
      SUBROUTINE watsub(I,J,NHW,NHE,NVN,NVS)
C
C     THIS SUBROUTINE CACULATES ENERGY BALANCES OF SNOW, RESIDUE
C     AND SOIL SURFACES, FREEZING, THAWING, AND HEAT AND WATER
C     TRANSFER THROUGH SOIL PROFILES
C
      include "parameters.h"
      include "blkc.h"
      include "blk2a.h"
      include "blk2b.h"
      include "blk2c.h"
      include "blk5.h"
      include "blk8a.h"
      include "blk8b.h"
      include "blk10.h"
      include "blk11a.h"
      include "blk11b.h"
      include "blk13a.h"
      include "blk13b.h"
      include "blk13c.h"
      include "blk15a.h"
      include "blk15b.h"
      include "blk22a.h"
      include "blk22b.h"
      include "blk22c.h"
      DIMENSION PHOL(JZ,JY,JX),DHOL(JZ,JY,JX),VOLWX1(JZ,JY,JX)
     2,TVOL1(JY,JX),TVOLW(JY,JX),FMAC(JZ,JY,JX),FGRD(JZ,JY,JX) 
     3,VOLW1(0:JZ,JY,JX),VOLI1(0:JZ,JY,JX),VOLPX1(JZ,JY,JX) 
     4,VHCP1(JZ,JY,JX),TK1(0:JZ,JY,JX),TWFLXL(JZ,JY,JX),TTFLXL(JZ,JY,JX)
     5,VOLP1(0:JZ,JY,JX),WGSG1(JZ,JY,JX),TWFLXH(JZ,JY,JX) 
     6,VOLS0(JY,JX),VOLI0(JY,JX),VOLW0(JY,JX),VOLS1(JY,JX)
     7,DPTHS0(JY,JX),VHCP0(JY,JX),TK0(JY,JX),AREAU(JZ,JY,JX) 
     8,FLQ0S(JY,JX),FLQ0W(JY,JX),FLQ1(JY,JX),FLH1(JY,JX) 
     9,FLY1(JY,JX),HWFLQ0(JY,JX),HWFLQ1(JY,JX),HWFLY1(JY,JX)
     1,RAR(JY,JX),RAGS(JY,JX),WGSG0(JY,JX),WRP(0:JZ,JY,JX)
     2,RAGR(JY,JX),RAGW(JY,JX),BARE(JY,JX),CVRD(JY,JX),PAREG(JY,JX) 
     3,RAG(JY,JX),PARSG(JY,JX),PARER(JY,JX),PARSR(JY,JX),WGSGR0(JY,JX) 
     4,VPQ(JY,JX),TKQ(JY,JX),VHCPR1(JY,JX),QR1(2,JV,JH),HQR1(2,JV,JH)
     5,QS1(2,JV,JH),QW1(2,JV,JH),QI1(2,JV,JH),HQS1(2,JV,JH)
     6,TQR1(JY,JX),THQR1(JY,JX),TQS1(JY,JX),TQW1(JY,JX)
     7,TQI1(JY,JX),THQS1(JY,JX),EVAP(JY,JX),DENSS(JY,JX)
     8,EVAPS(JY,JX),EVAPR(JY,JX),TFLX0(JY,JX),WFLXA(JY,JX),WFLXB(JY,JX)
     9,FLW0L(JY,JX),FLW0S(JY,JX),HFLW0L(JY,JX),RFLWV(JY,JX),FLWRL(JY,JX)
     1,HFLWRL(JY,JX),FINHL(JZ,JY,JX),FLWVL(JZ,JY,JX),FLWL(3,JD,JV,JH)
      DIMENSION FLWHL(3,JD,JV,JH),HFLWL(3,JD,JV,JH),AVCNHL(3,JD,JV,JH)
     2,TFLWL(JZ,JY,JX),TFLWHL(JZ,JY,JX),THFLWL(JZ,JY,JX),PSISE1(JZ)
     3,WFLXL(3,JZ,JY,JX),TFLXL(3,JZ,JY,JX),FLWZ1(JY,JX),FLWS1(JY,JX)
     4,FLWI1(JY,JX),FLSI1(JY,JX),HFLWZ1(JY,JX),HFLSI1(JY,JX)
     5,THRYW(JY,JX),THRMW(JY,JX),THRMS(JY,JX),THRMR(JY,JX)
     6,THRYG(JY,JX),THRYR(JY,JX),RADXW(JY,JX),RADXG(JY,JX)
     7,RADXR(JY,JX),FLWLX(3,JD,JV,JH),TFLWLX(JZ,JY,JX) 
     8,FLU1(JZ,JY,JX),HWFLU1(JZ,JY,JX),PSISM1(0:JZ,JY,JX)
     9,RCHQN1(JY,JX),RCHQE1(JY,JX),RCHQS1(JY,JX),RCHQW1(JY,JX)
     1,RCHGNU1(JY,JX),RCHGEU1(JY,JX),RCHGSU1(JY,JX),RCHGWU1(JY,JX)
     2,RCHGNT1(JY,JX),RCHGET1(JY,JX),RCHGST1(JY,JX),RCHGWT1(JY,JX)
     3,RCHGD1(JY,JX),CMAN(JY,JX) 
     4,ALTG(JY,JX),TKWX(JY,JX),TKSX(JY,JX),TKRX(JY,JX)
     5,WFLXLH(3,JZ,JY,JX),DLYRR(JY,JX),WFLXR(JY,JX)
     6,TFLXR(JY,JX),HCNDR(JY,JX),CNDH1(JZ,JY,JX) 
     7,THETWX(0:JZ,JY,JX),THETIX(0:JZ,JY,JX),THETPX(0:JZ,JY,JX)
     8,VOLAH1(JZ,JY,JX),VOLWH1(JZ,JY,JX),VOLPH1(JZ,JY,JX)
     9,VOLIH1(JZ,JY,JX) 
      PARAMETER (RACX=0.0278,THETPI=0.01,EMMS=0.98,EMMW=0.98
     2,EMMR=0.98,RZ=0.0278,RZR=0.0278,RZW=0.0278,HCNDRR=25.0
     3,RAM=1.39E-03,THETPZ=0.01,THETWZ=1.0-THETPZ,HYSTK=1.00
     4,FQS=8.0E-01)
      PARAMETER (Z1S=0.0175,Z2SW=12.0,Z2SD=12.0,Z3SX=0.50
     2,Z1R=0.0175,Z2RW=3.0,Z2RD=12.0,Z3R=0.50)
      PARAMETER (VISCQ=1.18E-06,VISCA=1.44E-05,DIFFQ=1.45E-07
     2,DIFFA=2.01E-05,EXPNQ=207.0E-06,EXPNA=3.66E-03,GRAV=9.8
     3,RYLXQ=GRAV*EXPNQ/(VISCQ*DIFFQ),RYLXA=GRAV*EXPNA/(VISCA*DIFFA)
     4,PRNTQ=VISCQ/DIFFQ,PRNTA=VISCA/DIFFA,TTRB=0.375
     5,DNUSQ=(1.0+(0.492/PRNTQ)**0.5625)**0.4444
     6,DNUSA=(1.0+(0.492/PRNTA)**0.5625)**0.4444)
      PARAMETER (NPR=10,XNPR=1.0/NPR,FHFLX=0.67,OVOLPH=1.00
     2,FRAR=0.50,FVOLAH=0.0,PSISX=-0.5,PSISXR=-0.5,HYGR=-250.0
     3,DTHETW=1.0E-06)
      REAL*4 RI,THETWR,THETW1,THETA1,THETAL,THETWL
     2,TKR2,TKS1,TKY,TKW1,TK11,TK12,TK0X,TKXR,TK1X,TKX1,TFND1
      FQSM=FQS*XNPH
      DO 9995 NX=NHW,NHE
      DO 9990 NY=NVN,NVS
C
C     SET INTERNAL TIME STEPS FROM CYCLES PER HOUR ENTERED IN 'READS'
C     XNPH = INTERNAL TIME STEP FOR SNOWPACK, SOIL PROFILE
C     XNPR = INTERNAL TIME STEP FOR SURFACE RESIDUE
C
      XNPHR=XNPH*XNPR
      HYSTX=HYSTK
C
C     ADJUST SURFACE ELEVATION USED IN RUNOFF FOR EROSION 
C
      ALTG(NY,NX)=ALT(NY,NX)-CDPTH(NU(NY,NX),NY,NX)
     2+DLYR(3,NU(NY,NX),NY,NX)
C
C     SET BOUNDARY CONDITIONS TO FUNCTION AT INTERNAL TIME STEP
C
      RCHQN1(NY,NX)=1.0-(1.0-RCHQN(NY,NX))
      RCHQE1(NY,NX)=1.0-(1.0-RCHQE(NY,NX))
      RCHQS1(NY,NX)=1.0-(1.0-RCHQS(NY,NX))
      RCHQW1(NY,NX)=1.0-(1.0-RCHQW(NY,NX))
      IF(IPRC(NY,NX).EQ.0)THEN
      RCHGNU1(NY,NX)=0.0
      RCHGEU1(NY,NX)=0.0
      RCHGSU1(NY,NX)=0.0
      RCHGWU1(NY,NX)=0.0
      ELSE
      RCHGNU1(NY,NX)=RCHGNU(NY,NX)
      RCHGEU1(NY,NX)=RCHGEU(NY,NX)
      RCHGSU1(NY,NX)=RCHGSU(NY,NX)
      RCHGWU1(NY,NX)=RCHGWU(NY,NX)
      ENDIF
      RCHGNT1(NY,NX)=1.0-(1.0-RCHGNT(NY,NX))
      RCHGET1(NY,NX)=1.0-(1.0-RCHGET(NY,NX))
      RCHGST1(NY,NX)=1.0-(1.0-RCHGST(NY,NX))
      RCHGWT1(NY,NX)=1.0-(1.0-RCHGWT(NY,NX))
      IF(THETW(NL(NY,NX),NY,NX).GT.FC(NL(NY,NX),NY,NX))THEN
      RCHGD1(NY,NX)=1.0-(1.0-RCHGD(NY,NX))
      ELSE
      RCHGD1(NY,NX)=1.0-(1.0-RCHGU(NY,NX))
      ENDIF
C
C     ENTER STATE VARIABLES AND DRIVERS INTO LOCAL ARRAYS
C     FOR USE AT INTERNAL TIME STEP
C
      VOLS0(NY,NX)=VOLSS(NY,NX)
      VOLI0(NY,NX)=VOLIS(NY,NX)
      VOLW0(NY,NX)=VOLWS(NY,NX)
      VOLS1(NY,NX)=VOLS(NY,NX)
      DPTHS0(NY,NX)=DPTHS(NY,NX)
      VHCP0(NY,NX)=VHCPW(NY,NX)
      TK0(NY,NX)=TKW(NY,NX)
      WFLXR(NY,NX)=0.0
      TFLXR(NY,NX)=0.0
      CMAN(NY,NX)=0.03*NPH
      TKWX(NY,NX)=TKW(NY,NX)
      TKSX(NY,NX)=TKS(NU(NY,NX),NY,NX)
      TKRX(NY,NX)=TKS(0,NY,NX)
      DO 65 L=NU(NY,NX),NL(NY,NX)
      IF(CDPTH(L,NY,NX).GE.WDPTH(I,NY,NX))THEN
      LWDPTH=L
      GO TO 55
      ENDIF
65    CONTINUE
55    CONTINUE
C
C     SET INITIAL SOIL VALUES
C
      DO 30 L=NU(NY,NX),NL(NY,NX)
C
C     ENTER STATE VARIABLES AND DRIVERS INTO LOCAL ARRAYS
C     FOR USE AT INTERNAL TIME STEP
C
      PSISM1(L,NY,NX)=PSISM(L,NY,NX)
      VOLW1(L,NY,NX)=VOLW(L,NY,NX)
      VOLWX1(L,NY,NX)=VOLWX(L,NY,NX)
      VOLI1(L,NY,NX)=VOLI(L,NY,NX) 
      VOLWH1(L,NY,NX)=VOLWH(L,NY,NX)
      VOLIH1(L,NY,NX)=VOLIH(L,NY,NX)
      VOLP1(L,NY,NX)=AMAX1(0.0,VOLA(L,NY,NX)-VOLW1(L,NY,NX)
     2-VOLI1(L,NY,NX))
      VOLAH1(L,NY,NX)=AMAX1(0.0,VOLAH(L,NY,NX)-FVOLAH*CCLAY(L,NY,NX)
     2*(VOLW1(L,NY,NX)/VOLX(L,NY,NX)-WP(L,NY,NX))*VOLT(L,NY,NX))
      VOLPH1(L,NY,NX)=AMAX1(0.0,VOLAH1(L,NY,NX)-VOLWH1(L,NY,NX)
     2-VOLIH1(L,NY,NX))
      VOLPX1(L,NY,NX)=VOLP1(L,NY,NX)*HYST(L,NY,NX)
      VOLWM(1,L,NY,NX)=VOLW1(L,NY,NX)
      VOLWHM(1,L,NY,NX)=VOLWH1(L,NY,NX)
      VOLPM(1,L,NY,NX)=VOLP1(L,NY,NX)+VOLPH1(L,NY,NX)
     2+THETPI*(VOLI1(L,NY,NX)+VOLIH1(L,NY,NX))
      THETWX(L,NY,NX)=AMAX1(0.0,(VOLW1(L,NY,NX)+VOLWH1(L,NY,NX))
     2/VOLT(L,NY,NX))
      THETIX(L,NY,NX)=AMAX1(0.0,(VOLI1(L,NY,NX)+VOLIH1(L,NY,NX))
     2/VOLT(L,NY,NX))
      THETPX(L,NY,NX)=AMAX1(0.0,(VOLP1(L,NY,NX)+VOLPH1(L,NY,NX))
     2/VOLT(L,NY,NX))
      THETPM(1,L,NY,NX)=THETPX(L,NY,NX)
      VHCP1(L,NY,NX)=VHCM(L,NY,NX)+4.19*(VOLW1(L,NY,NX)
     2+VOLWH1(L,NY,NX))+1.9274*(VOLI1(L,NY,NX)+VOLIH1(L,NY,NX))
C
C     MACROPOROSITY
C
      DHOL(L,NY,NX)=DLYR(3,L,NY,NX)*NHOL(L,NY,NX)
      IF(NHOL(L,NY,NX).GT.0)THEN
      PHOL(L,NY,NX)=1.0/(SQRT(3.1416*DHOL(L,NY,NX)))
      ELSE
      PHOL(L,NY,NX)=1.0
      ENDIF
      IF(VOLAH(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FMAC(L,NY,NX)=FHOL(L,NY,NX)*VOLAH1(L,NY,NX)/VOLAH(L,NY,NX)
      CNDH1(L,NY,NX)=XNPH*NHOL(L,NY,NX)*CNDH(L,NY,NX) 
     2*(VOLAH1(L,NY,NX)/VOLAH(L,NY,NX))**2
      ELSE
      FMAC(L,NY,NX)=0.0
      CNDH1(L,NY,NX)=0.0
      ENDIF
      FGRD(L,NY,NX)=1.0-FMAC(L,NY,NX)
      TK1(L,NY,NX)=TKS(L,NY,NX)
      IF(L.EQ.LWDPTH)THEN
      FLU(L,NY,NX)=PRECU(NY,NX)
      HWFLU(L,NY,NX)=4.19*TKA(NY,NX)*PRECU(NY,NX)
      FLU1(L,NY,NX)=FLU(L,NY,NX)*XNPH
      HWFLU1(L,NY,NX)=HWFLU(L,NY,NX)*XNPH
      ELSE
      FLU(L,NY,NX)=0.0
      HWFLU(L,NY,NX)=0.0
      FLU1(L,NY,NX)=0.0
      HWFLU1(L,NY,NX)=0.0
      ENDIF
      IF(CDPTH(L,NY,NX).GE.DTBLX(NY,NX))THEN
      AREAU(L,NY,NX)=AMIN1(1.0,AMAX1(0.0
     2,(CDPTH(L,NY,NX)-DTBLX(NY,NX))
     2/DLYR(3,L,NY,NX)))
      ELSE
      AREAU(L,NY,NX)=0.0
      ENDIF
30    CONTINUE
C
C     ENTER STATE VARIABLES AND DRIVERS INTO LOCAL ARRAYS
C     FOR USE AT INTERNAL TIME STEP
C
      THRMG(NY,NX)=0.0
      FLQGM(NY,NX)=0.0
C
C     INITIALIZE SNOW AND SOIL-RESIDUE THERMAL CONDUCTIVITIES
C
      VHCPR1(NY,NX)=2.496E-06*ORGC(0,NY,NX)+4.19*VOLW(0,NY,NX)
     2+1.9274*VOLI(0,NY,NX)
      VOLW1(0,NY,NX)=AMAX1(0.0,VOLW(0,NY,NX))
      VOLI1(0,NY,NX)=AMAX1(0.0,VOLI(0,NY,NX))
      VOLP1(0,NY,NX)=AMAX1(0.0,VOLA(0,NY,NX)-VOLW1(0,NY,NX)
     2-VOLI1(0,NY,NX))
      VOLWM(1,0,NY,NX)=VOLW1(0,NY,NX)
      VOLPM(1,0,NY,NX)=VOLP1(0,NY,NX)
      TVOL1(NY,NX)=AMAX1(0.0,VOLW1(0,NY,NX)+VOLI1(0,NY,NX)
     2-VOLWRX(NY,NX))
      TVOLW(NY,NX)=AMAX1(0.0,VOLW1(0,NY,NX)-VOLWRX(NY,NX))
      VOLGM(1,NY,NX)=AMAX1(0.0,TVOL1(NY,NX))
      THETWX(0,NY,NX)=AMAX1(0.0,VOLW1(0,NY,NX)/VOLT(0,NY,NX))
      THETIX(0,NY,NX)=AMAX1(0.0,VOLI1(0,NY,NX)/VOLT(0,NY,NX))
      THETPX(0,NY,NX)=AMAX1(0.0,VOLP1(0,NY,NX)/VOLT(0,NY,NX))
      THETPM(1,0,NY,NX)=THETPX(0,NY,NX)
      PSISM1(0,NY,NX)=PSISM(0,NY,NX)
      TK1(0,NY,NX)=TKS(0,NY,NX)
C
C     RESIDUE COVERAGE OF SOIL SURFACE
C
      IF(BKDS(NU(NY,NX),NY,NX).GT.ZERO)THEN
      BARE(NY,NX)=AMAX1(0.0,EXP(-0.8E-02*(TRC0(NY,NX)/AREA(3,0,NY,NX)))
     2-AMIN1(1.0,TVOLW(NY,NX)/VOLWG(NY,NX)))
      ELSE
      BARE(NY,NX)=0.0
      ENDIF
      CVRD(NY,NX)=1.0-BARE(NY,NX)
      PRECD(NY,NX)=PRECA(NY,NX)*FRADG(NY,NX)*BARE(NY,NX)
      PRECB(NY,NX)=(PRECA(NY,NX)-PRECD(NY,NX)-TFLWC(NY,NX))*BARE(NY,NX)
C
C     VARIABLES TO TRANSFER SNOWPACK INTO SOIL SURFACE AT FINAL MELT
C
      IF(VHCPW(NY,NX).LE.VHCPWX(NY,NX).AND.DPTHS(NY,NX).GT.0.0
     2.AND.TCS(NU(NY,NX),NY,NX).GT.0.0)THEN
      FLWZ=VOLWS(NY,NX)
      FLWS=VOLSS(NY,NX)/0.92
      FLWI=VOLIS(NY,NX)
      HFLWZ=4.19*VOLWS(NY,NX)*TKW(NY,NX)
      FLWSI(NY,NX)=FLWS+FLWI
      HFLWSI(NY,NX)=1.9274*(FLWS+FLWI)*TKW(NY,NX)
      WDISP=VOLWS(NY,NX)+VOLSS(NY,NX)+VOLIS(NY,NX)*0.92
      ELSE
      FLWZ=0.0
      FLWS=0.0
      FLWI=0.0
      HFLWZ=0.0
      FLWSI(NY,NX)=0.0
      HFLWSI(NY,NX)=0.0
      WDISP=0.0
      ENDIF
C
C     RESIDUE WATER ABSORPTION CAPACITY
C
      HCNDRX=HCNDRR*CVRD(NY,NX)
      HCNDR(NY,NX)=HCNDRX*XNPH 
      DLYRR(NY,NX)=AMIN1(5.0E-02,AMAX1(1.0E-06,DLYR(3,0,NY,NX)))
C
C     DISCHARGE OF MELTWATER AND ITS HEAT FROM SNOWPACK
C     TO RESIDUE, SOIL SURFACE AND MACROPORES
C
      IF(VHCPW(NY,NX).GT.VHCPWX(NY,NX))THEN
      WMELT=AMAX1(0.0,AMAX1(0.0,VOLWS(NY,NX))
     2-0.05*AMAX1(0.0,VOLSS(NY,NX)))
      FLWQR=WMELT*CVRD(NY,NX) 
      HFLWQR=4.19*TKW(NY,NX)*FLWQR
      FLWQG=WMELT-FLWQR
      HFLWQG=4.19*TKW(NY,NX)*FLWQG
      FLWQGS=FLWQG*FGRD(NU(NY,NX),NY,NX)
      FLWQGH=FLWQG*FMAC(NU(NY,NX),NY,NX)
      ELSE
      WMELT=0.0
      FLWQR=0.0
      HFLWQR=0.0
      FLWQG=0.0
      HFLWQG=0.0
      FLWQGS=0.0
      FLWQGH=0.0
      ENDIF
      FLQRM(NY,NX)=FLWQR
      FLQGM(NY,NX)=FLWQG+WDISP 
C
C     DISTRIBUTION OF PRECIPITATION AND ITS HEAT AMONG SURFACE
C     RESIDUE, SOIL SURFACE, AND MACROPORES
C
      IF(PRECA(NY,NX).GT.0.0.OR.PRECW(NY,NX).GT.0.0)THEN
      IF(VHCPW(NY,NX).GT.VHCPWX(NY,NX))THEN
      FLWQW=PRECA(NY,NX)-TFLWC(NY,NX)
      FLWSW=PRECW(NY,NX)
      HFLWSW=2.095*TKA(NY,NX)*FLWSW+4.19*TKA(NY,NX)*FLWQW
      FLWQBX=0.0
      HFLWQB=0.0
      FLWQAX=0.0
      HFLWQA=0.0
      FLWQAS=0.0
      FLWQAH=0.0
      ELSE
      FLWQW=0.0
      FLWSW=PRECW(NY,NX)
      HFLWSW=2.095*TKA(NY,NX)*FLWSW
      FLWQBX=(PRECA(NY,NX)-TFLWC(NY,NX))*CVRD(NY,NX) 
      HFLWQB=4.19*TKA(NY,NX)*FLWQBX
      FLWQAX=PRECA(NY,NX)-TFLWC(NY,NX)-FLWQBX
      HFLWQA=4.19*TKA(NY,NX)*FLWQAX
      FLWQAS=FLWQAX*FGRD(NU(NY,NX),NY,NX)
      FLWQAH=FLWQAX*FMAC(NU(NY,NX),NY,NX)
      ENDIF
      ELSE
      IF(VHCPW(NY,NX).GT.VHCPWX(NY,NX))THEN
      FLWQW=-TFLWC(NY,NX)
      FLWSW=0.0
      HFLWSW=4.19*TKA(NY,NX)*FLWQW
      FLWQBX=0.0
      HFLWQB=0.0
      FLWQAX=0.0
      HFLWQA=0.0
      FLWQAS=0.0
      FLWQAH=0.0
      ELSE
      FLWQW=0.0
      FLWSW=0.0
      HFLWSW=0.0
      FLWQBX=-TFLWC(NY,NX)*CVRD(NY,NX) 
      HFLWQB=4.19*TKA(NY,NX)*FLWQBX
      FLWQAX=-TFLWC(NY,NX)-FLWQBX 
      HFLWQA=4.19*TKA(NY,NX)*FLWQAX
      FLWQAS=FLWQAX*FGRD(NU(NY,NX),NY,NX)
      FLWQAH=FLWQAX*FMAC(NU(NY,NX),NY,NX)
      ENDIF
      ENDIF
C
C     PRECIP ON SNOW
C
      IF(PRECW(NY,NX).GT.0.0.OR.(PRECR(NY,NX).GT.0.0
     2.AND.VHCPW(NY,NX).GT.VHCPWX(NY,NX)))THEN
      FLQRQ(NY,NX)=0.0
      FLQRI(NY,NX)=0.0
      FLQGQ(NY,NX)=PRECQ(NY,NX)
      FLQGI(NY,NX)=PRECI(NY,NX)
      ELSEIF((PRECQ(NY,NX).GT.0.0.OR.PRECI(NY,NX).GT.0.0)
     2.AND.VHCPW(NY,NX).LE.VHCPWX(NY,NX))THEN
      FLQRQ(NY,NX)=FLWQBX*PRECQ(NY,NX)/(PRECQ(NY,NX)+PRECI(NY,NX))
      FLQRI(NY,NX)=FLWQBX*PRECI(NY,NX)/(PRECQ(NY,NX)+PRECI(NY,NX))
      FLQGQ(NY,NX)=PRECQ(NY,NX)-FLQRQ(NY,NX)
      FLQGI(NY,NX)=PRECI(NY,NX)-FLQRI(NY,NX)
      ELSE
      FLQRQ(NY,NX)=0.0
      FLQRI(NY,NX)=0.0
      FLQGQ(NY,NX)=0.0
      FLQGI(NY,NX)=0.0
      ENDIF
C
C     GATHER PRECIPITATION AND MELTWATER FLUXES AND THEIR HEATS
C     AMONG ATMOSPHERE, SNOWPACK, RESIDUE AND SOIL SURFACES
C     INTO LOCAL ARRAYS FOR USE IN MASS AND ENERGY EXCHANGE
C     ALGORITHMS
C
      FLQ0W(NY,NX)=(FLWQW-FLWQR-FLWQGS-FLWQGH)*XNPH
      FLQ0S(NY,NX)=FLWSW*XNPH
      HWFLQ0(NY,NX)=(HFLWSW-HFLWQG-HFLWQR)*XNPH
      FLQ1(NY,NX)=(FLWQAS+FLWQGS+FLWZ)*XNPH
      FLH1(NY,NX)=(FLWQAH+FLWQGH)*XNPH
      FLY1(NY,NX)=(FLWQBX+FLWQR)*XNPH
      HWFLQ1(NY,NX)=(HFLWQA+HFLWQG+HFLWZ)*XNPH
      HWFLY1(NY,NX)=(HFLWQB+HFLWQR)*XNPH
      FLWZ1(NY,NX)=FLWZ*XNPH
      FLWS1(NY,NX)=FLWS*0.92*XNPH
      FLWI1(NY,NX)=FLWI*XNPH
      HFLWZ1(NY,NX)=HFLWZ*XNPH
      FLSI1(NY,NX)=FLWSI(NY,NX)*XNPH
      HFLSI1(NY,NX)=HFLWSI(NY,NX)*XNPH
      RFLWV(NY,NX)=1.0E-02*XNPH
C     IF(I.EQ.118.AND.NX.EQ.3.AND.NY.EQ.4)THEN
C     WRITE(*,4422)'FLQ0W',I,J,FLQ0W(NY,NX),FLWQW
C    2,FLWQR,FLWQGS,FLWQGH,XNPH
C     WRITE(*,4422)'FLY',I,J,PRECA(NY,NX),TFLWC(NY,NX),FLY1(NY,NX)
C    2,PSISM1(0,NY,NX),PSISM(0,NY,NX)
C    2,FLQ1(NY,NX),FLH1(NY,NX),FLWQBX,FLWQR 
C    2,FLWQAS,FLWQGS,FLWZ,FLWQAH,FLWQGH
C    3,FGRD(NU(NY,NX),NY,NX),FMAC(NU(NY,NX),NY,NX)
C    4,FHOL(L,NY,NX),VOLAH1(L,NY,NX),VOLAH(L,NY,NX)
4422  FORMAT(A8,2I4,30E12.4)
C     ENDIF
C
C     INITIALIZE PARAMETERS, FLUXES FOR ENERGY EXCHANGE
C     AT SNOW, RESIDUE AND SOIL SURFACES
C
      RADXW(NY,NX)=RADG(NY,NX)*XNPH
      RADXG(NY,NX)=RADXW(NY,NX)*BARE(NY,NX)
      RADXR(NY,NX)=RADXW(NY,NX)*CVRD(NY,NX)*XNPR
      THRYW(NY,NX)=(THS(NY,NX)*FRADG(NY,NX)+THRMCX(NY,NX))*XNPH
      THRYG(NY,NX)=THRYW(NY,NX)*BARE(NY,NX)
      THRYR(NY,NX)=THRYW(NY,NX)*CVRD(NY,NX)*XNPR
      THRMW(NY,NX)=EMMW*2.04E-10*AREA(3,NU(NY,NX),NY,NX)*XNPH
      THRMS(NY,NX)=EMMS*2.04E-10*AREA(3,NU(NY,NX),NY,NX)*XNPH
     2*BARE(NY,NX)
      THRMR(NY,NX)=EMMR*2.04E-10*AREA(3,NU(NY,NX),NY,NX)*XNPHR
     2*CVRD(NY,NX)
C
C     AERODYNAMIC RESISTANCE OF CANOPY TO SNOW/RESIDUE/SOIL
C     SURFACE ENERGY EXCHANGE WITH ATMOSPHERE
C
      ALFZ=2.0*(1.0-FRADG(NY,NX))
      IF(RAB(NY,NX).GT.ZERO.AND.ZT(NY,NX).GT.ZS(NY,NX)
     2.AND.ALFZ.GT.ZERO)THEN
      RAC(NY,NX)=AMIN1(RACX,AMAX1(0.0,ZT(NY,NX)*EXP(ALFZ)
     2/(ALFZ/RAB(NY,NX))*AMAX1(0.0,EXP(-ALFZ*ZS(NY,NX)/ZT(NY,NX))
     3-EXP(-ALFZ*(ZD(NY,NX)+ZR(NY,NX))/ZT(NY,NX)))))
      UAG=UA(NY,NX)*EXP(-ALFZ)
      ELSE
      RAC(NY,NX)=0.0
      UAG=UA(NY,NX)
      ENDIF
      VPQ(NY,NX)=VPA(NY,NX)-1.0*TLEX(NY,NX)
     2/(VAP*AREA(3,NU(NY,NX),NY,NX)) 
      TKQ(NY,NX)=TKA(NY,NX)-1.0*TSHX(NY,NX)
     2/(1.25E-03*AREA(3,NU(NY,NX),NY,NX))
C
C     AERODYNAMIC RESISTANCE OF RESIDUE TO SOIL
C     SURFACE ENERGY EXCHANGE WITH ATMOSPHERE
C     Soil Sci. Soc. Am. J. 48:25-32
C
      WGSG0(NY,NX)=WGSGW(NY,NX)*XNPH
      WGSGR0(NY,NX)=WGSGR(NY,NX)*XNPH
      DO 25 L=NU(NY,NX),NL(NY,NX)
      IF(POROS(L,NY,NX).GT.0.0)THEN
      WFPS=THETW(L,NY,NX)/POROS(L,NY,NX)
      ELSE
      WFPS=1.0
      ENDIF
      FWGWP=AMAX1(1.0,10.0-50.0*WP(L,NY,NX))
      FWGSG=9.5+2.0*WFPS-8.5*EXP(-((FWGWP*WFPS)**3))
      WGSG1(L,NY,NX)=FWGSG*WGSGL(L,NY,NX)*XNPH 
25    CONTINUE
      RAR(NY,NX)=DLYRR(NY,NX)/WGSGR(NY,NX) 
      RAR1=RAR(NY,NX)/AMAX1(0.1,THETPX(0,NY,NX))**2.33
      RAG(NY,NX)=RAC(NY,NX)+RAB(NY,NX)
      RAGW(NY,NX)=RAG(NY,NX) 
      RAGS(NY,NX)=RAG(NY,NX)+RAR1
      RAGR(NY,NX)=RAG(NY,NX)+RAR1*FRAR 
      PARG(NY,NX)=AREA(3,NU(NY,NX),NY,NX)*XNPH/RAGS(NY,NX)
      PARR(NY,NX)=AREA(3,NU(NY,NX),NY,NX)*XNPH/RAGR(NY,NX)
      PAREG(NY,NX)=AREA(3,NU(NY,NX),NY,NX)*XNPH
      PARER(NY,NX)=PAREG(NY,NX)*XNPR*CVRD(NY,NX)
      PARSG(NY,NX)=1.25E-03*AREA(3,NU(NY,NX),NY,NX)*XNPH
      PARSR(NY,NX)=PARSG(NY,NX)*XNPR*CVRD(NY,NX)
C     IF(I.EQ.287)THEN
C     WRITE(*,3111)'RAC',I,J,ALFZ,RAC(NY,NX),ZT(NY,NX),RAB(NY,NX)
C    2,RAR(NY,NX),RAR1,RAR1*FRAR,PARG(NY,NX),PARR(NY,NX)
C    3,DLYRR(NY,NX),RAG(NY,NX),RAGS(NY,NX),RAGR(NY,NX)
C    4,THETPX(0,NY,NX),WGSGR(NY,NX)
C    4,TLEX(NY,NX),TSHX(NY,NX),RADG(NY,NX),THS(NY,NX)
C    5,FRADG(NY,NX),THRMCX(NY,NX),ZS(NY,NX)
3111  FORMAT(A8,2I4,30E12.4)
C     ENDIF
9990  CONTINUE
9995  CONTINUE
C
C     INITIALIZE SOIL HYDRAULIC PARAMETERS IN LOCAL ARRAYS
C     FOR LATER USE IN WATER TRANSFER ALGORITHMS
C
      DO 9985 NX=NHW,NHE
      DO 9980 NY=NVN,NVS
      DO 35 L=NU(NY,NX),NL(NY,NX)
      DO 40 N=NCN(NY,NX),3
      TFLXL(N,L,NY,NX)=0.0
      WFLXL(N,L,NY,NX)=0.0
      WFLXLH(N,L,NY,NX)=0.0
      N1=NX
      N2=NY
      N3=L
      IF(N.EQ.1)THEN
      IF(NX.EQ.NHE)THEN
      GO TO 50
      ELSE
      N4=NX+1
      N5=NY
      N6=L
      ENDIF
      ELSEIF(N.EQ.2)THEN
      IF(NY.EQ.NVS)THEN
      GO TO 50
      ELSE
      N4=NX
      N5=NY+1
      N6=L
      ENDIF
      ELSEIF(N.EQ.3)THEN
      IF(L.EQ.NL(NY,NX))THEN
      GO TO 50
      ELSE
      N4=NX
      N5=NY
      N6=L+1
      ENDIF
      ENDIF
C
C     MACROPORE CONDUCTIVITY FROM 'HOUR1' AND GRAVITATIONAL
C     GRADIENT USED TO CALCULATE MACROPORE FLOW FOR USE BELOW
C
      IF(CNDH1(N3,N2,N1).GT.ZERO.AND.CNDH1(N6,N5,N4)
     2.GT.ZERO)THEN
      AVCNHL(N,N6,N5,N4)=2.0*CNDH1(N3,N2,N1)*CNDH1(N6,N5,N4) 
     2/(CNDH1(N3,N2,N1)*DLYR(N,N6,N5,N4)+CNDH1(N6,N5,N4) 
     3*DLYR(N,N3,N2,N1)) 
      ELSE
      AVCNHL(N,N6,N5,N4)=0.0
      ENDIF
50    CONTINUE
40    CONTINUE
35    CONTINUE
9980  CONTINUE
9985  CONTINUE
C
C     DYNAMIC LOOP FOR FLUX CALCULATIONS
C
      DO 3320 M=1,NPH
      DO 9895 NX=NHW,NHE
      DO 9890 NY=NVN,NVS
      TQR1(NY,NX)=0.0
      THQR1(NY,NX)=0.0
      TQS1(NY,NX)=0.0
      TQW1(NY,NX)=0.0
      TQI1(NY,NX)=0.0
      THQS1(NY,NX)=0.0
C
C     WATER REPELLENCY AND GAS EXCHANGE COEFFICIENTS
C
      WRP(0,NY,NX)=1.0/(1.0+(AMAX1(-1.5
     2,PSISM1(0,NY,NX))/PSISXR)**3)
      IF(VOLA(0,NY,NX).GT.VOLI1(0,NY,NX)
     2.AND.VOLW1(0,NY,NX).GT.ZEROS(NY,NX))THEN
      THETWA=AMIN1(1.0,VOLW1(0,NY,NX)/(VOLA(0,NY,NX)-VOLI1(0,NY,NX)))
      TFND1=(TK1(0,NY,NX)/298.15)**6
      IF(THETWA.GT.Z3R)THEN
      DFGS(M,0,NY,NX)=AMAX1(0.0
     2,TFND1*XNPD/((Z1R**-1)*EXP(Z2RW*(THETWA-Z3R))))
      ELSE
      DFGS(M,0,NY,NX)=AMIN1(1.0
     2,TFND1*XNPD/((Z1R**-1)*EXP(Z2RD*(THETWA-Z3R))))
      ENDIF
      ELSE
      DFGS(M,0,NY,NX)=0.0
      ENDIF
      DO 9885 L=NU(NY,NX),NL(NY,NX)
      TWFLXL(L,NY,NX)=0.0
      TWFLXH(L,NY,NX)=0.0
      TTFLXL(L,NY,NX)=0.0
      TFLWL(L,NY,NX)=0.0
      TFLWLX(L,NY,NX)=0.0
      TFLWHL(L,NY,NX)=0.0
      THFLWL(L,NY,NX)=0.0
C
C     ARTIFICIAL SOIL WARMING
C
C     IF(L.EQ.5)THEN
C     THFLWL(L,NY,NX)=(1.8-3.0*AMIN1(0.30
C    2,AMAX1(0.0,DPTHS(NY,NX))**0.5))*VHCP(L,NY,NX)*XNPH
C     ENDIF
C
C     ARTIFICIAL SOIL WARMING
C
      WRP(L,NY,NX)=1.0/(1.0+(AMAX1(-1.5
     2,PSISM1(L,NY,NX))/PSISX)**3)
      VOLWT=VOLW1(L,NY,NX)+VOLWH1(L,NY,NX)
      VOLAT=VOLA(L,NY,NX)+VOLAH(L,NY,NX)
     2-VOLI1(L,NY,NX)-VOLIH1(L,NY,NX)
      IF(VOLWT.GT.ZEROS(NY,NX).AND.VOLAT.GT.ZEROS(NY,NX))THEN
      THETWA=VOLWT/VOLAT
      TFND1=(TK1(L,NY,NX)/298.15)**6
      Z3S=AMAX1(Z3SX,FC(L,NY,NX)/POROS(L,NY,NX))
      IF(THETWA.GT.Z3S)THEN 
      DFGS(M,L,NY,NX)=AMAX1(0.0
     2,TFND1*XNPD/((Z1S**-1)*EXP(Z2SW*(THETWA-Z3S)))) 
      ELSE
      DFGS(M,L,NY,NX)=AMIN1(1.0
     2,TFND1*XNPD/((Z1S**-1)*EXP(Z2SD*(THETWA-Z3S)))) 
      ENDIF
      ELSE
      DFGS(M,L,NY,NX)=0.0
      ENDIF
C     IF(L.EQ.NU(NY,NX))THEN
C     WRITE(*,3377)'DFGS',I,J,M,NX,NY,L,DFGS(M+1,L,NY,NX)
C    2,XNPD,TFACL,Z1S,Z2S,THETWA,Z3S,Z2S*(THETWA-Z3S)
C    3,EXP(Z2S*(THETWA-Z3S)),Z1S**-1
C    4,(Z1S**-1)*EXP(Z2S*(THETWA-Z3S))
9885  CONTINUE
C
C     REDISTRIBUTE INCOMING MELTWATER OR PRECIPITATION
C     BETWEEN RESIDUE AND SOIL SURFACE
C
      VOLWRM=AMAX1(0.0,VOLWRX(NY,NX)-VOLW1(0,NY,NX)-VOLI1(0,NY,NX))
      FLWR1=AMAX1(0.0,FLY1(NY,NX)-VOLWRM)
      HFLWR1=4.19*TKA(NY,NX)*FLWR1
      FLYM=FLY1(NY,NX)-FLWR1
      HWFLYM=HWFLY1(NY,NX)-HFLWR1
      FLQM=FLQ1(NY,NX)+FLWR1*FGRD(NU(NY,NX),NY,NX)
      FLHM=FLH1(NY,NX)+FLWR1*FMAC(NU(NY,NX),NY,NX)
      HWFLQM=HWFLQ1(NY,NX)+HFLWR1
C
C     REDISTRIBUTE SURFACE WATER FROM WATER REPELLANCY
C
C     FLWPR=FLYM*(1.0-WRP(0,NY,NX))
C     HFLWPR=4.19*TKA(NY,NX)*FLWPR
C     FLYM=FLYM-FLWPR
C     HWFLYM=HWFLYM-HFLWPR
C     FLQM=FLQM+FLWPR*FGRD(NU(NY,NX),NY,NX)
C     FLHM=FLHM+FLWPR*FMAC(NU(NY,NX),NY,NX)
C     HWFLQM=HWFLQM+HFLWPR
C     FLWP1=FLQM*(1.0-WRP(NU(NY,NX),NY,NX))
C     FLQM=FLQM-FLWP1
C     FLHM=FLHM+FLWP1
      FLYM2=FLYM*XNPR
      HWFLM2=HWFLYM*XNPR
C     WRITE(*,3132)'FLWR1',I,J,M,FLY1(NY,NX),FLQ1(NY,NX)
C    2,FLH1(NY,NX),FLYM,FLQM,FLHM,VOLWRM,FLWR1
C    3,FMAC(NU(NY,NX),NY,NX),FGRD(NU(NY,NX),NY,NX)
C    5,VOLAH(NU(NY,NX),NY,NX),FVOLAH,CCLAY(NU(NY,NX),NY,NX)
C    4,VOLW1(NU(NY,NX),NY,NX)/VOLX(NU(NY,NX),NY,NX)-WP(L,NY,NX)
C    2,VOLT(NU(NY,NX),NY,NX),VOLAH1(NU(NY,NX),NY,NX)
C    5,VOLWRX(NY,NX),VOLW1(0,NY,NX),VOLI1(0,NY,NX)
C    6,WRP(0,NY,NX),WRP(NU(NY,NX),NY,NX),PSISM1(0,NY,NX)
C    7,PSISM1(NU(NY,NX),NY,NX)
3132  FORMAT(A8,3I4,40E12.4)
C
C     ENERGY EXCHANGE AT SNOW SURFACE IF PRESENT
C
      IF(VHCP0(NY,NX).GT.VHCPWX(NY,NX))THEN
C
C     PHYSICAL AND HYDRAULIC PROPERTIES OF SNOWPACK INCLUDING
C     AIR AND WATER-FILLED POROSITY, WATER POTENTIAL OF UNDERLYING
C     SOIL SURFACE USED IN FLUX CALCULATIONS
C
      DENSS(NY,NX)=AMIN1(0.6,DENS0(NY,NX)+DENS1(NY,NX)*VOLS0(NY,NX)
     2/AREA(3,NU(NY,NX),NY,NX))
      VOLS1(NY,NX)=VOLS0(NY,NX)/DENSS(NY,NX)+VOLW0(NY,NX)+VOLI0(NY,NX)
      DPTHS0(NY,NX)=VOLS1(NY,NX)/AREA(3,NU(NY,NX),NY,NX)
      THETP0=AMAX1(THETPI,1.0-(VOLS0(NY,NX)+VOLI0(NY,NX)
     2+VOLW0(NY,NX))/VOLS1(NY,NX))
      THETW1=AMAX1(THETY(NU(NY,NX),NY,NX),AMIN1(POROS(NU(NY,NX),NY,NX)
     2,VOLW1(NU(NY,NX),NY,NX)/VOLX(NU(NY,NX),NY,NX)))
      IF(BKVL(NU(NY,NX),NY,NX).GT.0.0)THEN
      IF(THETW1.LT.FC(NU(NY,NX),NY,NX))THEN
      PSISM1(NU(NY,NX),NY,NX)=AMAX1(HYGR,-EXP(PSIMX(NY,NX)
     2+((FCL(NU(NY,NX),NY,NX)-LOG(THETW1))
     3/FCD(NU(NY,NX),NY,NX)*PSIMD(NY,NX))))
      ELSEIF(THETW1.LT.POROS(NU(NY,NX),NY,NX)-DTHETW)THEN 
      PSISM1(NU(NY,NX),NY,NX)=-EXP(PSIMS(NY,NX)
     2+(((PSL(NU(NY,NX),NY,NX)-LOG(THETW1))
     3/PSD(NU(NY,NX),NY,NX))**SRP(NU(NY,NX),NY,NX)*PSISD(NY,NX)))
      ELSE
      PSISM1(NU(NY,NX),NY,NX)=PSISE(NU(NY,NX),NY,NX)
      ENDIF
      ELSE
      PSISM1(NU(NY,NX),NY,NX)=PSISE(NU(NY,NX),NY,NX)
      ENDIF
      PSISV1=PSISM1(NU(NY,NX),NY,NX)+PSISO(NU(NY,NX),NY,NX)
C
C     SNOWPACK ALBEDO, NET RADIATION
C
      ALBW=(0.85*VOLS0(NY,NX)+0.30*VOLI0(NY,NX)+0.06*VOLW0(NY,NX))
     2/(VOLS0(NY,NX)+VOLI0(NY,NX)+VOLW0(NY,NX))
      FSNOW=AMIN1((DPTHS0(NY,NX)/0.07)**2,1.0)
      ALBG=FSNOW*ALBW+(1.0-FSNOW)*ALBS(NY,NX)
      RFLX1=(1.0-ALBG)*RADXW(NY,NX)+THRYW(NY,NX)
      THRMX=THRMW(NY,NX)*TKWX(NY,NX)**4
      RFLX=RFLX1-THRMX
C
C     AERODYNAMIC RESISTANCE ABOVE SNOWPACK INCLUDING
C     RESISTANCE IMPOSED BY PLANT CANOPY
C
      RI=AMAX1(-0.3,AMIN1(0.075,RIB(NY,NX)*(TKQ(NY,NX)-TKWX(NY,NX))))
      RAGX=AMAX1(RAM,0.75*RAGW(NY,NX),AMIN1(1.33*RAGW(NY,NX)
     2,RAG(NY,NX)/(1.0-10.0*RI)))
      RAGW(NY,NX)=RAGX
      RA=RAGX
C
C     PARAMETERS FOR CALCULATING LATENT AND SENSIBLE HEAT FLUXES
C
      PARE=PAREG(NY,NX)/(RA+RZW)
      PARS=PARSG(NY,NX)/RA
      TKW1=TKWX(NY,NX)
      TK11=TK1(NU(NY,NX),NY,NX)
      VP0=2.173E-03/TKW1
     2*0.61*EXP(5360.0*(3.661E-03-1.0/TKW1))
      VP1=2.173E-03/TK11
     2*0.61*EXP(5360.0*(3.661E-03-1.0/TK11))
     3*EXP(18.0*PSISV1/(8.3143*TK11))
      EVAPT=PARE*(VPQ(NY,NX)-VP0)
      EVAP(NY,NX)=AMAX1(EVAPT,-AMAX1(0.0,VOLW0(NY,NX)))
      EVAPX=AMIN1(0.0,EVAPT-EVAP(NY,NX))
      EVAPS(NY,NX)=AMAX1(EVAPX,-AMAX1(0.0,VOLS0(NY,NX)))
      EFLX=EVAP(NY,NX)*VAP+EVAPS(NY,NX)*(VAP+333.0)
      IF(EVAPT.LT.0.0)THEN
      VFLX=(EVAP(NY,NX)*4.19+EVAPS(NY,NX)*2.095)*TKWX(NY,NX)
      ELSE
      VFLX=(EVAP(NY,NX)*4.19+EVAPS(NY,NX)*2.095)*TKQ(NY,NX)
      ENDIF
C
C     SOLVE FOR SNOWPACK SURFACE TEMPERATURE AT WHICH ENERGY
C     BALANCE OCCURS, SOLVE LATENT, SENSIBLE AND STORAGE HEAT FLUXES
C
      TKWX(NY,NX)=(PARS*TKQ(NY,NX)+VHCP0(NY,NX)*TK0(NY,NX)+RFLX+EFLX
     2+HWFLQ0(NY,NX)+VFLX)/(PARS+VHCP0(NY,NX)+4.19*(FLQ0W(NY,NX)
     3+FLQ0S(NY,NX)+EVAP(NY,NX))+2.095*EVAPS(NY,NX))
      SFLX=PARS*(TKQ(NY,NX)-TKWX(NY,NX))
      HFLW0=RFLX+EFLX+SFLX+VFLX
C
C     VAPOR PRESSURES AND CONDUCTIVITY BETWEEN SNOWPACK
C     AND SOIL SURFACE
C
      CNV0=THETP0**1.33*WGSG0(NY,NX)
      CNV1=THETPX(NU(NY,NX),NY,NX)**2/POROQ(NU(NY,NX),NY,NX)
     2*WGSG1(NU(NY,NX),NY,NX)
      IF(CNV0.GT.ZERO.AND.CNV1.GT.ZERO)THEN
      AVCNV1=2.0*CNV0*CNV1
     2/(CNV0*DLYR(3,NU(NY,NX),NY,NX)+CNV1*DPTHS0(NY,NX))
      ELSE
      AVCNV1=2.0*CNV0
     2/(DLYR(3,NU(NY,NX),NY,NX)+DPTHS0(NY,NX))
      ENDIF
C
C     HEAT AND VAPOR FLUXES BETWEEN SNOWPACK AND SOIL SURFACE
C
      TKY=(TK0(NY,NX)*VHCP0(NY,NX)+TK1(NU(NY,NX),NY,NX)
     2*VHCP1(NU(NY,NX),NY,NX))/(VHCP0(NY,NX)+VHCP1(NU(NY,NX),NY,NX))
      HFLWX=(TK0(NY,NX)-TKY)*VHCP0(NY,NX)*FHFLX*XDIM 
      FLVX=AVCNV1*(VP0-VP1)*AREA(3,NU(NY,NX),NY,NX)*BARE(NY,NX) 
      IF(FLVX.GE.0.0)THEN
      FLV1=AMIN1(FLVX,VOLW0(NY,NX)*XNPH)
      IF(HFLWX.GE.0.0)THEN
      FLV1=AMIN1(FLV1,HFLWX/(4.19*TK0(NY,NX)+VAP))
      ENDIF
      HWFLV1=(4.19*TK0(NY,NX)+VAP)*FLV1
      ELSE
      FLV1=AMAX1(FLVX,-VOLW1(NU(NY,NX),NY,NX)*XNPH)
      IF(HFLWX.LT.0.0)THEN
      FLV1=AMAX1(FLV1,HFLWX/(4.19*TK1(NU(NY,NX),NY,NX)+VAP))
      ENDIF
      HWFLV1=(4.19*TK1(NU(NY,NX),NY,NX)+VAP)*FLV1
      ENDIF
      IF(VOLS1(NY,NX).GT.ZEROS(NY,NX))THEN
      DENSW=(VOLS0(NY,NX)+VOLW0(NY,NX)+VOLI0(NY,NX))/VOLS1(NY,NX)
      ELSE
      DENSW=DENS0(NY,NX)
      ENDIF
C
C     J GLACIOL 43:26-41
C
      IF(DENSW.LT.0.156)THEN
      TCNDW=8.28E-05+8.42E-04*DENSW
      ELSE
      TCNDW=4.97E-04-3.64E-03*DENSW+1.16E-02*DENSW**2
      ENDIF
      TCND1=(STC(NU(NY,NX),NY,NX)+THETWX(NU(NY,NX),NY,NX)*2.067E-03
     2+0.611*THETIX(NU(NY,NX),NY,NX)*7.844E-03
     3+1.609*THETPX(NU(NY,NX),NY,NX)*9.050E-05)
     4/(DTC(NU(NY,NX),NY,NX)+THETWX(NU(NY,NX),NY,NX)
     5+0.611*THETIX(NU(NY,NX),NY,NX)+1.609*THETPX(NU(NY,NX),NY,NX))
      IF(BARE(NY,NX).GT.ZERO)THEN
      TCNDW1=TCNDW*XNPH
      TCND1W=TCND1*XNPH
      ATCND0=2.0*TCNDW1*TCND1W
     2/(TCNDW1*DLYR(3,NU(NY,NX),NY,NX)+TCND1W*DPTHS0(NY,NX))*BARE(NY,NX) 
      ELSE
      ATCND0=0.0
      ENDIF
      TK0X=TK0(NY,NX)-HWFLV1/VHCP0(NY,NX)
      TK1X=TK1(NU(NY,NX),NY,NX)+HWFLV1/VHCP1(NU(NY,NX),NY,NX) 
      TKY=(TK0X*VHCP0(NY,NX)+TK1X*VHCP1(NU(NY,NX),NY,NX))
     2/(VHCP0(NY,NX)+VHCP1(NU(NY,NX),NY,NX))
      HFLWX=(TK0X-TKY)*VHCP0(NY,NX)*FHFLX*XDIM 
      HFLWC=ATCND0*(TK0X-TK1X)*AREA(3,NU(NY,NX),NY,NX)
      IF(HFLWC.GE.0.0)THEN
      HFLC01=AMAX1(0.0,AMIN1(HFLWX,HFLWC))
      ELSE
      HFLC01=AMIN1(0.0,AMAX1(HFLWX,HFLWC))
      ENDIF
C     IF(J.EQ.16)THEN
C     WRITE(*,1113)'EFLX0',I,J,M,NX,NY,RFLX,RFLX1,THRMX
C    2,RADXW(NY,NX),THRYW(NY,NX),ALBG,RADG(NY,NX),THS(NY,NX)
C    3,FRADG(NY,NX),THRMCX(NY,NX)
C    2,TKA(NY,NX),TKQ(NY,NX),VPQ(NY,NX),VP0,VP1,PARE,EVAPT,CNV1
C    3,VHCP0(NY,NX),RA,RI,RZ,RAGX,RAGW(NY,NX),RAG(NY,NX),RAB(NY,NX)
C    4,WFLXA(NY,NX),WFLXB(NY,NX),CNV0,PARG(NY,NX),UA(NY,NX),UAG,ALFZ
C    5,THETP0,VOLS0(NY,NX),VOLI0(NY,NX),VOLW0(NY,NX),VOLS1(NY,NX)
C    6,WGSG0(NY,NX),WGSG1(NU(NY,NX),NY,NX),DPTHS0(NY,NX)
C    7,VOLW1(NU(NY,NX),NY,NX),FLQM,FLYM,WMELT
C    8,HWFLQM,HWFLV1,HFLC01,HFLCR1,TKWX(NY,NX)
C    9,WGSG0(NY,NX),THETPX(NU(NY,NX),NY,NX)
C    1,DENSS(NY,NX),VOLS0(NY,NX),VOLS1(NY,NX),TCNDW
1113  FORMAT(A8,5I4,60E12.4)
C     ENDIF
C
C     HEAT FLUX BETWEEN SNOWPACK AND SURFACE RESIDUE
C
      FLVR=0.0
      HWFLVR=0.0
      FLVS=0.0
      HWFLVS=0.0
      HFLC0R=0.0
      HFLCR1=0.0
      IF(VHCPR1(NY,NX).GT.VHCPRX(NY,NX))THEN
      TK0X=TK0(NY,NX) 
      TKXR=TK1(0,NY,NX) 
      TK1X=TK1(NU(NY,NX),NY,NX) 
      CNV01=CNV0*XNPR
      CNV11=CNV1*XNPR
      CNVR1=THETPX(0,NY,NX)**2/POROQ(0,NY,NX)*WGSGR0(NY,NX)*XNPR
      IF(CVRD(NY,NX).GT.ZERO)THEN
      IF(CNV01.GT.ZERO.AND.CNVR1.GT.ZERO)THEN
      AVCNVR=2.0*CNVR1*CNV01
     2/(CNV01*DLYRR(NY,NX)+CNVR1*DPTHS0(NY,NX))*CVRD(NY,NX)
      ELSE
      AVCNVR=2.0*CNV01
     2/(DLYRR(NY,NX)+DPTHS0(NY,NX))*CVRD(NY,NX)
      ENDIF
      IF(CNVR1.GT.ZERO.AND.CNV11.GT.ZERO)THEN
      AVCNVS=2.0*CNVR1*CNV11
     2/(CNVR1*DLYR(3,NU(NY,NX),NY,NX)+CNV11*DLYRR(NY,NX))*CVRD(NY,NX)
      ELSE
      AVCNVS=2.0*CNV11
     2/(DLYR(3,NU(NY,NX),NY,NX)+DLYRR(NY,NX))*CVRD(NY,NX)
      ENDIF
      THETRR=AMAX1(0.0,1.0-THETPX(0,NY,NX)-THETWX(0,NY,NX)
     2-THETIX(0,NY,NX))
      TCNDR=(0.779*THETRR*9.050E-04+0.622*THETWX(0,NY,NX)
     2*2.067E-03+0.380*THETIX(0,NY,NX)*7.844E-03+THETPX(0,NY,NX) 
     3*9.050E-05)/(0.779*THETRR+0.622*THETWX(0,NY,NX)
     4+0.380*THETIX(0,NY,NX)+THETPX(0,NY,NX))
      IF(TCNDW.GT.ZERO.AND.TCNDR.GT.ZERO)THEN
      TCNDW1=TCNDW*XNPHR
      TCNDR1=TCNDR*XNPHR
      ATCNDR=2.0*TCNDW1*TCNDR1
     2/(TCNDW1*DLYRR(NY,NX)+TCNDR1*DPTHS0(NY,NX))*CVRD(NY,NX)
      ELSE
      ATCNDR=0.0
      ENDIF
      IF(TCNDR.GT.ZERO.AND.TCND1.GT.ZERO)THEN
      TCND11=TCND1*XNPHR
      ATCNDS=2.0*TCNDR1*TCND11
     2/(TCNDR1*DLYR(3,NU(NY,NX),NY,NX)+TCND11*DLYRR(NY,NX))*CVRD(NY,NX) 
      ELSE
      ATCNDS=0.0
      ENDIF
      ELSE
      AVCNVR=0.0
      AVCNVS=0.0
      ATCNDR=0.0
      ATCNDS=0.0
      ENDIF
      DO 4000 N=1,NPR
      VP0=2.173E-03/TK0X
     2*0.61*EXP(5360.0*(3.661E-03-1.0/TK0X))
      VPR=2.173E-03/TKXR
     2*0.61*EXP(5360.0*(3.661E-03-1.0/TKXR))
     3*EXP(18.0*PSISM1(0,NY,NX)/(8.3143*TKXR))
      TKY=(TKXR*VHCPR1(NY,NX)+TK0X*VHCP0(NY,NX))
     2/(VHCPR1(NY,NX)+VHCP0(NY,NX)) 
      HFLWX=(TKY-TKXR)*VHCPR1(NY,NX)*FHFLX*XDIM 
      FLVX=AVCNVR*(VP0-VPR)*AREA(3,NU(NY,NX),NY,NX) 
      IF(FLVX.GE.0.0)THEN
      FLVR1=AMIN1(FLVX,VOLW0(NY,NX)*XNPHR)
      IF(HFLWX.GE.0.0)THEN
      FLVR1=AMIN1(FLVR1,HFLWX/(4.19*TK0X+VAP))
      ENDIF
      HWFLVR1=(4.19*TK0X+VAP)*FLVR1
      ELSE
      FLVR1=AMAX1(FLVX,-VOLW1(0,NY,NX)*XNPHR)
      IF(HFLWX.LT.0.0)THEN
      FLVR1=AMAX1(FLVR1,HFLWX/(4.19*TKXR+VAP))
      ENDIF
      HWFLVR1=(4.19*TKXR+VAP)*FLVR1
      ENDIF
      TK0X=TK0X-HWFLVR1/VHCP0(NY,NX)
      TKXR=TKXR+HWFLVR1/VHCPR1(NY,NX) 
      TKY=(TKXR*VHCPR1(NY,NX)+TK0X*VHCP0(NY,NX))
     2/(VHCPR1(NY,NX)+VHCP0(NY,NX)) 
      HFLWX=(TKY-TKXR)*VHCPR1(NY,NX)*FHFLX*XDIM 
      HFLWC=ATCNDR*(TK0X-TKXR)*AREA(3,NU(NY,NX),NY,NX)
      IF(HFLWC.GE.0.0)THEN
      HFLC0R1=AMAX1(0.0,AMIN1(HFLWX,HFLWC))
      ELSE
      HFLC0R1=AMIN1(0.0,AMAX1(HFLWX,HFLWC))
      ENDIF
      TK0X=TK0X-HFLC0R1/VHCP0(NY,NX)
      TKXR=TKXR+HFLC0R1/VHCPR1(NY,NX) 
C
C     HEAT FLUX BETWEEN SURFACE RESIDUE AND SOIL SURFACE UNDER SNOWPACK
C
      VP1=2.173E-03/TK1X
     2*0.61*EXP(5360.0*(3.661E-03-1.0/TK1X))
     3*EXP(18.0*PSISV1/(8.3143*TK1X))
      TKY=(TKXR*VHCPR1(NY,NX)+TK1X*VHCP1(NU(NY,NX),NY,NX))
     2/(VHCPR1(NY,NX)+VHCP1(NU(NY,NX),NY,NX))
      HFLWX=(TKXR-TKY)*VHCPR1(NY,NX)*FHFLX*XDIM 
      FLVX=AVCNVS*(VPR-VP1)*AREA(3,NU(NY,NX),NY,NX) 
      IF(FLVX.GE.0.0)THEN
      FLVS1=AMIN1(FLVX,VOLW1(0,NY,NX)*XNPHR)
      IF(HFLWX.GE.0.0)THEN
      FLVS1=AMIN1(FLVS1,HFLWX/(4.19*TKXR+VAP))
      ENDIF
      HWFLVS1=(4.19*TKXR+VAP)*FLVS1
      ELSE
      FLVS1=AMAX1(FLVX,-VOLW1(NU(NY,NX),NY,NX)*XNPHR)
      IF(HFLWX.LT.0.0)THEN
      FLVS1=AMAX1(FLVS1,HFLWX/(4.19*TK1X+VAP))
      ENDIF
      HWFLVS1=(4.19*TK1X+VAP)*FLVS1
      ENDIF
      TKXR=TKXR-HWFLVS1/VHCPR1(NY,NX)
      TK1X=TK1X+HWFLVS1/VHCP1(NU(NY,NX),NY,NX) 
      TKY=(TKXR*VHCPR1(NY,NX)+TK1X*VHCP1(NU(NY,NX),NY,NX))
     2/(VHCPR1(NY,NX)+VHCP1(NU(NY,NX),NY,NX))
      HFLWX=(TKXR-TKY)*VHCPR1(NY,NX)*FHFLX*XDIM 
      HFLWC=ATCNDS*(TKXR-TK1X)*AREA(3,NU(NY,NX),NY,NX) 
      IF(HFLWC.GE.0.0)THEN
      HFLCR11=AMAX1(0.0,AMIN1(HFLWX,HFLWC))
      ELSE
      HFLCR11=AMIN1(0.0,AMAX1(HFLWX,HFLWC))
      ENDIF
      TKXR=TKXR-HFLCR11/VHCPR1(NY,NX)
      TK1X=TK1X+HFLCR11/VHCP1(NU(NY,NX),NY,NX) 
      FLVR=FLVR+FLVR1
      HWFLVR=HWFLVR+HWFLVR1
      FLVS=FLVS+FLVS1
      HWFLVS=HWFLVS+HWFLVS1
      HFLC0R=HFLC0R+HFLC0R1
      HFLCR1=HFLCR1+HFLCR11
C     IF(NX.EQ.1)THEN
C     WRITE(*,1114)'FLVR0',I,J,M,NX,NY,N,TK0(NY,NX),TK1(0,NY,NX)
C    2,TK1(NU(NY,NX),NY,NX),TK0X,TKXR,TK1X,FLVR1,HWFLVR1,FLVS1
C    4,HWFLVS1,HFLC0R1,HFLCR11,FLVR,HWFLVR,FLVS,HWFLVS 
C    3,HFLC0R,HFLCR1,VPQ(NY,NX),VP0,VPR,VP1,PSISM1(0,NY,NX),PSISV1
C    5,AVCNVR,ATCNDR,AVCNVS,ATCNDS,VHCP0(NY,NX),VHCPR1(NY,NX)
C    6,VHCP1(NU(NY,NX),NY,NX),DLYRR(NY,NX),DPTHS0(NY,NX),CNV01,CNVR1
C    7,CNV11,CNV1,THETPX(NU(NY,NX),NY,NX),POROQ(NU(NY,NX),NY,NX)
C    2,WGSG1(NU(NY,NX),NY,NX),CVRD(NY,NX)
1114  FORMAT(A8,6I4,60E12.4)
C     ENDIF
4000  CONTINUE
      IF(VOLWRX(NY,NX).GT.ZEROS(NY,NX))THEN
      THETWR=AMAX1(0.01,AMIN1(1.0,VOLW1(0,NY,NX)/VOLWRX(NY,NX)))
      ELSE
      THETWR=1.0
      ENDIF
      PSISM1(0,NY,NX)=PSISE(0,NY,NX)*THETWR**-4.0 
      ELSE
      PSISM1(0,NY,NX)=PSISM1(NU(NY,NX),NY,NX)
      ENDIF
      EVAPR(NY,NX)=0.0
      RFLXR=0.0
      EFLXR=0.0
      VFLXR=0.0
      SFLXR=0.0
C
C     GATHER WATER, VAPOR AND HEAT FLUXES INTO FLUX ARRAYS
C     FOR LATER UPDATES TO STATE VARIABLES
C
      FLW0S(NY,NX)=FLQ0S(NY,NX)+EVAPS(NY,NX)
      FLW0L(NY,NX)=FLQ0W(NY,NX)+EVAP(NY,NX)-FLV1-FLVR
      HFLW0L(NY,NX)=HWFLQ0(NY,NX)+HFLW0-HWFLV1-HWFLVR-HFLC01-HFLC0R
      FLWL(3,NU(NY,NX),NY,NX)=FLQM+FLV1+FLVS
      FLWLX(3,NU(NY,NX),NY,NX)=FLQM+FLV1
      FLWHL(3,NU(NY,NX),NY,NX)=FLHM
      HFLWL(3,NU(NY,NX),NY,NX)=HWFLQM+HWFLV1+HWFLVS+HFLC01+HFLCR1
      FLWRL(NY,NX)=FLYM+FLVR-FLVS
      HFLWRL(NY,NX)=HWFLYM+HFLC0R-HFLCR1+HWFLVR-HWFLVS
      FLWVL(NU(NY,NX),NY,NX)=0.0
      FLWV(NU(NY,NX),NY,NX)=FLWV(NU(NY,NX),NY,NX)
     2+FLWVL(NU(NY,NX),NY,NX)
C     IF(NX.EQ.1.AND.NY.EQ.6)THEN
C     WRITE(*,7753)'FLW0L',I,J,M,NX,NY,FLW0L(NY,NX)
C    2,FLQ0W(NY,NX),EVAP(NY,NX),FLV1,FLVR,VOLW0(NY,NX)
C    2,FLW0S(NY,NX),FLQ0S(NY,NX),EVAPS(NY,NX)
C     WRITE(*,7753)'FLWRL',I,J,M,NX,NY,FLWRL(NY,NX)
C    3,PSISM1(0,NY,NX),PSISE(0,NY,NX)
C    2,FLYM,FLVR,FLVS,HFLWRL(NY,NX),VOLW1(0,NY,NX)
C    2,HWFLYM,HFLC0R,HFLCR1,HWFLVR,HWFLVS
7753  FORMAT(A8,5I4,20E12.4)     
C     ENDIF
C
C     FREEZE-THAW IN SNOWPACK FROM NET CHANGE IN SNOWPACK
C     HEAT STORAGE
C
      TFLX=3.6785E-01*(273.15*(2.095*FLW0S(NY,NX)+4.19*FLW0L(NY,NX))
     2+VHCP0(NY,NX)*(273.15-TK0(NY,NX))-HFLW0L(NY,NX))
      IF(TFLX.LT.0.0)THEN
      TVOLWS=VOLS0(NY,NX)+0.92*VOLI0(NY,NX)
      IF(TVOLWS.GT.ZEROS(NY,NX))THEN
      FVOLS0=VOLS0(NY,NX)/TVOLWS
      FVOLI0=0.92*VOLI0(NY,NX)/TVOLWS
      ELSE
      FVOLS0=0.0
      FVOLI0=0.0
      ENDIF
      TFLX0(NY,NX)=AMAX1(-333.0*TVOLWS*XNPH,TFLX)
      WFLXA(NY,NX)=-TFLX0(NY,NX)*FVOLS0/333.0
      WFLXB(NY,NX)=-TFLX0(NY,NX)*FVOLI0/333.0
      ELSE
      TFLX0(NY,NX)=AMIN1(333.0*VOLW0(NY,NX)*XNPH,TFLX)
      WFLXA(NY,NX)=0.0
      WFLXB(NY,NX)=-TFLX0(NY,NX)/333.0
      ENDIF
C
C     TOTAL SNOWPACK WATER, VAPOR AND HEAT FLUXES
C
      TFLWS(NY,NX)=TFLWS(NY,NX)+FLW0S(NY,NX)
     2-WFLXA(NY,NX)-FLWS1(NY,NX)
      TFLWW(NY,NX)=TFLWW(NY,NX)+FLW0L(NY,NX)
     2+WFLXA(NY,NX)+WFLXB(NY,NX)-FLWZ1(NY,NX)
      TFLWI(NY,NX)=TFLWI(NY,NX)-WFLXB(NY,NX)/0.92-FLWI1(NY,NX)
      THFLWW(NY,NX)=THFLWW(NY,NX)+HFLW0L(NY,NX)+TFLX0(NY,NX)
     2-HFLWZ1(NY,NX)-HFLSI1(NY,NX)
      HTHAWW(NY,NX)=HTHAWW(NY,NX)+TFLX0(NY,NX)
      THRMG(NY,NX)=THRMG(NY,NX)+THRMX
C
C     ENERGY EXCHANGE AT SOIL SURFACE IF EXPOSED
C
      ELSE
C
C     PHYSICAL AND HYDRAULIC PROPERTIES OF SOIL SURFACE INCLUDING
C     AIR AND WATER-FILLED POROSITY, AND WATER POTENTIAL USED IN
C     FLUX CALCULATIONS
C
      IF(BKVL(NU(NY,NX),NY,NX).GT.0.0)THEN
      THETW1=AMAX1(THETY(NU(NY,NX),NY,NX),AMIN1(POROS(NU(NY,NX),NY,NX)
     2,VOLW1(NU(NY,NX),NY,NX)/VOLX(NU(NY,NX),NY,NX)))
      IF(THETW1.LT.FC(NU(NY,NX),NY,NX))THEN
      PSISM1(NU(NY,NX),NY,NX)=AMAX1(HYGR,-EXP(PSIMX(NY,NX)
     2+((FCL(NU(NY,NX),NY,NX)-LOG(THETW1))
     3/FCD(NU(NY,NX),NY,NX)*PSIMD(NY,NX))))
      ELSEIF(THETW1.LT.POROS(NU(NY,NX),NY,NX)-DTHETW)THEN 
      PSISM1(NU(NY,NX),NY,NX)=-EXP(PSIMS(NY,NX)
     2+(((PSL(NU(NY,NX),NY,NX)-LOG(THETW1))
     3/PSD(NU(NY,NX),NY,NX))**SRP(NU(NY,NX),NY,NX)*PSISD(NY,NX)))
      ELSE
      PSISM1(NU(NY,NX),NY,NX)=PSISE(NU(NY,NX),NY,NX)
      ENDIF
      ELSE
      PSISM1(NU(NY,NX),NY,NX)=PSISE(NU(NY,NX),NY,NX)
      ENDIF
      PSISV1=PSISM1(NU(NY,NX),NY,NX)+PSISO(NU(NY,NX),NY,NX)
C     WRITE(*,3232)'PSISV1',I,J,M,NU(NY,NX),PSISV1
C    2,PSISM1(NU(NY,NX),NY,NX),PSISO(NU(NY,NX),NY,NX)
C    3,THETWX(NU(NY,NX),NY,NX),THETW1,POROS(NU(NY,NX),NY,NX)
C    4,PSL(NU(NY,NX),NY,NX),LOG(THETW1),PSD(NU(NY,NX),NY,NX)
C    5,SRP(NU(NY,NX),NY,NX)
3232  FORMAT(A8,4I4,12E12.4)
C
C     SOIL SURFACE ALBEDO, NET RADIATION
C
      VOLWXG=VOLW1(NU(NY,NX),NY,NX)+VOLWH1(NU(NY,NX),NY,NX)
      VOLIXG=VOLI1(NU(NY,NX),NY,NX)+VOLIH1(NU(NY,NX),NY,NX)
      ALBG=(ALBS(NY,NX)*BKVL(NU(NY,NX),NY,NX)+0.06*VOLWXG
     2+0.30*VOLIXG)/(BKVL(NU(NY,NX),NY,NX)+VOLWXG+VOLIXG)
      RFLX1=(1.0-ALBG)*RADXG(NY,NX)+THRYG(NY,NX)
      THRMA=THRMS(NY,NX)*TKSX(NY,NX)**4
      RFLX=RFLX1-THRMA
C
C     AERODYNAMIC RESISTANCE ABOVE SOIL SURFACE INCLUDING
C     RESISTANCE IMPOSED BY PLANT CANOPY
C
      RAR1=RAR(NY,NX)/AMAX1(0.1,THETPX(0,NY,NX))**2.33
      RAGZ=RAG(NY,NX)+RAR1
      RI=AMAX1(-0.3,AMIN1(0.075,RIB(NY,NX)*(TKQ(NY,NX)
     2-TK1(NU(NY,NX),NY,NX))))
      RAGX=AMAX1(RAM,0.75*RAGS(NY,NX),AMIN1(1.33*RAGS(NY,NX)
     2,RAGZ/(1.0-10.0*RI)))
      RAGS(NY,NX)=RAGX
      RA=RAGX 
C
C     PARAMETERS FOR CALCULATING LATENT AND SENSIBLE HEAT FLUXES
C
      PARE=PAREG(NY,NX)/(RA+RZ)
      PARS=PARSG(NY,NX)/RA
      TKX1=TKSX(NY,NX)
      VP1=2.173E-03/TKX1
     2*0.61*EXP(5360.0*(3.661E-03-1.0/TKX1))
     3*EXP(18.0*PSISV1/(8.3143*TKX1))
      EVAP(NY,NX)=AMAX1(PARE*(VPQ(NY,NX)-VP1)
     2,-AMAX1(0.0,VOLW1(NU(NY,NX),NY,NX))*XNPH)
      EVAPS(NY,NX)=0.0
      EFLX=EVAP(NY,NX)*VAP
      IF(EVAP(NY,NX).LT.0.0)THEN
      VFLX=EVAP(NY,NX)*4.19*TKSX(NY,NX)
      ELSE
      VFLX=EVAP(NY,NX)*4.19*TKQ(NY,NX)
      ENDIF
C     WRITE(*,3376)'EVAP',I,J,NX,NY,M,EVAP(NY,NX),RFLX,RFLX1,THRMA
C    3,THETPX(0,NY,NX)
C    2,PARE,VPQ(NY,NX),VP1,RA,RAZ,RAGS(NY,NX),RI,RAR1,RAR(NY,NX),RAGZ
C    3,RAG(NY,NX),RIB(NY,NX),TKX1,PSISV1,VOLW1(NU(NY,NX),NY,NX)
C    4,DLYRR(NY,NX),WGSGR(NY,NX),VOLX(0,NY,NX),ORGC(0,NY,NX)
C    5,VOLA(0,NY,NX),VOLW1(0,NY,NX),VOLI1(0,NY,NX),VOLP1(0,NY,NX)
C
C     SOLVE FOR SOIL SURFACE TEMPERATURE AT WHICH ENERGY
C     BALANCE OCCURS, SOLVE LATENT, SENSIBLE AND STORAGE HEAT FLUXES
C
      TKSX(NY,NX)=(PARS*TKQ(NY,NX)+VHCP1(NU(NY,NX),NY,NX)
     2*TK1(NU(NY,NX),NY,NX)+RFLX+EFLX+HWFLQM+VFLX)
     3/(PARS+VHCP1(NU(NY,NX),NY,NX)+4.19*(FLQM+FLHM+EVAP(NY,NX)))
      SFLX=PARS*(TKQ(NY,NX)-TKSX(NY,NX))
      HFLW1=RFLX+EFLX+SFLX+VFLX
C     IF(I.EQ.208)THEN
C     WRITE(*,1112)'EFLX',I,J,M,NX,NY,TK1(NU(NY,NX),NY,NX),TKSX(NY,NX) 
C    2,RFLX,EFLX,SFLX,VFLX,HFLW1,RA,RAC(NY,NX),RAG(NY,NX),RAS1,RAGZ,RAR1
C    3,RAGX,RI,RAGS(NY,NX),VOLW1(NU(NY,NX),NY,NX),VOLI1(NU(NY,NX),NY,NX) 
C    4,RADXG(NY,NX),THRYG(NY,NX),THRMA,THRYW(NY,NX),THS(NY,NX)
C    5,BARE(NY,NX),PARG(NY,NX),VPQ(NY,NX),VP1,FRADG(NY,NX),THRMCX(NY,NX)
C    5,PSISM1(NU(NY,NX),NY,NX),PSISO(NU(NY,NX),NY,NX) 
C    6,FLQM,EVAP(NY,NX),PARE,HFLW1,PARS,PARSG(NY,NX),HWFLQM
C    7,ATCNDS,TCND1,THETWX(NU(NY,NX),NY,NX),RAR(NY,NX),THETPX(0,NY,NX)
C    8,TKSX(NY,NX),VHCP1(NU(NY,NX),NY,NX),PARS,TKRX(NY,NX)
C    3,TKQ(NY,NX)
1112  FORMAT(A8,5I4,60E12.4)
C     ENDIF
C
C     ENERGY BALANCE AT RESIDUE SURFACE
C
      IF(VHCPR1(NY,NX).GT.VHCPRX(NY,NX))THEN
C
C     PARAMETERS FOR CALCULATING LATENT AND SENSIBLE HEAT FLUXES
C
      EVAPR(NY,NX)=0.0
      RFLXR=0.0
      EFLXR=0.0
      VFLXR=0.0
      SFLXR=0.0
      HFLR1=0.0
      FLV1=0.0
      HWFLV1=0.0
      HFLCR1=0.0
      THRMZ=0.0
C
C     NET RADIATION AT RESIDUE SURFACE
C
      
      ALBR=(0.20*BKVL(0,NY,NX)+0.06*VOLW1(0,NY,NX)+0.30
     2*VOLI1(0,NY,NX))/(BKVL(0,NY,NX)+VOLW1(0,NY,NX)+VOLI1(0,NY,NX))
      RFLX1=(1.0-ALBR)*RADXR(NY,NX)+THRYR(NY,NX)
      TKR2=TKRX(NY,NX)
      TKR1=TK1(0,NY,NX)
      VOLWR2=VOLW1(0,NY,NX)
      VHCPR2=VHCPR1(NY,NX)
      TKS1=TK1(NU(NY,NX),NY,NX)
      HFLW2=HFLW1*XNPR
      VOLW12=VOLW1(NU(NY,NX),NY,NX)
      VHCP12=VHCP1(NU(NY,NX),NY,NX)
C
C     THERMAL CONDUCTIVITY BETWEEN SURFACE RESIDUE AND SOIL SURFACE
C
      CNVR=THETPX(0,NY,NX)**2/POROQ(0,NY,NX)*WGSGR0(NY,NX)*XNPR
      CNV1=THETPX(NU(NY,NX),NY,NX)**2/POROQ(NU(NY,NX),NY,NX)*XNPR
     2*WGSG1(NU(NY,NX),NY,NX)
      IF(CVRD(NY,NX).GT.ZERO)THEN
      IF(CNVR.GT.ZERO.AND.CNV1.GT.ZERO)THEN
      AVCNVS=2.0*CNVR*CNV1
     2/(CNVR*DLYR(3,NU(NY,NX),NY,NX)+CNV1*DLYRR(NY,NX))*CVRD(NY,NX)
      ELSE
      AVCNVS=2.0*CNVR
     2/(DLYR(3,NU(NY,NX),NY,NX)+DLYRR(NY,NX))*CVRD(NY,NX)
      ENDIF
      ELSE
      AVCNVS=0.0
      ENDIF
      THETRR=AMAX1(0.0,1.0-THETPX(0,NY,NX)-THETWX(0,NY,NX)
     2-THETIX(0,NY,NX))
      DTKX=ABS(TK1(0,NY,NX)-TK1(NU(NY,NX),NY,NX))*1.0E-06
      DTHW0=AMAX1(0.0,THETWX(0,NY,NX)-TTRB)**3 
      DTHP0=AMAX1(0.0,THETPX(0,NY,NX)-TTRB)**3 
      DTHW1=AMAX1(0.0,THETWX(NU(NY,NX),NY,NX)-TTRB)**3 
      DTHP1=AMAX1(0.0,THETPX(NU(NY,NX),NY,NX)-TTRB)**3 
      RYLNW0=DTKX*DTHW0 
      RYLNP0=DTKX*DTHP0 
      RYLNW1=DTKX*DTHW1 
      RYLNP1=DTKX*DTHP1 
      RYLNQ0=AMIN1(1.0E+04,RYLXQ*RYLNW0)  
      RYLNA0=AMIN1(1.0E+04,RYLXA*RYLNP0)
      RYLNQ1=AMIN1(1.0E+04,RYLXQ*RYLNW1)  
      RYLNA1=AMIN1(1.0E+04,RYLXA*RYLNP1)
      XNUSQ0=AMAX1(1.0,0.68+0.67*RYLNQ0**0.25/DNUSQ)
      XNUSA0=AMAX1(1.0,0.68+0.67*RYLNA0**0.25/DNUSA)
      XNUSQ1=AMAX1(1.0,0.68+0.67*RYLNQ1**0.25/DNUSQ)
      XNUSA1=AMAX1(1.0,0.68+0.67*RYLNA1**0.25/DNUSA)
      TCNDQ0=2.067E-03*XNUSQ0
      TCNDA0=9.050E-05*XNUSA0  
      TCNDQ1=2.067E-03*XNUSQ1
      TCNDA1=9.050E-05*XNUSA1  
      TCNDR=(0.779*THETRR*9.050E-04+0.622*THETWX(0,NY,NX)*TCNDQ0 
     2+0.380*THETIX(0,NY,NX)*7.844E-03+THETPX(0,NY,NX)*TCNDA0) 
     3/(0.779*THETRR+0.622*THETWX(0,NY,NX)
     4+0.380*THETIX(0,NY,NX)+THETPX(0,NY,NX))
      TCNDR1=TCNDR*XNPHR
      TCND1=(STC(NU(NY,NX),NY,NX)+THETWX(NU(NY,NX),NY,NX)*TCNDQ1
     2+0.611*THETIX(NU(NY,NX),NY,NX)*7.844E-03
     3+1.609*THETPX(NU(NY,NX),NY,NX)*TCNDA1)
     4/(DTC(NU(NY,NX),NY,NX)+THETWX(NU(NY,NX),NY,NX)
     5+0.611*THETIX(NU(NY,NX),NY,NX)+1.609*THETPX(NU(NY,NX),NY,NX))
      TCND1R=TCND1*XNPHR
      ATCNDR=2.0*TCNDR1*TCND1R
     2/(TCNDR1*DLYR(3,NU(NY,NX),NY,NX)+TCND1R*DLYRR(NY,NX))*CVRD(NY,NX) 
C
C     SMALLER TIME STEP FOR SOLVING SURFACE RESIDUE ENERGY EXCHANGE
C
      DO 5000 N=1,NPR
      IF(VHCPR2.GT.VHCPRX(NY,NX))THEN
C
C     AERODYNAMIC RESISTANCE ABOVE RESIDUE INCLUDING
C     RESISTANCE IMPOSED BY PLANT CANOPY
C
      RARZ=RAG(NY,NX)+RAR1*FRAR
      RI=AMAX1(-0.3,AMIN1(0.075,RIB(NY,NX)*(TKQ(NY,NX)-TKR2)))
      RAGX=AMAX1(RAM,0.75*RAGR(NY,NX),AMIN1(1.33*RAGR(NY,NX)
     2,RARZ/(1.0-10.0*RI)))
      RAGR(NY,NX)=RAGX
      RA=RAGX
      PARE=PARER(NY,NX)/(RA+RZR)
      PARS=PARSR(NY,NX)/RA
C
C     NET RADIATION AT RESIDUE SURFACE
C
      THRMZ2=THRMR(NY,NX)*TKR2**4
      RFLXR2=RFLX1-THRMZ2
      IF(VOLWRX(NY,NX).GT.ZEROS(NY,NX))THEN
      THETWR=AMAX1(0.01,AMIN1(1.0,VOLWR2/VOLWRX(NY,NX)))
      ELSE
      THETWR=1.0
      ENDIF
      PSISM1(0,NY,NX)=PSISE(0,NY,NX)*THETWR**-4.0 
C
C     VAPOR FLUX AT RESIDUE SURFACE
C
      VPR=2.173E-03/TKR2
     2*0.61*EXP(5360.0*(3.661E-03-1.0/TKR2))
     3*EXP(18.0*PSISM1(0,NY,NX)/(8.3143*TKR2))
      VP1=2.173E-03/TKS1
     2*0.61*EXP(5360.0*(3.661E-03-1.0/TKS1))
     3*EXP(18.0*PSISV1/(8.3143*TKS1))
      EVAPR2=AMIN1(VOLWRM*XNPHR,AMAX1(-AMAX1(0.0,VOLWR2)*XNPHR
     2,PARE*(VPQ(NY,NX)-VPR)))
      EFLXR2=EVAPR2*VAP
      VFLXR2=EVAPR2*4.19*TKR2
C
C     SOLVE FOR RESIDUE SURFACE TEMPERATURE AT WHICH ENERGY
C     BALANCE OCCURS, SOLVE LATENT, SENSIBLE AND STORAGE HEAT FLUXES
C
      TKY=(TKR2*VHCPR2+TKS1*VHCP12)/(VHCPR2+VHCP12)
      HFLWX=(TKR2-TKY)*VHCPR2*FHFLX*XDIM 
      FLVX=AVCNVS*(VPR-VP1)*AREA(3,NU(NY,NX),NY,NX) 
      IF(FLVX.GE.0.0)THEN
      FLV2=AMIN1(FLVX,VOLWR2*XNPHR)
      IF(HFLWX.GE.0.0)THEN
      FLV2=AMIN1(FLV2,HFLWX/(4.19*TKR2+VAP))
      ENDIF
      HWFLV2=(4.19*TKR2+VAP)*FLV2
      ELSE
      FLV2=AMAX1(FLVX,-VOLW12*XNPHR)
      IF(HFLWX.LT.0.0)THEN
      FLV2=AMAX1(FLV2,HFLWX/(4.19*TKS1+VAP))
      ENDIF
      HWFLV2=(4.19*TKS1+VAP)*FLV2
      ENDIF
      TKXR=TKR2-HWFLV2/VHCPR2
      TK1X=TKS1+HWFLV2/VHCP12 
      TKY=(TKXR*VHCPR2+TK1X*VHCP12)/(VHCPR2+VHCP12)
      HFLWX=(TKXR-TKY)*VHCPR2*FHFLX*XDIM 
      HFLWC=ATCNDR*(TKXR-TK1X)*AREA(3,0,NY,NX)
      IF(HFLWC.GE.0.0)THEN
      HFLCR2=AMAX1(0.0,AMIN1(HFLWX,HFLWC))
      ELSE
      HFLCR2=AMIN1(0.0,AMAX1(HFLWX,HFLWC))
      ENDIF
      TKR2=(PARS*TKQ(NY,NX)+VHCPR2*TKR1+HWFLM2
     2+RFLXR2+EFLXR2+VFLXR2-HWFLV2-HFLCR2)
     2/(PARS+VHCPR2+4.19*(FLYM2+EVAPR2))
      SFLXR2=PARS*(TKQ(NY,NX)-TKR2)
      HFLR2=RFLXR2+EFLXR2+SFLXR2+VFLXR2
C
C     AGGREGATE WATER AND ENERGY FLUXES FROM RESIDUE TIME STEP
C     TO MODEL TIME STEP
C
      EVAPR(NY,NX)=EVAPR(NY,NX)+EVAPR2
      RFLXR=RFLXR+RFLXR2
      EFLXR=EFLXR+EFLXR2
      VFLXR=VFLXR+VFLXR2
      SFLXR=SFLXR+SFLXR2
      HFLR1=HFLR1+HFLR2
      FLV1=FLV1+FLV2
      HWFLV1=HWFLV1+HWFLV2
      HFLCR1=HFLCR1+HFLCR2 
      THRMZ=THRMZ+THRMZ2
      ELSE
      EVAPR2=0.0
      RFLXR2=0.0
      EFLXR2=0.0
      VFLXR2=0.0
      SFLXR2=0.0
      HFLR2=0.0
      FLV2=0.0
      HWFLV2=0.0
      HFLCR2=0.0
      THRMZ2=0.0
      ENDIF
      VOLWR2=VOLWR2+FLYM2+EVAPR2-FLV2
      VOLW12=VOLW12+FLV2
      ENGYR=VHCPR2*TKR1
      VHCPR2=2.496E-06*ORGC(0,NY,NX)+4.19*VOLWR2
     2+1.9274*VOLI1(0,NY,NX)
      VHCP12=VHCP12+4.19*FLV2 
      TKR1=(ENGYR+HWFLM2+HFLR2-HWFLV2-HFLCR2)/VHCPR2
      TKS1X=TKS1
      TKS1=TKS1+(HFLW2+HWFLV2+HFLCR2)/VHCP12
C     IF(NX.EQ.1.AND.NY.EQ.6)THEN
C     WRITE(*,1111)'EFLXR2',I,J,NX,NY,M,N,TKR2,TKR1,TKS1,TKQ(NY,NX)
C    2,EFLXR2,SFLXR2,VFLXR2,FLV2,FLVX,VPR,VP1,AVCNVS,PSISE(0,NY,NX)
C    3,PSISM1(0,NY,NX),PSISV1,THETWR,VOLWR2,VOLWRX(NY,NX),TRC0(NY,NX)
C    4,PARS,PARE,RA,RZR,RI,TKQ(NY,NX)-TKR2,VOLWR2,VOLW12,HFLWX,FLV1
C    5,VOLW1(NU(NY,NX),NY,NX),THRMZ2,VOLW1(0,NY,NX) 
C    3,HWFLV2,HFLCR2,HWFLM2,RA,RAGX,RAG(NY,NX),RAB(NY,NX),RAC(NY,NX)
C    4,RZR,RZ,PARS,TKR2 
C    4,RARZ,RAR1,PARE,VPQ(NY,NX),EVAPR(NY,NX),EVAPR2 
C    5,VHCPR2,VHCP12,CNVR,CNV1,VOLX(0,NY,NX) 
C    5,ATCNDR,TCNDR,TCNDR1,TCND1R,DLYR(3,NU(NY,NX),NY,NX) 
C    6,DLYRR(NY,NX),DLYR(3,0,NY,NX),POROQ(0,NY,NX),WGSGR(NY,NX)
C    7,THETWX(0,NY,NX),THETIX(0,NY,NX),THETPX(0,NY,NX),ORGC(0,NY,NX)
C    8,CVRD(NY,NX),EFLXR,EFLX,TRA0(NY,NX),ATCNDR*(TKR2-TKS1),TKS1X 
1111  FORMAT(A8,6I4,100E24.16)
C     ENDIF
5000  CONTINUE
      TKRX(NY,NX)=TKR2
C
C     IF NO SURFACE RESIDUE
C
      ELSE
      TKRX(NY,NX)=TKSX(NY,NX)
      TK1(0,NY,NX)=TK1(NU(NY,NX),NY,NX)
      EVAPR(NY,NX)=0.0
      RFLXR=0.0
      EFLXR=0.0
      VFLXR=0.0
      SFLXR=0.0
      HFLR1=0.0
      FLV1=0.0
      HWFLV1=0.0
      HFLCR1=0.0
      THRMZ=0.0
      ENDIF
C
C     GATHER WATER, VAPOR AND HEAT FLUXES INTO FLUX ARRAYS
C     FOR LATER UPDATES TO STATE VARIABLES
C
      FLWL(3,NU(NY,NX),NY,NX)=FLQM+EVAP(NY,NX)+FLV1
      FLWLX(3,NU(NY,NX),NY,NX)=FLQM+EVAP(NY,NX)+FLV1
      FLWHL(3,NU(NY,NX),NY,NX)=FLHM
      HFLWL(3,NU(NY,NX),NY,NX)=HWFLQM+HFLW1+HWFLV1+HFLCR1
      FLWRL(NY,NX)=FLYM+EVAPR(NY,NX)-FLV1
      HFLWRL(NY,NX)=HWFLYM+HFLR1-HWFLV1-HFLCR1
      FLWVL(NU(NY,NX),NY,NX)=RFLWV(NY,NX)*(VOLW1(NU(NY,NX),NY,NX)
     2-VOLWX1(NU(NY,NX),NY,NX))
      FLWV(NU(NY,NX),NY,NX)=FLWV(NU(NY,NX),NY,NX)
     2+FLWVL(NU(NY,NX),NY,NX)
C     IF(NX.EQ.1.AND.NY.EQ.6)THEN
C     WRITE(*,3376)'FLW1',I,J,M,NX,NY,FLWL(3,NU(NY,NX),NY,NX)
C    2,PSISM1(0,NY,NX),PSISM1(NU(NY,NX),NY,NX),VOLWRX(NY,NX)
C    3,VOLW1(0,NY,NX),VOLW1(NU(NY,NX),NY,NX),THETWX(NU(NY,NX),NY,NX)
C    2,FLQM,EVAP(NY,NX),PARE,VPQ(NY,NX),VP1
C    4,FLWRL(NY,NX),FLYM,EVAPR(NY,NX),FLV1
C     WRITE(*,3376)'HFLW1',I,J,M,NX,NY,HFLWL(3,NU(NY,NX),NY,NX)
C    2,HWFLQM,HFLW1,HWFLV1,HFLCR1,HFLWRL(NY,NX),HWFLYM
C    3,HFLR1,HWFLV1,HFLCR1
3376  FORMAT(A8,5I4,40E24.16)
C     ENDIF
C
C     HEAT AND WATER TRANSFER WITH RESIDUAL SNOWPACK
C
      TFLWS(NY,NX)=TFLWS(NY,NX)+FLQ0S(NY,NX)-FLWS1(NY,NX)
      TFLWW(NY,NX)=TFLWW(NY,NX)+FLQ0W(NY,NX)-FLWZ1(NY,NX)
      TFLWI(NY,NX)=TFLWI(NY,NX)-FLWI1(NY,NX)
      THFLWW(NY,NX)=THFLWW(NY,NX)+HWFLQ0(NY,NX)-HFLWZ1(NY,NX)
     2-HFLSI1(NY,NX)
      THRMG(NY,NX)=THRMG(NY,NX)+THRMA+THRMZ
      ENDIF
C
C     CAPILLARY EXCHANGE OF WATER BETWEEN SOIL SURFACE AND RESIDUE
C
      CNDR=HCNDR(NY,NX)*(PSISE(0,NY,NX)/PSISM1(0,NY,NX))**3
      IF(VOLW1(0,NY,NX).GE.VOLWRX(NY,NX))THEN
      CND1=HCND(3,1,NU(NY,NX),NY,NX)*XNPH
      ELSE
      K1=MIN(100,INT(100.0*(AMAX1(0.0,POROS(NU(NY,NX),NY,NX)
     2-THETWX(NU(NY,NX),NY,NX)))/POROS(NU(NY,NX),NY,NX))+1)
      CND1=HCND(3,K1,NU(NY,NX),NY,NX)*XNPH
      ENDIF
      AVCND1=2.0*CNDR*CND1/(CNDR*DLYR(3,NU(NY,NX),NY,NX)
     2+CND1*DLYRR(NY,NX)) 
      FLXQR=AVCND1*(PSISM1(0,NY,NX)-PSISM1(NU(NY,NX),NY,NX))
     2*AREA(3,NU(NY,NX),NY,NX)
      IF(FLXQR.LT.0.0)THEN
      FLXSR=AMAX1(FLXQR,-XNPH*AMIN1(VOLW1(NU(NY,NX),NY,NX)
     2,AMAX1(0.0,VOLWRX(NY,NX)-VOLW1(0,NY,NX)-VOLI1(0,NY,NX))))
      ELSE
      FLXSR=AMIN1(FLXQR,AMIN1(XNPH*VOLW1(0,NY,NX)
     2,XNPH*VOLP1(NU(NY,NX),NY,NX)))
      ENDIF
      IF(FLXSR.GT.0.0)THEN
      HFLXSR=4.19*TK1(0,NY,NX)*FLXSR
      ELSE
      HFLXSR=4.19*TK1(NU(NY,NX),NY,NX)*FLXSR
      ENDIF
      FLWL(3,NU(NY,NX),NY,NX)=FLWL(3,NU(NY,NX),NY,NX)+FLXSR
      HFLWL(3,NU(NY,NX),NY,NX)=HFLWL(3,NU(NY,NX),NY,NX)+HFLXSR
      FLWRL(NY,NX)=FLWRL(NY,NX)-FLXSR
      HFLWRL(NY,NX)=HFLWRL(NY,NX)-HFLXSR
      FLWRM(M,NY,NX)=FLXSR
C
C     MOVE WATER UP DURING PRECIPITATION OR FREEZING
C 
      IF(VOLP1(NU(NY,NX),NY,NX).LT.ZEROS(NY,NX))THEN
      FLWLY=AMIN1(0.0,VOLA(NU(NY,NX),NY,NX)-VOLW1(NU(NY,NX),NY,NX)
     3-VOLI1(NU(NY,NX),NY,NX))
      HFLWLY=FLWLY*4.19*TK1(NU(NY,NX),NY,NX)
      FLWL(3,NU(NY,NX),NY,NX)=FLWL(3,NU(NY,NX),NY,NX)+FLWLY 
      HFLWL(3,NU(NY,NX),NY,NX)=HFLWL(3,NU(NY,NX),NY,NX)+HFLWLY 
      FLWLYR=AMIN1(0.0,FLWLY+VOLPH1(NU(NY,NX),NY,NX))
      HFLWYR=FLWLYR*4.19*TK1(NU(NY,NX),NY,NX)
      FLWLYH=FLWLY-FLWLYR
      HFLWYH=FLWLYH*4.19*TK1(NU(NY,NX),NY,NX)
      FLWRL(NY,NX)=FLWRL(NY,NX)-FLWLYR 
      HFLWRL(NY,NX)=HFLWRL(NY,NX)-HFLWYR
      FLWHL(3,NU(NY,NX),NY,NX)=FLWHL(3,NU(NY,NX),NY,NX)-FLWLYH 
      HFLWL(3,NU(NY,NX),NY,NX)=HFLWL(3,NU(NY,NX),NY,NX)-HFLWYH
C     IF(NX.EQ.1.AND.NY.EQ.6)THEN
C     WRITE(*,4322)'FLWLY',I,J,M,NX,NY,FLWRL(NY,NX),FLWLY,FLWLYR 
C    2,FLWLYH,FLXSR,VOLX(NU(NY,NX),NY,NX),VOLA(NU(NY,NX),NY,NX)
C    3,VOLP1(NU(NY,NX),NY,NX),VOLW1(NU(NY,NX),NY,NX)
C    3,VOLI1(NU(NY,NX),NY,NX),VOLP1(0,NY,NX),VOLW1(0,NY,NX)
C    3,VOLI1(0,NY,NX)
C    2,VOLAH1(NU(NY,NX),NY,NX),VOLPH1(NU(NY,NX),NY,NX)
C    2,VOLWH1(NU(NY,NX),NY,NX),VOLIH1(NU(NY,NX),NY,NX)
4322  FORMAT(A8,5I4,40E12.4)
C     ENDIF
      ENDIF
      IF(VOLPH1(NU(NY,NX),NY,NX).LT.ZEROS(NY,NX))THEN
      FLWHY=AMIN1(0.0,VOLAH1(NU(NY,NX),NY,NX)-VOLWH1(NU(NY,NX),NY,NX)
     3-VOLIH1(NU(NY,NX),NY,NX))
      HFLWHY=FLWHY*4.19*TK1(NU(NY,NX),NY,NX) 
      FLWHL(3,NU(NY,NX),NY,NX)=FLWHL(3,NU(NY,NX),NY,NX)+FLWHY 
      HFLWL(3,NU(NY,NX),NY,NX)=HFLWL(3,NU(NY,NX),NY,NX)+HFLWHY 
      FLWRL(NY,NX)=FLWRL(NY,NX)-FLWHY 
      HFLWRL(NY,NX)=HFLWRL(NY,NX)-HFLWHY
C     IF(NX.EQ.1.AND.NY.EQ.6)THEN
C     WRITE(*,4324)'FLWHY',I,J,M,NX,NY,FLWRL(NY,NX),FLWHY
C    2,VOLAH1(NU(NY,NX),NY,NX),VOLPH1(NU(NY,NX),NY,NX)
C    2,VOLWH1(NU(NY,NX),NY,NX),VOLIH1(NU(NY,NX),NY,NX)
C    2,VOLAH1(NU(NY,NX)+1,NY,NX),VOLPH1(NU(NY,NX)+1,NY,NX)
C    2,VOLWH1(NU(NY,NX)+1,NY,NX),VOLIH1(NU(NY,NX)+1,NY,NX)
C    3,VOLW1(0,NY,NX)
4324  FORMAT(A8,5I4,30E12.4)
C     ENDIF
      ENDIF
C     IF((I/10)*10.EQ.I)THEN
C     WRITE(*,4321)'HCNDR',I,J,M,NX,NY,K1,AVCND1,CNDR,CND1,DLYRR(NY,NX)
C    2,PSISM1(0,NY,NX),PSISM1(NU(NY,NX),NY,NX),FLXQR,FLXSR,HFLXSR 
C    3,VOLWR2,TRA0(NY,NX),EVAPR(NY,NX),VOLWRX(NY,NX)-VOLW1(0,NY,NX)
C    2-VOLI1(0,NY,NX),VOLW1(NU(NY,NX),NY,NX),VOLW1(0,NY,NX)
C    4,VOLP1(NU(NY,NX),NY,NX),POROS(NU(NY,NX),NY,NX)
C    5,VOLWG(NY,NX),FLYM,HCNDR(NY,NX),PSISE(0,NY,NX),PSISM1(0,NY,NX)
C    6,THETWR,VHCPR1(NY,NX),VHCPRX(NY,NX)
4321  FORMAT(A8,6I4,30E12.4)
C     ENDIF
C
C     OVERLAND FLOW INTO MACROPORES WHEN WATER STORAGE CAPACITY
C     OF THE SOIL SURFACE IS EXCEEDED
C
      IF(VOLPH1(NU(NY,NX),NY,NX).GT.0.0)THEN
      IF(VOLW1(0,NY,NX).GT.VOLWRX(NY,NX))THEN
      AVCNH1=2.0*CNDH1(NU(NY,NX),NY,NX)/DLYR(3,NU(NY,NX),NY,NX) 
      FLWHX=AVCNH1*0.01*DPTH(NU(NY,NX),NY,NX)*AREA(3,NU(NY,NX),NY,NX)
      FINHR=AMIN1(OVOLPH*VOLPH1(NU(NY,NX),NY,NX)
     2,VOLW1(0,NY,NX)-VOLWRX(NY,NX),FLWHX)
      HFINHR=FINHR*4.19*TK1(0,NY,NX)
      FLWRL(NY,NX)=FLWRL(NY,NX)-FINHR
      HFLWRL(NY,NX)=HFLWRL(NY,NX)-HFINHR
      FLWHL(3,NU(NY,NX),NY,NX)=FLWHL(3,NU(NY,NX),NY,NX)+FINHR
      HFLWL(3,NU(NY,NX),NY,NX)=HFLWL(3,NU(NY,NX),NY,NX)+HFINHR
C     IF(NX.EQ.1.AND.NY.EQ.6)THEN
C     WRITE(*,4357)'FINHR',I,J,M,NX,NY,FLWRL(NY,NX),FINHR
C    2,VOLPH1(NU(NY,NX),NY,NX),TVOLW(NY,NX),FLWHX,VOLW1(0,NY,NX) 
C    3,VOLWRX(NY,NX),FLWHL(3,NU(NY,NX),NY,NX)
C    4,HFINHR,TK1(0,NY,NX),HFLWRL(NY,NX),HFLWL(3,NU(NY,NX),NY,NX)
4357  FORMAT(A8,5I4,40E12.4)
C     ENDIF
      ENDIF
      ENDIF
C
C     FREEZE-THAW IN RESIDUE SURFACE FROM NET CHANGE IN RESIDUE 
C     SURFACE HEAT STORAGE
C
      TFREEZ=-9.0959E+04/(PSISM1(0,NY,NX)-333.0)
      IF((TK1(0,NY,NX).LT.TFREEZ
     2.AND.VOLW1(0,NY,NX).GT.1.0E-12*VOLA(0,NY,NX))
     3.OR.(TK1(0,NY,NX).GT.TFREEZ 
     4.AND.VOLI1(0,NY,NX).GT.1.0E-12*VOLA(0,NY,NX)))THEN
      TFLX1=1.0/(1.0+TFREEZ*6.2913E-03) 
     2*(TFREEZ*4.19*FLWRL(NY,NX)
     3+VHCPR1(NY,NX)*(TFREEZ-TK1(0,NY,NX))
     4-HFLWRL(NY,NX))
      IF(TFLX1.LT.0.0)THEN
      TFLX=AMAX1(-333.0*0.92*VOLI1(0,NY,NX)*XNPH
     2,-VHCPR1(NY,NX)*XNPH*10.0,TFLX1)
      ELSE
      TFLX=AMIN1(333.0*VOLW1(0,NY,NX)*XNPH
     2,VHCPR1(NY,NX)*XNPH*10.0,TFLX1)
      ENDIF
      WFLX=-TFLX/333.0
      IF(WFLX.GT.0.0.AND.VOLI1(0,NY,NX)
     2.GT.ZEROS(NY,NX))THEN
      WFLXR(NY,NX)=WFLX 
      TFLXR(NY,NX)=TFLX
      ELSEIF(WFLX.LT.0.0.AND.VOLW1(0,NY,NX)
     2.GT.ZEROS(NY,NX))THEN
      WFLXR(NY,NX)=WFLX 
      TFLXR(NY,NX)=TFLX
      ELSE
      WFLXR(NY,NX)=0.0
      TFLXR(NY,NX)=0.0
      ENDIF
      ELSE
      WFLXR(NY,NX)=0.0
      TFLXR(NY,NX)=0.0
      ENDIF
C     WRITE(*,5352)'TFLXR',I,J,M,WFLXR(NY,NX),TFLXR(NY,NX)
C    2,PSISV0,THETWR,TFLX,WFLX,VOLI1(0,NY,NX),VOLW1(0,NY,NX)
C    3,TKXR,TFREEZ,PSISV0
5352  FORMAT(A8,3I4,20E12.4)
C
C     FREEZE-THAW IN SOIL SURFACE MICROPORE FROM NET CHANGE IN SOIL 
C     SURFACE HEAT STORAGE
C
      TFREEZ=-9.0959E+04/(PSISV1-333.0)
      IF((TK1(NU(NY,NX),NY,NX).LT.TFREEZ
     2.AND.VOLW1(NU(NY,NX),NY,NX).GT.1.0E-12*VOLA(NU(NY,NX),NY,NX)
     3.AND.VOLI1(NU(NY,NX),NY,NX).LT.VOLA(NU(NY,NX),NY,NX))
     4.OR.(TK1(NU(NY,NX),NY,NX).GT.TFREEZ
     5.AND.VOLI1(NU(NY,NX),NY,NX).GT.1.0E-12*VOLA(NU(NY,NX),NY,NX)))THEN
      TFLX1=FGRD(NU(NY,NX),NY,NX)*(1.0/(1.0+TFREEZ*6.2913E-03) 
     2*(TFREEZ*4.19*(FLWL(3,NU(NY,NX),NY,NX)+FLWHL(3,NU(NY,NX),NY,NX))
     3+VHCP1(NU(NY,NX),NY,NX)*(TFREEZ-TK1(NU(NY,NX),NY,NX))
     4-HFLWL(3,NU(NY,NX),NY,NX)))
      IF(TFLX1.LT.0.0)THEN
      TFLX=AMAX1(-333.0*0.92*VOLI1(NU(NY,NX),NY,NX)*XNPH,TFLX1)
      ELSE
      TFLX=AMIN1(333.0*VOLW1(NU(NY,NX),NY,NX)*XNPH,TFLX1)
      ENDIF
      WFLX=-TFLX/333.0
      IF(WFLX.GT.0.0.AND.VOLI1(NU(NY,NX),NY,NX)
     2.GT.ZEROS(NY,NX))THEN
      WFLXL(3,NU(NY,NX),NY,NX)=WFLX 
      ELSEIF(WFLX.LT.0.0.AND.VOLW1(NU(NY,NX),NY,NX)
     2.GT.ZEROS(NY,NX))THEN
      WFLXL(3,NU(NY,NX),NY,NX)=WFLX 
      ELSE
      TFLX=0.0
      WFLXL(3,NU(NY,NX),NY,NX)=0.0
      ENDIF
      ELSE
      TFLX=0.0
      WFLXL(3,NU(NY,NX),NY,NX)=0.0
      ENDIF
C
C     FREEZE-THAW IN SOIL SURFACE MACROPORE FROM NET CHANGE IN SOIL 
C     SURFACE HEAT STORAGE
C
      IF((TK1(NU(NY,NX),NY,NX).LT.273.15.AND.VOLWH1(NU(NY,NX),NY,NX)
     2.GT.1.0E-12*VOLT(NU(NY,NX),NY,NX)).OR.(TK1(NU(NY,NX),NY,NX)
     3.GT.273.15.AND.VOLIH1(NU(NY,NX),NY,NX)
     4.GT.1.0E-12*VOLT(NU(NY,NX),NY,NX)))THEN
      TFLX1=FMAC(NU(NY,NX),NY,NX)*(1.0/(1.0+273.15*6.2913E-03) 
     2*(273.15*4.19*(FLWL(3,NU(NY,NX),NY,NX)+FLWHL(3,NU(NY,NX),NY,NX))
     3+VHCP1(NU(NY,NX),NY,NX)*(273.15-TK1(NU(NY,NX),NY,NX))
     4-HFLWL(3,NU(NY,NX),NY,NX)))
      IF(TFLX1.LT.0.0)THEN
      TFLXH=AMAX1(-333.0*0.92*VOLIH1(NU(NY,NX),NY,NX)*XNPH,TFLX1)
      ELSE
      TFLXH=AMIN1(333.0*VOLWH1(NU(NY,NX),NY,NX)*XNPH,TFLX1)
      ENDIF
      WFLXH=-TFLXH/333.0
      IF(WFLXH.GT.0.0.AND.VOLIH1(NU(NY,NX),NY,NX)
     2.GT.ZEROS(NY,NX))THEN
      WFLXLH(3,NU(NY,NX),NY,NX)=WFLXH 
      ELSEIF(WFLXH.LT.0.0.AND.VOLWH1(NU(NY,NX),NY,NX)
     2.GT.ZEROS(NY,NX))THEN
      WFLXLH(3,NU(NY,NX),NY,NX)=WFLXH 
      ELSE
      TFLXH=0.0
      WFLXLH(3,NU(NY,NX),NY,NX)=0.0
      ENDIF
      ELSE
      TFLXH=0.0
      WFLXLH(3,NU(NY,NX),NY,NX)=0.0
      ENDIF
      TFLXL(3,NU(NY,NX),NY,NX)=TFLX+TFLXH
C     IF(NY.EQ.1)THEN
C     WRITE(*,4358)'TFLX',I,J,M,TFREEZ,TK1(NU(NY,NX),NY,NX),PSISV1 
C    2,TFLX,TFLXH,TFLXL(3,NU(NY,NX),NY,NX),WFLX,WFLXH
C    2,WFLXL(3,NU(NY,NX),NY,NX),WFLXLH(3,NU(NY,NX),NY,NX)
C    4,VOLW1(NU(NY,NX),NY,NX),VOLWH1(NU(NY,NX),NY,NX)
C    4,VOLI1(NU(NY,NX),NY,NX),VOLIH1(NU(NY,NX),NY,NX)
C    5,FGRD(NU(NY,NX),NY,NX),FMAC(NU(NY,NX),NY,NX)
4358  FORMAT(A8,3I4,20E12.4)
C     ENDIF
C
C
C     THICKNESS OF WATER FILMS FOR GAS EXCHANGE IN 'TRNSFR'
C
      IF(VHCPR1(NY,NX).GT.VHCPRX(NY,NX))THEN
      FILM(M,0,NY,NX)=AMAX1(1.0E-06
     2,EXP(-13.650-0.857*LOG(-PSISM1(0,NY,NX))))
      ELSE
      FILM(M,0,NY,NX)=1.0E-03
      ENDIF
      IF(BKVL(NU(NY,NX),NY,NX).GT.0.0)THEN
      FILM(M,NU(NY,NX),NY,NX)=AMAX1(1.0E-06
     2,EXP(-13.650-0.857*LOG(-PSISM1(NU(NY,NX),NY,NX))))
      ELSE
      FILM(M,NU(NY,NX),NY,NX)=DLYR(3,NU(NY,NX),NY,NX)
      ENDIF
C
C     OVERLAND FLOW WHEN WATER STORAGE CAPACITY
C     OF THE SOIL SURFACE PLUS MACROPORES IS EXCEEDED
C
      N1=NX
      N2=NY
      TVOLZ1=AMAX1(0.0,VOLW1(0,N2,N1)+VOLI1(0,N2,N1)-VOLWRX(N2,N1))
      VOLWZ1=AMAX1(0.0,VOLW1(0,N2,N1)-VOLWRX(N2,N1))
C
C     LOCATE INTERNAL BOUNDARIES BETWEEN ADJACENT GRID CELLS
C
      DO 4310 N=1,2
      IF(N.EQ.1)THEN
      IF(NX.EQ.NHE)THEN
      GO TO 4310
      ELSE
      N4=NX+1
      N5=NY
      WDTH=DLYR(2,NU(NY,NX),NY,NX)
      ENDIF
      ELSEIF(N.EQ.2)THEN
      IF(NY.EQ.NVS)THEN
      GO TO 4310
      ELSE
      N4=NX
      N5=NY+1
      WDTH=DLYR(1,NU(NY,NX),NY,NX)
      ENDIF
      ENDIF
C
C     ELEVATION OF EACH PAIR OF ADJACENT GRID CELLS
C
      TVOLZ2=AMAX1(0.0,VOLW1(0,N5,N4)+VOLI1(0,N5,N4)-VOLWRX(N5,N4))
      VOLWZ2=AMAX1(0.0,VOLW1(0,N5,N4)-VOLWRX(N5,N4))
      ALT1=ALTG(N2,N1)+TVOLZ1/AREA(3,NU(N2,N1),N2,N1)
      ALT2=ALTG(N5,N4)+TVOLZ2/AREA(3,NU(N5,N4),N5,N4)
C
C     EXCESS SURFACE WATER DEPTH, WETTED PERIMETER, SLOPE, VELOCITY
C
      IF(ALT1.GT.ALT2.AND.TVOLZ1.GT.VOLWG(N2,N1))THEN
      QRX1=TVOLZ1-VOLWG(N2,N1)
      D=QRX1/AREA(3,NU(N2,N1),N2,N1)
      R=D/2.828
      S=(ALT1-ALT2)/DIST(N,NU(N5,N4),N5,N4)
      V=R**0.67*SQRT(S)/ZM(N2,N1)
C
C     RUNOFF
C
      Q=V*D*AMIN1(1.0,D/ZS(N2,N1))*WDTH*3.6E+03*XNPH
      QRQ1=AMAX1(0.0,((ALT1-ALT2)*AREA(3,NU(N2,N1),N2,N1)
     2*AREA(3,NU(N5,N4),N5,N4)-TVOLZ2*AREA(3,NU(N2,N1),N2,N1)
     3+TVOLZ1*AREA(3,NU(N5,N4),N5,N4))
     4/(AREA(3,NU(N2,N1),N2,N1)+AREA(3,NU(N5,N4),N5,N4)))
      QR1(N,N5,N4)=AMIN1(Q,0.25*QRQ1,0.25*QRX1)*VOLWZ1/TVOLZ1
      HQR1(N,N5,N4)=4.19*TK1(0,N2,N1)*QR1(N,N5,N4) 
C
C     EXCESS SURFACE WATER DEPTH, WETTED PERIMETER, SLOPE, VELOCITY
C
      ELSEIF(ALT1.LT.ALT2.AND.TVOLZ2.GT.VOLWG(N5,N4))THEN
      QRX1=TVOLZ2-VOLWG(N5,N4)
      D=QRX1/AREA(3,NU(N5,N4),N5,N4)
      R=D/2.828
      S=(ALT2-ALT1)/DIST(N,NU(N5,N4),N5,N4)
      V=R**0.67*SQRT(S)/ZM(N5,N4)
C
C     RUNON
C
      Q=V*D*AMIN1(1.0,D/ZS(N5,N4))*DLYR(N,NU(N5,N4),N5,N4)
     2*3.6E+03*XNPH
      QRQ1=AMIN1(0.0,((ALT1-ALT2)*AREA(3,NU(N2,N1),N2,N1)
     2*AREA(3,NU(N5,N4),N5,N4)-TVOLZ2*AREA(3,NU(N2,N1),N2,N1)
     3+TVOLZ1*AREA(3,NU(N5,N4),N5,N4))
     4/(AREA(3,NU(N2,N1),N2,N1)+AREA(3,NU(N5,N4),N5,N4)))
      QR1(N,N5,N4)=AMAX1(-Q,0.25*QRQ1,-0.25*QRX1)*VOLWZ2/TVOLZ2
      HQR1(N,N5,N4)=4.19*TK1(0,N5,N4)*QR1(N,N5,N4) 
      ELSE
      QR1(N,N5,N4)=0.0
      HQR1(N,N5,N4)=0.0
      V=0.0
      ENDIF
      QR(N,N5,N4)=QR(N,N5,N4)+QR1(N,N5,N4)
      HQR(N,N5,N4)=HQR(N,N5,N4)+HQR1(N,N5,N4)
      QRM(M,N,N5,N4)=QR1(N,N5,N4)
      QRV(M,N,N5,N4)=V
C     IF(I.EQ.186)THEN
C     WRITE(*,5555)'QR1',I,J,M,N1,N2,N4,N5,N,QR1(N,N5,N4) 
C    2,ALT1,ALT2,ALTG(N2,N1),ALTG(N5,N4),QRX1,D,R,S,V,Q,QRQ1
C    2,VOLW1(0,N2,N1),VOLI1(0,N2,N1)
C    3,VOLW1(0,N5,N4),VOLI1(0,N5,N4)
C    4,VOLWZ1,VOLWZ2,TVOLZ1,TVOLZ2,VOLWG(N2,N1),VOLWG(N5,N4)
C    5,QR(N,N5,N4),TVOLW(N5,N4),FVOLW2,FVOLH2 
C    6,DIST(N,NU(N5,N4),N5,N4)
5555  FORMAT(A8,8I4,30E12.4)
C     ENDIF
C
C     SNOW REDISTRIBUTION
C
      IF(VHCP0(NY,NX).GT.VHCPWX(NY,NX))THEN
      ALTS1=ALTG(N2,N1)+DPTHS0(N2,N1)
      ALTS2=ALTG(N5,N4)+DPTHS0(N5,N4)
C     IF(NU(3,3).EQ.1)THEN
C     IF(NU(N2,N1).EQ.1)THEN
C     ALTS1=ALTG(N2,N1)+0.15+DPTHS0(N2,N1)
C     ENDIF
C     IF(NU(N5,N4).EQ.1)THEN
C     ALTS2=ALTG(N5,N4)+0.15+DPTHS0(N5,N4)
C     ENDIF
C     ENDIF
      SS=(ALTS1-ALTS2)/DIST(N,NU(N5,N4),N5,N4)
      QSX=FQSM*SS
      QSM(M,N,N5,N4)=QSX
      IF(ALTS1.GT.ALTS2)THEN
      QS1(N,N5,N4)=QSX*VOLS0(N2,N1)
      QW1(N,N5,N4)=QSX*VOLW0(N2,N1)
      QI1(N,N5,N4)=QSX*VOLI0(N2,N1)
      QST1=QS1(N,N5,N4)+QW1(N,N5,N4)+QI1(N,N5,N4)
      HQS1(N,N5,N4)=4.19*TK0(N2,N1)*QST1
      ELSEIF(ALTS1.LT.ALTS2)THEN 
      QS1(N,N5,N4)=QSX*VOLS0(N5,N4)
      QW1(N,N5,N4)=QSX*VOLW0(N5,N4)
      QI1(N,N5,N4)=QSX*VOLI0(N5,N4)
      QST1=QS1(N,N5,N4)+QW1(N,N5,N4)+QI1(N,N5,N4)
      HQS1(N,N5,N4)=4.19*TK0(N5,N4)*QST1
      ELSE
      QS1(N,N5,N4)=0.0
      QW1(N,N5,N4)=0.0
      QI1(N,N5,N4)=0.0
      QST1=0.0
      HQS1(N,N5,N4)=0.0
      ENDIF
      QS(N,N5,N4)=QS(N,N5,N4)+QS1(N,N5,N4)
      QW(N,N5,N4)=QW(N,N5,N4)+QW1(N,N5,N4)
      QI(N,N5,N4)=QI(N,N5,N4)+QI1(N,N5,N4)
      HQS(N,N5,N4)=HQS(N,N5,N4)+HQS1(N,N5,N4)
      QSM(M,N,N5,N4)=QST1
      ELSE
      QS1(N,N5,N4)=0.0
      QW1(N,N5,N4)=0.0
      QI1(N,N5,N4)=0.0
      HQS1(N,N5,N4)=0.0
      QSM(M,N,N5,N4)=0.0
      ENDIF
C     WRITE(*,5556)'QS1',I,J,M,N1,N2,N4,N5,N,QSX,QS1(N,N5,N4)
C    2,QW1(N,N5,N4),QI1(N,N5,N4),VOLS0(N2,N1),VOLW0(N2,N1)
C    3,VOLI0(N2,N1),ALTS1,ALTS2,ALTG(N2,N1),ALTG(N5,N4)
C    4,DPTHS0(N2,N1),DPTHS0(N5,N4),DIST(N,NU(N5,N4),N5,N4) 
5556  FORMAT(A8,8I4,30E12.4)
4310  CONTINUE
C
C     TOTAL WATER, VAPOR AND HEAT FLUXES THROUGH SURFACE RESIDUE
C     AND SOIL SURFACE
C
      THAWR(NY,NX)=THAWR(NY,NX)+WFLXR(NY,NX)
      HTHAWR(NY,NX)=HTHAWR(NY,NX)+TFLXR(NY,NX)
      THAW(3,NU(NY,NX),NY,NX)=THAW(3,NU(NY,NX),NY,NX)
     2+WFLXL(3,NU(NY,NX),NY,NX)
      THAWH(3,NU(NY,NX),NY,NX)=THAWH(3,NU(NY,NX),NY,NX)
     2+WFLXLH(3,NU(NY,NX),NY,NX)
      HTHAW(3,NU(NY,NX),NY,NX)=HTHAW(3,NU(NY,NX),NY,NX)
     2+TFLXL(3,NU(NY,NX),NY,NX)
      FLW(3,NU(NY,NX),NY,NX)=FLW(3,NU(NY,NX),NY,NX)
     2+FLWL(3,NU(NY,NX),NY,NX)
      FLWX(3,NU(NY,NX),NY,NX)=FLWX(3,NU(NY,NX),NY,NX)
     2+FLWLX(3,NU(NY,NX),NY,NX)
      FLWH(3,NU(NY,NX),NY,NX)=FLWH(3,NU(NY,NX),NY,NX)
     2+FLWHL(3,NU(NY,NX),NY,NX)
      HFLW(3,NU(NY,NX),NY,NX)=HFLW(3,NU(NY,NX),NY,NX)
     2+HFLWL(3,NU(NY,NX),NY,NX)
      FLWR(NY,NX)=FLWR(NY,NX)+FLWRL(NY,NX)
      HFLWR(NY,NX)=HFLWR(NY,NX)+HFLWRL(NY,NX)
      HEATI(NY,NX)=HEATI(NY,NX)+RFLX+RFLXR
      HEATS(NY,NX)=HEATS(NY,NX)+SFLX+SFLXR
      HEATE(NY,NX)=HEATE(NY,NX)+EFLX+EFLXR
      HEATV(NY,NX)=HEATV(NY,NX)+VFLX+VFLXR
      HEATH(NY,NX)=HEATH(NY,NX)+RFLX+RFLXR
     2+SFLX+SFLXR+EFLX+EFLXR+VFLX+VFLXR
      TEVAPG(NY,NX)=TEVAPG(NY,NX)+EVAP(NY,NX)+EVAPS(NY,NX)+EVAPR(NY,NX)
      VOLWX1(NU(NY,NX),NY,NX)=VOLW1(NU(NY,NX),NY,NX)
      HYSM(M,NU(NY,NX),NY,NX)=HYST(NU(NY,NX),NY,NX)
      FLWM(M,3,NU(NY,NX),NY,NX)=FLWL(3,NU(NY,NX),NY,NX)
      FLWHM(M,3,NU(NY,NX),NY,NX)=FLWHL(3,NU(NY,NX),NY,NX)
C
C     DELAYED MIGRATION OF PRECIPITATION OR MELTWATER INTO MICROPORES
C
      IF(FLQM.GT.0.0.AND.VOLPX1(NU(NY,NX),NY,NX).GT.ZEROS(NY,NX)
     2.AND.HYST(NU(NY,NX),NY,NX).GT.ZERO)THEN
      HYST(NU(NY,NX),NY,NX)=AMIN1(1.0,AMAX1(0.0,HYST(NU(NY,NX),NY,NX)
     2-FLQM/VOLPX1(NU(NY,NX),NY,NX)))
      ENDIF
      HYST(NU(NY,NX),NY,NX)=HYST(NU(NY,NX),NY,NX)
     2+(1.0-HYST(NU(NY,NX),NY,NX))*HYSTX
C
C     WATER AND ENERGY TRANSFER THROUGH SOIL PROFILE
C
      IFLGH=0
      DO 4400 L=1,NL(NY,NX)
      N1=NX
      N2=NY
      N3=L
C
C     LOCATE INTERNAL BOUNDARIES BETWEEN ADJACENT GRID CELLS
C
      DO 4320 N=NCN(N2,N1),3
      IF(N.EQ.1)THEN
      IF(NX.EQ.NHE)THEN
      GO TO 4320
      ELSE
      N4=NX+1
      N5=NY
      N6=L
      ENDIF
      ELSEIF(N.EQ.2)THEN
      IF(NY.EQ.NVS)THEN
      GO TO 4320
      ELSE
      N4=NX
      N5=NY+1
      N6=L
      ENDIF
      ELSEIF(N.EQ.3)THEN
      IF(L.EQ.NL(NY,NX))THEN
      GO TO 4320
      ELSE
      N4=NX
      N5=NY
      N6=L+1
      ENDIF
      ENDIF
C
C     POROSITIES 'THETP*', WATER CONTENTS 'THETA*', AND POTENTIALS
C     'PSIS*' FOR EACH GRID CELL
C
      IF(N3.GE.NU(N2,N1).AND.N6.GE.NU(N5,N4)
     2.AND.N3.LE.NL(N2,N1).AND.N6.LE.NL(N5,N4))THEN
      THETP1=AMAX1(0.0,VOLPX1(N3,N2,N1)/VOLX(N3,N2,N1))
      THETPL=AMAX1(0.0,VOLPX1(N6,N5,N4)/VOLX(N6,N5,N4))
      THETA1=AMAX1(THETY(N3,N2,N1),AMIN1(POROS(N3,N2,N1)
     2,VOLW1(N3,N2,N1)/VOLX(N3,N2,N1)))
      THETAL=AMAX1(THETY(N6,N5,N4),AMIN1(POROS(N6,N5,N4)
     2,VOLW1(N6,N5,N4)/VOLX(N6,N5,N4)))
      IF(BKVL(N3,N2,N1).GT.0.0)THEN
      IF(THETA1.LT.FC(N3,N2,N1))THEN
      PSISA1=AMAX1(HYGR,-EXP(PSIMX(N2,N1)
     2+((FCL(N3,N2,N1)-LOG(THETA1))
     3/FCD(N3,N2,N1)*PSIMD(N2,N1))))
      ELSEIF(THETA1.LT.POROS(N3,N2,N1)-DTHETW)THEN 
      PSISA1=-EXP(PSIMS(N2,N1)
     2+(((PSL(N3,N2,N1)-LOG(THETA1))
     3/PSD(N3,N2,N1))**SRP(N3,N2,N1)*PSISD(N2,N1)))
      ELSE
      PSISA1=PSISE(N3,N2,N1) 
      ENDIF
      ELSE
      PSISA1=PSISE(N3,N2,N1) 
      ENDIF
      IF(BKVL(N6,N5,N4).GT.0.0)THEN
      IF(THETAL.LT.FC(N6,N5,N4))THEN
      PSISAL=AMAX1(HYGR,-EXP(PSIMX(N5,N4)
     2+((FCL(N6,N5,N4)-LOG(THETAL))
     3/FCD(N6,N5,N4)*PSIMD(N5,N4))))
      ELSEIF(THETAL.LT.POROS(N6,N5,N4)-DTHETW)THEN 
      PSISAL=-EXP(PSIMS(N5,N4)
     2+(((PSL(N6,N5,N4)-LOG(THETAL))
     3/PSD(N6,N5,N4))**SRP(N6,N5,N4)*PSISD(N5,N4)))
      ELSE
      PSISAL=PSISE(N6,N5,N4) 
      ENDIF
      ELSE
      PSISAL=PSISE(N6,N5,N4) 
      ENDIF
C     IF(J.GE.20)THEN
C     WRITE(*,7272)'PSIM',I,J,N1,N2,N3,N4,N5,N6,M,PSISM1(N6,N5,N4)
C    2,PSIMX(N5,N4),FCL(N6,N5,N4),THETWL,FCD(N6,N5,N4),PSIMD(N5,N4)
C    3,POROS(N6,N5,N4),PSIMS(N5,N4),PSL(N6,N5,N4),PSD(N6,N5,N4)
C    4,SRP(N6,N5,N4),PSISD(N5,N4),THETAL,PSISE(N6,N5,N4)
C    5,THETAL-POROS(N6,N5,N4),PSISA1,PSISAL
7272  FORMAT(A8,9I4,20E12.4)
C     ENDIF
C
C     DARCY FLOW IF BOTH CELLS ARE SATURATED
C     (CURRENT WATER POTENTIAL > AIR ENTRY WATER POTENTIAL)
C
      IF(PSISA1.GT.PSISA(N3,N2,N1)
     2.AND.PSISAL.GT.PSISA(N6,N5,N4))THEN
      THETW1=THETA1
      THETWL=THETAL
      CND1=HCND(N,1,N3,N2,N1)*XNPH
      CNDL=HCND(N,1,N6,N5,N4)*XNPH
      PSISM1(N3,N2,N1)=PSISA1
      PSISM1(N6,N5,N4)=PSISAL
      IF(PSISM1(N3,N2,N1).GE.PSISM1(N6,N5,N4)
     2.AND.VOLW1(N3,N2,N1).GT.ZEROS(N2,N1))THEN
      FLGX=VOLWX1(N3,N2,N1)/VOLW1(N3,N2,N1)
      ELSEIF(VOLW1(N6,N5,N4).GT.ZEROS(N5,N4))THEN
      FLGX=VOLWX1(N6,N5,N4)/VOLW1(N6,N5,N4)
      ELSE
      FLGX=0.0
      ENDIF
C
C     GREEN-AMPT FLOW IF ONE LAYER IS SATURATED
C     (CURRENT WATER POTENTIAL < AIR ENTRY WATER POENTIAL)
C
C
C     GREEN-AMPT FLOW IF SOURCE CELL SATURATED
C
      ELSEIF(PSISA1.GT.PSISA(N3,N2,N1))THEN
      THETW1=THETA1
      THETWL=AMAX1(THETY(N6,N5,N4),AMIN1(POROS(N6,N5,N4)
     2,VOLWX1(N6,N5,N4)/VOLX(N6,N5,N4)))
      CND1=HCND(N,1,N3,N2,N1)*XNPH
      CNDL=HCND(N,1,N6,N5,N4)*XNPH
      PSISM1(N3,N2,N1)=PSISA1
      IF(BKVL(N6,N5,N4).GT.0.0)THEN
      IF(THETWL.LT.FC(N6,N5,N4))THEN
      PSISM1(N6,N5,N4)=AMAX1(HYGR,-EXP(PSIMX(N5,N4)
     2+((FCL(N6,N5,N4)-LOG(THETWL))
     3/FCD(N6,N5,N4)*PSIMD(N5,N4))))
      ELSEIF(THETWL.LT.POROS(N6,N5,N4)-DTHETW)THEN 
      PSISM1(N6,N5,N4)=-EXP(PSIMS(N5,N4)
     2+(((PSL(N6,N5,N4)-LOG(THETWL))
     3/PSD(N6,N5,N4))**SRP(N6,N5,N4)*PSISD(N5,N4)))
      ELSE
      PSISM1(N6,N5,N4)=PSISE(N6,N5,N4)
      ENDIF
      ELSE
      PSISM1(N6,N5,N4)=PSISE(N6,N5,N4)
      ENDIF
      FLGX=0.0
C
C     GREEN-AMPT FLOW IF ADJACENT CELL SATURATED
C
      ELSEIF(PSISAL.GT.PSISA(N6,N5,N4))THEN
      THETW1=AMAX1(THETY(N3,N2,N1),AMIN1(POROS(N3,N2,N1)
     2,VOLWX1(N3,N2,N1)/VOLX(N3,N2,N1)))
      THETWL=THETAL
      CND1=HCND(N,1,N3,N2,N1)*XNPH
      CNDL=HCND(N,1,N6,N5,N4)*XNPH
      IF(BKVL(N3,N2,N1).GT.0.0)THEN
      IF(THETW1.LT.FC(N3,N2,N1))THEN
      PSISM1(N3,N2,N1)=AMAX1(HYGR,-EXP(PSIMX(N2,N1)
     2+((FCL(N3,N2,N1)-LOG(THETW1))
     3/FCD(N3,N2,N1)*PSIMD(N2,N1))))
      ELSEIF(THETW1.LT.POROS(N3,N2,N1)-DTHETW)THEN 
      PSISM1(N3,N2,N1)=-EXP(PSIMS(N2,N1)
     2+(((PSL(N3,N2,N1)-LOG(THETW1))
     3/PSD(N3,N2,N1))**SRP(N3,N2,N1)*PSISD(N2,N1)))
      ELSE
      PSISM1(N3,N2,N1)=PSISE(N3,N2,N1) 
      ENDIF
      ELSE
      PSISM1(N3,N2,N1)=PSISE(N3,N2,N1) 
      ENDIF
      FLGX=0.0
C
C     RICHARDS FLOW IF NEITHER CELL IS SATURATED
C     (CURRENT WATER POTENTIAL < AIR ENTRY WATER POTENTIAL)
C
      ELSE
      THETW1=THETA1
      THETWL=THETAL
      K1=MIN(100,INT(100.0*(POROS(N3,N2,N1)-THETA1)/POROS(N3,N2,N1))+1)
      CND1=HCND(N,K1,N3,N2,N1)*XNPH
      KL=MIN(100,INT(100.0*(POROS(N6,N5,N4)-THETAL)/POROS(N6,N5,N4))+1)
      CNDL=HCND(N,KL,N6,N5,N4)*XNPH
      PSISM1(N3,N2,N1)=PSISA1
      PSISM1(N6,N5,N4)=PSISAL
      IF(PSISM1(N3,N2,N1).GE.PSISM1(N6,N5,N4)
     2.AND.VOLW1(N3,N2,N1).GT.ZEROS(N2,N1))THEN
      FLGX=VOLWX1(N3,N2,N1)/VOLW1(N3,N2,N1)
      ELSEIF(VOLW1(N6,N5,N4).GT.ZEROS(N5,N4))THEN
      FLGX=VOLWX1(N6,N5,N4)/VOLW1(N6,N5,N4)
      ELSE
      FLGX=0.0
      ENDIF
      ENDIF
C
C     TOTAL SOIL WATER POTENTIAL = MATRIC, GRAVIMETRIC + OSMOTIC
C
      PSIST1=PSISM1(N3,N2,N1)+PSISH(N3,N2,N1)+0.03*PSISO(N3,N2,N1)
      PSISTL=PSISM1(N6,N5,N4)+PSISH(N6,N5,N4)+0.03*PSISO(N6,N5,N4)
      PSISV1=PSISM1(N3,N2,N1)+PSISO(N3,N2,N1)
      PSISVL=PSISM1(N6,N5,N4)+PSISO(N6,N5,N4)
C
C     HYDRAULIC CONDUCTIVITY FROM CURRENT WATER CONTENT
C     AND LOOKUP ARRAY GENERATED IN 'HOUR1'
C
      IF(CND1.GT.ZERO.AND.CNDL.GT.ZERO)THEN
      AVCNDL=2.0*CND1*CNDL/(CND1*DLYR(N,N6,N5,N4)
     2+CNDL*DLYR(N,N3,N2,N1)) 
      ELSE
      AVCNDL=0.0
      ENDIF
C
C     WATER FLUX FROM WATER POTENTIALS, HYDRAULIC CONDUCTIVITY
C     CONSTRAINED BY WATER POTENTIAL GRADIENT, COUPLED WITH
C     CONVECTIVE HEAT FLUX FROM WATER FLUX
C
      FLQX=AVCNDL*(PSIST1-PSISTL)*AREA(N,N3,N2,N1)
      IF(FLQX.GE.0.0)THEN
      FLQL=AMAX1(0.0,AMIN1(FLQX,VOLW1(N3,N2,N1)*XNPH
     2,VOLP1(N6,N5,N4)*XNPH))
      HWFLQL=4.19*TK1(N3,N2,N1)*FLQL
      ELSE
      FLQL=AMIN1(0.0,AMAX1(FLQX,-VOLW1(N6,N5,N4)*XNPH
     2,-VOLP1(N3,N2,N1)*XNPH))
      HWFLQL=4.19*TK1(N6,N5,N4)*FLQL
      ENDIF
      FLQ2=FLGX*FLQL
C
C     INFILTRATION OF WATER FROM MACROPORES INTO MICROPORES
C
      IF(N.EQ.3.AND.VOLWH1(N3,N2,N1).GT.ZEROS(N2,N1))THEN
      FINHX=XNPH*6.283*SCNH(N3,N2,N1)*AREA(3,N3,N2,N1)
     2*(PSISE(N3,N2,N1)-PSISM1(N3,N2,N1))
     3/LOG(PHOL(N3,N2,N1)/HRAD(N3,N2,N1))*DHOL(N3,N2,N1)
      IF(FINHX.GT.0.0)THEN
      FINHL(N3,N2,N1)=AMAX1(0.0,AMIN1(FINHX,VOLWH1(N3,N2,N1)
     2,VOLPX1(N3,N2,N1)))
      ELSE
      FINHL(N3,N2,N1)=AMIN1(0.0,AMAX1(FINHX,-VOLPH1(N3,N2,N1)
     2,VOLW1(N3,N2,N1)))
      ENDIF
      FINHM(M,N3,N2,N1)=FINHL(N3,N2,N1)
      FINH(N3,N2,N1)=FINH(N3,N2,N1)+FINHL(N3,N2,N1)
C     IF(NX.EQ.1.AND.NY.EQ.1)THEN
C     WRITE(*,3366)'FINHL',I,J,M,N1,N2,N3,IFLGH,FINHL(N3,N2,N1)
C    3,FINHX,VOLWH1(N3,N2,N1),VOLPH1(N3,N2,N1),VOLP1(N3,N2,N1)
C    4,PSISM1(N3,N2,N1),SCNH(N3,N2,N1),PHOL(N3,N2,N1)
C    5,HRAD(N3,N2,N1),DHOL(N3,N2,N1)
3366  FORMAT(A8,7I4,20E12.4)
C     ENDIF
      ELSE
      FINHL(N3,N2,N1)=0.0
      FINHM(M,N3,N2,N1)=0.0
      ENDIF
C
C     MACROPORE FLOW FROM POISEUILLE FLOW IF MACROPORES PRESENT
C
      IF(VOLAH1(N3,N2,N1).GT.ZEROS(N2,N1)
     2.AND.VOLAH1(N6,N5,N4).GT.ZEROS(N5,N4).AND.IFLGH.EQ.0)THEN
      PSISH1=PSISH(N3,N2,N1)+0.01*DLYR(3,N3,N2,N1)
     2*(AMIN1(1.0,AMAX1(0.0,VOLWH1(N3,N2,N1)/VOLAH1(N3,N2,N1)))-0.5)
      PSISHL=PSISH(N6,N5,N4)+0.01*DLYR(3,N6,N5,N4)
     2*(AMIN1(1.0,AMAX1(0.0,VOLWH1(N6,N5,N4)/VOLAH1(N6,N5,N4)))-0.5)
      FLWHX=AVCNHL(N,N6,N5,N4)*(PSISH1-PSISHL)*AREA(N,N3,N2,N1)
C
C     MACROPORE FLOW IF GRAVITATIONAL GRADIENT IS POSITIVE
C     AND MACROPORE POROSITY EXISTS IN ADJACENT CELL
C
      IF(N.NE.3)THEN
      IF(PSISH1.GT.PSISHL)THEN
      FLWHL(N,N6,N5,N4)=AMAX1(0.0,AMIN1(AMIN1(VOLWH1(N3,N2,N1)
     2,OVOLPH*VOLPH1(N6,N5,N4))*XDIM,FLWHX))
      ELSEIF(PSISH1.LT.PSISHL)THEN
      FLWHL(N,N6,N5,N4)=AMIN1(0.0,AMAX1(AMAX1(-VOLWH1(N6,N5,N4)
     2,-OVOLPH*VOLPH1(N3,N2,N1))*XDIM,FLWHX))
      ELSE
      FLWHL(N,N6,N5,N4)=0.0
      ENDIF
      ELSE
      FLWHL(N,N6,N5,N4)=AMAX1(0.0,AMIN1(AMIN1(VOLWH1(N3,N2,N1)
     2+FLWHL(N,N3,N2,N1)-FINHL(N3,N2,N1)
     3,OVOLPH*VOLPH1(N6,N5,N4))*XDIM,FLWHX))
      ENDIF
      FLWHM(M,N,N6,N5,N4)=FLWHL(N,N6,N5,N4)
C     IF(NX.EQ.4.AND.L.EQ.14)THEN
C     WRITE(*,5478)'FLWH',I,J,M,N1,N2,N3,IFLGH
C    2,FINHL(N3,N2,N1),FLHM,FLWHX,FLWHL(N,N3,N2,N1),FLWHL(N,N6,N5,N4) 
C    2,AVCNHL(N,N6,N5,N4),PSISH(N3,N2,N1),PSISH(N6,N5,N4) 
C    3,VOLPH1(N3,N2,N1),VOLPH1(N6,N5,N4),VOLWH1(N3,N2,N1)
C    4,VOLWH1(N6,N5,N4),VOLAH1(N3,N2,N1),VOLAH1(N6,N5,N4)
C    5,DLYR(N,N6,N5,N4),DLYR(N,N3,N2,N1),AREA(N,N3,N2,N1)
C    7,CNDH1(N3,N2,N1),CNDH1(N6,N5,N4),XNPH,XDIM,HWFLHL 
5478  FORMAT(A8,7I4,30E12.4)
C     ENDIF
      ELSE
      FLWHL(N,N6,N5,N4)=0.0
      FLWHM(M,N,N6,N5,N4)=0.0
      IF(VOLPH1(N6,N5,N4).LE.0.0)IFLGH=1
      ENDIF
C
C     CONVECTIVE HEAT FLOW FROM MACROPORE FLOW
C
      IF(FLWHL(N,N6,N5,N4).GT.0.0)THEN
      HWFLHL=4.19*TK1(N3,N2,N1)*FLWHL(N,N6,N5,N4)
      ELSE
      HWFLHL=4.19*TK1(N6,N5,N4)*FLWHL(N,N6,N5,N4)
      ENDIF
C
C     VAPOR PRESSURE AND DIFFUSIVITY IN EACH GRID CELL
C
      TK11=TK1(N3,N2,N1)
      TK12=TK1(N6,N5,N4)
      VP1=2.173E-03/TK11
     2*0.61*EXP(5360.0*(3.661E-03-1.0/TK11))
     3*EXP(18.0*PSISV1/(8.3143*TK11))
      VPL=2.173E-03/TK12
     2*0.61*EXP(5360.0*(3.661E-03-1.0/TK12))
     3*EXP(18.0*PSISVL/(8.3143*TK12))
      CNV1=THETP1**2/POROQ(N3,N2,N1)*WGSG1(N3,N2,N1)
      CNVL=THETPL**2/POROQ(N6,N5,N4)*WGSG1(N6,N5,N4) 
      IF(CNV1.GT.ZERO.AND.CNVL.GT.ZERO)THEN
      AVCNVL=2.0*CNV1*CNVL
     2/(CNV1*DLYR(N,N6,N5,N4)+CNVL*DLYR(N,N3,N2,N1))
      ELSE
      AVCNVL=0.0
      ENDIF
C
C     VAPOR FLUX FROM VAPOR PRESSURE AND DIFFUSIVITY,
C     AND CONVECTIVE HEAT FLUX FROM VAPOR FLUX
C
      TKY=(VHCP1(N3,N2,N1)*TK1(N3,N2,N1)+VHCP1(N6,N5,N4)*TK1(N6,N5,N4))
     2/(VHCP1(N3,N2,N1)+VHCP1(N6,N5,N4))
      HFLWX=(TKY-TK1(N6,N5,N4))*VHCP1(N6,N5,N4)*FHFLX*XDIM 
      FLVX=AVCNVL*(VP1-VPL)*AREA(N,N3,N2,N1)
      IF(FLVX.GE.0.0)THEN
      FLVL=AMIN1(FLVX,VOLW1(N3,N2,N1)*XNPH)
      IF(HFLWX.GE.0.0)THEN
      FLVL=AMIN1(FLVL,HFLWX/(4.19*TK1(N3,N2,N1)+VAP))
      ENDIF
      HWFLVL=(4.19*TK1(N3,N2,N1)+VAP)*FLVL
      ELSE
      FLVL=AMAX1(FLVX,-VOLW1(N6,N5,N4)*XNPH)
      IF(HFLWX.LT.0.0)THEN
      FLVL=AMAX1(FLVL,HFLWX/(4.19*TK1(N6,N5,N4)+VAP))
      ENDIF
      HWFLVL=(4.19*TK1(N6,N5,N4)+VAP)*FLVL
      ENDIF
      HWFLWL=HWFLQL+HWFLVL
      FLWL(N,N6,N5,N4)=FLQL+FLVL
      FLWLX(N,N6,N5,N4)=FLQ2+FLVL
C     IF(J.EQ.15/)THEN
C     WRITE(*,1115)'FLWL',I,J,M,N4,N5,N6,N,K1,KL,FLWL(N,N3,N2,N1)
C    2,FLWL(N,N6,N5,N4),FLQL,FLVL,FLQX,FLVX,HFLWX,FLWLY,FLWHY
C    3,CND1,CNDL,AVCNDL,AVCNVL,VP1,VPL,PSIST1,PSISTL 
C    4,UAG,VOLA(N6,N5,N4),VOLI1(N6,N5,N4),SCNV(N6,N5,N4),THETP1 
C    5,THETPL,VOLPX1(N3,N2,N1),VOLPX1(N6,N5,N4)
C    7,TK1(N3,N2,N1),TK1(N6,N5,N4),VOLT(N3,N2,N1),VOLT(N6,N5,N4)
C    8,VOLW1(N6,N5,N4),VOLP1(N6,N5,N4),VOLX(N6,N5,N4),VOLW1(N3,N2,N1) 
C    9,VOLP1(N3,N2,N1),VOLX(N3,N2,N1),POROS(N6,N5,N4),POROS(N3,N2,N1)
C    6,THETW1,THETWL,THETK1,THETKL,PSISA1,PSISAL,PSISM1(N3,N2,N1)
C    7,PSISM1(N6,N5,N4),PSISH(N3,N2,N1),PSISH(N6,N5,N4)
C    8,DLYR(N,N3,N2,N1),DLYR(N,N6,N5,N4)
C    8,AREA(N,N3,N2,N1)
1115  FORMAT(A8,9I4,60E12.4)
C     ENDIF
C
C     THERMAL CONDUCTIVITY
C
      DTKX=ABS(TK1(N3,N2,N1)-TK1(N6,N5,N4))*1.0E-06
      DTHW1=AMAX1(0.0,THETWX(N3,N2,N1)-TTRB)**3 
      DTHP1=AMAX1(0.0,THETPX(N3,N2,N1)-TTRB)**3 
      DTHW2=AMAX1(0.0,THETWX(N6,N5,N4)-TTRB)**3 
      DTHP2=AMAX1(0.0,THETPX(N6,N5,N4)-TTRB)**3 
      RYLNW1=DTKX*DTHW1 
      RYLNP1=DTKX*DTHP1 
      RYLNW2=DTKX*DTHW2 
      RYLNP2=DTKX*DTHP2 
      RYLNQ1=AMIN1(1.0E+04,RYLXQ*RYLNW1)  
      RYLNA1=AMIN1(1.0E+04,RYLXA*RYLNP1)
      RYLNQ2=AMIN1(1.0E+04,RYLXQ*RYLNW2)  
      RYLNA2=AMIN1(1.0E+04,RYLXA*RYLNP2)
      XNUSQ1=AMAX1(1.0,0.68+0.67*RYLNQ1**0.25/DNUSQ)
      XNUSA1=AMAX1(1.0,0.68+0.67*RYLNA1**0.25/DNUSA)
      XNUSQ2=AMAX1(1.0,0.68+0.67*RYLNQ2**0.25/DNUSQ)
      XNUSA2=AMAX1(1.0,0.68+0.67*RYLNA2**0.25/DNUSA)
      TCNDQ1=2.067E-03*XNUSQ1
      TCNDA1=9.050E-05*XNUSA1  
      TCNDQ2=2.067E-03*XNUSQ2
      TCNDA2=9.050E-05*XNUSA2  
      TCND1=(STC(N3,N2,N1)+THETWX(N3,N2,N1)*TCNDQ1
     2+0.611*THETIX(N3,N2,N1)*7.844E-03+1.609*THETPX(N3,N2,N1)*TCNDA1)
     3/(DTC(N3,N2,N1)+THETWX(N3,N2,N1)+0.611*THETIX(N3,N2,N1)
     2+1.609*THETPX(N3,N2,N1))
      TCND2=(STC(N6,N5,N4)+THETWX(N6,N5,N4)*TCNDQ2
     2+0.611*THETIX(N6,N5,N4)*7.844E-03+1.609*THETPX(N6,N5,N4)*TCNDA2)
     3/(DTC(N6,N5,N4)+THETWX(N6,N5,N4)+0.611*THETIX(N6,N5,N4)
     2+1.609*THETPX(N6,N5,N4))
      ATCND1=(2.0*TCND1*TCND2)/(TCND1*DLYR(N,N6,N5,N4) 
     3+TCND2*DLYR(N,N3,N2,N1))*XNPH
C
C     HEAT FLOW FROM THERMAL CONDUCTIVITY AND TEMPERATURE GRADIENT
C
      TK1X=TK1(N3,N2,N1)-HWFLVL/VHCP1(N3,N2,N1)
      TKLX=TK1(N6,N5,N4)+HWFLVL/VHCP1(N6,N5,N4) 
      TKY=(VHCP1(N3,N2,N1)*TK1X+VHCP1(N6,N5,N4)*TKLX)
     2/(VHCP1(N3,N2,N1)+VHCP1(N6,N5,N4))
      HFLWX=(TKY-TKLX)*VHCP1(N6,N5,N4)*FHFLX*XDIM 
      HFLWC=ATCND1*(TK1X-TKLX)*AREA(N,N3,N2,N1)
      IF(HFLWC.GE.0.0)THEN
      HFLWC=AMAX1(0.0,AMIN1(HFLWC,HFLWX))
      ELSE
      HFLWC=AMIN1(0.0,AMAX1(HFLWC,HFLWX))
      ENDIF
      HFLWL(N,N6,N5,N4)=HWFLWL+HWFLHL+HFLWC
C     IF(J.EQ.15.AND.N.EQ.3)THEN
C     WRITE(*,8765)'HFLWL',I,J,N4,N5,N6,N,M,HFLWL(N,N6,N5,N4)
C    2,TCND1,TCND2,ATCND1,STC(N3,N2,N1),THETWX(N3,N2,N1),TCNDQ
C    3,THETIX(N3,N2,N1),THETPX(N3,N2,N1),TCNDA,DTC(N3,N2,N1)
C    4,STC(N6,N5,N4),THETWX(N6,N5,N4),THETIX(N6,N5,N4)
C    5,THETPX(N6,N5,N4),DTC(N6,N5,N4),TKQ(N5,N4),TKA(NY,NX) 
C    6,TK1(N3,N2,N1),TK1(N6,N5,N4),RYLNW,RYLNP,RYLNQ,RYLNA
C    7,PRNTQ,PRNTA,XNUSQ,XNUSA,HWFLWL,HWFLHL,HFLWC,HFLWX,HWFLVL
C    8,TK1X,TKLX,HFLWL(N,N3,N2,N1),VHCP1(N3,N2,N1),VHCP1(N6,N5,N4)
8765  FORMAT(A8,7I4,60E12.4)
C     ENDIF
C
C     MOVE WATER UP DURING PRECIPITATION OR FREEZING
C 
      IF(N.EQ.3)THEN
      IF(VOLP1(N6,N5,N4).LT.0.0)THEN
      FLWLY=XNPH*AMIN1(0.0,AMAX1(-VOLW1(N6,N5,N4)
     2,VOLA(N6,N5,N4)-VOLW1(N6,N5,N4)-VOLI1(N6,N5,N4)))
      HFLWLY=FLWLY*4.19*TK1(N6,N5,N4) 
      FLWL(N,N6,N5,N4)=FLWL(N,N6,N5,N4)+FLWLY 
      HFLWL(N,N6,N5,N4)=HFLWL(N,N6,N5,N4)+HFLWLY 
      ENDIF
      IF(VOLPH1(N6,N5,N4).LE.0.0)THEN
      FLWHY=AMIN1(0.0,AMAX1(-VOLWH1(N6,N5,N4)
     2,VOLAH1(N6,N5,N4)-VOLWH1(N6,N5,N4)-VOLIH1(N6,N5,N4)))
      HFLWHY=FLWHY*4.19*TK1(N6,N5,N4) 
      FLWHL(N,N6,N5,N4)=FLWHL(N,N6,N5,N4)+FLWHY 
      HFLWL(N,N6,N5,N4)=HFLWL(N,N6,N5,N4)+HFLWHY 
      ENDIF
      IF(PSISAL.GT.PSISA(N6,N5,N4))THEN
      FLWVL(N6,N5,N4)=VOLW1(N6,N5,N4)-VOLWX1(N6,N5,N4)
      ELSE
      FLWVL(N6,N5,N4)=RFLWV(N5,N4)*(VOLW1(N6,N5,N4)-VOLWX1(N6,N5,N4))
      ENDIF
      FLWV(N6,N5,N4)=FLWV(N6,N5,N4)+FLWVL(N6,N5,N4)
      ENDIF
C
C     FREEZE-THAW IN SOIL LAYER MICROPORE FROM NET CHANGE IN SOIL 
C     LAYER HEAT STORAGE
C
      IF(N.EQ.3)THEN
      TFREEZ=-9.0959E+04/(PSISVL-333.0)
      IF((TK1(N6,N5,N4).LT.TFREEZ
     2.AND.VOLW1(N6,N5,N4).GT.1.0E-12*VOLA(N6,N5,N4)
     3.AND.VOLI1(N6,N5,N4).LT.VOLA(N6,N5,N4))
     4.OR.(TK1(N6,N5,N4).GT.TFREEZ
     5.AND.VOLI1(N6,N5,N4).GT.1.0E-12*VOLT(N6,N5,N4)))THEN
      TFLX1=FGRD(N6,N5,N4)*(1.0/(1.0+TFREEZ*6.2913E-03)
     2*(TFREEZ*4.19*(FLWL(N,N6,N5,N4)+FLWHL(N,N6,N5,N4))
     2+VHCP1(N6,N5,N4)*(TFREEZ-TK1(N6,N5,N4))
     3-HFLWL(N,N6,N5,N4)))
      IF(TFLX1.LT.0.0)THEN
      TFLX=AMAX1(-333.0*0.92*VOLI1(N6,N5,N4)*XNPH,TFLX1)
      ELSE
      TFLX=AMIN1(333.0*VOLW1(N6,N5,N4)*XNPH,TFLX1)
      ENDIF
      WFLX=-TFLX/333.0
      IF(WFLX.GT.0.0.AND.VOLI1(N6,N5,N4).GT.ZEROS(N5,N4))THEN
      WFLXL(N,N6,N5,N4)=WFLX 
      ELSEIF(WFLX.LT.0.0.AND.VOLW1(N6,N5,N4).GT.ZEROS(N5,N4))THEN
      WFLXL(N,N6,N5,N4)=WFLX
      ELSE
      TFLX=0.0
      WFLXL(N,N6,N5,N4)=0.0 
      ENDIF 
      ELSE
      TFLX=0.0
      WFLXL(N,N6,N5,N4)=0.0
      ENDIF
C
C     FREEZE-THAW IN SOIL LAYER MACROPORE FROM NET CHANGE IN SOIL 
C     LAYER HEAT STORAGE
C
      IF((TK1(N6,N5,N4).LT.273.15.AND.VOLWH1(N6,N5,N4)
     2.GT.1.0E-12*VOLT(N6,N5,N4)).OR.(TK1(N6,N5,N4).GT.273.15
     3.AND.VOLIH1(N6,N5,N4).GT.1.0E-12*VOLT(N6,N5,N4)))THEN
      TFLX1=FMAC(N6,N5,N4)*(1.0/(1.0+273.15*6.2913E-03)
     2*(273.15*4.19*(FLWL(N,N6,N5,N4)+FLWHL(N,N6,N5,N4))
     2+VHCP1(N6,N5,N4)*(273.15-TK1(N6,N5,N4))
     3-HFLWL(N,N6,N5,N4)))
      IF(TFLX1.LT.0.0)THEN
      TFLXH=AMAX1(-333.0*0.92*VOLIH1(N6,N5,N4)*XNPH,TFLX1)
      ELSE
      TFLXH=AMIN1(333.0*VOLWH1(N6,N5,N4)*XNPH,TFLX1)
      ENDIF
      WFLXH=-TFLXH/333.0
      IF(WFLXH.GT.0.0.AND.VOLIH1(N6,N5,N4).GT.ZEROS(N5,N4))THEN
      WFLXLH(N,N6,N5,N4)=WFLXH 
      ELSEIF(WFLXH.LT.0.0.AND.VOLWH1(N6,N5,N4).GT.ZEROS(N5,N4))THEN
      WFLXLH(N,N6,N5,N4)=WFLXH 
      ELSE
      TFLXH=0.0
      WFLXLH(N,N6,N5,N4)=0.0 
      ENDIF 
      ELSE
      TFLXH=0.0
      WFLXLH(N,N6,N5,N4)=0.0
      ENDIF
      TFLXL(N,N6,N5,N4)=TFLX+TFLXH
C     IF(NY.EQ.1)THEN
C     WRITE(*,4359)'TFLX',I,J,M,N4,N5,N6,TFREEZ,TK1(N6,N5,N4),PSISVL 
C    2,TFLX,TFLXH,TFLXL(N,N6,N5,N4),WFLX,WFLXH
C    2,WFLXL(N,N6,N5,N4),WFLXLH(N,N6,N5,N4)
C    4,VOLW1(N6,N5,N4),VOLWH1(N6,N5,N4)
C    4,VOLI1(N6,N5,N4),VOLIH1(N6,N5,N4)
C    5,FGRD(N6,N5,N4),FMAC(N6,N5,N4)
4359  FORMAT(A8,6I4,20E12.4)
C     ENDIF
      ENDIF
C
C     TOTAL WATER, VAPOR AND HEAT FLUXES
C
      THAW(N,N6,N5,N4)=THAW(N,N6,N5,N4)+WFLXL(N,N6,N5,N4)
      THAWH(N,N6,N5,N4)=THAWH(N,N6,N5,N4)+WFLXLH(N,N6,N5,N4)
      HTHAW(N,N6,N5,N4)=HTHAW(N,N6,N5,N4)+TFLXL(N,N6,N5,N4)
      FLW(N,N6,N5,N4)=FLW(N,N6,N5,N4)+FLWL(N,N6,N5,N4)
      FLWX(N,N6,N5,N4)=FLWX(N,N6,N5,N4)+FLWLX(N,N6,N5,N4)
      FLWH(N,N6,N5,N4)=FLWH(N,N6,N5,N4)+FLWHL(N,N6,N5,N4)
      HFLW(N,N6,N5,N4)=HFLW(N,N6,N5,N4)+HFLWL(N,N6,N5,N4)
      FLWM(M,N,N6,N5,N4)=FLWL(N,N6,N5,N4)
      IF(N.EQ.3)THEN
      HYSM(M,N6,N5,N4)=HYST(N6,N5,N4)
      IF(PSISA1.GT.PSISA(N3,N2,N1).AND.VOLPX1(N6,N5,N4).GT.ZEROS(N5,N4)
     2.AND.HYST(N6,N5,N4).GT.ZERO)THEN
      HYST(N6,N5,N4)=AMIN1(1.0,AMAX1(0.0,HYST(N6,N5,N4)
     2-FLWL(N,N6,N5,N4)/VOLPX1(N6,N5,N4)))
      ENDIF
C
C     WATER FILM THICKNESS FOR CALCULATING GAS EXCHANGE IN 'TRNSFR'
C
      IF(BKVL(N6,N5,N4).GT.0.0)THEN
      FILM(M,N6,N5,N4)=AMAX1(1.0E-06
     2,EXP(-13.833-0.857*LOG(-PSISM1(N6,N5,N4))))
      ELSE
      FILM(M,N6,N5,N4)=DLYR(3,N6,N5,N4)
      ENDIF
      HYST(N6,N5,N4)=HYST(N6,N5,N4)+(1.0-HYST(N6,N5,N4))*HYSTX
      ENDIF
      ELSEIF(N.NE.3)THEN
      FLWL(N,N6,N5,N4)=0.0
      FLWLX(N,N6,N5,N4)=0.0
      FLWHL(N,N6,N5,N4)=0.0
      HFLWL(N,N6,N5,N4)=0.0
      FLWHM(M,N,N6,N5,N4)=0.0
      ENDIF
4320  CONTINUE
4400  CONTINUE
9890  CONTINUE
9895  CONTINUE
C
C     BOUNDARY WATER AND HEAT FLUXES
C
      DO 9595 NX=NHW,NHE
      DO 9590 NY=NVN,NVS
      DO 9585 L=NU(NY,NX),NL(NY,NX)
      TVOLZ1=TVOL1(NY,NX) 
      VOLWZ1=TVOLW(NY,NX)
      VOLP2=VOLP1(L,NY,NX)
      VOLPX2=VOLPX1(L,NY,NX)
      VOLPH2=VOLPH1(L,NY,NX)
C
C     IDENTIFY CONDITIONS FOR MICROPRE DISCHARGE TO WATER TABLE
C
      IF(IPRC(NY,NX).NE.0.AND.DPTH(L,NY,NX).LT.DTBLX(NY,NX))THEN
      IF(PSISM1(L,NY,NX).GE.PSISE(L,NY,NX)
     2+0.01*(DPTH(L,NY,NX)-DTBLX(NY,NX)))THEN
      IFLGU=0
      DO 9565 LL=MIN(L+1,NL(NY,NX)),NL(NY,NX)
      IF(CDPTH(LL,NY,NX).LT.DTBLX(NY,NX))THEN
      IF((PSISM1(LL,NY,NX).LT.PSISA(LL,NY,NX).AND.L.NE.NL(NY,NX)) 
     2.OR.CDPTH(LL,NY,NX).GT.DPTHA(NY,NX))THEN
      IFLGU=1
      ENDIF
      ENDIF
9565  CONTINUE
      ELSE
      IFLGU=1
      ENDIF
      ELSE
      IFLGU=1
      ENDIF
C
C     IDENTIFY CONDITIONS FOR MACROPORE DISCHARGE TO WATER TABLE
C
      IF(VOLAH1(L,NY,NX).GT.ZEROS(NY,NX))THEN
      DPTHH=CDPTH(L,NY,NX)-(VOLWH1(L,NY,NX)+VOLIH1(L,NY,NX))
     2/VOLAH1(L,NY,NX)*DLYR(3,L,NY,NX)
      ELSE
      DPTHH=CDPTH(L,NY,NX)
      ENDIF
      IF(IPRC(NY,NX).NE.0.AND.DPTHH.LT.DTBLX(NY,NX)
     2.AND.VOLWH1(L,NY,NX).GT.ZEROS(NY,NX))THEN
      IFLGUH=0
      ELSE
      IFLGUH=1
      ENDIF
C     IF((I/30)*30.EQ.I.AND.M.EQ.1)THEN
C     WRITE(*,9567)'IFLGU',I,J,M,NX,NY,L,IFLGU,IFLGUH,PSISM1(L,NY,NX)
C    2,PSISE(L,NY,NX),DPTH(L,NY,NX),DTBLX(NY,NX),PSISE(L,NY,NX)
C    2+0.01*(DPTH(L,NY,NX)-DTBLX(NY,NX)),THETPY,THETX
C    3,VOLAH1(L,NY,NX),VOLWH1(L,NY,NX),VOLIH1(L,NY,NX),CDPTH(L,NY,NX)
C    4,DLYR(3,L,NY,NX),DTBLX(NY,NX),DPTHH
9567  FORMAT(A8,8I4,20E12.4)
C     ENDIF 
C
C     LOCATE ALL EXTERNAL BOUNDARIES AND SET BOUNDARY CONDITIONS
C     ENTERED IN 'READS'
C
      N1=NX
      N2=NY
      N3=L
      DO 9580 N=1,3
      DO 9575 NN=1,2
      IF(N.EQ.1)THEN
      N4=NX+1
      N5=NY
      N6=L
      WDTH=DLYR(2,NU(NY,NX),NY,NX)
      IF(NN.EQ.1)THEN
      IF(NX.EQ.NHE)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX+1
      M5=NY
      M6=L
      XN=-1.0
      RCHQF=RCHQE1(M2,M1)
      RCHGFU=RCHGEU1(M2,M1)
      RCHGFT=RCHGET1(M2,M1)
      ELSE
      GO TO 9575
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      IF(NX.EQ.NHW)THEN
      M1=NX+1
      M2=NY
      M3=L
      M4=NX
      M5=NY
      M6=L
      XN=1.0
      RCHQF=RCHQW1(M5,M4)
      RCHGFU=RCHGWU1(M5,M4)
      RCHGFT=RCHGWT1(M5,M4)
      ELSE
      GO TO 9575
      ENDIF
      ENDIF
      ELSEIF(N.EQ.2)THEN
      N4=NX
      N5=NY+1
      N6=L
      WDTH=DLYR(1,NU(NY,NX),NY,NX)
      IF(NN.EQ.1)THEN
      IF(NY.EQ.NVS)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY+1
      M6=L
      XN=-1.0
      RCHQF=RCHQS1(M2,M1)
      RCHGFU=RCHGSU1(M2,M1)
      RCHGFT=RCHGST1(M2,M1)
      ELSE
      GO TO 9575
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      IF(NY.EQ.NVN)THEN
      M1=NX
      M2=NY+1
      M3=L
      M4=NX
      M5=NY
      M6=L
      XN=1.0
      RCHQF=RCHQN1(M5,M4)
      RCHGFU=RCHGNU1(M5,M4)
      RCHGFT=RCHGNT1(M5,M4)
      ELSE
      GO TO 9575
      ENDIF
      ENDIF
      ELSEIF(N.EQ.3)THEN
      N4=NX
      N5=NY
      N6=L+1
      IF(NN.EQ.1)THEN
      IF(L.EQ.NL(NY,NX))THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY
      M6=L+1
      XN=-1.0
      RCHGFU=RCHGD1(M2,M1)
      RCHGFT=RCHGD1(M2,M1)
      ELSE
      GO TO 9575
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      GO TO 9575
      ENDIF
      ENDIF
C
C     BOUNDARY SURFACE RUNOFF DEPENDING ON ASPECT, SLOPE
C     VELOCITY, HYDRAULIC RADIUS AND SURFACE WATER STORAGE
C
      IF(L.EQ.NU(N2,N1).AND.N.NE.3)THEN
      IF(IRCHG(NN,N,N2,N1).EQ.0.OR.RCHQF.EQ.0.0)THEN
      V=0.0
      QR1(N,M5,M4)=0.0
      HQR1(N,M5,M4)=0.0
      ELSE
C
C     RUNOFF
C
      ALT1=ALTG(N2,N1)+TVOLZ1/AREA(3,NU(N2,N1),N2,N1)
      ALT2=ALTG(N2,N1)+VOLWG(N2,N1)/AREA(3,NU(N2,N1),N2,N1)
     2-GSIN(N2,N1)*DLYR(N,NU(N2,N1),N2,N1)
      IF(ALT1.GT.ALT2.AND.TVOLZ1.GT.VOLWG(N2,N1))THEN
      QRX1=TVOLZ1-VOLWG(N2,N1)
      D=QRX1/AREA(3,0,N2,N1)
      R=D/2.828
      S=(ALT1-ALT2)/DLYR(N,NU(N2,N1),N2,N1)
      V=R**0.67*SQRT(S)/ZM(N2,N1) 
      Q=V*D*AMIN1(1.0,D/ZS(N2,N1))*WDTH*3.6E+03*XNPH*RCHQF
      QR1(N,M5,M4)=-XN*AMIN1(Q,0.25*QRX1)*VOLWZ1/TVOLZ1*RCHQF
      HQR1(N,M5,M4)=4.19*TK1(0,N2,N1)*QR1(N,M5,M4) 
      VOLWZ1=VOLWZ1+XN*QR1(N,M5,M4)
      TVOLZ1=TVOLZ1+XN*QR1(N,M5,M4)
      ELSEIF(DTBLX(N2,N1).LT.0.0)THEN
C
C     RUNON
C
      QRX1=AMIN1(0.0,DTBLX(N2,N1)+TVOLZ1/AREA(3,NU(N2,N1),N2,N1))
     2*AREA(3,NU(N2,N1),N2,N1)
      QR1(N,M5,M4)=-XN*0.25*QRX1*RCHQF
      HQR1(N,M5,M4)=4.19*TK1(0,N2,N1)*QR1(N,M5,M4) 
      VOLWZ1=VOLWZ1+XN*QR1(N,M5,M4)
      TVOLZ1=TVOLZ1+XN*QR1(N,M5,M4)
      ELSE
      V=0.0
      QR1(N,M5,M4)=0.0
      HQR1(N,M5,M4)=0.0
      ENDIF
      QR(N,M5,M4)=QR(N,M5,M4)+QR1(N,M5,M4)
      HQR(N,M5,M4)=HQR(N,M5,M4)+HQR1(N,M5,M4)
      QRM(M,N,M5,M4)=QR1(N,M5,M4)
      QRV(M,N,M5,M4)=V
      QS1(N,M5,M4)=0.0
      QW1(N,M5,M4)=0.0
      QI1(N,M5,M4)=0.0
      HQS1(N,M5,M4)=0.0
      QS(N,M5,M4)=QS(N,M5,M4)+QS1(N,M5,M4)
      QW(N,M5,M4)=QW(N,M5,M4)+QW1(N,M5,M4)
      QI(N,M5,M4)=QI(N,M5,M4)+QI1(N,M5,M4)
      HQS(N,M5,M4)=HQS(N,M5,M4)+HQS1(N,M5,M4)
      QSM(M,N,M5,M4)=QS1(N,M5,M4)
C     IF((I/10)*10.EQ.I.AND.M.EQ.NPH)THEN
C     WRITE(*,7744)'QRB',I,J,M,N1,N2,N3,M4,M5,M6,N,NN,IRCHG(NN,N,N2,N1) 
C    2,QR(N,M5,M4),QR1(N,M5,M4),Q,QRX1,V,S,D,ALT1,ALT2,ZM(N2,N1) 
C    3,ZS(N2,N1),VOLWZ1,TVOLZ1,RCHQF,VOLWG(N2,N1),VOLW1(0,N2,N1)
C    4,VOLI1(0,N2,N1),TVOLW(N2,N1),FVOLW1,FVOLH1,PSISM1(0,N2,N1)
C    7,VOLWRX(N2,N1),FLWL(3,0,N2,N1),FLWRL(N2,N1)
7744  FORMAT(A8,12I4,30E12.4)
C     ENDIF
      ENDIF
      ENDIF
C
C     INFILTRATION OF WATER FROM MACROPORES INTO MICROPORES
C
      IF(N.EQ.3.AND.M3.NE.NU(M2,M1))THEN
      IF(NHOL(M3,M2,M1).GT.0)THEN
      FINHX=XNPH*6.283*SCNH(M3,M2,M1)*(PSISE(N3,N2,N1)-PSISM1(N3,N2,N1))
     3/LOG(PHOL(M3,M2,M1)/HRAD(M3,M2,M1))*DHOL(M3,M2,M1)
      IF(FINHX.GT.0.0)THEN
      FINHL(M3,M2,M1)=AMAX1(0.0,AMIN1(FINHX,XNPH*VOLWH1(M3,M2,M1)
     2,VOLPX1(M3,M2,M1)))
      ELSE
      FINHL(M3,M2,M1)=AMIN1(0.0,AMAX1(FINHX,-VOLPH1(M3,M2,M1)
     2,-XNPH*VOLW1(M3,M2,M1)))
      ENDIF
      FINHM(M,M3,M2,M1)=FINHL(M3,M2,M1)
      FINH(M3,M2,M1)=FINH(M3,M2,M1)+FINHL(M3,M2,M1)
C     IF(J.EQ.12.AND.M.EQ.1)THEN
C     WRITE(*,3367)'HOLE',I,J,M,M1,M2,M3,FINHL(M3,M2,M1)
C    2,FLWHL(N,M3,M2,M1),FLWHL(N,M6,M5,M4),VOLWH1(M3,M2,M1)
C    3,VOLPH1(M3,M2,M1),VOLAH1(M3,M2,M1),PSISE(M3,M2,M1)
C    4,XNPH,VOLW1(M3,M2,M1),VOLPX1(M3,M2,M1),SCNH(M3,M2,M1)
C    5,PHOL(M3,M2,M1),HRAD(M3,M2,M1),DHOL(M3,M2,M1)
C    6,PSISM1(M3,M2,M1)
3367  FORMAT(A8,6I4,20E12.4)
C     ENDIF
      ELSE
      FINHL(M3,M2,M1)=0.0
      FINHM(M,M3,M2,M1)=0.0
      ENDIF
      ENDIF
C
C     BOUNDARY SUBSURFACE WATER AND HEAT TRANSFER DEPENDING
C     ON LEVEL OF WATER TABLE
      IF(NCN(N2,N1).EQ.1.OR.N.EQ.3)THEN
C
C     IF NO WATER TABLE
C
      IF(IPRC(N2,N1).EQ.0.OR.N.EQ.3)THEN
      THETA1=AMAX1(THETY(N3,N2,N1),AMIN1(POROS(N3,N2,N1)
     2,VOLW1(N3,N2,N1)/VOLX(N3,N2,N1)))
      THETAX=AMAX1(THETY(N3,N2,N1),AMIN1(POROS(N3,N2,N1)
     2,VOLWX1(N3,N2,N1)/VOLX(N3,N2,N1)))
      K1=MIN(100,INT(100.0*(POROS(N3,N2,N1)
     2-THETA1)/POROS(N3,N2,N1))+1)
      KX=MIN(100,INT(100.0*(POROS(N3,N2,N1)
     2-THETAX)/POROS(N3,N2,N1))+1)
      CND1=HCND(N,K1,N3,N2,N1)*XNPH
      CNDX=HCND(N,KX,N3,N2,N1)*XNPH
      FLWL(N,M6,M5,M4)=AMIN1(VOLW1(N3,N2,N1)*XNPH
     2,0.01*CND1*AREA(3,N3,N2,N1))*RCHGFU
      FLWLX(N,M6,M5,M4)=AMIN1(VOLWX1(N3,N2,N1)*XNPH
     2,0.01*CNDX*AREA(3,N3,N2,N1))*RCHGFU
      FLWHL(N,M6,M5,M4)=AMIN1(VOLWH1(L,NY,NX)
     2,0.01*CNDH1(L,NY,NX)*AREA(3,N3,N2,N1))*RCHGFU
      HFLWL(N,M6,M5,M4)=4.19*TK1(N3,N2,N1)
     2*(FLWL(N,M6,M5,M4)+FLWHL(N,M6,M5,M4))
C     IF(J.EQ.12.AND.M.EQ.1)THEN
C     WRITE(*,4443)'ABV',I,J,M,N,NN,M4,M5,M6,XN,FLWL(N,M6,M5,M4)
C    2,VOLP2,RCHGFU,THW(N3,N2,N1),VOLX(N3,N2,N1),VOLW1(N3,N2,N1)
C    3,VOLWH1(N3,N2,N1),VOLPH1(N3,N2,N1),VOLPH2,VOLI1(N3,N2,N1)
C    4,VOLIH1(N3,N2,N1),VOLP1(N3,N2,N1),HFLWL(N,M6,M5,M4)
C    5,PSISM1(N3,N2,N1),PSISE(N3,N2,N1),FLWHL(N,M6,M5,M4),DDRG(N2,N1)
4443  FORMAT(A8,8I4,30E12.4)
C     ENDIF
      ELSE
C
C     MICROPORE DISCHARGE ABOVE WATER TABLE
C
      IF(IFLGU.EQ.0.AND.RCHGFT.NE.0.0)THEN
      PSISWD=XN*0.005*SLOPE(N,N2,N1)*DLYR(N,N3,N2,N1)
     2*(1.0-DTBLG(N2,N1))
      PSISWT=AMIN1(0.0,PSISE(N3,N2,N1)-PSISM1(N3,N2,N1) 
     2+0.01*(DPTH(N3,N2,N1)-DTBLX(N2,N1))
     3-0.01*AMAX1(0.0,DPTH(N3,N2,N1)-DPTHT(N2,N1)))
      IF(PSISWT.LT.0.0)PSISWT=PSISWT-PSISWD 
      FLWT=PSISWT*HCND(N,1,N3,N2,N1)*XNPH*AREA(N,N3,N2,N1)
     2*(1.0-AREAU(N3,N2,N1))/(RCHGFU+1.0)*RCHGFT 
      FLWL(N,M6,M5,M4)=XN*FLWT 
      FLWLX(N,M6,M5,M4)=XN*FLWT 
      HFLWL(N,M6,M5,M4)=4.19*TK1(N3,N2,N1)*XN*FLWT
C     WRITE(*,4445)'DISCHMI',I,J,M,N1,N2,N3,M4,M5,M6,N,NN,XN
C    2,FLWL(N,M6,M5,M4),FLWT,PSISWT,HCND(N,1,N3,N2,N1)
C    3,AREA(N,N3,N2,N1),AREAU(N3,N2,N1),RCHGFU,RCHGFT
4445  FORMAT(A8,11I4,30E12.4)
      ELSE
      FLWL(N,M6,M5,M4)=0.0
      FLWLX(N,M6,M5,M4)=0.0
      HFLWL(N,M6,M5,M4)=0.0
      ENDIF
C
C     MACROPORE DISCHARGE ABOVE WATER TABLE
C
      IF(IFLGUH.EQ.0.AND.RCHGFT.NE.0.0)THEN
      PSISWD=XN*0.005*SLOPE(N,N2,N1)*DLYR(N,N3,N2,N1)
     2*(1.0-DTBLG(N2,N1))
      PSISWTH=0.01*(DPTHH-DTBLX(N2,N1))
     2-0.01*AMAX1(0.0,DPTHH-DPTHT(N2,N1))
      IF(PSISWTH.LT.0.0)PSISWTH=PSISWTH-PSISWD
      FLWTH=PSISWTH*CNDH1(N3,N2,N1)*AREA(N,N3,N2,N1)  
     2*(1.0-AREAU(N3,N2,N1))/(RCHGFU+1.0)*RCHGFT 
      FLWTHL=AMAX1(FLWTH,AMIN1(0.0,-XNPH*(VOLWH1(N3,N2,N1) 
     2+FLWHL(3,N3,N2,N1)-FLWHL(3,N3+1,N2,N1)-FINHL(N3,N2,N1))))
      FLWHL(N,M6,M5,M4)=XN*FLWTHL 
      HFLWL(N,M6,M5,M4)=HFLWL(N,M6,M5,M4)+4.19*TK1(N3,N2,N1)*XN*FLWTHL
C     WRITE(*,4446)'DISCHMA',I,J,M,N1,N2,N3,M4,M5,M6,N,NN,XN
C    2,FLWHL(N,M6,M5,M4),FLWTHL,FLWTH,PSISWTH,CNDH1(N3,N2,N1)
C    3,DPTH(N3,N2,N1),DLYR(3,N3,N2,N1),DPTHH,VOLWH1(N3,N2,N1)
C    4,VOLIH1(L,NY,NX),VOLAH1(N3,N2,N1),DTBLX(N2,N1),PSISWD
4446  FORMAT(A8,11I4,30E12.4)
      ELSE
      FLWHL(N,M6,M5,M4)=0.0
      ENDIF
C
C     MICROPORE RECHARGE BELOW WATER TABLE
C
      IF(IPRC(N2,N1).NE.3.AND.DPTH(N3,N2,N1).GT.DTBLX(N2,N1)
     2.AND.VOLP2.GT.0.0)THEN
      PSISWD=XN*0.005*SLOPE(N,N2,N1)*DLYR(N,N3,N2,N1)
     2*(1.0-DTBLG(N2,N1))
      PSISUT=AMAX1(0.0,PSISE(N3,N2,N1)-PSISM1(N3,N2,N1) 
     2+0.01*(DPTH(N3,N2,N1)-DTBLX(N2,N1)))
      IF(PSISUT.GT.0.0)PSISUT=PSISUT+PSISWD 
      FLWU=PSISUT*HCND(N,1,N3,N2,N1)*XNPH*AREA(N,N3,N2,N1) 
     2*AREAU(N3,N2,N1)/(RCHGFU+1.0)*RCHGFT 
      FLWUL=AMIN1(FLWU,AMAX1(0.0,VOLP2))
      FLWUX=AMIN1(FLWU,AMAX1(0.0,VOLPX2))
      FLWL(N,M6,M5,M4)=FLWL(N,M6,M5,M4)+XN*FLWUL 
      FLWLX(N,M6,M5,M4)=FLWLX(N,M6,M5,M4)+XN*FLWUX 
      HFLWL(N,M6,M5,M4)=HFLWL(N,M6,M5,M4)+4.19*TK1(N3,N2,N1)
     2*XN*FLWUL
C     IF(I.GT.208.AND.J.EQ.21)THEN
C     WRITE(*,4444)'RECHGMI',I,J,M,N1,N2,N3,M4,M5,M6,N,NN,IFLGU,XN 
C    2,FLWL(N,M6,M5,M4),AREAU(N3,N2,N1),RCHGFT,VOLP2,FLWT 
C    3,FLWU,FLWUL,PSISM1(N3,N2,N1),PSISA(N3,N2,N1) 
C    4,PSISWT,PSISUT,PSISUTH,HCND(N,1,N3,N2,N1) 
C    5,DTBLX(N2,N1),CDPTH(N3,N2,N1),DPTHT(N2,N1) 
C    6,DDRG(N2,N1),DPTH(N3,N2,N1),VOLW1(N3,N2,N1),VOLI1(N3,N2,N1) 
C    7,VOLX(N3,N2,N1),VOLP1(N3,N2,N1)
C    8,RCHGFU,AREA(N,N3,N2,N1)
C    9,FINHL(N3,N2,N1),DLYR(N,N3,N2,N1),DLYR(3,N3,N2,N1),PSISWD
C    1,SLOPE(N,N2,N1)
4444  FORMAT(A8,12I4,40E12.4)
C     ENDIF
      ENDIF
C
C     MACROPORE RECHARGE BELOW WATER TABLE
C
      IF(IPRC(N2,N1).NE.3.AND.DPTHH.GT.DTBLX(N2,N1)
     2.AND.VOLPH2.GT.0.0)THEN
      PSISWD=XN*0.005*SLOPE(N,N2,N1)*DLYR(N,N3,N2,N1)
     2*(1.0-DTBLG(N2,N1))
      PSISUTH=0.01*(DPTHH-DTBLX(N2,N1))
      IF(PSISUTH.GT.0.0)PSISUTH=PSISUTH+PSISWD
      FLWUH=PSISUTH*CNDH1(N3,N2,N1)*AREA(N,N3,N2,N1)  
     2*AREAU(N3,N2,N1)/(RCHGFU+1.0)*RCHGFT 
      FLWUHL=AMIN1(FLWUH,AMAX1(0.0,XNPH*(VOLPH2
     2-FLWHL(3,N3,N2,N1)+FLWHL(3,N3+1,N2,N1)+FINHL(N3,N2,N1))))
      FLWHL(N,M6,M5,M4)=FLWHL(N,M6,M5,M4)+XN*FLWUHL
      HFLWL(N,M6,M5,M4)=HFLWL(N,M6,M5,M4)+4.19*TK1(N3,N2,N1)
     2*XN*FLWUHL
C     IF(I.GT.208.AND.J.EQ.21)THEN
C     WRITE(*,4447)'RECHGMA',I,J,M,N1,N2,N3,M4,M5,M6,N,NN,IFLGU,XN 
C    2,AREAU(N3,N2,N1),FLWUH,FLWUHL,DPTHH,PSISUTH,CNDH1(N3,N2,N1) 
C    5,FLWHL(N,M6,M5,M4),DTBLX(N2,N1),CDPTH(N3,N2,N1),DPTHT(N2,N1) 
C    6,DDRG(N2,N1),DPTH(N3,N2,N1),VOLWH1(N3,N2,N1),VOLPH1(N3,N2,N1) 
C    8,FLWHL(3,N3,N2,N1),FLWHL(3,N3+1,N2,N1),RCHGFU,AREA(N,N3,N2,N1)
C    9,FINHL(N3,N2,N1),DLYR(N,N3,N2,N1),DLYR(3,N3,N2,N1),PSISWD
C    1,SLOPE(N,N2,N1)
4447  FORMAT(A8,12I4,40E12.4)
C     ENDIF
      ENDIF
      ENDIF
C
C     SUBSURFACE HEAT SOURCE/SINK
C
      IF(N.EQ.3.AND.IETYP(N2,N1).NE.-2)THEN
      HFLWL(N,M6,M5,M4)=HFLWL(N,M6,M5,M4)+(TK1(N3,N2,N1)
     2-TKSD(N2,N1))*TCNDG/(DPTHSK(N2,N1)-CDPTH(N3,N2,N1))
     3*AREA(N,N3,N2,N1)*XNPH
      ENDIF
      VOLP2=VOLP2-XN*FLWL(N,M6,M5,M4)
      VOLPX2=VOLPX2-XN*FLWLX(N,M6,M5,M4)
      VOLPH2=VOLPH2-XN*FLWHL(N,M6,M5,M4)
      FLWLD=0.0
      FLWLXD=0.0
      FLWHLD=0.0
      FLW(N,M6,M5,M4)=FLW(N,M6,M5,M4)+FLWL(N,M6,M5,M4)
      FLWX(N,M6,M5,M4)=FLWX(N,M6,M5,M4)+FLWLX(N,M6,M5,M4)
      FLWH(N,M6,M5,M4)=FLWH(N,M6,M5,M4)+FLWHL(N,M6,M5,M4)
      HFLW(N,M6,M5,M4)=HFLW(N,M6,M5,M4)+HFLWL(N,M6,M5,M4)
      FLWM(M,N,M6,M5,M4)=FLWL(N,M6,M5,M4)
      FLWHM(M,N,M6,M5,M4)=FLWHL(N,M6,M5,M4)
      ENDIF
9575  CONTINUE
C
C     TOTAL WATER AND HEAT FLUXES IN EACH GRID CELL
C
      IF(L.EQ.NU(N2,N1).AND.N.NE.3)THEN
      TQR1(N2,N1)=TQR1(N2,N1)+QR1(N,N2,N1)-QR1(N,N5,N4)
      THQR1(N2,N1)=THQR1(N2,N1)+HQR1(N,N2,N1)-HQR1(N,N5,N4)
      TQS1(N2,N1)=TQS1(N2,N1)+QS1(N,N2,N1)-QS1(N,N5,N4)
      TQW1(N2,N1)=TQW1(N2,N1)+QW1(N,N2,N1)-QW1(N,N5,N4)
      TQI1(N2,N1)=TQI1(N2,N1)+QI1(N,N2,N1)-QI1(N,N5,N4)
      THQS1(N2,N1)=THQS1(N2,N1)+HQS1(N,N2,N1)-HQS1(N,N5,N4)
      ENDIF
      IF(NCN(N2,N1).EQ.1.OR.N.EQ.3)THEN
      TFLWL(N3,N2,N1)=TFLWL(N3,N2,N1)+FLWL(N,N3,N2,N1)
     2-FLWL(N,N6,N5,N4)
      TFLWLX(N3,N2,N1)=TFLWLX(N3,N2,N1)+FLWLX(N,N3,N2,N1)
     2-FLWLX(N,N6,N5,N4)
      TFLWHL(N3,N2,N1)=TFLWHL(N3,N2,N1)+FLWHL(N,N3,N2,N1)
     2-FLWHL(N,N6,N5,N4)
      THFLWL(N3,N2,N1)=THFLWL(N3,N2,N1)+HFLWL(N,N3,N2,N1)
     2-HFLWL(N,N6,N5,N4)
      TWFLXL(N3,N2,N1)=TWFLXL(N3,N2,N1)+WFLXL(N,N3,N2,N1)
      TWFLXH(N3,N2,N1)=TWFLXH(N3,N2,N1)+WFLXLH(N,N3,N2,N1)
      TTFLXL(N3,N2,N1)=TTFLXL(N3,N2,N1)+TFLXL(N,N3,N2,N1)
C     IF(L.EQ.1)THEN
C     WRITE(*,3378)'THFLWL',I,J,M,N1,N2,N3,N4,N5,N6,N,THFLWL(N3,N2,N1)
C    3,HFLWL(N,N3,N2,N1),HFLWL(N,N6,N5,N4),TFLWL(N3,N2,N1)
C    3,FLWL(N,N3,N2,N1),FLWL(N,N6,N5,N4),TFLWHL(N3,N2,N1)
C    3,FLWHL(N,N3,N2,N1),FLWHL(N,N6,N5,N4)
3378  FORMAT(A8,10I4,20E12.4)
C     ENDIF
      ENDIF
9580  CONTINUE
9585  CONTINUE
9590  CONTINUE
9595  CONTINUE
C
C     UPDATE STATE VARIABLES FROM FLUXES CALCULATED ABOVE
C
      IF(M.NE.NPH)THEN
      DO 9795 NX=NHW,NHE
      DO 9790 NY=NVN,NVS
C
C     SNOWPACK WATER, ICE, SNOW AND TEMPERATURE
C
      IF(VHCP0(NY,NX).GT.VHCPWX(NY,NX))THEN
      VOLS0(NY,NX)=VOLS0(NY,NX)+FLW0S(NY,NX)
     2-WFLXA(NY,NX)-FLWS1(NY,NX)+TQS1(NY,NX)
      VOLW0(NY,NX)=VOLW0(NY,NX)+FLW0L(NY,NX)
     2+WFLXA(NY,NX)+WFLXB(NY,NX)-FLWZ1(NY,NX)+TQW1(NY,NX)
      VOLI0(NY,NX)=VOLI0(NY,NX)
     2-WFLXB(NY,NX)/0.92-FLWI1(NY,NX)+TQI1(NY,NX)
      ENGY0=VHCP0(NY,NX)*TK0(NY,NX)
      VHCP0(NY,NX)=2.095*VOLS0(NY,NX)+4.19*VOLW0(NY,NX)
     2+1.9274*VOLI0(NY,NX)
      TK0(NY,NX)=(ENGY0+HFLW0L(NY,NX)+TFLX0(NY,NX)-HFLWZ1(NY,NX)
     2-HFLSI1(NY,NX)+THQS1(NY,NX))/VHCP0(NY,NX)
      ELSE
      VOLS0(NY,NX)=VOLS0(NY,NX)+FLQ0S(NY,NX)-FLWS1(NY,NX)
      VOLW0(NY,NX)=VOLW0(NY,NX)+FLQ0W(NY,NX)-FLWZ1(NY,NX)
      VOLI0(NY,NX)=VOLI0(NY,NX)-FLWI1(NY,NX)+TQI1(NY,NX)
      VHCP0(NY,NX)=2.095*VOLS0(NY,NX)+4.19*VOLW0(NY,NX)
     2+1.9274*VOLI0(NY,NX)
      TK0(NY,NX)=TK1(NU(NY,NX),NY,NX)
      DPTHS0(NY,NX)=0.0
      ENDIF
C     IF(NX.EQ.2.AND.NY.EQ.2)THEN
C     WRITE(*,7754)'TKW',I,J,M,NX,NY,TK0(NY,NX),HFLW0L(NY,NX)
C    2,TFLX0(NY,NX),HFLWZ1(NY,NX),HFLSI1(NY,NX),VHCP0(NY,NX)
C    3,FLW0S(NY,NX),WFLXA(NY,NX),WFLXB(NY,NX),FLWS1(NY,NX)
C    3,VOLS0(NY,NX),VOLW0(NY,NX),VOLI0(NY,NX),VOLS1(NY,NX)
C    4,TQS1(NY,NX),TQW1(NY,NX),TQI1(NY,NX),THQS1(NY,NX)
C    5,VHCPW(NY,NX),VHCPWX(NY,NX)
C     ENDIF
C
C     SURFACE RESIDUE WATER AND TEMPERATURE
C
      TVOL1(NY,NX)=AMAX1(0.0,VOLW1(0,NY,NX)+VOLI1(0,NY,NX)
     2-VOLWRX(NY,NX))
      TVOLW(NY,NX)=AMAX1(0.0,VOLW1(0,NY,NX)-VOLWRX(NY,NX))
      VOLGM(M+1,NY,NX)=AMAX1(0.0,TVOL1(NY,NX))
C     VOLXP2=(VOLP1(NU(NY,NX),NY,NX)+VOLPH1(NU(NY,NX),NY,NX))
C    2*AMIN1(1.0,(VOLA(NU(NY,NX),NY,NX)+VOLAH1(NU(NY,NX),NY,NX))
C    3/TVOL1(NY,NX))
C     VOLPX1(NU(NY,NX),NY,NX)=VOLXP2*HYST(NU(NY,NX),NY,NX)
      VOLW1(0,NY,NX)=AMAX1(0.0,VOLW1(0,NY,NX)+FLWRL(NY,NX)+WFLXR(NY,NX)
     2+TQR1(NY,NX))
      VOLI1(0,NY,NX)=AMAX1(0.0,VOLI1(0,NY,NX)-WFLXR(NY,NX)/0.92)
      VOLP1(0,NY,NX)=AMAX1(0.0,VOLA(0,NY,NX)-VOLW1(0,NY,NX)
     2-VOLI1(0,NY,NX))
      VOLWM(M+1,0,NY,NX)=VOLW1(0,NY,NX)
      VOLPM(M+1,0,NY,NX)=VOLP1(0,NY,NX)
      THETWX(0,NY,NX)=AMAX1(0.0,VOLW1(0,NY,NX)/VOLT(0,NY,NX))
      THETIX(0,NY,NX)=AMAX1(0.0,VOLI1(0,NY,NX)/VOLT(0,NY,NX))
      THETPX(0,NY,NX)=AMAX1(0.0,VOLP1(0,NY,NX)/VOLT(0,NY,NX))
      THETPM(M+1,0,NY,NX)=THETPX(0,NY,NX)
C     IF(NX.EQ.1.AND.NY.EQ.6)THEN
C     WRITE(*,7752)'VOLW10',I,J,M,NX,NY,VOLW1(0,NY,NX)
C    2,FLWRL(NY,NX),WFLXR(NY,NX),TQR1(NY,NX)
C    3,TRC0(NY,NX),VHCPR1(NY,NX),VHCPRX(NY,NX),CVRD(NY,NX)
C    4,FLWR(NY,NX)
7752  FORMAT(A8,5I4,20E12.4)    
C     ENDIF
      ENGYR=VHCPR1(NY,NX)*TK1(0,NY,NX)
      VHCPR1(NY,NX)=2.496E-06*ORGC(0,NY,NX)+4.19*VOLW1(0,NY,NX)
     2+1.9274*VOLI1(0,NY,NX)
      IF(VHCPR1(NY,NX).GT.VHCPRX(NY,NX))THEN
      TK1(0,NY,NX)=(ENGYR+HFLWRL(NY,NX)+TFLXR(NY,NX)
     2+THQR1(NY,NX))/VHCPR1(NY,NX)
C     WRITE(*,7754)'TKR',I,J,M,NX,NY,TK1(0,NY,NX),ENGYR,HFLWRL(NY,NX)
C    2,TFLXR(NY,NX),THQR1(NY,NX),VHCPR1(NY,NX),VOLW1(0,NY,NX) 
C    2,VOLI1(0,NY,NX),FLWRL(NY,NX),WFLXR(NY,NX)
7754  FORMAT(A8,5I4,30E12.4)      
      ELSE
      TK1(0,NY,NX)=TK1(NU(NY,NX),NY,NX)
      ENDIF
C
C     SOIL SURFACE WATER FROM RUNOFF
C
      VOLI1(NU(NY,NX),NY,NX)=VOLI1(NU(NY,NX),NY,NX)+FLSI1(NY,NX)
      ENGY1=VHCP1(NU(NY,NX),NY,NX)*TK1(NU(NY,NX),NY,NX)
      VHCP1(NU(NY,NX),NY,NX)=VHCM(NU(NY,NX),NY,NX)
     2+4.19*(VOLW1(NU(NY,NX),NY,NX)+VOLWH1(NU(NY,NX),NY,NX))
     3+1.9274*(VOLI1(NU(NY,NX),NY,NX)+VOLIH1(NU(NY,NX),NY,NX))
      TK1(NU(NY,NX),NY,NX)=(ENGY1+HFLSI1(NY,NX))
     2/VHCP1(NU(NY,NX),NY,NX)
C     WRITE(*,7755)'TQR',I,J,M,NX,NY,VOLW1(NU(NY,NX),NY,NX)
C    2,VOLWH1(NU(NY,NX),NY,NX),TQR1(NY,NX) 
C     WRITE(*,7755)'TK1',I,J,M,NX,NY,TK1(NU(NY,NX),NY,NX)
C    2,VHCP1(NU(NY,NX),NY,NX),VHCM(NU(NY,NX),NY,NX)
C    2,ENGY1,THQR1(NY,NX),HFLSI1(NY,NX),TQR1(NY,NX) 
C    3,VOLW1(NU(NY,NX),NY,NX),VOLWH1(NU(NY,NX),NY,NX)
C    4,VOLI1(NU(NY,NX),NY,NX),FLSI1(NY,NX)
7755  FORMAT(A8,5I4,20E12.4)
C
C     SOIL LAYER WATER, ICE AND TEMPERATURE
C
      DO 9785 L=NU(NY,NX),NL(NY,NX)
      VOLW1(L,NY,NX)=VOLW1(L,NY,NX)+TFLWL(L,NY,NX) 
     2+FINHL(L,NY,NX)+TWFLXL(L,NY,NX)+FLU1(L,NY,NX)
      VOLWX1(L,NY,NX)=VOLWX1(L,NY,NX)+TFLWLX(L,NY,NX) 
     2+FINHL(L,NY,NX)+TWFLXL(L,NY,NX)+FLU1(L,NY,NX)+FLWVL(L,NY,NX)
C     IF(BKDS(L,NY,NX).GT.0.0)THEN
C     VOLWX1(L,NY,NX)=AMAX1(THETX*VOLX(L,NY,NX)
C    2,VOLWX1(L,NY,NX))
C     ENDIF
      VOLWX1(L,NY,NX)=AMIN1(VOLW1(L,NY,NX),VOLWX1(L,NY,NX))
      VOLI1(L,NY,NX)=VOLI1(L,NY,NX)-TWFLXL(L,NY,NX)/0.92
      VOLWH1(L,NY,NX)=VOLWH1(L,NY,NX)+TFLWHL(L,NY,NX) 
     2-FINHL(L,NY,NX)+TWFLXH(L,NY,NX)
      VOLIH1(L,NY,NX)=VOLIH1(L,NY,NX)-TWFLXH(L,NY,NX)/0.92
      VOLP1(L,NY,NX)=AMAX1(0.0,VOLA(L,NY,NX)-VOLW1(L,NY,NX)
     2-VOLI1(L,NY,NX))
      VOLAH1(L,NY,NX)=AMAX1(0.0,VOLAH(L,NY,NX)-FVOLAH*CCLAY(L,NY,NX)
     2*(VOLW1(L,NY,NX)/VOLX(L,NY,NX)-WP(L,NY,NX))*VOLT(L,NY,NX))
      VOLPH1(L,NY,NX)=AMAX1(0.0,VOLAH1(L,NY,NX)-VOLWH1(L,NY,NX)
     2-VOLIH1(L,NY,NX))
      VOLPX1(L,NY,NX)=VOLP1(L,NY,NX)*HYST(L,NY,NX)
      VOLWM(M+1,L,NY,NX)=VOLW1(L,NY,NX)
      VOLWHM(M+1,L,NY,NX)=VOLWH1(L,NY,NX)
      VOLPM(M+1,L,NY,NX)=VOLP1(L,NY,NX)+VOLPH1(L,NY,NX)
     2+THETPI*(VOLI1(L,NY,NX)+VOLIH1(L,NY,NX))
      FLPM(M,L,NY,NX)=VOLPM(M,L,NY,NX)-VOLPM(M+1,L,NY,NX)
      THETWX(L,NY,NX)=AMAX1(0.0,(VOLW1(L,NY,NX)+VOLWH1(L,NY,NX))
     2/VOLT(L,NY,NX))
      THETIX(L,NY,NX)=AMAX1(0.0,(VOLI1(L,NY,NX)+VOLIH1(L,NY,NX))
     2/VOLT(L,NY,NX))
      THETPX(L,NY,NX)=AMAX1(0.0,(VOLP1(L,NY,NX)+VOLPH1(L,NY,NX))
     2/VOLT(L,NY,NX))
      THETPM(M+1,L,NY,NX)=THETPX(L,NY,NX)
      IF(VOLAH(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FMAC(L,NY,NX)=FHOL(L,NY,NX)*VOLAH1(L,NY,NX)/VOLAH(L,NY,NX)
      CNDH1(L,NY,NX)=XNPH*NHOL(L,NY,NX)*CNDH(L,NY,NX) 
     2*(VOLAH1(L,NY,NX)/VOLAH(L,NY,NX))**2
      ELSE
      FMAC(L,NY,NX)=0.0
      CNDH1(L,NY,NX)=0.0
      ENDIF
      FGRD(L,NY,NX)=1.0-FMAC(L,NY,NX)
      TKXX=TK1(L,NY,NX)
      VHXX=VHCP1(L,NY,NX)
      ENGY1=VHCP1(L,NY,NX)*TK1(L,NY,NX)
      VHCP1(L,NY,NX)=VHCM(L,NY,NX)+4.19*(VOLW1(L,NY,NX)
     2+VOLWH1(L,NY,NX))+1.9274*(VOLI1(L,NY,NX)+VOLIH1(L,NY,NX))
      TK1(L,NY,NX)=(ENGY1+THFLWL(L,NY,NX)+TTFLXL(L,NY,NX)
     2+HWFLU1(L,NY,NX))/VHCP1(L,NY,NX)
C     IF(I.GT.208.AND.J.EQ.21)THEN
C     WRITE(*,3377)'VOLW1',I,J,M,NX,NY,L,VOLW1(L,NY,NX)
C    2,TFLWL(L,NY,NX),FINHL(L,NY,NX),TWFLXL(L,NY,NX),FLU1(L,NY,NX) 
C    3,TQR1(NY,NX),VOLP1(L,NY,NX),VOLA(L,NY,NX) 
C    5,VOLI1(L,NY,NX),VOLPX1(L,NY,NX),HYST(L,NY,NX),PSISM1(L,NY,NX) 
C    6,FLWL(3,L,NY,NX),FLWL(3,L+1,NY,NX)
C    7,FLWL(2,L,NY,NX),FLWL(2,L,NY+1,NX)
C    8,FLWL(1,L,NY,NX),FLWL(1,L,NY,NX+1)
C    9,FLPM(M,L,NY,NX),VOLPM(M,L,NY,NX),VOLPM(M+1,L,NY,NX)
C     WRITE(*,3377)'VOLWH1',I,J,M,NX,NY,L,VOLWH1(L,NY,NX)
C    2,TFLWHL(L,NY,NX),FINHL(L,NY,NX),VOLIH1(L,NY,NX) 
C    4,TWFLXH(L,NY,NX),TQR1(NY,NX),VOLPH1(L,NY,NX)
C    5,FLWHL(3,L,NY,NX),FLWHL(3,L+1,NY,NX) 
C    WRITE(*,3377)'TKL',I,J,M,NX,NY,L,TK1(L,NY,NX),ENGY1
C    2,THFLWL(L,NY,NX),TTFLXL(L,NY,NX),HWFLU1(L,NY,NX),VHCP1(L,NY,NX) 
C    3,VHCM(L,NY,NX),VOLW1(L,NY,NX),VOLWH1(L,NY,NX),VOLI1(L,NY,NX)
C    4,THETW(L,NY,NX),THETI(L,NY,NX),FINHL(L,NY,NX),THQR1(NY,NX)
C    5,HFLSI1(NY,NX),HFLWL(3,L,NY,NX),HFLWL(3,L+1,NY,NX),TKXX,VHXX
3377  FORMAT(A8,6I4,40E12.4)
C     ENDIF
9785  CONTINUE
9790  CONTINUE
9795  CONTINUE
      ENDIF
3320  CONTINUE
      RETURN
      END
