      SUBROUTINE trnsfr(I,J,NHW,NHE,NVN,NVS)
C
C     THIS SUBROUTINE CALCULATES 3-DIMENSIONAL FLUXES OF ALL SOIL
C     NON-SALT SOLUTES AND GASES
C
      include "parameters.h"
      include "blkc.h"
      include "blk2a.h"
      include "blk2b.h"
      include "blk2c.h"
      include "blk8a.h"
      include "blk8b.h"
      include "blk10.h"
      include "blk11a.h"
      include "blk11b.h"
      include "blk13a.h"
      include "blk13b.h"
      include "blk13c.h"
      include "blk15a.h"
      include "blk15b.h"
      include "blk18a.h"
      include "blk18b.h"
      include "blk19d.h"
      include "blk20d.h"
      include "blk20e.h"
      include "blk21a.h"
      include "blk21b.h"
      include "blk22a.h"
      include "blk22b.h"
      include "blk22c.h"
      DIMENSION CO2G2(JZ,JY,JX),CO2S2(0:JZ,JY,JX)
     2,CH4G2(JZ,JY,JX),CH4S2(0:JZ,JY,JX),OXYG2(JZ,JY,JX)
     3,OXYS2(0:JZ,JY,JX),Z2GG2(JZ,JY,JX),Z2GS2(0:JZ,JY,JX)
     4,Z2OG2(JZ,JY,JX),Z2OS2(0:JZ,JY,JX),ZN3G2(0:JZ,JY,JX)
     5,ZNH4S2(0:JZ,JY,JX),ZNH4B2(0:JZ,JY,JX),ZN3S2(0:JZ,JY,JX)
     6,ZNBS2(0:JZ,JY,JX),ZNO3S2(0:JZ,JY,JX),ZNO3B2(0:JZ,JY,JX)
     7,H2PO42(0:JZ,JY,JX),H2POB2(0:JZ,JY,JX),ZNO2S2(0:JZ,JY,JX)
     8,CGSGL2(JZ,JY,JX),CHSGL2(JZ,JY,JX),OGSGL2(JZ,JY,JX)
     9,ZGSGL2(JZ,JY,JX),Z2SGL2(JZ,JY,JX),ZHSGL2(JZ,JY,JX)
     7,OQC2(0:4,0:JZ,JY,JX),OQN2(0:4,0:JZ,JY,JX),OQP2(0:4,0:JZ,JY,JX)
     8,OQA2(0:4,0:JZ,JY,JX),OCSGL2(0:JZ,JY,JX),ONSGL2(0:JZ,JY,JX)
     9,OPSGL2(0:JZ,JY,JX),OASGL2(0:JZ,JY,JX),CHY0(0:JZ,JY,JX)
     1,CO2W2(JY,JX),CH4W2(JY,JX),OXYW2(JY,JX),ZNGW2(JY,JX)
     2,ZN2W2(JY,JX),ZN4W2(JY,JX),ZN3W2(JY,JX),ZNOW2(JY,JX)
     3,ZHPW2(JY,JX)
      DIMENSION ROCSK2(0:4,0:JZ,JY,JX),RONSK2(0:4,0:JZ,JY,JX) 
     2,ROPSK2(0:4,0:JZ,JY,JX),ROASK2(0:4,0:JZ,JY,JX)
     3,RCOSK2(0:JZ,JY,JX),ROXSK2(0:JZ,JY,JX),RCHSK2(0:JZ,JY,JX) 
     4,RNGSK2(0:JZ,JY,JX),RN2SK2(0:JZ,JY,JX),RN4SK2(0:JZ,JY,JX)
     5,RN3SK2(0:JZ,JY,JX),RNOSK2(0:JZ,JY,JX),RHPSK2(0:JZ,JY,JX)
     6,R4BSK2(JZ,JY,JX),R3BSK2(JZ,JY,JX),RNBSK2(JZ,JY,JX)
     7,RHBSK2(JZ,JY,JX),RNXSK2(0:JZ,JY,JX),RNZSK2(JZ,JY,JX)
     8,RHGSK2(0:JZ,JY,JX),RNHSK2(0:JZ,JY,JX) 
      DIMENSION CLSGL2(0:JZ,JY,JX),CQSGL2(0:JZ,JY,JX),OLSGL2(0:JZ,JY,JX)
     2,ZNSGL2(0:JZ,JY,JX),ZLSGL2(0:JZ,JY,JX),ZVSGL2(0:JZ,JY,JX)
     3,HLSGL2(0:JZ,JY,JX),ZOSGL2(0:JZ,JY,JX),POSGL2(0:JZ,JY,JX)
     4,RCODFS(JY,JX),RCHDFS(JY,JX),ROXDFS(JY,JX),RNGDFS(JY,JX)
     5,RN2DFS(JY,JX),RN3DFS(JY,JX),RNBDFS(JY,JX),RHGDFS(JY,JX)
     6,RCODFR(JY,JX),RCHDFR(JY,JX),ROXDFR(JY,JX),RNGDFR(JY,JX)
     7,RN2DFR(JY,JX),RN3DFR(JY,JX),RHGDFR(JY,JX) 
     8,RQROC(0:4,2,JV,JH),RQRON(0:4,2,JV,JH),RQROP(0:4,2,JV,JH)
     9,RQROA(0:4,2,JV,JH),RQRCOS(2,JV,JH),RQRCHS(2,JV,JH)
     1,RQROXS(2,JV,JH),RQRNGS(2,JV,JH),RQRN2S(2,JV,JH),RQRNH4(2,JV,JH)
     2,RQRNH3(2,JV,JH),RQRNO3(2,JV,JH),RQRH2P(2,JV,JH)
     3,RQRNO2(2,JV,JH),RQRHGS(2,JV,JH),FLWU(JZ,JY,JX)
     4,RQSCOS(2,JV,JH),RQSCHS(2,JV,JH),RQSOXS(2,JV,JH)
     5,RQSNGS(2,JV,JH),RQSN2S(2,JV,JH),RQSNH4(2,JV,JH)
     6,RQSNH3(2,JV,JH),RQSNO3(2,JV,JH),RQSH2P(2,JV,JH)
      DIMENSION RCOFLS(3,0:JD,JV,JH),RCHFLS(3,0:JD,JV,JH) 
     2,ROXFLS(3,0:JD,JV,JH),RNGFLS(3,0:JD,JV,JH),RN2FLS(3,0:JD,JV,JH)
     3,RHGFLS(3,0:JD,JV,JH),RN4FLW(3,0:JD,JV,JH),RN3FLW(3,0:JD,JV,JH)
     4,RNOFLW(3,0:JD,JV,JH),RNXFLS(3,0:JD,JV,JH),RH2PFS(3,0:JD,JV,JH)
     5,RN4FLB(3,0:JD,JV,JH),RN3FLB(3,0:JD,JV,JH),RNOFLB(3,0:JD,JV,JH)
     6,RNXFLB(3,0:JD,JV,JH),RH2BFB(3,0:JD,JV,JH),RCOFHS(3,JD,JV,JH)
     7,RCHFHS(3,JD,JV,JH),ROXFHS(3,JD,JV,JH),RNGFHS(3,JD,JV,JH)
     8,RN2FHS(3,JD,JV,JH),RN4FHW(3,JD,JV,JH),RN3FHW(3,JD,JV,JH)
     9,RNOFHW(3,JD,JV,JH),RH2PHS(3,JD,JV,JH),RN4FHB(3,JD,JV,JH)
     1,RN3FHB(3,JD,JV,JH),RNOFHB(3,JD,JV,JH),RH2BHB(3,JD,JV,JH)
     2,ROCFLS(0:4,3,0:JD,JV,JH),RONFLS(0:4,3,0:JD,JV,JH)
     3,ROPFLS(0:4,3,0:JD,JV,JH),ROAFLS(0:4,3,0:JD,JV,JH) 
     4,ROCFHS(0:4,3,JD,JV,JH),RONFHS(0:4,3,JD,JV,JH)
     5,ROPFHS(0:4,3,JD,JV,JH),ROAFHS(0:4,3,JD,JV,JH)
     6,ROXFLG(3,JD,JV,JH),RN3FLG(3,JD,JV,JH),RCOFLG(3,JD,JV,JH)
     7,RCHFLG(3,JD,JV,JH),RNGFLG(3,JD,JV,JH),RN2FLG(3,JD,JV,JH)
     8,RNXFHS(3,JD,JV,JH),RNXFHB(3,JD,JV,JH) 
      DIMENSION RCODFG(0:JZ,JY,JX),RCHDFG(0:JZ,JY,JX)
     1,ROXDFG(0:JZ,JY,JX),RNGDFG(0:JZ,JY,JX),RN2DFG(0:JZ,JY,JX)
     2,RN3DFG(0:JZ,JY,JX),RNBDFG(0:JZ,JY,JX),TQROC(0:4,JY,JX)
     3,TQRON(0:4,JY,JX),TQROP(0:4,JY,JX),TQROA(0:4,JY,JX),TQRCOS(JY,JX)
     4,TQRCHS(JY,JX),TQROXS(JY,JX),TQRNGS(JY,JX),TQRN2S(JY,JX)
     5,TQRNH4(JY,JX),TQRNH3(JY,JX),TQRNO3(JY,JX),TQRH2P(JY,JX)
     7,TQRNO2(JY,JX),TQRHGS(JY,JX),TQSCOS(JY,JX)
     4,TQSCHS(JY,JX),TQSOXS(JY,JX),TQSNGS(JY,JX),TQSN2S(JY,JX)
     5,TQSNH4(JY,JX),TQSNH3(JY,JX),TQSNO3(JY,JX),TQSH2P(JY,JX)
     8,TOCFLS(0:4,JZ,JY,JX),TONFLS(0:4,JZ,JY,JX)
     8,TOPFLS(0:4,JZ,JY,JX),TOAFLS(0:4,JZ,JY,JX),TCOFLS(JZ,JY,JX)
     9,TCHFLS(JZ,JY,JX),TOXFLS(JZ,JY,JX),TNGFLS(JZ,JY,JX)
     1,TN2FLS(JZ,JY,JX),TN4FLW(JZ,JY,JX),TN3FLW(JZ,JY,JX)
     2,TNOFLW(JZ,JY,JX),TH2PFS(JZ,JY,JX),TN4FLB(JZ,JY,JX)
     3,TN3FLB(JZ,JY,JX),TNOFLB(JZ,JY,JX),TH2BFB(JZ,JY,JX)
     4,TNXFLS(JZ,JY,JX),TCOFLG(JZ,JY,JX),TCHFLG(JZ,JY,JX)
     5,TOXFLG(JZ,JY,JX),TNGFLG(JZ,JY,JX),TN2FLG(JZ,JY,JX)
     6,RN34SQ(0:JZ,JY,JX),RN34BQ(0:JZ,JY,JX)
      DIMENSION TN3FLG(JZ,JY,JX),RCOBBL(JZ,JY,JX)
     4,RCHBBL(JZ,JY,JX),ROXBBL(JZ,JY,JX),RNGBBL(JZ,JY,JX)
     5,RN2BBL(JZ,JY,JX),RN3BBL(JZ,JY,JX),RNBBBL(JZ,JY,JX)
     6,RHGBBL(JZ,JY,JX)
      DIMENSION CO2SH2(JZ,JY,JX),CH4SH2(JZ,JY,JX),OXYSH2(JZ,JY,JX)
     2,Z2GSH2(JZ,JY,JX),Z2OSH2(JZ,JY,JX),ZNH4H2(JZ,JY,JX)
     3,ZN4BH2(JZ,JY,JX),ZNH3H2(JZ,JY,JX),ZN3BH2(JZ,JY,JX)
     4,ZNO3H2(JZ,JY,JX),ZNOBH2(JZ,JY,JX),H2P4H2(JZ,JY,JX)
     5,H2PBH2(JZ,JY,JX),ZNO2H2(JZ,JY,JX),OQCH2(0:4,JZ,JY,JX)
     6,OQNH2(0:4,JZ,JY,JX),OQPH2(0:4,JZ,JY,JX),OQAH2(0:4,JZ,JY,JX)
     7,TOCFHS(0:4,JZ,JY,JX),TONFHS(0:4,JZ,JY,JX),TOPFHS(0:4,JZ,JY,JX)
     8,TOAFHS(0:4,JZ,JY,JX),TCOFHS(JZ,JY,JX),TCHFHS(JZ,JY,JX)
     9,TOXFHS(JZ,JY,JX),TNGFHS(JZ,JY,JX),TN2FHS(JZ,JY,JX)
     1,TN4FHW(JZ,JY,JX),TN3FHW(JZ,JY,JX),TNOFHW(JZ,JY,JX)
     2,TH2PHS(JZ,JY,JX),TN4FHB(JZ,JY,JX),TN3FHB(JZ,JY,JX)
     3,TNOFHB(JZ,JY,JX),TH2BHB(JZ,JY,JX),TNXFHS(JZ,JY,JX)
     4,ZNO2B2(JZ,JY,JX),ZN2BH2(JZ,JY,JX),TNXFLB(JZ,JY,JX)
     5,TNXFHB(JZ,JY,JX) 
      DIMENSION RCOFLZ(JZ,JY,JX),RCHFLZ(JZ,JY,JX)
     1,ROXFLZ(JZ,JY,JX),RNGFLZ(JZ,JY,JX)
     2,RN2FLZ(JZ,JY,JX),RN4FLZ(JZ,JY,JX),RN3FLZ(JZ,JY,JX)
     3,RNOFLZ(JZ,JY,JX),RH2PFZ(JZ,JY,JX),RN4FBZ(JZ,JY,JX)
     4,RN3FBZ(JZ,JY,JX),RNOFBZ(JZ,JY,JX),RH2BBZ(JZ,JY,JX)
      DIMENSION ROCFXS(0:4,JZ,JY,JX),RONFXS(0:4,JZ,JY,JX)
     1,ROPFXS(0:4,JZ,JY,JX),ROAFXS(0:4,JZ,JY,JX),RCOFXS(JZ,JY,JX)
     2,RCHFXS(JZ,JY,JX),ROXFXS(JZ,JY,JX)
     3,RNGFXS(JZ,JY,JX),RN2FXS(JZ,JY,JX),RN4FXW(JZ,JY,JX)
     4,RN3FXW(JZ,JY,JX),RNOFXW(JZ,JY,JX),RH2PXS(JZ,JY,JX)
     5,RN4FXB(JZ,JY,JX),RN3FXB(JZ,JY,JX),RNOFXB(JZ,JY,JX)
     6,RH2BXB(JZ,JY,JX),RNXFXS(JZ,JY,JX),RNXFXB(JZ,JY,JX)
      DIMENSION RFLOC(0:4),RFLON(0:4),RFLOP(0:4),RFLOA(0:4)
     2,RFHOC(0:4),RFHON(0:4),RFHOP(0:4),RFHOA(0:4) ,COQC1(0:4)
     3,COQC2(0:4),COQN1(0:4),COQN2(0:4),COQP1(0:4),COQP2(0:4)
     4,COQA1(0:4),COQA2(0:4),COQCH1(0:4),COQCH2(0:4)
     3,COQNH1(0:4),COQNH2(0:4),COQPH1(0:4),COQPH2(0:4)
     4,COQAH1(0:4),COQAH2(0:4),DFVOC(0:4),DFVON(0:4),DFVOP(0:4)
     5,DFVOA(0:4),DFHOC(0:4),DFHON(0:4),DFHOP(0:4),DFHOA(0:4)
      DIMENSION THETW1(0:JZ,JY,JX)
     2,DCO2G(3,JZ,JY,JX),DCH4G(3,JZ,JY,JX)
     3,DOXYG(3,JZ,JY,JX),DZ2GG(3,JZ,JY,JX),DZ2OG(3,JZ,JY,JX)
     4,DNH3G(3,JZ,JY,JX),VOLWCO(0:JZ,JY,JX),VOLWCH(0:JZ,JY,JX)
     5,VOLWOX(0:JZ,JY,JX),VOLWNG(0:JZ,JY,JX),VOLWN2(0:JZ,JY,JX)
     6,VOLWN3(0:JZ,JY,JX),VOLWNB(0:JZ,JY,JX),VOLWHG(0:JZ,JY,JX)
     7,H2GG2(JZ,JY,JX),H2GS2(0:JZ,JY,JX),H2GSH2(JZ,JY,JX)
     8,HGSGL2(JZ,JY,JX),DH2GG(3,JZ,JY,JX),RHGFXS(JZ,JY,JX)
     2,RHGFLZ(JZ,JY,JX),RHGFLG(3,JD,JV,JH),THGFLS(JZ,JY,JX)
     3,THGFHS(JZ,JY,JX),RHGDFG(0:JZ,JY,JX),FLQM(3,JD,JV,JH)  
     4,RHGFHS(3,JD,JV,JH),THGFLG(JZ,JY,JX),FLVM(JZ,JY,JX)
     5,THETH2(JZ,JY,JX),THETHL(JZ,JY,JX),VOLPMA(JZ,JY,JX)
     6,VOLPMB(JZ,JY,JX),VOLWMA(JZ,JY,JX),VOLWMB(JZ,JY,JX)
     7,VOLWXA(0:JZ,JY,JX),VOLWXB(JZ,JY,JX),PARGCO(JY,JX)
     8,PARGCH(JY,JX),PARGOX(JY,JX),PARGNG(JY,JX) 
     9,PARGN2(JY,JX),PARGN3(JY,JX),PARGH2(JY,JX)
      DIMENSION ROCFL0(0:2,JY,JX),RONFL0(0:2,JY,JX),ROPFL0(0:2,JY,JX)
     2,ROAFL0(0:2,JY,JX),ROCFL1(0:2,JY,JX),RONFL1(0:2,JY,JX)
     3,ROPFL1(0:2,JY,JX),ROAFL1(0:2,JY,JX),RCOFL0(JY,JX),RCHFL0(JY,JX)
     4,ROXFL0(JY,JX),RNGFL0(JY,JX),RN2FL0(JY,JX),RHGFL0(JY,JX)
     5,RN4FL0(JY,JX),RN3FL0(JY,JX),RNOFL0(JY,JX),RNXFL0(JY,JX)
     6,RH2PF0(JY,JX),RCOFL1(JY,JX),RCHFL1(JY,JX),ROXFL1(JY,JX)
     7,RNGFL1(JY,JX),RN2FL1(JY,JX),RHGFL1(JY,JX),RN4FL1(JY,JX)
     8,RN3FL1(JY,JX),RNOFL1(JY,JX),RNXFL1(JY,JX),RH2PF1(JY,JX)
     9,RN4FL2(JY,JX),RN3FL2(JY,JX),RNOFL2(JY,JX),RNXFL2(JY,JX)
     1,RH2BF2(JY,JX)
      DIMENSION VOLCOR(JY,JX),VOLCHR(JY,JX),VOLOXR(JY,JX),VOLNGR(JY,JX)
     2,VOLN2R(JY,JX),VOLN3R(JY,JX),VOLHGR(JY,JX),VOLCOT(JY,JX)
     3,VOLCHT(JY,JX),VOLOXT(JY,JX),VOLNGT(JY,JX),VOLN2T(JY,JX)
     4,VOLN3T(JY,JX),VOLNBT(JY,JX),VOLHGT(JY,JX)
      PARAMETER(DPN4=5.7E-07,FVFLW=0.10,DFGAS=1.0,DFGAV=10.0,DFGSS=0.5)
      REAL*4 CCO2SQ,CCH4SQ,COXYSQ,CZ2GSQ,CZ2OSQ,CNH3SQ
     2,CNH3BQ,CH2GSQ
C
C     TIME STEPS FOR SOLUTE AND GAS FLUX CALCULATIONS
C
      DO 9995 NX=NHW,NHE
      DO 9990 NY=NVN,NVS
C
C     GAS AND SOLUTE SINKS AND SOURCES IN SURFACE RESIDUE FROM MICROBIAL
C     TRANSFORMATIONS IN 'NITRO' + ROOT EXCHANGE IN 'EXTRACT'
C     + EQUILIBRIA REACTIONS IN 'SOLUTE' AT SUB-HOURLY TIME STEP
C
      RCOSK2(0,NY,NX)=RCO2O(0,NY,NX)*XNPG
      RCHSK2(0,NY,NX)=RCH4O(0,NY,NX)*XNPG
      RNGSK2(0,NY,NX)=(RN2G(0,NY,NX)+XN2GS(0,NY,NX))*XNPG
      RN2SK2(0,NY,NX)=RN2O(0,NY,NX)*XNPG
      RNHSK2(0,NY,NX)=-TRN3G(0,NY,NX)*XNPG
      RHGSK2(0,NY,NX)=RH2GO(0,NY,NX)*XNPG
      DO 14 K=0,2
      ROCSK2(K,0,NY,NX)=-XOQCS(K,0,NY,NX)*XNPH
      RONSK2(K,0,NY,NX)=-XOQNS(K,0,NY,NX)*XNPH
      ROPSK2(K,0,NY,NX)=-XOQPS(K,0,NY,NX)*XNPH
      ROASK2(K,0,NY,NX)=-XOQAS(K,0,NY,NX)*XNPH
14    CONTINUE
      RN4SK2(0,NY,NX)=(-XNH4S(0,NY,NX)-TRN4S(0,NY,NX))*XNPH
      RN3SK2(0,NY,NX)=-TRN3S(0,NY,NX)*XNPH
      RNOSK2(0,NY,NX)=(-XNO3S(0,NY,NX)-TRNO3(0,NY,NX))*XNPH
      RNXSK2(0,NY,NX)=(-XNO2S(0,NY,NX)-TRNO2(0,NY,NX))*XNPH
      RHPSK2(0,NY,NX)=(-XH2PS(0,NY,NX)-TRH2P(0,NY,NX))*XNPH
      CO2S2(0,NY,NX)=CO2S(0,NY,NX) 
      CH4S2(0,NY,NX)=CH4S(0,NY,NX) 
      OXYS2(0,NY,NX)=OXYS(0,NY,NX) 
      Z2GS2(0,NY,NX)=Z2GS(0,NY,NX) 
      Z2OS2(0,NY,NX)=Z2OS(0,NY,NX) 
      H2GS2(0,NY,NX)=H2GS(0,NY,NX) 
      DO 9979 K=0,2
      OQC2(K,0,NY,NX)=OQC(K,0,NY,NX)-XOQCS(K,0,NY,NX) 
      OQN2(K,0,NY,NX)=OQN(K,0,NY,NX)-XOQNS(K,0,NY,NX)
      OQP2(K,0,NY,NX)=OQP(K,0,NY,NX)-XOQPS(K,0,NY,NX)
      OQA2(K,0,NY,NX)=OQA(K,0,NY,NX)-XOQAS(K,0,NY,NX)
9979  CONTINUE
      ZNH4S2(0,NY,NX)=ZNH4S(0,NY,NX) 
      ZN3S2(0,NY,NX)=ZNH3S(0,NY,NX) 
      ZNO3S2(0,NY,NX)=ZNO3S(0,NY,NX)
      ZNO2S2(0,NY,NX)=ZNO2S(0,NY,NX)
      H2PO42(0,NY,NX)=H2PO4(0,NY,NX)
      CHY0(0,NY,NX)=10.0**(-(PH(0,NY,NX)-3.0))
C
C     SURFACE SOLUTE FLUXES FROM ATMOSPHERE
C
      DO 8855 K=0,4
      IF(K.LE.2)THEN
      XOCFLS(K,3,0,NY,NX)=0.0
      XONFLS(K,3,0,NY,NX)=0.0
      XOPFLS(K,3,0,NY,NX)=0.0
      XOAFLS(K,3,0,NY,NX)=0.0
      ENDIF
      XOCFLS(K,3,NU(NY,NX),NY,NX)=0.0
      XONFLS(K,3,NU(NY,NX),NY,NX)=0.0
      XOPFLS(K,3,NU(NY,NX),NY,NX)=0.0
      XOAFLS(K,3,NU(NY,NX),NY,NX)=0.0
      XOCFHS(K,3,NU(NY,NX),NY,NX)=0.0
      XONFHS(K,3,NU(NY,NX),NY,NX)=0.0
      XOPFHS(K,3,NU(NY,NX),NY,NX)=0.0
      XOAFHS(K,3,NU(NY,NX),NY,NX)=0.0
8855  CONTINUE
C
C     HOURLY SOLUTE FLUXES FROM ATMOSPHERE TO SNOWPACK
C     IN SNOWFALL AND IRRIGATION ACCORDING TO CONCENTRATIONS
C     ENTERED IN WEATHER AND IRRIGATION FILES
C
      IF(PRECW(NY,NX).GT.0.0.OR.(PRECR(NY,NX).GT.0.0
     2.AND.VHCPW(NY,NX).GT.VHCPWX(NY,NX)))THEN
      XCOBLS(NY,NX)=FLQGQ(NY,NX)*CCOR(NY,NX)+FLQGI(NY,NX)*CCOQ(NY,NX)
      XCHBLS(NY,NX)=FLQGQ(NY,NX)*CCHR(NY,NX)+FLQGI(NY,NX)*CCHQ(NY,NX)
      XOXBLS(NY,NX)=FLQGQ(NY,NX)*COXR(NY,NX)+FLQGI(NY,NX)*COXQ(NY,NX)
      XNGBLS(NY,NX)=FLQGQ(NY,NX)*CNNR(NY,NX)+FLQGI(NY,NX)*CNNQ(NY,NX)
      XN2BLS(NY,NX)=FLQGQ(NY,NX)*CN2R(NY,NX)+FLQGI(NY,NX)*CN2Q(NY,NX)
      XHGBLS(NY,NX)=0.0
      XN4BLW(NY,NX)=(FLQGQ(NY,NX)*CN4R(NY,NX)+FLQGI(NY,NX)
     2*CN4Q(I,NY,NX))*14.0
      XN3BLW(NY,NX)=(FLQGQ(NY,NX)*CN3R(NY,NX)+FLQGI(NY,NX)
     2*CN3Q(I,NY,NX))*14.0
      XNOBLW(NY,NX)=(FLQGQ(NY,NX)*CNOR(NY,NX)+FLQGI(NY,NX)
     2*CNOQ(I,NY,NX))*14.0
      XH2PBS(NY,NX)=(FLQGQ(NY,NX)*CPOR(NY,NX)+FLQGI(NY,NX)
     2*CPOQ(I,NY,NX))*31.0
C
C     HOURLY SOLUTE FLUXES FROM ATMOSPHERE TO SOIL SURFACE
C     IF RAINFALL AND IRRIGATION IS ZERO IF SNOWPACK IS PRESENT
C
      XCOFLS(3,0,NY,NX)=0.0
      XCHFLS(3,0,NY,NX)=0.0
      XOXFLS(3,0,NY,NX)=0.0
      XNGFLS(3,0,NY,NX)=0.0
      XN2FLS(3,0,NY,NX)=0.0
      XHGFLS(3,0,NY,NX)=0.0
      XN4FLW(3,0,NY,NX)=0.0
      XN3FLW(3,0,NY,NX)=0.0
      XNOFLW(3,0,NY,NX)=0.0
      XNXFLS(3,0,NY,NX)=0.0
      XH2PFS(3,0,NY,NX)=0.0
      XCOFLS(3,NU(NY,NX),NY,NX)=0.0
      XCHFLS(3,NU(NY,NX),NY,NX)=0.0
      XOXFLS(3,NU(NY,NX),NY,NX)=0.0
      XNGFLS(3,NU(NY,NX),NY,NX)=0.0
      XN2FLS(3,NU(NY,NX),NY,NX)=0.0
      XHGFLS(3,NU(NY,NX),NY,NX)=0.0
      XN4FLW(3,NU(NY,NX),NY,NX)=0.0
      XN3FLW(3,NU(NY,NX),NY,NX)=0.0
      XNOFLW(3,NU(NY,NX),NY,NX)=0.0
      XNXFLS(3,NU(NY,NX),NY,NX)=0.0
      XH2PFS(3,NU(NY,NX),NY,NX)=0.0
      XN4FLB(3,NU(NY,NX),NY,NX)=0.0
      XN3FLB(3,NU(NY,NX),NY,NX)=0.0
      XNOFLB(3,NU(NY,NX),NY,NX)=0.0
      XNXFLB(3,NU(NY,NX),NY,NX)=0.0
      XH2BFB(3,NU(NY,NX),NY,NX)=0.0
C
C     HOURLY SOLUTE FLUXES FROM ATMOSPHERE TO SOIL SURFACE
C     IN RAINFALL AND IRRIGATION ACCORDING TO CONCENTRATIONS
C     ENTERED IN WEATHER AND IRRIGATION FILES
C
      ELSEIF((PRECQ(NY,NX).GT.0.0.OR.PRECI(NY,NX).GT.0.0)
     2.AND.VHCPW(NY,NX).LE.VHCPWX(NY,NX))THEN
C
C     HOURLY SOLUTE FLUXES FROM ATMOSPHERE TO SNOWPACK
C     IF SNOWFALL AND IRRIGATION IS ZERO AND SNOWPACK IS ABSENT
C
      XCOBLS(NY,NX)=0.0
      XCHBLS(NY,NX)=0.0
      XOXBLS(NY,NX)=0.0
      XNGBLS(NY,NX)=0.0
      XN2BLS(NY,NX)=0.0
      XHGBLS(NY,NX)=0.0
      XN4BLW(NY,NX)=0.0
      XN3BLW(NY,NX)=0.0
      XNOBLW(NY,NX)=0.0
      XH2PBS(NY,NX)=0.0
      XCOFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CCOR(NY,NX)
     2+FLQRI(NY,NX)*CCOQ(NY,NX)
      XCHFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CCHR(NY,NX)
     2+FLQRI(NY,NX)*CCHQ(NY,NX)
      XOXFLS(3,0,NY,NX)=FLQRQ(NY,NX)*COXR(NY,NX)
     2+FLQRI(NY,NX)*COXQ(NY,NX)
      XNGFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CNNR(NY,NX)
     2+FLQRI(NY,NX)*CNNQ(NY,NX)
      XN2FLS(3,0,NY,NX)=FLQRQ(NY,NX)*CN2R(NY,NX)
     2+FLQRI(NY,NX)*CN2Q(NY,NX)
      XHGFLS(3,0,NY,NX)=0.0
      XN4FLW(3,0,NY,NX)=(FLQRQ(NY,NX)*CN4R(NY,NX)+FLQRI(NY,NX)
     2*CN4Q(I,NY,NX))*14.0
      XN3FLW(3,0,NY,NX)=(FLQRQ(NY,NX)*CN3R(NY,NX)+FLQRI(NY,NX)
     2*CN3Q(I,NY,NX))*14.0
      XNOFLW(3,0,NY,NX)=(FLQRQ(NY,NX)*CNOR(NY,NX)+FLQRI(NY,NX)
     2*CNOQ(I,NY,NX))*14.0
      XNXFLS(3,0,NY,NX)=0.0
      XH2PFS(3,0,NY,NX)=(FLQRQ(NY,NX)*CPOR(NY,NX)+FLQRI(NY,NX)
     2*CPOQ(I,NY,NX))*31.0
      XCOFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CCOR(NY,NX)
     2+FLQGI(NY,NX)*CCOQ(NY,NX)
      XCHFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CCHR(NY,NX)
     2+FLQGI(NY,NX)*CCHQ(NY,NX)
      XOXFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*COXR(NY,NX)
     2+FLQGI(NY,NX)*COXQ(NY,NX)
      XNGFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CNNR(NY,NX)
     2+FLQGI(NY,NX)*CNNQ(NY,NX)
      XN2FLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CN2R(NY,NX)
     2+FLQGI(NY,NX)*CN2Q(NY,NX)
      XHGFLS(3,NU(NY,NX),NY,NX)=0.0
      XN4FLW(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CN4R(NY,NX)+FLQGI(NY,NX)
     2*CN4Q(I,NY,NX))*14.0)*VLNH4(NU(NY,NX),NY,NX)
      XN3FLW(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CN3R(NY,NX)+FLQGI(NY,NX)
     2*CN3Q(I,NY,NX))*14.0)*VLNH4(NU(NY,NX),NY,NX)
      XNOFLW(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CNOR(NY,NX)+FLQGI(NY,NX)
     2*CNOQ(I,NY,NX))*14.0)*VLNO3(NU(NY,NX),NY,NX)
      XNXFLS(3,NU(NY,NX),NY,NX)=0.0
      XH2PFS(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CPOR(NY,NX)+FLQGI(NY,NX)
     2*CPOQ(I,NY,NX))*31.0)*VLPO4(NU(NY,NX),NY,NX)
      XN4FLB(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CN4R(NY,NX)+FLQGI(NY,NX)
     2*CN4Q(I,NY,NX))*14.0)*VLNHB(NU(NY,NX),NY,NX)
      XN3FLB(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CN3R(NY,NX)+FLQGI(NY,NX)
     2*CN3Q(I,NY,NX))*14.0)*VLNHB(NU(NY,NX),NY,NX)
      XNOFLB(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CNOR(NY,NX)+FLQGI(NY,NX)
     2*CNOQ(I,NY,NX))*14.0)*VLNOB(NU(NY,NX),NY,NX)
      XNXFLB(3,NU(NY,NX),NY,NX)=0.0
      XH2BFB(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CPOR(NY,NX)+FLQGI(NY,NX)
     2*CPOQ(I,NY,NX))*31.0)*VLPOB(NU(NY,NX),NY,NX)
C
C     NO SOLUTE FLUXES FROM ATMOSPHERE
C
      ELSE
      XCOBLS(NY,NX)=0.0
      XCHBLS(NY,NX)=0.0
      XOXBLS(NY,NX)=0.0
      XNGBLS(NY,NX)=0.0
      XN2BLS(NY,NX)=0.0
      XHGBLS(NY,NX)=0.0
      XN4BLW(NY,NX)=0.0
      XN3BLW(NY,NX)=0.0
      XNOBLW(NY,NX)=0.0
      XH2PBS(NY,NX)=0.0
      XCOFLS(3,0,NY,NX)=0.0
      XCHFLS(3,0,NY,NX)=0.0
      XOXFLS(3,0,NY,NX)=0.0
      XNGFLS(3,0,NY,NX)=0.0
      XN2FLS(3,0,NY,NX)=0.0
      XHGFLS(3,0,NY,NX)=0.0
      XN4FLW(3,0,NY,NX)=0.0
      XN3FLW(3,0,NY,NX)=0.0
      XNOFLW(3,0,NY,NX)=0.0
      XNXFLS(3,0,NY,NX)=0.0
      XH2PFS(3,0,NY,NX)=0.0
      XCOFLS(3,NU(NY,NX),NY,NX)=0.0
      XCHFLS(3,NU(NY,NX),NY,NX)=0.0
      XOXFLS(3,NU(NY,NX),NY,NX)=0.0
      XNGFLS(3,NU(NY,NX),NY,NX)=0.0
      XN2FLS(3,NU(NY,NX),NY,NX)=0.0
      XHGFLS(3,NU(NY,NX),NY,NX)=0.0
      XN4FLW(3,NU(NY,NX),NY,NX)=0.0
      XN3FLW(3,NU(NY,NX),NY,NX)=0.0
      XNOFLW(3,NU(NY,NX),NY,NX)=0.0
      XNXFLS(3,NU(NY,NX),NY,NX)=0.0
      XH2PFS(3,NU(NY,NX),NY,NX)=0.0
      XN4FLB(3,NU(NY,NX),NY,NX)=0.0
      XN3FLB(3,NU(NY,NX),NY,NX)=0.0
      XNOFLB(3,NU(NY,NX),NY,NX)=0.0
      XNXFLB(3,NU(NY,NX),NY,NX)=0.0
      XH2BFB(3,NU(NY,NX),NY,NX)=0.0
      ENDIF
C
C     HOURLY SOLUTE FLUXES FROM MELTING SNOWPACK TO
C     RESIDUE AND SOIL SURFACE FROM SNOWMELT IN 'WATSUB' AND
C     CONCENTRATIONS IN SNOWPACK
C
      FLQTM=FLQGM(NY,NX)+FLQRM(NY,NX)
      IF(FLQTM.GT.ZEROS(NY,NX))THEN
      VOLWW=VOLWS(NY,NX)+VOLSS(NY,NX)+VOLIS(NY,NX)*0.92
      IF(VOLWW.GT.ZEROS(NY,NX))THEN
      VFLWW=AMAX1(0.0,AMIN1(1.0,FLQTM/VOLWW))
      ELSE
      VFLWW=1.0
      ENDIF
      VFLWG=VFLWW*FLQGM(NY,NX)/FLQTM
      VFLWR=VFLWW*FLQRM(NY,NX)/FLQTM
      XCOBLS(NY,NX)=XCOBLS(NY,NX)-CO2W(NY,NX)*VFLWW
      XCHBLS(NY,NX)=XCHBLS(NY,NX)-CH4W(NY,NX)*VFLWW 
      XOXBLS(NY,NX)=XOXBLS(NY,NX)-OXYW(NY,NX)*VFLWW 
      XNGBLS(NY,NX)=XNGBLS(NY,NX)-ZNGW(NY,NX)*VFLWW 
      XN2BLS(NY,NX)=XN2BLS(NY,NX)-ZN2W(NY,NX)*VFLWW 
      XN4BLW(NY,NX)=XN4BLW(NY,NX)-ZN4W(NY,NX)*VFLWW
      XN3BLW(NY,NX)=XN3BLW(NY,NX)-ZN3W(NY,NX)*VFLWW
      XNOBLW(NY,NX)=XNOBLW(NY,NX)-ZNOW(NY,NX)*VFLWW
      XH2PBS(NY,NX)=XH2PBS(NY,NX)-ZHPW(NY,NX)*VFLWW
      XCOFLS(3,0,NY,NX)=XCOFLS(3,0,NY,NX)+CO2W(NY,NX)*VFLWR
      XCHFLS(3,0,NY,NX)=XCHFLS(3,0,NY,NX)+CH4W(NY,NX)*VFLWR
      XOXFLS(3,0,NY,NX)=XOXFLS(3,0,NY,NX)+OXYW(NY,NX)*VFLWR
      XNGFLS(3,0,NY,NX)=XNGFLS(3,0,NY,NX)+ZNGW(NY,NX)*VFLWR
      XN2FLS(3,0,NY,NX)=XN2FLS(3,0,NY,NX)+ZN2W(NY,NX)*VFLWR
      XN4FLW(3,0,NY,NX)=XN4FLW(3,0,NY,NX)+ZN4W(NY,NX)*VFLWR
      XN3FLW(3,0,NY,NX)=XN3FLW(3,0,NY,NX)+ZN3W(NY,NX)*VFLWR
      XNOFLW(3,0,NY,NX)=XNOFLW(3,0,NY,NX)+ZNOW(NY,NX)*VFLWR
      XH2PFS(3,0,NY,NX)=XH2PFS(3,0,NY,NX)+ZHPW(NY,NX)*VFLWR
      XCOFLS(3,NU(NY,NX),NY,NX)=XCOFLS(3,NU(NY,NX),NY,NX)
     2+CO2W(NY,NX)*VFLWG
      XCHFLS(3,NU(NY,NX),NY,NX)=XCHFLS(3,NU(NY,NX),NY,NX)
     2+CH4W(NY,NX)*VFLWG
      XOXFLS(3,NU(NY,NX),NY,NX)=XOXFLS(3,NU(NY,NX),NY,NX)
     2+OXYW(NY,NX)*VFLWG
      XNGFLS(3,NU(NY,NX),NY,NX)=XNGFLS(3,NU(NY,NX),NY,NX)
     2+ZNGW(NY,NX)*VFLWG
      XN2FLS(3,NU(NY,NX),NY,NX)=XN2FLS(3,NU(NY,NX),NY,NX)
     2+ZN2W(NY,NX)*VFLWG
      XN4FLW(3,NU(NY,NX),NY,NX)=XN4FLW(3,NU(NY,NX),NY,NX)
     2+ZN4W(NY,NX)*VFLWG*VLNH4(NU(NY,NX),NY,NX)
      XN3FLW(3,NU(NY,NX),NY,NX)=XN3FLW(3,NU(NY,NX),NY,NX)
     2+ZN3W(NY,NX)*VFLWG*VLNH4(NU(NY,NX),NY,NX)
      XNOFLW(3,NU(NY,NX),NY,NX)=XNOFLW(3,NU(NY,NX),NY,NX)
     2+ZNOW(NY,NX)*VFLWG*VLNO3(NU(NY,NX),NY,NX)
      XH2PFS(3,NU(NY,NX),NY,NX)=XH2PFS(3,NU(NY,NX),NY,NX)
     2+ZHPW(NY,NX)*VFLWG*VLPO4(NU(NY,NX),NY,NX)
      XN4FLB(3,NU(NY,NX),NY,NX)=XN4FLB(3,NU(NY,NX),NY,NX)
     2+ZN4W(NY,NX)*VFLWG*VLNHB(NU(NY,NX),NY,NX)
      XN3FLB(3,NU(NY,NX),NY,NX)=XN3FLB(3,NU(NY,NX),NY,NX)
     2+ZN3W(NY,NX)*VFLWG*VLNHB(NU(NY,NX),NY,NX)
      XNOFLB(3,NU(NY,NX),NY,NX)=XNOFLB(3,NU(NY,NX),NY,NX)
     2+ZNOW(NY,NX)*VFLWG*VLNOB(NU(NY,NX),NY,NX)
      XH2BFB(3,NU(NY,NX),NY,NX)=XH2BFB(3,NU(NY,NX),NY,NX)
     2+ZHPW(NY,NX)*VFLWG*VLPOB(NU(NY,NX),NY,NX)
      ENDIF
      XCOFHS(3,NU(NY,NX),NY,NX)=0.0
      XCHFHS(3,NU(NY,NX),NY,NX)=0.0
      XOXFHS(3,NU(NY,NX),NY,NX)=0.0
      XNGFHS(3,NU(NY,NX),NY,NX)=0.0
      XN2FHS(3,NU(NY,NX),NY,NX)=0.0
      XHGFHS(3,NU(NY,NX),NY,NX)=0.0
      XN4FHW(3,NU(NY,NX),NY,NX)=0.0
      XN3FHW(3,NU(NY,NX),NY,NX)=0.0
      XNOFHW(3,NU(NY,NX),NY,NX)=0.0
      XH2PHS(3,NU(NY,NX),NY,NX)=0.0
      XN4FHB(3,NU(NY,NX),NY,NX)=0.0
      XN3FHB(3,NU(NY,NX),NY,NX)=0.0
      XNOFHB(3,NU(NY,NX),NY,NX)=0.0
      XNXFHB(3,NU(NY,NX),NY,NX)=0.0
      XH2BHB(3,NU(NY,NX),NY,NX)=0.0
      XNXFHS(3,NU(NY,NX),NY,NX)=0.0
      CO2W2(NY,NX)=CO2W(NY,NX)+XCOBLS(NY,NX)
      CH4W2(NY,NX)=CH4W(NY,NX)+XCHBLS(NY,NX)
      OXYW2(NY,NX)=OXYW(NY,NX)+XOXBLS(NY,NX)
      ZNGW2(NY,NX)=ZNGW(NY,NX)+XNGBLS(NY,NX)
      ZN2W2(NY,NX)=ZN2W(NY,NX)+XN2BLS(NY,NX)
      ZN4W2(NY,NX)=ZN4W(NY,NX)+XN4BLW(NY,NX)
      ZN3W2(NY,NX)=ZN3W(NY,NX)+XN3BLW(NY,NX)
      ZNOW2(NY,NX)=ZNOW(NY,NX)+XNOBLW(NY,NX)
      ZHPW2(NY,NX)=ZHPW(NY,NX)+XH2PBS(NY,NX)
C
C     GAS AND SOLUTE FLUXES AT SUB-HOURLY FLUX TIME STEP
C     ENTERED IN SITE FILE
C
      DO 9845 K=0,2
      ROCFL0(K,NY,NX)=XOCFLS(K,3,0,NY,NX)*XNPH
      RONFL0(K,NY,NX)=XONFLS(K,3,0,NY,NX)*XNPH
      ROPFL0(K,NY,NX)=XOPFLS(K,3,0,NY,NX)*XNPH
      ROAFL0(K,NY,NX)=XOAFLS(K,3,0,NY,NX)*XNPH
      ROCFL1(K,NY,NX)=XOCFLS(K,3,NU(NY,NX),NY,NX)*XNPH
      RONFL1(K,NY,NX)=XONFLS(K,3,NU(NY,NX),NY,NX)*XNPH
      ROPFL1(K,NY,NX)=XOPFLS(K,3,NU(NY,NX),NY,NX)*XNPH
      ROAFL1(K,NY,NX)=XOAFLS(K,3,NU(NY,NX),NY,NX)*XNPH
9845  CONTINUE
      RCOFL0(NY,NX)=XCOFLS(3,0,NY,NX)*XNPH
      RCHFL0(NY,NX)=XCHFLS(3,0,NY,NX)*XNPH
      ROXFL0(NY,NX)=XOXFLS(3,0,NY,NX)*XNPH
      RNGFL0(NY,NX)=XNGFLS(3,0,NY,NX)*XNPH
      RN2FL0(NY,NX)=XN2FLS(3,0,NY,NX)*XNPH
      RHGFL0(NY,NX)=XHGFLS(3,0,NY,NX)*XNPH
      RN4FL0(NY,NX)=XN4FLW(3,0,NY,NX)*XNPH
      RN3FL0(NY,NX)=XN3FLW(3,0,NY,NX)*XNPH
      RNOFL0(NY,NX)=XNOFLW(3,0,NY,NX)*XNPH
      RNXFL0(NY,NX)=XNXFLS(3,0,NY,NX)*XNPH
      RH2PF0(NY,NX)=XH2PFS(3,0,NY,NX)*XNPH
      RCOFL1(NY,NX)=XCOFLS(3,NU(NY,NX),NY,NX)*XNPH
      RCHFL1(NY,NX)=XCHFLS(3,NU(NY,NX),NY,NX)*XNPH
      ROXFL1(NY,NX)=XOXFLS(3,NU(NY,NX),NY,NX)*XNPH
      RNGFL1(NY,NX)=XNGFLS(3,NU(NY,NX),NY,NX)*XNPH
      RN2FL1(NY,NX)=XN2FLS(3,NU(NY,NX),NY,NX)*XNPH
      RHGFL1(NY,NX)=XHGFLS(3,NU(NY,NX),NY,NX)*XNPH
      RN4FL1(NY,NX)=XN4FLW(3,NU(NY,NX),NY,NX)*XNPH
      RN3FL1(NY,NX)=XN3FLW(3,NU(NY,NX),NY,NX)*XNPH
      RNOFL1(NY,NX)=XNOFLW(3,NU(NY,NX),NY,NX)*XNPH
      RNXFL1(NY,NX)=XNXFLS(3,NU(NY,NX),NY,NX)*XNPH
      RH2PF1(NY,NX)=XH2PFS(3,NU(NY,NX),NY,NX)*XNPH
      RN4FL2(NY,NX)=XN4FLB(3,NU(NY,NX),NY,NX)*XNPH
      RN3FL2(NY,NX)=XN3FLB(3,NU(NY,NX),NY,NX)*XNPH
      RNOFL2(NY,NX)=XNOFLB(3,NU(NY,NX),NY,NX)*XNPH
      RNXFL2(NY,NX)=XNXFLB(3,NU(NY,NX),NY,NX)*XNPH
      RH2BF2(NY,NX)=XH2BFB(3,NU(NY,NX),NY,NX)*XNPH
C     IF(I.EQ.118.AND.NX.EQ.3.AND.NY.EQ.4)THEN
C     WRITE(*,6767)'ROXFL0',I,J,NX,NY,ROXFL0(NY,NX),XOXFLS(3,0,NY,NX)
C    2,OXYW(NY,NX),VFLWR 
6767  FORMAT(A8,4I4,12E12.4)
C     ENDIF
C
C     GAS AND SOLUTE SINKS AND SOURCES IN SOIL LAYERS FROM MICROBIAL
C     TRANSFORMATIONS IN 'NITRO' + ROOT EXCHANGE IN 'EXTRACT'
C     + EQUILIBRIA REACTIONS IN 'SOLUTE' AT SUB-HOURLY TIME STEP
C
      CLSGL2(0,NY,NX)=CLSGL(0,NY,NX)*XNPH
      CQSGL2(0,NY,NX)=CQSGL(0,NY,NX)*XNPH
      OLSGL2(0,NY,NX)=OLSGL(0,NY,NX)*XNPH
      ZLSGL2(0,NY,NX)=ZLSGL(0,NY,NX)*XNPH
      ZNSGL2(0,NY,NX)=ZNSGL(0,NY,NX)*XNPH
      ZVSGL2(0,NY,NX)=ZVSGL(0,NY,NX)*XNPH
      HLSGL2(0,NY,NX)=HLSGL(0,NY,NX)*XNPH
      OCSGL2(0,NY,NX)=OCSGL(0,NY,NX)*XNPH
      ONSGL2(0,NY,NX)=ONSGL(0,NY,NX)*XNPH
      OPSGL2(0,NY,NX)=OPSGL(0,NY,NX)*XNPH
      OASGL2(0,NY,NX)=OASGL(0,NY,NX)*XNPH
      ZOSGL2(0,NY,NX)=ZOSGL(0,NY,NX)*XNPH
      POSGL2(0,NY,NX)=POSGL(0,NY,NX)*XNPH
      PARGM=PARG(NY,NX)*XNPT
      PARGCO(NY,NX)=PARGM*0.74
      PARGCH(NY,NX)=PARGM*1.04
      PARGOX(NY,NX)=PARGM*0.83
      PARGNG(NY,NX)=PARGM*0.86
      PARGN2(NY,NX)=PARGM*0.74
      PARGN3(NY,NX)=PARGM*1.02
      PARGH2(NY,NX)=PARGM*2.08
      DO 10 L=NU(NY,NX),NL(NY,NX)
      CHY0(L,NY,NX)=10.0**(-(PH(L,NY,NX)-3.0))
      FLWU(L,NY,NX)=TUPWTR(L,NY,NX)*XNPH
      RCOSK2(L,NY,NX)=(RCO2O(L,NY,NX)+TCO2S(L,NY,NX)+TRCO2(L,NY,NX))
     2*XNPG
      RCHSK2(L,NY,NX)=(RCH4O(L,NY,NX)+TUPCHS(L,NY,NX))*XNPG
      RNGSK2(L,NY,NX)=(RN2G(L,NY,NX)+XN2GS(L,NY,NX)+TUPNF(L,NY,NX))
     2*XNPG
      RN2SK2(L,NY,NX)=(RN2O(L,NY,NX)+TUPN2S(L,NY,NX))*XNPG
      RNHSK2(L,NY,NX)=-TRN3G(L,NY,NX)*XNPG
      RHGSK2(L,NY,NX)=(RH2GO(L,NY,NX)+TUPHGS(L,NY,NX))*XNPG
      DO 15 K=0,4
      ROCSK2(K,L,NY,NX)=-XOQCS(K,L,NY,NX)*XNPH
      RONSK2(K,L,NY,NX)=-XOQNS(K,L,NY,NX)*XNPH
      ROPSK2(K,L,NY,NX)=-XOQPS(K,L,NY,NX)*XNPH
      ROASK2(K,L,NY,NX)=-XOQAS(K,L,NY,NX)*XNPH
15    CONTINUE
      RN4SK2(L,NY,NX)=(-XNH4S(L,NY,NX)-TRN4S(L,NY,NX)
     2+TUPNH4(L,NY,NX))*XNPH
      RN3SK2(L,NY,NX)=(-TRN3S(L,NY,NX)+TUPN3S(L,NY,NX))*XNPH
      RNOSK2(L,NY,NX)=(-XNO3S(L,NY,NX)-TRNO3(L,NY,NX)
     2+TUPNO3(L,NY,NX))*XNPH
      RNXSK2(L,NY,NX)=(-XNO2S(L,NY,NX)-TRNO2(L,NY,NX))*XNPH
      RHPSK2(L,NY,NX)=(-XH2PS(L,NY,NX)-TRH2P(L,NY,NX)
     2+TUPH2P(L,NY,NX))*XNPH
      R4BSK2(L,NY,NX)=(-XNH4B(L,NY,NX)-TRN4B(L,NY,NX)
     2+TUPNHB(L,NY,NX))*XNPH
      R3BSK2(L,NY,NX)=(-TRN3B(L,NY,NX)+TUPN3B(L,NY,NX))*XNPH
      RNBSK2(L,NY,NX)=(-XNO3B(L,NY,NX)-TRNOB(L,NY,NX)
     2+TUPNOB(L,NY,NX))*XNPH
      RNZSK2(L,NY,NX)=(-XNO2B(L,NY,NX)-TRN2B(L,NY,NX))*XNPH
      RHBSK2(L,NY,NX)=(-XH2BS(L,NY,NX)-TRH2B(L,NY,NX)
     2+TUPH2B(L,NY,NX))*XNPH
C
C     HOURLY SOLUTE FLUXES FROM SUBSURFACE IRRIGATION
C
      RCOFLU(L,NY,NX)=FLU(L,NY,NX)*CCOQ(NY,NX)
      RCHFLU(L,NY,NX)=FLU(L,NY,NX)*CCHQ(NY,NX)
      ROXFLU(L,NY,NX)=FLU(L,NY,NX)*COXQ(NY,NX)
      RNGFLU(L,NY,NX)=FLU(L,NY,NX)*CNNQ(NY,NX)
      RN2FLU(L,NY,NX)=FLU(L,NY,NX)*CN2Q(NY,NX)
      RHGFLU(L,NY,NX)=0.0
      RN4FLU(L,NY,NX)=FLU(L,NY,NX)*CN4Q(I,NY,NX)*VLNH4(L,NY,NX)*14.0
      RN3FLU(L,NY,NX)=FLU(L,NY,NX)*CN3Q(I,NY,NX)*VLNH4(L,NY,NX)*14.0
      RNOFLU(L,NY,NX)=FLU(L,NY,NX)*CNOQ(I,NY,NX)*VLNO3(L,NY,NX)*14.0
      RH2PFU(L,NY,NX)=FLU(L,NY,NX)*CPOQ(I,NY,NX)*VLPO4(L,NY,NX)*31.0
      RN4FBU(L,NY,NX)=FLU(L,NY,NX)*CN4Q(I,NY,NX)*VLNHB(L,NY,NX)*14.0
      RN3FBU(L,NY,NX)=FLU(L,NY,NX)*CN3Q(I,NY,NX)*VLNHB(L,NY,NX)*14.0
      RNOFBU(L,NY,NX)=FLU(L,NY,NX)*CNOQ(I,NY,NX)*VLNOB(L,NY,NX)*14.0
      RH2BBU(L,NY,NX)=FLU(L,NY,NX)*CPOQ(I,NY,NX)*VLPOB(L,NY,NX)*31.0
C
C     SUB-HOURLY SOLUTE FLUXES FROM SUBSURFACE IRRIGATION
C
      RCOFLZ(L,NY,NX)=RCOFLU(L,NY,NX)*XNPH
      RCHFLZ(L,NY,NX)=RCHFLU(L,NY,NX)*XNPH
      ROXFLZ(L,NY,NX)=ROXFLU(L,NY,NX)*XNPH
      RNGFLZ(L,NY,NX)=RNGFLU(L,NY,NX)*XNPH
      RN2FLZ(L,NY,NX)=RN2FLU(L,NY,NX)*XNPH
      RHGFLZ(L,NY,NX)=RHGFLU(L,NY,NX)*XNPH
      RN4FLZ(L,NY,NX)=RN4FLU(L,NY,NX)*XNPH
      RN3FLZ(L,NY,NX)=RN3FLU(L,NY,NX)*XNPH
      RNOFLZ(L,NY,NX)=RNOFLU(L,NY,NX)*XNPH
      RH2PFZ(L,NY,NX)=RH2PFU(L,NY,NX)*XNPH
      RN4FBZ(L,NY,NX)=RN4FBU(L,NY,NX)*XNPH
      RN3FBZ(L,NY,NX)=RN3FBU(L,NY,NX)*XNPH
      RNOFBZ(L,NY,NX)=RNOFBU(L,NY,NX)*XNPH
      RH2BBZ(L,NY,NX)=RH2BBU(L,NY,NX)*XNPH
C
C     GAS AND SOLUTE DIFFUSIVITIES AT SUB-HOURLY TIME STEP
C
      OCSGL2(L,NY,NX)=OCSGL(L,NY,NX)*XNPH
      ONSGL2(L,NY,NX)=ONSGL(L,NY,NX)*XNPH
      OPSGL2(L,NY,NX)=OPSGL(L,NY,NX)*XNPH
      OASGL2(L,NY,NX)=OASGL(L,NY,NX)*XNPH
      CLSGL2(L,NY,NX)=CLSGL(L,NY,NX)*XNPH
      CQSGL2(L,NY,NX)=CQSGL(L,NY,NX)*XNPH
      OLSGL2(L,NY,NX)=OLSGL(L,NY,NX)*XNPH
      ZLSGL2(L,NY,NX)=ZLSGL(L,NY,NX)*XNPH
      ZVSGL2(L,NY,NX)=ZVSGL(L,NY,NX)*XNPH
      ZNSGL2(L,NY,NX)=ZNSGL(L,NY,NX)*XNPH
      HLSGL2(L,NY,NX)=HLSGL(L,NY,NX)*XNPH
      ZOSGL2(L,NY,NX)=ZOSGL(L,NY,NX)*XNPH
      POSGL2(L,NY,NX)=POSGL(L,NY,NX)*XNPH
      CGSGL2(L,NY,NX)=CGSGL(L,NY,NX)*XNPG
      CHSGL2(L,NY,NX)=CHSGL(L,NY,NX)*XNPG
      OGSGL2(L,NY,NX)=OGSGL(L,NY,NX)*XNPG
      ZGSGL2(L,NY,NX)=ZGSGL(L,NY,NX)*XNPG
      Z2SGL2(L,NY,NX)=Z2SGL(L,NY,NX)*XNPG
      ZHSGL2(L,NY,NX)=ZHSGL(L,NY,NX)*XNPG
      HGSGL2(L,NY,NX)=HGSGL(L,NY,NX)*XNPG
C
C     STATE VARIABLES FOR GASES AND SOLUTES USED IN 'TRNSFR'
C     TO STORE SUB-HOURLY CHANGES DURING FLUX CALCULATIONS
C     INCLUDING TRANSFORMATIONS FROM 'NITRO', 'UPTAKE' AND 'SOLUTE'
C
      CO2G2(L,NY,NX)=CO2G(L,NY,NX)
      CH4G2(L,NY,NX)=CH4G(L,NY,NX)
      OXYG2(L,NY,NX)=OXYG(L,NY,NX)
      ZN3G2(L,NY,NX)=ZNH3G(L,NY,NX)
      Z2GG2(L,NY,NX)=Z2GG(L,NY,NX)
      Z2OG2(L,NY,NX)=Z2OG(L,NY,NX)
      H2GG2(L,NY,NX)=H2GG(L,NY,NX)
      CO2S2(L,NY,NX)=CO2S(L,NY,NX) 
      CH4S2(L,NY,NX)=CH4S(L,NY,NX) 
      OXYS2(L,NY,NX)=OXYS(L,NY,NX) 
      Z2GS2(L,NY,NX)=Z2GS(L,NY,NX) 
      Z2OS2(L,NY,NX)=Z2OS(L,NY,NX) 
      H2GS2(L,NY,NX)=H2GS(L,NY,NX) 
      DO 9980 K=0,4
      OQC2(K,L,NY,NX)=OQC(K,L,NY,NX)-XOQCS(K,L,NY,NX)
      OQN2(K,L,NY,NX)=OQN(K,L,NY,NX)-XOQNS(K,L,NY,NX)
      OQP2(K,L,NY,NX)=OQP(K,L,NY,NX)-XOQPS(K,L,NY,NX)
      OQA2(K,L,NY,NX)=OQA(K,L,NY,NX)-XOQAS(K,L,NY,NX)
      OQCH2(K,L,NY,NX)=OQCH(K,L,NY,NX)
      OQNH2(K,L,NY,NX)=OQNH(K,L,NY,NX)
      OQPH2(K,L,NY,NX)=OQPH(K,L,NY,NX)
      OQAH2(K,L,NY,NX)=OQAH(K,L,NY,NX)
9980  CONTINUE
      ZNH4S2(L,NY,NX)=ZNH4S(L,NY,NX) 
      ZN3S2(L,NY,NX)=ZNH3S(L,NY,NX) 
      ZNO3S2(L,NY,NX)=ZNO3S(L,NY,NX)
      ZNO2S2(L,NY,NX)=ZNO2S(L,NY,NX)
      H2PO42(L,NY,NX)=H2PO4(L,NY,NX)
      ZNH4B2(L,NY,NX)=ZNH4B(L,NY,NX)
      ZNBS2(L,NY,NX)=ZNH3B(L,NY,NX) 
      ZNO3B2(L,NY,NX)=ZNO3B(L,NY,NX)
      ZNO2B2(L,NY,NX)=ZNO2B(L,NY,NX)
      H2POB2(L,NY,NX)=H2POB(L,NY,NX)
      CO2SH2(L,NY,NX)=CO2SH(L,NY,NX)
      CH4SH2(L,NY,NX)=CH4SH(L,NY,NX)
      OXYSH2(L,NY,NX)=OXYSH(L,NY,NX)
      Z2GSH2(L,NY,NX)=Z2GSH(L,NY,NX)
      Z2OSH2(L,NY,NX)=Z2OSH(L,NY,NX)
      H2GSH2(L,NY,NX)=H2GSH(L,NY,NX)
      ZNH4H2(L,NY,NX)=ZNH4SH(L,NY,NX)
      ZNH3H2(L,NY,NX)=ZNH3SH(L,NY,NX)
      ZNO3H2(L,NY,NX)=ZNO3SH(L,NY,NX)
      ZNO2H2(L,NY,NX)=ZNO2SH(L,NY,NX)
      H2P4H2(L,NY,NX)=H2PO4H(L,NY,NX)
      ZN4BH2(L,NY,NX)=ZNH4BH(L,NY,NX)
      ZN3BH2(L,NY,NX)=ZNH3BH(L,NY,NX)
      ZNOBH2(L,NY,NX)=ZNO3BH(L,NY,NX)
      ZN2BH2(L,NY,NX)=ZNO2BH(L,NY,NX)
      H2PBH2(L,NY,NX)=H2POBH(L,NY,NX)
C     IF(CDPTH(L,NY,NX).LT.DPNH4(NY,NX).AND.ROWN(NY,NX).GT.0.0)THEN
C     VLNHB(L,NY,NX)=WDNHB(L,NY,NX)/ROWN(NY,NX)
C     ELSE
C     VLNHB(L,NY,NX)=0.0
C     ENDIF
C     VLNH4(L,NY,NX)=1.0-VLNHB(L,NY,NX)
C     IF(CDPTH(L-1,NY,NX).LT.DPNO3(NY,NX).AND.ROWO(NY,NX).GT.0.0)THEN
C     VLNOB(L,NY,NX)=WDNOB(L,NY,NX)/ROWO(NY,NX)
C     ELSE
C     VLNOB(L,NY,NX)=0.0
C     ENDIF
C     VLNO3(L,NY,NX)=1.0-VLNOB(L,NY,NX)
C     IF(CDPTH(L,NY,NX).LT.DPPO4(NY,NX).AND.ROWP(NY,NX).GT.0.0)THEN
C     VLPOB(L,NY,NX)=WDPOB(L,NY,NX)/ROWP(NY,NX)
C     ELSE
C     VLPOB(L,NY,NX)=0.0
C     ENDIF
C     VLPO4(L,NY,NX)=1.0-VLPOB(L,NY,NX)
10    CONTINUE
9990  CONTINUE

9995  CONTINUE
C
C     TIME STEP USED IN GAS AND SOLUTE FLUX CALCULATIONS
C
      MX=0
      DO 30 MM=1,NPG
      M=MIN(NPH,INT((MM-1)*XNPT)+1)
      DO 9895 NX=NHW,NHE
      DO 9890 NY=NVN,NVS
      IF(M.NE.MX)THEN
C
C     RESET RUNOFF SOLUTE FLUX ACCUMULATORS
C
      DO 9880 K=0,2
      TQROC(K,NY,NX)=0.0
      TQRON(K,NY,NX)=0.0
      TQROP(K,NY,NX)=0.0
      TQROA(K,NY,NX)=0.0
      OQC2(K,0,NY,NX)=OQC2(K,0,NY,NX)-ROCSK2(K,0,NY,NX)
      OQN2(K,0,NY,NX)=OQN2(K,0,NY,NX)-RONSK2(K,0,NY,NX)
      OQP2(K,0,NY,NX)=OQP2(K,0,NY,NX)-ROPSK2(K,0,NY,NX)
      OQA2(K,0,NY,NX)=OQA2(K,0,NY,NX)-ROASK2(K,0,NY,NX)
9880  CONTINUE
      TQRCOS(NY,NX)=0.0
      TQRCHS(NY,NX)=0.0
      TQROXS(NY,NX)=0.0
      TQRNGS(NY,NX)=0.0
      TQRN2S(NY,NX)=0.0
      TQRHGS(NY,NX)=0.0
      TQRNH4(NY,NX)=0.0
      TQRNH3(NY,NX)=0.0
      TQRNO3(NY,NX)=0.0
      TQRNO2(NY,NX)=0.0
      TQRH2P(NY,NX)=0.0
      TQSCOS(NY,NX)=0.0
      TQSCHS(NY,NX)=0.0
      TQSOXS(NY,NX)=0.0
      TQSNGS(NY,NX)=0.0
      TQSN2S(NY,NX)=0.0
      TQSNH4(NY,NX)=0.0
      TQSNH3(NY,NX)=0.0
      TQSNO3(NY,NX)=0.0
      TQSH2P(NY,NX)=0.0
      ZNH4S2(0,NY,NX)=ZNH4S2(0,NY,NX)-RN4SK2(0,NY,NX) 
      ZN3S2(0,NY,NX)=ZN3S2(0,NY,NX)-RN3SK2(0,NY,NX)
      ZNO3S2(0,NY,NX)=ZNO3S2(0,NY,NX)-RNOSK2(0,NY,NX) 
      ZNO2S2(0,NY,NX)=ZNO2S2(0,NY,NX)-RNXSK2(0,NY,NX)
      H2PO42(0,NY,NX)=H2PO42(0,NY,NX)-RHPSK2(0,NY,NX) 
      ROXSK2(0,NY,NX)=ROXSK(M,0,NY,NX)*XNPT 
      ENDIF
      CO2S2(0,NY,NX)=CO2S2(0,NY,NX)-RCOSK2(0,NY,NX)
      CH4S2(0,NY,NX)=CH4S2(0,NY,NX)-RCHSK2(0,NY,NX)
      OXYS2(0,NY,NX)=OXYS2(0,NY,NX)-ROXSK2(0,NY,NX) 
      Z2GS2(0,NY,NX)=Z2GS2(0,NY,NX)-RNGSK2(0,NY,NX)
      Z2OS2(0,NY,NX)=Z2OS2(0,NY,NX)-RN2SK2(0,NY,NX)
      H2GS2(0,NY,NX)=H2GS2(0,NY,NX)-RHGSK2(0,NY,NX) 
      ZN3G2(0,NY,NX)=ZN3G2(0,NY,NX)-RNHSK2(0,NY,NX)
      DO 9885 L=NU(NY,NX),NL(NY,NX)
C
C     RESET SOIL SOLUTE FLUX ACCUMULATORS
C
      IF(M.NE.MX)THEN
      DO 9875 K=0,4
      TOCFLS(K,L,NY,NX)=0.0
      TONFLS(K,L,NY,NX)=0.0
      TOPFLS(K,L,NY,NX)=0.0
      TOAFLS(K,L,NY,NX)=0.0
      TOCFHS(K,L,NY,NX)=0.0
      TONFHS(K,L,NY,NX)=0.0
      TOPFHS(K,L,NY,NX)=0.0
      TOAFHS(K,L,NY,NX)=0.0
      OQC2(K,L,NY,NX)=OQC2(K,L,NY,NX)-ROCSK2(K,L,NY,NX)
      OQN2(K,L,NY,NX)=OQN2(K,L,NY,NX)-RONSK2(K,L,NY,NX)
      OQP2(K,L,NY,NX)=OQP2(K,L,NY,NX)-ROPSK2(K,L,NY,NX)
      OQA2(K,L,NY,NX)=OQA2(K,L,NY,NX)-ROASK2(K,L,NY,NX)
9875  CONTINUE
      TCOFLS(L,NY,NX)=0.0
      TCHFLS(L,NY,NX)=0.0
      TOXFLS(L,NY,NX)=0.0
      TNGFLS(L,NY,NX)=0.0
      TN2FLS(L,NY,NX)=0.0
      THGFLS(L,NY,NX)=0.0
      TN4FLW(L,NY,NX)=0.0
      TN3FLW(L,NY,NX)=0.0
      TNOFLW(L,NY,NX)=0.0
      TNXFLS(L,NY,NX)=0.0
      TH2PFS(L,NY,NX)=0.0
      TN4FLB(L,NY,NX)=0.0
      TN3FLB(L,NY,NX)=0.0
      TNOFLB(L,NY,NX)=0.0
      TNXFLB(L,NY,NX)=0.0
      TH2BFB(L,NY,NX)=0.0
      TCOFHS(L,NY,NX)=0.0
      TCHFHS(L,NY,NX)=0.0
      TOXFHS(L,NY,NX)=0.0
      TNGFHS(L,NY,NX)=0.0
      TN2FHS(L,NY,NX)=0.0
      THGFHS(L,NY,NX)=0.0
      TN4FHW(L,NY,NX)=0.0
      TN3FHW(L,NY,NX)=0.0
      TNOFHW(L,NY,NX)=0.0
      TNXFHS(L,NY,NX)=0.0
      TH2PHS(L,NY,NX)=0.0
      TN4FHB(L,NY,NX)=0.0
      TN3FHB(L,NY,NX)=0.0
      TNOFHB(L,NY,NX)=0.0
      TNXFHB(L,NY,NX)=0.0
      TH2BHB(L,NY,NX)=0.0
      ZNH4S2(L,NY,NX)=ZNH4S2(L,NY,NX)-RN4SK2(L,NY,NX) 
      ZN3S2(L,NY,NX)=ZN3S2(L,NY,NX)-RN3SK2(L,NY,NX)
      ZNO3S2(L,NY,NX)=ZNO3S2(L,NY,NX)-RNOSK2(L,NY,NX) 
      ZNO2S2(L,NY,NX)=ZNO2S2(L,NY,NX)-RNXSK2(L,NY,NX)
      H2PO42(L,NY,NX)=H2PO42(L,NY,NX)-RHPSK2(L,NY,NX) 
      ZNH4B2(L,NY,NX)=ZNH4B2(L,NY,NX)-R4BSK2(L,NY,NX)
      ZNBS2(L,NY,NX)=ZNBS2(L,NY,NX)-R3BSK2(L,NY,NX) 
      ZNO3B2(L,NY,NX)=ZNO3B2(L,NY,NX)-RNBSK2(L,NY,NX)
      ZNO2B2(L,NY,NX)=ZNO2B2(L,NY,NX)-RNZSK2(L,NY,NX)
      H2POB2(L,NY,NX)=H2POB2(L,NY,NX)-RHBSK2(L,NY,NX)
      ROXSK2(L,NY,NX)=ROXSK(M,L,NY,NX)*XNPT 
      ENDIF
C
C     SOIL GAS FLUX ACCUMULATORS
C
      TCOFLG(L,NY,NX)=0.0
      TCHFLG(L,NY,NX)=0.0
      TOXFLG(L,NY,NX)=0.0
      TNGFLG(L,NY,NX)=0.0
      TN2FLG(L,NY,NX)=0.0
      TN3FLG(L,NY,NX)=0.0
      THGFLG(L,NY,NX)=0.0
      CO2S2(L,NY,NX)=CO2S2(L,NY,NX)-RCOSK2(L,NY,NX) 
      CH4S2(L,NY,NX)=CH4S2(L,NY,NX)-RCHSK2(L,NY,NX) 
      OXYS2(L,NY,NX)=OXYS2(L,NY,NX)-ROXSK2(L,NY,NX) 
      Z2GS2(L,NY,NX)=Z2GS2(L,NY,NX)-RNGSK2(L,NY,NX)
      Z2OS2(L,NY,NX)=Z2OS2(L,NY,NX)-RN2SK2(L,NY,NX) 
      H2GS2(L,NY,NX)=H2GS2(L,NY,NX)-RHGSK2(L,NY,NX)
      ZN3G2(L,NY,NX)=ZN3G2(L,NY,NX)-RNHSK2(L,NY,NX)
9885  CONTINUE
      IF(M.NE.MX)THEN
C
C     SOLUTE FLUXES AT SOIL SURFACE FROM SURFACE WATER
C     CONTENTS, WATER FLUXES 'FLQM' AND ATMOSPHERE BOUNDARY
C     LAYER RESISTANCES 'PARGM' FROM 'WATSUB'
C
      VOLWMA(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*VLNH4(NU(NY,NX),NY,NX)
      VOLWMB(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*VLNHB(NU(NY,NX),NY,NX)
      VOLWXA(NU(NY,NX),NY,NX)=14.0*VOLWMA(NU(NY,NX),NY,NX)
      VOLWXB(NU(NY,NX),NY,NX)=14.0*VOLWMB(NU(NY,NX),NY,NX)
      VOLWOA=VOLWM(M,NU(NY,NX),NY,NX)*VLNO3(NU(NY,NX),NY,NX)
      VOLWOB=VOLWM(M,NU(NY,NX),NY,NX)*VLNOB(NU(NY,NX),NY,NX)
      VOLWPA=VOLWM(M,NU(NY,NX),NY,NX)*VLPO4(NU(NY,NX),NY,NX)
      VOLWPB=VOLWM(M,NU(NY,NX),NY,NX)*VLPOB(NU(NY,NX),NY,NX)
      VOLPMA(NU(NY,NX),NY,NX)=VOLPM(M,NU(NY,NX),NY,NX)
     2*VLNH4(NU(NY,NX),NY,NX)
      VOLPMB(NU(NY,NX),NY,NX)=VOLPM(M,NU(NY,NX),NY,NX)
     2*VLNHB(NU(NY,NX),NY,NX)
      THETW1(NU(NY,NX),NY,NX)=AMAX1(0.0,VOLWM(M,NU(NY,NX),NY,NX)
     2/VOLX(NU(NY,NX),NY,NX))
      FLVM(NU(NY,NX),NY,NX)=FLPM(M,NU(NY,NX),NY,NX)*XNPT
      FLQM(3,NU(NY,NX),NY,NX)=(FLWM(M,3,NU(NY,NX),NY,NX)
     2+FLWHM(M,3,NU(NY,NX),NY,NX))*XNPT
C
C     SURFACE EXCHANGE OF AQUEOUS CO2, CH4, O2, N2, NH3
C     THROUGH VOLATILIZATION-DISSOLUTION FROM AQUEOUS
C     DIFFUSIVITIES IN SURFACE RESIDUE
C
      VOLWCO(0,NY,NX)=VOLWM(M,0,NY,NX)*SCO2L(0,NY,NX)
      VOLWCH(0,NY,NX)=VOLWM(M,0,NY,NX)*SCH4L(0,NY,NX)
      VOLWOX(0,NY,NX)=VOLWM(M,0,NY,NX)*SOXYL(0,NY,NX)
      VOLWNG(0,NY,NX)=VOLWM(M,0,NY,NX)*SN2GL(0,NY,NX)
      VOLWN2(0,NY,NX)=VOLWM(M,0,NY,NX)*SN2OL(0,NY,NX)
      VOLWN3(0,NY,NX)=VOLWM(M,0,NY,NX)*SNH3L(0,NY,NX)
      VOLWHG(0,NY,NX)=VOLWM(M,0,NY,NX)*SH2GL(0,NY,NX)
      VOLWXA(0,NY,NX)=14.0*VOLWM(M,0,NY,NX)
      VOLCOR(NY,NX)=VOLWCO(0,NY,NX)+VOLPM(M,0,NY,NX)
      VOLCHR(NY,NX)=VOLWCH(0,NY,NX)+VOLPM(M,0,NY,NX)
      VOLOXR(NY,NX)=VOLWOX(0,NY,NX)+VOLPM(M,0,NY,NX)
      VOLNGR(NY,NX)=VOLWNG(0,NY,NX)+VOLPM(M,0,NY,NX)
      VOLN2R(NY,NX)=VOLWN2(0,NY,NX)+VOLPM(M,0,NY,NX)
      VOLN3R(NY,NX)=VOLWN3(0,NY,NX)+VOLPM(M,0,NY,NX)
      VOLHGR(NY,NX)=VOLWHG(0,NY,NX)+VOLPM(M,0,NY,NX)
      PARGPM=PARR(NY,NX)*VOLPM(M,0,NY,NX)
      DFGSPM=DFGSS*VOLPM(M,0,NY,NX)
C
C     EQUILIBRIUM CONCENTRATIONS AT RESIDUE SURFACE AT WHICH
C     AQUEOUS DIFFUSION THROUGH RESIDUE SURFACE LAYER = GASEOUS
C     DIFFUSION THROUGH ATMOSPHERE BOUNDARY LAYER CALCULATED
C     FROM AQUEOUS DIFFUSIVITY AND BOUNDARY LAYER CONDUCTANCE
C
      CO2GQ=(PARGPM*CCO2E(NY,NX)*VOLCOR(NY,NX)+DFGSPM
     2*CO2S2(0,NY,NX))/(DFGSS*VOLWCO(0,NY,NX)
     3+PARR(NY,NX)*VOLCOR(NY,NX))
      CH4GQ=(PARGPM*CCH4E(NY,NX)*VOLCHR(NY,NX)+DFGSPM
     2*CH4S2(0,NY,NX))/(DFGSS*VOLWCH(0,NY,NX)
     3+PARR(NY,NX)*VOLCHR(NY,NX))
      OXYGQ=(PARGPM*COXYE(NY,NX)*VOLOXR(NY,NX)+DFGSPM
     2*OXYS2(0,NY,NX))/(DFGSS*VOLWOX(0,NY,NX)
     3+PARR(NY,NX)*VOLOXR(NY,NX))
      Z2GGQ=(PARGPM*CZ2GE(NY,NX)*VOLNGR(NY,NX)+DFGSPM
     2*Z2GS2(0,NY,NX))/(DFGSS*VOLWNG(0,NY,NX)
     3+PARR(NY,NX)*VOLNGR(NY,NX))
      Z2OGQ=(PARGPM*CZ2OE(NY,NX)*VOLN2R(NY,NX)+DFGSPM
     2*Z2OS2(0,NY,NX))/(DFGSS*VOLWN2(0,NY,NX)
     3+PARR(NY,NX)*VOLN2R(NY,NX))
      ZN3GQ=(PARGPM*CNH3E(NY,NX)*VOLN3R(NY,NX)+DFGSPM
     2*ZN3S2(0,NY,NX))/(DFGSS*VOLWN3(0,NY,NX)
     3+PARR(NY,NX)*VOLN3R(NY,NX))
      H2GGQ=(PARGPM*CH2GE(NY,NX)*VOLHGR(NY,NX)+DFGSPM
     2*H2GS2(0,NY,NX))/(DFGSS*VOLWHG(0,NY,NX)
     3+PARR(NY,NX)*VOLHGR(NY,NX))
C
C     SURFACE VOLATILIZATION-DISSOLUTION FROM DIFFERENCES
C     BETWEEN ATMOSPHERIC AND RESIDUE SURFACE EQUILIBRIUM
C     CONCENTRATIONS
C
      RCODFR(NY,NX)=DFGSS*(CO2GQ*VOLWCO(0,NY,NX)
     3-CO2S2(0,NY,NX)*VOLPM(M,0,NY,NX))/VOLCOR(NY,NX)
      RCHDFR(NY,NX)=DFGSS*(CH4GQ*VOLWCH(0,NY,NX)
     3-CH4S2(0,NY,NX)*VOLPM(M,0,NY,NX))/VOLCHR(NY,NX)
      ROXDFR(NY,NX)=DFGSS*(OXYGQ*VOLWOX(0,NY,NX)
     3-OXYS2(0,NY,NX)*VOLPM(M,0,NY,NX))/VOLOXR(NY,NX)
      RNGDFR(NY,NX)=DFGSS*(Z2GGQ*VOLWNG(0,NY,NX)
     3-Z2GS2(0,NY,NX)*VOLPM(M,0,NY,NX))/VOLNGR(NY,NX)
      RN2DFR(NY,NX)=DFGSS*(Z2OGQ*VOLWN2(0,NY,NX)
     3-Z2OS2(0,NY,NX)*VOLPM(M,0,NY,NX))/VOLN2R(NY,NX)
      RN3DFR(NY,NX)=DFGSS*(ZN3GQ*VOLWN3(0,NY,NX)
     3-ZN3S2(0,NY,NX)*VOLPM(M,0,NY,NX))/VOLN3R(NY,NX)
      RHGDFR(NY,NX)=DFGSS*(H2GGQ*VOLWHG(0,NY,NX)
     3-H2GS2(0,NY,NX)*VOLPM(M,0,NY,NX))/VOLHGR(NY,NX)
C     IF(I.EQ.268)THEN
C     WRITE(*,1118)'RCODFR',I,J,NX,NY,M,MM,CO2S2(0,NY,NX)
C    2,RCODFR(NY,NX),PARR(NY,NX),CCO2E(NY,NX),CCO2Q
C    3,DCO21,CCO22,SCO2L(0,NY,NX),TORT1,THETW1(0,NY,NX)
C    4,DLYR(3,0,NY,NX),VOLWM(M,0,NY,NX)
C     WRITE(*,1118)'ROXDFR',I,J,NX,NY,M,MM,OXYS2(0,NY,NX)
C    2,ROXDFR(NY,NX),PARR(NY,NX),COXYE(NY,NX),COXYSQ
C    3,DOXY1,COXYS2,SOXYL(0,NY,NX),TORT1,THETW1(0,NY,NX)
C    4,DLYR(3,0,NY,NX),DPT0,VOLGM(M,NY,NX)
1118  FORMAT(A8,6I4,20E12.4)
C     ENDIF
C
C     ACCUMULATE HOURLY FLUXES
C
      XCODFR(NY,NX)=XCODFR(NY,NX)+RCODFR(NY,NX)
      XCHDFR(NY,NX)=XCHDFR(NY,NX)+RCHDFR(NY,NX)
      XOXDFR(NY,NX)=XOXDFR(NY,NX)+ROXDFR(NY,NX)
      XNGDFR(NY,NX)=XNGDFR(NY,NX)+RNGDFR(NY,NX)
      XN2DFR(NY,NX)=XN2DFR(NY,NX)+RN2DFR(NY,NX)
      XN3DFR(NY,NX)=XN3DFR(NY,NX)+RN3DFR(NY,NX)
      XHGDFR(NY,NX)=XHGDFR(NY,NX)+RHGDFR(NY,NX)
C
C     SURFACE EXCHANGE OF AQUEOUS CO2, CH4, O2, N2, NH3
C     THROUGH VOLATILIZATION-DISSOLUTION FROM AQUEOUS
C     DIFFUSIVITIES IN SURFACE SOIL LAYER
C
      IF(VOLPM(M,0,NY,NX).GT.ZEROS(NY,NX))THEN
      VOLWCO(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*SCO2L(NU(NY,NX),NY,NX)
      VOLWCH(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*SCH4L(NU(NY,NX),NY,NX)
      VOLWOX(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*SOXYL(NU(NY,NX),NY,NX)
      VOLWNG(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*SN2GL(NU(NY,NX),NY,NX)
      VOLWN2(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*SN2OL(NU(NY,NX),NY,NX)
      VOLWN3(NU(NY,NX),NY,NX)=VOLWMA(NU(NY,NX),NY,NX)
     2*SNH3L(NU(NY,NX),NY,NX)
      VOLWNB(NU(NY,NX),NY,NX)=VOLWMB(NU(NY,NX),NY,NX)
     2*SNH3L(NU(NY,NX),NY,NX)
      VOLWHG(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*SH2GL(NU(NY,NX),NY,NX)
      VOLCOT(NY,NX)=VOLWCO(NU(NY,NX),NY,NX)+VOLPM(M,NU(NY,NX),NY,NX)
      VOLCHT(NY,NX)=VOLWCH(NU(NY,NX),NY,NX)+VOLPM(M,NU(NY,NX),NY,NX)
      VOLOXT(NY,NX)=VOLWOX(NU(NY,NX),NY,NX)+VOLPM(M,NU(NY,NX),NY,NX)
      VOLNGT(NY,NX)=VOLWNG(NU(NY,NX),NY,NX)+VOLPM(M,NU(NY,NX),NY,NX)
      VOLN2T(NY,NX)=VOLWN2(NU(NY,NX),NY,NX)+VOLPM(M,NU(NY,NX),NY,NX)
      VOLN3T(NY,NX)=VOLWN3(NU(NY,NX),NY,NX)+VOLPMA(NU(NY,NX),NY,NX)
      VOLNBT(NY,NX)=VOLWNB(NU(NY,NX),NY,NX)+VOLPMB(NU(NY,NX),NY,NX)
      VOLHGT(NY,NX)=VOLWHG(NU(NY,NX),NY,NX)+VOLPM(M,NU(NY,NX),NY,NX)
      PARGPM=PARG(NY,NX)*VOLPM(M,NU(NY,NX),NY,NX)
      DFGSPM=DFGSS*VOLPM(M,NU(NY,NX),NY,NX)
C
C     EQUILIBRIUM CONCENTRATIONS AT RESIDUE SURFACE AT WHICH
C     AQUEOUS DIFFUSION THROUGH RESIDUE SURFACE LAYER = GASEOUS
C     DIFFUSION THROUGH ATMOSPHERE BOUNDARY LAYER CALCULATED
C     FROM AQUEOUS DIFFUSIVITY AND BOUNDARY LAYER CONDUCTANCE
C
      CO2GQ=(PARGPM*CCO2E(NY,NX)*VOLCOT(NY,NX)+DFGSPM
     2*CO2S2(NU(NY,NX),NY,NX))/(DFGSS*VOLWCO(NU(NY,NX),NY,NX)
     3+PARG(NY,NX)*VOLCOT(NY,NX))
      CH4GQ=(PARGPM*CCH4E(NY,NX)*VOLCHT(NY,NX)+DFGSPM
     2*CH4S2(NU(NY,NX),NY,NX))/(DFGSS*VOLWCH(NU(NY,NX),NY,NX)
     3+PARG(NY,NX)*VOLCHT(NY,NX))
      OXYGQ=(PARGPM*COXYE(NY,NX)*VOLOXT(NY,NX)+DFGSPM
     2*OXYS2(NU(NY,NX),NY,NX))/(DFGSS*VOLWOX(NU(NY,NX),NY,NX)
     3+PARG(NY,NX)*VOLOXT(NY,NX))
      Z2GGQ=(PARGPM*CZ2GE(NY,NX)*VOLNGT(NY,NX)+DFGSPM
     2*Z2GS2(NU(NY,NX),NY,NX))/(DFGSS*VOLWNG(NU(NY,NX),NY,NX)
     3+PARG(NY,NX)*VOLNGT(NY,NX))
      Z2OGQ=(PARGPM*CZ2OE(NY,NX)*VOLN2T(NY,NX)+DFGSPM
     2*Z2OS2(NU(NY,NX),NY,NX))/(DFGSS*VOLWN2(NU(NY,NX),NY,NX)
     3+PARG(NY,NX)*VOLN2T(NY,NX))
      IF(VOLN3T(NY,NX).GT.ZEROS(NY,NX))THEN
      ZN3GQ=(PARGPM*CNH3E(NY,NX)*VOLN3T(NY,NX)+DFGSPM
     2*ZN3S2(NU(NY,NX),NY,NX))/(DFGSS*VOLWN3(NU(NY,NX),NY,NX)
     3+PARG(NY,NX)*VOLN3T(NY,NX))
      ELSE
      ZN3GQ=0.0
      ENDIF
      IF(VOLNBT(NY,NX).GT.ZEROS(NY,NX))THEN
      ZNBGQ=(PARGPM*CNH3E(NY,NX)*VOLNBT(NY,NX)+DFGSPM
     2*ZNBS2(NU(NY,NX),NY,NX))/(DFGSS*VOLWNB(NU(NY,NX),NY,NX)
     3+PARG(NY,NX)*VOLNBT(NY,NX))
      ELSE
      ZNBGQ=0.0
      ENDIF
      H2GGQ=(PARGPM*CH2GE(NY,NX)*VOLHGT(NY,NX)+DFGSPM
     2*H2GS2(NU(NY,NX),NY,NX))/(DFGSS*VOLWHG(NU(NY,NX),NY,NX)
     3+PARG(NY,NX)*VOLHGT(NY,NX))
C
C     SURFACE VOLATILIZATION-DISSOLUTION FROM DIFFERENCES
C     BETWEEN ATMOSPHERIC AND SOIL SURFACE EQUILIBRIUM
C     CONCENTRATIONS
C
      RCODFS(NY,NX)=DFGSS*(CO2GQ*VOLWCO(NU(NY,NX),NY,NX)
     3-CO2S2(NU(NY,NX),NY,NX)*VOLPM(M,NU(NY,NX),NY,NX))/VOLCOT(NY,NX)
      RCHDFS(NY,NX)=DFGSS*(CH4GQ*VOLWCH(NU(NY,NX),NY,NX)
     3-CH4S2(NU(NY,NX),NY,NX)*VOLPM(M,NU(NY,NX),NY,NX))/VOLCHT(NY,NX)
      ROXDFS(NY,NX)=DFGSS*(OXYGQ*VOLWOX(NU(NY,NX),NY,NX)
     3-OXYS2(NU(NY,NX),NY,NX)*VOLPM(M,NU(NY,NX),NY,NX))/VOLOXT(NY,NX)
      RNGDFS(NY,NX)=DFGSS*(Z2GGQ*VOLWNG(NU(NY,NX),NY,NX)
     3-Z2GS2(NU(NY,NX),NY,NX)*VOLPM(M,NU(NY,NX),NY,NX))/VOLNGT(NY,NX)
      RN2DFS(NY,NX)=DFGSS*(Z2OGQ*VOLWN2(NU(NY,NX),NY,NX)
     3-Z2OS2(NU(NY,NX),NY,NX)*VOLPM(M,NU(NY,NX),NY,NX))/VOLN2T(NY,NX)
      IF(VOLN3T(NY,NX).GT.ZEROS(NY,NX))THEN
      RN3DFS(NY,NX)=DFGSS*(ZN3GQ*VOLWN3(NU(NY,NX),NY,NX)
     3-ZN3S2(NU(NY,NX),NY,NX)*VOLPM(M,NU(NY,NX),NY,NX))/VOLN3T(NY,NX)
     4*VLNH4(NU(NY,NX),NY,NX)
      ELSE
      RN3DFS(NY,NX)=0.0
      ENDIF
      IF(VOLNBT(NY,NX).GT.ZEROS(NY,NX))THEN
      RNBDFS(NY,NX)=DFGSS*(ZNBGQ*VOLWNB(NU(NY,NX),NY,NX)
     3-ZNBS2(NU(NY,NX),NY,NX)*VOLPM(M,NU(NY,NX),NY,NX))/VOLNBT(NY,NX)
     4*VLNHB(NU(NY,NX),NY,NX)
C     WRITE(*,1118)'RNBDFS',I,J,NX,NY,M,MM,RNBDFS(NY,NX)
C    2,DFGSS,ZNBGQ,VOLWNB(NU(NY,NX),NY,NX),ZNBS2(NU(NY,NX),NY,NX)
C    3,VOLPM(M,NU(NY,NX),NY,NX),VOLNBT(NY,NX)
      ELSE
      RNBDFS(NY,NX)=0.0
      ENDIF
      RHGDFS(NY,NX)=DFGSS*(H2GGQ*VOLWHG(NU(NY,NX),NY,NX)
     3-H2GS2(NU(NY,NX),NY,NX)*VOLPM(M,NU(NY,NX),NY,NX))/VOLHGT(NY,NX)
C
C     ACCUMULATE HOURLY FLUXES
C
      XCODFS(NY,NX)=XCODFS(NY,NX)+RCODFS(NY,NX)
      XCHDFS(NY,NX)=XCHDFS(NY,NX)+RCHDFS(NY,NX)
      XOXDFS(NY,NX)=XOXDFS(NY,NX)+ROXDFS(NY,NX)
      XNGDFS(NY,NX)=XNGDFS(NY,NX)+RNGDFS(NY,NX)
      XN2DFS(NY,NX)=XN2DFS(NY,NX)+RN2DFS(NY,NX)
      XN3DFS(NY,NX)=XN3DFS(NY,NX)+RN3DFS(NY,NX)
      XNBDFS(NY,NX)=XNBDFS(NY,NX)+RNBDFS(NY,NX)
      XHGDFS(NY,NX)=XHGDFS(NY,NX)+RHGDFS(NY,NX)
      ELSE
      RCODFS(NY,NX)=0.0
      RCHDFS(NY,NX)=0.0
      ROXDFS(NY,NX)=0.0
      RNGDFS(NY,NX)=0.0
      RN2DFS(NY,NX)=0.0
      RN3DFS(NY,NX)=0.0
      RNBDFS(NY,NX)=0.0
      RHGDFS(NY,NX)=0.0
      ENDIF
C     IF((I/30)*30.EQ.I.AND.J.EQ.12)THEN
C     WRITE(*,3232)'ROXDFS',I,J,NX,NY,M,MM,ROXDFS(NY,NX),OXYGQ
C    2,COXYE(NY,NX),PARG(NY,NX),VOLPM(M,NU(NY,NX),NY,NX)
C    2,VOLWOX(NU(NY,NX),NY,NX),VOLPM(M,NU(NY,NX),NY,NX)
C    3,DFGS(M,NU(NY,NX),NY,NX),OXYS2(NU(NY,NX),NY,NX)
C    4,VOLPM(M,NU(NY,NX),NY,NX),OXYGQ/VOLPM(M,NU(NY,NX),NY,NX)
431   FORMAT(A8,7I4,20E24.16)
C     ENDIF
C
C     CONVECTIVE SOLUTE EXCHANGE BETWEEN RESIDUE AND SOIL SURFACE
C
      FLWRM1=FLWRM(M,NY,NX) 
C
C     IF WATER FLUX FROM 'WATSUB' IS FROM RESIDUE TO
C     SOIL SURFACE THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MICROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN RESIDUE
C
      IF(FLWRM1.GT.0.0)THEN   
      IF(VOLWM(M,0,NY,NX).GT.ZEROS(NY,NX))THEN
      VFLW=AMAX1(0.0,AMIN1(FVFLW,FLWRM1/VOLWM(M,0,NY,NX)))
      ELSE
      VFLW=0.0
      ENDIF
      DO 8820 K=0,2
      RFLOC(K)=VFLW*AMAX1(0.0,OQC2(K,0,NY,NX))
      RFLON(K)=VFLW*AMAX1(0.0,OQN2(K,0,NY,NX))
      RFLOP(K)=VFLW*AMAX1(0.0,OQP2(K,0,NY,NX))
      RFLOA(K)=VFLW*AMAX1(0.0,OQA2(K,0,NY,NX))
8820  CONTINUE
      RFLCOS=VFLW*AMAX1(0.0,CO2S2(0,NY,NX))
      RFLCHS=VFLW*AMAX1(0.0,CH4S2(0,NY,NX))
      RFLOXS=VFLW*AMAX1(0.0,OXYS2(0,NY,NX))
      RFLNGS=VFLW*AMAX1(0.0,Z2GS2(0,NY,NX))
      RFLN2S=VFLW*AMAX1(0.0,Z2OS2(0,NY,NX))
      RFLHGS=VFLW*AMAX1(0.0,H2GS2(0,NY,NX))
      RFLNH4=VFLW*AMAX1(0.0,ZNH4S2(0,NY,NX))*VLNH4(NU(NY,NX),NY,NX)
      RFLNH3=VFLW*AMAX1(0.0,ZN3S2(0,NY,NX))*VLNH4(NU(NY,NX),NY,NX)
      RFLNO3=VFLW*AMAX1(0.0,ZNO3S2(0,NY,NX))*VLNO3(NU(NY,NX),NY,NX)
      RFLNO2=VFLW*AMAX1(0.0,ZNO2S2(0,NY,NX))*VLNO3(NU(NY,NX),NY,NX)
      RFLPO4=VFLW*AMAX1(0.0,H2PO42(0,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      RFLN4B=VFLW*AMAX1(0.0,ZNH4S2(0,NY,NX))*VLNHB(NU(NY,NX),NY,NX)
      RFLN3B=VFLW*AMAX1(0.0,ZN3S2(0,NY,NX))*VLNHB(NU(NY,NX),NY,NX)
      RFLNOB=VFLW*AMAX1(0.0,ZNO3S2(0,NY,NX))*VLNOB(NU(NY,NX),NY,NX)
      RFLN2B=VFLW*AMAX1(0.0,ZNO2S2(0,NY,NX))*VLNOB(NU(NY,NX),NY,NX)
      RFLPOB=VFLW*AMAX1(0.0,H2PO42(0,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
C
C     IF WATER FLUX FROM 'WATSUB' IS TO RESIDUE FROM
C     SOIL SURFACE THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MICROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN SOIL SURFACE
C
      ELSE
      IF(VOLWM(M,NU(NY,NX),NY,NX).GT.ZEROS(NY,NX))THEN
      VFLW=AMIN1(0.0,AMAX1(-FVFLW
     2,FLWRM1/VOLWM(M,NU(NY,NX),NY,NX)))
      ELSE
      VFLW=-1.0
      ENDIF
      DO 8815 K=0,2
      RFLOC(K)=VFLW*AMAX1(0.0,OQC2(K,NU(NY,NX),NY,NX))
      RFLON(K)=VFLW*AMAX1(0.0,OQN2(K,NU(NY,NX),NY,NX))
      RFLOP(K)=VFLW*AMAX1(0.0,OQP2(K,NU(NY,NX),NY,NX))
      RFLOA(K)=VFLW*AMAX1(0.0,OQA2(K,NU(NY,NX),NY,NX))
8815  CONTINUE
      RFLCOS=VFLW*AMAX1(0.0,CO2S2(NU(NY,NX),NY,NX))
      RFLCHS=VFLW*AMAX1(0.0,CH4S2(NU(NY,NX),NY,NX))
      RFLOXS=VFLW*AMAX1(0.0,OXYS2(NU(NY,NX),NY,NX))
      RFLNGS=VFLW*AMAX1(0.0,Z2GS2(NU(NY,NX),NY,NX))
      RFLN2S=VFLW*AMAX1(0.0,Z2OS2(NU(NY,NX),NY,NX))
      RFLHGS=VFLW*AMAX1(0.0,H2GS2(NU(NY,NX),NY,NX))
      RFLNH4=VFLW*AMAX1(0.0,ZNH4S2(NU(NY,NX),NY,NX))
      RFLNH3=VFLW*AMAX1(0.0,ZN3S2(NU(NY,NX),NY,NX))
      RFLNO3=VFLW*AMAX1(0.0,ZNO3S2(NU(NY,NX),NY,NX))
      RFLNO2=VFLW*AMAX1(0.0,ZNO2S2(NU(NY,NX),NY,NX))
      RFLPO4=VFLW*AMAX1(0.0,H2PO42(NU(NY,NX),NY,NX))
      RFLN4B=VFLW*AMAX1(0.0,ZNH4B2(NU(NY,NX),NY,NX))
      RFLN3B=VFLW*AMAX1(0.0,ZNBS2(NU(NY,NX),NY,NX))
      RFLNOB=VFLW*AMAX1(0.0,ZNO3B2(NU(NY,NX),NY,NX))
      RFLN2B=VFLW*AMAX1(0.0,ZNO2B2(NU(NY,NX),NY,NX))
      RFLPOB=VFLW*AMAX1(0.0,H2POB2(NU(NY,NX),NY,NX))
      ENDIF
C
C     DIFFUSIVE FLUXES OF GASES AND SOLUTES BETWEEN RESIDUE AND
C     SOIL SURFACE FROM AQUEOUS DIFFUSIVITIES
C     AND CONCENTRATION DIFFERENCES
C
      IF(THETW1(0,NY,NX).GT.THETY(0,NY,NX)
     2.AND.THETW1(NU(NY,NX),NY,NX).GT.THETY(NU(NY,NX),NY,NX))THEN
C
C     MICROPORE CONCENTRATIONS FROM WATER IN RESIDUE AND SOIL SURFACE
C
      DO 8810 K=0,2
      COQC1(K)=AMAX1(0.0,OQC2(K,0,NY,NX)/VOLWM(M,0,NY,NX))
      COQN1(K)=AMAX1(0.0,OQN2(K,0,NY,NX)/VOLWM(M,0,NY,NX))
      COQP1(K)=AMAX1(0.0,OQP2(K,0,NY,NX)/VOLWM(M,0,NY,NX))
      COQA1(K)=AMAX1(0.0,OQA2(K,0,NY,NX)/VOLWM(M,0,NY,NX))
      COQC2(K)=AMAX1(0.0,OQC2(K,NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
      COQN2(K)=AMAX1(0.0,OQN2(K,NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
      COQP2(K)=AMAX1(0.0,OQP2(K,NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
      COQA2(K)=AMAX1(0.0,OQA2(K,NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
8810  CONTINUE
      CCO2S1=AMAX1(0.0,CO2S2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CCH4S1=AMAX1(0.0,CH4S2(0,NY,NX)/VOLWM(M,0,NY,NX))
      COXYS1=AMAX1(0.0,OXYS2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CZ2GS1=AMAX1(0.0,Z2GS2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CZ2OS1=AMAX1(0.0,Z2OS2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CH2GS1=AMAX1(0.0,H2GS2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CNH4S1=AMAX1(0.0,ZNH4S2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CNH3S1=AMAX1(0.0,ZN3S2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CNO3S1=AMAX1(0.0,ZNO3S2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CNO2S1=AMAX1(0.0,ZNO2S2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CPO4S1=AMAX1(0.0,H2PO42(0,NY,NX)/VOLWM(M,0,NY,NX))
      CCO2S2=AMAX1(0.0,CO2S2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CCH4S2=AMAX1(0.0,CH4S2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      COXYS2=AMAX1(0.0,OXYS2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CZ2GS2=AMAX1(0.0,Z2GS2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CZ2OS2=AMAX1(0.0,Z2OS2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CH2GS2=AMAX1(0.0,H2GS2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      IF(VOLWMA(NU(NY,NX),NY,NX).GT.ZEROS(NY,NX))THEN
      CNH3S2=AMAX1(0.0,ZN3S2(NU(NY,NX),NY,NX)/VOLWMA(NU(NY,NX),NY,NX))
      CNH4S2=AMAX1(0.0,ZNH4S2(NU(NY,NX),NY,NX)/VOLWMA(NU(NY,NX),NY,NX))
      ELSE
      CNH3S2=0.0
      CNH4S2=0.0
      ENDIF
      IF(VOLWOA.GT.ZEROS(NY,NX))THEN
      CNO3S2=AMAX1(0.0,ZNO3S2(NU(NY,NX),NY,NX)/VOLWOA)
      CNO2S2=AMAX1(0.0,ZNO2S2(NU(NY,NX),NY,NX)/VOLWOA)
      ELSE
      CNO3S2=0.0
      CNO2S2=0.0
      ENDIF
      IF(VOLWPA.GT.ZEROS(NY,NX))THEN
      CPO4S2=AMAX1(0.0,H2PO42(NU(NY,NX),NY,NX)/VOLWPA)
      ELSE
      CPO4S2=0.0
      ENDIF
      IF(VOLWMB(NU(NY,NX),NY,NX).GT.ZEROS(NY,NX))THEN
      CNH3B2=AMAX1(0.0,ZNBS2(NU(NY,NX),NY,NX)/VOLWMB(NU(NY,NX),NY,NX))
      CNH4B2=AMAX1(0.0,ZNH4B2(NU(NY,NX),NY,NX)/VOLWMB(NU(NY,NX),NY,NX))
      ELSE
      CNH3B2=CNH3S2
      CNH4B2=CNH4S2
      ENDIF
      IF(VOLWOB.GT.ZEROS(NY,NX))THEN
      CNO3B2=AMAX1(0.0,ZNO3B2(NU(NY,NX),NY,NX)/VOLWOB)
      CNO2B2=AMAX1(0.0,ZNO2B2(NU(NY,NX),NY,NX)/VOLWOB)
      ELSE
      CNO3B2=CNO3S2
      CNO2B2=CNO2S2
      ENDIF
      IF(VOLWPB.GT.ZEROS(NY,NX))THEN
      CPO4B2=AMAX1(0.0,H2POB2(NU(NY,NX),NY,NX)/VOLWPB)
      ELSE
      CPO4B2=CPO4S2
      ENDIF
C
C     DIFFUSIVITIES IN RESIDUE AND SOIL SURFACE
C
      TORT0=TORT(0,NY,NX)*AREA(3,NU(NY,NX),NY,NX)
     2/DLYR(3,0,NY,NX)
      TORT1=TORT(NU(NY,NX),NY,NX)*AREA(3,NU(NY,NX),NY,NX)
     2/DLYR(3,NU(NY,NX),NY,NX)
      DISPN=DISP(3,NU(NY,NX),NY,NX)*ABS(FLWRM1/AREA(3,NU(NY,NX),NY,NX))
      DIFOC0=(OCSGL2(0,NY,NX)*TORT0+DISPN)
      DIFON0=(ONSGL2(0,NY,NX)*TORT0+DISPN)
      DIFOP0=(OPSGL2(0,NY,NX)*TORT0+DISPN)
      DIFOA0=(OASGL2(0,NY,NX)*TORT0+DISPN)
      DIFNH0=(ZNSGL2(0,NY,NX)*TORT0+DISPN)
      DIFNO0=(ZOSGL2(0,NY,NX)*TORT0+DISPN)
      DIFPO0=(POSGL2(0,NY,NX)*TORT0+DISPN)
      DIFCS0=(CLSGL2(0,NY,NX)*TORT0+DISPN)
      DIFCQ0=(CQSGL2(0,NY,NX)*TORT0+DISPN)
      DIFOS0=(OLSGL2(0,NY,NX)*TORT0+DISPN)
      DIFNG0=(ZLSGL2(0,NY,NX)*TORT0+DISPN)
      DIFN20=(ZVSGL2(0,NY,NX)*TORT0+DISPN)
      DIFHG0=(HLSGL2(0,NY,NX)*TORT0+DISPN)
      DIFOC1=(OCSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFON1=(ONSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFOP1=(OPSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFOA1=(OASGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFNH1=(ZNSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFNO1=(ZOSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFPO1=(POSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFCS1=(CLSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFCQ1=(CQSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFOS1=(OLSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFNG1=(ZLSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFN21=(ZVSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFHG1=(HLSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFOC=DIFOC0*DIFOC1/(DIFOC0+DIFOC1)
      DIFON=DIFON0*DIFON1/(DIFON0+DIFON1)
      DIFOP=DIFOP0*DIFOP1/(DIFOP0+DIFOP1)
      DIFOA=DIFOA0*DIFOA1/(DIFOA0+DIFOA1)
      DIFNH=DIFNH0*DIFNH1/(DIFNH0+DIFNH1)
      DIFNO=DIFNO0*DIFNO1/(DIFNO0+DIFNO1)
      DIFPO=DIFPO0*DIFPO1/(DIFPO0+DIFPO1)
      DIFCS=DIFCS0*DIFCS1/(DIFCS0+DIFCS1)
      DIFCQ=DIFCQ0*DIFCQ1/(DIFCQ0+DIFCQ1)
      DIFOS=DIFOS0*DIFOS1/(DIFOS0+DIFOS1)
      DIFNG=DIFNG0*DIFNG1/(DIFNG0+DIFNG1)
      DIFN2=DIFN20*DIFN21/(DIFN20+DIFN21)
      DIFHG=DIFHG0*DIFHG1/(DIFHG0+DIFHG1)
C
C     DIFFUSIVE FLUXES BETWEEN CURRENT AND ADJACENT GRID CELL
C     MICROPORES
C
      DO 8805 K=0,2
      DFVOC(K)=DIFOC*(COQC1(K)-COQC2(K))
      DFVON(K)=DIFON*(COQN1(K)-COQN2(K))
      DFVOP(K)=DIFOP*(COQP1(K)-COQP2(K))
      DFVOA(K)=DIFOA*(COQA1(K)-COQA2(K))
8805  CONTINUE
      DFVCOS=DIFCS*(CCO2S1-CCO2S2)
      DFVCHS=DIFCQ*(CCH4S1-CCH4S2)
      DFVOXS=DIFOS*(COXYS1-COXYS2)
      DFVNGS=DIFNG*(CZ2GS1-CZ2GS2)
      DFVN2S=DIFN2*(CZ2OS1-CZ2OS2)
      DFVHGS=DIFHG*(CH2GS1-CH2GS2)
      DFVNH4=DIFNH*(CNH4S1-CNH4S2)*VLNH4(NU(NY,NX),NY,NX)
      DFVNH3=DIFNH*(CNH3S1-CNH3S2)*VLNH4(NU(NY,NX),NY,NX)
      DFVNO3=DIFNO*(CNO3S1-CNO3S2)*VLNO3(NU(NY,NX),NY,NX)
      DFVNO2=DIFNO*(CNO2S1-CNO2S2)*VLNO3(NU(NY,NX),NY,NX)
      DFVPO4=DIFPO*(CPO4S1-CPO4S2)*VLPO4(NU(NY,NX),NY,NX)
      DFVN4B=DIFNH*(CNH4S1-CNH4B2)*VLNHB(NU(NY,NX),NY,NX)
      DFVN3B=DIFNH*(CNH3S1-CNH3B2)*VLNHB(NU(NY,NX),NY,NX)
      DFVNOB=DIFNO*(CNO3S1-CNO3B2)*VLNOB(NU(NY,NX),NY,NX)
      DFVN2B=DIFNO*(CNO2S1-CNO2B2)*VLNOB(NU(NY,NX),NY,NX)
      DFVPOB=DIFPO*(CPO4S1-CPO4B2)*VLPOB(NU(NY,NX),NY,NX)
      ELSE
      DO 8905 K=0,2
      DFVOC(K)=0.0
      DFVON(K)=0.0
      DFVOP(K)=0.0
      DFVOA(K)=0.0
8905  CONTINUE
      DFVCOS=0.0
      DFVCHS=0.0
      DFVOXS=0.0
      DFVNGS=0.0
      DFVN2S=0.0
      DFVHGS=0.0
      DFVNH4=0.0
      DFVNH3=0.0
      DFVNO3=0.0
      DFVNO2=0.0
      DFVPO4=0.0
      DFVN4B=0.0
      DFVN3B=0.0
      DFVNOB=0.0
      DFVN2B=0.0
      DFVPOB=0.0
      ENDIF
C
C     TOTAL MICROPORE AND MACROPORE SOLUTE TRANSPORT FLUXES BETWEEN
C     ADJACENT GRID CELLS = CONVECTIVE + DIFFUSIVE FLUXES
C
      DO 9760 K=0,2
      ROCFLS(K,3,0,NY,NX)=ROCFL0(K,NY,NX)-RFLOC(K)-DFVOC(K)
      RONFLS(K,3,0,NY,NX)=RONFL0(K,NY,NX)-RFLON(K)-DFVON(K)
      ROPFLS(K,3,0,NY,NX)=ROPFL0(K,NY,NX)-RFLOP(K)-DFVOP(K)
      ROAFLS(K,3,0,NY,NX)=ROAFL0(K,NY,NX)-RFLOA(K)-DFVOA(K)
      ROCFLS(K,3,NU(NY,NX),NY,NX)=ROCFL1(K,NY,NX)+RFLOC(K)+DFVOC(K)
      RONFLS(K,3,NU(NY,NX),NY,NX)=RONFL1(K,NY,NX)+RFLON(K)+DFVON(K)
      ROPFLS(K,3,NU(NY,NX),NY,NX)=ROPFL1(K,NY,NX)+RFLOP(K)+DFVOP(K)
      ROAFLS(K,3,NU(NY,NX),NY,NX)=ROAFL1(K,NY,NX)+RFLOA(K)+DFVOA(K)
      XOCFLS(K,3,0,NY,NX)=XOCFLS(K,3,0,NY,NX)
     2-RFLOC(K)-DFVOC(K)
      XONFLS(K,3,0,NY,NX)=XONFLS(K,3,0,NY,NX)
     2-RFLON(K)-DFVON(K)
      XOPFLS(K,3,0,NY,NX)=XOPFLS(K,3,0,NY,NX)
     2-RFLOP(K)-DFVOP(K)
      XOAFLS(K,3,0,NY,NX)=XOAFLS(K,3,0,NY,NX)
     2-RFLOA(K)-DFVOA(K)
      XOCFLS(K,3,NU(NY,NX),NY,NX)=XOCFLS(K,3,NU(NY,NX),NY,NX)
     2+RFLOC(K)+DFVOC(K)
      XONFLS(K,3,NU(NY,NX),NY,NX)=XONFLS(K,3,NU(NY,NX),NY,NX)
     2+RFLON(K)+DFVON(K)
      XOPFLS(K,3,NU(NY,NX),NY,NX)=XOPFLS(K,3,NU(NY,NX),NY,NX)
     2+RFLOP(K)+DFVOP(K)
      XOAFLS(K,3,NU(NY,NX),NY,NX)=XOAFLS(K,3,NU(NY,NX),NY,NX)
     2+RFLOA(K)+DFVOA(K)
9760  CONTINUE
      RCOFLS(3,0,NY,NX)=RCOFL0(NY,NX)-RFLCOS-DFVCOS
      RCHFLS(3,0,NY,NX)=RCHFL0(NY,NX)-RFLCHS-DFVCHS
      ROXFLS(3,0,NY,NX)=ROXFL0(NY,NX)-RFLOXS-DFVOXS
      RNGFLS(3,0,NY,NX)=RNGFL0(NY,NX)-RFLNGS-DFVNGS
      RN2FLS(3,0,NY,NX)=RN2FL0(NY,NX)-RFLN2S-DFVN2S
      RHGFLS(3,0,NY,NX)=RHGFL0(NY,NX)-RFLHGS-DFVHGS
      RN4FLW(3,0,NY,NX)=RN4FL0(NY,NX)-RFLNH4-DFVNH4-RFLN4B-DFVN4B
      RN3FLW(3,0,NY,NX)=RN3FL0(NY,NX)-RFLNH3-DFVNH3-RFLN3B-DFVN3B
      RNOFLW(3,0,NY,NX)=RNOFL0(NY,NX)-RFLNO3-DFVNO3-RFLNOB-DFVNOB
      RNXFLS(3,0,NY,NX)=RNXFL0(NY,NX)-RFLNO2-DFVNO2-RFLN2B-DFVN2B
      RH2PFS(3,0,NY,NX)=RH2PF0(NY,NX)-RFLPO4-DFVPO4-RFLPOB-DFVPOB
      RCOFLS(3,NU(NY,NX),NY,NX)=RCOFL1(NY,NX)+RFLCOS+DFVCOS
      RCHFLS(3,NU(NY,NX),NY,NX)=RCHFL1(NY,NX)+RFLCHS+DFVCHS
      ROXFLS(3,NU(NY,NX),NY,NX)=ROXFL1(NY,NX)+RFLOXS+DFVOXS
      RNGFLS(3,NU(NY,NX),NY,NX)=RNGFL1(NY,NX)+RFLNGS+DFVNGS
      RN2FLS(3,NU(NY,NX),NY,NX)=RN2FL1(NY,NX)+RFLN2S+DFVN2S
      RHGFLS(3,NU(NY,NX),NY,NX)=RHGFL1(NY,NX)+RFLHGS+DFVHGS
      RN4FLW(3,NU(NY,NX),NY,NX)=RN4FL1(NY,NX)+RFLNH4+DFVNH4
      RN3FLW(3,NU(NY,NX),NY,NX)=RN3FL1(NY,NX)+RFLNH3+DFVNH3
      RNOFLW(3,NU(NY,NX),NY,NX)=RNOFL1(NY,NX)+RFLNO3+DFVNO3
      RNXFLS(3,NU(NY,NX),NY,NX)=RNXFL1(NY,NX)+RFLNO2+DFVNO2
      RH2PFS(3,NU(NY,NX),NY,NX)=RH2PF1(NY,NX)+RFLPO4+DFVPO4
      RN4FLB(3,NU(NY,NX),NY,NX)=RN4FL2(NY,NX)+RFLN4B+DFVN4B
      RN3FLB(3,NU(NY,NX),NY,NX)=RN3FL2(NY,NX)+RFLN3B+DFVN3B
      RNOFLB(3,NU(NY,NX),NY,NX)=RNOFL2(NY,NX)+RFLNOB+DFVNOB
      RNXFLB(3,NU(NY,NX),NY,NX)=RNXFL2(NY,NX)+RFLN2B+DFVN2B
      RH2BFB(3,NU(NY,NX),NY,NX)=RH2BF2(NY,NX)+RFLPOB+DFVPOB
      XCOFLS(3,0,NY,NX)=XCOFLS(3,0,NY,NX)-RFLCOS-DFVCOS
      XCHFLS(3,0,NY,NX)=XCHFLS(3,0,NY,NX)-RFLCHS-DFVCHS
      XOXFLS(3,0,NY,NX)=XOXFLS(3,0,NY,NX)-RFLOXS-DFVOXS
      XNGFLS(3,0,NY,NX)=XNGFLS(3,0,NY,NX)-RFLNGS-DFVNGS
      XN2FLS(3,0,NY,NX)=XN2FLS(3,0,NY,NX)-RFLN2S-DFVN2S
      XHGFLS(3,0,NY,NX)=XHGFLS(3,0,NY,NX)-RFLHGS-DFVHGS
      XN4FLW(3,0,NY,NX)=XN4FLW(3,0,NY,NX)-RFLNH4-DFVNH4-RFLN4B-DFVN4B
      XN3FLW(3,0,NY,NX)=XN3FLW(3,0,NY,NX)-RFLNH3-DFVNH3-RFLN3B-DFVN3B
      XNOFLW(3,0,NY,NX)=XNOFLW(3,0,NY,NX)-RFLNO3-DFVNO3-RFLNOB-DFVNOB
      XNXFLS(3,0,NY,NX)=XNXFLS(3,0,NY,NX)-RFLNO2-DFVNO2-RFLN2B-DFVN2B
      XH2PFS(3,0,NY,NX)=XH2PFS(3,0,NY,NX)-RFLPO4-DFVPO4-RFLPOB-DFVPOB
      XCOFLS(3,NU(NY,NX),NY,NX)=XCOFLS(3,NU(NY,NX),NY,NX)+RFLCOS+DFVCOS
      XCHFLS(3,NU(NY,NX),NY,NX)=XCHFLS(3,NU(NY,NX),NY,NX)+RFLCHS+DFVCHS
      XOXFLS(3,NU(NY,NX),NY,NX)=XOXFLS(3,NU(NY,NX),NY,NX)+RFLOXS+DFVOXS
      XNGFLS(3,NU(NY,NX),NY,NX)=XNGFLS(3,NU(NY,NX),NY,NX)+RFLNGS+DFVNGS
      XN2FLS(3,NU(NY,NX),NY,NX)=XN2FLS(3,NU(NY,NX),NY,NX)+RFLN2S+DFVN2S
      XHGFLS(3,NU(NY,NX),NY,NX)=XHGFLS(3,NU(NY,NX),NY,NX)+RFLHGS+DFVHGS
      XN4FLW(3,NU(NY,NX),NY,NX)=XN4FLW(3,NU(NY,NX),NY,NX)+RFLNH4+DFVNH4
      XN3FLW(3,NU(NY,NX),NY,NX)=XN3FLW(3,NU(NY,NX),NY,NX)+RFLNH3+DFVNH3
      XNOFLW(3,NU(NY,NX),NY,NX)=XNOFLW(3,NU(NY,NX),NY,NX)+RFLNO3+DFVNO3
      XNXFLS(3,NU(NY,NX),NY,NX)=XNXFLS(3,NU(NY,NX),NY,NX)+RFLNO2+DFVNO2
      XH2PFS(3,NU(NY,NX),NY,NX)=XH2PFS(3,NU(NY,NX),NY,NX)+RFLPO4+DFVPO4
      XN4FLB(3,NU(NY,NX),NY,NX)=XN4FLB(3,NU(NY,NX),NY,NX)+RFLN4B+DFVN4B
      XN3FLB(3,NU(NY,NX),NY,NX)=XN3FLB(3,NU(NY,NX),NY,NX)+RFLN3B+DFVN3B
      XNOFLB(3,NU(NY,NX),NY,NX)=XNOFLB(3,NU(NY,NX),NY,NX)+RFLNOB+DFVNOB
      XNXFLB(3,NU(NY,NX),NY,NX)=XNXFLB(3,NU(NY,NX),NY,NX)+RFLN2B+DFVN2B
      XH2BFB(3,NU(NY,NX),NY,NX)=XH2BFB(3,NU(NY,NX),NY,NX)+RFLPOB+DFVPOB
C     IF(I.EQ.118.AND.NX.EQ.3.AND.NY.EQ.4)THEN
C     WRITE(*,3434)'ROXFLS',I,J,NX,NY,M,MM,ROXFLS(3,0,NY,NX)
C    2,XOXFLS(3,0,NY,NX),ROXFL0(NY,NX),RFLOXS,DFVOXS
3434  FORMAT(A8,6I4,12E12.4)
C     ENDIF
C
C     MACROPORE-MICROPORE SOLUTE EXCHANGE IN SOIL
C     SURFACE LAYER FROM WATER EXCHANGE IN 'WATSUB' AND
C     FROM MACROPORE OR MICROPORE SOLUTE CONCENTRATIONS
C
      IF(FINHM(M,NU(NY,NX),NY,NX).GT.0.0)THEN
C
C     MACROPORE TO MICROPORE TRANSFER
C
      IF(VOLWHM(M,NU(NY,NX),NY,NX).GT.ZEROS(NY,NX))THEN
      VFLW=AMAX1(0.0,AMIN1(FVFLW,FINHM(M,NU(NY,NX),NY,NX)
     2/VOLWHM(M,NU(NY,NX),NY,NX)))
      ELSE
      VFLW=0.0
      ENDIF
      DO 9870 K=0,4
      ROCFXS(K,NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,OQCH2(K,NU(NY,NX),NY,NX))
      RONFXS(K,NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,OQNH2(K,NU(NY,NX),NY,NX))
      ROPFXS(K,NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,OQPH2(K,NU(NY,NX),NY,NX))
      ROAFXS(K,NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,OQAH2(K,NU(NY,NX),NY,NX))
9870  CONTINUE
      RCOFXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,CO2SH2(NU(NY,NX),NY,NX))
      RCHFXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,CH4SH2(NU(NY,NX),NY,NX))
      ROXFXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,OXYSH2(NU(NY,NX),NY,NX))
      RNGFXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,Z2GSH2(NU(NY,NX),NY,NX))
      RN2FXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,Z2OSH2(NU(NY,NX),NY,NX))
      RHGFXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,H2GSH2(NU(NY,NX),NY,NX))
      RN4FXW(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZNH4H2(NU(NY,NX),NY,NX))
     2*VLNH4(NU(NY,NX),NY,NX)
      RN3FXW(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZNH3H2(NU(NY,NX),NY,NX))
     2*VLNH4(NU(NY,NX),NY,NX)
      RNOFXW(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZNO3H2(NU(NY,NX),NY,NX))
     2*VLNO3(NU(NY,NX),NY,NX)
      RNXFXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZNO2H2(NU(NY,NX),NY,NX))
     2*VLNO3(NU(NY,NX),NY,NX)
      RH2PXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,H2P4H2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RN4FXB(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZN4BH2(NU(NY,NX),NY,NX))
     2*VLNHB(NU(NY,NX),NY,NX)
      RN3FXB(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZN3BH2(NU(NY,NX),NY,NX))
     2*VLNHB(NU(NY,NX),NY,NX)
      RNOFXB(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZNOBH2(NU(NY,NX),NY,NX))
     2*VLNOB(NU(NY,NX),NY,NX)
      RNXFXB(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZN2BH2(NU(NY,NX),NY,NX))
     2*VLNOB(NU(NY,NX),NY,NX)
      RH2BXB(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,H2PBH2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
C
C     MICROPORE TO MACROPORE TRANSFER
C
      ELSEIF(FINHM(M,NU(NY,NX),NY,NX).LT.0.0)THEN
      IF(VOLWM(M,NU(NY,NX),NY,NX).GT.ZEROS(NY,NX))THEN
      VFLW=AMIN1(0.0,AMAX1(-FVFLW,FINHM(M,NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX)))
      ELSE
      VFLW=-1.0
      ENDIF
      DO 9865 K=0,4
      ROCFXS(K,NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,OQC2(K,NU(NY,NX),NY,NX))
      RONFXS(K,NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,OQN2(K,NU(NY,NX),NY,NX))
      ROPFXS(K,NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,OQP2(K,NU(NY,NX),NY,NX))
      ROAFXS(K,NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,OQA2(K,NU(NY,NX),NY,NX))
9865  CONTINUE
      RCOFXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,CO2S2(NU(NY,NX),NY,NX))
      RCHFXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,CH4S2(NU(NY,NX),NY,NX))
      ROXFXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,OXYS2(NU(NY,NX),NY,NX))
      RNGFXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,Z2GS2(NU(NY,NX),NY,NX))
      RN2FXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,Z2OS2(NU(NY,NX),NY,NX))
      RHGFXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,H2GS2(NU(NY,NX),NY,NX))
      RN4FXW(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZNH4S2(NU(NY,NX),NY,NX))
     2*VLNH4(NU(NY,NX),NY,NX)
      RN3FXW(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZN3S2(NU(NY,NX),NY,NX))
     2*VLNH4(NU(NY,NX),NY,NX)
      RNOFXW(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZNO3S2(NU(NY,NX),NY,NX))
     2*VLNO3(NU(NY,NX),NY,NX)
      RNXFXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZNO2S2(NU(NY,NX),NY,NX))
     2*VLNO3(NU(NY,NX),NY,NX)
      RH2PXS(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,H2PO42(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RN4FXB(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZNH4B2(NU(NY,NX),NY,NX))
     2*VLNHB(NU(NY,NX),NY,NX)
      RN3FXB(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZNBS2(NU(NY,NX),NY,NX))
     2*VLNHB(NU(NY,NX),NY,NX)
      RNOFXB(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZNO3B2(NU(NY,NX),NY,NX))
     2*VLNOB(NU(NY,NX),NY,NX)
      RNXFXB(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,ZNO2B2(NU(NY,NX),NY,NX))
     2*VLNOB(NU(NY,NX),NY,NX)
      RH2BXB(NU(NY,NX),NY,NX)=VFLW*AMAX1(0.0,H2POB2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
C
C     NO MACROPORE TO MICROPORE TRANSFER
C
      ELSE
      DO 9860 K=0,4
      ROCFXS(K,NU(NY,NX),NY,NX)=0.0
      RONFXS(K,NU(NY,NX),NY,NX)=0.0
      ROPFXS(K,NU(NY,NX),NY,NX)=0.0
      ROAFXS(K,NU(NY,NX),NY,NX)=0.0
9860  CONTINUE
      RCOFXS(NU(NY,NX),NY,NX)=0.0
      RCHFXS(NU(NY,NX),NY,NX)=0.0
      ROXFXS(NU(NY,NX),NY,NX)=0.0
      RNGFXS(NU(NY,NX),NY,NX)=0.0
      RN2FXS(NU(NY,NX),NY,NX)=0.0
      RHGFXS(NU(NY,NX),NY,NX)=0.0
      RN4FXW(NU(NY,NX),NY,NX)=0.0
      RN3FXW(NU(NY,NX),NY,NX)=0.0
      RNOFXW(NU(NY,NX),NY,NX)=0.0
      RNXFXS(NU(NY,NX),NY,NX)=0.0
      RH2PXS(NU(NY,NX),NY,NX)=0.0
      RN4FXB(NU(NY,NX),NY,NX)=0.0
      RN3FXB(NU(NY,NX),NY,NX)=0.0
      RNOFXB(NU(NY,NX),NY,NX)=0.0
      RNXFXB(NU(NY,NX),NY,NX)=0.0
      RH2BXB(NU(NY,NX),NY,NX)=0.0
      ENDIF
C
C     ACCUMULATE HOURLY FLUXES
C
      DO 9940 K=0,4
      XOCFXS(K,NU(NY,NX),NY,NX)=XOCFXS(K,NU(NY,NX),NY,NX)
     2+ROCFXS(K,NU(NY,NX),NY,NX)
      XONFXS(K,NU(NY,NX),NY,NX)=XONFXS(K,NU(NY,NX),NY,NX)
     2+RONFXS(K,NU(NY,NX),NY,NX)
      XOPFXS(K,NU(NY,NX),NY,NX)=XOPFXS(K,NU(NY,NX),NY,NX)
     2+ROPFXS(K,NU(NY,NX),NY,NX)
      XOAFXS(K,NU(NY,NX),NY,NX)=XOAFXS(K,NU(NY,NX),NY,NX)
     2+ROAFXS(K,NU(NY,NX),NY,NX)
9940  CONTINUE
      XCOFXS(NU(NY,NX),NY,NX)=XCOFXS(NU(NY,NX),NY,NX)
     2+RCOFXS(NU(NY,NX),NY,NX)
      XCHFXS(NU(NY,NX),NY,NX)=XCHFXS(NU(NY,NX),NY,NX)
     2+RCHFXS(NU(NY,NX),NY,NX)
      XOXFXS(NU(NY,NX),NY,NX)=XOXFXS(NU(NY,NX),NY,NX)
     2+ROXFXS(NU(NY,NX),NY,NX)
      XNGFXS(NU(NY,NX),NY,NX)=XNGFXS(NU(NY,NX),NY,NX)
     2+RNGFXS(NU(NY,NX),NY,NX)
      XN2FXS(NU(NY,NX),NY,NX)=XN2FXS(NU(NY,NX),NY,NX)
     2+RN2FXS(NU(NY,NX),NY,NX)
      XHGFXS(NU(NY,NX),NY,NX)=XHGFXS(NU(NY,NX),NY,NX)
     2+RHGFXS(NU(NY,NX),NY,NX)
      XN4FXW(NU(NY,NX),NY,NX)=XN4FXW(NU(NY,NX),NY,NX)
     2+RN4FXW(NU(NY,NX),NY,NX)
      XN3FXW(NU(NY,NX),NY,NX)=XN3FXW(NU(NY,NX),NY,NX)
     2+RN3FXW(NU(NY,NX),NY,NX)
      XNOFXW(NU(NY,NX),NY,NX)=XNOFXW(NU(NY,NX),NY,NX)
     2+RNOFXW(NU(NY,NX),NY,NX)
      XNXFXS(NU(NY,NX),NY,NX)=XNXFXS(NU(NY,NX),NY,NX)
     2+RNXFXS(NU(NY,NX),NY,NX)
      XH2PXS(NU(NY,NX),NY,NX)=XH2PXS(NU(NY,NX),NY,NX)
     2+RH2PXS(NU(NY,NX),NY,NX)
      XN4FXB(NU(NY,NX),NY,NX)=XN4FXB(NU(NY,NX),NY,NX)
     2+RN4FXB(NU(NY,NX),NY,NX)
      XN3FXB(NU(NY,NX),NY,NX)=XN3FXB(NU(NY,NX),NY,NX)
     2+RN3FXB(NU(NY,NX),NY,NX)
      XNOFXB(NU(NY,NX),NY,NX)=XNOFXB(NU(NY,NX),NY,NX)
     2+RNOFXB(NU(NY,NX),NY,NX)
      XNXFXB(NU(NY,NX),NY,NX)=XNXFXB(NU(NY,NX),NY,NX)
     2+RNXFXB(NU(NY,NX),NY,NX)
      XH2BXB(NU(NY,NX),NY,NX)=XH2BXB(NU(NY,NX),NY,NX)
     2+RH2BXB(NU(NY,NX),NY,NX)
C
C     SOLUTE TRANSPORT FROM WATER OVERLAND FLOW
C     IN 'WATSUB' AND FROM SOLUTE CONCENTRATIONS
C     IN SOIL SURFACE LAYER
C
      N1=NX
      N2=NY
C
C     LOCATE INTERNAL BOUNDARIES BETWEEN ADJACENT GRID CELLS
C
      DO 4310 N=1,2
      IF(N.EQ.1)THEN
      IF(NX.EQ.NHE)THEN
      GO TO 4310
      ELSE
      N4=NX+1
      N5=NY
      ENDIF
      ELSEIF(N.EQ.2)THEN
      IF(NY.EQ.NVS)THEN
      GO TO 4310
      ELSE
      N4=NX
      N5=NY+1
      ENDIF
      ENDIF
C
C     IF NO OVERLAND FLOW THEN NO TRANSPORT
C
      IF(QRM(M,N,N5,N4).EQ.0.0)THEN
      DO 9840 K=0,2
      RQROC(K,N,N5,N4)=0.0
      RQRON(K,N,N5,N4)=0.0
      RQROP(K,N,N5,N4)=0.0
      RQROA(K,N,N5,N4)=0.0
9840  CONTINUE
      RQRCOS(N,N5,N4)=0.0
      RQRCHS(N,N5,N4)=0.0
      RQROXS(N,N5,N4)=0.0
      RQRNGS(N,N5,N4)=0.0
      RQRN2S(N,N5,N4)=0.0
      RQRHGS(N,N5,N4)=0.0
      RQRNH4(N,N5,N4)=0.0
      RQRNH3(N,N5,N4)=0.0
      RQRNO3(N,N5,N4)=0.0
      RQRNO2(N,N5,N4)=0.0
      RQRH2P(N,N5,N4)=0.0
C
C     IF OVERLAND FLOW IS FROM CURRENT TO ADJACENT GRID CELL
C
      ELSEIF(QRM(M,N,N5,N4).GT.0.0)THEN
      IF(VOLWM(M,0,N2,N1).GT.ZEROS(N2,N1))THEN
      VFLW=AMAX1(0.0,AMIN1(FVFLW,QRM(M,N,N5,N4)
     2/VOLWM(M,0,N2,N1)))
      ELSE
      VFLW=0.0
      ENDIF
      DO 9835 K=0,2
      RQROC(K,N,N5,N4)=VFLW*AMAX1(0.0,OQC2(K,0,N2,N1))
      RQRON(K,N,N5,N4)=VFLW*AMAX1(0.0,OQN2(K,0,N2,N1))
      RQROP(K,N,N5,N4)=VFLW*AMAX1(0.0,OQP2(K,0,N2,N1))
      RQROA(K,N,N5,N4)=VFLW*AMAX1(0.0,OQA2(K,0,N2,N1))
9835  CONTINUE
      RQRCOS(N,N5,N4)=VFLW*AMAX1(0.0,CO2S2(0,N2,N1))
      RQRCHS(N,N5,N4)=VFLW*AMAX1(0.0,CH4S2(0,N2,N1))
      RQROXS(N,N5,N4)=VFLW*AMAX1(0.0,OXYS2(0,N2,N1))
      RQRNGS(N,N5,N4)=VFLW*AMAX1(0.0,Z2GS2(0,N2,N1))
      RQRN2S(N,N5,N4)=VFLW*AMAX1(0.0,Z2OS2(0,N2,N1))
      RQRHGS(N,N5,N4)=VFLW*AMAX1(0.0,H2GS2(0,N2,N1))
      RQRNH4(N,N5,N4)=VFLW*AMAX1(0.0,ZNH4S2(0,N2,N1))
      RQRNH3(N,N5,N4)=VFLW*AMAX1(0.0,ZN3S2(0,N2,N1))
      RQRNO3(N,N5,N4)=VFLW*AMAX1(0.0,ZNO3S2(0,N2,N1))
      RQRNO2(N,N5,N4)=VFLW*AMAX1(0.0,ZNO2S2(0,N2,N1))
      RQRH2P(N,N5,N4)=VFLW*AMAX1(0.0,H2PO42(0,N2,N1))
C
C     IF OVERLAND FLOW IS TO CURRENT FROM ADJACENT GRID CELL
C
      ELSEIF(QRM(M,N,N5,N4).LT.0.0)THEN
      IF(VOLWM(M,0,N5,N4).GT.ZEROS(N5,N4))THEN
      VFLW=AMIN1(0.0,AMAX1(-FVFLW,QRM(M,N,N5,N4)
     2/VOLWM(M,0,N5,N4)))
      ELSE
      VFLW=-1.0
      ENDIF
      DO 9830 K=0,2
      RQROC(K,N,N5,N4)=VFLW*AMAX1(0.0,OQC2(K,0,N5,N4))
      RQRON(K,N,N5,N4)=VFLW*AMAX1(0.0,OQN2(K,0,N5,N4))
      RQROP(K,N,N5,N4)=VFLW*AMAX1(0.0,OQP2(K,0,N5,N4))
      RQROA(K,N,N5,N4)=VFLW*AMAX1(0.0,OQA2(K,0,N5,N4))
9830  CONTINUE
      RQRCOS(N,N5,N4)=VFLW*AMAX1(0.0,CO2S2(0,N5,N4))
      RQRCHS(N,N5,N4)=VFLW*AMAX1(0.0,CH4S2(0,N5,N4))
      RQROXS(N,N5,N4)=VFLW*AMAX1(0.0,OXYS2(0,N5,N4))
      RQRNGS(N,N5,N4)=VFLW*AMAX1(0.0,Z2GS2(0,N5,N4))
      RQRN2S(N,N5,N4)=VFLW*AMAX1(0.0,Z2OS2(0,N5,N4))
      RQRHGS(N,N5,N4)=VFLW*AMAX1(0.0,H2GS2(0,N5,N4))
      RQRNH4(N,N5,N4)=VFLW*AMAX1(0.0,ZNH4S2(0,N5,N4))
      RQRNH3(N,N5,N4)=VFLW*AMAX1(0.0,ZN3S2(0,N5,N4))
      RQRNO3(N,N5,N4)=VFLW*AMAX1(0.0,ZNO3S2(0,N5,N4))
      RQRNO2(N,N5,N4)=VFLW*AMAX1(0.0,ZNO2S2(0,N5,N4))
      RQRH2P(N,N5,N4)=VFLW*AMAX1(0.0,H2PO42(0,N5,N4))
      ENDIF
C
C     ACCUMULATE HOURLY FLUXES
C
      DO 9825 K=0,2
      XOCQRS(K,N,N5,N4)=XOCQRS(K,N,N5,N4)+RQROC(K,N,N5,N4)
      XONQRS(K,N,N5,N4)=XONQRS(K,N,N5,N4)+RQRON(K,N,N5,N4)
      XOPQRS(K,N,N5,N4)=XOPQRS(K,N,N5,N4)+RQROP(K,N,N5,N4)
      XOAQRS(K,N,N5,N4)=XOAQRS(K,N,N5,N4)+RQROA(K,N,N5,N4)
9825  CONTINUE
      XCOQRS(N,N5,N4)=XCOQRS(N,N5,N4)+RQRCOS(N,N5,N4)
      XCHQRS(N,N5,N4)=XCHQRS(N,N5,N4)+RQRCHS(N,N5,N4)
      XOXQRS(N,N5,N4)=XOXQRS(N,N5,N4)+RQROXS(N,N5,N4)
      XNGQRS(N,N5,N4)=XNGQRS(N,N5,N4)+RQRNGS(N,N5,N4)
      XN2QRS(N,N5,N4)=XN2QRS(N,N5,N4)+RQRN2S(N,N5,N4)
      XHGQRS(N,N5,N4)=XHGQRS(N,N5,N4)+RQRHGS(N,N5,N4)
      XN4QRW(N,N5,N4)=XN4QRW(N,N5,N4)+RQRNH4(N,N5,N4)
      XN3QRW(N,N5,N4)=XN3QRW(N,N5,N4)+RQRNH3(N,N5,N4)
      XNOQRW(N,N5,N4)=XNOQRW(N,N5,N4)+RQRNO3(N,N5,N4)
      XNXQRS(N,N5,N4)=XNXQRS(N,N5,N4)+RQRNO2(N,N5,N4)
      XP4QRW(N,N5,N4)=XP4QRW(N,N5,N4)+RQRH2P(N,N5,N4)
C
C     IF NO SNOW DRIFT THEN NO TRANSPORT
C
      IF(QSM(M,N,N5,N4).EQ.0.0)THEN
      RQSCOS(N,N5,N4)=0.0
      RQSCHS(N,N5,N4)=0.0
      RQSOXS(N,N5,N4)=0.0
      RQSNGS(N,N5,N4)=0.0
      RQSN2S(N,N5,N4)=0.0
      RQSNH4(N,N5,N4)=0.0
      RQSNH3(N,N5,N4)=0.0
      RQSNO3(N,N5,N4)=0.0
      RQSH2P(N,N5,N4)=0.0
C
C     IF DRIFT IS FROM CURRENT TO ADJACENT GRID CELL
C
      ELSEIF(QSM(M,N,N5,N4).GT.0.0)THEN
      IF(VOLS(N2,N1).GT.ZEROS(N2,N1))THEN
      VFLW=AMAX1(0.0,AMIN1(1.0,QSM(M,N,N5,N4)/VOLS(N2,N1)))
      ELSE
      VFLW=0.0
      ENDIF
      RQSCOS(N,N5,N4)=VFLW*AMAX1(0.0,CO2W2(N2,N1))
      RQSCHS(N,N5,N4)=VFLW*AMAX1(0.0,CH4W2(N2,N1))
      RQSOXS(N,N5,N4)=VFLW*AMAX1(0.0,OXYW2(N2,N1))
      RQSNGS(N,N5,N4)=VFLW*AMAX1(0.0,ZNGW2(N2,N1))
      RQSN2S(N,N5,N4)=VFLW*AMAX1(0.0,ZN2W2(N2,N1))
      RQSNH4(N,N5,N4)=VFLW*AMAX1(0.0,ZN4W2(N2,N1))
      RQSNH3(N,N5,N4)=VFLW*AMAX1(0.0,ZN3W2(N2,N1))
      RQSNO3(N,N5,N4)=VFLW*AMAX1(0.0,ZNOW2(N2,N1))
      RQSH2P(N,N5,N4)=VFLW*AMAX1(0.0,ZHPW2(N2,N1))
C
C     IF DRIFT IS TO CURRENT FROM ADJACENT GRID CELL
C
      ELSEIF(QSM(M,N,N5,N4).LT.0.0)THEN
      IF(VOLS(N5,N4).GT.ZEROS(N5,N4))THEN
      VFLW=AMIN1(0.0,AMAX1(-1.0,QSM(M,N,N5,N4)/VOLS(N5,N4)))
      ELSE
      VFLW=-1.0
      ENDIF
      RQSCOS(N,N5,N4)=VFLW*AMAX1(0.0,CO2W2(N5,N4))
      RQSCHS(N,N5,N4)=VFLW*AMAX1(0.0,CH4W2(N5,N4))
      RQSOXS(N,N5,N4)=VFLW*AMAX1(0.0,OXYW2(N5,N4))
      RQSNGS(N,N5,N4)=VFLW*AMAX1(0.0,ZNGW2(N5,N4))
      RQSN2S(N,N5,N4)=VFLW*AMAX1(0.0,ZN2W2(N5,N4))
      RQSNH4(N,N5,N4)=VFLW*AMAX1(0.0,ZN4W2(N5,N4))
      RQSNH3(N,N5,N4)=VFLW*AMAX1(0.0,ZN3W2(N5,N4))
      RQSNO3(N,N5,N4)=VFLW*AMAX1(0.0,ZNOW2(N5,N4))
      RQSH2P(N,N5,N4)=VFLW*AMAX1(0.0,ZHPW2(N5,N4))
      ENDIF
C
C     ACCUMULATE HOURLY FLUXES
C
      XCOQSS(N,N5,N4)=XCOQSS(N,N5,N4)+RQSCOS(N,N5,N4)
      XCHQSS(N,N5,N4)=XCHQSS(N,N5,N4)+RQSCHS(N,N5,N4)
      XOXQSS(N,N5,N4)=XOXQSS(N,N5,N4)+RQSOXS(N,N5,N4)
      XNGQSS(N,N5,N4)=XNGQSS(N,N5,N4)+RQSNGS(N,N5,N4)
      XN2QSS(N,N5,N4)=XN2QSS(N,N5,N4)+RQSN2S(N,N5,N4)
      XN4QSS(N,N5,N4)=XN4QSS(N,N5,N4)+RQSNH4(N,N5,N4)
      XN3QSS(N,N5,N4)=XN3QSS(N,N5,N4)+RQSNH3(N,N5,N4)
      XNOQSS(N,N5,N4)=XNOQSS(N,N5,N4)+RQSNO3(N,N5,N4)
      XP4QSS(N,N5,N4)=XP4QSS(N,N5,N4)+RQSH2P(N,N5,N4)
C     IF(I.EQ.118.AND.NX.EQ.3.AND.NY.EQ.4)THEN
C     WRITE(*,6969)'XOXQSS',I,J,N4,N5,N,M,MM,XOXQSS(N,N5,N4)
C    2,RQSOXS(N,N5,N4),VFLW,OXYW2(N2,N1),OXYW2(N5,N4)
C    3,QSM(M,N,N5,N4),VOLS(N2,N1),VOLS(N5,N4)
6969  FORMAT(A8,7I4,20E12.4)
C     ENDIF
4310  CONTINUE
      ENDIF
C
C     VOLATILIZATION-DISSOLUTION OF GASES IN RESIDUE AND SOIL SURFACE
C     LAYERS FROM GASEOUS CONCENTRATIONS VS. THEIR AQUEOUS
C     EQUIVALENTS DEPENDING ON SOLUBILITY FROM 'HOUR1'
C     AND TRANSFER COEFFICIENT 'DFGS' FROM 'WATSUB'
C
      IF(VOLWM(M,0,NY,NX).GT.ZEROS(NY,NX))THEN
      CO2G0=CCO2G(0,NY,NX)*VOLPM(M,0,NY,NX)
      CH4G0=CCH4G(0,NY,NX)*VOLPM(M,0,NY,NX)
      OXYG0=COXYG(0,NY,NX)*VOLPM(M,0,NY,NX)
      Z2GG0=CZ2GG(0,NY,NX)*VOLPM(M,0,NY,NX)
      Z2OG0=CZ2OG(0,NY,NX)*VOLPM(M,0,NY,NX)
      ZN3G0=CNH3G(0,NY,NX)*VOLPM(M,0,NY,NX)
      H2GG0=CH2GG(0,NY,NX)*VOLPM(M,0,NY,NX)
      RCODFG(0,NY,NX)=DFGS(M,0,NY,NX)
     2*(AMAX1(ZEROS(NY,NX),CO2G0)*VOLWCO(0,NY,NX)
     3-(CO2S2(0,NY,NX)+RCODFR(NY,NX))
     4*VOLPM(M,0,NY,NX))/VOLCOR(NY,NX) 
      RCHDFG(0,NY,NX)=DFGS(M,0,NY,NX)
     2*(AMAX1(ZEROS(NY,NX),CH4G0)*VOLWCH(0,NY,NX)
     3-(CH4S2(0,NY,NX)+RCHDFR(NY,NX))
     4*VOLPM(M,0,NY,NX))/VOLCHR(NY,NX) 
      ROXDFG(0,NY,NX)=DFGS(M,0,NY,NX)
     2*(AMAX1(ZEROS(NY,NX),OXYG0)*VOLWOX(0,NY,NX) 
     3-(OXYS2(0,NY,NX)+ROXDFR(NY,NX))
     4*VOLPM(M,0,NY,NX))/VOLOXR(NY,NX) 
      RNGDFG(0,NY,NX)=DFGS(M,0,NY,NX)
     2*(AMAX1(ZEROS(NY,NX),Z2GG0)*VOLWNG(0,NY,NX)
     3-(Z2GS2(0,NY,NX)+RNGDFR(NY,NX))
     4*VOLPM(M,0,NY,NX))/VOLNGR(NY,NX) 
      RN2DFG(0,NY,NX)=DFGS(M,0,NY,NX)
     2*(AMAX1(ZEROS(NY,NX),Z2OG0)*VOLWN2(0,NY,NX)
     3-(Z2OS2(0,NY,NX)+RN2DFR(NY,NX))
     4*VOLPM(M,0,NY,NX))/VOLN2R(NY,NX) 
      RN3DFX=(AMAX1(ZEROS(NY,NX),ZN3G0)*VOLWN3(0,NY,NX)
     3-(ZN3S2(0,NY,NX)+RN3DFR(NY,NX))
     4*VOLPM(M,0,NY,NX))/VOLN3R(NY,NX) 
      IF(RN3DFX.GT.0.0)THEN
      RN3DFG(0,NY,NX)=DFGAS*DFGS(M,0,NY,NX)*RN3DFX 
      ELSE
      RN3DFG(0,NY,NX)=DFGAV*DFGS(M,0,NY,NX)*RN3DFX 
      ENDIF
      CNH3S0=AMAX1(0.0,(ZN3S2(0,NY,NX)+RN3DFG(0,NY,NX)))
     2/VOLWXA(0,NY,NX)
      CNH4S0=AMAX1(0.0,ZNH4S2(0,NY,NX))
     2/VOLWXA(0,NY,NX)
      RN34SQ(0,NY,NX)=VOLWXA(0,NY,NX)
     2*(CHY0(0,NY,NX)*CNH3S0-DPN4*CNH4S0)/(DPN4+CHY0(0,NY,NX))
      RHGDFG(0,NY,NX)=DFGS(M,0,NY,NX)
     2*(AMAX1(ZEROS(NY,NX),H2GG0)*VOLWHG(0,NY,NX)
     3-(H2GS2(0,NY,NX)+RHGDFR(NY,NX))
     4*VOLPM(M,0,NY,NX))/VOLHGR(NY,NX) 
C     IF(M.NE.MX.AND.J.EQ.15)THEN
C     WRITE(*,323)'ROXFLG',I,J,NX,NY,M,MM,ROXDFG(0,NY,NX)
C    2,DFGS(M,0,NY,NX),OXYG0,VOLWOX(0,NY,NX),OXYS2(0,NY,NX)
C    3,VOLPM(M,0,NY,NX),VOLOXR(NY,NX)
323   FORMAT(A8,6I4,30E12.4)
C     ENDIF
C
C     ACCUMULATE HOURLY FLUXES
C
      XCODFG(0,NY,NX)=XCODFG(0,NY,NX)+RCODFG(0,NY,NX)
      XCHDFG(0,NY,NX)=XCHDFG(0,NY,NX)+RCHDFG(0,NY,NX)
      XOXDFG(0,NY,NX)=XOXDFG(0,NY,NX)+ROXDFG(0,NY,NX)
      XNGDFG(0,NY,NX)=XNGDFG(0,NY,NX)+RNGDFG(0,NY,NX)
      XN2DFG(0,NY,NX)=XN2DFG(0,NY,NX)+RN2DFG(0,NY,NX)
      XN3DFG(0,NY,NX)=XN3DFG(0,NY,NX)+RN3DFG(0,NY,NX)
      XN34SQ(0,NY,NX)=XN34SQ(0,NY,NX)+RN34SQ(0,NY,NX)
      XHGDFG(0,NY,NX)=XHGDFG(0,NY,NX)+RHGDFG(0,NY,NX)
      ELSE
      RCODFG(0,NY,NX)=0.0
      RCHDFG(0,NY,NX)=0.0
      ROXDFG(0,NY,NX)=0.0
      RNGDFG(0,NY,NX)=0.0
      RN2DFG(0,NY,NX)=0.0
      RN3DFG(0,NY,NX)=0.0
      RN34SQ(0,NY,NX)=0.0
      RHGDFG(0,NY,NX)=0.0
      ENDIF
C
C     SURFACE GAS EXCHANGE FROM GAS DIFFUSIVITY THROUGH
C     SOIL SURFACE LAYER AND THROUGH ATMOSPHERE BOUNDARY
C     LAYER
C
      IF(THETPM(M,NU(NY,NX),NY,NX).GT.THETX
     2.AND.BKDS(NU(NY,NX),NY,NX).GT.0.0)THEN
C
C     GASEOUS DIFFUSIVITIES
C
      DFLG2=2.0*AMAX1(0.0,THETPM(M,NU(NY,NX),NY,NX))**2
     2/POROQ(NU(NY,NX),NY,NX)*AREA(3,NU(NY,NX),NY,NX)
     3/AMAX1(0.001,DLYR(3,NU(NY,NX),NY,NX))
      DCO2G(3,NU(NY,NX),NY,NX)=DFLG2*CGSGL2(NU(NY,NX),NY,NX)
      DCH4G(3,NU(NY,NX),NY,NX)=DFLG2*CHSGL2(NU(NY,NX),NY,NX)
      DOXYG(3,NU(NY,NX),NY,NX)=DFLG2*OGSGL2(NU(NY,NX),NY,NX)
      DZ2GG(3,NU(NY,NX),NY,NX)=DFLG2*ZGSGL2(NU(NY,NX),NY,NX)
      DZ2OG(3,NU(NY,NX),NY,NX)=DFLG2*Z2SGL2(NU(NY,NX),NY,NX)
      DNH3G(3,NU(NY,NX),NY,NX)=DFLG2*ZHSGL2(NU(NY,NX),NY,NX)
      DH2GG(3,NU(NY,NX),NY,NX)=DFLG2*HGSGL2(NU(NY,NX),NY,NX)
C
C     SURFACE GAS CONCENTRATIONS
C
      CCO2G2=AMAX1(0.0,CO2G2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
      CCH4G2=AMAX1(0.0,CH4G2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
      COXYG2=AMAX1(0.0,OXYG2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
      CZ2GG2=AMAX1(0.0,Z2GG2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
      CZ2OG2=AMAX1(0.0,Z2OG2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
      CNH3G2=AMAX1(0.0,ZN3G2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
      CH2GG2=AMAX1(0.0,H2GG2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
C
C     EQUILIBRIUM CONCENTRATIONS AT SOIL SURFACE AT WHICH
C     GASEOUS DIFFUSION THROUGH SOIL SURFACE LAYER = GASEOUS
C     DIFFUSION THROUGH ATMOSPHERE BOUNDARY LAYER CALCULATED
C     FROM GASEOUS DIFFUSIVITY AND BOUNDARY LAYER CONDUCTANCE
C
      DCO2GQ=DCO2G(3,NU(NY,NX),NY,NX)*PARGCO(NY,NX)
     2/(DCO2G(3,NU(NY,NX),NY,NX)+PARGCO(NY,NX))
      DCH4GQ=DCH4G(3,NU(NY,NX),NY,NX)*PARGCH(NY,NX)
     2/(DCH4G(3,NU(NY,NX),NY,NX)+PARGCH(NY,NX))
      DOXYGQ=DOXYG(3,NU(NY,NX),NY,NX)*PARGOX(NY,NX)
     2/(DOXYG(3,NU(NY,NX),NY,NX)+PARGOX(NY,NX))
      DZ2GGQ=DZ2GG(3,NU(NY,NX),NY,NX)*PARGNG(NY,NX)
     2/(DZ2GG(3,NU(NY,NX),NY,NX)+PARGNG(NY,NX))
      DZ2OGQ=DZ2OG(3,NU(NY,NX),NY,NX)*PARGN2(NY,NX)
     2/(DZ2OG(3,NU(NY,NX),NY,NX)+PARGN2(NY,NX))
      DNH3GQ=DNH3G(3,NU(NY,NX),NY,NX)*PARGN3(NY,NX)
     2/(DNH3G(3,NU(NY,NX),NY,NX)+PARGN3(NY,NX))
      DH2GGQ=DH2GG(3,NU(NY,NX),NY,NX)*PARGH2(NY,NX)
     2/(DH2GG(3,NU(NY,NX),NY,NX)+PARGH2(NY,NX))
      DFVCOG=DCO2GQ*(CCO2E(NY,NX)-CCO2G2)
      DFVCHG=DCH4GQ*(CCH4E(NY,NX)-CCH4G2)
      DFVOXG=DOXYGQ*(COXYE(NY,NX)-COXYG2)
      DFVNGG=DZ2GGQ*(CZ2GE(NY,NX)-CZ2GG2)
      DFVN2G=DZ2OGQ*(CZ2OE(NY,NX)-CZ2OG2)
      DFVN3G=DNH3GQ*(CNH3E(NY,NX)-CNH3G2)
      DFVHGG=DH2GGQ*(CH2GE(NY,NX)-CH2GG2)
C
C     CONVECTIVE GAS TRANSFER DRIVEN BY SURFACE WATER FLUXES
C     FROM 'WATSUB' AND GAS CONCENTRATIONS IN THE SOIL SURFACE
C     OR THE ATMOSPHERE DEPENDING ON WATER FLUX DIRECTION
C
      IF(FLQM(3,NU(NY,NX),NY,NX).GT.0.0)THEN
      IF(VOLPM(M,NU(NY,NX),NY,NX).GT.ZEROS(NY,NX))THEN
      VFLW=-AMAX1(0.0,AMIN1(FVFLW,FLQM(3,NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX)))
      ELSE
      VFLW=0.0
      ENDIF
      RFLCOG=VFLW*AMAX1(0.0,CO2G2(NU(NY,NX),NY,NX))
      RFLCHG=VFLW*AMAX1(0.0,CH4G2(NU(NY,NX),NY,NX))
      RFLOXG=VFLW*AMAX1(0.0,OXYG2(NU(NY,NX),NY,NX))
      RFLNGG=VFLW*AMAX1(0.0,Z2GG2(NU(NY,NX),NY,NX))
      RFLN2G=VFLW*AMAX1(0.0,Z2OG2(NU(NY,NX),NY,NX))
      RFLN3G=VFLW*AMAX1(0.0,ZN3G2(NU(NY,NX),NY,NX))
      RFLH2G=VFLW*AMAX1(0.0,H2GG2(NU(NY,NX),NY,NX))
      ELSE
      RFLCOG=-FLQM(3,NU(NY,NX),NY,NX)*CCO2E(NY,NX)
      RFLCHG=-FLQM(3,NU(NY,NX),NY,NX)*CCH4E(NY,NX)
      RFLOXG=-FLQM(3,NU(NY,NX),NY,NX)*COXYE(NY,NX)
      RFLNGG=-FLQM(3,NU(NY,NX),NY,NX)*CZ2GE(NY,NX)
      RFLN2G=-FLQM(3,NU(NY,NX),NY,NX)*CZ2OE(NY,NX)
      RFLN3G=-FLQM(3,NU(NY,NX),NY,NX)*CNH3E(NY,NX)
      RFLH2G=-FLQM(3,NU(NY,NX),NY,NX)*CH2GE(NY,NX)
      ENDIF
C
C     SURFACE GAS FLUX FROM DIFFERENCES
C     BETWEEN ATMOSPHERIC AND SOIL SURFACE EQUILIBRIUM
C     CONCENTRATIONS + CONVECTIVE FLUX
C
      RCOFLG(3,NU(NY,NX),NY,NX)=DFVCOG+RFLCOG 
      RCHFLG(3,NU(NY,NX),NY,NX)=DFVCHG+RFLCHG 
      ROXFLG(3,NU(NY,NX),NY,NX)=DFVOXG+RFLOXG 
      RNGFLG(3,NU(NY,NX),NY,NX)=DFVNGG+RFLNGG 
      RN2FLG(3,NU(NY,NX),NY,NX)=DFVN2G+RFLN2G 
      RN3FLG(3,NU(NY,NX),NY,NX)=DFVN3G+RFLN3G 
      RHGFLG(3,NU(NY,NX),NY,NX)=DFVHGG+RFLH2G 
C
C     ACCUMULATE HOURLY FLUXES
C
      XCOFLG(3,NU(NY,NX),NY,NX)=XCOFLG(3,NU(NY,NX),NY,NX)
     2+RCOFLG(3,NU(NY,NX),NY,NX)
      XCHFLG(3,NU(NY,NX),NY,NX)=XCHFLG(3,NU(NY,NX),NY,NX)
     2+RCHFLG(3,NU(NY,NX),NY,NX)
      XOXFLG(3,NU(NY,NX),NY,NX)=XOXFLG(3,NU(NY,NX),NY,NX)
     2+ROXFLG(3,NU(NY,NX),NY,NX)
      XNGFLG(3,NU(NY,NX),NY,NX)=XNGFLG(3,NU(NY,NX),NY,NX)
     2+RNGFLG(3,NU(NY,NX),NY,NX)
      XN2FLG(3,NU(NY,NX),NY,NX)=XN2FLG(3,NU(NY,NX),NY,NX)
     2+RN2FLG(3,NU(NY,NX),NY,NX)
      XN3FLG(3,NU(NY,NX),NY,NX)=XN3FLG(3,NU(NY,NX),NY,NX)
     2+RN3FLG(3,NU(NY,NX),NY,NX)
      XHGFLG(3,NU(NY,NX),NY,NX)=XHGFLG(3,NU(NY,NX),NY,NX)
     2+RHGFLG(3,NU(NY,NX),NY,NX)
C     IF(NX.EQ.3.AND.NY.EQ.2.AND.I.GE.190)THEN
C     WRITE(*,3131)'ROXFLG',I,J,NX,NY,M,MM,XOXFLG(3,NU(NY,NX),NY,NX)
C    2,ROXFLG(3,NU(NY,NX),NY,NX),DFVOXG,RFLOXG,COXYE(NY,NX) 
C    2,COXYG2,DOXYGQ,OXYG2(NU(NY,NX),NY,NX),FLQM(3,NU(NY,NX),NY,NX)
C    3,VFLW,DOXYG(3,NU(NY,NX),NY,NX),PARGOX(NY,NX)
C    4,THETPM(M,NU(NY,NX),NY,NX),VOLPM(M,NU(NY,NX),NY,NX)
3131  FORMAT(A8,6I4,30E12.4)
C     ENDIF
C
C     SOIL SURFACE
C 
      IF(THETW1(NU(NY,NX),NY,NX).GT.THETY(NU(NY,NX),NY,NX))THEN
      RCODFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),CO2G2(NU(NY,NX),NY,NX))
     3*VOLWCO(NU(NY,NX),NY,NX)-(CO2S2(NU(NY,NX),NY,NX) 
     4+RCODFS(NY,NX))*VOLPM(M,NU(NY,NX),NY,NX))/VOLCOT(NY,NX)
      RCHDFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),CH4G2(NU(NY,NX),NY,NX))
     3*VOLWCH(NU(NY,NX),NY,NX)-(CH4S2(NU(NY,NX),NY,NX) 
     4+RCHDFS(NY,NX))*VOLPM(M,NU(NY,NX),NY,NX))/VOLCHT(NY,NX)
      ROXDFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),OXYG2(NU(NY,NX),NY,NX))
     3*VOLWOX(NU(NY,NX),NY,NX)-(OXYS2(NU(NY,NX),NY,NX) 
     4+ROXDFS(NY,NX))*VOLPM(M,NU(NY,NX),NY,NX))/VOLOXT(NY,NX) 
      RNGDFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),Z2GG2(NU(NY,NX),NY,NX))
     3*VOLWNG(NU(NY,NX),NY,NX)-(Z2GS2(NU(NY,NX),NY,NX)
     4+RNGDFS(NY,NX))*VOLPM(M,NU(NY,NX),NY,NX))/VOLNGT(NY,NX)
      RN2DFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),Z2OG2(NU(NY,NX),NY,NX))
     3*VOLWN2(NU(NY,NX),NY,NX)-(Z2OS2(NU(NY,NX),NY,NX) 
     4+RN2DFS(NY,NX))*VOLPM(M,NU(NY,NX),NY,NX))/VOLN2T(NY,NX)
      IF(VOLN3T(NY,NX).GT.ZEROS(NY,NX)
     2.AND.VOLWXA(NU(NY,NX),NY,NX).GT.ZEROS(NY,NX))THEN
      ZN3G2A=ZN3G2(NU(NY,NX),NY,NX)*VLNH4(NU(NY,NX),NY,NX)
      RN3DFX=(AMAX1(ZEROS(NY,NX),ZN3G2A)*VOLWN3(NU(NY,NX),NY,NX)
     2-(ZN3S2(NU(NY,NX),NY,NX)+RN3DFS(NY,NX))
     3*VOLPMA(NU(NY,NX),NY,NX))/VOLN3T(NY,NX)
      IF(RN3DFX.GT.0.0)THEN
      RN3DFG(NU(NY,NX),NY,NX)=DFGAS*DFGS(M,NU(NY,NX),NY,NX)*RN3DFX
      ELSE
      RN3DFG(NU(NY,NX),NY,NX)=DFGAV*DFGS(M,NU(NY,NX),NY,NX)*RN3DFX
      ENDIF
      CNH3S0=AMAX1(0.0,(ZN3S2(NU(NY,NX),NY,NX)
     2+RN3DFG(NU(NY,NX),NY,NX))/VOLWXA(NU(NY,NX),NY,NX))
      CNH4S0=AMAX1(0.0,ZNH4S2(NU(NY,NX),NY,NX))
     2/VOLWXA(NU(NY,NX),NY,NX)
      RN34SQ(NU(NY,NX),NY,NX)=VOLWXA(NU(NY,NX),NY,NX)
     2*(CHY0(NU(NY,NX),NY,NX)*CNH3S0-DPN4*CNH4S0)
     3/(DPN4+CHY0(NU(NY,NX),NY,NX))
      ELSE
      RN3DFG(NU(NY,NX),NY,NX)=0.0
      RN34SQ(NU(NY,NX),NY,NX)=0.0
      ENDIF
      IF(VOLNBT(NY,NX).GT.ZEROS(NY,NX)
     2.AND.VOLWXB(NU(NY,NX),NY,NX).GT.ZEROS(NY,NX))THEN
      ZN3G2B=ZN3G2(NU(NY,NX),NY,NX)*VLNHB(NU(NY,NX),NY,NX)
      RNBDFX=(AMAX1(ZEROS(NY,NX),ZN3G2B)*VOLWNB(NU(NY,NX),NY,NX)
     2-(ZNBS2(NU(NY,NX),NY,NX)+RNBDFS(NY,NX))
     3*VOLPMB(NU(NY,NX),NY,NX))/VOLNBT(NY,NX)
      IF(RNBDFX.GT.0.0)THEN
      RNBDFG(NU(NY,NX),NY,NX)=DFGAS*DFGS(M,NU(NY,NX),NY,NX)*RNBDFX
      ELSE
      RNBDFG(NU(NY,NX),NY,NX)=DFGAV*DFGS(M,NU(NY,NX),NY,NX)*RNBDFX
      ENDIF
      CNH3B0=AMAX1(0.0,(ZNBS2(NU(NY,NX),NY,NX)
     2+RNBDFG(NU(NY,NX),NY,NX))/VOLWXB(NU(NY,NX),NY,NX))
      CNH4B0=AMAX1(0.0,ZNH4B2(NU(NY,NX),NY,NX))
     2/VOLWXB(NU(NY,NX),NY,NX)
      RN34BQ(NU(NY,NX),NY,NX)=VOLWXB(NU(NY,NX),NY,NX)
     2*(CHY0(NU(NY,NX),NY,NX)*CNH3B0-DPN4*CNH4B0)
     3/(DPN4+CHY0(NU(NY,NX),NY,NX))
      ELSE
      RNBDFG(NU(NY,NX),NY,NX)=0.0
      RN34BQ(NU(NY,NX),NY,NX)=0.0
      ENDIF
      RHGDFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),H2GG2(NU(NY,NX),NY,NX))
     3*VOLWHG(NU(NY,NX),NY,NX)-(H2GS2(NU(NY,NX),NY,NX)
     4+RHGDFS(NY,NX))*VOLPM(M,NU(NY,NX),NY,NX))/VOLHGT(NY,NX)
C     IF(J.EQ.12)THEN
C     WRITE(*,323)'RN3FLG',I,J,M,MM,RN3FLG(3,NU(NY,NX),NY,NX)
C    2,DNH3GQ,CNH3E(NY,NX),CNH3G2,FLQM(3,NU(NY,NX),NY,NX),CNH3GV
C    2,CNH3B2,ZNBS2(NU(NY,NX),NY,NX),RNBDFG(NU(NY,NX),NY,NX)
C    3,DFGS(M,NU(NY,NX),NY,NX),ZN3G2B,VOLPMB(NU(NY,NX),NY,NX)
C    4,ZNBS2(NU(NY,NX),NY,NX),VOLWNB(NU(NY,NX),NY,NX)
C    5,VOLWMB,SNH3L(NU(NY,NX),NY,NX)
C     ENDIF
C
C     ACCUMULATE HOURLY FLUXES
C
      XCODFG(NU(NY,NX),NY,NX)=XCODFG(NU(NY,NX),NY,NX)
     2+RCODFG(NU(NY,NX),NY,NX)
      XCHDFG(NU(NY,NX),NY,NX)=XCHDFG(NU(NY,NX),NY,NX)
     2+RCHDFG(NU(NY,NX),NY,NX)
      XOXDFG(NU(NY,NX),NY,NX)=XOXDFG(NU(NY,NX),NY,NX)
     2+ROXDFG(NU(NY,NX),NY,NX)
      XNGDFG(NU(NY,NX),NY,NX)=XNGDFG(NU(NY,NX),NY,NX)
     2+RNGDFG(NU(NY,NX),NY,NX)
      XN2DFG(NU(NY,NX),NY,NX)=XN2DFG(NU(NY,NX),NY,NX)
     2+RN2DFG(NU(NY,NX),NY,NX)
      XN3DFG(NU(NY,NX),NY,NX)=XN3DFG(NU(NY,NX),NY,NX)
     2+RN3DFG(NU(NY,NX),NY,NX)
      XN34SQ(NU(NY,NX),NY,NX)=XN34SQ(NU(NY,NX),NY,NX)
     2+RN34SQ(NU(NY,NX),NY,NX)
      XNBDFG(NU(NY,NX),NY,NX)=XNBDFG(NU(NY,NX),NY,NX)
     2+RNBDFG(NU(NY,NX),NY,NX)
      XN34BQ(NU(NY,NX),NY,NX)=XN34BQ(NU(NY,NX),NY,NX)
     2+RN34BQ(NU(NY,NX),NY,NX)
      XHGDFG(NU(NY,NX),NY,NX)=XHGDFG(NU(NY,NX),NY,NX)
     2+RHGDFG(NU(NY,NX),NY,NX)
C     WRITE(*,3131)'ROXDFG',I,J,NX,NY,M,MM,XOXDFG(NU(NY,NX),NY,NX)
C    2,ROXDFG(NU(NY,NX),NY,NX),DFGS(M,NU(NY,NX),NY,NX)
C    2,AMAX1(ZEROS(NY,NX),OXYG2(NU(NY,NX),NY,NX))
C    3,VOLWOX(NU(NY,NX),NY,NX),AMAX1(ZEROS(NY,NX)
C    4,OXYS2(NU(NY,NX),NY,NX)),VOLPM(M,NU(NY,NX),NY,NX)
      ELSE
      RCODFG(NU(NY,NX),NY,NX)=0.0
      RCHDFG(NU(NY,NX),NY,NX)=0.0
      ROXDFG(NU(NY,NX),NY,NX)=0.0
      RNGDFG(NU(NY,NX),NY,NX)=0.0
      RN2DFG(NU(NY,NX),NY,NX)=0.0
      RN3DFG(NU(NY,NX),NY,NX)=0.0
      RN34SQ(NU(NY,NX),NY,NX)=0.0
      RNBDFG(NU(NY,NX),NY,NX)=0.0
      RN34BQ(NU(NY,NX),NY,NX)=0.0
      RHGDFG(NU(NY,NX),NY,NX)=0.0
      ENDIF
      ELSE
      RCOFLG(3,NU(NY,NX),NY,NX)=0.0
      RCHFLG(3,NU(NY,NX),NY,NX)=0.0
      ROXFLG(3,NU(NY,NX),NY,NX)=0.0
      RNGFLG(3,NU(NY,NX),NY,NX)=0.0
      RN2FLG(3,NU(NY,NX),NY,NX)=0.0
      RN3FLG(3,NU(NY,NX),NY,NX)=0.0
      RHGFLG(3,NU(NY,NX),NY,NX)=0.0
      RCODFG(NU(NY,NX),NY,NX)=0.0
      RCHDFG(NU(NY,NX),NY,NX)=0.0
      ROXDFG(NU(NY,NX),NY,NX)=0.0
      RN2DFG(NU(NY,NX),NY,NX)=0.0
      RNGDFG(NU(NY,NX),NY,NX)=0.0
      RN3DFG(NU(NY,NX),NY,NX)=0.0
      RN34SQ(NU(NY,NX),NY,NX)=0.0
      RNBDFG(NU(NY,NX),NY,NX)=0.0
      RN34BQ(NU(NY,NX),NY,NX)=0.0
      RHGDFG(NU(NY,NX),NY,NX)=0.0
      ENDIF
C
C     SOLUTE FLUXES BETWEEN ADJACENT GRID CELLS
C
      IFLGB=0
      DO 125 L=1,NL(NY,NX)
      N1=NX
      N2=NY
      N3=L
C
C     LOCATE INTERNAL BOUNDARIES BETWEEN ADJACENT GRID CELLS
C
      DO 120 N=NCN(N2,N1),3
      IF(N.EQ.1)THEN
      IF(NX.EQ.NHE)THEN
      GO TO 120
      ELSE
      N4=NX+1
      N5=NY
      N6=L
      ENDIF
      ELSEIF(N.EQ.2)THEN
      IF(NY.EQ.NVS)THEN
      GO TO 120
      ELSE
      N4=NX
      N5=NY+1
      N6=L
      ENDIF
      ELSEIF(N.EQ.3)THEN
      IF(L.EQ.NL(NY,NX))THEN
      GO TO 120
      ELSE
      N4=NX
      N5=NY
      N6=L+1
      ENDIF
      ENDIF
      IF(N3.GE.NU(N2,N1).AND.N6.GE.NU(N5,N4))THEN
      IF(M.NE.MX)THEN
C
C     SOLUTE FLUXES BETWEEN ADJACENT GRID CELLS FROM
C     WATER CONTENTS AND WATER FLUXES 'FLQM' FROM 'WATSUB'
C
      VOLW4A=VOLWM(M,N3,N2,N1)*VLNH4(N3,N2,N1)
      VOLW4B=VOLWM(M,N3,N2,N1)*VLNHB(N3,N2,N1)
      VOLH4A=VOLWHM(M,N3,N2,N1)*VLNH4(N3,N2,N1)
      VOLH4B=VOLWHM(M,N3,N2,N1)*VLNHB(N3,N2,N1)
      VOLW3A=VOLWM(M,N3,N2,N1)*VLNO3(N3,N2,N1)
      VOLW3B=VOLWM(M,N3,N2,N1)*VLNOB(N3,N2,N1)
      VOLH3A=VOLWHM(M,N3,N2,N1)*VLNO3(N3,N2,N1)
      VOLH3B=VOLWHM(M,N3,N2,N1)*VLNOB(N3,N2,N1)
      VOLW2A=VOLWM(M,N3,N2,N1)*VLPO4(N3,N2,N1)
      VOLW2B=VOLWM(M,N3,N2,N1)*VLPOB(N3,N2,N1)
      VOLH2A=VOLWHM(M,N3,N2,N1)*VLPO4(N3,N2,N1)
      VOLH2B=VOLWHM(M,N3,N2,N1)*VLPOB(N3,N2,N1)
      VOLWMA(N6,N5,N4)=VOLWM(M,N6,N5,N4)*VLNH4(N6,N5,N4)
      VOLWMB(N6,N5,N4)=VOLWM(M,N6,N5,N4)*VLNHB(N6,N5,N4)
      VOLWXA(N6,N5,N4)=14.0*VOLWMA(N6,N5,N4)
      VOLWXB(N6,N5,N4)=14.0*VOLWMB(N6,N5,N4)
      VOLWOA=VOLWM(M,N6,N5,N4)*VLNO3(N6,N5,N4)
      VOLWOB=VOLWM(M,N6,N5,N4)*VLNOB(N6,N5,N4)
      VOLHOA=VOLWHM(M,N6,N5,N4)*VLNO3(N6,N5,N4)
      VOLHOB=VOLWHM(M,N6,N5,N4)*VLNOB(N6,N5,N4)
      VOLWPA=VOLWM(M,N6,N5,N4)*VLPO4(N6,N5,N4)
      VOLWPB=VOLWM(M,N6,N5,N4)*VLPOB(N6,N5,N4)
      VOLHPA=VOLWHM(M,N6,N5,N4)*VLPO4(N6,N5,N4)
      VOLHPB=VOLWHM(M,N6,N5,N4)*VLPOB(N6,N5,N4)
      VOLPMA(N6,N5,N4)=VOLPM(M,N6,N5,N4)*VLNH4(N6,N5,N4)
      VOLPMB(N6,N5,N4)=VOLPM(M,N6,N5,N4)*VLNHB(N6,N5,N4)
      THETW1(N3,N2,N1)=AMAX1(0.0,VOLWM(M,N3,N2,N1)/VOLX(N3,N2,N1))
      THETW1(N6,N5,N4)=AMAX1(0.0,VOLWM(M,N6,N5,N4)/VOLX(N6,N5,N4))
      FLVM(N6,N5,N4)=FLPM(M,N6,N5,N4)*XNPT
C
C     GASEOUS SOLUBILITIES
C
      IF(N.EQ.3)THEN
      VOLWCO(N6,N5,N4)=VOLWM(M,N6,N5,N4)*SCO2L(N6,N5,N4)
      VOLWCH(N6,N5,N4)=VOLWM(M,N6,N5,N4)*SCH4L(N6,N5,N4)
      VOLWOX(N6,N5,N4)=VOLWM(M,N6,N5,N4)*SOXYL(N6,N5,N4)
      VOLWNG(N6,N5,N4)=VOLWM(M,N6,N5,N4)*SN2GL(N6,N5,N4)
      VOLWN2(N6,N5,N4)=VOLWM(M,N6,N5,N4)*SN2OL(N6,N5,N4)
      VOLWN3(N6,N5,N4)=VOLWMA(N6,N5,N4)*SNH3L(N6,N5,N4)
      VOLWNB(N6,N5,N4)=VOLWMB(N6,N5,N4)*SNH3L(N6,N5,N4)
      VOLWHG(N6,N5,N4)=VOLWM(M,N6,N5,N4)*SH2GL(N6,N5,N4)
      ENDIF
      FLQM(N,N6,N5,N4)=(FLWM(M,N,N6,N5,N4)+FLWHM(M,N,N6,N5,N4))*XNPT
C
C     SOLUTE TRANSPORT IN MICROPORES
C
      IF(FLWM(M,N,N6,N5,N4).GT.0.0)THEN
C
C     IF MICROPORE WATER FLUX FROM 'WATSUB' IS FROM CURRENT TO
C     ADJACENT GRID CELL THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MICROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN CURRENT GRID CELL
C
      IF(VOLWM(M,N3,N2,N1).GT.ZEROS(N2,N1))THEN
      VFLW=AMAX1(0.0,AMIN1(FVFLW,FLWM(M,N,N6,N5,N4)
     2/VOLWM(M,N3,N2,N1)))
      ELSE
      VFLW=0.0
      ENDIF
      DO 9820 K=0,4
      RFLOC(K)=VFLW*AMAX1(0.0,OQC2(K,N3,N2,N1))
      RFLON(K)=VFLW*AMAX1(0.0,OQN2(K,N3,N2,N1))
      RFLOP(K)=VFLW*AMAX1(0.0,OQP2(K,N3,N2,N1))
      RFLOA(K)=VFLW*AMAX1(0.0,OQA2(K,N3,N2,N1))
9820  CONTINUE
      RFLCOS=VFLW*AMAX1(0.0,CO2S2(N3,N2,N1))
      RFLCHS=VFLW*AMAX1(0.0,CH4S2(N3,N2,N1))
      RFLOXS=VFLW*AMAX1(0.0,OXYS2(N3,N2,N1))
      RFLNGS=VFLW*AMAX1(0.0,Z2GS2(N3,N2,N1))
      RFLN2S=VFLW*AMAX1(0.0,Z2OS2(N3,N2,N1))
      RFLHGS=VFLW*AMAX1(0.0,H2GS2(N3,N2,N1))
      RFLNH4=VFLW*AMAX1(0.0,ZNH4S2(N3,N2,N1))
      RFLNH3=VFLW*AMAX1(0.0,ZN3S2(N3,N2,N1))
      RFLNO3=VFLW*AMAX1(0.0,ZNO3S2(N3,N2,N1))
      RFLNO2=VFLW*AMAX1(0.0,ZNO2S2(N3,N2,N1))
      RFLPO4=VFLW*AMAX1(0.0,H2PO42(N3,N2,N1))
      RFLN4B=VFLW*AMAX1(0.0,ZNH4B2(N3,N2,N1))
      RFLN3B=VFLW*AMAX1(0.0,ZNBS2(N3,N2,N1))
      RFLNOB=VFLW*AMAX1(0.0,ZNO3B2(N3,N2,N1))
      RFLN2B=VFLW*AMAX1(0.0,ZNO2B2(N3,N2,N1))
      RFLPOB=VFLW*AMAX1(0.0,H2POB2(N3,N2,N1))
      ELSE
C
C     IF MICROPORE WATER FLUX FROM 'WATSUB' IS TO CURRENT FROM
C     ADJACENT GRID CELL THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MICROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN ADJACENT GRID CELL
C
      IF(VOLWM(M,N6,N5,N4).GT.ZEROS(N5,N4))THEN
      VFLW=AMIN1(0.0,AMAX1(-FVFLW,FLWM(M,N,N6,N5,N4)
     2/VOLWM(M,N6,N5,N4)))
      ELSE
      VFLW=-1.0
      ENDIF
      DO 9815 K=0,4
      RFLOC(K)=VFLW*AMAX1(0.0,OQC2(K,N6,N5,N4))
      RFLON(K)=VFLW*AMAX1(0.0,OQN2(K,N6,N5,N4))
      RFLOP(K)=VFLW*AMAX1(0.0,OQP2(K,N6,N5,N4))
      RFLOA(K)=VFLW*AMAX1(0.0,OQA2(K,N6,N5,N4))
9815  CONTINUE
      RFLCOS=VFLW*AMAX1(0.0,CO2S2(N6,N5,N4))
      RFLCHS=VFLW*AMAX1(0.0,CH4S2(N6,N5,N4))
      RFLOXS=VFLW*AMAX1(0.0,OXYS2(N6,N5,N4))
      RFLNGS=VFLW*AMAX1(0.0,Z2GS2(N6,N5,N4))
      RFLN2S=VFLW*AMAX1(0.0,Z2OS2(N6,N5,N4))
      RFLHGS=VFLW*AMAX1(0.0,H2GS2(N6,N5,N4))
      RFLNH4=VFLW*AMAX1(0.0,ZNH4S2(N6,N5,N4))
      RFLNH3=VFLW*AMAX1(0.0,ZN3S2(N6,N5,N4))
      RFLNO3=VFLW*AMAX1(0.0,ZNO3S2(N6,N5,N4))
      RFLNO2=VFLW*AMAX1(0.0,ZNO2S2(N6,N5,N4))
      RFLPO4=VFLW*AMAX1(0.0,H2PO42(N6,N5,N4))
      RFLN4B=VFLW*AMAX1(0.0,ZNH4B2(N6,N5,N4))
      RFLN3B=VFLW*AMAX1(0.0,ZNBS2(N6,N5,N4))
      RFLNOB=VFLW*AMAX1(0.0,ZNO3B2(N6,N5,N4))
      RFLN2B=VFLW*AMAX1(0.0,ZNO2B2(N6,N5,N4))
      RFLPOB=VFLW*AMAX1(0.0,H2POB2(N6,N5,N4))
      ENDIF
C
C     DIFFUSIVE FLUXES OF GASES AND SOLUTES BETWEEN CURRENT AND
C     ADJACENT GRID CELL MICROPORES FROM AQUEOUS DIFFUSIVITIES
C     AND CONCENTRATION DIFFERENCES
C
      IF(THETW1(N3,N2,N1).GT.THETY(N3,N2,N1)
     2.AND.THETW1(N6,N5,N4).GT.THETY(N6,N5,N4))THEN
C
C     MICROPORE CONCENTRATIONS FROM WATER-FILLED POROSITY
C     IN CURRENT AND ADJACENT GRID CELLS
C
      DO 9810 K=0,4
      COQC1(K)=AMAX1(0.0,OQC2(K,N3,N2,N1)/VOLWM(M,N3,N2,N1))
      COQN1(K)=AMAX1(0.0,OQN2(K,N3,N2,N1)/VOLWM(M,N3,N2,N1))
      COQP1(K)=AMAX1(0.0,OQP2(K,N3,N2,N1)/VOLWM(M,N3,N2,N1))
      COQA1(K)=AMAX1(0.0,OQA2(K,N3,N2,N1)/VOLWM(M,N3,N2,N1))
      COQC2(K)=AMAX1(0.0,OQC2(K,N6,N5,N4)/VOLWM(M,N6,N5,N4))
      COQN2(K)=AMAX1(0.0,OQN2(K,N6,N5,N4)/VOLWM(M,N6,N5,N4))
      COQP2(K)=AMAX1(0.0,OQP2(K,N6,N5,N4)/VOLWM(M,N6,N5,N4))
      COQA2(K)=AMAX1(0.0,OQA2(K,N6,N5,N4)/VOLWM(M,N6,N5,N4))
9810  CONTINUE
      CCO2S1=AMAX1(0.0,CO2S2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CCH4S1=AMAX1(0.0,CH4S2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      COXYS1=AMAX1(0.0,OXYS2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CZ2GS1=AMAX1(0.0,Z2GS2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CZ2OS1=AMAX1(0.0,Z2OS2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CH2GS1=AMAX1(0.0,H2GS2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      IF(VOLW4A.GT.ZEROS(N2,N1))THEN
      CNH4S1=AMAX1(0.0,ZNH4S2(N3,N2,N1)/VOLW4A)
      CNH3S1=AMAX1(0.0,ZN3S2(N3,N2,N1)/VOLW4A)
      ELSE
      CNH4S1=0.0
      CNH3S1=0.0
      ENDIF
      IF(VOLW3A.GT.ZEROS(N2,N1))THEN
      CNO3S1=AMAX1(0.0,ZNO3S2(N3,N2,N1)/VOLW3A)
      CNO2S1=AMAX1(0.0,ZNO2S2(N3,N2,N1)/VOLW3A)
      ELSE
      CNO3S1=0.0
      CNO2S1=0.0
      ENDIF
      IF(VOLW2A.GT.ZEROS(N2,N1))THEN
      CPO4S1=AMAX1(0.0,H2PO42(N3,N2,N1)/VOLW2A)
      ELSE
      CPO4S1=0.0
      ENDIF
      IF(VOLW4B.GT.ZEROS(N2,N1))THEN
      CNH4B1=AMAX1(0.0,ZNH4B2(N3,N2,N1)/VOLW4B)
      CNH3B1=AMAX1(0.0,ZNBS2(N3,N2,N1)/VOLW4B)
      ELSE
      CNH4B1=0.0
      CNH3B1=0.0
      ENDIF
      IF(VOLW3B.GT.ZEROS(N2,N1))THEN
      CNO3B1=AMAX1(0.0,ZNO3B2(N3,N2,N1)/VOLW3B)
      CNO2B1=AMAX1(0.0,ZNO2B2(N3,N2,N1)/VOLW3B)
      ELSE
      CNO3B1=CNO3S1
      CNO2B1=CNO2S1
      ENDIF
      IF(VOLW2B.GT.ZEROS(N2,N1))THEN
      CPO4B1=AMAX1(0.0,H2POB2(N3,N2,N1)/VOLW2B)
      ELSE
      CPO4B1=CPO4S1
      ENDIF
      CCO2S2=AMAX1(0.0,CO2S2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CCH4S2=AMAX1(0.0,CH4S2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      COXYS2=AMAX1(0.0,OXYS2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CZ2GS2=AMAX1(0.0,Z2GS2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CZ2OS2=AMAX1(0.0,Z2OS2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CH2GS2=AMAX1(0.0,H2GS2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      IF(VOLWMA(N6,N5,N4).GT.ZEROS(N5,N4))THEN
      CNH3S2=AMAX1(0.0,ZN3S2(N6,N5,N4)/VOLWMA(N6,N5,N4))
      CNH4S2=AMAX1(0.0,ZNH4S2(N6,N5,N4)/VOLWMA(N6,N5,N4))
      ELSE
      CNH3S2=0.0
      CNH4S2=0.0
      ENDIF
      IF(VOLWOA.GT.ZEROS(N5,N4))THEN
      CNO3S2=AMAX1(0.0,ZNO3S2(N6,N5,N4)/VOLWOA)
      CNO2S2=AMAX1(0.0,ZNO2S2(N6,N5,N4)/VOLWOA)
      ELSE
      CNO3S2=0.0
      CNO2S2=0.0
      ENDIF
      IF(VOLWPA.GT.ZEROS(N5,N4))THEN
      CPO4S2=AMAX1(0.0,H2PO42(N6,N5,N4)/VOLWPA)
      ELSE
      CPO4S2=0.0
      ENDIF
      IF(VOLWMB(N6,N5,N4).GT.ZEROS(N5,N4))THEN
      CNH3B2=AMAX1(0.0,ZNBS2(N6,N5,N4)/VOLWMB(N6,N5,N4))
      CNH4B2=AMAX1(0.0,ZNH4B2(N6,N5,N4)/VOLWMB(N6,N5,N4))
      ELSE
      CNH3B2=CNH3S2
      CNH4B2=CNH4S2
      ENDIF
      IF(VOLWOB.GT.ZEROS(N5,N4))THEN
      CNO3B2=AMAX1(0.0,ZNO3B2(N6,N5,N4)/VOLWOB)
      CNO2B2=AMAX1(0.0,ZNO2B2(N6,N5,N4)/VOLWOB)
      ELSE
      CNO3B2=CNO3S2
      CNO2B2=CNO2S2
      ENDIF
      IF(VOLWPB.GT.ZEROS(N5,N4))THEN
      CPO4B2=AMAX1(0.0,H2POB2(N6,N5,N4)/VOLWPB)
      ELSE
      CPO4B2=CPO4S2
      ENDIF
C
C     DIFFUSIVITIES IN CURRENT AND ADJACENT GRID CELL MICROPORES
C
      TORTL=(TORT(N3,N2,N1)*DLYR(N,N3,N2,N1)
     2+TORT(N6,N5,N4)*DLYR(N,N6,N5,N4))
     3/(DLYR(N,N3,N2,N1)+DLYR(N,N6,N5,N4))
      DISPN=DISP(N,N6,N5,N4)*ABS(FLWM(M,N,N6,N5,N4)/AREA(N,N6,N5,N4))
      DIFOC=(OCSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFON=(ONSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOP=(OPSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOA=(OASGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNH=(ZNSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNO=(ZOSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFPO=(POSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFCS=(CLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFCQ=(CQSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOS=(OLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNG=(ZLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFN2=(ZVSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFHG=(HLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
C
C     DIFFUSIVE FLUXES BETWEEN CURRENT AND ADJACENT GRID CELL
C     MICROPORES
C
      DO 9805 K=0,4
      DFVOC(K)=DIFOC*(COQC1(K)-COQC2(K))
      DFVON(K)=DIFON*(COQN1(K)-COQN2(K))
      DFVOP(K)=DIFOP*(COQP1(K)-COQP2(K))
      DFVOA(K)=DIFOA*(COQA1(K)-COQA2(K))
9805  CONTINUE
      DFVCOS=DIFCS*(CCO2S1-CCO2S2)
      DFVCHS=DIFCQ*(CCH4S1-CCH4S2)
      DFVOXS=DIFOS*(COXYS1-COXYS2)
      DFVNGS=DIFNG*(CZ2GS1-CZ2GS2)
      DFVN2S=DIFN2*(CZ2OS1-CZ2OS2)
      DFVHGS=DIFHG*(CH2GS1-CH2GS2)
      DFVNH4=DIFNH*(CNH4S1-CNH4S2)*AMIN1(VLNH4(N3,N2,N1)
     2,VLNH4(N6,N5,N4))
      DFVNH3=DIFNH*(CNH3S1-CNH3S2)*AMIN1(VLNH4(N3,N2,N1)
     2,VLNH4(N6,N5,N4))
      DFVNO3=DIFNO*(CNO3S1-CNO3S2)*AMIN1(VLNO3(N3,N2,N1)
     2,VLNO3(N6,N5,N4))
      DFVNO2=DIFNO*(CNO2S1-CNO2S2)*AMIN1(VLNO3(N3,N2,N1)
     2,VLNO3(N6,N5,N4))
      DFVPO4=DIFPO*(CPO4S1-CPO4S2)*AMIN1(VLPO4(N3,N2,N1)
     2,VLPO4(N6,N5,N4))
      DFVN4B=DIFNH*(CNH4B1-CNH4B2)*AMIN1(VLNHB(N3,N2,N1)
     2,VLNHB(N6,N5,N4))
      DFVN3B=DIFNH*(CNH3B1-CNH3B2)*AMIN1(VLNHB(N3,N2,N1)
     2,VLNHB(N6,N5,N4))
      DFVNOB=DIFNO*(CNO3B1-CNO3B2)*AMIN1(VLNOB(N3,N2,N1)
     2,VLNOB(N6,N5,N4))
      DFVN2B=DIFNO*(CNO2B1-CNO2B2)*AMIN1(VLNOB(N3,N2,N1)
     2,VLNOB(N6,N5,N4))
      DFVPOB=DIFPO*(CPO4B1-CPO4B2)*AMIN1(VLPOB(N3,N2,N1)
     2,VLPOB(N6,N5,N4))
      ELSE
      DO 9905 K=0,4
      DFVOC(K)=0.0
      DFVON(K)=0.0
      DFVOP(K)=0.0
      DFVOA(K)=0.0
9905  CONTINUE
      DFVCOS=0.0
      DFVCHS=0.0
      DFVOXS=0.0
      DFVNGS=0.0
      DFVN2S=0.0
      DFVHGS=0.0
      DFVNH4=0.0
      DFVNH3=0.0
      DFVNO3=0.0
      DFVNO2=0.0
      DFVPO4=0.0
      DFVN4B=0.0
      DFVN3B=0.0
      DFVNOB=0.0
      DFVN2B=0.0
      DFVPOB=0.0
      ENDIF
C
C     SOLUTE TRANSPORT IN MACROPORES
C
      IF(FLWHM(M,N,N6,N5,N4).GT.0.0)THEN
C
C     IF MACROPORE WATER FLUX FROM 'WATSUB' IS FROM CURRENT TO
C     ADJACENT GRID CELL THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MACROPORE SOLUTE CONCENTRATIONS IN CURRENT
C     GRID CELL
C
      IF(VOLWHM(M,N3,N2,N1).GT.ZEROS(N2,N1))THEN
      VFLW=AMAX1(0.0,AMIN1(FVFLW,FLWHM(M,N,N6,N5,N4)
     2/VOLWHM(M,N3,N2,N1)))
      ELSE
      VFLW=0.0
      ENDIF
C
C     ACCOUNT FOR OVERLAND TRANSPORT IN THE SURFACE SOIL LAYER
C
      IF(N.EQ.3.AND.VOLAH(N6,N5,N4).GT.VOLWHM(M,N6,N5,N4))THEN
      DO 9800 K=0,4
      RFHOC(K)=VFLW*AMAX1(0.0,(OQCH2(K,N3,N2,N1)
     2-AMIN1(0.0,ROCFXS(K,NU(N2,N1),N2,N1))))
      RFHON(K)=VFLW*AMAX1(0.0,(OQNH2(K,N3,N2,N1)
     2-AMIN1(0.0,RONFXS(K,NU(N2,N1),N2,N1))))
      RFHOP(K)=VFLW*AMAX1(0.0,(OQPH2(K,N3,N2,N1)
     2-AMIN1(0.0,ROPFXS(K,NU(N2,N1),N2,N1))))
      RFHOA(K)=VFLW*AMAX1(0.0,(OQAH2(K,N3,N2,N1)
     2-AMIN1(0.0,ROAFXS(K,NU(N2,N1),N2,N1))))
9800  CONTINUE
      RFHCOS=VFLW*AMAX1(0.0,(CO2SH2(N3,N2,N1)
     2-AMIN1(0.0,RCOFXS(NU(N2,N1),N2,N1))))
      RFHCHS=VFLW*AMAX1(0.0,(CH4SH2(N3,N2,N1)
     2-AMIN1(0.0,RCHFXS(NU(N2,N1),N2,N1))))
      RFHOXS=VFLW*AMAX1(0.0,(OXYSH2(N3,N2,N1)
     2-AMIN1(0.0,ROXFXS(NU(N2,N1),N2,N1))))
      RFHNGS=VFLW*AMAX1(0.0,(Z2GSH2(N3,N2,N1)
     2-AMIN1(0.0,RNGFXS(NU(N2,N1),N2,N1))))
      RFHN2S=VFLW*AMAX1(0.0,(Z2OSH2(N3,N2,N1)
     2-AMIN1(0.0,RN2FXS(NU(N2,N1),N2,N1))))
      RFHHGS=VFLW*AMAX1(0.0,(H2GSH2(N3,N2,N1)
     2-AMIN1(0.0,RHGFXS(NU(N2,N1),N2,N1))))
      RFHNH4=VFLW*AMAX1(0.0,(ZNH4H2(N3,N2,N1)
     2-AMIN1(0.0,RN4FXW(NU(N2,N1),N2,N1)*VLNH4(N3,N2,N1))))
     3*VLNH4(N6,N5,N4)
      RFHNH3=VFLW*AMAX1(0.0,(ZNH3H2(N3,N2,N1)
     2-AMIN1(0.0,RN3FXW(NU(N2,N1),N2,N1)*VLNH4(N3,N2,N1))))
     3*VLNH4(N6,N5,N4)
      RFHNO3=VFLW*AMAX1(0.0,(ZNO3H2(N3,N2,N1)
     2-AMIN1(0.0,RNOFXW(NU(N2,N1),N2,N1)*VLNO3(N3,N2,N1))))
     3*VLNO3(N6,N5,N4)
      RFHNO2=VFLW*AMAX1(0.0,(ZNO2H2(N3,N2,N1)
     2-AMIN1(0.0,RNXFXS(NU(N2,N1),N2,N1)*VLNO3(N3,N2,N1))))
     3*VLNO3(N6,N5,N4)
      RFHPO4=VFLW*AMAX1(0.0,(H2P4H2(N3,N2,N1)
     2-AMIN1(0.0,RH2PXS(NU(N2,N1),N2,N1)*VLPO4(N3,N2,N1))))
     3*VLPO4(N6,N5,N4)
      RFHN4B=VFLW*AMAX1(0.0,(ZN4BH2(N3,N2,N1)
     2-AMIN1(0.0,RN4FXB(NU(N2,N1),N2,N1)*VLNHB(N3,N2,N1))))
     3*VLNHB(N6,N5,N4)
      RFHN3B=VFLW*AMAX1(0.0,(ZN3BH2(N3,N2,N1)
     2-AMIN1(0.0,RN3FXB(NU(N2,N1),N2,N1)*VLNHB(N3,N2,N1))))
     3*VLNHB(N6,N5,N4)
      RFHNOB=VFLW*AMAX1(0.0,(ZNOBH2(N3,N2,N1)
     2-AMIN1(0.0,RNOFXB(NU(N2,N1),N2,N1)*VLNOB(N3,N2,N1))))
     3*VLNOB(N6,N5,N4)
      RFHN2B=VFLW*AMAX1(0.0,(ZN2BH2(N3,N2,N1)
     2-AMIN1(0.0,RNXFXB(NU(N2,N1),N2,N1)*VLNOB(N3,N2,N1))))
     3*VLNOB(N6,N5,N4)
      RFHPOB=VFLW*AMAX1(0.0,(H2PBH2(N3,N2,N1)
     2-AMIN1(0.0,RH2BXB(NU(N2,N1),N2,N1)*VLPOB(N3,N2,N1))))
     3*VLPOB(N6,N5,N4)
C
C     IF NOT IN THE SURFACE LAYER
C
      ELSE
      DO 9850 K=0,4
      RFHOC(K)=VFLW*AMAX1(0.0,OQCH2(K,N3,N2,N1))
      RFHON(K)=VFLW*AMAX1(0.0,OQNH2(K,N3,N2,N1))
      RFHOP(K)=VFLW*AMAX1(0.0,OQPH2(K,N3,N2,N1))
      RFHOA(K)=VFLW*AMAX1(0.0,OQAH2(K,N3,N2,N1))
9850  CONTINUE
      RFHCOS=VFLW*AMAX1(0.0,CO2SH2(N3,N2,N1))
      RFHCHS=VFLW*AMAX1(0.0,CH4SH2(N3,N2,N1))
      RFHOXS=VFLW*AMAX1(0.0,OXYSH2(N3,N2,N1))
      RFHNGS=VFLW*AMAX1(0.0,Z2GSH2(N3,N2,N1))
      RFHN2S=VFLW*AMAX1(0.0,Z2OSH2(N3,N2,N1))
      RFHHGS=VFLW*AMAX1(0.0,H2GSH2(N3,N2,N1))
      RFHNH4=VFLW*AMAX1(0.0,ZNH4H2(N3,N2,N1))*VLNH4(N6,N5,N4)
      RFHNH3=VFLW*AMAX1(0.0,ZNH3H2(N3,N2,N1))*VLNH4(N6,N5,N4)
      RFHNO3=VFLW*AMAX1(0.0,ZNO3H2(N3,N2,N1))*VLNO3(N6,N5,N4)
      RFHNO2=VFLW*AMAX1(0.0,ZNO2H2(N3,N2,N1))*VLNO3(N6,N5,N4)
      RFHPO4=VFLW*AMAX1(0.0,H2P4H2(N3,N2,N1))*VLPO4(N6,N5,N4)
      RFHN4B=VFLW*AMAX1(0.0,ZN4BH2(N3,N2,N1))*VLNHB(N6,N5,N4)
      RFHN3B=VFLW*AMAX1(0.0,ZN3BH2(N3,N2,N1))*VLNHB(N6,N5,N4)
      RFHNOB=VFLW*AMAX1(0.0,ZNOBH2(N3,N2,N1))*VLNOB(N6,N5,N4)
      RFHN2B=VFLW*AMAX1(0.0,ZN2BH2(N3,N2,N1))*VLNOB(N6,N5,N4)
      RFHPOB=VFLW*AMAX1(0.0,H2PBH2(N3,N2,N1))*VLPOB(N6,N5,N4)
      ENDIF
      ELSEIF(FLWHM(M,N,N6,N5,N4).LT.0.0)THEN
C
C     IF MACROPORE WATER FLUX FROM 'WATSUB' IS FROM ADJACENT TO
C     CURRENT GRID CELL THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MACROPORE SOLUTE CONCENTRATIONS IN ADJACENT
C     GRID CELL
C
      IF(VOLWHM(M,N6,N5,N4).GT.ZEROS(N5,N4))THEN
      VFLW=AMIN1(0.0,AMAX1(-FVFLW,FLWHM(M,N,N6,N5,N4)
     2/VOLWHM(M,N6,N5,N4)))
      ELSE
      VFLW=-1.0
      ENDIF
      DO 9665 K=0,4
      RFHOC(K)=VFLW*AMAX1(0.0,OQCH2(K,N6,N5,N4))
      RFHON(K)=VFLW*AMAX1(0.0,OQNH2(K,N6,N5,N4))
      RFHOP(K)=VFLW*AMAX1(0.0,OQPH2(K,N6,N5,N4))
      RFHOA(K)=VFLW*AMAX1(0.0,OQAH2(K,N6,N5,N4))
9665  CONTINUE
      RFHCOS=VFLW*AMAX1(0.0,CO2SH2(N6,N5,N4))
      RFHCHS=VFLW*AMAX1(0.0,CH4SH2(N6,N5,N4))
      RFHOXS=VFLW*AMAX1(0.0,OXYSH2(N6,N5,N4))
      RFHNGS=VFLW*AMAX1(0.0,Z2GSH2(N6,N5,N4))
      RFHN2S=VFLW*AMAX1(0.0,Z2OSH2(N6,N5,N4))
      RFHHGS=VFLW*AMAX1(0.0,H2GSH2(N6,N5,N4))
      RFHNH4=VFLW*AMAX1(0.0,ZNH4H2(N6,N5,N4))*VLNH4(N6,N5,N4)
      RFHNH3=VFLW*AMAX1(0.0,ZNH3H2(N6,N5,N4))*VLNH4(N6,N5,N4)
      RFHNO3=VFLW*AMAX1(0.0,ZNO3H2(N6,N5,N4))*VLNO3(N6,N5,N4)
      RFHNO2=VFLW*AMAX1(0.0,ZNO2H2(N6,N5,N4))*VLNO3(N6,N5,N4)
      RFHPO4=VFLW*AMAX1(0.0,H2P4H2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFHN4B=VFLW*AMAX1(0.0,ZN4BH2(N6,N5,N4))*VLNHB(N6,N5,N4)
      RFHN3B=VFLW*AMAX1(0.0,ZN3BH2(N6,N5,N4))*VLNHB(N6,N5,N4)
      RFHNOB=VFLW*AMAX1(0.0,ZNOBH2(N6,N5,N4))*VLNOB(N6,N5,N4)
      RFHN2B=VFLW*AMAX1(0.0,ZN2BH2(N6,N5,N4))*VLNOB(N6,N5,N4)
      RFHPOB=VFLW*AMAX1(0.0,H2PBH2(N6,N5,N4))*VLPOB(N6,N5,N4)
      ELSE
C
C     NO MACROPORE FLUX
C
      DO 9795 K=0,4
      RFHOC(K)=0.0
      RFHON(K)=0.0
      RFHOP(K)=0.0
      RFHOA(K)=0.0
9795  CONTINUE
      RFHCOS=0.0
      RFHCHS=0.0
      RFHOXS=0.0
      RFHNGS=0.0
      RFHN2S=0.0
      RFHHGS=0.0
      RFHNH4=0.0
      RFHNH3=0.0
      RFHNO3=0.0
      RFHNO2=0.0
      RFHPO4=0.0
      RFHN4B=0.0
      RFHN3B=0.0
      RFHNOB=0.0
      RFHN2B=0.0
      RFHPOB=0.0
      ENDIF
C
C     DIFFUSIVE FLUXES OF GASES AND SOLUTES BETWEEN CURRENT AND
C     ADJACENT GRID CELL MACROPORES FROM AQUEOUS DIFFUSIVITIES
C     AND CONCENTRATION DIFFERENCES
C
      IF(VOLWHM(M,N3,N2,N1).GT.THETY(N3,N2,N1)*VOLAH(N3,N2,N1)
     2.AND.VOLWHM(M,N6,N5,N4).GT.THETY(N6,N5,N4)*VOLAH(N6,N5,N4))THEN
C
C     MACROPORE CONCENTRATIONS IN CURRENT AND ADJACENT GRID CELLS
C
      DO 9790 K=0,4
      COQCH1(K)=AMAX1(0.0,OQCH2(K,N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      COQNH1(K)=AMAX1(0.0,OQNH2(K,N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      COQPH1(K)=AMAX1(0.0,OQPH2(K,N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      COQAH1(K)=AMAX1(0.0,OQAH2(K,N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      COQCH2(K)=AMAX1(0.0,OQCH2(K,N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      COQNH2(K)=AMAX1(0.0,OQNH2(K,N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      COQPH2(K)=AMAX1(0.0,OQPH2(K,N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      COQAH2(K)=AMAX1(0.0,OQAH2(K,N6,N5,N4)/VOLWHM(M,N6,N5,N4))
9790  CONTINUE
      CCO2SH1=AMAX1(0.0,CO2SH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CCH4SH1=AMAX1(0.0,CH4SH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      COXYSH1=AMAX1(0.0,OXYSH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CZ2GSH1=AMAX1(0.0,Z2GSH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CZ2OSH1=AMAX1(0.0,Z2OSH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CH2GSH1=AMAX1(0.0,H2GSH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      IF(VOLH4A.GT.ZEROS(N2,N1))THEN
      CNH4SH1=AMAX1(0.0,ZNH4H2(N3,N2,N1)/VOLH4A)
      CNH3SH1=AMAX1(0.0,ZNH3H2(N3,N2,N1)/VOLH4A)
      ELSE
      CNH4SH1=0.0
      CNH3SH1=0.0
      ENDIF
      IF(VOLH3A.GT.ZEROS(N2,N1))THEN
      CNO3SH1=AMAX1(0.0,ZNO3H2(N3,N2,N1)/VOLH3A)
      CNO2SH1=AMAX1(0.0,ZNO2H2(N3,N2,N1)/VOLH3A)
      ELSE
      CNO3SH1=0.0
      CNO2SH1=0.0
      ENDIF
      IF(VOLH2A.GT.ZEROS(N2,N1))THEN
      CPO4SH1=AMAX1(0.0,H2P4H2(N3,N2,N1)/VOLH2A)
      ELSE
      CPO4SH1=0.0
      ENDIF
      IF(VOLH4B.GT.ZEROS(N2,N1))THEN
      CNH4BH1=AMAX1(0.0,ZN4BH2(N3,N2,N1)/VOLH4B)
      CNH3BH1=AMAX1(0.0,ZN3BH2(N3,N2,N1)/VOLH4B)
      ELSE
      CNH4BH1=CNH4SH1
      CNH3BH1=CNH3SH1
      ENDIF
      IF(VOLH3B.GT.ZEROS(N2,N1))THEN
      CNO3BH1=AMAX1(0.0,ZNOBH2(N3,N2,N1)/VOLH3B)
      CNO2BH1=AMAX1(0.0,ZN2BH2(N3,N2,N1)/VOLH3B)
      ELSE
      CNO3BH1=CNO3SH1
      CNO2BH1=CNO2SH1
      ENDIF
      IF(VOLH2B.GT.ZEROS(N2,N1))THEN
      CPO4BH1=AMAX1(0.0,H2PBH2(N3,N2,N1)/VOLH2B)
      ELSE
      CPO4BH1=CPO4SH1
      ENDIF
      CCO2SH2=AMAX1(0.0,CO2SH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CCH4SH2=AMAX1(0.0,CH4SH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      COXYSH2=AMAX1(0.0,OXYSH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CZ2GSH2=AMAX1(0.0,Z2GSH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CZ2OSH2=AMAX1(0.0,Z2OSH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CH2GSH2=AMAX1(0.0,H2GSH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      VOLHMA=VOLWHM(M,N6,N5,N4)*VLNH4(N6,N5,N4)
      IF(VOLHMA.GT.ZEROS(N5,N4))THEN
      CNH4SH2=AMAX1(0.0,ZNH4H2(N6,N5,N4)/VOLHMA)
      CNH3SH2=AMAX1(0.0,ZNH3H2(N6,N5,N4)/VOLHMA)
      ELSE
      CNH4SH2=0.0
      CNH3SH2=0.0
      ENDIF
      VOLHOA=VOLWHM(M,N6,N5,N4)*VLNO3(N6,N5,N4)
      IF(VOLHOA.GT.ZEROS(N5,N4))THEN
      CNO3SH2=AMAX1(0.0,ZNO3H2(N6,N5,N4)/VOLHOA)
      CNO2SH2=AMAX1(0.0,ZNO2H2(N6,N5,N4)/VOLHOA)
      ELSE
      CNO3SH2=0.0
      CNO2SH2=0.0
      ENDIF
      VOLHPA=VOLWHM(M,N6,N5,N4)*VLPO4(N6,N5,N4)
      IF(VOLHPA.GT.ZEROS(N5,N4))THEN
      CPO4SH2=AMAX1(0.0,H2P4H2(N6,N5,N4)/VOLHPA)
      ELSE
      CPO4SH2=0.0
      ENDIF
      VOLHMB=VOLWHM(M,N6,N5,N4)*VLNHB(N6,N5,N4)
      IF(VOLHMB.GT.ZEROS(N5,N4))THEN
      CNH4BH2=AMAX1(0.0,ZN4BH2(N6,N5,N4)/VOLHMB)
      CNH3BH2=AMAX1(0.0,ZN3BH2(N6,N5,N4)/VOLHMB)
      ELSE
      CNH4BH2=CNH4SH2
      CNH3BH2=CNH3SH2
      ENDIF
      VOLHOB=VOLWHM(M,N6,N5,N4)*VLNOB(N6,N5,N4)
      IF(VOLHOB.GT.ZEROS(N5,N4))THEN
      CNO3BH2=AMAX1(0.0,ZNOBH2(N6,N5,N4)/VOLHOB)
      CNO2BH2=AMAX1(0.0,ZN2BH2(N6,N5,N4)/VOLHOB)
      ELSE
      CNO3BH2=CNO3SH2
      CNO2BH2=CNO2SH2
      ENDIF
      VOLHPB=VOLWHM(M,N6,N5,N4)*VLPOB(N6,N5,N4)
      IF(VOLHPB.GT.ZEROS(N5,N4))THEN
      CPO4BH2=AMAX1(0.0,H2PBH2(N6,N5,N4)/VOLHPB)
      ELSE
      CPO4BH2=CPO4SH2
      ENDIF
C
C     DIFFUSIVITIES IN CURRENT AND ADJACENT GRID CELL MACROPORES
C
      TORTL=(TORTH(N3,N2,N1)*DLYR(N,N3,N2,N1)
     2+TORTH(N6,N5,N4)*DLYR(N,N6,N5,N4))
     3/(DLYR(N,N3,N2,N1)+DLYR(N,N6,N5,N4))
      DISPN=DISP(N,N6,N5,N4)*ABS(FLWHM(M,N,N6,N5,N4)/AREA(N,N6,N5,N4))
      DIFOC=(OCSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFON=(ONSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOP=(OPSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOA=(OASGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNH=(ZNSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNO=(ZOSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFPO=(POSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFCS=(CLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFCQ=(CQSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOS=(OLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNG=(ZLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFN2=(ZVSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFHG=(HLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
C
C     DIFFUSIVE FLUXES BETWEEN CURRENT AND ADJACENT GRID CELL
C     MACROPORES
C
      DO 9785 K=0,4
      DFHOC(K)=DIFOC*(COQCH1(K)-COQCH2(K))
      DFHON(K)=DIFON*(COQNH1(K)-COQNH2(K))
      DFHOP(K)=DIFOP*(COQPH1(K)-COQPH2(K))
      DFHOA(K)=DIFOA*(COQAH1(K)-COQAH2(K))
9785  CONTINUE
      DFHCOS=DIFCS*(CCO2SH1-CCO2SH2)
      DFHCHS=DIFCQ*(CCH4SH1-CCH4SH2)
      DFHOXS=DIFOS*(COXYSH1-COXYSH2)
      DFHNGS=DIFNG*(CZ2GSH1-CZ2GSH2)
      DFHN2S=DIFN2*(CZ2OSH1-CZ2OSH2)
      DFHHGS=DIFNH*(CH2GSH1-CH2GSH2)
      DFHNH4=DIFNH*(CNH4SH1-CNH4SH2)*AMIN1(VLNH4(N3,N2,N1)
     2,VLNH4(N6,N5,N4))
      DFHNH3=DIFNH*(CNH3SH1-CNH3SH2)*AMIN1(VLNH4(N3,N2,N1)
     2,VLNH4(N6,N5,N4))
      DFHNO3=DIFNO*(CNO3SH1-CNO3SH2)*AMIN1(VLNO3(N3,N2,N1)
     2,VLNO3(N6,N5,N4))
      DFHNO2=DIFNO*(CNO2SH1-CNO2SH2)*AMIN1(VLNO3(N3,N2,N1)
     2,VLNO3(N6,N5,N4))
      DFHPO4=DIFPO*(CPO4SH1-CPO4SH2)*AMIN1(VLPO4(N3,N2,N1)
     2,VLPO4(N6,N5,N4))
      DFHN4B=DIFNH*(CNH4BH1-CNH4BH2)*AMIN1(VLNHB(N3,N2,N1)
     2,VLNHB(N6,N5,N4))
      DFHN3B=DIFNH*(CNH3BH1-CNH3BH2)*AMIN1(VLNHB(N3,N2,N1)
     2,VLNHB(N6,N5,N4))
      DFHNOB=DIFNO*(CNO3BH1-CNO3BH2)*AMIN1(VLNOB(N3,N2,N1)
     2,VLNOB(N6,N5,N4))
      DFHN2B=DIFNO*(CNO2BH1-CNO2BH2)*AMIN1(VLNOB(N3,N2,N1)
     2,VLNOB(N6,N5,N4))
      DFHPOB=DIFPO*(CPO4BH1-CPO4BH2)*AMIN1(VLPOB(N3,N2,N1)
     2,VLPOB(N6,N5,N4))
      ELSE
      DO 9780 K=0,4
      DFHOC(K)=0.0
      DFHON(K)=0.0
      DFHOP(K)=0.0
      DFHOA(K)=0.0
9780  CONTINUE
      DFHCOS=0.0
      DFHCHS=0.0
      DFHOXS=0.0
      DFHNGS=0.0
      DFHN2S=0.0
      DFHHGS=0.0
      DFHNH4=0.0
      DFHNH3=0.0
      DFHNO3=0.0
      DFHNO2=0.0
      DFHPO4=0.0
      DFHN4B=0.0
      DFHN3B=0.0
      DFHNOB=0.0
      DFHN2B=0.0
      DFHPOB=0.0
      ENDIF
C
C     TOTAL MICROPORE AND MACROPORE SOLUTE TRANSPORT FLUXES BETWEEN
C     ADJACENT GRID CELLS = CONVECTIVE + DIFFUSIVE FLUXES
C
      DO 9765 K=0,4
      ROCFLS(K,N,N6,N5,N4)=RFLOC(K)+DFVOC(K)
      RONFLS(K,N,N6,N5,N4)=RFLON(K)+DFVON(K)
      ROPFLS(K,N,N6,N5,N4)=RFLOP(K)+DFVOP(K)
      ROAFLS(K,N,N6,N5,N4)=RFLOA(K)+DFVOA(K)
      ROCFHS(K,N,N6,N5,N4)=RFHOC(K)+DFHOC(K)
      RONFHS(K,N,N6,N5,N4)=RFHON(K)+DFHON(K)
      ROPFHS(K,N,N6,N5,N4)=RFHOP(K)+DFHOP(K)
      ROAFHS(K,N,N6,N5,N4)=RFHOA(K)+DFHOA(K)
9765  CONTINUE
      RCOFLS(N,N6,N5,N4)=RFLCOS+DFVCOS
      RCHFLS(N,N6,N5,N4)=RFLCHS+DFVCHS
      ROXFLS(N,N6,N5,N4)=RFLOXS+DFVOXS
      RNGFLS(N,N6,N5,N4)=RFLNGS+DFVNGS
      RN2FLS(N,N6,N5,N4)=RFLN2S+DFVN2S
      RHGFLS(N,N6,N5,N4)=RFLHGS+DFVHGS
      RN4FLW(N,N6,N5,N4)=RFLNH4+DFVNH4
      RN3FLW(N,N6,N5,N4)=RFLNH3+DFVNH3
      RNOFLW(N,N6,N5,N4)=RFLNO3+DFVNO3
      RNXFLS(N,N6,N5,N4)=RFLNO2+DFVNO2
      RH2PFS(N,N6,N5,N4)=RFLPO4+DFVPO4
      RN4FLB(N,N6,N5,N4)=RFLN4B+DFVN4B
      RN3FLB(N,N6,N5,N4)=RFLN3B+DFVN3B
      RNOFLB(N,N6,N5,N4)=RFLNOB+DFVNOB
      RNXFLB(N,N6,N5,N4)=RFLN2B+DFVN2B
      RH2BFB(N,N6,N5,N4)=RFLPOB+DFVPOB
      RCOFHS(N,N6,N5,N4)=RFHCOS+DFHCOS
      RCHFHS(N,N6,N5,N4)=RFHCHS+DFHCHS
      ROXFHS(N,N6,N5,N4)=RFHOXS+DFHOXS
      RNGFHS(N,N6,N5,N4)=RFHNGS+DFHNGS
      RN2FHS(N,N6,N5,N4)=RFHN2S+DFHN2S
      RHGFHS(N,N6,N5,N4)=RFHHGS+DFHHGS
      RN4FHW(N,N6,N5,N4)=RFHNH4+DFHNH4
      RN3FHW(N,N6,N5,N4)=RFHNH3+DFHNH3
      RNOFHW(N,N6,N5,N4)=RFHNO3+DFHNO3
      RNXFHS(N,N6,N5,N4)=RFHNO2+DFHNO2
      RH2PHS(N,N6,N5,N4)=RFHPO4+DFHPO4
      RN4FHB(N,N6,N5,N4)=RFHN4B+DFHN4B
      RN3FHB(N,N6,N5,N4)=RFHN3B+DFHN3B
      RNOFHB(N,N6,N5,N4)=RFHNOB+DFHNOB
      RNXFHB(N,N6,N5,N4)=RFHN2B+DFHN2B
      RH2BHB(N,N6,N5,N4)=RFHPOB+DFHPOB
C     IF(M.NE.MX.AND.I.GE.180.AND.I.LE.200)THEN
C     WRITE(*,443)'DFVCO2',I,J,NX,NY,L,M,MM,N
C    2,RCOFLS(N,N6,N5,N4),RFLCOS,DFVCOS,DIFCS,CCO2S1,CCO2S2
C    3,CLSGL2(N6,N5,N4),TORTL,DISPN,XDPTH(N,N6,N5,N4)
C     WRITE(*,443)'RH2PFS',I,J,NX,NY,L,M,MM,N
C    2,RH2PFS(N,N6,N5,N4),RFLPO4,DFVPO4,DIFPO,CPO4S1,CPO4S2
C    3,VLPO4(N3,N2,N1),VLPO4(N6,N5,N4),VOLW2A,VOLWPA
C    4,H2PO42(N3,N2,N1),H2PO42(N6,N5,N4)
443   FORMAT(A8,8I4,20E12.4)
C     ENDIF
C
C     ACCUMULATE HOURLY FLUXES
C
      DO 9755 K=0,4
      XOCFLS(K,N,N6,N5,N4)=XOCFLS(K,N,N6,N5,N4)+ROCFLS(K,N,N6,N5,N4)
      XONFLS(K,N,N6,N5,N4)=XONFLS(K,N,N6,N5,N4)+RONFLS(K,N,N6,N5,N4)
      XOPFLS(K,N,N6,N5,N4)=XOPFLS(K,N,N6,N5,N4)+ROPFLS(K,N,N6,N5,N4)
      XOAFLS(K,N,N6,N5,N4)=XOAFLS(K,N,N6,N5,N4)+ROAFLS(K,N,N6,N5,N4)
      XOCFHS(K,N,N6,N5,N4)=XOCFHS(K,N,N6,N5,N4)+ROCFHS(K,N,N6,N5,N4)
      XONFHS(K,N,N6,N5,N4)=XONFHS(K,N,N6,N5,N4)+RONFHS(K,N,N6,N5,N4)
      XOPFHS(K,N,N6,N5,N4)=XOPFHS(K,N,N6,N5,N4)+ROPFHS(K,N,N6,N5,N4)
      XOAFHS(K,N,N6,N5,N4)=XOAFHS(K,N,N6,N5,N4)+ROAFHS(K,N,N6,N5,N4)
9755  CONTINUE
      XCOFLS(N,N6,N5,N4)=XCOFLS(N,N6,N5,N4)+RCOFLS(N,N6,N5,N4)
      XCHFLS(N,N6,N5,N4)=XCHFLS(N,N6,N5,N4)+RCHFLS(N,N6,N5,N4)
      XOXFLS(N,N6,N5,N4)=XOXFLS(N,N6,N5,N4)+ROXFLS(N,N6,N5,N4)
      XNGFLS(N,N6,N5,N4)=XNGFLS(N,N6,N5,N4)+RNGFLS(N,N6,N5,N4)
      XN2FLS(N,N6,N5,N4)=XN2FLS(N,N6,N5,N4)+RN2FLS(N,N6,N5,N4)
      XHGFLS(N,N6,N5,N4)=XHGFLS(N,N6,N5,N4)+RHGFLS(N,N6,N5,N4)
      XN4FLW(N,N6,N5,N4)=XN4FLW(N,N6,N5,N4)+RN4FLW(N,N6,N5,N4)
      XN3FLW(N,N6,N5,N4)=XN3FLW(N,N6,N5,N4)+RN3FLW(N,N6,N5,N4)
      XNOFLW(N,N6,N5,N4)=XNOFLW(N,N6,N5,N4)+RNOFLW(N,N6,N5,N4)
      XNXFLS(N,N6,N5,N4)=XNXFLS(N,N6,N5,N4)+RNXFLS(N,N6,N5,N4)
      XH2PFS(N,N6,N5,N4)=XH2PFS(N,N6,N5,N4)+RH2PFS(N,N6,N5,N4)
      XN4FLB(N,N6,N5,N4)=XN4FLB(N,N6,N5,N4)+RN4FLB(N,N6,N5,N4)
      XN3FLB(N,N6,N5,N4)=XN3FLB(N,N6,N5,N4)+RN3FLB(N,N6,N5,N4)
      XNOFLB(N,N6,N5,N4)=XNOFLB(N,N6,N5,N4)+RNOFLB(N,N6,N5,N4)
      XNXFLB(N,N6,N5,N4)=XNXFLB(N,N6,N5,N4)+RNXFLB(N,N6,N5,N4)
      XH2BFB(N,N6,N5,N4)=XH2BFB(N,N6,N5,N4)+RH2BFB(N,N6,N5,N4)
      XCOFHS(N,N6,N5,N4)=XCOFHS(N,N6,N5,N4)+RCOFHS(N,N6,N5,N4)
      XCHFHS(N,N6,N5,N4)=XCHFHS(N,N6,N5,N4)+RCHFHS(N,N6,N5,N4)
      XOXFHS(N,N6,N5,N4)=XOXFHS(N,N6,N5,N4)+ROXFHS(N,N6,N5,N4)
      XNGFHS(N,N6,N5,N4)=XNGFHS(N,N6,N5,N4)+RNGFHS(N,N6,N5,N4)
      XN2FHS(N,N6,N5,N4)=XN2FHS(N,N6,N5,N4)+RN2FHS(N,N6,N5,N4)
      XHGFHS(N,N6,N5,N4)=XHGFHS(N,N6,N5,N4)+RHGFHS(N,N6,N5,N4)
      XN4FHW(N,N6,N5,N4)=XN4FHW(N,N6,N5,N4)+RN4FHW(N,N6,N5,N4)
      XN3FHW(N,N6,N5,N4)=XN3FHW(N,N6,N5,N4)+RN3FHW(N,N6,N5,N4)
      XNOFHW(N,N6,N5,N4)=XNOFHW(N,N6,N5,N4)+RNOFHW(N,N6,N5,N4)
      XNXFHS(N,N6,N5,N4)=XNXFHS(N,N6,N5,N4)+RNXFHS(N,N6,N5,N4)
      XH2PHS(N,N6,N5,N4)=XH2PHS(N,N6,N5,N4)+RH2PHS(N,N6,N5,N4)
      XN4FHB(N,N6,N5,N4)=XN4FHB(N,N6,N5,N4)+RN4FHB(N,N6,N5,N4)
      XN3FHB(N,N6,N5,N4)=XN3FHB(N,N6,N5,N4)+RN3FHB(N,N6,N5,N4)
      XNOFHB(N,N6,N5,N4)=XNOFHB(N,N6,N5,N4)+RNOFHB(N,N6,N5,N4)
      XNXFHB(N,N6,N5,N4)=XNXFHB(N,N6,N5,N4)+RNXFHB(N,N6,N5,N4)
      XH2BHB(N,N6,N5,N4)=XH2BHB(N,N6,N5,N4)+RH2BHB(N,N6,N5,N4)
C
C     MACROPORE-MICROPORE SOLUTE EXCHANGE WITHIN SOIL
C     LAYER FROM WATER EXCHANGE IN 'WATSUB' AND
C     FROM MACROPORE OR MICROPORE SOLUTE CONCENTRATIONS
C
      IF(N.EQ.3)THEN
      IF(FINHM(M,N6,N5,N4).GT.0.0)THEN
C
C     MACROPORE TO MICROPORE TRANSFER
C
      IF(VOLWHM(M,N6,N5,N4).GT.ZEROS(N5,N4))THEN
      VFLW=AMAX1(0.0,AMIN1(FVFLW,FINHM(M,N6,N5,N4)
     2/VOLWHM(M,N6,N5,N4)))
      ELSE
      VFLW=0.0
      ENDIF
      DO 9970 K=0,4
      ROCFXS(K,N6,N5,N4)=VFLW*AMAX1(0.0,OQCH2(K,N6,N5,N4))
      RONFXS(K,N6,N5,N4)=VFLW*AMAX1(0.0,OQNH2(K,N6,N5,N4))
      ROPFXS(K,N6,N5,N4)=VFLW*AMAX1(0.0,OQPH2(K,N6,N5,N4))
      ROAFXS(K,N6,N5,N4)=VFLW*AMAX1(0.0,OQAH2(K,N6,N5,N4))
9970  CONTINUE
      RCOFXS(N6,N5,N4)=VFLW*AMAX1(0.0,CO2SH2(N6,N5,N4))
      RCHFXS(N6,N5,N4)=VFLW*AMAX1(0.0,CH4SH2(N6,N5,N4))
      ROXFXS(N6,N5,N4)=VFLW*AMAX1(0.0,OXYSH2(N6,N5,N4))
      RNGFXS(N6,N5,N4)=VFLW*AMAX1(0.0,Z2GSH2(N6,N5,N4))
      RN2FXS(N6,N5,N4)=VFLW*AMAX1(0.0,Z2OSH2(N6,N5,N4))
      RHGFXS(N6,N5,N4)=VFLW*AMAX1(0.0,H2GSH2(N6,N5,N4))
      RN4FXW(N6,N5,N4)=VFLW*AMAX1(0.0,ZNH4H2(N6,N5,N4))*VLNH4(N6,N5,N4)
      RN3FXW(N6,N5,N4)=VFLW*AMAX1(0.0,ZNH3H2(N6,N5,N4))*VLNH4(N6,N5,N4)
      RNOFXW(N6,N5,N4)=VFLW*AMAX1(0.0,ZNO3H2(N6,N5,N4))*VLNO3(N6,N5,N4)
      RNXFXS(N6,N5,N4)=VFLW*AMAX1(0.0,ZNO2H2(N6,N5,N4))*VLNO3(N6,N5,N4)
      RH2PXS(N6,N5,N4)=VFLW*AMAX1(0.0,H2P4H2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RN4FXB(N6,N5,N4)=VFLW*AMAX1(0.0,ZN4BH2(N6,N5,N4))*VLNHB(N6,N5,N4)
      RN3FXB(N6,N5,N4)=VFLW*AMAX1(0.0,ZN3BH2(N6,N5,N4))*VLNHB(N6,N5,N4)
      RNOFXB(N6,N5,N4)=VFLW*AMAX1(0.0,ZNOBH2(N6,N5,N4))*VLNOB(N6,N5,N4)
      RNXFXB(N6,N5,N4)=VFLW*AMAX1(0.0,ZN2BH2(N6,N5,N4))*VLNOB(N6,N5,N4)
      RH2BXB(N6,N5,N4)=VFLW*AMAX1(0.0,H2PBH2(N6,N5,N4))*VLPOB(N6,N5,N4)
C
C     MICROPORE TO MACROPORE TRANSFER
C
      ELSEIF(FINHM(M,N6,N5,N4).LT.0.0)THEN
      IF(VOLWM(M,N6,N5,N4).GT.ZEROS(N5,N4))THEN
      VFLW=AMIN1(0.0,AMAX1(-FVFLW,FINHM(M,N6,N5,N4)
     2/VOLWM(M,N6,N5,N4)))
      ELSE
      VFLW=-1.0
      ENDIF
      DO 9965 K=0,4
      ROCFXS(K,N6,N5,N4)=VFLW*AMAX1(0.0,OQC2(K,N6,N5,N4))
      RONFXS(K,N6,N5,N4)=VFLW*AMAX1(0.0,OQN2(K,N6,N5,N4))
      ROPFXS(K,N6,N5,N4)=VFLW*AMAX1(0.0,OQP2(K,N6,N5,N4))
      ROAFXS(K,N6,N5,N4)=VFLW*AMAX1(0.0,OQA2(K,N6,N5,N4))
9965  CONTINUE
      RCOFXS(N6,N5,N4)=VFLW*AMAX1(0.0,CO2S2(N6,N5,N4))
      RCHFXS(N6,N5,N4)=VFLW*AMAX1(0.0,CH4S2(N6,N5,N4))
      ROXFXS(N6,N5,N4)=VFLW*AMAX1(0.0,OXYS2(N6,N5,N4))
      RNGFXS(N6,N5,N4)=VFLW*AMAX1(0.0,Z2GS2(N6,N5,N4))
      RN2FXS(N6,N5,N4)=VFLW*AMAX1(0.0,Z2OS2(N6,N5,N4))
      RHGFXS(N6,N5,N4)=VFLW*AMAX1(0.0,H2GS2(N6,N5,N4))
      RN4FXW(N6,N5,N4)=VFLW*AMAX1(0.0,ZNH4S2(N6,N5,N4))*VLNH4(N6,N5,N4)
      RN3FXW(N6,N5,N4)=VFLW*AMAX1(0.0,ZN3S2(N6,N5,N4))*VLNH4(N6,N5,N4)
      RNOFXW(N6,N5,N4)=VFLW*AMAX1(0.0,ZNO3S2(N6,N5,N4))*VLNO3(N6,N5,N4)
      RNXFXS(N6,N5,N4)=VFLW*AMAX1(0.0,ZNO2S2(N6,N5,N4))*VLNO3(N6,N5,N4)
      RH2PXS(N6,N5,N4)=VFLW*AMAX1(0.0,H2PO42(N6,N5,N4))*VLPO4(N6,N5,N4)
      RN4FXB(N6,N5,N4)=VFLW*AMAX1(0.0,ZNH4B2(N6,N5,N4))*VLNHB(N6,N5,N4)
      RN3FXB(N6,N5,N4)=VFLW*AMAX1(0.0,ZNBS2(N6,N5,N4))*VLNHB(N6,N5,N4)
      RNOFXB(N6,N5,N4)=VFLW*AMAX1(0.0,ZNO3B2(N6,N5,N4))*VLNOB(N6,N5,N4)
      RNXFXB(N6,N5,N4)=VFLW*AMAX1(0.0,ZNO2B2(N6,N5,N4))*VLNOB(N6,N5,N4)
      RH2BXB(N6,N5,N4)=VFLW*AMAX1(0.0,H2POB2(N6,N5,N4))*VLPOB(N6,N5,N4)
      ELSE
C
C     NO MACROPORE TO MICROPORE TRANSFER
C
      DO 9960 K=0,4
      ROCFXS(K,N6,N5,N4)=0.0
      RONFXS(K,N6,N5,N4)=0.0
      ROPFXS(K,N6,N5,N4)=0.0
      ROAFXS(K,N6,N5,N4)=0.0
9960  CONTINUE
      RCOFXS(N6,N5,N4)=0.0
      RCHFXS(N6,N5,N4)=0.0
      ROXFXS(N6,N5,N4)=0.0
      RNGFXS(N6,N5,N4)=0.0
      RN2FXS(N6,N5,N4)=0.0
      RHGFXS(N6,N5,N4)=0.0
      RN4FXW(N6,N5,N4)=0.0
      RN3FXW(N6,N5,N4)=0.0
      RNOFXW(N6,N5,N4)=0.0
      RNXFXS(N6,N5,N4)=0.0
      RH2PXS(N6,N5,N4)=0.0
      RN4FXB(N6,N5,N4)=0.0
      RN3FXB(N6,N5,N4)=0.0
      RNOFXB(N6,N5,N4)=0.0
      RNXFXB(N6,N5,N4)=0.0
      RH2BXB(N6,N5,N4)=0.0
      ENDIF
C
C     ACCUMULATE HOURLY FLUXES
C
      DO 9945 K=0,4
      XOCFXS(K,N6,N5,N4)=XOCFXS(K,N6,N5,N4)+ROCFXS(K,N6,N5,N4)
      XONFXS(K,N6,N5,N4)=XONFXS(K,N6,N5,N4)+RONFXS(K,N6,N5,N4)
      XOPFXS(K,N6,N5,N4)=XOPFXS(K,N6,N5,N4)+ROPFXS(K,N6,N5,N4)
      XOAFXS(K,N6,N5,N4)=XOAFXS(K,N6,N5,N4)+ROAFXS(K,N6,N5,N4)
9945  CONTINUE
      XCOFXS(N6,N5,N4)=XCOFXS(N6,N5,N4)+RCOFXS(N6,N5,N4)
      XCHFXS(N6,N5,N4)=XCHFXS(N6,N5,N4)+RCHFXS(N6,N5,N4)
      XOXFXS(N6,N5,N4)=XOXFXS(N6,N5,N4)+ROXFXS(N6,N5,N4)
      XNGFXS(N6,N5,N4)=XNGFXS(N6,N5,N4)+RNGFXS(N6,N5,N4)
      XN2FXS(N6,N5,N4)=XN2FXS(N6,N5,N4)+RN2FXS(N6,N5,N4)
      XHGFXS(N6,N5,N4)=XHGFXS(N6,N5,N4)+RHGFXS(N6,N5,N4)
      XN4FXW(N6,N5,N4)=XN4FXW(N6,N5,N4)+RN4FXW(N6,N5,N4)
      XN3FXW(N6,N5,N4)=XN3FXW(N6,N5,N4)+RN3FXW(N6,N5,N4)
      XNOFXW(N6,N5,N4)=XNOFXW(N6,N5,N4)+RNOFXW(N6,N5,N4)
      XNXFXS(N6,N5,N4)=XNXFXS(N6,N5,N4)+RNXFXS(N6,N5,N4)
      XH2PXS(N6,N5,N4)=XH2PXS(N6,N5,N4)+RH2PXS(N6,N5,N4)
      XN4FXB(N6,N5,N4)=XN4FXB(N6,N5,N4)+RN4FXB(N6,N5,N4)
      XN3FXB(N6,N5,N4)=XN3FXB(N6,N5,N4)+RN3FXB(N6,N5,N4)
      XNOFXB(N6,N5,N4)=XNOFXB(N6,N5,N4)+RNOFXB(N6,N5,N4)
      XNXFXB(N6,N5,N4)=XNXFXB(N6,N5,N4)+RNXFXB(N6,N5,N4)
      XH2BXB(N6,N5,N4)=XH2BXB(N6,N5,N4)+RH2BXB(N6,N5,N4)
      ENDIF
      ENDIF
C
C     GASEOUS TRANSPORT FROM GASEOUS DIFFUSIVITY AND CONCENTRATION
C     DIFFERENCES BETWEEN ADJACENT GRID CELLS
C
C
C     GASEOUS DIFFUSIVITIES
C
      IF(THETPM(M,N3,N2,N1).GT.THETX
     2.AND.THETPM(M,N6,N5,N4).GT.THETX
     3.AND.VOLPM(M,N3,N2,N1).GT.ZEROS(N2,N1)
     4.AND.VOLPM(M,N6,N5,N4).GT.ZEROS(N5,N4))THEN
      DFLG2=2.0*AMAX1(0.0,THETPM(M,N3,N2,N1))**2/POROQ(N3,N2,N1)
     2*AREA(N,N3,N2,N1)/DLYR(N,N3,N2,N1)
      DFLGL=2.0*AMAX1(0.0,THETPM(M,N6,N5,N4))**2/POROQ(N6,N5,N4)
     2*AREA(N,N6,N5,N4)/DLYR(N,N6,N5,N4)
      CNDC1=DFLG2*CGSGL2(N3,N2,N1)
      CND41=DFLG2*CHSGL2(N3,N2,N1)
      CNDO1=DFLG2*OGSGL2(N3,N2,N1)
      CNDG1=DFLG2*ZGSGL2(N3,N2,N1)
      CND21=DFLG2*Z2SGL2(N3,N2,N1)
      CNDH1=DFLG2*ZHSGL2(N3,N2,N1)
      CNHG1=DFLG2*HGSGL2(N3,N2,N1)
      CNDC2=DFLGL*CGSGL2(N6,N5,N4)
      CND42=DFLGL*CHSGL2(N6,N5,N4)
      CNDO2=DFLGL*OGSGL2(N6,N5,N4)
      CNDG2=DFLGL*ZGSGL2(N6,N5,N4)
      CND22=DFLGL*Z2SGL2(N6,N5,N4)
      CNDH2=DFLGL*ZHSGL2(N6,N5,N4)
      CNHG2=DFLGL*HGSGL2(N6,N5,N4)
C
C     GASOUS CONDUCTANCES
C
      DCO2G(N,N6,N5,N4)=(CNDC1*CNDC2)/(CNDC1+CNDC2)
      DCH4G(N,N6,N5,N4)=(CND41*CND42)/(CND41+CND42)
      DOXYG(N,N6,N5,N4)=(CNDO1*CNDO2)/(CNDO1+CNDO2)
      DZ2GG(N,N6,N5,N4)=(CNDG1*CNDG2)/(CNDG1+CNDG2)
      DZ2OG(N,N6,N5,N4)=(CND21*CND22)/(CND21+CND22)
      DNH3G(N,N6,N5,N4)=(CNDH1*CNDH2)/(CNDH1+CNDH2)
      DH2GG(N,N6,N5,N4)=(CNHG1*CNHG2)/(CNHG1+CNHG2)
C
C     GASEOUS CONCENTRATIONS FROM AIR-FILLED POROSITY
C     IN CURRENT AND ADJACENT GRID CELLS
C
      CCO2G1=AMAX1(0.0,CO2G2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      CCH4G1=AMAX1(0.0,CH4G2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      COXYG1=AMAX1(0.0,OXYG2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      CZ2GG1=AMAX1(0.0,Z2GG2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      CZ2OG1=AMAX1(0.0,Z2OG2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      CNH3G1=AMAX1(0.0,ZN3G2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      CH2GG1=AMAX1(0.0,H2GG2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      CCO2G2=AMAX1(0.0,CO2G2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
      CCH4G2=AMAX1(0.0,CH4G2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
      COXYG2=AMAX1(0.0,OXYG2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
      CZ2GG2=AMAX1(0.0,Z2GG2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
      CZ2OG2=AMAX1(0.0,Z2OG2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
      CNH3G2=AMAX1(0.0,ZN3G2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
      CH2GG2=AMAX1(0.0,H2GG2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
C
C     CONVECTIVE GAS TRANSFER DRIVEN BY SOIL WATER FLUXES
C     FROM 'WATSUB' AND GAS CONCENTRATIONS IN THE ADJACENT GRID CELLS
C     DEPENDING ON WATER FLUX DIRECTION
C
      DFVCOG=DCO2G(N,N6,N5,N4)*(CCO2G1-CCO2G2)
      DFVCHG=DCH4G(N,N6,N5,N4)*(CCH4G1-CCH4G2)
      DFVOXG=DOXYG(N,N6,N5,N4)*(COXYG1-COXYG2)
      DFVNGG=DZ2GG(N,N6,N5,N4)*(CZ2GG1-CZ2GG2)
      DFVN2G=DZ2OG(N,N6,N5,N4)*(CZ2OG1-CZ2OG2)
      DFVN3G=DNH3G(N,N6,N5,N4)*(CNH3G1-CNH3G2)
      DFVHGG=DH2GG(N,N6,N5,N4)*(CH2GG1-CH2GG2)
      IF(FLQM(N,N6,N5,N4).GT.0.0)THEN
      IF(VOLPM(M,N6,N5,N4).GT.ZEROS(N5,N4))THEN
      VFLW=-AMAX1(0.0,AMIN1(FVFLW,FLQM(N,N6,N5,N4)
     2/VOLPM(M,N6,N5,N4)))
      ELSE
      VFLW=0.0
      ENDIF
      RFLCOG=VFLW*AMAX1(0.0,CO2G2(N6,N5,N4))
      RFLCHG=VFLW*AMAX1(0.0,CH4G2(N6,N5,N4))
      RFLOXG=VFLW*AMAX1(0.0,OXYG2(N6,N5,N4))
      RFLNGG=VFLW*AMAX1(0.0,Z2GG2(N6,N5,N4))
      RFLN2G=VFLW*AMAX1(0.0,Z2OG2(N6,N5,N4))
      RFLN3G=VFLW*AMAX1(0.0,ZN3G2(N6,N5,N4))
      RFLH2G=VFLW*AMAX1(0.0,H2GG2(N6,N5,N4))
      ELSE
      IF(VOLPM(M,N3,N2,N1).GT.ZEROS(N2,N1))THEN
      VFLW=-AMIN1(0.0,AMAX1(-FVFLW,FLQM(N,N6,N5,N4)
     2/VOLPM(M,N3,N2,N1)))
      ELSE
      VFLW=0.0
      ENDIF
      RFLCOG=VFLW*AMAX1(0.0,CO2G2(N3,N2,N1))
      RFLCHG=VFLW*AMAX1(0.0,CH4G2(N3,N2,N1))
      RFLOXG=VFLW*AMAX1(0.0,OXYG2(N3,N2,N1))
      RFLNGG=VFLW*AMAX1(0.0,Z2GG2(N3,N2,N1))
      RFLN2G=VFLW*AMAX1(0.0,Z2OG2(N3,N2,N1))
      RFLN3G=VFLW*AMAX1(0.0,ZN3G2(N3,N2,N1))
      RFLH2G=VFLW*AMAX1(0.0,H2GG2(N3,N2,N1))
      ENDIF
C
C     SOIL GAS FLUX FROM DIFFERENCES
C     BETWEEN CURRENT AND EQUILIBRIUM
C     CONCENTRATIONS + CONVECTIVE FLUX
C
      RCOFLG(N,N6,N5,N4)=DFVCOG+RFLCOG 
      RCHFLG(N,N6,N5,N4)=DFVCHG+RFLCHG 
      ROXFLG(N,N6,N5,N4)=DFVOXG+RFLOXG 
      RNGFLG(N,N6,N5,N4)=DFVNGG+RFLNGG 
      RN2FLG(N,N6,N5,N4)=DFVN2G+RFLN2G 
      RN3FLG(N,N6,N5,N4)=DFVN3G+RFLN3G 
      RHGFLG(N,N6,N5,N4)=DFVHGG+RFLH2G 
C     IF(NX.EQ.3.AND.NY.EQ.2.AND.I.GE.190
C    2.AND.N3.EQ.NU(N2,N1))THEN
C     WRITE(*,3133)'ROXFL2',I,J,N1,N2,N3,M,MM,N,XOXFLG(N,N6,N5,N4)
C    2,ROXFLG(N,N6,N5,N4),DFVOXG,RFLOXG,COXYG1,COXYG2 
C    3,OXYG2(N3,N2,N1),OXYG2(N6,N5,N4)
C    4,FLQM(N,N6,N5,N4),VFLW,DOXYG(N,N6,N5,N4)
C    5,THETPM(M,N3,N2,N1),THETPM(M,N6,N5,N4)
C    5,VOLPM(M,N3,N2,N1),VOLPM(M,N6,N5,N4)
3133  FORMAT(A8,8I4,20E12.4)
C     ENDIF
C
C     ACCUMULATE HOURLY FLUXES
C
      XCOFLG(N,N6,N5,N4)=XCOFLG(N,N6,N5,N4)+RCOFLG(N,N6,N5,N4)
      XCHFLG(N,N6,N5,N4)=XCHFLG(N,N6,N5,N4)+RCHFLG(N,N6,N5,N4)
      XOXFLG(N,N6,N5,N4)=XOXFLG(N,N6,N5,N4)+ROXFLG(N,N6,N5,N4)
      XNGFLG(N,N6,N5,N4)=XNGFLG(N,N6,N5,N4)+RNGFLG(N,N6,N5,N4)
      XN2FLG(N,N6,N5,N4)=XN2FLG(N,N6,N5,N4)+RN2FLG(N,N6,N5,N4)
      XN3FLG(N,N6,N5,N4)=XN3FLG(N,N6,N5,N4)+RN3FLG(N,N6,N5,N4)
      XHGFLG(N,N6,N5,N4)=XHGFLG(N,N6,N5,N4)+RHGFLG(N,N6,N5,N4)
      ELSE
      RCOFLG(N,N6,N5,N4)=0.0
      RCHFLG(N,N6,N5,N4)=0.0
      ROXFLG(N,N6,N5,N4)=0.0
      RNGFLG(N,N6,N5,N4)=0.0
      RN2FLG(N,N6,N5,N4)=0.0
      RN3FLG(N,N6,N5,N4)=0.0
      RHGFLG(N,N6,N5,N4)=0.0
      ENDIF
C
C     VOLATILIZATION-DISSOLUTION OF GASES IN SOIL
C     LAYER FROM GASEOUS CONCENTRATIONS VS. THEIR AQUEOUS
C     EQUIVALENTS DEPENDING ON SOLUBILITY FROM 'HOUR1'
C     AND TRANSFER COEFFICIENT 'DFGS' FROM 'WATSUB'
C
      IF(N.EQ.3)THEN
      IF(THETPM(M,N6,N5,N4).GT.THETX)THEN
      RCODFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,CO2G2(N6,N5,N4))*VOLWCO(N6,N5,N4) 
     3-CO2S2(N6,N5,N4)*VOLPM(M,N6,N5,N4))
     4/(VOLWCO(N6,N5,N4)+VOLPM(M,N6,N5,N4))
      RCHDFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,CH4G2(N6,N5,N4))*VOLWCH(N6,N5,N4) 
     3-CH4S2(N6,N5,N4)*VOLPM(M,N6,N5,N4))
     4/(VOLWCH(N6,N5,N4)+VOLPM(M,N6,N5,N4))
      ROXDFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,OXYG2(N6,N5,N4))*VOLWOX(N6,N5,N4) 
     3-OXYS2(N6,N5,N4)*VOLPM(M,N6,N5,N4))
     4/(VOLWOX(N6,N5,N4)+VOLPM(M,N6,N5,N4))
      RNGDFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,Z2GG2(N6,N5,N4))*VOLWNG(N6,N5,N4) 
     3-Z2GS2(N6,N5,N4)*VOLPM(M,N6,N5,N4))
     4/(VOLWNG(N6,N5,N4)+VOLPM(M,N6,N5,N4))
      RN2DFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,Z2OG2(N6,N5,N4))*VOLWN2(N6,N5,N4) 
     3-Z2OS2(N6,N5,N4)*VOLPM(M,N6,N5,N4))
     3/(VOLWN2(N6,N5,N4)+VOLPM(M,N6,N5,N4))
      IF(VOLPMA(N6,N5,N4).GT.ZEROS(N5,N4)
     2.AND.VOLWXA(N6,N5,N4).GT.ZEROS(N5,N4))THEN
      ZN3S2A=ZN3G2(N6,N5,N4)*VLNH4(N6,N5,N4)
      RN3DFX=(AMAX1(ZEROS(N5,N4),ZN3S2A)*VOLWN3(N6,N5,N4)
     2-ZN3S2(N6,N5,N4)*VOLPMA(N6,N5,N4))
     3/(VOLWN3(N6,N5,N4)+VOLPMA(N6,N5,N4))
      IF(RN3DFX.GT.0.0)THEN
      RN3DFG(N6,N5,N4)=DFGAS*DFGS(M,N6,N5,N4)*RN3DFX
      ELSE
      RN3DFG(N6,N5,N4)=DFGAV*DFGS(M,N6,N5,N4)*RN3DFX
      ENDIF
      CNH3S0=AMAX1(0.0,(ZN3S2(N6,N5,N4)+RN3DFG(N6,N5,N4))
     2/VOLWXA(N6,N5,N4))
      CNH4S0=AMAX1(0.0,ZNH4S2(N6,N5,N4))
     2/VOLWXA(N6,N5,N4)
      RN34SQ(N6,N5,N4)=VOLWXA(N6,N5,N4)
     2*(CHY0(N6,N5,N4)*CNH3S0-DPN4*CNH4S0)/(DPN4+CHY0(N6,N5,N4))
      ELSE
      RN3DFG(N6,N5,N4)=0.0
      RN34SQ(N6,N5,N4)=0.0
      ENDIF
      IF(VOLPMB(N6,N5,N4).GT.ZEROS(N5,N4)
     2.AND.VOLWXB(N6,N5,N4).GT.ZEROS(N5,N4))THEN
      ZN3S2B=ZN3G2(N6,N5,N4)*VLNHB(N6,N5,N4)
      RN3DFX=(AMAX1(ZEROS(N5,N4),ZN3S2B)*VOLWNB(N6,N5,N4)
     2-ZNBS2(N6,N5,N4)*VOLPMB(N6,N5,N4))
     3/(VOLWNB(N6,N5,N4)+VOLPMB(N6,N5,N4))
      IF(RN3DFX.GT.0.0)THEN
      RNBDFG(N6,N5,N4)=DFGAS*DFGS(M,N6,N5,N4)*RN3DFX 
      ELSE
      RNBDFG(N6,N5,N4)=DFGAV*DFGS(M,N6,N5,N4)*RN3DFX 
      ENDIF
      CNH3B0=AMAX1(0.0,(ZNBS2(N6,N5,N4)+RNBDFG(N6,N5,N4))
     2/VOLWXB(N6,N5,N4))
      CNH4B0=AMAX1(0.0,ZNH4B2(N6,N5,N4))/VOLWXB(N6,N5,N4)
      RN34BQ(N6,N5,N4)=VOLWXB(N6,N5,N4)
     2*(CHY0(N6,N5,N4)*CNH3B0-DPN4*CNH4B0)/(DPN4+CHY0(N6,N5,N4))
      ELSE
      RNBDFG(N6,N5,N4)=0.0
      RN34BQ(N6,N5,N4)=0.0
      ENDIF
      RHGDFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,H2GG2(N6,N5,N4))*VOLWHG(N6,N5,N4) 
     3-H2GS2(N6,N5,N4)*VOLPM(M,N6,N5,N4))
     4/(VOLWHG(N6,N5,N4)+VOLPM(M,N6,N5,N4))
C     IF(I.EQ.187)THEN
C     WRITE(*,6666)'RN3DFG',I,J,M,MM,N4,N5,N6,RN3DFG(N6,N5,N4)
C    2,DFGS(M,N6,N5,N4),ZN3S2A,VOLWN3(N6,N5,N4),ZN3S2(N6,N5,N4)
C    3,VOLPMA(N6,N5,N4),RNBDFG(N6,N5,N4),ZN3S2B
C    4,VOLWNB(N6,N5,N4),ZNBS2(N6,N5,N4),VOLPMB(N6,N5,N4)
C     WRITE(*,6666)'RCHDFG',I,J,M,MM,N4,N5,N6,RCHDFG(N6,N5,N4)
C    2,DFGS(M,N6,N5,N4),CH4G2(N6,N5,N4),VOLWCH(N6,N5,N4)
C    3,CH4S2(N6,N5,N4),VOLWM(M,N6,N5,N4),THETPM(M,N6,N5,N4)
C    4,SCH4L(N6,N5,N4),XCHDFG(N6,N5,N4)
6666  FORMAT(A8,7I4,20E12.4)
C     ENDIF
C
C     ACCUMULATE HOURLY FLUXES
C
      XCODFG(N6,N5,N4)=XCODFG(N6,N5,N4)+RCODFG(N6,N5,N4)
      XCHDFG(N6,N5,N4)=XCHDFG(N6,N5,N4)+RCHDFG(N6,N5,N4)
      XOXDFG(N6,N5,N4)=XOXDFG(N6,N5,N4)+ROXDFG(N6,N5,N4)
      XNGDFG(N6,N5,N4)=XNGDFG(N6,N5,N4)+RNGDFG(N6,N5,N4)
      XN2DFG(N6,N5,N4)=XN2DFG(N6,N5,N4)+RN2DFG(N6,N5,N4)
      XN3DFG(N6,N5,N4)=XN3DFG(N6,N5,N4)+RN3DFG(N6,N5,N4)
      XN34SQ(N6,N5,N4)=XN34SQ(N6,N5,N4)+RN34SQ(N6,N5,N4)
      XNBDFG(N6,N5,N4)=XNBDFG(N6,N5,N4)+RNBDFG(N6,N5,N4)
      XN34BQ(N6,N5,N4)=XN34BQ(N6,N5,N4)+RN34BQ(N6,N5,N4)
      XHGDFG(N6,N5,N4)=XHGDFG(N6,N5,N4)+RHGDFG(N6,N5,N4)
      ELSE
      RCODFG(N6,N5,N4)=0.0
      RCHDFG(N6,N5,N4)=0.0
      ROXDFG(N6,N5,N4)=0.0
      RNGDFG(N6,N5,N4)=0.0
      RN2DFG(N6,N5,N4)=0.0
      RN3DFG(N6,N5,N4)=0.0
      RN34SQ(N6,N5,N4)=0.0
      RNBDFG(N6,N5,N4)=0.0
      RN34BQ(N6,N5,N4)=0.0
      RHGDFG(N6,N5,N4)=0.0
      ENDIF
      ENDIF
      ELSEIF(N.NE.3)THEN
      DCO2G(N,N6,N5,N4)=0.0
      DCH4G(N,N6,N5,N4)=0.0
      DOXYG(N,N6,N5,N4)=0.0
      DZ2GG(N,N6,N5,N4)=0.0
      DZ2OG(N,N6,N5,N4)=0.0
      DNH3G(N,N6,N5,N4)=0.0
      DH2GG(N,N6,N5,N4)=0.0
      DO 9750 K=0,4
      ROCFLS(K,N,N6,N5,N4)=0.0
      RONFLS(K,N,N6,N5,N4)=0.0
      ROPFLS(K,N,N6,N5,N4)=0.0
      ROAFLS(K,N,N6,N5,N4)=0.0
      ROCFHS(K,N,N6,N5,N4)=0.0
      RONFHS(K,N,N6,N5,N4)=0.0
      ROPFHS(K,N,N6,N5,N4)=0.0
      ROAFHS(K,N,N6,N5,N4)=0.0
9750  CONTINUE
      RCOFLS(N,N6,N5,N4)=0.0
      RCHFLS(N,N6,N5,N4)=0.0
      ROXFLS(N,N6,N5,N4)=0.0
      RNGFLS(N,N6,N5,N4)=0.0
      RN2FLS(N,N6,N5,N4)=0.0
      RHGFLS(N,N6,N5,N4)=0.0
      RN4FLW(N,N6,N5,N4)=0.0
      RN3FLW(N,N6,N5,N4)=0.0
      RNOFLW(N,N6,N5,N4)=0.0
      RNXFLS(N,N6,N5,N4)=0.0
      RH2PFS(N,N6,N5,N4)=0.0
      RN4FLB(N,N6,N5,N4)=0.0
      RN3FLB(N,N6,N5,N4)=0.0
      RNOFLB(N,N6,N5,N4)=0.0
      RNXFLB(N,N6,N5,N4)=0.0
      RH2BFB(N,N6,N5,N4)=0.0
      RCOFHS(N,N6,N5,N4)=0.0
      RCHFHS(N,N6,N5,N4)=0.0
      ROXFHS(N,N6,N5,N4)=0.0
      RNGFHS(N,N6,N5,N4)=0.0
      RN2FHS(N,N6,N5,N4)=0.0
      RHGFHS(N,N6,N5,N4)=0.0
      RN4FHW(N,N6,N5,N4)=0.0
      RN3FHW(N,N6,N5,N4)=0.0
      RNOFHW(N,N6,N5,N4)=0.0
      RNXFHS(N,N6,N5,N4)=0.0
      RH2PHS(N,N6,N5,N4)=0.0
      RN4FHB(N,N6,N5,N4)=0.0
      RN3FHB(N,N6,N5,N4)=0.0
      RNOFHB(N,N6,N5,N4)=0.0
      RNXFHB(N,N6,N5,N4)=0.0
      RH2BHB(N,N6,N5,N4)=0.0
      RCOFLG(N,N6,N5,N4)=0.0
      RCHFLG(N,N6,N5,N4)=0.0
      ROXFLG(N,N6,N5,N4)=0.0
      RNGFLG(N,N6,N5,N4)=0.0
      RN2FLG(N,N6,N5,N4)=0.0
      RN3FLG(N,N6,N5,N4)=0.0
      RHGFLG(N,N6,N5,N4)=0.0
      ENDIF
120   CONTINUE
C
C     CHECK FOR BUBBLING IF THE SUM OF ALL GASEOUS EQUIVALENT
C     PARTIAL CONCENTRATIONS EXCEEDS ATMOSPHERIC PRESSURE
C
      IF(N3.GE.NU(N2,N1).AND.M.NE.MX)THEN
      THETW1(N3,N2,N1)=AMAX1(0.0,VOLWM(M,N3,N2,N1)/VOLX(N3,N2,N1))
      IF(THETW1(N3,N2,N1).GT.THETY(N3,N2,N1).AND.IFLGB.EQ.0)THEN
      SCO2X=12.0*SCO2L(N3,N2,N1)
      SCH4X=12.0*SCH4L(N3,N2,N1)
      SOXYX=32.0*SOXYL(N3,N2,N1)
      SN2GX=28.0*SN2GL(N3,N2,N1)
      SN2OX=28.0*SN2OL(N3,N2,N1)
      SNH3X=14.0*SNH3L(N3,N2,N1)
      SH2GX=1.0*SH2GL(N3,N2,N1)
C
C     GASEOUS EQUIVALENT PARTIAL CONCENTRATIONS
C
      VCO2G2=CO2S2(N3,N2,N1)/SCO2X
      VCH4G2=CH4S2(N3,N2,N1)/SCH4X
      VOXYG2=OXYS2(N3,N2,N1)/SOXYX
      VZ2GG2=Z2GS2(N3,N2,N1)/SN2GX
      VZ2OG2=Z2OS2(N3,N2,N1)/SN2OX
      VNH3G2=ZN3S2(N3,N2,N1)/SNH3X
      VNHBG2=ZNBS2(N3,N2,N1)/SNH3X
      VH2GG2=H2GS2(N3,N2,N1)/SH2GX
C
C     GASEOUS EQUIVALENT ATMOSPHERIC CONCENTRATION
C
      VTATM=AMAX1(0.0,1.2194E+04*VOLWM(M,N3,N2,N1)/TKS(N3,N2,N1))
      VTGAS=VCO2G2+VCH4G2+VOXYG2+VZ2GG2+VZ2OG2+VNH3G2+VNHBG2+VH2GG2
C
C     PROPORTIONAL REMOVAL OF EXCESS AQUEOUS GASES
C
      IF(VTGAS.GT.VTATM)THEN
      DVTGAS=VTATM-VTGAS
      RCOBBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VCO2G2/VTGAS)*SCO2X
      RCHBBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VCH4G2/VTGAS)*SCH4X
      ROXBBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VOXYG2/VTGAS)*SOXYX
      RNGBBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VZ2GG2/VTGAS)*SN2GX
      RN2BBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VZ2OG2/VTGAS)*SN2OX
      RN3BBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VNH3G2/VTGAS)*SNH3X
      RNBBBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VNHBG2/VTGAS)*SNH3X
      RHGBBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VH2GG2/VTGAS)*SH2GX
C
C     ACCUMULATE HOURLY FLUXES
C
      XCOBBL(N3,N2,N1)=XCOBBL(N3,N2,N1)+RCOBBL(N3,N2,N1)
      XCHBBL(N3,N2,N1)=XCHBBL(N3,N2,N1)+RCHBBL(N3,N2,N1)
      XOXBBL(N3,N2,N1)=XOXBBL(N3,N2,N1)+ROXBBL(N3,N2,N1)
      XNGBBL(N3,N2,N1)=XNGBBL(N3,N2,N1)+RNGBBL(N3,N2,N1)
      XN2BBL(N3,N2,N1)=XN2BBL(N3,N2,N1)+RN2BBL(N3,N2,N1)
      XN3BBL(N3,N2,N1)=XN3BBL(N3,N2,N1)+RN3BBL(N3,N2,N1)
      XNBBBL(N3,N2,N1)=XNBBBL(N3,N2,N1)+RNBBBL(N3,N2,N1)
      XHGBBL(N3,N2,N1)=XHGBBL(N3,N2,N1)+RHGBBL(N3,N2,N1)
      ELSE
      RCOBBL(N3,N2,N1)=0.0
      RCHBBL(N3,N2,N1)=0.0
      ROXBBL(N3,N2,N1)=0.0
      RNGBBL(N3,N2,N1)=0.0
      RN2BBL(N3,N2,N1)=0.0
      RN3BBL(N3,N2,N1)=0.0
      RNBBBL(N3,N2,N1)=0.0
      RHGBBL(N3,N2,N1)=0.0
      ENDIF
      ELSE
      IFLGB=1
      RCOBBL(N3,N2,N1)=0.0
      RCHBBL(N3,N2,N1)=0.0
      ROXBBL(N3,N2,N1)=0.0
      RNGBBL(N3,N2,N1)=0.0
      RN2BBL(N3,N2,N1)=0.0
      RN3BBL(N3,N2,N1)=0.0
      RNBBBL(N3,N2,N1)=0.0
      RHGBBL(N3,N2,N1)=0.0
      ENDIF
C     IF(N1.EQ.2.AND.N2.EQ.1.AND.N3.EQ.13)THEN
C     WRITE(*,6688)'BUBBL',I,J,N1,N2,N3,M,MM,IFLGB,VTGAS,VTATM 
C    2,DVTGAS,SOXYX,VCO2G2,VCH4G2,VOXYG2,VZ2GG2,VZ2OG2
C    3,VNH3G2,VNHBG2,VH2GG2,ROXBBL(N3,N2,N1),XOXBBL(N3,N2,N1) 
C    4,OXYS2(N3,N2,N1),VOLWM(M,N3,N2,N1)
6688  FORMAT(A8,8I4,20E12.4)
C     ENDIF
      ENDIF
125   CONTINUE
9890  CONTINUE
9895  CONTINUE
C
C     BOUNDARY SOLUTE AND GAS FLUXES
C
      DO 9595 NX=NHW,NHE
      DO 9590 NY=NVN,NVS
      DO 9585 L=NU(NY,NX),NL(NY,NX)
      N1=NX
      N2=NY
      N3=L
C
C     LOCATE ALL EXTERNAL BOUNDARIES AND SET BOUNDARY CONDITIONS
C     ENTERED IN 'READS'
C
      DO 9580 N=1,3
      DO 9575 NN=1,2
      IF(N.EQ.1)THEN
      N4=NX+1
      N5=NY
      N6=L
      IF(NN.EQ.1)THEN
      IF(NX.EQ.NHE)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX+1
      M5=NY
      M6=L
      XN=-1.0
      ELSE
      GO TO 9575
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      IF(NX.EQ.NHW)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY
      M6=L
      XN=1.0
      ELSE
      GO TO 9575
      ENDIF
      ENDIF
      ELSEIF(N.EQ.2)THEN
      N4=NX
      N5=NY+1
      N6=L
      IF(NN.EQ.1)THEN
      IF(NY.EQ.NVS)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY+1
      M6=L
      XN=-1.0
      ELSE
      GO TO 9575
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      IF(NY.EQ.NVN)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY
      M6=L
      XN=1.0
      ELSE
      GO TO 9575
      ENDIF
      ENDIF
      ELSEIF(N.EQ.3)THEN
      N1=NX
      N2=NY
      N3=L
      N4=NX
      N5=NY
      N6=L+1
      IF(NN.EQ.1)THEN
      IF(L.EQ.NL(NY,NX))THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY
      M6=L+1
      XN=-1.0
      ELSE
      GO TO 9575
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      GO TO 9575
      ENDIF
      ENDIF
C
C     SURFACE SOLUTE TRANSPORT FROM BOUNDARY SURFACE
C     RUNOFF IN 'WATSUB' AND CONCENTRATIONS IN THE SURFACE SOIL LAYER
C
      IF(M.NE.MX)THEN
      IF(M3.EQ.NU(M2,M1).AND.N.NE.3)THEN
C
C     NO RUNOFF
C
      IF(QRM(M,N,M5,M4).EQ.0.0)THEN
      DO 9570 K=0,2
      RQROC(K,N,M5,M4)=0.0
      RQRON(K,N,M5,M4)=0.0
      RQROP(K,N,M5,M4)=0.0
      RQROA(K,N,M5,M4)=0.0
9570  CONTINUE
      RQRCOS(N,M5,M4)=0.0
      RQRCHS(N,M5,M4)=0.0
      RQROXS(N,M5,M4)=0.0
      RQRNGS(N,M5,M4)=0.0
      RQRN2S(N,M5,M4)=0.0
      RQRHGS(N,M5,M4)=0.0
      RQRNH4(N,M5,M4)=0.0
      RQRNH3(N,M5,M4)=0.0
      RQRNO3(N,M5,M4)=0.0
      RQRNO2(N,M5,M4)=0.0
      RQRH2P(N,M5,M4)=0.0
C
C     SOLUTE LOSS FROM RUNOFF DEPENDING ON ASPECT
C     AND BOUNDARY CONDITIONS SET IN SITE FILE
C
      ELSEIF(NN.EQ.1.AND.QRM(M,N,M5,M4).GT.0.0
     2.OR.NN.EQ.2.AND.QRM(M,N,M5,M4).LT.0.0)THEN
      IF(VOLWM(M,0,M2,M1).GT.ZEROS(M2,M1))THEN
      VFLW=AMAX1(-FVFLW,AMIN1(FVFLW,QRM(M,N,M5,M4)
     2/VOLWM(M,0,M2,M1)))
      ELSE
      VFLW=0.0
      ENDIF
      DO 9540 K=0,2
      RQROC(K,N,M5,M4)=VFLW*AMAX1(0.0,OQC2(K,0,M2,M1))
      RQRON(K,N,M5,M4)=VFLW*AMAX1(0.0,OQN2(K,0,M2,M1))
      RQROP(K,N,M5,M4)=VFLW*AMAX1(0.0,OQP2(K,0,M2,M1))
      RQROA(K,N,M5,M4)=VFLW*AMAX1(0.0,OQA2(K,0,M2,M1))
9540  CONTINUE
      RQRCOS(N,M5,M4)=VFLW*AMAX1(0.0,CO2S2(0,M2,M1))
      RQRCHS(N,M5,M4)=VFLW*AMAX1(0.0,CH4S2(0,M2,M1))
      RQROXS(N,M5,M4)=VFLW*AMAX1(0.0,OXYS2(0,M2,M1))
      RQRNGS(N,M5,M4)=VFLW*AMAX1(0.0,Z2GS2(0,M2,M1))
      RQRN2S(N,M5,M4)=VFLW*AMAX1(0.0,Z2OS2(0,M2,M1)) 
      RQRHGS(N,M5,M4)=VFLW*AMAX1(0.0,H2GS2(0,M2,M1))
      RQRNH4(N,M5,M4)=VFLW*AMAX1(0.0,ZNH4S2(0,M2,M1))
      RQRNH3(N,M5,M4)=VFLW*AMAX1(0.0,ZN3S2(0,M2,M1))
      RQRNO3(N,M5,M4)=VFLW*AMAX1(0.0,ZNO3S2(0,M2,M1))
      RQRNO2(N,M5,M4)=VFLW*AMAX1(0.0,ZNO2S2(0,M2,M1))
      RQRH2P(N,M5,M4)=VFLW*AMAX1(0.0,H2PO42(0,M2,M1))
C     WRITE(18,1114)'RUNX',I,J,M,M1,M2,M3,N,QRM(M,N,M5,M4)
C    2,RQRH2P(N,M5,M4),(RQROP(K,N,M5,M4),K=1,4)
1114  FORMAT(A8,7I4,20E12.4)
C
C     SOLUTE GAIN FROM RUNON DEPENDING ON ASPECT
C     AND BOUNDARY CONDITIONS SET IN SITE FILE
C
      ELSE
      DO 9640 K=0,2
      RQROC(K,N,M5,M4)=0.0
      RQRON(K,N,M5,M4)=0.0
      RQROP(K,N,M5,M4)=0.0
      RQROA(K,N,M5,M4)=0.0
9640  CONTINUE
      RQRCOS(N,M5,M4)=QRM(M,N,M5,M4)*CCOU
      RQRCHS(N,M5,M4)=QRM(M,N,M5,M4)*CCHU
      RQROXS(N,M5,M4)=QRM(M,N,M5,M4)*COXU
      RQRNGS(N,M5,M4)=QRM(M,N,M5,M4)*CNNU
      RQRN2S(N,M5,M4)=QRM(M,N,M5,M4)*CN2U
      RQRHGS(N,M5,M4)=0.0
      RQRNH4(N,M5,M4)=0.0
      RQRNH3(N,M5,M4)=0.0
      RQRNO3(N,M5,M4)=0.0
      RQRNO2(N,M5,M4)=0.0
      RQRH2P(N,M5,M4)=0.0
      ENDIF
      RQSCOS(N,M5,M4)=0.0
      RQSCHS(N,M5,M4)=0.0
      RQSOXS(N,M5,M4)=0.0
      RQSNGS(N,M5,M4)=0.0
      RQSN2S(N,M5,M4)=0.0
      RQSNH4(N,M5,M4)=0.0
      RQSNH3(N,M5,M4)=0.0
      RQSNO3(N,M5,M4)=0.0
      RQSH2P(N,M5,M4)=0.0
C
C     ACCUMULATE HOURLY FLUXES
C
      DO 9565 K=0,2
      XOCQRS(K,N,M5,M4)=XOCQRS(K,N,M5,M4)+RQROC(K,N,M5,M4)
      XONQRS(K,N,M5,M4)=XONQRS(K,N,M5,M4)+RQRON(K,N,M5,M4)
      XOPQRS(K,N,M5,M4)=XOPQRS(K,N,M5,M4)+RQROP(K,N,M5,M4)
      XOAQRS(K,N,M5,M4)=XOAQRS(K,N,M5,M4)+RQROA(K,N,M5,M4)
9565  CONTINUE
      XCOQRS(N,M5,M4)=XCOQRS(N,M5,M4)+RQRCOS(N,M5,M4)
      XCHQRS(N,M5,M4)=XCHQRS(N,M5,M4)+RQRCHS(N,M5,M4)
      XOXQRS(N,M5,M4)=XOXQRS(N,M5,M4)+RQROXS(N,M5,M4)
      XNGQRS(N,M5,M4)=XNGQRS(N,M5,M4)+RQRNGS(N,M5,M4)
      XN2QRS(N,M5,M4)=XN2QRS(N,M5,M4)+RQRN2S(N,M5,M4)
      XHGQRS(N,M5,M4)=XHGQRS(N,M5,M4)+RQRHGS(N,M5,M4)
      XN4QRW(N,M5,M4)=XN4QRW(N,M5,M4)+RQRNH4(N,M5,M4)
      XN3QRW(N,M5,M4)=XN3QRW(N,M5,M4)+RQRNH3(N,M5,M4)
      XNOQRW(N,M5,M4)=XNOQRW(N,M5,M4)+RQRNO3(N,M5,M4)
      XNXQRS(N,M5,M4)=XNXQRS(N,M5,M4)+RQRNO2(N,M5,M4)
      XP4QRW(N,M5,M4)=XP4QRW(N,M5,M4)+RQRH2P(N,M5,M4)
      XCOQSS(N,M5,M4)=XCOQSS(N,M5,M4)+RQSCOS(N,M5,M4)
      XCHQSS(N,M5,M4)=XCHQSS(N,M5,M4)+RQSCHS(N,M5,M4)
      XOXQSS(N,M5,M4)=XOXQSS(N,M5,M4)+RQSOXS(N,M5,M4)
      XNGQSS(N,M5,M4)=XNGQSS(N,M5,M4)+RQSNGS(N,M5,M4)
      XN2QSS(N,M5,M4)=XN2QSS(N,M5,M4)+RQSN2S(N,M5,M4)
      XN4QSS(N,M5,M4)=XN4QSS(N,M5,M4)+RQSNH4(N,M5,M4)
      XN3QSS(N,M5,M4)=XN3QSS(N,M5,M4)+RQSNH3(N,M5,M4)
      XNOQSS(N,M5,M4)=XNOQSS(N,M5,M4)+RQSNO3(N,M5,M4)
      XP4QSS(N,M5,M4)=XP4QSS(N,M5,M4)+RQSH2P(N,M5,M4)
      ENDIF
C
C     SOLUTE LOSS WITH SUBSURFACE MICROPORE WATER LOSS
C
      IF(NCN(M2,M1).EQ.1.OR.N.EQ.3)THEN
      IF(VOLWM(M,M3,M2,M1).GT.ZEROS(M2,M1))THEN
      VFLW=AMAX1(-FVFLW,AMIN1(FVFLW,FLWM(M,N,M6,M5,M4)
     2/VOLWM(M,M3,M2,M1)))
      ELSE
      VFLW=0.0
      ENDIF
      IF(NN.EQ.1.AND.FLWM(M,N,M6,M5,M4).GT.0.0
     2.OR.NN.EQ.2.AND.FLWM(M,N,M6,M5,M4).LT.0.0)THEN
      DO 9520 K=0,4
      ROCFLS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQC2(K,M3,M2,M1))
      RONFLS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQN2(K,M3,M2,M1))
      ROPFLS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQP2(K,M3,M2,M1))
      ROAFLS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQA2(K,M3,M2,M1))
9520  CONTINUE
      RCOFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,CO2S2(M3,M2,M1))
      RCHFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,CH4S2(M3,M2,M1))
      ROXFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,OXYS2(M3,M2,M1))
      RNGFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,Z2GS2(M3,M2,M1))
      RN2FLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,Z2OS2(M3,M2,M1))
      RHGFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H2GS2(M3,M2,M1))
      RN4FLW(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNH4S2(M3,M2,M1))
     2*VLNH4(M3,M2,M1)
      RN3FLW(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZN3S2(M3,M2,M1))
     2*VLNH4(M3,M2,M1)
      RNOFLW(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNO3S2(M3,M2,M1))
     2*VLNO3(M3,M2,M1)
      RNXFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNO2S2(M3,M2,M1))
     2*VLNO3(M3,M2,M1)
      RH2PFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H2PO42(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RN4FLB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNH4B2(M3,M2,M1))
     2*VLNHB(M3,M2,M1)
      RN3FLB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNBS2(M3,M2,M1))
     2*VLNHB(M3,M2,M1)
      RNOFLB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNO3B2(M3,M2,M1))
     2*VLNOB(M3,M2,M1)
      RNXFLB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNO2B2(M3,M2,M1))
     2*VLNOB(M3,M2,M1)
      RH2BFB(N,M6,M5,M4)=VFLW*AMAX1(0.0,H2POB2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
C     IF(J.EQ.15)THEN
C     WRITE(*,8765)'LEACH',I,J,M,M6,M5,M4,RNOFLW(N,M6,M5,M4)
C    2,VFLW,ZNO3S2(M3,M2,M1),VLNO3(M3,M2,M1),FLWM(M,N,M6,M5,M4)
C    3,VOLWM(M,M3,M2,M1)
8765  FORMAT(A8,6I4,20E12.4)
C     ENDIF
C
C     SOLUTE GAIN WITH SUBSURFACE MICROPORE WATER GAIN
C
      ELSE
      DO 9515 K=0,4
      ROCFLS(K,N,M6,M5,M4)=0.0
      RONFLS(K,N,M6,M5,M4)=0.0
      ROPFLS(K,N,M6,M5,M4)=0.0
      ROAFLS(K,N,M6,M5,M4)=0.0
9515  CONTINUE
      RCOFLS(N,M6,M5,M4)=0.0
      RCHFLS(N,M6,M5,M4)=0.0
      ROXFLS(N,M6,M5,M4)=0.0
      RNGFLS(N,M6,M5,M4)=0.0
      RN2FLS(N,M6,M5,M4)=0.0
      RHGFLS(N,M6,M5,M4)=0.0
      RN4FLW(N,M6,M5,M4)=0.0
      RN3FLW(N,M6,M5,M4)=0.0
      RNOFLW(N,M6,M5,M4)=0.0
      RNXFLS(N,M6,M5,M4)=0.0
      RH2PFS(N,M6,M5,M4)=0.0
      RN4FLB(N,M6,M5,M4)=0.0
      RN3FLB(N,M6,M5,M4)=0.0
      RNOFLB(N,M6,M5,M4)=0.0
      RNXFLB(N,M6,M5,M4)=0.0
      RH2BFB(N,M6,M5,M4)=0.0
      ENDIF
C     IF(M.NE.MX.AND.I.GE.180.AND.I.LE.200)THEN
C     WRITE(*,1115)'LEACHX',I,J,M1,M2,M3,M,MM,N
C    1,RCOFLS(N,M6,M5,M4),VFLW,CO2S2(M3,M2,M1)
C    2,RH2PFS(N,M6,M5,M4),(ROPFLS(K,N,M6,M5,M4),K=1,4)
C    4,VOLWM(M,M3,M2,M1),FLWM(M,N,M6,M5,M4),VFLW
1115  FORMAT(A8,8I4,20E12.4)
C     ENDIF
C
C     SOLUTE LOSS WITH SUBSURFACE MACROPORE WATER LOSS
C
      IF(NN.EQ.1.AND.FLWHM(M,N,M6,M5,M4).GT.0.0
     2.OR.NN.EQ.2.AND.FLWHM(M,N,M6,M5,M4).LT.0.0)THEN
      IF(VOLWHM(M,M3,M2,M1).GT.ZEROS(M2,M1))THEN
      VFLW=AMAX1(-FVFLW,AMIN1(FVFLW,FLWHM(M,N,M6,M5,M4)
     2/VOLWHM(M,M3,M2,M1)))
      ELSE
      VFLW=0.0
      ENDIF
      DO 9535 K=0,4
      ROCFHS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQCH2(K,M3,M2,M1))
      RONFHS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQNH2(K,M3,M2,M1))
      ROPFHS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQPH2(K,M3,M2,M1))
      ROAFHS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQAH2(K,M3,M2,M1))
9535  CONTINUE
      RCOFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,CO2SH2(M3,M2,M1))
      RCHFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,CH4SH2(M3,M2,M1))
      ROXFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,OXYSH2(M3,M2,M1))
      RNGFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,Z2GSH2(M3,M2,M1))
      RN2FHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,Z2OSH2(M3,M2,M1))
      RHGFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H2GSH2(M3,M2,M1))
      RN4FHW(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNH4H2(M3,M2,M1))
     2*VLNH4(M3,M2,M1)
      RN3FHW(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNH3H2(M3,M2,M1))
     2*VLNH4(M3,M2,M1)
      RNOFHW(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNO3H2(M3,M2,M1))
     2*VLNO3(M3,M2,M1)
      RNXFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNO2H2(M3,M2,M1))
     2*VLNO3(M3,M2,M1)
      RH2PHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H2P4H2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RN4FHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZN4BH2(M3,M2,M1))
     2*VLNHB(M3,M2,M1)
      RN3FHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZN3BH2(M3,M2,M1))
     2*VLNHB(M3,M2,M1)
      RNOFHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNOBH2(M3,M2,M1))
     2*VLNOB(M3,M2,M1)
      RNXFHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZN2BH2(M3,M2,M1))
     2*VLNOB(M3,M2,M1)
      RH2BHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,H2PBH2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
C
C     NO SOLUTE GAIN IN SUBSURFACE MACROPORES
C
      ELSE
      DO 9530 K=0,4
      ROCFHS(K,N,M6,M5,M4)=0.0
      RONFHS(K,N,M6,M5,M4)=0.0
      ROPFHS(K,N,M6,M5,M4)=0.0
      ROAFHS(K,N,M6,M5,M4)=0.0
9530  CONTINUE
      RCOFHS(N,M6,M5,M4)=0.0
      RCHFHS(N,M6,M5,M4)=0.0
      ROXFHS(N,M6,M5,M4)=0.0
      RNGFHS(N,M6,M5,M4)=0.0
      RN2FHS(N,M6,M5,M4)=0.0
      RN4FHW(N,M6,M5,M4)=0.0
      RHGFHS(N,M6,M5,M4)=0.0
      RN3FHW(N,M6,M5,M4)=0.0
      RNOFHW(N,M6,M5,M4)=0.0
      RNXFHS(N,M6,M5,M4)=0.0
      RH2PHS(N,M6,M5,M4)=0.0
      RN4FHB(N,M6,M5,M4)=0.0
      RN3FHB(N,M6,M5,M4)=0.0
      RNOFHB(N,M6,M5,M4)=0.0
      RNXFHB(N,M6,M5,M4)=0.0
      RH2BHB(N,M6,M5,M4)=0.0
      ENDIF
C
C     ACCUMULATE HOURLY FLUXES
C
      DO 9555 K=0,4
      XOCFLS(K,N,M6,M5,M4)=XOCFLS(K,N,M6,M5,M4)+ROCFLS(K,N,M6,M5,M4)
      XONFLS(K,N,M6,M5,M4)=XONFLS(K,N,M6,M5,M4)+RONFLS(K,N,M6,M5,M4)
      XOPFLS(K,N,M6,M5,M4)=XOPFLS(K,N,M6,M5,M4)+ROPFLS(K,N,M6,M5,M4)
      XOAFLS(K,N,M6,M5,M4)=XOAFLS(K,N,M6,M5,M4)+ROAFLS(K,N,M6,M5,M4)
      XOCFHS(K,N,M6,M5,M4)=XOCFHS(K,N,M6,M5,M4)+ROCFHS(K,N,M6,M5,M4)
      XONFHS(K,N,M6,M5,M4)=XONFHS(K,N,M6,M5,M4)+RONFHS(K,N,M6,M5,M4)
      XOPFHS(K,N,M6,M5,M4)=XOPFHS(K,N,M6,M5,M4)+ROPFHS(K,N,M6,M5,M4)
      XOAFHS(K,N,M6,M5,M4)=XOAFHS(K,N,M6,M5,M4)+ROAFHS(K,N,M6,M5,M4)
9555  CONTINUE
      XCOFLS(N,M6,M5,M4)=XCOFLS(N,M6,M5,M4)+RCOFLS(N,M6,M5,M4)
      XCHFLS(N,M6,M5,M4)=XCHFLS(N,M6,M5,M4)+RCHFLS(N,M6,M5,M4)
      XOXFLS(N,M6,M5,M4)=XOXFLS(N,M6,M5,M4)+ROXFLS(N,M6,M5,M4)
      XNGFLS(N,M6,M5,M4)=XNGFLS(N,M6,M5,M4)+RNGFLS(N,M6,M5,M4)
      XN2FLS(N,M6,M5,M4)=XN2FLS(N,M6,M5,M4)+RN2FLS(N,M6,M5,M4)
      XHGFLS(N,M6,M5,M4)=XHGFLS(N,M6,M5,M4)+RHGFLS(N,M6,M5,M4)
      XN4FLW(N,M6,M5,M4)=XN4FLW(N,M6,M5,M4)+RN4FLW(N,M6,M5,M4)
      XN3FLW(N,M6,M5,M4)=XN3FLW(N,M6,M5,M4)+RN3FLW(N,M6,M5,M4)
      XNOFLW(N,M6,M5,M4)=XNOFLW(N,M6,M5,M4)+RNOFLW(N,M6,M5,M4)
      XNXFLS(N,M6,M5,M4)=XNXFLS(N,M6,M5,M4)+RNXFLS(N,M6,M5,M4)
      XH2PFS(N,M6,M5,M4)=XH2PFS(N,M6,M5,M4)+RH2PFS(N,M6,M5,M4)
      XN4FLB(N,M6,M5,M4)=XN4FLB(N,M6,M5,M4)+RN4FLB(N,M6,M5,M4)
      XN3FLB(N,M6,M5,M4)=XN3FLB(N,M6,M5,M4)+RN3FLB(N,M6,M5,M4)
      XNOFLB(N,M6,M5,M4)=XNOFLB(N,M6,M5,M4)+RNOFLB(N,M6,M5,M4)
      XNXFLB(N,M6,M5,M4)=XNXFLB(N,M6,M5,M4)+RNXFLB(N,M6,M5,M4)
      XH2BFB(N,M6,M5,M4)=XH2BFB(N,M6,M5,M4)+RH2BFB(N,M6,M5,M4)
      XCOFHS(N,M6,M5,M4)=XCOFHS(N,M6,M5,M4)+RCOFHS(N,M6,M5,M4)
      XCHFHS(N,M6,M5,M4)=XCHFHS(N,M6,M5,M4)+RCHFHS(N,M6,M5,M4)
      XOXFHS(N,M6,M5,M4)=XOXFHS(N,M6,M5,M4)+ROXFHS(N,M6,M5,M4)
      XNGFHS(N,M6,M5,M4)=XNGFHS(N,M6,M5,M4)+RNGFHS(N,M6,M5,M4)
      XN2FHS(N,M6,M5,M4)=XN2FHS(N,M6,M5,M4)+RN2FHS(N,M6,M5,M4)
      XHGFHS(N,M6,M5,M4)=XHGFHS(N,M6,M5,M4)+RHGFHS(N,M6,M5,M4)
      XN4FHW(N,M6,M5,M4)=XN4FHW(N,M6,M5,M4)+RN4FHW(N,M6,M5,M4)
      XN3FHW(N,M6,M5,M4)=XN3FHW(N,M6,M5,M4)+RN3FHW(N,M6,M5,M4)
      XNOFHW(N,M6,M5,M4)=XNOFHW(N,M6,M5,M4)+RNOFHW(N,M6,M5,M4)
      XNXFHS(N,M6,M5,M4)=XNXFHS(N,M6,M5,M4)+RNXFHS(N,M6,M5,M4)
      XH2PHS(N,M6,M5,M4)=XH2PHS(N,M6,M5,M4)+RH2PHS(N,M6,M5,M4)
      XN4FHB(N,M6,M5,M4)=XN4FHB(N,M6,M5,M4)+RN4FHB(N,M6,M5,M4)
      XN3FHB(N,M6,M5,M4)=XN3FHB(N,M6,M5,M4)+RN3FHB(N,M6,M5,M4)
      XNOFHB(N,M6,M5,M4)=XNOFHB(N,M6,M5,M4)+RNOFHB(N,M6,M5,M4)
      XNXFHB(N,M6,M5,M4)=XNXFHB(N,M6,M5,M4)+RNXFHB(N,M6,M5,M4)
      XH2BHB(N,M6,M5,M4)=XH2BHB(N,M6,M5,M4)+RH2BHB(N,M6,M5,M4)
      ENDIF
      ENDIF
C
C     GASOUS BOUNDARY FLUXES
C
      IF(NN.EQ.1.AND.FLQM(N,M6,M5,M4).GT.0.0
     2.OR.NN.EQ.2.AND.FLQM(N,M6,M5,M4).LT.0.0)THEN
      IF(VOLPM(M,M3,M2,M1).GT.ZEROS(M2,M1))THEN
      VFLW=AMAX1(-FVFLW,AMIN1(FVFLW,FLQM(N,M6,M5,M4)
     2/VOLPM(M,M3,M2,M1)))
      ELSE
      VFLW=0.0
      ENDIF
      RCOFLG(N,M6,M5,M4)=-VFLW*AMAX1(0.0,CO2G2(M3,M2,M1))
      RCHFLG(N,M6,M5,M4)=-VFLW*AMAX1(0.0,CH4G2(M3,M2,M1))
      ROXFLG(N,M6,M5,M4)=-VFLW*AMAX1(0.0,OXYG2(M3,M2,M1))
      RNGFLG(N,M6,M5,M4)=-VFLW*AMAX1(0.0,Z2GG2(M3,M2,M1))
      RN2FLG(N,M6,M5,M4)=-VFLW*AMAX1(0.0,Z2OG2(M3,M2,M1))
      RN3FLG(N,M6,M5,M4)=-VFLW*AMAX1(0.0,ZN3G2(M3,M2,M1))
      RHGFLG(N,M6,M5,M4)=-VFLW*AMAX1(0.0,H2GG2(M3,M2,M1))
      XCOFLG(N,M6,M5,M4)=XCOFLG(N,M6,M5,M4)+RCOFLG(N,M6,M5,M4)
      XCHFLG(N,M6,M5,M4)=XCHFLG(N,M6,M5,M4)+RCHFLG(N,M6,M5,M4)
      XOXFLG(N,M6,M5,M4)=XOXFLG(N,M6,M5,M4)+ROXFLG(N,M6,M5,M4)
      XNGFLG(N,M6,M5,M4)=XNGFLG(N,M6,M5,M4)+RNGFLG(N,M6,M5,M4)
      XN2FLG(N,M6,M5,M4)=XN2FLG(N,M6,M5,M4)+RN2FLG(N,M6,M5,M4)
      XN3FLG(N,M6,M5,M4)=XN3FLG(N,M6,M5,M4)+RN3FLG(N,M6,M5,M4)
      XHGFLG(N,M6,M5,M4)=XHGFLG(N,M6,M5,M4)+RHGFLG(N,M6,M5,M4)
      ELSE
      RCOFLG(N,M6,M5,M4)=0.0
      RCHFLG(N,M6,M5,M4)=0.0
      ROXFLG(N,M6,M5,M4)=0.0
      RNGFLG(N,M6,M5,M4)=0.0
      RN2FLG(N,M6,M5,M4)=0.0
      RN3FLG(N,M6,M5,M4)=0.0
      RHGFLG(N,M6,M5,M4)=0.0
      ENDIF
9575  CONTINUE
C
C     TOTAL GAS AND SOLUTE FLUXES IN EACH GRID CELL
C
      IF(M.NE.MX)THEN
      IF(L.EQ.NU(N2,N1).AND.N.NE.3)THEN
C
C     TOTAL OVERLAND FLUX
C
      DO 9550 K=0,2
      TQROC(K,N2,N1)=TQROC(K,N2,N1)+RQROC(K,N,N2,N1)-RQROC(K,N,N5,N4)
      TQRON(K,N2,N1)=TQRON(K,N2,N1)+RQRON(K,N,N2,N1)-RQRON(K,N,N5,N4)
      TQROP(K,N2,N1)=TQROP(K,N2,N1)+RQROP(K,N,N2,N1)-RQROP(K,N,N5,N4)
      TQROA(K,N2,N1)=TQROA(K,N2,N1)+RQROA(K,N,N2,N1)-RQROA(K,N,N5,N4)
9550  CONTINUE
      TQRCOS(N2,N1)=TQRCOS(N2,N1)+RQRCOS(N,N2,N1)-RQRCOS(N,N5,N4)
      TQRCHS(N2,N1)=TQRCHS(N2,N1)+RQRCHS(N,N2,N1)-RQRCHS(N,N5,N4)
      TQROXS(N2,N1)=TQROXS(N2,N1)+RQROXS(N,N2,N1)-RQROXS(N,N5,N4)
      TQRNGS(N2,N1)=TQRNGS(N2,N1)+RQRNGS(N,N2,N1)-RQRNGS(N,N5,N4)
      TQRN2S(N2,N1)=TQRN2S(N2,N1)+RQRN2S(N,N2,N1)-RQRN2S(N,N5,N4)
      TQRHGS(N2,N1)=TQRHGS(N2,N1)+RQRHGS(N,N2,N1)-RQRHGS(N,N5,N4)
      TQRNH4(N2,N1)=TQRNH4(N2,N1)+RQRNH4(N,N2,N1)-RQRNH4(N,N5,N4)
      TQRNH3(N2,N1)=TQRNH3(N2,N1)+RQRNH3(N,N2,N1)-RQRNH3(N,N5,N4)
      TQRNO3(N2,N1)=TQRNO3(N2,N1)+RQRNO3(N,N2,N1)-RQRNO3(N,N5,N4)
      TQRNO2(N2,N1)=TQRNO2(N2,N1)+RQRNO2(N,N2,N1)-RQRNO2(N,N5,N4)
      TQRH2P(N2,N1)=TQRH2P(N2,N1)+RQRH2P(N,N2,N1)-RQRH2P(N,N5,N4)
      TQSCOS(N2,N1)=TQSCOS(N2,N1)+RQSCOS(N,N2,N1)-RQSCOS(N,N5,N4)
      TQSCHS(N2,N1)=TQSCHS(N2,N1)+RQSCHS(N,N2,N1)-RQSCHS(N,N5,N4)
      TQSOXS(N2,N1)=TQSOXS(N2,N1)+RQSOXS(N,N2,N1)-RQSOXS(N,N5,N4)
      TQSNGS(N2,N1)=TQSNGS(N2,N1)+RQSNGS(N,N2,N1)-RQSNGS(N,N5,N4)
      TQSN2S(N2,N1)=TQSN2S(N2,N1)+RQSN2S(N,N2,N1)-RQSN2S(N,N5,N4)
      TQSNH4(N2,N1)=TQSNH4(N2,N1)+RQSNH4(N,N2,N1)-RQSNH4(N,N5,N4)
      TQSNH3(N2,N1)=TQSNH3(N2,N1)+RQSNH3(N,N2,N1)-RQSNH3(N,N5,N4)
      TQSNO3(N2,N1)=TQSNO3(N2,N1)+RQSNO3(N,N2,N1)-RQSNO3(N,N5,N4)
      TQSH2P(N2,N1)=TQSH2P(N2,N1)+RQSH2P(N,N2,N1)-RQSH2P(N,N5,N4)
      ENDIF
      ENDIF
C
C     TOTAL SOLUTE FLUX IN MICROPORES AND MACROPORES
C
      IF(M.NE.MX)THEN
      IF(NCN(N2,N1).EQ.1.OR.N.EQ.3)THEN
      DO 9545 K=0,4
      TOCFLS(K,N3,N2,N1)=TOCFLS(K,N3,N2,N1)+ROCFLS(K,N,N3,N2,N1)
     2-ROCFLS(K,N,N6,N5,N4)
      TONFLS(K,N3,N2,N1)=TONFLS(K,N3,N2,N1)+RONFLS(K,N,N3,N2,N1)
     2-RONFLS(K,N,N6,N5,N4)
      TOPFLS(K,N3,N2,N1)=TOPFLS(K,N3,N2,N1)+ROPFLS(K,N,N3,N2,N1)
     2-ROPFLS(K,N,N6,N5,N4)
      TOAFLS(K,N3,N2,N1)=TOAFLS(K,N3,N2,N1)+ROAFLS(K,N,N3,N2,N1)
     2-ROAFLS(K,N,N6,N5,N4)
      TOCFHS(K,N3,N2,N1)=TOCFHS(K,N3,N2,N1)+ROCFHS(K,N,N3,N2,N1)
     2-ROCFHS(K,N,N6,N5,N4)
      TONFHS(K,N3,N2,N1)=TONFHS(K,N3,N2,N1)+RONFHS(K,N,N3,N2,N1)
     2-RONFHS(K,N,N6,N5,N4)
      TOPFHS(K,N3,N2,N1)=TOPFHS(K,N3,N2,N1)+ROPFHS(K,N,N3,N2,N1)
     2-ROPFHS(K,N,N6,N5,N4)
      TOAFHS(K,N3,N2,N1)=TOAFHS(K,N3,N2,N1)+ROAFHS(K,N,N3,N2,N1)
     2-ROAFHS(K,N,N6,N5,N4)
9545  CONTINUE
      TCOFLS(N3,N2,N1)=TCOFLS(N3,N2,N1)+RCOFLS(N,N3,N2,N1)
     2-RCOFLS(N,N6,N5,N4)
      TCHFLS(N3,N2,N1)=TCHFLS(N3,N2,N1)+RCHFLS(N,N3,N2,N1)
     2-RCHFLS(N,N6,N5,N4)
      TOXFLS(N3,N2,N1)=TOXFLS(N3,N2,N1)+ROXFLS(N,N3,N2,N1)
     2-ROXFLS(N,N6,N5,N4)
      TNGFLS(N3,N2,N1)=TNGFLS(N3,N2,N1)+RNGFLS(N,N3,N2,N1)
     2-RNGFLS(N,N6,N5,N4)
      TN2FLS(N3,N2,N1)=TN2FLS(N3,N2,N1)+RN2FLS(N,N3,N2,N1)
     2-RN2FLS(N,N6,N5,N4)
      THGFLS(N3,N2,N1)=THGFLS(N3,N2,N1)+RHGFLS(N,N3,N2,N1)
     2-RHGFLS(N,N6,N5,N4)
      TN4FLW(N3,N2,N1)=TN4FLW(N3,N2,N1)+RN4FLW(N,N3,N2,N1)
     2-RN4FLW(N,N6,N5,N4)
      TN3FLW(N3,N2,N1)=TN3FLW(N3,N2,N1)+RN3FLW(N,N3,N2,N1)
     2-RN3FLW(N,N6,N5,N4)
      TNOFLW(N3,N2,N1)=TNOFLW(N3,N2,N1)+RNOFLW(N,N3,N2,N1)
     2-RNOFLW(N,N6,N5,N4)
      TNXFLS(N3,N2,N1)=TNXFLS(N3,N2,N1)+RNXFLS(N,N3,N2,N1)
     2-RNXFLS(N,N6,N5,N4)
      TH2PFS(N3,N2,N1)=TH2PFS(N3,N2,N1)+RH2PFS(N,N3,N2,N1)
     2-RH2PFS(N,N6,N5,N4)
      TN4FLB(N3,N2,N1)=TN4FLB(N3,N2,N1)+RN4FLB(N,N3,N2,N1)
     2-RN4FLB(N,N6,N5,N4)
      TN3FLB(N3,N2,N1)=TN3FLB(N3,N2,N1)+RN3FLB(N,N3,N2,N1)
     2-RN3FLB(N,N6,N5,N4)
      TNOFLB(N3,N2,N1)=TNOFLB(N3,N2,N1)+RNOFLB(N,N3,N2,N1)
     2-RNOFLB(N,N6,N5,N4)
      TNXFLB(N3,N2,N1)=TNXFLB(N3,N2,N1)+RNXFLB(N,N3,N2,N1)
     2-RNXFLB(N,N6,N5,N4)
      TH2BFB(N3,N2,N1)=TH2BFB(N3,N2,N1)+RH2BFB(N,N3,N2,N1)
     2-RH2BFB(N,N6,N5,N4)
      TCOFHS(N3,N2,N1)=TCOFHS(N3,N2,N1)+RCOFHS(N,N3,N2,N1)
     2-RCOFHS(N,N6,N5,N4)
      TCHFHS(N3,N2,N1)=TCHFHS(N3,N2,N1)+RCHFHS(N,N3,N2,N1)
     2-RCHFHS(N,N6,N5,N4)
      TOXFHS(N3,N2,N1)=TOXFHS(N3,N2,N1)+ROXFHS(N,N3,N2,N1)
     2-ROXFHS(N,N6,N5,N4)
      TNGFHS(N3,N2,N1)=TNGFHS(N3,N2,N1)+RNGFHS(N,N3,N2,N1)
     2-RNGFHS(N,N6,N5,N4)
      TN2FHS(N3,N2,N1)=TN2FHS(N3,N2,N1)+RN2FHS(N,N3,N2,N1)
     2-RN2FHS(N,N6,N5,N4)
      THGFHS(N3,N2,N1)=THGFHS(N3,N2,N1)+RHGFHS(N,N3,N2,N1)
     2-RHGFHS(N,N6,N5,N4)
      TN4FHW(N3,N2,N1)=TN4FHW(N3,N2,N1)+RN4FHW(N,N3,N2,N1)
     2-RN4FHW(N,N6,N5,N4)
      TN3FHW(N3,N2,N1)=TN3FHW(N3,N2,N1)+RN3FHW(N,N3,N2,N1)
     2-RN3FHW(N,N6,N5,N4)
      TNOFHW(N3,N2,N1)=TNOFHW(N3,N2,N1)+RNOFHW(N,N3,N2,N1)
     2-RNOFHW(N,N6,N5,N4)
      TNXFHS(N3,N2,N1)=TNXFHS(N3,N2,N1)+RNXFHS(N,N3,N2,N1)
     2-RNXFHS(N,N6,N5,N4)
      TH2PHS(N3,N2,N1)=TH2PHS(N3,N2,N1)+RH2PHS(N,N3,N2,N1)
     2-RH2PHS(N,N6,N5,N4)
      TN4FHB(N3,N2,N1)=TN4FHB(N3,N2,N1)+RN4FHB(N,N3,N2,N1)
     2-RN4FHB(N,N6,N5,N4)
      TN3FHB(N3,N2,N1)=TN3FHB(N3,N2,N1)+RN3FHB(N,N3,N2,N1)
     2-RN3FHB(N,N6,N5,N4)
      TNOFHB(N3,N2,N1)=TNOFHB(N3,N2,N1)+RNOFHB(N,N3,N2,N1)
     2-RNOFHB(N,N6,N5,N4)
      TNXFHB(N3,N2,N1)=TNXFHB(N3,N2,N1)+RNXFHB(N,N3,N2,N1)
     2-RNXFHB(N,N6,N5,N4)
      TH2BHB(N3,N2,N1)=TH2BHB(N3,N2,N1)+RH2BHB(N,N3,N2,N1)
     2-RH2BHB(N,N6,N5,N4)
      ENDIF
      ENDIF
C
C     TOTAL GAS FLUX
C
C     IF(NCN(N2,N1).EQ.1.OR.N.EQ.3)THEN
      TCOFLG(N3,N2,N1)=TCOFLG(N3,N2,N1)+RCOFLG(N,N3,N2,N1)
     2-RCOFLG(N,N6,N5,N4)
      TCHFLG(N3,N2,N1)=TCHFLG(N3,N2,N1)+RCHFLG(N,N3,N2,N1)
     2-RCHFLG(N,N6,N5,N4)
      TOXFLG(N3,N2,N1)=TOXFLG(N3,N2,N1)+ROXFLG(N,N3,N2,N1)
     2-ROXFLG(N,N6,N5,N4)
      TNGFLG(N3,N2,N1)=TNGFLG(N3,N2,N1)+RNGFLG(N,N3,N2,N1)
     2-RNGFLG(N,N6,N5,N4)
      TN2FLG(N3,N2,N1)=TN2FLG(N3,N2,N1)+RN2FLG(N,N3,N2,N1)
     2-RN2FLG(N,N6,N5,N4)
      TN3FLG(N3,N2,N1)=TN3FLG(N3,N2,N1)+RN3FLG(N,N3,N2,N1)
     2-RN3FLG(N,N6,N5,N4)
      THGFLG(N3,N2,N1)=THGFLG(N3,N2,N1)+RHGFLG(N,N3,N2,N1)
     2-RHGFLG(N,N6,N5,N4)
C     ENDIF
9580  CONTINUE
9585  CONTINUE
9590  CONTINUE
9595  CONTINUE
C
C     UPDATE STATE VARIABLES FROM TOTAL FLUXES CALCULATED ABOVE
C
      IF(MM.NE.NPG)THEN
      DO 9695 NX=NHW,NHE
      DO 9690 NY=NVN,NVS
      IF(M.NE.MX)THEN
C
C     STATE VARIABLES FOR SOLUTES IN MICROPORES AND MACROPORES IN
C     SOIL SURFACE LAYER FROM OVERLAND FLOW AND SURFACE VOLATILIZATION-
C     DISSOLUTION
C
      DO 9681 K=0,2
      OQC2(K,0,NY,NX)=OQC2(K,0,NY,NX)+ROCFLS(K,3,0,NY,NX)
      OQN2(K,0,NY,NX)=OQN2(K,0,NY,NX)+RONFLS(K,3,0,NY,NX)
      OQP2(K,0,NY,NX)=OQP2(K,0,NY,NX)+ROPFLS(K,3,0,NY,NX)
      OQA2(K,0,NY,NX)=OQA2(K,0,NY,NX)+ROAFLS(K,3,0,NY,NX)
9681  CONTINUE
      CO2S2(0,NY,NX)=CO2S2(0,NY,NX)+RCODFR(NY,NX)+RCOFLS(3,0,NY,NX)
      CH4S2(0,NY,NX)=CH4S2(0,NY,NX)+RCHDFR(NY,NX)+RCHFLS(3,0,NY,NX)
      OXYS2(0,NY,NX)=OXYS2(0,NY,NX)+ROXDFR(NY,NX)+ROXFLS(3,0,NY,NX)
C     IF(I.EQ.175)THEN
C     WRITE(*,8787)'OXYS20',I,J,NX,NY,M,MM,OXYS2(0,NY,NX)
C    2,ROXDFR(NY,NX),ROXFLS(3,0,NY,NX),ROXSK2(0,NY,NX)
C    3,TQROXS(NY,NX),ROXDFG(0,NY,NX),XOXFLS(3,0,NY,NX)
8787  FORMAT(A8,6I4,12E12.4)
C     ENDIF
      Z2GS2(0,NY,NX)=Z2GS2(0,NY,NX)+RNGDFR(NY,NX)+RNGFLS(3,0,NY,NX)
      Z2OS2(0,NY,NX)=Z2OS2(0,NY,NX)+RN2DFR(NY,NX)+RN2FLS(3,0,NY,NX)
      H2GS2(0,NY,NX)=H2GS2(0,NY,NX)+RHGDFR(NY,NX)+RHGFLS(3,0,NY,NX)
      ZNH4S2(0,NY,NX)=ZNH4S2(0,NY,NX)+RN4FLW(3,0,NY,NX)
      ZN3S2(0,NY,NX)=ZN3S2(0,NY,NX)+RN3DFR(NY,NX)+RN3FLW(3,0,NY,NX)
      ZNO3S2(0,NY,NX)=ZNO3S2(0,NY,NX)+RNOFLW(3,0,NY,NX)
      ZNO2S2(0,NY,NX)=ZNO2S2(0,NY,NX)+RNXFLS(3,0,NY,NX)
      H2PO42(0,NY,NX)=H2PO42(0,NY,NX)+RH2PFS(3,0,NY,NX)
      CO2S2(NU(NY,NX),NY,NX)=CO2S2(NU(NY,NX),NY,NX)+RCODFS(NY,NX)
      CH4S2(NU(NY,NX),NY,NX)=CH4S2(NU(NY,NX),NY,NX)+RCHDFS(NY,NX)
      OXYS2(NU(NY,NX),NY,NX)=OXYS2(NU(NY,NX),NY,NX)+ROXDFS(NY,NX)
      Z2GS2(NU(NY,NX),NY,NX)=Z2GS2(NU(NY,NX),NY,NX)+RNGDFS(NY,NX)
      Z2OS2(NU(NY,NX),NY,NX)=Z2OS2(NU(NY,NX),NY,NX)+RN2DFS(NY,NX)
      ZN3S2(NU(NY,NX),NY,NX)=ZN3S2(NU(NY,NX),NY,NX)+RN3DFS(NY,NX)
      ZNBS2(NU(NY,NX),NY,NX)=ZNBS2(NU(NY,NX),NY,NX)+RNBDFS(NY,NX)
      H2GS2(NU(NY,NX),NY,NX)=H2GS2(NU(NY,NX),NY,NX)+RHGDFS(NY,NX)
      DO 9680 K=0,2
      OQC2(K,0,NY,NX)=OQC2(K,0,NY,NX)+TQROC(K,NY,NX)
      OQN2(K,0,NY,NX)=OQN2(K,0,NY,NX)+TQRON(K,NY,NX)
      OQP2(K,0,NY,NX)=OQP2(K,0,NY,NX)+TQROP(K,NY,NX)
      OQA2(K,0,NY,NX)=OQA2(K,0,NY,NX)+TQROA(K,NY,NX)
9680  CONTINUE
      CO2S2(0,NY,NX)=CO2S2(0,NY,NX)+TQRCOS(NY,NX)
      CH4S2(0,NY,NX)=CH4S2(0,NY,NX)+TQRCHS(NY,NX)
      OXYS2(0,NY,NX)=OXYS2(0,NY,NX)+TQROXS(NY,NX)
      Z2GS2(0,NY,NX)=Z2GS2(0,NY,NX)+TQRNGS(NY,NX)
      Z2OS2(0,NY,NX)=Z2OS2(0,NY,NX)+TQRN2S(NY,NX)
      H2GS2(0,NY,NX)=H2GS2(0,NY,NX)+TQRHGS(NY,NX)
      ZNH4S2(0,NY,NX)=ZNH4S2(0,NY,NX)+TQRNH4(NY,NX)
      ZN3S2(0,NY,NX)=ZN3S2(0,NY,NX)+TQRNH3(NY,NX)
      ZNO3S2(0,NY,NX)=ZNO3S2(0,NY,NX)+TQRNO3(NY,NX)
      ZNO2S2(0,NY,NX)=ZNO2S2(0,NY,NX)+TQRNO2(NY,NX)
      H2PO42(0,NY,NX)=H2PO42(0,NY,NX)+TQRH2P(NY,NX)
      CO2W2(NY,NX)=CO2W2(NY,NX)+TQSCOS(NY,NX)
      CH4W2(NY,NX)=CH4W2(NY,NX)+TQSCHS(NY,NX)
      OXYW2(NY,NX)=OXYW2(NY,NX)+TQSOXS(NY,NX)
      ZNGW2(NY,NX)=ZNGW2(NY,NX)+TQSNGS(NY,NX)
      ZN2W2(NY,NX)=ZN2W2(NY,NX)+TQSN2S(NY,NX)
      ZN4W2(NY,NX)=ZN4W2(NY,NX)+TQSNH4(NY,NX)
      ZN3W2(NY,NX)=ZN3W2(NY,NX)+TQSNH3(NY,NX)
      ZNOW2(NY,NX)=ZNOW2(NY,NX)+TQSNO3(NY,NX)
      ZHPW2(NY,NX)=ZHPW2(NY,NX)+TQSH2P(NY,NX)
C     IF(I.EQ.118.AND.NX.EQ.3.AND.NY.EQ.4)THEN
C     WRITE(*,6868)'OXYW2',I,J,NX,NY,M,MM,OXYW2(NY,NX)
C    2,TQSOXS(NY,NX),XOXBLS(NY,NX)
6868  FORMAT(A8,6I4,12E12.4)
C     ENDIF
      ENDIF
C
C     STATE VARIABLES FOR GASES AND FOR SOLUTES IN MICROPORES AND
C     MACROPORES IN SOIL LAYERS FROM SUBSURFACE FLOW, MICROBIAL
C     AND ROOT EXCHANGE IN 'NITRO' AND 'UPTAKE', AND EQUILIBRIUM
C     REACTIONS IN 'SOLUTE'
C
      DO 9685 L=NU(NY,NX),NL(NY,NX)
      IF(M.NE.MX)THEN
      CO2S2(L,NY,NX)=CO2S2(L,NY,NX)+TCOFLS(L,NY,NX)+RCOFXS(L,NY,NX)
     2+RCOFLZ(L,NY,NX)+RCOBBL(L,NY,NX)
      CH4S2(L,NY,NX)=CH4S2(L,NY,NX)+TCHFLS(L,NY,NX)+RCHFXS(L,NY,NX)
     2+RCHFLZ(L,NY,NX)+RCHBBL(L,NY,NX)
      OXYS2(L,NY,NX)=OXYS2(L,NY,NX)+TOXFLS(L,NY,NX)+ROXFXS(L,NY,NX)
     2+ROXFLZ(L,NY,NX)+ROXBBL(L,NY,NX)
      Z2GS2(L,NY,NX)=Z2GS2(L,NY,NX)+TNGFLS(L,NY,NX)+RNGFXS(L,NY,NX)
     2+RNGFLZ(L,NY,NX)+RNGBBL(L,NY,NX)
      Z2OS2(L,NY,NX)=Z2OS2(L,NY,NX)+TN2FLS(L,NY,NX)+RN2FXS(L,NY,NX)
     2+RN2FLZ(L,NY,NX)+RN2BBL(L,NY,NX)
      ZN3S2(L,NY,NX)=ZN3S2(L,NY,NX)+TN3FLW(L,NY,NX)+RN3FXW(L,NY,NX)
     2+RN3FLZ(L,NY,NX)+RN3BBL(L,NY,NX)
      ZNBS2(L,NY,NX)=ZNBS2(L,NY,NX)+TN3FLB(L,NY,NX)+RN3FXB(L,NY,NX)
     2+RN3FBZ(L,NY,NX)+RNBBBL(L,NY,NX)
      H2GS2(L,NY,NX)=H2GS2(L,NY,NX)+THGFLS(L,NY,NX)+RHGFXS(L,NY,NX)
     2+RHGFLZ(L,NY,NX)+RHGBBL(L,NY,NX)
      DO 9675 K=0,4
      OQC2(K,L,NY,NX)=OQC2(K,L,NY,NX)+TOCFLS(K,L,NY,NX)
     2+ROCFXS(K,L,NY,NX) 
      OQN2(K,L,NY,NX)=OQN2(K,L,NY,NX)+TONFLS(K,L,NY,NX)
     2+RONFXS(K,L,NY,NX) 
      OQP2(K,L,NY,NX)=OQP2(K,L,NY,NX)+TOPFLS(K,L,NY,NX)
     2+ROPFXS(K,L,NY,NX) 
      OQA2(K,L,NY,NX)=OQA2(K,L,NY,NX)+TOAFLS(K,L,NY,NX)
     2+ROAFXS(K,L,NY,NX) 
      OQCH2(K,L,NY,NX)=OQCH2(K,L,NY,NX)+TOCFHS(K,L,NY,NX)
     2-ROCFXS(K,L,NY,NX)
      OQNH2(K,L,NY,NX)=OQNH2(K,L,NY,NX)+TONFHS(K,L,NY,NX)
     2-RONFXS(K,L,NY,NX)
      OQPH2(K,L,NY,NX)=OQPH2(K,L,NY,NX)+TOPFHS(K,L,NY,NX)
     2-ROPFXS(K,L,NY,NX)
      OQAH2(K,L,NY,NX)=OQAH2(K,L,NY,NX)+TOAFHS(K,L,NY,NX)
     2-ROAFXS(K,L,NY,NX)
9675  CONTINUE
      ZNH4S2(L,NY,NX)=ZNH4S2(L,NY,NX)+TN4FLW(L,NY,NX)+RN4FXW(L,NY,NX)
     2+RN4FLZ(L,NY,NX)
      ZNO3S2(L,NY,NX)=ZNO3S2(L,NY,NX)+TNOFLW(L,NY,NX)+RNOFXW(L,NY,NX)
     2+RNOFLZ(L,NY,NX)
      ZNO2S2(L,NY,NX)=ZNO2S2(L,NY,NX)+TNXFLS(L,NY,NX)+RNXFXS(L,NY,NX)
      H2PO42(L,NY,NX)=H2PO42(L,NY,NX)+TH2PFS(L,NY,NX)+RH2PXS(L,NY,NX)
     2+RH2PFZ(L,NY,NX)
      ZNH4B2(L,NY,NX)=ZNH4B2(L,NY,NX)+TN4FLB(L,NY,NX)+RN4FXB(L,NY,NX)
     2+RN4FBZ(L,NY,NX)
      ZNO3B2(L,NY,NX)=ZNO3B2(L,NY,NX)+TNOFLB(L,NY,NX)+RNOFXB(L,NY,NX)
     2+RNOFBZ(L,NY,NX)
      ZNO2B2(L,NY,NX)=ZNO2B2(L,NY,NX)+TNXFLB(L,NY,NX)+RNXFXB(L,NY,NX)
      H2POB2(L,NY,NX)=H2POB2(L,NY,NX)+TH2BFB(L,NY,NX)+RH2BXB(L,NY,NX)
     2+RH2BBZ(L,NY,NX)
      CO2SH2(L,NY,NX)=CO2SH2(L,NY,NX)+TCOFHS(L,NY,NX)-RCOFXS(L,NY,NX)
      CH4SH2(L,NY,NX)=CH4SH2(L,NY,NX)+TCHFHS(L,NY,NX)-RCHFXS(L,NY,NX)
      OXYSH2(L,NY,NX)=OXYSH2(L,NY,NX)+TOXFHS(L,NY,NX)-ROXFXS(L,NY,NX)
      Z2GSH2(L,NY,NX)=Z2GSH2(L,NY,NX)+TNGFHS(L,NY,NX)-RNGFXS(L,NY,NX)
      Z2OSH2(L,NY,NX)=Z2OSH2(L,NY,NX)+TN2FHS(L,NY,NX)-RN2FXS(L,NY,NX)
      H2GSH2(L,NY,NX)=H2GSH2(L,NY,NX)+THGFHS(L,NY,NX)-RHGFXS(L,NY,NX)
      ZNH4H2(L,NY,NX)=ZNH4H2(L,NY,NX)+TN4FHW(L,NY,NX)-RN4FXW(L,NY,NX)
      ZNH3H2(L,NY,NX)=ZNH3H2(L,NY,NX)+TN3FHW(L,NY,NX)-RN3FXW(L,NY,NX)
      ZNO3H2(L,NY,NX)=ZNO3H2(L,NY,NX)+TNOFHW(L,NY,NX)-RNOFXW(L,NY,NX)
      ZNO2H2(L,NY,NX)=ZNO2H2(L,NY,NX)+TNXFHS(L,NY,NX)-RNXFXS(L,NY,NX)
      H2P4H2(L,NY,NX)=H2P4H2(L,NY,NX)+TH2PHS(L,NY,NX)-RH2PXS(L,NY,NX)
      ZN4BH2(L,NY,NX)=ZN4BH2(L,NY,NX)+TN4FHB(L,NY,NX)-RN4FXB(L,NY,NX)
      ZN3BH2(L,NY,NX)=ZN3BH2(L,NY,NX)+TN3FHB(L,NY,NX)-RN3FXB(L,NY,NX)
      ZNOBH2(L,NY,NX)=ZNOBH2(L,NY,NX)+TNOFHB(L,NY,NX)-RNOFXB(L,NY,NX)
      ZN2BH2(L,NY,NX)=ZN2BH2(L,NY,NX)+TNXFHB(L,NY,NX)-RNXFXB(L,NY,NX)
      H2PBH2(L,NY,NX)=H2PBH2(L,NY,NX)+TH2BHB(L,NY,NX)-RH2BXB(L,NY,NX)
      ENDIF
      CO2S2(L,NY,NX)=CO2S2(L,NY,NX)+RCODFG(L,NY,NX)
      CH4S2(L,NY,NX)=CH4S2(L,NY,NX)+RCHDFG(L,NY,NX)
      OXYS2(L,NY,NX)=OXYS2(L,NY,NX)+ROXDFG(L,NY,NX)
      Z2GS2(L,NY,NX)=Z2GS2(L,NY,NX)+RNGDFG(L,NY,NX)
      Z2OS2(L,NY,NX)=Z2OS2(L,NY,NX)+RN2DFG(L,NY,NX)
      ZN3S2(L,NY,NX)=ZN3S2(L,NY,NX)+RN3DFG(L,NY,NX)-RN34SQ(L,NY,NX)
      ZNH4S2(L,NY,NX)=ZNH4S2(L,NY,NX)+RN34SQ(L,NY,NX)
      ZNBS2(L,NY,NX)=ZNBS2(L,NY,NX)+RNBDFG(L,NY,NX)-RN34BQ(L,NY,NX)
      ZNH4B2(L,NY,NX)=ZNH4B2(L,NY,NX)+RN34BQ(L,NY,NX)
      H2GS2(L,NY,NX)=H2GS2(L,NY,NX)+RHGDFG(L,NY,NX)
      CO2G2(L,NY,NX)=CO2G2(L,NY,NX)+TCOFLG(L,NY,NX)-RCODFG(L,NY,NX)
      CH4G2(L,NY,NX)=CH4G2(L,NY,NX)+TCHFLG(L,NY,NX)-RCHDFG(L,NY,NX)
      OXYG2(L,NY,NX)=OXYG2(L,NY,NX)+TOXFLG(L,NY,NX)-ROXDFG(L,NY,NX)
      Z2GG2(L,NY,NX)=Z2GG2(L,NY,NX)+TNGFLG(L,NY,NX)-RNGDFG(L,NY,NX)
      Z2OG2(L,NY,NX)=Z2OG2(L,NY,NX)+TN2FLG(L,NY,NX)-RN2DFG(L,NY,NX)
      ZN3G2(L,NY,NX)=ZN3G2(L,NY,NX)+TN3FLG(L,NY,NX)-RN3DFG(L,NY,NX)
     2-RNBDFG(L,NY,NX)
      H2GG2(L,NY,NX)=H2GG2(L,NY,NX)+THGFLG(L,NY,NX)-RHGDFG(L,NY,NX)
C     IF(NX.EQ.3.AND.NY.EQ.2.AND.I.GE.190)THEN
C     WRITE(*,444)'CO2S2',I,J,NX,NY,L,M,MM
C    2,CO2S2(L,NY,NX),TCOFLS(L,NY,NX),RCOFXS(L,NY,NX)
C    2,RCOFLZ(L,NY,NX),RCOBBL(L,NY,NX),RCODFG(L,NY,NX)
C    2,CO2S(L,NY,NX),RCOSK2(L,NY,NX),TQRCOS(NY,NX)
C    3,RCODFS(NY,NX),PARG(NY,NX),CCO2E(NY,NX),CCO2SQ
C    4,CO2S2(L,NY,NX)/VOLWM(M,L,NY,NX)
C     WRITE(*,444)'OXYS2',I,J,NX,NY,L,M,MX
C    2,OXYS2(L,NY,NX),TOXFLS(L,NY,NX),ROXFXS(L,NY,NX)
C    3,ROXFLZ(L,NY,NX),ROXBBL(L,NY,NX),ROXDFG(L,NY,NX)
C    4,ROXSK(M,L,NY,NX),OXYG2(L,NY,NX),ROXFLS(3,L,NY,NX)
C    5,ROXFLS(3,L+1,NY,NX),ROXDFS(NY,NX),ROXSK2(L,NY,NX)
C    6,ROXSK(M,L,NY,NX),VOLWM(M,L,NY,NX)
C     WRITE(*,444)'CH4S2',I,J,NX,NY,L,M,MM,CH4S2(L,NY,NX)
C    2,TCHFLS(L,NY,NX),RCHFXS(L,NY,NX),RCHFLZ(L,NY,NX)
C    3,RCHBBL(L,NY,NX),RCHDFG(L,NY,NX),RCHSK2(L,NY,NX)
C    4,RCHFLS(3,L,NY,NX),RCHFLS(3,L+1,NY,NX)
C     WRITE(*,444)'ZN3G2',I,J,NX,NY,L,M,MM,ZN3G2(L,NY,NX) 
C    2,TN3FLG(L,NY,NX),RN3DFG(L,NY,NX),RN34SQ(L,NY,NX),RNBDFG(L,NY,NX) 
C    3,RN34BQ(L,NY,NX),ZN3S2(L,NY,NX),ZNBS2(L,NY,NX)
C    3,ZNH4S2(L,NY,NX),ZNH4B2(L,NY,NX),RNHSK2(L,NY,NX)
C     WRITE(*,444)'OXYG2',I,J,NX,NY,L,M,MM,OXYG2(L,NY,NX) 
C    2,TOXFLG(L,NY,NX),ROXDFG(L,NY,NX),OXYS2(L,NY,NX) 
C    3,ROXFLG(3,L,NY,NX),ROXFLG(3,L+1,NY,NX),DOXYG(3,L,NY,NX)
C    4,THETPM(M,L,NY,NX),PARGOX(NY,NX)
C    6,XOXFLG(3,L,NY,NX),XOXFLG(3,L+1,NY,NX)
C    7,THETPM(M,L,NY,NX),COXYE(NY,NX),FLQM(N,L,NY,NX)
C     WRITE(*,444)'N2OG2',I,J,NX,NY,L,M,MM,Z2OG2(L,NY,NX)
C    2,Z2OS2(L,NY,NX),Z2OSH2(L,NY,NX),TN2FLG(L,NY,NX),RN2DFG(L,NY,NX)
C    3,TN2FLS(L,NY,NX),RN2FXS(L,NY,NX),RN2FLZ(L,NY,NX),RN2BBL(L,NY,NX)
C    2,TN2FHS(L,NY,NX),RN2SK2(L,NY,NX),RN2O(L,NY,NX),TUPN2S(L,NY,NX) 
C     WRITE(*,444)'H2GS2',I,J,NX,NY,L,M,MM,H2GS2(L,NY,NX)
C    2,THGFLS(L,NY,NX),RHGFXS(L,NY,NX),RHGFLZ(L,NY,NX),RHGBBL(L,NY,NX)
C    3,H2GSH2(L,NY,NX),THGFHS(L,NY,NX),RHGDFG(L,NY,NX),RHGSK2(L,NY,NX)
C    4,RH2GO(L,NY,NX),TUPHGS(L,NY,NX) 
444   FORMAT(A8,7I4,20E16.6)
C     ENDIF
9685  CONTINUE
      CO2S2(0,NY,NX)=CO2S2(0,NY,NX)+RCODFG(0,NY,NX)
      CH4S2(0,NY,NX)=CH4S2(0,NY,NX)+RCHDFG(0,NY,NX)
      OXYS2(0,NY,NX)=OXYS2(0,NY,NX)+ROXDFG(0,NY,NX)
      Z2GS2(0,NY,NX)=Z2GS2(0,NY,NX)+RNGDFG(0,NY,NX)
      Z2OS2(0,NY,NX)=Z2OS2(0,NY,NX)+RN2DFG(0,NY,NX)
      ZN3S2(0,NY,NX)=ZN3S2(0,NY,NX)+RN3DFG(0,NY,NX) 
      H2GS2(0,NY,NX)=H2GS2(0,NY,NX)+RHGDFG(0,NY,NX)
      ZN3S2(0,NY,NX)=ZN3S2(0,NY,NX)-RN34SQ(0,NY,NX)
      ZNH4S2(0,NY,NX)=ZNH4S2(0,NY,NX)+RN34SQ(0,NY,NX)
C     IF(NY.EQ.5.AND.M.NE.MX)THEN
C     WRITE(*,1119)'OXYS20',I,J,NX,NY,M,MM,OXYS2(0,NY,NX)
C    2,ROXDFG(0,NY,NX),ROXDFR(NY,NX),ROXFLS(3,0,NY,NX)
C    3,TQROXS(NY,NX),ROXSK2(0,NY,NX),OXYS2(0,NY,NX)/VOLWM(M,0,NY,NX)
C    4,VOLWM(M,0,NY,NX)/VOLA(0,NY,NX),VOLPM(M,0,NY,NX)/VOLA(0,NY,NX)
C    5,VOLWM(M,0,NY,NX),VOLA(0,NY,NX),VOLWG(NY,NX),DFGS(M,0,NY,NX)
C    6,VOLPM(M,NU(NY,NX),NY,NX),VOLWM(M,NU(NY,NX),NY,NX)
C    7,VOLWHM(M,NU(NY,NX),NY,NX) 
1119  FORMAT(A8,6I4,20E12.4)
C     ENDIF
9690  CONTINUE
9695  CONTINUE
      ENDIF
      MX=M
30    CONTINUE
      RETURN
      END
