
      SUBROUTINE solute(I,J,NHW,NHE,NVN,NVS)
C
C     THIS SUBROUTINE CALCULATES ALL SOLUTE TRANSFORMATIONS
C     FROM THERMODYNAMIC EQUILIBRIA
C
      include "parameters.h"
      include "blkc.h"
      include "blk2a.h"
      include "blk2b.h"
      include "blk2c.h"
      include "blk8a.h"
      include "blk8b.h"
      include "blk10.h"
      include "blk11a.h"
      include "blk11b.h"
      include "blk13a.h"
      include "blk13b.h"
      include "blk13c.h"
      include "blk15a.h"
      include "blk15b.h"
      include "blk18a.h"
      include "blk18b.h"
      include "blk19a.h"
      include "blk19b.h"
      include "blk19c.h"
      include "blk19d.h"
      include "blk21a.h"
      include "blk21b.h"
      DIMENSION SPNH4(2),SPNH3(2),SPNHU(2),SPNO3(2),SPPO4(2)
C
C     EQUILIBRIUM CONSTANTS
C
      PARAMETER (DPH2O=6.5E-09,SYALO=4.0E-21,SYFEO=4.0E-26
     2,SPCAC=4.0E-03,SPCAS=1.4E+01,SPALP=3.5E-15,SPFEP=3.0E-20
     3,SPCAM=7.0E+07,SPCAD=1.0E-01,SPCAH=6.4E-32,SXOH2=4.5E-05
     4,SXOH1=1.1E-06,SYH2P=1.6E+04,SHH2P=SYH2P*DPH2O,SYH1P=1.6E+04
     5,SHH1P=SYH1P*DPH2O,DPCO2=4.2E-04,DPHCO=5.6E-08
     6,DPN4=5.7E-07,DPAL1=8.6E-07,DPAL2=1.8E-08,DPAL3=2.0E-04
     7,DPAL4=8.0E-03,DPALS=0.16,DPFE1=7.1E-10,DPFE2=1.45E-08
     8,DPFE3=1.15E-04,DPFE4=1.45E-03,DPFES=7.1E-02,DPCAO=12.5
     9,DPCAC=4.2E-02,DPCAH=13.5,DPCAS=1.2,DPMGO=0.7,DPMGC=0.3
     1,DPMGH=67.0,DPMGS=2.1,DPNAC=0.45,DPNAS=3.3E+02,DPKAS=5.0E+01
     2,DPH1P=4.5E-10,DPH2P=6.3E-05,DPH3P=7.1,DPF1P=4.5E-02
     3,DPF2P=3.7E-03,DPC0P=3.5E-04,DPC1P=1.82,DPC2P=40.0
     4,DPM1P=1.23,DPCOH=1.0E-02,DPALO=6.3E+04)
      PARAMETER (DPCO3=DPCO2*DPHCO,SHALO=SYALO/DPH2O**3
     2,SYAL1=SYALO/DPAL1,SHAL1=SYAL1/DPH2O**2,SYAL2=SYAL1/DPAL2
     3,SHAL2=SYAL2/DPH2O,SPAL3=SYAL2/DPAL3,SYAL4=SPAL3/DPAL4
     4,SHAL4=SYAL4*DPH2O,SHFEO=SYFEO/DPH2O**3,SYFE1=SYFEO/DPFE1
     5,SHFE1=SYFE1/DPH2O**2,SYFE2=SYFE1/DPFE2,SHFE2=SYFE2/DPH2O
     6,SPFE3=SYFE2/DPFE3,SYFE4=SPFE3/DPFE4,SHFE4=SYFE4*DPH2O
     7,SHCAC1=SPCAC/DPHCO,SYCAC1=SHCAC1*DPH2O,SHCAC2=SHCAC1/DPCO2
     8,SYCAC2=SHCAC2*DPH2O**2,SHA0P1=SPALP/DPH1P,SYA0P1=SHA0P1*DPH2O
     9,SPA1P1=SYA0P1/DPAL1,SYA2P1=SPA1P1/DPAL2,SHA2P1=SYA2P1*DPH2O
     1,SYA3P1=SYA2P1/DPAL3,SHA3P1=SYA3P1*DPH2O**2,SYA4P1=SYA3P1/DPAL4
     2,SHA4P1=SYA4P1*DPH2O**3,SHA0P2=SHA0P1/DPH2P
     3,SYA0P2=SHA0P2*DPH2O**2,SYA1P2=SYA0P2/DPAL1,SHA1P2=SYA1P2/DPH2O
     4,SPA2P2=SYA1P2/DPAL2,SYA3P2=SPA2P2/DPAL3,SHA3P2=SYA3P2*DPH2O
     5,SYA4P2=SYA3P2/DPAL4,SHA4P2=SYA4P2*DPH2O**2)
      PARAMETER (SHF0P1=SPFEP/DPH1P,SYF0P1=SHF0P1*DPH2O
     2,SPF1P1=SYF0P1/DPFE1,SYF2P1=SPF1P1/DPFE2,SHF2P1=SYF2P1*DPH2O
     3,SYF3P1=SYF2P1/DPFE3,SHF3P1=SYF3P1*DPH2O**2,SYF4P1=SYF3P1/DPFE4
     4,SHF4P1=SYF4P1*DPH2O**3,SHF0P2=SHF0P1/DPH2P,SYF0P2=SHF0P2*DPH2O**2
     5,SYF1P2=SYF0P2/DPFE1,SHF1P2=SYF1P2/DPH2O,SPF2P2=SYF1P2/DPFE2
     6,SYF3P2=SPF2P2/DPFE3,SHF3P2=SYF3P2*DPH2O,SYF4P2=SYF3P2/DPFE4
     7,SHF4P2=SYF4P2*DPH2O**2,SHCAD2=SPCAD/DPH2P,SYCAD2=SHCAD2*DPH2O
     8,SHCAH1=SPCAH/(DPH2O*DPH1P**3),SYCAH1=SHCAH1*DPH2O**4
     9,SHCAH2=SHCAH1/DPH2P**3,SYCAH2=SHCAH2*DPH2O**7)
      PARAMETER (MRXN=5,TPD=1.0E-03,TPDX=TPD/MRXN,TADA=1.0E-02
     2,TADAX=TADA/MRXN,TADC=3.3E-01,TADCX=TADC/MRXN
     3,TSL=1.0,TSLX=TSL/MRXN) 
      PARAMETER (DUKM=84.0,DUKI=25.0,A0=1.0,AE=10.0,COOH=2.5E-02
     2,CCAMX=100.0)
      DATA SPNH4/1.0E-00,1.0E-01/,SPNH3/1.0E-00,1.0E-01/
     2,SPNHU/2.5E-02,2.5E-03/,SPNO3/1.0E-00,1.0E-01/
     3,SPPO4/5.0E-03,5.0E-04/
C
C     DUKM FROM SOIL SCI 136:56
C
      NPI=INT(NPH/2)
      DO 9995 NX=NHW,NHE
      DO 9990 NY=NVN,NVS
      DO 9985 L=NU(NY,NX),NL(NY,NX)
      IF(THETW(L,NY,NX).GT.THETY(L,NY,NX))THEN
C
C     WATER VOLUME IN NON-BAND AND BAND SOIL ZONES
C
      VOLWNH=VOLWM(NPH,L,NY,NX)*VLNH4(L,NY,NX)
      VOLWNB=VOLWM(NPH,L,NY,NX)*VLNHB(L,NY,NX)
      VOLWNO=VOLWM(NPH,L,NY,NX)*VLNO3(L,NY,NX)
      VOLWNZ=VOLWM(NPH,L,NY,NX)*VLNOB(L,NY,NX)
      VOLWPO=VOLWM(NPH,L,NY,NX)*VLPO4(L,NY,NX)
      VOLWPB=VOLWM(NPH,L,NY,NX)*VLPOB(L,NY,NX)
C
C     UREA HYDROLYSIS IN BAND AND NON-BAND SOIL ZONES
C
      IF(VOLQ(L,NY,NX).GT.ZEROS(NY,NX))THEN
      COMA=AMIN1(0.1E+06,OMAT(L,NY,NX)/VOLQ(L,NY,NX))
      ELSE
      COMA=0.1E+06
      ENDIF
      DUKD=DUKM*(1.0+COMA/DUKI)
C
C     UREA CONCENTRATION AND HYDROLYSIS IN NON-BAND
C
      IF(ZNHUFA(L,NY,NX).GT.ZEROS(NY,NX)
     2.AND.VOLWM(NPH,L,NY,NX).GT.ZEROS(NY,NX))THEN
      CNHUA=ZNHUFA(L,NY,NX)/VOLWM(NPH,L,NY,NX)
      DFNSA=CNHUA/(CNHUA+DUKD)
      RSNUA=AMIN1(ZNHUFA(L,NY,NX)
     2,SPNHU(IFTYP(NY,NX))*OMAT(L,NY,NX)*DFNSA*TFNQ(L,NY,NX))
      ELSE
      RSNUA=0.0
      ENDIF
C
C     UREA CONCENTRATION AND HYDROLYSIS IN BAND
C
      IF(ZNHUFB(L,NY,NX).GT.ZEROS(NY,NX)
     2.AND.VOLWNB.GT.ZEROS(NY,NX))THEN
      CNHUB=ZNHUFB(L,NY,NX)/VOLWNB
      DFNSB=CNHUB/(CNHUB+DUKD)
      RSNUB=AMIN1(ZNHUFB(L,NY,NX)
     2,SPNHU(IFTYP(NY,NX))*OMAT(L,NY,NX)*DFNSB*TFNQ(L,NY,NX))
      ELSE
      RSNUB=0.0
      ENDIF
C     IF(L.EQ.3)THEN
C     WRITE(*,8888)'UREA',I,J,L,RSNUA,ZNHUFA(L,NY,NX)
C    2,OMAT(L,NY,NX),DFNSA,TFNQ(L,NY,NX),CNHUA,DUKD,DUKM,DUKI,COMA
C    3,VOLQ(L,NY,NX),BKVL(L,NY,NX),SPNHU(IFTYP(NY,NX))
8888  FORMAT(A8,3I4,40E12.4)
C     ENDIF
C
C     NH4, NH3, UREA, NO3 DISSOLUTION IN BAND AND NON-BAND
C     SOIL ZONES FROM FIRST-ORDER FUNCTIONS OF REMAINING
C     FERTILIZER (NOTE: SUPERPHOSPHATE AND ROCK PHOSPHATE
C     ARE REPRESENTED AS MONOCALCIUM PHOSPHATE AND HYDROXYAPATITE
C     MODELLED IN PHOSPHORUS REACTIONS BELOW)
C
      RSN4AA=SPNH4(IFTYP(NY,NX))*ZNH4FA(L,NY,NX)*VLNH4(L,NY,NX)
     2*THETW(L,NY,NX)
      RSN3AA=SPNH3(IFTYP(NY,NX))*ZNH3FA(L,NY,NX)*VLNH4(L,NY,NX)
      RSNUAA=RSNUA*VLNH4(L,NY,NX)*THETW(L,NY,NX) 
      RSNOAA=SPNO3(IFTYP(NY,NX))*ZNO3FA(L,NY,NX)*VLNO3(L,NY,NX)
     2*THETW(L,NY,NX)
      RSN4BA=SPNH4(IFTYP(NY,NX))*ZNH4FA(L,NY,NX)*VLNHB(L,NY,NX)
     2*THETW(L,NY,NX)
      RSN3BA=SPNH3(IFTYP(NY,NX))*ZNH3FA(L,NY,NX)*VLNHB(L,NY,NX)
      RSNUBA=RSNUA*VLNHB(L,NY,NX)*THETW(L,NY,NX) 
      RSNOBA=SPNO3(IFTYP(NY,NX))*ZNO3FA(L,NY,NX)*VLNOB(L,NY,NX)
     2*THETW(L,NY,NX)
      RSN4BB=SPNH4(IFTYP(NY,NX))*ZNH4FB(L,NY,NX)*THETW(L,NY,NX)
      RSN3BB=SPNH3(IFTYP(NY,NX))*ZNH3FB(L,NY,NX) 
      RSNUBB=RSNUB*VLNHB(L,NY,NX)*THETW(L,NY,NX) 
      RSNOBB=SPNO3(IFTYP(NY,NX))*ZNO3FB(L,NY,NX)*THETW(L,NY,NX)
C
C     SOLUBLE AND EXCHANGEABLE NH4 CONCENTRATIONS
C     IN NON-BAND AND BAND SOIL ZONES
C
      IF(VOLWNH.GT.ZEROS(NY,NX))THEN
      VOLWNX=14.0*VOLWNH 
      RN4X=(-TUPNH4(L,NY,NX)+XNH4S(L,NY,NX)+14.0*RSN4AA)/VOLWNX
      RN3X=(-TUPN3S(L,NY,NX)+14.0*RSNUAA)/VOLWNX
      CN41=AMAX1(0.0,ZNH4S(L,NY,NX)/VOLWNX+RN4X)
      CN31=AMAX1(0.0,ZNH3S(L,NY,NX)/VOLWNX+RN3X)
      XN41=AMAX1(0.0,XN4(L,NY,NX)/VOLWNH)
      ELSE
      RN4X=0.0
      RN3X=0.0
      CN41=0.0
      CN31=0.0
      XN41=0.0
      ENDIF
      IF(VOLWNB.GT.ZEROS(NY,NX))THEN
      VOLWNX=14.0*VOLWNB 
      RNBX=(-TUPNHB(L,NY,NX)+XNH4B(L,NY,NX)+14.0*(RSN4BA+RSN4BB))
     2/VOLWNX
      R3BX=(-TUPN3B(L,NY,NX)+14.0*(RSNUBA+RSNUBB))
     2/VOLWNX 
      CN4B=AMAX1(0.0,ZNH4B(L,NY,NX)/VOLWNX+RNBX)
      CN3B=AMAX1(0.0,ZNH3B(L,NY,NX)/VOLWNX+R3BX)
      XN4B=AMAX1(0.0,XNB(L,NY,NX)/VOLWNB)
      ELSE
      RNBX=0.0
      R3BX=0.0
      CN4B=0.0
      CN3B=0.0
      XN4B=0.0
      ENDIF
C
C     SOLUBLE, EXCHANGEABLE AND PRECIPITATED PO4 CONCENTRATIONS IN
C     NON-BAND AND BAND SOIL ZONES
C
      IF(VOLWPO.GT.ZEROS(NY,NX))THEN
      VOLWPX=31.0*VOLWPO
      RH2PX=(XH2PS(L,NY,NX)-TUPH2P(L,NY,NX))/VOLWPX
      CH2P1=AMAX1(0.0,H2PO4(L,NY,NX)/VOLWPX+RH2PX)
      XOH01=AMAX1(0.0,XOH0(L,NY,NX))/VOLWPO
      XOH11=AMAX1(0.0,XOH1(L,NY,NX))/VOLWPO
      XOH21=AMAX1(0.0,XOH2(L,NY,NX))/VOLWPO
      XH1P1=AMAX1(0.0,XH1P(L,NY,NX))/VOLWPO
      XH2P1=AMAX1(0.0,XH2P(L,NY,NX))/VOLWPO
      PCAPM1=AMAX1(0.0,PCAPM(L,NY,NX))/VOLWPO
      PCAPD1=AMAX1(0.0,PCAPD(L,NY,NX))/VOLWPO
      PCAPH1=AMAX1(0.0,PCAPH(L,NY,NX))/VOLWPO
      PALPO1=AMAX1(0.0,PALPO(L,NY,NX))/VOLWPO
      PFEPO1=AMAX1(0.0,PFEPO(L,NY,NX))/VOLWPO
C     WRITE(*,8642)'CH2P1',I,J,L,CH2P1,H2PO4(L,NY,NX)
C    2,VOLWPX,RH2PX,XH2PS(L,NY,NX),TUPH2P(L,NY,NX)
8642  FORMAT(A8,3I4,20E12.4)
      ELSE
      RH2PX=0.0
      CH2P1=0.0
      XOH01=0.0
      XOH11=0.0
      XOH21=0.0
      XH1P1=0.0
      XH2P1=0.0
      PALPO1=0.0
      PFEPO1=0.0
      PCAPM1=0.0
      PCAPD1=0.0
      PCAPH1=0.0
      ENDIF
      IF(VOLWPB.GT.ZEROS(NY,NX))THEN
      VOLWPX=31.0*VOLWPB
      RH2BX=(XH2BS(L,NY,NX)-TUPH2B(L,NY,NX))/VOLWPX
      CH2B1=AMAX1(0.0,H2POB(L,NY,NX)/VOLWPX+RH2BX)
      XH01B=AMAX1(0.0,XOH0B(L,NY,NX))/VOLWPB
      XH11B=AMAX1(0.0,XOH1B(L,NY,NX))/VOLWPB
      XH21B=AMAX1(0.0,XOH2B(L,NY,NX))/VOLWPB
      X1P1B=AMAX1(0.0,XH1PB(L,NY,NX))/VOLWPB
      X2P1B=AMAX1(0.0,XH2PB(L,NY,NX))/VOLWPB
      PALPOB=AMAX1(0.0,PALPB(L,NY,NX))/VOLWPB
      PFEPOB=AMAX1(0.0,PFEPB(L,NY,NX))/VOLWPB
      PCAPMB=AMAX1(0.0,PCPMB(L,NY,NX))/VOLWPB
      PCAPDB=AMAX1(0.0,PCPDB(L,NY,NX))/VOLWPB
      PCAPHB=AMAX1(0.0,PCPHB(L,NY,NX))/VOLWPB
      ELSE
      RH2BX=0.0
      CH2B1=0.0
      XH01B=0.0
      XH11B=0.0
      XH21B=0.0
      X1P1B=0.0
      X2P1B=0.0
      PALPOB=0.0
      PFEPOB=0.0
      PCAPMB=0.0
      PCAPDB=0.0
      PCAPHB=0.0
      ENDIF
C
C     IF SALT OPTION SELECTED IN SITE FILE
C     THEN SOLVE FULL SET OF EQUILIBRIA REACTIONS
C
      IF(ISALT(NY,NX).NE.0)THEN
C
C     SOLUBLE NO3 CONCENTRATIONS
C     IN NON-BAND AND BAND SOIL ZONES
C
      IF(VOLWNO.GT.ZEROS(NY,NX))THEN
      CNO1=AMAX1(0.0,ZNO3S(L,NY,NX)/(14.0*VOLWNO))
      ELSE
      CNO1=0.0
      ENDIF
      IF(VOLWNZ.GT.ZEROS(NY,NX))THEN
      CNOB=AMAX1(0.0,ZNO3B(L,NY,NX)/(14.0*VOLWNZ))
      ELSE
      CNOB=0.0
      ENDIF
      RHY1=XZHYS(L,NY,NX)/VOLWM(NPH,L,NY,NX)
      CHY1=AMAX1(0.0,ZHY(L,NY,NX))/VOLWM(NPH,L,NY,NX)+RHY1
C
C     SOLUTE ION AND ION PAIR CONCENTRATIONS
C
      CCEC=AMAX1(ZERO,XCEC(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      COH1=AMAX1(0.0,ZOH(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CAL1=AMAX1(0.0,ZAL(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CFE1=AMAX1(0.0,ZFE(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CCA1=AMAX1(0.0,ZCA(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CMG1=AMAX1(0.0,ZMG(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CNA1=AMAX1(0.0,ZNA(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CKA1=AMAX1(0.0,ZKA(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CSO41=AMAX1(0.0,ZSO4(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CCL1=AMAX1(0.0,ZCL(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CCO31=AMAX1(0.0,ZCO3(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CHCO31=AMAX1(0.0,ZHCO3(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CCO21=AMAX1(0.0,CO2S(L,NY,NX)/(12.0*VOLWM(NPH,L,NY,NX)))
      CALO1=AMAX1(0.0,ZALOH1(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CALO2=AMAX1(0.0,ZALOH2(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CALO3=AMAX1(0.0,ZALOH3(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CALO4=AMAX1(0.0,ZALOH4(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CALS1=AMAX1(0.0,ZALS(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CFEO1=AMAX1(0.0,ZFEOH1(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CFEO2=AMAX1(0.0,ZFEOH2(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CFEO3=AMAX1(0.0,ZFEOH3(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CFEO4=AMAX1(0.0,ZFEOH4(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CFES1=AMAX1(0.0,ZFES(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CCAO1=AMAX1(0.0,ZCAO(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CCAC1=AMAX1(0.0,ZCAC(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CCAH1=AMAX1(0.0,ZCAH(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CCAS1=AMAX1(0.0,ZCAS(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CMGO1=AMAX1(0.0,ZMGO(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CMGC1=AMAX1(0.0,ZMGC(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CMGH1=AMAX1(0.0,ZMGH(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CMGS1=AMAX1(0.0,ZMGS(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CNAC1=AMAX1(0.0,ZNAC(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CNAS1=AMAX1(0.0,ZNAS(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CKAS1=AMAX1(0.0,ZKAS(L,NY,NX)/VOLWM(NPH,L,NY,NX))
C
C     PO4 CONCENTRATIONS IN NON-BAND AND BAND SOIL ZONES
C
      IF(VOLWPO.GT.ZEROS(NY,NX))THEN
      CH0P1=AMAX1(0.0,H0PO4(L,NY,NX)/VOLWPO)
      CH1P1=AMAX1(0.0,H1PO4(L,NY,NX)/VOLWPO)
      CH3P1=AMAX1(0.0,H3PO4(L,NY,NX)/VOLWPO)
      CF1P1=AMAX1(0.0,ZFE1P(L,NY,NX)/VOLWPO)
      CF2P1=AMAX1(0.0,ZFE2P(L,NY,NX)/VOLWPO)
      CC0P1=AMAX1(0.0,ZCA0P(L,NY,NX)/VOLWPO)
      CC1P1=AMAX1(0.0,ZCA1P(L,NY,NX)/VOLWPO)
      CC2P1=AMAX1(0.0,ZCA2P(L,NY,NX)/VOLWPO)
      CM1P1=AMAX1(0.0,ZMG1P(L,NY,NX)/VOLWPO)
      ELSE
      CH0P1=0.0
      CH1P1=0.0
      CH3P1=0.0
      CF1P1=0.0
      CF2P1=0.0
      CC0P1=0.0
      CC1P1=0.0
      CC2P1=0.0
      CM1P1=0.0
      ENDIF
      IF(VOLWPB.GT.ZEROS(NY,NX))THEN
      CH0PB=AMAX1(0.0,H0POB(L,NY,NX)/VOLWPB)
      CH1PB=AMAX1(0.0,H1POB(L,NY,NX)/VOLWPB)
      CH3PB=AMAX1(0.0,H3POB(L,NY,NX)/VOLWPB)
      CF1PB=AMAX1(0.0,ZFE1PB(L,NY,NX)/VOLWPB)
      CF2PB=AMAX1(0.0,ZFE2PB(L,NY,NX)/VOLWPB)
      CC0PB=AMAX1(0.0,ZCA0PB(L,NY,NX)/VOLWPB)
      CC1PB=AMAX1(0.0,ZCA1PB(L,NY,NX)/VOLWPB)
      CC2PB=AMAX1(0.0,ZCA2PB(L,NY,NX)/VOLWPB)
      CM1PB=AMAX1(0.0,ZMG1PB(L,NY,NX)/VOLWPB)
      ELSE
      CH0PB=0.0
      CH1PB=0.0
      CH3PB=0.0
      CF1PB=0.0
      CF2PB=0.0
      CC0PB=0.0
      CC1PB=0.0
      CC2PB=0.0
      CM1PB=0.0
      ENDIF
C
C     EXCHANGEABLE ION CONCENTRATIONS
C
      XHY1=AMAX1(0.0,XHY(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      XAL1=AMAX1(0.0,XAL(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      XCA1=AMAX1(0.0,XCA(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      XMG1=AMAX1(0.0,XMG(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      XNA1=AMAX1(0.0,XNA(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      XKA1=AMAX1(0.0,XKA(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      XHC1=AMAX1(0.0,XHC(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      XALO21=AMAX1(0.0,XALO2(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      XCOOH=AMAX1(0.0,COOH*ORGC(L,NY,NX)/VOLWM(NPH,L,NY,NX))
C
C     PRECIPITATE CONCENTRATIONS
C
      PALOH1=AMAX1(0.0,PALOH(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      PFEOH1=AMAX1(0.0,PFEOH(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      PCACO1=AMAX1(0.0,PCACO(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      PCASO1=AMAX1(0.0,PCASO(L,NY,NX)/VOLWM(NPH,L,NY,NX))
C
C     CONVERGENCE TOWARDS SOLUTE EQILIBRIA
C
      DO 1000 M=1,MRXN
      CN41=AMAX1(ZERO,CN41)
      CN4B=AMAX1(ZERO,CN4B)
      CN31=AMAX1(ZERO,CN31)
      CN3B=AMAX1(ZERO,CN3B)
      CAL1=AMAX1(ZERO,CAL1)
      CFE1=AMAX1(ZERO,CFE1)
      CHY1=AMAX1(ZERO,CHY1)
      CCA1=AMAX1(ZERO,AMIN1(CCAMX,CCA1))
      CMG1=AMAX1(ZERO,CMG1)
      CNA1=AMAX1(ZERO,CNA1)
      CKA1=AMAX1(ZERO,CKA1)
      COH1=AMAX1(ZERO,COH1)
      CSO41=AMAX1(ZERO,CSO41)
      CCO31=AMAX1(ZERO,CCO31)
      CHCO31=AMAX1(ZERO,CHCO31)
      CCO21=AMAX1(ZERO,CCO21)
      CALO1=AMAX1(ZERO,CALO1)
      CALO2=AMAX1(ZERO,CALO2)
      CALO3=AMAX1(ZERO,CALO3)
      CALO4=AMAX1(ZERO,CALO4)
      CALS1=AMAX1(ZERO,CALS1)
      CFEO1=AMAX1(ZERO,CFEO1)
      CFEO2=AMAX1(ZERO,CFEO2)
      CFEO3=AMAX1(ZERO,CFEO3)
      CFEO4=AMAX1(ZERO,CFEO4)
      CFES1=AMAX1(ZERO,CFES1)
      CCAO1=AMAX1(ZERO,CCAO1)
      CCAC1=AMAX1(ZERO,CCAC1)
      CCAH1=AMAX1(ZERO,CCAH1)
      CCAS1=AMAX1(ZERO,CCAS1)
      CMGO1=AMAX1(ZERO,CMGO1)
      CMGC1=AMAX1(ZERO,CMGC1)
      CMGH1=AMAX1(ZERO,CMGH1)
      CMGS1=AMAX1(ZERO,CMGS1)
      CNAC1=AMAX1(ZERO,CNAC1)
      CNAS1=AMAX1(ZERO,CNAS1)
      CKAS1=AMAX1(ZERO,CKAS1)
      CH0P1=AMAX1(ZERO,CH0P1)
      CH1P1=AMAX1(ZERO,CH1P1)
      CH2P1=AMAX1(ZERO,CH2P1)
      CH3P1=AMAX1(ZERO,CH3P1)
      CF1P1=AMAX1(ZERO,CF1P1)
      CF2P1=AMAX1(ZERO,CF2P1)
      CC0P1=AMAX1(ZERO,CC0P1)
      CC1P1=AMAX1(ZERO,CC1P1)
      CC2P1=AMAX1(ZERO,CC2P1)
      CM1P1=AMAX1(ZERO,CM1P1)
      CH0PB=AMAX1(ZERO,CH0PB)
      CH1PB=AMAX1(ZERO,CH1PB)
      CH2B1=AMAX1(ZERO,CH2B1)
      CH3PB=AMAX1(ZERO,CH3PB)
      CF1PB=AMAX1(ZERO,CF1PB)
      CF2PB=AMAX1(ZERO,CF2PB)
      CC0PB=AMAX1(ZERO,CC0PB)
      CC1PB=AMAX1(ZERO,CC1PB)
      CC2PB=AMAX1(ZERO,CC2PB)
      CM1PB=AMAX1(ZERO,CM1PB)
      XCOO=AMAX1(0.0,XCOOH-XHC1-XALO21)
C
C     IONIC STRENGTH FROM SUMS OF ION CONCENTRATIONS
C
      CC3=CAL1+CFE1
      CA3=CH0P1*VLPO4(L,NY,NX)+CH0PB*VLPOB(L,NY,NX)
      CC2=CCA1+CMG1+CALO1+CFEO1+CF2P1*VLPO4(L,NY,NX)
     2+CF2PB*VLPOB(L,NY,NX)
      CA2=CSO41+CCO31+CH1P1*VLPO4(L,NY,NX)+CH1PB*VLPOB(L,NY,NX)
      CC1=CN41*VLNH4(L,NY,NX)+CN4B*VLNHB(L,NY,NX)+CHY1+CNA1+CKA1
     2+CALO2+CFEO2+CALS1+CFES1+CCAO1+CCAH1+CMGO1+CMGH1
     3+(CF1P1+CC2P1)*VLPO4(L,NY,NX)+(CF1PB+CC2PB)*VLPOB(L,NY,NX)
      CA1=CNO1*VLNO3(L,NY,NX)+CNOB*VLNOB(L,NY,NX)+COH1+CHCO31+CCL1
     2+CALO4+CFEO4+CNAC1+CNAS1+CKAS1+(CH2P1+CC0P1)*VLPO4(L,NY,NX)
     3+(CH2B1+CC0PB)*VLPOB(L,NY,NX)
      CION1=ABS(3.0*(CC3-CA3)+2.0*(CC2-CA2)+CC1-CA1)
      CSTR1=AMAX1(0.0,0.5E-03*(9.0*(CC3+CA3)+4.0*(CC2+CA2)
     2+CC1+CA1+CION1))
      CSTR2=SQRT(CSTR1)
      FSTR2=CSTR2/(1.0+CSTR2)
C
C     ACTIVITY COEFFICIENTS CALCULATED FROM ION STRENGTH
C
      A1=AMIN1(1.0,10.0**(-0.509*1.0*FSTR2+0.20*CSTR2))
      A2=AMIN1(1.0,10.0**(-0.509*4.0*FSTR2+0.20*CSTR2))
      A3=AMIN1(1.0,10.0**(-0.509*9.0*FSTR2+0.20*CSTR2))
      A12=A1**2
      A13=A1**3
      A14=A1**4
      A22=A2**2
      A25=A2**5
      A28=A2**8
      A2Q=A2**0.500
      A3C=A3**0.333
      A0A2=A0*A2
      A0A12=A0/A12
      A0A22=A0/A22
      A0A1A2=A0*A12*A2
      A1A2=A1*A2
      A1A2D=A1/A2
      A1A2QD=A1/A2Q
      A1A3=A1*A3
      A1A3D=A1/A3
      A12A2=A12*A2
      A12A2D=A12/A2
      A12A22=A12/A22
      A12A25=A12/A25
      A12A28=A12/A28
      A1202D=A12/A0A2
      A13A2=A13*A2
      A13A3=A13*A3
      A13A3D=A13/A3
      A14A0=A14/A0
      A14A2=A14*A2
      A14A2D=A14/A2
      A14A0A=A14/A0A2
      A14A5D=A14/A25
      A14A28=A14*A28
      A14A8D=A14/A28
      A1TA25=A1**10*A25
      A2A3=A2*A3
      A2A13D=A2/A1A3
      A1A2A3=A1*A2A3
      A1A23D=A1/A2A3
C
C     PRECIPITATION-DISSOLUTION CALCULATED FROM ACTIVITIES
C     OF REACTANTS AND PRODUCTS THROUGH CONVERGENCE SOLUTIONS
C     FOR THEIR EQUILIBRIUM CONSTANTS USING SOLUTE FORMS
C     CURRENTLY AT HIGHEST CONCENTRATIONS
C
      AHY1=CHY1*A1
      AOH1=COH1*A1
      AAL1=CAL1*A3
      AALO1=CALO1*A2
      AALO2=CALO2*A1
      AALO3=CALO3
      AALO4=CALO4*A1
      AFE1=CFE1*A3
      AFEO1=CFEO1*A2
      AFEO2=CFEO2*A1
      AFEO3=CFEO3
      AFEO4=CFEO4*A1
      ACO31=CCO31*A2
      AHCO31=CHCO31*A1
      ACO21=CCO21*A0
C
C     ALUMINUM HYDROXIDE (GIBBSITE)
C
      PX=AMAX1(AAL1,AALO1,AALO2,AALO3,AALO4)
      IF(PX.EQ.AAL1)THEN
      R2=CHY1
      P2=COH1
      P1=CAL1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP2=3
      SP=SYALO/A13A3
      ELSE
      NR2=3
      NP2=0
      SP=SHALO*A13A3D
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      R2=CHY1
      P2=COH1
      P1=CALO1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP2=2
      SP=SYAL1/A12A2
      ELSE
      NR2=2
      NP2=0
      SP=SHAL1*A12A2D
      ENDIF
      ELSEIF(PX.EQ.AALO2)THEN
      R2=CHY1
      P2=COH1
      P1=CALO2
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP2=1
      SP=SYAL2/A12
      ELSE
      NR2=1
      NP2=0
      SP=SHAL2
      ENDIF
      ELSEIF(PX.EQ.AALO3)THEN
      R2=CHY1
      P2=COH1
      P1=CALO3
      NR2=0
      NP2=0
      SP=SPAL3
      ELSEIF(PX.EQ.AALO4)THEN
      R2=COH1
      P2=CHY1
      P1=CALO4
      IF(AOH1.GT.AHY1)THEN
      NR2=1
      NP2=0
      SP=SYAL4
      ELSE
      NR2=0
      NP2=1
      SP=SHAL4/A12
      ENDIF
      ENDIF
      RYAL1=0.0
      RYALO1=0.0
      RYALO2=0.0
      RYALO3=0.0
      RYALO4=0.0
      RHAL1=0.0
      RHALO1=0.0
      RHALO2=0.0
      RHALO3=0.0
      RHALO4=0.0
      X=0.0
      TX=0.0
      FX=1.0/(1+NR2+NP2)
      DO 1010 MM=1,100
      R2=AMAX1(ZERO,R2+NR2*X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-NP2*X)
      Z=(P1*P2**NP2/R2**NR2)/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1110
      IF(Z.LE.0.95.AND.PALOH1.LE.0.0)GO TO 1110
      IF(NR2.NE.0)THEN
      Y=AMIN1(P1,R2/NR2)
      ELSEIF(NP2.NE.0)THEN
      Y=AMIN1(P1,P2/NP2)
      ELSE
      Y=P1
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**FX
      ELSE
      X=Y*Z**FX-Y
      ENDIF
      TX=TX+X
1010  CONTINUE
1110  CONTINUE
      RPALOX=AMAX1(-PALOH1,TPD*TX)
      IF(PX.EQ.AAL1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYAL1=RPALOX
      ELSE
      RHAL1=RPALOX
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYALO1=RPALOX
      ELSE
      RHALO1=RPALOX
      ENDIF
      ELSEIF(PX.EQ.AALO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYALO2=RPALOX
      ELSE
      RHALO2=RPALOX
      ENDIF
      ELSEIF(PX.EQ.AALO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYALO3=RPALOX
      ELSE
      RHALO3=RPALOX
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYALO4=RPALOX
      ELSE
      RHALO4=RPALOX
      ENDIF
      ENDIF
C     IF((M/10)*10.EQ.M)THEN
C     WRITE(*,1112)'GIBB',I,J,M,MM,PALOH1,CAL1,CALO1,CALO2,CALO3,CALO4
C    2,COH1,R2,P1,P2,SP,Z,TX,RPALOX,RHAL1,RHALO1,RHALO2,RHALO3,RHALO4
C    3,CAL1*A3*(COH1*A1)**3,SYALO
C     ENDIF
C
C     IRON HYDROXIDE
C
      PX=AMAX1(AFE1,AFEO1,AFEO2,AFEO3,AFEO4)
      IF(PX.EQ.AFE1)THEN
      R2=CHY1
      P2=COH1
      P1=CFE1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP2=3
      SP=SYFEO/A13A3
      ELSE
      NR2=3
      NP2=0
      SP=SHFEO*A13A3D
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      R2=CHY1
      P2=COH1
      P1=CFEO1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP2=2
      SP=SYFE1/A12A2
      ELSE
      NR2=2
      NP2=0
      SP=SHFE1*A12A2D
      ENDIF
      ELSEIF(PX.EQ.AFEO2)THEN
      R2=CHY1
      P2=COH1
      P1=CFEO2
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP2=1
      SP=SYFE2/A12
      ELSE
      NR2=1
      NP2=0
      SP=SHFE2
      ENDIF
      ELSEIF(PX.EQ.AFEO3)THEN
      R2=CHY1
      P2=COH1
      P1=CFEO3
      NR2=0
      NP2=0
      SP=SPFE3
      ELSEIF(PX.EQ.AFEO4)THEN
      R2=COH1
      P2=CHY1
      P1=CFEO4
      IF(AOH1.GT.AHY1)THEN
      NR2=1
      NP2=0
      SP=SYFE4
      ELSE
      NR2=0
      NP2=1
      SP=SHFE4/A12
      ENDIF
      ENDIF
      RYFE1=0.0
      RYFEO1=0.0
      RYFEO2=0.0
      RYFEO3=0.0
      RYFEO4=0.0
      RHFE1=0.0
      RHFEO1=0.0
      RHFEO2=0.0
      RHFEO3=0.0
      RHFEO4=0.0
      X=0.0
      TX=0.0
      FX=1.0/(1+NR2+NP2)
      DO 1020 MM=1,100
      R2=AMAX1(ZERO,R2+NR2*X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-NP2*X)
      Z=(P1*P2**NP2/R2**NR2)/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1120
      IF(Z.LE.0.95.AND.PFEOH1.LE.0.0)GO TO 1120
      IF(NR2.NE.0)THEN
      Y=AMIN1(P1,R2/NR2)
      ELSEIF(NP2.NE.0)THEN
      Y=AMIN1(P1,P2/NP2)
      ELSE
      Y=P1
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**FX
      ELSE
      X=Y*Z**FX-Y
      ENDIF
      TX=TX+X
1020  CONTINUE
1120  CONTINUE
      RPFEOX=AMAX1(-PFEOH1,TPD*TX)
      IF(PX.EQ.AFE1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYFE1=RPFEOX
      ELSE
      RHFE1=RPFEOX
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYFEO1=RPFEOX
      ELSE
      RHFEO1=RPFEOX
      ENDIF
      ELSEIF(PX.EQ.AFEO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYFEO2=RPFEOX
      ELSE
      RHFEO2=RPFEOX
      ENDIF
      ELSEIF(PX.EQ.AFEO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYFEO3=RPFEOX
      ELSE
      RHFEO3=RPFEOX
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYFEO4=RPFEOX
      ELSE
      RHFEO4=RPFEOX
      ENDIF
      ENDIF
C     IF((M/10)*10.EQ.M)THEN
C     WRITE(*,1112)'IRON',I,J,M,MM,PFEOH1,CFE1,CFEO1,CFEO2,CFEO3,CFEO4
C    2,COH1,R2,P1,P2,SP,Z,TX,RPFEOX,RHFE1,RHFEO1,RHFEO2,RHFEO3,RHFEO4
C    3,CFE1*A3*(COH1*A1)**3,SYFEO
C     ENDIF
C
C     CALCITE AND GYPSUM
C
      PX=AMAX1(ACO31,AHCO31,ACO21)
      R2=CHY1
      P3=COH1
      P1=CCA1
      IF(PX.EQ.ACO31)THEN
      P2=CCO31
      NR2=0
      NP3=0
      SP=SPCAC/A22
      ELSEIF(PX.EQ.AHCO31)THEN
      P2=CHCO31
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP3=1
      SP=SYCAC1/A12A2
      ELSE
      NR2=1
      NP3=0
      SP=SHCAC1/A2
      ENDIF
      ELSEIF(PX.EQ.ACO21)THEN
      P2=CCO21
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP3=2
      SP=SYCAC2/A0A1A2
      ELSE
      NR2=2
      NP3=0
      SP=SHCAC2*A1202D
      ENDIF
      ENDIF
      RYCAC3=0.0
      RYCACH=0.0
      RYCACO=0.0
      RHCAC3=0.0
      RHCACH=0.0
      RHCACO=0.0
      X=0.0
      TX=0.0
      FX=1.0/(2+NR2+NP3)
      DO 1030 MM=1,100
      R2=AMAX1(ZERO,R2+NR2*X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      P3=AMAX1(ZERO,P3-NP3*X)
      Z=(P1*P2*P3**NP3/R2**NR2)/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1130
      IF(Z.LE.0.95.AND.PCACO1.LE.0.0)GO TO 1130
      IF(NR2.NE.0)THEN
      Y=AMIN1(R2/NR2,P1,P2)
      ELSEIF(NP3.NE.0)THEN
      Y=AMIN1(P1,P2,P3/NP3)
      ELSE
      Y=AMIN1(P1,P2)
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**FX
      ELSE
      X=Y*Z**FX-Y
      ENDIF
      TX=TX+X
1030  CONTINUE
1130  CONTINUE
      RPCACX=AMAX1(-PCACO1,TPD*TX)
      IF(PX.EQ.ACO31)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCAC3=RPCACX
      ELSE
      RHCAC3=RPCACX
      ENDIF
      ELSEIF(PX.EQ.AHCO31)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCACH=RPCACX
      ELSE
      RHCACH=RPCACX
      ENDIF
      ELSEIF(PX.EQ.ACO21)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCACO=RPCACX
      ELSE
      RHCACO=RPCACX
      ENDIF
      ENDIF
      SP=SPCAS/A22
      S0=CCA1+CSO41
      S1=AMAX1(0.0,S0**2-4.0*(CCA1*CSO41-SP))
      RPCASO=AMAX1(-PCASO1,TPDX*(S0-SQRT(S1)))
C     IF((M/10)*10.EQ.M)THEN
C     WRITE(*,1112)'CALC',I,J,M,MM,PCASO1,ACO31,AHCO31,ACO21,CHY1
C    2,COH1,R2,P1,P2,P3,SP,Z,TX,RPCACX,RHCAC3,RHCACH,RHCACO
C    3,CCA1*A2*CCO3*A2,SPCAC
C     ENDIF
C
C     PHOSPHORUS PRECIPITATION-DISSOLUTION IN NON-BAND SOIL ZONE
C
      IF(VOLWPO.GT.ZEROS(NY,NX))THEN
C
C     ALUMINUM PHOSPHATE (VARISCITE)
C
      AH1P1=CH1P1*A2
      AH2P1=CH2P1*A1
      PX=AMAX1(AAL1,AALO1,AALO2,AALO3,AALO4)
      PY=AMAX1(AH1P1,AH2P1)
      R3=CHY1
      R4=COH1
      P3=CHY1
      P4=COH1
      IF(PY.EQ.AH1P1)THEN
      P2=CH1P1
      IF(PX.EQ.AAL1)THEN
      P1=CAL1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=1
      SP=SYA0P1/A1A2A3
      ELSE
      NR3=1
      NR4=0
      NP3=0
      NP4=0
      SP=SHA0P1*A1A23D
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      P1=CALO1
      NR3=0
      NR4=0
      NP3=0
      NP4=0
      SP=SPA1P1/A22
      ELSEIF(PX.EQ.AALO2)THEN
      P1=CALO2
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=1
      NP3=0
      NP4=0
      SP=SYA2P1/A2
      ELSE
      NR3=0
      NR4=0
      NP3=1
      NP4=0
      SP=SHA2P1/A12A2
      ENDIF
      ELSEIF(PX.EQ.AALO3)THEN
      P1=CALO3
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=2
      NP3=0
      NP4=0
      SP=SYA3P1*A12A2D
      ELSE
      NR3=0
      NR4=0
      NP3=2
      NP4=0
      SP=SHA3P1/A13A2
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      P1=CALO4
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=3
      NP3=0
      NP4=0
      SP=SYA4P1*A12A2D
      ELSE
      NR3=0
      NR4=0
      NP3=3
      NP4=0
      SP=SHA4P1*A14A2
      ENDIF
      ENDIF
      ELSE
      P2=CH2P1
      IF(PX.EQ.AAL1)THEN
      P1=CAL1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=2
      SP=SYA0P2/A13A3
      ELSE
      NR3=2
      NR4=0
      NP3=0
      NP4=0
      SP=SHA0P2*A1A3D
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      P1=CALO1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=1
      SP=SYA1P2/A12A2
      ELSE
      NR3=1
      NR4=0
      NP3=0
      NP4=0
      SP=SHA1P2/A2
      ENDIF
      ELSEIF(PX.EQ.AALO2)THEN
      P1=CALO2
      NR3=0
      NR4=0
      NP3=0
      NP4=0
      SP=SPA2P2/A12
      ELSEIF(PX.EQ.AALO3)THEN
      P1=CALO3
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=1
      NP3=0
      NP4=0
      SP=SYA3P2
      ELSE
      NR3=0
      NR4=0
      NP3=1
      NP4=0
      SP=SHA3P2/A22
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      P1=CALO4
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=2
      NP3=0
      NP4=0
      SP=SYA4P2
      ELSE
      NR3=0
      NR4=0
      NP3=2
      NP4=0
      SP=SHA4P2/A14
      ENDIF
      ENDIF
      ENDIF
      RYA0P1=0.0
      RYA1P1=0.0
      RYA2P1=0.0
      RYA3P1=0.0
      RYA4P1=0.0
      RYA0P2=0.0
      RYA1P2=0.0
      RYA2P2=0.0
      RYA3P2=0.0
      RYA4P2=0.0
      RHA0P1=0.0
      RHA1P1=0.0
      RHA2P1=0.0
      RHA3P1=0.0
      RHA4P1=0.0
      RHA0P2=0.0
      RHA1P2=0.0
      RHA2P2=0.0
      RHA3P2=0.0
      RHA4P2=0.0
      X=0.0
      TX=0.0
      FX=1.0/(2+NR3+NR4+NP3+NP4)
      DO 1040 MM=1,100
      R3=AMAX1(ZERO,R3+NR3*X)
      R4=AMAX1(ZERO,R4+NR4*X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      P3=AMAX1(ZERO,P3-NP3*X)
      P4=AMAX1(ZERO,P4-NP4*X)
      Z=(P1*P2*P3**NP3*P4**NP4/(R3**NR3*R4**NR4))/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1140
      IF(Z.LE.0.95.AND.PALPO1.LE.0.0)GO TO 1140
      IF(NR3.NE.0)THEN
      Y=AMIN1(R3/NR3,P1,P2)
      ELSEIF(NR4.NE.0)THEN
      Y=AMIN1(R4/NR4,P1,P2)
      ELSEIF(NP3.NE.0)THEN
      Y=AMIN1(P1,P2,P3/NP3)
      ELSEIF(NP4.NE.0)THEN
      Y=AMIN1(P1,P2,P4/NP4)
      ELSE
      Y=AMIN1(P1,P2)
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**FX
      ELSE
      X=Y*Z**FX-Y
      ENDIF
      TX=TX+X
1040  CONTINUE
1140  CONTINUE
      RPALPX=AMAX1(-PALPO1,TPD*TX)
      IF(PY.EQ.AH1P1)THEN
      IF(PX.EQ.AAL1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA0P1=RPALPX
      ELSE
      RHA0P1=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA1P1=RPALPX
      ELSE
      RHA1P1=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA2P1=RPALPX
      ELSE
      RHA2P1=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA3P1=RPALPX
      ELSE
      RHA3P1=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA4P1=RPALPX
      ELSE
      RHA4P1=RPALPX
      ENDIF
      ENDIF
      ELSE
      IF(PX.EQ.AAL1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA0P2=RPALPX
      ELSE
      RHA0P2=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA1P2=RPALPX
      ELSE
      RHA1P2=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA2P2=RPALPX
      ELSE
      RHA2P2=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA3P2=RPALPX
      ELSE
      RHA3P2=RPALPX
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA4P2=RPALPX
      ELSE
      RHA4P2=RPALPX
      ENDIF
      ENDIF
      ENDIF
C     IF((M/10)*10.EQ.M)THEN
C     WRITE(*,1112)'ALPO4',I,J,M,MM,PALPO1,CAL1,CALO1,CALO2,CALO3,CALO4
C    2,CH1P1,CH2P1,CHY1,COH1,RPALPX,RHA0P1,RHA1P1,RHA2P1,RHA3P1,RHA4P1
C    3,RHA0P2,RHA1P2,RHA2P2,RHA3P2,RHA4P2,R3,R4,P2,P3,P4,SP,Z,TX
1112  FORMAT(A8,4I4,80E12.4)
C     ENDIF
C
C     IRON PHOSPHATE (STRENGITE)
C
      PX=AMAX1(AFE1,AFEO1,AFEO2,AFEO3,AFEO4)
      PY=AMAX1(AH1P1,AH2P1)
      R3=CHY1
      R4=COH1
      P3=CHY1
      P4=COH1
      IF(PY.EQ.AH1P1)THEN
      P2=CH1P1
      IF(PX.EQ.AFE1)THEN
      P1=CFE1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=1
      SP=SYF0P1/A1A2A3
      ELSE
      NR3=1
      NR4=0
      NP3=0
      NP4=0
      SP=SHF0P1*A1A23D
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      P1=CFEO1
      NR3=0
      NR4=0
      NP3=0
      NP4=0
      SP=SPF1P1/A22
      ELSEIF(PX.EQ.AFEO2)THEN
      P1=CFEO2
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=1
      NP3=0
      NP4=0
      SP=SYF2P1/A2
      ELSE
      NR3=0
      NR4=0
      NP3=1
      NP4=0
      SP=SHF2P1/A12A2
      ENDIF
      ELSEIF(PX.EQ.AFEO3)THEN
      P1=CFEO3
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=2
      NP3=0
      NP4=0
      SP=SYF3P1*A12A2D
      ELSE
      NR3=0
      NR4=0
      NP3=2
      NP4=0
      SP=SHF3P1/A13A2
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      P1=CFEO4
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=3
      NP3=0
      NP4=0
      SP=SYF4P1*A12A2D
      ELSE
      NR3=0
      NR4=0
      NP3=3
      NP4=0
      SP=SHF4P1*A14A2
      ENDIF
      ENDIF
      ELSE
      P2=CH2P1
      IF(PX.EQ.AFE1)THEN
      P1=CFE1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=2
      SP=SYF0P2/A13A3
      ELSE
      NR3=2
      NR4=0
      NP3=0
      NP4=0
      SP=SHF0P2*A1A3D
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      P1=CFEO1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=1
      SP=SYF1P2/A12A2
      ELSE
      NR3=1
      NR4=0
      NP3=0
      NP4=0
      SP=SHF1P2/A2
      ENDIF
      ELSEIF(PX.EQ.AFEO2)THEN
      P1=CFEO2
      NR3=0
      NR4=0
      NP3=0
      NP4=0
      SP=SPF2P2/A12
      ELSEIF(PX.EQ.AFEO3)THEN
      P1=CFEO3
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=1
      NP3=0
      NP4=0
      SP=SYF3P2
      ELSE
      NR3=0
      NR4=0
      NP3=1
      NP4=0
      SP=SHF3P2/A22
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      P1=CFEO4
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=2
      NP3=0
      NP4=0
      SP=SYF4P2
      ELSE
      NR3=0
      NR4=0
      NP3=2
      NP4=0
      SP=SHF4P2/A14
      ENDIF
      ENDIF
      ENDIF
      RYF0P1=0.0
      RYF1P1=0.0
      RYF2P1=0.0
      RYF3P1=0.0
      RYF4P1=0.0
      RYF0P2=0.0
      RYF1P2=0.0
      RYF2P2=0.0
      RYF3P2=0.0
      RYF4P2=0.0
      RHF0P1=0.0
      RHF1P1=0.0
      RHF2P1=0.0
      RHF3P1=0.0
      RHF4P1=0.0
      RHF0P2=0.0
      RHF1P2=0.0
      RHF2P2=0.0
      RHF3P2=0.0
      RHF4P2=0.0
      X=0.0
      TX=0.0
      FX=1.0/(2+NR3+NR4+NP3+NP4)
      DO 1050 MM=1,100
      R3=AMAX1(ZERO,R3+NR3*X)
      R4=AMAX1(ZERO,R4+NR4*X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      P3=AMAX1(ZERO,P3-NP3*X)
      P4=AMAX1(ZERO,P4-NP4*X)
      Z=(P1*P2*P3**NP3*P4**NP4/(R3**NR3*R4**NR4))/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1150
      IF(Z.LE.0.95.AND.PFEPO1.LE.0.0)GO TO 1150
      IF(NR3.NE.0)THEN
      Y=AMIN1(R3/NR3,P1,P2)
      ELSEIF(NR4.NE.0)THEN
      Y=AMIN1(R4/NR4,P1,P2)
      ELSEIF(NP3.NE.0)THEN
      Y=AMIN1(P1,P2,P3/NP3)
      ELSEIF(NP4.NE.0)THEN
      Y=AMIN1(P1,P2,P4/NP4)
      ELSE
      Y=AMIN1(P1,P2)
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**FX
      ELSE
      X=Y*Z**FX-Y
      ENDIF
      TX=TX+X
1050  CONTINUE
1150  CONTINUE
      RPFEPX=AMAX1(-PFEPO1,TPD*TX)
      IF(PY.EQ.AH1P1)THEN
      IF(PX.EQ.AFE1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF0P1=RPFEPX
      ELSE
      RHF0P1=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF1P1=RPFEPX
      ELSE
      RHF1P1=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF2P1=RPFEPX
      ELSE
      RHF2P1=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF3P1=RPFEPX
      ELSE
      RHF3P1=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF4P1=RPFEPX
      ELSE
      RHF4P1=RPFEPX
      ENDIF
      ENDIF
      ELSE
      IF(PX.EQ.AFE1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF0P2=RPFEPX
      ELSE
      RHF0P2=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF1P2=RPFEPX
      ELSE
      RHF1P2=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF2P2=RPFEPX
      ELSE
      RHF2P2=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF3P2=RPFEPX
      ELSE
      RHF3P2=RPFEPX
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF4P2=RPFEPX
      ELSE
      RHF4P2=RPFEPX
      ENDIF
      ENDIF
      ENDIF
C     IF((M/10)*10.EQ.M)THEN
C     WRITE(*,1112)'FEPO4',I,J,M,MM,PFEPO1,CFE1,CFEO1,CFEO2,CFEO3,CFEO4
C    2,CH1P1,CH2P1,CHY1,COH1,RPFEPX,RHF0P1,RHF1P1,RHF2P1,RHF3P1,RHF4P1
C    3,RHF0P2,RHF1P2,RHF2P2,RHF3P2,RHF4P2,R3,R4,P2,P3,P4,SP,Z,TX
C     ENDIF
C
C     DICALCIUM PHOSPHATE
C
      PX=AMAX1(AH1P1,AH2P1)
      R2=CHY1
      P3=COH1
      P1=CCA1
      IF(PX.EQ.AH1P1)THEN
      P2=CH1P1
      NR2=0
      NP3=0
      SP=SPCAD/A22
      ELSEIF(PX.EQ.AH2P1)THEN
      P2=CH2P1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP3=1
      SP=SYCAD2/A12A2
      ELSE
      NR2=1
      NP3=0
      SP=SHCAD2/A2
      ENDIF
      ENDIF
      RPCAD1=0.0
      RYCAD2=0.0
      RHCAD2=0.0
      X=0.0
      TX=0.0
      FX=1.0/(2+NR2+NP3)
      DO 1060 MM=1,100
      R2=AMAX1(ZERO,R2+NR2*X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      P3=AMAX1(ZERO,P3-NP3*X)
      Z=(P1*P2*P3**NP3/R2**NR2)/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1160
      IF(Z.LE.0.95.AND.PCAPD1.LE.0.0)GO TO 1160
      IF(NR2.NE.0)THEN
      Y=AMIN1(R2/NR2,P1,P2)
      ELSEIF(NP3.NE.0)THEN
      Y=AMIN1(P1,P2,P3/NP3)
      ELSE
      Y=AMIN1(P1,P2)
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**FX
      ELSE
      X=Y*Z**FX-Y
      ENDIF
      TX=TX+X
1060  CONTINUE
1160  CONTINUE
      RPCADX=AMAX1(-PCAPD1,TPD*TX)
      IF(PX.EQ.AH1P1)THEN
      RPCAD1=RPCADX
      ELSEIF(PX.EQ.AH2P1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCAD2=RPCADX
      ELSE
      RHCAD2=RPCADX
      ENDIF
      ENDIF
C     IF((M/10)*10.EQ.M)THEN
C     WRITE(*,1112)'CAPO4',I,J,M,MM,PCAPM1,PCAPD1,CCA1
C    2,CH1P1,CH2P1,CHY1,COH1,RPCADX,RPCAD1,RYCAD2,RHCAD2,R2,P1,P2,P3
C    3,SP,Z,FX,Y,X,TX,A2,CCA1*A2*CH1P1*A2,SPCAD
C     ENDIF
C
C     HYDROXYAPATITE
C
      PX=AMAX1(AH1P1,AH2P1)
      R2=CHY1
      P3=COH1
      P1=CCA1
      IF(PX.EQ.AH1P1)THEN
      P2=CH1P1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP3=4
      SP=SYCAH1/A14A28
      ELSE
      NR2=4
      NP3=0
      SP=SHCAH1*A14A8D
      ENDIF
      ELSEIF(PX.EQ.AH2P1)THEN
      P2=CH2P1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP3=7
      SP=SYCAH2/A1TA25
      ELSE
      NR2=7
      NP3=0
      SP=SHCAH2*A14A5D
      ENDIF
      ENDIF
      RYCAH1=0.0
      RYCAH2=0.0
      RHCAH1=0.0
      RHCAH2=0.0
      X=0.0
      TX=0.0
      FX=1.0/(6+NR2+NR3)
      DO 1070 MM=1,100
      R2=AMAX1(ZERO,R2+NR2*X)
      P1=AMAX1(ZERO,P1-5.0*X)
      P2=AMAX1(ZERO,P2-3.0*X)
      P3=AMAX1(ZERO,P3-NP3*X)
      Z=(P1**5*P2**3*P3**NP3/R2**NR2)/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1170
      IF(Z.LE.0.95.AND.PCAPH1.LE.0.0)GO TO 1170
      IF(NR2.GT.0)THEN
      Y=AMIN1(R2/NR2,P1/5,P2/3)
      ELSE
      Y=AMIN1(P1/5,P2/3,P3/NP3)
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**FX
      ELSE
      X=Y*Z**FX-Y
      ENDIF
      TX=TX+X
1070  CONTINUE
1170  CONTINUE
      RPCAHX=AMAX1(-PCAPH1,TPD*TX)
      IF(PX.EQ.AH1P1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCAH1=RPCAHX
      ELSE
      RHCAH1=RPCAHX
      ENDIF
      ELSEIF(PX.EQ.AH2P1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCAH2=RPCAHX
      ELSE
      RHCAH2=RPCAHX
      ENDIF
      ENDIF
C     IF((M/10)*10.EQ.M)THEN
C     WRITE(*,1112)'APATITE',I,J,M,MM,PCAPH1,CCA1
C    2,CH1P1,CH2P1,CHY1,RPCAHX,RHCAH1,RHCAH2,R2,P1,P2,P3
C    3,SP,Z,(CCA1*A2)**5*(CH0P1*A3)**3*COH1*A1,SPCAH
C     ENDIF
C
C     MONOCALCIUM PHOSPHATE
C
      P1=CCA1
      P2=CH2P1
      SP=SPCAM/A12A2
      X=0.0
      TX=0.0
      DO 1080 MM=1,100
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-2*X)
      Z=P1*P2**2/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 1180
      IF(Z.LE.0.95.AND.PCAPM1.LE.0.0)GO TO 1180
      Y=AMIN1(P1,P2/2)
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.33
      ELSE
      X=Y*Z**0.33-Y
      ENDIF
      TX=TX+X
1080  CONTINUE
1180  CONTINUE
      RPCAMX=AMAX1(-PCAPM1*SPPO4(IFTYP(NY,NX)),TPD*TX)
      ELSE
      RPALPX=0.0
      RPFEPX=0.0
      RPCADX=0.0
      RPCAHX=0.0
      RYA0P1=0.0
      RYA1P1=0.0
      RYA2P1=0.0
      RYA3P1=0.0
      RYA4P1=0.0
      RYA0P2=0.0
      RYA1P2=0.0
      RYA2P2=0.0
      RYA3P2=0.0
      RYA4P2=0.0
      RHA0P1=0.0
      RHA1P1=0.0
      RHA2P1=0.0
      RHA3P1=0.0
      RHA4P1=0.0
      RHA0P2=0.0
      RHA1P2=0.0
      RHA2P2=0.0
      RHA3P2=0.0
      RHA4P2=0.0
      RYF0P1=0.0
      RYF1P1=0.0
      RYF2P1=0.0
      RYF3P1=0.0
      RYF4P1=0.0
      RYF0P2=0.0
      RYF1P2=0.0
      RYF2P2=0.0
      RYF3P2=0.0
      RYF4P2=0.0
      RHF0P1=0.0
      RHF1P1=0.0
      RHF2P1=0.0
      RHF3P1=0.0
      RHF4P1=0.0
      RHF0P2=0.0
      RHF1P2=0.0
      RHF2P2=0.0
      RHF3P2=0.0
      RHF4P2=0.0
      RPCAD1=0.0
      RYCAD2=0.0
      RHCAD2=0.0
      RYCAH1=0.0
      RYCAH2=0.0
      RHCAH1=0.0
      RHCAH2=0.0
      RPCAMX=0.0
      ENDIF
C
C     PHOSPHORUS PRECIPITATION-DISSOLUTION IN BAND SOIL ZONE
C
      IF(VOLWPB.GT.ZEROS(NY,NX))THEN
C
C     ALUMINUM PHOSPHATE (VARISCITE)
C
      AH1PB=CH1PB*A2
      AH2PB=CH2B1*A1
      PX=AMAX1(AAL1,AALO1,AALO2,AALO3,AALO4)
      PY=AMAX1(AH1PB,AH2PB)
      R3=CHY1
      R4=COH1
      P3=CHY1
      P4=COH1
      IF(PY.EQ.AH1PB)THEN
      P2=CH1PB
      IF(PX.EQ.AAL1)THEN
      P1=CAL1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=1
      SP=SYA0P1/A1A2A3
      ELSE
      NR3=1
      NR4=0
      NP3=0
      NP4=0
      SP=SHA0P1*A1A23D
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      P1=CALO1
      NR3=0
      NR4=0
      NP3=0
      NP4=0
      SP=SPA1P1/A22
      ELSEIF(PX.EQ.AALO2)THEN
      P1=CALO2
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=1
      NP3=0
      NP4=0
      SP=SYA2P1/A2
      ELSE
      NR3=0
      NR4=0
      NP3=1
      NP4=0
      SP=SHA2P1/A12A2
      ENDIF
      ELSEIF(PX.EQ.AALO3)THEN
      P1=CALO3
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=2
      NP3=0
      NP4=0
      SP=SYA3P1*A12A2D
      ELSE
      NR3=0
      NR4=0
      NP3=2
      NP4=0
      SP=SHA3P1/A13A2
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      P1=CALO4
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=3
      NP3=0
      NP4=0
      SP=SYA4P1*A12A2D
      ELSE
      NR3=0
      NR4=0
      NP3=3
      NP4=0
      SP=SHA4P1*A14A2
      ENDIF
      ENDIF
      ELSE
      P2=CH2B1
      IF(PX.EQ.AAL1)THEN
      P1=CAL1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=2
      SP=SYA0P2/A13A3
      ELSE
      NR3=2
      NR4=0
      NP3=0
      NP4=0
      SP=SHA0P2*A1A3D
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      P1=CALO1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=1
      SP=SYA1P2/A12A2
      ELSE
      NR3=1
      NR4=0
      NP3=0
      NP4=0
      SP=SHA1P2/A2
      ENDIF
      ELSEIF(PX.EQ.AALO2)THEN
      P1=CALO2
      NR3=0
      NR4=0
      NP3=0
      NP4=0
      SP=SPA2P2/A12
      ELSEIF(PX.EQ.AALO3)THEN
      P1=CALO3
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=1
      NP3=0
      NP4=0
      SP=SYA3P2
      ELSE
      NR3=0
      NR4=0
      NP3=1
      NP4=0
      SP=SHA3P2/A22
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      P1=CALO4
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=2
      NP3=0
      NP4=0
      SP=SYA4P2
      ELSE
      NR3=0
      NR4=0
      NP3=2
      NP4=0
      SP=SHA4P2/A14
      ENDIF
      ENDIF
      ENDIF
      RYA0B1=0.0
      RYA1B1=0.0
      RYA2B1=0.0
      RYA3B1=0.0
      RYA4B1=0.0
      RYA0B2=0.0
      RYA1B2=0.0
      RYA2B2=0.0
      RYA3B2=0.0
      RYA4B2=0.0
      RHA0B1=0.0
      RHA1B1=0.0
      RHA2B1=0.0
      RHA3B1=0.0
      RHA4B1=0.0
      RHA0B2=0.0
      RHA1B2=0.0
      RHA2B2=0.0
      RHA3B2=0.0
      RHA4B2=0.0
      X=0.0
      TX=0.0
      FX=1.0/(2+NR3+NR4+NP3+NP4)
      DO 2040 MM=1,100
      R3=AMAX1(ZERO,R3+NR3*X)
      R4=AMAX1(ZERO,R4+NR4*X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      P3=AMAX1(ZERO,P3-NP3*X)
      P4=AMAX1(ZERO,P4-NP4*X)
      Z=(P1*P2*P3**NP3*P4**NP4/(R3**NR3*R4**NR4))/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 2140
      IF(Z.LE.0.95.AND.PALPOB.LE.0.0)GO TO 2140
      IF(NR3.NE.0)THEN
      Y=AMIN1(R3/NR3,P1,P2)
      ELSEIF(NR4.NE.0)THEN
      Y=AMIN1(R4/NR4,P1,P2)
      ELSEIF(NP3.NE.0)THEN
      Y=AMIN1(P1,P2,P3/NP3)
      ELSEIF(NP4.NE.0)THEN
      Y=AMIN1(P1,P2,P4/NP4)
      ELSE
      Y=AMIN1(P1,P2)
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**FX
      ELSE
      X=Y*Z**FX-Y
      ENDIF
      TX=TX+X
2040  CONTINUE
2140  CONTINUE
      RPALBX=AMAX1(-PALPOB,TPD*TX)
      IF(PY.EQ.AH1PB)THEN
      IF(PX.EQ.AAL1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA0B1=RPALBX
      ELSE
      RHA0B1=RPALBX
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA1B1=RPALBX
      ELSE
      RHA1B1=RPALBX
      ENDIF
      ELSEIF(PX.EQ.AALO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA2B1=RPALBX
      ELSE
      RHA2B1=RPALBX
      ENDIF
      ELSEIF(PX.EQ.AALO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA3B1=RPALBX
      ELSE
      RHA3B1=RPALBX
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA4B1=RPALBX
      ELSE
      RHA4B1=RPALBX
      ENDIF
      ENDIF
      ELSE
      IF(PX.EQ.AAL1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA0B2=RPALBX
      ELSE
      RHA0B2=RPALBX
      ENDIF
      ELSEIF(PX.EQ.AALO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA1B2=RPALBX
      ELSE
      RHA1B2=RPALBX
      ENDIF
      ELSEIF(PX.EQ.AALO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA2B2=RPALBX
      ELSE
      RHA2B2=RPALBX
      ENDIF
      ELSEIF(PX.EQ.AALO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA3B2=RPALBX
      ELSE
      RHA3B2=RPALBX
      ENDIF
      ELSEIF(PX.EQ.AALO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYA4B2=RPALBX
      ELSE
      RHA4B2=RPALBX
      ENDIF
      ENDIF
      ENDIF
C
C     IRON PHOSPHATE (STRENGITE)
C
      PX=AMAX1(AFE1,AFEO1,AFEO2,AFEO3,AFEO4)
      PY=AMAX1(AH1PB,AH2PB)
      R3=CHY1
      R4=COH1
      P3=CHY1
      P4=COH1
      IF(PY.EQ.AH1PB)THEN
      P2=CH1PB
      IF(PX.EQ.AFE1)THEN
      P1=CFE1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=1
      SP=SYF0P1/A1A2A3
      ELSE
      NR3=1
      NR4=0
      NP3=0
      NP4=0
      SP=SHF0P1*A1A23D
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      P1=CFEO1
      NR3=0
      NR4=0
      NP3=0
      NP4=0
      SP=SPF1P1/A22
      ELSEIF(PX.EQ.AFEO2)THEN
      P1=CFEO2
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=1
      NP3=0
      NP4=0
      SP=SYF2P1/A2
      ELSE
      NR3=0
      NR4=0
      NP3=1
      NP4=0
      SP=SHF2P1/A12A2
      ENDIF
      ELSEIF(PX.EQ.AFEO3)THEN
      P1=CFEO3
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=2
      NP3=0
      NP4=0
      SP=SYF3P1*A12A2D
      ELSE
      NR3=0
      NR4=0
      NP3=2
      NP4=0
      SP=SHF3P1/A13A2
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      P1=CFEO4
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=3
      NP3=0
      NP4=0
      SP=SYF4P1*A12A2D
      ELSE
      NR3=0
      NR4=0
      NP3=3
      NP4=0
      SP=SHF4P1*A14A2
      ENDIF
      ENDIF
      ELSE
      P2=CH2B1
      IF(PX.EQ.AFE1)THEN
      P1=CFE1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=2
      SP=SYF0P2/A13A3
      ELSE
      NR3=2
      NR4=0
      NP3=0
      NP4=0
      SP=SHF0P2*A1A3D
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      P1=CFEO1
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=0
      NP3=0
      NP4=1
      SP=SYF1P2/A12A2
      ELSE
      NR3=1
      NR4=0
      NP3=0
      NP4=0
      SP=SHF1P2/A2
      ENDIF
      ELSEIF(PX.EQ.AFEO2)THEN
      P1=CFEO2
      NR3=0
      NR4=0
      NP3=0
      NP4=0
      SP=SPF2P2/A12
      ELSEIF(PX.EQ.AFEO3)THEN
      P1=CFEO3
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=1
      NP3=0
      NP4=0
      SP=SYF3P2
      ELSE
      NR3=0
      NR4=0
      NP3=1
      NP4=0
      SP=SHF3P2/A22
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      P1=CFEO4
      IF(AOH1.GT.AHY1)THEN
      NR3=0
      NR4=2
      NP3=0
      NP4=0
      SP=SYF4P2
      ELSE
      NR3=0
      NR4=0
      NP3=2
      NP4=0
      SP=SHF4P2/A14
      ENDIF
      ENDIF
      ENDIF
      RYF0B1=0.0
      RYF1B1=0.0
      RYF2B1=0.0
      RYF3B1=0.0
      RYF4B1=0.0
      RYF0B2=0.0
      RYF1B2=0.0
      RYF2B2=0.0
      RYF3B2=0.0
      RYF4B2=0.0
      RHF0B1=0.0
      RHF1B1=0.0
      RHF2B1=0.0
      RHF3B1=0.0
      RHF4B1=0.0
      RHF0B2=0.0
      RHF1B2=0.0
      RHF2B2=0.0
      RHF3B2=0.0
      RHF4B2=0.0
      X=0.0
      TX=0.0
      FX=1.0/(2+NR3+NR4+NP3+NP4)
      DO 2050 MM=1,100
      R3=AMAX1(ZERO,R3+NR3*X)
      R4=AMAX1(ZERO,R4+NR4*X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      P3=AMAX1(ZERO,P3-NP3*X)
      P4=AMAX1(ZERO,P4-NP4*X)
      Z=(P1*P2*P3**NP3*P4**NP4/(R3**NR3*R4**NR4))/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 2150
      IF(Z.LE.0.95.AND.PFEPOB.LE.0.0)GO TO 2150
      IF(NR3.NE.0)THEN
      Y=AMIN1(R3/NR3,P1,P2)
      ELSEIF(NR4.NE.0)THEN
      Y=AMIN1(R4/NR4,P1,P2)
      ELSEIF(NP3.NE.0)THEN
      Y=AMIN1(P1,P2,P3/NP3)
      ELSEIF(NP4.NE.0)THEN
      Y=AMIN1(P1,P2,P4/NP4)
      ELSE
      Y=AMIN1(P1,P2)
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**FX
      ELSE
      X=Y*Z**FX-Y
      ENDIF
      TX=TX+X
2050  CONTINUE
2150  CONTINUE
      RPFEBX=AMAX1(-PFEPOB,TPD*TX)
      IF(PY.EQ.AH1PB)THEN
      IF(PX.EQ.AFE1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF0B1=RPFEBX
      ELSE
      RHF0B1=RPFEBX
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF1B1=RPFEBX
      ELSE
      RHF1B1=RPFEBX
      ENDIF
      ELSEIF(PX.EQ.AFEO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF2B1=RPFEBX
      ELSE
      RHF2B1=RPFEBX
      ENDIF
      ELSEIF(PX.EQ.AFEO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF3B1=RPFEBX
      ELSE
      RHF3B1=RPFEBX
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF4B1=RPFEBX
      ELSE
      RHF4B1=RPFEBX
      ENDIF
      ENDIF
      ELSE
      IF(PX.EQ.AFE1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF0B2=RPFEBX
      ELSE
      RHF0B2=RPFEBX
      ENDIF
      ELSEIF(PX.EQ.AFEO1)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF1B2=RPFEBX
      ELSE
      RHF1B2=RPFEBX
      ENDIF
      ELSEIF(PX.EQ.AFEO2)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF2B2=RPFEBX
      ELSE
      RHF2B2=RPFEBX
      ENDIF
      ELSEIF(PX.EQ.AFEO3)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF3B2=RPFEBX
      ELSE
      RHF3B2=RPFEBX
      ENDIF
      ELSEIF(PX.EQ.AFEO4)THEN
      IF(AOH1.GT.AHY1)THEN
      RYF4B2=RPFEBX
      ELSE
      RHF4B2=RPFEBX
      ENDIF
      ENDIF
      ENDIF
C
C     DICALCIUM PHOSPHATE
C
      PX=AMAX1(AH1PB,AH2PB)
      R2=CHY1
      P3=COH1
      P1=CCA1
      IF(PX.EQ.AH1PB)THEN
      P2=CH1PB
      NR2=0
      NP3=0
      SP=SPCAD/A22
      ELSEIF(PX.EQ.AH2PB)THEN
      P2=CH2B1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP3=1
      SP=SYCAD2/A12A2
      ELSE
      NR2=1
      NP3=0
      SP=SHCAD2/A2
      ENDIF
      ENDIF
      RPCDB1=0.0
      RYCDB2=0.0
      RHCDB2=0.0
      X=0.0
      TX=0.0
      FX=1.0/(2+NR2+NP3)
      DO 2060 MM=1,100
      R2=AMAX1(ZERO,R2+NR2*X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      P3=AMAX1(ZERO,P3-NP3*X)
      Z=(P1*P2*P3**NP3/R2**NR2)/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 2160
      IF(Z.LE.0.95.AND.PCAPDB.LE.0.0)GO TO 2160
      IF(NR2.NE.0)THEN
      Y=AMIN1(R2/NR2,P1,P2)
      ELSEIF(NP3.NE.0)THEN
      Y=AMIN1(P1,P2,P3/NP3)
      ELSE
      Y=AMIN1(P1,P2)
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**FX
      ELSE
      X=Y*Z**FX-Y
      ENDIF
      TX=TX+X
2060  CONTINUE
2160  CONTINUE
      RPCDBX=AMAX1(-PCAPDB,TPD*TX)
      IF(PX.EQ.AH1PB)THEN
      RPCDB1=RPCDBX
      ELSEIF(PX.EQ.AH2PB)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCDB2=RPCDBX
      ELSE
      RHCDB2=RPCDBX
      ENDIF
      ENDIF
C
C     HYDROXYAPATITE
C
      PX=AMAX1(AH1PB,AH2PB)
      R2=CHY1
      P3=COH1
      P1=CCA1
      IF(PX.EQ.AH1PB)THEN
      P2=CH1PB
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP3=4
      SP=SYCAH1/A14A28
      ELSE
      NR2=4
      NP3=0
      SP=SHCAH1*A14A8D
      ENDIF
      ELSEIF(PX.EQ.AH2PB)THEN
      P2=CH2B1
      IF(AOH1.GT.AHY1)THEN
      NR2=0
      NP3=7
      SP=SYCAH2/A1TA25
      ELSE
      NR2=7
      NP3=0
      SP=SHCAH2*A14A5D
      ENDIF
      ENDIF
      RYCHB1=0.0
      RYCHB2=0.0
      RHCHB1=0.0
      RHCHB2=0.0
      X=0.0
      TX=0.0
      FX=1.0/(6+NR2+NR3)
      DO 2070 MM=1,100
      R2=AMAX1(ZERO,R2+NR2*X)
      P1=AMAX1(ZERO,P1-5.0*X)
      P2=AMAX1(ZERO,P2-3.0*X)
      P3=AMAX1(ZERO,P3-NP3*X)
      Z=(P1**5*P2**3*P3**NP3/R2**NR2)/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 2170
      IF(Z.LE.0.95.AND.PCAPHB.LE.0.0)GO TO 2170
      IF(NR2.GT.0)THEN
      Y=AMIN1(R2/NR2,P1/5,P2/3)
      ELSE
      Y=AMIN1(P1/5,P2/3,P3/NP3)
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**FX
      ELSE
      X=Y*Z**FX-Y
      ENDIF
      TX=TX+X
2070  CONTINUE
2170  CONTINUE
      RPCHBX=AMAX1(-PCAPHB,TPD*TX)
      IF(PX.EQ.AH1PB)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCHB1=RPCHBX
      ELSE
      RHCHB1=RPCHBX
      ENDIF
      ELSEIF(PX.EQ.AH2PB)THEN
      IF(AOH1.GT.AHY1)THEN
      RYCHB2=RPCHBX
      ELSE
      RHCHB2=RPCHBX
      ENDIF
      ENDIF
C
C     MONOCALCIUM PHOSPHATE
C
      P1=CCA1
      P2=CH2B1
      SP=SPCAM/A12A2
      X=0.0
      TX=0.0
      DO 2080 MM=1,100
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-2*X)
      Z=P1*P2**2/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 2180
      IF(Z.LE.0.95.AND.PCAPMB.LE.0.0)GO TO 2180
      Y=AMIN1(P1,P2/2)
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.33
      ELSE
      X=Y*Z**0.33-Y
      ENDIF
      TX=TX+X
2080  CONTINUE
2180  CONTINUE
      RPCMBX=AMAX1(-PCAPMB*SPPO4(IFTYP(NY,NX)),TPD*TX)
      ELSE
      RPALBX=0.0
      RPFEBX=0.0
      RPCDBX=0.0
      RPCHBX=0.0
      RPCMBX=0.0
      RYA0B1=0.0
      RYA1B1=0.0
      RYA2B1=0.0
      RYA3B1=0.0
      RYA4B1=0.0
      RYA0B2=0.0
      RYA1B2=0.0
      RYA2B2=0.0
      RYA3B2=0.0
      RYA4B2=0.0
      RHA0B1=0.0
      RHA1B1=0.0
      RHA2B1=0.0
      RHA3B1=0.0
      RHA4B1=0.0
      RHA0B2=0.0
      RHA1B2=0.0
      RHA2B2=0.0
      RHA3B2=0.0
      RHA4B2=0.0
      RYF0B1=0.0
      RYF1B1=0.0
      RYF2B1=0.0
      RYF3B1=0.0
      RYF4B1=0.0
      RYF0B2=0.0
      RYF1B2=0.0
      RYF2B2=0.0
      RYF3B2=0.0
      RYF4B2=0.0
      RHF0B1=0.0
      RHF1B1=0.0
      RHF2B1=0.0
      RHF3B1=0.0
      RHF4B1=0.0
      RHF0B2=0.0
      RHF1B2=0.0
      RHF2B2=0.0
      RHF3B2=0.0
      RHF4B2=0.0
      RPCDB1=0.0
      RYCDB2=0.0
      RHCDB2=0.0
      RYCHB1=0.0
      RYCHB2=0.0
      RHCHB1=0.0
      RHCHB2=0.0
      ENDIF
C
C     PHOSPHORUS ANION EXCHANGE IN NON-BAND SOIL ZONE
C     CALCULATED FROM EXCHANGE EQUILIBRIA AMONG H2PO4-,
C     HPO4--, H+, OH- AND PROTONATED AND NON-PROTONATED -OH
C     EXCHANGE SITES
C
      IF(VOLWPO.GT.ZEROS(NY,NX)
     2.AND.AEC(L,NY,NX).GT.ZEROS(NY,NX))THEN
C

C     PROTONATION OF ANION EXCHANGE SITES IN NON-BAND SOIL ZONE
C
      DCHG=AMAX1(-0.1E+05,XOH21-XOH01-XH1P1)
      AEP=EXP(AE*DCHG/TKS(L,NY,NX))
      AEN=EXP(-AE*DCHG/TKS(L,NY,NX))
      SPOH2=SXOH2*AEP/A1
      X0=XOH11+CHY1+SPOH2
      X1=AMAX1(0.0,X0**2-4.0*(XOH11*CHY1-SPOH2*XOH21))
      RXOH2=TADAX*(X0-SQRT(X1))
      SPOH1=SXOH1/(AEN*A1)
      X0=XOH01+CHY1+SPOH1
      X1=AMAX1(0.0,X0**2-4.0*(XOH01*CHY1-SPOH1*XOH11))
      RXOH1=TADAX*(X0-SQRT(X1))
C
C     H2PO4 EXCHANGE IN NON-BAND SOIL ZONE FROM CONVERGENCE
C     SOLUTION FOR EQUILIBRIUM AMONG H2PO4-, H+, OH-, X-OH
C     AND X-H2PO4
C
      SPH2P=SYH2P*DPH2O/(SXOH2*AEP*A1)
      X0=XOH21+CH2P1+SPH2P
      X1=AMAX1(0.0,X0**2-4.0*(XOH21*CH2P1-SPH2P*XH2P1))
      RXH2P=TADAX*(X0-SQRT(X1))
      R1=XH2P1
      R2=COH1
      P1=XOH11
      P2=CH2P1
      P3=CHY1
      IF(AOH1.GT.AHY1)THEN
      NR2=1
      NP3=0
      SP=SYH2P
      ELSE
      NR2=0
      NP3=1
      SP=SHH2P/A12
      ENDIF
      RYH2P=0.0
      RHH2P=0.0
      X=0.0
      TX=0.0
      DO 4010 MM=1,100
      R1=AMAX1(ZERO,R1+X)
      R2=AMAX1(ZERO,R2+NR2*X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      P3=AMAX1(ZERO,P3-NP3*X)
      Z=(P1*P2*P3**NP3/(R1*R2**NR2))/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 4110
      IF(NR2.GT.0)THEN
      Y=AMIN1(R1,R2/NR2,P1,P2)
      ELSE
      Y=AMIN1(R1,P1,P2,P3/NP3)
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.25
      ELSE
      X=Y*Z**0.25-Y
      ENDIF
      TX=TX+X
4010  CONTINUE
4110  CONTINUE
      IF(AOH1.GT.AHY1)THEN
      RYH2P=TADAX*TX
      ELSE
      RHH2P=TADAX*TX
      ENDIF
C
C     HPO4 EXCHANGE IN NON-BAND SOIL ZONE FROM CONVERGENCE
C     SOLUTION FOR EQUILIBRIUM AMONG HPO4--, H+, OH-, X-OH
C     AND X-HPO4
C
      R1=XH1P1
      R2=COH1
      P1=XOH11
      P2=CH1P1
      P3=CHY1
      IF(AOH1.GT.AHY1)THEN
      NR2=1
      NP3=0
      SP=SYH1P*AEN*A1A2D
      ELSE
      NR2=0
      NP3=1
      SP=SHH1P*AEN/A1A2
      ENDIF
      RYH1P=0.0
      RHH1P=0.0
      X=0.0
      TX=0.0
      DO 4020 MM=1,100
      R1=AMAX1(ZERO,R1+X)
      R2=AMAX1(ZERO,R2+NR2*X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      P3=AMAX1(ZERO,P3-NP3*X)
      Z=(P1*P2*P3**NP3/(R1*R2**NR2))/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 4120
      IF(NR2.GT.0)THEN
      Y=AMIN1(R1,R2/NR2,P1,P2)
      ELSE
      Y=AMIN1(R1,P1,P2,P3/NP3)
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.25
      ELSE
      X=Y*Z**0.25-Y
      ENDIF
      TX=TX+X
4020  CONTINUE
4120  CONTINUE
      IF(AOH1.GT.AHY1)THEN
      RYH1P=TADAX*TX
      ELSE
      RHH1P=TADAX*TX
      ENDIF
      ELSE
      RXOH2=0.0
      RXOH1=0.0
      RXH2P=0.0
      RYH2P=0.0
      RYH1P=0.0
      RHH2P=0.0
      RHH1P=0.0
      ENDIF
C
C     PHOSPHORUS ANION EXCHANGE IN BAND SOIL ZONE
C     CALCULATED FROM EXCHANGE EQUILIBRIA AMONG H2PO4-,
C     HPO4--, H+, OH- AND PROTONATED AND NON-PROTONATED -OH
C     EXCHANGE SITES
C
      IF(VOLWPB.GT.ZEROS(NY,NX)
     2.AND.AEC(L,NY,NX).GT.ZEROS(NY,NX))THEN
C
C     PROTONATION OF EXCHANGE SITES IN BAND SOIL ZONE
C
      DCHG=AMAX1(-0.1E+05,XH21B-XH01B-X1P1B)
      AEP=EXP(AE*DCHG/TKS(L,NY,NX))
      AEN=EXP(-AE*DCHG/TKS(L,NY,NX))
      SPOH2=SXOH2*AEP/A1

      X0=XH11B+CHY1+SPOH2
      X1=AMAX1(0.0,X0**2-4.0*(XH11B*CHY1-SPOH2*XH21B))
      RXO2B=TADAX*(X0-SQRT(X1))
      SPOH1=SXOH1/(AEN*A1)
      X0=XH01B+CHY1+SPOH1
      X1=AMAX1(0.0,X0**2-4.0*(XH01B*CHY1-SPOH1*XH11B))
      RXO1B=TADAX*(X0-SQRT(X1))
C
C     H2PO4 EXCHANGE IN BAND SOIL ZONE FROM CONVERGENCE
C     SOLUTION FOR EQUILIBRIUM AMONG H2PO4-, H+, OH-, X-OH
C     AND X-H2PO4
C
      SPH2P=SYH2P*DPH2O/(SXOH2*AEP*A1)
      X0=XH21B+CH2B1+SPH2P
      X1=AMAX1(0.0,X0**2-4.0*(XH21B*CH2B1-SPH2P*X2P1B))
      RXH2B=TADAX*(X0-SQRT(X1))
      R1=X2P1B
      R2=COH1
      P1=XH11B
      P2=CH2B1
      P3=CHY1
      IF(AOH1.GT.AHY1)THEN
      NR2=1
      NP3=0
      SP=SYH2P
      ELSE
      NR2=0
      NP3=1
      SP=SHH2P/A12
      ENDIF
      RYH2B=0.0
      RHH2B=0.0
      X=0.0
      TX=0.0
      DO 5010 MM=1,100
      R1=AMAX1(ZERO,R1+X)
      R2=AMAX1(ZERO,R2+NR2*X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      P3=AMAX1(ZERO,P3-NP3*X)
      Z=(P1*P2*P3**NP3/(R1*R2**NR2))/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 5110
      IF(NR2.GT.0)THEN
      Y=AMIN1(R1,R2/NR2,P1,P2)
      ELSE
      Y=AMIN1(R1,P1,P2,P3/NP3)
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.25
      ELSE
      X=Y*Z**0.25-Y
      ENDIF
      TX=TX+X
5010  CONTINUE
5110  CONTINUE
      IF(AOH1.GT.AHY1)THEN
      RYH2B=TADAX*TX
      ELSE
      RHH2B=TADAX*TX
      ENDIF
C
C     HPO4 EXCHANGE IN BAND SOIL ZONE FROM CONVERGENCE
C     SOLUTION FOR EQUILIBRIUM AMONG HPO4--, H+, OH-, X-OH
C     AND X-HPO4
C
      R1=X1P1B
      R2=COH1
      P1=XH11B
      P2=CH1PB
      P3=CHY1
      IF(AOH1.GT.AHY1)THEN
      NR2=1
      NP3=0
      SP=SYH1P*AEN*A1A2D
      ELSE
      NR2=0
      NP3=1
      SP=SHH1P*AEN/A1A2
      ENDIF
      RYH1B=0.0
      RHH1B=0.0
      X=0.0
      TX=0.0
      DO 5020 MM=1,100
      R1=AMAX1(ZERO,R1+X)
      R2=AMAX1(ZERO,R2+NR2*X)
      P1=AMAX1(ZERO,P1-X)
      P2=AMAX1(ZERO,P2-X)
      P3=AMAX1(ZERO,P3-NP3*X)
      Z=(P1*P2*P3**NP3/(R1*R2**NR2))/SP
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 5120
      IF(NR2.GT.0)THEN
      Y=AMIN1(R1,R2/NR2,P1,P2)
      ELSE
      Y=AMIN1(R1,P1,P2,P3/NP3)
      ENDIF
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.25
      ELSE
      X=Y*Z**0.25-Y
      ENDIF
      TX=TX+X
5020  CONTINUE
5120  CONTINUE
      IF(AOH1.GT.AHY1)THEN
      RYH1B=TADAX*TX
      ELSE
      RHH1B=TADAX*TX
      ENDIF
      ELSE
      RXO2B=0.0
      RXO1B=0.0
      RXH2B=0.0
      RYH2B=0.0
      RYH1B=0.0
      RHH2B=0.0
      RHH1B=0.0
      ENDIF
C
C     CATION EXCHANGE FROM GAPON SELECTIVITY COEFFICIENTS
C     FOR CA-NH4, CA-H, CA-AL, CA-MG, CA-NA, CA-K
C
      IF(CEC(L,NY,NX).GT.ZEROS(NY,NX))THEN
C
C     CATION CONCENTRATIONS
C
      CN4X=CN41
      CNBX=CN4B
      CHYX=CHY1
      CALX=CAL1**0.333
      CCAX=CCA1**0.500
      CMGX=CMG1**0.500
      CNAX=CNA1
      CKAX=CKA1
C
C     GAPON COEFFICIENTS FROM SOIL FILE ADJUSTED
C     FOR ACTIVITY COEFFICIENTS
C
      GKCHX=GKCH(L,NY,NX)*A1A2QD
      GKC4X=GKC4(L,NY,NX)*A1A2QD
      GKCAX=GKCA(L,NY,NX)*A3C/A2Q
      GKCMX=GKCM(L,NY,NX)
      GKCNX=GKCN(L,NY,NX)*A1A2QD
      GKCKX=GKCK(L,NY,NX)*A1A2QD
C
C     EQUILIBRIUM X-CA CONCENTRATION FROM CEC AND CATION
C     CONCENTRATIONS
C
      XCAQ=CCEC/(1.0+GKC4X*CN4X/CCAX*VLNH4(L,NY,NX)+GKC4X*CNBX/CCAX
     2*VLNHB(L,NY,NX)+GKCHX*CHYX/CCAX+GKCAX*CALX/CCAX+GKCMX*CMGX/CCAX
     3+GKCNX*CNAX/CCAX+GKCKX*CKAX/CCAX)
      FCAQ=XCAQ/CCAX
      FN4X=FCAQ*GKC4X
      FHYX=FCAQ*GKCHX
      FALX=FCAQ*GKCAX/3.0
      FCAX=FCAQ*0.5
      FMGX=FCAQ*GKCMX*0.5
      FNAX=FCAQ*GKCNX
      FKAX=FCAQ*GKCKX
C
C     NH4 EXCHANGE IN NON-BAND AND BAND SOIL ZONES
C
      RXN4=TADCX*(FN4X*CN4X-XN41)/(1.0+FN4X)
      RXNB=TADCX*(FN4X*CNBX-XN4B)/(1.0+FN4X)
C
C     H EXCHANGE
C
      RXHY=TADCX*(FHYX*CHYX-XHY1)/(1.0+FHYX)
C
C     AL EXCHANGE
C
      E=XAL1
      C=CAL1
      X=0.0
      TX=0.0
      DO 3010 MM=1,100
      E=AMAX1(ZERO,E+X)
      C=AMAX1(ZERO,C-X)
      Z=(C**0.333/E)*FALX
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 3110
      Y=AMIN1(E,C)
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.75
      ELSE
      X=Y*Z**0.75-Y
      ENDIF
      TX=TX+X
3010  CONTINUE
3110  CONTINUE
      RXAL=TADCX*TX
C
C     CA EXCHANGE
C
      E=XCA1
      C=CCA1
      X=0.0
      TX=0.0
      DO 3020 MM=1,100
      E=AMAX1(ZERO,E+X)
      C=AMAX1(ZERO,C-X)
      Z=(C**0.50/E)*FCAX
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 3120
      Y=AMIN1(E,C)
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.67
      ELSE
      X=Y*Z**0.67-Y
      ENDIF
      TX=TX+X
3020  CONTINUE
3120  CONTINUE
      RXCA=TADCX*TX
C
C     MG EXCHANGE
C
      E=XMG1
      C=CMG1
      X=0.0
      TX=0.0
      DO 3030 MM=1,100
      E=AMAX1(ZERO,E+X)
      C=AMAX1(ZERO,C-X)
      Z=(C**0.50/E)*FMGX
      IF(Z.GT.0.95.AND.Z.LT.1.05)GO TO 3130
      Y=AMIN1(E,C)
      IF(Z.GT.1.0)THEN
      X=Y-Y/Z**0.67
      ELSE
      X=Y*Z**0.67-Y
      ENDIF
      TX=TX+X
3030  CONTINUE
3130  CONTINUE
      RXMG=TADCX*TX
C
C     NA EXCHANGE
C
      RXNA=TADCX*(FNAX*CNAX-XNA1)/(1.0+FNAX)
C
C     K EXCHANGE
C
      RXKA=TADCX*(FKAX*CKAX-XKA1)/(1.0+FKAX)
      ELSE
      RXN4=0.0
      RXNB=0.0
      RXHY=0.0
      RXAL=0.0
      RXCA=0.0
      RXMG=0.0
      RXNA=0.0
      RXKA=0.0
      ENDIF
C
C     DISSOCIATION OF CARBOXYL RADICALS AND ADSORPTION OF AL(OH)2
C
      DP=DPCOH/A1
      S0=CHY1+XCOO+DP
      S1=AMAX1(0.0,S0**2-4.0*(CHY1*XCOO-DP*XHC1))
      RXHC=TADCX*(S0-SQRT(S1))
      DP=DPALO/A1
      S0=CALO2+XCOO+DP
      S1=AMAX1(0.0,S0**2-4.0*(CALO2*XCOO-DP*XALO21))
      RXALO2=TADAX*(S0-SQRT(S1))
C
C     NH4-NH3+H IN NON-BAND AND BAND SOIL ZONES
C
      IF(VOLWNH.GT.ZEROS(NY,NX))THEN
      DP=DPN4/A0
      S0=CHY1+CN31+DP
      S1=AMAX1(0.0,S0**2-4.0*(CHY1*CN31-DP*CN41))
      RNH4=TSLX*(S0-SQRT(S1))
      ELSE
      RNH4=0.0
      ENDIF
      IF(VOLWNB.GT.ZEROS(NY,NX))THEN
      DP=DPN4/A0
      S0=CHY1+CN3B+DP
      S1=AMAX1(0.0,S0**2-4.0*(CHY1*CN3B-DP*CN4B))
      RNHB=TSLX*(S0-SQRT(S1))
      ELSE
      RNHB=0.0
      ENDIF
C
C     CO2-H+HCO3
C
      DP=DPCO2*A0A12
      S0=CHY1+CHCO31+DP
      S1=AMAX1(0.0,S0**2-4.0*(CHY1*CHCO31-DP*CCO21))
      RCO2Q=TSLX*(S0-SQRT(S1))
C
C     HCO3-H+CO3
C
      DP=DPHCO/A2
      S0=CHY1+CCO31+DP
      S1=AMAX1(0.0,S0**2-4.0*(CHY1*CCO31-DP*CHCO31))
      RHCO3=TSLX*(S0-SQRT(S1))
C
C     ALOH-AL+OH
C
      DP=DPAL1*A2A13D
      S0=CAL1+COH1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CAL1*COH1-DP*CALO1))
      RALO1=TSLX*(S0-SQRT(S1))
C
C     AL(OH)2-ALOH+OH
C
      DP=DPAL2/A2
      S0=CALO1+COH1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CALO1*COH1-DP*CALO2))
      RALO2=TSLX*(S0-SQRT(S1))
C
C     AL(OH)3-AL(OH)2+OH
C
      DP=DPAL3*A0A12
      S0=CALO2+COH1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CALO2*COH1-DP*CALO3))
      RALO3=TSLX*(S0-SQRT(S1))
C
C     AL(OH)4-AL(OH)3+OH
C
      DP=DPAL4/A0
      S0=CALO3+COH1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CALO3*COH1-DP*CALO4))
      RALO4=TSLX*(S0-SQRT(S1))
C
C     ALSO4-AL+SO4
C
      DP=DPALS*A1A23D
      S0=CAL1+CSO41+DP
      S1=AMAX1(0.0,S0**2-4.0*(CAL1*CSO41-DP*CALS1))
      RALS=TSLX*(S0-SQRT(S1))
C
C     FEOH-FE+OH
C
      DP=DPFE1*A2A13D
      S0=CFE1+COH1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CFE1*COH1-DP*CFEO1))
      RFEO1=TSLX*(S0-SQRT(S1))
C
C     FE(OH)2-FEOH+OH
C
      DP=DPFE2/A2
      S0=CFEO1+COH1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CFEO1*COH1-DP*CFEO2))
      RFEO2=TSLX*(S0-SQRT(S1))
C
C     FE(OH)3-FE(OH)2+OH
C
      DP=DPFE3*A0A12
      S0=CFEO2+COH1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CFEO2*COH1-DP*CFEO3))
      RFEO3=TSLX*(S0-SQRT(S1))
C
C     AL(OH)4-AL(OH)3+OH
C
      DP=DPFE4/A0
      S0=CFEO3+COH1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CFEO3*COH1-DP*CFEO4))
      RFEO4=TSLX*(S0-SQRT(S1))
C
C     FESO4-FE+SO4
C
      DP=DPFES*A1A23D
      S0=CFE1+CSO41+DP
      S1=AMAX1(0.0,S0**2-4.0*(CFE1*CSO41-DP*CFES1))
      RFES=TSLX*(S0-SQRT(S1))
C
C     CAOH-CA+OH
C
      DP=DPCAO/A2
      S0=CCA1+COH1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CCA1*COH1-DP*CCAO1))
      RCAO=TSLX*(S0-SQRT(S1))
C
C     CACO3-CA+CO3
C
      DP=DPCAC*A0A22
      S0=CCA1+CCO31+DP
      S1=AMAX1(0.0,S0**2-4.0*(CCA1*CCO31-DP*CCAC1))
      RCAC=TSLX*(S0-SQRT(S1))
C
C     CAHCO3-CA+HCO3
C
      DP=DPCAH/A2
      S0=CCA1+CHCO31+DP
      S1=AMAX1(0.0,S0**2-4.0*(CCA1*CHCO31-DP*CCAH1))
      RCAH=TSLX*(S0-SQRT(S1))
C
C     CASO4-CA+SO4
C
      DP=DPCAS*A0A22
      S0=CCA1+CSO41+DP
      S1=AMAX1(0.0,S0**2-4.0*(CCA1*CSO41-DP*CCAS1))
      RCAS=TSLX*(S0-SQRT(S1))
C
C     MGOH-MG+OH
C
      DP=DPMGO/A2
      S0=CMG1+COH1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CMG1*COH1-DP*CMGO1))
      RMGO=TSLX*(S0-SQRT(S1))
C
C     MGCO3-MG+CO3
C
      DP=DPMGC*A0A22
      S0=CMG1+CCO31+DP
      S1=AMAX1(0.0,S0**2-4.0*(CMG1*CCO31-DP*CMGC1))
      RMGC=TSLX*(S0-SQRT(S1))
C
C     MGHCO3-MG+HCO3
C
      DP=DPMGH/A2
      S0=CMG1+CHCO31+DP
      S1=AMAX1(0.0,S0**2-4.0*(CMG1*CHCO31-DP*CMGH1))
      RMGH=TSLX*(S0-SQRT(S1))
C
C     MGSO4-MG+SO4
C
      DP=DPMGS*A0A22
      S0=CMG1+CSO41+DP
      S1=AMAX1(0.0,S0**2-4.0*(CMG1*CSO41-DP*CMGS1))
      RMGS=TSLX*(S0-SQRT(S1))
C
C     NACO3-NA+CO3
C
      DP=DPNAC/A2
      S0=CNA1+CCO31+DP
      S1=AMAX1(0.0,S0**2-4.0*(CNA1*CCO31-DP*CNAC1))
      RNAC=TSLX*(S0-SQRT(S1))
C
C     NASO4-NA+SO4
C
      DP=DPNAS/A2
      S0=CNA1+CSO41+DP
      S1=AMAX1(0.0,S0**2-4.0*(CNA1*CSO41-DP*CNAS1))
      RNAS=TSLX*(S0-SQRT(S1))
C
C     KSO4-K+SO4
C
      DP=DPKAS/A2
      S0=CKA1+CSO41+DP
      S1=AMAX1(0.0,S0**2-4.0*(CKA1*CSO41-DP*CKAS1))
      RKAS=TSLX*(S0-SQRT(S1))
C
C     PHOSPHORUS IN NON-BAND SOIL ZONE
C
      IF(VOLWPO.GT.ZEROS(NY,NX))THEN
C
C     HPO4-H+PO4
C
      DP=DPH1P*A2A13D
      S0=CH0P1+CHY1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CH0P1*CHY1-DP*CH1P1))
      RH1P=TSLX*(S0-SQRT(S1))
C
C     H2PO4-H+HPO4
C
      DP=DPH2P/A2
      S0=CH1P1+CHY1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CH1P1*CHY1-DP*CH2P1))
      RH2P=TSLX*(S0-SQRT(S1))
C     IF(NY.EQ.5.AND.L.EQ.10)THEN
C     WRITE(*,22)'RH2P',I,J,NX,NY,L,M,RH2P,TSLX,S0,S1,DP,DPH2P,A2
C    2,CH1P1,CHY1,CH2P1,H2PO4(L,NY,NX),VOLWPX,RH2PX,XH2PS(L,NY,NX)
C    3,TUPH2P(L,NY,NX)
22    FORMAT(A8,6I4,60E12.4)
C     ENDIF
C
C     H3PO4-H+H2PO4
C
      DP=DPH3P*A0A12
      S0=CH2P1+CHY1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CH2P1*CHY1-DP*CH3P1))
      RH3P=TSLX*(S0-SQRT(S1))
C
C     FEHPO4-FE+HPO4
C
      DP=DPF1P*A1A23D
      S0=CFE1+CH1P1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CFE1*CH1P1-DP*CF1P1))
      RF1P=TSLX*(S0-SQRT(S1))
C
C     FEH2PO4-FE+H2PO4
C
      DP=DPF2P*A2A13D
      S0=CFE1+CH2P1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CFE1*CH2P1-DP*CF2P1))
      RF2P=TSLX*(S0-SQRT(S1))
C
C     CAPO4-CA+PO4
C
      DP=DPC0P*A1A23D
      S0=CCA1+CH0P1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CCA1*CH0P1-DP*CC0P1))
      RC0P=TSLX*(S0-SQRT(S1))
C
C     CAHPO4-CA+HPO4
C
      DP=DPC1P*A0A22
      S0=CCA1+CH1P1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CCA1*CH1P1-DP*CC1P1))
      RC1P=TSLX*(S0-SQRT(S1))
C
C     CAH2PO4-CA+H2PO4
C
      DP=DPC2P/A2
      S0=CCA1+CH2P1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CCA1*CH2P1-DP*CC2P1))
      RC2P=TSLX*(S0-SQRT(S1))
C
C     MGHPO4-MG+HPO4
C
      DP=DPM1P*A0A22
      S0=CMG1+CH1P1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CMG1*CH1P1-DP*CM1P1))
      RM1P=TSLX*(S0-SQRT(S1))
      ELSE
      RH1P=0.0
      RH2P=0.0
      RH3P=0.0
      RF1P=0.0
      RF2P=0.0
      RC0P=0.0
      RC1P=0.0
      RC2P=0.0
      RM1P=0.0
      ENDIF
C
C     PHOSPHORUS IN BAND SOIL ZONE
C
      IF(VOLWPB.GT.ZEROS(NY,NX))THEN
C
C     HPO4-H+PO4
C
      DP=DPH1P*A2A13D
      S0=CH0PB+CHY1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CH0PB*CHY1-DP*CH1PB))
      RH1B=TSLX*(S0-SQRT(S1))
C
C     H2PO4-H+HPO4
C
      DP=DPH2P/A2
      S0=CH1PB+CHY1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CH1PB*CHY1-DP*CH2B1))
      RH2B=TSLX*(S0-SQRT(S1))
C
C     H3PO4-H+H2PO4
C
      DP=DPH3P*A0A12
      S0=CH2B1+CHY1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CH2B1*CHY1-DP*CH3PB))
      RH3B=TSLX*(S0-SQRT(S1))
C
C     FEHPO4-FE+HPO4
C
      DP=DPF1P*A1A23D
      S0=CFE1+CH1PB+DP
      S1=AMAX1(0.0,S0**2-4.0*(CFE1*CH1PB-DP*CF1PB))
      RF1B=TSLX*(S0-SQRT(S1))
C
C     FEH2PO4-FE+H2PO4
C
      DP=DPF2P*A2A13D
      S0=CFE1+CH2B1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CFE1*CH2B1-DP*CF2PB))
      RF2B=TSLX*(S0-SQRT(S1))
C
C     CAPO4-CA+PO4
C
      DP=DPC0P*A1A23D
      S0=CCA1+CH0PB+DP
      S1=AMAX1(0.0,S0**2-4.0*(CCA1*CH0PB-DP*CC0PB))
      RC0B=TSLX*(S0-SQRT(S1))
C
C     CAHPO4-CA+HPO4
C
      DP=DPC1P*A0A22
      S0=CCA1+CH1PB+DP
      S1=AMAX1(0.0,S0**2-4.0*(CCA1*CH1PB-DP*CC1PB))
      RC1B=TSLX*(S0-SQRT(S1))
C
C     CAH2PO4-CA+H2PO4
C
      DP=DPC2P/A2
      S0=CCA1+CH2B1+DP
      S1=AMAX1(0.0,S0**2-4.0*(CCA1*CH2B1-DP*CC2PB))
      RC2B=TSLX*(S0-SQRT(S1))
C
C     MGHPO4-MG+HPO4
C
      DP=DPM1P*A0A22
      S0=CMG1+CH1PB+DP
      S1=AMAX1(0.0,S0**2-4.0*(CMG1*CH1PB-DP*CM1PB))
      RM1B=TSLX*(S0-SQRT(S1))
      ELSE
      RH1B=0.0
      RH2B=0.0
      RH3B=0.0
      RF1B=0.0
      RF2B=0.0
      RC0B=0.0
      RC1B=0.0
      RC2B=0.0
      RM1B=0.0
      ENDIF
C
C     TOTAL ION FLUXES FOR CURRENT ITERATION
C     FROM ALL REACTIONS ABOVE
C
      RN4S=RNH4-RXN4
      RN4B=RNHB-RXNB
      RN3S=-RNH4
      RN3B=-RNHB
      RAL=-RYAL1-RHAL1-RXAL-RALO1-RALS
     2-(RYA0P1+RHA0P1+RYA0P2+RHA0P2)*VLPO4(L,NY,NX)
     3-(RYA0B1+RHA0B1+RYA0B2+RHA0B2)*VLPOB(L,NY,NX)
      RFE=-RYFE1-RHFE1-RFEO1-RFES
     2-(RYF0P1+RHF0P1+RYF0P2+RHF0P2+RF1P+RF2P)*VLPO4(L,NY,NX)
     2-(RYF0B1+RHF0B1+RYF0B2+RHF0B2+RF1B+RF2B)*VLPOB(L,NY,NX)
      RHY=-RXHY-RXHC+2.0*(RHALO1+RHFEO1+RHCACO
     2+(RHA0P2+RHF0P2-RHA3P1-RHA4P2-RHF3P1-RHF4P2)*VLPO4(L,NY,NX)
     3+(RHA0B2+RHF0B2-RHA3B1-RHA4B2-RHF3B1-RHF4B2)*VLPOB(L,NY,NX))
     4+3.0*(RHAL1+RHFE1
     5-(RHA4P1+RHF4P1)*VLPO4(L,NY,NX)
     6-(RHF4B1+RHA4B1)*VLPOB(L,NY,NX))
     7+4.0*(RHCAH1*VLPO4(L,NY,NX)+RHCHB1*VLPOB(L,NY,NX))
     8+7.0*(RHCAH2*VLPO4(L,NY,NX)+RHCHB2*VLPOB(L,NY,NX))
     9+RHALO2+RHFEO2-RHALO4-RHFEO4+RHCACH-RCO2Q-RHCO3
     1+(RHA0P1-RHA2P1+RHA1P2-RHA3P2+RHF0P1-RHF2P1+RHF1P2-RHF3P2
     2+RHCAD2-RXOH2-RXOH1-RHH2P-RHH1P-RH1P-RH2P-RH3P)*VLPO4(L,NY,NX)
     3+(RHA0B1-RHA2B1+RHA1B2-RHA3B2+RHF0B1-RHF2B1+RHF1B2-RHF3B2
     4+RHCDB2-RXO2B-RXO1B-RHH2B-RHH1B-RH1B-RH2B-RH3B)*VLPOB(L,NY,NX)
     5-RNH4*VLNH4(L,NY,NX)-RNHB*VLNHB(L,NY,NX)
      RCA=-RPCACX-RPCASO-RXCA-RCAO-RCAC-RCAH-RCAS
     2-(RPCADX+RPCAMX+RC0P+RC1P+RC2P)*VLPO4(L,NY,NX)
     3-(RPCDBX+RPCMBX+RC0B+RC1B+RC2B)*VLPOB(L,NY,NX)
     4-5.0*(RPCAHX*VLPO4(L,NY,NX)+RPCHBX*VLPOB(L,NY,NX))
      RMG=-RXMG-RMGO-RMGC-RMGH-RMGS
     2-RM1P*VLPO4(L,NY,NX)-RM1B*VLPOB(L,NY,NX)
      RNA=-RXNA-RNAC-RNAS
      RKA=-RXKA-RKAS
      ROH=2.0*(-RYALO1-RYFEO1-RYCACO
     2+(RYA3P1+RYA4P2-RYA0P2+RYF3P1+RYF4P2-RYF0P2)*VLPO4(L,NY,NX)
     3+(RYA3B1+RYA4B2-RYA0B2+RYF3B1+RYF4B2-RYF0B2)*VLPOB(L,NY,NX))
     4+3.0*(-RYAL1-RYFE1+(RYA4P1+RYF4P1)*VLPO4(L,NY,NX)
     5+(RYA4B1+RYF4B1)*VLPOB(L,NY,NX))
     6-4.0*(RYCAH1*VLPO4(L,NY,NX)+RYCHB1*VLPOB(L,NY,NX))
     7-7.0*(RYCAH2*VLPO4(L,NY,NX)+RYCHB2*VLPOB(L,NY,NX))
     8+RYALO4-RYALO2+RYFEO4-RYFEO2-RYCACH-RCAO-RMGO-RALO1
     9-RALO2-RALO3-RALO4-RFEO1-RFEO2-RFEO3-RFEO4
     1-(RYA0P1-RYA2P1+RYA1P2-RYA3P2+RYF0P1-RYF2P1+RYF1P2-RYF3P2
     2+RYCAD2-RYH2P-RYH1P)*VLPO4(L,NY,NX)
     3-(RYA0B1-RYA2B1+RYA1B2-RYA3B2+RYF0B1-RYF2B1+RYF1B2-RYF3B2
     4+RYCDB2-RYH2B-RYH1B)*VLPOB(L,NY,NX)
      RSO4=-RPCASO-RALS-RFES-RCAS-RMGS-RNAS-RKAS
      RCO3=-RYCAC3-RHCAC3-RHCO3-RCAC-RMGC-RNAC
      RHCO=-RYCACH-RHCACH-RCO2Q-RCAH-RMGH+RHCO3
      RCO2=-RHCACO-RYCACO+RCO2Q
      RH2O=2.0*(-RHALO1-RHFEO1+RYCACO
     2+(RHA2P1+RYA0P2+RYA1P2+RYA2P2+RHA2P2+RYA3P2+RYA4P2
     3+RHF2P1+RYF0P2+RYF1P2+RYF2P2+RHF2P2+RYF3P2+RYF4P2)*VLPO4(L,NY,NX)
     4+(RHA2B1+RYA0B2+RYA1B2+RYA2B2+RHA2B2+RYA3B2+RYA4B2
     5+RHF2B1+RYF0B2+RYF1B2+RYF2B2+RHF2B2+RYF3B2+RYF4B2)*VLPOB(L,NY,NX))
     6+3.0*(-RHAL1-RHFE1
     7+(RHA3P1+RHA3P2+RHF3P1+RHF3P2+RYCAH1)*VLPO4(L,NY,NX)
     8+(RHA3B1+RHA3B2+RHF3B1+RHF3B2+RYCHB1)*VLPOB(L,NY,NX))
     9+4.0*((RHA4P1+RHA4P2+RHF4P1+RHF4P2)*VLPO4(L,NY,NX)
     1+(RHA4B1+RHA4B2+RHF4B1+RHF4B2)*VLPOB(L,NY,NX))
     2+6.0*(RYCAH2*VLPO4(L,NY,NX)+RYCHB2*VLPOB(L,NY,NX))
     3-RHALO2-RHFEO2+RHALO4+RHFEO4+RYCACH
     4+(RYA0P1+RYA1P1+RHA1P1+RYA2P1+RYA3P1+RYA4P1+RHA1P2
     5+RYF0P1+RYF1P1+RHF1P1+RYF2P1+RYF3P1+RYF4P1+RHF1P2
     6+RYCAD2-RHCAH1-RHCAH2+RXH2P+RHH2P+RHH1P)*VLPO4(L,NY,NX)
     7+(RYA0B1+RYA1B1+RHA1B1+RYA2B1+RYA3B1+RYA4B1+RHA1B2
     8+RYF0B1+RYF1B1+RHF1B1+RYF2B1+RYF3B1+RYF4B1+RHF1B2
     9+RYCDB2-RHCHB1-RHCHB2+RXH2B+RHH2B+RHH1B)*VLPOB(L,NY,NX)
      RAL1=-RYALO1-RHALO1+RALO1-RALO2
     2-(RYA1P1+RHA1P1+RYA1P2+RHA1P2)*VLPO4(L,NY,NX)
     3-(RYA1B1+RHA1B1+RYA1B2+RHA1B2)*VLPOB(L,NY,NX)
      RAL2=-RYALO2-RHALO2+RALO2-RALO3
     2-(RYA2P1+RHA2P1+RYA2P2+RHA2P2)*VLPO4(L,NY,NX)
     3-(RYA2B1+RHA2B1+RYA2B2+RHA2B2)*VLPOB(L,NY,NX)-RXALO2
      RAL3=-RYALO3-RHALO3+RALO3-RALO4
     2-(RYA3P1+RHA3P1+RYA3P2+RHA3P2)*VLPO4(L,NY,NX)
     3-(RYA3B1+RHA3B1+RYA3B2+RHA3B2)*VLPOB(L,NY,NX)
      RAL4=-RYALO4-RHALO4+RALO4
     2-(RYA4P1+RHA4P1+RYA4P2+RHA4P2)*VLPO4(L,NY,NX)
     3-(RYA4B1+RHA4B1+RYA4B2+RHA4B2)*VLPOB(L,NY,NX)
      RFE1=-RYFEO1-RHFEO1+RFEO1-RFEO2
     2-(RYF1P1+RHF1P1+RYF1P2+RHF1P2)*VLPO4(L,NY,NX)
     3-(RYF1B1+RHF1B1+RYF1B2+RHF1B2)*VLPOB(L,NY,NX)
      RFE2=-RYFEO2-RHFEO2+RFEO2-RFEO3
     2-(RYF2P1+RHF2P1+RYF2P2+RHF2P2)*VLPO4(L,NY,NX)
     3-(RYF2B1+RHF2B1+RYF2B2+RHF2B2)*VLPOB(L,NY,NX)
      RFE3=-RYFEO3-RHFEO3+RFEO3-RFEO4
     2-(RYF3P1+RHF3P1+RYF3P2+RHF3P2)*VLPO4(L,NY,NX)
     3-(RYF3B1+RHF3B1+RYF3B2+RHF3B2)*VLPOB(L,NY,NX)
      RFE4=-RYFEO4-RHFEO4+RFEO4
     2-(RYF4P1+RHF4P1+RYF4P2+RHF4P2)*VLPO4(L,NY,NX)
     3-(RYF4B1+RHF4B1+RYF4B2+RHF4B2)*VLPOB(L,NY,NX)
      RHP0=-RH1P-RC0P
      RHP1=-RYA0P1-RHA0P1-RYA1P1-RHA1P1-RYA2P1-RHA2P1-RYA3P1-RHA3P1
     2-RYA4P1-RHA4P1-RYF0P1-RHF0P1-RYF1P1-RHF1P1-RYF2P1-RHF2P1-RYF3P1
     3-RHF3P1-RYF4P1-RHF4P1-RPCAD1-3.0*(RYCAH1+RHCAH1)-RYH1P-RHH1P
     4+RH1P-RH2P-RF1P-RC1P-RM1P
      RHP2=-RYA0P2-RHA0P2-RYA1P2-RHA1P2-RYA2P2-RHA2P2-RYA3P2-RHA3P2
     2-RYA4P2-RHA4P2-RYF0P2-RHF0P2-RYF1P2-RHF1P2-RYF2P2-RHF2P2-RYF3P2
     3-RHF3P2-RYF4P2-RHF4P2-RHCAD2-RYCAD2-3.0*(RYCAH2+RHCAH2)
     4-2.0*RPCAMX-RXH2P-RYH2P-RHH2P+RH2P-RH3P-RF2P-RC2P
      RHP3=RH3P
      RXH0=-RXOH1
      RXH1=RXOH1-RXOH2-RYH2P-RYH1P-RHH2P-RHH1P
      RXH2=RXOH2-RXH2P
      RX1P=RYH1P+RHH1P
      RX2P=RXH2P+RYH2P+RHH2P
C     IF(NY.EQ.5.AND.L.EQ.10)THEN
C     WRITE(*,23)'HP2',I,J,NX,NY,L,M,RHP2,RYA0P2,RHA0P2,RYA1P2,RHA1P2
C    2,RYA2P2,RHA2P2,RYA3P2,RHA3P2,RYA4P2,RHA4P2,RYF0P2,RHF0P2,RYF1P2
C    3,RHF1P2,RYF2P2,RHF2P2,RYF3P2,RHF3P2,RYF4P2,RHF4P2,RHCAD2,RYCAD2
C    4,RYCAH2,RHCAH2,RPCAMX,RXH2P,RYH2P,RHH2P,RH2P,RH3P,RF2P,RC2P
23    FORMAT(A8,6I4,60E12.4)
C     ENDIF
      RHB0=-RH1B-RC0B
      RHB1=-RYA0B1-RHA0B1-RYA1B1-RHA1B1-RYA2B1-RHA2B1-RYA3B1-RHA3B1
     2-RYA4B1-RHA4B1-RYF0B1-RHF0B1-RYF1B1-RHF1B1-RYF2B1-RHF2B1-RYF3B1
     3-RHF3B1-RYF4B1-RHF4B1-RPCDB1-3.0*(RYCHB1+RHCHB1)-RYH1B-RHH1B
     4+RH1B-RH2B-RF1B-RC1B-RM1B
      RHB2=-RYA0B2-RHA0B2-RYA1B2-RHA1B2-RYA2B2-RHA2B2-RYA3B2-RHA3B2
     2-RYA4B2-RHA4B2-RYF0B2-RHF0B2-RYF1B2-RHF1B2-RYF2B2-RHF2B2-RYF3B2
     3-RHF3B2-RYF4B2-RHF4B2-RHCDB2-RYCDB2-3.0*(RYCHB2+RHCHB2)
     4-2.0*RPCMBX-RXH2B-RYH2B-RHH2B+RH2B-RH3B-RF2B-RC2B
      RHB3=RH3B
      RBH0=-RXO1B
      RBH1=RXO1B-RXO2B-RYH2B-RYH1B-RHH2B-RHH1B
      RBH2=RXO2B-RXH2B
      RB1P=RYH1B+RHH1B
      RB2P=RXH2B+RYH2B+RHH2B
      BNH4=-RXN4*VLNH4(L,NY,NX)-RXNB*VLNHB(L,NY,NX)
      BH2P=RHP2*VLPO4(L,NY,NX)+RHB2*VLPOB(L,NY,NX)
      BION=RNH4*VLNH4(L,NY,NX)+RNHB*VLNHB(L,NY,NX)
C
C     UPDATE ION CONCENTRATIONS FOR CURRENT ITERATION
C     FROM TOTAL ION FLUXES
C
      CN41=CN41+RN4S
      CN4B=CN4B+RN4B
      CN31=CN31+RN3S
      CN3B=CN3B+RN3B
      CAL1=CAL1+RAL
      CFE1=CFE1+RFE
      CHY1=CHY1+RHY
      CCA1=CCA1+RCA
      CMG1=CMG1+RMG
      CNA1=CNA1+RNA
      CKA1=CKA1+RKA
      COH1=COH1+ROH
      CSO41=CSO41+RSO4
      CCO31=CCO31+RCO3
      CHCO31=CHCO31+RHCO
      CCO21=CCO21+RCO2
      CALO1=CALO1+RAL1
      CALO2=CALO2+RAL2
      CALO3=CALO3+RAL3
      CALO4=CALO4+RAL4
      CALS1=CALS1+RALS
      CFEO1=CFEO1+RFE1
      CFEO2=CFEO2+RFE2
      CFEO3=CFEO3+RFE3
      CFEO4=CFEO4+RFE4
      CFES1=CFES1+RFES
      CCAO1=CCAO1+RCAO
      CCAC1=CCAC1+RCAC
      CCAH1=CCAH1+RCAH
      CCAS1=CCAS1+RCAS
      CMGO1=CMGO1+RMGO
      CMGC1=CMGC1+RMGC
      CMGH1=CMGH1+RMGH
      CMGS1=CMGS1+RMGS
      CNAC1=CNAC1+RNAC
      CNAS1=CNAS1+RNAS
      CKAS1=CKAS1+RKAS
      CH0P1=CH0P1+RHP0
      CH1P1=CH1P1+RHP1
      CH2P1=CH2P1+RHP2
      CH3P1=CH3P1+RHP3
      CF1P1=CF1P1+RF1P
      CF2P1=CF2P1+RF2P
      CC0P1=CC0P1+RC0P
      CC1P1=CC1P1+RC1P
      CC2P1=CC2P1+RC2P
      CM1P1=CM1P1+RM1P
      CH0PB=CH0PB+RHB0
      CH1PB=CH1PB+RHB1
      CH2B1=CH2B1+RHB2
      CH3PB=CH3PB+RHB3
      CF1PB=CF1PB+RF1B
      CF2PB=CF2PB+RF2B
      CC0PB=CC0PB+RC0B
      CC1PB=CC1PB+RC1B
      CC2PB=CC2PB+RC2B
      CM1PB=CM1PB+RM1B
C
C     REQUILIBRATE H2O-H+OH
C
      CHY2=AMAX1(ZERO,CHY1)
      COH2=AMAX1(ZERO,COH1)
      DP=DPH2O/A1**2
      S0=CHY2+COH2
      S1=AMAX1(0.0,S0**2-4.0*(CHY2*COH2-DP))
      RHOH=0.5*(S0-SQRT(S1))
      RHY=RHY-RHOH
      ROH=ROH-RHOH
      RH2O=RH2O+RHOH
      CHY1=CHY1-RHOH
      COH1=COH1-RHOH
C     IF((I/10)*10.EQ.I.AND.J.EQ.12.AND.L.LE.3)THEN
C     WRITE(*,1111)'CCA1',I,J,L,M,CCA1,CHY1,CH1P1,CH2P1,SPCAD/A22,SPCAD2/A2
C    2,RCA,RPCACX,RPCASO,RPCADX,RPCDBX,5.0*(RPCAHX+RPCHBX),RPCAMX
C    2,RPCMBX,RXCA,RCAO,RCAC,RCAH,RCAS,RC0P,RC1P,RC2P,RC0B,RC1B,RC2B
C     WRITE(*,1111)'CAL1',I,J,L,M,CAL1,CAL1*A3
C    2,RAL,RYAL1,RYA0P1,RYA0P2,RYA0B1,RYA0B2,RXAL,RALO1,RALS
C    3,CSO41,CALS1,DPALS,A1A23D
C     WRITE(*,1111)'CFEO2',I,J,L,M,CFEO2,CFEO2*A1
C    2,RFE2,RYFEO2,RHFEO2,RYF2P1,RHF2P1,RYF2P2,RHF2P2,RYF2B1,RHF2B1
C    2,RYF2B2,RHF2B2,RFEO2,RFEO3
C     WRITE(*,1112)'CHY1',I,J,L,M,CHY1,COH1,CHY1*A1,CHYX,COHX,RHOH,RHY1
C    2,RHY,RXHY,RXHC,RHALO1,RHFEO1,RHCACO,RHA0P2,RHA0B2,RHF0P2,RHF0B2
C    2,RHA3P1,RHA4P2,RHA3B1,RHA4B2,RHF3P1,RHF4P2,RHF3B1,RHF4B2
C    3,RHAL1,RHFE1,RHA4P1,RHA4B1,RHF4P1,RHF4B1,RHCAH1
C    4,RHCHB1,RHCAH2,RHCHB2,RHALO2,RHFEO2,RHALO4,RHFEO4
C    5,RHCACH,RHA0P1,RHA2P1,RHA1P2,RHA3P2,RHA0B1,RHA2B1,RHA1B2
C    6,RHA3B2,RHF0P1,RHF2P1,RHF1P2,RHF3P2,RHF0B1,RHF2B1,RHF1B2
C    7,RHF3B2,RHCAD2,RHCDB2,RXOH2,RXOH1,RXO2B,RXO1B,RHH2P,RHH2B
C    8,RHH1P,RHH1B,RCO2Q,RHCO3,RNH4,RNHB,RH1P,RH2P,RH3P,RH1B,RH2B
C    9,RH3B,(CHY2-RHOH)*(COH2-RHOH),DP
C     ENDIF
C     WRITE(*,1111)'COH1',I,J,L,M,COH1,COH1*A1
C    2,ROH,RHOH,RYH2P,RYH2B,RYH1P,RYH1B,RPALPX,RYFEPX,RCAO,RMGO
C    2,RPCAHX,RALO1,RALO2,RALO3,RALO4,RFEO1,RFEO2,RFEO3,RFEO4
1111  FORMAT(A8,4I4,80E12.4)
C
C     UPDATE EXCHANGEABLE ION CONCENTRATIONS IN CURRENT
C     ITERATION FROM TOTAL ION FLUXES
C
      XN41=XN41+RXN4
      XN4B=XN4B+RXNB
      XHY1=XHY1+RXHY
      XAL1=XAL1+RXAL
      XCA1=XCA1+RXCA
      XMG1=XMG1+RXMG
      XNA1=XNA1+RXNA
      XKA1=XKA1+RXKA
      XHC1=XHC1+RXHC
      XALO21=XALO21+RXALO2
      XOH01=XOH01+RXH0
      XOH11=XOH11+RXH1
      XOH21=XOH21+RXH2
      XH1P1=XH1P1+RX1P
      XH2P1=XH2P1+RX2P
      XH01B=XH01B+RBH0
      XH11B=XH11B+RBH1
      XH21B=XH21B+RBH2
      X1P1B=X1P1B+RB1P
      X2P1B=X2P1B+RB2P
C
C     UPDATE PRECIPITATE CONCENTRATIONS IN CURRENT
C     ITERATION FROM TOTAL ION FLUXES
C
      PALOH1=PALOH1+RPALOX
      PFEOH1=PFEOH1+RPFEOX
      PCACO1=PCACO1+RPCACX
      PCASO1=PCASO1+RPCASO
      PALPO1=PALPO1+RPALPX
      PFEPO1=PFEPO1+RPFEPX
      PCAPD1=PCAPD1+RPCADX
      PCAPH1=PCAPH1+RPCAHX
      PCAPM1=PCAPM1+RPCAMX
      PALPOB=PALPOB+RPALBX
      PFEPOB=PFEPOB+RPFEBX
      PCAPDB=PCAPDB+RPCDBX
      PCAPHB=PCAPHB+RPCHBX
      PCAPMB=PCAPMB+RPCMBX
C
C     ACCUMULATE TOTAL ION FLUXES FOR ALL ITERATIONS
C
      TRN4S(L,NY,NX)=TRN4S(L,NY,NX)+RN4S
      TRN4B(L,NY,NX)=TRN4B(L,NY,NX)+RN4B
      TRN3S(L,NY,NX)=TRN3S(L,NY,NX)+RN3S
      TRN3B(L,NY,NX)=TRN3B(L,NY,NX)+RN3B
      TRAL(L,NY,NX)=TRAL(L,NY,NX)+RAL
      TRFE(L,NY,NX)=TRFE(L,NY,NX)+RFE
      TRHY(L,NY,NX)=TRHY(L,NY,NX)+RHY
      TRCA(L,NY,NX)=TRCA(L,NY,NX)+RCA
      TRMG(L,NY,NX)=TRMG(L,NY,NX)+RMG
      TRNA(L,NY,NX)=TRNA(L,NY,NX)+RNA
      TRKA(L,NY,NX)=TRKA(L,NY,NX)+RKA
      TROH(L,NY,NX)=TROH(L,NY,NX)+ROH
      TRSO4(L,NY,NX)=TRSO4(L,NY,NX)+RSO4
      TRCO3(L,NY,NX)=TRCO3(L,NY,NX)+RCO3
      TRHCO(L,NY,NX)=TRHCO(L,NY,NX)+RHCO
      TBCO2(L,NY,NX)=TBCO2(L,NY,NX)+RCO2
      TRH2O(L,NY,NX)=TRH2O(L,NY,NX)+RH2O
      TRAL1(L,NY,NX)=TRAL1(L,NY,NX)+RAL1
      TRAL2(L,NY,NX)=TRAL2(L,NY,NX)+RAL2
      TRAL3(L,NY,NX)=TRAL3(L,NY,NX)+RAL3
      TRAL4(L,NY,NX)=TRAL4(L,NY,NX)+RAL4
      TRALS(L,NY,NX)=TRALS(L,NY,NX)+RALS
      TRFE1(L,NY,NX)=TRFE1(L,NY,NX)+RFE1
      TRFE2(L,NY,NX)=TRFE2(L,NY,NX)+RFE2
      TRFE3(L,NY,NX)=TRFE3(L,NY,NX)+RFE3
      TRFE4(L,NY,NX)=TRFE4(L,NY,NX)+RFE4
      TRFES(L,NY,NX)=TRFES(L,NY,NX)+RFES
      TRCAO(L,NY,NX)=TRCAO(L,NY,NX)+RCAO
      TRCAC(L,NY,NX)=TRCAC(L,NY,NX)+RCAC
      TRCAH(L,NY,NX)=TRCAH(L,NY,NX)+RCAH
      TRCAS(L,NY,NX)=TRCAS(L,NY,NX)+RCAS
      TRMGO(L,NY,NX)=TRMGO(L,NY,NX)+RMGO
      TRMGC(L,NY,NX)=TRMGC(L,NY,NX)+RMGC
      TRMGH(L,NY,NX)=TRMGH(L,NY,NX)+RMGH
      TRMGS(L,NY,NX)=TRMGS(L,NY,NX)+RMGS
      TRNAC(L,NY,NX)=TRNAC(L,NY,NX)+RNAC
      TRNAS(L,NY,NX)=TRNAS(L,NY,NX)+RNAS
      TRKAS(L,NY,NX)=TRKAS(L,NY,NX)+RKAS
      TRH0P(L,NY,NX)=TRH0P(L,NY,NX)+RHP0
      TRH1P(L,NY,NX)=TRH1P(L,NY,NX)+RHP1
      TRH2P(L,NY,NX)=TRH2P(L,NY,NX)+RHP2
      TRH3P(L,NY,NX)=TRH3P(L,NY,NX)+RHP3
      TRF1P(L,NY,NX)=TRF1P(L,NY,NX)+RF1P
      TRF2P(L,NY,NX)=TRF2P(L,NY,NX)+RF2P
      TRC0P(L,NY,NX)=TRC0P(L,NY,NX)+RC0P
      TRC1P(L,NY,NX)=TRC1P(L,NY,NX)+RC1P
      TRC2P(L,NY,NX)=TRC2P(L,NY,NX)+RC2P
      TRM1P(L,NY,NX)=TRM1P(L,NY,NX)+RM1P
      TRH0B(L,NY,NX)=TRH0B(L,NY,NX)+RHB0
      TRH1B(L,NY,NX)=TRH1B(L,NY,NX)+RHB1
      TRH2B(L,NY,NX)=TRH2B(L,NY,NX)+RHB2
      TRH3B(L,NY,NX)=TRH3B(L,NY,NX)+RHB3
      TRF1B(L,NY,NX)=TRF1B(L,NY,NX)+RF1B
      TRF2B(L,NY,NX)=TRF2B(L,NY,NX)+RF2B
      TRC0B(L,NY,NX)=TRC0B(L,NY,NX)+RC0B
      TRC1B(L,NY,NX)=TRC1B(L,NY,NX)+RC1B
      TRC2B(L,NY,NX)=TRC2B(L,NY,NX)+RC2B
      TRM1B(L,NY,NX)=TRM1B(L,NY,NX)+RM1B
      TRXN4(L,NY,NX)=TRXN4(L,NY,NX)+RXN4
      TRXNB(L,NY,NX)=TRXNB(L,NY,NX)+RXNB
      TRXHY(L,NY,NX)=TRXHY(L,NY,NX)+RXHY
      TRXAL(L,NY,NX)=TRXAL(L,NY,NX)+RXAL
      TRXCA(L,NY,NX)=TRXCA(L,NY,NX)+RXCA
      TRXMG(L,NY,NX)=TRXMG(L,NY,NX)+RXMG
      TRXNA(L,NY,NX)=TRXNA(L,NY,NX)+RXNA
      TRXKA(L,NY,NX)=TRXKA(L,NY,NX)+RXKA
      TRXHC(L,NY,NX)=TRXHC(L,NY,NX)+RXHC
      TRXAL2(L,NY,NX)=TRXAL2(L,NY,NX)+RXALO2
      TRXH0(L,NY,NX)=TRXH0(L,NY,NX)+RXH0
      TRXH1(L,NY,NX)=TRXH1(L,NY,NX)+RXH1
      TRXH2(L,NY,NX)=TRXH2(L,NY,NX)+RXH2
      TRX1P(L,NY,NX)=TRX1P(L,NY,NX)+RX1P
      TRX2P(L,NY,NX)=TRX2P(L,NY,NX)+RX2P
      TRBH0(L,NY,NX)=TRBH0(L,NY,NX)+RBH0
      TRBH1(L,NY,NX)=TRBH1(L,NY,NX)+RBH1
      TRBH2(L,NY,NX)=TRBH2(L,NY,NX)+RBH2
      TRB1P(L,NY,NX)=TRB1P(L,NY,NX)+RB1P
      TRB2P(L,NY,NX)=TRB2P(L,NY,NX)+RB2P
      TRALOH(L,NY,NX)=TRALOH(L,NY,NX)+RPALOX
      TRFEOH(L,NY,NX)=TRFEOH(L,NY,NX)+RPFEOX
      TRCACO(L,NY,NX)=TRCACO(L,NY,NX)+RPCACX
      TRCASO(L,NY,NX)=TRCASO(L,NY,NX)+RPCASO
      TRALPO(L,NY,NX)=TRALPO(L,NY,NX)+RPALPX
      TRFEPO(L,NY,NX)=TRFEPO(L,NY,NX)+RPFEPX
      TRCAPD(L,NY,NX)=TRCAPD(L,NY,NX)+RPCADX
      TRCAPH(L,NY,NX)=TRCAPH(L,NY,NX)+RPCAHX
      TRCAPM(L,NY,NX)=TRCAPM(L,NY,NX)+RPCAMX
      TRALPB(L,NY,NX)=TRALPB(L,NY,NX)+RPALBX
      TRFEPB(L,NY,NX)=TRFEPB(L,NY,NX)+RPFEBX
      TRCPDB(L,NY,NX)=TRCPDB(L,NY,NX)+RPCDBX
      TRCPHB(L,NY,NX)=TRCPHB(L,NY,NX)+RPCHBX
      TRCPMB(L,NY,NX)=TRCPMB(L,NY,NX)+RPCMBX
      TBNH4(L,NY,NX)=TBNH4(L,NY,NX)+BNH4
      TBH2P(L,NY,NX)=TBH2P(L,NY,NX)+BH2P
      TBION(L,NY,NX)=TBION(L,NY,NX)+BION
C
C     GO TO NEXT ITERATION
C
1000  CONTINUE
C
C     ITERATIONS COMPLETED
C
C     IF(J.EQ.24)THEN
C     WRITE(*,1119)'GAPON',I,J,L,M,CH0P1,CAL1,CFE1,CH0P1*A3*CAL1*A3
C    2,SPALP,CH0P1*A3*CFE1*A3,SPFEP
C    6,SPOH2,XOH11*CHY1*A1/XOH21,SPOH1,XOH01*CHY1*A1/XOH11
C    7,SPH2P,XOH21*CH2P1*A1/XH2P1,SYH2P,XOH11*CH2P1/(XH2P1*COH1)
C    8,SYH1P,XOH11*CH1P1*A2/(XH1P1*COH1*A1)
C    9,COH1*A1,CHY1*A1
1119  FORMAT(A8,4I4,24E11.3)
C     WRITE(*,1119)'CATION',I,J,L,M,CCEC,XN41+XHY1+3*XAL1+2*(XCA1+XMG1)
C    2+XNA1+XKA1,XN41,XHY1,XAL1,XCA1,XMG1,XNA1,XKA1,CN41,CHY1,CAL1,CCA1
C    2,CMG1,CNA1,CKA1,(CCA1*A2)**0.5*XN41/(CN41*A1*XCA1*2)
C    3,(CCA1*A2)**0.5*XHY1/(CHY1*A1*XCA1*2)
C    2,(CCA1*A2)**0.5*XAL1*3/((CAL1*A3)**0.333*XCA1*2)
C    3,(CCA1*A2)**0.5*XMG1*2/((CMG1*A2)**0.5*XCA1*2)
C    3,(CCA1*A2)**0.5*XNA1/(CNA1*A1*XCA1*2)
C    5,(CCA1*A2)**0.5*XKA1/(CKA1*A1*XCA1*2)
C    6,CHY1*A1*XCOO/XHC1,CALO2*A1*XCOO/XALO21
C     ENDIF
C
C     CONVERT TOTAL ION FLUXES FROM CHANGES IN CONCENTRATION
C     TO CHANGES IN MASS PER UNIT AREA FOR USE IN 'REDIST'
C
      TRN4S(L,NY,NX)=TRN4S(L,NY,NX)*VOLWNH
      TRN4B(L,NY,NX)=TRN4B(L,NY,NX)*VOLWNB
      TRN3S(L,NY,NX)=TRN3S(L,NY,NX)*VOLWNH
      TRN3B(L,NY,NX)=TRN3B(L,NY,NX)*VOLWNB
      TRAL(L,NY,NX)=TRAL(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRFE(L,NY,NX)=TRFE(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRHY(L,NY,NX)=TRHY(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRCA(L,NY,NX)=TRCA(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRMG(L,NY,NX)=TRMG(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRNA(L,NY,NX)=TRNA(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRKA(L,NY,NX)=TRKA(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TROH(L,NY,NX)=TROH(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRSO4(L,NY,NX)=TRSO4(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRCO3(L,NY,NX)=TRCO3(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRHCO(L,NY,NX)=TRHCO(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TBCO2(L,NY,NX)=TBCO2(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRH2O(L,NY,NX)=TRH2O(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRAL1(L,NY,NX)=TRAL1(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRAL2(L,NY,NX)=TRAL2(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRAL3(L,NY,NX)=TRAL3(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRAL4(L,NY,NX)=TRAL4(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRALS(L,NY,NX)=TRALS(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRFE1(L,NY,NX)=TRFE1(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRFE2(L,NY,NX)=TRFE2(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRFE3(L,NY,NX)=TRFE3(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRFE4(L,NY,NX)=TRFE4(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRFES(L,NY,NX)=TRFES(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRCAO(L,NY,NX)=TRCAO(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRCAC(L,NY,NX)=TRCAC(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRCAH(L,NY,NX)=TRCAH(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRCAS(L,NY,NX)=TRCAS(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRMGO(L,NY,NX)=TRMGO(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRMGC(L,NY,NX)=TRMGC(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRMGH(L,NY,NX)=TRMGH(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRMGS(L,NY,NX)=TRMGS(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRNAC(L,NY,NX)=TRNAC(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRNAS(L,NY,NX)=TRNAS(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRKAS(L,NY,NX)=TRKAS(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRH0P(L,NY,NX)=TRH0P(L,NY,NX)*VOLWPO
      TRH1P(L,NY,NX)=TRH1P(L,NY,NX)*VOLWPO
      TRH2P(L,NY,NX)=TRH2P(L,NY,NX)*VOLWPO
      TRH3P(L,NY,NX)=TRH3P(L,NY,NX)*VOLWPO
      TRF1P(L,NY,NX)=TRF1P(L,NY,NX)*VOLWPO
      TRF2P(L,NY,NX)=TRF2P(L,NY,NX)*VOLWPO
      TRC0P(L,NY,NX)=TRC0P(L,NY,NX)*VOLWPO
      TRC1P(L,NY,NX)=TRC1P(L,NY,NX)*VOLWPO
      TRC2P(L,NY,NX)=TRC2P(L,NY,NX)*VOLWPO
      TRM1P(L,NY,NX)=TRM1P(L,NY,NX)*VOLWPO
      TRH0B(L,NY,NX)=TRH0B(L,NY,NX)*VOLWPB
      TRH1B(L,NY,NX)=TRH1B(L,NY,NX)*VOLWPB
      TRH2B(L,NY,NX)=TRH2B(L,NY,NX)*VOLWPB
      TRH3B(L,NY,NX)=TRH3B(L,NY,NX)*VOLWPB
      TRF1B(L,NY,NX)=TRF1B(L,NY,NX)*VOLWPB
      TRF2B(L,NY,NX)=TRF2B(L,NY,NX)*VOLWPB
      TRC0B(L,NY,NX)=TRC0B(L,NY,NX)*VOLWPB
      TRC1B(L,NY,NX)=TRC1B(L,NY,NX)*VOLWPB
      TRC2B(L,NY,NX)=TRC2B(L,NY,NX)*VOLWPB
      TRM1B(L,NY,NX)=TRM1B(L,NY,NX)*VOLWPB
      TRXN4(L,NY,NX)=TRXN4(L,NY,NX)*VOLWNH
      TRXNB(L,NY,NX)=TRXNB(L,NY,NX)*VOLWNB
      TRXHY(L,NY,NX)=TRXHY(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRXAL(L,NY,NX)=TRXAL(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRXCA(L,NY,NX)=TRXCA(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRXMG(L,NY,NX)=TRXMG(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRXNA(L,NY,NX)=TRXNA(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRXKA(L,NY,NX)=TRXKA(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRXHC(L,NY,NX)=TRXHC(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRXAL2(L,NY,NX)=TRXAL2(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRXH0(L,NY,NX)=TRXH0(L,NY,NX)*VOLWPO
      TRXH1(L,NY,NX)=TRXH1(L,NY,NX)*VOLWPO
      TRXH2(L,NY,NX)=TRXH2(L,NY,NX)*VOLWPO
      TRX1P(L,NY,NX)=TRX1P(L,NY,NX)*VOLWPO
      TRX2P(L,NY,NX)=TRX2P(L,NY,NX)*VOLWPO
      TRBH0(L,NY,NX)=TRBH0(L,NY,NX)*VOLWPB
      TRBH1(L,NY,NX)=TRBH1(L,NY,NX)*VOLWPB
      TRBH2(L,NY,NX)=TRBH2(L,NY,NX)*VOLWPB
      TRB1P(L,NY,NX)=TRB1P(L,NY,NX)*VOLWPB
      TRB2P(L,NY,NX)=TRB2P(L,NY,NX)*VOLWPB
      TRALOH(L,NY,NX)=TRALOH(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRFEOH(L,NY,NX)=TRFEOH(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRCACO(L,NY,NX)=TRCACO(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRCASO(L,NY,NX)=TRCASO(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TRALPO(L,NY,NX)=TRALPO(L,NY,NX)*VOLWPO
      TRFEPO(L,NY,NX)=TRFEPO(L,NY,NX)*VOLWPO
      TRCAPD(L,NY,NX)=TRCAPD(L,NY,NX)*VOLWPO
      TRCAPH(L,NY,NX)=TRCAPH(L,NY,NX)*VOLWPO
      TRCAPM(L,NY,NX)=TRCAPM(L,NY,NX)*VOLWPO
      TRALPB(L,NY,NX)=TRALPB(L,NY,NX)*VOLWPB
      TRFEPB(L,NY,NX)=TRFEPB(L,NY,NX)*VOLWPB
      TRCPDB(L,NY,NX)=TRCPDB(L,NY,NX)*VOLWPB
      TRCPHB(L,NY,NX)=TRCPHB(L,NY,NX)*VOLWPB
      TRCPMB(L,NY,NX)=TRCPMB(L,NY,NX)*VOLWPB
      TBNH4(L,NY,NX)=TBNH4(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TBH2P(L,NY,NX)=TBH2P(L,NY,NX)*VOLWM(NPH,L,NY,NX)
      TBION(L,NY,NX)=TBION(L,NY,NX)*VOLWM(NPH,L,NY,NX)
C
C     IF NO SALTS IS SELECTED IN SITE FILE THEN A SUBSET
C     OF THE EQUILIBRIA REACTIONS ARE SOLVED: MOSTLY THOSE
C     FOR PHOSPHORUS
C
      ELSE
C
C     PRECIPITATION-DISSOLUTION CALCULATED FROM ACTIVITIES
C     OF REACTANTS AND PRODUCTS THROUGH SOLUTIONS
C     FOR THEIR EQUILIBRIUM CONSTANTS USING CURRENT
C     ION CONCENTRATION
C
      CCEC=AMAX1(ZERO,XCEC(L,NY,NX)/VOLWM(NPH,L,NY,NX))
      CHY1=AMAX1(ZERO,10.0**(-(PH(L,NY,NX)-3.0)))
      COH1=AMAX1(ZERO,DPH2O/CHY1)
      IF(CAL(L,NY,NX).LT.0.0)THEN
      CAL1=AMAX1(ZERO,SYALO/COH1**3)
      ELSE
      CAL1=AMAX1(ZERO,AMIN1(CAL(L,NY,NX),SYALO/COH1**3))
      ENDIF
      IF(CFE(L,NY,NX).LT.0.0)THEN
      CFE1=AMAX1(ZERO,SYFEO/COH1**3)
      ELSE
      CFE1=AMAX1(ZERO,AMIN1(CFE(L,NY,NX),SYFEO/COH1**3))
      ENDIF
C
C     CA CONCENTRATION FROM CURRENT CO2 CONCENTRATION
C
      CCO21=AMAX1(ZERO,CCO2S(L,NY,NX)/12.0)
      CCO31=AMAX1(ZERO,CCO21*DPCO3/CHY1**2)
      IF(CCA(L,NY,NX).LT.0.0)THEN
      CCA1=AMAX1(ZERO,AMIN1(CCAMX,SPCAC/CCO31))
      ELSE
      CCA1=AMAX1(ZERO,AMIN1(CCA(L,NY,NX),SPCAC/CCO31))
      ENDIF
C
C     PHOSPHORUS TRANSFORMATIONS IN NON-BAND SOIL ZONE
C
      IF(VOLWPO.GT.ZEROS(NY,NX))THEN
C
C     ALUMINUM PHOSPHATE (VARISCITE)
C
      CH2PA=SYA0P2/(CAL1*COH1**2)
      RPALPX=AMAX1(-PALPO1,TPD*(CH2P1-CH2PA))
C
C     IRON PHOSPHATE (STRENGITE)
C
      CH2PF=SYF0P2/(CFE1*COH1**2)
      RPFEPX=AMAX1(-PFEPO1,TPD*(CH2P1-CH2PF))
C     IF(I.EQ.180.AND.J.EQ.12)THEN
C     WRITE(*,1117)'RPFEPX',I,J,L,CH2PA,SYA0P2,CAL1,COH1,PALPO1
C    2,CH2P1,CH2PF,SYF0P2,CFE1,COH1,PFEPO1,CH2P1,RPALPX,RPFEPX
C    3,CAL(L,NY,NX) 
C     ENDIF
C
C     DICALCIUM PHOSPHATE
C
      CH2PD=SYCAD2/(CCA1*COH1)
      RPCADX=AMAX1(-PCAPD1,TPD*(CH2P1-CH2PD))
C
C     HYDROXYAPATITE
C
      CH2PH=(SYCAH2/(CCA1**5*COH1**7))**0.333
      RPCAHX=AMAX1(-PCAPH1,TPD*(CH2P1-CH2PH))
C
C     MONOCALCIUM PHOSPHATE
C
      CH2PM=SQRT(SPCAM/CCA1)
      RPCAMX=AMAX1(-PCAPM1*SPPO4(IFTYP(NY,NX)),TPD*(CH2P1-CH2PM))
C     IF(I.GT.315)THEN
C     WRITE(*,1117)'RPPO4',I,J,L,RPCADX,CH2P1,CH2PD,PCAPD1,RPCAHX 
C    2,CH2PA,CH2PH,SYA0P2,CAL1,COH1,SYCAH2,CCA1,CCO21,CCO31,PCAPH1 
C    3,VOLWPO,SPCAC/CCO31,CCA(L,NY,NX),H2PO4(L,NY,NX)
C    4,VOLWM(NPH,L,NY,NX),ZCA(L,NY,NX),CCO2S(L,NY,NX)
1117  FORMAT(A8,3I4,30E12.4)
C     ENDIF
C
C     PHOSPHORUS ANION EXCHANGE IN NON-BAND SOIL ZONE
C     CALCULATED FROM EXCHANGE EQUILIBRIA AMONG H2PO4-,
C     HPO4--, H+, OH- AND PROTONATED AND NON-PROTONATED -OH
C     EXCHANGE SITES
C
      IF(AEC(L,NY,NX).GT.0.0)THEN
C
C     PROTONATION OF ANION EXCHANGE SITES IN NON-BAND SOIL ZONE
C
      DCHG=AMAX1(-1.0E+02,XOH21-XOH01-XH1P1)
      AEP=EXP(AE*DCHG/TKS(L,NY,NX))
      AEN=EXP(-AE*DCHG/TKS(L,NY,NX))
C
C     H2PO4 EXCHANGE IN NON-BAND SOIL ZONE FROM CONVERGENCE
C     SOLUTION FOR EQUILIBRIUM AMONG H2PO4-, H+, OH-, X-OH
C     AND X-H2PO4
C
      SPH2P=SYH2P*DPH2O/(SXOH2*AEP)
      X0=XOH21+CH2P1+SPH2P
      X1=AMAX1(0.0,X0**2-4.0*(XOH21*CH2P1-SPH2P*XH2P1))
      RXH2P=TADA*(X0-SQRT(X1))
      X0=XOH11+CH2P1+SYH2P*COH1 
      X1=AMAX1(0.0,X0**2-4.0*(XOH11*CH2P1-SYH2P*COH1*XH2P1))
      RYH2P=TADA*(X0-SQRT(X1))
C
C     HPO4 EXCHANGE IN NON-BAND SOIL ZONE FROM CONVERGENCE
C     SOLUTION FOR EQUILIBRIUM AMONG HPO4--, H+, OH-, X-OH
C     AND X-HPO4
C
      SPH1P=SYH1P*DPH2O*AEN/DPH2P
      X0=XOH11+CH2P1+SPH1P
      X1=AMAX1(0.0,X0**2-4.0*(XOH11*CH2P1-SPH1P*XH1P1))
      RXH1P=TADA*(X0-SQRT(X1))
C     WRITE(*,1116)'RXH2P',I,J,NX,NY,L,RXH2P
C    2,XOH21,CH2P1,XH2P1,XOH21*(CH2P1-RXH2P)/(XH2P1+RXH2P),SPH2P
C    3,H2PO4(L,NY,NX),RH2PX,VOLWPO,AEP
C     WRITE(*,1116)'RYH2P',I,J,NX,NY,L,RYH2P
C    2,XOH11,CH2P1,XH2P1,COH1,(XOH11*(CH2P1-RYH2P))
C    3/((XH2P1+RYH2P)*COH1),SYH2P
C     WRITE(*,1116)'RXH1P',I,J,NX,NY,L,RXH1P,X0,X1
C    2,XOH11,CH2P1,XH1P1,XOH11*(CH2P1-RXH1P)/(XH1P1+RXH1P),SPH1P
C    3,SYH1P,DPH2O,AEN,DPH2P,XOH1(L,NY,NX),VLPO4(L,NY,NX),VLPOB(L,NY,NX)
C    4,AE,DCHG,TKS(L,NY,NX),XOH21,XOH01
1116  FORMAT(A8,5I4,40E12.4)
      ELSE
      RXH2P=0.0
      RYH2P=0.0
      RXH1P=0.0
      ENDIF
      ELSE
      RPALPX=0.0
      RPFEPX=0.0
      RPCADX=0.0
      RPCAHX=0.0
      RPCAMX=0.0
      RXH2P=0.0
      RYH2P=0.0
      RXH1P=0.0
      ENDIF
C     IF(J.EQ.1)THEN
C     WRITE(*,2222)'PO4',I,J,L,CH2P1,PALPO1,PFEPO1,PCAPD1,PCAPH1,PCAPM1
C    2,CH2PA,CH2PF,CH2PD,CH2PH,CH2PM,RPALPX,RPFEPX,RPCADX,RPCAHX,RPCAMX
C    3,XH2P1,RXH2P,RYH2P
C    3,CAL1,CFE1,CCA1,CHY1,COH1
2222  FORMAT(A8,3I4,40E12.4)
C     ENDIF
C
C     PHOSPHORUS PRECIPITATION-DISSOLUTION IN BAND SOIL ZONE
C
      IF(VOLWPB.GT.ZEROS(NY,NX))THEN
C
C     ALUMINUM PHOSPHATE (VARISCITE)
C
      CH2PA=SYA0P2/(CAL1*COH1**2)
      RPALBX=AMAX1(-PALPOB,TPD*(CH2B1-CH2PA))
C
C     IRON PHOSPHATE (STRENGITE)
C
      CH2PF=SYF0P2/(CFE1*COH1**2)
      RPFEBX=AMAX1(-PFEPOB,TPD*(CH2B1-CH2PF))
C
C     DICALCIUM PHOSPHATE
C
      CH2PD=SYCAD2/(CCA1*COH1)
      RPCDBX=AMAX1(-PCAPDB,TPD*(CH2B1-CH2PD))
C
C     HYDROXYAPATITE
C
      CH2PH=(SYCAH2/(CCA1**5*COH1**7))**0.333
      RPCHBX=AMAX1(-PCAPHB,TPD*(CH2B1-CH2PH))
C
C     MONOCALCIUM PHOSPHATE
C
      CH2PM=SQRT(SPCAM/CCA1)
      RPCMBX=AMAX1(-PCAPMB*SPPO4(IFTYP(NY,NX)),TPD*(CH2B1-CH2PM))
C
C     PHOSPHORUS ANION EXCHANGE IN BAND SOIL ZONE
C     CALCULATED FROM EXCHANGE EQUILIBRIA AMONG H2PO4-,
C     HPO4--, H+, OH- AND PROTONATED AND NON-PROTONATED -OH
C     EXCHANGE SITES
C
      IF(AEC(L,NY,NX).GT.0.0)THEN
C
C     PROTONATION OF EXCHANGE SITES IN BAND SOIL ZONE
C
      DCHG=AMAX1(-0.1E+05,XH21B-XH01B-X1P1B)
      AEP=EXP(AE*DCHG/TKS(L,NY,NX))
      AEN=EXP(-AE*DCHG/TKS(L,NY,NX))
C
C     H2PO4 EXCHANGE IN BAND SOIL ZONE FROM CONVERGENCE
C     SOLUTION FOR EQUILIBRIUM AMONG H2PO4-, H+, OH-, X-OH
C     AND X-H2PO4
C
      RXH2B=TADA*(XH21B*CH2B1-SPH2P*X2P1B)/(SPH2P+XH21B)
      RYH2B=TADA*(XH11B*CH2B1-SYH2P*X2P1B*COH1)/(SYH2P*COH1+XH11B)
C
C     HPO4 EXCHANGE IN BAND SOIL ZONE FROM CONVERGENCE
C     SOLUTION FOR EQUILIBRIUM AMONG HPO4--, H+, OH-, X-OH
C     AND X-HPO4
C
      SPH1P=SYH1P*DPH2O*AEN/DPH2P
      RXH1B=TADA*(XH11B*CH2B1-SPH1P*X1P1B)/(SPH1P+XH11B)
C     WRITE(*,2224)'RXH2B',I,J,L,RXH2B,RXH1B,XH21B,CH2B1,SPH2P,X2P1B
C    2,SPH2P,XH21B,XH11B,CH2B1,SPH1P,X1P1B,SPH1P,XH11B,H2POB(L,NY,NX)
2224  FORMAT(A8,3I4,40E12.4)
      ELSE
      RXH2B=0.0
      RYH2B=0.0
      RXH1B=0.0
      ENDIF
      ELSE
      RPALBX=0.0
      RPFEBX=0.0
      RPCDBX=0.0
      RPCHBX=0.0
      RPCMBX=0.0
      RXH2B=0.0
      RYH2B=0.0
      RXH1B=0.0
      ENDIF
C
C     CATION EXCHANGE FROM GAPON SELECTIVITY COEFFICIENTS
C     FOR CA-NH4, CA-H, CA-AL
C
      CALX=AMAX1(ZERO,CAL1)**0.333
      CCAX=AMAX1(ZERO,CCA1)**0.500
C
C     EQUILIBRIUM X-CA CONCENTRATION FROM CEC AND CATION
C     CONCENTRATIONS
C
      XCAQ=CCEC/(1.0+GKC4(L,NY,NX)*CN41/CCAX*VLNH4(L,NY,NX)
     2+GKC4(L,NY,NX)*CN4B/CCAX*VLNHB(L,NY,NX)+GKCH(L,NY,NX)*CHY1/CCAX
     3+GKCA(L,NY,NX)*CALX/CCAX)
      FCAQ=XCAQ/CCAX
      FN4X=FCAQ*GKC4(L,NY,NX)
C
C     NH4 EXCHANGE IN NON-BAND AND BAND SOIL ZONES
C
      RXN4=TADC*(FN4X*CN41-XN41)/(1.0+FN4X)
      RXNB=TADC*(FN4X*CN4B-XN4B)/(1.0+FN4X)
C     IF(J.EQ.12.AND.L.EQ.0)THEN
C     WRITE(*,2222)'RXN4',I,J,L,RXN4,CN41,XN41,CCAX,CCA1,XCAQ,CCEC
C    2,FN4X,FCAQ,GKC4(L,NY,NX),PH(L,NY,NX)
C    3,(CCA1)**0.5*XN41/(CN41*XCAQ),ZCA(L,NY,NX)
C     ENDIF
C
C     NH4-NH3+H IN NON-BAND AND BAND SOIL ZONES
C
      IF(VOLWNH.GT.ZEROS(NY,NX))THEN
      RNH4=(CHY1*CN31-DPN4*CN41)/(DPN4+CHY1)
      ELSE
      RNH4=0.0
      ENDIF
      IF(VOLWNB.GT.ZEROS(NY,NX))THEN
      RNHB=(CHY1*CN3B-DPN4*CN4B)/(DPN4+CHY1)
      ELSE
      RNHB=0.0
      ENDIF
C     IF(J.EQ.12.AND.L.LE.6)THEN
C     WRITE(*,2222)'RNH4',I,J,L,RNH4,CHY1,CN31,DPN4,CN41
C    2,RXN4,XN41,VOLWNH,RNHB,CHYB,CN3B,CN4B,VOLWNB,RXNB,XN4B,FN4X
C    2,CN41*VOLWNH,XN41*VOLWNH,CN4B*VOLWNB,XN4B*VOLWNB 
C    3,(CCA1)**0.5*XN41/(CN41*XCAQ),(CCA1)**0.5*XN4B/(CN4B*XCAQ)
C     ENDIF
C
C     TOTAL ION FLUXES FOR ALL REACTIONS ABOVE
C
      RN4S=RNH4-RXN4
      RN4B=RNHB-RXNB
      RN3S=-RNH4
      RN3B=-RNHB
      RHP2=-RXH2P-RYH2P-RXH1P-RPALPX-RPFEPX-RPCADX-2.0*RPCAMX-3.0*RPCAHX
      RHB2=-RXH2B-RYH2B-RXH1B-RPALBX-RPFEBX-RPCDBX-2.0*RPCMBX-3.0*RPCHBX
      RXH1=-RYH2P-RXH1P
      RXH2=-RXH2P
      RX1P=RXH1P
      RX2P=RXH2P+RYH2P
      RBH1=-RYH2B-RXH1B
      RBH2=-RXH2B
      RB1P=RXH1B
      RB2P=RXH2B+RYH2B
      RH2O=(RXH2P+RXH1P+RPCADX)*VLPO4(L,NY,NX)+(RXH2B+RXH1B+RPCDBX)
     2*VLPOB(L,NY,NX)+2.0*((RPALPX+RPFEPX)*VLPO4(L,NY,NX)
     3+(RPALBX+RPFEBX)*VLPOB(L,NY,NX))+6.0*(RPCAHX*VLPO4(L,NY,NX)
     4+RPCHBX*VLPOB(L,NY,NX))
      BNH4=-RXN4*VLNH4(L,NY,NX)-RXNB*VLNHB(L,NY,NX)
      BH2P=RHP2*VLPO4(L,NY,NX)+RHB2*VLPOB(L,NY,NX)
      BION=(RYH2P-RPCAMX)*VLPO4(L,NY,NX)+(RYH2B-RPCMBX)*VLPOB(L,NY,NX)
     2-3.0*((RPALPX+RPFEPX)*VLPO4(L,NY,NX)
     3+(RPALBX+RPFEBX)*VLPOB(L,NY,NX))
     4-2.0*(RPCADX*VLPO4(L,NY,NX)+RPCDBX*VLPOB(L,NY,NX))
     5-12.0*(RPCAHX*VLPO4(L,NY,NX)+RPCHBX*VLPOB(L,NY,NX))
C
C     CONVERT TOTAL ION FLUXES FROM CHANGES IN CONCENTRATION
C     TO CHANGES IN MASS PER UNIT AREA FOR USE IN 'REDIST'
C
      TRN4S(L,NY,NX)=TRN4S(L,NY,NX)+RN4S*VOLWNH
      TRN4B(L,NY,NX)=TRN4B(L,NY,NX)+RN4B*VOLWNB
      TRN3S(L,NY,NX)=TRN3S(L,NY,NX)+RN3S*VOLWNH
      TRN3B(L,NY,NX)=TRN3B(L,NY,NX)+RN3B*VOLWNB
      TRH2P(L,NY,NX)=TRH2P(L,NY,NX)+RHP2*VOLWPO
      TRH2B(L,NY,NX)=TRH2B(L,NY,NX)+RHB2*VOLWPB
      TRXN4(L,NY,NX)=TRXN4(L,NY,NX)+RXN4*VOLWNH
      TRXNB(L,NY,NX)=TRXNB(L,NY,NX)+RXNB*VOLWNB
      TRXH1(L,NY,NX)=TRXH1(L,NY,NX)+RXH1*VOLWPO
      TRXH2(L,NY,NX)=TRXH2(L,NY,NX)+RXH2*VOLWPO
      TRX1P(L,NY,NX)=TRX1P(L,NY,NX)+RX1P*VOLWPO
      TRX2P(L,NY,NX)=TRX2P(L,NY,NX)+RX2P*VOLWPO
      TRBH1(L,NY,NX)=TRBH1(L,NY,NX)+RBH1*VOLWPB
      TRBH2(L,NY,NX)=TRBH2(L,NY,NX)+RBH2*VOLWPB
      TRB1P(L,NY,NX)=TRB1P(L,NY,NX)+RB1P*VOLWPB
      TRB2P(L,NY,NX)=TRB2P(L,NY,NX)+RB2P*VOLWPB
      TRALPO(L,NY,NX)=TRALPO(L,NY,NX)+RPALPX*VOLWPO
      TRFEPO(L,NY,NX)=TRFEPO(L,NY,NX)+RPFEPX*VOLWPO
      TRCAPD(L,NY,NX)=TRCAPD(L,NY,NX)+RPCADX*VOLWPO
      TRCAPH(L,NY,NX)=TRCAPH(L,NY,NX)+RPCAHX*VOLWPO
      TRCAPM(L,NY,NX)=TRCAPM(L,NY,NX)+RPCAMX*VOLWPO
      TRALPB(L,NY,NX)=TRALPB(L,NY,NX)+RPALBX*VOLWPB
      TRFEPB(L,NY,NX)=TRFEPB(L,NY,NX)+RPFEBX*VOLWPB
      TRCPDB(L,NY,NX)=TRCPDB(L,NY,NX)+RPCDBX*VOLWPB
      TRCPHB(L,NY,NX)=TRCPHB(L,NY,NX)+RPCHBX*VOLWPB
      TRCPMB(L,NY,NX)=TRCPMB(L,NY,NX)+RPCMBX*VOLWPB
      TRH2O(L,NY,NX)=TRH2O(L,NY,NX)+RH2O*VOLWM(NPH,L,NY,NX)
      TBNH4(L,NY,NX)=TBNH4(L,NY,NX)+BNH4*VOLWM(NPH,L,NY,NX)
      TBH2P(L,NY,NX)=TBH2P(L,NY,NX)+BH2P*VOLWM(NPH,L,NY,NX)
      TBION(L,NY,NX)=TBION(L,NY,NX)+BION*VOLWM(NPH,L,NY,NX)
C     IF(L.EQ.1)THEN
C     WRITE(*,4334)'RH2O',I,J,L,TRH2O(L,NY,NX),RH2O,RXH2P,RXH1P,RPCADX
C    2,VLPO4(L,NY,NX),RXH2B,RXH1B,RPCDBX
C    2,VLPOB(L,NY,NX),RPALPX,RPFEPX,VLPO4(L,NY,NX)
C    3,RPALBX,RPFEBX,VLPOB(L,NY,NX),RPCAHX,VLPO4(L,NY,NX)
C    4,RPCHBX,VLPOB(L,NY,NX),VOLWM(NPH,L,NY,NX)
C    5,TADA,XOH21,CH2P1,SPH2P,XH2P1,H2PO4(L,NY,NX),VOLWPX,RH2PX
C    6,VOLWPO,XH2PS(L,NY,NX),TUPH2P(L,NY,NX)
4334  FORMAT(A8,3I4,40E12.4)
C     ENDIF
      ENDIF
C
C     CHANGE IN WIDTHS AND DEPTHS OF FERTILIZER BANDS FROM
C     VERTICAL AND HORIZONTAL DIFFUSION DRIVEN BY CONCENTRATION
C     DIFFERENCES BETWEEN BAND AND NON-BAND SOIL ZONES
C
C     IF(ROWI(I,NY,NX).GT.0.0)THEN
      FLWD=0.5*(FLW(3,L,NY,NX)+FLW(3,L+1,NY,NX))/AREA(3,L,NY,NX)
C
C     NH4 FERTILIZER BAND
C
      IF(IFNHB(NY,NX).EQ.1.AND.ROWN(NY,NX).GT.0.0)THEN
      IF(L.EQ.NU(NY,NX).OR.CDPTH(L-1,NY,NX).LT.DPNH4(NY,NX))THEN
C
C     NH4 BAND WIDTH
C
      DWNH4=0.5*SQRT(ZNSGL(L,NY,NX))*TORT(L,NY,NX)
      WDNHB(L,NY,NX)=AMIN1(ROWN(NY,NX),WDNHB(L,NY,NX)+DWNH4)
C
C     NH4 BAND DEPTH
C
      IF(CDPTH(L,NY,NX).GE.DPNH4(NY,NX))THEN
      DPFLW=FLWD+DWNH4
      DPNH4(NY,NX)=DPNH4(NY,NX)+DPFLW
      DPNHB(L,NY,NX)=DPNHB(L,NY,NX)+DPFLW
      IF(DPNHB(L,NY,NX).GT.DLYR(3,L,NY,NX))THEN
      DPNHB(L+1,NY,NX)=DPNHB(L+1,NY,NX)+(DPNHB(L,NY,NX)-DLYR(3,L,NY,NX))
      WDNHB(L+1,NY,NX)=WDNHB(L,NY,NX)
      DPNHB(L,NY,NX)=DLYR(3,L,NY,NX)
      ELSEIF(DPNHB(L,NY,NX).LT.0.0)THEN
      DPNHB(L-1,NY,NX)=DPNHB(L-1,NY,NX)+DPNHB(L,NY,NX)
      DPNHB(L,NY,NX)=0.0
      WDNHB(L,NY,NX)=0.0
      ENDIF
      ENDIF
C
C     FRACTION OF SOIL LAYER OCCUPIED BY NH4 BAND
C     FROM BAND WIDTH X DEPTH
C
      XVLNH4=VLNH4(L,NY,NX)
      VLNHB(L,NY,NX)=AMIN1(0.999,WDNHB(L,NY,NX)/ROWN(NY,NX)
     2*DPNHB(L,NY,NX)/DLYR(3,L,NY,NX))
      VLNH4(L,NY,NX)=1.0-VLNHB(L,NY,NX)
      FVLNH4=AMIN1(0.0,(VLNH4(L,NY,NX)-XVLNH4)/XVLNH4)
C
C     TRANSFER NH4, NH3 FROM NON-BAND TO BAND
C     DURING BAND GROWTH
C
      DNH4S=FVLNH4*ZNH4S(L,NY,NX)/14.0
      DNH3S=FVLNH4*ZNH3S(L,NY,NX)/14.0
      DXNH4=FVLNH4*XN4(L,NY,NX)
      TRN4S(L,NY,NX)=TRN4S(L,NY,NX)+DNH4S
      TRN4B(L,NY,NX)=TRN4B(L,NY,NX)-DNH4S
      TRN3S(L,NY,NX)=TRN3S(L,NY,NX)+DNH3S
      TRN3B(L,NY,NX)=TRN3B(L,NY,NX)-DNH3S
      TRXN4(L,NY,NX)=TRXN4(L,NY,NX)+DXNH4
      TRXNB(L,NY,NX)=TRXNB(L,NY,NX)-DXNH4
      ELSE
C
C     AMALGAMATE NH4 BAND WITH NON-BAND
C
      DPNHB(L,NY,NX)=0.0
      WDNHB(L,NY,NX)=0.0
      VLNH4(L,NY,NX)=1.0
      VLNHB(L,NY,NX)=0.0
      ZNH4S(L,NY,NX)=ZNH4S(L,NY,NX)+ZNH4B(L,NY,NX)
      ZNH3S(L,NY,NX)=ZNH3S(L,NY,NX)+ZNH3B(L,NY,NX)
      ZNH4B(L,NY,NX)=0.0
      ZNH3B(L,NY,NX)=0.0
      XN4(L,NY,NX)=XN4(L,NY,NX)+XNB(L,NY,NX)
      XNB(L,NY,NX)=0.0
      ENDIF
      ENDIF
C
C     NO3 FERTILIZER BAND
C
      IF(IFNOB(NY,NX).EQ.1.AND.ROWO(NY,NX).GT.0.0)THEN
      IF(L.EQ.NU(NY,NX).OR.CDPTH(L-1,NY,NX).LT.DPNO3(NY,NX))THEN
C
C     NO3 BAND WIDTH
C
      DWNO3=0.5*SQRT(ZOSGL(L,NY,NX))*TORT(L,NY,NX)
      WDNOB(L,NY,NX)=AMIN1(ROWO(NY,NX),WDNOB(L,NY,NX)+DWNO3)
C
C     NO3 BAND DEPTH
C
      IF(CDPTH(L,NY,NX).GE.DPNO3(NY,NX))THEN
      DPFLW=FLWD+DWNO3
      DPNO3(NY,NX)=DPNO3(NY,NX)+DPFLW
      DPNOB(L,NY,NX)=DPNOB(L,NY,NX)+DPFLW
      IF(DPNOB(L,NY,NX).GT.DLYR(3,L,NY,NX))THEN
      DPNOB(L+1,NY,NX)=DPNOB(L+1,NY,NX)+(DPNOB(L,NY,NX)-DLYR(3,L,NY,NX))
      WDNOB(L+1,NY,NX)=WDNOB(L,NY,NX)
      DPNOB(L,NY,NX)=DLYR(3,L,NY,NX)
      ELSE IF(DPNOB(L,NY,NX).LT.0.0)THEN
      DPNOB(L-1,NY,NX)=DPNOB(L-1,NY,NX)+DPNOB(L,NY,NX)
      DPNOB(L,NY,NX)=0.0
      WDNOB(L,NY,NX)=0.0
      ENDIF
      ENDIF
C
C     FRACTION OF SOIL LAYER OCCUPIED BY NO3 BAND
C     FROM BAND WIDTH X DEPTH
C
      XVLNO3=VLNO3(L,NY,NX)
      VLNOB(L,NY,NX)=AMIN1(0.999,WDNOB(L,NY,NX)/ROWO(NY,NX)
     2*DPNOB(L,NY,NX)/DLYR(3,L,NY,NX))
      VLNO3(L,NY,NX)=1.0-VLNOB(L,NY,NX)
      FVLNO3=AMIN1(0.0,(VLNO3(L,NY,NX)-XVLNO3)/XVLNO3)
C
C     TRANSFER NO3 FROM NON-BAND TO BAND
C     DURING BAND GROWTH
C
      DNO3S=FVLNO3*ZNO3S(L,NY,NX)/14.0
      DNO2S=FVLNO3*ZNO2S(L,NY,NX)/14.0
      TRNO3(L,NY,NX)=TRNO3(L,NY,NX)+DNO3S
      TRNO2(L,NY,NX)=TRNO2(L,NY,NX)+DNO2S
      TRNOB(L,NY,NX)=TRNOB(L,NY,NX)-DNO3S
      TRN2B(L,NY,NX)=TRN2B(L,NY,NX)-DNO2S
      ELSE
C
C     AMALGAMATE NO3 BAND WITH NON-BAND
C
      DPNOB(L,NY,NX)=0.0
      WDNOB(L,NY,NX)=0.0
      VLNO3(L,NY,NX)=1.0
      VLNOB(L,NY,NX)=0.0
      ZNO3S(L,NY,NX)=ZNO3S(L,NY,NX)+ZNO3B(L,NY,NX)
      ZNO2S(L,NY,NX)=ZNO2S(L,NY,NX)+ZNO2B(L,NY,NX)
      ZNO3B(L,NY,NX)=0.0
      ZNO2B(L,NY,NX)=0.0
      ENDIF
      ENDIF
C
C     PO4 FERTILIZER BAND
C
      IF(IFPOB(NY,NX).EQ.1.AND.ROWP(NY,NX).GT.0.0)THEN
      IF(L.EQ.NU(NY,NX).OR.CDPTH(L-1,NY,NX).LT.DPPO4(NY,NX))THEN
C
C     PO4 BAND WIDTH
C
      DWPO4=0.5*SQRT(POSGL(L,NY,NX))*TORT(L,NY,NX)
      WDPOB(L,NY,NX)=AMIN1(ROWP(NY,NX),WDPOB(L,NY,NX)+DWPO4)
C
C     PO4 BAND DEPTH
C
      IF(CDPTH(L,NY,NX).GE.DPPO4(NY,NX))THEN
      DPFLW=FLWD+DWPO4
      DPPO4(NY,NX)=DPPO4(NY,NX)+DPFLW
      DPPOB(L,NY,NX)=DPPOB(L,NY,NX)+DPFLW
      IF(DPPOB(L,NY,NX).GT.DLYR(3,L,NY,NX))THEN
      DPPOB(L+1,NY,NX)=DPPOB(L+1,NY,NX)+(DPPOB(L,NY,NX)-DLYR(3,L,NY,NX))
      WDPOB(L+1,NY,NX)=WDPOB(L,NY,NX)
      DPPOB(L,NY,NX)=DLYR(3,L,NY,NX)
      ELSE IF(DPPOB(L,NY,NX).LT.0.0)THEN
      DPPOB(L-1,NY,NX)=DPPOB(L-1,NY,NX)+DPPOB(L,NY,NX)
      DPPOB(L,NY,NX)=0.0
      WDPOB(L,NY,NX)=0.0
      ENDIF
      ENDIF
C
C     FRACTION OF SOIL LAYER OCCUPIED BY PO4 BAND
C     FROM BAND WIDTH X DEPTH
C
      XVLPO4=VLPO4(L,NY,NX)
      VLPOB(L,NY,NX)=AMIN1(0.999,WDPOB(L,NY,NX)/ROWP(NY,NX)
     2*DPPOB(L,NY,NX)/DLYR(3,L,NY,NX))
      VLPO4(L,NY,NX)=1.0-VLPOB(L,NY,NX)
      FVLPO4=AMIN1(0.0,(VLPO4(L,NY,NX)-XVLPO4)/XVLPO4)
C
C     TRANSFER NO3 FROM NON-BAND TO BAND
C     DURING BAND GROWTH DEPENDING ON SALT
C     VS. NON-SALT OPTION
C
      IF(ISALT(NY,NX).NE.0)THEN
      DZH0P=FVLPO4*H0PO4(L,NY,NX)
      DZH1P=FVLPO4*H1PO4(L,NY,NX)
      DZH2P=FVLPO4*H2PO4(L,NY,NX)/31.0
      DZH3P=FVLPO4*H3PO4(L,NY,NX)
      DZF1P=FVLPO4*ZFE1P(L,NY,NX)
      DZF2P=FVLPO4*ZFE2P(L,NY,NX)
      DZC0P=FVLPO4*ZCA0P(L,NY,NX)
      DZC1P=FVLPO4*ZCA1P(L,NY,NX)
      DZC2P=FVLPO4*ZCA2P(L,NY,NX)
      DZM1P=FVLPO4*ZMG1P(L,NY,NX)
      DXOH0=FVLPO4*XOH0(L,NY,NX)
      DXOH1=FVLPO4*XOH1(L,NY,NX)
      DXOH2=FVLPO4*XOH2(L,NY,NX)
      DXH1P=FVLPO4*XH1P(L,NY,NX)
      DXH2P=FVLPO4*XH2P(L,NY,NX)
      DPALP=FVLPO4*PALPO(L,NY,NX)
      DPFEP=FVLPO4*PFEPO(L,NY,NX)
      DPCDP=FVLPO4*PCAPD(L,NY,NX)
      DPCHP=FVLPO4*PCAPH(L,NY,NX)
      DPCMP=FVLPO4*PCAPM(L,NY,NX)
      TRH0P(L,NY,NX)=TRH0P(L,NY,NX)+DZH0P
      TRH1P(L,NY,NX)=TRH1P(L,NY,NX)+DZH1P
      TRH2P(L,NY,NX)=TRH2P(L,NY,NX)+DZH2P
      TRH3P(L,NY,NX)=TRH3P(L,NY,NX)+DZH3P
      TRF1P(L,NY,NX)=TRF1P(L,NY,NX)+DZF1P
      TRF2P(L,NY,NX)=TRF2P(L,NY,NX)+DZF2P
      TRC0P(L,NY,NX)=TRC0P(L,NY,NX)+DZC0P
      TRC1P(L,NY,NX)=TRC1P(L,NY,NX)+DZC1P
      TRC2P(L,NY,NX)=TRC2P(L,NY,NX)+DZC2P
      TRM1P(L,NY,NX)=TRM1P(L,NY,NX)+DZM1P
      TRH0B(L,NY,NX)=TRH0B(L,NY,NX)-DZH0P
      TRH1B(L,NY,NX)=TRH1B(L,NY,NX)-DZH1P
      TRH2B(L,NY,NX)=TRH2B(L,NY,NX)-DZH2P
      TRH3B(L,NY,NX)=TRH3B(L,NY,NX)-DZH3P
      TRF1B(L,NY,NX)=TRF1B(L,NY,NX)-DZF1P
      TRF2B(L,NY,NX)=TRF2B(L,NY,NX)-DZF2P
      TRC0B(L,NY,NX)=TRC0B(L,NY,NX)-DZC0P
      TRC1B(L,NY,NX)=TRC1B(L,NY,NX)-DZC1P
      TRC2B(L,NY,NX)=TRC2B(L,NY,NX)-DZC2P
      TRM1B(L,NY,NX)=TRM1B(L,NY,NX)-DZM1P
      TRXH0(L,NY,NX)=TRXH0(L,NY,NX)+DXOH0
      TRXH1(L,NY,NX)=TRXH1(L,NY,NX)+DXOH1
      TRXH2(L,NY,NX)=TRXH2(L,NY,NX)+DXOH2
      TRX1P(L,NY,NX)=TRX1P(L,NY,NX)+DXH1P
      TRX2P(L,NY,NX)=TRX2P(L,NY,NX)+DXH2P
      TRBH0(L,NY,NX)=TRBH0(L,NY,NX)-DXOH0
      TRBH1(L,NY,NX)=TRBH1(L,NY,NX)-DXOH1
      TRBH2(L,NY,NX)=TRBH2(L,NY,NX)-DXOH2
      TRB1P(L,NY,NX)=TRB1P(L,NY,NX)-DXH1P
      TRB2P(L,NY,NX)=TRB2P(L,NY,NX)-DXH2P
      TRALPO(L,NY,NX)=TRALPO(L,NY,NX)+DPALP
      TRFEPO(L,NY,NX)=TRFEPO(L,NY,NX)+DPFEP
      TRCAPD(L,NY,NX)=TRCAPD(L,NY,NX)+DPCDP
      TRCAPH(L,NY,NX)=TRCAPH(L,NY,NX)+DPCHP
      TRCAPM(L,NY,NX)=TRCAPM(L,NY,NX)+DPCMP
      TRALPB(L,NY,NX)=TRALPB(L,NY,NX)-DPALP
      TRFEPB(L,NY,NX)=TRFEPB(L,NY,NX)-DPFEP
      TRCPDB(L,NY,NX)=TRCPDB(L,NY,NX)-DPCDP
      TRCPHB(L,NY,NX)=TRCPHB(L,NY,NX)-DPCHP
      TRCPMB(L,NY,NX)=TRCPMB(L,NY,NX)-DPCMP
      ELSE
      DZH2P=FVLPO4*H2PO4(L,NY,NX)/31.0
      DXOH1=FVLPO4*XOH1(L,NY,NX)
      DXOH2=FVLPO4*XOH2(L,NY,NX)
      DXH2P=FVLPO4*XH2P(L,NY,NX)
      DPALP=FVLPO4*PALPO(L,NY,NX)
      DPFEP=FVLPO4*PFEPO(L,NY,NX)
      DPCDP=FVLPO4*PCAPD(L,NY,NX)
      DPCHP=FVLPO4*PCAPH(L,NY,NX)
      DPCMP=FVLPO4*PCAPM(L,NY,NX)
      TRH2P(L,NY,NX)=TRH2P(L,NY,NX)+DZH2P
      TRXH1(L,NY,NX)=TRXH1(L,NY,NX)+DXOH1
      TRXH2(L,NY,NX)=TRXH2(L,NY,NX)+DXOH2
      TRX2P(L,NY,NX)=TRX2P(L,NY,NX)+DXH2P
      TRH2B(L,NY,NX)=TRH2B(L,NY,NX)-DZH2P
      TRBH1(L,NY,NX)=TRBH1(L,NY,NX)-DXOH1
      TRBH2(L,NY,NX)=TRBH2(L,NY,NX)-DXOH2
      TRB2P(L,NY,NX)=TRB2P(L,NY,NX)-DXH2P
      TRALPO(L,NY,NX)=TRALPO(L,NY,NX)+DPALP
      TRFEPO(L,NY,NX)=TRFEPO(L,NY,NX)+DPFEP
      TRCAPD(L,NY,NX)=TRCAPD(L,NY,NX)+DPCDP
      TRCAPH(L,NY,NX)=TRCAPH(L,NY,NX)+DPCHP
      TRCAPM(L,NY,NX)=TRCAPM(L,NY,NX)+DPCMP
      TRALPB(L,NY,NX)=TRALPB(L,NY,NX)-DPALP
      TRFEPB(L,NY,NX)=TRFEPB(L,NY,NX)-DPFEP
      TRCPDB(L,NY,NX)=TRCPDB(L,NY,NX)-DPCDP
      TRCPHB(L,NY,NX)=TRCPHB(L,NY,NX)-DPCHP
      TRCPMB(L,NY,NX)=TRCPMB(L,NY,NX)-DPCMP
      ENDIF
      ELSE
C
C     AMALGAMATE PO4 BAND WITH NON-BAND
C
      DPPOB(L,NY,NX)=0.0
      WDPOB(L,NY,NX)=0.0
      VLPOB(L,NY,NX)=0.0
      VLPO4(L,NY,NX)=1.0
      H0PO4(L,NY,NX)=H0PO4(L,NY,NX)+H0POB(L,NY,NX)
      H1PO4(L,NY,NX)=H1PO4(L,NY,NX)+H1POB(L,NY,NX)
      H2PO4(L,NY,NX)=H2PO4(L,NY,NX)+H2POB(L,NY,NX)
      H3PO4(L,NY,NX)=H3PO4(L,NY,NX)+H3POB(L,NY,NX)
      ZFE1P(L,NY,NX)=ZFE1P(L,NY,NX)+ZFE1PB(L,NY,NX)
      ZFE2P(L,NY,NX)=ZFE2P(L,NY,NX)+ZFE2PB(L,NY,NX)
      ZCA0P(L,NY,NX)=ZCA0P(L,NY,NX)+ZCA0PB(L,NY,NX)
      ZCA1P(L,NY,NX)=ZCA1P(L,NY,NX)+ZCA1PB(L,NY,NX)
      ZCA2P(L,NY,NX)=ZCA2P(L,NY,NX)+ZCA2PB(L,NY,NX)
      ZMG1P(L,NY,NX)=ZMG1P(L,NY,NX)+ZMG1PB(L,NY,NX)
      H0POB(L,NY,NX)=0.0
      H1POB(L,NY,NX)=0.0
      H2POB(L,NY,NX)=0.0
      H3POB(L,NY,NX)=0.0
      ZFE1PB(L,NY,NX)=0.0
      ZFE2PB(L,NY,NX)=0.0
      ZCA0PB(L,NY,NX)=0.0
      ZCA1PB(L,NY,NX)=0.0
      ZCA2PB(L,NY,NX)=0.0
      ZMG1PB(L,NY,NX)=0.0
      XOH0(L,NY,NX)=XOH0(L,NY,NX)+XOH0B(L,NY,NX)
      XOH1(L,NY,NX)=XOH1(L,NY,NX)+XOH1B(L,NY,NX)
      XOH2(L,NY,NX)=XOH2(L,NY,NX)+XOH2B(L,NY,NX)
      XH1P(L,NY,NX)=XH1P(L,NY,NX)+XH1PB(L,NY,NX)
      XH2P(L,NY,NX)=XH2P(L,NY,NX)+XH2PB(L,NY,NX)
      XOH0B(L,NY,NX)=0.0
      XOH1B(L,NY,NX)=0.0
      XOH2B(L,NY,NX)=0.0
      XH1PB(L,NY,NX)=0.0
      XH2PB(L,NY,NX)=0.0
      PALPO(L,NY,NX)=PALPO(L,NY,NX)+PALPB(L,NY,NX)
      PFEPO(L,NY,NX)=PFEPO(L,NY,NX)+PFEPB(L,NY,NX)
      PCAPD(L,NY,NX)=PCAPD(L,NY,NX)+PCPDB(L,NY,NX)
      PCAPH(L,NY,NX)=PCAPH(L,NY,NX)+PCPHB(L,NY,NX)
      PCAPM(L,NY,NX)=PCAPM(L,NY,NX)+PCPMB(L,NY,NX)
      PALPB(L,NY,NX)=0.0
      PFEPB(L,NY,NX)=0.0
      PCPDB(L,NY,NX)=0.0
      PCPHB(L,NY,NX)=0.0
      PCPMB(L,NY,NX)=0.0
      ENDIF
      ENDIF
C     ENDIF
C
C     SUBTRACT FERTILIZER DISSOLUTION FROM FERTILIZER POOLS
C
      ZNH4FA(L,NY,NX)=ZNH4FA(L,NY,NX)-RSN4AA-RSN4BA
      ZNH3FA(L,NY,NX)=ZNH3FA(L,NY,NX)-RSN3AA-RSN3BA
      ZNHUFA(L,NY,NX)=ZNHUFA(L,NY,NX)-RSNUAA-RSNUBA
      ZNO3FA(L,NY,NX)=ZNO3FA(L,NY,NX)-RSNOAA-RSNOBA
      ZNH4FB(L,NY,NX)=ZNH4FB(L,NY,NX)-RSN4BB
      ZNH3FB(L,NY,NX)=ZNH3FB(L,NY,NX)-RSN3BB
      ZNHUFB(L,NY,NX)=ZNHUFB(L,NY,NX)-RSNUBB
      ZNO3FB(L,NY,NX)=ZNO3FB(L,NY,NX)-RSNOBB
C
C     ADD FERTILIZER DISSOLUTION TO ION FLUXES
C
      TRN3G(L,NY,NX)=TRN3G(L,NY,NX)+RSN3AA+RSN3BA+RSN3BB 
      TRN4S(L,NY,NX)=TRN4S(L,NY,NX)+RSN4AA 
      TRN4B(L,NY,NX)=TRN4B(L,NY,NX)+RSN4BA+RSN4BB 
      TRN3S(L,NY,NX)=TRN3S(L,NY,NX)+RSNUAA
      TRN3B(L,NY,NX)=TRN3B(L,NY,NX)+RSNUBA+RSNUBB
      TRNO3(L,NY,NX)=TRNO3(L,NY,NX)+RSNOAA
      TRNOB(L,NY,NX)=TRNOB(L,NY,NX)+RSNOBA+RSNOBB
      TBNH4(L,NY,NX)=TBNH4(L,NY,NX)+RSN4AA+RSN4BA+RSN4BB
      TBNH3(L,NY,NX)=TBNH3(L,NY,NX)+RSN3AA+RSN3BA+RSN3BB
     2+RSNUAA+RSNUBA+RSNUBB
      TBNO3(L,NY,NX)=TBNO3(L,NY,NX)+RSNOAA+RSNOBA+RSNOBB
      TRN3G(L,NY,NX)=TRN3G(L,NY,NX)*14.0
      TRN4S(L,NY,NX)=TRN4S(L,NY,NX)*14.0
      TRN4B(L,NY,NX)=TRN4B(L,NY,NX)*14.0
      TRN3S(L,NY,NX)=TRN3S(L,NY,NX)*14.0
      TRN3B(L,NY,NX)=TRN3B(L,NY,NX)*14.0
      TRNO3(L,NY,NX)=TRNO3(L,NY,NX)*14.0
      TRNOB(L,NY,NX)=TRNOB(L,NY,NX)*14.0
      TRNO2(L,NY,NX)=TRNO2(L,NY,NX)*14.0
      TRN2B(L,NY,NX)=TRN2B(L,NY,NX)*14.0
      TRH2P(L,NY,NX)=TRH2P(L,NY,NX)*31.0
      TRH2B(L,NY,NX)=TRH2B(L,NY,NX)*31.0
      TRCO2(L,NY,NX)=TBCO2(L,NY,NX)*12.0
C     IF(L.EQ.1)THEN
C     WRITE(*,9984)'TRN4S',I,J,L,TRN4S(L,NY,NX)
C    2,RN4S,VOLWNH,RSN4AA,ZNH4FA(L,NY,NX),VLNH4(L,NY,NX)
9984  FORMAT(A8,3I4,20E12.4)
C     ENDIF
      ENDIF
9985  CONTINUE
C
C     SURFACE RESIDUE
C
      IF(VOLWM(NPH,0,NY,NX).GT.ZEROS(NY,NX))THEN
C
C     UREA HYDROLYSIS IN SURFACE RESIDUE
C
      IF(VOLQ(0,NY,NX).GT.ZEROS(NY,NX))THEN
      COMA=AMIN1(0.1E+06,OMAT(0,NY,NX)/VOLQ(0,NY,NX))
      ELSE
      COMA=0.1E+06
      ENDIF
      DUKD=DUKM*(1.0+COMA/DUKI)
C
C     UREA CONCENTRATION AND HYDROLYSIS IN SURFACE RESIDUE
C
      IF(ZNHUFA(0,NY,NX).GT.ZEROS(NY,NX)
     2.AND.BKVL(0,NY,NX).GT.ZEROS(NY,NX))THEN
      CNHUA=ZNHUFA(0,NY,NX)/BKVL(0,NY,NX)
      DFNSA=CNHUA/(CNHUA+DUKD)
      RSNUA=AMIN1(ZNHUFA(0,NY,NX)
     2,SPNHU(IFTYP(NY,NX))*OMAT(0,NY,NX)*DFNSA*TFNQ(0,NY,NX))
     3*THETW(0,NY,NX)
      ELSE
      RSNUA=0.0
      ENDIF
C     WRITE(*,8778)'UREA',I,J,RSNUA,ZNHUFA(0,NY,NX),SPNHU(IFTYP(NY,NX))
C    2,OMAT(0,NY,NX),DFNSA,TFNQ(0,NY,NX),CNHUA,DUKD,DUKM,DUKI,COMA
C    3,VOLQ(0,NY,NX),BKVL(0,NY,NX)
8778  FORMAT(A8,2I4,40E12.4)
C
C     NH4, NH3, UREA, NO3 DISSOLUTION IN SURFACE RESIDUE
C     FROM FIRST-ORDER FUNCTIONS OF REMAINING
C     FERTILIZER (NOTE: SUPERPHOSPHATE AND ROCK PHOSPHATE
C     ARE REPRESENTED AS MONOCALCIUM PHOSPHATE AND HYDROXYAPATITE
C     MODELLED IN PHOSPHORUS REACTIONS BELOW)
C
      RSN4AA=SPNH4(IFTYP(NY,NX))*ZNH4FA(0,NY,NX)*THETW(0,NY,NX)
      RSN3AA=SPNH3(IFTYP(NY,NX))*ZNH3FA(0,NY,NX)
      RSNUAA=RSNUA*THETW(0,NY,NX)
      RSNOAA=SPNO3(IFTYP(NY,NX))*ZNO3FA(0,NY,NX)*THETW(0,NY,NX)
      IF(VOLWM(NPH,0,NY,NX).GT.ZEROS(NY,NX))THEN
      VOLWMX=14.0*VOLWM(NPH,0,NY,NX)
      RN4X=(XNH4S(0,NY,NX)+14.0*RSN4AA)/VOLWMX
      RN3X=14.0*RSNUAA/VOLWMX
      CN41=AMAX1(0.0,ZNH4S(0,NY,NX)/VOLWMX+RN4X)
      CN31=AMAX1(0.0,ZNH3S(0,NY,NX)/VOLWMX+RN3X)
      XN41=AMAX1(0.0,XN4(0,NY,NX)/VOLWM(NPH,0,NY,NX))
      VOLWMP=31.0*VOLWM(NPH,0,NY,NX)
      RH2PX=XH2PS(0,NY,NX)/VOLWMP
      CH2P1=AMAX1(0.0,H2PO4(0,NY,NX)/VOLWMP+RH2PX)
      ELSE
      RN4X=0.0
      RN3X=0.0
      CN41=0.0
      CN31=0.0
      XN41=0.0
      RH2PX=0.0
      CH2P1=0.0
      ENDIF
C
C     PHOSPHORUS TRANSFORMATIONS IN SURFACE RESIDUE
C
      PCAPM1=AMAX1(0.0,PCAPM(0,NY,NX)/VOLWM(NPH,0,NY,NX))
      PCAPD1=AMAX1(0.0,PCAPD(0,NY,NX)/VOLWM(NPH,0,NY,NX))
      PCAPH1=AMAX1(0.0,PCAPH(0,NY,NX)/VOLWM(NPH,0,NY,NX))
      PALPO1=AMAX1(0.0,PALPO(0,NY,NX)/VOLWM(NPH,0,NY,NX))
      PFEPO1=AMAX1(0.0,PFEPO(0,NY,NX)/VOLWM(NPH,0,NY,NX))
      CHY1=AMAX1(ZERO,10.0**(-(PH(0,NY,NX)-3.0)))
      COH1=AMAX1(ZERO,DPH2O/CHY1)
      CAL1=AMAX1(ZERO,SYALO/COH1**3)
      CFE1=AMAX1(ZERO,SYFEO/COH1**3)
      CCO20=AMAX1(ZERO,CCO2S(0,NY,NX)/12.0)
      CCO31=AMAX1(ZERO,CCO20*DPCO3/CHY1**2)
      CCA1=AMAX1(ZERO,AMIN1(CCAMX,SPCAC/CCO31))
      CALX=AMAX1(ZERO,CAL1)**0.333
      CCAX=AMAX1(ZERO,CCA1)**0.500
C
C     ALUMINUM PHOSPHATE (VARISCITE)
C
      CH2PA=SYA0P2/(CAL1*COH1**2)
      RPALPX=AMIN1(AMAX1(0.0,4.0E-08*ORGC(0,NY,NX)-PALPO1)
     2,AMAX1(-PALPO1,TPD*(CH2P1-CH2PA)))
C
C     IRON PHOSPHATE (STRENGITE)
C
      CH2PF=SYF0P2/(CFE1*COH1**2)
      RPFEPX=AMIN1(AMAX1(0.0,2.0E-06*ORGC(0,NY,NX)-PFEPO1)
     2,AMAX1(-PFEPO1,TPD*(CH2P1-CH2PF)))
C
C     DICALCIUM PHOSPHATE
C
      CH2PD=SYCAD2/(CCA1*COH1)
      RPCADX=AMIN1(AMAX1(0-.0,5.0E-05*ORGC(0,NY,NX)-PCAPD1)
     2,AMAX1(-PCAPD1,TPD*(CH2P1-CH2PD)))
C
C     HYDROXYAPATITE
C
      CH2PH=(SYCAH2/(CCA1**5*COH1**7))**0.333
      RPCAHX=AMIN1(AMAX1(0.0,5.0E-05*ORGC(0,NY,NX)-PCAPH1)
     2,AMAX1(-PCAPH1,TPD*(CH2P1-CH2PH)))
C
C     MONOCALCIUM PHOSPHATE
C
      CH2PM=SQRT(SPCAM/CCA1)
      RPCAMX=AMIN1(AMAX1(0.0,5.0E-05*ORGC(0,NY,NX)-PCAPM1)
     2,AMAX1(-PCAPM1*SPPO4(IFTYP(NY,NX)),TPD*(CH2P1-CH2PM)))
C     IF(I.GT.315)THEN
C     WRITE(*,2227)'RPPO4',I,J,L,RPCAHX,CH2P1,CH2PA,CH2PH
C    2,SYA0P2,CAL1,COH1,SYCAH2,CCA1,CCO21,CCO31,PCAPH1
C    3,VOLWM(NPH,0,NY,NX),SPCAC/CCO31,H2PO4(0,NY,NX)
C    4,CCO20,DPCO3,CHY1,CCO2S(0,NY,NX)
2227  FORMAT(A8,3I4,20E12.4)
C     ENDIF
C
C     PHOSPHORUS ANION EXCHANGE IN SURFACE REDISUE
C     CALCULATED FROM EXCHANGE EQUILIBRIA AMONG H2PO4-,
C     HPO4--, H+, OH- AND PROTONATED AND NON-PROTONATED -OH
C     EXCHANGE SITES (NOT CALCULATED)
C
C     EQUILIBRIUM X-CA CONCENTRATION FROM CEC AND CATION
C     CONCENTRATIONS
C
      IF(VOLWM(NPH,0,NY,NX).GT.ZEROS(NY,NX))THEN
      CCEC0=AMAX1(0.0,COOH*ORGC(0,NY,NX)/VOLWM(NPH,0,NY,NX))
      ELSE
      CCEC0=0.0
      ENDIF
      XCAQ=CCEC0/(1.0+GKC4(NU(NY,NX),NY,NX)*CN41/CCAX
     2+GKCH(NU(NY,NX),NY,NX)*CHY1/CCAX+GKCA(NU(NY,NX),NY,NX)*CALX/CCAX)
      FCAQ=XCAQ/CCAX
      FN4X=FCAQ*GKC4(NU(NY,NX),NY,NX)
C
C     NH4 AND NH3 EXCHANGE IN SURFACE RESIDUE
C
      RXN4=TADC*(FN4X*CN41-XN41)/(1.0+FN4X)
      RNH4=(CHY1*CN31-DPN4*CN41)/(DPN4+CHY1)
C     IF(J.EQ.12)THEN
C     WRITE(*,2223)'RXN4',I,J,NX,NY,RXN4,CN41,XN41,CCAX,CCA1,CCO20,CCO31 
C    2,XCAQ,CCEC0,FN4X,FCAQ,GKC4(NU(NY,NX),NY,NX),PH(0,NY,NX),CHY1,RNH4
C    3,CN31,DPN4,ZNH4S(0,NY,NX),XNH4S(0,NY,NX),14.0*RSN4AA,RN4X 
2223  FORMAT(A8,4I4,30E12.4)
C     ENDIF
      ELSE
      RSN4AA=0.0
      RSN3AA=0.0
      RSNUAA=0.0
      RSNOAA=0.0
      RPALPX=0.0
      RPFEPX=0.0
      RPCADX=0.0
      RPCAHX=0.0
      RPCAMX=0.0
      RXN4=0.0
      RNH4=0.0
      ENDIF
C
C     TOTAL ION FLUXES FOR ALL REACTIONS ABOVE
C
      RN4S=RNH4-RXN4
      RN3S=-RNH4
      RHP2=-RPALPX-RPFEPX-RPCADX-2.0*RPCAMX-3.0*RPCAHX
      RH2O=RPCADX+2.0*(RPALPX+RPFEPX)+6.0*RPCAHX
      BNH4=-RXN4
      BH2P=RHP2
      BION=-RPCAMX-3.0*(RPALPX+RPFEPX)-2.0*RPCADX-12.0*RPCAHX
C
C     CONVERT TOTAL ION FLUXES FROM CHANGES IN CONCENTRATION
C     TO CHANGES IN MASS PER UNIT AREA FOR USE IN 'REDIST'
C
      TRN4S(0,NY,NX)=TRN4S(0,NY,NX)+RN4S*VOLWM(NPH,0,NY,NX)
      TRN3S(0,NY,NX)=TRN3S(0,NY,NX)+RN3S*VOLWM(NPH,0,NY,NX)
      TRH2P(0,NY,NX)=TRH2P(0,NY,NX)+RHP2*VOLWM(NPH,0,NY,NX)
      TRXN4(0,NY,NX)=TRXN4(0,NY,NX)+RXN4*VOLWM(NPH,0,NY,NX)
      TRALPO(0,NY,NX)=TRALPO(0,NY,NX)+RPALPX*VOLWM(NPH,0,NY,NX)
      TRFEPO(0,NY,NX)=TRFEPO(0,NY,NX)+RPFEPX*VOLWM(NPH,0,NY,NX)
      TRCAPD(0,NY,NX)=TRCAPD(0,NY,NX)+RPCADX*VOLWM(NPH,0,NY,NX)
      TRCAPH(0,NY,NX)=TRCAPH(0,NY,NX)+RPCAHX*VOLWM(NPH,0,NY,NX)
      TRCAPM(0,NY,NX)=TRCAPM(0,NY,NX)+RPCAMX*VOLWM(NPH,0,NY,NX)
      TRH2O(0,NY,NX)=TRH2O(0,NY,NX)+RH2O*VOLWM(NPH,0,NY,NX)
      TBNH4(0,NY,NX)=TBNH4(0,NY,NX)+BNH4*VOLWM(NPH,0,NY,NX)
      TBH2P(0,NY,NX)=TBH2P(0,NY,NX)+BH2P*VOLWM(NPH,0,NY,NX)
      TBION(0,NY,NX)=TBION(0,NY,NX)+BION*VOLWM(NPH,0,NY,NX)
      ZNH4FA(0,NY,NX)=ZNH4FA(0,NY,NX)-RSN4AA
      ZNH3FA(0,NY,NX)=ZNH3FA(0,NY,NX)-RSN3AA
      ZNHUFA(0,NY,NX)=ZNHUFA(0,NY,NX)-RSNUAA
      ZNO3FA(0,NY,NX)=ZNO3FA(0,NY,NX)-RSNOAA
      TRN4S(0,NY,NX)=TRN4S(0,NY,NX)+RSN4AA 
      TRN3S(0,NY,NX)=TRN3S(0,NY,NX)+RSN3AA+RSNUAA 
      TRNO3(0,NY,NX)=TRNO3(0,NY,NX)+RSNOAA
      TBNH4(0,NY,NX)=TBNH4(0,NY,NX)+RSN4AA 
      TBNH3(0,NY,NX)=TBNH3(0,NY,NX)+RSN3AA+RSNUAA
      TBNO3(0,NY,NX)=TBNO3(0,NY,NX)+RSNOAA
      TRN4S(0,NY,NX)=TRN4S(0,NY,NX)*14.0
      TRN3S(0,NY,NX)=TRN3S(0,NY,NX)*14.0
      TRNO3(0,NY,NX)=TRNO3(0,NY,NX)*14.0
      TRH2P(0,NY,NX)=TRH2P(0,NY,NX)*31.0
C     WRITE(*,9989)'TRH2O',I,J,TRH2O(0,NY,NX)
C    2,RH2O,VOLWM(NPH,0,NY,NX),RPCADX,RPALPX,RPFEPX,RPCAHX      
C     WRITE(*,9989)'TRN4S',I,J,TRN4S(0,NY,NX)
C    2,RN4S,RNH4,RXN4,RSN4AA,VOLWM(NPH,0,NY,NX)
C    3,SPNH4(IFTYP(NY,NX)),ZNH4FA(0,NY,NX)
C    4,THETW(0,NY,NX)
9989  FORMAT(A8,2I4,12E12.4)
9990  CONTINUE
9995  CONTINUE
      RETURN
      END
