
      SUBROUTINE redist(I,J,NHW,NHE,NVN,NVS)
C
C     THIS SUBROUTINE UPDATES SOIL STATE VARIABLES WITH WATER, HEAT,
C     C, N, P, SOLUTE FLUXES CALCULATED IN EARLIER SUBROUTINES
C
      include "parameters.h"
      include "blkc.h"
      include "blk2a.h"
      include "blk2b.h"
      include "blk2c.h"
      include "blk5.h"
      include "blk8a.h"
      include "blk8b.h"
      include "blk11a.h"
      include "blk11b.h"
      include "blk13a.h"
      include "blk13b.h"
      include "blk13c.h"
      include "blk15a.h"
      include "blk15b.h"
      include "blk16.h"
      include "blk18a.h"
      include "blk18b.h"
      include "blk19a.h"
      include "blk19b.h"
      include "blk19c.h"
      include "blk19d.h"
      include "blk20a.h"
      include "blk20b.h"
      include "blk20c.h"
      include "blk20d.h"
      include "blk20e.h"
      include "blk20f.h"
      include "blk21a.h"
      include "blk21b.h"
      include "blk22a.h"
      include "blk22b.h"
      include "blk22c.h"
      DIMENSION TFLW(JZ,JY,JX),TFLWX(JZ,JY,JX),THFLW(JZ,JY,JX)
     1,TFLWH(JZ,JY,JX),TOCFLS(0:4,JZ,JY,JX),TONFLS(0:4,JZ,JY,JX)
     2,TOPFLS(0:4,JZ,JY,JX),TOAFLS(0:4,JZ,JY,JX),TCOFLS(JZ,JY,JX)
     3,TCHFLS(JZ,JY,JX),TOXFLS(JZ,JY,JX),TNXFLB(JZ,JY,JX)
     4,TNGFLS(JZ,JY,JX),TN2FLS(JZ,JY,JX),TN4FLS(JZ,JY,JX)
     5,TN4FLB(JZ,JY,JX),TN3FLS(JZ,JY,JX),TN3FLB(JZ,JY,JX)
     6,TNOFLS(JZ,JY,JX),TNOFLB(JZ,JY,JX),TPOFLS(JZ,JY,JX)
     7,TH2BFB(JZ,JY,JX),TNXFLS(JZ,JY,JX),TOCFHS(0:4,JZ,JY,JX)
     8,TONFHS(0:4,JZ,JY,JX),TOPFHS(0:4,JZ,JY,JX),TOAFHS(0:4,JZ,JY,JX)
     9,TCOFHS(JZ,JY,JX),TCHFHS(JZ,JY,JX),TNXFHB(JZ,JY,JX)
     2,TOXFHS(JZ,JY,JX),TNGFHS(JZ,JY,JX),TN2FHS(JZ,JY,JX)
     2,TN4FHS(JZ,JY,JX),TN4FHB(JZ,JY,JX),TN3FHS(JZ,JY,JX)
     3,TN3FHB(JZ,JY,JX),TNOFHS(JZ,JY,JX),TNOFHB(JZ,JY,JX)
     4,TPOFHS(JZ,JY,JX),TH2BHB(JZ,JY,JX),TNXFHS(JZ,JY,JX)
     5,TCOFLG(JZ,JY,JX),TCHFLG(JZ,JY,JX),TOXFLG(JZ,JY,JX)
     6,TNGFLG(JZ,JY,JX),TN2FLG(JZ,JY,JX),TNHFLG(JZ,JY,JX)
     7,TTHAW(JZ,JY,JX),THTHAW(JZ,JY,JX),TTHAWH(JZ,JY,JX)
      DIMENSION TQR(JY,JX),THQR(JY,JX),TQS(JY,JX)
     2,TQW(JY,JX),TQI(JY,JX),THQS(JY,JX),TOCQRS(0:4,JY,JX)
     1,TONQRS(0:4,JY,JX),TOPQRS(0:4,JY,JX),TOAQRS(0:4,JY,JX)
     2,TCOQRS(JY,JX),TCHQRS(JY,JX),TOXQRS(JY,JX)
     3,TNGQRS(JY,JX),TN2QRS(JY,JX),TN4QRS(JY,JX),TN3QRS(JY,JX)
     4,TNOQRS(JY,JX),TPOQRS(JY,JX),TNXQRS(JY,JX),TQRAL(JY,JX)
     6,TQRFE(JY,JX),TQRHY(JY,JX),TQRCA(JY,JX),TQRMG(JY,JX)
     7,TQRNA(JY,JX),TQRKA(JY,JX),TQROH(JY,JX),TQRSO(JY,JX)
     8,TQRCL(JY,JX),TQRC3(JY,JX),TQRHC(JY,JX),TQRAL1(JY,JX)
     9,TQRAL2(JY,JX),TQRAL3(JY,JX),TQRAL4(JY,JX),TQRALS(JY,JX)
     1,TQRFE1(JY,JX),TQRFE2(JY,JX),TQRFE3(JY,JX),TQRFE4(JY,JX)
     2,TQRFES(JY,JX),TQRCAO(JY,JX),TQRCAC(JY,JX),TQRCAH(JY,JX)
     3,TQRCAS(JY,JX),TQRMGO(JY,JX),TQRMGC(JY,JX),TQRMGH(JY,JX)
     4,TQRMGS(JY,JX),TQRNAC(JY,JX),TQRNAS(JY,JX),TQRKAS(JY,JX)
     5,TQRH0P(JY,JX),TQRH1P(JY,JX),TQRH3P(JY,JX),TQRF1P(JY,JX)
     6,TQRF2P(JY,JX),TQRC0P(JY,JX),TQRC1P(JY,JX),TQRC2P(JY,JX)
     7,TQRM1P(JY,JX),TCOQSS(JY,JX),TCHQSS(JY,JX),TOXQSS(JY,JX)
     3,TNGQSS(JY,JX),TN2QSS(JY,JX),TN4QSS(JY,JX),TN3QSS(JY,JX)
     4,TNOQSS(JY,JX),TPOQSS(JY,JX),TQSAL(JY,JX)
     6,TQSFE(JY,JX),TQSHY(JY,JX),TQSCA(JY,JX),TQSMG(JY,JX)
     7,TQSNA(JY,JX),TQSKA(JY,JX),TQSOH(JY,JX),TQSSO(JY,JX)
     8,TQSCL(JY,JX),TQSC3(JY,JX),TQSHC(JY,JX),TQSAL1(JY,JX)
     9,TQSAL2(JY,JX),TQSAL3(JY,JX),TQSAL4(JY,JX),TQSALS(JY,JX)
     1,TQSFE1(JY,JX),TQSFE2(JY,JX),TQSFE3(JY,JX),TQSFE4(JY,JX)
     2,TQSFES(JY,JX),TQSCAO(JY,JX),TQSCAC(JY,JX),TQSCAH(JY,JX)
     3,TQSCAS(JY,JX),TQSMGO(JY,JX),TQSMGC(JY,JX),TQSMGH(JY,JX)
     4,TQSMGS(JY,JX),TQSNAC(JY,JX),TQSNAS(JY,JX),TQSKAS(JY,JX)
     5,TQSH0P(JY,JX),TQSH1P(JY,JX),TQSH3P(JY,JX),TQSF1P(JY,JX)
     6,TQSF2P(JY,JX),TQSC0P(JY,JX),TQSC1P(JY,JX),TQSC2P(JY,JX)
     7,TQSM1P(JY,JX)

      DIMENSION TALFLS(JZ,JY,JX),TFEFLS(JZ,JY,JX)
     1,TCAFLS(JZ,JY,JX),THYFLS(JZ,JY,JX),TMGFLS(JZ,JY,JX)
     2,TNAFLS(JZ,JY,JX),TKAFLS(JZ,JY,JX),TOHFLS(JZ,JY,JX)
     3,TSOFLS(JZ,JY,JX),TCLFLS(JZ,JY,JX),TC3FLS(JZ,JY,JX)
     4,THCFLS(JZ,JY,JX),TAL1FS(JZ,JY,JX),TAL2FS(JZ,JY,JX)
     5,TAL3FS(JZ,JY,JX),TAL4FS(JZ,JY,JX),TALSFS(JZ,JY,JX)
     6,TFE1FS(JZ,JY,JX),TFE2FS(JZ,JY,JX)
     7,TFE3FS(JZ,JY,JX),TFE4FS(JZ,JY,JX),TFESFS(JZ,JY,JX)
     8,TCAOFS(JZ,JY,JX),TCACFS(JZ,JY,JX),TCAHFS(JZ,JY,JX)
     9,TCASFS(JZ,JY,JX),TMGOFS(JZ,JY,JX),TMGCFS(JZ,JY,JX)
     1,TMGHFS(JZ,JY,JX),TMGSFS(JZ,JY,JX),TNACFS(JZ,JY,JX)
     2,TNASFS(JZ,JY,JX),TKASFS(JZ,JY,JX),TH0PFS(JZ,JY,JX)
     3,TH1PFS(JZ,JY,JX),TH3PFS(JZ,JY,JX),TF1PFS(JZ,JY,JX)
     4,TF2PFS(JZ,JY,JX),TC0PFS(JZ,JY,JX),TC1PFS(JZ,JY,JX)
     5,TC2PFS(JZ,JY,JX),TM1PFS(JZ,JY,JX),TH0BFB(JZ,JY,JX)
     6,TH1BFB(JZ,JY,JX),TH3BFB(JZ,JY,JX),TF1BFB(JZ,JY,JX)
     7,TF2BFB(JZ,JY,JX),TC0BFB(JZ,JY,JX),TC1BFB(JZ,JY,JX)
     8,TC2BFB(JZ,JY,JX),TM1BFB(JZ,JY,JX)
      DIMENSION TALFHS(JZ,JY,JX),TFEFHS(JZ,JY,JX)
     1,THYFHS(JZ,JY,JX),TCAFHS(JZ,JY,JX),TMGFHS(JZ,JY,JX)
     2,TNAFHS(JZ,JY,JX),TKAFHS(JZ,JY,JX),TOHFHS(JZ,JY,JX)
     3,TSOFHS(JZ,JY,JX),TCLFHS(JZ,JY,JX),TC3FHS(JZ,JY,JX)
     4,THCFHS(JZ,JY,JX),TAL1HS(JZ,JY,JX),TAL2HS(JZ,JY,JX)
     5,TAL3HS(JZ,JY,JX),TAL4HS(JZ,JY,JX),TALSHS(JZ,JY,JX)
     6,TFE1HS(JZ,JY,JX),TFE2HS(JZ,JY,JX)
     7,TFE3HS(JZ,JY,JX),TFE4HS(JZ,JY,JX),TFESHS(JZ,JY,JX)
     8,TCAOHS(JZ,JY,JX),TCACHS(JZ,JY,JX),TCAHHS(JZ,JY,JX)
     9,TCASHS(JZ,JY,JX),TMGOHS(JZ,JY,JX),TMGCHS(JZ,JY,JX)
     1,TMGHHS(JZ,JY,JX),TMGSHS(JZ,JY,JX),TNACHS(JZ,JY,JX)
     2,TNASHS(JZ,JY,JX),TKASHS(JZ,JY,JX),TH0PHS(JZ,JY,JX)
     3,TH1PHS(JZ,JY,JX),TH3PHS(JZ,JY,JX),TF1PHS(JZ,JY,JX)
     4,TF2PHS(JZ,JY,JX),TC0PHS(JZ,JY,JX),TC1PHS(JZ,JY,JX)
     5,TC2PHS(JZ,JY,JX),TM1PHS(JZ,JY,JX),TH0BHB(JZ,JY,JX)
     6,TH1BHB(JZ,JY,JX),TH3BHB(JZ,JY,JX),TF1BHB(JZ,JY,JX)
     7,TF2BHB(JZ,JY,JX),TC0BHB(JZ,JY,JX),TC1BHB(JZ,JY,JX)
     8,TC2BHB(JZ,JY,JX),TM1BHB(JZ,JY,JX)
      DIMENSION TSANER(JY,JX),TSILER(JY,JX),TCLAER(JY,JX)
     2,TCECER(JY,JX),TAECER(JY,JX),TNH4ER(JY,JX),TNH3ER(JY,JX)
     3,TNHUER(JY,JX),TNO3ER(JY,JX),TNH4EB(JY,JX),TNH3EB(JY,JX)
     4,TNHUEB(JY,JX),TNO3EB(JY,JX),TN4ER(JY,JX),TNBER(JY,JX)
     5,THYER(JY,JX),TALER(JY,JX),TCAER(JY,JX),TMGER(JY,JX)
     6,TNAER(JY,JX),TKAER(JY,JX),THCER(JY,JX),TAL2ER(JY,JX)
     7,TOH0ER(JY,JX),TOH1ER(JY,JX),TOH2ER(JY,JX),TH1PER(JY,JX)
     8,TH2PER(JY,JX),TOH0EB(JY,JX),TOH1EB(JY,JX),TOH2EB(JY,JX)
     9,TH1PEB(JY,JX),TH2PEB(JY,JX),TALOER(JY,JX),TFEOER(JY,JX)
     1,TCACER(JY,JX),TCASER(JY,JX),TALPER(JY,JX),TFEPER(JY,JX)
     2,TCPDER(JY,JX),TCPHER(JY,JX),TCPMER(JY,JX),TALPEB(JY,JX)
     3,TFEPEB(JY,JX),TCPDEB(JY,JX),TCPHEB(JY,JX),TCPMEB(JY,JX)
     4,TOMCER(3,7,0:5,JY,JX),TOMNER(3,7,0:5,JY,JX),TOMPER(3,7,0:5,JY,JX)
     5,TORCER(2,0:4,JY,JX),TORNER(2,0:4,JY,JX),TORPER(2,0:4,JY,JX)
     6,TOHCER(0:4,JY,JX),TOHNER(0:4,JY,JX),TOHPER(0:4,JY,JX)
     7,TOHAER(0:4,JY,JX),TOSCER(4,0:4,JY,JX),TOSAER(4,0:4,JY,JX)
     8,TOSNER(4,0:4,JY,JX),TOSPER(4,0:4,JY,JX),TSEDER(JY,JX)
      DIMENSION TOMC(3,7,0:5),TOMN(3,7,0:5),TOMP(3,7,0:5),TORC(2,0:4)
     2,TORN(2,0:4),TORP(2,0:4),TOQC(0:4),TOQN(0:4),TOQP(0:4),TOQA(0:4)
     3,TOHC(0:4),TOHN(0:4),TOHP(0:4),TOHA(0:4),TOSC(4,0:4),TOSA(4,0:4)
     4,TOSN(4,0:4),TOSP(4,0:4),TOSGC(4,0:2),TOSGA(4,0:2),TOSGN(4,0:2)
     5,TOSGP(4,0:2),TOMGC(3,7,0:5),TOMGN(3,7,0:5),TOMGP(3,7,0:5)
     6,TORXC(2,0:2),TORXN(2,0:2),TORXP(2,0:2),TOQGC(0:2),TOQGN(0:2)
     7,TOQGP(0:2),TOQHC(0:2),TOQHN(0:2),TOQHP(0:2),TOHGC(0:2)
     8,TOHGN(0:2),TOHGP(0:2), TOHGA(0:2),TOQGA(0:2),TOQHA(0:2)
     9,THGQRS(JY,JX),THGFHS(JZ,JY,JX),THGFLG(JZ,JY,JX),THGFLS(JZ,JY,JX)
     1,OMCL(0:JZ,JY,JX),OMNL(0:JZ,JY,JX),OMCNLL(0:JZ,JY,JX)
C ZM
C     2,OMCN(1:7,0:JZ,JY,JX),OMNN(1:7,0:JZ,JY,JX),OMCN1(0:JZ,JY,JX)
     2,OMCN1(0:JZ,JY,JX)
     3,OMCN2(0:JZ,JY,JX),OMCN3(0:JZ,JY,JX),OMCN4(0:JZ,JY,JX)
     4,OMCN5(0:JZ,JY,JX),OMCN6(0:JZ,JY,JX),OMCN7(0:JZ,JY,JX)
     5,OMNN1(0:JZ,JY,JX),OMNN2(0:JZ,JY,JX),OMNN3(0:JZ,JY,JX)
     6,OMNN4(0:JZ,JY,JX),OMNN5(0:JZ,JY,JX),OMNN6(0:JZ,JY,JX)
     7,OMNN7(0:JZ,JY,JX)
C     ,OMCN1L(JY,JX),OMCN2L(JY,JX)
C     8,OMCN3L(JY,JX),OMCN4L(JY,JX),OMCN5L(JY,JX)
C     9,OMCN6L(JY,JX),OMCN7L(JY,JX)
C     ,OMCNSUM(JY,JX)
C     1,OMCNA1(JY,JX),OMCNA2(0:JZ,JY,JX),OMCNA3(0:JZ,JY,JX)
C     2,OMCNA5(0:JZ,JY,JX),OMNNA1(0:JZ,JY,JX),OMNNA2(0:JZ,JY,JX)
C     3,OMNNA3(0:JZ,JY,JX),OMNNA5(0:JZ,JY,JX)
C     2,OMCN(1:7,0:JZ,JY,JX),OMNN(1:7,0:JZ,JY,JX),OMCN1(JY,JX)
C     3,OMCN2(JY,JX),OMCN3(JY,JX),OMCN4(JY,JX)
C     4,OMCN5(JY,JX),OMCN6(JY,JX),OMCN7(JY,JX)
C     5,OMNN1(JY,JX),OMNN2(JY,JX),OMNN3(JY,JX)
C     6,OMNN4(JY,JX),OMNN5(JY,JX),OMNN6(JY,JX)
C     7,OMNN7(JY,JX)         
C zm     
     2,OMCI(2,0:1),OMCF(7),OSCX(4,0:1),OSNX(4,0:1),OSPX(4,0:1)
     3,EFIRE(2,21:22),ONL(4,0:4),OPL(4,0:4)
      PARAMETER (DNUMN=0.001,DNUMX=0.025)
      DATA OMCI/5.0E-05,5.0E-05,5.0E-04,5.0E-04/
      DATA OMCF/0.50,0.05,0.25,0.05,0.05,0.05,0.05/
      DATA SG/0.0/
      DATA EFIRE/1.0,1.0,0.917,0.167/
      TFLWT=0.0
      VOLPT=0.0
      VOLTT=0.0
C    ZM added depth of burn var (DBURN)
      DBURN=0.0
      DO 9995 NX=NHW,NHE
      DO 9990 NY=NVN,NVS
      TNPP(NY,NX)=TGPP(NY,NX)+TRAU(NY,NX)
C
C     ADD WATER, HEAT FLUXES FROM 'WATSUB' AND GAS, SOLUTE FLUXES
C     FROM 'TRNSFR' AND 'TRNSFRS' TO SNOWPACK
C
      IF(PRECW(NY,NX).GT.0.0.OR.FLQGM(NY,NX).GT.0.0.OR.
     2(PRECR(NY,NX).GT.0.0.AND.VHCPW(NY,NX).GT.VHCPWX(NY,NX)))THEN
      CO2W(NY,NX)=CO2W(NY,NX)+XCOBLS(NY,NX)
      CH4W(NY,NX)=CH4W(NY,NX)+XCHBLS(NY,NX)
      OXYW(NY,NX)=OXYW(NY,NX)+XOXBLS(NY,NX)
      ZNGW(NY,NX)=ZNGW(NY,NX)+XNGBLS(NY,NX)
      ZN2W(NY,NX)=ZN2W(NY,NX)+XN2BLS(NY,NX)
      H2GW(NY,NX)=H2GW(NY,NX)+XHGBLS(NY,NX)
      ZN4W(NY,NX)=ZN4W(NY,NX)+XN4BLW(NY,NX)
      ZN3W(NY,NX)=ZN3W(NY,NX)+XN3BLW(NY,NX)
      ZNOW(NY,NX)=ZNOW(NY,NX)+XNOBLW(NY,NX)
      ZHPW(NY,NX)=ZHPW(NY,NX)+XH2PBS(NY,NX)
      IF(ISALT(NY,NX).NE.0)THEN
      ZALW(NY,NX)=ZALW(NY,NX)+XALBLS(NY,NX)
      ZFEW(NY,NX)=ZFEW(NY,NX)+XFEBLS(NY,NX)
      ZHYW(NY,NX)=ZHYW(NY,NX)+XHYBLS(NY,NX)
      ZCAW(NY,NX)=ZCAW(NY,NX)+XCABLS(NY,NX)
      ZMGW(NY,NX)=ZMGW(NY,NX)+XMGBLS(NY,NX)
      ZNAW(NY,NX)=ZNAW(NY,NX)+XNABLS(NY,NX)
      ZKAW(NY,NX)=ZKAW(NY,NX)+XKABLS(NY,NX)
      ZOHW(NY,NX)=ZOHW(NY,NX)+XOHBLS(NY,NX)
      ZSO4W(NY,NX)=ZSO4W(NY,NX)+XSOBLS(NY,NX) 
      ZCLW(NY,NX)=ZCLW(NY,NX)+XCLBLS(NY,NX) 
      ZCO3W(NY,NX)=ZCO3W(NY,NX)+XC3BLS(NY,NX) 
      ZHCO3W(NY,NX)=ZHCO3W(NY,NX)+XHCBLS(NY,NX)
      ZALH1W(NY,NX)=ZALH1W(NY,NX)+XAL1BS(NY,NX)
      ZALH2W(NY,NX)=ZALH2W(NY,NX)+XAL2BS(NY,NX)
      ZALH3W(NY,NX)=ZALH3W(NY,NX)+XAL3BS(NY,NX)
      ZALH4W(NY,NX)=ZALH4W(NY,NX)+XAL4BS(NY,NX)
      ZALSW(NY,NX)=ZALSW(NY,NX)+XALSBS(NY,NX) 
      ZFEH1W(NY,NX)=ZFEH1W(NY,NX)+XFE1BS(NY,NX)
      ZFEH2W(NY,NX)=ZFEH2W(NY,NX)+XFE2BS(NY,NX)
      ZFEH3W(NY,NX)=ZFEH3W(NY,NX)+XFE3BS(NY,NX)
      ZFEH4W(NY,NX)=ZFEH4W(NY,NX)+XFE4BS(NY,NX)
      ZFESW(NY,NX)=ZFESW(NY,NX)+XFESBS(NY,NX)
      ZCAOW(NY,NX)=ZCAOW(NY,NX)+XCAOBS(NY,NX)
      ZCACW(NY,NX)=ZCACW(NY,NX)+XCACBS(NY,NX)
      ZCAHW(NY,NX)=ZCAHW(NY,NX)+XCAHBS(NY,NX)
      ZCASW(NY,NX)=ZCASW(NY,NX)+XCASBS(NY,NX)
      ZMGOW(NY,NX)=ZMGOW(NY,NX)+XMGOBS(NY,NX)
      ZMGCW(NY,NX)=ZMGCW(NY,NX)+XMGCBS(NY,NX)
      ZMGHW(NY,NX)=ZMGHW(NY,NX)+XMGHBS(NY,NX)
      ZMGSW(NY,NX)=ZMGSW(NY,NX)+XMGSBS(NY,NX)
      ZNACW(NY,NX)=ZNACW(NY,NX)+XNACBS(NY,NX)
      ZNASW(NY,NX)=ZNASW(NY,NX)+XNASBS(NY,NX)
      ZKASW(NY,NX)=ZKASW(NY,NX)+XKASBS(NY,NX)
      H0PO4W(NY,NX)=H0PO4W(NY,NX)+XH0PBS(NY,NX)
      H1PO4W(NY,NX)=H1PO4W(NY,NX)+XH1PBS(NY,NX)
      H3PO4W(NY,NX)=H3PO4W(NY,NX)+XH3PBS(NY,NX)
      ZFE1PW(NY,NX)=ZFE1PW(NY,NX)+XF1PBS(NY,NX)
      ZFE2PW(NY,NX)=ZFE2PW(NY,NX)+XF2PBS(NY,NX)
      ZCA0PW(NY,NX)=ZCA0PW(NY,NX)+XC0PBS(NY,NX)
      ZCA1PW(NY,NX)=ZCA1PW(NY,NX)+XC1PBS(NY,NX)
      ZCA2PW(NY,NX)=ZCA2PW(NY,NX)+XC2PBS(NY,NX)
      ZMG1PW(NY,NX)=ZMG1PW(NY,NX)+XM1PBS(NY,NX)
      ENDIF
      ENDIF
C 
C     CALCULATE SNOWPACK TEMPERATURE FROM ITS CHANGE
C     IN HEAT STORAGE
C
      VHCPW(NY,NX)=2.095*VOLSS(NY,NX)+4.19*VOLWS(NY,NX)
     2+1.9274*VOLIS(NY,NX)
      VOLSS(NY,NX)=VOLSS(NY,NX)+TFLWS(NY,NX)+TQS(NY,NX)
      VOLWS(NY,NX)=VOLWS(NY,NX)+TFLWW(NY,NX)+TQW(NY,NX)
      VOLIS(NY,NX)=VOLIS(NY,NX)+TFLWI(NY,NX)+TQI(NY,NX)
      DENSS=AMIN1(0.6,DENS0(NY,NX)+DENS1(NY,NX)*VOLSS(NY,NX)
     2/AREA(3,NU(NY,NX),NY,NX))
      VOLS(NY,NX)=VOLSS(NY,NX)/DENSS+VOLWS(NY,NX)+VOLIS(NY,NX)
      ENGYW=VHCPW(NY,NX)*TKW(NY,NX)
      VHCPW(NY,NX)=2.095*VOLSS(NY,NX)+4.19*VOLWS(NY,NX)
     2+1.9274*VOLIS(NY,NX)
      IF(VHCPW(NY,NX).GT.VHCPWX(NY,NX))THEN
      DPTHS(NY,NX)=AMAX1(0.0,VOLS(NY,NX))/AREA(3,NU(NY,NX),NY,NX)
      TKW(NY,NX)=(ENGYW+THFLWW(NY,NX)+THQS(NY,NX))/VHCPW(NY,NX)
      ELSEIF(VHCPW(NY,NX).GT.ZEROS(NY,NX))THEN
      HFLXW=VHCPW(NY,NX)*((ENGYW+THFLWW(NY,NX)+THQS(NY,NX))/VHCPW(NY,NX)
     2-TKS(NU(NY,NX),NY,NX))
      HEATOU=HEATOU+HFLXW
      TKW(NY,NX)=TKS(NU(NY,NX),NY,NX)
      DPTHS(NY,NX)=0.0
      ELSE
      TKW(NY,NX)=TKS(NU(NY,NX),NY,NX)
      DPTHS(NY,NX)=0.0
      ENDIF
      TCW(NY,NX)=TKW(NY,NX)-273.15
C
C     SNOWPACK VARIABLES NEEDED FOR WATER, C, N, P, O, SOLUTE AND
C     ENERGY BALANCES INCLUDING SUM OF ALL CURRENT STATE VARIABLES,
C     CUMULATIVE SUMS OF ALL ADDITIONS AND REMOVALS SINCE START OF RUN
C
C     IF(J.EQ.24)THEN
      WS=VOLSS(NY,NX)+VOLWS(NY,NX)+VOLIS(NY,NX)*0.92
      VOLWSO=VOLWSO+WS
      UVOLW(NY,NX)=UVOLW(NY,NX)+WS
      HEATSO=HEATSO+VHCPW(NY,NX)*TKW(NY,NX)
      TLCO2G=TLCO2G+CO2W(NY,NX)+CH4W(NY,NX)
      UCO2S(NY,NX)=UCO2S(NY,NX)+CO2W(NY,NX)+CH4W(NY,NX)
      OXYGSO=OXYGSO+OXYW(NY,NX)
      TLN2G=TLN2G+ZNGW(NY,NX)+ZN2W(NY,NX)
      TLNH4=TLNH4+ZN4W(NY,NX)+ZN3W(NY,NX)
      TLNO3=TLNO3+ZNOW(NY,NX)
      TLPO4=TLPO4+ZHPW(NY,NX)
      TW=ZALW(NY,NX)+ZFEW(NY,NX)+ZHYW(NY,NX)+ZCAW(NY,NX)
     2+ZMGW(NY,NX)+ZNAW(NY,NX)+ZKAW(NY,NX)+ZOHW(NY,NX)
     3+ZSO4W(NY,NX)+ZCLW(NY,NX)+ZCO3W(NY,NX)+H0PO4W(NY,NX)
     4+2.0*(ZHCO3W(NY,NX)+ZALH1W(NY,NX)
     5+ZALSW(NY,NX)+ZFEH1W(NY,NX)+ZFESW(NY,NX)+ZCAOW(NY,NX)
     6+ZCACW(NY,NX)+ZCASW(NY,NX)+ZMGOW(NY,NX)+ZMGCW(NY,NX)
     7+ZMGSW(NY,NX)+ZNACW(NY,NX)+ZNASW(NY,NX)+ZKASW(NY,NX)
     8+H1PO4W(NY,NX)+ZCA0PW(NY,NX))
     9+3.0*(ZALH2W(NY,NX)+ZFEH2W(NY,NX)+ZCAHW(NY,NX)
     1+ZMGHW(NY,NX)+ZFE1PW(NY,NX)+ZCA1PW(NY,NX)+ZMG1PW(NY,NX))
     2+4.0*(ZALH3W(NY,NX)+ZFEH3W(NY,NX)+H3PO4W(NY,NX)+ZFE2PW(NY,NX)
     4+ZCA2PW(NY,NX))+5.0*(ZALH4W(NY,NX)+ZFEH4W(NY,NX))+H2GW(NY,NX)
      TION=TION+TW
C     ENDIF
C
C     ADD ABOVE-GROUND LITTERFALL FROM 'EXTRACT' TO SURFACE RESIDUE
C
      OSGX=ORGC(0,NY,NX)
      DO 6955 K=0,1
      DO 6955 M=1,4
      OSCX(M,K)=0.0
      OSNX(M,K)=0.0
      OSPX(M,K)=0.0
6955  CONTINUE
C
C     ADD MICROBIAL C,N,P IN ABOVE-GROUND LITTERFALL TO MICROBIAL
C     C,N,P IN SURFACE RESIDUE
C
      DO 6950 N=1,7
      DO 6950 K=0,1
      DO 6950 M=1,4
      DO 6950 MM=1,2
      OMC1=AMAX1(0.0,CSNT(M,K,0,NY,NX)*OMCI(MM,K)*OMCF(N))
      OMN1=AMAX1(0.0,ZSNT(M,K,0,NY,NX)*OMCI(MM,K)*OMCF(N))
      OMP1=AMAX1(0.0,PSNT(M,K,0,NY,NX)*OMCI(MM,K)*OMCF(N))
      OMC(MM,N,K,0,NY,NX)=OMC(MM,N,K,0,NY,NX)+OMC1
      OMN(MM,N,K,0,NY,NX)=OMN(MM,N,K,0,NY,NX)+OMN1
      OMP(MM,N,K,0,NY,NX)=OMP(MM,N,K,0,NY,NX)+OMP1
      OSCX(M,K)=OSCX(M,K)+OMC1
      OSNX(M,K)=OSNX(M,K)+OMN1
      OSPX(M,K)=OSPX(M,K)+OMP1
C     WRITE(*,8643)'LITTER',I,J,K,N,M,MM,OMP(MM,N,K,0,NY,NX),OMP1
C    2,PSNT(M,K,0,NY,NX),OMCI(MM,K),OMCF(N)
C    3,CSNT(M,K,0,NY,NX),ZSNT(M,K,0,NY,NX)
8643  FORMAT(A8,6I4,12E12.4)
6950  CONTINUE
C
C     ADD PLANT C,N,P IN ABOVE-GROUND LITTERFALL TO C,N,P
C     IN SURFACE RESIDUE
C
      OQC(1,0,NY,NX)=OQC(1,0,NY,NX)+TDFOMC(0,NY,NX)
      OQN(1,0,NY,NX)=OQN(1,0,NY,NX)+TDFOMN(0,NY,NX)
      OQP(1,0,NY,NX)=OQP(1,0,NY,NX)+TDFOMP(0,NY,NX)
      DO 6965 K=0,1
      DO 6965 M=1,4
      OSC(M,K,0,NY,NX)=OSC(M,K,0,NY,NX)+CSNT(M,K,0,NY,NX)-OSCX(M,K)
      OSN(M,K,0,NY,NX)=OSN(M,K,0,NY,NX)+ZSNT(M,K,0,NY,NX)-OSNX(M,K)
      OSP(M,K,0,NY,NX)=OSP(M,K,0,NY,NX)+PSNT(M,K,0,NY,NX)-OSPX(M,K)
C     IF((I/30)*30.EQ.I.AND.J.EQ.15)THEN
C     WRITE(*,8486)'OSC0',I,J,L,K,M,OSC(M,K,0,NY,NX)
C    2,OSN(M,K,0,NY,NX),OSP(M,K,0,NY,NX),CSNT(M,K,0,NY,NX)
C    3,ZSNT(M,K,0,NY,NX),PSNT(M,K,0,NY,NX)
8486  FORMAT(A8,5I4,12E12.4)
C     ENDIF
6965  CONTINUE
C
C     GAS AND SOLUTE EXCHANGE WITHIN SURFACE RESIDUE ADDED TO ECOSYSTEM
C     TOTALS FOR CALCULATING COMPETITION CONSTRAINTS ON MICROBIAL
C     AND ROOT POPULATIONS
C
      DO 8990 K=0,5
      IF(K.NE.3.AND.K.NE.4)THEN
      DO 8980 N=1,7
      ROXYX(0,NY,NX)=ROXYX(0,NY,NX)+ROXYS(N,K,0,NY,NX)
      RNH4X(0,NY,NX)=RNH4X(0,NY,NX)+RVMX4(N,K,0,NY,NX)
      RNO3X(0,NY,NX)=RNO3X(0,NY,NX)+RVMX3(N,K,0,NY,NX)
      RNO2X(0,NY,NX)=RNO2X(0,NY,NX)+RVMX2(N,K,0,NY,NX)
      RN2OX(0,NY,NX)=RN2OX(0,NY,NX)+RVMX1(N,K,0,NY,NX)
      RNH4X(0,NY,NX)=RNH4X(0,NY,NX)+RINHO(N,K,0,NY,NX)
      RNO3X(0,NY,NX)=RNO3X(0,NY,NX)+RINOO(N,K,0,NY,NX)
      RPO4X(0,NY,NX)=RPO4X(0,NY,NX)+RIPOO(N,K,0,NY,NX)
      RNH4X(NU(NY,NX),NY,NX)=RNH4X(NU(NY,NX),NY,NX)+RINHOR(N,K,NY,NX)
      RNO3X(NU(NY,NX),NY,NX)=RNO3X(NU(NY,NX),NY,NX)+RINOOR(N,K,NY,NX)
      RPO4X(NU(NY,NX),NY,NX)=RPO4X(NU(NY,NX),NY,NX)+RIPOOR(N,K,NY,NX)
      IF(K.LE.4)THEN
      ROQCX(K,0,NY,NX)=ROQCX(K,0,NY,NX)+ROQCS(N,K,0,NY,NX)
      ROQAX(K,0,NY,NX)=ROQAX(K,0,NY,NX)+ROQAS(N,K,0,NY,NX)
      ENDIF
8980  CONTINUE
      ENDIF
8990  CONTINUE
      RNO2X(0,NY,NX)=RNO2X(0,NY,NX)+RVMXC(0,NY,NX)
C
C     ADD RESIDUE C,N,P TO SUBSURFACE SEDIMENT BELOW A POND SURFACE
C
      IF(BKDS(NU(NY,NX),NY,NX).EQ.0.0.AND.ORGC(0,NY,NX).GT.0.0)THEN
      OSGX=ORGC(0,NY,NX)
      RC=0.0
      RN=0.0
      RP=0.0
      DO 1970 K=0,5
      IF(K.NE.3.AND.K.NE.4)THEN
C
C     MICROBIAL C,N,P
C
      DO 1960 N=1,7
      DO 1960 M=1,3
      OMC(M,N,K,NW(NY,NX),NY,NX)=OMC(M,N,K,NW(NY,NX),NY,NX)
     2+OMC(M,N,K,0,NY,NX)
      OMN(M,N,K,NW(NY,NX),NY,NX)=OMN(M,N,K,NW(NY,NX),NY,NX)
     2+OMN(M,N,K,0,NY,NX)
      OMP(M,N,K,NW(NY,NX),NY,NX)=OMP(M,N,K,NW(NY,NX),NY,NX)
     2+OMP(M,N,K,0,NY,NX)
      RC=RC+OMC(M,N,K,0,NY,NX)
      RN=RN+OMN(M,N,K,0,NY,NX)
      RP=RP+OMP(M,N,K,0,NY,NX)
      OMC(M,N,K,0,NY,NX)=0.0
      OMN(M,N,K,0,NY,NX)=0.0
      OMP(M,N,K,0,NY,NX)=0.0
1960  CONTINUE
      ENDIF
1970  CONTINUE
C
C     MICROBIAL RESIDUE C,N,P
C
      DO 1900 K=0,2
      DO 1940 M=1,2
      ORC(M,K,NW(NY,NX),NY,NX)=ORC(M,K,NW(NY,NX),NY,NX)+ORC(M,K,0,NY,NX)
      ORN(M,K,NW(NY,NX),NY,NX)=ORN(M,K,NW(NY,NX),NY,NX)+ORN(M,K,0,NY,NX)
      ORP(M,K,NW(NY,NX),NY,NX)=ORP(M,K,NW(NY,NX),NY,NX)+ORP(M,K,0,NY,NX)
      RC=RC+ORC(M,K,0,NY,NX)
      RN=RN+ORN(M,K,0,NY,NX)
      RP=RP+ORP(M,K,0,NY,NX)
      ORC(M,K,0,NY,NX)=0.0
      ORN(M,K,0,NY,NX)=0.0
      ORP(M,K,0,NY,NX)=0.0
1940  CONTINUE
C
C     DOC, DON, DOP
C
      OQC(K,NW(NY,NX),NY,NX)=OQC(K,NW(NY,NX),NY,NX)+OQC(K,0,NY,NX)
      OQN(K,NW(NY,NX),NY,NX)=OQN(K,NW(NY,NX),NY,NX)+OQN(K,0,NY,NX)
      OQP(K,NW(NY,NX),NY,NX)=OQP(K,NW(NY,NX),NY,NX)+OQP(K,0,NY,NX)
      OQA(K,NW(NY,NX),NY,NX)=OQA(K,NW(NY,NX),NY,NX)+OQA(K,0,NY,NX)
      RC=RC+OQC(K,0,NY,NX)+OQA(K,0,NY,NX)
      RN=RN+OQN(K,0,NY,NX)
      RP=RP+OQP(K,0,NY,NX)
      OQC(K,0,NY,NX)=0.0
      OQN(K,0,NY,NX)=0.0
      OQP(K,0,NY,NX)=0.0
      OQA(K,0,NY,NX)=0.0
      OQCH(K,NW(NY,NX),NY,NX)=OQCH(K,NW(NY,NX),NY,NX)+OQCH(K,0,NY,NX)
      OQNH(K,NW(NY,NX),NY,NX)=OQNH(K,NW(NY,NX),NY,NX)+OQNH(K,0,NY,NX)
      OQPH(K,NW(NY,NX),NY,NX)=OQPH(K,NW(NY,NX),NY,NX)+OQPH(K,0,NY,NX)
      OQAH(K,NW(NY,NX),NY,NX)=OQAH(K,NW(NY,NX),NY,NX)+OQAH(K,0,NY,NX)
      RC=RC+OQCH(K,0,NY,NX)+OQAH(K,0,NY,NX)
      RN=RN+OQNH(K,0,NY,NX)
      RP=RP+OQPH(K,0,NY,NX)
      OQCH(K,0,NY,NX)=0.0
      OQNH(K,0,NY,NX)=0.0
      OQPH(K,0,NY,NX)=0.0
      OQAH(K,0,NY,NX)=0.0
C
C     ADSORBED C,N,P
C
      OHC(K,NW(NY,NX),NY,NX)=OHC(K,NW(NY,NX),NY,NX)+OHC(K,0,NY,NX)
      OHN(K,NW(NY,NX),NY,NX)=OHN(K,NW(NY,NX),NY,NX)+OHN(K,0,NY,NX)
      OHP(K,NW(NY,NX),NY,NX)=OHP(K,NW(NY,NX),NY,NX)+OHP(K,0,NY,NX)
      OHA(K,NW(NY,NX),NY,NX)=OHA(K,NW(NY,NX),NY,NX)+OHA(K,0,NY,NX)
      RC=RC+OHC(K,0,NY,NX)+OHA(K,0,NY,NX)
      RN=RN+OHN(K,0,NY,NX)
      RP=RP+OHP(K,0,NY,NX)
      OHC(K,0,NY,NX)=0.0
      OHN(K,0,NY,NX)=0.0
      OHP(K,0,NY,NX)=0.0
      OHA(K,0,NY,NX)=0.0
C
C     PLANT RESIDUE C,N,P
C
      DO 1930 M=1,4
      OSC(M,K,NW(NY,NX),NY,NX)=OSC(M,K,NW(NY,NX),NY,NX)+OSC(M,K,0,NY,NX)
      OSA(M,K,NW(NY,NX),NY,NX)=OSA(M,K,NW(NY,NX),NY,NX)+OSA(M,K,0,NY,NX)
      OSN(M,K,NW(NY,NX),NY,NX)=OSN(M,K,NW(NY,NX),NY,NX)+OSN(M,K,0,NY,NX)
      OSP(M,K,NW(NY,NX),NY,NX)=OSP(M,K,NW(NY,NX),NY,NX)+OSP(M,K,0,NY,NX)
      RC=RC+OSC(M,K,0,NY,NX)
      RN=RN+OSN(M,K,0,NY,NX)
      RP=RP+OSP(M,K,0,NY,NX)
      OSC(M,K,0,NY,NX)=0.0
      OSA(M,K,0,NY,NX)=0.0
      OSN(M,K,0,NY,NX)=0.0
      OSP(M,K,0,NY,NX)=0.0
1930  CONTINUE
1900  CONTINUE
      TLRSDC=TLRSDC-RC
      TLRSDN=TLRSDN-RN
      TLRSDP=TLRSDP-RP
      URSDC(NY,NX)=URSDC(NY,NX)-RC
      URSDN(NY,NX)=URSDN(NY,NX)-RN
      URSDP(NY,NX)=URSDP(NY,NX)-RP
      ORGC(0,NY,NX)=0.0
      ORGN(0,NY,NX)=0.0
      ORGR(0,NY,NX)=0.0
      VOLR(NY,NX)=0.0
C
C     ADD RESIDUE SOLUTES TO SUBSURFACE SEDIMENT BELOW A POND SURFACE
C
C     CO2S(NW(NY,NX),NY,NX)=CO2S(NW(NY,NX),NY,NX)+CO2S(0,NY,NX) 
C     CH4S(NW(NY,NX),NY,NX)=CH4S(NW(NY,NX),NY,NX)+CH4S(0,NY,NX) 
C     OXYS(NW(NY,NX),NY,NX)=OXYS(NW(NY,NX),NY,NX)+OXYS(0,NY,NX) 
C     Z2GS(NW(NY,NX),NY,NX)=Z2GS(NW(NY,NX),NY,NX)+Z2GS(0,NY,NX) 
C     Z2OS(NW(NY,NX),NY,NX)=Z2OS(NW(NY,NX),NY,NX)+Z2OS(0,NY,NX) 
C     H2GS(NW(NY,NX),NY,NX)=H2GS(NW(NY,NX),NY,NX)+H2GS(0,NY,NX) 
C     ZNH4S(NW(NY,NX),NY,NX)=ZNH4S(NW(NY,NX),NY,NX)+ZNH4S(0,NY,NX)
C     ZNH3S(NW(NY,NX),NY,NX)=ZNH3S(NW(NY,NX),NY,NX)+ZNH3S(0,NY,NX)
C     ZNO3S(NW(NY,NX),NY,NX)=ZNO3S(NW(NY,NX),NY,NX)+ZNO3S(0,NY,NX)
C     H2PO4(NW(NY,NX),NY,NX)=H2PO4(NW(NY,NX),NY,NX)+H2PO4(0,NY,NX)
C     ZNO2S(NW(NY,NX),NY,NX)=ZNO2S(NW(NY,NX),NY,NX)+ZNO2S(0,NY,NX)
C     CS=CO2S(0,NY,NX)+CH4S(0,NY,NX)
C     TLCO2G=TLCO2G-CS
C     UCO2S(NY,NX)=UCO2S(NY,NX)-CS
C     OS=OXYS(0,NY,NX)
C     OXYGSO=OXYGSO-OS
C     ZG=Z2GS(0,NY,NX)+Z2OS(0,NY,NX)
C     TLN2G=TLN2G-ZG
C     ZNH=ZNH4S(0,NY,NX)+ZNH3S(0,NY,NX)
C     TLNH4=TLNH4-ZNH
C     UNH4(NY,NX)=UNH4(NY,NX)-ZNH
C     ZNO=ZNO3S(0,NY,NX)+ZNO2S(0,NY,NX)
C     TLNO3=TLNO3-ZNO
C     UNO3(NY,NX)=UNO3(NY,NX)-ZNO
C     P4=H2PO4(0,NY,NX)
C     TLPO4=TLPO4-P4
C     UPO4(NY,NX)=UPO4(NY,NX)-P4
C     CO2S(0,NY,NX)=0.0
C     CH4S(0,NY,NX)=0.0
C     OXYS(0,NY,NX)=0.0
C     Z2GS(0,NY,NX)=0.0
C     Z2OS(0,NY,NX)=0.0
C     H2GS(0,NY,NX)=0.0
C     ZNH4S(0,NY,NX)=0.0
C     ZNH3S(0,NY,NX)=0.0
C     ZNO3S(0,NY,NX)=0.0
C     H2PO4(0,NY,NX)=0.0
C     ZNO2S(0,NY,NX)=0.0
      ENDIF
C
C     RUNOFF AND SUBSURFACE BOUNDARY FLUXES
C
      DO 9985 L=NU(NY,NX),NL(NY,NX)
C
C     LOCATE EXTERNAL BOUNDARIES
C
      DO 9980 N=1,3
      DO 9975 NN=1,2
      IF(N.EQ.1)THEN
      IF(NN.EQ.1)THEN
      IF(NX.EQ.NHE)THEN
      N4=NX+1
      N5=NY
      N6=L
      XN=-1.0
      ELSE
      GO TO 9975
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      IF(NX.EQ.NHW)THEN
      N4=NX
      N5=NY
      N6=L
      XN=1.0
      ELSE
      GO TO 9975
      ENDIF
      ENDIF
      ELSEIF(N.EQ.2)THEN
      IF(NN.EQ.1)THEN
      IF(NY.EQ.NVS)THEN
      N4=NX
      N5=NY+1
      N6=L
      XN=-1.0
      ELSE
      GO TO 9975
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      IF(NY.EQ.NVN)THEN
      N4=NX
      N5=NY
      N6=L
      XN=1.0
      ELSE
      GO TO 9975
      ENDIF
      ENDIF
      ELSEIF(N.EQ.3)THEN
      IF(NN.EQ.1)THEN
      IF(L.EQ.NL(NY,NX))THEN
      N4=NX
      N5=NY
      N6=L+1
      XN=-1.0
      ELSE
      GO TO 9975
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      GO TO 9975
      ENDIF
      ENDIF
C
C     RUNOFF BOUNDARY FLUXES OF WATER AND HEAT
C
      IF(L.EQ.NU(NY,NX).AND.N.NE.3)THEN
      WQ=XN*(QR(N,N5,N4)+QS(N,N5,N4)+QW(N,N5,N4)+QI(N,N5,N4))
      IF(WQ.NE.0.0)THEN
      CRUN=CRUN-WQ
      URUN(NY,NX)=URUN(NY,NX)-WQ
      HEATOU=HEATOU-XN*(HQR(N,N5,N4)+HQS(N,N5,N4))
C
C     RUNOFF BOUNDARY FLUXES OF c, n AND p
C
      CX=XN*(XCOQRS(N,N5,N4)+XCHQRS(N,N5,N4)
     2+XCOQSS(N,N5,N4)+XCHQSS(N,N5,N4))
      CQ=0.0
      DO 2575 K=0,4
      CQ=CQ+XN*(XOCQRS(K,N,N5,N4)+XOAQRS(K,N,N5,N4))
2575  CONTINUE
      TCOU=TCOU-CQ-CX
      TNBP(NY,NX)=TNBP(NY,NX)+CQ+CX
      UDOCQ(NY,NX)=UDOCQ(NY,NX)-CQ
      UDICQ(NY,NX)=UDICQ(NY,NX)-CX
      OX=XN*(XOXQRS(N,N5,N4)+XOXQSS(N,N5,N4))
      OXYGOU=OXYGOU-OX 
      ZX=XN*(XN4QRW(N,N5,N4)+XN3QRW(N,N5,N4) 
     2+XNOQRW(N,N5,N4)+XNXQRS(N,N5,N4)+XN4QSS(N,N5,N4)
     3+XN3QSS(N,N5,N4)+XNOQSS(N,N5,N4))
      ZG=XN*(XN2QRS(N,N5,N4)+XNGQRS(N,N5,N4)
     2+XN2QSS(N,N5,N4)+XNGQSS(N,N5,N4))
      ZQ=0.0
      DO 2875 K=0,4
      ZQ=ZQ+XN*XONQRS(K,N,N5,N4)
2875  CONTINUE
      TZOU=TZOU-ZQ-ZX-ZG
      UDONQ(NY,NX)=UDONQ(NY,NX)-ZQ
      UDINQ(NY,NX)=UDINQ(NY,NX)-ZX
      PX=XN*(XP4QRW(N,N5,N4)+XP4QSS(N,N5,N4))
      PQ=0.0
      DO 2775 K=0,4
      PQ=PQ+XN*XOPQRS(K,N,N5,N4)
2775  CONTINUE
      TPOU=TPOU-PQ-PX
      UDOPQ(NY,NX)=UDOPQ(NY,NX)-PQ
      UDIPQ(NY,NX)=UDIPQ(NY,NX)-PX
C
C     RUNOFF BOUNDARY FLUXES OF SOLUTES
C
      SQ1=XN*(XQRAL(N,N5,N4)+XQRFE(N,N5,N4)+XQRHY(N,N5,N4)
     2+XQRCA(N,N5,N4)+XQRMG(N,N5,N4)+XQRNA(N,N5,N4)+XQRKA(N,N5,N4)
     3+XQROH(N,N5,N4)+XQRSO(N,N5,N4)+XQRCL(N,N5,N4)+XQRC3(N,N5,N4)
     4+XQRH0P(N,N5,N4)+XHGQRS(N,N5,N4)+XQSAL(N,N5,N4)+XQSFE(N,N5,N4)
     5+XQSHY(N,N5,N4)+XQSCA(N,N5,N4)+XQSMG(N,N5,N4)+XQSNA(N,N5,N4)
     6+XQSKA(N,N5,N4)+XQSOH(N,N5,N4)+XQSSO(N,N5,N4)+XQSCL(N,N5,N4)
     3+XQSC3(N,N5,N4)+XQSH0P(N,N5,N4)) 
      SQ2=XN*2.0*(XQRHC(N,N5,N4)+XQRAL1(N,N5,N4)+XQRALS(N,N5,N4)
     2+XQRFE1(N,N5,N4)+XQRFES(N,N5,N4)+XQRCAO(N,N5,N4)+XQRCAC(N,N5,N4)
     3+XQRCAS(N,N5,N4)+XQRMGO(N,N5,N4)+XQRMGC(N,N5,N4)+XQRMGS(N,N5,N4)
     4+XQRNAC(N,N5,N4)+XQRNAS(N,N5,N4)+XQRKAS(N,N5,N4)+XQRH1P(N,N5,N4)
     5+XQRC0P(N,N5,N4)+XQSHC(N,N5,N4)+XQSAL1(N,N5,N4)+XQSALS(N,N5,N4)
     2+XQSFE1(N,N5,N4)+XQSFES(N,N5,N4)+XQSCAO(N,N5,N4)+XQSCAC(N,N5,N4)
     3+XQSCAS(N,N5,N4)+XQSMGO(N,N5,N4)+XQSMGC(N,N5,N4)+XQSMGS(N,N5,N4)
     4+XQSNAC(N,N5,N4)+XQSNAS(N,N5,N4)+XQSKAS(N,N5,N4)+XQSH1P(N,N5,N4)
     5+XQSC0P(N,N5,N4)) 
      SQ3=XN*3.0*(XQRAL2(N,N5,N4)+XQRFE2(N,N5,N4)+XQRCAH(N,N5,N4)
     2+XQRMGH(N,N5,N4)+XQRF1P(N,N5,N4)+XQRC1P(N,N5,N4)+XQRM1P(N,N5,N4)
     3+XQSAL2(N,N5,N4)+XQSFE2(N,N5,N4)+XQSCAH(N,N5,N4)+XQSMGH(N,N5,N4)
     2+XQSF1P(N,N5,N4)+XQSC1P(N,N5,N4)+XQSM1P(N,N5,N4)) 
      SQ4=XN*4.0*(XQRAL3(N,N5,N4)+XQRFE3(N,N5,N4)+XQRH3P(N,N5,N4)
     2+XQRF2P(N,N5,N4)+XQRC2P(N,N5,N4)+XQSAL3(N,N5,N4)+XQSFE3(N,N5,N4)
     3+XQSH3P(N,N5,N4)+XQSF2P(N,N5,N4)+XQSC2P(N,N5,N4))
     5+XN*5.0*(XQRAL4(N,N5,N4)+XQRFE4(N,N5,N4)
     6+XQSAL4(N,N5,N4)+XQSFE4(N,N5,N4))
      SQ=SQ1+SQ2+SQ3+SQ4
      TIONOU=TIONOU-SQ
      UIONOU(NY,NX)=UIONOU(NY,NX)-SQ
C
C     RUNOFF BOUNDARY FLUXES OF SEDIMENT
C
      IF(IERSN(N5,N4).NE.0)THEN
      ER=XN*(XSANER(N,N5,N4)+XSILER(N,N5,N4)+XCLAER(N,N5,N4))
      TSEDOU=TSEDOU-ER
      USEDOU(NY,NX)=USEDOU(NY,NX)-ER
C
C     MICROBIAL C IN RUNOFF SEDIMENT
C
      CQ=0.0
      DO 3580 K=0,5
      DO 3580 NO=1,7
      DO 3580 M=1,3
      CQ=CQ+XN*OMCER(M,NO,K,N,N5,N4)
3580  CONTINUE
C
C     MICROBIAL RESIDUE C IN RUNOFF SEDIMENT
C
      DO 3575 K=0,4
      DO 3570 M=1,2
      CQ=CQ+XN*ORCER(M,K,N,N5,N4)
3570  CONTINUE
C
C     DOC, ADSORBED AND HUMUS C IN RUNOFF SEDIMENT
C
      CQ=CQ+XN*OHCER(K,N,N5,N4)
      DO 3565 M=1,4
      CQ=CQ+XN*OSCER(M,K,N,N5,N4)
3565  CONTINUE
3575  CONTINUE
      TCOU=TCOU-CQ-CX
      UDOCQ(NY,NX)=UDOCQ(NY,NX)-CQ
      UDICQ(NY,NX)=UDICQ(NY,NX)-CX
      TSEDOU=TSEDOU-CQ*1.0E-06
      USEDOU(NY,NX)=USEDOU(NY,NX)-CQ*1.0E-06
      TNBP(NY,NX)=TNBP(NY,NX)+CQ+CX
C
C     MICROBIAL N IN RUNOFF SEDIMENT
C
      ZQ=0.0
      DO 6880 K=0,5
      DO 6880 NO=1,7
      DO 6880 M=1,2
      ZQ=ZQ+XN*OMNER(M,NO,K,N,N5,N4)
6880  CONTINUE
C
C     MICROBIAL RESIDUE N IN RUNOFF SEDIMENT
C
      DO 6875 K=0,4
      DO 6870 M=1,2
      ZQ=ZQ+XN*ORNER(M,K,N,N5,N4)
6870  CONTINUE
C
C     DON, ADSORBED AND HUMUS N IN RUNOFF SEDIMENT
C
      ZQ=ZQ+XN*OHNER(K,N,N5,N4)
      DO 6865 M=1,4
      ZQ=ZQ+XN*OSNER(M,K,N,N5,N4)
6865  CONTINUE
6875  CONTINUE
      TZOU=TZOU-ZQ-ZX-ZG
      UDONQ(NY,NX)=UDONQ(NY,NX)-ZQ
      UDINQ(NY,NX)=UDINQ(NY,NX)-ZX
C
C     MICROBIAL P IN RUNOFF SEDIMENT
C
      PQ=0.0
      DO 6780 K=0,5
      DO 6780 NO=1,7
      DO 6780 M=1,2
      PQ=PQ+XN*OMPER(M,NO,K,N,N5,N4)
6780  CONTINUE
C
C     MICROBIAL RESIDUE P IN RUNOFF SEDIMENT
C
      DO 6775 K=0,4
      DO 6770 M=1,2
      PQ=PQ+XN*ORPER(M,K,N,N5,N4)
6770  CONTINUE
C
C     DOP, ADSORBED AND HUMUS P IN RUNOFF SEDIMENT
C
      PQ=PQ+XN*OHPER(K,N,N5,N4)
      DO 6765 M=1,4
      PQ=PQ+XN*OSPER(M,K,N,N5,N4)
6765  CONTINUE
6775  CONTINUE
      TPOU=TPOU-PQ-PX
      UDOPQ(NY,NX)=UDOPQ(NY,NX)-PQ
      UDIPQ(NY,NX)=UDIPQ(NY,NX)-PX
C
C     RUNOFF BOUNDARY FLUXES OF SEDIMENTS
C
      SQ1=XN*(XOH0ER(N,N5,N4)
     5+XOH0EB(N,N5,N4)+XHYER(N,N5,N4)+XALER(N,N5,N4)+XCAER(N,N5,N4)
     6+XMGER(N,N5,N4)+XNAER(N,N5,N4)+XKAER(N,N5,N4)+XHCER(N,N5,N4)
     7+XNH3ER(N,N5,N4)+XNHUER(N,N5,N4)+XNO3ER(N,N5,N4)+XNH3EB(N,N5,N4)
     8+XNHUEB(N,N5,N4)+XNO3EB(N,N5,N4))
      SQ2=XN*2.0*(XN4ER(N,N5,N4)
     6+XNBER(N,N5,N4)+XOH1ER(N,N5,N4)+XOH1EB(N,N5,N4)+PCACER(N,N5,N4)
     7+PCASER(N,N5,N4)+PALPER(N,N5,N4)+PFEPER(N,N5,N4)+PALPEB(N,N5,N4)
     8+PFEPEB(N,N5,N4)+XNH4ER(N,N5,N4)+XNH4EB(N,N5,N4))
      SQ3=XN*3.0*(XAL2ER(N,N5,N4)
     4+XOH2ER(N,N5,N4)+XH1PER(N,N5,N4)+XOH2EB(N,N5,N4)+XH1PEB(N,N5,N4)
     5+PCPDER(N,N5,N4)+PCPDEB(N,N5,N4))
      SQ4=XN*4.0*(XH2PER(N,N5,N4)+XH2PEB(N,N5,N4)+PALOER(N,N5,N4)
     4+PFEOER(N,N5,N4))
     6+XN*7.0*(PCPMER(N,N5,N4)+PCPMEB(N,N5,N4))
     7+XN*9.0*(PCPHER(N,N5,N4)+PCPHEB(N,N5,N4))
      SQ=SQ1+SQ2+SQ3+SQ4
      TIONOU=TIONOU-SQ
      UIONOU(NY,NX)=UIONOU(NY,NX)-SQ
      ENDIF
      ENDIF
      ENDIF
C
C     SUBSURFACE BOUNDARY FLUXES OF WATER AND HEAT
C
      IF(NCN(NY,NX).EQ.1.OR.N.EQ.3)THEN
      WO=XN*(FLW(N,N6,N5,N4)+FLWH(N,N6,N5,N4))
      VOLWOU=VOLWOU-WO
      HVOLO(NY,NX)=HVOLO(NY,NX)-WO
      UVOLO(NY,NX)=UVOLO(NY,NX)-WO
      HEATOU=HEATOU-XN*HFLW(N,N6,N5,N4)
C
C     SUBSURFACE BOUNDARY FLUXES OF CO2 AND DOC
C
      CO=0.0
      DO 450 K=0,4
      CO=CO+XN*(XOCFLS(K,N,N6,N5,N4)+XOAFLS(K,N,N6,N5,N4)
     4+XOCFHS(K,N,N6,N5,N4)+XOAFHS(K,N,N6,N5,N4))
450   CONTINUE
      CX=XN*(XCOFLS(N,N6,N5,N4)+XCOFHS(N,N6,N5,N4)
     2+XCOFLG(N,N6,N5,N4)+XCHFLS(N,N6,N5,N4)
     3+XCHFHS(N,N6,N5,N4)+XCHFLG(N,N6,N5,N4))
      TCOU=TCOU-CO-CX
      UDOCD(NY,NX)=UDOCD(NY,NX)-CO
      UDICD(NY,NX)=UDICD(NY,NX)-CX
      TNBP(NY,NX)=TNBP(NY,NX)+CO+CX
C
C     SUBSURFACE BOUNDARY FLUXES OF O2
C
      OO=XN*(XOXFLS(N,N6,N5,N4)+XOXFHS(N,N6,N5,N4)+XOXFLG(N,N6,N5,N4))
      OXYGOU=OXYGOU-OO
C
C     SUBSURFACE BOUNDARY FLUXES OF N2O, N2, NH4, NH3, NO3, NO2 AND DON
C
      ZO=0.0
      DO 455 K=0,4
      ZO=ZO+XN*(XONFLS(K,N,N6,N5,N4)+XONFHS(K,N,N6,N5,N4))
455   CONTINUE
      ZX=XN*(XN2FLS(N,N6,N5,N4)+XN4FLW(N,N6,N5,N4) 
     2+XN3FLW(N,N6,N5,N4)+XNOFLW(N,N6,N5,N4)+XN4FLB(N,N6,N5,N4)
     3+XN3FLB(N,N6,N5,N4)+XNOFLB(N,N6,N5,N4)+XNXFLS(N,N6,N5,N4)
     4+XNXFLB(N,N6,N5,N4)+XN2FHS(N,N6,N5,N4) 
     5+XN4FHW(N,N6,N5,N4)+XN3FHW(N,N6,N5,N4)+XNOFHW(N,N6,N5,N4) 
     6+XN4FHB(N,N6,N5,N4)+XN3FHB(N,N6,N5,N4)+XNOFHB(N,N6,N5,N4)
     7+XNXFHS(N,N6,N5,N4)+XNXFHB(N,N6,N5,N4)+XN2FLG(N,N6,N5,N4)
     8+XN3FLG(N,N6,N5,N4))
      ZG=XN*(XNGFLS(N,N6,N5,N4)+XNGFLG(N,N6,N5,N4)+XNGFHS(N,N6,N5,N4))
      TZOU=TZOU-ZO-ZX-ZG
      UDOND(NY,NX)=UDOND(NY,NX)-ZO
      UDIND(NY,NX)=UDIND(NY,NX)-ZX
C
C     SUBSURFACE BOUNDARY FLUXES OF PO4 AND DOP
C
      PO=0.0
      DO 460 K=0,4
      PO=PO+XN*(XOPFLS(K,N,N6,N5,N4)+XOPFHS(K,N,N6,N5,N4))
460   CONTINUE
      PX=XN*(XH2PFS(N,N6,N5,N4)+XH2BFB(N,N6,N5,N4)
     2+XH2PHS(N,N6,N5,N4)+XH2BHB(N,N6,N5,N4))
      TPOU=TPOU-PO-PX
      UDOPD(NY,NX)=UDOPD(NY,NX)-PO
      UDIPD(NY,NX)=UDIPD(NY,NX)-PX
C
C     SUBSURFACE BOUNDARY FLUXES OF SOLUTES
C
      SS=XN*(XALFLS(N,N6,N5,N4)+XFEFLS(N,N6,N5,N4)+XHYFLS(N,N6,N5,N4)
     2+XCAFLS(N,N6,N5,N4)+XMGFLS(N,N6,N5,N4)+XNAFLS(N,N6,N5,N4)
     3+XKAFLS(N,N6,N5,N4)+XOHFLS(N,N6,N5,N4)+XSOFLS(N,N6,N5,N4)
     4+XCLFLS(N,N6,N5,N4)+XC3FLS(N,N6,N5,N4)+XH0PFS(N,N6,N5,N4)
     5+XH0BFB(N,N6,N5,N4)+2.0*(XHCFLS(N,N6,N5,N4)+XAL1FS(N,N6,N5,N4)
     6+XALSFS(N,N6,N5,N4)+XFE1FS(N,N6,N5,N4)+XFESFS(N,N6,N5,N4)
     7+XCAOFS(N,N6,N5,N4)+XCACFS(N,N6,N5,N4)
     8+XCASFS(N,N6,N5,N4)+XMGOFS(N,N6,N5,N4)+XMGCFS(N,N6,N5,N4)
     9+XMGSFS(N,N6,N5,N4)+XNACFS(N,N6,N5,N4)+XNASFS(N,N6,N5,N4)
     1+XKASFS(N,N6,N5,N4)+XH1PFS(N,N6,N5,N4)+XH1BFB(N,N6,N5,N4)
     2+XC0PFS(N,N6,N5,N4)+XC0BFB(N,N6,N5,N4))+3.0*(XAL2FS(N,N6,N5,N4)
     3+XFE2FS(N,N6,N5,N4)+XCAHFS(N,N6,N5,N4)+XMGHFS(N,N6,N5,N4)
     4+XF1PFS(N,N6,N5,N4)+XC1PFS(N,N6,N5,N4)+XM1PFS(N,N6,N5,N4)
     5+XF1BFB(N,N6,N5,N4)+XC1BFB(N,N6,N5,N4)+XM1BFB(N,N6,N5,N4))
     6+4.0*(XAL3FS(N,N6,N5,N4)+XFE3FS(N,N6,N5,N4)+XH3PFS(N,N6,N5,N4)
     7+XF2PFS(N,N6,N5,N4)+XC2PFS(N,N6,N5,N4)+XH3BFB(N,N6,N5,N4)
     8+XF2BFB(N,N6,N5,N4)+XC2BFB(N,N6,N5,N4))
     9+5.0*(XAL4FS(N,N6,N5,N4)+XFE4FS(N,N6,N5,N4))+XHGFLS(N,N6,N5,N4)
     1+XHGFLG(N,N6,N5,N4))
      SG=SG+XHGFLS(N,N6,N5,N4)+XHGFLG(N,N6,N5,N4)
      SH=XN*(XALFHS(N,N6,N5,N4)+XFEFHS(N,N6,N5,N4)+XHYFHS(N,N6,N5,N4)
     2+XCAFHS(N,N6,N5,N4)+XMGFHS(N,N6,N5,N4)+XNAFHS(N,N6,N5,N4)
     3+XKAFHS(N,N6,N5,N4)+XOHFHS(N,N6,N5,N4)+XSOFHS(N,N6,N5,N4)
     4+XCLFHS(N,N6,N5,N4)+XC3FHS(N,N6,N5,N4)+XH0PHS(N,N6,N5,N4)
     5+XH0BHB(N,N6,N5,N4)+2.0*(XHCFHS(N,N6,N5,N4)+XAL1HS(N,N6,N5,N4)
     6+XALSHS(N,N6,N5,N4)+XFE1HS(N,N6,N5,N4)+XFESHS(N,N6,N5,N4)
     7+XCAOHS(N,N6,N5,N4)+XCACHS(N,N6,N5,N4)
     8+XCASHS(N,N6,N5,N4)+XMGOHS(N,N6,N5,N4)+XMGCHS(N,N6,N5,N4)
     9+XMGSHS(N,N6,N5,N4)+XNACHS(N,N6,N5,N4)+XNASHS(N,N6,N5,N4)
     1+XKASHS(N,N6,N5,N4)+XH1PHS(N,N6,N5,N4)+XH1BHB(N,N6,N5,N4)
     2+XC0PHS(N,N6,N5,N4)+XC0BHB(N,N6,N5,N4))+3.0*(XAL2HS(N,N6,N5,N4)
     3+XFE2HS(N,N6,N5,N4)+XCAHHS(N,N6,N5,N4)+XMGHHS(N,N6,N5,N4)
     4+XF1PHS(N,N6,N5,N4)+XC1PHS(N,N6,N5,N4)+XM1PHS(N,N6,N5,N4)
     5+XF1BHB(N,N6,N5,N4)+XC1BHB(N,N6,N5,N4)+XM1BHB(N,N6,N5,N4))
     6+4.0*(XAL3HS(N,N6,N5,N4)+XFE3HS(N,N6,N5,N4)+XH3PHS(N,N6,N5,N4)
     7+XF2PHS(N,N6,N5,N4)+XC2PHS(N,N6,N5,N4)+XH3BHB(N,N6,N5,N4)
     8+XF2BHB(N,N6,N5,N4)+XC2BHB(N,N6,N5,N4))
     9+5.0*(XAL4HS(N,N6,N5,N4)+XAL4HS(N,N6,N5,N4))+XHGFHS(N,N6,N5,N4))
      SO=SS+SH
      TIONOU=TIONOU-SO
      UIONOU(NY,NX)=UIONOU(NY,NX)-SO
      ENDIF
9975  CONTINUE
9980  CONTINUE
9985  CONTINUE
C
C     TOTAL FLUXES FOR EACH GRID CELL FROM ALL INTERNAL AND BOUNDARY FLUXES
C     CALCULATED IN 'WATSUB', NITRO', 'SOLUTE', 'EXTRACT', 'TRNSFR',
C     'TRNSFRS' AND 'REDIST' ABOVE
C
      TQR(NY,NX)=0.0
      THQR(NY,NX)=0.0
      TQS(NY,NX)=0.0
      TQW(NY,NX)=0.0
      TQI(NY,NX)=0.0
      THQS(NY,NX)=0.0
      DO 9960 K=0,2
      TOCQRS(K,NY,NX)=0.0
      TONQRS(K,NY,NX)=0.0
      TOPQRS(K,NY,NX)=0.0
      TOAQRS(K,NY,NX)=0.0
9960  CONTINUE
      TCOQRS(NY,NX)=0.0
      TCHQRS(NY,NX)=0.0
      TOXQRS(NY,NX)=0.0
      TNGQRS(NY,NX)=0.0
      TN2QRS(NY,NX)=0.0
      THGQRS(NY,NX)=0.0
      TN4QRS(NY,NX)=0.0
      TN3QRS(NY,NX)=0.0
      TNOQRS(NY,NX)=0.0
      TNXQRS(NY,NX)=0.0
      TPOQRS(NY,NX)=0.0
      TCOQSS(NY,NX)=0.0
      TCHQSS(NY,NX)=0.0
      TOXQSS(NY,NX)=0.0
      TNGQSS(NY,NX)=0.0
      TN2QSS(NY,NX)=0.0
      TN4QSS(NY,NX)=0.0
      TN3QSS(NY,NX)=0.0
      TNOQSS(NY,NX)=0.0
      TPOQSS(NY,NX)=0.0
      IF(ISALT(NY,NX).NE.0)THEN
      TQRAL(NY,NX)=0.0
      TQRFE(NY,NX)=0.0
      TQRHY(NY,NX)=0.0
      TQRCA(NY,NX)=0.0
      TQRMG(NY,NX)=0.0
      TQRNA(NY,NX)=0.0
      TQRKA(NY,NX)=0.0
      TQROH(NY,NX)=0.0
      TQRSO(NY,NX)=0.0
      TQRCL(NY,NX)=0.0
      TQRC3(NY,NX)=0.0
      TQRHC(NY,NX)=0.0
      TQRAL1(NY,NX)=0.0
      TQRAL2(NY,NX)=0.0
      TQRAL3(NY,NX)=0.0
      TQRAL4(NY,NX)=0.0
      TQRALS(NY,NX)=0.0
      TQRFE1(NY,NX)=0.0
      TQRFE2(NY,NX)=0.0
      TQRFE3(NY,NX)=0.0
      TQRFE4(NY,NX)=0.0
      TQRFES(NY,NX)=0.0
      TQRCAO(NY,NX)=0.0
      TQRCAC(NY,NX)=0.0
      TQRCAH(NY,NX)=0.0
      TQRCAS(NY,NX)=0.0
      TQRMGO(NY,NX)=0.0
      TQRMGC(NY,NX)=0.0
      TQRMGH(NY,NX)=0.0
      TQRMGS(NY,NX)=0.0
      TQRNAC(NY,NX)=0.0
      TQRNAS(NY,NX)=0.0
      TQRKAS(NY,NX)=0.0
      TQRH0P(NY,NX)=0.0
      TQRH1P(NY,NX)=0.0
      TQRH3P(NY,NX)=0.0
      TQRF1P(NY,NX)=0.0
      TQRF2P(NY,NX)=0.0
      TQRC0P(NY,NX)=0.0
      TQRC1P(NY,NX)=0.0
      TQRC2P(NY,NX)=0.0
      TQRM1P(NY,NX)=0.0
      TQSAL(NY,NX)=0.0
      TQSFE(NY,NX)=0.0
      TQSHY(NY,NX)=0.0
      TQSCA(NY,NX)=0.0
      TQSMG(NY,NX)=0.0
      TQSNA(NY,NX)=0.0
      TQSKA(NY,NX)=0.0
      TQSOH(NY,NX)=0.0
      TQSSO(NY,NX)=0.0
      TQSCL(NY,NX)=0.0
      TQSC3(NY,NX)=0.0
      TQSHC(NY,NX)=0.0
      TQSAL1(NY,NX)=0.0
      TQSAL2(NY,NX)=0.0
      TQSAL3(NY,NX)=0.0
      TQSAL4(NY,NX)=0.0
      TQSALS(NY,NX)=0.0
      TQSFE1(NY,NX)=0.0
      TQSFE2(NY,NX)=0.0
      TQSFE3(NY,NX)=0.0
      TQSFE4(NY,NX)=0.0
      TQSFES(NY,NX)=0.0
      TQSCAO(NY,NX)=0.0
      TQSCAC(NY,NX)=0.0
      TQSCAH(NY,NX)=0.0
      TQSCAS(NY,NX)=0.0
      TQSMGO(NY,NX)=0.0
      TQSMGC(NY,NX)=0.0
      TQSMGH(NY,NX)=0.0
      TQSMGS(NY,NX)=0.0
      TQSNAC(NY,NX)=0.0
      TQSNAS(NY,NX)=0.0
      TQSKAS(NY,NX)=0.0
      TQSH0P(NY,NX)=0.0
      TQSH1P(NY,NX)=0.0
      TQSH3P(NY,NX)=0.0
      TQSF1P(NY,NX)=0.0
      TQSF2P(NY,NX)=0.0
      TQSC0P(NY,NX)=0.0
      TQSC1P(NY,NX)=0.0
      TQSC2P(NY,NX)=0.0
      TQSM1P(NY,NX)=0.0
      ENDIF
      IF(IERSN(NY,NX).NE.0)THEN
      TSEDER(NY,NX)=0.0
      TSANER(NY,NX)=0.0
      TSILER(NY,NX)=0.0
      TCLAER(NY,NX)=0.0
      TCECER(NY,NX)=0.0
      TAECER(NY,NX)=0.0
      TNH4ER(NY,NX)=0.0
      TNH3ER(NY,NX)=0.0
      TNHUER(NY,NX)=0.0
      TNO3ER(NY,NX)=0.0
      TNH4EB(NY,NX)=0.0
      TNH3EB(NY,NX)=0.0
      TNHUEB(NY,NX)=0.0
      TNO3EB(NY,NX)=0.0
      TN4ER(NY,NX)=0.0
      TNBER(NY,NX)=0.0
      THYER(NY,NX)=0.0
      TALER(NY,NX)=0.0
      TCAER(NY,NX)=0.0
      TMGER(NY,NX)=0.0
      TNAER(NY,NX)=0.0
      TKAER(NY,NX)=0.0
      THCER(NY,NX)=0.0
      TAL2ER(NY,NX)=0.0
      TOH0ER(NY,NX)=0.0
      TOH1ER(NY,NX)=0.0
      TOH2ER(NY,NX)=0.0
      TH1PER(NY,NX)=0.0
      TH2PER(NY,NX)=0.0
      TOH0EB(NY,NX)=0.0
      TOH1EB(NY,NX)=0.0
      TOH2EB(NY,NX)=0.0
      TH1PEB(NY,NX)=0.0
      TH2PEB(NY,NX)=0.0
      TALOER(NY,NX)=0.0
      TFEOER(NY,NX)=0.0
      TCACER(NY,NX)=0.0
      TCASER(NY,NX)=0.0
      TALPER(NY,NX)=0.0
      TFEPER(NY,NX)=0.0
      TCPDER(NY,NX)=0.0
      TCPHER(NY,NX)=0.0
      TCPMER(NY,NX)=0.0
      TALPEB(NY,NX)=0.0
      TFEPEB(NY,NX)=0.0
      TCPDEB(NY,NX)=0.0
      TCPHEB(NY,NX)=0.0
      TCPMEB(NY,NX)=0.0
      DO 9480 K=0,5
      DO 9480 NN=1,7
      TOMCER(3,NN,K,NY,NX)=0.0
      DO 9480 M=1,2
      TOMCER(M,NN,K,NY,NX)=0.0
      TOMNER(M,NN,K,NY,NX)=0.0
      TOMPER(M,NN,K,NY,NX)=0.0
9480  CONTINUE
      DO 9475 K=0,4
      DO 9470 M=1,2
      TORCER(M,K,NY,NX)=0.0
      TORNER(M,K,NY,NX)=0.0
      TORPER(M,K,NY,NX)=0.0
9470  CONTINUE
      TOHCER(K,NY,NX)=0.0
      TOHNER(K,NY,NX)=0.0
      TOHPER(K,NY,NX)=0.0
      DO 9465 M=1,4
      TOSCER(M,K,NY,NX)=0.0
      TOSAER(M,K,NY,NX)=0.0
      TOSNER(M,K,NY,NX)=0.0
      TOSPER(M,K,NY,NX)=0.0
9465  CONTINUE
9475  CONTINUE
      ENDIF
      LG=0
      LX=0
      DO 8575 L=NU(NY,NX),NL(NY,NX)
      IF(THETP(L,NY,NX).LT.THETX)LX=1
      IF(THETP(L,NY,NX).GE.THETX.AND.LX.EQ.0)LG=L
      TTHAW(L,NY,NX)=0.0
      TTHAWH(L,NY,NX)=0.0
      THTHAW(L,NY,NX)=0.0
      TFLW(L,NY,NX)=0.0
      TFLWX(L,NY,NX)=0.0
      TFLWH(L,NY,NX)=0.0
      THFLW(L,NY,NX)=0.0
C
C     ARTIFICIAL SOIL WARMING
C
C     IF(L.EQ.5)THEN
C     THFLW(L,NY,NX)=(1.8-3.0*AMIN1(0.30
C    2,AMAX1(0.0,DPTHS(NY,NX))**0.5))*VHCP(L,NY,NX)
C     ENDIF
C
C     ARTIFICIAL SOIL WARMING
C
      DO 8595 K=0,4
      TOCFLS(K,L,NY,NX)=0.0
      TONFLS(K,L,NY,NX)=0.0
      TOPFLS(K,L,NY,NX)=0.0
      TOAFLS(K,L,NY,NX)=0.0
      TOCFHS(K,L,NY,NX)=0.0
      TONFHS(K,L,NY,NX)=0.0
      TOPFHS(K,L,NY,NX)=0.0
      TOAFHS(K,L,NY,NX)=0.0
8595  CONTINUE
      TCOFLS(L,NY,NX)=0.0
      TCHFLS(L,NY,NX)=0.0
      TOXFLS(L,NY,NX)=0.0
      TNGFLS(L,NY,NX)=0.0
      TN2FLS(L,NY,NX)=0.0
      THGFLS(L,NY,NX)=0.0
      TN4FLS(L,NY,NX)=0.0
      TN3FLS(L,NY,NX)=0.0
      TNOFLS(L,NY,NX)=0.0
      TNXFLS(L,NY,NX)=0.0
      TPOFLS(L,NY,NX)=0.0
      TN4FLB(L,NY,NX)=0.0
      TN3FLB(L,NY,NX)=0.0
      TNOFLB(L,NY,NX)=0.0
      TNXFLB(L,NY,NX)=0.0
      TH2BFB(L,NY,NX)=0.0
      TCOFHS(L,NY,NX)=0.0
      TCHFHS(L,NY,NX)=0.0
      TOXFHS(L,NY,NX)=0.0
      TNGFHS(L,NY,NX)=0.0
      TN2FHS(L,NY,NX)=0.0
      THGFHS(L,NY,NX)=0.0
      TN4FHS(L,NY,NX)=0.0
      TN3FHS(L,NY,NX)=0.0
      TNOFHS(L,NY,NX)=0.0
      TNXFHS(L,NY,NX)=0.0
      TPOFHS(L,NY,NX)=0.0
      TN4FHB(L,NY,NX)=0.0
      TN3FHB(L,NY,NX)=0.0
      TNOFHB(L,NY,NX)=0.0
      TNXFHB(L,NY,NX)=0.0
      TH2BHB(L,NY,NX)=0.0
      TCOFLG(L,NY,NX)=0.0
      TCHFLG(L,NY,NX)=0.0
      TOXFLG(L,NY,NX)=0.0
      TNGFLG(L,NY,NX)=0.0
      TN2FLG(L,NY,NX)=0.0
      TNHFLG(L,NY,NX)=0.0
      THGFLG(L,NY,NX)=0.0
      IF(ISALT(NY,NX).NE.0)THEN
      TALFLS(L,NY,NX)=0.0
      TFEFLS(L,NY,NX)=0.0
      THYFLS(L,NY,NX)=0.0
      TCAFLS(L,NY,NX)=0.0
      TMGFLS(L,NY,NX)=0.0
      TNAFLS(L,NY,NX)=0.0
      TKAFLS(L,NY,NX)=0.0
      TOHFLS(L,NY,NX)=0.0
      TSOFLS(L,NY,NX)=0.0
      TCLFLS(L,NY,NX)=0.0
      TC3FLS(L,NY,NX)=0.0
      THCFLS(L,NY,NX)=0.0
      TAL1FS(L,NY,NX)=0.0
      TAL2FS(L,NY,NX)=0.0
      TAL3FS(L,NY,NX)=0.0
      TAL4FS(L,NY,NX)=0.0
      TALSFS(L,NY,NX)=0.0
      TFE1FS(L,NY,NX)=0.0
      TFE2FS(L,NY,NX)=0.0
      TFE3FS(L,NY,NX)=0.0
      TFE4FS(L,NY,NX)=0.0
      TFESFS(L,NY,NX)=0.0
      TCAOFS(L,NY,NX)=0.0
      TCACFS(L,NY,NX)=0.0
      TCAHFS(L,NY,NX)=0.0
      TCASFS(L,NY,NX)=0.0
      TMGOFS(L,NY,NX)=0.0
      TMGCFS(L,NY,NX)=0.0
      TMGHFS(L,NY,NX)=0.0
      TMGSFS(L,NY,NX)=0.0
      TNACFS(L,NY,NX)=0.0
      TNASFS(L,NY,NX)=0.0
      TKASFS(L,NY,NX)=0.0
      TH0PFS(L,NY,NX)=0.0
      TH1PFS(L,NY,NX)=0.0
      TH3PFS(L,NY,NX)=0.0
      TF1PFS(L,NY,NX)=0.0
      TF2PFS(L,NY,NX)=0.0
      TC0PFS(L,NY,NX)=0.0
      TC1PFS(L,NY,NX)=0.0
      TC2PFS(L,NY,NX)=0.0
      TM1PFS(L,NY,NX)=0.0
      TH0BFB(L,NY,NX)=0.0
      TH1BFB(L,NY,NX)=0.0
      TH3BFB(L,NY,NX)=0.0
      TF1BFB(L,NY,NX)=0.0
      TF2BFB(L,NY,NX)=0.0
      TC0BFB(L,NY,NX)=0.0
      TC1BFB(L,NY,NX)=0.0
      TC2BFB(L,NY,NX)=0.0
      TM1BFB(L,NY,NX)=0.0
      TALFHS(L,NY,NX)=0.0
      TFEFHS(L,NY,NX)=0.0
      THYFHS(L,NY,NX)=0.0
      TCAFHS(L,NY,NX)=0.0
      TMGFHS(L,NY,NX)=0.0
      TNAFHS(L,NY,NX)=0.0
      TKAFHS(L,NY,NX)=0.0
      TOHFHS(L,NY,NX)=0.0
      TSOFHS(L,NY,NX)=0.0
      TCLFHS(L,NY,NX)=0.0
      TC3FHS(L,NY,NX)=0.0
      THCFHS(L,NY,NX)=0.0
      TAL1HS(L,NY,NX)=0.0
      TAL2HS(L,NY,NX)=0.0
      TAL3HS(L,NY,NX)=0.0
      TAL4HS(L,NY,NX)=0.0
      TALSHS(L,NY,NX)=0.0
      TFE1HS(L,NY,NX)=0.0
      TFE2HS(L,NY,NX)=0.0
      TFE3HS(L,NY,NX)=0.0
      TFE4HS(L,NY,NX)=0.0
      TFESHS(L,NY,NX)=0.0
      TCAOHS(L,NY,NX)=0.0
      TCACHS(L,NY,NX)=0.0
      TCAHHS(L,NY,NX)=0.0
      TCASHS(L,NY,NX)=0.0
      TMGOHS(L,NY,NX)=0.0
      TMGCHS(L,NY,NX)=0.0
      TMGHHS(L,NY,NX)=0.0
      TMGSHS(L,NY,NX)=0.0
      TNACHS(L,NY,NX)=0.0
      TNASHS(L,NY,NX)=0.0
      TKASHS(L,NY,NX)=0.0
      TH0PHS(L,NY,NX)=0.0
      TH1PHS(L,NY,NX)=0.0
      TH3PHS(L,NY,NX)=0.0
      TF1PHS(L,NY,NX)=0.0
      TF2PHS(L,NY,NX)=0.0
      TC0PHS(L,NY,NX)=0.0
      TC1PHS(L,NY,NX)=0.0
      TC2PHS(L,NY,NX)=0.0
      TM1PHS(L,NY,NX)=0.0
      TH0BHB(L,NY,NX)=0.0
      TH1BHB(L,NY,NX)=0.0
      TH3BHB(L,NY,NX)=0.0
      TF1BHB(L,NY,NX)=0.0
      TF2BHB(L,NY,NX)=0.0
      TC0BHB(L,NY,NX)=0.0
      TC1BHB(L,NY,NX)=0.0
      TC2BHB(L,NY,NX)=0.0
      TM1BHB(L,NY,NX)=0.0
      ENDIF
      N1=NX
      N2=NY
      N3=L
      DO 8580 N=1,3
      IF(N.EQ.1)THEN
      N4=NX+1
      N5=NY
      N6=L
      ELSEIF(N.EQ.2)THEN
      N4=NX
      N5=NY+1
      N6=L
      ELSEIF(N.EQ.3)THEN
      N4=NX
      N5=NY
      N6=L+1
      ENDIF
C
C     TOTAL FLUXES FROM OVERLAND FLOW
C
      IF(L.EQ.NU(N2,N1).AND.N.NE.3)THEN
      TQR(N2,N1)=TQR(N2,N1)+QR(N,N2,N1)-QR(N,N5,N4)
      THQR(N2,N1)=THQR(N2,N1)+HQR(N,N2,N1)-HQR(N,N5,N4)
      TQS(N2,N1)=TQS(N2,N1)+QS(N,N2,N1)-QS(N,N5,N4)
      TQW(N2,N1)=TQW(N2,N1)+QW(N,N2,N1)-QW(N,N5,N4)
      TQI(N2,N1)=TQI(N2,N1)+QI(N,N2,N1)-QI(N,N5,N4)
      THQS(N2,N1)=THQS(N2,N1)+HQS(N,N2,N1)-HQS(N,N5,N4)
      DO 8590 K=0,2
      TOCQRS(K,N2,N1)=TOCQRS(K,N2,N1)+XOCQRS(K,N,N2,N1)
     2-XOCQRS(K,N,N5,N4)
      TONQRS(K,N2,N1)=TONQRS(K,N2,N1)+XONQRS(K,N,N2,N1)
     2-XONQRS(K,N,N5,N4)
      TOPQRS(K,N2,N1)=TOPQRS(K,N2,N1)+XOPQRS(K,N,N2,N1)
     2-XOPQRS(K,N,N5,N4)
      TOAQRS(K,N2,N1)=TOAQRS(K,N2,N1)+XOAQRS(K,N,N2,N1)
     2-XOAQRS(K,N,N5,N4)
8590  CONTINUE
      TCOQRS(N2,N1)=TCOQRS(N2,N1)+XCOQRS(N,N2,N1)-XCOQRS(N,N5,N4)
      TCHQRS(N2,N1)=TCHQRS(N2,N1)+XCHQRS(N,N2,N1)-XCHQRS(N,N5,N4)
      TOXQRS(N2,N1)=TOXQRS(N2,N1)+XOXQRS(N,N2,N1)-XOXQRS(N,N5,N4)
      TNGQRS(N2,N1)=TNGQRS(N2,N1)+XNGQRS(N,N2,N1)-XNGQRS(N,N5,N4)
      TN2QRS(N2,N1)=TN2QRS(N2,N1)+XN2QRS(N,N2,N1)-XN2QRS(N,N5,N4)
      THGQRS(N2,N1)=THGQRS(N2,N1)+XHGQRS(N,N2,N1)-XHGQRS(N,N5,N4)
      TN4QRS(N2,N1)=TN4QRS(N2,N1)+XN4QRW(N,N2,N1)-XN4QRW(N,N5,N4)
      TN3QRS(N2,N1)=TN3QRS(N2,N1)+XN3QRW(N,N2,N1)-XN3QRW(N,N5,N4)
      TNOQRS(N2,N1)=TNOQRS(N2,N1)+XNOQRW(N,N2,N1)-XNOQRW(N,N5,N4)
      TNXQRS(N2,N1)=TNXQRS(N2,N1)+XNXQRS(N,N2,N1)-XNXQRS(N,N5,N4)
      TPOQRS(N2,N1)=TPOQRS(N2,N1)+XP4QRW(N,N2,N1)-XP4QRW(N,N5,N4)
      TCOQSS(N2,N1)=TCOQSS(N2,N1)+XCOQSS(N,N2,N1)-XCOQSS(N,N5,N4)
      TCHQSS(N2,N1)=TCHQSS(N2,N1)+XCHQSS(N,N2,N1)-XCHQSS(N,N5,N4)
      TOXQSS(N2,N1)=TOXQSS(N2,N1)+XOXQSS(N,N2,N1)-XOXQSS(N,N5,N4)
      TNGQSS(N2,N1)=TNGQSS(N2,N1)+XNGQSS(N,N2,N1)-XNGQSS(N,N5,N4)
      TN2QSS(N2,N1)=TN2QSS(N2,N1)+XN2QSS(N,N2,N1)-XN2QSS(N,N5,N4)
      TN4QSS(N2,N1)=TN4QSS(N2,N1)+XN4QSS(N,N2,N1)-XN4QSS(N,N5,N4)
      TN3QSS(N2,N1)=TN3QSS(N2,N1)+XN3QSS(N,N2,N1)-XN3QSS(N,N5,N4)
      TNOQSS(N2,N1)=TNOQSS(N2,N1)+XNOQSS(N,N2,N1)-XNOQSS(N,N5,N4)
      TPOQSS(N2,N1)=TPOQSS(N2,N1)+XP4QSS(N,N2,N1)-XP4QSS(N,N5,N4)
      IF(ISALT(NY,NX).NE.0)THEN
      TQRAL(N2,N1)=TQRAL(N2,N1)+XQRAL(N,N2,N1)-XQRAL(N,N5,N4)
      TQRFE(N2,N1)=TQRFE(N2,N1)+XQRFE(N,N2,N1)-XQRFE(N,N5,N4)
      TQRHY(N2,N1)=TQRHY(N2,N1)+XQRHY(N,N2,N1)-XQRHY(N,N5,N4)
      TQRCA(N2,N1)=TQRCA(N2,N1)+XQRCA(N,N2,N1)-XQRCA(N,N5,N4)
      TQRMG(N2,N1)=TQRMG(N2,N1)+XQRMG(N,N2,N1)-XQRMG(N,N5,N4)
      TQRNA(N2,N1)=TQRNA(N2,N1)+XQRNA(N,N2,N1)-XQRNA(N,N5,N4)
      TQRKA(N2,N1)=TQRKA(N2,N1)+XQRKA(N,N2,N1)-XQRKA(N,N5,N4)
      TQROH(N2,N1)=TQROH(N2,N1)+XQROH(N,N2,N1)-XQROH(N,N5,N4)
      TQRSO(N2,N1)=TQRSO(N2,N1)+XQRSO(N,N2,N1)-XQRSO(N,N5,N4)
      TQRCL(N2,N1)=TQRCL(N2,N1)+XQRCL(N,N2,N1)-XQRCL(N,N5,N4)
      TQRC3(N2,N1)=TQRC3(N2,N1)+XQRC3(N,N2,N1)-XQRC3(N,N5,N4)
      TQRHC(N2,N1)=TQRHC(N2,N1)+XQRHC(N,N2,N1)-XQRHC(N,N5,N4)
      TQRAL1(N2,N1)=TQRAL1(N2,N1)+XQRAL1(N,N2,N1)-XQRAL1(N,N5,N4)
      TQRAL2(N2,N1)=TQRAL2(N2,N1)+XQRAL2(N,N2,N1)-XQRAL2(N,N5,N4)
      TQRAL3(N2,N1)=TQRAL3(N2,N1)+XQRAL3(N,N2,N1)-XQRAL3(N,N5,N4)
      TQRAL4(N2,N1)=TQRAL4(N2,N1)+XQRAL4(N,N2,N1)-XQRAL4(N,N5,N4)
      TQRALS(N2,N1)=TQRALS(N2,N1)+XQRALS(N,N2,N1)-XQRALS(N,N5,N4)
      TQRFE1(N2,N1)=TQRFE1(N2,N1)+XQRFE1(N,N2,N1)-XQRFE1(N,N5,N4)
      TQRFE2(N2,N1)=TQRFE2(N2,N1)+XQRFE2(N,N2,N1)-XQRFE2(N,N5,N4)
      TQRFE3(N2,N1)=TQRFE3(N2,N1)+XQRFE3(N,N2,N1)-XQRFE3(N,N5,N4)
      TQRFE4(N2,N1)=TQRFE4(N2,N1)+XQRFE4(N,N2,N1)-XQRFE4(N,N5,N4)
      TQRFES(N2,N1)=TQRFES(N2,N1)+XQRFES(N,N2,N1)-XQRFES(N,N5,N4)
      TQRCAO(N2,N1)=TQRCAO(N2,N1)+XQRCAO(N,N2,N1)-XQRCAO(N,N5,N4)
      TQRCAC(N2,N1)=TQRCAC(N2,N1)+XQRCAC(N,N2,N1)-XQRCAC(N,N5,N4)
      TQRCAH(N2,N1)=TQRCAH(N2,N1)+XQRCAH(N,N2,N1)-XQRCAH(N,N5,N4)
      TQRCAS(N2,N1)=TQRCAS(N2,N1)+XQRCAS(N,N2,N1)-XQRCAS(N,N5,N4)
      TQRMGO(N2,N1)=TQRMGO(N2,N1)+XQRMGO(N,N2,N1)-XQRMGO(N,N5,N4)
      TQRMGC(N2,N1)=TQRMGC(N2,N1)+XQRMGC(N,N2,N1)-XQRMGC(N,N5,N4)
      TQRMGH(N2,N1)=TQRMGH(N2,N1)+XQRMGH(N,N2,N1)-XQRMGH(N,N5,N4)
      TQRMGS(N2,N1)=TQRMGS(N2,N1)+XQRMGS(N,N2,N1)-XQRMGS(N,N5,N4)
      TQRNAC(N2,N1)=TQRNAC(N2,N1)+XQRNAC(N,N2,N1)-XQRNAC(N,N5,N4)
      TQRNAS(N2,N1)=TQRNAS(N2,N1)+XQRNAS(N,N2,N1)-XQRNAS(N,N5,N4)
      TQRKAS(N2,N1)=TQRKAS(N2,N1)+XQRKAS(N,N2,N1)-XQRKAS(N,N5,N4)
      TQRH0P(N2,N1)=TQRH0P(N2,N1)+XQRH0P(N,N2,N1)-XQRH0P(N,N5,N4)
      TQRH1P(N2,N1)=TQRH1P(N2,N1)+XQRH1P(N,N2,N1)-XQRH1P(N,N5,N4)
      TQRH3P(N2,N1)=TQRH3P(N2,N1)+XQRH3P(N,N2,N1)-XQRH3P(N,N5,N4)
      TQRF1P(N2,N1)=TQRF1P(N2,N1)+XQRF1P(N,N2,N1)-XQRF1P(N,N5,N4)
      TQRF2P(N2,N1)=TQRF2P(N2,N1)+XQRF2P(N,N2,N1)-XQRF2P(N,N5,N4)
      TQRC0P(N2,N1)=TQRC0P(N2,N1)+XQRC0P(N,N2,N1)-XQRC0P(N,N5,N4)
      TQRC1P(N2,N1)=TQRC1P(N2,N1)+XQRC1P(N,N2,N1)-XQRC1P(N,N5,N4)
      TQRC2P(N2,N1)=TQRC2P(N2,N1)+XQRC2P(N,N2,N1)-XQRC2P(N,N5,N4)
      TQRM1P(N2,N1)=TQRM1P(N2,N1)+XQRM1P(N,N2,N1)-XQRM1P(N,N5,N4)
      TQSAL(N2,N1)=TQSAL(N2,N1)+XQSAL(N,N2,N1)-XQSAL(N,N5,N4)
      TQSFE(N2,N1)=TQSFE(N2,N1)+XQSFE(N,N2,N1)-XQSFE(N,N5,N4)
      TQSHY(N2,N1)=TQSHY(N2,N1)+XQSHY(N,N2,N1)-XQSHY(N,N5,N4)
      TQSCA(N2,N1)=TQSCA(N2,N1)+XQSCA(N,N2,N1)-XQSCA(N,N5,N4)
      TQSMG(N2,N1)=TQSMG(N2,N1)+XQSMG(N,N2,N1)-XQSMG(N,N5,N4)
      TQSNA(N2,N1)=TQSNA(N2,N1)+XQSNA(N,N2,N1)-XQSNA(N,N5,N4)
      TQSKA(N2,N1)=TQSKA(N2,N1)+XQSKA(N,N2,N1)-XQSKA(N,N5,N4)
      TQSOH(N2,N1)=TQSOH(N2,N1)+XQSOH(N,N2,N1)-XQSOH(N,N5,N4)
      TQSSO(N2,N1)=TQSSO(N2,N1)+XQSSO(N,N2,N1)-XQSSO(N,N5,N4)
      TQSCL(N2,N1)=TQSCL(N2,N1)+XQSCL(N,N2,N1)-XQSCL(N,N5,N4)
      TQSC3(N2,N1)=TQSC3(N2,N1)+XQSC3(N,N2,N1)-XQSC3(N,N5,N4)
      TQSHC(N2,N1)=TQSHC(N2,N1)+XQSHC(N,N2,N1)-XQSHC(N,N5,N4)
      TQSAL1(N2,N1)=TQSAL1(N2,N1)+XQSAL1(N,N2,N1)-XQSAL1(N,N5,N4)
      TQSAL2(N2,N1)=TQSAL2(N2,N1)+XQSAL2(N,N2,N1)-XQSAL2(N,N5,N4)
      TQSAL3(N2,N1)=TQSAL3(N2,N1)+XQSAL3(N,N2,N1)-XQSAL3(N,N5,N4)
      TQSAL4(N2,N1)=TQSAL4(N2,N1)+XQSAL4(N,N2,N1)-XQSAL4(N,N5,N4)
      TQSALS(N2,N1)=TQSALS(N2,N1)+XQSALS(N,N2,N1)-XQSALS(N,N5,N4)
      TQSFE1(N2,N1)=TQSFE1(N2,N1)+XQSFE1(N,N2,N1)-XQSFE1(N,N5,N4)
      TQSFE2(N2,N1)=TQSFE2(N2,N1)+XQSFE2(N,N2,N1)-XQSFE2(N,N5,N4)
      TQSFE3(N2,N1)=TQSFE3(N2,N1)+XQSFE3(N,N2,N1)-XQSFE3(N,N5,N4)
      TQSFE4(N2,N1)=TQSFE4(N2,N1)+XQSFE4(N,N2,N1)-XQSFE4(N,N5,N4)
      TQSFES(N2,N1)=TQSFES(N2,N1)+XQSFES(N,N2,N1)-XQSFES(N,N5,N4)
      TQSCAO(N2,N1)=TQSCAO(N2,N1)+XQSCAO(N,N2,N1)-XQSCAO(N,N5,N4)
      TQSCAC(N2,N1)=TQSCAC(N2,N1)+XQSCAC(N,N2,N1)-XQSCAC(N,N5,N4)
      TQSCAH(N2,N1)=TQSCAH(N2,N1)+XQSCAH(N,N2,N1)-XQSCAH(N,N5,N4)
      TQSCAS(N2,N1)=TQSCAS(N2,N1)+XQSCAS(N,N2,N1)-XQSCAS(N,N5,N4)
      TQSMGO(N2,N1)=TQSMGO(N2,N1)+XQSMGO(N,N2,N1)-XQSMGO(N,N5,N4)
      TQSMGC(N2,N1)=TQSMGC(N2,N1)+XQSMGC(N,N2,N1)-XQSMGC(N,N5,N4)
      TQSMGH(N2,N1)=TQSMGH(N2,N1)+XQSMGH(N,N2,N1)-XQSMGH(N,N5,N4)
      TQSMGS(N2,N1)=TQSMGS(N2,N1)+XQSMGS(N,N2,N1)-XQSMGS(N,N5,N4)
      TQSNAC(N2,N1)=TQSNAC(N2,N1)+XQSNAC(N,N2,N1)-XQSNAC(N,N5,N4)
      TQSNAS(N2,N1)=TQSNAS(N2,N1)+XQSNAS(N,N2,N1)-XQSNAS(N,N5,N4)
      TQSKAS(N2,N1)=TQSKAS(N2,N1)+XQSKAS(N,N2,N1)-XQSKAS(N,N5,N4)
      TQSH0P(N2,N1)=TQSH0P(N2,N1)+XQSH0P(N,N2,N1)-XQSH0P(N,N5,N4)
      TQSH1P(N2,N1)=TQSH1P(N2,N1)+XQSH1P(N,N2,N1)-XQSH1P(N,N5,N4)
      TQSH3P(N2,N1)=TQSH3P(N2,N1)+XQSH3P(N,N2,N1)-XQSH3P(N,N5,N4)
      TQSF1P(N2,N1)=TQSF1P(N2,N1)+XQSF1P(N,N2,N1)-XQSF1P(N,N5,N4)
      TQSF2P(N2,N1)=TQSF2P(N2,N1)+XQSF2P(N,N2,N1)-XQSF2P(N,N5,N4)
      TQSC0P(N2,N1)=TQSC0P(N2,N1)+XQSC0P(N,N2,N1)-XQSC0P(N,N5,N4)
      TQSC1P(N2,N1)=TQSC1P(N2,N1)+XQSC1P(N,N2,N1)-XQSC1P(N,N5,N4)
      TQSC2P(N2,N1)=TQSC2P(N2,N1)+XQSC2P(N,N2,N1)-XQSC2P(N,N5,N4)
      TQSM1P(N2,N1)=TQSM1P(N2,N1)+XQSM1P(N,N2,N1)-XQSM1P(N,N5,N4)
      ENDIF
C
C     TOTAL FLUXES FROM SEDIMENT TRANSPORT
C
      IF(IERSN(NY,NX).NE.0)THEN
      TSEDER(N2,N1)=TSEDER(N2,N1)+XSEDER(N,N2,N1)-XSEDER(N,N5,N4)
      TSANER(N2,N1)=TSANER(N2,N1)+XSANER(N,N2,N1)-XSANER(N,N5,N4)
      TSILER(N2,N1)=TSILER(N2,N1)+XSILER(N,N2,N1)-XSILER(N,N5,N4)
      TCLAER(N2,N1)=TCLAER(N2,N1)+XCLAER(N,N2,N1)-XCLAER(N,N5,N4)
      TCECER(N2,N1)=TCECER(N2,N1)+XCECER(N,N2,N1)-XCECER(N,N5,N4)
      TAECER(N2,N1)=TAECER(N2,N1)+XAECER(N,N2,N1)-XAECER(N,N5,N4)
      TNH4ER(N2,N1)=TNH4ER(N2,N1)+XNH4ER(N,N2,N1)-XNH4ER(N,N5,N4)
      TNH3ER(N2,N1)=TNH3ER(N2,N1)+XNH3ER(N,N2,N1)-XNH3ER(N,N5,N4)
      TNHUER(N2,N1)=TNHUER(N2,N1)+XNHUER(N,N2,N1)-XNHUER(N,N5,N4)
      TNO3ER(N2,N1)=TNO3ER(N2,N1)+XNO3ER(N,N2,N1)-XNO3ER(N,N5,N4)
      TNH4EB(N2,N1)=TNH4EB(N2,N1)+XNH4EB(N,N2,N1)-XNH4EB(N,N5,N4)
      TNH3EB(N2,N1)=TNH3EB(N2,N1)+XNH3EB(N,N2,N1)-XNH3EB(N,N5,N4)
      TNHUEB(N2,N1)=TNHUEB(N2,N1)+XNHUEB(N,N2,N1)-XNHUEB(N,N5,N4)
      TNO3EB(N2,N1)=TNO3EB(N2,N1)+XNO3EB(N,N2,N1)-XNO3EB(N,N5,N4)
      TN4ER(N2,N1)=TN4ER(N2,N1)+XN4ER(N,N2,N1)-XN4ER(N,N5,N4)
      TNBER(N2,N1)=TNBER(N2,N1)+XNBER(N,N2,N1)-XNBER(N,N5,N4)
      THYER(N2,N1)=THYER(N2,N1)+XHYER(N,N2,N1)-XHYER(N,N5,N4)
      TALER(N2,N1)=TALER(N2,N1)+XALER(N,N2,N1)-XALER(N,N5,N4)
      TCAER(N2,N1)=TCAER(N2,N1)+XCAER(N,N2,N1)-XCAER(N,N5,N4)
      TMGER(N2,N1)=TMGER(N2,N1)+XMGER(N,N2,N1)-XMGER(N,N5,N4)
      TNAER(N2,N1)=TNAER(N2,N1)+XNAER(N,N2,N1)-XNAER(N,N5,N4)
      TKAER(N2,N1)=TKAER(N2,N1)+XKAER(N,N2,N1)-XKAER(N,N5,N4)
      THCER(N2,N1)=THCER(N2,N1)+XHCER(N,N2,N1)-XHCER(N,N5,N4)
      TAL2ER(N2,N1)=TAL2ER(N2,N1)+XAL2ER(N,N2,N1)-XAL2ER(N,N5,N4)
      TOH0ER(N2,N1)=TOH0ER(N2,N1)+XOH0ER(N,N2,N1)-XOH0ER(N,N5,N4)
      TOH1ER(N2,N1)=TOH1ER(N2,N1)+XOH1ER(N,N2,N1)-XOH1ER(N,N5,N4)
      TOH2ER(N2,N1)=TOH2ER(N2,N1)+XOH2ER(N,N2,N1)-XOH2ER(N,N5,N4)
      TH1PER(N2,N1)=TH1PER(N2,N1)+XH1PER(N,N2,N1)-XH1PER(N,N5,N4)
      TH2PER(N2,N1)=TH2PER(N2,N1)+XH2PER(N,N2,N1)-XH2PER(N,N5,N4)
      TOH0EB(N2,N1)=TOH0EB(N2,N1)+XOH0EB(N,N2,N1)-XOH0EB(N,N5,N4)
      TOH1EB(N2,N1)=TOH1EB(N2,N1)+XOH1EB(N,N2,N1)-XOH1EB(N,N5,N4)
      TOH2EB(N2,N1)=TOH2EB(N2,N1)+XOH2EB(N,N2,N1)-XOH2EB(N,N5,N4)
      TH1PEB(N2,N1)=TH1PEB(N2,N1)+XH1PEB(N,N2,N1)-XH1PEB(N,N5,N4)
      TH2PEB(N2,N1)=TH2PEB(N2,N1)+XH2PEB(N,N2,N1)-XH2PEB(N,N5,N4)
      TALOER(N2,N1)=TALOER(N2,N1)+PALOER(N,N2,N1)-PALOER(N,N5,N4)
      TFEOER(N2,N1)=TFEOER(N2,N1)+PFEOER(N,N2,N1)-PFEOER(N,N5,N4)
      TCACER(N2,N1)=TCACER(N2,N1)+PCACER(N,N2,N1)-PCACER(N,N5,N4)
      TCASER(N2,N1)=TCASER(N2,N1)+PCASER(N,N2,N1)-PCASER(N,N5,N4)
      TALPER(N2,N1)=TALPER(N2,N1)+PALPER(N,N2,N1)-PALPER(N,N5,N4)
      TFEPER(N2,N1)=TFEPER(N2,N1)+PFEPER(N,N2,N1)-PFEPER(N,N5,N4)
      TCPDER(N2,N1)=TCPDER(N2,N1)+PCPDER(N,N2,N1)-PCPDER(N,N5,N4)
      TCPHER(N2,N1)=TCPHER(N2,N1)+PCPHER(N,N2,N1)-PCPHER(N,N5,N4)
      TCPMER(N2,N1)=TCPMER(N2,N1)+PCPMER(N,N2,N1)-PCPMER(N,N5,N4)
      TALPEB(N2,N1)=TALPEB(N2,N1)+PALPEB(N,N2,N1)-PALPEB(N,N5,N4)
      TFEPEB(N2,N1)=TFEPEB(N2,N1)+PFEPEB(N,N2,N1)-PFEPEB(N,N5,N4)
      TCPDEB(N2,N1)=TCPDEB(N2,N1)+PCPDEB(N,N2,N1)-PCPDEB(N,N5,N4)
      TCPHEB(N2,N1)=TCPHEB(N2,N1)+PCPHEB(N,N2,N1)-PCPHEB(N,N5,N4)
      TCPMEB(N2,N1)=TCPMEB(N2,N1)+PCPMEB(N,N2,N1)-PCPMEB(N,N5,N4)
      DO 9380 K=0,5
      DO 9380 NN=1,7
      TOMCER(3,NN,K,N2,N1)=TOMCER(3,NN,K,N2,N1)
     2+OMCER(3,NN,K,N,N2,N1)-OMCER(3,NN,K,N,N5,N4)
      DO 9380 M=1,2
      TOMCER(M,NN,K,N2,N1)=TOMCER(M,NN,K,N2,N1)
     2+OMCER(M,NN,K,N,N2,N1)-OMCER(M,NN,K,N,N5,N4)
      TOMNER(M,NN,K,N2,N1)=TOMNER(M,NN,K,N2,N1)
     2+OMNER(M,NN,K,N,N2,N1)-OMNER(M,NN,K,N,N5,N4)
      TOMPER(M,NN,K,N2,N1)=TOMPER(M,NN,K,N2,N1)
     2+OMPER(M,NN,K,N,N2,N1)-OMPER(M,NN,K,N,N5,N4)
9380  CONTINUE
      DO 9375 K=0,4
      DO 9370 M=1,2
      TORCER(M,K,N2,N1)=TORCER(M,K,N2,N1)
     2+ORCER(M,K,N,N2,N1)-ORCER(M,K,N,N5,N4)
      TORNER(M,K,N2,N1)=TORNER(M,K,N2,N1)
     2+ORNER(M,K,N,N2,N1)-ORNER(M,K,N,N5,N4)
      TORPER(M,K,N2,N1)=TORPER(M,K,N2,N1)
     2+ORPER(M,K,N,N2,N1)-ORPER(M,K,N,N5,N4)
9370  CONTINUE
      TOHCER(K,N2,N1)=TOHCER(K,N2,N1)
     2+OHCER(K,N,N2,N1)-OHCER(K,N,N5,N4)
      TOHNER(K,N2,N1)=TOHNER(K,N2,N1)
     2+OHNER(K,N,N2,N1)-OHNER(K,N,N5,N4)
      TOHPER(K,N2,N1)=TOHPER(K,N2,N1)
     2+OHPER(K,N,N2,N1)-OHPER(K,N,N5,N4)
      DO 9365 M=1,4
      TOSCER(M,K,N2,N1)=TOSCER(M,K,N2,N1)
     2+OSCER(M,K,N,N2,N1)-OSCER(M,K,N,N5,N4)
      TOSAER(M,K,N2,N1)=TOSAER(M,K,N2,N1)
     2+OSAER(M,K,N,N2,N1)-OSAER(M,K,N,N5,N4)
      TOSNER(M,K,N2,N1)=TOSNER(M,K,N2,N1)
     2+OSNER(M,K,N,N2,N1)-OSNER(M,K,N,N5,N4)
      TOSPER(M,K,N2,N1)=TOSPER(M,K,N2,N1)
     2+OSPER(M,K,N,N2,N1)-OSPER(M,K,N,N5,N4)
9365  CONTINUE
9375  CONTINUE
      ENDIF
      ENDIF
C
C     TOTAL HEAT, WATER, GAS AND SOLUTE FLUXES BETWEEN ADJACENT
C     GRID CELLS
C
      IF(NCN(N2,N1).EQ.1.OR.N.EQ.3)THEN
      TTHAW(N3,N2,N1)=TTHAW(N3,N2,N1)+THAW(N,N3,N2,N1)
      TTHAWH(N3,N2,N1)=TTHAWH(N3,N2,N1)+THAWH(N,N3,N2,N1)
      THTHAW(N3,N2,N1)=THTHAW(N3,N2,N1)+HTHAW(N,N3,N2,N1)
      TFLW(N3,N2,N1)=TFLW(N3,N2,N1)+FLW(N,N3,N2,N1)-FLW(N,N6,N5,N4)
      TFLWX(N3,N2,N1)=TFLWX(N3,N2,N1)+FLWX(N,N3,N2,N1)-FLWX(N,N6,N5,N4)
      TFLWH(N3,N2,N1)=TFLWH(N3,N2,N1)+FLWH(N,N3,N2,N1)-FLWH(N,N6,N5,N4)
      THFLW(N3,N2,N1)=THFLW(N3,N2,N1)+HFLW(N,N3,N2,N1)-HFLW(N,N6,N5,N4)
      DO 8585 K=0,4
      TOCFLS(K,N3,N2,N1)=TOCFLS(K,N3,N2,N1)+XOCFLS(K,N,N3,N2,N1)
     2-XOCFLS(K,N,N6,N5,N4)
      TONFLS(K,N3,N2,N1)=TONFLS(K,N3,N2,N1)+XONFLS(K,N,N3,N2,N1)
     2-XONFLS(K,N,N6,N5,N4)
      TOPFLS(K,N3,N2,N1)=TOPFLS(K,N3,N2,N1)+XOPFLS(K,N,N3,N2,N1)
     2-XOPFLS(K,N,N6,N5,N4)
      TOAFLS(K,N3,N2,N1)=TOAFLS(K,N3,N2,N1)+XOAFLS(K,N,N3,N2,N1)
     2-XOAFLS(K,N,N6,N5,N4)
      TOCFHS(K,N3,N2,N1)=TOCFHS(K,N3,N2,N1)+XOCFHS(K,N,N3,N2,N1)
     2-XOCFHS(K,N,N6,N5,N4)
      TONFHS(K,N3,N2,N1)=TONFHS(K,N3,N2,N1)+XONFHS(K,N,N3,N2,N1)
     2-XONFHS(K,N,N6,N5,N4)
      TOPFHS(K,N3,N2,N1)=TOPFHS(K,N3,N2,N1)+XOPFHS(K,N,N3,N2,N1)
     2-XOPFHS(K,N,N6,N5,N4)
      TOAFHS(K,N3,N2,N1)=TOAFHS(K,N3,N2,N1)+XOAFHS(K,N,N3,N2,N1)
     2-XOAFHS(K,N,N6,N5,N4)
8585  CONTINUE
      TCOFLS(N3,N2,N1)=TCOFLS(N3,N2,N1)+XCOFLS(N,N3,N2,N1)
     2-XCOFLS(N,N6,N5,N4)
      TCHFLS(N3,N2,N1)=TCHFLS(N3,N2,N1)+XCHFLS(N,N3,N2,N1)
     2-XCHFLS(N,N6,N5,N4)
      TOXFLS(N3,N2,N1)=TOXFLS(N3,N2,N1)+XOXFLS(N,N3,N2,N1)
     2-XOXFLS(N,N6,N5,N4)
      TNGFLS(N3,N2,N1)=TNGFLS(N3,N2,N1)+XNGFLS(N,N3,N2,N1)
     2-XNGFLS(N,N6,N5,N4)
      TN2FLS(N3,N2,N1)=TN2FLS(N3,N2,N1)+XN2FLS(N,N3,N2,N1)
     2-XN2FLS(N,N6,N5,N4)
      THGFLS(N3,N2,N1)=THGFLS(N3,N2,N1)+XHGFLS(N,N3,N2,N1)
     2-XHGFLS(N,N6,N5,N4)
      TN4FLS(N3,N2,N1)=TN4FLS(N3,N2,N1)+XN4FLW(N,N3,N2,N1)
     2-XN4FLW(N,N6,N5,N4)
      TN3FLS(N3,N2,N1)=TN3FLS(N3,N2,N1)+XN3FLW(N,N3,N2,N1)
     2-XN3FLW(N,N6,N5,N4)
      TNOFLS(N3,N2,N1)=TNOFLS(N3,N2,N1)+XNOFLW(N,N3,N2,N1)
     2-XNOFLW(N,N6,N5,N4)
      TNXFLS(N3,N2,N1)=TNXFLS(N3,N2,N1)+XNXFLS(N,N3,N2,N1)
     2-XNXFLS(N,N6,N5,N4)
      TPOFLS(N3,N2,N1)=TPOFLS(N3,N2,N1)+XH2PFS(N,N3,N2,N1)
     2-XH2PFS(N,N6,N5,N4)
      TN4FLB(N3,N2,N1)=TN4FLB(N3,N2,N1)+XN4FLB(N,N3,N2,N1)
     2-XN4FLB(N,N6,N5,N4)
      TN3FLB(N3,N2,N1)=TN3FLB(N3,N2,N1)+XN3FLB(N,N3,N2,N1)
     2-XN3FLB(N,N6,N5,N4)
      TNOFLB(N3,N2,N1)=TNOFLB(N3,N2,N1)+XNOFLB(N,N3,N2,N1)
     2-XNOFLB(N,N6,N5,N4)
      TNXFLB(N3,N2,N1)=TNXFLB(N3,N2,N1)+XNXFLB(N,N3,N2,N1)
     2-XNXFLB(N,N6,N5,N4)
      TH2BFB(N3,N2,N1)=TH2BFB(N3,N2,N1)+XH2BFB(N,N3,N2,N1)
     2-XH2BFB(N,N6,N5,N4)
      TCOFHS(N3,N2,N1)=TCOFHS(N3,N2,N1)+XCOFHS(N,N3,N2,N1)
     2-XCOFHS(N,N6,N5,N4)
      TCHFHS(N3,N2,N1)=TCHFHS(N3,N2,N1)+XCHFHS(N,N3,N2,N1)
     2-XCHFHS(N,N6,N5,N4)
      TOXFHS(N3,N2,N1)=TOXFHS(N3,N2,N1)+XOXFHS(N,N3,N2,N1)
     2-XOXFHS(N,N6,N5,N4)
      TNGFHS(N3,N2,N1)=TNGFHS(N3,N2,N1)+XNGFHS(N,N3,N2,N1)
     2-XNGFHS(N,N6,N5,N4)
      TN2FHS(N3,N2,N1)=TN2FHS(N3,N2,N1)+XN2FHS(N,N3,N2,N1)
     2-XN2FHS(N,N6,N5,N4)
      THGFHS(N3,N2,N1)=THGFHS(N3,N2,N1)+XHGFHS(N,N3,N2,N1)
     2-XHGFHS(N,N6,N5,N4)
      TN4FHS(N3,N2,N1)=TN4FHS(N3,N2,N1)+XN4FHW(N,N3,N2,N1)
     2-XN4FHW(N,N6,N5,N4)
      TN3FHS(N3,N2,N1)=TN3FHS(N3,N2,N1)+XN3FHW(N,N3,N2,N1)
     2-XN3FHW(N,N6,N5,N4)
      TNOFHS(N3,N2,N1)=TNOFHS(N3,N2,N1)+XNOFHW(N,N3,N2,N1)
     2-XNOFHW(N,N6,N5,N4)
      TNXFHS(N3,N2,N1)=TNXFHS(N3,N2,N1)+XNXFHS(N,N3,N2,N1)
     2-XNXFHS(N,N6,N5,N4)
      TPOFHS(N3,N2,N1)=TPOFHS(N3,N2,N1)+XH2PHS(N,N3,N2,N1)
     2-XH2PHS(N,N6,N5,N4)
      TN4FHB(N3,N2,N1)=TN4FHB(N3,N2,N1)+XN4FHB(N,N3,N2,N1)
     2-XN4FHB(N,N6,N5,N4)
      TN3FHB(N3,N2,N1)=TN3FHB(N3,N2,N1)+XN3FHB(N,N3,N2,N1)
     2-XN3FHB(N,N6,N5,N4)
      TNOFHB(N3,N2,N1)=TNOFHB(N3,N2,N1)+XNOFHB(N,N3,N2,N1)
     2-XNOFHB(N,N6,N5,N4)
      TNXFHB(N3,N2,N1)=TNXFHB(N3,N2,N1)+XNXFHB(N,N3,N2,N1)
     2-XNXFHB(N,N6,N5,N4)
      TH2BHB(N3,N2,N1)=TH2BHB(N3,N2,N1)+XH2BHB(N,N3,N2,N1)
     2-XH2BHB(N,N6,N5,N4)
      TCOFLG(N3,N2,N1)=TCOFLG(N3,N2,N1)+XCOFLG(N,N3,N2,N1)
     2-XCOFLG(N,N6,N5,N4)
      TCHFLG(N3,N2,N1)=TCHFLG(N3,N2,N1)+XCHFLG(N,N3,N2,N1)
     2-XCHFLG(N,N6,N5,N4)
      TOXFLG(N3,N2,N1)=TOXFLG(N3,N2,N1)+XOXFLG(N,N3,N2,N1)
     2-XOXFLG(N,N6,N5,N4)
      TNGFLG(N3,N2,N1)=TNGFLG(N3,N2,N1)+XNGFLG(N,N3,N2,N1)
     2-XNGFLG(N,N6,N5,N4)
      TN2FLG(N3,N2,N1)=TN2FLG(N3,N2,N1)+XN2FLG(N,N3,N2,N1)
     2-XN2FLG(N,N6,N5,N4)
      TNHFLG(N3,N2,N1)=TNHFLG(N3,N2,N1)+XN3FLG(N,N3,N2,N1)
     2-XN3FLG(N,N6,N5,N4)
      THGFLG(N3,N2,N1)=THGFLG(N3,N2,N1)+XHGFLG(N,N3,N2,N1)
     2-XHGFLG(N,N6,N5,N4)
      IF(ISALT(N2,N1).NE.0)THEN
      TALFLS(N3,N2,N1)=TALFLS(N3,N2,N1)+XALFLS(N,N3,N2,N1)
     2-XALFLS(N,N6,N5,N4)
      TFEFLS(N3,N2,N1)=TFEFLS(N3,N2,N1)+XFEFLS(N,N3,N2,N1)
     2-XFEFLS(N,N6,N5,N4)
      THYFLS(N3,N2,N1)=THYFLS(N3,N2,N1)+XHYFLS(N,N3,N2,N1)
     2-XHYFLS(N,N6,N5,N4)
      TCAFLS(N3,N2,N1)=TCAFLS(N3,N2,N1)+XCAFLS(N,N3,N2,N1)
     2-XCAFLS(N,N6,N5,N4)
      TMGFLS(N3,N2,N1)=TMGFLS(N3,N2,N1)+XMGFLS(N,N3,N2,N1)
     2-XMGFLS(N,N6,N5,N4)
      TNAFLS(N3,N2,N1)=TNAFLS(N3,N2,N1)+XNAFLS(N,N3,N2,N1)
     2-XNAFLS(N,N6,N5,N4)
      TKAFLS(N3,N2,N1)=TKAFLS(N3,N2,N1)+XKAFLS(N,N3,N2,N1)
     2-XKAFLS(N,N6,N5,N4)
      TOHFLS(N3,N2,N1)=TOHFLS(N3,N2,N1)+XOHFLS(N,N3,N2,N1)
     2-XOHFLS(N,N6,N5,N4)
      TSOFLS(N3,N2,N1)=TSOFLS(N3,N2,N1)+XSOFLS(N,N3,N2,N1)
     2-XSOFLS(N,N6,N5,N4)
      TCLFLS(N3,N2,N1)=TCLFLS(N3,N2,N1)+XCLFLS(N,N3,N2,N1)
     2-XCLFLS(N,N6,N5,N4)
      TC3FLS(N3,N2,N1)=TC3FLS(N3,N2,N1)+XC3FLS(N,N3,N2,N1)
     2-XC3FLS(N,N6,N5,N4)
      THCFLS(N3,N2,N1)=THCFLS(N3,N2,N1)+XHCFLS(N,N3,N2,N1)
     2-XHCFLS(N,N6,N5,N4)
      TAL1FS(N3,N2,N1)=TAL1FS(N3,N2,N1)+XAL1FS(N,N3,N2,N1)
     2-XAL1FS(N,N6,N5,N4)
      TAL2FS(N3,N2,N1)=TAL2FS(N3,N2,N1)+XAL2FS(N,N3,N2,N1)
     2-XAL2FS(N,N6,N5,N4)
      TAL3FS(N3,N2,N1)=TAL3FS(N3,N2,N1)+XAL3FS(N,N3,N2,N1)
     2-XAL3FS(N,N6,N5,N4)
      TAL4FS(N3,N2,N1)=TAL4FS(N3,N2,N1)+XAL4FS(N,N3,N2,N1)
     2-XAL4FS(N,N6,N5,N4)
      TALSFS(N3,N2,N1)=TALSFS(N3,N2,N1)+XALSFS(N,N3,N2,N1)
     2-XALSFS(N,N6,N5,N4)
      TFE1FS(N3,N2,N1)=TFE1FS(N3,N2,N1)+XFE1FS(N,N3,N2,N1)
     2-XFE1FS(N,N6,N5,N4)
      TFE2FS(N3,N2,N1)=TFE2FS(N3,N2,N1)+XFE2FS(N,N3,N2,N1)
     2-XFE2FS(N,N6,N5,N4)
      TFE3FS(N3,N2,N1)=TFE3FS(N3,N2,N1)+XFE3FS(N,N3,N2,N1)
     2-XFE3FS(N,N6,N5,N4)
      TFE4FS(N3,N2,N1)=TFE4FS(N3,N2,N1)+XFE4FS(N,N3,N2,N1)
     2-XFE4FS(N,N6,N5,N4)
      TFESFS(N3,N2,N1)=TFESFS(N3,N2,N1)+XFESFS(N,N3,N2,N1)
     2-XFESFS(N,N6,N5,N4)
      TCAOFS(N3,N2,N1)=TCAOFS(N3,N2,N1)+XCAOFS(N,N3,N2,N1)
     2-XCAOFS(N,N6,N5,N4)
      TCACFS(N3,N2,N1)=TCACFS(N3,N2,N1)+XCACFS(N,N3,N2,N1)
     2-XCACFS(N,N6,N5,N4)
      TCAHFS(N3,N2,N1)=TCAHFS(N3,N2,N1)+XCAHFS(N,N3,N2,N1)
     2-XCAHFS(N,N6,N5,N4)
      TCASFS(N3,N2,N1)=TCASFS(N3,N2,N1)+XCASFS(N,N3,N2,N1)
     2-XCASFS(N,N6,N5,N4)
      TMGOFS(N3,N2,N1)=TMGOFS(N3,N2,N1)+XMGOFS(N,N3,N2,N1)
     2-XMGOFS(N,N6,N5,N4)
      TMGCFS(N3,N2,N1)=TMGCFS(N3,N2,N1)+XMGCFS(N,N3,N2,N1)
     2-XMGCFS(N,N6,N5,N4)
      TMGHFS(N3,N2,N1)=TMGHFS(N3,N2,N1)+XMGHFS(N,N3,N2,N1)
     2-XMGHFS(N,N6,N5,N4)
      TMGSFS(N3,N2,N1)=TMGSFS(N3,N2,N1)+XMGSFS(N,N3,N2,N1)
     2-XMGSFS(N,N6,N5,N4)
      TNACFS(N3,N2,N1)=TNACFS(N3,N2,N1)+XNACFS(N,N3,N2,N1)
     2-XNACFS(N,N6,N5,N4)
      TNASFS(N3,N2,N1)=TNASFS(N3,N2,N1)+XNASFS(N,N3,N2,N1)
     2-XNASFS(N,N6,N5,N4)
      TKASFS(N3,N2,N1)=TKASFS(N3,N2,N1)+XKASFS(N,N3,N2,N1)
     2-XKASFS(N,N6,N5,N4)
      TH0PFS(N3,N2,N1)=TH0PFS(N3,N2,N1)+XH0PFS(N,N3,N2,N1)
     2-XH0PFS(N,N6,N5,N4)
      TH1PFS(N3,N2,N1)=TH1PFS(N3,N2,N1)+XH1PFS(N,N3,N2,N1)
     2-XH1PFS(N,N6,N5,N4)
      TH3PFS(N3,N2,N1)=TH3PFS(N3,N2,N1)+XH3PFS(N,N3,N2,N1)
     2-XH3PFS(N,N6,N5,N4)
      TF1PFS(N3,N2,N1)=TF1PFS(N3,N2,N1)+XF1PFS(N,N3,N2,N1)
     2-XF1PFS(N,N6,N5,N4)
      TF2PFS(N3,N2,N1)=TF2PFS(N3,N2,N1)+XF2PFS(N,N3,N2,N1)
     2-XF2PFS(N,N6,N5,N4)
      TC0PFS(N3,N2,N1)=TC0PFS(N3,N2,N1)+XC0PFS(N,N3,N2,N1)
     2-XC0PFS(N,N6,N5,N4)
      TC1PFS(N3,N2,N1)=TC1PFS(N3,N2,N1)+XC1PFS(N,N3,N2,N1)
     2-XC1PFS(N,N6,N5,N4)
      TC2PFS(N3,N2,N1)=TC2PFS(N3,N2,N1)+XC2PFS(N,N3,N2,N1)
     2-XC2PFS(N,N6,N5,N4)
      TM1PFS(N3,N2,N1)=TM1PFS(N3,N2,N1)+XM1PFS(N,N3,N2,N1)
     2-XM1PFS(N,N6,N5,N4)
      TH0BFB(N3,N2,N1)=TH0BFB(N3,N2,N1)+XH0BFB(N,N3,N2,N1)
     2-XH0BFB(N,N6,N5,N4)
      TH1BFB(N3,N2,N1)=TH1BFB(N3,N2,N1)+XH1BFB(N,N3,N2,N1)
     2-XH1BFB(N,N6,N5,N4)
      TH3BFB(N3,N2,N1)=TH3BFB(N3,N2,N1)+XH3BFB(N,N3,N2,N1)
     2-XH3BFB(N,N6,N5,N4)
      TF1BFB(N3,N2,N1)=TF1BFB(N3,N2,N1)+XF1BFB(N,N3,N2,N1)
     2-XF1BFB(N,N6,N5,N4)
      TF2BFB(N3,N2,N1)=TF2BFB(N3,N2,N1)+XF2BFB(N,N3,N2,N1)
     2-XF2BFB(N,N6,N5,N4)
      TC0BFB(N3,N2,N1)=TC0BFB(N3,N2,N1)+XC0BFB(N,N3,N2,N1)
     2-XC0BFB(N,N6,N5,N4)
      TC1BFB(N3,N2,N1)=TC1BFB(N3,N2,N1)+XC1BFB(N,N3,N2,N1)
     2-XC1BFB(N,N6,N5,N4)
      TC2BFB(N3,N2,N1)=TC2BFB(N3,N2,N1)+XC2BFB(N,N3,N2,N1)
     2-XC2BFB(N,N6,N5,N4)
      TM1BFB(N3,N2,N1)=TM1BFB(N3,N2,N1)+XM1BFB(N,N3,N2,N1)
     2-XM1BFB(N,N6,N5,N4)
      TALFHS(N3,N2,N1)=TALFHS(N3,N2,N1)+XALFHS(N,N3,N2,N1)
     2-XALFHS(N,N6,N5,N4)
      TFEFHS(N3,N2,N1)=TFEFHS(N3,N2,N1)+XFEFHS(N,N3,N2,N1)
     2-XFEFHS(N,N6,N5,N4)
      THYFHS(N3,N2,N1)=THYFHS(N3,N2,N1)+XHYFHS(N,N3,N2,N1)
     2-XHYFHS(N,N6,N5,N4)
      TCAFHS(N3,N2,N1)=TCAFHS(N3,N2,N1)+XCAFHS(N,N3,N2,N1)
     2-XCAFHS(N,N6,N5,N4)
      TMGFHS(N3,N2,N1)=TMGFHS(N3,N2,N1)+XMGFHS(N,N3,N2,N1)
     2-XMGFHS(N,N6,N5,N4)
      TNAFHS(N3,N2,N1)=TNAFHS(N3,N2,N1)+XNAFHS(N,N3,N2,N1)
     2-XNAFHS(N,N6,N5,N4)
      TKAFHS(N3,N2,N1)=TKAFHS(N3,N2,N1)+XKAFHS(N,N3,N2,N1)
     2-XKAFHS(N,N6,N5,N4)
      TOHFHS(N3,N2,N1)=TOHFHS(N3,N2,N1)+XOHFHS(N,N3,N2,N1)
     2-XOHFHS(N,N6,N5,N4)
      TSOFHS(N3,N2,N1)=TSOFHS(N3,N2,N1)+XSOFHS(N,N3,N2,N1)
     2-XSOFHS(N,N6,N5,N4)
      TCLFHS(N3,N2,N1)=TCLFHS(N3,N2,N1)+XCLFHS(N,N3,N2,N1)
     2-XCLFHS(N,N6,N5,N4)
      TC3FHS(N3,N2,N1)=TC3FHS(N3,N2,N1)+XC3FHS(N,N3,N2,N1)
     2-XC3FHS(N,N6,N5,N4)
      THCFHS(N3,N2,N1)=THCFHS(N3,N2,N1)+XHCFHS(N,N3,N2,N1)
     2-XHCFHS(N,N6,N5,N4)
      TAL1HS(N3,N2,N1)=TAL1HS(N3,N2,N1)+XAL1HS(N,N3,N2,N1)
     2-XAL1HS(N,N6,N5,N4)
      TAL2HS(N3,N2,N1)=TAL2HS(N3,N2,N1)+XAL2HS(N,N3,N2,N1)
     2-XAL2HS(N,N6,N5,N4)
      TAL3HS(N3,N2,N1)=TAL3HS(N3,N2,N1)+XAL3HS(N,N3,N2,N1)
     2-XAL3HS(N,N6,N5,N4)
      TAL4HS(N3,N2,N1)=TAL4HS(N3,N2,N1)+XAL4HS(N,N3,N2,N1)
     2-XAL4HS(N,N6,N5,N4)
      TALSHS(N3,N2,N1)=TALSHS(N3,N2,N1)+XALSHS(N,N3,N2,N1)
     2-XALSHS(N,N6,N5,N4)
      TFE1HS(N3,N2,N1)=TFE1HS(N3,N2,N1)+XFE1HS(N,N3,N2,N1)
     2-XFE1HS(N,N6,N5,N4)
      TFE2HS(N3,N2,N1)=TFE2HS(N3,N2,N1)+XFE2HS(N,N3,N2,N1)
     2-XFE2HS(N,N6,N5,N4)
      TFE3HS(N3,N2,N1)=TFE3HS(N3,N2,N1)+XFE3HS(N,N3,N2,N1)
     2-XFE3HS(N,N6,N5,N4)
      TFE4HS(N3,N2,N1)=TFE4HS(N3,N2,N1)+XFE4HS(N,N3,N2,N1)
     2-XFE4HS(N,N6,N5,N4)
      TFESHS(N3,N2,N1)=TFESHS(N3,N2,N1)+XFESHS(N,N3,N2,N1)
     2-XFESHS(N,N6,N5,N4)
      TCAOHS(N3,N2,N1)=TCAOHS(N3,N2,N1)+XCAOHS(N,N3,N2,N1)
     2-XCAOHS(N,N6,N5,N4)
      TCACHS(N3,N2,N1)=TCACHS(N3,N2,N1)+XCACHS(N,N3,N2,N1)
     2-XCACHS(N,N6,N5,N4)
      TCAHHS(N3,N2,N1)=TCAHHS(N3,N2,N1)+XCAHHS(N,N3,N2,N1)
     2-XCAHHS(N,N6,N5,N4)
      TCASHS(N3,N2,N1)=TCASHS(N3,N2,N1)+XCASHS(N,N3,N2,N1)
     2-XCASHS(N,N6,N5,N4)
      TMGOHS(N3,N2,N1)=TMGOHS(N3,N2,N1)+XMGOHS(N,N3,N2,N1)
     2-XMGOHS(N,N6,N5,N4)
      TMGCHS(N3,N2,N1)=TMGCHS(N3,N2,N1)+XMGCHS(N,N3,N2,N1)
     2-XMGCHS(N,N6,N5,N4)
      TMGHHS(N3,N2,N1)=TMGHHS(N3,N2,N1)+XMGHHS(N,N3,N2,N1)
     2-XMGHHS(N,N6,N5,N4)
      TMGSHS(N3,N2,N1)=TMGSHS(N3,N2,N1)+XMGSHS(N,N3,N2,N1)
     2-XMGSHS(N,N6,N5,N4)
      TNACHS(N3,N2,N1)=TNACHS(N3,N2,N1)+XNACHS(N,N3,N2,N1)
     2-XNACHS(N,N6,N5,N4)
      TNASHS(N3,N2,N1)=TNASHS(N3,N2,N1)+XNASHS(N,N3,N2,N1)
     2-XNASHS(N,N6,N5,N4)
      TKASHS(N3,N2,N1)=TKASHS(N3,N2,N1)+XKASHS(N,N3,N2,N1)
     2-XKASHS(N,N6,N5,N4)
      TH0PHS(N3,N2,N1)=TH0PHS(N3,N2,N1)+XH0PHS(N,N3,N2,N1)
     2-XH0PHS(N,N6,N5,N4)
      TH1PHS(N3,N2,N1)=TH1PHS(N3,N2,N1)+XH1PHS(N,N3,N2,N1)
     2-XH1PHS(N,N6,N5,N4)
      TH3PHS(N3,N2,N1)=TH3PHS(N3,N2,N1)+XH3PHS(N,N3,N2,N1)
     2-XH3PHS(N,N6,N5,N4)
      TF1PHS(N3,N2,N1)=TF1PHS(N3,N2,N1)+XF1PHS(N,N3,N2,N1)
     2-XF1PHS(N,N6,N5,N4)
      TF2PHS(N3,N2,N1)=TF2PHS(N3,N2,N1)+XF2PHS(N,N3,N2,N1)
     2-XF2PHS(N,N6,N5,N4)
      TC0PHS(N3,N2,N1)=TC0PHS(N3,N2,N1)+XC0PHS(N,N3,N2,N1)
     2-XC0PHS(N,N6,N5,N4)
      TC1PHS(N3,N2,N1)=TC1PHS(N3,N2,N1)+XC1PHS(N,N3,N2,N1)
     2-XC1PHS(N,N6,N5,N4)
      TC2PHS(N3,N2,N1)=TC2PHS(N3,N2,N1)+XC2PHS(N,N3,N2,N1)
     2-XC2PHS(N,N6,N5,N4)
      TM1PHS(N3,N2,N1)=TM1PHS(N3,N2,N1)+XM1PHS(N,N3,N2,N1)
     2-XM1PHS(N,N6,N5,N4)
      TH0BHB(N3,N2,N1)=TH0BHB(N3,N2,N1)+XH0BHB(N,N3,N2,N1)
     2-XH0BHB(N,N6,N5,N4)
      TH1BHB(N3,N2,N1)=TH1BHB(N3,N2,N1)+XH1BHB(N,N3,N2,N1)
     2-XH1BHB(N,N6,N5,N4)
      TH3BHB(N3,N2,N1)=TH3BHB(N3,N2,N1)+XH3BHB(N,N3,N2,N1)
     2-XH3BHB(N,N6,N5,N4)
      TF1BHB(N3,N2,N1)=TF1BHB(N3,N2,N1)+XF1BHB(N,N3,N2,N1)
     2-XF1BHB(N,N6,N5,N4)
      TF2BHB(N3,N2,N1)=TF2BHB(N3,N2,N1)+XF2BHB(N,N3,N2,N1)
     2-XF2BHB(N,N6,N5,N4)
      TC0BHB(N3,N2,N1)=TC0BHB(N3,N2,N1)+XC0BHB(N,N3,N2,N1)
     2-XC0BHB(N,N6,N5,N4)
      TC1BHB(N3,N2,N1)=TC1BHB(N3,N2,N1)+XC1BHB(N,N3,N2,N1)
     2-XC1BHB(N,N6,N5,N4)
      TC2BHB(N3,N2,N1)=TC2BHB(N3,N2,N1)+XC2BHB(N,N3,N2,N1)
     2-XC2BHB(N,N6,N5,N4)
      TM1BHB(N3,N2,N1)=TM1BHB(N3,N2,N1)+XM1BHB(N,N3,N2,N1)
     2-XM1BHB(N,N6,N5,N4)
      ENDIF
      ENDIF
8580  CONTINUE
8575  CONTINUE
C
C     CALCULATE SURFACE RESIDUE TEMPERATURE FROM ITS CHANGE
C     IN HEAT STORAGE
C
      HFLXD=2.496E-06*(OSGX-ORGC(0,NY,NX))*TKS(0,NY,NX)
      VOLW(0,NY,NX)=VOLW(0,NY,NX)+FLWR(NY,NX)+THAWR(NY,NX)
     2+TQR(NY,NX)+18.0E-06*TRH2O(0,NY,NX)
      VOLI(0,NY,NX)=VOLI(0,NY,NX)-THAWR(NY,NX)/0.92
      ENGYR=VHCPR(NY,NX)*TKS(0,NY,NX)-HFLXD
      VHCPR(NY,NX)=2.496E-06*ORGC(0,NY,NX)+4.19*VOLW(0,NY,NX)
     2+1.9274*VOLI(0,NY,NX)
      IF(VHCPR(NY,NX).GT.ZEROS(NY,NX))THEN
      TKS(0,NY,NX)=(ENGYR+HFLWR(NY,NX)+HTHAWR(NY,NX)
     2+THQR(NY,NX))/VHCPR(NY,NX)
      ELSE
      TKS(0,NY,NX)=TKS(NU(NY,NX),NY,NX)
      ENDIF
      IF(VHCPR(NY,NX).LT.VHCPRX(NY,NX))THEN
      HFLXR=VHCPR(NY,NX)*(TKS(0,NY,NX)-TKS(NU(NY,NX),NY,NX))
      HEATOU=HEATOU+HFLXR
      TKS(0,NY,NX)=TKS(NU(NY,NX),NY,NX)
      ENDIF
      HEATIN=HEATIN+HTHAWR(NY,NX)-HFLXD
C     UVOLW(NY,NX)=UVOLW(NY,NX)-VOLW(0,NY,NX)-VOLI(0,NY,NX)*0.92
C
C     SURFACE BOUNDARY WATER FLUXES
C
      WI=PRECQ(NY,NX)+PRECI(NY,NX)
      CRAIN=CRAIN+WI
      URAIN(NY,NX)=URAIN(NY,NX)+WI
      WO=TEVAPG(NY,NX)+TEVAPP(NY,NX)
      CEVAP=CEVAP-WO
      UEVAP(NY,NX)=UEVAP(NY,NX)-WO
      VOLWOU=VOLWOU-PRECU(NY,NX)-18.0E-06*TRH2O(0,NY,NX)
      HVOLO(NY,NX)=HVOLO(NY,NX)-PRECU(NY,NX)
      UVOLO(NY,NX)=UVOLO(NY,NX)-PRECU(NY,NX)
      UDRAIN(NY,NX)=UDRAIN(NY,NX)+FLW(3,NK(NY,NX),NY,NX)
C
C     SURFACE BOUNDARY HEAT FLUXES
C
      HEATIN=HEATIN+4.19*TKA(NY,NX)*PRECA(NY,NX)
     2+2.095*TKA(NY,NX)*PRECW(NY,NX)
      HEATIN=HEATIN+HEATH(NY,NX)+HTHAWW(NY,NX)+THFLXC(NY,NX)
      HEATOU=HEATOU-4.19*TKA(NY,NX)*PRECU(NY,NX)
C     WRITE(*,5151)'TK0',I,J,NX,NY,TKS(0,NY,NX),ENGYR 
C    2,HFLWR(NY,NX),HFLXD,HTHAWR(NY,NX),VHCPR(NY,NX),VOLW(0,NY,NX) 
C    3,VOLI(0,NY,NX),FLWR(NY,NX),THAWR(NY,NX),TRH2O(0,NY,NX)
C    3,ORGC(0,NY,NX),VHCPR(NY,NX)*TKS(0,NY,NX),TQR(NY,NX)
C    4,THQR(NY,NX),HEATH(NY,NX),HTHAWW(NY,NX),THFLXC(NY,NX),HEATIN
5151  FORMAT(A8,4I4,30F20.6)
C
C     SURFACE BOUNDARY CO2, CH4 AND DOC FLUXES
C
      CI=XCODFS(NY,NX)+XCOFLG(3,NU(NY,NX),NY,NX)+TCO2Z(NY,NX)
     2+(FLQGQ(NY,NX)+FLQRQ(NY,NX))*CCOR(NY,NX)
     3+(FLQGI(NY,NX)+FLQRI(NY,NX))*CCOQ(NY,NX)
     4+XCODFG(0,NY,NX)+XCODFR(NY,NX)
      CH=XCHDFS(NY,NX)+XCHFLG(3,NU(NY,NX),NY,NX)+TCH4Z(NY,NX)
     2+(FLQGQ(NY,NX)+FLQRQ(NY,NX))*CCHR(NY,NX)
     3+(FLQGI(NY,NX)+FLQRI(NY,NX))*CCHQ(NY,NX)
     4+XCHDFG(0,NY,NX)+XCHDFR(NY,NX) 
      CO=-PRECU(NY,NX)*CCOQ(NY,NX)
      CX=-PRECU(NY,NX)*CCHQ(NY,NX)
      UCO2G(NY,NX)=UCO2G(NY,NX)+CI
      HCO2G(NY,NX)=HCO2G(NY,NX)+CI
      UCH4G(NY,NX)=UCH4G(NY,NX)+CH
      HCH4G(NY,NX)=HCH4G(NY,NX)+CH
      CO2GIN=CO2GIN+CI+CH
      TCOU=TCOU+CO+CX
      TNBP(NY,NX)=TNBP(NY,NX)+CH
C     IF(NX.EQ.3.AND.NY.EQ.3)THEN
C     WRITE(*,6644)'CO2',I,J,NX,NY,HCO2G(NY,NX),CI,XCODFS(NY,NX)
C    2,XCOFLG(3,NU(NY,NX),NY,NX),TCO2Z(NY,NX),FLQGQ(NY,NX)*CCOR(NY,NX)
C    3,XCODFG(0,NY,NX),PRECU(NY,NX),CCOQ(NY,NX),CCHQ(NY,NX),CO,CX,TCOU 
C    4,CO2S(NU(NY,NX),NY,NX)
C     WRITE(*,6644)'CH4',I,J,NX,NY,CH,XCHDFS(NY,NX)
C    2,XCHFLG(3,NU(NY,NX),NY,NX),TCH4Z(NY,NX),FLQGQ(NY,NX)
C    3,FLQRQ(NY,NX),FLQGI(NY,NX),FLQRI(NY,NX),CCHR(NY,NX),CCHQ(NY,NX)
C    4,XCHDFG(0,NY,NX),XCHDFR(NY,NX),CH4S(NU(NY,NX),NY,NX)
6644  FORMAT(A8,4I4,30E12.4)
C     ENDIF
C
C     SURFACE BOUNDARY O2 FLUXES
C
      OI=XOXDFS(NY,NX)+XOXFLG(3,NU(NY,NX),NY,NX)+TOXYZ(NY,NX)
     2+(FLQGQ(NY,NX)+FLQRQ(NY,NX))*COXR(NY,NX)
     3+(FLQGI(NY,NX)+FLQRI(NY,NX))*COXQ(NY,NX)
     4+XOXDFG(0,NY,NX)+XOXDFR(NY,NX) 
      OO=RUPOXO(0,NY,NX)-PRECU(NY,NX)*COXQ(NY,NX) 
      UOXYG(NY,NX)=UOXYG(NY,NX)+OI
      HOXYG(NY,NX)=HOXYG(NY,NX)+OI
      OXYGIN=OXYGIN+OI
      OXYGOU=OXYGOU+OO
C     IF(NX.EQ.2.AND.NY.EQ.1)THEN
C     WRITE(*,6646)'UOXYG',I,J,NX,NY,UCO2G(NY,NX),UOXYG(NY,NX),CI,OI
C    2,XCODFS(NY,NX),XCOFLG(3,NU(NY,NX),NY,NX),TCO2Z(NY,NX)
C    2,(FLQGQ(NY,NX)+FLQRQ(NY,NX))*CCOR(NY,NX)
C    3,(FLQGI(NY,NX)+FLQRI(NY,NX))*CCOQ(NY,NX)
C    4,XCODFG(0,NY,NX),XCODFR(NY,NX)
C    5,XOXDFS(NY,NX),XOXFLG(3,NU(NY,NX),NY,NX),TOXYZ(NY,NX)
C    2,(FLQGQ(NY,NX)+FLQRQ(NY,NX))*COXR(NY,NX)
C    3,(FLQGI(NY,NX)+FLQRI(NY,NX))*COXQ(NY,NX)
C    4,XOXDFG(0,NY,NX)+XOXDFR(NY,NX)
C    5,(TLCO2P(L,NY,NX),L=1,10),(TLOXYP(L,NY,NX),L=1,10) 
6646  FORMAT(A8,4I4,60E12.4)
C     ENDIF
C
C     SURFACE BOUNDARY N2, N2O, NH3, NH4, NO3, AND DON FLUXES
C
      ZN2GIN=ZN2GIN+XNGDFS(NY,NX)+XN2DFS(NY,NX)+XN3DFS(NY,NX)
     2+XNBDFS(NY,NX)+XNGFLG(3,NU(NY,NX),NY,NX)+XN2FLG(3,NU(NY,NX),NY,NX)
     3+XN3FLG(3,NU(NY,NX),NY,NX)+TN2OZ(NY,NX)+TNH3Z(NY,NX)
     4+(FLQGQ(NY,NX)+FLQRQ(NY,NX))*(CNNR(NY,NX)+CN2R(NY,NX))
     5+(FLQGI(NY,NX)+FLQRI(NY,NX))*(CNNQ(NY,NX)+CN2Q(NY,NX))
     6+XN2DFG(0,NY,NX)+XNGDFG(0,NY,NX)+XN3DFG(0,NY,NX)
     7+XNGDFR(NY,NX)+XN2DFR(NY,NX)+XN3DFR(NY,NX) 
      TZIN=TZIN+((FLQGQ(NY,NX)+FLQRQ(NY,NX))
     2*(CN4R(NY,NX)+CN3R(NY,NX)+CNOR(NY,NX))
     3+(FLQGI(NY,NX)+FLQRI(NY,NX))*(CN4Q(I,NY,NX)+CN3Q(I,NY,NX)
     4+CNOQ(I,NY,NX)))*14.0
      TZOU=TZOU-PRECU(NY,NX)*(CNNQ(NY,NX)+CN2Q(NY,NX))-PRECU(NY,NX)
     2*(CN4Q(I,NY,NX)+CN3Q(I,NY,NX)+CNOQ(I,NY,NX))*14.0
      ZDRAIN(NY,NX)=ZDRAIN(NY,NX)+XN4FLW(3,NK(NY,NX),NY,NX)
     2+XN3FLW(3,NK(NY,NX),NY,NX)+XNOFLW(3,NK(NY,NX),NY,NX)
     3+XNXFLS(3,NK(NY,NX),NY,NX)+XN4FLB(3,NK(NY,NX),NY,NX)
     4+XN3FLB(3,NK(NY,NX),NY,NX)+XNOFLB(3,NK(NY,NX),NY,NX)
     5+XNXFLB(3,NK(NY,NX),NY,NX)
      ZNGGIN=XNGDFS(NY,NX)+XNGFLG(3,NU(NY,NX),NY,NX)+XNGDFG(0,NY,NX)
      ZN2OIN=XN2DFS(NY,NX)+XN2FLG(3,NU(NY,NX),NY,NX)+XN2DFG(0,NY,NX)
      ZNH3IN=XN3DFS(NY,NX)+XNBDFS(NY,NX)+XN3FLG(3,NU(NY,NX),NY,NX)
     2+XN3DFG(0,NY,NX)
      TI=XHGDFS(NY,NX)+XHGFLG(3,NU(NY,NX),NY,NX)+TH2GZ(NY,NX)
     2+XHGDFG(0,NY,NX)+XHGDFR(NY,NX)
C     UN2GG(NY,NX)=UN2GG(NY,NX)+ZNGGIN
C     HN2GG(NY,NX)=HN2GG(NY,NX)+ZNGGIN
      UN2OG(NY,NX)=UN2OG(NY,NX)+ZN2OIN
      HN2OG(NY,NX)=HN2OG(NY,NX)+ZN2OIN
      UNH3G(NY,NX)=UNH3G(NY,NX)+ZNH3IN
      HNH3G(NY,NX)=HNH3G(NY,NX)+ZNH3IN
      UN2GS(NY,NX)=UN2GS(NY,NX)+XN2GS(0,NY,NX)
      UH2GG(NY,NX)=UH2GG(NY,NX)+TI 
C     WRITE(*,6644)'HNH3G',I,J,NX,NY,HNH3G(NY,NX),ZNH3IN
C    2,XN3DFS(NY,NX),XNBDFS(NY,NX),XN3FLG(3,NU(NY,NX),NY,NX)
C    2,XN3DFG(0,NY,NX)
C     WRITE(*,6644)'ZN2GIN',I,J,NX,NY,ZN2GIN,XNGDFS(NY,NX)
C    3,XN2DFS(NY,NX),XN3DFS(NY,NX)
C    2,XNBDFS(NY,NX),XNGFLG(3,NU(NY,NX),NY,NX),XN2FLG(3,NU(NY,NX),NY,NX)
C    3,XN3FLG(3,NU(NY,NX),NY,NX),TN2OZ(NY,NX),TNH3Z(NY,NX)
C    4,(FLQGQ(NY,NX)+FLQRQ(NY,NX))*(CNNR(NY,NX)+CN2R(NY,NX))
C    5,(FLQGI(NY,NX)+FLQRI(NY,NX))*(CNNQ(NY,NX)+CN2Q(NY,NX))
C    6,XN2DFG(0,NY,NX)+XNGDFG(0,NY,NX),XN3DFG(0,NY,NX)
C    7,XNGDFR(NY,NX)+XN2DFR(NY,NX),XN3DFR(NY,NX) 
C
C     SURFACE BOUNDARY PO4 AND DOP FLUXES
C
      TPIN=TPIN+((FLQGQ(NY,NX)+FLQRQ(NY,NX))*CPOR(NY,NX)
     2+(FLQGI(NY,NX)+FLQRI(NY,NX))*CPOQ(I,NY,NX))*31.0
      TPOU=TPOU-PRECU(NY,NX)*CPOQ(I,NY,NX)*31.0
      PDRAIN(NY,NX)=PDRAIN(NY,NX)+XH2PFS(3,NK(NY,NX),NY,NX)
     2+XH2BFB(3,NK(NY,NX),NY,NX)
C
C     SURFACE BOUNDARY ION FLUXES
C
      TZOU=TZOU-14.0*(TBNH4(0,NY,NX)+TBNO3(0,NY,NX)+TBNH3(0,NY,NX))
      TPOU=TPOU-31.0*TBH2P(0,NY,NX)
      TO=2.0*TRH2O(0,NY,NX)+2.0*TBNH4(0,NY,NX)
     2+TBNH3(0,NY,NX)+TBNO3(0,NY,NX)+3.0*TBH2P(0,NY,NX)
     3+RH2GO(0,NY,NX)+TBION(0,NY,NX)
      TIONIN=TIONIN+TI
      TIONOU=TIONOU+TO
C     UIONOU(NY,NX)=UIONOU(NY,NX)+TO
C
C     ACCUMULATE PLANT LITTERFALL FLUXES
C
      XCSN=XCSN+ZCSNC(NY,NX)
      XZSN=XZSN+ZZSNC(NY,NX)
      XPSN=XPSN+ZPSNC(NY,NX)
      UXCSN(NY,NX)=UXCSN(NY,NX)+ZCSNC(NY,NX)
      UXZSN(NY,NX)=UXZSN(NY,NX)+ZZSNC(NY,NX)
      UXPSN(NY,NX)=UXPSN(NY,NX)+ZPSNC(NY,NX)
C
C     SURFACE BOUNDARY SALT FLUXES FROM RAINFALL AND SURFACE IRRIGATION
C
      IF(ISALT(NY,NX).NE.0)THEN
      SR=PRECQ(NY,NX)*(CALR(NY,NX)+CFER(NY,NX)+CHYR(NY,NX)+CCAR(NY,NX)
     2+CMGR(NY,NX)+CNAR(NY,NX)+CKAR(NY,NX)+COHR(NY,NX)+CSOR(NY,NX)
     3+CCLR(NY,NX)+CC3R(NY,NX)+CH0PR(NY,NX)
     4+2.0*(CHCR(NY,NX)+CAL1R(NY,NX)+CALSR(NY,NX)+CFE1R(NY,NX)
     5+CFESR(NY,NX)+CCAOR(NY,NX)+CCACR(NY,NX)+CCASR(NY,NX)+CMGOR(NY,NX)
     6+CMGCR(NY,NX)+CMGSR(NY,NX)+CNACR(NY,NX)+CNASR(NY,NX)
     7+CKASR(NY,NX)+CH1PR(NY,NX)+CC0PR(NY,NX))
     8+3.0*(CAL2R(NY,NX)+CFE2R(NY,NX)+CCAHR(NY,NX)+CMGHR(NY,NX)
     9+CF1PR(NY,NX)+CC1PR(NY,NX)+CM1PR(NY,NX))
     1+4.0*(CAL3R(NY,NX)+CFE3R(NY,NX)+CH3PR(NY,NX)+CF2PR(NY,NX)
     2+CC2PR(NY,NX))
     3+5.0*(CAL4R(NY,NX)+CFE4R(NY,NX)))
      SI=PRECI(NY,NX)*(CALQ(I,NY,NX)+CFEQ(I,NY,NX)+CHYQ(I,NY,NX)
     2+CCAQ(I,NY,NX)+CMGQ(I,NY,NX)+CNAQ(I,NY,NX)+CKAQ(I,NY,NX)
     3+COHQ(I,NY,NX)+CSOQ(I,NY,NX)+CCLQ(I,NY,NX)+CC3Q(I,NY,NX)
     4+CH0PQ(I,NY,NX)+2.0*(CHCQ(I,NY,NX)+CAL1Q(I,NY,NX)+CALSQ(I,NY,NX)
     5+CFE1Q(I,NY,NX)+CFESQ(I,NY,NX)+CCAOQ(I,NY,NX)+CCACQ(I,NY,NX)
     6+CCASQ(I,NY,NX)+CMGOQ(I,NY,NX)+CMGCQ(I,NY,NX)+CMGSQ(I,NY,NX)
     7+CNACQ(I,NY,NX)+CNASQ(I,NY,NX)+CKASQ(I,NY,NX)+CH1PQ(I,NY,NX)
     8+CC0PQ(I,NY,NX))+3.0*(CAL2Q(I,NY,NX)+CFE2Q(I,NY,NX)
     9+CCAHQ(I,NY,NX)+CMGHQ(I,NY,NX)+CF1PQ(I,NY,NX)+CC1PQ(I,NY,NX)
     1+CM1PQ(I,NY,NX))+4.0*(CAL3Q(I,NY,NX)+CFE3Q(I,NY,NX)
     2+CH3PQ(I,NY,NX)+CF2PQ(I,NY,NX)+CC2PQ(I,NY,NX))
     3+5.0*(CAL4Q(I,NY,NX)+CFE4Q(I,NY,NX)))
      TIONIN=TIONIN+SR+SI
C
C     SUBSURFACE BOUNDARY SALT FLUXES FROM SUBSURFACE IRRIGATION
C
      SI=PRECU(NY,NX)*(CALQ(I,NY,NX)+CFEQ(I,NY,NX)+CHYQ(I,NY,NX)
     2+CCAQ(I,NY,NX)+CMGQ(I,NY,NX)+CNAQ(I,NY,NX)+CKAQ(I,NY,NX)
     3+COHQ(I,NY,NX)+CSOQ(I,NY,NX)+CCLQ(I,NY,NX)+CC3Q(I,NY,NX)
     4+CH0PQ(I,NY,NX)+2.0*(CHCQ(I,NY,NX)+CAL1Q(I,NY,NX)+CALSQ(I,NY,NX)
     5+CFE1Q(I,NY,NX)+CFESQ(I,NY,NX)+CCAOQ(I,NY,NX)+CCACQ(I,NY,NX)
     6+CCASQ(I,NY,NX)+CMGOQ(I,NY,NX)+CMGCQ(I,NY,NX)+CMGSQ(I,NY,NX)
     7+CNACQ(I,NY,NX)+CNASQ(I,NY,NX)+CKASQ(I,NY,NX)+CH1PQ(I,NY,NX)
     8+CC0PQ(I,NY,NX))+3.0*(CAL2Q(I,NY,NX)+CFE2Q(I,NY,NX)
     9+CCAHQ(I,NY,NX)+CMGHQ(I,NY,NX)+CF1PQ(I,NY,NX)+CC1PQ(I,NY,NX)
     1+CM1PQ(I,NY,NX))+4.0*(CAL3Q(I,NY,NX)+CFE3Q(I,NY,NX)
     2+CH3PQ(I,NY,NX)+CF2PQ(I,NY,NX)+CC2PQ(I,NY,NX))
     3+5.0*(CAL4Q(I,NY,NX)+CFE4Q(I,NY,NX)))
      TIONIN=TIONIN+SI
      ENDIF
C
C     GAS EXCHANGE FROM SURFACE VOLATILIZATION-DISSOLUTION
C
      DO 9680 K=0,2
      OQC(K,0,NY,NX)=OQC(K,0,NY,NX)+XOCFLS(K,3,0,NY,NX)
      OQN(K,0,NY,NX)=OQN(K,0,NY,NX)+XONFLS(K,3,0,NY,NX)
      OQP(K,0,NY,NX)=OQP(K,0,NY,NX)+XOPFLS(K,3,0,NY,NX)
      OQA(K,0,NY,NX)=OQA(K,0,NY,NX)+XOAFLS(K,3,0,NY,NX)
9680  CONTINUE
      CO2S(0,NY,NX)=CO2S(0,NY,NX)+XCODFR(NY,NX)+XCOFLS(3,0,NY,NX)
     2+XCODFG(0,NY,NX)-RCO2O(0,NY,NX)
      CH4S(0,NY,NX)=CH4S(0,NY,NX)+XCHDFR(NY,NX)+XCHFLS(3,0,NY,NX)
     2+XCHDFG(0,NY,NX)-RCH4O(0,NY,NX)
      OXYS(0,NY,NX)=OXYS(0,NY,NX)+XOXDFR(NY,NX)+XOXFLS(3,0,NY,NX)
     2+XOXDFG(0,NY,NX)-RUPOXO(0,NY,NX)
      Z2GS(0,NY,NX)=Z2GS(0,NY,NX)+XNGDFR(NY,NX)+XNGFLS(3,0,NY,NX)
     2+XNGDFG(0,NY,NX)-RN2G(0,NY,NX)-XN2GS(0,NY,NX)
      Z2OS(0,NY,NX)=Z2OS(0,NY,NX)+XN2DFR(NY,NX)+XN2FLS(3,0,NY,NX)
     2+XN2DFG(0,NY,NX)-RN2O(0,NY,NX)
      H2GS(0,NY,NX)=H2GS(0,NY,NX)+XHGDFR(NY,NX)+XHGFLS(3,0,NY,NX)
     2+XHGDFG(0,NY,NX)-RH2GO(0,NY,NX)
      ZNH4S(0,NY,NX)=ZNH4S(0,NY,NX)+XN4FLW(3,0,NY,NX)
     2+XNH4S(0,NY,NX)+TRN4S(0,NY,NX)+XN34SQ(0,NY,NX)
      ZNH3S(0,NY,NX)=ZNH3S(0,NY,NX)+XN3DFR(NY,NX)+XN3FLW(3,0,NY,NX)
     2+XN3DFG(0,NY,NX)+TRN3S(0,NY,NX)-XN34SQ(0,NY,NX)
      ZNO3S(0,NY,NX)=ZNO3S(0,NY,NX)+XNOFLW(3,0,NY,NX)
     2+XNO3S(0,NY,NX)+TRNO3(0,NY,NX)
      ZNO2S(0,NY,NX)=ZNO2S(0,NY,NX)+XNXFLS(3,0,NY,NX)
     2+XNO2S(0,NY,NX)
      H2PO4(0,NY,NX)=H2PO4(0,NY,NX)+XH2PFS(3,0,NY,NX)
     2+XH2PS(0,NY,NX)+TRH2P(0,NY,NX)
      CO2S(NU(NY,NX),NY,NX)=CO2S(NU(NY,NX),NY,NX)+XCODFS(NY,NX)
      CH4S(NU(NY,NX),NY,NX)=CH4S(NU(NY,NX),NY,NX)+XCHDFS(NY,NX)
      OXYS(NU(NY,NX),NY,NX)=OXYS(NU(NY,NX),NY,NX)+XOXDFS(NY,NX)
      Z2GS(NU(NY,NX),NY,NX)=Z2GS(NU(NY,NX),NY,NX)+XNGDFS(NY,NX)
      Z2OS(NU(NY,NX),NY,NX)=Z2OS(NU(NY,NX),NY,NX)+XN2DFS(NY,NX)
      ZNH3S(NU(NY,NX),NY,NX)=ZNH3S(NU(NY,NX),NY,NX)+XN3DFS(NY,NX)
      ZNH3B(NU(NY,NX),NY,NX)=ZNH3B(NU(NY,NX),NY,NX)+XNBDFS(NY,NX)
      H2GS(NU(NY,NX),NY,NX)=H2GS(NU(NY,NX),NY,NX)+XHGDFS(NY,NX)
      SED(NY,NX)=SED(NY,NX)+XDTSED(NY,NX)
      THRE(NY,NX)=THRE(NY,NX)+RCO2O(0,NY,NX)
      UN2GG(NY,NX)=UN2GG(NY,NX)+RN2G(0,NY,NX)
      HN2GG(NY,NX)=HN2GG(NY,NX)+RN2G(0,NY,NX)
      ROXYF(0,NY,NX)=XOXDFG(0,NY,NX)
      RCO2F(0,NY,NX)=XCODFG(0,NY,NX)
      RCH4F(0,NY,NX)=XCHDFG(0,NY,NX)
      ROXYL(0,NY,NX)=XOXDFR(NY,NX)+XOXFLS(3,0,NY,NX)
     2-(FLQRQ(NY,NX)*COXR(NY,NX)+FLQRI(NY,NX)*COXQ(NY,NX))
      RCH4L(0,NY,NX)=XCHDFR(NY,NX)+XCHFLS(3,0,NY,NX)
     2-(FLQRQ(NY,NX)*CCHR(NY,NX)+FLQRI(NY,NX)*CCHQ(NY,NX)) 
      ROXYL(NU(NY,NX),NY,NX)=ROXYL(NU(NY,NX),NY,NX)+XOXDFS(NY,NX)
      RCH4L(NU(NY,NX),NY,NX)=RCH4L(NU(NY,NX),NY,NX)+XCHDFS(NY,NX)
C     IF(I.EQ.118.AND.NX.EQ.3.AND.NY.EQ.4)THEN
C     WRITE(*,1119)'CO2S0',I,J,NX,NY,CO2S(0,NY,NX),XCODFS(NY,NX)
C    2,XCODFR(NY,NX),XCOFLS(3,0,NY,NX),XCODFG(0,NY,NX),RCO2O(0,NY,NX)
C    3,ORGC(0,NY,NX)
C     WRITE(*,1119)'CH4S0',I,J,NX,NY,CH4S(0,NY,NX),XCHDFS(NY,NX)
C    2,XCHDFR(NY,NX),XCHFLS(3,0,NY,NX),RCH4O(0,NY,NX),XCHDFG(0,NY,NX)
C    3,RCH4L(0,NY,NX)
C     WRITE(*,1119)'OXYS0',I,J,NX,NY,OXYS(0,NY,NX),XOXDFR(NY,NX) 
C    2,XOXFLS(3,0,NY,NX),XOXDFG(0,NY,NX),RUPOXO(0,NY,NX)
C    3,ROXYL(0,NY,NX),TOXQRS(NY,NX)
1119  FORMAT(A8,4I4,12E12.4)
C    ENDIF
C     IF(NX.EQ.5)THEN
C     WRITE(*,5533)'ZNH4S0',I,J,NX,NY,ZNH4S(0,NY,NX),XN4FLW(3,0,NY,NX)
C    2,XNH4S(0,NY,NX),XN3FLW(3,0,NY,NX),TRN4S(0,NY,NX)
C    3,ZNH3S(0,NY,NX),TRN3S(0,NY,NX),XN3DFG(0,NY,NX),XN34SQ(0,NY,NX)
C    4,ZNHUFA(0,NY,NX),XNO2S(0,NY,NX),XN4(0,NY,NX)*14.0
C     WRITE(*,5533)'ZNO3S0',I,J,NX,NY,ZNO3S(0,NY,NX),XNOFLW(3,0,NY,NX)
C    2,XNO3S(0,NY,NX),TRNO3(0,NY,NX),ZNO2S(0,NY,NX),XNXFLS(3,0,NY,NX)
C    3,XNO2S(0,NY,NX)
C     WRITE(*,5533)'H2PO40',I,J,NX,NY,H2PO4(0,NY,NX)
C    2,XH2PFS(3,0,NY,NX),XH2PS(0,NY,NX),TRH2P(0,NY,NX)
5533  FORMAT(A8,4I4,20E12.4)
C     ENDIF
C
C     OVERLAND FLOW
C
      IF(TQR(NY,NX).NE.0.0)THEN
C
C     DOC, DON, DOP
C
      DO 8570 K=0,2
      OQC(K,0,NY,NX)=OQC(K,0,NY,NX)+TOCQRS(K,NY,NX)
      OQN(K,0,NY,NX)=OQN(K,0,NY,NX)+TONQRS(K,NY,NX)
      OQP(K,0,NY,NX)=OQP(K,0,NY,NX)+TOPQRS(K,NY,NX)
      OQA(K,0,NY,NX)=OQA(K,0,NY,NX)+TOAQRS(K,NY,NX)
8570  CONTINUE
C
C     SOLUTES
C
      CO2S(0,NY,NX)=CO2S(0,NY,NX)+TCOQRS(NY,NX)
      CH4S(0,NY,NX)=CH4S(0,NY,NX)+TCHQRS(NY,NX)
      OXYS(0,NY,NX)=OXYS(0,NY,NX)+TOXQRS(NY,NX)
      Z2GS(0,NY,NX)=Z2GS(0,NY,NX)+TNGQRS(NY,NX)
      Z2OS(0,NY,NX)=Z2OS(0,NY,NX)+TN2QRS(NY,NX)
      H2GS(0,NY,NX)=H2GS(0,NY,NX)+THGQRS(NY,NX)
      ZNH4S(0,NY,NX)=ZNH4S(0,NY,NX)+TN4QRS(NY,NX)
      ZNH3S(0,NY,NX)=ZNH3S(0,NY,NX)+TN3QRS(NY,NX)
      ZNO3S(0,NY,NX)=ZNO3S(0,NY,NX)+TNOQRS(NY,NX)
      ZNO2S(0,NY,NX)=ZNO2S(0,NY,NX)+TNXQRS(NY,NX)
      H2PO4(0,NY,NX)=H2PO4(0,NY,NX)+TPOQRS(NY,NX)
      IF(ISALT(NY,NX).NE.0)THEN
      ZAL(0,NY,NX)=ZAL(0,NY,NX)+TQRAL(NY,NX)
      ZFE(0,NY,NX)=ZFE(0,NY,NX)+TQRFE(NY,NX)
      ZHY(0,NY,NX)=ZHY(0,NY,NX)+TQRHY(NY,NX)
      ZCA(0,NY,NX)=ZCA(0,NY,NX)+TQRCA(NY,NX)
      ZMG(0,NY,NX)=ZMG(0,NY,NX)+TQRMG(NY,NX)
      ZNA(0,NY,NX)=ZNA(0,NY,NX)+TQRNA(NY,NX)
      ZKA(0,NY,NX)=ZKA(0,NY,NX)+TQRKA(NY,NX)
      ZOH(0,NY,NX)=ZOH(0,NY,NX)+TQROH(NY,NX)
      ZSO4(0,NY,NX)=ZSO4(0,NY,NX)+TQRSO(NY,NX)
      ZCL(0,NY,NX)=ZCL(0,NY,NX)+TQRCL(NY,NX)
      ZCO3(0,NY,NX)=ZCO3(0,NY,NX)+TQRC3(NY,NX)
      ZHCO3(0,NY,NX)=ZHCO3(0,NY,NX)+TQRHC(NY,NX)
      ZALOH1(0,NY,NX)=ZALOH1(0,NY,NX)+TQRAL1(NY,NX)
      ZALOH2(0,NY,NX)=ZALOH2(0,NY,NX)+TQRAL2(NY,NX)
      ZALOH3(0,NY,NX)=ZALOH3(0,NY,NX)+TQRAL3(NY,NX)
      ZALOH4(0,NY,NX)=ZALOH4(0,NY,NX)+TQRAL4(NY,NX)
      ZALS(0,NY,NX)=ZALS(0,NY,NX)+TQRALS(NY,NX)
      ZFEOH1(0,NY,NX)=ZFEOH1(0,NY,NX)+TQRFE1(NY,NX)
      ZFEOH2(0,NY,NX)=ZFEOH2(0,NY,NX)+TQRFE2(NY,NX)
      ZFEOH3(0,NY,NX)=ZFEOH3(0,NY,NX)+TQRFE3(NY,NX)
      ZFEOH4(0,NY,NX)=ZFEOH4(0,NY,NX)+TQRFE4(NY,NX)
      ZFES(0,NY,NX)=ZFES(0,NY,NX)+TQRFES(NY,NX)
      ZCAO(0,NY,NX)=ZCAO(0,NY,NX)+TQRCAO(NY,NX)
      ZCAC(0,NY,NX)=ZCAC(0,NY,NX)+TQRCAC(NY,NX)
      ZCAH(0,NY,NX)=ZCAH(0,NY,NX)+TQRCAH(NY,NX)
      ZCAS(0,NY,NX)=ZCAS(0,NY,NX)+TQRCAS(NY,NX)
      ZMGO(0,NY,NX)=ZMGO(0,NY,NX)+TQRMGO(NY,NX)
      ZMGC(0,NY,NX)=ZMGC(0,NY,NX)+TQRMGC(NY,NX)
      ZMGH(0,NY,NX)=ZMGH(0,NY,NX)+TQRMGH(NY,NX)
      ZMGS(0,NY,NX)=ZMGS(0,NY,NX)+TQRMGS(NY,NX)
      ZNAC(0,NY,NX)=ZNAC(0,NY,NX)+TQRNAC(NY,NX)
      ZNAS(0,NY,NX)=ZNAS(0,NY,NX)+TQRNAS(NY,NX)
      ZKAS(0,NY,NX)=ZKAS(0,NY,NX)+TQRKAS(NY,NX)
      H0PO4(0,NY,NX)=H0PO4(0,NY,NX)+TQRH0P(NY,NX)
      H1PO4(0,NY,NX)=H1PO4(0,NY,NX)+TQRH1P(NY,NX)
      H3PO4(0,NY,NX)=H3PO4(0,NY,NX)+TQRH3P(NY,NX)
      ZFE1P(0,NY,NX)=ZFE1P(0,NY,NX)+TQRF1P(NY,NX)
      ZFE2P(0,NY,NX)=ZFE2P(0,NY,NX)+TQRF2P(NY,NX)
      ZCA0P(0,NY,NX)=ZCA0P(0,NY,NX)+TQRC0P(NY,NX)
      ZCA1P(0,NY,NX)=ZCA1P(0,NY,NX)+TQRC1P(NY,NX)
      ZCA2P(0,NY,NX)=ZCA2P(0,NY,NX)+TQRC2P(NY,NX)
      ZMG1P(0,NY,NX)=ZMG1P(0,NY,NX)+TQRM1P(NY,NX)
      ENDIF
C
C     SURFACE SEDIMENT TRANSPORT
C
      IF(IERSN(NY,NX).NE.0)THEN
      IF(BKDS(NU(NY,NX),NY,NX).GT.ZERO)THEN
      SED(NY,NX)=SED(NY,NX)+TSEDER(NY,NX)
      DLYR(3,NU(NY,NX),NY,NX)=DLYR(3,NU(NY,NX),NY,NX)+TSEDER(NY,NX)
     2/(AREA(3,NU(NY,NX),NY,NX)*BKDS(NU(NY,NX),NY,NX))
      IF(TSEDER(NY,NX).GT.1.0E-06*BKVL(NU(NY,NX),NY,NX))IFLGS(NY,NX)=1
      ENDIF
C
C     SOIL MINERAL FRACTIONS
C
      SAND(NU(NY,NX),NY,NX)=SAND(NU(NY,NX),NY,NX)+TSANER(NY,NX)
      SILT(NU(NY,NX),NY,NX)=SILT(NU(NY,NX),NY,NX)+TSILER(NY,NX)
      CLAY(NU(NY,NX),NY,NX)=CLAY(NU(NY,NX),NY,NX)+TCLAER(NY,NX)
      XCEC(NU(NY,NX),NY,NX)=XCEC(NU(NY,NX),NY,NX)+TCECER(NY,NX)
      XAEC(NU(NY,NX),NY,NX)=XAEC(NU(NY,NX),NY,NX)+TAECER(NY,NX)
C
C     FERTILIZER POOLS
C
      ZNH4FA(NU(NY,NX),NY,NX)=ZNH4FA(NU(NY,NX),NY,NX)+TNH4ER(NY,NX)
      ZNH3FA(NU(NY,NX),NY,NX)=ZNH3FA(NU(NY,NX),NY,NX)+TNH3ER(NY,NX)
      ZNHUFA(NU(NY,NX),NY,NX)=ZNHUFA(NU(NY,NX),NY,NX)+TNHUER(NY,NX)
      ZNO3FA(NU(NY,NX),NY,NX)=ZNO3FA(NU(NY,NX),NY,NX)+TNO3ER(NY,NX)
      ZNH4FB(NU(NY,NX),NY,NX)=ZNH4FB(NU(NY,NX),NY,NX)+TNH4EB(NY,NX)
      ZNH3FB(NU(NY,NX),NY,NX)=ZNH3FB(NU(NY,NX),NY,NX)+TNH3EB(NY,NX)
      ZNHUFB(NU(NY,NX),NY,NX)=ZNHUFB(NU(NY,NX),NY,NX)+TNHUEB(NY,NX)
      ZNO3FB(NU(NY,NX),NY,NX)=ZNO3FB(NU(NY,NX),NY,NX)+TNO3EB(NY,NX)
C
C     EXCHANGEABLE CATIONS AND ANIONS
C
      XN4(NU(NY,NX),NY,NX)=XN4(NU(NY,NX),NY,NX)+TN4ER(NY,NX)
      XNB(NU(NY,NX),NY,NX)=XNB(NU(NY,NX),NY,NX)+TNBER(NY,NX)
      XHY(NU(NY,NX),NY,NX)=XHY(NU(NY,NX),NY,NX)+THYER(NY,NX)
      XAL(NU(NY,NX),NY,NX)=XAL(NU(NY,NX),NY,NX)+TALER(NY,NX)
      XCA(NU(NY,NX),NY,NX)=XCA(NU(NY,NX),NY,NX)+TCAER(NY,NX)
      XMG(NU(NY,NX),NY,NX)=XMG(NU(NY,NX),NY,NX)+TMGER(NY,NX)
      XNA(NU(NY,NX),NY,NX)=XNA(NU(NY,NX),NY,NX)+TNAER(NY,NX)
      XKA(NU(NY,NX),NY,NX)=XKA(NU(NY,NX),NY,NX)+TKAER(NY,NX)
      XHC(NU(NY,NX),NY,NX)=XHC(NU(NY,NX),NY,NX)+THCER(NY,NX)
      XALO2(NU(NY,NX),NY,NX)=XALO2(NU(NY,NX),NY,NX)+TAL2ER(NY,NX)
      XOH0(NU(NY,NX),NY,NX)=XOH0(NU(NY,NX),NY,NX)+TOH0ER(NY,NX)
      XOH1(NU(NY,NX),NY,NX)=XOH1(NU(NY,NX),NY,NX)+TOH1ER(NY,NX)
      XOH2(NU(NY,NX),NY,NX)=XOH2(NU(NY,NX),NY,NX)+TOH2ER(NY,NX)
      XH1P(NU(NY,NX),NY,NX)=XH1P(NU(NY,NX),NY,NX)+TH1PER(NY,NX)
      XH2P(NU(NY,NX),NY,NX)=XH2P(NU(NY,NX),NY,NX)+TH2PER(NY,NX)
      XOH0B(NU(NY,NX),NY,NX)=XOH0B(NU(NY,NX),NY,NX)+TOH0EB(NY,NX)
      XOH1B(NU(NY,NX),NY,NX)=XOH1B(NU(NY,NX),NY,NX)+TOH1EB(NY,NX)
      XOH2B(NU(NY,NX),NY,NX)=XOH2B(NU(NY,NX),NY,NX)+TOH2EB(NY,NX)
      XH1PB(NU(NY,NX),NY,NX)=XH1PB(NU(NY,NX),NY,NX)+TH1PEB(NY,NX)
      XH2PB(NU(NY,NX),NY,NX)=XH2PB(NU(NY,NX),NY,NX)+TH2PEB(NY,NX)
C
C     PRECIPITATES
C
      PALOH(NU(NY,NX),NY,NX)=PALOH(NU(NY,NX),NY,NX)+TALOER(NY,NX)
      PFEOH(NU(NY,NX),NY,NX)=PFEOH(NU(NY,NX),NY,NX)+TFEOER(NY,NX)
      PCACO(NU(NY,NX),NY,NX)=PCACO(NU(NY,NX),NY,NX)+TCACER(NY,NX)
      PCASO(NU(NY,NX),NY,NX)=PCASO(NU(NY,NX),NY,NX)+TCASER(NY,NX)
      PALPO(NU(NY,NX),NY,NX)=PALPO(NU(NY,NX),NY,NX)+TALPER(NY,NX)
      PFEPO(NU(NY,NX),NY,NX)=PFEPO(NU(NY,NX),NY,NX)+TFEPER(NY,NX)
      PCAPD(NU(NY,NX),NY,NX)=PCAPD(NU(NY,NX),NY,NX)+TCPDER(NY,NX)
      PCAPH(NU(NY,NX),NY,NX)=PCAPH(NU(NY,NX),NY,NX)+TCPHER(NY,NX)
      PCAPM(NU(NY,NX),NY,NX)=PCAPM(NU(NY,NX),NY,NX)+TCPMER(NY,NX)
      PALPB(NU(NY,NX),NY,NX)=PALPB(NU(NY,NX),NY,NX)+TALPEB(NY,NX)
      PFEPB(NU(NY,NX),NY,NX)=PFEPB(NU(NY,NX),NY,NX)+TFEPEB(NY,NX)
      PCPDB(NU(NY,NX),NY,NX)=PCPDB(NU(NY,NX),NY,NX)+TCPDEB(NY,NX)
      PCPHB(NU(NY,NX),NY,NX)=PCPHB(NU(NY,NX),NY,NX)+TCPHEB(NY,NX)
      PCPMB(NU(NY,NX),NY,NX)=PCPMB(NU(NY,NX),NY,NX)+TCPMEB(NY,NX)
C
C     ORGANIC CONSTITUENTS
C
      DO 9280 K=0,5
      DO 9280 NN=1,7
      DO 9280 M=1,3
      OMC(M,NN,K,NU(NY,NX),NY,NX)=OMC(M,NN,K,NU(NY,NX),NY,NX)
     2+TOMCER(M,NN,K,NY,NX)
      OMN(M,NN,K,NU(NY,NX),NY,NX)=OMN(M,NN,K,NU(NY,NX),NY,NX)
     2+TOMNER(M,NN,K,NY,NX)
      OMP(M,NN,K,NU(NY,NX),NY,NX)=OMP(M,NN,K,NU(NY,NX),NY,NX)
     2+TOMPER(M,NN,K,NY,NX)
9280  CONTINUE
      DO 9275 K=0,4
      DO 9270 M=1,2
      ORC(M,K,NU(NY,NX),NY,NX)=ORC(M,K,NU(NY,NX),NY,NX)
     2+TORCER(M,K,NY,NX)
      ORN(M,K,NU(NY,NX),NY,NX)=ORN(M,K,NU(NY,NX),NY,NX)
     2+TORNER(M,K,NY,NX)
      ORP(M,K,NU(NY,NX),NY,NX)=ORP(M,K,NU(NY,NX),NY,NX)
     2+TORPER(M,K,NY,NX)
9270  CONTINUE
      OHC(K,NU(NY,NX),NY,NX)=OHC(K,NU(NY,NX),NY,NX)+TOHCER(K,NY,NX)
      OHN(K,NU(NY,NX),NY,NX)=OHN(K,NU(NY,NX),NY,NX)+TOHNER(K,NY,NX)
      OHP(K,NU(NY,NX),NY,NX)=OHP(K,NU(NY,NX),NY,NX)+TOHPER(K,NY,NX)
      OHA(K,NU(NY,NX),NY,NX)=OHA(K,NU(NY,NX),NY,NX)+TOHAER(K,NY,NX)
      DO 9265 M=1,4
      OSC(M,K,NU(NY,NX),NY,NX)=OSC(M,K,NU(NY,NX),NY,NX)
     2+TOSCER(M,K,NY,NX)
      OSA(M,K,NU(NY,NX),NY,NX)=OSA(M,K,NU(NY,NX),NY,NX)
     2+TOSAER(M,K,NY,NX)
      OSN(M,K,NU(NY,NX),NY,NX)=OSN(M,K,NU(NY,NX),NY,NX)
     2+TOSNER(M,K,NY,NX)
      OSP(M,K,NU(NY,NX),NY,NX)=OSP(M,K,NU(NY,NX),NY,NX)
     2+TOSPER(M,K,NY,NX)
9265  CONTINUE
9275  CONTINUE
      ENDIF
      ENDIF
C
C     OVERLAND SNOW REDISTRIBUTION
C
      IF(TQS(NY,NX).NE.0.0)THEN
      CO2W(NY,NX)=CO2W(NY,NX)+TCOQSS(NY,NX)
      CH4W(NY,NX)=CH4W(NY,NX)+TCHQSS(NY,NX)
      OXYW(NY,NX)=OXYW(NY,NX)+TOXQSS(NY,NX)
      ZNGW(NY,NX)=ZNGW(NY,NX)+TNGQSS(NY,NX)
      ZN2W(NY,NX)=ZN2W(NY,NX)+TN2QSS(NY,NX)
      ZN4W(NY,NX)=ZN4W(NY,NX)+TN4QSS(NY,NX)
      ZN3W(NY,NX)=ZN3W(NY,NX)+TN3QSS(NY,NX)
      ZNOW(NY,NX)=ZNOW(NY,NX)+TNOQSS(NY,NX)
      ZHPW(NY,NX)=ZHPW(NY,NX)+TPOQSS(NY,NX)
      IF(ISALT(NY,NX).NE.0)THEN
      ZALW(NY,NX)=ZALW(NY,NX)+TQSAL(NY,NX)
      ZFEW(NY,NX)=ZFEW(NY,NX)+TQSFE(NY,NX)
      ZHYW(NY,NX)=ZHYW(NY,NX)+TQSHY(NY,NX)
      ZCAW(NY,NX)=ZCAW(NY,NX)+TQSCA(NY,NX)
      ZMGW(NY,NX)=ZMGW(NY,NX)+TQSMG(NY,NX)
      ZNAW(NY,NX)=ZNAW(NY,NX)+TQSNA(NY,NX)
      ZKAW(NY,NX)=ZKAW(NY,NX)+TQSKA(NY,NX)
      ZOHW(NY,NX)=ZOHW(NY,NX)+TQSOH(NY,NX)
      ZSO4W(NY,NX)=ZSO4W(NY,NX)+TQSSO(NY,NX)
      ZCLW(NY,NX)=ZCLW(NY,NX)+TQSCL(NY,NX) 
      ZCO3W(NY,NX)=ZCO3W(NY,NX)+TQSC3(NY,NX)
      ZHCO3W(NY,NX)=ZHCO3W(NY,NX)+TQSHC(NY,NX)
      ZALH1W(NY,NX)=ZALH1W(NY,NX)+TQSAL1(NY,NX)
      ZALH2W(NY,NX)=ZALH2W(NY,NX)+TQSAL2(NY,NX)
      ZALH3W(NY,NX)=ZALH3W(NY,NX)+TQSAL3(NY,NX)
      ZALH4W(NY,NX)=ZALH4W(NY,NX)+TQSAL4(NY,NX)
      ZALSW(NY,NX)=ZALSW(NY,NX)+TQSALS(NY,NX)
      ZFEH1W(NY,NX)=ZFEH1W(NY,NX)+TQSFE1(NY,NX)
      ZFEH2W(NY,NX)=ZFEH2W(NY,NX)+TQSFE2(NY,NX)
      ZFEH3W(NY,NX)=ZFEH3W(NY,NX)+TQSFE3(NY,NX)
      ZFEH4W(NY,NX)=ZFEH4W(NY,NX)+TQSFE4(NY,NX)
      ZFESW(NY,NX)=ZFESW(NY,NX)+TQSFES(NY,NX)
      ZCAOW(NY,NX)=ZCAOW(NY,NX)+TQSCAO(NY,NX)
      ZCACW(NY,NX)=ZCACW(NY,NX)+TQSCAC(NY,NX)
      ZCAHW(NY,NX)=ZCAHW(NY,NX)+TQSCAH(NY,NX)
      ZCASW(NY,NX)=ZCASW(NY,NX)+TQSCAS(NY,NX)
      ZMGOW(NY,NX)=ZMGOW(NY,NX)+TQSMGO(NY,NX)
      ZMGCW(NY,NX)=ZMGCW(NY,NX)+TQSMGC(NY,NX)
      ZMGHW(NY,NX)=ZMGHW(NY,NX)+TQSMGH(NY,NX)
      ZMGSW(NY,NX)=ZMGSW(NY,NX)+TQSMGS(NY,NX)
      ZNACW(NY,NX)=ZNACW(NY,NX)+TQSNAC(NY,NX)
      ZNASW(NY,NX)=ZNASW(NY,NX)+TQSNAS(NY,NX)
      ZKASW(NY,NX)=ZKASW(NY,NX)+TQSKAS(NY,NX)
      H0PO4W(NY,NX)=H0PO4W(NY,NX)+TQSH0P(NY,NX)
      H1PO4W(NY,NX)=H1PO4W(NY,NX)+TQSH1P(NY,NX)
      H3PO4W(NY,NX)=H3PO4W(NY,NX)+TQSH3P(NY,NX)
      ZFE1PW(NY,NX)=ZFE1PW(NY,NX)+TQSF1P(NY,NX)
      ZFE2PW(NY,NX)=ZFE2PW(NY,NX)+TQSF2P(NY,NX)
      ZCA0PW(NY,NX)=ZCA0PW(NY,NX)+TQSC0P(NY,NX)
      ZCA1PW(NY,NX)=ZCA1PW(NY,NX)+TQSC1P(NY,NX)
      ZCA2PW(NY,NX)=ZCA2PW(NY,NX)+TQSC2P(NY,NX)
      ZMG1PW(NY,NX)=ZMG1PW(NY,NX)+TQSM1P(NY,NX)
      ENDIF
      ENDIF
C
C     UPDATE STATE VARIABLES WITH TOTAL FLUXES CALCULATED ABOVE
C
C     IF(J.EQ.24)THEN
C
C     TOTAL C,N,P IN SURFACE RESIDUE
C
      RC=0.0
      RN=0.0
      RP=0.0
      DO 6975 K=0,5
      RC0(K,NY,NX)=0.0
      RA0(K,NY,NX)=0.0
6975  CONTINUE
      OMCL(0,NY,NX)=0.0
      OMNL(0,NY,NX)=0.0
C      
C     ZM added
C
      OMCN1(0,NY,NX)=0.0
      OMCN2(0,NY,NX)=0.0
      OMCN3(0,NY,NX)=0.0
      OMCN4(0,NY,NX)=0.0
      OMCN5(0,NY,NX)=0.0
      OMCN6(0,NY,NX)=0.0
      OMCN7(0,NY,NX)=0.0
C      OMNN1(0,NY,NX)=0.0
C      OMNN2(0,NY,NX)=0.0
C      OMNN3(0,NY,NX)=0.0
C      OMNN4(0,NY,NX)=0.0
C      OMNN5(0,NY,NX)=0.0
C      OMNN6(0,NY,NX)=0.0
C      OMNN7(0,NY,NX)=0.0   
C      OMCNA1(0,NY,NX)=0.0
C      OMCNA2(0,NY,NX)=0.0
C      OMCNA3(0,NY,NX)=0.0
C      OMCNA5(0,NY,NX)=0.0
C      OMNNA1(0,NY,NX)=0.0
C      OMNNA2(0,NY,NX)=0.0
C      OMNNA3(0,NY,NX)=0.0
C      OMNNA5(0,NY,NX)=0.0
C
      DO 6970 K=0,5
      IF(K.NE.3.AND.K.NE.4)THEN
C
C     TOTAL MICROBIAL C,N,P
C
      DO 6960 N=1,7
      DO 6960 M=1,3
      RC=RC+OMC(M,N,K,0,NY,NX)
      RN=RN+OMN(M,N,K,0,NY,NX)
      RP=RP+OMP(M,N,K,0,NY,NX)
      RC0(K,NY,NX)=RC0(K,NY,NX)+OMC(M,N,K,0,NY,NX)
      RA0(K,NY,NX)=RA0(K,NY,NX)+OMC(M,N,K,0,NY,NX)
      TOMT(NY,NX)=TOMT(NY,NX)+OMC(M,N,K,0,NY,NX)
      TONT(NY,NX)=TONT(NY,NX)+OMN(M,N,K,0,NY,NX)
      TOPT(NY,NX)=TOPT(NY,NX)+OMP(M,N,K,0,NY,NX)
      OMCL(0,NY,NX)=OMCL(0,NY,NX)+OMC(M,N,K,0,NY,NX)
      OMNL(0,NY,NX)=OMNL(0,NY,NX)+OMN(M,N,K,0,NY,NX)
C      
C ZM ADDED OMCN and OMNN for each microbial group
C
      OMCN1(0,NY,NX)=OMCN1(0,NY,NX)+OMC(M,1,K,0,NY,NX)
      OMCN2(0,NY,NX)=OMCN2(0,NY,NX)+OMC(M,2,K,0,NY,NX)
      OMCN3(0,NY,NX)=OMCN3(0,NY,NX)+OMC(M,3,K,0,NY,NX)
      OMCN4(0,NY,NX)=OMCN4(0,NY,NX)+OMC(M,4,K,0,NY,NX)
      OMCN5(0,NY,NX)=OMCN5(0,NY,NX)+OMC(M,5,K,0,NY,NX)
      OMCN6(0,NY,NX)=OMCN6(0,NY,NX)+OMC(M,6,K,0,NY,NX)
      OMCN7(0,NY,NX)=OMCN7(0,NY,NX)+OMC(M,7,K,0,NY,NX)
C      OMNN1(0,NY,NX)=OMNN1(0,NY,NX)+OMN(M,1,K,0,NY,NX)
C      OMNN2(0,NY,NX)=OMNN2(0,NY,NX)+OMN(M,2,K,0,NY,NX)
C      OMNN3(0,NY,NX)=OMNN3(0,NY,NX)+OMN(M,3,K,0,NY,NX)
C      OMNN4(0,NY,NX)=OMNN4(0,NY,NX)+OMN(M,4,K,0,NY,NX)
C      OMNN5(0,NY,NX)=OMNN5(0,NY,NX)+OMN(M,5,K,0,NY,NX)
C      OMNN6(0,NY,NX)=OMNN6(0,NY,NX)+OMN(M,6,K,0,NY,NX)
C      OMNN7(0,NY,NX)=OMNN7(0,NY,NX)+OMN(M,7,K,0,NY,NX)
C   
C      OMCNA1(0,NY,NX)=OMCNA1(0,NY,NX)+OMC(M,1,5,0,NY,NX)
C      OMCNA2(0,NY,NX)=OMCNA2(0,NY,NX)+OMC(M,2,5,0,NY,NX)
C      OMCNA3(0,NY,NX)=OMCNA3(0,NY,NX)+OMC(M,3,5,0,NY,NX)
C      OMCNA5(0,NY,NX)=OMCNA5(0,NY,NX)+OMC(M,4,5,0,NY,NX)
C      OMNNA1(0,NY,NX)=OMNNA1(0,NY,NX)+OMN(M,1,5,0,NY,NX)
C      OMNNA2(0,NY,NX)=OMNNA2(0,NY,NX)+OMN(M,2,5,0,NY,NX)
C      OMNNA3(0,NY,NX)=OMNNA3(0,NY,NX)+OMN(M,3,5,0,NY,NX)
C      OMNNA5(0,NY,NX)=OMNNA5(0,NY,NX)+OMN(M,4,5,0,NY,NX) 
C   zm
6960  CONTINUE
      ENDIF
6970  CONTINUE
C
C     TOTAL MICROBIAL RESIDUE C,N,P
C
      DO 6900 K=0,2
      DO 6940 M=1,2
      RC=RC+ORC(M,K,0,NY,NX)
      RN=RN+ORN(M,K,0,NY,NX)
      RP=RP+ORP(M,K,0,NY,NX)
      RC0(K,NY,NX)=RC0(K,NY,NX)+ORC(M,K,0,NY,NX)
      RA0(K,NY,NX)=RA0(K,NY,NX)+ORC(M,K,0,NY,NX)
6940  CONTINUE
C
C     TOTAL DOC, DON, DOP
C
      RC=RC+OQC(K,0,NY,NX)+OQCH(K,0,NY,NX)+OHC(K,0,NY,NX)+OQA(K,0,NY,NX)
     2+OQAH(K,0,NY,NX)+OHA(K,0,NY,NX)
      RN=RN+OQN(K,0,NY,NX)+OQNH(K,0,NY,NX)+OHN(K,0,NY,NX)
      RP=RP+OQP(K,0,NY,NX)+OQPH(K,0,NY,NX)+OHP(K,0,NY,NX)
      RC0(K,NY,NX)=RC0(K,NY,NX)+OQC(K,0,NY,NX)+OQCH(K,0,NY,NX)
     2+OHC(K,0,NY,NX)+OQA(K,0,NY,NX)+OQAH(K,0,NY,NX)+OHA(K,0,NY,NX)
      RA0(K,NY,NX)=RA0(K,NY,NX)+OQC(K,0,NY,NX)+OQCH(K,0,NY,NX)
     2+OHC(K,0,NY,NX)+OQA(K,0,NY,NX)+OQAH(K,0,NY,NX)+OHA(K,0,NY,NX)
C
C     TOTAL PLANT RESIDUE C,N,P
C
      DO 6930 M=1,4
      RC=RC+OSC(M,K,0,NY,NX)
      RN=RN+OSN(M,K,0,NY,NX)
      RP=RP+OSP(M,K,0,NY,NX)
      RC0(K,NY,NX)=RC0(K,NY,NX)+OSC(M,K,0,NY,NX)
      RA0(K,NY,NX)=RA0(K,NY,NX)+OSA(M,K,0,NY,NX)
6930  CONTINUE
6900  CONTINUE
      ORGC(0,NY,NX)=RC
      ORGN(0,NY,NX)=RN
      ORGR(0,NY,NX)=RC
      TLRSDC=TLRSDC+RC
      URSDC(NY,NX)=URSDC(NY,NX)+RC
      TLRSDN=TLRSDN+RN
      URSDN(NY,NX)=URSDN(NY,NX)+RN
      TLRSDP=TLRSDP+RP
      URSDP(NY,NX)=URSDP(NY,NX)+RP
      WS=TVOLWC(NY,NX)+TVOLWP(NY,NX)+VOLW(0,NY,NX)+VOLI(0,NY,NX)*0.92
      VOLWSO=VOLWSO+WS
      UVOLW(NY,NX)=UVOLW(NY,NX)+WS
      ENGYR=VHCPR(NY,NX)*TKS(0,NY,NX)
      HEATSO=HEATSO+TENGYC(NY,NX)+ENGYR
      CS=CO2S(0,NY,NX)+CH4S(0,NY,NX)
      TLCO2G=TLCO2G+CS
      UCO2S(NY,NX)=UCO2S(NY,NX)+CS
      OS=OXYS(0,NY,NX)
      OXYGSO=OXYGSO+OS
      ZG=Z2GS(0,NY,NX)+Z2OS(0,NY,NX)
      TLN2G=TLN2G+ZG
      ZNH=ZNH4S(0,NY,NX)+ZNH3S(0,NY,NX)
      TLNH4=TLNH4+ZNH
      UNH4(NY,NX)=UNH4(NY,NX)+ZNH+14.0*(XN4(0,NY,NX)+XNB(0,NY,NX))
      XN4(0,NY,NX)=XN4(0,NY,NX)+TRXN4(0,NY,NX)
      ZNO=ZNO3S(0,NY,NX)+ZNO2S(0,NY,NX)
      TLNO3=TLNO3+ZNO
      UNO3(NY,NX)=UNO3(NY,NX)+ZNO
      P4=H2PO4(0,NY,NX)
      TLPO4=TLPO4+P4
      UPO4(NY,NX)=UPO4(NY,NX)+P4+31.0*(XH1P(0,NY,NX)+XH2P(0,NY,NX))
      PALPO(0,NY,NX)=PALPO(0,NY,NX)+TRALPO(0,NY,NX)
      PFEPO(0,NY,NX)=PFEPO(0,NY,NX)+TRFEPO(0,NY,NX)
      PCAPD(0,NY,NX)=PCAPD(0,NY,NX)+TRCAPD(0,NY,NX)
      PCAPH(0,NY,NX)=PCAPH(0,NY,NX)+TRCAPH(0,NY,NX)
      PCAPM(0,NY,NX)=PCAPM(0,NY,NX)+TRCAPM(0,NY,NX)
      UPP4(NY,NX)=UPP4(NY,NX)+31.0*(PALPO(0,NY,NX)+PFEPO(0,NY,NX)
     2+PCAPD(0,NY,NX))+93.0*PCAPH(0,NY,NX)+62.0*PCAPM(0,NY,NX)
      TX=2.0*XN4(0,NY,NX)+XOH0(0,NY,NX)
     2+2.0*(PALPO(0,NY,NX)+PFEPO(0,NY,NX)+XOH1(0,NY,NX))
     3+3.0*(PCAPD(0,NY,NX)+XOH2(0,NY,NX)+XH1P(0,NY,NX))
     4+4.0*XH2P(0,NY,NX)+7.0*PCAPM(0,NY,NX)+9.0*PCAPH(0,NY,NX)
      TF=2.0*ZNH4FA(0,NY,NX)+ZNHUFA(0,NY,NX)+ZNO3FA(0,NY,NX)
     2+ZNH3FA(0,NY,NX)
      TG=H2GS(0,NY,NX) 
      TI=TX+TF+TG
      TION=TION+TI
      UION(NY,NX)=UION(NY,NX)+TI

      IF(ISALT(NY,NX).NE.0)THEN
      ZAL(0,NY,NX)=ZAL(0,NY,NX)+XALFLS(3,0,NY,NX)
      ZFE(0,NY,NX)=ZFE(0,NY,NX)+XFEFLS(3,0,NY,NX)
      ZHY(0,NY,NX)=ZHY(0,NY,NX)+XHYFLS(3,0,NY,NX)
      ZCA(0,NY,NX)=ZCA(0,NY,NX)+XCAFLS(3,0,NY,NX)
      ZMG(0,NY,NX)=ZMG(0,NY,NX)+XMGFLS(3,0,NY,NX)
      ZNA(0,NY,NX)=ZNA(0,NY,NX)+XNAFLS(3,0,NY,NX)
      ZKA(0,NY,NX)=ZKA(0,NY,NX)+XKAFLS(3,0,NY,NX)
      ZOH(0,NY,NX)=ZOH(0,NY,NX)+XOHFLS(3,0,NY,NX)
      ZSO4(0,NY,NX)=ZSO4(0,NY,NX)+XSOFLS(3,0,NY,NX)
      ZCL(0,NY,NX)=ZCL(0,NY,NX)+XCLFLS(3,0,NY,NX) 
      ZCO3(0,NY,NX)=ZCO3(0,NY,NX)+XC3FLS(3,0,NY,NX)
      ZHCO3(0,NY,NX)=ZHCO3(0,NY,NX)+XHCFLS(3,0,NY,NX)
      ZALOH1(0,NY,NX)=ZALOH1(0,NY,NX)+XAL1FS(3,0,NY,NX)
      ZALOH2(0,NY,NX)=ZALOH2(0,NY,NX)+XAL2FS(3,0,NY,NX)
      ZALOH3(0,NY,NX)=ZALOH3(0,NY,NX)+XAL3FS(3,0,NY,NX)
      ZALOH4(0,NY,NX)=ZALOH4(0,NY,NX)+XAL4FS(3,0,NY,NX)
      ZALS(0,NY,NX)=ZALS(0,NY,NX)+XALSFS(3,0,NY,NX)
      ZFEOH1(0,NY,NX)=ZFEOH1(0,NY,NX)+XFE1FS(3,0,NY,NX)
      ZFEOH2(0,NY,NX)=ZFEOH2(0,NY,NX)+XFE2FS(3,0,NY,NX)
      ZFEOH3(0,NY,NX)=ZFEOH3(0,NY,NX)+XFE3FS(3,0,NY,NX)
      ZFEOH4(0,NY,NX)=ZFEOH4(0,NY,NX)+XFE4FS(3,0,NY,NX)
      ZFES(0,NY,NX)=ZFES(0,NY,NX)+XFESFS(3,0,NY,NX)
      ZCAO(0,NY,NX)=ZCAO(0,NY,NX)+XCAOFS(3,0,NY,NX)
      ZCAC(0,NY,NX)=ZCAC(0,NY,NX)+XCACFS(3,0,NY,NX)
      ZCAH(0,NY,NX)=ZCAH(0,NY,NX)+XCAHFS(3,0,NY,NX)
      ZCAS(0,NY,NX)=ZCAS(0,NY,NX)+XCASFS(3,0,NY,NX)
      ZMGO(0,NY,NX)=ZMGO(0,NY,NX)+XMGOFS(3,0,NY,NX)
      ZMGC(0,NY,NX)=ZMGC(0,NY,NX)+XMGCFS(3,0,NY,NX)
      ZMGH(0,NY,NX)=ZMGH(0,NY,NX)+XMGHFS(3,0,NY,NX)
      ZMGS(0,NY,NX)=ZMGS(0,NY,NX)+XMGSFS(3,0,NY,NX)
      ZNAC(0,NY,NX)=ZNAC(0,NY,NX)+XNACFS(3,0,NY,NX)
      ZNAS(0,NY,NX)=ZNAS(0,NY,NX)+XNASFS(3,0,NY,NX)
      ZKAS(0,NY,NX)=ZKAS(0,NY,NX)+XKASFS(3,0,NY,NX)
      H0PO4(0,NY,NX)=H0PO4(0,NY,NX)+XH0PFS(3,0,NY,NX)
      H1PO4(0,NY,NX)=H1PO4(0,NY,NX)+XH1PFS(3,0,NY,NX)
      H3PO4(0,NY,NX)=H3PO4(0,NY,NX)+XH3PFS(3,0,NY,NX)
      ZFE1P(0,NY,NX)=ZFE1P(0,NY,NX)+XF1PFS(3,0,NY,NX)
      ZFE2P(0,NY,NX)=ZFE2P(0,NY,NX)+XF2PFS(3,0,NY,NX)
      ZCA0P(0,NY,NX)=ZCA0P(0,NY,NX)+XC0PFS(3,0,NY,NX)
      ZCA1P(0,NY,NX)=ZCA1P(0,NY,NX)+XC1PFS(3,0,NY,NX)
      ZCA2P(0,NY,NX)=ZCA2P(0,NY,NX)+XC2PFS(3,0,NY,NX)
      ZMG1P(0,NY,NX)=ZMG1P(0,NY,NX)+XM1PFS(3,0,NY,NX)
      TS=ZAL(0,NY,NX)+ZFE(0,NY,NX)+ZHY(0,NY,NX)+ZCA(0,NY,NX)
     2+ZMG(0,NY,NX)+ZNA(0,NY,NX)+ZKA(0,NY,NX)+ZOH(0,NY,NX)
     3+ZSO4(0,NY,NX)+ZCL(0,NY,NX)+ZCO3(0,NY,NX)+H0PO4(0,NY,NX)
     4+2.0*(ZHCO3(0,NY,NX)+ZALOH1(0,NY,NX)
     5+ZALS(0,NY,NX)+ZFEOH1(0,NY,NX)+ZFES(0,NY,NX)+ZCAO(0,NY,NX)
     6+ZCAC(0,NY,NX)+ZCAS(0,NY,NX)+ZMGO(0,NY,NX)+ZMGC(0,NY,NX)
     7+ZMGS(0,NY,NX)+ZNAC(0,NY,NX)+ZNAS(0,NY,NX)+ZKAS(0,NY,NX)
     8+H1PO4(0,NY,NX)+ZCA0P(0,NY,NX))
     9+3.0*(ZALOH2(0,NY,NX)+ZFEOH2(0,NY,NX)+ZCAH(0,NY,NX)
     1+ZMGH(0,NY,NX)+ZFE1P(0,NY,NX)+ZCA1P(0,NY,NX)+ZMG1P(0,NY,NX))
     2+4.0*
     3(ZALOH3(0,NY,NX)+ZFEOH3(0,NY,NX)+H3PO4(0,NY,NX)+ZFE2P(0,NY,NX)
     4+ZCA2P(0,NY,NX))+5.0*(ZALOH4(0,NY,NX)+ZFEOH4(0,NY,NX))
      TION=TION+TS
      UION(NY,NX)=UION(NY,NX)+TS
      ENDIF
C     ENDIF
C
C     IF SNOWPACK OR SURFACE RESIDUE DISAPPEARS
C
      IF(FLWSI(NY,NX).GT.0.0)THEN
      VHCP(NU(NY,NX),NY,NX)=VHCM(NU(NY,NX),NY,NX)
     2+4.19*(VOLW(NU(NY,NX),NY,NX)+VOLWH(NU(NY,NX),NY,NX))
     2+1.9274*(VOLI(NU(NY,NX),NY,NX)+VOLIH(NU(NY,NX),NY,NX))
      VOLI(NU(NY,NX),NY,NX)=VOLI(NU(NY,NX),NY,NX)+FLWSI(NY,NX)
      ENGY=VHCP(NU(NY,NX),NY,NX)*TKS(NU(NY,NX),NY,NX)
      VHCP(NU(NY,NX),NY,NX)=VHCM(NU(NY,NX),NY,NX)
     2+4.19*(VOLW(NU(NY,NX),NY,NX)+VOLWH(NU(NY,NX),NY,NX))
     2+1.9274*(VOLI(NU(NY,NX),NY,NX)+VOLIH(NU(NY,NX),NY,NX))
      TKS(NU(NY,NX),NY,NX)=(ENGY+HFLWSI(NY,NX))/VHCP(NU(NY,NX),NY,NX)
      ENDIF
      VOLWX(NU(NY,NX),NY,NX)=VOLW(NU(NY,NX),NY,NX)
      TCS(0,NY,NX)=TKS(0,NY,NX)-273.15
      TSMX(0,NY,NX)=AMAX1(TSMX(0,NY,NX),TCS(0,NY,NX))
      TSMN(0,NY,NX)=AMIN1(TSMN(0,NY,NX),TCS(0,NY,NX))
C
C     UPDATE SOIL LAYER VARIABLES WITH TOTAL FLUXES
C
      DO 125 L=NU(NY,NX),NL(NY,NX)
C
C     WATER, ICE, HEAT, TEMPERATURE
C
      VHCP(L,NY,NX)=VHCM(L,NY,NX)+4.19*(VOLW(L,NY,NX)+VOLWH(L,NY,NX))
     2+1.9274*(VOLI(L,NY,NX)+VOLIH(L,NY,NX))
      VOLW1=VOLW(L,NY,NX)
      VOLW(L,NY,NX)=VOLW(L,NY,NX)+TFLW(L,NY,NX)+FINH(L,NY,NX)
     2+TTHAW(L,NY,NX)+TUPWTR(L,NY,NX)
     3+FLU(L,NY,NX)+18.0E-06*TRH2O(L,NY,NX)
      IF(VOLW(L,NY,NX).GT.ZEROS(NY,NX))THEN
      VOLWX(L,NY,NX)=VOLWX(L,NY,NX)+TFLWX(L,NY,NX)+FINH(L,NY,NX)
     2+TTHAW(L,NY,NX)+TUPWTR(L,NY,NX)*VOLWX(L,NY,NX)/VOLW(L,NY,NX)
     3+FLU(L,NY,NX)+18.0E-06*TRH2O(L,NY,NX)+FLWV(L,NY,NX)
      VOLWX(L,NY,NX)=AMAX1(THETY(L,NY,NX)*VOLX(L,NY,NX)
     2,AMIN1(VOLW(L,NY,NX),VOLWX(L,NY,NX)))
      ELSE
      VOLWX(L,NY,NX)=0.0
      ENDIF
      VOLI(L,NY,NX)=VOLI(L,NY,NX)-TTHAW(L,NY,NX)/0.92
      VOLWH(L,NY,NX)=VOLWH(L,NY,NX)+TFLWH(L,NY,NX)-FINH(L,NY,NX)
     2+TTHAWH(L,NY,NX)
      VOLIH(L,NY,NX)=VOLIH(L,NY,NX)-TTHAWH(L,NY,NX)/0.92
      VOLP(L,NY,NX)=AMAX1(0.0,VOLA(L,NY,NX)-VOLW(L,NY,NX)
     2-VOLI(L,NY,NX))+AMAX1(0.0,VOLAH(L,NY,NX)-VOLWH(L,NY,NX)
     3-VOLIH(L,NY,NX))
      ENGY=VHCP(L,NY,NX)*TKS(L,NY,NX)
      VHCP1=VHCP(L,NY,NX)
      TKS1=TKS(L,NY,NX)
      VHCP(L,NY,NX)=VHCM(L,NY,NX)+4.19*(VOLW(L,NY,NX)+VOLWH(L,NY,NX))
     2+1.9274*(VOLI(L,NY,NX)+VOLIH(L,NY,NX))
      TKS(L,NY,NX)=(ENGY+THFLW(L,NY,NX)+THTHAW(L,NY,NX)+TUPHT(L,NY,NX)
     2+HWFLU(L,NY,NX))/VHCP(L,NY,NX)
      TCS(L,NY,NX)=TKS(L,NY,NX)-273.15
      TSMX(L,NY,NX)=AMAX1(TSMX(L,NY,NX),TCS(L,NY,NX))
      TSMN(L,NY,NX)=AMIN1(TSMN(L,NY,NX),TCS(L,NY,NX))
      UN2GS(NY,NX)=UN2GS(NY,NX)+XN2GS(L,NY,NX)
C     IF(NX.EQ.4.AND.NY.EQ.2)THEN
C     WRITE(*,6547)'VOLW',I,J,NX,NY,L,VOLW(L,NY,NX),VOLW1
C    2,TFLW(L,NY,NX),FINH(L,NY,NX),TTHAW(L,NY,NX),TUPWTR(L,NY,NX)
C    3,FLU(L,NY,NX),18.0E-06*TRH2O(L,NY,NX),TQR(NY,NX) 
C    4,PSISM(L,NY,NX),VOLI(L,NY,NX),VOLP(L,NY,NX),VOLA(L,NY,NX)
C     WRITE(*,6547)'VOLWH',I,J,NX,NY,L,VOLWH(L,NY,NX),TFLWH(L,NY,NX)
C    2,FINH(L,NY,NX),TTHAWH(L,NY,NX),VOLIH(L,NY,NX),VOLAH(L,NY,NX) 
6547  FORMAT(A8,5I4,20E12.4)
C     WRITE(*,6633)'TKS',I,J,NX,NY,L,TKS(L,NY,NX),ENGY,THFLW(L,NY,NX)
C    2,THTHAW(L,NY,NX),TUPHT(L,NY,NX),HWFLU(L,NY,NX),VHCP(L,NY,NX)
C    3,VHCP1,TKS1,VOLW(L,NY,NX),VOLWH(L,NY,NX),VOLI(L,NY,NX)
C    4,VOLIH(L,NY,NX),TFLW(L,NY,NX),FINH(L,NY,NX),TTHAW(L,NY,NX)
C    5,TUPWTR(L,NY,NX),FLU(L,NY,NX),TRH2O(L,NY,NX),TQR(NY,NX)
C    6,FLWSI(NY,NX),HFLWSI(NY,NX) 
6633  FORMAT(A8,5I4,30F20.6)
C      ENDIF
C
C     RESIDUE FROM PLANT LITTERFALL
C
      DO 8565 K=0,1
      DO 8565 M=1,4
      OSC(M,K,L,NY,NX)=OSC(M,K,L,NY,NX)+CSNT(M,K,L,NY,NX)
      OSN(M,K,L,NY,NX)=OSN(M,K,L,NY,NX)+ZSNT(M,K,L,NY,NX)
      OSP(M,K,L,NY,NX)=OSP(M,K,L,NY,NX)+PSNT(M,K,L,NY,NX)
C     IF((I/30)*30.EQ.I.AND.J.EQ.15)THEN
C     WRITE(*,8484)'OSC',I,J,L,K,M,OSC(M,K,L,NY,NX)
C    2,OSN(M,K,L,NY,NX),OSP(M,K,L,NY,NX),CSNT(M,K,L,NY,NX)
C    3,ZSNT(M,K,L,NY,NX),PSNT(M,K,L,NY,NX)
8484  FORMAT(A8,5I4,12E12.4)
C     ENDIF
8565  CONTINUE
C
C     DOC, DON, DOP FROM AQUEOUS TRANSPORT
C
      DO 8560 K=0,4
      OQC(K,L,NY,NX)=OQC(K,L,NY,NX)+TOCFLS(K,L,NY,NX)
     2+XOCFXS(K,L,NY,NX)
      OQN(K,L,NY,NX)=OQN(K,L,NY,NX)+TONFLS(K,L,NY,NX)
     2+XONFXS(K,L,NY,NX)
      OQP(K,L,NY,NX)=OQP(K,L,NY,NX)+TOPFLS(K,L,NY,NX)
     2+XOPFXS(K,L,NY,NX)
      OQA(K,L,NY,NX)=OQA(K,L,NY,NX)+TOAFLS(K,L,NY,NX)
     2+XOAFXS(K,L,NY,NX)
      OQCH(K,L,NY,NX)=OQCH(K,L,NY,NX)+TOCFHS(K,L,NY,NX)
     2-XOCFXS(K,L,NY,NX)
      OQNH(K,L,NY,NX)=OQNH(K,L,NY,NX)+TONFHS(K,L,NY,NX)
     2-XONFXS(K,L,NY,NX)
      OQPH(K,L,NY,NX)=OQPH(K,L,NY,NX)+TOPFHS(K,L,NY,NX)
     2-XOPFXS(K,L,NY,NX)
      OQAH(K,L,NY,NX)=OQAH(K,L,NY,NX)+TOAFHS(K,L,NY,NX)
     2-XOAFXS(K,L,NY,NX)
C     WRITE(*,2627)'OQC',I,J,NX,NY,L,K,OQC(K,L,NY,NX)
C    2,TOCFLS(K,L,NY,NX),XOCFXS(K,L,NY,NX)
2627  FORMAT(A8,6I4,20E12.4)
8560  CONTINUE
C
C     DOC, DON, DOP FROM PLANT EXUDATION
C
      OQC(1,L,NY,NX)=OQC(1,L,NY,NX)+TDFOMC(L,NY,NX)
      OQN(1,L,NY,NX)=OQN(1,L,NY,NX)+TDFOMN(L,NY,NX)
      OQP(1,L,NY,NX)=OQP(1,L,NY,NX)+TDFOMP(L,NY,NX)
C
C     SOIL SOLUTES FROM AQUEOUS TRANSPORT, MICROBIAL AND ROOT
C     EXCHANGE, EQUILIBRIUM REACTIONS, GAS EXCHANGE,
C     MICROPORE-MACROPORE EXCHANGE,
C
      CO2S(L,NY,NX)=CO2S(L,NY,NX)+TCOFLS(L,NY,NX)+XCODFG(L,NY,NX)
     2-RCO2O(L,NY,NX)-TCO2S(L,NY,NX)+RCOFLU(L,NY,NX)+XCOFXS(L,NY,NX)
     3+TRCO2(L,NY,NX)+XCOBBL(L,NY,NX)
      CH4S(L,NY,NX)=CH4S(L,NY,NX)+TCHFLS(L,NY,NX)+XCHDFG(L,NY,NX)
     2-RCH4O(L,NY,NX)-TUPCHS(L,NY,NX)+RCHFLU(L,NY,NX)
     3+XCHFXS(L,NY,NX)+XCHBBL(L,NY,NX)
      OXYS(L,NY,NX)=OXYS(L,NY,NX)+TOXFLS(L,NY,NX)+XOXDFG(L,NY,NX)
     2-RUPOXO(L,NY,NX)-TUPOXS(L,NY,NX)+ROXFLU(L,NY,NX) 
     3+XOXFXS(L,NY,NX)+XOXBBL(L,NY,NX)
C     IF(NX.EQ.3.AND.NY.EQ.4)THEN
C     WRITE(*,5432)'CO2S',I,J,NX,NY,L,CO2S(L,NY,NX),TCOFLS(L,NY,NX)
C    2,XCODFG(L,NY,NX),RCO2O(L,NY,NX),TCO2S(L,NY,NX)
C    3,RCOFLU(L,NY,NX),XCOFXS(L,NY,NX),TRCO2(L,NY,NX)
C    4,XCOBBL(L,NY,NX),CO2G(L,NY,NX)
C     WRITE(*,5432)'CH4S',I,J,NX,NY,L,CH4S(L,NY,NX),TCHFLS(L,NY,NX)
C    2,XCHDFG(L,NY,NX),RCH4O(L,NY,NX),TUPCHS(L,NY,NX)
C    3,RCHFLU(L,NY,NX),XCHFXS(L,NY,NX),XCHBBL(L,NY,NX)
C    4,XCOBBL(L,NY,NX),XCHFLS(3,L,NY,NX),XCHFLS(3,L+1,NY,NX)
C     WRITE(*,5432)'OXYS',I,J,NX,NY,L,OXYS(L,NY,NX),TOXFLS(L,NY,NX)
C    2,XOXDFG(L,NY,NX),RUPOXO(L,NY,NX),TUPOXS(L,NY,NX)
C    3,ROXFLU(L,NY,NX),XOXFXS(L,NY,NX),XOXBBL(L,NY,NX),COXYS(L,NY,NX)
C    4,XOXFLS(3,L,NY,NX),XOXFLS(3,L+1,NY,NX),XOXDFS(NY,NX)
5432  FORMAT(A8,5I4,20E16.6)
C     ENDIF
      Z2GS(L,NY,NX)=Z2GS(L,NY,NX)+TNGFLS(L,NY,NX)+XNGDFG(L,NY,NX)
     2-RN2G(L,NY,NX)-TUPNF(L,NY,NX)+RNGFLU(L,NY,NX)+XNGFXS(L,NY,NX)
     3-XN2GS(L,NY,NX)+XNGBBL(L,NY,NX)
      Z2OS(L,NY,NX)=Z2OS(L,NY,NX)+TN2FLS(L,NY,NX)+XN2DFG(L,NY,NX)
     2-RN2O(L,NY,NX)-TUPN2S(L,NY,NX)+RN2FLU(L,NY,NX)+XN2FXS(L,NY,NX)
     3+XN2BBL(L,NY,NX)
C     IF(I.GT.160.AND.I.LT.190)THEN
C     WRITE(*,4444)'Z2OS',I,J,NX,NY,L,Z2OS(L,NY,NX),TN2FLS(L,NY,NX)
C    2,XN2DFG(L,NY,NX),RN2O(L,NY,NX),TUPN2S(L,NY,NX),RN2FLU(L,NY,NX)
C    3,XN2FXS(L,NY,NX),Z2GS(L,NY,NX),TNGFLS(L,NY,NX),XNGDFG(L,NY,NX)
C    4,RN2G(L,NY,NX),TUPNF(L,NY,NX),RNGFLU(L,NY,NX),XNGFXS(L,NY,NX)
C    5,XN2GS(L,NY,NX),XNGBBL(L,NY,NX)
C     ENDIF
      H2GS(L,NY,NX)=H2GS(L,NY,NX)+THGFLS(L,NY,NX)+XHGDFG(L,NY,NX)
     2-RH2GO(L,NY,NX)-TUPHGS(L,NY,NX)+RHGFLU(L,NY,NX)
     3+XHGFXS(L,NY,NX)+XHGBBL(L,NY,NX)
      ZNH3S(L,NY,NX)=ZNH3S(L,NY,NX)+TN3FLS(L,NY,NX)+XN3DFG(L,NY,NX)
     2-XN34SQ(L,NY,NX)+TRN3S(L,NY,NX)-TUPN3S(L,NY,NX)+RN3FLU(L,NY,NX) 
     3+XN3FXW(L,NY,NX)+XN3BBL(L,NY,NX)
      ZNH4S(L,NY,NX)=ZNH4S(L,NY,NX)+TN4FLS(L,NY,NX)+XNH4S(L,NY,NX)
     2+TRN4S(L,NY,NX)-TUPNH4(L,NY,NX)+RN4FLU(L,NY,NX)
     3+XN4FXW(L,NY,NX)+XN34SQ(L,NY,NX)
C     IF(L.EQ.1)THEN
C     WRITE(*,4444)'NH3',I,J,NX,NY,L,ZNH3S(L,NY,NX),TN3FLS(L,NY,NX)
C    2,XN3DFG(L,NY,NX),XN34SQ(L,NY,NX),TRN3S(L,NY,NX),TUPN3S(L,NY,NX) 
C    3,RN3FLU(L,NY,NX),XN3FXW(L,NY,NX),XN3BBL(L,NY,NX),ZNH4S(L,NY,NX)
C    4,TN4FLS(L,NY,NX),XNH4S(L,NY,NX),TRN4S(L,NY,NX),TUPNH4(L,NY,NX)
C    5,RN4FLU(L,NY,NX),XN4FXW(L,NY,NX),TN4QRS(NY,NX),TN3QRS(NY,NX)
C    6,ZNH3SH(L,NY,NX),ZNH4SH(L,NY,NX)
4444  FORMAT(A8,5I4,30E12.4)
C     ENDIF
      ZNO3S(L,NY,NX)=ZNO3S(L,NY,NX)+TNOFLS(L,NY,NX)+XNO3S(L,NY,NX)
     2+TRNO3(L,NY,NX)-TUPNO3(L,NY,NX)+RNOFLU(L,NY,NX)
     3+XNOFXW(L,NY,NX)
      ZNO2S(L,NY,NX)=ZNO2S(L,NY,NX)+TNXFLS(L,NY,NX)+XNO2S(L,NY,NX)
     2+TRNO2(L,NY,NX)+XNXFXS(L,NY,NX)
C     IF(L.EQ.NU(NY,NX))THEN
C     WRITE(*,5545)'NO3',I,J,NX,NY,L,ZNO3S(L,NY,NX),TNOFLS(L,NY,NX)
C    2,XNO3S(L,NY,NX),TRNO3(L,NY,NX),TUPNO3(L,NY,NX),RNOFLU(L,NY,NX)
C    3,XNOFXW(L,NY,NX),ZNO2S(L,NY,NX),TNXFLS(L,NY,NX)
C    4,XNO2S(L,NY,NX),TRNO2(L,NY,NX),XNXFXS(L,NY,NX),TNXQRS(NY,NX)
5545  FORMAT(A8,5I4,40E12.4)
C     ENDIF
      H2PO4(L,NY,NX)=H2PO4(L,NY,NX)+TPOFLS(L,NY,NX)+XH2PS(L,NY,NX)
     2+TRH2P(L,NY,NX)-TUPH2P(L,NY,NX)+RH2PFU(L,NY,NX)
     3+XH2PXS(L,NY,NX)
      ZNH3B(L,NY,NX)=ZNH3B(L,NY,NX)+TN3FLB(L,NY,NX)+XNBDFG(L,NY,NX)
     2-XN34BQ(L,NY,NX)+TRN3B(L,NY,NX)-TUPN3B(L,NY,NX)+RN3FBU(L,NY,NX) 
     3+XN3FXB(L,NY,NX)+XNBBBL(L,NY,NX)
      ZNH4B(L,NY,NX)=ZNH4B(L,NY,NX)+TN4FLB(L,NY,NX)+XNH4B(L,NY,NX)
     2+TRN4B(L,NY,NX)-TUPNHB(L,NY,NX)+RN4FBU(L,NY,NX)
     3+XN4FXB(L,NY,NX)+XN34BQ(L,NY,NX)
      ZNO3B(L,NY,NX)=ZNO3B(L,NY,NX)+TNOFLB(L,NY,NX)+XNO3B(L,NY,NX)
     2+TRNOB(L,NY,NX)-TUPNOB(L,NY,NX)+RNOFBU(L,NY,NX)
     3+XNOFXB(L,NY,NX)
      ZNO2B(L,NY,NX)=ZNO2B(L,NY,NX)+TNXFLB(L,NY,NX)+XNO2B(L,NY,NX)
     2+TRN2B(L,NY,NX)+XNXFXB(L,NY,NX)
      H2POB(L,NY,NX)=H2POB(L,NY,NX)+TH2BFB(L,NY,NX)+XH2BS(L,NY,NX)
     2+TRH2B(L,NY,NX)-TUPH2B(L,NY,NX)+RH2BBU(L,NY,NX)
     3+XH2BXB(L,NY,NX)
      THRE(NY,NX)=THRE(NY,NX)+RCO2O(L,NY,NX)
      UN2GG(NY,NX)=UN2GG(NY,NX)+RN2G(L,NY,NX)
      HN2GG(NY,NX)=HN2GG(NY,NX)+RN2G(L,NY,NX)
C     IF(J.EQ.12.AND.L.LE.4)THEN
C     WRITE(*,4445)'NHB',I,J,L,ZNH3B(L,NY,NX),TN3FLB(L,NY,NX)
C    2,XNBDFG(L,NY,NX),XN34BQ(L,NY,NX),TRN3B(L,NY,NX),TUPN3B(L,NY,NX) 
C    3,RN3FBU(L,NY,NX),XN3FXB(L,NY,NX),XNBBBL(L,NY,NX),TUPNHB(L,NY,NX)
C    4,ZNH4B(L,NY,NX),TN4FLB(L,NY,NX),XNH4B(L,NY,NX)
C    5,TRN4B(L,NY,NX),TUPNHB(L,NY,NX),RN4FBU(L,NY,NX)
C     WRITE(*,4445)'NOB',I,J,L,ZNO2B(L,NY,NX),TNXFLB(L,NY,NX)
C    2,XNO2B(L,NY,NX),TRN2B(L,NY,NX),XNXFXB(L,NY,NX)
4445  FORMAT(A8,3I4,20E12.4)
C     ENDIF
C
C     EXCHANGEABLE CATIONS AND ANIONS FROM EXCHANGE REACTIONS
C
      XN4(L,NY,NX)=XN4(L,NY,NX)+TRXN4(L,NY,NX)
      XNB(L,NY,NX)=XNB(L,NY,NX)+TRXNB(L,NY,NX)
      XOH0(L,NY,NX)=XOH0(L,NY,NX)+TRXH0(L,NY,NX)
      XOH1(L,NY,NX)=XOH1(L,NY,NX)+TRXH1(L,NY,NX)
      XOH2(L,NY,NX)=XOH2(L,NY,NX)+TRXH2(L,NY,NX)
      XH1P(L,NY,NX)=XH1P(L,NY,NX)+TRX1P(L,NY,NX)
      XH2P(L,NY,NX)=XH2P(L,NY,NX)+TRX2P(L,NY,NX)
      XOH0B(L,NY,NX)=XOH0B(L,NY,NX)+TRBH0(L,NY,NX)
      XOH1B(L,NY,NX)=XOH1B(L,NY,NX)+TRBH1(L,NY,NX)
      XOH2B(L,NY,NX)=XOH2B(L,NY,NX)+TRBH2(L,NY,NX)
      XH1PB(L,NY,NX)=XH1PB(L,NY,NX)+TRB1P(L,NY,NX)
      XH2PB(L,NY,NX)=XH2PB(L,NY,NX)+TRB2P(L,NY,NX)
C
C     PRECIPITATES FROM PRECIPITATION-DISSOLUTION REACTIONS
C
      PALPO(L,NY,NX)=PALPO(L,NY,NX)+TRALPO(L,NY,NX)
      PFEPO(L,NY,NX)=PFEPO(L,NY,NX)+TRFEPO(L,NY,NX)
      PCAPD(L,NY,NX)=PCAPD(L,NY,NX)+TRCAPD(L,NY,NX)
      PCAPH(L,NY,NX)=PCAPH(L,NY,NX)+TRCAPH(L,NY,NX)
      PCAPM(L,NY,NX)=PCAPM(L,NY,NX)+TRCAPM(L,NY,NX)
      PALPB(L,NY,NX)=PALPB(L,NY,NX)+TRALPB(L,NY,NX)
      PFEPB(L,NY,NX)=PFEPB(L,NY,NX)+TRFEPB(L,NY,NX)
      PCPDB(L,NY,NX)=PCPDB(L,NY,NX)+TRCPDB(L,NY,NX)
      PCPHB(L,NY,NX)=PCPHB(L,NY,NX)+TRCPHB(L,NY,NX)
      PCPMB(L,NY,NX)=PCPMB(L,NY,NX)+TRCPMB(L,NY,NX)
C
C     MACROPORE SOLUTES FROM MACROPORE-MICROPORE EXCHANGE
C
      CO2SH(L,NY,NX)=CO2SH(L,NY,NX)+TCOFHS(L,NY,NX)-XCOFXS(L,NY,NX)
      CH4SH(L,NY,NX)=CH4SH(L,NY,NX)+TCHFHS(L,NY,NX)-XCHFXS(L,NY,NX)
      OXYSH(L,NY,NX)=OXYSH(L,NY,NX)+TOXFHS(L,NY,NX)-XOXFXS(L,NY,NX)
      Z2GSH(L,NY,NX)=Z2GSH(L,NY,NX)+TNGFHS(L,NY,NX)-XNGFXS(L,NY,NX)
      Z2OSH(L,NY,NX)=Z2OSH(L,NY,NX)+TN2FHS(L,NY,NX)-XN2FXS(L,NY,NX)
      H2GSH(L,NY,NX)=H2GSH(L,NY,NX)+THGFHS(L,NY,NX)-XHGFXS(L,NY,NX)
      ZNH4SH(L,NY,NX)=ZNH4SH(L,NY,NX)+TN4FHS(L,NY,NX)-XN4FXW(L,NY,NX)
      ZNH3SH(L,NY,NX)=ZNH3SH(L,NY,NX)+TN3FHS(L,NY,NX)-XN3FXW(L,NY,NX)
      ZNO3SH(L,NY,NX)=ZNO3SH(L,NY,NX)+TNOFHS(L,NY,NX)-XNOFXW(L,NY,NX)
      ZNO2SH(L,NY,NX)=ZNO2SH(L,NY,NX)+TNXFHS(L,NY,NX)-XNXFXS(L,NY,NX)
      H2PO4H(L,NY,NX)=H2PO4H(L,NY,NX)+TPOFHS(L,NY,NX)-XH2PXS(L,NY,NX)
      ZNH4BH(L,NY,NX)=ZNH4BH(L,NY,NX)+TN4FHB(L,NY,NX)-XN4FXB(L,NY,NX)
      ZNH3BH(L,NY,NX)=ZNH3BH(L,NY,NX)+TN3FHB(L,NY,NX)-XN3FXB(L,NY,NX)
      ZNO3BH(L,NY,NX)=ZNO3BH(L,NY,NX)+TNOFHB(L,NY,NX)-XNOFXB(L,NY,NX)
      ZNO2BH(L,NY,NX)=ZNO2BH(L,NY,NX)+TNXFHB(L,NY,NX)-XNXFXB(L,NY,NX)
      H2POBH(L,NY,NX)=H2POBH(L,NY,NX)+TH2BHB(L,NY,NX)-XH2BXB(L,NY,NX)
C     IF(NX.EQ.1)THEN
C     WRITE(*,4747)'ZNO3SH',I,J,NX,NY,L,ZNO3SH(L,NY,NX)
C    2,TNOFHS(L,NY,NX),XNOFXW(L,NY,NX)
C    3,ZNO2SH(L,NY,NX),TNXFHS(L,NY,NX),XNXFXS(L,NY,NX)
4747  FORMAT(A8,5I4,12E12.4)
C     ENDIF
C
C     GASES FROM VOLATILIZATION-DISSOLUTION AND GAS TRANSFER
C
      CO2G(L,NY,NX)=CO2G(L,NY,NX)+TCOFLG(L,NY,NX)-XCODFG(L,NY,NX)
      CH4G(L,NY,NX)=CH4G(L,NY,NX)+TCHFLG(L,NY,NX)-XCHDFG(L,NY,NX)
      OXYG(L,NY,NX)=OXYG(L,NY,NX)+TOXFLG(L,NY,NX)-XOXDFG(L,NY,NX)
      Z2GG(L,NY,NX)=Z2GG(L,NY,NX)+TNGFLG(L,NY,NX)-XNGDFG(L,NY,NX)
      Z2OG(L,NY,NX)=Z2OG(L,NY,NX)+TN2FLG(L,NY,NX)-XN2DFG(L,NY,NX)
      ZNH3G(L,NY,NX)=ZNH3G(L,NY,NX)+TNHFLG(L,NY,NX)-XN3DFG(L,NY,NX)
     2-XNBDFG(L,NY,NX)+TRN3G(L,NY,NX)
      H2GG(L,NY,NX)=H2GG(L,NY,NX)+THGFLG(L,NY,NX)-XHGDFG(L,NY,NX)
      ROXYF(L,NY,NX)=TOXFLG(L,NY,NX)
      RCO2F(L,NY,NX)=TCOFLG(L,NY,NX)
      RCH4F(L,NY,NX)=TCHFLG(L,NY,NX)
      ROXYL(L,NY,NX)=TOXFLS(L,NY,NX)+ROXFLU(L,NY,NX)+XOXFXS(L,NY,NX)
     2+XOXBBL(L,NY,NX)
      RCH4L(L,NY,NX)=TCHFLS(L,NY,NX)+RCHFLU(L,NY,NX)+XCHFXS(L,NY,NX) 
     2+XCHBBL(L,NY,NX)
C     IF(NX.EQ.3.AND.NY.EQ.4)THEN
C     WRITE(*,5432)'CO2G',I,J,NX,NY,L,CO2G(L,NY,NX),TCOFLG(L,NY,NX)
C    2,XCODFG(L,NY,NX),THETP(L,NY,NX)
C     WRITE(*,5432)'OXYG',I,J,NX,NY,L,OXYG(L,NY,NX),TOXFLG(L,NY,NX)
C    2,XOXDFG(L,NY,NX),COXYG(L,NY,NX),XOXFLG(3,L,NY,NX)
C    3,XOXFLG(3,L+1,NY,NX)
C     WRITE(*,5432)'CH4G',I,J,NX,NY,L,CH4G(L,NY,NX),TCHFLG(L,NY,NX)
C    2,XCHDFG(L,NY,NX),CCH4G(L,NY,NX),XCHFLG(3,L,NY,NX)
C    3,XCHFLG(3,L+1,NY,NX),XCHDFS(NY,NX),RCH4F(L,NY,NX)
C    4,RCH4L(L,NY,NX)
C     ENDIF
C
C     SALT SOLUTES IFROM EQUILIBRIUM REACTIONS, MICROPORE-MACROPORE
C     EXCHANGE, AQUEOUS FLUXES
C
      IF(ISALT(NY,NX).NE.0)THEN
      XZHYU=0.0714*(TUPNH4(L,NY,NX)+TUPNHB(L,NY,NX))
      XZOHU=0.0714*(TUPNO3(L,NY,NX)+TUPNOB(L,NY,NX))
      ZAL(L,NY,NX)=ZAL(L,NY,NX)+TRAL(L,NY,NX)+TALFLS(L,NY,NX)
     2+RALFLU(L,NY,NX)+XALFXS(L,NY,NX)
      ZFE(L,NY,NX)=ZFE(L,NY,NX)+TRFE(L,NY,NX)+TFEFLS(L,NY,NX)
     2+RFEFLU(L,NY,NX)+XFEFXS(L,NY,NX)
      ZHY(L,NY,NX)=ZHY(L,NY,NX)+TRHY(L,NY,NX)+THYFLS(L,NY,NX)
     2+RHYFLU(L,NY,NX)+XHYFXS(L,NY,NX)+XZHYS(L,NY,NX)+XZHYU
      ZCA(L,NY,NX)=ZCA(L,NY,NX)+TRCA(L,NY,NX)+TCAFLS(L,NY,NX)
     2+RCAFLU(L,NY,NX)+XCAFXS(L,NY,NX)
      ZMG(L,NY,NX)=ZMG(L,NY,NX)+TRMG(L,NY,NX)+TMGFLS(L,NY,NX)
     2+RMGFLU(L,NY,NX)+XMGFXS(L,NY,NX)
      ZNA(L,NY,NX)=ZNA(L,NY,NX)+TRNA(L,NY,NX)+TNAFLS(L,NY,NX)
     2+RNAFLU(L,NY,NX)+XNAFXS(L,NY,NX)
      ZKA(L,NY,NX)=ZKA(L,NY,NX)+TRKA(L,NY,NX)+TKAFLS(L,NY,NX)
     2+RKAFLU(L,NY,NX)+XKAFXS(L,NY,NX)
      ZOH(L,NY,NX)=ZOH(L,NY,NX)+TROH(L,NY,NX)+TOHFLS(L,NY,NX)
     2+ROHFLU(L,NY,NX)+XOHFXS(L,NY,NX)+XZOHU
      ZSO4(L,NY,NX)=ZSO4(L,NY,NX)+TRSO4(L,NY,NX)+TSOFLS(L,NY,NX)
     2+RSOFLU(L,NY,NX)+XSOFXS(L,NY,NX)
      ZCL(L,NY,NX)=ZCL(L,NY,NX)+TCLFLS(L,NY,NX)+RCLFLU(L,NY,NX)
     2+XCLFXS(L,NY,NX)
      ZCO3(L,NY,NX)=ZCO3(L,NY,NX)+TRCO3(L,NY,NX)+TC3FLS(L,NY,NX)
     2+XC3FXS(L,NY,NX)
      ZHCO3(L,NY,NX)=ZHCO3(L,NY,NX)+TRHCO(L,NY,NX)+THCFLS(L,NY,NX)
     2+XHCFXS(L,NY,NX)
      ZALOH1(L,NY,NX)=ZALOH1(L,NY,NX)+TRAL1(L,NY,NX)+TAL1FS(L,NY,NX)
     2+XAL1XS(L,NY,NX)
      ZALOH2(L,NY,NX)=ZALOH2(L,NY,NX)+TRAL2(L,NY,NX)+TAL2FS(L,NY,NX)
     2+XAL2XS(L,NY,NX)
      ZALOH3(L,NY,NX)=ZALOH3(L,NY,NX)+TRAL3(L,NY,NX)+TAL3FS(L,NY,NX)
     2+XAL3XS(L,NY,NX)
      ZALOH4(L,NY,NX)=ZALOH4(L,NY,NX)+TRAL4(L,NY,NX)+TAL4FS(L,NY,NX)
     2+XAL4XS(L,NY,NX)
      ZALS(L,NY,NX)=ZALS(L,NY,NX)+TRALS(L,NY,NX)+TALSFS(L,NY,NX)
     2+XALSXS(L,NY,NX)
      ZFEOH1(L,NY,NX)=ZFEOH1(L,NY,NX)+TRFE1(L,NY,NX)+TFE1FS(L,NY,NX)
     2+XFE1XS(L,NY,NX)
      ZFEOH2(L,NY,NX)=ZFEOH2(L,NY,NX)+TRFE2(L,NY,NX)+TFE2FS(L,NY,NX)
     2+XFE2XS(L,NY,NX)
      ZFEOH3(L,NY,NX)=ZFEOH3(L,NY,NX)+TRFE3(L,NY,NX)+TFE3FS(L,NY,NX)
     2+XFE3XS(L,NY,NX)
      ZFEOH4(L,NY,NX)=ZFEOH4(L,NY,NX)+TRFE4(L,NY,NX)+TFE4FS(L,NY,NX)
     2+XFE4XS(L,NY,NX)
      ZFES(L,NY,NX)=ZFES(L,NY,NX)+TRFES(L,NY,NX)+TFESFS(L,NY,NX)
     2+XFESXS(L,NY,NX)
      ZCAO(L,NY,NX)=ZCAO(L,NY,NX)+TRCAO(L,NY,NX)+TCAOFS(L,NY,NX)
     2+XCAOXS(L,NY,NX)
      ZCAC(L,NY,NX)=ZCAC(L,NY,NX)+TRCAC(L,NY,NX)+TCACFS(L,NY,NX)
     2+XCACXS(L,NY,NX)
      ZCAH(L,NY,NX)=ZCAH(L,NY,NX)+TRCAH(L,NY,NX)+TCAHFS(L,NY,NX)
     2+XCAHXS(L,NY,NX)
      ZCAS(L,NY,NX)=ZCAS(L,NY,NX)+TRCAS(L,NY,NX)+TCASFS(L,NY,NX)
     2+XCASXS(L,NY,NX)
      ZMGO(L,NY,NX)=ZMGO(L,NY,NX)+TRMGO(L,NY,NX)+TMGOFS(L,NY,NX)
     2+XMGOXS(L,NY,NX)
      ZMGC(L,NY,NX)=ZMGC(L,NY,NX)+TRMGC(L,NY,NX)+TMGCFS(L,NY,NX)
     2+XMGCXS(L,NY,NX)
      ZMGH(L,NY,NX)=ZMGH(L,NY,NX)+TRMGH(L,NY,NX)+TMGHFS(L,NY,NX)
     2+XMGHXS(L,NY,NX)
      ZMGS(L,NY,NX)=ZMGS(L,NY,NX)+TRMGS(L,NY,NX)+TMGSFS(L,NY,NX)
     2+XMGSXS(L,NY,NX)
      ZNAC(L,NY,NX)=ZNAC(L,NY,NX)+TRNAC(L,NY,NX)+TNACFS(L,NY,NX)
     2+XNACXS(L,NY,NX)
      ZNAS(L,NY,NX)=ZNAS(L,NY,NX)+TRNAS(L,NY,NX)+TNASFS(L,NY,NX)
     2+XNASXS(L,NY,NX)
      ZKAS(L,NY,NX)=ZKAS(L,NY,NX)+TRKAS(L,NY,NX)+TKASFS(L,NY,NX)
     2+XKASXS(L,NY,NX)
      H0PO4(L,NY,NX)=H0PO4(L,NY,NX)+TRH0P(L,NY,NX)+TH0PFS(L,NY,NX)
     2+XH0PXS(L,NY,NX)
      H1PO4(L,NY,NX)=H1PO4(L,NY,NX)+TRH1P(L,NY,NX)+TH1PFS(L,NY,NX)
     2+XH1PXS(L,NY,NX)
      H3PO4(L,NY,NX)=H3PO4(L,NY,NX)+TRH3P(L,NY,NX)+TH3PFS(L,NY,NX)
     2+XH3PXS(L,NY,NX)
      ZFE1P(L,NY,NX)=ZFE1P(L,NY,NX)+TRF1P(L,NY,NX)+TF1PFS(L,NY,NX)
     2+XF1PXS(L,NY,NX)
      ZFE2P(L,NY,NX)=ZFE2P(L,NY,NX)+TRF2P(L,NY,NX)+TF2PFS(L,NY,NX)
     2+XF2PXS(L,NY,NX)
      ZCA0P(L,NY,NX)=ZCA0P(L,NY,NX)+TRC0P(L,NY,NX)+TC0PFS(L,NY,NX)
     2+XC0PXS(L,NY,NX)
      ZCA1P(L,NY,NX)=ZCA1P(L,NY,NX)+TRC1P(L,NY,NX)+TC1PFS(L,NY,NX)
     2+XC1PXS(L,NY,NX)
      ZCA2P(L,NY,NX)=ZCA2P(L,NY,NX)+TRC2P(L,NY,NX)+TC2PFS(L,NY,NX)
     2+XC2PXS(L,NY,NX)
      ZMG1P(L,NY,NX)=ZMG1P(L,NY,NX)+TRM1P(L,NY,NX)+TM1PFS(L,NY,NX)
     2+XM1PXS(L,NY,NX)
      H0POB(L,NY,NX)=H0POB(L,NY,NX)+TRH0B(L,NY,NX)+TH0BFB(L,NY,NX)
     2+XH0BXB(L,NY,NX)
      H1POB(L,NY,NX)=H1POB(L,NY,NX)+TRH1B(L,NY,NX)+TH1BFB(L,NY,NX)
     2+XH1BXB(L,NY,NX)
      H3POB(L,NY,NX)=H3POB(L,NY,NX)+TRH3B(L,NY,NX)+TH3BFB(L,NY,NX)
     2+XH3BXB(L,NY,NX)
      ZFE1PB(L,NY,NX)=ZFE1PB(L,NY,NX)+TRF1B(L,NY,NX)+TF1BFB(L,NY,NX)
     2+XF1BXB(L,NY,NX)
      ZFE2PB(L,NY,NX)=ZFE2PB(L,NY,NX)+TRF2B(L,NY,NX)+TF2BFB(L,NY,NX)
     2+XF2BXB(L,NY,NX)
      ZCA0PB(L,NY,NX)=ZCA0PB(L,NY,NX)+TRC0B(L,NY,NX)+TC0BFB(L,NY,NX)
     2+XC0BXB(L,NY,NX)
      ZCA1PB(L,NY,NX)=ZCA1PB(L,NY,NX)+TRC1B(L,NY,NX)+TC1BFB(L,NY,NX)
     2+XC1BXB(L,NY,NX)
      ZCA2PB(L,NY,NX)=ZCA2PB(L,NY,NX)+TRC2B(L,NY,NX)+TC2BFB(L,NY,NX)
     2+XC2BXB(L,NY,NX)
      ZMG1PB(L,NY,NX)=ZMG1PB(L,NY,NX)+TRM1B(L,NY,NX)+TM1BFB(L,NY,NX)
     2+XM1BXB(L,NY,NX)
      ZALH(L,NY,NX)=ZALH(L,NY,NX)+TALFHS(L,NY,NX)-XALFXS(L,NY,NX)
      ZFEH(L,NY,NX)=ZFEH(L,NY,NX)+TFEFHS(L,NY,NX)-XFEFXS(L,NY,NX)
      ZHYH(L,NY,NX)=ZHYH(L,NY,NX)+THYFHS(L,NY,NX)-XHYFXS(L,NY,NX)
      ZCCH(L,NY,NX)=ZCCH(L,NY,NX)+TCAFHS(L,NY,NX)-XCAFXS(L,NY,NX)
      ZMAH(L,NY,NX)=ZMAH(L,NY,NX)+TMGFHS(L,NY,NX)-XMGFXS(L,NY,NX)
      ZNAH(L,NY,NX)=ZNAH(L,NY,NX)+TNAFHS(L,NY,NX)-XNAFXS(L,NY,NX)
      ZKAH(L,NY,NX)=ZKAH(L,NY,NX)+TKAFHS(L,NY,NX)-XKAFXS(L,NY,NX)
      ZOHH(L,NY,NX)=ZOHH(L,NY,NX)+TOHFHS(L,NY,NX)-XOHFXS(L,NY,NX)
      ZSO4H(L,NY,NX)=ZSO4H(L,NY,NX)+TSOFHS(L,NY,NX)-XSOFXS(L,NY,NX)
      ZCLH(L,NY,NX)=ZCLH(L,NY,NX)+TCLFHS(L,NY,NX)-XCLFXS(L,NY,NX)
      ZCO3H(L,NY,NX)=ZCO3H(L,NY,NX)+TC3FHS(L,NY,NX)-XC3FXS(L,NY,NX)
      ZHCO3H(L,NY,NX)=ZHCO3H(L,NY,NX)+THCFHS(L,NY,NX)-XHCFXS(L,NY,NX)
      ZALO1H(L,NY,NX)=ZALO1H(L,NY,NX)+TAL1HS(L,NY,NX)-XAL1XS(L,NY,NX)
      ZALO2H(L,NY,NX)=ZALO2H(L,NY,NX)+TAL2HS(L,NY,NX)-XAL2XS(L,NY,NX)
      ZALO3H(L,NY,NX)=ZALO3H(L,NY,NX)+TAL3HS(L,NY,NX)-XAL3XS(L,NY,NX)
      ZALO4H(L,NY,NX)=ZALO4H(L,NY,NX)+TAL4HS(L,NY,NX)-XAL4XS(L,NY,NX)
      ZALSH(L,NY,NX)=ZALSH(L,NY,NX)+TALSHS(L,NY,NX)-XALSXS(L,NY,NX)
      ZFEO1H(L,NY,NX)=ZFEO1H(L,NY,NX)+TFE1HS(L,NY,NX)-XFE1XS(L,NY,NX)
      ZFEO2H(L,NY,NX)=ZFEO2H(L,NY,NX)+TFE2HS(L,NY,NX)-XFE2XS(L,NY,NX)
      ZFEO3H(L,NY,NX)=ZFEO3H(L,NY,NX)+TFE3HS(L,NY,NX)-XFE3XS(L,NY,NX)
      ZFEO4H(L,NY,NX)=ZFEO4H(L,NY,NX)+TFE4HS(L,NY,NX)-XFE4XS(L,NY,NX)
      ZFESH(L,NY,NX)=ZFESH(L,NY,NX)+TFESHS(L,NY,NX)-XFESXS(L,NY,NX)
      ZCAOH(L,NY,NX)=ZCAOH(L,NY,NX)+TCAOHS(L,NY,NX)-XCAOXS(L,NY,NX)
      ZCACH(L,NY,NX)=ZCACH(L,NY,NX)+TCACHS(L,NY,NX)-XCACXS(L,NY,NX)
      ZCAHH(L,NY,NX)=ZCAHH(L,NY,NX)+TCAHHS(L,NY,NX)-XCAHXS(L,NY,NX)
      ZCASH(L,NY,NX)=ZCASH(L,NY,NX)+TCASHS(L,NY,NX)-XCASXS(L,NY,NX)
      ZMGOH(L,NY,NX)=ZMGOH(L,NY,NX)+TMGOHS(L,NY,NX)-XMGOXS(L,NY,NX)
      ZMGCH(L,NY,NX)=ZMGCH(L,NY,NX)+TMGCHS(L,NY,NX)-XMGCXS(L,NY,NX)
      ZMGHH(L,NY,NX)=ZMGHH(L,NY,NX)+TMGHHS(L,NY,NX)-XMGHXS(L,NY,NX)
      ZMGSH(L,NY,NX)=ZMGSH(L,NY,NX)+TMGSHS(L,NY,NX)-XMGSXS(L,NY,NX)
      ZNACH(L,NY,NX)=ZNACH(L,NY,NX)+TNACHS(L,NY,NX)-XNACXS(L,NY,NX)
      ZNASH(L,NY,NX)=ZNASH(L,NY,NX)+TNASHS(L,NY,NX)-XNASXS(L,NY,NX)
      ZKASH(L,NY,NX)=ZKASH(L,NY,NX)+TKASHS(L,NY,NX)-XKASXS(L,NY,NX)
      H0PO4H(L,NY,NX)=H0PO4H(L,NY,NX)+TH0PHS(L,NY,NX)-XH0PXS(L,NY,NX)
      H1PO4H(L,NY,NX)=H1PO4H(L,NY,NX)+TH1PHS(L,NY,NX)-XH1PXS(L,NY,NX)
      H3PO4H(L,NY,NX)=H3PO4H(L,NY,NX)+TH3PHS(L,NY,NX)-XH3PXS(L,NY,NX)
      ZFE1PH(L,NY,NX)=ZFE1PH(L,NY,NX)+TF1PHS(L,NY,NX)-XF1PXS(L,NY,NX)
      ZFE2PH(L,NY,NX)=ZFE2PH(L,NY,NX)+TF2PHS(L,NY,NX)-XF2PXS(L,NY,NX)
      ZCA0PH(L,NY,NX)=ZCA0PH(L,NY,NX)+TC0PHS(L,NY,NX)-XC0PXS(L,NY,NX)
      ZCA1PH(L,NY,NX)=ZCA1PH(L,NY,NX)+TC1PHS(L,NY,NX)-XC1PXS(L,NY,NX)
      ZCA2PH(L,NY,NX)=ZCA2PH(L,NY,NX)+TC2PHS(L,NY,NX)-XC2PXS(L,NY,NX)
      ZMG1PH(L,NY,NX)=ZMG1PH(L,NY,NX)+TM1PHS(L,NY,NX)-XM1PXS(L,NY,NX)
      H0POBH(L,NY,NX)=H0POBH(L,NY,NX)+TH0BHB(L,NY,NX)-XH0BXB(L,NY,NX)
      H1POBH(L,NY,NX)=H1POBH(L,NY,NX)+TH1BHB(L,NY,NX)-XH1BXB(L,NY,NX)
      H3POBH(L,NY,NX)=H3POBH(L,NY,NX)+TH3BHB(L,NY,NX)-XH3BXB(L,NY,NX)
      ZFE1BH(L,NY,NX)=ZFE1BH(L,NY,NX)+TF1BHB(L,NY,NX)-XF1BXB(L,NY,NX)
      ZFE2BH(L,NY,NX)=ZFE2BH(L,NY,NX)+TF2BHB(L,NY,NX)-XF2BXB(L,NY,NX)
      ZCA0BH(L,NY,NX)=ZCA0BH(L,NY,NX)+TC0BHB(L,NY,NX)-XC0BXB(L,NY,NX)
      ZCA1BH(L,NY,NX)=ZCA1BH(L,NY,NX)+TC1BHB(L,NY,NX)-XC1BXB(L,NY,NX)
      ZCA2BH(L,NY,NX)=ZCA2BH(L,NY,NX)+TC2BHB(L,NY,NX)-XC2BXB(L,NY,NX)
      ZMG1BH(L,NY,NX)=ZMG1BH(L,NY,NX)+TM1BHB(L,NY,NX)-XM1BXB(L,NY,NX)
      XHY(L,NY,NX)=XHY(L,NY,NX)+TRXHY(L,NY,NX)
      XAL(L,NY,NX)=XAL(L,NY,NX)+TRXAL(L,NY,NX)
      XCA(L,NY,NX)=XCA(L,NY,NX)+TRXCA(L,NY,NX)
      XMG(L,NY,NX)=XMG(L,NY,NX)+TRXMG(L,NY,NX)
      XNA(L,NY,NX)=XNA(L,NY,NX)+TRXNA(L,NY,NX)
      XKA(L,NY,NX)=XKA(L,NY,NX)+TRXKA(L,NY,NX)
      XHC(L,NY,NX)=XHC(L,NY,NX)+TRXHC(L,NY,NX)
      XALO2(L,NY,NX)=XALO2(L,NY,NX)+TRXAL2(L,NY,NX)
      PALOH(L,NY,NX)=PALOH(L,NY,NX)+TRALOH(L,NY,NX)
      PFEOH(L,NY,NX)=PFEOH(L,NY,NX)+TRFEOH(L,NY,NX)
      PCACO(L,NY,NX)=PCACO(L,NY,NX)+TRCACO(L,NY,NX)
      PCASO(L,NY,NX)=PCASO(L,NY,NX)+TRCASO(L,NY,NX)
      ELSE
      XZHYS(L,NY,NX)=0.0
      XZHYU=0.0
      XZOHU=0.0
      ENDIF
C
C     GRID CELL BOUNDARY FLUXES FROM ROOT GAS TRANSFER
C
      VOLWOU=VOLWOU-18.0E-06*TRH2O(L,NY,NX)
      HEATIN=HEATIN+THTHAW(L,NY,NX)+TUPHT(L,NY,NX)
      CI=TCOFLA(L,NY,NX)
      CH=TCHFLA(L,NY,NX)
      OI=TOXFLA(L,NY,NX)
      ZGI=0.0
      Z2I=TN2FLA(L,NY,NX)
      ZHI=TNHFLA(L,NY,NX)
      TI=THGFLA(L,NY,NX)
C
C     GRID CELL BOUNDARY FLUXES BUBBLING
C
      IF(LG.EQ.0)THEN
      CI=CI+XCOBBL(L,NY,NX)
      CH=CH+XCHBBL(L,NY,NX)
      OI=OI+XOXBBL(L,NY,NX)
      ZGI=ZGI+XNGBBL(L,NY,NX)
      Z2I=Z2I+XN2BBL(L,NY,NX)
      ZHI=ZHI+XN3BBL(L,NY,NX)+XNBBBL(L,NY,NX)
      TI=TI+XHGBBL(L,NY,NX)
      ELSE
      LL=MIN(L,LG)
      CO2G(LL,NY,NX)=CO2G(LL,NY,NX)-XCOBBL(L,NY,NX)
      CH4G(LL,NY,NX)=CH4G(LL,NY,NX)-XCHBBL(L,NY,NX)
      OXYG(LL,NY,NX)=OXYG(LL,NY,NX)-XOXBBL(L,NY,NX)
      Z2GG(LL,NY,NX)=Z2GG(LL,NY,NX)-XNGBBL(L,NY,NX)
      Z2OG(LL,NY,NX)=Z2OG(LL,NY,NX)-XN2BBL(L,NY,NX)
      ZNH3G(LL,NY,NX)=ZNH3G(LL,NY,NX)-XN3BBL(L,NY,NX)-XNBBBL(L,NY,NX)
      H2GG(LL,NY,NX)=H2GG(LL,NY,NX)-XHGBBL(L,NY,NX)
      IF(LG.LT.L)THEN
      TLCO2G=TLCO2G-XCOBBL(L,NY,NX)-XCHBBL(L,NY,NX)
      UCO2S(NY,NX)=UCO2S(NY,NX)-XCOBBL(L,NY,NX)-XCHBBL(L,NY,NX)
      OXYGSO=OXYGSO-XOXBBL(L,NY,NX)
      TLN2G=TLN2G-XNGBBL(L,NY,NX)-XN2BBL(L,NY,NX)
     2-XN3BBL(L,NY,NX)-XNBBBL(L,NY,NX)
      TION=TION-XHGBBL(L,NY,NX)
      ENDIF
      ENDIF
      CO2GIN=CO2GIN+CI+CH
      CO=TCO2P(L,NY,NX)+TCO2S(L,NY,NX)-TRCO2(L,NY,NX)
      HCO2G(NY,NX)=HCO2G(NY,NX)+CI
      UCO2G(NY,NX)=UCO2G(NY,NX)+CI
      HCH4G(NY,NX)=HCH4G(NY,NX)+CH
      UCH4G(NY,NX)=UCH4G(NY,NX)+CH
      TCOU=TCOU+CO
      UCOP(NY,NX)=UCOP(NY,NX)+TCO2P(L,NY,NX)+TCO2S(L,NY,NX)
      UDICD(NY,NX)=UDICD(NY,NX)-TRCO2(L,NY,NX)
      TNBP(NY,NX)=TNBP(NY,NX)+CH+TRCO2(L,NY,NX)
      OXYGIN=OXYGIN+OI
      OO=RUPOXO(L,NY,NX)+TUPOXP(L,NY,NX)+TUPOXS(L,NY,NX)
      UOXYG(NY,NX)=UOXYG(NY,NX)+OI
      HOXYG(NY,NX)=HOXYG(NY,NX)+OI
      OXYGOU=OXYGOU+OO
      ZN2GIN=ZN2GIN+ZGI+Z2I+ZHI
C     UN2GG(NY,NX)=UN2GG(NY,NX)+ZGI
C     HN2GG(NY,NX)=HN2GG(NY,NX)+ZGI
      UN2OG(NY,NX)=UN2OG(NY,NX)+Z2I
      HN2OG(NY,NX)=HN2OG(NY,NX)+Z2I
      UNH3G(NY,NX)=UNH3G(NY,NX)+ZHI
      HNH3G(NY,NX)=HNH3G(NY,NX)+ZHI
      UH2GG(NY,NX)=UH2GG(NY,NX)+TI 
C     IF(NX.EQ.3.AND.NY.EQ.4)THEN
C     WRITE(*,6645)'PLT',I,J,NX,NY,L,LG,LL,HCH4G(NY,NX),CH
C    2,TCHFLA(L,NY,NX),XCHBBL(L,NY,NX),HOXYG(NY,NX),OI
C    3,XOXBBL(L,NY,NX),TUPOXP(L,NY,NX),TUPOXS(L,NY,NX)
C    4,TOXFLA(L,NY,NX)
C    4,HCO2G(NY,NX),CI,TCOFLA(L,NY,NX),XCOBBL(L,NY,NX)
C    2,UN2GG(NY,NX),ZGI,XNGBBL(L,NY,NX)
C    5,TN2FLA(L,NY,NX),TNHFLA(L,NY,NX),THGFLA(L,NY,NX)
C    6,CH4G(LL,NY,NX)
6645  FORMAT(A8,7I4,30E12.4)
C     ENDIF
C
C     GRID CELL BOUNDARY FLUXES FROM EQUILIBRIUM REACTIONS
C
      TZOU=TZOU-14.0*(TBNH4(L,NY,NX)+TBNO3(L,NY,NX)+TBNH3(L,NY,NX))
      TPOU=TPOU-31.0*TBH2P(L,NY,NX)
      TIONIN=TIONIN+TI
      TO=2.0*TRH2O(L,NY,NX)+3.0*TBCO2(L,NY,NX)+2.0*TBNH4(L,NY,NX)
     2+TBNH3(L,NY,NX)+TBNO3(L,NY,NX)+3.0*TBH2P(L,NY,NX)-XZHYS(L,NY,NX)
     3+RH2GO(L,NY,NX)-XZHYU-XZOHU+TBION(L,NY,NX)
      TIONOU=TIONOU+TO
C     UIONOU(NY,NX)=UIONOU(NY,NX)+TO
C
C     GAS AND SOLUTE EXCHANGE WITHIN GRID CELL ADDED TO ECOSYSTEM

C     TOTALS FOR CALCULATING COMPETITION CONSTRAINTS ON MICROBIAL
C     AND ROOT POPULATIONS
C
      DO 7990 K=0,5
      DO 7980 N=1,7
      ROXYX(L,NY,NX)=ROXYX(L,NY,NX)+ROXYS(N,K,L,NY,NX)
      RNH4X(L,NY,NX)=RNH4X(L,NY,NX)+RVMX4(N,K,L,NY,NX)
     2+RINHO(N,K,L,NY,NX)
      RNO3X(L,NY,NX)=RNO3X(L,NY,NX)+RVMX3(N,K,L,NY,NX)
     2+RINOO(N,K,L,NY,NX)
      RNO2X(L,NY,NX)=RNO2X(L,NY,NX)+RVMX2(N,K,L,NY,NX)
      RN2OX(L,NY,NX)=RN2OX(L,NY,NX)+RVMX1(N,K,L,NY,NX)
      RPO4X(L,NY,NX)=RPO4X(L,NY,NX)+RIPOO(N,K,L,NY,NX)
      RNHBX(L,NY,NX)=RNHBX(L,NY,NX)+RVMB4(N,K,L,NY,NX)
     2+RINHB(N,K,L,NY,NX)
      RN3BX(L,NY,NX)=RN3BX(L,NY,NX)+RVMB3(N,K,L,NY,NX)
     2+RINOB(N,K,L,NY,NX)
      RN2BX(L,NY,NX)=RN2BX(L,NY,NX)+RVMB2(N,K,L,NY,NX)
      RPOBX(L,NY,NX)=RPOBX(L,NY,NX)+RIPOB(N,K,L,NY,NX)
      IF(K.LE.4)THEN
      ROQCX(K,L,NY,NX)=ROQCX(K,L,NY,NX)+ROQCS(N,K,L,NY,NX)
      ROQAX(K,L,NY,NX)=ROQAX(K,L,NY,NX)+ROQAS(N,K,L,NY,NX)
      ENDIF
7980  CONTINUE
7990  CONTINUE
      RNO2X(L,NY,NX)=RNO2X(L,NY,NX)+RVMXC(L,NY,NX)
      RN2BX(L,NY,NX)=RN2BX(L,NY,NX)+RVMBC(L,NY,NX)
C
C     GRID CELL VARIABLES NEEDED FOR WATER, C, N, P, O, SOLUTE AND
C     ENERGY BALANCES INCLUDING SUM OF ALL CURRENT STATE VARIABLES,
C     CUMULATIVE SUMS OF ALL ADDITIONS AND REMOVALS SINCE START OF RUN
C
C     IF(J.EQ.24)THEN
      WS=VOLW(L,NY,NX)+VOLWH(L,NY,NX)
     2+(VOLI(L,NY,NX)+VOLIH(L,NY,NX))*0.92
      VOLWSO=VOLWSO+WS
      UVOLW(NY,NX)=UVOLW(NY,NX)+WS
C    2-WP(L,NY,NX)*VOLX(L,NY,NX)
      HEATSO=HEATSO+VHCP(L,NY,NX)*TKS(L,NY,NX)
      SD=SAND(L,NY,NX)+SILT(L,NY,NX)+CLAY(L,NY,NX)
      TSEDSO=TSEDSO+SD
      CS=CO2G(L,NY,NX)+CO2S(L,NY,NX)+CO2SH(L,NY,NX)+TLCO2P(L,NY,NX)
     2+CH4G(L,NY,NX)+CH4S(L,NY,NX)+CH4SH(L,NY,NX)+TLCH4P(L,NY,NX)
      TLCO2G=TLCO2G+CS
      UCO2S(NY,NX)=UCO2S(NY,NX)+CS
C     IF(NX.EQ.1.AND.NY.EQ.1)THEN
C     WRITE(*,8642)'TLCO2G',I,J,L,TLCO2G,CS,CO2G(L,NY,NX),CO2S(L,NY,NX)
C    2,CO2SH(L,NY,NX),TLCO2P(L,NY,NX),CH4G(L,NY,NX),CH4S(L,NY,NX)
C    3,CH4SH(L,NY,NX),TLCH4P(L,NY,NX),UCO2S(NY,NX)
8642  FORMAT(A8,3I4,20F20.6)
C     ENDIF
      OS=OXYG(L,NY,NX)+OXYS(L,NY,NX)+OXYSH(L,NY,NX)+TLOXYP(L,NY,NX)
      OXYGSO=OXYGSO+OS
      ZG=Z2GG(L,NY,NX)+Z2GS(L,NY,NX)+Z2GSH(L,NY,NX)+TLN2OP(L,NY,NX)
     2+Z2OG(L,NY,NX)+Z2OS(L,NY,NX)+Z2OSH(L,NY,NX)+TLNH3P(L,NY,NX)
     3+ZNH3G(L,NY,NX)
      TLN2G=TLN2G+ZG
      ZNH=ZNH4S(L,NY,NX)+ZNH4SH(L,NY,NX)+ZNH4B(L,NY,NX)+ZNH4BH(L,NY,NX)
     2+ZNH3S(L,NY,NX)+ZNH3SH(L,NY,NX)+ZNH3B(L,NY,NX)+ZNH3BH(L,NY,NX)
      TLNH4=TLNH4+ZNH
      UNH4(NY,NX)=UNH4(NY,NX)+ZNH+14.0*(XN4(L,NY,NX)+XNB(L,NY,NX))
C     IF(NX.EQ.4)THEN
C     WRITE(*,5455)'XNH4L',I,J,NX,NY,L,UNH4(NY,NX),ZNH,XN4(L,NY,NX)
C    2,XNB(L,NY,NX),ZNH4S(L,NY,NX),ZNH4SH(L,NY,NX)
C    3,ZNH4B(L,NY,NX),ZNH4BH(L,NY,NX),ZNH3S(L,NY,NX),ZNH3SH(L,NY,NX)
C    4,ZNH3B(L,NY,NX),ZNH3BH(L,NY,NX)
5455  FORMAT(A8,5I4,30E12.4)
C     ENDIF
      ZNO=ZNO3S(L,NY,NX)+ZNO3SH(L,NY,NX)+ZNO3B(L,NY,NX)+ZNO3BH(L,NY,NX)
     2+ZNO2S(L,NY,NX)+ZNO2SH(L,NY,NX)+ZNO2B(L,NY,NX)+ZNO2BH(L,NY,NX)
      TLNO3=TLNO3+ZNO
      UNO3(NY,NX)=UNO3(NY,NX)+ZNO
      P4=H2PO4(L,NY,NX)+H2PO4H(L,NY,NX)+H2POB(L,NY,NX)+H2POBH(L,NY,NX)
      TLPO4=TLPO4+P4
      UPO4(NY,NX)=UPO4(NY,NX)+P4+31.0*(XH1P(L,NY,NX)+XH2P(L,NY,NX)
     2+XH1PB(L,NY,NX)+XH2PB(L,NY,NX))
      UPP4(NY,NX)=UPP4(NY,NX)+31.0*(PALPO(L,NY,NX)+PFEPO(L,NY,NX)
     2+PCAPD(L,NY,NX)+PALPB(L,NY,NX)+PFEPB(L,NY,NX)+PCPDB(L,NY,NX))
     3+93.0*(PCAPH(L,NY,NX)+PCPHB(L,NY,NX))
     4+62.0*(PCAPM(L,NY,NX)+PCPMB(L,NY,NX))
C
C     TOTAL SON,SON,SOP
C    
      RC=0.0
      RN=0.0
      RP=0.0
      OC=0.0
      ON=0.0
      OP=0.0
      OMCL(L,NY,NX)=0.0
      OMNL(L,NY,NX)=0.0
C      
C     ZM added
C
      OMCN1(L,NY,NX)=0.0
      OMCN2(L,NY,NX)=0.0
      OMCN3(L,NY,NX)=0.0
      OMCN4(L,NY,NX)=0.0
      OMCN5(L,NY,NX)=0.0
      OMCN6(L,NY,NX)=0.0
      OMCN7(L,NY,NX)=0.0
C      OMNN1(L,NY,NX)=0.0
C      OMNN2(L,NY,NX)=0.0
C      OMNN3(L,NY,NX)=0.0
C      OMNN4(L,NY,NX)=0.0
C      OMNN5(L,NY,NX)=0.0
C      OMNN6(L,NY,NX)=0.0
C      OMNN7(L,NY,NX)=0.0   
C      OMCNA1(L,NY,NX)=0.0
C      OMCNA2(L,NY,NX)=0.0
C      OMCNA3(L,NY,NX)=0.0
C      OMCNA5(L,NY,NX)=0.0
C      OMNNA1(L,NY,NX)=0.0
C      OMNNA2(L,NY,NX)=0.0
C      OMNNA3(L,NY,NX)=0.0
C      OMNNA5(L,NY,NX)=0.0
C  zm
C
      DO 7970 K=0,5
      IF(K.LE.2)THEN
      DO 7960 N=1,7
      DO 7960 M=1,3
      RC=RC+OMC(M,N,K,L,NY,NX)
      RN=RN+OMN(M,N,K,L,NY,NX)
      RP=RP+OMP(M,N,K,L,NY,NX)
      TOMT(NY,NX)=TOMT(NY,NX)+OMC(M,N,K,L,NY,NX)
      TONT(NY,NX)=TONT(NY,NX)+OMN(M,N,K,L,NY,NX)
      TOPT(NY,NX)=TOPT(NY,NX)+OMP(M,N,K,L,NY,NX)
      OMCL(L,NY,NX)=OMCL(L,NY,NX)+OMC(M,N,K,L,NY,NX)
      OMNL(L,NY,NX)=OMNL(L,NY,NX)+OMN(M,N,K,L,NY,NX)
C   
C ZM ADDED OMCN and OMNN for each microbial group
C
      OMCN1(L,NY,NX)=OMCN1(L,NY,NX)+OMC(M,1,K,L,NY,NX)
      OMCN2(L,NY,NX)=OMCN2(L,NY,NX)+OMC(M,2,K,L,NY,NX)
      OMCN3(L,NY,NX)=OMCN3(L,NY,NX)+OMC(M,3,K,L,NY,NX)
      OMCN4(L,NY,NX)=OMCN4(L,NY,NX)+OMC(M,4,K,L,NY,NX)
      OMCN5(L,NY,NX)=OMCN5(L,NY,NX)+OMC(M,5,K,L,NY,NX)
      OMCN6(L,NY,NX)=OMCN6(L,NY,NX)+OMC(M,6,K,L,NY,NX)
      OMCN7(L,NY,NX)=OMCN7(L,NY,NX)+OMC(M,7,K,L,NY,NX)
C      OMNN1(L,NY,NX)=OMNN1(L,NY,NX)+OMN(M,1,K,L,NY,NX)
C      OMNN2(L,NY,NX)=OMNN2(L,NY,NX)+OMN(M,2,K,L,NY,NX)
C      OMNN3(L,NY,NX)=OMNN3(L,NY,NX)+OMN(M,3,K,L,NY,NX)
C      OMNN4(L,NY,NX)=OMNN4(L,NY,NX)+OMN(M,4,K,L,NY,NX)
C      OMNN5(L,NY,NX)=OMNN5(L,NY,NX)+OMN(M,5,K,L,NY,NX)
C      OMNN6(L,NY,NX)=OMNN6(L,NY,NX)+OMN(M,6,K,L,NY,NX)
C      OMNN7(L,NY,NX)=OMNN7(L,NY,NX)+OMN(M,7,K,L,NY,NX)
C   
C      OMCNA1(L,NY,NX)=OMCNA1(L,NY,NX)+OMC(M,1,5,L,NY,NX)
C      OMCNA2(L,NY,NX)=OMCNA2(L,NY,NX)+OMC(M,2,5,L,NY,NX)
C      OMCNA3(L,NY,NX)=OMCNA3(L,NY,NX)+OMC(M,3,5,L,NY,NX)
C      OMCNA5(L,NY,NX)=OMCNA5(L,NY,NX)+OMC(M,4,5,L,NY,NX)
C      OMNNA1(L,NY,NX)=OMNNA1(L,NY,NX)+OMN(M,1,5,L,NY,NX)
C      OMNNA2(L,NY,NX)=OMNNA2(L,NY,NX)+OMN(M,2,5,L,NY,NX)
C      OMNNA3(L,NY,NX)=OMNNA3(L,NY,NX)+OMN(M,3,5,L,NY,NX)
C      OMNNA5(L,NY,NX)=OMNNA5(L,NY,NX)+OMN(M,4,5,L,NY,NX) 
C    zm
C
7960  CONTINUE
      ELSE
      DO 7950 N=1,7
      DO 7950 M=1,3
      OC=OC+OMC(M,N,K,L,NY,NX)
      ON=ON+OMN(M,N,K,L,NY,NX)
      OP=OP+OMP(M,N,K,L,NY,NX)
      TOMT(NY,NX)=TOMT(NY,NX)+OMC(M,N,K,L,NY,NX)
      TONT(NY,NX)=TONT(NY,NX)+OMN(M,N,K,L,NY,NX)
      TOPT(NY,NX)=TOPT(NY,NX)+OMP(M,N,K,L,NY,NX)
      OMCL(L,NY,NX)=OMCL(L,NY,NX)+OMC(M,N,K,L,NY,NX)
      OMNL(L,NY,NX)=OMNL(L,NY,NX)+OMN(M,N,K,L,NY,NX)
C
C ZM ADDED OMCN and OMNN for each microbial group
C
      OMCN1(L,NY,NX)=OMCN1(L,NY,NX)+OMC(M,1,K,L,NY,NX)
      OMCN2(L,NY,NX)=OMCN2(L,NY,NX)+OMC(M,2,K,L,NY,NX)
      OMCN3(L,NY,NX)=OMCN3(L,NY,NX)+OMC(M,3,K,L,NY,NX)
      OMCN4(L,NY,NX)=OMCN4(L,NY,NX)+OMC(M,4,K,L,NY,NX)
      OMCN5(L,NY,NX)=OMCN5(L,NY,NX)+OMC(M,5,K,L,NY,NX)
      OMCN6(L,NY,NX)=OMCN6(L,NY,NX)+OMC(M,6,K,L,NY,NX)
      OMCN7(L,NY,NX)=OMCN7(L,NY,NX)+OMC(M,7,K,L,NY,NX)
C      OMNN1(L,NY,NX)=OMNN1(L,NY,NX)+OMN(M,1,K,L,NY,NX)
C      OMNN2(L,NY,NX)=OMNN2(L,NY,NX)+OMN(M,2,K,L,NY,NX)
C      OMNN3(L,NY,NX)=OMNN3(L,NY,NX)+OMN(M,3,K,L,NY,NX)
C      OMNN4(L,NY,NX)=OMNN4(L,NY,NX)+OMN(M,4,K,L,NY,NX)
C      OMNN5(L,NY,NX)=OMNN5(L,NY,NX)+OMN(M,5,K,L,NY,NX)
C      OMNN6(L,NY,NX)=OMNN6(L,NY,NX)+OMN(M,6,K,L,NY,NX)
C      OMNN7(L,NY,NX)=OMNN7(L,NY,NX)+OMN(M,7,K,L,NY,NX)
C   
C      OMCNA1(L,NY,NX)=OMCNA1(L,NY,NX)+OMC(M,1,5,L,NY,NX)
C      OMCNA2(L,NY,NX)=OMCNA2(L,NY,NX)+OMC(M,2,5,L,NY,NX)
C      OMCNA3(L,NY,NX)=OMCNA3(L,NY,NX)+OMC(M,3,5,L,NY,NX)
C      OMCNA5(L,NY,NX)=OMCNA5(L,NY,NX)+OMC(M,4,5,L,NY,NX)
C      OMNNA1(L,NY,NX)=OMNNA1(L,NY,NX)+OMN(M,1,5,L,NY,NX)
C      OMNNA2(L,NY,NX)=OMNNA2(L,NY,NX)+OMN(M,2,5,L,NY,NX)
C      OMNNA3(L,NY,NX)=OMNNA3(L,NY,NX)+OMN(M,3,5,L,NY,NX)
C      OMNNA5(L,NY,NX)=OMNNA5(L,NY,NX)+OMN(M,4,5,L,NY,NX) 
C     zm
7950  CONTINUE
      ENDIF
7970  CONTINUE
      DO 7900 K=0,4
      IF(K.LE.2)THEN
      DO 7940 M=1,2
      RC=RC+ORC(M,K,L,NY,NX)
      RN=RN+ORN(M,K,L,NY,NX)
      RP=RP+ORP(M,K,L,NY,NX)
7940  CONTINUE
      RC=RC+OQC(K,L,NY,NX)+OQCH(K,L,NY,NX)+OHC(K,L,NY,NX)
     2+OQA(K,L,NY,NX)+OQAH(K,L,NY,NX)+OHA(K,L,NY,NX)
      RN=RN+OQN(K,L,NY,NX)+OQNH(K,L,NY,NX)+OHN(K,L,NY,NX)
      RP=RP+OQP(K,L,NY,NX)+OQPH(K,L,NY,NX)+OHP(K,L,NY,NX)
      DO 7930 M=1,4
      RC=RC+OSC(M,K,L,NY,NX)
      RN=RN+OSN(M,K,L,NY,NX)
      RP=RP+OSP(M,K,L,NY,NX)
7930  CONTINUE
      ELSE
      DO 7920 M=1,2
      OC=OC+ORC(M,K,L,NY,NX)
      ON=ON+ORN(M,K,L,NY,NX)
      OP=OP+ORP(M,K,L,NY,NX)
7920  CONTINUE
      OC=OC+OQC(K,L,NY,NX)+OQCH(K,L,NY,NX)+OHC(K,L,NY,NX)
     2+OQA(K,L,NY,NX)+OQAH(K,L,NY,NX)+OHA(K,L,NY,NX)
      ON=ON+OQN(K,L,NY,NX)+OQNH(K,L,NY,NX)+OHN(K,L,NY,NX)
      OP=OP+OQP(K,L,NY,NX)+OQPH(K,L,NY,NX)+OHP(K,L,NY,NX)
      DO 7910 M=1,4
      OC=OC+OSC(M,K,L,NY,NX)
      ON=ON+OSN(M,K,L,NY,NX)
      OP=OP+OSP(M,K,L,NY,NX)
7910  CONTINUE
      ENDIF
7900  CONTINUE
      ORGC(L,NY,NX)=RC+OC
      ORGN(L,NY,NX)=RN+ON
      ORGR(L,NY,NX)=RC
      TLRSDC=TLRSDC+RC
      URSDC(NY,NX)=URSDC(NY,NX)+RC
      TLRSDN=TLRSDN+RN
      URSDN(NY,NX)=URSDN(NY,NX)+RN
      TLRSDP=TLRSDP+RP
      URSDP(NY,NX)=URSDP(NY,NX)+RP
      TLORGC=TLORGC+OC
      UORGC(NY,NX)=UORGC(NY,NX)+OC
      TLORGN=TLORGN+ON
      UORGN(NY,NX)=UORGN(NY,NX)+ON
      TLORGP=TLORGP+OP
      UORGP(NY,NX)=UORGP(NY,NX)+OP
      TSEDSO=TSEDSO+(RC+OC)*1.0E-06
      TS=ZAL(L,NY,NX)+ZFE(L,NY,NX)+ZHY(L,NY,NX)+ZCA(L,NY,NX)
     2+ZMG(L,NY,NX)+ZNA(L,NY,NX)+ZKA(L,NY,NX)+ZOH(L,NY,NX)
     3+ZSO4(L,NY,NX)+ZCL(L,NY,NX)+ZCO3(L,NY,NX)+H0PO4(L,NY,NX)
     4+H0POB(L,NY,NX)+2.0*(ZHCO3(L,NY,NX)+ZALOH1(L,NY,NX)
     5+ZALS(L,NY,NX)+ZFEOH1(L,NY,NX)+ZFES(L,NY,NX)+ZCAO(L,NY,NX)
     6+ZCAC(L,NY,NX)+ZCAS(L,NY,NX)+ZMGO(L,NY,NX)+ZMGC(L,NY,NX)
     7+ZMGS(L,NY,NX)+ZNAC(L,NY,NX)+ZNAS(L,NY,NX)+ZKAS(L,NY,NX)
     8+H1PO4(L,NY,NX)+H1POB(L,NY,NX)+ZCA0P(L,NY,NX)+ZCA0PB(L,NY,NX))
     9+3.0*(ZALOH2(L,NY,NX)+ZFEOH2(L,NY,NX)+ZCAH(L,NY,NX)
     1+ZMGH(L,NY,NX)+ZFE1P(L,NY,NX)+ZCA1P(L,NY,NX)+ZMG1P(L,NY,NX)
     2+ZFE1PB(L,NY,NX)+ZCA1PB(L,NY,NX)+ZMG1PB(L,NY,NX))+4.0*
     3(ZALOH3(L,NY,NX)+ZFEOH3(L,NY,NX)+H3PO4(L,NY,NX)+ZFE2P(L,NY,NX)
     4+ZCA2P(L,NY,NX)+H3POB(L,NY,NX)+ZFE2PB(L,NY,NX)
     5+ZCA2PB(L,NY,NX))+5.0*(ZALOH4(L,NY,NX)+ZFEOH4(L,NY,NX))
      TH=ZALH(L,NY,NX)+ZFEH(L,NY,NX)+ZHYH(L,NY,NX)+ZCCH(L,NY,NX)
     2+ZMAH(L,NY,NX)+ZNAH(L,NY,NX)+ZKAH(L,NY,NX)+ZOHH(L,NY,NX)
     3+ZSO4H(L,NY,NX)+ZCLH(L,NY,NX)+ZCO3H(L,NY,NX)+H0PO4H(L,NY,NX)
     4+H0POBH(L,NY,NX)+2.0*(ZHCO3H(L,NY,NX)+ZALO1H(L,NY,NX)
     5+ZALSH(L,NY,NX)+ZFEO1H(L,NY,NX)+ZFESH(L,NY,NX)+ZCAOH(L,NY,NX)
     6+ZCACH(L,NY,NX)+ZCASH(L,NY,NX)+ZMGOH(L,NY,NX)+ZMGCH(L,NY,NX)
     7+ZMGSH(L,NY,NX)+ZNACH(L,NY,NX)+ZNASH(L,NY,NX)+ZKASH(L,NY,NX)
     8+H1PO4H(L,NY,NX)+H1POBH(L,NY,NX)+ZCA0PH(L,NY,NX)+ZCA0BH(L,NY,NX))
     9+3.0*(ZALO2H(L,NY,NX)+ZFEO2H(L,NY,NX)+ZCAHH(L,NY,NX)
     1+ZMGHH(L,NY,NX)+ZFE1PH(L,NY,NX)+ZCA1PH(L,NY,NX)+ZMG1PH(L,NY,NX)
     2+ZFE1BH(L,NY,NX)+ZCA1BH(L,NY,NX)+ZMG1BH(L,NY,NX))+4.0*
     3(ZALO3H(L,NY,NX)+ZFEO3H(L,NY,NX)+H3PO4H(L,NY,NX)+ZFE2PH(L,NY,NX)
     4+ZCA2PH(L,NY,NX)+H3POBH(L,NY,NX)+ZFE2BH(L,NY,NX)
     5+ZCA2BH(L,NY,NX))+5.0*(ZALO4H(L,NY,NX)+ZFEO4H(L,NY,NX))
      TX=2.0*(XN4(L,NY,NX)+XNB(L,NY,NX))+XHY(L,NY,NX)+XAL(L,NY,NX)
     2+XCA(L,NY,NX)+XMG(L,NY,NX)+XNA(L,NY,NX)+XKA(L,NY,NX)+XHC(L,NY,NX)
     3+XOH0(L,NY,NX)+XOH0B(L,NY,NX)+2.0*(PCACO(L,NY,NX)+PCASO(L,NY,NX)
     4+PALPO(L,NY,NX)+PFEPO(L,NY,NX)+PALPB(L,NY,NX)+PFEPB(L,NY,NX)
     5+XOH1(L,NY,NX)+XOH1B(L,NY,NX))
     6+3.0*(PCAPD(L,NY,NX)+PCPDB(L,NY,NX)+XALO2(L,NY,NX)
     7+XOH2(L,NY,NX)+XOH2B(L,NY,NX)+XH1P(L,NY,NX)+XH1PB(L,NY,NX))
     8+4.0*(PALOH(L,NY,NX)+PFEOH(L,NY,NX)+XH2P(L,NY,NX)
     9+XH2PB(L,NY,NX))+7.0*(PCAPM(L,NY,NX)+PCPMB(L,NY,NX))
     1+9.0*(PCAPH(L,NY,NX)+PCPHB(L,NY,NX))
      TF=2.0*(ZNH4FA(L,NY,NX)+ZNH4FB(L,NY,NX))+ZNO3FA(L,NY,NX)
     2+ZNO3FB(L,NY,NX)+ZNH3FA(L,NY,NX)+ZNH3FB(L,NY,NX)
     3+ZNHUFA(L,NY,NX)+ZNHUFB(L,NY,NX)
      TG=H2GG(L,NY,NX)+H2GS(L,NY,NX)+H2GSH(L,NY,NX)+TLH2GP(L,NY,NX)
      TI=TS+TH+TX+TF+TG
      TION=TION+TI
      UION(NY,NX)=UION(NY,NX)+TI
C     ENDIF
125   CONTINUE
      TRN(NY,NX)=TRN(NY,NX)+HEATI(NY,NX)
      TLE(NY,NX)=TLE(NY,NX)+HEATE(NY,NX)
      TSH(NY,NX)=TSH(NY,NX)+HEATS(NY,NX)
      TGH(NY,NX)=TGH(NY,NX)-(HEATH(NY,NX)-HEATV(NY,NX))
      TLEC(NY,NX)=TLEC(NY,NX)+HEATE(NY,NX)*RAC(NY,NX)
      TSHC(NY,NX)=TSHC(NY,NX)+HEATS(NY,NX)*RAC(NY,NX)
      TCNET(NY,NX)=TCNET(NY,NX)+HCO2G(NY,NX)
      RECO(NY,NX)=RECO(NY,NX)+HCO2G(NY,NX)
      TNBP(NY,NX)=TNBP(NY,NX)+TCNET(NY,NX)
C
C     UPDATE STATE VARIABLES WHEN SURFACE SEDIMENT TRANSPORT
C     FORCES SOIL RE-LAYERING IF SURFACE LAYER BECOMES TOO
C     THIN OR TOO THICK
C
      IF(DLYR(3,NU(NY,NX),NY,NX).LT.DNUMN
     2.OR.DLYR(3,NU(NY,NX),NY,NX).GT.DNUMX)THEN
      L0=NU(NY,NX)
      IF(DLYR(3,NU(NY,NX),NY,NX).LT.DNUMN)THEN
      FX=1.0
      L1=NU(NY,NX)+1
      NU(NY,NX)=L1
      ELSE
      IF(NU(NY,NX).EQ.1)THEN
      FX=(DLYR(3,NU(NY,NX),NY,NX)-DNUMX)/DLYR(3,NU(NY,NX),NY,NX)
      L1=NU(NY,NX)+1
      NU(NY,NX)=L0
      ELSE
      FZ=DLYR(3,NU(NY,NX),NY,NX)-DNUMX
      IF(FZ.GT.DNUMN)THEN
      FX=(DLYR(3,NU(NY,NX),NY,NX)-DNUMX)/DLYR(3,NU(NY,NX),NY,NX)
      L1=NU(NY,NX)-1
      NU(NY,NX)=L1
      ELSE
      FX=0.0
      L1=NU(NY,NX)
      ENDIF
      ENDIF
      ENDIF
      WRITE(*,5599)'ERODE1',I,J,NX,NY,L0,L1,NU(NY,NX),DNUMN,DNUMX
     2,DLYR(3,L0,NY,NX),DLYR(3,L1,NY,NX),FX 
5599  FORMAT(A8,7I4,12E12.4)
      IF(FX.GT.0.0)THEN
      FY=1.0-FX
      BKDS(L1,NY,NX)=(BKDS(L1,NY,NX)
     2*DLYR(3,L1,NY,NX)+BKDS(L0,NY,NX)
     3*FX*DLYR(3,L0,NY,NX))/(DLYR(3,L1,NY,NX)
     4+FX*DLYR(3,L0,NY,NX))
      VLNHB(L1,NY,NX)=(VLNHB(L1,NY,NX)
     2*DLYR(3,L1,NY,NX)+VLNHB(L0,NY,NX)
     3*FX*DLYR(3,L0,NY,NX))/(DLYR(3,L1,NY,NX)
     4+FX*DLYR(3,L0,NY,NX))
      VLNOB(L1,NY,NX)=(VLNOB(L1,NY,NX)
     2*DLYR(3,L1,NY,NX)+VLNOB(L0,NY,NX)
     3*FX*DLYR(3,L0,NY,NX))/(DLYR(3,L1,NY,NX)
     4+FX*DLYR(3,L0,NY,NX))
      VLPOB(L1,NY,NX)=(VLPOB(L1,NY,NX)
     2*DLYR(3,L1,NY,NX)+VLPOB(L0,NY,NX)
     3*FX*DLYR(3,L0,NY,NX))/(DLYR(3,L1,NY,NX)
     4+FX*DLYR(3,L0,NY,NX))
      VLNH4(L1,NY,NX)=1.0-VLNHB(L1,NY,NX)
      VLNO3(L1,NY,NX)=1.0-VLNOB(L1,NY,NX)
      VLPO4(L1,NY,NX)=1.0-VLPOB(L1,NY,NX)
      DLYR(3,L1,NY,NX)=DLYR(3,L1,NY,NX)
     2+FX*DLYR(3,L0,NY,NX)
      VOLX(L1,NY,NX)=VOLX(L1,NY,NX)
     2+FX*VOLX(L0,NY,NX)
      BKVL(L1,NY,NX)=BKVL(L1,NY,NX)
     2+FX*BKVL(L0,NY,NX)
      SAND(L1,NY,NX)=SAND(L1,NY,NX)
     2+FX*SAND(L0,NY,NX)
      SILT(L1,NY,NX)=SILT(L1,NY,NX)
     2+FX*SILT(L0,NY,NX)
      CLAY(L1,NY,NX)=CLAY(L1,NY,NX)
     2+FX*CLAY(L0,NY,NX)
      XCEC(L1,NY,NX)=XCEC(L1,NY,NX)
     2+FX*XCEC(L0,NY,NX)
      XAEC(L1,NY,NX)=XAEC(L1,NY,NX)
     2+FX*XAEC(L0,NY,NX)
      VOLW(L1,NY,NX)=VOLW(L1,NY,NX)
     2+FX*VOLW(L0,NY,NX)
      VOLI(L1,NY,NX)=VOLI(L1,NY,NX)
     2+FX*VOLI(L0,NY,NX)
      VOLIH(L1,NY,NX)=VOLIH(L1,NY,NX)
     2+FX*VOLIH(L0,NY,NX)
      VOLP(L1,NY,NX)=VOLP(L1,NY,NX)
     2+FX*VOLP(L0,NY,NX)
      VOLA(L1,NY,NX)=VOLA(L1,NY,NX)
     2+FX*VOLA(L0,NY,NX)
      VOLWX(L1,NY,NX)=VOLW(L0,NY,NX)
      VOLWH(L1,NY,NX)=VOLWH(L1,NY,NX)
     2+FX*VOLWH(L0,NY,NX)
      VOLAH(L1,NY,NX)=VOLAH(L1,NY,NX)
     2+FX*VOLAH(L0,NY,NX)
      VHCM(L1,NY,NX)=VHCM(L1,NY,NX)
     2+FX*VHCM(L0,NY,NX)
      VHCP(L1,NY,NX)=VHCM(L1,NY,NX)
     2+4.19*(VOLW(L1,NY,NX)+VOLWH(L1,NY,NX))
     3+1.9274*(VOLI(L1,NY,NX)+VOLIH(L1,NY,NX))
      ZNH4FA(L1,NY,NX)=ZNH4FA(L1,NY,NX)
     2+FX*ZNH4FA(L0,NY,NX)
      ZNH3FA(L1,NY,NX)=ZNH3FA(L1,NY,NX)
     2+FX*ZNH3FA(L0,NY,NX)
      ZNHUFA(L1,NY,NX)=ZNHUFA(L1,NY,NX)
     2+FX*ZNHUFA(L0,NY,NX)
      ZNO3FA(L1,NY,NX)=ZNO3FA(L1,NY,NX)
     2+FX*ZNO3FA(L0,NY,NX)
      ZNH4FB(L1,NY,NX)=ZNH4FB(L1,NY,NX)
     2+FX*ZNH4FB(L0,NY,NX)
      ZNH3FB(L1,NY,NX)=ZNH3FB(L1,NY,NX)
     2+FX*ZNH3FB(L0,NY,NX)
      ZNHUFB(L1,NY,NX)=ZNHUFB(L1,NY,NX)
     2+FX*ZNHUFB(L0,NY,NX)
      ZNO3FB(L1,NY,NX)=ZNO3FB(L1,NY,NX)
     2+FX*ZNO3FB(L0,NY,NX)
      ZNH4S(L1,NY,NX)=ZNH4S(L1,NY,NX)
     2+FX*ZNH4S(L0,NY,NX)
      ZNH4B(L1,NY,NX)=ZNH4B(L1,NY,NX)
     2+FX*ZNH4B(L0,NY,NX)
      ZNH3S(L1,NY,NX)=ZNH3S(L1,NY,NX)
     2+FX*ZNH3S(L0,NY,NX)
      ZNH3B(L1,NY,NX)=ZNH3B(L1,NY,NX)
     2+FX*ZNH3B(L0,NY,NX)
      ZNO3S(L1,NY,NX)=ZNO3S(L1,NY,NX)
     2+FX*ZNO3S(L0,NY,NX)
      ZNO3B(L1,NY,NX)=ZNO3B(L1,NY,NX)
     2+FX*ZNO3B(L0,NY,NX)
      ZNO2S(L1,NY,NX)=ZNO2S(L1,NY,NX)
     2+FX*ZNO2S(L0,NY,NX)
      ZNO2B(L1,NY,NX)=ZNO2B(L1,NY,NX)
     2+FX*ZNO2B(L0,NY,NX)
      ZAL(L1,NY,NX)=ZAL(L1,NY,NX)
     2+FX*ZAL(L0,NY,NX)
      ZFE(L1,NY,NX)=ZFE(L1,NY,NX)
     2+FX*ZFE(L0,NY,NX)
      ZHY(L1,NY,NX)=ZHY(L1,NY,NX)
     2+FX*ZHY(L0,NY,NX)
      ZCA(L1,NY,NX)=ZCA(L1,NY,NX)
     2+FX*ZCA(L0,NY,NX)
      ZMG(L1,NY,NX)=ZMG(L1,NY,NX)
     2+FX*ZMG(L0,NY,NX)
      ZNA(L1,NY,NX)=ZNA(L1,NY,NX)
     2+FX*ZNA(L0,NY,NX)
      ZKA(L1,NY,NX)=ZKA(L1,NY,NX)
     2+FX*ZKA(L0,NY,NX)
      ZOH(L1,NY,NX)=ZOH(L1,NY,NX)
     2+FX*ZOH(L0,NY,NX)
      ZSO4(L1,NY,NX)=ZSO4(L1,NY,NX)
     2+FX*ZSO4(L0,NY,NX)
      ZCL(L1,NY,NX)=ZCL(L1,NY,NX)
     2+FX*ZCL(L0,NY,NX)
      ZCO3(L1,NY,NX)=ZCO3(L1,NY,NX)
     2+FX*ZCO3(L0,NY,NX)
      ZHCO3(L1,NY,NX)=ZHCO3(L1,NY,NX)
     2+FX*ZHCO3(L0,NY,NX)
      ZALOH1(L1,NY,NX)=ZALOH1(L1,NY,NX)
     2+FX*ZALOH1(L0,NY,NX)
      ZALOH2(L1,NY,NX)=ZALOH2(L1,NY,NX)
     2+FX*ZALOH2(L0,NY,NX)
      ZALOH3(L1,NY,NX)=ZALOH3(L1,NY,NX)
     2+FX*ZALOH3(L0,NY,NX)
      ZALOH4(L1,NY,NX)=ZALOH4(L1,NY,NX)
     2+FX*ZALOH4(L0,NY,NX)
      ZALS(L1,NY,NX)=ZALS(L1,NY,NX)
     2+FX*ZALS(L0,NY,NX)
      ZFEOH1(L1,NY,NX)=ZFEOH1(L1,NY,NX)
     2+FX*ZFEOH1(L0,NY,NX)
      ZFEOH2(L1,NY,NX)=ZFEOH2(L1,NY,NX)
     2+FX*ZFEOH2(L0,NY,NX)
      ZFEOH3(L1,NY,NX)=ZFEOH3(L1,NY,NX)
     2+FX*ZFEOH3(L0,NY,NX)
      ZFEOH4(L1,NY,NX)=ZFEOH4(L1,NY,NX)
     2+FX*ZFEOH4(L0,NY,NX)
      ZFES(L1,NY,NX)=ZFES(L1,NY,NX)
     2+FX*ZFES(L0,NY,NX)
      ZCAO(L1,NY,NX)=ZCAO(L1,NY,NX)
     2+FX*ZCAO(L0,NY,NX)
      ZCAC(L1,NY,NX)=ZCAC(L1,NY,NX)
     2+FX*ZCAC(L0,NY,NX)
      ZCAH(L1,NY,NX)=ZCAH(L1,NY,NX)
     2+FX*ZCAH(L0,NY,NX)
      ZCAS(L1,NY,NX)=ZCAS(L1,NY,NX)
     2+FX*ZCAS(L0,NY,NX)
      ZMGO(L1,NY,NX)=ZMGO(L1,NY,NX)
     2+FX*ZMGO(L0,NY,NX)
      ZMGC(L1,NY,NX)=ZMGC(L1,NY,NX)
     2+FX*ZMGC(L0,NY,NX)
      ZMGH(L1,NY,NX)=ZMGH(L1,NY,NX)
     2+FX*ZMGH(L0,NY,NX)
      ZMGS(L1,NY,NX)=ZMGS(L1,NY,NX)
     2+FX*ZMGS(L0,NY,NX)
      ZNAC(L1,NY,NX)=ZNAC(L1,NY,NX)
     2+FX*ZNAC(L0,NY,NX)
      ZNAS(L1,NY,NX)=ZNAS(L1,NY,NX)
     2+FX*ZNAS(L0,NY,NX)
      ZKAS(L1,NY,NX)=ZKAS(L1,NY,NX)
     2+FX*ZKAS(L0,NY,NX)
      H0PO4(L1,NY,NX)=H0PO4(L1,NY,NX)
     2+FX*H0PO4(L0,NY,NX)
      H1PO4(L1,NY,NX)=H1PO4(L1,NY,NX)
     2+FX*H1PO4(L0,NY,NX)
      H2PO4(L1,NY,NX)=H2PO4(L1,NY,NX)
     2+FX*H2PO4(L0,NY,NX)
      H3PO4(L1,NY,NX)=H3PO4(L1,NY,NX)
     2+FX*H3PO4(L0,NY,NX)
      ZFE1P(L1,NY,NX)=ZFE1P(L1,NY,NX)
     2+FX*ZFE1P(L0,NY,NX)
      ZFE2P(L1,NY,NX)=ZFE2P(L1,NY,NX)
     2+FX*ZFE2P(L0,NY,NX)
      ZCA0P(L1,NY,NX)=ZCA0P(L1,NY,NX)
     2+FX*ZCA0P(L0,NY,NX)
      ZCA1P(L1,NY,NX)=ZCA1P(L1,NY,NX)
     2+FX*ZCA1P(L0,NY,NX)
      ZCA2P(L1,NY,NX)=ZCA2P(L1,NY,NX)
     2+FX*ZCA2P(L0,NY,NX)
      ZMG1P(L1,NY,NX)=ZMG1P(L1,NY,NX)
     2+FX*ZMG1P(L0,NY,NX)
      H0POB(L1,NY,NX)=H0POB(L1,NY,NX)
     2+FX*H0POB(L0,NY,NX)
      H1POB(L1,NY,NX)=H1POB(L1,NY,NX)
     2+FX*H1POB(L0,NY,NX)
      H2POB(L1,NY,NX)=H2POB(L1,NY,NX)
     2+FX*H2POB(L0,NY,NX)
      H3POB(L1,NY,NX)=H3POB(L1,NY,NX)
     2+FX*H3POB(L0,NY,NX)
      ZFE1PB(L1,NY,NX)=ZFE1PB(L1,NY,NX)
     2+FX*ZFE1PB(L0,NY,NX)
      ZFE2PB(L1,NY,NX)=ZFE2PB(L1,NY,NX)
     2+FX*ZFE2PB(L0,NY,NX)
      ZCA0PB(L1,NY,NX)=ZCA0PB(L1,NY,NX)
     2+FX*ZCA0PB(L0,NY,NX)
      ZCA1PB(L1,NY,NX)=ZCA1PB(L1,NY,NX)
     2+FX*ZCA1PB(L0,NY,NX)
      ZCA2PB(L1,NY,NX)=ZCA2PB(L1,NY,NX)
     2+FX*ZCA2PB(L0,NY,NX)
      ZMG1PB(L1,NY,NX)=ZMG1PB(L1,NY,NX)
     2+FX*ZMG1PB(L0,NY,NX)
      XN4(L1,NY,NX)=XN4(L1,NY,NX)
     2+FX*XN4(L0,NY,NX)
      XNB(L1,NY,NX)=XNB(L1,NY,NX)
     2+FX*XNB(L0,NY,NX)
      XHY(L1,NY,NX)=XHY(L1,NY,NX)
     2+FX*XHY(L0,NY,NX)
      XAL(L1,NY,NX)=XAL(L1,NY,NX)
     2+FX*XAL(L0,NY,NX)
      XCA(L1,NY,NX)=XCA(L1,NY,NX)
     2+FX*XCA(L0,NY,NX)
      XMG(L1,NY,NX)=XMG(L1,NY,NX)
     2+FX*XMG(L0,NY,NX)
      XNA(L1,NY,NX)=XNA(L1,NY,NX)
     2+FX*XNA(L0,NY,NX)
      XKA(L1,NY,NX)=XKA(L1,NY,NX)
     2+FX*XKA(L0,NY,NX)
      XHC(L1,NY,NX)=XHC(L1,NY,NX)
     2+FX*XHC(L0,NY,NX)
      XALO2(L1,NY,NX)=XALO2(L1,NY,NX)
     2+FX*XALO2(L0,NY,NX)
      XOH0(L1,NY,NX)=XOH0(L1,NY,NX)
     2+FX*XOH0(L0,NY,NX)
      XOH1(L1,NY,NX)=XOH1(L1,NY,NX)
     2+FX*XOH1(L0,NY,NX)
      XOH2(L1,NY,NX)=XOH2(L1,NY,NX)
     2+FX*XOH2(L0,NY,NX)
      XH1P(L1,NY,NX)=XH1P(L1,NY,NX)
     2+FX*XH1P(L0,NY,NX)
      XH2P(L1,NY,NX)=XH2P(L1,NY,NX)
     2+FX*XH2P(L0,NY,NX)
      XOH0B(L1,NY,NX)=XOH0B(L1,NY,NX)
     2+FX*XOH0B(L0,NY,NX)
      XOH1B(L1,NY,NX)=XOH1B(L1,NY,NX)
     2+FX*XOH1B(L0,NY,NX)
      XOH2B(L1,NY,NX)=XOH2B(L1,NY,NX)
     2+FX*XOH2B(L0,NY,NX)
      XH1PB(L1,NY,NX)=XH1PB(L1,NY,NX)
     2+FX*XH1PB(L0,NY,NX)
      XH2PB(L1,NY,NX)=XH2PB(L1,NY,NX)
     2+FX*XH2PB(L0,NY,NX)
      PALOH(L1,NY,NX)=PALOH(L1,NY,NX)
     2+FX*PALOH(L0,NY,NX)
      PFEOH(L1,NY,NX)=PFEOH(L1,NY,NX)
     2+FX*PFEOH(L0,NY,NX)
      PCACO(L1,NY,NX)=PCACO(L1,NY,NX)
     2+FX*PCACO(L0,NY,NX)
      PCASO(L1,NY,NX)=PCASO(L1,NY,NX)
     2+FX*PCASO(L0,NY,NX)
      PALPO(L1,NY,NX)=PALPO(L1,NY,NX)
     2+FX*PALPO(L0,NY,NX)
      PFEPO(L1,NY,NX)=PFEPO(L1,NY,NX)
     2+FX*PFEPO(L0,NY,NX)
      PCAPD(L1,NY,NX)=PCAPD(L1,NY,NX)
     2+FX*PCAPD(L0,NY,NX)
      PCAPH(L1,NY,NX)=PCAPH(L1,NY,NX)
     2+FX*PCAPH(L0,NY,NX)
      PCAPM(L1,NY,NX)=PCAPM(L1,NY,NX)
     2+FX*PCAPM(L0,NY,NX)
      PALPB(L1,NY,NX)=PALPB(L1,NY,NX)
     2+FX*PALPB(L0,NY,NX)
      PFEPB(L1,NY,NX)=PFEPB(L1,NY,NX)
     2+FX*PFEPB(L0,NY,NX)
      PCPDB(L1,NY,NX)=PCPDB(L1,NY,NX)
     2+FX*PCPDB(L0,NY,NX)
      PCPHB(L1,NY,NX)=PCPHB(L1,NY,NX)
     2+FX*PCPHB(L0,NY,NX)
      PCPMB(L1,NY,NX)=PCPMB(L1,NY,NX)
     2+FX*PCPMB(L0,NY,NX)
      CO2G(L1,NY,NX)=CO2G(L1,NY,NX)
     2+FX*CO2G(L0,NY,NX)
      CH4G(L1,NY,NX)=CH4G(L1,NY,NX)
     2+FX*CH4G(L0,NY,NX)
      CO2S(L1,NY,NX)=CO2S(L1,NY,NX)
     2+FX*CO2S(L0,NY,NX)
      CH4S(L1,NY,NX)=CH4S(L1,NY,NX)
     2+FX*CH4S(L0,NY,NX)
      OXYG(L1,NY,NX)=OXYG(L1,NY,NX)
     2+FX*OXYG(L0,NY,NX)
      OXYS(L1,NY,NX)=OXYS(L1,NY,NX)
     2+FX*OXYS(L0,NY,NX)
      Z2GG(L1,NY,NX)=Z2GG(L1,NY,NX)
     2+FX*Z2GG(L0,NY,NX)
      Z2GS(L1,NY,NX)=Z2GS(L1,NY,NX)
     2+FX*Z2GS(L0,NY,NX)
      Z2OG(L1,NY,NX)=Z2OG(L1,NY,NX)
     2+FX*Z2OG(L0,NY,NX)
      Z2OS(L1,NY,NX)=Z2OS(L1,NY,NX)
     2+FX*Z2OS(L0,NY,NX)
      ZNH3G(L1,NY,NX)=ZNH3G(L1,NY,NX)
     2+FX*ZNH3G(L0,NY,NX)
      H2GG(L1,NY,NX)=H2GG(L1,NY,NX)
     2+FX*H2GG(L0,NY,NX)
      H2GS(L1,NY,NX)=H2GS(L1,NY,NX)
     2+FX*H2GS(L0,NY,NX)
      ZNH4SH(L1,NY,NX)=ZNH4SH(L1,NY,NX)
     2+FX*ZNH4SH(L0,NY,NX)
      ZNH3SH(L1,NY,NX)=ZNH3SH(L1,NY,NX)
     2+FX*ZNH3SH(L0,NY,NX)
      ZNO3SH(L1,NY,NX)=ZNO3SH(L1,NY,NX)
     2+FX*ZNO3SH(L0,NY,NX)
      ZNO2SH(L1,NY,NX)=ZNO2SH(L1,NY,NX)
     2+FX*ZNO2SH(L0,NY,NX)
      H2PO4H(L1,NY,NX)=H2PO4H(L1,NY,NX)
     2+FX*H2PO4H(L0,NY,NX)
      ZNH4BH(L1,NY,NX)=ZNH4BH(L1,NY,NX)
     2+FX*ZNH4BH(L0,NY,NX)
      ZNH3BH(L1,NY,NX)=ZNH3BH(L1,NY,NX)
     2+FX*ZNH3BH(L0,NY,NX)
      ZNO3BH(L1,NY,NX)=ZNO3BH(L1,NY,NX)
     2+FX*ZNO3BH(L0,NY,NX)
      ZNO2BH(L1,NY,NX)=ZNO2BH(L1,NY,NX)
     2+FX*ZNO2BH(L0,NY,NX)
      H2POBH(L1,NY,NX)=H2POBH(L1,NY,NX)
     2+FX*H2POBH(L0,NY,NX)
      ZALH(L1,NY,NX)=ZALH(L1,NY,NX)
     2+FX*ZALH(L0,NY,NX)
      ZFEH(L1,NY,NX)=ZFEH(L1,NY,NX)
     2+FX*ZFEH(L0,NY,NX)
      ZHYH(L1,NY,NX)=ZHYH(L1,NY,NX)
     2+FX*ZHYH(L0,NY,NX)
      ZCCH(L1,NY,NX)=ZCCH(L1,NY,NX)
     2+FX*ZCCH(L0,NY,NX)
      ZMAH(L1,NY,NX)=ZMAH(L1,NY,NX)
     2+FX*ZMAH(L0,NY,NX)
      ZNAH(L1,NY,NX)=ZNAH(L1,NY,NX)
     2+FX*ZNAH(L0,NY,NX)
      ZKAH(L1,NY,NX)=ZKAH(L1,NY,NX)
     2+FX*ZKAH(L0,NY,NX)
      ZOHH(L1,NY,NX)=ZOHH(L1,NY,NX)
     2+FX*ZOHH(L0,NY,NX)
      ZSO4H(L1,NY,NX)=ZSO4H(L1,NY,NX)
     2+FX*ZSO4H(L0,NY,NX)
      ZCLH(L1,NY,NX)=ZCLH(L1,NY,NX)
     2+FX*ZCLH(L0,NY,NX)
      ZCO3H(L1,NY,NX)=ZCO3H(L1,NY,NX)
     2+FX*ZCO3H(L0,NY,NX)
      ZHCO3H(L1,NY,NX)=ZHCO3H(L1,NY,NX)
     2+FX*ZHCO3H(L0,NY,NX)
      ZALO1H(L1,NY,NX)=ZALO1H(L1,NY,NX)
     2+FX*ZALO1H(L0,NY,NX)
      ZALO2H(L1,NY,NX)=ZALO2H(L1,NY,NX)
     2+FX*ZALO2H(L0,NY,NX)
      ZALO3H(L1,NY,NX)=ZALO3H(L1,NY,NX)
     2+FX*ZALO3H(L0,NY,NX)
      ZALO4H(L1,NY,NX)=ZALO4H(L1,NY,NX)
     2+FX*ZALO4H(L0,NY,NX)
      ZALSH(L1,NY,NX)=ZALSH(L1,NY,NX)
     2+FX*ZALSH(L0,NY,NX)
      ZFEO1H(L1,NY,NX)=ZFEO1H(L1,NY,NX)
     2+FX*ZFEO1H(L0,NY,NX)
      ZFEO2H(L1,NY,NX)=ZFEO2H(L1,NY,NX)
     2+FX*ZFEO2H(L0,NY,NX)
      ZFEO3H(L1,NY,NX)=ZFEO3H(L1,NY,NX)
     2+FX*ZFEO3H(L0,NY,NX)
      ZFEO4H(L1,NY,NX)=ZFEO4H(L1,NY,NX)
     2+FX*ZFEO4H(L0,NY,NX)
      ZFESH(L1,NY,NX)=ZFESH(L1,NY,NX)
     2+FX*ZFESH(L0,NY,NX)
      ZCAOH(L1,NY,NX)=ZCAOH(L1,NY,NX)
     2+FX*ZCAOH(L0,NY,NX)
      ZCACH(L1,NY,NX)=ZCACH(L1,NY,NX)
     2+FX*ZCACH(L0,NY,NX)
      ZCAHH(L1,NY,NX)=ZCAHH(L1,NY,NX)
     2+FX*ZCAHH(L0,NY,NX)
      ZCASH(L1,NY,NX)=ZCASH(L1,NY,NX)
     2+FX*ZCASH(L0,NY,NX)
      ZMGOH(L1,NY,NX)=ZMGOH(L1,NY,NX)
     2+FX*ZMGOH(L0,NY,NX)
      ZMGCH(L1,NY,NX)=ZMGCH(L1,NY,NX)
     2+FX*ZMGCH(L0,NY,NX)
      ZMGHH(L1,NY,NX)=ZMGHH(L1,NY,NX)
     2+FX*ZMGHH(L0,NY,NX)
      ZMGSH(L1,NY,NX)=ZMGSH(L1,NY,NX)
     2+FX*ZMGSH(L0,NY,NX)
      ZNACH(L1,NY,NX)=ZNACH(L1,NY,NX)
     2+FX*ZNACH(L0,NY,NX)
      ZNASH(L1,NY,NX)=ZNASH(L1,NY,NX)
     2+FX*ZNASH(L0,NY,NX)
      ZKASH(L1,NY,NX)=ZKASH(L1,NY,NX)
     2+FX*ZKASH(L0,NY,NX)
      H0PO4H(L1,NY,NX)=H0PO4H(L1,NY,NX)
     2+FX*H0PO4H(L0,NY,NX)
      H1PO4H(L1,NY,NX)=H1PO4H(L1,NY,NX)
     2+FX*H1PO4H(L0,NY,NX)
      H3PO4H(L1,NY,NX)=H3PO4H(L1,NY,NX)
     2+FX*H3PO4H(L0,NY,NX)
      ZFE1PH(L1,NY,NX)=ZFE1PH(L1,NY,NX)
     2+FX*ZFE1PH(L0,NY,NX)
      ZFE2PH(L1,NY,NX)=ZFE2PH(L1,NY,NX)
     2+FX*ZFE2PH(L0,NY,NX)
      ZCA0PH(L1,NY,NX)=ZCA0PH(L1,NY,NX)
     2+FX*ZCA0PH(L0,NY,NX)
      ZCA1PH(L1,NY,NX)=ZCA1PH(L1,NY,NX)
     2+FX*ZCA1PH(L0,NY,NX)
      ZCA2PH(L1,NY,NX)=ZCA2PH(L1,NY,NX)
     2+FX*ZCA2PH(L0,NY,NX)
      ZMG1PH(L1,NY,NX)=ZMG1PH(L1,NY,NX)
     2+FX*ZMG1PH(L0,NY,NX)
      H0POBH(L1,NY,NX)=H0POBH(L1,NY,NX)
     2+FX*H0POBH(L0,NY,NX)
      H1POBH(L1,NY,NX)=H1POBH(L1,NY,NX)
     2+FX*H1POBH(L0,NY,NX)
      H3POBH(L1,NY,NX)=H3POBH(L1,NY,NX)
     2+FX*H3POBH(L0,NY,NX)
      ZFE1BH(L1,NY,NX)=ZFE1BH(L1,NY,NX)
     2+FX*ZFE1BH(L0,NY,NX)
      ZFE2BH(L1,NY,NX)=ZFE2BH(L1,NY,NX)
     2+FX*ZFE2BH(L0,NY,NX)
      ZCA0BH(L1,NY,NX)=ZCA0BH(L1,NY,NX)
     2+FX*ZCA0BH(L0,NY,NX)
      ZCA1BH(L1,NY,NX)=ZCA1BH(L1,NY,NX)
     2+FX*ZCA1BH(L0,NY,NX)
      ZCA2BH(L1,NY,NX)=ZCA2BH(L1,NY,NX)
     2+FX*ZCA2BH(L0,NY,NX)
      ZMG1BH(L1,NY,NX)=ZMG1BH(L1,NY,NX)
     2+FX*ZMG1BH(L0,NY,NX)
      CO2SH(L1,NY,NX)=CO2SH(L1,NY,NX)
     2+FX*CO2SH(L0,NY,NX)
      CH4SH(L1,NY,NX)=CH4SH(L1,NY,NX)
     2+FX*CH4SH(L0,NY,NX)
      OXYSH(L1,NY,NX)=OXYSH(L1,NY,NX)
     2+FX*OXYSH(L0,NY,NX)
      Z2GSH(L1,NY,NX)=Z2GSH(L1,NY,NX)
     2+FX*Z2GSH(L0,NY,NX)
      Z2OSH(L1,NY,NX)=Z2OSH(L1,NY,NX)
     2+FX*Z2OSH(L0,NY,NX)
      ORGC(L1,NY,NX)=ORGC(L1,NY,NX)
     2+FX*ORGC(L0,NY,NX)
      ORGN(L1,NY,NX)=ORGN(L1,NY,NX)
     2+FX*ORGN(L0,NY,NX)
      DO 7965 K=0,5
      DO 7965 N=1,7
      DO 7965 M=1,3
      OMC(M,N,K,L1,NY,NX)=OMC(M,N,K,L1,NY,NX)
     2+FX*OMC(M,N,K,L0,NY,NX)
      OMN(M,N,K,L1,NY,NX)=OMN(M,N,K,L1,NY,NX)
     2+FX*OMN(M,N,K,L0,NY,NX)
      OMP(M,N,K,L1,NY,NX)=OMP(M,N,K,L1,NY,NX)
     2+FX*OMP(M,N,K,L0,NY,NX)
7965  CONTINUE
      DO 7780 K=0,4
      DO 7775 M=1,2
      ORC(M,K,L1,NY,NX)=ORC(M,K,L1,NY,NX)
     2+FX*ORC(M,K,L0,NY,NX)
      ORN(M,K,L1,NY,NX)=ORN(M,K,L1,NY,NX)
     2+FX*ORN(M,K,L0,NY,NX)
      ORP(M,K,L1,NY,NX)=ORP(M,K,L1,NY,NX)
     2+FX*ORP(M,K,L0,NY,NX)
7775  CONTINUE
      OQC(K,L1,NY,NX)=OQC(K,L1,NY,NX)
     2+FX*OQC(K,L0,NY,NX)
      OQN(K,L1,NY,NX)=OQN(K,L1,NY,NX)
     2+FX*OQN(K,L0,NY,NX)
      OQP(K,L1,NY,NX)=OQP(K,L1,NY,NX)
     2+FX*OQP(K,L0,NY,NX)
      OQA(K,L1,NY,NX)=OQA(K,L1,NY,NX)
     2+FX*OQA(K,L0,NY,NX)
      OQCH(K,L1,NY,NX)=OQCH(K,L1,NY,NX)
     2+FX*OQCH(K,L0,NY,NX)
      OQNH(K,L1,NY,NX)=OQNH(K,L1,NY,NX)
     2+FX*OQNH(K,L0,NY,NX)
      OQPH(K,L1,NY,NX)=OQPH(K,L1,NY,NX)
     2+FX*OQPH(K,L0,NY,NX)
      OQAH(K,L1,NY,NX)=OQAH(K,L1,NY,NX)
     2+FX*OQAH(K,L0,NY,NX)
      OHC(K,L1,NY,NX)=OHC(K,L1,NY,NX)
     2+FX*OHC(K,L0,NY,NX)
      OHN(K,L1,NY,NX)=OHN(K,L1,NY,NX)
     2+FX*OHN(K,L0,NY,NX)
      OHP(K,L1,NY,NX)=OHP(K,L1,NY,NX)
     2+FX*OHP(K,L0,NY,NX)
      OHA(K,L1,NY,NX)=OHA(K,L1,NY,NX)
     2+FX*OHA(K,L0,NY,NX)
      DO 7770 M=1,4
      OSC(M,K,L1,NY,NX)=OSC(M,K,L1,NY,NX)
     2+FX*OSC(M,K,L0,NY,NX)
      OSA(M,K,L1,NY,NX)=OSA(M,K,L1,NY,NX)
     2+FX*OSA(M,K,L0,NY,NX)
      OSN(M,K,L1,NY,NX)=OSN(M,K,L1,NY,NX)
     2+FX*OSN(M,K,L0,NY,NX)
      OSP(M,K,L1,NY,NX)=OSP(M,K,L1,NY,NX)
     2+FX*OSP(M,K,L0,NY,NX)
7770  CONTINUE
7780  CONTINUE
      CDPTH(L0,NY,NX)=CDPTH(L0,NY,NX)
     2-FX*DLYR(3,L0,NY,NX)
      DLYR(3,L0,NY,NX)=FY*DLYR(3,L0,NY,NX)
      VOLX(L0,NY,NX)=FY*VOLX(L0,NY,NX)
      BKVL(L0,NY,NX)=FY*BKVL(L0,NY,NX)
      SAND(L0,NY,NX)=FY*SAND(L0,NY,NX)
      SILT(L0,NY,NX)=FY*SILT(L0,NY,NX)
      CLAY(L0,NY,NX)=FY*CLAY(L0,NY,NX)
      XCEC(L0,NY,NX)=FY*XCEC(L0,NY,NX)
      XAEC(L0,NY,NX)=FY*XAEC(L0,NY,NX)
      VOLW(L0,NY,NX)=FY*VOLW(L0,NY,NX)
      VOLI(L0,NY,NX)=FY*VOLI(L0,NY,NX)
      VOLP(L0,NY,NX)=FY*VOLP(L0,NY,NX)
      VOLA(L0,NY,NX)=FY*VOLA(L0,NY,NX)
      VOLWX(L0,NY,NX)=FY*VOLWX(L0,NY,NX)
      VOLWH(L0,NY,NX)=FY*VOLWH(L0,NY,NX)
      VOLIH(L0,NY,NX)=FY*VOLIH(L0,NY,NX)
      VOLAH(L0,NY,NX)=FY*VOLAH(L0,NY,NX)
      VHCM(L0,NY,NX)=FY*VHCM(L0,NY,NX)
      VHCP(L0,NY,NX)=FY*VHCP(L0,NY,NX)
      VHCP(L0,NY,NX)=VHCM(L0,NY,NX)
     2+4.19*(VOLW(L0,NY,NX)+VOLWH(L0,NY,NX))
     3+1.9274*(VOLI(L0,NY,NX)+VOLIH(L0,NY,NX))
      ZNH4FA(L0,NY,NX)=FY*ZNH4FA(L0,NY,NX)
      ZNH3FA(L0,NY,NX)=FY*ZNH3FA(L0,NY,NX)
      ZNHUFA(L0,NY,NX)=FY*ZNHUFA(L0,NY,NX)
      ZNO3FA(L0,NY,NX)=FY*ZNO3FA(L0,NY,NX)
      ZNH4FB(L0,NY,NX)=FY*ZNH4FB(L0,NY,NX)
      ZNH3FB(L0,NY,NX)=FY*ZNH3FB(L0,NY,NX)
      ZNHUFB(L0,NY,NX)=FY*ZNHUFB(L0,NY,NX)
      ZNO3FB(L0,NY,NX)=FY*ZNO3FB(L0,NY,NX)
      ZNH4S(L0,NY,NX)=FY*ZNH4S(L0,NY,NX)
      ZNH4B(L0,NY,NX)=FY*ZNH4B(L0,NY,NX)
      ZNH3S(L0,NY,NX)=FY*ZNH3S(L0,NY,NX)
      ZNH3B(L0,NY,NX)=FY*ZNH3B(L0,NY,NX)
      ZNO3S(L0,NY,NX)=FY*ZNO3S(L0,NY,NX)
      ZNO3B(L0,NY,NX)=FY*ZNO3B(L0,NY,NX)
      ZNO2S(L0,NY,NX)=FY*ZNO2S(L0,NY,NX)
      ZNO2B(L0,NY,NX)=FY*ZNO2B(L0,NY,NX)
      ZAL(L0,NY,NX)=FY*ZAL(L0,NY,NX)
      ZFE(L0,NY,NX)=FY*ZFE(L0,NY,NX)
      ZHY(L0,NY,NX)=FY*ZHY(L0,NY,NX)
      ZCA(L0,NY,NX)=FY*ZCA(L0,NY,NX)
      ZMG(L0,NY,NX)=FY*ZMG(L0,NY,NX)
      ZNA(L0,NY,NX)=FY*ZNA(L0,NY,NX)
      ZKA(L0,NY,NX)=FY*ZKA(L0,NY,NX)
      ZOH(L0,NY,NX)=FY*ZOH(L0,NY,NX)
      ZSO4(L0,NY,NX)=FY*ZSO4(L0,NY,NX)
      ZCL(L0,NY,NX)=FY*ZCL(L0,NY,NX)
      ZCO3(L0,NY,NX)=FY*ZCO3(L0,NY,NX)
      ZHCO3(L0,NY,NX)=FY*ZHCO3(L0,NY,NX)
      ZALOH1(L0,NY,NX)=FY*ZALOH1(L0,NY,NX)
      ZALOH2(L0,NY,NX)=FY*ZALOH2(L0,NY,NX)
      ZALOH3(L0,NY,NX)=FY*ZALOH3(L0,NY,NX)
      ZALOH4(L0,NY,NX)=FY*ZALOH4(L0,NY,NX)
      ZALS(L0,NY,NX)=FY*ZALS(L0,NY,NX)
      ZFEOH1(L0,NY,NX)=FY*ZFEOH1(L0,NY,NX)
      ZFEOH2(L0,NY,NX)=FY*ZFEOH2(L0,NY,NX)
      ZFEOH3(L0,NY,NX)=FY*ZFEOH3(L0,NY,NX)
      ZFEOH4(L0,NY,NX)=FY*ZFEOH4(L0,NY,NX)
      ZFES(L0,NY,NX)=FY*ZFES(L0,NY,NX)
      ZCAO(L0,NY,NX)=FY*ZCAO(L0,NY,NX)
      ZCAC(L0,NY,NX)=FY*ZCAC(L0,NY,NX)
      ZCAH(L0,NY,NX)=FY*ZCAH(L0,NY,NX)
      ZCAS(L0,NY,NX)=FY*ZCAS(L0,NY,NX)
      ZMGO(L0,NY,NX)=FY*ZMGO(L0,NY,NX)
      ZMGC(L0,NY,NX)=FY*ZMGC(L0,NY,NX)
      ZMGH(L0,NY,NX)=FY*ZMGH(L0,NY,NX)
      ZMGS(L0,NY,NX)=FY*ZMGS(L0,NY,NX)
      ZNAC(L0,NY,NX)=FY*ZNAC(L0,NY,NX)
      ZNAS(L0,NY,NX)=FY*ZNAS(L0,NY,NX)
      ZKAS(L0,NY,NX)=FY*ZKAS(L0,NY,NX)
      H0PO4(L0,NY,NX)=FY*H0PO4(L0,NY,NX)
      H1PO4(L0,NY,NX)=FY*H1PO4(L0,NY,NX)
      H2PO4(L0,NY,NX)=FY*H2PO4(L0,NY,NX)
      H3PO4(L0,NY,NX)=FY*H3PO4(L0,NY,NX)
      ZFE1P(L0,NY,NX)=FY*ZFE1P(L0,NY,NX)
      ZFE2P(L0,NY,NX)=FY*ZFE2P(L0,NY,NX)
      ZCA0P(L0,NY,NX)=FY*ZCA0P(L0,NY,NX)
      ZCA1P(L0,NY,NX)=FY*ZCA1P(L0,NY,NX)
      ZCA2P(L0,NY,NX)=FY*ZCA2P(L0,NY,NX)
      ZMG1P(L0,NY,NX)=FY*ZMG1P(L0,NY,NX)
      H0POB(L0,NY,NX)=FY*H0POB(L0,NY,NX)
      H1POB(L0,NY,NX)=FY*H1POB(L0,NY,NX)
      H2POB(L0,NY,NX)=FY*H2POB(L0,NY,NX)
      H3POB(L0,NY,NX)=FY*H3POB(L0,NY,NX)
      ZFE1PB(L0,NY,NX)=FY*ZFE1PB(L0,NY,NX)
      ZFE2PB(L0,NY,NX)=FY*ZFE2PB(L0,NY,NX)
      ZCA0PB(L0,NY,NX)=FY*ZCA0PB(L0,NY,NX)
      ZCA1PB(L0,NY,NX)=FY*ZCA1PB(L0,NY,NX)
      ZCA2PB(L0,NY,NX)=FY*ZCA2PB(L0,NY,NX)
      ZMG1PB(L0,NY,NX)=FY*ZMG1PB(L0,NY,NX)
      XN4(L0,NY,NX)=FY*XN4(L0,NY,NX)
      XNB(L0,NY,NX)=FY*XNB(L0,NY,NX)
      XHY(L0,NY,NX)=FY*XHY(L0,NY,NX)
      XAL(L0,NY,NX)=FY*XAL(L0,NY,NX)
      XCA(L0,NY,NX)=FY*XCA(L0,NY,NX)
      XMG(L0,NY,NX)=FY*XMG(L0,NY,NX)
      XNA(L0,NY,NX)=FY*XNA(L0,NY,NX)
      XKA(L0,NY,NX)=FY*XKA(L0,NY,NX)
      XHC(L0,NY,NX)=FY*XHC(L0,NY,NX)
      XALO2(L0,NY,NX)=FY*XALO2(L0,NY,NX)
      XOH0(L0,NY,NX)=FY*XOH0(L0,NY,NX)
      XOH1(L0,NY,NX)=FY*XOH1(L0,NY,NX)
      XOH2(L0,NY,NX)=FY*XOH2(L0,NY,NX)
      XH1P(L0,NY,NX)=FY*XH1P(L0,NY,NX)
      XH2P(L0,NY,NX)=FY*XH2P(L0,NY,NX)
      XOH0B(L0,NY,NX)=FY*XOH0B(L0,NY,NX)
      XOH1B(L0,NY,NX)=FY*XOH1B(L0,NY,NX)
      XOH2B(L0,NY,NX)=FY*XOH2B(L0,NY,NX)
      XH1PB(L0,NY,NX)=FY*XH1PB(L0,NY,NX)
      XH2PB(L0,NY,NX)=FY*XH2PB(L0,NY,NX)
      PALOH(L0,NY,NX)=FY*PALOH(L0,NY,NX)
      PFEOH(L0,NY,NX)=FY*PFEOH(L0,NY,NX)
      PCACO(L0,NY,NX)=FY*PCACO(L0,NY,NX)
      PCASO(L0,NY,NX)=FY*PCASO(L0,NY,NX)
      PALPO(L0,NY,NX)=FY*PALPO(L0,NY,NX)
      PFEPO(L0,NY,NX)=FY*PFEPO(L0,NY,NX)
      PCAPD(L0,NY,NX)=FY*PCAPD(L0,NY,NX)
      PCAPH(L0,NY,NX)=FY*PCAPH(L0,NY,NX)
      PCAPM(L0,NY,NX)=FY*PCAPM(L0,NY,NX)
      PALPB(L0,NY,NX)=FY*PALPB(L0,NY,NX)
      PFEPB(L0,NY,NX)=FY*PFEPB(L0,NY,NX)
      PCPDB(L0,NY,NX)=FY*PCPDB(L0,NY,NX)
      PCPHB(L0,NY,NX)=FY*PCPHB(L0,NY,NX)
      PCPMB(L0,NY,NX)=FY*PCPMB(L0,NY,NX)
      CO2G(L0,NY,NX)=FY*CO2G(L0,NY,NX)
      CH4G(L0,NY,NX)=FY*CH4G(L0,NY,NX)
      CO2S(L0,NY,NX)=FY*CO2S(L0,NY,NX)
      CH4S(L0,NY,NX)=FY*CH4S(L0,NY,NX)
      OXYG(L0,NY,NX)=FY*OXYG(L0,NY,NX)
      OXYS(L0,NY,NX)=FY*OXYS(L0,NY,NX)
      Z2GG(L0,NY,NX)=FY*Z2GG(L0,NY,NX)
      Z2GS(L0,NY,NX)=FY*Z2GS(L0,NY,NX)
      Z2OG(L0,NY,NX)=FY*Z2OG(L0,NY,NX)
      Z2OS(L0,NY,NX)=FY*Z2OS(L0,NY,NX)
      ZNH3G(L0,NY,NX)=FY*ZNH3G(L0,NY,NX)
      H2GG(L0,NY,NX)=FY*H2GG(L0,NY,NX)
      H2GS(L0,NY,NX)=FY*H2GS(L0,NY,NX)
      ZNH4SH(L0,NY,NX)=FY*ZNH4SH(L0,NY,NX)
      ZNH3SH(L0,NY,NX)=FY*ZNH3SH(L0,NY,NX)
      ZNO3SH(L0,NY,NX)=FY*ZNO3SH(L0,NY,NX)
      ZNO2SH(L0,NY,NX)=FY*ZNO2SH(L0,NY,NX)
      H2PO4H(L0,NY,NX)=FY*H2PO4H(L0,NY,NX)
      ZNH4BH(L0,NY,NX)=FY*ZNH4BH(L0,NY,NX)
      ZNH3BH(L0,NY,NX)=FY*ZNH3BH(L0,NY,NX)
      ZNO3BH(L0,NY,NX)=FY*ZNO3BH(L0,NY,NX)
      ZNO2BH(L0,NY,NX)=FY*ZNO2BH(L0,NY,NX)
      H2POBH(L0,NY,NX)=FY*H2POBH(L0,NY,NX)
      ZALH(L0,NY,NX)=FY*ZALH(L0,NY,NX)
      ZFEH(L0,NY,NX)=FY*ZFEH(L0,NY,NX)
      ZHYH(L0,NY,NX)=FY*ZHYH(L0,NY,NX)
      ZCCH(L0,NY,NX)=FY*ZCCH(L0,NY,NX)
      ZMAH(L0,NY,NX)=FY*ZMAH(L0,NY,NX)
      ZNAH(L0,NY,NX)=FY*ZNAH(L0,NY,NX)
      ZKAH(L0,NY,NX)=FY*ZKAH(L0,NY,NX)
      ZOHH(L0,NY,NX)=FY*ZOHH(L0,NY,NX)
      ZSO4H(L0,NY,NX)=FY*ZSO4H(L0,NY,NX)
      ZCLH(L0,NY,NX)=FY*ZCLH(L0,NY,NX)
      ZCO3H(L0,NY,NX)=FY*ZCO3H(L0,NY,NX)
      ZHCO3H(L0,NY,NX)=FY*ZHCO3H(L0,NY,NX)
      ZALO1H(L0,NY,NX)=FY*ZALO1H(L0,NY,NX)
      ZALO2H(L0,NY,NX)=FY*ZALO2H(L0,NY,NX)
      ZALO3H(L0,NY,NX)=FY*ZALO3H(L0,NY,NX)
      ZALO4H(L0,NY,NX)=FY*ZALO4H(L0,NY,NX)
      ZALSH(L0,NY,NX)=FY*ZALSH(L0,NY,NX)
      ZFEO1H(L0,NY,NX)=FY*ZFEO1H(L0,NY,NX)
      ZFEO2H(L0,NY,NX)=FY*ZFEO2H(L0,NY,NX)
      ZFEO3H(L0,NY,NX)=FY*ZFEO3H(L0,NY,NX)
      ZFEO4H(L0,NY,NX)=FY*ZFEO4H(L0,NY,NX)
      ZFESH(L0,NY,NX)=FY*ZFESH(L0,NY,NX)
      ZCAOH(L0,NY,NX)=FY*ZCAOH(L0,NY,NX)
      ZCACH(L0,NY,NX)=FY*ZCACH(L0,NY,NX)
      ZCAHH(L0,NY,NX)=FY*ZCAHH(L0,NY,NX)
      ZCASH(L0,NY,NX)=FY*ZCASH(L0,NY,NX)
      ZMGOH(L0,NY,NX)=FY*ZMGOH(L0,NY,NX)
      ZMGCH(L0,NY,NX)=FY*ZMGCH(L0,NY,NX)
      ZMGHH(L0,NY,NX)=FY*ZMGHH(L0,NY,NX)
      ZMGSH(L0,NY,NX)=FY*ZMGSH(L0,NY,NX)
      ZNACH(L0,NY,NX)=FY*ZNACH(L0,NY,NX)
      ZNASH(L0,NY,NX)=FY*ZNASH(L0,NY,NX)
      ZKASH(L0,NY,NX)=FY*ZKASH(L0,NY,NX)
      H0PO4H(L0,NY,NX)=FY*H0PO4H(L0,NY,NX)
      H1PO4H(L0,NY,NX)=FY*H1PO4H(L0,NY,NX)
      H3PO4H(L0,NY,NX)=FY*H3PO4H(L0,NY,NX)
      ZFE1PH(L0,NY,NX)=FY*ZFE1PH(L0,NY,NX)
      ZFE2PH(L0,NY,NX)=FY*ZFE2PH(L0,NY,NX)
      ZCA0PH(L0,NY,NX)=FY*ZCA0PH(L0,NY,NX)
      ZCA1PH(L0,NY,NX)=FY*ZCA1PH(L0,NY,NX)
      ZCA2PH(L0,NY,NX)=FY*ZCA2PH(L0,NY,NX)
      ZMG1PH(L0,NY,NX)=FY*ZMG1PH(L0,NY,NX)
      H0POBH(L0,NY,NX)=FY*H0POBH(L0,NY,NX)
      H1POBH(L0,NY,NX)=FY*H1POBH(L0,NY,NX)
      H3POBH(L0,NY,NX)=FY*H3POBH(L0,NY,NX)
      ZFE1BH(L0,NY,NX)=FY*ZFE1BH(L0,NY,NX)
      ZFE2BH(L0,NY,NX)=FY*ZFE2BH(L0,NY,NX)
      ZCA0BH(L0,NY,NX)=FY*ZCA0BH(L0,NY,NX)
      ZCA1BH(L0,NY,NX)=FY*ZCA1BH(L0,NY,NX)
      ZCA2BH(L0,NY,NX)=FY*ZCA2BH(L0,NY,NX)
      ZMG1BH(L0,NY,NX)=FY*ZMG1BH(L0,NY,NX)
      CO2SH(L0,NY,NX)=FY*CO2SH(L0,NY,NX)
      CH4SH(L0,NY,NX)=FY*CH4SH(L0,NY,NX)
      OXYSH(L0,NY,NX)=FY*OXYSH(L0,NY,NX)
      Z2GSH(L0,NY,NX)=FY*Z2GSH(L0,NY,NX)
      Z2OSH(L0,NY,NX)=FY*Z2OSH(L0,NY,NX)
      ORGC(L0,NY,NX)=FY*ORGC(L0,NY,NX)
      ORGN(L0,NY,NX)=FY*ORGN(L0,NY,NX)
      DO 7865 K=0,5
      DO 7865 N=1,7
      DO 7865 M=1,3
      OMC(M,N,K,L0,NY,NX)=FY*OMC(M,N,K,L0,NY,NX)
      OMN(M,N,K,L0,NY,NX)=FY*OMN(M,N,K,L0,NY,NX)
      OMP(M,N,K,L0,NY,NX)=FY*OMP(M,N,K,L0,NY,NX)
7865  CONTINUE
      DO 7880 K=0,4
      DO 7875 M=1,2
      ORC(M,K,L0,NY,NX)=FY*ORC(M,K,L0,NY,NX)
      ORN(M,K,L0,NY,NX)=FY*ORN(M,K,L0,NY,NX)
      ORP(M,K,L0,NY,NX)=FY*ORP(M,K,L0,NY,NX)
7875  CONTINUE
      OQC(K,L0,NY,NX)=FY*OQC(K,L0,NY,NX)
      OQN(K,L0,NY,NX)=FY*OQN(K,L0,NY,NX)
      OQP(K,L0,NY,NX)=FY*OQP(K,L0,NY,NX)
      OQA(K,L0,NY,NX)=FY*OQA(K,L0,NY,NX)
      OQCH(K,L0,NY,NX)=FY*OQCH(K,L0,NY,NX)
      OQNH(K,L0,NY,NX)=FY*OQNH(K,L0,NY,NX)
      OQPH(K,L0,NY,NX)=FY*OQPH(K,L0,NY,NX)
      OQAH(K,L0,NY,NX)=FY*OQAH(K,L0,NY,NX)
      OHC(K,L0,NY,NX)=FY*OHC(K,L0,NY,NX)
      OHN(K,L0,NY,NX)=FY*OHN(K,L0,NY,NX)
      OHP(K,L0,NY,NX)=FY*OHP(K,L0,NY,NX)
      OHA(K,L0,NY,NX)=FY*OHA(K,L0,NY,NX)
      DO 7870 M=1,4
      OSC(M,K,L0,NY,NX)=FY*OSC(M,K,L0,NY,NX)
      OSA(M,K,L0,NY,NX)=FY*OSA(M,K,L0,NY,NX)
      OSN(M,K,L0,NY,NX)=FY*OSN(M,K,L0,NY,NX)
      OSP(M,K,L0,NY,NX)=FY*OSP(M,K,L0,NY,NX)
7870  CONTINUE
7880  CONTINUE
      IF(FY.EQ.0.0)THEN
      CCO2S(L0,NY,NX)=9999
      CCH4S(L0,NY,NX)=9999
      COXYS(L0,NY,NX)=9999
      THETW(L0,NY,NX)=9999
      THETI(L0,NY,NX)=9999
      PSISM(L0,NY,NX)=9999
      CZ2OS(L0,NY,NX)=9999
      CNH3S(L0,NY,NX)=9999
      TCS(L0,NY,NX)=9999
      ENDIF
      IFLGS(NY,NX)=1
      WRITE(*,5599)'ERODE2',I,J,NX,NY,L0,L1,NU(NY,NX),DNUMN,DNUMX
     2,DLYR(3,L0,NY,NX),DLYR(3,L1,NY,NX),FX 
      ENDIF
      ENDIF
C
C     RESIDUE REMOVAL IF REMOVAL EVENT IS ENTERED IN DISTURBANCE FILE
C
C    ZM added depth of burn var (DBURN) 2.3*5=11.5cm depth_increase
C    that can be estimated from burn-fraction input(DCORP)
C     
      IF(IYRC.LE.2010)THEN
      DBURN=0.15
C       
      ELSEIF(IYRC.GE.2011.AND.IYRC.LE.2030)THEN
      DBURN=0.18
      ELSEIF(IYRC.GE.2031.AND.IYRC.LE.2040)THEN
      DBURN=0.19
      ELSEIF(IYRC.GE.2041.AND.IYRC.LE.2050)THEN
      DBURN=0.21
      ELSEIF(IYRC.GE.2051.AND.IYRC.LE.2060)THEN
      DBURN=0.22 
      ELSEIF(IYRC.GE.2061.AND.IYRC.LE.2070)THEN
      DBURN=0.23
      ELSEIF(IYRC.GE.2071.AND.IYRC.LE.2080)THEN
      DBURN=0.24
      ELSEIF(IYRC.GE.2081.AND.IYRC.LE.2090)THEN
      DBURN=0.25
      ELSEIF(IYRC.GE.2091.AND.IYRC.LE.2100)THEN
      DBURN=0.27
      ELSEIF(IYRC.GE.2101.AND.IYRC.LE.2300)THEN
      DBURN=0.27
      ELSE
C      
      DBURN=0.28
C      DBURN=AMAX1(0.16,0.15+(DCORP(I,NY,NX)-0.85)*2.3)
      ENDIF
C   ZM
      IF(J.EQ.INT(ZNOON(NY,NX)).AND.(ITILL(I,NY,NX).EQ.21
     2.OR.ITILL(I,NY,NX).EQ.22))THEN
      IF(ITILL(I,NY,NX).EQ.22)THEN
      IFLGQ=0
      NLL=-1
      DO 2945 L=0,NL(NY,NX)
C     WRITE(*,9494)'FIRE',I,J,L,IFLGQ,NLL,THETW(L,NY,NX)
9494  FORMAT(A8,5I6,12E12.4)
      IF(L.EQ.0.OR.L.GE.NU(NY,NX))THEN
      IF(IFLGQ.EQ.1)THEN
      GO TO 2946
C     ZM added : replaced 0.15 by depth of burn(DBURN)            
C     ZM turned off SWC(FVLWB),SOC(FVLWB)combustion constraints
C    +added limited DEPTH-DBURN. FVLWB and FORGC are set in starts.f   
C     ELSEIF(THETW(L,NY,NX).GT.FVLWB.OR.CORGC(L,NY,NX).LE.FORGC)THEN
      ELSEIF(CORGC(L,NY,NX).LE.FORGC.OR.CDPTH(L,NY,NX).GT.DBURN)THEN
      IFLGQ=1
      ELSE
      NLL=L
      ENDIF
      ENDIF
2945  CONTINUE
      ELSE
      NLL=0
      ENDIF
2946  CONTINUE
      DO 2950 L=0,NLL
      IF(NLL.GE.0)THEN
      IF(ITILL(I,NY,NX).EQ.22)THEN
      DCORPC=AMIN1(0.999,DCORP(I,NY,NX))*(CORGC(L,NY,NX)-FORGC)
     2/(0.5E+06-FORGC)
      ELSE
      DCORPC=AMIN1(0.999,DCORP(I,NY,NX))
      ENDIF
C     WRITE(*,9696)'BURN',I,J,L,NLL,CORGC(L,NY,NX)
C    2,FORGC,DCORPC,DCORP(I,NY,NX)
9696  FORMAT(A8,4I6,12E12.4)
      VOLWOU=VOLWOU+DCORPC*VOLW(L,NY,NX)
      HEATOU=HEATOU+DCORPC*4.19*TKS(L,NY,NX)*VOLW(L,NY,NX)
      VOLW(L,NY,NX)=VOLW(L,NY,NX)-DCORPC*VOLW(L,NY,NX)
      OSGX=ORGC(L,NY,NX)
      OC=0.0
      ON=0.0
      OP=0.0
      RC=0.0
      RN=0.0
      RP=0.0
      DO 2955 K=0,4
      DO 2955 M=1,4
      ONL(M,K)=0.0
      OPL(M,K)=0.0
2955  CONTINUE
      DO 2970 K=0,5
      IF(L.NE.0.OR.(K.NE.3.AND.K.NE.4))THEN
C
C     REMOVE MICROBIAL BIOMASS
C
      DO 2960 N=1,7
      DO 2960 M=1,3
      OCH=DCORPC*OMC(M,N,K,L,NY,NX)
      ONH=DCORPC*OMN(M,N,K,L,NY,NX)
      OPH=DCORPC*OMP(M,N,K,L,NY,NX)
      ONX=EFIRE(1,ITILL(I,NY,NX))*ONH
      OPX=EFIRE(2,ITILL(I,NY,NX))*OPH
      IF(K.LE.2)THEN
      ONL(4,K)=ONL(4,K)+ONH-ONX
      OPL(4,K)=OPL(4,K)+OPH-OPX
      ELSEIF(K.LE.4)THEN
      ONL(1,K)=ONL(1,K)+ONH-ONX 
      OPL(1,K)=OPL(1,K)+OPH-OPX
      ELSEIF(K.EQ.5)THEN
      ONL(4,1)=ONL(4,1)+ONH-ONX
      OPL(4,1)=OPL(4,1)+OPH-OPX
      ENDIF
      OMC(M,N,K,L,NY,NX)=OMC(M,N,K,L,NY,NX)-OCH
      OMN(M,N,K,L,NY,NX)=OMN(M,N,K,L,NY,NX)-ONH
      OMP(M,N,K,L,NY,NX)=OMP(M,N,K,L,NY,NX)-OPH
      RC=RC+OMC(M,N,K,L,NY,NX)
      RN=RN+OMN(M,N,K,L,NY,NX)
      RP=RP+OMP(M,N,K,L,NY,NX)
      TOMT(NY,NX)=TOMT(NY,NX)+OMC(M,N,K,L,NY,NX)
      TONT(NY,NX)=TONT(NY,NX)+OMN(M,N,K,L,NY,NX)
      TOPT(NY,NX)=TOPT(NY,NX)+OMP(M,N,K,L,NY,NX)
      OMCL(L,NY,NX)=OMCL(L,NY,NX)+OMC(M,N,K,L,NY,NX)
      OMNL(L,NY,NX)=OMNL(L,NY,NX)+OMN(M,N,K,L,NY,NX)
      OC=OC+OCH
      ON=ON+ONX
      OP=OP+OPX
C
C ZM ADDED OMCN and OMNN for each microbial group
C
      OMCN1(L,NY,NX)=OMCN1(L,NY,NX)+OMC(M,1,K,L,NY,NX)
      OMCN2(L,NY,NX)=OMCN2(L,NY,NX)+OMC(M,2,K,L,NY,NX)
      OMCN3(L,NY,NX)=OMCN3(L,NY,NX)+OMC(M,3,K,L,NY,NX)
      OMCN4(L,NY,NX)=OMCN4(L,NY,NX)+OMC(M,4,K,L,NY,NX)
      OMCN5(L,NY,NX)=OMCN5(L,NY,NX)+OMC(M,5,K,L,NY,NX)
      OMCN6(L,NY,NX)=OMCN6(L,NY,NX)+OMC(M,6,K,L,NY,NX)
      OMCN7(L,NY,NX)=OMCN7(L,NY,NX)+OMC(M,7,K,L,NY,NX)
C      OMNN1(L,NY,NX)=OMNN1(L,NY,NX)+OMN(M,1,K,L,NY,NX)
C      OMNN2(L,NY,NX)=OMNN2(L,NY,NX)+OMN(M,2,K,L,NY,NX)
C      OMNN3(L,NY,NX)=OMNN3(L,NY,NX)+OMN(M,3,K,L,NY,NX)
C      OMNN4(L,NY,NX)=OMNN4(L,NY,NX)+OMN(M,4,K,L,NY,NX)
C      OMNN5(L,NY,NX)=OMNN5(L,NY,NX)+OMN(M,5,K,L,NY,NX)
C      OMNN6(L,NY,NX)=OMNN6(L,NY,NX)+OMN(M,6,K,L,NY,NX)
C      OMNN7(L,NY,NX)=OMNN7(L,NY,NX)+OMN(M,7,K,L,NY,NX)
C   
C      OMCNA1(L,NY,NX)=OMCNA1(L,NY,NX)+OMC(M,1,5,L,NY,NX)
C      OMCNA2(L,NY,NX)=OMCNA2(L,NY,NX)+OMC(M,2,5,L,NY,NX)
C      OMCNA3(L,NY,NX)=OMCNA3(L,NY,NX)+OMC(M,3,5,L,NY,NX)
C      OMCNA5(L,NY,NX)=OMCNA5(L,NY,NX)+OMC(M,4,5,L,NY,NX)
C      OMNNA1(L,NY,NX)=OMNNA1(L,NY,NX)+OMC(M,1,5,L,NY,NX)
C      OMNNA2(L,NY,NX)=OMNNA2(L,NY,NX)+OMC(M,2,5,L,NY,NX)
C      OMNNA3(L,NY,NX)=OMNNA3(L,NY,NX)+OMC(M,3,5,L,NY,NX)
C      OMNNA5(L,NY,NX)=OMNNA5(L,NY,NX)+OMC(M,4,5,L,NY,NX) 
C   zm   
C
2960  CONTINUE
      ENDIF
2970  CONTINUE
C
C     REMOVE MICROBIAL RESIDUE
C
      DO 2900 K=0,4
      IF(L.NE.0.OR.(K.NE.3.AND.K.NE.4))THEN
      DO 2940 M=1,2
      OCH=DCORPC*ORC(M,K,L,NY,NX)
      ONH=DCORPC*ORN(M,K,L,NY,NX)
      OPH=DCORPC*ORP(M,K,L,NY,NX)
      ONX=EFIRE(1,ITILL(I,NY,NX))*ONH
      OPX=EFIRE(2,ITILL(I,NY,NX))*OPH
      IF(K.LE.2)THEN
      ONL(4,K)=ONL(4,K)+ONH-ONX
      OPL(4,K)=OPL(4,K)+OPH-OPX
      ELSE
      ONL(1,K)=ONL(1,K)+ONH-ONX 
      OPL(1,K)=OPL(1,K)+OPH-OPX
      ENDIF
      ORC(M,K,L,NY,NX)=ORC(M,K,L,NY,NX)-OCH
      ORN(M,K,L,NY,NX)=ORN(M,K,L,NY,NX)-ONH
      ORP(M,K,L,NY,NX)=ORP(M,K,L,NY,NX)-OPH
      RC=RC+ORC(M,K,L,NY,NX)
      RN=RN+ORN(M,K,L,NY,NX)
      RP=RP+ORP(M,K,L,NY,NX)
      OC=OC+OCH
      ON=ON+ONX
      OP=OP+OPX
2940  CONTINUE
C
C     REMOVE DOC, DON, DOP
C
      OCH=DCORPC*OQC(K,L,NY,NX)
      OCA=DCORPC*OQA(K,L,NY,NX)
      ONH=DCORPC*OQN(K,L,NY,NX)
      OPH=DCORPC*OQP(K,L,NY,NX)
      ONX=EFIRE(1,ITILL(I,NY,NX))*ONH
      OPX=EFIRE(2,ITILL(I,NY,NX))*OPH
      IF(K.LE.2)THEN
      ONL(4,K)=ONL(4,K)+ONH-ONX
      OPL(4,K)=OPL(4,K)+OPH-OPX
      ELSE
      ONL(1,K)=ONL(1,K)+ONH-ONX 
      OPL(1,K)=OPL(1,K)+OPH-OPX
      ENDIF
      OQC(K,L,NY,NX)=OQC(K,L,NY,NX)-OCH
      OQA(K,L,NY,NX)=OQA(K,L,NY,NX)-OCA
      OQN(K,L,NY,NX)=OQN(K,L,NY,NX)-ONH
      OQP(K,L,NY,NX)=OQP(K,L,NY,NX)-OPH
      OC=OC+OCH+OCA
      ON=ON+ONX
      OP=OP+OPX
      OCH=DCORPC*OQCH(K,L,NY,NX)
      ONH=DCORPC*OQNH(K,L,NY,NX)
      OPH=DCORPC*OQPH(K,L,NY,NX)
      OAH=DCORPC*OQAH(K,L,NY,NX)
      ONX=EFIRE(1,ITILL(I,NY,NX))*ONH
      OPX=EFIRE(2,ITILL(I,NY,NX))*OPH
      IF(K.LE.2)THEN
      ONL(4,K)=ONL(4,K)+ONH-ONX
      OPL(4,K)=OPL(4,K)+OPH-OPX
      ELSE
      ONL(1,K)=ONL(1,K)+ONH-ONX 
      OPL(1,K)=OPL(1,K)+OPH-OPX
      ENDIF
      OQCH(K,L,NY,NX)=OQCH(K,L,NY,NX)-OCH
      OQNH(K,L,NY,NX)=OQNH(K,L,NY,NX)-ONH
      OQPH(K,L,NY,NX)=OQPH(K,L,NY,NX)-OPH
      OQAH(K,L,NY,NX)=OQAH(K,L,NY,NX)-OAH
      OC=OC+OCH+OAH
      ON=ON+ONX
      OP=OP+OPX
C
C     REMOVE ADSORBED OM 
C
      OCH=DCORPC*OHC(K,L,NY,NX)
      ONH=DCORPC*OHN(K,L,NY,NX)
      OPH=DCORPC*OHP(K,L,NY,NX)
      OAH=DCORPC*OHA(K,L,NY,NX)
      ONX=EFIRE(1,ITILL(I,NY,NX))*ONH
      OPX=EFIRE(2,ITILL(I,NY,NX))*OPH
      IF(K.LE.2)THEN
      ONL(4,K)=ONL(4,K)+ONH-ONX
      OPL(4,K)=OPL(4,K)+OPH-OPX
      ELSE
      ONL(1,K)=ONL(1,K)+ONH-ONX 
      OPL(1,K)=OPL(1,K)+OPH-OPX
      ENDIF
      OHC(K,L,NY,NX)=OHC(K,L,NY,NX)-OCH
      OHN(K,L,NY,NX)=OHN(K,L,NY,NX)-ONH
      OHP(K,L,NY,NX)=OHP(K,L,NY,NX)-OPH
      OHA(K,L,NY,NX)=OHA(K,L,NY,NX)-OAH
      RC=RC+OQC(K,L,NY,NX)+OQCH(K,L,NY,NX)+OHC(K,L,NY,NX)
     2+OQA(K,L,NY,NX)+OQAH(K,L,NY,NX)+OHA(K,L,NY,NX)
      RN=RN+OQN(K,L,NY,NX)+OQNH(K,L,NY,NX)+OHN(K,L,NY,NX)
      RP=RP+OQP(K,L,NY,NX)+OQPH(K,L,NY,NX)+OHP(K,L,NY,NX)
      OC=OC+OCH
      ON=ON+ONX
      OP=OP+OPX
C
C     REMOVE RESIDUE
C
      DO 2930 M=1,4
      OCH=DCORPC*OSC(M,K,L,NY,NX)
      OCA=DCORPC*OSA(M,K,L,NY,NX)
      ONH=DCORPC*OSN(M,K,L,NY,NX)
      OPH=DCORPC*OSP(M,K,L,NY,NX)
      ONX=EFIRE(1,ITILL(I,NY,NX))*ONH
      OPX=EFIRE(2,ITILL(I,NY,NX))*OPH
      ONL(M,K)=ONL(M,K)+ONH-ONX
      OPL(M,K)=OPL(M,K)+OPH-OPX
      OSC(M,K,L,NY,NX)=OSC(M,K,L,NY,NX)-OCH
      OSA(M,K,L,NY,NX)=OSA(M,K,L,NY,NX)-OCA
      OSN(M,K,L,NY,NX)=OSN(M,K,L,NY,NX)-ONH
      OSP(M,K,L,NY,NX)=OSP(M,K,L,NY,NX)-OPH
      RC=RC+OSC(M,K,L,NY,NX)
      RN=RN+OSN(M,K,L,NY,NX)
      RP=RP+OSP(M,K,L,NY,NX)
      OC=OC+OCH
      ON=ON+ONX
      OP=OP+OPX
2930  CONTINUE
      ENDIF
2900  CONTINUE
C
C     ADD UNBURNED N,P TO ORG N, ORG P
C
      DO 2905 K=0,4
      DO 2905 M=1,4
      OSN(M,K,L,NY,NX)=OSN(M,K,L,NY,NX)+ONL(M,K)
      OSP(M,K,L,NY,NX)=OSP(M,K,L,NY,NX)+OPL(M,K)
      RN=RN+ONL(M,K)
      RP=RP+OPL(M,K)
2905  CONTINUE
C
C     REMOVE FERTILIZER IN RESIDUE
C
      IF(ITILL(I,NY,NX).EQ.21)THEN
      ON=ON+DCORPC*(ZNH4S(L,NY,NX)+ZNH3S(L,NY,NX)
     2+ZNO3S(L,NY,NX)+ZNO2S(L,NY,NX))
      OP=OP+DCORPC*H2PO4(L,NY,NX)
      TIONOU=TIONOU+DCORPC*(ZNH3FA(L,NY,NX)+ZNO3FA(L,NY,NX)
     2+ZNHUFA(L,NY,NX)+2.0*(XN4(L,NY,NX)+PALPO(L,NY,NX)+PFEPO(L,NY,NX) 
     2+ZNH4FA(L,NY,NX))+3.0*PCAPD(L,NY,NX)+7.0*PCAPM(L,NY,NX)
     3+9.0*PCAPH(L,NY,NX))
      ZNH4S(L,NY,NX)=(1.0-DCORPC)*ZNH4S(L,NY,NX)
      ZNH3S(L,NY,NX)=(1.0-DCORPC)*ZNH3S(L,NY,NX)
      ZNO3S(L,NY,NX)=(1.0-DCORPC)*ZNO3S(L,NY,NX)
      ZNO2S(L,NY,NX)=(1.0-DCORPC)*ZNO2S(L,NY,NX)
      H2PO4(L,NY,NX)=(1.0-DCORPC)*H2PO4(L,NY,NX)
      XN4(L,NY,NX)=(1.0-DCORPC)*XN4(L,NY,NX)
      PALPO(L,NY,NX)=(1.0-DCORPC)*PALPO(L,NY,NX)
      PFEPO(L,NY,NX)=(1.0-DCORPC)*PFEPO(L,NY,NX)
      PCAPD(L,NY,NX)=(1.0-DCORPC)*PCAPD(L,NY,NX)
      PCAPH(L,NY,NX)=(1.0-DCORPC)*PCAPH(L,NY,NX)
      PCAPM(L,NY,NX)=(1.0-DCORPC)*PCAPM(L,NY,NX)
      ZNH4FA(L,NY,NX)=(1.0-DCORPC)*ZNH4FA(L,NY,NX)
      ZNH3FA(L,NY,NX)=(1.0-DCORPC)*ZNH3FA(L,NY,NX)
      ZNHUFA(L,NY,NX)=(1.0-DCORPC)*ZNHUFA(L,NY,NX)
      ZNO3FA(L,NY,NX)=(1.0-DCORPC)*ZNO3FA(L,NY,NX)
      ENDIF
      ORGC(L,NY,NX)=RC
      ORGN(L,NY,NX)=RN
      HFLXD=4.19E-06*(OSGX-ORGC(L,NY,NX))*TKS(L,NY,NX)
      HEATOU=HEATOU+HFLXD
      IF(L.EQ.0)THEN
      VHCPR(NY,NX)=2.496E-06*ORGC(0,NY,NX)+4.19*VOLW(0,NY,NX)
     2+1.9274*VOLI(0,NY,NX)
      ELSE
      VHCP(L,NY,NX)=VHCM(L,NY,NX)+4.19*(VOLW(L,NY,NX)+VOLWH(L,NY,NX))
     2+1.9274*(VOLI(L,NY,NX)+VOLIH(L,NY,NX))
      ENDIF
      IF(ITILL(I,NY,NX).EQ.21)THEN
      TCOU=TCOU+OC
      TZOU=TZOU+ON
      TPOU=TPOU+OP
      UDOCQ(NY,NX)=UDOCQ(NY,NX)+OC
      UDONQ(NY,NX)=UDONQ(NY,NX)+ON
      UDOPQ(NY,NX)=UDOPQ(NY,NX)+OP
      TNBP(NY,NX)=TNBP(NY,NX)-OC
      ELSEIF(ITILL(I,NY,NX).EQ.22)THEN
      CO2GIN=CO2GIN-OC
      OXYGIN=OXYGIN+2.667*OC
      OXYGOU=OXYGOU+2.667*OC
      TZOU=TZOU+ON
      TPOU=TPOU+OP
      UCO2F(NY,NX)=UCO2F(NY,NX)-(1.0-FCH4F)*OC
      UCH4F(NY,NX)=UCH4F(NY,NX)-FCH4F*OC
      UOXYF(NY,NX)=UOXYF(NY,NX)+(1.0-FCH4F)*2.667*OC
      UNH3F(NY,NX)=UNH3F(NY,NX)-ON
      UN2OF(NY,NX)=UN2OF(NY,NX)-0.0
      UPO4F(NY,NX)=UPO4F(NY,NX)-OP
      TNBP(NY,NX)=TNBP(NY,NX)-OC
      ENDIF
      ENDIF
2950  CONTINUE
C     IFLGS(NY,NX)=1
      ENDIF
C
C     CHANGE WATER TABLE DEPTH THROUGH DRAINAGE
C
      IF(J.EQ.INT(ZNOON(NY,NX)).AND.ITILL(I,NY,NX).EQ.23)THEN
      DTBLI(NY,NX)=DCORP(I,NY,NX)
      IF(BKDS(NU(NY,NX),NY,NX).GT.0.0)THEN
      DTBLZ(NY,NX)=AMAX1(0.0,DTBLI(NY,NX)-(ALTZ(NY,NX)-ALT(NY,NX))
     2*(1.0-DTBLG(NY,NX)))
      ELSE
      DTBLZ(NY,NX)=0.0
      ENDIF
      ENDIF
      IF(J.EQ.INT(ZNOON(NY,NX)).AND.ITILL(I,NY,NX).EQ.24)THEN
      DDRGI(NY,NX)=DCORP(I,NY,NX)
      IF(BKDS(NU(NY,NX),NY,NX).GT.0.0)THEN
      DDRG(NY,NX)=AMAX1(0.0,DDRGI(NY,NX)-(ALTZ(NY,NX)-ALT(NY,NX))
     2*(1.0-DTBLG(NY,NX)))
      ELSE
      DDRG(NY,NX)=0.0
      ENDIF
      ENDIF
C
C     MIX ALL SOIL STATE VARIABLES AND INCORPORATE ALL SURFACE
C     RESIDUE STATE VARIABLES WITHIN THE TILLAGE ZONE TO THE EXTENT
C     ASSOCIATED IN 'DAY' WITH EACH TILLAGE EVENT ENTERED IN THE
C     TILLAGE FILE
C
      IF(J.EQ.INT(ZNOON(NY,NX)).AND.XCORP(NY,NX).LT.1.0
     2.AND.DCORP(I,NY,NX).GT.0.0)THEN
C
C     EXTENT OF MIXING
C
      CORP=1.0-XCORP(NY,NX)
C
C     TEMPORARY ACCUMULATORS
C
      URAIQ(NY,NX)=0.0
      TBKDS=0.0
      TFC=0.0
      TWP=0.0
      TSCNV=0.0
      TSCNH=0.0
      TSAND=0.0
      TSILT=0.0
      TCLAY=0.0
      TXCEC=0.0
      TXAEC=0.0
      TGKC4=0.0
      TGKCA=0.0
      TGKCM=0.0
      TGKCN=0.0
      TGKCK=0.0
      TVOLW=0.0
      TVOLI=0.0
      TVOLP=0.0
      TVOLA=0.0
      TENGY=0.0
      TVHCM=0.0
      TNH4FA=0.0
      TNH3FA=0.0
      TNHUFA=0.0
      TNO3FA=0.0
      TNH4FB=0.0
      TNH3FB=0.0
      TNHUFB=0.0
      TNO3FB=0.0
      TNH4S=0.0
      TNH4B=0.0
      TNH3S=0.0
      TNH3B=0.0
      TNO3S=0.0
      TNO3B=0.0
      TNO2S=0.0
      TNO2B=0.0
      TZAL=0.0
      TZFE=0.0
      TZHY=0.0
      TZCA=0.0
      TZMG=0.0
      TZNA=0.0
      TZKA=0.0
      TZOH=0.0
      TZSO4=0.0
      TZCL=0.0
      TZCO3=0.0
      TZHCO3=0.0
      TZALO1=0.0
      TZALO2=0.0
      TZALO3=0.0
      TZALO4=0.0
      TZALS=0.0
      TZFEO1=0.0
      TZFEO2=0.0
      TZFEO3=0.0
      TZFEO4=0.0
      TZFES=0.0
      TZCAO=0.0
      TZCAC=0.0
      TZCAH=0.0
      TZCAS=0.0
      TZMGO=0.0
      TZMGC=0.0
      TZMGH=0.0
      TZMGS=0.0
      TZNAC=0.0
      TZNAS=0.0
      TZKAS=0.0
      TH0PO4=0.0
      TH1PO4=0.0
      TH2PO4=0.0
      TH3PO4=0.0
      TZFE1P=0.0
      TZFE2P=0.0
      TZCA0P=0.0
      TZCA1P=0.0
      TZCA2P=0.0
      TZMG1P=0.0
      TH0POB=0.0
      TH1POB=0.0
      TH2POB=0.0
      TH3POB=0.0
      TFE1PB=0.0
      TFE2PB=0.0
      TCA0PB=0.0
      TCA1PB=0.0
      TCA2PB=0.0
      TMG1PB=0.0
      TXNH4=0.0
      TXNHB=0.0
      TXHY=0.0
      TXAL=0.0
      TXCA=0.0
      TXMG=0.0
      TXNA=0.0
      TXKA=0.0
      TXHC=0.0
      TXAL2=0.0
      TXOH0=0.0
      TXOH1=0.0
      TXOH2=0.0
      TXH1P=0.0
      TXH2P=0.0
      TXOH0B=0.0
      TXOH1B=0.0
      TXOH2B=0.0
      TXH1PB=0.0
      TXH2PB=0.0
      TPALOH=0.0
      TPFEOH=0.0
      TPCACO=0.0
      TPCASO=0.0
      TPALPO=0.0
      TPFEPO=0.0
      TPCAPD=0.0
      TPCAPH=0.0
      TPCAPM=0.0
      TPALPB=0.0
      TPFEPB=0.0
      TPCPDB=0.0
      TPCPHB=0.0
      TPCPMB=0.0
      TCO2G=0.0
      TCH4G=0.0
      TCOZS=0.0
      TCHFS=0.0
      TOXYG=0.0
      TOXYS=0.0
      TZ2GG=0.0
      TZ2GS=0.0
      TZ2OG=0.0
      TZ2OS=0.0
      TZNH3G=0.0
      TH2GG=0.0
      TH2GS=0.0
      DO 3990 K=0,5
      DO 3990 N=1,7
      DO 3990 M=1,3
      TOMC(M,N,K)=0.0
      TOMN(M,N,K)=0.0
      TOMP(M,N,K)=0.0
3990  CONTINUE
      DO 3980 K=0,4
      DO 3975 M=1,2
      TORC(M,K)=0.0
      TORN(M,K)=0.0
      TORP(M,K)=0.0
3975  CONTINUE
      TOQC(K)=0.0
      TOQN(K)=0.0
      TOQP(K)=0.0
      TOQA(K)=0.0
      TOHC(K)=0.0
      TOHN(K)=0.0
      TOHP(K)=0.0
      TOHA(K)=0.0
      DO 3970 M=1,4
      TOSC(M,K)=0.0
      TOSA(M,K)=0.0
      TOSN(M,K)=0.0
      TOSP(M,K)=0.0
3970  CONTINUE
3980  CONTINUE
C
C     ACCUMULATE STATE VARIABLES IN SURFACE RESIDUE FOR ADDITION
C     TO SOIL IN TILLAGE MIXING ZONE
C
      RC=0.0
      RN=0.0
      RP=0.0
      DO 3950 K=0,5
      IF(K.NE.3.AND.K.NE.4)THEN
      DO 3945 N=1,7
      DO 3945 M=1,3
      TOMGC(M,N,K)=OMC(M,N,K,0,NY,NX)*CORP
      TOMGN(M,N,K)=OMN(M,N,K,0,NY,NX)*CORP
      TOMGP(M,N,K)=OMP(M,N,K,0,NY,NX)*CORP
      OMC(M,N,K,0,NY,NX)=OMC(M,N,K,0,NY,NX)*XCORP(NY,NX)
      OMN(M,N,K,0,NY,NX)=OMN(M,N,K,0,NY,NX)*XCORP(NY,NX)
      OMP(M,N,K,0,NY,NX)=OMP(M,N,K,0,NY,NX)*XCORP(NY,NX)
      RC=RC+OMC(M,N,K,0,NY,NX)
      RN=RN+OMN(M,N,K,0,NY,NX)
      RP=RP+OMP(M,N,K,0,NY,NX)
3945  CONTINUE
      ENDIF
3950  CONTINUE
      DO 3940 K=0,2
      DO 3935 M=1,2
      TORXC(M,K)=ORC(M,K,0,NY,NX)*CORP
      TORXN(M,K)=ORN(M,K,0,NY,NX)*CORP
      TORXP(M,K)=ORP(M,K,0,NY,NX)*CORP
      ORC(M,K,0,NY,NX)=ORC(M,K,0,NY,NX)*XCORP(NY,NX)
      ORN(M,K,0,NY,NX)=ORN(M,K,0,NY,NX)*XCORP(NY,NX)
      ORP(M,K,0,NY,NX)=ORP(M,K,0,NY,NX)*XCORP(NY,NX)
      RC=RC+ORC(M,K,0,NY,NX)
      RN=RN+ORN(M,K,0,NY,NX)
      RP=RP+ORP(M,K,0,NY,NX)
3935  CONTINUE
      TOQGC(K)=OQC(K,0,NY,NX)*CORP
      TOQGN(K)=OQN(K,0,NY,NX)*CORP
      TOQGP(K)=OQP(K,0,NY,NX)*CORP
      TOQGA(K)=OQA(K,0,NY,NX)*CORP
      TOQHC(K)=OQCH(K,0,NY,NX)*CORP
      TOQHN(K)=OQNH(K,0,NY,NX)*CORP
      TOQHP(K)=OQPH(K,0,NY,NX)*CORP
      TOQHA(K)=OQAH(K,0,NY,NX)*CORP
      TOHGC(K)=OHC(K,0,NY,NX)*CORP
      TOHGN(K)=OHN(K,0,NY,NX)*CORP
      TOHGP(K)=OHP(K,0,NY,NX)*CORP
      TOHGA(K)=OHA(K,0,NY,NX)*CORP
C
C     REDUCE SURFACE RESIDUE STATE VARIABLES FOR INCORPORATION
C
      OQC(K,0,NY,NX)=OQC(K,0,NY,NX)*XCORP(NY,NX)
      OQN(K,0,NY,NX)=OQN(K,0,NY,NX)*XCORP(NY,NX)
      OQP(K,0,NY,NX)=OQP(K,0,NY,NX)*XCORP(NY,NX)
      OQA(K,0,NY,NX)=OQA(K,0,NY,NX)*XCORP(NY,NX)
      OQCH(K,0,NY,NX)=OQCH(K,0,NY,NX)*XCORP(NY,NX)
      OQNH(K,0,NY,NX)=OQNH(K,0,NY,NX)*XCORP(NY,NX)
      OQPH(K,0,NY,NX)=OQPH(K,0,NY,NX)*XCORP(NY,NX)
      OQAH(K,0,NY,NX)=OQAH(K,0,NY,NX)*XCORP(NY,NX)
      OHC(K,0,NY,NX)=OHC(K,0,NY,NX)*XCORP(NY,NX)
      OHN(K,0,NY,NX)=OHN(K,0,NY,NX)*XCORP(NY,NX)
      OHP(K,0,NY,NX)=OHP(K,0,NY,NX)*XCORP(NY,NX)
      OHA(K,0,NY,NX)=OHA(K,0,NY,NX)*XCORP(NY,NX)
      RC=RC+OQC(K,0,NY,NX)+OQCH(K,0,NY,NX)+OHC(K,0,NY,NX)+OQA(K,0,NY,NX)
     2+OQAH(K,0,NY,NX)+OHA(K,0,NY,NX)
      RN=RN+OQN(K,0,NY,NX)+OQNH(K,0,NY,NX)+OHN(K,0,NY,NX)
      RP=RP+OQP(K,0,NY,NX)+OQPH(K,0,NY,NX)+OHP(K,0,NY,NX)
      DO 3965 M=1,4
      TOSGC(M,K)=OSC(M,K,0,NY,NX)*CORP
      TOSGA(M,K)=OSA(M,K,0,NY,NX)*CORP
      TOSGN(M,K)=OSN(M,K,0,NY,NX)*CORP
      TOSGP(M,K)=OSP(M,K,0,NY,NX)*CORP
      OSC(M,K,0,NY,NX)=OSC(M,K,0,NY,NX)*XCORP(NY,NX)
      OSA(M,K,0,NY,NX)=OSA(M,K,0,NY,NX)*XCORP(NY,NX)
      OSN(M,K,0,NY,NX)=OSN(M,K,0,NY,NX)*XCORP(NY,NX)
      OSP(M,K,0,NY,NX)=OSP(M,K,0,NY,NX)*XCORP(NY,NX)
      RC=RC+OSC(M,K,0,NY,NX)
      RN=RN+OSN(M,K,0,NY,NX)
      RP=RP+OSP(M,K,0,NY,NX)
3965  CONTINUE
3940  CONTINUE
      TCO2GS=CO2S(0,NY,NX)*CORP
      TCH4GS=CH4S(0,NY,NX)*CORP
      TOXYGS=OXYS(0,NY,NX)*CORP
      TZ2GSG=Z2GS(0,NY,NX)*CORP
      TZ2OGS=Z2OS(0,NY,NX)*CORP
      TH2GGS=H2GS(0,NY,NX)*CORP
      TNH4GS=ZNH4S(0,NY,NX)*CORP
      TNH3GS=ZNH3S(0,NY,NX)*CORP
      TNO3GS=ZNO3S(0,NY,NX)*CORP
      TNO2GS=ZNO2S(0,NY,NX)*CORP
      TPO4GS=H2PO4(0,NY,NX)*CORP
      TXN4G=XN4(0,NY,NX)*CORP
      TXOH0G=XOH0(0,NY,NX)*CORP
      TXOH1G=XOH1(0,NY,NX)*CORP
      TXOH2G=XOH2(0,NY,NX)*CORP
      TXH1PG=XH1P(0,NY,NX)*CORP
      TXH2PG=XH2P(0,NY,NX)*CORP
      TALPOG=PALPO(0,NY,NX)*CORP
      TFEPOG=PFEPO(0,NY,NX)*CORP
      TCAPDG=PCAPD(0,NY,NX)*CORP
      TCAPHG=PCAPH(0,NY,NX)*CORP
      TCAPMG=PCAPM(0,NY,NX)*CORP
      TNH4FG=ZNH4FA(0,NY,NX)*CORP
      TNH3FG=ZNH3FA(0,NY,NX)*CORP
      TNHUFG=ZNHUFA(0,NY,NX)*CORP
      TNO3FG=ZNO3FA(0,NY,NX)*CORP
      TVOLWR=VOLW(0,NY,NX)*CORP
      TVOLIR=VOLI(0,NY,NX)*CORP
      HFLXD=2.496E-06*ORGC(0,NY,NX)*CORP*TKS(0,NY,NX)
      HEATIN=HEATIN-HFLXD 
      HEATSO=HEATSO-HFLXD 
      TENGYR=(4.19*TVOLWR+1.9274*TVOLIR)*TKS(0,NY,NX)
      ORGC(0,NY,NX)=RC
      ORGN(0,NY,NX)=RN
      ORGR(0,NY,NX)=RC
      CO2S(0,NY,NX)=CO2S(0,NY,NX)*XCORP(NY,NX)
      CH4S(0,NY,NX)=CH4S(0,NY,NX)*XCORP(NY,NX)
      OXYS(0,NY,NX)=OXYS(0,NY,NX)*XCORP(NY,NX)
      Z2GS(0,NY,NX)=Z2GS(0,NY,NX)*XCORP(NY,NX)
      Z2OS(0,NY,NX)=Z2OS(0,NY,NX)*XCORP(NY,NX)
      H2GS(0,NY,NX)=H2GS(0,NY,NX)*XCORP(NY,NX)
      ZNH4S(0,NY,NX)=ZNH4S(0,NY,NX)*XCORP(NY,NX)
      ZNH3S(0,NY,NX)=ZNH3S(0,NY,NX)*XCORP(NY,NX)
      ZNO3S(0,NY,NX)=ZNO3S(0,NY,NX)*XCORP(NY,NX)
      ZNO2S(0,NY,NX)=ZNO2S(0,NY,NX)*XCORP(NY,NX)
      H2PO4(0,NY,NX)=H2PO4(0,NY,NX)*XCORP(NY,NX)
      XN4(0,NY,NX)=XN4(0,NY,NX)*XCORP(NY,NX)
      XOH0(0,NY,NX)=XOH0(0,NY,NX)*XCORP(NY,NX)
      XOH1(0,NY,NX)=XOH1(0,NY,NX)*XCORP(NY,NX)
      XOH2(0,NY,NX)=XOH2(0,NY,NX)*XCORP(NY,NX)
      XH1P(0,NY,NX)=XH1P(0,NY,NX)*XCORP(NY,NX)
      XH2P(0,NY,NX)=XH2P(0,NY,NX)*XCORP(NY,NX)
      PALPO(0,NY,NX)=PALPO(0,NY,NX)*XCORP(NY,NX)
      PFEPO(0,NY,NX)=PFEPO(0,NY,NX)*XCORP(NY,NX)
      PCAPD(0,NY,NX)=PCAPD(0,NY,NX)*XCORP(NY,NX)
      PCAPH(0,NY,NX)=PCAPH(0,NY,NX)*XCORP(NY,NX)
      PCAPM(0,NY,NX)=PCAPM(0,NY,NX)*XCORP(NY,NX)
      ZNH4FA(0,NY,NX)=ZNH4FA(0,NY,NX)*XCORP(NY,NX)
      ZNH3FA(0,NY,NX)=ZNH3FA(0,NY,NX)*XCORP(NY,NX)
      ZNHUFA(0,NY,NX)=ZNHUFA(0,NY,NX)*XCORP(NY,NX)
      ZNO3FA(0,NY,NX)=ZNO3FA(0,NY,NX)*XCORP(NY,NX)
      VOLW(0,NY,NX)=VOLW(0,NY,NX)*XCORP(NY,NX)
      VOLI(0,NY,NX)=VOLI(0,NY,NX)*XCORP(NY,NX)
      VHCPR(NY,NX)=VHCPR(NY,NX)*XCORP(NY,NX)
      VOLT(0,NY,NX)=VOLT(0,NY,NX)*XCORP(NY,NX)
      LL=NU(NY,NX)
C
C     REDISTRIBUTE SOIL STATE VARIABLES DURING TILLAGE
C
      DCORPZ=AMIN1(DCORP(I,NY,NX),CDPTH(NL(NY,NX),NY,NX))
      DCORPX=DCORPZ+(CDPTH(NU(NY,NX),NY,NX)-DLYR(3,NU(NY,NX),NY,NX))
C
C     ACCUMULATE SOIL STATE VARIABLES WITHIN TILLAGE MIXING ZONE
C
      DO 1000 L=NU(NY,NX),NL(NY,NX)
      IF(CDPTH(L,NY,NX)-DLYR(3,L,NY,NX).LT.DCORPX)THEN
      TL=AMIN1(DLYR(3,L,NY,NX),DCORPX-(CDPTH(L,NY,NX)
     2-DLYR(3,L,NY,NX)))
      FI=TL/DCORPZ
      TI=TL/DLYR(3,L,NY,NX)
      TBKDS=TBKDS+FI*BKDS(L,NY,NX)
      TFC=TFC+FI*FC(L,NY,NX)
      TWP=TWP+FI*WP(L,NY,NX)
      TSCNV=TSCNV+FI*SCNV(L,NY,NX)
      TSCNH=TSCNH+FI*SCNH(L,NY,NX)
      TSAND=TSAND+TI*SAND(L,NY,NX)
      TSILT=TSILT+TI*SILT(L,NY,NX)
      TCLAY=TCLAY+TI*CLAY(L,NY,NX)
      TXCEC=TXCEC+TI*XCEC(L,NY,NX)
      TXAEC=TXAEC+TI*XAEC(L,NY,NX)
      TGKC4=TGKC4+FI*GKC4(L,NY,NX)
      TGKCA=TGKCA+FI*GKCA(L,NY,NX)
      TGKCM=TGKCM+FI*GKCM(L,NY,NX)
      TGKCN=TGKCN+FI*GKCN(L,NY,NX)
      TGKCK=TGKCK+FI*GKCK(L,NY,NX)
      TVOLW=TVOLW+TI*VOLW(L,NY,NX)
      TVOLI=TVOLI+TI*VOLI(L,NY,NX)
      TVOLP=TVOLP+TI*VOLP(L,NY,NX)
      TVOLA=TVOLA+TI*VOLA(L,NY,NX)
      TENGY=TENGY+TI*(4.19*(VOLW(L,NY,NX)+VOLWH(L,NY,NX))
     2+1.9274*(VOLI(L,NY,NX)+VOLIH(L,NY,NX)))*TKS(L,NY,NX)
      TNH4FA=TNH4FA+TI*ZNH4FA(L,NY,NX)
      TNH3FA=TNH3FA+TI*ZNH3FA(L,NY,NX)
      TNHUFA=TNHUFA+TI*ZNHUFA(L,NY,NX)
      TNO3FA=TNO3FA+TI*ZNO3FA(L,NY,NX)
      TNH4FB=TNH4FB+TI*ZNH4FB(L,NY,NX)
      TNH3FB=TNH3FB+TI*ZNH3FB(L,NY,NX)
      TNHUFB=TNHUFB+TI*ZNHUFB(L,NY,NX)
      TNO3FB=TNO3FB+TI*ZNO3FB(L,NY,NX)
      TNH4S=TNH4S+TI*ZNH4S(L,NY,NX)
      TNH4B=TNH4B+TI*ZNH4B(L,NY,NX)
      TNH3S=TNH3S+TI*ZNH3S(L,NY,NX)
      TNH3B=TNH3B+TI*ZNH3B(L,NY,NX)
      TNO3S=TNO3S+TI*ZNO3S(L,NY,NX)
      TNO3B=TNO3B+TI*ZNO3B(L,NY,NX)
      TNO2S=TNO2S+TI*ZNO2S(L,NY,NX)
      TNO2B=TNO2B+TI*ZNO2B(L,NY,NX)
      TZAL=TZAL+TI*ZAL(L,NY,NX)
      TZFE=TZFE+TI*ZFE(L,NY,NX)
      TZHY=TZHY+TI*ZHY(L,NY,NX)
      TZCA=TZCA+TI*ZCA(L,NY,NX)
      TZMG=TZMG+TI*ZMG(L,NY,NX)
      TZNA=TZNA+TI*ZNA(L,NY,NX)
      TZKA=TZKA+TI*ZKA(L,NY,NX)
      TZOH=TZOH+TI*ZOH(L,NY,NX)
      TZSO4=TZSO4+TI*ZSO4(L,NY,NX)
      TZCL=TZCL+TI*ZCL(L,NY,NX)
      TZCO3=TZCO3+TI*ZCO3(L,NY,NX)
      TZHCO3=TZHCO3+TI*ZHCO3(L,NY,NX)
      TZALO1=TZALO1+TI*ZALOH1(L,NY,NX)
      TZALO2=TZALO2+TI*ZALOH2(L,NY,NX)
      TZALO3=TZALO3+TI*ZALOH3(L,NY,NX)
      TZALO4=TZALO4+TI*ZALOH4(L,NY,NX)
      TZALS=TZALS+TI*ZALS(L,NY,NX)
      TZFEO1=TZFEO1+TI*ZFEOH1(L,NY,NX)
      TZFEO2=TZFEO2+TI*ZFEOH2(L,NY,NX)
      TZFEO3=TZFEO3+TI*ZFEOH3(L,NY,NX)
      TZFEO4=TZFEO4+TI*ZFEOH4(L,NY,NX)
      TZFES=TZFES+TI*ZFES(L,NY,NX)
      TZCAO=TZCAO+TI*ZCAO(L,NY,NX)
      TZCAC=TZCAC+TI*ZCAC(L,NY,NX)
      TZCAH=TZCAH+TI*ZCAH(L,NY,NX)
      TZCAS=TZCAS+TI*ZCAS(L,NY,NX)
      TZMGO=TZMGO+TI*ZMGO(L,NY,NX)
      TZMGC=TZMGC+TI*ZMGC(L,NY,NX)
      TZMGH=TZMGH+TI*ZMGH(L,NY,NX)
      TZMGS=TZMGS+TI*ZMGS(L,NY,NX)
      TZNAC=TZNAC+TI*ZNAC(L,NY,NX)
      TZNAS=TZNAS+TI*ZNAS(L,NY,NX)
      TZKAS=TZKAS+TI*ZKAS(L,NY,NX)
      TH0PO4=TH0PO4+TI*H0PO4(L,NY,NX)
      TH1PO4=TH1PO4+TI*H1PO4(L,NY,NX)
      TH2PO4=TH2PO4+TI*H2PO4(L,NY,NX)
      TH3PO4=TH3PO4+TI*H3PO4(L,NY,NX)
      TZFE1P=TZFE1P+TI*ZFE1P(L,NY,NX)
      TZFE2P=TZFE2P+TI*ZFE2P(L,NY,NX)
      TZCA0P=TZCA0P+TI*ZCA0P(L,NY,NX)
      TZCA1P=TZCA1P+TI*ZCA1P(L,NY,NX)
      TZCA2P=TZCA2P+TI*ZCA2P(L,NY,NX)
      TZMG1P=TZMG1P+TI*ZMG1P(L,NY,NX)
      TH0POB=TH0POB+TI*H0POB(L,NY,NX)
      TH1POB=TH1POB+TI*H1POB(L,NY,NX)
      TH2POB=TH2POB+TI*H2POB(L,NY,NX)
      TH3POB=TH3POB+TI*H3POB(L,NY,NX)
      TFE1PB=TFE1PB+TI*ZFE1PB(L,NY,NX)
      TFE2PB=TFE2PB+TI*ZFE2PB(L,NY,NX)
      TCA0PB=TCA0PB+TI*ZCA0PB(L,NY,NX)
      TCA1PB=TCA1PB+TI*ZCA1PB(L,NY,NX)
      TCA2PB=TCA2PB+TI*ZCA2PB(L,NY,NX)
      TMG1PB=TMG1PB+TI*ZMG1PB(L,NY,NX)
      TXNH4=TXNH4+TI*XN4(L,NY,NX)
      TXNHB=TXNHB+TI*XNB(L,NY,NX)
      TXHY=TXHY+TI*XHY(L,NY,NX)
      TXAL=TXAL+TI*XAL(L,NY,NX)
      TXCA=TXCA+TI*XCA(L,NY,NX)
      TXMG=TXMG+TI*XMG(L,NY,NX)
      TXNA=TXNA+TI*XNA(L,NY,NX)
      TXKA=TXKA+TI*XKA(L,NY,NX)
      TXHC=TXHC+TI*XHC(L,NY,NX)
      TXAL2=TXAL2+TI*XALO2(L,NY,NX)
      TXOH0=TXOH0+TI*XOH0(L,NY,NX)
      TXOH1=TXOH1+TI*XOH1(L,NY,NX)
      TXOH2=TXOH2+TI*XOH2(L,NY,NX)
      TXH1P=TXH1P+TI*XH1P(L,NY,NX)
      TXH2P=TXH2P+TI*XH2P(L,NY,NX)
      TXOH0B=TXOH0B+TI*XOH0B(L,NY,NX)
      TXOH1B=TXOH1B+TI*XOH1B(L,NY,NX)
      TXOH2B=TXOH2B+TI*XOH2B(L,NY,NX)
      TXH1PB=TXH1PB+TI*XH1PB(L,NY,NX)
      TXH2PB=TXH2PB+TI*XH2PB(L,NY,NX)
      TPALOH=TPALOH+TI*PALOH(L,NY,NX)
      TPFEOH=TPFEOH+TI*PFEOH(L,NY,NX)
      TPCACO=TPCACO+TI*PCACO(L,NY,NX)
      TPCASO=TPCASO+TI*PCASO(L,NY,NX)
      TPALPO=TPALPO+TI*PALPO(L,NY,NX)
      TPFEPO=TPFEPO+TI*PFEPO(L,NY,NX)
      TPCAPD=TPCAPD+TI*PCAPD(L,NY,NX)
      TPCAPH=TPCAPH+TI*PCAPH(L,NY,NX)
      TPCAPM=TPCAPM+TI*PCAPM(L,NY,NX)
      TPALPB=TPALPB+TI*PALPB(L,NY,NX)
      TPFEPB=TPFEPB+TI*PFEPB(L,NY,NX)
      TPCPDB=TPCPDB+TI*PCPDB(L,NY,NX)
      TPCPHB=TPCPHB+TI*PCPHB(L,NY,NX)
      TPCPMB=TPCPMB+TI*PCPMB(L,NY,NX)
      TCO2G=TCO2G+TI*CO2G(L,NY,NX)
      TCH4G=TCH4G+TI*CH4G(L,NY,NX)
      TCOZS=TCOZS+TI*CO2S(L,NY,NX)
      TCHFS=TCHFS+TI*CH4S(L,NY,NX)
      TOXYG=TOXYG+TI*OXYG(L,NY,NX)
      TOXYS=TOXYS+TI*OXYS(L,NY,NX)
      TZ2GG=TZ2GG+TI*Z2GG(L,NY,NX)
      TZ2GS=TZ2GS+TI*Z2GS(L,NY,NX)
      TZ2OG=TZ2OG+TI*Z2OG(L,NY,NX)
      TZ2OS=TZ2OS+TI*Z2OS(L,NY,NX)
      TZNH3G=TZNH3G+TI*ZNH3G(L,NY,NX)
      TH2GG=TH2GG+TI*H2GG(L,NY,NX)
      TH2GS=TH2GS+TI*H2GS(L,NY,NX)
      DO 4985 K=0,5
      DO 4985 N=1,7
      DO 4985 M=1,3
      TOMC(M,N,K)=TOMC(M,N,K)+TI*OMC(M,N,K,L,NY,NX)
      TOMN(M,N,K)=TOMN(M,N,K)+TI*OMN(M,N,K,L,NY,NX)
      TOMP(M,N,K)=TOMP(M,N,K)+TI*OMP(M,N,K,L,NY,NX)
4985  CONTINUE
      DO 4980 K=0,4
      DO 4975 M=1,2
      TORC(M,K)=TORC(M,K)+TI*ORC(M,K,L,NY,NX)
      TORN(M,K)=TORN(M,K)+TI*ORN(M,K,L,NY,NX)
      TORP(M,K)=TORP(M,K)+TI*ORP(M,K,L,NY,NX)
4975  CONTINUE
      TOQC(K)=TOQC(K)+TI*OQC(K,L,NY,NX)
      TOQN(K)=TOQN(K)+TI*OQN(K,L,NY,NX)
      TOQP(K)=TOQP(K)+TI*OQP(K,L,NY,NX)
      TOQA(K)=TOQA(K)+TI*OQA(K,L,NY,NX)
      TOHC(K)=TOHC(K)+TI*OHC(K,L,NY,NX)
      TOHN(K)=TOHN(K)+TI*OHN(K,L,NY,NX)
      TOHP(K)=TOHP(K)+TI*OHP(K,L,NY,NX)
      TOHA(K)=TOHA(K)+TI*OHA(K,L,NY,NX)
      DO 4970 M=1,4
      TOSC(M,K)=TOSC(M,K)+TI*OSC(M,K,L,NY,NX)
      TOSA(M,K)=TOSA(M,K)+TI*OSA(M,K,L,NY,NX)
      TOSN(M,K)=TOSN(M,K)+TI*OSN(M,K,L,NY,NX)
      TOSP(M,K)=TOSP(M,K)+TI*OSP(M,K,L,NY,NX)
4970  CONTINUE
4980  CONTINUE
      LL=L
      ENDIF
1000  CONTINUE
C
C     CHANGE SOIL STATE VARIABLES IN TILLAGE MIXING ZONE
C     TO ACCOUNT FOR REDISTRIBUTION FROM MIXING
C
      HEATSR=VHCPW(NY,NX)*TKW(NY,NX)+VHCPR(NY,NX)*TKS(0,NY,NX)
      DO 2000 L=NU(NY,NX),LL
      TL=AMIN1(DLYR(3,L,NY,NX),DCORPX-(CDPTH(L,NY,NX)
     2-DLYR(3,L,NY,NX)))
      FI=TL/DCORPZ
      TI=TL/DLYR(3,L,NY,NX)
      TX=1.0-TI
      BKDS(L,NY,NX)=TI*(BKDS(L,NY,NX)+CORP*(TBKDS-BKDS(L,NY,NX)))
     2+TX*BKDS(L,NY,NX)
      FC(L,NY,NX)=TI*(FC(L,NY,NX)+CORP*(TFC-FC(L,NY,NX)))
     2+TX*FC(L,NY,NX)
      WP(L,NY,NX)=TI*(WP(L,NY,NX)+CORP*(TWP-WP(L,NY,NX)))
     2+TX*WP(L,NY,NX)
      SCNV(L,NY,NX)=TI*(SCNV(L,NY,NX)+CORP*(TSCNV-SCNV(L,NY,NX)))
     2+TX*SCNV(L,NY,NX)
      SCNH(L,NY,NX)=TI*(SCNH(L,NY,NX)+CORP*(TSCNH-SCNH(L,NY,NX)))
     2+TX*SCNH(L,NY,NX)
      SAND(L,NY,NX)=TI*SAND(L,NY,NX)+CORP*(FI*TSAND-TI*SAND(L,NY,NX))
     2+TX*SAND(L,NY,NX)
      SILT(L,NY,NX)=TI*SILT(L,NY,NX)+CORP*(FI*TSILT-TI*SILT(L,NY,NX))
     2+TX*SILT(L,NY,NX)
      CLAY(L,NY,NX)=TI*CLAY(L,NY,NX)+CORP*(FI*TCLAY-TI*CLAY(L,NY,NX))
     2+TX*CLAY(L,NY,NX)
      XCEC(L,NY,NX)=TI*XCEC(L,NY,NX)+CORP*(FI*TXCEC-TI*XCEC(L,NY,NX))
     2+TX*XCEC(L,NY,NX)
      XAEC(L,NY,NX)=TI*XAEC(L,NY,NX)+CORP*(FI*TXAEC-TI*XAEC(L,NY,NX))
     2+TX*XAEC(L,NY,NX)
      GKC4(L,NY,NX)=TI*(GKC4(L,NY,NX)+CORP*(TGKC4-GKC4(L,NY,NX)))
     2+TX*GKC4(L,NY,NX)
      GKCA(L,NY,NX)=TI*(GKCA(L,NY,NX)+CORP*(TGKCA-GKCA(L,NY,NX)))
     2+TX*GKCA(L,NY,NX)
      GKCM(L,NY,NX)=TI*(GKCM(L,NY,NX)+CORP*(TGKCM-GKCM(L,NY,NX)))
     2+TX*GKCM(L,NY,NX)
      GKCN(L,NY,NX)=TI*(GKCN(L,NY,NX)+CORP*(TGKCN-GKCN(L,NY,NX)))
     2+TX*GKCN(L,NY,NX)
      GKCK(L,NY,NX)=TI*(GKCK(L,NY,NX)+CORP*(TGKCK-GKCK(L,NY,NX)))
     2+TX*GKCK(L,NY,NX)
      ENGYM=VHCM(L,NY,NX)*TKS(L,NY,NX)
      ENGYW=(4.19*(VOLW(L,NY,NX)+VOLWH(L,NY,NX))
     2+1.9274*(VOLI(L,NY,NX)+VOLIH(L,NY,NX)))*TKS(L,NY,NX)
      VOLW(L,NY,NX)=TI*VOLW(L,NY,NX)+CORP*(FI*TVOLW-TI*VOLW(L,NY,NX))
     2+TX*VOLW(L,NY,NX)+FI*TVOLWR 
      VOLI(L,NY,NX)=TI*VOLI(L,NY,NX)+CORP*(FI*TVOLI-TI*VOLI(L,NY,NX))
     2+TX*VOLI(L,NY,NX)+FI*TVOLIR
      VOLP(L,NY,NX)=TI*VOLP(L,NY,NX)+CORP*(FI*TVOLP-TI*VOLP(L,NY,NX))
     2+TX*VOLP(L,NY,NX)
      VOLA(L,NY,NX)=TI*VOLA(L,NY,NX)+CORP*(FI*TVOLA-TI*VOLA(L,NY,NX))
     2+TX*VOLA(L,NY,NX)
      VOLWX(L,NY,NX)=VOLW(L,NY,NX)
C     VOLW(L,NY,NX)=VOLW(L,NY,NX)+CORP*VOLWH(L,NY,NX)
C     VOLI(L,NY,NX)=VOLI(L,NY,NX)+CORP*VOLIH(L,NY,NX)
C     VOLA(L,NY,NX)=VOLA(L,NY,NX)+CORP*VOLAH(L,NY,NX)
C     VOLWH(L,NY,NX)=XCORP(NY,NX)*VOLWH(L,NY,NX)
C     VOLWH(L,NY,NX)=XCORP(NY,NX)*VOLWH(L,NY,NX)
C     VOLIH(L,NY,NX)=XCORP(NY,NX)*VOLIH(L,NY,NX)
C     FHOL(L,NY,NX)=XCORP(NY,NX)*FHOL(L,NY,NX)
      ENGYL=TI*ENGYW+CORP*(FI*TENGY-TI*ENGYW)+TX*ENGYW+FI*TENGYR
      VHCP(L,NY,NX)=VHCM(L,NY,NX)+4.19*(VOLW(L,NY,NX)+VOLWH(L,NY,NX))
     2+1.9274*(VOLI(L,NY,NX)+VOLIH(L,NY,NX)) 
      TKS(L,NY,NX)=(ENGYM+ENGYL)/VHCP(L,NY,NX)
      TCS(L,NY,NX)=TKS(L,NY,NX)-273.15
      ZNH4FA(L,NY,NX)=TI*ZNH4FA(L,NY,NX)+CORP*(FI*TNH4FA
     2-TI*ZNH4FA(L,NY,NX))+TX*ZNH4FA(L,NY,NX)
      ZNH3FA(L,NY,NX)=TI*ZNH3FA(L,NY,NX)+CORP*(FI*TNH3FA
     2-TI*ZNH3FA(L,NY,NX))+TX*ZNH3FA(L,NY,NX)
      ZNHUFA(L,NY,NX)=TI*ZNHUFA(L,NY,NX)+CORP*(FI*TNHUFA
     2-TI*ZNHUFA(L,NY,NX))+TX*ZNHUFA(L,NY,NX)
      ZNO3FA(L,NY,NX)=TI*ZNO3FA(L,NY,NX)+CORP*(FI*TNO3FA
     2-TI*ZNO3FA(L,NY,NX))+TX*ZNO3FA(L,NY,NX)
      ZNH4FB(L,NY,NX)=TI*ZNH4FB(L,NY,NX)+CORP*(FI*TNH4FB
     2-TI*ZNH4FB(L,NY,NX))+TX*ZNH4FB(L,NY,NX)
      ZNH3FB(L,NY,NX)=TI*ZNH3FB(L,NY,NX)+CORP*(FI*TNH3FB
     2-TI*ZNH3FB(L,NY,NX))+TX*ZNH3FB(L,NY,NX)
      ZNHUFB(L,NY,NX)=TI*ZNHUFB(L,NY,NX)+CORP*(FI*TNHUFB
     2-TI*ZNHUFB(L,NY,NX))+TX*ZNHUFB(L,NY,NX)
      ZNO3FB(L,NY,NX)=TI*ZNO3FB(L,NY,NX)+CORP*(FI*TNO3FB
     2-TI*ZNO3FB(L,NY,NX))+TX*ZNO3FB(L,NY,NX)
      ZNH4S(L,NY,NX)=TI*ZNH4S(L,NY,NX)+CORP*(FI*TNH4S-TI*ZNH4S(L,NY,NX))
     2+TX*ZNH4S(L,NY,NX)+CORP*ZNH4SH(L,NY,NX)
      ZNH4B(L,NY,NX)=TI*ZNH4B(L,NY,NX)+CORP*(FI*TNH4B-TI*ZNH4B(L,NY,NX))
     2+TX*ZNH4B(L,NY,NX)+CORP*ZNH4BH(L,NY,NX)
      ZNH3S(L,NY,NX)=TI*ZNH3S(L,NY,NX)+CORP*(FI*TNH3S-TI*ZNH3S(L,NY,NX))
     2+TX*ZNH3S(L,NY,NX)+CORP*ZNH3SH(L,NY,NX)
      ZNH3B(L,NY,NX)=TI*ZNH3B(L,NY,NX)+CORP*(FI*TNH3B-TI*ZNH3B(L,NY,NX))
     2+TX*ZNH3B(L,NY,NX)+CORP*ZNH3BH(L,NY,NX)
      ZNO3S(L,NY,NX)=TI*ZNO3S(L,NY,NX)+CORP*(FI*TNO3S-TI*ZNO3S(L,NY,NX))
     2+TX*ZNO3S(L,NY,NX)+CORP*ZNO3SH(L,NY,NX)
      ZNO3B(L,NY,NX)=TI*ZNO3B(L,NY,NX)+CORP*(FI*TNO3B-TI*ZNO3B(L,NY,NX))
     2+TX*ZNO3B(L,NY,NX)+CORP*ZNO3BH(L,NY,NX)
      ZNO2S(L,NY,NX)=TI*ZNO2S(L,NY,NX)+CORP*(FI*TNO2S-TI*ZNO2S(L,NY,NX))
     2+TX*ZNO2S(L,NY,NX)+CORP*ZNO2SH(L,NY,NX)
      ZNO2B(L,NY,NX)=TI*ZNO2B(L,NY,NX)+CORP*(FI*TNO2B-TI*ZNO2B(L,NY,NX))
     2+TX*ZNO2B(L,NY,NX)+CORP*ZNO2BH(L,NY,NX)
      ZAL(L,NY,NX)=TI*ZAL(L,NY,NX)+CORP*(FI*TZAL-TI*ZAL(L,NY,NX))
     2+TX*ZAL(L,NY,NX)+CORP*ZALH(L,NY,NX)
      ZFE(L,NY,NX)=TI*ZFE(L,NY,NX)+CORP*(FI*TZFE-TI*ZFE(L,NY,NX))
     2+TX*ZFE(L,NY,NX)+CORP*ZFEH(L,NY,NX)
      ZHY(L,NY,NX)=TI*ZHY(L,NY,NX)+CORP*(FI*TZHY-TI*ZHY(L,NY,NX))
     2+TX*ZHY(L,NY,NX)+CORP*ZHYH(L,NY,NX)
      ZCA(L,NY,NX)=TI*ZCA(L,NY,NX)+CORP*(FI*TZCA-TI*ZCA(L,NY,NX))
     2+TX*ZCA(L,NY,NX)+CORP*ZCCH(L,NY,NX)
      ZMG(L,NY,NX)=TI*ZMG(L,NY,NX)+CORP*(FI*TZMG-TI*ZMG(L,NY,NX))
     2+TX*ZMG(L,NY,NX)+CORP*ZMAH(L,NY,NX)
      ZNA(L,NY,NX)=TI*ZNA(L,NY,NX)+CORP*(FI*TZNA-TI*ZNA(L,NY,NX))
     2+TX*ZNA(L,NY,NX)+CORP*ZNAH(L,NY,NX)
      ZKA(L,NY,NX)=TI*ZKA(L,NY,NX)+CORP*(FI*TZKA-TI*ZKA(L,NY,NX))
     2+TX*ZKA(L,NY,NX)+CORP*ZKAH(L,NY,NX)
      ZOH(L,NY,NX)=TI*ZOH(L,NY,NX)+CORP*(FI*TZOH-TI*ZOH(L,NY,NX))
     2+TX*ZOH(L,NY,NX)+CORP*ZOHH(L,NY,NX)
      ZSO4(L,NY,NX)=TI*ZSO4(L,NY,NX)+CORP*(FI*TZSO4-TI*ZSO4(L,NY,NX))
     2+TX*ZSO4(L,NY,NX)+CORP*ZSO4H(L,NY,NX)
      ZCL(L,NY,NX)=TI*ZCL(L,NY,NX)+CORP*(FI*TZCL-TI*ZCL(L,NY,NX))
     2+TX*ZCL(L,NY,NX)+CORP*ZCLH(L,NY,NX)
      ZCO3(L,NY,NX)=TI*ZCO3(L,NY,NX)+CORP*(FI*TZCO3-TI*ZCO3(L,NY,NX))
     2+TX*ZCO3(L,NY,NX)+CORP*ZCO3H(L,NY,NX)
      ZHCO3(L,NY,NX)=TI*ZHCO3(L,NY,NX)+CORP*(FI*TZHCO3
     2-TI*ZHCO3(L,NY,NX))+TX*ZHCO3(L,NY,NX)+CORP*ZHCO3H(L,NY,NX)
      ZALOH1(L,NY,NX)=TI*ZALOH1(L,NY,NX)+CORP*(FI*TZALO1
     2-TI*ZALOH1(L,NY,NX))+TX*ZALOH1(L,NY,NX)+CORP*ZALO1H(L,NY,NX)
      ZALOH2(L,NY,NX)=TI*ZALOH2(L,NY,NX)+CORP*(FI*TZALO2
     2-TI*ZALOH2(L,NY,NX))+TX*ZALOH2(L,NY,NX)+CORP*ZALO2H(L,NY,NX)
      ZALOH3(L,NY,NX)=TI*ZALOH3(L,NY,NX)+CORP*(FI*TZALO3
     2-TI*ZALOH3(L,NY,NX))+TX*ZALOH3(L,NY,NX)+CORP*ZALO3H(L,NY,NX)
      ZALOH4(L,NY,NX)=TI*ZALOH4(L,NY,NX)+CORP*(FI*TZALO4
     2-TI*ZALOH4(L,NY,NX))+TX*ZALOH4(L,NY,NX)+CORP*ZALO4H(L,NY,NX)
      ZALS(L,NY,NX)=TI*ZALS(L,NY,NX)+CORP*(FI*TZALS-TI*ZALS(L,NY,NX))
     2+TX*ZALS(L,NY,NX)+CORP*ZALSH(L,NY,NX)
      ZFEOH1(L,NY,NX)=TI*ZFEOH1(L,NY,NX)+CORP*(FI*TZFEO1
     2-TI*ZFEOH1(L,NY,NX))+TX*ZFEOH1(L,NY,NX)+CORP*ZFEO1H(L,NY,NX)
      ZFEOH2(L,NY,NX)=TI*ZFEOH2(L,NY,NX)+CORP*(FI*TZFEO2
     2-TI*ZFEOH2(L,NY,NX))+TX*ZFEOH2(L,NY,NX)+CORP*ZFEO2H(L,NY,NX)
      ZFEOH3(L,NY,NX)=TI*ZFEOH3(L,NY,NX)+CORP*(FI*TZFEO3
     2-TI*ZFEOH3(L,NY,NX))+TX*ZFEOH3(L,NY,NX)+CORP*ZFEO3H(L,NY,NX)
      ZFEOH4(L,NY,NX)=TI*ZFEOH4(L,NY,NX)+CORP*(FI*TZFEO4
     2-TI*ZFEOH4(L,NY,NX))+TX*ZFEOH4(L,NY,NX)+CORP*ZFEO4H(L,NY,NX)
      ZFES(L,NY,NX)=TI*ZFES(L,NY,NX)+CORP*(FI*TZFES-TI*ZFES(L,NY,NX))
     2+TX*ZFES(L,NY,NX)+CORP*ZFESH(L,NY,NX)
      ZCAO(L,NY,NX)=TI*ZCAO(L,NY,NX)+CORP*(FI*TZCAO-TI*ZCAO(L,NY,NX))
     2+TX*ZCAO(L,NY,NX)+CORP*ZCAOH(L,NY,NX)
      ZCAC(L,NY,NX)=TI*ZCAC(L,NY,NX)+CORP*(FI*TZCAC-TI*ZCAC(L,NY,NX))
     2+TX*ZCAC(L,NY,NX)+CORP*ZCACH(L,NY,NX)
      ZCAH(L,NY,NX)=TI*ZCAH(L,NY,NX)+CORP*(FI*TZCAH-TI*ZCAH(L,NY,NX))
     2+TX*ZCAH(L,NY,NX)+CORP*ZCAHH(L,NY,NX)
      ZCAS(L,NY,NX)=TI*ZCAS(L,NY,NX)+CORP*(FI*TZCAS-TI*ZCAS(L,NY,NX))
     2+TX*ZCAS(L,NY,NX)+CORP*ZCASH(L,NY,NX)
      ZMGO(L,NY,NX)=TI*ZMGO(L,NY,NX)+CORP*(FI*TZMGO-TI*ZMGO(L,NY,NX))
     2+TX*ZMGO(L,NY,NX)+CORP*ZMGOH(L,NY,NX)
      ZMGC(L,NY,NX)=TI*ZMGC(L,NY,NX)+CORP*(FI*TZMGC-TI*ZMGC(L,NY,NX))
     2+TX*ZMGC(L,NY,NX)+CORP*ZMGCH(L,NY,NX)
      ZMGH(L,NY,NX)=TI*ZMGH(L,NY,NX)+CORP*(FI*TZMGH-TI*ZMGH(L,NY,NX))
     2+TX*ZMGH(L,NY,NX)+CORP*ZMGHH(L,NY,NX)
      ZMGS(L,NY,NX)=TI*ZMGS(L,NY,NX)+CORP*(FI*TZMGS-TI*ZMGS(L,NY,NX))
     2+TX*ZMGS(L,NY,NX)+CORP*ZMGSH(L,NY,NX)
      ZNAC(L,NY,NX)=TI*ZNAC(L,NY,NX)+CORP*(FI*TZNAC-TI*ZNAC(L,NY,NX))
     2+TX*ZNAC(L,NY,NX)+CORP*ZNACH(L,NY,NX)
      ZNAS(L,NY,NX)=TI*ZNAS(L,NY,NX)+CORP*(FI*TZNAS-TI*ZNAS(L,NY,NX))
     2+TX*ZNAS(L,NY,NX)+CORP*ZNASH(L,NY,NX)
      ZKAS(L,NY,NX)=TI*ZKAS(L,NY,NX)+CORP*(FI*TZKAS-TI*ZKAS(L,NY,NX))
     2+TX*ZKAS(L,NY,NX)+CORP*ZKASH(L,NY,NX)
      H0PO4(L,NY,NX)=TI*H0PO4(L,NY,NX)+CORP*(FI*TH0PO4
     2-TI*H0PO4(L,NY,NX))+TX*H0PO4(L,NY,NX)+CORP*H0PO4H(L,NY,NX)
      H1PO4(L,NY,NX)=TI*H1PO4(L,NY,NX)+CORP*(FI*TH1PO4
     2-TI*H1PO4(L,NY,NX))+TX*H1PO4(L,NY,NX)+CORP*H1PO4H(L,NY,NX)
      H2PO4(L,NY,NX)=TI*H2PO4(L,NY,NX)+CORP*(FI*TH2PO4
     2-TI*H2PO4(L,NY,NX))+TX*H2PO4(L,NY,NX)+CORP*H2PO4H(L,NY,NX)
      H3PO4(L,NY,NX)=TI*H3PO4(L,NY,NX)+CORP*(FI*TH3PO4
     2-TI*H3PO4(L,NY,NX))+TX*H3PO4(L,NY,NX)+CORP*H3PO4H(L,NY,NX)
      ZFE1P(L,NY,NX)=TI*ZFE1P(L,NY,NX)+CORP*(FI*TZFE1P
     2-TI*ZFE1P(L,NY,NX))+TX*ZFE1P(L,NY,NX)+CORP*ZFE1PH(L,NY,NX)
      ZFE2P(L,NY,NX)=TI*ZFE2P(L,NY,NX)+CORP*(FI*TZFE2P
     2-TI*ZFE2P(L,NY,NX))+TX*ZFE2P(L,NY,NX)+CORP*ZFE2PH(L,NY,NX)
      ZCA0P(L,NY,NX)=TI*ZCA0P(L,NY,NX)+CORP*(FI*TZCA0P
     2-TI*ZCA0P(L,NY,NX))+TX*ZCA0P(L,NY,NX)+CORP*ZCA0PH(L,NY,NX)
      ZCA1P(L,NY,NX)=TI*ZCA1P(L,NY,NX)+CORP*(FI*TZCA1P
     2-TI*ZCA1P(L,NY,NX))+TX*ZCA1P(L,NY,NX)+CORP*ZCA1PH(L,NY,NX)
      ZCA2P(L,NY,NX)=TI*ZCA2P(L,NY,NX)+CORP*(FI*TZCA2P
     2-TI*ZCA2P(L,NY,NX))+TX*ZCA2P(L,NY,NX)+CORP*ZCA2PH(L,NY,NX)
      ZMG1P(L,NY,NX)=TI*ZMG1P(L,NY,NX)+CORP*(FI*TZMG1P
     2-TI*ZMG1P(L,NY,NX))+TX*ZMG1P(L,NY,NX)+CORP*ZMG1PH(L,NY,NX)
      H0POB(L,NY,NX)=TI*H0POB(L,NY,NX)+CORP*(FI*TH0POB
     2-TI*H0POB(L,NY,NX))+TX*H0POB(L,NY,NX)+CORP*H0POBH(L,NY,NX)
      H1POB(L,NY,NX)=TI*H1POB(L,NY,NX)+CORP*(FI*TH1POB
     2-TI*H1POB(L,NY,NX))+TX*H1POB(L,NY,NX)+CORP*H1POBH(L,NY,NX)
      H2POB(L,NY,NX)=TI*H2POB(L,NY,NX)+CORP*(FI*TH2POB
     2-TI*H2POB(L,NY,NX))+TX*H2POB(L,NY,NX)+CORP*H2POBH(L,NY,NX)
      H3POB(L,NY,NX)=TI*H3POB(L,NY,NX)+CORP*(FI*TH3POB
     2-TI*H3POB(L,NY,NX))+TX*H3POB(L,NY,NX)+CORP*H3POBH(L,NY,NX)
      ZFE1PB(L,NY,NX)=TI*ZFE1PB(L,NY,NX)+CORP*(FI*TFE1PB
     2-TI*ZFE1PB(L,NY,NX))+TX*ZFE1PB(L,NY,NX)+CORP*ZFE1BH(L,NY,NX)
      ZFE2PB(L,NY,NX)=TI*ZFE2PB(L,NY,NX)+CORP*(FI*TFE2PB
     2-TI*ZFE2PB(L,NY,NX))+TX*ZFE2PB(L,NY,NX)+CORP*ZFE2BH(L,NY,NX)
      ZCA0PB(L,NY,NX)=TI*ZCA0PB(L,NY,NX)+CORP*(FI*TCA0PB
     2-TI*ZCA0PB(L,NY,NX))+TX*ZCA0PB(L,NY,NX)+CORP*ZCA0BH(L,NY,NX)
      ZCA1PB(L,NY,NX)=TI*ZCA1PB(L,NY,NX)+CORP*(FI*TCA1PB
     2-TI*ZCA1PB(L,NY,NX))+TX*ZCA1PB(L,NY,NX)+CORP*ZCA1BH(L,NY,NX)
      ZCA2PB(L,NY,NX)=TI*ZCA2PB(L,NY,NX)+CORP*(FI*TCA2PB
     2-TI*ZCA2PB(L,NY,NX))+TX*ZCA2PB(L,NY,NX)+CORP*ZCA2BH(L,NY,NX)
      ZMG1PB(L,NY,NX)=TI*ZMG1PB(L,NY,NX)+CORP*(FI*TMG1PB
     2-TI*ZMG1PB(L,NY,NX))+TX*ZMG1PB(L,NY,NX)+CORP*ZMG1BH(L,NY,NX)
      XN4(L,NY,NX)=TI*XN4(L,NY,NX)+CORP*(FI*TXNH4-TI*XN4(L,NY,NX))
     2+TX*XN4(L,NY,NX)
      XNB(L,NY,NX)=TI*XNB(L,NY,NX)+CORP*(FI*TXNHB-TI*XNB(L,NY,NX))
     2+TX*XNB(L,NY,NX)
      XHY(L,NY,NX)=TI*XHY(L,NY,NX)+CORP*(FI*TXHY-TI*XHY(L,NY,NX))
     2+TX*XHY(L,NY,NX)
      XAL(L,NY,NX)=TI*XAL(L,NY,NX)+CORP*(FI*TXAL-TI*XAL(L,NY,NX))
     2+TX*XAL(L,NY,NX)
      XCA(L,NY,NX)=TI*XCA(L,NY,NX)+CORP*(FI*TXCA-TI*XCA(L,NY,NX))
     2+TX*XCA(L,NY,NX)
      XMG(L,NY,NX)=TI*XMG(L,NY,NX)+CORP*(FI*TXMG-TI*XMG(L,NY,NX))
     2+TX*XMG(L,NY,NX)
      XNA(L,NY,NX)=TI*XNA(L,NY,NX)+CORP*(FI*TXNA-TI*XNA(L,NY,NX))
     2+TX*XNA(L,NY,NX)
      XKA(L,NY,NX)=TI*XKA(L,NY,NX)+CORP*(FI*TXKA-TI*XKA(L,NY,NX))
     2+TX*XKA(L,NY,NX)
      XHC(L,NY,NX)=TI*XHC(L,NY,NX)+CORP*(FI*TXHC-TI*XHC(L,NY,NX))
     2+TX*XHC(L,NY,NX)
      XALO2(L,NY,NX)=TI*XALO2(L,NY,NX)+CORP*(FI*TXAL2-TI*XALO2(L,NY,NX))
     2+TX*XALO2(L,NY,NX)
      XOH0(L,NY,NX)=TI*XOH0(L,NY,NX)+CORP*(FI*TXOH0-TI*XOH0(L,NY,NX))
     2+TX*XOH0(L,NY,NX)
      XOH1(L,NY,NX)=TI*XOH1(L,NY,NX)+CORP*(FI*TXOH1-TI*XOH1(L,NY,NX))
     2+TX*XOH1(L,NY,NX)
      XOH2(L,NY,NX)=TI*XOH2(L,NY,NX)+CORP*(FI*TXOH2-TI*XOH2(L,NY,NX))
     2+TX*XOH2(L,NY,NX)
      XH1P(L,NY,NX)=TI*XH1P(L,NY,NX)+CORP*(FI*TXH1P-TI*XH1P(L,NY,NX))
     2+TX*XH1P(L,NY,NX)
      XH2P(L,NY,NX)=TI*XH2P(L,NY,NX)+CORP*(FI*TXH2P-TI*XH2P(L,NY,NX))
     2+TX*XH2P(L,NY,NX)
      XOH0B(L,NY,NX)=TI*XOH0B(L,NY,NX)+CORP*(FI*TXOH0B
     2-TI*XOH0B(L,NY,NX))+TX*XOH0B(L,NY,NX)
      XOH1B(L,NY,NX)=TI*XOH1B(L,NY,NX)+CORP*(FI*TXOH1B
     2-TI*XOH1B(L,NY,NX))+TX*XOH1B(L,NY,NX)
      XOH2B(L,NY,NX)=TI*XOH2B(L,NY,NX)+CORP*(FI*TXOH2B
     2-TI*XOH2B(L,NY,NX))+TX*XOH2B(L,NY,NX)
      XH1PB(L,NY,NX)=TI*XH1PB(L,NY,NX)+CORP*(FI*TXH1PB
     2-TI*XH1PB(L,NY,NX))+TX*XH1PB(L,NY,NX)
      XH2PB(L,NY,NX)=TI*XH2PB(L,NY,NX)+CORP*(FI*TXH2PB
     2-TI*XH2PB(L,NY,NX))+TX*XH2PB(L,NY,NX)
      PALOH(L,NY,NX)=TI*PALOH(L,NY,NX)+CORP*(FI*TPALOH
     2-TI*PALOH(L,NY,NX))+TX*PALOH(L,NY,NX)
      PFEOH(L,NY,NX)=TI*PFEOH(L,NY,NX)+CORP*(FI*TPFEOH
     2-TI*PFEOH(L,NY,NX))+TX*PFEOH(L,NY,NX)
      PCACO(L,NY,NX)=TI*PCACO(L,NY,NX)+CORP*(FI*TPCACO
     2-TI*PCACO(L,NY,NX))+TX*PCACO(L,NY,NX)
      PCASO(L,NY,NX)=TI*PCASO(L,NY,NX)+CORP*(FI*TPCASO
     2-TI*PCASO(L,NY,NX))+TX*PCASO(L,NY,NX)
      PALPO(L,NY,NX)=TI*PALPO(L,NY,NX)+CORP*(FI*TPALPO
     2-TI*PALPO(L,NY,NX))+TX*PALPO(L,NY,NX)
      PFEPO(L,NY,NX)=TI*PFEPO(L,NY,NX)+CORP*(FI*TPFEPO
     2-TI*PFEPO(L,NY,NX))+TX*PFEPO(L,NY,NX)
      PCAPD(L,NY,NX)=TI*PCAPD(L,NY,NX)+CORP*(FI*TPCAPD
     2-TI*PCAPD(L,NY,NX))+TX*PCAPD(L,NY,NX)
      PCAPH(L,NY,NX)=TI*PCAPH(L,NY,NX)+CORP*(FI*TPCAPH
     2-TI*PCAPH(L,NY,NX))+TX*PCAPH(L,NY,NX)
      PCAPM(L,NY,NX)=TI*PCAPM(L,NY,NX)+CORP*(FI*TPCAPM
     2-TI*PCAPM(L,NY,NX))+TX*PCAPM(L,NY,NX)
      PALPB(L,NY,NX)=TI*PALPB(L,NY,NX)+CORP*(FI*TPALPB
     2-TI*PALPB(L,NY,NX))+TX*PALPB(L,NY,NX)
      PFEPB(L,NY,NX)=TI*PFEPB(L,NY,NX)+CORP*(FI*TPFEPB
     2-TI*PFEPB(L,NY,NX))+TX*PFEPB(L,NY,NX)
      PCPDB(L,NY,NX)=TI*PCPDB(L,NY,NX)+CORP*(FI*TPCPDB
     2-TI*PCPDB(L,NY,NX))+TX*PCPDB(L,NY,NX)
      PCPHB(L,NY,NX)=TI*PCPHB(L,NY,NX)+CORP*(FI*TPCPHB
     2-TI*PCPHB(L,NY,NX))+TX*PCPHB(L,NY,NX)
      PCPMB(L,NY,NX)=TI*PCPMB(L,NY,NX)+CORP*(FI*TPCPMB
     2-TI*PCPMB(L,NY,NX))+TX*PCPMB(L,NY,NX)
      CO2G(L,NY,NX)=TI*CO2G(L,NY,NX)+CORP*(FI*TCO2G-TI*CO2G(L,NY,NX))
     2+TX*CO2G(L,NY,NX)
      CH4G(L,NY,NX)=TI*CH4G(L,NY,NX)+CORP*(FI*TCH4G-TI*CH4G(L,NY,NX))
     2+TX*CH4G(L,NY,NX)
      CO2S(L,NY,NX)=TI*CO2S(L,NY,NX)+CORP*(FI*TCOZS-TI*CO2S(L,NY,NX))
     2+TX*CO2S(L,NY,NX)+CORP*CO2SH(L,NY,NX)
      CH4S(L,NY,NX)=TI*CH4S(L,NY,NX)+CORP*(FI*TCHFS-TI*CH4S(L,NY,NX))
     2+TX*CH4S(L,NY,NX)+CORP*CH4SH(L,NY,NX)
      OXYG(L,NY,NX)=TI*OXYG(L,NY,NX)+CORP*(FI*TOXYG-TI*OXYG(L,NY,NX))
     2+TX*OXYG(L,NY,NX)
      OXYS(L,NY,NX)=TI*OXYS(L,NY,NX)+CORP*(FI*TOXYS-TI*OXYS(L,NY,NX))
     2+TX*OXYS(L,NY,NX)+CORP*OXYSH(L,NY,NX)
      Z2GG(L,NY,NX)=TI*Z2GG(L,NY,NX)+CORP*(FI*TZ2GG-TI*Z2GG(L,NY,NX))
     2+TX*Z2GG(L,NY,NX)
      Z2GS(L,NY,NX)=TI*Z2GS(L,NY,NX)+CORP*(FI*TZ2GS-TI*Z2GS(L,NY,NX))
     2+TX*Z2GS(L,NY,NX)+CORP*Z2GSH(L,NY,NX)
      Z2OG(L,NY,NX)=TI*Z2OG(L,NY,NX)+CORP*(FI*TZ2OG-TI*Z2OG(L,NY,NX))
     2+TX*Z2OG(L,NY,NX)
      Z2OS(L,NY,NX)=TI*Z2OS(L,NY,NX)+CORP*(FI*TZ2OS-TI*Z2OS(L,NY,NX))
     2+TX*Z2OS(L,NY,NX)+CORP*Z2OSH(L,NY,NX)
      ZNH3G(L,NY,NX)=TI*ZNH3G(L,NY,NX)+CORP*(FI*TZNH3G
     2-TI*ZNH3G(L,NY,NX))+TX*ZNH3G(L,NY,NX)
      H2GG(L,NY,NX)=TI*H2GG(L,NY,NX)+CORP*(FI*TH2GG-TI*H2GG(L,NY,NX))
     2+TX*H2GG(L,NY,NX)
      H2GS(L,NY,NX)=TI*H2GS(L,NY,NX)+CORP*(FI*TH2GS-TI*H2GS(L,NY,NX))
     2+TX*H2GS(L,NY,NX)+CORP*H2GSH(L,NY,NX)
      ZNH4SH(L,NY,NX)=XCORP(NY,NX)*ZNH4SH(L,NY,NX)
      ZNH3SH(L,NY,NX)=XCORP(NY,NX)*ZNH3SH(L,NY,NX)
      ZNO3SH(L,NY,NX)=XCORP(NY,NX)*ZNO3SH(L,NY,NX)
      ZNO2SH(L,NY,NX)=XCORP(NY,NX)*ZNO2SH(L,NY,NX)
      H2PO4H(L,NY,NX)=XCORP(NY,NX)*H2PO4H(L,NY,NX)
      ZNH4BH(L,NY,NX)=XCORP(NY,NX)*ZNH4BH(L,NY,NX)
      ZNH3BH(L,NY,NX)=XCORP(NY,NX)*ZNH3BH(L,NY,NX)
      ZNO3BH(L,NY,NX)=XCORP(NY,NX)*ZNO3BH(L,NY,NX)
      ZNO2BH(L,NY,NX)=XCORP(NY,NX)*ZNO2BH(L,NY,NX)
      H2POBH(L,NY,NX)=XCORP(NY,NX)*H2POBH(L,NY,NX)
      ZALH(L,NY,NX)=XCORP(NY,NX)*ZALH(L,NY,NX)
      ZFEH(L,NY,NX)=XCORP(NY,NX)*ZFEH(L,NY,NX)
      ZHYH(L,NY,NX)=XCORP(NY,NX)*ZHYH(L,NY,NX)
      ZCCH(L,NY,NX)=XCORP(NY,NX)*ZCCH(L,NY,NX)
      ZMAH(L,NY,NX)=XCORP(NY,NX)*ZMAH(L,NY,NX)
      ZNAH(L,NY,NX)=XCORP(NY,NX)*ZNAH(L,NY,NX)
      ZKAH(L,NY,NX)=XCORP(NY,NX)*ZKAH(L,NY,NX)
      ZOHH(L,NY,NX)=XCORP(NY,NX)*ZOHH(L,NY,NX)
      ZSO4H(L,NY,NX)=XCORP(NY,NX)*ZSO4H(L,NY,NX)
      ZCLH(L,NY,NX)=XCORP(NY,NX)*ZCLH(L,NY,NX)
      ZCO3H(L,NY,NX)=XCORP(NY,NX)*ZCO3H(L,NY,NX)
      ZHCO3H(L,NY,NX)=XCORP(NY,NX)*ZHCO3H(L,NY,NX)
      ZALO1H(L,NY,NX)=XCORP(NY,NX)*ZALO1H(L,NY,NX)
      ZALO2H(L,NY,NX)=XCORP(NY,NX)*ZALO2H(L,NY,NX)
      ZALO3H(L,NY,NX)=XCORP(NY,NX)*ZALO3H(L,NY,NX)
      ZALO4H(L,NY,NX)=XCORP(NY,NX)*ZALO4H(L,NY,NX)
      ZALSH(L,NY,NX)=XCORP(NY,NX)*ZALSH(L,NY,NX)
      ZFEO1H(L,NY,NX)=XCORP(NY,NX)*ZFEO1H(L,NY,NX)
      ZFEO2H(L,NY,NX)=XCORP(NY,NX)*ZFEO2H(L,NY,NX)
      ZFEO3H(L,NY,NX)=XCORP(NY,NX)*ZFEO3H(L,NY,NX)
      ZFEO4H(L,NY,NX)=XCORP(NY,NX)*ZFEO4H(L,NY,NX)
      ZFESH(L,NY,NX)=XCORP(NY,NX)*ZFESH(L,NY,NX)
      ZCAOH(L,NY,NX)=XCORP(NY,NX)*ZCAOH(L,NY,NX)
      ZCACH(L,NY,NX)=XCORP(NY,NX)*ZCACH(L,NY,NX)
      ZCAHH(L,NY,NX)=XCORP(NY,NX)*ZCAHH(L,NY,NX)
      ZCASH(L,NY,NX)=XCORP(NY,NX)*ZCASH(L,NY,NX)
      ZMGOH(L,NY,NX)=XCORP(NY,NX)*ZMGOH(L,NY,NX)
      ZMGCH(L,NY,NX)=XCORP(NY,NX)*ZMGCH(L,NY,NX)
      ZMGHH(L,NY,NX)=XCORP(NY,NX)*ZMGHH(L,NY,NX)
      ZMGSH(L,NY,NX)=XCORP(NY,NX)*ZMGSH(L,NY,NX)
      ZNACH(L,NY,NX)=XCORP(NY,NX)*ZNACH(L,NY,NX)
      ZNASH(L,NY,NX)=XCORP(NY,NX)*ZNASH(L,NY,NX)
      ZKASH(L,NY,NX)=XCORP(NY,NX)*ZKASH(L,NY,NX)
      H0PO4H(L,NY,NX)=XCORP(NY,NX)*H0PO4H(L,NY,NX)
      H1PO4H(L,NY,NX)=XCORP(NY,NX)*H1PO4H(L,NY,NX)
      H3PO4H(L,NY,NX)=XCORP(NY,NX)*H3PO4H(L,NY,NX)
      ZFE1PH(L,NY,NX)=XCORP(NY,NX)*ZFE1PH(L,NY,NX)
      ZFE2PH(L,NY,NX)=XCORP(NY,NX)*ZFE2PH(L,NY,NX)
      ZCA0PH(L,NY,NX)=XCORP(NY,NX)*ZCA0PH(L,NY,NX)
      ZCA1PH(L,NY,NX)=XCORP(NY,NX)*ZCA1PH(L,NY,NX)
      ZCA2PH(L,NY,NX)=XCORP(NY,NX)*ZCA2PH(L,NY,NX)
      ZMG1PH(L,NY,NX)=XCORP(NY,NX)*ZMG1PH(L,NY,NX)
      H0POBH(L,NY,NX)=XCORP(NY,NX)*H0POBH(L,NY,NX)
      H1POBH(L,NY,NX)=XCORP(NY,NX)*H1POBH(L,NY,NX)
      H3POBH(L,NY,NX)=XCORP(NY,NX)*H3POBH(L,NY,NX)
      ZFE1BH(L,NY,NX)=XCORP(NY,NX)*ZFE1BH(L,NY,NX)
      ZFE2BH(L,NY,NX)=XCORP(NY,NX)*ZFE2BH(L,NY,NX)
      ZCA0BH(L,NY,NX)=XCORP(NY,NX)*ZCA0BH(L,NY,NX)
      ZCA1BH(L,NY,NX)=XCORP(NY,NX)*ZCA1BH(L,NY,NX)
      ZCA2BH(L,NY,NX)=XCORP(NY,NX)*ZCA2BH(L,NY,NX)
      ZMG1BH(L,NY,NX)=XCORP(NY,NX)*ZMG1BH(L,NY,NX)
      CO2SH(L,NY,NX)=XCORP(NY,NX)*CO2SH(L,NY,NX)
      CH4SH(L,NY,NX)=XCORP(NY,NX)*CH4SH(L,NY,NX)
      OXYSH(L,NY,NX)=XCORP(NY,NX)*OXYSH(L,NY,NX)
      Z2GSH(L,NY,NX)=XCORP(NY,NX)*Z2GSH(L,NY,NX)
      Z2OSH(L,NY,NX)=XCORP(NY,NX)*Z2OSH(L,NY,NX)
      DO 5965 K=0,5
      DO 5965 N=1,7
      DO 5965 M=1,3
      OMC(M,N,K,L,NY,NX)=TI*OMC(M,N,K,L,NY,NX)+CORP*(FI*TOMC(M,N,K)
     2-TI*OMC(M,N,K,L,NY,NX))+TX*OMC(M,N,K,L,NY,NX)
      OMN(M,N,K,L,NY,NX)=TI*OMN(M,N,K,L,NY,NX)+CORP*(FI*TOMN(M,N,K)
     2-TI*OMN(M,N,K,L,NY,NX))+TX*OMN(M,N,K,L,NY,NX)
      OMP(M,N,K,L,NY,NX)=TI*OMP(M,N,K,L,NY,NX)+CORP*(FI*TOMP(M,N,K)
     2-TI*OMP(M,N,K,L,NY,NX))+TX*OMP(M,N,K,L,NY,NX)
5965  CONTINUE
      DO 5980 K=0,4
      DO 5975 M=1,2
      ORC(M,K,L,NY,NX)=TI*ORC(M,K,L,NY,NX)+CORP*(FI*TORC(M,K)
     2-TI*ORC(M,K,L,NY,NX))+TX*ORC(M,K,L,NY,NX)
      ORN(M,K,L,NY,NX)=TI*ORN(M,K,L,NY,NX)+CORP*(FI*TORN(M,K)
     2-TI*ORN(M,K,L,NY,NX))+TX*ORN(M,K,L,NY,NX)
      ORP(M,K,L,NY,NX)=TI*ORP(M,K,L,NY,NX)+CORP*(FI*TORP(M,K)
     2-TI*ORP(M,K,L,NY,NX))+TX*ORP(M,K,L,NY,NX)
5975  CONTINUE
      OQC(K,L,NY,NX)=TI*OQC(K,L,NY,NX)+CORP*(FI*TOQC(K)
     2-TI*OQC(K,L,NY,NX))+TX*OQC(K,L,NY,NX)+CORP*OQCH(K,L,NY,NX)
      OQN(K,L,NY,NX)=TI*OQN(K,L,NY,NX)+CORP*(FI*TOQN(K)
     2-TI*OQN(K,L,NY,NX))+TX*OQN(K,L,NY,NX)+CORP*OQNH(K,L,NY,NX)
      OQP(K,L,NY,NX)=TI*OQP(K,L,NY,NX)+CORP*(FI*TOQP(K)
     2-TI*OQP(K,L,NY,NX))+TX*OQP(K,L,NY,NX)+CORP*OQPH(K,L,NY,NX)
      OQA(K,L,NY,NX)=TI*OQA(K,L,NY,NX)+CORP*(FI*TOQA(K)
     2-TI*OQA(K,L,NY,NX))+TX*OQA(K,L,NY,NX)+CORP*OQAH(K,L,NY,NX)
      OQCH(K,L,NY,NX)=XCORP(NY,NX)*OQCH(K,L,NY,NX)
      OQNH(K,L,NY,NX)=XCORP(NY,NX)*OQNH(K,L,NY,NX)
      OQPH(K,L,NY,NX)=XCORP(NY,NX)*OQPH(K,L,NY,NX)
      OQAH(K,L,NY,NX)=XCORP(NY,NX)*OQAH(K,L,NY,NX)
      OHC(K,L,NY,NX)=TI*OHC(K,L,NY,NX)+CORP*(FI*TOHC(K)
     2-TI*OHC(K,L,NY,NX))+TX*OHC(K,L,NY,NX)
      OHN(K,L,NY,NX)=TI*OHN(K,L,NY,NX)+CORP*(FI*TOHN(K)
     2-TI*OHN(K,L,NY,NX))+TX*OHN(K,L,NY,NX)
      OHP(K,L,NY,NX)=TI*OHP(K,L,NY,NX)+CORP*(FI*TOHP(K)
     2-TI*OHP(K,L,NY,NX))+TX*OHP(K,L,NY,NX)
      OHA(K,L,NY,NX)=TI*OHA(K,L,NY,NX)+CORP*(FI*TOHA(K)
     2-TI*OHA(K,L,NY,NX))+TX*OHA(K,L,NY,NX)
      DO 5970 M=1,4
      OSC(M,K,L,NY,NX)=TI*OSC(M,K,L,NY,NX)+CORP*(FI*TOSC(M,K)
     2-TI*OSC(M,K,L,NY,NX))+TX*OSC(M,K,L,NY,NX)
      OSA(M,K,L,NY,NX)=TI*OSA(M,K,L,NY,NX)+CORP*(FI*TOSA(M,K)
     2-TI*OSA(M,K,L,NY,NX))+TX*OSA(M,K,L,NY,NX)
      OSN(M,K,L,NY,NX)=TI*OSN(M,K,L,NY,NX)+CORP*(FI*TOSN(M,K)
     2-TI*OSN(M,K,L,NY,NX))+TX*OSN(M,K,L,NY,NX)
      OSP(M,K,L,NY,NX)=TI*OSP(M,K,L,NY,NX)+CORP*(FI*TOSP(M,K)
     2-TI*OSP(M,K,L,NY,NX))+TX*OSP(M,K,L,NY,NX)
5970  CONTINUE
5980  CONTINUE
C
C     ADD STATE VARIABLES IN SURFACE RESIDUE INCORPORATED
C     WITHIN TILLAGE MIXING ZONE
C
      DO 5910 K=0,5
      IF(K.NE.3.AND.K.NE.4)THEN
      DO 5915 N=1,7
      DO 5915 M=1,3
      OMC(M,N,K,L,NY,NX)=OMC(M,N,K,L,NY,NX)+FI*TOMGC(M,N,K)
      OMN(M,N,K,L,NY,NX)=OMN(M,N,K,L,NY,NX)+FI*TOMGN(M,N,K)
      OMP(M,N,K,L,NY,NX)=OMP(M,N,K,L,NY,NX)+FI*TOMGP(M,N,K)
5915  CONTINUE
      ENDIF
5910  CONTINUE
      DO 5920 K=0,2
      DO 5925 M=1,2
      ORC(M,K,L,NY,NX)=ORC(M,K,L,NY,NX)+FI*TORXC(M,K)
      ORN(M,K,L,NY,NX)=ORN(M,K,L,NY,NX)+FI*TORXN(M,K)
      ORP(M,K,L,NY,NX)=ORP(M,K,L,NY,NX)+FI*TORXP(M,K)
5925  CONTINUE
      OQC(K,L,NY,NX)=OQC(K,L,NY,NX)+FI*TOQGC(K)
      OQN(K,L,NY,NX)=OQN(K,L,NY,NX)+FI*TOQGN(K)
      OQP(K,L,NY,NX)=OQP(K,L,NY,NX)+FI*TOQGP(K)
      OQA(K,L,NY,NX)=OQA(K,L,NY,NX)+FI*TOQGA(K)
      OQCH(K,L,NY,NX)=OQCH(K,L,NY,NX)+FI*TOQHC(K)
      OQNH(K,L,NY,NX)=OQNH(K,L,NY,NX)+FI*TOQHN(K)
      OQPH(K,L,NY,NX)=OQPH(K,L,NY,NX)+FI*TOQHP(K)
      OQAH(K,L,NY,NX)=OQAH(K,L,NY,NX)+FI*TOQHA(K)
      OHC(K,L,NY,NX)=OHC(K,L,NY,NX)+FI*TOHGC(K)
      OHN(K,L,NY,NX)=OHN(K,L,NY,NX)+FI*TOHGN(K)
      OHP(K,L,NY,NX)=OHP(K,L,NY,NX)+FI*TOHGP(K)
      OHA(K,L,NY,NX)=OHA(K,L,NY,NX)+FI*TOHGA(K)
      DO 5930 M=1,4
      OSC(M,K,L,NY,NX)=OSC(M,K,L,NY,NX)+FI*TOSGC(M,K)
      OSA(M,K,L,NY,NX)=OSA(M,K,L,NY,NX)+FI*TOSGA(M,K)
      OSN(M,K,L,NY,NX)=OSN(M,K,L,NY,NX)+FI*TOSGN(M,K)
      OSP(M,K,L,NY,NX)=OSP(M,K,L,NY,NX)+FI*TOSGP(M,K)
5930  CONTINUE
5920  CONTINUE
      OC=0.0
      ON=0.0
      OP=0.0
      RC=0.0
      DO 5985 K=0,5
      DO 5985 N=1,7
      DO 5985 M=1,3
      OC=OC+OMC(M,N,K,L,NY,NX)
      ON=ON+OMN(M,N,K,L,NY,NX)
      OP=OP+OMP(M,N,K,L,NY,NX)
      IF(K.LE.2)THEN
      RC=RC+OMC(M,N,K,L,NY,NX)
      ENDIF
5985  CONTINUE
      DO 6995 K=0,4
      DO 6985 M=1,2
      OC=OC+ORC(M,K,L,NY,NX)
      ON=ON+ORN(M,K,L,NY,NX)
      OP=OP+ORP(M,K,L,NY,NX)
      IF(K.LE.2)THEN
      RC=RC+ORC(M,K,L,NY,NX)
      ENDIF
6985  CONTINUE
      OC=OC+OQC(K,L,NY,NX)+OQCH(K,L,NY,NX)+OHC(K,L,NY,NX)
     2+OQA(K,L,NY,NX)+OQAH(K,L,NY,NX)+OHA(K,L,NY,NX)
      ON=ON+OQN(K,L,NY,NX)+OQNH(K,L,NY,NX)+OHN(K,L,NY,NX)
      OP=OP+OQP(K,L,NY,NX)+OQPH(K,L,NY,NX)+OHP(K,L,NY,NX)
      IF(K.LE.2)THEN
      RC=RC+OQC(K,L,NY,NX)+OQCH(K,L,NY,NX)+OHC(K,L,NY,NX)
     2+OQA(K,L,NY,NX)+OQAH(K,L,NY,NX)+OHA(K,L,NY,NX)
      ENDIF
      DO 6980 M=1,4
      OC=OC+OSC(M,K,L,NY,NX)
      ON=ON+OSN(M,K,L,NY,NX)
      OP=OP+OSP(M,K,L,NY,NX)
      IF(K.LE.2)THEN
      RC=RC+OSC(M,K,L,NY,NX)
      ENDIF
6980  CONTINUE
6995  CONTINUE
      ORGC(L,NY,NX)=OC
      ORGN(L,NY,NX)=ON
      ORGR(L,NY,NX)=RC
      CO2S(L,NY,NX)=CO2S(L,NY,NX)+FI*TCO2GS
      CH4S(L,NY,NX)=CH4S(L,NY,NX)+FI*TCH4GS
      OXYS(L,NY,NX)=OXYS(L,NY,NX)+FI*TOXYGS
      Z2GS(L,NY,NX)=Z2GS(L,NY,NX)+FI*TZ2GSG
      Z2OS(L,NY,NX)=Z2OS(L,NY,NX)+FI*TZ2OGS
      H2GS(L,NY,NX)=H2GS(L,NY,NX)+FI*TH2GGS
      ZNH4S(L,NY,NX)=ZNH4S(L,NY,NX)+FI*TNH4GS
      ZNH3S(L,NY,NX)=ZNH3S(L,NY,NX)+FI*TNH3GS
      ZNO3S(L,NY,NX)=ZNO3S(L,NY,NX)+FI*TNO3GS
      ZNO2S(L,NY,NX)=ZNO2S(L,NY,NX)+FI*TNO2GS
      H2PO4(L,NY,NX)=H2PO4(L,NY,NX)+FI*TPO4GS
      XN4(L,NY,NX)=XN4(L,NY,NX)+FI*TXN4G
      XOH0(L,NY,NX)=XOH0(L,NY,NX)+FI*TXOH0G
      XOH1(L,NY,NX)=XOH1(L,NY,NX)+FI*TXOH1G
      XOH2(L,NY,NX)=XOH2(L,NY,NX)+FI*TXOH2G
      XH1P(L,NY,NX)=XH1P(L,NY,NX)+FI*TXH1PG
      XH2P(L,NY,NX)=XH2P(L,NY,NX)+FI*TXH2PG
      PALPO(L,NY,NX)=PALPO(L,NY,NX)+FI*TALPOG
      PFEPO(L,NY,NX)=PFEPO(L,NY,NX)+FI*TFEPOG
      PCAPD(L,NY,NX)=PCAPD(L,NY,NX)+FI*TCAPDG
      PCAPH(L,NY,NX)=PCAPH(L,NY,NX)+FI*TCAPHG
      PCAPM(L,NY,NX)=PCAPM(L,NY,NX)+FI*TCAPMG
      ZNH4FA(L,NY,NX)=ZNH4FA(L,NY,NX)+FI*TNH4FG
      ZNH3FA(L,NY,NX)=ZNH3FA(L,NY,NX)+FI*TNH3FG
      ZNHUFA(L,NY,NX)=ZNHUFA(L,NY,NX)+FI*TNHUFG
      ZNO3FA(L,NY,NX)=ZNO3FA(L,NY,NX)+FI*TNO3FG
2000  CONTINUE
      IFLGS(NY,NX)=1
      ENDIF
C
C     CHECK MATERIAL BALANCES
C
C     IF(I.EQ.365.AND.J.EQ.24)THEN
C     WRITE(19,2221)'ORGC',I,J,NX,NY,(ORGC(L,NY,NX),L=0,NL(NY,NX))
C     WRITE(20,2221)'ORGN',I,J,NX,NY,(ORGN(L,NY,NX),L=0,NL(NY,NX))
2221  FORMAT(A8,5I4,20E12.4)
C
C     ZM added microbial C and N 
C      WRITE(LUN,'(A16,F8.3,4X,A8,50E16.7E3)')OUTFILS(N-20,NY,NX)
C      WRITE(LUN,'(A16,F8.3,4X,A8,50E16.7E3)')OUTFILS(N-20,NY,NX)
C
C3221  FORMAT(A9,2F8.3,A8,50E16.7E3)
3221  FORMAT(A9,F8.3,X,I4,20E12.4)
C 3222  FORMAT(5A9,/,4I4,20E12.4)
3222  FORMAT(A9,2I4,20E12.4)
C  total microbial carbon for microbial groups(1-7) for layer 0-11
C       
       OMCN1L(NY,NX)=OMCN1(0,NY,NX)+OMCN1(1,NY,NX)
     2+OMCN1(2,NY,NX)+OMCN1(3,NY,NX)+OMCN1(4,NY,NX)
     3+OMCN1(5,NY,NX)+OMCN1(6,NY,NX)+OMCN1(7,NY,NX)
     4+OMCN1(8,NY,NX)+OMCN1(9,NY,NX)
     5+OMCN1(10,NY,NX)+OMCN1(11,NY,NX)
      OMCN2L(NY,NX)=OMCN2(0,NY,NX)+OMCN2(1,NY,NX)
     2+OMCN2(2,NY,NX)+OMCN2(3,NY,NX)+OMCN2(4,NY,NX)
     3+OMCN2(5,NY,NX)+OMCN2(6,NY,NX)+OMCN2(7,NY,NX)
     4+OMCN2(8,NY,NX)+OMCN2(9,NY,NX)
     5+OMCN2(10,NY,NX)+OMCN2(11,NY,NX)
      OMCN3L(NY,NX)=OMCN3(0,NY,NX)+OMCN3(1,NY,NX)
     2+OMCN3(2,NY,NX)+OMCN3(3,NY,NX)+OMCN3(4,NY,NX)
     3+OMCN3(5,NY,NX)+OMCN3(6,NY,NX)+OMCN3(7,NY,NX)
     4+OMCN3(8,NY,NX)+OMCN3(9,NY,NX)
     5+OMCN3(10,NY,NX)+OMCN3(11,NY,NX)
      OMCN4L(NY,NX)=OMCN4(0,NY,NX)+OMCN4(1,NY,NX)
     2+OMCN4(2,NY,NX)+OMCN4(3,NY,NX)+OMCN4(4,NY,NX)
     3+OMCN4(5,NY,NX)+OMCN4(6,NY,NX)+OMCN4(7,NY,NX)
     4+OMCN4(8,NY,NX)+OMCN4(9,NY,NX)
     5+OMCN4(10,NY,NX)+OMCN4(11,NY,NX)
      OMCN5L(NY,NX)=OMCN5(0,NY,NX)+OMCN5(1,NY,NX)
     2+OMCN5(2,NY,NX)+OMCN5(3,NY,NX)+OMCN5(4,NY,NX)
     3+OMCN5(5,NY,NX)+OMCN5(6,NY,NX)+OMCN5(7,NY,NX)
     4+OMCN5(8,NY,NX)+OMCN5(9,NY,NX)
     5+OMCN5(10,NY,NX)+OMCN5(11,NY,NX)
      OMCN6L(NY,NX)=OMCN6(0,NY,NX)+OMCN6(1,NY,NX)
     2+OMCN6(2,NY,NX)+OMCN6(3,NY,NX)+OMCN6(4,NY,NX)
     3+OMCN6(5,NY,NX)+OMCN6(6,NY,NX)+OMCN6(7,NY,NX)
     4+OMCN6(8,NY,NX)+OMCN6(9,NY,NX)
     5+OMCN6(10,NY,NX)+OMCN6(11,NY,NX)
      OMCN7L(NY,NX)=OMCN7(0,NY,NX)+OMCN7(1,NY,NX)
     2+OMCN7(2,NY,NX)+OMCN7(3,NY,NX)+OMCN7(4,NY,NX)
     3+OMCN7(5,NY,NX)+OMCN7(6,NY,NX)+OMCN7(7,NY,NX)
     4+OMCN7(8,NY,NX)+OMCN7(9,NY,NX)
     5+OMCN7(10,NY,NX)+OMCN7(11,NY,NX)
C  SUM ALL THE 7 groups across layers
      OMCNSUM(NY,NX)=OMCN1L(NY,NX)+OMCN2L(NY,NX)
     2+OMCN3L(NY,NX)+OMCN4L(NY,NX)+OMCN5L(NY,NX)
     3+OMCN6L(NY,NX)+OMCN7L(NY,NX)
C  outputs every 10 days and 10 years
      XXD=DOY/10
      XXD1=INT(XXD)
      XXD2=XXD1*10
      XXY=IYRC/10
      XXY1=INT(XXY)
      XXY2=XXY1*10
C      IF(J.EQ.24.AND.XXD2.EQ.DOY.AND.XXY2.EQ.IYRC)THEN
C      WRITE(57,3222)'OMNL',I,J,IYRC,NX,NY,(OMCL(L,NY,NX),L=0,NL(NY,NX))  
C      WRITE(54,3221)'CMICROBE1',DOY,IYRC,(OMCN1(L,NY,NX),L=0,NL(NY,NX))
C      WRITE(56,3221)'CMICROBE2',DOY,IYRC,OMCN1L(NY,NX)
C
C      WRITE(58,3222)'MICROALL','DOY','DATE','IYRC',
C     2'OMCNSUM',DOY,DOY,DATE,IYRC,OMCNSUM(NY,NX)
C      WRITE(58,3222)'MICROALL',DOY,DATE,IYRC,OMCNSUM(NY,NX)
C      WRITE(62,5229)'NMICROBE1',I,J,IYRC,OMCN1(NY,NX),OMCN2(NY,NX),OMCN3(NY,NX)
C     2,OMCN4(NY,NX),OMCN5(NY,NX),OMCN6(NY,NX),OMCN7(NY,NX)
C      WRITE(72,4221)'NMICROBE1',I,J,IYRC,OMNN1(NY,NX)
C     2,OMNN2(NY,NX),OMNN3(NY,NX),OMNN4(NY,NX)
C     3,OMNN5(NY,NX),OMNN6(NY,NX),OMNN7(NY,NX)
C       DOY,CDATE
C      OMCN1L(NY,NX)=0
C      OMCN1L(NY,NX)=OMCN1L(NY,NX)+OMCN1(L=0,NY,NX)
C      OMCN1L(NY,NX)=OMCN1L(NY,NX)+OMCN1((L=1,11),NY,NX)
C

C       WRITE(59,3222)'MIALL',I,J,IYRC,NX,NY,OMCNLL(L,NY,NX)  
C       WRITE(59,3221)'MICROALO',DOY,IYRC,(OMCNLL(L,NY,NX),L=0,NL(NY,NX))
C     2,OMCN2(NY,NX),OMCN3(NY,NX)
C      WRITE(56,3222)'CMICROBE2',I,J,IYRC,OMCN2(NY,NX)
C      WRITE(57,3223)'CMICROBE3',I,J,IYRC,OMCN3(NY,NX)
C     WRITE(58,3224)'CMICROBE4',I,J,IYRC,OMCN4(NY,NX)
C      WRITE(59,3225)'CMICROBE5',I,J,IYRC,OMCN5(NY,NX)
C      WRITE(60,3226)'CMICROBE6',I,J,IYRC,OMCN6(NY,NX)
C      WRITE(61,3227)'CMICROBE7',I,J,IYRC,OMCN7(NY,NX)
C       WRITE(62,3228)'CMICROBEt',I,J,IYRC,(OMCL(L,NY,NX),L=0,NL(NY,NX))
C            
C      WRITE(65,4221)'NMICROBE1',I,J,IYRC,OMNN1(L,NY,NX)
C      WRITE(66,4222)'NMICROBE2',I,J,IYRC,OMNN2(L,NY,NX)
C      WRITE(67,4223)'NMICROBE3',I,J,IYRC,OMNN3(L,NY,NX)
C      WRITE(68,4224)'NMICROBE4',I,J,IYRC,OMNN4(L,NY,NX)
C      WRITE(69,4225)'NMICROBE5',I,J,IYRC,OMNN5(L,NY,NX)
C      WRITE(70,4226)'NMICROBE6',I,J,IYRC,OMNN6(L,NY,NX)
C      WRITE(71,4227)'NMICROBE7',I,J,IYRC,OMNN7(L,NY,NX)      
C       WRITE(72,4228)'NMICROBEt',I,J,IYRC,(OMNL(L,NY,NX),L=0,NL(NY,NX))
C
C       WRITE(75,5221)'ACMICRO1',I,J,IYRC,(OMCNA1(L,NY,NX),L=0,NL(NY,NX))
C       WRITE(76,5222)'ACMICRO2',I,J,IYRC,(OMCNA2(L,NY,NX),L=0,NL(NY,NX))
C       WRITE(77,5223)'ACMICRO3',I,J,IYRC,(OMCNA3(L,NY,NX),L=0,NL(NY,NX))
C       WRITE(78,5224)'ACMICRO5',I,J,IYRC,(OMCNA5(L,NY,NX),L=0,NL(NY,NX))
C       WRITE(79,5225)'ANMICRO1',I,J,IYRC,(OMNNA1(L,NY,NX),L=0,NL(NY,NX))
C       WRITE(80,5226)'ANMICRO2',I,J,IYRC,(OMNNA2(L,NY,NX),L=0,NL(NY,NX))
C       WRITE(81,5227)'ANMICRO3',I,J,IYRC,(OMNNA3(L,NY,NX),L=0,NL(NY,NX))
C       WRITE(82,5228)'ANMICRO5',I,J,IYRC,(OMNNA5(L,NY,NX),L=0,NL(NY,NX))
Cc       WRITE(72,4221)'NMICROBEt',I,J,IYRC,(OMNL(L,NY,NX),L=0,NL(NY,NX))
C
C      ENDIF
C
C     ENDIF
C     IF(I.EQ.365.AND.J.EQ.24)THEN
C     WRITE(20,2221)'OMCL',I,J,IYRC,NX,NY,(OMCL(L,NY,NX),L=0,NL(NY,NX))
C     WRITE(20,2221)'OMNL',I,J,IYRC,NX,NY,(OMNL(L,NY,NX),L=0,NL(NY,NX))
C     WRITE(20,2222)'TLC',I,J,IYRC,NX,NY,TLRSDC+TLORGC+TLCO2G-CO2GIN
C    2+TCOU-TORGF-XCSN,TLRSDC,TLORGC,TLCO2G,CO2GIN,TCOU,TORGF,XCSN
C    5,XCODFS(NY,NX),XCOFLG(3,NU(NY,NX),NY,NX),TCO2Z(NY,NX)
C    2,FLQGQ(NY,NX)*CCOR(NY,NX),FLQGI(NY,NX)*CCOQ(NY,NX),XCODFG(0,NY,NX)
C    3,XCODFR(NY,NX),XCHDFS(NY,NX),XCHFLG(3,NU(NY,NX),NY,NX) 
C    2,FLQGQ(NY,NX)*CCHR(NY,NX),FLQGI(NY,NX)*CCHQ(NY,NX),XCHDFG(0,NY,NX)
C    3,XCHDFR(NY,NX),PRECU(NY,NX)*CCOQ(NY,NX),PRECU(NY,NX)*CCHQ(NY,NX)
C    6,TCOQRS(NY,NX),TCHQRS(NY,NX),XCOFLS(1,0,NY,NX+1)
C    7,XCOFLS(2,0,NY+1,NX)
C    3,UCOP(NY,NX),UDOCQ(NY,NX),UDICQ(NY,NX),UDOCD(NY,NX),UDICD(NY,NX)
C    2,(((CSNT(M,K,L,NY,NX),M=1,4),K=0,1),L=0,NJ(NY,NX))
C    3,(TCO2P(L,NY,NX),L=1,NJ(NY,NX)),(TCO2S(L,NY,NX),L=1,NJ(NY,NX))
C    4,CQ,ZCSNC(NY,NX)
C     WRITE(20,2222)'TLW',I,J,IYRC,NX,NY,VOLWSO-CRAIN+CRUN+CEVAP+VOLWOU
C    2,VOLWSO,CRAIN,CRUN,CEVAP,VOLWOU,(TUPWTR(L,NY,NX),L=1,JZ)
C    3,TVOLWC(NY,NX),TVOLWP(NY,NX),VOLW(0,NY,NX),VOLI(0,NY,NX)*0.92
C    4,TFLWC(NY,NX),TEVAPC(NY,NX),TEVAPG(NY,NX),TEVAPP(NY,NX)
C    5,VOLSS(NY,NX),VOLWS(NY,NX),VOLIS(NY,NX)*0.92,TQS(NY,NX)
C    6,TQW(NY,NX),TQI(NY,NX),TFLWS(NY,NX),TFLWW(NY,NX),TFLWI(NY,NX)
C    7,TVOLWC(NY,NX),TVOLWP(NY,NX)
C     WRITE(19,2222)'TLH',I,J,IYRC,NX,NY,HEATSO-HEATIN+HEATOU
C    2,HEATSO,HEATIN,HEATOU,HTHAWR(NY,NX),HFLXD,4.19*TKA(NY,NX)*PRECA(NY,NX)
C    3+2.095*TKA(NY,NX)*PRECW(NY,NX),HEATH(NY,NX),HTHAWW(NY,NX) 
C    4,THFLXC(NY,NX),(THTHAW(L,NY,NX),L=NU(NY,NX),NL(NY,NX))
C    5,(VHCP(L,NY,NX)*TKS(L,NY,NX),L=NU(NY,NX),NL(NY,NX))
C    5,4.19*TKA(NY,NX)*PRECU(NY,NX),TENGYC(NY,NX),ENGYR
C    6,VHCPW(NY,NX)*TKW(NY,NX),VHCPR(NY,NX)*TKS(0,NY,NX)
C     WRITE(19,2222)'TLO',I,J,IYRC,NX,NY,OXYGSO-OXYGIN+OXYGOU,OXYGSO
C    2,OXYGIN,OXYGOU,XOXDFS(NY,NX),XOXFLG(3,NU(NY,NX),NY,NX)
C    3,XOXDFG(0,NY,NX),TOXYZ(NY,NX),FLQGQ(NY,NX)*COXR(NY,NX),FLQGI(NY,NX)*COXQ
C    2,PRECU(NY,NX)*COXQ,(RUPOXO(L,NY,NX),L=1,NJ(NY,NX))
C    3,(TUPOXP(L,NY,NX),L=1,NJ(NY,NX)),(TOXFLA(L,NY,NX),L=1,NJ(NY,NX))
C     WRITE(20,2222)'TLN',I,J,IYRC,NX,NY,TLRSDN+TLORGN+TLN2G+TLNH4
C    2+TLNO3-ZN2GIN-TZIN+TZOU-TORGN-XZSN,TLRSDN,TLORGN,TLN2G,TLNH4
C    3,TLNO3,ZN2GIN,TZIN,TZOU,TORGN,XZSN,PRECQ(NY,NX),PRECR(NY,NX)
C    4,PRECW(NY,NX),PRECI(NY,NX),FLQGM(NY,NX),FLQRM(NY,NX)
C    4,(((ZSNT(M,K,L,NY,NX),M=1,4),K=0,1),L=0,JZ)
C    5,(TUPNH4(L,NY,NX),L=1,JZ)
C    6,(TUPNO3(L,NY,NX),L=1,JZ),(TNHFLA(L,NY,NX),L=1,JZ)
C    7,XN3DFS(NY,NX),XNBDFS(NY,NX)
C    8,XN3FLG(3,NU(NY,NX),NY,NX),TNH3Z(NY,NX),UN2GS(NY,NX)
C    9,(XN2GS(L,NY,NX),L=0,JZ)
C     WRITE(*,2222)'TLI',I,J,IYRC,NX,NY,TION-TIONIN+TIONOU
C    2-TFERTN-TFERTP,TION,TIONIN,TIONOU,SG,TFERTN,TFERTP
C    3,PRECQ(NY,NX),XHGDFS(NY,NX),XHGFLG(3,NU(NY,NX),NY,NX),TH2GZ(NY,NX)
C    4,(XHGQRS(N,NY,NX),N=1,2),(RH2GO(L,NY,NX),L=1,JZ)
C    5,(THGFLA(L,NY,NX),L=1,JZ),H2GW(NY,NX),(H2GS(L,NY,NX),L=1,JZ)
C    6,(H2GG(L,NY,NX),L=1,JZ),(TLH2GP(L,NY,NX),L=1,JZ)
C     WRITE(*,2223)'TLS',I,J,IYRC,NX,NY,NU(NY,NX),TSEDSO+TSEDOU
C    2,TSEDSO,TSEDOU,USEDOU(NY,NX),DLYR(3,NU(NY,NX),NY,NX)
C    3,BKVL(NU(NY,NX),NY,NX),SAND(NU(NY,NX),NY,NX),SILT(NU(NY,NX),NY,NX)
C    4,CLAY(NU(NY,NX),NY,NX),ORGC(NU(NY,NX),NY,NX)
2222  FORMAT(A8,5I6,240F20.6)
2223  FORMAT(A8,6I6,160F16.6)
C     ENDIF
9990  CONTINUE
9995  CONTINUE
      RETURN
      END

