      SUBROUTINE nitro(I,J,NHW,NHE,NVN,NVS)
C
C     THIS SUBROUTINE CALCULATES ALL SOIL BIOLOGICAL TRANSFORMATIONS
C
      include "parameters.h"
      include "blkc.h"
      include "blk2a.h"
      include "blk2b.h"
      include "blk2c.h"
      include "blk8a.h"
      include "blk8b.h"
      include "blk10.h"
      include "blk11a.h"
      include "blk11b.h"
      include "blk13a.h"
      include "blk13b.h"
      include "blk13c.h"
      include "blk13d.h"
      include "blk15a.h"
      include "blk15b.h"
      include "blk18a.h"
      include "blk18b.h"
      DIMENSION CNOMA(7,0:5),CPOMA(7,0:5),OMA(7,0:5),FOMA(7,0:5)
     2,FOMN(7,0:5),RDOSC(4,0:4),RDOSN(4,0:4),RDOSP(4,0:4),RHOSC(4,0:4)
     3,RHOSN(4,0:4),RHOSP(4,0:4),RCOSC(4,0:4),RCOSN(4,0:4),RCOSP(4,0:4)
     4,SPOSC(4,0:4),RDORC(2,0:4),RDORN(2,0:4),RDORP(2,0:4),SPORC(2)
     5,RDOHC(0:4),RDOHN(0:4),RDOHP(0:4),RDOHA(0:4),CSORP(0:4),ZSORP(0:4)
     6,PSORP(0:4),CSORPA(0:4),OSRH(0:4),FOSRH(0:4),RUPOX(7,0:5)
     8,RGOMO(7,0:5),ROXYM(7,0:5),ROXYP(7,0:5),ROXYO(7,0:5),RDNO3(7,0:5)
     9,RDNOB(7,0:5),RDNO2(7,0:5),RDN2B(7,0:5),RDN2O(7,0:5),RGOMD(7,0:5)
     1,RMOMC(2,7,0:5),RINH4(7,0:5),RINO3(7,0:5),RIPO4(7,0:5)
     2,RINB4(7,0:5),RINB3(7,0:5),RIPB4(7,0:5),FOMK(7,0:5)
     3,RDOMC(2,7,0:5),RDOMN(2,7,0:5),RDOMP(2,7,0:5),RHOMC(2,7,0:5)
     4,RHOMN(2,7,0:5),RHOMP(2,7,0:5),RCOMC(2,7,0:5),RCOMN(2,7,0:5)
     5,RCOMP(2,7,0:5),CGOMC(7,0:5),CGOMN(7,0:5),RH2GX(7,0:5)
     6,CGOMP(7,0:5),RDMMC(2,7,0:5),RHMMC(2,7,0:5),RCMMC(2,7,0:5)
     7,RDMMN(2,7,0:5),RHMMN(2,7,0:5),RCMMN(2,7,0:5),RDMMP(2,7,0:5)
     8,RHMMP(2,7,0:5),RCMMP(2,7,0:5),RCCMC(2,7,0:4)
     9,RCCMN(2,7,0:4),RCCMP(2,7,0:4),RN2FX(7,0:5),TOMK(0:5),ZOMA(0:4)
     1,ZONA(0:4),ZOPA(0:4),SPOMC(2),OMCF(7),OMC2(7,0:5),WFN(7,0:5) 
     2,OMN2(7,0:5),FOM2(7,0:5),FOCA(0:4),FOAA(0:4),RXOMC(2,7,0:5)
     3,RXOMN(2,7,0:5),RXOMP(2,7,0:5),R3OMC(2,7,0:5),R3OMN(2,7,0:5)
     4,R3OMP(2,7,0:5),RXMMC(2,7,0:5),RXMMN(2,7,0:5),RXMMP(2,7,0:5) 
     4,R3MMC(2,7,0:5),R3MMN(2,7,0:5),R3MMP(2,7,0:5) 
      DIMENSION CGOQC(7,0:5),CGOAC(7,0:5) 
     2,EN2F(7),ORCT(0:4),OSCT(0:4),OSAT(0:4),ZNH4T(0:JZ),ZNO3T(0:JZ)
     3,ZNO2T(0:JZ),H2P4T(0:JZ),RINH4R(7,0:5),RINO3R(7,0:5)
     4,RIPO4R(7,0:5),FNH4XR(7,0:5),FNO3XR(7,0:5),FPO4XR(7,0:5)
     5,RGOMY(7,0:5),CNQ(0:4),CPQ(0:4),CNH(0:4),CPH(0:4)
     6,CNS(4,0:4),CPS(4,0:4),DCKM(0:4),DCKX(0:4) 
     7,DOSA(0:4),DOSX(0:4),DOSM(0:4),FORC(0:5)
     8,CGOMS(2,7,0:5),CGONS(2,7,0:5),CGOPS(2,7,0:5),TOCK(0:5),TONK(0:5) 
     1,TOPK(0:5),FCNK(0:4),FCPK(0:4),CNRH(0:4),CPRH(0:4),CNOMK(0:4)
     2,CPOMK(0:4),RCO2X(7,0:5),RCH3X(7,0:5),RCH4X(7,0:5) 
     2,RVOXA(7),RVOXB(7),TGROMC(0:7),XOMA(0:4),XONA(0:4),XOPA(0:4)
     3,FCN(7,0:5),FCP(7,0:5),FCNP(7,0:5),FSBST(7,0:5) 
C
C     SUBSTRATE DECOMPOSITION BY MICROBIAL POPULATIONS
C
      PARAMETER (ORAD=1.0E-06,BIOS=1.0E-06/(4.19*ORAD**3) 
     2,BIOA=BIOS*12.57*ORAD**2,DNKI=12.5,DCKI=25.0,RCCX=0.750
     3,RCCQ=0.750,RCCY=0.833,RCCZ=0.167
     4,OMGR=0.250,OQKI=1200.0,H2KI=1.0,OAKI=12.0,DOMK=250.0
     5,CNKI=1.0E+01,CPKI=7.5E+01,ZSKI=1.0E-01,PSKI=1.33E-02
     6,FOSCZ0=2.0E-02,FOSCZL=0.5E-06,FMN=1.0E-06)
C
C     SPECIFIC RESPIRATION RATES, M-M UPTAKE CONSTANTS,
C     STOICHIOMETRIC CONSTANTS FOR MICROBIAL REDOX REACTIONS
C
      PARAMETER (VMXO=0.10,VMXF=0.10,VMXM=0.10,VMXH=0.33,VMXN=0.33
     2,VMX4=0.10,VMXC=0.10,OQKM=1.2E+01,OQKA=1.2E+01,OQKAM=1.2E+01
     3,CCKM=0.15,CCK4=0.012,ZHKM=2.0E-04,ZNKM=0.70,Z3KM=1.4
     4,Z2KM=1.4,Z1KM=0.014,Z4MX=5.0E-03,Z4KU=0.40,Z4MN=0.0125 
     5,ZOMX=5.0E-03,ZOKU=0.35,ZOMN=0.03,HPMX=1.0E-03,HPKU=0.075 
     6,HPMN=0.002,ZFKM=0.14,H2KM=0.01,C3KI=1.0,ECNH=0.133
     7,ECNO=0.044,ECN3=0.857,ECN2=0.857,ECN1=0.429
     8,ECHO=0.75,VMKI=0.50,OXKA=0.32,EDNH=0.25,EDNA=0.25)
C
C     ENERGY REQUIREMENTS FOR MICROBIAL GROWTH AND
C     ENERGY YIELDS FROM REDUCTION OF O2,OC, CH4, NO3, N2
C
      PARAMETER (EOMC=25.0,EOMF=25.0,EOMD=37.5,EOMN=112.5,EOMH=25.0
     2,GO2X=37.5,GCHX=4.50,GO2A=GO2X-GCHX,GC4X=3.00,GCOX=11.00
     3,GNOX=10.0,GN2X=187.5,EN2X=GO2X/GN2X,EN2Y=GCHX/GN2X
     4,EO2X=1.0/(1.0+GO2X/EOMC),EO2D=1.0/(1.0+GO2X/EOMD)
     5,ENFX=1.0/(1.0+GO2X/EOMN),ENOX=1.0/(1.0+GNOX/EOMC) 
     7,EO2A=1.0/(1.0+GO2A/EOMC))
C
C     SORPTION RATE CONSTANTS
C
      PARAMETER (TSORP=0.5,HSORP=1.0)
C
C     SPECIFIC DECOMPOSITION RATES
C
      PARAMETER (SPOHC=0.025,SPOHA=0.025,RMOM=0.010)
      DATA SPOSC/1.00,1.00,0.15,0.025,1.00,1.00,0.15,0.025
     2,1.00,1.00,0.15,0.025,0.005,0.00,0.00,0.00
     3,0.005,0.00167,0.00,0.00/
      DATA SPORC/5.00,1.00/
      DATA SPOMC/10.0E-03,5.0E-04/
      DATA DCKM/5.0E+02,5.0E+02,5.0E+02,5.0E+02,5.0E+02/
      DATA DOSA/5.0E+00,5.0E+00,5.0E+00,5.0E+00,5.0E+00/
      DATA DOSX/0.0500,0.0500,0.0500,0.0125,0.0125/
      DATA DOSM/0.0050,0.0050,0.0050,0.0025,0.0025/
      DATA DCKX/0.50,0.50,0.50,0.00,0.00/
C
C     MICROBIAL C:N:P RATIOS DURING HUMIFICATION
C
      DATA CNRH/3.33E-02,3.33E-02,3.33E-02,6.67E-02,12.50E-02/
      DATA CPRH/4.44E-03,4.44E-03,4.44E-03,8.89E-03,16.67E-03/
      DATA EN2F/0.0,0.0,0.0,0.0,0.0,EN2X,EN2Y/
      DATA OMCF/0.50,0.05,0.25,0.05,0.05,0.05,0.05/
      REAL*4 WFNG,TFNX,TFNY,TFNG,TFNR,CNSHZ,CPSHZ,FRM
C     REAL*16 B,C
      DO 9995 NX=NHW,NHE
      DO 9990 NY=NVN,NVS
      DO 998 L=0,NL(NY,NX)
      IF(L.EQ.0.OR.L.GE.NU(NY,NX))THEN
      IF(L.EQ.0)THEN
      KL=2
      ZNH4T(NU(NY,NX))=AMAX1(0.0,ZNH4S(NU(NY,NX),NY,NX))
     2+AMAX1(0.0,ZNH4B(NU(NY,NX),NY,NX))
      ZNO3T(NU(NY,NX))=AMAX1(0.0,ZNO3S(NU(NY,NX),NY,NX))
     2+AMAX1(0.0,ZNO3B(NU(NY,NX),NY,NX))
      ZNO2T(NU(NY,NX))=AMAX1(0.0,ZNO2S(NU(NY,NX),NY,NX))
     2+AMAX1(0.0,ZNO2B(NU(NY,NX),NY,NX))
      H2P4T(NU(NY,NX))=AMAX1(0.0,H2PO4(NU(NY,NX),NY,NX))
     2+AMAX1(0.0,H2POB(NU(NY,NX),NY,NX))
      IF(VOLX(L,NY,NX).GT.ZEROS(NY,NX))THEN
      VOLWZ=AMAX1(0.0,(AMIN1(0.6*VOLWRX(NY,NX)/VOLX(L,NY,NX)
     2,THETW(L,NY,NX))-THETY(L,NY,NX))*VOLX(L,NY,NX))
      ELSE
      VOLWZ=0.0
      ENDIF
      ELSE
      KL=4
      VOLWZ=AMAX1(0.0,(AMIN1(0.6*POROS(L,NY,NX) 
     2,THETW(L,NY,NX))-THETY(L,NY,NX))*VOLX(L,NY,NX))
      ENDIF
C
C     TEMPERATURE FUNCTIONS FOR GROWTH AND MAINTENANCE
C     WITH OFFSET FOR THERMAL ADAPTATION
C
      TKSO=TKS(L,NY,NX)+OFFSET(NY,NX)
      TCSR=AMIN1(45.0,TCS(L,NY,NX)+OFFSET(NY,NX))
      RTK=8.3143*TKSO
      STK=710.0*TKSO
      ACTV=1+EXP((195000-STK)/RTK)+EXP((STK-222500)/RTK)
      TFNX=EXP(25.227-62500/RTK)/ACTV
      TFNY=EXP(0.0742*(TCSR-25.0))
      WFNG=EXP(0.05*PSISM(L,NY,NX))
      TFNG=TFNX*WFNG
      TFNR=TFNY*WFNG
C
C     BIOLOGICALLY AVAILABLE WATER, TOTAL MINERAL NH4, NO3 AND PO4
C
      ZNH4T(L)=AMAX1(0.0,ZNH4S(L,NY,NX))+AMAX1(0.0,ZNH4B(L,NY,NX))
      ZNO3T(L)=AMAX1(0.0,ZNO3S(L,NY,NX))+AMAX1(0.0,ZNO3B(L,NY,NX))
      ZNO2T(L)=AMAX1(0.0,ZNO2S(L,NY,NX))+AMAX1(0.0,ZNO2B(L,NY,NX))
      H2P4T(L)=AMAX1(0.0,H2PO4(L,NY,NX))+AMAX1(0.0,H2POB(L,NY,NX))
      COXYQ1=COXYG(L,NY,NX)*SOXYL(L,NY,NX)
C
C     TOTAL SUBSTRATE
C
      TOSC=0.0
      TOSA=0.0
      TORC=0.0
      TOHC=0.0
C
C     TOTAL SOLID SUBSTRATE
C
      DO 870 K=0,KL
      OSCT(K)=0.0
      OSAT(K)=0.0
      DO 865 M=1,4
      OSCT(K)=OSCT(K)+OSC(M,K,L,NY,NX)
      OSAT(K)=OSAT(K)+OSA(M,K,L,NY,NX)
865   CONTINUE
      TOSC=TOSC+OSCT(K)
      TOSA=TOSA+OSAT(K)
870   CONTINUE
C
C     TOTAL BIORESIDUE
C
      DO 880 K=0,KL
      ORCT(K)=0.0
      DO 875 M=1,2
      ORCT(K)=ORCT(K)+ORC(M,K,L,NY,NX)
875   CONTINUE
      TORC=TORC+ORCT(K)
C
C     TOTAL ADSORBED AND DISSOLVED SUBSTRATE
C
      TOHC=TOHC+OHC(K,L,NY,NX)+OHA(K,L,NY,NX)
880   CONTINUE
      DO 860 K=0,KL
      OSRH(K)=OSAT(K)+ORCT(K)+OHC(K,L,NY,NX)+OHA(K,L,NY,NX)
860   CONTINUE
      TSRH=TOSA+TORC+TOHC
C
C     C:N AND C:P RATIOS OF TOTAL BIOMASS
C
      TOMA=0.0
      TOMN=0.0
      DO 890 K=0,5
      IF(L.NE.0.OR.(K.NE.3.AND.K.NE.4))THEN
      DO 895 N=1,7
      IF(K.NE.5.OR.(N.LE.3.OR.N.EQ.5))THEN
      IF(OMC(1,N,K,L,NY,NX).GT.ZEROS(NY,NX))THEN
      CNOMA(N,K)=AMAX1(0.0,OMN(1,N,K,L,NY,NX)/OMC(1,N,K,L,NY,NX))
      CPOMA(N,K)=AMAX1(0.0,OMP(1,N,K,L,NY,NX)/OMC(1,N,K,L,NY,NX))
      ELSE
      CNOMA(N,K)=CNOMC(1)
      CPOMA(N,K)=CPOMC(1)
      ENDIF
      OMA(N,K)=AMAX1(0.0,OMC(1,N,K,L,NY,NX)/FL(1))
      FCN(N,K)=AMIN1(1.0,AMAX1(0.25,CNOMA(N,K)/CNOMC(1)))
      FCP(N,K)=AMIN1(1.0,AMAX1(0.25,CPOMA(N,K)/CPOMC(1)))
      FCNP(N,K)=AMIN1(FCN(N,K),FCP(N,K))
C
C     TOTAL BIOMASS
C
      IF(K.NE.5.OR.(N.LE.3.OR.N.EQ.5))THEN
      TOMA=TOMA+OMA(N,K)
      ENDIF
      IF((K.LE.4.AND.N.EQ.2).OR.(K.EQ.5.AND.N.EQ.1))THEN
      TOMN=TOMN+OMA(N,K)
      ENDIF
      OMC2(N,K)=AMAX1(0.0,AMIN1(OMA(N,K)*FL(2),OMC(2,N,K,L,NY,NX)))
      IF(OMC(2,N,K,L,NY,NX).GT.ZEROS(NY,NX))THEN
      FOM2(N,K)=AMAX1(0.0,OMC2(N,K)/OMC(2,N,K,L,NY,NX))
      OMN2(N,K)=AMAX1(0.0,FOM2(N,K)*OMN(2,N,K,L,NY,NX))
      ELSE
      FOM2(N,K)=0.0
      OMN2(N,K)=0.0
      ENDIF
      ENDIF
895   CONTINUE
      ENDIF
890   CONTINUE
      DO 690 K=0,KL
      TOMK(K)=0.0
      TOCK(K)=0.0
      TONK(K)=0.0
      TOPK(K)=0.0
      DO 685 N=1,7
      IF(K.NE.5.OR.(N.LE.3.OR.N.EQ.5))THEN
      TOMK(K)=TOMK(K)+OMA(N,K) 
      TOCK(K)=TOCK(K)+OMC(1,N,K,L,NY,NX)
      TONK(K)=TONK(K)+OMN(1,N,K,L,NY,NX)
      TOPK(K)=TOPK(K)+OMP(1,N,K,L,NY,NX)
      ENDIF
685   CONTINUE
690   CONTINUE
      DO 790 K=0,KL
      IF(TSRH.GT.ZEROS(NY,NX))THEN
      FOSRH(K)=OSRH(K)/TSRH
      ELSE
      FOSRH(K)=1.0
      ENDIF
C
C     DOC CONCENTRATIONS
C
      IF(VOLWM(NPH,L,NY,NX).GT.ZEROS(NY,NX))THEN
      IF(FOSRH(K).GT.ZERO)THEN
      COQC(K,L,NY,NX)=AMAX1(0.0,OQC(K,L,NY,NX)
     2/(VOLWM(NPH,L,NY,NX)*FOSRH(K)))
      COQA(K,L,NY,NX)=AMAX1(0.0,OQA(K,L,NY,NX)
     2/(VOLWM(NPH,L,NY,NX)*FOSRH(K)))
      ELSE
      COQC(K,L,NY,NX)=AMAX1(0.0,OQC(K,L,NY,NX)/VOLWM(NPH,L,NY,NX))
      COQA(K,L,NY,NX)=AMAX1(0.0,OQA(K,L,NY,NX)/VOLWM(NPH,L,NY,NX))
      ENDIF
      ELSE
      COQC(K,L,NY,NX)=0.0
      COQA(K,L,NY,NX)=0.0
      OHCQ=0.0
      ENDIF
      IF(OQC(K,L,NY,NX).GT.ZEROS(NY,NX))THEN
      CNQ(K)=AMAX1(0.0,OQN(K,L,NY,NX)/OQC(K,L,NY,NX))
      CPQ(K)=AMAX1(0.0,OQP(K,L,NY,NX)/OQC(K,L,NY,NX))
      ELSE
      CNQ(K)=0.0
      CPQ(K)=0.0
      ENDIF
      IF(OQC(K,L,NY,NX).GT.ZEROS(NY,NX).AND.OQA(K,L,NY,NX)
     2.GT.ZEROS(NY,NX))THEN
      FOCA(K)=OQC(K,L,NY,NX)/(OQC(K,L,NY,NX)+OQA(K,L,NY,NX))
      FOAA(K)=1.0-FOCA(K)
      ELSEIF(OQC(K,L,NY,NX).GT.ZEROS(NY,NX))THEN
      FOCA(K)=1.0
      FOAA(K)=0.0
      ELSE
      FOCA(K)=0.0
      FOAA(K)=1.0
      ENDIF
790   CONTINUE
C
C     NITROUS ACID CONCN AND ENERGY YIELD OF HYDROGENOTROPHIC 
C     METHANOGENESIS AT AMBIENT H2 CONCENTRATION
C
      CHY1=AMAX1(ZERO,10.0**(-(PH(L,NY,NX)-3.0)))
      CHNO2=CNO2S(L,NY,NX)*CHY1/0.5
      CHNOB=CNO2B(L,NY,NX)*CHY1/0.5
      GH2X=8.3143E-03*TKS(L,NY,NX)
     2*LOG((AMAX1(1.0E-03,CH2GS(L,NY,NX))/H2KI)**4)
C
C     RESPIRATION BY MICROBIAL POPULATIONS
C
      TFOXYX=0.0
      TFNH4X=0.0
      TFNO3X=0.0
      TFNO2X=0.0
      TFN2OX=0.0
      TFPO4X=0.0
      TFNH4B=0.0
      TFNO3B=0.0
      TFNO2B=0.0
      TFPO4B=0.0
      TCH4H=0.0
      TCH4A=0.0
      TFOQC=0.0
      TFOQA=0.0
      TRH2G=0.0
      DO 760 K=0,5
      IF(L.NE.0.OR.(K.NE.3.AND.K.NE.4))THEN
      DO 750 N=1,7
      IF(K.LE.4)THEN
      OXKX=OXKM
      ELSE
      OXKX=OXKA
      ENDIF
      IF(K.NE.5.OR.(N.LE.3.OR.N.EQ.5))THEN
C
C     INITIALIZE MICROBIAL POPULATIONS IF SUBSTRATE PRESENT
C     WITHOUT BIOMASS
C
      IF(OMC(1,N,K,L,NY,NX).LE.0.0)THEN
      IF(K.LE.4)THEN
      IF(OSRH(K).GT.0.0)THEN
      DO 815 M=1,3
      OMC(M,N,K,L,NY,NX)=1.0E-03*OSRH(K)*OMCF(N)
      OMN(M,N,K,L,NY,NX)=OMC(M,N,K,L,NY,NX)*CNOMA(N,K)*OMCF(N)
      OMP(M,N,K,L,NY,NX)=OMC(M,N,K,L,NY,NX)*CPOMA(N,K)*OMCF(N)
815   CONTINUE
      ENDIF
      ENDIF
      ENDIF
      IF(OMA(N,K).GT.0.0)THEN
      IF(TOMA.GT.ZEROS(NY,NX))THEN
      FOMA(N,K)=OMA(N,K)/TOMA
      ELSE
      FOMA(N,K)=1.0
      ENDIF
      IF(TOMN.GT.ZEROS(NY,NX))THEN
      FOMN(N,K)=OMA(N,K)/TOMN
      ELSE
      FOMN(N,K)=1.0
      ENDIF
      IF(TOMK(K).GT.ZEROS(NY,NX))THEN
      FOMK(N,K)=OMA(N,K)/TOMK(K)
      ELSE
      FOMK(N,K)=1.0
      ENDIF
      IF(K.LE.4.AND.BKVL(L,NY,NX).GT.ZEROS(NY,NX))THEN
      IF(FOSRH(K).GT.ZERO)THEN
      DOMA=OMA(N,K)/(BKVL(L,NY,NX)*FOSRH(K))
      ELSE
      DOMA=OMA(N,K)/BKVL(L,NY,NX)
      ENDIF
      SPOMC2=DOMA/(DOMA+DOMK)
      ELSE
      IF(VOLW(L,NY,NX).GT.ZEROS(NY,NX))THEN 
      DOMA=OMA(N,K)/VOLW(L,NY,NX)
      SPOMC2=DOMA/(DOMA+DOMK)
      ELSE
      SPOMC2=1.0
      ENDIF
      ENDIF
      OXYI=1.0-1.0/(1.0+EXP(1.0*(-COXYS(L,NY,NX)+5.0)))
C
C     FACTORS CONSTRAINING DOC,ACETATE, O2, NH4, NO3, PO4 UPTAKE AMONG
C     COMPETING MICROBIAL AND ROOT POPULATIONS IN SOIL LAYERS
C
      IF(ROXYY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FOXYX=AMAX1(FMN,ROXYS(N,K,L,NY,NX)/ROXYY(L,NY,NX))
      ELSE
      FOXYX=AMAX1(FMN,FOMA(N,K))
      ENDIF
      IF(RNH4Y(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNH4X=AMAX1(FMN,RINHO(N,K,L,NY,NX)/RNH4Y(L,NY,NX))
      ELSE
      FNH4X=AMAX1(FMN,FOMA(N,K)*VLNH4(L,NY,NX))
      ENDIF
      IF(RNHBY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNB4X=AMAX1(FMN,RINHB(N,K,L,NY,NX)/RNHBY(L,NY,NX))
      ELSE
      FNB4X=AMAX1(FMN,FOMA(N,K)*VLNHB(L,NY,NX))
      ENDIF
      IF(RNO3Y(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNO3X=AMAX1(FMN,RINOO(N,K,L,NY,NX)/RNO3Y(L,NY,NX))
      ELSE
      FNO3X=AMAX1(FMN,FOMA(N,K)*VLNO3(L,NY,NX))
      ENDIF
      IF(RN3BY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNB3X=AMAX1(FMN,RINOB(N,K,L,NY,NX)/RN3BY(L,NY,NX))
      ELSE
      FNB3X=AMAX1(FMN,FOMA(N,K)*VLNOB(L,NY,NX))
      ENDIF
      IF(RPO4Y(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FPO4X=AMAX1(FMN,RIPOO(N,K,L,NY,NX)/RPO4Y(L,NY,NX))
      ELSE
      FPO4X=AMAX1(FMN,FOMA(N,K)*VLPO4(L,NY,NX))
      ENDIF
      IF(RPOBY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FPB4X=AMAX1(FMN,RIPOB(N,K,L,NY,NX)/RPOBY(L,NY,NX))
      ELSE
      FPB4X=AMAX1(FMN,FOMA(N,K)*VLPOB(L,NY,NX))
      ENDIF
      IF(K.LE.4)THEN
      IF(ROQCY(K,L,NY,NX).GT.ZEROS(NY,NX))THEN
      FOQC=AMAX1(FMN,ROQCS(N,K,L,NY,NX)/ROQCY(K,L,NY,NX))
      ELSE
      FOQC=AMAX1(FMN,FOMK(N,K))
      ENDIF
      TFOQC=TFOQC+FOQC
      IF(ROQAY(K,L,NY,NX).GT.ZEROS(NY,NX))THEN
      FOQA=AMAX1(FMN,ROQAS(N,K,L,NY,NX)/ROQAY(K,L,NY,NX))
      ELSE
      FOQA=AMAX1(FMN,FOMK(N,K))
      ENDIF
      TFOQA=TFOQA+FOQA
      ENDIF
      TFOXYX=TFOXYX+FOXYX
      TFNH4X=TFNH4X+FNH4X
      TFNO3X=TFNO3X+FNO3X
      TFPO4X=TFPO4X+FPO4X
      TFNH4B=TFNH4B+FNB4X
      TFNO3B=TFNO3B+FNB3X
      TFPO4B=TFPO4B+FPB4X
C
C     FACTORS CONSTRAINING NH4, NO3, PO4 UPTAKE AMONG COMPETING
C     MICROBIAL POPULATIONS IN SURFACE RESIDUE
C
      IF(L.EQ.0)THEN
      IF(RNH4Y(NU(NY,NX),NY,NX).GT.ZEROS(NY,NX))THEN
      FNH4XR(N,K)=AMAX1(1.0E-03,RINHOR(N,K,NY,NX)
     2/RNH4Y(NU(NY,NX),NY,NX))
      ELSE
      FNH4XR(N,K)=0.0
      ENDIF
      IF(RNO3Y(NU(NY,NX),NY,NX).GT.ZEROS(NY,NX))THEN
      FNO3XR(N,K)=AMAX1(1.0E-03,RINOOR(N,K,NY,NX)
     2/RNO3Y(NU(NY,NX),NY,NX))
      ELSE
      FNO3XR(N,K)=0.0
      ENDIF
      IF(RPO4Y(NU(NY,NX),NY,NX).GT.ZEROS(NY,NX))THEN
      FPO4XR(N,K)=AMAX1(1.0E-03,RIPOOR(N,K,NY,NX)
     2/RPO4Y(NU(NY,NX),NY,NX))
      ELSE
      FPO4XR(N,K)=0.0
      ENDIF
      ENDIF
      IF(L.EQ.NU(NY,NX).AND.K.NE.3.AND.K.NE.4
     2.AND.BKVL(0,NY,NX).GT.ZEROS(NY,NX))THEN
      TFNH4X=TFNH4X+FNH4XR(N,K)
      TFNO3X=TFNO3X+FNO3XR(N,K)
      TFPO4X=TFPO4X+FPO4XR(N,K)
      ENDIF
C
C     HETEROTROPHIC BIOMASS RESPIRATION
C
      IF(K.LE.4)THEN
C
C     RESPIRATION BY HETEROTROPHIC AEROBES:
C     N=(1)OBLIGATE AEROBES,(2)FACULTATIVE ANAEROBES,(3)FUNGI,(6)N2 FIXERS
C
      IF(N.LE.3.OR.N.EQ.6)THEN
C
C     ENERGY YIELDS OF REDOX REACTIONS
C
      IF(N.EQ.1.OR.N.EQ.3)THEN
      EO2Q=EO2X
      ELSEIF(N.EQ.2)THEN
      EO2Q=EO2D
      ELSEIF(N.EQ.6)THEN
      EO2Q=ENFX
      ENDIF
C
C     O2-UNCONSTRAINED RESPIRATION RATES BY HETEROTROPHIC AEROBES 'RGO*Z'
C     FROM SPECIFIC OXIDATION RATE, ACTIVE BIOMASS, DOC OR ACETATE

C     CONCENTRATION,MICROBIAL C:N:P FACTOR, AND TEMPERATURE FOLLOWED BY
C     POTENTIAL RESPIRATION RATES 'RGO*P' WITH UNLIMITED SUBSTRATE USED
C     FOR MICROBIAL COMPETITION FACTOR
C
      FSBSTC=COQC(K,L,NY,NX)/(COQC(K,L,NY,NX)+OQKM)
      FSBSTA=COQA(K,L,NY,NX)/(COQA(K,L,NY,NX)+OQKA)
      RGOCZ=AMAX1(0.0,FCNP(N,K)*TFNG*VMXO*OMA(N,K))
     2*FOCA(K)*FSBSTC
      RGOAZ=AMAX1(0.0,FCNP(N,K)*TFNG*VMXO*OMA(N,K))
     2*FOAA(K)*FSBSTA 
      FSBST(N,K)=FOQC*FSBSTC+FOQA*FSBSTA 
      RGOCX=AMAX1(0.0,OQC(K,L,NY,NX)*FOQC*EO2Q)
      RGOAX=AMAX1(0.0,OQA(K,L,NY,NX)*FOQA*EO2A)
      RGOCP=AMIN1(RGOCX,RGOCZ) 
      RGOAP=AMIN1(RGOAX,RGOAZ) 
      RGOMP=RGOCP+RGOAP
      IF(RGOMP.GT.ZEROS(NY,NX))THEN
      FGOCP=RGOCP/RGOMP
      FGOAP=RGOAP/RGOMP
      ELSE
      FGOCP=1.0
      FGOAP=0.0
      ENDIF
C
C     ENERGY YIELD AND O2 DEMAND FROM DOC AND ACETATE OXIDATION
C     BY HETEROTROPHIC AEROBES
C
      ECHZ=EO2Q*FGOCP+EO2A*FGOAP
      ROXYM(N,K)=2.667*RGOMP
      ROXYP(N,K)=ROXYM(N,K)
      ROXYS(N,K,L,NY,NX)=ROXYP(N,K)
      ROQCS(N,K,L,NY,NX)=RGOCZ 
      ROQAS(N,K,L,NY,NX)=RGOAZ 
C     IF((I/10)*10.EQ.I.AND.NX.EQ.3.AND.NY.EQ.1.AND.J.EQ.24)THEN
C     WRITE(*,5555)'RGOMP',I,J,NX,NY,L,K,N,RGOMP,RGOCP,RGOAP,RGOCZ 
C    2,RGOAZ,RGOCX,RGOAX,FCNP(N,K),TFNG,VMXO,OMA(N,K),FOCA(K)
C    2,COQC(K,L,NY,NX),OQC(K,L,NY,NX),FOQC,EO2Q,TKS(L,NY,NX)
C    3,OQKM,OMC(1,N,K,L,NY,NX),OMC(2,N,K,L,NY,NX),OMC(3,N,K,L,NY,NX)
C    3,VOLWM(NPH,L,NY,NX),FOSRH(K),DOMA,SPOMC2 
5555  FORMAT(A8,7I4,60E12.4)
C     ENDIF
C
C     RESPIRATION BY HETEROTROPHIC ANAEROBES:
C     N=(4)ACETOGENIC FERMENTERS (7) ACETOGENIC N2 FIXERS
C
C
C     ENERGY YIELD FROM FERMENTATION DEPENDS ON H2 CONCENTRATION
C
      ELSEIF(N.EQ.4.OR.N.EQ.7)THEN
      GH2F=GH2X/72.0
      GOAX=8.3143E-03*TKS(L,NY,NX) 
     2*LOG((AMAX1(ZERO,COQA(K,L,NY,NX))/OAKI)**2)
      GOAF=GOAX/72.0
      GHAX=GH2F+GOAF
      IF(N.EQ.4)THEN
      ECHZ=AMAX1(EO2X,AMIN1(1.0,1.0
     2/(1.0+AMAX1(0.0,(GCHX-GHAX))/EOMF)))
      ELSE
      ECHZ=AMAX1(ENFX,AMIN1(1.0,1.0
     2/(1.0+AMAX1(0.0,(GCHX-GHAX))/EOMN)))
      ENDIF
C
C     RESPIRATION RATES BY HETEROTROPHIC ANAEROBES 'RGOMP' FROM SPECIFIC
C     OXIDATION RATE, ACTIVE BIOMASS, DOC CONCENTRATION,
C     MICROBIAL C:N:P FACTOR, AND TEMPERATURE FOLLOWED BY POTENTIAL 
C     RESPIRATION RATES 'RGOMP' WITH UNLIMITED SUBSTRATE USED FOR MICROBIAL
C     COMPETITION FACTOR
C
      FSBST(N,K)=COQC(K,L,NY,NX)/(COQC(K,L,NY,NX)+OQKM)*OXYI
      SPOMC2=SPOMC2*OXYI 
      RGOFZ=AMAX1(0.0,FCNP(N,K)*TFNG*VMXF*OMA(N,K)*FSBST(N,K)) 
      RGOFX=AMAX1(0.0,OQC(K,L,NY,NX)*FOQC*ECHZ)
      RGOMP=AMIN1(RGOFX,RGOFZ)
      FGOCP=1.0
      FGOAP=0.0
      ROXYM(N,K)=0.0
      ROXYP(N,K)=0.0
      ROXYS(N,K,L,NY,NX)=0.0
      ROQCS(N,K,L,NY,NX)=RGOFZ 
      ROQAS(N,K,L,NY,NX)=0.0 
      TRH2G=TRH2G+RGOMP
C     IF((I/10)*10.EQ.I.AND.NX.EQ.3.AND.NY.EQ.1.AND.J.EQ.24)THEN
C     WRITE(*,5554)'FERM',I,J,NX,NY,L,K,N,RGOMP,RGOFZ,RGOFX,GHAX,GOAF 
C    2,ECHZ,FCNP(N,K),TFNG,OMA(N,K),FOQC,COQC(K,L,NY,NX),OQC(K,L,NY,NX)
C    3,OQKM,OMC(1,N,K,L,NY,NX),OMC(2,N,K,L,NY,NX),OMC(3,N,K,L,NY,NX)
C    3,OMN(1,N,K,L,NY,NX),OMN(2,N,K,L,NY,NX),OMN(3,N,K,L,NY,NX)
C    5,VOLWM(NPH,L,NY,NX),PSISM(L,NY,NX),WFNG,COXYS(L,NY,NX),OXYI
C    6,FSBST(N,K),FOSRH(K),DOMA,SPOMC2
5554  FORMAT(A8,7I4,60E12.4)
C     ENDIF
C
C     ENERGY YIELD FROM ACETOTROPHIC METHANOGENESIS
C
      ELSEIF(N.EQ.5)THEN
      GOMX=8.3143E-03*TKS(L,NY,NX) 
     2*LOG((AMAX1(ZERO,COQA(K,L,NY,NX))/OAKI))
      GOMM=GOMX/24.0
      ECHZ=AMAX1(EO2X,AMIN1(1.0,1.0/(1.0+AMAX1(0.0,(GC4X+GOMM))/EOMH)))
C
C     RESPIRATION RATES BY ACETOTROPHIC METHANOGENS 'RGOMP' FROM SPECIFIC
C     OXIDATION RATE, ACTIVE BIOMASS, DOC CONCENTRATION,
C     MICROBIAL C:N:P FACTOR, AND TEMPERATURE FOLLOWED BY POTENTIAL C
C     RESPIRATION RATES 'RGOMP' WITH UNLIMITED SUBSTRATE USED FOR 
C     MICROBIAL COMPETITION FACTOR
C
      FSBST(N,K)=COQA(K,L,NY,NX)/(COQA(K,L,NY,NX)+OQKAM)
      RGOGZ=AMAX1(0.0,FCNP(N,K)*TFNG*VMXM*OMA(N,K))*FSBST(N,K)
      RGOGX=AMAX1(0.0,OQA(K,L,NY,NX)*FOQA*ECHZ) 
      RGOMP=AMIN1(RGOGX,RGOGZ)
      FGOCP=0.0
      FGOAP=1.0
      ROXYM(N,K)=0.0
      ROXYP(N,K)=0.0
      ROXYS(N,K,L,NY,NX)=0.0
      ROQCS(N,K,L,NY,NX)=0.0 
      ROQAS(N,K,L,NY,NX)=RGOGZ 
      TCH4H=TCH4H+0.5*RGOMP
C     IF((I/10)*10.EQ.I.AND.NX.EQ.3.AND.NY.EQ.1.AND.J.EQ.24)THEN
C     WRITE(*,5552)'ACMETH',I,J,NX,NY,L,K,N,RGOMP,RGOGZ,RGOGX,GOMM 
C    2,ECHZ,FCNP(N,K),TFNG,OMA(N,K),FOQA,COQA(K,L,NY,NX),OQA(K,L,NY,NX)
C    3,OMC(1,N,K,L,NY,NX),OMC(2,N,K,L,NY,NX),OMC(3,N,K,L,NY,NX)
C    3,OMN(1,N,K,L,NY,NX),OMN(2,N,K,L,NY,NX),OMN(3,N,K,L,NY,NX)
C    5,VOLWM(NPH,L,NY,NX),PSISM(L,NY,NX),WFNG,COXYS(L,NY,NX) 
C    6,OHA(K,L,NY,NX),FSBST(N,K),SPOMC2
5552  FORMAT(A8,7I4,40E12.4)
C     ENDIF
      ENDIF
C
C     RESPIRATION RATES BY AUTOTROPHS 'RGOMP' FROM SPECIFIC
C     OXIDATION RATE, ACTIVE BIOMASS, DOC CONCENTRATION,
C     MICROBIAL C:N:P FACTOR, AND TEMPERATURE FOLLOWED BY POTENTIAL 
C     RESPIRATION RATES 'RGOMP' WITH UNLIMITED SUBSTRATE USED FOR MICROBIAL
C     COMPETITION FACTOR. N=(1) NH4 OXIDIZERS (2) NO2 OXIDIZERS,
C     (3) CH4 OXIDIZERS, (5) H2TROPHIC METHANOGENS
C
      ELSEIF(K.EQ.5)THEN
      XCO2=CCO2S(L,NY,NX)/(CCKM+CCO2S(L,NY,NX))
C
C     NH3 OXIDIZERS
C
      IF(N.EQ.1)THEN
C
C     FACTOR TO REGULATE COMPETITION FOR NH4 AMONG DIFFERENT
C     MICROBIAL AND ROOT POPULATIONS
C
      IF(RNH4Y(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNH4=AMAX1(1.0E-03,RVMX4(N,K,L,NY,NX)/RNH4Y(L,NY,NX))
      ELSE
      FNH4=AMAX1(1.0E-03,VLNH4(L,NY,NX)*FOMA(N,K))
      ENDIF
      IF(RNHBY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNB4=AMAX1(1.0E-03,RVMB4(N,K,L,NY,NX)/RNHBY(L,NY,NX))
      ELSE
      FNB4=AMAX1(1.0E-03,VLNHB(L,NY,NX)*FOMA(N,K))
      ENDIF
      TFNH4X=TFNH4X+FNH4
      TFNH4B=TFNH4B+FNB4
C
C     NH3 OXIDATION FROM SPECIFIC OXIDATION RATE, ENERGY YIELD,
C     ACTIVE OXIDIZER BIOMASS, TEMPERATURE, AQUEOUS CO2 AND
C     NH3 CONCENTRATIONS IN BAND AND NON-BAND SOIL ZONES
C
      ECHZ=EO2X
      VMXA=TFNG*FCNP(N,K)*XCO2*OMA(N,K)*VMXH
      FCN3S=CNH3S(L,NY,NX)/(ZHKM+CNH3S(L,NY,NX))
     2/(1.0+CNH3S(L,NY,NX)/C3KI)*VLNH4(L,NY,NX)
      FCN3B=CNH3B(L,NY,NX)/(ZHKM+CNH3B(L,NY,NX))
     2/(1.0+CNH3B(L,NY,NX)/C3KI)*VLNHB(L,NY,NX)
      FSBST(N,K)=FCN3S+FCN3B
      RVMX4S=VMXA*FCN3S
      RVMX4B=VMXA*FCN3B
      RNNH4=AMAX1(0.0,AMIN1(FNH4*ZNH4S(L,NY,NX),RVMX4S))
      RNNHB=AMAX1(0.0,AMIN1(FNB4*ZNH4B(L,NY,NX),RVMX4B))
      RVOXP=RNNH4+RNNHB
      RVOXPA=RNNH4
      RVOXPB=RNNHB
      RGOMP=AMAX1(0.0,RVOXP*ECNH*ECHZ) 
      RVMX4(N,K,L,NY,NX)=RVMX4S 
      RVMB4(N,K,L,NY,NX)=RVMX4B
C
C     O2 DEMAND FROM NH3 OXIDATION
C
      ROXYM(N,K)=2.667*RGOMP
      ROXYP(N,K)=ROXYM(N,K)+3.429*RVOXP 
      ROXYS(N,K,L,NY,NX)=ROXYP(N,K)
C     IF(L.LE.1)THEN
C     WRITE(*,6666)'NITRI',I,J,L,K,N,RNNH4,RNNHB
C    2,ZNH4S(L,NY,NX),ZNH4B(L,NY,NX),ZNH3S(L,NY,NX),ZNH3B(L,NY,NX)
C    3,CNH3S(L,NY,NX),CNH3B(L,NY,NX),COXYS(L,NY,NX)
C    4,PH(L,NY,NX),TFNG,FCNP(N,K),XCO2,ROXYM(N,K),FNH4,OMA(N,K)
C    5,FCN3S,FCN3B,FRNH4,FRNHB,VLNH4(L,NY,NX),VLNHB(L,NY,NX)
C    6,DPNH4(NY,NX),COXYG(L,NY,NX),RVMX4S,RVMX4B,VMXA,TFNX,WFNG
C    7,1.0+CNH3S(L,NY,NX)/C3KI,1.0+CNH3B(L,NY,NX)/C3KI 
6666  FORMAT(A8,5I4,40E12.4)
C     ENDIF
C
C     NO2 OXIDIZERS
C
      ELSEIF(N.EQ.2)THEN
C
C     FACTOR TO REGULATE COMPETITION FOR NO2 AMONG DIFFERENT
C     MICROBIAL POPULATIONS
C
      IF(RNO2Y(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNO2=AMAX1(1.0E-03*FOMN(N,K)*VLNO3(L,NY,NX)
     2,RVMX2(N,K,L,NY,NX)/RNO2Y(L,NY,NX))
      ELSE
      FNO2=AMAX1(1.0E-03,FOMN(N,K)*VLNO3(L,NY,NX))
      ENDIF
      IF(RN2BY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNB2=AMAX1(1.0E-03*FOMN(N,K)*VLNOB(L,NY,NX)
     2,RVMB2(N,K,L,NY,NX)/RN2BY(L,NY,NX))
      ELSE
      FNB2=AMAX1(1.0E-03,FOMN(N,K)*VLNOB(L,NY,NX))
      ENDIF
      TFNO2X=TFNO2X+FNO2
      TFNO2B=TFNO2B+FNB2
C
C     NO2 OXIDATION FROM SPECIFIC OXIDATION RATE, ENERGY YIELD,
C     ACTIVE OXIDIZER BIOMASS, TEMPERATURE, AQUEOUS CO2 AND
C     NO2 CONCENTRATIONS
C
      ECHZ=EO2X
      VMXA=TFNG*FCNP(N,K)*XCO2*OMA(N,K)*VMXN
      FCN2S=CNO2S(L,NY,NX)/(ZNKM+CNO2S(L,NY,NX))
     2/(1.0+CNH3S(L,NY,NX)/C3KI)*VLNO3(L,NY,NX) 
      FCN2B=CNO2B(L,NY,NX)/(ZNKM+CNO2B(L,NY,NX))
     2/(1.0+CNH3B(L,NY,NX)/C3KI)*VLNOB(L,NY,NX)
      FSBST(N,K)=FCN2S+FCN2B
      RVMX2S=VMXA*FCN2S
      RVMX2B=VMXA*FCN2B
      RNNO2=AMAX1(0.0,AMIN1(FNO2*ZNO2S(L,NY,NX),RVMX2S))
      RNNOB=AMAX1(0.0,AMIN1(FNB2*ZNO2B(L,NY,NX),RVMX2B))
      RVOXP=RNNO2+RNNOB
      RVOXPA=RNNO2
      RVOXPB=RNNOB
      RGOMP=AMAX1(0.0,RVOXP*ECNO*ECHZ) 
      RVMX2(N,K,L,NY,NX)=RVMX2S 
      RVMB2(N,K,L,NY,NX)=RVMX2B
C
C     O2 DEMAND FROM NO2 OXIDATION
C
      ROXYM(N,K)=2.667*RGOMP
      ROXYP(N,K)=ROXYM(N,K)+1.143*RVOXP 
      ROXYS(N,K,L,NY,NX)=ROXYP(N,K)
C     IF(L.LE.6)THEN
C     WRITE(*,6667)'NO2OX',I,J,L,K,N,RNNO2,RNNOB,ZNO2S(L,NY,NX)
C    2,ZNO2B(L,NY,NX),CNO2S(L,NY,NX),CNO2B(L,NY,NX),CNH3S(L,NY,NX)
C    3,CNH3B(L,NY,NX),CNH4S(L,NY,NX),CNH4B(L,NY,NX),CNO3S(L,NY,NX) 
C    3,CNO3B(L,NY,NX),CHNO2,CHNOB,VMXA,TFNG,FCNP(N,K),XCO2,VMXN,ZNKM
C    4,FCN2S,FCN2B,OMA(N,K),FOMN(N,K),TOMN,RVMX2(N,K,L,NY,NX)
C    5,RNO2Y(L,NY,NX),FNO2,FNB2,ROXYM(N,K),ROXYP(N,K) 
C    6,ROXYS(N,K,L,NY,NX),VLNHB(L,NY,NX),VLNOB(L,NY,NX) 
6667  FORMAT(A8,5I4,50E12.4)
C     ENDIF
C
C     H2TROPHIC METHANOGENS
C
      ELSEIF(N.EQ.5)THEN
C
C     CO2 REDUCTION FROM SPECIFIC REDUCTION RATE, ENERGY YIELD,
C     ACTIVE OXIDIZER BIOMASS, TEMPERATURE, AQUEOUS CO2 AND
C
      GH2H=GH2X/12.0
      ECHZ=AMAX1(EO2X,AMIN1(1.0,1.0/(1.0+AMAX1(0.0,(GCOX+GH2H))/EOMH)))
      VMXA=TFNG*FCNP(N,K)*XCO2*OMA(N,K)*VMXC
      H2GSX=H2GS(L,NY,NX)+0.111*TRH2G
      FSBST(N,K)=CH2GS(L,NY,NX)/(CH2GS(L,NY,NX)+H2KM)
      RGOMP=AMAX1(0.0,AMIN1(1.5*H2GSX,VMXA*FSBST(N,K)))
      ROXYM(N,K)=0.0
      ROXYM(N,K)=0.0
      ROXYS(N,K,L,NY,NX)=0.0
      TCH4A=TCH4A+RGOMP 
C     IF((I/10)*10.EQ.I.AND.NX.EQ.3.AND.NY.EQ.1.AND.J.EQ.24)THEN
C     WRITE(*,5553)'H2METH',I,J,NX,NY,L,K,N,RGOMP,H2GS(L,NY,NX)
C    2,H2GSX,CH2GS(L,NY,NX),VMXA,TFNG,FCNP(N,K),XCO2 
C    3,OMA(N,K),VMXC,ECHZ,GCOX,GH2H,TKS(L,NY,NX),FSBST(N,K),SPOMC2 
5553  FORMAT(A8,7I4,20E12.4)
C     ENDIF
C
C     METHANOTROPHS
C
      ELSEIF(N.EQ.3)THEN
C
C     CH4 OXIDATION FROM SPECIFIC OXIDATION RATE, ENERGY YIELD,
C     ACTIVE OXIDIZER BIOMASS, TEMPERATURE, AQUEOUS CO2 AND
C     CH4 CONCENTRATIONS IN BAND AND NON-BAND SOIL ZONES
C
      ECHZ=EO2X
      VMXA=TFNG*FCNP(N,K)*OMA(N,K)*VMX4
      RCH4L1=RCH4L(L,NY,NX)*XNPG
      RCH4F1=RCH4F(L,NY,NX)*XNPG
      RCH4S1=(TCH4H+TCH4A)*XNPG
      IF(L.EQ.0)THEN
      CH4G1=CCH4E(NY,NX)*VOLPM(1,L,NY,NX)
      ELSE
      CH4G1=CCH4G(L,NY,NX)*VOLPM(1,L,NY,NX)
      ENDIF
      CH4S1=CH4S(L,NY,NX) 
      VMXA1=VMXA*XNPG
      RVOXP=0.0
      RGOMP=0.0
      CH4GX=CH4G1
      CH4SX=CH4S1
C
C     CH4 DISSOLUTION FROM GASEOUS PHASE SOLVED IN SHORTER TIME STEP
C     TO MAINTAIN AQUEOUS CH4 CONCENTRATION DURING OXIDATION
C
      DO 320 M=1,NPH
      IF(VOLWM(M,L,NY,NX).GT.ZEROS(NY,NX))THEN
      VOLWCH=VOLWM(M,L,NY,NX)*SCH4L(L,NY,NX)
      VOLWPM=VOLWCH+VOLPM(M,L,NY,NX)
      DO 325 MM=1,NPT
      CH4G1=CH4G1+RCH4F1
      CH4S1=CH4S1+RCH4L1+RCH4S1 
      CCH4S1=AMAX1(0.0,CH4S1/VOLWM(M,L,NY,NX))
      FSBST(N,K)=CCH4S1/(CCH4S1+CCK4)
      RVOXP1=AMIN1(AMAX1(0.0,CH4S1)/(1.0+ECHO*ECHZ)
     2,VMXA1*FSBST(N,K))
      RGOMP1=RVOXP1*ECHO*ECHZ
      CH4S1=CH4S1-RVOXP1-RGOMP1 
      IF(THETPM(M,L,NY,NX).GT.THETX)THEN
      RCHDF=DFGS(M,L,NY,NX)*(AMAX1(ZEROS(NY,NX),CH4G1)*VOLWCH
     2-CH4S1*VOLPM(M,L,NY,NX))/VOLWPM
      ELSE
      RCHDF=0.0
      ENDIF
      CH4G1=CH4G1-RCHDF 
      CH4S1=CH4S1+RCHDF 
      RVOXP=RVOXP+RVOXP1
      RGOMP=RGOMP+RGOMP1
C     IF((I/10)*10.EQ.I.AND.NX.EQ.3.AND.NY.EQ.1.AND.J.EQ.24
C    2.AND.M.EQ.NPH)THEN
C     WRITE(*,5547)'CH4OX',I,J,NX,NY,L,K,N,M,MM,RVOXP1,RGOMP1,CH4G1 
C    2,CH4S1,VMXA1,RVOXP,RGOMP,RCHDF,RCH4L1,RCH4F1,RCH4S1,CCH4S1 
C    3,ECHO,ECHZ,OMA(N,K),VOLWM(M,L,NY,NX),VOLPM(M,L,NY,NX),VOLWCH
C    4,THETPM(M,L,NY,NX),SCH4L(L,NY,NX),DFGS(M,L,NY,NX)
C    5,COXYS(L,NY,NX),CCH4E(NY,NX),CH4GX,CH4SX,FSBST(N,K),SPOMC2
5547  FORMAT(A8,9I4,30E12.4)
C     ENDIF
325   CONTINUE
      ENDIF
320   CONTINUE
      RVOXPA=RVOXP
      RVOXPB=0.0
C
C     O2 DEMAND FROM CH4 OXIDATION
C
      ROXYM(N,K)=2.667*RGOMP
      ROXYP(N,K)=ROXYM(N,K)+4.00*RVOXP 
      ROXYS(N,K,L,NY,NX)=ROXYP(N,K) 
      ELSE
      RGOMP=0.0
      ROXYM(N,K)=0.0
      ROXYP(N,K)=0.0
      ROXYS(N,K,L,NY,NX)=0.0
      ENDIF
      ELSE
      RGOMP=0.0
      ROXYM(N,K)=0.0
      ROXYP(N,K)=0.0
      ROXYS(N,K,L,NY,NX)=0.0
      ENDIF
C
C     O2 UPTAKE BY AEROBES
C
      RUPOX(N,K)=0.0
      IF(N.LE.3.OR.N.EQ.6)THEN
      IF(ROXYP(N,K).GT.ZEROS(NY,NX).AND.FOXYX.GT.ZERO)THEN
      IF(L.NE.0.OR.VOLX(L,NY,NX).GT.ZEROS(NY,NX))THEN
C
C     MAXIMUM O2 UPAKE FROM POTENTIAL RESPIRATION OF EACH AEROBIC
C     POPULATION
C
      RUPMX=ROXYP(N,K)*XNPG 
      ROXYFX=ROXYF(L,NY,NX)*XNPG*FOXYX
      OLSGL1=OLSGL(L,NY,NX)*XNPG 
      IF(L.NE.0)THEN
      OXYG1=OXYG(L,NY,NX)*FOXYX
      ROXYLX=ROXYL(L,NY,NX)*XNPG*FOXYX
      ELSE
      OXYG1=COXYG(L,NY,NX)*VOLPM(1,L,NY,NX)*FOXYX
      ROXYLX=(ROXYL(L,NY,NX)+FLQRQ(NY,NX)*COXR(NY,NX)
     2+FLQRI(NY,NX)*COXQ(NY,NX))*XNPG*FOXYX
      ENDIF
      OXYS1=OXYS(L,NY,NX)*FOXYX
C
C     O2 DISSOLUTION FROM GASEOUS PHASE SOLVED IN SHORTER TIME STEP
C     TO MAINTAIN AQUEOUS O2 CONCENTRATION DURING REDUCTION
C
      DO 420 M=1,NPH
C
C     ACTUAL REDUCTION OF AQUEOUS BY AEROBES CALCULATED
C     FROM MASS FLOW PLUS DIFFUSION = ACTIVE UPTAKE 
C     COUPLED WITH DISSOLUTION OF GASEOUS O2 DURING REDUCTION 
C     OF AQUEOUS O2 FROM DISSOLUTION RATE CONSTANT 'DFGS' 
C     CALCULATED IN 'WATSUB'
C
      THETW1=AMAX1(0.0,VOLWM(M,L,NY,NX)/VOLX(L,NY,NX))
      RRADO=ORAD*(FILM(M,L,NY,NX)+ORAD)/FILM(M,L,NY,NX)
      DIFOX=TORT(L,NY,NX)*OLSGL1*12.57*BIOS*OMA(N,K)*RRADO
      VOLWOX=VOLWM(M,L,NY,NX)*SOXYL(L,NY,NX)
      VOLPOX=VOLPM(M,L,NY,NX)
      VOLWPM=VOLWOX+VOLPOX
      DO 425 MX=1,NPT
      OXYG1=OXYG1+ROXYFX
      OXYS1=OXYS1+ROXYLX 
      COXYS1=AMIN1(COXYE(NY,NX)*SOXYL(L,NY,NX)
     2,AMAX1(0.0,OXYS1/(VOLWM(M,L,NY,NX)*FOXYX)))
      X=DIFOX*COXYS1
      IF(X.GT.ZEROS(NY,NX).AND.OXYS1.GT.ZEROS(NY,NX))THEN
      B=-RUPMX-DIFOX*OXKX-X
      C=X*RUPMX
      RMPOX=(-B-SQRT(B*B-4.0*C))/2.0
      ELSE
      RMPOX=0.0
      ENDIF
      OXYS1=OXYS1-RMPOX
      IF(THETPM(M,L,NY,NX).GT.THETX.AND.VOLPOX.GT.ZEROS(NY,NX))THEN
      ROXDFQ=DFGS(M,L,NY,NX)*(AMAX1(ZEROS(NY,NX),OXYG1)*VOLWOX
     2-OXYS1*VOLPOX)/VOLWPM
      ELSE
      ROXDFQ=0.0
      ENDIF
      OXYG1=OXYG1-ROXDFQ 
      OXYS1=OXYS1+ROXDFQ 
      RUPOX(N,K)=RUPOX(N,K)+RMPOX
      ROXSK(M,L,NY,NX)=ROXSK(M,L,NY,NX)+RMPOX
C     IF(L.EQ.2.AND.M.EQ.NPH.AND.MX.EQ.NPT)THEN
C     WRITE(*,5545)'RMPOX',I,J,L,K,N,M,MX,OXYS1,ROXDFQ,ROXYLX,RMPOX 
C    2,DFGS(M,L,NY,NX),OXYG1,VOLWOX,VOLPOX,VOLWPM,X,B,C
C    3,RUPMX,DIFOX,OXKM,COXYS1,FOXYX,ROXYL(L,NY,NX) 
C    4,ROXSK(M,L,NY,NX),VOLWM(M,L,NY,NX)/VOLX(L,NY,NX) 
C    5,OXYS(L,NY,NX)
5545  FORMAT(A8,7I4,30E16.6)
C     ENDIF
C     IF(I.EQ.240.AND.J.EQ.24.AND.NX.EQ.4.AND.NY.EQ.1
C    2.AND.K.EQ.5.AND.N.EQ.3)THEN
C     WRITE(*,5544)'OXY',I,J,L,K,N,M,MX,RUPOX(N,K),ROXYP(N,K)
C    2,ROXSK(M,L,NY,NX),RUPMX,RMPOX,DIFOX,OLSGL1,BIOS,OMA(N,K),X 
C    2,ROXDFQ,ROXYLX,ROXYFX,FOXYX,COXYS1,OXYS1,OXYG1,OXYS1
C    4/(VOLWM(M,L,NY,NX)*FOXYX),OXYG1/(VOLPM(M,L,NY,NX)*FOXYX)
C    5,THETW1,THETPM(M,L,NY,NX),DFGS(M,L,NY,NX),ROXSK(M,L,NY,NX)
C    6,VOLPM(M,L,NY,NX),VOLWM(M,L,NY,NX),VOLA(L,NY,NX)
C    7,COXYS(L,NY,NX),COXYG(L,NY,NX),ROXYY(L,NY,NX),OXKX
5544  FORMAT(A8,7I4,50E12.4)
C     ENDIF
425   CONTINUE
420   CONTINUE
C
C     RATIO OF ACTUAL O2 UPAKE TO BIOLOGICAL DEMAND
C
      WFN(N,K)=AMIN1(1.0,AMAX1(0.0,RUPOX(N,K)/ROXYP(N,K)))
      IF(K.LE.4)THEN
      ROQCS(N,K,L,NY,NX)=ROQCS(N,K,L,NY,NX)*WFN(N,K)
      ROQAS(N,K,L,NY,NX)=ROQAS(N,K,L,NY,NX)*WFN(N,K)
      ENDIF
      IF(K.EQ.5)THEN
      IF(N.EQ.1)THEN
      RVMX4(N,K,L,NY,NX)=RVMX4(N,K,L,NY,NX)*WFN(N,K)
      RVMB4(N,K,L,NY,NX)=RVMB4(N,K,L,NY,NX)*WFN(N,K)
      ELSEIF(N.EQ.2)THEN
      RVMX2(N,K,L,NY,NX)=RVMX2(N,K,L,NY,NX)*WFN(N,K)
      RVMB2(N,K,L,NY,NX)=RVMB2(N,K,L,NY,NX)*WFN(N,K)
      ENDIF
      ENDIF
      ELSE
      RUPOX(N,K)=ROXYP(N,K)
      WFN(N,K)=1.0
      ENDIF
      ELSE
      RUPOX(N,K)=0.0
      WFN(N,K)=1.0
      ENDIF
C
C     RESPIRATION PRODUCTS ALLOCATED TO O2, CO2, ACETATE, CH4, H2
C
      RGOMO(N,K)=RGOMP*WFN(N,K)
      RCO2X(N,K)=RGOMO(N,K)
      RCH3X(N,K)=0.0
      RCH4X(N,K)=0.0
      ROXYO(N,K)=ROXYM(N,K)*WFN(N,K)
      RH2GX(N,K)=0.0
      IF(K.EQ.5)THEN
      RVOXA(N)=RVOXPA*WFN(N,K)
      RVOXB(N)=RVOXPB*WFN(N,K)
      ENDIF
      ELSEIF(N.EQ.4.OR.N.EQ.7)THEN
      RGOMO(N,K)=RGOMP
      RCO2X(N,K)=0.333*RGOMO(N,K)
      RCH3X(N,K)=0.667*RGOMO(N,K)
      RCH4X(N,K)=0.0
      ROXYO(N,K)=ROXYM(N,K)
      IF(K.LE.4)THEN
      RH2GX(N,K)=0.111*RGOMO(N,K)
      ELSE
      RH2GX(N,K)=0.0
      ENDIF
      ELSEIF(N.EQ.5)THEN
      RGOMO(N,K)=RGOMP
      IF(K.LE.4)THEN
      RCO2X(N,K)=0.50*RGOMO(N,K)
      RCH3X(N,K)=0.00
      RCH4X(N,K)=0.50*RGOMO(N,K)
      ROXYO(N,K)=ROXYM(N,K)
      RH2GX(N,K)=0.0
      ELSEIF(K.EQ.5)THEN
      RCO2X(N,K)=0.00
      RCH3X(N,K)=0.00
      RCH4X(N,K)=RGOMO(N,K)
      ROXYO(N,K)=ROXYM(N,K)
      RH2GX(N,K)=0.0
      RH2GZ=0.667*RGOMO(N,K)
      ENDIF
      ENDIF
C
C     HETEROTROPHIC DENITRIFICATION
C
      IF(K.LE.4.AND.N.EQ.2.AND.ROXYM(N,K).GT.0.0
     2.AND.(L.NE.0.OR.VOLX(L,NY,NX).GT.ZEROS(NY,NX)))THEN
C
C     FACTOR TO CONSTRAIN NO3 UPAKE AMONG COMPETING MICROBIAL
C     AND ROOT POPULATIONS
C
      IF(RNO3Y(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNO3=AMAX1(1.0E-03,RVMX3(N,K,L,NY,NX)/RNO3Y(L,NY,NX))
      ELSE
      FNO3=AMAX1(1.0E-03,FOMA(N,K)*VLNO3(L,NY,NX))
      ENDIF
      IF(RN3BY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNB3=AMAX1(1.0E-03,RVMB3(N,K,L,NY,NX)/RN3BY(L,NY,NX))
      ELSE
      FNB3=AMAX1(1.0E-03,FOMA(N,K)*VLNOB(L,NY,NX))
      ENDIF
      TFNO3X=TFNO3X+FNO3
      TFNO3B=TFNO3B+FNB3
C
C     NO3 REDUCTION FROM SPECIFIC REDUCTION RATE, ENERGY YIELD,
C     ACTIVE DENITRIFIER BIOMASS, TEMPERATURE, AQUEOUS NO3
C     CONCENTRATIONS AND STOICHIOMETRY OF REDOX ELECTRON TRANSFER
C     NOT ACCEPTED BY O2 IN BAND AND NON-BAND SOIL ZONES
C
      ROXYD=AMAX1(0.0,ROXYM(N,K)-ROXYO(N,K))
      VMXDX=EDNH*0.875*ROXYD
      IF(VOLX(L,NY,NX).GT.ZEROS(NY,NX).AND.FOSRH(K).GT.ZERO)THEN
      VMXD3=VMXDX/(1.0+VMKI*ROXYD/(VOLX(L,NY,NX)*FOSRH(K)))
      ELSE
      VMXD3=0.0
      ENDIF
      IF(CNO3S(L,NY,NX).GT.ZERO)THEN
      VMXD3S=VMXD3*VLNO3(L,NY,NX)*CNO3S(L,NY,NX)/(Z3KM+CNO3S(L,NY,NX))
     2/(1.0+(CNO2S(L,NY,NX)*Z3KM)/(CNO3S(L,NY,NX)*Z2KM))
      ELSE
      VMXD3S=0.0
      ENDIF
      IF(CNO3B(L,NY,NX).GT.ZERO)THEN
      VMXD3B=VMXD3*VLNOB(L,NY,NX)*CNO3B(L,NY,NX)/(Z3KM+CNO3B(L,NY,NX)) 
     2/(1.0+(CNO2B(L,NY,NX)*Z3KM)/(CNO3B(L,NY,NX)*Z2KM))
      ELSE
      VMXD3B=0.0
      ENDIF
      OQCZ3=AMAX1(0.0,OQC(K,L,NY,NX)*FOQC-RGOCP*WFN(N,K))
      OQCD3=OQCZ3/ECN3
      OQCD3S=OQCD3*VLNO3(L,NY,NX)
      OQCD3B=OQCD3*VLNOB(L,NY,NX)
      ZNO3SX=ZNO3S(L,NY,NX)*FNO3
      ZNO3BX=ZNO3B(L,NY,NX)*FNB3
      RDNO3X=AMAX1(0.0,AMIN1(ZNO3SX,VMXD3S))
      RDNOBX=AMAX1(0.0,AMIN1(ZNO3BX,VMXD3B))
      RDNO3(N,K)=AMAX1(0.0,AMIN1(VMXD3S,OQCD3S,ZNO3SX))
      RDNOB(N,K)=AMAX1(0.0,AMIN1(VMXD3B,OQCD3B,ZNO3BX))
      RDNOX=RDNO3X+RDNOBX
      RDNOT=RDNO3(N,K)+RDNOB(N,K)
      RGOM3X=ECN3*RDNOX
      RGOMD3=ECN3*RDNOT
      RVMX3(N,K,L,NY,NX)=VMXD3S 
      RVMB3(N,K,L,NY,NX)=VMXD3B
C
C     FACTOR TO CONSTRAIN NO2 UPAKE AMONG COMPETING MICROBIAL
C     POPULATIONS
C
      IF(RNO2Y(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNO2=AMAX1(1.0E-03,RVMX2(N,K,L,NY,NX)/RNO2Y(L,NY,NX))
      ELSE
      FNO2=AMAX1(1.0E-03,FOMA(N,K)*VLNO3(L,NY,NX))
      ENDIF
      IF(RN2BY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNB2=AMAX1(1.0E-03,RVMB2(N,K,L,NY,NX)/RN2BY(L,NY,NX))
      ELSE
      FNB2=AMAX1(1.0E-03,FOMA(N,K)*VLNOB(L,NY,NX))
      ENDIF
      TFNO2X=TFNO2X+FNO2
      TFNO2B=TFNO2B+FNB2
C
C     NO2 REDUCTION FROM SPECIFIC REDUCTION RATE, ENERGY YIELD,
C     ACTIVE DENITRIFIER BIOMASS, TEMPERATURE, AQUEOUS NO2
C     CONCENTRATIONS AND STOICHIOMETRY OF REDOX ELECTRON TRANSFER
C     NOT ACCEPTED BY O2 AND NO3 IN BAND AND NON-BAND SOIL ZONES
C
      VMXD2=VMXD3-RDNOT
      IF(CNO2S(L,NY,NX).GT.ZERO)THEN
      VMXD2S=VMXD2*VLNO3(L,NY,NX)*CNO2S(L,NY,NX)/(Z2KM+CNO2S(L,NY,NX))
     2/(1.0+(CZ2OS(L,NY,NX)*Z2KM)/(CNO2S(L,NY,NX)*Z1KM))
      ELSE
      VMXD2S=0.0
      ENDIF
      IF(CNO2B(L,NY,NX).GT.ZERO)THEN
      VMXD2B=VMXD2*VLNOB(L,NY,NX)*CNO2B(L,NY,NX)/(Z2KM+CNO2B(L,NY,NX))
     2/(1.0+(CZ2OS(L,NY,NX)*Z2KM)/(CNO2B(L,NY,NX)*Z1KM))
      ELSE
      VMXD2B=0.0
      ENDIF
      OQCZ2=AMAX1(0.0,OQCZ3-RGOMD3)
      OQCD2=OQCZ2/ECN2
      OQCD2S=OQCD2*VLNO3(L,NY,NX)
      OQCD2B=OQCD2*VLNOB(L,NY,NX)
      ZNO2SX=(ZNO2S(L,NY,NX)+RDNO3(N,K))*FNO2
      ZNO2BX=(ZNO2B(L,NY,NX)+RDNOB(N,K))*FNB2 
      RDNO2X=AMAX1(0.0,AMIN1(ZNO2SX,VMXD2S))
      RDNOBX=AMAX1(0.0,AMIN1(ZNO2BX,VMXD2B))
      RDNO2(N,K)=AMAX1(0.0,AMIN1(VMXD2S,OQCD2S,ZNO2SX))
      RDN2B(N,K)=AMAX1(0.0,AMIN1(VMXD2B,OQCD2B,ZNO2BX))
      RDN2X=RDNO2X+RDNOBX
      RDN2T=RDNO2(N,K)+RDN2B(N,K)
      RGOM2X=ECN2*RDN2X
      RGOMD2=ECN2*RDN2T
      RVMX2(N,K,L,NY,NX)=VMXD2S 
      RVMB2(N,K,L,NY,NX)=VMXD2B
C
C     FACTOR TO CONSTRAIN N2O UPAKE AMONG COMPETING MICROBIAL
C     AND ROOT POPULATIONS
C
      IF(RN2OY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FN2O=AMAX1(1.0E-03,RVMX1(N,K,L,NY,NX)/RN2OY(L,NY,NX))
      ELSE
      FN2O=AMAX1(1.0E-03,FOMA(N,K))
      ENDIF
      TFN2OX=TFN2OX+FN2O
C
C     N2O REDUCTION FROM SPECIFIC REDUCTION RATE, ENERGY YIELD,
C     ACTIVE DENITRIFIER BIOMASS, TEMPERATURE, AQUEOUS N2O
C     CONCENTRATIONS AND STOICHIOMETRY OF REDOX ELECTRON TRANSFER
C     NOT ACCEPTED BY O2, NO3 AND NO2 IN BAND AND NON-BAND SOIL ZONES
C
      VMXD1=(VMXD2-RDN2T)*2.0
      VMXD1S=VMXD1*CZ2OS(L,NY,NX)
     2/(Z1KM+CZ2OS(L,NY,NX))
      OQCZ1=AMAX1(0.0,OQCZ2-RGOMD2)
      OQCD1=OQCZ1/ECN1
      Z2OSX=(Z2OS(L,NY,NX)+RDN2T)*FN2O 
      RDN2OX=AMAX1(0.0,AMIN1(Z2OSX,VMXD1S))
      RDN2O(N,K)=AMAX1(0.0,AMIN1(VMXD1S,OQCD1,Z2OSX))
      RGOM1X=ECN1*RDN2OX
      RGOMD1=ECN1*RDN2O(N,K)
      RGOMY(N,K)=RGOM3X+RGOM2X+RGOM1X
      RGOMD(N,K)=RGOMD3+RGOMD2+RGOMD1
      RVMX1(N,K,L,NY,NX)=VMXD1S 
C     IF(L.LE.2.AND.I.EQ.170.AND.J.EQ.15)THEN
C     WRITE(*,2222)'DENIT',I,J,L,K,N,RDNO3(N,K),RDNOB(N,K),RDNO2(N,K)
C    2,RDN2B(N,K),RDN2O(N,K),COXYS(L,NY,NX),COXYG(L,NY,NX),ROXYM(N,K)
C    3,ROXYO(N,K),OMA(N,K),VMXD,CNO3S(L,NY,NX),CNO3B(L,NY,NX) 
C    4,CNO2S(L,NY,NX),CNO2B(L,NY,NX),CZ2OS(L,NY,NX),VLNO3(L,NY,NX)
C    5,VLNOB(L,NY,NX),THETW(L,NY,NX),THETI(L,NY,NX),FOMA(N,K)
C    5,ZNO3S(L,NY,NX),ZNO3B(L,NY,NX),ZNO2S(L,NY,NX),ZNO2B(L,NY,NX)
C    6,Z2OS(L,NY,NX),RGOMY(N,K),RGOMD(N,K),TOMA,FOXYX,FNO23S,FNO23B 
C    7,OQC(K,L,NY,NX),FOQC,RGOCP,WFN(N,K),VOLWZ,FOSRH(K),ZERO 
C    9,RGOM3X,RGOM2X,RGOM1X,FNO3,FNO2,FN2O,ZNO3SX,ZNO2SX,Z2OSX 
C    3,OQCD3S,OQCD2S,OQCD1,VMXD3S,VMXD2S,VMXD1S,VMXD3,VMXD2,VMXD1
C    4,ROXYD,VMXDX,TFNX,WFNG,TFNG,PSISM(L,NY,NX) 
C    2,(1.0+(CNO2S(L,NY,NX)*Z3KM)/(CNO3S(L,NY,NX)*Z2KM))
C    2,(1.0+(CZ2OS(L,NY,NX)*Z2KM)/(CNO2S(L,NY,NX)*Z1KM))
2222  FORMAT(A8,5I4,70E12.4)
C     ENDIF
C
C     AUTOTROPHIC DENITRIFICATION
C
      ELSEIF(K.EQ.5.AND.N.EQ.1.AND.ROXYM(N,K).GT.0.0
     2.AND.(L.NE.0.OR.VOLX(L,NY,NX).GT.ZEROS(NY,NX)))THEN
C
C     FACTOR TO CONSTRAIN NO2 UPAKE AMONG COMPETING MICROBIAL
C     POPULATIONS
C
      IF(RNO2Y(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNO2=AMAX1(1.0E-03*FOMN(N,K)*VLNO3(L,NY,NX)
     2,RVMX2(N,K,L,NY,NX)/RNO2Y(L,NY,NX))
      ELSE
      FNO2=AMAX1(1.0E-03,FOMN(N,K)*VLNO3(L,NY,NX))
      ENDIF
      IF(RN2BY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNB2=AMAX1(1.0E-03*FOMN(N,K)*VLNOB(L,NY,NX)
     2,RVMB2(N,K,L,NY,NX)/RN2BY(L,NY,NX))
      ELSE
      FNB2=AMAX1(1.0E-03,FOMN(N,K)*VLNOB(L,NY,NX))
      ENDIF
      TFNO2X=TFNO2X+FNO2
      TFNO2B=TFNO2B+FNB2
C
C     NO2 REDUCTION FROM SPECIFIC REDUCTION RATE, ENERGY YIELD,
C     ACTIVE NITRIFIER BIOMASS, TEMPERATURE, AQUEOUS NO2 AND CO2
C     CONCENTRATIONS AND STOICHIOMETRY OF REDOX ELECTRON TRANSFER
C     NOT ACCEPTED BY O2
C
      ROXYD=AMAX1(0.0,ROXYM(N,K)-ROXYO(N,K))
      VMXDX=EDNA*0.875*ROXYD*XCO2
      IF(VOLX(L,NY,NX).GT.ZEROS(NY,NX))THEN
      VMXDA=VMXDX/(1.0+VMKI*ROXYD/VOLX(L,NY,NX))
      ELSE
      VMXDA=0.0
      ENDIF
      VMXDS=VMXDA*CNO2S(L,NY,NX)/(Z2KM+CNO2S(L,NY,NX))*VLNO3(L,NY,NX)
      VMXDB=VMXDA*CNO2B(L,NY,NX)/(Z2KM+CNO2B(L,NY,NX))*VLNOB(L,NY,NX)
      RDNO2(N,K)=AMAX1(0.0,AMIN1(ZNO2S(L,NY,NX)*FNO2,VMXDS))
      RDN2B(N,K)=AMAX1(0.0,AMIN1(ZNO2B(L,NY,NX)*FNB2,VMXDB))
      RDNOT=RDNO2(N,K)+RDN2B(N,K)
      RGOMY(N,K)=0.0
      RGOMD(N,K)=RDNOT*ECNO*ENOX
      RDNO3(N,K)=0.0
      RDNOB(N,K)=0.0
      RDN2O(N,K)=0.0
      RVMX2(N,K,L,NY,NX)=VMXDS 
      RVMB2(N,K,L,NY,NX)=VMXDB
      RVOXA(N)=RVOXA(N)+0.333*RDNO2(N,K)
      RVOXB(N)=RVOXB(N)+0.333*RDN2B(N,K)
C     IF(L.LE.2.AND.I.EQ.170)THEN
C     WRITE(*,7777)'AUTO',I,J,L,K,N,RDNO2(N,K),RDN2B(N,K)
C    2,CNO2S(L,NY,NX),CNO2B(L,NY,NX),CNO3S(L,NY,NX),CNO3B(L,NY,NX)
C    3,VLNO3(L,NY,NX),VLNOB(L,NY,NX),ZNO2S(L,NY,NX),ZNO2B(L,NY,NX)
C    3,XCO2,FNO2,VMXD,VMXDS,VMXDB,TFNG,OMA(N,K),COMN,FCN2S,FCN2B
C    2,ROXYP(N,K),ROXYM(N,K),ROXYO(N,K),FOXYX,DFGS(NPH,L,NY,NX)
C    3,THETW(L,NY,NX),WFN(N,K),COXYS(L,NY,NX),COXYG(L,NY,NX)
C    4,ROXYD,VMXDX,VMXDA 
7777  FORMAT(A8,5I4,40E12.4)
C     ENDIF
      ELSE
      RDNO3(N,K)=0.0
      RDNOB(N,K)=0.0
      RDNO2(N,K)=0.0
      RDN2B(N,K)=0.0
      RDN2O(N,K)=0.0
      RGOMY(N,K)=0.0
      RGOMD(N,K)=0.0
      ENDIF
C
C     BIOMASS DECOMPOSITION AND MINERALIZATION
C
C
C     MINERALIZATION-IMMOBILIZATION OF NH4 IN SOIL FROM MICROBIAL
C     C:N AND NH4 CONCENTRATION IN BAND AND NON-BAND SOIL ZONES
C
      RINHP=(OMC(3,N,K,L,NY,NX)*CNOMC(3)-OMN(3,N,K,L,NY,NX))
      IF(RINHP.GT.0.0)THEN
      CNH4X=AMAX1(0.0,CNH4S(L,NY,NX)-Z4MN)
      CNH4Y=AMAX1(0.0,CNH4B(L,NY,NX)-Z4MN)
      RINHX=AMIN1(RINHP,BIOA*OMA(N,K)*TFNG*Z4MX) 
      RINHO(N,K,L,NY,NX)=VLNH4(L,NY,NX)*RINHX*CNH4X/(CNH4X+Z4KU)
      RINHB(N,K,L,NY,NX)=VLNHB(L,NY,NX)*RINHX*CNH4Y/(CNH4Y+Z4KU)
      ZNH4M=Z4MN*VOLW(L,NY,NX)*VLNH4(L,NY,NX)
      ZNHBM=Z4MN*VOLW(L,NY,NX)*VLNHB(L,NY,NX)
      RINH4(N,K)=AMIN1(FNH4X*AMAX1(0.0,(ZNH4S(L,NY,NX)-ZNH4M))
     2,RINHO(N,K,L,NY,NX)) 
      RINB4(N,K)=AMIN1(FNB4X*AMAX1(0.0,(ZNH4B(L,NY,NX)-ZNHBM))
     2,RINHB(N,K,L,NY,NX))
      ELSE
      RINHO(N,K,L,NY,NX)=0.0
      RINHB(N,K,L,NY,NX)=0.0
      RINH4(N,K)=RINHP*VLNH4(L,NY,NX)
      RINB4(N,K)=RINHP*VLNHB(L,NY,NX)
      ENDIF
C     IF(M.EQ.1.AND.K.EQ.1.AND.N.EQ.1)THEN
C     WRITE(*,7776)'RINH4',I,J,L,K,N,M,RINH4(N,K),RINHP
C    1,BIOA*OMA(N,K)*Z4MX*TFNG,BIOA,OMA(N,K),Z4MX,TFNG 
C    2,OMC(M,N,K,L,NY,NX),CNOMC(3),OMN(M,N,K,L,NY,NX)
C    3,RINHO(N,K,L,NY,NX),FRNH4,CNH4S(L,NY,NX),FNH4X(M)
C    4,ZNH4T(L),OQN(K,L,NY,NX)
7776  FORMAT(A8,6I4,30E12.4)
C     ENDIF
C
C     MINERALIZATION-IMMOBILIZATION OF NO3 IN SOIL FROM MICROBIAL
C     C:N AND NO3 CONCENTRATION IN BAND AND NON-BAND SOIL ZONES
C
      RINOP=AMAX1(0.0,RINHP-RINH4(N,K)-RINB4(N,K))
      IF(RINOP.GT.0.0)THEN
      CNO3X=AMAX1(0.0,CNO3S(L,NY,NX)-ZOMN)
      CNO3Y=AMAX1(0.0,CNO3B(L,NY,NX)-ZOMN)
      RINOX=AMIN1(RINOP,BIOA*OMA(N,K)*TFNG*ZOMX)
      RINOO(N,K,L,NY,NX)=VLNO3(L,NY,NX)*RINOX*CNO3X/(CNO3X+ZOKU)
      RINOB(N,K,L,NY,NX)=VLNOB(L,NY,NX)*RINOX*CNO3Y/(CNO3Y+ZOKU)
      ZNO3M=ZOMN*VOLW(L,NY,NX)*VLNO3(L,NY,NX)
      ZNOBM=ZOMN*VOLW(L,NY,NX)*VLNOB(L,NY,NX)
      RINO3(N,K)=AMIN1(FNO3X*AMAX1(0.0,(ZNO3S(L,NY,NX)-ZNO3M))
     2,RINOO(N,K,L,NY,NX)) 
      RINB3(N,K)=AMIN1(FNB3X*AMAX1(0.0,(ZNO3B(L,NY,NX)-ZNOBM))
     2,RINOB(N,K,L,NY,NX)) 
      ELSE
      RINOO(N,K,L,NY,NX)=0.0
      RINOB(N,K,L,NY,NX)=0.0
      RINO3(N,K)=RINOP*VLNO3(L,NY,NX)
      RINB3(N,K)=RINOP*VLNOB(L,NY,NX)
      ENDIF
C
C     MINERALIZATION-IMMOBILIZATION OF PO4 IN SOIL FROM MICROBIAL
C     C:P AND PO4 CONCENTRATION IN BAND AND NON-BAND SOIL ZONES
C
      RIPOP=(OMC(3,N,K,L,NY,NX)*CPOMC(3)-OMP(3,N,K,L,NY,NX))
      IF(RIPOP.GT.0.0)THEN
      CH2PX=AMAX1(0.0,CH2P4(L,NY,NX)-HPMN)
      CH2PY=AMAX1(0.0,CH2PB(L,NY,NX)-HPMN)
      RIPOX=AMIN1(RIPOP,BIOA*OMA(N,K)*TFNG*HPMX)
      RIPOO(N,K,L,NY,NX)=VLPO4(L,NY,NX)*RIPOX*CH2PX/(CH2PX+HPKU) 
      RIPOB(N,K,L,NY,NX)=VLPOB(L,NY,NX)*RIPOX*CH2PY/(CH2PY+HPKU) 
      H2POM=HPMN*VOLW(L,NY,NX)*VLPO4(L,NY,NX)
      H2PBM=HPMN*VOLW(L,NY,NX)*VLPOB(L,NY,NX)
      RIPO4(N,K)=AMIN1(FPO4X*AMAX1(0.0,(H2PO4(L,NY,NX)-H2POM))
     2,RIPOO(N,K,L,NY,NX)) 
      RIPB4(N,K)=AMIN1(FPB4X*AMAX1(0.0,(H2POB(L,NY,NX)-H2PBM))
     2,RIPOB(N,K,L,NY,NX)) 
      ELSE
      RIPOO(N,K,L,NY,NX)=0.0
      RIPOB(N,K,L,NY,NX)=0.0
      RIPO4(N,K)=RIPOP*VLPO4(L,NY,NX)
      RIPB4(N,K)=RIPOP*VLPOB(L,NY,NX)
      ENDIF
C     IF(NY.EQ.5.AND.L.EQ.10.AND.K.EQ.3.AND.N.EQ.2)THEN
C     WRITE(*,4322)'RIPO4',I,J,NX,NY,L,K,N,RIPO4(N,K),FPO4X,H2P4T(L)
C    2,RIPOO(N,K,L,NY,NX),RIPOP,BIOA,OMA(N,K),TFNG,HPMX,WFN(N,K) 
C    2,VLPO4(L,NY,NX),CH2PX,HPKU,VLPOB(L,NY,NX),CH2PY
C    3,OMC(3,N,K,L,NY,NX),CPOMC(3),OMP(3,N,K,L,NY,NX),WFNG 
4322  FORMAT(A8,7I4,30E12.4)
C     ENDIF
C
C     MINERALIZATION-IMMOBILIZATION OF NH4 IN SURFACE RESIDUE FROM
C     MICROBIAL C:N AND NH4 CONCENTRATION IN BAND AND NON-BAND SOIL
C     ZONES OF SOIL SURFACE
C
      IF(L.EQ.0)THEN
      RINHPR=RINHP-RINH4(N,K)-RINO3(N,K)
      IF(RINHPR.GT.0.0)THEN
      CNH4X=AMAX1(0.0,CNH4S(NU(NY,NX),NY,NX)-Z4MN)
      CNH4Y=AMAX1(0.0,CNH4B(NU(NY,NX),NY,NX)-Z4MN)
      RINHOR(N,K,NY,NX)=AMIN1(RINHPR,BIOA*OMA(N,K)*TFNG*Z4MX) 
     2*(VLNH4(L,NY,NX)*CNH4X/(CNH4X+Z4KU)+VLNHB(L,NY,NX)*CNH4Y
     3/(CNH4Y+Z4KU)) 
      ZNH4M=Z4MN*VOLW(NU(NY,NX),NY,NX) 
      RINH4R(N,K)=AMIN1(FNH4XR(N,K)*AMAX1(0.0,(ZNH4T(NU(NY,NX))-ZNH4M))
     2,RINHOR(N,K,NY,NX))
      ELSE
      RINHOR(N,K,NY,NX)=0.0
      RINH4R(N,K)=RINHPR
      ENDIF
C     IF(K.EQ.2.AND.N.EQ.1)THEN
C     WRITE(*,7778)'RINH4R',I,J,L,K,N,M,RINH4R(N,K),RINHPR
C    2,BIOA*OMA(N,K)*Z4MX,RINHP,RINH4(N,K),RINO3(N,K) 
C    3,RINHOR(N,K,NY,NX),FRNH4,CNH4S(NU(NY,NX),NY,NX),FNH4XR(M,N,K)
C    4,ZNH4T(NU(NY,NX))
7778  FORMAT(A8,6I4,20E12.4)
C     ENDIF
C
C     MINERALIZATION-IMMOBILIZATION OF NO3 IN SURFACE RESIDUE FROM
C     MICROBIAL C:N AND NO3 CONCENTRATION IN BAND AND NON-BAND SOIL
C     ZONES OF SOIL SURFACE
C
      RINOPR=AMAX1(0.0,RINHPR-RINH4R(N,K))
      IF(RINOPR.GT.0.0)THEN
      CNO3X=AMAX1(0.0,CNO3S(NU(NY,NX),NY,NX)-ZOMN)
      CNO3Y=AMAX1(0.0,CNO3B(NU(NY,NX),NY,NX)-ZOMN)
      RINOOR(N,K,NY,NX)=AMAX1(RINOPR,BIOA*OMA(N,K)*TFNG*ZOMX) 
     2*(VLNO3(L,NY,NX)*CNO3X/(CNO3X+ZOKU)+VLNOB(L,NY,NX)*CNO3Y
     3/(CNO3Y+ZOKU)) 
      ZNO3M=ZOMN*VOLW(NU(NY,NX),NY,NX) 
      RINO3R(N,K)=AMIN1(FNO3XR(N,K)*AMAX1(0.0,(ZNO3T(NU(NY,NX))-ZNO3M))
     2,RINOOR(N,K,NY,NX))
      ELSE
      RINOOR(N,K,NY,NX)=0.0
      RINO3R(N,K)=RINOPR
      ENDIF
C
C     MINERALIZATION-IMMOBILIZATION OF PO4 IN SURFACE RESIDUE FROM
C     MICROBIAL C:P AND PO4 CONCENTRATION IN BAND AND NON-BAND SOIL
C     ZONES OF SOIL SURFACE
C
      RIPOPR=RIPOP-RIPO4(N,K)
      IF(RIPOPR.GT.0.0)THEN
      CH2PX=AMAX1(0.0,CH2P4(NU(NY,NX),NY,NX)-HPMN)
      CH2PY=AMAX1(0.0,CH2PB(NU(NY,NX),NY,NX)-HPMN)
      RIPOOR(N,K,NY,NX)=AMIN1(RIPOPR,BIOA*OMA(N,K)*TFNG*HPMX) 
     2*(VLPO4(L,NY,NX)*CH2PX/(CH2PX+HPKU)+VLPOB(L,NY,NX)*CH2PY
     3/(CH2PY+HPKU)) 
      H2P4M=HPMN*VOLW(NU(NY,NX),NY,NX) 
      RIPO4R(N,K)=AMIN1(FPO4XR(N,K)*AMAX1(0.0,(H2P4T(NU(NY,NX))-H2P4M))
     2,RIPOOR(N,K,NY,NX))
      ELSE
      RIPOOR(N,K,NY,NX)=0.0
      RIPO4R(N,K)=RIPOPR
      ENDIF
      ENDIF
C
C     pH EFFECT ON MAINTENANCE RESPIRATION
C
      FPH=1.0+AMAX1(0.0,0.25*(6.5-PH(L,NY,NX)))
      RMOMC(1,N,K)=OMN(1,N,K,L,NY,NX)*RMOM*TFNR*FPH 
      RMOMC(2,N,K)=OMN2(N,K)*RMOM*TFNR*FPH
C
C     MICROBIAL MAINTENANCE AND GROWTH RESPIRATION
C
      RMOMT=RMOMC(1,N,K)+RMOMC(2,N,K)
      RGOMT=AMAX1(0.0,RGOMO(N,K)-RMOMT)
      RXOMT=AMAX1(0.0,RMOMT-RGOMO(N,K))
C
C     N2 FIXATION: N=(6) AEROBIC, (7) ANAEROBIC
C     FROM GROWTH RESPIRATION, FIXATION ENERGY REQUIREMENT,
C     MICROBIAL N REQUIREMENT IN LABILE (1) AND RESISTANT (2) FRACTIONS
C
      IF(K.LE.4.AND.(N.EQ.6.OR.N.EQ.7))THEN
      RGN2P=AMAX1(0.0,OMC(3,N,K,L,NY,NX)*CNOMC(3)
     2-OMN(3,N,K,L,NY,NX))/EN2F(N)
      RGN2F=AMIN1(RGN2P,RGOMT)
     2*CZ2GS(L,NY,NX)/(CZ2GS(L,NY,NX)+ZFKM)
      RN2FX(N,K)=RGN2F*EN2F(N) 
C     IF((I/30)*30.EQ.I.AND.J.EQ.12)THEN
C     WRITE(*,5566)'N2 FIX',I,J,L,K,N,RN2FX(N,K),EN2F(N) 
C    2,OMC(3,N,K,L,NY,NX)*CNOMC(3),OMN(3,N,K,L,NY,NX)
C    3,RINH4(N,K),RINO3(N,K),RGN2P,RGN2F,FNFX,RGOMT 
5566  FORMAT(A8,5I4,30E12.4)
C     ENDIF
      ELSE
      RN2FX(N,K)=0.0
      RGN2F=0.0
      ENDIF
C
C     DOC, DON, DOP AND ACETATE UPTAKE DRIVEN BY GROWTH RESPIRATION
C     FROM O2, NOX AND C REDUCTION
C
      CGOMX=AMIN1(RMOMT,RGOMO(N,K))+RGN2F+(RGOMT-RGN2F)/ECHZ
      CGOMD=RGOMD(N,K)/ENOX
      CGOMC(N,K)=CGOMX+CGOMD
      IF(K.LE.4)THEN
      CGOQC(N,K)=CGOMX*FGOCP+CGOMD
      CGOAC(N,K)=CGOMX*FGOAP
      CGOXC=CGOQC(N,K)+CGOAC(N,K)
      CGOMN(N,K)=AMAX1(0.0,AMIN1(OQN(K,L,NY,NX)*FOMK(N,K)
     2,CGOXC*CNQ(K)/FCN(N,K)))
      CGOMP(N,K)=AMAX1(0.0,AMIN1(OQP(K,L,NY,NX)*FOMK(N,K)
     2,CGOXC*CPQ(K)/FCP(N,K)))
      ELSE
      CGOQC(N,K)=CGOMX+CGOMD
      CGOAC(N,K)=0.0
      CGOMN(N,K)=0.0
      CGOMP(N,K)=0.0
      ENDIF
C     IF(J.EQ.16.AND.L.EQ.1)THEN
C     WRITE(*,5557)'CGOQC',I,J,L,K,N,CGOQC(N,K),CGOMX 
C    2,CGOMD,RMOMT,RGN2F,RGN2F,ECHZ 
C    3,RGOMD(N,K),ENOX,RGOMO(N,K),WFN(N,K),FOXYX
5557  FORMAT(A8,5I4,20E12.4)
C     ENDIF
C
C     TRANSFER UPTAKEN C,N,P FROM STORAGE TO ACTIVE BIOMASS
C
      IF(OMC(3,N,K,L,NY,NX).GT.ZEROS(NY,NX))THEN
      CCC=AMIN1(OMN(3,N,K,L,NY,NX)/(OMN(3,N,K,L,NY,NX)
     2+OMC(3,N,K,L,NY,NX)/CNKI)
     3,OMP(3,N,K,L,NY,NX)/(OMP(3,N,K,L,NY,NX)
     4+OMC(3,N,K,L,NY,NX)/CPKI))
      CNC=OMC(3,N,K,L,NY,NX)/(OMC(3,N,K,L,NY,NX)
     2+OMN(3,N,K,L,NY,NX)/ZSKI)
      CPC=OMC(3,N,K,L,NY,NX)/(OMC(3,N,K,L,NY,NX)
     2+OMP(3,N,K,L,NY,NX)/PSKI)
      RCCC=RCCZ+CCC*RCCY*(1.0-FSBST(N,K))
      RCCN=CNC*RCCX
      RCCP=CPC*RCCQ
      ELSE
      RCCC=RCCZ
      RCCN=0.0
      RCCP=0.0
      ENDIF
      CGOMZ=TFNG*OMGR*AMAX1(0.0,OMC(3,N,K,L,NY,NX)) 
      DO 745 M=1,2
      CGOMS(M,N,K)=FL(M)*CGOMZ 
      IF(OMC(3,N,K,L,NY,NX).GT.ZEROS(NY,NX))THEN
      CGONS(M,N,K)=AMIN1(FL(M)*AMAX1(0.0,OMN(3,N,K,L,NY,NX))
     2,CGOMS(M,N,K)*OMN(3,N,K,L,NY,NX)/OMC(3,N,K,L,NY,NX))
      CGOPS(M,N,K)=AMIN1(FL(M)*AMAX1(0.0,OMP(3,N,K,L,NY,NX))
     2,CGOMS(M,N,K)*OMP(3,N,K,L,NY,NX)/OMC(3,N,K,L,NY,NX))
      ELSE
      CGONS(M,N,K)=0.0
      CGOPS(M,N,K)=0.0
      ENDIF 
C
C     MICROBIAL DECOMPOSITION FROM BIOMASS, SPECIFIC DECOMPOSITION
C     RATE, TEMPERATURE
C
      SPOMX=SQRT(TFNG)*SPOMC(M)*SPOMC2 
      RXOMC(M,N,K)=AMAX1(0.0,OMC(M,N,K,L,NY,NX)*SPOMX)
      RXOMN(M,N,K)=AMAX1(0.0,OMN(M,N,K,L,NY,NX)*SPOMX)
      RXOMP(M,N,K)=AMAX1(0.0,OMP(M,N,K,L,NY,NX)*SPOMX)
      RDOMC(M,N,K)=RXOMC(M,N,K)*(1.0-RCCC)
      RDOMN(M,N,K)=RXOMN(M,N,K)*(1.0-RCCN)
      RDOMP(M,N,K)=RXOMP(M,N,K)*(1.0-RCCP)
      R3OMC(M,N,K)=RXOMC(M,N,K)*RCCC
      R3OMN(M,N,K)=RXOMN(M,N,K)*RCCN
      R3OMP(M,N,K)=RXOMP(M,N,K)*RCCP
C
C     HUMIFICATION OF MICROBIAL DECOMPOSITION PRODUCTS FROM
C     DECOMPOSITION RATE, SOIL CLAY AND OC CONTENT 'EHUM' FROM 'HOUR1'
C
      IF(RDOMC(M,N,K).GT.ZEROS(NY,NX))THEN
      CNSHX=RDOMN(M,N,K)/RDOMC(M,N,K)
      CPSHX=RDOMP(M,N,K)/RDOMC(M,N,K)
      ELSE
      CNSHX=CNRH(4)
      CPSHX=CPRH(4)
      ENDIF
      IF(L.NE.0)THEN
      LL=L
      ELSE
      LL=NU(NY,NX)
      ENDIF
      IF(OSC(1,4,LL,NY,NX).GT.ZEROS(NY,NX))THEN
      CNSHY1=OSN(1,4,LL,NY,NX)/OSC(1,4,LL,NY,NX)
      CPSHY1=OSP(1,4,LL,NY,NX)/OSC(1,4,LL,NY,NX)
      ELSE
      CNSHY1=CNRH(4)
      CPSHY1=CPRH(4)
      ENDIF
      IF(OSC(2,4,LL,NY,NX).GT.ZEROS(NY,NX))THEN
      CNSHY2=OSN(2,4,LL,NY,NX)/OSC(2,4,LL,NY,NX)
      CPSHY2=OSP(2,4,LL,NY,NX)/OSC(2,4,LL,NY,NX)
      ELSE
      CNSHY2=CNRH(4)
      CPSHY2=CPRH(4)
      ENDIF
      CNSHY=CNSHY1*CFOMC(1,LL,NY,NX)+CNSHY2*CFOMC(2,LL,NY,NX)
      CPSHY=CPSHY1*CFOMC(1,LL,NY,NX)+CPSHY2*CFOMC(2,LL,NY,NX)
      CNSHZ=0.125*CNRH(4)+0.125*CNSHX+0.750*CNSHY
      CPSHZ=0.125*CPRH(4)+0.125*CPSHX+0.750*CPSHY
      RHOMC(M,N,K)=AMIN1(RDOMC(M,N,K)
     2,RDOMN(M,N,K)/CNSHZ,RDOMP(M,N,K)/CPSHZ)*EHUM(L,NY,NX)
      RHOMN(M,N,K)=AMIN1(RDOMN(M,N,K)*EHUM(L,NY,NX)
     2,RHOMC(M,N,K)*CNSHZ)
      RHOMP(M,N,K)=AMIN1(RDOMP(M,N,K)*EHUM(L,NY,NX)
     2,RHOMC(M,N,K)*CPSHZ)
C
C     NON-HUMIFIED PRODUCTS TO MICROBIAL RESIDUE
C
      RCOMC(M,N,K)=RDOMC(M,N,K)-RHOMC(M,N,K)
      RCOMN(M,N,K)=RDOMN(M,N,K)-RHOMN(M,N,K)
      RCOMP(M,N,K)=RDOMP(M,N,K)-RHOMP(M,N,K)
745   CONTINUE
C
C     MICROBIAL DECOMPOSITION WHEN MAINTENANCE RESPIRATION
C     EXCEEDS UPTAKE
C
      IF(RXOMT.GT.ZEROS(NY,NX).AND.RMOMT.GT.ZEROS(NY,NX)
     2.AND.RCCC.GT.ZERO)THEN
      FRM=RXOMT/RMOMT
      DO 730 M=1,2
      RXMMC(M,N,K)=AMIN1(OMC(M,N,K,L,NY,NX),FRM*RMOMC(M,N,K)/RCCC)
      RXMMN(M,N,K)=AMAX1(0.0,RXMMC(M,N,K)*CNOMA(N,K)) 
      RXMMP(M,N,K)=AMAX1(0.0,RXMMC(M,N,K)*CPOMA(N,K))
      RDMMC(M,N,K)=RXMMC(M,N,K)*(1.0-RCCC)
      RDMMN(M,N,K)=RXMMN(M,N,K)*(1.0-RCCN)
      RDMMP(M,N,K)=RXMMP(M,N,K)*(1.0-RCCP)
      R3MMC(M,N,K)=RXMMC(M,N,K)*RCCC
      R3MMN(M,N,K)=RXMMN(M,N,K)*RCCN
      R3MMP(M,N,K)=RXMMP(M,N,K)*RCCP
C
C     HUMIFICATION AND RECYCLING OF RESPIRATION DECOMPOSITION
C     PRODUCTS
C
      IF(RDMMC(M,N,K).GT.ZEROS(NY,NX))THEN
      CNSHX=RDMMN(M,N,K)/RDMMC(M,N,K)
      CPSHX=RDMMP(M,N,K)/RDMMC(M,N,K)
      ELSE
      CNSHX=CNRH(4)
      CPSHX=CPRH(4)
      ENDIF
      CNSHZ=0.125*CNRH(4)+0.125*CNSHX+0.750*CNSHY
      CPSHZ=0.125*CPRH(4)+0.125*CPSHX+0.750*CPSHY
      RHMMC(M,N,K)=AMIN1(RDMMC(M,N,K)
     2,RDMMN(M,N,K)/CNSHZ,RDMMP(M,N,K)/CPSHZ)*EHUM(L,NY,NX)
      RHMMN(M,N,K)=AMIN1(RDMMN(M,N,K)*EHUM(L,NY,NX)
     2,RHMMC(M,N,K)*CNSHZ)
      RHMMP(M,N,K)=AMIN1(RDMMP(M,N,K)*EHUM(L,NY,NX)
     2,RHMMC(M,N,K)*CPSHZ)
      RCMMC(M,N,K)=RDMMC(M,N,K)-RHMMC(M,N,K)
      RCMMN(M,N,K)=RDMMN(M,N,K)-RHMMN(M,N,K)
      RCMMP(M,N,K)=RDMMP(M,N,K)-RHMMP(M,N,K)
C     IF(L.EQ.0)THEN
C     WRITE(*,8821)'RCMMC',I,J,L,K,N,M,RCMMC(M,N,K)
C    2,RDMMC(M,N,K),RHMMC(M,N,K),OMC(M,N,K,L,NY,NX)
C    3,FRM,RMOMC(M,N,K),OMN(1,N,K,L,NY,NX),OMN2(N,K)
C    4,RMOM,TFNR,FPH,RDMMN(M,N,K),CNSHZ,RDMMP(M,N,K)
C    5,CPSHZ,EHUM(L,NY,NX),RXOMT,RMOMT,RMOMT,RGOMO(N,K)
C    6,RGOMP,WFN(N,K)
C     ENDIF
730   CONTINUE
      ELSE
      DO 720 M=1,2
      RXMMC(M,N,K)=0.0
      RXMMN(M,N,K)=0.0
      RXMMP(M,N,K)=0.0
      RDMMC(M,N,K)=0.0
      RDMMN(M,N,K)=0.0
      RDMMP(M,N,K)=0.0
      R3MMC(M,N,K)=0.0
      R3MMN(M,N,K)=0.0
      R3MMP(M,N,K)=0.0
      RHMMC(M,N,K)=0.0
      RHMMN(M,N,K)=0.0
      RHMMP(M,N,K)=0.0
      RCMMC(M,N,K)=0.0
      RCMMN(M,N,K)=0.0
      RCMMP(M,N,K)=0.0
720   CONTINUE
      ENDIF
      ELSE
      RUPOX(N,K)=0.0
      RGOMO(N,K)=0.0
      RCO2X(N,K)=0.0
      RCH3X(N,K)=0.0
      RCH4X(N,K)=0.0
      RGOMY(N,K)=0.0
      RGOMD(N,K)=0.0
      CGOMC(N,K)=0.0
      CGOMN(N,K)=0.0
      CGOMP(N,K)=0.0
      CGOQC(N,K)=0.0
      CGOAC(N,K)=0.0
      RDNO3(N,K)=0.0
      RDNOB(N,K)=0.0
      RDNO2(N,K)=0.0
      RDN2B(N,K)=0.0
      RDN2O(N,K)=0.0
      RN2FX(N,K)=0.0
      RINH4(N,K)=0.0
      RINO3(N,K)=0.0
      RIPO4(N,K)=0.0
      RINB4(N,K)=0.0
      RINB3(N,K)=0.0
      RIPB4(N,K)=0.0
      IF(L.EQ.0)THEN
      RINH4R(N,K)=0.0
      RINO3R(N,K)=0.0
      RIPO4R(N,K)=0.0
      FNH4XR(N,K)=0.0
      FNO3XR(N,K)=0.0
      FPO4XR(N,K)=0.0
      ENDIF
      DO 725 M=1,2
      CGOMS(M,N,K)=0.0
      CGONS(M,N,K)=0.0
      CGOPS(M,N,K)=0.0
      RMOMC(M,N,K)=0.0
      RXMMC(M,N,K)=0.0
      RXMMN(M,N,K)=0.0
      RXMMP(M,N,K)=0.0
      RDMMC(M,N,K)=0.0
      RDMMN(M,N,K)=0.0
      RDMMP(M,N,K)=0.0
      R3MMC(M,N,K)=0.0
      R3MMN(M,N,K)=0.0
      R3MMP(M,N,K)=0.0
      RHMMC(M,N,K)=0.0
      RHMMN(M,N,K)=0.0
      RHMMP(M,N,K)=0.0
      RCMMC(M,N,K)=0.0
      RCMMN(M,N,K)=0.0
      RCMMP(M,N,K)=0.0
      RXOMC(M,N,K)=0.0
      RXOMN(M,N,K)=0.0
      RXOMP(M,N,K)=0.0
      RDOMC(M,N,K)=0.0
      RDOMN(M,N,K)=0.0
      RDOMP(M,N,K)=0.0
      R3OMC(M,N,K)=0.0
      R3OMN(M,N,K)=0.0
      R3OMP(M,N,K)=0.0
      RHOMC(M,N,K)=0.0
      RHOMN(M,N,K)=0.0
      RHOMP(M,N,K)=0.0
      RCOMC(M,N,K)=0.0
      RCOMN(M,N,K)=0.0
      RCOMP(M,N,K)=0.0
725   CONTINUE
      RH2GX(N,K)=0.0
      IF(K.EQ.5)THEN
      RVOXA(N)=0.0
      RVOXB(N)=0.0
      IF(N.EQ.5)THEN
      RH2GZ=0.0
      ENDIF
      ENDIF
      ENDIF
      ENDIF
750   CONTINUE
      ENDIF
760   CONTINUE
C
C     CHEMODENITRIFICATION
C
      IF(RNO2Y(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNO2=AMAX1(1.0E-03*VLNO3(L,NY,NX),RVMXC(L,NY,NX)/RNO2Y(L,NY,NX))
      ELSE
      FNO2=1.0E-03
      ENDIF
      IF(RN2BY(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FNB2=AMAX1(1.0E-03*VLNOB(L,NY,NX),RVMBC(L,NY,NX)/RN2BY(L,NY,NX))
      ELSE
      FNB2=1.0E-03
      ENDIF
      TFNO2X=TFNO2X+FNO2
      TFNO2B=TFNO2B+FNB2
      VMXDS=7.5E-02*CHNO2*VOLWM(NPH,L,NY,NX)*TFNG*VLNO3(L,NY,NX)
      VMXDB=7.5E-02*CHNOB*VOLWM(NPH,L,NY,NX)*TFNG*VLNOB(L,NY,NX)
      RCNO2=AMAX1(0.0,AMIN1(ZNO2S(L,NY,NX)*FNO2,VMXDS))
      RCNOB=AMAX1(0.0,AMIN1(ZNO2B(L,NY,NX)*FNB2,VMXDB))
      RCN2O=0.10*RCNO2
      RCN2B=0.10*RCNOB
      RCNO3=0.80*RCNO2
      RCN3B=0.80*RCNOB
      RCOQN=0.10*(RCNO2+RCNOB)
      RVMXC(L,NY,NX)=VMXDS 
      RVMBC(L,NY,NX)=VMXDB 
C     IF(L.EQ.0)THEN
C     WRITE(*,7779)'CHEMO',I,J,L,RCNO2,RCNOB,CHY1,CHNO2,CHNOB
C    2,CNO2S(L,NY,NX),CNO2B(L,NY,NX),VOLWM(NPH,L,NY,NX),FNO2 
C    3,VMXDS,VMXDB,RVMXC(L,NY,NX),RNO2Y(L,NY,NX),RCN2O,RCN2B,RCNO3
C    4,RCNOB,RCOQN,VLNO3(L,NY,NX),VLNOB(L,NY,NX) 
7779  FORMAT(A8,3I4,30E12.4)
C     ENDIF
C
C     DECOMPOSITION    
C
      DO 1870 K=0,KL
      ZOMA(K)=TOMK(K)
      ZONA(K)=TONK(K)/FL(1)
      ZOPA(K)=TOPK(K)/FL(1)
      IF(TOCK(K).GT.ZEROS(NY,NX))THEN
      CNOMK(K)=AMIN1(CNOMC(1),TONK(K)/TOCK(K))
      CPOMK(K)=AMIN1(CPOMC(1),TOPK(K)/TOCK(K))
      ELSE
      CNOMK(K)=CNOMC(1) 
      CPOMK(K)=CPOMC(1) 
      ENDIF
      XOMA(K)=0.0
      XONA(K)=0.0
      XOPA(K)=0.0
1870  CONTINUE
C
C     PRIMING BETWEEN LITTER AND NON-LITTER C
C
      DO 795 K=0,KL
      IF(K.LE.KL-1)THEN
      DO 800 KK=K+1,KL
      IF(OSRH(KK).GT.ZEROS(NY,NX))THEN
      XFRC=0.375*TFND(L,NY,NX)*(TOMK(K)*OSRH(KK)-TOMK(KK)*OSRH(K))
     2/(OSRH(K)+OSRH(KK))
      IF(XFRC.GT.0.0)THEN
      XFRN=XFRC*CNOMK(K)
      XFRP=XFRC*CPOMK(K)
      ELSE
      XFRN=XFRC*CNOMK(KK)
      XFRP=XFRC*CPOMK(KK)
      ENDIF 
      XOMA(KK)=XOMA(KK)+XFRC
      XOMA(K)=XOMA(K)-XFRC
      XONA(KK)=XONA(KK)+XFRN
      XONA(K)=XONA(K)-XFRN
      XOPA(KK)=XOPA(KK)+XFRP
      XOPA(K)=XOPA(K)-XFRP
      ENDIF
800   CONTINUE
      ENDIF
795   CONTINUE
C
C     DECOMPOSITION OF ORGANIC SUBSTRATES
C
      DO 1790 K=0,KL
      ZOMA(K)=ZOMA(K)+XOMA(K)
      ZONA(K)=ZONA(K)+XONA(K)
      ZOPA(K)=ZOPA(K)+XOPA(K)
      IF(ZOMA(K).GT.ZEROS(NY,NX))THEN
      CNOMX=ZONA(K)/ZOMA(K)
      CPOMX=ZOPA(K)/ZOMA(K)
      FCNK(K)=AMIN1(1.0,AMAX1(0.25,CNOMX/CNOMC(1)))
      FCPK(K)=AMIN1(1.0,AMAX1(0.25,CPOMX/CPOMC(1)))
      ELSE
      FCNK(K)=1.0
      FCPK(K)=1.0
      ENDIF
C
C     AQUEOUS CONCENTRATION OF BIOMASS TO CACULATE INHIBITION
C     CONSTANT FOR DECOMPOSITION
C
      IF(VOLWZ.GT.ZEROS(NY,NX))THEN
      COMA=AMIN1(0.5E+06,ZOMA(K)/VOLWZ)
      ELSE
      COMA=0.5E+06
      ENDIF
      DCKD=DCKM(K)*(1.0+COMA/DCKI)
      IF(OSRH(K).GT.ZEROS(NY,NX))THEN
      COSC=OSRH(K)/VOLX(L,NY,NX) 
      DFNS=COSC/(COSC+DCKD)
      OQCI=1.0/(1.0+COQC(K,L,NY,NX)/OQKI)
C     IF(L.EQ.0)THEN
C     WRITE(*,4242)'COSC',I,J,L,K,DFNS,COSC,COMA,DCKD,OSRH(K)
C    2,OSAT(K),OSCT(K),ORCT(K),OHC(K,L,NY,NX),BKVL(L,NY,NX)
C    3,ZOMA(K),VOLWZ,VOLWRX(NY,NX) 
4242  FORMAT(A8,4I4,20E12.4)
C     ENDIF
C
C     C, N, P DECOMPOSITION RATE OF SOLID SUBSTRATES 'RDOS*' FROM
C     RATE CONSTANT, TOTAL ACTIVE BIOMASS, DENSITY FACTOR,
C     TEMPERATURE, SUBSTRATE C:N, C:P
C
      DO 785 M=1,4
      IF(OSC(M,K,L,NY,NX).GT.ZEROS(NY,NX))THEN
      CNS(M,K)=AMAX1(0.0,OSN(M,K,L,NY,NX)/OSC(M,K,L,NY,NX))
      CPS(M,K)=AMAX1(0.0,OSP(M,K,L,NY,NX)/OSC(M,K,L,NY,NX))
      RDOSC(M,K)=AMAX1(0.0,AMIN1(OSA(M,K,L,NY,NX)
     2,SPOSC(M,K)*ZOMA(K)*DFNS*TFNG*OQCI*OSA(M,K,L,NY,NX)/OSRH(K)))
C    3*AMIN1(FCNK(K),FCPK(K)) 
      RDOSN(M,K)=AMAX1(0.0,AMIN1(OSN(M,K,L,NY,NX)
     2,CNS(M,K)*RDOSC(M,K)))/FCNK(K)
      RDOSP(M,K)=AMAX1(0.0,AMIN1(OSP(M,K,L,NY,NX)
     2,CPS(M,K)*RDOSC(M,K)))/FCPK(K)
      ELSE
      CNS(M,K)=CNOSC(M,K,L,NY,NX)
      CPS(M,K)=CPOSC(M,K,L,NY,NX)
      RDOSC(M,K)=0.0
      RDOSN(M,K)=0.0
      RDOSP(M,K)=0.0
      ENDIF
C     IF((I/10)*10.EQ.I.AND.NX.EQ.3.AND.NY.EQ.1.AND.J.EQ.24)THEN
C     WRITE(*,4444)'RDOSC',I,J,NX,NY,L,K,M,RDOSC(M,K),RDOSN(M,K) 
C    2,RDOSP(M,K),CNS(M,K),CPS(M,K),SPOSC(M,K),ZOMA(K),DFNS,TFNG 
C    3,OQCI,OSA(M,K,L,NY,NX),OSRH(K),COSC,COMA,DCKD,VOLWZ
C    4,TFNX,WFNG,TKS(L,NY,NX),PSISM(L,NY,NX) 
C    4,OSAT(K),OSCT(K),FOSRH(K),VOLX(L,NY,NX),ORGC(L,NY,NX) 
C    2,OSC(M,K,L,NY,NX),OSN(M,K,L,NY,NX),OSP(M,K,L,NY,NX),FCNK(K)
C    6,FCPK(K) 
4444  FORMAT(A8,7I4,40E12.4)
C     ENDIF
785   CONTINUE
C
C     HUMIFICATION OF DECOMPOSED RESIDUE LIGNIN WITH PROTEIN,
C     CH2O AND CELLULOSE 'RHOS*' WITH REMAINDER 'RCOS*' TO DOC,N,P
C
      IF(K.LE.2)THEN
      RHOSC(4,K)=AMAX1(0.0,AMIN1(RDOSN(4,K)/CNRH(3)
     2,RDOSP(4,K)/CPRH(3),EPOC(L,NY,NX)*RDOSC(4,K)))
      RHOSCM=0.10*RHOSC(4,K)
      RHOSC(1,K)=AMAX1(0.0,AMIN1(RDOSC(1,K),RDOSN(1,K)/CNRH(3)
     2,RDOSP(1,K)/CPRH(3),RHOSCM))
      RHOSC(2,K)=AMAX1(0.0,AMIN1(RDOSC(2,K),RDOSN(2,K)/CNRH(3)
     2,RDOSP(2,K)/CPRH(3),RHOSCM))
      RHOSC(3,K)=AMAX1(0.0,AMIN1(RDOSC(3,K),RDOSN(3,K)/CNRH(3)
     2,RDOSP(3,K)/CPRH(3),RHOSCM-RHOSC(2,K)))
      DO 805 M=1,4
      RHOSN(M,K)=AMIN1(RDOSN(M,K),RHOSC(M,K)*CNRH(3))
      RHOSP(M,K)=AMIN1(RDOSP(M,K),RHOSC(M,K)*CPRH(3))
      RCOSC(M,K)=RDOSC(M,K)-RHOSC(M,K)
      RCOSN(M,K)=RDOSN(M,K)-RHOSN(M,K)
      RCOSP(M,K)=RDOSP(M,K)-RHOSP(M,K)
805   CONTINUE
      ELSE
      DO 810 M=1,4
      RHOSC(M,K)=0.0
      RHOSN(M,K)=0.0
      RHOSP(M,K)=0.0
      RCOSC(M,K)=RDOSC(M,K)
      RCOSN(M,K)=RDOSN(M,K)
      RCOSP(M,K)=RDOSP(M,K)
810   CONTINUE
      ENDIF
      ELSE
      DO 780 M=1,4
      RDOSC(M,K)=0.0
      RDOSN(M,K)=0.0
      RDOSP(M,K)=0.0
      RHOSC(M,K)=0.0
      RHOSN(M,K)=0.0
      RHOSP(M,K)=0.0
      RCOSC(M,K)=0.0
      RCOSN(M,K)=0.0
      RCOSP(M,K)=0.0
780   CONTINUE
      ENDIF
C
C     C, N, P DECOMPOSITION RATE OF BIORESIDUE 'RDOR*' FROM
C     RATE CONSTANT, TOTAL ACTIVE BIOMASS, DENSITY FACTOR,
C     TEMPERATURE, SUBSTRATE C:N, C:P
C
      IF(OSRH(K).GT.ZEROS(NY,NX))THEN
      DO 775 M=1,2
      IF(ORC(M,K,L,NY,NX).GT.ZEROS(NY,NX))THEN
      CNR=AMAX1(0.0,ORN(M,K,L,NY,NX)/ORC(M,K,L,NY,NX))
      CPR=AMAX1(0.0,ORP(M,K,L,NY,NX)/ORC(M,K,L,NY,NX))
      RDORC(M,K)=AMAX1(0.0,AMIN1(ORC(M,K,L,NY,NX)
     2,SPORC(M)*ZOMA(K)*DFNS*TFNG*OQCI*ORC(M,K,L,NY,NX)/OSRH(K)))
C    3*AMIN1(FCNK(K),FCPK(K)) 
      RDORN(M,K)=AMAX1(0.0,AMIN1(ORN(M,K,L,NY,NX),CNR*RDORC(M,K)))
     2/FCNK(K)
      RDORP(M,K)=AMAX1(0.0,AMIN1(ORP(M,K,L,NY,NX),CPR*RDORC(M,K)))
     2/FCPK(K) 
      ELSE
      RDORC(M,K)=0.0
      RDORN(M,K)=0.0
      RDORP(M,K)=0.0
      ENDIF
775   CONTINUE
      ELSE
      DO 776 M=1,2
      RDORC(M,K)=0.0
      RDORN(M,K)=0.0
      RDORP(M,K)=0.0
776   CONTINUE
      ENDIF
C
C     C, N, P DECOMPOSITION RATE OF SORBED SUBSTRATES 'RDOH*' FROM
C     RATE CONSTANT, TOTAL ACTIVE BIOMASS, DENSITY FACTOR,
C     TEMPERATURE, SUBSTRATE C:N, C:P
C
      IF(OSRH(K).GT.ZEROS(NY,NX))THEN
      IF(OHC(K,L,NY,NX).GT.ZEROS(NY,NX))THEN 
      CNH(K)=AMAX1(0.0,OHN(K,L,NY,NX)/OHC(K,L,NY,NX))
      CPH(K)=AMAX1(0.0,OHP(K,L,NY,NX)/OHC(K,L,NY,NX))
      RDOHC(K)=AMAX1(0.0,AMIN1(OHC(K,L,NY,NX)
     2,SPOHC*ZOMA(K)*DFNS*TFNG*OQCI*OHC(K,L,NY,NX)/OSRH(K)))
C    3*AMIN1(FCNK(K),FCPK(K)) 
      RDOHN(K)=AMAX1(0.0,AMIN1(OHN(K,L,NY,NX),CNH(K)*RDOHC(K)))
     2/FCNK(K)
      RDOHP(K)=AMAX1(0.0,AMIN1(OHP(K,L,NY,NX),CPH(K)*RDOHC(K)))
     2/FCPK(K)
      RDOHA(K)=AMAX1(0.0,AMIN1(OHA(K,L,NY,NX)
     2,SPOHA*ZOMA(K)*DFNS*TFNG*OHA(K,L,NY,NX)/OSRH(K)))
C    3*AMIN1(FCNK(K),FCPK(K))
      ELSE
      CNH(K)=0.0
      CPH(K)=0.0
      RDOHC(K)=0.0
      RDOHN(K)=0.0
      RDOHP(K)=0.0
      RDOHA(K)=0.0
      ENDIF
      ELSE
      CNH(K)=0.0
      CPH(K)=0.0
      RDOHC(K)=0.0
      RDOHN(K)=0.0
      RDOHP(K)=0.0
      RDOHA(K)=0.0
      ENDIF
C     IF((I/30)*30.EQ.I.AND.J.EQ.15)THEN
C     WRITE(*,2122)'ZOMA',I,J,L,TOMA,(TOMK(K),K=0,KL),(ZOMA(K),K=0,KL)
C    3,(FOSRH(K),K=0,KL),(ZOMA(K)/OSRH(K),K=0,KL),(ZONA(K),K=0,KL)
C    4,(ZOPA(K),K=0,KL),(FCNK(K),K=0,KL),(FCPK(K),K=0,KL)
2122  FORMAT(A8,3I4,60E12.4)
C     ENDIF
C
C     DOC ADSORPTION - DESORPTION
C
      IF(VOLWM(NPH,L,NY,NX).GT.ZEROS(NY,NX).AND.FOSRH(K).GT.ZERO)THEN
      IF(L.EQ.0)THEN
      AECX=50.0
      ELSE
      AECX=AEC(L,NY,NX) 
      ENDIF 
      OQCX=AMAX1(ZEROS(NY,NX),OQC(K,L,NY,NX))
      OQNX=AMAX1(ZEROS(NY,NX),OQN(K,L,NY,NX))
      OQPX=AMAX1(ZEROS(NY,NX),OQP(K,L,NY,NX))
      OQAX=AMAX1(ZEROS(NY,NX),OQA(K,L,NY,NX))
      OHCX=AMAX1(ZEROS(NY,NX),OHC(K,L,NY,NX))
      OHNX=AMAX1(ZEROS(NY,NX),OHN(K,L,NY,NX))
      OHPX=AMAX1(ZEROS(NY,NX),OHP(K,L,NY,NX))
      OHAX=AMAX1(ZEROS(NY,NX),OHA(K,L,NY,NX))
      VOLXX=BKVL(L,NY,NX)*AECX*HSORP*FOSRH(K)
      VOLXW=VOLWM(NPH,L,NY,NX)*FOSRH(K)
      IF(FOCA(K).GT.ZERO)THEN
      VOLCX=FOCA(K)*VOLXX
      VOLCW=FOCA(K)*VOLXW
      CSORP(K)=TSORP*(OQCX*VOLCX-OHCX*VOLCW)/(VOLCX+VOLCW)
      ELSE
      CSORP(K)=TSORP*(OQCX*VOLXX-OHCX*VOLXW)/(VOLXX+VOLXW)
      ENDIF
      IF(FOAA(K).GT.ZERO)THEN
      VOLAX=FOAA(K)*VOLXX
      VOLAW=FOAA(K)*VOLXW
      CSORPA(K)=TSORP*(OQAX*VOLAX-OHAX*VOLAW)/(VOLAX+VOLAW)
      ELSE
      CSORPA(K)=TSORP*(OQAX*VOLXX-OHAX*VOLXW)/(VOLXX+VOLXW)
      ENDIF
      ZSORP(K)=TSORP*(OQNX*VOLXX-OHNX*VOLXW)/(VOLXX+VOLXW)
      PSORP(K)=TSORP*(OQPX*VOLXX-OHPX*VOLXW)/(VOLXX+VOLXW)
      ELSE
      CSORP(K)=0.0 
      CSORPA(K)=0.0
      ZSORP(K)=0.0
      PSORP(K)=0.0
      ENDIF
C     IF(I.EQ.284)THEN
C     WRITE(*,591)'CSORP',I,J,NX,NY,L,K,CSORP(K),CSORPA(K) 
C    1,OQC(K,L,NY,NX),OHC(K,L,NY,NX),OQA(K,L,NY,NX),OHA(K,L,NY,NX)
C    2,OQC(K,L,NY,NX)/VOLWM(NPH,L,NY,NX),OHC(K,L,NY,NX)/BKVL(L,NY,NX)
C    2,OQA(K,L,NY,NX)/VOLWM(NPH,L,NY,NX),OHA(K,L,NY,NX)/BKVL(L,NY,NX)
C    4,BKVL(L,NY,NX),VOLWM(NPH,L,NY,NX),FOCA(K),FOAA(K),FOSRH(K)
591   FORMAT(A8,6I4,40E12.4)
C     ENDIF
1790  CONTINUE
C
C     REDISTRIBUTE AUTOTROPHIC DECOMPOSITION PRODUCTS AMONG
C     HETEROTROPHIC SUBSTRATE-MICROBE COMPLEXES
C
      DO 1690 K=0,KL
      IF(TORC.GT.ZEROS(NY,NX))THEN
      FORC(K)=ORCT(K)/TORC
      ELSE
      IF(K.EQ.3)THEN
      FORC(K)=1.0
      ELSE
      FORC(K)=0.0
      ENDIF
      ENDIF
      DO 1685 N=1,7
      DO 1680 M=1,2
      RCCMC(M,N,K)=(RCOMC(M,N,5)+RCMMC(M,N,5))*FORC(K)
      RCCMN(M,N,K)=(RCOMN(M,N,5)+RCMMN(M,N,5))*FORC(K)
      RCCMP(M,N,K)=(RCOMP(M,N,5)+RCMMP(M,N,5))*FORC(K)
C     IF(L.EQ.0)THEN
C     WRITE(*,8821)'RCCMC',I,J,L,K,N,M,RCCMC(M,N,K)
C    2,RCOMC(M,N,5),RCMMC(M,N,5),FORC(K) 
C     ENDIF
1680  CONTINUE
1685  CONTINUE
1690  CONTINUE
C
C     REDISTRIBUTE C,N AND P TRANSFORMATIONS AMONG STATE
C     VARIABLES IN SUBSTRATE-MICROBE COMPLEXES
C
      DO 590 K=0,KL
      DO 580 M=1,4
C
C     SUBSTRATE DECOMPOSITION PRODUCTS
C
      OSC(M,K,L,NY,NX)=OSC(M,K,L,NY,NX)-RDOSC(M,K)
      OSA(M,K,L,NY,NX)=OSA(M,K,L,NY,NX)-RDOSC(M,K)
      OSN(M,K,L,NY,NX)=OSN(M,K,L,NY,NX)-RDOSN(M,K)
      OSP(M,K,L,NY,NX)=OSP(M,K,L,NY,NX)-RDOSP(M,K)
      OQC(K,L,NY,NX)=OQC(K,L,NY,NX)+RCOSC(M,K)
      OQN(K,L,NY,NX)=OQN(K,L,NY,NX)+RCOSN(M,K)
      OQP(K,L,NY,NX)=OQP(K,L,NY,NX)+RCOSP(M,K)
C
C     LIGNIFICATION PRODUCTS
C
      IF(L.NE.0)THEN
      OSC(1,3,L,NY,NX)=OSC(1,3,L,NY,NX)+RHOSC(M,K)
      OSA(1,3,L,NY,NX)=OSA(1,3,L,NY,NX)+RHOSC(M,K)
      OSN(1,3,L,NY,NX)=OSN(1,3,L,NY,NX)+RHOSN(M,K)
      OSP(1,3,L,NY,NX)=OSP(1,3,L,NY,NX)+RHOSP(M,K)
      ELSE
      OSC(1,3,NU(NY,NX),NY,NX)=OSC(1,3,NU(NY,NX),NY,NX)+RHOSC(M,K)
      OSA(1,3,NU(NY,NX),NY,NX)=OSA(1,3,NU(NY,NX),NY,NX)+RHOSC(M,K)
      OSN(1,3,NU(NY,NX),NY,NX)=OSN(1,3,NU(NY,NX),NY,NX)+RHOSN(M,K)
      OSP(1,3,NU(NY,NX),NY,NX)=OSP(1,3,NU(NY,NX),NY,NX)+RHOSP(M,K)
      IF(TRC0(NY,NX).GT.ZEROS(NY,NX))THEN
      VOLR(NY,NX)=VOLR(NY,NX)*(1.0-RDOSC(M,K)/TRC0(NY,NX))
      ENDIF
      ENDIF
580   CONTINUE
C
C     MICROBIAL RESIDUE DECOMPOSITION PRODUCTS
C
      DO 575 M=1,2
      ORC(M,K,L,NY,NX)=ORC(M,K,L,NY,NX)-RDORC(M,K)
      ORN(M,K,L,NY,NX)=ORN(M,K,L,NY,NX)-RDORN(M,K)
      ORP(M,K,L,NY,NX)=ORP(M,K,L,NY,NX)-RDORP(M,K)
      OQC(K,L,NY,NX)=OQC(K,L,NY,NX)+RDORC(M,K)
      OQN(K,L,NY,NX)=OQN(K,L,NY,NX)+RDORN(M,K)
      OQP(K,L,NY,NX)=OQP(K,L,NY,NX)+RDORP(M,K)
575   CONTINUE
      OQC(K,L,NY,NX)=OQC(K,L,NY,NX)+RDOHC(K)
      OQN(K,L,NY,NX)=OQN(K,L,NY,NX)+RDOHN(K)+RCOQN*FORC(K)
      OQP(K,L,NY,NX)=OQP(K,L,NY,NX)+RDOHP(K)
      OQA(K,L,NY,NX)=OQA(K,L,NY,NX)+RDOHA(K)
      OHC(K,L,NY,NX)=OHC(K,L,NY,NX)-RDOHC(K)
      OHN(K,L,NY,NX)=OHN(K,L,NY,NX)-RDOHN(K)
      OHP(K,L,NY,NX)=OHP(K,L,NY,NX)-RDOHP(K)
      OHA(K,L,NY,NX)=OHA(K,L,NY,NX)-RDOHA(K)
C
C     MICROBIAL UPTAKE OF DISSOLVED C, N, P
C
      DO 570 N=1,7
      OQC(K,L,NY,NX)=OQC(K,L,NY,NX)-CGOQC(N,K)
      OQN(K,L,NY,NX)=OQN(K,L,NY,NX)-CGOMN(N,K) 
      OQP(K,L,NY,NX)=OQP(K,L,NY,NX)-CGOMP(N,K) 
      OQA(K,L,NY,NX)=OQA(K,L,NY,NX)-CGOAC(N,K)+RCH3X(N,K)
C
C     MICROBIAL DECOMPOSITION PRODUCTS
C
      DO 565 M=1,2
      ORC(M,K,L,NY,NX)=ORC(M,K,L,NY,NX)+RCOMC(M,N,K)+RCCMC(M,N,K)
     2+RCMMC(M,N,K)
      ORN(M,K,L,NY,NX)=ORN(M,K,L,NY,NX)+RCOMN(M,N,K)+RCCMN(M,N,K)
     2+RCMMN(M,N,K)
      ORP(M,K,L,NY,NX)=ORP(M,K,L,NY,NX)+RCOMP(M,N,K)+RCCMP(M,N,K)
     2+RCMMP(M,N,K)
C     IF(L.EQ.0)THEN
C     WRITE(*,8821)'ORC',I,J,L,K,N,M,ORC(M,K,L,NY,NX)
C    2,RCOMC(M,N,K),RCCMC(M,N,K),RCMMC(M,N,K),RDORC(M,K)
8821  FORMAT(A8,6I4,100E24.16)
C     ENDIF
565   CONTINUE
570   CONTINUE
C
C     SORPTION PRODUCTS
C
      OQC(K,L,NY,NX)=OQC(K,L,NY,NX)-CSORP(K)
      OQN(K,L,NY,NX)=OQN(K,L,NY,NX)-ZSORP(K)
      OQP(K,L,NY,NX)=OQP(K,L,NY,NX)-PSORP(K)
      OQA(K,L,NY,NX)=OQA(K,L,NY,NX)-CSORPA(K)
      OHC(K,L,NY,NX)=OHC(K,L,NY,NX)+CSORP(K)
      OHN(K,L,NY,NX)=OHN(K,L,NY,NX)+ZSORP(K)
      OHP(K,L,NY,NX)=OHP(K,L,NY,NX)+PSORP(K)
      OHA(K,L,NY,NX)=OHA(K,L,NY,NX)+CSORPA(K)
C     IF((I/10)*10.EQ.I.AND.NX.EQ.3.AND.NY.EQ.1.AND.J.EQ.24)THEN
C     WRITE(*,592)'OQC',I,J,NX,NY,L,K,OQC(K,L,NY,NX)
C    2,(RCOSC(M,K),M=1,4),(RDORC(M,K),M=1,2),RDOHC(K)
C    2,(CGOQC(N,K),N=1,7),CSORP(K),OHC(K,L,NY,NX),OQCI  
C    4,(WFN(N,K),N=1,7)
C   3,RDOHA(K),(RCH3X(N,K),N=1,7),(CGOAC(N,K),N=1,7),CSORPA(K)
C   5,OQA(K,L,NY,NX),OHA(K,L,NY,NX) 
592   FORMAT(A8,6I4,80E12.4)
C     ENDIF 
590   CONTINUE
C
C     MICROBIAL GROWTH FROM RESPIRATION, MINERALIZATION
C
      DO 550 K=0,5
      TGROMC(K)=0.0
      IF(L.NE.0.OR.(K.NE.3.AND.K.NE.4))THEN
      DO 545 N=1,7
      IF(K.NE.5.OR.(N.LE.3.OR.N.EQ.5))THEN
      DO 540 M=1,2
      OMC(M,N,K,L,NY,NX)=OMC(M,N,K,L,NY,NX)+CGOMS(M,N,K) 
     2-RXOMC(M,N,K)-RXMMC(M,N,K) 
      OMN(M,N,K,L,NY,NX)=OMN(M,N,K,L,NY,NX)+CGONS(M,N,K) 
     2-RXOMN(M,N,K)-RXMMN(M,N,K)
      OMP(M,N,K,L,NY,NX)=OMP(M,N,K,L,NY,NX)+CGOPS(M,N,K) 
     2-RXOMP(M,N,K)-RXMMP(M,N,K) 
C     IF(I.EQ.240.AND.J.EQ.24.AND.NX.EQ.4.AND.NY.EQ.1
C    2.AND.K.EQ.5.AND.N.EQ.3)THEN
C     WRITE(*,4488)'RDOMC',I,J,NX,NY,L,K,N,M,CGOMS(M,N,K),CGOQC(N,K)
C    4,CGOAC(N,K),RGOMO(N,K),RGOMD(N,K),RXOMC(M,N,K),RXMMC(M,N,K)
C    3,RMOMC(M,N,K),TFNG,OMGR,OMC(3,N,K,L,NY,NX),WFN(N,K)
C    3,OMC(M,N,K,L,NY,NX),OMA(N,K),TSRH 
C    4,RCH3X(N,K),RH2GZ,RH2GX(4,K),FOCA(K),FOAA(K) 
C    6,OQA(K,L,NY,NX),OHA(K,L,NY,NX),OQC(K,L,NY,NX),OHC(K,L,NY,NX)
C    7,OMP(M,N,K,L,NY,NX),CGOPS(M,N,K),RDOMP(M,N,K),RDMMP(M,N,K)
C    8,OMP(3,N,K,L,NY,NX),CGOMP(N,K),RIPO4(N,K)
4488  FORMAT(A8,8I4,40E12.4)
C     ENDIF
C
C     HUMIFICATION PRODUCTS
C
      IF(L.NE.0)THEN
      OSC(1,4,L,NY,NX)=OSC(1,4,L,NY,NX)+CFOMC(1,L,NY,NX)
     2*(RHOMC(M,N,K)+RHMMC(M,N,K))
      OSA(1,4,L,NY,NX)=OSA(1,4,L,NY,NX)+CFOMC(1,L,NY,NX)
     2*(RHOMC(M,N,K)+RHMMC(M,N,K))
      OSN(1,4,L,NY,NX)=OSN(1,4,L,NY,NX)+CFOMC(1,L,NY,NX)
     2*(RHOMN(M,N,K)+RHMMN(M,N,K))
      OSP(1,4,L,NY,NX)=OSP(1,4,L,NY,NX)+CFOMC(1,L,NY,NX)
     2*(RHOMP(M,N,K)+RHMMP(M,N,K))
      OSC(2,4,L,NY,NX)=OSC(2,4,L,NY,NX)+CFOMC(2,L,NY,NX)
     2*(RHOMC(M,N,K)+RHMMC(M,N,K))
      OSA(2,4,L,NY,NX)=OSA(2,4,L,NY,NX)+CFOMC(2,L,NY,NX)
     2*(RHOMC(M,N,K)+RHMMC(M,N,K))
      OSN(2,4,L,NY,NX)=OSN(2,4,L,NY,NX)+CFOMC(2,L,NY,NX)
     2*(RHOMN(M,N,K)+RHMMN(M,N,K))
      OSP(2,4,L,NY,NX)=OSP(2,4,L,NY,NX)+CFOMC(2,L,NY,NX)
     2*(RHOMP(M,N,K)+RHMMP(M,N,K))
      ELSE
      OSC(1,4,NU(NY,NX),NY,NX)=OSC(1,4,NU(NY,NX),NY,NX)
     2+CFOMC(1,NU(NY,NX),NY,NX)*(RHOMC(M,N,K)+RHMMC(M,N,K))
      OSA(1,4,NU(NY,NX),NY,NX)=OSA(1,4,NU(NY,NX),NY,NX)
     2+CFOMC(1,NU(NY,NX),NY,NX)*(RHOMC(M,N,K)+RHMMC(M,N,K))
      OSN(1,4,NU(NY,NX),NY,NX)=OSN(1,4,NU(NY,NX),NY,NX)
     2+CFOMC(1,NU(NY,NX),NY,NX)*(RHOMN(M,N,K)+RHMMN(M,N,K))
      OSP(1,4,NU(NY,NX),NY,NX)=OSP(1,4,NU(NY,NX),NY,NX)
     2+CFOMC(1,NU(NY,NX),NY,NX)*(RHOMP(M,N,K)+RHMMP(M,N,K))
      OSC(2,4,NU(NY,NX),NY,NX)=OSC(2,4,NU(NY,NX),NY,NX)
     2+CFOMC(2,NU(NY,NX),NY,NX)*(RHOMC(M,N,K)+RHMMC(M,N,K))
      OSA(2,4,NU(NY,NX),NY,NX)=OSA(2,4,NU(NY,NX),NY,NX)
     2+CFOMC(2,NU(NY,NX),NY,NX)*(RHOMC(M,N,K)+RHMMC(M,N,K))
      OSN(2,4,NU(NY,NX),NY,NX)=OSN(2,4,NU(NY,NX),NY,NX)
     2+CFOMC(2,NU(NY,NX),NY,NX)*(RHOMN(M,N,K)+RHMMN(M,N,K))
      OSP(2,4,NU(NY,NX),NY,NX)=OSP(2,4,NU(NY,NX),NY,NX)
     2+CFOMC(2,NU(NY,NX),NY,NX)*(RHOMP(M,N,K)+RHMMP(M,N,K))
      ENDIF
540   CONTINUE
C
C     INPUTS TO NONSTRUCTURAL POOLS
C
      CGROMC=CGOMC(N,K)-RGOMO(N,K)-RGOMD(N,K)
      TGROMC(K)=TGROMC(K)+CGROMC
      DO 555 M=1,2
      OMC(3,N,K,L,NY,NX)=OMC(3,N,K,L,NY,NX)-CGOMS(M,N,K)
     2+R3OMC(M,N,K) 
      OMN(3,N,K,L,NY,NX)=OMN(3,N,K,L,NY,NX)-CGONS(M,N,K)
     2+R3OMN(M,N,K)+R3MMN(M,N,K)
      OMP(3,N,K,L,NY,NX)=OMP(3,N,K,L,NY,NX)-CGOPS(M,N,K)
     2+R3OMP(M,N,K)+R3MMP(M,N,K)
      RCO2X(N,K)=RCO2X(N,K)+R3MMC(M,N,K) 
555   CONTINUE
      OMC(3,N,K,L,NY,NX)=OMC(3,N,K,L,NY,NX)+CGROMC
      OMN(3,N,K,L,NY,NX)=OMN(3,N,K,L,NY,NX)+CGOMN(N,K) 
     2+RINH4(N,K)+RINB4(N,K)+RINO3(N,K)+RINB3(N,K)+RN2FX(N,K) 
      OMP(3,N,K,L,NY,NX)=OMP(3,N,K,L,NY,NX)+CGOMP(N,K) 
     2+RIPO4(N,K)+RIPB4(N,K) 
      IF(L.EQ.0)THEN
      OMN(3,N,K,L,NY,NX)=OMN(3,N,K,L,NY,NX)+RINH4R(N,K)+RINO3R(N,K)
      OMP(3,N,K,L,NY,NX)=OMP(3,N,K,L,NY,NX)+RIPO4R(N,K)
      ENDIF
C     IF(NY.EQ.5.AND.L.EQ.10.AND.K.EQ.3.AND.N.EQ.2)THEN
C     WRITE(*,5556)'OMC3',I,J,NX,NY,L,K,N,OMC(3,N,K,L,NY,NX)
C    2,CGOMS(1,N,K),CGOMS(2,N,K),CGROMC,OMP(3,N,K,L,NY,NX)
C    3,CGOPS(1,N,K),CGOPS(2,N,K),CGOMP(N,K),RIPO4(N,K)
C    4,CGOMC(N,K),RGOMO(N,K),RGOMD(N,K),RMOMT,WFN(N,K)
5556  FORMAT(A8,7I4,20E12.4)
C     ENDIF
      ENDIF
545   CONTINUE
      ENDIF
550   CONTINUE
      DO 475 K=0,KL
      OSCT(K)=0.0
      OSAT(K)=0.0
      DO 475 M=1,4
      OSCT(K)=OSCT(K)+OSC(M,K,L,NY,NX)
      OSAT(K)=OSAT(K)+OSA(M,K,L,NY,NX)
475   CONTINUE
      DO 480 K=0,KL
      OSCX=OSCT(K)-OSAT(K)
      IF(OSCX.GT.ZEROS(NY,NX))THEN
      IF(OSAT(K).GT.ZEROS(NY,NX))THEN
      COSC=OSCX/OSAT(K)
      DFNA=COSC/(COSC+DCKX(K))
      ELSE
      DFNA=1.0
      ENDIF
      DO 485 M=1,4
      OSA(M,K,L,NY,NX)=AMIN1(OSC(M,K,L,NY,NX) 
     2,OSA(M,K,L,NY,NX)+DOSA(K)*(AMAX1(DOSM(K),AMIN1(DOSX(K),TGROMC(K) 
     3/AREA(3,L,NY,NX))))*AREA(3,L,NY,NX) 
     3*(OSC(M,K,L,NY,NX)-OSA(M,K,L,NY,NX))/OSCX*DFNA)
C     IF(INT(I/30)*30.EQ.I.AND.J.EQ.19.AND.K.LE.1)THEN
C     WRITE(*,8822)'OSA',I,J,L,K,M,OSA(M,K,L,NY,NX),OSC(M,K,L,NY,NX)
C    3,OSAT(K),OSCT(K),(OSC(M,K,L,NY,NX)-OSA(M,K,L,NY,NX))
C    3/OSCX,DOSA(K),ZOMA(K),TFNG,TFNX,WFNG,COSC,DFNA
C    4,(TGROMC(K)/AREA(3,L,NY,NX))
C    5,(AMAX1(DOSM(K),AMIN1(DOSX(K)
C    3,TGROMC(K)/AREA(3,L,NY,NX)))),TGROMC(K) 
C     ENDIF
8822  FORMAT(A8,5I4,20E12.4)
485   CONTINUE
      ELSE
      DO 490 M=1,4
      OSA(M,K,L,NY,NX)=AMIN1(OSC(M,K,L,NY,NX),OSA(M,K,L,NY,NX)) 
490   CONTINUE
      ENDIF
C     IF(L.EQ.0)THEN
C     WRITE(*,8823)'OSC',I,J,L,K,((OMC(M,N,K,L,NY,NX),N=1,7),M=1,3)
C    2,(ORC(M,K,L,NY,NX),M=1,2),OQC(K,L,NY,NX),OQCH(K,L,NY,NX)
C    3,OHC(K,L,NY,NX),OQA(K,L,NY,NX),OQAH(K,L,NY,NX),OHA(K,L,NY,NX)
C    4,(OSC(M,K,L,NY,NX),M=1,4)
8823  FORMAT(A8,4I4,100E24.16)
C     ENDIF
480   CONTINUE
C
C     AGGREGATE TRANSFORMATIONS
C
      TRINH=0.0
      TRINO=0.0
      TRIPO=0.0
      TRINB=0.0
      TRIOB=0.0
      TRIPB=0.0
      TRGOM=0.0
      TRGOC=0.0
      TRGOD=0.0
      TRGOA=0.0
      TRGOH=0.0
      TUPOX=0.0
      TRDN3=0.0
      TRDNB=0.0
      TRDN2=0.0
      TRD2B=0.0
      TRDNO=0.0
      TRN2F=0.0
      DO 650 K=0,5
      IF(L.NE.0.OR.(K.NE.3.AND.K.NE.4))THEN
      DO 640 N=1,7
      IF(K.NE.5.OR.(N.LE.3.OR.N.EQ.5))THEN
      TRINH=TRINH+RINH4(N,K)
      TRINO=TRINO+RINO3(N,K)
      TRIPO=TRIPO+RIPO4(N,K)
      TRINB=TRINB+RINB4(N,K)
      TRIOB=TRIOB+RINB3(N,K)
      TRIPB=TRIPB+RIPB4(N,K)
      TRN2F=TRN2F+RN2FX(N,K)
      IF(L.EQ.NU(NY,NX))THEN
      TRINH=TRINH+RINH4R(N,K)
      TRINO=TRINO+RINO3R(N,K)
      TRIPO=TRIPO+RIPO4R(N,K)
      ENDIF
C     IF(NY.EQ.5.AND.L.EQ.10.AND.K.EQ.3.AND.N.EQ.2)THEN
C     WRITE(*,4469)'TRINO',I,J,NX,NY,L,K,N,TRINO,RINO3(N,K),RINO3R(N,K)
C     WRITE(*,4469)'TRIPO',I,J,NX,NY,L,K,N,TRIPO,RIPO4(N,K),RIPO4R(N,K)
C    2,CGOMP(N,K)
4469  FORMAT(A8,7I4,20E12.4)
C     ENDIF
      TRGOM=TRGOM+RCO2X(N,K)
      TRGOC=TRGOC+RCH4X(N,K)
      TRGOD=TRGOD+RGOMD(N,K)
      TUPOX=TUPOX+RUPOX(N,K)
      TRDN3=TRDN3+RDNO3(N,K)
      TRDNB=TRDNB+RDNOB(N,K)
      TRDN2=TRDN2+RDNO2(N,K)
      TRD2B=TRD2B+RDN2B(N,K)
      TRDNO=TRDNO+RDN2O(N,K)
      TRGOH=TRGOH+RH2GX(N,K)
C     IF(L.EQ.NU(NY,NX))THEN
C     WRITE(*,3333)'TUPOX',I,J,NX,NY,L,K,N,TUPOX,RUPOX(N,K)
C     ENDIF
C     IF(J.EQ.12.AND.L.LE.4)THEN
C     WRITE(*,3333)'N2O',I,J,NX,NY,L,K,N,TRDN2,TRD2B,TRDNO
C    2,RDNO2(N,K),RDN2B(N,K),RDN2O(N,K),COXYS(L,NY,NX)
C    3,COXYG(L,NY,NX)
C     WRITE(*,3333)'TRGOH',I,J,NX,NY,L,K,N,TRGOH,RH2GX(N,K)
C    2,RGOMO(N,K)
3333  FORMAT(A8,7I4,20E12.4)
C     ENDIF
      ENDIF
640   CONTINUE
      ENDIF
650   CONTINUE
C     IF(J.EQ.12.AND.L.LE.4)THEN
C     WRITE(*,3334)'CHEMO',I,J,L,RCN2O,RCN2B
3334  FORMAT(A8,3I4,12E12.4)
C     ENDIF
      DO 645 N=1,7
      IF(N.LE.3.OR.N.EQ.5)THEN
      IF(N.NE.3)THEN
      TRGOA=TRGOA+CGOMC(N,5) 
      ENDIF
      ENDIF
645   CONTINUE
C
C     ALLOCATE AGGREGATED TRANSFORMATIONS INTO ARRAYS TO UPDATE
C     STATE VARIABLES IN 'REDIST'
C
      RCO2O(L,NY,NX)=TRGOA-TRGOM-TRGOD-RVOXA(3)
      RCH4O(L,NY,NX)=RVOXA(3)+CGOMC(3,5)-TRGOC
      RH2GO(L,NY,NX)=RH2GZ-TRGOH
      RUPOXO(L,NY,NX)=TUPOX
      RN2G(L,NY,NX)=-TRDNO
      RN2O(L,NY,NX)=-TRDN2-TRD2B-RCN2O-RCN2B+TRDNO
C     IF(NY.EQ.5)THEN
C     WRITE(*,2468)'RCH4O',I,J,NX,NY,L,RCH4O(L,NY,NX),RVOXA(3)
C    2,CGOMC(3,5),TRGOC,(OMA(N,1),N=1,7)
2468  FORMAT(A8,5I4,20E12.4)
C     ENDIF
      DO 655 K=0,4
      DO 660 M=1,4
      XOQCS(K,L,NY,NX)=XOQCS(K,L,NY,NX)+RCOSC(M,K)
      XOQNS(K,L,NY,NX)=XOQNS(K,L,NY,NX)+RCOSN(M,K)
      XOQPS(K,L,NY,NX)=XOQPS(K,L,NY,NX)+RCOSP(M,K)
660   CONTINUE
      DO 665 M=1,2
      XOQCS(K,L,NY,NX)=XOQCS(K,L,NY,NX)+RDORC(M,K)
      XOQNS(K,L,NY,NX)=XOQNS(K,L,NY,NX)+RDORN(M,K)
      XOQPS(K,L,NY,NX)=XOQPS(K,L,NY,NX)+RDORP(M,K)
665   CONTINUE
      XOQCS(K,L,NY,NX)=XOQCS(K,L,NY,NX)+RDOHC(K)
      XOQNS(K,L,NY,NX)=XOQNS(K,L,NY,NX)+RDOHN(K)
      XOQPS(K,L,NY,NX)=XOQPS(K,L,NY,NX)+RDOHP(K)
      XOQAS(K,L,NY,NX)=XOQAS(K,L,NY,NX)+RDOHA(K)
      DO 670 N=1,7
      XOQCS(K,L,NY,NX)=XOQCS(K,L,NY,NX)-CGOQC(N,K)
      XOQNS(K,L,NY,NX)=XOQNS(K,L,NY,NX)-CGOMN(N,K) 
      XOQPS(K,L,NY,NX)=XOQPS(K,L,NY,NX)-CGOMP(N,K) 
      XOQAS(K,L,NY,NX)=XOQAS(K,L,NY,NX)-CGOAC(N,K)+RCH3X(N,K)
670   CONTINUE
      XOQCS(K,L,NY,NX)=XOQCS(K,L,NY,NX)-CSORP(K)
      XOQNS(K,L,NY,NX)=XOQNS(K,L,NY,NX)-ZSORP(K)
      XOQPS(K,L,NY,NX)=XOQPS(K,L,NY,NX)-PSORP(K)
      XOQAS(K,L,NY,NX)=XOQAS(K,L,NY,NX)-CSORPA(K)
655   CONTINUE
      XNH4S(L,NY,NX)=-TRINH-RVOXA(1) 
      XNO3S(L,NY,NX)=-TRINO+RVOXA(2)-TRDN3+RCNO3
      XNO2S(L,NY,NX)=RVOXA(1)-RVOXA(2)+TRDN3-TRDN2-RCNO2
      XH2PS(L,NY,NX)=-TRIPO
      XNH4B(L,NY,NX)=-TRINB-RVOXB(1) 
      XNO3B(L,NY,NX)=-TRIOB+RVOXB(2)-TRDNB+RCN3B
      XNO2B(L,NY,NX)=RVOXB(1)-RVOXB(2)+TRDNB-TRD2B-RCNOB
      XH2BS(L,NY,NX)=-TRIPB
      XN2GS(L,NY,NX)=TRN2F
      XZHYS(L,NY,NX)=0.1429*(RVOXA(1)+RVOXB(1)-TRDN3-TRDNB)
     2-0.0714*(TRDN2+TRD2B+TRDNO)
      OMAT(L,NY,NX)=TOMA
      TFNQ(L,NY,NX)=TFNG
      VOLQ(L,NY,NX)=VOLWZ
C     IF(L.EQ.0)THEN
C     WRITE(*,2323)'XNH4S',I,J,L,XNH4S(L,NY,NX)
C    2,TRINH,RVOXA(1),VLNH4(L,NY,NX)
C     WRITE(*,2323)'XNO3S',I,J,L,XNO3S(L,NY,NX)
C    2,TRINO,RVOXA(2),VLNO3(L,NY,NX),TRDN3,RCNO3
C     WRITE(*,2323)'XH2PS',I,J,L,XH2PS(L,NY,NX)
C    2,RIPOT,TRIPO,VLPO4(L,NY,NX)
C     WRITE(*,2323)'XNO2B',I,J,L,XNO2B(L,NY,NX),RVOXB(1)
C    2,VLNHB(L,NY,NX),RVOXB(2),VLNOB(L,NY,NX),TRDNB,TRD2B,RCNOB
2323  FORMAT(A8,3I4,12E12.4)
C     ENDIF
      ELSE
      RCO2O(L,NY,NX)=0.0
      RCH4O(L,NY,NX)=0.0
      RH2GO(L,NY,NX)=0.0
      RUPOXO(L,NY,NX)=0.0
      RN2G(L,NY,NX)=0.0
      RN2O(L,NY,NX)=0.0
      XNH4S(L,NY,NX)=0.0
      XNO3S(L,NY,NX)=0.0
      XNO2S(L,NY,NX)=0.0
      XH2PS(L,NY,NX)=0.0
      XNH4B(L,NY,NX)=0.0
      XNO3B(L,NY,NX)=0.0
      XNO2B(L,NY,NX)=0.0
      XH2BS(L,NY,NX)=0.0
      XN2GS(L,NY,NX)=0.0
      XZHYS(L,NY,NX)=0.0
      ENDIF
C
C     ADJUST LAYERING OF SOC
C
      IF(L.EQ.0.OR.(L.GE.NU(NY,NX).AND.L.LT.NL(NY,NX))
     2.AND.CDPTH(L,NY,NX).LE.CDPTH(NU(NY,NX)-1,NY,NX)+0.30)THEN
      IF(L.EQ.0)THEN
      LL=NU(NY,NX)
      IF(ORGR(L,NY,NX).GT.0.0)THEN
      FOSCXS=AMIN1(1.0,FOSCZ0/ORGR(L,NY,NX)*TOMA*TFNG)
      IF(ATKA(NY,NX).LT.268.15)THEN
      IF(THAW(3,LL,NY,NX).LT.0.0.AND.VOLW(LL,NY,NX)
     2.GT.ZEROS(NY,NX).AND.VOLW(LL,NY,NX)+VOLI(LL,NY,NX)
     3.GT.0.90*VOLA(LL,NY,NX))THEN
      FOSCXS=FOSCXS-0.0025*THAW(3,LL,NY,NX)/VOLW(LL,NY,NX)
      ENDIF
      ENDIF
      VOLR(NY,NX)=VOLR(NY,NX)*(1.0-FOSCXS)
      ELSE
      FOSCXS=0.0
      ENDIF 
      ELSE
      LL=L+1
      OSCXD=(ORGR(L,NY,NX)*VOLT(LL,NY,NX)-ORGR(LL,NY,NX)*VOLT(L,NY,NX))
     2/(VOLT(L,NY,NX)+VOLT(LL,NY,NX))
      IF(OSCXD.GT.0.0.AND.ORGR(L,NY,NX).GT.ZEROS(NY,NX))THEN
      FOSCXD=OSCXD/ORGR(L,NY,NX)
      ELSEIF(OSCXD.LT.0.0.AND.ORGR(LL,NY,NX).GT.ZEROS(NY,NX))THEN 
      FOSCXD=OSCXD/ORGR(LL,NY,NX)
      ELSE
      FOSCXD=0.0
      ENDIF
      FOSCXS=FOSCZL*FOSCXD*TFNG*TOMA/VOLT(L,NY,NX)
      ENDIF
C     IF(L.EQ.0)THEN
C     WRITE(*,1115)'MIX',I,J,L,FOSCXS,FOSCZ0,FOSCZL,OSCXD,TOMA 
C    2,TFNG,OSCXS1,BKVL(L,NY,NX),OSCXS2,BKVL(LL,NY,NX)
1115  FORMAT(A8,3I4,20E12.4)
C     ENDIF
      IF(FOSCXS.NE.0.0)THEN
      DO 7971 K=0,2
      DO 7961 N=1,7
      DO 7962 M=1,3
      OMCXS=FOSCXS*OMC(M,N,K,L,NY,NX)
      OMNXS=FOSCXS*OMN(M,N,K,L,NY,NX)
      OMPXS=FOSCXS*OMP(M,N,K,L,NY,NX)
      OMC(M,N,K,L,NY,NX)=OMC(M,N,K,L,NY,NX)-OMCXS
      OMN(M,N,K,L,NY,NX)=OMN(M,N,K,L,NY,NX)-OMNXS
      OMP(M,N,K,L,NY,NX)=OMP(M,N,K,L,NY,NX)-OMPXS
      OMC(M,N,K,LL,NY,NX)=OMC(M,N,K,LL,NY,NX)+OMCXS
      OMN(M,N,K,LL,NY,NX)=OMN(M,N,K,LL,NY,NX)+OMNXS
      OMP(M,N,K,LL,NY,NX)=OMP(M,N,K,LL,NY,NX)+OMPXS
7962  CONTINUE
7961  CONTINUE
7971  CONTINUE
      DO 7901 K=0,2
      DO 7941 M=1,2
      ORCXS=FOSCXS*ORC(M,K,L,NY,NX)
      ORNXS=FOSCXS*ORN(M,K,L,NY,NX)
      ORPXS=FOSCXS*ORP(M,K,L,NY,NX)
      ORC(M,K,L,NY,NX)=ORC(M,K,L,NY,NX)-ORCXS
      ORN(M,K,L,NY,NX)=ORN(M,K,L,NY,NX)-ORNXS
      ORP(M,K,L,NY,NX)=ORP(M,K,L,NY,NX)-ORPXS
      ORC(M,K,LL,NY,NX)=ORC(M,K,LL,NY,NX)+ORCXS
      ORN(M,K,LL,NY,NX)=ORN(M,K,LL,NY,NX)+ORNXS
      ORP(M,K,LL,NY,NX)=ORP(M,K,LL,NY,NX)+ORPXS
7941  CONTINUE
      OQCXS=FOSCXS*OQC(K,L,NY,NX)
      OQCHXS=FOSCXS*OQCH(K,L,NY,NX)
      OHCXS=FOSCXS*OHC(K,L,NY,NX)
      OQAXS=FOSCXS*OQA(K,L,NY,NX)
      OQAHXS=FOSCXS*OQAH(K,L,NY,NX)
      OHAXS=FOSCXS*OHA(K,L,NY,NX)
      OQNXS=FOSCXS*OQN(K,L,NY,NX)
      OQNHXS=FOSCXS*OQNH(K,L,NY,NX)
      OHNXS=FOSCXS*OHN(K,L,NY,NX)
      OQPXS=FOSCXS*OQP(K,L,NY,NX)
      OQPHXS=FOSCXS*OQPH(K,L,NY,NX)
      OHPXS=FOSCXS*OHP(K,L,NY,NX)
      OQC(K,L,NY,NX)=OQC(K,L,NY,NX)-OQCXS
      OQCH(K,L,NY,NX)=OQCH(K,L,NY,NX)-OQCHXS
      OHC(K,L,NY,NX)=OHC(K,L,NY,NX)-OHCXS
      OQA(K,L,NY,NX)=OQA(K,L,NY,NX)-OQAXS
      OQAH(K,L,NY,NX)=OQAH(K,L,NY,NX)-OQAHXS
      OHA(K,L,NY,NX)=OHA(K,L,NY,NX)-OHAXS
      OQN(K,L,NY,NX)=OQN(K,L,NY,NX)-OQNXS
      OQNH(K,L,NY,NX)=OQNH(K,L,NY,NX)-OQNHXS
      OHN(K,L,NY,NX)=OHN(K,L,NY,NX)-OHNXS
      OQP(K,L,NY,NX)=OQP(K,L,NY,NX)-OQPXS
      OQPH(K,L,NY,NX)=OQPH(K,L,NY,NX)-OQPHXS
      OHP(K,L,NY,NX)=OHP(K,L,NY,NX)-OHPXS
      OQC(K,LL,NY,NX)=OQC(K,LL,NY,NX)+OQCXS
      OQCH(K,LL,NY,NX)=OQCH(K,LL,NY,NX)+OQCHXS
      OHC(K,LL,NY,NX)=OHC(K,LL,NY,NX)+OHCXS
      OQA(K,LL,NY,NX)=OQA(K,LL,NY,NX)+OQAXS
      OQAH(K,LL,NY,NX)=OQAH(K,LL,NY,NX)+OQAHXS
      OHA(K,LL,NY,NX)=OHA(K,LL,NY,NX)+OHAXS
      OQN(K,LL,NY,NX)=OQN(K,LL,NY,NX)+OQNXS
      OQNH(K,LL,NY,NX)=OQNH(K,LL,NY,NX)+OQNHXS
      OHN(K,LL,NY,NX)=OHN(K,LL,NY,NX)+OHNXS
      OQP(K,LL,NY,NX)=OQP(K,LL,NY,NX)+OQPXS
      OQPH(K,LL,NY,NX)=OQPH(K,LL,NY,NX)+OQPHXS
      OHP(K,LL,NY,NX)=OHP(K,LL,NY,NX)+OHPXS
      DO 7931 M=1,4
      OSCXS=FOSCXS*OSC(M,K,L,NY,NX)
      OSAXS=FOSCXS*OSA(M,K,L,NY,NX)
      OSNXS=FOSCXS*OSN(M,K,L,NY,NX)
      OSPXS=FOSCXS*OSP(M,K,L,NY,NX)
      OSC(M,K,L,NY,NX)=OSC(M,K,L,NY,NX)-OSCXS
      OSA(M,K,L,NY,NX)=OSA(M,K,L,NY,NX)-OSAXS
      OSN(M,K,L,NY,NX)=OSN(M,K,L,NY,NX)-OSNXS
      OSP(M,K,L,NY,NX)=OSP(M,K,L,NY,NX)-OSPXS
      OSC(M,K,LL,NY,NX)=OSC(M,K,LL,NY,NX)+OSCXS
      OSA(M,K,LL,NY,NX)=OSA(M,K,LL,NY,NX)+OSAXS
      OSN(M,K,LL,NY,NX)=OSN(M,K,LL,NY,NX)+OSNXS
      OSP(M,K,LL,NY,NX)=OSP(M,K,LL,NY,NX)+OSPXS
7931  CONTINUE
7901  CONTINUE
      ENDIF
C     IF(L.EQ.0)THEN
C     WRITE(*,2123)'TOTALL',I,J,NX,NY,L,TFOXYX,TFNH4X
C    2,TFNO3X,TFPO4X,TFNH4B,TFNO3B,TFPO4B,TFNO2X,TFNO2B
C    3,TFOQC,TFOQA
2123  FORMAT(A8,5I4,12E15.4)
C     ENDIF
      ENDIF
998   CONTINUE
C     WRITE(20,3434)'RN2O',IYRC,I,J,(RN2O(L,NY,NX),L=0,NL(NY,NX))
3434  FORMAT(A8,3I4,20E12.4)
9990  CONTINUE
9995  CONTINUE
      RETURN
      END
