      SUBROUTINE hour1(I,J,NHW,NHE,NVN,NVS)
C
C     THIS SUBROUTINE REINITIALIZES HOURLY VARIABLES USED IN OTHER
C     SUBROUTINES
C
      include "parameters.h"
      include "filec.h"
      include "blkc.h"
      include "blk1g.h"
      include "blk2a.h"
      include "blk2b.h"
      include "blk2c.h"
      include "blk3.h"
      include "blk5.h"
      include "blk6.h"
      include "blk8a.h"
      include "blk8b.h"
      include "blk9a.h"
      include "blk9b.h"
      include "blk9c.h"
      include "blk10.h"
      include "blk11a.h"
      include "blk11b.h"
      include "blk13a.h"
      include "blk13b.h"
      include "blk13c.h"
      include "blk15a.h"
      include "blk15b.h"
      include "blk16.h"
      include "blk18a.h"
      include "blk18b.h"
      include "blk19a.h"
      include "blk19b.h"
      include "blk19c.h"
      include "blk19d.h"
      include "blk20a.h"
      include "blk20b.h"
      include "blk20c.h"
      include "blk20d.h"
      include "blk20e.h"
      include "blk20f.h"
      include "blk21a.h"
      include "blk21b.h"
      CHARACTER*16 DATA(30)
      DIMENSION OFC(2),OFN(2),OFP(2),CNOF(4),CPOF(4),OMCI(3),OMCF(7)
     2,OMCA(2)
      DIMENSION PSISK(100),TAUY(0:16),RABSL(0:16),RABPL(0:16)
     2,RAFSL(0:16),RAFPL(0:16),IALBS(4,4),RADSL(05,JY,JX)
     3,RADPL(05,JY,JX),RADS1(05,JY,JX),RADP1(05,JY,JX),RADS2(05,JY,JX)
     4,RADP2(05,JY,JX),RAYSL(05,JY,JX),RAYPL(05,JY,JX),RAYS1(05,JY,JX)
     5,RAYP1(05,JY,JX),RAYS2(05,JY,JX),RAYP2(05,JY,JX),RADSW(05,JY,JX)
     6,RADPW(05,JY,JX),RADW1(05,JY,JX),RADQ1(05,JY,JX),RADW2(05,JY,JX)
     7,RADQ2(05,JY,JX),RAYSW(05,JY,JX),RAYPW(05,JY,JX),RAYW1(05,JY,JX)
     8,RAYQ1(05,JY,JX),RAYW2(05,JY,JX),RAYQ2(05,JY,JX),RADSA(05,JY,JX)
     9,RAPSA(05,JY,JX),RDNDIR(4,4,05,JY,JX),PARDIR(4,4,05,JY,JX)
     1,RADWA(05,JY,JX),RAPWA(05,JY,JX),RDNDIW(4,4,05,JY,JX)
     2,PARDIW(4,4,05,JY,JX),TSURF(4,JZ,05,JY,JX),TSURFB(4,JZ,05,JY,JX)
     3,XVOLWC(0:2),ZL1(0:JZ,JY,JX),THETPX(0:JZ)
C     4,TRAPC(JY,JX),TRADG(JY,JX),TRAPG(JY,JX),TRADC(JY,JX)
      PARAMETER (CGSG=4.68E-02,CLSG=4.25E-06,CHSG=7.80E-02
     2,CQSG=7.08E-06,OGSG=6.43E-02,OLSG=8.57E-06,ZGSG=5.57E-02
     3,ZLSG=7.34E-06,Z2SG=5.57E-02,ZVSG=5.72E-06,ZHSG=6.67E-02
     4,ZNSG=4.00E-06,ZOSG=6.00E-06,POSG=3.00E-06,OCSG=1.0E-08
     5,ONSG=1.0E-08,OPSG=1.0E-08,OASG=3.64E-06,WGSG=7.70E-02
     6,ALSG=5.0E-06,FESG=5.0E-06,HYSG=5.0E-06,CASG=5.0E-06
     7,GMSG=5.0E-06,ANSG=5.0E-06,AKSG=5.0E-06,OHSG=5.0E-06
     8,C3SG=5.0E-06,HCSG=5.0E-06,SOSG=5.0E-06,CLSX=5.0E-06
     9,HGSG=5.57E-02,HLSG=7.34E-06)
      PARAMETER (SCO2X=7.391E-01,SCH4X=3.156E-02,SOXYX=2.925E-02
     2,SN2GX=1.510E-02,SN2OX=5.241E-01,SNH3X=2.852E+02,SH2GX=3.156E-02
     3,ACO2X=0.14,ACH4X=0.14,AOXYX=0.31,AN2GX=0.23,AN2OX=0.23
     4,ANH3X=0.07,AH2GX=0.14)
      PARAMETER (ALBRW=0.1,ALBPW=0.1,ABSRW=1.0-ALBRW,ABSPW=1.0-ALBPW)
      PARAMETER (VISC=0.28E-12,BKDSX=1.89,ZW=0.005,CFW=0.5
     2,FORGW=0.25E+06,THETRX=16.0E-06,HYGR=-250.0,DTHETW=1.0E-06)
      DATA XVOLWC/5.0E-04,2.5E-04,2.5E-04/ 
      DATA OMCI/0.005,0.020,0.005/
      DATA OMCF/0.20,0.20,0.00,0.20,0.20,0.05,0.05/
      DATA OMCA/0.05,0.05/
      REAL*4 TFACL,TFACG,TFACW,TFACR,TFACA
      XJ=J
      DOY=I-1+XJ/24
C
C     RESET SOIL ACCUMULATORS
C
      VOLWSO=0.0
      HEATSO=0.0
      OXYGSO=0.0
      TSEDSO=0.0
      TLRSDC=0.0
      TLORGC=0.0
      TLCO2G=0.0
      TLRSDN=0.0
      TLORGN=0.0
      TLN2G=0.0
      TLRSDP=0.0
      TLORGP=0.0
      TLNH4=0.0
      TLNO3=0.0
      TLPO4=0.0
      TION=0.0
      TBALC=0.0
      TBALN=0.0
      TBALP=0.0
C
C     CONCENTRATIONS OF CO2, CH4, O2, N2, N2O, NH3, H2 IN ATMOSPHERE
C     AND PRECIPITATION FROM MIXING RATIOS READ IN 'READS'
C
      DO 9145 NX=NHW,NHE
      DO 9140 NY=NVN,NVS
      CCO2E(NY,NX)=CO2E(NY,NX)*5.36E-04*273.15/TKA(NY,NX)
      CCH4E(NY,NX)=CH4E(NY,NX)*5.36E-04*273.15/TKA(NY,NX)
      COXYE(NY,NX)=OXYE(NY,NX)*1.43E-03*273.15/TKA(NY,NX)
      CZ2GE(NY,NX)=Z2GE(NY,NX)*1.25E-03*273.15/TKA(NY,NX)
      CZ2OE(NY,NX)=Z2OE(NY,NX)*1.25E-03*273.15/TKA(NY,NX)
      CNH3E(NY,NX)=ZNH3E(NY,NX)*6.25E-04*273.15/TKA(NY,NX)
      CH2GE(NY,NX)=H2GE(NY,NX)*8.92E-05*273.15/TKA(NY,NX)
      CCOR(NY,NX)=CCO2E(NY,NX)*SCO2X/(EXP(ACO2X*CSTRR(NY,NX)))
     2*EXP(0.843-0.0281*TCA(NY,NX))
      CCHR(NY,NX)=CCH4E(NY,NX)*SCH4X/(EXP(ACH4X*CSTRR(NY,NX)))
     2*EXP(0.597-0.0199*TCA(NY,NX))
      COXR(NY,NX)=COXYE(NY,NX)*SOXYX/(EXP(AOXYX*CSTRR(NY,NX)))
     2*EXP(0.516-0.0172*TCA(NY,NX))
      CNNR(NY,NX)=CZ2GE(NY,NX)*SN2GX/(EXP(AN2GX*CSTRR(NY,NX)))
     2*EXP(0.456-0.0152*TCA(NY,NX))
      CN2R(NY,NX)=CZ2OE(NY,NX)*SN2OX/(EXP(AN2OX*CSTRR(NY,NX)))
     2*EXP(0.897-0.0299*TCA(NY,NX))
      CCOQ(NY,NX)=CCO2E(NY,NX)*SCO2X/(EXP(ACO2X*CSTRQ(I,NY,NX)))
     2*EXP(0.843-0.0281*TCA(NY,NX))
      CCHQ(NY,NX)=CCH4E(NY,NX)*SCH4X/(EXP(ACH4X*CSTRQ(I,NY,NX)))
     2*EXP(0.597-0.0199*TCA(NY,NX))
      COXQ(NY,NX)=COXYE(NY,NX)*SOXYX/(EXP(AOXYX*CSTRQ(I,NY,NX)))
     2*EXP(0.516-0.0172*TCA(NY,NX))
      CNNQ(NY,NX)=CZ2GE(NY,NX)*SN2GX/(EXP(AN2GX*CSTRQ(I,NY,NX)))
     2*EXP(0.456-0.0152*TCA(NY,NX))
      CN2Q(NY,NX)=CZ2OE(NY,NX)*SN2OX/(EXP(AN2OX*CSTRQ(I,NY,NX)))
     2*EXP(0.897-0.0299*TCA(NY,NX))
9140  CONTINUE
9145  CONTINUE
C
C     RESET FLUX ARRAYS USED IN OTHER SUBROUTINES
C
      DO 9895 NX=NHW,NHE+1
      DO 9890 NY=NVN,NVS+1
      DO 9885 L=0,NL(NY,NX)+1
      DO 9880 N=1,3
      IF(L.EQ.0.AND.N.NE.3)THEN
      QR(N,NY,NX)=0.0
      HQR(N,NY,NX)=0.0
      QS(N,NY,NX)=0.0
      QW(N,NY,NX)=0.0
      QI(N,NY,NX)=0.0
      HQS(N,NY,NX)=0.0
      DO 9870 K=0,4
      XOCQRS(K,N,NY,NX)=0.0
      XONQRS(K,N,NY,NX)=0.0
      XOPQRS(K,N,NY,NX)=0.0
      XOAQRS(K,N,NY,NX)=0.0
9870  CONTINUE
      XCOQRS(N,NY,NX)=0.0
      XCHQRS(N,NY,NX)=0.0
      XOXQRS(N,NY,NX)=0.0
      XNGQRS(N,NY,NX)=0.0
      XN2QRS(N,NY,NX)=0.0
      XHGQRS(N,NY,NX)=0.0
      XN4QRW(N,NY,NX)=0.0
      XN3QRW(N,NY,NX)=0.0
      XNOQRW(N,NY,NX)=0.0
      XNXQRS(N,NY,NX)=0.0
      XP4QRW(N,NY,NX)=0.0
      XCOQSS(N,NY,NX)=0.0
      XCHQSS(N,NY,NX)=0.0
      XOXQSS(N,NY,NX)=0.0
      XNGQSS(N,NY,NX)=0.0
      XN2QSS(N,NY,NX)=0.0
      XN4QSS(N,NY,NX)=0.0
      XN3QSS(N,NY,NX)=0.0
      XNOQSS(N,NY,NX)=0.0
      XP4QSS(N,NY,NX)=0.0
      IF(IERSN(NY,NX).NE.0)THEN
      XSEDER(N,NY,NX)=0.0
      XSANER(N,NY,NX)=0.0
      XSILER(N,NY,NX)=0.0
      XCLAER(N,NY,NX)=0.0
      XCECER(N,NY,NX)=0.0
      XAECER(N,NY,NX)=0.0
      XNH4ER(N,NY,NX)=0.0
      XNH3ER(N,NY,NX)=0.0
      XNHUER(N,NY,NX)=0.0
      XNO3ER(N,NY,NX)=0.0
      XNH4EB(N,NY,NX)=0.0
      XNH3EB(N,NY,NX)=0.0
      XNHUEB(N,NY,NX)=0.0
      XNO3EB(N,NY,NX)=0.0
      XN4ER(N,NY,NX)=0.0
      XNBER(N,NY,NX)=0.0
      XHYER(N,NY,NX)=0.0
      XALER(N,NY,NX)=0.0
      XCAER(N,NY,NX)=0.0
      XMGER(N,NY,NX)=0.0
      XNAER(N,NY,NX)=0.0
      XKAER(N,NY,NX)=0.0
      XHCER(N,NY,NX)=0.0
      XAL2ER(N,NY,NX)=0.0
      XOH0ER(N,NY,NX)=0.0
      XOH1ER(N,NY,NX)=0.0
      XOH2ER(N,NY,NX)=0.0
      XH1PER(N,NY,NX)=0.0
      XH2PER(N,NY,NX)=0.0
      XOH0EB(N,NY,NX)=0.0
      XOH1EB(N,NY,NX)=0.0
      XOH2EB(N,NY,NX)=0.0
      XH1PEB(N,NY,NX)=0.0
      XH2PEB(N,NY,NX)=0.0
      PALOER(N,NY,NX)=0.0
      PFEOER(N,NY,NX)=0.0
      PCACER(N,NY,NX)=0.0
      PCASER(N,NY,NX)=0.0
      PALPER(N,NY,NX)=0.0
      PFEPER(N,NY,NX)=0.0
      PCPDER(N,NY,NX)=0.0
      PCPHER(N,NY,NX)=0.0
      PCPMER(N,NY,NX)=0.0
      PALPEB(N,NY,NX)=0.0
      PFEPEB(N,NY,NX)=0.0
      PCPDEB(N,NY,NX)=0.0
      PCPHEB(N,NY,NX)=0.0
      PCPMEB(N,NY,NX)=0.0
      DO 9480 K=0,5
      DO 9480 NN=1,7
      OMCER(3,NN,K,N,NY,NX)=0.0
      DO 9480 M=1,2
      OMCER(M,NN,K,N,NY,NX)=0.0
      OMNER(M,NN,K,N,NY,NX)=0.0
      OMPER(M,NN,K,N,NY,NX)=0.0
9480  CONTINUE
      DO 9475 K=0,4
      DO 9470 M=1,2
      ORCER(M,K,N,NY,NX)=0.0
      ORNER(M,K,N,NY,NX)=0.0
      ORPER(M,K,N,NY,NX)=0.0
9470  CONTINUE
      OHCER(K,N,NY,NX)=0.0
      OHNER(K,N,NY,NX)=0.0
      OHPER(K,N,NY,NX)=0.0
      DO 9465 M=1,4
      OSCER(M,K,N,NY,NX)=0.0
      OSAER(M,K,N,NY,NX)=0.0
      OSNER(M,K,N,NY,NX)=0.0
      OSPER(M,K,N,NY,NX)=0.0
9465  CONTINUE
9475  CONTINUE
      ENDIF
      ENDIF
      XCOFLS(N,L,NY,NX)=0.0
      XCHFLS(N,L,NY,NX)=0.0
      XOXFLS(N,L,NY,NX)=0.0
      XNGFLS(N,L,NY,NX)=0.0
      XN2FLS(N,L,NY,NX)=0.0
      XHGFLS(N,L,NY,NX)=0.0
      XN4FLW(N,L,NY,NX)=0.0
      XN3FLW(N,L,NY,NX)=0.0
      XNOFLW(N,L,NY,NX)=0.0
      XNXFLS(N,L,NY,NX)=0.0
      XH2PFS(N,L,NY,NX)=0.0
      DO 9860 K=0,4
      XOCFLS(K,N,L,NY,NX)=0.0
      XONFLS(K,N,L,NY,NX)=0.0
      XOPFLS(K,N,L,NY,NX)=0.0
      XOAFLS(K,N,L,NY,NX)=0.0
9860  CONTINUE
9880  CONTINUE
      IF(L.NE.0)THEN
      DO 9840 N=1,3
      FLW(N,L,NY,NX)=0.0
      FLWX(N,L,NY,NX)=0.0
      FLWH(N,L,NY,NX)=0.0
      HFLW(N,L,NY,NX)=0.0
      XN4FLB(N,L,NY,NX)=0.0
      XN3FLB(N,L,NY,NX)=0.0
      XNOFLB(N,L,NY,NX)=0.0
      XNXFLB(N,L,NY,NX)=0.0
      XH2BFB(N,L,NY,NX)=0.0
      XCOFHS(N,L,NY,NX)=0.0
      XCHFHS(N,L,NY,NX)=0.0
      XOXFHS(N,L,NY,NX)=0.0
      XNGFHS(N,L,NY,NX)=0.0
      XN2FHS(N,L,NY,NX)=0.0
      XHGFHS(N,L,NY,NX)=0.0
      XN4FHW(N,L,NY,NX)=0.0
      XN3FHW(N,L,NY,NX)=0.0
      XNOFHW(N,L,NY,NX)=0.0
      XNXFHS(N,L,NY,NX)=0.0
      XH2PHS(N,L,NY,NX)=0.0
      XN4FHB(N,L,NY,NX)=0.0
      XN3FHB(N,L,NY,NX)=0.0
      XNOFHB(N,L,NY,NX)=0.0
      XNXFHB(N,L,NY,NX)=0.0
      XH2BHB(N,L,NY,NX)=0.0
      XCOFLG(N,L,NY,NX)=0.0
      XCHFLG(N,L,NY,NX)=0.0
      XOXFLG(N,L,NY,NX)=0.0
      XNGFLG(N,L,NY,NX)=0.0
      XN2FLG(N,L,NY,NX)=0.0
      XN3FLG(N,L,NY,NX)=0.0
      XHGFLG(N,L,NY,NX)=0.0
      DO 9820 K=0,4
      XOCFHS(K,N,L,NY,NX)=0.0
      XONFHS(K,N,L,NY,NX)=0.0
      XOPFHS(K,N,L,NY,NX)=0.0
      XOAFHS(K,N,L,NY,NX)=0.0
9820  CONTINUE
9840  CONTINUE
      ENDIF
9885  CONTINUE
9890  CONTINUE
9895  CONTINUE
      DO 8895 NX=NHW,NHE+1
      DO 8890 NY=NVN,NVS+1
      IF(ISALT(NY,NX).NE.0)THEN
      DO 8885 L=1,NL(NY,NX)+1
      DO 8880 N=1,3
      IF(L.EQ.1.AND.N.NE.3)THEN
      XQRAL(N,NY,NX)=0.0
      XQRFE(N,NY,NX)=0.0
      XQRHY(N,NY,NX)=0.0
      XQRCA(N,NY,NX)=0.0
      XQRMG(N,NY,NX)=0.0
      XQRNA(N,NY,NX)=0.0
      XQRKA(N,NY,NX)=0.0
      XQROH(N,NY,NX)=0.0
      XQRSO(N,NY,NX)=0.0
      XQRCL(N,NY,NX)=0.0
      XQRC3(N,NY,NX)=0.0
      XQRHC(N,NY,NX)=0.0
      XQRAL1(N,NY,NX)=0.0
      XQRAL2(N,NY,NX)=0.0
      XQRAL3(N,NY,NX)=0.0
      XQRAL4(N,NY,NX)=0.0
      XQRALS(N,NY,NX)=0.0
      XQRFE1(N,NY,NX)=0.0
      XQRFE2(N,NY,NX)=0.0
      XQRFE3(N,NY,NX)=0.0
      XQRFE4(N,NY,NX)=0.0
      XQRFES(N,NY,NX)=0.0
      XQRCAO(N,NY,NX)=0.0
      XQRCAC(N,NY,NX)=0.0
      XQRCAH(N,NY,NX)=0.0
      XQRCAS(N,NY,NX)=0.0
      XQRMGO(N,NY,NX)=0.0
      XQRMGC(N,NY,NX)=0.0
      XQRMGH(N,NY,NX)=0.0
      XQRMGS(N,NY,NX)=0.0
      XQRNAC(N,NY,NX)=0.0
      XQRNAS(N,NY,NX)=0.0
      XQRKAS(N,NY,NX)=0.0
      XQRH0P(N,NY,NX)=0.0
      XQRH1P(N,NY,NX)=0.0
      XQRH3P(N,NY,NX)=0.0
      XQRF1P(N,NY,NX)=0.0
      XQRF2P(N,NY,NX)=0.0
      XQRC0P(N,NY,NX)=0.0
      XQRC1P(N,NY,NX)=0.0
      XQRC2P(N,NY,NX)=0.0
      XQRM1P(N,NY,NX)=0.0
      XQRH0B(N,NY,NX)=0.0
      XQRH1B(N,NY,NX)=0.0
      XQRH3B(N,NY,NX)=0.0
      XQRF1B(N,NY,NX)=0.0
      XQRF2B(N,NY,NX)=0.0
      XQRC0B(N,NY,NX)=0.0
      XQRC1B(N,NY,NX)=0.0
      XQRC2B(N,NY,NX)=0.0
      XQRM1B(N,NY,NX)=0.0
      XQSAL(N,NY,NX)=0.0
      XQSFE(N,NY,NX)=0.0
      XQSHY(N,NY,NX)=0.0
      XQSCA(N,NY,NX)=0.0
      XQSMG(N,NY,NX)=0.0
      XQSNA(N,NY,NX)=0.0
      XQSKA(N,NY,NX)=0.0
      XQSOH(N,NY,NX)=0.0
      XQSSO(N,NY,NX)=0.0
      XQSCL(N,NY,NX)=0.0
      XQSC3(N,NY,NX)=0.0
      XQSHC(N,NY,NX)=0.0
      XQSAL1(N,NY,NX)=0.0
      XQSAL2(N,NY,NX)=0.0
      XQSAL3(N,NY,NX)=0.0
      XQSAL4(N,NY,NX)=0.0
      XQSALS(N,NY,NX)=0.0
      XQSFE1(N,NY,NX)=0.0
      XQSFE2(N,NY,NX)=0.0
      XQSFE3(N,NY,NX)=0.0
      XQSFE4(N,NY,NX)=0.0
      XQSFES(N,NY,NX)=0.0
      XQSCAO(N,NY,NX)=0.0
      XQSCAC(N,NY,NX)=0.0
      XQSCAH(N,NY,NX)=0.0
      XQSCAS(N,NY,NX)=0.0
      XQSMGO(N,NY,NX)=0.0
      XQSMGC(N,NY,NX)=0.0
      XQSMGH(N,NY,NX)=0.0
      XQSMGS(N,NY,NX)=0.0
      XQSNAC(N,NY,NX)=0.0
      XQSNAS(N,NY,NX)=0.0
      XQSKAS(N,NY,NX)=0.0
      XQSH0P(N,NY,NX)=0.0
      XQSH1P(N,NY,NX)=0.0
      XQSH3P(N,NY,NX)=0.0
      XQSF1P(N,NY,NX)=0.0
      XQSF2P(N,NY,NX)=0.0
      XQSC0P(N,NY,NX)=0.0
      XQSC1P(N,NY,NX)=0.0
      XQSC2P(N,NY,NX)=0.0
      XQSM1P(N,NY,NX)=0.0
      XQSH0B(N,NY,NX)=0.0
      XQSH1B(N,NY,NX)=0.0
      XQSH3B(N,NY,NX)=0.0
      XQSF1B(N,NY,NX)=0.0
      XQSF2B(N,NY,NX)=0.0
      XQSC0B(N,NY,NX)=0.0
      XQSC1B(N,NY,NX)=0.0
      XQSC2B(N,NY,NX)=0.0
      XQSM1B(N,NY,NX)=0.0
      ENDIF
      XALFLS(N,L,NY,NX)=0.0
      XFEFLS(N,L,NY,NX)=0.0
      XHYFLS(N,L,NY,NX)=0.0
      XCAFLS(N,L,NY,NX)=0.0
      XMGFLS(N,L,NY,NX)=0.0
      XNAFLS(N,L,NY,NX)=0.0
      XKAFLS(N,L,NY,NX)=0.0
      XOHFLS(N,L,NY,NX)=0.0
      XSOFLS(N,L,NY,NX)=0.0
      XCLFLS(N,L,NY,NX)=0.0
      XC3FLS(N,L,NY,NX)=0.0
      XHCFLS(N,L,NY,NX)=0.0
      XAL1FS(N,L,NY,NX)=0.0
      XAL2FS(N,L,NY,NX)=0.0
      XAL3FS(N,L,NY,NX)=0.0
      XAL4FS(N,L,NY,NX)=0.0
      XALSFS(N,L,NY,NX)=0.0
      XFE1FS(N,L,NY,NX)=0.0
      XFE2FS(N,L,NY,NX)=0.0
      XFE3FS(N,L,NY,NX)=0.0
      XFE4FS(N,L,NY,NX)=0.0
      XFESFS(N,L,NY,NX)=0.0
      XCAOFS(N,L,NY,NX)=0.0
      XCACFS(N,L,NY,NX)=0.0
      XCAHFS(N,L,NY,NX)=0.0
      XCASFS(N,L,NY,NX)=0.0
      XMGOFS(N,L,NY,NX)=0.0
      XMGCFS(N,L,NY,NX)=0.0
      XMGHFS(N,L,NY,NX)=0.0
      XMGSFS(N,L,NY,NX)=0.0
      XNACFS(N,L,NY,NX)=0.0
      XNASFS(N,L,NY,NX)=0.0
      XKASFS(N,L,NY,NX)=0.0
      XH0PFS(N,L,NY,NX)=0.0
      XH1PFS(N,L,NY,NX)=0.0
      XH3PFS(N,L,NY,NX)=0.0
      XF1PFS(N,L,NY,NX)=0.0
      XF2PFS(N,L,NY,NX)=0.0
      XC0PFS(N,L,NY,NX)=0.0
      XC1PFS(N,L,NY,NX)=0.0
      XC2PFS(N,L,NY,NX)=0.0
      XM1PFS(N,L,NY,NX)=0.0
      XH0BFB(N,L,NY,NX)=0.0
      XH1BFB(N,L,NY,NX)=0.0
      XH3BFB(N,L,NY,NX)=0.0
      XF1BFB(N,L,NY,NX)=0.0
      XF2BFB(N,L,NY,NX)=0.0
      XC0BFB(N,L,NY,NX)=0.0
      XC1BFB(N,L,NY,NX)=0.0
      XC2BFB(N,L,NY,NX)=0.0
      XM1BFB(N,L,NY,NX)=0.0
      XALFHS(N,L,NY,NX)=0.0
      XFEFHS(N,L,NY,NX)=0.0
      XHYFHS(N,L,NY,NX)=0.0
      XCAFHS(N,L,NY,NX)=0.0
      XMGFHS(N,L,NY,NX)=0.0
      XNAFHS(N,L,NY,NX)=0.0
      XKAFHS(N,L,NY,NX)=0.0
      XOHFHS(N,L,NY,NX)=0.0
      XSOFHS(N,L,NY,NX)=0.0
      XCLFHS(N,L,NY,NX)=0.0
      XC3FHS(N,L,NY,NX)=0.0
      XHCFHS(N,L,NY,NX)=0.0
      XAL1HS(N,L,NY,NX)=0.0
      XAL2HS(N,L,NY,NX)=0.0
      XAL3HS(N,L,NY,NX)=0.0
      XAL4HS(N,L,NY,NX)=0.0
      XALSHS(N,L,NY,NX)=0.0
      XFE1HS(N,L,NY,NX)=0.0
      XFE2HS(N,L,NY,NX)=0.0
      XFE3HS(N,L,NY,NX)=0.0
      XFE4HS(N,L,NY,NX)=0.0
      XFESHS(N,L,NY,NX)=0.0
      XCAOHS(N,L,NY,NX)=0.0
      XCACHS(N,L,NY,NX)=0.0
      XCAHHS(N,L,NY,NX)=0.0
      XCASHS(N,L,NY,NX)=0.0
      XMGOHS(N,L,NY,NX)=0.0
      XMGCHS(N,L,NY,NX)=0.0
      XMGHHS(N,L,NY,NX)=0.0
      XMGSHS(N,L,NY,NX)=0.0
      XNACHS(N,L,NY,NX)=0.0
      XNASHS(N,L,NY,NX)=0.0
      XKASHS(N,L,NY,NX)=0.0
      XH0PHS(N,L,NY,NX)=0.0
      XH1PHS(N,L,NY,NX)=0.0
      XH3PHS(N,L,NY,NX)=0.0
      XF1PHS(N,L,NY,NX)=0.0
      XF2PHS(N,L,NY,NX)=0.0
      XC0PHS(N,L,NY,NX)=0.0
      XC1PHS(N,L,NY,NX)=0.0
      XC2PHS(N,L,NY,NX)=0.0
      XM1PHS(N,L,NY,NX)=0.0
      XH0BHB(N,L,NY,NX)=0.0
      XH1BHB(N,L,NY,NX)=0.0
      XH3BHB(N,L,NY,NX)=0.0
      XF1BHB(N,L,NY,NX)=0.0
      XF2BHB(N,L,NY,NX)=0.0
      XC0BHB(N,L,NY,NX)=0.0
      XC1BHB(N,L,NY,NX)=0.0
      XC2BHB(N,L,NY,NX)=0.0
      XM1BHB(N,L,NY,NX)=0.0
8880  CONTINUE
8885  CONTINUE
      ENDIF
8890  CONTINUE
8895  CONTINUE
C
C     RESET SOIL PROPERTIES AND PEDOTRANSFER FUNCTIONS
C     FOLLOWING ANY SOIL DISTURBANCE
C
      DO 9995 NX=NHW,NHE
      DO 9990 NY=NVN,NVS
      IFLGX(NY,NX)=IFLGT(NY,NX)
      IF(J.EQ.1)THEN
      IFLGT(NY,NX)=0
      DO 9905 NZ=1,NP(NY,NX)
      PSILZ(NZ,NY,NX)=0.0
9905  CONTINUE
      ENDIF
      IF(BKDS(NU(NY,NX),NY,NX).LT.ZERO)THEN
      VOLT(NU(NY,NX),NY,NX)=VOLW(NU(NY,NX),NY,NX)+VOLI(NU(NY,NX),NY,NX)
     2+VOLWH(NU(NY,NX),NY,NX)+VOLIH(NU(NY,NX),NY,NX)
      VOLX(NU(NY,NX),NY,NX)=VOLT(NU(NY,NX),NY,NX)*FMPR(NU(NY,NX),NY,NX)
      DLYR(3,NU(NY,NX),NY,NX)=VOLT(NU(NY,NX),NY,NX)
     2/AREA(3,NU(NY,NX),NY,NX)
      ENDIF
C
C     RESET SOIL PHYSICAL PROPERTIES (DENSITY, TEXTURE)
C     AFTER DISTURBANCES (E.G. TILLAGE, EROSION)
C
      IF(IFLGS(NY,NX).NE.0)THEN
      DO 9975 L=NU(NY,NX),NL(NY,NX)
      VOLT(L,NY,NX)=AREA(3,L,NY,NX)*DLYR(3,L,NY,NX)
      VOLX(L,NY,NX)=VOLT(L,NY,NX)*FMPR(L,NY,NX)
      BKDS(L,NY,NX)=AMIN1(0.99*BKDSX,BKDS(L,NY,NX))
      BKVL(L,NY,NX)=BKDS(L,NY,NX)*VOLX(L,NY,NX)
      IF(BKVL(L,NY,NX).GT.0.0)THEN
      CORGC(L,NY,NX)=AMIN1(0.5E+06,ORGC(L,NY,NX)/BKVL(L,NY,NX))
      CSAND(L,NY,NX)=SAND(L,NY,NX)/BKVL(L,NY,NX)
      CSILT(L,NY,NX)=SILT(L,NY,NX)/BKVL(L,NY,NX)
      CCLAY(L,NY,NX)=CLAY(L,NY,NX)/BKVL(L,NY,NX)
      ELSE
      CORGC(L,NY,NX)=0.0
      CSAND(L,NY,NX)=0.0
      CSILT(L,NY,NX)=0.0
      CCLAY(L,NY,NX)=0.0
      ENDIF
      CORGCM=2.0E-06*CORGC(L,NY,NX) 
      PTDS=1.30*CORGCM+2.66*(1.0-CORGCM)
      IF(L.EQ.NU(NY,NX))THEN
      POROS(L,NY,NX)=AMAX1(POROS(L,NY,NX),1.0-(BKDS(L,NY,NX)/PTDS))
      ELSE
      POROS(L,NY,NX)=1.0-(BKDS(L,NY,NX)/PTDS)
      ENDIF
      POROQ(L,NY,NX)=POROS(L,NY,NX)**0.667
      VOLA(L,NY,NX)=POROS(L,NY,NX)*VOLX(L,NY,NX)
      VOLAH(L,NY,NX)=FHOL(L,NY,NX)*VOLT(L,NY,NX)
      VOLP(L,NY,NX)=AMAX1(0.0,VOLA(L,NY,NX)-VOLW(L,NY,NX)
     2-VOLI(L,NY,NX))+AMAX1(0.0,VOLAH(L,NY,NX)-VOLWH(L,NY,NX)
     3-VOLIH(L,NY,NX))
      EHUM(L,NY,NX)=0.250+0.250*CCLAY(L,NY,NX)
      EPOC(L,NY,NX)=1.0
      IF(CORGC(L,NY,NX).GT.FORGC)THEN
      SRP(L,NY,NX)=0.80
      ELSEIF(CORGC(L,NY,NX).GT.0.5*FORGC)THEN
      SRP(L,NY,NX)=0.90
      ELSE
      SRP(L,NY,NX)=1.0
      ENDIF
C
C     SOIL HYDROLOGIC PROPERTIES (FIELD CAPACITY, WILTING POINT)
C
      IF(ISOIL(1,L,NY,NX).EQ.1.OR.ISOIL(2,L,NY,NX).EQ.1)THEN
      IF(DATA(20).EQ.'NO')THEN
      IF(ISOIL(1,L,NY,NX).EQ.1)THEN
      IF(CORGC(L,NY,NX).LT.FORGW)THEN
      FC(L,NY,NX)=0.2576-0.20*CSAND(L,NY,NX)
     2+0.36*CCLAY(L,NY,NX)+0.60E-06*CORGC(L,NY,NX)
      ELSE
      IF(BKDS(L,NY,NX).LT.0.075)THEN
      FC(L,NY,NX)=0.27
      ELSEIF(BKDS(L,NY,NX).LT.0.195)THEN
      FC(L,NY,NX)=0.62
      ELSE
      FC(L,NY,NX)=0.71
      ENDIF
      ENDIF
      FC(L,NY,NX)=FC(L,NY,NX)/(1.0-FHOL(L,NY,NX))
      FC(L,NY,NX)=AMIN1(0.75*POROS(L,NY,NX),FC(L,NY,NX))
      ENDIF
      IF(ISOIL(2,L,NY,NX).EQ.1)THEN
      IF(CORGC(L,NY,NX).LT.FORGW)THEN
      WP(L,NY,NX)=0.0260+0.50*CCLAY(L,NY,NX)
     2+0.32E-06*CORGC(L,NY,NX)
      ELSE
      IF(BKDS(L,NY,NX).LT.0.075)THEN
      WP(L,NY,NX)=0.04
      ELSEIF(BKDS(L,NY,NX).LT.0.195)THEN
      WP(L,NY,NX)=0.15
      ELSE
      WP(L,NY,NX)=0.22
      ENDIF
      ENDIF
      WP(L,NY,NX)=WP(L,NY,NX)/(1.0-FHOL(L,NY,NX))
      WP(L,NY,NX)=AMIN1(0.75*FC(L,NY,NX),WP(L,NY,NX))
      ENDIF
      ENDIF
      IF(THW(L,NY,NX).GT.1.0)THEN
      THW(L,NY,NX)=POROS(L,NY,NX)
      ELSEIF(THW(L,NY,NX).EQ.1.0)THEN 
      THW(L,NY,NX)=FC(L,NY,NX)
      ELSEIF(THW(L,NY,NX).LE.0.0)THEN 
      THW(L,NY,NX)=WP(L,NY,NX)
      ENDIF
      IF(THI(L,NY,NX).GT.1.0)THEN
      THI(L,NY,NX)=AMAX1(0.0,AMIN1(POROS(L,NY,NX)
     2,POROS(L,NY,NX)-THW(L,NY,NX)))
      ELSEIF(THI(L,NY,NX).EQ.1.0)THEN 
      THI(L,NY,NX)=AMAX1(0.0,AMIN1(FC(L,NY,NX)
     2,POROS(L,NY,NX)-THW(L,NY,NX)))
      ELSEIF(THI(L,NY,NX).LT.0.0)THEN 
      THI(L,NY,NX)=AMAX1(0.0,AMIN1(WP(L,NY,NX)
     2,POROS(L,NY,NX)-THW(L,NY,NX)))
      ENDIF
      IF(DATA(20).EQ.'NO')THEN
      THETW(L,NY,NX)=THW(L,NY,NX)
      VOLW(L,NY,NX)=THETW(L,NY,NX)*VOLX(L,NY,NX)
      VOLWX(L,NY,NX)=VOLW(L,NY,NX)
      VOLWH(L,NY,NX)=THETW(L,NY,NX)*VOLAH(L,NY,NX)
      THETI(L,NY,NX)=THI(L,NY,NX)
      VOLI(L,NY,NX)=THETI(L,NY,NX)*VOLX(L,NY,NX)
      VOLIH(L,NY,NX)=THETI(L,NY,NX)*VOLAH(L,NY,NX)
      ENDIF
      ENDIF
      PSL(L,NY,NX)=LOG(POROS(L,NY,NX))
      FCL(L,NY,NX)=LOG(FC(L,NY,NX))
      WPL(L,NY,NX)=LOG(WP(L,NY,NX))
      PSD(L,NY,NX)=PSL(L,NY,NX)-FCL(L,NY,NX)
      FCD(L,NY,NX)=FCL(L,NY,NX)-WPL(L,NY,NX)
      VOLP(L,NY,NX)=AMAX1(0.0,VOLA(L,NY,NX)-VOLW(L,NY,NX)
     2-VOLI(L,NY,NX))+AMAX1(0.0,VOLAH(L,NY,NX)-VOLWH(L,NY,NX)
     3-VOLIH(L,NY,NX))
      THETP(L,NY,NX)=VOLP(L,NY,NX)/VOLT(L,NY,NX)
      THETY(L,NY,NX)=EXP((PSIMX(NY,NX)-LOG(-HYGR))
     2*FCD(L,NY,NX)/PSIMD(NY,NX)+FCL(L,NY,NX))
C
C     SATURATED HYDRAULIC CONDUCTIVITY FROM SWC AT SATURATION VS.
C     -0.033 MPA (MINERAL SOILS) IF NOT ENTERED IN 'READS'
C
      IF(ISOIL(3,L,NY,NX).EQ.1)THEN
      IF(CORGC(L,NY,NX).LT.FORGW)THEN
      THETF=AMIN1(POROS(L,NY,NX),EXP((PSIMS(NY,NX)-LOG(0.033))
     2*(PSL(L,NY,NX)-FCL(L,NY,NX))/PSISD(NY,NX)+PSL(L,NY,NX)))
      SCNV(L,NY,NX)=1.54*((POROS(L,NY,NX)-THETF)/THETF)**2
      ELSE
      SCNV(L,NY,NX)=0.10+75.0*1.0E-15**BKDS(L,NY,NX)
      SCNV(L,NY,NX)=SCNV(L,NY,NX)*FMPR(L,NY,NX)
      ENDIF
      ENDIF
      IF(ISOIL(4,L,NY,NX).EQ.1)THEN
      IF(CORGC(L,NY,NX).LT.FORGW)THEN
      THETF=AMIN1(POROS(L,NY,NX),EXP((PSIMS(NY,NX)-LOG(0.033))
     2*(PSL(L,NY,NX)-FCL(L,NY,NX))/PSISD(NY,NX)+PSL(L,NY,NX)))
      SCNH(L,NY,NX)=1.54*((POROS(L,NY,NX)-THETF)/THETF)**2
      ELSE
      SCNH(L,NY,NX)=0.10+75.0*1.0E-15**BKDS(L,NY,NX)
      SCNH(L,NY,NX)=SCNH(L,NY,NX)*FMPR(L,NY,NX)
      ENDIF
      ENDIF
C     WRITE(*,3333)'PPTYS',I,J,NX,NY,L,ISOIL(1,L,NY,NX)
C    2,ISOIL(2,L,NY,NX),ISOIL(3,L,NY,NX),ISOIL(4,L,NY,NX)
C    3,SCNV(L,NY,NX),POROS(L,NY,NX),THETF
C    2,FC(L,NY,NX),WP(L,NY,NX),BKDS(L,NY,NX),THW(L,NY,NX)
C    3,THETW(L,NY,NX),THI(L,NY,NX),THETI(L,NY,NX)
3333  FORMAT(A8,9I4,20E12.4)
C
C     HYDRAULIC CONDUCTIVITY FUNCTION FROM KSAT AND SOIL WATER RELEASE CURVE
C
      IF(BKVL(L,NY,NX).GT.0.0)THEN
      SUM2=0.0
      DO 1320 K=1,100
      XK=K-1
      THETK=POROS(L,NY,NX)-(XK/100.0*POROS(L,NY,NX))
      IF(THETK.LT.FC(L,NY,NX))THEN
      PSISK(K)=AMAX1(HYGR,-EXP(PSIMX(NY,NX)
     2+((FCL(L,NY,NX)-LOG(THETK))
     3/FCD(L,NY,NX)*PSIMD(NY,NX))))
      ELSEIF(THETK.LT.POROS(L,NY,NX)-DTHETW)THEN 
      PSISK(K)=-EXP(PSIMS(NY,NX)
     2+(((PSL(L,NY,NX)-LOG(THETK))
     3/PSD(L,NY,NX))**SRP(L,NY,NX)*PSISD(NY,NX)))
      ELSE
      PSISK(K)=PSISE(L,NY,NX)
      ENDIF
      SUM2=SUM2+(2*K-1)/(PSISK(K)**2)
C     WRITE(*,3536)'PSI',L,K,PSISK(K),THETK,POROS(L,NY,NX)
C    2,PSL(L,NY,NX),LOG(THETK),FC(L,NY,NX),WP(L,NY,NX),SRP(L,NY,NX)
3536  FORMAT(A8,2I4,12E12.4)
1320  CONTINUE
      DO 1335 K=1,100
      SUM1=0.0
      XK=K-1
      YK=((100.0-XK)/100.0)**1.33
      DO 1330 M=K,100
      SUM1=SUM1+(2*M+1-2*K)/(PSISK(M)**2)
1330  CONTINUE
      DO 1340 N=1,3
      IF(N.EQ.3)THEN
      HCND(N,K,L,NY,NX)=SCNV(L,NY,NX)*YK*SUM1/SUM2
      ELSE
      HCND(N,K,L,NY,NX)=SCNH(L,NY,NX)*YK*SUM1/SUM2
      ENDIF
1340  CONTINUE
1335  CONTINUE
      ELSE
      DO 2335 K=1,100
      DO 2340 N=1,3
      IF(N.EQ.3)THEN
      HCND(N,K,L,NY,NX)=SCNV(L,NY,NX)
      ELSE
      HCND(N,K,L,NY,NX)=SCNH(L,NY,NX)
      ENDIF
2340  CONTINUE
2335  CONTINUE
      ENDIF
C
C     SOIL MACROPORE DIMENSIONS AND CONDUCTIVITY FROM MACROPORE FRACTION
C     ENTERED IN 'READS'
C
      HRAD(L,NY,NX)=1.0E-03
      NHOL(L,NY,NX)=INT(VOLAH(L,NY,NX)/(3.1416*HRAD(L,NY,NX)**2
     2*VOLT(L,NY,NX)))
C     IF(L.GT.NU(NY,NX))THEN
C     NHOL(L,NY,NX)=MIN(NHOL(L,NY,NX),NHOL(L-1,NY,NX))
C     ENDIF
      CNDH(L,NY,NX)=1.0E-02*3.1416*HRAD(L,NY,NX)**4/(8.0*VISC)
C
C     SOIL HEAT CAPACITY AND THERMAL CONDUCTIVITY OF SOLID PHASE
C     FROM SOC AND TEXTURE
C
      VORGC=CORGCM*BKDS(L,NY,NX)/PTDS
      VMINL=(CSILT(L,NY,NX)+CCLAY(L,NY,NX))*BKDS(L,NY,NX)/PTDS
      VSAND=CSAND(L,NY,NX)*BKDS(L,NY,NX)/PTDS
      STC(L,NY,NX)=(1.253*VORGC*9.050E-04+0.514*VMINL*1.056E-02
     2+0.514*VSAND*1.056E-02)*FMPR(L,NY,NX)
     3+0.514*ROCK(L,NY,NX)*1.056E-02
      DTC(L,NY,NX)=(1.253*VORGC+0.514*VMINL+0.514*VSAND)
     2*FMPR(L,NY,NX)+0.514*ROCK(L,NY,NX)
C     VHCM(L,NY,NX)=((2.496*VORGC+2.385*VMINL+2.128*VSAND)
C    2*FMPR(L,NY,NX)+2.128*ROCK(L,NY,NX))
C    3*AREA(3,L,NY,NX)*DLYR(3,L,NY,NX)
9975  CONTINUE
C
C     SURFACE RESIDUE PROPERTIES
C
      CORGC(0,NY,NX)=0.5E+06
      THETY(0,NY,NX)=0.0
C
C     SOIL SURFACE WATER STORAGE CAPACITY
C
      DS=AMAX1(0.001,0.112*ZS(NY,NX)+3.10*ZS(NY,NX)**2
     2-0.012*ZS(NY,NX)*SL(NY,NX)/57.29578)
      VOLWG(NY,NX)=AMAX1(DS,-DTBLX(NY,NX))*AREA(3,NU(NY,NX),NY,NX)
      DPTH(NU(NY,NX),NY,NX)=CDPTH(NU(NY,NX),NY,NX)
     2-0.5*DLYR(3,NU(NY,NX),NY,NX)
      YDPTH(NU(NY,NX),NY,NX)=ALT(NY,NX)-DPTH(NU(NY,NX),NY,NX)
      IF(BKVL(NU(NY,NX),NY,NX).GT.0.0)THEN
      CCLAY(NU(NY,NX),NY,NX)=CLAY(NU(NY,NX),NY,NX)/BKVL(NU(NY,NX),NY,NX)
      CSILT(NU(NY,NX),NY,NX)=SILT(NU(NY,NX),NY,NX)/BKVL(NU(NY,NX),NY,NX)
      CSAND(NU(NY,NX),NY,NX)=SAND(NU(NY,NX),NY,NX)/BKVL(NU(NY,NX),NY,NX)
      ELSE
      CCLAY(NU(NY,NX),NY,NX)=0.0
      CSILT(NU(NY,NX),NY,NX)=0.0
      CSAND(NU(NY,NX),NY,NX)=0.0
      ENDIF
      EHUM(0,NY,NX)=0.250+0.250*CCLAY(NU(NY,NX),NY,NX)
      EPOC(0,NY,NX)=0.150
C
C     PARAMETERS FOR SOIL COHESION, EROSIVITY, AND ROUGHNESS USED
C     FOR SURFACE WATER AND SEDIMENT TRANSPORT IN 'EROSION'
C
      DETS(NY,NX)=1.0+2.0*(1.0-CSILT(NU(NY,NX),NY,NX))
      D50=1.0*CCLAY(NU(NY,NX),NY,NX)+10.0*CSILT(NU(NY,NX),NY,NX)
     2+100.0*CSAND(NU(NY,NX),NY,NX)
      CER(NY,NX)=((D50+5.0)/0.32)**(-0.6)
      XER(NY,NX)=((D50+5.0)/300.0)**0.25
      ZD50(NY,NX)=0.041*(1.0E-06*D50)**0.167
      IFLGS(NY,NX)=0
      ENDIF
      COHS(NY,NX)=2.0+2.0E-04*CORGC(NU(NY,NX),NY,NX)
C    2+1.0E-04*RTDNT(NU(NY,NX),NY,NX)
      ORGCX=ORGC(0,NY,NX)/AREA(3,0,NY,NX)
      ZM(NY,NX)=ZS(NY,NX)+ZD50(NY,NX)+2.0E-04*ORGCX
C
C     RESET HOURLY ACCUMULATORS
C
      UCO2S(NY,NX)=0.0
      XDTSED(NY,NX)=0.0
      TOMT(NY,NX)=0.0
      TONT(NY,NX)=0.0
      TOPT(NY,NX)=0.0
      UVOLW(NY,NX)=0.0
      URSDC(NY,NX)=0.0
      UORGC(NY,NX)=0.0
      URSDN(NY,NX)=0.0
      UORGN(NY,NX)=0.0
      URSDP(NY,NX)=0.0
      UORGP(NY,NX)=0.0
      UNH4(NY,NX)=0.0
      UNO3(NY,NX)=0.0
      UPO4(NY,NX)=0.0
      UPP4(NY,NX)=0.0
      UION(NY,NX)=0.0
      HVOLO(NY,NX)=0.0
      HCO2G(NY,NX)=0.0
      HCH4G(NY,NX)=0.0
      HOXYG(NY,NX)=0.0
      HN2GG(NY,NX)=0.0
      HN2OG(NY,NX)=0.0
      HNH3G(NY,NX)=0.0
      FLWR(NY,NX)=0.0
      HFLWR(NY,NX)=0.0
      FLWSI(NY,NX)=0.0
      HFLWSI(NY,NX)=0.0
      TFLWW(NY,NX)=0.0
      TFLWS(NY,NX)=0.0
      TFLWI(NY,NX)=0.0
      THFLWW(NY,NX)=0.0
      HTHAWW(NY,NX)=0.0
      THAWR(NY,NX)=0.0
      HTHAWR(NY,NX)=0.0
      HEATI(NY,NX)=0.0
      HEATS(NY,NX)=0.0
      HEATE(NY,NX)=0.0
      HEATV(NY,NX)=0.0
      HEATH(NY,NX)=0.0
      TEVAPG(NY,NX)=0.0
      XCODFS(NY,NX)=0.0
      XCHDFS(NY,NX)=0.0
      XOXDFS(NY,NX)=0.0
      XNGDFS(NY,NX)=0.0
      XN2DFS(NY,NX)=0.0
      XN3DFS(NY,NX)=0.0
      XNBDFS(NY,NX)=0.0
      XHGDFS(NY,NX)=0.0
      XCODFR(NY,NX)=0.0
      XCHDFR(NY,NX)=0.0
      XOXDFR(NY,NX)=0.0
      XNGDFR(NY,NX)=0.0
      XN2DFR(NY,NX)=0.0
      XN3DFR(NY,NX)=0.0
      XHGDFR(NY,NX)=0.0
      TVOLWP(NY,NX)=0.0
      TVOLWC(NY,NX)=0.0
      TFLWC(NY,NX)=0.0
      TEVAPP(NY,NX)=0.0
      TEVAPC(NY,NX)=0.0
      THFLXC(NY,NX)=0.0
      TENGYC(NY,NX)=0.0
      TCO2Z(NY,NX)=0.0
      TOXYZ(NY,NX)=0.0
      TCH4Z(NY,NX)=0.0
      TN2OZ(NY,NX)=0.0
      TNH3Z(NY,NX)=0.0
      TH2GZ(NY,NX)=0.0
      ZCSNC(NY,NX)=0.0
      ZZSNC(NY,NX)=0.0
      ZPSNC(NY,NX)=0.0
      WTSTGT(NY,NX)=0.0
      PPT(NY,NX)=0.0
C
C     RESET ARRAYS TO TRANSFER MATERIALS WITHIN SOILS
C     AND BETWEEN SOILS AND PLANTS
C
      DO 9875 L=0,NL(NY,NX)
      DO 9950 K=0,1
      DO 9950 M=1,4
      CSNT(M,K,L,NY,NX)=0.0
      ZSNT(M,K,L,NY,NX)=0.0
      PSNT(M,K,L,NY,NX)=0.0
9950  CONTINUE
      DO 7775 K=0,4
      XOQCS(K,L,NY,NX)=0.0
      XOQNS(K,L,NY,NX)=0.0
      XOQPS(K,L,NY,NX)=0.0
      XOQAS(K,L,NY,NX)=0.0
7775  CONTINUE
      TRN4S(L,NY,NX)=0.0
      TRN3S(L,NY,NX)=0.0
      TRN3G(L,NY,NX)=0.0
      TRNO3(L,NY,NX)=0.0
      TRNO2(L,NY,NX)=0.0
      TRH2P(L,NY,NX)=0.0
      TRXN4(L,NY,NX)=0.0
      TRXH0(L,NY,NX)=0.0
      TRXH1(L,NY,NX)=0.0
      TRXH2(L,NY,NX)=0.0
      TRX1P(L,NY,NX)=0.0
      TRX2P(L,NY,NX)=0.0
      TRALPO(L,NY,NX)=0.0
      TRFEPO(L,NY,NX)=0.0
      TRCAPD(L,NY,NX)=0.0
      TRCAPH(L,NY,NX)=0.0
      TRCAPM(L,NY,NX)=0.0
      TRH2O(L,NY,NX)=0.0
      TBNH4(L,NY,NX)=0.0
      TBNH3(L,NY,NX)=0.0
      TBNO3(L,NY,NX)=0.0
      TBH2P(L,NY,NX)=0.0
      TBION(L,NY,NX)=0.0
      TUPWTR(L,NY,NX)=0.0
      TUPHT(L,NY,NX)=0.0
      XCODFG(L,NY,NX)=0.0
      XCHDFG(L,NY,NX)=0.0
      XOXDFG(L,NY,NX)=0.0
      XNGDFG(L,NY,NX)=0.0
      XN2DFG(L,NY,NX)=0.0
      XN3DFG(L,NY,NX)=0.0
      XN34SQ(L,NY,NX)=0.0
      XNBDFG(L,NY,NX)=0.0
      XN34BQ(L,NY,NX)=0.0
      XHGDFG(L,NY,NX)=0.0
      TDFOMC(L,NY,NX)=0.0
      TDFOMN(L,NY,NX)=0.0
      TDFOMP(L,NY,NX)=0.0
      DO 9795 M=1,NPH
      ROXSK(M,L,NY,NX)=0.0
9795  CONTINUE
9875  CONTINUE
      IFLGL=0
      IFLGY=0
      ICHKA=0
      DO 9985 L=NU(NY,NX),NL(NY,NX)
      FINH(L,NY,NX)=0.0
      FLWV(L,NY,NX)=0.0
      TCO2S(L,NY,NX)=0.0
      TCO2P(L,NY,NX)=0.0
      TCOFLA(L,NY,NX)=0.0
      TCHFLA(L,NY,NX)=0.0
      TLCO2P(L,NY,NX)=0.0
      TUPOXP(L,NY,NX)=0.0
      TUPOXS(L,NY,NX)=0.0
      TUPCHS(L,NY,NX)=0.0
      TUPN2S(L,NY,NX)=0.0
      TUPN3S(L,NY,NX)=0.0
      TUPN3B(L,NY,NX)=0.0
      TUPHGS(L,NY,NX)=0.0
      TOXFLA(L,NY,NX)=0.0
      TCHFLA(L,NY,NX)=0.0
      TN2FLA(L,NY,NX)=0.0
      TNHFLA(L,NY,NX)=0.0
      THGFLA(L,NY,NX)=0.0
      TLOXYP(L,NY,NX)=0.0
      TLCH4P(L,NY,NX)=0.0
      TLN2OP(L,NY,NX)=0.0
      TLNH3P(L,NY,NX)=0.0
      TLH2GP(L,NY,NX)=0.0
      TUPNH4(L,NY,NX)=0.0
      TUPNO3(L,NY,NX)=0.0
      TUPH2P(L,NY,NX)=0.0
      TUPNHB(L,NY,NX)=0.0
      TUPNOB(L,NY,NX)=0.0
      TUPH2B(L,NY,NX)=0.0
      TUPNF(L,NY,NX)=0.0
      TRN4B(L,NY,NX)=0.0
      TRN3B(L,NY,NX)=0.0
      TRNOB(L,NY,NX)=0.0
      TRN2B(L,NY,NX)=0.0
      TRH2B(L,NY,NX)=0.0
      TRAL(L,NY,NX)=0.0
      TRFE(L,NY,NX)=0.0
      TRHY(L,NY,NX)=0.0
      TRCA(L,NY,NX)=0.0
      TRMG(L,NY,NX)=0.0
      TRNA(L,NY,NX)=0.0
      TRKA(L,NY,NX)=0.0
      TROH(L,NY,NX)=0.0
      TRSO4(L,NY,NX)=0.0
      TRCO3(L,NY,NX)=0.0
      TRHCO(L,NY,NX)=0.0
      TBCO2(L,NY,NX)=0.0
      TRAL1(L,NY,NX)=0.0
      TRAL2(L,NY,NX)=0.0
      TRAL3(L,NY,NX)=0.0
      TRAL4(L,NY,NX)=0.0
      TRALS(L,NY,NX)=0.0
      TRFE1(L,NY,NX)=0.0
      TRFE2(L,NY,NX)=0.0
      TRFE3(L,NY,NX)=0.0
      TRFE4(L,NY,NX)=0.0
      TRFES(L,NY,NX)=0.0
      TRCAO(L,NY,NX)=0.0
      TRCAC(L,NY,NX)=0.0
      TRCAH(L,NY,NX)=0.0
      TRCAS(L,NY,NX)=0.0
      TRMGO(L,NY,NX)=0.0
      TRMGC(L,NY,NX)=0.0
      TRMGH(L,NY,NX)=0.0
      TRMGS(L,NY,NX)=0.0
      TRNAC(L,NY,NX)=0.0
      TRNAS(L,NY,NX)=0.0
      TRKAS(L,NY,NX)=0.0
      TRH0P(L,NY,NX)=0.0
      TRH1P(L,NY,NX)=0.0
      TRH3P(L,NY,NX)=0.0
      TRC0P(L,NY,NX)=0.0
      TRF1P(L,NY,NX)=0.0
      TRF2P(L,NY,NX)=0.0
      TRC1P(L,NY,NX)=0.0
      TRC2P(L,NY,NX)=0.0
      TRM1P(L,NY,NX)=0.0
      TRH0B(L,NY,NX)=0.0
      TRH1B(L,NY,NX)=0.0
      TRH3B(L,NY,NX)=0.0
      TRF1B(L,NY,NX)=0.0
      TRF2B(L,NY,NX)=0.0
      TRC0B(L,NY,NX)=0.0
      TRC1B(L,NY,NX)=0.0
      TRC2B(L,NY,NX)=0.0
      TRM1B(L,NY,NX)=0.0
      TRXNB(L,NY,NX)=0.0
      TRXHY(L,NY,NX)=0.0
      TRXAL(L,NY,NX)=0.0
      TRXCA(L,NY,NX)=0.0
      TRXMG(L,NY,NX)=0.0
      TRXNA(L,NY,NX)=0.0
      TRXKA(L,NY,NX)=0.0
      TRXHC(L,NY,NX)=0.0
      TRXAL2(L,NY,NX)=0.0
      TRBH0(L,NY,NX)=0.0
      TRBH1(L,NY,NX)=0.0
      TRBH2(L,NY,NX)=0.0
      TRB1P(L,NY,NX)=0.0
      TRB2P(L,NY,NX)=0.0
      TRALOH(L,NY,NX)=0.0
      TRFEOH(L,NY,NX)=0.0
      TRCACO(L,NY,NX)=0.0
      TRCASO(L,NY,NX)=0.0
      TRALPB(L,NY,NX)=0.0
      TRFEPB(L,NY,NX)=0.0
      TRCPDB(L,NY,NX)=0.0
      TRCPHB(L,NY,NX)=0.0
      TRCPMB(L,NY,NX)=0.0
      XCOFXS(L,NY,NX)=0.0
      XCHFXS(L,NY,NX)=0.0
      XOXFXS(L,NY,NX)=0.0
      XNGFXS(L,NY,NX)=0.0
      XN2FXS(L,NY,NX)=0.0
      XHGFXS(L,NY,NX)=0.0
      XN4FXW(L,NY,NX)=0.0
      XN3FXW(L,NY,NX)=0.0
      XNOFXW(L,NY,NX)=0.0
      XNXFXS(L,NY,NX)=0.0
      XH2PXS(L,NY,NX)=0.0
      XN4FXB(L,NY,NX)=0.0
      XN3FXB(L,NY,NX)=0.0
      XNOFXB(L,NY,NX)=0.0
      XNXFXB(L,NY,NX)=0.0
      XH2BXB(L,NY,NX)=0.0
      XALFXS(L,NY,NX)=0.0
      XFEFXS(L,NY,NX)=0.0
      XHYFXS(L,NY,NX)=0.0
      XCAFXS(L,NY,NX)=0.0
      XMGFXS(L,NY,NX)=0.0
      XNAFXS(L,NY,NX)=0.0
      XKAFXS(L,NY,NX)=0.0
      XOHFXS(L,NY,NX)=0.0
      XSOFXS(L,NY,NX)=0.0
      XCLFXS(L,NY,NX)=0.0
      XC3FXS(L,NY,NX)=0.0
      XHCFXS(L,NY,NX)=0.0
      XAL1XS(L,NY,NX)=0.0
      XAL2XS(L,NY,NX)=0.0
      XAL3XS(L,NY,NX)=0.0
      XAL4XS(L,NY,NX)=0.0
      XALSXS(L,NY,NX)=0.0
      XFE1XS(L,NY,NX)=0.0
      XFE2XS(L,NY,NX)=0.0
      XFE3XS(L,NY,NX)=0.0
      XFE4XS(L,NY,NX)=0.0
      XFESXS(L,NY,NX)=0.0
      XCAOXS(L,NY,NX)=0.0
      XCACXS(L,NY,NX)=0.0
      XCAHXS(L,NY,NX)=0.0
      XCASXS(L,NY,NX)=0.0
      XMGOXS(L,NY,NX)=0.0
      XMGCXS(L,NY,NX)=0.0
      XMGHXS(L,NY,NX)=0.0
      XMGSXS(L,NY,NX)=0.0
      XNACXS(L,NY,NX)=0.0
      XNASXS(L,NY,NX)=0.0
      XKASXS(L,NY,NX)=0.0
      XH0PXS(L,NY,NX)=0.0
      XH1PXS(L,NY,NX)=0.0
      XH3PXS(L,NY,NX)=0.0
      XF1PXS(L,NY,NX)=0.0
      XF2PXS(L,NY,NX)=0.0
      XC0PXS(L,NY,NX)=0.0
      XC1PXS(L,NY,NX)=0.0
      XC2PXS(L,NY,NX)=0.0
      XM1PXS(L,NY,NX)=0.0
      XH0BXB(L,NY,NX)=0.0
      XH1BXB(L,NY,NX)=0.0
      XH3BXB(L,NY,NX)=0.0
      XF1BXB(L,NY,NX)=0.0
      XF2BXB(L,NY,NX)=0.0
      XC0BXB(L,NY,NX)=0.0
      XC1BXB(L,NY,NX)=0.0
      XC2BXB(L,NY,NX)=0.0
      XM1BXB(L,NY,NX)=0.0
      DO 9955 K=0,4
      XOCFXS(K,L,NY,NX)=0.0
      XONFXS(K,L,NY,NX)=0.0
      XOPFXS(K,L,NY,NX)=0.0
      XOAFXS(K,L,NY,NX)=0.0
9955  CONTINUE
      DO 9980 N=NCN(NY,NX),3
      THAW(N,L,NY,NX)=0.0
      THAWH(N,L,NY,NX)=0.0
      HTHAW(N,L,NY,NX)=0.0
9980  CONTINUE
      XCOBBL(L,NY,NX)=0.0
      XCHBBL(L,NY,NX)=0.0
      XOXBBL(L,NY,NX)=0.0
      XNGBBL(L,NY,NX)=0.0
      XN2BBL(L,NY,NX)=0.0
      XN3BBL(L,NY,NX)=0.0
      XNBBBL(L,NY,NX)=0.0
      XHGBBL(L,NY,NX)=0.0
      RTDNT(L,NY,NX)=0.0
C
C     CALCULATE SOIL CONCENTRATIONS OF SOLUTES, GASES
C
      CDPTHZ(L,NY,NX)=CDPTH(L,NY,NX)-CDPTH(NU(NY,NX),NY,NX)
     2+DLYR(3,NU(NY,NX),NY,NX)
      IF(L.EQ.NU(NY,NX))THEN
      DPTHZ(L,NY,NX)=0.5*CDPTHZ(L,NY,NX)
      ELSE
      DPTHZ(L,NY,NX)=0.5*(CDPTHZ(L,NY,NX)+CDPTHZ(L-1,NY,NX))
      ENDIF
      THETW(L,NY,NX)=AMAX1(0.0,AMIN1(POROS(L,NY,NX) 
     2,VOLW(L,NY,NX)/VOLX(L,NY,NX)))
      THETI(L,NY,NX)=AMAX1(0.0,AMIN1(POROS(L,NY,NX)
     2,VOLI(L,NY,NX)/VOLX(L,NY,NX)))
      THETP(L,NY,NX)=AMAX1(0.0,VOLP(L,NY,NX)/VOLT(L,NY,NX))
     2*HYST(L,NY,NX)
      TORT(L,NY,NX)=AMAX1(0.01,0.7*THETW(L,NY,NX)**2)
     2*(1.0-FHOL(L,NY,NX))
      IF(VOLAH(L,NY,NX).GT.ZEROS(NY,NX))THEN
      THETWH=VOLWH(L,NY,NX)/VOLAH(L,NY,NX)
      TORTH(L,NY,NX)=AMIN1(1.0,2.8*THETWH**3)*FHOL(L,NY,NX)
      ELSE
      TORTH(L,NY,NX)=0.0
      ENDIF
      IF(THETP(L,NY,NX).GT.THETX)THEN
      CCO2G(L,NY,NX)=AMAX1(0.0,CO2G(L,NY,NX)/VOLP(L,NY,NX))
      CCH4G(L,NY,NX)=AMAX1(0.0,CH4G(L,NY,NX)/VOLP(L,NY,NX))
      COXYG(L,NY,NX)=AMAX1(0.0,OXYG(L,NY,NX)/VOLP(L,NY,NX))
      CZ2GG(L,NY,NX)=AMAX1(0.0,Z2GG(L,NY,NX)/VOLP(L,NY,NX))
      CZ2OG(L,NY,NX)=AMAX1(0.0,Z2OG(L,NY,NX)/VOLP(L,NY,NX))
      CNH3G(L,NY,NX)=AMAX1(0.0,ZNH3G(L,NY,NX)/VOLP(L,NY,NX))
      CH2GG(L,NY,NX)=AMAX1(0.0,H2GG(L,NY,NX)/VOLP(L,NY,NX))
      ELSE
      CCO2G(L,NY,NX)=0.0
      CCH4G(L,NY,NX)=0.0
      COXYG(L,NY,NX)=0.0
      CZ2GG(L,NY,NX)=0.0
      CZ2OG(L,NY,NX)=0.0
      CNH3G(L,NY,NX)=0.0
      CH2GG(L,NY,NX)=0.0
      ENDIF
      IF(VOLW(L,NY,NX).GT.ZEROS(NY,NX))THEN
      CCO2S(L,NY,NX)=AMAX1(0.0,CO2S(L,NY,NX)/VOLW(L,NY,NX))
      CCH4S(L,NY,NX)=AMAX1(0.0,CH4S(L,NY,NX)/VOLW(L,NY,NX))
      COXYS(L,NY,NX)=AMAX1(0.0,OXYS(L,NY,NX)/VOLW(L,NY,NX))
      CZ2GS(L,NY,NX)=AMAX1(0.0,Z2GS(L,NY,NX)/VOLW(L,NY,NX))
      CZ2OS(L,NY,NX)=AMAX1(0.0,Z2OS(L,NY,NX)/VOLW(L,NY,NX))
      CH2GS(L,NY,NX)=AMAX1(0.0,H2GS(L,NY,NX)/VOLW(L,NY,NX))
      CRSDS(L,NY,NX)=AMAX1(0.0,OQC(1,L,NY,NX)/VOLW(L,NY,NX))
      CRSDN(L,NY,NX)=AMAX1(0.0,OQN(1,L,NY,NX)/VOLW(L,NY,NX))
      CRSDP(L,NY,NX)=AMAX1(0.0,OQP(1,L,NY,NX)/VOLW(L,NY,NX))
      ELSE
      CCO2S(L,NY,NX)=0.0
      CCH4S(L,NY,NX)=0.0
      COXYS(L,NY,NX)=0.0
      CZ2GS(L,NY,NX)=0.0
      CZ2OS(L,NY,NX)=0.0
      CH2GS(L,NY,NX)=0.0
      CRSDS(L,NY,NX)=0.0
      CRSDN(L,NY,NX)=0.0
      CRSDP(L,NY,NX)=0.0
      ENDIF
      IF(BKVL(L,NY,NX).GT.0.0)THEN
      CORGC(L,NY,NX)=AMIN1(0.5E+06,ORGC(L,NY,NX)/BKVL(L,NY,NX))
      ELSE
      CORGC(L,NY,NX)=0.0
      ENDIF
C
C     CALCULATE SOIL CONCENTRATIONS OF NH4, NH3, NO3, PO4
C     IN BAND AND NON-BAND ZONES
C
      IF(VOLW(L,NY,NX).GT.ZEROS(NY,NX))THEN
      IF(VLNH4(L,NY,NX).GT.ZERO)THEN
      CNH4S(L,NY,NX)=AMAX1(0.0,ZNH4S(L,NY,NX)
     2/(VOLW(L,NY,NX)*VLNH4(L,NY,NX)))
      CNH3S(L,NY,NX)=AMAX1(0.0,ZNH3S(L,NY,NX)
     2/(VOLW(L,NY,NX)*VLNH4(L,NY,NX)))
      ELSE
      CNH4S(L,NY,NX)=0.0
      CNH3S(L,NY,NX)=0.0
      ENDIF
      IF(VLNO3(L,NY,NX).GT.ZERO)THEN
      CNO3S(L,NY,NX)=AMAX1(0.0,ZNO3S(L,NY,NX)
     2/(VOLW(L,NY,NX)*VLNO3(L,NY,NX)))
      CNO2S(L,NY,NX)=AMAX1(0.0,ZNO2S(L,NY,NX)
     2/(VOLW(L,NY,NX)*VLNO3(L,NY,NX)))
      ELSE
      CNO3S(L,NY,NX)=0.0
      CNO2S(L,NY,NX)=0.0
      ENDIF
      IF(VLPO4(L,NY,NX).GT.ZERO)THEN
      CH2P4(L,NY,NX)=AMAX1(0.0,H2PO4(L,NY,NX)
     2/(VOLW(L,NY,NX)*VLPO4(L,NY,NX)))
      CPO4S(L,NY,NX)=AMAX1(0.0,((H0PO4(L,NY,NX)+H1PO4(L,NY,NX)
     2+H3PO4(L,NY,NX)+ZFE1P(L,NY,NX)+ZFE2P(L,NY,NX)+ZCA0P(L,NY,NX)
     3+ZCA1P(L,NY,NX)+ZCA2P(L,NY,NX)+ZMG1P(L,NY,NX))*31.0
     4+H2PO4(L,NY,NX))/(VOLW(L,NY,NX)*VLPO4(L,NY,NX)))
      ELSE
      CH2P4(L,NY,NX)=0.0
      CPO4S(L,NY,NX)=0.0
      ENDIF
      IF(VLNHB(L,NY,NX).GT.ZERO)THEN
      CNH4B(L,NY,NX)=AMAX1(0.0,ZNH4B(L,NY,NX)
     2/(VOLW(L,NY,NX)*VLNHB(L,NY,NX)))
      CNH3B(L,NY,NX)=AMAX1(0.0,ZNH3B(L,NY,NX)
     2/(VOLW(L,NY,NX)*VLNHB(L,NY,NX)))
      ELSE
      CNH4B(L,NY,NX)=0.0
      CNH3B(L,NY,NX)=0.0
      ENDIF
      IF(VLNOB(L,NY,NX).GT.ZERO)THEN
      CNO3B(L,NY,NX)=AMAX1(0.0,ZNO3B(L,NY,NX)
     2/(VOLW(L,NY,NX)*VLNOB(L,NY,NX)))
      CNO2B(L,NY,NX)=AMAX1(0.0,ZNO2B(L,NY,NX)
     2/(VOLW(L,NY,NX)*VLNOB(L,NY,NX)))
      ELSE
      CNO3B(L,NY,NX)=0.0
      CNO2B(L,NY,NX)=0.0
      ENDIF
      IF(VLPOB(L,NY,NX).GT.ZERO)THEN
      CH2PB(L,NY,NX)=AMAX1(0.0,H2POB(L,NY,NX)
     2/(VOLW(L,NY,NX)*VLPOB(L,NY,NX)))
      CPO4B(L,NY,NX)=AMAX1(0.0,((H0POB(L,NY,NX)+H1POB(L,NY,NX)
     2+H3POB(L,NY,NX)+ZFE1PB(L,NY,NX)+ZFE2PB(L,NY,NX)+ZCA0PB(L,NY,NX)
     3+ZCA1PB(L,NY,NX)+ZCA2PB(L,NY,NX)+ZMG1PB(L,NY,NX))*31.0
     4+H2POB(L,NY,NX))/(VOLW(L,NY,NX)*VLPOB(L,NY,NX)))
      ELSE
      CH2PB(L,NY,NX)=0.0
      CPO4B(L,NY,NX)=0.0
      ENDIF
      ELSE
      CNH4S(L,NY,NX)=0.0
      CNH3S(L,NY,NX)=0.0
      CNO3S(L,NY,NX)=0.0
      CNO2S(L,NY,NX)=0.0
      CH2P4(L,NY,NX)=0.0
      CPO4S(L,NY,NX)=0.0
      CNH4B(L,NY,NX)=0.0
      CNH3B(L,NY,NX)=0.0
      CNO3B(L,NY,NX)=0.0
      CNO2B(L,NY,NX)=0.0
      CH2PB(L,NY,NX)=0.0
      CPO4B(L,NY,NX)=0.0
      ENDIF
      ROXYY(L,NY,NX)=ROXYX(L,NY,NX)
      RNH4Y(L,NY,NX)=RNH4X(L,NY,NX)
      RNO3Y(L,NY,NX)=RNO3X(L,NY,NX)
      RNO2Y(L,NY,NX)=RNO2X(L,NY,NX)
      RN2OY(L,NY,NX)=RN2OX(L,NY,NX)
      RPO4Y(L,NY,NX)=RPO4X(L,NY,NX)
      RNHBY(L,NY,NX)=RNHBX(L,NY,NX)
      RN3BY(L,NY,NX)=RN3BX(L,NY,NX)
      RN2BY(L,NY,NX)=RN2BX(L,NY,NX)
      RPOBY(L,NY,NX)=RPOBX(L,NY,NX)
      ROXYX(L,NY,NX)=0.0
      RNH4X(L,NY,NX)=0.0
      RNO3X(L,NY,NX)=0.0
      RNO2X(L,NY,NX)=0.0
      RN2OX(L,NY,NX)=0.0
      RPO4X(L,NY,NX)=0.0
      RNHBX(L,NY,NX)=0.0
      RN3BX(L,NY,NX)=0.0
      RN2BX(L,NY,NX)=0.0
      RPOBX(L,NY,NX)=0.0
      DO 5050 K=0,4
      ROQCY(K,L,NY,NX)=ROQCX(K,L,NY,NX) 
      ROQAY(K,L,NY,NX)=ROQAX(K,L,NY,NX)
      ROQCX(K,L,NY,NX)=0.0 
      ROQAX(K,L,NY,NX)=0.0
5050  CONTINUE
      TFACG=(TKS(L,NY,NX)/273.15)**1.75
      TFACL=(TKS(L,NY,NX)/273.15)**6
      TFND(L,NY,NX)=TFACL
      CGSGL(L,NY,NX)=CGSG*TFACG
      CHSGL(L,NY,NX)=CHSG*TFACG
      OGSGL(L,NY,NX)=OGSG*TFACG
      ZGSGL(L,NY,NX)=ZGSG*TFACG
      Z2SGL(L,NY,NX)=Z2SG*TFACG
      ZHSGL(L,NY,NX)=ZHSG*TFACG
      HGSGL(L,NY,NX)=HGSG*TFACG
      CLSGL(L,NY,NX)=CLSG*TFACL
      CQSGL(L,NY,NX)=CQSG*TFACL
      OLSGL(L,NY,NX)=OLSG*TFACL
      ZLSGL(L,NY,NX)=ZLSG*TFACL
      ZNSGL(L,NY,NX)=ZNSG*TFACL
      HLSGL(L,NY,NX)=HLSG*TFACL
      ZVSGL(L,NY,NX)=ZVSG*TFACL
      ZOSGL(L,NY,NX)=ZOSG*TFACL
      POSGL(L,NY,NX)=POSG*TFACL
      OCSGL(L,NY,NX)=OCSG*TFACL
      ONSGL(L,NY,NX)=ONSG*TFACL
      OPSGL(L,NY,NX)=OPSG*TFACL
      OASGL(L,NY,NX)=OASG*TFACL
      WGSGL(L,NY,NX)=WGSG*TFACG
      IF(ISALT(NY,NX).NE.0)THEN
      ALSGL(L,NY,NX)=ALSG*TFACL
      FESGL(L,NY,NX)=FESG*TFACL
      HYSGL(L,NY,NX)=HYSG*TFACL
      CASGL(L,NY,NX)=CASG*TFACL
      GMSGL(L,NY,NX)=GMSG*TFACL
      ANSGL(L,NY,NX)=ANSG*TFACL
      AKSGL(L,NY,NX)=AKSG*TFACL
      OHSGL(L,NY,NX)=OHSG*TFACL
      C3SGL(L,NY,NX)=C3SG*TFACL
      HCSGL(L,NY,NX)=HCSG*TFACL
      SOSGL(L,NY,NX)=SOSG*TFACL
      CLSXL(L,NY,NX)=CLSX*TFACL
C
C     SOIL ELECTRICAL CONDUCTIVITY FROM CATION AND ANION CONCENTRATIONS
C
      IF(VOLW(L,NY,NX).GT.0.0)THEN
      ECHY=0.337*AMAX1(0.0,ZHY(L,NY,NX)/VOLW(L,NY,NX))
      ECOH=0.192*AMAX1(0.0,ZOH(L,NY,NX)/VOLW(L,NY,NX))
      ECAL=0.056*AMAX1(0.0,ZAL(L,NY,NX)*3.0/VOLW(L,NY,NX))
      ECFE=0.051*AMAX1(0.0,ZFE(L,NY,NX)*3.0/VOLW(L,NY,NX))
      ECCA=0.060*AMAX1(0.0,ZCA(L,NY,NX)*2.0/VOLW(L,NY,NX)) 
      ECMG=0.053*AMAX1(0.0,ZMG(L,NY,NX)*2.0/VOLW(L,NY,NX)) 
      ECNA=0.050*AMAX1(0.0,ZNA(L,NY,NX)/VOLW(L,NY,NX)) 
      ECKA=0.070*AMAX1(0.0,ZKA(L,NY,NX)/VOLW(L,NY,NX))
      ECCO=0.072*AMAX1(0.0,ZCO3(L,NY,NX)*2.0/VOLW(L,NY,NX))
      ECHC=0.044*AMAX1(0.0,ZHCO3(L,NY,NX)/VOLW(L,NY,NX))
      ECSO=0.080*AMAX1(0.0,ZSO4(L,NY,NX)*2.0/VOLW(L,NY,NX))
      ECCL=0.076*AMAX1(0.0,ZCL(L,NY,NX)/VOLW(L,NY,NX))
      ECNO=0.071*AMAX1(0.0,ZNO3S(L,NY,NX)/(VOLW(L,NY,NX)*14.0))
      ECND(L,NY,NX)=ECHY+ECOH+ECAL+ECFE+ECCA+ECMG+ECNA+ECKA
     2+ECCO+ECHC+ECSO+ECCL+ECNO
      ELSE
      ECND(L,NY,NX)=0.0
      ENDIF
C     WRITE(*,5656)'ECND',I,J,NU(NY,NX),NL(NY,NX),L,ECND(L,NY,NX)
C    2,VOLW(L,NY,NX),ECHY,ECOH,ECAL,ECFE,ECCA,ECMG,ECNA,ECKA
C    3,ECCO,ECHC,ECSO,ECCL,ECNO
5656  FORMAT(A8,5I4,30E12.4)
C
C     TOTAL ION CONCENTRATION
C
      ZC3=ZAL(L,NY,NX)+ZFE(L,NY,NX)
      ZA3=H0PO4(L,NY,NX)+H0POB(L,NY,NX)
      ZC2=ZCA(L,NY,NX)+ZMG(L,NY,NX)+ZALOH1(L,NY,NX)+ZFEOH1(L,NY,NX)
     2+ZFE2P(L,NY,NX)+ZFE2PB(L,NY,NX)
      ZA2=ZSO4(L,NY,NX)+ZCO3(L,NY,NX)+H1PO4(L,NY,NX)+H1POB(L,NY,NX)
      ZC1=(ZNH4S(L,NY,NX)+ZNH4B(L,NY,NX))/14.0+ZHY(L,NY,NX)
     2+ZNA(L,NY,NX)+ZKA(L,NY,NX)+ZALOH2(L,NY,NX)+ZFEOH2(L,NY,NX)
     3+ZALS(L,NY,NX)+ZFES(L,NY,NX)+ZCAO(L,NY,NX)+ZCAH(L,NY,NX)
     4+ZMGO(L,NY,NX)+ZMGH(L,NY,NX)+ZFE1P(L,NY,NX)+ZFE1PB(L,NY,NX)
     5+ZCA2P(L,NY,NX)+ZCA2PB(L,NY,NX)
      ZA1=(ZNO3S(L,NY,NX)+ZNO3B(L,NY,NX))/14.0+ZOH(L,NY,NX)
     2+ZHCO3(L,NY,NX)+ZCL(L,NY,NX)+ZALOH4(L,NY,NX)+ZFEOH4(L,NY,NX)
     3+ZNAC(L,NY,NX)+ZNAS(L,NY,NX)+ZKAS(L,NY,NX)+(H2PO4(L,NY,NX)
     4+H2POB(L,NY,NX))/31.0+ZCA0P(L,NY,NX)+ZCA0PB(L,NY,NX)
      ZN=CO2S(L,NY,NX)/12.0+CH4S(L,NY,NX)/12.0+OXYS(L,NY,NX)/32.0
     2+(Z2GS(L,NY,NX)+Z2OS(L,NY,NX)+ZNH3S(L,NY,NX)+ZNH3B(L,NY,NX))/14.0
     3+ZALOH3(L,NY,NX)+ZFEOH3(L,NY,NX)+ZCAC(L,NY,NX)+ZCAS(L,NY,NX)
     4+ZMGC(L,NY,NX)+ZMGS(L,NY,NX)+H3PO4(L,NY,NX)+ZCA1P(L,NY,NX)
     5+ZMG1P(L,NY,NX)+H3POB(L,NY,NX)+ZCA1PB(L,NY,NX)+ZMG1PB(L,NY,NX)
      ZION1=ABS(3.0*(ZC3-ZA3)+2.0*(ZC2-ZA2)+ZC1-ZA1)
      IF(VOLW(L,NY,NX).GT.ZEROS(NY,NX))THEN
      CSTR(L,NY,NX)=AMAX1(0.0,0.5E-03*(9.0*(ZC3+ZA3)+4.0*(ZC2+ZA2)
     2+ZC1+ZA1+ZION1)/VOLW(L,NY,NX))
      CION(L,NY,NX)=AMAX1(0.0,(ZC3+ZA3+ZC2+ZA2+ZC1+ZA1+ZN+ZION1)
     2/VOLW(L,NY,NX))
      ELSE
      CSTR(L,NY,NX)=0.0
      CION(L,NY,NX)=0.0
      ENDIF
      IF(ZHY(L,NY,NX).GT.ZEROS(NY,NX)
     2.AND.VOLW(L,NY,NX).GT.ZEROS(NY,NX))THEN
      PH(L,NY,NX)=-LOG10(ZHY(L,NY,NX)/(VOLW(L,NY,NX)*1.0E+03))
      ENDIF
      ENDIF
C
C     OSTWALD COEFFICIENTS FOR CO2, CH4, O2, N2, N2O, NH3 AND H2
C     SOLUBILITY IN WATER
C
      FH2O=5.56E+04/(5.56E+04+CION(L,NY,NX))
      SCO2L(L,NY,NX)=SCO2X/(EXP(ACO2X*CSTR(L,NY,NX)))
     2*EXP(0.843-0.0281*TCS(L,NY,NX))*FH2O
      SCH4L(L,NY,NX)=SCH4X/(EXP(ACH4X*CSTR(L,NY,NX)))
     2*EXP(0.597-0.0199*TCS(L,NY,NX))*FH2O
      SOXYL(L,NY,NX)=SOXYX/(EXP(AOXYX*CSTR(L,NY,NX)))
     2*EXP(0.516-0.0172*TCS(L,NY,NX))*FH2O
      SN2GL(L,NY,NX)=SN2GX/(EXP(AN2GX*CSTR(L,NY,NX)))
     2*EXP(0.456-0.0152*TCS(L,NY,NX))*FH2O
      SN2OL(L,NY,NX)=SN2OX/(EXP(AN2OX*CSTR(L,NY,NX)))
     2*EXP(0.897-0.0299*TCS(L,NY,NX))*FH2O
      SNH3L(L,NY,NX)=SNH3X/(EXP(ANH3X*CSTR(L,NY,NX)))
     2*EXP(0.513-0.0171*TCS(L,NY,NX))*FH2O
      SH2GL(L,NY,NX)=SH2GX/(EXP(AH2GX*CSTR(L,NY,NX)))
     2*EXP(0.597-0.0199*TCS(L,NY,NX))*FH2O
      IF(BKVL(L,NY,NX).GT.0.0)THEN
      IF(THETW(L,NY,NX).LT.FC(L,NY,NX))THEN
      PSISM(L,NY,NX)=AMAX1(HYGR,-EXP(PSIMX(NY,NX)
     2+((FCL(L,NY,NX)-LOG(THETW(L,NY,NX)))
     3/FCD(L,NY,NX)*PSIMD(NY,NX))))
      ELSEIF(THETW(L,NY,NX).LT.POROS(L,NY,NX)-DTHETW)THEN 
      PSISM(L,NY,NX)=-EXP(PSIMS(NY,NX)
     2+(((PSL(L,NY,NX)-LOG(THETW(L,NY,NX)))
     3/PSD(L,NY,NX))**SRP(L,NY,NX)*PSISD(NY,NX)))
      ELSE
      PSISM(L,NY,NX)=PSISE(0,NY,NX)
      ENDIF
      ELSE
      PSISM(L,NY,NX)=PSISE(0,NY,NX)
      ENDIF
C
C     SOIL OSMOTIC, GRAVIMETRIC AND MATRIC WATER POTENTIALS
C
      PSISO(L,NY,NX)=-8.3143E-06*TKS(L,NY,NX)*CION(L,NY,NX)
      PSISH(L,NY,NX)=0.01*YDPTH(L,NY,NX)
      PSIST(L,NY,NX)=AMIN1(0.0,PSISM(L,NY,NX)+PSISO(L,NY,NX)
     2+PSISH(L,NY,NX))
C
C     SOIL RESISTANCE TO ROOT PENETRATION
C
C     IF(BKDS(L,NY,NX).GT.0.0)THEN
C     CCLAYT=CCLAY(L,NY,NX)*1.0E+02
C     CORGCT=CORGC(L,NY,NX)*1.0E-04
C     CC=EXP(-3.6733-0.1447*CCLAYT+0.7653*CORGCT)
C     DD=-0.4805-0.1239*CCLAYT+0.2080*CORGCT
C     EE=3.8521+0.0963*CCLAYT
C     RSCS(L,NY,NX)=CC*THETW(L,NY,NX)**DD*BKDS(L,NY,NX)**EE
C     ELSE
      RSCS(L,NY,NX)=0.0
C     ENDIF
C     WRITE(*,2442)'RSCS',I,J,NX,NY,L,RSCS(L,NY,NX),THETW(L,NY,NX)
C    2,BKDS(L,NY,NX),CCLAY(L,NY,NX),CORGC(L,NY,NX)
2442  FORMAT(A8,5I4,12E12.4)
C
C     SOIL HYDRAULIC CONDUCTIVITIES FROM AMBIENT SOIL WATER CONTENTS
C
      K=MAX(1,MIN(100,INT(100.0*(POROS(L,NY,NX)-THETW(L,NY,NX))
     2/POROS(L,NY,NX))+1))
      CNDU(L,NY,NX)=0.5*(HCND(1,K,L,NY,NX)+HCND(3,K,L,NY,NX))
C
C     CALCULATE ACTIVE LAYER DEPTH
C     
      IF(ICHKA.EQ.0)THEN
      VOLIT=VOLI(L,NY,NX)+VOLIH(L,NY,NX)
      VOLAT=VOLA(L,NY,NX)+VOLAH(L,NY,NX)
      IF(VOLIT.GT.0.01*VOLAT)THEN
      DO 5700 LL=MIN(L+1,NL(NY,NX)),NL(NY,NX)
      VOLITL=VOLI(LL,NY,NX)+VOLIH(LL,NY,NX)
      VOLWTL=VOLW(LL,NY,NX)+VOLWH(LL,NY,NX)
      VOLATL=VOLA(LL,NY,NX)+VOLAH(LL,NY,NX)
C    ZM (1) modified the parameter(0.01 to 0.001), (0.833 to 0.6) and(2)chnaged the 9999 to CDPTH
      IF(VOLITL.LT.0.001*VOLATL)THEN
      GO TO 5701
      ENDIF
5700  CONTINUE
      DPTHA(NY,NX)=CDPTH(L,NY,NX)-DLYR(3,L,NY,NX)
     2*AMIN1(1.0,VOLIT/(0.4*VOLAT))
      ICHKA=1
      GO TO 5702
5701  DPTHA(NY,NX)=CDPTH(NL(NY,NX),NY,NX)
5702  CONTINUE
      ENDIF
      ENDIF
C
C     OUTPUT FOR WATER TABLE DEPTH
C
      IF(IPRC(NY,NX).NE.0)THEN
      IF(IFLGY.EQ.0)THEN
      THETPX(L)=POROS(L,NY,NX)-THETW(L,NY,NX)-THETI(L,NY,NX)
      IF(PSISM(L,NY,NX).GT.PSISA(L,NY,NX).OR.L.EQ.NL(NY,NX))THEN
      IFLGY=1
      IF(DPTH(L,NY,NX).LT.DTBLX(NY,NX))THEN
      DO 5705 LL=MIN(L+1,NL(NY,NX)),NL(NY,NX)
      IF(PSISM(LL,NY,NX).LT.PSISA(LL,NY,NX).AND.L.NE.NL(NY,NX))THEN
      IFLGY=0
      GO TO 5706
      ELSEIF(DPTH(LL,NY,NX).GE.DTBL(NY,NX))THEN
      GO TO 5706
      ENDIF
5705  CONTINUE
      ENDIF
5706  CONTINUE
      IF(IFLGY.EQ.1)THEN
      IF(PSISM(L,NY,NX).LT.PSISA(L,NY,NX).AND.L.EQ.NL(NY,NX))THEN
      PSIS1=PSISE(L,NY,NX)-0.01*(DPTH(L,NY,NX)-DPTH(L-1,NY,NX))
      THETA1=AMIN1(POROS(L,NY,NX),EXP((PSIMS(NY,NX)-LOG(-PSIS1))
     2*PSD(L,NY,NX)/PSISD(NY,NX)+PSL(L,NY,NX)))
      THETP1=POROS(L,NY,NX)-THETA1
      IF(THETP1.GT.ZERO)THEN
      DPTHT(NY,NX)=CDPTH(L,NY,NX)-DLYR(3,L,NY,NX)
     2*AMAX1(0.0,AMIN1(1.0,1.0-THETPX(L)/THETP1))
      ELSE
      DPTHT(NY,NX)=CDPTH(L,NY,NX)-DLYR(3,L,NY,NX)
      ENDIF
      ELSEIF(L.GT.NU(NY,NX))THEN
      PSIS1=PSISE(L,NY,NX)-0.01*(DPTH(L,NY,NX)-DPTH(L-1,NY,NX))
      THETA1=AMIN1(POROS(L-1,NY,NX),EXP((PSIMS(NY,NX)-LOG(-PSIS1))
     2*PSD(L-1,NY,NX)/PSISD(NY,NX)+PSL(L-1,NY,NX)))
      THETP1=POROS(L-1,NY,NX)-THETA1
      IF(THETP1.GT.ZERO)THEN
      DPTHT(NY,NX)=CDPTH(L-1,NY,NX)-DLYR(3,L-1,NY,NX)
     2*AMAX1(0.0,AMIN1(1.0,1.0-THETPX(L-1)/THETP1))
      ELSE
      DPTHT(NY,NX)=CDPTH(L-1,NY,NX)-DLYR(3,L-1,NY,NX) 
      ENDIF
      ELSE
      DPTHT(NY,NX)=CDPTH(L-1,NY,NX)-AMAX1(0.0,VOLW(L,NY,NX) 
     2+VOLI(L,NY,NX)+VOLWH(L,NY,NX)+VOLIH(L,NY,NX)-VOLA(L,NY,NX) 
     3-VOLAH(L,NY,NX))/AREA(3,L,NY,NX)
      ENDIF
      ENDIF
      ENDIF
      ENDIF
C     WRITE(*,5353)'DPTHT',I,J,NX,NY,L,LL,IFLGY,DPTHT(NY,NX)
C    2,CDPTH(L,NY,NX),DLYR(3,L,NY,NX),DPTH(L,NY,NX),DPTH(L-1,NY,NX)
C    3,PSIS1,PSISE(L,NY,NX),THETA1,THETP1,THETPX(L)
C    4,PSISM(L,NY,NX),DTBLZ(NY,NX),DTBL(NY,NX),DTBLX(NY,NX)
C    5,POROS(L,NY,NX),THETW(L,NY,NX),THETI(L,NY,NX)
5353  FORMAT(A8,7I4,30E12.4)
      ENDIF
9985  CONTINUE
C
C     PHYSICAL PROPERTIES, AND WATER, GAS, AND MINERAL CONTENTS
C     OF SURFACE RESIDUE
C
      TVOLG=AMAX1(0.0,VOLW(0,NY,NX)+VOLI(0,NY,NX)
     2-VOLWRX(NY,NX))
      VOLT(0,NY,NX)=TVOLG+VOLR(NY,NX)
      IF(VOLT(0,NY,NX).GT.ZEROS(NY,NX))THEN
      VOLX(0,NY,NX)=VOLT(0,NY,NX)
      BKVL(0,NY,NX)=2.0E-06*ORGC(0,NY,NX)
      VOLA(0,NY,NX)=AMAX1(0.0,VOLX(0,NY,NX)-BKVL(0,NY,NX)/1.30)
      VOLP(0,NY,NX)=AMAX1(0.0,VOLA(0,NY,NX)-VOLW(0,NY,NX)
     2-VOLI(0,NY,NX))
      POROS(0,NY,NX)=VOLA(0,NY,NX)/VOLX(0,NY,NX)
      DLYR(3,0,NY,NX)=VOLX(0,NY,NX)/AREA(3,0,NY,NX)
      THETW(0,NY,NX)=AMAX1(0.0,AMIN1(VOLA(0,NY,NX)
     2,VOLW(0,NY,NX))/VOLX(0,NY,NX))
      THETI(0,NY,NX)=AMAX1(0.0,AMIN1(VOLA(0,NY,NX)
     2,VOLI(0,NY,NX))/VOLX(0,NY,NX))
      THETP(0,NY,NX)=AMAX1(0.0,VOLP(0,NY,NX)/VOLX(0,NY,NX))
      TRC0(NY,NX)=RC0(0,NY,NX)+RC0(1,NY,NX)+RC0(2,NY,NX)
      TRA0(NY,NX)=RA0(0,NY,NX)+RA0(1,NY,NX)+RA0(2,NY,NX)
      VOLWRX(NY,NX)=THETRX*TRC0(NY,NX)
      IF(TRC0(NY,NX).GT.ZEROS(NY,NX)
     2.AND.VOLW(0,NY,NX).GT.ZEROS(NY,NX))THEN
      VOLXA(NY,NX)=VOLX(0,NY,NX)*TRA0(NY,NX)/TRC0(NY,NX)
      IF(VOLWRX(NY,NX).GT.ZEROS(NY,NX))THEN
      THETWR=AMAX1(1.0E-02,AMIN1(1.0,VOLW(0,NY,NX)/VOLWRX(NY,NX)))
      ELSE
      THETWR=1.0
      ENDIF
      PSISM(0,NY,NX)=PSISE(0,NY,NX)*THETWR**-4.0 
      CNH4S(0,NY,NX)=AMAX1(0.0,ZNH4S(0,NY,NX)/VOLW(0,NY,NX))
      CNH3S(0,NY,NX)=AMAX1(0.0,ZNH3S(0,NY,NX)/VOLW(0,NY,NX))
      CNO3S(0,NY,NX)=AMAX1(0.0,ZNO3S(0,NY,NX)/VOLW(0,NY,NX))
      CNO2S(0,NY,NX)=AMAX1(0.0,ZNO2S(0,NY,NX)/VOLW(0,NY,NX))
      CH2P4(0,NY,NX)=AMAX1(0.0,H2PO4(0,NY,NX)/VOLW(0,NY,NX))
      ELSE
      VOLXA(NY,NX)=0.0
      PSISM(0,NY,NX)=PSISM(NU(NY,NX),NY,NX)
      CNH4S(0,NY,NX)=0.0
      CNH3S(0,NY,NX)=0.0
      CNO3S(0,NY,NX)=0.0
      CNO2S(0,NY,NX)=0.0
      CH2P4(0,NY,NX)=0.0
      ENDIF
      ELSE
      VOLX(0,NY,NX)=0.0
      BKVL(0,NY,NX)=0.0
      VOLA(0,NY,NX)=0.0
      VOLP(0,NY,NX)=0.0
      POROS(0,NY,NX)=1.0
      DLYR(3,0,NY,NX)=0.0
      THETW(0,NY,NX)=0.0
      THETI(0,NY,NX)=0.0
      THETP(0,NY,NX)=1.0
      TRC0(NY,NX)=0.0
      TRA0(NY,NX)=0.0
      VOLWRX(NY,NX)=0.0
      VOLXA(NY,NX)=0.0
      PSISM(0,NY,NX)=PSISM(NU(NY,NX),NY,NX)
      CNH4S(0,NY,NX)=0.0
      CNH3S(0,NY,NX)=0.0
      CNO3S(0,NY,NX)=0.0
      CNO2S(0,NY,NX)=0.0
      CH2P4(0,NY,NX)=0.0
      CCO2S(0,NY,NX)=0.0
      CCH4S(0,NY,NX)=0.0
      COXYS(0,NY,NX)=0.0
      CZ2GS(0,NY,NX)=0.0
      CZ2OS(0,NY,NX)=0.0
      CH2GS(0,NY,NX)=0.0
      ENDIF
      POROQ(0,NY,NX)=POROS(0,NY,NX)**0.667
      CCO2G(0,NY,NX)=CO2E(NY,NX)*5.36E-04*273.15/TKS(0,NY,NX)
      CCH4G(0,NY,NX)=CH4E(NY,NX)*5.36E-04*273.15/TKS(0,NY,NX)
      COXYG(0,NY,NX)=OXYE(NY,NX)*1.43E-03*273.15/TKS(0,NY,NX)
      CZ2GG(0,NY,NX)=Z2GE(NY,NX)*1.25E-03*273.15/TKS(0,NY,NX)
      CZ2OG(0,NY,NX)=Z2OE(NY,NX)*1.25E-03*273.15/TKS(0,NY,NX)
      CNH3G(0,NY,NX)=ZNH3E(NY,NX)*6.25E-04*273.15/TKS(0,NY,NX)
      CH2GG(0,NY,NX)=H2GE(NY,NX)*8.92E-05*273.15/TKS(0,NY,NX)
      CNH4B(0,NY,NX)=0.0
      CNH3B(0,NY,NX)=0.0
      CNO3B(0,NY,NX)=0.0
      CNO2B(0,NY,NX)=0.0
      CH2PB(0,NY,NX)=0.0
      SCO2L(0,NY,NX)=SCO2X*EXP(0.843-0.0281*TCS(0,NY,NX)) 
      SCH4L(0,NY,NX)=SCH4X*EXP(0.597-0.0199*TCS(0,NY,NX))
      SOXYL(0,NY,NX)=SOXYX*EXP(0.516-0.0172*TCS(0,NY,NX)) 
      SN2GL(0,NY,NX)=SN2GX*EXP(0.456-0.0152*TCS(0,NY,NX)) 
      SN2OL(0,NY,NX)=SN2OX*EXP(0.897-0.0299*TCS(0,NY,NX)) 
      SNH3L(0,NY,NX)=SNH3X*EXP(0.513-0.0171*TCS(0,NY,NX)) 
      SH2GL(0,NY,NX)=SH2GX*EXP(0.597-0.0199*TCS(0,NY,NX)) 
      IF(VOLW(0,NY,NX).GT.ZEROS(NY,NX))THEN
      CCO2S(0,NY,NX)=AMAX1(0.0,CO2S(0,NY,NX)/VOLW(0,NY,NX))
      CCH4S(0,NY,NX)=AMAX1(0.0,CH4S(0,NY,NX)/VOLW(0,NY,NX))
      COXYS(0,NY,NX)=AMAX1(0.0,OXYS(0,NY,NX)/VOLW(0,NY,NX))
      CZ2GS(0,NY,NX)=AMAX1(0.0,Z2GS(0,NY,NX)/VOLW(0,NY,NX))
      CZ2OS(0,NY,NX)=AMAX1(0.0,Z2OS(0,NY,NX)/VOLW(0,NY,NX))
      CH2GS(0,NY,NX)=AMAX1(0.0,H2GS(0,NY,NX)/VOLW(0,NY,NX))
      ELSE
      CCO2S(0,NY,NX)=0.0
      CCH4S(0,NY,NX)=0.0 
      COXYS(0,NY,NX)=0.0
      CZ2GS(0,NY,NX)=0.0
      CZ2OS(0,NY,NX)=0.0
      CH2GS(0,NY,NX)=0.0
      ENDIF
      TFACL=(TKS(0,NY,NX)/273.15)**6
      TFND(0,NY,NX)=TFACL
      CQSGL(0,NY,NX)=CQSG*TFACL
      OLSGL(0,NY,NX)=OLSG*TFACL
      ZLSGL(0,NY,NX)=ZLSG*TFACL
      ZNSGL(0,NY,NX)=ZNSG*TFACL
      HLSGL(0,NY,NX)=HLSG*TFACL
      ZVSGL(0,NY,NX)=ZVSG*TFACL
      ZOSGL(0,NY,NX)=ZOSG*TFACL
      POSGL(0,NY,NX)=POSG*TFACL
      OCSGL(0,NY,NX)=OCSG*TFACL
      ONSGL(0,NY,NX)=ONSG*TFACL
      OPSGL(0,NY,NX)=OPSG*TFACL
      OASGL(0,NY,NX)=OASG*TFACL
      TORT(0,NY,NX)=1.0
      ROXYY(0,NY,NX)=ROXYX(0,NY,NX)
      RNH4Y(0,NY,NX)=RNH4X(0,NY,NX)
      RNO3Y(0,NY,NX)=RNO3X(0,NY,NX)
      RNO2Y(0,NY,NX)=RNO2X(0,NY,NX)
      RN2OY(0,NY,NX)=RN2OX(0,NY,NX)
      RPO4Y(0,NY,NX)=RPO4X(0,NY,NX)
      ROXYX(0,NY,NX)=0.0
      RNH4X(0,NY,NX)=0.0
      RNO3X(0,NY,NX)=0.0
      RNO2X(0,NY,NX)=0.0
      RN2OX(0,NY,NX)=0.0
      RPO4X(0,NY,NX)=0.0
      DO 5055 K=0,4
      ROQCY(K,0,NY,NX)=ROQCX(K,0,NY,NX) 
      ROQAY(K,0,NY,NX)=ROQAX(K,0,NY,NX)
      ROQCX(K,0,NY,NX)=0.0 
      ROQAX(K,0,NY,NX)=0.0
5055  CONTINUE
      TFACW=(TKW(NY,NX)/273.15)**1.75
      TFACR=(TKS(0,NY,NX)/273.15)**1.75
      TFACA=(TKA(NY,NX)/273.15)**1.75
      WGSGW(NY,NX)=WGSG*TFACW
      WGSGR(NY,NX)=WGSG*TFACR
      WGSGA(NY,NX)=WGSG*TFACA
C
C     SET DEPTH OF EXTERNAL WATER TABLE
C
      IF(IPRC(NY,NX).EQ.2)THEN
      DTBL(NY,NX)=0.50*DTBLZ(NY,NX)+0.50*DPTHT(NY,NX)
      ELSE
      DTBL(NY,NX)=DTBLZ(NY,NX)
      ENDIF
      IF(IPRC(NY,NX).EQ.3)THEN
      DTBLX(NY,NX)=DDRG(NY,NX)
      ELSE
      DTBLX(NY,NX)=DTBL(NY,NX)
      ENDIF
C
C     MULTILAYER CANOPY INTERECEPTION OF DIRECT AND DIFFUSE RADIATION
C     IN SW AND VISIBLE BANDS
C
      IF(SSIN(NY,NX).GT.ZERO)THEN
      RAD(NY,NX)=RADS(NY,NX)*SSIN(NY,NX)+RADY(NY,NX)*TYSIN
      RAP(NY,NX)=RAPS(NY,NX)*SSIN(NY,NX)+RAPY(NY,NX)*TYSIN
      ELSE
      RADS(NY,NX)=0.0
      RADY(NY,NX)=0.0
      RAPS(NY,NX)=0.0
      RAPY(NY,NX)=0.0
      RAD(NY,NX)=0.0
      RAP(NY,NX)=0.0
      ENDIF
      TRADC(NY,NX)=0.0
      TRAPC(NY,NX)=0.0
      DO 1025 NZ=1,NP(NY,NX)
      RADC(NZ,NY,NX)=0.0
      RADP(NZ,NY,NX)=0.0
      CFX(NZ,NY,NX)=CF(NZ,NY,NX)*(1.0-0.025
     2*ARLFP(NZ,NY,NX)/AREA(3,NU(NY,NX),NY,NX))
1025  CONTINUE
C
C     ANGLE BETWEEN SUN AND GROUND SURFACE
C
      IF(SSIN(NY,NX).GT.ZERO)THEN
      SAZI=0.2618*(ZNOON(NY,NX)-J)+4.7124
      SCOS=SQRT(1.0-SSIN(NY,NX)**2)
      DGAZI=COS(GAZI(NY,NX)-SAZI)
      BETAG=AMAX1(0.0,AMIN1(1.0,GCOS(NY,NX)*SSIN(NY,NX)
     2+GSIN(NY,NX)*SCOS*DGAZI))
      IF(IFLGX(NY,NX).GT.0.AND.ARLFC(NY,NX)+ARSTC(NY,NX).GT.0.0)THEN
      SAGL=ASIN(SSIN(NY,NX))
C
C     ABSORBED RADIATION FROM OPTICAL PROPERTIES ENTERED IN 'READS'
C
      DO 1050 NZ=1,NP(NY,NX)
      RADSA(NZ,NY,NX)=RADS(NY,NX)*ABSR(NZ,NY,NX)
      RADWA(NZ,NY,NX)=RADS(NY,NX)*ABSRW
      RAPSA(NZ,NY,NX)=RAPS(NY,NX)*ABSP(NZ,NY,NX)
      RAPWA(NZ,NY,NX)=RAPS(NY,NX)*ABSPW
1050  CONTINUE
C
C     ANGLES BETWEEN SUN OR SKY ZONES AND FOLIAR SURFACES
C
      DO 1100 M=1,4
      ZAZI=SAZI+(M-0.5)*3.1416/4
      DAZI=COS(ZAZI-SAZI)
      DO 1100 N=1,4
      BETY=ZCOS(N)*SSIN(NY,NX)+ZSIN(N)*SCOS*DAZI
      BETA(N,M)=ABS(BETY)
      BETX(N,M)=BETA(N,M)/SSIN(NY,NX)
      IF(ZCOS(N).GT.SSIN(NY,NX))THEN
      BETZ=ACOS(BETY)
      ELSE
      BETZ=-ACOS(BETY)
      ENDIF
      IF(BETZ.GT.-1.5708)THEN
      ZAGL=SAGL+2.0*BETZ
      ELSE
      ZAGL=SAGL-2.0*(3.1416+BETZ)
      ENDIF
      IF(ZAGL.GT.0.0.AND.ZAGL.LT.3.1416)THEN
      IALBS(N,M)=1
      ELSE
      IALBS(N,M)=2
      ENDIF
C
C     INTENSITY OF ABSORBED DIRECT RADIATION AT LEAF SURFACES
C
      DO 1100 NZ=1,NP(NY,NX)
      RDNDIR(N,M,NZ,NY,NX)=RADSA(NZ,NY,NX)*ABS(BETA(N,M))
      RDNDIW(N,M,NZ,NY,NX)=RADWA(NZ,NY,NX)*ABS(BETA(N,M))
      PARDIR(N,M,NZ,NY,NX)=RAPSA(NZ,NY,NX)*ABS(BETA(N,M))
      PARDIW(N,M,NZ,NY,NX)=RAPWA(NZ,NY,NX)*ABS(BETA(N,M))
      DO 1100 L=1,NC(NY,NX)
      PARDIF(N,M,L,NZ,NY,NX)=0.0
      PAR(N,M,L,NZ,NY,NX)=PARDIR(N,M,NZ,NY,NX)
1100  CONTINUE
      XAREA=1.00/AREA(3,NU(NY,NX),NY,NX)
      YAREA=0.25/AREA(3,NU(NY,NX),NY,NX)
      RADYL=RADY(NY,NX)
      RAPYL=RAPY(NY,NX)
      TAUS(NC(NY,NX)+1,NY,NX)=1.0
      TAUY(NC(NY,NX)+1)=1.0
      RAFSL(NC(NY,NX)+1)=0.0
      RAFPL(NC(NY,NX)+1)=0.0
      STOPS=0.0
C
C     RESET ARRAYS OF SUNLIT AND SHADED LEAF AREAS IN DIFFERENT
C     LAYERS AND ANGLE CLASSES
C
      DO 1150 NZ=1,NP(NY,NX)
      ARLFS(NZ,NY,NX)=0.0
      DO 1150 L=1,NC(NY,NX)
      DO 1150 N=1,4
      TSURF(N,L,NZ,NY,NX)=0.0
      TSURFB(N,L,NZ,NY,NX)=0.0
1150  CONTINUE
      DO 1200 NZ=1,NP(NY,NX)
      DO 1200 NB=1,NBR(NZ,NY,NX)
      DO 1200 K=1,25
      DO 1200 L=1,NC(NY,NX)
      DO 1200 N=1,4
      TSURF(N,L,NZ,NY,NX)=TSURF(N,L,NZ,NY,NX)+SURF(N,L,K,NB,NZ,NY,NX)
      IF(ZL(L,NY,NX).GT.DPTHS(NY,NX))THEN
      ARLFS(NZ,NY,NX)=ARLFS(NZ,NY,NX)+4.0*SURF(N,L,K,NB,NZ,NY,NX)
      ENDIF
1200  CONTINUE
      DO 1210 NZ=1,NP(NY,NX)
      DO 1210 NB=1,NBR(NZ,NY,NX)
      DO 1210 L=1,NC(NY,NX)
      DO 1210 N=1,4
      TSURFB(N,L,NZ,NY,NX)=TSURFB(N,L,NZ,NY,NX)+SURFB(N,L,NB,NZ,NY,NX)
      IF(ZL(L,NY,NX).GT.DPTHS(NY,NX))THEN
      ARLFS(NZ,NY,NX)=ARLFS(NZ,NY,NX)+4.0*SURFB(N,L,NB,NZ,NY,NX)
      ENDIF
1210  CONTINUE
C
C     CALCULATE ABSORPTION, REFLECTION AND TRANSMISSION OF DIRECT AND DIFFUSE
C     DOWNWARD TOTAL AND VISIBLE RADIATION BY EACH SPECIES NZ IN EACH LAYER L
C
      DO 1800 L=NC(NY,NX),1,-1
      IF(ZL(L,NY,NX).GT.DPTHS(NY,NX))THEN
      RADYL=RADYL*TAUY(L+1)+RAFSL(L+1)
      RAPYL=RAPYL*TAUY(L+1)+RAFPL(L+1)
      RAFSL(L)=0.0
      RAFPL(L)=0.0
      RABSL(L)=0.0
      RABPL(L)=0.0
      STOPY=0.0
      STOPSZ=0.0
      STOPYZ=0.0
C
C     RESET ACCUMULATORS OB ABSORBED, REFLECTED AND TRANSMITTED RADIATION
C
      DO 1500 NZ=1,NP(NY,NX)
      RADSL(NZ,NY,NX)=0.0
      RADSW(NZ,NY,NX)=0.0
      RADPL(NZ,NY,NX)=0.0
      RADPW(NZ,NY,NX)=0.0
      RAYSL(NZ,NY,NX)=0.0
      RAYSW(NZ,NY,NX)=0.0
      RAYPL(NZ,NY,NX)=0.0
      RAYPW(NZ,NY,NX)=0.0
      RADS1(NZ,NY,NX)=0.0
      RADW1(NZ,NY,NX)=0.0
      RADP1(NZ,NY,NX)=0.0
      RADQ1(NZ,NY,NX)=0.0
      RAYS1(NZ,NY,NX)=0.0
      RAYW1(NZ,NY,NX)=0.0
      RAYP1(NZ,NY,NX)=0.0
      RAYQ1(NZ,NY,NX)=0.0
      RADS2(NZ,NY,NX)=0.0
      RADW2(NZ,NY,NX)=0.0
      RADP2(NZ,NY,NX)=0.0
      RADQ2(NZ,NY,NX)=0.0
      RAYS2(NZ,NY,NX)=0.0
      RAYW2(NZ,NY,NX)=0.0
      RAYP2(NZ,NY,NX)=0.0
      RAYQ2(NZ,NY,NX)=0.0
C
C     LEAF SURFACE AREA IN EACH INCLINATION CLASS N, AZIMUTH CLASS M,
C     LAYER L AND SPECIES NZ
C
      DO 1600 N=1,4
      TSURFY=TSURF(N,L,NZ,NY,NX)*CFX(NZ,NY,NX)
      TSURFZ=TSURFY*YAREA
      TSURFS=TSURFY*TAUS(L+1,NY,NX)
      TSURFX=TSURFS*XAREA
      TSURWY=TSURFB(N,L,NZ,NY,NX)*CFW
      TSURWZ=TSURWY*YAREA
      TSURWS=TSURWY*TAUS(L+1,NY,NX)
      TSURWX=TSURWS*XAREA
C
C     ABSORPTION OF DIRECT RADIATION BY SUNLIT LEAF SURFACES
C
      DO 1700 M=1,4
      RADSL(NZ,NY,NX)=RADSL(NZ,NY,NX)+TSURFS*RDNDIR(N,M,NZ,NY,NX)
      RADSW(NZ,NY,NX)=RADSW(NZ,NY,NX)+TSURWS*RDNDIW(N,M,NZ,NY,NX)
      RADPL(NZ,NY,NX)=RADPL(NZ,NY,NX)+TSURFS*PARDIR(N,M,NZ,NY,NX)
      RADPW(NZ,NY,NX)=RADPW(NZ,NY,NX)+TSURWS*PARDIW(N,M,NZ,NY,NX)
      STOPSZ=STOPSZ+(TSURFX+TSURWX)*BETX(N,M)
C
C     BACKSCATTERING OF REFLECTED DIRECT RADIATION
C
      IF(IALBS(N,M).EQ.1)THEN
      RADS1(NZ,NY,NX)=RADS1(NZ,NY,NX)+TSURFS*RDNDIR(N,M,NZ,NY,NX)
      RADW1(NZ,NY,NX)=RADW1(NZ,NY,NX)+TSURWS*RDNDIW(N,M,NZ,NY,NX)
      RADP1(NZ,NY,NX)=RADP1(NZ,NY,NX)+TSURFS*PARDIR(N,M,NZ,NY,NX)
      RADQ1(NZ,NY,NX)=RADQ1(NZ,NY,NX)+TSURWS*PARDIW(N,M,NZ,NY,NX)
C
C     FORWARD SCATTERING OF REFLECTED DIRECT RADIATION
C
      ELSE
      RADS2(NZ,NY,NX)=RADS2(NZ,NY,NX)+TSURFS*RDNDIR(N,M,NZ,NY,NX)
      RADW2(NZ,NY,NX)=RADW2(NZ,NY,NX)+TSURWS*RDNDIW(N,M,NZ,NY,NX)
      RADP2(NZ,NY,NX)=RADP2(NZ,NY,NX)+TSURFS*PARDIR(N,M,NZ,NY,NX)
      RADQ2(NZ,NY,NX)=RADQ2(NZ,NY,NX)+TSURWS*PARDIW(N,M,NZ,NY,NX)
      ENDIF
C
C     INTENSITY OF ABSORBED DIFFUSE RADIATION AT LEAF SURFACES
C
      DO 1750 NN=1,4
      RADYN=RADYL*OMEGA(M,N,NN)*ABSR(NZ,NY,NX)
      RADYW=RADYL*OMEGA(M,N,NN)*ABSRW
      RAPYN=RAPYL*OMEGA(M,N,NN)*ABSP(NZ,NY,NX)
      RAPYW=RAPYL*OMEGA(M,N,NN)*ABSPW
      PARDIF(N,M,L,NZ,NY,NX)=PARDIF(N,M,L,NZ,NY,NX)+RAPYN
      PAR(N,M,L,NZ,NY,NX)=PAR(N,M,L,NZ,NY,NX)+RAPYN
C
C     ABSORPTION OF DIFFUSE RADIATION BY SHADED LEAF SURFACES
C
      RAYSL(NZ,NY,NX)=RAYSL(NZ,NY,NX)+TSURFY*RADYN
      RAYSW(NZ,NY,NX)=RAYSW(NZ,NY,NX)+TSURWY*RADYW
      RAYPL(NZ,NY,NX)=RAYPL(NZ,NY,NX)+TSURFY*RAPYN
      RAYPW(NZ,NY,NX)=RAYPW(NZ,NY,NX)+TSURWY*RAPYW
      STOPYZ=STOPYZ+(TSURFZ+TSURWZ)*OMEGX(M,N,NN)
C
C     BACKSCATTERING OF REFLECTED DIFFUSE RADIATION
C
      IF(IALBY(M,N,NN).EQ.1)THEN
      RAYS1(NZ,NY,NX)=RAYS1(NZ,NY,NX)+TSURFY*RADYN
      RAYW1(NZ,NY,NX)=RAYW1(NZ,NY,NX)+TSURWY*RADYW
      RAYP1(NZ,NY,NX)=RAYP1(NZ,NY,NX)+TSURFY*RAPYN
      RAYQ1(NZ,NY,NX)=RAYQ1(NZ,NY,NX)+TSURWY*RAPYW
C
C     FORWARD SCATTERING OF REFLECTED DIFFUSE RADIATION
C
      ELSE
      RAYS2(NZ,NY,NX)=RAYS2(NZ,NY,NX)+TSURFY*RADYN
      RAYW2(NZ,NY,NX)=RAYW2(NZ,NY,NX)+TSURWY*RADYW
      RAYP2(NZ,NY,NX)=RAYP2(NZ,NY,NX)+TSURFY*RAPYN
      RAYQ2(NZ,NY,NX)=RAYQ2(NZ,NY,NX)+TSURWY*RAPYW
      ENDIF
1750  CONTINUE
1700  CONTINUE
1600  CONTINUE
1500  CONTINUE
C
C     CHECK TOTAL INTERCEPTION IN CANOPY LAYER
C

      IF(STOPS+STOPSZ.GT.1.0)THEN
      IF(STOPSZ.GT.ZERO)THEN
      XTAUS=(1.0-STOPS)/((1.0-STOPS)-(1.0-STOPS-STOPSZ))
      ELSE
      XTAUS=0.0
      ENDIF
      TAUS(L+1,NY,NX)=TAUS(L+1,NY,NX)*XTAUS
      STOPSZ=STOPSZ*XTAUS
      DO 1510 NZ=1,NP(NY,NX)
      RADSL(NZ,NY,NX)=RADSL(NZ,NY,NX)*XTAUS
      RADSW(NZ,NY,NX)=RADSW(NZ,NY,NX)*XTAUS
      RADPL(NZ,NY,NX)=RADPL(NZ,NY,NX)*XTAUS
      RADPW(NZ,NY,NX)=RADPW(NZ,NY,NX)*XTAUS
      RADS1(NZ,NY,NX)=RADS1(NZ,NY,NX)*XTAUS
      RADW1(NZ,NY,NX)=RADW1(NZ,NY,NX)*XTAUS
      RADP1(NZ,NY,NX)=RADP1(NZ,NY,NX)*XTAUS
      RADQ1(NZ,NY,NX)=RADQ1(NZ,NY,NX)*XTAUS
      RADS2(NZ,NY,NX)=RADS2(NZ,NY,NX)*XTAUS
      RADW2(NZ,NY,NX)=RADW2(NZ,NY,NX)*XTAUS
      RADP2(NZ,NY,NX)=RADP2(NZ,NY,NX)*XTAUS
      RADQ2(NZ,NY,NX)=RADQ2(NZ,NY,NX)*XTAUS
1510  CONTINUE
      ENDIF
      IF(STOPY+STOPYZ.GT.1.0)THEN
      XTAUY=(1.0-STOPY)/((1.0-STOPY)-(1.0-STOPY-STOPYZ))
      TAUY(L+1)=TAUY(L+1)*XTAUY
      STOPYZ=STOPYZ*XTAUY
      DO 1520 NZ=1,NP(NY,NX)
      RAYSL(NZ,NY,NX)=RAYSL(NZ,NY,NX)*XTAUY
      RAYSW(NZ,NY,NX)=RAYSW(NZ,NY,NX)*XTAUY
      RAYPL(NZ,NY,NX)=RAYPL(NZ,NY,NX)*XTAUY
      RAYPW(NZ,NY,NX)=RAYPW(NZ,NY,NX)*XTAUY
      RAYS1(NZ,NY,NX)=RAYS1(NZ,NY,NX)*XTAUY
      RAYW1(NZ,NY,NX)=RAYW1(NZ,NY,NX)*XTAUY
      RAYP1(NZ,NY,NX)=RAYP1(NZ,NY,NX)*XTAUY
      RAYQ1(NZ,NY,NX)=RAYQ1(NZ,NY,NX)*XTAUY
      RAYS2(NZ,NY,NX)=RAYS2(NZ,NY,NX)*XTAUY
      RAYW2(NZ,NY,NX)=RAYW2(NZ,NY,NX)*XTAUY
      RAYP2(NZ,NY,NX)=RAYP2(NZ,NY,NX)*XTAUY
      RAYQ2(NZ,NY,NX)=RAYQ2(NZ,NY,NX)*XTAUY
      DO 1730 N=1,4
      DO 1730 M=1,4
      PARDIF(N,M,L,NZ,NY,NX)=PARDIF(N,M,L,NZ,NY,NX)*XTAUY
      PAR(N,M,L,NZ,NY,NX)=PARDIR(N,M,NZ,NY,NX)+PARDIF(N,M,L,NZ,NY,NX)
1730  CONTINUE
1520  CONTINUE
      ENDIF
C
C     TOTAL RADIATION ABSORBED, REFLECTED AND TRANSMITTED BY ALL PLANT SPECIES
C
      DO 1530 NZ=1,NP(NY,NX)
      RADST=RADSL(NZ,NY,NX)+RAYSL(NZ,NY,NX)
      RADWT=RADSW(NZ,NY,NX)+RAYSW(NZ,NY,NX)
      RADPT=RADPL(NZ,NY,NX)+RAYPL(NZ,NY,NX)
      RADQT=RADPW(NZ,NY,NX)+RAYPW(NZ,NY,NX)
      RA1ST=RADS1(NZ,NY,NX)+RAYS1(NZ,NY,NX)
      RA1WT=RADW1(NZ,NY,NX)+RAYW1(NZ,NY,NX)
      RA1PT=RADP1(NZ,NY,NX)+RAYP1(NZ,NY,NX)
      RA1QT=RADP1(NZ,NY,NX)+RAYQ1(NZ,NY,NX)
      RA2ST=RADS2(NZ,NY,NX)+RAYS2(NZ,NY,NX)
      RA2WT=RADW2(NZ,NY,NX)+RAYW2(NZ,NY,NX)
      RA2PT=RADP2(NZ,NY,NX)+RAYP2(NZ,NY,NX)
      RA2QT=RADQ2(NZ,NY,NX)+RAYQ2(NZ,NY,NX)
      RAFSL(L)=RAFSL(L)+(RADST*TAUR(NZ,NY,NX)
     2+RA2ST*ALBR(NZ,NY,NX)+RA2WT*ALBRW)*YAREA
      RAFPL(L)=RAFPL(L)+(RADPT*TAUP(NZ,NY,NX)
     2+RA2PT*ALBP(NZ,NY,NX)+RA2QT*ALBPW)*YAREA
      RABSL(L)=RABSL(L)+(RA1ST*ALBR(NZ,NY,NX)+RA1WT*ALBRW)*YAREA
      RABPL(L)=RABPL(L)+(RA1PT*ALBP(NZ,NY,NX)+RA1QT*ALBPW)*YAREA
      RADC(NZ,NY,NX)=RADC(NZ,NY,NX)+RADST+RADWT
      RADP(NZ,NY,NX)=RADP(NZ,NY,NX)+RADPT+RADQT
      TRADC(NY,NX)=TRADC(NY,NX)+RADST+RADWT
      TRAPC(NY,NX)=TRAPC(NY,NX)+RADPT+RADQT
1530  CONTINUE
      STOPS=STOPS+STOPSZ
      STOPY=STOPY+STOPYZ
      TAUS(L,NY,NX)=1.0-STOPS
      TAU0(L,NY,NX)=1.0-TAUS(L,NY,NX)
      TAUY(L)=1.0-STOPY
      ELSE
      RAFSL(L)=RAFSL(L+1)
      RAFPL(L)=RAFPL(L+1)
      TAUS(L,NY,NX)=TAUS(L+1,NY,NX)
      TAU0(L,NY,NX)=1.0-TAUS(L,NY,NX)
      TAUY(L)=TAUY(L+1)
      ENDIF
1800  CONTINUE
C
C     DIRECT AND DIFFUSE RADIATION ABSORBED AT GROUND SURFACE
C
      RADSG=RADS(NY,NX)*TAUS(1,NY,NX)
      RADYG=RADYL*TAUY(1)+RAFSL(1)
      RAPSG=RAPS(NY,NX)*TAUS(1,NY,NX)
      RAPYG=RAPYL*TAUY(1)+RAFPL(1)
      RASG=ABS(BETAG)*RADSG
      RAPG=ABS(BETAG)*RAPSG
      DO 20 N=1,4
      RASG=RASG+ABS(OMEGAG(N,NY,NX))*RADYG
      RAPG=RAPG+ABS(OMEGAG(N,NY,NX))*RAPYG
20    CONTINUE
      RADG(NY,NX)=RASG*AREA(3,NU(NY,NX),NY,NX)
C
C     RADIATION REFLECTED FROM GROUND SURFACE
C
      IF(VHCPW(NY,NX).GT.VHCPWX(NY,NX))THEN
      ALBW=(0.85*VOLSS(NY,NX)+0.30*VOLIS(NY,NX)+0.06*VOLWS(NY,NX))
     2/(VOLSS(NY,NX)+VOLIS(NY,NX)+VOLWS(NY,NX))
      FSNOW=AMIN1((DPTHS(NY,NX)/0.07)**2,1.0)
      ALBG=FSNOW*ALBW+(1.0-FSNOW)*ALBS(NY,NX)
      ELSE
      THETW1=AMIN1(POROS(NU(NY,NX),NY,NX)
     2,VOLW(NU(NY,NX),NY,NX)/VOLX(NU(NY,NX),NY,NX))
      ALBG=AMIN1(ALBX(NY,NX),ALBS(NY,NX)
     2+AMAX1(0.0,ALBX(NY,NX)-THETW1))
      ENDIF
      RABSL(0)=RASG*ALBG*0.25
      RABPL(0)=RAPG*ALBG*0.25
      TRADG(NY,NX)=(1.0-ALBG)*RASG*AREA(3,NU(NY,NX),NY,NX)
      TRAPG(NY,NX)=(1.0-ALBG)*RAPG*AREA(3,NU(NY,NX),NY,NX)
C
C     ADD RADIATION FROM SCATTERING THROUGH CANOPY LAYERS
C
      RADYL=0.0
      RAPYL=0.0
      TAUY(0)=1.0
      RAFSL(0)=0.0
      RAFPL(0)=0.0
      DO 2800 L=1,NC(NY,NX)
      IF(ZL(L,NY,NX).GT.DPTHS(NY,NX))THEN
      RADYL=RADYL*TAUY(L-1)+RAFSL(L-1)+RABSL(L-1)
      RAPYL=RAPYL*TAUY(L-1)+RAFPL(L-1)+RABPL(L-1)
      RAFSL(L)=0.0
      RAFPL(L)=0.0
      DO 2500 NZ=1,NP(NY,NX)
      RAYSL(NZ,NY,NX)=0.0
      RAYSW(NZ,NY,NX)=0.0
      RAYPL(NZ,NY,NX)=0.0
      RAYPW(NZ,NY,NX)=0.0
      DO 2600 N=1,4
      TSURFY=TSURF(N,L,NZ,NY,NX)*CFX(NZ,NY,NX)
      TSURWY=TSURFB(N,L,NZ,NY,NX)*CFW
      DO 2700 M=1,4
      DO 2750 NN=1,4
      RADYN=RADYL*OMEGA(M,N,NN)*ABSR(NZ,NY,NX)
      RADYW=RADYL*OMEGA(M,N,NN)*ABSRW
      RAPYN=RAPYL*OMEGA(M,N,NN)*ABSP(NZ,NY,NX)
      RAPYW=RAPYL*OMEGA(M,N,NN)*ABSPW
      PARDIF(N,M,L,NZ,NY,NX)=PARDIF(N,M,L,NZ,NY,NX)+RAPYN
      PAR(N,M,L,NZ,NY,NX)=PAR(N,M,L,NZ,NY,NX)+RAPYN
      RAYSL(NZ,NY,NX)=RAYSL(NZ,NY,NX)+TSURFY*RADYN
      RAYSW(NZ,NY,NX)=RAYSW(NZ,NY,NX)+TSURWY*RADYW
      RAYPL(NZ,NY,NX)=RAYPL(NZ,NY,NX)+TSURFY*RAPYN
      RAYPW(NZ,NY,NX)=RAYPW(NZ,NY,NX)+TSURWY*RAPYW
2750  CONTINUE
2700  CONTINUE
2600  CONTINUE
      RAFSL(L)=RAFSL(L)+RAYSL(NZ,NY,NX)*TAUR(NZ,NY,NX)*YAREA
      RAFPL(L)=RAFPL(L)+RAYPL(NZ,NY,NX)*TAUP(NZ,NY,NX)*YAREA
      RADC(NZ,NY,NX)=RADC(NZ,NY,NX)+RAYSL(NZ,NY,NX)+RAYSW(NZ,NY,NX)
      RADP(NZ,NY,NX)=RADP(NZ,NY,NX)+RAYPL(NZ,NY,NX)+RAYPW(NZ,NY,NX)
      TRADC(NY,NX)=TRADC(NY,NX)+RAYSL(NZ,NY,NX)+RAYSW(NZ,NY,NX)
      TRAPC(NY,NX)=TRAPC(NY,NX)+RAYPL(NZ,NY,NX)+RAYPW(NZ,NY,NX)
2500  CONTINUE
      ELSE
      RAFSL(L)=RAFSL(L-1)
      RAFPL(L)=RAFPL(L-1)
      RABSL(L)=RABSL(L-1)
      RABPL(L)=RABPL(L-1)
      ENDIF
2800  CONTINUE
      IF(ABS(J-ZNOON(NY,NX)).LT.1)THEN
      FRADG(NY,NX)=AMAX1(0.0,1.0-TRAPC(NY,NX)
     2/(RAP(NY,NX)*AREA(3,NU(NY,NX),NY,NX)))
      ENDIF
      ELSE
C
C     RADIATION AT GROUND SURFACE IF NO CANOPY
C
      RASG=ABS(BETAG)*RADS(NY,NX)
      DO 120 N=1,4
      RASG=RASG+ABS(OMEGAG(N,NY,NX))*RADY(NY,NX)
120   CONTINUE
      RADG(NY,NX)=RASG*AREA(3,NU(NY,NX),NY,NX)
      FRADG(NY,NX)=1.0
      ENDIF
      ELSE
      RADG(NY,NX)=0.0
      IF(IFLGX(NY,NX).EQ.0)THEN
      FRADG(NY,NX)=1.0
      ENDIF
      ENDIF
C
C     CANOPY ZERO PLANE DISPLACEMENT AND SURFACE ROUGHNESS HEIGHTS
C     CALCULATED FROM CANOPY HEIGHT AND LEAF AREA
C
      ZT(NY,NX)=0.0
      DO 9685 NZ=1,NP(NY,NX)
      ZT(NY,NX)=AMAX1(ZT(NY,NX),ZC(NZ,NY,NX))
9685  CONTINUE
      ZL(NC(NY,NX),NY,NX)=ZT(NY,NX)+0.01
      ZL1(NC(NY,NX),NY,NX)=ZL(NC(NY,NX),NY,NX)
      ZL1(0,NY,NX)=0.0
      ART=(ARLFC(NY,NX)+ARSTC(NY,NX))/NC(NY,NX)
      IF(ART.GT.ZEROS(NY,NX))THEN
      DO 2765 L=NC(NY,NX),2,-1
      ARL=ARLFT(L,NY,NX)+ARSTT(L,NY,NX)
      IF(ARL.GT.1.01*ART)THEN
      DZL=ZL(L,NY,NX)-ZL(L-1,NY,NX)
      ZL1(L-1,NY,NX)=ZL(L-1,NY,NX)+0.5*AMIN1(1.0,(ARL-ART)/ARL)*DZL
      ELSEIF(ARL.LT.0.99*ART)THEN
      ARX=ARLFT(L-1,NY,NX)+ARSTT(L-1,NY,NX)
      DZL=ZL(L-1,NY,NX)-ZL(L-2,NY,NX)
      IF(ARX.GT.ZEROS(NY,NX))THEN
      ZL1(L-1,NY,NX)=ZL(L-1,NY,NX)-0.5*AMIN1(1.0,(ART-ARL)/ARX)*DZL
      ENDIF
      ELSE
      ZL1(L-1,NY,NX)=ZL(L-1,NY,NX)
      ENDIF
C     IF(J.EQ.12)THEN
C     WRITE(*,3233)'ZL',I,J,NX,NY,L,ZL1(L,NY,NX),ZL1(L-1,NY,NX)
C    3,ZL(L,NY,NX),ZL(L-1,NY,NX),ART,ARL,ARX
C    2,DZL,ARLFC(NY,NX),ARSTC(NY,NX),ARLFT(L,NY,NX),ARSTT(L,NY,NX)
C    3,ARLFT(L-1,NY,NX),ARSTT(L-1,NY,NX)
C    3,ZL(NC(NY,NX),NY,NX),ZT(NY,NX),ZC(1,NY,NX)
3233  FORMAT(A8,5I4,30E12.4)
C     ENDIF
2765  CONTINUE
      DO 2770 L=NC(NY,NX),2,-1
      ZL(L-1,NY,NX)=ZL1(L-1,NY,NX)
C     ZL(L-1,NY,NX)=AMAX1(0.0,AMIN1(ZL(L,NY,NX)-1.0E-06,ZL(L-1,NY,NX)))
2770  CONTINUE
      ENDIF
      ARLSC=ARLFC(NY,NX)+ARSTC(NY,NX)
      IF(ARLSC.GT.ZEROS(NY,NX).AND.ZT(NY,NX).GT.DPTHS(NY,NX))THEN
      ARLSG=ARLSC/AREA(3,NU(NY,NX),NY,NX)
      ZX=EXP(-0.5*ARLSG)
      ZY=1.0-ZX
      ZD(NY,NX)=ZT(NY,NX)*AMAX1(0.0,1.0-2.0/ARLSG*ZY)
      ZE=ZT(NY,NX)*AMAX1(0.05,ZX*ZY)
      ELSE
      ZD(NY,NX)=0.0
      ZE=0.0
      ENDIF
      IF(IFLGW.EQ.1)THEN
      ZZ=Z0(NY,NX)+ZT(NY,NX)
      ELSE
      ZZ=AMAX1(Z0(NY,NX),ZD(NY,NX)+2.0)
      ENDIF
      IF(IETYP(NY,NX).GE.0)THEN
      IF(VHCPW(NY,NX).GT.VHCPWX(NY,NX))THEN
      ZR(NY,NX)=AMAX1(0.001,ZE,ZW)
      ELSE
      ZR(NY,NX)=AMAX1(0.001,ZE,ZS(NY,NX))
      ENDIF
C
C     CANOPY ISOTHERMAL BOUNDARY LAYER RESISTANCE AND RICHARDSON NUMBER
C
      RAB(NY,NX)=AMAX1(1.39E-03,
     2(LOG((ZZ-ZD(NY,NX))/ZR(NY,NX)))**2/(0.168*UA(NY,NX)))
      RIB(NY,NX)=1.27E+08*(ZZ-ZR(NY,NX))/(UA(NY,NX)**2*TKA(NY,NX))
      ELSE
      RAB(NY,NX)=1.39E-03
      RIB(NY,NX)=0.0
      ENDIF
      THRMCX(NY,NX)=THRMC(NY,NX)
      THRMGX(NY,NX)=THRMG(NY,NX)
      CNETX(NY,NX)=TCNET(NY,NX)/AREA(3,NU(NY,NX),NY,NX)
      THRMC(NY,NX)=0.0
      THRMG(NY,NX)=0.0
      TLEX(NY,NX)=TLEC(NY,NX)
      TSHX(NY,NX)=TSHC(NY,NX)
      TLEC(NY,NX)=0.0
      TSHC(NY,NX)=0.0
      TRN(NY,NX)=0.0
      TLE(NY,NX)=0.0
      TSH(NY,NX)=0.0
      TGH(NY,NX)=0.0
      TCNET(NY,NX)=0.0
      GPP(NY,NX)=0.0
      RECO(NY,NX)=0.0
      DO 1930 NZ=1,NP(NY,NX)
C
C     FRACTION OF INCOMING PAR ABSORBED BY CANOPY USED TO CALCULATE
C     SKY VIEW FACTOR IN CANOPY WATER AND ENERGY EXCHANGE CALCULATIONS
C
      IF(ABS(J-ZNOON(NY,NX)).LT.1)THEN
      IF(RAP(NY,NX).GT.0.0)THEN
      FRADP(NZ,NY,NX)=AMAX1(0.0,RADP(NZ,NY,NX)
     2/(RAP(NY,NX)*AREA(3,NU(NY,NX),NY,NX)))
      ELSE
      FRADP(NZ,NY,NX)=1.0-EXP(-0.65*ARLFS(NZ,NY,NX)
     2/AREA(3,NU(NY,NX),NY,NX))
      ENDIF
C     WRITE(19,1926)'CANOPY',IYRC,I,J,NX,NY,NZ,FRADP(NZ,NY,NX)
C    2,RADP(NZ,NY,NX)/AREA(3,NU(NY,NX),NY,NX),RAP(NY,NX)
C    3,ARLFP(NZ,NY,NX)/AREA(3,NU(NY,NX),NY,NX)
C    4,ARSTP(NZ,NY,NX)/AREA(3,NU(NY,NX),NY,NX)
C    5,ARLFS(NZ,NY,NX)/AREA(3,NU(NY,NX),NY,NX)
1926  FORMAT(A10,6I6,30E12.4)
      ENDIF
      VOLWCX=XVOLWC(IGTYP(NZ,NY,NX))*(ARLFP(NZ,NY,NX)+ARSTP(NZ,NY,NX))
      FLWC(NZ,NY,NX)=AMAX1(0.0,AMIN1(PRECA(NY,NX)*FRADP(NZ,NY,NX)
     2,VOLWCX-VOLWC(NZ,NY,NX)))
      TFLWC(NY,NX)=TFLWC(NY,NX)+FLWC(NZ,NY,NX)
C
C     NUMBERS OF TOP AND BOTTOM ROOTED SOIL LAYERS FOR EACH PLANT SPECIES
C
      NG(NZ,NY,NX)=MAX(NG(NZ,NY,NX),NU(NY,NX))
      NIX(NZ,NY,NX)=MAX(NIX(NZ,NY,NX),NU(NY,NX))
      DO 9790 NR=1,10
      NINR(NR,NZ,NY,NX)=MAX(NINR(NR,NZ,NY,NX),NU(NY,NX))
9790  CONTINUE
1930  CONTINUE
C    ZM uncommented
C     WRITE SW AND PAR ALBEDO
C  RAD:shortwave rad, TRADC (total shortwave absorbed by all canopies) 
C  TRADG(total shortwave absorbed by all ground),  
C  RAP (par rad),TRAPC (total par ab. canopy), 
C      IF(ABS(J-ZNOON(NY,NX)).LT.1)THEN
C      IF(IYRC.GT.2009.OR.IYRC.EQ.1903)THEN
C      IF(IYRC.GT.2009)THEN
C 9292  FORMAT(A9,2I4,20E12.4)
C ....      IF(J.EQ.ZNOON(NY,NX))THEN
C ....       IF(RAD(NY,NX).GT.0.0.AND.RAP(NY,NX).GT.0.0)THEN
C      WRITE(55,*)'ALBEDD IYRC I J NX NY RAD TRADC TRADG ALBE' 
C ....       WRITE(55,1927)'ALBEDO',IYRC,I,J,NX,NY
C ....      2,RAD(NY,NX),TRADC(NY,NX)
C ....     3,TRADG(NY,NX)
C ....      4,(RAD(NY,NX)-TRADC(NY,NX)-TRADG(NY,NX))/RAD(NY,NX) 
C     5,(RAP(NY,NX)-TRAPC(NY,NX)-TRAPG(NY,NX))/RAP(NY,NX) 
C      WRITE(55,1927)'ALBEDO',IYRC,I,J,NX,NY
C     2,RAD(NY,NX),RAP(NY,NX),TRADC(NY,NX),TRAPC(NY,NX)
C     3,TRADG(NY,NX),TRAPG(NY,NX)
C     4,(RAD(NY,NX)-TRADC(NY,NX)-TRADG(NY,NX))/RAD(NY,NX) 
C     5,(RAP(NY,NX)-TRAPC(NY,NX)-TRAPG(NY,NX))/RAP(NY,NX)
C   ZM
C
C %%%%%%%%%
C     WRITE SW AND PAR ALBEDO
C
C      IF(ABS(J-ZNOON(NY,NX)).LT.1)THEN
C      IF(RAD(NY,NX).GT.0.0.AND.RAP(NY,NX).GT.0.0)THEN
C      WRITE(55,1927)'ALBEDO',IYRC,I,J,NX,NY
C     2,RAD(NY,NX),RAP(NY,NX),TRADC(NY,NX),TRAPC(NY,NX)
C     3,TRADG(NY,NX),TRAPG(NY,NX)
C     4,(RAD(NY,NX)-TRADC(NY,NX)-TRADG(NY,NX))/RAD(NY,NX) 
C     5,(RAP(NY,NX)-TRAPC(NY,NX)-TRAPG(NY,NX))/RAP(NY,NX) 
C %%%%%%%%
1927  FORMAT(A10,5I6,30E12.4)
C      ENDIF
C      ENDIF
C      ENDIF
9990  CONTINUE
9995  CONTINUE
C
C     FERTILIZER APPLICATIONS OCCUR AT SOLAR NOON
C
      DO 8990 NX=NHW,NHE
      DO 8995 NY=NVN,NVS
      IF(J.EQ.INT(ZNOON(NY,NX)))THEN
C
C     NH4,NH3,UREA,NO3 BROADCAST (A) AND BANDED (B)
C
      Z4A=FERT(1,I,NY,NX)
      Z3A=FERT(2,I,NY,NX)
      ZUA=FERT(3,I,NY,NX)
      ZOA=FERT(4,I,NY,NX)
      Z4B=FERT(5,I,NY,NX)
      Z3B=FERT(6,I,NY,NX)
      ZUB=FERT(7,I,NY,NX)
      ZOB=FERT(8,I,NY,NX)
C
C     MONOCALCIUM PHOSPHATE OR HYDROXYAPATITE BROADCAST (A) AND BANDED (B)
C
      PMA=FERT(9,I,NY,NX)
      PMB=FERT(10,I,NY,NX)
      PHA=FERT(11,I,NY,NX)
C
C     LIME AND GYPSUM
C
      CAC=FERT(12,I,NY,NX)
      CAS=FERT(13,I,NY,NX)
C
C     PLANT AND ANIMAL RESIDUE C, N AND P
C
      OFC(1)=FERT(14,I,NY,NX)
      OFN(1)=FERT(15,I,NY,NX)
      OFP(1)=FERT(16,I,NY,NX)
      OFC(2)=FERT(17,I,NY,NX)
      OFN(2)=FERT(18,I,NY,NX)
      OFP(2)=FERT(19,I,NY,NX)
C
C     SOIL LAYER NUMBER AT DEPTH OF APPLICATION
C
      IF(Z4A+Z3A+ZUA+ZOA+Z4B+Z3B+ZUB+ZOB+PMA+PMB+PHA+CAC+CAS.GT.0.0)THEN
      IF(FDPTH(I,NY,NX).LE.0.0.AND.Z4B+Z3B+ZUB+ZOB+PMB.EQ.0.0)THEN
      LFDPTH=0
      CVRD=1.0-EXP(-0.8E-02*(ORGC(0,NY,NX)/AREA(3,0,NY,NX)))
      ELSE
      DO 65 L=NU(NY,NX),JZ
      IF(CDPTH(L,NY,NX).GE.FDPTH(I,NY,NX))THEN
      LFDPTH=L
      CVRD=1.0
      GO TO 55
      ENDIF
65    CONTINUE
55    CONTINUE
      ENDIF
      BARE=1.0-CVRD
C
C     RESET WIDTH AND DEPTH OF NH4 FERTILIZER BAND IF NEW BAND APPLICATION
C     AND ADD REMAINS OF ANY EXISTING FERTILIZER BAND TO NEW BAND
C
      IF((Z4B+Z3B+ZUB.GT.0.0).OR.((ZNH4B(LFDPTH,NY,NX).GT.0.0
     2.OR.ZNH3B(LFDPTH,NY,NX).GT.0.0).AND.IFNHB(NY,NX).EQ.0))THEN
      IFNHB(NY,NX)=1
      ROWN(NY,NX)=ROWI(I,NY,NX)
      DO 50 L=NU(NY,NX),JZ
      IF(L.LT.LFDPTH)THEN
      DPNHB(L,NY,NX)=DLYR(3,L,NY,NX)
      WDNHB(L,NY,NX)=0.0
      ELSEIF(L.EQ.LFDPTH)THEN
C     IF(Z3B.GT.0.0)THEN
C     DPNHB(L,NY,NX)=AMAX1(0.10,FDPTH(I,NY,NX)-CDPTH(L-1,NY,NX))
C     WDNHB(L,NY,NX)=AMIN1(0.10,ROWN(NY,NX))
C     ELSE
      DPNHB(L,NY,NX)=AMAX1(0.01,FDPTH(I,NY,NX)-CDPTH(L-1,NY,NX))
      WDNHB(L,NY,NX)=AMIN1(0.01,ROWN(NY,NX))
C     ENDIF
      ELSE
      DPNHB(L,NY,NX)=0.0
      WDNHB(L,NY,NX)=0.0
      ENDIF
      VLNHB(L,NY,NX)=AMIN1(0.999,WDNHB(L,NY,NX)/ROWN(NY,NX)
     2*DPNHB(L,NY,NX)/DLYR(3,L,NY,NX))
      VLNH4(L,NY,NX)=1.0-VLNHB(L,NY,NX)
      ZNH4T=ZNH4S(L,NY,NX)+ZNH4B(L,NY,NX)
      ZNH3T=ZNH3S(L,NY,NX)+ZNH3B(L,NY,NX)
      XN4T=XN4(L,NY,NX)+XNB(L,NY,NX)
      ZNH4S(L,NY,NX)=ZNH4T*VLNH4(L,NY,NX)
      ZNH3S(L,NY,NX)=ZNH3T*VLNH4(L,NY,NX)
      ZNH4B(L,NY,NX)=ZNH4T*VLNHB(L,NY,NX)
      ZNH3B(L,NY,NX)=ZNH3T*VLNHB(L,NY,NX)
      XN4(L,NY,NX)=XN4T*VLNH4(L,NY,NX)
      XNB(L,NY,NX)=XN4T*VLNHB(L,NY,NX)
50    CONTINUE
      DPNH4(NY,NX)=DPNHB(LFDPTH,NY,NX)+CDPTH(LFDPTH-1,NY,NX)
      ENDIF
C
C     RESET WIDTH AND DEPTH OF NO3 FERTILIZER BAND IF NEW BAND APPLICATION
C     AND ADD REMAINS OF ANY EXISTING FERTILIZER BAND TO NEW BAND
C
      IF((Z4B+Z3B+ZUB+ZOB.GT.0.0).OR.((ZNO3B(LFDPTH,NY,NX).GT.0.0
     2.OR.ZNO2B(LFDPTH,NY,NX).GT.0.0).AND.IFNOB(NY,NX).EQ.0))THEN
      IFNOB(NY,NX)=1
      ROWO(NY,NX)=ROWI(I,NY,NX)
      DO 45 L=NU(NY,NX),JZ
      IF(L.LT.LFDPTH)THEN
      DPNOB(L,NY,NX)=DLYR(3,L,NY,NX)
      WDNOB(L,NY,NX)=0.0
      ELSEIF(L.EQ.LFDPTH)THEN
      DPNOB(L,NY,NX)=AMAX1(0.01,FDPTH(I,NY,NX)-CDPTH(L-1,NY,NX))
      WDNOB(L,NY,NX)=AMIN1(0.01,ROWO(NY,NX))
      ELSE
      DPNOB(L,NY,NX)=0.0
      WDNOB(L,NY,NX)=0.0
      ENDIF
      VLNOB(L,NY,NX)=AMIN1(0.999,WDNOB(L,NY,NX)/ROWO(NY,NX)
     2*DPNOB(L,NY,NX)/DLYR(3,L,NY,NX))
      VLNO3(L,NY,NX)=1.0-VLNOB(L,NY,NX)
      ZNO3T=ZNO3S(L,NY,NX)+ZNO3B(L,NY,NX)
      ZNO2T=ZNO2S(L,NY,NX)+ZNO2B(L,NY,NX)
      ZNO3S(L,NY,NX)=ZNO3T*VLNO3(L,NY,NX)
      ZNO2S(L,NY,NX)=ZNO2T*VLNO3(L,NY,NX)
      ZNO3B(L,NY,NX)=ZNO3T*VLNOB(L,NY,NX)
      ZNO2B(L,NY,NX)=ZNO2T*VLNOB(L,NY,NX)
45    CONTINUE
      DPNO3(NY,NX)=DPNOB(LFDPTH,NY,NX)+CDPTH(LFDPTH-1,NY,NX)
      ENDIF
C
C     RESET WIDTH AND DEPTH OF PO4 FERTILIZER BAND IF NEW BAND APPLICATION
C     AND ADD REMAINS OF ANY EXISTING FERTILIZER BAND TO NEW BAND
C
      IF((PMB.GT.0.0).OR.(H2POB(LFDPTH,NY,NX).GT.0.0
     2.AND.IFPOB(NY,NX).EQ.0))THEN
      IFPOB(NY,NX)=1
      ROWP(NY,NX)=ROWI(I,NY,NX)
      DO 40 L=NU(NY,NX),JZ
      IF(L.LT.LFDPTH)THEN
      DPPOB(L,NY,NX)=DLYR(3,L,NY,NX)
      WDPOB(L,NY,NX)=AMIN1(0.01,ROWP(NY,NX))
      ELSEIF(L.EQ.LFDPTH)THEN
      DPPOB(L,NY,NX)=AMAX1(0.01,FDPTH(I,NY,NX)-CDPTH(L-1,NY,NX))
      WDPOB(L,NY,NX)=AMIN1(0.01,ROWP(NY,NX))
      ELSE
      DPPOB(L,NY,NX)=0.0
      WDPOB(L,NY,NX)=0.0
      ENDIF
      VLPOB(L,NY,NX)=AMIN1(0.999,WDPOB(L,NY,NX)/ROWP(NY,NX)
     2*DPPOB(L,NY,NX)/DLYR(3,L,NY,NX))
      VLPO4(L,NY,NX)=1.0-VLPOB(L,NY,NX)
      H0PO4T=H0PO4(L,NY,NX)+H0POB(L,NY,NX)
      H1PO4T=H1PO4(L,NY,NX)+H1POB(L,NY,NX)
      H2PO4T=H2PO4(L,NY,NX)+H2POB(L,NY,NX)
      H3PO4T=H3PO4(L,NY,NX)+H3POB(L,NY,NX)
      ZFE1PT=ZFE1P(L,NY,NX)+ZFE1PB(L,NY,NX)
      ZFE2PT=ZFE2P(L,NY,NX)+ZFE2PB(L,NY,NX)
      ZCA0PT=ZCA0P(L,NY,NX)+ZCA0PB(L,NY,NX)
      ZCA1PT=ZCA1P(L,NY,NX)+ZCA1PB(L,NY,NX)
      ZCA2PT=ZCA2P(L,NY,NX)+ZCA2PB(L,NY,NX)
      ZMG1PT=ZMG1P(L,NY,NX)+ZMG1PB(L,NY,NX)
      XOH0T=XOH0(L,NY,NX)+XOH0B(L,NY,NX)
      XOH1T=XOH1(L,NY,NX)+XOH1B(L,NY,NX)
      XOH2T=XOH2(L,NY,NX)+XOH2B(L,NY,NX)
      XH1PT=XH1P(L,NY,NX)+XH1PB(L,NY,NX)
      XH2PT=XH2P(L,NY,NX)+XH2PB(L,NY,NX)
      PALPOT=PALPO(L,NY,NX)+PALPB(L,NY,NX)
      PFEPOT=PFEPO(L,NY,NX)+PFEPB(L,NY,NX)
      PCAPDT=PCAPD(L,NY,NX)+PCPDB(L,NY,NX)
      PCAPHT=PCAPH(L,NY,NX)+PCPHB(L,NY,NX)
      PCAPMT=PCAPM(L,NY,NX)+PCPMB(L,NY,NX)
      H0PO4(L,NY,NX)=H0PO4T*VLPO4(L,NY,NX)
      H1PO4(L,NY,NX)=H1PO4T*VLPO4(L,NY,NX)
      H2PO4(L,NY,NX)=H2PO4T*VLPO4(L,NY,NX)
      H3PO4(L,NY,NX)=H3PO4T*VLPO4(L,NY,NX)
      ZFE1P(L,NY,NX)=ZFE1PT*VLPO4(L,NY,NX)
      ZFE2P(L,NY,NX)=ZFE2PT*VLPO4(L,NY,NX)
      ZCA0P(L,NY,NX)=ZCA0PT*VLPO4(L,NY,NX)
      ZCA1P(L,NY,NX)=ZCA1PT*VLPO4(L,NY,NX)
      ZCA2P(L,NY,NX)=ZCA2PT*VLPO4(L,NY,NX)
      ZMG1P(L,NY,NX)=ZMG1PT*VLPO4(L,NY,NX)
      H0POB(L,NY,NX)=H0PO4T*VLPOB(L,NY,NX)
      H1POB(L,NY,NX)=H1PO4T*VLPOB(L,NY,NX)
      H2POB(L,NY,NX)=H2PO4T*VLPOB(L,NY,NX)
      H3POB(L,NY,NX)=H3PO4T*VLPOB(L,NY,NX)
      ZFE1PB(L,NY,NX)=ZFE1PT*VLPOB(L,NY,NX)
      ZFE2PB(L,NY,NX)=ZFE2PT*VLPOB(L,NY,NX)
      ZCA0PB(L,NY,NX)=ZCA0PT*VLPOB(L,NY,NX)
      ZCA1PB(L,NY,NX)=ZCA1PT*VLPOB(L,NY,NX)
      ZCA2PB(L,NY,NX)=ZCA2PT*VLPOB(L,NY,NX)
      ZMG1PB(L,NY,NX)=ZMG1PT*VLPOB(L,NY,NX)
      XOH0(L,NY,NX)=XOH0T*VLPO4(L,NY,NX)
      XOH1(L,NY,NX)=XOH1T*VLPO4(L,NY,NX)
      XOH2(L,NY,NX)=XOH2T*VLPO4(L,NY,NX)
      XH1P(L,NY,NX)=XH1PT*VLPO4(L,NY,NX)
      XH2P(L,NY,NX)=XH2PT*VLPO4(L,NY,NX)
      XOH0B(L,NY,NX)=XOH0T*VLPOB(L,NY,NX)
      XOH1B(L,NY,NX)=XOH1T*VLPOB(L,NY,NX)
      XOH2B(L,NY,NX)=XOH2T*VLPOB(L,NY,NX)
      XH1PB(L,NY,NX)=XH1PT*VLPOB(L,NY,NX)
      XH2PB(L,NY,NX)=XH2PT*VLPOB(L,NY,NX)
      PALPO(L,NY,NX)=PALPOT*VLPO4(L,NY,NX)
      PFEPO(L,NY,NX)=PFEPOT*VLPO4(L,NY,NX)
      PCAPD(L,NY,NX)=PCAPDT*VLPO4(L,NY,NX)
      PCAPH(L,NY,NX)=PCAPHT*VLPO4(L,NY,NX)
      PCAPM(L,NY,NX)=PCAPMT*VLPO4(L,NY,NX)
      PALPB(L,NY,NX)=PALPOT*VLPOB(L,NY,NX)
      PFEPB(L,NY,NX)=PFEPOT*VLPOB(L,NY,NX)
      PCPDB(L,NY,NX)=PCAPDT*VLPOB(L,NY,NX)
      PCPHB(L,NY,NX)=PCAPHT*VLPOB(L,NY,NX)
      PCPMB(L,NY,NX)=PCAPMT*VLPOB(L,NY,NX)
40    CONTINUE
      DPPO4(NY,NX)=DPPOB(LFDPTH,NY,NX)+CDPTH(LFDPTH-1,NY,NX)
      ENDIF
C
C     UPDATE STATE VARIABLES FOR BROADCAST AND BANDED FERTILIZER
C     NH4, NH3, UREA, NO3, PO4, LIME AND GYPSUM IN SOIL
C
      Z4AX=Z4A*AREA(3,LFDPTH,NY,NX)/14.0
      Z3AX=Z3A*AREA(3,LFDPTH,NY,NX)/14.0
      ZUAX=ZUA*AREA(3,LFDPTH,NY,NX)/14.0
      ZOAX=ZOA*AREA(3,LFDPTH,NY,NX)/14.0
      Z4BX=Z4B*AREA(3,LFDPTH,NY,NX)/14.0
      Z3BX=Z3B*AREA(3,LFDPTH,NY,NX)/14.0
      ZUBX=ZUB*AREA(3,LFDPTH,NY,NX)/14.0
      ZOBX=ZOB*AREA(3,LFDPTH,NY,NX)/14.0
      PMAX=PMA*AREA(3,LFDPTH,NY,NX)/62.0
      PMBX=PMB*AREA(3,LFDPTH,NY,NX)/62.0
      PHAX=PHA*AREA(3,LFDPTH,NY,NX)/93.0
      CACX=CAC*AREA(3,LFDPTH,NY,NX)/40.0
      CASX=CAS*AREA(3,LFDPTH,NY,NX)/40.0
      ZNH4FA(LFDPTH,NY,NX)=ZNH4FA(LFDPTH,NY,NX)+Z4AX*CVRD
      ZNHUFA(LFDPTH,NY,NX)=ZNHUFA(LFDPTH,NY,NX)+ZUAX*CVRD
      ZNO3FA(LFDPTH,NY,NX)=ZNO3FA(LFDPTH,NY,NX)+ZOAX*CVRD
      ZNH4FB(LFDPTH,NY,NX)=ZNH4FB(LFDPTH,NY,NX)+Z4BX*CVRD
      ZNHUFB(LFDPTH,NY,NX)=ZNHUFB(LFDPTH,NY,NX)+ZUBX*CVRD
      ZNO3FB(LFDPTH,NY,NX)=ZNO3FB(LFDPTH,NY,NX)+ZOBX*CVRD
      PCAPM(LFDPTH,NY,NX)=PCAPM(LFDPTH,NY,NX)
     2+PMAX*VLPO4(LFDPTH,NY,NX)*CVRD
      PCPMB(LFDPTH,NY,NX)=PCPMB(LFDPTH,NY,NX)
     2+PMAX*VLPOB(LFDPTH,NY,NX)*CVRD+PMBX*CVRD
      PCAPH(LFDPTH,NY,NX)=PCAPH(LFDPTH,NY,NX)
     2+PHAX*VLPO4(LFDPTH,NY,NX)*CVRD
      PCPHB(LFDPTH,NY,NX)=PCPHB(LFDPTH,NY,NX)
     2+PHAX*VLPOB(LFDPTH,NY,NX)*CVRD
      IF(LFDPTH.EQ.0)THEN
      ZNH4FA(NU(NY,NX),NY,NX)=ZNH4FA(NU(NY,NX),NY,NX)+Z4AX*BARE
      ZNH3FA(NU(NY,NX),NY,NX)=ZNH3FA(NU(NY,NX),NY,NX)+Z3AX 
      ZNHUFA(NU(NY,NX),NY,NX)=ZNHUFA(NU(NY,NX),NY,NX)+ZUAX*BARE
      ZNO3FA(NU(NY,NX),NY,NX)=ZNO3FA(NU(NY,NX),NY,NX)+ZOAX*BARE
      ZNH4FB(NU(NY,NX),NY,NX)=ZNH4FB(NU(NY,NX),NY,NX)+Z4BX*BARE
      ZNH3FB(NU(NY,NX),NY,NX)=ZNH3FB(NU(NY,NX),NY,NX)+Z3BX 
      ZNHUFB(NU(NY,NX),NY,NX)=ZNHUFB(NU(NY,NX),NY,NX)+ZUBX*BARE
      ZNO3FB(NU(NY,NX),NY,NX)=ZNO3FB(NU(NY,NX),NY,NX)+ZOBX*BARE
      PCAPM(NU(NY,NX),NY,NX)=PCAPM(NU(NY,NX),NY,NX)
     2+PMAX*VLPO4(NU(NY,NX),NY,NX)*BARE
      PCPMB(NU(NY,NX),NY,NX)=PCPMB(NU(NY,NX),NY,NX)
     2+PMAX*VLPOB(NU(NY,NX),NY,NX)*BARE+PMBX*BARE
      PCAPH(NU(NY,NX),NY,NX)=PCAPH(NU(NY,NX),NY,NX)
     2+PHAX*VLPO4(NU(NY,NX),NY,NX)*BARE
      PCPHB(NU(NY,NX),NY,NX)=PCPHB(NU(NY,NX),NY,NX)
     2+PHAX*VLPOB(NU(NY,NX),NY,NX)*BARE
      ELSE
      ZNH3FA(LFDPTH,NY,NX)=ZNH3FA(LFDPTH,NY,NX)+Z3AX*CVRD
      ZNH3FB(LFDPTH,NY,NX)=ZNH3FB(LFDPTH,NY,NX)+Z3BX*CVRD
      ENDIF
      PCACO(NU(NY,NX),NY,NX)=PCACO(NU(NY,NX),NY,NX)+CACX
      PCASO(NU(NY,NX),NY,NX)=PCASO(NU(NY,NX),NY,NX)+CASX
      TFERTN=TFERTN+2.0*(Z4AX+Z4BX)+ZUAX+ZUBX+Z3AX+Z3BX+ZOAX+ZOBX
      TFERTP=TFERTP+7.0*(PMAX+PMBX)+9.0*PHAX
      TIONIN=TIONIN+2.0*(CACX+CASX)
      UFERTN(NY,NX)=UFERTN(NY,NX)+14.0*(Z4AX+Z4BX+Z3AX+Z3BX
     2+ZUAX+ZUBX+ZOAX+ZOBX)
      UFERTP(NY,NX)=UFERTP(NY,NX)+62.0*(PMAX+PMBX)+93.0*PHAX
      IF(IYTYP(0,I,NY,NX).EQ.2)THEN
      IFTYP(NY,NX)=2
      ELSE
      IFTYP(NY,NX)=1
      ENDIF
      ENDIF
C
C     SOIL LAYER NUMBER IN WHICH PLANT OR ANIMAL RESIDUES ARE APPLIED
C
      IF(OFC(1)+OFC(2).GT.0.0)THEN
      DO 2985 L=0,JZ
      IF(FDPTH(I,NY,NX).LE.0.0)THEN
      LFDPTH=0
      GO TO 2980
      ELSEIF(CDPTH(L,NY,NX).GE.FDPTH(I,NY,NX))THEN
      LFDPTH=L
      GO TO 2980
      ENDIF
2985  CONTINUE
2980  CONTINUE
C
C     ALLOCATION OF PLANT RESIDUE APPLICATION TO
C     RESIDUE PROTEIN, CH2O, CELLULOSE, LIGNIN
C
C
C     MAIZE
C
      IF(IYTYP(1,I,NY,NX).EQ.1)THEN
      CFOSC(1,1,LFDPTH,NY,NX)=0.080
      CFOSC(2,1,LFDPTH,NY,NX)=0.245
      CFOSC(3,1,LFDPTH,NY,NX)=0.613
      CFOSC(4,1,LFDPTH,NY,NX)=0.062
C
C     WHEAT
C
      ELSEIF(IYTYP(1,I,NY,NX).EQ.2)THEN
      CFOSC(1,1,LFDPTH,NY,NX)=0.125
      CFOSC(2,1,LFDPTH,NY,NX)=0.171
      CFOSC(3,1,LFDPTH,NY,NX)=0.560
      CFOSC(4,1,LFDPTH,NY,NX)=0.144
C
C     SOYBEAN
C
      ELSEIF(IYTYP(1,I,NY,NX).EQ.3)THEN
      CFOSC(1,1,LFDPTH,NY,NX)=0.138
      CFOSC(2,1,LFDPTH,NY,NX)=0.426
      CFOSC(3,1,LFDPTH,NY,NX)=0.316
      CFOSC(4,1,LFDPTH,NY,NX)=0.120
C
C     OLD STRAW
C
      ELSEIF(IYTYP(1,I,NY,NX).EQ.4)THEN
      CFOSC(1,1,LFDPTH,NY,NX)=0.075
      CFOSC(2,1,LFDPTH,NY,NX)=0.125
      CFOSC(3,1,LFDPTH,NY,NX)=0.550
      CFOSC(4,1,LFDPTH,NY,NX)=0.250
C
C     STRAW
C
      ELSEIF(IYTYP(1,I,NY,NX).EQ.5)THEN
      CFOSC(1,1,LFDPTH,NY,NX)=0.036
      CFOSC(2,1,LFDPTH,NY,NX)=0.044
      CFOSC(3,1,LFDPTH,NY,NX)=0.767
      CFOSC(4,1,LFDPTH,NY,NX)=0.153
C
C     COMPOST
C
      ELSEIF(IYTYP(1,I,NY,NX).EQ.6)THEN
      CFOSC(1,1,LFDPTH,NY,NX)=0.143
      CFOSC(2,1,LFDPTH,NY,NX)=0.015
      CFOSC(3,1,LFDPTH,NY,NX)=0.640
      CFOSC(4,1,LFDPTH,NY,NX)=0.202
C
C     GREEN MANURE
C
      ELSEIF(IYTYP(1,I,NY,NX).EQ.7)THEN
      CFOSC(1,1,LFDPTH,NY,NX)=0.202
      CFOSC(2,1,LFDPTH,NY,NX)=0.013
      CFOSC(3,1,LFDPTH,NY,NX)=0.560
      CFOSC(4,1,LFDPTH,NY,NX)=0.225
C
C     SIMPLE SUBSTRATE
C
      ELSEIF(IYTYP(1,I,NY,NX).EQ.10)THEN
      CFOSC(1,1,LFDPTH,NY,NX)=0.000
      CFOSC(2,1,LFDPTH,NY,NX)=1.000
      CFOSC(3,1,LFDPTH,NY,NX)=0.000
      CFOSC(4,1,LFDPTH,NY,NX)=0.000
      ELSE
      CFOSC(1,1,LFDPTH,NY,NX)=0.075
      CFOSC(2,1,LFDPTH,NY,NX)=0.125
      CFOSC(3,1,LFDPTH,NY,NX)=0.550
      CFOSC(4,1,LFDPTH,NY,NX)=0.250
      ENDIF
C
C     ALLOCATION OF ANIMAL RESIDUE APPLICATION TO
C     RESIDUE PROTEIN, CH2O, CELLULOSE, LIGNIN
C
C
C     RUMINANT
C
      IF(IYTYP(2,I,NY,NX).EQ.1)THEN
      CFOSC(1,2,LFDPTH,NY,NX)=0.036
      CFOSC(2,2,LFDPTH,NY,NX)=0.044
      CFOSC(3,2,LFDPTH,NY,NX)=0.520
      CFOSC(4,2,LFDPTH,NY,NX)=0.400
C
C     NON-RUMINANT
C
      ELSEIF(IYTYP(2,I,NY,NX).EQ.2)THEN
      CFOSC(1,2,LFDPTH,NY,NX)=0.138
      CFOSC(2,2,LFDPTH,NY,NX)=0.401
      CFOSC(3,2,LFDPTH,NY,NX)=0.316
      CFOSC(4,2,LFDPTH,NY,NX)=0.145
C
C     GRAZING
C
      ELSEIF(IYTYP(2,I,NY,NX).EQ.3)THEN
      CFOSC(1,2,LFDPTH,NY,NX)=0.036
      CFOSC(2,2,LFDPTH,NY,NX)=0.044
      CFOSC(3,2,LFDPTH,NY,NX)=0.520
      CFOSC(4,2,LFDPTH,NY,NX)=0.400
C
C     OTHER
C
      ELSE
      CFOSC(1,2,LFDPTH,NY,NX)=0.138
      CFOSC(2,2,LFDPTH,NY,NX)=0.401
      CFOSC(3,2,LFDPTH,NY,NX)=0.316
      CFOSC(4,2,LFDPTH,NY,NX)=0.145
      ENDIF
C
C     DISTRIBUTE RESIDUE APPLICATION AMONG COMPONENTS OF RESIDUE COMPLEX
C
      DO 2965 K=1,2
      OSCI=OFC(K)*AREA(3,LFDPTH,NY,NX)
      OSNI=OFN(K)*AREA(3,LFDPTH,NY,NX)
      OSPI=OFP(K)*AREA(3,LFDPTH,NY,NX)
      IF(BKVL(LFDPTH,NY,NX).GT.0.0)THEN
      CORGCX=OSCI/BKVL(LFDPTH,NY,NX)
      ELSE
      CORGCX=0.5E+06
      ENDIF
      OSCX=0.0
      OSNX=0.0
      OSPX=0.0
C
C     BIOMASSES OF MICROBIAL POPULATIONS IN RESIDUE
C
      DO 2960 N=1,7
      DO 2961 M=1,2
      OMC1=AMAX1(0.0,AMIN1(OSCI*OMCI(M)*OMCF(N),OSCI-OSCX))
      OMN1=AMAX1(0.0,AMIN1(OMC1*CNOMC(M),OSNI-OSNX))
      OMP1=AMAX1(0.0,AMIN1(OMC1*CPOMC(M),OSPI-OSPX))
      OMC(M,N,K,LFDPTH,NY,NX)=OMC(M,N,K,LFDPTH,NY,NX)+OMC1
      OMN(M,N,K,LFDPTH,NY,NX)=OMN(M,N,K,LFDPTH,NY,NX)+OMN1
      OMP(M,N,K,LFDPTH,NY,NX)=OMP(M,N,K,LFDPTH,NY,NX)+OMP1
      OSCX=OSCX+OMC1
      OSNX=OSNX+OMN1
      OSPX=OSPX+OMP1
2961  CONTINUE
      OMC1=AMAX1(0.0,AMIN1(OSCI*OMCI(3)*OMCF(N),OSCI-OSCX))
      OMN1=AMAX1(0.0,AMIN1(OMC1*CNOMC(1),OSNI-OSNX))
      OMP1=AMAX1(0.0,AMIN1(OMC1*CPOMC(1),OSPI-OSPX))
      OMC(3,N,K,LFDPTH,NY,NX)=OMC(3,N,K,LFDPTH,NY,NX)+OMC1
      OMN(3,N,K,LFDPTH,NY,NX)=OMN(3,N,K,LFDPTH,NY,NX)+OMN1
      OMP(3,N,K,LFDPTH,NY,NX)=OMP(3,N,K,LFDPTH,NY,NX)+OMP1
      OSCX=OSCX+OMC1
      OSNX=OSNX+OMN1
      OSPX=OSPX+OMP1      
2960  CONTINUE
      DO 2962 N=1,2
      DO 2963 M=1,2
      OMC1=AMAX1(0.0,AMIN1(OSCI*OMCI(M)*OMCA(N),OSCI-OSCX))
      OMN1=AMAX1(0.0,AMIN1(OMC1*CNOMC(M),OSNI-OSNX))
      OMP1=AMAX1(0.0,AMIN1(OMC1*CPOMC(M),OSPI-OSPX))
      OMC(M,N,5,LFDPTH,NY,NX)=OMC(M,N,5,LFDPTH,NY,NX)+OMC1
      OMN(M,N,5,LFDPTH,NY,NX)=OMN(M,N,5,LFDPTH,NY,NX)+OMN1
      OMP(M,N,5,LFDPTH,NY,NX)=OMP(M,N,5,LFDPTH,NY,NX)+OMP1
      OSCX=OSCX+OMC1
      OSNX=OSNX+OMN1
      OSPX=OSPX+OMP1
2963  CONTINUE
      OMC1=AMAX1(0.0,AMIN1(OSCI*OMCI(3)*OMCA(N),OSCI-OSCX))
      OMN1=AMAX1(0.0,AMIN1(OMC1*CNOMC(1),OSNI-OSNX))
      OMP1=AMAX1(0.0,AMIN1(OMC1*CPOMC(1),OSPI-OSPX))
      OMC(3,N,5,LFDPTH,NY,NX)=OMC(3,N,5,LFDPTH,NY,NX)+OMC1
      OMN(3,N,5,LFDPTH,NY,NX)=OMN(3,N,5,LFDPTH,NY,NX)+OMN1
      OMP(3,N,5,LFDPTH,NY,NX)=OMP(3,N,5,LFDPTH,NY,NX)+OMP1
      OSCX=OSCX+OMC1
      OSNX=OSNX+OMN1
      OSPX=OSPX+OMP1      
2962  CONTINUE
C
C     DOC, DON AND DOP IN RESIDUE
C
      OQC1=AMIN1(0.1*OSCX,OSCI-OSCX)
      OQN1=AMIN1(0.1*OSNX,OSNI-OSNX)
      OQP1=AMIN1(0.1*OSPX,OSPI-OSPX)
      OQC(K,LFDPTH,NY,NX)=OQC(K,LFDPTH,NY,NX)+OQC1
      OQN(K,LFDPTH,NY,NX)=OQN(K,LFDPTH,NY,NX)+OQN1
      OQP(K,LFDPTH,NY,NX)=OQP(K,LFDPTH,NY,NX)+OQP1
C
C     REMAINDER DISTRIBUTED TO RESIDUE FRACTIONS
C
      OSCX=OSCX+OQC1
      OSNX=OSNX+OQN1
      OSPX=OSPX+OQP1
      CNOFT=0.0
      CPOFT=0.0
      IF(OSCI-OSCX.GT.ZEROS(NY,NX))THEN
      RNT=0.0
      RPT=0.0
      DO 965 M=1,4
      RNT=RNT+(OSCI-OSCX)*CFOSC(M,K,LFDPTH,NY,NX)*CNOFC(M,K)
      RPT=RPT+(OSCI-OSCX)*CFOSC(M,K,LFDPTH,NY,NX)*CPOFC(M,K)
965   CONTINUE
      FRNT=(OSNI-OSNX)/RNT
      FRPT=(OSPI-OSPX)/RPT
      DO 970 M=1,4
      CNOF(M)=CNOFC(M,K)*FRNT 
      CPOF(M)=CPOFC(M,K)*FRPT 
      CNOFT=CNOFT+CFOSC(M,K,LFDPTH,NY,NX)*CNOF(M)
      CPOFT=CPOFT+CFOSC(M,K,LFDPTH,NY,NX)*CPOF(M)
970   CONTINUE
      ELSE
      DO 975 M=1,4
      CNOF(M)=0.0
      CPOF(M)=0.0
975   CONTINUE
      ENDIF
      DO 2970 M=1,4
      OSC1=CFOSC(M,K,LFDPTH,NY,NX)*(OSCI-OSCX)
      IF(CNOFT.GT.ZERO)THEN
      OSN1=CFOSC(M,K,LFDPTH,NY,NX)*CNOF(M)/CNOFT*(OSNI-OSNX)
      ELSE
      OSN1=0.0
      ENDIF
      IF(CPOFT.GT.ZERO)THEN
      OSP1=CFOSC(M,K,LFDPTH,NY,NX)*CPOF(M)/CPOFT*(OSPI-OSPX)
      ELSE
      OSP1=0.0
      ENDIF
      OSC(M,K,LFDPTH,NY,NX)=OSC(M,K,LFDPTH,NY,NX)+OSC1
      OSA(M,K,LFDPTH,NY,NX)=OSA(M,K,LFDPTH,NY,NX)+OSC1
      OSN(M,K,LFDPTH,NY,NX)=OSN(M,K,LFDPTH,NY,NX)+OSN1
      OSP(M,K,LFDPTH,NY,NX)=OSP(M,K,LFDPTH,NY,NX)+OSP1
      IF(LFDPTH.EQ.0)THEN
      VOLT(LFDPTH,NY,NX)=VOLT(LFDPTH,NY,NX)+OSC1*1.0E-06/BKRS(1)
      ENDIF
2970  CONTINUE
      TORGF=TORGF+OSCI
      TORGN=TORGN+OSNI
      TORGP=TORGP+OSPI
      UORGF(NY,NX)=UORGF(NY,NX)+OSCI
      UFERTN(NY,NX)=UFERTN(NY,NX)+OSNI
      UFERTP(NY,NX)=UFERTP(NY,NX)+OSPI
      IF(IYTYP(2,I,NY,NX).LT.3)THEN
      TNBP(NY,NX)=TNBP(NY,NX)+OSCI
      ENDIF
2965  CONTINUE
      ENDIF
      ENDIF
8995  CONTINUE
8990  CONTINUE
      NPH=NPX
      NPT=NPY
      NPG=NPH*NPT
      XNPH=1.0/NPH
      XNPT=1.0/NPT
      XNPG=1.0/NPG
      XNPD=600.0*XNPG
      RETURN
      END
