
      SUBROUTINE grosub(I,J,NHW,NHE,NVN,NVS)
C
C     THIS SUBROUTINE CALCULATES ALL PLANT BIOLOGICAL TRANSFORMATIONS
C
      include "parameters.h"
      include "files.h"
      include "blkc.h"
      include "blk1cp.h"
      include "blk1cr.h"
      include "blk1g.h"
      include "blk1n.h"
      include "blk1p.h"
      include "blk1s.h"
      include "blk2a.h"
      include "blk2b.h"
      include "blk2c.h"
      include "blk3.h"
      include "blk5.h"
      include "blk8a.h"
      include "blk8b.h"
      include "blk9a.h"
      include "blk9b.h"
      include "blk9c.h"
      include "blk11a.h"
      include "blk11b.h"
      include "blk12a.h"
      include "blk12b.h"
      include "blk13a.h"
      include "blk13b.h"
      include "blk13c.h"
      include "blk14.h"
      include "blk16.h"
      include "blk18a.h"
      include "blk18b.h"
      DIMENSION PART(7),TFN6(JZ),ARSTKB(10),NRX(2,JZ),ICHK1(2,JZ)
     2,NBZ(10),FXFB(0:3,0:5),FXFR(0:3,0:5),FXRT(0:1),FXSH(0:1) 
     3,VMXS(0:1,0:5),WTLSBZ(10),CPOOLZ(10),ZPOOLZ(10),PPOOLZ(10)
     4,ZCX(05,JY,JX),UPNFC(05,JY,JX),FRSV(0:3),FXFV(0:1),FXFZ(0:1)
     5,FXRN(4) 
      DIMENSION RTNT(2),RLNT(2,JZ),RTSK1(2,JZ,10),RTSK2(2,JZ,10)
     2,RTDPL(10,JZ),FWTR(JZ),FWTB(05),FRTDP(0:3),RCCX(0:2),RCCQ(0:2)
     3,EFIRE(2,5:5),WGLFBL(JZ,10,05,JY,JX),WTSHTA(JZ,JY,JX)
      DIMENSION CH2O3(25),CH2O4(25),CPOOLK(10,05,JY,JX),FHVSTK(0:25)
     2,FHVSHK(0:25),WFNGR(2,JZ),PSILY(0:2),FPART1(0:1),FPART2(0:1)
      DIMENSION FWOOD(0:1),FWOODN(0:1),FWOODP(0:1)
     2,FWODB(0:1),FWODLN(0:1),FWODLP(0:1),FWODSN(0:1),FWODSP(0:1)
C     DIMENSION VCO2(400,366,05)
      PARAMETER(PART1X=0.05,PART2X=0.02
     2,VMXC=0.015,ATRPX=276.91,FSNR=2.884E-03,FLG4X=168.0
     3,FLGZX=240.0,XFRX=2.5E-02,XFRY=2.5E-03,IFLGRX=960
     4,RCCY=0.333,RCCZ=0.167,FSNKM=0.05,FXFS=1.0,FMYC=0.01)
      PARAMETER(CNKI=1.0E+01,CPKI=1.0E+02
     2,ZSKI=1.0E-01,PSKI=1.0E-02,ZSKF=1.0)
      PARAMETER(RMPLT=0.010,PSILM=0.1,RCMN=1.560E+01,RTDPX=0.00
     2,RTLGAX=1.0E-03,EMODR=5.0)
      PARAMETER(QNTM=0.45,CURV=0.70,CURV2=2.0*CURV,CURV4=4.0*CURV
     2,ELEC3=4.5,ELEC4=3.0,CO2KI=1.0+03,FCO2B=0.02,FHCOB=1.0-FCO2B)
      PARAMETER(COMP4=0.5,FDML=6.0,FBS=0.2*FDML,FMP=0.8*FDML
     2,FVRN=0.5)
      PARAMETER(ZPLFM=0.33,ZPLFD=1.0-ZPLFM,ZPGRM=0.75
     2,ZPGRD=1.0-ZPGRM,FRF=0.25,FRC=1.0-FRF,GY=0.5,GZ=1.0-GY)
      PARAMETER(FSTK=0.05,ZSTX=1.0E-03,DSTK=0.225,VSTK=1.0E-06/DSTK
     2,FRTX=1.0/(1.0-(1.0-FSTK)**2))
      PARAMETER(SETC=1.0E-02,SETN=1.0E-03,SETP=1.0E-04)
      PARAMETER(SLA2=-0.33,SSL2=-0.50,SNL2=-0.67)
      PARAMETER(CNMX=0.20,CPMX=0.020,CNMN=0.050,CPMN=0.005)
      PARAMETER(EN2F=0.20,VMXO=0.50,SPNDL=1.0E-06,CCNKM=1.0E-02
     2,CCNKX=1.0E+02,WTNDI=0.01)
      DATA RCCX/0.200,0.750,0.750/
      DATA RCCQ/0.750,0.750,0.750/
      DATA FXRN/0.50,0.05,0.25,0.025/
      DATA FXFB/0.0,0.0,0.0,0.0
     1,5.0E-03,5.0E-03,0.0,0.0
     2,5.0E-03,5.0E-03,0.0,0.0
     3,5.0E-03,5.0E-03,0.0,0.0
     4,5.0E-03,5.0E-03,0.0,0.0
     5,5.0E-03,5.0E-03,0.0,0.0/
      DATA FXFR/0.0,0.0,0.0,0.0
     1,5.0E-03,5.0E-03,0.0,0.0
     2,5.0E-03,5.0E-03,0.0,0.0
     3,5.0E-03,5.0E-03,0.0,0.0
     4,5.0E-03,5.0E-03,0.0,0.0
     5,5.0E-03,5.0E-03,0.0,0.0/ 
      DATA VMXS/0.025,0.0025
     1,0.0025,0.0025
     2,0.0025,0.0025
     3,0.0025,0.0025
     4,0.0025,0.0025
     5,0.0025,0.0025/
      DATA FPART1/1.00,0.75/,FPART2/0.40,0.30/
      DATA FXSH/0.500,0.750/,FXRT/0.500,0.250/
      DATA FRSV/0.015,0.015,0.001,0.005/
      DATA FXFV/0.05,0.005/,FXFZ/0.25,0.005/
      DATA EFIRE/0.917,0.167/
      DATA PSILY/-200.0,-2.0,-2.0/
C     DATA TC4,TLK/0.0,0.0/
      REAL*4 TFN5,WFNG,WFNC,WFNS,WFNSG,WFNSS,WFN4,WFNB
     2,WFNR,WFNRG,WFNGR,FSNC2 
C
C     TOTAL AGB FOR GRAZING IN LANDSCAPE GROUP
C
      DO 2995 NX=NHW,NHE
      DO 2990 NY=NVN,NVS
      DO 2985 NZ=1,NP(NY,NX)
      IF(IHVST(NZ,I,NY,NX).EQ.4.OR.IHVST(NZ,I,NY,NX).EQ.6)THEN
      WTSHTZ=0
      NN=0
      DO 1995 NX1=NHW,NHE
      DO 1990 NY1=NVN,NVS
      IF(LSG(NZ,NY1,NX1).EQ.LSG(NZ,NY,NX))THEN
      IF(IFLGC(NZ,NY1,NX1).EQ.1)THEN
      WTSHTZ=WTSHTZ+WTSHT(NZ,NY1,NX1)
      NN=NN+1
      ENDIF
      ENDIF
1990  CONTINUE
1995  CONTINUE
      IF(NN.GT.0)THEN
      WTSHTA(NZ,NY,NX)=WTSHTZ/NN
      ELSE
      WTSHTA(NZ,NY,NX)=WTSHT(NZ,NY,NX)
      ENDIF
      ENDIF
2985  CONTINUE
2990  CONTINUE
2995  CONTINUE
      DO 9995 NX=NHW,NHE
      DO 9990 NY=NVN,NVS
      DO 9980 NZ=1,NP0(NY,NX)
      DO 1 L=0,NJ(NY,NX)
      DO 1 K=0,1
      DO 1 M=1,4
      CSNC(M,K,L,NZ,NY,NX)=0.0
      ZSNC(M,K,L,NZ,NY,NX)=0.0
      PSNC(M,K,L,NZ,NY,NX)=0.0
1     CONTINUE
      HCSNC(NZ,NY,NX)=0.0
      HZSNC(NZ,NY,NX)=0.0
      HPSNC(NZ,NY,NX)=0.0
      CNET(NZ,NY,NX)=0.0
      UPNFC(NZ,NY,NX)=0.0
      ZCX(NZ,NY,NX)=ZC(NZ,NY,NX)
      ZC(NZ,NY,NX)=0.0
9980  CONTINUE
C
C     TRANSFORMATIONS IN LIVING PLANT POPULATIONS
C
      DO 9985 NZ=1,NP(NY,NX)
C     IF(J.EQ.INT(ZNOON(NY,NX)))THEN
      XHVST=1.0
      WHVSBL=0.0      
      WTHTH0=0.0
      WTHNH0=0.0
      WTHPH0=0.0
      WTHTH1=0.0
      WTHNH1=0.0
      WTHPH1=0.0
      WTHTH2=0.0
      WTHNH2=0.0
      WTHPH2=0.0
      WTHTH3=0.0
      WTHNH3=0.0
      WTHPH3=0.0
      WTHTH4=0.0
      WTHNH4=0.0
      WTHPH4=0.0
      WTHTR1=0.0
      WTHNR1=0.0
      WTHPR1=0.0
      WTHTR2=0.0
      WTHNR2=0.0
      WTHPR2=0.0
      WTHTR3=0.0
      WTHNR3=0.0
      WTHPR3=0.0
      WTHTR4=0.0
      WTHNR4=0.0
      WTHPR4=0.0
      WTHTX0=0.0
      WTHNX0=0.0
      WTHPX0=0.0
      WTHTX1=0.0
      WTHNX1=0.0
      WTHPX1=0.0
      WTHTX2=0.0
      WTHNX2=0.0
      WTHPX2=0.0
      WTHTX3=0.0
      WTHNX3=0.0
      WTHPX3=0.0
      WTHTX4=0.0
      WTHNX4=0.0
      WTHPX4=0.0
      WTHTG=0.0
      WTHNG=0.0
      WTHPG=0.0
C     ENDIF
C     IF(NX.EQ.4.AND.NY.EQ.4.AND.NZ.EQ.2)THEN
C     WRITE(*,2328)'IFLGC',I,J,NZ,IFLGC(NZ,NY,NX)
C    2,IDTHP(NZ,NY,NX),IDTHR(NZ,NY,NX)
2328  FORMAT(A8,10I4)
C     ENDIF
      IF(IFLGC(NZ,NY,NX).EQ.1)THEN
      IF(IDTHP(NZ,NY,NX).EQ.0.OR.IDTHR(NZ,NY,NX).EQ.0)THEN
C     IF(I.EQ.1.AND.J.EQ.1)THEN
C     DO 87 II=1,366
C     DO 87 N=1,400
C     VCO2(N,II,NZ)=0.0
87    CONTINUE
C     ENDIF
C     IF(IYRC.GE.2099)THEN
C     IF(I.EQ.365.AND.J.EQ.24)THEN
C     DO 88 N=1,400
C     WRITE(19,12)IYRC,NZ,N,(VCO2(N,II,NZ),II=1,181)
C     WRITE(20,12)IYRC,NZ,N,(VCO2(N,II,NZ),II=182,365)
12    FORMAT(3I8,365E12.4)
88    CONTINUE
C     ENDIF
C     ENDIF
      IFLGZ=0
      IFLGY=0
      DO 2 L=1,NC(NY,NX)
      ARLFV(L,NZ,NY,NX)=0.0
      WGLFV(L,NZ,NY,NX)=0.0
      ARSTV(L,NZ,NY,NX)=0.0
2     CONTINUE
      DO 5 NR=1,NRT(NZ,NY,NX)
      DO 5 N=1,MY(NZ,NY,NX)
      NRX(N,NR)=0
      ICHK1(N,NR)=0
5     CONTINUE
      DO 9 N=1,MY(NZ,NY,NX)
      RTNT(N)=0.0
      DO 6 L=NU(NY,NX),NJ(NY,NX)
      WSRTL(N,L,NZ,NY,NX)=0.0
      RTN1(N,L,NZ,NY,NX)=0.0
      RTNL(N,L,NZ,NY,NX)=0.0
      RCO2M(N,L,NZ,NY,NX)=0.0
      RCO2N(N,L,NZ,NY,NX)=0.0
      RCO2A(N,L,NZ,NY,NX)=0.0
      RLNT(N,L)=0.0
      DO 6 NR=1,NRT(NZ,NY,NX)
      RTSK1(N,L,NR)=0.0
      RTSK2(N,L,NR)=0.0
6     CONTINUE
9     CONTINUE
      IF(IBTYP(NZ,NY,NX).EQ.0.OR.IGTYP(NZ,NY,NX).LE.1
     2.OR.WTSTK(NZ,NY,NX).LT.ZEROP(NZ,NY,NX)
     3.OR.WVSTK(NZ,NY,NX).LT.ZEROP(NZ,NY,NX))THEN
      FWOOD(1)=1.0
      FWODB(1)=1.0
      ELSE
      FWOOD(1)=SQRT(FRTX*WVSTK(NZ,NY,NX)/WTSTK(NZ,NY,NX))
C     IF(ISTYP(NZ,NY,NX).EQ.1.AND.(IBTYP(NZ,NY,NX).GE.2
C    2.OR.IWTYP(NZ,NY,NX).EQ.0))THEN
C     FWODB(1)=FWOOD(1)
C     ELSE
      FWODB(1)=1.0
C     ENDIF
      ENDIF
      FWOOD(0)=1.0-FWOOD(1)
      FWODB(0)=1.0-FWODB(1)
      CNLFW=FWODB(0)*CNSTK(NZ,NY,NX)+FWODB(1)*CNLF(NZ,NY,NX)
      CPLFW=FWODB(0)*CPSTK(NZ,NY,NX)+FWODB(1)*CPLF(NZ,NY,NX)
      CNSHW=FWODB(0)*CNSTK(NZ,NY,NX)+FWODB(1)*CNSHE(NZ,NY,NX)
      CPSHW=FWODB(0)*CPSTK(NZ,NY,NX)+FWODB(1)*CPSHE(NZ,NY,NX)
      CNRTW=FWOOD(0)*CNSTK(NZ,NY,NX)+FWOOD(1)*CNRT(NZ,NY,NX)
      CPRTW=FWOOD(0)*CPSTK(NZ,NY,NX)+FWOOD(1)*CPRT(NZ,NY,NX)
      FWODLN(0)=FWODB(0)*CNSTK(NZ,NY,NX)/CNLFW
      FWODLP(0)=FWODB(0)*CPSTK(NZ,NY,NX)/CPLFW
      FWODSN(0)=FWODB(0)*CNSTK(NZ,NY,NX)/CNSHW
      FWODSP(0)=FWODB(0)*CPSTK(NZ,NY,NX)/CPSHW
      FWOODN(0)=FWOOD(0)*CNSTK(NZ,NY,NX)/CNRTW
      FWOODP(0)=FWOOD(0)*CPSTK(NZ,NY,NX)/CPRTW
      FWODLN(1)=1.0-FWODLN(0)
      FWODLP(1)=1.0-FWODLP(0)
      FWODSN(1)=1.0-FWODSN(0)
      FWODSP(1)=1.0-FWODSP(0)
      FWOODN(1)=1.0-FWOODN(0)
      FWOODP(1)=1.0-FWOODP(0)
C
C     SHOOT AND ROOT TEMPERATURE FUNCTIONS FOR MAINTENANCE
C     RESPIRATION FROM TEMPERATURES WITH OFFSETS FOR THERMAL ADAPTATION
C
      TCSR=AMIN1(45.0,TCC(NZ,NY,NX)+OFFST(NZ,NY,NX))
      TFN5=EXP(0.0742*(TCSR-25.0))
      DO 7 L=NU(NY,NX),NJ(NY,NX)
      TCSR=AMIN1(45.0,TCS(L,NY,NX)+OFFST(NZ,NY,NX))
      TFN6(L)=EXP(0.0742*(TCSR-25.0))
7     CONTINUE
      GROGR=0.0
      WTRTA(NZ,NY,NX)=AMAX1(0.999992087*WTRTA(NZ,NY,NX)
     2,WTRT(NZ,NY,NX)/PP(NZ,NY,NX))
      XRTN1=AMAX1(1.0,WTRTA(NZ,NY,NX)**0.72)*PP(NZ,NY,NX)
C
C     WATER STRESS FUNCTIONS FOR EXPANSION AND GROWTH RESPIRATION
C     FROM CANOPY TURGOR
C
      WFNS=AMIN1(1.0,AMAX1(0.0,PSILG(NZ,NY,NX)-PSILM))
      WFNSG=WFNS**0.25
      WFNSS=WFNS**0.50
      IF(IGTYP(NZ,NY,NX).EQ.0)THEN
      WFNC=1.0
      WFNG=EXP(0.05*PSILT(NZ,NY,NX))
      ELSE
      WFNC=EXP(RCS(NZ,NY,NX)*PSILG(NZ,NY,NX))
      WFNG=EXP(0.10*PSILT(NZ,NY,NX))
      ENDIF
C
C     CALCULATE GROWTH OF EACH BRANCH
C
      DO 105 NB=1,NBR(NZ,NY,NX)
      WTLSB(NB,NZ,NY,NX)=AMAX1(0.0,WTLFB(NB,NZ,NY,NX)
     2+WTSHEB(NB,NZ,NY,NX))
      IF(IDTHB(NB,NZ,NY,NX).EQ.0)THEN
C
C     PARTITION GROWTH WITHIN EACH BRANCH FROM GROWTH STAGE
C     1=LEAF,2=SHEATH OR PETIOLE,3=STALK,4=RESERVE,
C     5,6=REPRODUCTIVE ORGANS,7=GRAIN
C
      ARSTKB(NB)=0.0
      TOTAL=0.0
      DO 10 N=1,7
      PART(N)=0.0
10    CONTINUE
C
C     IF BEFORE FLORAL INDUCTION
C
      IF(IDAY(2,NB,NZ,NY,NX).EQ.0)THEN
      PART(1)=0.725
      PART(2)=0.275
C
C     IF BEFORE ANTHESIS
C
      ELSEIF(IDAY(6,NB,NZ,NY,NX).EQ.0)THEN
      PART(1)=AMAX1(PART1X,0.725-FPART1(ISTYP(NZ,NY,NX))
     2*TGSTGI(NB,NZ,NY,NX))
      PART(2)=AMAX1(PART2X,0.275-FPART2(ISTYP(NZ,NY,NX))
     2*TGSTGI(NB,NZ,NY,NX))
      PARTS=1.0-PART(1)-PART(2)
      PART(3)=0.60*PARTS
      PART(4)=0.30*PARTS
      PARTX=PARTS-PART(3)-PART(4)
      PART(5)=0.5*PARTX
      PART(6)=0.5*PARTX
C
C     IF BEFORE GRAIN FILLING, DETERMINATE OR INDETERMINATE
C
      ELSEIF(IDAY(7,NB,NZ,NY,NX).EQ.0)THEN
      IF(IDTYP(NZ,NY,NX).EQ.0)THEN
      PART(1)=0.0
      PART(2)=0.0
      ELSE
      PART(1)=AMAX1(PART1X,(0.725-FPART1(ISTYP(NZ,NY,NX)))
     2*(1.0-TGSTGF(NB,NZ,NY,NX)))
      PART(2)=AMAX1(PART2X,(0.275-FPART2(ISTYP(NZ,NY,NX)))
     2*(1.0-TGSTGF(NB,NZ,NY,NX)))
      ENDIF
      PARTS=1.0-PART(1)-PART(2)
      PART(3)=AMAX1(0.0,0.60*PARTS*(1.0-TGSTGF(NB,NZ,NY,NX)))
      PART(4)=AMAX1(0.0,0.30*PARTS*(1.0-TGSTGF(NB,NZ,NY,NX)))
      PARTX=PARTS-PART(3)-PART(4)
      PART(5)=0.5*PARTX
      PART(6)=0.5*PARTX
C
C     DURING GRAIN FILLING, DETERMINATE OR INDETERMINATE
C
      ELSE
      IF(IDTYP(NZ,NY,NX).EQ.0)THEN
      PART(7)=1.0
      ELSE
      PART(1)=PART1X
      PART(2)=PART2X
      PARTS=1.0-PART(1)-PART(2)
      IF(ISTYP(NZ,NY,NX).EQ.0)THEN
      PART(3)=0.125*PARTS
      PART(5)=0.125*PARTS
      PART(6)=0.125*PARTS
      PART(7)=0.625*PARTS
      ELSE
      PART(3)=0.75*PARTS
      PART(7)=0.25*PARTS
      ENDIF
      ENDIF
      ENDIF
C
C     IF AFTER GRAIN FILLING
C
      IF(IBTYP(NZ,NY,NX).EQ.0.AND.IDAY(10,NB,NZ,NY,NX).NE.0)THEN
      IF(ISTYP(NZ,NY,NX).EQ.0)THEN
      PART(4)=0.0
      PART(3)=0.0
      PART(7)=0.0
      ELSE
      PART(4)=PART(4)+PART(3)
      PART(3)=0.0
      PART(7)=0.0
      ENDIF
      ENDIF
C
C     REDIRECT FROM STALK TO STALK RESERVES IF RESERVES BECOME LOW
C
      IF(IDAY(2,NB,NZ,NY,NX).NE.0)THEN
      IF(WTRSVB(NB,NZ,NY,NX).LT.XFRX*WVSTKB(NB,NZ,NY,NX))THEN
      DO 1020 N=1,7
      IF(N.NE.4)THEN
      PART(4)=PART(4)+0.10*PART(N)
      PART(N)=PART(N)-0.10*PART(N)
      ENDIF
1020  CONTINUE
C
C     REDIRECT FROM STALK RESERVES TO STALK IF RESERVES BECOME TOO LARGE
C
      ELSEIF(WTRSVB(NB,NZ,NY,NX).GT.1.0*WVSTKB(NB,NZ,NY,NX))THEN
      PART(3)=PART(3)+PART(4)+PART(7)
      PART(4)=0.0
      PART(7)=0.0
      ENDIF
      ENDIF
C
C     REDIRECT FROM LEAVES TO STALK IF LAI BECOMES TOO LARGE
C
      ARLFI=ARLFP(NZ,NY,NX)/AREA(3,NU(NY,NX),NY,NX)
      IF(ARLFI.GT.5.0)THEN
      FPARTL=AMAX1(0.0,(10.0-ARLFI)/5.0)
      PART(3)=PART(3)+(1.0-FPARTL)*(PART(1)+PART(2))
      PART(1)=FPARTL*PART(1)
      PART(2)=FPARTL*PART(2)
      ENDIF
C
C     DECIDUOUS LEAF FALL AFTER GRAIN FILL IN DETERMINATES,
C     AFTER AUTUMNIZATION IN INDETERMINATES, OR AFTER SUSTAINED
C     WATER STRESS
C
      IF((ISTYP(NZ,NY,NX).NE.0
     2.AND.VRNF(NB,NZ,NY,NX).GE.FVRN*VRNX(NB,NZ,NY,NX))
     3.OR.(ISTYP(NZ,NY,NX).EQ.0
     4.AND.IDAY(8,NB,NZ,NY,NX).NE.0))THEN
      IFLGZ=1
      IF(ISTYP(NZ,NY,NX).EQ.0)THEN
      IFLGY=1
      FLGZ(NB,NZ,NY,NX)=FLGZ(NB,NZ,NY,NX)+1.0
      ELSEIF((IWTYP(NZ,NY,NX).EQ.1.OR.IWTYP(NZ,NY,NX).EQ.3)
     2.AND.TCC(NZ,NY,NX).LT.CTC(NZ,NY,NX))THEN
      IFLGY=1
      FLGZ(NB,NZ,NY,NX)=FLGZ(NB,NZ,NY,NX)+1.0
      ENDIF
      IF(IWTYP(NZ,NY,NX).GE.2 
     2.AND.PSILT(NZ,NY,NX).LT.PSILY(IGTYP(NZ,NY,NX)))THEN
      IFLGY=1
      FLGZ(NB,NZ,NY,NX)=FLGZ(NB,NZ,NY,NX)+1.0
      ENDIF 
      IF(ISTYP(NZ,NY,NX).NE.0.AND.IWTYP(NZ,NY,NX).NE.0)THEN
      PART(3)=PART(3)+0.5*(PART(1)+PART(2))
      PART(4)=PART(4)+0.5*(PART(1)+PART(2))
      PART(1)=0.0
      PART(2)=0.0
      ENDIF
      ELSE
      IFLGZ=0
      IFLGY=0
      FLGZ(NB,NZ,NY,NX)=0.0
      ENDIF
C
C     CHECK PARTITIONING COEFFICIENTS
C
      DO 1000 N=1,7
      PART(N)=AMAX1(0.0,PART(N))
      TOTAL=TOTAL+PART(N)
1000  CONTINUE
      IF(TOTAL.GT.ZERO)THEN
      DO 1010 N=1,7
      PART(N)=PART(N)/TOTAL
1010  CONTINUE
      ELSE
      DO 1015 N=1,7
      PART(N)=0.0
1015  CONTINUE
      ENDIF
C
C     SHOOT COEFFICIENTS FOR GROWTH RESPIRATION AND N,P CONTENTS
C     FROM GROWTH YIELDS ENTERED IN 'READQ', AND FROM PARTITIONING
C     COEFFICIENTS ABOVE
C
      IF(IDAY(1,NB,NZ,NY,NX).NE.0)THEN
      DMLFB=DMLF(NZ,NY,NX)
      DMSHB=DMSHE(NZ,NY,NX)
      CNLFB=CNLFW
      CNSHB=CNSHW
      CPLFB=CPLFW
      CPSHB=CPSHW
      ELSE
      DMLFB=DMRT(NZ,NY,NX)
      DMSHB=DMRT(NZ,NY,NX)
      CNLFB=CNRTW
      CNSHB=CNRTW
      CPLFB=CPRTW
      CPSHB=CPRTW
      ENDIF
      DMSHT=PART(1)*DMLFB+PART(2)*DMSHB+PART(3)*DMSTK(NZ,NY,NX)
     2+PART(4)*DMRSV(NZ,NY,NX)+PART(5)*DMHSK(NZ,NY,NX)
     3+PART(6)*DMEAR(NZ,NY,NX)+PART(7)*DMGR(NZ,NY,NX)
      DMSHD=1.0-DMSHT
      CNLFM=PART(1)*DMLFB*ZPLFM*CNLFB
      CPLFM=PART(1)*DMLFB*ZPLFM*CPLFB
      CNLFX=PART(1)*DMLFB*ZPLFD*CNLFB
      CPLFX=PART(1)*DMLFB*ZPLFD*CPLFB
      CNSHX=PART(2)*DMSHB*CNSHB
     2+PART(3)*DMSTK(NZ,NY,NX)*CNSTK(NZ,NY,NX)
     3+PART(4)*DMRSV(NZ,NY,NX)*CNRSV(NZ,NY,NX)
     4+PART(5)*DMHSK(NZ,NY,NX)*CNHSK(NZ,NY,NX)
     5+PART(6)*DMEAR(NZ,NY,NX)*CNEAR(NZ,NY,NX)
     6+PART(7)*DMGR(NZ,NY,NX)*CNRSV(NZ,NY,NX)
      CPSHX=PART(2)*DMSHB*CPSHB
     2+PART(3)*DMSTK(NZ,NY,NX)*CPSTK(NZ,NY,NX)
     3+PART(4)*DMRSV(NZ,NY,NX)*CPRSV(NZ,NY,NX)
     4+PART(5)*DMHSK(NZ,NY,NX)*CPHSK(NZ,NY,NX)
     5+PART(6)*DMEAR(NZ,NY,NX)*CPEAR(NZ,NY,NX)
     6+PART(7)*DMGR(NZ,NY,NX)*CPRSV(NZ,NY,NX)
C
C     TOTAL SHOOT STRUCTURAL N CONTENT FOR MAINTENANCE RESPIRATION
C
      WTSHXN=AMAX1(0.0,WTLFBN(NB,NZ,NY,NX)+WTSHBN(NB,NZ,NY,NX)
     2+CNSTK(NZ,NY,NX)*WVSTKB(NB,NZ,NY,NX))
      IF(IDAY(10,NB,NZ,NY,NX).EQ.0)THEN
      WTSHXN=WTSHXN+AMAX1(0.0,WTHSBN(NB,NZ,NY,NX)
     2+WTEABN(NB,NZ,NY,NX)+WTGRBN(NB,NZ,NY,NX))
      ENDIF
C
C     GROSS PRIMARY PRODUCTIVITY
C
      IF(IDAY(1,NB,NZ,NY,NX).NE.0)THEN
      IF(FDBK(NB,NZ,NY,NX).NE.0)THEN
      IF(SSIN(NY,NX).GT.0.0.AND.RADP(NZ,NY,NX).GT.0.0
     2.AND.CO2Q(NZ,NY,NX).GT.0.0)THEN
      CO2F=0.0
      CH2O=0.0
      IF(IGTYP(NZ,NY,NX).NE.0.OR.WFNC.GT.0.0)THEN
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,5651)'CHECK1',I,J,NZ,NB,IDAY(1,NB,NZ,NY,NX)
C    2,FDBK(NB,NZ,NY,NX),RADP(NZ,NY,NX),CO2Q(NZ,NY,NX),WFNC
5651  FORMAT(A8,5I4,12E12.4)
C     ENDIF
C
C     FOR EACH NODE
C
      DO 100 K=1,25
      CH2O3(K)=0.0
      CH2O4(K)=0.0
      IF(ARLF(K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
C
C     C4 PHOTOSYNTHESIS
C
      IF(ICTYP(NZ,NY,NX).EQ.4.AND.VCGR4(K,NB,NZ,NY,NX).GT.0.0)THEN
C
C     FOR EACH CANOPY LAYER
C
      DO 110 L=NC(NY,NX),1,-1
      IF(ARLFL(L,K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
C
C     FOR EACH LEAF AZIMUTH AND INCLINATION
C
      DO 115 N = 1,4
      DO 120 M = 1,4
C
C     CO2 FIXATION BY SUNLIT LEAVES
C
      IF(SURFX(N,L,K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      IF(PAR(N,M,L,NZ,NY,NX).GT.0.0)THEN
C
C     C4 CARBOXYLATION REACTIONS USING VARIABLES FROM 'STOMATE'
C
      PARX=QNTM*PAR(N,M,L,NZ,NY,NX)
      PARJ=PARX+ETGR4(K,NB,NZ,NY,NX)
      ETLF=(PARJ-SQRT(PARJ**2-CURV4*PARX*ETGR4(K,NB,NZ,NY,NX)))/CURV2
      EGRO=ETLF*CBXN4(K,NB,NZ,NY,NX)
      VL=AMIN1(VGRO4(K,NB,NZ,NY,NX),EGRO)*FDBK4(K,NB,NZ,NY,NX)
C
C     STOMATAL EFFECT OF WATER DEFICIT
C
      IF(VL.GT.ZERO)THEN
      RS=AMIN1(RCMX(NZ,NY,NX),AMAX1(RCMN,DCO2(NZ,NY,NX)/VL))
      RSL=RS+(RCMX(NZ,NY,NX)-RS)*WFNC
      GSL=1.0/RSL*FMOL(NZ,NY,NX)
C
C     NON-STOMATAL EFFECT OF WATER DEFICIT
C
      IF(IGTYP(NZ,NY,NX).NE.0)THEN
      WFN4=(RS/RSL)**1.00
      WFNB=SQRT(RS/RSL)
      ELSE
      WFN4=WFNG
      WFNB=WFNG
      ENDIF
C
C     CONVERGENCE SOLUTION FOR CO2I AT WHICH CARBOXYLATION
C     EQUALS DIFFUSION
C
      CO2X=CO2I(NZ,NY,NX)
      DO 125 NN=1,100
      CO2C=CO2X*SCO2(NZ,NY,NX)
      CO2Y=AMAX1(0.0,CO2C-COMP4)
      CBXNX=CO2Y/(ELEC4*CO2C+10.5*COMP4)
      VGROX=VCGR4(K,NB,NZ,NY,NX)*CO2Y/(CO2C+XKCO24(NZ,NY,NX))
      EGROX=ETLF*CBXNX
      VL=AMIN1(VGROX,EGROX)*WFN4*FDBK4(K,NB,NZ,NY,NX)
      VG=(CO2Q(NZ,NY,NX)-CO2X)*GSL
      IF(VL+VG.GT.ZERO)THEN
      DIFF=(VL-VG)/(VL+VG)
      IF(ABS(DIFF).LT.0.005)GO TO 130
      VA=0.95*VG+0.05*VL
      CO2X=CO2Q(NZ,NY,NX)-VA/GSL
      ELSE
      VL=0.0
      GO TO 130
      ENDIF
125   CONTINUE

C
C     ACCUMULATE C4 FIXATION PRODUCT
C
130   CH2O4(K)=CH2O4(K)+VL*SURFX(N,L,K,NB,NZ,NY,NX)
     2*TAUS(L+1,NY,NX)
C     ICO2I=MAX(1,MIN(400,INT(CO2X)))
C     VCO2(ICO2I,I,NZ)=VCO2(ICO2I,I,NZ)
C    2+(VL*SURFX(N,L,K,NB,NZ,NY,NX)*TAUS(L+1,NY,NX))*0.0432
C     IF(NB.EQ.1.AND.M.EQ.1.AND.N.EQ.3.AND.K.EQ.KLEAF(NB,NZ,NY,NX)
C    2.AND.(I/10)*10.EQ.I.AND.J.EQ.12)THEN
C     WRITE(20,4444)'VLD4',IYRC,I,J,NZ,L,M,N,K,VL,PAR(N,M,L,NZ,NY,NX) 
C    2,PAR(N,M,L,NZ,NY,NX)*TAUS(L+1,NY,NX)+PARDIF(N,M,L,NZ,NY,NX)
C    3*TAU0(L+1,NY,NX)
C    2,RAPS,TKC(NZ,NY,NX),CO2Q(NZ,NY,NX),ETGR4(K,NB,NZ,NY,NX)
C    3,CBXN4(K,NB,NZ,NY,NX),VGRO4(K,NB,NZ,NY,NX),EGRO
C    3,FDBK4(K,NB,NZ,NY,NX),CH2O4(K),WFN4,VGROX,EGROX
C    4,VCGR4(K,NB,NZ,NY,NX),CO2X,CO2C,CBXNX
C    5,RS,RSL
4444  FORMAT(A8,8I4,40E12.4)
C     ENDIF
C
C     C3 CARBOXYLATION REACTIONS IN C4 PLANTS USING VARIABLES FROM 'STOMATE'
C
      PARJ=PARX+ETGRO(K,NB,NZ,NY,NX)
      ETLF=(PARJ-SQRT(PARJ**2-CURV4*PARX*ETGRO(K,NB,NZ,NY,NX)))/CURV2
      EGRO=ETLF*CBXN(K,NB,NZ,NY,NX)
      VL=AMIN1(VGRO(K,NB,NZ,NY,NX),EGRO)*WFNB*FDBK(NB,NZ,NY,NX)
C
C     ACCUMULATE C3 FIXATION PRODUCT
C
      CH2O3(K)=CH2O3(K)+VL*SURFX(N,L,K,NB,NZ,NY,NX)
     2*TAUS(L+1,NY,NX)
C     IF(L.EQ.NC-1.AND.NB.EQ.1.AND.M.EQ.1.AND.N.EQ.1)THEN
C     WRITE(*,4445)'VLD3',IYRC,I,J,NZ,L,M,N,K,VL,PAR(N,M,L,NZ,NY,NX) 
C    2,RAPS,TKC(NZ,NY,NX),CO2Q(NZ,NY,NX),ETGRO(K,NB,NZ,NY,NX)
C    3,CBXN(K,NB,NZ,NY,NX),VGRO(K,NB,NZ,NY,NX),EGRO
C    3,FDBK(NB,NZ,NY,NX),WFNB
4445  FORMAT(A8,8I4,20E12.4)
C     ENDIF
      ENDIF
      ENDIF
C
C     CO2 FIXATION BY SHADED LEAVES
C
      IF(PARDIF(N,M,L,NZ,NY,NX).GT.0.0)THEN
C
C     C4 CARBOXYLATION REACTIONS
C
      PARX=QNTM*PARDIF(N,M,L,NZ,NY,NX)
      PARJ=PARX+ETGR4(K,NB,NZ,NY,NX)
      ETLF=(PARJ-SQRT(PARJ**2-CURV4*PARX*ETGR4(K,NB,NZ,NY,NX)))/CURV2
      EGRO=ETLF*CBXN4(K,NB,NZ,NY,NX)
      VL=AMIN1(VGRO4(K,NB,NZ,NY,NX),EGRO)*FDBK4(K,NB,NZ,NY,NX)
C
C     STOMATAL EFFECT OF WATER DEFICIT
C
      IF(VL.GT.ZERO)THEN
      RS=AMIN1(RCMX(NZ,NY,NX),AMAX1(RCMN,DCO2(NZ,NY,NX)/VL))
      RSL=RS+(RCMX(NZ,NY,NX)-RS)*WFNC
      GSL=1.0/RSL*FMOL(NZ,NY,NX)
C
C     NON-STOMATAL EFFECT OF WATER DEFICIT
C
      IF(IGTYP(NZ,NY,NX).NE.0)THEN
      WFN4=(RS/RSL)**1.00
      WFNB=SQRT(RS/RSL)
      ELSE
      WFN4=WFNG
      WFNB=WFNG
      ENDIF
C
C     CONVERGENCE SOLUTION FOR CO2I AT WHICH CARBOXYLATION
C     EQUALS DIFFUSION
C
      CO2X=CO2I(NZ,NY,NX)
      DO 135 NN=1,100
      CO2C=CO2X*SCO2(NZ,NY,NX)
      CO2Y=AMAX1(0.0,CO2C-COMP4)
      CBXNX=CO2Y/(ELEC4*CO2C+10.5*COMP4)
      VGROX=VCGR4(K,NB,NZ,NY,NX)*CO2Y/(CO2C+XKCO24(NZ,NY,NX))
      EGROX=ETLF*CBXNX
      VL=AMIN1(VGROX,EGROX)*WFN4*FDBK4(K,NB,NZ,NY,NX)
      VG=(CO2Q(NZ,NY,NX)-CO2X)*GSL
      IF(VL+VG.GT.ZERO)THEN
      DIFF=(VL-VG)/(VL+VG)
      IF(ABS(DIFF).LT.0.005)GO TO 140
      VA=0.95*VG+0.05*VL
      CO2X=CO2Q(NZ,NY,NX)-VA/GSL
      ELSE
      VL=0.0
      GO TO 140
      ENDIF
135   CONTINUE
C
C     ACCUMULATE C4 FIXATION PRODUCT
C
140   CH2O4(K)=CH2O4(K)+VL*SURFX(N,L,K,NB,NZ,NY,NX)
     2*TAU0(L+1,NY,NX)
C     ICO2I=MAX(1,MIN(400,INT(CO2X)))
C     VCO2(ICO2I,I,NZ)=VCO2(ICO2I,I,NZ)
C    2+(VL*SURFX(N,L,K,NB,NZ,NY,NX)*TAU0(L+1,NY,NX))*0.0432
C     WRITE(*,4455)'VLB4',IYRC,I,J,NZ,L,M,N,K,VL,PAR(N,M,L,NZ,NY,NX) 
C    2,RAPS,TKC(NZ,NY,NX),CO2Q(NZ,NY,NX),ETGR4(K,NB,NZ,NY,NX)
C    3,CBXN4(K,NB,NZ,NY,NX),VGRO4(K,NB,NZ,NY,NX),EGRO
C    3,FDBK4(K,NB,NZ,NY,NX),CH2O4(K),WFN4,VGROX,EGROX
C    4,VCGR4(K,NB,NZ,NY,NX),CO2X,CO2C,CBXNX
C    5,RS,RSL
4455  FORMAT(A8,8I4,40E12.4)
C
C     C3 CARBOXYLATION REACTIONS IN C4 PLANTS USING VARIABLES FROM 'STOMATE'
C
      PARJ=PARX+ETGRO(K,NB,NZ,NY,NX)
      ETLF=(PARJ-SQRT(PARJ**2-CURV4*PARX*ETGRO(K,NB,NZ,NY,NX)))/CURV2
      EGRO=ETLF*CBXN(K,NB,NZ,NY,NX)
      VL=AMIN1(VGRO(K,NB,NZ,NY,NX),EGRO)*WFNB*FDBK(NB,NZ,NY,NX)
C
C     ACCUMULATE C3 FIXATION PRODUCT
C
      CH2O3(K)=CH2O3(K)+VL*SURFX(N,L,K,NB,NZ,NY,NX)
     2*TAU0(L+1,NY,NX)
C     IF(J.EQ.13.AND.NB.EQ.1.AND.M.EQ.1.AND.N.EQ.1)THEN
C     WRITE(*,4444)'VLB4',IYRC,I,J,NZ,L,K,VL,PARDIF(N,M,L,NZ,NY,NX) 
C    2,RAPY,TKC(NZ,NY,NX),CO2Q(NZ,NY,NX),CO2X,FMOL(NZ,NY,NX)/GSL
C    3,VCGRO(K,NB,NZ,NY,NX),ETLF,FDBK(NB,NZ,NY,NX),WFNB
C     ENDIF
      ENDIF
      ENDIF
      ENDIF
120   CONTINUE
115   CONTINUE
      ENDIF
110   CONTINUE
      CO2F=CO2F+CH2O4(K)
      CH2O=CH2O+CH2O3(K)
C
C     C3 PHOTOSYNTHESIS
C
      ELSEIF(ICTYP(NZ,NY,NX).NE.4.AND.VCGRO(K,NB,NZ,NY,NX).GT.0.0)THEN
C
C     FOR EACH CANOPY LAYER
C
      DO 210 L=NC(NY,NX),1,-1
      IF(ARLFL(L,K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
C
C     FOR EACH LEAF AZIMUTH AND INCLINATION
C
      DO 215 N=1,4
      DO 220 M=1,4
C
C     CO2 FIXATION BY SUNLIT LEAVES
C
      IF(SURFX(N,L,K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN

      IF(PAR(N,M,L,NZ,NY,NX).GT.0.0)THEN
C
C     C3 CARBOXYLATION REACTIONS USING VARIABLES FROM 'STOMATE'
C
      PARX=QNTM*PAR(N,M,L,NZ,NY,NX)
      PARJ=PARX+ETGRO(K,NB,NZ,NY,NX)
      ETLF=(PARJ-SQRT(PARJ**2-CURV4*PARX*ETGRO(K,NB,NZ,NY,NX)))/CURV2
      EGRO=ETLF*CBXN(K,NB,NZ,NY,NX)
      VL=AMIN1(VGRO(K,NB,NZ,NY,NX),EGRO)*FDBK(NB,NZ,NY,NX)
C
C     STOMATAL EFFECT OF WATER DEFICIT
C
      IF(VL.GT.ZERO)THEN
      RS=AMIN1(RCMX(NZ,NY,NX),AMAX1(RCMN,DCO2(NZ,NY,NX)/VL))
      RSL=RS+(RCMX(NZ,NY,NX)-RS)*WFNC
      GSL=1.0/RSL*FMOL(NZ,NY,NX)
C
C     NON-STOMATAL EFFECT OF WATER DEFICIT
C
      IF(IGTYP(NZ,NY,NX).NE.0)THEN
      WFNB=SQRT(RS/RSL)
      ELSE
      WFNB=WFNG
      ENDIF
C
C     CONVERGENCE SOLUTION FOR CO2I AT WHICH CARBOXYLATION
C     EQUALS DIFFUSION
C
      CO2X=CO2I(NZ,NY,NX)
      DO 225 NN=1,100
      CO2C=CO2X*SCO2(NZ,NY,NX)
      CO2Y=AMAX1(0.0,CO2C-COMPL(K,NB,NZ,NY,NX))
      CBXNX=CO2Y/(ELEC3*CO2C+10.5*COMPL(K,NB,NZ,NY,NX))
      VGROX=VCGRO(K,NB,NZ,NY,NX)*CO2Y/(CO2C+XKCO2O(NZ,NY,NX))
      EGROX=ETLF*CBXNX
      VL=AMIN1(VGROX,EGROX)*WFNB*FDBK(NB,NZ,NY,NX)
      VG=(CO2Q(NZ,NY,NX)-CO2X)*GSL
      IF(VL+VG.GT.ZERO)THEN
      DIFF=(VL-VG)/(VL+VG)
      IF(ABS(DIFF).LT.0.005)GO TO 230
      VA=0.95*VG+0.05*VL
      CO2X=CO2Q(NZ,NY,NX)-VA/GSL
      ELSE
      VL=0.0
      GO TO 230
      ENDIF
225   CONTINUE
C
C     ACCUMULATE C3 FIXATION PRODUCT
C
230   CH2O3(K)=CH2O3(K)+VL*SURFX(N,L,K,NB,NZ,NY,NX)
     2*TAUS(L+1,NY,NX)
C     ICO2I=MAX(1,MIN(400,INT(CO2X)))
C     VCO2(ICO2I,I,NZ)=VCO2(ICO2I,I,NZ)
C    2+(VL*SURFX(N,L,K,NB,NZ,NY,NX)*TAUS(L+1,NY,NX))*0.0432
C     IF(NB.EQ.1.AND.M.EQ.1.AND.N.EQ.1.AND.K.EQ.KLEAF(NB,NZ,NY,NX)-1
C    2.AND.J.EQ.12)THEN
C     WRITE(20,3335)'VLD',IYRC,I,J,NZ,L,M,N,K,VL,PAR(N,M,L,NZ,NY,NX)
C    2,RAPS,TKC(NZ,NY,NX),TKA,CO2Q(NZ,NY,NX),CO2X,CO2C,FMOL(NZ,NY,NX) 
C    3/GSL,VGROX,EGROX,ETLF,CBXNX,FDBK(NB,NZ,NY,NX),WFNB,PSILG(NZ,NY,NX)
C    4,VCGRO(K,NB,NZ,NY,NX),ETGRO(K,NB,NZ,NY,NX),COMPL(K,NB,NZ,NY,NX)
C    5,SURFX(N,L,K,NB,NZ,NY,NX),TAUS(L+1,NY,NX),CH2O3(K)
3335  FORMAT(A8,8I4,30E12.4)
C     ENDIF
      ENDIF
      ENDIF
C
C     CO2 FIXATION BY SHADED LEAVES
C
      IF(PARDIF(N,M,L,NZ,NY,NX).GT.0.0)THEN
C
C     C3 CARBOXYLATION REACTIONS USING VARIABLES FROM 'STOMATE'
C
      PARX=QNTM*PARDIF(N,M,L,NZ,NY,NX)
      PARJ=PARX+ETGRO(K,NB,NZ,NY,NX)
      ETLF=(PARJ-SQRT(PARJ**2-CURV4*PARX*ETGRO(K,NB,NZ,NY,NX)))/CURV2
      EGRO=ETLF*CBXN(K,NB,NZ,NY,NX)
      VL=AMIN1(VGRO(K,NB,NZ,NY,NX),EGRO)*FDBK(NB,NZ,NY,NX)
C
C     STOMATAL EFFECT OF WATER DEFICIT
C
      IF(VL.GT.ZERO)THEN
      RS=AMIN1(RCMX(NZ,NY,NX),AMAX1(RCMN,DCO2(NZ,NY,NX)/VL))
      RSL=RS+(RCMX(NZ,NY,NX)-RS)*WFNC
      GSL=1.0/RSL*FMOL(NZ,NY,NX)
C
C     NON-STOMATAL EFFECT OF WATER DEFICIT
C
      IF(IGTYP(NZ,NY,NX).NE.0)THEN
      WFNB=SQRT(RS/RSL)
      ELSE
      WFNB=WFNG
      ENDIF
C
C     CONVERGENCE SOLUTION FOR CO2I AT WHICH CARBOXYLATION
C     EQUALS DIFFUSION
C
      CO2X=CO2I(NZ,NY,NX)
      DO 235 NN=1,100
      CO2C=CO2X*SCO2(NZ,NY,NX)
      CO2Y=AMAX1(0.0,CO2C-COMPL(K,NB,NZ,NY,NX))
      CBXNX=CO2Y/(ELEC3*CO2C+10.5*COMPL(K,NB,NZ,NY,NX))
      VGROX=VCGRO(K,NB,NZ,NY,NX)*CO2Y/(CO2C+XKCO2O(NZ,NY,NX))
      EGROX=ETLF*CBXNX
      VL=AMIN1(VGROX,EGROX)*WFNB*FDBK(NB,NZ,NY,NX)
      VG=(CO2Q(NZ,NY,NX)-CO2X)*GSL
      IF(VL+VG.GT.ZERO)THEN
      DIFF=(VL-VG)/(VL+VG)
      IF(ABS(DIFF).LT.0.005)GO TO 240
      VA=0.95*VG+0.05*VL
      CO2X=CO2Q(NZ,NY,NX)-VA/GSL
      ELSE
      VL=0.0
      GO TO 240
      ENDIF
235   CONTINUE
C
C     ACCUMULATE C3 FIXATION PRODUCT
C
240   CH2O3(K)=CH2O3(K)+VL*SURFX(N,L,K,NB,NZ,NY,NX)
     2*TAU0(L+1,NY,NX)
C     ICO2I=MAX(1,MIN(400,INT(CO2X)))
C     VCO2(ICO2I,I,NZ)=VCO2(ICO2I,I,NZ)
C    2+(VL*SURFX(N,L,K,NB,NZ,NY,NX)*TAU0(L+1,NY,NX))*0.0432
C     IF(J.EQ.13.AND.NB.EQ.1.AND.M.EQ.1.AND.N.EQ.1)THEN
C     WRITE(*,3335)'VLB',IYRC,I,J,NZ,L,K,VL,PARDIF(N,M,L,NZ,NY,NX) 
C    2,RAPY,TKC(NZ,NY,NX),CO2Q(NZ,NY,NX),CO2X,FMOL(NZ,NY,NX)/GSL
C    3,VCGRO(K,NB,NZ,NY,NX),ETLF,FDBK(NB,NZ,NY,NX),WFNB
C     ENDIF
      ENDIF
      ENDIF
      ENDIF
220   CONTINUE
215   CONTINUE
      ENDIF
210   CONTINUE
      CO2F=CO2F+CH2O3(K)
      CH2O=CH2O+CH2O3(K)
      ENDIF
      ENDIF
100   CONTINUE
      CO2F=CO2F*0.0432
      CH2O=CH2O*0.0432
C
C     CONVERT UMOL M-2 S-1 TO G C M-2 H-1
C
      DO 150 K=1,25
      CH2O3(K)=CH2O3(K)*0.0432
      CH2O4(K)=CH2O4(K)*0.0432
150   CONTINUE
      ELSE
      CO2F=0.0
      CH2O=0.0
      IF(ICTYP(NZ,NY,NX).EQ.4)THEN
      DO 155 K=1,25
      CH2O3(K)=0.0
      CH2O4(K)=0.0
155   CONTINUE
      ENDIF
      ENDIF
      ELSE
      CO2F=0.0
      CH2O=0.0
      IF(ICTYP(NZ,NY,NX).EQ.4)THEN
      DO 160 K=1,25
      CH2O3(K)=0.0
      CH2O4(K)=0.0
160   CONTINUE
      ENDIF
      ENDIF
      ELSE
      CO2F=0.0
      CH2O=0.0
      IF(ICTYP(NZ,NY,NX).EQ.4)THEN
      DO 165 K=1,25
      CH2O3(K)=0.0
      CH2O4(K)=0.0
165   CONTINUE
      ENDIF
      ENDIF
C
C     SHOOT AUTOTROPHIC RESPIRATION AFTER EMERGENCE
C
C
C     N,P CONSTRAINT ON RESPIRATION FROM NON-STRUCTURAL C:N:P
C
      IF(CCPOLB(NB,NZ,NY,NX).GT.ZERO)THEN
      CNPG=AMIN1(CZPOLB(NB,NZ,NY,NX)/(CZPOLB(NB,NZ,NY,NX)
     2+CCPOLB(NB,NZ,NY,NX)/CNKI)
     3,CPPOLB(NB,NZ,NY,NX)/(CPPOLB(NB,NZ,NY,NX)
     2+CCPOLB(NB,NZ,NY,NX)/CPKI))
      ELSE
      CNPG=1.0
      ENDIF
C
C     RESPIRATION FROM NON-STRUCTURAL C DETERMINED BY TEMPERATURE,
C     NON-STRUCTURAL C:N:P
C
      RCO2C=AMAX1(0.0,VMXC*CPOOL(NB,NZ,NY,NX)
     2*TFN3(NZ,NY,NX))*CNPG*FDBKX(NB,NZ,NY,NX)*WFNG
C
C     MAINTENANCE RESPIRATION FROM TEMPERATURE, PLANT STRUCTURAL N
C
      RMNCS=AMAX1(0.0,RMPLT*TFN5*WTSHXN)
      IF(IWTYP(NZ,NY,NX).EQ.2)THEN
      RMNCS=RMNCS*WFNG
      ENDIF 
C
C     GROWTH RESPIRATION FROM TOTAL - MAINTENANCE
C     IF > 0 DRIVES GROWTH, IF < 0 DRIVES REMOBILIZATION
C
      RCO2X=RCO2C-RMNCS
      RCO2Y=AMAX1(0.0,RCO2X)*WFNSG
      SNCR=AMAX1(0.0,-RCO2X)
C
C     GROWTH RESPIRATION MAY BE LIMITED BY NON-STRUCTURAL N,P
C     AVAILABLE FOR GROWTH
C
      IF(RCO2Y.GT.0.0.AND.(CNSHX.GT.0.0.OR.CNLFX.GT.0.0))THEN
      ZPOOLB=AMAX1(0.0,ZPOOL(NB,NZ,NY,NX))
      PPOOLB=AMAX1(0.0,PPOOL(NB,NZ,NY,NX))
      RCO2G=AMIN1(RCO2Y,ZPOOLB*DMSHD/(CNSHX+CNLFM+CNLFX*CNPG)
     2,PPOOLB*DMSHD/(CPSHX+CPLFM+CPLFX*CNPG))
      ELSE
      RCO2G=0.0
      ENDIF
C
C     TOTAL NON-STRUCTURAL C,N,P USED IN GROWTH
C     AND GROWTH RESPIRATION DEPENDS ON GROWTH YIELDS
C     ENTERED IN 'READQ'
C
      CGROS=RCO2G/DMSHD
      ZADDB=AMAX1(0.0,AMIN1(ZPOOL(NB,NZ,NY,NX)
     2,CGROS*(CNSHX+CNLFM+CNLFX*CNPG)))
      PADDB=AMAX1(0.0,AMIN1(PPOOL(NB,NZ,NY,NX)
     2,CGROS*(CPSHX+CPLFM+CPLFX*CNPG)))
      CNRDA=AMAX1(0.0,1.70*ZADDB-0.025*CH2O)
C
C     TOTAL ABOVE-GROUND AUTOTROPHIC RESPIRATION BY BRANCH
C     ACCUMULATE GPP, SHOOT AUTOTROPHIC RESPIRATION, NET C EXCHANGE
C
      RCO2T=AMIN1(RMNCS,RCO2C)+RCO2G+SNCR+CNRDA
      CARBN(NZ,NY,NX)=CARBN(NZ,NY,NX)+CO2F
      TCSNR(NZ,NY,NX)=TCSNR(NZ,NY,NX)-RCO2T
      TCO2A(NZ,NY,NX)=TCO2A(NZ,NY,NX)-RCO2T
      CNET(NZ,NY,NX)=CNET(NZ,NY,NX)+CO2F-RCO2T
      GPP(NY,NX)=GPP(NY,NX)+CO2F
      TGPP(NY,NX)=TGPP(NY,NX)+CO2F
      RECO(NY,NX)=RECO(NY,NX)-RCO2T
      TRAU(NY,NX)=TRAU(NY,NX)-RCO2T
C     IF(NZ.EQ.1)THEN
C     WRITE(*,4477)'RCO2',I,J,NX,NY,NZ,NB,IFLGZ,CPOOL(NB,NZ,NY,NX)
C    2,CH2O,RMNCS,RCO2C,CGROS,CNRDA,CNPG,RCO2T,RCO2X,SNCR
C    3,RCO2G,DMSHD,ZADDB,PART(1),PART(2),DMLFB,DMSHB
C    4,WTRSVB(NB,NZ,NY,NX),WVSTKB(NB,NZ,NY,NX),WTSHXN 
C    5,ZPOOL(NB,NZ,NY,NX),PPOOL(NB,NZ,NY,NX),PSILT(NZ,NY,NX)
C    6,ZADDB,RNH3B(NB,NZ,NY,NX),WFR(1,NG(NZ,NY,NX),NZ,NY,NX)
C    7,WFNG,TFN3(NZ,NY,NX),TFN5,FDBKX(NB,NZ,NY,NX),VMXC
4477  FORMAT(A8,7I4,40E12.4)
C     ENDIF
C
C     SHOOT AUTOTROPHIC RESPIRATION BEFORE EMERGENCE
C
      ELSE
C
C     N,P CONSTRAINT ON RESPIRATION FROM NON-STRUCTURAL C:N:P
C
      IF(CCPOLB(NB,NZ,NY,NX).GT.ZERO)THEN
      CNPG=AMIN1(CZPOLB(NB,NZ,NY,NX)/(CZPOLB(NB,NZ,NY,NX)
     2+CCPOLB(NB,NZ,NY,NX)/CNKI)
     3,CPPOLB(NB,NZ,NY,NX)/(CPPOLB(NB,NZ,NY,NX)
     4+CCPOLB(NB,NZ,NY,NX)/CPKI))
      ELSE
      CNPG=1.0
      ENDIF
C
C     RESPIRATION FROM NON-STRUCTURAL C DETERMINED BY TEMPERATURE,
C     NON-STRUCTURAL C:N:P, O2 UPTAKE
C
      RCO2CM=AMAX1(0.0,VMXC*CPOOL(NB,NZ,NY,NX)
     2*TFN4(NG(NZ,NY,NX),NZ,NY,NX))*CNPG*WFNG*FDBKX(NB,NZ,NY,NX)
      RCO2C=RCO2CM*WFR(1,NG(NZ,NY,NX),NZ,NY,NX)
C
C     MAINTENANCE RESPIRATION FROM TEMPERATURE, PLANT STRUCTURAL N
C
      RMNCS=AMAX1(0.0,RMPLT*TFN6(NG(NZ,NY,NX))*WTSHXN)
      IF(IWTYP(NZ,NY,NX).EQ.2)THEN
      RMNCS=RMNCS*WFNG
      ENDIF 
C
C     GROWTH RESPIRATION FROM TOTAL - MAINTENANCE
C     IF > 0 DRIVES GROWTH, IF < 0 DRIVES REMOBILIZATION
C
      RCO2XM=RCO2CM-RMNCS
      RCO2X=RCO2C-RMNCS
      RCO2YM=AMAX1(0.0,RCO2XM)*WFNSG
      RCO2Y=AMAX1(0.0,RCO2X)*WFNSG
      SNCRM=AMAX1(0.0,-RCO2XM)
      SNCR=AMAX1(0.0,-RCO2X)
C
C     GROWTH RESPIRATION MAY BE LIMITED BY NON-STRUCTURAL N,P
C     AVAILABLE FOR GROWTH
C
      IF(CNSHX.GT.0.0.OR.CNLFX.GT.0.0)THEN
      ZPOOLB=AMAX1(0.0,ZPOOL(NB,NZ,NY,NX))
      PPOOLB=AMAX1(0.0,PPOOL(NB,NZ,NY,NX))
      FNP=AMIN1(ZPOOLB*DMSHD/(CNSHX+CNLFM+CNLFX*CNPG)
     2,PPOOLB*DMSHD/(CPSHX+CPLFM+CPLFX*CNPG))
      IF(RCO2YM.GT.0.0)THEN
      RCO2GM=AMIN1(RCO2YM,FNP)
      ELSE
      RCO2GM=0.0
      ENDIF
      IF(RCO2Y.GT.0.0)THEN
      RCO2G=AMIN1(RCO2Y,FNP*WFR(1,NG(NZ,NY,NX),NZ,NY,NX))
      ELSE
      RCO2G=0.0
      ENDIF
      ELSE
      RCO2GM=0.0
      RCO2G=0.0
      ENDIF
C
C     TOTAL NON-STRUCTURAL C,N,P USED IN GROWTH
C     AND GROWTH RESPIRATION DEPENDS ON GROWTH YIELDS
C     ENTERED IN 'READQ'
C
      CGROSM=RCO2GM/DMSHD
      CGROS=RCO2G/DMSHD
      ZADDBM=AMAX1(0.0,CGROSM*(CNSHX+CNLFM+CNLFX*CNPG))
      ZADDB=AMAX1(0.0,CGROS*(CNSHX+CNLFM+CNLFX*CNPG))
      PADDB=AMAX1(0.0,CGROS*(CPSHX+CPLFM+CPLFX*CNPG))
      CNRDM=AMAX1(0.0,1.70*ZADDBM)
      CNRDA=AMAX1(0.0,1.70*ZADDB)
C
C     TOTAL ABOVE-GROUND AUTOTROPHIC RESPIRATION BY BRANCH
C     ACCUMULATE GPP, SHOOT AUTOTROPHIC RESPIRATION, NET C EXCHANGE
C
      RCO2TM=RMNCS+RCO2GM+SNCRM+CNRDM
      RCO2T=RMNCS+RCO2G+SNCR+CNRDA
      RCO2M(1,NG(NZ,NY,NX),NZ,NY,NX)=RCO2M(1,NG(NZ,NY,NX),NZ,NY,NX)
     2+RCO2TM
      RCO2N(1,NG(NZ,NY,NX),NZ,NY,NX)=RCO2N(1,NG(NZ,NY,NX),NZ,NY,NX)
     2+RCO2T
      RCO2A(1,NG(NZ,NY,NX),NZ,NY,NX)=RCO2A(1,NG(NZ,NY,NX),NZ,NY,NX)
     2-RCO2T
      CH2O=0.0
      ENDIF
C
C     REMOVE C,N,P USED IN MAINTENANCE + GROWTH REPIRATION AND GROWTH
C     FROM NON-STRUCTURAL POOLS
C
      CPOOL(NB,NZ,NY,NX)=CPOOL(NB,NZ,NY,NX)+CH2O-AMIN1(RMNCS,RCO2C)
     2-CGROS-CNRDA
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)-ZADDB+RNH3B(NB,NZ,NY,NX)
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)-PADDB
C
C     TRANSFER OF C4 FIXATION PRODUCTS FROM NON-STRUCTURAL POOLS
C     IN MESOPHYLL TO THOSE IN BUNDLE SHEATH, DECARBOXYLATION
C     OF C4 FIXATION PRODUCTS IN BUNDLE SHEATH, LEAKAGE OF DECARBOXYLATION
C     PRODUCTS BACK TO MESOPHYLL IN C4 PLANTS
C
      IF(ICTYP(NZ,NY,NX).EQ.4)THEN
      DO 170 K=1,25
      IF(WGLF(K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      CCBS1=AMAX1(0.0,0.083E+09*CO2B(K,NB,NZ,NY,NX)
     2/(WGLF(K,NB,NZ,NY,NX)*FBS))
C
C     BUNDLE SHEATH LEAKAGE
C
      CO2LK=AMIN1(AMAX1(0.0,CPOOL3(K,NB,NZ,NY,NX)-CH2O3(K))
     2,5.0E-07*(CCBS1-CO2L(NZ,NY,NX))*WGLF(K,NB,NZ,NY,NX)*FBS)
      IF(CPOOL3(K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FPL3X=CPOOL3(K,NB,NZ,NY,NX)/(CPOOL3(K,NB,NZ,NY,NX)
     2+AMAX1(0.0,CO2B(K,NB,NZ,NY,NX)))
      ELSE
      FPL3X=0.0
      ENDIF
      CPL3X=FPL3X*(CH2O3(K)+CO2LK)
      CPL3Z=CPL3X-CH2O3(K)-CO2LK 
      CO2B(K,NB,NZ,NY,NX)=CO2B(K,NB,NZ,NY,NX)+FCO2B*CPL3Z 
      HCOB(K,NB,NZ,NY,NX)=HCOB(K,NB,NZ,NY,NX)+FHCOB*CPL3Z 
      CPOOL3(K,NB,NZ,NY,NX)=CPOOL3(K,NB,NZ,NY,NX)-CPL3X
C
C     BUNDLE SHEATH DECARBOXYLATION
C
      CCBS2=AMAX1(0.0,0.083E+09*CO2B(K,NB,NZ,NY,NX)
     2/(WGLF(K,NB,NZ,NY,NX)*FBS))
      CPL3K=2.5E-02*CPOOL3(K,NB,NZ,NY,NX)/(1.0+CCBS2/CO2KI)
      CPOOL3(K,NB,NZ,NY,NX)=CPOOL3(K,NB,NZ,NY,NX)-CPL3K
      CO2B(K,NB,NZ,NY,NX)=CO2B(K,NB,NZ,NY,NX)+FCO2B*CPL3K
      HCOB(K,NB,NZ,NY,NX)=HCOB(K,NB,NZ,NY,NX)+FHCOB*CPL3K 
C
C     MESOPHYLL TO BUNDLE SHEATH TRANSFER
C
      CPOOL4(K,NB,NZ,NY,NX)=CPOOL4(K,NB,NZ,NY,NX)+CH2O4(K)
      CPL4M=0.5*(CPOOL4(K,NB,NZ,NY,NX)*WGLF(K,NB,NZ,NY,NX)*FBS
     2-CPOOL3(K,NB,NZ,NY,NX)*WGLF(K,NB,NZ,NY,NX)*FMP)
     2/(WGLF(K,NB,NZ,NY,NX)*(FBS+FMP))
      CPOOL4(K,NB,NZ,NY,NX)=CPOOL4(K,NB,NZ,NY,NX)-CPL4M
      CPOOL3(K,NB,NZ,NY,NX)=CPOOL3(K,NB,NZ,NY,NX)+CPL4M
      TCSNR(NZ,NY,NX)=TCSNR(NZ,NY,NX)-CO2LK
      TCO2A(NZ,NY,NX)=TCO2A(NZ,NY,NX)-CO2LK
      CNET(NZ,NY,NX)=CNET(NZ,NY,NX)-CO2LK
      RECO(NY,NX)=RECO(NY,NX)-CO2LK
      TRAU(NY,NX)=TRAU(NY,NX)-CO2LK
      CO2LKF=CO2LK/ARLF(K,NB,NZ,NY,NX)*23.148
C     TC4=TC4+CH2O4(K)
C     TLK=TLK+CO2LK
C     IF(NB.EQ.1.AND.(K.EQ.16))THEN
C     CCBS3=AMAX1(0.0,0.083E+09*CO2B(K,NB,NZ,NY,NX)
C    2/(WGLF(K,NB,NZ,NY,NX)*FBS))
C     WRITE(*,6667)'CO2K',I,J,NB,K,CPOOL4(K,NB,NZ,NY,NX)
C    2,CPOOL3(K,NB,NZ,NY,NX),CO2B(K,NB,NZ,NY,NX)
C    2,CPOOL4(K,NB,NZ,NY,NX)/(WGLF(K,NB,NZ,NY,NX)*FMP)
C    2,CPOOL3(K,NB,NZ,NY,NX)/(WGLF(K,NB,NZ,NY,NX)*FBS)
C    2,CO2B(K,NB,NZ,NY,NX)/(WGLF(K,NB,NZ,NY,NX)*FBS)
C    4,FPL3X,CH2O4(K),CH2O3(K),CPL4M,CPL3X,CPL3K,CO2LK
C    5,TC4,TLK,CO2LKF,CCBS1,CO2L(NZ,NY,NX),CCBS3
C    6,ARLF(K,NB,NZ,NY,NX),HCOB(K,NB,NZ,NY,NX)
6667  FORMAT(A8,4I4,30E14.6)
C     ENDIF
      ENDIF
170   CONTINUE
      ENDIF
C
C     C,N,P GROWTH OF LEAF, SHEATH OR PETIOLE, STALK,
C     STALK RESERVES, REPRODUCTIVE ORGANS, GRAIN
C
      GROLF=PART(1)*CGROS*DMLFB
      GROSHE=PART(2)*CGROS*DMSHB
      GROSTK=PART(3)*CGROS*DMSTK(NZ,NY,NX)
      GRORSV=PART(4)*CGROS*DMRSV(NZ,NY,NX)
      GROHSK=PART(5)*CGROS*DMHSK(NZ,NY,NX)
      GROEAR=PART(6)*CGROS*DMEAR(NZ,NY,NX)
      GROGR=PART(7)*CGROS*DMGR(NZ,NY,NX)
      GROSHT=CGROS*DMSHT
      GROLFN=GROLF*CNLFB*(ZPLFM+ZPLFD*CNPG)
      GROSHN=GROSHE*CNSHB
      GROSTN=GROSTK*CNSTK(NZ,NY,NX)
      GRORSN=GRORSV*CNRSV(NZ,NY,NX)
      GROHSN=GROHSK*CNHSK(NZ,NY,NX)
      GROEAN=GROEAR*CNEAR(NZ,NY,NX)
      GROGRN=GROGR*CNRSV(NZ,NY,NX)
      GROLFP=GROLF*CPLFB*(ZPLFM+ZPLFD*CNPG)
      GROSHP=GROSHE*CPSHB
      GROSTP=GROSTK*CPSTK(NZ,NY,NX)
      GRORSP=GRORSV*CPRSV(NZ,NY,NX)
      GROHSP=GROHSK*CPHSK(NZ,NY,NX)
      GROEAP=GROEAR*CPEAR(NZ,NY,NX)
      GROGRP=GROGR*CPRSV(NZ,NY,NX)
      WTLFB(NB,NZ,NY,NX)=WTLFB(NB,NZ,NY,NX)+GROLF
      WTSHEB(NB,NZ,NY,NX)=WTSHEB(NB,NZ,NY,NX)+GROSHE
      WTSTKB(NB,NZ,NY,NX)=WTSTKB(NB,NZ,NY,NX)+GROSTK
      WTRSVB(NB,NZ,NY,NX)=WTRSVB(NB,NZ,NY,NX)+GRORSV
      WTHSKB(NB,NZ,NY,NX)=WTHSKB(NB,NZ,NY,NX)+GROHSK
      WTEARB(NB,NZ,NY,NX)=WTEARB(NB,NZ,NY,NX)+GROEAR
      WTLFBN(NB,NZ,NY,NX)=WTLFBN(NB,NZ,NY,NX)+GROLFN
      WTSHBN(NB,NZ,NY,NX)=WTSHBN(NB,NZ,NY,NX)+GROSHN
      WTSTBN(NB,NZ,NY,NX)=WTSTBN(NB,NZ,NY,NX)+GROSTN
      WTRSBN(NB,NZ,NY,NX)=WTRSBN(NB,NZ,NY,NX)+GRORSN
      WTHSBN(NB,NZ,NY,NX)=WTHSBN(NB,NZ,NY,NX)+GROHSN
      WTEABN(NB,NZ,NY,NX)=WTEABN(NB,NZ,NY,NX)+GROEAN
      WTLFBP(NB,NZ,NY,NX)=WTLFBP(NB,NZ,NY,NX)+GROLFP
      WTSHBP(NB,NZ,NY,NX)=WTSHBP(NB,NZ,NY,NX)+GROSHP
      WTSTBP(NB,NZ,NY,NX)=WTSTBP(NB,NZ,NY,NX)+GROSTP
      WTRSBP(NB,NZ,NY,NX)=WTRSBP(NB,NZ,NY,NX)+GRORSP
      WTHSBP(NB,NZ,NY,NX)=WTHSBP(NB,NZ,NY,NX)+GROHSP
      WTEABP(NB,NZ,NY,NX)=WTEABP(NB,NZ,NY,NX)+GROEAP
C
C     DISTRIBUTE LEAF GROWTH AMONG CURRENTLY GROWING NODES
C
      CCE=AMIN1(CZPOLB(NB,NZ,NY,NX)/(CZPOLB(NB,NZ,NY,NX)
     2+CCPOLB(NB,NZ,NY,NX)/CNKI)
     3,CPPOLB(NB,NZ,NY,NX)/(CPPOLB(NB,NZ,NY,NX)
     4+CCPOLB(NB,NZ,NY,NX)/CPKI))
      ETOL=1.0+CCE
      IF(NB.EQ.NB1(NZ,NY,NX).AND.HTCTL(NZ,NY,NX).LE.SDPTH(NZ,NY,NX))THEN
      NNOD1=0
      ELSE
      NNOD1=1
      ENDIF
      IF(GROLF.GT.0.0)THEN
      MXNOD=KVSTG(NB,NZ,NY,NX)
      MNNOD=MAX(NNOD1,MXNOD-NNOD(NZ,NY,NX)+1)
      MXNOD=MAX(MXNOD,MNNOD)
      KNOD=MXNOD-MNNOD+1
      GNOD=KNOD
      ALLOCL=1.0/GNOD
      GRO=ALLOCL*GROLF
      GRON=ALLOCL*GROLFN
      GROP=ALLOCL*GROLFP
      GSLA=ALLOCL*FNOD(NZ,NY,NX)*NNOD(NZ,NY,NX)
C
C     GROWTH AT EACH CURRENT NODE
C
      DO 490 KK=MNNOD,MXNOD
      K=MOD(KK,25)
      IF(K.EQ.0.AND.KK.NE.0)K=25
      WGLF(K,NB,NZ,NY,NX)=WGLF(K,NB,NZ,NY,NX)+GRO
      WGLFN(K,NB,NZ,NY,NX)=WGLFN(K,NB,NZ,NY,NX)+GRON
      WGLFP(K,NB,NZ,NY,NX)=WGLFP(K,NB,NZ,NY,NX)+GROP
      WSLF(K,NB,NZ,NY,NX)=WSLF(K,NB,NZ,NY,NX)
     2+AMIN1(GRON*CNWS(NZ,NY,NX),GROP*CPWS(NZ,NY,NX))
C
C     SPECIFIC LEAF AREA FUNCTION OF CURRENT LEAF MASS
C     WITH PARAMETERS FROM 'READQ'
C
      SLA=ETOL*SLA1(NZ,NY,NX)*(AMAX1(ZEROL(NZ,NY,NX)
     2,WGLF(K,NB,NZ,NY,NX))/(PP(NZ,NY,NX)*GSLA))**SLA2*WFNS
      GROA=GRO*SLA 
      ARLFB(NB,NZ,NY,NX)=ARLFB(NB,NZ,NY,NX)+GROA
      ARLF(K,NB,NZ,NY,NX)=ARLF(K,NB,NZ,NY,NX)+GROA
490   CONTINUE
      ENDIF
C
C     DISTRIBUTE SHEATH OR PETIOLE GROWTH AMONG CURRENTLY GROWING NODES
C
      IF(GROSHE.GT.0.0)THEN
      MXNOD=KVSTG(NB,NZ,NY,NX)
      MNNOD=MAX(NNOD1,MXNOD-NNOD(NZ,NY,NX)+1)
      MXNOD=MAX(MXNOD,MNNOD)
      GNOD=MXNOD-MNNOD+1
      ALLOCS=1.0/GNOD
      GRO=ALLOCS*GROSHE
      GRON=ALLOCS*GROSHN
      GROP=ALLOCS*GROSHP
      GSSL=ALLOCL*FNOD(NZ,NY,NX)*NNOD(NZ,NY,NX)
C
C     GROWTH AT EACH CURRENT NODE
C
      DO 505 KK=MNNOD,MXNOD
      K=MOD(KK,25)
      IF(K.EQ.0.AND.KK.NE.0)K=25
      WGSHE(K,NB,NZ,NY,NX)=WGSHE(K,NB,NZ,NY,NX)+GRO
      WGSHN(K,NB,NZ,NY,NX)=WGSHN(K,NB,NZ,NY,NX)+GRON
      WGSHP(K,NB,NZ,NY,NX)=WGSHP(K,NB,NZ,NY,NX)+GROP
      WSSHE(K,NB,NZ,NY,NX)=WSSHE(K,NB,NZ,NY,NX)
     2+AMIN1(GRON*CNWS(NZ,NY,NX),GROP*CPWS(NZ,NY,NX))
C
C     SPECIFIC SHEATH OR PETIOLE LENGTH FUNCTION OF CURRENT MASS
C     WITH PARAMETERS FROM 'READQ'
C
      IF(WGLF(K,NB,NZ,NY,NX).GT.0.0)THEN
      SSL=ETOL*SSL1(NZ,NY,NX)*(AMAX1(ZEROL(NZ,NY,NX) 
     4,WGSHE(K,NB,NZ,NY,NX))/(PP(NZ,NY,NX)*GSSL))**SSL2*WFNS 
      GROS=GRO/PP(NZ,NY,NX)*SSL
      HTSHE(K,NB,NZ,NY,NX)=HTSHE(K,NB,NZ,NY,NX)+GROS*ANGSH(NZ,NY,NX)
C     IF(I.EQ.120.AND.J.EQ.24)THEN
C     WRITE(*,2526)'HTSHE',I,J,NZ,NB,K,SSL,WGSHE(K,NB,NZ,NY,NX)
C    2,HTSHE(K,NB,NZ,NY,NX),PP(NZ,NY,NX),SSL1(NZ,NY,NX)
C    3,GSLA,SSL3,WFNS,GROS,GRO,ANGSH(NZ,NY,NX),ZEROL(NZ,NY,NX)
C    4,CCPOLB(NB,NZ,NY,NX),ETOL
2526  FORMAT(A8,5I4,20E12.4)
C     ENDIF
      ENDIF
505   CONTINUE
      ENDIF
C
C     DISTRIBUTE STALK GROWTH AMONG CURRENTLY GROWING NODES
C
      IF(IDAY(1,NB,NZ,NY,NX).EQ.0)THEN
      NN=0
      ELSE
      NN=1
      ENDIF
      MXNOD=KVSTG(NB,NZ,NY,NX)
      MNNOD=MAX(MIN(NN,MAX(NN,MXNOD-NNOD(NZ,NY,NX)))
     2,KVSTG(NB,NZ,NY,NX)-23)
      MXNOD=MAX(MXNOD,MNNOD)
      IF(GROSTK.GT.0.0)THEN
      GNOD=MXNOD-MNNOD+1
      ALLOCN=1.0/GNOD
      GRO=ALLOCN*GROSTK
      GRON=ALLOCN*GROSTN
      GROP=ALLOCN*GROSTP
C
C     SPECIFIC INTERNODE LENGTH FUNCTION OF CURRENT STALK MASS
C     WITH PARAMETERS FROM 'READQ'
C
      SNL=ETOL*SNL1(NZ,NY,NX)*(WTSTKB(NB,NZ,NY,NX)/PP(NZ,NY,NX))**SNL2
      GROH=GRO/PP(NZ,NY,NX)*SNL
      KX=MOD(MNNOD-1,25)
      IF(KX.EQ.0.AND.MNNOD-1.NE.0)KX=25
C
C     GROWTH AT EACH CURRENT NODE
C
      DO 510 KK=MNNOD,MXNOD
      K1=MOD(KK,25)
      IF(K1.EQ.0.AND.KK.NE.0)K1=25
      K2=MOD(KK-1,25)
      IF(K2.EQ.0.AND.KK-1.NE.0)K2=25
      WGNODE(K1,NB,NZ,NY,NX)=WGNODE(K1,NB,NZ,NY,NX)+GRO
      WGNODN(K1,NB,NZ,NY,NX)=WGNODN(K1,NB,NZ,NY,NX)+GRON
      WGNODP(K1,NB,NZ,NY,NX)=WGNODP(K1,NB,NZ,NY,NX)+GROP
      HTNODX(K1,NB,NZ,NY,NX)=HTNODX(K1,NB,NZ,NY,NX)+GROH*ANGBR(NZ,NY,NX) 
      IF(K1.NE.0)THEN
      HTNODE(K1,NB,NZ,NY,NX)=HTNODX(K1,NB,NZ,NY,NX)
     2+HTNODE(K2,NB,NZ,NY,NX)
      ELSE
      HTNODE(K1,NB,NZ,NY,NX)=HTNODX(K1,NB,NZ,NY,NX)
      ENDIF
C     IF(NZ.EQ.1)THEN
C     WRITE(*,515)'HTNODE',I,J,NZ,NB,KK,K1,K2,MNNOD,MXNOD
C    1,NNOD(NZ,NY,NX),ARLF(K1,NB,NZ,NY,NX)
C    2,HTNODE(K1,NB,NZ,NY,NX),HTNODE(K2,NB,NZ,NY,NX),SNL,GRO 
C    3,ALLOCN,WTSTKB(NB,NZ,NY,NX),WGNODE(K1,NB,NZ,NY,NX)
C    4,HTNODX(K1,NB,NZ,NY,NX),PP(NZ,NY,NX),GROSTK 
515   FORMAT(A8,10I4,20E12.4)
C     ENDIF   
510   CONTINUE
      ENDIF
C
C     RECOVERY OF REMOBILIZABLE N,P DURING REMOBILIZATION DEPENDS
C     ON SHOOT NON-STRUCTURAL C:N:P
C
      IF(IDAY(1,NB,NZ,NY,NX).NE.0
     2.AND.CCPOLB(NB,NZ,NY,NX).GT.ZERO)THEN
      CCC=AMIN1(CZPOLB(NB,NZ,NY,NX)/(CZPOLB(NB,NZ,NY,NX)
     2+CCPOLB(NB,NZ,NY,NX)/CNKI)
     3,CPPOLB(NB,NZ,NY,NX)/(CPPOLB(NB,NZ,NY,NX)
     4+CCPOLB(NB,NZ,NY,NX)/CPKI))
      CNC=CCPOLB(NB,NZ,NY,NX)/(CCPOLB(NB,NZ,NY,NX)
     2+CZPOLB(NB,NZ,NY,NX)/ZSKI)
      CPC=CCPOLB(NB,NZ,NY,NX)/(CCPOLB(NB,NZ,NY,NX)
     2+CPPOLB(NB,NZ,NY,NX)/PSKI)
      ELSE
      CCC=0.0
      CNC=0.0
      CPC=0.0
      ENDIF
      RCCC=RCCZ+CCC*RCCY
      RCCN=CNC*RCCX(IGTYP(NZ,NY,NX))
      RCCP=CPC*RCCQ(IGTYP(NZ,NY,NX))
C
C     WITHDRAW REMOBILIZABLE C,N,P FROM LOWEST NODE AFTER
C     MAXIMUM NODE NUMBER OF 25 IS REACHED
C
      IF(IFLGG(NB,NZ,NY,NX).EQ.1)THEN
      KVSTGX=KVSTG(NB,NZ,NY,NX)-24
      IF(KVSTGX.GT.0)THEN
      K=MOD(KVSTGX,25)
      IF(K.EQ.0.AND.KVSTGX.GT.0)K=25
      KX=MOD(KVSTG(NB,NZ,NY,NX),25)
      IF(KX.EQ.0.AND.KVSTG(NB,NZ,NY,NX).NE.0)KX=25
      FSNC=TFN3(NZ,NY,NX)*XRLA(NZ,NY,NX)
C
C     REMOBILIZATION OF LEAF C,N,P ALSO DEPENDS ON STRUCTURAL C:N:P
C
      IF(IFLGP(NB,NZ,NY,NX).EQ.1)THEN
      WGLFX(NB,NZ,NY,NX)=AMAX1(0.0,WGLF(K,NB,NZ,NY,NX))
      WGLFNX(NB,NZ,NY,NX)=AMAX1(0.0,WGLFN(K,NB,NZ,NY,NX))
      WGLFPX(NB,NZ,NY,NX)=AMAX1(0.0,WGLFP(K,NB,NZ,NY,NX))
      ARLFZ(NB,NZ,NY,NX)=AMAX1(0.0,ARLF(K,NB,NZ,NY,NX))
      IF(WGLFX(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      RCCLX(NB,NZ,NY,NX)=RCCC*WGLFX(NB,NZ,NY,NX)
      RCZLX(NB,NZ,NY,NX)=WGLFNX(NB,NZ,NY,NX)*(RCCN+(1.0-RCCN)*RCCC)
      RCPLX(NB,NZ,NY,NX)=WGLFPX(NB,NZ,NY,NX)*(RCCP+(1.0-RCCP)*RCCC)
      ELSE
      RCCLX(NB,NZ,NY,NX)=0.0
      RCZLX(NB,NZ,NY,NX)=0.0
      RCPLX(NB,NZ,NY,NX)=0.0
      ENDIF
      ENDIF
C
C     FRACTION OF CURRENT LEAF TO BE REMOBILIZED
C
      IF(FSNC*WGLFX(NB,NZ,NY,NX).GT.WGLF(K,NB,NZ,NY,NX)
     2.AND.WGLFX(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FSNCL=AMAX1(0.0,WGLF(K,NB,NZ,NY,NX)/WGLFX(NB,NZ,NY,NX))
      ELSE
      FSNCL=FSNC
      ENDIF
C
C     NON-REMOBILIZABLE C,N,P BECOMES LITTERFALL ALLOCATED
C     TO FRACTIONS SET IN 'STARTQ'
C
      DO 6300 M=1,4
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)+CFOPC(5,M,NZ,NY,NX)
     2*FSNCL*(WGLFX(NB,NZ,NY,NX)-RCCLX(NB,NZ,NY,NX))*FWODB(0)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)+CFOPN(5,M,NZ,NY,NX)
     2*FSNCL*(WGLFNX(NB,NZ,NY,NX)-RCZLX(NB,NZ,NY,NX))*FWODLN(0)
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)+CFOPP(5,M,NZ,NY,NX)
     2*FSNCL*(WGLFPX(NB,NZ,NY,NX)-RCPLX(NB,NZ,NY,NX))*FWODLP(0)
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)+CFOPC(1,M,NZ,NY,NX)
     2*FSNCL*(WGLFX(NB,NZ,NY,NX)-RCCLX(NB,NZ,NY,NX))*FWODB(1)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)+CFOPN(1,M,NZ,NY,NX)
     2*FSNCL*(WGLFNX(NB,NZ,NY,NX)-RCZLX(NB,NZ,NY,NX))*FWODLN(1)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)+CFOPP(1,M,NZ,NY,NX)
     2*FSNCL*(WGLFPX(NB,NZ,NY,NX)-RCPLX(NB,NZ,NY,NX))*FWODLP(1)
6300  CONTINUE
C
C     UPDATE STATE VARIABLES FOR REMOBILIZATION AND LITTERFALL
C
      ARLFB(NB,NZ,NY,NX)=ARLFB(NB,NZ,NY,NX)
     2-FSNCL*ARLFZ(NB,NZ,NY,NX)
      WTLFB(NB,NZ,NY,NX)=WTLFB(NB,NZ,NY,NX)
     2-FSNCL*WGLFX(NB,NZ,NY,NX)
      WTLFBN(NB,NZ,NY,NX)=WTLFBN(NB,NZ,NY,NX)
     2-FSNCL*WGLFNX(NB,NZ,NY,NX)
      WTLFBP(NB,NZ,NY,NX)=WTLFBP(NB,NZ,NY,NX)
     2-FSNCL*WGLFPX(NB,NZ,NY,NX)
      ARLF(K,NB,NZ,NY,NX)=ARLF(K,NB,NZ,NY,NX)
     2-FSNCL*ARLFZ(NB,NZ,NY,NX)
      WGLF(K,NB,NZ,NY,NX)=WGLF(K,NB,NZ,NY,NX)
     2-FSNCL*WGLFX(NB,NZ,NY,NX)
      WGLFN(K,NB,NZ,NY,NX)=WGLFN(K,NB,NZ,NY,NX)
     2-FSNCL*WGLFNX(NB,NZ,NY,NX)
      WGLFP(K,NB,NZ,NY,NX)=WGLFP(K,NB,NZ,NY,NX)
     2-FSNCL*WGLFPX(NB,NZ,NY,NX)
      WSLF(K,NB,NZ,NY,NX)=AMAX1(0.0,WSLF(K,NB,NZ,NY,NX)
     2-FSNCL*AMAX1(WGLFNX(NB,NZ,NY,NX)*CNWS(NZ,NY,NX)
     3,WGLFPX(NB,NZ,NY,NX)*CPWS(NZ,NY,NX)))
      CPOOL(NB,NZ,NY,NX)=CPOOL(NB,NZ,NY,NX)+FSNCL*RCCLX(NB,NZ,NY,NX) 
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)+FSNCL*RCZLX(NB,NZ,NY,NX)
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)+FSNCL*RCPLX(NB,NZ,NY,NX)
C
C     REMOBILIZATION OF SHEATHS OR PETIOLE C,N,P ALSO DEPENDS ON
C     STRUCTURAL C:N:P
C
      IF(IFLGP(NB,NZ,NY,NX).EQ.1)THEN
      WGSHEX(NB,NZ,NY,NX)=AMAX1(0.0,WGSHE(K,NB,NZ,NY,NX))
      WGSHNX(NB,NZ,NY,NX)=AMAX1(0.0,WGSHN(K,NB,NZ,NY,NX))
      WGSHPX(NB,NZ,NY,NX)=AMAX1(0.0,WGSHP(K,NB,NZ,NY,NX))
      HTSHEX(NB,NZ,NY,NX)=AMAX1(0.0,HTSHE(K,NB,NZ,NY,NX))
      IF(WGSHEX(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      RCCSX(NB,NZ,NY,NX)=RCCC*WGSHEX(NB,NZ,NY,NX)
      RCZSX(NB,NZ,NY,NX)=WGSHNX(NB,NZ,NY,NX)
     2*(RCCN+(1.0-RCCN)*RCCSX(NB,NZ,NY,NX)/WGSHEX(NB,NZ,NY,NX))
      RCPSX(NB,NZ,NY,NX)=WGSHPX(NB,NZ,NY,NX)
     2*(RCCP+(1.0-RCCP)*RCCSX(NB,NZ,NY,NX)/WGSHEX(NB,NZ,NY,NX))
      ELSE
      RCCSX(NB,NZ,NY,NX)=0.0
      RCZSX(NB,NZ,NY,NX)=0.0
      RCPSX(NB,NZ,NY,NX)=0.0
      ENDIF
      WTSTXB(NB,NZ,NY,NX)=WTSTXB(NB,NZ,NY,NX)+WGNODE(K,NB,NZ,NY,NX)  
      WTSTXN(NB,NZ,NY,NX)=WTSTXN(NB,NZ,NY,NX)+WGNODN(K,NB,NZ,NY,NX)
      WTSTXP(NB,NZ,NY,NX)=WTSTXP(NB,NZ,NY,NX)+WGNODP(K,NB,NZ,NY,NX)
C     IF(NZ.EQ.2)THEN
C     WRITE(*,2358)'WTSTXB',I,J,NZ,NB,K,WTSTXB(NB,NZ,NY,NX)
C    2,WTSTKB(NB,NZ,NY,NX),WGNODE(K,NB,NZ,NY,NX)
2358  FORMAT(A8,5I4,12E12.4)
C     ENDIF
      WGNODE(K,NB,NZ,NY,NX)=0.0
      WGNODN(K,NB,NZ,NY,NX)=0.0
      WGNODP(K,NB,NZ,NY,NX)=0.0
      HTNODX(K,NB,NZ,NY,NX)=0.0
      ENDIF
C
C     FRACTION OF CURRENT SHEATH TO BE REMOBILIZED
C
      IF(FSNC*WGSHEX(NB,NZ,NY,NX).GT.WGSHE(K,NB,NZ,NY,NX)
     2.AND.WGSHEX(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FSNCS=AMAX1(0.0,WGSHE(K,NB,NZ,NY,NX)/WGSHEX(NB,NZ,NY,NX))
      ELSE
      FSNCS=FSNC
      ENDIF
C
C     NON-REMOBILIZABLE C,N,P BECOMES LITTERFALL ALLOCATED
C     TO FRACTIONS SET IN 'STARTQ'
C
      DO 6305 M=1,4
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)+CFOPC(5,M,NZ,NY,NX)
     2*FSNCS*(WGSHEX(NB,NZ,NY,NX)-RCCSX(NB,NZ,NY,NX))*FWODB(0)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)+CFOPN(5,M,NZ,NY,NX)
     2*FSNCS*(WGSHNX(NB,NZ,NY,NX)-RCZSX(NB,NZ,NY,NX))*FWODSN(0)
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)+CFOPP(5,M,NZ,NY,NX)
     2*FSNCS*(WGSHPX(NB,NZ,NY,NX)-RCPSX(NB,NZ,NY,NX))*FWODSP(0)
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)+CFOPC(2,M,NZ,NY,NX)
     2*FSNCS*(WGSHEX(NB,NZ,NY,NX)-RCCSX(NB,NZ,NY,NX))*FWODB(1)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)+CFOPN(2,M,NZ,NY,NX)
     2*FSNCS*(WGSHNX(NB,NZ,NY,NX)-RCZSX(NB,NZ,NY,NX))*FWODSN(1)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)+CFOPP(2,M,NZ,NY,NX)
     2*FSNCS*(WGSHPX(NB,NZ,NY,NX)-RCPSX(NB,NZ,NY,NX))*FWODSP(1)
6305  CONTINUE
C
C     UPDATE STATE VARIABLES FOR REMOBILIZATION AND LITTERFALL
C
      WTSHEB(NB,NZ,NY,NX)=WTSHEB(NB,NZ,NY,NX)
     2-FSNCS*WGSHEX(NB,NZ,NY,NX)
      WTSHBN(NB,NZ,NY,NX)=WTSHBN(NB,NZ,NY,NX)
     2-FSNCS*WGSHNX(NB,NZ,NY,NX)
      WTSHBP(NB,NZ,NY,NX)=WTSHBP(NB,NZ,NY,NX)
     2-FSNCS*WGSHPX(NB,NZ,NY,NX)
      HTSHE(K,NB,NZ,NY,NX)=HTSHE(K,NB,NZ,NY,NX)
     2-FSNCS*HTSHEX(NB,NZ,NY,NX) 
      WGSHE(K,NB,NZ,NY,NX)=WGSHE(K,NB,NZ,NY,NX)
     2-FSNCS*WGSHEX(NB,NZ,NY,NX)
      WGSHN(K,NB,NZ,NY,NX)=WGSHN(K,NB,NZ,NY,NX)
     2-FSNCS*WGSHNX(NB,NZ,NY,NX)
      WGSHP(K,NB,NZ,NY,NX)=WGSHP(K,NB,NZ,NY,NX)
     2-FSNCS*WGSHPX(NB,NZ,NY,NX)
      WSSHE(K,NB,NZ,NY,NX)=AMAX1(0.0,WSSHE(K,NB,NZ,NY,NX)
     2-FSNCS*AMAX1(WGSHNX(NB,NZ,NY,NX)*CNWS(NZ,NY,NX)
     3,WGSHPX(NB,NZ,NY,NX)*CPWS(NZ,NY,NX)))
      CPOOL(NB,NZ,NY,NX)=CPOOL(NB,NZ,NY,NX)+FSNCS*RCCSX(NB,NZ,NY,NX)
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)+FSNCS*RCZSX(NB,NZ,NY,NX)
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)+FSNCS*RCPSX(NB,NZ,NY,NX)
      ENDIF
      ENDIF
C
C     REMOBILIZATION OF STALK RESERVE C,N,P IF GROWTH RESPIRATION < 0  
C
      IF(IFLGZ.EQ.0)THEN
      IF(SNCR.GT.0.0.AND.WTRSVB(NB,NZ,NY,NX).GT.0.0)THEN
      RCO2V=AMIN1(SNCR,VMXC*WTRSVB(NB,NZ,NY,NX)*TFN3(NZ,NY,NX))
      WTRSVB(NB,NZ,NY,NX)=WTRSVB(NB,NZ,NY,NX)-RCO2V
      SNCR=SNCR-RCO2V
      ENDIF
      ENDIF
C
C     TOTAL REMOBILIZATION = GROWTH RESPIRATION < 0 + DECIDUOUS LEAF
C     FALL DURING AUTUMN + REMOBILZATION DURING GRAIN FILL IN ANNUALS
C
      IF(IFLGZ.EQ.1.AND.IFLGY.EQ.1)THEN
      SNCZ=FXFR(IBTYP(NZ,NY,NX),IWTYP(NZ,NY,NX))
     2*WTLSB(NB,NZ,NY,NX)*AMIN1(1.0,FLGZ(NB,NZ,NY,NX)/FLGZX)
      ELSE
      SNCZ=0.0
      ENDIF
      SNCX=SNCR+SNCZ
      IF(SNCX.GT.ZEROP(NZ,NY,NX))THEN
      SNCF=SNCZ/SNCX
      KSNC=INT(0.5*(KVSTG(NB,NZ,NY,NX)-KVSTGN(NB,NZ,NY,NX)))+1
      XKSNC=KSNC
      KN=MAX(0,KVSTGN(NB,NZ,NY,NX)-1)
C     IF(NZ.EQ.2.OR.NZ.EQ.3)THEN
C     WRITE(*,1266)'SNCX0',I,J,NX,NY,NZ,NB,SNCY,SNCR,SNCX,SNCF 
C    2,CPOOL(NB,NZ,NY,NX),WTLSB(NB,NZ,NY,NX),RCCC
1266  FORMAT(A8,6I4,12E16.8)
C     ENDIF
C
C     TRANSFER NON-STRUCTURAL C,N,P FROM BRANCHES TO MAIN STEM
C     IF MAIN STEM POOLS ARE DEPLETED
C
      IF(IBTYP(NZ,NY,NX).NE.0.AND.IGTYP(NZ,NY,NX).GT.1
     2.AND.NB.EQ.NB1(NZ,NY,NX).AND.SNCF.EQ.0)THEN
      NBY=0
      DO 584 NBL=1,NBR(NZ,NY,NX)
      NBZ(NBL)=0
584   CONTINUE
      DO 586 NBL=1,NBR(NZ,NY,NX)
      NBX=KVSTG(NB,NZ,NY,NX)
      DO 585 NBK=1,NBR(NZ,NY,NX)
      IF(IDTHB(NBK,NZ,NY,NX).EQ.0.AND.NBK.NE.NB1(NZ,NY,NX)
     2.AND.NBTB(NBK,NZ,NY,NX).LT.NBX
     3.AND.NBTB(NBK,NZ,NY,NX).GT.NBY)THEN
      NBZ(NBL)=NBK
      NBX=NBTB(NBK,NZ,NY,NX)
      ENDIF
585   CONTINUE
      IF(NBZ(NBL).NE.0)THEN
      NBY=NBTB(NBZ(NBL),NZ,NY,NX)
      ENDIF
586   CONTINUE
      DO 580 NBL=1,NBR(NZ,NY,NX)
      IF(NBZ(NBL).NE.0)THEN
      IF(NBTB(NBZ(NBL),NZ,NY,NX).LT.KK)THEN
      IF(CPOOL(NBZ(NBL),NZ,NY,NX).GT.0)THEN
      XFRC=1.0E-02*AMIN1(SNCX,CPOOL(NBZ(NBL),NZ,NY,NX))
      XFRN=XFRC*ZPOOL(NBZ(NBL),NZ,NY,NX)/CPOOL(NBZ(NBL),NZ,NY,NX)
      XFRP=XFRC*PPOOL(NBZ(NBL),NZ,NY,NX)/CPOOL(NBZ(NBL),NZ,NY,NX)
      ELSE
      XFRC=0.0
      XFRN=1.0E-02*ZPOOL(NBZ(NBL),NZ,NY,NX)
      XFRP=1.0E-02*PPOOL(NBZ(NBL),NZ,NY,NX)
      ENDIF
      CPOOL(NBZ(NBL),NZ,NY,NX)=CPOOL(NBZ(NBL),NZ,NY,NX)-XFRC
      ZPOOL(NBZ(NBL),NZ,NY,NX)=ZPOOL(NBZ(NBL),NZ,NY,NX)-XFRN
      PPOOL(NBZ(NBL),NZ,NY,NX)=PPOOL(NBZ(NBL),NZ,NY,NX)-XFRP
      CPOOL(NB1(NZ,NY,NX),NZ,NY,NX)=CPOOL(NB1(NZ,NY,NX),NZ,NY,NX)
     2+XFRC*SNCF
      ZPOOL(NB1(NZ,NY,NX),NZ,NY,NX)=ZPOOL(NB1(NZ,NY,NX),NZ,NY,NX)
     2+XFRN
      PPOOL(NB1(NZ,NY,NX),NZ,NY,NX)=PPOOL(NB1(NZ,NY,NX),NZ,NY,NX)
     2+XFRP
      SNCX=SNCX-XFRC
      IF(SNCX.LE.0.0)GO TO 595
      ENDIF
      ENDIF
580   CONTINUE
      ENDIF
C
C     REMOBILIZATION AND LITTERFALL WHEN GROWTH RESPIRATION < 0
C     STARTING FROM LOWEST LEAFED NODE AND PROCEEDING UPWARDS
C
C     IF(NZ.EQ.2.OR.NZ.EQ.3)THEN
C     WRITE(*,1266)'SNCX1',I,J,NX,NY,NZ,NB,SNCY,SNCR,SNCX,SNCF 
C    2,CPOOL(NB,NZ,NY,NX),WTLSB(NB,NZ,NY,NX),RCCC
C     ENDIF
      DO 575 N=1,KSNC
      SNCT=SNCX/XKSNC
      DO 650 KK=KN,KVSTG(NB,NZ,NY,NX)
      SNCLF=0.0
      SNCSH=0.0
      K=MOD(KK,25)
      IF(K.EQ.0.AND.KK.NE.0)K=25
C
C     REMOBILIZATION OF LEAF C,N,P DEPENDS ON NON-STRUCTURAL C:N:P
C
      IF(WGLF(K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FNCLF=WGLF(K,NB,NZ,NY,NX)/(WGLF(K,NB,NZ,NY,NX)
     2+WGSHE(K,NB,NZ,NY,NX))
      SNCLF=FNCLF*SNCT
      SNCSH=SNCT-SNCLF
      RCCL=RCCC*WGLF(K,NB,NZ,NY,NX)
      RCZL=WGLFN(K,NB,NZ,NY,NX)*(RCCN+(1.0-RCCN)*RCCC)
      RCPL=WGLFP(K,NB,NZ,NY,NX)*(RCCP+(1.0-RCCP)*RCCC)
C
C     FRACTION OF CURRENT LEAF TO BE REMOBILIZED
C
      IF(RCCL.GT.ZEROP(NZ,NY,NX))THEN
      FSNCL=AMAX1(0.0,AMIN1(1.0,SNCLF/RCCL))
      ELSE
      FSNCL=1.0
      ENDIF
      FSNAL=FSNCL
C
C     NON-REMOBILIZABLE C,N,P BECOMES LITTERFALL ALLOCATED
C     TO FRACTIONS SET IN 'STARTQ'
C
C     IF(NZ.EQ.1)THEN
C     WRITE(*,4898)'SNCT1',I,J,NX,NY,NZ,NB,K,N
C    2,KN,KVSTG(NB,NZ,NY,NX),SNCLF,SNCT
C     2,FSNCL,RCCL,WTLFB(NB,NZ,NY,NX),ARLFB(NB,NZ,NY,NX)
C    2,WGLFN(K,NB,NZ,NY,NX),WGLFLN(1,K,NB,NZ,NY,NX)
C    3,ARLF(K,NB,NZ,NY,NX)
4898  FORMAT(A8,10I4,12E16.8)
C     ENDIF
      DO 6310 M=1,4
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)+CFOPC(5,M,NZ,NY,NX)
     2*FSNCL*(WGLF(K,NB,NZ,NY,NX)-RCCL)*FWODB(0)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)+CFOPN(5,M,NZ,NY,NX)
     2*FSNCL*(WGLFN(K,NB,NZ,NY,NX)-RCZL)*FWODLN(0)
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)+CFOPP(5,M,NZ,NY,NX)
     2*FSNCL*(WGLFP(K,NB,NZ,NY,NX)-RCPL)*FWODLP(0)
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)+CFOPC(1,M,NZ,NY,NX)
     2*FSNCL*(WGLF(K,NB,NZ,NY,NX)-RCCL)*FWODB(1)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)+CFOPN(1,M,NZ,NY,NX)
     2*FSNCL*(WGLFN(K,NB,NZ,NY,NX)-RCZL)*FWODLN(1)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)+CFOPP(1,M,NZ,NY,NX)
     2*FSNCL*(WGLFP(K,NB,NZ,NY,NX)-RCPL)*FWODLP(1)
6310  CONTINUE
      IF(K.NE.0)THEN
      CSNC(2,1,0,NZ,NY,NX)=CSNC(2,1,0,NZ,NY,NX)
     2+FSNCL*(CPOOL3(K,NB,NZ,NY,NX)+CPOOL4(K,NB,NZ,NY,NX))
      CPOOL3(K,NB,NZ,NY,NX)=CPOOL3(K,NB,NZ,NY,NX)
     2-FSNCL*CPOOL3(K,NB,NZ,NY,NX)
      CPOOL4(K,NB,NZ,NY,NX)=CPOOL4(K,NB,NZ,NY,NX)
     2-FSNCL*CPOOL4(K,NB,NZ,NY,NX)
      ENDIF
C
C     UPDATE STATE VARIABLES FOR REMOBILIZATION AND LITTERFALL
C
      ARLFB(NB,NZ,NY,NX)=AMAX1(0.0,ARLFB(NB,NZ,NY,NX)
     2-FSNAL*ARLF(K,NB,NZ,NY,NX))
      WTLFB(NB,NZ,NY,NX)=AMAX1(0.0,WTLFB(NB,NZ,NY,NX)
     2-FSNCL*WGLF(K,NB,NZ,NY,NX))
      WTLFBN(NB,NZ,NY,NX)=AMAX1(0.0,WTLFBN(NB,NZ,NY,NX)
     2-FSNCL*WGLFN(K,NB,NZ,NY,NX))
      WTLFBP(NB,NZ,NY,NX)=AMAX1(0.0,WTLFBP(NB,NZ,NY,NX)
     2-FSNCL*WGLFP(K,NB,NZ,NY,NX))
      ARLF(K,NB,NZ,NY,NX)=ARLF(K,NB,NZ,NY,NX)
     2-FSNAL*ARLF(K,NB,NZ,NY,NX)
      WGLF(K,NB,NZ,NY,NX)=WGLF(K,NB,NZ,NY,NX)
     2-FSNCL*WGLF(K,NB,NZ,NY,NX)
      WGLFN(K,NB,NZ,NY,NX)=WGLFN(K,NB,NZ,NY,NX)
     2-FSNCL*WGLFN(K,NB,NZ,NY,NX)
      WGLFP(K,NB,NZ,NY,NX)=WGLFP(K,NB,NZ,NY,NX)
     2-FSNCL*WGLFP(K,NB,NZ,NY,NX)
      WSLF(K,NB,NZ,NY,NX)=AMAX1(0.0,WSLF(K,NB,NZ,NY,NX)
     2-FSNCL*AMAX1(WGLFN(K,NB,NZ,NY,NX)*CNWS(NZ,NY,NX)
     3,WGLFP(K,NB,NZ,NY,NX)*CPWS(NZ,NY,NX)))
C
C     FRACTION OF C REMOBILIZED FOR GROWTH RESPIRATION < 0 IS
C     RESPIRED AND NOT TRANSFERRED TO NON-STRUCTURAL POOLS
C
      CPOOL(NB,NZ,NY,NX)=CPOOL(NB,NZ,NY,NX)+FSNCL*RCCL*SNCF
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)+FSNCL*RCZL
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)+FSNCL*RCPL
      SNCLF=SNCLF-FSNCL*RCCL
      SNCT=SNCT-FSNCL*RCCL
      IF(WTLFB(NB,NZ,NY,NX).LT.ZEROL(NZ,NY,NX))THEN 
      WTLFB(NB,NZ,NY,NX)=0.0
      ARLFB(NB,NZ,NY,NX)=0.0
      ENDIF
C
C     EXIT LOOP IF REMOBILIZATION REQUIREMENT HAS BEEN MET
C
      IF(SNCLF.LE.ZEROP(NZ,NY,NX))GO TO 564
C
C     OTHERWISE REMAINING C,N,P IN LEAF GOES TO LITTERFALL
C
      ELSE
C     IF(NZ.EQ.1)THEN
C     WRITE(*,4899)'SNCT2',I,J,NX,NY,NZ,NB,K,N,SNCLF,SNCT
C    2,FSNCL,RCCL,WTLFB(NB,NZ,NY,NX),ARLFB(NB,NZ,NY,NX)
C    2,WGLFN(K,NB,NZ,NY,NX),WGLFLN(1,K,NB,NZ,NY,NX)
C    3,ARLF(K,NB,NZ,NY,NX)
4899  FORMAT(A8,8I4,12E16.8)
C     ENDIF
      DO 6315 M=1,4
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)+CFOPC(5,M,NZ,NY,NX)
     2*WGLF(K,NB,NZ,NY,NX)*FWODB(0)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)+CFOPN(5,M,NZ,NY,NX)
     2*WGLFN(K,NB,NZ,NY,NX)*FWODLN(0)
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)+CFOPP(5,M,NZ,NY,NX)
     2*WGLFP(K,NB,NZ,NY,NX)*FWODLP(0)
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)+CFOPC(1,M,NZ,NY,NX)
     2*WGLF(K,NB,NZ,NY,NX)*FWODB(1)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)+CFOPN(1,M,NZ,NY,NX)
     2*WGLFN(K,NB,NZ,NY,NX)*FWODLN(1)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)+CFOPP(1,M,NZ,NY,NX)
     2*WGLFP(K,NB,NZ,NY,NX)*FWODLP(1)
6315  CONTINUE
      IF(K.NE.0)THEN
      CSNC(2,1,0,NZ,NY,NX)=CSNC(2,1,0,NZ,NY,NX)
     2+CPOOL3(K,NB,NZ,NY,NX)+CPOOL4(K,NB,NZ,NY,NX)
      CPOOL3(K,NB,NZ,NY,NX)=0.0
      CPOOL4(K,NB,NZ,NY,NX)=0.0
      ENDIF
      ARLFB(NB,NZ,NY,NX)=AMAX1(0.0,ARLFB(NB,NZ,NY,NX)
     2-ARLF(K,NB,NZ,NY,NX))
      WTLFB(NB,NZ,NY,NX)=AMAX1(0.0,WTLFB(NB,NZ,NY,NX)
     2-WGLF(K,NB,NZ,NY,NX))
      WTLFBN(NB,NZ,NY,NX)=AMAX1(0.0,WTLFBN(NB,NZ,NY,NX)
     2-WGLFN(K,NB,NZ,NY,NX))
      WTLFBP(NB,NZ,NY,NX)=AMAX1(0.0,WTLFBP(NB,NZ,NY,NX)
     2-WGLFP(K,NB,NZ,NY,NX))
      ARLF(K,NB,NZ,NY,NX)=0.0
      WGLF(K,NB,NZ,NY,NX)=0.0
      WGLFN(K,NB,NZ,NY,NX)=0.0
      WGLFP(K,NB,NZ,NY,NX)=0.0
      WSLF(K,NB,NZ,NY,NX)=0.0
      IF(WTLFB(NB,NZ,NY,NX).LT.ZEROL(NZ,NY,NX))THEN 
      WTLFB(NB,NZ,NY,NX)=0.0
      ARLFB(NB,NZ,NY,NX)=0.0
      ENDIF
      ENDIF
C
C     REMOBILIZATION OF SHEATHS OR PETIOLE C,N,P DEPENDS ON
C     NON-STRUCTURAL C:N:P
C
564   CONTINUE
      IF(WGSHE(K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      RCCS=RCCC*WGSHE(K,NB,NZ,NY,NX)
      RCZS=WGSHN(K,NB,NZ,NY,NX)*(RCCN+(1.0-RCCN)*RCCC)
      RCPS=WGSHP(K,NB,NZ,NY,NX)*(RCCP+(1.0-RCCP)*RCCC)
C
C     FRACTION OF REMOBILIZATION THAT CAN BE MET FROM CURRENT SHEATH
C     OR PETIOLE
C
      IF(RCCS.GT.ZEROP(NZ,NY,NX))THEN
      FSNCS=AMAX1(0.0,AMIN1(1.0,SNCSH/RCCS))
      ELSE
      FSNCS=1.0
      ENDIF
      FSNAS=1.0*FSNCS
C
C     NON-REMOBILIZABLE C,N,P BECOMES LITTERFALL ALLOCATED
C     TO FRACTIONS SET IN 'STARTQ'
C
      DO 6320 M=1,4
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)+CFOPC(5,M,NZ,NY,NX)
     2*FSNCS*(WGSHE(K,NB,NZ,NY,NX)-RCCS)*FWODB(0)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)+CFOPN(5,M,NZ,NY,NX)
     2*FSNCS*(WGSHN(K,NB,NZ,NY,NX)-RCZS)*FWODSN(0)
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)+CFOPP(5,M,NZ,NY,NX)
     2*FSNCS*(WGSHP(K,NB,NZ,NY,NX)-RCPS)*FWODSP(0)
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)+CFOPC(2,M,NZ,NY,NX)
     2*FSNCS*(WGSHE(K,NB,NZ,NY,NX)-RCCS)*FWODB(1)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)+CFOPN(2,M,NZ,NY,NX)
     2*FSNCS*(WGSHN(K,NB,NZ,NY,NX)-RCZS)*FWODSN(1)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)+CFOPP(2,M,NZ,NY,NX)
     2*FSNCS*(WGSHP(K,NB,NZ,NY,NX)-RCPS)*FWODSP(1)
6320  CONTINUE
C
C     UPDATE STATE VARIABLES FOR REMOBILIZATION AND LITTERFALL
C
      WTSHEB(NB,NZ,NY,NX)=AMAX1(0.0,WTSHEB(NB,NZ,NY,NX)
     2-FSNCS*WGSHE(K,NB,NZ,NY,NX))
      WTSHBN(NB,NZ,NY,NX)=AMAX1(0.0,WTSHBN(NB,NZ,NY,NX)
     2-FSNCS*WGSHN(K,NB,NZ,NY,NX))
      WTSHBP(NB,NZ,NY,NX)=AMAX1(0.0,WTSHBP(NB,NZ,NY,NX)
     2-FSNCS*WGSHP(K,NB,NZ,NY,NX))
      HTSHE(K,NB,NZ,NY,NX)=HTSHE(K,NB,NZ,NY,NX)
     2-FSNAS*HTSHE(K,NB,NZ,NY,NX)
      WGSHE(K,NB,NZ,NY,NX)=WGSHE(K,NB,NZ,NY,NX)
     2-FSNCS*WGSHE(K,NB,NZ,NY,NX)
      WGSHN(K,NB,NZ,NY,NX)=WGSHN(K,NB,NZ,NY,NX)
     2-FSNCS*WGSHN(K,NB,NZ,NY,NX)
      WGSHP(K,NB,NZ,NY,NX)=WGSHP(K,NB,NZ,NY,NX)
     2-FSNCS*WGSHP(K,NB,NZ,NY,NX)
      WSSHE(K,NB,NZ,NY,NX)=AMAX1(0.0,WSSHE(K,NB,NZ,NY,NX)
     2-FSNCS*AMAX1(WGSHN(K,NB,NZ,NY,NX)*CNWS(NZ,NY,NX)
     3,WGSHP(K,NB,NZ,NY,NX)*CPWS(NZ,NY,NX)))
C
C     FRACTION OF C REMOBILIZED FOR GROWTH RESPIRATION < 0 IS
C     RESPIRED AND NOT TRANSFERRED TO NON-STRUCTURAL POOLS
C
      CPOOL(NB,NZ,NY,NX)=CPOOL(NB,NZ,NY,NX)+FSNCS*RCCS*SNCF
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)+FSNCS*RCZS
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)+FSNCS*RCPS
      SNCSH=SNCSH-FSNCS*RCCS
      SNCT=SNCT-FSNCS*RCCS
      IF(WTSHEB(NB,NZ,NY,NX).LT.ZEROL(NZ,NY,NX))THEN 
      WTSHEB(NB,NZ,NY,NX)=0.0
      ENDIF
C
C     EXIT LOOP IF REMOBILIZATION REQUIREMENT HAS BEEN MET
C
      IF(SNCSH.LE.ZEROP(NZ,NY,NX))GO TO 565
C
C     OTHERWISE REMAINING C,N,P IN SHEATH OR PETIOLE GOES TO LITTERFALL
C
      ELSE
      DO 6325 M=1,4
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)+CFOPC(5,M,NZ,NY,NX)
     2*WGSHE(K,NB,NZ,NY,NX)*FWODB(0)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)+CFOPN(5,M,NZ,NY,NX)
     2*WGSHN(K,NB,NZ,NY,NX)*FWODSN(0)
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)+CFOPP(5,M,NZ,NY,NX)
     2*WGSHP(K,NB,NZ,NY,NX)*FWODSP(0)
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)+CFOPC(2,M,NZ,NY,NX)
     2*WGSHE(K,NB,NZ,NY,NX)*FWODB(1)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)+CFOPN(2,M,NZ,NY,NX)
     2*WGSHN(K,NB,NZ,NY,NX)*FWODSN(1)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)+CFOPP(2,M,NZ,NY,NX)
     2*WGSHP(K,NB,NZ,NY,NX)*FWODSP(1)
6325  CONTINUE
      WTSHEB(NB,NZ,NY,NX)=AMAX1(0.0,WTSHEB(NB,NZ,NY,NX)
     2-WGSHE(K,NB,NZ,NY,NX))
      WTSHBN(NB,NZ,NY,NX)=AMAX1(0.0,WTSHBN(NB,NZ,NY,NX)
     2-WGSHN(K,NB,NZ,NY,NX))
      WTSHBP(NB,NZ,NY,NX)=AMAX1(0.0,WTSHBP(NB,NZ,NY,NX)
     2-WGSHP(K,NB,NZ,NY,NX))
      HTSHE(K,NB,NZ,NY,NX)=0.0
      WGSHE(K,NB,NZ,NY,NX)=0.0
      WGSHN(K,NB,NZ,NY,NX)=0.0
      WGSHP(K,NB,NZ,NY,NX)=0.0
      WSSHE(K,NB,NZ,NY,NX)=0.0
      IF(WTSHEB(NB,NZ,NY,NX).LT.ZEROL(NZ,NY,NX))THEN 
      WTSHEB(NB,NZ,NY,NX)=0.0
      ENDIF
      ENDIF
650   CONTINUE
      KN=KN+1
      SNCR=SNCT*(1.0-SNCF)
C
C     REMOBILIZATION OF RESERVE C
C
      IF(WTRSVB(NB,NZ,NY,NX).GT.SNCR)THEN
      WTRSVB(NB,NZ,NY,NX)=WTRSVB(NB,NZ,NY,NX)-SNCR
      SNCR=0.0
      GO TO 565
      ENDIF
C
C     REMOBILIZATION OF STALK C,N,P 
C
      SNCZ=FXFS*SNCR
      SNCT=SNCR+SNCZ
      IF(SNCT.GT.ZEROP(NZ,NY,NX)
     2.AND.WTSTKB(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      SNCF=SNCZ/SNCT
      FRCC=WVSTKB(NB,NZ,NY,NX)/WTSTKB(NB,NZ,NY,NX)    
      RCSC=RCCC*FRCC 
      RCSN=RCCN*FRCC 
      RCSP=RCCP*FRCC 
      MXNOD=KVSTG(NB,NZ,NY,NX)
      MNNOD=MAX(MIN(0,MAX(0,MXNOD-NNOD(NZ,NY,NX)))
     2,KVSTG(NB,NZ,NY,NX)-23)
      MXNOD=MAX(MXNOD,MNNOD)
      DO 1650 KK=MXNOD,MNNOD,-1
      K=MOD(KK,25)
      IF(K.EQ.0.AND.KK.NE.0)K=25
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,2356)'WGNODE1',I,J,NZ,NB,K,KK,MXNOD,MNNOD
C    2,KSNC,RCCC,FRCC,RCSC,SNCT,WGNODE(K,NB,NZ,NY,NX)
C    3,HTNODX(K,NB,NZ,NY,NX),WTSTKB(NB,NZ,NY,NX)
C    4,CPOOL(NB,NZ,NY,NX)
C     ENDIF
C
C     REMOBILIZATION OF STALK C,N,P DEPENDS ON NON-STRUCTURAL C:N:P
C
      IF(WGNODE(K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      RCCK=RCSC*WGNODE(K,NB,NZ,NY,NX)
      RCZK=WGNODN(K,NB,NZ,NY,NX)*(RCSN+(1.0-RCSN)*RCSC)
      RCPK=WGNODP(K,NB,NZ,NY,NX)*(RCSP+(1.0-RCSP)*RCSC)
C
C     FRACTION OF CURRENT NODE TO BE REMOBILIZED
C
      IF(RCCK.GT.ZEROP(NZ,NY,NX))THEN
      FSNCK=AMAX1(0.0,AMIN1(1.0,SNCT/RCCK))
      ELSE
      FSNCK=1.0
      ENDIF
C
C     NON-REMOBILIZABLE C,N,P BECOMES LITTERFALL ALLOCATED
C     TO FRACTIONS SET IN 'STARTQ'
C
      DO 7310 M=1,4
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)+CFOPC(3,M,NZ,NY,NX)
     2*FSNCK*(WGNODE(K,NB,NZ,NY,NX)-RCCK)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)+CFOPN(3,M,NZ,NY,NX)
     2*FSNCK*(WGNODN(K,NB,NZ,NY,NX)-RCZK)
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)+CFOPP(3,M,NZ,NY,NX)
     2*FSNCK*(WGNODP(K,NB,NZ,NY,NX)-RCPK)
7310  CONTINUE
C
C     UPDATE STATE VARIABLES FOR REMOBILIZATION AND LITTERFALL
C
      WTSTKB(NB,NZ,NY,NX)=AMAX1(0.0,WTSTKB(NB,NZ,NY,NX)
     2-FSNCK*WGNODE(K,NB,NZ,NY,NX))
      WTSTBN(NB,NZ,NY,NX)=AMAX1(0.0,WTSTBN(NB,NZ,NY,NX)
     2-FSNCK*WGNODN(K,NB,NZ,NY,NX))
      WTSTBP(NB,NZ,NY,NX)=AMAX1(0.0,WTSTBP(NB,NZ,NY,NX)
     2-FSNCK*WGNODP(K,NB,NZ,NY,NX))
      HTNODE(K,NB,NZ,NY,NX)=HTNODE(K,NB,NZ,NY,NX)
     2-FSNCK*HTNODX(K,NB,NZ,NY,NX)
      WGNODE(K,NB,NZ,NY,NX)=WGNODE(K,NB,NZ,NY,NX)
     2-FSNCK*WGNODE(K,NB,NZ,NY,NX)
      WGNODN(K,NB,NZ,NY,NX)=WGNODN(K,NB,NZ,NY,NX)
     2-FSNCK*WGNODN(K,NB,NZ,NY,NX)
      WGNODP(K,NB,NZ,NY,NX)=WGNODP(K,NB,NZ,NY,NX)
     2-FSNCK*WGNODP(K,NB,NZ,NY,NX)
      HTNODX(K,NB,NZ,NY,NX)=HTNODX(K,NB,NZ,NY,NX)
     2-FSNCK*HTNODX(K,NB,NZ,NY,NX)
C
C     FRACTION OF C REMOBILIZED FOR GROWTH RESPIRATION < 0 IS
C     RESPIRED AND NOT TRANSFERRED TO NON-STRUCTURAL POOLS
C
      WTRSVB(NB,NZ,NY,NX)=WTRSVB(NB,NZ,NY,NX)+FSNCK*RCCK*SNCF 
      WTRSBN(NB,NZ,NY,NX)=WTRSBN(NB,NZ,NY,NX)+FSNCK*RCZK
      WTRSBP(NB,NZ,NY,NX)=WTRSBP(NB,NZ,NY,NX)+FSNCK*RCPK
      SNCT=SNCT-FSNCK*RCCK
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,2356)'WGNODE2',I,J,NZ,NB,K,KK,MXNOD,MNNOD
C    2,KSNC,RCCC,FRCC,RCSC,SNCT,WGNODE(K,NB,NZ,NY,NX)
C    3,HTNODX(K,NB,NZ,NY,NX),WTSTKB(NB,NZ,NY,NX)
C    4,CPOOL(NB,NZ,NY,NX)
2356  FORMAT(A8,9I4,12E16.8)
C     ENDIF
C
C     EXIT LOOP IF REMOBILIZATION REQUIREMENT HAS BEEN MET
C
      IF(SNCT.LE.ZEROP(NZ,NY,NX))GO TO 565
C
C     OTHERWISE REMAINING C,N,P IN NODE GOES TO LITTERFALL
C
      ELSE
      DO 7315 M=1,4
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)+CFOPC(3,M,NZ,NY,NX)
     2*WGNODE(K,NB,NZ,NY,NX)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)+CFOPN(3,M,NZ,NY,NX)
     2*WGNODN(K,NB,NZ,NY,NX)
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)+CFOPP(3,M,NZ,NY,NX)
     2*WGNODP(K,NB,NZ,NY,NX)
7315  CONTINUE
      WTSTKB(NB,NZ,NY,NX)=AMAX1(0.0,WTSTKB(NB,NZ,NY,NX)
     2-WGNODE(K,NB,NZ,NY,NX))
      WTSTBN(NB,NZ,NY,NX)=AMAX1(0.0,WTSTBN(NB,NZ,NY,NX)
     2-WGNODN(K,NB,NZ,NY,NX))
      WTSTBP(NB,NZ,NY,NX)=AMAX1(0.0,WTSTBP(NB,NZ,NY,NX)
     2-WGNODP(K,NB,NZ,NY,NX))
      HTNODE(K,NB,NZ,NY,NX)=HTNODE(K,NB,NZ,NY,NX)
     2-HTNODX(K,NB,NZ,NY,NX)
      WGNODE(K,NB,NZ,NY,NX)=0.0
      WGNODN(K,NB,NZ,NY,NX)=0.0
      WGNODP(K,NB,NZ,NY,NX)=0.0
      HTNODX(K,NB,NZ,NY,NX)=0.0
      ENDIF
1650  CONTINUE
C
C     RESIDUAL STALK
C
      IF(WTSTXB(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      RCCK=RCSC*WTSTXB(NB,NZ,NY,NX)
      RCZK=WTSTXN(NB,NZ,NY,NX)*(RCSN+(1.0-RCSN)*RCSC)
      RCPK=WTSTXP(NB,NZ,NY,NX)*(RCSP+(1.0-RCSP)*RCSC)
C
C     FRACTION OF RESIDUAL STALK TO BE REMOBILIZED
C
      IF(RCCK.GT.ZEROP(NZ,NY,NX))THEN
      FSNCR=AMAX1(0.0,AMIN1(1.0,SNCT/RCCK))
      ELSE
      FSNCR=1.0
      ENDIF
C
C     NON-REMOBILIZABLE C,N,P BECOMES LITTERFALL ALLOCATED
C     TO FRACTIONS SET IN 'STARTQ'
C
      DO 8310 M=1,4
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)+CFOPC(3,M,NZ,NY,NX)
     2*FSNCR*(WTSTXB(NB,NZ,NY,NX)-RCCK)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)+CFOPN(3,M,NZ,NY,NX)
     2*FSNCR*(WTSTXN(NB,NZ,NY,NX)-RCZK)
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)+CFOPP(3,M,NZ,NY,NX)
     2*FSNCR*(WTSTXP(NB,NZ,NY,NX)-RCPK)
8310  CONTINUE
C
C     UPDATE STATE VARIABLES FOR REMOBILIZATION AND LITTERFALL
C
      WTSTKB(NB,NZ,NY,NX)=AMAX1(0.0,WTSTKB(NB,NZ,NY,NX)
     2-FSNCR*WTSTXB(NB,NZ,NY,NX))
      WTSTBN(NB,NZ,NY,NX)=AMAX1(0.0,WTSTBN(NB,NZ,NY,NX)
     2-FSNCR*WTSTXN(NB,NZ,NY,NX))
      WTSTBP(NB,NZ,NY,NX)=AMAX1(0.0,WTSTBP(NB,NZ,NY,NX)
     2-FSNCR*WTSTXP(NB,NZ,NY,NX))
      WTSTXB(NB,NZ,NY,NX)=AMAX1(0.0,WTSTXB(NB,NZ,NY,NX)
     2-FSNCR*WTSTXB(NB,NZ,NY,NX))
      WTSTXN(NB,NZ,NY,NX)=AMAX1(0.0,WTSTXN(NB,NZ,NY,NX)
     2-FSNCR*WTSTXN(NB,NZ,NY,NX))
      WTSTXP(NB,NZ,NY,NX)=AMAX1(0.0,WTSTXP(NB,NZ,NY,NX)
     2-FSNCR*WTSTXP(NB,NZ,NY,NX))
      HTNODZ=0.0
      DO 8320 K=0,25
      HTNODZ=AMAX1(HTNODZ,HTNODE(K,NB,NZ,NY,NX))
8320  CONTINUE
      HTNODZ=AMAX1(0.0,HTNODZ-FSNCR*HTNODZ)
      DO 8325 K=0,25
      HTNODE(K,NB,NZ,NY,NX)=AMIN1(HTNODZ,HTNODE(K,NB,NZ,NY,NX))
8325  CONTINUE
C
C     FRACTION OF C REMOBILIZED FOR GROWTH RESPIRATION < 0 IS
C     RESPIRED AND NOT TRANSFERRED TO NON-STRUCTURAL POOLS
C
      WTRSVB(NB,NZ,NY,NX)=WTRSVB(NB,NZ,NY,NX)+FSNCR*RCCK*SNCF 
      WTRSBN(NB,NZ,NY,NX)=WTRSBN(NB,NZ,NY,NX)+FSNCR*RCZK
      WTRSBP(NB,NZ,NY,NX)=WTRSBP(NB,NZ,NY,NX)+FSNCR*RCPK
      SNCT=SNCT-FSNCR*RCCK
      ENDIF
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,2357)'WTSTXB1',I,J,NZ,NB,K,FSNCR,SNCT
C    3,WTSTKB(NB,NZ,NY,NX),WTSTXB(NB,NZ,NY,NX)
C    4,(HTNODE(K,NB,NZ,NY,NX),K=0,25)
2357  FORMAT(A8,5I4,40E12.4)
C     ENDIF
C
C     EXIT LOOP IF REMOBILIZATION REQUIREMENT HAS BEEN MET
C
      IF(SNCT.LE.ZEROP(NZ,NY,NX))GO TO 565
C
C     OTHERWISE REMAINING C,N,P IN NODE GOES TO LITTERFALL
C
      ELSE
      DO 8315 M=1,4
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)+CFOPC(3,M,NZ,NY,NX)
     2*WTSTXB(NB,NZ,NY,NX)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)+CFOPN(3,M,NZ,NY,NX)
     2*WTSTXN(NB,NZ,NY,NX)
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)+CFOPP(3,M,NZ,NY,NX)
     2*WTSTXP(NB,NZ,NY,NX)
8315  CONTINUE
      WTSTKB(NB,NZ,NY,NX)=AMAX1(0.0,WTSTKB(NB,NZ,NY,NX)
     2-WTSTXB(NB,NZ,NY,NX))
      WTSTBN(NB,NZ,NY,NX)=AMAX1(0.0,WTSTBN(NB,NZ,NY,NX)
     2-WTSTXN(NB,NZ,NY,NX))
      WTSTBP(NB,NZ,NY,NX)=AMAX1(0.0,WTSTBP(NB,NZ,NY,NX)
     2-WTSTXP(NB,NZ,NY,NX))
      WTSTXB(NB,NZ,NY,NX)=0.0
      WTSTXN(NB,NZ,NY,NX)=0.0
      WTSTXP(NB,NZ,NY,NX)=0.0
      MXNOD=KVSTG(NB,NZ,NY,NX)
      MNNOD=MAX(MIN(0,MAX(0,MXNOD-NNOD(NZ,NY,NX)))
     2,KVSTG(NB,NZ,NY,NX)-23)
      MXNOD=MAX(MXNOD,MNNOD)
      DO 1660 KK=MXNOD,MNNOD,-1
      K=MOD(KK,25)
      IF(K.EQ.0.AND.KK.NE.0)K=25
      HTNODE(K,NB,NZ,NY,NX)=0.0
      HTNODX(K,NB,NZ,NY,NX)=0.0
1660  CONTINUE
C     IF(NZ.EQ.2)THEN
C     WRITE(*,2357)'WTSTXB2',I,J,NZ,NB,FSNCR,SNCT
C    3,HTNODX(K,NB,NZ,NY,NX),WTSTKB(NB,NZ,NY,NX)
C    4,WTSTXB(NB,NZ,NY,NX),WTSTBN(NB,NZ,NY,NX),WTSTBP(NB,NZ,NY,NX)
C     ENDIF
      ENDIF
C
C     REMOBILIZATION OF STORAGE C,N,P 
C
      SNCR=SNCT/(1.0+FXFS)
      IF(WTRVC(NZ,NY,NX).GT.SNCR)THEN
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)-SNCR
      SNCR=0.0
      GO TO 565
      ELSE
      IDTHB(NB,NZ,NY,NX)=1
      ENDIF
565   CONTINUE
575   CONTINUE
      ENDIF
595   CONTINUE
C
C     DEATH IF MAIN STALK OF TREE DIES
C
      IF(IBTYP(NZ,NY,NX).NE.0.AND.IGTYP(NZ,NY,NX).GT.1
     2.AND.IDTHB(NB1(NZ,NY,NX),NZ,NY,NX).EQ.1)IDTHB(NB,NZ,NY,NX)=1
C
C     REMOBILIZE EXCESS LEAF STRUCTURAL N,P
C
      KVSTGX=MAX(0,KVSTG(NB,NZ,NY,NX)-24)
      DO 495 KK=KVSTGX,KVSTG(NB,NZ,NY,NX)
      K=MOD(KK,25)
      IF(K.EQ.0.AND.KK.NE.0)K=25
      IF(WGLF(K,NB,NZ,NY,NX).GT.0.0)THEN
      CPOOLT=WGLF(K,NB,NZ,NY,NX)+CPOOL(NB,NZ,NY,NX) 
      IF(CPOOLT.GT.ZEROP(NZ,NY,NX))THEN
      ZPOOLD=WGLFN(K,NB,NZ,NY,NX)*CPOOL(NB,NZ,NY,NX) 
     2-ZPOOL(NB,NZ,NY,NX)*WGLF(K,NB,NZ,NY,NX)
      XFRN1=AMAX1(0.0,AMIN1(1.0E-03*ZPOOLD/CPOOLT,WGLFN(K,NB,NZ,NY,NX)
     2-ZPLFM*CNLFB*WGLF(K,NB,NZ,NY,NX)))
      PPOOLD=WGLFP(K,NB,NZ,NY,NX)*CPOOL(NB,NZ,NY,NX) 
     2-PPOOL(NB,NZ,NY,NX)*WGLF(K,NB,NZ,NY,NX)
      XFRP1=AMAX1(0.0,AMIN1(1.0E-03*PPOOLD/CPOOLT,WGLFP(K,NB,NZ,NY,NX)
     2-ZPLFM*CPLFB*WGLF(K,NB,NZ,NY,NX)))
      XFRN=AMAX1(XFRN1,10.0*XFRP1)
      XFRP=AMAX1(XFRP1,0.10*XFRN1)
      WGLFN(K,NB,NZ,NY,NX)=WGLFN(K,NB,NZ,NY,NX)-XFRN
      WTLFBN(NB,NZ,NY,NX)=WTLFBN(NB,NZ,NY,NX)-XFRN
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)+XFRN
      WGLFP(K,NB,NZ,NY,NX)=WGLFP(K,NB,NZ,NY,NX)-XFRP
      WTLFBP(NB,NZ,NY,NX)=WTLFBP(NB,NZ,NY,NX)-XFRP
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)+XFRP
      WSLF(K,NB,NZ,NY,NX)=AMAX1(0.0,WSLF(K,NB,NZ,NY,NX)
     2-AMAX1(XFRN*CNWS(NZ,NY,NX),XFRP*CPWS(NZ,NY,NX)))
      ENDIF
      ENDIF
495   CONTINUE
C
C     ALLOCATION OF LEAF AREA TO CANOPY LAYERS
C
      KVSTGN(NB,NZ,NY,NX)=0
      IF(HTCTL(NZ,NY,NX).LE.SDPTH(NZ,NY,NX)
     2.AND.ARLF(0,NB1(NZ,NY,NX),NZ,NY,NX).GT.0.0)THEN
      XLGLF=SQRT(1.0E+02*ARLF(0,NB1(NZ,NY,NX),NZ,NY,NX)
     2/PP(NZ,NY,NX))
      HTCTL(NZ,NY,NX)=XLGLF+HTSHE(0,NB1(NZ,NY,NX),NZ,NY,NX)
     2+HTNODE(0,NB1(NZ,NY,NX),NZ,NY,NX)
      ENDIF
C
C     IF CANOPY HAS EMERGED
C
      IF(HTCTL(NZ,NY,NX).GT.SDPTH(NZ,NY,NX))THEN
      DO 540 K=0,25
      DO 540 L=1,NC(NY,NX)
      ARLFL(L,K,NB,NZ,NY,NX)=0.0
      WGLFL(L,K,NB,NZ,NY,NX)=0.0
      WGLFLN(L,K,NB,NZ,NY,NX)=0.0
      WGLFLP(L,K,NB,NZ,NY,NX)=0.0
540   CONTINUE
      DO 535 L=1,NC(NY,NX)
      ARSTK(L,NB,NZ,NY,NX)=0.0
535   CONTINUE
C
C     BRANCH HEIGHT
C
      IF(IBTYP(NZ,NY,NX).NE.0.AND.IGTYP(NZ,NY,NX).GT.1)THEN
      IF(NB.NE.NB1(NZ,NY,NX))THEN
      KVSTG1=MAX(1,KVSTG(NB1(NZ,NY,NX),NZ,NY,NX)-24)
      IF(NBTB(NB,NZ,NY,NX).GE.KVSTG1)THEN
      K=MOD(NBTB(NB,NZ,NY,NX),25)
      IF(K.EQ.0.AND.KK.NE.0)K=25
      HTBR=HTNODE(K,NB1(NZ,NY,NX),NZ,NY,NX)
      ELSE
      HTBR=0.0
      ENDIF
      ELSE
      HTBR=0.0
      ENDIF
      ELSE
      HTBR=0.0
      ENDIF
      KVSTGX=MAX(0,KVSTG(NB,NZ,NY,NX)-24)
C
C     FOR ALL LEAFED NODES
C
      DO 560 KK=KVSTGX,KVSTG(NB,NZ,NY,NX)
      K=MOD(KK,25)
      IF(K.EQ.0.AND.KK.NE.0)K=25
C
C     HEIGHT OF STALK INTERNODE + SHEATH OR PETIOLE
C     AND LENGTH OF LEAF
C
      HTSTK=HTBR+HTNODE(K,NB,NZ,NY,NX)
      HTLF=HTSTK+HTSHE(K,NB,NZ,NY,NX)
      XLGLF=AMAX1(0.0,SQRT(WDLF(NZ,NY,NX)*AMAX1(0.0
     2,ARLF(K,NB,NZ,NY,NX))/(PP(NZ,NY,NX)*FNOD(NZ,NY,NX))))
      TLGLF=0.0
C
C     ALLOCATE FRACTIONS OF LEAF IN EACH INCLINATION CLASS
C     FROM HIGHEST TO LOWEST TO CANOPY LAYER
C
      DO 555 N=4,1,-1
      YLGLF=ZSIN(N)*CLASS(N,NZ,NY,NX)*XLGLF
      HTLFL=AMIN1(ZCX(NZ,NY,NX)+0.01-YLGLF,HTLF+TLGLF)
      HTLFU=AMIN1(ZCX(NZ,NY,NX)+0.01,HTLFL+YLGLF)
      LU=0
      LL=0
      DO 550 L=NC(NY,NX),1,-1
      IF(LU.EQ.1.AND.LL.EQ.1)GO TO 551
      IF((HTLFU.GT.ZL(L-1,NY,NX).OR.ZL(L-1,NY,NX).LT.ZERO)
     2.AND.LU.EQ.0)THEN
      LHTLFU=MAX(1,L)
      LU=1
      ENDIF
      IF((HTLFL.GT.ZL(L-1,NY,NX).OR.ZL(L-1,NY,NX).LT.ZERO)
     2.AND.LL.EQ.0)THEN
      LHTLFL=MAX(1,L)
      LL=1
      ENDIF
550   CONTINUE
551   CONTINUE
      DO 570 L=LHTLFL,LHTLFU
      IF(LHTLFU.EQ.LHTLFL)THEN
      FRACL=CLASS(N,NZ,NY,NX)
      ELSEIF(HTLFU.GT.HTLFL.AND.ZL(L,NY,NX).GT.HTLFL)THEN
      FRACL=CLASS(N,NZ,NY,NX)*(AMIN1(HTLFU,ZL(L,NY,NX))
     2-AMAX1(HTLFL,ZL(L-1,NY,NX)))/(HTLFU-HTLFL)
      ELSE
      FRACL=CLASS(N,NZ,NY,NX) 
      ENDIF
      YARLF=FRACL*ARLF(K,NB,NZ,NY,NX)
      YWGLF=FRACL*WGLF(K,NB,NZ,NY,NX)
      YWGLFN=FRACL*WGLFN(K,NB,NZ,NY,NX)
      YWGLFP=FRACL*WGLFP(K,NB,NZ,NY,NX)
C
C     ACCUMULATE LAYER LEAF AREAS, C, N AND P CONTENTS
C
      ARLFL(L,K,NB,NZ,NY,NX)=ARLFL(L,K,NB,NZ,NY,NX)+YARLF
      WGLFL(L,K,NB,NZ,NY,NX)=WGLFL(L,K,NB,NZ,NY,NX)+YWGLF
      WGLFLN(L,K,NB,NZ,NY,NX)=WGLFLN(L,K,NB,NZ,NY,NX)+YWGLFN
      WGLFLP(L,K,NB,NZ,NY,NX)=WGLFLP(L,K,NB,NZ,NY,NX)+YWGLFP
      ARLFV(L,NZ,NY,NX)=ARLFV(L,NZ,NY,NX)+YARLF
      WGLFV(L,NZ,NY,NX)=WGLFV(L,NZ,NY,NX)+YWGLF
C     IF(J.EQ.12)THEN
C     WRITE(*,4813)'GRO',I,J,NZ,NB,K,KK,L,LHTLFL,LHTLFU
C    2,FRACL,HTLFU,HTLFL,ZL(L-1,NY,NX),ARLFB(NB,NZ,NY,NX) 
C    3,ARLF(K,NB,NZ,NY,NX),WTLFB(NB,NZ,NY,NX),WGLF(K,NB,NZ,NY,NX)
C    4,ARLFP(NZ,NY,NX),ZL(L,NY,NX),HTLF,TLGLF,HTSTK,HTBR 
C    4,HTNODE(K,NB,NZ,NY,NX),HTSHE(K,NB,NZ,NY,NX),YLGLF
C    5,ZSIN(N),CLASS(N,NZ,NY,NX),XLGLF,ZC(NZ,NY,NX)
C    6,ZCX(NZ,NY,NX) 
4813  FORMAT(A8,9I4,30E12.4)
C     ENDIF
570   CONTINUE
      TLGLF=TLGLF+YLGLF
      ZC(NZ,NY,NX)=AMAX1(ZC(NZ,NY,NX),HTLFU)
555   CONTINUE
      IF(WSSHE(K,NB,NZ,NY,NX).GT.0.0)THEN
      IF(KVSTGN(NB,NZ,NY,NX).EQ.0)KVSTGN(NB,NZ,NY,NX)
     2=MIN(KK,KVSTG(NB,NZ,NY,NX))
      ENDIF
560   CONTINUE
      IF(KVSTGN(NB,NZ,NY,NX).EQ.0)KVSTGN(NB,NZ,NY,NX)
     2=KVSTG(NB,NZ,NY,NX)
      K1=MOD(KVSTG(NB,NZ,NY,NX),25)
      IF(K1.EQ.0.AND.KVSTG(NB,NZ,NY,NX).NE.0)K1=25
      HTLFB=HTBR 
     2+AMAX1(0.0,HTNODE(K1,NB,NZ,NY,NX))
C
C     ALLOCATE STALK SURFACE AREA TO CANOPY LAYERS
C
      IF(HTNODE(K1,NB,NZ,NY,NX).GT.0.0)THEN
      LU=0
      LL=0
      DO 545 L=NC(NY,NX),1,-1
      IF(LU.EQ.1.AND.LL.EQ.1)GO TO 546
      IF((HTLFB.GT.ZL(L-1,NY,NX).OR.ZL(L-1,NY,NX).LT.ZERO)
     2.AND.LU.EQ.0)THEN
      LHTBRU=MAX(1,L)
      LU=1
      ENDIF
      IF((HTBR.GT.ZL(L-1,NY,NX).OR.ZL(L-1,NY,NX)
     2.LT.ZERO).AND.LL.EQ.0)THEN
      LHTBRL=MAX(1,L)
      LL=1
      ENDIF
545   CONTINUE
546   CONTINUE
      RSTK=SQRT(VSTK*(AMAX1(0.0,WTSTKB(NB,NZ,NY,NX))/PP(NZ,NY,NX))
     3/(3.1416*HTNODE(K1,NB,NZ,NY,NX)))
      ARSTKB(NB)=3.1416*HTNODE(K1,NB,NZ,NY,NX)*PP(NZ,NY,NX)*RSTK
      IF(ISTYP(NZ,NY,NX).EQ.0)THEN
      WVSTKB(NB,NZ,NY,NX)=WTSTKB(NB,NZ,NY,NX)
      ELSE
      ZSTK=AMIN1(ZSTX,FSTK*RSTK)
      ASTV=3.1416*(2.0*RSTK*ZSTK-ZSTK**2)
      WVSTKB(NB,NZ,NY,NX)=ASTV/VSTK*HTNODE(K1,NB,NZ,NY,NX)*PP(NZ,NY,NX)
      ENDIF
      DO 445 L=LHTBRL,LHTBRU
      IF(HTLFB.GT.HTBR)THEN
      IF(HTLFB.GT.ZL(L-1,NY,NX))THEN
      FRACL=(AMIN1(HTLFB,ZL(L,NY,NX))-AMAX1(HTBR
     2,ZL(L-1,NY,NX)))/(HTLFB-HTBR)
      ELSE
      FRACL=0.0
      ENDIF
      ELSE
      FRACL=1.0
      ENDIF
      ARSTK(L,NB,NZ,NY,NX)=FRACL*ARSTKB(NB)
445   CONTINUE
      ELSE
      WVSTKB(NB,NZ,NY,NX)=0.0
      DO 450 L=1,NC(NY,NX)
      ARSTK(L,NB,NZ,NY,NX)=0.0
450   CONTINUE
      ENDIF
      ELSE
      WVSTKB(NB,NZ,NY,NX)=0.0
      DO 455 L=1,NC(NY,NX)
      ARSTK(L,NB,NZ,NY,NX)=0.0
455   CONTINUE
      ENDIF
C
C     ALLOCATE LEAF AREA TO INCLINATION CLASSES ACCORDING TO
C     DISTRIBUTION ENTERED IN 'READQ' ASSUMING AZIMUTH IS UNIFORM
C
      IF(SSINN(NY,NX).GT.0.0)THEN
      DO 900 K=1,25
      DO 900 L=1,NC(NY,NX)
      DO 900 N=1,4
      SURF(N,L,K,NB,NZ,NY,NX)=0.0
900   CONTINUE
C     ARLFXB=0.0
C     ARLFXL=0.0
C     SURFXX=0.0
      DO 500 K=1,25
C     ARLFXB=ARLFXB+ARLF(K,NB,NZ,NY,NX)
      IF(ARLF(K,NB,NZ,NY,NX).GT.0.0
     2.AND.ZC(NZ,NY,NX).GT.DPTHS(NY,NX))THEN
      DO 700 L=NC(NY,NX),1,-1
C     ARLFXL=ARLFXL+ARLFL(L,K,NB,NZ,NY,NX) 
      DO 800 N=1,4
      SURF(N,L,K,NB,NZ,NY,NX)=AMAX1(0.0,CLASS(N,NZ,NY,NX)
     2*0.25*ARLFL(L,K,NB,NZ,NY,NX))
C     SURFXX=SURFXX+SURF(N,L,K,NB,NZ,NY,NX)
C     IF(I.EQ.151.AND.(NZ.EQ.1.OR.NZ.EQ.4))THEN
C     WRITE(*,6363)'SURF',I,J,NX,NY,NZ,NB,K,L,N
C    2,ARLFL(L,K,NB,NZ,NY,NX)
C    2,SURF(N,L,K,NB,NZ,NY,NX),CLASS(N,NZ,NY,NX),ARLF(K,NB,NZ,NY,NX)
C    3,DPTHS(NY,NX),ARLFXB,ARLFXL,SURFXX,ARLF(0,NB,NZ,NY,NX)
C    4,ARLFB(NB,NZ,NY,NX)
6363  FORMAT(A8,9I4,12E16.8)
C     ENDIF 
800   CONTINUE
700   CONTINUE
      ENDIF
500   CONTINUE
C
C     ALLOCATE STALK AREA TO INCLINATION CLASSES ACCORDING TO
C     BRANCH ANGLE ENTERED IN 'READQ' ASSUMING AZIMUTH IS UNIFORM
C
      DO 910 L=1,NC(NY,NX)
      DO 910 N=1,4
      SURFB(N,L,NB,NZ,NY,NX)=0.0
910   CONTINUE
      IF(NB.EQ.NB1(NZ,NY,NX))THEN
      N=4
      ELSE
      N=MIN(4,INT(ASIN(ANGBR(NZ,NY,NX))/0.3927)+1)
      ENDIF
      DO 710 L=NC(NY,NX),1,-1
      SURFB(N,L,NB,NZ,NY,NX)=0.25*ARSTK(L,NB,NZ,NY,NX)
710   CONTINUE
      ENDIF
C
C     SET MAXIMUM GRAIN NUMBER FROM SHOOT MASS BEFORE ANTHESIS
C
      IF(IDAY(3,NB,NZ,NY,NX).NE.0.AND.IDAY(6,NB,NZ,NY,NX).EQ.0)THEN
      GRNXB(NB,NZ,NY,NX)=GRNXB(NB,NZ,NY,NX)
     2+STMX(NZ,NY,NX)*AMAX1(0.0,GROSTK)
C     WRITE(*,4246)'GRNX',I,J,NZ,NB,IDAY(3,NB,NZ,NY,NX)
C    2,GRNXB(NB,NZ,NY,NX),STMX(NZ,NY,NX),CGROS,GROSTK
      ENDIF
C
C     SET FINAL GRAIN NUMBER AND MAXIMUM GRAIN SIZE FROM C,N,P
C     NON-STRUCTURAL POOLS AFTER ANTHESIS
C
      IF(IDAY(6,NB,NZ,NY,NX).NE.0.AND.IDAY(9,NB,NZ,NY,NX).EQ.0)THEN
      SET=AMIN1(CCPOLB(NB,NZ,NY,NX)/(CCPOLB(NB,NZ,NY,NX)+SETC)
     2,CZPOLB(NB,NZ,NY,NX)/(CZPOLB(NB,NZ,NY,NX)+SETN)
     3,CPPOLB(NB,NZ,NY,NX)/(CPPOLB(NB,NZ,NY,NX)+SETP))
      IF(TCC(NZ,NY,NX).LT.CTC(NZ,NY,NX))THEN
      IF(IDAY(7,NB,NZ,NY,NX).EQ.0)THEN
      FGRNX=0.002*(CTC(NZ,NY,NX)-TCC(NZ,NY,NX))
      ELSEIF(IDAY(8,NB,NZ,NY,NX).EQ.0)THEN
      FGRNX=0.002*(CTC(NZ,NY,NX)-TCC(NZ,NY,NX))
      ELSE
      FGRNX=0.0
      ENDIF
      ELSEIF(TCC(NZ,NY,NX).GT.HTC(NZ,NY,NX))THEN
      IF(IDAY(7,NB,NZ,NY,NX).EQ.0)THEN
      FGRNX=0.002*(TCC(NZ,NY,NX)-HTC(NZ,NY,NX))
      ELSEIF(IDAY(8,NB,NZ,NY,NX).EQ.0)THEN
      FGRNX=0.002*(TCC(NZ,NY,NX)-HTC(NZ,NY,NX))
      ELSE
      FGRNX=0.0
      ENDIF
      ELSE
      FGRNX=0.0
      ENDIF
      IF(IDAY(6,NB,NZ,NY,NX).NE.0.AND.IDAY(8,NB,NZ,NY,NX).EQ.0)THEN
C     GRNXB(NB,NZ,NY,NX)=GRNXB(NB,NZ,NY,NX)*FGRNX
      GRNOB(NB,NZ,NY,NX)=AMIN1(SDMX(NZ,NY,NX)*GRNXB(NB,NZ,NY,NX)
     2,GRNOB(NB,NZ,NY,NX)+SDMX(NZ,NY,NX)*GRNXB(NB,NZ,NY,NX)
     3*SET*DGSTGF(NB,NZ,NY,NX)-FGRNX*GRNOB(NB,NZ,NY,NX)) 
C     IF(FGRNX.LT.1.0)THEN 
C     WRITE(*,4246)'GRNO',I,J,NZ,NB,IDAY(7,NB,NZ,NY,NX),TCC(NZ,NY,NX)
C    2,HTC(NZ,NY,NX),FGRNX,GRNXB(NB,NZ,NY,NX),GRNOB(NB,NZ,NY,NX)
C    3,SET,CCPOLB(NB,NZ,NY,NX),CZPOLB(NB,NZ,NY,NX)
C    4,CPPOLB(NB,NZ,NY,NX)
4246  FORMAT(A8,5I4,20E12.4)
C     ENDIF
      ENDIF
      IF(IDAY(7,NB,NZ,NY,NX).NE.0.AND.IDAY(9,NB,NZ,NY,NX).EQ.0)THEN
      GRMXB=GRMX(NZ,NY,NX)*SQRT(1.0-FGRNX) 
      GRWTB(NB,NZ,NY,NX)=AMIN1(GRMX(NZ,NY,NX),GRWTB(NB,NZ,NY,NX) 
     2+GRMXB*AMAX1(0.50,SQRT(SET))*DGSTGF(NB,NZ,NY,NX))
C     IF(FGRNX.LT.1.0)THEN
C     WRITE(*,4246)'GRWT',I,J,NZ,NB,IDAY(8,NB,NZ,NY,NX),TCC(NZ,NY,NX)
C    2,HTC(NZ,NY,NX),FGRNX,GRMX(NZ,NY,NX),GRWTB(NB,NZ,NY,NX)
C     ENDIF
      ENDIF
      ENDIF
C
C     GRAIN FILL BY TRANSLOCATION FROM STALK RESERVES
C     UNTIL GRAIN SINK (=FINAL GRAIN NUMBER X MAXIMUM
C     GRAIN SIZE) IS FILLED OR RESERVES ARE EXHAUSTED
C
      IF(IDAY(7,NB,NZ,NY,NX).NE.0)THEN
      IF(WTGRB(NB,NZ,NY,NX).GE.GRWTB(NB,NZ,NY,NX)
     2*GRNOB(NB,NZ,NY,NX))THEN
      GROLM=0.0
      ELSEIF(IRTYP(NZ,NY,NX).EQ.0)THEN
      GROLM=AMAX1(0.0,GFILL(NZ,NY,NX)*GRNOB(NB,NZ,NY,NX)
     2*SQRT(TFN3(NZ,NY,NX)))
      ELSE
      GROLM=AMAX1(0.0,GFILL(NZ,NY,NX)*GRNOB(NB,NZ,NY,NX)
     2*SQRT(TFN4(NG(NZ,NY,NX),NZ,NY,NX)))
      ENDIF
C
C     GRAIN FILL RATE MAY BE CONSTRAINED BY HIGH GRAIN C:N OR C:P
C
      IF(WTGRBN(NB,NZ,NY,NX).LT.ZPGRM*CNGR(NZ,NY,NX)
     2*WTGRB(NB,NZ,NY,NX).OR.WTGRBP(NB,NZ,NY,NX).LT.ZPGRM
     3*CPGR(NZ,NY,NX)*WTGRB(NB,NZ,NY,NX))THEN
      GROLC=0.0
      ELSE
      GROLC=GROLM
      ENDIF
      XLOCM=AMIN1(GROLM,WTRSVB(NB,NZ,NY,NX))
      XLOCC=AMIN1(GROLC,WTRSVB(NB,NZ,NY,NX))
C
C     GRAIN N OR P FILL RATE MAY BE LIMITED BY C:N OR C:P RATIOS
C     OF STALK RESERVES
C
      IF(WTRSVB(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      ZNPG=AMIN1(WTRSBN(NB,NZ,NY,NX)/(WTRSBN(NB,NZ,NY,NX)
     2+SETN*WTRSVB(NB,NZ,NY,NX))
     3,WTRSBP(NB,NZ,NY,NX)/(WTRSBP(NB,NZ,NY,NX)
     3+SETP*WTRSVB(NB,NZ,NY,NX)))
      ZPGRX=ZPGRM+ZNPG*ZPGRD
      XLOCN=AMIN1(XLOCM*CNGR(NZ,NY,NX),WTRSBN(NB,NZ,NY,NX)*ZPGRX
     2,(WTGRB(NB,NZ,NY,NX)+XLOCC)*CNGR(NZ,NY,NX)-WTGRBN(NB,NZ,NY,NX))
      XLOCP=AMIN1(XLOCM*CPGR(NZ,NY,NX),WTRSBP(NB,NZ,NY,NX)*ZPGRX
     2,(WTGRB(NB,NZ,NY,NX)+XLOCC)*CPGR(NZ,NY,NX)-WTGRBP(NB,NZ,NY,NX))
      ELSE
      XLOCN=0.0
      XLOCP=0.0
      ENDIF
C
C     TRANSLOCATE C,N,P FROM STALK RESERVES TO GRAIN
C
      WTRSVB(NB,NZ,NY,NX)=WTRSVB(NB,NZ,NY,NX)+GROGR-XLOCC
      WTRSBN(NB,NZ,NY,NX)=WTRSBN(NB,NZ,NY,NX)+GROGRN-XLOCN
      WTRSBP(NB,NZ,NY,NX)=WTRSBP(NB,NZ,NY,NX)+GROGRP-XLOCP
      WTGRB(NB,NZ,NY,NX)=WTGRB(NB,NZ,NY,NX)+XLOCC
      WTGRBN(NB,NZ,NY,NX)=WTGRBN(NB,NZ,NY,NX)+XLOCN
      WTGRBP(NB,NZ,NY,NX)=WTGRBP(NB,NZ,NY,NX)+XLOCP
      ELSE
      XLOCC=0.0
      XLOCN=0.0
      ENDIF
C
C     SET DATE OF PHYSIOLOGICAL MATURITY WHEN GRAIN FILL
C     HAS STOPPED FOR SET PERIOD OF TIME
C
      IF(IDAY(8,NB,NZ,NY,NX).NE.0)THEN
      IF(XLOCC.LE.1.0E-09*PP(NZ,NY,NX))THEN
      FLG4(NB,NZ,NY,NX)=FLG4(NB,NZ,NY,NX)+1.0
      ELSE
      FLG4(NB,NZ,NY,NX)=0.0
      ENDIF
      IF(FLG4(NB,NZ,NY,NX).GE.FLG4X)THEN
      IF(IDAY(10,NB,NZ,NY,NX).EQ.0)THEN
      IDAY(10,NB,NZ,NY,NX)=I
      ENDIF
      ENDIF
      ENDIF
C     IF(NZ.EQ.3)THEN
C     WRITE(*,85)'XLOC',I,J,NZ,NB,WTGRB(NB,NZ,NY,NX),WTGRBN(NB,NZ,NY,NX)
C    2,WTRSVB(NB,NZ,NY,NX),WTRSBN(NB,NZ,NY,NX),XLOCC,XLOCN,XLOCM
C    3,CNGR(NZ,NY,NX),ZPGRX,ZNPG,GROLC,GROLM,GROGR,GRNOB(NB,NZ,NY,NX)
C    4,GRWTB(NB,NZ,NY,NX),GFILL(NZ,NY,NX),SQRT(TFN3(NZ,NY,NX))
C    5,FLG4(NB,NZ,NY,NX) 
85    FORMAT(A8,4I4,20E12.4)
C     ENDIF
C
C     RESET PHENOLOGY AT EMERGENCE ('VRNS' > 'VRNL')
C     AND END OF SEASON ('VRNF' > 'VRNX')
C
      IF(ISTYP(NZ,NY,NX).NE.0.OR.IWTYP(NZ,NY,NX).NE.0)THEN
      IF((IFLGE(NB,NZ,NY,NX).EQ.0
     2.AND.VRNS(NB,NZ,NY,NX).GE.VRNL(NB,NZ,NY,NX)
     3.AND.ZC(NZ,NY,NX).GT.DPTHS(NY,NX)-1.0E-03)
     4.OR.(IFLGF(NB,NZ,NY,NX).EQ.0
     5.AND.VRNF(NB,NZ,NY,NX).GE.VRNX(NB,NZ,NY,NX))
     6.OR.IDTHB(NB1(NZ,NY,NX),NZ,NY,NX).EQ.1)THEN
      IF(IFLGE(NB,NZ,NY,NX).EQ.0
     2.AND.VRNS(NB,NZ,NY,NX).GE.VRNL(NB,NZ,NY,NX)
     3.AND.ZC(NZ,NY,NX).GT.DPTHS(NY,NX)-1.0E-03)THEN
      IF(IBTYP(NZ,NY,NX).EQ.0)THEN
      PSTG(NB,NZ,NY,NX)=XTLI(NZ,NY,NX)
      VSTG(NB,NZ,NY,NX)=0.0
      KLEAF(NB,NZ,NY,NX)=1
      KVSTG(NB,NZ,NY,NX)=1
      FLG4(NB,NZ,NY,NX)=0.0
      DO 5330 M=1,4
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)
     2+CFOPC(5,M,NZ,NY,NX)*WTLFB(NB,NZ,NY,NX)*FWODB(0)
     3+CFOPC(5,M,NZ,NY,NX)*WTSHEB(NB,NZ,NY,NX)*FWODB(0)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)
     2+CFOPN(5,M,NZ,NY,NX)*WTLFBN(NB,NZ,NY,NX)*FWODLN(0)
     3+CFOPN(5,M,NZ,NY,NX)*WTSHBN(NB,NZ,NY,NX)*FWODSN(0)
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)
     2+CFOPP(5,M,NZ,NY,NX)*WTLFBP(NB,NZ,NY,NX)*FWODLP(0) 
     3+CFOPP(5,M,NZ,NY,NX)*WTSHBP(NB,NZ,NY,NX)*FWODSP(0) 
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+CFOPC(1,M,NZ,NY,NX)*WTLFB(NB,NZ,NY,NX)*FWODB(1)
     3+CFOPC(2,M,NZ,NY,NX)*WTSHEB(NB,NZ,NY,NX)*FWODB(1)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+CFOPN(1,M,NZ,NY,NX)*WTLFBN(NB,NZ,NY,NX)*FWODLN(1)
     3+CFOPN(2,M,NZ,NY,NX)*WTSHBN(NB,NZ,NY,NX)*FWODSN(1)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)
     2+CFOPP(1,M,NZ,NY,NX)*WTLFBP(NB,NZ,NY,NX)*FWODLP(1) 
     3+CFOPP(2,M,NZ,NY,NX)*WTSHBP(NB,NZ,NY,NX)*FWODSP(1)
5330  CONTINUE
      ARLFB(NB,NZ,NY,NX)=0.0
      WTLFB(NB,NZ,NY,NX)=0.0
      WTLFBN(NB,NZ,NY,NX)=0.0
      WTLFBP(NB,NZ,NY,NX)=0.0
      WTSHEB(NB,NZ,NY,NX)=0.0
      WTSHBN(NB,NZ,NY,NX)=0.0
      WTSHBP(NB,NZ,NY,NX)=0.0
      DO 5335 K=0,25
      ARLF(K,NB,NZ,NY,NX)=0.0
      HTSHE(K,NB,NZ,NY,NX)=0.0
      WGLF(K,NB,NZ,NY,NX)=0.0
      WSLF(K,NB,NZ,NY,NX)=0.0
      WGLFN(K,NB,NZ,NY,NX)=0.0
      WGLFP(K,NB,NZ,NY,NX)=0.0
      WGSHE(K,NB,NZ,NY,NX)=0.0
      WSSHE(K,NB,NZ,NY,NX)=0.0
      WGSHN(K,NB,NZ,NY,NX)=0.0
      WGSHP(K,NB,NZ,NY,NX)=0.0
5335  CONTINUE
      ENDIF
      ENDIF
      IF((IBTYP(NZ,NY,NX).LT.2.AND.IWTYP(NZ,NY,NX).NE.0)
     2.OR.(IFLGE(NB,NZ,NY,NX).EQ.0
     3.AND.VRNS(NB,NZ,NY,NX).GE.VRNL(NB,NZ,NY,NX)))THEN
      IF(ISTYP(NZ,NY,NX).EQ.0)THEN
      GROUP(NB,NZ,NY,NX)=AMAX1(0.0,GROUPI(NZ,NY,NX)
     2-NBTB(NB,NZ,NY,NX))
      ELSE
      GROUP(NB,NZ,NY,NX)=GROUPI(NZ,NY,NX)
      ENDIF
      PSTGI(NB,NZ,NY,NX)=PSTG(NB,NZ,NY,NX)
      PSTGF(NB,NZ,NY,NX)=0.0
      VSTGX(NB,NZ,NY,NX)=0.0
      TGSTGI(NB,NZ,NY,NX)=0.0
      TGSTGF(NB,NZ,NY,NX)=0.0
      IDAY(1,NB,NZ,NY,NX)=I
      DO 2005 M=2,10
      IDAY(M,NB,NZ,NY,NX)=0
2005  CONTINUE
      IF(NB.EQ.NB1(NZ,NY,NX))THEN
      WSTR(NZ,NY,NX)=0.0
      ENDIF
C
C     RESIDUAL STALKS BECOME LITTERFALL IN GRASSES, SHRUBS AT
C     START OF SEASON
C
      IF(ISTYP(NZ,NY,NX).NE.0.AND.(IFLGE(NB,NZ,NY,NX).EQ.0
     3.AND.VRNS(NB,NZ,NY,NX).GE.VRNL(NB,NZ,NY,NX)))THEN
      DO 6245 M=1,4
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)+CFOPC(2,M,NZ,NY,NX)
     2*(WTHSKB(NB,NZ,NY,NX)+WTEARB(NB,NZ,NY,NX)+WTGRB(NB,NZ,NY,NX))
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)+CFOPN(2,M,NZ,NY,NX)
     2*(WTHSBN(NB,NZ,NY,NX)+WTEABN(NB,NZ,NY,NX)+WTGRBN(NB,NZ,NY,NX))
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)+CFOPP(2,M,NZ,NY,NX)
     2*(WTHSBP(NB,NZ,NY,NX)+WTEABP(NB,NZ,NY,NX)+WTGRBP(NB,NZ,NY,NX))
6245  CONTINUE
      WTHSKB(NB,NZ,NY,NX)=0.0
      WTEARB(NB,NZ,NY,NX)=0.0
      WTGRB(NB,NZ,NY,NX)=0.0
      WTHSBN(NB,NZ,NY,NX)=0.0
      WTEABN(NB,NZ,NY,NX)=0.0
      WTGRBN(NB,NZ,NY,NX)=0.0
      WTHSBP(NB,NZ,NY,NX)=0.0
      WTEABP(NB,NZ,NY,NX)=0.0
      WTGRBP(NB,NZ,NY,NX)=0.0
      GRNXB(NB,NZ,NY,NX)=0.0
      GRNOB(NB,NZ,NY,NX)=0.0
      GRWTB(NB,NZ,NY,NX)=0.0
      IF(IBTYP(NZ,NY,NX).EQ.0.OR.IGTYP(NZ,NY,NX).LE.1)THEN
      DO 6345 M=1,4
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)+CFOPC(3,M,NZ,NY,NX)
     2*WTSTKB(NB,NZ,NY,NX)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)+CFOPN(3,M,NZ,NY,NX)
     2*WTSTBN(NB,NZ,NY,NX)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)+CFOPP(3,M,NZ,NY,NX)
     2*WTSTBP(NB,NZ,NY,NX)
6345  CONTINUE
      WTSTKB(NB,NZ,NY,NX)=0.0
      WTSTBN(NB,NZ,NY,NX)=0.0
      WTSTBP(NB,NZ,NY,NX)=0.0
      WTSTXB(NB,NZ,NY,NX)=0.0
      WTSTXN(NB,NZ,NY,NX)=0.0
      WTSTXP(NB,NZ,NY,NX)=0.0
      DO 6340 K=0,25
      HTNODE(K,NB,NZ,NY,NX)=0.0
      HTNODX(K,NB,NZ,NY,NX)=0.0
      WGNODE(K,NB,NZ,NY,NX)=0.0
      WGNODN(K,NB,NZ,NY,NX)=0.0
      WGNODP(K,NB,NZ,NY,NX)=0.0
6340  CONTINUE
      ENDIF
      ENDIF
      ENDIF
      IF(IFLGE(NB,NZ,NY,NX).EQ.0
     2.AND.VRNS(NB,NZ,NY,NX).GE.VRNL(NB,NZ,NY,NX))THEN
      IFLGA(NB,NZ,NY,NX)=0
      IFLGE(NB,NZ,NY,NX)=1
      IFLGR(NB,NZ,NY,NX)=0
      IFLGQ(NB,NZ,NY,NX)=0
      ELSE
      IFLGF(NB,NZ,NY,NX)=1
      IFLGR(NB,NZ,NY,NX)=1
      IFLGQ(NB,NZ,NY,NX)=0
      ENDIF
      ENDIF
      ENDIF
C
C     REPRODUCTIVE MATERIAL BECOMES LITTERFALL AT END OF SEASON
C
      IF(IFLGR(NB,NZ,NY,NX).EQ.1)THEN
      IFLGQ(NB,NZ,NY,NX)=IFLGQ(NB,NZ,NY,NX)+1
      IF(IFLGQ(NB,NZ,NY,NX).EQ.IFLGRX)THEN
      IFLGR(NB,NZ,NY,NX)=0
      IFLGQ(NB,NZ,NY,NX)=0
      ENDIF
      DO 6330 M=1,4
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+FSNR*CFOPC(2,M,NZ,NY,NX)
     2*(WTHSKB(NB,NZ,NY,NX)+WTEARB(NB,NZ,NY,NX))
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+FSNR*CFOPN(2,M,NZ,NY,NX)
     2*(WTHSBN(NB,NZ,NY,NX)+WTEABN(NB,NZ,NY,NX))
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)
     2+FSNR*CFOPP(2,M,NZ,NY,NX)
     2*(WTHSBP(NB,NZ,NY,NX)+WTEABP(NB,NZ,NY,NX))
      IF(ISTYP(NZ,NY,NX).EQ.0.AND.IWTYP(NZ,NY,NX).NE.0)THEN
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)
     2+FSNR*CFOPC(2,M,NZ,NY,NX)*WTGRB(NB,NZ,NY,NX)
      WTRVN(NZ,NY,NX)=WTRVN(NZ,NY,NX)
     2+FSNR*CFOPN(2,M,NZ,NY,NX)*WTGRBN(NB,NZ,NY,NX)
      WTRVP(NZ,NY,NX)=WTRVP(NZ,NY,NX)
     2+FSNR*CFOPP(2,M,NZ,NY,NX)*WTGRBP(NB,NZ,NY,NX)
      ELSE
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+FSNR*CFOPC(2,M,NZ,NY,NX)*WTGRB(NB,NZ,NY,NX)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+FSNR*CFOPN(2,M,NZ,NY,NX)*WTGRBN(NB,NZ,NY,NX)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX) 
     2+FSNR*CFOPP(2,M,NZ,NY,NX)*WTGRBP(NB,NZ,NY,NX)
      ENDIF
6330  CONTINUE
      WTHSKB(NB,NZ,NY,NX)=(1.0-FSNR)*WTHSKB(NB,NZ,NY,NX)
      WTEARB(NB,NZ,NY,NX)=(1.0-FSNR)*WTEARB(NB,NZ,NY,NX)
      WTGRB(NB,NZ,NY,NX)=(1.0-FSNR)*WTGRB(NB,NZ,NY,NX)
      WTHSBN(NB,NZ,NY,NX)=(1.0-FSNR)*WTHSBN(NB,NZ,NY,NX)
      WTEABN(NB,NZ,NY,NX)=(1.0-FSNR)*WTEABN(NB,NZ,NY,NX)
      WTGRBN(NB,NZ,NY,NX)=(1.0-FSNR)*WTGRBN(NB,NZ,NY,NX)
      WTHSBP(NB,NZ,NY,NX)=(1.0-FSNR)*WTHSBP(NB,NZ,NY,NX)
      WTEABP(NB,NZ,NY,NX)=(1.0-FSNR)*WTEABP(NB,NZ,NY,NX)
      WTGRBP(NB,NZ,NY,NX)=(1.0-FSNR)*WTGRBP(NB,NZ,NY,NX)
      GRNXB(NB,NZ,NY,NX)=(1.0-FSNR)*GRNXB(NB,NZ,NY,NX)
      GRNOB(NB,NZ,NY,NX)=(1.0-FSNR)*GRNOB(NB,NZ,NY,NX)
      GRWTB(NB,NZ,NY,NX)=(1.0-FSNR)*GRWTB(NB,NZ,NY,NX)
C
C     STALKS BECOME LITTERFALL IN GRASSES AT END OF SEASON
C
      IF((IBTYP(NZ,NY,NX).EQ.0.OR.IGTYP(NZ,NY,NX).LE.1)
     2.AND.ISTYP(NZ,NY,NX).NE.0)THEN
      DO 6335 M=1,4
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+FSNR*CFOPC(3,M,NZ,NY,NX)*WTSTKB(NB,NZ,NY,NX)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+FSNR*CFOPN(3,M,NZ,NY,NX)*WTSTBN(NB,NZ,NY,NX)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)
     2+FSNR*CFOPP(3,M,NZ,NY,NX)*WTSTBP(NB,NZ,NY,NX)
6335  CONTINUE
      WTSTKB(NB,NZ,NY,NX)=(1.0-FSNR)*WTSTKB(NB,NZ,NY,NX)
      WTSTBN(NB,NZ,NY,NX)=(1.0-FSNR)*WTSTBN(NB,NZ,NY,NX)
      WTSTBP(NB,NZ,NY,NX)=(1.0-FSNR)*WTSTBP(NB,NZ,NY,NX)
      WTSTXB(NB,NZ,NY,NX)=(1.0-FSNR)*WTSTXB(NB,NZ,NY,NX) 
      WTSTXN(NB,NZ,NY,NX)=(1.0-FSNR)*WTSTXN(NB,NZ,NY,NX) 
      WTSTXP(NB,NZ,NY,NX)=(1.0-FSNR)*WTSTXP(NB,NZ,NY,NX) 
      DO 2010 K=0,25
C     HTNODE(K,NB,NZ,NY,NX)=(1.0-FSNR)*HTNODE(K,NB,NZ,NY,NX)
      HTNODX(K,NB,NZ,NY,NX)=(1.0-FSNR)*HTNODX(K,NB,NZ,NY,NX)
      WGNODE(K,NB,NZ,NY,NX)=(1.0-FSNR)*WGNODE(K,NB,NZ,NY,NX)
      WGNODN(K,NB,NZ,NY,NX)=(1.0-FSNR)*WGNODN(K,NB,NZ,NY,NX)
      WGNODP(K,NB,NZ,NY,NX)=(1.0-FSNR)*WGNODP(K,NB,NZ,NY,NX)
2010  CONTINUE
      ENDIF
C
C     SELF-SEEDING ANNUALS IF DROUGHT DECIDUOUS
C
      IF(J.EQ.INT(ZNOON(NY,NX)))THEN
      IF(NB.EQ.NB1(NZ,NY,NX))THEN
      IF(ISTYP(NZ,NY,NX).EQ.0.AND.IWTYP(NZ,NY,NX).NE.0)THEN
      IDAYH(NZ,NY,NX)=I
      IYRH(NZ,NY,NX)=IYRC
      IHVST(NZ,I,NY,NX)=1
      JHVST(NZ,I,NY,NX)=2
      HVST(NZ,I,NY,NX)=0.0
      THIN(NZ,I,NY,NX)=0.0
      EHVST(1,1,NZ,I,NY,NX)=1.0
      EHVST(1,2,NZ,I,NY,NX)=1.0
      EHVST(1,3,NZ,I,NY,NX)=1.0
      EHVST(1,4,NZ,I,NY,NX)=1.0
      EHVST(2,1,NZ,I,NY,NX)=0.0
      EHVST(2,2,NZ,I,NY,NX)=1.0
      EHVST(2,3,NZ,I,NY,NX)=0.0
      EHVST(2,4,NZ,I,NY,NX)=0.0
      IDAY0(NZ,NY,NX)=-1E+06
      IYR0(NZ,NY,NX)=-1E+06
      IFLGI(NZ,NY,NX)=1
C     WRITE(*,3366)'HVST',I,J,IYRC,IDAYH(NZ,NY,NX),IYRH(NZ,NY,NX)
C    2,IHVST(NZ,I,NY,NX),JHVST(NZ,I,NY,NX),IFLGI(NZ,NY,NX)
3366  FORMAT(A8,8I8)
      ENDIF
      ENDIF
      ENDIF
      ENDIF
C
C     TRANSFER C,N,P FROM SEASONAL STORAGE TO SHOOT AND ROOT
C     NON-STRUCTURAL C DURING SEED GERMINATION OR LEAFOUT
C
C     IF(NZ.EQ.1)THEN
C     WRITE(*,2322)'VRNS',I,J,NX,NY,NZ,NB,NB1(NZ,NY,NX),IFLGZ
C    2,ISTYP(NZ,NY,NX),IFLGI(NZ,NY,NX),VRNS(NB1(NZ,NY,NX),NZ,NY,NX)
C    3,VRNL(NB,NZ,NY,NX),VRNF(NB,NZ,NY,NX),VRNX(NB,NZ,NY,NX)
2322  FORMAT(A8,10I4,20E12.4)
C     ENDIF
      IF((ISTYP(NZ,NY,NX).EQ.0.AND.IFLGI(NZ,NY,NX).EQ.0)
     2.OR.(VRNS(NB1(NZ,NY,NX),NZ,NY,NX).GE.VRNL(NB,NZ,NY,NX)
     3.AND.VRNF(NB,NZ,NY,NX).LT.FVRN*VRNX(NB,NZ,NY,NX)))THEN
      WTRTM=0.0
      CPOOLM=0.0
      DO 4 L=NU(NY,NX),NI(NZ,NY,NX)
      WTRTM=WTRTM+AMAX1(0.0,WTRTD(1,L,NZ,NY,NX))
      CPOOLM=CPOOLM+AMAX1(0.0,CPOOLR(1,L,NZ,NY,NX))
4     CONTINUE
C
C     RESET TIME COUNTER
C
      IF(IFLGA(NB,NZ,NY,NX).EQ.0)THEN
      ATRP(NB,NZ,NY,NX)=0.0
      IFLGA(NB,NZ,NY,NX)=1
      ENDIF
C
C     INCREMENT TIME COUNTER
C
      IF(NB.EQ.NB1(NZ,NY,NX))THEN
      IF(IPTYP(NZ,NY,NX).EQ.2
     2.AND.(IWTYP(NZ,NY,NX).EQ.1.OR.IWTYP(NZ,NY,NX).EQ.3))THEN
      PPDX=AMAX1(0.0,XDL(NZ,NY,NX)-XPPD(NZ,NY,NX)-DYLN(NY,NX))
      ATRPPD=EXP(-0.0*PPDX)
      ELSE
      ATRPPD=1.0
      ENDIF
      DATRP=ATRPPD*TFN3(NZ,NY,NX)*WFNSG 
      ATRP(NB,NZ,NY,NX)=ATRP(NB,NZ,NY,NX)+DATRP
C     IF(NZ.EQ.1)THEN
C     WRITE(*,2323)'ATRP',I,J,NX,NY,NZ,NB,ATRP(NB,NZ,NY,NX),DATRP
C    2,ATRPPD,TFN3(NZ,NY,NX),WFNSG,PPDX,XDL(NZ,NY,NX),XPPD(NZ,NY,NX) 
C    3,DYLN(NY,NX),WTLFB(NB,NZ,NY,NX),ARLFB(NB,NZ,NY,NX),HTCTL(NZ,NY,NX)
2323  FORMAT(A8,6I4,20E12.4)
C     ENDIF
      IF(ATRP(NB,NZ,NY,NX).LE.ATRPX
     2.OR.(ISTYP(NZ,NY,NX).EQ.0.AND.IWTYP(NZ,NY,NX).EQ.0))THEN
      IF(WTRVC(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      CPOOLT=CPOOLM+CPOOL(NB,NZ,NY,NX)
C
C     REMOBILIZE C FROM SEASONAL STORAGE AT FIRST-ORDER RATE
C     MODIFIED BY SOIL TEMPERATURE AT SEED DEPTH
C
      GFNX=VMXS(ISTYP(NZ,NY,NX),IWTYP(NZ,NY,NX))*DATRP
      CH2OH=AMAX1(0.0,GFNX*WTRVC(NZ,NY,NX))
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,2123)'GERM0',I,J,NX,NY,NZ,NB,GFNX,CH2OH,WTRVC(NZ,NY,NX)
C    2,CPOOL(NB,NZ,NY,NX),CPOOLR(1,NG(NZ,NY,NX),NZ,NY,NX)
C    3,FXSH(ISTYP(NZ,NY,NX)),FXRT(ISTYP(NZ,NY,NX))
2123  FORMAT(A8,6I4,20E12.4)
C     ENDIF
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)-CH2OH
      CPOOL(NB,NZ,NY,NX)=CPOOL(NB,NZ,NY,NX)
     2+CH2OH*FXSH(ISTYP(NZ,NY,NX))
      IF(WTRTM.GT.ZEROP(NZ,NY,NX).AND.CPOOLM.GT.ZEROP(NZ,NY,NX))THEN
      DO 50 L=NU(NY,NX),NI(NZ,NY,NX)
      FXFC=AMAX1(0.0,WTRTD(1,L,NZ,NY,NX))/WTRTM
      CPOOLR(1,L,NZ,NY,NX)=CPOOLR(1,L,NZ,NY,NX)
     2+FXFC*CH2OH*FXRT(ISTYP(NZ,NY,NX))
50    CONTINUE
      ELSE
      CPOOLR(1,NG(NZ,NY,NX),NZ,NY,NX)=CPOOLR(1,NG(NZ,NY,NX),NZ,NY,NX)
     2+CH2OH*FXRT(ISTYP(NZ,NY,NX))
      ENDIF
      ELSE
      CH2OH=0.0
      ENDIF
      ELSE
      CH2OH=0.0
      ENDIF
C
C     REMOBILIZE N,P FROM SEASONAL STORAGE AT FIRST-ORDER RATE
C     MODIFIED BY SOIL TEMPERATURE AT SEED DEPTH
C
      IF(WTRVC(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      IF(ISTYP(NZ,NY,NX).NE.0)THEN
      CPOOLT=AMAX1(0.0,WTRVC(NZ,NY,NX)+CPOOL(NB,NZ,NY,NX))
      ZPOOLD=(WTRVN(NZ,NY,NX)*CPOOL(NB,NZ,NY,NX)
     2-ZPOOL(NB,NZ,NY,NX)*WTRVC(NZ,NY,NX))/CPOOLT
      PPOOLD=(WTRVP(NZ,NY,NX)*CPOOL(NB,NZ,NY,NX)
     2-PPOOL(NB,NZ,NY,NX)*WTRVC(NZ,NY,NX))/CPOOLT
      UPNH4B=AMAX1(0.0,FRSV(IBTYP(NZ,NY,NX))*ZPOOLD)
      UPPO4B=AMAX1(0.0,FRSV(IBTYP(NZ,NY,NX))*PPOOLD)
      ELSE
      UPNH4B=AMAX1(0.0,FXSH(ISTYP(NZ,NY,NX))
     2*CH2OH*WTRVN(NZ,NY,NX)/WTRVC(NZ,NY,NX))
      UPPO4B=AMAX1(0.0,FXSH(ISTYP(NZ,NY,NX))
     2*CH2OH*WTRVP(NZ,NY,NX)/WTRVC(NZ,NY,NX))
      ENDIF
      ELSE
      UPNH4B=AMAX1(0.0,FXSH(ISTYP(NZ,NY,NX))*WTRVN(NZ,NY,NX))
      UPPO4B=AMAX1(0.0,FXSH(ISTYP(NZ,NY,NX))*WTRVP(NZ,NY,NX))
      ENDIF
C
C     ADD TO NON-STRUCTURAL POOLS IN ROOT
C
      CPOOLM=0.0
      ZPOOLM=0.0
      PPOOLM=0.0
      DO 3 L=NU(NY,NX),NI(NZ,NY,NX)
      CPOOLM=CPOOLM+AMAX1(0.0,CPOOLR(1,L,NZ,NY,NX))
      ZPOOLM=ZPOOLM+AMAX1(0.0,ZPOOLR(1,L,NZ,NY,NX))
      PPOOLM=PPOOLM+AMAX1(0.0,PPOOLR(1,L,NZ,NY,NX))
3     CONTINUE
      IF(WTRVC(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      IF(ISTYP(NZ,NY,NX).NE.0)THEN
      CPOOLT=AMAX1(ZEROP(NZ,NY,NX),WTRVC(NZ,NY,NX)+CPOOLM)
      ZPOOLD=(WTRVN(NZ,NY,NX)*CPOOLM
     2-ZPOOLM*WTRVC(NZ,NY,NX))/CPOOLT
      PPOOLD=(WTRVP(NZ,NY,NX)*CPOOLM
     2-PPOOLM*WTRVC(NZ,NY,NX))/CPOOLT
      UPNH4R=AMAX1(0.0,FRSV(IBTYP(NZ,NY,NX))*ZPOOLD)
      UPPO4R=AMAX1(0.0,FRSV(IBTYP(NZ,NY,NX))*PPOOLD)
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,9878)'GERM1',I,J,NZ,UPNH4R,FRSV(IBTYP(NZ,NY,NX))
C    2,ZPOOLD,WTRVN(NZ,NY,NX),CPOOLM,ZPOOLM,WTRVC(NZ,NY,NX)
C    3,CPOOLT 
9878  FORMAT(A8,3I4,12E24.16)
C     ENDIF
      ELSE
      UPNH4R=AMAX1(0.0,FXRT(ISTYP(NZ,NY,NX))
     2*CH2OH*WTRVN(NZ,NY,NX)/WTRVC(NZ,NY,NX))
      UPPO4R=AMAX1(0.0,FXRT(ISTYP(NZ,NY,NX))
     2*CH2OH*WTRVP(NZ,NY,NX)/WTRVC(NZ,NY,NX))
      ENDIF
      ELSE
      UPNH4R=AMAX1(0.0,FXRT(ISTYP(NZ,NY,NX))*WTRVN(NZ,NY,NX))
      UPPO4R=AMAX1(0.0,FXRT(ISTYP(NZ,NY,NX))*WTRVP(NZ,NY,NX))
      ENDIF
C
C     TRANSFER STORAGE FLUXES
C
      WTRVN(NZ,NY,NX)=WTRVN(NZ,NY,NX)-UPNH4B-UPNH4R
      WTRVP(NZ,NY,NX)=WTRVP(NZ,NY,NX)-UPPO4B-UPPO4R
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)+UPNH4B
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)+UPPO4B
      IF(WTRTM.GT.ZEROP(NZ,NY,NX)
     2.AND.CPOOLM.GT.ZEROP(NZ,NY,NX))THEN
      DO 51 L=NU(NY,NX),NI(NZ,NY,NX)
      FXFN=AMAX1(0.0,CPOOLR(1,L,NZ,NY,NX))/CPOOLM
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,9879)'GERM2',I,J,NZ,L,UPNH4R,FXFN
C    2,ZPOOLR(1,L,NZ,NY,NX),CPOOLR(1,L,NZ,NY,NX),CPOOLM
9879  FORMAT(A8,4I4,12E24.16)
C     ENDIF
      ZPOOLR(1,L,NZ,NY,NX)=ZPOOLR(1,L,NZ,NY,NX)+FXFN*UPNH4R
      PPOOLR(1,L,NZ,NY,NX)=PPOOLR(1,L,NZ,NY,NX)+FXFN*UPPO4R
51    CONTINUE
      ELSE
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,9879)'GERM3',I,J,NZ,L,UPNH4R,FXFN
C    2,ZPOOLR(1,L,NZ,NY,NX),CPOOLR(1,L,NZ,NY,NX),CPOOLM
C     ENDIF
      ZPOOLR(1,NG(NZ,NY,NX),NZ,NY,NX)=ZPOOLR(1,NG(NZ,NY,NX),NZ,NY,NX)
     2+UPNH4R
      PPOOLR(1,NG(NZ,NY,NX),NZ,NY,NX)=PPOOLR(1,NG(NZ,NY,NX),NZ,NY,NX)
     2+UPPO4R
      ENDIF
      ENDIF
C
C     REDISTRIBUTE TRANFERRED C FROM MAIN STEM TO OTHER BRANCHES
C
      IF(NB.NE.NB1(NZ,NY,NX).AND.ATRP(NB,NZ,NY,NX).LE.ATRPX)THEN
      ATRP(NB,NZ,NY,NX)=ATRP(NB,NZ,NY,NX)+TFN3(NZ,NY,NX)*WFNG 
      XFRC=AMAX1(0.0,0.05*TFN3(NZ,NY,NX)
     2*(0.5*(CPOOL(NB1(NZ,NY,NX),NZ,NY,NX)+CPOOL(NB,NZ,NY,NX))
     3-CPOOL(NB,NZ,NY,NX)))
      XFRN=AMAX1(0.0,0.05*TFN3(NZ,NY,NX)
     2*(0.5*(ZPOOL(NB1(NZ,NY,NX),NZ,NY,NX)+ZPOOL(NB,NZ,NY,NX))
     2-ZPOOL(NB,NZ,NY,NX)))
      XFRP=AMAX1(0.0,0.05*TFN3(NZ,NY,NX)
     2*(0.5*(PPOOL(NB1(NZ,NY,NX),NZ,NY,NX)+PPOOL(NB,NZ,NY,NX))
     3-PPOOL(NB,NZ,NY,NX)))
      CPOOL(NB,NZ,NY,NX)=CPOOL(NB,NZ,NY,NX)+XFRC
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)+XFRN
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)+XFRP
      CPOOL(NB1(NZ,NY,NX),NZ,NY,NX)=CPOOL(NB1(NZ,NY,NX),NZ,NY,NX)-XFRC
      ZPOOL(NB1(NZ,NY,NX),NZ,NY,NX)=ZPOOL(NB1(NZ,NY,NX),NZ,NY,NX)-XFRN
      PPOOL(NB1(NZ,NY,NX),NZ,NY,NX)=PPOOL(NB1(NZ,NY,NX),NZ,NY,NX)-XFRP
      ENDIF
      ENDIF
C
C     TRANSFER LEAF AND STALK NON-STRUCTURAL C,N,P TO SEASONAL STORAGE
C     IN PERENNIALS AFTER GRAIN FILL IN DETERMINATES, AFTER AUTUMNIZ'N
C     IN INDETERMINATES, OR AFTER SUSTAINED WATER STRESS 
C
      IF(IFLGZ.EQ.1.AND.ISTYP(NZ,NY,NX).NE.0)THEN
      IF(WVSTKB(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.WTRSVB(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      CWTRSV=AMAX1(0.0,WTRSVB(NB,NZ,NY,NX)/WVSTKB(NB,NZ,NY,NX))
      CWTRSN=AMAX1(0.0,WTRSBN(NB,NZ,NY,NX)/WVSTKB(NB,NZ,NY,NX))
      CWTRSP=AMAX1(0.0,WTRSBP(NB,NZ,NY,NX)/WVSTKB(NB,NZ,NY,NX))
      CNR=CWTRSV/(CWTRSV+CWTRSN/ZSKI)
      CPR=CWTRSV/(CWTRSV+CWTRSP/PSKI)
      ELSE
      CNR=0.0
      CPR=0.0
      ENDIF
      XFRCX=FXFB(IBTYP(NZ,NY,NX),IWTYP(NZ,NY,NX))
     2*AMAX1(0.0,WTRSVB(NB,NZ,NY,NX))
      XFRNX=FXFB(IBTYP(NZ,NY,NX),IWTYP(NZ,NY,NX))
     2*AMAX1(0.0,WTRSBN(NB,NZ,NY,NX))*(1.0+CNR)
      XFRPX=FXFB(IBTYP(NZ,NY,NX),IWTYP(NZ,NY,NX))
     2*AMAX1(0.0,WTRSBP(NB,NZ,NY,NX))*(1.0+CPR)
      XFRC=AMIN1(XFRCX,XFRNX/CNMN,XFRPX/CPMN)
      XFRN=AMIN1(XFRNX,XFRC*CNMX,XFRPX*CNMX/CPMN*0.5)
      XFRP=AMIN1(XFRPX,XFRC*CPMX,XFRNX*CPMX/CNMN*0.5)
      WTRSVB(NB,NZ,NY,NX)=WTRSVB(NB,NZ,NY,NX)-XFRC
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)+XFRC
      WTRSBN(NB,NZ,NY,NX)=WTRSBN(NB,NZ,NY,NX)-XFRN
      WTRVN(NZ,NY,NX)=WTRVN(NZ,NY,NX)+XFRN
      WTRSBP(NB,NZ,NY,NX)=WTRSBP(NB,NZ,NY,NX)-XFRP
      WTRVP(NZ,NY,NX)=WTRVP(NZ,NY,NX)+XFRP
      IF(CPOOL(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      CNL=CCPOLB(NB,NZ,NY,NX)/(CCPOLB(NB,NZ,NY,NX)
     2+CZPOLB(NB,NZ,NY,NX)/ZSKI)
      CPL=CCPOLB(NB,NZ,NY,NX)/(CCPOLB(NB,NZ,NY,NX)
     2+CPPOLB(NB,NZ,NY,NX)/PSKI)
      ELSE
      CNL=0.0
      CPL=0.0
      ENDIF
      XFRCX=FXFB(IBTYP(NZ,NY,NX),IWTYP(NZ,NY,NX))
     2*AMAX1(0.0,CPOOL(NB,NZ,NY,NX))
      XFRNX=FXFB(IBTYP(NZ,NY,NX),IWTYP(NZ,NY,NX))
     2*AMAX1(0.0,ZPOOL(NB,NZ,NY,NX))*(1.0+CNL)
      XFRPX=FXFB(IBTYP(NZ,NY,NX),IWTYP(NZ,NY,NX))
     2*AMAX1(0.0,PPOOL(NB,NZ,NY,NX))*(1.0+CPL)
      XFRC=AMIN1(XFRCX,XFRNX/CNMN,XFRPX/CPMN)
      XFRN=AMIN1(XFRNX,XFRC*CNMX,XFRPX*CNMX/CPMN*0.5)
      XFRP=AMIN1(XFRPX,XFRC*CPMX,XFRNX*CPMX/CNMN*0.5)
      CPOOL(NB,NZ,NY,NX)=CPOOL(NB,NZ,NY,NX)-XFRC
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)+XFRC
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)-XFRN
      WTRVN(NZ,NY,NX)=WTRVN(NZ,NY,NX)+XFRN
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)-XFRP
      WTRVP(NZ,NY,NX)=WTRVP(NZ,NY,NX)+XFRP
C     IF(NZ.EQ.1)THEN
C     WRITE(*,4490)'RSV',I,J,NZ,NB,XFRC,XFRN,WTRSVB(NB,NZ,NY,NX)
C    2,WTRSBN(NB,NZ,NY,NX),WTRVC(NZ,NY,NX),WTRVN(NZ,NY,NX)
C    3,CNR,CNL,CPOOL(NB,NZ,NY,NX),ZPOOL(NB,NZ,NY,NX)
C    4,FXFB(IBTYP(NZ,NY,NX),IWTYP(NZ,NY,NX))
4490  FORMAT(A8,4I4,20E12.4)
C     ENDIF
      ENDIF
C
C     TRANSFER NON-STRUCTURAL C,N,P FROM LEAVES AND ROOTS TO RESERVES
C     IN STALKS DURING GRAIN FILL IN ANNUALS OR BETWEEN STALK RESERVES
C     AND LEAVES IN PERENNIALS ACCORDING TO CONCENTRATION DIFFERENCES
C
      IF(IDAY(3,NB,NZ,NY,NX).NE.0)THEN
      IF(ISTYP(NZ,NY,NX).EQ.0.AND.IDAY(8,NB,NZ,NY,NX).NE.0)THEN
      NS=0
      ELSE
      NS=1
      ENDIF
      WTPLTT=WTLSB(NB,NZ,NY,NX)+WVSTKB(NB,NZ,NY,NX)
      CPOOLT=CPOOL(NB,NZ,NY,NX)+WTRSVB(NB,NZ,NY,NX)
      IF(WTPLTT.GT.ZEROP(NZ,NY,NX))THEN
      CPOOLD=(CPOOL(NB,NZ,NY,NX)*WVSTKB(NB,NZ,NY,NX)
     2-WTRSVB(NB,NZ,NY,NX)*WTLSB(NB,NZ,NY,NX))/WTPLTT 
      XFRC=FXFV(NS)*CPOOLD
      CPOOL(NB,NZ,NY,NX)=CPOOL(NB,NZ,NY,NX)-XFRC
      WTRSVB(NB,NZ,NY,NX)=WTRSVB(NB,NZ,NY,NX)+XFRC
      ENDIF
      IF(CPOOLT.GT.ZEROP(NZ,NY,NX))THEN
      ZPOOLD=(ZPOOL(NB,NZ,NY,NX)*WTRSVB(NB,NZ,NY,NX)
     2-WTRSBN(NB,NZ,NY,NX)*CPOOL(NB,NZ,NY,NX))/CPOOLT 
      PPOOLD=(PPOOL(NB,NZ,NY,NX)*WTRSVB(NB,NZ,NY,NX)
     2-WTRSBP(NB,NZ,NY,NX)*CPOOL(NB,NZ,NY,NX))/CPOOLT 
      XFRN=FXFZ(NS)*ZPOOLD 
      XFRP=FXFZ(NS)*PPOOLD 
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)-XFRN
      WTRSBN(NB,NZ,NY,NX)=WTRSBN(NB,NZ,NY,NX)+XFRN
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)-XFRP
      WTRSBP(NB,NZ,NY,NX)=WTRSBP(NB,NZ,NY,NX)+XFRP
      ENDIF
C     IF(NZ.EQ.1)THEN
C     WRITE(*,4488)'EXCHC',I,J,NX,NY,NZ,NB,NS,XFRC,XFRN
C    2,FXFV(NS),WTRSVB(NB,NZ,NY,NX),CPOOL(NB,NZ,NY,NX) 
C    3,WVSTKB(NB,NZ,NY,NX),WTLSB(NB,NZ,NY,NX) 
C    4,CPOOLT,CPOOLD,ZPOOL(NB,NZ,NY,NX),WTRSBN(NB,NZ,NY,NX)
4488  FORMAT(A8,7I4,12E12.4)
C     ENDIF
      IF(NS.EQ.0)THEN
      DO 2050 L=NU(NY,NX),NI(NZ,NY,NX)
      WTRTRX=AMAX1(ZEROP(NZ,NY,NX),WTRTL(1,L,NZ,NY,NX)*FWOOD(1))
      WTPLTX=WTRTRX+WVSTKB(NB,NZ,NY,NX)
      IF(WTPLTX.GT.ZEROP(NZ,NY,NX))THEN
      CPOOLD=(CPOOLR(1,L,NZ,NY,NX)*WVSTKB(NB,NZ,NY,NX)
     2-WTRSVB(NB,NZ,NY,NX)*WTRTRX)/WTPLTX 
      XFRC=FXFV(NS)*CPOOLD
      CPOOLR(1,L,NZ,NY,NX)=CPOOLR(1,L,NZ,NY,NX)-XFRC
      WTRSVB(NB,NZ,NY,NX)=WTRSVB(NB,NZ,NY,NX)+XFRC
      CPOOLT=CPOOLR(1,L,NZ,NY,NX)+WTRSVB(NB,NZ,NY,NX)
      IF(CPOOLT.GT.ZEROP(NZ,NY,NX))THEN
      ZPOOLD=(ZPOOLR(1,L,NZ,NY,NX)*WTRSVB(NB,NZ,NY,NX)
     2-WTRSBN(NB,NZ,NY,NX)*CPOOLR(1,L,NZ,NY,NX))/CPOOLT 
      PPOOLD=(PPOOLR(1,L,NZ,NY,NX)*WTRSVB(NB,NZ,NY,NX)
     2-WTRSBP(NB,NZ,NY,NX)*CPOOLR(1,L,NZ,NY,NX))/CPOOLT 
      XFRN=FXFZ(NS)*ZPOOLD 
      XFRP=FXFZ(NS)*PPOOLD 
      ZPOOLR(1,L,NZ,NY,NX)=ZPOOLR(1,L,NZ,NY,NX)-XFRN
      WTRSBN(NB,NZ,NY,NX)=WTRSBN(NB,NZ,NY,NX)+XFRN
      PPOOLR(1,L,NZ,NY,NX)=PPOOLR(1,L,NZ,NY,NX)-XFRP
      WTRSBP(NB,NZ,NY,NX)=WTRSBP(NB,NZ,NY,NX)+XFRP
C     IF(NZ.EQ.1)THEN
C     WRITE(*,4489)'EXCHC',I,J,NZ,NB,L,WTRSVB(NB,NZ,NY,NX)
C    2,WVSTKB(NB,NZ,NY,NX),CPOOLR(1,L,NZ,NY,NX) 
C    3,WTRTL(1,L,NZ,NY,NX),FWOOD(1),WTRTRX,WTPLTX
C    4,CPOOLT,CPOOLD,XFRC,FXFV(NS) 
4489  FORMAT(A8,5I4,12E16.8)
C     ENDIF
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,4489)'EXCHN',I,J,NZ,NB,L,WTRSBN(NB,NZ,NY,NX)
C    2,WTRSVB(NB,NZ,NY,NX),ZPOOLR(1,L,NZ,NY,NX) 
C    3,CPOOLR(1,L,NZ,NY,NX),FWOOD(1),ZPOOLD,XFRN
C     ENDIF
      ENDIF
      ENDIF
2050  CONTINUE
      ENDIF
      ENDIF
C
C     REPLENISH BRANCH NON-STRUCTURAL POOL FROM
C     SEASONAL STORAGE POOL
C
      IF(WVSTKB(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.WVSTK(NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     3.AND.WTRT(NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     4.AND.WTRSVB(NB,NZ,NY,NX).LE.XFRX*WVSTKB(NB,NZ,NY,NX))THEN
      FWTBR=WVSTKB(NB,NZ,NY,NX)/WVSTK(NZ,NY,NX)
      WVSTBX=WVSTKB(NB,NZ,NY,NX)
      WTRTTX=WTRT(NZ,NY,NX)*FWTBR
      WTPLTT=WVSTBX+WTRTTX
      WTRSBX=AMAX1(0.0,WTRSVB(NB,NZ,NY,NX))
      WTRVCX=AMAX1(0.0,WTRVC(NZ,NY,NX)*FWTBR)
      CPOOLD=(WTRVCX*WVSTBX-WTRSBX*WTRTTX)/WTPLTT 
      XFRC=AMAX1(0.0,XFRY*CPOOLD) 
      WTRSVB(NB,NZ,NY,NX)=WTRSVB(NB,NZ,NY,NX)+XFRC
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)-XFRC
      ENDIF
C
C     CANOPY N2 FIXATION (CYANOBACTERIA)
C
      IF(INTYP(NZ,NY,NX).GE.3)THEN
C
C     INITIAL INFECTION
C
      IF(WTNDB(NB,NZ,NY,NX).LE.0.0)THEN
      WTNDB(NB,NZ,NY,NX)=WTNDB(NB,NZ,NY,NX)
     2+WTNDI*AREA(3,NU(NY,NX),NY,NX)
      WTNDBN(NB,NZ,NY,NX)=WTNDBN(NB,NZ,NY,NX)
     2+WTNDI*AREA(3,NU(NY,NX),NY,NX)*CNND(NZ,NY,NX)
      WTNDBP(NB,NZ,NY,NX)=WTNDBP(NB,NZ,NY,NX)
     2+WTNDI*AREA(3,NU(NY,NX),NY,NX)*CPND(NZ,NY,NX)
      ENDIF
C
C     O2-UNCONSTRAINED RESPIRATION RATES BY HETEROTROPHIC AEROBES
C     IN NODULE FROM SPECIFIC OXIDATION RATE, ACTIVE BIOMASS,
C     NON-STRUCTURAL C CONCENTRATION, MICROBIAL C:N:P FACTOR,
C     AND TEMPERATURE
C
      IF(WTNDB(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      CCPOLN=AMAX1(0.0,CPOLNB(NB,NZ,NY,NX)/WTNDB(NB,NZ,NY,NX))
      CZPOLN=AMAX1(0.0,ZPOLNB(NB,NZ,NY,NX)/WTNDB(NB,NZ,NY,NX))
      CPPOLN=AMAX1(0.0,PPOLNB(NB,NZ,NY,NX)/WTNDB(NB,NZ,NY,NX))
      ELSE
      CCPOLN=1.0
      CZPOLN=1.0
      CPPOLN=1.0
      ENDIF
      IF(CCPOLN.GT.ZERO)THEN 
      CCC=AMIN1(CZPOLN/(CZPOLN+CCPOLN/CNKI)
     2,CPPOLN/(CPPOLN+CCPOLN/CPKI))
      CNC=CCPOLN/(CCPOLN+CZPOLN/ZSKI)
      CPC=CCPOLN/(CCPOLN+CPPOLN/PSKI)
      CNF=CCPOLN/(CCPOLN+CZPOLN/ZSKF)
      ELSE
      CCC=0.0
      CNC=0.0
      CPC=0.0
      CNF=0.0
      ENDIF
      IF(WTNDB(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FCNPF=AMIN1(1.0,AMAX1(0.0
     2,WTNDBN(NB,NZ,NY,NX)/(WTNDB(NB,NZ,NY,NX)*CNND(NZ,NY,NX))
     3,WTNDBP(NB,NZ,NY,NX)/(WTNDB(NB,NZ,NY,NX)*CPND(NZ,NY,NX))))
      ELSE
      FCNPF=1.0
      ENDIF
      RDNDBX=CCPOLN/(CCPOLN+CCNKX)
      RCNDL=AMAX1(0.0,AMIN1(CPOLNB(NB,NZ,NY,NX)*(1.0-DMND(NZ,NY,NX))
     2,VMXO*WTNDB(NB,NZ,NY,NX)*CCPOLN/(CCPOLN+CCNKM) 
     3*TFN3(NZ,NY,NX)*FCNPF*WFNG))*CNF 
C
C     NODULE MAINTENANCE RESPIRATION FROM SOIL TEMPERATURE,
C     NODULE STRUCTURAL N
C
      RMNDL=AMAX1(0.0,RMPLT*TFN5*WTNDBN(NB,NZ,NY,NX))*RDNDBX 
C
C     NODULE GROWTH RESPIRATION FROM TOTAL - MAINTENANCE
C     IF > 0 DRIVES GROWTH, IF < 0 DRIVES REMOBILIZATION
C
      RXNDL=RCNDL-RMNDL
      RGNDL=AMAX1(0.0,RXNDL) 
      RSNDL=AMAX1(0.0,-RXNDL)
C
C     NODULE N2 FIXATION FROM GROWTH RESPIRATION, FIXATION ENERGY
C     REQUIREMENT AND NON-STRUCTURAL C:N:P PRODUCT INHIBITION,
C     CONSTRAINED BY MICROBIAL N REQUIREMENT
C
      RGN2P=AMAX1(0.0,WTNDB(NB,NZ,NY,NX)*CNND(NZ,NY,NX)
     2-WTNDBN(NB,NZ,NY,NX))/EN2F 
      RGN2F=AMIN1(RGNDL,RGN2P)
      RUPNFB=RGN2F*EN2F
      UPNFC(NZ,NY,NX)=UPNFC(NZ,NY,NX)+RUPNFB 
C
C     TOTAL NON-STRUCTURAL C,N,P USED IN NODULE GROWTH
C     AND GROWTH RESPIRATION DEPENDS ON GROWTH YIELD ENTERED IN 'READQ'
C
      CGNDL=(RGNDL-RGN2F)/(1.0-DMND(NZ,NY,NX))
      GRNDG=CGNDL*DMND(NZ,NY,NX)
      ZADDN=AMAX1(0.0,AMIN1(ZPOLNB(NB,NZ,NY,NX)
     2,GRNDG*CNND(NZ,NY,NX))*CCC)
      PADDN=AMAX1(0.0,AMIN1(PPOLNB(NB,NZ,NY,NX)
     2,GRNDG*CPND(NZ,NY,NX))*CCC)
C
C     NODULE C,N,P REMOBILIZATION AND DECOMPOSITION AND LEAKAGE 
C
      RCCC=RCCZ+CCC*RCCY
      RCCN=CNC*RCCX(IGTYP(NZ,NY,NX))
      RCCP=CPC*RCCQ(IGTYP(NZ,NY,NX))
      SPNDX=SPNDL*RDNDBX 
      RXNDLC=SPNDX*WTNDB(NB,NZ,NY,NX)*WFNG 
      RXNDLN=SPNDX*WTNDBN(NB,NZ,NY,NX)*WFNG 
      RXNDLP=SPNDX*WTNDBP(NB,NZ,NY,NX)*WFNG 
      RDNDLC=RXNDLC*(1.0-RCCC)
      RDNDLN=RXNDLN*(1.0-RCCC)
      RDNDLP=RXNDLP*(1.0-RCCC)
      RCNDLC=RXNDLC*RCCC
      RCNDLN=RXNDLN*RCCC
      RCNDLP=RXNDLP*RCCC
C
C     NODULE SENESCENCE
C
      IF(RSNDL.GT.0.0.AND.WTNDB(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.RCCC.GT.ZERO)THEN
      RXNSNC=RSNDL/RCCC
      RXNSNN=RXNSNC*WTNDBN(NB,NZ,NY,NX)/WTNDB(NB,NZ,NY,NX)
      RXNSNP=RXNSNC*WTNDBP(NB,NZ,NY,NX)/WTNDB(NB,NZ,NY,NX)
      RDNSNC=RXNSNC*(1.0-RCCC)
      RDNSNN=RXNSNN*(1.0-RCCN)
      RDNSNP=RXNSNP*(1.0-RCCP)
      RCNSNC=RXNSNC*RCCC
      RCNSNN=RXNSNN*RCCN
      RCNSNP=RXNSNP*RCCP
      ELSE
      RXNSNC=0.0
      RXNSNN=0.0
      RXNSNP=0.0
      RDNSNC=0.0
      RDNSNN=0.0
      RDNSNP=0.0
      RCNSNC=0.0
      RCNSNN=0.0
      RCNSNP=0.0
      ENDIF
C
C     TOTAL NODULE RESPIRATION
C
      RCO2T=AMIN1(RMNDL,RCNDL)+RGNDL+RCNSNC 
      TCSNR(NZ,NY,NX)=TCSNR(NZ,NY,NX)-RCO2T
      TCO2A(NZ,NY,NX)=TCO2A(NZ,NY,NX)-RCO2T
      CNET(NZ,NY,NX)=CNET(NZ,NY,NX)-RCO2T
      RECO(NY,NX)=RECO(NY,NX)-RCO2T
      TRAU(NY,NX)=TRAU(NY,NX)-RCO2T
C
C     NODULE LITTERFALL CAUSED BY REMOBILIZATION
C
      DO 6470 M=1,4
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)+CFOPC(1,M,NZ,NY,NX)
     2*(RDNDLC+RDNSNC) 
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)+CFOPN(1,M,NZ,NY,NX)
     2*(RDNDLN+RDNSNN)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)+CFOPP(1,M,NZ,NY,NX)
     2*(RDNDLP+RDNSNP) 
6470  CONTINUE
C
C     CONSUMPTION OF NON-STRUCTURAL C,N,P BY NODULE
C
      CPOLNB(NB,NZ,NY,NX)=CPOLNB(NB,NZ,NY,NX)-AMIN1(RMNDL,RCNDL)
     2-RGN2F-CGNDL+RCNDLC 
      ZPOLNB(NB,NZ,NY,NX)=ZPOLNB(NB,NZ,NY,NX)-ZADDN+RCNDLN+RCNSNN
     2+RUPNFB 
      PPOLNB(NB,NZ,NY,NX)=PPOLNB(NB,NZ,NY,NX)-PADDN+RCNDLP+RCNSNP
C
C     UPDATE STATE VARIABLES FOR NODULE C, N, P
C
      WTNDB(NB,NZ,NY,NX)=WTNDB(NB,NZ,NY,NX)+GRNDG-RXNDLC-RXNSNC
      WTNDBN(NB,NZ,NY,NX)=WTNDBN(NB,NZ,NY,NX)+ZADDN-RXNDLN-RXNSNN
      WTNDBP(NB,NZ,NY,NX)=WTNDBP(NB,NZ,NY,NX)+PADDN-RXNDLP-RXNSNP
C
C     TRANSFER NON-STRUCTURAL C,N,P BETWEEN BRANCH AND NODULES
C     FROM NON-STRUCTURAL C,N,P CONCENTRATION DIFFERENCES
C
      IF(CPOOL(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.WTLSB(NB,NZ,NY,NX).GT.ZEROL(NZ,NY,NX))THEN
      WTLSB1=WTLSB(NB,NZ,NY,NX)
      WTNDB1=AMIN1(WTLSB(NB,NZ,NY,NX),WTNDB(NB,NZ,NY,NX))
      WTLSBT=WTLSB1+WTNDB1
      IF(WTLSBT.GT.ZEROP(NZ,NY,NX))THEN
      CPOOLD=(CPOOL(NB,NZ,NY,NX)*WTNDB1
     2-CPOLNB(NB,NZ,NY,NX)*WTLSB1)/WTLSBT
      XFRC=FXRN(INTYP(NZ,NY,NX))*CPOOLD 
      CPOOL(NB,NZ,NY,NX)=CPOOL(NB,NZ,NY,NX)-XFRC
      CPOLNB(NB,NZ,NY,NX)=CPOLNB(NB,NZ,NY,NX)+XFRC 
      CPOOLT=CPOOL(NB,NZ,NY,NX)+CPOLNB(NB,NZ,NY,NX)
      IF(CPOOLT.GT.ZEROP(NZ,NY,NX))THEN
      ZPOOLD=(ZPOOL(NB,NZ,NY,NX)*CPOLNB(NB,NZ,NY,NX)
     2-ZPOLNB(NB,NZ,NY,NX)*CPOOL(NB,NZ,NY,NX))/CPOOLT 
      XFRN=FXRN(INTYP(NZ,NY,NX))*ZPOOLD 
      PPOOLD=(PPOOL(NB,NZ,NY,NX)*CPOLNB(NB,NZ,NY,NX)
     2-PPOLNB(NB,NZ,NY,NX)*CPOOL(NB,NZ,NY,NX))/CPOOLT 
      XFRP=FXRN(INTYP(NZ,NY,NX))*PPOOLD 
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)-XFRN
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)-XFRP
      ZPOLNB(NB,NZ,NY,NX)=ZPOLNB(NB,NZ,NY,NX)+XFRN
      PPOLNB(NB,NZ,NY,NX)=PPOLNB(NB,NZ,NY,NX)+XFRP
C     IF((I/10)*10.EQ.I.AND.J.EQ.12.AND.NZ.EQ.4)THEN
C     WRITE(*,2121)'NODEX',I,J,NZ,NB,XFRC,XFRN,XFRP
C    3,WTLSB(NB,NZ,NY,NX),WTNDB(NB,NZ,NY,NX),CPOOLT
C    4,CPOLNB(NB,NZ,NY,NX),ZPOLNB(NB,NZ,NY,NX),PPOLNB(NB,NZ,NY,NX)
C    4,CPOOL(NB,NZ,NY,NX),ZPOOL(NB,NZ,NY,NX),PPOOL(NB,NZ,NY,NX)
C     ENDIF
      ENDIF
      ENDIF
      ENDIF
C     IF((I/10)*10.EQ.I.AND.J.EQ.12.AND.NY.EQ.5)THEN
C     WRITE(*,2121)'NODGR',I,J,NZ,NB,RCNDL,RMNDL,RGNDL,RGN2P 
C    2,RGN2F,CGNDL,SNCR,GRNDG,ZADDN,PADDN,FSNCN 
C    8,RDNDLC,RDNDLN,RDNDLP,RCCC,RCCN,RCCP,TFN5
C    3,WTNDB(NB,NZ,NY,NX),WTNDBN(NB,NZ,NY,NX),WTNDBP(NB,NZ,NY,NX) 
C    4,CPOLNB(NB,NZ,NY,NX),ZPOLNB(NB,NZ,NY,NX),PPOLNB(NB,NZ,NY,NX)
C    5,CCPOLN,CZPOLN,TFN3(NZ,NY,NX),CNF,FCNPF,WFNG
C    6,CPOLNB(NB,NZ,NY,NX)*(1.0-DMND(NZ,NY,NX))
C    6,VMXO*WTNDB(NB,NZ,NY,NX)*CCPOLN/(CCPOLN+CCNKM) 
2121  FORMAT(A8,4I4,60E12.4)
C     ENDIF
      ENDIF
      ENDIF


105   CONTINUE
C
C     ROOT GROWTH
C
      NIX(NZ,NY,NX)=NG(NZ,NY,NX)
      IDTHRN=0
C
C     FOR ROOTS (N=1) AND MYCORRHIZAE (N=2) IN EACH SOIL LAYER
C
      DO 4990 N=1,MY(NZ,NY,NX)
      DO 4990 L=NU(NY,NX),NI(NZ,NY,NX)
C
C     RESPIRATION FROM NUTRIENT UPTAKE CALCULATED IN 'UPTAKE':
C     ACTUAL, O2-UNLIMITED AND C-UNLIMITED
C
      CUPRL=0.86*(RUPNH4(N,L,NZ,NY,NX)+RUPNHB(N,L,NZ,NY,NX)
     2+RUPNO3(N,L,NZ,NY,NX)+RUPNOB(N,L,NZ,NY,NX)+RUPH2P(N,L,NZ,NY,NX)
     3+RUPH2B(N,L,NZ,NY,NX))
      CUPRO=0.86*(RUONH4(N,L,NZ,NY,NX)+RUONHB(N,L,NZ,NY,NX)
     2+RUONO3(N,L,NZ,NY,NX)+RUONOB(N,L,NZ,NY,NX)+RUOH2P(N,L,NZ,NY,NX)
     3+RUOH2B(N,L,NZ,NY,NX))
      CUPRC=0.86*(RUCNH4(N,L,NZ,NY,NX)+RUCNHB(N,L,NZ,NY,NX)
     2+RUCNO3(N,L,NZ,NY,NX)+RUCNOB(N,L,NZ,NY,NX)+RUCH2P(N,L,NZ,NY,NX)
     3+RUCH2B(N,L,NZ,NY,NX))
C
C     ACCUMULATE RESPIRATION IN FLUX ARRAYS
C
      RCO2M(N,L,NZ,NY,NX)=RCO2M(N,L,NZ,NY,NX)+CUPRO
      RCO2N(N,L,NZ,NY,NX)=RCO2N(N,L,NZ,NY,NX)+CUPRC
      RCO2A(N,L,NZ,NY,NX)=RCO2A(N,L,NZ,NY,NX)-CUPRL
      CPOOLR(N,L,NZ,NY,NX)=CPOOLR(N,L,NZ,NY,NX)-CUPRL
C
C     EXUDATION AND UPTAKE OF C, N AND P TO/FROM SOIL AND ROOT
C     OR MYCORRHIZAL NON-STRUCTURAL C,N,P POOLS
C
      CPOOLR(N,L,NZ,NY,NX)=CPOOLR(N,L,NZ,NY,NX)+RDFOMC(N,L,NZ,NY,NX)
      ZPOOLR(N,L,NZ,NY,NX)=ZPOOLR(N,L,NZ,NY,NX)+RDFOMN(N,L,NZ,NY,NX)
     2+RUPNH4(N,L,NZ,NY,NX)+RUPNHB(N,L,NZ,NY,NX)+RUPNO3(N,L,NZ,NY,NX)
     2+RUPNOB(N,L,NZ,NY,NX)
      PPOOLR(N,L,NZ,NY,NX)=PPOOLR(N,L,NZ,NY,NX)+RDFOMP(N,L,NZ,NY,NX)
     2+RUPH2P(N,L,NZ,NY,NX)+RUPH2B(N,L,NZ,NY,NX)
C     IF(L.EQ.1)THEN
C     WRITE(*,9881)'CUPNH4',I,J,NZ,L,N,CPOOLR(N,L,NZ,NY,NX)
C    2,ZPOOLR(N,L,NZ,NY,NX),PPOOLR(N,L,NZ,NY,NX),CUPRL
C    2,RDFOMC(N,L,NZ,NY,NX),RDFOMN(N,L,NZ,NY,NX),RDFOMP(N,L,NZ,NY,NX)
C    2,RUPNH4(N,L,NZ,NY,NX),RUPNHB(N,L,NZ,NY,NX),RUPNO3(N,L,NZ,NY,NX)
C    2,RUPNOB(N,L,NZ,NY,NX),RUPH2P(N,L,NZ,NY,NX),RUPH2B(N,L,NZ,NY,NX)
C    3,WFR(N,L,NZ,NY,NX)
9881  FORMAT(A8,5I4,30E24.16)
C     ENDIF
C
C     GROWTH OF EACH ROOT AXIS
C
      DO 4985 NR=1,NRT(NZ,NY,NX)
C
C     PRIMARY ROOT SINK STRENGTH FROM ROOT RADIUS AND ROOT DEPTH
C
      IF(N.EQ.1)THEN
      IF(RTDP1(N,NR,NZ,NY,NX).GT.CDPTHZ(L-1,NY,NX))THEN
      IF(RTDP1(N,NR,NZ,NY,NX).LE.CDPTHZ(L,NY,NX))THEN
      RTDPP=RTDP1(N,NR,NZ,NY,NX)+HTSTZ(NZ,NY,NX)
      RTSK1(N,L,NR)=XRTN1*RRAD1(N,L,NZ,NY,NX)**2/RTDPP
      RTNT(N)=RTNT(N)+RTSK1(N,L,NR)
      RLNT(N,L)=RLNT(N,L)+RTSK1(N,L,NR)
      ENDIF
      ENDIF
      ENDIF
C
C     SECONDARY ROOT SINK STRENGTH FROM ROOT RADIUS, ROOT AXIS NUMBER,
C     AND ROOT LENGTH IN SERIES WITH PRIMARY ROOT SINK STRENGTH
C
      IF(N.EQ.1)THEN
      RTDPL(NR,L)=AMAX1(0.0,RTDP1(1,NR,NZ,NY,NX)-CDPTHZ(L-1,NY,NX)
     2-RTDPX)
      RTDPL(NR,L)=AMAX1(0.0,AMIN1(DLYR(3,L,NY,NX),RTDPL(NR,L))
     2-AMAX1(0.0,SDPTH(NZ,NY,NX)-CDPTHZ(L-1,NY,NX)-HTCTL(NZ,NY,NX)))
      RTDPS=AMAX1(SDPTH(NZ,NY,NX),CDPTHZ(L-1,NY,NX))
     2+0.5*RTDPL(NR,L)+HTSTZ(NZ,NY,NX)
      IF(RTDPS.GT.ZERO)THEN
      RTSKP=PP(NZ,NY,NX)*RRAD1(N,L,NZ,NY,NX)**2/RTDPS
      RTSKS=RTN2(N,L,NR,NZ,NY,NX)*RRAD2(N,L,NZ,NY,NX)**2
     2/RTLGA(N,L,NZ,NY,NX)
      IF(RTSKP+RTSKS.GT.ZEROP(NZ,NY,NX))THEN
      RTSK2(N,L,NR)=RTSKP*RTSKS/(RTSKP+RTSKS)
      ELSE
      RTSK2(N,L,NR)=0.0
      ENDIF
      ELSE
      RTSK2(N,L,NR)=0.0
      ENDIF
      ELSE
      RTSK2(N,L,NR)=RTN2(N,L,NR,NZ,NY,NX)*RRAD2(N,L,NZ,NY,NX)**2
     2/RTLGA(N,L,NZ,NY,NX)
      ENDIF
      RTNT(N)=RTNT(N)+RTSK2(N,L,NR)
      RLNT(N,L)=RLNT(N,L)+RTSK2(N,L,NR)
C     IF(NZ.EQ.3)THEN
C     WRITE(*,3341)'SINK',I,J,NX,NY,NZ,L,NR,N
C    2,RTSK1(N,L,NR),RTSK2(N,L,NR),RLNT(N,L),RTNT(N)
C    3,XRTN1,PP(NZ,NY,NX),RRAD1(N,L,NZ,NY,NX),RTDPP
C    4,RTN2(N,L,NR,NZ,NY,NX),RRAD2(N,L,NZ,NY,NX)
C    2,RTLGA(N,L,NZ,NY,NX)
3341  FORMAT(A8,8I4,20E12.4)
C     ENDIF
4985  CONTINUE
4990  CONTINUE
C
C     RESPIRATION AND GROWTH OF ROOT, MYCORRHIZAE IN EACH LAYER
C
      DO 5010 N=1,MY(NZ,NY,NX)
      DO 5000 L=NU(NY,NX),NI(NZ,NY,NX)
C
C     WATER STRESS CONSTRAINT ON SECONDARY ROOT EXTENSION IMPOSED
C     BY ROOT TURGOR AND SOIL PENETRATION RESISTANCE
C
      RSCS2=RSCS(L,NY,NX)*RRAD2(N,L,NZ,NY,NX)/1.0E-03
      WFNR=AMIN1(1.0,AMAX1(0.0,PSIRG(N,L,NZ,NY,NX)-PSILM-RSCS2))
      WFNRG=WFNR**0.25
      WFNGR(N,L)=EXP(0.10*PSIRT(N,L,NZ,NY,NX))
      DMRTD=1.0-DMRT(NZ,NY,NX)
      RTLGL=0.0
      RTLGZ=0.0
      WTRTX=0.0
      WTRTZ=0.0
C
C     FOR EACH ROOT AXIS
C
      DO 5050 NR=1,NRT(NZ,NY,NX)
C
C     SECONDARY ROOT EXTENSION
C
      IF(L.LE.NINR(NR,NZ,NY,NX).AND.NRX(N,NR).EQ.0)THEN
C
C     FRACTION OF SECONDARY ROOT SINK IN SOIL LAYER ATTRIBUTED
C     TO CURRENT AXIS
C
      IF(RLNT(N,L).GT.ZEROP(NZ,NY,NX))THEN
      FRTN=RTSK2(N,L,NR)/RLNT(N,L)
      ELSE
      FRTN=1.0 
      ENDIF
C
C     N,P CONSTRAINT ON SECONDARY ROOT RESPIRATION FROM
C     NON-STRUCTURAL C:N:P
C
      IF(CCPOLR(N,L,NZ,NY,NX).GT.ZERO)THEN
      CNPG=AMIN1(CZPOLR(N,L,NZ,NY,NX)/(CZPOLR(N,L,NZ,NY,NX)
     2+CCPOLR(N,L,NZ,NY,NX)/CNKI),CPPOLR(N,L,NZ,NY,NX)
     3/(CPPOLR(N,L,NZ,NY,NX)+CCPOLR(N,L,NZ,NY,NX)/CPKI))
      ELSE
      CNPG=1.0
      ENDIF
C
C     O2-UNLIMITED SECONDARY ROOT RESPIRATION FROM NON-STRUCTURAL C
C     CONSTRAINED BY TEMPERATURE AND NON-STRUCTURAL C:N:P
C
      RCO2RM=AMAX1(0.0,VMXC*FRTN*CPOOLR(N,L,NZ,NY,NX)
     2*TFN4(L,NZ,NY,NX))*CNPG*FDBKX(NB1(NZ,NY,NX),NZ,NY,NX)
     3*WFNGR(N,L)
C
C     O2-LIMITED SECONDARY ROOT RESPIRATION FROM 'WFR' IN 'UPTAKE'
C
      RCO2R=RCO2RM*WFR(N,L,NZ,NY,NX)
C
C     SECONDARY ROOT MAINTENANCE RESPIRATION FROM SOIL TEMPERATURE,
C     ROOT STRUCTURAL N
C
      RMNCR=AMAX1(0.0,RMPLT*WTRT2N(N,L,NR,NZ,NY,NX))*TFN6(L)
      IF(IWTYP(NZ,NY,NX).EQ.2)THEN
      RMNCR=RMNCR*WFNGR(N,L)
      ENDIF 
      RCO2XM=RCO2RM-RMNCR
      RCO2X=RCO2R-RMNCR
      RCO2YM=AMAX1(0.0,RCO2XM)*WFNRG
      RCO2Y=AMAX1(0.0,RCO2X)*WFNRG
C
C     SECONDARY ROOT GROWTH RESPIRATION MAY BE LIMITED BY
C     NON-STRUCTURAL N,P AVAILABLE FOR GROWTH
C
      DMRTR=DMRTD*FRTN
      ZPOOLB=AMAX1(0.0,ZPOOLR(N,L,NZ,NY,NX))
      PPOOLB=AMAX1(0.0,PPOOLR(N,L,NZ,NY,NX))
      FNP=AMIN1(ZPOOLB*DMRTR/CNRTS(NZ,NY,NX)
     2,PPOOLB*DMRTR/CPRTS(NZ,NY,NX))
      IF(RCO2YM.GT.0.0)THEN
      RCO2GM=AMIN1(RCO2YM,FNP)
      ELSE
      RCO2GM=0.0
      ENDIF
      IF(RCO2Y.GT.0.0)THEN
      RCO2G=AMIN1(RCO2Y,FNP*WFR(N,L,NZ,NY,NX))
      ELSE
      RCO2G=0.0
      ENDIF
C
C     TOTAL NON-STRUCTURAL C,N,P USED IN SECONDARY ROOT GROWTH
C     AND GROWTH RESPIRATION DEPENDS ON GROWTH YIELD ENTERED IN 'READQ'
C
      CGRORM=RCO2GM/DMRTD
      CGROR=RCO2G/DMRTD
      GRTWGM=CGRORM*DMRT(NZ,NY,NX)
      GRTWTG=CGROR*DMRT(NZ,NY,NX)
      ZADD2M=AMAX1(0.0,GRTWGM*CNRTW)
      ZADD2=AMAX1(0.0,AMIN1(FRTN*ZPOOLR(N,L,NZ,NY,NX),GRTWTG*CNRTW))
      PADD2=AMAX1(0.0,AMIN1(FRTN*PPOOLR(N,L,NZ,NY,NX),GRTWTG*CPRTW))
      CNRDM=AMAX1(0.0,1.70*ZADD2M)
      CNRDA=AMAX1(0.0,1.70*ZADD2)
C
C     SECONDARY ROOT GROWTH RESPIRATION FROM TOTAL - MAINTENANCE
C     IF > 0 DRIVES GROWTH, IF < 0 DRIVES REMOBILIZATION, ALSO
C     SECONDARY ROOT C LOSS FROM REMOBILIZATION AND CONSEQUENT LITTERFALL
C
      IF(IDAY(1,NB1(NZ,NY,NX),NZ,NY,NX).NE.0
     2.AND.CCPOLR(N,L,NZ,NY,NX).GT.ZERO)THEN
      CCC=AMIN1(CZPOLR(N,L,NZ,NY,NX)/(CZPOLR(N,L,NZ,NY,NX)
     2+CCPOLR(N,L,NZ,NY,NX)/CNKI)
     3,CPPOLR(N,L,NZ,NY,NX)/(CPPOLR(N,L,NZ,NY,NX)
     4+CCPOLR(N,L,NZ,NY,NX)/CPKI))
      CNC=CCPOLR(N,L,NZ,NY,NX)/(CCPOLR(N,L,NZ,NY,NX)
     2+CZPOLR(N,L,NZ,NY,NX)/ZSKI)
      CPC=CCPOLR(N,L,NZ,NY,NX)/(CCPOLR(N,L,NZ,NY,NX)
     2+CPPOLR(N,L,NZ,NY,NX)/PSKI)
      ELSE
      CCC=0.0
      CNC=0.0
      CPC=0.0
      ENDIF
      RCCC=RCCZ+CCC*RCCY
      RCCN=CNC*RCCX(IGTYP(NZ,NY,NX))
      RCCP=CPC*RCCQ(IGTYP(NZ,NY,NX))
      IF(-RCO2XM.GT.0.0)THEN
      IF(-RCO2XM.LT.WTRT2(N,L,NR,NZ,NY,NX)*RCCC)THEN 
      SNCRM=-RCO2XM
      ELSE
      SNCRM=AMAX1(0.0,WTRT2(N,L,NR,NZ,NY,NX)*RCCC)
      ENDIF
      ELSE
      SNCRM=0.0
      ENDIF
      IF(-RCO2X.GT.0.0)THEN
      IF(-RCO2X.LT.WTRT2(N,L,NR,NZ,NY,NX)*RCCC)THEN
      SNCR=-RCO2X
      ELSE
      SNCR=AMAX1(0.0,WTRT2(N,L,NR,NZ,NY,NX)*RCCC)
     2*WFR(N,L,NZ,NY,NX)
      ENDIF
      ELSE
      SNCR=0.0
      ENDIF
C
C     RECOVERY OF REMOBILIZABLE N,P FROM SECONDARY ROOT DURING
C     REMOBILIZATION DEPENDS ON ROOT NON-STRUCTURAL C:N:P
C
      IF(SNCR.GT.0.0.AND.WTRT2(N,L,NR,NZ,NY,NX)
     2.GT.ZEROP(NZ,NY,NX))THEN
      RCCR=RCCC*WTRT2(N,L,NR,NZ,NY,NX)
      RCZR=WTRT2N(N,L,NR,NZ,NY,NX)*(RCCN+(1.0-RCCN)
     2*RCCR/WTRT2(N,L,NR,NZ,NY,NX))
      RCPR=WTRT2P(N,L,NR,NZ,NY,NX)*(RCCP+(1.0-RCCP)
     2*RCCR/WTRT2(N,L,NR,NZ,NY,NX))
      IF(RCCR.GT.ZEROP(NZ,NY,NX))THEN
      FSNC2=AMAX1(0.0,AMIN1(1.0,SNCR/RCCR))
      ELSE
      FSNC2=1.0
      ENDIF
      ELSE
      RCCR=0.0
      RCZR=0.0
      RCPR=0.0
      FSNC2=0.0
      ENDIF
C
C     SECONDARY ROOT LITTERFALL CAUSED BY REMOBILIZATION
C
      DO 6350 M=1,4
      CSNC(M,0,L,NZ,NY,NX)=CSNC(M,0,L,NZ,NY,NX)+CFOPC(5,M,NZ,NY,NX)
     2*FSNC2*(WTRT2(N,L,NR,NZ,NY,NX)-RCCR)*FWOOD(0)
      ZSNC(M,0,L,NZ,NY,NX)=ZSNC(M,0,L,NZ,NY,NX)+CFOPN(5,M,NZ,NY,NX)
     2*FSNC2*(WTRT2N(N,L,NR,NZ,NY,NX)-RCZR)*FWOODN(0)
      PSNC(M,0,L,NZ,NY,NX)=PSNC(M,0,L,NZ,NY,NX)+CFOPP(5,M,NZ,NY,NX)
     2*FSNC2*(WTRT2P(N,L,NR,NZ,NY,NX)-RCPR)*FWOODP(0)
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+CFOPC(4,M,NZ,NY,NX)
     2*FSNC2*(WTRT2(N,L,NR,NZ,NY,NX)-RCCR)*FWOOD(1)
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+CFOPN(4,M,NZ,NY,NX)
     2*FSNC2*(WTRT2N(N,L,NR,NZ,NY,NX)-RCZR)*FWOODN(1)
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+CFOPP(4,M,NZ,NY,NX)
     2*FSNC2*(WTRT2P(N,L,NR,NZ,NY,NX)-RCPR)*FWOODP(1)
6350  CONTINUE
C
C     CONSUMPTION OF NON-STRUCTURAL C,N,P BY SECONDARY ROOT
C
      CPOOLR(N,L,NZ,NY,NX)=CPOOLR(N,L,NZ,NY,NX)-AMIN1(RMNCR,RCO2R)
     2-CGROR-CNRDA-SNCR+FSNC2*RCCR
      ZPOOLR(N,L,NZ,NY,NX)=ZPOOLR(N,L,NZ,NY,NX)-ZADD2+FSNC2*RCZR
      PPOOLR(N,L,NZ,NY,NX)=PPOOLR(N,L,NZ,NY,NX)-PADD2+FSNC2*RCPR
C
C     TOTAL SECONDARY ROOT RESPIRATION
C
      RCO2TM=AMIN1(RMNCR,RCO2RM)+RCO2GM+SNCRM+CNRDM
      RCO2T=AMIN1(RMNCR,RCO2R)+RCO2G+SNCR+CNRDA
      RCO2M(N,L,NZ,NY,NX)=RCO2M(N,L,NZ,NY,NX)+RCO2TM
      RCO2N(N,L,NZ,NY,NX)=RCO2N(N,L,NZ,NY,NX)+RCO2T
      RCO2A(N,L,NZ,NY,NX)=RCO2A(N,L,NZ,NY,NX)-RCO2T
C
C     SECONDARY ROOT EXTENSION FROM ROOT GROWTH AND ROOT TURGOR
C
      GRTLGL=GRTWTG*RTLG2X(N,NZ,NY,NX)*WFNR*FWOOD(1)
     2-FSNC2*RTLG2(N,L,NR,NZ,NY,NX)
      GRTWTL=GRTWTG-FSNC2*WTRT2(N,L,NR,NZ,NY,NX)
      GRTWTN=ZADD2-FSNC2*WTRT2N(N,L,NR,NZ,NY,NX) 
      GRTWTP=PADD2-FSNC2*WTRT2P(N,L,NR,NZ,NY,NX) 
C
C     UPDATE STATE VARIABLES FOR SECONDARY ROOT LENGTH, C, N, P
C     AND AXIS NUMBER 
C
      RTLG2(N,L,NR,NZ,NY,NX)=RTLG2(N,L,NR,NZ,NY,NX)+GRTLGL
      WTRT2(N,L,NR,NZ,NY,NX)=WTRT2(N,L,NR,NZ,NY,NX)+GRTWTL
      WTRT2N(N,L,NR,NZ,NY,NX)=WTRT2N(N,L,NR,NZ,NY,NX)+GRTWTN
      WTRT2P(N,L,NR,NZ,NY,NX)=WTRT2P(N,L,NR,NZ,NY,NX)+GRTWTP
      WSRTL(N,L,NZ,NY,NX)=WSRTL(N,L,NZ,NY,NX)
     2+AMIN1(CNWS(NZ,NY,NX)*WTRT2N(N,L,NR,NZ,NY,NX)
     2,CPWS(NZ,NY,NX)*WTRT2P(N,L,NR,NZ,NY,NX))
      RTLGL=RTLGL+RTLG2(N,L,NR,NZ,NY,NX)
      WTRTX=WTRTX+WTRT2(N,L,NR,NZ,NY,NX)
      RTN2X=RTFQ(NZ,NY,NX)*XRTN1
      RTN2Y=RTFQ(NZ,NY,NX)*RTN2X
      RTN2(N,L,NR,NZ,NY,NX)=RTN2X+RTN2Y 
      RTNL(N,L,NZ,NY,NX)=RTNL(N,L,NZ,NY,NX)+RTN2(N,L,NR,NZ,NY,NX)
C     IF(L.EQ.1)THEN
C     WRITE(*,9876)'RCO22',I,J,NZ,NR,L,N
C    2,RCO2TM,RCO2T,RMNCR,RCO2RM,RCO2R,RCO2GM,RCO2G
C    3,RCO2XM,RCO2X,CGROR,SNCRM,SNCR,CNRDA,CPOOLR(N,L,NZ,NY,NX),FRTN 
C    4,TFN4(L,NZ,NY,NX),CNPG,FDBKX(NB1(NZ,NY,NX),NZ,NY,NX),WFNGR(N,L)
C    5,TFN6(L),GRTWTG,GRTWTL,GRTLGL,RTLG2(N,L,NR,NZ,NY,NX)
C    5,WTRT2(N,L,NR,NZ,NY,NX),RTLG2(N,L,NR,NZ,NY,NX)
C    4,RCO2M(N,L,NZ,NY,NX),RCO2A(N,L,NZ,NY,NX),WFR(N,L,NZ,NY,NX) 
C    8,ZPOOLR(N,L,NZ,NY,NX),PPOOLR(N,L,NZ,NY,NX)
C    9,FSNC2,RLNT(N,L),RTSK1(N,L,NR),RTSK2(N,L,NR) 
C    4,RTN2X,RTN2Y,XRTN1
C    5,RTDPL(NR,L),RTDNP(N,L,NZ,NY,NX)
C    5,RTDP1(1,NR,NZ,NY,NX),CDPTHZ(L-1,NY,NX),DLYR(3,L,NY,NX)
C    6,SDPTH(NZ,NY,NX),HTCTL(NZ,NY,NX) 
C    5,WFNRG,FNP,RTLGP(N,L,NZ,NY,NX),ZADD2,PADD2,CUPRO,CUPRL 
C    7,RUPNH4(N,L,NZ,NY,NX),RUPNHB(N,L,NZ,NY,NX)
C    8,RUPNO3(N,L,NZ,NY,NX),RUPNOB(N,L,NZ,NY,NX) 
C    9,RUPH2P(N,L,NZ,NY,NX),RUPH2B(N,L,NZ,NY,NX)
C    6,RDFOMN(N,L,NZ,NY,NX),RDFOMP(N,L,NZ,NY,NX) 
C    2,RTN1(N,L,NZ,NY,NX),RTN2(N,L,NR,NZ,NY,NX)
C    3,RTNL(N,L,NZ,NY,NX)
9876  FORMAT(A8,6I4,100E12.4)
C     ENDIF
C
C     PRIMARY ROOT EXTENSION
C
      IF(N.EQ.1)THEN
      IF(RTDP1(N,NR,NZ,NY,NX).GT.CDPTHZ(L-1,NY,NX)
     2.AND.ICHK1(N,NR).EQ.0)THEN
      RTN1(N,L,NZ,NY,NX)=RTN1(N,L,NZ,NY,NX)+XRTN1
      IF(RTDP1(N,NR,NZ,NY,NX).LE.CDPTHZ(L,NY,NX))THEN
      ICHK1(N,NR)=1
C
C     FRACTION OF PRIMARY ROOT SINK IN SOIL LAYER ATTRIBUTED TO CURRENT AXIS
C
      IF(RLNT(N,L).GT.ZEROP(NZ,NY,NX))THEN
      FRTN=RTSK1(N,L,NR)/RLNT(N,L)
      ELSE
      FRTN=1.0
      ENDIF
C
C     WATER STRESS CONSTRAINT ON SECONDARY ROOT EXTENSION IMPOSED
C     BY ROOT TURGOR AND SOIL PENETRATION RESISTANCE
C
      RSCS1=RSCS(L,NY,NX)*RRAD1(N,L,NZ,NY,NX)/1.0E-03
      WFNR=AMIN1(1.0,AMAX1(0.0,PSIRG(N,L,NZ,NY,NX)-PSILM-RSCS1))
      WFNRG=WFNR**0.25
C
C     N,P CONSTRAINT ON PRIMARY ROOT RESPIRATION FROM
C     NON-STRUCTURAL C:N:P
C
      IF(CCPOLR(N,L,NZ,NY,NX).GT.ZERO)THEN
      CNPG=AMIN1(CZPOLR(N,L,NZ,NY,NX)/(CZPOLR(N,L,NZ,NY,NX)
     2+CCPOLR(N,L,NZ,NY,NX)/CNKI),CPPOLR(N,L,NZ,NY,NX)
     3/(CPPOLR(N,L,NZ,NY,NX)+CCPOLR(N,L,NZ,NY,NX)/CPKI))
      ELSE
      CNPG=1.0
      ENDIF
C
C     O2-UNLIMITED PRIMARY ROOT RESPIRATION FROM ROOT NON-STRUCTURAL C
C     CONSTRAINED BY TEMPERATURE AND NON-STRUCTURAL C:N:P
C
      RCO2RM=AMAX1(0.0,VMXC*FRTN*CPOOLR(N,L,NZ,NY,NX)
     2*TFN4(L,NZ,NY,NX))*CNPG*FDBKX(NB1(NZ,NY,NX),NZ,NY,NX)
     3*WFNGR(N,L)
C
C     O2-LIMITED PRIMARY ROOT RESPIRATION FROM 'WFR' IN 'UPTAKE'
C
      RCO2R=RCO2RM*WFR(N,L,NZ,NY,NX)
C
C     PRIMARY ROOT MAINTENANCE RESPIRATION FROM SOIL TEMPERATURE,
C     ROOT STRUCTURAL N
C
      RMNCR=AMAX1(0.0,RMPLT*RTWT1N(N,NR,NZ,NY,NX))*TFN6(L)
      IF(IWTYP(NZ,NY,NX).EQ.2)THEN
      RMNCR=RMNCR*WFNGR(N,L)
      ENDIF 
      RCO2XM=RCO2RM-RMNCR
      RCO2X=RCO2R-RMNCR
      RCO2YM=AMAX1(0.0,RCO2XM)*WFNRG
      RCO2Y=AMAX1(0.0,RCO2X)*WFNRG
C
C     PRIMARY ROOT GROWTH RESPIRATION MAY BE LIMITED BY
C     NON-STRUCTURAL N,P AVAILABLE FOR GROWTH
C
      DMRTR=DMRTD*FRTN
      ZPOOLB=AMAX1(0.0,ZPOOLR(N,L,NZ,NY,NX))
      PPOOLB=AMAX1(0.0,PPOOLR(N,L,NZ,NY,NX))
      FNP=AMIN1(ZPOOLB*DMRTR/CNRTS(NZ,NY,NX)
     2,PPOOLB*DMRTR/CPRTS(NZ,NY,NX))
      IF(RCO2YM.GT.0.0)THEN
      RCO2GM=AMIN1(RCO2YM,FNP)
      ELSE
      RCO2GM=0.0
      ENDIF
      IF(RCO2Y.GT.0.0)THEN
      RCO2G=AMIN1(RCO2Y,FNP*WFR(N,L,NZ,NY,NX))
      ELSE
      RCO2G=0.0
      ENDIF
C
C     TOTAL NON-STRUCTURAL C,N,P USED IN PRIMARY ROOT GROWTH
C     AND GROWTH RESPIRATION DEPENDS ON GROWTH YIELD
C     ENTERED IN 'READQ'
C
      CGRORM=RCO2GM/DMRTD
      CGROR=RCO2G/DMRTD
      GRTWGM=CGRORM*DMRT(NZ,NY,NX)
      GRTWTG=CGROR*DMRT(NZ,NY,NX)
      ZADD1M=AMAX1(0.0,GRTWGM*CNRTW)
      ZADD1=AMAX1(0.0,AMIN1(FRTN*ZPOOLR(N,L,NZ,NY,NX),GRTWTG*CNRTW))
      PADD1=AMAX1(0.0,AMIN1(FRTN*PPOOLR(N,L,NZ,NY,NX),GRTWTG*CPRTW))
      CNRDM=AMAX1(0.0,1.70*ZADD1M)
      CNRDA=AMAX1(0.0,1.70*ZADD1)
C
C     PRIMARY ROOT GROWTH RESPIRATION FROM TOTAL - MAINTENANCE
C     IF > 0 DRIVES GROWTH, IF < 0 DRIVES REMOBILIZATION, ALSO
C     PRIMARY ROOT C LOSS FROM REMOBILIZATION AND CONSEQUENT LITTERFALL
C
      IF(IDAY(1,NB1(NZ,NY,NX),NZ,NY,NX).NE.0
     2.AND.CCPOLR(N,L,NZ,NY,NX).GT.ZERO)THEN
      CCC=AMIN1(CZPOLR(N,L,NZ,NY,NX)/(CZPOLR(N,L,NZ,NY,NX)
     2+CCPOLR(N,L,NZ,NY,NX)/CNKI)
     3,CPPOLR(N,L,NZ,NY,NX)/(CPPOLR(N,L,NZ,NY,NX)
     4+CCPOLR(N,L,NZ,NY,NX)/CPKI))
      CNC=CCPOLR(N,L,NZ,NY,NX)/(CCPOLR(N,L,NZ,NY,NX)
     2+CZPOLR(N,L,NZ,NY,NX)/ZSKI)
      CPC=CCPOLR(N,L,NZ,NY,NX)/(CCPOLR(N,L,NZ,NY,NX)
     2+CPPOLR(N,L,NZ,NY,NX)/PSKI)
      ELSE
      CCC=0.0
      CNC=0.0
      CPC=0.0
      ENDIF
      RCCC=RCCZ+CCC*RCCY
      RCCN=CNC*RCCX(IGTYP(NZ,NY,NX))
      RCCP=CPC*RCCQ(IGTYP(NZ,NY,NX))
      IF(-RCO2XM.GT.0.0)THEN
      IF(-RCO2XM.LT.RTWT1(N,NR,NZ,NY,NX)*RCCC)THEN
      SNCRM=-RCO2XM
      ELSE
      SNCRM=AMAX1(0.0,RTWT1(N,NR,NZ,NY,NX)*RCCC)
      ENDIF
      ELSE
      SNCRM=0.0
      ENDIF
      IF(-RCO2X.GT.0.0)THEN
      IF(-RCO2X.LT.RTWT1(N,NR,NZ,NY,NX)*RCCC)THEN
      SNCR=-RCO2X
      ELSE
      SNCR=AMAX1(0.0,RTWT1(N,NR,NZ,NY,NX)*RCCC)
     2*WFR(N,L,NZ,NY,NX)
      ENDIF
      ELSE
      SNCR=0.0
      ENDIF
C
C     RECOVERY OF REMOBILIZABLE N,P DURING PRIMARY ROOT REMOBILIZATION
C     DEPENDS ON ROOT NON-STRUCTURAL C:N:P
C
      IF(SNCR.GT.0.0.AND.RTWT1(N,NR,NZ,NY,NX)
     2.GT.ZEROP(NZ,NY,NX))THEN
      RCCR=RCCC*RTWT1(N,NR,NZ,NY,NX)
      RCZR=RTWT1N(N,NR,NZ,NY,NX)*(RCCN+(1.0-RCCN)
     2*RCCR/RTWT1(N,NR,NZ,NY,NX))
      RCPR=RTWT1P(N,NR,NZ,NY,NX)*(RCCP+(1.0-RCCP)
     2*RCCR/RTWT1(N,NR,NZ,NY,NX))
      IF(RCCR.GT.ZEROP(NZ,NY,NX))THEN
      FSNC1=AMAX1(0.0,AMIN1(1.0,SNCR/RCCR))
      ELSE
      FSNC1=1.0
      ENDIF
      ELSE
      RCCR=0.0
      RCZR=0.0
      RCPR=0.0
      FSNC1=0.0
      ENDIF
C
C     PRIMARY ROOT LITTERFALL CAUSED BY REMOBILIZATION
C
      DO 6355 M=1,4
      CSNC(M,0,L,NZ,NY,NX)=CSNC(M,0,L,NZ,NY,NX)+CFOPC(5,M,NZ,NY,NX)
     2*FSNC1*(RTWT1(N,NR,NZ,NY,NX)-RCCR)*FWOOD(0)
      ZSNC(M,0,L,NZ,NY,NX)=ZSNC(M,0,L,NZ,NY,NX)+CFOPN(5,M,NZ,NY,NX)
     2*FSNC1*(RTWT1N(N,NR,NZ,NY,NX)-RCZR)*FWOODN(0)
      PSNC(M,0,L,NZ,NY,NX)=PSNC(M,0,L,NZ,NY,NX)+CFOPP(5,M,NZ,NY,NX)
     2*FSNC1*(RTWT1P(N,NR,NZ,NY,NX)-RCPR)*FWOODP(0)
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+CFOPC(4,M,NZ,NY,NX)
     2*FSNC1*(RTWT1(N,NR,NZ,NY,NX)-RCCR)*FWOOD(1)
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+CFOPN(4,M,NZ,NY,NX)
     2*FSNC1*(RTWT1N(N,NR,NZ,NY,NX)-RCZR)*FWOODN(1)
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+CFOPP(4,M,NZ,NY,NX)
     2*FSNC1*(RTWT1P(N,NR,NZ,NY,NX)-RCPR)*FWOODP(1)
6355  CONTINUE
C
C     CONSUMPTION OF NON-STRUCTURAL C,N,P BY PRIMARY ROOTS
C
      CPOOLR(N,L,NZ,NY,NX)=CPOOLR(N,L,NZ,NY,NX)-AMIN1(RMNCR,RCO2R)
     2-CGROR-CNRDA-SNCR+FSNC1*RCCR
      ZPOOLR(N,L,NZ,NY,NX)=ZPOOLR(N,L,NZ,NY,NX)-ZADD1+FSNC1*RCZR 
      PPOOLR(N,L,NZ,NY,NX)=PPOOLR(N,L,NZ,NY,NX)-PADD1+FSNC1*RCPR 
C
C     TOTAL PRIMARY ROOT RESPIRATION
C
      RCO2TM=AMIN1(RMNCR,RCO2RM)+RCO2GM+SNCRM+CNRDM
      RCO2T=AMIN1(RMNCR,RCO2R)+RCO2G+SNCR+CNRDA
C
C     ALLOCATE PRIMARY ROOT TOTAL RESPIRATION TO ALL SOIL LAYERS
C     THROUGH WHICH PRIMARY ROOTS GROW
C
      IF(RTDP1(N,NR,NZ,NY,NX).GT.CDPTHZ(NG(NZ,NY,NX),NY,NX))THEN
      DO 5100 LL=NG(NZ,NY,NX),NINR(NR,NZ,NY,NX)
      FRCO2=RTLG1(N,LL,NR,NZ,NY,NX)/(RTDP1(N,NR,NZ,NY,NX)
     2-SDPTH(NZ,NY,NX))
      RCO2M(N,LL,NZ,NY,NX)=RCO2M(N,LL,NZ,NY,NX)+RCO2TM*FRCO2
      RCO2N(N,LL,NZ,NY,NX)=RCO2N(N,LL,NZ,NY,NX)+RCO2T*FRCO2
      RCO2A(N,LL,NZ,NY,NX)=RCO2A(N,LL,NZ,NY,NX)-RCO2T*FRCO2
5100  CONTINUE
      ELSE
      RCO2M(N,L,NZ,NY,NX)=RCO2M(N,L,NZ,NY,NX)+RCO2TM
      RCO2N(N,L,NZ,NY,NX)=RCO2N(N,L,NZ,NY,NX)+RCO2T
      RCO2A(N,L,NZ,NY,NX)=RCO2A(N,L,NZ,NY,NX)-RCO2T
      ENDIF
C
C     ALLOCATE ANY NEGATIVE PRIMARY ROOT C,N,P GROWTH TO SECONDARY
C     ROOTS ON THE SAME AXIS IN THE SAME LAYER UNTIL SECONDARY ROOTS
C     HAVE DISAPPEARED
C
      GRTWTL=GRTWTG-FSNC1*RTWT1(N,NR,NZ,NY,NX) 
      GRTWTN=ZADD1-FSNC1*RTWT1N(N,NR,NZ,NY,NX) 
      GRTWTP=PADD1-FSNC1*RTWT1P(N,NR,NZ,NY,NX) 
      IF(GRTWTL.LT.0.0)THEN
      LX=MAX(1,L-1)
      DO 5105 LL=L,LX,-1
      GRTWTM=GRTWTL
      IF(GRTWTL.LT.0.0)THEN
      IF(GRTWTL.GT.-WTRT2(N,LL,NR,NZ,NY,NX))THEN
      RTLG2(N,LL,NR,NZ,NY,NX)=RTLG2(N,LL,NR,NZ,NY,NX)+GRTWTL
     2*RTLG2(N,LL,NR,NZ,NY,NX)/WTRT2(N,LL,NR,NZ,NY,NX)
      WTRT2(N,LL,NR,NZ,NY,NX)=WTRT2(N,LL,NR,NZ,NY,NX)+GRTWTL
      GRTWTL=0.0
      ELSE
      GRTWTL=GRTWTL+WTRT2(N,LL,NR,NZ,NY,NX)
      RTLG2(N,LL,NR,NZ,NY,NX)=0.0
      WTRT2(N,LL,NR,NZ,NY,NX)=0.0
      ENDIF
      ENDIF
      IF(GRTWTN.LT.0.0)THEN
      IF(GRTWTN.GT.-WTRT2N(N,LL,NR,NZ,NY,NX))THEN
      WTRT2N(N,LL,NR,NZ,NY,NX)=WTRT2N(N,LL,NR,NZ,NY,NX)+GRTWTN
      GRTWTN=0.0
      ELSE
      GRTWTN=GRTWTN+WTRT2N(N,LL,NR,NZ,NY,NX)
      WTRT2N(N,LL,NR,NZ,NY,NX)=0.0
      ENDIF
      ENDIF
      IF(GRTWTP.LT.0.0)THEN
      IF(GRTWTP.GT.-WTRT2P(N,LL,NR,NZ,NY,NX))THEN
      WTRT2P(N,LL,NR,NZ,NY,NX)=WTRT2P(N,LL,NR,NZ,NY,NX)+GRTWTP
      GRTWTP=0.0
      ELSE
      GRTWTP=GRTWTP+WTRT2P(N,LL,NR,NZ,NY,NX)
      WTRT2P(N,LL,NR,NZ,NY,NX)=0.0
      ENDIF
      ENDIF
C     WRITE(*,9876)'WTRT2',I,J,NZ,NR,LL,N
C    2,GRTWTL,GRTWTM,GRTWTG,FSNC1,SNCR,RCCR,RTWT1(N,NR,NZ,NY,NX)
C    3,WTRT2(1,LL,NR,NZ,NY,NX),WTRTL(1,LL,NZ,NY,NX)
C    3,WTRT2(2,LL,NR,NZ,NY,NX),WTRTL(2,LL,NZ,NY,NX)
C    4,RTLG2(1,LL,NR,NZ,NY,NX),RTLG1(1,LL,NR,NZ,NY,NX)
C    4,RTLG2(2,LL,NR,NZ,NY,NX),RTLG1(2,LL,NR,NZ,NY,NX)
C
C     CONCURRENT LOSS OF MYCORRHIZAE AND NODULES
C
      IF(GRTWTM.LT.0.0)THEN
      IF(WTRT2(1,LL,NR,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FSNCM=AMIN1(1.0,ABS(GRTWTM)/WTRT2(1,LL,NR,NZ,NY,NX))
      ELSE
      FSNCM=1.0
      ENDIF
      IF(WTRTL(1,LL,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FSNCP=AMIN1(1.0,ABS(GRTWTM)/WTRTL(1,LL,NZ,NY,NX))
      ELSE
      FSNCP=1.0
      ENDIF
      DO 6450 M=1,4
      CSNC(M,0,LL,NZ,NY,NX)=CSNC(M,0,LL,NZ,NY,NX)+CFOPC(5,M,NZ,NY,NX)
     2*FSNCM*AMAX1(0.0,WTRT2(2,LL,NR,NZ,NY,NX))*FWOOD(0)
      ZSNC(M,0,LL,NZ,NY,NX)=ZSNC(M,0,LL,NZ,NY,NX)+CFOPN(5,M,NZ,NY,NX)
     2*FSNCM*AMAX1(0.0,WTRT2N(2,LL,NR,NZ,NY,NX))*FWOODN(0)
      PSNC(M,0,LL,NZ,NY,NX)=PSNC(M,0,LL,NZ,NY,NX)+CFOPP(5,M,NZ,NY,NX)
     2*FSNCM*AMAX1(0.0,WTRT2P(2,LL,NR,NZ,NY,NX))*FWOODP(0)
      CSNC(M,1,LL,NZ,NY,NX)=CSNC(M,1,LL,NZ,NY,NX)+CFOPC(4,M,NZ,NY,NX)
     2*FSNCM*AMAX1(0.0,WTRT2(2,LL,NR,NZ,NY,NX))*FWOOD(1)
      ZSNC(M,1,LL,NZ,NY,NX)=ZSNC(M,1,LL,NZ,NY,NX)+CFOPN(4,M,NZ,NY,NX)
     2*FSNCM*AMAX1(0.0,WTRT2N(2,LL,NR,NZ,NY,NX))*FWOODN(1)
      PSNC(M,1,LL,NZ,NY,NX)=PSNC(M,1,LL,NZ,NY,NX)+CFOPP(4,M,NZ,NY,NX)
     2*FSNCM*AMAX1(0.0,WTRT2P(2,LL,NR,NZ,NY,NX))*FWOODP(1)
      CSNC(M,1,LL,NZ,NY,NX)=CSNC(M,1,LL,NZ,NY,NX)+CFOPC(0,M,NZ,NY,NX)
     2*FSNCP*AMAX1(0.0,CPOOLR(2,LL,NZ,NY,NX)) 
      ZSNC(M,1,LL,NZ,NY,NX)=ZSNC(M,1,LL,NZ,NY,NX)+CFOPN(0,M,NZ,NY,NX)
     2*FSNCP*AMAX1(0.0,ZPOOLR(2,LL,NZ,NY,NX)) 
      PSNC(M,1,LL,NZ,NY,NX)=PSNC(M,1,LL,NZ,NY,NX)+CFOPP(0,M,NZ,NY,NX)
     2*FSNCP*AMAX1(0.0,PPOOLR(2,LL,NZ,NY,NX)) 
6450  CONTINUE
      RTLG2(2,LL,NR,NZ,NY,NX)=AMAX1(0.0,RTLG2(2,LL,NR,NZ,NY,NX))
     2*(1.0-FSNCM)
      WTRT2(2,LL,NR,NZ,NY,NX)=AMAX1(0.0,WTRT2(2,LL,NR,NZ,NY,NX))
     2*(1.0-FSNCM)     
      WTRT2N(2,LL,NR,NZ,NY,NX)=AMAX1(0.0,WTRT2N(2,LL,NR,NZ,NY,NX))
     2*(1.0-FSNCM)     
      WTRT2P(2,LL,NR,NZ,NY,NX)=AMAX1(0.0,WTRT2P(2,LL,NR,NZ,NY,NX))
     2*(1.0-FSNCM)     
      CPOOLR(2,LL,NZ,NY,NX)=AMAX1(0.0,CPOOLR(2,LL,NZ,NY,NX))
     2*(1.0-FSNCP)
      ZPOOLR(2,LL,NZ,NY,NX)=AMAX1(0.0,ZPOOLR(2,LL,NZ,NY,NX))
     2*(1.0-FSNCP)
      PPOOLR(2,LL,NZ,NY,NX)=AMAX1(0.0,PPOOLR(2,LL,NZ,NY,NX))
     2*(1.0-FSNCP)
      ENDIF
5105  CONTINUE
      ENDIF
C
C     PRIMARY ROOT EXTENSION FROM ROOT GROWTH AND ROOT TURGOR
C
      IF(GRTWTL.LT.0.0.AND.RTWT1(N,NR,NZ,NY,NX)
     2.GT.ZEROP(NZ,NY,NX))THEN
      GRTLGL=GRTWTG*RTLG1X(N,NZ,NY,NX)/PP(NZ,NY,NX)*WFNR*FWOOD(1)
     2+GRTWTL*(RTDP1(N,NR,NZ,NY,NX)-SDPTH(NZ,NY,NX))
     3/RTWT1(N,NR,NZ,NY,NX)
      ELSE
      GRTLGL=GRTWTG*RTLG1X(N,NZ,NY,NX)/PP(NZ,NY,NX)*WFNR*FWOOD(1)
      ENDIF
      IF(L.LT.NJ(NY,NX))THEN
      GRTLGL=AMIN1(DLYR(3,L+1,NY,NX),GRTLGL)
      ENDIF
C
C     ALLOCATE PRIMARY ROOT GROWTH TO CURRENT
C     AND NEXT SOIL LAYER WHEN PRIMARY ROOTS EXTEND ACROSS LOWER
C     BOUNDARY OF CURRENT LAYER
C
      IF(GRTLGL.GT.ZEROP(NZ,NY,NX).AND.L.LT.NJ(NY,NX))THEN
      FGROL=AMAX1(0.0,AMIN1(1.0,(CDPTHZ(L,NY,NX)
     2-RTDP1(N,NR,NZ,NY,NX))/GRTLGL))
      IF(FGROL.LT.1.0)FGROL=0.0
      FGROZ=AMAX1(0.0,1.0-FGROL)
      ELSE
      FGROL=1.0
      FGROZ=0.0
      ENDIF
C
C     UPDATE STATE VARIABLES FOR PRIMARY ROOT LENGTH, GROWTH
C     AND AXIS NUMBER
C
      RTWT1(N,NR,NZ,NY,NX)=RTWT1(N,NR,NZ,NY,NX)+GRTWTL
      RTWT1N(N,NR,NZ,NY,NX)=RTWT1N(N,NR,NZ,NY,NX)+GRTWTN
      RTWT1P(N,NR,NZ,NY,NX)=RTWT1P(N,NR,NZ,NY,NX)+GRTWTP
      RTDP1(N,NR,NZ,NY,NX)=RTDP1(N,NR,NZ,NY,NX)+GRTLGL
      WTRT1(N,L,NR,NZ,NY,NX)=WTRT1(N,L,NR,NZ,NY,NX)+GRTWTL*FGROL
      WTRT1N(N,L,NR,NZ,NY,NX)=WTRT1N(N,L,NR,NZ,NY,NX)+GRTWTN*FGROL
      WTRT1P(N,L,NR,NZ,NY,NX)=WTRT1P(N,L,NR,NZ,NY,NX)+GRTWTP*FGROL
      WSRTL(N,L,NZ,NY,NX)=WSRTL(N,L,NZ,NY,NX)
     2+AMIN1(CNWS(NZ,NY,NX)*WTRT1N(N,L,NR,NZ,NY,NX)
     2,CPWS(NZ,NY,NX)*WTRT1P(N,L,NR,NZ,NY,NX))
      RTLG1(N,L,NR,NZ,NY,NX)=RTLG1(N,L,NR,NZ,NY,NX)+GRTLGL*FGROL
C
C     TRANSFER C,N,P INTO NEXT SOIL LAYER
C     WHEN PRIMARY ROOT EXTENDS ACROSS LOWER BOUNDARY
C     OF CURRENT SOIL LAYER
C
      IF(FGROZ.GT.0.0)THEN
      WTRT1(N,L+1,NR,NZ,NY,NX)=WTRT1(N,L+1,NR,NZ,NY,NX)
     2+GRTWTL*FGROZ
      WTRT1N(N,L+1,NR,NZ,NY,NX)=WTRT1N(N,L+1,NR,NZ,NY,NX)
     2+GRTWTN*FGROZ
      WTRT1P(N,L+1,NR,NZ,NY,NX)=WTRT1P(N,L+1,NR,NZ,NY,NX)
     2+GRTWTP*FGROZ
      WSRTL(N,L+1,NZ,NY,NX)=WSRTL(N,L+1,NZ,NY,NX) 
     2+AMIN1(CNWS(NZ,NY,NX)*WTRT1N(N,L+1,NR,NZ,NY,NX)
     2,CPWS(NZ,NY,NX)*WTRT1P(N,L+1,NR,NZ,NY,NX))
      WTRTD(N,L+1,NZ,NY,NX)=WTRTD(N,L+1,NZ,NY,NX)
     2+WTRT1(N,L+1,NR,NZ,NY,NX)
      RTLG1(N,L+1,NR,NZ,NY,NX)=RTLG1(N,L+1,NR,NZ,NY,NX)+GRTLGL*FGROZ
      RRAD1(N,L+1,NZ,NY,NX)=RRAD1(N,L,NZ,NY,NX)
      RTLGZ=RTLGZ+RTLG1(N,L+1,NR,NZ,NY,NX)
      WTRTZ=WTRTZ+WTRT1(N,L+1,NR,NZ,NY,NX)
      XFRC=FRTN*CPOOLR(N,L,NZ,NY,NX)
      XFRN=FRTN*ZPOOLR(N,L,NZ,NY,NX)
      XFRP=FRTN*PPOOLR(N,L,NZ,NY,NX)
      CPOOLR(N,L,NZ,NY,NX)=CPOOLR(N,L,NZ,NY,NX)-XFRC
      ZPOOLR(N,L,NZ,NY,NX)=ZPOOLR(N,L,NZ,NY,NX)-XFRN
      PPOOLR(N,L,NZ,NY,NX)=PPOOLR(N,L,NZ,NY,NX)-XFRP
      CPOOLR(N,L+1,NZ,NY,NX)=CPOOLR(N,L+1,NZ,NY,NX)+XFRC
      ZPOOLR(N,L+1,NZ,NY,NX)=ZPOOLR(N,L+1,NZ,NY,NX)+XFRN
      PPOOLR(N,L+1,NZ,NY,NX)=PPOOLR(N,L+1,NZ,NY,NX)+XFRP
      PSIRT(N,L+1,NZ,NY,NX)=PSIRT(N,L,NZ,NY,NX)
      PSIRO(N,L+1,NZ,NY,NX)=PSIRO(N,L,NZ,NY,NX)
      PSIRG(N,L+1,NZ,NY,NX)=PSIRG(N,L,NZ,NY,NX)
      NINR(NR,NZ,NY,NX)=MAX(NG(NZ,NY,NX),L+1)
C     WRITE(*,9877)'INFIL',I,J,NZ,NR,L,N,NINR(NR,NZ,NY,NX) 
C    2,FRTN,WTRTD(N,L+1,NZ,NY,NX),CPOOLR(N,L+1,NZ,NY,NX)
C    2,FGROZ,RTDP1(N,NR,NZ,NY,NX),GRTLGL,CDPTHZ(L,NY,NX)
      ENDIF
C     IF(L.EQ.1)THEN
C     WRITE(*,9877)'RCO21',I,J,NZ,NR,L,N,NINR(NR,NZ,NY,NX) 
C    2,RCO2TM,RCO2T,RMNCR,RCO2RM,RCO2R,RCO2GM,RCO2G
C    3,RCO2XM,RCO2X,CGROR,SNCRM,SNCR,CNRDA,CPOOLR(N,L,NZ,NY,NX),FRTN 
C    4,TFN4(L,NZ,NY,NX),CNPG,FDBKX(NB1(NZ,NY,NX),NZ,NY,NX),WFNGR(N,L)
C    5,TFN6(L),GRTWTG,GRTWTL,GRTLGL,RTWT1N(N,NR,NZ,NY,NX)
C    6,WTRT1(N,L,NR,NZ,NY,NX),RTDP1(N,NR,NZ,NY,NX)
C    3,RCO2M(N,L,NZ,NY,NX),RCO2A(N,L,NZ,NY,NX),WFR(N,L,NZ,NY,NX)
C    4,RTSK1(N,L,NR),RRAD1(N,L,NZ,NY,NX),RTDPP 
C    5,PSIRG(N,L,NZ,NY,NX),WFNR,WFNRG,FWOOD(1)
C    6,RTDP1(N,NR,NZ,NY,NX),FGROZ,RTWT1(N,NR,NZ,NY,NX),FSNC1 
C    9,ZADD1,PADD1,ZPOOLR(N,L,NZ,NY,NX),PPOOLR(N,L,NZ,NY,NX)
C    1,RUPNH4(N,L,NZ,NY,NX),RUPNO3(N,L,NZ,NY,NX)
9877  FORMAT(A8,7I4,100E24.16)
C     ENDIF
      ENDIF
C
C     TRANSFER PRIMARY ROOT C,N,P TO NEXT SOIL LAYER ABOVE THE
C     CURRENT SOIL LAYER WHEN NEGATIVE PRIMARY ROOT GROWTH FORCES
C     WITHDRAWAL FROM THE CURRENT SOIL LAYER AND ALL SECONDARY ROOTS
C     IN THE CURRENT SOIL LAYER HAVE BEEN LOST
C
      IF(L.EQ.NINR(NR,NZ,NY,NX))THEN
      DO 5115 LL=L,NG(NZ,NY,NX)+1,-1
      IF(RTDP1(N,NR,NZ,NY,NX).LT.CDPTHZ(LL-1,NY,NX)
     2.OR.RTDP1(N,NR,NZ,NY,NX).LT.SDPTH(NZ,NY,NX))THEN
      IF(RLNT(N,LL).GT.ZEROP(NZ,NY,NX))THEN
      FRTN=(RTSK1(N,LL,NR)+RTSK2(N,LL,NR))/RLNT(N,LL)
      ELSE
      FRTN=1.0
      ENDIF
      DO 5110 NN=1,MY(NZ,NY,NX)
      WTRT1(NN,LL-1,NR,NZ,NY,NX)=WTRT1(NN,LL-1,NR,NZ,NY,NX)
     2+WTRT1(NN,LL,NR,NZ,NY,NX)
      WTRT1N(NN,LL-1,NR,NZ,NY,NX)=WTRT1N(NN,LL-1,NR,NZ,NY,NX)
     2+WTRT1N(NN,LL,NR,NZ,NY,NX)
      WTRT1P(NN,LL-1,NR,NZ,NY,NX)=WTRT1P(NN,LL-1,NR,NZ,NY,NX)
     2+WTRT1P(NN,LL,NR,NZ,NY,NX)
      WTRT2(NN,LL-1,NR,NZ,NY,NX)=WTRT2(NN,LL-1,NR,NZ,NY,NX)
     2+WTRT2(NN,LL,NR,NZ,NY,NX)
      WTRT2N(NN,LL-1,NR,NZ,NY,NX)=WTRT2N(NN,LL-1,NR,NZ,NY,NX) 
     2+WTRT2N(NN,LL,NR,NZ,NY,NX)
      WTRT2P(NN,LL-1,NR,NZ,NY,NX)=WTRT2P(NN,LL-1,NR,NZ,NY,NX) 
     2+WTRT2P(NN,LL,NR,NZ,NY,NX)
      RTLG1(NN,LL-1,NR,NZ,NY,NX)=RTLG1(NN,LL-1,NR,NZ,NY,NX)
     2+RTLG1(NN,LL,NR,NZ,NY,NX) 
      WTRT1(NN,LL,NR,NZ,NY,NX)=0.0
      WTRT1N(NN,LL,NR,NZ,NY,NX)=0.0
      WTRT1P(NN,LL,NR,NZ,NY,NX)=0.0
      WTRT2(NN,LL,NR,NZ,NY,NX)=0.0
      WTRT2N(NN,LL,NR,NZ,NY,NX)=0.0
      WTRT2P(NN,LL,NR,NZ,NY,NX)=0.0
      RTLG1(NN,LL,NR,NZ,NY,NX)=0.0 
      XFRC=FRTN*CPOOLR(NN,LL,NZ,NY,NX)
      XFRN=FRTN*ZPOOLR(NN,LL,NZ,NY,NX)
      XFRP=FRTN*PPOOLR(NN,LL,NZ,NY,NX)
      XFRW=FRTN*WSRTL(NN,L,NZ,NY,NX)
      XFRD=FRTN*WTRTD(NN,LL,NZ,NY,NX)
      CPOOLR(NN,LL,NZ,NY,NX)=CPOOLR(NN,LL,NZ,NY,NX)-XFRC
      ZPOOLR(NN,LL,NZ,NY,NX)=ZPOOLR(NN,LL,NZ,NY,NX)-XFRN
      PPOOLR(NN,LL,NZ,NY,NX)=PPOOLR(NN,LL,NZ,NY,NX)-XFRP
      WSRTL(NN,LL,NZ,NY,NX)=WSRTL(NN,LL,NZ,NY,NX)-XFRW 
      WTRTD(NN,LL,NZ,NY,NX)=WTRTD(NN,LL,NZ,NY,NX)-XFRD
      CPOOLR(NN,LL-1,NZ,NY,NX)=CPOOLR(NN,LL-1,NZ,NY,NX)+XFRC
      ZPOOLR(NN,LL-1,NZ,NY,NX)=ZPOOLR(NN,LL-1,NZ,NY,NX)+XFRN
      PPOOLR(NN,LL-1,NZ,NY,NX)=PPOOLR(NN,LL-1,NZ,NY,NX)+XFRP
      WSRTL(NN,LL-1,NZ,NY,NX)=WSRTL(NN,LL-1,NZ,NY,NX)+XFRW 
      WTRTD(NN,LL-1,NZ,NY,NX)=WTRTD(NN,LL-1,NZ,NY,NX)+XFRD
C
C     WITHDRAW GASES IN PRIMARY ROOTS
C
      RCO2Z(NZ,NY,NX)=RCO2Z(NZ,NY,NX)-FRTN*(CO2A(NN,LL,NZ,NY,NX)
     2+CO2P(NN,LL,NZ,NY,NX))
      ROXYZ(NZ,NY,NX)=ROXYZ(NZ,NY,NX)-FRTN*(OXYA(NN,LL,NZ,NY,NX)
     2+OXYP(NN,LL,NZ,NY,NX))
      RCH4Z(NZ,NY,NX)=RCH4Z(NZ,NY,NX)-FRTN*(CH4A(NN,LL,NZ,NY,NX)
     2+CH4P(NN,LL,NZ,NY,NX))
      RN2OZ(NZ,NY,NX)=RN2OZ(NZ,NY,NX)-FRTN*(Z2OA(NN,LL,NZ,NY,NX)
     2+Z2OP(NN,LL,NZ,NY,NX))
      RNH3Z(NZ,NY,NX)=RNH3Z(NZ,NY,NX)-FRTN*(ZH3A(NN,LL,NZ,NY,NX)
     2+ZH3P(NN,LL,NZ,NY,NX))
      RH2GZ(NZ,NY,NX)=RH2GZ(NZ,NY,NX)-FRTN*(H2GA(NN,LL,NZ,NY,NX)
     2+H2GP(NN,LL,NZ,NY,NX))
      CO2A(NN,LL,NZ,NY,NX)=(1.0-FRTN)*CO2A(NN,LL,NZ,NY,NX)
      OXYA(NN,LL,NZ,NY,NX)=(1.0-FRTN)*OXYA(NN,LL,NZ,NY,NX)
      CH4A(NN,LL,NZ,NY,NX)=(1.0-FRTN)*CH4A(NN,LL,NZ,NY,NX)
      Z2OA(NN,LL,NZ,NY,NX)=(1.0-FRTN)*Z2OA(NN,LL,NZ,NY,NX)
      ZH3A(NN,LL,NZ,NY,NX)=(1.0-FRTN)*ZH3A(NN,LL,NZ,NY,NX)
      H2GA(NN,LL,NZ,NY,NX)=(1.0-FRTN)*H2GA(NN,LL,NZ,NY,NX)
      CO2P(NN,LL,NZ,NY,NX)=(1.0-FRTN)*CO2P(NN,LL,NZ,NY,NX)
      OXYP(NN,LL,NZ,NY,NX)=(1.0-FRTN)*OXYP(NN,LL,NZ,NY,NX)
      CH4P(NN,LL,NZ,NY,NX)=(1.0-FRTN)*CH4P(NN,LL,NZ,NY,NX)
      Z2OP(NN,LL,NZ,NY,NX)=(1.0-FRTN)*Z2OP(NN,LL,NZ,NY,NX)
      ZH3P(NN,LL,NZ,NY,NX)=(1.0-FRTN)*ZH3P(NN,LL,NZ,NY,NX)
      H2GP(NN,LL,NZ,NY,NX)=(1.0-FRTN)*H2GP(NN,LL,NZ,NY,NX)
C     IF(NZ.EQ.1.OR.NZ.EQ.4)THEN
C     WRITE(*,9868)'WITHDR',I,J,NZ,NR,LL,NN,NINR(NR,NZ,NY,NX) 
C    2,FRTN,RTSK1(N,LL,NR),RTSK2(N,LL,NR),RLNT(N,LL)
C    2,WTRTD(NN,LL-1,NZ,NY,NX),WTRTD(NN,LL,NZ,NY,NX)
C    2,RTLG1(NN,LL-1,NR,NZ,NY,NX),RTLG1(NN,LL,NR,NZ,NY,NX)
C    2,RTLG2(NN,LL-1,NR,NZ,NY,NX),RTLG2(NN,LL,NR,NZ,NY,NX)
C    3,RTDP1(N,NR,NZ,NY,NX),RTDP1(NN,NR,NZ,NY,NX) 
C    4,CPOOLR(NN,LL-1,NZ,NY,NX),CPOOLR(NN,LL,NZ,NY,NX)
C    4,WTRT1(NN,LL-1,NR,NZ,NY,NX),WTRT1(NN,LL,NR,NZ,NY,NX)
C    4,WTRT2(NN,LL-1,NR,NZ,NY,NX),WTRT2(NN,LL,NR,NZ,NY,NX)
9868  FORMAT(A8,7I4,100E24.16)
C     ENDIF
5110  CONTINUE
      RTNL(N,LL,NZ,NY,NX)=RTNL(N,LL,NZ,NY,NX)
     2-RTN2(N,LL,NR,NZ,NY,NX)
      RTNL(N,LL-1,NZ,NY,NX)=RTNL(N,LL-1,NZ,NY,NX)
     2+RTN2(N,LL,NR,NZ,NY,NX)
      RTN2(N,LL,NR,NZ,NY,NX)=0.0
      RTN1(N,LL,NZ,NY,NX)=RTN1(N,LL,NZ,NY,NX)-XRTN1
C
C     RESET PRIMARY ROOT LENGTH
C
      IF(LL-1.GT.NG(NZ,NY,NX))THEN
      RTLG1(N,LL-1,NR,NZ,NY,NX)=DLYR(3,LL-1,NY,NX)
     2-(CDPTHZ(LL-1,NY,NX)-RTDP1(N,NR,NZ,NY,NX))
      ELSE
      RTLG1(N,LL-1,NR,NZ,NY,NX)=DLYR(3,LL-1,NY,NX)
     2-(CDPTHZ(LL-1,NY,NX)-RTDP1(N,NR,NZ,NY,NX))
     3-(SDPTH(NZ,NY,NX)-CDPTHZ(LL-2,NY,NX))
      ENDIF
C
C     REMOBILIZE C,N,P FROM ROOT NODULES IN LEGUMES
C
      IF(INTYP(NZ,NY,NX).EQ.1.OR.INTYP(NZ,NY,NX).EQ.2)THEN
      XFRC=FRTN*WTNDL(LL,NZ,NY,NX) 
      XFRN=FRTN*WTNDLN(LL,NZ,NY,NX)
      XFRP=FRTN*WTNDLP(LL,NZ,NY,NX)
      WTNDL(LL,NZ,NY,NX)=WTNDL(LL,NZ,NY,NX)-XFRC
      WTNDLN(LL,NZ,NY,NX)=WTNDLN(LL,NZ,NY,NX)-XFRN
      WTNDLP(LL,NZ,NY,NX)=WTNDLP(LL,NZ,NY,NX)-XFRP
      WTNDL(LL-1,NZ,NY,NX)=WTNDL(LL-1,NZ,NY,NX)+XFRC
      WTNDLN(LL-1,NZ,NY,NX)=WTNDLN(LL-1,NZ,NY,NX)+XFRN
      WTNDLP(LL-1,NZ,NY,NX)=WTNDLP(LL-1,NZ,NY,NX)+XFRP
      XFRC=FRTN*CPOOLN(LL,NZ,NY,NX) 
      XFRN=FRTN*ZPOOLN(LL,NZ,NY,NX)
      XFRP=FRTN*PPOOLN(LL,NZ,NY,NX)
      CPOOLN(LL,NZ,NY,NX)=CPOOLN(LL,NZ,NY,NX)-XFRC
      ZPOOLN(LL,NZ,NY,NX)=ZPOOLN(LL,NZ,NY,NX)-XFRN 
      PPOOLN(LL,NZ,NY,NX)=PPOOLN(LL,NZ,NY,NX)-XFRP 
      CPOOLN(LL-1,NZ,NY,NX)=CPOOLN(LL-1,NZ,NY,NX)+XFRC
      ZPOOLN(LL-1,NZ,NY,NX)=ZPOOLN(LL-1,NZ,NY,NX)+XFRN 
      PPOOLN(LL-1,NZ,NY,NX)=PPOOLN(LL-1,NZ,NY,NX)+XFRP 
C     WRITE(*,9868)'WITHDRN',I,J,NZ,NR,LL,NN,NINR(NR,NZ,NY,NX)
C    2,WTNDL(LL,NZ,NY,NX),CPOOLN(LL,NZ,NY,NX),RTDP1(N,NR,NZ,NY,NX)
      ENDIF
      NINR(NR,NZ,NY,NX)=MAX(NG(NZ,NY,NX),LL-1)
      ELSE
      GO TO 5120
      ENDIF
5115  CONTINUE
      ENDIF
5120  CONTINUE
      IF(WTRT1(N,L,NR,NZ,NY,NX).LT.0.0)THEN
      CPOOLR(N,L,NZ,NY,NX)=CPOOLR(N,L,NZ,NY,NX)+WTRT1(N,L,NR,NZ,NY,NX)
      WTRT1(N,L,NR,NZ,NY,NX)=0.0
      ENDIF
      IF(WTRT2(N,L,NR,NZ,NY,NX).LT.0.0)THEN
      CPOOLR(N,L,NZ,NY,NX)=CPOOLR(N,L,NZ,NY,NX)+WTRT2(N,L,NR,NZ,NY,NX)
      WTRT2(N,L,NR,NZ,NY,NX)=0.0
      ENDIF
C
C     TOTAL ROOT LENGTH AND MASS
C
      RTLGZ=RTLGZ+RTLG1(N,L,NR,NZ,NY,NX)
      WTRTZ=WTRTZ+WTRT1(N,L,NR,NZ,NY,NX)
      NINR(NR,NZ,NY,NX)=MIN(NINR(NR,NZ,NY,NX),NJ(NY,NX))
      IF(L.EQ.NINR(NR,NZ,NY,NX))NRX(N,NR)=1
      ENDIF
      ENDIF
      RTLGZ=RTLGZ+RTLG1(N,L,NR,NZ,NY,NX)
      WTRTZ=WTRTZ+WTRT1(N,L,NR,NZ,NY,NX)
C     ENDIF
      ENDIF
      NIX(NZ,NY,NX)=MAX(NIX(NZ,NY,NX),NINR(NR,NZ,NY,NX))
5050  CONTINUE
C
C     DRAW FROM ROOT NON-STRUCTURAL POOL WHEN
C     SEASONAL STORAGE POOL IS DEPLETED
C
      IF(L.LE.NIX(NZ,NY,NX))THEN
      IF(WTRTL(N,L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.WTRT(NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.WTRVC(NZ,NY,NX).LT.XFRX*WTRT(NZ,NY,NX))THEN
      FWTRT=WTRTL(N,L,NZ,NY,NX)/WTRT(NZ,NY,NX)
      WTRTLX=WTRTL(N,L,NZ,NY,NX)
      WTRTTX=WTRT(NZ,NY,NX)*FWTRT
      WTRTTT=WTRTLX+WTRTTX
      CPOOLX=AMAX1(0.0,CPOOLR(N,L,NZ,NY,NX))
      WTRVCX=AMAX1(0.0,WTRVC(NZ,NY,NX)*FWTRT)
      CPOOLD=(WTRVCX*WTRTLX-CPOOLX*WTRTTX)/WTRTTT 
      XFRC=AMIN1(0.0,XFRY*CPOOLD)
      CPOOLR(N,L,NZ,NY,NX)=CPOOLR(N,L,NZ,NY,NX)+XFRC
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)-XFRC
C     WRITE(*,3471)'RVC',I,J,NX,NY,NZ,L 
C    2,XFRC,CPOOLR(N,L,NZ,NY,NX),WTRTD(N,L,NZ,NY,NX)
C    3,WTRVC(NZ,NY,NX),WTRT(NZ,NY,NX),FWTRT
3471  FORMAT(A8,6I4,12E12.4)
      ENDIF
      ENDIF
C
C     ROOT AND MYCORRHIZAL LENGTH, DENSITY, VOLUME, RADIUS, AREA
C     TO CALCULATE WATER AND NUTRIENT UPTAKE IN 'UPTAKE'
C
      IF(N.EQ.1)THEN
      RTLGZ=RTLGZ*FWOOD(1)
      RTLGL=RTLGL*FWOOD(1)
      ENDIF
      RTLGX=RTLGZ*PP(NZ,NY,NX)
      RTLGT=RTLGL+RTLGX
      WTRTT=WTRTX+WTRTZ
      IF(RTLGT.GT.0.0.AND.WTRTT.GT.0.0.AND.PP(NZ,NY,NX).GT.0.0)THEN
      RTLGP(N,L,NZ,NY,NX)=RTLGT/PP(NZ,NY,NX)
      RTDNP(N,L,NZ,NY,NX)=RTLGP(N,L,NZ,NY,NX)/DLYR(3,L,NY,NX)
      RTVL=AMAX1(RTAR1X(N,NZ,NY,NX)*RTLGX+RTAR2X(N,NZ,NY,NX)*RTLGL
     2,WTRTT*DMVL(N,NZ,NY,NX)*PSIRG(N,L,NZ,NY,NX))
      RTVLP(N,L,NZ,NY,NX)=PORT(N,NZ,NY,NX)*RTVL
      RTVLW(N,L,NZ,NY,NX)=(1.0-PORT(N,NZ,NY,NX))*RTVL
      RRAD1(N,L,NZ,NY,NX)=AMAX1(RRAD1X(N,NZ,NY,NX)
     2,(1.0+PSIRT(N,L,NZ,NY,NX)/EMODR)*RRAD1M(N,NZ,NY,NX))
      RRAD2(N,L,NZ,NY,NX)=AMAX1(RRAD2X(N,NZ,NY,NX)
     2,(1.0+PSIRT(N,L,NZ,NY,NX)/EMODR)*RRAD2M(N,NZ,NY,NX))
      RTAR=6.283*RRAD1(N,L,NZ,NY,NX)*RTLGX
     2+6.283*RRAD2(N,L,NZ,NY,NX)*RTLGL
      RTARP(N,L,NZ,NY,NX)=RTAR/PP(NZ,NY,NX)
      IF(RTNL(N,L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      RTLGA(N,L,NZ,NY,NX)=AMAX1(RTLGAX,RTLGL/RTNL(N,L,NZ,NY,NX))
      ELSE
      RTLGA(N,L,NZ,NY,NX)=RTLGAX
      ENDIF
      ELSE
      RTLGP(N,L,NZ,NY,NX)=0.0
      RTDNP(N,L,NZ,NY,NX)=0.0
      RTVLP(N,L,NZ,NY,NX)=0.0
      RTVLW(N,L,NZ,NY,NX)=0.0
      RRAD1(N,L,NZ,NY,NX)=RRAD1M(N,NZ,NY,NX)
      RRAD2(N,L,NZ,NY,NX)=RRAD2M(N,NZ,NY,NX)
      RTARP(N,L,NZ,NY,NX)=0.0
      RTLGA(N,L,NZ,NY,NX)=RTLGAX
      RCO2Z(NZ,NY,NX)=RCO2Z(NZ,NY,NX)-(CO2A(N,L,NZ,NY,NX)
     2+CO2P(N,L,NZ,NY,NX))
      ROXYZ(NZ,NY,NX)=ROXYZ(NZ,NY,NX)-(OXYA(N,L,NZ,NY,NX)
     2+OXYP(N,L,NZ,NY,NX))
      RCH4Z(NZ,NY,NX)=RCH4Z(NZ,NY,NX)-(CH4A(N,L,NZ,NY,NX)
     2+CH4P(N,L,NZ,NY,NX))
      RN2OZ(NZ,NY,NX)=RN2OZ(NZ,NY,NX)-(Z2OA(N,L,NZ,NY,NX)
     2+Z2OP(N,L,NZ,NY,NX))
      RNH3Z(NZ,NY,NX)=RNH3Z(NZ,NY,NX)-(ZH3A(N,L,NZ,NY,NX)
     2+ZH3P(N,L,NZ,NY,NX))
      RH2GZ(NZ,NY,NX)=RH2GZ(NZ,NY,NX)-(H2GA(N,L,NZ,NY,NX)
     2+H2GP(N,L,NZ,NY,NX))
      CO2A(N,L,NZ,NY,NX)=0.0
      OXYA(N,L,NZ,NY,NX)=0.0
      CH4A(N,L,NZ,NY,NX)=0.0
      Z2OA(N,L,NZ,NY,NX)=0.0
      ZH3A(N,L,NZ,NY,NX)=0.0
      H2GA(N,L,NZ,NY,NX)=0.0
      CO2P(N,L,NZ,NY,NX)=0.0
      OXYP(N,L,NZ,NY,NX)=0.0
      CH4P(N,L,NZ,NY,NX)=0.0
      Z2OP(N,L,NZ,NY,NX)=0.0
      ZH3P(N,L,NZ,NY,NX)=0.0
      H2GP(N,L,NZ,NY,NX)=0.0
      ENDIF
5000  CONTINUE
5010  CONTINUE
C
C     ADD SEED DIMENSIONS TO ROOT DIMENSIONS (ONLY IMPORTANT DURING
C     GERMINATION)
C
      RTLGP(1,NG(NZ,NY,NX),NZ,NY,NX)=RTLGP(1,NG(NZ,NY,NX),NZ,NY,NX)
     2+SDLG(NZ,NY,NX)
      RTDNP(1,NG(NZ,NY,NX),NZ,NY,NX)=RTLGP(1,NG(NZ,NY,NX),NZ,NY,NX)
     2/DLYR(3,NG(NZ,NY,NX),NY,NX)
      RTVL=RTVLP(1,NG(NZ,NY,NX),NZ,NY,NX)+RTVLW(1,NG(NZ,NY,NX),NZ,NY,NX)
     2+SDVL(NZ,NY,NX)*PP(NZ,NY,NX)
      RTVLP(1,NG(NZ,NY,NX),NZ,NY,NX)=PORT(1,NZ,NY,NX)*RTVL
      RTVLW(1,NG(NZ,NY,NX),NZ,NY,NX)=(1.0-PORT(1,NZ,NY,NX))*RTVL
      RTARP(1,NG(NZ,NY,NX),NZ,NY,NX)=RTARP(1,NG(NZ,NY,NX),NZ,NY,NX)
     2+SDAR(NZ,NY,NX)
      IF(IDTHRN.EQ.NRT(NZ,NY,NX).OR.(WTRVC(NZ,NY,NX)
     2.LT.ZEROL(NZ,NY,NX).AND.ISTYP(NZ,NY,NX).NE.0))THEN
      IDTHR(NZ,NY,NX)=1
      IDTHP(NZ,NY,NX)=1
      ENDIF
C
C     ROOT N2 FIXATION (LEGUMES)
C
      IF((INTYP(NZ,NY,NX).EQ.1.OR.INTYP(NZ,NY,NX).EQ.2))THEN
      DO 5400 L=NU(NY,NX),NIX(NZ,NY,NX)
      IF(WTRTD(1,L,NZ,NY,NX).GT.ZEROL(NZ,NY,NX))THEN 
C
C     INITIAL INFECTION
C
      IF(WTNDL(L,NZ,NY,NX).LE.0.0)THEN
      WTNDL(L,NZ,NY,NX)=WTNDL(L,NZ,NY,NX)
     2+WTNDI*AREA(3,NU(NY,NX),NY,NX)
      WTNDLN(L,NZ,NY,NX)=WTNDLN(L,NZ,NY,NX) 
     2+WTNDI*AREA(3,NU(NY,NX),NY,NX)*CNND(NZ,NY,NX)
      WTNDLP(L,NZ,NY,NX)=WTNDLP(L,NZ,NY,NX) 
     2+WTNDI*AREA(3,NU(NY,NX),NY,NX)*CPND(NZ,NY,NX)
      ENDIF
C
C     O2-UNCONSTRAINED RESPIRATION RATES BY HETEROTROPHIC AEROBES
C     IN NODULE FROM SPECIFIC OXIDATION RATE, ACTIVE BIOMASS,
C     NON-STRUCTURAL C CONCENTRATION, MICROBIAL C:N:P FACTOR,
C     AND TEMPERATURE
C
      IF(WTNDL(L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      CCPOLN=AMAX1(0.0,CPOOLN(L,NZ,NY,NX)/WTNDL(L,NZ,NY,NX))
      CZPOLN=AMAX1(0.0,ZPOOLN(L,NZ,NY,NX)/WTNDL(L,NZ,NY,NX))
      CPPOLN=AMAX1(0.0,PPOOLN(L,NZ,NY,NX)/WTNDL(L,NZ,NY,NX))
      ELSE
      CCPOLN=1.0
      CZPOLN=1.0
      CPPOLN=1.0
      ENDIF
      IF(CCPOLN.GT.ZERO)THEN 
      CCC=AMIN1(CZPOLN/(CZPOLN+CCPOLN/CNKI)
     2,CPPOLN/(CPPOLN+CCPOLN/CPKI))
      CNC=CCPOLN/(CCPOLN+CZPOLN/ZSKI)
      CPC=CCPOLN/(CCPOLN+CPPOLN/PSKI)
      CNF=CCPOLN/(CCPOLN+CZPOLN/ZSKF)
      ELSE
      CCC=0.0
      CNC=0.0
      CPC=0.0
      CNF=0.0
      ENDIF
      IF(WTNDL(L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FCNPF=AMIN1(1.0,AMAX1(0.0
     2,WTNDLN(L,NZ,NY,NX)/(WTNDL(L,NZ,NY,NX)*CNND(NZ,NY,NX))
     3,WTNDLP(L,NZ,NY,NX)/(WTNDL(L,NZ,NY,NX)*CPND(NZ,NY,NX))))
      ELSE
      FCNPF=1.0
      ENDIF
      RDNDLX=CCPOLN/(CCPOLN+CCNKX)
      RCNDLM=AMAX1(0.0,AMIN1(CPOOLN(L,NZ,NY,NX)*(1.0-DMND(NZ,NY,NX))
     2,VMXO*WTNDL(L,NZ,NY,NX)*CCPOLN/(CCPOLN+CCNKM)
     3*TFN4(L,NZ,NY,NX)*FCNPF*WFNGR(1,L)))*CNF
C
C     O2-LIMITED NODULE RESPIRATION FROM 'WFR' IN 'UPTAKE'
C
      RCNDL=RCNDLM*WFR(1,L,NZ,NY,NX) 
C
C     NODULE MAINTENANCE RESPIRATION FROM SOIL TEMPERATURE,
C     NODULE STRUCTURAL N
C
      RMNDL=AMAX1(0.0,RMPLT*WTNDLN(L,NZ,NY,NX))*TFN6(L)*RDNDLX 
C
C     NODULE GROWTH RESPIRATION FROM TOTAL - MAINTENANCE
C     IF > 0 DRIVES GROWTH, IF < 0 DRIVES REMOBILIZATION
C
      RXNDLM=RCNDLM-RMNDL
      RXNDL=RCNDL-RMNDL
      RGNDLM=AMAX1(0.0,RXNDLM) 
      RGNDL=AMAX1(0.0,RXNDL) 
      RSNDLM=AMAX1(0.0,-RXNDLM)
      RSNDL=AMAX1(0.0,-RXNDL)
C
C     NODULE N2 FIXATION FROM GROWTH RESPIRATION, FIXATION ENERGY
C     REQUIREMENT AND NON-STRUCTURAL C:N:P PRODUCT INHIBITION,
C     CONSTRAINED BY MICROBIAL N REQUIREMENT
C
      RGN2P=AMAX1(0.0,WTNDL(L,NZ,NY,NX)*CNND(NZ,NY,NX)
     2-WTNDLN(L,NZ,NY,NX))/EN2F
      RGN2F=AMIN1(RGNDL,RGN2P)
      RUPNF(L,NZ,NY,NX)=RGN2F*EN2F 
      UPNF(NZ,NY,NX)=UPNF(NZ,NY,NX)+RUPNF(L,NZ,NY,NX)
C
C     TOTAL NON-STRUCTURAL C,N,P USED IN NODULE GROWTH
C     AND GROWTH RESPIRATION DEPENDS ON GROWTH YIELD ENTERED IN 'READQ'
C
      CGNDL=(RGNDL-RGN2F)/(1.0-DMND(NZ,NY,NX))
      GRNDG=CGNDL*DMND(NZ,NY,NX)
      ZADDN=AMAX1(0.0,AMIN1(ZPOOLN(L,NZ,NY,NX)
     2,GRNDG*CNND(NZ,NY,NX))*CCC)
      PADDN=AMAX1(0.0,AMIN1(PPOOLN(L,NZ,NY,NX)
     2,GRNDG*CPND(NZ,NY,NX))*CCC)
C
C     NODULE C,N,P REMOBILIZATION AND DECOMPOSITION 
C
      RCCC=RCCZ+CCC*RCCY
      RCCN=CNC*RCCX(IGTYP(NZ,NY,NX))
      RCCP=CPC*RCCQ(IGTYP(NZ,NY,NX))
      SPNDX=SPNDL*RDNDLX 
      RXNDLC=SPNDX*WTNDL(L,NZ,NY,NX)*WFNGR(1,L)
      RXNDLN=SPNDX*WTNDLN(L,NZ,NY,NX)*WFNGR(1,L)
      RXNDLP=SPNDX*WTNDLP(L,NZ,NY,NX)*WFNGR(1,L)
      RDNDLC=RXNDLC*(1.0-RCCC) 
      RDNDLN=RXNDLN*(1.0-RCCN) 
      RDNDLP=RXNDLP*(1.0-RCCP) 
      RCNDLC=RXNDLC*RCCC 
      RCNDLN=RXNDLN*RCCN 
      RCNDLP=RXNDLP*RCCP 
C
C     NODULE SENESCENCE
C
      IF(RSNDL.GT.0.0.AND.WTNDL(L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.RCCC.GT.ZERO)THEN
      RXNSNC=RSNDL/RCCC 
      RXNSNN=RXNSNC*WTNDLN(L,NZ,NY,NX)/WTNDL(L,NZ,NY,NX)
      RXNSNP=RXNSNC*WTNDLP(L,NZ,NY,NX)/WTNDL(L,NZ,NY,NX)
      RDNSNC=RXNSNC*(1.0-RCCC)
      RDNSNN=RXNSNN*(1.0-RCCN)
      RDNSNP=RXNSNP*(1.0-RCCP)
      RCNSNC=RXNSNC*RCCC
      RCNSNN=RXNSNN*RCCN
      RCNSNP=RXNSNP*RCCP
      ELSE
      RXNSNC=0.0
      RXNSNN=0.0
      RXNSNP=0.0
      RDNSNC=0.0
      RDNSNN=0.0
      RDNSNP=0.0
      RCNSNC=0.0
      RCNSNN=0.0
      RCNSNP=0.0
      ENDIF
C
C     TOTAL NODULE RESPIRATION
C
      RCO2TM=AMIN1(RMNDL,RCNDLM)+RGNDLM+RCNSNC 
      RCO2T=AMIN1(RMNDL,RCNDL)+RGNDL+RCNSNC 
      RCO2M(1,L,NZ,NY,NX)=RCO2M(1,L,NZ,NY,NX)+RCO2TM
      RCO2N(1,L,NZ,NY,NX)=RCO2N(1,L,NZ,NY,NX)+RCO2T
      RCO2A(1,L,NZ,NY,NX)=RCO2A(1,L,NZ,NY,NX)-RCO2T
C
C     NODULE LITTERFALL CAUSED BY REMOBILIZATION
C
      DO 6370 M=1,4
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+CFOPC(4,M,NZ,NY,NX)
     2*(RDNDLC+RDNSNC)
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+CFOPN(4,M,NZ,NY,NX)
     2*(RDNDLN+RDNSNN) 
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+CFOPP(4,M,NZ,NY,NX)
     2*(RDNDLP+RDNSNP) 
6370  CONTINUE
C
C     CONSUMPTION OF NON-STRUCTURAL C,N,P BY NODULE
C
      CPOOLN(L,NZ,NY,NX)=CPOOLN(L,NZ,NY,NX)-AMIN1(RMNDL,RCNDL)
     2-RGN2F-CGNDL+RCNDLC
      ZPOOLN(L,NZ,NY,NX)=ZPOOLN(L,NZ,NY,NX)-ZADDN+RCNDLN+RCNSNN
     2+RUPNF(L,NZ,NY,NX) 
      PPOOLN(L,NZ,NY,NX)=PPOOLN(L,NZ,NY,NX)-PADDN+RCNDLP+RCNSNP
C
C     UPDATE STATE VARIABLES FOR NODULE C, N, P
C
      WTNDL(L,NZ,NY,NX)=WTNDL(L,NZ,NY,NX)+GRNDG-RXNDLC-RXNSNC
      WTNDLN(L,NZ,NY,NX)=WTNDLN(L,NZ,NY,NX)+ZADDN-RXNDLN-RXNSNN
      WTNDLP(L,NZ,NY,NX)=WTNDLP(L,NZ,NY,NX)+PADDN-RXNDLP-RXNSNP
C
C     TRANSFER NON-STRUCTURAL C,N,P BETWEEN ROOT AND NODULES
C     FROM NON-STRUCTURAL C,N,P CONCENTRATION DIFFERENCES
C
      IF(CPOOLR(1,L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.WTRTD(1,L,NZ,NY,NX).GT.ZEROL(NZ,NY,NX))THEN
      WTRTD1=WTRTD(1,L,NZ,NY,NX)
      WTNDL1=AMIN1(WTRTD(1,L,NZ,NY,NX),AMAX1(FSNKM
     2*WTRTD(1,L,NZ,NY,NX),WTNDL(L,NZ,NY,NX)))
      WTRTDT=WTRTD1+WTRTD2
      IF(WTRTDT.GT.ZEROP(NZ,NY,NX))THEN
      CPOOLD=(CPOOLR(1,L,NZ,NY,NX)*WTNDL1
     2-CPOOLN(L,NZ,NY,NX)*WTRTD1)/WTRTDT 
      XFRC=FXRN(INTYP(NZ,NY,NX))*CPOOLD 
      CPOOLR(1,L,NZ,NY,NX)=CPOOLR(1,L,NZ,NY,NX)-XFRC
      CPOOLN(L,NZ,NY,NX)=CPOOLN(L,NZ,NY,NX)+XFRC 
      CPOOLT=CPOOLR(1,L,NZ,NY,NX)+CPOOLN(L,NZ,NY,NX)
      IF(CPOOLT.GT.ZEROP(NZ,NY,NX))THEN
      ZPOOLD=(ZPOOLR(1,L,NZ,NY,NX)*CPOOLN(L,NZ,NY,NX)
     2-ZPOOLN(L,NZ,NY,NX)*CPOOLR(1,L,NZ,NY,NX))/CPOOLT 
      XFRN=FXRN(INTYP(NZ,NY,NX))*ZPOOLD 
      PPOOLD=(PPOOLR(1,L,NZ,NY,NX)*CPOOLN(L,NZ,NY,NX)
     2-PPOOLN(L,NZ,NY,NX)*CPOOLR(1,L,NZ,NY,NX))/CPOOLT 
      XFRP=FXRN(INTYP(NZ,NY,NX))*PPOOLD 
      ZPOOLR(1,L,NZ,NY,NX)=ZPOOLR(1,L,NZ,NY,NX)-XFRN
      PPOOLR(1,L,NZ,NY,NX)=PPOOLR(1,L,NZ,NY,NX)-XFRP
      ZPOOLN(L,NZ,NY,NX)=ZPOOLN(L,NZ,NY,NX)+XFRN 
      PPOOLN(L,NZ,NY,NX)=PPOOLN(L,NZ,NY,NX)+XFRP 
C     IF(L.EQ.1)THEN
C     WRITE(*,2122)'NODEX',I,J,NZ,L,XFRC,XFRN,XFRP
C    3,WTRTD(1,L,NZ,NY,NX),WTRTDT,CPOOLT 
C    4,WTNDL(L,NZ,NY,NX),WTNDLN(L,NZ,NY,NX),WTNDLP(L,NZ,NY,NX)
C    2,CPOOLN(L,NZ,NY,NX),ZPOOLN(L,NZ,NY,NX),PPOOLN(L,NZ,NY,NX)
C    3,CPOOLR(1,L,NZ,NY,NX),ZPOOLR(1,L,NZ,NY,NX),PPOOLR(1,L,NZ,NY,NX)
C     ENDIF
      ENDIF
      ENDIF
      ENDIF
C     IF(L.EQ.1)THEN
C     WRITE(*,2122)'NODGR',I,J,NZ,L,RCNDL,RMNDL,RGNDL,RGN2P 
C    2,RGN2F,CGNDL,GRNDG,CCC,ZADDN,PADDN,SNCR,RCCC,RCCN,RCCP 
C    8,FSNCN,RCCO,RDNDLC,RDNDLN,RDNDLP,WFR(1,L,NZ,NY,NX)  
C    3,WTNDL(L,NZ,NY,NX),WTNDLN(L,NZ,NY,NX),WTNDLP(L,NZ,NY,NX)
C    2,CPOOLN(L,NZ,NY,NX),ZPOOLN(L,NZ,NY,NX),PPOOLN(L,NZ,NY,NX)
C    5,FCNPF,TFN4(L,NZ,NY,NX),WFNGR(1,L)
2122  FORMAT(A8,4I4,60E24.16)
C     ENDIF
      ENDIF
5400  CONTINUE
      ENDIF
C
C     TRANSFER NON-STRUCTURAL C,N,P AMONG BRANCH LEAVES
C     FROM NON-STRUCTURAL C,N,P CONCENTRATION DIFFERENCES
C     WHEN SEASONAL STORAGE C IS NOT BEING MOBILIZED
C
      IF(NBR(NZ,NY,NX).GT.1)THEN
      WTPLTT=0.0
      CPOOLT=0.0
      ZPOOLT=0.0
      PPOOLT=0.0
      DO 300 NB=1,NBR(NZ,NY,NX)
      IF(IDTHB(NB,NZ,NY,NX).EQ.0)THEN
      IF(ATRP(NB,NZ,NY,NX).GT.ATRPX)THEN
      WTLSBZ(NB)=AMAX1(0.0,WTLSB(NB,NZ,NY,NX))
      CPOOLZ(NB)=AMAX1(0.0,CPOOL(NB,NZ,NY,NX))
      ZPOOLZ(NB)=AMAX1(0.0,ZPOOL(NB,NZ,NY,NX))
      PPOOLZ(NB)=AMAX1(0.0,PPOOL(NB,NZ,NY,NX))
      WTPLTT=WTPLTT+WTLSBZ(NB)
      CPOOLT=CPOOLT+CPOOLZ(NB)
      ZPOOLT=ZPOOLT+ZPOOLZ(NB)
      PPOOLT=PPOOLT+PPOOLZ(NB)
      ENDIF
      ENDIF
300   CONTINUE
      DO 305 NB=1,NBR(NZ,NY,NX)
      IF(IDTHB(NB,NZ,NY,NX).EQ.0)THEN
      IF(ATRP(NB,NZ,NY,NX).GT.ATRPX)THEN
      IF(WTPLTT.GT.ZEROP(NZ,NY,NX)
     2.AND.CPOOLT.GT.ZEROP(NZ,NY,NX))THEN
      CPOOLD=CPOOLT*WTLSBZ(NB)-CPOOLZ(NB)*WTPLTT
      ZPOOLD=ZPOOLT*CPOOLZ(NB)-ZPOOLZ(NB)*CPOOLT
      PPOOLD=PPOOLT*CPOOLZ(NB)-PPOOLZ(NB)*CPOOLT
      XFRC=0.01*CPOOLD/WTPLTT
      XFRN=0.01*ZPOOLD/CPOOLT
      XFRP=0.01*PPOOLD/CPOOLT
      CPOOL(NB,NZ,NY,NX)=CPOOL(NB,NZ,NY,NX)+XFRC
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)+XFRN
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)+XFRP
      ENDIF
      ENDIF
      ENDIF
305   CONTINUE
      ENDIF
C
C     TRANSFER NON-STRUCTURAL C,N,P AMONG BRANCH STALK RESERVES
C     FROM NON-STRUCTURAL C,N,P CONCENTRATION DIFFERENCES
C
      IF(NBR(NZ,NY,NX).GT.1)THEN
      WTSTKT=0.0
      WTRSVT=0.0
      WTRSNT=0.0
      WTRSPT=0.0
      DO 330 NB=1,NBR(NZ,NY,NX)
      IF(IDTHB(NB,NZ,NY,NX).EQ.0)THEN
      IF(IDAY(7,NB,NZ,NY,NX).NE.0)THEN
      WTSTKT=WTSTKT+WVSTKB(NB,NZ,NY,NX)
      WTRSVT=WTRSVT+WTRSVB(NB,NZ,NY,NX)
      WTRSNT=WTRSNT+WTRSBN(NB,NZ,NY,NX)
      WTRSPT=WTRSPT+WTRSBP(NB,NZ,NY,NX)
      ENDIF
      ENDIF
330   CONTINUE
      IF(WTSTKT.GT.ZEROP(NZ,NY,NX)
     2.AND.WTRSVT.GT.ZEROP(NZ,NY,NX))THEN
      DO 335 NB=1,NBR(NZ,NY,NX)
      IF(IDTHB(NB,NZ,NY,NX).EQ.0)THEN
      IF(IDAY(7,NB,NZ,NY,NX).NE.0)THEN
      WTRSVD=WTRSVT*WVSTKB(NB,NZ,NY,NX)
     2-WTRSVB(NB,NZ,NY,NX)*WTSTKT
      XFRC=0.1*WTRSVD/WTSTKT
      WTRSVB(NB,NZ,NY,NX)=WTRSVB(NB,NZ,NY,NX)+XFRC
      WTRSND=WTRSNT*WTRSVB(NB,NZ,NY,NX)
     2-WTRSBN(NB,NZ,NY,NX)*WTRSVT
      XFRN=0.1*WTRSND/WTRSVT
      WTRSBN(NB,NZ,NY,NX)=WTRSBN(NB,NZ,NY,NX)+XFRN
      WTRSPD=WTRSPT*WTRSVB(NB,NZ,NY,NX)
     2-WTRSBP(NB,NZ,NY,NX)*WTRSVT
      XFRP=0.1*WTRSPD/WTRSVT
      WTRSBP(NB,NZ,NY,NX)=WTRSBP(NB,NZ,NY,NX)+XFRP
      ENDIF
      ENDIF
335   CONTINUE
      ENDIF
      ENDIF
C
C     TRANSFER NON-STRUCTURAL C,N,P BWTWEEN ROOT AND MYCORRHIZAE
C     IN EACH ROOTED SOIL LAYER FROM NON-STRUCTURAL C,N,P CONCENTRATION
C     DIFFERENCES
C
      IF(MY(NZ,NY,NX).EQ.2)THEN
      DO 425 L=NU(NY,NX),NIX(NZ,NY,NX)
      IF(CPOOLR(1,L,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.WTRTD(1,L,NZ,NY,NX).GT.ZEROL(NZ,NY,NX))THEN
      WTRTD1=WTRTD(1,L,NZ,NY,NX)
      WTRTD2=AMIN1(WTRTD(1,L,NZ,NY,NX),AMAX1(FSNKM
     2*WTRTD(1,L,NZ,NY,NX),WTRTD(2,L,NZ,NY,NX)))
      WTPLTT=WTRTD1+WTRTD2
      IF(WTPLTT.GT.ZEROP(NZ,NY,NX))THEN
      CPOOLD=(CPOOLR(1,L,NZ,NY,NX)*WTRTD2
     2-CPOOLR(2,L,NZ,NY,NX)*WTRTD1)/WTPLTT
      XFRC=FMYC*CPOOLD
      CPOOLR(1,L,NZ,NY,NX)=CPOOLR(1,L,NZ,NY,NX)-XFRC
      CPOOLR(2,L,NZ,NY,NX)=CPOOLR(2,L,NZ,NY,NX)+XFRC
      CPOOLT=CPOOLR(1,L,NZ,NY,NX)+CPOOLR(2,L,NZ,NY,NX)
      IF(CPOOLT.GT.ZEROP(NZ,NY,NX))THEN
      ZPOOLD=(ZPOOLR(1,L,NZ,NY,NX)*CPOOLR(2,L,NZ,NY,NX)
     2-ZPOOLR(2,L,NZ,NY,NX)*CPOOLR(1,L,NZ,NY,NX))/CPOOLT 
      XFRN=FMYC*ZPOOLD 
      PPOOLD=(PPOOLR(1,L,NZ,NY,NX)*CPOOLR(2,L,NZ,NY,NX)
     2-PPOOLR(2,L,NZ,NY,NX)*CPOOLR(1,L,NZ,NY,NX))/CPOOLT 
      XFRP=FMYC*PPOOLD 
      ZPOOLR(1,L,NZ,NY,NX)=ZPOOLR(1,L,NZ,NY,NX)-XFRN
      ZPOOLR(2,L,NZ,NY,NX)=ZPOOLR(2,L,NZ,NY,NX)+XFRN
      PPOOLR(1,L,NZ,NY,NX)=PPOOLR(1,L,NZ,NY,NX)-XFRP
      PPOOLR(2,L,NZ,NY,NX)=PPOOLR(2,L,NZ,NY,NX)+XFRP
C     IF(L.EQ.NIX(NZ,NY,NX))THEN
C     WRITE(*,9873)'MYCO',I,J,NZ,L,XFRC,XFRN,XFRP
C    2,CPOOLR(1,L,NZ,NY,NX),WTRTD(1,L,NZ,NY,NX)
C    3,CPOOLR(2,L,NZ,NY,NX),WTRTD2
C    3,WTPLTT,ZPOOLR(1,L,NZ,NY,NX),ZPOOLR(2,L,NZ,NY,NX)
C    4,PPOOLR(1,L,NZ,NY,NX),PPOOLR(2,L,NZ,NY,NX),CPOOLT 
9873  FORMAT(A8,4I4,20E24.16)
C     ENDIF
      ENDIF
      ENDIF
      ENDIF
425   CONTINUE
      ENDIF
C
C     TRANSFER NON-STRUCTURAL C,N,P BETWEEN ROOT AND STORAGE
C
C     IF(IFLGZ.EQ.1.AND.ISTYP(NZ,NY,NX).NE.0)THEN
C     DO 5545 N=1,MY(NZ,NY,NX)
C     DO 5550 L=NU(NY,NX),NI(NZ,NY,NX)
C     IF(CCPOLR(N,L,NZ,NY,NX).GT.ZERO)THEN
C     CNL=CCPOLR(N,L,NZ,NY,NX)/(CCPOLR(N,L,NZ,NY,NX)
C    2+CZPOLR(N,L,NZ,NY,NX)/ZSKI)
C     CPL=CCPOLR(N,L,NZ,NY,NX)/(CCPOLR(N,L,NZ,NY,NX)
C    2+CPPOLR(N,L,NZ,NY,NX)/PSKI)
C     ELSE
C     CNL=0.0
C     CPL=0.0
C     ENDIF
C     XFRCX=FXFB(IBTYP(NZ,NY,NX),IWTYP(NZ,NY,NX))
C    2*AMAX1(0.0,CPOOLR(N,L,NZ,NY,NX))
C     XFRNX=FXFB(IBTYP(NZ,NY,NX),IWTYP(NZ,NY,NX))
C    2*AMAX1(0.0,ZPOOLR(N,L,NZ,NY,NX))*(1.0+CNL)
C     XFRPX=FXFB(IBTYP(NZ,NY,NX),IWTYP(NZ,NY,NX))
C    2*AMAX1(0.0,PPOOLR(N,L,NZ,NY,NX))*(1.0+CPL)
C     XFRC=AMIN1(XFRCX,XFRNX/CNMN,XFRPX/CPMN)
C     XFRN=AMIN1(XFRNX,XFRC*CNMX,XFRPX*CNMX/CPMN*0.5)
C     XFRP=AMIN1(XFRPX,XFRC*CPMX,XFRNX*CPMX/CNMN*0.5)
C     CPOOLR(N,L,NZ,NY,NX)=CPOOLR(N,L,NZ,NY,NX)-XFRC
C     WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)+XFRC
C     ZPOOLR(N,L,NZ,NY,NX)=ZPOOLR(N,L,NZ,NY,NX)-XFRN
C     WTRVN(NZ,NY,NX)=WTRVN(NZ,NY,NX)+XFRN
C     PPOOLR(N,L,NZ,NY,NX)=PPOOLR(N,L,NZ,NY,NX)-XFRP
C     WTRVP(NZ,NY,NX)=WTRVP(NZ,NY,NX)+XFRP
5550  CONTINUE
5545  CONTINUE
C     ENDIF
C
C     ROOT AND NODULE TOTALS
C
      DO 5445 N=1,MY(NZ,NY,NX)
      DO 5450 L=NU(NY,NX),NI(NZ,NY,NX)
      WTRTL(N,L,NZ,NY,NX)=0.0
      WTRTD(N,L,NZ,NY,NX)=0.0
      DO 5460 NR=1,NRT(NZ,NY,NX)
      WTRTL(N,L,NZ,NY,NX)=WTRTL(N,L,NZ,NY,NX)+WTRT2(N,L,NR,NZ,NY,NX)
      WTRTD(N,L,NZ,NY,NX)=WTRTD(N,L,NZ,NY,NX)+WTRT2(N,L,NR,NZ,NY,NX)
     2+WTRT1(N,L,NR,NZ,NY,NX)
5460  CONTINUE
      TCSNR(NZ,NY,NX)=TCSNR(NZ,NY,NX)+RCO2A(N,L,NZ,NY,NX)
      RECO(NY,NX)=RECO(NY,NX)+RCO2A(N,L,NZ,NY,NX)
      TRAU(NY,NX)=TRAU(NY,NX)+RCO2A(N,L,NZ,NY,NX)
5450  CONTINUE
      DO 5470 NR=1,NRT(NZ,NY,NX)
      WTRTL(N,NINR(NR,NZ,NY,NX),NZ,NY,NX)
     2=WTRTL(N,NINR(NR,NZ,NY,NX),NZ,NY,NX)
     3+RTWT1(N,NR,NZ,NY,NX)
5470  CONTINUE
5445  CONTINUE
C
C     TRANSFER NON-STRUCTURAL C,N,P BETWEEN ROOT AND SHOOT
C
C     SINK STRENGTH OF ROOTS IN EACH SOIL LAYER AS A FRACTION
C     OF TOTAL SINK STRENGTH OF ROOTS IN ALL SOIL LAYERS 
C
      IF(ISTYP(NZ,NY,NX).EQ.1)THEN
      IF(WTLS(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FWTC=AMIN1(1.0,0.667*WTRT(NZ,NY,NX)/WTLS(NZ,NY,NX))
      ELSE
      FWTC=1.0
      ENDIF 
      IF(WTRT(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FWTS=AMIN1(1.0,WTLS(NZ,NY,NX)/(0.667*WTRT(NZ,NY,NX)))
      ELSE
      FWTS=1.0
      ENDIF
      ELSE
      FWTC=1.0
      FWTS=1.0
      ENDIF
      DO 290 L=NU(NY,NX),NI(NZ,NY,NX)
      IF(RTNT(1).GT.ZEROP(NZ,NY,NX))THEN
      FWTR(L)=AMAX1(1.0E-03,RLNT(1,L)/RTNT(1))
      ELSE
      FWTR(L)=1.0
      ENDIF
290   CONTINUE
C
C     RATE CONSTANT FOR TRANSFER IS SET FROM INPUT IN 'READQ'
C     BUT IS NOT USED FOR ANNUALS DURING GRAIN FILL
C
      WTLS(NZ,NY,NX)=0.0
      DO 309 NB=1,NBR(NZ,NY,NX)
      WTLS(NZ,NY,NX)=WTLS(NZ,NY,NX)+WTLSB(NB,NZ,NY,NX)
309   CONTINUE
      DO 310 NB=1,NBR(NZ,NY,NX)
      IF(IDTHB(NB,NZ,NY,NX).EQ.0
     2.AND.(ISTYP(NZ,NY,NX).NE.0.OR.IDAY(7,NB,NZ,NY,NX).EQ.0))THEN
C
C     SINK STRENGTH OF BRANCHES IN EACH CANOPY AS A FRACTION
C     OF TOTAL SINK STRENGTH OF THE CANOPY 
C
      IF(WTLS(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FWTB(NB)=AMAX1(0.0,WTLSB(NB,NZ,NY,NX)/WTLS(NZ,NY,NX))
      ELSE
      FWTB(NB)=1.0
      ENDIF
      IF(FDBK(NB,NZ,NY,NX).GT.ZERO)THEN
      FSNKR=0.75/FDBK(NB,NZ,NY,NX)
      ELSE
      FSNKR=1.0
      ENDIF
      PTSHTR=AMIN1(1.0,PTSHT(NZ,NY,NX)*FSNKR)
      DO 415 L=NU(NY,NX),NI(NZ,NY,NX)
      WTLSBX=WTLSB(NB,NZ,NY,NX)*FWODB(1)*FWTR(L)*FWTC 
      WTRTLX=WTRTL(1,L,NZ,NY,NX)*FWOOD(1)*FWTB(NB)*FWTS 
      WTLSBB=AMAX1(0.0,WTLSBX,FSNKM*WTRTLX)
      WTRTLR=AMAX1(0.0,WTRTLX,FSNKM*WTLSBX)
      WTPLTT=WTLSBB+WTRTLR
      IF(WTPLTT.GT.ZEROP(NZ,NY,NX))THEN
      CPOOLB=AMAX1(0.0,CPOOL(NB,NZ,NY,NX)*FWTR(L))
      CPOOLS=AMAX1(0.0,CPOOLR(1,L,NZ,NY,NX)*FWTB(NB))
      CPOOLD=(CPOOLB*WTRTLR-CPOOLS*WTLSBB)/WTPLTT
      XFRC=PTSHTR*CPOOLD
      CPOOL(NB,NZ,NY,NX)=CPOOL(NB,NZ,NY,NX)-XFRC
      CPOOLR(1,L,NZ,NY,NX)=CPOOLR(1,L,NZ,NY,NX)+XFRC
      CPOOLT=CPOOLS+CPOOLB
      IF(CPOOLT.GT.ZEROP(NZ,NY,NX))THEN
      ZPOOLB=AMAX1(0.0,ZPOOL(NB,NZ,NY,NX)*FWTR(L))
      ZPOOLS=AMAX1(0.0,ZPOOLR(1,L,NZ,NY,NX)*FWTB(NB))
      ZPOOLD=(ZPOOLB*CPOOLS-ZPOOLS*CPOOLB)/CPOOLT
      XFRN=PTSHTR*ZPOOLD 
      PPOOLB=AMAX1(0.0,PPOOL(NB,NZ,NY,NX)*FWTR(L))
      PPOOLS=AMAX1(0.0,PPOOLR(1,L,NZ,NY,NX)*FWTB(NB))
      PPOOLD=(PPOOLB*CPOOLS-PPOOLS*CPOOLB)/CPOOLT
      XFRP=PTSHTR*PPOOLD 
      ELSE
      XFRN=0.0
      XFRP=0.0
      ENDIF
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)-XFRN
      ZPOOLR(1,L,NZ,NY,NX)=ZPOOLR(1,L,NZ,NY,NX)+XFRN
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)-XFRP
      PPOOLR(1,L,NZ,NY,NX)=PPOOLR(1,L,NZ,NY,NX)+XFRP
C     IF(NZ.EQ.3)THEN
C     WRITE(*,3344)'ROOT',I,J,NX,NY,NZ,NB,L 
C    2,FSNKR,FDBK(NB,NZ,NY,NX),CPOOL(NB,NZ,NY,NX)
C    3,CPOOLR(1,L,NZ,NY,NX),ZPOOL(NB,NZ,NY,NX)
C    3,ZPOOLR(1,L,NZ,NY,NX),FWTB(NB),FWTR(L) 
C    3,FWTC,FWTS,XFRC,XFRN,XFRP,WTLSBX,WTRTLX 
C    4,CPOOLD,CPOOLB,WTRTLR,CPOOLS,WTLSBB 
C    5,FWOOD(1),FWODB(1),WTRTL(1,L,NZ,NY,NX) 
C    6,WTLSB(NB,NZ,NY,NX),RLNT(1,L),RTNT(1)
3344  FORMAT(A8,7I4,30E12.4)
C     ENDIF
      ENDIF
415   CONTINUE
      ENDIF
310   CONTINUE
C
C     TOTAL C,N,P IN EACH BRANCH
C
      DO 320 NB=1,NBR(NZ,NY,NX)
      CPOOLK(NB,NZ,NY,NX)=0.0
      DO 325 K=1,25
      CPOOLK(NB,NZ,NY,NX)=CPOOLK(NB,NZ,NY,NX)
     2+CPOOL3(K,NB,NZ,NY,NX)+CPOOL4(K,NB,NZ,NY,NX)
     3+CO2B(K,NB,NZ,NY,NX)+HCOB(K,NB,NZ,NY,NX)
325   CONTINUE
      WTSHTB(NB,NZ,NY,NX)=WTLFB(NB,NZ,NY,NX)
     2+WTSHEB(NB,NZ,NY,NX)+WTSTKB(NB,NZ,NY,NX)+WTRSVB(NB,NZ,NY,NX)
     3+WTHSKB(NB,NZ,NY,NX)+WTEARB(NB,NZ,NY,NX)+WTGRB(NB,NZ,NY,NX)
     4+CPOOL(NB,NZ,NY,NX)+CPOOLK(NB,NZ,NY,NX)
      WTSHTN(NB,NZ,NY,NX)=WTLFBN(NB,NZ,NY,NX)
     2+WTSHBN(NB,NZ,NY,NX)+WTSTBN(NB,NZ,NY,NX)+WTRSBN(NB,NZ,NY,NX)
     3+WTHSBN(NB,NZ,NY,NX)+WTEABN(NB,NZ,NY,NX)+WTGRBN(NB,NZ,NY,NX)
     4+ZPOOL(NB,NZ,NY,NX)
      WTSHTP(NB,NZ,NY,NX)=WTLFBP(NB,NZ,NY,NX)
     2+WTSHBP(NB,NZ,NY,NX)+WTSTBP(NB,NZ,NY,NX)+WTRSBP(NB,NZ,NY,NX)
     3+WTHSBP(NB,NZ,NY,NX)+WTEABP(NB,NZ,NY,NX)+WTGRBP(NB,NZ,NY,NX)
     4+PPOOL(NB,NZ,NY,NX)
320   CONTINUE
C
C     TOTAL C,N,P IN ROOTS AND MYCORRHIZAE IN EACH SOIL LAYER
C
      DO 345 N=1,MY(NZ,NY,NX)
      DO 345 L=NU(NY,NX),NI(NZ,NY,NX)
      WTRTD(N,L,NZ,NY,NX)=WTRTD(N,L,NZ,NY,NX)+CPOOLR(N,L,NZ,NY,NX)
345   CONTINUE
      ELSE
      HCUPTK(NZ,NY,NX)=UPOMC(NZ,NY,NX)
      HZUPTK(NZ,NY,NX)=UPOMN(NZ,NY,NX)+UPNH4(NZ,NY,NX)+UPNO3(NZ,NY,NX)
     2+UPNF(NZ,NY,NX)
      HPUPTK(NZ,NY,NX)=UPOMP(NZ,NY,NX)+UPH2P(NZ,NY,NX)
      ENDIF
C
C     TRANSFER ABOVE-GROUND C,N,P AT HARVEST OR DISTURBANCE
C
      IF((IHVST(NZ,I,NY,NX).GE.0.AND.J.EQ.INT(ZNOON(NY,NX))
     2.AND.IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)
     3.OR.(IHVST(NZ,I,NY,NX).EQ.4.OR.IHVST(NZ,I,NY,NX).EQ.6))THEN
C
C     ACCUMULATE ALL HARVESTED MATERIAL ABOVE CUTTING HEIGHT
C     ACCOUNTING FOR HARVEST EFFICIENCY ENTERED IN 'READS'
C
      IF(IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)THEN
      IF(JHVST(NZ,I,NY,NX).NE.2)THEN
      PPX(NZ,NY,NX)=PPX(NZ,NY,NX)*(1.0-THIN(NZ,I,NY,NX))
      PP(NZ,NY,NX)=PP(NZ,NY,NX)*(1.0-THIN(NZ,I,NY,NX))
      ELSE
C     PPI(NZ,NY,NX)=AMAX1(1.0,0.5*(PPI(NZ,NY,NX)+GRNO(NZ,NY,NX)
C    2/AREA(3,NU(NY,NX),NY,NX)))
      PPX(NZ,NY,NX)=PPI(NZ,NY,NX)
      PP(NZ,NY,NX)=PPX(NZ,NY,NX)*AREA(3,NU(NY,NX),NY,NX)
      ENDIF
      IF(IHVST(NZ,I,NY,NX).EQ.3)THEN
      CF(NZ,NY,NX)=CF(NZ,NY,NX)*HVST(NZ,I,NY,NX)
      ENDIF
      IF(IHVST(NZ,I,NY,NX).LE.2.AND.HVST(NZ,I,NY,NX).LT.0.0)THEN
      ARLFY=(1.0-ABS(HVST(NZ,I,NY,NX)))*ARLFC(NY,NX)
      ARLFR=0.0
      DO 9875 L=1,NC(NY,NX)
      IF(ZL(L,NY,NX).GT.ZL(L-1,NY,NX)
     2.AND.ARLFT(L,NY,NX).GT.ZEROS(NY,NX)
     3.AND.ARLFR.LT.ARLFY)THEN
      IF(ARLFR+ARLFT(L,NY,NX).GT.ARLFY)THEN
      HVST(NZ,I,NY,NX)=ZL(L-1,NY,NX)+((ARLFY-ARLFR)
     2/ARLFT(L,NY,NX))*(ZL(L,NY,NX)-ZL(L-1,NY,NX))
      ENDIF
      ARLFR=ARLFR+ARLFT(L,NY,NX)
      ENDIF 
C     WRITE(*,6544)'HVST',I,J,L,NZ,IHVST(NZ,I,NY,NX),ARLFC(NY,NX) 
C    2,ARLFT(L,NY,NX),ARLFY,ARLFR,ZL(L,NY,NX),ZL(L-1,NY,NX)
C    3,ARLFV(L,NZ,NY,NX),HVST(NZ,I,NY,NX)
6544  FORMAT(A8,5I4,20E12.4)
9875  CONTINUE
      ENDIF
      WHVSTT=0.0
      WHVSLF=0.0
      WHVHSH=0.0
      WHVEAH=0.0
      WHVGRH=0.0
      WHVSCP=0.0
      WHVSTH=0.0
      WHVRVH=0.0
      ELSE
C
C     GRAZING REMOVAL
C
      IF(WTSHTA(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      WHVSTT=HVST(NZ,I,NY,NX)*THIN(NZ,I,NY,NX)*0.45/24.0
     2*AREA(3,NU(NY,NX),NY,NX)*WTSHT(NZ,NY,NX)/WTSHTA(NZ,NY,NX)
      ELSE
      WHVSTT=0.0
      ENDIF
      IF(IHVST(NZ,I,NY,NX).EQ.6)THEN
      WHVSTT=WHVSTT*TFN3(NZ,NY,NX)
      ENDIF
      CCPOLX=CCPOLP(NZ,NY,NX)/(1.0+CCPOLP(NZ,NY,NX))
      CCPLNX=CCPLNP(NZ,NY,NX)/(1.0+CCPLNP(NZ,NY,NX))
      WHVSLX=WHVSTT*EHVST(1,1,NZ,I,NY,NX)
      WHVSLY=AMIN1(WTLF(NZ,NY,NX),WHVSLX) 
      WHVSLF=WHVSLY*(1.0-CCPOLX)
      WHVSCL=WHVSLY*CCPOLX
      WHVSNL=WHVSLY*CCPLNX
      WHVXXX=AMAX1(0.0,WHVSLX-WHVSLY)
      WHVSSX=WHVSTT*EHVST(1,2,NZ,I,NY,NX)
      WTSHTT=WTSHE(NZ,NY,NX)+WTHSK(NZ,NY,NX)+WTEAR(NZ,NY,NX)
     2+WTGR(NZ,NY,NX)
      IF(WTSHTT.GT.ZEROP(NZ,NY,NX))THEN
      WHVSHX=WHVSSX*WTSHE(NZ,NY,NX)/WTSHTT+WHVXXX
      WHVSHY=AMIN1(WTSHE(NZ,NY,NX),WHVSHX) 
      WHVSHH=WHVSHY*(1.0-CCPOLX)
      WHVSCS=WHVSHY*CCPOLX
      WHVSNS=WHVSHY*CCPLNX
      WHVXXX=AMAX1(0.0,WHVSHX-WHVSHY)
      WHVHSX=WHVSSX*WTHSK(NZ,NY,NX)/WTSHTT+WHVXXX
      WHVHSY=AMIN1(WTHSK(NZ,NY,NX),WHVHSX)
      WHVHSH=WHVHSY 
      WHVXXX=AMAX1(0.0,WHVHSX-WHVHSY)
      WHVEAX=WHVSSX*WTEAR(NZ,NY,NX)/WTSHTT+WHVXXX
      WHVEAY=AMIN1(WTEAR(NZ,NY,NX),WHVEAX) 
      WHVEAH=WHVEAY 
      WHVXXX=AMAX1(0.0,WHVEAX-WHVEAY)
      WHVGRX=WHVSSX*WTGR(NZ,NY,NX)/WTSHTT+WHVXXX
      WHVGRY=AMIN1(WTGR(NZ,NY,NX),WHVGRX) 
      WHVGRH=WHVGRY 
      WHVXXX=AMAX1(0.0,WHVGRX-WHVGRY)
      ELSE
      WHVSHH=0.0
      WHVSCS=0.0
      WHVSNS=0.0
      WHVHSH=0.0
      WHVEAH=0.0
      WHVGRH=0.0
      WHVXXX=WHVXXX+WHVSSX
      ENDIF
      WHVSCP=WHVSCL+WHVSCS
      WHVSNP=WHVSNL+WHVSNS
      WHVSKX=WHVSTT*EHVST(1,3,NZ,I,NY,NX)
      WTSTKT=WTSTK(NZ,NY,NX)+WTRSV(NZ,NY,NX)
      IF(WTSTKT.GT.WHVSKX+WHVXXX)THEN
      WHVSTX=WHVSKX*WTSTK(NZ,NY,NX)/WTSTKT+WHVXXX
      WHVSTY=AMIN1(WTSTK(NZ,NY,NX),WHVSTX) 
      WHVSTH=WHVSTY 
      WHVXXX=AMAX1(0.0,WHVSTX-WHVSTY)
      WHVRVX=WHVSKX*WTRSV(NZ,NY,NX)/WTSTKT+WHVXXX
      WHVRVY=AMIN1(WTRSV(NZ,NY,NX),WHVRVX) 
      WHVRVH=WHVRVY 
      WHVXXX=AMAX1(0.0,WHVRVX-WHVRVY)
      ELSE
      WHVSTH=0.0
      WHVRVH=0.0
      WHVXXX=AMAX1(0.0,WHVSKX)
      IF(WHVXXX.GT.0.0)THEN
      WHVSLY=AMIN1(WTLF(NZ,NY,NX)-WHVSLF-WHVSCL,WHVXXX) 
      WHVSLF=WHVSLF+WHVSLY*(1.0-CCPOLX)
      WHVSCL=WHVSCL+WHVSLY*CCPOLX
      WHVSNL=WHVSNL+WHVSLY*CCPLNX 
      WHVXXX=AMAX1(0.0,WHVXXX-WHVSLY)
      IF(WTSHTT.GT.ZEROP(NZ,NY,NX))THEN
      WHVSHX=WHVXXX*WTSHE(NZ,NY,NX)/WTSHTT 
      WHVSHY=AMIN1(WTSHE(NZ,NY,NX),WHVSHX) 
      WHVSHH=WHVSHH+WHVSHY*(1.0-CCPOLX)
      WHVSCS=WHVSCS+WHVSHY*CCPOLX
      WHVSNS=WHVSNS+WHVSHY*CCPLNX
      WHVXXX=AMAX1(0.0,WHVXXX-WHVSHY)
      WHVHSX=WHVXXX*WTHSK(NZ,NY,NX)/WTSHTT
      WHVHSY=AMIN1(WTHSK(NZ,NY,NX),WHVHSX) 
      WHVHSH=WHVHSH+WHVHSY 
      WHVXXX=AMAX1(0.0,WHVXXX-WHVHSY)
      WHVEAX=WHVXXX*WTEAR(NZ,NY,NX)/WTSHTT
      WHVEAY=AMIN1(WTEAR(NZ,NY,NX),WHVEAX) 
      WHVEAH=WHVEAH+WHVEAY 
      WHVXXX=AMAX1(0.0,WHVEAX-WHVEAY)
      WHVGRX=WHVXXX*WTGR(NZ,NY,NX)/WTSHTT 
      WHVGRY=AMIN1(WTGR(NZ,NY,NX),WHVGRX)
      WHVGRH=WHVGRH+WHVGRY 
      WHVXXX=AMAX1(0.0,WHVGRX-WHVGRY)
      ENDIF
      ENDIF
      ENDIF
C
C     ALL HARVEST REMOVALS
C
      DO 9860 NB=1,NBR(NZ,NY,NX)
      DO 9860 L=1,NC(NY,NX)
      DO 9860 K=0,25
      WGLFBL(L,NB,NZ,NY,NX)=0.0
9860  CONTINUE
      DO 9870 NB=1,NBR(NZ,NY,NX)
      DO 9870 L=1,NC(NY,NX)
      DO 9870 K=0,25
      WGLFBL(L,NB,NZ,NY,NX)=WGLFBL(L,NB,NZ,NY,NX)
     2+WGLFL(L,K,NB,NZ,NY,NX)
9870  CONTINUE
      ENDIF
      DO 9865 L=NC(NY,NX),1,-1
      IF(IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)THEN
      IF(IHVST(NZ,I,NY,NX).NE.3)THEN
      IF(ZL(L,NY,NX).GT.ZL(L-1,NY,NX))THEN
      FHGT=AMAX1(0.0,AMIN1(1.0,1.0-((ZL(L,NY,NX))
     2-HVST(NZ,I,NY,NX))/(ZL(L,NY,NX)-ZL(L-1,NY,NX))))
      ELSE
      FHGT=1.0
      ENDIF
      ELSE
      FHGT=0.0
      ENDIF
      IF(THIN(NZ,I,NY,NX).EQ.0.0)THEN
      FHVST=AMAX1(0.0,1.0-(1.0-FHGT)*EHVST(1,1,NZ,I,NY,NX))
      FHVSH=FHVST
      ELSE
      FHVST=AMAX1(0.0,1.0-THIN(NZ,I,NY,NX))
      IF(IHVST(NZ,I,NY,NX).EQ.0)THEN
      FHVSH=1.0-(1.0-FHGT)*EHVST(1,1,NZ,I,NY,NX)*THIN(NZ,I,NY,NX)
      ELSE
      FHVSH=FHVST
      ENDIF
      ENDIF
      ELSE
      FHVST=0.0
      FHVSH=0.0
      ENDIF
C
C     CUT LEAVES AT HARVESTED NODES AND LAYERS
C
      DO 9855 NB=1,NBR(NZ,NY,NX)
      IF((IHVST(NZ,I,NY,NX).EQ.4.OR.IHVST(NZ,I,NY,NX).EQ.6)
     2.AND.WTLF(NZ,NY,NX).GT.ZEROL(NZ,NY,NX))THEN
      WHVSBL=WHVSLF*AMAX1(0.0,WGLFBL(L,NB,NZ,NY,NX))/WTLF(NZ,NY,NX)
      ELSE
      WHVSBL=0.0
      ENDIF
      DO 9845 K=25,0,-1
      IF((IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)
     2.OR.WHVSBL.GT.0.0)THEN      
      IF(IHVST(NZ,I,NY,NX).EQ.4.OR.IHVST(NZ,I,NY,NX).EQ.6)THEN
      IF(WGLFL(L,K,NB,NZ,NY,NX).GT.WHVSBL)THEN
      FHVST=AMAX1(0.0,AMIN1(1.0,(WGLFL(L,K,NB,NZ,NY,NX)-WHVSBL)
     2/WGLFL(L,K,NB,NZ,NY,NX)))
      FHVSH=FHVST
      ELSE
      FHVST=1.0
      FHVSH=1.0
      ENDIF
      ENDIF 
C
C     HARVESTED LEAF AREA, C, N, P
C
      WHVSBL=WHVSBL-(1.0-FHVST)*WGLFL(L,K,NB,NZ,NY,NX)
      WTHTH1=WTHTH1+(1.0-FHVSH)*WGLFL(L,K,NB,NZ,NY,NX)*FWODB(1)
      WTHNH1=WTHNH1+(1.0-FHVSH)*WGLFLN(L,K,NB,NZ,NY,NX)*FWODLN(1)
      WTHPH1=WTHPH1+(1.0-FHVSH)*WGLFLP(L,K,NB,NZ,NY,NX)*FWODLP(1)
      WTHTX1=WTHTX1+(FHVSH-FHVST)*WGLFL(L,K,NB,NZ,NY,NX)*FWODB(1) 
      WTHNX1=WTHNX1+(FHVSH-FHVST)*WGLFLN(L,K,NB,NZ,NY,NX)*FWODLN(1) 
      WTHPX1=WTHPX1+(FHVSH-FHVST)*WGLFLP(L,K,NB,NZ,NY,NX)*FWODLP(1) 
      WTHTH3=WTHTH3+(1.0-FHVSH)*WGLFL(L,K,NB,NZ,NY,NX)*FWODB(0)
      WTHNH3=WTHNH3+(1.0-FHVSH)*WGLFLN(L,K,NB,NZ,NY,NX)*FWODLN(0)
      WTHPH3=WTHPH3+(1.0-FHVSH)*WGLFLP(L,K,NB,NZ,NY,NX)*FWODLP(0)
      WTHTX3=WTHTX3+(FHVSH-FHVST)*WGLFL(L,K,NB,NZ,NY,NX)*FWODB(0) 
      WTHNX3=WTHNX3+(FHVSH-FHVST)*WGLFLN(L,K,NB,NZ,NY,NX)*FWODLN(0) 
      WTHPX3=WTHPX3+(FHVSH-FHVST)*WGLFLP(L,K,NB,NZ,NY,NX)*FWODLP(0) 
C
C     REMAINING LEAF C,N,P AND AREA
C
      WGLFL(L,K,NB,NZ,NY,NX)=FHVST*WGLFL(L,K,NB,NZ,NY,NX)
      WGLFLN(L,K,NB,NZ,NY,NX)=FHVST*WGLFLN(L,K,NB,NZ,NY,NX)
      WGLFLP(L,K,NB,NZ,NY,NX)=FHVST*WGLFLP(L,K,NB,NZ,NY,NX)
      ARLFL(L,K,NB,NZ,NY,NX)=FHVST*ARLFL(L,K,NB,NZ,NY,NX)
      IF(K.EQ.1)THEN
      ARSTK(L,NB,NZ,NY,NX)=FHVST*ARSTK(L,NB,NZ,NY,NX)
      ENDIF
      ENDIF
C     IF(I.EQ.262.AND.K.EQ.5)THEN
C     WRITE(*,6543)'GRAZ',I,J,NZ,NB,K,L,IHVST(NZ,I,NY,NX) 
C    2,ZL(L,NY,NX),ZL(L-1,NY,NX),HVST(NZ,I,NY,NX),FHVST,FHVSH 
C    5,WGLFBL(L,NB,NZ,NY,NX),WTLF(NZ,NY,NX),CPOOLP(NZ,NY,NX) 
C    6,ARLFL(L,K,NB,NZ,NY,NX),WGLF(K,NB,NZ,NY,NX),ARLF(K,NB,NZ,NY,NX)
C    7,HTNODE(K,NB,NZ,NY,NX)
C    7,WTSHTA(NZ,NY,NX),WHVSBL,WHVSTT,WHVSLF,WHVSHH
C    3,WHVHSH,WHVEAH,WHVGRH,WHVSCP,WHVSTH,WHVRVH,WHVXXX
C    4,WTSHTT,WHVSSX,CCPOLX  
6543  FORMAT(A8,7I4,30E12.4)
C     ENDIF
9845  CONTINUE
9855  CONTINUE
      ARLFV(L,NZ,NY,NX)=0.0
      WGLFV(L,NZ,NY,NX)=0.0
      ARSTV(L,NZ,NY,NX)=ARSTV(L,NZ,NY,NX)*FHVST
9865  CONTINUE
      DO 9835 NB=1,NBR(NZ,NY,NX)
      CPOOLG=0.0
      ZPOOLG=0.0
      PPOOLG=0.0
      CPOLNG=0.0
      ZPOLNG=0.0
      PPOLNG=0.0
      WTNDG=0.0 
      WTNDNG=0.0 
      WTNDPG=0.0
      WGLFGX=0.0
      WGSHGX=0.0
      WGLFGY=0.0
      WGSHGY=0.0
      DO 9825 K=0,25
      ARLFG=0.0
      WGLFG=0.0
      WGLFNG=0.0
      WGLFPG=0.0
C
C     REMAINING LEAF AREA, C, N, P
C
      DO 9815 L=1,NC(NY,NX)
      ARLFG=ARLFG+ARLFL(L,K,NB,NZ,NY,NX)
      WGLFG=WGLFG+WGLFL(L,K,NB,NZ,NY,NX)
      WGLFNG=WGLFNG+WGLFLN(L,K,NB,NZ,NY,NX)
      WGLFPG=WGLFPG+WGLFLP(L,K,NB,NZ,NY,NX)
      ARLFV(L,NZ,NY,NX)=ARLFV(L,NZ,NY,NX)+ARLFL(L,K,NB,NZ,NY,NX)
      WGLFV(L,NZ,NY,NX)=WGLFV(L,NZ,NY,NX)+WGLFL(L,K,NB,NZ,NY,NX)
9815  CONTINUE
C
C     ACCUMULATE REMAINING BRANCH LEAF AREA, C, N, P
C
      IF(IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)THEN
      IF(WGLF(K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX)
     2.AND.EHVST(1,1,NZ,I,NY,NX).GT.0.0)THEN
      FHVSTK(K)=AMAX1(0.0,AMIN1(1.0,(1.0-(1.0-AMAX1(0.0,WGLFG)
     2/WGLF(K,NB,NZ,NY,NX))*EHVST(1,2,NZ,I,NY,NX)
     3/EHVST(1,1,NZ,I,NY,NX))))
      FHVSHK(K)=FHVSTK(K)
      ELSE
      IF(THIN(NZ,I,NY,NX).EQ.0.0)THEN
      FHVSTK(K)=1.0-EHVST(1,2,NZ,I,NY,NX)
      FHVSHK(K)=FHVSTK(K)
      ELSE
      FHVSTK(K)=1.0-THIN(NZ,I,NY,NX)
      IF(IHVST(NZ,I,NY,NX).EQ.0)THEN
      FHVSHK(K)=1.0-EHVST(1,2,NZ,I,NY,NX)*THIN(NZ,I,NY,NX)
      ELSE
      FHVSHK(K)=FHVSTK(K)
      ENDIF
      ENDIF
      ENDIF
      ELSE
      FHVSTK(K)=0.0
      FHVSHK(K)=0.0
      ENDIF
      WGLFGY=WGLFGY+WGLF(K,NB,NZ,NY,NX)
      WTLFB(NB,NZ,NY,NX)=WTLFB(NB,NZ,NY,NX)
     2-WGLF(K,NB,NZ,NY,NX)+WGLFG
      WTLFBN(NB,NZ,NY,NX)=WTLFBN(NB,NZ,NY,NX)
     2-WGLFN(K,NB,NZ,NY,NX)+WGLFNG
      WTLFBP(NB,NZ,NY,NX)=WTLFBP(NB,NZ,NY,NX)
     2-WGLFP(K,NB,NZ,NY,NX)+WGLFPG
      ARLFB(NB,NZ,NY,NX)=ARLFB(NB,NZ,NY,NX)-ARLF(K,NB,NZ,NY,NX)+ARLFG
      IF(ARLF(K,NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      WSLF(K,NB,NZ,NY,NX)=WSLF(K,NB,NZ,NY,NX)*ARLFG/ARLF(K,NB,NZ,NY,NX)
      ELSE
      WSLF(K,NB,NZ,NY,NX)=0.0
      ENDIF
      ARLF(K,NB,NZ,NY,NX)=ARLFG
      WGLF(K,NB,NZ,NY,NX)=WGLFG
      WGLFN(K,NB,NZ,NY,NX)=WGLFNG
      WGLFP(K,NB,NZ,NY,NX)=WGLFPG
      WGLFGX=WGLFGX+WGLF(K,NB,NZ,NY,NX)
9825  CONTINUE
C
C     CUT SHEATHS OR PETIOLES AND STALKS HARVESTED NODES AND LAYERS
C
      HTSTKX=-1.0
      IF((IHVST(NZ,I,NY,NX).EQ.4.OR.IHVST(NZ,I,NY,NX).EQ.6)
     2.AND.WTSHE(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      WHVSBS=WHVSHH*WTSHEB(NB,NZ,NY,NX)/WTSHE(NZ,NY,NX)
      ELSE
      WHVSBS=0.0
      ENDIF
      DO 9805 K=25,0,-1
C     WRITE(*,112)'VSTG',I,J,NX,NY,NZ,NB,K,VSTG(NB,NZ,NY,NX),FHVSTK(K)
C    2,HTNODE(K,NB,NZ,NY,NX),HVST(NZ,I,NY,NX)
112   FORMAT(A8,7I4,12E12.4)
      IF(HTNODE(K,NB,NZ,NY,NX).GT.0.0)
     2HTSTKX=AMAX1(HTSTKX,HTNODE(K,NB,NZ,NY,NX))
C
C     HARVESTED SHEATH OR PETIOLE C,N,P
C
      IF((IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)
     2.OR.WHVSBS.GT.0.0)THEN      
      IF(IHVST(NZ,I,NY,NX).EQ.4.OR.IHVST(NZ,I,NY,NX).EQ.6)THEN
      IF(WGSHE(K,NB,NZ,NY,NX).GT.WHVSBS)THEN
      FHVSTK(K)=AMAX1(0.0,AMIN1(1.0,(WGSHE(K,NB,NZ,NY,NX)-WHVSBS)
     2/WGSHE(K,NB,NZ,NY,NX)))
      FHVSHK(K)=FHVSTK(K)
      ELSE
      FHVSTK(K)=0.0
      FHVSHK(K)=0.0
      ENDIF
      ENDIF
      WHVSBS=WHVSBS-(1.0-FHVSTK(K))*WGSHE(K,NB,NZ,NY,NX)
      WTHTH2=WTHTH2+(1.0-FHVSHK(K))*WGSHE(K,NB,NZ,NY,NX)*FWODB(1)
      WTHNH2=WTHNH2+(1.0-FHVSHK(K))*WGSHN(K,NB,NZ,NY,NX)*FWODSN(1)
      WTHPH2=WTHPH2+(1.0-FHVSHK(K))*WGSHP(K,NB,NZ,NY,NX)*FWODSP(1)
      WTHTX2=WTHTX2+(FHVSHK(K)-FHVSTK(K))*WGSHE(K,NB,NZ,NY,NX)
     2*FWODB(1)
      WTHNX2=WTHNX2+(FHVSHK(K)-FHVSTK(K))*WGSHN(K,NB,NZ,NY,NX)
     2*FWODSN(1)
      WTHPX2=WTHPX2+(FHVSHK(K)-FHVSTK(K))*WGSHP(K,NB,NZ,NY,NX)
     2*FWODSP(1)
      WTHTH3=WTHTH3+(1.0-FHVSHK(K))*WGSHE(K,NB,NZ,NY,NX)*FWODB(0)
      WTHNH3=WTHNH3+(1.0-FHVSHK(K))*WGSHN(K,NB,NZ,NY,NX)*FWODSN(0)
      WTHPH3=WTHPH3+(1.0-FHVSHK(K))*WGSHP(K,NB,NZ,NY,NX)*FWODSP(0)
      WTHTX3=WTHTX3+(FHVSHK(K)-FHVSTK(K))*WGSHE(K,NB,NZ,NY,NX)
     2*FWODB(0)
      WTHNX3=WTHNX3+(FHVSHK(K)-FHVSTK(K))*WGSHN(K,NB,NZ,NY,NX)
     2*FWODSN(0)
      WTHPX3=WTHPX3+(FHVSHK(K)-FHVSTK(K))*WGSHP(K,NB,NZ,NY,NX)
     2*FWODSP(0)
C
C     REMAINING SHEATH OR PETIOLE C,N,P AND LENGTH
C
      WGSHGY=WGSHGY+WGSHE(K,NB,NZ,NY,NX)
      WTSHEB(NB,NZ,NY,NX)=WTSHEB(NB,NZ,NY,NX)
     2-(1.0-FHVSTK(K))*WGSHE(K,NB,NZ,NY,NX)
      WTSHBN(NB,NZ,NY,NX)=WTSHBN(NB,NZ,NY,NX)
     2-(1.0-FHVSTK(K))*WGSHN(K,NB,NZ,NY,NX)
      WTSHBP(NB,NZ,NY,NX)=WTSHBP(NB,NZ,NY,NX)
     2-(1.0-FHVSTK(K))*WGSHP(K,NB,NZ,NY,NX)
      WGSHE(K,NB,NZ,NY,NX)=FHVSTK(K)*WGSHE(K,NB,NZ,NY,NX)
      WSSHE(K,NB,NZ,NY,NX)=FHVSTK(K)*WSSHE(K,NB,NZ,NY,NX)
      WGSHN(K,NB,NZ,NY,NX)=FHVSTK(K)*WGSHN(K,NB,NZ,NY,NX)
      WGSHP(K,NB,NZ,NY,NX)=FHVSTK(K)*WGSHP(K,NB,NZ,NY,NX)
      WSSHE(K,NB,NZ,NY,NX)=FHVSTK(K)*WSSHE(K,NB,NZ,NY,NX)
      IF(IHVST(NZ,I,NY,NX).LE.2
     2.AND.HTSHE(K,NB,NZ,NY,NX).GT.0.0)THEN
      FHGT=AMAX1(0.0,AMIN1(1.0,(HTNODE(K,NB,NZ,NY,NX)
     2+HTSHE(K,NB,NZ,NY,NX)-HVST(NZ,I,NY,NX))/HTSHE(K,NB,NZ,NY,NX)))
      HTSHE(K,NB,NZ,NY,NX)=(1.0-FHGT)*HTSHE(K,NB,NZ,NY,NX)
      ELSE
      HTSHE(K,NB,NZ,NY,NX)=FHVSTK(K)*HTSHE(K,NB,NZ,NY,NX)
      ENDIF
      WGSHGX=WGSHGX+WGSHE(K,NB,NZ,NY,NX)
C     IF(IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)THEN
C     IF(HTNODE(K,NB,NZ,NY,NX).GT.HVST(NZ,I,NY,NX)
C    2.OR.IHVST(NZ,I,NY,NX).EQ.3)THEN
C     IF(FHVSTK(K).EQ.0.0.AND.K.GT.0)THEN
C     IF(IBTYP(NZ,NY,NX).EQ.0.OR.IGTYP(NZ,NY,NX).LE.1)THEN
C     VSTG(NB,NZ,NY,NX)=AMAX1(0.0,VSTG(NB,NZ,NY,NX)-1.0)
C     ELSE
C     VSTG(NB,NZ,NY,NX)=AMAX1(0.0,VSTG(NB,NZ,NY,NX)-0.04)
C     ENDIF
C     ENDIF
C     ENDIF
C     ENDIF
      ENDIF
9805  CONTINUE
C
C     CUT NON-STRUCTURAL C,N,P IN HARVESTED BRANCHES
C
      CPOOLX=AMAX1(0.0,CPOOL(NB,NZ,NY,NX))
      ZPOOLX=AMAX1(0.0,ZPOOL(NB,NZ,NY,NX)) 
      PPOOLX=AMAX1(0.0,PPOOL(NB,NZ,NY,NX)) 
      CPOLNX=AMAX1(0.0,CPOLNB(NB,NZ,NY,NX))
      ZPOLNX=AMAX1(0.0,ZPOLNB(NB,NZ,NY,NX)) 
      PPOLNX=AMAX1(0.0,PPOLNB(NB,NZ,NY,NX)) 
      IF(IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)THEN
      IF(WGLFGY+WGSHGY.GT.ZEROP(NZ,NY,NX))THEN
      FHVST=AMAX1(0.0,AMIN1(1.0,(WGLFGX+WGSHGX)
     2/(WGLFGY+WGSHGY)))
      CPOOLG=CPOOLX*FHVST 
      ZPOOLG=ZPOOLX*FHVST 
      PPOOLG=PPOOLX*FHVST
      CPOLNG=CPOLNX*FHVST 
      ZPOLNG=ZPOLNX*FHVST 
      PPOLNG=PPOLNX*FHVST
      WTNDG=WTNDB(NB,NZ,NY,NX)*FHVST 
      WTNDNG=WTNDBN(NB,NZ,NY,NX)*FHVST 
      WTNDPG=WTNDBP(NB,NZ,NY,NX)*FHVST
      ELSE 
      CPOOLG=0.0 
      ZPOOLG=0.0 
      PPOOLG=0.0
      CPOLNG=0.0 
      ZPOLNG=0.0 
      PPOLNG=0.0
      WTNDG=0.0 
      WTNDNG=0.0 
      WTNDPG=0.0
      ENDIF
      ELSE
      IF(WTLS(NZ,NY,NX).GT.ZEROL(NZ,NY,NX))THEN
      WTLSBX=AMAX1(0.0,WTLSB(NB,NZ,NY,NX))
      IF(CPOOL(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      WHVSCX=AMAX1(0.0,WHVSCP)*WTLSBX/WTLS(NZ,NY,NX)
      CPOOLG=AMAX1(0.0,CPOOLX-WHVSCX)
      ZPOOLG=AMAX1(0.0,ZPOOLX-WHVSCX*ZPOOLX/CPOOL(NB,NZ,NY,NX))
      PPOOLG=AMAX1(0.0,PPOOLX-WHVSCX*PPOOLX/CPOOL(NB,NZ,NY,NX)) 
      ELSE 
      CPOOLG=0.0 
      ZPOOLG=0.0 
      PPOOLG=0.0
      ENDIF
      IF(CPOLNB(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      WHVSNX=AMAX1(0.0,WHVSNP)*WTLSBX/WTLS(NZ,NY,NX)
      CPOLNG=AMAX1(0.0,CPOLNX-WHVSNX)
      ZPOLNG=AMAX1(0.0,ZPOLNX-WHVSNX*ZPOLNX/CPOLNB(NB,NZ,NY,NX))
      PPOLNG=AMAX1(0.0,PPOLNX-WHVSNX*PPOLNX/CPOLNB(NB,NZ,NY,NX)) 
      WTNDG=WTNDB(NB,NZ,NY,NX)*(1.0-WHVSNX/CPOLNX) 
      WTNDNG=WTNDBN(NB,NZ,NY,NX)*(1.0-WHVSNX/CPOLNX) 
      WTNDPG=WTNDBP(NB,NZ,NY,NX)*(1.0-WHVSNX/CPOLNX) 
      ELSE 
      CPOLNG=0.0 
      ZPOLNG=0.0 
      PPOLNG=0.0
      WTNDG=0.0 
      WTNDNG=0.0 
      WTNDPG=0.0
      ENDIF
      ELSE
      CPOOLG=0.0 
      ZPOOLG=0.0 
      PPOOLG=0.0
      CPOLNG=0.0 
      ZPOLNG=0.0 
      PPOLNG=0.0
      WTNDG=0.0 
      WTNDNG=0.0 
      WTNDPG=0.0
      ENDIF
      ENDIF
C
C     HARVESTED NON-STRUCTURAL C, N, P
C
      WTHTH0=WTHTH0+CPOOLX-CPOOLG+CPOLNX-CPOLNG
      WTHNH0=WTHNH0+ZPOOLX-ZPOOLG+ZPOLNX-ZPOLNG
      WTHPH0=WTHPH0+PPOOLX-PPOOLG+PPOLNX-PPOLNG
      WTHTH0=WTHTH0+WTNDB(NB,NZ,NY,NX)-WTNDG 
      WTHNH0=WTHNH0+WTNDBN(NB,NZ,NY,NX)-WTNDNG 
      WTHPH0=WTHPH0+WTNDBP(NB,NZ,NY,NX)-WTNDPG 
C
C     REMAINING NON-STRUCTURAL C, N, P
C
      CPOOL(NB,NZ,NY,NX)=CPOOLG
      ZPOOL(NB,NZ,NY,NX)=ZPOOLG
      PPOOL(NB,NZ,NY,NX)=PPOOLG
      CPOLNB(NB,NZ,NY,NX)=CPOLNG
      ZPOLNB(NB,NZ,NY,NX)=ZPOLNG
      PPOLNB(NB,NZ,NY,NX)=PPOLNG
      WTNDB(NB,NZ,NY,NX)=WTNDG
      WTNDBN(NB,NZ,NY,NX)=WTNDNG
      WTNDBP(NB,NZ,NY,NX)=WTNDPG
C
C     REMOVE C4 NON-STRUCTURAL C 
C
      IF(ICTYP(NZ,NY,NX).EQ.4.AND.CPOOLX.GT.ZEROP(NZ,NY,NX))THEN
      FHVST4=CPOOLG/CPOOLX
      DO 9810 K=1,25
      WTHTH0=WTHTH0+(1.0-FHVST4)*CPOOL3(K,NB,NZ,NY,NX) 
      WTHTH0=WTHTH0+(1.0-FHVST4)*CPOOL4(K,NB,NZ,NY,NX) 
      WTHTH0=WTHTH0+(1.0-FHVST4)*CO2B(K,NB,NZ,NY,NX) 
      WTHTH0=WTHTH0+(1.0-FHVST4)*HCOB(K,NB,NZ,NY,NX) 
      CPOOL3(K,NB,NZ,NY,NX)=FHVST4*CPOOL3(K,NB,NZ,NY,NX)
      CPOOL4(K,NB,NZ,NY,NX)=FHVST4*CPOOL4(K,NB,NZ,NY,NX)
      CO2B(K,NB,NZ,NY,NX)=FHVST4*CO2B(K,NB,NZ,NY,NX)
      HCOB(K,NB,NZ,NY,NX)=FHVST4*HCOB(K,NB,NZ,NY,NX)
9810  CONTINUE 
      ENDIF
C
C     CUT STALKS
C
      IF(IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)THEN
      IF(HTSTKX.GT.ZERO)THEN
      IF(IHVST(NZ,I,NY,NX).NE.3)THEN
      FHGT=AMAX1(0.0,AMIN1(1.0,HVST(NZ,I,NY,NX)/HTSTKX))
      ELSE
      FHGT=0.0
      ENDIF
      IF(THIN(NZ,I,NY,NX).EQ.0.0)THEN
      FHVST=AMAX1(0.0,1.0-(1.0-FHGT)*EHVST(1,3,NZ,I,NY,NX))
      FHVSH=FHVST
      ELSE
      FHVST=AMAX1(0.0,1.0-THIN(NZ,I,NY,NX))
      IF(IHVST(NZ,I,NY,NX).EQ.0)THEN
      FHVSH=1.0-(1.0-FHGT)*EHVST(1,3,NZ,I,NY,NX)*THIN(NZ,I,NY,NX)
      ELSE
      FHVSH=FHVST
      ENDIF
      ENDIF
      ELSE
      FHVST=1.0
      FHVSH=1.0
      ENDIF
      ELSE
      IF(WTSTK(NZ,NY,NX).GT.ZEROL(NZ,NY,NX))THEN
      FHVST=AMAX1(0.0,AMIN1(1.0,1.0-WHVSTH/WTSTK(NZ,NY,NX)))
      FHVSH=FHVST
      ELSE
      FHVST=1.0
      FHVSH=1.0
      ENDIF
      ENDIF
C
C     HARVESTED STALK C,N,P
C
      WTHTH3=WTHTH3+(1.0-FHVSH)*WTSTKB(NB,NZ,NY,NX)
      WTHNH3=WTHNH3+(1.0-FHVSH)*WTSTBN(NB,NZ,NY,NX)
      WTHPH3=WTHPH3+(1.0-FHVSH)*WTSTBP(NB,NZ,NY,NX)
      WTHTX3=WTHTX3+(FHVSH-FHVST)*WTSTKB(NB,NZ,NY,NX)
      WTHNX3=WTHNX3+(FHVSH-FHVST)*WTSTBN(NB,NZ,NY,NX)
      WTHPX3=WTHPX3+(FHVSH-FHVST)*WTSTBP(NB,NZ,NY,NX)
C
C     REMAINING STALK C,N,P
C
      WTSTKB(NB,NZ,NY,NX)=FHVST*WTSTKB(NB,NZ,NY,NX)
      WTSTBN(NB,NZ,NY,NX)=FHVST*WTSTBN(NB,NZ,NY,NX)
      WTSTBP(NB,NZ,NY,NX)=FHVST*WTSTBP(NB,NZ,NY,NX)
      WVSTKB(NB,NZ,NY,NX)=FHVST*WVSTKB(NB,NZ,NY,NX)
      WTSTXB(NB,NZ,NY,NX)=FHVST*WTSTXB(NB,NZ,NY,NX)
      WTSTXN(NB,NZ,NY,NX)=FHVST*WTSTXN(NB,NZ,NY,NX)
      WTSTXP(NB,NZ,NY,NX)=FHVST*WTSTXP(NB,NZ,NY,NX)

C
C     CUT STALK NODES
C
      DO 9820 K=25,0,-1
      IF(IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)THEN
      IF(HTNODX(K,NB,NZ,NY,NX).GT.ZERO)THEN
      IF(IHVST(NZ,I,NY,NX).NE.3)THEN
      FHGT=AMAX1(0.0,AMIN1(1.0,(HTNODE(K,NB,NZ,NY,NX)
     2-HVST(NZ,I,NY,NX))/HTNODX(K,NB,NZ,NY,NX)))
      ELSE
      FHGT=0.0
      ENDIF
      IF(THIN(NZ,I,NY,NX).EQ.0.0)THEN
      FHVST=AMAX1(0.0,1.0-FHGT*EHVST(1,3,NZ,I,NY,NX))
      ELSE
      FHVST=AMAX1(0.0,1.0-THIN(NZ,I,NY,NX))
      ENDIF
      ELSE
      FHVST=1.0
      ENDIF
      ELSE
      IF(WTSTK(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FHVST=AMAX1(0.0,AMIN1(1.0,1.0-WHVSTH/WTSTK(NZ,NY,NX)))
      ELSE
      FHVST=1.0
      ENDIF
      ENDIF
      WGNODE(K,NB,NZ,NY,NX)=FHVST*WGNODE(K,NB,NZ,NY,NX)
      WGNODN(K,NB,NZ,NY,NX)=FHVST*WGNODN(K,NB,NZ,NY,NX)
      WGNODP(K,NB,NZ,NY,NX)=FHVST*WGNODP(K,NB,NZ,NY,NX) 
      IF(IHVST(NZ,I,NY,NX).LE.2.AND.THIN(NZ,I,NY,NX).EQ.0.0)THEN
      HTNODX(K,NB,NZ,NY,NX)=FHVST*HTNODX(K,NB,NZ,NY,NX)
      HTNODE(K,NB,NZ,NY,NX)=AMIN1(HTNODE(K,NB,NZ,NY,NX)
     2,HVST(NZ,I,NY,NX))
      ENDIF
C     IF(NZ.EQ.2)THEN
C     WRITE(*,4811)'STK2',I,J,NZ,NB,K,IHVST(NZ,I,NY,NX)
C    2,HTNODX(K,NB,NZ,NY,NX),HTNODE(K,NB,NZ,NY,NX)
C    3,HVST(NZ,I,NY,NX),FHGT,FHVST,ARLF(K,NB,NZ,NY,NX)
C    4,EHVST(1,3,NZ,I,NY,NX),THIN(NZ,I,NY,NX)
4811  FORMAT(A8,6I4,12E12.4)
C     ENDIF
9820  CONTINUE
C
C     CUT STALK RESERVES
C
      IF(IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)THEN
      IF(WTSTKB(NB,NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FHVST=FHVST
      FHVSH=FHVSH
      ELSE
      FHVST=0.0
      FHVSH=0.0
      ENDIF
      ELSE
      IF(WTRSV(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FHVST=AMAX1(0.0,AMIN1(1.0,1.0-WHVRVH/WTRSV(NZ,NY,NX)))
      FHVSH=FHVST
      ELSE
      FHVST=0.0
      FHVSH=0.0
      ENDIF
      ENDIF
C
C     HARVESTED STALK RESERVE C,N,P 
C
      WTHTH3=WTHTH3+(1.0-FHVSH)*WTRSVB(NB,NZ,NY,NX)
      WTHNH3=WTHNH3+(1.0-FHVSH)*WTRSBN(NB,NZ,NY,NX)
      WTHPH3=WTHPH3+(1.0-FHVSH)*WTRSBP(NB,NZ,NY,NX)
      WTHTX3=WTHTX3+(FHVSH-FHVST)*WTRSVB(NB,NZ,NY,NX)
      WTHNX3=WTHNX3+(FHVSH-FHVST)*WTRSBN(NB,NZ,NY,NX)
      WTHPX3=WTHPX3+(FHVSH-FHVST)*WTRSBP(NB,NZ,NY,NX)
C
C     REMAINING STALK RESERVE C,N,P IF STALK REMAINING
C
      WTRSVB(NB,NZ,NY,NX)=FHVST*WTRSVB(NB,NZ,NY,NX) 
      WTRSBN(NB,NZ,NY,NX)=FHVST*WTRSBN(NB,NZ,NY,NX) 
      WTRSBP(NB,NZ,NY,NX)=FHVST*WTRSBP(NB,NZ,NY,NX) 
C
C     CUT REPRODUCTIVE ORGANS
C
      IF(IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)THEN
      IF(HVST(NZ,I,NY,NX).LT.HTSTKX
     2.OR.IHVST(NZ,I,NY,NX).EQ.3)THEN
      IF(THIN(NZ,I,NY,NX).EQ.0.0)THEN
      FHVSTG=1.0-EHVST(1,2,NZ,I,NY,NX)
      FHVSHG=FHVSTG
      ELSE
      FHVSTG=1.0-THIN(NZ,I,NY,NX)
      FHVSHG=1.0-EHVST(1,2,NZ,I,NY,NX)*THIN(NZ,I,NY,NX)
      ENDIF
      ELSE
      FHVSTG=1.0-THIN(NZ,I,NY,NX)
      FHVSHG=FHVSTG
      ENDIF
      FHVSTH=FHVSTG 
      FHVSTE=FHVSTG 
      FHVSHH=FHVSHG 
      FHVSHE=FHVSHG 
      ELSE
      IF(WTHSK(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FHVSTH=AMAX1(0.0,AMIN1(1.0,1.0-WHVHSH/WTHSK(NZ,NY,NX)))
      FHVSHH=FHVSTH
      ELSE
      FHVSTH=1.0
      FHVSHH=1.0
      ENDIF
      IF(WTEAR(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FHVSTE=AMAX1(0.0,AMIN1(1.0,1.0-WHVEAH/WTEAR(NZ,NY,NX)))
      FHVSHE=FHVSTE
      ELSE
      FHVSTE=1.0
      FHVSHE=1.0
      ENDIF
      IF(WTGR(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      FHVSTG=AMAX1(0.0,AMIN1(1.0,1.0-WHVGRH/WTGR(NZ,NY,NX)))
      FHVSHG=FHVSTG
      ELSE
      FHVSTG=1.0
      FHVSHG=1.0
      ENDIF
      ENDIF
C
C     HARVESTED REPRODUCTIVE C,N,P
C
      WTHTH2=WTHTH2+(1.0-FHVSHH)*WTHSKB(NB,NZ,NY,NX)+(1.0-FHVSHE)
     2*WTEARB(NB,NZ,NY,NX)+(1.0-FHVSHG)*WTGRB(NB,NZ,NY,NX)
      WTHNH2=WTHNH2+(1.0-FHVSHH)*WTHSBN(NB,NZ,NY,NX)+(1.0-FHVSHE)
     2*WTEABN(NB,NZ,NY,NX)+(1.0-FHVSHG)*WTGRBN(NB,NZ,NY,NX)
      WTHPH2=WTHPH2+(1.0-FHVSHH)*WTHSBP(NB,NZ,NY,NX)+(1.0-FHVSHE)
     2*WTEABP(NB,NZ,NY,NX)+(1.0-FHVSHG)*WTGRBP(NB,NZ,NY,NX)
      WTHTX2=WTHTX2+(FHVSHH-FHVSTH)*WTHSKB(NB,NZ,NY,NX)+(FHVSHE-FHVSTE)
     2*WTEARB(NB,NZ,NY,NX)+(FHVSHG-FHVSTG)*WTGRB(NB,NZ,NY,NX)
      WTHNX2=WTHNX2+(FHVSHH-FHVSTH)*WTHSBN(NB,NZ,NY,NX)+(FHVSHE-FHVSTE)
     2*WTEABN(NB,NZ,NY,NX)+(FHVSHG-FHVSTG)*WTGRBN(NB,NZ,NY,NX)
      WTHPX2=WTHPX2+(FHVSHH-FHVSTH)*WTHSBP(NB,NZ,NY,NX)+(FHVSHE-FHVSTE)
     2*WTEABP(NB,NZ,NY,NX)+(FHVSHG-FHVSTG)*WTGRBP(NB,NZ,NY,NX)
      WTHTG=WTHTG+(1.0-FHVSTG)*WTGRB(NB,NZ,NY,NX)
      WTHNG=WTHNG+(1.0-FHVSTG)*WTGRBN(NB,NZ,NY,NX)
      WTHPG=WTHPG+(1.0-FHVSTG)*WTGRBP(NB,NZ,NY,NX)
C
C     REMAINING REPRODUCTIVE C,N,P
C
      WTHSKB(NB,NZ,NY,NX)=FHVSTH*WTHSKB(NB,NZ,NY,NX)
      WTEARB(NB,NZ,NY,NX)=FHVSTE*WTEARB(NB,NZ,NY,NX)
      WTGRB(NB,NZ,NY,NX)=FHVSTG*WTGRB(NB,NZ,NY,NX)
      WTHSBN(NB,NZ,NY,NX)=FHVSTH*WTHSBN(NB,NZ,NY,NX)
      WTEABN(NB,NZ,NY,NX)=FHVSTE*WTEABN(NB,NZ,NY,NX)
      WTGRBN(NB,NZ,NY,NX)=FHVSTG*WTGRBN(NB,NZ,NY,NX)
      WTHSBP(NB,NZ,NY,NX)=FHVSTH*WTHSBP(NB,NZ,NY,NX)
      WTEABP(NB,NZ,NY,NX)=FHVSTE*WTEABP(NB,NZ,NY,NX)
      WTGRBP(NB,NZ,NY,NX)=FHVSTG*WTGRBP(NB,NZ,NY,NX)
      GRNXB(NB,NZ,NY,NX)=FHVSTG*GRNXB(NB,NZ,NY,NX)
      GRNOB(NB,NZ,NY,NX)=FHVSTG*GRNOB(NB,NZ,NY,NX)
      GRWTB(NB,NZ,NY,NX)=FHVSTG*GRWTB(NB,NZ,NY,NX)
C
C     REMAINING TOTAL BRANCH C,N,P AND LEAF, STALK AREA
C
      CPOOLK(NB,NZ,NY,NX)=0.0
      DO 1325 K=1,25
      CPOOLK(NB,NZ,NY,NX)=CPOOLK(NB,NZ,NY,NX)
     2+CPOOL3(K,NB,NZ,NY,NX)+CPOOL4(K,NB,NZ,NY,NX)
     2+CO2B(K,NB,NZ,NY,NX)+HCOB(K,NB,NZ,NY,NX)
1325  CONTINUE
      WTLSB(NB,NZ,NY,NX)=AMAX1(0.0,WTLFB(NB,NZ,NY,NX)
     2+WTSHEB(NB,NZ,NY,NX))
      WTSHTB(NB,NZ,NY,NX)=AMAX1(0.0,WTLFB(NB,NZ,NY,NX)
     2+WTSHEB(NB,NZ,NY,NX)+WTSTKB(NB,NZ,NY,NX)+WTRSVB(NB,NZ,NY,NX)
     3+WTHSKB(NB,NZ,NY,NX)+WTEARB(NB,NZ,NY,NX)+WTGRB(NB,NZ,NY,NX)
     4+CPOOL(NB,NZ,NY,NX)+CPOOLK(NB,NZ,NY,NX))
      WTSHTN(NB,NZ,NY,NX)=AMAX1(0.0,WTLFBN(NB,NZ,NY,NX)
     2+WTSHBN(NB,NZ,NY,NX)+WTSTBN(NB,NZ,NY,NX)+WTRSBN(NB,NZ,NY,NX)
     3+WTHSBN(NB,NZ,NY,NX)+WTEABN(NB,NZ,NY,NX)+WTGRBN(NB,NZ,NY,NX)
     4+ZPOOL(NB,NZ,NY,NX))
      WTSHTP(NB,NZ,NY,NX)=AMAX1(0.0,WTLFBP(NB,NZ,NY,NX)
     2+WTSHBP(NB,NZ,NY,NX)+WTSTBP(NB,NZ,NY,NX)+WTRSBP(NB,NZ,NY,NX)
     3+WTHSBP(NB,NZ,NY,NX)+WTEABP(NB,NZ,NY,NX)+WTGRBP(NB,NZ,NY,NX)
     4+PPOOL(NB,NZ,NY,NX))
      VOLWPX=VOLWP(NZ,NY,NX)
      WVPLT=AMAX1(0.0,WTLS(NZ,NY,NX)+WVSTK(NZ,NY,NX))
      APSILT=ABS(PSILT(NZ,NY,NX))
      FDM=0.16+0.10*APSILT/(0.05*APSILT+2.0)
      VOLWP(NZ,NY,NX)=1.0E-06*WVPLT/FDM
      VOLWOU=VOLWOU+VOLWPX-VOLWP(NZ,NY,NX)
      UVOLO(NY,NX)=UVOLO(NY,NX)+VOLWPX-VOLWP(NZ,NY,NX)
C
C     RESET PHENOLOGY, GROWTH STAGE IF STALKS ARE CUT
C
      IF((IBTYP(NZ,NY,NX).EQ.0.OR.IGTYP(NZ,NY,NX).LE.1)
     2.AND.(IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)
     3.AND.ZC(NZ,NY,NX).GT.HVST(NZ,I,NY,NX))THEN
      IF((IWTYP(NZ,NY,NX).NE.0
     2.AND.VRNF(NB,NZ,NY,NX).LE.FVRN*VRNX(NB,NZ,NY,NX))
     3.OR.(IWTYP(NZ,NY,NX).EQ.0
     4.AND.IDAY(1,NB,NZ,NY,NX).NE.0))THEN
      GROUP(NB,NZ,NY,NX)=GROUPI(NZ,NY,NX)
      PSTGI(NB,NZ,NY,NX)=PSTG(NB,NZ,NY,NX)
      PSTGF(NB,NZ,NY,NX)=0.0
      VSTGX(NB,NZ,NY,NX)=0.0
      TGSTGI(NB,NZ,NY,NX)=0.0
      TGSTGF(NB,NZ,NY,NX)=0.0
      FLG4(NB,NZ,NY,NX)=0.0
      IDAY(1,NB,NZ,NY,NX)=I
      DO 3005 M=2,10
      IDAY(M,NB,NZ,NY,NX)=0
3005  CONTINUE
      IFLGA(NB,NZ,NY,NX)=0
      IF(NB.EQ.NB1(NZ,NY,NX))THEN
      DO 3010 NBX=1,NBR(NZ,NY,NX)
      IF(NBX.NE.NB1(NZ,NY,NX))THEN
      GROUP(NBX,NZ,NY,NX)=GROUPI(NZ,NY,NX)
      PSTGI(NBX,NZ,NY,NX)=PSTG(NBX,NZ,NY,NX)
      PSTGF(NBX,NZ,NY,NX)=0.0
      VSTGX(NBX,NZ,NY,NX)=0.0
      TGSTGI(NBX,NZ,NY,NX)=0.0
      TGSTGF(NBX,NZ,NY,NX)=0.0
      FLG4(NBX,NZ,NY,NX)=0.0
      IDAY(1,NBX,NZ,NY,NX)=I
      DO 3015 M=2,10
      IDAY(M,NBX,NZ,NY,NX)=0
3015  CONTINUE
      IFLGA(NBX,NZ,NY,NX)=0
      ENDIF
3010  CONTINUE
      ENDIF
      ENDIF
      ENDIF
C
C     DEATH OF BRANCH IF KILLING HARVEST ENTERED IN 'READQ'
C
      IF(JHVST(NZ,I,NY,NX).NE.0)IDTHB(NB,NZ,NY,NX)=1
      IF(PP(NZ,NY,NX).LE.0.0)IDTHB(NB,NZ,NY,NX)=1
9835  CONTINUE
      WTLS(NZ,NY,NX)=0.0
      WTSTK(NZ,NY,NX)=0.0
      WVSTK(NZ,NY,NX)=0.0
      ARSTP(NZ,NY,NX)=0.0
      DO 9840 NB=1,NBR(NZ,NY,NX)
      WTLS(NZ,NY,NX)=WTLS(NZ,NY,NX)+WTLSB(NB,NZ,NY,NX)
      WTSTK(NZ,NY,NX)=WTSTK(NZ,NY,NX)+WTSTKB(NB,NZ,NY,NX)
      WVSTK(NZ,NY,NX)=WVSTK(NZ,NY,NX)+WVSTKB(NB,NZ,NY,NX)
      DO 9830 L=1,NC(NY,NX)
      ARSTP(NZ,NY,NX)=ARSTP(NZ,NY,NX)+ARSTK(L,NB,NZ,NY,NX)
9830  CONTINUE
9840  CONTINUE
C
C     ROOT LITTERFALL FROM HARVESTING OR FIRE
C
      IF(IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)THEN
      XHVST=1.0-THIN(NZ,I,NY,NX)
      DO 3985 N=1,MY(NZ,NY,NX)
      DO 3980 L=NU(NY,NX),NJ(NY,NX)
      IF(IHVST(NZ,I,NY,NX).NE.5)THEN
      XHVST=1.0-THIN(NZ,I,NY,NX)
      XHVSN=XHVST
      XHVSP=XHVST
      FFIRE=0.0
      FFIRN=0.0
      FFIRP=0.0
      ELSE
      IF(THETW(L,NY,NX).GT.FVLWB.OR.CORGC(L,NY,NX).LE.FORGC)THEN
      XHVST=1.0
      XHVSN=XHVST
      XHVSP=XHVST
      FFIRE=0.0
      FFIRN=0.0
      FFIRP=0.0
      ELSE
      XHVST=1.0-EHVST(1,3,NZ,I,NY,NX)*AMIN1(1.0,(CORGC(L,NY,NX)-FORGC)
     2/(0.5E+06-FORGC))
      XHVSN=XHVST
      XHVSP=XHVST
      FFIRE=EHVST(2,3,NZ,I,NY,NX)
      FFIRN=FFIRE*EFIRE(1,IHVST(NZ,I,NY,NX)) 
      FFIRP=FFIRE*EFIRE(2,IHVST(NZ,I,NY,NX)) 
      ENDIF
      ENDIF
      DO 3385 M=1,4
      FHVST=(1.0-XHVST)*CFOPC(0,M,NZ,NY,NX)*CPOOLR(N,L,NZ,NY,NX)
      FHVSN=(1.0-XHVSN)*CFOPN(0,M,NZ,NY,NX)*ZPOOLR(N,L,NZ,NY,NX)
      FHVSP=(1.0-XHVSP)*CFOPP(0,M,NZ,NY,NX)*PPOOLR(N,L,NZ,NY,NX)
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+(1.0-FFIRE)*FHVST 
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+(1.0-FFIRN)*FHVSN 
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+(1.0-FFIRP)*FHVSP
      VCO2F(NZ,NY,NX)=VCO2F(NZ,NY,NX)-(1.0-FCH4F)*FFIRE*FHVST 
      VCH4F(NZ,NY,NX)=VCH4F(NZ,NY,NX)-FCH4F*FFIRE*FHVST 
      VOXYF(NZ,NY,NX)=VOXYF(NZ,NY,NX)-(1.0-FCH4F)*FFIRE*FHVST*2.667 
      VNH3F(NZ,NY,NX)=VNH3F(NZ,NY,NX)-FFIRN*FHVSN
      VN2OF(NZ,NY,NX)=VN2OF(NZ,NY,NX)-0.0
      VPO4F(NZ,NY,NX)=VPO4F(NZ,NY,NX)-FFIRP*FHVSP
      CNET(NZ,NY,NX)=CNET(NZ,NY,NX)-(1.0-FCH4F)*FFIRE*FHVST
      TNBP(NY,NX)=TNBP(NY,NX)-FCH4F*FFIRE*FHVST 
      DO 3385 NR=1,NRT(NZ,NY,NX)
      FHVST=(1.0-XHVST)*CFOPC(5,M,NZ,NY,NX)*(WTRT1(N,L,NR,NZ,NY,NX)
     3+WTRT2(N,L,NR,NZ,NY,NX))*FWOOD(0)
      FHVSN=(1.0-XHVSN)*CFOPN(5,M,NZ,NY,NX)*(WTRT1N(N,L,NR,NZ,NY,NX)
     3+WTRT2N(N,L,NR,NZ,NY,NX))*FWOODN(0)
      FHVSP=(1.0-XHVSP)*CFOPP(5,M,NZ,NY,NX)*(WTRT1P(N,L,NR,NZ,NY,NX)
     3+WTRT2P(N,L,NR,NZ,NY,NX))*FWOODP(0)
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+(1.0-FFIRE)*FHVST 
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+(1.0-FFIRN)*FHVSN 
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+(1.0-FFIRP)*FHVSP
      VCO2F(NZ,NY,NX)=VCO2F(NZ,NY,NX)-(1.0-FCH4F)*FFIRE*FHVST 
      VCH4F(NZ,NY,NX)=VCH4F(NZ,NY,NX)-FCH4F*FFIRE*FHVST 
      VOXYF(NZ,NY,NX)=VOXYF(NZ,NY,NX)-(1.0-FCH4F)*FFIRE*FHVST*2.667 
      VNH3F(NZ,NY,NX)=VNH3F(NZ,NY,NX)-FFIRN*FHVSN
      VN2OF(NZ,NY,NX)=VN2OF(NZ,NY,NX)-0.0
      VPO4F(NZ,NY,NX)=VPO4F(NZ,NY,NX)-FFIRP*FHVSP
      CNET(NZ,NY,NX)=CNET(NZ,NY,NX)-(1.0-FCH4F)*FFIRE*FHVST 
      TNBP(NY,NX)=TNBP(NY,NX)-FCH4F*FFIRE*FHVST 
      FHVST=(1.0-XHVST)*CFOPC(4,M,NZ,NY,NX)*(WTRT1(N,L,NR,NZ,NY,NX)
     3+WTRT2(N,L,NR,NZ,NY,NX))*FWOOD(1)
      FHVSN=(1.0-XHVSN)*CFOPN(4,M,NZ,NY,NX)*(WTRT1N(N,L,NR,NZ,NY,NX)
     3+WTRT2N(N,L,NR,NZ,NY,NX))*FWOODN(1)
      FHVSP=(1.0-XHVSP)*CFOPP(4,M,NZ,NY,NX)*(WTRT1P(N,L,NR,NZ,NY,NX)
     3+WTRT2P(N,L,NR,NZ,NY,NX))*FWOODP(1)
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+(1.0-FFIRE)*FHVST 
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+(1.0-FFIRN)*FHVSN 
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+(1.0-FFIRP)*FHVSP
      VCO2F(NZ,NY,NX)=VCO2F(NZ,NY,NX)-(1.0-FCH4F)*FFIRE*FHVST 
      VCH4F(NZ,NY,NX)=VCH4F(NZ,NY,NX)-FCH4F*FFIRE*FHVST 
      VOXYF(NZ,NY,NX)=VOXYF(NZ,NY,NX)-(1.0-FCH4F)*FFIRE*FHVST*2.667 
      VNH3F(NZ,NY,NX)=VNH3F(NZ,NY,NX)-FFIRN*FHVSN
      VN2OF(NZ,NY,NX)=VN2OF(NZ,NY,NX)-0.0
      VPO4F(NZ,NY,NX)=VPO4F(NZ,NY,NX)-FFIRP*FHVSP
      CNET(NZ,NY,NX)=CNET(NZ,NY,NX)-(1.0-FCH4F)*FFIRE*FHVST 
      TNBP(NY,NX)=TNBP(NY,NX)-FCH4F*FFIRE*FHVST
3385  CONTINUE
C     WRITE(*,6161)'FIRE',I,J,NZ,L,N,M,VCO2F(NZ,NY,NX),FFIRE
C    2,FHVST,CFOPC(4,M,NZ,NY,NX),CPOOLR(N,L,NZ,NY,NX),THETW(L,NY,NX)
C    3,CORGC(L,NY,NX)
6161  FORMAT(A8,6I4,20E12.4) 
C
C     RELEASE ROOT GAS CONTENTS DURING HARVESTING
C
      RCO2Z(NZ,NY,NX)=RCO2Z(NZ,NY,NX)-(1.0-XHVST)
     2*(CO2A(N,L,NZ,NY,NX)+CO2P(N,L,NZ,NY,NX))
      ROXYZ(NZ,NY,NX)=ROXYZ(NZ,NY,NX)-(1.0-XHVST)
     2*(OXYA(N,L,NZ,NY,NX)+OXYP(N,L,NZ,NY,NX))
      RCH4Z(NZ,NY,NX)=RCH4Z(NZ,NY,NX)-(1.0-XHVST)
     2*(CH4A(N,L,NZ,NY,NX)+CH4P(N,L,NZ,NY,NX))
      RN2OZ(NZ,NY,NX)=RN2OZ(NZ,NY,NX)-(1.0-XHVST)
     2*(Z2OA(N,L,NZ,NY,NX)+Z2OP(N,L,NZ,NY,NX))
      RNH3Z(NZ,NY,NX)=RNH3Z(NZ,NY,NX)-(1.0-XHVST)
     2*(ZH3A(N,L,NZ,NY,NX)+ZH3P(N,L,NZ,NY,NX))
      RH2GZ(NZ,NY,NX)=RH2GZ(NZ,NY,NX)-(1.0-XHVST)
     2*(H2GA(N,L,NZ,NY,NX)+H2GP(N,L,NZ,NY,NX))
      CO2A(N,L,NZ,NY,NX)=XHVST*CO2A(N,L,NZ,NY,NX)
      OXYA(N,L,NZ,NY,NX)=XHVST*OXYA(N,L,NZ,NY,NX)
      CH4A(N,L,NZ,NY,NX)=XHVST*CH4A(N,L,NZ,NY,NX)
      Z2OA(N,L,NZ,NY,NX)=XHVST*Z2OA(N,L,NZ,NY,NX)
      ZH3A(N,L,NZ,NY,NX)=XHVST*ZH3A(N,L,NZ,NY,NX)
      H2GA(N,L,NZ,NY,NX)=XHVST*H2GA(N,L,NZ,NY,NX)
      CO2P(N,L,NZ,NY,NX)=XHVST*CO2P(N,L,NZ,NY,NX)
      OXYP(N,L,NZ,NY,NX)=XHVST*OXYP(N,L,NZ,NY,NX)
      CH4P(N,L,NZ,NY,NX)=XHVST*CH4P(N,L,NZ,NY,NX)
      Z2OP(N,L,NZ,NY,NX)=XHVST*Z2OP(N,L,NZ,NY,NX)
      ZH3P(N,L,NZ,NY,NX)=XHVST*ZH3P(N,L,NZ,NY,NX)
      H2GP(N,L,NZ,NY,NX)=XHVST*H2GP(N,L,NZ,NY,NX)
C
C     REDUCE ROOT STATE VARIABLES DURING HARVESTING
C
      DO 3960 NR=1,NRT(NZ,NY,NX)
      WTRT1(N,L,NR,NZ,NY,NX)=WTRT1(N,L,NR,NZ,NY,NX)*XHVST
      WTRT2(N,L,NR,NZ,NY,NX)=WTRT2(N,L,NR,NZ,NY,NX)*XHVST
      WTRT1N(N,L,NR,NZ,NY,NX)=WTRT1N(N,L,NR,NZ,NY,NX)*XHVST
      WTRT2N(N,L,NR,NZ,NY,NX)=WTRT2N(N,L,NR,NZ,NY,NX)*XHVST
      WTRT1P(N,L,NR,NZ,NY,NX)=WTRT1P(N,L,NR,NZ,NY,NX)*XHVST
      WTRT2P(N,L,NR,NZ,NY,NX)=WTRT2P(N,L,NR,NZ,NY,NX)*XHVST
      RTWT1(N,NR,NZ,NY,NX)=RTWT1(N,NR,NZ,NY,NX)*XHVST
      RTWT1N(N,NR,NZ,NY,NX)=RTWT1N(N,NR,NZ,NY,NX)*XHVST
      RTWT1P(N,NR,NZ,NY,NX)=RTWT1P(N,NR,NZ,NY,NX)*XHVST
      RTLG1(N,L,NR,NZ,NY,NX)=RTLG1(N,L,NR,NZ,NY,NX)*XHVST
      RTLG2(N,L,NR,NZ,NY,NX)=RTLG2(N,L,NR,NZ,NY,NX)*XHVST
      RTN2(N,L,NR,NZ,NY,NX)=RTN2(N,L,NR,NZ,NY,NX)*XHVST
3960  CONTINUE
      CPOOLR(N,L,NZ,NY,NX)=CPOOLR(N,L,NZ,NY,NX)*XHVST
      ZPOOLR(N,L,NZ,NY,NX)=ZPOOLR(N,L,NZ,NY,NX)*XHVST
      PPOOLR(N,L,NZ,NY,NX)=PPOOLR(N,L,NZ,NY,NX)*XHVST
      WTRTL(N,L,NZ,NY,NX)=WTRTL(N,L,NZ,NY,NX)*XHVST
      WTRTD(N,L,NZ,NY,NX)=WTRTD(N,L,NZ,NY,NX)*XHVST
      WSRTL(N,L,NZ,NY,NX)=WSRTL(N,L,NZ,NY,NX)*XHVST
      RTN1(N,L,NZ,NY,NX)=RTN1(N,L,NZ,NY,NX)*XHVST
      RTNL(N,L,NZ,NY,NX)=RTNL(N,L,NZ,NY,NX)*XHVST
      RTLGP(N,L,NZ,NY,NX)=RTLGP(N,L,NZ,NY,NX)*XHVST
      RTDNP(N,L,NZ,NY,NX)=RTDNP(N,L,NZ,NY,NX)*XHVST
      RTVLP(N,L,NZ,NY,NX)=RTVLP(N,L,NZ,NY,NX)*XHVST
      RTVLW(N,L,NZ,NY,NX)=RTVLW(N,L,NZ,NY,NX)*XHVST
      RTARP(N,L,NZ,NY,NX)=RTARP(N,L,NZ,NY,NX)*XHVST
      RCO2M(N,L,NZ,NY,NX)=RCO2M(N,L,NZ,NY,NX)*XHVST
      RCO2N(N,L,NZ,NY,NX)=RCO2N(N,L,NZ,NY,NX)*XHVST
      RCO2A(N,L,NZ,NY,NX)=RCO2A(N,L,NZ,NY,NX)*XHVST
C
C     NODULE LITTERFALL AND STATE VARIABLES DURING HARVESTING
C
      IF(INTYP(NZ,NY,NX).NE.0.AND.N.EQ.1)THEN
      DO 3395 M=1,4
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+(1.0-XHVST)
     2*(CFOPC(4,M,NZ,NY,NX)*WTNDL(L,NZ,NY,NX)
     3+CFOPC(0,M,NZ,NY,NX)*CPOOLN(L,NZ,NY,NX))
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+(1.0-XHVST)
     2*(CFOPN(4,M,NZ,NY,NX)*WTNDLN(L,NZ,NY,NX)
     3+CFOPN(0,M,NZ,NY,NX)*ZPOOLN(L,NZ,NY,NX))
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+(1.0-XHVST)
     2*(CFOPP(4,M,NZ,NY,NX)*WTNDLP(L,NZ,NY,NX)
     3+CFOPP(0,M,NZ,NY,NX)*PPOOLN(L,NZ,NY,NX))
3395  CONTINUE
      WTNDL(L,NZ,NY,NX)=WTNDL(L,NZ,NY,NX)*XHVST
      WTNDLN(L,NZ,NY,NX)=WTNDLN(L,NZ,NY,NX)*XHVST
      WTNDLP(L,NZ,NY,NX)=WTNDLP(L,NZ,NY,NX)*XHVST
      CPOOLN(L,NZ,NY,NX)=CPOOLN(L,NZ,NY,NX)*XHVST
      ZPOOLN(L,NZ,NY,NX)=ZPOOLN(L,NZ,NY,NX)*XHVST
      PPOOLN(L,NZ,NY,NX)=PPOOLN(L,NZ,NY,NX)*XHVST
      ENDIF
3980  CONTINUE
3985  CONTINUE
C
C     STORAGE LITTERFALL AND STATE VARIABLES DURING HARVESTING
C
      IF(ISTYP(NZ,NY,NX).NE.0)THEN
      DO 3400 M=1,4
      CSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)=CSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)
     2+((1.0-XHVST)*CFOPC(0,M,NZ,NY,NX)*WTRVC(NZ,NY,NX))*FWOOD(0)
      ZSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)=ZSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)
     2+((1.0-XHVST)*CFOPN(0,M,NZ,NY,NX)*WTRVN(NZ,NY,NX))*FWOODN(0)
      PSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)=PSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)
     2+((1.0-XHVST)*CFOPP(0,M,NZ,NY,NX)*WTRVP(NZ,NY,NX))*FWOODP(0)
      CSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)=CSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)
     2+((1.0-XHVST)*CFOPC(0,M,NZ,NY,NX)*WTRVC(NZ,NY,NX))*FWOOD(1)
      ZSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)=ZSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)
     2+((1.0-XHVST)*CFOPN(0,M,NZ,NY,NX)*WTRVN(NZ,NY,NX))*FWOODN(1)
      PSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)=PSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)
     2+((1.0-XHVST)*CFOPP(0,M,NZ,NY,NX)*WTRVP(NZ,NY,NX))*FWOODP(1)
3400  CONTINUE
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)*XHVST
      WTRVN(NZ,NY,NX)=WTRVN(NZ,NY,NX)*XHVST
      WTRVP(NZ,NY,NX)=WTRVP(NZ,NY,NX)*XHVST
      ENDIF
      ENDIF
      ENDIF
C
C     REDUCE OR REMOVE PLANT POPULATIONS DURING TILLAGE
C
      IF(J.EQ.INT(ZNOON(NY,NX)).AND.(IBTYP(NZ,NY,NX).EQ.0
     2.OR.IGTYP(NZ,NY,NX).LE.1).AND.(I.NE.IDAY0(NZ,NY,NX)
     3.OR.IDATA(3).NE.IYR0(NZ,NY,NX)))THEN
      IF(XCORP(NY,NX).LT.1.0.AND.ITILL(I,NY,NX).NE.19)THEN
      IF(I.GT.IDAY0(NZ,NY,NX).OR.IYRC.GT.IYR0(NZ,NY,NX))THEN
      XHVST=XCORP(NY,NX)
      PPX(NZ,NY,NX)=PPX(NZ,NY,NX)*XHVST
      PP(NZ,NY,NX)=PP(NZ,NY,NX)*XHVST
      FRADP(NZ,NY,NX)=FRADP(NZ,NY,NX)*XHVST
      VHCPC(NZ,NY,NX)=VHCPC(NZ,NY,NX)*XHVST
      WTLS(NZ,NY,NX)=0.0
      WVSTK(NZ,NY,NX)=0.0
C
C     TERMINATE BRANCHES IF TILLAGE IMPLEMENT 20 IS SELECTED
C
      DO 8975 NB=1,NBR(NZ,NY,NX)
      IF(IDTHB(NB,NZ,NY,NX).EQ.0)THEN
      IF(XHVST.LE.1.0E-03)THEN
      IDTHB(NB,NZ,NY,NX)=1
      ENDIF 
C
C     LITTERFALL FROM BRANCHES DURING TILLAGE
C
      DO 6380 M=1,4
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)+(1.0-XHVST)
     2*(CFOPC(0,M,NZ,NY,NX)*(CPOOL(NB,NZ,NY,NX)+CPOLNB(NB,NZ,NY,NX)
     3+CPOOLK(NB,NZ,NY,NX)+WTRSVB(NB,NZ,NY,NX)) 
     4+CFOPC(1,M,NZ,NY,NX)*(WTLFB(NB,NZ,NY,NX)*FWODB(1) 
     5+WTNDB(NB,NZ,NY,NX)) 
     6+CFOPC(2,M,NZ,NY,NX)*(WTSHEB(NB,NZ,NY,NX)*FWODB(1) 
     7+WTHSKB(NB,NZ,NY,NX)+WTEARB(NB,NZ,NY,NX)))
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPC(5,M,NZ,NY,NX)*(WTLFB(NB,NZ,NY,NX)*FWODB(0)
     3+WTSHEB(NB,NZ,NY,NX)*FWODB(0))
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)+(1.0-XHVST)
     2*(CFOPN(0,M,NZ,NY,NX)*(ZPOOL(NB,NZ,NY,NX)+ZPOLNB(NB,NZ,NY,NX)
     3+WTRSBN(NB,NZ,NY,NX))
     4+CFOPN(1,M,NZ,NY,NX)*(WTLFBN(NB,NZ,NY,NX)*FWODLN(1)
     5+WTNDBN(NB,NZ,NY,NX))
     6+CFOPN(2,M,NZ,NY,NX)*(WTSHBN(NB,NZ,NY,NX)*FWODSN(1) 
     7+WTHSBN(NB,NZ,NY,NX)+WTEABN(NB,NZ,NY,NX)))
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPN(5,M,NZ,NY,NX)*(WTLFBN(NB,NZ,NY,NX)*FWODLN(0)
     3+WTSHBN(NB,NZ,NY,NX)*FWODSN(0))
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)+(1.0-XHVST)
     2*(CFOPP(0,M,NZ,NY,NX)*(PPOOL(NB,NZ,NY,NX)+PPOLNB(NB,NZ,NY,NX)
     3+WTRSBP(NB,NZ,NY,NX))
     4+CFOPP(1,M,NZ,NY,NX)*(WTLFBP(NB,NZ,NY,NX)*FWODLP(1)
     5+WTNDBP(NB,NZ,NY,NX))
     6+CFOPP(2,M,NZ,NY,NX)*(WTSHBP(NB,NZ,NY,NX)*FWODSP(1)
     7+WTHSBP(NB,NZ,NY,NX)+WTEABP(NB,NZ,NY,NX)))
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPP(5,M,NZ,NY,NX)*(WTLFBP(NB,NZ,NY,NX)*FWODLP(0)
     3+WTSHBP(NB,NZ,NY,NX)*FWODSP(0))
      IF(ISTYP(NZ,NY,NX).EQ.0.AND.IWTYP(NZ,NY,NX).NE.0)THEN
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)+(1.0-XHVST)
     2*CFOPC(2,M,NZ,NY,NX)*WTGRB(NB,NZ,NY,NX)
      WTRVN(NZ,NY,NX)=WTRVN(NZ,NY,NX)+(1.0-XHVST)
     2*CFOPN(2,M,NZ,NY,NX)*WTGRBN(NB,NZ,NY,NX)
      WTRVP(NZ,NY,NX)=WTRVP(NZ,NY,NX)+(1.0-XHVST)
     2*CFOPP(2,M,NZ,NY,NX)*WTGRBP(NB,NZ,NY,NX)
      ELSE
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPC(2,M,NZ,NY,NX)*WTGRB(NB,NZ,NY,NX)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPN(2,M,NZ,NY,NX)*WTGRBN(NB,NZ,NY,NX)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPP(2,M,NZ,NY,NX)*WTGRBP(NB,NZ,NY,NX)
      ENDIF
      IF(IBTYP(NZ,NY,NX).EQ.0.OR.IGTYP(NZ,NY,NX).LE.1)THEN
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPC(3,M,NZ,NY,NX)*WTSTKB(NB,NZ,NY,NX)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPN(3,M,NZ,NY,NX)*WTSTBN(NB,NZ,NY,NX)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPP(3,M,NZ,NY,NX)*WTSTBP(NB,NZ,NY,NX)
      ELSE
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPC(5,M,NZ,NY,NX)*WTSTKB(NB,NZ,NY,NX)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPN(5,M,NZ,NY,NX)*WTSTBN(NB,NZ,NY,NX)
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPP(5,M,NZ,NY,NX)*WTSTBP(NB,NZ,NY,NX)
      ENDIF
6380  CONTINUE
C
C     REDUCE PLANT STATE VARIABLES DURING TILLAGE
C
      CPOOL(NB,NZ,NY,NX)=CPOOL(NB,NZ,NY,NX)*XHVST
      CPOOLK(NB,NZ,NY,NX)=CPOOLK(NB,NZ,NY,NX)*XHVST
      ZPOOL(NB,NZ,NY,NX)=ZPOOL(NB,NZ,NY,NX)*XHVST
      PPOOL(NB,NZ,NY,NX)=PPOOL(NB,NZ,NY,NX)*XHVST
      CPOLNB(NB,NZ,NY,NX)=CPOLNB(NB,NZ,NY,NX)*XHVST
      ZPOLNB(NB,NZ,NY,NX)=ZPOLNB(NB,NZ,NY,NX)*XHVST
      PPOLNB(NB,NZ,NY,NX)=PPOLNB(NB,NZ,NY,NX)*XHVST
      WTSHTB(NB,NZ,NY,NX)=WTSHTB(NB,NZ,NY,NX)*XHVST
      WTLFB(NB,NZ,NY,NX)=WTLFB(NB,NZ,NY,NX)*XHVST
      WTNDB(NB,NZ,NY,NX)=WTNDB(NB,NZ,NY,NX)*XHVST
      WTSHEB(NB,NZ,NY,NX)=WTSHEB(NB,NZ,NY,NX)*XHVST
      WTSTKB(NB,NZ,NY,NX)=WTSTKB(NB,NZ,NY,NX)*XHVST
      WVSTKB(NB,NZ,NY,NX)=WVSTKB(NB,NZ,NY,NX)*XHVST
      WTRSVB(NB,NZ,NY,NX)=WTRSVB(NB,NZ,NY,NX)*XHVST
      WTHSKB(NB,NZ,NY,NX)=WTHSKB(NB,NZ,NY,NX)*XHVST
      WTEARB(NB,NZ,NY,NX)=WTEARB(NB,NZ,NY,NX)*XHVST
      WTGRB(NB,NZ,NY,NX)=WTGRB(NB,NZ,NY,NX)*XHVST
      WTSHTN(NB,NZ,NY,NX)=WTSHTN(NB,NZ,NY,NX)*XHVST
      WTLFBN(NB,NZ,NY,NX)=WTLFBN(NB,NZ,NY,NX)*XHVST
      WTNDBN(NB,NZ,NY,NX)=WTNDBN(NB,NZ,NY,NX)*XHVST
      WTSHBN(NB,NZ,NY,NX)=WTSHBN(NB,NZ,NY,NX)*XHVST
      WTSTBN(NB,NZ,NY,NX)=WTSTBN(NB,NZ,NY,NX)*XHVST
      WTRSBN(NB,NZ,NY,NX)=WTRSBN(NB,NZ,NY,NX)*XHVST
      WTHSBN(NB,NZ,NY,NX)=WTHSBN(NB,NZ,NY,NX)*XHVST
      WTEABN(NB,NZ,NY,NX)=WTEABN(NB,NZ,NY,NX)*XHVST
      WTGRBN(NB,NZ,NY,NX)=WTGRBN(NB,NZ,NY,NX)*XHVST
      WTSHTP(NB,NZ,NY,NX)=WTSHTP(NB,NZ,NY,NX)*XHVST
      WTLFBP(NB,NZ,NY,NX)=WTLFBP(NB,NZ,NY,NX)*XHVST
      WTNDBP(NB,NZ,NY,NX)=WTNDBP(NB,NZ,NY,NX)*XHVST
      WTSHBP(NB,NZ,NY,NX)=WTSHBP(NB,NZ,NY,NX)*XHVST
      WTSTBP(NB,NZ,NY,NX)=WTSTBP(NB,NZ,NY,NX)*XHVST
      WTRSBP(NB,NZ,NY,NX)=WTRSBP(NB,NZ,NY,NX)*XHVST
      WTHSBP(NB,NZ,NY,NX)=WTHSBP(NB,NZ,NY,NX)*XHVST
      WTEABP(NB,NZ,NY,NX)=WTEABP(NB,NZ,NY,NX)*XHVST
      WTGRBP(NB,NZ,NY,NX)=WTGRBP(NB,NZ,NY,NX)*XHVST
      GRNXB(NB,NZ,NY,NX)=GRNXB(NB,NZ,NY,NX)*XHVST
      GRNOB(NB,NZ,NY,NX)=GRNOB(NB,NZ,NY,NX)*XHVST
      GRWTB(NB,NZ,NY,NX)=GRWTB(NB,NZ,NY,NX)*XHVST
      ARLFB(NB,NZ,NY,NX)=ARLFB(NB,NZ,NY,NX)*XHVST
      WTLSB(NB,NZ,NY,NX)=AMAX1(0.0,WTLFB(NB,NZ,NY,NX)
     2+WTSHEB(NB,NZ,NY,NX))
      WTLS(NZ,NY,NX)=WTLS(NZ,NY,NX)+WTLSB(NB,NZ,NY,NX)
      WTSTXB(NB,NZ,NY,NX)=WTSTXB(NB,NZ,NY,NX)*XHVST
      WTSTXN(NB,NZ,NY,NX)=WTSTXN(NB,NZ,NY,NX)*XHVST
      WTSTXP(NB,NZ,NY,NX)=WTSTXP(NB,NZ,NY,NX)*XHVST
      WVSTK(NZ,NY,NX)=WVSTK(NZ,NY,NX)+WVSTKB(NB,NZ,NY,NX)
      DO 8970 K=0,25
      IF(K.NE.0)THEN
      CPOOL3(K,NB,NZ,NY,NX)=CPOOL3(K,NB,NZ,NY,NX)*XHVST 
      CPOOL4(K,NB,NZ,NY,NX)=CPOOL4(K,NB,NZ,NY,NX)*XHVST 
      CO2B(K,NB,NZ,NY,NX)=CO2B(K,NB,NZ,NY,NX)*XHVST 
      HCOB(K,NB,NZ,NY,NX)=HCOB(K,NB,NZ,NY,NX)*XHVST
      ENDIF 
      ARLF(K,NB,NZ,NY,NX)=ARLF(K,NB,NZ,NY,NX)*XHVST
      WGLF(K,NB,NZ,NY,NX)=WGLF(K,NB,NZ,NY,NX)*XHVST
      WSLF(K,NB,NZ,NY,NX)=WSLF(K,NB,NZ,NY,NX)*XHVST
C     HTSHE(K,NB,NZ,NY,NX)=HTSHE(K,NB,NZ,NY,NX)*XHVST
      WGSHE(K,NB,NZ,NY,NX)=WGSHE(K,NB,NZ,NY,NX)*XHVST
      WSSHE(K,NB,NZ,NY,NX)=WSSHE(K,NB,NZ,NY,NX)*XHVST
C     HTNODE(K,NB,NZ,NY,NX)=HTNODE(K,NB,NZ,NY,NX)*XHVST
C     HTNODX(K,NB,NZ,NY,NX)=HTNODX(K,NB,NZ,NY,NX)*XHVST
      WGNODE(K,NB,NZ,NY,NX)=WGNODE(K,NB,NZ,NY,NX)*XHVST
      WGLFN(K,NB,NZ,NY,NX)=WGLFN(K,NB,NZ,NY,NX)*XHVST
      WGSHN(K,NB,NZ,NY,NX)=WGSHN(K,NB,NZ,NY,NX)*XHVST
      WGNODN(K,NB,NZ,NY,NX)=WGNODN(K,NB,NZ,NY,NX)*XHVST
      WGLFP(K,NB,NZ,NY,NX)=WGLFP(K,NB,NZ,NY,NX)*XHVST
      WGSHP(K,NB,NZ,NY,NX)=WGSHP(K,NB,NZ,NY,NX)*XHVST
      WGNODP(K,NB,NZ,NY,NX)=WGNODP(K,NB,NZ,NY,NX)*XHVST
      DO 8965 L=1,NC(NY,NX)
      ARLFL(L,K,NB,NZ,NY,NX)=ARLFL(L,K,NB,NZ,NY,NX)*XHVST
      WGLFL(L,K,NB,NZ,NY,NX)=WGLFL(L,K,NB,NZ,NY,NX)*XHVST
      WGLFLN(L,K,NB,NZ,NY,NX)=WGLFLN(L,K,NB,NZ,NY,NX)*XHVST
      WGLFLP(L,K,NB,NZ,NY,NX)=WGLFLP(L,K,NB,NZ,NY,NX)*XHVST
8965  CONTINUE
8970  CONTINUE
      ENDIF
8975  CONTINUE
      VOLWPX=VOLWP(NZ,NY,NX)
      WVPLT=AMAX1(0.0,WTLS(NZ,NY,NX)+WVSTK(NZ,NY,NX))
      APSILT=ABS(PSILT(NZ,NY,NX))
      FDM=0.16+0.10*APSILT/(0.05*APSILT+2.0)
      VOLWP(NZ,NY,NX)=1.0E-06*WVPLT/FDM
      VOLWOU=VOLWOU+VOLWPX-VOLWP(NZ,NY,NX)
      UVOLO(NY,NX)=UVOLO(NY,NX)+VOLWPX-VOLWP(NZ,NY,NX)
C
C     TERMINATE ROOTS IF TILLAGE IMPLEMENT 20 IS SELECTED
C
      IF(XHVST.LE.1.0E-03)THEN
      IDTHR(NZ,NY,NX)=1
      IDTHP(NZ,NY,NX)=1
      JHVST(NZ,I,NY,NX)=1
      ENDIF
C
C     LITTERFALL FROM ROOTS DURING TILLAGE
C
      DO 8985 N=1,MY(NZ,NY,NX)
      DO 8980 L=NU(NY,NX),NJ(NY,NX)
      DO 6385 M=1,4
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPC(0,M,NZ,NY,NX)*CPOOLR(N,L,NZ,NY,NX)
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPN(0,M,NZ,NY,NX)*ZPOOLR(N,L,NZ,NY,NX)
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPP(0,M,NZ,NY,NX)*PPOOLR(N,L,NZ,NY,NX)
      DO 6385 NR=1,NRT(NZ,NY,NX)
      CSNC(M,0,L,NZ,NY,NX)=CSNC(M,0,L,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPC(5,M,NZ,NY,NX)*(WTRT1(N,L,NR,NZ,NY,NX)
     3+WTRT2(N,L,NR,NZ,NY,NX))*FWOOD(0)
      ZSNC(M,0,L,NZ,NY,NX)=ZSNC(M,0,L,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPN(5,M,NZ,NY,NX)*(WTRT1N(N,L,NR,NZ,NY,NX)
     3+WTRT2N(N,L,NR,NZ,NY,NX))*FWOODN(0)
      PSNC(M,0,L,NZ,NY,NX)=PSNC(M,0,L,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPP(5,M,NZ,NY,NX)*(WTRT1P(N,L,NR,NZ,NY,NX)
     3+WTRT2P(N,L,NR,NZ,NY,NX))*FWOODP(0)
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPC(4,M,NZ,NY,NX)*(WTRT1(N,L,NR,NZ,NY,NX)
     3+WTRT2(N,L,NR,NZ,NY,NX))*FWOOD(1)
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPN(4,M,NZ,NY,NX)*(WTRT1N(N,L,NR,NZ,NY,NX)
     3+WTRT2N(N,L,NR,NZ,NY,NX))*FWOODN(1)
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+(1.0-XHVST)
     2*CFOPP(4,M,NZ,NY,NX)*(WTRT1P(N,L,NR,NZ,NY,NX)
     3+WTRT2P(N,L,NR,NZ,NY,NX))*FWOODP(1)
6385  CONTINUE
C
C     RELEASE ROOT GAS CONTENTS DURING TILLAGE
C
      RCO2Z(NZ,NY,NX)=RCO2Z(NZ,NY,NX)-(1.0-XHVST)
     2*(CO2A(N,L,NZ,NY,NX)+CO2P(N,L,NZ,NY,NX))
      ROXYZ(NZ,NY,NX)=ROXYZ(NZ,NY,NX)-(1.0-XHVST)
     2*(OXYA(N,L,NZ,NY,NX)+OXYP(N,L,NZ,NY,NX))
      RCH4Z(NZ,NY,NX)=RCH4Z(NZ,NY,NX)-(1.0-XHVST)
     2*(CH4A(N,L,NZ,NY,NX)+CH4P(N,L,NZ,NY,NX))
      RN2OZ(NZ,NY,NX)=RN2OZ(NZ,NY,NX)-(1.0-XHVST)
     2*(Z2OA(N,L,NZ,NY,NX)+Z2OP(N,L,NZ,NY,NX))
      RNH3Z(NZ,NY,NX)=RNH3Z(NZ,NY,NX)-(1.0-XHVST)
     2*(ZH3A(N,L,NZ,NY,NX)+ZH3P(N,L,NZ,NY,NX))
      RH2GZ(NZ,NY,NX)=RH2GZ(NZ,NY,NX)-(1.0-XHVST)
     2*(H2GA(N,L,NZ,NY,NX)+H2GP(N,L,NZ,NY,NX))
      CO2A(N,L,NZ,NY,NX)=XHVST*CO2A(N,L,NZ,NY,NX)
      OXYA(N,L,NZ,NY,NX)=XHVST*OXYA(N,L,NZ,NY,NX)
      CH4A(N,L,NZ,NY,NX)=XHVST*CH4A(N,L,NZ,NY,NX)
      Z2OA(N,L,NZ,NY,NX)=XHVST*Z2OA(N,L,NZ,NY,NX)
      ZH3A(N,L,NZ,NY,NX)=XHVST*ZH3A(N,L,NZ,NY,NX)
      H2GA(N,L,NZ,NY,NX)=XHVST*H2GA(N,L,NZ,NY,NX)
      CO2P(N,L,NZ,NY,NX)=XHVST*CO2P(N,L,NZ,NY,NX)
      OXYP(N,L,NZ,NY,NX)=XHVST*OXYP(N,L,NZ,NY,NX)
      CH4P(N,L,NZ,NY,NX)=XHVST*CH4P(N,L,NZ,NY,NX)
      Z2OP(N,L,NZ,NY,NX)=XHVST*Z2OP(N,L,NZ,NY,NX)
      ZH3P(N,L,NZ,NY,NX)=XHVST*ZH3P(N,L,NZ,NY,NX)
      H2GP(N,L,NZ,NY,NX)=XHVST*H2GP(N,L,NZ,NY,NX)
C
C     REDUCE ROOT STATE VARIABLES DURING TILLAGE
C
      DO 8960 NR=1,NRT(NZ,NY,NX)
      WTRT1(N,L,NR,NZ,NY,NX)=WTRT1(N,L,NR,NZ,NY,NX)*XHVST
      WTRT2(N,L,NR,NZ,NY,NX)=WTRT2(N,L,NR,NZ,NY,NX)*XHVST
      WTRT1N(N,L,NR,NZ,NY,NX)=WTRT1N(N,L,NR,NZ,NY,NX)*XHVST
      WTRT2N(N,L,NR,NZ,NY,NX)=WTRT2N(N,L,NR,NZ,NY,NX)*XHVST
      WTRT1P(N,L,NR,NZ,NY,NX)=WTRT1P(N,L,NR,NZ,NY,NX)*XHVST
      WTRT2P(N,L,NR,NZ,NY,NX)=WTRT2P(N,L,NR,NZ,NY,NX)*XHVST
      RTWT1(N,NR,NZ,NY,NX)=RTWT1(N,NR,NZ,NY,NX)*XHVST
      RTWT1N(N,NR,NZ,NY,NX)=RTWT1N(N,NR,NZ,NY,NX)*XHVST
      RTWT1P(N,NR,NZ,NY,NX)=RTWT1P(N,NR,NZ,NY,NX)*XHVST
      RTLG1(N,L,NR,NZ,NY,NX)=RTLG1(N,L,NR,NZ,NY,NX)*XHVST
      RTLG2(N,L,NR,NZ,NY,NX)=RTLG2(N,L,NR,NZ,NY,NX)*XHVST
      RTN2(N,L,NR,NZ,NY,NX)=RTN2(N,L,NR,NZ,NY,NX)*XHVST
8960  CONTINUE
      CPOOLR(N,L,NZ,NY,NX)=CPOOLR(N,L,NZ,NY,NX)*XHVST
      ZPOOLR(N,L,NZ,NY,NX)=ZPOOLR(N,L,NZ,NY,NX)*XHVST
      PPOOLR(N,L,NZ,NY,NX)=PPOOLR(N,L,NZ,NY,NX)*XHVST
      WTRTL(N,L,NZ,NY,NX)=WTRTL(N,L,NZ,NY,NX)*XHVST
      WTRTD(N,L,NZ,NY,NX)=WTRTD(N,L,NZ,NY,NX)*XHVST
      WSRTL(N,L,NZ,NY,NX)=WSRTL(N,L,NZ,NY,NX)*XHVST
      RTN1(N,L,NZ,NY,NX)=RTN1(N,L,NZ,NY,NX)*XHVST
      RTNL(N,L,NZ,NY,NX)=RTNL(N,L,NZ,NY,NX)*XHVST
      RTLGP(N,L,NZ,NY,NX)=RTLGP(N,L,NZ,NY,NX)*XHVST
      RTDNP(N,L,NZ,NY,NX)=RTDNP(N,L,NZ,NY,NX)*XHVST
      RTVLP(N,L,NZ,NY,NX)=RTVLP(N,L,NZ,NY,NX)*XHVST
      RTVLW(N,L,NZ,NY,NX)=RTVLW(N,L,NZ,NY,NX)*XHVST
      RTARP(N,L,NZ,NY,NX)=RTARP(N,L,NZ,NY,NX)*XHVST
      RCO2M(N,L,NZ,NY,NX)=RCO2M(N,L,NZ,NY,NX)*XHVST
      RCO2N(N,L,NZ,NY,NX)=RCO2N(N,L,NZ,NY,NX)*XHVST
      RCO2A(N,L,NZ,NY,NX)=RCO2A(N,L,NZ,NY,NX)*XHVST
C
C     LITTERFALL AND STATE VARIABLES FOR NODULES DURING TILLAGE
C
      IF(INTYP(NZ,NY,NX).NE.0.AND.N.EQ.1)THEN
      DO 6395 M=1,4
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+(1.0-XHVST)
     2*(CFOPC(4,M,NZ,NY,NX)*WTNDL(L,NZ,NY,NX)
     3+CFOPC(0,M,NZ,NY,NX)*CPOOLN(L,NZ,NY,NX))
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+(1.0-XHVST)
     2*(CFOPN(4,M,NZ,NY,NX)*WTNDLN(L,NZ,NY,NX)
     3+CFOPN(0,M,NZ,NY,NX)*ZPOOLN(L,NZ,NY,NX))
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+(1.0-XHVST)
     2*(CFOPP(4,M,NZ,NY,NX)*WTNDLP(L,NZ,NY,NX)
     3+CFOPP(0,M,NZ,NY,NX)*PPOOLN(L,NZ,NY,NX))
6395  CONTINUE
      WTNDL(L,NZ,NY,NX)=WTNDL(L,NZ,NY,NX)*XHVST
      WTNDLN(L,NZ,NY,NX)=WTNDLN(L,NZ,NY,NX)*XHVST
      WTNDLP(L,NZ,NY,NX)=WTNDLP(L,NZ,NY,NX)*XHVST
      CPOOLN(L,NZ,NY,NX)=CPOOLN(L,NZ,NY,NX)*XHVST
      ZPOOLN(L,NZ,NY,NX)=ZPOOLN(L,NZ,NY,NX)*XHVST
      PPOOLN(L,NZ,NY,NX)=PPOOLN(L,NZ,NY,NX)*XHVST
      ENDIF
8980  CONTINUE
8985  CONTINUE
C
C     LITTERFALL AND STATE VARIABLES FOR SEASONAL STORAGE RESERVES
C     DURING TILLAGE
C
      DO 6400 M=1,4
      CSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)=CSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)
     2+((1.0-XHVST)*CFOPC(0,M,NZ,NY,NX)*WTRVC(NZ,NY,NX))*FWOOD(0)
      ZSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)=ZSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)
     2+((1.0-XHVST)*CFOPN(0,M,NZ,NY,NX)*WTRVN(NZ,NY,NX))*FWOODN(0)
      PSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)=PSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)
     2+((1.0-XHVST)*CFOPP(0,M,NZ,NY,NX)*WTRVP(NZ,NY,NX))*FWOODP(0)
      CSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)=CSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)
     2+((1.0-XHVST)*CFOPC(0,M,NZ,NY,NX)*WTRVC(NZ,NY,NX))*FWOOD(1)
      ZSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)=ZSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)
     2+((1.0-XHVST)*CFOPN(0,M,NZ,NY,NX)*WTRVN(NZ,NY,NX))*FWOODN(1)
      PSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)=PSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)
     2+((1.0-XHVST)*CFOPP(0,M,NZ,NY,NX)*WTRVP(NZ,NY,NX))*FWOODP(1)
6400  CONTINUE
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)*XHVST
      WTRVN(NZ,NY,NX)=WTRVN(NZ,NY,NX)*XHVST
      WTRVP(NZ,NY,NX)=WTRVP(NZ,NY,NX)*XHVST
      ENDIF
      ENDIF
      ENDIF
C
C     DEAD BRANCHES
C
      IF(J.EQ.INT(ZNOON(NY,NX)).AND.IDAY(1,NB1(NZ,NY,NX),NZ,NY,NX).NE.0
     2.AND.(ISTYP(NZ,NY,NX).NE.0.OR.(I.GE.IDAYH(NZ,NY,NX)
     3.AND.IYRC.GE.IYRH(NZ,NY,NX))))THEN
      IDTHY=0
C
C     RESET PHENOLOGY AND GROWTH STAGE OF DEAD BRANCHES
C
      DO 8845 NB=1,NBR(NZ,NY,NX)
      IF(IDTHB(NB,NZ,NY,NX).EQ.1)THEN
      GROUP(NB,NZ,NY,NX)=GROUPI(NZ,NY,NX)
      PSTG(NB,NZ,NY,NX)=XTLI(NZ,NY,NX)
      PSTGI(NB,NZ,NY,NX)=PSTG(NB,NZ,NY,NX)
      PSTGF(NB,NZ,NY,NX)=0.0
      VSTG(NB,NZ,NY,NX)=0.0
      VSTGX(NB,NZ,NY,NX)=0.0
      KLEAF(NB,NZ,NY,NX)=1
      KVSTG(NB,NZ,NY,NX)=1
      TGSTGI(NB,NZ,NY,NX)=0.0
      TGSTGF(NB,NZ,NY,NX)=0.0
      IF(IWTYP(NZ,NY,NX).EQ.0)THEN
      VRNS(NB,NZ,NY,NX)=VRNL(NB,NZ,NY,NX)+0.5
      ELSE
      VRNS(NB,NZ,NY,NX)=0.0
      ENDIF
      VRNF(NB,NZ,NY,NX)=0.0
      ATRP(NB,NZ,NY,NX)=0.0
      FLG4(NB,NZ,NY,NX)=0.0
      FDBK(NB,NZ,NY,NX)=1.0
      FDBKX(NB,NZ,NY,NX)=1.0
      IFLGA(NB,NZ,NY,NX)=0
      IFLGE(NB,NZ,NY,NX)=1
      IFLGF(NB,NZ,NY,NX)=0
      IFLGR(NB,NZ,NY,NX)=0
      IFLGQ(NB,NZ,NY,NX)=0
      IFLGD(NB,NZ,NY,NX)=0
      NBTB(NB,NZ,NY,NX)=0
      DO 8850 M=1,10
      IDAY(M,NB,NZ,NY,NX)=0
8850  CONTINUE
C
C     LITTERFALL FROM DEAD BRANCHES
C
      DO 6405 M=1,4
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+CFOPC(0,M,NZ,NY,NX)*(CPOOL(NB,NZ,NY,NX)+CPOLNB(NB,NZ,NY,NX)
     3+CPOOLK(NB,NZ,NY,NX)+WTRSVB(NB,NZ,NY,NX)) 
     4+CFOPC(1,M,NZ,NY,NX)*(WTLFB(NB,NZ,NY,NX)*FWODB(1) 
     5+WTNDB(NB,NZ,NY,NX)) 
     6+CFOPC(2,M,NZ,NY,NX)*(WTSHEB(NB,NZ,NY,NX)*FWODB(1) 
     7+WTHSKB(NB,NZ,NY,NX)+WTEARB(NB,NZ,NY,NX))
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX) 
     2+CFOPC(5,M,NZ,NY,NX)*(WTLFB(NB,NZ,NY,NX)*FWODB(0)
     3+WTSHEB(NB,NZ,NY,NX)*FWODB(0))
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+CFOPN(0,M,NZ,NY,NX)*(ZPOOL(NB,NZ,NY,NX)+ZPOLNB(NB,NZ,NY,NX)
     3+WTRSBN(NB,NZ,NY,NX))
     4+CFOPN(1,M,NZ,NY,NX)*(WTLFBN(NB,NZ,NY,NX)*FWODLN(1)
     5+WTNDBN(NB,NZ,NY,NX))
     6+CFOPN(2,M,NZ,NY,NX)*(WTSHBN(NB,NZ,NY,NX)*FWODSN(1) 
     7+WTHSBN(NB,NZ,NY,NX)+WTEABN(NB,NZ,NY,NX))
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX) 
     2+CFOPN(5,M,NZ,NY,NX)*(WTLFBN(NB,NZ,NY,NX)*FWODLN(0)
     3+WTSHBN(NB,NZ,NY,NX)*FWODSN(0))
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX) 
     2+CFOPP(0,M,NZ,NY,NX)*(PPOOL(NB,NZ,NY,NX)+PPOLNB(NB,NZ,NY,NX)
     3+WTRSBP(NB,NZ,NY,NX))
     4+CFOPP(1,M,NZ,NY,NX)*(WTLFBP(NB,NZ,NY,NX)*FWODLP(1)
     5+WTNDBP(NB,NZ,NY,NX))
     6+CFOPP(2,M,NZ,NY,NX)*(WTSHBP(NB,NZ,NY,NX)*FWODSP(1)
     7+WTHSBP(NB,NZ,NY,NX)+WTEABP(NB,NZ,NY,NX))
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX) 
     2+CFOPP(5,M,NZ,NY,NX)*(WTLFBP(NB,NZ,NY,NX)*FWODLP(0)
     3+WTSHBP(NB,NZ,NY,NX)*FWODSP(0))
      IF(ISTYP(NZ,NY,NX).EQ.0.AND.IWTYP(NZ,NY,NX).NE.0)THEN
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)
     2+CFOPC(2,M,NZ,NY,NX)*WTGRB(NB,NZ,NY,NX)
      WTRVN(NZ,NY,NX)=WTRVN(NZ,NY,NX)
     2+CFOPN(2,M,NZ,NY,NX)*WTGRBN(NB,NZ,NY,NX)
      WTRVP(NZ,NY,NX)=WTRVP(NZ,NY,NX)
     2+CFOPP(2,M,NZ,NY,NX)*WTGRBP(NB,NZ,NY,NX)
      ELSE
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+CFOPC(2,M,NZ,NY,NX)*WTGRB(NB,NZ,NY,NX)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+CFOPN(2,M,NZ,NY,NX)*WTGRBN(NB,NZ,NY,NX)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX) 
     2+CFOPP(2,M,NZ,NY,NX)*WTGRBP(NB,NZ,NY,NX)
      ENDIF
      IF(IBTYP(NZ,NY,NX).EQ.0.OR.IGTYP(NZ,NY,NX).LE.1)THEN
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     5+CFOPC(3,M,NZ,NY,NX)*WTSTKB(NB,NZ,NY,NX)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     5+CFOPN(3,M,NZ,NY,NX)*WTSTBN(NB,NZ,NY,NX)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)
     5+CFOPP(3,M,NZ,NY,NX)*WTSTBP(NB,NZ,NY,NX)
      ELSE
      WTSTDG(M,NZ,NY,NX)=WTSTDG(M,NZ,NY,NX)
     5+CFOPC(5,M,NZ,NY,NX)*WTSTKB(NB,NZ,NY,NX)
      WTSTDN(M,NZ,NY,NX)=WTSTDN(M,NZ,NY,NX)
     5+CFOPN(5,M,NZ,NY,NX)*WTSTBN(NB,NZ,NY,NX)
      WTSTDP(M,NZ,NY,NX)=WTSTDP(M,NZ,NY,NX)
     5+CFOPP(5,M,NZ,NY,NX)*WTSTBP(NB,NZ,NY,NX)
      ENDIF
6405  CONTINUE
C
C     RECOVER NON-STRUCTURAL C,N,P FROM BRANCH TO
C     SEASONAL STORAGE RESERVES
C
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)
     2+CPOOL(NB,NZ,NY,NX)+CPOOLK(NB,NZ,NY,NX)+WTRSVB(NB,NZ,NY,NX)
      WTRVN(NZ,NY,NX)=WTRVN(NZ,NY,NX)
     2+ZPOOL(NB,NZ,NY,NX)+WTRSBN(NB,NZ,NY,NX)
      WTRVP(NZ,NY,NX)=WTRVP(NZ,NY,NX)
     2+PPOOL(NB,NZ,NY,NX)+WTRSBP(NB,NZ,NY,NX)
C
C     RESET STATE VARIABLES FROM DEAD BRANCHES
C
      CPOOL(NB,NZ,NY,NX)=0.0
      CPOOLK(NB,NZ,NY,NX)=0.0
      ZPOOL(NB,NZ,NY,NX)=0.0
      PPOOL(NB,NZ,NY,NX)=0.0
      CPOLNB(NB,NZ,NY,NX)=0.0
      ZPOLNB(NB,NZ,NY,NX)=0.0
      PPOLNB(NB,NZ,NY,NX)=0.0
      WTSHTB(NB,NZ,NY,NX)=0.0
      WTLFB(NB,NZ,NY,NX)=0.0
      WTNDB(NB,NZ,NY,NX)=0.0
      WTSHEB(NB,NZ,NY,NX)=0.0
      WTSTKB(NB,NZ,NY,NX)=0.0
      WVSTKB(NB,NZ,NY,NX)=0.0
      WTRSVB(NB,NZ,NY,NX)=0.0
      WTHSKB(NB,NZ,NY,NX)=0.0
      WTEARB(NB,NZ,NY,NX)=0.0
      WTGRB(NB,NZ,NY,NX)=0.0
      WTLSB(NB,NZ,NY,NX)=0.0
      WTSHTN(NB,NZ,NY,NX)=0.0
      WTLFBN(NB,NZ,NY,NX)=0.0
      WTNDBN(NB,NZ,NY,NX)=0.0
      WTSHBN(NB,NZ,NY,NX)=0.0
      WTSTBN(NB,NZ,NY,NX)=0.0
      WTRSBN(NB,NZ,NY,NX)=0.0
      WTHSBN(NB,NZ,NY,NX)=0.0
      WTEABN(NB,NZ,NY,NX)=0.0
      WTGRBN(NB,NZ,NY,NX)=0.0
      WTSHTP(NB,NZ,NY,NX)=0.0
      WTLFBP(NB,NZ,NY,NX)=0.0
      WTNDBP(NB,NZ,NY,NX)=0.0
      WTSHBP(NB,NZ,NY,NX)=0.0
      WTSTBP(NB,NZ,NY,NX)=0.0
      WTRSBP(NB,NZ,NY,NX)=0.0
      WTHSBP(NB,NZ,NY,NX)=0.0
      WTEABP(NB,NZ,NY,NX)=0.0
      WTGRBP(NB,NZ,NY,NX)=0.0
      GRNXB(NB,NZ,NY,NX)=0.0
      GRNOB(NB,NZ,NY,NX)=0.0
      GRWTB(NB,NZ,NY,NX)=0.0
      ARLFB(NB,NZ,NY,NX)=0.0
      WTSTXB(NB,NZ,NY,NX)=0.0
      WTSTXN(NB,NZ,NY,NX)=0.0
      WTSTXP(NB,NZ,NY,NX)=0.0
      DO 8855 K=0,25
      IF(K.NE.0)THEN
      CPOOL3(K,NB,NZ,NY,NX)=0.0 
      CPOOL4(K,NB,NZ,NY,NX)=0.0 
      CO2B(K,NB,NZ,NY,NX)=0.0 
      HCOB(K,NB,NZ,NY,NX)=0.0 
      ENDIF
      ARLF(K,NB,NZ,NY,NX)=0.0
      HTNODE(K,NB,NZ,NY,NX)=0.0
      HTNODX(K,NB,NZ,NY,NX)=0.0
      HTSHE(K,NB,NZ,NY,NX)=0.0
      WGLF(K,NB,NZ,NY,NX)=0.0
      WSLF(K,NB,NZ,NY,NX)=0.0
      WGLFN(K,NB,NZ,NY,NX)=0.0
      WGLFP(K,NB,NZ,NY,NX)=0.0
      WGSHE(K,NB,NZ,NY,NX)=0.0
      WSSHE(K,NB,NZ,NY,NX)=0.0
      WGSHN(K,NB,NZ,NY,NX)=0.0
      WGSHP(K,NB,NZ,NY,NX)=0.0
      WGNODE(K,NB,NZ,NY,NX)=0.0
      WGNODN(K,NB,NZ,NY,NX)=0.0
      WGNODP(K,NB,NZ,NY,NX)=0.0
      DO 8865 L=1,NC(NY,NX)
      ARLFV(L,NZ,NY,NX)=ARLFV(L,NZ,NY,NX)-ARLFL(L,K,NB,NZ,NY,NX)
      WGLFV(L,NZ,NY,NX)=WGLFV(L,NZ,NY,NX)-WGLFL(L,K,NB,NZ,NY,NX)
      ARLFL(L,K,NB,NZ,NY,NX)=0.0
      WGLFL(L,K,NB,NZ,NY,NX)=0.0
      WGLFLN(L,K,NB,NZ,NY,NX)=0.0
      WGLFLP(L,K,NB,NZ,NY,NX)=0.0
      IF(K.NE.0)THEN
      DO 8860 N=1,4
      SURF(N,L,K,NB,NZ,NY,NX)=0.0
8860  CONTINUE
      ENDIF
8865  CONTINUE
8855  CONTINUE
      DO 8875 L=1,NC(NY,NX)
      ARSTK(L,NB,NZ,NY,NX)=0.0
      DO 8875 N=1,4
      SURFB(N,L,NB,NZ,NY,NX)=0.0
8875  CONTINUE
      IDTHY=IDTHY+1
      ENDIF
8845  CONTINUE
      IF(IDTHY.EQ.NBR(NZ,NY,NX))THEN
      IDTHP(NZ,NY,NX)=1
      NBT(NZ,NY,NX)=0
      WSTR(NZ,NY,NX)=0.0
      IF(IFLGI(NZ,NY,NX).EQ.1)THEN
      NBR(NZ,NY,NX)=1
      ELSE
      NBR(NZ,NY,NX)=0
      ENDIF
      HTCTL(NZ,NY,NX)=0.0
      VOLWOU=VOLWOU+VOLWP(NZ,NY,NX)
      UVOLO(NY,NX)=UVOLO(NY,NX)+VOLWP(NZ,NY,NX)
      VOLWP(NZ,NY,NX)=0.0
      IF(WTRVC(NZ,NY,NX).LT.1.0E-04*WTRT(NZ,NY,NX)
     2.AND.ISTYP(NZ,NY,NX).NE.0)IDTHR(NZ,NY,NX)=1
      IF(ISTYP(NZ,NY,NX).EQ.0)IDTHR(NZ,NY,NX)=1
      IF(JHVST(NZ,I,NY,NX).NE.0)IDTHR(NZ,NY,NX)=1
      IF(PP(NZ,NY,NX).LE.0.0)IDTHR(NZ,NY,NX)=1
      IF(IDTHR(NZ,NY,NX).EQ.1)IDTHP(NZ,NY,NX)=1
      ENDIF
C
C     DEAD ROOTS
C
C
C     LITTERFALL FROM DEAD ROOTS
C
      IF(IDTHR(NZ,NY,NX).EQ.1)THEN
      DO 8900 N=1,MY(NZ,NY,NX)
      DO 8895 L=NU(NY,NX),NJ(NY,NX)
      DO 6410 M=1,4
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+CFOPC(0,M,NZ,NY,NX)
     2*CPOOLR(N,L,NZ,NY,NX)
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+CFOPN(0,M,NZ,NY,NX)
     2*ZPOOLR(N,L,NZ,NY,NX)
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+CFOPP(0,M,NZ,NY,NX)
     2*PPOOLR(N,L,NZ,NY,NX)
      DO 6410 NR=1,NRT(NZ,NY,NX)
      CSNC(M,0,L,NZ,NY,NX)=CSNC(M,0,L,NZ,NY,NX)+CFOPC(5,M,NZ,NY,NX)
     2*(WTRT1(N,L,NR,NZ,NY,NX)+WTRT2(N,L,NR,NZ,NY,NX))*FWOOD(0)
      ZSNC(M,0,L,NZ,NY,NX)=ZSNC(M,0,L,NZ,NY,NX)+CFOPN(5,M,NZ,NY,NX)
     2*(WTRT1N(N,L,NR,NZ,NY,NX)+WTRT2N(N,L,NR,NZ,NY,NX))*FWOODN(0)
      PSNC(M,0,L,NZ,NY,NX)=PSNC(M,0,L,NZ,NY,NX)+CFOPP(5,M,NZ,NY,NX)
     2*(WTRT1P(N,L,NR,NZ,NY,NX)+WTRT2P(N,L,NR,NZ,NY,NX))*FWOODP(0)
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+CFOPC(4,M,NZ,NY,NX)
     2*(WTRT1(N,L,NR,NZ,NY,NX)+WTRT2(N,L,NR,NZ,NY,NX))*FWOOD(1)
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+CFOPN(4,M,NZ,NY,NX)
     2*(WTRT1N(N,L,NR,NZ,NY,NX)+WTRT2N(N,L,NR,NZ,NY,NX))*FWOODN(1)
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+CFOPP(4,M,NZ,NY,NX)
     2*(WTRT1P(N,L,NR,NZ,NY,NX)+WTRT2P(N,L,NR,NZ,NY,NX))*FWOODP(1)
6410  CONTINUE
C
C     RELEASE GAS CONTENTS OF DEAD ROOTS
C
      RCO2Z(NZ,NY,NX)=RCO2Z(NZ,NY,NX)-CO2A(N,L,NZ,NY,NX)
     2-CO2P(N,L,NZ,NY,NX)
      ROXYZ(NZ,NY,NX)=ROXYZ(NZ,NY,NX)-OXYA(N,L,NZ,NY,NX)
     2-OXYP(N,L,NZ,NY,NX)
      RCH4Z(NZ,NY,NX)=RCH4Z(NZ,NY,NX)-CH4A(N,L,NZ,NY,NX)
     2-CH4P(N,L,NZ,NY,NX)
      RN2OZ(NZ,NY,NX)=RN2OZ(NZ,NY,NX)-Z2OA(N,L,NZ,NY,NX)
     2-Z2OP(N,L,NZ,NY,NX)
      RNH3Z(NZ,NY,NX)=RNH3Z(NZ,NY,NX)-ZH3A(N,L,NZ,NY,NX)
     2-ZH3P(N,L,NZ,NY,NX)
      RH2GZ(NZ,NY,NX)=RH2GZ(NZ,NY,NX)-H2GA(N,L,NZ,NY,NX)
     2-H2GP(N,L,NZ,NY,NX)
      CO2A(N,L,NZ,NY,NX)=0.0
      OXYA(N,L,NZ,NY,NX)=0.0
      CH4A(N,L,NZ,NY,NX)=0.0
      Z2OA(N,L,NZ,NY,NX)=0.0
      ZH3A(N,L,NZ,NY,NX)=0.0
      H2GA(N,L,NZ,NY,NX)=0.0
      CO2P(N,L,NZ,NY,NX)=0.0
      OXYP(N,L,NZ,NY,NX)=0.0
      CH4P(N,L,NZ,NY,NX)=0.0
      Z2OP(N,L,NZ,NY,NX)=0.0
      ZH3P(N,L,NZ,NY,NX)=0.0
      H2GP(N,L,NZ,NY,NX)=0.0
C
C     RESET STATE VARIABLES OF DEAD ROOTS
C
      DO 8870 NR=1,NRT(NZ,NY,NX)
      WTRT1(N,L,NR,NZ,NY,NX)=0.0
      WTRT1N(N,L,NR,NZ,NY,NX)=0.0
      WTRT1P(N,L,NR,NZ,NY,NX)=0.0
      WTRT2(N,L,NR,NZ,NY,NX)=0.0
      WTRT2N(N,L,NR,NZ,NY,NX)=0.0
      WTRT2P(N,L,NR,NZ,NY,NX)=0.0
      RTWT1(N,NR,NZ,NY,NX)=0.0
      RTWT1N(N,NR,NZ,NY,NX)=0.0
      RTWT1P(N,NR,NZ,NY,NX)=0.0
      RTLG1(N,L,NR,NZ,NY,NX)=0.0
      RTLG2(N,L,NR,NZ,NY,NX)=0.0
      RTN2(N,L,NR,NZ,NY,NX)=0.0
8870  CONTINUE
      CPOOLR(N,L,NZ,NY,NX)=0.0
      ZPOOLR(N,L,NZ,NY,NX)=0.0
      PPOOLR(N,L,NZ,NY,NX)=0.0
      WTRTL(N,L,NZ,NY,NX)=0.0
      WTRTD(N,L,NZ,NY,NX)=0.0
      WSRTL(N,L,NZ,NY,NX)=0.0
      RTN1(N,L,NZ,NY,NX)=0.0
      RTNL(N,L,NZ,NY,NX)=0.0
      RTLGP(N,L,NZ,NY,NX)=0.0
      RTDNP(N,L,NZ,NY,NX)=0.0
      RTVLP(N,L,NZ,NY,NX)=0.0
      RTVLW(N,L,NZ,NY,NX)=0.0
      RRAD1(N,L,NZ,NY,NX)=RRAD1M(N,NZ,NY,NX)
      RRAD2(N,L,NZ,NY,NX)=RRAD2M(N,NZ,NY,NX)
      RTARP(N,L,NZ,NY,NX)=0.0
      RTLGA(N,L,NZ,NY,NX)=RTLGAX
C
C     LITTERFALL AND STATE VARIABLES FROM DEAD NODULES
C
      IF(INTYP(NZ,NY,NX).NE.0.AND.N.EQ.1)THEN
      DO 6420 M=1,4
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+CFOPC(4,M,NZ,NY,NX)
     2*WTNDL(L,NZ,NY,NX)+CFOPC(0,M,NZ,NY,NX)*CPOOLN(L,NZ,NY,NX)
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+CFOPN(4,M,NZ,NY,NX)
     2*WTNDLN(L,NZ,NY,NX)+CFOPN(0,M,NZ,NY,NX)*ZPOOLN(L,NZ,NY,NX)
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+CFOPP(4,M,NZ,NY,NX)
     2*WTNDLP(L,NZ,NY,NX)+CFOPP(0,M,NZ,NY,NX)*PPOOLN(L,NZ,NY,NX)
6420  CONTINUE
      WTNDL(L,NZ,NY,NX)=0.0
      WTNDLN(L,NZ,NY,NX)=0.0
      WTNDLP(L,NZ,NY,NX)=0.0
      CPOOLN(L,NZ,NY,NX)=0.0
      ZPOOLN(L,NZ,NY,NX)=0.0
      PPOOLN(L,NZ,NY,NX)=0.0
      ENDIF
8895  CONTINUE
8900  CONTINUE
C
C     RESET DEPTH VARIABLES OF DEAD ROOTS
C
      DO 8795 NR=1,NRT(NZ,NY,NX)
      NINR(NR,NZ,NY,NX)=NG(NZ,NY,NX)
      DO 8790 N=1,MY(NZ,NY,NX)
      RTDP1(N,NR,NZ,NY,NX)=SDPTH(NZ,NY,NX)
      RTWT1(N,NR,NZ,NY,NX)=0.0
      RTWT1N(N,NR,NZ,NY,NX)=0.0
      RTWT1P(N,NR,NZ,NY,NX)=0.0
8790  CONTINUE
8795  CONTINUE
      NIX(NZ,NY,NX)=NG(NZ,NY,NX)
      NRT(NZ,NY,NX)=0
      ENDIF
C
C     LITTERFALL AND STATE VARIABLES FOR SEASONAL STORAGE
C     RESERVES AT DEATH
C
      IF(IDTHP(NZ,NY,NX).EQ.1.AND.IDTHR(NZ,NY,NX).EQ.1)THEN
      IF(IFLGI(NZ,NY,NX).EQ.0)THEN
      DO 6425 M=1,4
      DO 8825 NB=1,NBR(NZ,NY,NX)
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+CFOPC(0,M,NZ,NY,NX)*(CPOOL(NB,NZ,NY,NX)+CPOLNB(NB,NZ,NY,NX)
     3+CPOOLK(NB,NZ,NY,NX)+WTRSVB(NB,NZ,NY,NX)) 
     4+CFOPC(1,M,NZ,NY,NX)*(WTLFB(NB,NZ,NY,NX)*FWODB(1) 
     5+WTNDB(NB,NZ,NY,NX)) 
     6+CFOPC(2,M,NZ,NY,NX)*(WTSHEB(NB,NZ,NY,NX)*FWODB(1) 
     7+WTHSKB(NB,NZ,NY,NX)+WTEARB(NB,NZ,NY,NX))
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX) 
     2+CFOPC(5,M,NZ,NY,NX)*(WTLFB(NB,NZ,NY,NX)*FWODB(0)
     3+WTSHEB(NB,NZ,NY,NX)*FWODB(0))
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+CFOPN(0,M,NZ,NY,NX)*(ZPOOL(NB,NZ,NY,NX)+ZPOLNB(NB,NZ,NY,NX)
     3+WTRSBN(NB,NZ,NY,NX))
     4+CFOPN(1,M,NZ,NY,NX)*(WTLFBN(NB,NZ,NY,NX)*FWODLN(1)
     5+WTNDBN(NB,NZ,NY,NX))
     6+CFOPN(2,M,NZ,NY,NX)*(WTSHBN(NB,NZ,NY,NX)*FWODSN(1) 
     7+WTHSBN(NB,NZ,NY,NX)+WTEABN(NB,NZ,NY,NX))
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX) 
     2+CFOPN(5,M,NZ,NY,NX)*(WTLFBN(NB,NZ,NY,NX)*FWODLN(0)
     3+WTSHBN(NB,NZ,NY,NX)*FWODSN(0))
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX) 
     2+CFOPP(0,M,NZ,NY,NX)*(PPOOL(NB,NZ,NY,NX)+PPOLNB(NB,NZ,NY,NX)
     3+WTRSBP(NB,NZ,NY,NX))
     4+CFOPP(1,M,NZ,NY,NX)*(WTLFBP(NB,NZ,NY,NX)*FWODLP(1)
     5+WTNDBP(NB,NZ,NY,NX))
     6+CFOPP(2,M,NZ,NY,NX)*(WTSHBP(NB,NZ,NY,NX)*FWODSP(1)
     7+WTHSBP(NB,NZ,NY,NX)+WTEABP(NB,NZ,NY,NX))
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX) 
     2+CFOPP(5,M,NZ,NY,NX)*(WTLFBP(NB,NZ,NY,NX)*FWODLP(0)
     3+WTSHBP(NB,NZ,NY,NX)*FWODSP(0))
      IF(ISTYP(NZ,NY,NX).EQ.0.AND.IWTYP(NZ,NY,NX).NE.0)THEN
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)
     2+CFOPC(2,M,NZ,NY,NX)*WTGRB(NB,NZ,NY,NX)
      WTRVN(NZ,NY,NX)=WTRVN(NZ,NY,NX)
     2+CFOPN(2,M,NZ,NY,NX)*WTGRBN(NB,NZ,NY,NX)
      WTRVP(NZ,NY,NX)=WTRVP(NZ,NY,NX)
     2+CFOPP(2,M,NZ,NY,NX)*WTGRBP(NB,NZ,NY,NX)
      ELSE
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+CFOPC(2,M,NZ,NY,NX)*WTGRB(NB,NZ,NY,NX)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+CFOPN(2,M,NZ,NY,NX)*WTGRBN(NB,NZ,NY,NX)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX) 
     2+CFOPP(2,M,NZ,NY,NX)*WTGRBP(NB,NZ,NY,NX)
      ENDIF
      IF(IBTYP(NZ,NY,NX).EQ.0.OR.IGTYP(NZ,NY,NX).LE.1)THEN
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     5+CFOPC(3,M,NZ,NY,NX)*WTSTKB(NB,NZ,NY,NX)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     5+CFOPN(3,M,NZ,NY,NX)*WTSTBN(NB,NZ,NY,NX)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)
     5+CFOPP(3,M,NZ,NY,NX)*WTSTBP(NB,NZ,NY,NX)
      ELSE
      WTSTDG(M,NZ,NY,NX)=WTSTDG(M,NZ,NY,NX)
     5+CFOPC(5,M,NZ,NY,NX)*WTSTKB(NB,NZ,NY,NX)
      WTSTDN(M,NZ,NY,NX)=WTSTDN(M,NZ,NY,NX)
     5+CFOPN(5,M,NZ,NY,NX)*WTSTBN(NB,NZ,NY,NX)
      WTSTDP(M,NZ,NY,NX)=WTSTDP(M,NZ,NY,NX)
     5+CFOPP(5,M,NZ,NY,NX)*WTSTBP(NB,NZ,NY,NX)
      ENDIF
8825  CONTINUE
      DO 6415 L=NU(NY,NX),NJ(NY,NX)
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+CFOPC(0,M,NZ,NY,NX)
     2*CPOOLR(N,L,NZ,NY,NX)
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+CFOPN(0,M,NZ,NY,NX)
     2*ZPOOLR(N,L,NZ,NY,NX)
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+CFOPP(0,M,NZ,NY,NX)
     2*PPOOLR(N,L,NZ,NY,NX)
      DO 6415 NR=1,NRT(NZ,NY,NX)
      CSNC(M,0,L,NZ,NY,NX)=CSNC(M,0,L,NZ,NY,NX)+CFOPC(5,M,NZ,NY,NX)
     2*(WTRT1(N,L,NR,NZ,NY,NX)+WTRT2(N,L,NR,NZ,NY,NX))*FWOOD(0)
      ZSNC(M,0,L,NZ,NY,NX)=ZSNC(M,0,L,NZ,NY,NX)+CFOPN(5,M,NZ,NY,NX)
     2*(WTRT1N(N,L,NR,NZ,NY,NX)+WTRT2N(N,L,NR,NZ,NY,NX))*FWOODN(0)
      PSNC(M,0,L,NZ,NY,NX)=PSNC(M,0,L,NZ,NY,NX)+CFOPP(5,M,NZ,NY,NX)
     2*(WTRT1P(N,L,NR,NZ,NY,NX)+WTRT2P(N,L,NR,NZ,NY,NX))*FWOODP(0)
      CSNC(M,1,L,NZ,NY,NX)=CSNC(M,1,L,NZ,NY,NX)+CFOPC(4,M,NZ,NY,NX)
     2*(WTRT1(N,L,NR,NZ,NY,NX)+WTRT2(N,L,NR,NZ,NY,NX))*FWOOD(1)
      ZSNC(M,1,L,NZ,NY,NX)=ZSNC(M,1,L,NZ,NY,NX)+CFOPN(4,M,NZ,NY,NX)
     2*(WTRT1N(N,L,NR,NZ,NY,NX)+WTRT2N(N,L,NR,NZ,NY,NX))*FWOODN(1)
      PSNC(M,1,L,NZ,NY,NX)=PSNC(M,1,L,NZ,NY,NX)+CFOPP(4,M,NZ,NY,NX)
     2*(WTRT1P(N,L,NR,NZ,NY,NX)+WTRT2P(N,L,NR,NZ,NY,NX))*FWOODP(1)
6415  CONTINUE
      CSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)=CSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)
     2+CFOPC(0,M,NZ,NY,NX)*WTRVC(NZ,NY,NX)*FWOOD(0)
      ZSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)=ZSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)
     2+CFOPN(0,M,NZ,NY,NX)*WTRVN(NZ,NY,NX)*FWOODN(0)
      PSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)=PSNC(M,0,NG(NZ,NY,NX),NZ,NY,NX)
     2+CFOPP(0,M,NZ,NY,NX)*WTRVP(NZ,NY,NX)*FWOODP(0)
      CSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)=CSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)
     2+CFOPC(0,M,NZ,NY,NX)*WTRVC(NZ,NY,NX)*FWOOD(1)
      ZSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)=ZSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)
     2+CFOPN(0,M,NZ,NY,NX)*WTRVN(NZ,NY,NX)*FWOODN(1)
      PSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)=PSNC(M,1,NG(NZ,NY,NX),NZ,NY,NX)
     2+CFOPP(0,M,NZ,NY,NX)*WTRVP(NZ,NY,NX)*FWOODP(1)
6425  CONTINUE
      DO 8835 NB=1,NBR(NZ,NY,NX)
      CPOOL(NB,NZ,NY,NX)=0.0
      CPOOLK(NB,NZ,NY,NX)=0.0
      ZPOOL(NB,NZ,NY,NX)=0.0
      PPOOL(NB,NZ,NY,NX)=0.0
      CPOLNB(NB,NZ,NY,NX)=0.0
      ZPOLNB(NB,NZ,NY,NX)=0.0
      PPOLNB(NB,NZ,NY,NX)=0.0
      WTSHTB(NB,NZ,NY,NX)=0.0
      WTLFB(NB,NZ,NY,NX)=0.0
      WTNDB(NB,NZ,NY,NX)=0.0
      WTSHEB(NB,NZ,NY,NX)=0.0
      WTSTKB(NB,NZ,NY,NX)=0.0
      WVSTKB(NB,NZ,NY,NX)=0.0
      WTRSVB(NB,NZ,NY,NX)=0.0
      WTHSKB(NB,NZ,NY,NX)=0.0
      WTEARB(NB,NZ,NY,NX)=0.0
      WTGRB(NB,NZ,NY,NX)=0.0
      WTLSB(NB,NZ,NY,NX)=0.0
      WTSHTN(NB,NZ,NY,NX)=0.0
      WTLFBN(NB,NZ,NY,NX)=0.0
      WTNDBN(NB,NZ,NY,NX)=0.0
      WTSHBN(NB,NZ,NY,NX)=0.0
      WTSTBN(NB,NZ,NY,NX)=0.0
      WTRSBN(NB,NZ,NY,NX)=0.0
      WTHSBN(NB,NZ,NY,NX)=0.0
      WTEABN(NB,NZ,NY,NX)=0.0
      WTGRBN(NB,NZ,NY,NX)=0.0
      WTSHTP(NB,NZ,NY,NX)=0.0
      WTLFBP(NB,NZ,NY,NX)=0.0
      WTNDBP(NB,NZ,NY,NX)=0.0
      WTSHBP(NB,NZ,NY,NX)=0.0
      WTSTBP(NB,NZ,NY,NX)=0.0
      WTRSBP(NB,NZ,NY,NX)=0.0
      WTHSBP(NB,NZ,NY,NX)=0.0
      WTEABP(NB,NZ,NY,NX)=0.0
      WTGRBP(NB,NZ,NY,NX)=0.0
      WTSTXB(NB,NZ,NY,NX)=0.0
      WTSTXN(NB,NZ,NY,NX)=0.0
      WTSTXP(NB,NZ,NY,NX)=0.0
8835  CONTINUE
      DO 6416 L=NU(NY,NX),NJ(NY,NX)
      CPOOLR(N,L,NZ,NY,NX)=0.0
      ZPOOLR(N,L,NZ,NY,NX)=0.0
      PPOOLR(N,L,NZ,NY,NX)=0.0
      DO 6416 NR=1,NRT(NZ,NY,NX)
      WTRT1(N,L,NR,NZ,NY,NX)=0.0
      WTRT1N(N,L,NR,NZ,NY,NX)=0.0
      WTRT1P(N,L,NR,NZ,NY,NX)=0.0
      WTRT2(N,L,NR,NZ,NY,NX)=0.0
      WTRT2N(N,L,NR,NZ,NY,NX)=0.0
      WTRT2P(N,L,NR,NZ,NY,NX)=0.0
      RTWT1(N,NR,NZ,NY,NX)=0.0
      RTWT1N(N,NR,NZ,NY,NX)=0.0
      RTWT1P(N,NR,NZ,NY,NX)=0.0
      RTLG1(N,L,NR,NZ,NY,NX)=0.0
      RTLG2(N,L,NR,NZ,NY,NX)=0.0
      RTN2(N,L,NR,NZ,NY,NX)=0.0
6416  CONTINUE
      WTRVC(NZ,NY,NX)=0.0
      WTRVN(NZ,NY,NX)=0.0
      WTRVP(NZ,NY,NX)=0.0
      IDTH(NZ,NY,NX)=1
      ENDIF
C
C     RESEED DEAD PERENNIALS
C
      IF(ISTYP(NZ,NY,NX).NE.0.AND.JHVST(NZ,I,NY,NX).EQ.0)THEN
      IF(I.LT.LYRC)THEN
      IDAY0(NZ,NY,NX)=I+1
      IYR0(NZ,NY,NX)=IDATA(3)
      ELSE
      IDAY0(NZ,NY,NX)=1
      IYR0(NZ,NY,NX)=IDATA(3)+1
      ENDIF
      ENDIF
      ENDIF
      ENDIF
C
C     CHECK PLANT C,N,P BALANCES
C
      CPOOLP(NZ,NY,NX)=0.0
      ZPOOLP(NZ,NY,NX)=0.0
      PPOOLP(NZ,NY,NX)=0.0
      WTSHT(NZ,NY,NX)=0.0
      WTSHN(NZ,NY,NX)=0.0
      WTSHP(NZ,NY,NX)=0.0
      WTLF(NZ,NY,NX)=0.0
      WTSHE(NZ,NY,NX)=0.0
      WTSTK(NZ,NY,NX)=0.0
      WVSTK(NZ,NY,NX)=0.0
      WTRSV(NZ,NY,NX)=0.0
      WTHSK(NZ,NY,NX)=0.0
      WTEAR(NZ,NY,NX)=0.0
      WTGR(NZ,NY,NX)=0.0
      WTLS(NZ,NY,NX)=0.0
      WTRT(NZ,NY,NX)=0.0
      WTRTS(NZ,NY,NX)=0.0
      WTRTN(NZ,NY,NX)=0.0
      WTRTP(NZ,NY,NX)=0.0
      WTLFN(NZ,NY,NX)=0.0
      WTSHEN(NZ,NY,NX)=0.0
      WTSTKN(NZ,NY,NX)=0.0
      WTRSVN(NZ,NY,NX)=0.0
      WTHSKN(NZ,NY,NX)=0.0
      WTEARN(NZ,NY,NX)=0.0
      WTGRNN(NZ,NY,NX)=0.0
      WTLFP(NZ,NY,NX)=0.0
      WTSHEP(NZ,NY,NX)=0.0
      WTSTKP(NZ,NY,NX)=0.0
      WTRSVP(NZ,NY,NX)=0.0
      WTHSKP(NZ,NY,NX)=0.0
      WTEARP(NZ,NY,NX)=0.0
      WTGRNP(NZ,NY,NX)=0.0
      GRNO(NZ,NY,NX)=0.0
      ARLFP(NZ,NY,NX)=0.0
      ARSTP(NZ,NY,NX)=0.0
      DO 8940 L=1,NC(NY,NX)
      ARSTV(L,NZ,NY,NX)=0.0
8940  CONTINUE
C
C     ACCUMULATE PLANT STATE VARIABLES FROM BRANCH STATE VARIABLES
C
      DO 8950 NB=1,NBR(NZ,NY,NX)
      CPOOLP(NZ,NY,NX)=CPOOLP(NZ,NY,NX)+CPOOL(NB,NZ,NY,NX)
      ZPOOLP(NZ,NY,NX)=ZPOOLP(NZ,NY,NX)+ZPOOL(NB,NZ,NY,NX)
      PPOOLP(NZ,NY,NX)=PPOOLP(NZ,NY,NX)+PPOOL(NB,NZ,NY,NX)
      WTSHT(NZ,NY,NX)=WTSHT(NZ,NY,NX)+WTSHTB(NB,NZ,NY,NX)
      WTLF(NZ,NY,NX)=WTLF(NZ,NY,NX)+WTLFB(NB,NZ,NY,NX)
      WTSHE(NZ,NY,NX)=WTSHE(NZ,NY,NX)+WTSHEB(NB,NZ,NY,NX)
      WTSTK(NZ,NY,NX)=WTSTK(NZ,NY,NX)+WTSTKB(NB,NZ,NY,NX)
      WVSTK(NZ,NY,NX)=WVSTK(NZ,NY,NX)+WVSTKB(NB,NZ,NY,NX)
      WTRSV(NZ,NY,NX)=WTRSV(NZ,NY,NX)+WTRSVB(NB,NZ,NY,NX)
      WTHSK(NZ,NY,NX)=WTHSK(NZ,NY,NX)+WTHSKB(NB,NZ,NY,NX)
      WTEAR(NZ,NY,NX)=WTEAR(NZ,NY,NX)+WTEARB(NB,NZ,NY,NX)
      WTGR(NZ,NY,NX)=WTGR(NZ,NY,NX)+WTGRB(NB,NZ,NY,NX)
      WTLS(NZ,NY,NX)=WTLS(NZ,NY,NX)+WTLSB(NB,NZ,NY,NX)
      WTSHN(NZ,NY,NX)=WTSHN(NZ,NY,NX)+WTSHTN(NB,NZ,NY,NX)
      WTLFN(NZ,NY,NX)=WTLFN(NZ,NY,NX)+WTLFBN(NB,NZ,NY,NX)
      WTSHEN(NZ,NY,NX)=WTSHEN(NZ,NY,NX)+WTSHBN(NB,NZ,NY,NX)
      WTSTKN(NZ,NY,NX)=WTSTKN(NZ,NY,NX)+WTSTBN(NB,NZ,NY,NX)
      WTRSVN(NZ,NY,NX)=WTRSVN(NZ,NY,NX)+WTRSBN(NB,NZ,NY,NX)
      WTHSKN(NZ,NY,NX)=WTHSKN(NZ,NY,NX)+WTHSBN(NB,NZ,NY,NX)
      WTEARN(NZ,NY,NX)=WTEARN(NZ,NY,NX)+WTEABN(NB,NZ,NY,NX)
      WTGRNN(NZ,NY,NX)=WTGRNN(NZ,NY,NX)+WTGRBN(NB,NZ,NY,NX)
      WTSHP(NZ,NY,NX)=WTSHP(NZ,NY,NX)+WTSHTP(NB,NZ,NY,NX)
      WTLFP(NZ,NY,NX)=WTLFP(NZ,NY,NX)+WTLFBP(NB,NZ,NY,NX)
      WTSHEP(NZ,NY,NX)=WTSHEP(NZ,NY,NX)+WTSHBP(NB,NZ,NY,NX)
      WTSTKP(NZ,NY,NX)=WTSTKP(NZ,NY,NX)+WTSTBP(NB,NZ,NY,NX)
      WTRSVP(NZ,NY,NX)=WTRSVP(NZ,NY,NX)+WTRSBP(NB,NZ,NY,NX)
      WTHSKP(NZ,NY,NX)=WTHSKP(NZ,NY,NX)+WTHSBP(NB,NZ,NY,NX)
      WTEARP(NZ,NY,NX)=WTEARP(NZ,NY,NX)+WTEABP(NB,NZ,NY,NX)
      WTGRNP(NZ,NY,NX)=WTGRNP(NZ,NY,NX)+WTGRBP(NB,NZ,NY,NX)
      ARLFP(NZ,NY,NX)=ARLFP(NZ,NY,NX)+ARLFB(NB,NZ,NY,NX)
      GRNO(NZ,NY,NX)=GRNO(NZ,NY,NX)+GRNOB(NB,NZ,NY,NX)
      DO 8945 L=1,NC(NY,NX)
      ARSTP(NZ,NY,NX)=ARSTP(NZ,NY,NX)+ARSTK(L,NB,NZ,NY,NX)
      ARSTV(L,NZ,NY,NX)=ARSTV(L,NZ,NY,NX)+ARSTK(L,NB,NZ,NY,NX)
8945  CONTINUE
8950  CONTINUE
C
C     ACCUMULATE ROOT STATE VARIABLES FROM ROOT LAYER STATE VARIABLES
C
C     IF(WTLS(NZ,NY,NX).LE.0.0)ARLFP(NZ,NY,NX)=0.0
      DO 8925 N=1,MY(NZ,NY,NX)
      DO 8930 L=NU(NY,NX),NJ(NY,NX)
      WTRT(NZ,NY,NX)=WTRT(NZ,NY,NX)+CPOOLR(N,L,NZ,NY,NX)
      WTRTN(NZ,NY,NX)=WTRTN(NZ,NY,NX)+ZPOOLR(N,L,NZ,NY,NX)
      WTRTP(NZ,NY,NX)=WTRTP(NZ,NY,NX)+PPOOLR(N,L,NZ,NY,NX)
      DO 8935 NR=1,NRT(NZ,NY,NX)
      WTRT(NZ,NY,NX)=WTRT(NZ,NY,NX)+WTRT1(N,L,NR,NZ,NY,NX)
     2+WTRT2(N,L,NR,NZ,NY,NX)
      WTRTS(NZ,NY,NX)=WTRTS(NZ,NY,NX)+WTRT1(N,L,NR,NZ,NY,NX)
     2+WTRT2(N,L,NR,NZ,NY,NX)
      WTRTN(NZ,NY,NX)=WTRTN(NZ,NY,NX)+WTRT1N(N,L,NR,NZ,NY,NX)
     2+WTRT2N(N,L,NR,NZ,NY,NX)
      WTRTP(NZ,NY,NX)=WTRTP(NZ,NY,NX)+WTRT1P(N,L,NR,NZ,NY,NX)
     2+WTRT2P(N,L,NR,NZ,NY,NX)
8935  CONTINUE
8930  CONTINUE
8925  CONTINUE
C
C     ACCUMULATE NODULE STATE VATIABLES FROM NODULE LAYER VARIABLES
C
      IF(INTYP(NZ,NY,NX).NE.0)THEN
      WTND(NZ,NY,NX)=0.0
      WTNDN(NZ,NY,NX)=0.0
      WTNDP(NZ,NY,NX)=0.0
      IF(INTYP(NZ,NY,NX).GE.3)THEN
      DO 7950 NB=1,NBR(NZ,NY,NX)
      CPOLNP(NZ,NY,NX)=CPOLNP(NZ,NY,NX)+CPOLNB(NB,NZ,NY,NX)
      ZPOLNP(NZ,NY,NX)=ZPOLNP(NZ,NY,NX)+ZPOLNB(NB,NZ,NY,NX)
      PPOLNP(NZ,NY,NX)=PPOLNP(NZ,NY,NX)+PPOLNB(NB,NZ,NY,NX)
      WTND(NZ,NY,NX)=WTND(NZ,NY,NX)+WTNDB(NB,NZ,NY,NX)
     2+CPOLNB(NB,NZ,NY,NX) 
      WTNDN(NZ,NY,NX)=WTNDN(NZ,NY,NX)+WTNDBN(NB,NZ,NY,NX)
     2+ZPOLNB(NB,NZ,NY,NX)
      WTNDP(NZ,NY,NX)=WTNDP(NZ,NY,NX)+WTNDBP(NB,NZ,NY,NX)
     2+PPOLNB(NB,NZ,NY,NX)
7950  CONTINUE
      ELSEIF(INTYP(NZ,NY,NX).EQ.1.OR.INTYP(NZ,NY,NX).EQ.2)THEN 
      DO 8920 L=NU(NY,NX),NI(NZ,NY,NX)
      WTND(NZ,NY,NX)=WTND(NZ,NY,NX)+WTNDL(L,NZ,NY,NX)
     2+CPOOLN(L,NZ,NY,NX)
      WTNDN(NZ,NY,NX)=WTNDN(NZ,NY,NX)+WTNDLN(L,NZ,NY,NX)
     2+ZPOOLN(L,NZ,NY,NX)
      WTNDP(NZ,NY,NX)=WTNDP(NZ,NY,NX)+WTNDLP(L,NZ,NY,NX)
     2+PPOOLN(L,NZ,NY,NX)
8920  CONTINUE
      ENDIF
      ENDIF
C
C     ACCUMULATE TOTAL SOIL-PLANT C,N,P EXCHANGE
C
      HCUPTK(NZ,NY,NX)=UPOMC(NZ,NY,NX)
      HZUPTK(NZ,NY,NX)=UPOMN(NZ,NY,NX)+UPNH4(NZ,NY,NX)+UPNO3(NZ,NY,NX)
     2+UPNF(NZ,NY,NX)
      HPUPTK(NZ,NY,NX)=UPOMP(NZ,NY,NX)+UPH2P(NZ,NY,NX)
      TCUPTK(NZ,NY,NX)=TCUPTK(NZ,NY,NX)+UPOMC(NZ,NY,NX)
      TZUPTK(NZ,NY,NX)=TZUPTK(NZ,NY,NX)+UPOMN(NZ,NY,NX)+UPNH4(NZ,NY,NX)
     2+UPNO3(NZ,NY,NX)
      TPUPTK(NZ,NY,NX)=TPUPTK(NZ,NY,NX)+UPOMP(NZ,NY,NX)+UPH2P(NZ,NY,NX)
      TZUPFX(NZ,NY,NX)=TZUPFX(NZ,NY,NX)+UPNF(NZ,NY,NX)+UPNFC(NZ,NY,NX)
      ENDIF
C
C     HARVEST STANDING DEAD
C
      IF(IHVST(NZ,I,NY,NX).GE.0)THEN
      IF(J.EQ.INT(ZNOON(NY,NX)).AND.IHVST(NZ,I,NY,NX).NE.4
     2.AND.IHVST(NZ,I,NY,NX).NE.6)THEN
      IF(THIN(NZ,I,NY,NX).EQ.0.0)THEN
      FHVST=AMAX1(0.0,1.0-EHVST(1,4,NZ,I,NY,NX))
      FHVSH=FHVST
      ELSE
      FHVST=AMAX1(0.0,1.0-THIN(NZ,I,NY,NX))
      IF(IHVST(NZ,I,NY,NX).EQ.0)THEN
      FHVSH=AMAX1(0.0,1.0-EHVST(1,4,NZ,I,NY,NX)*THIN(NZ,I,NY,NX))
      ELSE
      FHVSH=FHVST
      ENDIF
      ENDIF
      ELSEIF(IHVST(NZ,I,NY,NX).EQ.4.OR.IHVST(NZ,I,NY,NX).EQ.6)THEN
      IF(WTSTG(NZ,NY,NX).GT.ZEROP(NZ,NY,NX))THEN
      WHVSTD=HVST(NZ,I,NY,NX)*THIN(NZ,I,NY,NX)*0.45/24.0
     2*AREA(3,NU(NY,NX),NY,NX)*EHVST(1,4,NZ,I,NY,NX)
      FHVST=AMAX1(0.0,1.0-WHVSTD/WTSTG(NZ,NY,NX))
      FHVSH=FHVST
      ELSE
      FHVST=1.0
      FHVSH=1.0
      ENDIF
      ELSE
      FHVST=1.0
      FHVSH=1.0
      ENDIF
      DO 6475 M=1,4
      WTHTH4=WTHTH4+(1.0-FHVSH)*WTSTDG(M,NZ,NY,NX)
      WTHNH4=WTHNH4+(1.0-FHVSH)*WTSTDN(M,NZ,NY,NX)
      WTHPH4=WTHPH4+(1.0-FHVSH)*WTSTDP(M,NZ,NY,NX)
      WTHTX4=WTHTX4+(FHVSH-FHVST)*WTSTDG(M,NZ,NY,NX)
      WTHNX4=WTHNX4+(FHVSH-FHVST)*WTSTDN(M,NZ,NY,NX)
      WTHPX4=WTHPX4+(FHVSH-FHVST)*WTSTDP(M,NZ,NY,NX)
      WTSTDG(M,NZ,NY,NX)=FHVST*WTSTDG(M,NZ,NY,NX)
      WTSTDN(M,NZ,NY,NX)=FHVST*WTSTDN(M,NZ,NY,NX)
      WTSTDP(M,NZ,NY,NX)=FHVST*WTSTDP(M,NZ,NY,NX)
6475  CONTINUE
C
C     IF NO PLANT C,N,P REMOVED AT HARVEST (ALL RESIDUE RETURNED)
C
      IF(IHVST(NZ,I,NY,NX).EQ.0)THEN
      WTHTR0=WTHTH0*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHNR0=WTHNH0*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHPR0=WTHPH0*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHTR1=WTHTH1*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHNR1=WTHNH1*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHPR1=WTHPH1*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHTR2=WTHTH2*(1.0-EHVST(2,2,NZ,I,NY,NX))
      WTHNR2=WTHNH2*(1.0-EHVST(2,2,NZ,I,NY,NX))
      WTHPR2=WTHPH2*(1.0-EHVST(2,2,NZ,I,NY,NX))
      WTHTR3=WTHTH3*(1.0-EHVST(2,3,NZ,I,NY,NX))
      WTHNR3=WTHNH3*(1.0-EHVST(2,3,NZ,I,NY,NX))
      WTHPR3=WTHPH3*(1.0-EHVST(2,3,NZ,I,NY,NX))
      WTHTR4=WTHTH4*(1.0-EHVST(2,4,NZ,I,NY,NX))
      WTHNR4=WTHNH4*(1.0-EHVST(2,4,NZ,I,NY,NX))
      WTHPR4=WTHPH4*(1.0-EHVST(2,4,NZ,I,NY,NX))
C
C     IF ONLY GRAIN C,N,P REMOVED AT HARVEST
C
      ELSEIF(IHVST(NZ,I,NY,NX).EQ.1)THEN
      WTHTR0=WTHTH0
      WTHNR0=WTHNH0
      WTHPR0=WTHPH0
      WTHTR1=WTHTH1
      WTHNR1=WTHNH1
      WTHPR1=WTHPH1
      WTHTR2=WTHTH2-WTHTG*EHVST(2,2,NZ,I,NY,NX)
      WTHNR2=WTHNH2-WTHNG*EHVST(2,2,NZ,I,NY,NX)
      WTHPR2=WTHPH2-WTHPG*EHVST(2,2,NZ,I,NY,NX)
      WTHTR3=WTHTH3
      WTHNR3=WTHNH3
      WTHPR3=WTHPH3
      WTHTR4=WTHTH4
      WTHNR4=WTHNH4
      WTHPR4=WTHPH4
C
C     IF ONLY WOOD C,N,P REMOVED AT HARVEST
C
      ELSEIF(IHVST(NZ,I,NY,NX).EQ.2)THEN
      WTHTR0=WTHTH0*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHNR0=WTHNH0*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHPR0=WTHPH0*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHTR1=WTHTH1*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHNR1=WTHNH1*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHPR1=WTHPH1*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHTR2=WTHTH2*(1.0-EHVST(2,2,NZ,I,NY,NX))
      WTHNR2=WTHNH2*(1.0-EHVST(2,2,NZ,I,NY,NX))
      WTHPR2=WTHPH2*(1.0-EHVST(2,2,NZ,I,NY,NX))
      WTHTR3=WTHTH3*(1.0-EHVST(2,3,NZ,I,NY,NX))
      WTHNR3=WTHNH3*(1.0-EHVST(2,3,NZ,I,NY,NX))
      WTHPR3=WTHPH3*(1.0-EHVST(2,3,NZ,I,NY,NX))
      WTHTR4=WTHTH4*(1.0-EHVST(2,4,NZ,I,NY,NX))
      WTHNR4=WTHNH4*(1.0-EHVST(2,4,NZ,I,NY,NX))
      WTHPR4=WTHPH4*(1.0-EHVST(2,4,NZ,I,NY,NX))
C
C     IF ALL PLANT C,N,P REMOVED AT HARVEST (NO RESIDUE RETURNED)
C
      ELSEIF(IHVST(NZ,I,NY,NX).EQ.3)THEN
      WTHTR0=WTHTH0*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHNR0=WTHNH0*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHPR0=WTHPH0*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHTR1=WTHTH1*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHNR1=WTHNH1*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHPR1=WTHPH1*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHTR2=WTHTH2*(1.0-EHVST(2,2,NZ,I,NY,NX))
      WTHNR2=WTHNH2*(1.0-EHVST(2,2,NZ,I,NY,NX))
      WTHPR2=WTHPH2*(1.0-EHVST(2,2,NZ,I,NY,NX))
      WTHTR3=WTHTH3*(1.0-EHVST(2,3,NZ,I,NY,NX))
      WTHNR3=WTHNH3*(1.0-EHVST(2,3,NZ,I,NY,NX))
      WTHPR3=WTHPH3*(1.0-EHVST(2,3,NZ,I,NY,NX))
      WTHTR4=WTHTH4*(1.0-EHVST(2,4,NZ,I,NY,NX))
      WTHNR4=WTHNH4*(1.0-EHVST(2,4,NZ,I,NY,NX))
      WTHPR4=WTHPH4*(1.0-EHVST(2,4,NZ,I,NY,NX))
C
C     IF PLANT C,N,P REMOVED BY GRAZING
C
      ELSEIF(IHVST(NZ,I,NY,NX).EQ.4.OR.IHVST(NZ,I,NY,NX).EQ.6)THEN
      WTHTR0=WTHTH0*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHNR0=WTHNH0*(1.0-EHVST(2,1,NZ,I,NY,NX)*0.5)
      WTHPR0=WTHPH0*(1.0-EHVST(2,1,NZ,I,NY,NX)*0.5)
      WTHTR1=WTHTH1*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHNR1=WTHNH1*(1.0-EHVST(2,1,NZ,I,NY,NX)*0.5)
      WTHPR1=WTHPH1*(1.0-EHVST(2,1,NZ,I,NY,NX)*0.5)
      WTHTR2=WTHTH2*(1.0-EHVST(2,2,NZ,I,NY,NX))
      WTHNR2=WTHNH2*(1.0-EHVST(2,2,NZ,I,NY,NX)*0.5)
      WTHPR2=WTHPH2*(1.0-EHVST(2,2,NZ,I,NY,NX)*0.5)
      WTHTR3=WTHTH3*(1.0-EHVST(2,3,NZ,I,NY,NX))
      WTHNR3=WTHNH3*(1.0-EHVST(2,3,NZ,I,NY,NX)*0.5)
      WTHPR3=WTHPH3*(1.0-EHVST(2,3,NZ,I,NY,NX)*0.5)
      WTHTR4=WTHTH4*(1.0-EHVST(2,4,NZ,I,NY,NX))
      WTHNR4=WTHNH4*(1.0-EHVST(2,4,NZ,I,NY,NX)*0.5)
      WTHPR4=WTHPH4*(1.0-EHVST(2,4,NZ,I,NY,NX)*0.5)
C
C     ADD MANURE FROM GRAZING NEXT DAY
C
      FERT(17,I+1,NY,NX)=FERT(17,I+1,NY,NX)
     2+(WTHTR1+WTHTR2+WTHTR3+WTHTR4)/AREA(3,NU(NY,NX),NY,NX)
      FERT(18,I+1,NY,NX)=FERT(18,I+1,NY,NX)
     2+(WTHNR1+WTHNR2+WTHNR3+WTHNR4)/AREA(3,NU(NY,NX),NY,NX)*0.5
      FERT(3,I+1,NY,NX)=FERT(3,I+1,NY,NX)
     2+(WTHNR1+WTHNR2+WTHNR3+WTHNR4)/AREA(3,NU(NY,NX),NY,NX)*0.5
      FERT(19,I+1,NY,NX)=FERT(19,I+1,NY,NX)
     2+(WTHPR1+WTHPR2+WTHPR3+WTHPR4)/AREA(3,NU(NY,NX),NY,NX)
      IYTYP(2,I+1,NY,NX)=3
C     IF(NX.EQ.2)THEN
C     WRITE(*,6542)'MANURE',I,J,NX,NY,NZ,FERT(2,I+1,NY,NX)
C    2,WTHNR1,WTHNR2,WTHNR3,WTHNR4,WTHNH1,WTHNH2,WTHNH3
C    3,WTHNH4
6542  FORMAT(A8,5I4,20E12.4)
C     ENDIF
C
C     FIRE
C
      ELSEIF(IHVST(NZ,I,NY,NX).EQ.5)THEN
      WTHTR0=WTHTH0*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHNR0=WTHNH0*(1.0-EFIRE(1,IHVST(NZ,I,NY,NX))
     2*EHVST(2,1,NZ,I,NY,NX))
      WTHPR0=WTHPH0*(1.0-EFIRE(2,IHVST(NZ,I,NY,NX))
     2*EHVST(2,1,NZ,I,NY,NX))
      WTHNL0=WTHNH0*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHPL0=WTHPH0*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHTR1=WTHTH1*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHNR1=WTHNH1*(1.0-EFIRE(1,IHVST(NZ,I,NY,NX))
     2*EHVST(2,1,NZ,I,NY,NX))
      WTHPR1=WTHPH1*(1.0-EFIRE(2,IHVST(NZ,I,NY,NX))
     2*EHVST(2,1,NZ,I,NY,NX))
      WTHNL1=WTHNH1*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHPL1=WTHPH1*(1.0-EHVST(2,1,NZ,I,NY,NX))
      WTHTR2=WTHTH2*(1.0-EHVST(2,2,NZ,I,NY,NX))
      WTHNR2=WTHNH2*(1.0-EFIRE(1,IHVST(NZ,I,NY,NX))
     2*EHVST(2,2,NZ,I,NY,NX))
      WTHPR2=WTHPH2*(1.0-EFIRE(2,IHVST(NZ,I,NY,NX))
     2*EHVST(2,2,NZ,I,NY,NX))
      WTHNL2=WTHNH2*(1.0-EHVST(2,2,NZ,I,NY,NX))
      WTHPL2=WTHPH2*(1.0-EHVST(2,2,NZ,I,NY,NX))
      WTHTR3=WTHTH3*(1.0-EHVST(2,3,NZ,I,NY,NX))
      WTHNR3=WTHNH3*(1.0-EFIRE(1,IHVST(NZ,I,NY,NX))
     2*EHVST(2,3,NZ,I,NY,NX))
      WTHPR3=WTHPH3*(1.0-EFIRE(2,IHVST(NZ,I,NY,NX))
     2*EHVST(2,3,NZ,I,NY,NX))
      WTHNL3=WTHNH3*(1.0-EHVST(2,3,NZ,I,NY,NX))
      WTHPL3=WTHPH3*(1.0-EHVST(2,3,NZ,I,NY,NX))
      WTHTR4=WTHTH4*(1.0-EHVST(2,4,NZ,I,NY,NX))
      WTHNR4=WTHNH4*(1.0-EFIRE(1,IHVST(NZ,I,NY,NX))
     2*EHVST(2,4,NZ,I,NY,NX))
      WTHPR4=WTHPH4*(1.0-EFIRE(2,IHVST(NZ,I,NY,NX))
     2*EHVST(2,4,NZ,I,NY,NX))
      WTHNL4=WTHNH4*(1.0-EHVST(2,4,NZ,I,NY,NX))
      WTHPL4=WTHPH4*(1.0-EHVST(2,4,NZ,I,NY,NX))
      ENDIF
C
C     C,N,P REMOVED FROM HARVESTING
C
      WTHTHT=WTHTH0+WTHTH1+WTHTH2+WTHTH3+WTHTH4
      WTHTRT=WTHTR0+WTHTR1+WTHTR2+WTHTR3+WTHTR4
      WTHNHT=WTHNH0+WTHNH1+WTHNH2+WTHNH3+WTHNH4
      WTHNRT=WTHNR0+WTHNR1+WTHNR2+WTHNR3+WTHNR4
      WTHPHT=WTHPH0+WTHPH1+WTHPH2+WTHPH3+WTHPH4
      WTHPRT=WTHPR0+WTHPR1+WTHPR2+WTHPR3+WTHPR4
      WTHTXT=WTHTX0+WTHTX1+WTHTX2+WTHTX3+WTHTX4
      WTHNXT=WTHNX0+WTHNX1+WTHNX2+WTHNX3+WTHNX4
      WTHPXT=WTHPX0+WTHPX1+WTHPX2+WTHPX3+WTHPX4
      IF(IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)THEN
      IF(IHVST(NZ,I,NY,NX).NE.5)THEN
      IF(JHVST(NZ,I,NY,NX).NE.2)THEN
      HVSTC(NZ,NY,NX)=HVSTC(NZ,NY,NX)+WTHTHT-WTHTRT 
      HVSTN(NZ,NY,NX)=HVSTN(NZ,NY,NX)+WTHNHT-WTHNRT 
      HVSTP(NZ,NY,NX)=HVSTP(NZ,NY,NX)+WTHPHT-WTHPRT 
      TNBP(NY,NX)=TNBP(NY,NX)+WTHTRT-WTHTHT
      XHVSTC(NY,NX)=XHVSTC(NY,NX)+WTHTHT-WTHTRT
      XHVSTN(NY,NX)=XHVSTN(NY,NX)+WTHNHT-WTHNRT
      XHVSTP(NY,NX)=XHVSTP(NY,NX)+WTHPHT-WTHPRT
      ELSE
      WTRVC(NZ,NY,NX)=WTRVC(NZ,NY,NX)+WTHTHT-WTHTRT
      WTRVN(NZ,NY,NX)=WTRVN(NZ,NY,NX)+WTHNHT-WTHNRT
      WTRVP(NZ,NY,NX)=WTRVP(NZ,NY,NX)+WTHPHT-WTHPRT
      ENDIF
C
C     C,N,P LOST AS GAS IF FIRE
C
      ELSE
      VCO2F(NZ,NY,NX)=VCO2F(NZ,NY,NX)-(1.0-FCH4F)*(WTHTHT-WTHTRT)
      VCH4F(NZ,NY,NX)=VCH4F(NZ,NY,NX)-FCH4F*(WTHTHT-WTHTRT)
      VOXYF(NZ,NY,NX)=VOXYF(NZ,NY,NX)-(1.0-FCH4F)*(WTHTHT-WTHTRT)*2.667 
      VNH3F(NZ,NY,NX)=VNH3F(NZ,NY,NX)-WTHNHT+WTHNRT
      VN2OF(NZ,NY,NX)=VN2OF(NZ,NY,NX)-0.0
      VPO4F(NZ,NY,NX)=VPO4F(NZ,NY,NX)-WTHPHT+WTHPRT
      CNET(NZ,NY,NX)=CNET(NZ,NY,NX)-(1.0-FCH4F)*(WTHTHT-WTHTRT)
      TNBP(NY,NX)=TNBP(NY,NX)-FCH4F*(WTHTHT-WTHTRT)
C     WRITE(*,5679)'FIRE2',I,J,NZ,VCO2F(NZ,NY,NX),FCH4F,WTHNH0,WTHNH1,WTHNH2
C    3,WTHNH3,WTHNH4,WTHNR0,WTHNR1,WTHNR2,WTHNR3,WTHNR4,WTHNHT,WTHNRT 
5679  FORMAT(A8,3I4,20E12.4)
      ENDIF
C
C     C,N,P REMOVED FROM GRAZING
C
      ELSE
      HVSTC(NZ,NY,NX)=HVSTC(NZ,NY,NX)+GY*(WTHTHT-WTHTRT)
      TCSNR(NZ,NY,NX)=TCSNR(NZ,NY,NX)-GZ*(WTHTHT-WTHTRT)
      TCO2A(NZ,NY,NX)=TCO2A(NZ,NY,NX)-GZ*(WTHTHT-WTHTRT)
      HVSTN(NZ,NY,NX)=HVSTN(NZ,NY,NX)+WTHNHT-WTHNRT
      HVSTP(NZ,NY,NX)=HVSTP(NZ,NY,NX)+WTHPHT-WTHPRT
      TNBP(NY,NX)=TNBP(NY,NX)+GY*(WTHTRT-WTHTHT)
      CNET(NZ,NY,NX)=CNET(NZ,NY,NX)+GZ*(WTHTRT-WTHTHT)
      XHVSTC(NY,NX)=XHVSTC(NY,NX)+GY*(WTHTHT-WTHTRT)
      XHVSTN(NY,NX)=XHVSTN(NY,NX)+WTHNHT-WTHNRT
      XHVSTP(NY,NX)=XHVSTP(NY,NX)+WTHPHT-WTHPRT
      RECO(NY,NX)=RECO(NY,NX)-GZ*(WTHTHT-WTHTRT)
      TRAU(NY,NX)=TRAU(NY,NX)-GZ*(WTHTHT-WTHTRT)
      ENDIF
C
C     ABOVE-GROUND LITTERFALL FROM HARVESTING
C
      IF(IHVST(NZ,I,NY,NX).NE.4.AND.IHVST(NZ,I,NY,NX).NE.6)THEN
      IF(IHVST(NZ,I,NY,NX).NE.5)THEN
      DO 6375 M=1,4
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+CFOPC(0,M,NZ,NY,NX)*(WTHTR0+WTHTX0)
     3+CFOPC(1,M,NZ,NY,NX)*(WTHTR1+WTHTX1)
     4+CFOPC(2,M,NZ,NY,NX)*(WTHTR2+WTHTX2)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+CFOPN(0,M,NZ,NY,NX)*(WTHNR0+WTHNX0)
     3+CFOPN(1,M,NZ,NY,NX)*(WTHNR1+WTHNX1)
     4+CFOPN(2,M,NZ,NY,NX)*(WTHNR2+WTHNX2)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)
     2+CFOPP(0,M,NZ,NY,NX)*(WTHPR0+WTHPX0)
     3+CFOPP(1,M,NZ,NY,NX)*(WTHPR1+WTHPX1)
     4+CFOPP(2,M,NZ,NY,NX)*(WTHPR2+WTHPX2)
      IF(IBTYP(NZ,NY,NX).EQ.0.OR.IGTYP(NZ,NY,NX).LE.1)THEN
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+CFOPC(3,M,NZ,NY,NX)*(WTHTR3+WTHTX3+WTHTR4+WTHTX4)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+CFOPN(3,M,NZ,NY,NX)*(WTHNR3+WTHNX3+WTHNR4+WTHNX4)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)
     2+CFOPP(3,M,NZ,NY,NX)*(WTHPR3+WTHPX3+WTHPR4+WTHPX4)
      ELSE
      WTSTDG(M,NZ,NY,NX)=WTSTDG(M,NZ,NY,NX)
     2+CFOPC(5,M,NZ,NY,NX)*(WTHTX3+WTHTX4)
      WTSTDN(M,NZ,NY,NX)=WTSTDN(M,NZ,NY,NX)
     2+CFOPN(5,M,NZ,NY,NX)*(WTHNX3+WTHNX4)
      WTSTDP(M,NZ,NY,NX)=WTSTDP(M,NZ,NY,NX)
     2+CFOPP(5,M,NZ,NY,NX)*(WTHPX3+WTHPX4)
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)
     2+FRC*CFOPC(5,M,NZ,NY,NX)*(WTHTR3+WTHTR4)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)
     2+FRC*CFOPN(5,M,NZ,NY,NX)*(WTHNR3+WTHNR4)
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)
     2+FRC*CFOPP(5,M,NZ,NY,NX)*(WTHPR3+WTHPR4)
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+FRF*CFOPC(5,M,NZ,NY,NX)*(WTHTR3+WTHTR4)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+FRF*CFOPN(5,M,NZ,NY,NX)*(WTHNR3+WTHNR4)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)
     2+FRF*CFOPP(5,M,NZ,NY,NX)*(WTHPR3+WTHPR4)
      ENDIF
6375  CONTINUE
C
C     ABOVE-GROUND LITTERFALL FROM FIRE
C
      ELSE
      DO 6485 M=1,4
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+CFOPC(0,M,NZ,NY,NX)*(WTHTR0+WTHTX0)
     3+CFOPC(1,M,NZ,NY,NX)*(WTHTR1+WTHTX1)
     4+CFOPC(2,M,NZ,NY,NX)*(WTHTR2+WTHTX2)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+CFOPN(0,M,NZ,NY,NX)*WTHNL0
     3+CFOPN(1,M,NZ,NY,NX)*WTHNL1
     4+CFOPN(2,M,NZ,NY,NX)*WTHNL2
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)
     2+CFOPP(0,M,NZ,NY,NX)*WTHPL0
     3+CFOPP(1,M,NZ,NY,NX)*WTHPL1
     4+CFOPP(2,M,NZ,NY,NX)*WTHPL2
      ZSNC(4,1,0,NZ,NY,NX)=ZSNC(4,1,0,NZ,NY,NX)
     2+CFOPN(0,M,NZ,NY,NX)*(WTHNR0+WTHNX0-WTHNL0)
     3+CFOPN(1,M,NZ,NY,NX)*(WTHNR1+WTHNX1-WTHNL1)
     4+CFOPN(2,M,NZ,NY,NX)*(WTHNR2+WTHNX2-WTHNL2)
      PSNC(4,1,0,NZ,NY,NX)=PSNC(4,1,0,NZ,NY,NX)
     2+CFOPP(0,M,NZ,NY,NX)*(WTHPR0+WTHPX0-WTHPL0)
     3+CFOPP(1,M,NZ,NY,NX)*(WTHPR1+WTHPX1-WTHPL1)
     4+CFOPP(2,M,NZ,NY,NX)*(WTHPR2+WTHPX2-WTHPL2)
      IF(IBTYP(NZ,NY,NX).EQ.0.OR.IGTYP(NZ,NY,NX).LE.1)THEN
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+CFOPC(3,M,NZ,NY,NX)*(WTHTR3+WTHTX3+WTHTR4+WTHTX4)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+CFOPN(3,M,NZ,NY,NX)*(WTHNL3+WTHNL4)
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)
     2+CFOPP(3,M,NZ,NY,NX)*(WTHPL3+WTHPL4)
      ZSNC(4,1,0,NZ,NY,NX)=ZSNC(4,1,0,NZ,NY,NX)
     2+CFOPN(3,M,NZ,NY,NX)*(WTHNR3+WTHNX3-WTHNL3+WTHNR4+WTHNX4-WTHNL4)
      PSNC(4,1,0,NZ,NY,NX)=PSNC(4,1,0,NZ,NY,NX)
     2+CFOPP(3,M,NZ,NY,NX)*(WTHPR3+WTHPX3-WTHPL3+WTHPR4+WTHPX4-WTHPL4)
      ELSE
      WTSTDG(M,NZ,NY,NX)=WTSTDG(M,NZ,NY,NX)
     2+CFOPC(5,M,NZ,NY,NX)*(WTHTR3+WTHTX3)
      WTSTDN(M,NZ,NY,NX)=WTSTDN(M,NZ,NY,NX)
     2+CFOPN(5,M,NZ,NY,NX)*WTHNL3
      WTSTDP(M,NZ,NY,NX)=WTSTDP(M,NZ,NY,NX)
     2+CFOPP(5,M,NZ,NY,NX)*WTHPL3
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)
     2+FRC*CFOPC(3,M,NZ,NY,NX)*(WTHTR4+WTHTX4)
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)
     2+FRC*CFOPN(3,M,NZ,NY,NX)*WTHNL4
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)
     2+FRC*CFOPP(3,M,NZ,NY,NX)*WTHPL4
      ZSNC(4,0,0,NZ,NY,NX)=ZSNC(4,0,0,NZ,NY,NX)
     2+FRC*CFOPN(5,M,NZ,NY,NX)*(WTHNR3+WTHNX3-WTHNL3
     3+WTHNR4+WTHNX4-WTHNL4)
      PSNC(4,0,0,NZ,NY,NX)=PSNC(4,0,0,NZ,NY,NX)
     2+FRC*CFOPP(5,M,NZ,NY,NX)*(WTHPR3+WTHPX3-WTHPL3
     3+WTHPR4+WTHPX4-WTHPL4)
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)
     2+FRF*CFOPC(3,M,NZ,NY,NX)*(WTHTR4+WTHTX4)
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)
     2+FRF*CFOPN(3,M,NZ,NY,NX)*WTHNL4
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)
     2+FRF*CFOPP(3,M,NZ,NY,NX)*WTHPL4
      ZSNC(4,1,0,NZ,NY,NX)=ZSNC(4,1,0,NZ,NY,NX)
     2+FRF*CFOPN(5,M,NZ,NY,NX)*(WTHNR3+WTHNX3-WTHNL3
     3+WTHNR4+WTHNX4-WTHNL4)
      PSNC(4,1,0,NZ,NY,NX)=PSNC(4,1,0,NZ,NY,NX)
     2+FRF*CFOPP(5,M,NZ,NY,NX)*(WTHPR3+WTHPX3-WTHPL3
     3+WTHPR4+WTHPX4-WTHPL4)
      ENDIF
6485  CONTINUE
      ENDIF
      ELSE
C
C     ABOVE-GROUND LITTERFALL FROM GRAZING
C
      TCSNC(NZ,NY,NX)=TCSNC(NZ,NY,NX)+WTHTRT+WTHTXT
      TZSNC(NZ,NY,NX)=TZSNC(NZ,NY,NX)+WTHNRT+WTHNXT 
      TPSNC(NZ,NY,NX)=TPSNC(NZ,NY,NX)+WTHPRT+WTHPXT
      TCSN0(NZ,NY,NX)=TCSN0(NZ,NY,NX)+WTHTRT+WTHTXT
      TZSN0(NZ,NY,NX)=TZSNC(NZ,NY,NX)+WTHNRT+WTHNXT 
      TPSN0(NZ,NY,NX)=TPSNC(NZ,NY,NX)+WTHPRT+WTHPXT
      ENDIF
      ZEROP(NZ,NY,NX)=ZERO*PP(NZ,NY,NX)
      ZEROQ(NZ,NY,NX)=ZERO*PP(NZ,NY,NX)/AREA(3,NU(NY,NX),NY,NX)
      ZEROL(NZ,NY,NX)=ZERO*PP(NZ,NY,NX)*1.0E+06
      ENDIF
9985  CONTINUE
C
C     TRANSFORMATIONS IN LIVING OR DEAD PLANT POPULATIONS
C
      DO 9975 NZ=1,NP0(NY,NX)
C
C     ACTIVATE DORMANT SEEDS
C
      DO 205 NB=1,NBR(NZ,NY,NX)
      IF(IFLGI(NZ,NY,NX).EQ.1)THEN
      IF(IFLGE(NB,NZ,NY,NX).EQ.0
     2.AND.VRNS(NB,NZ,NY,NX).GE.VRNL(NB,NZ,NY,NX))THEN
      IDAY0(NZ,NY,NX)=I
      IYR0(NZ,NY,NX)=IYRC
      SDPTHI(NZ,NY,NX)=0.005
      IFLGI(NZ,NY,NX)=0
      ENDIF
      ENDIF
205   CONTINUE
C
C     LITTERFALL FROM STANDING DEAD
C
      DO 6235 M=1,4
      XFRC=1.5814E-05*TFN3(NZ,NY,NX)*WTSTDG(M,NZ,NY,NX)
      XFRN=1.5814E-05*TFN3(NZ,NY,NX)*WTSTDN(M,NZ,NY,NX)
      XFRP=1.5814E-05*TFN3(NZ,NY,NX)*WTSTDP(M,NZ,NY,NX)
      IF(IBTYP(NZ,NY,NX).EQ.0.OR.IGTYP(NZ,NY,NX).LE.1)THEN
      CSNC(M,1,0,NZ,NY,NX)=CSNC(M,1,0,NZ,NY,NX)+XFRC
      ZSNC(M,1,0,NZ,NY,NX)=ZSNC(M,1,0,NZ,NY,NX)+XFRN
      PSNC(M,1,0,NZ,NY,NX)=PSNC(M,1,0,NZ,NY,NX)+XFRP
      ELSE
      CSNC(M,0,0,NZ,NY,NX)=CSNC(M,0,0,NZ,NY,NX)+XFRC
      ZSNC(M,0,0,NZ,NY,NX)=ZSNC(M,0,0,NZ,NY,NX)+XFRN
      PSNC(M,0,0,NZ,NY,NX)=PSNC(M,0,0,NZ,NY,NX)+XFRP
      ENDIF
      WTSTDG(M,NZ,NY,NX)=WTSTDG(M,NZ,NY,NX)-XFRC
      WTSTDN(M,NZ,NY,NX)=WTSTDN(M,NZ,NY,NX)-XFRN
      WTSTDP(M,NZ,NY,NX)=WTSTDP(M,NZ,NY,NX)-XFRP
6235  CONTINUE
C
C     ACCUMULATE TOTAL SURFACE, SUBSURFACE LITTERFALL
C
      DO 6430 M=1,4
      DO 6430 K=0,1
      TCSN0(NZ,NY,NX)=TCSN0(NZ,NY,NX)+CSNC(M,K,0,NZ,NY,NX)
      TZSN0(NZ,NY,NX)=TZSN0(NZ,NY,NX)+ZSNC(M,K,0,NZ,NY,NX)
      TPSN0(NZ,NY,NX)=TPSN0(NZ,NY,NX)+PSNC(M,K,0,NZ,NY,NX)
      DO 8955 L=0,NJ(NY,NX)
      HCSNC(NZ,NY,NX)=HCSNC(NZ,NY,NX)+CSNC(M,K,L,NZ,NY,NX)
      HZSNC(NZ,NY,NX)=HZSNC(NZ,NY,NX)+ZSNC(M,K,L,NZ,NY,NX)
      HPSNC(NZ,NY,NX)=HPSNC(NZ,NY,NX)+PSNC(M,K,L,NZ,NY,NX)
      TCSNC(NZ,NY,NX)=TCSNC(NZ,NY,NX)+CSNC(M,K,L,NZ,NY,NX)
      TZSNC(NZ,NY,NX)=TZSNC(NZ,NY,NX)+ZSNC(M,K,L,NZ,NY,NX)
      TPSNC(NZ,NY,NX)=TPSNC(NZ,NY,NX)+PSNC(M,K,L,NZ,NY,NX)
8955  CONTINUE
6430  CONTINUE
C
C     TOTAL STANDING DEAD
C
      WTSTG(NZ,NY,NX)=WTSTDG(1,NZ,NY,NX)+WTSTDG(2,NZ,NY,NX) 
     4+WTSTDG(3,NZ,NY,NX)+WTSTDG(4,NZ,NY,NX)
      WTSTGN(NZ,NY,NX)=WTSTDN(1,NZ,NY,NX)+WTSTDN(2,NZ,NY,NX) 
     4+WTSTDN(3,NZ,NY,NX)+WTSTDN(4,NZ,NY,NX)
      WTSTGP(NZ,NY,NX)=WTSTDP(1,NZ,NY,NX)+WTSTDP(2,NZ,NY,NX) 
     4+WTSTDP(3,NZ,NY,NX)+WTSTDP(4,NZ,NY,NX)
C
C     PLANT C BALANCE = TOTAL C STATE VARIABLES + TOTAL
C     AUTOTROPHIC RESPIRATION + TOTAL LITTERFALL - TOTAL EXUDATION
C     - TOTAL CO2 FIXATION
C
      ZNPP(NZ,NY,NX)=CARBN(NZ,NY,NX)+TCSNR(NZ,NY,NX)
      IF(IFLGC(NZ,NY,NX).EQ.1)THEN
      BALC(NZ,NY,NX)=WTSHT(NZ,NY,NX)+WTRT(NZ,NY,NX)+WTND(NZ,NY,NX)
     2+WTRVC(NZ,NY,NX)-ZNPP(NZ,NY,NX)+TCSNC(NZ,NY,NX)-TCUPTK(NZ,NY,NX)
     3-RSETC(NZ,NY,NX)+WTSTG(NZ,NY,NX)+THVSTC(NZ,NY,NX)
     4+HVSTC(NZ,NY,NX)-VCO2F(NZ,NY,NX)-VCH4F(NZ,NY,NX)
C     IF(NZ.EQ.1)THEN
C     WRITE(*,1111)'BALC',I,J,NX,NY,NZ,BALC(NZ,NY,NX),WTSHT(NZ,NY,NX)
C    2,WTRT(NZ,NY,NX),WTND(NZ,NY,NX),WTRVC(NZ,NY,NX),TCSNR(NZ,NY,NX)
C    3,TCSNC(NZ,NY,NX),TCUPTK(NZ,NY,NX),CARBN(NZ,NY,NX) 
C    2,RSETC(NZ,NY,NX),WTSTG(NZ,NY,NX),THVSTC(NZ,NY,NX)
C    3,HVSTC(NZ,NY,NX),CPOOLP(NZ,NY,NX) 
C    3,WTLF(NZ,NY,NX),WTSHE(NZ,NY,NX),WTSTK(NZ,NY,NX),WTRSV(NZ,NY,NX) 
C    3,WTHSK(NZ,NY,NX),WTEAR(NZ,NY,NX),WTGR(NZ,NY,NX) 
C    5,VCO2F(NZ,NY,NX),VCH4F(NZ,NY,NX) 
C    5,(WTLFB(NB,NZ,NY,NX),NB=1,5)
C    3,((CSNC(M,0,L,NZ,NY,NX),M=1,4),L=0,NL(NY,NX))
C    4,((CPOOLR(N,L,NZ,NY,NX),L=1,NL(NY,NX)),N=1,2)
C    4,(CPOOLK(NB,NZ,NY,NX),NB=1,10)
1111  FORMAT(A8,5I4,200F18.6)
C     ENDIF
C
C     PLANT N BALANCE = TOTAL N STATE VARIABLES + TOTAL N LITTERFALL
C     - TOTAL N UPTAKE FROM SOIL - TOTAL N ABSORPTION FROM ATMOSPHERE
C
      BALN(NZ,NY,NX)=WTSHN(NZ,NY,NX)+WTRTN(NZ,NY,NX)+WTNDN(NZ,NY,NX)
     2+WTRVN(NZ,NY,NX)+TZSNC(NZ,NY,NX)-TZUPTK(NZ,NY,NX)-TNH3C(NZ,NY,NX)
     3-RSETN(NZ,NY,NX)+WTSTGN(NZ,NY,NX)+HVSTN(NZ,NY,NX)+THVSTN(NZ,NY,NX)
     4-VNH3F(NZ,NY,NX)-VN2OF(NZ,NY,NX)-TZUPFX(NZ,NY,NX) 
C     IF(NZ.EQ.1)THEN
C     WRITE(*,1112)'BALN',I,J,NX,NY,NZ,BALN(NZ,NY,NX),WTSHN(NZ,NY,NX)
C    2,WTRTN(NZ,NY,NX),WTNDN(NZ,NY,NX),WTRVN(NZ,NY,NX),TZSNC(NZ,NY,NX)
C    3,TZUPTK(NZ,NY,NX),TNH3C(NZ,NY,NX),RSETN(NZ,NY,NX),HVSTN(NZ,NY,NX)
C    4,WTSTGN(NZ,NY,NX),WTLFN(NZ,NY,NX),WTSHEN(NZ,NY,NX)
C    5,WTSTKN(NZ,NY,NX),WTRSVN(NZ,NY,NX),WTHSKN(NZ,NY,NX)
C    3,WTEARN(NZ,NY,NX),WTGRNN(NZ,NY,NX),UPOMN(NZ,NY,NX),UPNH4(NZ,NY,NX)
C    2,UPNO3(NZ,NY,NX),VNH3F(NZ,NY,NX),VN2OF(NZ,NY,NX)
C    4,((RDFOMN(N,L,NZ,NY,NX),N=1,2),L=NU(NY,NX),NI(NZ,NY,NX))
C    4,((ZPOOLR(N,L,NZ,NY,NX),N=1,2),L=NU(NY,NX),NI(NZ,NY,NX))
1112  FORMAT(A8,5I4,200F18.6)
C     ENDIF
C
C     PLANT P BALANCE = TOTAL P STATE VARIABLES + TOTAL P LITTERFALL
C     - TOTAL P UPTAKE FROM SOIL
C
      BALP(NZ,NY,NX)=WTSHP(NZ,NY,NX)+WTRTP(NZ,NY,NX)+WTNDP(NZ,NY,NX)
     2+WTRVP(NZ,NY,NX)+TPSNC(NZ,NY,NX)-TPUPTK(NZ,NY,NX) 
     3-RSETP(NZ,NY,NX)+WTSTDP(1,NZ,NY,NX)+WTSTGP(NZ,NY,NX)
     4+HVSTP(NZ,NY,NX)+THVSTP(NZ,NY,NX)-VPO4F(NZ,NY,NX)
C     IF(NZ.EQ.4)THEN
C     WRITE(*,1112)'BALP',I,J,NX,NY,NZ,BALP(NZ,NY,NX),WTSHP(NZ,NY,NX)
C    2,WTRTP(NZ,NY,NX),WTNDP(NZ,NY,NX),WTRVP(NZ,NY,NX),TPSNC(NZ,NY,NX)
C    3,TPUPTK(NZ,NY,NX),RSETP(NZ,NY,NX)
C    4,WTSTDP(1,NZ,NY,NX),WTSTGP(NZ,NY,NX),HVSTP(NZ,NY,NX)
C    5,THVSTP(NZ,NY,NX),VPO4F(NZ,NY,NX)
C     ENDIF
      ENDIF
9975  CONTINUE
9990  CONTINUE
9995  CONTINUE
      RETURN
      END
