      SUBROUTINE trnsfr(I,J,NHW,NHE,NVN,NVS)
C
C     THIS SUBROUTINE CALCULATES 3-DIMENSIONAL FLUXES OF ALL SOIL
C     NON-SALT SOLUTES AND GASES
C
      include "parameters.h"
      include "blkc.h"
      include "blk2a.h"
      include "blk2b.h"
      include "blk2c.h"
      include "blk8a.h"
      include "blk8b.h"
      include "blk10.h"
      include "blk11a.h"
      include "blk11b.h"
      include "blk13a.h"
      include "blk13b.h"
      include "blk13c.h"
      include "blk15a.h"
      include "blk15b.h"
      include "blk18a.h"
      include "blk18b.h"
      include "blk19d.h"
      include "blk20d.h"
      include "blk20e.h"
      include "blk21a.h"
      include "blk21b.h"
      include "blk22a.h"
      include "blk22b.h"
      include "blk22c.h"
      DIMENSION CO2G2(JZ,JY,JX),CO2S2(0:JZ,JY,JX)
     2,CH4G2(JZ,JY,JX),CH4S2(0:JZ,JY,JX),OXYG2(JZ,JY,JX)
     3,OXYS2(0:JZ,JY,JX),Z2GG2(JZ,JY,JX),Z2GS2(0:JZ,JY,JX)
     4,Z2OG2(JZ,JY,JX),Z2OS2(0:JZ,JY,JX),ZN3G2(0:JZ,JY,JX)
     5,ZNH4S2(0:JZ,JY,JX),ZNH4B2(0:JZ,JY,JX),ZNH3S2(0:JZ,JY,JX)
     6,ZNH3B2(0:JZ,JY,JX),ZNO3S2(0:JZ,JY,JX),ZNO3B2(0:JZ,JY,JX)
     7,H2PO42(0:JZ,JY,JX),H2POB2(0:JZ,JY,JX),ZNO2S2(0:JZ,JY,JX)
     8,CGSGL2(JZ,JY,JX),CHSGL2(JZ,JY,JX),OGSGL2(JZ,JY,JX)
     9,ZGSGL2(JZ,JY,JX),Z2SGL2(JZ,JY,JX),ZHSGL2(JZ,JY,JX)
     7,OQC2(0:4,0:JZ,JY,JX),OQN2(0:4,0:JZ,JY,JX),OQP2(0:4,0:JZ,JY,JX)
     8,OQA2(0:4,0:JZ,JY,JX),OCSGL2(0:JZ,JY,JX),ONSGL2(0:JZ,JY,JX)
     9,OPSGL2(0:JZ,JY,JX),OASGL2(0:JZ,JY,JX),CHY0(0:JZ,JY,JX)
     1,CO2W2(JS,JY,JX),CH4W2(JS,JY,JX),OXYW2(JS,JY,JX),ZNGW2(JS,JY,JX)
     2,ZN2W2(JS,JY,JX),ZN4W2(JS,JY,JX),ZN3W2(JS,JY,JX),ZNOW2(JS,JY,JX)
     3,ZHPW2(JS,JY,JX),Z1PW2(JS,JY,JX)
     2,H1PO42(0:JZ,JY,JX),H1POB2(0:JZ,JY,JX)
      DIMENSION ROCSK2(0:4,0:JZ,JY,JX),RONSK2(0:4,0:JZ,JY,JX)
     2,ROPSK2(0:4,0:JZ,JY,JX),ROASK2(0:4,0:JZ,JY,JX)
     3,RCOSK2(0:JZ,JY,JX),ROXSK2(0:JZ,JY,JX),RCHSK2(0:JZ,JY,JX)
     4,RNGSK2(0:JZ,JY,JX),RN2SK2(0:JZ,JY,JX),RN4SK2(0:JZ,JY,JX)
     5,RN3SK2(0:JZ,JY,JX),RNOSK2(0:JZ,JY,JX),RHPSK2(0:JZ,JY,JX)
     6,R4BSK2(JZ,JY,JX),R3BSK2(JZ,JY,JX),RNBSK2(JZ,JY,JX)
     7,RHBSK2(JZ,JY,JX),RNXSK2(0:JZ,JY,JX),RNZSK2(JZ,JY,JX)
     8,RHGSK2(0:JZ,JY,JX),RNHSK2(0:JZ,JY,JX),R1PSK2(0:JZ,JY,JX)
      DIMENSION CLSGL2(0:JZ,JY,JX),CQSGL2(0:JZ,JY,JX),OLSGL2(0:JZ,JY,JX)
     2,ZNSGL2(0:JZ,JY,JX),ZLSGL2(0:JZ,JY,JX),ZVSGL2(0:JZ,JY,JX)
     3,HLSGL2(0:JZ,JY,JX),ZOSGL2(0:JZ,JY,JX),POSGL2(0:JZ,JY,JX)
     4,RCODFS(JY,JX),RCHDFS(JY,JX),ROXDFS(JY,JX),RNGDFS(JY,JX)
     5,RN2DFS(JY,JX),RN3DFS(JY,JX),RNBDFS(JY,JX),RHGDFS(JY,JX)
     6,RCODFR(JY,JX),RCHDFR(JY,JX),ROXDFR(JY,JX),RNGDFR(JY,JX)
     7,RN2DFR(JY,JX),RN3DFR(JY,JX),RHGDFR(JY,JX),R1BSK2(JZ,JY,JX)
     8,RQROC(0:4,2,2,JV,JH),RQRON(0:4,2,2,JV,JH),RQROP(0:4,2,2,JV,JH)
     9,RQROA(0:4,2,2,JV,JH),RQRCOS(2,2,JV,JH),RQRCHS(2,2,JV,JH)
     1,RQROXS(2,2,JV,JH),RQRNGS(2,2,JV,JH),RQRN2S(2,2,JV,JH)
     2,RQRHGS(2,2,JV,JH),RQRNH4(2,2,JV,JH),RQRNH3(2,2,JV,JH)
     3,RQRNO3(2,2,JV,JH),RQRNO2(2,2,JV,JH),RQRH2P(2,2,JV,JH)
     4,RQRH1P(2,2,JV,JH),FLWU(JZ,JY,JX)
     5,RQSCOS(2,JV,JH),RQSCHS(2,JV,JH),RQSOXS(2,JV,JH)
     6,RQSNGS(2,JV,JH),RQSN2S(2,JV,JH),RQSNH4(2,JV,JH)
     7,RQSNH3(2,JV,JH),RQSNO3(2,JV,JH),RQSH2P(2,JV,JH)
     8,RQSH1P(2,JV,JH)
      DIMENSION RCOFLS(3,0:JD,JV,JH),RCHFLS(3,0:JD,JV,JH)
     2,ROXFLS(3,0:JD,JV,JH),RNGFLS(3,0:JD,JV,JH),RN2FLS(3,0:JD,JV,JH)
     3,RHGFLS(3,0:JD,JV,JH),RN4FLW(3,0:JD,JV,JH),RN3FLW(3,0:JD,JV,JH)
     4,RNOFLW(3,0:JD,JV,JH),RNXFLS(3,0:JD,JV,JH),RH2PFS(3,0:JD,JV,JH)
     5,RN4FLB(3,0:JD,JV,JH),RN3FLB(3,0:JD,JV,JH),RNOFLB(3,0:JD,JV,JH)
     6,RNXFLB(3,0:JD,JV,JH),RH2BFB(3,0:JD,JV,JH),RCOFHS(3,JD,JV,JH)
     7,RCHFHS(3,JD,JV,JH),ROXFHS(3,JD,JV,JH),RNGFHS(3,JD,JV,JH)
     8,RN2FHS(3,JD,JV,JH),RN4FHW(3,JD,JV,JH),RN3FHW(3,JD,JV,JH)
     9,RNOFHW(3,JD,JV,JH),RH2PHS(3,JD,JV,JH),RN4FHB(3,JD,JV,JH)
     1,RN3FHB(3,JD,JV,JH),RNOFHB(3,JD,JV,JH),RH2BHB(3,JD,JV,JH)
     2,ROCFLS(0:4,3,0:JD,JV,JH),RONFLS(0:4,3,0:JD,JV,JH)
     3,ROPFLS(0:4,3,0:JD,JV,JH),ROAFLS(0:4,3,0:JD,JV,JH)
     4,ROCFHS(0:4,3,JD,JV,JH),RONFHS(0:4,3,JD,JV,JH)
     5,ROPFHS(0:4,3,JD,JV,JH),ROAFHS(0:4,3,JD,JV,JH)
     6,ROXFLG(3,JD,JV,JH),RN3FLG(3,JD,JV,JH),RCOFLG(3,JD,JV,JH)
     7,RCHFLG(3,JD,JV,JH),RNGFLG(3,JD,JV,JH),RN2FLG(3,JD,JV,JH)
     8,RNXFHS(3,JD,JV,JH),RNXFHB(3,JD,JV,JH),RH1PFS(3,0:JD,JV,JH)
     9,RH1BFB(3,0:JD,JV,JH),RH1PHS(3,JD,JV,JH),RH1BHB(3,JD,JV,JH)
      DIMENSION RCODFG(0:JZ,JY,JX),RCHDFG(0:JZ,JY,JX)
     1,ROXDFG(0:JZ,JY,JX),RNGDFG(0:JZ,JY,JX),RN2DFG(0:JZ,JY,JX)
     2,RN3DFG(0:JZ,JY,JX),RNBDFG(0:JZ,JY,JX),TQROC(0:4,JY,JX)
     3,TQRON(0:4,JY,JX),TQROP(0:4,JY,JX),TQROA(0:4,JY,JX)
     4,TQRCHS(JY,JX),TQROXS(JY,JX),TQRNGS(JY,JX),TQRN2S(JY,JX)
     5,TQRNH4(JY,JX),TQRNH3(JY,JX),TQRNO3(JY,JX),TQRH2P(JY,JX)
     7,TQRNO2(JY,JX),TQRHGS(JY,JX),TQSCOS(JY,JX),TQRCOS(JY,JX)
     4,TQSCHS(JY,JX),TQSOXS(JY,JX),TQSNGS(JY,JX),TQSN2S(JY,JX)
     5,TQSNH4(JY,JX),TQSNH3(JY,JX),TQSNO3(JY,JX),TQSH1P(JY,JX)
     8,TQSH2P(JY,JX),TOCFLS(0:4,JZ,JY,JX),TONFLS(0:4,JZ,JY,JX)
     8,TOPFLS(0:4,JZ,JY,JX),TOAFLS(0:4,JZ,JY,JX),TCOFLS(JZ,JY,JX)
     9,TCHFLS(JZ,JY,JX),TOXFLS(JZ,JY,JX),TNGFLS(JZ,JY,JX)
     1,TN2FLS(JZ,JY,JX),TN4FLW(JZ,JY,JX),TN3FLW(JZ,JY,JX)
     2,TNOFLW(JZ,JY,JX),TH2PFS(JZ,JY,JX),TN4FLB(JZ,JY,JX)
     3,TN3FLB(JZ,JY,JX),TNOFLB(JZ,JY,JX),TH2BFB(JZ,JY,JX)
     4,TNXFLS(JZ,JY,JX),TCOFLG(JZ,JY,JX),TCHFLG(JZ,JY,JX)
     5,TOXFLG(JZ,JY,JX),TNGFLG(JZ,JY,JX),TN2FLG(JZ,JY,JX)
     6,TQRH1P(JY,JX),TH1PFS(JZ,JY,JX),TH1BFB(JZ,JY,JX)
      DIMENSION TN3FLG(JZ,JY,JX),RCOBBL(JZ,JY,JX)
     4,RCHBBL(JZ,JY,JX),ROXBBL(JZ,JY,JX),RNGBBL(JZ,JY,JX)
     5,RN2BBL(JZ,JY,JX),RN3BBL(JZ,JY,JX),RNBBBL(JZ,JY,JX)
     6,RHGBBL(JZ,JY,JX)
      DIMENSION CO2SH2(JZ,JY,JX),CH4SH2(JZ,JY,JX),OXYSH2(JZ,JY,JX)
     2,Z2GSH2(JZ,JY,JX),Z2OSH2(JZ,JY,JX),ZNH4H2(JZ,JY,JX)
     3,ZN4BH2(JZ,JY,JX),ZNH3H2(JZ,JY,JX),ZN3BH2(JZ,JY,JX)
     4,ZNO3H2(JZ,JY,JX),ZNOBH2(JZ,JY,JX),H2P4H2(JZ,JY,JX)
     5,H2PBH2(JZ,JY,JX),ZNO2H2(JZ,JY,JX),OQCH2(0:4,JZ,JY,JX)
     6,OQNH2(0:4,JZ,JY,JX),OQPH2(0:4,JZ,JY,JX),OQAH2(0:4,JZ,JY,JX)
     7,TOCFHS(0:4,JZ,JY,JX),TONFHS(0:4,JZ,JY,JX),TOPFHS(0:4,JZ,JY,JX)
     8,TOAFHS(0:4,JZ,JY,JX),TCOFHS(JZ,JY,JX),TCHFHS(JZ,JY,JX)
     9,TOXFHS(JZ,JY,JX),TNGFHS(JZ,JY,JX),TN2FHS(JZ,JY,JX)
     1,TN4FHW(JZ,JY,JX),TN3FHW(JZ,JY,JX),TNOFHW(JZ,JY,JX)
     2,TH2PHS(JZ,JY,JX),TN4FHB(JZ,JY,JX),TN3FHB(JZ,JY,JX)
     3,TNOFHB(JZ,JY,JX),TH2BHB(JZ,JY,JX),TNXFHS(JZ,JY,JX)
     4,ZNO2B2(JZ,JY,JX),ZN2BH2(JZ,JY,JX),TNXFLB(JZ,JY,JX)
     5,TNXFHB(JZ,JY,JX),H1P4H2(JZ,JY,JX),H1PBH2(JZ,JY,JX)
     6,TH1PHS(JZ,JY,JX),TH1BHB(JZ,JY,JX)
      DIMENSION RCOFLZ(JZ,JY,JX),RCHFLZ(JZ,JY,JX)
     1,ROXFLZ(JZ,JY,JX),RNGFLZ(JZ,JY,JX)
     2,RN2FLZ(JZ,JY,JX),RN4FLZ(JZ,JY,JX),RN3FLZ(JZ,JY,JX)
     3,RNOFLZ(JZ,JY,JX),RH2PFZ(JZ,JY,JX),RN4FBZ(JZ,JY,JX)
     4,RN3FBZ(JZ,JY,JX),RNOFBZ(JZ,JY,JX),RH2BBZ(JZ,JY,JX)
     5,RH1PFZ(JZ,JY,JX),RH1BBZ(JZ,JY,JX)
      DIMENSION ROCFXS(0:4,JZ,JY,JX),RONFXS(0:4,JZ,JY,JX)
     1,ROPFXS(0:4,JZ,JY,JX),ROAFXS(0:4,JZ,JY,JX),RCOFXS(JZ,JY,JX)
     2,RCHFXS(JZ,JY,JX),ROXFXS(JZ,JY,JX)
     3,RNGFXS(JZ,JY,JX),RN2FXS(JZ,JY,JX),RN4FXW(JZ,JY,JX)
     4,RN3FXW(JZ,JY,JX),RNOFXW(JZ,JY,JX),RH2PXS(JZ,JY,JX)
     5,RN4FXB(JZ,JY,JX),RN3FXB(JZ,JY,JX),RNOFXB(JZ,JY,JX)
     6,RH2BXB(JZ,JY,JX),RNXFXS(JZ,JY,JX),RNXFXB(JZ,JY,JX)
     7,RH1PXS(JZ,JY,JX),RH1BXB(JZ,JY,JX)
      DIMENSION RCOBLS(JS,JY,JX),RCHBLS(JS,JY,JX)
     2,ROXBLS(JS,JY,JX),RNGBLS(JS,JY,JX),RN2BLS(JS,JY,JX)
     3,RN4BLW(JS,JY,JX),RN3BLW(JS,JY,JX),RNOBLW(JS,JY,JX)
     4,RH1PBS(JS,JY,JX),RH2PBS(JS,JY,JX),TCOBLS(JS,JY,JX)
     5,TCHBLS(JS,JY,JX),TOXBLS(JS,JY,JX),TNGBLS(JS,JY,JX)
     6,TN2BLS(JS,JY,JX),TN4BLW(JS,JY,JX),TN3BLW(JS,JY,JX)
     7,TNOBLW(JS,JY,JX),TH1PBS(JS,JY,JX),TH2PBS(JS,JY,JX)
      DIMENSION RFLOC(0:4),RFLON(0:4),RFLOP(0:4),RFLOA(0:4)
     2,RFHOC(0:4),RFHON(0:4),RFHOP(0:4),RFHOA(0:4) ,COQC1(0:4)
     3,COQC2(0:4),COQN1(0:4),COQN2(0:4),COQP1(0:4),COQP2(0:4)
     4,COQA1(0:4),COQA2(0:4),COQCH1(0:4),COQCH2(0:4)
     3,COQNH1(0:4),COQNH2(0:4),COQPH1(0:4),COQPH2(0:4)
     4,COQAH1(0:4),COQAH2(0:4),DFVOC(0:4),DFVON(0:4),DFVOP(0:4)
     5,DFVOA(0:4),DFHOC(0:4),DFHON(0:4),DFHOP(0:4),DFHOA(0:4)
      DIMENSION THETW1(JZ,JY,JX)
     2,DCO2G(3,JZ,JY,JX),DCH4G(3,JZ,JY,JX)
     3,DOXYG(3,JZ,JY,JX),DZ2GG(3,JZ,JY,JX),DZ2OG(3,JZ,JY,JX)
     4,DNH3G(3,JZ,JY,JX),VOLWCO(0:JZ,JY,JX),VOLWCH(0:JZ,JY,JX)
     5,VOLWOX(0:JZ,JY,JX),VOLWNG(0:JZ,JY,JX),VOLWN2(0:JZ,JY,JX)
     6,VOLWN3(0:JZ,JY,JX),VOLWNB(0:JZ,JY,JX),VOLWHG(0:JZ,JY,JX)
     7,H2GG2(JZ,JY,JX),H2GS2(0:JZ,JY,JX),H2GSH2(JZ,JY,JX)
     8,HGSGL2(JZ,JY,JX),DH2GG(3,JZ,JY,JX),RHGFXS(JZ,JY,JX)
     2,RHGFLZ(JZ,JY,JX),RHGFLG(3,JD,JV,JH),THGFLS(JZ,JY,JX)
     3,THGFHS(JZ,JY,JX),RHGDFG(0:JZ,JY,JX),FLQM(3,JD,JV,JH)
     4,RHGFHS(3,JD,JV,JH),THGFLG(JZ,JY,JX),FLVM(JZ,JY,JX)
     5,THETH2(JZ,JY,JX),THETHL(JZ,JY,JX),VOLPMA(JZ,JY,JX)
     6,VOLPMB(JZ,JY,JX),VOLWMA(JZ,JY,JX),VOLWMB(JZ,JY,JX)
     7,VOLWXA(0:JZ,JY,JX),VOLWXB(JZ,JY,JX),PARGCO(JY,JX)
     8,PARGCH(JY,JX),PARGOX(JY,JX),PARGNG(JY,JX)
     9,PARGN2(JY,JX),PARGN3(JY,JX),PARGH2(JY,JX)
      DIMENSION ROCFL0(0:2,JY,JX),RONFL0(0:2,JY,JX),ROPFL0(0:2,JY,JX)
     2,ROAFL0(0:2,JY,JX),ROCFL1(0:2,JY,JX),RONFL1(0:2,JY,JX)
     3,ROPFL1(0:2,JY,JX),ROAFL1(0:2,JY,JX),RCOFL0(JY,JX),RCHFL0(JY,JX)
     4,ROXFL0(JY,JX),RNGFL0(JY,JX),RN2FL0(JY,JX),RHGFL0(JY,JX)
     5,RN4FL0(JY,JX),RN3FL0(JY,JX),RNOFL0(JY,JX),RNXFL0(JY,JX)
     6,RH2PF0(JY,JX),RCOFL1(JY,JX),RCHFL1(JY,JX),ROXFL1(JY,JX)
     7,RNGFL1(JY,JX),RN2FL1(JY,JX),RHGFL1(JY,JX),RN4FL1(JY,JX)
     8,RN3FL1(JY,JX),RNOFL1(JY,JX),RNXFL1(JY,JX),RH2PF1(JY,JX)
     9,RN4FL2(JY,JX),RN3FL2(JY,JX),RNOFL2(JY,JX),RNXFL2(JY,JX)
     1,RH2BF2(JY,JX),RH1PF0(JY,JX),RH1PF1(JY,JX),RH1BF2(JY,JX)
      DIMENSION VOLCOR(JY,JX),VOLCHR(JY,JX),VOLOXR(JY,JX),VOLNGR(JY,JX)
     2,VOLN2R(JY,JX),VOLN3R(JY,JX),VOLHGR(JY,JX),VOLCOT(JY,JX)
     3,VOLCHT(JY,JX),VOLOXT(JY,JX),VOLNGT(JY,JX),VOLN2T(JY,JX)
     4,VOLN3T(JY,JX),VOLNBT(JY,JX),VOLHGT(JY,JX)
     5,RQROC0(0:4,JV,JH),RQRON0(0:4,JV,JH),RQROP0(0:4,JV,JH)
     6,RQROA0(0:4,JV,JH),RQRCOS0(JV,JH),RQRCHS0(JV,JH)
     1,RQROXS0(JV,JH),RQRNGS0(JV,JH),RQRN2S0(JV,JH)
     2,RQRHGS0(JV,JH),RQRNH40(JV,JH),RQRNH30(JV,JH)
     3,RQRNO30(JV,JH),RQRNO20(JV,JH),RQRH2P0(JV,JH)
     4,RQRH1P0(JV,JH)
      PARAMETER(DPN4=5.7E-07,VFLWX=0.5,XFRS=0.05)
      REAL*4 CCO2SQ,CCH4SQ,COXYSQ,CZ2GSQ,CZ2OSQ,CNH3SQ
     2,CNH3BQ,CH2GSQ
C
C     TIME STEPS FOR SOLUTE AND GAS FLUX CALCULATIONS
C
      DO 9995 NX=NHW,NHE
      DO 9990 NY=NVN,NVS
C
C     GAS AND SOLUTE SINKS AND SOURCES IN SURFACE RESIDUE FROM MICROBIAL
C     TRANSFORMATIONS IN 'NITRO' + ROOT EXCHANGE IN 'EXTRACT'
C     + EQUILIBRIA REACTIONS IN 'SOLUTE' AT SUB-HOURLY TIME STEP
C
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C
C     XNPG=1/number of cycles h-1 for gas flux calculations
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C     R*SK2=total sink from nitro.f, uptake.f, solute.f
C     RCO2O=net soil CO2 uptake from nitro.f
C     RCH4O=net soil CH4 uptake from nitro.f
C     RN2G=total soil N2 production from nitro.f
C     XN2GS=total N2 fixation from nitro.f
C     RN2O=net soil N2O uptake from nitro.f
C     RH2GO=net H2 uptake from nitro.f
C     XOQCS,XOQNZ,XOQPS,XOQAS=net change in DOC,DON,DOP,acetate from nitro.f
C     XNH4S=net change in NH4 from nitro.f
C     TRN4S,TRN3S=NH4,NH3 dissolution from solute.f
C     XNO3S=net change in NO3 from nitro.f
C     TRNO3=NO3 dissolution from solute.f
C     XNO2S=net change in NO2 from nitro.f
C     TRNO2=NO2 dissolution from solute.f
C     XH2PS=net change in H2PO4 from nitro.f
C     TRH2P=H2PO4 dissolution from solute.f
C     XH1PS=net change in HPO4 from nitro.f
C     TRH1P=HPO4 dissolution from solute.f
C
      RCOSK2(0,NY,NX)=RCO2O(0,NY,NX)*XNPG
      RCHSK2(0,NY,NX)=RCH4O(0,NY,NX)*XNPG
      RNGSK2(0,NY,NX)=(RN2G(0,NY,NX)+XN2GS(0,NY,NX))*XNPG
      RN2SK2(0,NY,NX)=RN2O(0,NY,NX)*XNPG
      RNHSK2(0,NY,NX)=0.0
      RHGSK2(0,NY,NX)=RH2GO(0,NY,NX)*XNPG
      DO 14 K=0,4
      ROCSK2(K,0,NY,NX)=-XOQCS(K,0,NY,NX)*XNPH
      RONSK2(K,0,NY,NX)=-XOQNS(K,0,NY,NX)*XNPH
      ROPSK2(K,0,NY,NX)=-XOQPS(K,0,NY,NX)*XNPH
      ROASK2(K,0,NY,NX)=-XOQAS(K,0,NY,NX)*XNPH
14    CONTINUE
      RN4SK2(0,NY,NX)=(-XNH4S(0,NY,NX)-TRN4S(0,NY,NX))*XNPH
      RN3SK2(0,NY,NX)=-TRN3S(0,NY,NX)*XNPH
      RNOSK2(0,NY,NX)=(-XNO3S(0,NY,NX)-TRNO3(0,NY,NX))*XNPH
      RNXSK2(0,NY,NX)=(-XNO2S(0,NY,NX)-TRNO2(0,NY,NX))*XNPH
      RHPSK2(0,NY,NX)=(-XH2PS(0,NY,NX)-TRH2P(0,NY,NX))*XNPH
      R1PSK2(0,NY,NX)=(-XH1PS(0,NY,NX)-TRH1P(0,NY,NX))*XNPH
C
C     INITIALIZE STATE VARIABLES FOR USE IN GAS, SOLUTE FLUX CALCULATIONS
C
C     CO2S,CH4S,OXYS,Z2GS,Z2OS,H2GS=aqueous CO2,CH4,O2,N2,N2O,H2 content
C     OQC,OQN,OQP,OQA=DOC,DON,DOP,acetate
C     XOQCS,XOQNZ,XOQPS,XOQAS=net change in DOC,DON,DOP,acetate from nitro.f
C     ZNH4S,ZNH3S,ZNO3S,ZNO2S,H1PO4,H2PO4=aqueous NH4,NH3,NO3,NO2,HPO4,H2PO4
C     CHY0=H concentration
C     PH=pH
C
      CO2S2(0,NY,NX)=CO2S(0,NY,NX)
      CH4S2(0,NY,NX)=CH4S(0,NY,NX)
      OXYS2(0,NY,NX)=OXYS(0,NY,NX)
      Z2GS2(0,NY,NX)=Z2GS(0,NY,NX)
      Z2OS2(0,NY,NX)=Z2OS(0,NY,NX)
      H2GS2(0,NY,NX)=H2GS(0,NY,NX)
      DO 9979 K=0,4
      OQC2(K,0,NY,NX)=OQC(K,0,NY,NX)-XOQCS(K,0,NY,NX)
      OQN2(K,0,NY,NX)=OQN(K,0,NY,NX)-XOQNS(K,0,NY,NX)
      OQP2(K,0,NY,NX)=OQP(K,0,NY,NX)-XOQPS(K,0,NY,NX)
      OQA2(K,0,NY,NX)=OQA(K,0,NY,NX)-XOQAS(K,0,NY,NX)
9979  CONTINUE
      ZNH4S2(0,NY,NX)=ZNH4S(0,NY,NX)
      ZNH3S2(0,NY,NX)=ZNH3S(0,NY,NX)
      ZNO3S2(0,NY,NX)=ZNO3S(0,NY,NX)
      ZNO2S2(0,NY,NX)=ZNO2S(0,NY,NX)
      H1PO42(0,NY,NX)=H1PO4(0,NY,NX)
      H2PO42(0,NY,NX)=H2PO4(0,NY,NX)
      CHY0(0,NY,NX)=10.0**(-(PH(0,NY,NX)-3.0))
C
C     INITIALIZE SURFACE SOLUTE FLUXES FROM ATMOSPHERE
C
C     X*FLS,X*FHS=hourly solute flux in macropores,micropores
C
      DO 8855 K=0,4
      IF(K.LE.2)THEN
      XOCFLS(K,3,0,NY,NX)=0.0
      XONFLS(K,3,0,NY,NX)=0.0
      XOPFLS(K,3,0,NY,NX)=0.0
      XOAFLS(K,3,0,NY,NX)=0.0
      ENDIF
      XOCFLS(K,3,NU(NY,NX),NY,NX)=0.0
      XONFLS(K,3,NU(NY,NX),NY,NX)=0.0
      XOPFLS(K,3,NU(NY,NX),NY,NX)=0.0
      XOAFLS(K,3,NU(NY,NX),NY,NX)=0.0
      XOCFHS(K,3,NU(NY,NX),NY,NX)=0.0
      XONFHS(K,3,NU(NY,NX),NY,NX)=0.0
      XOPFHS(K,3,NU(NY,NX),NY,NX)=0.0
      XOAFHS(K,3,NU(NY,NX),NY,NX)=0.0
8855  CONTINUE
C
C     HOURLY SOLUTE FLUXES FROM ATMOSPHERE TO SNOWPACK
C     IN SNOWFALL AND IRRIGATION ACCORDING TO CONCENTRATIONS
C     ENTERED IN WEATHER AND IRRIGATION FILES
C
C     PRECW,PRECR=snow,rain
C     VHCPWM,VHCPWX=current,minimum volumetric heat capacity of snowpack
C     X*BLS=hourly solute flux to snowpack
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     FLQGQ,FLQGI=water flux to snowpack from rain,irrigation
C     C*R,C*Q=precipitation,irrigation solute concentrations
C     gas code: *CO*=CO2,*OX*=O2,*CH*=CH4,*NG*=N2,*N2*=N2O,*NH*=NH3,*H2*=H2
C
      IF(PRECW(NY,NX).GT.0.0.OR.(PRECR(NY,NX).GT.0.0
     2.AND.VHCPWM(1,1,NY,NX).GT.VHCPWX(NY,NX)))THEN
      XCOBLS(1,NY,NX)=FLQGQ(NY,NX)*CCOR(NY,NX)
     2+FLQGI(NY,NX)*CCOQ(NY,NX)
      XCHBLS(1,NY,NX)=FLQGQ(NY,NX)*CCHR(NY,NX)
     2+FLQGI(NY,NX)*CCHQ(NY,NX)
      XOXBLS(1,NY,NX)=FLQGQ(NY,NX)*COXR(NY,NX)
     2+FLQGI(NY,NX)*COXQ(NY,NX)
      XNGBLS(1,NY,NX)=FLQGQ(NY,NX)*CNNR(NY,NX)
     2+FLQGI(NY,NX)*CNNQ(NY,NX)
      XN2BLS(1,NY,NX)=FLQGQ(NY,NX)*CN2R(NY,NX)
     2+FLQGI(NY,NX)*CN2Q(NY,NX)
      XN4BLW(1,NY,NX)=(FLQGQ(NY,NX)*CN4R(NY,NX)+FLQGI(NY,NX)
     2*CN4Q(I,NY,NX))*14.0
      XN3BLW(1,NY,NX)=(FLQGQ(NY,NX)*CN3R(NY,NX)+FLQGI(NY,NX)
     2*CN3Q(I,NY,NX))*14.0
      XNOBLW(1,NY,NX)=(FLQGQ(NY,NX)*CNOR(NY,NX)+FLQGI(NY,NX)
     2*CNOQ(I,NY,NX))*14.0
      XH1PBS(1,NY,NX)=(FLQGQ(NY,NX)*CH1PR(NY,NX)+FLQGI(NY,NX)
     2*CH1PQ(I,NY,NX))*31.0
      XH2PBS(1,NY,NX)=(FLQGQ(NY,NX)*CPOR(NY,NX)+FLQGI(NY,NX)
     2*CPOQ(I,NY,NX))*31.0
C
C     HOURLY SOLUTE FLUXES FROM ATMOSPHERE TO SOIL SURFACE
C     IF RAINFALL AND IRRIGATION IS ZERO IF SNOWPACK IS PRESENT
C
C     X*FLS,X*FLB=hourly solute flux to micropores in non-band,band
C
      XCOFLS(3,0,NY,NX)=0.0
      XCHFLS(3,0,NY,NX)=0.0
      XOXFLS(3,0,NY,NX)=0.0
      XNGFLS(3,0,NY,NX)=0.0
      XN2FLS(3,0,NY,NX)=0.0
      XHGFLS(3,0,NY,NX)=0.0
      XN4FLW(3,0,NY,NX)=0.0
      XN3FLW(3,0,NY,NX)=0.0
      XNOFLW(3,0,NY,NX)=0.0
      XNXFLS(3,0,NY,NX)=0.0
      XH1PFS(3,0,NY,NX)=0.0
      XH2PFS(3,0,NY,NX)=0.0
      XCOFLS(3,NU(NY,NX),NY,NX)=0.0
      XCHFLS(3,NU(NY,NX),NY,NX)=0.0
      XOXFLS(3,NU(NY,NX),NY,NX)=0.0
      XNGFLS(3,NU(NY,NX),NY,NX)=0.0
      XN2FLS(3,NU(NY,NX),NY,NX)=0.0
      XHGFLS(3,NU(NY,NX),NY,NX)=0.0
      XN4FLW(3,NU(NY,NX),NY,NX)=0.0
      XN3FLW(3,NU(NY,NX),NY,NX)=0.0
      XNOFLW(3,NU(NY,NX),NY,NX)=0.0
      XNXFLS(3,NU(NY,NX),NY,NX)=0.0
      XH1PFS(3,NU(NY,NX),NY,NX)=0.0
      XH2PFS(3,NU(NY,NX),NY,NX)=0.0
      XN4FLB(3,NU(NY,NX),NY,NX)=0.0
      XN3FLB(3,NU(NY,NX),NY,NX)=0.0
      XNOFLB(3,NU(NY,NX),NY,NX)=0.0
      XNXFLB(3,NU(NY,NX),NY,NX)=0.0
      XH1BFB(3,NU(NY,NX),NY,NX)=0.0
      XH2BFB(3,NU(NY,NX),NY,NX)=0.0
C
C     HOURLY SOLUTE FLUXES FROM ATMOSPHERE TO SOIL SURFACE
C     IN RAINFALL AND IRRIGATION ACCORDING TO CONCENTRATIONS
C     ENTERED IN WEATHER AND IRRIGATION FILES
C
      ELSEIF((PRECQ(NY,NX).GT.0.0.OR.PRECI(NY,NX).GT.0.0)
     2.AND.VHCPWM(1,1,NY,NX).LE.VHCPWX(NY,NX))THEN
C
C     HOURLY SOLUTE FLUXES FROM ATMOSPHERE TO SNOWPACK
C     IF SNOWFALL AND IRRIGATION IS ZERO AND SNOWPACK IS ABSENT
C
C     PRECQ,PRECI=snow+rain,irrigation
C     X*BLS=hourly solute flux to snowpack
C     X*FLS,X*FLB=hourly solute flux to surface litter,soil surface micropore non-band,band
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     FLQRQ,FLQRI=water flux to surface litter from rain,irrigation
C     FLQGQ,FLQGI=water flux to soil surface from rain,irrigation
C     C*R,C*Q=precipitation,irrigation solute concentrations
C     gas code: *CO*=CO2,*OX*=O2,*CH*=CH4,*NG*=N2,*N2*=N2O,*NH*=NH3,*H2*=H2
C
      XCOBLS(1,NY,NX)=0.0
      XCHBLS(1,NY,NX)=0.0
      XOXBLS(1,NY,NX)=0.0
      XNGBLS(1,NY,NX)=0.0
      XN2BLS(1,NY,NX)=0.0
      XN4BLW(1,NY,NX)=0.0
      XN3BLW(1,NY,NX)=0.0
      XNOBLW(1,NY,NX)=0.0
      XH1PBS(1,NY,NX)=0.0
      XH2PBS(1,NY,NX)=0.0
      XCOFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CCOR(NY,NX)
     2+FLQRI(NY,NX)*CCOQ(NY,NX)
      XCHFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CCHR(NY,NX)
     2+FLQRI(NY,NX)*CCHQ(NY,NX)
      XOXFLS(3,0,NY,NX)=FLQRQ(NY,NX)*COXR(NY,NX)
     2+FLQRI(NY,NX)*COXQ(NY,NX)
      XNGFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CNNR(NY,NX)
     2+FLQRI(NY,NX)*CNNQ(NY,NX)
      XN2FLS(3,0,NY,NX)=FLQRQ(NY,NX)*CN2R(NY,NX)
     2+FLQRI(NY,NX)*CN2Q(NY,NX)
      XHGFLS(3,0,NY,NX)=0.0
      XN4FLW(3,0,NY,NX)=(FLQRQ(NY,NX)*CN4R(NY,NX)+FLQRI(NY,NX)
     2*CN4Q(I,NY,NX))*14.0
      XN3FLW(3,0,NY,NX)=(FLQRQ(NY,NX)*CN3R(NY,NX)+FLQRI(NY,NX)
     2*CN3Q(I,NY,NX))*14.0
      XNOFLW(3,0,NY,NX)=(FLQRQ(NY,NX)*CNOR(NY,NX)+FLQRI(NY,NX)
     2*CNOQ(I,NY,NX))*14.0
      XNXFLS(3,0,NY,NX)=0.0
      XH1PFS(3,0,NY,NX)=(FLQRQ(NY,NX)*CH1PR(NY,NX)+FLQRI(NY,NX)
     2*CH1PQ(I,NY,NX))*31.0
      XH2PFS(3,0,NY,NX)=(FLQRQ(NY,NX)*CPOR(NY,NX)+FLQRI(NY,NX)
     2*CPOQ(I,NY,NX))*31.0
      XCOFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CCOR(NY,NX)
     2+FLQGI(NY,NX)*CCOQ(NY,NX)
      XCHFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CCHR(NY,NX)
     2+FLQGI(NY,NX)*CCHQ(NY,NX)
      XOXFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*COXR(NY,NX)
     2+FLQGI(NY,NX)*COXQ(NY,NX)
      XNGFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CNNR(NY,NX)
     2+FLQGI(NY,NX)*CNNQ(NY,NX)
      XN2FLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CN2R(NY,NX)
     2+FLQGI(NY,NX)*CN2Q(NY,NX)
      XHGFLS(3,NU(NY,NX),NY,NX)=0.0
      XN4FLW(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CN4R(NY,NX)
     2+FLQGI(NY,NX)*CN4Q(I,NY,NX))*14.0)*VLNH4(NU(NY,NX),NY,NX)
      XN3FLW(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CN3R(NY,NX)
     2+FLQGI(NY,NX)*CN3Q(I,NY,NX))*14.0)*VLNH4(NU(NY,NX),NY,NX)
      XNOFLW(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CNOR(NY,NX)
     2+FLQGI(NY,NX)*CNOQ(I,NY,NX))*14.0)*VLNO3(NU(NY,NX),NY,NX)
      XNXFLS(3,NU(NY,NX),NY,NX)=0.0
      XH1PFS(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CH1PR(NY,NX)
     2+FLQGI(NY,NX)*CH1PQ(I,NY,NX))*31.0)*VLPO4(NU(NY,NX),NY,NX)
      XH2PFS(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CPOR(NY,NX)
     2+FLQGI(NY,NX)*CPOQ(I,NY,NX))*31.0)*VLPO4(NU(NY,NX),NY,NX)
      XN4FLB(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CN4R(NY,NX)
     2+FLQGI(NY,NX)*CN4Q(I,NY,NX))*14.0)*VLNHB(NU(NY,NX),NY,NX)
      XN3FLB(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CN3R(NY,NX)
     2+FLQGI(NY,NX)*CN3Q(I,NY,NX))*14.0)*VLNHB(NU(NY,NX),NY,NX)
      XNOFLB(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CNOR(NY,NX)
     2+FLQGI(NY,NX)*CNOQ(I,NY,NX))*14.0)*VLNOB(NU(NY,NX),NY,NX)
      XNXFLB(3,NU(NY,NX),NY,NX)=0.0
      XH1BFB(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CH1PR(NY,NX)
     2+FLQGI(NY,NX)*CH1PQ(I,NY,NX))*31.0)*VLPOB(NU(NY,NX),NY,NX)
      XH2BFB(3,NU(NY,NX),NY,NX)=((FLQGQ(NY,NX)*CPOR(NY,NX)
     2+FLQGI(NY,NX)*CPOQ(I,NY,NX))*31.0)*VLPOB(NU(NY,NX),NY,NX)
C
C     NO SOLUTE FLUXES FROM ATMOSPHERE
C
      ELSE
      XCOBLS(1,NY,NX)=0.0
      XCHBLS(1,NY,NX)=0.0
      XOXBLS(1,NY,NX)=0.0
      XNGBLS(1,NY,NX)=0.0
      XN2BLS(1,NY,NX)=0.0
      XN4BLW(1,NY,NX)=0.0
      XN3BLW(1,NY,NX)=0.0
      XNOBLW(1,NY,NX)=0.0
      XH1PBS(1,NY,NX)=0.0
      XH2PBS(1,NY,NX)=0.0
      XCOFLS(3,0,NY,NX)=0.0
      XCHFLS(3,0,NY,NX)=0.0
      XOXFLS(3,0,NY,NX)=0.0
      XNGFLS(3,0,NY,NX)=0.0
      XN2FLS(3,0,NY,NX)=0.0
      XHGFLS(3,0,NY,NX)=0.0
      XN4FLW(3,0,NY,NX)=0.0
      XN3FLW(3,0,NY,NX)=0.0
      XNOFLW(3,0,NY,NX)=0.0
      XNXFLS(3,0,NY,NX)=0.0
      XH1PFS(3,0,NY,NX)=0.0
      XH2PFS(3,0,NY,NX)=0.0
      XCOFLS(3,NU(NY,NX),NY,NX)=0.0
      XCHFLS(3,NU(NY,NX),NY,NX)=0.0
      XOXFLS(3,NU(NY,NX),NY,NX)=0.0
      XNGFLS(3,NU(NY,NX),NY,NX)=0.0
      XN2FLS(3,NU(NY,NX),NY,NX)=0.0
      XHGFLS(3,NU(NY,NX),NY,NX)=0.0
      XN4FLW(3,NU(NY,NX),NY,NX)=0.0
      XN3FLW(3,NU(NY,NX),NY,NX)=0.0
      XNOFLW(3,NU(NY,NX),NY,NX)=0.0
      XNXFLS(3,NU(NY,NX),NY,NX)=0.0
      XH1PFS(3,NU(NY,NX),NY,NX)=0.0
      XH2PFS(3,NU(NY,NX),NY,NX)=0.0
      XN4FLB(3,NU(NY,NX),NY,NX)=0.0
      XN3FLB(3,NU(NY,NX),NY,NX)=0.0
      XNOFLB(3,NU(NY,NX),NY,NX)=0.0
      XNXFLB(3,NU(NY,NX),NY,NX)=0.0
      XH1BFB(3,NU(NY,NX),NY,NX)=0.0
      XH2BFB(3,NU(NY,NX),NY,NX)=0.0
      ENDIF
      XCOFHS(3,NU(NY,NX),NY,NX)=0.0
      XCHFHS(3,NU(NY,NX),NY,NX)=0.0
      XOXFHS(3,NU(NY,NX),NY,NX)=0.0
      XNGFHS(3,NU(NY,NX),NY,NX)=0.0
      XN2FHS(3,NU(NY,NX),NY,NX)=0.0
      XHGFHS(3,NU(NY,NX),NY,NX)=0.0
      XN4FHW(3,NU(NY,NX),NY,NX)=0.0
      XN3FHW(3,NU(NY,NX),NY,NX)=0.0
      XNOFHW(3,NU(NY,NX),NY,NX)=0.0
      XH1PHS(3,NU(NY,NX),NY,NX)=0.0
      XH2PHS(3,NU(NY,NX),NY,NX)=0.0
      XN4FHB(3,NU(NY,NX),NY,NX)=0.0
      XN3FHB(3,NU(NY,NX),NY,NX)=0.0
      XNOFHB(3,NU(NY,NX),NY,NX)=0.0
      XNXFHB(3,NU(NY,NX),NY,NX)=0.0
      XH1BHB(3,NU(NY,NX),NY,NX)=0.0
      XH2BHB(3,NU(NY,NX),NY,NX)=0.0
      XNXFHS(3,NU(NY,NX),NY,NX)=0.0
C
C     GAS AND SOLUTE FLUXES AT SUB-HOURLY FLUX TIME STEP
C     ENTERED IN SITE FILE
C
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C     R*BLS,R*FL0,R*FL1,R*FL2=solute flux to snowpack,surface litter,soil surface non-band,band
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     gas code: *CO*=CO2,*OX*=O2,*CH*=CH4,*NG*=N2,*N2*=N2O,*NH*=NH3,*H2*=H2
C
      DO 9845 K=0,2
      ROCFL0(K,NY,NX)=XOCFLS(K,3,0,NY,NX)*XNPH
      RONFL0(K,NY,NX)=XONFLS(K,3,0,NY,NX)*XNPH
      ROPFL0(K,NY,NX)=XOPFLS(K,3,0,NY,NX)*XNPH
      ROAFL0(K,NY,NX)=XOAFLS(K,3,0,NY,NX)*XNPH
      ROCFL1(K,NY,NX)=XOCFLS(K,3,NU(NY,NX),NY,NX)*XNPH
      RONFL1(K,NY,NX)=XONFLS(K,3,NU(NY,NX),NY,NX)*XNPH
      ROPFL1(K,NY,NX)=XOPFLS(K,3,NU(NY,NX),NY,NX)*XNPH
      ROAFL1(K,NY,NX)=XOAFLS(K,3,NU(NY,NX),NY,NX)*XNPH
9845  CONTINUE
      RCOBLS(1,NY,NX)=XCOBLS(1,NY,NX)*XNPH
      RCHBLS(1,NY,NX)=XCHBLS(1,NY,NX)*XNPH
      ROXBLS(1,NY,NX)=XOXBLS(1,NY,NX)*XNPH
      RNGBLS(1,NY,NX)=XNGBLS(1,NY,NX)*XNPH
      RN2BLS(1,NY,NX)=XN2BLS(1,NY,NX)*XNPH
      RN4BLW(1,NY,NX)=XN4BLW(1,NY,NX)*XNPH
      RN3BLW(1,NY,NX)=XN3BLW(1,NY,NX)*XNPH
      RNOBLW(1,NY,NX)=XNOBLW(1,NY,NX)*XNPH
      RH1PBS(1,NY,NX)=XH1PBS(1,NY,NX)*XNPH
      RH2PBS(1,NY,NX)=XH2PBS(1,NY,NX)*XNPH
      RCOFL0(NY,NX)=XCOFLS(3,0,NY,NX)*XNPH
      RCHFL0(NY,NX)=XCHFLS(3,0,NY,NX)*XNPH
      ROXFL0(NY,NX)=XOXFLS(3,0,NY,NX)*XNPH
      RNGFL0(NY,NX)=XNGFLS(3,0,NY,NX)*XNPH
      RN2FL0(NY,NX)=XN2FLS(3,0,NY,NX)*XNPH
      RHGFL0(NY,NX)=XHGFLS(3,0,NY,NX)*XNPH
      RN4FL0(NY,NX)=XN4FLW(3,0,NY,NX)*XNPH
      RN3FL0(NY,NX)=XN3FLW(3,0,NY,NX)*XNPH
      RNOFL0(NY,NX)=XNOFLW(3,0,NY,NX)*XNPH
      RNXFL0(NY,NX)=XNXFLS(3,0,NY,NX)*XNPH
      RH1PF0(NY,NX)=XH1PFS(3,0,NY,NX)*XNPH
      RH2PF0(NY,NX)=XH2PFS(3,0,NY,NX)*XNPH
      RCOFL1(NY,NX)=XCOFLS(3,NU(NY,NX),NY,NX)*XNPH
      RCHFL1(NY,NX)=XCHFLS(3,NU(NY,NX),NY,NX)*XNPH
      ROXFL1(NY,NX)=XOXFLS(3,NU(NY,NX),NY,NX)*XNPH
      RNGFL1(NY,NX)=XNGFLS(3,NU(NY,NX),NY,NX)*XNPH
      RN2FL1(NY,NX)=XN2FLS(3,NU(NY,NX),NY,NX)*XNPH
      RHGFL1(NY,NX)=XHGFLS(3,NU(NY,NX),NY,NX)*XNPH
      RN4FL1(NY,NX)=XN4FLW(3,NU(NY,NX),NY,NX)*XNPH
      RN3FL1(NY,NX)=XN3FLW(3,NU(NY,NX),NY,NX)*XNPH
      RNOFL1(NY,NX)=XNOFLW(3,NU(NY,NX),NY,NX)*XNPH
      RNXFL1(NY,NX)=XNXFLS(3,NU(NY,NX),NY,NX)*XNPH
      RH1PF1(NY,NX)=XH1PFS(3,NU(NY,NX),NY,NX)*XNPH
      RH2PF1(NY,NX)=XH2PFS(3,NU(NY,NX),NY,NX)*XNPH
      RN4FL2(NY,NX)=XN4FLB(3,NU(NY,NX),NY,NX)*XNPH
      RN3FL2(NY,NX)=XN3FLB(3,NU(NY,NX),NY,NX)*XNPH
      RNOFL2(NY,NX)=XNOFLB(3,NU(NY,NX),NY,NX)*XNPH
      RNXFL2(NY,NX)=XNXFLB(3,NU(NY,NX),NY,NX)*XNPH
      RH1BF2(NY,NX)=XH1BFB(3,NU(NY,NX),NY,NX)*XNPH
      RH2BF2(NY,NX)=XH2BFB(3,NU(NY,NX),NY,NX)*XNPH
C     IF(I.EQ.118.AND.NX.EQ.3.AND.NY.EQ.4)THEN
C     WRITE(*,6767)'ROXFL0',I,J,NX,NY,ROXFL0(NY,NX),XOXFLS(3,0,NY,NX)
C    2,OXYW(NY,NX),VFLWR
6767  FORMAT(A8,4I4,12E12.4)
C     ENDIF
C
C     GAS AND SOLUTE SINKS AND SOURCES IN SOIL LAYERS FROM MICROBIAL
C     TRANSFORMATIONS IN 'NITRO' + ROOT EXCHANGE IN 'EXTRACT'
C     + EQUILIBRIA REACTIONS IN 'SOLUTE' AT SUB-HOURLY TIME STEP
C
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C     *SGL*=solute diffusivity from hour1.f
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     PARR=boundary layer conductance above litter from watsub.f
C     XNPT=1/number of cycles NPH-1 for gas flux calculations
C
      CLSGL2(0,NY,NX)=CLSGL(0,NY,NX)*XNPH
      CQSGL2(0,NY,NX)=CQSGL(0,NY,NX)*XNPH
      OLSGL2(0,NY,NX)=OLSGL(0,NY,NX)*XNPH
      ZLSGL2(0,NY,NX)=ZLSGL(0,NY,NX)*XNPH
      ZNSGL2(0,NY,NX)=ZNSGL(0,NY,NX)*XNPH
      ZVSGL2(0,NY,NX)=ZVSGL(0,NY,NX)*XNPH
      HLSGL2(0,NY,NX)=HLSGL(0,NY,NX)*XNPH
      OCSGL2(0,NY,NX)=OCSGL(0,NY,NX)*XNPH
      ONSGL2(0,NY,NX)=ONSGL(0,NY,NX)*XNPH
      OPSGL2(0,NY,NX)=OPSGL(0,NY,NX)*XNPH
      OASGL2(0,NY,NX)=OASGL(0,NY,NX)*XNPH
      ZOSGL2(0,NY,NX)=ZOSGL(0,NY,NX)*XNPH
      POSGL2(0,NY,NX)=POSGL(0,NY,NX)*XNPH
C
C     INITIAL SOLUTES IN SNOWPACK
C
C     CO2W,CH4W,OXYW,ZNGW,ZN2W,ZN4W,ZN3W,ZNOW,Z1PW,ZHPW=CO2,CH4,O2,N2,N2O,H2 content in snowpack
C
      DO 20 L=1,JS
      CO2W2(L,NY,NX)=CO2W(L,NY,NX)
      CH4W2(L,NY,NX)=CH4W(L,NY,NX)
      OXYW2(L,NY,NX)=OXYW(L,NY,NX)
      ZNGW2(L,NY,NX)=ZNGW(L,NY,NX)
      ZN2W2(L,NY,NX)=ZN2W(L,NY,NX)
      ZN4W2(L,NY,NX)=ZN4W(L,NY,NX)
      ZN3W2(L,NY,NX)=ZN3W(L,NY,NX)
      ZNOW2(L,NY,NX)=ZNOW(L,NY,NX)
      Z1PW2(L,NY,NX)=Z1PW(L,NY,NX)
      ZHPW2(L,NY,NX)=ZHPW(L,NY,NX)
20    CONTINUE
C
C     SOLUTE FLUXES FROM WATSUB.F, NITRO.F, UPTAKE.F, SOLUTE.F
C
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C     CHY0=H concentration
C     PH=pH
C     FLWU,TUPWTR=total root water uptake from extract.f
C     R*SK2=total sink from nitro.f, uptake.f, solute.f
C     RCO2O=net soil CO2 uptake from nitro.f
C     RCH4O=net soil CH4 uptake from nitro.f
C     RN2G=total soil N2 production from nitro.f
C     XN2GS=total N2 fixation from nitro.f
C     RN2O=net soil N2O uptake from nitro.f
C     RH2GO=net H2 uptake from nitro.f
C     XOQCS,XOQNZ,XOQPS,XOQAS=net change in DOC,DON,DOP,acetate from nitro.f
C     XNH4S=net change in NH4 from nitro.f
C     TRN4S,TRN3S=NH4,NH3 dissolution from solute.f
C     XNO3S=net change in NO3 from nitro.f
C     TRNO3=NO3 dissolution from solute.f
C     XNO2S=net change in NO2 from nitro.f
C     TRNO2=NO2 dissolution from solute.f
C     XH2PS=net change in H2PO4 from nitro.f
C     TRH2P=H2PO4 dissolution from solute.f
C     XH1PS=net change in HPO4 from nitro.f
C     TRH1P=HPO4 dissolution from solute.f
C     TUPNH4,TUPNHB=root NH4 uptake in non-band,band from extract.f
C     TUPNO3,TUPNOB=root NO3 uptake in non-band,band from extract.f
C     TUPH2P,TUPH2B=root H2PO4 uptake in non-band,band from extract.f
C     TUPH1P,TUPH1B=root HPO4 uptake in non-band,band from extract.f
C
      DO 10 L=NU(NY,NX),NL(NY,NX)
      CHY0(L,NY,NX)=10.0**(-(PH(L,NY,NX)-3.0))
      FLWU(L,NY,NX)=TUPWTR(L,NY,NX)*XNPH
      RCOSK2(L,NY,NX)=(RCO2O(L,NY,NX)+TCO2S(L,NY,NX)-TRCO2(L,NY,NX))
     2*XNPG
      RCHSK2(L,NY,NX)=(RCH4O(L,NY,NX)+TUPCHS(L,NY,NX))*XNPG
      RNGSK2(L,NY,NX)=(RN2G(L,NY,NX)+XN2GS(L,NY,NX)+TUPNF(L,NY,NX))
     2*XNPG
      RN2SK2(L,NY,NX)=(RN2O(L,NY,NX)+TUPN2S(L,NY,NX))*XNPG
      RNHSK2(L,NY,NX)=-TRN3G(L,NY,NX)*XNPG
      RHGSK2(L,NY,NX)=(RH2GO(L,NY,NX)+TUPHGS(L,NY,NX))*XNPG
      DO 15 K=0,4
      ROCSK2(K,L,NY,NX)=-XOQCS(K,L,NY,NX)*XNPH
      RONSK2(K,L,NY,NX)=-XOQNS(K,L,NY,NX)*XNPH
      ROPSK2(K,L,NY,NX)=-XOQPS(K,L,NY,NX)*XNPH
      ROASK2(K,L,NY,NX)=-XOQAS(K,L,NY,NX)*XNPH
15    CONTINUE
      RN4SK2(L,NY,NX)=(-XNH4S(L,NY,NX)-TRN4S(L,NY,NX)
     2+TUPNH4(L,NY,NX))*XNPH
      RN3SK2(L,NY,NX)=(-TRN3S(L,NY,NX)+TUPN3S(L,NY,NX))*XNPH
      RNOSK2(L,NY,NX)=(-XNO3S(L,NY,NX)-TRNO3(L,NY,NX)
     2+TUPNO3(L,NY,NX))*XNPH
      RNXSK2(L,NY,NX)=(-XNO2S(L,NY,NX)-TRNO2(L,NY,NX))*XNPH
      RHPSK2(L,NY,NX)=(-XH2PS(L,NY,NX)-TRH2P(L,NY,NX)
     2+TUPH2P(L,NY,NX))*XNPH
      R1PSK2(L,NY,NX)=(-XH1PS(L,NY,NX)-TRH1P(L,NY,NX)
     2+TUPH1P(L,NY,NX))*XNPH
      R4BSK2(L,NY,NX)=(-XNH4B(L,NY,NX)-TRN4B(L,NY,NX)
     2+TUPNHB(L,NY,NX))*XNPH
      R3BSK2(L,NY,NX)=(-TRN3B(L,NY,NX)+TUPN3B(L,NY,NX))*XNPH
      RNBSK2(L,NY,NX)=(-XNO3B(L,NY,NX)-TRNOB(L,NY,NX)
     2+TUPNOB(L,NY,NX))*XNPH
      RNZSK2(L,NY,NX)=(-XNO2B(L,NY,NX)-TRN2B(L,NY,NX))*XNPH
      RHBSK2(L,NY,NX)=(-XH2BS(L,NY,NX)-TRH2B(L,NY,NX)
     2+TUPH2B(L,NY,NX))*XNPH
      R1BSK2(L,NY,NX)=(-XH1BS(L,NY,NX)-TRH1B(L,NY,NX)
     2+TUPH1B(L,NY,NX))*XNPH
C     IF(IYRC.EQ.2012.AND.I.EQ.151.AND.NX.EQ.1)THEN
C     WRITE(*,4441)'RN3SK2',I,J,NX,NY,L,RN3SK2(L,NY,NX)
C    2,TRN3S(L,NY,NX),TUPN3S(L,NY,NX),RN4SK2(L,NY,NX)
C    2,XNH4S(L,NY,NX),TRN4S(L,NY,NX),TUPNH4(L,NY,NX)
4441  FORMAT(A8,5I4,20E12.4)
C     ENDIF
C
C     SOLUTE FLUXES FROM SUBSURFACE IRRIGATION
C
C     FLU=subsurface water flux from watsub.f
C     R*FLU,R*FBU=subsurface solute flux in non-band,band
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     C*Q=irrigation solute concentrations
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C
      RCOFLU(L,NY,NX)=FLU(L,NY,NX)*CCOQ(NY,NX)
      RCHFLU(L,NY,NX)=FLU(L,NY,NX)*CCHQ(NY,NX)
      ROXFLU(L,NY,NX)=FLU(L,NY,NX)*COXQ(NY,NX)
      RNGFLU(L,NY,NX)=FLU(L,NY,NX)*CNNQ(NY,NX)
      RN2FLU(L,NY,NX)=FLU(L,NY,NX)*CN2Q(NY,NX)
      RHGFLU(L,NY,NX)=0.0
      RN4FLU(L,NY,NX)=FLU(L,NY,NX)*CN4Q(I,NY,NX)*VLNH4(L,NY,NX)*14.0
      RN3FLU(L,NY,NX)=FLU(L,NY,NX)*CN3Q(I,NY,NX)*VLNH4(L,NY,NX)*14.0
      RNOFLU(L,NY,NX)=FLU(L,NY,NX)*CNOQ(I,NY,NX)*VLNO3(L,NY,NX)*14.0
      RH1PFU(L,NY,NX)=FLU(L,NY,NX)*CH1PQ(I,NY,NX)*VLPO4(L,NY,NX)*31.0
      RH2PFU(L,NY,NX)=FLU(L,NY,NX)*CPOQ(I,NY,NX)*VLPO4(L,NY,NX)*31.0
      RN4FBU(L,NY,NX)=FLU(L,NY,NX)*CN4Q(I,NY,NX)*VLNHB(L,NY,NX)*14.0
      RN3FBU(L,NY,NX)=FLU(L,NY,NX)*CN3Q(I,NY,NX)*VLNHB(L,NY,NX)*14.0
      RNOFBU(L,NY,NX)=FLU(L,NY,NX)*CNOQ(I,NY,NX)*VLNOB(L,NY,NX)*14.0
      RH1BBU(L,NY,NX)=FLU(L,NY,NX)*CH1PQ(I,NY,NX)*VLPOB(L,NY,NX)*31.0
      RH2BBU(L,NY,NX)=FLU(L,NY,NX)*CPOQ(I,NY,NX)*VLPOB(L,NY,NX)*31.0
C
C     SUB-HOURLY SOLUTE FLUXES FROM SUBSURFACE IRRIGATION
C
C     R*FLZ,R*FBZ=subsurface solute flux in non-band,band
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C
      RCOFLZ(L,NY,NX)=RCOFLU(L,NY,NX)*XNPH
      RCHFLZ(L,NY,NX)=RCHFLU(L,NY,NX)*XNPH
      ROXFLZ(L,NY,NX)=ROXFLU(L,NY,NX)*XNPH
      RNGFLZ(L,NY,NX)=RNGFLU(L,NY,NX)*XNPH
      RN2FLZ(L,NY,NX)=RN2FLU(L,NY,NX)*XNPH
      RHGFLZ(L,NY,NX)=RHGFLU(L,NY,NX)*XNPH
      RN4FLZ(L,NY,NX)=RN4FLU(L,NY,NX)*XNPH
      RN3FLZ(L,NY,NX)=RN3FLU(L,NY,NX)*XNPH
      RNOFLZ(L,NY,NX)=RNOFLU(L,NY,NX)*XNPH
      RH1PFZ(L,NY,NX)=RH1PFU(L,NY,NX)*XNPH
      RH2PFZ(L,NY,NX)=RH2PFU(L,NY,NX)*XNPH
      RN4FBZ(L,NY,NX)=RN4FBU(L,NY,NX)*XNPH
      RN3FBZ(L,NY,NX)=RN3FBU(L,NY,NX)*XNPH
      RNOFBZ(L,NY,NX)=RNOFBU(L,NY,NX)*XNPH
      RH1BBZ(L,NY,NX)=RH1BBU(L,NY,NX)*XNPH
      RH2BBZ(L,NY,NX)=RH2BBU(L,NY,NX)*XNPH
C
C     GAS AND SOLUTE DIFFUSIVITIES AT SUB-HOURLY TIME STEP
C
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C     XNPG=1/number of cycles h-1 for gas flux calculations
C     *SGL*=solute diffusivity from hour1.f
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C
      OCSGL2(L,NY,NX)=OCSGL(L,NY,NX)*XNPH
      ONSGL2(L,NY,NX)=ONSGL(L,NY,NX)*XNPH
      OPSGL2(L,NY,NX)=OPSGL(L,NY,NX)*XNPH
      OASGL2(L,NY,NX)=OASGL(L,NY,NX)*XNPH
      CLSGL2(L,NY,NX)=CLSGL(L,NY,NX)*XNPH
      CQSGL2(L,NY,NX)=CQSGL(L,NY,NX)*XNPH
      OLSGL2(L,NY,NX)=OLSGL(L,NY,NX)*XNPH
      ZLSGL2(L,NY,NX)=ZLSGL(L,NY,NX)*XNPH
      ZVSGL2(L,NY,NX)=ZVSGL(L,NY,NX)*XNPH
      ZNSGL2(L,NY,NX)=ZNSGL(L,NY,NX)*XNPH
      HLSGL2(L,NY,NX)=HLSGL(L,NY,NX)*XNPH
      ZOSGL2(L,NY,NX)=ZOSGL(L,NY,NX)*XNPH
      POSGL2(L,NY,NX)=POSGL(L,NY,NX)*XNPH
      CGSGL2(L,NY,NX)=CGSGL(L,NY,NX)*XNPG
      CHSGL2(L,NY,NX)=CHSGL(L,NY,NX)*XNPG
      OGSGL2(L,NY,NX)=OGSGL(L,NY,NX)*XNPG
      ZGSGL2(L,NY,NX)=ZGSGL(L,NY,NX)*XNPG
      Z2SGL2(L,NY,NX)=Z2SGL(L,NY,NX)*XNPG
      ZHSGL2(L,NY,NX)=ZHSGL(L,NY,NX)*XNPG
      HGSGL2(L,NY,NX)=HGSGL(L,NY,NX)*XNPG
C
C     STATE VARIABLES FOR GASES AND SOLUTES USED IN 'TRNSFR'
C     TO STORE SUB-HOURLY CHANGES DURING FLUX CALCULATIONS
C     INCLUDING TRANSFORMATIONS FROM NITRO.F, UPTAKE.F AND SOLUTE.F
C
C     CO2G,CH4G,OXYG,ZN3G,Z2GG,Z2OG,H2GG=gaseous CO2,CH4,O2,NH3,N2,N2O,H2
C     CO2S,CH4S,OXYS,Z2GS,Z2OS,H2GS=aqueous CO2,CH4,O2,N2,N2O,H2 in micropores
C     OQC,OQN,OQP,OQA=DOC,DON,DOP,acetate in micropores
C     XOQCS,XOQNZ,XOQPS,XOQAS=net change in DOC,DON,DOP,acetate from nitro.f
C     OQCH,OQNH,OQPH,OQAH=DOC,DON,DOP,acetate in macropores
C     ZNH4S,ZNH3S,ZNO3S,ZNO2S,H1PO4,H2PO4=aqueous NH4,NH3,NO3,NO2,HPO4,H2PO4 in non-band micropores
C     ZNH4B,ZNH3B,ZNO3B,ZNO2B,H1POB,H2POB=aqueous NH4,NH3,NO3,NO2,HPO4,H2PO4 in band micropores
C     CO2SH,CH4SH,OXYSH,Z2GSH,Z2OSH,H2GSH=aqueous CO2,CH4,O2,N2,N2O,H2 content in macropores
C     ZNH4SH,ZNH3SH,ZNO3SH,ZNO2SH,H1PO4H,H2PO4H=aqueous NH4,NH3,NO3,NO2,HPO4,H2PO4 in non-band macropores
C     ZNH4BH,ZNH3BH,ZNO3BH,ZNO2BH,H1POBH,H2POBH=aqueous NH4,NH3,NO3,NO2,HPO4,H2PO4 in band macropores
C
      CO2G2(L,NY,NX)=CO2G(L,NY,NX)
      CH4G2(L,NY,NX)=CH4G(L,NY,NX)
      OXYG2(L,NY,NX)=OXYG(L,NY,NX)
      ZN3G2(L,NY,NX)=ZNH3G(L,NY,NX)
      Z2GG2(L,NY,NX)=Z2GG(L,NY,NX)
      Z2OG2(L,NY,NX)=Z2OG(L,NY,NX)
      H2GG2(L,NY,NX)=H2GG(L,NY,NX)
      CO2S2(L,NY,NX)=CO2S(L,NY,NX)
      CH4S2(L,NY,NX)=CH4S(L,NY,NX)
      OXYS2(L,NY,NX)=OXYS(L,NY,NX)
      Z2GS2(L,NY,NX)=Z2GS(L,NY,NX)
      Z2OS2(L,NY,NX)=Z2OS(L,NY,NX)
      H2GS2(L,NY,NX)=H2GS(L,NY,NX)
      DO 9980 K=0,4
      OQC2(K,L,NY,NX)=OQC(K,L,NY,NX)-XOQCS(K,L,NY,NX)
      OQN2(K,L,NY,NX)=OQN(K,L,NY,NX)-XOQNS(K,L,NY,NX)
      OQP2(K,L,NY,NX)=OQP(K,L,NY,NX)-XOQPS(K,L,NY,NX)
      OQA2(K,L,NY,NX)=OQA(K,L,NY,NX)-XOQAS(K,L,NY,NX)
      OQCH2(K,L,NY,NX)=OQCH(K,L,NY,NX)
      OQNH2(K,L,NY,NX)=OQNH(K,L,NY,NX)
      OQPH2(K,L,NY,NX)=OQPH(K,L,NY,NX)
      OQAH2(K,L,NY,NX)=OQAH(K,L,NY,NX)
C     IF(L.EQ.1)THEN
C     WRITE(*,449)'OQCI',I,J,NX,NY,L,K,OQC2(K,L,NY,NX),OQC(K,L,NY,NX)
C    2,XOQCS(K,L,NY,NX)
449   FORMAT(A8,6I4,12E12.4)
C     ENDIF
9980  CONTINUE
      ZNH4S2(L,NY,NX)=ZNH4S(L,NY,NX)
      ZNH3S2(L,NY,NX)=ZNH3S(L,NY,NX)
      ZNO3S2(L,NY,NX)=ZNO3S(L,NY,NX)
      ZNO2S2(L,NY,NX)=ZNO2S(L,NY,NX)
      H1PO42(L,NY,NX)=H1PO4(L,NY,NX)
      H2PO42(L,NY,NX)=H2PO4(L,NY,NX)
      ZNH4B2(L,NY,NX)=ZNH4B(L,NY,NX)
      ZNH3B2(L,NY,NX)=ZNH3B(L,NY,NX)
      ZNO3B2(L,NY,NX)=ZNO3B(L,NY,NX)
      ZNO2B2(L,NY,NX)=ZNO2B(L,NY,NX)
      H1POB2(L,NY,NX)=H1POB(L,NY,NX)
      H2POB2(L,NY,NX)=H2POB(L,NY,NX)
      CO2SH2(L,NY,NX)=CO2SH(L,NY,NX)
      CH4SH2(L,NY,NX)=CH4SH(L,NY,NX)
      OXYSH2(L,NY,NX)=OXYSH(L,NY,NX)
      Z2GSH2(L,NY,NX)=Z2GSH(L,NY,NX)
      Z2OSH2(L,NY,NX)=Z2OSH(L,NY,NX)
      H2GSH2(L,NY,NX)=H2GSH(L,NY,NX)
      ZNH4H2(L,NY,NX)=ZNH4SH(L,NY,NX)
      ZNH3H2(L,NY,NX)=ZNH3SH(L,NY,NX)
      ZNO3H2(L,NY,NX)=ZNO3SH(L,NY,NX)
      ZNO2H2(L,NY,NX)=ZNO2SH(L,NY,NX)
      H1P4H2(L,NY,NX)=H1PO4H(L,NY,NX)
      H2P4H2(L,NY,NX)=H2PO4H(L,NY,NX)
      ZN4BH2(L,NY,NX)=ZNH4BH(L,NY,NX)
      ZN3BH2(L,NY,NX)=ZNH3BH(L,NY,NX)
      ZNOBH2(L,NY,NX)=ZNO3BH(L,NY,NX)
      ZN2BH2(L,NY,NX)=ZNO2BH(L,NY,NX)
      H1PBH2(L,NY,NX)=H1POBH(L,NY,NX)
      H2PBH2(L,NY,NX)=H2POBH(L,NY,NX)
10    CONTINUE
9990  CONTINUE
9995  CONTINUE
C
C     TIME STEP USED IN GAS AND SOLUTE FLUX CALCULATIONS
C
      MX=0
      DO 30 MM=1,NPG
      M=MIN(NPH,INT((MM-1)*XNPT)+1)
      DO 9895 NX=NHW,NHE
      DO 9890 NY=NVN,NVS
      IF(M.NE.MX)THEN
C
C     GASEOUS BOUNDARY LAYER CONDUCTANCES
C
C     PARG=boundary layer conductance above soil surface from watsub.f
C
      PARGM=PARG(M,NY,NX)*XNPT
      PARGCO(NY,NX)=PARGM*0.74
      PARGCH(NY,NX)=PARGM*1.04
      PARGOX(NY,NX)=PARGM*0.83
      PARGNG(NY,NX)=PARGM*0.86
      PARGN2(NY,NX)=PARGM*0.74
      PARGN3(NY,NX)=PARGM*1.02
      PARGH2(NY,NX)=PARGM*2.08
C
C     RESET RUNOFF SOLUTE FLUX ACCUMULATORS
C
C     R*SK2=total sink from nitro.f, uptake.f, solute.f
C     OQC,OQN,OQP,OQA=DOC,DON,DOP,acetate in micropores
C     ZNH4S,ZNH3S,ZNO3S,ZNO2S,H1PO4,H2PO4=aqueous NH4,NH3,NO3,NO2,HPO4,H2PO4 in micropores
C     CO2S,CH4S,OXYS,Z2GS,Z2OS,H2GS=aqueous CO2,CH4,O2,N2,N2O,H2 in micropores
C     ZN3G=gaseous NH3
C
      DO 9880 K=0,4
      TQROC(K,NY,NX)=0.0
      TQRON(K,NY,NX)=0.0
      TQROP(K,NY,NX)=0.0
      TQROA(K,NY,NX)=0.0
      OQC2(K,0,NY,NX)=OQC2(K,0,NY,NX)-ROCSK2(K,0,NY,NX)
      OQN2(K,0,NY,NX)=OQN2(K,0,NY,NX)-RONSK2(K,0,NY,NX)
      OQP2(K,0,NY,NX)=OQP2(K,0,NY,NX)-ROPSK2(K,0,NY,NX)
      OQA2(K,0,NY,NX)=OQA2(K,0,NY,NX)-ROASK2(K,0,NY,NX)
9880  CONTINUE
      TQRCOS(NY,NX)=0.0
      TQRCHS(NY,NX)=0.0
      TQROXS(NY,NX)=0.0
      TQRNGS(NY,NX)=0.0
      TQRN2S(NY,NX)=0.0
      TQRHGS(NY,NX)=0.0
      TQRNH4(NY,NX)=0.0
      TQRNH3(NY,NX)=0.0
      TQRNO3(NY,NX)=0.0
      TQRNO2(NY,NX)=0.0
      TQRH1P(NY,NX)=0.0
      TQRH2P(NY,NX)=0.0
      TQSCOS(NY,NX)=0.0
      TQSCHS(NY,NX)=0.0
      TQSOXS(NY,NX)=0.0
      TQSNGS(NY,NX)=0.0
      TQSN2S(NY,NX)=0.0
      TQSNH4(NY,NX)=0.0
      TQSNH3(NY,NX)=0.0
      TQSNO3(NY,NX)=0.0
      TQSH1P(NY,NX)=0.0
      TQSH2P(NY,NX)=0.0
      ZNH4S2(0,NY,NX)=ZNH4S2(0,NY,NX)-RN4SK2(0,NY,NX)
      ZNH3S2(0,NY,NX)=ZNH3S2(0,NY,NX)-RN3SK2(0,NY,NX)
      ZNO3S2(0,NY,NX)=ZNO3S2(0,NY,NX)-RNOSK2(0,NY,NX)
      ZNO2S2(0,NY,NX)=ZNO2S2(0,NY,NX)-RNXSK2(0,NY,NX)
      H2PO42(0,NY,NX)=H2PO42(0,NY,NX)-RHPSK2(0,NY,NX)
      H1PO42(0,NY,NX)=H1PO42(0,NY,NX)-R1PSK2(0,NY,NX)
      ROXSK2(0,NY,NX)=ROXSK(M,0,NY,NX)*XNPT
      ENDIF
      CO2S2(0,NY,NX)=CO2S2(0,NY,NX)-RCOSK2(0,NY,NX)
      CH4S2(0,NY,NX)=CH4S2(0,NY,NX)-RCHSK2(0,NY,NX)
      OXYS2(0,NY,NX)=OXYS2(0,NY,NX)-ROXSK2(0,NY,NX)
      Z2GS2(0,NY,NX)=Z2GS2(0,NY,NX)-RNGSK2(0,NY,NX)
      Z2OS2(0,NY,NX)=Z2OS2(0,NY,NX)-RN2SK2(0,NY,NX)
      H2GS2(0,NY,NX)=H2GS2(0,NY,NX)-RHGSK2(0,NY,NX)
      ZN3G2(0,NY,NX)=ZN3G2(0,NY,NX)-RNHSK2(0,NY,NX)
C
C     INITIALIZE SNOWPACK NET FLUX ACCUMULATORS
C
      IF(M.NE.MX)THEN
      DO 9855 L=1,JS
      TCOBLS(L,NY,NX)=0.0
      TCHBLS(L,NY,NX)=0.0
      TOXBLS(L,NY,NX)=0.0
      TNGBLS(L,NY,NX)=0.0
      TN2BLS(L,NY,NX)=0.0
      TN4BLW(L,NY,NX)=0.0
      TN3BLW(L,NY,NX)=0.0
      TNOBLW(L,NY,NX)=0.0
      TH1PBS(L,NY,NX)=0.0
      TH2PBS(L,NY,NX)=0.0
9855  CONTINUE
      ENDIF
C
C     INITIALIZE SOIL SOLUTE NET FLUX ACCUMULATORS
C
      DO 9885 L=NU(NY,NX),NL(NY,NX)
      IF(M.NE.MX)THEN
      DO 9875 K=0,4
      TOCFLS(K,L,NY,NX)=0.0
      TONFLS(K,L,NY,NX)=0.0
      TOPFLS(K,L,NY,NX)=0.0
      TOAFLS(K,L,NY,NX)=0.0
      TOCFHS(K,L,NY,NX)=0.0
      TONFHS(K,L,NY,NX)=0.0
      TOPFHS(K,L,NY,NX)=0.0
      TOAFHS(K,L,NY,NX)=0.0
      OQC2(K,L,NY,NX)=OQC2(K,L,NY,NX)-ROCSK2(K,L,NY,NX)
      OQN2(K,L,NY,NX)=OQN2(K,L,NY,NX)-RONSK2(K,L,NY,NX)
      OQP2(K,L,NY,NX)=OQP2(K,L,NY,NX)-ROPSK2(K,L,NY,NX)
      OQA2(K,L,NY,NX)=OQA2(K,L,NY,NX)-ROASK2(K,L,NY,NX)
9875  CONTINUE
      TCOFLS(L,NY,NX)=0.0
      TCHFLS(L,NY,NX)=0.0
      TOXFLS(L,NY,NX)=0.0
      TNGFLS(L,NY,NX)=0.0
      TN2FLS(L,NY,NX)=0.0
      THGFLS(L,NY,NX)=0.0
      TN4FLW(L,NY,NX)=0.0
      TN3FLW(L,NY,NX)=0.0
      TNOFLW(L,NY,NX)=0.0
      TNXFLS(L,NY,NX)=0.0
      TH1PFS(L,NY,NX)=0.0
      TH2PFS(L,NY,NX)=0.0
      TN4FLB(L,NY,NX)=0.0
      TN3FLB(L,NY,NX)=0.0
      TNOFLB(L,NY,NX)=0.0
      TNXFLB(L,NY,NX)=0.0
      TH1BFB(L,NY,NX)=0.0
      TH2BFB(L,NY,NX)=0.0
      TCOFHS(L,NY,NX)=0.0
      TCHFHS(L,NY,NX)=0.0
      TOXFHS(L,NY,NX)=0.0
      TNGFHS(L,NY,NX)=0.0
      TN2FHS(L,NY,NX)=0.0
      THGFHS(L,NY,NX)=0.0
      TN4FHW(L,NY,NX)=0.0
      TN3FHW(L,NY,NX)=0.0
      TNOFHW(L,NY,NX)=0.0
      TNXFHS(L,NY,NX)=0.0
      TH1PHS(L,NY,NX)=0.0
      TH2PHS(L,NY,NX)=0.0
      TN4FHB(L,NY,NX)=0.0
      TN3FHB(L,NY,NX)=0.0
      TNOFHB(L,NY,NX)=0.0
      TNXFHB(L,NY,NX)=0.0
      TH1BHB(L,NY,NX)=0.0
      TH2BHB(L,NY,NX)=0.0
C
C     ADD SOLUTE SINKS
C
C     R*SK2=total flux from nitro.f, uptake.f, solute.f
C     ZNH4S,ZNH3S,ZNO3S,ZNO2S,H1PO4,H2PO4=aqueous NH4,NH3,NO3,NO2,HPO4,H2PO4 in non-band micropores
C     ZNH4B,ZNH3B,ZNO3B,ZNO2B,H1POB,H2POB=aqueous NH4,NH3,NO3,NO2,HPO4,H2PO4 in band micropores
C
C
      ZNH4S2(L,NY,NX)=ZNH4S2(L,NY,NX)-RN4SK2(L,NY,NX)
      ZNH3S2(L,NY,NX)=ZNH3S2(L,NY,NX)-RN3SK2(L,NY,NX)
      ZNO3S2(L,NY,NX)=ZNO3S2(L,NY,NX)-RNOSK2(L,NY,NX)
      ZNO2S2(L,NY,NX)=ZNO2S2(L,NY,NX)-RNXSK2(L,NY,NX)
      H2PO42(L,NY,NX)=H2PO42(L,NY,NX)-RHPSK2(L,NY,NX)
      H1PO42(L,NY,NX)=H1PO42(L,NY,NX)-R1PSK2(L,NY,NX)
      ZNH4B2(L,NY,NX)=ZNH4B2(L,NY,NX)-R4BSK2(L,NY,NX)
      ZNH3B2(L,NY,NX)=ZNH3B2(L,NY,NX)-R3BSK2(L,NY,NX)
      ZNO3B2(L,NY,NX)=ZNO3B2(L,NY,NX)-RNBSK2(L,NY,NX)
      ZNO2B2(L,NY,NX)=ZNO2B2(L,NY,NX)-RNZSK2(L,NY,NX)
      H2POB2(L,NY,NX)=H2POB2(L,NY,NX)-RHBSK2(L,NY,NX)
      H1POB2(L,NY,NX)=H1POB2(L,NY,NX)-R1BSK2(L,NY,NX)
      ROXSK2(L,NY,NX)=ROXSK(M,L,NY,NX)*XNPT
      ENDIF
C
C     SOIL GAS FLUX ACCUMULATORS
C
C     R*SK2=total sink from nitro.f, uptake.f, solute.f
C     CO2S,CH4S,OXYS,Z2GS,Z2OS,H2GS=aqueous CO2,CH4,O2,N2,N2O,H2 in micropores
C     ZN3G=gaseous NH3
C
      TCOFLG(L,NY,NX)=0.0
      TCHFLG(L,NY,NX)=0.0
      TOXFLG(L,NY,NX)=0.0
      TNGFLG(L,NY,NX)=0.0
      TN2FLG(L,NY,NX)=0.0
      TN3FLG(L,NY,NX)=0.0
      THGFLG(L,NY,NX)=0.0
      CO2S2(L,NY,NX)=CO2S2(L,NY,NX)-RCOSK2(L,NY,NX)
      CH4S2(L,NY,NX)=CH4S2(L,NY,NX)-RCHSK2(L,NY,NX)
      OXYS2(L,NY,NX)=OXYS2(L,NY,NX)-ROXSK2(L,NY,NX)
      Z2GS2(L,NY,NX)=Z2GS2(L,NY,NX)-RNGSK2(L,NY,NX)
      Z2OS2(L,NY,NX)=Z2OS2(L,NY,NX)-RN2SK2(L,NY,NX)
      H2GS2(L,NY,NX)=H2GS2(L,NY,NX)-RHGSK2(L,NY,NX)
      ZN3G2(L,NY,NX)=ZN3G2(L,NY,NX)-RNHSK2(L,NY,NX)
C     IF(I.EQ.105)THEN
C     WRITE(*,444)'CO2S1',I,J,NX,NY,L,M,MM,CO2S2(L,NY,NX)
C    2,RCOSK2(L,NY,NX),RCO2O(L,NY,NX),TCO2S(L,NY,NX)
C    3,TRCO2(L,NY,NX)
C     ENDIF
9885  CONTINUE
      IF(M.NE.MX)THEN
C
C     SOLUTE FLUXES FROM MELTING SNOWPACK TO
C     RESIDUE AND SOIL SURFACE FROM SNOWMELT IN 'WATSUB' AND
C     CONCENTRATIONS IN SNOWPACK
C
C     VHCPWM,VHCPWX=current,minimum volumetric heat capacity of snowpack
C     VOLWSL=snowpack water content
C     FLQWM=snowpack water flux
C     R*BLS=solute flux in snowpack
C     X*BLS=hourly solute flux in snowpack
C     CO2W,CH4W,OXYW,ZNGW,ZN2W,ZN4W,ZN3W,ZNOW,Z1PW,ZHPW=CO2,CH4,O2,N2,N2O,H2 content in snowpack
C
      ICHKL=0
      DO 9775 L=1,JS
      IF(VHCPWM(M,L,NY,NX).GT.VHCPWX(NY,NX))THEN
      L2=MIN(JS,L+1)
      IF(L.LT.JS.AND.VHCPWM(M,L2,NY,NX).GT.VHCPWX(NY,NX))THEN
      IF(VOLWSL(L,NY,NX).GT.ZEROS2(NY,NX))THEN
      VFLWW=AMAX1(0.0,AMIN1(1.0,FLQWM(M,L2,NY,NX)/VOLWSL(L,NY,NX)))
      ELSE
      VFLWW=1.0
      ENDIF
      RCOBLS(L2,NY,NX)=CO2W2(L,NY,NX)*VFLWW
      RCHBLS(L2,NY,NX)=CH4W2(L,NY,NX)*VFLWW
      ROXBLS(L2,NY,NX)=OXYW2(L,NY,NX)*VFLWW
      RNGBLS(L2,NY,NX)=ZNGW2(L,NY,NX)*VFLWW
      RN2BLS(L2,NY,NX)=ZN2W2(L,NY,NX)*VFLWW
      RN4BLW(L2,NY,NX)=ZN4W2(L,NY,NX)*VFLWW
      RN3BLW(L2,NY,NX)=ZN3W2(L,NY,NX)*VFLWW
      RNOBLW(L2,NY,NX)=ZNOW2(L,NY,NX)*VFLWW
      RH1PBS(L2,NY,NX)=Z1PW2(L,NY,NX)*VFLWW
      RH2PBS(L2,NY,NX)=ZHPW2(L,NY,NX)*VFLWW
      XCOBLS(L2,NY,NX)=XCOBLS(L2,NY,NX)+RCOBLS(L2,NY,NX)
      XCHBLS(L2,NY,NX)=XCHBLS(L2,NY,NX)+RCHBLS(L2,NY,NX)
      XOXBLS(L2,NY,NX)=XOXBLS(L2,NY,NX)+ROXBLS(L2,NY,NX)
      XNGBLS(L2,NY,NX)=XNGBLS(L2,NY,NX)+RNGBLS(L2,NY,NX)
      XN2BLS(L2,NY,NX)=XN2BLS(L2,NY,NX)+RN2BLS(L2,NY,NX)
      XN4BLW(L2,NY,NX)=XN4BLW(L2,NY,NX)+RN4BLW(L2,NY,NX)
      XN3BLW(L2,NY,NX)=XN3BLW(L2,NY,NX)+RN3BLW(L2,NY,NX)
      XNOBLW(L2,NY,NX)=XNOBLW(L2,NY,NX)+RNOBLW(L2,NY,NX)
      XH1PBS(L2,NY,NX)=XH1PBS(L2,NY,NX)+RH1PBS(L2,NY,NX)
      XH2PBS(L2,NY,NX)=XH2PBS(L2,NY,NX)+RH2PBS(L2,NY,NX)
      ELSE
      IF(L.LT.JS)THEN
      RCOBLS(L2,NY,NX)=0.0
      RCHBLS(L2,NY,NX)=0.0
      ROXBLS(L2,NY,NX)=0.0
      RNGBLS(L2,NY,NX)=0.0
      RN2BLS(L2,NY,NX)=0.0
      RN4BLW(L2,NY,NX)=0.0
      RN3BLW(L2,NY,NX)=0.0
      RNOBLW(L2,NY,NX)=0.0
      RH1PBS(L2,NY,NX)=0.0
      RH2PBS(L2,NY,NX)=0.0
      ENDIF
C
C     SNOWPACK SOLUTE DISCHARGE TO SURFACE LITTER, SOIL SURFACE
C
C     VOLWSL=snowpack water content
C     FLQRM,FLQSM,FLQHM=total water flux to litter,soil micropore,macropore
C     CVRD,BARE=litter cover fraction,1-CVRD
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C     R*S0=solute flux to surface litter
C     R*S1,R*B1=solute flux to soil surface non-band,band
C     CO2W,CH4W,OXYW,ZNGW,ZN2W,ZN4W,ZN3W,ZNOW,Z1PW,ZHPW=CO2,CH4,O2,N2,N2O,H2 content in snowpack
C
      IF(ICHKL.EQ.0)THEN
      IF(VOLWSL(L,NY,NX).GT.ZEROS2(NY,NX))THEN
      VFLWR=AMAX1(0.0,AMIN1(1.0,FLQRM(M,NY,NX)/VOLWSL(L,NY,NX)))
      VFLWS=AMAX1(0.0,AMIN1(1.0,(FLQSM(M,NY,NX)+FLQHM(M,NY,NX))
     2/VOLWSL(L,NY,NX)))
      ELSE
      VFLWR=CVRD(NY,NX)
      VFLWS=BARE(NY,NX)
      ENDIF
      VFLWNH4=VFLWS*VLNH4(NU(NY,NX),NY,NX)
      VFLWNHB=VFLWS*VLNHB(NU(NY,NX),NY,NX)
      VFLWNO3=VFLWS*VLNO3(NU(NY,NX),NY,NX)
      VFLWNOB=VFLWS*VLNOB(NU(NY,NX),NY,NX)
      VFLWPO4=VFLWS*VLPO4(NU(NY,NX),NY,NX)
      VFLWPOB=VFLWS*VLPOB(NU(NY,NX),NY,NX)
      RCOFLS0=CO2W2(L,NY,NX)*VFLWR
      RCHFLS0=CH4W2(L,NY,NX)*VFLWR
      ROXFLS0=OXYW2(L,NY,NX)*VFLWR
      RNGFLS0=ZNGW2(L,NY,NX)*VFLWR
      RN2FLS0=ZN2W2(L,NY,NX)*VFLWR
      RN4FLW0=ZN4W2(L,NY,NX)*VFLWR
      RN3FLW0=ZN3W2(L,NY,NX)*VFLWR
      RNOFLW0=ZNOW2(L,NY,NX)*VFLWR
      RH1PFS0=Z1PW2(L,NY,NX)*VFLWR
      RH2PFS0=ZHPW2(L,NY,NX)*VFLWR
      RCOFLS1=CO2W2(L,NY,NX)*VFLWS
      RCHFLS1=CH4W2(L,NY,NX)*VFLWS
      ROXFLS1=OXYW2(L,NY,NX)*VFLWS
      RNGFLS1=ZNGW2(L,NY,NX)*VFLWS
      RN2FLS1=ZN2W2(L,NY,NX)*VFLWS
      RN4FLW1=ZN4W2(L,NY,NX)*VFLWNH4
      RN3FLW1=ZN3W2(L,NY,NX)*VFLWNH4
      RNOFLW1=ZNOW2(L,NY,NX)*VFLWNO3
      RH1PFS1=Z1PW2(L,NY,NX)*VFLWPO4
      RH2PFS1=ZHPW2(L,NY,NX)*VFLWPO4
      RN4FLB1=ZN4W2(L,NY,NX)*VFLWNHB
      RN3FLB1=ZN3W2(L,NY,NX)*VFLWNHB
      RNOFLB1=ZNOW2(L,NY,NX)*VFLWNOB
      RH1BFB1=Z1PW2(L,NY,NX)*VFLWPOB
      RH2BFB1=ZHPW2(L,NY,NX)*VFLWPOB
      ICHKL=1
      ENDIF
      ENDIF
      ELSE
      RCOFLS0=0.0
      RCHFLS0=0.0
      ROXFLS0=0.0
      RNGFLS0=0.0
      RN2FLS0=0.0
      RN4FLW0=0.0
      RN3FLW0=0.0
      RNOFLW0=0.0
      RH1PFS0=0.0
      RH2PFS0=0.0
      RCOFLS1=0.0
      RCHFLS1=0.0
      ROXFLS1=0.0
      RNGFLS1=0.0
      RN2FLS1=0.0
      RN4FLW1=0.0
      RN3FLW1=0.0
      RNOFLW1=0.0
      RH1PFS1=0.0
      RH2PFS1=0.0
      RN4FLB1=0.0
      RN3FLB1=0.0
      RNOFLB1=0.0
      RH1BFB1=0.0
      RH2BFB1=0.0
      ENDIF
9775  CONTINUE
C
C     SOLUTE FLUXES AT SOIL SURFACE FROM SURFACE WATER
C     CONTENTS, WATER FLUXES 'FLQM' AND ATMOSPHERE BOUNDARY
C     LAYER RESISTANCES 'PARGM' FROM 'WATSUB'
C
C     VOLWM,VOLWHM,VOLPM,FLPM=micropore,macropore water volume, air volume and change in air volume
C     FLWM,FLWHM=water flux into soil micropore,macropore from watsub.f
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C     FLVM,FLM=air,water flux in gas flux calculations
C     XNPT=1/number of cycles NPH-1 for gas flux calculations
C
      VOLWMA(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*VLNH4(NU(NY,NX),NY,NX)
      VOLWMB(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*VLNHB(NU(NY,NX),NY,NX)
      VOLWXA(NU(NY,NX),NY,NX)=14.0*VOLWMA(NU(NY,NX),NY,NX)
      VOLWXB(NU(NY,NX),NY,NX)=14.0*VOLWMB(NU(NY,NX),NY,NX)
      VOLWOA=VOLWM(M,NU(NY,NX),NY,NX)*VLNO3(NU(NY,NX),NY,NX)
      VOLWOB=VOLWM(M,NU(NY,NX),NY,NX)*VLNOB(NU(NY,NX),NY,NX)
      VOLWPA=VOLWM(M,NU(NY,NX),NY,NX)*VLPO4(NU(NY,NX),NY,NX)
      VOLWPB=VOLWM(M,NU(NY,NX),NY,NX)*VLPOB(NU(NY,NX),NY,NX)
      VOLPMA(NU(NY,NX),NY,NX)=VOLPM(M,NU(NY,NX),NY,NX)
     2*VLNH4(NU(NY,NX),NY,NX)
      VOLPMB(NU(NY,NX),NY,NX)=VOLPM(M,NU(NY,NX),NY,NX)
     2*VLNHB(NU(NY,NX),NY,NX)
      FLVM(NU(NY,NX),NY,NX)=FLPM(M,NU(NY,NX),NY,NX)*XNPT
      FLQM(3,NU(NY,NX),NY,NX)=(FLWM(M,3,NU(NY,NX),NY,NX)
     2+FLWHM(M,3,NU(NY,NX),NY,NX))*XNPT
C
C     SURFACE EXCHANGE OF AQUEOUS CO2, CH4, O2, N2, NH3
C     THROUGH VOLATILIZATION-DISSOLUTION FROM AQUEOUS
C     DIFFUSIVITIES IN SURFACE RESIDUE
C
C     VOLT,DLYR,AREA=litter volume, thickness, area
C     VOLWM=micropore water-filled porosity from watsub.f
C     TORT=tortuosity from hour1.f
C     *SGL*=solute diffusivity
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     DFGS*=effective solute diffusivity
C     CO2S,CH4S,OXYS,Z2GS,Z2OS,H2GS=aqueous CO2,CH4,O2,N2,N2O,H2 in litter
C     OQC,OQN,OQP,OQA=DOC,DON,DOP,acetate in litter
C     ZNH4S,ZNH3S,ZNO3S,ZNO2S,H1PO4,H2PO4=aqueous NH4,NH3,NO3,NO2,HPO4,H2PO4 in litter
C     C*1=solute concentration in litter
C
      IF(VOLT(0,NY,NX).GT.ZEROS2(NY,NX)
     2.AND.VOLWM(M,0,NY,NX).GT.ZEROS2(NY,NX))THEN
      DLYR0=AMAX1(ZERO2,DLYR(3,0,NY,NX))
      TORT0=TORT(M,0,NY,NX)*AREA(3,NU(NY,NX),NY,NX)
     2/(0.5*DLYR0)*CVRD(NY,NX)
      DFGSCO=CLSGL2(0,NY,NX)*TORT0
      DFGSCH=CQSGL2(0,NY,NX)*TORT0
      DFGSOX=OLSGL2(0,NY,NX)*TORT0
      DFGSNG=ZLSGL2(0,NY,NX)*TORT0
      DFGSN2=ZNSGL2(0,NY,NX)*TORT0
      DFGSN3=ZVSGL2(0,NY,NX)*TORT0
      DFGSHL=HLSGL2(0,NY,NX)*TORT0
      DO 8810 K=0,4
      COQC1(K)=AMAX1(0.0,OQC2(K,0,NY,NX)/VOLWM(M,0,NY,NX))
      COQN1(K)=AMAX1(0.0,OQN2(K,0,NY,NX)/VOLWM(M,0,NY,NX))
      COQP1(K)=AMAX1(0.0,OQP2(K,0,NY,NX)/VOLWM(M,0,NY,NX))
      COQA1(K)=AMAX1(0.0,OQA2(K,0,NY,NX)/VOLWM(M,0,NY,NX))
8810  CONTINUE
      CCO2S1=AMAX1(0.0,CO2S2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CCH4S1=AMAX1(0.0,CH4S2(0,NY,NX)/VOLWM(M,0,NY,NX))
      COXYS1=AMAX1(0.0,OXYS2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CZ2GS1=AMAX1(0.0,Z2GS2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CZ2OS1=AMAX1(0.0,Z2OS2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CH2GS1=AMAX1(0.0,H2GS2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CNH4S1=AMAX1(0.0,ZNH4S2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CNH3S1=AMAX1(0.0,ZNH3S2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CNO3S1=AMAX1(0.0,ZNO3S2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CNO2S1=AMAX1(0.0,ZNO2S2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CP14S1=AMAX1(0.0,H1PO42(0,NY,NX)/VOLWM(M,0,NY,NX))
      CPO4S1=AMAX1(0.0,H2PO42(0,NY,NX)/VOLWM(M,0,NY,NX))
C
C     EQUILIBRIUM CONCENTRATIONS AT RESIDUE SURFACE AT WHICH
C     AQUEOUS DIFFUSION THROUGH RESIDUE SURFACE LAYER = GASEOUS
C     DIFFUSION THROUGH ATMOSPHERE BOUNDARY LAYER CALCULATED
C     FROM AQUEOUS DIFFUSIVITY AND BOUNDARY LAYER CONDUCTANCE
C
C     PARR=boundary layer conductance above litter surface from watsub.f
C     C*E=atmospheric gas concentration from hour1.f
C     C*Q=equilibrium gas concentration at litter surface
C     S*L=solubility of gas in water from hour1.f
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C     DFGS*=effective solute diffusivity
C
      CCO2GQ=(PARR(NY,NX)*CCO2E(NY,NX)*SCO2L(0,NY,NX)+DFGSCO*CCO2S1)
     2/(DFGSCO+PARR(NY,NX))
      CCH4GQ=(PARR(NY,NX)*CCH4E(NY,NX)*SCH4L(0,NY,NX)+DFGSCH*CCH4S1)
     2/(DFGSCH+PARR(NY,NX))
      COXYGQ=(PARR(NY,NX)*COXYE(NY,NX)*SOXYL(0,NY,NX)+DFGSOX*COXYS1)
     2/(DFGSOX+PARR(NY,NX))
      CZ2GGQ=(PARR(NY,NX)*CZ2GE(NY,NX)*SN2GL(0,NY,NX)+DFGSNG*CZ2GS1)
     2/(DFGSNG+PARR(NY,NX))
      CZ2OGQ=(PARR(NY,NX)*CZ2OE(NY,NX)*SN2OL(0,NY,NX)+DFGSN2*CZ2OS1)
     2/(DFGSN2+PARR(NY,NX))
      CZN3GQ=(PARR(NY,NX)*CNH3E(NY,NX)*SNH3L(0,NY,NX)+DFGSN3*CNH3S1)
     2/(DFGSN3+PARR(NY,NX))
      CH2GGQ=(PARR(NY,NX)*CH2GE(NY,NX)*SH2GL(0,NY,NX)+DFGSHL*CH2GS1)
     2/(DFGSHL+PARR(NY,NX))
C
C     SURFACE VOLATILIZATION-DISSOLUTION FROM DIFFERENCES
C     BETWEEN ATMOSPHERIC AND RESIDUE SURFACE EQUILIBRIUM
C     CONCENTRATIONS
C
C     R*DFR,X*DFR=current,hourly gas exchange between atmosphere and surface litter water
C     gas code: *CO*=CO2,*CH*=CH4,*OX*=O2,*NG*=N2,*N2*=N2O,*N3*=NH3,*HG*=H2
C     C*E=atmospheric gas concentration from hour1.f
C     C*Q=equilibrium gas concentration at litter surface
C     VOLWM=litter water volume
C     DFGS*=effective solute diffusivity
C     XNPT=1/number of cycles NPH-1 for gas flux calculations
C     R*DXR=R*DFR for gas flux calculations
C
      RCODFR(NY,NX)=(CCO2GQ-CCO2S1)*AMIN1(VOLWM(M,0,NY,NX),DFGSCO)
      RCHDFR(NY,NX)=(CCH4GQ-CCH4S1)*AMIN1(VOLWM(M,0,NY,NX),DFGSCH)
      ROXDFR(NY,NX)=(COXYGQ-COXYS1)*AMIN1(VOLWM(M,0,NY,NX),DFGSOX)
      RNGDFR(NY,NX)=(CZ2GGQ-CZ2GS1)*AMIN1(VOLWM(M,0,NY,NX),DFGSNG)
      RN2DFR(NY,NX)=(CZ2OGQ-CZ2OS1)*AMIN1(VOLWM(M,0,NY,NX),DFGSN2)
      RN3DFR(NY,NX)=(CZN3GQ-CNH3S1)*AMIN1(VOLWM(M,0,NY,NX),DFGSN3)
      RHGDFR(NY,NX)=(CH2GGQ-CH2GS1)*AMIN1(VOLWM(M,0,NY,NX),DFGSHL)
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
      XCODFR(NY,NX)=XCODFR(NY,NX)+RCODFR(NY,NX)
      XCHDFR(NY,NX)=XCHDFR(NY,NX)+RCHDFR(NY,NX)
      XOXDFR(NY,NX)=XOXDFR(NY,NX)+ROXDFR(NY,NX)
      XNGDFR(NY,NX)=XNGDFR(NY,NX)+RNGDFR(NY,NX)
      XN2DFR(NY,NX)=XN2DFR(NY,NX)+RN2DFR(NY,NX)
      XN3DFR(NY,NX)=XN3DFR(NY,NX)+RN3DFR(NY,NX)
      XHGDFR(NY,NX)=XHGDFR(NY,NX)+RHGDFR(NY,NX)
C     IF(J.EQ.24)THEN
C     WRITE(*,1118)'RCODFR',I,J,NX,NY,M,MM,NU(NY,NX),RCODFR(NY,NX)
C    2,PARR(NY,NX),CO2S2(0,NY,NX),CCO2E(NY,NX),CCO2Q,DFGSCO
C    3,DCO21,CCO22,SCO2L(0,NY,NX),TORT1
C    4,DLYR(3,0,NY,NX),VOLWM(M,0,NY,NX)
C     WRITE(*,1118)'RCHDFR',I,J,NX,NY,M,MM,NU(NY,NX),RCHDFR(NY,NX)
C    2,CH4GQ,CH4S2(0,NY,NX),PARR(NY,NX),CCH4E(NY,NX)
C    3,VOLWCH(0,NY,NX),DFGSCH,TORT(M,0,NY,NX)
C     WRITE(*,1118)'ROXDFR',I,J,NX,NY,M,MM,NU(NY,NX),ROXDFR(NY,NX)
C    2,XOXDFR(NY,NX),COXYGQ,COXYS1,PARR(NY,NX),DFGSOX,COXYE(NY,NX)
C    3,TORT(M,0,NY,NX),VOLWM(M,0,NY,NX),VOLT(0,NY,NX),DLYR(3,0,NY,NX)
1118  FORMAT(A8,7I4,30E12.4)
C     ENDIF
      ELSE
      RCODFR(NY,NX)=0.0
      RCHDFR(NY,NX)=0.0
      ROXDFR(NY,NX)=0.0
      RNGDFR(NY,NX)=0.0
      RN2DFR(NY,NX)=0.0
      RN3DFR(NY,NX)=0.0
      RHGDFR(NY,NX)=0.0
      ENDIF
      RCODXR=RCODFR(NY,NX)*XNPT
      RCHDXR=RCHDFR(NY,NX)*XNPT
      ROXDXR=ROXDFR(NY,NX)*XNPT
      RNGDXR=RNGDFR(NY,NX)*XNPT
      RN2DXR=RN2DFR(NY,NX)*XNPT
      RN3DXR=RN3DFR(NY,NX)*XNPT
      RHGDXR=RHGDFR(NY,NX)*XNPT
C
C     SURFACE EXCHANGE OF AQUEOUS CO2, CH4, O2, N2, NH3
C     THROUGH VOLATILIZATION-DISSOLUTION FROM AQUEOUS
C     DIFFUSIVITIES IN SURFACE SOIL LAYER
C
C     VOLWM=micropore water-filled porosity from watsub.f
C     TORT=tortuosity from hour1.f
C     *SGL*=solute diffusivity
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     DFGS*=effective solute diffusivity
C     C*2=solute concentration in soil surface
C     CO2S,CH4S,OXYS,Z2GS,Z2OS,H2GS=aqueous CO2,CH4,O2,N2,N2O,H2 in soil
C     OQC,OQN,OQP,OQA=DOC,DON,DOP,acetate in litter
C     ZNH4S,ZNH3S,ZNO3S,ZNO2S,H1PO4,H2PO4=aqueous NH4,NH3,NO3,NO2,HPO4,H2PO4 in non-band micropores
C     ZNH4B,ZNH3B,ZNO3B,ZNO2B,H1POB,H2POB=aqueous NH4,NH3,NO3,NO2,HPO4,H2PO4 in band micropores
C
      IF(VOLWM(M,NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      DLYR1=AMAX1(ZERO2,DLYR(3,NU(NY,NX),NY,NX))
      TORT1=TORT(M,NU(NY,NX),NY,NX)*AREA(3,NU(NY,NX),NY,NX)
     2/(0.5*DLYR1)
      DFGSCO=CLSGL2(NU(NY,NX),NY,NX)*TORT1
      DFGSCH=CQSGL2(NU(NY,NX),NY,NX)*TORT1
      DFGSOX=OLSGL2(NU(NY,NX),NY,NX)*TORT1
      DFGSNG=ZLSGL2(NU(NY,NX),NY,NX)*TORT1
      DFGSN2=ZNSGL2(NU(NY,NX),NY,NX)*TORT1
      DFGSN3=ZVSGL2(NU(NY,NX),NY,NX)*TORT1
      DFGSHL=HLSGL2(NU(NY,NX),NY,NX)*TORT1
      DO 8910 K=0,4
      COQC2(K)=AMAX1(0.0,OQC2(K,NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
      COQN2(K)=AMAX1(0.0,OQN2(K,NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
      COQP2(K)=AMAX1(0.0,OQP2(K,NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
      COQA2(K)=AMAX1(0.0,OQA2(K,NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
8910  CONTINUE
      CCO2S2=AMAX1(0.0,CO2S2(NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
      CCH4S2=AMAX1(0.0,CH4S2(NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
      COXYS2=AMAX1(0.0,OXYS2(NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
      CZ2GS2=AMAX1(0.0,Z2GS2(NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
      CZ2OS2=AMAX1(0.0,Z2OS2(NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
      CH2GS2=AMAX1(0.0,H2GS2(NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX))
      IF(VOLWMA(NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      CNH3S2=AMAX1(0.0,ZNH3S2(NU(NY,NX),NY,NX)
     2/VOLWMA(NU(NY,NX),NY,NX))
      CNH4S2=AMAX1(0.0,ZNH4S2(NU(NY,NX),NY,NX)
     2/VOLWMA(NU(NY,NX),NY,NX))
      ELSE
      CNH3S2=0.0
      CNH4S2=0.0
      ENDIF
      IF(VOLWOA.GT.ZEROS2(NY,NX))THEN
      CNO3S2=AMAX1(0.0,ZNO3S2(NU(NY,NX),NY,NX)/VOLWOA)
      CNO2S2=AMAX1(0.0,ZNO2S2(NU(NY,NX),NY,NX)/VOLWOA)
      ELSE
      CNO3S2=0.0
      CNO2S2=0.0
      ENDIF
      IF(VOLWPA.GT.ZEROS2(NY,NX))THEN
      CP14S2=AMAX1(0.0,H1PO42(NU(NY,NX),NY,NX)/VOLWPA)
      CPO4S2=AMAX1(0.0,H2PO42(NU(NY,NX),NY,NX)/VOLWPA)
      ELSE
      CP14S2=0.0
      CPO4S2=0.0
      ENDIF
      IF(VOLWMB(NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      CNH3B2=AMAX1(0.0,ZNH3B2(NU(NY,NX),NY,NX)
     2/VOLWMB(NU(NY,NX),NY,NX))
      CNH4B2=AMAX1(0.0,ZNH4B2(NU(NY,NX),NY,NX)
     2/VOLWMB(NU(NY,NX),NY,NX))
      ELSE
      CNH3B2=CNH3S2
      CNH4B2=CNH4S2
      ENDIF
      IF(VOLWOB.GT.ZEROS2(NY,NX))THEN
      CNO3B2=AMAX1(0.0,ZNO3B2(NU(NY,NX),NY,NX)/VOLWOB)
      CNO2B2=AMAX1(0.0,ZNO2B2(NU(NY,NX),NY,NX)/VOLWOB)
      ELSE
      CNO3B2=CNO3S2
      CNO2B2=CNO2S2
      ENDIF
      IF(VOLWPB.GT.ZEROS2(NY,NX))THEN
      CP14B2=AMAX1(0.0,H1POB2(NU(NY,NX),NY,NX)/VOLWPB)
      CPO4B2=AMAX1(0.0,H2POB2(NU(NY,NX),NY,NX)/VOLWPB)
      ELSE
      CP14B2=CP14S2
      CPO4B2=CPO4S2
      ENDIF
C
C     EQUILIBRIUM CONCENTRATIONS AT SOIL SURFACE AT WHICH
C     AQUEOUS DIFFUSION THROUGH SOIL SURFACE LAYER = GASEOUS
C     DIFFUSION THROUGH ATMOSPHERE BOUNDARY LAYER CALCULATED
C     FROM AQUEOUS DIFFUSIVITY AND BOUNDARY LAYER CONDUCTANCE
C
C     PARG=boundary layer conductance above soil surface from watsub.f
C     C*E=atmospheric gas concentration from hour1.f
C     C*Q=equilibrium gas concentration at soil surface
C     S*L=solubility of gas in water from hour1.f
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C     DFGS*=effective solute diffusivity
C
      CCO2GQ=(PARG(M,NY,NX)*CCO2E(NY,NX)*SCO2L(NU(NY,NX),NY,NX)
     2+DFGSCO*CCO2S2)/(DFGSCO+PARG(M,NY,NX))
      CCH4GQ=(PARG(M,NY,NX)*CCH4E(NY,NX)*SCH4L(NU(NY,NX),NY,NX)
     2+DFGSCH*CCH4S2)/(DFGSCH+PARG(M,NY,NX))
      COXYGQ=(PARG(M,NY,NX)*COXYE(NY,NX)*SOXYL(NU(NY,NX),NY,NX)
     2+DFGSOX*COXYS2)/(DFGSOX+PARG(M,NY,NX))
      CZ2GGQ=(PARG(M,NY,NX)*CZ2GE(NY,NX)*SN2GL(NU(NY,NX),NY,NX)
     2+DFGSNG*CZ2GS2)/(DFGSNG+PARG(M,NY,NX))
      CZ2OGQ=(PARG(M,NY,NX)*CZ2OE(NY,NX)*SN2OL(NU(NY,NX),NY,NX)
     2+DFGSN2*CZ2OS2)/(DFGSN2+PARG(M,NY,NX))
      CZN3GQ=(PARG(M,NY,NX)*CNH3E(NY,NX)*SNH3L(NU(NY,NX),NY,NX)
     2+DFGSN3*CNH3S2)/(DFGSN3+PARG(M,NY,NX))
      CZN3BQ=(PARG(M,NY,NX)*CNH3E(NY,NX)*SNH3L(NU(NY,NX),NY,NX)
     2+DFGSN3*CNH3B2)/(DFGSN3+PARG(M,NY,NX))
      CH2GGQ=(PARG(M,NY,NX)*CH2GE(NY,NX)*SH2GL(NU(NY,NX),NY,NX)
     2+DFGSHL*CH2GS2)/(DFGSHL+PARG(M,NY,NX))
C
C     SURFACE VOLATILIZATION-DISSOLUTION FROM DIFFERENCES
C     BETWEEN ATMOSPHERIC AND SOIL SURFACE EQUILIBRIUM
C     CONCENTRATIONS
C
C     R*DFS,X*DFS=current,cumulative gas exchange between atmosphere and soil surface water
C     gas code:*CO*=CO2,*CH*=CH4,*OX*=O2,*NG*=N2,*N2*=N2O,*N3*=NH3,*HG*=H2
C     C*E=atmospheric gas concentration from hour1.f
C     C*Q=equilibrium gas concentration at soil surface
C     VOLWM=litter water volume
C     DFGS*=effective solute diffusivity
C     XNPT=1/number of cycles NPH-1 for gas flux calculations
C     R*DXS=R*DFS for gas flux calculations
C
      RCODFS(NY,NX)=(CCO2GQ-CCO2S2)*AMIN1(VOLWM(M,NU(NY,NX),NY,NX)
     2,DFGSCO)
      RCHDFS(NY,NX)=(CCH4GQ-CCH4S2)*AMIN1(VOLWM(M,NU(NY,NX),NY,NX)
     2,DFGSCH)
      ROXDFS(NY,NX)=(COXYGQ-COXYS2)*AMIN1(VOLWM(M,NU(NY,NX),NY,NX)
     2,DFGSOX)
      RNGDFS(NY,NX)=(CZ2GGQ-CZ2GS2)*AMIN1(VOLWM(M,NU(NY,NX),NY,NX)
     2,DFGSNG)
      RN2DFS(NY,NX)=(CZ2OGQ-CZ2OS2)*AMIN1(VOLWM(M,NU(NY,NX),NY,NX)
     2,DFGSN2)
      RN3DFS(NY,NX)=(CZN3GQ-CNH3S2)*AMIN1(VOLWM(M,NU(NY,NX),NY,NX)
     2*VLNH4(NU(NY,NX),NY,NX),DFGSN3)
      RNBDFS(NY,NX)=(CZN3BQ-CNH3B2)*AMIN1(VOLWM(M,NU(NY,NX),NY,NX)
     2*VLNHB(NU(NY,NX),NY,NX),DFGSN3)
      RHGDFS(NY,NX)=(CH2GGQ-CH2GS2)*AMIN1(VOLWM(M,NU(NY,NX),NY,NX)
     2,DFGSHL)
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
      XCODFS(NY,NX)=XCODFS(NY,NX)+RCODFS(NY,NX)
      XCHDFS(NY,NX)=XCHDFS(NY,NX)+RCHDFS(NY,NX)
      XOXDFS(NY,NX)=XOXDFS(NY,NX)+ROXDFS(NY,NX)
      XNGDFS(NY,NX)=XNGDFS(NY,NX)+RNGDFS(NY,NX)
      XN2DFS(NY,NX)=XN2DFS(NY,NX)+RN2DFS(NY,NX)
      XN3DFS(NY,NX)=XN3DFS(NY,NX)+RN3DFS(NY,NX)
      XNBDFS(NY,NX)=XNBDFS(NY,NX)+RNBDFS(NY,NX)
      XHGDFS(NY,NX)=XHGDFS(NY,NX)+RHGDFS(NY,NX)
C     IF(J.EQ.24)THEN
C     WRITE(*,1118)'RCODFS',I,J,NX,NY,M,MM,NU(NY,NX),RCODFS(NY,NX)
C    2,XCODFS(NY,NX),CO2GQ,CO2S2X,CO2S2(NU(NY,NX),NY,NX),PARG(M,NY,NX)
C    3,CCO2E(NY,NX),VOLWCO(NU(NY,NX),NY,NX),DFGSCO
C    2,TORT(M,NU(NY,NX),NY,NX),CLSGL2(NU(NY,NX),NY,NX),TORT1
C    4,DLYR(3,NU(NY,NX),NY,NX),CO2S(NU(NY,NX),NY,NX)
C    5,RCOSK2(NU(NY,NX),NY,NX)
C     WRITE(*,1118)'RCHDFS',I,J,NX,NY,M,MM,NU(NY,NX),RCHDFS(NY,NX)
C    2,XCHDFS(NY,NX),CH4GQ,CH4S2X,CH4S2(NU(NY,NX),NY,NX),PARG(M,NY,NX)
C    3,CCH4E(NY,NX),VOLWCH(NU(NY,NX),NY,NX),DFGSCH,TORT(M,0,NY,NX)
C     WRITE(*,1118)'ROXDFS',I,J,NX,NY,M,MM,NU(NY,NX),ROXDFS(NY,NX)
C    2,XOXDFS(NY,NX),COXYGQ,COXYS2,OXYS2(NU(NY,NX),NY,NX),PARG(M,NY,NX)
C    3,COXYE(NY,NX),VOLWM(M,NU(NY,NX),NY,NX),DFGSOX,TORT(M,0,NY,NX)
C     WRITE(*,1118)'RNGDFS',I,J,NX,NY,M,MM,NU(NY,NX),RNGDFS(NY,NX)
C    2,XNGDFS(NY,NX),Z2GGQ,Z2GS2X,Z2GS2(NU(NY,NX),NY,NX),PARG(M,NY,NX)
C    3,CZ2GE(NY,NX),VOLWNG(NU(NY,NX),NY,NX),DFGSNG,TORT(M,0,NY,NX)
C     WRITE(*,1118)'RN2DFS',I,J,NX,NY,M,MM,NU(NY,NX),RN2DFS(NY,NX)
C    2,XN2DFS(NY,NX),Z2OGQ,Z2OS2X,Z2OS2(NU(NY,NX),NY,NX),PARG(M,NY,NX)
C    3,CZ2OE(NY,NX),VOLWN2(NU(NY,NX),NY,NX),DFGSN2,TORT(M,0,NY,NX)
C    4,VOLWM(M,NU(NY,NX),NY,NX),SN2OL(NU(NY,NX),NY,NX)
C    5,TKS(NU(NY,NX),NY,NX)
C     WRITE(*,1118)'RN3DFS',I,J,NX,NY,M,MM,NU(NY,NX),RN3DFS(NY,NX)
C    2,XN3DFS(NY,NX),ZN3GQ,ZN3S2X,PARG(M,NY,NX),CNH3E(NY,NX)
C    3,VOLWN3(NU(NY,NX),NY,NX),DFGSN3,ZNH3S2(NU(NY,NX),NY,NX)
C    4,ZN3G2(NU(NY,NX),NY,NX)
C     ENDIF
      ELSE
      RCODFS(NY,NX)=0.0
      RCHDFS(NY,NX)=0.0
      ROXDFS(NY,NX)=0.0
      RNGDFS(NY,NX)=0.0
      RN2DFS(NY,NX)=0.0
      RN3DFS(NY,NX)=0.0
      RNBDFS(NY,NX)=0.0
      RHGDFS(NY,NX)=0.0
      ENDIF
      RCODXS=RCODFS(NY,NX)*XNPT
      RCHDXS=RCHDFS(NY,NX)*XNPT
      ROXDXS=ROXDFS(NY,NX)*XNPT
      RNGDXS=RNGDFS(NY,NX)*XNPT
      RN2DXS=RN2DFS(NY,NX)*XNPT
      RN3DXS=RN3DFS(NY,NX)*XNPT
      RNBDXS=RNBDFS(NY,NX)*XNPT
      RHGDXS=RHGDFS(NY,NX)*XNPT
C
C     CONVECTIVE SOLUTE EXCHANGE BETWEEN RESIDUE AND SOIL SURFACE
C
      FLWRM1=FLWRM(M,NY,NX)
C
C     FLWRM=litter-soil water flux from watsub.f
C
C     IF WATER FLUX FROM 'WATSUB' IS FROM RESIDUE TO
C     SOIL SURFACE THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MICROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN RESIDUE
C
C     VOLWM=litter water volume
C     RFL*=soil-litter convective solute flux
C     *S2=litter solute content
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C
      IF(FLWRM1.GT.0.0)THEN
      IF(VOLWM(M,0,NY,NX).GT.ZEROS2(NY,NX))THEN
      VFLW=AMAX1(0.0,AMIN1(VFLWX,FLWRM1/VOLWM(M,0,NY,NX)))
      ELSE
      VFLW=VFLWX
      ENDIF
      DO 8820 K=0,4
      RFLOC(K)=VFLW*AMAX1(0.0,OQC2(K,0,NY,NX))
      RFLON(K)=VFLW*AMAX1(0.0,OQN2(K,0,NY,NX))
      RFLOP(K)=VFLW*AMAX1(0.0,OQP2(K,0,NY,NX))
      RFLOA(K)=VFLW*AMAX1(0.0,OQA2(K,0,NY,NX))
8820  CONTINUE
      RFLCOS=VFLW*AMAX1(0.0,CO2S2(0,NY,NX))
      RFLCHS=VFLW*AMAX1(0.0,CH4S2(0,NY,NX))
      RFLOXS=VFLW*AMAX1(0.0,OXYS2(0,NY,NX))
      RFLNGS=VFLW*AMAX1(0.0,Z2GS2(0,NY,NX))
      RFLN2S=VFLW*AMAX1(0.0,Z2OS2(0,NY,NX))
      RFLHGS=VFLW*AMAX1(0.0,H2GS2(0,NY,NX))
      RFLNH4=VFLW*AMAX1(0.0,ZNH4S2(0,NY,NX))*VLNH4(NU(NY,NX),NY,NX)
      RFLNH3=VFLW*AMAX1(0.0,ZNH3S2(0,NY,NX))*VLNH4(NU(NY,NX),NY,NX)
      RFLNO3=VFLW*AMAX1(0.0,ZNO3S2(0,NY,NX))*VLNO3(NU(NY,NX),NY,NX)
      RFLNO2=VFLW*AMAX1(0.0,ZNO2S2(0,NY,NX))*VLNO3(NU(NY,NX),NY,NX)
      RFLP14=VFLW*AMAX1(0.0,H1PO42(0,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      RFLPO4=VFLW*AMAX1(0.0,H2PO42(0,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      RFLN4B=VFLW*AMAX1(0.0,ZNH4S2(0,NY,NX))*VLNHB(NU(NY,NX),NY,NX)
      RFLN3B=VFLW*AMAX1(0.0,ZNH3S2(0,NY,NX))*VLNHB(NU(NY,NX),NY,NX)
      RFLNOB=VFLW*AMAX1(0.0,ZNO3S2(0,NY,NX))*VLNOB(NU(NY,NX),NY,NX)
      RFLN2B=VFLW*AMAX1(0.0,ZNO2S2(0,NY,NX))*VLNOB(NU(NY,NX),NY,NX)
      RFLP1B=VFLW*AMAX1(0.0,H1PO42(0,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      RFLPOB=VFLW*AMAX1(0.0,H2PO42(0,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
C
C     IF WATER FLUX FROM 'WATSUB' IS TO RESIDUE FROM
C     SOIL SURFACE THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MICROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN SOIL SURFACE
C
C     VOLWM=micropore water-filled porosity from watsub.f
C     RFL*=soil-litter convective solute flux
C     *S2=soil solute content
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C
      ELSE
      IF(VOLWM(M,NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      VFLW=AMIN1(0.0,AMAX1(-VFLWX,FLWRM1/VOLWM(M,NU(NY,NX),NY,NX)))
      ELSE
      VFLW=-VFLWX
      ENDIF
      DO 8815 K=0,4
      RFLOC(K)=VFLW*AMAX1(0.0,OQC2(K,NU(NY,NX),NY,NX))
      RFLON(K)=VFLW*AMAX1(0.0,OQN2(K,NU(NY,NX),NY,NX))
      RFLOP(K)=VFLW*AMAX1(0.0,OQP2(K,NU(NY,NX),NY,NX))
      RFLOA(K)=VFLW*AMAX1(0.0,OQA2(K,NU(NY,NX),NY,NX))
8815  CONTINUE
      RFLCOS=VFLW*AMAX1(0.0,CO2S2(NU(NY,NX),NY,NX))
      RFLCHS=VFLW*AMAX1(0.0,CH4S2(NU(NY,NX),NY,NX))
      RFLOXS=VFLW*AMAX1(0.0,OXYS2(NU(NY,NX),NY,NX))
      RFLNGS=VFLW*AMAX1(0.0,Z2GS2(NU(NY,NX),NY,NX))
      RFLN2S=VFLW*AMAX1(0.0,Z2OS2(NU(NY,NX),NY,NX))
      RFLHGS=VFLW*AMAX1(0.0,H2GS2(NU(NY,NX),NY,NX))
      RFLNH4=VFLW*AMAX1(0.0,ZNH4S2(NU(NY,NX),NY,NX))
      RFLNH3=VFLW*AMAX1(0.0,ZNH3S2(NU(NY,NX),NY,NX))
      RFLNO3=VFLW*AMAX1(0.0,ZNO3S2(NU(NY,NX),NY,NX))
      RFLNO2=VFLW*AMAX1(0.0,ZNO2S2(NU(NY,NX),NY,NX))
      RFLP14=VFLW*AMAX1(0.0,H1PO42(NU(NY,NX),NY,NX))
      RFLPO4=VFLW*AMAX1(0.0,H2PO42(NU(NY,NX),NY,NX))
      RFLN4B=VFLW*AMAX1(0.0,ZNH4B2(NU(NY,NX),NY,NX))
      RFLN3B=VFLW*AMAX1(0.0,ZNH3B2(NU(NY,NX),NY,NX))
      RFLNOB=VFLW*AMAX1(0.0,ZNO3B2(NU(NY,NX),NY,NX))
      RFLN2B=VFLW*AMAX1(0.0,ZNO2B2(NU(NY,NX),NY,NX))
      RFLP1B=VFLW*AMAX1(0.0,H1POB2(NU(NY,NX),NY,NX))
      RFLPOB=VFLW*AMAX1(0.0,H2POB2(NU(NY,NX),NY,NX))
      ENDIF
C
C     DIFFUSIVE FLUXES OF GASES AND SOLUTES BETWEEN RESIDUE AND
C     SOIL SURFACE FROM AQUEOUS DIFFUSIVITIES
C     AND CONCENTRATION DIFFERENCES
C
C     VOLT,DLYR,AREA=soil surface volume, thickness, area
C     VOLWM=micropore water-filled porosity from watsub.f
C
      IF((VOLT(0,NY,NX).GT.ZEROS2(NY,NX)
     2.AND.VOLWM(M,0,NY,NX).GT.ZEROS2(NY,NX))
     3.AND.(VOLWM(M,NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX)))THEN
C
C     DIFFUSIVITIES IN RESIDUE AND SOIL SURFACE
C
C     DLYR0,DLYR1=litter, soil surface thickness
C     TORT=tortuosity from hour1.f
C     CVRD,BARE=litter cover fraction,1-CVRD
C     DISP=dispersivity parameter
C     FLWRM=litter-soil water flux from watsub.f
C     DIF*0,DIF*1=aqueous diffusivity-dispersivity in litter, soil surface
C     *SGL*=solute diffusivity from hour1.f
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     DIF*=aqueous diffusivity-dispersivity between litter and soil surface
C
      DLYR0=AMAX1(ZERO2,DLYR(3,0,NY,NX))
      TORT0=TORT(M,0,NY,NX)/DLYR0*CVRD(NY,NX)
      DLYR1=AMAX1(ZERO2,DLYR(3,NU(NY,NX),NY,NX))
      TORT1=TORT(M,NU(NY,NX),NY,NX)/DLYR1
      DISPN=DISP(3,NU(NY,NX),NY,NX)
     2*AMIN1(VFLWX,ABS(FLWRM1/AREA(3,NU(NY,NX),NY,NX)))
      DIFOC0=(OCSGL2(0,NY,NX)*TORT0+DISPN)
      DIFON0=(ONSGL2(0,NY,NX)*TORT0+DISPN)
      DIFOP0=(OPSGL2(0,NY,NX)*TORT0+DISPN)
      DIFOA0=(OASGL2(0,NY,NX)*TORT0+DISPN)
      DIFNH0=(ZNSGL2(0,NY,NX)*TORT0+DISPN)
      DIFNO0=(ZOSGL2(0,NY,NX)*TORT0+DISPN)
      DIFPO0=(POSGL2(0,NY,NX)*TORT0+DISPN)
      DIFCS0=(CLSGL2(0,NY,NX)*TORT0+DISPN)
      DIFCQ0=(CQSGL2(0,NY,NX)*TORT0+DISPN)
      DIFOS0=(OLSGL2(0,NY,NX)*TORT0+DISPN)
      DIFNG0=(ZLSGL2(0,NY,NX)*TORT0+DISPN)
      DIFN20=(ZVSGL2(0,NY,NX)*TORT0+DISPN)
      DIFHG0=(HLSGL2(0,NY,NX)*TORT0+DISPN)
      DIFOC1=(OCSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFON1=(ONSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFOP1=(OPSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFOA1=(OASGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFNH1=(ZNSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFNO1=(ZOSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFPO1=(POSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFCS1=(CLSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFCQ1=(CQSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFOS1=(OLSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFNG1=(ZLSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFN21=(ZVSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFHG1=(HLSGL2(NU(NY,NX),NY,NX)*TORT1+DISPN)
      DIFOC=DIFOC0*DIFOC1/(DIFOC0+DIFOC1)*AREA(3,NU(NY,NX),NY,NX)
      DIFON=DIFON0*DIFON1/(DIFON0+DIFON1)*AREA(3,NU(NY,NX),NY,NX)
      DIFOP=DIFOP0*DIFOP1/(DIFOP0+DIFOP1)*AREA(3,NU(NY,NX),NY,NX)
      DIFOA=DIFOA0*DIFOA1/(DIFOA0+DIFOA1)*AREA(3,NU(NY,NX),NY,NX)
      DIFNH=DIFNH0*DIFNH1/(DIFNH0+DIFNH1)*AREA(3,NU(NY,NX),NY,NX)
      DIFNO=DIFNO0*DIFNO1/(DIFNO0+DIFNO1)*AREA(3,NU(NY,NX),NY,NX)
      DIFPO=DIFPO0*DIFPO1/(DIFPO0+DIFPO1)*AREA(3,NU(NY,NX),NY,NX)
      DIFCS=DIFCS0*DIFCS1/(DIFCS0+DIFCS1)*AREA(3,NU(NY,NX),NY,NX)
      DIFCQ=DIFCQ0*DIFCQ1/(DIFCQ0+DIFCQ1)*AREA(3,NU(NY,NX),NY,NX)
      DIFOS=DIFOS0*DIFOS1/(DIFOS0+DIFOS1)*AREA(3,NU(NY,NX),NY,NX)
      DIFNG=DIFNG0*DIFNG1/(DIFNG0+DIFNG1)*AREA(3,NU(NY,NX),NY,NX)
      DIFN2=DIFN20*DIFN21/(DIFN20+DIFN21)*AREA(3,NU(NY,NX),NY,NX)
      DIFHG=DIFHG0*DIFHG1/(DIFHG0+DIFHG1)*AREA(3,NU(NY,NX),NY,NX)
C
C     DIFFUSIVE FLUXES BETWEEN CURRENT AND ADJACENT GRID CELL
C     MICROPORES
C
C     DFV*S,DFV*B=diffusive solute flux between litter and soil surface in non-band,band
C     DIF*=aqueous diffusivity-dispersivity between litter and soil surface
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C     C*1,C*2=solute concentration in litter,soil surface
C
      DO 8805 K=0,4
      DFVOC(K)=DIFOC*(COQC1(K)-COQC2(K))
      DFVON(K)=DIFON*(COQN1(K)-COQN2(K))
      DFVOP(K)=DIFOP*(COQP1(K)-COQP2(K))
      DFVOA(K)=DIFOA*(COQA1(K)-COQA2(K))
8805  CONTINUE
      DFVCOS=DIFCS*(CCO2S1-CCO2S2)
      DFVCHS=DIFCQ*(CCH4S1-CCH4S2)
      DFVOXS=DIFOS*(COXYS1-COXYS2)
      DFVNGS=DIFNG*(CZ2GS1-CZ2GS2)
      DFVN2S=DIFN2*(CZ2OS1-CZ2OS2)
      DFVHGS=DIFHG*(CH2GS1-CH2GS2)
      DFVNH4=DIFNH*(CNH4S1-CNH4S2)*VLNH4(NU(NY,NX),NY,NX)
      DFVNH3=DIFNH*(CNH3S1-CNH3S2)*VLNH4(NU(NY,NX),NY,NX)
      DFVNO3=DIFNO*(CNO3S1-CNO3S2)*VLNO3(NU(NY,NX),NY,NX)
      DFVNO2=DIFNO*(CNO2S1-CNO2S2)*VLNO3(NU(NY,NX),NY,NX)
      DFVP14=DIFPO*(CP14S1-CP14S2)*VLPO4(NU(NY,NX),NY,NX)
      DFVPO4=DIFPO*(CPO4S1-CPO4S2)*VLPO4(NU(NY,NX),NY,NX)
      DFVN4B=DIFNH*(CNH4S1-CNH4B2)*VLNHB(NU(NY,NX),NY,NX)
      DFVN3B=DIFNH*(CNH3S1-CNH3B2)*VLNHB(NU(NY,NX),NY,NX)
      DFVNOB=DIFNO*(CNO3S1-CNO3B2)*VLNOB(NU(NY,NX),NY,NX)
      DFVN2B=DIFNO*(CNO2S1-CNO2B2)*VLNOB(NU(NY,NX),NY,NX)
      DFVP1B=DIFPO*(CP14S1-CP14B2)*VLPOB(NU(NY,NX),NY,NX)
      DFVPOB=DIFPO*(CPO4S1-CPO4B2)*VLPOB(NU(NY,NX),NY,NX)
      ELSE
      DO 8905 K=0,4
      DFVOC(K)=0.0
      DFVON(K)=0.0
      DFVOP(K)=0.0
      DFVOA(K)=0.0
8905  CONTINUE
      DFVCOS=0.0
      DFVCHS=0.0
      DFVOXS=0.0
      DFVNGS=0.0
      DFVN2S=0.0
      DFVHGS=0.0
      DFVNH4=0.0
      DFVNH3=0.0
      DFVNO3=0.0
      DFVNO2=0.0
      DFVP14=0.0
      DFVPO4=0.0
      DFVN4B=0.0
      DFVN3B=0.0
      DFVNOB=0.0
      DFVN2B=0.0
      DFVP1B=0.0
      DFVPOB=0.0
      ENDIF
C
C     TOTAL MICROPORE AND MACROPORE SOLUTE TRANSPORT FLUXES BETWEEN
C     ADJACENT GRID CELLS = CONVECTIVE + DIFFUSIVE FLUXES
C
C     R*FLS=convective + diffusive solute flux between litter, soil surface
C     R*FLW,R*FLB=convective + diffusive solute flux into soil in non-band,band
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     R*FL0,R*FL1=convective flux into surface litter, soil surface
C     RFL*=convective flux between surface litter and soil surface
C     DFV*=diffusive solute flux between litter and soil surface
C
      DO 9760 K=0,2
      ROCFLS(K,3,0,NY,NX)=ROCFL0(K,NY,NX)-RFLOC(K)-DFVOC(K)
      RONFLS(K,3,0,NY,NX)=RONFL0(K,NY,NX)-RFLON(K)-DFVON(K)
      ROPFLS(K,3,0,NY,NX)=ROPFL0(K,NY,NX)-RFLOP(K)-DFVOP(K)
      ROAFLS(K,3,0,NY,NX)=ROAFL0(K,NY,NX)-RFLOA(K)-DFVOA(K)
      ROCFLS(K,3,NU(NY,NX),NY,NX)=ROCFL1(K,NY,NX)+RFLOC(K)+DFVOC(K)
      RONFLS(K,3,NU(NY,NX),NY,NX)=RONFL1(K,NY,NX)+RFLON(K)+DFVON(K)
      ROPFLS(K,3,NU(NY,NX),NY,NX)=ROPFL1(K,NY,NX)+RFLOP(K)+DFVOP(K)
      ROAFLS(K,3,NU(NY,NX),NY,NX)=ROAFL1(K,NY,NX)+RFLOA(K)+DFVOA(K)
9760  CONTINUE
      RCOFLS(3,0,NY,NX)=RCOFL0(NY,NX)+RCOFLS0-RFLCOS-DFVCOS
C     IF(I.GE.360)THEN
C     WRITE(*,8788)'RCOFLS0',I,J,M,MM,NX,NY,NU(NY,NX)
C    2,RCOFLS(3,0,NY,NX)
C    2,RCOFL0(NY,NX),RCOFLS0,RFLCOS,DFVCOS,VFLW,CO2S2(0,NY,NX)
C    3,DIFCS,CCO2S1,CCO2S2,DIFCS0,DIFCS1,CO2S2(NU(NY,NX),NY,NX)
C    4,VOLWM(M,NU(NY,NX),NY,NX)
8788  FORMAT(A8,7I4,20E12.4)
C     ENDIF
      RCHFLS(3,0,NY,NX)=RCHFL0(NY,NX)+RCHFLS0-RFLCHS-DFVCHS
      ROXFLS(3,0,NY,NX)=ROXFL0(NY,NX)+ROXFLS0-RFLOXS-DFVOXS
      RNGFLS(3,0,NY,NX)=RNGFL0(NY,NX)+RNGFLS0-RFLNGS-DFVNGS
      RN2FLS(3,0,NY,NX)=RN2FL0(NY,NX)+RN2FLS0-RFLN2S-DFVN2S
      RHGFLS(3,0,NY,NX)=RHGFL0(NY,NX)-RFLHGS-DFVHGS
      RN4FLW(3,0,NY,NX)=RN4FL0(NY,NX)+RN4FLW0-RFLNH4-DFVNH4-RFLN4B
     2-DFVN4B
      RN3FLW(3,0,NY,NX)=RN3FL0(NY,NX)+RN3FLW0-RFLNH3-DFVNH3-RFLN3B
     2-DFVN3B
      RNOFLW(3,0,NY,NX)=RNOFL0(NY,NX)+RNOFLW0-RFLNO3-DFVNO3-RFLNOB
     2-DFVNOB
      RNXFLS(3,0,NY,NX)=RNXFL0(NY,NX)-RFLNO2-DFVNO2-RFLN2B-DFVN2B
      RH1PFS(3,0,NY,NX)=RH1PF0(NY,NX)+RH1PFS0-RFLP14-DFVP14-RFLP1B
     2-DFVP1B
      RH2PFS(3,0,NY,NX)=RH2PF0(NY,NX)+RH2PFS0-RFLPO4-DFVPO4-RFLPOB
     2-DFVPOB
      RCOFLS(3,NU(NY,NX),NY,NX)=RCOFL1(NY,NX)+RCOFLS1+RFLCOS+DFVCOS
      RCHFLS(3,NU(NY,NX),NY,NX)=RCHFL1(NY,NX)+RCHFLS1+RFLCHS+DFVCHS
      ROXFLS(3,NU(NY,NX),NY,NX)=ROXFL1(NY,NX)+ROXFLS1+RFLOXS+DFVOXS
      RNGFLS(3,NU(NY,NX),NY,NX)=RNGFL1(NY,NX)+RNGFLS1+RFLNGS+DFVNGS
      RN2FLS(3,NU(NY,NX),NY,NX)=RN2FL1(NY,NX)+RN2FLS1+RFLN2S+DFVN2S
      RHGFLS(3,NU(NY,NX),NY,NX)=RHGFL1(NY,NX)+RFLHGS+DFVHGS
      RN4FLW(3,NU(NY,NX),NY,NX)=RN4FL1(NY,NX)+RN4FLW1+RFLNH4+DFVNH4
      RN3FLW(3,NU(NY,NX),NY,NX)=RN3FL1(NY,NX)+RN3FLW1+RFLNH3+DFVNH3
      RNOFLW(3,NU(NY,NX),NY,NX)=RNOFL1(NY,NX)+RNOFLW1+RFLNO3+DFVNO3
      RNXFLS(3,NU(NY,NX),NY,NX)=RNXFL1(NY,NX)+RFLNO2+DFVNO2
      RH1PFS(3,NU(NY,NX),NY,NX)=RH1PF1(NY,NX)+RH1PFS1+RFLP14+DFVP14
      RH2PFS(3,NU(NY,NX),NY,NX)=RH2PF1(NY,NX)+RH2PFS1+RFLPO4+DFVPO4
      RN4FLB(3,NU(NY,NX),NY,NX)=RN4FL2(NY,NX)+RN4FLB1+RFLN4B+DFVN4B
      RN3FLB(3,NU(NY,NX),NY,NX)=RN3FL2(NY,NX)+RN3FLB1+RFLN3B+DFVN3B
      RNOFLB(3,NU(NY,NX),NY,NX)=RNOFL2(NY,NX)+RNOFLB1+RFLNOB+DFVNOB
      RNXFLB(3,NU(NY,NX),NY,NX)=RNXFL2(NY,NX)+RFLN2B+DFVN2B
      RH1BFB(3,NU(NY,NX),NY,NX)=RH1BF2(NY,NX)+RH1BFB1+RFLP1B+DFVP1B
      RH2BFB(3,NU(NY,NX),NY,NX)=RH2BF2(NY,NX)+RH2BFB1+RFLPOB+DFVPOB
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*FLS=hourly convective + diffusive solute flux
C     X*FLW,X*FLB= hourly convective + diffusive solute flux in non-band,band
C
      DO 9761 K=0,2
      XOCFLS(K,3,0,NY,NX)=XOCFLS(K,3,0,NY,NX)
     2-RFLOC(K)-DFVOC(K)
      XONFLS(K,3,0,NY,NX)=XONFLS(K,3,0,NY,NX)
     2-RFLON(K)-DFVON(K)
      XOPFLS(K,3,0,NY,NX)=XOPFLS(K,3,0,NY,NX)
     2-RFLOP(K)-DFVOP(K)
      XOAFLS(K,3,0,NY,NX)=XOAFLS(K,3,0,NY,NX)
     2-RFLOA(K)-DFVOA(K)
      XOCFLS(K,3,NU(NY,NX),NY,NX)=XOCFLS(K,3,NU(NY,NX),NY,NX)
     2+RFLOC(K)+DFVOC(K)
      XONFLS(K,3,NU(NY,NX),NY,NX)=XONFLS(K,3,NU(NY,NX),NY,NX)
     2+RFLON(K)+DFVON(K)
      XOPFLS(K,3,NU(NY,NX),NY,NX)=XOPFLS(K,3,NU(NY,NX),NY,NX)
     2+RFLOP(K)+DFVOP(K)
      XOAFLS(K,3,NU(NY,NX),NY,NX)=XOAFLS(K,3,NU(NY,NX),NY,NX)
     2+RFLOA(K)+DFVOA(K)
9761  CONTINUE
      XCOFLS(3,0,NY,NX)=XCOFLS(3,0,NY,NX)+RCOFLS0-RFLCOS-DFVCOS
      XCHFLS(3,0,NY,NX)=XCHFLS(3,0,NY,NX)+RCHFLS0-RFLCHS-DFVCHS
      XOXFLS(3,0,NY,NX)=XOXFLS(3,0,NY,NX)+ROXFLS0-RFLOXS-DFVOXS
      XNGFLS(3,0,NY,NX)=XNGFLS(3,0,NY,NX)+RNGFLS0-RFLNGS-DFVNGS
      XN2FLS(3,0,NY,NX)=XN2FLS(3,0,NY,NX)+RN2FLS0-RFLN2S-DFVN2S
      XHGFLS(3,0,NY,NX)=XHGFLS(3,0,NY,NX)-RFLHGS-DFVHGS
      XN4FLW(3,0,NY,NX)=XN4FLW(3,0,NY,NX)+RN4FLW0-RFLNH4-DFVNH4
     2-RFLN4B-DFVN4B
      XN3FLW(3,0,NY,NX)=XN3FLW(3,0,NY,NX)+RN3FLW0-RFLNH3-DFVNH3
     2-RFLN3B-DFVN3B
      XNOFLW(3,0,NY,NX)=XNOFLW(3,0,NY,NX)+RNOFLW0-RFLNO3-DFVNO3
     2-RFLNOB-DFVNOB
      XNXFLS(3,0,NY,NX)=XNXFLS(3,0,NY,NX)-RFLNO2-DFVNO2
     2-RFLN2B-DFVN2B
      XH1PFS(3,0,NY,NX)=XH1PFS(3,0,NY,NX)+RH1PFS0-RFLP14-DFVP14
     2-RFLP1B-DFVP1B
      XH2PFS(3,0,NY,NX)=XH2PFS(3,0,NY,NX)+RH2PFS0-RFLPO4-DFVPO4
     2-RFLPOB-DFVPOB
      XCOFLS(3,NU(NY,NX),NY,NX)=XCOFLS(3,NU(NY,NX),NY,NX)+RCOFLS1
     2+RFLCOS+DFVCOS
      XCHFLS(3,NU(NY,NX),NY,NX)=XCHFLS(3,NU(NY,NX),NY,NX)+RCHFLS1
     2+RFLCHS+DFVCHS
      XOXFLS(3,NU(NY,NX),NY,NX)=XOXFLS(3,NU(NY,NX),NY,NX)+ROXFLS1
     2+RFLOXS+DFVOXS
      XNGFLS(3,NU(NY,NX),NY,NX)=XNGFLS(3,NU(NY,NX),NY,NX)+RNGFLS1
     2+RFLNGS+DFVNGS
      XN2FLS(3,NU(NY,NX),NY,NX)=XN2FLS(3,NU(NY,NX),NY,NX)+RN2FLS1
     2+RFLN2S+DFVN2S
      XHGFLS(3,NU(NY,NX),NY,NX)=XHGFLS(3,NU(NY,NX),NY,NX)
     2+RFLHGS+DFVHGS
      XN4FLW(3,NU(NY,NX),NY,NX)=XN4FLW(3,NU(NY,NX),NY,NX)+RN4FLW1
     2+RFLNH4+DFVNH4
      XN3FLW(3,NU(NY,NX),NY,NX)=XN3FLW(3,NU(NY,NX),NY,NX)+RN3FLW1
     2+RFLNH3+DFVNH3
      XNOFLW(3,NU(NY,NX),NY,NX)=XNOFLW(3,NU(NY,NX),NY,NX)+RNOFLW1
     2+RFLNO3+DFVNO3
      XNXFLS(3,NU(NY,NX),NY,NX)=XNXFLS(3,NU(NY,NX),NY,NX)+RFLNO2+DFVNO2
      XH1PFS(3,NU(NY,NX),NY,NX)=XH1PFS(3,NU(NY,NX),NY,NX)+RH1PFS1
     2+RFLP14+DFVP14
      XH2PFS(3,NU(NY,NX),NY,NX)=XH2PFS(3,NU(NY,NX),NY,NX)+RH2PFS1
     2+RFLPO4+DFVPO4
      XN4FLB(3,NU(NY,NX),NY,NX)=XN4FLB(3,NU(NY,NX),NY,NX)+RN4FLB1
     2+RFLN4B+DFVN4B
      XN3FLB(3,NU(NY,NX),NY,NX)=XN3FLB(3,NU(NY,NX),NY,NX)+RN3FLB1
     2+RFLN3B+DFVN3B
      XNOFLB(3,NU(NY,NX),NY,NX)=XNOFLB(3,NU(NY,NX),NY,NX)+RNOFLB1
     2+RFLNOB+DFVNOB
      XNXFLB(3,NU(NY,NX),NY,NX)=XNXFLB(3,NU(NY,NX),NY,NX)
     2+RFLN2B+DFVN2B
      XH1BFB(3,NU(NY,NX),NY,NX)=XH1BFB(3,NU(NY,NX),NY,NX)+RH1BFB1
     2+RFLP1B+DFVP1B
      XH2BFB(3,NU(NY,NX),NY,NX)=XH2BFB(3,NU(NY,NX),NY,NX)+RH2BFB1
     2+RFLPOB+DFVPOB
C
C     MACROPORE-MICROPORE CONVECTIVE SOLUTE EXCHANGE IN SOIL
C     SURFACE LAYER FROM WATER EXCHANGE IN 'WATSUB' AND
C     FROM MACROPORE OR MICROPORE SOLUTE CONCENTRATIONS
C
C     FINHM=macro-micropore water transfer from watsub.f
C     VOLWM,VOLWHM=micropore,macropore water volume
C     RFL*=convective macropore-micropore solute transfer
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     *H2,*2=macropore,micropore solute content
C
C     MACROPORE TO MICROPORE TRANSFER
C
      IF(FINHM(M,NU(NY,NX),NY,NX).GT.0.0)THEN
      IF(VOLWHM(M,NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      VFLW=AMAX1(0.0,AMIN1(VFLWX,FINHM(M,NU(NY,NX),NY,NX)
     2/VOLWHM(M,NU(NY,NX),NY,NX)))
      ELSE
      VFLW=VFLWX
      ENDIF
      DO 9870 K=0,4
      RFLOC(K)=VFLW*AMAX1(0.0,OQCH2(K,NU(NY,NX),NY,NX))
      RFLON(K)=VFLW*AMAX1(0.0,OQNH2(K,NU(NY,NX),NY,NX))
      RFLOP(K)=VFLW*AMAX1(0.0,OQPH2(K,NU(NY,NX),NY,NX))
      RFLOA(K)=VFLW*AMAX1(0.0,OQAH2(K,NU(NY,NX),NY,NX))
9870  CONTINUE
      RFLCOS=VFLW*AMAX1(0.0,CO2SH2(NU(NY,NX),NY,NX))
      RFLCHS=VFLW*AMAX1(0.0,CH4SH2(NU(NY,NX),NY,NX))
      RFLOXS=VFLW*AMAX1(0.0,OXYSH2(NU(NY,NX),NY,NX))
      RFLNGS=VFLW*AMAX1(0.0,Z2GSH2(NU(NY,NX),NY,NX))
      RFLN2S=VFLW*AMAX1(0.0,Z2OSH2(NU(NY,NX),NY,NX))
      RFLHGS=VFLW*AMAX1(0.0,H2GSH2(NU(NY,NX),NY,NX))
      RFLNH4=VFLW*AMAX1(0.0,ZNH4H2(NU(NY,NX),NY,NX))
     2*VLNH4(NU(NY,NX),NY,NX)
      RFLNH3=VFLW*AMAX1(0.0,ZNH3H2(NU(NY,NX),NY,NX))
     2*VLNH4(NU(NY,NX),NY,NX)
      RFLNO3=VFLW*AMAX1(0.0,ZNO3H2(NU(NY,NX),NY,NX))
     2*VLNO3(NU(NY,NX),NY,NX)
      RFLNO2=VFLW*AMAX1(0.0,ZNO2H2(NU(NY,NX),NY,NX))
     2*VLNO3(NU(NY,NX),NY,NX)
      RFLP14=VFLW*AMAX1(0.0,H1P4H2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLPO4=VFLW*AMAX1(0.0,H2P4H2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLN4B=VFLW*AMAX1(0.0,ZN4BH2(NU(NY,NX),NY,NX))
     2*VLNHB(NU(NY,NX),NY,NX)
      RFLN3B=VFLW*AMAX1(0.0,ZN3BH2(NU(NY,NX),NY,NX))
     2*VLNHB(NU(NY,NX),NY,NX)
      RFLNOB=VFLW*AMAX1(0.0,ZNOBH2(NU(NY,NX),NY,NX))
     2*VLNOB(NU(NY,NX),NY,NX)
      RFLN2B=VFLW*AMAX1(0.0,ZN2BH2(NU(NY,NX),NY,NX))
     2*VLNOB(NU(NY,NX),NY,NX)
      RFLP1B=VFLW*AMAX1(0.0,H1PBH2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLPOB=VFLW*AMAX1(0.0,H2PBH2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
C
C     MICROPORE TO MACROPORE TRANSFER
C
      ELSEIF(FINHM(M,NU(NY,NX),NY,NX).LT.0.0)THEN
      IF(VOLWM(M,NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      VFLW=AMIN1(0.0,AMAX1(-VFLWX,FINHM(M,NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX)))
      ELSE
      VFLW=-VFLWX
      ENDIF
      DO 9865 K=0,4
      RFLOC(K)=VFLW*AMAX1(0.0,OQC2(K,NU(NY,NX),NY,NX))
      RFLON(K)=VFLW*AMAX1(0.0,OQN2(K,NU(NY,NX),NY,NX))
      RFLOP(K)=VFLW*AMAX1(0.0,OQP2(K,NU(NY,NX),NY,NX))
      RFLOA(K)=VFLW*AMAX1(0.0,OQA2(K,NU(NY,NX),NY,NX))
9865  CONTINUE
      RFLCOS=VFLW*AMAX1(0.0,CO2S2(NU(NY,NX),NY,NX))
      RFLCHS=VFLW*AMAX1(0.0,CH4S2(NU(NY,NX),NY,NX))
      RFLOXS=VFLW*AMAX1(0.0,OXYS2(NU(NY,NX),NY,NX))
      RFLNGS=VFLW*AMAX1(0.0,Z2GS2(NU(NY,NX),NY,NX))
      RFLN2S=VFLW*AMAX1(0.0,Z2OS2(NU(NY,NX),NY,NX))
      RFLHGS=VFLW*AMAX1(0.0,H2GS2(NU(NY,NX),NY,NX))
      RFLNH4=VFLW*AMAX1(0.0,ZNH4S2(NU(NY,NX),NY,NX))
     2*VLNH4(NU(NY,NX),NY,NX)
      RFLNH3=VFLW*AMAX1(0.0,ZNH3S2(NU(NY,NX),NY,NX))
     2*VLNH4(NU(NY,NX),NY,NX)
      RFLNO3=VFLW*AMAX1(0.0,ZNO3S2(NU(NY,NX),NY,NX))
     2*VLNO3(NU(NY,NX),NY,NX)
      RFLNO2=VFLW*AMAX1(0.0,ZNO2S2(NU(NY,NX),NY,NX))
     2*VLNO3(NU(NY,NX),NY,NX)
      RFLP14=VFLW*AMAX1(0.0,H1PO42(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLPO4=VFLW*AMAX1(0.0,H2PO42(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLN4B=VFLW*AMAX1(0.0,ZNH4B2(NU(NY,NX),NY,NX))
     2*VLNHB(NU(NY,NX),NY,NX)
      RFLN3B=VFLW*AMAX1(0.0,ZNH3B2(NU(NY,NX),NY,NX))
     2*VLNHB(NU(NY,NX),NY,NX)
      RFLNOB=VFLW*AMAX1(0.0,ZNO3B2(NU(NY,NX),NY,NX))
     2*VLNOB(NU(NY,NX),NY,NX)
      RFLN2B=VFLW*AMAX1(0.0,ZNO2B2(NU(NY,NX),NY,NX))
     2*VLNOB(NU(NY,NX),NY,NX)
      RFLP1B=VFLW*AMAX1(0.0,H1POB2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLPOB=VFLW*AMAX1(0.0,H2POB2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
C
C     NO MACROPORE TO MICROPORE TRANSFER
C
      ELSE
      DO 9860 K=0,4
      RFLOC(K)=0.0
      RFLON(K)=0.0
      RFLOP(K)=0.0
      RFLOA(K)=0.0
9860  CONTINUE
      RFLCOS=0.0
      RFLCHS=0.0
      RFLOXS=0.0
      RFLNGS=0.0
      RFLN2S=0.0
      RFLHGS=0.0
      RFLNH4=0.0
      RFLNH3=0.0
      RFLNO3=0.0
      RFLNO2=0.0
      RFLP14=0.0
      RFLPO4=0.0
      RFLN4B=0.0
      RFLN3B=0.0
      RFLNOB=0.0
      RFLN2B=0.0
      RFLP1B=0.0
      RFLPOB=0.0
      ENDIF
C
C     DIFFUSIVE FLUXES OF SOLUTES BETWEEN MICROPORES AND
C     MACROPORES FROM AQUEOUS DIFFUSIVITIES AND CONCENTRATION DIFFERENCES
C
C     VOLWM,VOLWHM=micropore,macropore water volume
C     XFRS*VOLT=maximum macropore volume for solute transfer
C     DFV*=diffusive macropore-micropore solute transfer
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C     *H2,*2=macropore,micropore solute content
C
      IF(VOLWHM(M,NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      VOLWHS=AMIN1(XFRS*VOLT(NU(NY,NX),NY,NX)
     2,VOLWHM(M,NU(NY,NX),NY,NX))
      VOLWT=VOLWM(M,NU(NY,NX),NY,NX)+VOLWHS
      DO 8835 K=0,4
      DFVOC(K)=XNPH*(AMAX1(0.0,OQCH2(K,NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,OQC2(K,NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVON(K)=XNPH*(AMAX1(0.0,OQNH2(K,NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,OQN2(K,NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVOP(K)=XNPH*(AMAX1(0.0,OQPH2(K,NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,OQP2(K,NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVOA(K)=XNPH*(AMAX1(0.0,OQAH2(K,NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,OQA2(K,NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
8835  CONTINUE
      DFVCOS=XNPH*(AMAX1(0.0,CO2SH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,CO2S2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVCHS=XNPH*(AMAX1(0.0,CH4SH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,CH4S2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVOXS=XNPH*(AMAX1(0.0,OXYSH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,OXYS2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVNGS=XNPH*(AMAX1(0.0,Z2GSH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,Z2GS2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVN2S=XNPH*(AMAX1(0.0,Z2OSH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,Z2OS2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVHGS=XNPH*(AMAX1(0.0,H2GSH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,H2GS2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVNH4=XNPH*(AMAX1(0.0,ZNH4H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZNH4S2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     3*VLNH4(NU(NY,NX),NY,NX)
      DFVNH3=XNPH*(AMAX1(0.0,ZNH3H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZNH3S2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     3*VLNH4(NU(NY,NX),NY,NX)
      DFVNO3=XNPH*(AMAX1(0.0,ZNO3H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZNO3S2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     3*VLNO3(NU(NY,NX),NY,NX)
      DFVNO2=XNPH*(AMAX1(0.0,ZNO2H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZNO2S2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     3*VLNO3(NU(NY,NX),NY,NX)
      DFVP14=XNPH*(AMAX1(0.0,H1P4H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,H1PO42(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     3*VLPO4(NU(NY,NX),NY,NX)
      DFVPO4=XNPH*(AMAX1(0.0,H2P4H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,H2PO42(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     3*VLPO4(NU(NY,NX),NY,NX)
      DFVN4B=XNPH*(AMAX1(0.0,ZN4BH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZNH4B2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     3*VLNHB(NU(NY,NX),NY,NX)
      DFVN3B=XNPH*(AMAX1(0.0,ZN3BH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZNH3B2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     3*VLNHB(NU(NY,NX),NY,NX)
      DFVNOB=XNPH*(AMAX1(0.0,ZNOBH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZNO3B2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     3*VLNOB(NU(NY,NX),NY,NX)
      DFVN2B=XNPH*(AMAX1(0.0,ZN2BH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZNO2B2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     3*VLNOB(NU(NY,NX),NY,NX)
      DFVP1B=XNPH*(AMAX1(0.0,H1PBH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,H1POB2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     3*VLPOB(NU(NY,NX),NY,NX)
      DFVPOB=XNPH*(AMAX1(0.0,H2PBH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,H2POB2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     3*VLPOB(NU(NY,NX),NY,NX)
      ELSE
      DO 8935 K=0,4
      DFVOC(K)=0.0
      DFVON(K)=0.0
      DFVOP(K)=0.0
      DFVOA(K)=0.0
8935  CONTINUE
      DFVCOS=0.0
      DFVCHS=0.0
      DFVOXS=0.0
      DFVNGS=0.0
      DFVN2S=0.0
      DFVHGS=0.0
      DFVNH4=0.0
      DFVNH3=0.0
      DFVNO3=0.0
      DFVNO2=0.0
      DFVP14=0.0
      DFVPO4=0.0
      DFVN4B=0.0
      DFVN3B=0.0
      DFVNOB=0.0
      DFVN2B=0.0
      DFVP1B=0.0
      DFVPOB=0.0
      ENDIF
C
C     TOTAL CONVECTIVE +DIFFUSIVE TRANSFER BETWEEN MACROPOES AND MICROPORES
C
C     R*FXS=convective + diffusive solute flux between macropores and micropores
C     RFL*=convective flux between macropores and micropores
C     DFV*=diffusive solute flux between macropores and micropores
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C
      DO 9940 K=0,4
      ROCFXS(K,NU(NY,NX),NY,NX)=RFLOC(K)+DFVOC(K)
      RONFXS(K,NU(NY,NX),NY,NX)=RFLON(K)+DFVON(K)
      ROPFXS(K,NU(NY,NX),NY,NX)=RFLOP(K)+DFVOP(K)
      ROAFXS(K,NU(NY,NX),NY,NX)=RFLOA(K)+DFVOA(K)
9940  CONTINUE
      RCOFXS(NU(NY,NX),NY,NX)=RFLCOS+DFVCOS
      RCHFXS(NU(NY,NX),NY,NX)=RFLCHS+DFVCHS
      ROXFXS(NU(NY,NX),NY,NX)=RFLOXS+DFVOXS
      RNGFXS(NU(NY,NX),NY,NX)=RFLNGS+DFVNGS
      RN2FXS(NU(NY,NX),NY,NX)=RFLN2S+DFVN2S
      RHGFXS(NU(NY,NX),NY,NX)=RFLHGS+DFVHGS
      RN4FXW(NU(NY,NX),NY,NX)=RFLNH4+DFVNH4
      RN3FXW(NU(NY,NX),NY,NX)=RFLNH3+DFVNH3
      RNOFXW(NU(NY,NX),NY,NX)=RFLNO3+DFVNO3
      RNXFXS(NU(NY,NX),NY,NX)=RFLNO2+DFVNO2
      RH1PXS(NU(NY,NX),NY,NX)=RFLP14+DFVP14
      RH2PXS(NU(NY,NX),NY,NX)=RFLPO4+DFVPO4
      RN4FXB(NU(NY,NX),NY,NX)=RFLN4B+DFVN4B
      RN3FXB(NU(NY,NX),NY,NX)=RFLN3B+DFVN3B
      RNOFXB(NU(NY,NX),NY,NX)=RFLNOB+DFVNOB
      RNXFXB(NU(NY,NX),NY,NX)=RFLN2B+DFVN2B
      RH1BXB(NU(NY,NX),NY,NX)=RFLP1B+DFVP1B
      RH2BXB(NU(NY,NX),NY,NX)=RFLPOB+DFVPOB
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*FXS=hourly convective + diffusive solute flux between macropores and micropores
C     R*FXS=total convective + diffusive solute flux between macropores and micropores
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C
      DO 9935 K=0,4
      XOCFXS(K,NU(NY,NX),NY,NX)=XOCFXS(K,NU(NY,NX),NY,NX)
     2+ROCFXS(K,NU(NY,NX),NY,NX)
      XONFXS(K,NU(NY,NX),NY,NX)=XONFXS(K,NU(NY,NX),NY,NX)
     2+RONFXS(K,NU(NY,NX),NY,NX)
      XOPFXS(K,NU(NY,NX),NY,NX)=XOPFXS(K,NU(NY,NX),NY,NX)
     2+ROPFXS(K,NU(NY,NX),NY,NX)
      XOAFXS(K,NU(NY,NX),NY,NX)=XOAFXS(K,NU(NY,NX),NY,NX)
     2+ROAFXS(K,NU(NY,NX),NY,NX)
9935  CONTINUE
      XCOFXS(NU(NY,NX),NY,NX)=XCOFXS(NU(NY,NX),NY,NX)
     2+RCOFXS(NU(NY,NX),NY,NX)
      XCHFXS(NU(NY,NX),NY,NX)=XCHFXS(NU(NY,NX),NY,NX)
     2+RCHFXS(NU(NY,NX),NY,NX)
      XOXFXS(NU(NY,NX),NY,NX)=XOXFXS(NU(NY,NX),NY,NX)
     2+ROXFXS(NU(NY,NX),NY,NX)
      XNGFXS(NU(NY,NX),NY,NX)=XNGFXS(NU(NY,NX),NY,NX)
     2+RNGFXS(NU(NY,NX),NY,NX)
      XN2FXS(NU(NY,NX),NY,NX)=XN2FXS(NU(NY,NX),NY,NX)
     2+RN2FXS(NU(NY,NX),NY,NX)
      XHGFXS(NU(NY,NX),NY,NX)=XHGFXS(NU(NY,NX),NY,NX)
     2+RHGFXS(NU(NY,NX),NY,NX)
      XN4FXW(NU(NY,NX),NY,NX)=XN4FXW(NU(NY,NX),NY,NX)
     2+RN4FXW(NU(NY,NX),NY,NX)
      XN3FXW(NU(NY,NX),NY,NX)=XN3FXW(NU(NY,NX),NY,NX)
     2+RN3FXW(NU(NY,NX),NY,NX)
      XNOFXW(NU(NY,NX),NY,NX)=XNOFXW(NU(NY,NX),NY,NX)
     2+RNOFXW(NU(NY,NX),NY,NX)
      XNXFXS(NU(NY,NX),NY,NX)=XNXFXS(NU(NY,NX),NY,NX)
     2+RNXFXS(NU(NY,NX),NY,NX)
      XH1PXS(NU(NY,NX),NY,NX)=XH1PXS(NU(NY,NX),NY,NX)
     2+RH1PXS(NU(NY,NX),NY,NX)
      XH2PXS(NU(NY,NX),NY,NX)=XH2PXS(NU(NY,NX),NY,NX)
     2+RH2PXS(NU(NY,NX),NY,NX)
      XN4FXB(NU(NY,NX),NY,NX)=XN4FXB(NU(NY,NX),NY,NX)
     2+RN4FXB(NU(NY,NX),NY,NX)
      XN3FXB(NU(NY,NX),NY,NX)=XN3FXB(NU(NY,NX),NY,NX)
     2+RN3FXB(NU(NY,NX),NY,NX)
      XNOFXB(NU(NY,NX),NY,NX)=XNOFXB(NU(NY,NX),NY,NX)
     2+RNOFXB(NU(NY,NX),NY,NX)
      XNXFXB(NU(NY,NX),NY,NX)=XNXFXB(NU(NY,NX),NY,NX)
     2+RNXFXB(NU(NY,NX),NY,NX)
      XH1BXB(NU(NY,NX),NY,NX)=XH1BXB(NU(NY,NX),NY,NX)
     2+RH1BXB(NU(NY,NX),NY,NX)
      XH2BXB(NU(NY,NX),NY,NX)=XH2BXB(NU(NY,NX),NY,NX)
     2+RH2BXB(NU(NY,NX),NY,NX)
C     IF(I.EQ.133)THEN
C     WRITE(*,441)'RH1BXB',I,J,M,NX,NY,RH1BXB(NU(NY,NX),NY,NX)
C    2,RFLP1B,DFVP1B,XH1BXB(NU(NY,NX),NY,NX),H1PBH2(NU(NY,NX),NY,NX)
C    2,H1POB2(NU(NY,NX),NY,NX)
441   FORMAT(A8,5I4,20E17.8)
C     ENDIF
C
C     SOLUTE TRANSPORT FROM WATER OVERLAND FLOW
C     IN 'WATSUB' AND FROM SOLUTE CONCENTRATIONS
C     IN SOIL SURFACE LAYER
C
C     QRM=runoff from watsub.f
C     RQR*=solute in runoff
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     VOLWM=litter water volume from watsub.f
C     *S2=litter solute content
C     N2,N1=NY,NX of source grid cell
C     N5,N4=NY,NX of destination grid cell
C     X*QRS=accumulated hourly solute in runoff
C
      N1=NX
      N2=NY
      IF(QRM(M,N2,N1).GT.ZEROS(N2,N1))THEN
      IF(VOLWM(M,0,N2,N1).GT.ZEROS2(N2,N1))THEN
      VFLW=AMIN1(VFLWX,QRM(M,N2,N1)/VOLWM(M,0,N2,N1))
      ELSE
      VFLW=VFLWX
      ENDIF
      DO 9835 K=0,4
      RQROC0(K,N2,N1)=VFLW*AMAX1(0.0,OQC2(K,0,N2,N1))
      RQRON0(K,N2,N1)=VFLW*AMAX1(0.0,OQN2(K,0,N2,N1))
      RQROP0(K,N2,N1)=VFLW*AMAX1(0.0,OQP2(K,0,N2,N1))
      RQROA0(K,N2,N1)=VFLW*AMAX1(0.0,OQA2(K,0,N2,N1))
9835  CONTINUE
      RQRCOS0(N2,N1)=VFLW*AMAX1(0.0,CO2S2(0,N2,N1))
      RQRCHS0(N2,N1)=VFLW*AMAX1(0.0,CH4S2(0,N2,N1))
      RQROXS0(N2,N1)=VFLW*AMAX1(0.0,OXYS2(0,N2,N1))
      RQRNGS0(N2,N1)=VFLW*AMAX1(0.0,Z2GS2(0,N2,N1))
      RQRN2S0(N2,N1)=VFLW*AMAX1(0.0,Z2OS2(0,N2,N1))
      RQRHGS0(N2,N1)=VFLW*AMAX1(0.0,H2GS2(0,N2,N1))
      RQRNH40(N2,N1)=VFLW*AMAX1(0.0,ZNH4S2(0,N2,N1))
      RQRNH30(N2,N1)=VFLW*AMAX1(0.0,ZNH3S2(0,N2,N1))
      RQRNO30(N2,N1)=VFLW*AMAX1(0.0,ZNO3S2(0,N2,N1))
      RQRNO20(N2,N1)=VFLW*AMAX1(0.0,ZNO2S2(0,N2,N1))
      RQRH1P0(N2,N1)=VFLW*AMAX1(0.0,H1PO42(0,N2,N1))
      RQRH2P0(N2,N1)=VFLW*AMAX1(0.0,H2PO42(0,N2,N1))
      ELSE
      DO 9836 K=0,4
      RQROC0(K,N2,N1)=0.0
      RQRON0(K,N2,N1)=0.0
      RQROP0(K,N2,N1)=0.0
      RQROA0(K,N2,N1)=0.0
9836  CONTINUE
      RQRCOS0(N2,N1)=0.0
      RQRCHS0(N2,N1)=0.0
      RQROXS0(N2,N1)=0.0
      RQRNGS0(N2,N1)=0.0
      RQRN2S0(N2,N1)=0.0
      RQRHGS0(N2,N1)=0.0
      RQRNH40(N2,N1)=0.0
      RQRNH30(N2,N1)=0.0
      RQRNO30(N2,N1)=0.0
      RQRNO20(N2,N1)=0.0
      RQRH1P0(N2,N1)=0.0
      RQRH2P0(N2,N1)=0.0
      ENDIF
C
C     LOCATE INTERNAL BOUNDARIES BETWEEN ADJACENT GRID CELLS
C
      DO 4310 N=1,2
      DO 4305 NN=1,2
      IF(N.EQ.1)THEN
      IF(NX.EQ.NHE.AND.NN.EQ.1
     2.OR.NX.EQ.NHW.AND.NN.EQ.2)THEN
      GO TO 4305
      ELSE
      N4=NX+1
      N5=NY
      N4B=NX-1
      N5B=NY
      ENDIF
      ELSEIF(N.EQ.2)THEN
      IF(NY.EQ.NVS.AND.NN.EQ.1
     2.OR.NY.EQ.NVN.AND.NN.EQ.2)THEN
      GO TO 4305
      ELSE
      N4=NX
      N5=NY+1
      N4B=NX
      N5B=NY-1
      ENDIF
      ENDIF
C
C     QRM=runoff from watsub.f
C     RQR*=solute in runoff
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     VOLWM=litter water volume from watsub.f
C     *S2=litter solute content
C
C     IF OVERLAND FLOW IS FROM CURRENT TO ADJACENT GRID CELL
C
      IF(QRM(M,N2,N1).GT.ZEROS(N2,N1))THEN
      IF(NN.EQ.1)THEN
      FQRM=QRMN(M,N,2,N5,N4)/QRM(M,N2,N1)
      DO 9840 K=0,4
      RQROC(K,N,2,N5,N4)=RQROC0(K,N2,N1)*FQRM
      RQRON(K,N,2,N5,N4)=RQRON0(K,N2,N1)*FQRM
      RQROP(K,N,2,N5,N4)=RQROP0(K,N2,N1)*FQRM
      RQROA(K,N,2,N5,N4)=RQROA0(K,N2,N1)*FQRM
9840  CONTINUE
      RQRCOS(N,2,N5,N4)=RQRCOS0(N2,N1)*FQRM
      RQRCHS(N,2,N5,N4)=RQRCHS0(N2,N1)*FQRM
      RQROXS(N,2,N5,N4)=RQROXS0(N2,N1)*FQRM
      RQRNGS(N,2,N5,N4)=RQRNGS0(N2,N1)*FQRM
      RQRN2S(N,2,N5,N4)=RQRN2S0(N2,N1)*FQRM
      RQRHGS(N,2,N5,N4)=RQRHGS0(N2,N1)*FQRM
      RQRNH4(N,2,N5,N4)=RQRNH40(N2,N1)*FQRM
      RQRNH3(N,2,N5,N4)=RQRNH30(N2,N1)*FQRM
      RQRNO3(N,2,N5,N4)=RQRNO30(N2,N1)*FQRM
      RQRNO2(N,2,N5,N4)=RQRNO20(N2,N1)*FQRM
      RQRH1P(N,2,N5,N4)=RQRH1P0(N2,N1)*FQRM
      RQRH2P(N,2,N5,N4)=RQRH2P0(N2,N1)*FQRM
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     XQR*=hourly solute in runoff
C     RQR*=solute in runoff
C
      DO 9841 K=0,4
      XOCQRS(K,N,2,N5,N4)=XOCQRS(K,N,2,N5,N4)+RQROC(K,N,2,N5,N4)
      XONQRS(K,N,2,N5,N4)=XONQRS(K,N,2,N5,N4)+RQRON(K,N,2,N5,N4)
      XOPQRS(K,N,2,N5,N4)=XOPQRS(K,N,2,N5,N4)+RQROP(K,N,2,N5,N4)
      XOAQRS(K,N,2,N5,N4)=XOAQRS(K,N,2,N5,N4)+RQROA(K,N,2,N5,N4)
9841  CONTINUE
      XCOQRS(N,2,N5,N4)=XCOQRS(N,2,N5,N4)+RQRCOS(N,2,N5,N4)
      XCHQRS(N,2,N5,N4)=XCHQRS(N,2,N5,N4)+RQRCHS(N,2,N5,N4)
      XOXQRS(N,2,N5,N4)=XOXQRS(N,2,N5,N4)+RQROXS(N,2,N5,N4)
      XNGQRS(N,2,N5,N4)=XNGQRS(N,2,N5,N4)+RQRNGS(N,2,N5,N4)
      XN2QRS(N,2,N5,N4)=XN2QRS(N,2,N5,N4)+RQRN2S(N,2,N5,N4)
      XHGQRS(N,2,N5,N4)=XHGQRS(N,2,N5,N4)+RQRHGS(N,2,N5,N4)
      XN4QRW(N,2,N5,N4)=XN4QRW(N,2,N5,N4)+RQRNH4(N,2,N5,N4)
      XN3QRW(N,2,N5,N4)=XN3QRW(N,2,N5,N4)+RQRNH3(N,2,N5,N4)
      XNOQRW(N,2,N5,N4)=XNOQRW(N,2,N5,N4)+RQRNO3(N,2,N5,N4)
      XNXQRS(N,2,N5,N4)=XNXQRS(N,2,N5,N4)+RQRNO2(N,2,N5,N4)
      XP1QRW(N,2,N5,N4)=XP1QRW(N,2,N5,N4)+RQRH1P(N,2,N5,N4)
      XP4QRW(N,2,N5,N4)=XP4QRW(N,2,N5,N4)+RQRH2P(N,2,N5,N4)
      ELSE
      DO 9842 K=0,4
      RQROC(K,N,2,N5,N4)=0.0
      RQRON(K,N,2,N5,N4)=0.0
      RQROP(K,N,2,N5,N4)=0.0
      RQROA(K,N,2,N5,N4)=0.0
9842  CONTINUE
      RQRCOS(N,2,N5,N4)=0.0
      RQRCHS(N,2,N5,N4)=0.0
      RQROXS(N,2,N5,N4)=0.0
      RQRNGS(N,2,N5,N4)=0.0
      RQRN2S(N,2,N5,N4)=0.0
      RQRHGS(N,2,N5,N4)=0.0
      RQRNH4(N,2,N5,N4)=0.0
      RQRNH3(N,2,N5,N4)=0.0
      RQRNO3(N,2,N5,N4)=0.0
      RQRNO2(N,2,N5,N4)=0.0
      RQRH1P(N,2,N5,N4)=0.0
      RQRH2P(N,2,N5,N4)=0.0
      ENDIF
C
C     IF OVERLAND FLOW IS FROM CURRENT TO ADJACENT GRID CELL
C
      IF(NN.EQ.2)THEN
      IF(N4B.GT.0.AND.N5B.GT.0)THEN
      FQRM=QRMN(M,N,1,N5B,N4B)/QRM(M,N2,N1)
      DO 9834 K=0,4
      RQROC(K,N,1,N5B,N4B)=RQROC0(K,N2,N1)*FQRM
      RQRON(K,N,1,N5B,N4B)=RQRON0(K,N2,N1)*FQRM
      RQROP(K,N,1,N5B,N4B)=RQROP0(K,N2,N1)*FQRM
      RQROA(K,N,1,N5B,N4B)=RQROA0(K,N2,N1)*FQRM
9834  CONTINUE
      RQRCOS(N,1,N5B,N4B)=RQRCOS0(N2,N1)*FQRM
      RQRCHS(N,1,N5B,N4B)=RQRCHS0(N2,N1)*FQRM
      RQROXS(N,1,N5B,N4B)=RQROXS0(N2,N1)*FQRM
      RQRNGS(N,1,N5B,N4B)=RQRNGS0(N2,N1)*FQRM
      RQRN2S(N,1,N5B,N4B)=RQRN2S0(N2,N1)*FQRM
      RQRHGS(N,1,N5B,N4B)=RQRHGS0(N2,N1)*FQRM
      RQRNH4(N,1,N5B,N4B)=RQRNH40(N2,N1)*FQRM
      RQRNH3(N,1,N5B,N4B)=RQRNH30(N2,N1)*FQRM
      RQRNO3(N,1,N5B,N4B)=RQRNO30(N2,N1)*FQRM
      RQRNO2(N,1,N5B,N4B)=RQRNO20(N2,N1)*FQRM
      RQRH1P(N,1,N5B,N4B)=RQRH1P0(N2,N1)*FQRM
      RQRH2P(N,1,N5B,N4B)=RQRH2P0(N2,N1)*FQRM
      DO 9824 K=0,4
      XOCQRS(K,N,1,N5B,N4B)=XOCQRS(K,N,1,N5B,N4B)+RQROC(K,N,1,N5B,N4B)
      XONQRS(K,N,1,N5B,N4B)=XONQRS(K,N,1,N5B,N4B)+RQRON(K,N,1,N5B,N4B)
      XOPQRS(K,N,1,N5B,N4B)=XOPQRS(K,N,1,N5B,N4B)+RQROP(K,N,1,N5B,N4B)
      XOAQRS(K,N,1,N5B,N4B)=XOAQRS(K,N,1,N5B,N4B)+RQROA(K,N,1,N5B,N4B)
9824  CONTINUE
      XCOQRS(N,1,N5B,N4B)=XCOQRS(N,1,N5B,N4B)+RQRCOS(N,1,N5B,N4B)
      XCHQRS(N,1,N5B,N4B)=XCHQRS(N,1,N5B,N4B)+RQRCHS(N,1,N5B,N4B)
      XOXQRS(N,1,N5B,N4B)=XOXQRS(N,1,N5B,N4B)+RQROXS(N,1,N5B,N4B)
      XNGQRS(N,1,N5B,N4B)=XNGQRS(N,1,N5B,N4B)+RQRNGS(N,1,N5B,N4B)
      XN2QRS(N,1,N5B,N4B)=XN2QRS(N,1,N5B,N4B)+RQRN2S(N,1,N5B,N4B)
      XHGQRS(N,1,N5B,N4B)=XHGQRS(N,1,N5B,N4B)+RQRHGS(N,1,N5B,N4B)
      XN4QRW(N,1,N5B,N4B)=XN4QRW(N,1,N5B,N4B)+RQRNH4(N,1,N5B,N4B)
      XN3QRW(N,1,N5B,N4B)=XN3QRW(N,1,N5B,N4B)+RQRNH3(N,1,N5B,N4B)
      XNOQRW(N,1,N5B,N4B)=XNOQRW(N,1,N5B,N4B)+RQRNO3(N,1,N5B,N4B)
      XNXQRS(N,1,N5B,N4B)=XNXQRS(N,1,N5B,N4B)+RQRNO2(N,1,N5B,N4B)
      XP1QRW(N,1,N5B,N4B)=XP1QRW(N,1,N5B,N4B)+RQRH1P(N,1,N5B,N4B)
      XP4QRW(N,1,N5B,N4B)=XP4QRW(N,1,N5B,N4B)+RQRH2P(N,1,N5B,N4B)
      ELSE
      DO 9833 K=0,4
      RQROC(K,N,1,N5B,N4B)=0.0
      RQRON(K,N,1,N5B,N4B)=0.0
      RQROP(K,N,1,N5B,N4B)=0.0
      RQROA(K,N,1,N5B,N4B)=0.0
9833  CONTINUE
      RQRCOS(N,1,N5B,N4B)=0.0
      RQRCHS(N,1,N5B,N4B)=0.0
      RQROXS(N,1,N5B,N4B)=0.0
      RQRNGS(N,1,N5B,N4B)=0.0
      RQRN2S(N,1,N5B,N4B)=0.0
      RQRHGS(N,1,N5B,N4B)=0.0
      RQRNH4(N,1,N5B,N4B)=0.0
      RQRNH3(N,1,N5B,N4B)=0.0
      RQRNO3(N,1,N5B,N4B)=0.0
      RQRNO2(N,1,N5B,N4B)=0.0
      RQRH1P(N,1,N5B,N4B)=0.0
      RQRH2P(N,1,N5B,N4B)=0.0
      ENDIF
      ENDIF
      ELSE
      DO 9839 K=0,4
      RQROC(K,N,2,N5,N4)=0.0
      RQRON(K,N,2,N5,N4)=0.0
      RQROP(K,N,2,N5,N4)=0.0
      RQROA(K,N,2,N5,N4)=0.0
9839  CONTINUE
      RQRCOS(N,2,N5,N4)=0.0
      RQRCHS(N,2,N5,N4)=0.0
      RQROXS(N,2,N5,N4)=0.0
      RQRNGS(N,2,N5,N4)=0.0
      RQRN2S(N,2,N5,N4)=0.0
      RQRHGS(N,2,N5,N4)=0.0
      RQRNH4(N,2,N5,N4)=0.0
      RQRNH3(N,2,N5,N4)=0.0
      RQRNO3(N,2,N5,N4)=0.0
      RQRNO2(N,2,N5,N4)=0.0
      RQRH1P(N,2,N5,N4)=0.0
      RQRH2P(N,2,N5,N4)=0.0
      IF(N4B.GT.0.AND.N5B.GT.0)THEN
      DO 9837 K=0,4
      RQROC(K,N,1,N5B,N4B)=0.0
      RQRON(K,N,1,N5B,N4B)=0.0
      RQROP(K,N,1,N5B,N4B)=0.0
      RQROA(K,N,1,N5B,N4B)=0.0
9837  CONTINUE
      RQRCOS(N,1,N5B,N4B)=0.0
      RQRCHS(N,1,N5B,N4B)=0.0
      RQROXS(N,1,N5B,N4B)=0.0
      RQRNGS(N,1,N5B,N4B)=0.0
      RQRN2S(N,1,N5B,N4B)=0.0
      RQRHGS(N,1,N5B,N4B)=0.0
      RQRNH4(N,1,N5B,N4B)=0.0
      RQRNH3(N,1,N5B,N4B)=0.0
      RQRNO3(N,1,N5B,N4B)=0.0
      RQRNO2(N,1,N5B,N4B)=0.0
      RQRH1P(N,1,N5B,N4B)=0.0
      RQRH2P(N,1,N5B,N4B)=0.0
      ENDIF
      ENDIF
C
C     SNOW DRIFT
C
C     QSM=snow transfer from watsub.f
C     RQS*=solute flux in snow transfer
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     VOLS=volume of snowpack from watsub.f
C     *W2=solute content of snowpack
C
      IF(NN.EQ.1)THEN
C
C     IF NO SNOW DRIFT THEN NO TRANSPORT
C
      IF(ABS(QSM(M,N,N5,N4)).LE.ZEROS2(N2,N1))THEN
      RQSCOS(N,N5,N4)=0.0
      RQSCHS(N,N5,N4)=0.0
      RQSOXS(N,N5,N4)=0.0
      RQSNGS(N,N5,N4)=0.0
      RQSN2S(N,N5,N4)=0.0
      RQSNH4(N,N5,N4)=0.0
      RQSNH3(N,N5,N4)=0.0
      RQSNO3(N,N5,N4)=0.0
      RQSH1P(N,N5,N4)=0.0
      RQSH2P(N,N5,N4)=0.0
C
C     IF DRIFT IS FROM CURRENT TO ADJACENT GRID CELL
C
      ELSEIF(QSM(M,N,N5,N4).GT.ZEROS2(N2,N1))THEN
      IF(VOLS(N2,N1).GT.ZEROS2(N2,N1))THEN
      VFLW=AMAX1(0.0,AMIN1(VFLWX,QSM(M,N,N5,N4)/VOLS(N2,N1)))
      ELSE
      VFLW=VFLWX
      ENDIF
      RQSCOS(N,N5,N4)=VFLW*AMAX1(0.0,CO2W2(1,N2,N1))
      RQSCHS(N,N5,N4)=VFLW*AMAX1(0.0,CH4W2(1,N2,N1))
      RQSOXS(N,N5,N4)=VFLW*AMAX1(0.0,OXYW2(1,N2,N1))
      RQSNGS(N,N5,N4)=VFLW*AMAX1(0.0,ZNGW2(1,N2,N1))
      RQSN2S(N,N5,N4)=VFLW*AMAX1(0.0,ZN2W2(1,N2,N1))
      RQSNH4(N,N5,N4)=VFLW*AMAX1(0.0,ZN4W2(1,N2,N1))
      RQSNH3(N,N5,N4)=VFLW*AMAX1(0.0,ZN3W2(1,N2,N1))
      RQSNO3(N,N5,N4)=VFLW*AMAX1(0.0,ZNOW2(1,N2,N1))
      RQSH1P(N,N5,N4)=VFLW*AMAX1(0.0,Z1PW2(1,N2,N1))
      RQSH2P(N,N5,N4)=VFLW*AMAX1(0.0,ZHPW2(1,N2,N1))
C
C     IF DRIFT IS TO CURRENT FROM ADJACENT GRID CELL
C
      ELSEIF(QSM(M,N,N5,N4).LT.-ZEROS2(N2,N1))THEN
      IF(VOLS(N5,N4).GT.ZEROS2(N5,N4))THEN
      VFLW=AMIN1(0.0,AMAX1(-VFLWX,QSM(M,N,N5,N4)/VOLS(N5,N4)))
      ELSE
      VFLW=-VFLWX
      ENDIF
      RQSCOS(N,N5,N4)=VFLW*AMAX1(0.0,CO2W2(1,N5,N4))
      RQSCHS(N,N5,N4)=VFLW*AMAX1(0.0,CH4W2(1,N5,N4))
      RQSOXS(N,N5,N4)=VFLW*AMAX1(0.0,OXYW2(1,N5,N4))
      RQSNGS(N,N5,N4)=VFLW*AMAX1(0.0,ZNGW2(1,N5,N4))
      RQSN2S(N,N5,N4)=VFLW*AMAX1(0.0,ZN2W2(1,N5,N4))
      RQSNH4(N,N5,N4)=VFLW*AMAX1(0.0,ZN4W2(1,N5,N4))
      RQSNH3(N,N5,N4)=VFLW*AMAX1(0.0,ZN3W2(1,N5,N4))
      RQSNO3(N,N5,N4)=VFLW*AMAX1(0.0,ZNOW2(1,N5,N4))
      RQSH1P(N,N5,N4)=VFLW*AMAX1(0.0,Z1PW2(1,N5,N4))
      RQSH2P(N,N5,N4)=VFLW*AMAX1(0.0,ZHPW2(1,N5,N4))
      ENDIF
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*QSS=hourly solute in snow flux
C     RQS*=solute in snow flux
C
      XCOQSS(N,N5,N4)=XCOQSS(N,N5,N4)+RQSCOS(N,N5,N4)
      XCHQSS(N,N5,N4)=XCHQSS(N,N5,N4)+RQSCHS(N,N5,N4)
      XOXQSS(N,N5,N4)=XOXQSS(N,N5,N4)+RQSOXS(N,N5,N4)
      XNGQSS(N,N5,N4)=XNGQSS(N,N5,N4)+RQSNGS(N,N5,N4)
      XN2QSS(N,N5,N4)=XN2QSS(N,N5,N4)+RQSN2S(N,N5,N4)
      XN4QSS(N,N5,N4)=XN4QSS(N,N5,N4)+RQSNH4(N,N5,N4)
      XN3QSS(N,N5,N4)=XN3QSS(N,N5,N4)+RQSNH3(N,N5,N4)
      XNOQSS(N,N5,N4)=XNOQSS(N,N5,N4)+RQSNO3(N,N5,N4)
      XP1QSS(N,N5,N4)=XP1QSS(N,N5,N4)+RQSH1P(N,N5,N4)
      XP4QSS(N,N5,N4)=XP4QSS(N,N5,N4)+RQSH2P(N,N5,N4)
C     IF(I.EQ.118.AND.NX.EQ.3.AND.NY.EQ.4)THEN
C     WRITE(*,6969)'XOXQSS',I,J,N4,N5,N,M,MM,XOXQSS(N,N5,N4)
C    2,RQSOXS(N,N5,N4),VFLW,OXYW2(N2,N1),OXYW2(N5,N4)
C    3,QSM(M,N,N5,N4),VOLS(N2,N1),VOLS(N5,N4)
6969  FORMAT(A8,7I4,20E12.4)
C     ENDIF
      ENDIF
4305  CONTINUE
4310  CONTINUE
      ENDIF
C
C     VOLATILIZATION-DISSOLUTION OF GASES IN RESIDUE AND SOIL SURFACE
C     LAYERS FROM GASEOUS CONCENTRATIONS VS. THEIR AQUEOUS
C     EQUIVALENTS DEPENDING ON SOLUBILITY FROM 'HOUR1'
C     AND TRANSFER COEFFICIENT 'DFGS' FROM 'WATSUB'
C
C     VOLT=litter volume from hour1.f
C     VOLWM,VOLPM=micropore water volume, air volume from watsub.f
C     VOLW*=equivalent aqueous volume for gas
C     S*L=solubility of gas in water from hour1.f
C     C*G=gas concentration
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C     R*DFG=surface gas volatilization
C     DFGS=rate constant for air-water gas exchange from watsub.f
C     *S2=litter solute content
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     R*DXR=gas exchange between atmosphere and surface litter water for gas flux calculations
C
      IF(VOLT(0,NY,NX).GT.ZEROS2(NY,NX)
     2.AND.VOLPM(M,0,NY,NX).GT.ZEROS2(NY,NX)
     3.AND.VOLWM(M,0,NY,NX).GT.ZEROS2(NY,NX))THEN
      VOLWCO(0,NY,NX)=VOLWM(M,0,NY,NX)*SCO2L(0,NY,NX)
      VOLWCH(0,NY,NX)=VOLWM(M,0,NY,NX)*SCH4L(0,NY,NX)
      VOLWOX(0,NY,NX)=VOLWM(M,0,NY,NX)*SOXYL(0,NY,NX)
      VOLWNG(0,NY,NX)=VOLWM(M,0,NY,NX)*SN2GL(0,NY,NX)
      VOLWN2(0,NY,NX)=VOLWM(M,0,NY,NX)*SN2OL(0,NY,NX)
      VOLWN3(0,NY,NX)=VOLWM(M,0,NY,NX)*SNH3L(0,NY,NX)
      VOLWHG(0,NY,NX)=VOLWM(M,0,NY,NX)*SH2GL(0,NY,NX)
      VOLWXA(0,NY,NX)=14.0*VOLWM(M,0,NY,NX)
      CO2G0=CCO2G(0,NY,NX)*VOLPM(M,0,NY,NX)
      CH4G0=CCH4G(0,NY,NX)*VOLPM(M,0,NY,NX)
      OXYG0=COXYG(0,NY,NX)*VOLPM(M,0,NY,NX)
      Z2GG0=CZ2GG(0,NY,NX)*VOLPM(M,0,NY,NX)
      Z2OG0=CZ2OG(0,NY,NX)*VOLPM(M,0,NY,NX)
      ZN3G0=CNH3G(0,NY,NX)*VOLPM(M,0,NY,NX)
      H2GG0=CH2GG(0,NY,NX)*VOLPM(M,0,NY,NX)
      VOLCOR(NY,NX)=VOLWCO(0,NY,NX)+VOLPM(M,0,NY,NX)
      VOLCHR(NY,NX)=VOLWCH(0,NY,NX)+VOLPM(M,0,NY,NX)
      VOLOXR(NY,NX)=VOLWOX(0,NY,NX)+VOLPM(M,0,NY,NX)
      VOLNGR(NY,NX)=VOLWNG(0,NY,NX)+VOLPM(M,0,NY,NX)
      VOLN2R(NY,NX)=VOLWN2(0,NY,NX)+VOLPM(M,0,NY,NX)
      VOLN3R(NY,NX)=VOLWN3(0,NY,NX)+VOLPM(M,0,NY,NX)
      VOLHGR(NY,NX)=VOLWHG(0,NY,NX)+VOLPM(M,0,NY,NX)
      RCODFG(0,NY,NX)=DFGS(M,0,NY,NX)
     2*(AMAX1(ZEROS(NY,NX),CO2G0)*VOLWCO(0,NY,NX)
     3-AMAX1(ZEROS(NY,NX),CO2S2(0,NY,NX)+RCODXR)
     4*VOLPM(M,0,NY,NX))/VOLCOR(NY,NX)
      RCHDFG(0,NY,NX)=DFGS(M,0,NY,NX)
     2*(AMAX1(ZEROS(NY,NX),CH4G0)*VOLWCH(0,NY,NX)
     3-AMAX1(ZEROS(NY,NX),CH4S2(0,NY,NX)+RCHDXR)
     4*VOLPM(M,0,NY,NX))/VOLCHR(NY,NX)
      ROXDFG(0,NY,NX)=DFGS(M,0,NY,NX)
     2*(AMAX1(ZEROS(NY,NX),OXYG0)*VOLWOX(0,NY,NX)
     3-AMAX1(ZEROS(NY,NX),OXYS2(0,NY,NX)+ROXDXR)
     4*VOLPM(M,0,NY,NX))/VOLOXR(NY,NX)
      RNGDFG(0,NY,NX)=DFGS(M,0,NY,NX)
     2*(AMAX1(ZEROS(NY,NX),Z2GG0)*VOLWNG(0,NY,NX)
     3-AMAX1(ZEROS(NY,NX),Z2GS2(0,NY,NX)+RNGDXR)
     4*VOLPM(M,0,NY,NX))/VOLNGR(NY,NX)
      RN2DFG(0,NY,NX)=DFGS(M,0,NY,NX)
     2*(AMAX1(ZEROS(NY,NX),Z2OG0)*VOLWN2(0,NY,NX)
     3-AMAX1(ZEROS(NY,NX),Z2OS2(0,NY,NX)+RN2DXR)
     4*VOLPM(M,0,NY,NX))/VOLN2R(NY,NX)
      RN3DFG(0,NY,NX)=DFGS(M,0,NY,NX)
     2*(AMAX1(ZEROS(NY,NX),ZN3G0)*VOLWN3(0,NY,NX)
     3-AMAX1(ZEROS(NY,NX),ZNH3S2(0,NY,NX)+RN3DXR)
     4*VOLPM(M,0,NY,NX))/VOLN3R(NY,NX)
      CNH3S0=AMAX1(0.0,(ZNH3S2(0,NY,NX)+RN3DFG(0,NY,NX)))
     2/VOLWXA(0,NY,NX)
      CNH4S0=AMAX1(0.0,ZNH4S2(0,NY,NX))
     2/VOLWXA(0,NY,NX)
      RHGDFG(0,NY,NX)=DFGS(M,0,NY,NX)
     2*(AMAX1(ZEROS(NY,NX),H2GG0)*VOLWHG(0,NY,NX)
     3-AMAX1(ZEROS(NY,NX),H2GS2(0,NY,NX)+RHGDXR)
     4*VOLPM(M,0,NY,NX))/VOLHGR(NY,NX)
C     IF(J.EQ.24)THEN
C     WRITE(*,323)'RCODFG',I,J,NX,NY,M,MM,RCODFG(0,NY,NX)
C    2,DFGS(M,0,NY,NX),CO2G0,VOLWCO(0,NY,NX),CO2S2(0,NY,NX)
C    3,VOLPM(M,0,NY,NX),VOLCOR(NY,NX),RCODXR
C     WRITE(*,323)'RCHDFG',I,J,NX,NY,M,MM,RCHDFG(0,NY,NX)
C    2,DFGS(M,0,NY,NX),CH4G0,VOLWCH(0,NY,NX),CH4S2(0,NY,NX)
C    3,VOLPM(M,0,NY,NX),VOLCHR(NY,NX),RCHDXR
C     WRITE(*,323)'ROXDFG',I,J,NX,NY,M,MM,ROXDFG(0,NY,NX)
C    2,DFGS(M,0,NY,NX),OXYG0,VOLWOX(0,NY,NX),OXYS2(0,NY,NX)
C    3,VOLPM(M,0,NY,NX),VOLOXR(NY,NX),ROXDXR,XOXDFG(0,NY,NX)
323   FORMAT(A8,6I4,30E12.4)
C     ENDIF
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*DFG=hourly surface gas volatilization
C     R*DFG=surface gas volatilization
C
      XCODFG(0,NY,NX)=XCODFG(0,NY,NX)+RCODFG(0,NY,NX)
      XCHDFG(0,NY,NX)=XCHDFG(0,NY,NX)+RCHDFG(0,NY,NX)
      XOXDFG(0,NY,NX)=XOXDFG(0,NY,NX)+ROXDFG(0,NY,NX)
      XNGDFG(0,NY,NX)=XNGDFG(0,NY,NX)+RNGDFG(0,NY,NX)
      XN2DFG(0,NY,NX)=XN2DFG(0,NY,NX)+RN2DFG(0,NY,NX)
      XN3DFG(0,NY,NX)=XN3DFG(0,NY,NX)+RN3DFG(0,NY,NX)
      XHGDFG(0,NY,NX)=XHGDFG(0,NY,NX)+RHGDFG(0,NY,NX)
      ELSE
      RCODFG(0,NY,NX)=0.0
      RCHDFG(0,NY,NX)=0.0
      ROXDFG(0,NY,NX)=0.0
      RNGDFG(0,NY,NX)=0.0
      RN2DFG(0,NY,NX)=0.0
      RN3DFG(0,NY,NX)=0.0
      RHGDFG(0,NY,NX)=0.0
      ENDIF
C
C     SURFACE GAS EXCHANGE FROM GAS DIFFUSIVITY THROUGH
C     SOIL SURFACE LAYER AND THROUGH ATMOSPHERE BOUNDARY
C     LAYER
C
C     THETPM=air-filled porosity from watsub.f
C     BKDS=bulk density
C
      IF(THETPM(M,NU(NY,NX),NY,NX).GT.THETX
     2.AND.BKDS(NU(NY,NX),NY,NX).GT.ZERO)THEN
C
C     GASEOUS DIFFUSIVITIES
C
C     DFLG2=air-filled porosity effect on gaseous diffusivity
C     POROQ=Penman Water Linear Reduction tortuosity from starts.f
C     POROS=total porosity
C     DLYR=soil layer thickness
C     D*G=gaseous diffusivity in soil
C     *SGL2= gaseous diffusivity in air
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C
      DFLG2=AMAX1(0.0,THETPM(M,NU(NY,NX),NY,NX))*POROQ
     2*THETPM(M,NU(NY,NX),NY,NX)/POROS(NU(NY,NX),NY,NX)
     3*AREA(3,NU(NY,NX),NY,NX)/AMAX1(ZERO2,DLYR(3,NU(NY,NX),NY,NX))
      DCO2G(3,NU(NY,NX),NY,NX)=DFLG2*CGSGL2(NU(NY,NX),NY,NX)
      DCH4G(3,NU(NY,NX),NY,NX)=DFLG2*CHSGL2(NU(NY,NX),NY,NX)
      DOXYG(3,NU(NY,NX),NY,NX)=DFLG2*OGSGL2(NU(NY,NX),NY,NX)
      DZ2GG(3,NU(NY,NX),NY,NX)=DFLG2*ZGSGL2(NU(NY,NX),NY,NX)
      DZ2OG(3,NU(NY,NX),NY,NX)=DFLG2*Z2SGL2(NU(NY,NX),NY,NX)
      DNH3G(3,NU(NY,NX),NY,NX)=DFLG2*ZHSGL2(NU(NY,NX),NY,NX)
      DH2GG(3,NU(NY,NX),NY,NX)=DFLG2*HGSGL2(NU(NY,NX),NY,NX)
C
C     SURFACE GAS CONCENTRATIONS
C
C     C*G2=gaseous concentration
C     *G2=gaseous content
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C     VOLPM=air-filled porosity
C
      CCO2G2=AMAX1(0.0,CO2G2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
      CCH4G2=AMAX1(0.0,CH4G2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
      COXYG2=AMAX1(0.0,OXYG2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
      CZ2GG2=AMAX1(0.0,Z2GG2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
      CZ2OG2=AMAX1(0.0,Z2OG2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
      CNH3G2=AMAX1(0.0,ZN3G2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
      CH2GG2=AMAX1(0.0,H2GG2(NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX))
C
C     EQUILIBRIUM CONCENTRATIONS AT SOIL SURFACE AT WHICH
C     GASEOUS DIFFUSION THROUGH SOIL SURFACE LAYER = GASEOUS
C     DIFFUSION THROUGH ATMOSPHERE BOUNDARY LAYER CALCULATED
C     FROM GASEOUS DIFFUSIVITY AND BOUNDARY LAYER CONDUCTANCE
C
C     D*GQ=gaseous diffusivity between soil surface and atmosphere
C     D*G=gaseous diffusivity in soil
C     PARG*=boundary layer conductance above soil surface
C     DFV*G=diffusive gas flux
C     C*E=atmospheric gas concentration from hour1.f
C     C*G2=gaseous concentration
C
      DCO2GQ=DCO2G(3,NU(NY,NX),NY,NX)*PARGCO(NY,NX)
     2/(DCO2G(3,NU(NY,NX),NY,NX)+PARGCO(NY,NX))
      DCH4GQ=DCH4G(3,NU(NY,NX),NY,NX)*PARGCH(NY,NX)
     2/(DCH4G(3,NU(NY,NX),NY,NX)+PARGCH(NY,NX))
      DOXYGQ=DOXYG(3,NU(NY,NX),NY,NX)*PARGOX(NY,NX)
     2/(DOXYG(3,NU(NY,NX),NY,NX)+PARGOX(NY,NX))
      DZ2GGQ=DZ2GG(3,NU(NY,NX),NY,NX)*PARGNG(NY,NX)
     2/(DZ2GG(3,NU(NY,NX),NY,NX)+PARGNG(NY,NX))
      DZ2OGQ=DZ2OG(3,NU(NY,NX),NY,NX)*PARGN2(NY,NX)
     2/(DZ2OG(3,NU(NY,NX),NY,NX)+PARGN2(NY,NX))
      DNH3GQ=DNH3G(3,NU(NY,NX),NY,NX)*PARGN3(NY,NX)
     2/(DNH3G(3,NU(NY,NX),NY,NX)+PARGN3(NY,NX))
      DH2GGQ=DH2GG(3,NU(NY,NX),NY,NX)*PARGH2(NY,NX)
     2/(DH2GG(3,NU(NY,NX),NY,NX)+PARGH2(NY,NX))
      DFVCOG=DCO2GQ*(CCO2E(NY,NX)-CCO2G2)
      DFVCHG=DCH4GQ*(CCH4E(NY,NX)-CCH4G2)
      DFVOXG=DOXYGQ*(COXYE(NY,NX)-COXYG2)
      DFVNGG=DZ2GGQ*(CZ2GE(NY,NX)-CZ2GG2)
      DFVN2G=DZ2OGQ*(CZ2OE(NY,NX)-CZ2OG2)
      DFVN3G=DNH3GQ*(CNH3E(NY,NX)-CNH3G2)
      DFVHGG=DH2GGQ*(CH2GE(NY,NX)-CH2GG2)
C
C     CONVECTIVE GAS TRANSFER DRIVEN BY SURFACE WATER FLUXES
C     FROM 'WATSUB' AND GAS CONCENTRATIONS IN THE SOIL SURFACE
C     OR THE ATMOSPHERE DEPENDING ON WATER FLUX DIRECTION
C
C     FLQM=total water flux into soil micropore+macropore from watsub.f
C     VOLPM=air-filled porosity
C     RFL*G=convective gas flux
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C     *G2=gaseous content
C     C*E=atmospheric gas concentration from hour1.f
C
      IF(FLQM(3,NU(NY,NX),NY,NX).GT.0.0)THEN
      IF(VOLPM(M,NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      VFLW=-AMAX1(0.0,AMIN1(VFLWX,FLQM(3,NU(NY,NX),NY,NX)
     2/VOLPM(M,NU(NY,NX),NY,NX)))
      ELSE
      VFLW=-VFLWX
      ENDIF
      RFLCOG=VFLW*AMAX1(0.0,CO2G2(NU(NY,NX),NY,NX))
      RFLCHG=VFLW*AMAX1(0.0,CH4G2(NU(NY,NX),NY,NX))
      RFLOXG=VFLW*AMAX1(0.0,OXYG2(NU(NY,NX),NY,NX))
      RFLNGG=VFLW*AMAX1(0.0,Z2GG2(NU(NY,NX),NY,NX))
      RFLN2G=VFLW*AMAX1(0.0,Z2OG2(NU(NY,NX),NY,NX))
      RFLN3G=VFLW*AMAX1(0.0,ZN3G2(NU(NY,NX),NY,NX))
      RFLH2G=VFLW*AMAX1(0.0,H2GG2(NU(NY,NX),NY,NX))
      ELSE
      RFLCOG=-FLQM(3,NU(NY,NX),NY,NX)*CCO2E(NY,NX)
      RFLCHG=-FLQM(3,NU(NY,NX),NY,NX)*CCH4E(NY,NX)
      RFLOXG=-FLQM(3,NU(NY,NX),NY,NX)*COXYE(NY,NX)
      RFLNGG=-FLQM(3,NU(NY,NX),NY,NX)*CZ2GE(NY,NX)
      RFLN2G=-FLQM(3,NU(NY,NX),NY,NX)*CZ2OE(NY,NX)
      RFLN3G=-FLQM(3,NU(NY,NX),NY,NX)*CNH3E(NY,NX)
      RFLH2G=-FLQM(3,NU(NY,NX),NY,NX)*CH2GE(NY,NX)
      ENDIF
C
C     TOTAL SOIL GAS FLUX FROM DIFFUSIVE + CONVECTIVE FLUX
C
C     R*FLG=convective+diffusive gas flux
C     gas code:*CO*=CO2,*OX*=O2,*CH*=CH4,*NG*=N2,*N2*=N2O,*NH*=NH3,*HG*=H2
C     DFV*G=diffusive gas flux
C     RFL*G=convective gas flux
C
      RCOFLG(3,NU(NY,NX),NY,NX)=DFVCOG+RFLCOG
      RCHFLG(3,NU(NY,NX),NY,NX)=DFVCHG+RFLCHG
      ROXFLG(3,NU(NY,NX),NY,NX)=DFVOXG+RFLOXG
      RNGFLG(3,NU(NY,NX),NY,NX)=DFVNGG+RFLNGG
      RN2FLG(3,NU(NY,NX),NY,NX)=DFVN2G+RFLN2G
      RN3FLG(3,NU(NY,NX),NY,NX)=DFVN3G+RFLN3G
      RHGFLG(3,NU(NY,NX),NY,NX)=DFVHGG+RFLH2G
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*FLG=hourly convective+diffusive gas flux
C
      XCOFLG(3,NU(NY,NX),NY,NX)=XCOFLG(3,NU(NY,NX),NY,NX)
     2+RCOFLG(3,NU(NY,NX),NY,NX)
      XCHFLG(3,NU(NY,NX),NY,NX)=XCHFLG(3,NU(NY,NX),NY,NX)
     2+RCHFLG(3,NU(NY,NX),NY,NX)
      XOXFLG(3,NU(NY,NX),NY,NX)=XOXFLG(3,NU(NY,NX),NY,NX)
     2+ROXFLG(3,NU(NY,NX),NY,NX)
      XNGFLG(3,NU(NY,NX),NY,NX)=XNGFLG(3,NU(NY,NX),NY,NX)
     2+RNGFLG(3,NU(NY,NX),NY,NX)
      XN2FLG(3,NU(NY,NX),NY,NX)=XN2FLG(3,NU(NY,NX),NY,NX)
     2+RN2FLG(3,NU(NY,NX),NY,NX)
      XN3FLG(3,NU(NY,NX),NY,NX)=XN3FLG(3,NU(NY,NX),NY,NX)
     2+RN3FLG(3,NU(NY,NX),NY,NX)
      XHGFLG(3,NU(NY,NX),NY,NX)=XHGFLG(3,NU(NY,NX),NY,NX)
     2+RHGFLG(3,NU(NY,NX),NY,NX)
C     IF(J.EQ.24)THEN
C     WRITE(*,3131)'ROXFLG',I,J,NX,NY,M,MM,XOXFLG(3,NU(NY,NX),NY,NX)
C    2,ROXFLG(3,NU(NY,NX),NY,NX),DFVOXG,RFLOXG,COXYE(NY,NX)
C    2,COXYG2,DOXYGQ,OXYG2(NU(NY,NX),NY,NX),FLQM(3,NU(NY,NX),NY,NX)
C    3,VFLW,DOXYG(3,NU(NY,NX),NY,NX),PARGOX(NY,NX)
C    4,THETPM(M,NU(NY,NX),NY,NX),VOLPM(M,NU(NY,NX),NY,NX)
C    5,DFGS(M,NU(NY,NX),NY,NX),FLWM(M,3,NU(NY,NX),NY,NX)
C    2+FLWHM(M,3,NU(NY,NX),NY,NX)
C     WRITE(*,3131)'RNGFLG',I,J,NX,NY,M,MM,XNGFLG(3,NU(NY,NX),NY,NX)
C    2,RNGFLG(3,NU(NY,NX),NY,NX),DFVNGG,RFLNGG,CZ2GE(NY,NX)
C    2,CZ2GG2,DZ2GGQ,Z2GG2(NU(NY,NX),NY,NX),FLQM(3,NU(NY,NX),NY,NX)
C    3,VFLW,DZ2GG(3,NU(NY,NX),NY,NX),PARGNG(NY,NX)
C    4,THETPM(M,NU(NY,NX),NY,NX),VOLPM(M,NU(NY,NX),NY,NX)
3131  FORMAT(A8,6I4,30E12.4)
C     ENDIF
C
C     SOIL SURFACE WATER-AIR GAS EXCHANGE
C
C     VOLWM=micropore water-filled porosity from watsub.f
C     VOLW*=equivalent aqueous volume for gas
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C     S*L=solubility of gas in water from hour1.f
C     VOLPM=air-filled porosity
C     R*DFG=water-air gas flux
C     DFGS=rate constant for air-water gas exchange from watsub.f
C     *G2,*S2=gaseous,aqueous gas content
C     R*DXS=gas exchange between atmosphere and soil surface water
C
      IF(VOLWM(M,NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      VOLWCO(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*SCO2L(NU(NY,NX),NY,NX)
      VOLWCH(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*SCH4L(NU(NY,NX),NY,NX)
      VOLWOX(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*SOXYL(NU(NY,NX),NY,NX)
      VOLWNG(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*SN2GL(NU(NY,NX),NY,NX)
      VOLWN2(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*SN2OL(NU(NY,NX),NY,NX)
      VOLWN3(NU(NY,NX),NY,NX)=VOLWMA(NU(NY,NX),NY,NX)
     2*SNH3L(NU(NY,NX),NY,NX)
      VOLWNB(NU(NY,NX),NY,NX)=VOLWMB(NU(NY,NX),NY,NX)
     2*SNH3L(NU(NY,NX),NY,NX)
      VOLWHG(NU(NY,NX),NY,NX)=VOLWM(M,NU(NY,NX),NY,NX)
     2*SH2GL(NU(NY,NX),NY,NX)
      VOLCOT(NY,NX)=VOLWCO(NU(NY,NX),NY,NX)+VOLPM(M,NU(NY,NX),NY,NX)
      VOLCHT(NY,NX)=VOLWCH(NU(NY,NX),NY,NX)+VOLPM(M,NU(NY,NX),NY,NX)
      VOLOXT(NY,NX)=VOLWOX(NU(NY,NX),NY,NX)+VOLPM(M,NU(NY,NX),NY,NX)
      VOLNGT(NY,NX)=VOLWNG(NU(NY,NX),NY,NX)+VOLPM(M,NU(NY,NX),NY,NX)
      VOLN2T(NY,NX)=VOLWN2(NU(NY,NX),NY,NX)+VOLPM(M,NU(NY,NX),NY,NX)
      VOLN3T(NY,NX)=VOLWN3(NU(NY,NX),NY,NX)+VOLPMA(NU(NY,NX),NY,NX)
      VOLNBT(NY,NX)=VOLWNB(NU(NY,NX),NY,NX)+VOLPMB(NU(NY,NX),NY,NX)
      VOLHGT(NY,NX)=VOLWHG(NU(NY,NX),NY,NX)+VOLPM(M,NU(NY,NX),NY,NX)
      RCODFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),CO2G2(NU(NY,NX),NY,NX))
     3*VOLWCO(NU(NY,NX),NY,NX)-AMAX1(ZEROS(NY,NX)
     2,CO2S2(NU(NY,NX),NY,NX)+RCODXS)
     4*VOLPM(M,NU(NY,NX),NY,NX))/VOLCOT(NY,NX)
      RCHDFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),CH4G2(NU(NY,NX),NY,NX))
     3*VOLWCH(NU(NY,NX),NY,NX)-AMAX1(ZEROS(NY,NX)
     2,CH4S2(NU(NY,NX),NY,NX)+RCHDXS)
     4*VOLPM(M,NU(NY,NX),NY,NX))/VOLCHT(NY,NX)
      ROXDFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),OXYG2(NU(NY,NX),NY,NX))
     3*VOLWOX(NU(NY,NX),NY,NX)-AMAX1(ZEROS(NY,NX)
     2,OXYS2(NU(NY,NX),NY,NX)+ROXDXS)
     4*VOLPM(M,NU(NY,NX),NY,NX))/VOLOXT(NY,NX)
      RNGDFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),Z2GG2(NU(NY,NX),NY,NX))
     3*VOLWNG(NU(NY,NX),NY,NX)-AMAX1(ZEROS(NY,NX)
     4,Z2GS2(NU(NY,NX),NY,NX)+RNGDXS)
     4*VOLPM(M,NU(NY,NX),NY,NX))/VOLNGT(NY,NX)
      RN2DFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),Z2OG2(NU(NY,NX),NY,NX))
     3*VOLWN2(NU(NY,NX),NY,NX)-AMAX1(ZEROS(NY,NX)
     2,Z2OS2(NU(NY,NX),NY,NX)+RN2DXS)
     4*VOLPM(M,NU(NY,NX),NY,NX))/VOLN2T(NY,NX)
      IF(VOLN3T(NY,NX).GT.ZEROS2(NY,NX)
     2.AND.VOLWXA(NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      RN3DFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),ZN3G2(NU(NY,NX),NY,NX))
     3*VOLWN3(NU(NY,NX),NY,NX)-AMAX1(ZEROS(NY,NX)
     4,ZNH3S2(NU(NY,NX),NY,NX)+RN3DXS)
     5*VOLPMA(NU(NY,NX),NY,NX))/VOLN3T(NY,NX)
      CNH3S0=AMAX1(0.0,(ZNH3S2(NU(NY,NX),NY,NX)
     2+RN3DFG(NU(NY,NX),NY,NX))/VOLWXA(NU(NY,NX),NY,NX))
      CNH4S0=AMAX1(0.0,ZNH4S2(NU(NY,NX),NY,NX))
     2/VOLWXA(NU(NY,NX),NY,NX)
      ELSE
      RN3DFG(NU(NY,NX),NY,NX)=0.0
      ENDIF
      IF(VOLNBT(NY,NX).GT.ZEROS2(NY,NX)
     2.AND.VOLWXB(NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      RNBDFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),ZN3G2(NU(NY,NX),NY,NX))
     3*VOLWNB(NU(NY,NX),NY,NX)-AMAX1(ZEROS(NY,NX)
     4,ZNH3B2(NU(NY,NX),NY,NX)+RNBDXS)
     5*VOLPMB(NU(NY,NX),NY,NX))/VOLNBT(NY,NX)
      CNH3B0=AMAX1(0.0,(ZNH3B2(NU(NY,NX),NY,NX)
     2+RNBDFG(NU(NY,NX),NY,NX))/VOLWXB(NU(NY,NX),NY,NX))
      CNH4B0=AMAX1(0.0,ZNH4B2(NU(NY,NX),NY,NX))
     2/VOLWXB(NU(NY,NX),NY,NX)
      ELSE
      RNBDFG(NU(NY,NX),NY,NX)=0.0
      ENDIF
      RHGDFG(NU(NY,NX),NY,NX)=DFGS(M,NU(NY,NX),NY,NX)
     2*(AMAX1(ZEROS(NY,NX),H2GG2(NU(NY,NX),NY,NX))
     3*VOLWHG(NU(NY,NX),NY,NX)-AMAX1(ZEROS(NY,NX)
     4,H2GS2(NU(NY,NX),NY,NX)+RHGDXS)
     4*VOLPM(M,NU(NY,NX),NY,NX))/VOLHGT(NY,NX)
C     IF(I.EQ.121)THEN
C     WRITE(*,323)'RCODFG',I,J,M,MM,NX,NY,XCODFG(NU(NY,NX),NY,NX)
C    2,RCODFG(NU(NY,NX),NY,NX),DFGS(M,NU(NY,NX),NY,NX)
C    2,CO2G2(NU(NY,NX),NY,NX),VOLWCO(NU(NY,NX),NY,NX)
C    2,CO2S2(NU(NY,NX),NY,NX),RCODXS,VOLWM(M,NU(NY,NX),NY,NX)
C    4,VOLPM(M,NU(NY,NX),NY,NX),VOLCOT(NY,NX),SCO2L(NU(NY,NX),NY,NX)
C     5,RCOFLG(3,NU(NY,NX),NY,NX),DFVCOG,RFLCOG
C     WRITE(*,323)'ROXDFG',I,J,M,MM,NX,NY,XOXDFG(NU(NY,NX),NY,NX)
C    2,ROXDFG(NU(NY,NX),NY,NX),DFGS(M,NU(NY,NX),NY,NX)
C    2,OXYG2(NU(NY,NX),NY,NX),VOLWOX(NU(NY,NX),NY,NX)
C    2,OXYS2(NU(NY,NX),NY,NX),ROXDXS,VOLWM(M,NU(NY,NX),NY,NX)
C    4,VOLPM(M,NU(NY,NX),NY,NX),VOLOXT(NY,NX),SOXYL(NU(NY,NX),NY,NX)
C    5,ROXFLG(3,NU(NY,NX),NY,NX),DFVOXG,RFLOXG
C     WRITE(*,323)'RN3FLG',I,J,M,MM,NX,NY,RN3FLG(3,NU(NY,NX),NY,NX)
C    2,DNH3GQ,CNH3E(NY,NX),CNH3G2,FLQM(3,NU(NY,NX),NY,NX),CNH3GV
C    2,CNH3B2,ZNH3B2(NU(NY,NX),NY,NX),RNBDFG(NU(NY,NX),NY,NX)
C    3,DFGS(M,NU(NY,NX),NY,NX),ZN3G2B,VOLPMB(NU(NY,NX),NY,NX)
C    4,ZNH3B2(NU(NY,NX),NY,NX),VOLWNB(NU(NY,NX),NY,NX)
C    5,VOLWMB,SNH3L(NU(NY,NX),NY,NX)
C     WRITE(*,323)'RNGDFG',I,J,M,MM,NX,NY,RNGDFG(NU(NY,NX),NY,NX)
C    2,DFGS(M,NU(NY,NX),NY,NX),Z2GG2(NU(NY,NX),NY,NX)
C    3,VOLWNG(NU(NY,NX),NY,NX),Z2GS2(NU(NY,NX),NY,NX)
C    4,RNGDFS(NY,NX),VOLPM(M,NU(NY,NX),NY,NX),VOLNGT(NY,NX)
C     ENDIF
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*DFG=hourly water-air gas flux
C
      XCODFG(NU(NY,NX),NY,NX)=XCODFG(NU(NY,NX),NY,NX)
     2+RCODFG(NU(NY,NX),NY,NX)
      XCHDFG(NU(NY,NX),NY,NX)=XCHDFG(NU(NY,NX),NY,NX)
     2+RCHDFG(NU(NY,NX),NY,NX)
      XOXDFG(NU(NY,NX),NY,NX)=XOXDFG(NU(NY,NX),NY,NX)
     2+ROXDFG(NU(NY,NX),NY,NX)
      XNGDFG(NU(NY,NX),NY,NX)=XNGDFG(NU(NY,NX),NY,NX)
     2+RNGDFG(NU(NY,NX),NY,NX)
      XN2DFG(NU(NY,NX),NY,NX)=XN2DFG(NU(NY,NX),NY,NX)
     2+RN2DFG(NU(NY,NX),NY,NX)
      XN3DFG(NU(NY,NX),NY,NX)=XN3DFG(NU(NY,NX),NY,NX)
     2+RN3DFG(NU(NY,NX),NY,NX)
      XNBDFG(NU(NY,NX),NY,NX)=XNBDFG(NU(NY,NX),NY,NX)
     2+RNBDFG(NU(NY,NX),NY,NX)
      XHGDFG(NU(NY,NX),NY,NX)=XHGDFG(NU(NY,NX),NY,NX)
     2+RHGDFG(NU(NY,NX),NY,NX)
C     WRITE(*,3131)'ROXDFG',I,J,NX,NY,M,MM,XOXDFG(NU(NY,NX),NY,NX)
C    2,ROXDFG(NU(NY,NX),NY,NX),DFGS(M,NU(NY,NX),NY,NX)
C    2,AMAX1(ZEROS(NY,NX),OXYG2(NU(NY,NX),NY,NX))
C    3,VOLWOX(NU(NY,NX),NY,NX),AMAX1(ZEROS(NY,NX)
C    4,OXYS2(NU(NY,NX),NY,NX)),VOLPM(M,NU(NY,NX),NY,NX)
      ELSE
      RCODFG(NU(NY,NX),NY,NX)=0.0
      RCHDFG(NU(NY,NX),NY,NX)=0.0
      ROXDFG(NU(NY,NX),NY,NX)=0.0
      RNGDFG(NU(NY,NX),NY,NX)=0.0
      RN2DFG(NU(NY,NX),NY,NX)=0.0
      RN3DFG(NU(NY,NX),NY,NX)=0.0
      RNBDFG(NU(NY,NX),NY,NX)=0.0
      RHGDFG(NU(NY,NX),NY,NX)=0.0
      ENDIF
      ELSE
      RCOFLG(3,NU(NY,NX),NY,NX)=0.0
      RCHFLG(3,NU(NY,NX),NY,NX)=0.0
      ROXFLG(3,NU(NY,NX),NY,NX)=0.0
      RNGFLG(3,NU(NY,NX),NY,NX)=0.0
      RN2FLG(3,NU(NY,NX),NY,NX)=0.0
      RN3FLG(3,NU(NY,NX),NY,NX)=0.0
      RHGFLG(3,NU(NY,NX),NY,NX)=0.0
      RCODFG(NU(NY,NX),NY,NX)=0.0
      RCHDFG(NU(NY,NX),NY,NX)=0.0
      ROXDFG(NU(NY,NX),NY,NX)=0.0
      RN2DFG(NU(NY,NX),NY,NX)=0.0
      RNGDFG(NU(NY,NX),NY,NX)=0.0
      RN3DFG(NU(NY,NX),NY,NX)=0.0
      RNBDFG(NU(NY,NX),NY,NX)=0.0
      RHGDFG(NU(NY,NX),NY,NX)=0.0
      ENDIF
C
C     SOLUTE FLUXES BETWEEN ADJACENT GRID CELLS
C
C     N3,N2,N1=L,NY,NX of source grid cell
C     N6,N5,N4=L,NY,NX of destination grid cell
C
      IFLGB=0
      DO 125 L=1,NL(NY,NX)
      N1=NX
      N2=NY
      N3=L
C
C     LOCATE INTERNAL BOUNDARIES BETWEEN ADJACENT GRID CELLS
C
      DO 120 N=NCN(N2,N1),3
      IF(N.EQ.1)THEN
      IF(NX.EQ.NHE)THEN
      GO TO 120
      ELSE
      N4=NX+1
      N5=NY
      N6=L
      ENDIF
      ELSEIF(N.EQ.2)THEN
      IF(NY.EQ.NVS)THEN
      GO TO 120
      ELSE
      N4=NX
      N5=NY+1
      N6=L
      ENDIF
      ELSEIF(N.EQ.3)THEN
      IF(L.EQ.NL(NY,NX))THEN
      GO TO 120
      ELSE
      N4=NX
      N5=NY
      N6=L+1
      ENDIF
      ENDIF
      DO 1100 LL=N6,NL(NY,NX)
      IF(VOLX(LL,N5,N4).GT.ZEROS2(N5,N4))THEN
      N6=LL
      GO TO 1101
      ENDIF
1100  CONTINUE
1101  CONTINUE
C
C     SOLUTE FLUXES BETWEEN ADJACENT GRID CELLS FROM
C     WATER CONTENTS AND WATER FLUXES 'FLQM' FROM 'WATSUB'
C
C     VOLX,VOLY=soil volume excluding rock, macropore
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C     VOLWM,VOLWHM=micropore,macropore water-filled porosity from watsub.f
C     THETW=volumetric water content
C     FLPM=change in air volume
C     XNPT=1/number of cycles NPH-1 for gas flux calculations
C
      IF(VOLX(N3,N2,N1).GT.ZEROS2(N2,N1))THEN
      IF(N3.GE.NUM(N2,N1).AND.N6.GE.NUM(N5,N4)
     2.AND.N3.LE.NL(N2,N1).AND.N6.LE.NL(N5,N4))THEN
      IF(M.NE.MX)THEN
      VOLW4A=VOLWM(M,N3,N2,N1)*VLNH4(N3,N2,N1)
      VOLW4B=VOLWM(M,N3,N2,N1)*VLNHB(N3,N2,N1)
      VOLH4A=VOLWHM(M,N3,N2,N1)*VLNH4(N3,N2,N1)
      VOLH4B=VOLWHM(M,N3,N2,N1)*VLNHB(N3,N2,N1)
      VOLW3A=VOLWM(M,N3,N2,N1)*VLNO3(N3,N2,N1)
      VOLW3B=VOLWM(M,N3,N2,N1)*VLNOB(N3,N2,N1)
      VOLH3A=VOLWHM(M,N3,N2,N1)*VLNO3(N3,N2,N1)
      VOLH3B=VOLWHM(M,N3,N2,N1)*VLNOB(N3,N2,N1)
      VOLW2A=VOLWM(M,N3,N2,N1)*VLPO4(N3,N2,N1)
      VOLW2B=VOLWM(M,N3,N2,N1)*VLPOB(N3,N2,N1)
      VOLH2A=VOLWHM(M,N3,N2,N1)*VLPO4(N3,N2,N1)
      VOLH2B=VOLWHM(M,N3,N2,N1)*VLPOB(N3,N2,N1)
      VOLWMA(N6,N5,N4)=VOLWM(M,N6,N5,N4)*VLNH4(N6,N5,N4)
      VOLWMB(N6,N5,N4)=VOLWM(M,N6,N5,N4)*VLNHB(N6,N5,N4)
      VOLWXA(N6,N5,N4)=14.0*VOLWMA(N6,N5,N4)
      VOLWXB(N6,N5,N4)=14.0*VOLWMB(N6,N5,N4)
      VOLWOA=VOLWM(M,N6,N5,N4)*VLNO3(N6,N5,N4)
      VOLWOB=VOLWM(M,N6,N5,N4)*VLNOB(N6,N5,N4)
      VOLHOA=VOLWHM(M,N6,N5,N4)*VLNO3(N6,N5,N4)
      VOLHOB=VOLWHM(M,N6,N5,N4)*VLNOB(N6,N5,N4)
      VOLWPA=VOLWM(M,N6,N5,N4)*VLPO4(N6,N5,N4)
      VOLWPB=VOLWM(M,N6,N5,N4)*VLPOB(N6,N5,N4)
      VOLHPA=VOLWHM(M,N6,N5,N4)*VLPO4(N6,N5,N4)
      VOLHPB=VOLWHM(M,N6,N5,N4)*VLPOB(N6,N5,N4)
      VOLPMA(N6,N5,N4)=VOLPM(M,N6,N5,N4)*VLNH4(N6,N5,N4)
      VOLPMB(N6,N5,N4)=VOLPM(M,N6,N5,N4)*VLNHB(N6,N5,N4)
      THETW1(N3,N2,N1)=AMAX1(0.0,VOLWM(M,N3,N2,N1)/VOLY(N3,N2,N1))
      THETW1(N6,N5,N4)=AMAX1(0.0,VOLWM(M,N6,N5,N4)/VOLY(N6,N5,N4))
      FLVM(N6,N5,N4)=FLPM(M,N6,N5,N4)*XNPT
C
C     GASEOUS SOLUBILITIES
C
C     VOLWM=micropore water-filled porosity from watsub.f
C     VOLW*=equivalent aqueous volume for gas
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C     S*L=solubility of gas in water from hour1.f
C     FLQM=total water flux into soil micropore+macropore from watsub.f
C
      IF(N.EQ.3)THEN
      VOLWCO(N6,N5,N4)=VOLWM(M,N6,N5,N4)*SCO2L(N6,N5,N4)
      VOLWCH(N6,N5,N4)=VOLWM(M,N6,N5,N4)*SCH4L(N6,N5,N4)
      VOLWOX(N6,N5,N4)=VOLWM(M,N6,N5,N4)*SOXYL(N6,N5,N4)
      VOLWNG(N6,N5,N4)=VOLWM(M,N6,N5,N4)*SN2GL(N6,N5,N4)
      VOLWN2(N6,N5,N4)=VOLWM(M,N6,N5,N4)*SN2OL(N6,N5,N4)
      VOLWN3(N6,N5,N4)=VOLWMA(N6,N5,N4)*SNH3L(N6,N5,N4)
      VOLWNB(N6,N5,N4)=VOLWMB(N6,N5,N4)*SNH3L(N6,N5,N4)
      VOLWHG(N6,N5,N4)=VOLWM(M,N6,N5,N4)*SH2GL(N6,N5,N4)
      ENDIF
      FLQM(N,N6,N5,N4)=(FLWM(M,N,N6,N5,N4)+FLWHM(M,N,N6,N5,N4))*XNPT
C
C     SOLUTE TRANSPORT IN MICROPORES
C
C     IF MICROPORE WATER FLUX FROM 'WATSUB' IS FROM CURRENT TO
C     ADJACENT GRID CELL THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MICROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN CURRENT GRID CELL
C
C     FLWM=water flux through soil micropore from watsub.f
C     VOLWM=micropore water-filled porosity from watsub.f
C     RFL*S=solute diffusive flux through micropore
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     *S2,*B2=micropore solute content in non-band,band
C
      IF(FLWM(M,N,N6,N5,N4).GT.0.0)THEN
      IF(VOLWM(M,N3,N2,N1).GT.ZEROS2(N2,N1))THEN
      VFLW=AMAX1(0.0,AMIN1(VFLWX,FLWM(M,N,N6,N5,N4)
     2/VOLWM(M,N3,N2,N1)))
      ELSE
      VFLW=VFLWX
      ENDIF
      DO 9820 K=0,4
      RFLOC(K)=VFLW*AMAX1(0.0,OQC2(K,N3,N2,N1))
      RFLON(K)=VFLW*AMAX1(0.0,OQN2(K,N3,N2,N1))
      RFLOP(K)=VFLW*AMAX1(0.0,OQP2(K,N3,N2,N1))
      RFLOA(K)=VFLW*AMAX1(0.0,OQA2(K,N3,N2,N1))
9820  CONTINUE
      RFLCOS=VFLW*AMAX1(0.0,CO2S2(N3,N2,N1))
      RFLCHS=VFLW*AMAX1(0.0,CH4S2(N3,N2,N1))
      RFLOXS=VFLW*AMAX1(0.0,OXYS2(N3,N2,N1))
      RFLNGS=VFLW*AMAX1(0.0,Z2GS2(N3,N2,N1))
      RFLN2S=VFLW*AMAX1(0.0,Z2OS2(N3,N2,N1))
      RFLHGS=VFLW*AMAX1(0.0,H2GS2(N3,N2,N1))
      RFLNH4=VFLW*AMAX1(0.0,ZNH4S2(N3,N2,N1))
      RFLNH3=VFLW*AMAX1(0.0,ZNH3S2(N3,N2,N1))
      RFLNO3=VFLW*AMAX1(0.0,ZNO3S2(N3,N2,N1))
      RFLNO2=VFLW*AMAX1(0.0,ZNO2S2(N3,N2,N1))
      RFLP14=VFLW*AMAX1(0.0,H1PO42(N3,N2,N1))
      RFLPO4=VFLW*AMAX1(0.0,H2PO42(N3,N2,N1))
      RFLN4B=VFLW*AMAX1(0.0,ZNH4B2(N3,N2,N1))
      RFLN3B=VFLW*AMAX1(0.0,ZNH3B2(N3,N2,N1))
      RFLNOB=VFLW*AMAX1(0.0,ZNO3B2(N3,N2,N1))
      RFLN2B=VFLW*AMAX1(0.0,ZNO2B2(N3,N2,N1))
      RFLP1B=VFLW*AMAX1(0.0,H1POB2(N3,N2,N1))
      RFLPOB=VFLW*AMAX1(0.0,H2POB2(N3,N2,N1))
C
C     IF MICROPORE WATER FLUX FROM 'WATSUB' IS TO CURRENT FROM
C     ADJACENT GRID CELL THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MICROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN ADJACENT GRID CELL
C
      ELSE
      IF(VOLWM(M,N6,N5,N4).GT.ZEROS2(N5,N4))THEN
      VFLW=AMIN1(0.0,AMAX1(-VFLWX,FLWM(M,N,N6,N5,N4)
     2/VOLWM(M,N6,N5,N4)))
      ELSE
      VFLW=-VFLWX
      ENDIF
      DO 9815 K=0,4
      RFLOC(K)=VFLW*AMAX1(0.0,OQC2(K,N6,N5,N4))
      RFLON(K)=VFLW*AMAX1(0.0,OQN2(K,N6,N5,N4))
      RFLOP(K)=VFLW*AMAX1(0.0,OQP2(K,N6,N5,N4))
      RFLOA(K)=VFLW*AMAX1(0.0,OQA2(K,N6,N5,N4))
9815  CONTINUE
      RFLCOS=VFLW*AMAX1(0.0,CO2S2(N6,N5,N4))
      RFLCHS=VFLW*AMAX1(0.0,CH4S2(N6,N5,N4))
      RFLOXS=VFLW*AMAX1(0.0,OXYS2(N6,N5,N4))
      RFLNGS=VFLW*AMAX1(0.0,Z2GS2(N6,N5,N4))
      RFLN2S=VFLW*AMAX1(0.0,Z2OS2(N6,N5,N4))
      RFLHGS=VFLW*AMAX1(0.0,H2GS2(N6,N5,N4))
      RFLNH4=VFLW*AMAX1(0.0,ZNH4S2(N6,N5,N4))
      RFLNH3=VFLW*AMAX1(0.0,ZNH3S2(N6,N5,N4))
      RFLNO3=VFLW*AMAX1(0.0,ZNO3S2(N6,N5,N4))
      RFLNO2=VFLW*AMAX1(0.0,ZNO2S2(N6,N5,N4))
      RFLP14=VFLW*AMAX1(0.0,H1PO42(N6,N5,N4))
      RFLPO4=VFLW*AMAX1(0.0,H2PO42(N6,N5,N4))
      RFLN4B=VFLW*AMAX1(0.0,ZNH4B2(N6,N5,N4))
      RFLN3B=VFLW*AMAX1(0.0,ZNH3B2(N6,N5,N4))
      RFLNOB=VFLW*AMAX1(0.0,ZNO3B2(N6,N5,N4))
      RFLN2B=VFLW*AMAX1(0.0,ZNO2B2(N6,N5,N4))
      RFLP1B=VFLW*AMAX1(0.0,H1POB2(N6,N5,N4))
      RFLPOB=VFLW*AMAX1(0.0,H2POB2(N6,N5,N4))
      ENDIF
C
C     DIFFUSIVE FLUXES OF GASES AND SOLUTES BETWEEN CURRENT AND
C     ADJACENT GRID CELL MICROPORES FROM AQUEOUS DIFFUSIVITIES
C     AND CONCENTRATION DIFFERENCES
C
      IF(THETW1(N3,N2,N1).GT.THETY(N3,N2,N1)
     2.AND.THETW1(N6,N5,N4).GT.THETY(N6,N5,N4)
     3.AND.VOLWM(M,N3,N2,N1).GT.ZEROS2(N2,N1)
     4.AND.VOLWM(M,N6,N5,N4).GT.ZEROS2(N5,N4))THEN
C
C     VOLWM=micropore water-filled porosity from watsub.f
C     THETW=volumetric water content
C
C     MICROPORE CONCENTRATIONS FROM WATER-FILLED POROSITY
C     IN CURRENT AND ADJACENT GRID CELLS
C
C     C*1,C*2=solute concentration in source,destination layer
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     *S2,*B2=soil solute content in non-band,band
C
      DO 9810 K=0,4
      COQC1(K)=AMAX1(0.0,OQC2(K,N3,N2,N1)/VOLWM(M,N3,N2,N1))
      COQN1(K)=AMAX1(0.0,OQN2(K,N3,N2,N1)/VOLWM(M,N3,N2,N1))
      COQP1(K)=AMAX1(0.0,OQP2(K,N3,N2,N1)/VOLWM(M,N3,N2,N1))
      COQA1(K)=AMAX1(0.0,OQA2(K,N3,N2,N1)/VOLWM(M,N3,N2,N1))
      COQC2(K)=AMAX1(0.0,OQC2(K,N6,N5,N4)/VOLWM(M,N6,N5,N4))
      COQN2(K)=AMAX1(0.0,OQN2(K,N6,N5,N4)/VOLWM(M,N6,N5,N4))
      COQP2(K)=AMAX1(0.0,OQP2(K,N6,N5,N4)/VOLWM(M,N6,N5,N4))
      COQA2(K)=AMAX1(0.0,OQA2(K,N6,N5,N4)/VOLWM(M,N6,N5,N4))
9810  CONTINUE
      CCO2S1=AMAX1(0.0,CO2S2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CCH4S1=AMAX1(0.0,CH4S2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      COXYS1=AMAX1(0.0,OXYS2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CZ2GS1=AMAX1(0.0,Z2GS2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CZ2OS1=AMAX1(0.0,Z2OS2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CH2GS1=AMAX1(0.0,H2GS2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      IF(VOLW4A.GT.ZEROS2(N2,N1))THEN
      CNH4S1=AMAX1(0.0,ZNH4S2(N3,N2,N1)/VOLW4A)
      CNH3S1=AMAX1(0.0,ZNH3S2(N3,N2,N1)/VOLW4A)
      ELSE
      CNH4S1=0.0
      CNH3S1=0.0
      ENDIF
      IF(VOLW3A.GT.ZEROS2(N2,N1))THEN
      CNO3S1=AMAX1(0.0,ZNO3S2(N3,N2,N1)/VOLW3A)
      CNO2S1=AMAX1(0.0,ZNO2S2(N3,N2,N1)/VOLW3A)
      ELSE
      CNO3S1=0.0
      CNO2S1=0.0
      ENDIF
      IF(VOLW2A.GT.ZEROS2(N2,N1))THEN
      CP14S1=AMAX1(0.0,H1PO42(N3,N2,N1)/VOLW2A)
      CPO4S1=AMAX1(0.0,H2PO42(N3,N2,N1)/VOLW2A)
      ELSE
      CP14S1=0.0
      CPO4S1=0.0
      ENDIF
      IF(VOLW4B.GT.ZEROS2(N2,N1))THEN
      CNH4B1=AMAX1(0.0,ZNH4B2(N3,N2,N1)/VOLW4B)
      CNH3B1=AMAX1(0.0,ZNH3B2(N3,N2,N1)/VOLW4B)
      ELSE
      CNH4B1=0.0
      CNH3B1=0.0
      ENDIF
      IF(VOLW3B.GT.ZEROS2(N2,N1))THEN
      CNO3B1=AMAX1(0.0,ZNO3B2(N3,N2,N1)/VOLW3B)
      CNO2B1=AMAX1(0.0,ZNO2B2(N3,N2,N1)/VOLW3B)
      ELSE
      CNO3B1=CNO3S1
      CNO2B1=CNO2S1
      ENDIF
      IF(VOLW2B.GT.ZEROS2(N2,N1))THEN
      CP14B1=AMAX1(0.0,H1POB2(N3,N2,N1)/VOLW2B)
      CPO4B1=AMAX1(0.0,H2POB2(N3,N2,N1)/VOLW2B)
      ELSE
      CP14B1=CP14S1
      CPO4B1=CPO4S1
      ENDIF
      CCO2S2=AMAX1(0.0,CO2S2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CCH4S2=AMAX1(0.0,CH4S2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      COXYS2=AMAX1(0.0,OXYS2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CZ2GS2=AMAX1(0.0,Z2GS2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CZ2OS2=AMAX1(0.0,Z2OS2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CH2GS2=AMAX1(0.0,H2GS2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      IF(VOLWMA(N6,N5,N4).GT.ZEROS2(N5,N4))THEN
      CNH3S2=AMAX1(0.0,ZNH3S2(N6,N5,N4)/VOLWMA(N6,N5,N4))
      CNH4S2=AMAX1(0.0,ZNH4S2(N6,N5,N4)/VOLWMA(N6,N5,N4))
      ELSE
      CNH3S2=0.0
      CNH4S2=0.0
      ENDIF
      IF(VOLWOA.GT.ZEROS2(N5,N4))THEN
      CNO3S2=AMAX1(0.0,ZNO3S2(N6,N5,N4)/VOLWOA)
      CNO2S2=AMAX1(0.0,ZNO2S2(N6,N5,N4)/VOLWOA)
      ELSE
      CNO3S2=0.0
      CNO2S2=0.0
      ENDIF
      IF(VOLWPA.GT.ZEROS2(N5,N4))THEN
      CP14S2=AMAX1(0.0,H1PO42(N6,N5,N4)/VOLWPA)
      CPO4S2=AMAX1(0.0,H2PO42(N6,N5,N4)/VOLWPA)
      ELSE
      CP14S2=0.0
      CPO4S2=0.0
      ENDIF
      IF(VOLWMB(N6,N5,N4).GT.ZEROS2(N5,N4))THEN
      CNH3B2=AMAX1(0.0,ZNH3B2(N6,N5,N4)/VOLWMB(N6,N5,N4))
      CNH4B2=AMAX1(0.0,ZNH4B2(N6,N5,N4)/VOLWMB(N6,N5,N4))
      ELSE
      CNH3B2=CNH3S2
      CNH4B2=CNH4S2
      ENDIF
      IF(VOLWOB.GT.ZEROS2(N5,N4))THEN
      CNO3B2=AMAX1(0.0,ZNO3B2(N6,N5,N4)/VOLWOB)
      CNO2B2=AMAX1(0.0,ZNO2B2(N6,N5,N4)/VOLWOB)
      ELSE
      CNO3B2=CNO3S2
      CNO2B2=CNO2S2
      ENDIF
      IF(VOLWPB.GT.ZEROS2(N5,N4))THEN
      CP14B2=AMAX1(0.0,H1POB2(N6,N5,N4)/VOLWPB)
      CPO4B2=AMAX1(0.0,H2POB2(N6,N5,N4)/VOLWPB)
      ELSE
      CP14B2=CP14S2
      CPO4B2=CPO4S2
      ENDIF
C
C     DIFFUSIVITIES IN CURRENT AND ADJACENT GRID CELL MICROPORES
C
C     DLYR=soil layer thickness
C     TORT=micropore tortuosity from hour1.f
C     DISP=dispersivity parameter
C     FLWM=water flux through soil micropore from watsub.f
C     DIF*=aqueous diffusivity-dispersivity through micropore
C     *SGL2=solute diffusivity from hour1.f
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     XDPTH=cross-sectional area/distance between layers
C     C*1,C*2=micropore solute concentration in source,destination layer
C     DFV*=diffusive solute transfer through soil micropore
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C
      DLYR1=AMAX1(ZERO2,DLYR(N,N3,N2,N1))
      DLYR2=AMAX1(ZERO2,DLYR(N,N6,N5,N4))
      TORTL=(TORT(M,N3,N2,N1)*DLYR1+TORT(M,N6,N5,N4)*DLYR2)
     2/(DLYR1+DLYR2)
      DISPN=DISP(N,N6,N5,N4)
     2*AMIN1(VFLWX,ABS(FLWM(M,N,N6,N5,N4)/AREA(N,N6,N5,N4)))
      DIFOC=(OCSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFON=(ONSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOP=(OPSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOA=(OASGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNH=(ZNSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNO=(ZOSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFPO=(POSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFCS=(CLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFCQ=(CQSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOS=(OLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNG=(ZLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFN2=(ZVSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFHG=(HLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
C
C     DIFFUSIVE FLUXES BETWEEN CURRENT AND ADJACENT GRID CELL
C     MICROPORES
C
      DO 9805 K=0,4
      DFVOC(K)=DIFOC*(COQC1(K)-COQC2(K))
      DFVON(K)=DIFON*(COQN1(K)-COQN2(K))
      DFVOP(K)=DIFOP*(COQP1(K)-COQP2(K))
      DFVOA(K)=DIFOA*(COQA1(K)-COQA2(K))
9805  CONTINUE
      DFVCOS=DIFCS*(CCO2S1-CCO2S2)
      DFVCHS=DIFCQ*(CCH4S1-CCH4S2)
      DFVOXS=DIFOS*(COXYS1-COXYS2)
      DFVNGS=DIFNG*(CZ2GS1-CZ2GS2)
      DFVN2S=DIFN2*(CZ2OS1-CZ2OS2)
      DFVHGS=DIFHG*(CH2GS1-CH2GS2)
      DFVNH4=DIFNH*(CNH4S1-CNH4S2)*AMIN1(VLNH4(N3,N2,N1)
     2,VLNH4(N6,N5,N4))
      DFVNH3=DIFNH*(CNH3S1-CNH3S2)*AMIN1(VLNH4(N3,N2,N1)
     2,VLNH4(N6,N5,N4))
      DFVNO3=DIFNO*(CNO3S1-CNO3S2)*AMIN1(VLNO3(N3,N2,N1)
     2,VLNO3(N6,N5,N4))
      DFVNO2=DIFNO*(CNO2S1-CNO2S2)*AMIN1(VLNO3(N3,N2,N1)
     2,VLNO3(N6,N5,N4))
      DFVP14=DIFPO*(CP14S1-CP14S2)*AMIN1(VLPO4(N3,N2,N1)
     2,VLPO4(N6,N5,N4))
      DFVPO4=DIFPO*(CPO4S1-CPO4S2)*AMIN1(VLPO4(N3,N2,N1)
     2,VLPO4(N6,N5,N4))
      DFVN4B=DIFNH*(CNH4B1-CNH4B2)*AMIN1(VLNHB(N3,N2,N1)
     2,VLNHB(N6,N5,N4))
      DFVN3B=DIFNH*(CNH3B1-CNH3B2)*AMIN1(VLNHB(N3,N2,N1)
     2,VLNHB(N6,N5,N4))
      DFVNOB=DIFNO*(CNO3B1-CNO3B2)*AMIN1(VLNOB(N3,N2,N1)
     2,VLNOB(N6,N5,N4))
      DFVN2B=DIFNO*(CNO2B1-CNO2B2)*AMIN1(VLNOB(N3,N2,N1)
     2,VLNOB(N6,N5,N4))
      DFVP1B=DIFPO*(CP14B1-CP14B2)*AMIN1(VLPOB(N3,N2,N1)
     2,VLPOB(N6,N5,N4))
      DFVPOB=DIFPO*(CPO4B1-CPO4B2)*AMIN1(VLPOB(N3,N2,N1)
     2,VLPOB(N6,N5,N4))
      ELSE
      DO 9905 K=0,4
      DFVOC(K)=0.0
      DFVON(K)=0.0
      DFVOP(K)=0.0
      DFVOA(K)=0.0
9905  CONTINUE
      DFVCOS=0.0
      DFVCHS=0.0
      DFVOXS=0.0
      DFVNGS=0.0
      DFVN2S=0.0
      DFVHGS=0.0
      DFVNH4=0.0
      DFVNH3=0.0
      DFVNO3=0.0
      DFVNO2=0.0
      DFVP14=0.0
      DFVPO4=0.0
      DFVN4B=0.0
      DFVN3B=0.0
      DFVNOB=0.0
      DFVN2B=0.0
      DFVP1B=0.0
      DFVPOB=0.0
      ENDIF
C
C     SOLUTE TRANSPORT IN MACROPORES
C
C     FLWHM=water flux through soil macropore from watsub.f
C
      IF(FLWHM(M,N,N6,N5,N4).GT.0.0)THEN
C
C     IF MACROPORE WATER FLUX FROM 'WATSUB' IS FROM CURRENT TO
C     ADJACENT GRID CELL THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MACROPORE SOLUTE CONCENTRATIONS IN CURRENT
C     GRID CELL
C
C     VOLWHM=macropore water-filled porosity from watsub.f
C     VOLWAH=macropore porosity
C     RFH*=solute diffusive flux through macropore
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     *SH2,*BH2=macropore solute content in non-band,band
C     R*FXS=convective + diffusive solute flux between macropores and micropores
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C
      IF(VOLWHM(M,N3,N2,N1).GT.ZEROS2(N2,N1))THEN
      VFLW=AMAX1(0.0,AMIN1(VFLWX,FLWHM(M,N,N6,N5,N4)
     2/VOLWHM(M,N3,N2,N1)))
      ELSE
      VFLW=VFLWX
      ENDIF
C
C     ACCOUNT FOR MACROPORE-MICROPORE EXCHANGE
C
      IF(N.EQ.3.AND.VOLAH(N6,N5,N4).GT.VOLWHM(M,N6,N5,N4))THEN
      DO 9800 K=0,4
      RFHOC(K)=VFLW*AMAX1(0.0,(OQCH2(K,N3,N2,N1)
     2-AMIN1(0.0,ROCFXS(K,NU(N2,N1),N2,N1))))
      RFHON(K)=VFLW*AMAX1(0.0,(OQNH2(K,N3,N2,N1)
     2-AMIN1(0.0,RONFXS(K,NU(N2,N1),N2,N1))))
      RFHOP(K)=VFLW*AMAX1(0.0,(OQPH2(K,N3,N2,N1)
     2-AMIN1(0.0,ROPFXS(K,NU(N2,N1),N2,N1))))
      RFHOA(K)=VFLW*AMAX1(0.0,(OQAH2(K,N3,N2,N1)
     2-AMIN1(0.0,ROAFXS(K,NU(N2,N1),N2,N1))))
9800  CONTINUE
      RFHCOS=VFLW*AMAX1(0.0,(CO2SH2(N3,N2,N1)
     2-AMIN1(0.0,RCOFXS(NU(N2,N1),N2,N1))))
      RFHCHS=VFLW*AMAX1(0.0,(CH4SH2(N3,N2,N1)
     2-AMIN1(0.0,RCHFXS(NU(N2,N1),N2,N1))))
      RFHOXS=VFLW*AMAX1(0.0,(OXYSH2(N3,N2,N1)
     2-AMIN1(0.0,ROXFXS(NU(N2,N1),N2,N1))))
      RFHNGS=VFLW*AMAX1(0.0,(Z2GSH2(N3,N2,N1)
     2-AMIN1(0.0,RNGFXS(NU(N2,N1),N2,N1))))
      RFHN2S=VFLW*AMAX1(0.0,(Z2OSH2(N3,N2,N1)
     2-AMIN1(0.0,RN2FXS(NU(N2,N1),N2,N1))))
      RFHHGS=VFLW*AMAX1(0.0,(H2GSH2(N3,N2,N1)
     2-AMIN1(0.0,RHGFXS(NU(N2,N1),N2,N1))))
      RFHNH4=VFLW*AMAX1(0.0,(ZNH4H2(N3,N2,N1)
     2-AMIN1(0.0,RN4FXW(NU(N2,N1),N2,N1)*VLNH4(N3,N2,N1))))
     3*VLNH4(N6,N5,N4)
      RFHNH3=VFLW*AMAX1(0.0,(ZNH3H2(N3,N2,N1)
     2-AMIN1(0.0,RN3FXW(NU(N2,N1),N2,N1)*VLNH4(N3,N2,N1))))
     3*VLNH4(N6,N5,N4)
      RFHNO3=VFLW*AMAX1(0.0,(ZNO3H2(N3,N2,N1)
     2-AMIN1(0.0,RNOFXW(NU(N2,N1),N2,N1)*VLNO3(N3,N2,N1))))
     3*VLNO3(N6,N5,N4)
      RFHNO2=VFLW*AMAX1(0.0,(ZNO2H2(N3,N2,N1)
     2-AMIN1(0.0,RNXFXS(NU(N2,N1),N2,N1)*VLNO3(N3,N2,N1))))
     3*VLNO3(N6,N5,N4)
      RFHP14=VFLW*AMAX1(0.0,(H1P4H2(N3,N2,N1)
     2-AMIN1(0.0,RH1PXS(NU(N2,N1),N2,N1)*VLPO4(N3,N2,N1))))
     3*VLPO4(N6,N5,N4)
      RFHPO4=VFLW*AMAX1(0.0,(H2P4H2(N3,N2,N1)
     2-AMIN1(0.0,RH2PXS(NU(N2,N1),N2,N1)*VLPO4(N3,N2,N1))))
     3*VLPO4(N6,N5,N4)
      RFHN4B=VFLW*AMAX1(0.0,(ZN4BH2(N3,N2,N1)
     2-AMIN1(0.0,RN4FXB(NU(N2,N1),N2,N1)*VLNHB(N3,N2,N1))))
     3*VLNHB(N6,N5,N4)
      RFHN3B=VFLW*AMAX1(0.0,(ZN3BH2(N3,N2,N1)
     2-AMIN1(0.0,RN3FXB(NU(N2,N1),N2,N1)*VLNHB(N3,N2,N1))))
     3*VLNHB(N6,N5,N4)
      RFHNOB=VFLW*AMAX1(0.0,(ZNOBH2(N3,N2,N1)
     2-AMIN1(0.0,RNOFXB(NU(N2,N1),N2,N1)*VLNOB(N3,N2,N1))))
     3*VLNOB(N6,N5,N4)
      RFHN2B=VFLW*AMAX1(0.0,(ZN2BH2(N3,N2,N1)
     2-AMIN1(0.0,RNXFXB(NU(N2,N1),N2,N1)*VLNOB(N3,N2,N1))))
     3*VLNOB(N6,N5,N4)
      RFHP1B=VFLW*AMAX1(0.0,(H1PBH2(N3,N2,N1)
     2-AMIN1(0.0,RH1BXB(NU(N2,N1),N2,N1)*VLPOB(N3,N2,N1))))
     3*VLPOB(N6,N5,N4)
      RFHPOB=VFLW*AMAX1(0.0,(H2PBH2(N3,N2,N1)
     2-AMIN1(0.0,RH2BXB(NU(N2,N1),N2,N1)*VLPOB(N3,N2,N1))))
     3*VLPOB(N6,N5,N4)
C
C     OTHERWISE
C
      ELSE
      DO 9850 K=0,4
      RFHOC(K)=VFLW*AMAX1(0.0,OQCH2(K,N3,N2,N1))
      RFHON(K)=VFLW*AMAX1(0.0,OQNH2(K,N3,N2,N1))
      RFHOP(K)=VFLW*AMAX1(0.0,OQPH2(K,N3,N2,N1))
      RFHOA(K)=VFLW*AMAX1(0.0,OQAH2(K,N3,N2,N1))
9850  CONTINUE
      RFHCOS=VFLW*AMAX1(0.0,CO2SH2(N3,N2,N1))
      RFHCHS=VFLW*AMAX1(0.0,CH4SH2(N3,N2,N1))
      RFHOXS=VFLW*AMAX1(0.0,OXYSH2(N3,N2,N1))
      RFHNGS=VFLW*AMAX1(0.0,Z2GSH2(N3,N2,N1))
      RFHN2S=VFLW*AMAX1(0.0,Z2OSH2(N3,N2,N1))
      RFHHGS=VFLW*AMAX1(0.0,H2GSH2(N3,N2,N1))
      RFHNH4=VFLW*AMAX1(0.0,ZNH4H2(N3,N2,N1))*VLNH4(N6,N5,N4)
      RFHNH3=VFLW*AMAX1(0.0,ZNH3H2(N3,N2,N1))*VLNH4(N6,N5,N4)
      RFHNO3=VFLW*AMAX1(0.0,ZNO3H2(N3,N2,N1))*VLNO3(N6,N5,N4)
      RFHNO2=VFLW*AMAX1(0.0,ZNO2H2(N3,N2,N1))*VLNO3(N6,N5,N4)
      RFHP14=VFLW*AMAX1(0.0,H1P4H2(N3,N2,N1))*VLPO4(N6,N5,N4)
      RFHPO4=VFLW*AMAX1(0.0,H2P4H2(N3,N2,N1))*VLPO4(N6,N5,N4)
      RFHN4B=VFLW*AMAX1(0.0,ZN4BH2(N3,N2,N1))*VLNHB(N6,N5,N4)
      RFHN3B=VFLW*AMAX1(0.0,ZN3BH2(N3,N2,N1))*VLNHB(N6,N5,N4)
      RFHNOB=VFLW*AMAX1(0.0,ZNOBH2(N3,N2,N1))*VLNOB(N6,N5,N4)
      RFHN2B=VFLW*AMAX1(0.0,ZN2BH2(N3,N2,N1))*VLNOB(N6,N5,N4)
      RFHP1B=VFLW*AMAX1(0.0,H1PBH2(N3,N2,N1))*VLPOB(N6,N5,N4)
      RFHPOB=VFLW*AMAX1(0.0,H2PBH2(N3,N2,N1))*VLPOB(N6,N5,N4)
      ENDIF
C
C     IF MACROPORE WATER FLUX FROM 'WATSUB' IS FROM ADJACENT TO
C     CURRENT GRID CELL THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MACROPORE SOLUTE CONCENTRATIONS IN ADJACENT
C     GRID CELL
C
      ELSEIF(FLWHM(M,N,N6,N5,N4).LT.0.0)THEN
      IF(VOLWHM(M,N6,N5,N4).GT.ZEROS2(N5,N4))THEN
      VFLW=AMIN1(0.0,AMAX1(-VFLWX,FLWHM(M,N,N6,N5,N4)
     2/VOLWHM(M,N6,N5,N4)))
      ELSE
      VFLW=-VFLWX
      ENDIF
      DO 9665 K=0,4
      RFHOC(K)=VFLW*AMAX1(0.0,OQCH2(K,N6,N5,N4))
      RFHON(K)=VFLW*AMAX1(0.0,OQNH2(K,N6,N5,N4))
      RFHOP(K)=VFLW*AMAX1(0.0,OQPH2(K,N6,N5,N4))
      RFHOA(K)=VFLW*AMAX1(0.0,OQAH2(K,N6,N5,N4))
9665  CONTINUE
      RFHCOS=VFLW*AMAX1(0.0,CO2SH2(N6,N5,N4))
      RFHCHS=VFLW*AMAX1(0.0,CH4SH2(N6,N5,N4))
      RFHOXS=VFLW*AMAX1(0.0,OXYSH2(N6,N5,N4))
      RFHNGS=VFLW*AMAX1(0.0,Z2GSH2(N6,N5,N4))
      RFHN2S=VFLW*AMAX1(0.0,Z2OSH2(N6,N5,N4))
      RFHHGS=VFLW*AMAX1(0.0,H2GSH2(N6,N5,N4))
      RFHNH4=VFLW*AMAX1(0.0,ZNH4H2(N6,N5,N4))*VLNH4(N6,N5,N4)
      RFHNH3=VFLW*AMAX1(0.0,ZNH3H2(N6,N5,N4))*VLNH4(N6,N5,N4)
      RFHNO3=VFLW*AMAX1(0.0,ZNO3H2(N6,N5,N4))*VLNO3(N6,N5,N4)
      RFHNO2=VFLW*AMAX1(0.0,ZNO2H2(N6,N5,N4))*VLNO3(N6,N5,N4)
      RFHP14=VFLW*AMAX1(0.0,H1P4H2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFHPO4=VFLW*AMAX1(0.0,H2P4H2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFHN4B=VFLW*AMAX1(0.0,ZN4BH2(N6,N5,N4))*VLNHB(N6,N5,N4)
      RFHN3B=VFLW*AMAX1(0.0,ZN3BH2(N6,N5,N4))*VLNHB(N6,N5,N4)
      RFHNOB=VFLW*AMAX1(0.0,ZNOBH2(N6,N5,N4))*VLNOB(N6,N5,N4)
      RFHN2B=VFLW*AMAX1(0.0,ZN2BH2(N6,N5,N4))*VLNOB(N6,N5,N4)
      RFHP1B=VFLW*AMAX1(0.0,H1PBH2(N6,N5,N4))*VLPOB(N6,N5,N4)
      RFHPOB=VFLW*AMAX1(0.0,H2PBH2(N6,N5,N4))*VLPOB(N6,N5,N4)
      ELSE
C
C     NO MACROPORE FLUX
C
      DO 9795 K=0,4
      RFHOC(K)=0.0
      RFHON(K)=0.0
      RFHOP(K)=0.0
      RFHOA(K)=0.0
9795  CONTINUE
      RFHCOS=0.0
      RFHCHS=0.0
      RFHOXS=0.0
      RFHNGS=0.0
      RFHN2S=0.0
      RFHHGS=0.0
      RFHNH4=0.0
      RFHNH3=0.0
      RFHNO3=0.0
      RFHNO2=0.0
      RFHP14=0.0
      RFHPO4=0.0
      RFHN4B=0.0
      RFHN3B=0.0
      RFHNOB=0.0
      RFHN2B=0.0
      RFHP1B=0.0
      RFHPOB=0.0
      ENDIF
C
C     DIFFUSIVE FLUXES OF GASES AND SOLUTES BETWEEN CURRENT AND
C     ADJACENT GRID CELL MACROPORES FROM AQUEOUS DIFFUSIVITIES
C     AND CONCENTRATION DIFFERENCES
C
C     VOLWHM=macropore water-filled porosity from watsub.f
C     THETY=hygroscopic water content
C     VOLAH=total macropore volume
C
      IF(VOLWHM(M,N3,N2,N1).GT.THETY(N3,N2,N1)*VOLAH(N3,N2,N1)
     2.AND.VOLWHM(M,N6,N5,N4).GT.THETY(N6,N5,N4)*VOLAH(N6,N5,N4))THEN
C
C     MACROPORE CONCENTRATIONS IN CURRENT AND ADJACENT GRID CELLS
C
C     C*H1,C*H2=macropore solute concentration in source,destination layer
C     *H2=macropore solute content
C     VOLWHM=macropore water content
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C
      DO 9790 K=0,4
      COQCH1(K)=AMAX1(0.0,OQCH2(K,N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      COQNH1(K)=AMAX1(0.0,OQNH2(K,N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      COQPH1(K)=AMAX1(0.0,OQPH2(K,N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      COQAH1(K)=AMAX1(0.0,OQAH2(K,N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      COQCH2(K)=AMAX1(0.0,OQCH2(K,N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      COQNH2(K)=AMAX1(0.0,OQNH2(K,N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      COQPH2(K)=AMAX1(0.0,OQPH2(K,N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      COQAH2(K)=AMAX1(0.0,OQAH2(K,N6,N5,N4)/VOLWHM(M,N6,N5,N4))
9790  CONTINUE
      CCO2SH1=AMAX1(0.0,CO2SH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CCH4SH1=AMAX1(0.0,CH4SH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      COXYSH1=AMAX1(0.0,OXYSH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CZ2GSH1=AMAX1(0.0,Z2GSH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CZ2OSH1=AMAX1(0.0,Z2OSH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CH2GSH1=AMAX1(0.0,H2GSH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      IF(VOLH4A.GT.ZEROS2(N2,N1))THEN
      CNH4SH1=AMAX1(0.0,ZNH4H2(N3,N2,N1)/VOLH4A)
      CNH3SH1=AMAX1(0.0,ZNH3H2(N3,N2,N1)/VOLH4A)
      ELSE
      CNH4SH1=0.0
      CNH3SH1=0.0
      ENDIF
      IF(VOLH3A.GT.ZEROS2(N2,N1))THEN
      CNO3SH1=AMAX1(0.0,ZNO3H2(N3,N2,N1)/VOLH3A)
      CNO2SH1=AMAX1(0.0,ZNO2H2(N3,N2,N1)/VOLH3A)
      ELSE
      CNO3SH1=0.0
      CNO2SH1=0.0
      ENDIF
      IF(VOLH2A.GT.ZEROS2(N2,N1))THEN
      CP14SH1=AMAX1(0.0,H1P4H2(N3,N2,N1)/VOLH2A)
      CPO4SH1=AMAX1(0.0,H2P4H2(N3,N2,N1)/VOLH2A)
      ELSE
      CP14SH1=0.0
      CPO4SH1=0.0
      ENDIF
      IF(VOLH4B.GT.ZEROS2(N2,N1))THEN
      CNH4BH1=AMAX1(0.0,ZN4BH2(N3,N2,N1)/VOLH4B)
      CNH3BH1=AMAX1(0.0,ZN3BH2(N3,N2,N1)/VOLH4B)
      ELSE
      CNH4BH1=CNH4SH1
      CNH3BH1=CNH3SH1
      ENDIF
      IF(VOLH3B.GT.ZEROS2(N2,N1))THEN
      CNO3BH1=AMAX1(0.0,ZNOBH2(N3,N2,N1)/VOLH3B)
      CNO2BH1=AMAX1(0.0,ZN2BH2(N3,N2,N1)/VOLH3B)
      ELSE
      CNO3BH1=CNO3SH1
      CNO2BH1=CNO2SH1
      ENDIF
      IF(VOLH2B.GT.ZEROS2(N2,N1))THEN
      CP14BH1=AMAX1(0.0,H1PBH2(N3,N2,N1)/VOLH2B)
      CPO4BH1=AMAX1(0.0,H2PBH2(N3,N2,N1)/VOLH2B)
      ELSE
      CP14BH1=CP14SH1
      CPO4BH1=CPO4SH1
      ENDIF
      CCO2SH2=AMAX1(0.0,CO2SH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CCH4SH2=AMAX1(0.0,CH4SH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      COXYSH2=AMAX1(0.0,OXYSH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CZ2GSH2=AMAX1(0.0,Z2GSH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CZ2OSH2=AMAX1(0.0,Z2OSH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CH2GSH2=AMAX1(0.0,H2GSH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      VOLHMA=VOLWHM(M,N6,N5,N4)*VLNH4(N6,N5,N4)
      IF(VOLHMA.GT.ZEROS2(N5,N4))THEN
      CNH4SH2=AMAX1(0.0,ZNH4H2(N6,N5,N4)/VOLHMA)
      CNH3SH2=AMAX1(0.0,ZNH3H2(N6,N5,N4)/VOLHMA)
      ELSE
      CNH4SH2=0.0
      CNH3SH2=0.0
      ENDIF
      VOLHOA=VOLWHM(M,N6,N5,N4)*VLNO3(N6,N5,N4)
      IF(VOLHOA.GT.ZEROS2(N5,N4))THEN
      CNO3SH2=AMAX1(0.0,ZNO3H2(N6,N5,N4)/VOLHOA)
      CNO2SH2=AMAX1(0.0,ZNO2H2(N6,N5,N4)/VOLHOA)
      ELSE
      CNO3SH2=0.0
      CNO2SH2=0.0
      ENDIF
      VOLHPA=VOLWHM(M,N6,N5,N4)*VLPO4(N6,N5,N4)
      IF(VOLHPA.GT.ZEROS2(N5,N4))THEN
      CP14SH2=AMAX1(0.0,H1P4H2(N6,N5,N4)/VOLHPA)
      CPO4SH2=AMAX1(0.0,H2P4H2(N6,N5,N4)/VOLHPA)
      ELSE
      CP14SH2=0.0
      CPO4SH2=0.0
      ENDIF
      VOLHMB=VOLWHM(M,N6,N5,N4)*VLNHB(N6,N5,N4)
      IF(VOLHMB.GT.ZEROS2(N5,N4))THEN
      CNH4BH2=AMAX1(0.0,ZN4BH2(N6,N5,N4)/VOLHMB)
      CNH3BH2=AMAX1(0.0,ZN3BH2(N6,N5,N4)/VOLHMB)
      ELSE
      CNH4BH2=CNH4SH2
      CNH3BH2=CNH3SH2
      ENDIF
      VOLHOB=VOLWHM(M,N6,N5,N4)*VLNOB(N6,N5,N4)
      IF(VOLHOB.GT.ZEROS2(N5,N4))THEN
      CNO3BH2=AMAX1(0.0,ZNOBH2(N6,N5,N4)/VOLHOB)
      CNO2BH2=AMAX1(0.0,ZN2BH2(N6,N5,N4)/VOLHOB)
      ELSE
      CNO3BH2=CNO3SH2
      CNO2BH2=CNO2SH2
      ENDIF
      VOLHPB=VOLWHM(M,N6,N5,N4)*VLPOB(N6,N5,N4)
      IF(VOLHPB.GT.ZEROS2(N5,N4))THEN
      CP14BH2=AMAX1(0.0,H1PBH2(N6,N5,N4)/VOLHPB)
      CPO4BH2=AMAX1(0.0,H2PBH2(N6,N5,N4)/VOLHPB)
      ELSE
      CP14BH2=CP14SH2
      CPO4BH2=CPO4SH2
      ENDIF
C
C     DIFFUSIVITIES IN CURRENT AND ADJACENT GRID CELL MACROPORES
C
C     DLYR=soil layer thickness
C     TORTH=macropore tortuosity from hour1.f
C     DISP=dispersivity parameter
C     FLWHM=water flux through soil macropore from watsub.f
C     DIF*=aqueous diffusivity-dispersivity through macropore
C     *SGL2=solute diffusivity from hour1.f
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     XDPTH=cross-sectional area/distance between layers
C     C*H1,C*H2=macropore solute concentration in source,destination layer
C     DFH*=diffusive solute transfer through soil macropore
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C
      DLYR1=AMAX1(ZERO2,DLYR(N,N3,N2,N1))
      DLYR2=AMAX1(ZERO2,DLYR(N,N6,N5,N4))
      TORTL=(TORTH(M,N3,N2,N1)*DLYR1+TORTH(M,N6,N5,N4)*DLYR2)
     3/(DLYR1+DLYR2)
      DISPN=DISP(N,N6,N5,N4)
     2*AMIN1(VFLWX,ABS(FLWHM(M,N,N6,N5,N4)/AREA(N,N6,N5,N4)))
      DIFOC=(OCSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFON=(ONSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOP=(OPSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOA=(OASGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNH=(ZNSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNO=(ZOSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFPO=(POSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFCS=(CLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFCQ=(CQSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOS=(OLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNG=(ZLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFN2=(ZVSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFHG=(HLSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
C
C     DIFFUSIVE FLUXES BETWEEN CURRENT AND ADJACENT GRID CELL
C     MACROPORES
C
      DO 9785 K=0,4
      DFHOC(K)=DIFOC*(COQCH1(K)-COQCH2(K))
      DFHON(K)=DIFON*(COQNH1(K)-COQNH2(K))
      DFHOP(K)=DIFOP*(COQPH1(K)-COQPH2(K))
      DFHOA(K)=DIFOA*(COQAH1(K)-COQAH2(K))
C     WRITE(*,2121)'DFHOC',I,J,M,N4,N5,N6,K,DFHOC(K),OQCH2(K,N3,N2,N1)
C    2,OQCH2(K,N6,N5,N4),DIFOC,COQCH1(K),COQCH2(K)
2121  FORMAT(A8,7I4,20E12.4)
9785  CONTINUE
      DFHCOS=DIFCS*(CCO2SH1-CCO2SH2)
      DFHCHS=DIFCQ*(CCH4SH1-CCH4SH2)
      DFHOXS=DIFOS*(COXYSH1-COXYSH2)
      DFHNGS=DIFNG*(CZ2GSH1-CZ2GSH2)
      DFHN2S=DIFN2*(CZ2OSH1-CZ2OSH2)
      DFHHGS=DIFNH*(CH2GSH1-CH2GSH2)
      DFHNH4=DIFNH*(CNH4SH1-CNH4SH2)*AMIN1(VLNH4(N3,N2,N1)
     2,VLNH4(N6,N5,N4))
      DFHNH3=DIFNH*(CNH3SH1-CNH3SH2)*AMIN1(VLNH4(N3,N2,N1)
     2,VLNH4(N6,N5,N4))
      DFHNO3=DIFNO*(CNO3SH1-CNO3SH2)*AMIN1(VLNO3(N3,N2,N1)
     2,VLNO3(N6,N5,N4))
      DFHNO2=DIFNO*(CNO2SH1-CNO2SH2)*AMIN1(VLNO3(N3,N2,N1)
     2,VLNO3(N6,N5,N4))
      DFHP14=DIFPO*(CP14SH1-CP14SH2)*AMIN1(VLPO4(N3,N2,N1)
     2,VLPO4(N6,N5,N4))
      DFHPO4=DIFPO*(CPO4SH1-CPO4SH2)*AMIN1(VLPO4(N3,N2,N1)
     2,VLPO4(N6,N5,N4))
      DFHN4B=DIFNH*(CNH4BH1-CNH4BH2)*AMIN1(VLNHB(N3,N2,N1)
     2,VLNHB(N6,N5,N4))
      DFHN3B=DIFNH*(CNH3BH1-CNH3BH2)*AMIN1(VLNHB(N3,N2,N1)
     2,VLNHB(N6,N5,N4))
      DFHNOB=DIFNO*(CNO3BH1-CNO3BH2)*AMIN1(VLNOB(N3,N2,N1)
     2,VLNOB(N6,N5,N4))
      DFHN2B=DIFNO*(CNO2BH1-CNO2BH2)*AMIN1(VLNOB(N3,N2,N1)
     2,VLNOB(N6,N5,N4))
      DFHP1B=DIFPO*(CP14BH1-CP14BH2)*AMIN1(VLPOB(N3,N2,N1)
     2,VLPOB(N6,N5,N4))
      DFHPOB=DIFPO*(CPO4BH1-CPO4BH2)*AMIN1(VLPOB(N3,N2,N1)
     2,VLPOB(N6,N5,N4))
      ELSE
      DO 9780 K=0,4
      DFHOC(K)=0.0
      DFHON(K)=0.0
      DFHOP(K)=0.0
      DFHOA(K)=0.0
9780  CONTINUE
      DFHCOS=0.0
      DFHCHS=0.0
      DFHOXS=0.0
      DFHNGS=0.0
      DFHN2S=0.0
      DFHHGS=0.0
      DFHNH4=0.0
      DFHNH3=0.0
      DFHNO3=0.0
      DFHNO2=0.0
      DFHP14=0.0
      DFHPO4=0.0
      DFHN4B=0.0
      DFHN3B=0.0
      DFHNOB=0.0
      DFHN2B=0.0
      DFHP1B=0.0
      DFHPOB=0.0
      ENDIF
C
C     TOTAL MICROPORE AND MACROPORE SOLUTE TRANSPORT FLUXES BETWEEN
C     ADJACENT GRID CELLS = CONVECTIVE + DIFFUSIVE FLUXES
C
C     R*FLS=convective + diffusive solute flux through micropores
C     R*FLW,R*FLB=convective + diffusive solute flux through micropores in non-band,band
C     R*FHS=convective + diffusive solute flux through macropores
C     R*FHW,R*FHB=convective + diffusive solute flux through macropores in non-band,band
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     RFL*=convective flux through micropores
C     DFV*=diffusive solute flux through micropores
C     RFH*=convective flux through macropores
C     DFH*=diffusive solute flux through macropores
C
      DO 9765 K=0,4
      ROCFLS(K,N,N6,N5,N4)=RFLOC(K)+DFVOC(K)
      RONFLS(K,N,N6,N5,N4)=RFLON(K)+DFVON(K)
      ROPFLS(K,N,N6,N5,N4)=RFLOP(K)+DFVOP(K)
      ROAFLS(K,N,N6,N5,N4)=RFLOA(K)+DFVOA(K)
      ROCFHS(K,N,N6,N5,N4)=RFHOC(K)+DFHOC(K)
      RONFHS(K,N,N6,N5,N4)=RFHON(K)+DFHON(K)
      ROPFHS(K,N,N6,N5,N4)=RFHOP(K)+DFHOP(K)
      ROAFHS(K,N,N6,N5,N4)=RFHOA(K)+DFHOA(K)
C     IF(N3.LE.3)THEN
C     WRITE(*,447)'ROCFLS',I,J,N4,N5,N6,M,MM,N,K
C    2,ROCFLS(K,N,N6,N5,N4),RFLOC(K),DFVOC(K),DIFOC
C    3,COQC1(K),COQC2(K),OQC2(K,N3,N2,N1),VOLWM(M,N3,N2,N1)
C    4,OQC2(K,N6,N5,N4),VOLWM(M,N6,N5,N4)
C    2,ROAFLS(K,N,N6,N5,N4),RFLOA(K),DFVOA(K),DIFOA
C    3,COQA1(K),COQA2(K),OQA2(K,N3,N2,N1),VOLWM(M,N3,N2,N1)
C    4,OQA2(K,N6,N5,N4),VOLWM(M,N6,N5,N4)
447   FORMAT(A8,9I4,20E12.4)
C     ENDIF
9765  CONTINUE
      RCOFLS(N,N6,N5,N4)=RFLCOS+DFVCOS
      RCHFLS(N,N6,N5,N4)=RFLCHS+DFVCHS
      ROXFLS(N,N6,N5,N4)=RFLOXS+DFVOXS
      RNGFLS(N,N6,N5,N4)=RFLNGS+DFVNGS
      RN2FLS(N,N6,N5,N4)=RFLN2S+DFVN2S
      RHGFLS(N,N6,N5,N4)=RFLHGS+DFVHGS
      RN4FLW(N,N6,N5,N4)=RFLNH4+DFVNH4
      RN3FLW(N,N6,N5,N4)=RFLNH3+DFVNH3
      RNOFLW(N,N6,N5,N4)=RFLNO3+DFVNO3
      RNXFLS(N,N6,N5,N4)=RFLNO2+DFVNO2
      RH1PFS(N,N6,N5,N4)=RFLP14+DFVP14
      RH2PFS(N,N6,N5,N4)=RFLPO4+DFVPO4
      RN4FLB(N,N6,N5,N4)=RFLN4B+DFVN4B
      RN3FLB(N,N6,N5,N4)=RFLN3B+DFVN3B
      RNOFLB(N,N6,N5,N4)=RFLNOB+DFVNOB
      RNXFLB(N,N6,N5,N4)=RFLN2B+DFVN2B
      RH1BFB(N,N6,N5,N4)=RFLP1B+DFVP1B
      RH2BFB(N,N6,N5,N4)=RFLPOB+DFVPOB
      RCOFHS(N,N6,N5,N4)=RFHCOS+DFHCOS
      RCHFHS(N,N6,N5,N4)=RFHCHS+DFHCHS
      ROXFHS(N,N6,N5,N4)=RFHOXS+DFHOXS
      RNGFHS(N,N6,N5,N4)=RFHNGS+DFHNGS
      RN2FHS(N,N6,N5,N4)=RFHN2S+DFHN2S
      RHGFHS(N,N6,N5,N4)=RFHHGS+DFHHGS
      RN4FHW(N,N6,N5,N4)=RFHNH4+DFHNH4
      RN3FHW(N,N6,N5,N4)=RFHNH3+DFHNH3
      RNOFHW(N,N6,N5,N4)=RFHNO3+DFHNO3
      RNXFHS(N,N6,N5,N4)=RFHNO2+DFHNO2
      RH1PHS(N,N6,N5,N4)=RFHP14+DFHP14
      RH2PHS(N,N6,N5,N4)=RFHPO4+DFHPO4
      RN4FHB(N,N6,N5,N4)=RFHN4B+DFHN4B
      RN3FHB(N,N6,N5,N4)=RFHN3B+DFHN3B
      RNOFHB(N,N6,N5,N4)=RFHNOB+DFHNOB
      RNXFHB(N,N6,N5,N4)=RFHN2B+DFHN2B
      RH1BHB(N,N6,N5,N4)=RFHP1B+DFHP1B
      RH2BHB(N,N6,N5,N4)=RFHPOB+DFHPOB
C     IF(I.EQ.361.AND.NY.EQ.2)THEN
C     WRITE(*,443)'RN4FHB',I,J,M,MM,N1,N2,N3,N4,N5,N6,N
C    2,RN4FHB(N,N6,N5,N4),RFHN4B,DFHN4B,VFLW,ZN4BH2(N3,N2,N1)
C    2,RN4FXB(NU(N2,N1),N2,N1),VLNHB(N3,N2,N1),VLNHB(N6,N5,N4)
C    3,FLWHM(M,N,N6,N5,N4),VFLWX,VOLWHM(M,N3,N2,N1)
C    4,VOLWHM(M,N6,N5,N4)
C     WRITE(*,443)'RCOFLS',I,J,M,MM,N1,N2,N3,N4,N5,N6,N
C    2,RCOFLS(N,N6,N5,N4),RFLCOS,DFVCOS,DIFCS,CCO2S1,CCO2S2
C    3,CLSGL2(N6,N5,N4),TORTL,DISPN,XDPTH(N,N6,N5,N4)
C    4,CO2S2(N3,N2,N1),VOLWM(M,N3,N2,N1),VOLY(N3,N2,N1)
C    4,CO2S2(N6,N5,N4),VOLWM(M,N6,N5,N4),VOLY(N6,N5,N4)
C     WRITE(*,443)'ROXFLS',I,J,M,MM,N1,N2,N3,N4,N5,N6,N
C    2,ROXFLS(N,N6,N5,N4),RFLOXS,DFVOXS,DIFOS,COXYS1,COXYS2
C    3,OLSGL2(N6,N5,N4),TORTL,DISPN,XDPTH(N,N6,N5,N4)
C     WRITE(*,443)'RN3FLW',I,J,M,MM,N1,N2,N3,N4,N5,N6,N
C    2,RN3FLW(N,N6,N5,N4),RFLNH3,DFVNH3,DIFNH,CNH3S1,CNH3S2
C    3,ZHSGL2(N6,N5,N4),TORTL,DIFNH0,DIFNH1,DISPN,XDPTH(N,N6,N5,N4)
C    4,VFLW,ZNH3S2(N3,N2,N1),ZNH3S2(N6,N5,N4)
C     WRITE(*,443)'RH2PFS',I,J,M,MM,N1,N2,N3,N4,N5,N6,N
C    2,RH2PFS(N,N6,N5,N4),RFLPO4,DFVPO4,DIFPO,CPO4S1,CPO4S2
C    3,VLPO4(N3,N2,N1),VLPO4(N6,N5,N4),VOLW2A,VOLWPA
C    4,H2PO42(N3,N2,N1),H2PO42(N6,N5,N4)
443   FORMAT(A8,11I4,20E12.4)
C     ENDIF
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*FLS=hourly convective + diffusive solute flux through micropores
C     X*FLW,X*FLB= hourly convective + diffusive solute flux through micropores in non-band,band
C     X*FHS=hourly convective + diffusive solute flux through macropores
C     X*FHW,X*FHB= hourly convective + diffusive solute flux through macropores in non-band,band
C     R*FLS=convective + diffusive solute flux through micropores
C     R*FLW,X*FLB=convective + diffusive solute flux through micropores in non-band,band
C     R*FHS=convective + diffusive solute flux through macropores
C     R*FHW,X*FHB=convective + diffusive solute flux through macropores in non-band,band
C
      DO 9755 K=0,4
      XOCFLS(K,N,N6,N5,N4)=XOCFLS(K,N,N6,N5,N4)+ROCFLS(K,N,N6,N5,N4)
      XONFLS(K,N,N6,N5,N4)=XONFLS(K,N,N6,N5,N4)+RONFLS(K,N,N6,N5,N4)
      XOPFLS(K,N,N6,N5,N4)=XOPFLS(K,N,N6,N5,N4)+ROPFLS(K,N,N6,N5,N4)
      XOAFLS(K,N,N6,N5,N4)=XOAFLS(K,N,N6,N5,N4)+ROAFLS(K,N,N6,N5,N4)
      XOCFHS(K,N,N6,N5,N4)=XOCFHS(K,N,N6,N5,N4)+ROCFHS(K,N,N6,N5,N4)
      XONFHS(K,N,N6,N5,N4)=XONFHS(K,N,N6,N5,N4)+RONFHS(K,N,N6,N5,N4)
      XOPFHS(K,N,N6,N5,N4)=XOPFHS(K,N,N6,N5,N4)+ROPFHS(K,N,N6,N5,N4)
      XOAFHS(K,N,N6,N5,N4)=XOAFHS(K,N,N6,N5,N4)+ROAFHS(K,N,N6,N5,N4)
9755  CONTINUE
      XCOFLS(N,N6,N5,N4)=XCOFLS(N,N6,N5,N4)+RCOFLS(N,N6,N5,N4)
      XCHFLS(N,N6,N5,N4)=XCHFLS(N,N6,N5,N4)+RCHFLS(N,N6,N5,N4)
      XOXFLS(N,N6,N5,N4)=XOXFLS(N,N6,N5,N4)+ROXFLS(N,N6,N5,N4)
      XNGFLS(N,N6,N5,N4)=XNGFLS(N,N6,N5,N4)+RNGFLS(N,N6,N5,N4)
      XN2FLS(N,N6,N5,N4)=XN2FLS(N,N6,N5,N4)+RN2FLS(N,N6,N5,N4)
      XHGFLS(N,N6,N5,N4)=XHGFLS(N,N6,N5,N4)+RHGFLS(N,N6,N5,N4)
      XN4FLW(N,N6,N5,N4)=XN4FLW(N,N6,N5,N4)+RN4FLW(N,N6,N5,N4)
      XN3FLW(N,N6,N5,N4)=XN3FLW(N,N6,N5,N4)+RN3FLW(N,N6,N5,N4)
      XNOFLW(N,N6,N5,N4)=XNOFLW(N,N6,N5,N4)+RNOFLW(N,N6,N5,N4)
      XNXFLS(N,N6,N5,N4)=XNXFLS(N,N6,N5,N4)+RNXFLS(N,N6,N5,N4)
      XH1PFS(N,N6,N5,N4)=XH1PFS(N,N6,N5,N4)+RH1PFS(N,N6,N5,N4)
      XH2PFS(N,N6,N5,N4)=XH2PFS(N,N6,N5,N4)+RH2PFS(N,N6,N5,N4)
      XN4FLB(N,N6,N5,N4)=XN4FLB(N,N6,N5,N4)+RN4FLB(N,N6,N5,N4)
      XN3FLB(N,N6,N5,N4)=XN3FLB(N,N6,N5,N4)+RN3FLB(N,N6,N5,N4)
      XNOFLB(N,N6,N5,N4)=XNOFLB(N,N6,N5,N4)+RNOFLB(N,N6,N5,N4)
      XNXFLB(N,N6,N5,N4)=XNXFLB(N,N6,N5,N4)+RNXFLB(N,N6,N5,N4)
      XH1BFB(N,N6,N5,N4)=XH1BFB(N,N6,N5,N4)+RH1BFB(N,N6,N5,N4)
      XH2BFB(N,N6,N5,N4)=XH2BFB(N,N6,N5,N4)+RH2BFB(N,N6,N5,N4)
      XCOFHS(N,N6,N5,N4)=XCOFHS(N,N6,N5,N4)+RCOFHS(N,N6,N5,N4)
      XCHFHS(N,N6,N5,N4)=XCHFHS(N,N6,N5,N4)+RCHFHS(N,N6,N5,N4)
      XOXFHS(N,N6,N5,N4)=XOXFHS(N,N6,N5,N4)+ROXFHS(N,N6,N5,N4)
      XNGFHS(N,N6,N5,N4)=XNGFHS(N,N6,N5,N4)+RNGFHS(N,N6,N5,N4)
      XN2FHS(N,N6,N5,N4)=XN2FHS(N,N6,N5,N4)+RN2FHS(N,N6,N5,N4)
      XHGFHS(N,N6,N5,N4)=XHGFHS(N,N6,N5,N4)+RHGFHS(N,N6,N5,N4)
      XN4FHW(N,N6,N5,N4)=XN4FHW(N,N6,N5,N4)+RN4FHW(N,N6,N5,N4)
      XN3FHW(N,N6,N5,N4)=XN3FHW(N,N6,N5,N4)+RN3FHW(N,N6,N5,N4)
      XNOFHW(N,N6,N5,N4)=XNOFHW(N,N6,N5,N4)+RNOFHW(N,N6,N5,N4)
      XNXFHS(N,N6,N5,N4)=XNXFHS(N,N6,N5,N4)+RNXFHS(N,N6,N5,N4)
      XH1PHS(N,N6,N5,N4)=XH1PHS(N,N6,N5,N4)+RH1PHS(N,N6,N5,N4)
      XH2PHS(N,N6,N5,N4)=XH2PHS(N,N6,N5,N4)+RH2PHS(N,N6,N5,N4)
      XN4FHB(N,N6,N5,N4)=XN4FHB(N,N6,N5,N4)+RN4FHB(N,N6,N5,N4)
      XN3FHB(N,N6,N5,N4)=XN3FHB(N,N6,N5,N4)+RN3FHB(N,N6,N5,N4)
      XNOFHB(N,N6,N5,N4)=XNOFHB(N,N6,N5,N4)+RNOFHB(N,N6,N5,N4)
      XNXFHB(N,N6,N5,N4)=XNXFHB(N,N6,N5,N4)+RNXFHB(N,N6,N5,N4)
      XH1BHB(N,N6,N5,N4)=XH1BHB(N,N6,N5,N4)+RH1BHB(N,N6,N5,N4)
      XH2BHB(N,N6,N5,N4)=XH2BHB(N,N6,N5,N4)+RH2BHB(N,N6,N5,N4)
C
C     MACROPORE-MICROPORE SOLUTE EXCHANGE WITHIN SOIL
C     LAYER FROM WATER EXCHANGE IN 'WATSUB' AND
C     FROM MACROPORE OR MICROPORE SOLUTE CONCENTRATIONS
C
      IF(N.EQ.3)THEN
C
C     MACROPORE-MICROPORE CONVECTIVE SOLUTE EXCHANGE IN SOIL
C     LAYER FROM WATER EXCHANGE IN 'WATSUB' AND
C     FROM MACROPORE OR MICROPORE SOLUTE CONCENTRATIONS
C
C     FINHM=macro-micropore water transfer from watsub.f
C     VOLWM,VOLWHM=micropore,macropore water volume
C     RFL*=convective macropore-micropore solute transfer
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     *H2,*2=macropore,micropore solute content
C
C     MACROPORE TO MICROPORE TRANSFER
C
      IF(FINHM(M,N6,N5,N4).GT.0.0)THEN
      IF(VOLWHM(M,N6,N5,N4).GT.ZEROS2(N5,N4))THEN
      VFLW=AMAX1(0.0,AMIN1(VFLWX,FINHM(M,N6,N5,N4)
     2/VOLWHM(M,N6,N5,N4)))
      ELSE
      VFLW=VFLWX
      ENDIF
      DO 9970 K=0,4
      RFLOC(K)=VFLW*AMAX1(0.0,OQCH2(K,N6,N5,N4))
      RFLON(K)=VFLW*AMAX1(0.0,OQNH2(K,N6,N5,N4))
      RFLOP(K)=VFLW*AMAX1(0.0,OQPH2(K,N6,N5,N4))
      RFLOA(K)=VFLW*AMAX1(0.0,OQAH2(K,N6,N5,N4))
9970  CONTINUE
      RFLCOS=VFLW*AMAX1(0.0,CO2SH2(N6,N5,N4))
      RFLCHS=VFLW*AMAX1(0.0,CH4SH2(N6,N5,N4))
      RFLOXS=VFLW*AMAX1(0.0,OXYSH2(N6,N5,N4))
      RFLNGS=VFLW*AMAX1(0.0,Z2GSH2(N6,N5,N4))
      RFLN2S=VFLW*AMAX1(0.0,Z2OSH2(N6,N5,N4))
      RFLHGS=VFLW*AMAX1(0.0,H2GSH2(N6,N5,N4))
      RFLNH4=VFLW*AMAX1(0.0,ZNH4H2(N6,N5,N4))*VLNH4(N6,N5,N4)
      RFLNH3=VFLW*AMAX1(0.0,ZNH3H2(N6,N5,N4))*VLNH4(N6,N5,N4)
      RFLNO3=VFLW*AMAX1(0.0,ZNO3H2(N6,N5,N4))*VLNO3(N6,N5,N4)
      RFLNO2=VFLW*AMAX1(0.0,ZNO2H2(N6,N5,N4))*VLNO3(N6,N5,N4)
      RFLP14=VFLW*AMAX1(0.0,H1P4H2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFLPO4=VFLW*AMAX1(0.0,H2P4H2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFLN4B=VFLW*AMAX1(0.0,ZN4BH2(N6,N5,N4))*VLNHB(N6,N5,N4)
      RFLN3B=VFLW*AMAX1(0.0,ZN3BH2(N6,N5,N4))*VLNHB(N6,N5,N4)
      RFLNOB=VFLW*AMAX1(0.0,ZNOBH2(N6,N5,N4))*VLNOB(N6,N5,N4)
      RFLN2B=VFLW*AMAX1(0.0,ZN2BH2(N6,N5,N4))*VLNOB(N6,N5,N4)
      RFLP1B=VFLW*AMAX1(0.0,H1PBH2(N6,N5,N4))*VLPOB(N6,N5,N4)
      RFLPOB=VFLW*AMAX1(0.0,H2PBH2(N6,N5,N4))*VLPOB(N6,N5,N4)
C
C     MICROPORE TO MACROPORE TRANSFER
C
      ELSEIF(FINHM(M,N6,N5,N4).LT.0.0)THEN
      IF(VOLWM(M,N6,N5,N4).GT.ZEROS2(N5,N4))THEN
      VFLW=AMIN1(0.0,AMAX1(-VFLWX,FINHM(M,N6,N5,N4)
     2/VOLWM(M,N6,N5,N4)))
      ELSE
      VFLW=-VFLWX
      ENDIF
      DO 9965 K=0,4
      RFLOC(K)=VFLW*AMAX1(0.0,OQC2(K,N6,N5,N4))
      RFLON(K)=VFLW*AMAX1(0.0,OQN2(K,N6,N5,N4))
      RFLOP(K)=VFLW*AMAX1(0.0,OQP2(K,N6,N5,N4))
      RFLOA(K)=VFLW*AMAX1(0.0,OQA2(K,N6,N5,N4))
9965  CONTINUE
      RFLCOS=VFLW*AMAX1(0.0,CO2S2(N6,N5,N4))
      RFLCHS=VFLW*AMAX1(0.0,CH4S2(N6,N5,N4))
      RFLOXS=VFLW*AMAX1(0.0,OXYS2(N6,N5,N4))
      RFLNGS=VFLW*AMAX1(0.0,Z2GS2(N6,N5,N4))
      RFLN2S=VFLW*AMAX1(0.0,Z2OS2(N6,N5,N4))
      RFLHGS=VFLW*AMAX1(0.0,H2GS2(N6,N5,N4))
      RFLNH4=VFLW*AMAX1(0.0,ZNH4S2(N6,N5,N4))*VLNH4(N6,N5,N4)
      RFLNH3=VFLW*AMAX1(0.0,ZNH3S2(N6,N5,N4))*VLNH4(N6,N5,N4)
      RFLNO3=VFLW*AMAX1(0.0,ZNO3S2(N6,N5,N4))*VLNO3(N6,N5,N4)
      RFLNO2=VFLW*AMAX1(0.0,ZNO2S2(N6,N5,N4))*VLNO3(N6,N5,N4)
      RFLP14=VFLW*AMAX1(0.0,H1PO42(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFLPO4=VFLW*AMAX1(0.0,H2PO42(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFLN4B=VFLW*AMAX1(0.0,ZNH4B2(N6,N5,N4))*VLNHB(N6,N5,N4)
      RFLN3B=VFLW*AMAX1(0.0,ZNH3B2(N6,N5,N4))*VLNHB(N6,N5,N4)
      RFLNOB=VFLW*AMAX1(0.0,ZNO3B2(N6,N5,N4))*VLNOB(N6,N5,N4)
      RFLN2B=VFLW*AMAX1(0.0,ZNO2B2(N6,N5,N4))*VLNOB(N6,N5,N4)
      RFLP1B=VFLW*AMAX1(0.0,H1POB2(N6,N5,N4))*VLPOB(N6,N5,N4)
      RFLPOB=VFLW*AMAX1(0.0,H2POB2(N6,N5,N4))*VLPOB(N6,N5,N4)
C
C     NO MACROPORE TO MICROPORE TRANSFER
C
      ELSE
      DO 9960 K=0,4
      RFLOC(K)=0.0
      RFLON(K)=0.0
      RFLOP(K)=0.0
      RFLOA(K)=0.0
9960  CONTINUE
      RFLCOS=0.0
      RFLCHS=0.0
      RFLOXS=0.0
      RFLNGS=0.0
      RFLN2S=0.0
      RFLHGS=0.0
      RFLNH4=0.0
      RFLNH3=0.0
      RFLNO3=0.0
      RFLNO2=0.0
      RFLP14=0.0
      RFLPO4=0.0
      RFLN4B=0.0
      RFLN3B=0.0
      RFLNOB=0.0
      RFLN2B=0.0
      RFLP1B=0.0
      RFLPOB=0.0
      ENDIF
C
C     DIFFUSIVE FLUXES OF SOLUTES BETWEEN MICROPORES AND
C     MACROPORES FROM AQUEOUS DIFFUSIVITIES AND CONCENTRATION
C     DIFFERENCES
C
C     VOLWM,VOLWHM=micropore,macropore water-filled porosity from watsub.f
C     DFV*S,DFV*B=diffusive solute flux between macro- and micropore in non-band,band
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     *2,*H2=solute content of micropores,macropores
C
      IF(VOLWHM(M,N6,N5,N4).GT.ZEROS2(N5,N4))THEN
      VOLWHS=AMIN1(XFRS*VOLT(N6,N5,N4),VOLWHM(M,N6,N5,N4))
      VOLWT=VOLWM(M,N6,N5,N4)+VOLWHS
      DO 9955 K=0,4
      DFVOC(K)=XNPH*(AMAX1(0.0,OQCH2(K,N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,OQC2(K,N6,N5,N4))*VOLWHS)/VOLWT
      DFVON(K)=XNPH*(AMAX1(0.0,OQNH2(K,N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,OQN2(K,N6,N5,N4))*VOLWHS)/VOLWT
      DFVOP(K)=XNPH*(AMAX1(0.0,OQPH2(K,N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,OQP2(K,N6,N5,N4))*VOLWHS)/VOLWT
      DFVOA(K)=XNPH*(AMAX1(0.0,OQAH2(K,N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,OQA2(K,N6,N5,N4))*VOLWHS)/VOLWT
9955  CONTINUE
      DFVCOS=XNPH*(AMAX1(0.0,CO2SH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,CO2S2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVCHS=XNPH*(AMAX1(0.0,CH4SH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,CH4S2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVOXS=XNPH*(AMAX1(0.0,OXYSH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,OXYS2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVNGS=XNPH*(AMAX1(0.0,Z2GSH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,Z2GS2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVN2S=XNPH*(AMAX1(0.0,Z2OSH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,Z2OS2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVHGS=XNPH*(AMAX1(0.0,H2GSH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,H2GS2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVNH4=XNPH*(AMAX1(0.0,ZNH4H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZNH4S2(N6,N5,N4))*VOLWHS)/VOLWT
     3*VLNH4(N6,N5,N4)
      DFVNH3=XNPH*(AMAX1(0.0,ZNH3H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZNH3S2(N6,N5,N4))*VOLWHS)/VOLWT
     3*VLNH4(N6,N5,N4)
      DFVNO3=XNPH*(AMAX1(0.0,ZNO3H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZNO3S2(N6,N5,N4))*VOLWHS)/VOLWT
     3*VLNO3(N6,N5,N4)
      DFVNO2=XNPH*(AMAX1(0.0,ZNO2H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZNO2S2(N6,N5,N4))*VOLWHS)/VOLWT
     3*VLNO3(N6,N5,N4)
      DFVP14=XNPH*(AMAX1(0.0,H1P4H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,H1PO42(N6,N5,N4))*VOLWHS)/VOLWT
     3*VLPO4(N6,N5,N4)
      DFVPO4=XNPH*(AMAX1(0.0,H2P4H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,H2PO42(N6,N5,N4))*VOLWHS)/VOLWT
     3*VLPO4(N6,N5,N4)
      DFVN4B=XNPH*(AMAX1(0.0,ZN4BH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZNH4B2(N6,N5,N4))*VOLWHS)/VOLWT
     3*VLNHB(N6,N5,N4)
      DFVN3B=XNPH*(AMAX1(0.0,ZN3BH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZNH3B2(N6,N5,N4))*VOLWHS)/VOLWT
     3*VLNHB(N6,N5,N4)
      DFVNOB=XNPH*(AMAX1(0.0,ZNOBH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZNO3B2(N6,N5,N4))*VOLWHS)/VOLWT
     3*VLNOB(N6,N5,N4)
      DFVN2B=XNPH*(AMAX1(0.0,ZN2BH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZNO2B2(N6,N5,N4))*VOLWHS)/VOLWT
     3*VLNOB(N6,N5,N4)
      DFVP1B=XNPH*(AMAX1(0.0,H1PBH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,H1POB2(N6,N5,N4))*VOLWHS)/VOLWT
     3*VLPOB(N6,N5,N4)
      DFVPOB=XNPH*(AMAX1(0.0,H2PBH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,H2POB2(N6,N5,N4))*VOLWHS)/VOLWT
     3*VLPOB(N6,N5,N4)
      ELSE
      DO 9975 K=0,4
      DFVOC(K)=0.0
      DFVON(K)=0.0
      DFVOP(K)=0.0
      DFVOA(K)=0.0
9975  CONTINUE
      DFVCOS=0.0
      DFVCHS=0.0
      DFVOXS=0.0
      DFVNGS=0.0
      DFVN2S=0.0
      DFVHGS=0.0
      DFVNH4=0.0
      DFVNH3=0.0
      DFVNO3=0.0
      DFVNO2=0.0
      DFVP14=0.0
      DFVPO4=0.0
      DFVN4B=0.0
      DFVN3B=0.0
      DFVNOB=0.0
      DFVN2B=0.0
      DFVP1B=0.0
      DFVPOB=0.0
      ENDIF
C
C     TOTAL CONVECTIVE +DIFFUSIVE TRANSFER BETWEEN MACROPOES AND MICROPORES
C
C     R*FXS,R*FXB=total convective + diffusive solute flux between macro- and micropore in non-band,band
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     RFL*=convective flux between macro- and micropore
C     DFV*=diffusive solute flux between macro- and micropore
C
      DO 9950 K=0,4
      ROCFXS(K,N6,N5,N4)=RFLOC(K)+DFVOC(K)
      RONFXS(K,N6,N5,N4)=RFLON(K)+DFVON(K)
      ROPFXS(K,N6,N5,N4)=RFLOP(K)+DFVOP(K)
      ROAFXS(K,N6,N5,N4)=RFLOA(K)+DFVOA(K)
9950  CONTINUE
      RCOFXS(N6,N5,N4)=RFLCOS+DFVCOS
      RCHFXS(N6,N5,N4)=RFLCHS+DFVCHS
      ROXFXS(N6,N5,N4)=RFLOXS+DFVOXS
      RNGFXS(N6,N5,N4)=RFLNGS+DFVNGS
      RN2FXS(N6,N5,N4)=RFLN2S+DFVN2S
      RHGFXS(N6,N5,N4)=RFLHGS+DFVHGS
      RN4FXW(N6,N5,N4)=RFLNH4+DFVNH4
      RN3FXW(N6,N5,N4)=RFLNH3+DFVNH3
      RNOFXW(N6,N5,N4)=RFLNO3+DFVNO3
      RNXFXS(N6,N5,N4)=RFLNO2+DFVNO2
      RH1PXS(N6,N5,N4)=RFLP14+DFVP14
      RH2PXS(N6,N5,N4)=RFLPO4+DFVPO4
      RN4FXB(N6,N5,N4)=RFLN4B+DFVN4B
      RN3FXB(N6,N5,N4)=RFLN3B+DFVN3B
      RNOFXB(N6,N5,N4)=RFLNOB+DFVNOB
      RNXFXB(N6,N5,N4)=RFLN2B+DFVN2B
      RH1BXB(N6,N5,N4)=RFLP1B+DFVP1B
      RH2BXB(N6,N5,N4)=RFLPOB+DFVPOB
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*FXS,X*FXB= hourly convective + diffusive solute flux between macro- and micropore in non-band,band
C     R*FXS,R*FXB=convective + diffusive solute flux between macro- and micropore in non-band,band
C
      DO 9945 K=0,4
      XOCFXS(K,N6,N5,N4)=XOCFXS(K,N6,N5,N4)+ROCFXS(K,N6,N5,N4)
      XONFXS(K,N6,N5,N4)=XONFXS(K,N6,N5,N4)+RONFXS(K,N6,N5,N4)
      XOPFXS(K,N6,N5,N4)=XOPFXS(K,N6,N5,N4)+ROPFXS(K,N6,N5,N4)
      XOAFXS(K,N6,N5,N4)=XOAFXS(K,N6,N5,N4)+ROAFXS(K,N6,N5,N4)
9945  CONTINUE
      XCOFXS(N6,N5,N4)=XCOFXS(N6,N5,N4)+RCOFXS(N6,N5,N4)
      XCHFXS(N6,N5,N4)=XCHFXS(N6,N5,N4)+RCHFXS(N6,N5,N4)
      XOXFXS(N6,N5,N4)=XOXFXS(N6,N5,N4)+ROXFXS(N6,N5,N4)
      XNGFXS(N6,N5,N4)=XNGFXS(N6,N5,N4)+RNGFXS(N6,N5,N4)
      XN2FXS(N6,N5,N4)=XN2FXS(N6,N5,N4)+RN2FXS(N6,N5,N4)
      XHGFXS(N6,N5,N4)=XHGFXS(N6,N5,N4)+RHGFXS(N6,N5,N4)
      XN4FXW(N6,N5,N4)=XN4FXW(N6,N5,N4)+RN4FXW(N6,N5,N4)
      XN3FXW(N6,N5,N4)=XN3FXW(N6,N5,N4)+RN3FXW(N6,N5,N4)
      XNOFXW(N6,N5,N4)=XNOFXW(N6,N5,N4)+RNOFXW(N6,N5,N4)
      XNXFXS(N6,N5,N4)=XNXFXS(N6,N5,N4)+RNXFXS(N6,N5,N4)
      XH1PXS(N6,N5,N4)=XH1PXS(N6,N5,N4)+RH1PXS(N6,N5,N4)
      XH2PXS(N6,N5,N4)=XH2PXS(N6,N5,N4)+RH2PXS(N6,N5,N4)
      XN4FXB(N6,N5,N4)=XN4FXB(N6,N5,N4)+RN4FXB(N6,N5,N4)
      XN3FXB(N6,N5,N4)=XN3FXB(N6,N5,N4)+RN3FXB(N6,N5,N4)
      XNOFXB(N6,N5,N4)=XNOFXB(N6,N5,N4)+RNOFXB(N6,N5,N4)
      XNXFXB(N6,N5,N4)=XNXFXB(N6,N5,N4)+RNXFXB(N6,N5,N4)
      XH1BXB(N6,N5,N4)=XH1BXB(N6,N5,N4)+RH1BXB(N6,N5,N4)
      XH2BXB(N6,N5,N4)=XH2BXB(N6,N5,N4)+RH2BXB(N6,N5,N4)
      ENDIF
      ENDIF
C
C     GASEOUS TRANSPORT FROM GASEOUS DIFFUSIVITY AND CONCENTRATION
C     DIFFERENCES BETWEEN ADJACENT GRID CELLS
C
C     THETPM,VOLPM=air-filled porosity,volume from watsub.f
C
      IF(THETPM(M,N3,N2,N1).GT.THETX
     2.AND.THETPM(M,N6,N5,N4).GT.THETX
     3.AND.VOLPM(M,N3,N2,N1).GT.ZEROS2(N2,N1)
     4.AND.VOLPM(M,N6,N5,N4).GT.ZEROS2(N5,N4))THEN
C
C     GASEOUS DIFFUSIVITIES
C
C     DFLG2,DFLGL=air-filled porosity effect on gaseous diffusivity in source,destination layer
C     POROQ=Penman Water Linear Reduction tortuosity from starts.f
C     POROS=total porosity
C     DLYR=soil layer thickness
C     D*G=gaseous diffusivity in soil
C     CND*1,CND*2=gaseous conductance in source,destination layer
C     *SGL2= gaseous diffusivity in air
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C
      DFLG2=2.0*AMAX1(0.0,THETPM(M,N3,N2,N1))*POROQ
     2*THETPM(M,N3,N2,N1)/POROS(N3,N2,N1)
     2*AREA(N,N3,N2,N1)/DLYR(N,N3,N2,N1)
      DFLGL=2.0*AMAX1(0.0,THETPM(M,N6,N5,N4))*POROQ
     2*THETPM(M,N6,N5,N4)/POROS(N6,N5,N4)
     2*AREA(N,N6,N5,N4)/DLYR(N,N6,N5,N4)
      CNDC1=DFLG2*CGSGL2(N3,N2,N1)
      CND41=DFLG2*CHSGL2(N3,N2,N1)
      CNDO1=DFLG2*OGSGL2(N3,N2,N1)
      CNDG1=DFLG2*ZGSGL2(N3,N2,N1)
      CND21=DFLG2*Z2SGL2(N3,N2,N1)
      CNDH1=DFLG2*ZHSGL2(N3,N2,N1)
      CNHG1=DFLG2*HGSGL2(N3,N2,N1)
      CNDC2=DFLGL*CGSGL2(N6,N5,N4)
      CND42=DFLGL*CHSGL2(N6,N5,N4)
      CNDO2=DFLGL*OGSGL2(N6,N5,N4)
      CNDG2=DFLGL*ZGSGL2(N6,N5,N4)
      CND22=DFLGL*Z2SGL2(N6,N5,N4)
      CNDH2=DFLGL*ZHSGL2(N6,N5,N4)
      CNHG2=DFLGL*HGSGL2(N6,N5,N4)
C
C     GASOUS CONDUCTANCES
C
C     D*G=gaseous diffusivity in soil
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C
      DCO2G(N,N6,N5,N4)=(CNDC1*CNDC2)/(CNDC1+CNDC2)
      DCH4G(N,N6,N5,N4)=(CND41*CND42)/(CND41+CND42)
      DOXYG(N,N6,N5,N4)=(CNDO1*CNDO2)/(CNDO1+CNDO2)
      DZ2GG(N,N6,N5,N4)=(CNDG1*CNDG2)/(CNDG1+CNDG2)
      DZ2OG(N,N6,N5,N4)=(CND21*CND22)/(CND21+CND22)
      DNH3G(N,N6,N5,N4)=(CNDH1*CNDH2)/(CNDH1+CNDH2)
      DH2GG(N,N6,N5,N4)=(CNHG1*CNHG2)/(CNHG1+CNHG2)
C
C     GASEOUS CONCENTRATIONS FROM AIR-FILLED POROSITY
C     IN CURRENT AND ADJACENT GRID CELLS
C
C     C*G1,C*G2=gaseous concentration in source,destination layer
C     *G2=gaseous content
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C     VOLPM=air-filled porosity
C
      CCO2G1=AMAX1(0.0,CO2G2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      CCH4G1=AMAX1(0.0,CH4G2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      COXYG1=AMAX1(0.0,OXYG2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      CZ2GG1=AMAX1(0.0,Z2GG2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      CZ2OG1=AMAX1(0.0,Z2OG2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      CNH3G1=AMAX1(0.0,ZN3G2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      CH2GG1=AMAX1(0.0,H2GG2(N3,N2,N1)/VOLPM(M,N3,N2,N1))
      CCO2G2=AMAX1(0.0,CO2G2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
      CCH4G2=AMAX1(0.0,CH4G2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
      COXYG2=AMAX1(0.0,OXYG2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
      CZ2GG2=AMAX1(0.0,Z2GG2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
      CZ2OG2=AMAX1(0.0,Z2OG2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
      CNH3G2=AMAX1(0.0,ZN3G2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
      CH2GG2=AMAX1(0.0,H2GG2(N6,N5,N4)/VOLPM(M,N6,N5,N4))
C
C     DIFFUSIVE GAS TRANSFER DRIVEN BY GAS CONCENTRATIONS IN
C     ADJACENT GRID CELLS
C
C     DFV*G=diffusive gas flux
C     C*G1,C*G2=gaseous concentration in source,destination layer
C
      DFVCOG=DCO2G(N,N6,N5,N4)*(CCO2G1-CCO2G2)
      DFVCHG=DCH4G(N,N6,N5,N4)*(CCH4G1-CCH4G2)
      DFVOXG=DOXYG(N,N6,N5,N4)*(COXYG1-COXYG2)
      DFVNGG=DZ2GG(N,N6,N5,N4)*(CZ2GG1-CZ2GG2)
      DFVN2G=DZ2OG(N,N6,N5,N4)*(CZ2OG1-CZ2OG2)
      DFVN3G=DNH3G(N,N6,N5,N4)*(CNH3G1-CNH3G2)
      DFVHGG=DH2GG(N,N6,N5,N4)*(CH2GG1-CH2GG2)
C
C     CONVECTIVE GAS TRANSFER DRIVEN BY SOIL WATER FLUXES
C     FROM 'WATSUB' AND GAS CONCENTRATIONS IN THE ADJACENT GRID CELLS
C     DEPENDING ON WATER FLUX DIRECTION
C
C     FLQM=total water flux into soil micropore+macropore from watsub.f
C     VOLPM=air-filled porosity
C     RFL*G=convective gas flux
C     gas code:*CO*=CO2,*OX*=O2,*CH*=CH4,*NG*=N2,*N2*=N2O,*NH*=NH3,*HG*=H2
C     *G2=gaseous content
C
      IF(FLQM(N,N6,N5,N4).GT.0.0)THEN
      IF(VOLPM(M,N6,N5,N4).GT.ZEROS2(N5,N4))THEN
      VFLW=-AMAX1(0.0,AMIN1(VFLWX,FLQM(N,N6,N5,N4)
     2/VOLPM(M,N6,N5,N4)))
      ELSE
      VFLW=-VFLWX
      ENDIF
      RFLCOG=VFLW*AMAX1(0.0,CO2G2(N6,N5,N4))
      RFLCHG=VFLW*AMAX1(0.0,CH4G2(N6,N5,N4))
      RFLOXG=VFLW*AMAX1(0.0,OXYG2(N6,N5,N4))
      RFLNGG=VFLW*AMAX1(0.0,Z2GG2(N6,N5,N4))
      RFLN2G=VFLW*AMAX1(0.0,Z2OG2(N6,N5,N4))
      RFLN3G=VFLW*AMAX1(0.0,ZN3G2(N6,N5,N4))
      RFLH2G=VFLW*AMAX1(0.0,H2GG2(N6,N5,N4))
      ELSE
      IF(VOLPM(M,N3,N2,N1).GT.ZEROS2(N2,N1))THEN
      VFLW=-AMIN1(0.0,AMAX1(-VFLWX,FLQM(N,N6,N5,N4)
     2/VOLPM(M,N3,N2,N1)))
      ELSE
      VFLW=VFLWX
      ENDIF
      RFLCOG=VFLW*AMAX1(0.0,CO2G2(N3,N2,N1))
      RFLCHG=VFLW*AMAX1(0.0,CH4G2(N3,N2,N1))
      RFLOXG=VFLW*AMAX1(0.0,OXYG2(N3,N2,N1))
      RFLNGG=VFLW*AMAX1(0.0,Z2GG2(N3,N2,N1))
      RFLN2G=VFLW*AMAX1(0.0,Z2OG2(N3,N2,N1))
      RFLN3G=VFLW*AMAX1(0.0,ZN3G2(N3,N2,N1))
      RFLH2G=VFLW*AMAX1(0.0,H2GG2(N3,N2,N1))
      ENDIF
C
C     TOTAL SOIL GAS FLUX FROM DIFFUSIVE + CONVECTIVE FLUX
C
C     R*FLG=total convective+diffusive gas flux
C     gas code:*CO*=CO2,*OX*=O2,*CH*=CH4,*NG*=N2,*N2*=N2O,*NH*=NH3,*HG*=H2
C     DFV*G=diffusive gas flux
C     RFL*G=convective gas flux
C
      RCOFLG(N,N6,N5,N4)=DFVCOG+RFLCOG
      RCHFLG(N,N6,N5,N4)=DFVCHG+RFLCHG
      ROXFLG(N,N6,N5,N4)=DFVOXG+RFLOXG
      RNGFLG(N,N6,N5,N4)=DFVNGG+RFLNGG
      RN2FLG(N,N6,N5,N4)=DFVN2G+RFLN2G
      RN3FLG(N,N6,N5,N4)=DFVN3G+RFLN3G
      RHGFLG(N,N6,N5,N4)=DFVHGG+RFLH2G
C     IF(I.EQ.43)THEN
C     WRITE(*,3133)'ROXFL2',I,J,M,MM,N1,N2,N3,N,XOXFLG(N,N6,N5,N4)
C    2,ROXFLG(N,N6,N5,N4),DFVOXG,RFLOXG,COXYG1,COXYG2
C    3,OXYG2(N3,N2,N1),OXYG2(N6,N5,N4)
C    4,FLQM(N,N6,N5,N4),VFLW,DOXYG(N,N6,N5,N4)
C    5,THETPM(M,N3,N2,N1),THETPM(M,N6,N5,N4)
C    5,VOLPM(M,N3,N2,N1),VOLPM(M,N6,N5,N4)
C     WRITE(*,3133)'RNGFLG',I,J,M,MM,N4,N4,N6,N,RNGFLG(N,N6,N5,N4)
C    2,DFVNGG,RFLNGG,DZ2GG(N,N6,N5,N4),CZ2GG1,CZ2GG2
3133  FORMAT(A8,8I4,20E12.4)
C     ENDIF
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*FLG=hourly total convective+diffusive gas flux
C
      XCOFLG(N,N6,N5,N4)=XCOFLG(N,N6,N5,N4)+RCOFLG(N,N6,N5,N4)
      XCHFLG(N,N6,N5,N4)=XCHFLG(N,N6,N5,N4)+RCHFLG(N,N6,N5,N4)
      XOXFLG(N,N6,N5,N4)=XOXFLG(N,N6,N5,N4)+ROXFLG(N,N6,N5,N4)
      XNGFLG(N,N6,N5,N4)=XNGFLG(N,N6,N5,N4)+RNGFLG(N,N6,N5,N4)
      XN2FLG(N,N6,N5,N4)=XN2FLG(N,N6,N5,N4)+RN2FLG(N,N6,N5,N4)
      XN3FLG(N,N6,N5,N4)=XN3FLG(N,N6,N5,N4)+RN3FLG(N,N6,N5,N4)
      XHGFLG(N,N6,N5,N4)=XHGFLG(N,N6,N5,N4)+RHGFLG(N,N6,N5,N4)
      ELSE
      RCOFLG(N,N6,N5,N4)=0.0
      RCHFLG(N,N6,N5,N4)=0.0
      ROXFLG(N,N6,N5,N4)=0.0
      RNGFLG(N,N6,N5,N4)=0.0
      RN2FLG(N,N6,N5,N4)=0.0
      RN3FLG(N,N6,N5,N4)=0.0
      RHGFLG(N,N6,N5,N4)=0.0
      ENDIF
C
C     VOLATILIZATION-DISSOLUTION OF GASES IN SOIL
C     LAYER FROM GASEOUS CONCENTRATIONS VS. THEIR AQUEOUS
C     EQUIVALENTS DEPENDING ON SOLUBILITY FROM 'HOUR1'
C     AND TRANSFER COEFFICIENT 'DFGS' FROM 'WATSUB'
C
C     THETPM,VOLWPM=air-filled porosity,volume
C     R*DFG=water-air gas flux
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C     DFGS=rate constant for air-water gas exchange from watsub.f
C     *G2,*S2=gaseous,aqueous gas content
C     VOLW*=equivalent aqueous volume for gas
C
      IF(N.EQ.3)THEN
      IF(THETPM(M,N6,N5,N4).GT.THETX)THEN
      RCODFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,CO2G2(N6,N5,N4))*VOLWCO(N6,N5,N4)
     3-CO2S2(N6,N5,N4)*VOLPM(M,N6,N5,N4))
     4/(VOLWCO(N6,N5,N4)+VOLPM(M,N6,N5,N4))
      RCHDFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,CH4G2(N6,N5,N4))*VOLWCH(N6,N5,N4)
     3-CH4S2(N6,N5,N4)*VOLPM(M,N6,N5,N4))
     4/(VOLWCH(N6,N5,N4)+VOLPM(M,N6,N5,N4))
      ROXDFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,OXYG2(N6,N5,N4))*VOLWOX(N6,N5,N4)
     3-OXYS2(N6,N5,N4)*VOLPM(M,N6,N5,N4))
     4/(VOLWOX(N6,N5,N4)+VOLPM(M,N6,N5,N4))
      RNGDFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,Z2GG2(N6,N5,N4))*VOLWNG(N6,N5,N4)
     3-Z2GS2(N6,N5,N4)*VOLPM(M,N6,N5,N4))
     4/(VOLWNG(N6,N5,N4)+VOLPM(M,N6,N5,N4))
      RN2DFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,Z2OG2(N6,N5,N4))*VOLWN2(N6,N5,N4)
     3-Z2OS2(N6,N5,N4)*VOLPM(M,N6,N5,N4))
     3/(VOLWN2(N6,N5,N4)+VOLPM(M,N6,N5,N4))
      IF(VOLPMA(N6,N5,N4).GT.ZEROS2(N5,N4)
     2.AND.VOLWXA(N6,N5,N4).GT.ZEROS2(N5,N4))THEN
      RN3DFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,ZN3G2(N6,N5,N4))*VOLWN3(N6,N5,N4)
     3-ZNH3S2(N6,N5,N4)*VOLPMA(N6,N5,N4))
     4/(VOLWN3(N6,N5,N4)+VOLPMA(N6,N5,N4))
      CNH3S0=AMAX1(0.0,(ZNH3S2(N6,N5,N4)+RN3DFG(N6,N5,N4))
     2/VOLWXA(N6,N5,N4))
      CNH4S0=AMAX1(0.0,ZNH4S2(N6,N5,N4))
     2/VOLWXA(N6,N5,N4)
      ELSE
      RN3DFG(N6,N5,N4)=0.0
      ENDIF
      IF(VOLPMB(N6,N5,N4).GT.ZEROS2(N5,N4)
     2.AND.VOLWXB(N6,N5,N4).GT.ZEROS2(N5,N4))THEN
      RNBDFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,ZN3G2(N6,N5,N4))*VOLWNB(N6,N5,N4)
     3-ZNH3B2(N6,N5,N4)*VOLPMB(N6,N5,N4))
     4/(VOLWNB(N6,N5,N4)+VOLPMB(N6,N5,N4))
      CNH3B0=AMAX1(0.0,(ZNH3B2(N6,N5,N4)+RNBDFG(N6,N5,N4))
     2/VOLWXB(N6,N5,N4))
      CNH4B0=AMAX1(0.0,ZNH4B2(N6,N5,N4))/VOLWXB(N6,N5,N4)
      ELSE
      RNBDFG(N6,N5,N4)=0.0
      ENDIF
      RHGDFG(N6,N5,N4)=DFGS(M,N6,N5,N4)*(AMAX1(ZEROS(N5,N4)
     2,H2GG2(N6,N5,N4))*VOLWHG(N6,N5,N4)
     3-H2GS2(N6,N5,N4)*VOLPM(M,N6,N5,N4))
     4/(VOLWHG(N6,N5,N4)+VOLPM(M,N6,N5,N4))
C     IF(I.EQ.121.AND.N6.EQ.2)THEN
C     WRITE(*,6666)'RCODFG',I,J,M,MM,N4,N5,N6,RCODFG(N6,N5,N4)
C    2,DFGS(M,N6,N5,N4),CO2G2(N6,N5,N4),VOLWCO(N6,N5,N4)
C    3,CO2S2(N6,N5,N4),VOLWM(M,N6,N5,N4),THETPM(M,N6,N5,N4)
C    4,SCO2L(N6,N5,N4),XCODFG(N6,N5,N4)
C     WRITE(*,6666)'RN3DFG',I,J,M,MM,N4,N5,N6,RN3DFG(N6,N5,N4)
C    2,DFGS(M,N6,N5,N4),ZN3S2A,VOLWN3(N6,N5,N4),ZNH3S2(N6,N5,N4)
C    3,VOLPMA(N6,N5,N4),RNBDFG(N6,N5,N4),ZN3S2B
C    4,VOLWNB(N6,N5,N4),ZNH3B2(N6,N5,N4),VOLPMB(N6,N5,N4)
C     WRITE(*,6666)'RCHDFG',I,J,M,MM,N4,N5,N6,RCHDFG(N6,N5,N4)
C    2,DFGS(M,N6,N5,N4),CH4G2(N6,N5,N4),VOLWCH(N6,N5,N4)
C    3,CH4S2(N6,N5,N4),VOLWM(M,N6,N5,N4),THETPM(M,N6,N5,N4)
C    4,SCH4L(N6,N5,N4),XCHDFG(N6,N5,N4)
C     WRITE(*,6666)'RNGDFG',I,J,M,MM,N4,N5,N6
C    2,RNGDFG(N6,N5,N4),DFGS(M,N6,N5,N4),Z2GG2(N6,N5,N4)
C    3,VOLWNG(N6,N5,N4),Z2GS2(N6,N5,N4),VOLPM(M,N6,N5,N4)
C    4,VOLWNG(N6,N5,N4),VOLPM(M,N6,N5,N4)
6666  FORMAT(A8,7I4,20E12.4)
C     ENDIF
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*DFG=hourly water-air gas flux
C
      XCODFG(N6,N5,N4)=XCODFG(N6,N5,N4)+RCODFG(N6,N5,N4)
      XCHDFG(N6,N5,N4)=XCHDFG(N6,N5,N4)+RCHDFG(N6,N5,N4)
      XOXDFG(N6,N5,N4)=XOXDFG(N6,N5,N4)+ROXDFG(N6,N5,N4)
      XNGDFG(N6,N5,N4)=XNGDFG(N6,N5,N4)+RNGDFG(N6,N5,N4)
      XN2DFG(N6,N5,N4)=XN2DFG(N6,N5,N4)+RN2DFG(N6,N5,N4)
      XN3DFG(N6,N5,N4)=XN3DFG(N6,N5,N4)+RN3DFG(N6,N5,N4)
      XNBDFG(N6,N5,N4)=XNBDFG(N6,N5,N4)+RNBDFG(N6,N5,N4)
      XHGDFG(N6,N5,N4)=XHGDFG(N6,N5,N4)+RHGDFG(N6,N5,N4)
      ELSE
      RCODFG(N6,N5,N4)=0.0
      RCHDFG(N6,N5,N4)=0.0
      ROXDFG(N6,N5,N4)=0.0
      RNGDFG(N6,N5,N4)=0.0
      RN2DFG(N6,N5,N4)=0.0
      RN3DFG(N6,N5,N4)=0.0
      RNBDFG(N6,N5,N4)=0.0
      RHGDFG(N6,N5,N4)=0.0
      ENDIF
      ENDIF
      ELSEIF(N.NE.3)THEN
      DCO2G(N,N6,N5,N4)=0.0
      DCH4G(N,N6,N5,N4)=0.0
      DOXYG(N,N6,N5,N4)=0.0
      DZ2GG(N,N6,N5,N4)=0.0
      DZ2OG(N,N6,N5,N4)=0.0
      DNH3G(N,N6,N5,N4)=0.0
      DH2GG(N,N6,N5,N4)=0.0
      DO 9750 K=0,4
      ROCFLS(K,N,N6,N5,N4)=0.0
      RONFLS(K,N,N6,N5,N4)=0.0
      ROPFLS(K,N,N6,N5,N4)=0.0
      ROAFLS(K,N,N6,N5,N4)=0.0
      ROCFHS(K,N,N6,N5,N4)=0.0
      RONFHS(K,N,N6,N5,N4)=0.0
      ROPFHS(K,N,N6,N5,N4)=0.0
      ROAFHS(K,N,N6,N5,N4)=0.0
9750  CONTINUE
      RCOFLS(N,N6,N5,N4)=0.0
      RCHFLS(N,N6,N5,N4)=0.0
      ROXFLS(N,N6,N5,N4)=0.0
      RNGFLS(N,N6,N5,N4)=0.0
      RN2FLS(N,N6,N5,N4)=0.0
      RHGFLS(N,N6,N5,N4)=0.0
      RN4FLW(N,N6,N5,N4)=0.0
      RN3FLW(N,N6,N5,N4)=0.0
      RNOFLW(N,N6,N5,N4)=0.0
      RNXFLS(N,N6,N5,N4)=0.0
      RH1PFS(N,N6,N5,N4)=0.0
      RH2PFS(N,N6,N5,N4)=0.0
      RN4FLB(N,N6,N5,N4)=0.0
      RN3FLB(N,N6,N5,N4)=0.0
      RNOFLB(N,N6,N5,N4)=0.0
      RNXFLB(N,N6,N5,N4)=0.0
      RH2BFB(N,N6,N5,N4)=0.0
      RCOFHS(N,N6,N5,N4)=0.0
      RCHFHS(N,N6,N5,N4)=0.0
      ROXFHS(N,N6,N5,N4)=0.0
      RNGFHS(N,N6,N5,N4)=0.0
      RN2FHS(N,N6,N5,N4)=0.0
      RHGFHS(N,N6,N5,N4)=0.0
      RN4FHW(N,N6,N5,N4)=0.0
      RN3FHW(N,N6,N5,N4)=0.0
      RNOFHW(N,N6,N5,N4)=0.0
      RNXFHS(N,N6,N5,N4)=0.0
      RH1PHS(N,N6,N5,N4)=0.0
      RH2PHS(N,N6,N5,N4)=0.0
      RN4FHB(N,N6,N5,N4)=0.0
      RN3FHB(N,N6,N5,N4)=0.0
      RNOFHB(N,N6,N5,N4)=0.0
      RNXFHB(N,N6,N5,N4)=0.0
      RH1BHB(N,N6,N5,N4)=0.0
      RH2BHB(N,N6,N5,N4)=0.0
      RCOFLG(N,N6,N5,N4)=0.0
      RCHFLG(N,N6,N5,N4)=0.0
      ROXFLG(N,N6,N5,N4)=0.0
      RNGFLG(N,N6,N5,N4)=0.0
      RN2FLG(N,N6,N5,N4)=0.0
      RN3FLG(N,N6,N5,N4)=0.0
      RHGFLG(N,N6,N5,N4)=0.0
      ENDIF
      ELSE
      DCO2G(N,N3,N2,N1)=0.0
      DCH4G(N,N3,N2,N1)=0.0
      DOXYG(N,N3,N2,N1)=0.0
      DZ2GG(N,N3,N2,N1)=0.0
      DZ2OG(N,N3,N2,N1)=0.0
      DNH3G(N,N3,N2,N1)=0.0
      DH2GG(N,N3,N2,N1)=0.0
      DO 9751 K=0,4
      ROCFLS(K,N,N3,N2,N1)=0.0
      RONFLS(K,N,N3,N2,N1)=0.0
      ROPFLS(K,N,N3,N2,N1)=0.0
      ROAFLS(K,N,N3,N2,N1)=0.0
      ROCFHS(K,N,N3,N2,N1)=0.0
      RONFHS(K,N,N3,N2,N1)=0.0
      ROPFHS(K,N,N3,N2,N1)=0.0
      ROAFHS(K,N,N3,N2,N1)=0.0
9751  CONTINUE
      RCOFLS(N,N3,N2,N1)=0.0
      RCHFLS(N,N3,N2,N1)=0.0
      ROXFLS(N,N3,N2,N1)=0.0
      RNGFLS(N,N3,N2,N1)=0.0
      RN2FLS(N,N3,N2,N1)=0.0
      RHGFLS(N,N3,N2,N1)=0.0
      RN4FLW(N,N3,N2,N1)=0.0
      RN3FLW(N,N3,N2,N1)=0.0
      RNOFLW(N,N3,N2,N1)=0.0
      RNXFLS(N,N3,N2,N1)=0.0
      RH1PFS(N,N3,N2,N1)=0.0
      RH2PFS(N,N3,N2,N1)=0.0
      RN4FLB(N,N3,N2,N1)=0.0
      RN3FLB(N,N3,N2,N1)=0.0
      RNOFLB(N,N3,N2,N1)=0.0
      RNXFLB(N,N3,N2,N1)=0.0
      RH2BFB(N,N3,N2,N1)=0.0
      RCOFHS(N,N3,N2,N1)=0.0
      RCHFHS(N,N3,N2,N1)=0.0
      ROXFHS(N,N3,N2,N1)=0.0
      RNGFHS(N,N3,N2,N1)=0.0
      RN2FHS(N,N3,N2,N1)=0.0
      RHGFHS(N,N3,N2,N1)=0.0
      RN4FHW(N,N3,N2,N1)=0.0
      RN3FHW(N,N3,N2,N1)=0.0
      RNOFHW(N,N3,N2,N1)=0.0
      RNXFHS(N,N3,N2,N1)=0.0
      RH1PHS(N,N3,N2,N1)=0.0
      RH2PHS(N,N3,N2,N1)=0.0
      RN4FHB(N,N3,N2,N1)=0.0
      RN3FHB(N,N3,N2,N1)=0.0
      RNOFHB(N,N3,N2,N1)=0.0
      RNXFHB(N,N3,N2,N1)=0.0
      RH1BHB(N,N3,N2,N1)=0.0
      RH2BHB(N,N3,N2,N1)=0.0
      RCOFLG(N,N3,N2,N1)=0.0
      RCHFLG(N,N3,N2,N1)=0.0
      ROXFLG(N,N3,N2,N1)=0.0
      RNGFLG(N,N3,N2,N1)=0.0
      RN2FLG(N,N3,N2,N1)=0.0
      RN3FLG(N,N3,N2,N1)=0.0
      RHGFLG(N,N3,N2,N1)=0.0
      ENDIF
120   CONTINUE
C
C     CHECK FOR BUBBLING IF THE SUM OF ALL GASEOUS EQUIVALENT
C     PARTIAL CONCENTRATIONS EXCEEDS ATMOSPHERIC PRESSURE
C
C     VOLWM=micropore water-filled porosity from watsub.f
C     VOLY=micropore volume
C     IFLGB=bubbling flag:0=enabled,1=disabled
C     S*L=solubility of gas in water from hour1.f
C
      IF(N3.GE.NUM(N2,N1).AND.M.NE.MX)THEN
      THETW1(N3,N2,N1)=AMAX1(0.0,VOLWM(M,N3,N2,N1)/VOLY(N3,N2,N1))
      IF(THETW1(N3,N2,N1).GT.THETY(N3,N2,N1).AND.IFLGB.EQ.0)THEN
      SCO2X=12.0*SCO2L(N3,N2,N1)
      SCH4X=12.0*SCH4L(N3,N2,N1)
      SOXYX=32.0*SOXYL(N3,N2,N1)
      SN2GX=28.0*SN2GL(N3,N2,N1)
      SN2OX=28.0*SN2OL(N3,N2,N1)
      SNH3X=14.0*SNH3L(N3,N2,N1)
      SH2GX=2.0*SH2GL(N3,N2,N1)
C
C     GASEOUS EQUIVALENT PARTIAL CONCENTRATIONS
C
C     V*G2=molar gas concentration
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C     R*DFS=gas exchange between atmosphere and soil surface water
C
      IF(N3.EQ.NU(N2,N1))THEN
      VCO2G2=(CO2S2(N3,N2,N1)+RCODFS(NY,NX))/SCO2X
      VCH4G2=(CH4S2(N3,N2,N1)+RCHDFS(NY,NX))/SCH4X
      VOXYG2=(OXYS2(N3,N2,N1)+ROXDFS(NY,NX))/SOXYX
      VZ2GG2=(Z2GS2(N3,N2,N1)+RNGDFS(NY,NX))/SN2GX
      VZ2OG2=(Z2OS2(N3,N2,N1)+RN2DFS(NY,NX))/SN2OX
      VNH3G2=(ZNH3S2(N3,N2,N1)+RN3DFS(NY,NX))/SNH3X
      VNHBG2=(ZNH3B2(N3,N2,N1)+RNBDFS(NY,NX))/SNH3X
      VH2GG2=(H2GS2(N3,N2,N1)+RHGDFS(NY,NX))/SH2GX
      ELSE
      VCO2G2=CO2S2(N3,N2,N1)/SCO2X
      VCH4G2=CH4S2(N3,N2,N1)/SCH4X
      VOXYG2=OXYS2(N3,N2,N1)/SOXYX
      VZ2GG2=Z2GS2(N3,N2,N1)/SN2GX
      VZ2OG2=Z2OS2(N3,N2,N1)/SN2OX
      VNH3G2=ZNH3S2(N3,N2,N1)/SNH3X
      VNHBG2=ZNH3B2(N3,N2,N1)/SNH3X
      VH2GG2=H2GS2(N3,N2,N1)/SH2GX
      ENDIF
C
C     GASEOUS EQUIVALENT ATMOSPHERIC CONCENTRATION
C
C     VTATM=molar gas concentration at atmospheric pressure
C     VTGAS=total molar gas concentration
C
      VTATM=AMAX1(0.0,1.2194E+04*VOLWM(M,N3,N2,N1)/TKS(N3,N2,N1))
      VTGAS=VCO2G2+VCH4G2+VOXYG2+VZ2GG2+VZ2OG2+VNH3G2+VNHBG2+VH2GG2
C
C     PROPORTIONAL REMOVAL OF EXCESS AQUEOUS GASES
C
C     R*BBL=bubble flux
C     gas code:*CO*=CO2,*CH*=CH4,*OX*=O2,*NG*=N2,*N2*=N2O,*N3*=NH3,*HG*=H2
C     V*G2=molar gas concentration
C
      IF(VTGAS.GT.VTATM)THEN
      DVTGAS=0.5*(VTATM-VTGAS)
      RCOBBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VCO2G2/VTGAS)*SCO2X
      RCHBBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VCH4G2/VTGAS)*SCH4X
      ROXBBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VOXYG2/VTGAS)*SOXYX
      RNGBBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VZ2GG2/VTGAS)*SN2GX
      RN2BBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VZ2OG2/VTGAS)*SN2OX
      RN3BBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VNH3G2/VTGAS)*SNH3X
      RNBBBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VNHBG2/VTGAS)*SNH3X
      RHGBBL(N3,N2,N1)=AMIN1(0.0,DVTGAS*VH2GG2/VTGAS)*SH2GX
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*BBL=hourly bubble flux
C
      XCOBBL(N3,N2,N1)=XCOBBL(N3,N2,N1)+RCOBBL(N3,N2,N1)
      XCHBBL(N3,N2,N1)=XCHBBL(N3,N2,N1)+RCHBBL(N3,N2,N1)
      XOXBBL(N3,N2,N1)=XOXBBL(N3,N2,N1)+ROXBBL(N3,N2,N1)
      XNGBBL(N3,N2,N1)=XNGBBL(N3,N2,N1)+RNGBBL(N3,N2,N1)
      XN2BBL(N3,N2,N1)=XN2BBL(N3,N2,N1)+RN2BBL(N3,N2,N1)
      XN3BBL(N3,N2,N1)=XN3BBL(N3,N2,N1)+RN3BBL(N3,N2,N1)
      XNBBBL(N3,N2,N1)=XNBBBL(N3,N2,N1)+RNBBBL(N3,N2,N1)
      XHGBBL(N3,N2,N1)=XHGBBL(N3,N2,N1)+RHGBBL(N3,N2,N1)
      ELSE
      RCOBBL(N3,N2,N1)=0.0
      RCHBBL(N3,N2,N1)=0.0
      ROXBBL(N3,N2,N1)=0.0
      RNGBBL(N3,N2,N1)=0.0
      RN2BBL(N3,N2,N1)=0.0
      RN3BBL(N3,N2,N1)=0.0
      RNBBBL(N3,N2,N1)=0.0
      RHGBBL(N3,N2,N1)=0.0
      ENDIF
      ELSE
      IFLGB=1
      RCOBBL(N3,N2,N1)=0.0
      RCHBBL(N3,N2,N1)=0.0
      ROXBBL(N3,N2,N1)=0.0
      RNGBBL(N3,N2,N1)=0.0
      RN2BBL(N3,N2,N1)=0.0
      RN3BBL(N3,N2,N1)=0.0
      RNBBBL(N3,N2,N1)=0.0
      RHGBBL(N3,N2,N1)=0.0
      ENDIF
C     IF(I.EQ.296)THEN
C     WRITE(*,6688)'RCOBBL',I,J,N1,N2,N3,M,MM,IFLGB
C    2,RCOBBL(N3,N2,N1),XCOBBL(N3,N2,N1),VTGAS,VTATM
C    2,DVTGAS,SCO2X,VCO2G2,VCH4G2,VOXYG2,VZ2GG2,VZ2OG2
C    3,VNH3G2,VNHBG2,VH2GG2
C    4,CO2S2(N3,N2,N1),VOLWM(M,N3,N2,N1)
C     WRITE(*,6688)'ROXBBL',I,J,N1,N2,N3,M,MM,IFLGB
C    2,ROXBBL(N3,N2,N1),XOXBBL(N3,N2,N1),VTGAS,VTATM
C    2,DVTGAS,SOXYX,VCO2G2,VCH4G2,VOXYG2,VZ2GG2,VZ2OG2
C    3,VNH3G2,VNHBG2,VH2GG2,SOXYL(N3,N2,N1)
C    4,OXYS2(N3,N2,N1),VOLWM(M,N3,N2,N1),TCS(N3,N2,N1)
6688  FORMAT(A8,8I4,20E12.4)
C     ENDIF
      ENDIF
125   CONTINUE
9890  CONTINUE
9895  CONTINUE
C
C     BOUNDARY SOLUTE AND GAS FLUXES
C
C     N3,N2,N1=L,NY,NX of source grid cell
C     M6,M5,M4=L,NY,NX of destination grid cell
C
      DO 9595 NX=NHW,NHE
      DO 9590 NY=NVN,NVS
      DO 9585 L=NU(NY,NX),NL(NY,NX)
      N1=NX
      N2=NY
      N3=L
C
C     LOCATE ALL EXTERNAL BOUNDARIES AND SET BOUNDARY CONDITIONS
C     ENTERED IN 'READS'
C
      DO 9580 N=1,3
      DO 9575 NN=1,2
      IF(N.EQ.1)THEN
      N4=NX+1
      N5=NY
      N4B=NX-1
      N5B=NY
      N6=L
      IF(NN.EQ.1)THEN
      IF(NX.EQ.NHE)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX+1
      M5=NY
      M6=L
      XN=-1.0
      RCHQF=RCHQE(M2,M1)
      RCHGFU=RCHGEU(M2,M1)
      RCHGFT=RCHGET(M2,M1)
      ELSE
      GO TO 9575
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      IF(NX.EQ.NHW)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY
      M6=L
      XN=1.0
      RCHQF=RCHQW(M5,M4)
      RCHGFU=RCHGWU(M5,M4)
      RCHGFT=RCHGWT(M5,M4)
      ELSE
      GO TO 9575
      ENDIF
      ENDIF
      ELSEIF(N.EQ.2)THEN
      N4=NX
      N5=NY+1
      N4B=NX
      N5B=NY-1
      N6=L
      IF(NN.EQ.1)THEN
      IF(NY.EQ.NVS)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY+1
      M6=L
      XN=-1.0
      RCHQF=RCHQS(M2,M1)
      RCHGFU=RCHGSU(M2,M1)
      RCHGFT=RCHGST(M2,M1)
      ELSE
      GO TO 9575
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      IF(NY.EQ.NVN)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY
      M6=L
      XN=1.0
      RCHQF=RCHQN(M5,M4)
      RCHGFU=RCHGNU(M5,M4)
      RCHGFT=RCHGNT(M5,M4)
      ELSE
      GO TO 9575
      ENDIF
      ENDIF
      ELSEIF(N.EQ.3)THEN
      N1=NX
      N2=NY
      N3=L
      N4=NX
      N5=NY
      N6=L+1
      IF(NN.EQ.1)THEN
      IF(L.EQ.NL(NY,NX))THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY
      M6=L+1
      XN=-1.0
      ELSE
      GO TO 9575
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      GO TO 9575
      ENDIF
      ENDIF
      IF(M.NE.MX)THEN
C
C     SURFACE SOLUTE TRANSPORT FROM BOUNDARY SURFACE
C     RUNOFF IN 'WATSUB' AND CONCENTRATIONS IN THE SURFACE SOIL LAYER
C
C     QRM =runoff from watsub.f
C     RQR*=solute in runoff
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
c
      IF(L.EQ.NUM(M2,M1).AND.N.NE.3)THEN
      IF(IRCHG(NN,N,N2,N1).EQ.0.OR.RCHQF.EQ.0.0
     2.OR.QRM(M,N2,N1).LE.ZEROS(N2,N1))THEN
      DO 9542 K=0,4
      RQROC(K,N,NN,M5,M4)=0.0
      RQRON(K,N,NN,M5,M4)=0.0
      RQROP(K,N,NN,M5,M4)=0.0
      RQROA(K,N,NN,M5,M4)=0.0
9542  CONTINUE
      RQRCOS(N,NN,M5,M4)=0.0
      RQRCHS(N,NN,M5,M4)=0.0
      RQROXS(N,NN,M5,M4)=0.0
      RQRNGS(N,NN,M5,M4)=0.0
      RQRN2S(N,NN,M5,M4)=0.0
      RQRHGS(N,NN,M5,M4)=0.0
      RQRNH4(N,NN,M5,M4)=0.0
      RQRNH3(N,NN,M5,M4)=0.0
      RQRNO3(N,NN,M5,M4)=0.0
      RQRNO2(N,NN,M5,M4)=0.0
      RQRH1P(N,NN,M5,M4)=0.0
      RQRH2P(N,NN,M5,M4)=0.0
      ELSE
C
C     SOLUTE LOSS FROM RUNOFF DEPENDING ON ASPECT
C     AND BOUNDARY CONDITIONS SET IN SITE FILE
C
      IF((NN.EQ.1.AND.QRMN(M,N,NN,M5,M4).GT.ZEROS(N2,N1))
     2.OR.(NN.EQ.2.AND.QRMN(M,N,NN,M5,M4).LT.ZEROS(N2,N1)))THEN
      FQRM=QRMN(M,N,NN,M5,M4)/QRM(M,N2,N1)
      DO 9540 K=0,4
      RQROC(K,N,NN,M5,M4)=RQROC0(K,N2,N1)*FQRM
      RQRON(K,N,NN,M5,M4)=RQRON0(K,N2,N1)*FQRM
      RQROP(K,N,NN,M5,M4)=RQROP0(K,N2,N1)*FQRM
      RQROA(K,N,NN,M5,M4)=RQROA0(K,N2,N1)*FQRM
9540  CONTINUE
      RQRCOS(N,NN,M5,M4)=RQRCOS0(N2,N1)*FQRM
      RQRCHS(N,NN,M5,M4)=RQRCHS0(N2,N1)*FQRM
      RQROXS(N,NN,M5,M4)=RQROXS0(N2,N1)*FQRM
      RQRNGS(N,NN,M5,M4)=RQRNGS0(N2,N1)*FQRM
      RQRN2S(N,NN,M5,M4)=RQRN2S0(N2,N1)*FQRM
      RQRHGS(N,NN,M5,M4)=RQRHGS0(N2,N1)*FQRM
      RQRNH4(N,NN,M5,M4)=RQRNH40(N2,N1)*FQRM
      RQRNH3(N,NN,M5,M4)=RQRNH30(N2,N1)*FQRM
      RQRNO3(N,NN,M5,M4)=RQRNO30(N2,N1)*FQRM
      RQRNO2(N,NN,M5,M4)=RQRNO20(N2,N1)*FQRM
      RQRH1P(N,NN,M5,M4)=RQRH1P0(N2,N1)*FQRM
      RQRH2P(N,NN,M5,M4)=RQRH2P0(N2,N1)*FQRM
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*QRS=hourly solute in runoff
C     RQR*=solute in runoff
C
      DO 9565 K=0,4
      XOCQRS(K,N,NN,M5,M4)=XOCQRS(K,N,NN,M5,M4)+RQROC(K,N,NN,M5,M4)
      XONQRS(K,N,NN,M5,M4)=XONQRS(K,N,NN,M5,M4)+RQRON(K,N,NN,M5,M4)
      XOPQRS(K,N,NN,M5,M4)=XOPQRS(K,N,NN,M5,M4)+RQROP(K,N,NN,M5,M4)
      XOAQRS(K,N,NN,M5,M4)=XOAQRS(K,N,NN,M5,M4)+RQROA(K,N,NN,M5,M4)
9565  CONTINUE
      XCOQRS(N,NN,M5,M4)=XCOQRS(N,NN,M5,M4)+RQRCOS(N,NN,M5,M4)
      XCHQRS(N,NN,M5,M4)=XCHQRS(N,NN,M5,M4)+RQRCHS(N,NN,M5,M4)
      XOXQRS(N,NN,M5,M4)=XOXQRS(N,NN,M5,M4)+RQROXS(N,NN,M5,M4)
      XNGQRS(N,NN,M5,M4)=XNGQRS(N,NN,M5,M4)+RQRNGS(N,NN,M5,M4)
      XN2QRS(N,NN,M5,M4)=XN2QRS(N,NN,M5,M4)+RQRN2S(N,NN,M5,M4)
      XHGQRS(N,NN,M5,M4)=XHGQRS(N,NN,M5,M4)+RQRHGS(N,NN,M5,M4)
      XN4QRW(N,NN,M5,M4)=XN4QRW(N,NN,M5,M4)+RQRNH4(N,NN,M5,M4)
      XN3QRW(N,NN,M5,M4)=XN3QRW(N,NN,M5,M4)+RQRNH3(N,NN,M5,M4)
      XNOQRW(N,NN,M5,M4)=XNOQRW(N,NN,M5,M4)+RQRNO3(N,NN,M5,M4)
      XNXQRS(N,NN,M5,M4)=XNXQRS(N,NN,M5,M4)+RQRNO2(N,NN,M5,M4)
      XP1QRW(N,NN,M5,M4)=XP1QRW(N,NN,M5,M4)+RQRH1P(N,NN,M5,M4)
      XP4QRW(N,NN,M5,M4)=XP4QRW(N,NN,M5,M4)+RQRH2P(N,NN,M5,M4)
C
C     SOLUTE GAIN FROM RUNON DEPENDING ON ASPECT
C     AND BOUNDARY CONDITIONS SET IN SITE FILE
C
      ELSEIF((NN.EQ.2.AND.QRMN(M,N,NN,M5,M4).GT.ZEROS(N2,N1))
     2.OR.(NN.EQ.1.AND.QRMN(M,N,NN,M5,M4).LT.ZEROS(N2,N1)))THEN
      DO 9629 K=0,4
      RQROC(K,N,NN,M5,M4)=0.0
      RQRON(K,N,NN,M5,M4)=0.0
      RQROP(K,N,NN,M5,M4)=0.0
      RQROA(K,N,NN,M5,M4)=0.0
9629  CONTINUE
      RQRCOS(N,NN,M5,M4)=QRMN(M,N,NN,M5,M4)*CCOU
      RQRCHS(N,NN,M5,M4)=QRMN(M,N,NN,M5,M4)*CCHU
      RQROXS(N,NN,M5,M4)=QRMN(M,N,NN,M5,M4)*COXU
      RQRNGS(N,NN,M5,M4)=QRMN(M,N,NN,M5,M4)*CNNU
      RQRN2S(N,NN,M5,M4)=QRMN(M,N,NN,M5,M4)*CN2U
      RQRHGS(N,NN,M5,M4)=0.0
      RQRNH4(N,NN,M5,M4)=0.0
      RQRNH3(N,NN,M5,M4)=0.0
      RQRNO3(N,NN,M5,M4)=0.0
      RQRNO2(N,NN,M5,M4)=0.0
      RQRH1P(N,NN,M5,M4)=0.0
      RQRH2P(N,NN,M5,M4)=0.0
      XCOQRS(N,NN,M5,M4)=XCOQRS(N,NN,M5,M4)+RQRCOS(N,NN,M5,M4)
      XCHQRS(N,NN,M5,M4)=XCHQRS(N,NN,M5,M4)+RQRCHS(N,NN,M5,M4)
      XOXQRS(N,NN,M5,M4)=XOXQRS(N,NN,M5,M4)+RQROXS(N,NN,M5,M4)
      XNGQRS(N,NN,M5,M4)=XNGQRS(N,NN,M5,M4)+RQRNGS(N,NN,M5,M4)
      XN2QRS(N,NN,M5,M4)=XN2QRS(N,NN,M5,M4)+RQRN2S(N,NN,M5,M4)
      ELSE
      DO 9627 K=0,4
      RQROC(K,N,NN,M5,M4)=0.0
      RQRON(K,N,NN,M5,M4)=0.0
      RQROP(K,N,NN,M5,M4)=0.0
      RQROA(K,N,NN,M5,M4)=0.0
9627  CONTINUE
      RQRCOS(N,NN,M5,M4)=0.0
      RQRCHS(N,NN,M5,M4)=0.0
      RQROXS(N,NN,M5,M4)=0.0
      RQRNGS(N,NN,M5,M4)=0.0
      RQRN2S(N,NN,M5,M4)=0.0
      RQRHGS(N,NN,M5,M4)=0.0
      RQRNH4(N,NN,M5,M4)=0.0
      RQRNH3(N,NN,M5,M4)=0.0
      RQRNO3(N,NN,M5,M4)=0.0
      RQRNO2(N,NN,M5,M4)=0.0
      RQRH1P(N,NN,M5,M4)=0.0
      RQRH2P(N,NN,M5,M4)=0.0
      ENDIF
C     WRITE(*,1114)'RQR',I,J,M,N1,N2,N4,N5,M4,M5,N,NN
C    2,QRM(M,N2,N1),QRMN(M,N,NN,M5,M4)
C    3,RQROC0(1,N2,N1),RQROC(1,N,NN,M5,M4),XOCQRS(1,N,NN,M5,M4)
C    3,RQROP0(1,N2,N1),RQROP(1,N,NN,M5,M4),XOPQRS(1,N,NN,M5,M4)
1114  FORMAT(A8,11I4,30E12.4)
      ENDIF
C
C     BOUNDARY SNOW FLUX
C
      IF(NN.EQ.1)THEN
      RQSCOS(N,M5,M4)=0.0
      RQSCHS(N,M5,M4)=0.0
      RQSOXS(N,M5,M4)=0.0
      RQSNGS(N,M5,M4)=0.0
      RQSN2S(N,M5,M4)=0.0
      RQSNH4(N,M5,M4)=0.0
      RQSNH3(N,M5,M4)=0.0
      RQSNO3(N,M5,M4)=0.0
      RQSH1P(N,M5,M4)=0.0
      RQSH2P(N,M5,M4)=0.0
      ENDIF
      ENDIF
C
C     SOLUTE LOSS WITH SUBSURFACE MICROPORE WATER LOSS
C
C     FLWM=water flux through soil micropore from watsub.f
C     VOLWM=micropore water-filled porosity from watsub.f
C     R*FLS=convective solute flux through micropores
C     R*FLW,R*FLB=convective solute flux through micropores in non-band,band
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C
      IF(VOLX(N3,N2,N1).GT.ZEROS2(N2,N1))THEN
      IF(NCN(M2,M1).NE.3.OR.N.EQ.3)THEN
      IF(NN.EQ.1.AND.FLWM(M,N,M6,M5,M4).GT.0.0
     2.OR.NN.EQ.2.AND.FLWM(M,N,M6,M5,M4).LT.0.0)THEN
      IF(VOLWM(M,M3,M2,M1).GT.ZEROS2(M2,M1))THEN
      VFLW=AMAX1(-VFLWX,AMIN1(VFLWX,FLWM(M,N,M6,M5,M4)
     2/VOLWM(M,M3,M2,M1)))
      ELSE
      VFLW=0.0
      ENDIF
      DO 9520 K=0,4
      ROCFLS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQC2(K,M3,M2,M1))
      RONFLS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQN2(K,M3,M2,M1))
      ROPFLS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQP2(K,M3,M2,M1))
      ROAFLS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQA2(K,M3,M2,M1))
9520  CONTINUE
      RCOFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,CO2S2(M3,M2,M1))
      RCHFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,CH4S2(M3,M2,M1))
      ROXFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,OXYS2(M3,M2,M1))
      RNGFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,Z2GS2(M3,M2,M1))
      RN2FLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,Z2OS2(M3,M2,M1))
      RHGFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H2GS2(M3,M2,M1))
      RN4FLW(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNH4S2(M3,M2,M1))
     2*VLNH4(M3,M2,M1)
      RN3FLW(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNH3S2(M3,M2,M1))
     2*VLNH4(M3,M2,M1)
      RNOFLW(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNO3S2(M3,M2,M1))
     2*VLNO3(M3,M2,M1)
      RNXFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNO2S2(M3,M2,M1))
     2*VLNO3(M3,M2,M1)
      RH1PFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H1PO42(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RH2PFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H2PO42(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RN4FLB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNH4B2(M3,M2,M1))
     2*VLNHB(M3,M2,M1)
      RN3FLB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNH3B2(M3,M2,M1))
     2*VLNHB(M3,M2,M1)
      RNOFLB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNO3B2(M3,M2,M1))
     2*VLNOB(M3,M2,M1)
      RNXFLB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNO2B2(M3,M2,M1))
     2*VLNOB(M3,M2,M1)
      RH1BFB(N,M6,M5,M4)=VFLW*AMAX1(0.0,H1POB2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RH2BFB(N,M6,M5,M4)=VFLW*AMAX1(0.0,H2POB2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
C     IF(J.EQ.15)THEN
C     WRITE(*,8765)'LEACH',I,J,M,M6,M5,M4,RNOFLW(N,M6,M5,M4)
C    2,VFLW,ZNO3S2(M3,M2,M1),VLNO3(M3,M2,M1),FLWM(M,N,M6,M5,M4)
C    3,VOLWM(M,M3,M2,M1)
8765  FORMAT(A8,6I4,20E12.4)
C     ENDIF
C
C     SOLUTE GAIN WITH SUBSURFACE MICROPORE WATER GAIN
C
      ELSE
      DO 9515 K=0,4
      ROCFLS(K,N,M6,M5,M4)=0.0
      RONFLS(K,N,M6,M5,M4)=0.0
      ROPFLS(K,N,M6,M5,M4)=0.0
      ROAFLS(K,N,M6,M5,M4)=0.0
9515  CONTINUE
      RCOFLS(N,M6,M5,M4)=0.0
      RCHFLS(N,M6,M5,M4)=0.0
      ROXFLS(N,M6,M5,M4)=0.0
      RNGFLS(N,M6,M5,M4)=0.0
      RN2FLS(N,M6,M5,M4)=0.0
      RHGFLS(N,M6,M5,M4)=0.0
      RN4FLW(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CN4U(M3,M2,M1)
     2*VLNH4(M3,M2,M1)
      RN3FLW(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CN3U(M3,M2,M1)
     2*VLNH4(M3,M2,M1)
      RNOFLW(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CNOU(M3,M2,M1)
     2*VLNO3(M3,M2,M1)
      RNXFLS(N,M6,M5,M4)=0.0
      RH1PFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CH1PU(M3,M2,M1)
     2*VLPO4(M3,M2,M1)
      RH2PFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CH2PU(M3,M2,M1)
     2*VLPO4(M3,M2,M1)
      RN4FLB(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CN4U(M3,M2,M1)
     2*VLNHB(M3,M2,M1)
      RN3FLB(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CN3U(M3,M2,M1)
     2*VLNHB(M3,M2,M1)
      RNOFLB(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CNOU(M3,M2,M1)
     2*VLNOB(M3,M2,M1)
      RNXFLB(N,M6,M5,M4)=0.0
      RH1BFB(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CH1PU(M3,M2,M1)
     2*VLPOB(M3,M2,M1)
      RH2BFB(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CH2PU(M3,M2,M1)
     2*VLPOB(M3,M2,M1)
      ENDIF
C     IF(M.NE.MX.AND.I.GE.180.AND.I.LE.200)THEN
C     WRITE(*,1115)'LEACHX',I,J,M1,M2,M3,M,MM,N
C    1,RCOFLS(N,M6,M5,M4),VFLW,CO2S2(M3,M2,M1)
C    2,RH2PFS(N,M6,M5,M4),(ROPFLS(K,N,M6,M5,M4),K=1,4)
C    4,VOLWM(M,M3,M2,M1),FLWM(M,N,M6,M5,M4),VFLW
1115  FORMAT(A8,8I4,20E12.4)
C     ENDIF
C
C     SOLUTE LOSS WITH SUBSURFACE MACROPORE WATER LOSS
C
C     FLWHM=water flux through soil macropore from watsub.f
C     VOLWHM=macropore water-filled porosity from watsub.f
C     RFH*S=solute diffusive flux through macropore
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C
      IF(NN.EQ.1.AND.FLWHM(M,N,M6,M5,M4).GT.0.0
     2.OR.NN.EQ.2.AND.FLWHM(M,N,M6,M5,M4).LT.0.0)THEN
      IF(VOLWHM(M,M3,M2,M1).GT.ZEROS2(M2,M1))THEN
      VFLW=AMAX1(-VFLWX,AMIN1(VFLWX,FLWHM(M,N,M6,M5,M4)
     2/VOLWHM(M,M3,M2,M1)))
      ELSE
      VFLW=0.0
      ENDIF
      DO 9535 K=0,4
      ROCFHS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQCH2(K,M3,M2,M1))
      RONFHS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQNH2(K,M3,M2,M1))
      ROPFHS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQPH2(K,M3,M2,M1))
      ROAFHS(K,N,M6,M5,M4)=VFLW*AMAX1(0.0,OQAH2(K,M3,M2,M1))
9535  CONTINUE
      RCOFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,CO2SH2(M3,M2,M1))
      RCHFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,CH4SH2(M3,M2,M1))
      ROXFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,OXYSH2(M3,M2,M1))
      RNGFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,Z2GSH2(M3,M2,M1))
      RN2FHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,Z2OSH2(M3,M2,M1))
      RHGFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H2GSH2(M3,M2,M1))
      RN4FHW(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNH4H2(M3,M2,M1))
     2*VLNH4(M3,M2,M1)
      RN3FHW(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNH3H2(M3,M2,M1))
     2*VLNH4(M3,M2,M1)
      RNOFHW(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNO3H2(M3,M2,M1))
     2*VLNO3(M3,M2,M1)
      RNXFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNO2H2(M3,M2,M1))
     2*VLNO3(M3,M2,M1)
      RH1PHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H1P4H2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RH2PHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H2P4H2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RN4FHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZN4BH2(M3,M2,M1))
     2*VLNHB(M3,M2,M1)
      RN3FHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZN3BH2(M3,M2,M1))
     2*VLNHB(M3,M2,M1)
      RNOFHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNOBH2(M3,M2,M1))
     2*VLNOB(M3,M2,M1)
      RNXFHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZN2BH2(M3,M2,M1))
     2*VLNOB(M3,M2,M1)
      RH1BHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,H1PBH2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RH2BHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,H2PBH2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
C
C     NO SOLUTE GAIN IN SUBSURFACE MACROPORES
C
      ELSE
      DO 9530 K=0,4
      ROCFHS(K,N,M6,M5,M4)=0.0
      RONFHS(K,N,M6,M5,M4)=0.0
      ROPFHS(K,N,M6,M5,M4)=0.0
      ROAFHS(K,N,M6,M5,M4)=0.0
9530  CONTINUE
      RCOFHS(N,M6,M5,M4)=0.0
      RCHFHS(N,M6,M5,M4)=0.0
      ROXFHS(N,M6,M5,M4)=0.0
      RNGFHS(N,M6,M5,M4)=0.0
      RN2FHS(N,M6,M5,M4)=0.0
      RN4FHW(N,M6,M5,M4)=0.0
      RHGFHS(N,M6,M5,M4)=0.0
      RN3FHW(N,M6,M5,M4)=0.0
      RNOFHW(N,M6,M5,M4)=0.0
      RNXFHS(N,M6,M5,M4)=0.0
      RH1PHS(N,M6,M5,M4)=0.0
      RH2PHS(N,M6,M5,M4)=0.0
      RN4FHB(N,M6,M5,M4)=0.0
      RN3FHB(N,M6,M5,M4)=0.0
      RNOFHB(N,M6,M5,M4)=0.0
      RNXFHB(N,M6,M5,M4)=0.0
      RH1BHB(N,M6,M5,M4)=0.0
      RH2BHB(N,M6,M5,M4)=0.0
      ENDIF
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*FLS,X*FLW,X*FLB=hourly solute flux in non-band,band micropores
C     X*FHS,X*FHW,X*FHB=hourly solute flux in non-band,band macropores
C     R*FLS,R*FLW,R*FLB=solute flux in non-band,band micropores
C     R*FHS,R*FHW,R*FHB=solute flux in non-band,band macropores
C
      DO 9555 K=0,4
      XOCFLS(K,N,M6,M5,M4)=XOCFLS(K,N,M6,M5,M4)+ROCFLS(K,N,M6,M5,M4)
      XONFLS(K,N,M6,M5,M4)=XONFLS(K,N,M6,M5,M4)+RONFLS(K,N,M6,M5,M4)
      XOPFLS(K,N,M6,M5,M4)=XOPFLS(K,N,M6,M5,M4)+ROPFLS(K,N,M6,M5,M4)
      XOAFLS(K,N,M6,M5,M4)=XOAFLS(K,N,M6,M5,M4)+ROAFLS(K,N,M6,M5,M4)
      XOCFHS(K,N,M6,M5,M4)=XOCFHS(K,N,M6,M5,M4)+ROCFHS(K,N,M6,M5,M4)
      XONFHS(K,N,M6,M5,M4)=XONFHS(K,N,M6,M5,M4)+RONFHS(K,N,M6,M5,M4)
      XOPFHS(K,N,M6,M5,M4)=XOPFHS(K,N,M6,M5,M4)+ROPFHS(K,N,M6,M5,M4)
      XOAFHS(K,N,M6,M5,M4)=XOAFHS(K,N,M6,M5,M4)+ROAFHS(K,N,M6,M5,M4)
9555  CONTINUE
      XCOFLS(N,M6,M5,M4)=XCOFLS(N,M6,M5,M4)+RCOFLS(N,M6,M5,M4)
      XCHFLS(N,M6,M5,M4)=XCHFLS(N,M6,M5,M4)+RCHFLS(N,M6,M5,M4)
      XOXFLS(N,M6,M5,M4)=XOXFLS(N,M6,M5,M4)+ROXFLS(N,M6,M5,M4)
      XNGFLS(N,M6,M5,M4)=XNGFLS(N,M6,M5,M4)+RNGFLS(N,M6,M5,M4)
      XN2FLS(N,M6,M5,M4)=XN2FLS(N,M6,M5,M4)+RN2FLS(N,M6,M5,M4)
      XHGFLS(N,M6,M5,M4)=XHGFLS(N,M6,M5,M4)+RHGFLS(N,M6,M5,M4)
      XN4FLW(N,M6,M5,M4)=XN4FLW(N,M6,M5,M4)+RN4FLW(N,M6,M5,M4)
      XN3FLW(N,M6,M5,M4)=XN3FLW(N,M6,M5,M4)+RN3FLW(N,M6,M5,M4)
      XNOFLW(N,M6,M5,M4)=XNOFLW(N,M6,M5,M4)+RNOFLW(N,M6,M5,M4)
      XNXFLS(N,M6,M5,M4)=XNXFLS(N,M6,M5,M4)+RNXFLS(N,M6,M5,M4)
      XH1PFS(N,M6,M5,M4)=XH1PFS(N,M6,M5,M4)+RH1PFS(N,M6,M5,M4)
      XH2PFS(N,M6,M5,M4)=XH2PFS(N,M6,M5,M4)+RH2PFS(N,M6,M5,M4)
      XN4FLB(N,M6,M5,M4)=XN4FLB(N,M6,M5,M4)+RN4FLB(N,M6,M5,M4)
      XN3FLB(N,M6,M5,M4)=XN3FLB(N,M6,M5,M4)+RN3FLB(N,M6,M5,M4)
      XNOFLB(N,M6,M5,M4)=XNOFLB(N,M6,M5,M4)+RNOFLB(N,M6,M5,M4)
      XNXFLB(N,M6,M5,M4)=XNXFLB(N,M6,M5,M4)+RNXFLB(N,M6,M5,M4)
      XH2BFB(N,M6,M5,M4)=XH2BFB(N,M6,M5,M4)+RH2BFB(N,M6,M5,M4)
      XCOFHS(N,M6,M5,M4)=XCOFHS(N,M6,M5,M4)+RCOFHS(N,M6,M5,M4)
      XCHFHS(N,M6,M5,M4)=XCHFHS(N,M6,M5,M4)+RCHFHS(N,M6,M5,M4)
      XOXFHS(N,M6,M5,M4)=XOXFHS(N,M6,M5,M4)+ROXFHS(N,M6,M5,M4)
      XNGFHS(N,M6,M5,M4)=XNGFHS(N,M6,M5,M4)+RNGFHS(N,M6,M5,M4)
      XN2FHS(N,M6,M5,M4)=XN2FHS(N,M6,M5,M4)+RN2FHS(N,M6,M5,M4)
      XHGFHS(N,M6,M5,M4)=XHGFHS(N,M6,M5,M4)+RHGFHS(N,M6,M5,M4)
      XN4FHW(N,M6,M5,M4)=XN4FHW(N,M6,M5,M4)+RN4FHW(N,M6,M5,M4)
      XN3FHW(N,M6,M5,M4)=XN3FHW(N,M6,M5,M4)+RN3FHW(N,M6,M5,M4)
      XNOFHW(N,M6,M5,M4)=XNOFHW(N,M6,M5,M4)+RNOFHW(N,M6,M5,M4)
      XNXFHS(N,M6,M5,M4)=XNXFHS(N,M6,M5,M4)+RNXFHS(N,M6,M5,M4)
      XH1PHS(N,M6,M5,M4)=XH1PHS(N,M6,M5,M4)+RH1PHS(N,M6,M5,M4)
      XH2PHS(N,M6,M5,M4)=XH2PHS(N,M6,M5,M4)+RH2PHS(N,M6,M5,M4)
      XN4FHB(N,M6,M5,M4)=XN4FHB(N,M6,M5,M4)+RN4FHB(N,M6,M5,M4)
      XN3FHB(N,M6,M5,M4)=XN3FHB(N,M6,M5,M4)+RN3FHB(N,M6,M5,M4)
      XNOFHB(N,M6,M5,M4)=XNOFHB(N,M6,M5,M4)+RNOFHB(N,M6,M5,M4)
      XNXFHB(N,M6,M5,M4)=XNXFHB(N,M6,M5,M4)+RNXFHB(N,M6,M5,M4)
      XH1BHB(N,M6,M5,M4)=XH1BHB(N,M6,M5,M4)+RH1BHB(N,M6,M5,M4)
      XH2BHB(N,M6,M5,M4)=XH2BHB(N,M6,M5,M4)+RH2BHB(N,M6,M5,M4)
      ENDIF
      ENDIF
C
C     GASOUS LOSS WITH SUBSURFACE MICROPORE WATER GAIN
C
C     FLWM,FLWHM=micropore,macropore water flux from watsub.f
C     XNPT=1/number of cycles NPH-1 for gas flux calculations
C     VOLPM=air-filled porosity
C     R*FLG=convective gas flux
C     X*FLG=convective gas flux
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C
      FLGM=(FLWM(M,N,M6,M5,M4)+FLWHM(M,N,M6,M5,M4))*XNPT
      IF(NN.EQ.1.AND.FLGM.LT.0.0
     2.OR.NN.EQ.2.AND.FLGM.GT.0.0)THEN
      IF(VOLPM(M,M3,M2,M1).GT.ZEROS2(M2,M1))THEN
      VFLW=-AMAX1(-VFLWX,AMIN1(VFLWX,FLGM
     2/VOLPM(M,M3,M2,M1)))
      ELSE
      VFLW=0.0
      ENDIF
      RCOFLG(N,M6,M5,M4)=VFLW*AMAX1(0.0,CO2G2(M3,M2,M1))
      RCHFLG(N,M6,M5,M4)=VFLW*AMAX1(0.0,CH4G2(M3,M2,M1))
      ROXFLG(N,M6,M5,M4)=VFLW*AMAX1(0.0,OXYG2(M3,M2,M1))
      RNGFLG(N,M6,M5,M4)=VFLW*AMAX1(0.0,Z2GG2(M3,M2,M1))
      RN2FLG(N,M6,M5,M4)=VFLW*AMAX1(0.0,Z2OG2(M3,M2,M1))
      RN3FLG(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZN3G2(M3,M2,M1))
      RHGFLG(N,M6,M5,M4)=VFLW*AMAX1(0.0,H2GG2(M3,M2,M1))
C
C     HOURLY GAS FLUX FOR USE IN REDIST.F
C
C     X*FLG=hourly convective gas flux
C
      XCOFLG(N,M6,M5,M4)=XCOFLG(N,M6,M5,M4)+RCOFLG(N,M6,M5,M4)
      XCHFLG(N,M6,M5,M4)=XCHFLG(N,M6,M5,M4)+RCHFLG(N,M6,M5,M4)
      XOXFLG(N,M6,M5,M4)=XOXFLG(N,M6,M5,M4)+ROXFLG(N,M6,M5,M4)
      XNGFLG(N,M6,M5,M4)=XNGFLG(N,M6,M5,M4)+RNGFLG(N,M6,M5,M4)
      XN2FLG(N,M6,M5,M4)=XN2FLG(N,M6,M5,M4)+RN2FLG(N,M6,M5,M4)
      XN3FLG(N,M6,M5,M4)=XN3FLG(N,M6,M5,M4)+RN3FLG(N,M6,M5,M4)
      XHGFLG(N,M6,M5,M4)=XHGFLG(N,M6,M5,M4)+RHGFLG(N,M6,M5,M4)
C     IF(FLGM.NE.0.0)THEN
C     WRITE(*,8766)'GAS OUT',I,J,M,MM,N,NN,M3,M2,M1,M6,M5,M4
C    2,VFLW,VOLPM(M,M3,M2,M1),ROXFLG(N,M6,M5,M4)
C    3,OXYG2(M3,M2,M1),FLGM,FLWM(M,N,M6,M5,M4)
C    4,FLWHM(M,N,M6,M5,M4)
C     ENDIF
      ELSE
      RCOFLG(N,M6,M5,M4)=0.0
      RCHFLG(N,M6,M5,M4)=0.0
      ROXFLG(N,M6,M5,M4)=0.0
      RNGFLG(N,M6,M5,M4)=0.0
      RN2FLG(N,M6,M5,M4)=0.0
      RN3FLG(N,M6,M5,M4)=0.0
      RHGFLG(N,M6,M5,M4)=0.0
      ENDIF
      ELSE
      DO 9531 K=0,4
      ROCFHS(K,N,M6,M5,M4)=0.0
      RONFHS(K,N,M6,M5,M4)=0.0
      ROPFHS(K,N,M6,M5,M4)=0.0
      ROAFHS(K,N,M6,M5,M4)=0.0
9531  CONTINUE
      RCOFHS(N,M6,M5,M4)=0.0
      RCHFHS(N,M6,M5,M4)=0.0
      ROXFHS(N,M6,M5,M4)=0.0
      RNGFHS(N,M6,M5,M4)=0.0
      RN2FHS(N,M6,M5,M4)=0.0
      RN4FHW(N,M6,M5,M4)=0.0
      RHGFHS(N,M6,M5,M4)=0.0
      RN3FHW(N,M6,M5,M4)=0.0
      RNOFHW(N,M6,M5,M4)=0.0
      RNXFHS(N,M6,M5,M4)=0.0
      RH1PHS(N,M6,M5,M4)=0.0
      RH2PHS(N,M6,M5,M4)=0.0
      RN4FHB(N,M6,M5,M4)=0.0
      RN3FHB(N,M6,M5,M4)=0.0
      RNOFHB(N,M6,M5,M4)=0.0
      RNXFHB(N,M6,M5,M4)=0.0
      RH1BHB(N,M6,M5,M4)=0.0
      RH2BHB(N,M6,M5,M4)=0.0
      RCOFLG(N,M6,M5,M4)=0.0
      RCHFLG(N,M6,M5,M4)=0.0
      ROXFLG(N,M6,M5,M4)=0.0
      RNGFLG(N,M6,M5,M4)=0.0
      RN2FLG(N,M6,M5,M4)=0.0
      RN3FLG(N,M6,M5,M4)=0.0
      RHGFLG(N,M6,M5,M4)=0.0
      ENDIF
9575  CONTINUE
C
C     NET GAS AND SOLUTE FLUXES IN EACH GRID CELL
C
      IF(M.NE.MX)THEN
      IF(L.EQ.NUM(N2,N1))THEN
      IF(N.NE.3)THEN
C
C     NET OVERLAND SOLUTE FLUX IN WATER
C
C     TQR*=net overland solute flux
C     RQR*=overland solute flux
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C
      DO 1202 NN=1,2
      DO 9550 K=0,4
      TQROC(K,N2,N1)=TQROC(K,N2,N1)+RQROC(K,N,NN,N2,N1)
      TQRON(K,N2,N1)=TQRON(K,N2,N1)+RQRON(K,N,NN,N2,N1)
      TQROP(K,N2,N1)=TQROP(K,N2,N1)+RQROP(K,N,NN,N2,N1)
      TQROA(K,N2,N1)=TQROA(K,N2,N1)+RQROA(K,N,NN,N2,N1)
9550  CONTINUE
      TQRCOS(N2,N1)=TQRCOS(N2,N1)+RQRCOS(N,NN,N2,N1)
      TQRCHS(N2,N1)=TQRCHS(N2,N1)+RQRCHS(N,NN,N2,N1)
      TQROXS(N2,N1)=TQROXS(N2,N1)+RQROXS(N,NN,N2,N1)
      TQRNGS(N2,N1)=TQRNGS(N2,N1)+RQRNGS(N,NN,N2,N1)
      TQRN2S(N2,N1)=TQRN2S(N2,N1)+RQRN2S(N,NN,N2,N1)
      TQRHGS(N2,N1)=TQRHGS(N2,N1)+RQRHGS(N,NN,N2,N1)
      TQRNH4(N2,N1)=TQRNH4(N2,N1)+RQRNH4(N,NN,N2,N1)
      TQRNH3(N2,N1)=TQRNH3(N2,N1)+RQRNH3(N,NN,N2,N1)
      TQRNO3(N2,N1)=TQRNO3(N2,N1)+RQRNO3(N,NN,N2,N1)
      TQRNO2(N2,N1)=TQRNO2(N2,N1)+RQRNO2(N,NN,N2,N1)
      TQRH1P(N2,N1)=TQRH1P(N2,N1)+RQRH1P(N,NN,N2,N1)
      TQRH2P(N2,N1)=TQRH2P(N2,N1)+RQRH2P(N,NN,N2,N1)
      IF(IFLBM(M,N,NN,N5,N4).EQ.0)THEN
      DO 9551 K=0,4
      TQROC(K,N2,N1)=TQROC(K,N2,N1)-RQROC(K,N,NN,N5,N4)
      TQRON(K,N2,N1)=TQRON(K,N2,N1)-RQRON(K,N,NN,N5,N4)
      TQROP(K,N2,N1)=TQROP(K,N2,N1)-RQROP(K,N,NN,N5,N4)
      TQROA(K,N2,N1)=TQROA(K,N2,N1)-RQROA(K,N,NN,N5,N4)
9551  CONTINUE
      TQRCOS(N2,N1)=TQRCOS(N2,N1)-RQRCOS(N,NN,N5,N4)
      TQRCHS(N2,N1)=TQRCHS(N2,N1)-RQRCHS(N,NN,N5,N4)
      TQROXS(N2,N1)=TQROXS(N2,N1)-RQROXS(N,NN,N5,N4)
      TQRNGS(N2,N1)=TQRNGS(N2,N1)-RQRNGS(N,NN,N5,N4)
      TQRN2S(N2,N1)=TQRN2S(N2,N1)-RQRN2S(N,NN,N5,N4)
      TQRHGS(N2,N1)=TQRHGS(N2,N1)-RQRHGS(N,NN,N5,N4)
      TQRNH4(N2,N1)=TQRNH4(N2,N1)-RQRNH4(N,NN,N5,N4)
      TQRNH3(N2,N1)=TQRNH3(N2,N1)-RQRNH3(N,NN,N5,N4)
      TQRNO3(N2,N1)=TQRNO3(N2,N1)-RQRNO3(N,NN,N5,N4)
      TQRNO2(N2,N1)=TQRNO2(N2,N1)-RQRNO2(N,NN,N5,N4)
      TQRH1P(N2,N1)=TQRH1P(N2,N1)-RQRH1P(N,NN,N5,N4)
      TQRH2P(N2,N1)=TQRH2P(N2,N1)-RQRH2P(N,NN,N5,N4)
      ENDIF
      IF(N4B.GT.0.AND.N5B.GT.0.AND.NN.EQ.1)THEN
      DO 9552 K=0,4
      TQROC(K,N2,N1)=TQROC(K,N2,N1)-RQROC(K,N,NN,N5B,N4B)
      TQRON(K,N2,N1)=TQRON(K,N2,N1)-RQRON(K,N,NN,N5B,N4B)
      TQROP(K,N2,N1)=TQROP(K,N2,N1)-RQROP(K,N,NN,N5B,N4B)
      TQROA(K,N2,N1)=TQROA(K,N2,N1)-RQROA(K,N,NN,N5B,N4B)
9552  CONTINUE
      TQRCOS(N2,N1)=TQRCOS(N2,N1)-RQRCOS(N,NN,N5B,N4B)
      TQRCHS(N2,N1)=TQRCHS(N2,N1)-RQRCHS(N,NN,N5B,N4B)
      TQROXS(N2,N1)=TQROXS(N2,N1)-RQROXS(N,NN,N5B,N4B)
      TQRNGS(N2,N1)=TQRNGS(N2,N1)-RQRNGS(N,NN,N5B,N4B)
      TQRN2S(N2,N1)=TQRN2S(N2,N1)-RQRN2S(N,NN,N5B,N4B)
      TQRHGS(N2,N1)=TQRHGS(N2,N1)-RQRHGS(N,NN,N5B,N4B)
      TQRNH4(N2,N1)=TQRNH4(N2,N1)-RQRNH4(N,NN,N5B,N4B)
      TQRNH3(N2,N1)=TQRNH3(N2,N1)-RQRNH3(N,NN,N5B,N4B)
      TQRNO3(N2,N1)=TQRNO3(N2,N1)-RQRNO3(N,NN,N5B,N4B)
      TQRNO2(N2,N1)=TQRNO2(N2,N1)-RQRNO2(N,NN,N5B,N4B)
      TQRH1P(N2,N1)=TQRH1P(N2,N1)-RQRH1P(N,NN,N5B,N4B)
      TQRH2P(N2,N1)=TQRH2P(N2,N1)-RQRH2P(N,NN,N5B,N4B)
      ENDIF
1202  CONTINUE
C
C     NET OVERLAND SOLUTE FLUX IN SNOW
C
C     TQS*=net solute flux in snow transfer
C     RQS*=solute flux in snow transfer
C
      TQSCOS(N2,N1)=TQSCOS(N2,N1)+RQSCOS(N,N2,N1)-RQSCOS(N,N5,N4)
      TQSCHS(N2,N1)=TQSCHS(N2,N1)+RQSCHS(N,N2,N1)-RQSCHS(N,N5,N4)
      TQSOXS(N2,N1)=TQSOXS(N2,N1)+RQSOXS(N,N2,N1)-RQSOXS(N,N5,N4)
      TQSNGS(N2,N1)=TQSNGS(N2,N1)+RQSNGS(N,N2,N1)-RQSNGS(N,N5,N4)
      TQSN2S(N2,N1)=TQSN2S(N2,N1)+RQSN2S(N,N2,N1)-RQSN2S(N,N5,N4)
      TQSNH4(N2,N1)=TQSNH4(N2,N1)+RQSNH4(N,N2,N1)-RQSNH4(N,N5,N4)
      TQSNH3(N2,N1)=TQSNH3(N2,N1)+RQSNH3(N,N2,N1)-RQSNH3(N,N5,N4)
      TQSNO3(N2,N1)=TQSNO3(N2,N1)+RQSNO3(N,N2,N1)-RQSNO3(N,N5,N4)
      TQSH1P(N2,N1)=TQSH1P(N2,N1)+RQSH1P(N,N2,N1)-RQSH1P(N,N5,N4)
      TQSH2P(N2,N1)=TQSH2P(N2,N1)+RQSH2P(N,N2,N1)-RQSH2P(N,N5,N4)
C
C     NET SOLUTE FLUX IN SNOWPACK
C
C     VHCPWM,VHCPWX=current,minimum volumetric heat capacity of snowpack
C     T*BLS=net solute flux in snowpack
C     R*BLS=solute flux in snowpack
C
      ELSEIF(N.EQ.3)THEN
      DO 1205 LS=1,JS
      IF(VHCPWM(M,LS,NY,NX).GT.VHCPWX(NY,NX))THEN
      LS2=MIN(JS,LS+1)
C
C     IF LOWER LAYER IS IN THE SNOWPACK
C
      IF(LS.LT.JS.AND.VHCPWM(M,LS2,N2,N1).GT.VHCPWX(N2,N1))THEN
      TCOBLS(LS,N2,N1)=TCOBLS(LS,N2,N1)+RCOBLS(LS,N2,N1)
     2-RCOBLS(LS2,N2,N1)
      TCHBLS(LS,N2,N1)=TCHBLS(LS,N2,N1)+RCHBLS(LS,N2,N1)
     2-RCHBLS(LS2,N2,N1)
      TOXBLS(LS,N2,N1)=TOXBLS(LS,N2,N1)+ROXBLS(LS,N2,N1)
     2-ROXBLS(LS2,N2,N1)
      TNGBLS(LS,N2,N1)=TNGBLS(LS,N2,N1)+RNGBLS(LS,N2,N1)
     2-RNGBLS(LS2,N2,N1)
      TN2BLS(LS,N2,N1)=TN2BLS(LS,N2,N1)+RN2BLS(LS,N2,N1)
     2-RN2BLS(LS2,N2,N1)
      TN4BLW(LS,N2,N1)=TN4BLW(LS,N2,N1)+RN4BLW(LS,N2,N1)
     2-RN4BLW(LS2,N2,N1)
      TN3BLW(LS,N2,N1)=TN3BLW(LS,N2,N1)+RN3BLW(LS,N2,N1)
     2-RN3BLW(LS2,N2,N1)
      TNOBLW(LS,N2,N1)=TNOBLW(LS,N2,N1)+RNOBLW(LS,N2,N1)
     2-RNOBLW(LS2,N2,N1)
      TH1PBS(LS,N2,N1)=TH1PBS(LS,N2,N1)+RH1PBS(LS,N2,N1)
     2-RH1PBS(LS2,N2,N1)
      TH2PBS(LS,N2,N1)=TH2PBS(LS,N2,N1)+RH2PBS(LS,N2,N1)
     2-RH2PBS(LS2,N2,N1)
      ELSE
C
C     IF LOWER LAYER IS THE LITTER AND SOIL SURFACE
C
      TCOBLS(LS,N2,N1)=TCOBLS(LS,N2,N1)+RCOBLS(LS,N2,N1)
     2-RCOFLS(3,0,N2,N1)-RCOFLS(3,NUM(N2,N1),N2,N1)
C    3-RCOFHS(3,NUM(N2,N1),N2,N1)
      TCHBLS(LS,N2,N1)=TCHBLS(LS,N2,N1)+RCHBLS(LS,N2,N1)
     2-RCHFLS(3,0,N2,N1)-RCHFLS(3,NUM(N2,N1),N2,N1)
C    3-RCHFHS(3,NUM(N2,N1),N2,N1)
      TOXBLS(LS,N2,N1)=TOXBLS(LS,N2,N1)+ROXBLS(LS,N2,N1)
     2-ROXFLS(3,0,N2,N1)-ROXFLS(3,NUM(N2,N1),N2,N1)
C    3-ROXFHS(3,NUM(N2,N1),N2,N1)
      TNGBLS(LS,N2,N1)=TNGBLS(LS,N2,N1)+RNGBLS(LS,N2,N1)
     2-RNGFLS(3,0,N2,N1)-RNGFLS(3,NUM(N2,N1),N2,N1)
C    3-RNGFHS(3,NUM(N2,N1),N2,N1)
      TN2BLS(LS,N2,N1)=TN2BLS(LS,N2,N1)+RN2BLS(LS,N2,N1)
     2-RN2FLS(3,0,N2,N1)-RN2FLS(3,NUM(N2,N1),N2,N1)
C    3-RN2FHS(3,NUM(N2,N1),N2,N1)
      TN4BLW(LS,N2,N1)=TN4BLW(LS,N2,N1)+RN4BLW(LS,N2,N1)
     2-RN4FLW(3,0,N2,N1)-RN4FLW(3,NUM(N2,N1),N2,N1)
     3-RN4FLB(3,NUM(N2,N1),N2,N1)
C    3-RN4FHW(3,NUM(N2,N1),N2,N1)-RN4FHB(3,NUM(N2,N1),N2,N1)
      TN3BLW(LS,N2,N1)=TN3BLW(LS,N2,N1)+RN3BLW(LS,N2,N1)
     2-RN3FLW(3,0,N2,N1)-RN3FLW(3,NUM(N2,N1),N2,N1)
     3-RN3FLB(3,NUM(N2,N1),N2,N1)
C    3-RN3FHW(3,NUM(N2,N1),N2,N1)-RN3FHB(3,NUM(N2,N1),N2,N1)
      TNOBLW(LS,N2,N1)=TNOBLW(LS,N2,N1)+RNOBLW(LS,N2,N1)
     2-RNOFLW(3,0,N2,N1)-RNOFLW(3,NUM(N2,N1),N2,N1)
     3-RNOFLB(3,NUM(N2,N1),N2,N1)
C    3-RNOFHW(3,NUM(N2,N1),N2,N1)-RNOFHB(3,NUM(N2,N1),N2,N1)
      TH1PBS(LS,N2,N1)=TH1PBS(LS,N2,N1)+RH1PBS(LS,N2,N1)
     2-RH1PFS(3,0,N2,N1)-RH1PFS(3,NUM(N2,N1),N2,N1)
     3-RH1BFB(3,NUM(N2,N1),N2,N1)
C    3-RH1PHS(3,NUM(N2,N1),N2,N1)-RH1BHB(3,NUM(N2,N1),N2,N1)
      TH2PBS(LS,N2,N1)=TH2PBS(LS,N2,N1)+RH2PBS(LS,N2,N1)
     2-RH2PFS(3,0,N2,N1)-RH2PFS(3,NUM(N2,N1),N2,N1)
     3-RH2BFB(3,NUM(N2,N1),N2,N1)
C    3-RH2PHS(3,NUM(N2,N1),N2,N1)-RH2BHB(3,NUM(N2,N1),N2,N1)
      ENDIF
      ENDIF
1205  CONTINUE
      ENDIF
      ENDIF
      ENDIF
C
C     TOTAL SOLUTE FLUX IN MICROPORES AND MACROPORES
C
C     T*FLS=net convective + diffusive solute flux through micropores
C     R*FLS=convective + diffusive solute flux through micropores
C     R*FLW,R*FLB=convective + diffusive solute flux through micropores in non-band,band
C     T*FHS=net convective + diffusive solute flux through macropores
C     R*FHS=convective + diffusive solute flux through macropores
C     R*FHW,R*FHB=convective + diffusive solute flux through macropores in non-band,band
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C
      IF(NCN(N2,N1).NE.3.OR.N.EQ.3)THEN
      DO 1200 LL=N6,NL(NY,NX)
      IF(VOLX(LL,N2,N1).GT.ZEROS2(N2,N1))THEN
      N6=LL
      GO TO 1201
      ENDIF
1200  CONTINUE
1201  CONTINUE
      IF(M.NE.MX)THEN
      IF(VOLX(N3,N2,N1).GT.ZEROS2(N2,N1))THEN
      DO 9545 K=0,4
      TOCFLS(K,N3,N2,N1)=TOCFLS(K,N3,N2,N1)+ROCFLS(K,N,N3,N2,N1)
     2-ROCFLS(K,N,N6,N5,N4)
      TONFLS(K,N3,N2,N1)=TONFLS(K,N3,N2,N1)+RONFLS(K,N,N3,N2,N1)
     2-RONFLS(K,N,N6,N5,N4)
      TOPFLS(K,N3,N2,N1)=TOPFLS(K,N3,N2,N1)+ROPFLS(K,N,N3,N2,N1)
     2-ROPFLS(K,N,N6,N5,N4)
      TOAFLS(K,N3,N2,N1)=TOAFLS(K,N3,N2,N1)+ROAFLS(K,N,N3,N2,N1)
     2-ROAFLS(K,N,N6,N5,N4)
      TOCFHS(K,N3,N2,N1)=TOCFHS(K,N3,N2,N1)+ROCFHS(K,N,N3,N2,N1)
     2-ROCFHS(K,N,N6,N5,N4)
      TONFHS(K,N3,N2,N1)=TONFHS(K,N3,N2,N1)+RONFHS(K,N,N3,N2,N1)
     2-RONFHS(K,N,N6,N5,N4)
      TOPFHS(K,N3,N2,N1)=TOPFHS(K,N3,N2,N1)+ROPFHS(K,N,N3,N2,N1)
     2-ROPFHS(K,N,N6,N5,N4)
      TOAFHS(K,N3,N2,N1)=TOAFHS(K,N3,N2,N1)+ROAFHS(K,N,N3,N2,N1)
     2-ROAFHS(K,N,N6,N5,N4)
9545  CONTINUE
      TCOFLS(N3,N2,N1)=TCOFLS(N3,N2,N1)+RCOFLS(N,N3,N2,N1)
     2-RCOFLS(N,N6,N5,N4)
C     IF(I.EQ.361.AND.NY.EQ.2)THEN
C     WRITE(*,3378)'TCOFLS',I,J,M,MM,N1,N2,N3,N4,N5,N6,N
C    2,TCOFLS(N3,N2,N1),RCOFLS(N,N3,N2,N1)
C    2,RCOFLS(N,N6,N5,N4),XCOFLS(N,N3,N2,N1)
C    2,XCOFLS(N,N6,N5,N4)
3378  FORMAT(A8,11I4,20E12.4)
C     ENDIF
      TCHFLS(N3,N2,N1)=TCHFLS(N3,N2,N1)+RCHFLS(N,N3,N2,N1)
     2-RCHFLS(N,N6,N5,N4)
      TOXFLS(N3,N2,N1)=TOXFLS(N3,N2,N1)+ROXFLS(N,N3,N2,N1)
     2-ROXFLS(N,N6,N5,N4)
      TNGFLS(N3,N2,N1)=TNGFLS(N3,N2,N1)+RNGFLS(N,N3,N2,N1)
     2-RNGFLS(N,N6,N5,N4)
      TN2FLS(N3,N2,N1)=TN2FLS(N3,N2,N1)+RN2FLS(N,N3,N2,N1)
     2-RN2FLS(N,N6,N5,N4)
      THGFLS(N3,N2,N1)=THGFLS(N3,N2,N1)+RHGFLS(N,N3,N2,N1)
     2-RHGFLS(N,N6,N5,N4)
      TN4FLW(N3,N2,N1)=TN4FLW(N3,N2,N1)+RN4FLW(N,N3,N2,N1)
     2-RN4FLW(N,N6,N5,N4)
      TN3FLW(N3,N2,N1)=TN3FLW(N3,N2,N1)+RN3FLW(N,N3,N2,N1)
     2-RN3FLW(N,N6,N5,N4)
      TNOFLW(N3,N2,N1)=TNOFLW(N3,N2,N1)+RNOFLW(N,N3,N2,N1)
     2-RNOFLW(N,N6,N5,N4)
      TNXFLS(N3,N2,N1)=TNXFLS(N3,N2,N1)+RNXFLS(N,N3,N2,N1)
     2-RNXFLS(N,N6,N5,N4)
      TH1PFS(N3,N2,N1)=TH1PFS(N3,N2,N1)+RH1PFS(N,N3,N2,N1)
     2-RH1PFS(N,N6,N5,N4)
      TH2PFS(N3,N2,N1)=TH2PFS(N3,N2,N1)+RH2PFS(N,N3,N2,N1)
     2-RH2PFS(N,N6,N5,N4)
      TN4FLB(N3,N2,N1)=TN4FLB(N3,N2,N1)+RN4FLB(N,N3,N2,N1)
     2-RN4FLB(N,N6,N5,N4)
      TN3FLB(N3,N2,N1)=TN3FLB(N3,N2,N1)+RN3FLB(N,N3,N2,N1)
     2-RN3FLB(N,N6,N5,N4)
      TNOFLB(N3,N2,N1)=TNOFLB(N3,N2,N1)+RNOFLB(N,N3,N2,N1)
     2-RNOFLB(N,N6,N5,N4)
      TNXFLB(N3,N2,N1)=TNXFLB(N3,N2,N1)+RNXFLB(N,N3,N2,N1)
     2-RNXFLB(N,N6,N5,N4)
      TH1BFB(N3,N2,N1)=TH1BFB(N3,N2,N1)+RH1BFB(N,N3,N2,N1)
     2-RH1BFB(N,N6,N5,N4)
      TH2BFB(N3,N2,N1)=TH2BFB(N3,N2,N1)+RH2BFB(N,N3,N2,N1)
     2-RH2BFB(N,N6,N5,N4)
      TCOFHS(N3,N2,N1)=TCOFHS(N3,N2,N1)+RCOFHS(N,N3,N2,N1)
     2-RCOFHS(N,N6,N5,N4)
      TCHFHS(N3,N2,N1)=TCHFHS(N3,N2,N1)+RCHFHS(N,N3,N2,N1)
     2-RCHFHS(N,N6,N5,N4)
      TOXFHS(N3,N2,N1)=TOXFHS(N3,N2,N1)+ROXFHS(N,N3,N2,N1)
     2-ROXFHS(N,N6,N5,N4)
      TNGFHS(N3,N2,N1)=TNGFHS(N3,N2,N1)+RNGFHS(N,N3,N2,N1)
     2-RNGFHS(N,N6,N5,N4)
      TN2FHS(N3,N2,N1)=TN2FHS(N3,N2,N1)+RN2FHS(N,N3,N2,N1)
     2-RN2FHS(N,N6,N5,N4)
      THGFHS(N3,N2,N1)=THGFHS(N3,N2,N1)+RHGFHS(N,N3,N2,N1)
     2-RHGFHS(N,N6,N5,N4)
      TN4FHW(N3,N2,N1)=TN4FHW(N3,N2,N1)+RN4FHW(N,N3,N2,N1)
     2-RN4FHW(N,N6,N5,N4)
      TN3FHW(N3,N2,N1)=TN3FHW(N3,N2,N1)+RN3FHW(N,N3,N2,N1)
     2-RN3FHW(N,N6,N5,N4)
      TNOFHW(N3,N2,N1)=TNOFHW(N3,N2,N1)+RNOFHW(N,N3,N2,N1)
     2-RNOFHW(N,N6,N5,N4)
      TNXFHS(N3,N2,N1)=TNXFHS(N3,N2,N1)+RNXFHS(N,N3,N2,N1)
     2-RNXFHS(N,N6,N5,N4)
      TH1PHS(N3,N2,N1)=TH1PHS(N3,N2,N1)+RH1PHS(N,N3,N2,N1)
     2-RH1PHS(N,N6,N5,N4)
      TH2PHS(N3,N2,N1)=TH2PHS(N3,N2,N1)+RH2PHS(N,N3,N2,N1)
     2-RH2PHS(N,N6,N5,N4)
      TN4FHB(N3,N2,N1)=TN4FHB(N3,N2,N1)+RN4FHB(N,N3,N2,N1)
     2-RN4FHB(N,N6,N5,N4)
      TN3FHB(N3,N2,N1)=TN3FHB(N3,N2,N1)+RN3FHB(N,N3,N2,N1)
     2-RN3FHB(N,N6,N5,N4)
      TNOFHB(N3,N2,N1)=TNOFHB(N3,N2,N1)+RNOFHB(N,N3,N2,N1)
     2-RNOFHB(N,N6,N5,N4)
      TNXFHB(N3,N2,N1)=TNXFHB(N3,N2,N1)+RNXFHB(N,N3,N2,N1)
     2-RNXFHB(N,N6,N5,N4)
      TH1BHB(N3,N2,N1)=TH1BHB(N3,N2,N1)+RH1BHB(N,N3,N2,N1)
     2-RH1BHB(N,N6,N5,N4)
      TH2BHB(N3,N2,N1)=TH2BHB(N3,N2,N1)+RH2BHB(N,N3,N2,N1)
     2-RH2BHB(N,N6,N5,N4)
      ELSE
      DO 9546 K=0,4
      TOCFLS(K,N3,N2,N1)=0.0
      TONFLS(K,N3,N2,N1)=0.0
      TOPFLS(K,N3,N2,N1)=0.0
      TOAFLS(K,N3,N2,N1)=0.0
      TOCFHS(K,N3,N2,N1)=0.0
      TONFHS(K,N3,N2,N1)=0.0
      TOPFHS(K,N3,N2,N1)=0.0
      TOAFHS(K,N3,N2,N1)=0.0
9546  CONTINUE
      TCOFLS(N3,N2,N1)=0.0
      TCHFLS(N3,N2,N1)=0.0
      TOXFLS(N3,N2,N1)=0.0
      TNGFLS(N3,N2,N1)=0.0
      TN2FLS(N3,N2,N1)=0.0
      THGFLS(N3,N2,N1)=0.0
      TN4FLW(N3,N2,N1)=0.0
      TN3FLW(N3,N2,N1)=0.0
      TNOFLW(N3,N2,N1)=0.0
      TNXFLS(N3,N2,N1)=0.0
      TH1PFS(N3,N2,N1)=0.0
      TH2PFS(N3,N2,N1)=0.0
      TN4FLB(N3,N2,N1)=0.0
      TN3FLB(N3,N2,N1)=0.0
      TNOFLB(N3,N2,N1)=0.0
      TNXFLB(N3,N2,N1)=0.0
      TH1BFB(N3,N2,N1)=0.0
      TH2BFB(N3,N2,N1)=0.0
      TCOFHS(N3,N2,N1)=0.0
      TCHFHS(N3,N2,N1)=0.0
      TOXFHS(N3,N2,N1)=0.0
      TNGFHS(N3,N2,N1)=0.0
      TN2FHS(N3,N2,N1)=0.0
      THGFHS(N3,N2,N1)=0.0
      TN4FHW(N3,N2,N1)=0.0
      TN3FHW(N3,N2,N1)=0.0
      TNOFHW(N3,N2,N1)=0.0
      TNXFHS(N3,N2,N1)=0.0
      TH1PHS(N3,N2,N1)=0.0
      TH2PHS(N3,N2,N1)=0.0
      TN4FHB(N3,N2,N1)=0.0
      TN3FHB(N3,N2,N1)=0.0
      TNOFHB(N3,N2,N1)=0.0
      TNXFHB(N3,N2,N1)=0.0
      TH1BHB(N3,N2,N1)=0.0
      TH2BHB(N3,N2,N1)=0.0
      ENDIF
      ENDIF
C
C     NET GAS FLUX
C
C     T*FLG=net convective+diffusive gas flux
C     R*FLG=convective+diffusive gas flux
C     gas code:*CO*=CO2,*OX*=O2,*CH*=CH4,*NG*=N2,*N2*=N2O,*NH*=NH3,*HG*=H2
C
      IF(VOLX(N3,N2,N1).GT.ZEROS2(N2,N1))THEN
      TCOFLG(N3,N2,N1)=TCOFLG(N3,N2,N1)+RCOFLG(N,N3,N2,N1)
     2-RCOFLG(N,N6,N5,N4)
      TCHFLG(N3,N2,N1)=TCHFLG(N3,N2,N1)+RCHFLG(N,N3,N2,N1)
     2-RCHFLG(N,N6,N5,N4)
      TOXFLG(N3,N2,N1)=TOXFLG(N3,N2,N1)+ROXFLG(N,N3,N2,N1)
     2-ROXFLG(N,N6,N5,N4)
      TNGFLG(N3,N2,N1)=TNGFLG(N3,N2,N1)+RNGFLG(N,N3,N2,N1)
     2-RNGFLG(N,N6,N5,N4)
      TN2FLG(N3,N2,N1)=TN2FLG(N3,N2,N1)+RN2FLG(N,N3,N2,N1)
     2-RN2FLG(N,N6,N5,N4)
      TN3FLG(N3,N2,N1)=TN3FLG(N3,N2,N1)+RN3FLG(N,N3,N2,N1)
     2-RN3FLG(N,N6,N5,N4)
      THGFLG(N3,N2,N1)=THGFLG(N3,N2,N1)+RHGFLG(N,N3,N2,N1)
     2-RHGFLG(N,N6,N5,N4)
      ELSE
      TCOFLG(N3,N2,N1)=0.0
      TCHFLG(N3,N2,N1)=0.0
      TOXFLG(N3,N2,N1)=0.0
      TNGFLG(N3,N2,N1)=0.0
      TN2FLG(N3,N2,N1)=0.0
      TN3FLG(N3,N2,N1)=0.0
      THGFLG(N3,N2,N1)=0.0
      ENDIF
      ENDIF
9580  CONTINUE
9585  CONTINUE
9590  CONTINUE
9595  CONTINUE
C
C     UPDATE STATE VARIABLES FROM TOTAL FLUXES CALCULATED ABOVE
C
      IF(MM.NE.NPG)THEN
      DO 9695 NX=NHW,NHE
      DO 9690 NY=NVN,NVS
      IF(M.NE.MX)THEN
C
C     STATE VARIABLES FOR SOLUTES IN SNOWPACK
C
C     *W2=solute content of snowpack
C     TQS*=net overland solute flux in snow
C     T*BLS=net solute flux in snowpack
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :N4=NH4,N3=NH3,NO=NO3,1P=HPO4,HP=H2PO4
C
      CO2W2(1,NY,NX)=CO2W2(1,NY,NX)+TQSCOS(NY,NX)
      CH4W2(1,NY,NX)=CH4W2(1,NY,NX)+TQSCHS(NY,NX)
      OXYW2(1,NY,NX)=OXYW2(1,NY,NX)+TQSOXS(NY,NX)
      ZNGW2(1,NY,NX)=ZNGW2(1,NY,NX)+TQSNGS(NY,NX)
      ZN2W2(1,NY,NX)=ZN2W2(1,NY,NX)+TQSN2S(NY,NX)
      ZN4W2(1,NY,NX)=ZN4W2(1,NY,NX)+TQSNH4(NY,NX)
      ZN3W2(1,NY,NX)=ZN3W2(1,NY,NX)+TQSNH3(NY,NX)
      ZNOW2(1,NY,NX)=ZNOW2(1,NY,NX)+TQSNO3(NY,NX)
      Z1PW2(1,NY,NX)=Z1PW2(1,NY,NX)+TQSH1P(NY,NX)
      ZHPW2(1,NY,NX)=ZHPW2(1,NY,NX)+TQSH2P(NY,NX)
      DO 9670 L=1,JS
      CO2W2(L,NY,NX)=CO2W2(L,NY,NX)+TCOBLS(L,NY,NX)
      CH4W2(L,NY,NX)=CH4W2(L,NY,NX)+TCHBLS(L,NY,NX)
      OXYW2(L,NY,NX)=OXYW2(L,NY,NX)+TOXBLS(L,NY,NX)
      ZNGW2(L,NY,NX)=ZNGW2(L,NY,NX)+TNGBLS(L,NY,NX)
      ZN2W2(L,NY,NX)=ZN2W2(L,NY,NX)+TN2BLS(L,NY,NX)
      ZN4W2(L,NY,NX)=ZN4W2(L,NY,NX)+TN4BLW(L,NY,NX)
      ZN3W2(L,NY,NX)=ZN3W2(L,NY,NX)+TN3BLW(L,NY,NX)
      ZNOW2(L,NY,NX)=ZNOW2(L,NY,NX)+TNOBLW(L,NY,NX)
      Z1PW2(L,NY,NX)=Z1PW2(L,NY,NX)+TH1PBS(L,NY,NX)
      ZHPW2(L,NY,NX)=ZHPW2(L,NY,NX)+TH2PBS(L,NY,NX)
C     IF(VHCPWM(M,L,NY,NX).GT.VHCPWX(NY,NX))THEN
C     WRITE(*,3434)'OXYW2',I,J,M,NX,NY,L,OXYW2(L,NY,NX),TOXBLS(L,NY,NX)
C    2,ROXBLS(L,NY,NX),ROXBLS(L+1,NY,NX)
C    2,ROXFLS(3,0,NY,NX),ROXFLS(3,NUM(NY,NX),NY,NX)
C    2,XOXBLS(L,NY,NX),XOXBLS(L+1,NY,NX)
C    2,XOXFLS(3,0,N2,N1),XOXFLS(3,NUM(N2,N1),N2,N1)
3434  FORMAT(A8,6I4,20E12.4)
C     ENDIF
9670  CONTINUE
C
C     STATE VARIABLES FOR SOLUTES IN SURFACE RESIDUE AND IN
C     MICROPORES AND MACROPORES IN SOIL SURFACE LAYER FROM OVERLAND
C     FLOW AND SURFACE VOLATILIZATION-DISSOLUTION
C
C     *S2=litter solute content
C     R*DFR=gas exchange between atmosphere and surface litter water
C     R*DFS=gas exchange between atmosphere and soil surface water
C     R*FLS=convective + diffusive solute flux into litter,soil surface
C     R*FLW,R*FLB=convective + diffusive solute flux into litter from non-band,band
C     TQR*=net overland solute flux
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C
      DO 9681 K=0,4
      OQC2(K,0,NY,NX)=OQC2(K,0,NY,NX)+ROCFLS(K,3,0,NY,NX)
      OQN2(K,0,NY,NX)=OQN2(K,0,NY,NX)+RONFLS(K,3,0,NY,NX)
      OQP2(K,0,NY,NX)=OQP2(K,0,NY,NX)+ROPFLS(K,3,0,NY,NX)
      OQA2(K,0,NY,NX)=OQA2(K,0,NY,NX)+ROAFLS(K,3,0,NY,NX)
9681  CONTINUE
      CO2S2(0,NY,NX)=CO2S2(0,NY,NX)+RCODFR(NY,NX)+RCOFLS(3,0,NY,NX)
      CH4S2(0,NY,NX)=CH4S2(0,NY,NX)+RCHDFR(NY,NX)+RCHFLS(3,0,NY,NX)
      OXYS2(0,NY,NX)=OXYS2(0,NY,NX)+ROXDFR(NY,NX)+ROXFLS(3,0,NY,NX)
      Z2GS2(0,NY,NX)=Z2GS2(0,NY,NX)+RNGDFR(NY,NX)+RNGFLS(3,0,NY,NX)
      Z2OS2(0,NY,NX)=Z2OS2(0,NY,NX)+RN2DFR(NY,NX)+RN2FLS(3,0,NY,NX)
      H2GS2(0,NY,NX)=H2GS2(0,NY,NX)+RHGDFR(NY,NX)+RHGFLS(3,0,NY,NX)
      ZNH4S2(0,NY,NX)=ZNH4S2(0,NY,NX)+RN4FLW(3,0,NY,NX)
      ZNH3S2(0,NY,NX)=ZNH3S2(0,NY,NX)+RN3DFR(NY,NX)+RN3FLW(3,0,NY,NX)
      ZNO3S2(0,NY,NX)=ZNO3S2(0,NY,NX)+RNOFLW(3,0,NY,NX)
      ZNO2S2(0,NY,NX)=ZNO2S2(0,NY,NX)+RNXFLS(3,0,NY,NX)
      H1PO42(0,NY,NX)=H1PO42(0,NY,NX)+RH1PFS(3,0,NY,NX)
      H2PO42(0,NY,NX)=H2PO42(0,NY,NX)+RH2PFS(3,0,NY,NX)
      CO2S2(NU(NY,NX),NY,NX)=CO2S2(NU(NY,NX),NY,NX)+RCODFS(NY,NX)
      CH4S2(NU(NY,NX),NY,NX)=CH4S2(NU(NY,NX),NY,NX)+RCHDFS(NY,NX)
      OXYS2(NU(NY,NX),NY,NX)=OXYS2(NU(NY,NX),NY,NX)+ROXDFS(NY,NX)
      Z2GS2(NU(NY,NX),NY,NX)=Z2GS2(NU(NY,NX),NY,NX)+RNGDFS(NY,NX)
      Z2OS2(NU(NY,NX),NY,NX)=Z2OS2(NU(NY,NX),NY,NX)+RN2DFS(NY,NX)
      ZNH3S2(NU(NY,NX),NY,NX)=ZNH3S2(NU(NY,NX),NY,NX)+RN3DFS(NY,NX)
      ZNH3B2(NU(NY,NX),NY,NX)=ZNH3B2(NU(NY,NX),NY,NX)+RNBDFS(NY,NX)
      H2GS2(NU(NY,NX),NY,NX)=H2GS2(NU(NY,NX),NY,NX)+RHGDFS(NY,NX)
C     IF(I.GE.360)THEN
C     WRITE(*,442)'CO2S20',I,J,M,MX,NX,NY,CO2S2(0,NY,NX)
C    2,CO2S2(NU(NY,NX),NY,NX),RCODFR(NY,NX),RCOFLS(3,0,NY,NX)
C    3,RCODFS(NY,NX)
C     WRITE(*,442)'OXYS20',I,J,NX,NY,M,MX,OXYS2(0,NY,NX)
C    2,OXYS2(NU(NY,NX),NY,NX),ROXDFR(NY,NX),ROXFLS(3,0,NY,NX)
C    3,ROXDFS(NY,NX)
442   FORMAT(A8,6I4,12E12.4)
C     ENDIF
      DO 9680 K=0,4
      OQC2(K,0,NY,NX)=OQC2(K,0,NY,NX)+TQROC(K,NY,NX)
      OQN2(K,0,NY,NX)=OQN2(K,0,NY,NX)+TQRON(K,NY,NX)
      OQP2(K,0,NY,NX)=OQP2(K,0,NY,NX)+TQROP(K,NY,NX)
      OQA2(K,0,NY,NX)=OQA2(K,0,NY,NX)+TQROA(K,NY,NX)
9680  CONTINUE
      CO2S2(0,NY,NX)=CO2S2(0,NY,NX)+TQRCOS(NY,NX)
      CH4S2(0,NY,NX)=CH4S2(0,NY,NX)+TQRCHS(NY,NX)
      OXYS2(0,NY,NX)=OXYS2(0,NY,NX)+TQROXS(NY,NX)
      Z2GS2(0,NY,NX)=Z2GS2(0,NY,NX)+TQRNGS(NY,NX)
      Z2OS2(0,NY,NX)=Z2OS2(0,NY,NX)+TQRN2S(NY,NX)
      H2GS2(0,NY,NX)=H2GS2(0,NY,NX)+TQRHGS(NY,NX)
      ZNH4S2(0,NY,NX)=ZNH4S2(0,NY,NX)+TQRNH4(NY,NX)
      ZNH3S2(0,NY,NX)=ZNH3S2(0,NY,NX)+TQRNH3(NY,NX)
      ZNO3S2(0,NY,NX)=ZNO3S2(0,NY,NX)+TQRNO3(NY,NX)
      ZNO2S2(0,NY,NX)=ZNO2S2(0,NY,NX)+TQRNO2(NY,NX)
      H1PO42(0,NY,NX)=H1PO42(0,NY,NX)+TQRH1P(NY,NX)
      H2PO42(0,NY,NX)=H2PO42(0,NY,NX)+TQRH2P(NY,NX)
C     IF(I.GE.360)THEN
C     WRITE(*,8787)'CO2S20',I,J,M,MM,NX,NY,CO2S2(0,NY,NX)
C    2,RCODFR(NY,NX),RCOFLS(3,0,NY,NX),RCOSK2(0,NY,NX)
C    3,TQRCOS(NY,NX),RCODFG(0,NY,NX),XCOFLS(3,0,NY,NX)
C     WRITE(*,8787)'CH4S20',I,J,NX,NY,M,MM,CH4S2(0,NY,NX)
C    2,RCHDFR(NY,NX),RCHFLS(3,0,NY,NX),RCHSK2(0,NY,NX)
C    3,TQRCHS(NY,NX),RCHDFG(0,NY,NX),XCHFLS(3,0,NY,NX)
C     WRITE(*,8787)'OXYS20',I,J,NX,NY,M,MM,OXYS2(0,NY,NX)
C    2,ROXDFR(NY,NX),ROXFLS(3,0,NY,NX),ROXSK2(0,NY,NX)
C    3,TQROXS(NY,NX),ROXDFG(0,NY,NX),XOXFLS(3,0,NY,NX)
8787  FORMAT(A8,6I4,12E12.4)
C     ENDIF
C     IF(I.EQ.118.AND.NX.EQ.3.AND.NY.EQ.4)THEN
C     WRITE(*,6868)'OXYW2',I,J,NX,NY,M,MM,OXYW2(NY,NX)
C    2,TQSOXS(NY,NX),XOXBLS(NY,NX)
6868  FORMAT(A8,6I4,12E12.4)
C     ENDIF
      ENDIF
C
C     STATE VARIABLES FOR SOLUTES IN MICROPORES AND
C     MACROPORES IN SOIL LAYERS FROM SUBSURFACE FLOW, MICROBIAL
C     AND ROOT EXCHANGE IN 'NITRO' AND 'UPTAKE', AND EQUILIBRIUM
C     REACTIONS IN 'SOLUTE'
C
C     *S2,*B2=micropore solute content in non-band,band
C     solute code:CO=CO2,CH=CH4,OX=O2,NG=N2,N2=N2O,HG=H2
C             :OC=DOC,ON=DON,OP=DOP,OA=acetate
C             :NH4=NH4,NH3=NH3,NO3=NO3,NO2=NO2,P14=HPO4,PO4=H2PO4 in non-band
C             :N4B=NH4,N3B=NH3,NOB=NO3,N2B=NO2,P1B=HPO4,POB=H2PO4 in band
C     T*FLS=net convective + diffusive solute flux through micropores
C     T*FHS=net convective + diffusive solute flux through macropores
C     R*FXS=convective + diffusive solute flux between macropores and micropores
C     R*FLZ,R*FBZ=subsurface solute flux in non-band,band
C     R*BBL=bubble flux
C
      DO 9685 L=NU(NY,NX),NL(NY,NX)
      IF(M.NE.MX)THEN
      IF(VOLX(L,NY,NX).GT.ZEROS2(NY,NX))THEN
      CO2S2(L,NY,NX)=CO2S2(L,NY,NX)+TCOFLS(L,NY,NX)+RCOFXS(L,NY,NX)
     2+RCOFLZ(L,NY,NX)+RCOBBL(L,NY,NX)
      CH4S2(L,NY,NX)=CH4S2(L,NY,NX)+TCHFLS(L,NY,NX)+RCHFXS(L,NY,NX)
     2+RCHFLZ(L,NY,NX)+RCHBBL(L,NY,NX)
      OXYS2(L,NY,NX)=OXYS2(L,NY,NX)+TOXFLS(L,NY,NX)+ROXFXS(L,NY,NX)
     2+ROXFLZ(L,NY,NX)+ROXBBL(L,NY,NX)
      Z2GS2(L,NY,NX)=Z2GS2(L,NY,NX)+TNGFLS(L,NY,NX)+RNGFXS(L,NY,NX)
     2+RNGFLZ(L,NY,NX)+RNGBBL(L,NY,NX)
      Z2OS2(L,NY,NX)=Z2OS2(L,NY,NX)+TN2FLS(L,NY,NX)+RN2FXS(L,NY,NX)
     2+RN2FLZ(L,NY,NX)+RN2BBL(L,NY,NX)
      ZNH3S2(L,NY,NX)=ZNH3S2(L,NY,NX)+TN3FLW(L,NY,NX)+RN3FXW(L,NY,NX)
     2+RN3FLZ(L,NY,NX)+RN3BBL(L,NY,NX)
      ZNH3B2(L,NY,NX)=ZNH3B2(L,NY,NX)+TN3FLB(L,NY,NX)+RN3FXB(L,NY,NX)
     2+RN3FBZ(L,NY,NX)+RNBBBL(L,NY,NX)
      H2GS2(L,NY,NX)=H2GS2(L,NY,NX)+THGFLS(L,NY,NX)+RHGFXS(L,NY,NX)
     2+RHGFLZ(L,NY,NX)+RHGBBL(L,NY,NX)
      DO 9675 K=0,4
      OQC2(K,L,NY,NX)=OQC2(K,L,NY,NX)+TOCFLS(K,L,NY,NX)
     2+ROCFXS(K,L,NY,NX)
      OQN2(K,L,NY,NX)=OQN2(K,L,NY,NX)+TONFLS(K,L,NY,NX)
     2+RONFXS(K,L,NY,NX)
      OQP2(K,L,NY,NX)=OQP2(K,L,NY,NX)+TOPFLS(K,L,NY,NX)
     2+ROPFXS(K,L,NY,NX)
      OQA2(K,L,NY,NX)=OQA2(K,L,NY,NX)+TOAFLS(K,L,NY,NX)
     2+ROAFXS(K,L,NY,NX)
      OQCH2(K,L,NY,NX)=OQCH2(K,L,NY,NX)+TOCFHS(K,L,NY,NX)
     2-ROCFXS(K,L,NY,NX)
      OQNH2(K,L,NY,NX)=OQNH2(K,L,NY,NX)+TONFHS(K,L,NY,NX)
     2-RONFXS(K,L,NY,NX)
      OQPH2(K,L,NY,NX)=OQPH2(K,L,NY,NX)+TOPFHS(K,L,NY,NX)
     2-ROPFXS(K,L,NY,NX)
      OQAH2(K,L,NY,NX)=OQAH2(K,L,NY,NX)+TOAFHS(K,L,NY,NX)
     2-ROAFXS(K,L,NY,NX)
9675  CONTINUE
      ZNH4S2(L,NY,NX)=ZNH4S2(L,NY,NX)+TN4FLW(L,NY,NX)+RN4FXW(L,NY,NX)
     2+RN4FLZ(L,NY,NX)
      ZNO3S2(L,NY,NX)=ZNO3S2(L,NY,NX)+TNOFLW(L,NY,NX)+RNOFXW(L,NY,NX)
     2+RNOFLZ(L,NY,NX)
      ZNO2S2(L,NY,NX)=ZNO2S2(L,NY,NX)+TNXFLS(L,NY,NX)+RNXFXS(L,NY,NX)
      H1PO42(L,NY,NX)=H1PO42(L,NY,NX)+TH1PFS(L,NY,NX)+RH1PXS(L,NY,NX)
     2+RH1PFZ(L,NY,NX)
      H2PO42(L,NY,NX)=H2PO42(L,NY,NX)+TH2PFS(L,NY,NX)+RH2PXS(L,NY,NX)
     2+RH2PFZ(L,NY,NX)
      ZNH4B2(L,NY,NX)=ZNH4B2(L,NY,NX)+TN4FLB(L,NY,NX)+RN4FXB(L,NY,NX)
     2+RN4FBZ(L,NY,NX)
      ZNO3B2(L,NY,NX)=ZNO3B2(L,NY,NX)+TNOFLB(L,NY,NX)+RNOFXB(L,NY,NX)
     2+RNOFBZ(L,NY,NX)
      ZNO2B2(L,NY,NX)=ZNO2B2(L,NY,NX)+TNXFLB(L,NY,NX)+RNXFXB(L,NY,NX)
      H1POB2(L,NY,NX)=H1POB2(L,NY,NX)+TH1BFB(L,NY,NX)+RH1BXB(L,NY,NX)
     2+RH1BBZ(L,NY,NX)
      H2POB2(L,NY,NX)=H2POB2(L,NY,NX)+TH2BFB(L,NY,NX)+RH2BXB(L,NY,NX)
     2+RH2BBZ(L,NY,NX)
      CO2SH2(L,NY,NX)=CO2SH2(L,NY,NX)+TCOFHS(L,NY,NX)-RCOFXS(L,NY,NX)
      CH4SH2(L,NY,NX)=CH4SH2(L,NY,NX)+TCHFHS(L,NY,NX)-RCHFXS(L,NY,NX)
      OXYSH2(L,NY,NX)=OXYSH2(L,NY,NX)+TOXFHS(L,NY,NX)-ROXFXS(L,NY,NX)
      Z2GSH2(L,NY,NX)=Z2GSH2(L,NY,NX)+TNGFHS(L,NY,NX)-RNGFXS(L,NY,NX)
      Z2OSH2(L,NY,NX)=Z2OSH2(L,NY,NX)+TN2FHS(L,NY,NX)-RN2FXS(L,NY,NX)
      H2GSH2(L,NY,NX)=H2GSH2(L,NY,NX)+THGFHS(L,NY,NX)-RHGFXS(L,NY,NX)
      ZNH4H2(L,NY,NX)=ZNH4H2(L,NY,NX)+TN4FHW(L,NY,NX)-RN4FXW(L,NY,NX)
      ZNH3H2(L,NY,NX)=ZNH3H2(L,NY,NX)+TN3FHW(L,NY,NX)-RN3FXW(L,NY,NX)
      ZNO3H2(L,NY,NX)=ZNO3H2(L,NY,NX)+TNOFHW(L,NY,NX)-RNOFXW(L,NY,NX)
      ZNO2H2(L,NY,NX)=ZNO2H2(L,NY,NX)+TNXFHS(L,NY,NX)-RNXFXS(L,NY,NX)
      H1P4H2(L,NY,NX)=H1P4H2(L,NY,NX)+TH1PHS(L,NY,NX)-RH1PXS(L,NY,NX)
      H2P4H2(L,NY,NX)=H2P4H2(L,NY,NX)+TH2PHS(L,NY,NX)-RH2PXS(L,NY,NX)
      ZN4BH2(L,NY,NX)=ZN4BH2(L,NY,NX)+TN4FHB(L,NY,NX)-RN4FXB(L,NY,NX)
      ZN3BH2(L,NY,NX)=ZN3BH2(L,NY,NX)+TN3FHB(L,NY,NX)-RN3FXB(L,NY,NX)
      ZNOBH2(L,NY,NX)=ZNOBH2(L,NY,NX)+TNOFHB(L,NY,NX)-RNOFXB(L,NY,NX)
      ZN2BH2(L,NY,NX)=ZN2BH2(L,NY,NX)+TNXFHB(L,NY,NX)-RNXFXB(L,NY,NX)
      H1PBH2(L,NY,NX)=H1PBH2(L,NY,NX)+TH1BHB(L,NY,NX)-RH1BXB(L,NY,NX)
      H2PBH2(L,NY,NX)=H2PBH2(L,NY,NX)+TH2BHB(L,NY,NX)-RH2BXB(L,NY,NX)
      ENDIF
      ENDIF
C
C     STATE VARIABLES FOR GASES IN SOIL LAYERS FROM SUBSURFACE FLOW,
C     MICROBIAL AND ROOT EXCHANGE IN 'NITRO' AND 'UPTAKE'
C
C     *G2,*S2=soil gas, solute content
C     R*DFG=water-air gas flux
C     T*FLG=net convective+diffusive gas flux
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C
      IF(VOLX(L,NY,NX).GT.ZEROS2(NY,NX))THEN
      CO2S2(L,NY,NX)=CO2S2(L,NY,NX)+RCODFG(L,NY,NX)
      CH4S2(L,NY,NX)=CH4S2(L,NY,NX)+RCHDFG(L,NY,NX)
      OXYS2(L,NY,NX)=OXYS2(L,NY,NX)+ROXDFG(L,NY,NX)
      Z2GS2(L,NY,NX)=Z2GS2(L,NY,NX)+RNGDFG(L,NY,NX)
      Z2OS2(L,NY,NX)=Z2OS2(L,NY,NX)+RN2DFG(L,NY,NX)
      ZNH3S2(L,NY,NX)=ZNH3S2(L,NY,NX)+RN3DFG(L,NY,NX)
      ZNH3B2(L,NY,NX)=ZNH3B2(L,NY,NX)+RNBDFG(L,NY,NX)
      H2GS2(L,NY,NX)=H2GS2(L,NY,NX)+RHGDFG(L,NY,NX)
      CO2G2(L,NY,NX)=CO2G2(L,NY,NX)+TCOFLG(L,NY,NX)-RCODFG(L,NY,NX)
      CH4G2(L,NY,NX)=CH4G2(L,NY,NX)+TCHFLG(L,NY,NX)-RCHDFG(L,NY,NX)
      OXYG2(L,NY,NX)=OXYG2(L,NY,NX)+TOXFLG(L,NY,NX)-ROXDFG(L,NY,NX)
      Z2GG2(L,NY,NX)=Z2GG2(L,NY,NX)+TNGFLG(L,NY,NX)-RNGDFG(L,NY,NX)
      Z2OG2(L,NY,NX)=Z2OG2(L,NY,NX)+TN2FLG(L,NY,NX)-RN2DFG(L,NY,NX)
      ZN3G2(L,NY,NX)=ZN3G2(L,NY,NX)+TN3FLG(L,NY,NX)-RN3DFG(L,NY,NX)
     2-RNBDFG(L,NY,NX)
      H2GG2(L,NY,NX)=H2GG2(L,NY,NX)+THGFLG(L,NY,NX)-RHGDFG(L,NY,NX)
      ENDIF
C     IF(I.EQ.121.AND.L.EQ.2)THEN
C     DO 9676 K=0,4
C     WRITE(*,446)'OQC2',I,J,NX,NY,L,M,MM,K,OQC2(K,L,NY,NX)
C    2,TOCFLS(K,L,NY,NX),ROCFXS(K,L,NY,NX),ROCSK2(K,L,NY,NX)
C    2,XOQCS(K,L,NY,NX)
C     WRITE(*,446)'OQA2',I,J,NX,NY,L,M,MM,K,OQA2(K,L,NY,NX)
C    2,TOAFLS(K,L,NY,NX),ROAFXS(K,L,NY,NX),ROASK2(K,L,NY,NX)
446   FORMAT(A8,8I4,12E12.4)
9676  CONTINUE
C     WRITE(*,448)'CO2S2',I,J,M,MM,NX,NY,L
C    2,CO2S2(L,NY,NX),TCOFLS(L,NY,NX),RCOFXS(L,NY,NX)
C    2,RCOFLZ(L,NY,NX),RCOBBL(L,NY,NX),RCODFG(L,NY,NX)
C    2,CO2S(L,NY,NX),RCOSK2(L,NY,NX),TQRCOS(NY,NX)
C    3,RCODFS(NY,NX),PARG(M,NY,NX),CCO2E(NY,NX),CO2GQ
C    4,VOLWM(M,L,NY,NX),DLYR(3,L,NY,NX),AREA(1,L,NY,NX)
C    6,RCO2O(L,NY,NX),TCO2S(L,NY,NX),TRCO2(L,NY,NX)
C    7,VOLY(L,NY,NX)
448   FORMAT(A8,7I4,40E12.4)
C     WRITE(*,444)'OXYS2',I,J,M,MM,NX,NY,L
C    2,OXYS2(L,NY,NX),TOXFLS(L,NY,NX),ROXFXS(L,NY,NX)
C    3,ROXFLZ(L,NY,NX),ROXBBL(L,NY,NX),ROXDFG(L,NY,NX)
C    4,ROXSK(M,L,NY,NX),OXYG2(L,NY,NX),ROXFLS(3,L,NY,NX)
C    5,ROXFLS(3,L+1,NY,NX),ROXFLS(1,L,NY,NX+1),ROXDFS(NY,NX)
C    6,XOXFLS(3,L,NY,NX),XOXFLS(3,L+1,NY,NX),XOXFLS(1,L,NY,NX+1)
C    6,ROXSK2(L,NY,NX),ROXSK(M,L,NY,NX),VOLWM(M,L,NY,NX)
C     WRITE(*,444)'OXYSH2',I,J,M,MX,NX,NY,L
C    2,OXYSH2(L,NY,NX),TOXFHS(L,NY,NX),ROXFXS(L,NY,NX)
C     WRITE(*,444)'CH4S2',I,J,NX,NY,L,M,MM,CH4S2(L,NY,NX)
C    2,TCHFLS(L,NY,NX),RCHFXS(L,NY,NX),RCHFLZ(L,NY,NX)
C    3,RCHBBL(L,NY,NX),RCHDFG(L,NY,NX),RCHSK2(L,NY,NX)
C    4,RCHFLS(3,L,NY,NX),RCHFLS(3,L+1,NY,NX)
C    5,RCHDFR(NY,NX),RCHFLS(3,L,NY,NX),RCHSK2(L,NY,NX)
C    3,TQRCHS(NY,NX),RCHDFG(L,NY,NX),XCHFLS(3,L,NY,NX)
C    6,CH4G2(L,NY,NX),TCHFLG(L,NY,NX),THETY(L,NY,NX)
C     WRITE(*,444)'Z2GS2',I,J,M,MX,NX,NY,L
C    2,Z2GS2(L,NY,NX),RNGDFG(L,NY,NX),RNGSK2(L,NY,NX)
C    3,RNGDFS(NY,NX),RNGFLS(3,0,NY,NX),TQRNGS(NY,NX)
C    4,TNGFLS(L,NY,NX),RNGFXS(L,NY,NX),RNGFLZ(L,NY,NX)
C    2,RNGBBL(L,NY,NX),Z2GG2(L,NY,NX),TNGFLG(L,NY,NX)
C     WRITE(*,444)'ZN3G2',I,J,M,MM,NX,NY,L,ZN3G2(L,NY,NX)
C    2,TN3FLG(L,NY,NX),RN3DFG(L,NY,NX),RNBDFG(L,NY,NX)
C    3,ZNH3S2(L,NY,NX),ZNH3B2(L,NY,NX),TN3FLW(L,NY,NX),RN3FXW(L,NY,NX)
C    2,RN3FLZ(L,NY,NX),RN3BBL(L,NY,NX),RN3SK2(L,NY,NX)
C    3,ZNH4S2(L,NY,NX),ZNH4B2(L,NY,NX),RN4SK2(L,NY,NX)
C    4,TN4FLW(L,NY,NX),RN4FXW(L,NY,NX),RN4FLZ(L,NY,NX)
C    5,RN4SK2(L,NY,NX)
C     WRITE(*,444)'CO2G2',I,J,M,MM,NX,NY,L,CO2G2(L,NY,NX)
C    2,TCOFLG(L,NY,NX),RCODFG(L,NY,NX),CO2S2(L,NY,NX)
C    3,RCOFLG(3,L,NY,NX),RCOFLG(3,L+1,NY,NX),RCOFLG(1,L,NY,NX+1)
C    4,DCO2G(3,L,NY,NX),THETPM(M,L,NY,NX),PARGCO(NY,NX)
C    6,XCOFLG(3,L,NY,NX),XCOFLG(3,L+1,NY,NX),XCOFLG(1,L,NY,NX+1)
C    7,CCO2E(NY,NX),VOLPM(M,L,NY,NX)
C     WRITE(*,444)'OXYG2',I,J,M,MM,NX,NY,L,OXYG2(L,NY,NX)
C    2,TOXFLG(L,NY,NX),ROXDFG(L,NY,NX),OXYS2(L,NY,NX)
C    3,ROXFLG(3,L,NY,NX),ROXFLG(3,L+1,NY,NX),ROXFLG(1,L,NY,NX+1)
C    4,DOXYG(3,L,NY,NX),THETPM(M,L,NY,NX),PARGOX(NY,NX)
C    6,XOXFLG(3,L,NY,NX),XOXFLG(3,L+1,NY,NX),XOXFLG(1,L,NY,NX+1)
C    7,COXYE(NY,NX),VOLPM(M,L,NY,NX)
C     WRITE(*,444)'N2OG2',I,J,M,MM,NX,NY,L,Z2OG2(L,NY,NX)
C    2,Z2OS2(L,NY,NX),Z2OSH2(L,NY,NX),TN2FLG(L,NY,NX),RN2DFG(L,NY,NX)
C    3,TN2FLS(L,NY,NX),RN2FXS(L,NY,NX),RN2FLZ(L,NY,NX),RN2BBL(L,NY,NX)
C    2,TN2FHS(L,NY,NX),RN2SK2(L,NY,NX),RN2O(L,NY,NX),TUPN2S(L,NY,NX)
C     WRITE(*,444)'H2GS2',I,J,NX,NY,M,MM,L,H2GS2(L,NY,NX)
C    2,THGFLS(L,NY,NX),RHGFXS(L,NY,NX),RHGFLZ(L,NY,NX),RHGBBL(L,NY,NX)
C    3,H2GSH2(L,NY,NX),THGFHS(L,NY,NX),RHGDFG(L,NY,NX),RHGSK2(L,NY,NX)
C    4,RH2GO(L,NY,NX),TUPHGS(L,NY,NX)
C     WRITE(*,444)'H1PO42',I,J,M,MM,NX,NY,L,H1PO42(L,NY,NX)
C    2,TH1PFS(L,NY,NX),RH1PXS(L,NY,NX),RH1PFZ(L,NY,NX)
C    3,H2PO42(L,NY,NX),TH2PFS(L,NY,NX),RH2PXS(L,NY,NX)
C    2,RH2PFZ(L,NY,NX),RH1PFS(3,L,NY,NX),RH1PFS(3,L+1,NY,NX)
C    2,H1POB2(L,NY,NX),H1PBH2(L,NY,NX),XH1BXB(L,NY,NX)
C     WRITE(*,444)'ZN4BH2',I,J,NX,NY,M,MM,L,ZN4BH2(L,NY,NX)
C    2,TN4FHB(L,NY,NX),RN4FXB(L,NY,NX),XN4FHB(3,L,NY,NX)
C    3,RN4FHB(3,L,NY,NX),RN4FHB(3,L+1,NY,NX)
444   FORMAT(A8,7I4,40E12.4)
C     ENDIF
9685  CONTINUE
C
C     GAS EXCHANGE IN SURFACE LITTER
C
C     *S2=litter aqueous gas content
C     R*DFG=litter-atmosphere gas flux
C     gas code:*CO2*=CO2,*OXY*=O2,*CH4*=CH4,*Z2G*=N2,*Z2O*=N2O
C             :*ZN3*=NH3,*H2G*=H2
C
      CO2S2(0,NY,NX)=CO2S2(0,NY,NX)+RCODFG(0,NY,NX)
      CH4S2(0,NY,NX)=CH4S2(0,NY,NX)+RCHDFG(0,NY,NX)
      OXYS2(0,NY,NX)=OXYS2(0,NY,NX)+ROXDFG(0,NY,NX)
      Z2GS2(0,NY,NX)=Z2GS2(0,NY,NX)+RNGDFG(0,NY,NX)
      Z2OS2(0,NY,NX)=Z2OS2(0,NY,NX)+RN2DFG(0,NY,NX)
      ZNH3S2(0,NY,NX)=ZNH3S2(0,NY,NX)+RN3DFG(0,NY,NX)
      H2GS2(0,NY,NX)=H2GS2(0,NY,NX)+RHGDFG(0,NY,NX)
C     IF(I.EQ.53)THEN
C     WRITE(*,1119)'OXYS20',I,J,M,MX,NX,NY,OXYS2(0,NY,NX)
C    2,ROXDFG(0,NY,NX),ROXDFR(NY,NX),ROXFLS(3,0,NY,NX)
C    3,TQROXS(NY,NX),ROXSK2(0,NY,NX),OXYS2(0,NY,NX)/VOLWM(M,0,NY,NX)
C    4,VOLWM(M,0,NY,NX)/VOLA(0,NY,NX),VOLPM(M,0,NY,NX)/VOLA(0,NY,NX)
C    5,VOLWM(M,0,NY,NX),VOLA(0,NY,NX),VOLWG(NY,NX),DFGS(M,0,NY,NX)
C    6,VOLPM(M,NU(NY,NX),NY,NX),VOLWM(M,NU(NY,NX),NY,NX)
C    7,VOLWHM(M,NU(NY,NX),NY,NX)
C     WRITE(*,1119)'CH4S2G',I,J,NX,NY,M,MM,CH4S2(0,NY,NX)
C    2,RCHDFG(0,NY,NX)
1119  FORMAT(A8,6I4,20E12.4)
C     ENDIF
9690  CONTINUE
9695  CONTINUE
      ENDIF
      MX=M
30    CONTINUE
      RETURN
      END
