      SUBROUTINE trnsfrs(I,J,NHW,NHE,NVN,NVS)
C
C     THIS SUBROUTINE CALCULATES 3-DIMENSIONAL FLUXES OF ALL SOIL
C     SALT SOLUTES
C
      include "parameters.h"
      include "blkc.h"
      include "blk2a.h"
      include "blk2b.h"
      include "blk2c.h"
      include "blk8a.h"
      include "blk8b.h"
      include "blk10.h"
      include "blk11a.h"
      include "blk11b.h"
      include "blk13c.h"
      include "blk15a.h"
      include "blk15b.h"
      include "blk18a.h"
      include "blk18b.h"
      include "blk19a.h"
      include "blk19b.h"
      include "blk19c.h"
      include "blk19d.h"
      include "blk20a.h"
      include "blk20b.h"
      include "blk20c.h"
      include "blk20d.h"
      include "blk20e.h"
      include "blk21a.h"
      include "blk21b.h"
      include "blk22a.h"
      include "blk22b.h"
      include "blk22c.h"
      DIMENSION ZAL2(0:JZ,JY,JX),ZFE2(0:JZ,JY,JX),ZHY2(0:JZ,JY,JX)
     2,ZCA2(0:JZ,JY,JX),ZMG2(0:JZ,JY,JX),ZNA2(0:JZ,JY,JX)
     3,ZKA2(0:JZ,JY,JX),ZOH2(0:JZ,JY,JX),ZSO42(0:JZ,JY,JX)
     4,ZHCO32(0:JZ,JY,JX),ZCL2(0:JZ,JY,JX),ZCO32(0:JZ,JY,JX)
     5,ZAL12(0:JZ,JY,JX),ZAL22(0:JZ,JY,JX),ZAL32(0:JZ,JY,JX)
     6,ZAL42(0:JZ,JY,JX),ZALS2(0:JZ,JY,JX),ZFE12(0:JZ,JY,JX)
     7,ZFE22(0:JZ,JY,JX),ZFE32(0:JZ,JY,JX),ZFE42(0:JZ,JY,JX)
     8,ZFES2(0:JZ,JY,JX),ZCAO2(0:JZ,JY,JX),ZCAC2(0:JZ,JY,JX)
     9,ZCAH2(0:JZ,JY,JX),ZCAS2(0:JZ,JY,JX),ZMGO2(0:JZ,JY,JX)
     1,ZMGC2(0:JZ,JY,JX),ZMGH2(0:JZ,JY,JX),ZMGS2(0:JZ,JY,JX)
     2,ZNAC2(0:JZ,JY,JX),ZNAS2(0:JZ,JY,JX),ZKAS2(0:JZ,JY,JX)
     3,H0PO42(0:JZ,JY,JX),H3PO42(0:JZ,JY,JX)
     4,ZFE1P2(0:JZ,JY,JX),ZFE2P2(0:JZ,JY,JX),ZCA0P2(0:JZ,JY,JX)
     5,ZCA1P2(0:JZ,JY,JX),ZCA2P2(0:JZ,JY,JX),ZMG1P2(0:JZ,JY,JX)
     6,H0POB2(JZ,JY,JX),H3POB2(JZ,JY,JX)
     7,ZF1PB2(JZ,JY,JX),ZF2PB2(JZ,JY,JX),ZC0PB2(JZ,JY,JX)
     8,ZC1PB2(JZ,JY,JX),ZC2PB2(JZ,JY,JX),ZM1PB2(JZ,JY,JX)
      DIMENSION RZAL2(0:JZ,JY,JX),RZFE2(0:JZ,JY,JX),RZHY2(0:JZ,JY,JX)
     2,RZCA2(0:JZ,JY,JX),RZMG2(0:JZ,JY,JX),RZNA2(0:JZ,JY,JX)
     3,RZKA2(0:JZ,JY,JX),RZOH2(0:JZ,JY,JX),RZSO42(0:JZ,JY,JX)
     4,RZHCO32(0:JZ,JY,JX),RZCL2(0:JZ,JY,JX),RZCO32(0:JZ,JY,JX)
     5,RZAL12(0:JZ,JY,JX),RZAL22(0:JZ,JY,JX),RZAL32(0:JZ,JY,JX)
     6,RZAL42(0:JZ,JY,JX),RZALS2(0:JZ,JY,JX),RZFE12(0:JZ,JY,JX)
     7,RZFE22(0:JZ,JY,JX),RZFE32(0:JZ,JY,JX),RZFE42(0:JZ,JY,JX)
     8,RZFES2(0:JZ,JY,JX),RZCAO2(0:JZ,JY,JX),RZCAC2(0:JZ,JY,JX)
     9,RZCAH2(0:JZ,JY,JX),RZCAS2(0:JZ,JY,JX),RZMGO2(0:JZ,JY,JX)
     1,RZMGC2(0:JZ,JY,JX),RZMGH2(0:JZ,JY,JX),RZMGS2(0:JZ,JY,JX)
     2,RZNAC2(0:JZ,JY,JX),RZNAS2(0:JZ,JY,JX),RZKAS2(0:JZ,JY,JX)
     3,RH0PO42(0:JZ,JY,JX),RH3PO42(0:JZ,JY,JX)
     4,RZFE1P2(0:JZ,JY,JX),RZFE2P2(0:JZ,JY,JX),RZCA0P2(0:JZ,JY,JX)
     5,RZCA1P2(0:JZ,JY,JX),RZCA2P2(0:JZ,JY,JX),RZMG1P2(0:JZ,JY,JX)
     6,RH0POB2(JZ,JY,JX),RH3POB2(JZ,JY,JX)
     7,RZF1PB2(JZ,JY,JX),RZF2PB2(JZ,JY,JX),RZC0PB2(JZ,JY,JX)
     8,RZC1PB2(JZ,JY,JX),RZC2PB2(JZ,JY,JX),RZM1PB2(JZ,JY,JX)
      DIMENSION ZALW2(JS,JY,JX),ZFEW2(JS,JY,JX),ZHYW2(JS,JY,JX)
     2,ZCAW2(JS,JY,JX),ZMGW2(JS,JY,JX),ZNAW2(JS,JY,JX)
     3,ZKAW2(JS,JY,JX),ZOHW2(JS,JY,JX),ZSO4W2(JS,JY,JX)
     4,ZCLW2(JS,JY,JX),ZCO3W2(JS,JY,JX),ZHCO3W2(JS,JY,JX)
     5,ZALH1W2(JS,JY,JX),ZALH2W2(JS,JY,JX),ZALH3W2(JS,JY,JX)
     6,ZALH4W2(JS,JY,JX),ZALSW2(JS,JY,JX),ZFEH1W2(JS,JY,JX)
     7,ZFEH2W2(JS,JY,JX),ZFEH3W2(JS,JY,JX),ZFEH4W2(JS,JY,JX)
     8,ZFESW2(JS,JY,JX),ZCAOW2(JS,JY,JX),ZCACW2(JS,JY,JX)
     9,ZCAHW2(JS,JY,JX),ZCASW2(JS,JY,JX),ZMGOW2(JS,JY,JX)
     1,ZMGCW2(JS,JY,JX),ZMGHW2(JS,JY,JX),ZMGSW2(JS,JY,JX)
     2,ZNACW2(JS,JY,JX),ZNASW2(JS,JY,JX),ZKASW2(JS,JY,JX)
     3,H0PO4W2(JS,JY,JX),H3PO4W2(JS,JY,JX),ZFE1PW2(JS,JY,JX)
     4,ZFE2PW2(JS,JY,JX),ZCA0PW2(JS,JY,JX),ZCA1PW2(JS,JY,JX)
     5,ZCA2PW2(JS,JY,JX),ZMG1PW2(JS,JY,JX)
      DIMENSION ZALH2(JZ,JY,JX),ZFEH2(JZ,JY,JX),ZHYH2(JZ,JY,JX)
     2,ZCCH2(JZ,JY,JX),ZMAH2(JZ,JY,JX),ZNAH2(JZ,JY,JX)
     3,ZKAH2(JZ,JY,JX),ZOHH2(JZ,JY,JX),ZSO4H2(JZ,JY,JX)
     4,ZCLH2(JZ,JY,JX),ZCO3H2(JZ,JY,JX),ZHCOH2(JZ,JY,JX)
     5,ZAL1H2(JZ,JY,JX),ZAL2H2(JZ,JY,JX),ZAL3H2(JZ,JY,JX)
     6,ZAL4H2(JZ,JY,JX),ZALSH2(JZ,JY,JX),ZFE1H2(JZ,JY,JX)
     7,ZFE2H2(JZ,JY,JX),ZFE3H2(JZ,JY,JX),ZFE4H2(JZ,JY,JX)
     8,ZFESH2(JZ,JY,JX),ZCAOH2(JZ,JY,JX),ZCACH2(JZ,JY,JX)
     9,ZCAHH2(JZ,JY,JX),ZCASH2(JZ,JY,JX),ZMGOH2(JZ,JY,JX)
     1,ZMGCH2(JZ,JY,JX),ZMGHH2(JZ,JY,JX),ZMGSH2(JZ,JY,JX)
     2,ZNACH2(JZ,JY,JX),ZNASH2(JZ,JY,JX),ZKASH2(JZ,JY,JX)
     3,H0P4H2(JZ,JY,JX),H3P4H2(JZ,JY,JX)
     4,ZF1PH2(JZ,JY,JX),ZF2PH2(JZ,JY,JX),ZC0PH2(JZ,JY,JX)
     5,ZC1PH2(JZ,JY,JX),ZC2PH2(JZ,JY,JX),ZM1PH2(JZ,JY,JX)
     6,H0PBH2(JZ,JY,JX),H3PBH2(JZ,JY,JX)
     7,ZF1BH2(JZ,JY,JX),ZF2BH2(JZ,JY,JX),ZC0BH2(JZ,JY,JX)
     8,ZC1BH2(JZ,JY,JX),ZC2BH2(JZ,JY,JX),ZM1BH2(JZ,JY,JX)
      DIMENSION ALSGL2(JZ,JY,JX),FESGL2(JZ,JY,JX),HYSGL2(JZ,JY,JX)
     2,CASGL2(JZ,JY,JX),GMSGL2(JZ,JY,JX),ANSGL2(JZ,JY,JX)
     3,AKSGL2(JZ,JY,JX),OHSGL2(JZ,JY,JX),C3SGL2(JZ,JY,JX)
     4,HCSGL2(JZ,JY,JX),SOSGL2(JZ,JY,JX),CLSXL2(JZ,JY,JX)
     5,RQRAL(2,2,JV,JH),RQRFE(2,2,JV,JH),RQRHY(2,2,JV,JH)
     5,RQRCA(2,2,JV,JH),RQRMG(2,2,JV,JH),RQRNA(2,2,JV,JH)
     6,RQRKA(2,2,JV,JH),RQROH(2,2,JV,JH),RQRSO(2,2,JV,JH)
     7,RQRCL(2,2,JV,JH),RQRC3(2,2,JV,JH),RQRHC(2,2,JV,JH)
     8,RQRAL1(2,2,JV,JH),RQRAL2(2,2,JV,JH),RQRAL3(2,2,JV,JH)
     9,RQRAL4(2,2,JV,JH),RQRALS(2,2,JV,JH),RQRFE1(2,2,JV,JH)
     1,RQRFE2(2,2,JV,JH),RQRFE3(2,2,JV,JH),RQRFE4(2,2,JV,JH)
     2,RQRFES(2,2,JV,JH),RQRCAO(2,2,JV,JH),RQRCAC(2,2,JV,JH)
     3,RQRCAH(2,2,JV,JH),RQRCAS(2,2,JV,JH),RQRMGO(2,2,JV,JH)
     4,RQRMGC(2,2,JV,JH),RQRMGH(2,2,JV,JH),RQRMGS(2,2,JV,JH)
     5,RQRNAC(2,2,JV,JH),RQRNAS(2,2,JV,JH),RQRKAS(2,2,JV,JH)
     5,RQRH0P(2,2,JV,JH),RQRH3P(2,2,JV,JH),RQRF1P(2,2,JV,JH)
     6,RQRF2P(2,2,JV,JH),RQRC0P(2,2,JV,JH),RQRC1P(2,2,JV,JH)
     7,RQRC2P(2,2,JV,JH),RQRM1P(2,2,JV,JH)
     5,RQSAL(2,JV,JH),RQSFE(2,JV,JH),RQSHY(2,JV,JH),RQSCA(2,JV,JH)
     6,RQSMG(2,JV,JH),RQSNA(2,JV,JH),RQSKA(2,JV,JH),RQSOH(2,JV,JH)
     7,RQSSO(2,JV,JH),RQSCL(2,JV,JH),RQSC3(2,JV,JH),RQSHC(2,JV,JH)
     8,RQSAL1(2,JV,JH),RQSAL2(2,JV,JH),RQSAL3(2,JV,JH)
     9,RQSAL4(2,JV,JH),RQSALS(2,JV,JH),RQSFE1(2,JV,JH)
     1,RQSFE2(2,JV,JH),RQSFE3(2,JV,JH),RQSFE4(2,JV,JH)
     2,RQSFES(2,JV,JH),RQSCAO(2,JV,JH),RQSCAC(2,JV,JH)
     3,RQSCAH(2,JV,JH),RQSCAS(2,JV,JH),RQSMGO(2,JV,JH),RQSMGC(2,JV,JH)
     4,RQSMGH(2,JV,JH),RQSMGS(2,JV,JH),RQSNAC(2,JV,JH),RQSNAS(2,JV,JH)
     5,RQSKAS(2,JV,JH),RQSH0P(2,JV,JH),RQSH3P(2,JV,JH)
     6,RQSF1P(2,JV,JH),RQSF2P(2,JV,JH),RQSC0P(2,JV,JH),RQSC1P(2,JV,JH)
     7,RQSC2P(2,JV,JH),RQSM1P(2,JV,JH)
      DIMENSION RALFLS(3,0:JD,JV,JH),RFEFLS(3,0:JD,JV,JH)
     2,RHYFLS(3,0:JD,JV,JH),RCAFLS(3,0:JD,JV,JH),RMGFLS(3,0:JD,JV,JH)
     3,RNAFLS(3,0:JD,JV,JH),RKAFLS(3,0:JD,JV,JH),ROHFLS(3,0:JD,JV,JH)
     4,RSOFLS(3,0:JD,JV,JH),RCLFLS(3,0:JD,JV,JH),RC3FLS(3,0:JD,JV,JH)
     5,RHCFLS(3,0:JD,JV,JH),RAL1FS(3,0:JD,JV,JH),RAL2FS(3,0:JD,JV,JH)
     6,RAL3FS(3,0:JD,JV,JH),RAL4FS(3,0:JD,JV,JH),RALSFS(3,0:JD,JV,JH)
     7,RFE1FS(3,0:JD,JV,JH),RFE2FS(3,0:JD,JV,JH),RFE3FS(3,0:JD,JV,JH)
     8,RFE4FS(3,0:JD,JV,JH),RFESFS(3,0:JD,JV,JH),RCAOFS(3,0:JD,JV,JH)
     9,RCACFS(3,0:JD,JV,JH),RCAHFS(3,0:JD,JV,JH)
     1,RCASFS(3,0:JD,JV,JH),RMGOFS(3,0:JD,JV,JH),RMGCFS(3,0:JD,JV,JH)
     2,RMGHFS(3,0:JD,JV,JH),RMGSFS(3,0:JD,JV,JH),RNACFS(3,0:JD,JV,JH)
     3,RNASFS(3,0:JD,JV,JH),RKASFS(3,0:JD,JV,JH),RH0PFS(3,0:JD,JV,JH)
     4,RH3PFS(3,0:JD,JV,JH),RF1PFS(3,0:JD,JV,JH)
     5,RF2PFS(3,0:JD,JV,JH),RC0PFS(3,0:JD,JV,JH),RC1PFS(3,0:JD,JV,JH)
     6,RC2PFS(3,0:JD,JV,JH),RM1PFS(3,0:JD,JV,JH),RH0BFB(3,0:JD,JV,JH)
     7,RH3BFB(3,0:JD,JV,JH),RF1BFB(3,0:JD,JV,JH)
     8,RF2BFB(3,0:JD,JV,JH),RC0BFB(3,0:JD,JV,JH),RC1BFB(3,0:JD,JV,JH)
     9,RC2BFB(3,0:JD,JV,JH),RM1BFB(3,0:JD,JV,JH)
      DIMENSION RALFHS(3,JD,JV,JH),RFEFHS(3,JD,JV,JH)
     2,RHYFHS(3,JD,JV,JH),RCAFHS(3,JD,JV,JH),RMGFHS(3,JD,JV,JH)
     3,RNAFHS(3,JD,JV,JH),RKAFHS(3,JD,JV,JH),ROHFHS(3,JD,JV,JH)
     4,RC3FHS(3,JD,JV,JH),RHCFHS(3,JD,JV,JH),RSOFHS(3,JD,JV,JH)
     5,RCLFHS(3,JD,JV,JH),RAL1HS(3,JD,JV,JH),RAL2HS(3,JD,JV,JH)
     6,RAL3HS(3,JD,JV,JH),RAL4HS(3,JD,JV,JH),RALSHS(3,JD,JV,JH)
     7,RFE1HS(3,JD,JV,JH),RFE2HS(3,JD,JV,JH),RFE3HS(3,JD,JV,JH)
     8,RFE4HS(3,JD,JV,JH),RFESHS(3,JD,JV,JH),RCAOHS(3,JD,JV,JH)
     9,RCACHS(3,JD,JV,JH),RCAHHS(3,JD,JV,JH)
     1,RCASHS(3,JD,JV,JH),RMGOHS(3,JD,JV,JH),RMGCHS(3,JD,JV,JH)
     2,RMGHHS(3,JD,JV,JH),RMGSHS(3,JD,JV,JH),RNACHS(3,JD,JV,JH)
     3,RNASHS(3,JD,JV,JH),RKASHS(3,JD,JV,JH),RH0PHS(3,JD,JV,JH)
     4,RH3PHS(3,JD,JV,JH),RF1PHS(3,JD,JV,JH)
     5,RF2PHS(3,JD,JV,JH),RC0PHS(3,JD,JV,JH),RC1PHS(3,JD,JV,JH)
     6,RC2PHS(3,JD,JV,JH),RM1PHS(3,JD,JV,JH),RH0BHB(3,JD,JV,JH)
     7,RH3BHB(3,JD,JV,JH),RF1BHB(3,JD,JV,JH)
     8,RF2BHB(3,JD,JV,JH),RC0BHB(3,JD,JV,JH),RC1BHB(3,JD,JV,JH)
     9,RC2BHB(3,JD,JV,JH),RM1BHB(3,JD,JV,JH)
      DIMENSION TQRAL(JY,JX),TQRFE(JY,JX),TQRHY(JY,JX)
     2,TQRCA(JY,JX),TQRMG(JY,JX),TQRNA(JY,JX),TQRKA(JY,JX)
     3,TQROH(JY,JX),TQRSO(JY,JX),TQRCL(JY,JX),TQRC3(JY,JX)
     4,TQRHC(JY,JX),TQRAL1(JY,JX),TQRAL2(JY,JX),TQRAL3(JY,JX)
     5,TQRAL4(JY,JX),TQRALS(JY,JX),TQRFE1(JY,JX),TQRFE2(JY,JX)
     6,TQRFE3(JY,JX),TQRFE4(JY,JX),TQRFES(JY,JX),TQRCAO(JY,JX)
     7,TQRCAC(JY,JX),TQRCAH(JY,JX),TQRCAS(JY,JX),TQRMGO(JY,JX)
     8,TQRMGC(JY,JX),TQRMGH(JY,JX),TQRMGS(JY,JX),TQRNAC(JY,JX)
     9,TQRNAS(JY,JX),TQRKAS(JY,JX),TQRH0P(JY,JX) 
     1,TQRH3P(JY,JX),TQRF1P(JY,JX),TQRF2P(JY,JX),TQRC0P(JY,JX)
     2,TQRC1P(JY,JX),TQRC2P(JY,JX),TQRM1P(JY,JX)
      DIMENSION TQSAL(JY,JX),TQSFE(JY,JX),TQSHY(JY,JX)
     2,TQSCA(JY,JX),TQSMG(JY,JX),TQSNA(JY,JX),TQSKA(JY,JX)
     3,TQSOH(JY,JX),TQSSO(JY,JX),TQSCL(JY,JX),TQSC3(JY,JX)
     4,TQSHC(JY,JX),TQSAL1(JY,JX),TQSAL2(JY,JX),TQSAL3(JY,JX)
     5,TQSAL4(JY,JX),TQSALS(JY,JX),TQSFE1(JY,JX),TQSFE2(JY,JX)
     6,TQSFE3(JY,JX),TQSFE4(JY,JX),TQSFES(JY,JX),TQSCAO(JY,JX)
     7,TQSCAC(JY,JX),TQSCAH(JY,JX),TQSCAS(JY,JX),TQSMGO(JY,JX)
     8,TQSMGC(JY,JX),TQSMGH(JY,JX),TQSMGS(JY,JX),TQSNAC(JY,JX)
     9,TQSNAS(JY,JX),TQSKAS(JY,JX),TQSH0P(JY,JX)
     1,TQSH3P(JY,JX),TQSF1P(JY,JX),TQSF2P(JY,JX),TQSC0P(JY,JX)
     2,TQSC1P(JY,JX),TQSC2P(JY,JX),TQSM1P(JY,JX)
      DIMENSION TALFLS(JZ,JY,JX),TFEFLS(JZ,JY,JX)
     1,TCAFLS(JZ,JY,JX),THYFLS(JZ,JY,JX),TMGFLS(JZ,JY,JX)
     2,TNAFLS(JZ,JY,JX),TKAFLS(JZ,JY,JX),TOHFLS(JZ,JY,JX)
     3,TSOFLS(JZ,JY,JX),TCLFLS(JZ,JY,JX),TC3FLS(JZ,JY,JX)
     4,THCFLS(JZ,JY,JX),TAL1FS(JZ,JY,JX),TAL2FS(JZ,JY,JX)
     5,TAL3FS(JZ,JY,JX),TAL4FS(JZ,JY,JX),TALSFS(JZ,JY,JX)
     6,TFE1FS(JZ,JY,JX),TFE2FS(JZ,JY,JX),TFE3FS(JZ,JY,JX)
     7,TFE4FS(JZ,JY,JX),TFESFS(JZ,JY,JX)
     8,TCAOFS(JZ,JY,JX),TCACFS(JZ,JY,JX),TCAHFS(JZ,JY,JX)
     9,TCASFS(JZ,JY,JX),TMGOFS(JZ,JY,JX),TMGCFS(JZ,JY,JX)
     1,TMGHFS(JZ,JY,JX),TMGSFS(JZ,JY,JX),TNACFS(JZ,JY,JX)
     2,TNASFS(JZ,JY,JX),TKASFS(JZ,JY,JX),TH0PFS(JZ,JY,JX)
     3,TH3PFS(JZ,JY,JX),TF1PFS(JZ,JY,JX)
     4,TF2PFS(JZ,JY,JX),TC0PFS(JZ,JY,JX),TC1PFS(JZ,JY,JX)
     5,TC2PFS(JZ,JY,JX),TM1PFS(JZ,JY,JX),TH0BFB(JZ,JY,JX)
     6,TH3BFB(JZ,JY,JX),TF1BFB(JZ,JY,JX)
     7,TF2BFB(JZ,JY,JX),TC0BFB(JZ,JY,JX),TC1BFB(JZ,JY,JX)
     8,TC2BFB(JZ,JY,JX),TM1BFB(JZ,JY,JX)
      DIMENSION TALFHS(JZ,JY,JX),TFEFHS(JZ,JY,JX)
     1,THYFHS(JZ,JY,JX),TCAFHS(JZ,JY,JX),TMGFHS(JZ,JY,JX)
     2,TNAFHS(JZ,JY,JX),TKAFHS(JZ,JY,JX),TOHFHS(JZ,JY,JX)
     3,TSOFHS(JZ,JY,JX),TCLFHS(JZ,JY,JX),TC3FHS(JZ,JY,JX)
     4,THCFHS(JZ,JY,JX),TAL1HS(JZ,JY,JX),TAL2HS(JZ,JY,JX)
     5,TAL3HS(JZ,JY,JX),TAL4HS(JZ,JY,JX),TALSHS(JZ,JY,JX)
     6,TFE1HS(JZ,JY,JX),TFE2HS(JZ,JY,JX),TFE3HS(JZ,JY,JX)
     7,TFE4HS(JZ,JY,JX),TFESHS(JZ,JY,JX)
     8,TCAOHS(JZ,JY,JX),TCACHS(JZ,JY,JX),TCAHHS(JZ,JY,JX)
     9,TCASHS(JZ,JY,JX),TMGOHS(JZ,JY,JX),TMGCHS(JZ,JY,JX)
     1,TMGHHS(JZ,JY,JX),TMGSHS(JZ,JY,JX),TNACHS(JZ,JY,JX)
     2,TNASHS(JZ,JY,JX),TKASHS(JZ,JY,JX),TH0PHS(JZ,JY,JX)
     3,TH3PHS(JZ,JY,JX),TF1PHS(JZ,JY,JX)
     4,TF2PHS(JZ,JY,JX),TC0PHS(JZ,JY,JX),TC1PHS(JZ,JY,JX)
     5,TC2PHS(JZ,JY,JX),TM1PHS(JZ,JY,JX),TH0BHB(JZ,JY,JX)
     6,TH3BHB(JZ,JY,JX),TF1BHB(JZ,JY,JX)
     7,TF2BHB(JZ,JY,JX),TC0BHB(JZ,JY,JX),TC1BHB(JZ,JY,JX)
     8,TC2BHB(JZ,JY,JX),TM1BHB(JZ,JY,JX)
      DIMENSION RALFLZ(JZ,JY,JX)
     5,RFEFLZ(JZ,JY,JX),RHYFLZ(JZ,JY,JX)
     6,RCAFLZ(JZ,JY,JX),RMGFLZ(JZ,JY,JX),RNAFLZ(JZ,JY,JX)
     7,RKAFLZ(JZ,JY,JX),ROHFLZ(JZ,JY,JX),RSOFLZ(JZ,JY,JX)
     8,RCLFLZ(JZ,JY,JX),RC3FLZ(JZ,JY,JX),RHCFLZ(JZ,JY,JX)
     9,RAL1FZ(JZ,JY,JX),RAL2FZ(JZ,JY,JX),RAL3FZ(JZ,JY,JX)
     1,RAL4FZ(JZ,JY,JX),RALSFZ(JZ,JY,JX),RCAOFZ(JZ,JY,JX)
     2,RFE1FZ(JZ,JY,JX),RFE2FZ(JZ,JY,JX),RFE3FZ(JZ,JY,JX)
     3,RFE4FZ(JZ,JY,JX),RFESFZ(JZ,JY,JX),RCACFZ(JZ,JY,JX)
     4,RCAHFZ(JZ,JY,JX),RCASFZ(JZ,JY,JX),RMGOFZ(JZ,JY,JX)
     5,RMGCFZ(JZ,JY,JX),RMGHFZ(JZ,JY,JX),RMGSFZ(JZ,JY,JX)
     6,RNACFZ(JZ,JY,JX),RNASFZ(JZ,JY,JX),RKASFZ(JZ,JY,JX)
      DIMENSION RH0PFZ(JZ,JY,JX),RH3PFZ(JZ,JY,JX)
     1,RF1PFZ(JZ,JY,JX),RF2PFZ(JZ,JY,JX),RC0PFZ(JZ,JY,JX)
     2,RC1PFZ(JZ,JY,JX),RC2PFZ(JZ,JY,JX),RM1PFZ(JZ,JY,JX)
     3,RH0BBZ(JZ,JY,JX),RH3BBZ(JZ,JY,JX)
     4,RF1BBZ(JZ,JY,JX),RF2BBZ(JZ,JY,JX),RC0BBZ(JZ,JY,JX)
     5,RC1BBZ(JZ,JY,JX),RC2BBZ(JZ,JY,JX),RM1BBZ(JZ,JY,JX)
      DIMENSION RALFXS(JZ,JY,JX)
     7,RFEFXS(JZ,JY,JX),RHYFXS(JZ,JY,JX),RCAFXS(JZ,JY,JX)
     8,RMGFXS(JZ,JY,JX),RNAFXS(JZ,JY,JX),RKAFXS(JZ,JY,JX)
     9,ROHFXS(JZ,JY,JX),RSOFXS(JZ,JY,JX),RCLFXS(JZ,JY,JX)
     1,RC3FXS(JZ,JY,JX),RHCFXS(JZ,JY,JX),RAL1XS(JZ,JY,JX)
     2,RAL2XS(JZ,JY,JX),RAL3XS(JZ,JY,JX),RAL4XS(JZ,JY,JX)
     3,RALSXS(JZ,JY,JX),RFE1XS(JZ,JY,JX),RFE2XS(JZ,JY,JX)
     4,RFE3XS(JZ,JY,JX),RFE4XS(JZ,JY,JX),RFESXS(JZ,JY,JX)
     5,RCACXS(JZ,JY,JX),RCAOXS(JZ,JY,JX),RCAHXS(JZ,JY,JX)
     6,RCASXS(JZ,JY,JX),RMGOXS(JZ,JY,JX),RMGCXS(JZ,JY,JX)
     7,RMGHXS(JZ,JY,JX),RMGSXS(JZ,JY,JX),RNACXS(JZ,JY,JX)
     8,RNASXS(JZ,JY,JX),RKASXS(JZ,JY,JX)
      DIMENSION RH0PXS(JZ,JY,JX),RH3PXS(JZ,JY,JX)
     1,RF1PXS(JZ,JY,JX),RF2PXS(JZ,JY,JX),RC0PXS(JZ,JY,JX)
     2,RC1PXS(JZ,JY,JX),RC2PXS(JZ,JY,JX),RM1PXS(JZ,JY,JX)
     3,RH0BXB(JZ,JY,JX),RH3BXB(JZ,JY,JX)
     4,RF1BXB(JZ,JY,JX),RF2BXB(JZ,JY,JX),RC0BXB(JZ,JY,JX)
     5,RC1BXB(JZ,JY,JX),RC2BXB(JZ,JY,JX),RM1BXB(JZ,JY,JX)
      DIMENSION RALBLS(JS,JY,JX),RFEBLS(JS,JY,JX),RHYBLS(JS,JY,JX)
     2,RCABLS(JS,JY,JX),RMGBLS(JS,JY,JX),RNABLS(JS,JY,JX)
     3,RKABLS(JS,JY,JX),ROHBLS(JS,JY,JX),RSOBLS(JS,JY,JX)
     4,RCLBLS(JS,JY,JX),RC3BLS(JS,JY,JX),RHCBLS(JS,JY,JX)
     5,RAL1BS(JS,JY,JX),RAL2BS(JS,JY,JX),RAL3BS(JS,JY,JX)
     6,RAL4BS(JS,JY,JX),RALSBS(JS,JY,JX),RFE1BS(JS,JY,JX)
     7,RFE2BS(JS,JY,JX),RFE3BS(JS,JY,JX),RFE4BS(JS,JY,JX)
     8,RFESBS(JS,JY,JX),RCAOBS(JS,JY,JX),RCACBS(JS,JY,JX)
     9,RCAHBS(JS,JY,JX),RCASBS(JS,JY,JX),RMGOBS(JS,JY,JX)
     1,RMGCBS(JS,JY,JX),RMGHBS(JS,JY,JX),RMGSBS(JS,JY,JX)
     2,RNACBS(JS,JY,JX),RNASBS(JS,JY,JX),RKASBS(JS,JY,JX)
     3,RH0PBS(JS,JY,JX),RH3PBS(JS,JY,JX),RF1PBS(JS,JY,JX)
     4,RF2PBS(JS,JY,JX),RC0PBS(JS,JY,JX),RC1PBS(JS,JY,JX)
     5,RC2PBS(JS,JY,JX),RM1PBS(JS,JY,JX),TALBLS(JS,JY,JX)
     6,TFEBLS(JS,JY,JX),THYBLS(JS,JY,JX),TCABLS(JS,JY,JX)
     7,TMGBLS(JS,JY,JX),TNABLS(JS,JY,JX),TKABLS(JS,JY,JX)
     8,TOHBLS(JS,JY,JX),TSOBLS(JS,JY,JX),TCLBLS(JS,JY,JX)
     9,TC3BLS(JS,JY,JX),THCBLS(JS,JY,JX),TAL1BS(JS,JY,JX)
     1,TAL2BS(JS,JY,JX),TAL3BS(JS,JY,JX),TAL4BS(JS,JY,JX)
     2,TALSBS(JS,JY,JX),TFE1BS(JS,JY,JX),TFE2BS(JS,JY,JX)
     3,TFE3BS(JS,JY,JX),TFE4BS(JS,JY,JX),TFESBS(JS,JY,JX)
     4,TCAOBS(JS,JY,JX),TCACBS(JS,JY,JX),TCAHBS(JS,JY,JX)
     5,TCASBS(JS,JY,JX),TMGOBS(JS,JY,JX),TMGCBS(JS,JY,JX)
     6,TMGHBS(JS,JY,JX),TMGSBS(JS,JY,JX),TNACBS(JS,JY,JX)
     7,TNASBS(JS,JY,JX),TKASBS(JS,JY,JX),TH0PBS(JS,JY,JX)
     8,TH3PBS(JS,JY,JX),TF1PBS(JS,JY,JX),TF2PBS(JS,JY,JX)
     9,TC0PBS(JS,JY,JX),TC1PBS(JS,JY,JX),TC2PBS(JS,JY,JX)
     1,TM1PBS(JS,JY,JX)
      DIMENSION RALFL0(JY,JX),RFEFL0(JY,JX),RHYFL0(JY,JX)
     2,RCAFL0(JY,JX),RMGFL0(JY,JX),RNAFL0(JY,JX),RKAFL0(JY,JX)
     3,ROHFL0(JY,JX),RSOFL0(JY,JX),RCLFL0(JY,JX),RC3FL0(JY,JX)
     4,RHCFL0(JY,JX),RAL1F0(JY,JX),RAL2F0(JY,JX),RAL3F0(JY,JX)
     5,RAL4F0(JY,JX),RALSF0(JY,JX),RFE1F0(JY,JX),RFE2F0(JY,JX)
     6,RFE3F0(JY,JX),RFE4F0(JY,JX),RFESF0(JY,JX),RCAOF0(JY,JX)
     7,RCACF0(JY,JX),RCAHF0(JY,JX),RCASF0(JY,JX),RMGOF0(JY,JX)
     8,RMGCF0(JY,JX),RMGHF0(JY,JX),RMGSF0(JY,JX),RNACF0(JY,JX)
     9,RNASF0(JY,JX),RKASF0(JY,JX),RH0PF0(JY,JX),RH3PF0(JY,JX)
     1,RF1PF0(JY,JX),RF2PF0(JY,JX),RC0PF0(JY,JX),RC1PF0(JY,JX)
     2,RC2PF0(JY,JX),RM1PF0(JY,JX),RALFL1(JY,JX),RFEFL1(JY,JX)
     3,RHYFL1(JY,JX),RCAFL1(JY,JX),RMGFL1(JY,JX),RNAFL1(JY,JX)
     4,RKAFL1(JY,JX),ROHFL1(JY,JX),RSOFL1(JY,JX),RCLFL1(JY,JX)
     5,RC3FL1(JY,JX),RHCFL1(JY,JX),RAL1F1(JY,JX),RAL2F1(JY,JX)
     6,RAL3F1(JY,JX),RAL4F1(JY,JX),RALSF1(JY,JX),RFE1F1(JY,JX)
     7,RFE2F1(JY,JX),RFE3F1(JY,JX),RFE4F1(JY,JX),RFESF1(JY,JX)
     8,RCAOF1(JY,JX),RCACF1(JY,JX),RCAHF1(JY,JX),RCASF1(JY,JX)
     9,RMGOF1(JY,JX),RMGCF1(JY,JX),RMGHF1(JY,JX),RMGSF1(JY,JX)
     1,RNACF1(JY,JX),RNASF1(JY,JX),RKASF1(JY,JX),RH0PF1(JY,JX)
     2,RH3PF1(JY,JX),RF1PF1(JY,JX),RF2PF1(JY,JX),RC0PF1(JY,JX)
     3,RC1PF1(JY,JX),RC2PF1(JY,JX),RM1PF1(JY,JX),RH0BF2(JY,JX)
     4,RH3BF2(JY,JX),RF1BF2(JY,JX),RF2BF2(JY,JX),RC0BF2(JY,JX)
     5,RC1BF2(JY,JX),RC2BF2(JY,JX),RM1BF2(JY,JX)
      DIMENSION RQRAL0(JY,JX),RQRFE0(JY,JX),RQRHY0(JY,JX)
     2,RQRCA0(JY,JX),RQRMG0(JY,JX),RQRNA0(JY,JX),RQRKA0(JY,JX)
     3,RQROH0(JY,JX),RQRSO0(JY,JX),RQRCL0(JY,JX),RQRC30(JY,JX)
     4,RQRHC0(JY,JX),RQRAL10(JY,JX),RQRAL20(JY,JX),RQRAL30(JY,JX)
     5,RQRAL40(JY,JX),RQRALS0(JY,JX),RQRFE10(JY,JX),RQRFE20(JY,JX)
     6,RQRFE30(JY,JX),RQRFE40(JY,JX),RQRFES0(JY,JX),RQRCAO0(JY,JX)
     7,RQRCAC0(JY,JX),RQRCAH0(JY,JX),RQRCAS0(JY,JX),RQRMGO0(JY,JX)
     8,RQRMGC0(JY,JX),RQRMGH0(JY,JX),RQRMGS0(JY,JX),RQRNAC0(JY,JX)
     9,RQRNAS0(JY,JX),RQRKAS0(JY,JX),RQRH0P0(JY,JX),RQRH3P0(JY,JX)
     1,RQRF1P0(JY,JX),RQRF2P0(JY,JX),RQRC0P0(JY,JX),RQRC1P0(JY,JX)
     2,RQRC2P0(JY,JX),RQRM1P0(JY,JX)
      DIMENSION THETW1(JZ,JY,JX),FLWU(JZ,JY,JX)
     2,POSGL2(JZ,JY,JX)
      PARAMETER (VFLWX=0.5,XFRS=0.05)
C
C     TIME STEPS FOR SOLUTE FLUX CALCULATIONS
C

      DO 9995 NX=NHW,NHE
      DO 9990 NY=NVN,NVS
      IF(ISALTG.NE.0)THEN
C
C     HOURLY SOLUTE FLUXES FROM ATMOSPHERE TO SNOWPACK
C     IN SNOWFALL AND IRRIGATION ACCORDING TO CONCENTRATIONS
C     ENTERED IN WEATHER AND IRRIGATION FILES
C
C     PRECW,PRECR=snow,rain 
C     VHCPWM,VHCPWX=current,minimum volumetric heat capacity of snowpack
C     X*BLS=hourly solute flux to snowpack
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C     FLQGQ,FLQGI=water flux to snowpack from rain,irrigation
C     C*R,C*Q=precipitation,irrigation solute concentrations
C
      IF(PRECW(NY,NX).GT.0.0.OR.(PRECR(NY,NX).GT.0.0
     2.AND.VHCPWM(1,1,NY,NX).GT.VHCPWX(NY,NX)))THEN
      XALBLS(1,NY,NX)=FLQGQ(NY,NX)*CALR(NY,NX)+FLQGI(NY,NX)
     2*CALQ(I,NY,NX)
      XFEBLS(1,NY,NX)=FLQGQ(NY,NX)*CFER(NY,NX)+FLQGI(NY,NX)
     2*CFEQ(I,NY,NX)
      XHYBLS(1,NY,NX)=FLQGQ(NY,NX)*CHYR(NY,NX)+FLQGI(NY,NX)
     2*CHYQ(I,NY,NX)
      XCABLS(1,NY,NX)=FLQGQ(NY,NX)*CCAR(NY,NX)+FLQGI(NY,NX)
     2*CCAQ(I,NY,NX)
      XMGBLS(1,NY,NX)=FLQGQ(NY,NX)*CMGR(NY,NX)+FLQGI(NY,NX)
     2*CMGQ(I,NY,NX)
      XNABLS(1,NY,NX)=FLQGQ(NY,NX)*CNAR(NY,NX)+FLQGI(NY,NX)
     2*CNAQ(I,NY,NX)
      XKABLS(1,NY,NX)=FLQGQ(NY,NX)*CKAR(NY,NX)+FLQGI(NY,NX)
     2*CKAQ(I,NY,NX)
      XOHBLS(1,NY,NX)=FLQGQ(NY,NX)*COHR(NY,NX)+FLQGI(NY,NX)
     2*COHQ(I,NY,NX)
      XSOBLS(1,NY,NX)=FLQGQ(NY,NX)*CSOR(NY,NX)+FLQGI(NY,NX)
     2*CSOQ(I,NY,NX)
      XCLBLS(1,NY,NX)=FLQGQ(NY,NX)*CCLR(NY,NX)+FLQGI(NY,NX)
     2*CCLQ(I,NY,NX)
      XC3BLS(1,NY,NX)=FLQGQ(NY,NX)*CC3R(NY,NX)+FLQGI(NY,NX)
     2*CC3Q(I,NY,NX)
      XHCBLS(1,NY,NX)=FLQGQ(NY,NX)*CHCR(NY,NX)+FLQGI(NY,NX)
     2*CHCQ(I,NY,NX)
      XAL1BS(1,NY,NX)=FLQGQ(NY,NX)*CAL1R(NY,NX)+FLQGI(NY,NX)
     2*CAL1Q(I,NY,NX)
      XAL2BS(1,NY,NX)=FLQGQ(NY,NX)*CAL2R(NY,NX)+FLQGI(NY,NX)
     2*CAL2Q(I,NY,NX)
      XAL3BS(1,NY,NX)=FLQGQ(NY,NX)*CAL3R(NY,NX)+FLQGI(NY,NX)
     2*CAL3Q(I,NY,NX)
      XAL4BS(1,NY,NX)=FLQGQ(NY,NX)*CAL4R(NY,NX)+FLQGI(NY,NX)
     2*CAL4Q(I,NY,NX)
      XALSBS(1,NY,NX)=FLQGQ(NY,NX)*CALSR(NY,NX)+FLQGI(NY,NX)
     2*CALSQ(I,NY,NX)
      XFE1BS(1,NY,NX)=FLQGQ(NY,NX)*CFE1R(NY,NX)+FLQGI(NY,NX)
     2*CFE1Q(I,NY,NX)
      XFE2BS(1,NY,NX)=FLQGQ(NY,NX)*CFE2R(NY,NX)+FLQGI(NY,NX)
     2*CFE2Q(I,NY,NX)
      XFE3BS(1,NY,NX)=FLQGQ(NY,NX)*CFE3R(NY,NX)+FLQGI(NY,NX)
     2*CFE3Q(I,NY,NX)
      XFE4BS(1,NY,NX)=FLQGQ(NY,NX)*CFE4R(NY,NX)+FLQGI(NY,NX)
     2*CFE4Q(I,NY,NX)
      XFESBS(1,NY,NX)=FLQGQ(NY,NX)*CFESR(NY,NX)+FLQGI(NY,NX)
     2*CFESQ(I,NY,NX)
      XCAOBS(1,NY,NX)=FLQGQ(NY,NX)*CCAOR(NY,NX)+FLQGI(NY,NX)
     2*CCAOQ(I,NY,NX)
      XCACBS(1,NY,NX)=FLQGQ(NY,NX)*CCACR(NY,NX)+FLQGI(NY,NX)
     2*CCACQ(I,NY,NX)
      XCAHBS(1,NY,NX)=FLQGQ(NY,NX)*CCAHR(NY,NX)+FLQGI(NY,NX)
     2*CCAHQ(I,NY,NX)
      XCASBS(1,NY,NX)=FLQGQ(NY,NX)*CCASR(NY,NX)+FLQGI(NY,NX)
     2*CCASQ(I,NY,NX)
      XMGOBS(1,NY,NX)=FLQGQ(NY,NX)*CMGOR(NY,NX)+FLQGI(NY,NX)
     2*CMGOQ(I,NY,NX)
      XMGCBS(1,NY,NX)=FLQGQ(NY,NX)*CMGCR(NY,NX)+FLQGI(NY,NX)
     2*CMGCQ(I,NY,NX)
      XMGHBS(1,NY,NX)=FLQGQ(NY,NX)*CMGHR(NY,NX)+FLQGI(NY,NX)
     2*CMGHQ(I,NY,NX)
      XMGSBS(1,NY,NX)=FLQGQ(NY,NX)*CMGSR(NY,NX)+FLQGI(NY,NX)
     2*CMGSQ(I,NY,NX)
      XNACBS(1,NY,NX)=FLQGQ(NY,NX)*CNACR(NY,NX)+FLQGI(NY,NX)
     2*CNACQ(I,NY,NX)
      XNASBS(1,NY,NX)=FLQGQ(NY,NX)*CNASR(NY,NX)+FLQGI(NY,NX)
     2*CNASQ(I,NY,NX)
      XKASBS(1,NY,NX)=FLQGQ(NY,NX)*CKASR(NY,NX)+FLQGI(NY,NX)
     2*CKASQ(I,NY,NX)
      XH0PBS(1,NY,NX)=FLQGQ(NY,NX)*CH0PR(NY,NX)+FLQGI(NY,NX)
     2*CH0PQ(I,NY,NX)
      XH3PBS(1,NY,NX)=FLQGQ(NY,NX)*CH3PR(NY,NX)+FLQGI(NY,NX)
     2*CH3PQ(I,NY,NX)
      XF1PBS(1,NY,NX)=FLQGQ(NY,NX)*CF1PR(NY,NX)+FLQGI(NY,NX)
     2*CF1PQ(I,NY,NX)
      XF2PBS(1,NY,NX)=FLQGQ(NY,NX)*CF2PR(NY,NX)+FLQGI(NY,NX)
     2*CF2PQ(I,NY,NX)
      XC0PBS(1,NY,NX)=FLQGQ(NY,NX)*CC0PR(NY,NX)+FLQGI(NY,NX)
     2*CC0PQ(I,NY,NX)
      XC1PBS(1,NY,NX)=FLQGQ(NY,NX)*CC1PR(NY,NX)+FLQGI(NY,NX)
     2*CC1PQ(I,NY,NX)
      XC2PBS(1,NY,NX)=FLQGQ(NY,NX)*CC2PR(NY,NX)+FLQGI(NY,NX)
     2*CC2PQ(I,NY,NX)
      XM1PBS(1,NY,NX)=FLQGQ(NY,NX)*CM1PR(NY,NX)+FLQGI(NY,NX)
     2*CM1PQ(I,NY,NX)
C
C     HOURLY SOLUTE FLUXES FROM ATMOSPHERE TO SOIL SURFACE
C     IN RAINFALL AND IRRIGATION ARE ZERO IF SNOWPACK IS PRESENT
C
C     X*FLS,X*FLB=hourly solute flux to micropores in non-band,band 
C
      XALFLS(3,0,NY,NX)=0.0
      XFEFLS(3,0,NY,NX)=0.0
      XHYFLS(3,0,NY,NX)=0.0
      XCAFLS(3,0,NY,NX)=0.0
      XMGFLS(3,0,NY,NX)=0.0
      XNAFLS(3,0,NY,NX)=0.0
      XKAFLS(3,0,NY,NX)=0.0
      XOHFLS(3,0,NY,NX)=0.0
      XSOFLS(3,0,NY,NX)=0.0
      XCLFLS(3,0,NY,NX)=0.0
      XC3FLS(3,0,NY,NX)=0.0
      XHCFLS(3,0,NY,NX)=0.0
      XAL1FS(3,0,NY,NX)=0.0
      XAL2FS(3,0,NY,NX)=0.0
      XAL3FS(3,0,NY,NX)=0.0
      XAL4FS(3,0,NY,NX)=0.0
      XALSFS(3,0,NY,NX)=0.0
      XFE1FS(3,0,NY,NX)=0.0
      XFE2FS(3,0,NY,NX)=0.0
      XFE3FS(3,0,NY,NX)=0.0
      XFE4FS(3,0,NY,NX)=0.0
      XFESFS(3,0,NY,NX)=0.0
      XCAOFS(3,0,NY,NX)=0.0
      XCACFS(3,0,NY,NX)=0.0
      XCAHFS(3,0,NY,NX)=0.0
      XCASFS(3,0,NY,NX)=0.0
      XMGOFS(3,0,NY,NX)=0.0
      XMGCFS(3,0,NY,NX)=0.0
      XMGHFS(3,0,NY,NX)=0.0
      XMGSFS(3,0,NY,NX)=0.0
      XNACFS(3,0,NY,NX)=0.0
      XNASFS(3,0,NY,NX)=0.0
      XKASFS(3,0,NY,NX)=0.0
      XH0PFS(3,0,NY,NX)=0.0
      XH3PFS(3,0,NY,NX)=0.0
      XF1PFS(3,0,NY,NX)=0.0
      XF2PFS(3,0,NY,NX)=0.0
      XC0PFS(3,0,NY,NX)=0.0
      XC1PFS(3,0,NY,NX)=0.0
      XC2PFS(3,0,NY,NX)=0.0
      XM1PFS(3,0,NY,NX)=0.0
      XALFLS(3,NU(NY,NX),NY,NX)=0.0
      XFEFLS(3,NU(NY,NX),NY,NX)=0.0
      XHYFLS(3,NU(NY,NX),NY,NX)=0.0
      XCAFLS(3,NU(NY,NX),NY,NX)=0.0
      XMGFLS(3,NU(NY,NX),NY,NX)=0.0
      XNAFLS(3,NU(NY,NX),NY,NX)=0.0
      XKAFLS(3,NU(NY,NX),NY,NX)=0.0
      XOHFLS(3,NU(NY,NX),NY,NX)=0.0
      XSOFLS(3,NU(NY,NX),NY,NX)=0.0
      XCLFLS(3,NU(NY,NX),NY,NX)=0.0
      XC3FLS(3,NU(NY,NX),NY,NX)=0.0
      XHCFLS(3,NU(NY,NX),NY,NX)=0.0
      XAL1FS(3,NU(NY,NX),NY,NX)=0.0
      XAL2FS(3,NU(NY,NX),NY,NX)=0.0
      XAL3FS(3,NU(NY,NX),NY,NX)=0.0
      XAL4FS(3,NU(NY,NX),NY,NX)=0.0
      XALSFS(3,NU(NY,NX),NY,NX)=0.0
      XFE1FS(3,NU(NY,NX),NY,NX)=0.0
      XFE2FS(3,NU(NY,NX),NY,NX)=0.0
      XFE3FS(3,NU(NY,NX),NY,NX)=0.0
      XFE4FS(3,NU(NY,NX),NY,NX)=0.0
      XFESFS(3,NU(NY,NX),NY,NX)=0.0
      XCAOFS(3,NU(NY,NX),NY,NX)=0.0
      XCACFS(3,NU(NY,NX),NY,NX)=0.0
      XCAHFS(3,NU(NY,NX),NY,NX)=0.0
      XCASFS(3,NU(NY,NX),NY,NX)=0.0
      XMGOFS(3,NU(NY,NX),NY,NX)=0.0
      XMGCFS(3,NU(NY,NX),NY,NX)=0.0
      XMGHFS(3,NU(NY,NX),NY,NX)=0.0
      XMGSFS(3,NU(NY,NX),NY,NX)=0.0
      XNACFS(3,NU(NY,NX),NY,NX)=0.0
      XNASFS(3,NU(NY,NX),NY,NX)=0.0
      XKASFS(3,NU(NY,NX),NY,NX)=0.0
      XH0PFS(3,NU(NY,NX),NY,NX)=0.0
      XH3PFS(3,NU(NY,NX),NY,NX)=0.0
      XF1PFS(3,NU(NY,NX),NY,NX)=0.0
      XF2PFS(3,NU(NY,NX),NY,NX)=0.0
      XC0PFS(3,NU(NY,NX),NY,NX)=0.0
      XC1PFS(3,NU(NY,NX),NY,NX)=0.0
      XC2PFS(3,NU(NY,NX),NY,NX)=0.0
      XM1PFS(3,NU(NY,NX),NY,NX)=0.0
      XH0BFB(3,NU(NY,NX),NY,NX)=0.0
      XH3BFB(3,NU(NY,NX),NY,NX)=0.0
      XF1BFB(3,NU(NY,NX),NY,NX)=0.0
      XF2BFB(3,NU(NY,NX),NY,NX)=0.0
      XC0BFB(3,NU(NY,NX),NY,NX)=0.0
      XC1BFB(3,NU(NY,NX),NY,NX)=0.0
      XC2BFB(3,NU(NY,NX),NY,NX)=0.0
      XM1BFB(3,NU(NY,NX),NY,NX)=0.0
C
C     HOURLY SOLUTE FLUXES FROM ATMOSPHERE TO SOIL SURFACE
C     IN RAINFALL AND IRRIGATION ACCORDING TO CONCENTRATIONS
C     ENTERED IN WEATHER AND IRRIGATION FILES
C
      ELSEIF((PRECQ(NY,NX).GT.0.0.OR.PRECI(NY,NX).GT.0.0)
     2.AND.VHCPWM(1,1,NY,NX).LE.VHCPWX(NY,NX))THEN
C
C     HOURLY SOLUTE FLUXES FROM ATMOSPHERE TO SNOWPACK
C     IN SNOWFALL AND IRRIGATION IS ZERO IF SNOWPACK IS ABSENT
C
C     PRECQ,PRECI=snow+rain,irrigation
C     X*BLS=hourly solute flux to snowpack
C     X*FLS,X*FLB=hourly solute flux to surface litter,soil surface micropore non-band,band
C     FLQRQ,FLQRI=water flux to surface litter from rain,irrigation
C     FLQGQ,FLQGI=water flux to soil surface from rain,irrigation
C     C*R,C*Q=precipitation,irrigation solute concentrations
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      XALBLS(1,NY,NX)=0.0
      XFEBLS(1,NY,NX)=0.0
      XHYBLS(1,NY,NX)=0.0
      XCABLS(1,NY,NX)=0.0
      XMGBLS(1,NY,NX)=0.0
      XNABLS(1,NY,NX)=0.0
      XKABLS(1,NY,NX)=0.0
      XOHBLS(1,NY,NX)=0.0
      XSOBLS(1,NY,NX)=0.0
      XCLBLS(1,NY,NX)=0.0
      XC3BLS(1,NY,NX)=0.0
      XHCBLS(1,NY,NX)=0.0
      XAL1BS(1,NY,NX)=0.0
      XAL2BS(1,NY,NX)=0.0
      XAL3BS(1,NY,NX)=0.0
      XAL4BS(1,NY,NX)=0.0
      XALSBS(1,NY,NX)=0.0
      XFE1BS(1,NY,NX)=0.0
      XFE2BS(1,NY,NX)=0.0
      XFE3BS(1,NY,NX)=0.0
      XFE4BS(1,NY,NX)=0.0
      XFESBS(1,NY,NX)=0.0
      XCAOBS(1,NY,NX)=0.0
      XCACBS(1,NY,NX)=0.0
      XCAHBS(1,NY,NX)=0.0
      XCASBS(1,NY,NX)=0.0
      XMGOBS(1,NY,NX)=0.0
      XMGCBS(1,NY,NX)=0.0
      XMGHBS(1,NY,NX)=0.0
      XMGSBS(1,NY,NX)=0.0
      XNACBS(1,NY,NX)=0.0
      XNASBS(1,NY,NX)=0.0
      XKASBS(1,NY,NX)=0.0
      XH0PBS(1,NY,NX)=0.0
      XH3PBS(1,NY,NX)=0.0
      XF1PBS(1,NY,NX)=0.0
      XF2PBS(1,NY,NX)=0.0
      XC0PBS(1,NY,NX)=0.0
      XC1PBS(1,NY,NX)=0.0
      XC2PBS(1,NY,NX)=0.0
      XM1PBS(1,NY,NX)=0.0
      XALFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CALR(NY,NX)+FLQRI(NY,NX)
     2*CALQ(I,NY,NX)
      XFEFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CFER(NY,NX)+FLQRI(NY,NX)
     2*CFEQ(I,NY,NX)
      XHYFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CHYR(NY,NX)+FLQRI(NY,NX)
     2*CHYQ(I,NY,NX)
      XCAFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CCAR(NY,NX)+FLQRI(NY,NX)
     2*CCAQ(I,NY,NX)
      XMGFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CMGR(NY,NX)+FLQRI(NY,NX)
     2*CMGQ(I,NY,NX)
      XNAFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CNAR(NY,NX)+FLQRI(NY,NX)
     2*CNAQ(I,NY,NX)
      XKAFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CKAR(NY,NX)+FLQRI(NY,NX)
     2*CKAQ(I,NY,NX)
      XOHFLS(3,0,NY,NX)=FLQRQ(NY,NX)*COHR(NY,NX)+FLQRI(NY,NX)
     2*COHQ(I,NY,NX)
      XSOFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CSOR(NY,NX)+FLQRI(NY,NX)
     2*CSOQ(I,NY,NX)
      XCLFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CCLR(NY,NX)+FLQRI(NY,NX)
     2*CCLQ(I,NY,NX)
      XC3FLS(3,0,NY,NX)=FLQRQ(NY,NX)*CC3R(NY,NX)+FLQRI(NY,NX)
     2*CC3Q(I,NY,NX)
      XHCFLS(3,0,NY,NX)=FLQRQ(NY,NX)*CHCR(NY,NX)+FLQRI(NY,NX)
     2*CHCQ(I,NY,NX)
      XAL1FS(3,0,NY,NX)=FLQRQ(NY,NX)*CAL1R(NY,NX)+FLQRI(NY,NX)
     2*CAL1Q(I,NY,NX)
      XAL2FS(3,0,NY,NX)=FLQRQ(NY,NX)*CAL2R(NY,NX)+FLQRI(NY,NX)
     2*CAL2Q(I,NY,NX)
      XAL3FS(3,0,NY,NX)=FLQRQ(NY,NX)*CAL3R(NY,NX)+FLQRI(NY,NX)
     2*CAL3Q(I,NY,NX)
      XAL4FS(3,0,NY,NX)=FLQRQ(NY,NX)*CAL4R(NY,NX)+FLQRI(NY,NX)
     2*CAL4Q(I,NY,NX)
      XALSFS(3,0,NY,NX)=FLQRQ(NY,NX)*CALSR(NY,NX)+FLQRI(NY,NX)
     2*CALSQ(I,NY,NX)
      XFE1FS(3,0,NY,NX)=FLQRQ(NY,NX)*CFE1R(NY,NX)+FLQRI(NY,NX)
     2*CFE1Q(I,NY,NX)
      XFE2FS(3,0,NY,NX)=FLQRQ(NY,NX)*CFE2R(NY,NX)+FLQRI(NY,NX)
     2*CFE2Q(I,NY,NX)
      XFE3FS(3,0,NY,NX)=FLQRQ(NY,NX)*CFE3R(NY,NX)+FLQRI(NY,NX)
     2*CFE3Q(I,NY,NX)
      XFE4FS(3,0,NY,NX)=FLQRQ(NY,NX)*CFE4R(NY,NX)+FLQRI(NY,NX)
     2*CFE4Q(I,NY,NX)
      XFESFS(3,0,NY,NX)=FLQRQ(NY,NX)*CFESR(NY,NX)+FLQRI(NY,NX)
     2*CFESQ(I,NY,NX)
      XCAOFS(3,0,NY,NX)=FLQRQ(NY,NX)*CCAOR(NY,NX)+FLQRI(NY,NX)
     2*CCAOQ(I,NY,NX)
      XCACFS(3,0,NY,NX)=FLQRQ(NY,NX)*CCACR(NY,NX)+FLQRI(NY,NX)
     2*CCACQ(I,NY,NX)
      XCAHFS(3,0,NY,NX)=FLQRQ(NY,NX)*CCAHR(NY,NX)+FLQRI(NY,NX)
     2*CCAHQ(I,NY,NX)
      XCASFS(3,0,NY,NX)=FLQRQ(NY,NX)*CCASR(NY,NX)+FLQRI(NY,NX)
     2*CCASQ(I,NY,NX)
      XMGOFS(3,0,NY,NX)=FLQRQ(NY,NX)*CMGOR(NY,NX)+FLQRI(NY,NX)
     2*CMGOQ(I,NY,NX)
      XMGCFS(3,0,NY,NX)=FLQRQ(NY,NX)*CMGCR(NY,NX)+FLQRI(NY,NX)
     2*CMGCQ(I,NY,NX)
      XMGHFS(3,0,NY,NX)=FLQRQ(NY,NX)*CMGHR(NY,NX)+FLQRI(NY,NX)
     2*CMGHQ(I,NY,NX)
      XMGSFS(3,0,NY,NX)=FLQRQ(NY,NX)*CMGSR(NY,NX)+FLQRI(NY,NX)
     2*CMGSQ(I,NY,NX)
      XNACFS(3,0,NY,NX)=FLQRQ(NY,NX)*CNACR(NY,NX)+FLQRI(NY,NX)
     2*CNACQ(I,NY,NX)
      XNASFS(3,0,NY,NX)=FLQRQ(NY,NX)*CNASR(NY,NX)+FLQRI(NY,NX)
     2*CNASQ(I,NY,NX)
      XKASFS(3,0,NY,NX)=FLQRQ(NY,NX)*CKASR(NY,NX)+FLQRI(NY,NX)
     2*CKASQ(I,NY,NX)
      XH0PFS(3,0,NY,NX)=FLQRQ(NY,NX)*CH0PR(NY,NX)+FLQRI(NY,NX)
     2*CH0PQ(I,NY,NX) 
      XH3PFS(3,0,NY,NX)=FLQRQ(NY,NX)*CH3PR(NY,NX)+FLQRI(NY,NX)
     2*CH3PQ(I,NY,NX) 
      XF1PFS(3,0,NY,NX)=FLQRQ(NY,NX)*CF1PR(NY,NX)+FLQRI(NY,NX)
     2*CF1PQ(I,NY,NX) 
      XF2PFS(3,0,NY,NX)=FLQRQ(NY,NX)*CF2PR(NY,NX)+FLQRI(NY,NX)
     2*CF2PQ(I,NY,NX) 
      XC0PFS(3,0,NY,NX)=FLQRQ(NY,NX)*CC0PR(NY,NX)+FLQRI(NY,NX)
     2*CC0PQ(I,NY,NX) 
      XC1PFS(3,0,NY,NX)=FLQRQ(NY,NX)*CC1PR(NY,NX)+FLQRI(NY,NX)
     2*CC1PQ(I,NY,NX) 
      XC2PFS(3,0,NY,NX)=FLQRQ(NY,NX)*CC2PR(NY,NX)+FLQRI(NY,NX)
     2*CC2PQ(I,NY,NX) 
      XM1PFS(3,0,NY,NX)=FLQRQ(NY,NX)*CM1PR(NY,NX)+FLQRI(NY,NX)
     2*CM1PQ(I,NY,NX) 
      XALFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CALR(NY,NX)+FLQGI(NY,NX)
     2*CALQ(I,NY,NX)
      XFEFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CFER(NY,NX)+FLQGI(NY,NX)
     2*CFEQ(I,NY,NX)
      XHYFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CHYR(NY,NX)+FLQGI(NY,NX)
     2*CHYQ(I,NY,NX)
      XCAFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CCAR(NY,NX)+FLQGI(NY,NX)
     2*CCAQ(I,NY,NX)
      XMGFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CMGR(NY,NX)+FLQGI(NY,NX)
     2*CMGQ(I,NY,NX)
      XNAFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CNAR(NY,NX)+FLQGI(NY,NX)
     2*CNAQ(I,NY,NX)
      XKAFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CKAR(NY,NX)+FLQGI(NY,NX)
     2*CKAQ(I,NY,NX)
      XOHFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*COHR(NY,NX)+FLQGI(NY,NX)
     2*COHQ(I,NY,NX)
      XSOFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CSOR(NY,NX)+FLQGI(NY,NX)
     2*CSOQ(I,NY,NX)
      XCLFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CCLR(NY,NX)+FLQGI(NY,NX)
     2*CCLQ(I,NY,NX)
      XC3FLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CC3R(NY,NX)+FLQGI(NY,NX)
     2*CC3Q(I,NY,NX)
      XHCFLS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CHCR(NY,NX)+FLQGI(NY,NX)
     2*CHCQ(I,NY,NX)
      XAL1FS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CAL1R(NY,NX)+FLQGI(NY,NX)
     2*CAL1Q(I,NY,NX)
      XAL2FS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CAL2R(NY,NX)+FLQGI(NY,NX)
     2*CAL2Q(I,NY,NX)
      XAL3FS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CAL3R(NY,NX)+FLQGI(NY,NX)
     2*CAL3Q(I,NY,NX)
      XAL4FS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CAL4R(NY,NX)+FLQGI(NY,NX)
     2*CAL4Q(I,NY,NX)
      XALSFS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CALSR(NY,NX)+FLQGI(NY,NX)
     2*CALSQ(I,NY,NX)
      XFE1FS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CFE1R(NY,NX)+FLQGI(NY,NX)
     2*CFE1Q(I,NY,NX)
      XFE2FS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CFE2R(NY,NX)+FLQGI(NY,NX)
     2*CFE2Q(I,NY,NX)
      XFE3FS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CFE3R(NY,NX)+FLQGI(NY,NX)
     2*CFE3Q(I,NY,NX)
      XFE4FS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CFE4R(NY,NX)+FLQGI(NY,NX)
     2*CFE4Q(I,NY,NX)
      XFESFS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CFESR(NY,NX)+FLQGI(NY,NX)
     2*CFESQ(I,NY,NX)
      XCAOFS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CCAOR(NY,NX)+FLQGI(NY,NX)
     2*CCAOQ(I,NY,NX)
      XCACFS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CCACR(NY,NX)+FLQGI(NY,NX)
     2*CCACQ(I,NY,NX)
      XCAHFS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CCAHR(NY,NX)+FLQGI(NY,NX)
     2*CCAHQ(I,NY,NX)
      XCASFS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CCASR(NY,NX)+FLQGI(NY,NX)
     2*CCASQ(I,NY,NX)
      XMGOFS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CMGOR(NY,NX)+FLQGI(NY,NX)
     2*CMGOQ(I,NY,NX)
      XMGCFS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CMGCR(NY,NX)+FLQGI(NY,NX)
     2*CMGCQ(I,NY,NX)
      XMGHFS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CMGHR(NY,NX)+FLQGI(NY,NX)
     2*CMGHQ(I,NY,NX)
      XMGSFS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CMGSR(NY,NX)+FLQGI(NY,NX)
     2*CMGSQ(I,NY,NX)
      XNACFS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CNACR(NY,NX)+FLQGI(NY,NX)
     2*CNACQ(I,NY,NX)
      XNASFS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CNASR(NY,NX)+FLQGI(NY,NX)
     2*CNASQ(I,NY,NX)
      XKASFS(3,NU(NY,NX),NY,NX)=FLQGQ(NY,NX)*CKASR(NY,NX)+FLQGI(NY,NX)
     2*CKASQ(I,NY,NX)
      XH0PFS(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CH0PR(NY,NX)+FLQGI(NY,NX)
     2*CH0PQ(I,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      XH3PFS(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CH3PR(NY,NX)+FLQGI(NY,NX)
     2*CH3PQ(I,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      XF1PFS(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CF1PR(NY,NX)+FLQGI(NY,NX)
     2*CF1PQ(I,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      XF2PFS(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CF2PR(NY,NX)+FLQGI(NY,NX)
     2*CF2PQ(I,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      XC0PFS(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CC0PR(NY,NX)+FLQGI(NY,NX)
     2*CC0PQ(I,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      XC1PFS(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CC1PR(NY,NX)+FLQGI(NY,NX)
     2*CC1PQ(I,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      XC2PFS(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CC2PR(NY,NX)+FLQGI(NY,NX)
     2*CC2PQ(I,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      XM1PFS(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CM1PR(NY,NX)+FLQGI(NY,NX)
     2*CM1PQ(I,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      XH0BFB(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CH0PR(NY,NX)+FLQGI(NY,NX)
     2*CH0PQ(I,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      XH3BFB(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CH3PR(NY,NX)+FLQGI(NY,NX)
     2*CH3PQ(I,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      XF1BFB(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CF1PR(NY,NX)+FLQGI(NY,NX)
     2*CF1PQ(I,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      XF2BFB(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CF2PR(NY,NX)+FLQGI(NY,NX)
     2*CF2PQ(I,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      XC0BFB(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CC0PR(NY,NX)+FLQGI(NY,NX)
     2*CC0PQ(I,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      XC1BFB(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CC1PR(NY,NX)+FLQGI(NY,NX)
     2*CC1PQ(I,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      XC2BFB(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CC2PR(NY,NX)+FLQGI(NY,NX)
     2*CC2PQ(I,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      XM1BFB(3,NU(NY,NX),NY,NX)=(FLQGQ(NY,NX)*CM1PR(NY,NX)+FLQGI(NY,NX)
     2*CM1PQ(I,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
C
C     NO SOLUTE FLUXES FROM ATMOSPHERE
C
      ELSE
      XALBLS(1,NY,NX)=0.0
      XFEBLS(1,NY,NX)=0.0
      XHYBLS(1,NY,NX)=0.0
      XCABLS(1,NY,NX)=0.0
      XMGBLS(1,NY,NX)=0.0
      XNABLS(1,NY,NX)=0.0
      XKABLS(1,NY,NX)=0.0
      XOHBLS(1,NY,NX)=0.0
      XSOBLS(1,NY,NX)=0.0
      XCLBLS(1,NY,NX)=0.0
      XC3BLS(1,NY,NX)=0.0
      XHCBLS(1,NY,NX)=0.0
      XAL1BS(1,NY,NX)=0.0
      XAL2BS(1,NY,NX)=0.0
      XAL3BS(1,NY,NX)=0.0
      XAL4BS(1,NY,NX)=0.0
      XALSBS(1,NY,NX)=0.0
      XFE1BS(1,NY,NX)=0.0
      XFE2BS(1,NY,NX)=0.0
      XFE3BS(1,NY,NX)=0.0
      XFE4BS(1,NY,NX)=0.0
      XFESBS(1,NY,NX)=0.0
      XCAOBS(1,NY,NX)=0.0
      XCACBS(1,NY,NX)=0.0
      XCAHBS(1,NY,NX)=0.0
      XCASBS(1,NY,NX)=0.0
      XMGOBS(1,NY,NX)=0.0
      XMGCBS(1,NY,NX)=0.0
      XMGHBS(1,NY,NX)=0.0
      XMGSBS(1,NY,NX)=0.0
      XNACBS(1,NY,NX)=0.0
      XNASBS(1,NY,NX)=0.0
      XKASBS(1,NY,NX)=0.0
      XH0PBS(1,NY,NX)=0.0
      XH3PBS(1,NY,NX)=0.0
      XF1PBS(1,NY,NX)=0.0
      XF2PBS(1,NY,NX)=0.0
      XC0PBS(1,NY,NX)=0.0
      XC1PBS(1,NY,NX)=0.0
      XC2PBS(1,NY,NX)=0.0
      XM1PBS(1,NY,NX)=0.0
      XALFLS(3,0,NY,NX)=0.0
      XFEFLS(3,0,NY,NX)=0.0
      XHYFLS(3,0,NY,NX)=0.0
      XCAFLS(3,0,NY,NX)=0.0
      XMGFLS(3,0,NY,NX)=0.0
      XNAFLS(3,0,NY,NX)=0.0
      XKAFLS(3,0,NY,NX)=0.0
      XOHFLS(3,0,NY,NX)=0.0
      XSOFLS(3,0,NY,NX)=0.0
      XCLFLS(3,0,NY,NX)=0.0
      XC3FLS(3,0,NY,NX)=0.0
      XHCFLS(3,0,NY,NX)=0.0
      XAL1FS(3,0,NY,NX)=0.0
      XAL2FS(3,0,NY,NX)=0.0
      XAL3FS(3,0,NY,NX)=0.0
      XAL4FS(3,0,NY,NX)=0.0
      XALSFS(3,0,NY,NX)=0.0
      XFE1FS(3,0,NY,NX)=0.0
      XFE2FS(3,0,NY,NX)=0.0
      XFE3FS(3,0,NY,NX)=0.0
      XFE4FS(3,0,NY,NX)=0.0
      XFESFS(3,0,NY,NX)=0.0
      XCAOFS(3,0,NY,NX)=0.0
      XCACFS(3,0,NY,NX)=0.0
      XCAHFS(3,0,NY,NX)=0.0
      XCASFS(3,0,NY,NX)=0.0
      XMGOFS(3,0,NY,NX)=0.0
      XMGCFS(3,0,NY,NX)=0.0
      XMGHFS(3,0,NY,NX)=0.0
      XMGSFS(3,0,NY,NX)=0.0
      XNACFS(3,0,NY,NX)=0.0
      XNASFS(3,0,NY,NX)=0.0
      XKASFS(3,0,NY,NX)=0.0
      XH0PFS(3,0,NY,NX)=0.0
      XH3PFS(3,0,NY,NX)=0.0
      XF1PFS(3,0,NY,NX)=0.0
      XF2PFS(3,0,NY,NX)=0.0
      XC0PFS(3,0,NY,NX)=0.0
      XC1PFS(3,0,NY,NX)=0.0
      XC2PFS(3,0,NY,NX)=0.0
      XM1PFS(3,0,NY,NX)=0.0
      XALFLS(3,NU(NY,NX),NY,NX)=0.0
      XFEFLS(3,NU(NY,NX),NY,NX)=0.0
      XHYFLS(3,NU(NY,NX),NY,NX)=0.0
      XCAFLS(3,NU(NY,NX),NY,NX)=0.0
      XMGFLS(3,NU(NY,NX),NY,NX)=0.0
      XNAFLS(3,NU(NY,NX),NY,NX)=0.0
      XKAFLS(3,NU(NY,NX),NY,NX)=0.0
      XOHFLS(3,NU(NY,NX),NY,NX)=0.0
      XSOFLS(3,NU(NY,NX),NY,NX)=0.0
      XCLFLS(3,NU(NY,NX),NY,NX)=0.0
      XC3FLS(3,NU(NY,NX),NY,NX)=0.0
      XHCFLS(3,NU(NY,NX),NY,NX)=0.0
      XAL1FS(3,NU(NY,NX),NY,NX)=0.0
      XAL2FS(3,NU(NY,NX),NY,NX)=0.0
      XAL3FS(3,NU(NY,NX),NY,NX)=0.0
      XAL4FS(3,NU(NY,NX),NY,NX)=0.0
      XALSFS(3,NU(NY,NX),NY,NX)=0.0
      XFE1FS(3,NU(NY,NX),NY,NX)=0.0
      XFE2FS(3,NU(NY,NX),NY,NX)=0.0
      XFE3FS(3,NU(NY,NX),NY,NX)=0.0
      XFE4FS(3,NU(NY,NX),NY,NX)=0.0
      XFESFS(3,NU(NY,NX),NY,NX)=0.0
      XCAOFS(3,NU(NY,NX),NY,NX)=0.0
      XCACFS(3,NU(NY,NX),NY,NX)=0.0
      XCAHFS(3,NU(NY,NX),NY,NX)=0.0
      XCASFS(3,NU(NY,NX),NY,NX)=0.0
      XMGOFS(3,NU(NY,NX),NY,NX)=0.0
      XMGCFS(3,NU(NY,NX),NY,NX)=0.0
      XMGHFS(3,NU(NY,NX),NY,NX)=0.0
      XMGSFS(3,NU(NY,NX),NY,NX)=0.0
      XNACFS(3,NU(NY,NX),NY,NX)=0.0
      XNASFS(3,NU(NY,NX),NY,NX)=0.0
      XKASFS(3,NU(NY,NX),NY,NX)=0.0
      XH0PFS(3,NU(NY,NX),NY,NX)=0.0
      XH3PFS(3,NU(NY,NX),NY,NX)=0.0
      XF1PFS(3,NU(NY,NX),NY,NX)=0.0
      XF2PFS(3,NU(NY,NX),NY,NX)=0.0
      XC0PFS(3,NU(NY,NX),NY,NX)=0.0
      XC1PFS(3,NU(NY,NX),NY,NX)=0.0
      XC2PFS(3,NU(NY,NX),NY,NX)=0.0
      XM1PFS(3,NU(NY,NX),NY,NX)=0.0
      XH0BFB(3,NU(NY,NX),NY,NX)=0.0
      XH3BFB(3,NU(NY,NX),NY,NX)=0.0
      XF1BFB(3,NU(NY,NX),NY,NX)=0.0
      XF2BFB(3,NU(NY,NX),NY,NX)=0.0
      XC0BFB(3,NU(NY,NX),NY,NX)=0.0
      XC1BFB(3,NU(NY,NX),NY,NX)=0.0
      XC2BFB(3,NU(NY,NX),NY,NX)=0.0
      XM1BFB(3,NU(NY,NX),NY,NX)=0.0
      ENDIF
C
C     GAS AND SOLUTE FLUXES AT SUB-HOURLY FLUX TIME STEP
C     ENTERED IN SITE FILE
C
C
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C     R*BLS,R*FL0,R*FL1,R*FL2=solute flux to snowpack,surface litter,soil surface non-band,band 
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      RALBLS(1,NY,NX)=XALBLS(1,NY,NX)*XNPH
      RFEBLS(1,NY,NX)=XFEBLS(1,NY,NX)*XNPH
      RHYBLS(1,NY,NX)=XHYBLS(1,NY,NX)*XNPH
      RCABLS(1,NY,NX)=XCABLS(1,NY,NX)*XNPH
      RMGBLS(1,NY,NX)=XMGBLS(1,NY,NX)*XNPH
      RNABLS(1,NY,NX)=XNABLS(1,NY,NX)*XNPH
      RKABLS(1,NY,NX)=XKABLS(1,NY,NX)*XNPH
      ROHBLS(1,NY,NX)=XOHBLS(1,NY,NX)*XNPH
      RSOBLS(1,NY,NX)=XSOBLS(1,NY,NX)*XNPH
      RCLBLS(1,NY,NX)=XCLBLS(1,NY,NX)*XNPH
      RC3BLS(1,NY,NX)=XC3BLS(1,NY,NX)*XNPH
      RHCBLS(1,NY,NX)=XHCBLS(1,NY,NX)*XNPH
      RAL1BS(1,NY,NX)=XAL1BS(1,NY,NX)*XNPH
      RAL2BS(1,NY,NX)=XAL2BS(1,NY,NX)*XNPH
      RAL3BS(1,NY,NX)=XAL3BS(1,NY,NX)*XNPH
      RAL4BS(1,NY,NX)=XAL4BS(1,NY,NX)*XNPH
      RALSBS(1,NY,NX)=XALSBS(1,NY,NX)*XNPH
      RFE1BS(1,NY,NX)=XFE1BS(1,NY,NX)*XNPH
      RFE2BS(1,NY,NX)=XFE2BS(1,NY,NX)*XNPH
      RFE3BS(1,NY,NX)=XFE3BS(1,NY,NX)*XNPH
      RFE4BS(1,NY,NX)=XFE4BS(1,NY,NX)*XNPH
      RFESBS(1,NY,NX)=XFESBS(1,NY,NX)*XNPH
      RCAOBS(1,NY,NX)=XCAOBS(1,NY,NX)*XNPH
      RCACBS(1,NY,NX)=XCACBS(1,NY,NX)*XNPH
      RCAHBS(1,NY,NX)=XCAHBS(1,NY,NX)*XNPH
      RCASBS(1,NY,NX)=XCASBS(1,NY,NX)*XNPH
      RMGOBS(1,NY,NX)=XMGOBS(1,NY,NX)*XNPH
      RMGCBS(1,NY,NX)=XMGCBS(1,NY,NX)*XNPH
      RMGHBS(1,NY,NX)=XMGHBS(1,NY,NX)*XNPH
      RMGSBS(1,NY,NX)=XMGSBS(1,NY,NX)*XNPH
      RNACBS(1,NY,NX)=XNACBS(1,NY,NX)*XNPH
      RNASBS(1,NY,NX)=XNASBS(1,NY,NX)*XNPH
      RKASBS(1,NY,NX)=XKASBS(1,NY,NX)*XNPH
      RH0PBS(1,NY,NX)=XH0PBS(1,NY,NX)*XNPH
      RH3PBS(1,NY,NX)=XH3PBS(1,NY,NX)*XNPH
      RF1PBS(1,NY,NX)=XF1PBS(1,NY,NX)*XNPH
      RF2PBS(1,NY,NX)=XF2PBS(1,NY,NX)*XNPH
      RC0PBS(1,NY,NX)=XC0PBS(1,NY,NX)*XNPH
      RC1PBS(1,NY,NX)=XC1PBS(1,NY,NX)*XNPH
      RC2PBS(1,NY,NX)=XC2PBS(1,NY,NX)*XNPH
      RM1PBS(1,NY,NX)=XM1PBS(1,NY,NX)*XNPH
      RALFL0(NY,NX)=XALFLS(3,0,NY,NX)*XNPH
      RFEFL0(NY,NX)=XFEFLS(3,0,NY,NX)*XNPH
      RHYFL0(NY,NX)=XHYFLS(3,0,NY,NX)*XNPH
      RCAFL0(NY,NX)=XCAFLS(3,0,NY,NX)*XNPH
      RMGFL0(NY,NX)=XMGFLS(3,0,NY,NX)*XNPH
      RNAFL0(NY,NX)=XNAFLS(3,0,NY,NX)*XNPH
      RKAFL0(NY,NX)=XKAFLS(3,0,NY,NX)*XNPH
      ROHFL0(NY,NX)=XOHFLS(3,0,NY,NX)*XNPH
      RSOFL0(NY,NX)=XSOFLS(3,0,NY,NX)*XNPH
      RCLFL0(NY,NX)=XCLFLS(3,0,NY,NX)*XNPH
      RC3FL0(NY,NX)=XC3FLS(3,0,NY,NX)*XNPH
      RHCFL0(NY,NX)=XHCFLS(3,0,NY,NX)*XNPH
      RAL1F0(NY,NX)=XAL1FS(3,0,NY,NX)*XNPH
      RAL2F0(NY,NX)=XAL2FS(3,0,NY,NX)*XNPH
      RAL3F0(NY,NX)=XAL3FS(3,0,NY,NX)*XNPH
      RAL4F0(NY,NX)=XAL4FS(3,0,NY,NX)*XNPH
      RALSF0(NY,NX)=XALSFS(3,0,NY,NX)*XNPH
      RFE1F0(NY,NX)=XFE1FS(3,0,NY,NX)*XNPH
      RFE2F0(NY,NX)=XFE2FS(3,0,NY,NX)*XNPH
      RFE3F0(NY,NX)=XFE3FS(3,0,NY,NX)*XNPH
      RFE4F0(NY,NX)=XFE4FS(3,0,NY,NX)*XNPH
      RFESF0(NY,NX)=XFESFS(3,0,NY,NX)*XNPH
      RCAOF0(NY,NX)=XCAOFS(3,0,NY,NX)*XNPH
      RCACF0(NY,NX)=XCACFS(3,0,NY,NX)*XNPH
      RCAHF0(NY,NX)=XCAHFS(3,0,NY,NX)*XNPH
      RCASF0(NY,NX)=XCASFS(3,0,NY,NX)*XNPH
      RMGOF0(NY,NX)=XMGOFS(3,0,NY,NX)*XNPH
      RMGCF0(NY,NX)=XMGCFS(3,0,NY,NX)*XNPH
      RMGHF0(NY,NX)=XMGHFS(3,0,NY,NX)*XNPH
      RMGSF0(NY,NX)=XMGSFS(3,0,NY,NX)*XNPH
      RNACF0(NY,NX)=XNACFS(3,0,NY,NX)*XNPH
      RNASF0(NY,NX)=XNASFS(3,0,NY,NX)*XNPH
      RKASF0(NY,NX)=XKASFS(3,0,NY,NX)*XNPH
      RH0PF0(NY,NX)=XH0PFS(3,0,NY,NX)*XNPH
      RH3PF0(NY,NX)=XH3PFS(3,0,NY,NX)*XNPH
      RF1PF0(NY,NX)=XF1PFS(3,0,NY,NX)*XNPH
      RF2PF0(NY,NX)=XF2PFS(3,0,NY,NX)*XNPH
      RC0PF0(NY,NX)=XC0PFS(3,0,NY,NX)*XNPH
      RC1PF0(NY,NX)=XC1PFS(3,0,NY,NX)*XNPH
      RC2PF0(NY,NX)=XC2PFS(3,0,NY,NX)*XNPH
      RM1PF0(NY,NX)=XM1PFS(3,0,NY,NX)*XNPH
      RALFL1(NY,NX)=XALFLS(3,NU(NY,NX),NY,NX)*XNPH
      RFEFL1(NY,NX)=XFEFLS(3,NU(NY,NX),NY,NX)*XNPH
      RHYFL1(NY,NX)=XHYFLS(3,NU(NY,NX),NY,NX)*XNPH
      RCAFL1(NY,NX)=XCAFLS(3,NU(NY,NX),NY,NX)*XNPH
      RMGFL1(NY,NX)=XMGFLS(3,NU(NY,NX),NY,NX)*XNPH
      RNAFL1(NY,NX)=XNAFLS(3,NU(NY,NX),NY,NX)*XNPH
      RKAFL1(NY,NX)=XKAFLS(3,NU(NY,NX),NY,NX)*XNPH
      ROHFL1(NY,NX)=XOHFLS(3,NU(NY,NX),NY,NX)*XNPH
      RSOFL1(NY,NX)=XSOFLS(3,NU(NY,NX),NY,NX)*XNPH
      RCLFL1(NY,NX)=XCLFLS(3,NU(NY,NX),NY,NX)*XNPH
      RC3FL1(NY,NX)=XC3FLS(3,NU(NY,NX),NY,NX)*XNPH
      RHCFL1(NY,NX)=XHCFLS(3,NU(NY,NX),NY,NX)*XNPH
      RAL1F1(NY,NX)=XAL1FS(3,NU(NY,NX),NY,NX)*XNPH
      RAL2F1(NY,NX)=XAL2FS(3,NU(NY,NX),NY,NX)*XNPH
      RAL3F1(NY,NX)=XAL3FS(3,NU(NY,NX),NY,NX)*XNPH
      RAL4F1(NY,NX)=XAL4FS(3,NU(NY,NX),NY,NX)*XNPH
      RALSF1(NY,NX)=XALSFS(3,NU(NY,NX),NY,NX)*XNPH
      RFE1F1(NY,NX)=XFE1FS(3,NU(NY,NX),NY,NX)*XNPH
      RFE2F1(NY,NX)=XFE2FS(3,NU(NY,NX),NY,NX)*XNPH
      RFE3F1(NY,NX)=XFE3FS(3,NU(NY,NX),NY,NX)*XNPH
      RFE4F1(NY,NX)=XFE4FS(3,NU(NY,NX),NY,NX)*XNPH
      RFESF1(NY,NX)=XFESFS(3,NU(NY,NX),NY,NX)*XNPH
      RCAOF1(NY,NX)=XCAOFS(3,NU(NY,NX),NY,NX)*XNPH
      RCACF1(NY,NX)=XCACFS(3,NU(NY,NX),NY,NX)*XNPH
      RCAHF1(NY,NX)=XCAHFS(3,NU(NY,NX),NY,NX)*XNPH
      RCASF1(NY,NX)=XCASFS(3,NU(NY,NX),NY,NX)*XNPH
      RMGOF1(NY,NX)=XMGOFS(3,NU(NY,NX),NY,NX)*XNPH
      RMGCF1(NY,NX)=XMGCFS(3,NU(NY,NX),NY,NX)*XNPH
      RMGHF1(NY,NX)=XMGHFS(3,NU(NY,NX),NY,NX)*XNPH
      RMGSF1(NY,NX)=XMGSFS(3,NU(NY,NX),NY,NX)*XNPH
      RNACF1(NY,NX)=XNACFS(3,NU(NY,NX),NY,NX)*XNPH
      RNASF1(NY,NX)=XNASFS(3,NU(NY,NX),NY,NX)*XNPH
      RKASF1(NY,NX)=XKASFS(3,NU(NY,NX),NY,NX)*XNPH
      RH0PF1(NY,NX)=XH0PFS(3,NU(NY,NX),NY,NX)*XNPH
      RH3PF1(NY,NX)=XH3PFS(3,NU(NY,NX),NY,NX)*XNPH
      RF1PF1(NY,NX)=XF1PFS(3,NU(NY,NX),NY,NX)*XNPH
      RF2PF1(NY,NX)=XF2PFS(3,NU(NY,NX),NY,NX)*XNPH
      RC0PF1(NY,NX)=XC0PFS(3,NU(NY,NX),NY,NX)*XNPH
      RC1PF1(NY,NX)=XC1PFS(3,NU(NY,NX),NY,NX)*XNPH
      RC2PF1(NY,NX)=XC2PFS(3,NU(NY,NX),NY,NX)*XNPH
      RM1PF1(NY,NX)=XM1PFS(3,NU(NY,NX),NY,NX)*XNPH
      RH0BF2(NY,NX)=XH0BFB(3,NU(NY,NX),NY,NX)*XNPH
      RH3BF2(NY,NX)=XH3BFB(3,NU(NY,NX),NY,NX)*XNPH
      RF1BF2(NY,NX)=XF1BFB(3,NU(NY,NX),NY,NX)*XNPH
      RF2BF2(NY,NX)=XF2BFB(3,NU(NY,NX),NY,NX)*XNPH
      RC0BF2(NY,NX)=XC0BFB(3,NU(NY,NX),NY,NX)*XNPH
      RC1BF2(NY,NX)=XC1BFB(3,NU(NY,NX),NY,NX)*XNPH
      RC2BF2(NY,NX)=XC2BFB(3,NU(NY,NX),NY,NX)*XNPH
      RM1BF2(NY,NX)=XM1BFB(3,NU(NY,NX),NY,NX)*XNPH
C
C     INITIAL SOLUTES IN SNOWPACK
C
C     Z*W=solute content in snowpacl
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-C
      DO 20 L=1,JS
      ZALW2(L,NY,NX)=ZALW(L,NY,NX)
      ZFEW2(L,NY,NX)=ZFEW(L,NY,NX)
      ZHYW2(L,NY,NX)=ZHYW(L,NY,NX)
      ZCAW2(L,NY,NX)=ZCAW(L,NY,NX)
      ZMGW2(L,NY,NX)=ZMGW(L,NY,NX)
      ZNAW2(L,NY,NX)=ZNAW(L,NY,NX)
      ZKAW2(L,NY,NX)=ZKAW(L,NY,NX)
      ZOHW2(L,NY,NX)=ZOHW(L,NY,NX)
      ZSO4W2(L,NY,NX)=ZSO4W(L,NY,NX)
      ZCLW2(L,NY,NX)=ZCLW(L,NY,NX) 
      ZCO3W2(L,NY,NX)=ZCO3W(L,NY,NX) 
      ZHCO3W2(L,NY,NX)=ZHCO3W(L,NY,NX)
      ZALH1W2(L,NY,NX)=ZALH1W(L,NY,NX)
      ZALH2W2(L,NY,NX)=ZALH2W(L,NY,NX)
      ZALH3W2(L,NY,NX)=ZALH3W(L,NY,NX)
      ZALH4W2(L,NY,NX)=ZALH4W(L,NY,NX)
      ZALSW2(L,NY,NX)=ZALSW(L,NY,NX) 
      ZFEH1W2(L,NY,NX)=ZFEH1W(L,NY,NX)
      ZFEH2W2(L,NY,NX)=ZFEH2W(L,NY,NX)
      ZFEH3W2(L,NY,NX)=ZFEH3W(L,NY,NX)
      ZFEH4W2(L,NY,NX)=ZFEH4W(L,NY,NX)
      ZFESW2(L,NY,NX)=ZFESW(L,NY,NX)
      ZCAOW2(L,NY,NX)=ZCAOW(L,NY,NX)
      ZCACW2(L,NY,NX)=ZCACW(L,NY,NX)
      ZCAHW2(L,NY,NX)=ZCAHW(L,NY,NX)
      ZCASW2(L,NY,NX)=ZCASW(L,NY,NX)
      ZMGOW2(L,NY,NX)=ZMGOW(L,NY,NX)
      ZMGCW2(L,NY,NX)=ZMGCW(L,NY,NX)
      ZMGHW2(L,NY,NX)=ZMGHW(L,NY,NX)
      ZMGSW2(L,NY,NX)=ZMGSW(L,NY,NX)
      ZNACW2(L,NY,NX)=ZNACW(L,NY,NX)
      ZNASW2(L,NY,NX)=ZNASW(L,NY,NX)
      ZKASW2(L,NY,NX)=ZKASW(L,NY,NX)
      H0PO4W2(L,NY,NX)=H0PO4W(L,NY,NX)
      H3PO4W2(L,NY,NX)=H3PO4W(L,NY,NX)
      ZFE1PW2(L,NY,NX)=ZFE1PW(L,NY,NX)
      ZFE2PW2(L,NY,NX)=ZFE2PW(L,NY,NX)
      ZCA0PW2(L,NY,NX)=ZCA0PW(L,NY,NX)
      ZCA1PW2(L,NY,NX)=ZCA1PW(L,NY,NX)
      ZCA2PW2(L,NY,NX)=ZCA2PW(L,NY,NX)
      ZMG1PW2(L,NY,NX)=ZMG1PW(L,NY,NX)
20    CONTINUE
C
C     SOLUTE FLUXES FROM SOLUTE.F 
C
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C     RZ*2=solute flux at time step for flux calculations
C     TR*=solute transformations from solute.f
C
      DO 10 L=NU(NY,NX),NL(NY,NX)
      RZAL2(L,NY,NX)=-TRAL(L,NY,NX)*XNPH
      RZFE2(L,NY,NX)=-TRFE(L,NY,NX)*XNPH
      RZHY2(L,NY,NX)=-(TRHY(L,NY,NX)+XZHYS(L,NY,NX))*XNPH
      RZCA2(L,NY,NX)=-TRCA(L,NY,NX)*XNPH
      RZMG2(L,NY,NX)=-TRMG(L,NY,NX)*XNPH
      RZNA2(L,NY,NX)=-TRNA(L,NY,NX)*XNPH
      RZKA2(L,NY,NX)=-TRKA(L,NY,NX)*XNPH
      RZOH2(L,NY,NX)=-TROH(L,NY,NX)*XNPH
      RZSO42(L,NY,NX)=-TRSO4(L,NY,NX)*XNPH
      RZCL2(L,NY,NX)=0.0
      RZCO32(L,NY,NX)=-TRCO3(L,NY,NX)*XNPH
      RZHCO32(L,NY,NX)=-TRHCO(L,NY,NX)*XNPH
      RZAL12(L,NY,NX)=-TRAL1(L,NY,NX)*XNPH
      RZAL22(L,NY,NX)=-TRAL2(L,NY,NX)*XNPH
      RZAL32(L,NY,NX)=-TRAL3(L,NY,NX)*XNPH
      RZAL42(L,NY,NX)=-TRAL4(L,NY,NX)*XNPH
      RZALS2(L,NY,NX)=-TRALS(L,NY,NX)*XNPH
      RZFE12(L,NY,NX)=-TRFE1(L,NY,NX)*XNPH
      RZFE22(L,NY,NX)=-TRFE2(L,NY,NX)*XNPH
      RZFE32(L,NY,NX)=-TRFE3(L,NY,NX)*XNPH
      RZFE42(L,NY,NX)=-TRFE4(L,NY,NX)*XNPH
      RZFES2(L,NY,NX)=-TRFES(L,NY,NX)*XNPH
      RZCAO2(L,NY,NX)=-TRCAO(L,NY,NX)*XNPH
      RZCAC2(L,NY,NX)=-TRCAC(L,NY,NX)*XNPH
      RZCAH2(L,NY,NX)=-TRCAH(L,NY,NX)*XNPH
      RZCAS2(L,NY,NX)=-TRCAS(L,NY,NX)*XNPH
      RZMGO2(L,NY,NX)=-TRMGO(L,NY,NX)*XNPH
      RZMGC2(L,NY,NX)=-TRMGC(L,NY,NX)*XNPH
      RZMGH2(L,NY,NX)=-TRMGH(L,NY,NX)*XNPH
      RZMGS2(L,NY,NX)=-TRMGS(L,NY,NX)*XNPH
      RZNAC2(L,NY,NX)=-TRNAC(L,NY,NX)*XNPH
      RZNAS2(L,NY,NX)=-TRNAS(L,NY,NX)*XNPH
      RZKAS2(L,NY,NX)=-TRKAS(L,NY,NX)*XNPH
      RH0PO42(L,NY,NX)=-TRH0P(L,NY,NX)*XNPH
      RH3PO42(L,NY,NX)=-TRH3P(L,NY,NX)*XNPH
      RZFE1P2(L,NY,NX)=-TRF1P(L,NY,NX)*XNPH
      RZFE2P2(L,NY,NX)=-TRF2P(L,NY,NX)*XNPH
      RZCA0P2(L,NY,NX)=-TRC0P(L,NY,NX)*XNPH
      RZCA1P2(L,NY,NX)=-TRC1P(L,NY,NX)*XNPH
      RZCA2P2(L,NY,NX)=-TRC2P(L,NY,NX)*XNPH
      RZMG1P2(L,NY,NX)=-TRM1P(L,NY,NX)*XNPH
      RH0POB2(L,NY,NX)=-TRH0B(L,NY,NX)*XNPH
      RH3POB2(L,NY,NX)=-TRH3B(L,NY,NX)*XNPH
      RZF1PB2(L,NY,NX)=-TRF1B(L,NY,NX)*XNPH
      RZF2PB2(L,NY,NX)=-TRF2B(L,NY,NX)*XNPH
      RZC0PB2(L,NY,NX)=-TRC0B(L,NY,NX)*XNPH
      RZC1PB2(L,NY,NX)=-TRC1B(L,NY,NX)*XNPH
      RZC2PB2(L,NY,NX)=-TRC2B(L,NY,NX)*XNPH
      RZM1PB2(L,NY,NX)=-TRM1B(L,NY,NX)*XNPH
C
C     SOLUTE FLUXES FROM SUBSURFACE IRRIGATION
C
C     FLU=subsurface water flux from watsub.f
C     R*FLU,R*FBU=subsurface solute flux in non-band,band
C     C*Q=irrigation solute concentrations
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C
      FLWU(L,NY,NX)=TUPWTR(L,NY,NX)*XNPH
      RALFLU(L,NY,NX)=FLU(L,NY,NX)*CALQ(I,NY,NX)
      RFEFLU(L,NY,NX)=FLU(L,NY,NX)*CFEQ(I,NY,NX)
      RHYFLU(L,NY,NX)=FLU(L,NY,NX)*CHYQ(I,NY,NX)
      RCAFLU(L,NY,NX)=FLU(L,NY,NX)*CCAQ(I,NY,NX)
      RMGFLU(L,NY,NX)=FLU(L,NY,NX)*CMGQ(I,NY,NX)
      RNAFLU(L,NY,NX)=FLU(L,NY,NX)*CNAQ(I,NY,NX)
      RKAFLU(L,NY,NX)=FLU(L,NY,NX)*CKAQ(I,NY,NX)
      ROHFLU(L,NY,NX)=FLU(L,NY,NX)*COHQ(I,NY,NX)
      RSOFLU(L,NY,NX)=FLU(L,NY,NX)*CSOQ(I,NY,NX)
      RCLFLU(L,NY,NX)=FLU(L,NY,NX)*CCLQ(I,NY,NX)
      RC3FLU(L,NY,NX)=FLU(L,NY,NX)*CC3Q(I,NY,NX)
      RHCFLU(L,NY,NX)=FLU(L,NY,NX)*CHCQ(I,NY,NX)
      RAL1FU(L,NY,NX)=FLU(L,NY,NX)*CAL1Q(I,NY,NX)
      RAL2FU(L,NY,NX)=FLU(L,NY,NX)*CAL2Q(I,NY,NX)
      RAL3FU(L,NY,NX)=FLU(L,NY,NX)*CAL3Q(I,NY,NX)
      RAL4FU(L,NY,NX)=FLU(L,NY,NX)*CAL4Q(I,NY,NX)
      RALSFU(L,NY,NX)=FLU(L,NY,NX)*CALSQ(I,NY,NX)
      RFE1FU(L,NY,NX)=FLU(L,NY,NX)*CFE1Q(I,NY,NX)
      RFE2FU(L,NY,NX)=FLU(L,NY,NX)*CFE2Q(I,NY,NX)
      RFE3FU(L,NY,NX)=FLU(L,NY,NX)*CFE3Q(I,NY,NX)
      RFE4FU(L,NY,NX)=FLU(L,NY,NX)*CFE4Q(I,NY,NX)
      RFESFU(L,NY,NX)=FLU(L,NY,NX)*CFESQ(I,NY,NX)
      RCAOFU(L,NY,NX)=FLU(L,NY,NX)*CCAOQ(I,NY,NX)
      RCACFU(L,NY,NX)=FLU(L,NY,NX)*CCACQ(I,NY,NX)
      RCAHFU(L,NY,NX)=FLU(L,NY,NX)*CCAHQ(I,NY,NX)
      RCASFU(L,NY,NX)=FLU(L,NY,NX)*CCASQ(I,NY,NX)
      RMGOFU(L,NY,NX)=FLU(L,NY,NX)*CMGOQ(I,NY,NX)
      RMGCFU(L,NY,NX)=FLU(L,NY,NX)*CMGCQ(I,NY,NX)
      RMGHFU(L,NY,NX)=FLU(L,NY,NX)*CMGHQ(I,NY,NX)
      RMGSFU(L,NY,NX)=FLU(L,NY,NX)*CMGSQ(I,NY,NX)
      RNACFU(L,NY,NX)=FLU(L,NY,NX)*CNACQ(I,NY,NX)
      RNASFU(L,NY,NX)=FLU(L,NY,NX)*CNASQ(I,NY,NX)
      RKASFU(L,NY,NX)=FLU(L,NY,NX)*CKASQ(I,NY,NX)
      RH0PFU(L,NY,NX)=FLU(L,NY,NX)*CH0PQ(I,NY,NX)*VLPO4(L,NY,NX)
      RH3PFU(L,NY,NX)=FLU(L,NY,NX)*CH3PQ(I,NY,NX)*VLPO4(L,NY,NX)
      RF1PFU(L,NY,NX)=FLU(L,NY,NX)*CF1PQ(I,NY,NX)*VLPO4(L,NY,NX)
      RF2PFU(L,NY,NX)=FLU(L,NY,NX)*CF2PQ(I,NY,NX)*VLPO4(L,NY,NX)
      RC0PFU(L,NY,NX)=FLU(L,NY,NX)*CC0PQ(I,NY,NX)*VLPO4(L,NY,NX)
      RC1PFU(L,NY,NX)=FLU(L,NY,NX)*CC1PQ(I,NY,NX)*VLPO4(L,NY,NX)
      RC2PFU(L,NY,NX)=FLU(L,NY,NX)*CC2PQ(I,NY,NX)*VLPO4(L,NY,NX)
      RM1PFU(L,NY,NX)=FLU(L,NY,NX)*CM1PQ(I,NY,NX)*VLPO4(L,NY,NX)
      RH0BBU(L,NY,NX)=FLU(L,NY,NX)*CH0PQ(I,NY,NX)*VLPOB(L,NY,NX)
      RH3BBU(L,NY,NX)=FLU(L,NY,NX)*CH3PQ(I,NY,NX)*VLPOB(L,NY,NX)
      RF1BBU(L,NY,NX)=FLU(L,NY,NX)*CF1PQ(I,NY,NX)*VLPOB(L,NY,NX)
      RF2BBU(L,NY,NX)=FLU(L,NY,NX)*CF2PQ(I,NY,NX)*VLPOB(L,NY,NX)
      RC0BBU(L,NY,NX)=FLU(L,NY,NX)*CC0PQ(I,NY,NX)*VLPOB(L,NY,NX)
      RC1BBU(L,NY,NX)=FLU(L,NY,NX)*CC1PQ(I,NY,NX)*VLPOB(L,NY,NX)
      RC2BBU(L,NY,NX)=FLU(L,NY,NX)*CC2PQ(I,NY,NX)*VLPOB(L,NY,NX)
      RM1BBU(L,NY,NX)=FLU(L,NY,NX)*CM1PQ(I,NY,NX)*VLPOB(L,NY,NX)
C
C     SUB-HOURLY SOLUTE FLUXES FROM SUBSURFACE IRRIGATION
C
C     R*FLZ,R*FBZ=subsurface solute flux in non-band,band
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C
      RALFLZ(L,NY,NX)=RALFLU(L,NY,NX)*XNPH
      RFEFLZ(L,NY,NX)=RFEFLU(L,NY,NX)*XNPH
      RHYFLZ(L,NY,NX)=RHYFLU(L,NY,NX)*XNPH
      RCAFLZ(L,NY,NX)=RCAFLU(L,NY,NX)*XNPH
      RMGFLZ(L,NY,NX)=RMGFLU(L,NY,NX)*XNPH
      RNAFLZ(L,NY,NX)=RNAFLU(L,NY,NX)*XNPH
      RKAFLZ(L,NY,NX)=RKAFLU(L,NY,NX)*XNPH
      ROHFLZ(L,NY,NX)=ROHFLU(L,NY,NX)*XNPH
      RSOFLZ(L,NY,NX)=RSOFLU(L,NY,NX)*XNPH
      RCLFLZ(L,NY,NX)=RCLFLU(L,NY,NX)*XNPH
      RC3FLZ(L,NY,NX)=RC3FLU(L,NY,NX)*XNPH
      RHCFLZ(L,NY,NX)=RHCFLU(L,NY,NX)*XNPH
      RAL1FZ(L,NY,NX)=RAL1FU(L,NY,NX)*XNPH
      RAL2FZ(L,NY,NX)=RAL2FU(L,NY,NX)*XNPH
      RAL3FZ(L,NY,NX)=RAL3FU(L,NY,NX)*XNPH
      RAL4FZ(L,NY,NX)=RAL4FU(L,NY,NX)*XNPH
      RALSFZ(L,NY,NX)=RALSFU(L,NY,NX)*XNPH
      RFE1FZ(L,NY,NX)=RFE1FU(L,NY,NX)*XNPH
      RFE2FZ(L,NY,NX)=RFE2FU(L,NY,NX)*XNPH
      RFE3FZ(L,NY,NX)=RFE3FU(L,NY,NX)*XNPH
      RFE4FZ(L,NY,NX)=RFE4FU(L,NY,NX)*XNPH
      RFESFZ(L,NY,NX)=RFESFU(L,NY,NX)*XNPH
      RCAOFZ(L,NY,NX)=RCAOFU(L,NY,NX)*XNPH
      RCACFZ(L,NY,NX)=RCACFU(L,NY,NX)*XNPH
      RCAHFZ(L,NY,NX)=RCAHFU(L,NY,NX)*XNPH
      RCASFZ(L,NY,NX)=RCASFU(L,NY,NX)*XNPH
      RMGOFZ(L,NY,NX)=RMGOFU(L,NY,NX)*XNPH
      RMGCFZ(L,NY,NX)=RMGCFU(L,NY,NX)*XNPH
      RMGHFZ(L,NY,NX)=RMGHFU(L,NY,NX)*XNPH
      RMGSFZ(L,NY,NX)=RMGSFU(L,NY,NX)*XNPH
      RNACFZ(L,NY,NX)=RNACFU(L,NY,NX)*XNPH
      RNASFZ(L,NY,NX)=RNASFU(L,NY,NX)*XNPH
      RKASFZ(L,NY,NX)=RKASFU(L,NY,NX)*XNPH
      RH0PFZ(L,NY,NX)=RH0PFU(L,NY,NX)*XNPH
      RH3PFZ(L,NY,NX)=RH3PFU(L,NY,NX)*XNPH
      RF1PFZ(L,NY,NX)=RF1PFU(L,NY,NX)*XNPH
      RF2PFZ(L,NY,NX)=RF2PFU(L,NY,NX)*XNPH
      RC0PFZ(L,NY,NX)=RC0PFU(L,NY,NX)*XNPH
      RC1PFZ(L,NY,NX)=RC1PFU(L,NY,NX)*XNPH
      RC2PFZ(L,NY,NX)=RC2PFU(L,NY,NX)*XNPH
      RM1PFZ(L,NY,NX)=RM1PFU(L,NY,NX)*XNPH
      RH0BBZ(L,NY,NX)=RH0BBU(L,NY,NX)*XNPH
      RH3BBZ(L,NY,NX)=RH3BBU(L,NY,NX)*XNPH
      RF1BBZ(L,NY,NX)=RF1BBU(L,NY,NX)*XNPH
      RF2BBZ(L,NY,NX)=RF2BBU(L,NY,NX)*XNPH
      RC0BBZ(L,NY,NX)=RC0BBU(L,NY,NX)*XNPH
      RC1BBZ(L,NY,NX)=RC1BBU(L,NY,NX)*XNPH
      RC2BBZ(L,NY,NX)=RC2BBU(L,NY,NX)*XNPH
      RM1BBZ(L,NY,NX)=RM1BBU(L,NY,NX)*XNPH
C
C     SOLUTE DIFFUSIVITIES AT SUB-HOURLY TIME STEP
C
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C     *SGL*=solute diffusivity from hour1.f
C     solute code:PO=PO4,AL=Al,FE=Fe,HY=H,CA=Ca,GM=Mg,AN=Na,AK=KOH=OH
C                :SO=SO4,CL=Cl,C3=CO3,HC=HCO3
      POSGL2(L,NY,NX)=POSGL(L,NY,NX)*XNPH
      ALSGL2(L,NY,NX)=ALSGL(L,NY,NX)*XNPH
      FESGL2(L,NY,NX)=FESGL(L,NY,NX)*XNPH
      HYSGL2(L,NY,NX)=HYSGL(L,NY,NX)*XNPH
      CASGL2(L,NY,NX)=CASGL(L,NY,NX)*XNPH
      GMSGL2(L,NY,NX)=GMSGL(L,NY,NX)*XNPH
      ANSGL2(L,NY,NX)=ANSGL(L,NY,NX)*XNPH
      AKSGL2(L,NY,NX)=AKSGL(L,NY,NX)*XNPH
      OHSGL2(L,NY,NX)=OHSGL(L,NY,NX)*XNPH
      SOSGL2(L,NY,NX)=SOSGL(L,NY,NX)*XNPH
      CLSXL2(L,NY,NX)=CLSXL(L,NY,NX)*XNPH
      C3SGL2(L,NY,NX)=C3SGL(L,NY,NX)*XNPH
      HCSGL2(L,NY,NX)=HCSGL(L,NY,NX)*XNPH
C
C     STATE VARIABLES FOR SOLUTES USED IN 'TRNSFRS'
C     TO STORE SUB-HOURLY CHANGES DURING FLUX CALCULATIONS
C     INCLUDING TRANSFORMATIONS FROM REACTIONS IN SOLUTE.F
C
C     Z*,Z*2=soil solute contents
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      ZAL2(L,NY,NX)=ZAL(L,NY,NX)
      ZFE2(L,NY,NX)=ZFE(L,NY,NX)
      ZHY2(L,NY,NX)=ZHY(L,NY,NX)
      ZCA2(L,NY,NX)=ZCA(L,NY,NX)
      ZMG2(L,NY,NX)=ZMG(L,NY,NX)
      ZNA2(L,NY,NX)=ZNA(L,NY,NX)
      ZKA2(L,NY,NX)=ZKA(L,NY,NX)
      ZOH2(L,NY,NX)=ZOH(L,NY,NX)
      ZSO42(L,NY,NX)=ZSO4(L,NY,NX) 
      ZCL2(L,NY,NX)=ZCL(L,NY,NX)
      ZCO32(L,NY,NX)=ZCO3(L,NY,NX) 
      ZHCO32(L,NY,NX)=ZHCO3(L,NY,NX)
      ZAL12(L,NY,NX)=ZALOH1(L,NY,NX)
      ZAL22(L,NY,NX)=ZALOH2(L,NY,NX)
      ZAL32(L,NY,NX)=ZALOH3(L,NY,NX)
      ZAL42(L,NY,NX)=ZALOH4(L,NY,NX)
      ZALS2(L,NY,NX)=ZALS(L,NY,NX) 
      ZFE12(L,NY,NX)=ZFEOH1(L,NY,NX)
      ZFE22(L,NY,NX)=ZFEOH2(L,NY,NX)
      ZFE32(L,NY,NX)=ZFEOH3(L,NY,NX)
      ZFE42(L,NY,NX)=ZFEOH4(L,NY,NX)
      ZFES2(L,NY,NX)=ZFES(L,NY,NX)
      ZCAO2(L,NY,NX)=ZCAO(L,NY,NX)
      ZCAC2(L,NY,NX)=ZCAC(L,NY,NX)
      ZCAH2(L,NY,NX)=ZCAH(L,NY,NX)
      ZCAS2(L,NY,NX)=ZCAS(L,NY,NX)
      ZMGO2(L,NY,NX)=ZMGO(L,NY,NX)
      ZMGC2(L,NY,NX)=ZMGC(L,NY,NX)
      ZMGH2(L,NY,NX)=ZMGH(L,NY,NX)
      ZMGS2(L,NY,NX)=ZMGS(L,NY,NX)
      ZNAC2(L,NY,NX)=ZNAC(L,NY,NX)
      ZNAS2(L,NY,NX)=ZNAS(L,NY,NX)
      ZKAS2(L,NY,NX)=ZKAS(L,NY,NX)
      H0PO42(L,NY,NX)=H0PO4(L,NY,NX)
      H3PO42(L,NY,NX)=H3PO4(L,NY,NX)
      ZFE1P2(L,NY,NX)=ZFE1P(L,NY,NX)
      ZFE2P2(L,NY,NX)=ZFE2P(L,NY,NX)
      ZCA0P2(L,NY,NX)=ZCA0P(L,NY,NX)
      ZCA1P2(L,NY,NX)=ZCA1P(L,NY,NX)
      ZCA2P2(L,NY,NX)=ZCA2P(L,NY,NX)
      ZMG1P2(L,NY,NX)=ZMG1P(L,NY,NX)
      H0POB2(L,NY,NX)=H0POB(L,NY,NX)
      H3POB2(L,NY,NX)=H3POB(L,NY,NX)
      ZF1PB2(L,NY,NX)=ZFE1PB(L,NY,NX)
      ZF2PB2(L,NY,NX)=ZFE2PB(L,NY,NX)
      ZC0PB2(L,NY,NX)=ZCA0PB(L,NY,NX)
      ZC1PB2(L,NY,NX)=ZCA1PB(L,NY,NX)
      ZC2PB2(L,NY,NX)=ZCA2PB(L,NY,NX)
      ZM1PB2(L,NY,NX)=ZMG1PB(L,NY,NX)
      ZALH2(L,NY,NX)=ZALH(L,NY,NX)
      ZFEH2(L,NY,NX)=ZFEH(L,NY,NX)
      ZHYH2(L,NY,NX)=ZHYH(L,NY,NX)
      ZCCH2(L,NY,NX)=ZCCH(L,NY,NX)
      ZMAH2(L,NY,NX)=ZMAH(L,NY,NX)
      ZNAH2(L,NY,NX)=ZNAH(L,NY,NX)
      ZKAH2(L,NY,NX)=ZKAH(L,NY,NX)
      ZOHH2(L,NY,NX)=ZOHH(L,NY,NX)
      ZSO4H2(L,NY,NX)=ZSO4H(L,NY,NX)
      ZCLH2(L,NY,NX)=ZCLH(L,NY,NX)
      ZCO3H2(L,NY,NX)=ZCO3H(L,NY,NX)
      ZHCOH2(L,NY,NX)=ZHCO3H(L,NY,NX)
      ZAL1H2(L,NY,NX)=ZALO1H(L,NY,NX)
      ZAL2H2(L,NY,NX)=ZALO2H(L,NY,NX)
      ZAL3H2(L,NY,NX)=ZALO3H(L,NY,NX)
      ZAL4H2(L,NY,NX)=ZALO4H(L,NY,NX)
      ZALSH2(L,NY,NX)=ZALSH(L,NY,NX)
      ZFE1H2(L,NY,NX)=ZFEO1H(L,NY,NX)
      ZFE2H2(L,NY,NX)=ZFEO2H(L,NY,NX)
      ZFE3H2(L,NY,NX)=ZFEO3H(L,NY,NX)
      ZFE4H2(L,NY,NX)=ZFEO4H(L,NY,NX)
      ZFESH2(L,NY,NX)=ZFESH(L,NY,NX)
      ZCAOH2(L,NY,NX)=ZCAOH(L,NY,NX)
      ZCACH2(L,NY,NX)=ZCACH(L,NY,NX)
      ZCAHH2(L,NY,NX)=ZCAHH(L,NY,NX)
      ZCASH2(L,NY,NX)=ZCASH(L,NY,NX)
      ZMGOH2(L,NY,NX)=ZMGOH(L,NY,NX)
      ZMGCH2(L,NY,NX)=ZMGCH(L,NY,NX)
      ZMGHH2(L,NY,NX)=ZMGHH(L,NY,NX)
      ZMGSH2(L,NY,NX)=ZMGSH(L,NY,NX)
      ZNACH2(L,NY,NX)=ZNACH(L,NY,NX)
      ZNASH2(L,NY,NX)=ZNASH(L,NY,NX)
      ZKASH2(L,NY,NX)=ZKASH(L,NY,NX)
      H0P4H2(L,NY,NX)=H0PO4H(L,NY,NX)
      H3P4H2(L,NY,NX)=H3PO4H(L,NY,NX)
      ZF1PH2(L,NY,NX)=ZFE1PH(L,NY,NX)
      ZF2PH2(L,NY,NX)=ZFE2PH(L,NY,NX)
      ZC0PH2(L,NY,NX)=ZCA0PH(L,NY,NX)
      ZC1PH2(L,NY,NX)=ZCA1PH(L,NY,NX)
      ZC2PH2(L,NY,NX)=ZCA2PH(L,NY,NX)
      ZM1PH2(L,NY,NX)=ZMG1PH(L,NY,NX)
      H0PBH2(L,NY,NX)=H0POBH(L,NY,NX)
      H3PBH2(L,NY,NX)=H3POBH(L,NY,NX)
      ZF1BH2(L,NY,NX)=ZFE1BH(L,NY,NX)
      ZF2BH2(L,NY,NX)=ZFE2BH(L,NY,NX)
      ZC0BH2(L,NY,NX)=ZCA0BH(L,NY,NX)
      ZC1BH2(L,NY,NX)=ZCA1BH(L,NY,NX)
      ZC2BH2(L,NY,NX)=ZCA2BH(L,NY,NX)
      ZM1BH2(L,NY,NX)=ZMG1BH(L,NY,NX)
10    CONTINUE
      ENDIF
9990  CONTINUE
9995  CONTINUE
C
C     TIME STEP USED IN GAS AND SOLUTE FLUX CALCULATIONS
C
      DO 30 M=1,NPH
      DO 9895 NX=NHW,NHE
      DO 9890 NY=NVN,NVS
      IF(ISALTG.NE.0)THEN
C
C     INITIALIZE SOLUTE RUNOFF NET FLUX ACCUMULATORS
C
      TQRAL(NY,NX)=0.0
      TQRFE(NY,NX)=0.0
      TQRHY(NY,NX)=0.0
      TQRCA(NY,NX)=0.0
      TQRMG(NY,NX)=0.0
      TQRNA(NY,NX)=0.0
      TQRKA(NY,NX)=0.0
      TQROH(NY,NX)=0.0
      TQRSO(NY,NX)=0.0
      TQRCL(NY,NX)=0.0
      TQRC3(NY,NX)=0.0
      TQRHC(NY,NX)=0.0
      TQRAL1(NY,NX)=0.0
      TQRAL2(NY,NX)=0.0
      TQRAL3(NY,NX)=0.0
      TQRAL4(NY,NX)=0.0
      TQRALS(NY,NX)=0.0
      TQRFE1(NY,NX)=0.0
      TQRFE2(NY,NX)=0.0
      TQRFE3(NY,NX)=0.0
      TQRFE4(NY,NX)=0.0
      TQRFES(NY,NX)=0.0
      TQRCAO(NY,NX)=0.0
      TQRCAC(NY,NX)=0.0
      TQRCAH(NY,NX)=0.0
      TQRCAS(NY,NX)=0.0
      TQRMGO(NY,NX)=0.0
      TQRMGC(NY,NX)=0.0
      TQRMGH(NY,NX)=0.0
      TQRMGS(NY,NX)=0.0
      TQRNAC(NY,NX)=0.0
      TQRNAS(NY,NX)=0.0
      TQRKAS(NY,NX)=0.0
      TQRH0P(NY,NX)=0.0
      TQRH3P(NY,NX)=0.0
      TQRF1P(NY,NX)=0.0
      TQRF2P(NY,NX)=0.0
      TQRC0P(NY,NX)=0.0
      TQRC1P(NY,NX)=0.0
      TQRC2P(NY,NX)=0.0
      TQRM1P(NY,NX)=0.0
      TQSAL(NY,NX)=0.0
      TQSFE(NY,NX)=0.0
      TQSHY(NY,NX)=0.0
      TQSCA(NY,NX)=0.0
      TQSMG(NY,NX)=0.0
      TQSNA(NY,NX)=0.0
      TQSKA(NY,NX)=0.0
      TQSOH(NY,NX)=0.0
      TQSSO(NY,NX)=0.0
      TQSCL(NY,NX)=0.0
      TQSC3(NY,NX)=0.0
      TQSHC(NY,NX)=0.0
      TQSAL1(NY,NX)=0.0
      TQSAL2(NY,NX)=0.0
      TQSAL3(NY,NX)=0.0
      TQSAL4(NY,NX)=0.0
      TQSALS(NY,NX)=0.0
      TQSFE1(NY,NX)=0.0
      TQSFE2(NY,NX)=0.0
      TQSFE3(NY,NX)=0.0
      TQSFE4(NY,NX)=0.0
      TQSFES(NY,NX)=0.0
      TQSCAO(NY,NX)=0.0
      TQSCAC(NY,NX)=0.0
      TQSCAH(NY,NX)=0.0
      TQSCAS(NY,NX)=0.0
      TQSMGO(NY,NX)=0.0
      TQSMGC(NY,NX)=0.0
      TQSMGH(NY,NX)=0.0
      TQSMGS(NY,NX)=0.0
      TQSNAC(NY,NX)=0.0
      TQSNAS(NY,NX)=0.0
      TQSKAS(NY,NX)=0.0
      TQSH0P(NY,NX)=0.0
      TQSH3P(NY,NX)=0.0
      TQSF1P(NY,NX)=0.0
      TQSF2P(NY,NX)=0.0
      TQSC0P(NY,NX)=0.0
      TQSC1P(NY,NX)=0.0
      TQSC2P(NY,NX)=0.0
      TQSM1P(NY,NX)=0.0
C
C     INITIALIZE SNOWPACK NET FLUX ACCUMULATORS
C
      DO 9855 L=1,JS
      TALBLS(L,NY,NX)=0.0
      TFEBLS(L,NY,NX)=0.0
      THYBLS(L,NY,NX)=0.0
      TCABLS(L,NY,NX)=0.0
      TMGBLS(L,NY,NX)=0.0
      TNABLS(L,NY,NX)=0.0
      TKABLS(L,NY,NX)=0.0
      TOHBLS(L,NY,NX)=0.0
      TSOBLS(L,NY,NX)=0.0
      TCLBLS(L,NY,NX)=0.0
      TC3BLS(L,NY,NX)=0.0
      THCBLS(L,NY,NX)=0.0
      TAL1BS(L,NY,NX)=0.0
      TAL2BS(L,NY,NX)=0.0
      TAL3BS(L,NY,NX)=0.0
      TAL4BS(L,NY,NX)=0.0
      TALSBS(L,NY,NX)=0.0
      TFE1BS(L,NY,NX)=0.0
      TFE2BS(L,NY,NX)=0.0
      TFE3BS(L,NY,NX)=0.0
      TFE4BS(L,NY,NX)=0.0
      TFESBS(L,NY,NX)=0.0
      TCAOBS(L,NY,NX)=0.0
      TCACBS(L,NY,NX)=0.0
      TCAHBS(L,NY,NX)=0.0
      TCASBS(L,NY,NX)=0.0
      TMGOBS(L,NY,NX)=0.0
      TMGCBS(L,NY,NX)=0.0
      TMGHBS(L,NY,NX)=0.0
      TMGSBS(L,NY,NX)=0.0
      TNACBS(L,NY,NX)=0.0
      TNASBS(L,NY,NX)=0.0
      TKASBS(L,NY,NX)=0.0
      TH0PBS(L,NY,NX)=0.0
      TH3PBS(L,NY,NX)=0.0
      TF1PBS(L,NY,NX)=0.0
      TF2PBS(L,NY,NX)=0.0
      TC0PBS(L,NY,NX)=0.0
      TC1PBS(L,NY,NX)=0.0
      TC2PBS(L,NY,NX)=0.0
      TM1PBS(L,NY,NX)=0.0
9855  CONTINUE
C
C     INITIALIZE SOIL SOLUTE NET FLUX ACCUMULATORS
C
      DO 9885 L=NU(NY,NX),NL(NY,NX)
      TALFLS(L,NY,NX)=0.0
      TFEFLS(L,NY,NX)=0.0
      THYFLS(L,NY,NX)=0.0
      TCAFLS(L,NY,NX)=0.0
      TMGFLS(L,NY,NX)=0.0
      TNAFLS(L,NY,NX)=0.0
      TKAFLS(L,NY,NX)=0.0
      TOHFLS(L,NY,NX)=0.0
      TSOFLS(L,NY,NX)=0.0
      TCLFLS(L,NY,NX)=0.0
      TC3FLS(L,NY,NX)=0.0
      THCFLS(L,NY,NX)=0.0
      TAL1FS(L,NY,NX)=0.0
      TAL2FS(L,NY,NX)=0.0
      TAL3FS(L,NY,NX)=0.0
      TAL4FS(L,NY,NX)=0.0
      TALSFS(L,NY,NX)=0.0
      TFE1FS(L,NY,NX)=0.0
      TFE2FS(L,NY,NX)=0.0
      TFE3FS(L,NY,NX)=0.0
      TFE4FS(L,NY,NX)=0.0
      TFESFS(L,NY,NX)=0.0
      TCAOFS(L,NY,NX)=0.0
      TCACFS(L,NY,NX)=0.0
      TCAHFS(L,NY,NX)=0.0
      TCASFS(L,NY,NX)=0.0
      TMGOFS(L,NY,NX)=0.0
      TMGCFS(L,NY,NX)=0.0
      TMGHFS(L,NY,NX)=0.0
      TMGSFS(L,NY,NX)=0.0
      TNACFS(L,NY,NX)=0.0
      TNASFS(L,NY,NX)=0.0
      TKASFS(L,NY,NX)=0.0
      TH0PFS(L,NY,NX)=0.0
      TH3PFS(L,NY,NX)=0.0
      TF1PFS(L,NY,NX)=0.0
      TF2PFS(L,NY,NX)=0.0
      TC0PFS(L,NY,NX)=0.0
      TC1PFS(L,NY,NX)=0.0
      TC2PFS(L,NY,NX)=0.0
      TM1PFS(L,NY,NX)=0.0
      TH0BFB(L,NY,NX)=0.0
      TH3BFB(L,NY,NX)=0.0
      TF1BFB(L,NY,NX)=0.0
      TF2BFB(L,NY,NX)=0.0
      TC0BFB(L,NY,NX)=0.0
      TC1BFB(L,NY,NX)=0.0
      TC2BFB(L,NY,NX)=0.0
      TM1BFB(L,NY,NX)=0.0
      TALFHS(L,NY,NX)=0.0
      TFEFHS(L,NY,NX)=0.0
      THYFHS(L,NY,NX)=0.0
      TCAFHS(L,NY,NX)=0.0
      TMGFHS(L,NY,NX)=0.0
      TNAFHS(L,NY,NX)=0.0
      TKAFHS(L,NY,NX)=0.0
      TOHFHS(L,NY,NX)=0.0
      TSOFHS(L,NY,NX)=0.0
      TCLFHS(L,NY,NX)=0.0
      TC3FHS(L,NY,NX)=0.0
      THCFHS(L,NY,NX)=0.0
      TAL1HS(L,NY,NX)=0.0
      TAL2HS(L,NY,NX)=0.0
      TAL3HS(L,NY,NX)=0.0
      TAL4HS(L,NY,NX)=0.0
      TALSHS(L,NY,NX)=0.0
      TFE1HS(L,NY,NX)=0.0
      TFE2HS(L,NY,NX)=0.0
      TFE3HS(L,NY,NX)=0.0
      TFE4HS(L,NY,NX)=0.0
      TFESHS(L,NY,NX)=0.0
      TCAOHS(L,NY,NX)=0.0
      TCACHS(L,NY,NX)=0.0
      TCAHHS(L,NY,NX)=0.0
      TCASHS(L,NY,NX)=0.0
      TMGOHS(L,NY,NX)=0.0
      TMGCHS(L,NY,NX)=0.0
      TMGHHS(L,NY,NX)=0.0
      TMGSHS(L,NY,NX)=0.0
      TNACHS(L,NY,NX)=0.0
      TNASHS(L,NY,NX)=0.0
      TKASHS(L,NY,NX)=0.0
      TH0PHS(L,NY,NX)=0.0
      TH3PHS(L,NY,NX)=0.0
      TF1PHS(L,NY,NX)=0.0
      TF2PHS(L,NY,NX)=0.0
      TC0PHS(L,NY,NX)=0.0
      TC1PHS(L,NY,NX)=0.0
      TC2PHS(L,NY,NX)=0.0
      TM1PHS(L,NY,NX)=0.0
      TH0BHB(L,NY,NX)=0.0
      TH3BHB(L,NY,NX)=0.0
      TF1BHB(L,NY,NX)=0.0
      TF2BHB(L,NY,NX)=0.0
      TC0BHB(L,NY,NX)=0.0
      TC1BHB(L,NY,NX)=0.0
      TC2BHB(L,NY,NX)=0.0
      TM1BHB(L,NY,NX)=0.0
C
C     ADD SINKS FROM SOLUTE.F   
C
C     RZ*2=solute flux at time step for flux calculations
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      ZAL2(L,NY,NX)=ZAL2(L,NY,NX)-RZAL2(L,NY,NX) 
      ZFE2(L,NY,NX)=ZFE2(L,NY,NX)-RZFE2(L,NY,NX) 
      ZHY2(L,NY,NX)=ZHY2(L,NY,NX)-RZHY2(L,NY,NX) 
      ZCA2(L,NY,NX)=ZCA2(L,NY,NX)-RZCA2(L,NY,NX)
      ZMG2(L,NY,NX)=ZMG2(L,NY,NX)-RZMG2(L,NY,NX)
      ZNA2(L,NY,NX)=ZNA2(L,NY,NX)-RZNA2(L,NY,NX)
      ZKA2(L,NY,NX)=ZKA2(L,NY,NX)-RZKA2(L,NY,NX)
      ZOH2(L,NY,NX)=ZOH2(L,NY,NX)-RZOH2(L,NY,NX)
      ZSO42(L,NY,NX)=ZSO42(L,NY,NX)-RZSO42(L,NY,NX) 
      ZCL2(L,NY,NX)=ZCL2(L,NY,NX)-RZCL2(L,NY,NX)
      ZCO32(L,NY,NX)=ZCO32(L,NY,NX)-RZCO32(L,NY,NX)
      ZHCO32(L,NY,NX)=ZHCO32(L,NY,NX)-RZHCO32(L,NY,NX) 
      ZAL12(L,NY,NX)=ZAL12(L,NY,NX)-RZAL12(L,NY,NX)
      ZAL22(L,NY,NX)=ZAL22(L,NY,NX)-RZAL22(L,NY,NX)
      ZAL32(L,NY,NX)=ZAL32(L,NY,NX)-RZAL32(L,NY,NX)
      ZAL42(L,NY,NX)=ZAL42(L,NY,NX)-RZAL42(L,NY,NX)
      ZALS2(L,NY,NX)=ZALS2(L,NY,NX)-RZALS2(L,NY,NX)
      ZFE12(L,NY,NX)=ZFE12(L,NY,NX)-RZFE12(L,NY,NX)
      ZFE22(L,NY,NX)=ZFE22(L,NY,NX)-RZFE22(L,NY,NX)
      ZFE32(L,NY,NX)=ZFE32(L,NY,NX)-RZFE32(L,NY,NX)
      ZFE42(L,NY,NX)=ZFE42(L,NY,NX)-RZFE42(L,NY,NX)
      ZFES2(L,NY,NX)=ZFES2(L,NY,NX)-RZFES2(L,NY,NX)
      ZCAO2(L,NY,NX)=ZCAO2(L,NY,NX)-RZCAO2(L,NY,NX)
      ZCAC2(L,NY,NX)=ZCAC2(L,NY,NX)-RZCAC2(L,NY,NX)
      ZCAH2(L,NY,NX)=ZCAH2(L,NY,NX)-RZCAH2(L,NY,NX)
      ZCAS2(L,NY,NX)=ZCAS2(L,NY,NX)-RZCAS2(L,NY,NX)
      ZMGO2(L,NY,NX)=ZMGO2(L,NY,NX)-RZMGO2(L,NY,NX)
      ZMGC2(L,NY,NX)=ZMGC2(L,NY,NX)-RZMGC2(L,NY,NX)
      ZMGH2(L,NY,NX)=ZMGH2(L,NY,NX)-RZMGH2(L,NY,NX)
      ZMGS2(L,NY,NX)=ZMGS2(L,NY,NX)-RZMGS2(L,NY,NX)
      ZNAC2(L,NY,NX)=ZNAC2(L,NY,NX)-RZNAC2(L,NY,NX)
      ZNAS2(L,NY,NX)=ZNAS2(L,NY,NX)-RZNAS2(L,NY,NX)
      ZKAS2(L,NY,NX)=ZKAS2(L,NY,NX)-RZKAS2(L,NY,NX)
      H0PO42(L,NY,NX)=H0PO42(L,NY,NX)-RH0PO42(L,NY,NX)
      H3PO42(L,NY,NX)=H3PO42(L,NY,NX)-RH3PO42(L,NY,NX)
      ZFE1P2(L,NY,NX)=ZFE1P2(L,NY,NX)-RZFE1P2(L,NY,NX)
      ZFE2P2(L,NY,NX)=ZFE2P2(L,NY,NX)-RZFE2P2(L,NY,NX)
      ZCA0P2(L,NY,NX)=ZCA0P2(L,NY,NX)-RZCA0P2(L,NY,NX)
      ZCA1P2(L,NY,NX)=ZCA1P2(L,NY,NX)-RZCA1P2(L,NY,NX)
      ZCA2P2(L,NY,NX)=ZCA2P2(L,NY,NX)-RZCA2P2(L,NY,NX)
      ZMG1P2(L,NY,NX)=ZMG1P2(L,NY,NX)-RZMG1P2(L,NY,NX)
      H0POB2(L,NY,NX)=H0POB2(L,NY,NX)-RH0POB2(L,NY,NX)
      H3POB2(L,NY,NX)=H3POB2(L,NY,NX)-RH3POB2(L,NY,NX)
      ZF1PB2(L,NY,NX)=ZF1PB2(L,NY,NX)-RZF1PB2(L,NY,NX)
      ZF2PB2(L,NY,NX)=ZF2PB2(L,NY,NX)-RZF2PB2(L,NY,NX)
      ZC0PB2(L,NY,NX)=ZC0PB2(L,NY,NX)-RZC0PB2(L,NY,NX)
      ZC1PB2(L,NY,NX)=ZC1PB2(L,NY,NX)-RZC1PB2(L,NY,NX)
      ZC2PB2(L,NY,NX)=ZC2PB2(L,NY,NX)-RZC2PB2(L,NY,NX)
      ZM1PB2(L,NY,NX)=ZM1PB2(L,NY,NX)-RZM1PB2(L,NY,NX)
9885  CONTINUE
C
C     SOLUTE FLUXES FROM MELTING SNOWPACK TO
C     SOIL SURFACE FROM SNOWMELT IN 'WATSUB' AND
C     CONCENTRATIONS IN SNOWPACK
C
C     VHCPWM,VHCPWX=current,minimum volumetric heat capacity of snowpack
C     VOLWSL=snowpack water content
C     FLQWM=snowpack water flux
C     R*BLS=solute flux in snowpack
C     X*BLS=hourly solute flux in snowpack
C
      ICHKL=0
      DO 9775 L=1,JS
      IF(VHCPWM(M,L,NY,NX).GT.VHCPWX(NY,NX))THEN 
      L2=MIN(JS,L+1)
      IF(L.LT.JS.AND.VHCPWM(M,L2,NY,NX).GT.VHCPWX(NY,NX))THEN
      IF(VOLWSL(L,NY,NX).GT.ZEROS2(NY,NX))THEN
      VFLWW=AMAX1(0.0,AMIN1(1.0,FLQWM(M,L2,NY,NX)/VOLWSL(L,NY,NX)))
      ELSE
      VFLWW=1.0
      ENDIF
      RALBLS(L2,NY,NX)=ZALW2(L,NY,NX)*VFLWW
      RFEBLS(L2,NY,NX)=ZFEW2(L,NY,NX)*VFLWW
      RHYBLS(L2,NY,NX)=ZHYW2(L,NY,NX)*VFLWW
      RCABLS(L2,NY,NX)=ZCAW2(L,NY,NX)*VFLWW
      RMGBLS(L2,NY,NX)=ZMGW2(L,NY,NX)*VFLWW
      RNABLS(L2,NY,NX)=ZNAW2(L,NY,NX)*VFLWW
      RKABLS(L2,NY,NX)=ZKAW2(L,NY,NX)*VFLWW
      ROHBLS(L2,NY,NX)=ZOHW2(L,NY,NX)*VFLWW
      RSOBLS(L2,NY,NX)=ZSO4W2(L,NY,NX)*VFLWW
      RCLBLS(L2,NY,NX)=ZCLW2(L,NY,NX)*VFLWW
      RC3BLS(L2,NY,NX)=ZCO3W2(L,NY,NX)*VFLWW
      RHCBLS(L2,NY,NX)=ZHCO3W2(L,NY,NX)*VFLWW
      RAL1BS(L2,NY,NX)=ZALH1W2(L,NY,NX)*VFLWW
      RAL2BS(L2,NY,NX)=ZALH2W2(L,NY,NX)*VFLWW
      RAL3BS(L2,NY,NX)=ZALH3W2(L,NY,NX)*VFLWW
      RAL4BS(L2,NY,NX)=ZALH4W2(L,NY,NX)*VFLWW
      RALSBS(L2,NY,NX)=ZALSW2(L,NY,NX)*VFLWW
      RFE1BS(L2,NY,NX)=ZFEH1W2(L,NY,NX)*VFLWW
      RFE2BS(L2,NY,NX)=ZFEH2W2(L,NY,NX)*VFLWW
      RFE3BS(L2,NY,NX)=ZFEH3W2(L,NY,NX)*VFLWW
      RFE4BS(L2,NY,NX)=ZFEH4W2(L,NY,NX)*VFLWW
      RFESBS(L2,NY,NX)=ZFESW2(L,NY,NX)*VFLWW
      RCAOBS(L2,NY,NX)=ZCAOW2(L,NY,NX)*VFLWW
      RCACBS(L2,NY,NX)=ZCACW2(L,NY,NX)*VFLWW
      RCAHBS(L2,NY,NX)=ZCAHW2(L,NY,NX)*VFLWW
      RCASBS(L2,NY,NX)=ZCASW2(L,NY,NX)*VFLWW
      RMGOBS(L2,NY,NX)=ZMGOW2(L,NY,NX)*VFLWW
      RMGCBS(L2,NY,NX)=ZMGCW2(L,NY,NX)*VFLWW
      RMGHBS(L2,NY,NX)=ZMGHW2(L,NY,NX)*VFLWW
      RMGSBS(L2,NY,NX)=ZMGSW2(L,NY,NX)*VFLWW
      RNACBS(L2,NY,NX)=ZNACW2(L,NY,NX)*VFLWW
      RNASBS(L2,NY,NX)=ZNASW2(L,NY,NX)*VFLWW
      RKASBS(L2,NY,NX)=ZKASW2(L,NY,NX)*VFLWW
      RH0PBS(L2,NY,NX)=H0PO4W2(L,NY,NX)*VFLWW
      RH3PBS(L2,NY,NX)=H3PO4W2(L,NY,NX)*VFLWW
      RF1PBS(L2,NY,NX)=ZFE1PW2(L,NY,NX)*VFLWW
      RF2PBS(L2,NY,NX)=ZFE2PW2(L,NY,NX)*VFLWW
      RC0PBS(L2,NY,NX)=ZCA0PW2(L,NY,NX)*VFLWW
      RC1PBS(L2,NY,NX)=ZCA1PW2(L,NY,NX)*VFLWW
      RC2PBS(L2,NY,NX)=ZCA2PW2(L,NY,NX)*VFLWW
      RM1PBS(L2,NY,NX)=ZMG1PW2(L,NY,NX)*VFLWW
      XALBLS(L2,NY,NX)=XALBLS(L2,NY,NX)+RALBLS(L2,NY,NX)
      XFEBLS(L2,NY,NX)=XFEBLS(L2,NY,NX)+RFEBLS(L2,NY,NX)
      XHYBLS(L2,NY,NX)=XHYBLS(L2,NY,NX)+RHYBLS(L2,NY,NX)
      XCABLS(L2,NY,NX)=XCABLS(L2,NY,NX)+RCABLS(L2,NY,NX)
      XMGBLS(L2,NY,NX)=XMGBLS(L2,NY,NX)+RMGBLS(L2,NY,NX)
      XNABLS(L2,NY,NX)=XNABLS(L2,NY,NX)+RNABLS(L2,NY,NX)
      XKABLS(L2,NY,NX)=XKABLS(L2,NY,NX)+RKABLS(L2,NY,NX)
      XOHBLS(L2,NY,NX)=XOHBLS(L2,NY,NX)+ROHBLS(L2,NY,NX)
      XSOBLS(L2,NY,NX)=XSOBLS(L2,NY,NX)+RSOBLS(L2,NY,NX)
      XCLBLS(L2,NY,NX)=XCLBLS(L2,NY,NX)+RCLBLS(L2,NY,NX)
      XC3BLS(L2,NY,NX)=XC3BLS(L2,NY,NX)+RC3BLS(L2,NY,NX)
      XHCBLS(L2,NY,NX)=XHCBLS(L2,NY,NX)+RHCBLS(L2,NY,NX)
      XAL1BS(L2,NY,NX)=XAL1BS(L2,NY,NX)+RAL1BS(L2,NY,NX)
      XAL2BS(L2,NY,NX)=XAL2BS(L2,NY,NX)+RAL2BS(L2,NY,NX)
      XAL3BS(L2,NY,NX)=XAL3BS(L2,NY,NX)+RAL3BS(L2,NY,NX)
      XAL4BS(L2,NY,NX)=XAL4BS(L2,NY,NX)+RAL4BS(L2,NY,NX)
      XALSBS(L2,NY,NX)=XALSBS(L2,NY,NX)+RALSBS(L2,NY,NX)
      XFE1BS(L2,NY,NX)=XFE1BS(L2,NY,NX)+RFE1BS(L2,NY,NX)
      XFE2BS(L2,NY,NX)=XFE2BS(L2,NY,NX)+RFE2BS(L2,NY,NX)
      XFE3BS(L2,NY,NX)=XFE3BS(L2,NY,NX)+RFE3BS(L2,NY,NX)
      XFE4BS(L2,NY,NX)=XFE4BS(L2,NY,NX)+RFE4BS(L2,NY,NX)
      XFESBS(L2,NY,NX)=XFESBS(L2,NY,NX)+RFESBS(L2,NY,NX)
      XCAOBS(L2,NY,NX)=XCAOBS(L2,NY,NX)+RCAOBS(L2,NY,NX)
      XCACBS(L2,NY,NX)=XCACBS(L2,NY,NX)+RCACBS(L2,NY,NX)
      XCAHBS(L2,NY,NX)=XCAHBS(L2,NY,NX)+RCAHBS(L2,NY,NX)
      XCASBS(L2,NY,NX)=XCASBS(L2,NY,NX)+RCASBS(L2,NY,NX)
      XMGOBS(L2,NY,NX)=XMGOBS(L2,NY,NX)+RMGOBS(L2,NY,NX)
      XMGCBS(L2,NY,NX)=XMGCBS(L2,NY,NX)+RMGCBS(L2,NY,NX)
      XMGHBS(L2,NY,NX)=XMGHBS(L2,NY,NX)+RMGHBS(L2,NY,NX)
      XMGSBS(L2,NY,NX)=XMGSBS(L2,NY,NX)+RMGSBS(L2,NY,NX)
      XNACBS(L2,NY,NX)=XNACBS(L2,NY,NX)+RNACBS(L2,NY,NX)
      XNASBS(L2,NY,NX)=XNASBS(L2,NY,NX)+RNASBS(L2,NY,NX)
      XKASBS(L2,NY,NX)=XKASBS(L2,NY,NX)+RKASBS(L2,NY,NX)
      XH0PBS(L2,NY,NX)=XH0PBS(L2,NY,NX)+RH0PBS(L2,NY,NX)
      XH3PBS(L2,NY,NX)=XH3PBS(L2,NY,NX)+RH3PBS(L2,NY,NX)
      XF1PBS(L2,NY,NX)=XF1PBS(L2,NY,NX)+RF1PBS(L2,NY,NX)
      XF2PBS(L2,NY,NX)=XF2PBS(L2,NY,NX)+RF2PBS(L2,NY,NX)
      XC0PBS(L2,NY,NX)=XC0PBS(L2,NY,NX)+RC0PBS(L2,NY,NX)
      XC1PBS(L2,NY,NX)=XC1PBS(L2,NY,NX)+RC1PBS(L2,NY,NX)
      XC2PBS(L2,NY,NX)=XC2PBS(L2,NY,NX)+RC2PBS(L2,NY,NX)
      XM1PBS(L2,NY,NX)=XM1PBS(L2,NY,NX)+RM1PBS(L2,NY,NX)
      ELSE
      IF(L.LT.JS)THEN
      RALBLS(L2,NY,NX)=0.0
      RFEBLS(L2,NY,NX)=0.0
      RHYBLS(L2,NY,NX)=0.0
      RCABLS(L2,NY,NX)=0.0
      RMGBLS(L2,NY,NX)=0.0
      RNABLS(L2,NY,NX)=0.0
      RKABLS(L2,NY,NX)=0.0
      ROHBLS(L2,NY,NX)=0.0
      RSOBLS(L2,NY,NX)=0.0
      RCLBLS(L2,NY,NX)=0.0
      RC3BLS(L2,NY,NX)=0.0
      RHCBLS(L2,NY,NX)=0.0
      RAL1BS(L2,NY,NX)=0.0
      RAL2BS(L2,NY,NX)=0.0
      RAL3BS(L2,NY,NX)=0.0
      RAL4BS(L2,NY,NX)=0.0
      RALSBS(L2,NY,NX)=0.0
      RFE1BS(L2,NY,NX)=0.0
      RFE2BS(L2,NY,NX)=0.0
      RFE3BS(L2,NY,NX)=0.0
      RFE4BS(L2,NY,NX)=0.0
      RFESBS(L2,NY,NX)=0.0
      RCAOBS(L2,NY,NX)=0.0
      RCACBS(L2,NY,NX)=0.0
      RCAHBS(L2,NY,NX)=0.0
      RCASBS(L2,NY,NX)=0.0
      RMGOBS(L2,NY,NX)=0.0
      RMGCBS(L2,NY,NX)=0.0
      RMGHBS(L2,NY,NX)=0.0
      RMGSBS(L2,NY,NX)=0.0
      RNACBS(L2,NY,NX)=0.0
      RNASBS(L2,NY,NX)=0.0
      RKASBS(L2,NY,NX)=0.0
      RH0PBS(L2,NY,NX)=0.0
      RH3PBS(L2,NY,NX)=0.0
      RF1PBS(L2,NY,NX)=0.0
      RF2PBS(L2,NY,NX)=0.0
      RC0PBS(L2,NY,NX)=0.0
      RC1PBS(L2,NY,NX)=0.0
      RC2PBS(L2,NY,NX)=0.0
      RM1PBS(L2,NY,NX)=0.0
      ENDIF
C
C     SNOWPACK SOLUTE DISCHARGE TO SURFACE LITTER, SOIL SURFACE
C
C     VOLWSL=snowpack water content
C     FLQRM,FLQSM,FLQHM=total water flux to litter,soil micropore,macropore
C     CVRD,BARE=litter cover fraction,1-CVRD
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C     R*S0=solute flux to surface litter
C     R*S1,R*B1=solute flux to soil surface non-band,band 
C
      IF(ICHKL.EQ.0)THEN
      IF(VOLWSL(L,NY,NX).GT.ZEROS2(NY,NX))THEN
      VFLWR=AMAX1(0.0,AMIN1(1.0,FLQRM(M,NY,NX)/VOLWSL(L,NY,NX)))
      VFLWS=AMAX1(0.0,AMIN1(1.0,(FLQSM(M,NY,NX)+FLQHM(M,NY,NX))
     2/VOLWSL(L,NY,NX)))
      ELSE
      VFLWR=CVRD(NY,NX)
      VFLWS=BARE(NY,NX)
      ENDIF
      VFLWPO4=VFLWS*VLPO4(NU(NY,NX),NY,NX)
      VFLWPOB=VFLWS*VLPOB(NU(NY,NX),NY,NX)
      RALFLS0=ZALW2(L,NY,NX)*VFLWR
      RFEFLS0=ZFEW2(L,NY,NX)*VFLWR
      RHYFLS0=ZHYW2(L,NY,NX)*VFLWR
      RCAFLS0=ZCAW2(L,NY,NX)*VFLWR
      RMGFLS0=ZMGW2(L,NY,NX)*VFLWR
      RNAFLS0=ZNAW2(L,NY,NX)*VFLWR
      RKAFLS0=ZKAW2(L,NY,NX)*VFLWR
      ROHFLS0=ZOHW2(L,NY,NX)*VFLWR
      RSOFLS0=ZSO4W2(L,NY,NX)*VFLWR
      RCLFLS0=ZCLW2(L,NY,NX)*VFLWR
      RC3FLS0=ZCO3W2(L,NY,NX)*VFLWR
      RHCFLS0=ZHCO3W2(L,NY,NX)*VFLWR
      RAL1FS0=ZALH1W2(L,NY,NX)*VFLWR
      RAL2FS0=ZALH2W2(L,NY,NX)*VFLWR
      RAL3FS0=ZALH3W2(L,NY,NX)*VFLWR
      RAL4FS0=ZALH4W2(L,NY,NX)*VFLWR
      RALSFS0=ZALSW2(L,NY,NX)*VFLWR
      RFE1FS0=ZFEH1W2(L,NY,NX)*VFLWR
      RFE2FS0=ZFEH2W2(L,NY,NX)*VFLWR
      RFE3FS0=ZFEH3W2(L,NY,NX)*VFLWR
      RFE4FS0=ZFEH4W2(L,NY,NX)*VFLWR
      RFESFS0=ZFESW2(L,NY,NX)*VFLWR
      RCAOFS0=ZCAOW2(L,NY,NX)*VFLWR
      RCACFS0=ZCACW2(L,NY,NX)*VFLWR
      RCAHFS0=ZCAHW2(L,NY,NX)*VFLWR
      RCASFS0=ZCASW2(L,NY,NX)*VFLWR
      RMGOFS0=ZMGOW2(L,NY,NX)*VFLWR
      RMGCFS0=ZMGCW2(L,NY,NX)*VFLWR
      RMGHFS0=ZMGHW2(L,NY,NX)*VFLWR
      RMGSFS0=ZMGSW2(L,NY,NX)*VFLWR
      RNACFS0=ZNACW2(L,NY,NX)*VFLWR
      RNASFS0=ZNASW2(L,NY,NX)*VFLWR
      RKASFS0=ZKASW2(L,NY,NX)*VFLWR
      RH0PFS0=H0PO4W2(L,NY,NX)*VFLWR
      RH3PFS0=H3PO4W2(L,NY,NX)*VFLWR
      RF1PFS0=ZFE1PW2(L,NY,NX)*VFLWR
      RF2PFS0=ZFE2PW2(L,NY,NX)*VFLWR
      RC0PFS0=ZCA0PW2(L,NY,NX)*VFLWR
      RC1PFS0=ZCA1PW2(L,NY,NX)*VFLWR
      RC2PFS0=ZCA2PW2(L,NY,NX)*VFLWR
      RM1PFS0=ZMG1PW2(L,NY,NX)*VFLWR
      RALFLS1=ZALW2(L,NY,NX)*VFLWS
      RFEFLS1=ZFEW2(L,NY,NX)*VFLWS
      RHYFLS1=ZHYW2(L,NY,NX)*VFLWS
      RCAFLS1=ZCAW2(L,NY,NX)*VFLWS
      RMGFLS1=ZMGW2(L,NY,NX)*VFLWS
      RNAFLS1=ZNAW2(L,NY,NX)*VFLWS
      RKAFLS1=ZKAW2(L,NY,NX)*VFLWS
      ROHFLS1=ZOHW2(L,NY,NX)*VFLWS
      RSOFLS1=ZSO4W2(L,NY,NX)*VFLWS
      RCLFLS1=ZCLW2(L,NY,NX)*VFLWS
      RC3FLS1=ZCO3W2(L,NY,NX)*VFLWS
      RHCFLS1=ZHCO3W2(L,NY,NX)*VFLWS
      RAL1FS1=ZALH1W2(L,NY,NX)*VFLWS 
      RAL2FS1=ZALH2W2(L,NY,NX)*VFLWS 
      RAL3FS1=ZALH3W2(L,NY,NX)*VFLWS 
      RAL4FS1=ZALH4W2(L,NY,NX)*VFLWS 
      RALSFS1=ZALSW2(L,NY,NX)*VFLWS 
      RFE1FS1=ZFEH1W2(L,NY,NX)*VFLWS 
      RFE2FS1=ZFEH2W2(L,NY,NX)*VFLWS 
      RFE3FS1=ZFEH3W2(L,NY,NX)*VFLWS 
      RFE4FS1=ZFEH4W2(L,NY,NX)*VFLWS 
      RFESFS1=ZFESW2(L,NY,NX)*VFLWS 
      RCAOFS1=ZCAOW2(L,NY,NX)*VFLWS 
      RCACFS1=ZCACW2(L,NY,NX)*VFLWS 
      RCAHFS1=ZCAHW2(L,NY,NX)*VFLWS 
      RCASFS1=ZCASW2(L,NY,NX)*VFLWS 
      RMGOFS1=ZMGOW2(L,NY,NX)*VFLWS 
      RMGCFS1=ZMGCW2(L,NY,NX)*VFLWS 
      RMGHFS1=ZMGHW2(L,NY,NX)*VFLWS 
      RMGSFS1=ZMGSW2(L,NY,NX)*VFLWS 
      RNACFS1=ZNACW2(L,NY,NX)*VFLWS 
      RNASFS1=ZNASW2(L,NY,NX)*VFLWS 
      RKASFS1=ZKASW2(L,NY,NX)*VFLWS 
      RH0PFS1=H0PO4W2(L,NY,NX)*VFLWPO4
      RH3PFS1=H3PO4W2(L,NY,NX)*VFLWPO4 
      RF1PFS1=ZFE1PW2(L,NY,NX)*VFLWPO4
      RF2PFS1=ZFE2PW2(L,NY,NX)*VFLWPO4
      RC0PFS1=ZCA0PW2(L,NY,NX)*VFLWPO4
      RC1PFS1=ZCA1PW2(L,NY,NX)*VFLWPO4
      RC2PFS1=ZCA2PW2(L,NY,NX)*VFLWPO4
      RM1PFS1=ZMG1PW2(L,NY,NX)*VFLWPO4
      RH0BFB1=H0PO4W2(L,NY,NX)*VFLWPOB
      RH3BFB1=H3PO4W2(L,NY,NX)*VFLWPOB
      RF1BFB1=ZFE1PW2(L,NY,NX)*VFLWPOB
      RF2BFB1=ZFE2PW2(L,NY,NX)*VFLWPOB
      RC0BFB1=ZCA0PW2(L,NY,NX)*VFLWPOB
      RC1BFB1=ZCA1PW2(L,NY,NX)*VFLWPOB
      RC2BFB1=ZCA2PW2(L,NY,NX)*VFLWPOB
      RM1BFB1=ZMG1PW2(L,NY,NX)*VFLWPOB
      ICHKL=1
      ENDIF
      ENDIF
      ELSE
      RALFLS0=0.0
      RFEFLS0=0.0
      RHYFLS0=0.0
      RCAFLS0=0.0
      RMGFLS0=0.0
      RNAFLS0=0.0
      RKAFLS0=0.0
      ROHFLS0=0.0
      RSOFLS0=0.0
      RCLFLS0=0.0
      RC3FLS0=0.0
      RHCFLS0=0.0
      RAL1FS0=0.0
      RAL2FS0=0.0
      RAL3FS0=0.0
      RAL4FS0=0.0
      RALSFS0=0.0
      RFE1FS0=0.0
      RFE2FS0=0.0
      RFE3FS0=0.0
      RFE4FS0=0.0
      RFESFS0=0.0
      RCAOFS0=0.0
      RCACFS0=0.0
      RCAHFS0=0.0
      RCASFS0=0.0
      RMGOFS0=0.0
      RMGCFS0=0.0
      RMGHFS0=0.0
      RMGSFS0=0.0
      RNACFS0=0.0
      RNASFS0=0.0
      RKASFS0=0.0
      RH0PFS0=0.0
      RH3PFS0=0.0
      RF1PFS0=0.0
      RF2PFS0=0.0
      RC0PFS0=0.0
      RC1PFS0=0.0
      RC2PFS0=0.0
      RM1PFS0=0.0
      RALFLS1=0.0
      RFEFLS1=0.0
      RHYFLS1=0.0
      RCAFLS1=0.0
      RMGFLS1=0.0
      RNAFLS1=0.0
      RKAFLS1=0.0
      ROHFLS1=0.0
      RSOFLS1=0.0
      RCLFLS1=0.0
      RC3FLS1=0.0
      RHCFLS1=0.0
      RAL1FS1=0.0
      RAL2FS1=0.0
      RAL3FS1=0.0
      RAL4FS1=0.0
      RALSFS1=0.0
      RFE1FS1=0.0
      RFE2FS1=0.0
      RFE3FS1=0.0
      RFE4FS1=0.0
      RFESFS1=0.0
      RCAOFS1=0.0
      RCACFS1=0.0
      RCAHFS1=0.0
      RCASFS1=0.0
      RMGOFS1=0.0
      RMGCFS1=0.0
      RMGHFS1=0.0
      RMGSFS1=0.0
      RNACFS1=0.0
      RNASFS1=0.0
      RKASFS1=0.0
      RH0PFS1=0.0
      RH3PFS1=0.0
      RF1PFS1=0.0
      RF2PFS1=0.0
      RC0PFS1=0.0
      RC1PFS1=0.0
      RC2PFS1=0.0
      RM1PFS1=0.0
      RH0BFB1=0.0
      RH3BFB1=0.0
      RF1BFB1=0.0
      RF2BFB1=0.0
      RC0BFB1=0.0
      RC1BFB1=0.0
      RC2BFB1=0.0
      RM1BFB1=0.0
      ENDIF
9775  CONTINUE

C
C     CONVECTIVE SOLUTE EXCHANGE BETWEEN RESIDUE AND SOIL SURFACE
C
      FLWRM1=FLWRM(M,NY,NX) 
C 
C     FLWRM=litter-soil water flux from watsub.f
C
C     IF WATER FLUX FROM 'WATSUB' IS FROM RESIDUE TO
C     SOIL SURFACE THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MICROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN RESIDUE
C
C     VOLWM=litter water volume
C     RFL*=soil-litter convective solute flux
C     Z*2=litter solute content
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C
      IF(FLWRM1.GT.0.0)THEN   
      IF(VOLWM(M,0,NY,NX).GT.ZEROS2(NY,NX))THEN
      VFLW=AMAX1(0.0,AMIN1(VFLWX,FLWRM1/VOLWM(M,0,NY,NX)))
      ELSE
      VFLW=VFLWX 
      ENDIF
      RFLAL=VFLW*AMAX1(0.0,ZAL2(0,NY,NX))
      RFLFE=VFLW*AMAX1(0.0,ZFE2(0,NY,NX))
      RFLHY=VFLW*AMAX1(0.0,ZHY2(0,NY,NX))
      RFLCA=VFLW*AMAX1(0.0,ZCA2(0,NY,NX))
      RFLMG=VFLW*AMAX1(0.0,ZMG2(0,NY,NX))
      RFLNA=VFLW*AMAX1(0.0,ZNA2(0,NY,NX))
      RFLKA=VFLW*AMAX1(0.0,ZKA2(0,NY,NX))
      RFLOH=VFLW*AMAX1(0.0,ZOH2(0,NY,NX))
      RFLSO=VFLW*AMAX1(0.0,ZSO42(0,NY,NX))
      RFLCL=VFLW*AMAX1(0.0,ZCL2(0,NY,NX))
      RFLC3=VFLW*AMAX1(0.0,ZCO32(0,NY,NX))
      RFLHC=VFLW*AMAX1(0.0,ZHCO32(0,NY,NX))
      RFLAL1=VFLW*AMAX1(0.0,ZAL12(0,NY,NX))
      RFLAL2=VFLW*AMAX1(0.0,ZAL22(0,NY,NX))
      RFLAL3=VFLW*AMAX1(0.0,ZAL32(0,NY,NX))
      RFLAL4=VFLW*AMAX1(0.0,ZAL42(0,NY,NX))
      RFLALS=VFLW*AMAX1(0.0,ZALS2(0,NY,NX))
      RFLFE1=VFLW*AMAX1(0.0,ZFE12(0,NY,NX))
      RFLFE2=VFLW*AMAX1(0.0,ZFE22(0,NY,NX))
      RFLFE3=VFLW*AMAX1(0.0,ZFE32(0,NY,NX))
      RFLFE4=VFLW*AMAX1(0.0,ZFE42(0,NY,NX))
      RFLFES=VFLW*AMAX1(0.0,ZFES2(0,NY,NX))
      RFLCAO=VFLW*AMAX1(0.0,ZCAO2(0,NY,NX))
      RFLCAC=VFLW*AMAX1(0.0,ZCAC2(0,NY,NX))
      RFLCAH=VFLW*AMAX1(0.0,ZCAH2(0,NY,NX))
      RFLCAS=VFLW*AMAX1(0.0,ZCAS2(0,NY,NX))
      RFLMGO=VFLW*AMAX1(0.0,ZMGO2(0,NY,NX))
      RFLMGC=VFLW*AMAX1(0.0,ZMGC2(0,NY,NX))
      RFLMGH=VFLW*AMAX1(0.0,ZMGH2(0,NY,NX))
      RFLMGS=VFLW*AMAX1(0.0,ZMGS2(0,NY,NX))
      RFLNAC=VFLW*AMAX1(0.0,ZNAC2(0,NY,NX))
      RFLNAS=VFLW*AMAX1(0.0,ZNAS2(0,NY,NX))
      RFLKAS=VFLW*AMAX1(0.0,ZKAS2(0,NY,NX))
      RFLH0P=VFLW*AMAX1(0.0,H0PO42(0,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      RFLH3P=VFLW*AMAX1(0.0,H3PO42(0,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      RFLF1P=VFLW*AMAX1(0.0,ZFE1P2(0,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      RFLF2P=VFLW*AMAX1(0.0,ZFE2P2(0,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      RFLC0P=VFLW*AMAX1(0.0,ZCA0P2(0,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      RFLC1P=VFLW*AMAX1(0.0,ZCA1P2(0,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      RFLC2P=VFLW*AMAX1(0.0,ZCA2P2(0,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      RFLM1P=VFLW*AMAX1(0.0,ZMG1P2(0,NY,NX))*VLPO4(NU(NY,NX),NY,NX)
      RFLH0B=VFLW*AMAX1(0.0,H0PO42(0,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      RFLH3B=VFLW*AMAX1(0.0,H3PO42(0,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      RFLF1B=VFLW*AMAX1(0.0,ZFE1P2(0,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      RFLF2B=VFLW*AMAX1(0.0,ZFE2P2(0,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      RFLC0B=VFLW*AMAX1(0.0,ZCA0P2(0,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      RFLC1B=VFLW*AMAX1(0.0,ZCA1P2(0,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      RFLC2B=VFLW*AMAX1(0.0,ZCA2P2(0,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
      RFLM1B=VFLW*AMAX1(0.0,ZMG1P2(0,NY,NX))*VLPOB(NU(NY,NX),NY,NX)
C
C     IF WATER FLUX FROM 'WATSUB' IS TO RESIDUE FROM
C     SOIL SURFACE THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MICROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN SOIL SURFACE
C
C     VOLWM=litter water volume
C     RFL*=soil-litter convective solute flux
C     Z*2=soil solute content
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C
      ELSE
      IF(VOLWM(M,NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      VFLW=AMIN1(0.0,AMAX1(-VFLWX,FLWRM1/VOLWM(M,NU(NY,NX),NY,NX)))
      ELSE
      VFLW=-VFLWX 
      ENDIF
      RFLAL=VFLW*AMAX1(0.0,ZAL2(NU(NY,NX),NY,NX))
      RFLFE=VFLW*AMAX1(0.0,ZFE2(NU(NY,NX),NY,NX))
      RFLHY=VFLW*AMAX1(0.0,ZHY2(NU(NY,NX),NY,NX))
      RFLCA=VFLW*AMAX1(0.0,ZCA2(NU(NY,NX),NY,NX))
      RFLMG=VFLW*AMAX1(0.0,ZMG2(NU(NY,NX),NY,NX))
      RFLNA=VFLW*AMAX1(0.0,ZNA2(NU(NY,NX),NY,NX))
      RFLKA=VFLW*AMAX1(0.0,ZKA2(NU(NY,NX),NY,NX))
      RFLOH=VFLW*AMAX1(0.0,ZOH2(NU(NY,NX),NY,NX))
      RFLSO=VFLW*AMAX1(0.0,ZSO42(NU(NY,NX),NY,NX))
      RFLCL=VFLW*AMAX1(0.0,ZCL2(NU(NY,NX),NY,NX))
      RFLC3=VFLW*AMAX1(0.0,ZCO32(NU(NY,NX),NY,NX))
      RFLHC=VFLW*AMAX1(0.0,ZHCO32(NU(NY,NX),NY,NX))
      RFLAL1=VFLW*AMAX1(0.0,ZAL12(NU(NY,NX),NY,NX))
      RFLAL2=VFLW*AMAX1(0.0,ZAL22(NU(NY,NX),NY,NX))
      RFLAL3=VFLW*AMAX1(0.0,ZAL32(NU(NY,NX),NY,NX))
      RFLAL4=VFLW*AMAX1(0.0,ZAL42(NU(NY,NX),NY,NX))
      RFLALS=VFLW*AMAX1(0.0,ZALS2(NU(NY,NX),NY,NX))
      RFLFE1=VFLW*AMAX1(0.0,ZFE12(NU(NY,NX),NY,NX))
      RFLFE2=VFLW*AMAX1(0.0,ZFE22(NU(NY,NX),NY,NX))
      RFLFE3=VFLW*AMAX1(0.0,ZFE32(NU(NY,NX),NY,NX))
      RFLFE4=VFLW*AMAX1(0.0,ZFE42(NU(NY,NX),NY,NX))
      RFLFES=VFLW*AMAX1(0.0,ZFES2(NU(NY,NX),NY,NX))
      RFLCAO=VFLW*AMAX1(0.0,ZCAO2(NU(NY,NX),NY,NX))
      RFLCAC=VFLW*AMAX1(0.0,ZCAC2(NU(NY,NX),NY,NX))
      RFLCAH=VFLW*AMAX1(0.0,ZCAH2(NU(NY,NX),NY,NX))
      RFLCAS=VFLW*AMAX1(0.0,ZCAS2(NU(NY,NX),NY,NX))
      RFLMGO=VFLW*AMAX1(0.0,ZMGO2(NU(NY,NX),NY,NX))
      RFLMGC=VFLW*AMAX1(0.0,ZMGC2(NU(NY,NX),NY,NX))
      RFLMGH=VFLW*AMAX1(0.0,ZMGH2(NU(NY,NX),NY,NX))
      RFLMGS=VFLW*AMAX1(0.0,ZMGS2(NU(NY,NX),NY,NX))
      RFLNAC=VFLW*AMAX1(0.0,ZNAC2(NU(NY,NX),NY,NX))
      RFLNAS=VFLW*AMAX1(0.0,ZNAS2(NU(NY,NX),NY,NX))
      RFLKAS=VFLW*AMAX1(0.0,ZKAS2(NU(NY,NX),NY,NX))
      RFLH0P=VFLW*AMAX1(0.0,H0PO42(NU(NY,NX),NY,NX))
      RFLH3P=VFLW*AMAX1(0.0,H3PO42(NU(NY,NX),NY,NX))
      RFLF1P=VFLW*AMAX1(0.0,ZFE1P2(NU(NY,NX),NY,NX))
      RFLF2P=VFLW*AMAX1(0.0,ZFE2P2(NU(NY,NX),NY,NX))
      RFLC0P=VFLW*AMAX1(0.0,ZCA0P2(NU(NY,NX),NY,NX))
      RFLC1P=VFLW*AMAX1(0.0,ZCA1P2(NU(NY,NX),NY,NX))
      RFLC2P=VFLW*AMAX1(0.0,ZCA2P2(NU(NY,NX),NY,NX))
      RFLM1P=VFLW*AMAX1(0.0,ZMG1P2(NU(NY,NX),NY,NX))
      RFLH0B=VFLW*AMAX1(0.0,H0POB2(NU(NY,NX),NY,NX))
      RFLH3B=VFLW*AMAX1(0.0,H3POB2(NU(NY,NX),NY,NX))
      RFLF1B=VFLW*AMAX1(0.0,ZF1PB2(NU(NY,NX),NY,NX))
      RFLF2B=VFLW*AMAX1(0.0,ZF2PB2(NU(NY,NX),NY,NX))
      RFLC0B=VFLW*AMAX1(0.0,ZC0PB2(NU(NY,NX),NY,NX))
      RFLC1B=VFLW*AMAX1(0.0,ZC1PB2(NU(NY,NX),NY,NX))
      RFLC2B=VFLW*AMAX1(0.0,ZC2PB2(NU(NY,NX),NY,NX))
      RFLM1B=VFLW*AMAX1(0.0,ZM1PB2(NU(NY,NX),NY,NX))
      ENDIF
C
C     DIFFUSIVE FLUXES OF GASES AND SOLUTES BETWEEN RESIDUE AND
C     SOIL SURFACE FROM AQUEOUS DIFFUSIVITIES
C     AND CONCENTRATION DIFFERENCES
C
C     VOLT,DLYR,AREA=soil surface volume, thickness, area
C     VOLWM=micropore water-filled porosity from watsub.f
C
      IF((VOLT(0,NY,NX).GT.ZEROS(NY,NX) 
     2.AND.VOLWM(M,0,NY,NX).GT.ZEROS2(NY,NX))
     3.AND.(VOLWM(M,NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX)))THEN
C
C     MICROPORE CONCENTRATIONS FROM WATER IN RESIDUE AND SOIL SURFACE
C
C     C*1,C*2=solute concentration in litter, soil
C     Z*1,Z*2=solute content in litter, soil
C
      VOLWPA=VOLWM(M,NU(NY,NX),NY,NX)*VLPO4(NU(NY,NX),NY,NX)
      VOLWPB=VOLWM(M,NU(NY,NX),NY,NX)*VLPOB(NU(NY,NX),NY,NX)
      CAL1=AMAX1(0.0,ZAL2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CFE1=AMAX1(0.0,ZFE2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CHY1=AMAX1(0.0,ZHY2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CCA1=AMAX1(0.0,ZCA2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CMG1=AMAX1(0.0,ZMG2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CNA1=AMAX1(0.0,ZNA2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CKA1=AMAX1(0.0,ZKA2(0,NY,NX)/VOLWM(M,0,NY,NX))
      COH1=AMAX1(0.0,ZOH2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CSO41=AMAX1(0.0,ZSO42(0,NY,NX)/VOLWM(M,0,NY,NX))
      CCL1=AMAX1(0.0,ZCL2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CCO31=AMAX1(0.0,ZCO32(0,NY,NX)/VOLWM(M,0,NY,NX))
      CHCO31=AMAX1(0.0,ZHCO32(0,NY,NX)/VOLWM(M,0,NY,NX))
      CAL11=AMAX1(0.0,ZAL12(0,NY,NX)/VOLWM(M,0,NY,NX))
      CAL21=AMAX1(0.0,ZAL22(0,NY,NX)/VOLWM(M,0,NY,NX))
      CAL31=AMAX1(0.0,ZAL32(0,NY,NX)/VOLWM(M,0,NY,NX))
      CAL41=AMAX1(0.0,ZAL42(0,NY,NX)/VOLWM(M,0,NY,NX))
      CALS1=AMAX1(0.0,ZALS2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CFE11=AMAX1(0.0,ZFE12(0,NY,NX)/VOLWM(M,0,NY,NX))
      CFE21=AMAX1(0.0,ZFE22(0,NY,NX)/VOLWM(M,0,NY,NX))
      CFE31=AMAX1(0.0,ZFE32(0,NY,NX)/VOLWM(M,0,NY,NX))
      CFE41=AMAX1(0.0,ZFE42(0,NY,NX)/VOLWM(M,0,NY,NX))
      CFES1=AMAX1(0.0,ZFES2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CCAO1=AMAX1(0.0,ZCAO2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CCAC1=AMAX1(0.0,ZCAC2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CCAH1=AMAX1(0.0,ZCAH2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CCAS1=AMAX1(0.0,ZCAS2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CMGO1=AMAX1(0.0,ZMGO2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CMGC1=AMAX1(0.0,ZMGC2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CMGH1=AMAX1(0.0,ZMGH2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CMGS1=AMAX1(0.0,ZMGS2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CNAC1=AMAX1(0.0,ZNAC2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CNAS1=AMAX1(0.0,ZNAS2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CKAS1=AMAX1(0.0,ZKAS2(0,NY,NX)/VOLWM(M,0,NY,NX))
      C0PO41=AMAX1(0.0,H0PO42(0,NY,NX)/VOLWM(M,0,NY,NX))
      C3PO41=AMAX1(0.0,H3PO42(0,NY,NX)/VOLWM(M,0,NY,NX))
      CFE1P1=AMAX1(0.0,ZFE1P2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CFE2P1=AMAX1(0.0,ZFE2P2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CCA0P1=AMAX1(0.0,ZCA0P2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CCA1P1=AMAX1(0.0,ZCA1P2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CCA2P1=AMAX1(0.0,ZCA2P2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CMG1P1=AMAX1(0.0,ZMG1P2(0,NY,NX)/VOLWM(M,0,NY,NX))
      CAL2=AMAX1(0.0,ZAL2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CFE2=AMAX1(0.0,ZFE2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CHY2=AMAX1(0.0,ZHY2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CCA2=AMAX1(0.0,ZCA2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CMG2=AMAX1(0.0,ZMG2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CNA2=AMAX1(0.0,ZNA2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CKA2=AMAX1(0.0,ZKA2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      COH2=AMAX1(0.0,ZOH2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CSO42=AMAX1(0.0,ZSO42(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CCL2=AMAX1(0.0,ZCL2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CCO32=AMAX1(0.0,ZCO32(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CHCO32=AMAX1(0.0,ZHCO32(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CAL12=AMAX1(0.0,ZAL12(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CAL22=AMAX1(0.0,ZAL22(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CAL32=AMAX1(0.0,ZAL32(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CAL42=AMAX1(0.0,ZAL42(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CALS2=AMAX1(0.0,ZALS2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CFE12=AMAX1(0.0,ZFE12(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CFE22=AMAX1(0.0,ZFE22(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CFE32=AMAX1(0.0,ZFE32(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CFE42=AMAX1(0.0,ZFE42(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CFES2=AMAX1(0.0,ZFES2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CCAO2=AMAX1(0.0,ZCAO2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CCAC2=AMAX1(0.0,ZCAC2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CCAH2=AMAX1(0.0,ZCAH2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CCAS2=AMAX1(0.0,ZCAS2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CMGO2=AMAX1(0.0,ZMGO2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CMGC2=AMAX1(0.0,ZMGC2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CMGH2=AMAX1(0.0,ZMGH2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CMGS2=AMAX1(0.0,ZMGS2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CNAC2=AMAX1(0.0,ZNAC2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CNAS2=AMAX1(0.0,ZNAS2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      CKAS2=AMAX1(0.0,ZKAS2(NU(NY,NX),NY,NX)/VOLWM(M,NU(NY,NX),NY,NX))
      IF(VOLWPA.GT.ZEROS2(NY,NX))THEN
      C0PO42=AMAX1(0.0,H0PO42(NU(NY,NX),NY,NX)/VOLWPA)
      C3PO42=AMAX1(0.0,H3PO42(NU(NY,NX),NY,NX)/VOLWPA)
      CFE1P2=AMAX1(0.0,ZFE1P2(NU(NY,NX),NY,NX)/VOLWPA)
      CFE2P2=AMAX1(0.0,ZFE2P2(NU(NY,NX),NY,NX)/VOLWPA)
      CCA0P2=AMAX1(0.0,ZCA0P2(NU(NY,NX),NY,NX)/VOLWPA)
      CCA1P2=AMAX1(0.0,ZCA1P2(NU(NY,NX),NY,NX)/VOLWPA)
      CCA2P2=AMAX1(0.0,ZCA2P2(NU(NY,NX),NY,NX)/VOLWPA)
      CMG1P2=AMAX1(0.0,ZMG1P2(NU(NY,NX),NY,NX)/VOLWPA)
      ELSE
      C0PO42=0.0
      C3PO42=0.0
      CFE1P2=0.0
      CFE2P2=0.0
      CCA0P2=0.0
      CCA1P2=0.0
      CCA2P2=0.0
      CMG1P2=0.0
      ENDIF
      IF(VOLWPB.GT.ZEROS2(NY,NX))THEN
      C0POB2=AMAX1(0.0,H0POB2(NU(NY,NX),NY,NX)/VOLWPB)
      C3POB2=AMAX1(0.0,H3POB2(NU(NY,NX),NY,NX)/VOLWPB)
      CF1PB2=AMAX1(0.0,ZF1PB2(NU(NY,NX),NY,NX)/VOLWPB)
      CF2PB2=AMAX1(0.0,ZF2PB2(NU(NY,NX),NY,NX)/VOLWPB)
      CC0PB2=AMAX1(0.0,ZC0PB2(NU(NY,NX),NY,NX)/VOLWPB)
      CC1PB2=AMAX1(0.0,ZC1PB2(NU(NY,NX),NY,NX)/VOLWPB)
      CC2PB2=AMAX1(0.0,ZC2PB2(NU(NY,NX),NY,NX)/VOLWPB)
      CM1PB2=AMAX1(0.0,ZM1PB2(NU(NY,NX),NY,NX)/VOLWPB)
      ELSE
      C0POB2=C0PO42
      C3POB2=C3PO42
      CF1PB2=CFE1P2
      CF2PB2=CFE2P2
      CC0PB2=CCA0P2
      CC1PB2=CCA1P2
      CC2PB2=CCA2P2
      CM1PB2=CMG1P2
      ENDIF
C
C     DIFFUSIVITIES IN RESIDUE AND SOIL SURFACE
C
C     DLYR0,DLYR1=litter, soil surface thickness    
C     TORT=tortuosity from hour1.f 
C     CVRD,BARE=litter cover fraction,1-CVRD
C     DISP=dispersivity parameter
C     FLWRM=litter-soil water flux from watsub.f
C     DIF*=aqueous diffusivity-dispersivity in soil surface 
C     *SGL*=solute diffusivity from hour1.f
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     DIF*=aqueous diffusivity-dispersivity between litter and soil surface
C
      DLYR0=AMAX1(ZERO2,DLYR(3,0,NY,NX))
      TORT0=TORT(M,0,NY,NX)*CVRD(NY,NX)
      DLYR1=AMAX1(ZERO2,DLYR(3,NU(NY,NX),NY,NX))
      TORT1=TORT(M,NU(NY,NX),NY,NX) 
      TORTL=AMIN1(1.0,(TORT0+TORT1)/(DLYR0+DLYR1))
      DISPN=DISP(3,NU(NY,NX),NY,NX)
     2*AMIN1(VFLWX,ABS(FLWRM1/AREA(3,NU(NY,NX),NY,NX)))
      DIFPO=(POSGL2(NU(NY,NX),NY,NX)*TORTL+DISPN)
     2*AREA(3,NU(NY,NX),NY,NX)
      DIFAL=(ALSGL2(NU(NY,NX),NY,NX)*TORTL+DISPN)
     2*AREA(3,NU(NY,NX),NY,NX)
      DIFFE=(FESGL2(NU(NY,NX),NY,NX)*TORTL+DISPN)
     2*AREA(3,NU(NY,NX),NY,NX)
      DIFHY=(HYSGL2(NU(NY,NX),NY,NX)*TORTL+DISPN)
     2*AREA(3,NU(NY,NX),NY,NX)
      DIFCA=(CASGL2(NU(NY,NX),NY,NX)*TORTL+DISPN)
     2*AREA(3,NU(NY,NX),NY,NX)
      DIFMG=(GMSGL2(NU(NY,NX),NY,NX)*TORTL+DISPN)
     2*AREA(3,NU(NY,NX),NY,NX)
      DIFNA=(ANSGL2(NU(NY,NX),NY,NX)*TORTL+DISPN)
     2*AREA(3,NU(NY,NX),NY,NX)
      DIFKA=(AKSGL2(NU(NY,NX),NY,NX)*TORTL+DISPN)
     2*AREA(3,NU(NY,NX),NY,NX)
      DIFOH=(OHSGL2(NU(NY,NX),NY,NX)*TORTL+DISPN)
     2*AREA(3,NU(NY,NX),NY,NX)
      DIFSO=(SOSGL2(NU(NY,NX),NY,NX)*TORTL+DISPN)
     2*AREA(3,NU(NY,NX),NY,NX)
      DIFCL=(CLSXL2(NU(NY,NX),NY,NX)*TORTL+DISPN)
     2*AREA(3,NU(NY,NX),NY,NX)
      DIFC3=(C3SGL2(NU(NY,NX),NY,NX)*TORTL+DISPN)
     2*AREA(3,NU(NY,NX),NY,NX)
      DIFHC=(HCSGL2(NU(NY,NX),NY,NX)*TORTL+DISPN)
     2*AREA(3,NU(NY,NX),NY,NX)
C
C     DIFFUSIVE FLUXES BETWEEN CURRENT AND ADJACENT GRID CELL
C     MICROPORES
C
C     DFV*S,DFV*B=diffusive solute flux between litter and soil surface in non-band,band
C     DIF*=aqueous diffusivity-dispersivity between litter and soil surface
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     C*1,C*2=solute concentration in litter,soil surface
C
      DFVAL=DIFAL*(CAL1-CAL2)
      DFVFE=DIFFE*(CFE1-CFE2)
      DFVHY=DIFHY*(CHY1-CHY2)
      DFVCA=DIFCA*(CCA1-CCA2)
      DFVMG=DIFMG*(CMG1-CMG2)
      DFVNA=DIFNA*(CNA1-CNA2)
      DFVKA=DIFKA*(CKA1-CKA2)
      DFVOH=DIFOH*(COH1-COH2)
      DFVSO=DIFSO*(CSO41-CSO42)
      DFVCL=DIFCL*(CCL1-CCL2)
      DFVC3=DIFC3*(CCO31-CCO32)
      DFVHC=DIFHC*(CHCO31-CHCO32)
      DFVAL1=DIFAL*(CAL11-CAL12)
      DFVAL2=DIFAL*(CAL21-CAL22)
      DFVAL3=DIFAL*(CAL31-CAL32)
      DFVAL4=DIFAL*(CAL41-CAL42)
      DFVALS=DIFAL*(CALS1-CALS2)
      DFVFE1=DIFFE*(CFE11-CFE12)
      DFVFE2=DIFFE*(CFE21-CFE22)
      DFVFE3=DIFFE*(CFE31-CFE32)
      DFVFE4=DIFFE*(CFE41-CFE42)
      DFVFES=DIFFE*(CFES1-CFES2)
      DFVCAO=DIFCA*(CCAO1-CCAO2)
      DFVCAC=DIFCA*(CCAC1-CCAC2)
      DFVCAH=DIFCA*(CCAH1-CCAH2)
      DFVCAS=DIFCA*(CCAS1-CCAS2)
      DFVMGO=DIFMG*(CMGO1-CMGO2)
      DFVMGC=DIFMG*(CMGC1-CMGC2)
      DFVMGH=DIFMG*(CMGH1-CMGH2)
      DFVMGS=DIFMG*(CMGS1-CMGS2)
      DFVNAC=DIFNA*(CNAC1-CNAC2)
      DFVNAS=DIFNA*(CNAS1-CNAS2)
      DFVKAS=DIFKA*(CKAS1-CKAS2)
      DFVH0P=DIFPO*(C0PO41-C0PO42)*VLPO4(NU(NY,NX),NY,NX)
      DFVH3P=DIFPO*(C3PO41-C3PO42)*VLPO4(NU(NY,NX),NY,NX)
      DFVF1P=DIFPO*(CFE1P1-CFE1P2)*VLPO4(NU(NY,NX),NY,NX)
      DFVF2P=DIFPO*(CFE2P1-CFE2P2)*VLPO4(NU(NY,NX),NY,NX)
      DFVC0P=DIFPO*(CCA0P1-CCA0P2)*VLPO4(NU(NY,NX),NY,NX)
      DFVC1P=DIFPO*(CCA1P1-CCA1P2)*VLPO4(NU(NY,NX),NY,NX)
      DFVC2P=DIFPO*(CCA2P1-CCA2P2)*VLPO4(NU(NY,NX),NY,NX)
      DFVM1P=DIFPO*(CMG1P1-CMG1P2)*VLPO4(NU(NY,NX),NY,NX)
      DFVH0B=DIFPO*(C0PO41-C0POB2)*VLPOB(NU(NY,NX),NY,NX)
      DFVH3B=DIFPO*(C3PO41-C3POB2)*VLPOB(NU(NY,NX),NY,NX)
      DFVF1B=DIFPO*(CFE1P1-CF1PB2)*VLPOB(NU(NY,NX),NY,NX)
      DFVF2B=DIFPO*(CFE2P1-CF2PB2)*VLPOB(NU(NY,NX),NY,NX)
      DFVC0B=DIFPO*(CCA0P1-CC0PB2)*VLPOB(NU(NY,NX),NY,NX)
      DFVC1B=DIFPO*(CCA1P1-CC1PB2)*VLPOB(NU(NY,NX),NY,NX)
      DFVC2B=DIFPO*(CCA2P1-CC2PB2)*VLPOB(NU(NY,NX),NY,NX)
      DFVM1B=DIFPO*(CMG1P1-CM1PB2)*VLPOB(NU(NY,NX),NY,NX)
      ELSE
      DFVAL=0.0
      DFVFE=0.0
      DFVHY=0.0
      DFVCA=0.0
      DFVMG=0.0
      DFVNA=0.0
      DFVKA=0.0
      DFVOH=0.0
      DFVSO=0.0
      DFVCL=0.0
      DFVC3=0.0
      DFVHC=0.0
      DFVAL1=0.0
      DFVAL2=0.0
      DFVAL3=0.0
      DFVAL4=0.0
      DFVALS=0.0
      DFVFE1=0.0
      DFVFE2=0.0
      DFVFE3=0.0
      DFVFE4=0.0
      DFVFES=0.0
      DFVCAO=0.0
      DFVCAC=0.0
      DFVCAH=0.0
      DFVCAS=0.0
      DFVMGO=0.0
      DFVMGC=0.0
      DFVMGH=0.0
      DFVMGS=0.0
      DFVNAC=0.0
      DFVNAS=0.0
      DFVKAS=0.0
      DFVH0P=0.0
      DFVH3P=0.0
      DFVF1P=0.0
      DFVF2P=0.0
      DFVC0P=0.0
      DFVC1P=0.0
      DFVC2P=0.0
      DFVM1P=0.0
      DFVH0B=0.0
      DFVH3B=0.0
      DFVF1B=0.0
      DFVF2B=0.0
      DFVC0B=0.0
      DFVC1B=0.0
      DFVC2B=0.0
      DFVM1B=0.0
      ENDIF
C
C     TOTAL MICROPORE AND MACROPORE SOLUTE TRANSPORT FLUXES BETWEEN
C     ADJACENT GRID CELLS = CONVECTIVE + DIFFUSIVE FLUXES
C
C
C     R*FLS=convective + diffusive solute flux between litter, soil surface
C     R*FLW,R*FLB=convective + diffusive solute flux into soil in non-band,band
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     R*FL0,R*FL1=convective flux into surface litter, soil surface
C     RFL*=convective flux between surface litter and soil surface 
C     DFV*=diffusive solute flux between litter and soil surface
C
      RALFLS(3,0,NY,NX)=RALFL0(NY,NX)+RALFLS0-RFLAL-DFVAL
      RFEFLS(3,0,NY,NX)=RFEFL0(NY,NX)+RFEFLS0-RFLFE-DFVFE
      RHYFLS(3,0,NY,NX)=RHYFL0(NY,NX)+RHYFLS0-RFLHY-DFVHY
      RCAFLS(3,0,NY,NX)=RCAFL0(NY,NX)+RCAFLS0-RFLCA-DFVCA
      RMGFLS(3,0,NY,NX)=RMGFL0(NY,NX)+RMGFLS0-RFLMG-DFVMG
      RNAFLS(3,0,NY,NX)=RNAFL0(NY,NX)+RNAFLS0-RFLNA-DFVNA
      RKAFLS(3,0,NY,NX)=RKAFL0(NY,NX)+RKAFLS0-RFLKA-DFVKA
      ROHFLS(3,0,NY,NX)=ROHFL0(NY,NX)+ROHFLS0-RFLOH-DFVOH
      RSOFLS(3,0,NY,NX)=RSOFL0(NY,NX)+RSOFLS0-RFLSO-DFVSO
      RCLFLS(3,0,NY,NX)=RCLFL0(NY,NX)+RCLFLS0-RFLCL-DFVCL
      RC3FLS(3,0,NY,NX)=RC3FL0(NY,NX)+RC3FLS0-RFLC3-DFVC3
      RHCFLS(3,0,NY,NX)=RHCFL0(NY,NX)+RHCFLS0-RFLHC-DFVHC
      RAL1FS(3,0,NY,NX)=RAL1F0(NY,NX)+RAL1FS0-RFLAL1-DFVAL1
      RAL2FS(3,0,NY,NX)=RAL2F0(NY,NX)+RAL2FS0-RFLAL2-DFVAL2
      RAL3FS(3,0,NY,NX)=RAL3F0(NY,NX)+RAL3FS0-RFLAL3-DFVAL3
      RAL4FS(3,0,NY,NX)=RAL4F0(NY,NX)+RAL4FS0-RFLAL4-DFVAL4
      RALSFS(3,0,NY,NX)=RALSF0(NY,NX)+RALSFS0-RFLALS-DFVALS
      RFE1FS(3,0,NY,NX)=RFE1F0(NY,NX)+RFE1FS0-RFLFE1-DFVFE1
      RFE2FS(3,0,NY,NX)=RFE2F0(NY,NX)+RFE2FS0-RFLFE2-DFVFE2
      RFE3FS(3,0,NY,NX)=RFE3F0(NY,NX)+RFE3FS0-RFLFE3-DFVFE3
      RFE4FS(3,0,NY,NX)=RFE4F0(NY,NX)+RFE4FS0-RFLFE4-DFVFE4
      RFESFS(3,0,NY,NX)=RFESF0(NY,NX)+RFESFS0-RFLFES-DFVFES
      RCAOFS(3,0,NY,NX)=RCAOF0(NY,NX)+RCAOFS0-RFLCAO-DFVCAO
      RCACFS(3,0,NY,NX)=RCACF0(NY,NX)+RCACFS0-RFLCAC-DFVCAC
      RCAHFS(3,0,NY,NX)=RCAHF0(NY,NX)+RCAHFS0-RFLCAH-DFVCAH
      RCASFS(3,0,NY,NX)=RCASF0(NY,NX)+RCASFS0-RFLCAS-DFVCAS
      RMGOFS(3,0,NY,NX)=RMGOF0(NY,NX)+RMGOFS0-RFLMGO-DFVMGO
      RMGCFS(3,0,NY,NX)=RMGCF0(NY,NX)+RMGCFS0-RFLMGC-DFVMGC
      RMGHFS(3,0,NY,NX)=RMGHF0(NY,NX)+RMGHFS0-RFLMGH-DFVMGH
      RMGSFS(3,0,NY,NX)=RMGSF0(NY,NX)+RMGSFS0-RFLMGS-DFVMGS
      RNACFS(3,0,NY,NX)=RNACF0(NY,NX)+RNACFS0-RFLNAC-DFVNAC
      RNASFS(3,0,NY,NX)=RNASF0(NY,NX)+RNASFS0-RFLNAS-DFVNAS
      RKASFS(3,0,NY,NX)=RKASF0(NY,NX)+RKASFS0-RFLKAS-DFVKAS
      RH0PFS(3,0,NY,NX)=RH0PF0(NY,NX)+RH0PFS0-RFLH0P-DFVH0P
     2-RFLH0B-DFVH0B 
      RH3PFS(3,0,NY,NX)=RH3PF0(NY,NX)+RH3PFS0-RFLH3P-DFVH3P
     2-RFLH3B-DFVH3B 
      RF1PFS(3,0,NY,NX)=RF1PF0(NY,NX)+RF1PFS0-RFLF1P-DFVF1P
     2-RFLF1B-DFVF1B 
      RF2PFS(3,0,NY,NX)=RF2PF0(NY,NX)+RF2PFS0-RFLF2P-DFVF2P
     2-RFLF2B-DFVF2B 
      RC0PFS(3,0,NY,NX)=RC0PF0(NY,NX)+RC0PFS0-RFLC0P-DFVC0P
     2-RFLC0B-DFVC0B 
      RC1PFS(3,0,NY,NX)=RC1PF0(NY,NX)+RC1PFS0-RFLC1P-DFVC1P
     2-RFLC1B-DFVC1B 
      RC2PFS(3,0,NY,NX)=RC2PF0(NY,NX)+RC2PFS0-RFLC2P-DFVC2P
     2-RFLC2B-DFVC2B 
      RM1PFS(3,0,NY,NX)=RM1PF0(NY,NX)+RM1PFS0-RFLM1P-DFVM1P
     2-RFLM1B-DFVM1B
      RALFLS(3,NU(NY,NX),NY,NX)=RALFL1(NY,NX)+RALFLS1+RFLAL+DFVAL
      RFEFLS(3,NU(NY,NX),NY,NX)=RFEFL1(NY,NX)+RFEFLS1+RFLFE+DFVFE
      RHYFLS(3,NU(NY,NX),NY,NX)=RHYFL1(NY,NX)+RHYFLS1+RFLHY+DFVHY
      RCAFLS(3,NU(NY,NX),NY,NX)=RCAFL1(NY,NX)+RCAFLS1+RFLCA+DFVCA
      RMGFLS(3,NU(NY,NX),NY,NX)=RMGFL1(NY,NX)+RMGFLS1+RFLMG+DFVMG
      RNAFLS(3,NU(NY,NX),NY,NX)=RNAFL1(NY,NX)+RNAFLS1+RFLNA+DFVNA
      RKAFLS(3,NU(NY,NX),NY,NX)=RKAFL1(NY,NX)+RKAFLS1+RFLKA+DFVKA
      ROHFLS(3,NU(NY,NX),NY,NX)=ROHFL1(NY,NX)+ROHFLS1+RFLOH+DFVOH
      RSOFLS(3,NU(NY,NX),NY,NX)=RSOFL1(NY,NX)+RSOFLS1+RFLSO+DFVSO
      RCLFLS(3,NU(NY,NX),NY,NX)=RCLFL1(NY,NX)+RCLFLS1+RFLCL+DFVCL
      RC3FLS(3,NU(NY,NX),NY,NX)=RC3FL1(NY,NX)+RC3FLS1+RFLC3+DFVC3
      RHCFLS(3,NU(NY,NX),NY,NX)=RHCFL1(NY,NX)+RHCFLS1+RFLHC+DFVHC
      RAL1FS(3,NU(NY,NX),NY,NX)=RAL1F1(NY,NX)+RAL1FS1+RFLAL1+DFVAL1
      RAL2FS(3,NU(NY,NX),NY,NX)=RAL2F1(NY,NX)+RAL2FS1+RFLAL2+DFVAL2
      RAL3FS(3,NU(NY,NX),NY,NX)=RAL3F1(NY,NX)+RAL3FS1+RFLAL3+DFVAL3
      RAL4FS(3,NU(NY,NX),NY,NX)=RAL4F1(NY,NX)+RAL4FS1+RFLAL4+DFVAL4
      RALSFS(3,NU(NY,NX),NY,NX)=RALSF1(NY,NX)+RALSFS1+RFLALS+DFVALS
      RFE1FS(3,NU(NY,NX),NY,NX)=RFE1F1(NY,NX)+RFE1FS1+RFLFE1+DFVFE1
      RFE2FS(3,NU(NY,NX),NY,NX)=RFE2F1(NY,NX)+RFE2FS1+RFLFE2+DFVFE2
      RFE3FS(3,NU(NY,NX),NY,NX)=RFE3F1(NY,NX)+RFE3FS1+RFLFE3+DFVFE3
      RFE4FS(3,NU(NY,NX),NY,NX)=RFE4F1(NY,NX)+RFE4FS1+RFLFE4+DFVFE4
      RFESFS(3,NU(NY,NX),NY,NX)=RFESF1(NY,NX)+RFESFS1+RFLFES+DFVFES
      RCAOFS(3,NU(NY,NX),NY,NX)=RCAOF1(NY,NX)+RCAOFS1+RFLCAO+DFVCAO
      RCACFS(3,NU(NY,NX),NY,NX)=RCACF1(NY,NX)+RCACFS1+RFLCAC+DFVCAC
      RCAHFS(3,NU(NY,NX),NY,NX)=RCAHF1(NY,NX)+RCAHFS1+RFLCAH+DFVCAH
      RCASFS(3,NU(NY,NX),NY,NX)=RCASF1(NY,NX)+RCASFS1+RFLCAS+DFVCAS
      RMGOFS(3,NU(NY,NX),NY,NX)=RMGOF1(NY,NX)+RMGOFS1+RFLMGO+DFVMGO
      RMGCFS(3,NU(NY,NX),NY,NX)=RMGCF1(NY,NX)+RMGCFS1+RFLMGC+DFVMGC
      RMGHFS(3,NU(NY,NX),NY,NX)=RMGHF1(NY,NX)+RMGHFS1+RFLMGH+DFVMGH
      RMGSFS(3,NU(NY,NX),NY,NX)=RMGSF1(NY,NX)+RMGSFS1+RFLMGS+DFVMGS
      RNACFS(3,NU(NY,NX),NY,NX)=RNACF1(NY,NX)+RNACFS1+RFLNAC+DFVNAC
      RNASFS(3,NU(NY,NX),NY,NX)=RNASF1(NY,NX)+RNASFS1+RFLNAS+DFVNAS
      RKASFS(3,NU(NY,NX),NY,NX)=RKASF1(NY,NX)+RKASFS1+RFLKAS+DFVKAS
      RH0PFS(3,NU(NY,NX),NY,NX)=RH0PF1(NY,NX)+RH0PFS1+RFLH0P+DFVH0P
      RH3PFS(3,NU(NY,NX),NY,NX)=RH3PF1(NY,NX)+RH3PFS1+RFLH3P+DFVH3P
      RF1PFS(3,NU(NY,NX),NY,NX)=RF1PF1(NY,NX)+RF1PFS1+RFLF1P+DFVF1P
      RF2PFS(3,NU(NY,NX),NY,NX)=RF2PF1(NY,NX)+RF2PFS1+RFLF2P+DFVF2P
      RC0PFS(3,NU(NY,NX),NY,NX)=RC0PF1(NY,NX)+RC0PFS1+RFLC0P+DFVC0P
      RC1PFS(3,NU(NY,NX),NY,NX)=RC1PF1(NY,NX)+RC1PFS1+RFLC1P+DFVC1P
      RC2PFS(3,NU(NY,NX),NY,NX)=RC2PF1(NY,NX)+RC2PFS1+RFLC2P+DFVC2P
      RM1PFS(3,NU(NY,NX),NY,NX)=RM1PF1(NY,NX)+RM1PFS1+RFLM1P+DFVM1P
      RH0BFB(3,NU(NY,NX),NY,NX)=RH0BF2(NY,NX)+RH0BFB1+RFLH0B+DFVH0B
      RH3BFB(3,NU(NY,NX),NY,NX)=RH3BF2(NY,NX)+RH3BFB1+RFLH3B+DFVH3B
      RF1BFB(3,NU(NY,NX),NY,NX)=RF1BF2(NY,NX)+RF1BFB1+RFLF1B+DFVF1B
      RF2BFB(3,NU(NY,NX),NY,NX)=RF2BF2(NY,NX)+RF2BFB1+RFLF2B+DFVF2B
      RC0BFB(3,NU(NY,NX),NY,NX)=RC0BF2(NY,NX)+RC0BFB1+RFLC0B+DFVC0B
      RC1BFB(3,NU(NY,NX),NY,NX)=RC1BF2(NY,NX)+RC1BFB1+RFLC1B+DFVC1B
      RC2BFB(3,NU(NY,NX),NY,NX)=RC2BF2(NY,NX)+RC2BFB1+RFLC2B+DFVC2B
      RM1BFB(3,NU(NY,NX),NY,NX)=RM1BF2(NY,NX)+RM1BFB1+RFLM1B+DFVM1B
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*FLS=hourly convective + diffusive solute flux
C     X*FLW,X*FLB= hourly convective + diffusive solute flux in non-band,band
C
      XALFLS(3,0,NY,NX)=XALFLS(3,0,NY,NX)+RALFLS0-RFLAL-DFVAL 
      XFEFLS(3,0,NY,NX)=XFEFLS(3,0,NY,NX)+RFEFLS0-RFLFE-DFVFE 
      XHYFLS(3,0,NY,NX)=XHYFLS(3,0,NY,NX)+RHYFLS0-RFLHY-DFVHY 
      XCAFLS(3,0,NY,NX)=XCAFLS(3,0,NY,NX)+RCAFLS0-RFLCA-DFVCA 
      XMGFLS(3,0,NY,NX)=XMGFLS(3,0,NY,NX)+RMGFLS0-RFLMG-DFVMG
      XNAFLS(3,0,NY,NX)=XNAFLS(3,0,NY,NX)+RNAFLS0-RFLNA-DFVNA
      XKAFLS(3,0,NY,NX)=XKAFLS(3,0,NY,NX)+RKAFLS0-RFLKA-DFVKA
      XOHFLS(3,0,NY,NX)=XOHFLS(3,0,NY,NX)+ROHFLS0-RFLOH-DFVOH
      XSOFLS(3,0,NY,NX)=XSOFLS(3,0,NY,NX)+RSOFLS0-RFLSO-DFVSO
      XCLFLS(3,0,NY,NX)=XCLFLS(3,0,NY,NX)+RCLFLS0-RFLCL-DFVCL
      XC3FLS(3,0,NY,NX)=XC3FLS(3,0,NY,NX)+RC3FLS0-RFLC3-DFVC3
      XHCFLS(3,0,NY,NX)=XHCFLS(3,0,NY,NX)+RHCFLS0-RFLHC-DFVHC
      XAL1FS(3,0,NY,NX)=XAL1FS(3,0,NY,NX)+RAL1FS0-RFLAL1-DFVAL1
      XAL2FS(3,0,NY,NX)=XAL2FS(3,0,NY,NX)+RAL2FS0-RFLAL2-DFVAL2
      XAL3FS(3,0,NY,NX)=XAL3FS(3,0,NY,NX)+RAL3FS0-RFLAL3-DFVAL3
      XAL4FS(3,0,NY,NX)=XAL4FS(3,0,NY,NX)+RAL4FS0-RFLAL4-DFVAL4
      XALSFS(3,0,NY,NX)=XALSFS(3,0,NY,NX)+RALSFS0-RFLALS-DFVALS
      XFE1FS(3,0,NY,NX)=XFE1FS(3,0,NY,NX)+RFE1FS0-RFLFE1-DFVFE1
      XFE2FS(3,0,NY,NX)=XFE2FS(3,0,NY,NX)+RFE2FS0-RFLFE2-DFVFE2
      XFE3FS(3,0,NY,NX)=XFE3FS(3,0,NY,NX)+RFE3FS0-RFLFE3-DFVFE3
      XFE4FS(3,0,NY,NX)=XFE4FS(3,0,NY,NX)+RFE4FS0-RFLFE4-DFVFE4
      XFESFS(3,0,NY,NX)=XFESFS(3,0,NY,NX)+RFESFS0-RFLFES-DFVFES
      XCAOFS(3,0,NY,NX)=XCAOFS(3,0,NY,NX)+RCAOFS0-RFLCAO-DFVCAO
      XCACFS(3,0,NY,NX)=XCACFS(3,0,NY,NX)+RCACFS0-RFLCAC-DFVCAC
      XCAHFS(3,0,NY,NX)=XCAHFS(3,0,NY,NX)+RCAHFS0-RFLCAH-DFVCAH
      XCASFS(3,0,NY,NX)=XCASFS(3,0,NY,NX)+RCASFS0-RFLCAS-DFVCAS
      XMGOFS(3,0,NY,NX)=XMGOFS(3,0,NY,NX)+RMGOFS0-RFLMGO-DFVMGO
      XMGCFS(3,0,NY,NX)=XMGCFS(3,0,NY,NX)+RMGCFS0-RFLMGC-DFVMGC
      XMGHFS(3,0,NY,NX)=XMGHFS(3,0,NY,NX)+RMGHFS0-RFLMGH-DFVMGH
      XMGSFS(3,0,NY,NX)=XMGSFS(3,0,NY,NX)+RMGSFS0-RFLMGS-DFVMGS
      XNACFS(3,0,NY,NX)=XNACFS(3,0,NY,NX)+RNACFS0-RFLNAC-DFVNAC
      XNASFS(3,0,NY,NX)=XNASFS(3,0,NY,NX)+RNASFS0-RFLNAS-DFVNAS
      XKASFS(3,0,NY,NX)=XKASFS(3,0,NY,NX)+RKASFS0-RFLKAS-DFVKAS
      XH0PFS(3,0,NY,NX)=XH0PFS(3,0,NY,NX)+RH0PFS0-RFLH0P-DFVH0P
     2-RFLH0B-DFVH0B
      XH3PFS(3,0,NY,NX)=XH3PFS(3,0,NY,NX)+RH3PFS0-RFLH3P-DFVH3P
     2-RFLH3B-DFVH3B
      XF1PFS(3,0,NY,NX)=XF1PFS(3,0,NY,NX)+RF1PFS0-RFLF1P-DFVF1P
     2-RFLF1B-DFVF1B 
      XF2PFS(3,0,NY,NX)=XF2PFS(3,0,NY,NX)+RF2PFS0-RFLF2P-DFVF2P
     2-RFLF2B-DFVF2B
      XC0PFS(3,0,NY,NX)=XC0PFS(3,0,NY,NX)+RC0PFS0-RFLC0P-DFVC0P
     2-RFLC0B-DFVC0B
      XC1PFS(3,0,NY,NX)=XC1PFS(3,0,NY,NX)+RC1PFS0-RFLC1P-DFVC1P
     2-RFLC1B-DFVC1B
      XC2PFS(3,0,NY,NX)=XC2PFS(3,0,NY,NX)+RC2PFS0-RFLC2P-DFVC2P
     2-RFLC2B-DFVC2B
      XM1PFS(3,0,NY,NX)=XM1PFS(3,0,NY,NX)+RM1PFS0-RFLM1P-DFVM1P
     2-RFLM1B-DFVM1B
      XALFLS(3,NU(NY,NX),NY,NX)=XALFLS(3,NU(NY,NX),NY,NX)+RALFLS1
     2+RFLAL+DFVAL
      XFEFLS(3,NU(NY,NX),NY,NX)=XFEFLS(3,NU(NY,NX),NY,NX)+RFEFLS1
     2+RFLFE+DFVFE
      XHYFLS(3,NU(NY,NX),NY,NX)=XHYFLS(3,NU(NY,NX),NY,NX)+RHYFLS1
     2+RFLHY+DFVHY
      XCAFLS(3,NU(NY,NX),NY,NX)=XCAFLS(3,NU(NY,NX),NY,NX)+RCAFLS1
     2+RFLCA+DFVCA
      XMGFLS(3,NU(NY,NX),NY,NX)=XMGFLS(3,NU(NY,NX),NY,NX)+RMGFLS1
     2+RFLMG+DFVMG
      XNAFLS(3,NU(NY,NX),NY,NX)=XNAFLS(3,NU(NY,NX),NY,NX)+RNAFLS1
     2+RFLNA+DFVNA
      XKAFLS(3,NU(NY,NX),NY,NX)=XKAFLS(3,NU(NY,NX),NY,NX)+RKAFLS1
     2+RFLKA+DFVKA
      XOHFLS(3,NU(NY,NX),NY,NX)=XOHFLS(3,NU(NY,NX),NY,NX)+ROHFLS1
     2+RFLOH+DFVOH
      XSOFLS(3,NU(NY,NX),NY,NX)=XSOFLS(3,NU(NY,NX),NY,NX)+RSOFLS1
     2+RFLSO+DFVSO
      XCLFLS(3,NU(NY,NX),NY,NX)=XCLFLS(3,NU(NY,NX),NY,NX)+RCLFLS1
     2+RFLCL+DFVCL
      XC3FLS(3,NU(NY,NX),NY,NX)=XC3FLS(3,NU(NY,NX),NY,NX)+RC3FLS1
     2+RFLC3+DFVC3
      XHCFLS(3,NU(NY,NX),NY,NX)=XHCFLS(3,NU(NY,NX),NY,NX)+RHCFLS1
     2+RFLHC+DFVHC
      XAL1FS(3,NU(NY,NX),NY,NX)=XAL1FS(3,NU(NY,NX),NY,NX)+RAL1FS1
     2+RFLAL1+DFVAL1
      XAL2FS(3,NU(NY,NX),NY,NX)=XAL2FS(3,NU(NY,NX),NY,NX)+RAL2FS1
     2+RFLAL2+DFVAL2
      XAL3FS(3,NU(NY,NX),NY,NX)=XAL3FS(3,NU(NY,NX),NY,NX)+RAL3FS1
     2+RFLAL3+DFVAL3
      XAL4FS(3,NU(NY,NX),NY,NX)=XAL4FS(3,NU(NY,NX),NY,NX)+RAL4FS1
     2+RFLAL4+DFVAL4
      XALSFS(3,NU(NY,NX),NY,NX)=XALSFS(3,NU(NY,NX),NY,NX)+RALSFS1
     2+RFLALS+DFVALS
      XFE1FS(3,NU(NY,NX),NY,NX)=XFE1FS(3,NU(NY,NX),NY,NX)+RFE1FS1
     2+RFLFE1+DFVFE1
      XFE2FS(3,NU(NY,NX),NY,NX)=XFE2FS(3,NU(NY,NX),NY,NX)+RFE2FS1
     2+RFLFE2+DFVFE2
      XFE3FS(3,NU(NY,NX),NY,NX)=XFE3FS(3,NU(NY,NX),NY,NX)+RFE3FS1
     2+RFLFE3+DFVFE3
      XFE4FS(3,NU(NY,NX),NY,NX)=XFE4FS(3,NU(NY,NX),NY,NX)+RFE4FS1
     2+RFLFE4+DFVFE4
      XFESFS(3,NU(NY,NX),NY,NX)=XFESFS(3,NU(NY,NX),NY,NX)+RFESFS1
     2+RFLFES+DFVFES
      XCAOFS(3,NU(NY,NX),NY,NX)=XCAOFS(3,NU(NY,NX),NY,NX)+RCAOFS1
     2+RFLCAO+DFVCAO 
      XCACFS(3,NU(NY,NX),NY,NX)=XCACFS(3,NU(NY,NX),NY,NX)+RCACFS1
     2+RFLCAC+DFVCAC
      XCAHFS(3,NU(NY,NX),NY,NX)=XCAHFS(3,NU(NY,NX),NY,NX)+RCAHFS1
     2+RFLCAH+DFVCAH
      XCASFS(3,NU(NY,NX),NY,NX)=XCASFS(3,NU(NY,NX),NY,NX)+RCASFS1
     2+RFLCAS+DFVCAS
      XMGOFS(3,NU(NY,NX),NY,NX)=XMGOFS(3,NU(NY,NX),NY,NX)+RMGOFS1
     2+RFLMGO+DFVMGO
      XMGCFS(3,NU(NY,NX),NY,NX)=XMGCFS(3,NU(NY,NX),NY,NX)+RMGCFS1
     2+RFLMGC+DFVMGC
      XMGHFS(3,NU(NY,NX),NY,NX)=XMGHFS(3,NU(NY,NX),NY,NX)+RMGHFS1
     2+RFLMGH+DFVMGH
      XMGSFS(3,NU(NY,NX),NY,NX)=XMGSFS(3,NU(NY,NX),NY,NX)+RMGSFS1
     2+RFLMGS+DFVMGS
      XNACFS(3,NU(NY,NX),NY,NX)=XNACFS(3,NU(NY,NX),NY,NX)+RNACFS1
     2+RFLNAC+DFVNAC
      XNASFS(3,NU(NY,NX),NY,NX)=XNASFS(3,NU(NY,NX),NY,NX)+RNASFS1
     2+RFLNAS+DFVNAS
      XKASFS(3,NU(NY,NX),NY,NX)=XKASFS(3,NU(NY,NX),NY,NX)+RKASFS1
     2+RFLKAS+DFVKAS
      XH0PFS(3,NU(NY,NX),NY,NX)=XH0PFS(3,NU(NY,NX),NY,NX)+RH0PFS1
     2+RFLH0P+DFVH0P
      XH3PFS(3,NU(NY,NX),NY,NX)=XH3PFS(3,NU(NY,NX),NY,NX)+RH3PFS1
     2+RFLH3P+DFVH3P
      XF1PFS(3,NU(NY,NX),NY,NX)=XF1PFS(3,NU(NY,NX),NY,NX)+RF1PFS1
     2+RFLF1P+DFVF1P
      XF2PFS(3,NU(NY,NX),NY,NX)=XF2PFS(3,NU(NY,NX),NY,NX)+RF2PFS1
     2+RFLF2P+DFVF2P
      XC0PFS(3,NU(NY,NX),NY,NX)=XC0PFS(3,NU(NY,NX),NY,NX)+RC0PFS1
     2+RFLC0P+DFVC0P
      XC1PFS(3,NU(NY,NX),NY,NX)=XC1PFS(3,NU(NY,NX),NY,NX)+RC1PFS1
     2+RFLC1P+DFVC1P
      XC2PFS(3,NU(NY,NX),NY,NX)=XC2PFS(3,NU(NY,NX),NY,NX)+RC2PFS1
     2+RFLC2P+DFVC2P
      XM1PFS(3,NU(NY,NX),NY,NX)=XM1PFS(3,NU(NY,NX),NY,NX)+RM1PFS1
     2+RFLM1P+DFVM1P
      XH0BFB(3,NU(NY,NX),NY,NX)=XH0BFB(3,NU(NY,NX),NY,NX)+RH0BFB1
     2+RFLH0B+DFVH0B
      XH3BFB(3,NU(NY,NX),NY,NX)=XH3BFB(3,NU(NY,NX),NY,NX)+RH3BFB1
     2+RFLH3B+DFVH3B
      XF1BFB(3,NU(NY,NX),NY,NX)=XF1BFB(3,NU(NY,NX),NY,NX)+RF1BFB1
     2+RFLF1B+DFVF1B
      XF2BFB(3,NU(NY,NX),NY,NX)=XF2BFB(3,NU(NY,NX),NY,NX)+RF2BFB1
     2+RFLF2B+DFVF2B
      XC0BFB(3,NU(NY,NX),NY,NX)=XC0BFB(3,NU(NY,NX),NY,NX)+RC0BFB1
     2+RFLC0B+DFVC0B
      XC1BFB(3,NU(NY,NX),NY,NX)=XC1BFB(3,NU(NY,NX),NY,NX)+RC1BFB1
     2+RFLC1B+DFVC1B
      XC2BFB(3,NU(NY,NX),NY,NX)=XC2BFB(3,NU(NY,NX),NY,NX)+RC2BFB1
     2+RFLC2B+DFVC2B
      XM1BFB(3,NU(NY,NX),NY,NX)=XM1BFB(3,NU(NY,NX),NY,NX)+RM1BFB1
     2+RFLM1B+DFVM1B
C
C     MACROPORE-MICROPORE SOLUTE EXCHANGE IN SOIL
C     SURFACE LAYER FROM WATER EXCHANGE IN 'WATSUB' AND
C     FROM MACROPORE OR MICROPORE SOLUTE CONCENTRATIONS
C
C     FINHM=macro-micropore water transfer from watsub.f 
C     VOLWM,VOLWHM=micropore,macropore water volume
C     RFL*=convective macropore-micropore solute transfer 
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     *H2,*2=macropore,micropore solute content
C
C     MACROPORE TO MICROPORE TRANSFER
C
      IF(FINHM(M,NU(NY,NX),NY,NX).GT.0.0)THEN
      IF(VOLWHM(M,NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      VFLW=AMAX1(0.0,AMIN1(VFLWX,FINHM(M,NU(NY,NX),NY,NX)
     2/VOLWHM(M,NU(NY,NX),NY,NX)))
      ELSE
      VFLW=VFLWX
      ENDIF
      RFLAL=VFLW*AMAX1(0.0,ZALH2(NU(NY,NX),NY,NX)) 
      RFLFE=VFLW*AMAX1(0.0,ZFEH2(NU(NY,NX),NY,NX))
      RFLHY=VFLW*AMAX1(0.0,ZHYH2(NU(NY,NX),NY,NX))
      RFLCA=VFLW*AMAX1(0.0,ZCCH2(NU(NY,NX),NY,NX))
      RFLMG=VFLW*AMAX1(0.0,ZMAH2(NU(NY,NX),NY,NX))
      RFLNA=VFLW*AMAX1(0.0,ZNAH2(NU(NY,NX),NY,NX))
      RFLKA=VFLW*AMAX1(0.0,ZKAH2(NU(NY,NX),NY,NX))
      RFLOH=VFLW*AMAX1(0.0,ZOHH2(NU(NY,NX),NY,NX))
      RFLSO=VFLW*AMAX1(0.0,ZSO4H2(NU(NY,NX),NY,NX))
      RFLCL=VFLW*AMAX1(0.0,ZCLH2(NU(NY,NX),NY,NX))
      RFLC3=VFLW*AMAX1(0.0,ZCO3H2(NU(NY,NX),NY,NX))
      RFLHC=VFLW*AMAX1(0.0,ZHCOH2(NU(NY,NX),NY,NX))
      RFLAL1=VFLW*AMAX1(0.0,ZAL1H2(NU(NY,NX),NY,NX))
      RFLAL2=VFLW*AMAX1(0.0,ZAL2H2(NU(NY,NX),NY,NX))
      RFLAL3=VFLW*AMAX1(0.0,ZAL3H2(NU(NY,NX),NY,NX))
      RFLAL4=VFLW*AMAX1(0.0,ZAL4H2(NU(NY,NX),NY,NX))
      RFLALS=VFLW*AMAX1(0.0,ZALSH2(NU(NY,NX),NY,NX))
      RFLFE1=VFLW*AMAX1(0.0,ZFE1H2(NU(NY,NX),NY,NX))
      RFLFE2=VFLW*AMAX1(0.0,ZFE2H2(NU(NY,NX),NY,NX))
      RFLFE3=VFLW*AMAX1(0.0,ZFE3H2(NU(NY,NX),NY,NX))
      RFLFE4=VFLW*AMAX1(0.0,ZFE4H2(NU(NY,NX),NY,NX))
      RFLFES=VFLW*AMAX1(0.0,ZFESH2(NU(NY,NX),NY,NX))
      RFLCAO=VFLW*AMAX1(0.0,ZCAOH2(NU(NY,NX),NY,NX))
      RFLCAC=VFLW*AMAX1(0.0,ZCACH2(NU(NY,NX),NY,NX))
      RFLCAH=VFLW*AMAX1(0.0,ZCAHH2(NU(NY,NX),NY,NX))
      RFLCAS=VFLW*AMAX1(0.0,ZCASH2(NU(NY,NX),NY,NX))
      RFLMGO=VFLW*AMAX1(0.0,ZMGOH2(NU(NY,NX),NY,NX))
      RFLMGC=VFLW*AMAX1(0.0,ZMGCH2(NU(NY,NX),NY,NX))
      RFLMGH=VFLW*AMAX1(0.0,ZMGHH2(NU(NY,NX),NY,NX))
      RFLMGS=VFLW*AMAX1(0.0,ZMGSH2(NU(NY,NX),NY,NX))
      RFLNAC=VFLW*AMAX1(0.0,ZNACH2(NU(NY,NX),NY,NX))
      RFLNAS=VFLW*AMAX1(0.0,ZNASH2(NU(NY,NX),NY,NX))
      RFLKAS=VFLW*AMAX1(0.0,ZKASH2(NU(NY,NX),NY,NX))
      RFLH0P=VFLW*AMAX1(0.0,H0P4H2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLH3P=VFLW*AMAX1(0.0,H3P4H2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLF1P=VFLW*AMAX1(0.0,ZF1PH2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLF2P=VFLW*AMAX1(0.0,ZF2PH2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLC0P=VFLW*AMAX1(0.0,ZC0PH2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLC1P=VFLW*AMAX1(0.0,ZC1PH2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLC2P=VFLW*AMAX1(0.0,ZC2PH2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLM1P=VFLW*AMAX1(0.0,ZM1PH2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLH0B=VFLW*AMAX1(0.0,H0PBH2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLH3B=VFLW*AMAX1(0.0,H3PBH2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLF1B=VFLW*AMAX1(0.0,ZF1BH2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLF2B=VFLW*AMAX1(0.0,ZF2BH2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLC0B=VFLW*AMAX1(0.0,ZC0BH2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLC1B=VFLW*AMAX1(0.0,ZC1BH2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLC2B=VFLW*AMAX1(0.0,ZC2BH2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLM1B=VFLW*AMAX1(0.0,ZM1BH2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
C
C     MICROPORE TO MACROPORE TRANSFER
C
      ELSEIF(FINHM(M,NU(NY,NX),NY,NX).LT.0.0)THEN
      IF(VOLWM(M,NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      VFLW=AMIN1(0.0,AMAX1(-VFLWX,FINHM(M,NU(NY,NX),NY,NX)
     2/VOLWM(M,NU(NY,NX),NY,NX)))
      ELSE
      VFLW=-VFLWX 
      ENDIF
      RFLAL=VFLW*AMAX1(0.0,ZAL2(NU(NY,NX),NY,NX))
      RFLFE=VFLW*AMAX1(0.0,ZFE2(NU(NY,NX),NY,NX)) 
      RFLHY=VFLW*AMAX1(0.0,ZHY2(NU(NY,NX),NY,NX))
      RFLCA=VFLW*AMAX1(0.0,ZCA2(NU(NY,NX),NY,NX))
      RFLMG=VFLW*AMAX1(0.0,ZMG2(NU(NY,NX),NY,NX))
      RFLNA=VFLW*AMAX1(0.0,ZNA2(NU(NY,NX),NY,NX))
      RFLKA=VFLW*AMAX1(0.0,ZKA2(NU(NY,NX),NY,NX))
      RFLOH=VFLW*AMAX1(0.0,ZOH2(NU(NY,NX),NY,NX))
      RFLSO=VFLW*AMAX1(0.0,ZSO42(NU(NY,NX),NY,NX))
      RFLCL=VFLW*AMAX1(0.0,ZCL2(NU(NY,NX),NY,NX))
      RFLC3=VFLW*AMAX1(0.0,ZCO32(NU(NY,NX),NY,NX))
      RFLHC=VFLW*AMAX1(0.0,ZHCO32(NU(NY,NX),NY,NX))
      RFLAL1=VFLW*AMAX1(0.0,ZAL12(NU(NY,NX),NY,NX))
      RFLAL2=VFLW*AMAX1(0.0,ZAL22(NU(NY,NX),NY,NX))
      RFLAL3=VFLW*AMAX1(0.0,ZAL32(NU(NY,NX),NY,NX))
      RFLAL4=VFLW*AMAX1(0.0,ZAL42(NU(NY,NX),NY,NX))
      RFLALS=VFLW*AMAX1(0.0,ZALS2(NU(NY,NX),NY,NX))
      RFLFE1=VFLW*AMAX1(0.0,ZFE12(NU(NY,NX),NY,NX))
      RFLFE2=VFLW*AMAX1(0.0,ZFE22(NU(NY,NX),NY,NX))
      RFLFE3=VFLW*AMAX1(0.0,ZFE32(NU(NY,NX),NY,NX))
      RFLFE4=VFLW*AMAX1(0.0,ZFE42(NU(NY,NX),NY,NX))
      RFLFES=VFLW*AMAX1(0.0,ZFES2(NU(NY,NX),NY,NX))
      RFLCAO=VFLW*AMAX1(0.0,ZCAO2(NU(NY,NX),NY,NX))
      RFLCAC=VFLW*AMAX1(0.0,ZCAC2(NU(NY,NX),NY,NX))
      RFLCAH=VFLW*AMAX1(0.0,ZCAH2(NU(NY,NX),NY,NX))
      RFLCAS=VFLW*AMAX1(0.0,ZCAS2(NU(NY,NX),NY,NX))
      RFLMGO=VFLW*AMAX1(0.0,ZMGO2(NU(NY,NX),NY,NX))
      RFLMGC=VFLW*AMAX1(0.0,ZMGC2(NU(NY,NX),NY,NX))
      RFLMGH=VFLW*AMAX1(0.0,ZMGH2(NU(NY,NX),NY,NX))
      RFLMGS=VFLW*AMAX1(0.0,ZMGS2(NU(NY,NX),NY,NX))
      RFLNAC=VFLW*AMAX1(0.0,ZNAC2(NU(NY,NX),NY,NX))
      RFLNAS=VFLW*AMAX1(0.0,ZNAS2(NU(NY,NX),NY,NX))
      RFLKAS=VFLW*AMAX1(0.0,ZKAS2(NU(NY,NX),NY,NX))
      RFLH0P=VFLW*AMAX1(0.0,H0PO42(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLH3P=VFLW*AMAX1(0.0,H3PO42(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLF1P=VFLW*AMAX1(0.0,ZFE1P2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLF2P=VFLW*AMAX1(0.0,ZFE2P2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLC0P=VFLW*AMAX1(0.0,ZCA0P2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLC1P=VFLW*AMAX1(0.0,ZCA1P2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLC2P=VFLW*AMAX1(0.0,ZCA2P2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLM1P=VFLW*AMAX1(0.0,ZMG1P2(NU(NY,NX),NY,NX))
     2*VLPO4(NU(NY,NX),NY,NX)
      RFLH0B=VFLW*AMAX1(0.0,H0POB2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLH3B=VFLW*AMAX1(0.0,H3POB2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLF1B=VFLW*AMAX1(0.0,ZF1PB2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLF2B=VFLW*AMAX1(0.0,ZF2PB2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLC0B=VFLW*AMAX1(0.0,ZC0PB2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLC1B=VFLW*AMAX1(0.0,ZC1PB2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLC2B=VFLW*AMAX1(0.0,ZC2PB2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
      RFLM1B=VFLW*AMAX1(0.0,ZM1PB2(NU(NY,NX),NY,NX))
     2*VLPOB(NU(NY,NX),NY,NX)
C
C     NO MACROPORE TO MICROPORE TRANSFER
C
      ELSE
      RFLAL=0.0
      RFLFE=0.0
      RFLHY=0.0
      RFLCA=0.0
      RFLMG=0.0
      RFLNA=0.0
      RFLKA=0.0
      RFLOH=0.0
      RFLSO=0.0
      RFLCL=0.0
      RFLC3=0.0
      RFLHC=0.0
      RFLAL1=0.0
      RFLAL2=0.0
      RFLAL3=0.0
      RFLAL4=0.0
      RFLALS=0.0
      RFLFE1=0.0
      RFLFE2=0.0
      RFLFE3=0.0
      RFLFE4=0.0
      RFLFES=0.0
      RFLCAO=0.0
      RFLCAC=0.0
      RFLCAH=0.0
      RFLCAS=0.0
      RFLMGO=0.0
      RFLMGC=0.0
      RFLMGH=0.0
      RFLMGS=0.0
      RFLNAC=0.0
      RFLNAS=0.0
      RFLKAS=0.0
      RFLH0P=0.0
      RFLH3P=0.0
      RFLF1P=0.0
      RFLF2P=0.0
      RFLC0P=0.0
      RFLC1P=0.0
      RFLC2P=0.0
      RFLM1P=0.0
      RFLH0B=0.0
      RFLH3B=0.0
      RFLF1B=0.0
      RFLF2B=0.0
      RFLC0B=0.0
      RFLC1B=0.0
      RFLC2B=0.0
      RFLM1B=0.0
      ENDIF
C
C     DIFFUSIVE FLUXES OF SOLUTES BETWEEN MICROPORES AND
C     MACROPORES FROM AQUEOUS DIFFUSIVITIES AND CONCENTRATION DIFFERENCES
C
C     VOLWM,VOLWHM=micropore,macropore water volume
C     XFRS*VOLT=maximum macropore volume for solute transfer
C     DFV*=diffusive macropore-micropore solute transfer 
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C     *H2,*2=macropore,micropore solute content
C
      IF(VOLWHM(M,NU(NY,NX),NY,NX).GT.ZEROS2(NY,NX))THEN
      VOLWHS=AMIN1(XFRS*VOLT(NU(NY,NX),NY,NX)
     2,VOLWHM(M,NU(NY,NX),NY,NX))
      VOLWT=VOLWM(M,NU(NY,NX),NY,NX)+VOLWHS 
      DFVAL=XNPH*(AMAX1(0.0,ZALH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZAL2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVFE=XNPH*(AMAX1(0.0,ZFEH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZFE2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVHY=XNPH*(AMAX1(0.0,ZHYH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZHY2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVCA=XNPH*(AMAX1(0.0,ZCCH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZCA2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVMG=XNPH*(AMAX1(0.0,ZMAH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZMG2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVNA=XNPH*(AMAX1(0.0,ZNAH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZNA2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVKA=XNPH*(AMAX1(0.0,ZKAH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZKA2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVOH=XNPH*(AMAX1(0.0,ZOHH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZOH2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVSO=XNPH*(AMAX1(0.0,ZSO4H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZSO42(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVCL=XNPH*(AMAX1(0.0,ZCLH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZCL2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVC3=XNPH*(AMAX1(0.0,ZCO3H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZCO32(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVHC=XNPH*(AMAX1(0.0,ZHCOH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZHCO32(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVAL1=XNPH*(AMAX1(0.0,ZAL1H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZAL12(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVAL2=XNPH*(AMAX1(0.0,ZAL2H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZAL22(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVAL3=XNPH*(AMAX1(0.0,ZAL3H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZAL32(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVAL4=XNPH*(AMAX1(0.0,ZAL4H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZAL42(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVALS=XNPH*(AMAX1(0.0,ZALSH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZALS2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVFE1=XNPH*(AMAX1(0.0,ZFE1H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZFE12(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVF22=XNPH*(AMAX1(0.0,ZFE2H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZFE22(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVFE3=XNPH*(AMAX1(0.0,ZFE3H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZFE32(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVFE4=XNPH*(AMAX1(0.0,ZFE4H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZFE42(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVFES=XNPH*(AMAX1(0.0,ZFESH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZFES2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVCAO=XNPH*(AMAX1(0.0,ZCAOH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZCAO2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVCAC=XNPH*(AMAX1(0.0,ZCACH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZCAC2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVCAH=XNPH*(AMAX1(0.0,ZCAHH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZCAH2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVCAS=XNPH*(AMAX1(0.0,ZCASH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZCAS2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVMGO=XNPH*(AMAX1(0.0,ZMGOH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZMGO2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVMGC=XNPH*(AMAX1(0.0,ZMGCH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZMGC2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVMGH=XNPH*(AMAX1(0.0,ZMGHH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZMGH2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVMGS=XNPH*(AMAX1(0.0,ZMGSH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZMGS2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVNAC=XNPH*(AMAX1(0.0,ZNACH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZNAC2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVNAS=XNPH*(AMAX1(0.0,ZNASH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZNAS2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVKAS=XNPH*(AMAX1(0.0,ZKASH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZKAS2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVNAC=XNPH*(AMAX1(0.0,ZNACH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZNAC2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
      DFVH0P=XNPH*(AMAX1(0.0,H0P4H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,H0PO42(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPO4(NU(NY,NX),NY,NX)
      DFVH3P=XNPH*(AMAX1(0.0,H3P4H2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,H3PO42(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPO4(NU(NY,NX),NY,NX)
      DFVF1P=XNPH*(AMAX1(0.0,ZF1PH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZFE1P2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPO4(NU(NY,NX),NY,NX)
      DFVF2P=XNPH*(AMAX1(0.0,ZF2PH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZFE2P2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPO4(NU(NY,NX),NY,NX)
      DFVC0P=XNPH*(AMAX1(0.0,ZC0PH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZCA0P2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPO4(NU(NY,NX),NY,NX)
      DFVC1P=XNPH*(AMAX1(0.0,ZC1PH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZCA1P2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPO4(NU(NY,NX),NY,NX)
      DFVC2P=XNPH*(AMAX1(0.0,ZC2PH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZCA2P2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPO4(NU(NY,NX),NY,NX)
      DFVM1P=XNPH*(AMAX1(0.0,ZM1PH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZMG1P2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPO4(NU(NY,NX),NY,NX)
      DFVH0B=XNPH*(AMAX1(0.0,H0PBH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,H0POB2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPOB(NU(NY,NX),NY,NX)
      DFVH3B=XNPH*(AMAX1(0.0,H3PBH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,H3POB2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPOB(NU(NY,NX),NY,NX)
      DFVF1B=XNPH*(AMAX1(0.0,ZF1BH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZF1PB2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPOB(NU(NY,NX),NY,NX)
      DFVF2B=XNPH*(AMAX1(0.0,ZF2BH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZF2PB2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPOB(NU(NY,NX),NY,NX)
      DFVC0B=XNPH*(AMAX1(0.0,ZC0BH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZC0PB2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPOB(NU(NY,NX),NY,NX)
      DFVC1B=XNPH*(AMAX1(0.0,ZC1BH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZC1PB2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPOB(NU(NY,NX),NY,NX)
      DFVC2B=XNPH*(AMAX1(0.0,ZC2BH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZC2PB2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPOB(NU(NY,NX),NY,NX)
      DFVM1B=XNPH*(AMAX1(0.0,ZM1BH2(NU(NY,NX),NY,NX))
     2*VOLWM(M,NU(NY,NX),NY,NX)
     2-AMAX1(0.0,ZM1PB2(NU(NY,NX),NY,NX))*VOLWHS)/VOLWT
     2*VLPOB(NU(NY,NX),NY,NX)
      ELSE
      DFVAL=0.0
      DFVFE=0.0
      DFVHY=0.0
      DFVCA=0.0
      DFVMG=0.0
      DFVNA=0.0
      DFVKA=0.0
      DFVOH=0.0
      DFVSO=0.0
      DFVCL=0.0
      DFVC3=0.0
      DFVHC=0.0
      DFVAL1=0.0
      DFVAL2=0.0
      DFVAL3=0.0
      DFVAL4=0.0
      DFVALS=0.0
      DFVFE1=0.0
      DFVFE2=0.0
      DFVFE3=0.0
      DFVFE4=0.0
      DFVFES=0.0
      DFVCAO=0.0
      DFVCAC=0.0
      DFVCAH=0.0
      DFVCAS=0.0
      DFVMGO=0.0
      DFVMGC=0.0
      DFVMGH=0.0
      DFVMGS=0.0
      DFVNAC=0.0
      DFVNAS=0.0
      DFVKAS=0.0
      DFVH0P=0.0
      DFVH3P=0.0
      DFVF1P=0.0
      DFVF2P=0.0
      DFVC0P=0.0
      DFVC1P=0.0
      DFVC2P=0.0
      DFVM1P=0.0
      DFVH0B=0.0
      DFVH3B=0.0
      DFVF1B=0.0
      DFVF2B=0.0
      DFVC0B=0.0
      DFVC1B=0.0
      DFVC2B=0.0
      DFVM1B=0.0
      ENDIF
C
C     TOTAL CONVECTIVE +DIFFUSIVE TRANSFER BETWEEN MACROPOES AND MICROPORES
C
C     R*FXS=convective + diffusive solute flux between macropores and micropores
C     RFL*=convective flux between macropores and micropores 
C     DFV*=diffusive solute flux between macropores and micropores 
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      RALFXS(NU(NY,NX),NY,NX)=RFLAL+DFVAL
      RFEFXS(NU(NY,NX),NY,NX)=RFLFE+DFVFE
      RHYFXS(NU(NY,NX),NY,NX)=RFLHY+DFVHY
      RCAFXS(NU(NY,NX),NY,NX)=RFLCA+DFVCA
      RMGFXS(NU(NY,NX),NY,NX)=RFLMG+DFVMG
      RNAFXS(NU(NY,NX),NY,NX)=RFLNA+DFVNA
      RKAFXS(NU(NY,NX),NY,NX)=RFLKA+DFVKA
      ROHFXS(NU(NY,NX),NY,NX)=RFLOH+DFVOH
      RSOFXS(NU(NY,NX),NY,NX)=RFLSO+DFVSO
      RCLFXS(NU(NY,NX),NY,NX)=RFLCL+DFVCL
      RC3FXS(NU(NY,NX),NY,NX)=RFLC3+DFVC3
      RHCFXS(NU(NY,NX),NY,NX)=RFLHC+DFVHC
      RAL1XS(NU(NY,NX),NY,NX)=RFLAL1+DFVAL1
      RAL2XS(NU(NY,NX),NY,NX)=RFLAL2+DFVAL2
      RAL3XS(NU(NY,NX),NY,NX)=RFLAL3+DFVAL3
      RAL4XS(NU(NY,NX),NY,NX)=RFLAL4+DFVAL4
      RALSXS(NU(NY,NX),NY,NX)=RFLALS+DFVALS
      RFE1XS(NU(NY,NX),NY,NX)=RFLFE1+DFVFE1
      RFE2XS(NU(NY,NX),NY,NX)=RFLFE2+DFVFE2
      RFE3XS(NU(NY,NX),NY,NX)=RFLFE3+DFVFE3
      RFE4XS(NU(NY,NX),NY,NX)=RFLFE4+DFVFE4
      RFESXS(NU(NY,NX),NY,NX)=RFLFES+DFVFES
      RCAOXS(NU(NY,NX),NY,NX)=RFLCAO+DFVCAO
      RCACXS(NU(NY,NX),NY,NX)=RFLCAC+DFVCAC
      RCAHXS(NU(NY,NX),NY,NX)=RFLCAH+DFVCAH
      RCASXS(NU(NY,NX),NY,NX)=RFLCAS+DFVCAS
      RMGOXS(NU(NY,NX),NY,NX)=RFLMGO+DFVMGO
      RMGCXS(NU(NY,NX),NY,NX)=RFLMGC+DFVMGC
      RMGHXS(NU(NY,NX),NY,NX)=RFLMGH+DFVMGH
      RMGSXS(NU(NY,NX),NY,NX)=RFLMGS+DFVMGS
      RNACXS(NU(NY,NX),NY,NX)=RFLNAC+DFVNAC
      RNASXS(NU(NY,NX),NY,NX)=RFLNAS+DFVNAS
      RKASXS(NU(NY,NX),NY,NX)=RFLKAS+DFVKAS
      RH0PXS(NU(NY,NX),NY,NX)=RFLH0P+DFVH0P
      RH3PXS(NU(NY,NX),NY,NX)=RFLH3P+DFVH3P
      RF1PXS(NU(NY,NX),NY,NX)=RFLF1P+DFVF1P
      RF2PXS(NU(NY,NX),NY,NX)=RFLF2P+DFVF2P
      RC0PXS(NU(NY,NX),NY,NX)=RFLC0P+DFVC0P
      RC1PXS(NU(NY,NX),NY,NX)=RFLC1P+DFVC1P
      RC2PXS(NU(NY,NX),NY,NX)=RFLC2P+DFVC2P
      RM1PXS(NU(NY,NX),NY,NX)=RFLM1P+DFVM1P
      RH0BXB(NU(NY,NX),NY,NX)=RFLH0B+DFVH0B
      RH3BXB(NU(NY,NX),NY,NX)=RFLH3B+DFVH3B
      RF1BXB(NU(NY,NX),NY,NX)=RFLF1B+DFVF1B
      RF2BXB(NU(NY,NX),NY,NX)=RFLF2B+DFVF2B
      RC0BXB(NU(NY,NX),NY,NX)=RFLC0B+DFVC0B
      RC1BXB(NU(NY,NX),NY,NX)=RFLC1B+DFVC1B
      RC2BXB(NU(NY,NX),NY,NX)=RFLC2B+DFVC2B
      RM1BXB(NU(NY,NX),NY,NX)=RFLM1B+DFVM1B
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*FXS=hourly convective + diffusive solute flux between macropores and micropores
C     R*FXS=total convective + diffusive solute flux between macropores and micropores
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      XALFXS(NU(NY,NX),NY,NX)=XALFXS(NU(NY,NX),NY,NX)
     2+RALFXS(NU(NY,NX),NY,NX)
      XFEFXS(NU(NY,NX),NY,NX)=XFEFXS(NU(NY,NX),NY,NX)
     2+RFEFXS(NU(NY,NX),NY,NX)
      XHYFXS(NU(NY,NX),NY,NX)=XHYFXS(NU(NY,NX),NY,NX)
     2+RHYFXS(NU(NY,NX),NY,NX)
      XCAFXS(NU(NY,NX),NY,NX)=XCAFXS(NU(NY,NX),NY,NX)
     2+RCAFXS(NU(NY,NX),NY,NX)
      XMGFXS(NU(NY,NX),NY,NX)=XMGFXS(NU(NY,NX),NY,NX)
     2+RMGFXS(NU(NY,NX),NY,NX)
      XNAFXS(NU(NY,NX),NY,NX)=XNAFXS(NU(NY,NX),NY,NX)
     2+RNAFXS(NU(NY,NX),NY,NX)
      XKAFXS(NU(NY,NX),NY,NX)=XKAFXS(NU(NY,NX),NY,NX)
     2+RKAFXS(NU(NY,NX),NY,NX)
      XOHFXS(NU(NY,NX),NY,NX)=XOHFXS(NU(NY,NX),NY,NX)
     2+ROHFXS(NU(NY,NX),NY,NX)
      XSOFXS(NU(NY,NX),NY,NX)=XSOFXS(NU(NY,NX),NY,NX)
     2+RSOFXS(NU(NY,NX),NY,NX)
      XCLFXS(NU(NY,NX),NY,NX)=XCLFXS(NU(NY,NX),NY,NX)
     2+RCLFXS(NU(NY,NX),NY,NX)
      XC3FXS(NU(NY,NX),NY,NX)=XC3FXS(NU(NY,NX),NY,NX)
     2+RC3FXS(NU(NY,NX),NY,NX)
      XHCFXS(NU(NY,NX),NY,NX)=XHCFXS(NU(NY,NX),NY,NX)
     2+RHCFXS(NU(NY,NX),NY,NX)
      XAL1XS(NU(NY,NX),NY,NX)=XAL1XS(NU(NY,NX),NY,NX)
     2+RAL1XS(NU(NY,NX),NY,NX)
      XAL2XS(NU(NY,NX),NY,NX)=XAL2XS(NU(NY,NX),NY,NX)
     2+RAL2XS(NU(NY,NX),NY,NX)
      XAL3XS(NU(NY,NX),NY,NX)=XAL3XS(NU(NY,NX),NY,NX)
     2+RAL3XS(NU(NY,NX),NY,NX)
      XAL4XS(NU(NY,NX),NY,NX)=XAL4XS(NU(NY,NX),NY,NX)
     2+RAL4XS(NU(NY,NX),NY,NX)
      XALSXS(NU(NY,NX),NY,NX)=XALSXS(NU(NY,NX),NY,NX)
     2+RALSXS(NU(NY,NX),NY,NX)
      XFE1XS(NU(NY,NX),NY,NX)=XFE1XS(NU(NY,NX),NY,NX)
     2+RFE1XS(NU(NY,NX),NY,NX)
      XFE2XS(NU(NY,NX),NY,NX)=XFE2XS(NU(NY,NX),NY,NX)
     2+RFE2XS(NU(NY,NX),NY,NX)
      XFE3XS(NU(NY,NX),NY,NX)=XFE3XS(NU(NY,NX),NY,NX)
     2+RFE3XS(NU(NY,NX),NY,NX)
      XFE4XS(NU(NY,NX),NY,NX)=XFE4XS(NU(NY,NX),NY,NX)
     2+RFE4XS(NU(NY,NX),NY,NX)
      XFESXS(NU(NY,NX),NY,NX)=XFESXS(NU(NY,NX),NY,NX)
     2+RFESXS(NU(NY,NX),NY,NX)
      XCAOXS(NU(NY,NX),NY,NX)=XCAOXS(NU(NY,NX),NY,NX)
     2+RCAOXS(NU(NY,NX),NY,NX)
      XCACXS(NU(NY,NX),NY,NX)=XCACXS(NU(NY,NX),NY,NX)
     2+RCACXS(NU(NY,NX),NY,NX)
      XCAHXS(NU(NY,NX),NY,NX)=XCAHXS(NU(NY,NX),NY,NX)
     2+RCAHXS(NU(NY,NX),NY,NX)
      XCASXS(NU(NY,NX),NY,NX)=XCASXS(NU(NY,NX),NY,NX)
     2+RCASXS(NU(NY,NX),NY,NX)
      XMGOXS(NU(NY,NX),NY,NX)=XMGOXS(NU(NY,NX),NY,NX)
     2+RMGOXS(NU(NY,NX),NY,NX)
      XMGCXS(NU(NY,NX),NY,NX)=XMGCXS(NU(NY,NX),NY,NX)
     2+RMGCXS(NU(NY,NX),NY,NX)
      XMGHXS(NU(NY,NX),NY,NX)=XMGHXS(NU(NY,NX),NY,NX)
     2+RMGHXS(NU(NY,NX),NY,NX)
      XMGSXS(NU(NY,NX),NY,NX)=XMGSXS(NU(NY,NX),NY,NX)
     2+RMGSXS(NU(NY,NX),NY,NX)
      XNACXS(NU(NY,NX),NY,NX)=XNACXS(NU(NY,NX),NY,NX)
     2+RNACXS(NU(NY,NX),NY,NX)
      XNASXS(NU(NY,NX),NY,NX)=XNASXS(NU(NY,NX),NY,NX)
     2+RNASXS(NU(NY,NX),NY,NX)
      XKASXS(NU(NY,NX),NY,NX)=XKASXS(NU(NY,NX),NY,NX)
     2+RKASXS(NU(NY,NX),NY,NX)
      XH0PXS(NU(NY,NX),NY,NX)=XH0PXS(NU(NY,NX),NY,NX)
     2+RH0PXS(NU(NY,NX),NY,NX)
      XH3PXS(NU(NY,NX),NY,NX)=XH3PXS(NU(NY,NX),NY,NX)
     2+RH3PXS(NU(NY,NX),NY,NX)
      XF1PXS(NU(NY,NX),NY,NX)=XF1PXS(NU(NY,NX),NY,NX)
     2+RF1PXS(NU(NY,NX),NY,NX)
      XF2PXS(NU(NY,NX),NY,NX)=XF2PXS(NU(NY,NX),NY,NX)
     2+RF2PXS(NU(NY,NX),NY,NX)
      XC0PXS(NU(NY,NX),NY,NX)=XC0PXS(NU(NY,NX),NY,NX)
     2+RC0PXS(NU(NY,NX),NY,NX)
      XC1PXS(NU(NY,NX),NY,NX)=XC1PXS(NU(NY,NX),NY,NX)
     2+RC1PXS(NU(NY,NX),NY,NX)
      XC2PXS(NU(NY,NX),NY,NX)=XC2PXS(NU(NY,NX),NY,NX)
     2+RC2PXS(NU(NY,NX),NY,NX)
      XM1PXS(NU(NY,NX),NY,NX)=XM1PXS(NU(NY,NX),NY,NX)
     2+RM1PXS(NU(NY,NX),NY,NX)
      XH0BXB(NU(NY,NX),NY,NX)=XH0BXB(NU(NY,NX),NY,NX)
     2+RH0BXB(NU(NY,NX),NY,NX)
      XH3BXB(NU(NY,NX),NY,NX)=XH3BXB(NU(NY,NX),NY,NX)
     2+RH3BXB(NU(NY,NX),NY,NX)
      XF1BXB(NU(NY,NX),NY,NX)=XF1BXB(NU(NY,NX),NY,NX)
     2+RF1BXB(NU(NY,NX),NY,NX)
      XF2BXB(NU(NY,NX),NY,NX)=XF2BXB(NU(NY,NX),NY,NX)
     2+RF2BXB(NU(NY,NX),NY,NX)
      XC0BXB(NU(NY,NX),NY,NX)=XC0BXB(NU(NY,NX),NY,NX)
     2+RC0BXB(NU(NY,NX),NY,NX)
      XC1BXB(NU(NY,NX),NY,NX)=XC1BXB(NU(NY,NX),NY,NX)
     2+RC1BXB(NU(NY,NX),NY,NX)
      XC2BXB(NU(NY,NX),NY,NX)=XC2BXB(NU(NY,NX),NY,NX)
     2+RC2BXB(NU(NY,NX),NY,NX)
      XM1BXB(NU(NY,NX),NY,NX)=XM1BXB(NU(NY,NX),NY,NX)
     2+RM1BXB(NU(NY,NX),NY,NX)
C
C     SOLUTE TRANSPORT FROM WATER OVERLAND FLOW
C     IN 'WATSUB' AND FROM SOLUTE CONCENTRATIONS
C     IN SOIL SURFACE LAYER
C
C     QRM=runoff from watsub.f
C     RQR*0=solute in runoff
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     VOLWM=litter water volume from watsub.f
C     *S2=litter solute content
C     N2,N1=NY,NX of source grid cell
C     N5,N4=NY,NX of destination grid cell
C     X*QRS=accumulated hourly solute in runoff
C
C
      N1=NX
      N2=NY
      IF(QRM(M,N2,N1).GT.ZEROS(N2,N1))THEN
      IF(VOLWM(M,0,N2,N1).GT.ZEROS2(N2,N1))THEN
      VFLW=AMIN1(VFLWX,QRM(M,N2,N1)/VOLWM(M,0,N2,N1))
      ELSE
      VFLW=VFLWX 
      ENDIF
      RQRAL0(N2,N1)=VFLW*AMAX1(0.0,ZAL2(0,N2,N1)) 
      RQRFE0(N2,N1)=VFLW*AMAX1(0.0,ZFE2(0,N2,N1))
      RQRHY0(N2,N1)=VFLW*AMAX1(0.0,ZHY2(0,N2,N1))
      RQRCA0(N2,N1)=VFLW*AMAX1(0.0,ZCA2(0,N2,N1))
      RQRMG0(N2,N1)=VFLW*AMAX1(0.0,ZMG2(0,N2,N1))
      RQRNA0(N2,N1)=VFLW*AMAX1(0.0,ZNA2(0,N2,N1))
      RQRKA0(N2,N1)=VFLW*AMAX1(0.0,ZKA2(0,N2,N1))
      RQROH0(N2,N1)=VFLW*AMAX1(0.0,ZOH2(0,N2,N1))
      RQRSO0(N2,N1)=VFLW*AMAX1(0.0,ZSO42(0,N2,N1)) 
      RQRCL0(N2,N1)=VFLW*AMAX1(0.0,ZCL2(0,N2,N1))
      RQRC30(N2,N1)=VFLW*AMAX1(0.0,ZCO32(0,N2,N1))
      RQRHC0(N2,N1)=VFLW*AMAX1(0.0,ZHCO32(0,N2,N1))
      RQRAL10(N2,N1)=VFLW*AMAX1(0.0,ZAL12(0,N2,N1))
      RQRAL20(N2,N1)=VFLW*AMAX1(0.0,ZAL22(0,N2,N1))
      RQRAL30(N2,N1)=VFLW*AMAX1(0.0,ZAL32(0,N2,N1))
      RQRAL40(N2,N1)=VFLW*AMAX1(0.0,ZAL42(0,N2,N1))
      RQRALS0(N2,N1)=VFLW*AMAX1(0.0,ZALS2(0,N2,N1))
      RQRFE10(N2,N1)=VFLW*AMAX1(0.0,ZFE12(0,N2,N1))
      RQRFE20(N2,N1)=VFLW*AMAX1(0.0,ZFE22(0,N2,N1))
      RQRFE30(N2,N1)=VFLW*AMAX1(0.0,ZFE32(0,N2,N1))
      RQRFE40(N2,N1)=VFLW*AMAX1(0.0,ZFE42(0,N2,N1))
      RQRFES0(N2,N1)=VFLW*AMAX1(0.0,ZFES2(0,N2,N1))
      RQRCAO0(N2,N1)=VFLW*AMAX1(0.0,ZCAO2(0,N2,N1))
      RQRCAC0(N2,N1)=VFLW*AMAX1(0.0,ZCAC2(0,N2,N1))
      RQRCAH0(N2,N1)=VFLW*AMAX1(0.0,ZCAH2(0,N2,N1)) 
      RQRCAS0(N2,N1)=VFLW*AMAX1(0.0,ZCAS2(0,N2,N1))
      RQRMGO0(N2,N1)=VFLW*AMAX1(0.0,ZMGO2(0,N2,N1))
      RQRMGC0(N2,N1)=VFLW*AMAX1(0.0,ZMGC2(0,N2,N1))
      RQRMGH0(N2,N1)=VFLW*AMAX1(0.0,ZMGH2(0,N2,N1))
      RQRMGS0(N2,N1)=VFLW*AMAX1(0.0,ZMGS2(0,N2,N1))
      RQRNAC0(N2,N1)=VFLW*AMAX1(0.0,ZNAC2(0,N2,N1))
      RQRNAS0(N2,N1)=VFLW*AMAX1(0.0,ZNAS2(0,N2,N1))
      RQRKAS0(N2,N1)=VFLW*AMAX1(0.0,ZKAS2(0,N2,N1))
      RQRH0P0(N2,N1)=VFLW*AMAX1(0.0,H0PO42(0,N2,N1))
      RQRH3P0(N2,N1)=VFLW*AMAX1(0.0,H3PO42(0,N2,N1))
      RQRF1P0(N2,N1)=VFLW*AMAX1(0.0,ZFE1P2(0,N2,N1))
      RQRF2P0(N2,N1)=VFLW*AMAX1(0.0,ZFE2P2(0,N2,N1))
      RQRC0P0(N2,N1)=VFLW*AMAX1(0.0,ZCA0P2(0,N2,N1))
      RQRC1P0(N2,N1)=VFLW*AMAX1(0.0,ZCA1P2(0,N2,N1))
      RQRC2P0(N2,N1)=VFLW*AMAX1(0.0,ZCA2P2(0,N2,N1))
      RQRM1P0(N2,N1)=VFLW*AMAX1(0.0,ZMG1P2(0,N2,N1))
      ELSE
      RQRAL0(N2,N1)=0.0
      RQRFE0(N2,N1)=0.0
      RQRHY0(N2,N1)=0.0
      RQRCA0(N2,N1)=0.0
      RQRMG0(N2,N1)=0.0
      RQRNA0(N2,N1)=0.0
      RQRKA0(N2,N1)=0.0
      RQROH0(N2,N1)=0.0
      RQRSO0(N2,N1)=0.0 
      RQRCL0(N2,N1)=0.0
      RQRC30(N2,N1)=0.0
      RQRHC0(N2,N1)=0.0
      RQRAL10(N2,N1)=0.0
      RQRAL20(N2,N1)=0.0
      RQRAL30(N2,N1)=0.0
      RQRAL40(N2,N1)=0.0
      RQRALS0(N2,N1)=0.0
      RQRFE10(N2,N1)=0.0
      RQRFE20(N2,N1)=0.0
      RQRFE30(N2,N1)=0.0
      RQRFE40(N2,N1)=0.0
      RQRFES0(N2,N1)=0.0
      RQRCAO0(N2,N1)=0.0
      RQRCAC0(N2,N1)=0.0
      RQRCAH0(N2,N1)=0.0
      RQRCAS0(N2,N1)=0.0
      RQRMGO0(N2,N1)=0.0
      RQRMGC0(N2,N1)=0.0
      RQRMGH0(N2,N1)=0.0
      RQRMGS0(N2,N1)=0.0
      RQRNAC0(N2,N1)=0.0
      RQRNAS0(N2,N1)=0.0
      RQRKAS0(N2,N1)=0.0
      RQRH0P0(N2,N1)=0.0
      RQRH3P0(N2,N1)=0.0
      RQRF1P0(N2,N1)=0.0
      RQRF2P0(N2,N1)=0.0
      RQRC0P0(N2,N1)=0.0
      RQRC1P0(N2,N1)=0.0
      RQRC2P0(N2,N1)=0.0
      RQRM1P0(N2,N1)=0.0
      ENDIF
C
C     LOCATE INTERNAL BOUNDARIES BETWEEN ADJACENT GRID CELLS
C
      DO 4310 N=1,2
      DO 4305 NN=1,2
      IF(N.EQ.1)THEN
      IF(NX.EQ.NHE.AND.NN.EQ.1
     2.OR.NX.EQ.NHW.AND.NN.EQ.2)THEN
      GO TO 4305
      ELSE
      N4=NX+1
      N5=NY
      N4B=NX-1
      N5B=NY
      ENDIF
      ELSEIF(N.EQ.2)THEN
      IF(NY.EQ.NVS.AND.NN.EQ.1
     2.OR.NY.EQ.NVN.AND.NN.EQ.2)THEN
      GO TO 4305
      ELSE
      N4=NX
      N5=NY+1
      N4B=NX
      N5B=NY-1
      ENDIF
      ENDIF
C
C     QRM=runoff from watsub.f
C     RQR*=solute in runoff
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
C     IF OVERLAND FLOW IS FROM CURRENT TO ADJACENT GRID CELL
C
      IF(QRM(M,N2,N1).GT.ZEROS(N2,N1))THEN
      IF(NN.EQ.1)THEN
      FQRM=QRMN(M,N,2,N5,N4)/QRM(M,N2,N1)
      RQRAL(N,2,N5,N4)=RQRAL0(N2,N1)*FQRM
      RQRFE(N,2,N5,N4)=RQRFE0(N2,N1)*FQRM
      RQRHY(N,2,N5,N4)=RQRHY0(N2,N1)*FQRM
      RQRCA(N,2,N5,N4)=RQRCA0(N2,N1)*FQRM
      RQRMG(N,2,N5,N4)=RQRMG0(N2,N1)*FQRM
      RQRNA(N,2,N5,N4)=RQRNA0(N2,N1)*FQRM
      RQRKA(N,2,N5,N4)=RQRKA0(N2,N1)*FQRM
      RQROH(N,2,N5,N4)=RQROH0(N2,N1)*FQRM
      RQRSO(N,2,N5,N4)=RQRSO0(N2,N1)*FQRM
      RQRCL(N,2,N5,N4)=RQRCL0(N2,N1)*FQRM
      RQRC3(N,2,N5,N4)=RQRC30(N2,N1)*FQRM
      RQRHC(N,2,N5,N4)=RQRHC0(N2,N1)*FQRM
      RQRAL1(N,2,N5,N4)=RQRAL10(N2,N1)*FQRM
      RQRAL2(N,2,N5,N4)=RQRAL20(N2,N1)*FQRM
      RQRAL3(N,2,N5,N4)=RQRAL30(N2,N1)*FQRM
      RQRAL4(N,2,N5,N4)=RQRAL40(N2,N1)*FQRM
      RQRALS(N,2,N5,N4)=RQRALS0(N2,N1)*FQRM
      RQRFE1(N,2,N5,N4)=RQRFE10(N2,N1)*FQRM
      RQRFE2(N,2,N5,N4)=RQRFE20(N2,N1)*FQRM
      RQRFE3(N,2,N5,N4)=RQRFE30(N2,N1)*FQRM
      RQRFE4(N,2,N5,N4)=RQRFE40(N2,N1)*FQRM
      RQRFES(N,2,N5,N4)=RQRFES0(N2,N1)*FQRM
      RQRCAO(N,2,N5,N4)=RQRCAO0(N2,N1)*FQRM
      RQRCAC(N,2,N5,N4)=RQRCAC0(N2,N1)*FQRM
      RQRCAH(N,2,N5,N4)=RQRCAH0(N2,N1)*FQRM
      RQRCAS(N,2,N5,N4)=RQRCAS0(N2,N1)*FQRM
      RQRMGO(N,2,N5,N4)=RQRMGO0(N2,N1)*FQRM
      RQRMGC(N,2,N5,N4)=RQRMGC0(N2,N1)*FQRM
      RQRMGH(N,2,N5,N4)=RQRMGH0(N2,N1)*FQRM
      RQRMGS(N,2,N5,N4)=RQRMGS0(N2,N1)*FQRM
      RQRNAC(N,2,N5,N4)=RQRNAC0(N2,N1)*FQRM
      RQRNAS(N,2,N5,N4)=RQRNAS0(N2,N1)*FQRM
      RQRKAS(N,2,N5,N4)=RQRKAS0(N2,N1)*FQRM
      RQRH0P(N,2,N5,N4)=RQRH0P0(N2,N1)*FQRM
      RQRH3P(N,2,N5,N4)=RQRH3P0(N2,N1)*FQRM
      RQRF1P(N,2,N5,N4)=RQRF1P0(N2,N1)*FQRM
      RQRF2P(N,2,N5,N4)=RQRF2P0(N2,N1)*FQRM
      RQRC0P(N,2,N5,N4)=RQRC0P0(N2,N1)*FQRM
      RQRC1P(N,2,N5,N4)=RQRC1P0(N2,N1)*FQRM
      RQRC2P(N,2,N5,N4)=RQRC2P0(N2,N1)*FQRM
      RQRM1P(N,2,N5,N4)=RQRM1P0(N2,N1)*FQRM
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     XQR*=hourly solute in runoff
C     RQR*=solute in runoff
C
      XQRAL(N,2,N5,N4)=XQRAL(N,2,N5,N4)+RQRAL(N,2,N5,N4)
      XQRFE(N,2,N5,N4)=XQRFE(N,2,N5,N4)+RQRFE(N,2,N5,N4)
      XQRHY(N,2,N5,N4)=XQRHY(N,2,N5,N4)+RQRHY(N,2,N5,N4)
      XQRCA(N,2,N5,N4)=XQRCA(N,2,N5,N4)+RQRCA(N,2,N5,N4)
      XQRMG(N,2,N5,N4)=XQRMG(N,2,N5,N4)+RQRMG(N,2,N5,N4)
      XQRNA(N,2,N5,N4)=XQRNA(N,2,N5,N4)+RQRNA(N,2,N5,N4)
      XQRKA(N,2,N5,N4)=XQRKA(N,2,N5,N4)+RQRKA(N,2,N5,N4)
      XQROH(N,2,N5,N4)=XQROH(N,2,N5,N4)+RQROH(N,2,N5,N4)
      XQRSO(N,2,N5,N4)=XQRSO(N,2,N5,N4)+RQRSO(N,2,N5,N4)
      XQRCL(N,2,N5,N4)=XQRCL(N,2,N5,N4)+RQRCL(N,2,N5,N4)
      XQRC3(N,2,N5,N4)=XQRC3(N,2,N5,N4)+RQRC3(N,2,N5,N4)
      XQRHC(N,2,N5,N4)=XQRHC(N,2,N5,N4)+RQRHC(N,2,N5,N4)
      XQRAL1(N,2,N5,N4)=XQRAL1(N,2,N5,N4)+RQRAL1(N,2,N5,N4)
      XQRAL2(N,2,N5,N4)=XQRAL2(N,2,N5,N4)+RQRAL2(N,2,N5,N4)
      XQRAL3(N,2,N5,N4)=XQRAL3(N,2,N5,N4)+RQRAL3(N,2,N5,N4)
      XQRAL4(N,2,N5,N4)=XQRAL4(N,2,N5,N4)+RQRAL4(N,2,N5,N4)
      XQRALS(N,2,N5,N4)=XQRALS(N,2,N5,N4)+RQRALS(N,2,N5,N4)
      XQRFE1(N,2,N5,N4)=XQRFE1(N,2,N5,N4)+RQRFE1(N,2,N5,N4)
      XQRFE2(N,2,N5,N4)=XQRFE2(N,2,N5,N4)+RQRFE2(N,2,N5,N4)
      XQRFE3(N,2,N5,N4)=XQRFE3(N,2,N5,N4)+RQRFE3(N,2,N5,N4)
      XQRFE4(N,2,N5,N4)=XQRFE4(N,2,N5,N4)+RQRFE4(N,2,N5,N4)
      XQRFES(N,2,N5,N4)=XQRFES(N,2,N5,N4)+RQRFES(N,2,N5,N4)
      XQRCAO(N,2,N5,N4)=XQRCAO(N,2,N5,N4)+RQRCAO(N,2,N5,N4)
      XQRCAC(N,2,N5,N4)=XQRCAC(N,2,N5,N4)+RQRCAC(N,2,N5,N4)
      XQRCAH(N,2,N5,N4)=XQRCAH(N,2,N5,N4)+RQRCAH(N,2,N5,N4)
      XQRCAS(N,2,N5,N4)=XQRCAS(N,2,N5,N4)+RQRCAS(N,2,N5,N4)
      XQRMGO(N,2,N5,N4)=XQRMGO(N,2,N5,N4)+RQRMGO(N,2,N5,N4)
      XQRMGC(N,2,N5,N4)=XQRMGC(N,2,N5,N4)+RQRMGC(N,2,N5,N4)
      XQRMGH(N,2,N5,N4)=XQRMGH(N,2,N5,N4)+RQRMGH(N,2,N5,N4)
      XQRMGS(N,2,N5,N4)=XQRMGS(N,2,N5,N4)+RQRMGS(N,2,N5,N4)
      XQRNAC(N,2,N5,N4)=XQRNAC(N,2,N5,N4)+RQRNAC(N,2,N5,N4)
      XQRNAS(N,2,N5,N4)=XQRNAS(N,2,N5,N4)+RQRNAS(N,2,N5,N4)
      XQRKAS(N,2,N5,N4)=XQRKAS(N,2,N5,N4)+RQRKAS(N,2,N5,N4)
      XQRH0P(N,2,N5,N4)=XQRH0P(N,2,N5,N4)+RQRH0P(N,2,N5,N4)
      XQRH3P(N,2,N5,N4)=XQRH3P(N,2,N5,N4)+RQRH3P(N,2,N5,N4)
      XQRF1P(N,2,N5,N4)=XQRF1P(N,2,N5,N4)+RQRF1P(N,2,N5,N4)
      XQRF2P(N,2,N5,N4)=XQRF2P(N,2,N5,N4)+RQRF2P(N,2,N5,N4)
      XQRC0P(N,2,N5,N4)=XQRC0P(N,2,N5,N4)+RQRC0P(N,2,N5,N4)
      XQRC1P(N,2,N5,N4)=XQRC1P(N,2,N5,N4)+RQRC1P(N,2,N5,N4)
      XQRC2P(N,2,N5,N4)=XQRC2P(N,2,N5,N4)+RQRC2P(N,2,N5,N4)
      XQRM1P(N,2,N5,N4)=XQRM1P(N,2,N5,N4)+RQRM1P(N,2,N5,N4)
      ELSE
      RQRAL(N,2,N5,N4)=0.0
      RQRFE(N,2,N5,N4)=0.0
      RQRHY(N,2,N5,N4)=0.0
      RQRCA(N,2,N5,N4)=0.0
      RQRMG(N,2,N5,N4)=0.0
      RQRNA(N,2,N5,N4)=0.0
      RQRKA(N,2,N5,N4)=0.0
      RQROH(N,2,N5,N4)=0.0
      RQRSO(N,2,N5,N4)=0.0
      RQRCL(N,2,N5,N4)=0.0
      RQRC3(N,2,N5,N4)=0.0
      RQRHC(N,2,N5,N4)=0.0
      RQRAL1(N,2,N5,N4)=0.0
      RQRAL2(N,2,N5,N4)=0.0
      RQRAL3(N,2,N5,N4)=0.0
      RQRAL4(N,2,N5,N4)=0.0
      RQRALS(N,2,N5,N4)=0.0
      RQRFE1(N,2,N5,N4)=0.0
      RQRFE2(N,2,N5,N4)=0.0
      RQRFE3(N,2,N5,N4)=0.0
      RQRFE4(N,2,N5,N4)=0.0
      RQRFES(N,2,N5,N4)=0.0
      RQRCAO(N,2,N5,N4)=0.0
      RQRCAC(N,2,N5,N4)=0.0
      RQRCAH(N,2,N5,N4)=0.0
      RQRCAS(N,2,N5,N4)=0.0
      RQRMGO(N,2,N5,N4)=0.0
      RQRMGC(N,2,N5,N4)=0.0
      RQRMGH(N,2,N5,N4)=0.0
      RQRMGS(N,2,N5,N4)=0.0
      RQRNAC(N,2,N5,N4)=0.0
      RQRNAS(N,2,N5,N4)=0.0
      RQRKAS(N,2,N5,N4)=0.0
      RQRH0P(N,2,N5,N4)=0.0
      RQRH3P(N,2,N5,N4)=0.0
      RQRF1P(N,2,N5,N4)=0.0
      RQRF2P(N,2,N5,N4)=0.0
      RQRC0P(N,2,N5,N4)=0.0
      RQRC1P(N,2,N5,N4)=0.0
      RQRC2P(N,2,N5,N4)=0.0
      RQRM1P(N,2,N5,N4)=0.0
      ENDIF
C
C     IF OVERLAND FLOW IS FROM CURRENT TO ADJACENT GRID CELL
C
      IF(NN.EQ.2)THEN
      IF(N4B.GT.0.AND.N5B.GT.0)THEN
      FQRM=QRMN(M,N,1,N5B,N4B)/QRM(M,N2,N1)
      RQRAL(N,1,N5B,N4B)=RQRAL0(N2,N1)*FQRM
      RQRFE(N,1,N5B,N4B)=RQRFE0(N2,N1)*FQRM
      RQRHY(N,1,N5B,N4B)=RQRHY0(N2,N1)*FQRM
      RQRCA(N,1,N5B,N4B)=RQRCA0(N2,N1)*FQRM
      RQRMG(N,1,N5B,N4B)=RQRMG0(N2,N1)*FQRM
      RQRNA(N,1,N5B,N4B)=RQRNA0(N2,N1)*FQRM
      RQRKA(N,1,N5B,N4B)=RQRKA0(N2,N1)*FQRM
      RQROH(N,1,N5B,N4B)=RQROH0(N2,N1)*FQRM
      RQRSO(N,1,N5B,N4B)=RQRSO0(N2,N1)*FQRM
      RQRCL(N,1,N5B,N4B)=RQRCL0(N2,N1)*FQRM
      RQRC3(N,1,N5B,N4B)=RQRC30(N2,N1)*FQRM
      RQRHC(N,1,N5B,N4B)=RQRHC0(N2,N1)*FQRM
      RQRAL1(N,1,N5B,N4B)=RQRAL10(N2,N1)*FQRM
      RQRAL2(N,1,N5B,N4B)=RQRAL20(N2,N1)*FQRM
      RQRAL3(N,1,N5B,N4B)=RQRAL30(N2,N1)*FQRM
      RQRAL4(N,1,N5B,N4B)=RQRAL40(N2,N1)*FQRM
      RQRALS(N,1,N5B,N4B)=RQRALS0(N2,N1)*FQRM
      RQRFE1(N,1,N5B,N4B)=RQRFE10(N2,N1)*FQRM
      RQRFE2(N,1,N5B,N4B)=RQRFE20(N2,N1)*FQRM
      RQRFE3(N,1,N5B,N4B)=RQRFE30(N2,N1)*FQRM
      RQRFE4(N,1,N5B,N4B)=RQRFE40(N2,N1)*FQRM
      RQRFES(N,1,N5B,N4B)=RQRFES0(N2,N1)*FQRM
      RQRCAO(N,1,N5B,N4B)=RQRCAO0(N2,N1)*FQRM
      RQRCAC(N,1,N5B,N4B)=RQRCAC0(N2,N1)*FQRM
      RQRCAH(N,1,N5B,N4B)=RQRCAH0(N2,N1)*FQRM
      RQRCAS(N,1,N5B,N4B)=RQRCAS0(N2,N1)*FQRM
      RQRMGO(N,1,N5B,N4B)=RQRMGO0(N2,N1)*FQRM
      RQRMGC(N,1,N5B,N4B)=RQRMGC0(N2,N1)*FQRM
      RQRMGH(N,1,N5B,N4B)=RQRMGH0(N2,N1)*FQRM
      RQRMGS(N,1,N5B,N4B)=RQRMGS0(N2,N1)*FQRM
      RQRNAC(N,1,N5B,N4B)=RQRNAC0(N2,N1)*FQRM
      RQRNAS(N,1,N5B,N4B)=RQRNAS0(N2,N1)*FQRM
      RQRKAS(N,1,N5B,N4B)=RQRKAS0(N2,N1)*FQRM
      RQRH0P(N,1,N5B,N4B)=RQRH0P0(N2,N1)*FQRM
      RQRH3P(N,1,N5B,N4B)=RQRH3P0(N2,N1)*FQRM
      RQRF1P(N,1,N5B,N4B)=RQRF1P0(N2,N1)*FQRM
      RQRF2P(N,1,N5B,N4B)=RQRF2P0(N2,N1)*FQRM
      RQRC0P(N,1,N5B,N4B)=RQRC0P0(N2,N1)*FQRM
      RQRC1P(N,1,N5B,N4B)=RQRC1P0(N2,N1)*FQRM
      RQRC2P(N,1,N5B,N4B)=RQRC2P0(N2,N1)*FQRM
      RQRM1P(N,1,N5B,N4B)=RQRM1P0(N2,N1)*FQRM 
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     XQR*=hourly solute in runoff
C     RQR*=solute in runoff
C
      XQRAL(N,1,N5B,N4B)=XQRAL(N,1,N5B,N4B)+RQRAL(N,1,N5B,N4B)
      XQRFE(N,1,N5B,N4B)=XQRFE(N,1,N5B,N4B)+RQRFE(N,1,N5B,N4B)
      XQRHY(N,1,N5B,N4B)=XQRHY(N,1,N5B,N4B)+RQRHY(N,1,N5B,N4B)
      XQRCA(N,1,N5B,N4B)=XQRCA(N,1,N5B,N4B)+RQRCA(N,1,N5B,N4B)
      XQRMG(N,1,N5B,N4B)=XQRMG(N,1,N5B,N4B)+RQRMG(N,1,N5B,N4B)
      XQRNA(N,1,N5B,N4B)=XQRNA(N,1,N5B,N4B)+RQRNA(N,1,N5B,N4B)
      XQRKA(N,1,N5B,N4B)=XQRKA(N,1,N5B,N4B)+RQRKA(N,1,N5B,N4B)
      XQROH(N,1,N5B,N4B)=XQROH(N,1,N5B,N4B)+RQROH(N,1,N5B,N4B)
      XQRSO(N,1,N5B,N4B)=XQRSO(N,1,N5B,N4B)+RQRSO(N,1,N5B,N4B)
      XQRCL(N,1,N5B,N4B)=XQRCL(N,1,N5B,N4B)+RQRCL(N,1,N5B,N4B)
      XQRC3(N,1,N5B,N4B)=XQRC3(N,1,N5B,N4B)+RQRC3(N,1,N5B,N4B)
      XQRHC(N,1,N5B,N4B)=XQRHC(N,1,N5B,N4B)+RQRHC(N,1,N5B,N4B)
      XQRAL1(N,1,N5B,N4B)=XQRAL1(N,1,N5B,N4B)+RQRAL1(N,1,N5B,N4B)
      XQRAL2(N,1,N5B,N4B)=XQRAL2(N,1,N5B,N4B)+RQRAL2(N,1,N5B,N4B)
      XQRAL3(N,1,N5B,N4B)=XQRAL3(N,1,N5B,N4B)+RQRAL3(N,1,N5B,N4B)
      XQRAL4(N,1,N5B,N4B)=XQRAL4(N,1,N5B,N4B)+RQRAL4(N,1,N5B,N4B)
      XQRALS(N,1,N5B,N4B)=XQRALS(N,1,N5B,N4B)+RQRALS(N,1,N5B,N4B)
      XQRFE1(N,1,N5B,N4B)=XQRFE1(N,1,N5B,N4B)+RQRFE1(N,1,N5B,N4B)
      XQRFE2(N,1,N5B,N4B)=XQRFE2(N,1,N5B,N4B)+RQRFE2(N,1,N5B,N4B)
      XQRFE3(N,1,N5B,N4B)=XQRFE3(N,1,N5B,N4B)+RQRFE3(N,1,N5B,N4B)
      XQRFE4(N,1,N5B,N4B)=XQRFE4(N,1,N5B,N4B)+RQRFE4(N,1,N5B,N4B)
      XQRFES(N,1,N5B,N4B)=XQRFES(N,1,N5B,N4B)+RQRFES(N,1,N5B,N4B)
      XQRCAO(N,1,N5B,N4B)=XQRCAO(N,1,N5B,N4B)+RQRCAO(N,1,N5B,N4B)
      XQRCAC(N,1,N5B,N4B)=XQRCAC(N,1,N5B,N4B)+RQRCAC(N,1,N5B,N4B)
      XQRCAH(N,1,N5B,N4B)=XQRCAH(N,1,N5B,N4B)+RQRCAH(N,1,N5B,N4B)
      XQRCAS(N,1,N5B,N4B)=XQRCAS(N,1,N5B,N4B)+RQRCAS(N,1,N5B,N4B)
      XQRMGO(N,1,N5B,N4B)=XQRMGO(N,1,N5B,N4B)+RQRMGO(N,1,N5B,N4B)
      XQRMGC(N,1,N5B,N4B)=XQRMGC(N,1,N5B,N4B)+RQRMGC(N,1,N5B,N4B)
      XQRMGH(N,1,N5B,N4B)=XQRMGH(N,1,N5B,N4B)+RQRMGH(N,1,N5B,N4B)
      XQRMGS(N,1,N5B,N4B)=XQRMGS(N,1,N5B,N4B)+RQRMGS(N,1,N5B,N4B)
      XQRNAC(N,1,N5B,N4B)=XQRNAC(N,1,N5B,N4B)+RQRNAC(N,1,N5B,N4B)
      XQRNAS(N,1,N5B,N4B)=XQRNAS(N,1,N5B,N4B)+RQRNAS(N,1,N5B,N4B)
      XQRKAS(N,1,N5B,N4B)=XQRKAS(N,1,N5B,N4B)+RQRKAS(N,1,N5B,N4B)
      XQRH0P(N,1,N5B,N4B)=XQRH0P(N,1,N5B,N4B)+RQRH0P(N,1,N5B,N4B)
      XQRH3P(N,1,N5B,N4B)=XQRH3P(N,1,N5B,N4B)+RQRH3P(N,1,N5B,N4B)
      XQRF1P(N,1,N5B,N4B)=XQRF1P(N,1,N5B,N4B)+RQRF1P(N,1,N5B,N4B)
      XQRF2P(N,1,N5B,N4B)=XQRF2P(N,1,N5B,N4B)+RQRF2P(N,1,N5B,N4B)
      XQRC0P(N,1,N5B,N4B)=XQRC0P(N,1,N5B,N4B)+RQRC0P(N,1,N5B,N4B)
      XQRC1P(N,1,N5B,N4B)=XQRC1P(N,1,N5B,N4B)+RQRC1P(N,1,N5B,N4B)
      XQRC2P(N,1,N5B,N4B)=XQRC2P(N,1,N5B,N4B)+RQRC2P(N,1,N5B,N4B)
      XQRM1P(N,1,N5B,N4B)=XQRM1P(N,1,N5B,N4B)+RQRM1P(N,1,N5B,N4B)
      ELSE
      RQRAL(N,1,N5B,N4B)=0.0
      RQRFE(N,1,N5B,N4B)=0.0
      RQRHY(N,1,N5B,N4B)=0.0
      RQRCA(N,1,N5B,N4B)=0.0
      RQRMG(N,1,N5B,N4B)=0.0
      RQRNA(N,1,N5B,N4B)=0.0
      RQRKA(N,1,N5B,N4B)=0.0
      RQROH(N,1,N5B,N4B)=0.0
      RQRSO(N,1,N5B,N4B)=0.0
      RQRCL(N,1,N5B,N4B)=0.0
      RQRC3(N,1,N5B,N4B)=0.0
      RQRHC(N,1,N5B,N4B)=0.0
      RQRAL1(N,1,N5B,N4B)=0.0
      RQRAL2(N,1,N5B,N4B)=0.0
      RQRAL3(N,1,N5B,N4B)=0.0
      RQRAL4(N,1,N5B,N4B)=0.0
      RQRALS(N,1,N5B,N4B)=0.0
      RQRFE1(N,1,N5B,N4B)=0.0
      RQRFE2(N,1,N5B,N4B)=0.0
      RQRFE3(N,1,N5B,N4B)=0.0
      RQRFE4(N,1,N5B,N4B)=0.0
      RQRFES(N,1,N5B,N4B)=0.0
      RQRCAO(N,1,N5B,N4B)=0.0
      RQRCAC(N,1,N5B,N4B)=0.0
      RQRCAH(N,1,N5B,N4B)=0.0
      RQRCAS(N,1,N5B,N4B)=0.0
      RQRMGO(N,1,N5B,N4B)=0.0
      RQRMGC(N,1,N5B,N4B)=0.0
      RQRMGH(N,1,N5B,N4B)=0.0
      RQRMGS(N,1,N5B,N4B)=0.0
      RQRNAC(N,1,N5B,N4B)=0.0
      RQRNAS(N,1,N5B,N4B)=0.0
      RQRKAS(N,1,N5B,N4B)=0.0
      RQRH0P(N,1,N5B,N4B)=0.0
      RQRH3P(N,1,N5B,N4B)=0.0
      RQRF1P(N,1,N5B,N4B)=0.0
      RQRF2P(N,1,N5B,N4B)=0.0
      RQRC0P(N,1,N5B,N4B)=0.0
      RQRC1P(N,1,N5B,N4B)=0.0
      RQRC2P(N,1,N5B,N4B)=0.0
      RQRM1P(N,1,N5B,N4B)=0.0 
      ENDIF
      ENDIF
      ELSE
      RQRAL(N,2,N5,N4)=0.0
      RQRFE(N,2,N5,N4)=0.0
      RQRHY(N,2,N5,N4)=0.0
      RQRCA(N,2,N5,N4)=0.0
      RQRMG(N,2,N5,N4)=0.0
      RQRNA(N,2,N5,N4)=0.0
      RQRKA(N,2,N5,N4)=0.0
      RQROH(N,2,N5,N4)=0.0
      RQRSO(N,2,N5,N4)=0.0
      RQRCL(N,2,N5,N4)=0.0
      RQRC3(N,2,N5,N4)=0.0
      RQRHC(N,2,N5,N4)=0.0
      RQRAL1(N,2,N5,N4)=0.0
      RQRAL2(N,2,N5,N4)=0.0
      RQRAL3(N,2,N5,N4)=0.0
      RQRAL4(N,2,N5,N4)=0.0
      RQRALS(N,2,N5,N4)=0.0
      RQRFE1(N,2,N5,N4)=0.0
      RQRFE2(N,2,N5,N4)=0.0
      RQRFE3(N,2,N5,N4)=0.0
      RQRFE4(N,2,N5,N4)=0.0
      RQRFES(N,2,N5,N4)=0.0
      RQRCAO(N,2,N5,N4)=0.0
      RQRCAC(N,2,N5,N4)=0.0
      RQRCAH(N,2,N5,N4)=0.0
      RQRCAS(N,2,N5,N4)=0.0
      RQRMGO(N,2,N5,N4)=0.0
      RQRMGC(N,2,N5,N4)=0.0
      RQRMGH(N,2,N5,N4)=0.0
      RQRMGS(N,2,N5,N4)=0.0
      RQRNAC(N,2,N5,N4)=0.0
      RQRNAS(N,2,N5,N4)=0.0
      RQRKAS(N,2,N5,N4)=0.0
      RQRH0P(N,2,N5,N4)=0.0
      RQRH3P(N,2,N5,N4)=0.0
      RQRF1P(N,2,N5,N4)=0.0
      RQRF2P(N,2,N5,N4)=0.0
      RQRC0P(N,2,N5,N4)=0.0
      RQRC1P(N,2,N5,N4)=0.0
      RQRC2P(N,2,N5,N4)=0.0
      RQRM1P(N,2,N5,N4)=0.0
      IF(N4B.GT.0.AND.N5B.GT.0)THEN
      RQRAL(N,1,N5B,N4B)=0.0
      RQRFE(N,1,N5B,N4B)=0.0
      RQRHY(N,1,N5B,N4B)=0.0
      RQRCA(N,1,N5B,N4B)=0.0
      RQRMG(N,1,N5B,N4B)=0.0
      RQRNA(N,1,N5B,N4B)=0.0
      RQRKA(N,1,N5B,N4B)=0.0
      RQROH(N,1,N5B,N4B)=0.0
      RQRSO(N,1,N5B,N4B)=0.0
      RQRCL(N,1,N5B,N4B)=0.0
      RQRC3(N,1,N5B,N4B)=0.0
      RQRHC(N,1,N5B,N4B)=0.0
      RQRAL1(N,1,N5B,N4B)=0.0
      RQRAL2(N,1,N5B,N4B)=0.0
      RQRAL3(N,1,N5B,N4B)=0.0
      RQRAL4(N,1,N5B,N4B)=0.0
      RQRALS(N,1,N5B,N4B)=0.0
      RQRFE1(N,1,N5B,N4B)=0.0
      RQRFE2(N,1,N5B,N4B)=0.0
      RQRFE3(N,1,N5B,N4B)=0.0
      RQRFE4(N,1,N5B,N4B)=0.0
      RQRFES(N,1,N5B,N4B)=0.0
      RQRCAO(N,1,N5B,N4B)=0.0
      RQRCAC(N,1,N5B,N4B)=0.0
      RQRCAH(N,1,N5B,N4B)=0.0
      RQRCAS(N,1,N5B,N4B)=0.0
      RQRMGO(N,1,N5B,N4B)=0.0
      RQRMGC(N,1,N5B,N4B)=0.0
      RQRMGH(N,1,N5B,N4B)=0.0
      RQRMGS(N,1,N5B,N4B)=0.0
      RQRNAC(N,1,N5B,N4B)=0.0
      RQRNAS(N,1,N5B,N4B)=0.0
      RQRKAS(N,1,N5B,N4B)=0.0
      RQRH0P(N,1,N5B,N4B)=0.0
      RQRH3P(N,1,N5B,N4B)=0.0
      RQRF1P(N,1,N5B,N4B)=0.0
      RQRF2P(N,1,N5B,N4B)=0.0
      RQRC0P(N,1,N5B,N4B)=0.0
      RQRC1P(N,1,N5B,N4B)=0.0
      RQRC2P(N,1,N5B,N4B)=0.0
      RQRM1P(N,1,N5B,N4B)=0.0
      ENDIF
      ENDIF
C
C     SNOW DRIFT 
C
C     QSM=snow transfer from watsub.f
C     RQS*=solute flux in snow transfer
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     VOLS=volume of snowpack from watsub.f
C     *W2=solute content of snowpack
C
      IF(NN.EQ.1)THEN
C
C     IF NO SNOW DRIFT THEN NO TRANSPORT
C
      IF(ABS(QSM(M,N,N5,N4)).LE.ZEROS2(N2,N1))THEN
      RQSAL(N,N5,N4)=0.0
      RQSFE(N,N5,N4)=0.0
      RQSHY(N,N5,N4)=0.0
      RQSCA(N,N5,N4)=0.0
      RQSMG(N,N5,N4)=0.0
      RQSNA(N,N5,N4)=0.0
      RQSKA(N,N5,N4)=0.0
      RQSOH(N,N5,N4)=0.0
      RQSSO(N,N5,N4)=0.0
      RQSCL(N,N5,N4)=0.0
      RQSC3(N,N5,N4)=0.0
      RQSHC(N,N5,N4)=0.0
      RQSAL1(N,N5,N4)=0.0
      RQSAL2(N,N5,N4)=0.0
      RQSAL3(N,N5,N4)=0.0
      RQSAL4(N,N5,N4)=0.0
      RQSALS(N,N5,N4)=0.0
      RQSFE1(N,N5,N4)=0.0
      RQSFE2(N,N5,N4)=0.0
      RQSFE3(N,N5,N4)=0.0
      RQSFE4(N,N5,N4)=0.0
      RQSFES(N,N5,N4)=0.0
      RQSCAO(N,N5,N4)=0.0
      RQSCAC(N,N5,N4)=0.0
      RQSCAH(N,N5,N4)=0.0
      RQSCAS(N,N5,N4)=0.0
      RQSMGO(N,N5,N4)=0.0
      RQSMGC(N,N5,N4)=0.0
      RQSMGH(N,N5,N4)=0.0
      RQSMGS(N,N5,N4)=0.0
      RQSNAC(N,N5,N4)=0.0
      RQSNAS(N,N5,N4)=0.0
      RQSKAS(N,N5,N4)=0.0
      RQSH0P(N,N5,N4)=0.0
      RQSH3P(N,N5,N4)=0.0
      RQSF1P(N,N5,N4)=0.0
      RQSF2P(N,N5,N4)=0.0
      RQSC0P(N,N5,N4)=0.0
      RQSC1P(N,N5,N4)=0.0
      RQSC2P(N,N5,N4)=0.0
      RQSM1P(N,N5,N4)=0.0
C
C     IF DRIFT IS FROM CURRENT TO ADJACENT GRID CELL
C
      ELSEIF(QSM(M,N,N5,N4).GT.0.0)THEN
      IF(VOLS(N2,N1).GT.ZEROS2(NY,NX))THEN
      VFLW=AMAX1(0.0,AMIN1(VFLWX,QSM(M,N,N5,N4)/VOLS(N2,N1)))
      ELSE
      VFLW=VFLWX
      ENDIF
      RQSAL(N,N5,N4)=VFLW*AMAX1(0.0,ZALW2(1,N2,N1)) 
      RQSFE(N,N5,N4)=VFLW*AMAX1(0.0,ZFEW2(1,N2,N1))
      RQSHY(N,N5,N4)=VFLW*AMAX1(0.0,ZHYW2(1,N2,N1))
      RQSCA(N,N5,N4)=VFLW*AMAX1(0.0,ZCAW2(1,N2,N1))
      RQSMG(N,N5,N4)=VFLW*AMAX1(0.0,ZMGW2(1,N2,N1))
      RQSNA(N,N5,N4)=VFLW*AMAX1(0.0,ZNAW2(1,N2,N1))
      RQSKA(N,N5,N4)=VFLW*AMAX1(0.0,ZKAW2(1,N2,N1))
      RQSOH(N,N5,N4)=VFLW*AMAX1(0.0,ZOHW2(1,N2,N1))
      RQSSO(N,N5,N4)=VFLW*AMAX1(0.0,ZSO4W2(1,N2,N1))
      RQSCL(N,N5,N4)=VFLW*AMAX1(0.0,ZCLW2(1,N2,N1))
      RQSC3(N,N5,N4)=VFLW*AMAX1(0.0,ZCO3W2(1,N2,N1))
      RQSHC(N,N5,N4)=VFLW*AMAX1(0.0,ZHCO3W2(1,N2,N1)) 
      RQSAL1(N,N5,N4)=VFLW*AMAX1(0.0,ZALH1W2(1,N2,N1))
      RQSAL2(N,N5,N4)=VFLW*AMAX1(0.0,ZALH2W2(1,N2,N1))
      RQSAL3(N,N5,N4)=VFLW*AMAX1(0.0,ZALH3W2(1,N2,N1))
      RQSAL4(N,N5,N4)=VFLW*AMAX1(0.0,ZALH4W2(1,N2,N1))
      RQSALS(N,N5,N4)=VFLW*AMAX1(0.0,ZALSW2(1,N2,N1))
      RQSFE1(N,N5,N4)=VFLW*AMAX1(0.0,ZFEH1W2(1,N2,N1))
      RQSFE2(N,N5,N4)=VFLW*AMAX1(0.0,ZFEH2W2(1,N2,N1))
      RQSFE3(N,N5,N4)=VFLW*AMAX1(0.0,ZFEH3W2(1,N2,N1))
      RQSFE4(N,N5,N4)=VFLW*AMAX1(0.0,ZFEH4W2(1,N2,N1))
      RQSFES(N,N5,N4)=VFLW*AMAX1(0.0,ZFESW2(1,N2,N1))
      RQSCAO(N,N5,N4)=VFLW*AMAX1(0.0,ZCAOW2(1,N2,N1))
      RQSCAC(N,N5,N4)=VFLW*AMAX1(0.0,ZCACW2(1,N2,N1))
      RQSCAH(N,N5,N4)=VFLW*AMAX1(0.0,ZCAHW2(1,N2,N1))
      RQSCAS(N,N5,N4)=VFLW*AMAX1(0.0,ZCASW2(1,N2,N1))
      RQSMGO(N,N5,N4)=VFLW*AMAX1(0.0,ZMGOW2(1,N2,N1)) 
      RQSMGC(N,N5,N4)=VFLW*AMAX1(0.0,ZMGCW2(1,N2,N1))
      RQSMGH(N,N5,N4)=VFLW*AMAX1(0.0,ZMGHW2(1,N2,N1))
      RQSMGS(N,N5,N4)=VFLW*AMAX1(0.0,ZMGSW2(1,N2,N1))
      RQSNAC(N,N5,N4)=VFLW*AMAX1(0.0,ZNACW2(1,N2,N1))
      RQSNAS(N,N5,N4)=VFLW*AMAX1(0.0,ZNASW2(1,N2,N1))
      RQSKAS(N,N5,N4)=VFLW*AMAX1(0.0,ZKASW2(1,N2,N1))
      RQSH0P(N,N5,N4)=VFLW*AMAX1(0.0,H0PO4W2(1,N2,N1))
      RQSH3P(N,N5,N4)=VFLW*AMAX1(0.0,H3PO4W2(1,N2,N1))
      RQSF1P(N,N5,N4)=VFLW*AMAX1(0.0,ZFE1PW2(1,N2,N1))
      RQSF2P(N,N5,N4)=VFLW*AMAX1(0.0,ZFE2PW2(1,N2,N1))
      RQSC0P(N,N5,N4)=VFLW*AMAX1(0.0,ZCA0PW2(1,N2,N1))
      RQSC1P(N,N5,N4)=VFLW*AMAX1(0.0,ZCA1PW2(1,N2,N1))
      RQSC2P(N,N5,N4)=VFLW*AMAX1(0.0,ZCA2PW2(1,N2,N1))
      RQSM1P(N,N5,N4)=VFLW*AMAX1(0.0,ZMG1PW2(1,N2,N1))
C
C     IF DRIFT IS TO CURRENT FROM ADJACENT GRID CELL
C
      ELSEIF(QSM(M,N,N5,N4).LT.-ZEROS2(N2,N1))THEN
      IF(VOLS(N5,N4).GT.ZEROS2(N5,N4))THEN
      VFLW=AMIN1(0.0,AMAX1(-VFLWX,QSM(M,N,N5,N4)/VOLS(N5,N4)))
      ELSE
      VFLW=-VFLWX 
      ENDIF
      RQSAL(N,N5,N4)=VFLW*AMAX1(0.0,ZALW2(1,N5,N4))
      RQSFE(N,N5,N4)=VFLW*AMAX1(0.0,ZFEW2(1,N5,N4))
      RQSHY(N,N5,N4)=VFLW*AMAX1(0.0,ZHYW2(1,N5,N4))
      RQSCA(N,N5,N4)=VFLW*AMAX1(0.0,ZCAW2(1,N5,N4))
      RQSMG(N,N5,N4)=VFLW*AMAX1(0.0,ZMGW2(1,N5,N4))
      RQSNA(N,N5,N4)=VFLW*AMAX1(0.0,ZNAW2(1,N5,N4))
      RQSKA(N,N5,N4)=VFLW*AMAX1(0.0,ZKAW2(1,N5,N4))
      RQSOH(N,N5,N4)=VFLW*AMAX1(0.0,ZOHW2(1,N5,N4)) 
      RQSSO(N,N5,N4)=VFLW*AMAX1(0.0,ZSO4W2(1,N5,N4))
      RQSCL(N,N5,N4)=VFLW*AMAX1(0.0,ZCLW2(1,N5,N4))
      RQSC3(N,N5,N4)=VFLW*AMAX1(0.0,ZCO3W2(1,N5,N4)) 
      RQSHC(N,N5,N4)=VFLW*AMAX1(0.0,ZHCO3W2(1,N5,N4))
      RQSAL1(N,N5,N4)=VFLW*AMAX1(0.0,ZALH1W2(1,N5,N4))
      RQSAL2(N,N5,N4)=VFLW*AMAX1(0.0,ZALH2W2(1,N5,N4))
      RQSAL3(N,N5,N4)=VFLW*AMAX1(0.0,ZALH3W2(1,N5,N4))
      RQSAL4(N,N5,N4)=VFLW*AMAX1(0.0,ZALH4W2(1,N5,N4))
      RQSALS(N,N5,N4)=VFLW*AMAX1(0.0,ZALSW2(1,N5,N4))
      RQSFE1(N,N5,N4)=VFLW*AMAX1(0.0,ZFEH1W2(1,N5,N4))
      RQSFE2(N,N5,N4)=VFLW*AMAX1(0.0,ZFEH2W2(1,N5,N4))
      RQSFE3(N,N5,N4)=VFLW*AMAX1(0.0,ZFEH3W2(1,N5,N4))
      RQSFE4(N,N5,N4)=VFLW*AMAX1(0.0,ZFEH4W2(1,N5,N4))
      RQSFES(N,N5,N4)=VFLW*AMAX1(0.0,ZFESW2(1,N5,N4))
      RQSCAO(N,N5,N4)=VFLW*AMAX1(0.0,ZCAOW2(1,N5,N4))
      RQSCAC(N,N5,N4)=VFLW*AMAX1(0.0,ZCACW2(1,N5,N4))
      RQSCAH(N,N5,N4)=VFLW*AMAX1(0.0,ZCAHW2(1,N5,N4))
      RQSCAS(N,N5,N4)=VFLW*AMAX1(0.0,ZCASW2(1,N5,N4))
      RQSMGO(N,N5,N4)=VFLW*AMAX1(0.0,ZMGOW2(1,N5,N4))
      RQSMGC(N,N5,N4)=VFLW*AMAX1(0.0,ZMGCW2(1,N5,N4)) 
      RQSMGH(N,N5,N4)=VFLW*AMAX1(0.0,ZMGHW2(1,N5,N4))
      RQSMGS(N,N5,N4)=VFLW*AMAX1(0.0,ZMGSW2(1,N5,N4))
      RQSNAC(N,N5,N4)=VFLW*AMAX1(0.0,ZNACW2(1,N5,N4))
      RQSNAS(N,N5,N4)=VFLW*AMAX1(0.0,ZNASW2(1,N5,N4))
      RQSKAS(N,N5,N4)=VFLW*AMAX1(0.0,ZKASW2(1,N5,N4))
      RQSH0P(N,N5,N4)=VFLW*AMAX1(0.0,H0PO4W2(1,N5,N4))
      RQSH3P(N,N5,N4)=VFLW*AMAX1(0.0,H3PO4W2(1,N5,N4))
      RQSF1P(N,N5,N4)=VFLW*AMAX1(0.0,ZFE1PW2(1,N5,N4))
      RQSF2P(N,N5,N4)=VFLW*AMAX1(0.0,ZFE2PW2(1,N5,N4))
      RQSC0P(N,N5,N4)=VFLW*AMAX1(0.0,ZCA0PW2(1,N5,N4))
      RQSC1P(N,N5,N4)=VFLW*AMAX1(0.0,ZCA1PW2(1,N5,N4))
      RQSC2P(N,N5,N4)=VFLW*AMAX1(0.0,ZCA2PW2(1,N5,N4))
      RQSM1P(N,N5,N4)=VFLW*AMAX1(0.0,ZMG1PW2(1,N5,N4))
      ENDIF
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     XQS*=hourly solute in snow transfer
C     RQS*=solute in snow transfer
C
      XQSAL(N,N5,N4)=XQSAL(N,N5,N4)+RQSAL(N,N5,N4)
      XQSFE(N,N5,N4)=XQSFE(N,N5,N4)+RQSFE(N,N5,N4)
      XQSHY(N,N5,N4)=XQSHY(N,N5,N4)+RQSHY(N,N5,N4)
      XQSCA(N,N5,N4)=XQSCA(N,N5,N4)+RQSCA(N,N5,N4)
      XQSMG(N,N5,N4)=XQSMG(N,N5,N4)+RQSMG(N,N5,N4)
      XQSNA(N,N5,N4)=XQSNA(N,N5,N4)+RQSNA(N,N5,N4)
      XQSKA(N,N5,N4)=XQSKA(N,N5,N4)+RQSKA(N,N5,N4)
      XQSOH(N,N5,N4)=XQSOH(N,N5,N4)+RQSOH(N,N5,N4)
      XQSSO(N,N5,N4)=XQSSO(N,N5,N4)+RQSSO(N,N5,N4)
      XQSCL(N,N5,N4)=XQSCL(N,N5,N4)+RQSCL(N,N5,N4)
      XQSC3(N,N5,N4)=XQSC3(N,N5,N4)+RQSC3(N,N5,N4)
      XQSHC(N,N5,N4)=XQSHC(N,N5,N4)+RQSHC(N,N5,N4)
      XQSAL1(N,N5,N4)=XQSAL1(N,N5,N4)+RQSAL1(N,N5,N4)
      XQSAL2(N,N5,N4)=XQSAL2(N,N5,N4)+RQSAL2(N,N5,N4)
      XQSAL3(N,N5,N4)=XQSAL3(N,N5,N4)+RQSAL3(N,N5,N4)
      XQSAL4(N,N5,N4)=XQSAL4(N,N5,N4)+RQSAL4(N,N5,N4)
      XQSALS(N,N5,N4)=XQSALS(N,N5,N4)+RQSALS(N,N5,N4)
      XQSFE1(N,N5,N4)=XQSFE1(N,N5,N4)+RQSFE1(N,N5,N4)
      XQSFE2(N,N5,N4)=XQSFE2(N,N5,N4)+RQSFE2(N,N5,N4)
      XQSFE3(N,N5,N4)=XQSFE3(N,N5,N4)+RQSFE3(N,N5,N4)
      XQSFE4(N,N5,N4)=XQSFE4(N,N5,N4)+RQSFE4(N,N5,N4)
      XQSFES(N,N5,N4)=XQSFES(N,N5,N4)+RQSFES(N,N5,N4)
      XQSCAO(N,N5,N4)=XQSCAO(N,N5,N4)+RQSCAO(N,N5,N4)
      XQSCAC(N,N5,N4)=XQSCAC(N,N5,N4)+RQSCAC(N,N5,N4)
      XQSCAH(N,N5,N4)=XQSCAH(N,N5,N4)+RQSCAH(N,N5,N4)
      XQSCAS(N,N5,N4)=XQSCAS(N,N5,N4)+RQSCAS(N,N5,N4)
      XQSMGO(N,N5,N4)=XQSMGO(N,N5,N4)+RQSMGO(N,N5,N4)
      XQSMGC(N,N5,N4)=XQSMGC(N,N5,N4)+RQSMGC(N,N5,N4)
      XQSMGH(N,N5,N4)=XQSMGH(N,N5,N4)+RQSMGH(N,N5,N4)
      XQSMGS(N,N5,N4)=XQSMGS(N,N5,N4)+RQSMGS(N,N5,N4)
      XQSNAC(N,N5,N4)=XQSNAC(N,N5,N4)+RQSNAC(N,N5,N4)
      XQSNAS(N,N5,N4)=XQSNAS(N,N5,N4)+RQSNAS(N,N5,N4)
      XQSKAS(N,N5,N4)=XQSKAS(N,N5,N4)+RQSKAS(N,N5,N4)
      XQSH0P(N,N5,N4)=XQSH0P(N,N5,N4)+RQSH0P(N,N5,N4)
      XQSH3P(N,N5,N4)=XQSH3P(N,N5,N4)+RQSH3P(N,N5,N4)
      XQSF1P(N,N5,N4)=XQSF1P(N,N5,N4)+RQSF1P(N,N5,N4)
      XQSF2P(N,N5,N4)=XQSF2P(N,N5,N4)+RQSF2P(N,N5,N4)
      XQSC0P(N,N5,N4)=XQSC0P(N,N5,N4)+RQSC0P(N,N5,N4)
      XQSC1P(N,N5,N4)=XQSC1P(N,N5,N4)+RQSC1P(N,N5,N4)
      XQSC2P(N,N5,N4)=XQSC2P(N,N5,N4)+RQSC2P(N,N5,N4)
      XQSM1P(N,N5,N4)=XQSM1P(N,N5,N4)+RQSM1P(N,N5,N4)
      ENDIF
4305  CONTINUE
4310  CONTINUE
C
C     SOLUTE FLUXES BETWEEN ADJACENT GRID CELLS
C
C     N3,N2,N1=L,NY,NX of source grid cell
C     N6,N5,N4=L,NY,NX of destination grid cell
C
      IFLGB=0
      DO 125 L=1,NL(NY,NX)
      N1=NX
      N2=NY
      N3=L
C
C     LOCATE INTERNAL BOUNDARIES BETWEEN ADJACENT GRID CELLS
C
      DO 120 N=NCN(N2,N1),3
      IF(N.EQ.1)THEN
      IF(NX.EQ.NHE)THEN
      GO TO 120
      ELSE
      N4=NX+1
      N5=NY
      N6=L
      ENDIF
      ELSEIF(N.EQ.2)THEN
      IF(NY.EQ.NVS)THEN
      GO TO 120
      ELSE
      N4=NX
      N5=NY+1
      N6=L
      ENDIF
      ELSEIF(N.EQ.3)THEN
      IF(L.EQ.NL(NY,NX))THEN
      GO TO 120
      ELSE
      N4=NX
      N5=NY
      N6=L+1
      ENDIF
      ENDIF
      DO 1100 LL=N6,NL(NY,NX)
      IF(VOLX(LL,N5,N4).GT.ZEROS2(N5,N4))THEN
      N6=LL
      GO TO 1101
      ENDIF
1100  CONTINUE
1101  CONTINUE
C
C     SOLUTE FLUXES BETWEEN ADJACENT GRID CELLS FROM
C     WATER CONTENTS AND WATER FLUXES 'FLQM' FROM 'WATSUB'
C
C     VOLX,VOLY=soil volume excluding rock, macropore
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C     VOLWM,VOLWHM=micropore,macropore water-filled porosity from watsub.f
C     THETW=volumetric water content
C     FLPM=change in air volume 
C     XNPT=1/number of cycles NPH-1 for gas flux calculations
C
      IF(VOLX(N3,N2,N1).GT.ZEROS2(NY,NX))THEN
      IF(N3.GE.NUM(N2,N1).AND.N6.GE.NUM(N5,N4)
     2.AND.N3.LE.NL(N2,N1).AND.N6.LE.NL(N5,N4))THEN
      THETW1(N3,N2,N1)=AMAX1(0.0,VOLWM(M,N3,N2,N1)/VOLY(N3,N2,N1))
      THETW1(N6,N5,N4)=AMAX1(0.0,VOLWM(M,N6,N5,N4)/VOLY(N6,N5,N4))
C
C     SOLUTE TRANSPORT IN MICROPORES
C
C     IF MICROPORE WATER FLUX FROM 'WATSUB' IS FROM CURRENT TO
C     ADJACENT GRID CELL THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MICROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN CURRENT GRID CELL
C
C     FLWM=water flux through soil micropore from watsub.f 
C     VOLWM=micropore water-filled porosity from watsub.f
C     RFL*S=solute diffusive flux through micropore
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     *S2,*B2=micropore solute content in non-band,band
C
      IF(FLWM(M,N,N6,N5,N4).GT.0.0)THEN
C
C     IF MICROPORE WATER FLUX FROM 'WATSUB' IS FROM CURRENT TO
C     ADJACENT GRID CELL THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MICROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN CURRENT GRID CELL
C
      IF(VOLWM(M,N3,N2,N1).GT.ZEROS2(N2,N1))THEN
      VFLW=AMAX1(0.0,AMIN1(VFLWX,FLWM(M,N,N6,N5,N4)
     2/VOLWM(M,N3,N2,N1)))
      ELSE
      VFLW=VFLWX
      ENDIF
      RFLAL=VFLW*AMAX1(0.0,ZAL2(N3,N2,N1))
      RFLFE=VFLW*AMAX1(0.0,ZFE2(N3,N2,N1))
      RFLHY=VFLW*AMAX1(0.0,ZHY2(N3,N2,N1))
      RFLCA=VFLW*AMAX1(0.0,ZCA2(N3,N2,N1))
      RFLMG=VFLW*AMAX1(0.0,ZMG2(N3,N2,N1))
      RFLNA=VFLW*AMAX1(0.0,ZNA2(N3,N2,N1))
      RFLKA=VFLW*AMAX1(0.0,ZKA2(N3,N2,N1))
      RFLOH=VFLW*AMAX1(0.0,ZOH2(N3,N2,N1))
      RFLSO=VFLW*AMAX1(0.0,ZSO42(N3,N2,N1))
      RFLCL=VFLW*AMAX1(0.0,ZCL2(N3,N2,N1))
      RFLC3=VFLW*AMAX1(0.0,ZCO32(N3,N2,N1))
      RFLHC=VFLW*AMAX1(0.0,ZHCO32(N3,N2,N1))
      RFLAL1=VFLW*AMAX1(0.0,ZAL12(N3,N2,N1))
      RFLAL2=VFLW*AMAX1(0.0,ZAL22(N3,N2,N1))
      RFLAL3=VFLW*AMAX1(0.0,ZAL32(N3,N2,N1))
      RFLAL4=VFLW*AMAX1(0.0,ZAL42(N3,N2,N1))
      RFLALS=VFLW*AMAX1(0.0,ZALS2(N3,N2,N1))
      RFLFE1=VFLW*AMAX1(0.0,ZFE12(N3,N2,N1))
      RFLFE2=VFLW*AMAX1(0.0,ZFE22(N3,N2,N1))
      RFLFE3=VFLW*AMAX1(0.0,ZFE32(N3,N2,N1))
      RFLFE4=VFLW*AMAX1(0.0,ZFE42(N3,N2,N1))
      RFLFES=VFLW*AMAX1(0.0,ZFES2(N3,N2,N1))
      RFLCAO=VFLW*AMAX1(0.0,ZCAO2(N3,N2,N1))
      RFLCAC=VFLW*AMAX1(0.0,ZCAC2(N3,N2,N1))
      RFLCAH=VFLW*AMAX1(0.0,ZCAH2(N3,N2,N1))
      RFLCAS=VFLW*AMAX1(0.0,ZCAS2(N3,N2,N1))
      RFLMGO=VFLW*AMAX1(0.0,ZMGO2(N3,N2,N1))
      RFLMGC=VFLW*AMAX1(0.0,ZMGC2(N3,N2,N1))
      RFLMGH=VFLW*AMAX1(0.0,ZMGH2(N3,N2,N1))
      RFLMGS=VFLW*AMAX1(0.0,ZMGS2(N3,N2,N1))
      RFLNAC=VFLW*AMAX1(0.0,ZNAC2(N3,N2,N1))
      RFLNAS=VFLW*AMAX1(0.0,ZNAS2(N3,N2,N1))
      RFLKAS=VFLW*AMAX1(0.0,ZKAS2(N3,N2,N1))
      RFLH0P=VFLW*AMAX1(0.0,H0PO42(N3,N2,N1))*VLPO4(N3,N2,N1)
      RFLH3P=VFLW*AMAX1(0.0,H3PO42(N3,N2,N1))*VLPO4(N3,N2,N1)
      RFLF1P=VFLW*AMAX1(0.0,ZFE1P2(N3,N2,N1))*VLPO4(N3,N2,N1)
      RFLF2P=VFLW*AMAX1(0.0,ZFE2P2(N3,N2,N1))*VLPO4(N3,N2,N1)
      RFLC0P=VFLW*AMAX1(0.0,ZCA0P2(N3,N2,N1))*VLPO4(N3,N2,N1)
      RFLC1P=VFLW*AMAX1(0.0,ZCA1P2(N3,N2,N1))*VLPO4(N3,N2,N1)
      RFLC2P=VFLW*AMAX1(0.0,ZCA2P2(N3,N2,N1))*VLPO4(N3,N2,N1)
      RFLM1P=VFLW*AMAX1(0.0,ZMG1P2(N3,N2,N1))*VLPO4(N3,N2,N1)
      RFLH0B=VFLW*AMAX1(0.0,H0POB2(N3,N2,N1))*VLPOB(N3,N2,N1)
      RFLH3B=VFLW*AMAX1(0.0,H3POB2(N3,N2,N1))*VLPOB(N3,N2,N1)
      RFLF1B=VFLW*AMAX1(0.0,ZF1PB2(N3,N2,N1))*VLPOB(N3,N2,N1)
      RFLF2B=VFLW*AMAX1(0.0,ZF2PB2(N3,N2,N1))*VLPOB(N3,N2,N1)
      RFLC0B=VFLW*AMAX1(0.0,ZC0PB2(N3,N2,N1))*VLPOB(N3,N2,N1)
      RFLC1B=VFLW*AMAX1(0.0,ZC1PB2(N3,N2,N1))*VLPOB(N3,N2,N1)
      RFLC2B=VFLW*AMAX1(0.0,ZC2PB2(N3,N2,N1))*VLPOB(N3,N2,N1)
      RFLM1B=VFLW*AMAX1(0.0,ZM1PB2(N3,N2,N1))*VLPOB(N3,N2,N1)
C
C     IF MICROPORE WATER FLUX FROM 'WATSUB' IS TO CURRENT FROM
C     ADJACENT GRID CELL THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MICROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN ADJACENT GRID CELL
C
      ELSE
      IF(VOLWM(M,N6,N5,N4).GT.ZEROS2(N5,N4))THEN
      VFLW=AMIN1(0.0,AMAX1(-VFLWX,FLWM(M,N,N6,N5,N4)
     2/VOLWM(M,N6,N5,N4)))
      ELSE
      VFLW=-VFLWX
      ENDIF
      RFLAL=VFLW*AMAX1(0.0,ZAL2(N6,N5,N4))
      RFLFE=VFLW*AMAX1(0.0,ZFE2(N6,N5,N4))
      RFLHY=VFLW*AMAX1(0.0,ZHY2(N6,N5,N4))
      RFLCA=VFLW*AMAX1(0.0,ZCA2(N6,N5,N4))
      RFLMG=VFLW*AMAX1(0.0,ZMG2(N6,N5,N4))
      RFLNA=VFLW*AMAX1(0.0,ZNA2(N6,N5,N4))
      RFLKA=VFLW*AMAX1(0.0,ZKA2(N6,N5,N4))
      RFLOH=VFLW*AMAX1(0.0,ZOH2(N6,N5,N4))
      RFLSO=VFLW*AMAX1(0.0,ZSO42(N6,N5,N4))
      RFLCL=VFLW*AMAX1(0.0,ZCL2(N6,N5,N4))
      RFLC3=VFLW*AMAX1(0.0,ZCO32(N6,N5,N4))
      RFLHC=VFLW*AMAX1(0.0,ZHCO32(N6,N5,N4))
      RFLAL1=VFLW*AMAX1(0.0,ZAL12(N6,N5,N4))
      RFLAL2=VFLW*AMAX1(0.0,ZAL22(N6,N5,N4))
      RFLAL3=VFLW*AMAX1(0.0,ZAL32(N6,N5,N4))
      RFLAL4=VFLW*AMAX1(0.0,ZAL42(N6,N5,N4))
      RFLALS=VFLW*AMAX1(0.0,ZALS2(N6,N5,N4))
      RFLFE1=VFLW*AMAX1(0.0,ZFE12(N6,N5,N4))
      RFLFE2=VFLW*AMAX1(0.0,ZFE22(N6,N5,N4))
      RFLFE3=VFLW*AMAX1(0.0,ZFE32(N6,N5,N4))
      RFLFE4=VFLW*AMAX1(0.0,ZFE42(N6,N5,N4))
      RFLFES=VFLW*AMAX1(0.0,ZFES2(N6,N5,N4))
      RFLCAO=VFLW*AMAX1(0.0,ZCAO2(N6,N5,N4))
      RFLCAC=VFLW*AMAX1(0.0,ZCAC2(N6,N5,N4))
      RFLCAH=VFLW*AMAX1(0.0,ZCAH2(N6,N5,N4))
      RFLCAS=VFLW*AMAX1(0.0,ZCAS2(N6,N5,N4))
      RFLMGO=VFLW*AMAX1(0.0,ZMGO2(N6,N5,N4))
      RFLMGC=VFLW*AMAX1(0.0,ZMGC2(N6,N5,N4))
      RFLMGH=VFLW*AMAX1(0.0,ZMGH2(N6,N5,N4))
      RFLMGS=VFLW*AMAX1(0.0,ZMGS2(N6,N5,N4))
      RFLNAC=VFLW*AMAX1(0.0,ZNAC2(N6,N5,N4))
      RFLNAS=VFLW*AMAX1(0.0,ZNAS2(N6,N5,N4))
      RFLKAS=VFLW*AMAX1(0.0,ZKAS2(N6,N5,N4))
      RFLH0P=VFLW*AMAX1(0.0,H0PO42(N6,N5,N4))
      RFLH3P=VFLW*AMAX1(0.0,H3PO42(N6,N5,N4))
      RFLF1P=VFLW*AMAX1(0.0,ZFE1P2(N6,N5,N4))
      RFLF2P=VFLW*AMAX1(0.0,ZFE2P2(N6,N5,N4))
      RFLC0P=VFLW*AMAX1(0.0,ZCA0P2(N6,N5,N4))
      RFLC1P=VFLW*AMAX1(0.0,ZCA1P2(N6,N5,N4))
      RFLC2P=VFLW*AMAX1(0.0,ZCA2P2(N6,N5,N4))
      RFLM1P=VFLW*AMAX1(0.0,ZMG1P2(N6,N5,N4))
      RFLH0B=VFLW*AMAX1(0.0,H0POB2(N6,N5,N4))
      RFLH3B=VFLW*AMAX1(0.0,H3POB2(N6,N5,N4))
      RFLF1B=VFLW*AMAX1(0.0,ZF1PB2(N6,N5,N4))
      RFLF2B=VFLW*AMAX1(0.0,ZF2PB2(N6,N5,N4))
      RFLC0B=VFLW*AMAX1(0.0,ZC0PB2(N6,N5,N4))
      RFLC1B=VFLW*AMAX1(0.0,ZC1PB2(N6,N5,N4))
      RFLC2B=VFLW*AMAX1(0.0,ZC2PB2(N6,N5,N4))
      RFLM1B=VFLW*AMAX1(0.0,ZM1PB2(N6,N5,N4))
      ENDIF
C
C     DIFFUSIVE FLUXES OF SOLUTES BETWEEN CURRENT AND
C     ADJACENT GRID CELL MICROPORES FROM AQUEOUS DIFFUSIVITIES
C     AND CONCENTRATION DIFFERENCES
C
      IF(THETW1(N3,N2,N1).GT.THETY(N3,N2,N1)
     2.AND.THETW1(N6,N5,N4).GT.THETY(N6,N5,N4)
     3.AND.VOLWM(M,N3,N2,N1).GT.ZEROS2(N2,N1)
     4.AND.VOLWM(M,N6,N5,N4).GT.ZEROS2(N5,N4))THEN
C
C     VOLWM=micropore water-filled porosity from watsub.f
C     THETW=volumetric water content
C
C     MICROPORE CONCENTRATIONS FROM WATER-FILLED POROSITY
C     IN CURRENT AND ADJACENT GRID CELLS
C
C     C*1,C*2=solute concentration in source,destination layer
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     *S2,*B2=soil solute content in non-band,band
C
      VLWPA1=VOLWM(M,N3,N2,N1)*VLPO4(N3,N2,N1)
      VLWPB1=VOLWM(M,N3,N2,N1)*VLPOB(N3,N2,N1)
      VLWPA2=VOLWM(M,N6,N5,N4)*VLPO4(N6,N5,N4)
      VLWPB2=VOLWM(M,N6,N5,N4)*VLPOB(N6,N5,N4)
      CAL1=AMAX1(0.0,ZAL2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CFE1=AMAX1(0.0,ZFE2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CHY1=AMAX1(0.0,ZHY2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CCA1=AMAX1(0.0,ZCA2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CMG1=AMAX1(0.0,ZMG2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CNA1=AMAX1(0.0,ZNA2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CKA1=AMAX1(0.0,ZKA2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      COH1=AMAX1(0.0,ZOH2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CSO41=AMAX1(0.0,ZSO42(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CCL1=AMAX1(0.0,ZCL2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CCO31=AMAX1(0.0,ZCO32(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CHCO31=AMAX1(0.0,ZHCO32(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CAL11=AMAX1(0.0,ZAL12(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CAL21=AMAX1(0.0,ZAL22(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CAL31=AMAX1(0.0,ZAL32(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CAL41=AMAX1(0.0,ZAL42(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CALS1=AMAX1(0.0,ZALS2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CFE11=AMAX1(0.0,ZFE12(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CFE21=AMAX1(0.0,ZFE22(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CFE31=AMAX1(0.0,ZFE32(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CFE41=AMAX1(0.0,ZFE42(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CFES1=AMAX1(0.0,ZFES2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CCAO1=AMAX1(0.0,ZCAO2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CCAC1=AMAX1(0.0,ZCAC2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CCAH1=AMAX1(0.0,ZCAH2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CCAS1=AMAX1(0.0,ZCAS2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CMGO1=AMAX1(0.0,ZMGO2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CMGC1=AMAX1(0.0,ZMGC2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CMGH1=AMAX1(0.0,ZMGH2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CMGS1=AMAX1(0.0,ZMGS2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CNAC1=AMAX1(0.0,ZNAC2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CNAS1=AMAX1(0.0,ZNAS2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      CKAS1=AMAX1(0.0,ZKAS2(N3,N2,N1)/VOLWM(M,N3,N2,N1))
      IF(VLWPA1.GT.ZEROS(N2,N1))THEN
      C0PO41=AMAX1(0.0,H0PO42(N3,N2,N1)/VLWPA1)
      C3PO41=AMAX1(0.0,H3PO42(N3,N2,N1)/VLWPA1)
      CFE1P1=AMAX1(0.0,ZFE1P2(N3,N2,N1)/VLWPA1)
      CFE2P1=AMAX1(0.0,ZFE2P2(N3,N2,N1)/VLWPA1)
      CCA0P1=AMAX1(0.0,ZCA0P2(N3,N2,N1)/VLWPA1)
      CCA1P1=AMAX1(0.0,ZCA1P2(N3,N2,N1)/VLWPA1)
      CCA2P1=AMAX1(0.0,ZCA2P2(N3,N2,N1)/VLWPA1)
      CMG1P1=AMAX1(0.0,ZMG1P2(N3,N2,N1)/VLWPA1)
      ELSE
      C0PO41=0.0
      C3PO41=0.0
      CFE1P1=0.0
      CFE2P1=0.0
      CCA0P1=0.0
      CCA1P1=0.0
      CCA2P1=0.0
      CMG1P1=0.0
      ENDIF
      IF(VLWPB1.GT.ZEROS(N2,N1))THEN
      C0POB1=AMAX1(0.0,H0POB2(N3,N2,N1)/VLWPB1)
      C3POB1=AMAX1(0.0,H3POB2(N3,N2,N1)/VLWPB1)
      CF1PB1=AMAX1(0.0,ZF1PB2(N3,N2,N1)/VLWPB1)
      CF2PB1=AMAX1(0.0,ZF2PB2(N3,N2,N1)/VLWPB1)
      CC0PB1=AMAX1(0.0,ZC0PB2(N3,N2,N1)/VLWPB1)
      CC1PB1=AMAX1(0.0,ZC1PB2(N3,N2,N1)/VLWPB1)
      CC2PB1=AMAX1(0.0,ZC2PB2(N3,N2,N1)/VLWPB1)
      CM1PB1=AMAX1(0.0,ZM1PB2(N3,N2,N1)/VLWPB1)
      ELSE
      C0POB1=C0PO41
      C3POB1=C3PO41
      CF1PB1=CFE1P1
      CF2PB1=CFE2P1
      CC0PB1=CCA0P1
      CC1PB1=CCA1P1
      CC2PB1=CCA2P1
      CM1PB1=CMG1P1
      ENDIF
      CAL2=AMAX1(0.0,ZAL2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CFE2=AMAX1(0.0,ZFE2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CHY2=AMAX1(0.0,ZHY2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CCA2=AMAX1(0.0,ZCA2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CMG2=AMAX1(0.0,ZMG2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CNA2=AMAX1(0.0,ZNA2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CKA2=AMAX1(0.0,ZKA2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      COH2=AMAX1(0.0,ZOH2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CSO42=AMAX1(0.0,ZSO42(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CCL2=AMAX1(0.0,ZCL2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CCO32=AMAX1(0.0,ZCO32(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CHCO32=AMAX1(0.0,ZHCO32(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CAL12=AMAX1(0.0,ZAL12(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CAL22=AMAX1(0.0,ZAL22(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CAL32=AMAX1(0.0,ZAL32(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CAL42=AMAX1(0.0,ZAL42(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CALS2=AMAX1(0.0,ZALS2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CFE12=AMAX1(0.0,ZFE12(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CFE22=AMAX1(0.0,ZFE22(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CFE32=AMAX1(0.0,ZFE32(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CFE42=AMAX1(0.0,ZFE42(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CFES2=AMAX1(0.0,ZFES2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CCAO2=AMAX1(0.0,ZCAO2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CCAC2=AMAX1(0.0,ZCAC2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CCAH2=AMAX1(0.0,ZCAH2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CCAS2=AMAX1(0.0,ZCAS2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CMGO2=AMAX1(0.0,ZMGO2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CMGC2=AMAX1(0.0,ZMGC2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CMGH2=AMAX1(0.0,ZMGH2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CMGS2=AMAX1(0.0,ZMGS2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CNAC2=AMAX1(0.0,ZNAC2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CNAS2=AMAX1(0.0,ZNAS2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CKAS2=AMAX1(0.0,ZKAS2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      IF(VLWPA2.GT.ZEROS(N5,N4))THEN
      C0PO42=AMAX1(0.0,H0PO42(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      C3PO42=AMAX1(0.0,H3PO42(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CFE1P2=AMAX1(0.0,ZFE1P2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CFE2P2=AMAX1(0.0,ZFE2P2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CCA0P2=AMAX1(0.0,ZCA0P2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CCA1P2=AMAX1(0.0,ZCA1P2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CCA2P2=AMAX1(0.0,ZCA2P2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CMG1P2=AMAX1(0.0,ZMG1P2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      ELSE
      C0PO42=0.0
      C3PO42=0.0
      CFE1P2=0.0
      CFE2P2=0.0
      CCA0P2=0.0
      CCA1P2=0.0
      CCA2P2=0.0
      CMG1P2=0.0
      ENDIF
      IF(VLWPB2.GT.ZEROS(N5,N4))THEN
      C0POB2=AMAX1(0.0,H0POB2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      C3POB2=AMAX1(0.0,H3POB2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CF1PB2=AMAX1(0.0,ZF1PB2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CF2PB2=AMAX1(0.0,ZF2PB2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CC0PB2=AMAX1(0.0,ZC0PB2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CC1PB2=AMAX1(0.0,ZC1PB2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CC2PB2=AMAX1(0.0,ZC2PB2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      CM1PB2=AMAX1(0.0,ZM1PB2(N6,N5,N4)/VOLWM(M,N6,N5,N4))
      ELSE
      C0POB2=C0PO42
      C3POB2=C3PO42
      CF1PB2=CFE1P2
      CF2PB2=CFE2P2
      CC0PB2=CCA0P2
      CC1PB2=CCA1P2
      CC2PB2=CCA2P2
      CM1PB2=CMG1P2
      ENDIF
C
C     DIFFUSIVITIES IN CURRENT AND ADJACENT GRID CELL MICROPORES
C
C     DLYR=soil layer thickness
C     TORT=micropore tortuosity from hour1.f 
C     DISP=dispersivity parameter
C     FLWM=water flux through soil micropore from watsub.f 
C     DIF*=aqueous diffusivity-dispersivity through micropore
C     *SGL2=solute diffusivity from hour1.f
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     XDPTH=cross-sectional area/distance between layers
C     C*1,C*2=micropore solute concentration in source,destination layer
C     DFV*=diffusive solute transfer through soil micropore 
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C
      DLYR1=AMAX1(ZERO2,DLYR(N,N3,N2,N1))
      DLYR2=AMAX1(ZERO2,DLYR(N,N6,N5,N4))
      TORTL=(TORT(M,N3,N2,N1)*DLYR1+TORT(M,N6,N5,N4)*DLYR2)
     2/(DLYR1+DLYR2)
      DISPN=DISP(N,N6,N5,N4)
     2*AMIN1(VFLWX,ABS(FLWM(M,N,N6,N5,N4)/AREA(N,N6,N5,N4)))
      DIFPO=(POSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFAL=(ALSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFFE=(FESGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFHY=(HYSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFCA=(CASGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFMG=(GMSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNA=(ANSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFKA=(AKSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOH=(OHSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFSO=(SOSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFCL=(CLSXL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFC3=(C3SGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFHC=(HCSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
C
C     DIFFUSIVE FLUXES BETWEEN CURRENT AND ADJACENT GRID CELL
C     MICROPORES
C
      DFVAL=DIFAL*(CAL1-CAL2)
      DFVFE=DIFFE*(CFE1-CFE2)
      DFVHY=DIFHY*(CHY1-CHY2)
      DFVCA=DIFCA*(CCA1-CCA2)
      DFVMG=DIFMG*(CMG1-CMG2)
      DFVNA=DIFNA*(CNA1-CNA2)
      DFVKA=DIFKA*(CKA1-CKA2)
      DFVOH=DIFOH*(COH1-COH2)
      DFVSO=DIFSO*(CSO41-CSO42)
      DFVCL=DIFCL*(CCL1-CCL2)
      DFVC3=DIFC3*(CCO31-CCO32)
      DFVHC=DIFHC*(CHCO31-CHCO32)
      DFVAL1=DIFAL*(CAL11-CAL12)
      DFVAL2=DIFAL*(CAL21-CAL22)
      DFVAL3=DIFAL*(CAL31-CAL32)
      DFVAL4=DIFAL*(CAL41-CAL42)
      DFVALS=DIFAL*(CALS1-CALS2)
      DFVFE1=DIFFE*(CFE11-CFE12)
      DFVFE2=DIFFE*(CFE21-CFE22)
      DFVFE3=DIFFE*(CFE31-CFE32)
      DFVFE4=DIFFE*(CFE41-CFE42)
      DFVFES=DIFFE*(CFES1-CFES2)
      DFVCAO=DIFCA*(CCAO1-CCAO2)
      DFVCAC=DIFCA*(CCAC1-CCAC2)
      DFVCAH=DIFCA*(CCAH1-CCAH2)
      DFVCAS=DIFCA*(CCAS1-CCAS2)
      DFVMGO=DIFMG*(CMGO1-CMGO2)
      DFVMGC=DIFMG*(CMGC1-CMGC2)
      DFVMGH=DIFMG*(CMGH1-CMGH2)
      DFVMGS=DIFMG*(CMGS1-CMGS2)
      DFVNAC=DIFNA*(CNAC1-CNAC2)
      DFVNAS=DIFNA*(CNAS1-CNAS2)
      DFVKAS=DIFKA*(CKAS1-CKAS2)
      DFVH0P=DIFPO*(C0PO41-C0PO42)*VLPO4(N6,N5,N4)
      DFVH3P=DIFPO*(C3PO41-C3PO42)*VLPO4(N6,N5,N4)
      DFVF1P=DIFPO*(CFE1P1-CFE1P2)*VLPO4(N6,N5,N4)
      DFVF2P=DIFPO*(CFE2P1-CFE2P2)*VLPO4(N6,N5,N4)
      DFVC0P=DIFPO*(CCA0P1-CCA0P2)*VLPO4(N6,N5,N4)
      DFVC1P=DIFPO*(CCA1P1-CCA1P2)*VLPO4(N6,N5,N4)
      DFVC2P=DIFPO*(CCA2P1-CCA2P2)*VLPO4(N6,N5,N4)
      DFVM1P=DIFPO*(CMG1P1-CMG1P2)*VLPO4(N6,N5,N4)
      DFVH0B=DIFPO*(C0POB1-C0POB2)*VLPOB(N6,N5,N4)
      DFVH3B=DIFPO*(C3POB1-C3POB2)*VLPOB(N6,N5,N4)
      DFVF1B=DIFPO*(CF1PB1-CF1PB2)*VLPOB(N6,N5,N4)
      DFVF2B=DIFPO*(CF2PB1-CF2PB2)*VLPOB(N6,N5,N4)
      DFVC0B=DIFPO*(CC0PB1-CC0PB2)*VLPOB(N6,N5,N4)
      DFVC1B=DIFPO*(CC1PB1-CC1PB2)*VLPOB(N6,N5,N4)
      DFVC2B=DIFPO*(CC2PB1-CC2PB2)*VLPOB(N6,N5,N4)
      DFVM1B=DIFPO*(CM1PB1-CM1PB2)*VLPOB(N6,N5,N4)
      ELSE
      DFVAL=0.0
      DFVFE=0.0
      DFVHY=0.0
      DFVCA=0.0
      DFVMG=0.0
      DFVNA=0.0
      DFVKA=0.0
      DFVOH=0.0
      DFVSO=0.0
      DFVCL=0.0
      DFVC3=0.0
      DFVHC=0.0
      DFVAL1=0.0
      DFVAL2=0.0
      DFVAL3=0.0
      DFVAL4=0.0
      DFVALS=0.0
      DFVFE1=0.0
      DFVFE2=0.0
      DFVFE3=0.0
      DFVFE4=0.0
      DFVFES=0.0
      DFVCAO=0.0
      DFVCAC=0.0
      DFVCAH=0.0
      DFVCAS=0.0
      DFVMGO=0.0
      DFVMGC=0.0
      DFVMGH=0.0
      DFVMGS=0.0
      DFVNAC=0.0
      DFVNAS=0.0
      DFVKAS=0.0
      DFVH0P=0.0
      DFVH3P=0.0
      DFVF1P=0.0
      DFVF2P=0.0
      DFVC0P=0.0
      DFVC1P=0.0
      DFVC2P=0.0
      DFVM1P=0.0
      DFVH0B=0.0
      DFVH3B=0.0
      DFVF1B=0.0
      DFVF2B=0.0
      DFVC0B=0.0
      DFVC1B=0.0
      DFVC2B=0.0
      DFVM1B=0.0
      ENDIF
C
C     SOLUTE TRANSPORT IN MACROPORES
C
C     FLWHM=water flux through soil macropore from watsub.f 
C
      IF(FLWHM(M,N,N6,N5,N4).GT.0.0)THEN
C
C     IF MACROPORE WATER FLUX FROM 'WATSUB' IS FROM CURRENT TO
C     ADJACENT GRID CELL THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MACROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN CURRENT GRID CELL
C
C     VOLWHM=macropore water-filled porosity from watsub.f
C     VOLWAH=macropore porosity
C     RFH*=solute diffusive flux through macropore
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     *SH2,*BH2=macropore solute content in non-band,band
C     R*FXS=convective + diffusive solute flux between macropores and micropores
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C
      IF(VOLWHM(M,N3,N2,N1).GT.ZEROS2(N2,N1))THEN
      VFLW=AMAX1(0.0,AMIN1(VFLWX,FLWHM(M,N,N6,N5,N4)
     2/VOLWHM(M,N3,N2,N1)))
      ELSE
      VFLW=VFLWX
      ENDIF
C
C     ACCOUNT FOR MACROPORE-MICROPORE EXCHANGE IN VERTICAL FLUX
C
      IF(N.EQ.3.AND.VOLAH(N6,N5,N4).GT.VOLWHM(M,N6,N5,N4))THEN
      RFHAL=VFLW*AMAX1(0.0,(ZALH2(N3,N2,N1)
     2-AMIN1(0.0,RALFXS(NU(N2,N1),N2,N1))))
      RFHFE=VFLW*AMAX1(0.0,(ZFEH2(N3,N2,N1)
     2-AMIN1(0.0,RFEFXS(NU(N2,N1),N2,N1))))
      RFHHY=VFLW*AMAX1(0.0,(ZHYH2(N3,N2,N1)
     2-AMIN1(0.0,RHYFXS(NU(N2,N1),N2,N1))))
      RFHCA=VFLW*AMAX1(0.0,(ZCCH2(N3,N2,N1)
     2-AMIN1(0.0,RCAFXS(NU(N2,N1),N2,N1))))
      RFHMG=VFLW*AMAX1(0.0,(ZMAH2(N3,N2,N1)
     2-AMIN1(0.0,RMGFXS(NU(N2,N1),N2,N1))))
      RFHNA=VFLW*AMAX1(0.0,(ZNAH2(N3,N2,N1)
     2-AMIN1(0.0,RNAFXS(NU(N2,N1),N2,N1))))
      RFHKA=VFLW*AMAX1(0.0,(ZKAH2(N3,N2,N1)
     2-AMIN1(0.0,RKAFXS(NU(N2,N1),N2,N1))))
      RFHOH=VFLW*AMAX1(0.0,(ZOHH2(N3,N2,N1)
     2-AMIN1(0.0,ROHFXS(NU(N2,N1),N2,N1))))
      RFHSO=VFLW*AMAX1(0.0,(ZSO4H2(N3,N2,N1)
     2-AMIN1(0.0,RSOFXS(NU(N2,N1),N2,N1))))
      RFHCL=VFLW*AMAX1(0.0,(ZCLH2(N3,N2,N1)
     2-AMIN1(0.0,RCLFXS(NU(N2,N1),N2,N1))))
      RFHC3=VFLW*AMAX1(0.0,(ZCO3H2(N3,N2,N1)
     2-AMIN1(0.0,RC3FXS(NU(N2,N1),N2,N1))))
      RFHHC=VFLW*AMAX1(0.0,(ZHCOH2(N3,N2,N1)
     2-AMIN1(0.0,RHCFXS(NU(N2,N1),N2,N1))))
      RFHAL1=VFLW*AMAX1(0.0,(ZAL1H2(N3,N2,N1)
     2-AMIN1(0.0,RAL1XS(NU(N2,N1),N2,N1))))
      RFHAL2=VFLW*AMAX1(0.0,(ZAL2H2(N3,N2,N1)
     2-AMIN1(0.0,RAL2XS(NU(N2,N1),N2,N1))))
      RFHAL3=VFLW*AMAX1(0.0,(ZAL3H2(N3,N2,N1)
     2-AMIN1(0.0,RAL3XS(NU(N2,N1),N2,N1))))
      RFHAL4=VFLW*AMAX1(0.0,(ZAL4H2(N3,N2,N1)
     2-AMIN1(0.0,RAL4XS(NU(N2,N1),N2,N1))))
      RFHALS=VFLW*AMAX1(0.0,(ZALSH2(N3,N2,N1)
     2-AMIN1(0.0,RALSXS(NU(N2,N1),N2,N1))))
      RFHFE1=VFLW*AMAX1(0.0,(ZFE1H2(N3,N2,N1)
     2-AMIN1(0.0,RFE1XS(NU(N2,N1),N2,N1))))
      RFHFE2=VFLW*AMAX1(0.0,(ZFE2H2(N3,N2,N1)
     2-AMIN1(0.0,RFE2XS(NU(N2,N1),N2,N1))))
      RFHFE3=VFLW*AMAX1(0.0,(ZFE3H2(N3,N2,N1)
     2-AMIN1(0.0,RFE3XS(NU(N2,N1),N2,N1))))
      RFHFE4=VFLW*AMAX1(0.0,(ZFE4H2(N3,N2,N1)
     2-AMIN1(0.0,RFE4XS(NU(N2,N1),N2,N1))))
      RFHFES=VFLW*AMAX1(0.0,(ZFESH2(N3,N2,N1)
     2-AMIN1(0.0,RFESXS(NU(N2,N1),N2,N1))))
      RFHCAO=VFLW*AMAX1(0.0,(ZCAOH2(N3,N2,N1)
     2-AMIN1(0.0,RCAOXS(NU(N2,N1),N2,N1))))
      RFHCAC=VFLW*AMAX1(0.0,(ZCACH2(N3,N2,N1)
     2-AMIN1(0.0,RCACXS(NU(N2,N1),N2,N1))))
      RFHCAH=VFLW*AMAX1(0.0,(ZCAHH2(N3,N2,N1)
     2-AMIN1(0.0,RCAHXS(NU(N2,N1),N2,N1))))
      RFHCAS=VFLW*AMAX1(0.0,(ZCASH2(N3,N2,N1)
     2-AMIN1(0.0,RCASXS(NU(N2,N1),N2,N1))))
      RFHMGO=VFLW*AMAX1(0.0,(ZMGOH2(N3,N2,N1)
     2-AMIN1(0.0,RMGOXS(NU(N2,N1),N2,N1))))
      RFHMGC=VFLW*AMAX1(0.0,(ZMGCH2(N3,N2,N1)
     2-AMIN1(0.0,RMGCXS(NU(N2,N1),N2,N1))))
      RFHMGH=VFLW*AMAX1(0.0,(ZMGHH2(N3,N2,N1)
     2-AMIN1(0.0,RMGHXS(NU(N2,N1),N2,N1))))
      RFHMGS=VFLW*AMAX1(0.0,(ZMGSH2(N3,N2,N1)
     2-AMIN1(0.0,RMGSXS(NU(N2,N1),N2,N1))))
      RFHNAC=VFLW*AMAX1(0.0,(ZNACH2(N3,N2,N1)
     2-AMIN1(0.0,RNACXS(NU(N2,N1),N2,N1))))
      RFHNAS=VFLW*AMAX1(0.0,(ZNASH2(N3,N2,N1)
     2-AMIN1(0.0,RNASXS(NU(N2,N1),N2,N1))))
      RFHKAS=VFLW*AMAX1(0.0,(ZKASH2(N3,N2,N1)
     2-AMIN1(0.0,RKASXS(NU(N2,N1),N2,N1))))
      RFHH0P=VFLW*AMAX1(0.0,(H0P4H2(N3,N2,N1)
     2-AMIN1(0.0,RH0PXS(NU(N2,N1),N2,N1))))*VLPO4(N3,N2,N1)
      RFHH3P=VFLW*AMAX1(0.0,(H3P4H2(N3,N2,N1)
     2-AMIN1(0.0,RH3PXS(NU(N2,N1),N2,N1))))*VLPO4(N3,N2,N1)
      RFHF1P=VFLW*AMAX1(0.0,(ZF1PH2(N3,N2,N1)
     2-AMIN1(0.0,RF1PXS(NU(N2,N1),N2,N1))))*VLPO4(N3,N2,N1)
      RFHF2P=VFLW*AMAX1(0.0,(ZF2PH2(N3,N2,N1)
     2-AMIN1(0.0,RF2PXS(NU(N2,N1),N2,N1))))*VLPO4(N3,N2,N1)
      RFHC0P=VFLW*AMAX1(0.0,(ZC0PH2(N3,N2,N1)
     2-AMIN1(0.0,RC0PXS(NU(N2,N1),N2,N1))))*VLPO4(N3,N2,N1)
      RFHC1P=VFLW*AMAX1(0.0,(ZC1PH2(N3,N2,N1)
     2-AMIN1(0.0,RC1PXS(NU(N2,N1),N2,N1))))*VLPO4(N3,N2,N1)
      RFHC2P=VFLW*AMAX1(0.0,(ZC2PH2(N3,N2,N1)
     2-AMIN1(0.0,RC2PXS(NU(N2,N1),N2,N1))))*VLPO4(N3,N2,N1)
      RFHM1P=VFLW*AMAX1(0.0,(ZM1PH2(N3,N2,N1)
     2-AMIN1(0.0,RM1PXS(NU(N2,N1),N2,N1))))*VLPO4(N3,N2,N1)
      RFHH0B=VFLW*AMAX1(0.0,(H0PBH2(N3,N2,N1)
     2-AMIN1(0.0,RH0BXB(NU(N2,N1),N2,N1))))*VLPOB(N3,N2,N1)
      RFHH3B=VFLW*AMAX1(0.0,(H3PBH2(N3,N2,N1)
     2-AMIN1(0.0,RH3BXB(NU(N2,N1),N2,N1))))*VLPOB(N3,N2,N1)
      RFHF1B=VFLW*AMAX1(0.0,(ZF1BH2(N3,N2,N1)
     2-AMIN1(0.0,RF1BXB(NU(N2,N1),N2,N1))))*VLPOB(N3,N2,N1)
      RFHF2B=VFLW*AMAX1(0.0,(ZF2BH2(N3,N2,N1)
     2-AMIN1(0.0,RF2BXB(NU(N2,N1),N2,N1))))*VLPOB(N3,N2,N1)
      RFHC0B=VFLW*AMAX1(0.0,(ZC0BH2(N3,N2,N1)
     2-AMIN1(0.0,RC0BXB(NU(N2,N1),N2,N1))))*VLPOB(N3,N2,N1)
      RFHC1B=VFLW*AMAX1(0.0,(ZC1BH2(N3,N2,N1)
     2-AMIN1(0.0,RC1BXB(NU(N2,N1),N2,N1))))*VLPOB(N3,N2,N1)
      RFHC2B=VFLW*AMAX1(0.0,(ZC2BH2(N3,N2,N1)
     2-AMIN1(0.0,RC2BXB(NU(N2,N1),N2,N1))))*VLPOB(N3,N2,N1)
      RFHM1B=VFLW*AMAX1(0.0,(ZM1BH2(N3,N2,N1)
     2-AMIN1(0.0,RM1BXB(NU(N2,N1),N2,N1))))*VLPOB(N3,N2,N1)
C
C     OTHERWISE
C
      ELSE
      RFHAL=VFLW*AMAX1(0.0,ZALH2(N3,N2,N1))
      RFHFE=VFLW*AMAX1(0.0,ZFEH2(N3,N2,N1))
      RFHHY=VFLW*AMAX1(0.0,ZHYH2(N3,N2,N1))
      RFHCA=VFLW*AMAX1(0.0,ZCCH2(N3,N2,N1))
      RFHMG=VFLW*AMAX1(0.0,ZMAH2(N3,N2,N1))
      RFHNA=VFLW*AMAX1(0.0,ZNAH2(N3,N2,N1))
      RFHKA=VFLW*AMAX1(0.0,ZKAH2(N3,N2,N1))
      RFHOH=VFLW*AMAX1(0.0,ZOHH2(N3,N2,N1))
      RFHSO=VFLW*AMAX1(0.0,ZSO4H2(N3,N2,N1))
      RFHCL=VFLW*AMAX1(0.0,ZCLH2(N3,N2,N1))
      RFHC3=VFLW*AMAX1(0.0,ZCO3H2(N3,N2,N1))
      RFHHC=VFLW*AMAX1(0.0,ZHCOH2(N3,N2,N1))
      RFHAL1=VFLW*AMAX1(0.0,ZAL1H2(N3,N2,N1))
      RFHAL2=VFLW*AMAX1(0.0,ZAL2H2(N3,N2,N1))
      RFHAL3=VFLW*AMAX1(0.0,ZAL3H2(N3,N2,N1))
      RFHAL4=VFLW*AMAX1(0.0,ZAL4H2(N3,N2,N1))
      RFHALS=VFLW*AMAX1(0.0,ZALSH2(N3,N2,N1))
      RFHFE1=VFLW*AMAX1(0.0,ZFE1H2(N3,N2,N1))
      RFHFE2=VFLW*AMAX1(0.0,ZFE2H2(N3,N2,N1))
      RFHFE3=VFLW*AMAX1(0.0,ZFE3H2(N3,N2,N1))
      RFHFE4=VFLW*AMAX1(0.0,ZFE4H2(N3,N2,N1))
      RFHFES=VFLW*AMAX1(0.0,ZFESH2(N3,N2,N1))
      RFHCAO=VFLW*AMAX1(0.0,ZCAOH2(N3,N2,N1))
      RFHCAC=VFLW*AMAX1(0.0,ZCACH2(N3,N2,N1))
      RFHCAH=VFLW*AMAX1(0.0,ZCAHH2(N3,N2,N1))
      RFHCAS=VFLW*AMAX1(0.0,ZCASH2(N3,N2,N1))
      RFHMGO=VFLW*AMAX1(0.0,ZMGOH2(N3,N2,N1))
      RFHMGC=VFLW*AMAX1(0.0,ZMGCH2(N3,N2,N1))
      RFHMGH=VFLW*AMAX1(0.0,ZMGHH2(N3,N2,N1))
      RFHMGS=VFLW*AMAX1(0.0,ZMGSH2(N3,N2,N1))
      RFHNAC=VFLW*AMAX1(0.0,ZNACH2(N3,N2,N1))
      RFHNAS=VFLW*AMAX1(0.0,ZNASH2(N3,N2,N1))
      RFHKAS=VFLW*AMAX1(0.0,ZKASH2(N3,N2,N1))
      RFHH0P=VFLW*AMAX1(0.0,H0P4H2(N3,N2,N1))*VLPO4(N6,N5,N4)
      RFHH3P=VFLW*AMAX1(0.0,H3P4H2(N3,N2,N1))*VLPO4(N6,N5,N4)
      RFHF1P=VFLW*AMAX1(0.0,ZF1PH2(N3,N2,N1))*VLPO4(N6,N5,N4)
      RFHF2P=VFLW*AMAX1(0.0,ZF2PH2(N3,N2,N1))*VLPO4(N6,N5,N4)
      RFHC0P=VFLW*AMAX1(0.0,ZC0PH2(N3,N2,N1))*VLPO4(N6,N5,N4)
      RFHC1P=VFLW*AMAX1(0.0,ZC1PH2(N3,N2,N1))*VLPO4(N6,N5,N4)
      RFHC2P=VFLW*AMAX1(0.0,ZC2PH2(N3,N2,N1))*VLPO4(N6,N5,N4)
      RFHM1P=VFLW*AMAX1(0.0,ZM1PH2(N3,N2,N1))*VLPO4(N6,N5,N4)
      RFHH0B=VFLW*AMAX1(0.0,H0PBH2(N3,N2,N1))*VLPOB(N6,N5,N4)
      RFHH3B=VFLW*AMAX1(0.0,H3PBH2(N3,N2,N1))*VLPOB(N6,N5,N4)
      RFHF1B=VFLW*AMAX1(0.0,ZF1BH2(N3,N2,N1))*VLPOB(N6,N5,N4)
      RFHF2B=VFLW*AMAX1(0.0,ZF2BH2(N3,N2,N1))*VLPOB(N6,N5,N4)
      RFHC0B=VFLW*AMAX1(0.0,ZC0BH2(N3,N2,N1))*VLPOB(N6,N5,N4)
      RFHC1B=VFLW*AMAX1(0.0,ZC1BH2(N3,N2,N1))*VLPOB(N6,N5,N4)
      RFHC2B=VFLW*AMAX1(0.0,ZC2BH2(N3,N2,N1))*VLPOB(N6,N5,N4)
      RFHM1B=VFLW*AMAX1(0.0,ZM1BH2(N3,N2,N1))*VLPOB(N6,N5,N4)
      ENDIF
      ELSEIF(FLWHM(M,N,N6,N5,N4).LT.0.0)THEN
C
C     IF MACROPORE WATER FLUX FROM 'WATSUB' IS FROM ADJACENT TO
C     CURRENT GRID CELL THEN CONVECTIVE TRANSPORT IS THE PRODUCT
C     OF WATER FLUX AND MACROPORE GAS OR SOLUTE CONCENTRATIONS
C     IN ADJACENT GRID CELL
C
      IF(VOLWHM(M,N6,N5,N4).GT.ZEROS2(N5,N4))THEN
      VFLW=AMIN1(0.0,AMAX1(-VFLWX,FLWHM(M,N,N6,N5,N4)
     2/VOLWHM(M,N6,N5,N4)))
      ELSE
      VFLW=-VFLWX
      ENDIF
      RFHAL=VFLW*AMAX1(0.0,ZALH2(N6,N5,N4))
      RFHFE=VFLW*AMAX1(0.0,ZFEH2(N6,N5,N4))
      RFHHY=VFLW*AMAX1(0.0,ZHYH2(N6,N5,N4))
      RFHCA=VFLW*AMAX1(0.0,ZCCH2(N6,N5,N4))
      RFHMG=VFLW*AMAX1(0.0,ZMAH2(N6,N5,N4))
      RFHNA=VFLW*AMAX1(0.0,ZNAH2(N6,N5,N4))
      RFHKA=VFLW*AMAX1(0.0,ZKAH2(N6,N5,N4))
      RFHOH=VFLW*AMAX1(0.0,ZOHH2(N6,N5,N4))
      RFHSO=VFLW*AMAX1(0.0,ZSO4H2(N6,N5,N4))
      RFHCL=VFLW*AMAX1(0.0,ZCLH2(N6,N5,N4))
      RFHC3=VFLW*AMAX1(0.0,ZCO3H2(N6,N5,N4))
      RFHHC=VFLW*AMAX1(0.0,ZHCOH2(N6,N5,N4))
      RFHAL1=VFLW*AMAX1(0.0,ZAL1H2(N6,N5,N4))
      RFHAL2=VFLW*AMAX1(0.0,ZAL2H2(N6,N5,N4))
      RFHAL3=VFLW*AMAX1(0.0,ZAL3H2(N6,N5,N4))
      RFHAL4=VFLW*AMAX1(0.0,ZAL4H2(N6,N5,N4))
      RFHALS=VFLW*AMAX1(0.0,ZALSH2(N6,N5,N4))
      RFHFE1=VFLW*AMAX1(0.0,ZFE1H2(N6,N5,N4))
      RFHFE2=VFLW*AMAX1(0.0,ZFE2H2(N6,N5,N4))
      RFHFE3=VFLW*AMAX1(0.0,ZFE3H2(N6,N5,N4))
      RFHFE4=VFLW*AMAX1(0.0,ZFE4H2(N6,N5,N4))
      RFHFES=VFLW*AMAX1(0.0,ZFESH2(N6,N5,N4))
      RFHCAO=VFLW*AMAX1(0.0,ZCAOH2(N6,N5,N4))
      RFHCAC=VFLW*AMAX1(0.0,ZCACH2(N6,N5,N4))
      RFHCAH=VFLW*AMAX1(0.0,ZCAHH2(N6,N5,N4))
      RFHCAS=VFLW*AMAX1(0.0,ZCASH2(N6,N5,N4))
      RFHMGO=VFLW*AMAX1(0.0,ZMGOH2(N6,N5,N4))
      RFHMGC=VFLW*AMAX1(0.0,ZMGCH2(N6,N5,N4))
      RFHMGH=VFLW*AMAX1(0.0,ZMGHH2(N6,N5,N4))
      RFHMGS=VFLW*AMAX1(0.0,ZMGSH2(N6,N5,N4))
      RFHNAC=VFLW*AMAX1(0.0,ZNACH2(N6,N5,N4))
      RFHNAS=VFLW*AMAX1(0.0,ZNASH2(N6,N5,N4))
      RFHKAS=VFLW*AMAX1(0.0,ZKASH2(N6,N5,N4))
      RFHH0P=VFLW*AMAX1(0.0,H0P4H2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFHH3P=VFLW*AMAX1(0.0,H3P4H2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFHF1P=VFLW*AMAX1(0.0,ZF1PH2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFHF2P=VFLW*AMAX1(0.0,ZF2PH2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFHC0P=VFLW*AMAX1(0.0,ZC0PH2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFHC1P=VFLW*AMAX1(0.0,ZC1PH2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFHC2P=VFLW*AMAX1(0.0,ZC2PH2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFHM1P=VFLW*AMAX1(0.0,ZM1PH2(N6,N5,N4))*VLPO4(N6,N5,N4)
      RFHH0B=VFLW*AMAX1(0.0,H0PBH2(N6,N5,N4))*VLPOB(N6,N5,N4)
      RFHH3B=VFLW*AMAX1(0.0,H3PBH2(N6,N5,N4))*VLPOB(N6,N5,N4)
      RFHF1B=VFLW*AMAX1(0.0,ZF1BH2(N6,N5,N4))*VLPOB(N6,N5,N4)
      RFHF2B=VFLW*AMAX1(0.0,ZF2BH2(N6,N5,N4))*VLPOB(N6,N5,N4)
      RFHC0B=VFLW*AMAX1(0.0,ZC0BH2(N6,N5,N4))*VLPOB(N6,N5,N4)
      RFHC1B=VFLW*AMAX1(0.0,ZC1BH2(N6,N5,N4))*VLPOB(N6,N5,N4)
      RFHC2B=VFLW*AMAX1(0.0,ZC2BH2(N6,N5,N4))*VLPOB(N6,N5,N4)
      RFHM1B=VFLW*AMAX1(0.0,ZM1BH2(N6,N5,N4))*VLPOB(N6,N5,N4)
C
C     NO MACROPORE FLUX
C
      ELSE
      RFHAL=0.0
      RFHFE=0.0
      RFHHY=0.0
      RFHCA=0.0
      RFHMG=0.0
      RFHNA=0.0
      RFHKA=0.0
      RFHOH=0.0
      RFHSO=0.0
      RFHCL=0.0
      RFHC3=0.0
      RFHHC=0.0
      RFHAL1=0.0
      RFHAL2=0.0
      RFHAL3=0.0
      RFHAL4=0.0
      RFHALS=0.0
      RFHFE1=0.0
      RFHFE2=0.0
      RFHFE3=0.0
      RFHFE4=0.0
      RFHFES=0.0
      RFHCAO=0.0
      RFHCAC=0.0
      RFHCAH=0.0
      RFHCAS=0.0
      RFHMGO=0.0
      RFHMGC=0.0
      RFHMGH=0.0
      RFHMGS=0.0
      RFHNAC=0.0
      RFHNAS=0.0
      RFHKAS=0.0
      RFHH0P=0.0
      RFHH3P=0.0
      RFHF1P=0.0
      RFHF2P=0.0
      RFHC0P=0.0
      RFHC1P=0.0
      RFHC2P=0.0
      RFHM1P=0.0
      RFHH0B=0.0
      RFHH3B=0.0
      RFHF1B=0.0
      RFHF2B=0.0
      RFHC0B=0.0
      RFHC1B=0.0
      RFHC2B=0.0
      RFHM1B=0.0
      ENDIF
C
C     DIFFUSIVE FLUXES OF GASES AND SOLUTES BETWEEN CURRENT AND
C     ADJACENT GRID CELL MACROPORES FROM AQUEOUS DIFFUSIVITIES
C     AND CONCENTRATION DIFFERENCES
C
C     VOLWHM=macropore water-filled porosity from watsub.f
C     THETY=hygroscopic water content
C     VOLAH=total macropore volume
C
      IF(VOLWHM(M,N3,N2,N1).GT.THETY(N3,N2,N1)*VOLAH(N3,N2,N1)
     2.AND.VOLWHM(M,N6,N5,N4).GT.THETY(N6,N5,N4)*VOLAH(N6,N5,N4))THEN
C
C     MACROPORE CONCENTRATIONS IN CURRENT AND ADJACENT GRID CELLS
C
C     C*H1,C*H2=macropore solute concentration in source,destination layer 
C     *H2=macropore solute content
C     VOLWHM=macropore water content 
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      CAL1=AMAX1(0.0,ZALH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CFE1=AMAX1(0.0,ZFEH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CHY1=AMAX1(0.0,ZHYH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CCA1=AMAX1(0.0,ZCCH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CMG1=AMAX1(0.0,ZMAH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CNA1=AMAX1(0.0,ZNAH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CKA1=AMAX1(0.0,ZKAH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      COH1=AMAX1(0.0,ZOHH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CSO41=AMAX1(0.0,ZSO4H2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CCL1=AMAX1(0.0,ZCLH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CCO31=AMAX1(0.0,ZCO3H2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CHCO31=AMAX1(0.0,ZHCOH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CAL11=AMAX1(0.0,ZAL1H2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CAL21=AMAX1(0.0,ZAL2H2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CAL31=AMAX1(0.0,ZAL3H2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CAL41=AMAX1(0.0,ZAL4H2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CALS1=AMAX1(0.0,ZALSH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CFE11=AMAX1(0.0,ZFE1H2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CFE21=AMAX1(0.0,ZFE2H2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CFE31=AMAX1(0.0,ZFE3H2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CFE41=AMAX1(0.0,ZFE4H2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CFES1=AMAX1(0.0,ZFESH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CCAO1=AMAX1(0.0,ZCAOH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CCAC1=AMAX1(0.0,ZCACH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CCAH1=AMAX1(0.0,ZCAHH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CCAS1=AMAX1(0.0,ZCASH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CMGO1=AMAX1(0.0,ZMGOH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CMGC1=AMAX1(0.0,ZMGCH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CMGH1=AMAX1(0.0,ZMGHH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CMGS1=AMAX1(0.0,ZMGSH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CNAC1=AMAX1(0.0,ZNACH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CNAS1=AMAX1(0.0,ZNASH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CKAS1=AMAX1(0.0,ZKASH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      C0PO41=AMAX1(0.0,H0P4H2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      C3PO41=AMAX1(0.0,H3P4H2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CFE1P1=AMAX1(0.0,ZF1PH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CFE2P1=AMAX1(0.0,ZF2PH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CCA0P1=AMAX1(0.0,ZC0PH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CCA1P1=AMAX1(0.0,ZC1PH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CCA2P1=AMAX1(0.0,ZC2PH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CMG1P1=AMAX1(0.0,ZM1PH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      C0POB1=AMAX1(0.0,H0PBH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      C3POB1=AMAX1(0.0,H3PBH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CF1PB1=AMAX1(0.0,ZF1BH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CF2PB1=AMAX1(0.0,ZF2BH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CC0PB1=AMAX1(0.0,ZC0BH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CC1PB1=AMAX1(0.0,ZC1BH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CC2PB1=AMAX1(0.0,ZC2BH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CM1PB1=AMAX1(0.0,ZM1BH2(N3,N2,N1)/VOLWHM(M,N3,N2,N1))
      CAL2=AMAX1(0.0,ZALH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CFE2=AMAX1(0.0,ZFEH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CHY2=AMAX1(0.0,ZHYH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CCA2=AMAX1(0.0,ZCCH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CMG2=AMAX1(0.0,ZMAH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CNA2=AMAX1(0.0,ZNAH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CKA2=AMAX1(0.0,ZKAH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      COH2=AMAX1(0.0,ZOHH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CSO42=AMAX1(0.0,ZSO4H2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CCL2=AMAX1(0.0,ZCLH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CCO32=AMAX1(0.0,ZCO3H2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CHCO32=AMAX1(0.0,ZHCOH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CAL12=AMAX1(0.0,ZAL1H2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CAL22=AMAX1(0.0,ZAL2H2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CAL32=AMAX1(0.0,ZAL3H2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CAL42=AMAX1(0.0,ZAL4H2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CALS2=AMAX1(0.0,ZALSH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CFE12=AMAX1(0.0,ZFE1H2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CFE22=AMAX1(0.0,ZFE2H2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CFE32=AMAX1(0.0,ZFE3H2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CFE42=AMAX1(0.0,ZFE4H2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CFES2=AMAX1(0.0,ZFESH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CCAO2=AMAX1(0.0,ZCAOH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CCAC2=AMAX1(0.0,ZCACH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CCAH2=AMAX1(0.0,ZCAHH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CCAS2=AMAX1(0.0,ZCASH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CMGO2=AMAX1(0.0,ZMGOH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CMGC2=AMAX1(0.0,ZMGCH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CMGH2=AMAX1(0.0,ZMGHH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CMGS2=AMAX1(0.0,ZMGSH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CNAC2=AMAX1(0.0,ZNACH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CNAS2=AMAX1(0.0,ZNASH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CKAS2=AMAX1(0.0,ZKASH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      C0PO42=AMAX1(0.0,H0P4H2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      C3PO42=AMAX1(0.0,H3P4H2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CFE1P2=AMAX1(0.0,ZF1PH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CFE2P2=AMAX1(0.0,ZF2PH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CCA0P2=AMAX1(0.0,ZC0PH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CCA1P2=AMAX1(0.0,ZC1PH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CCA2P2=AMAX1(0.0,ZC2PH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CMG1P2=AMAX1(0.0,ZM1PH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      C0POB2=AMAX1(0.0,H0PBH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      C3POB2=AMAX1(0.0,H3PBH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CF1PB2=AMAX1(0.0,ZF1BH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CF2PB2=AMAX1(0.0,ZF2BH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CC0PB2=AMAX1(0.0,ZC0BH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CC1PB2=AMAX1(0.0,ZC1BH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CC2PB2=AMAX1(0.0,ZC2BH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
      CM1PB2=AMAX1(0.0,ZM1BH2(N6,N5,N4)/VOLWHM(M,N6,N5,N4))
C
C     DIFFUSIVITIES IN CURRENT AND ADJACENT GRID CELL MACROPORES
C
C     DLYR=soil layer thickness
C     TORTH=macropore tortuosity from hour1.f 
C     DISP=dispersivity parameter
C     FLWHM=water flux through soil macropore from watsub.f 
C     DIF*=aqueous diffusivity-dispersivity through macropore
C     *SGL2=solute diffusivity from hour1.f
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     XDPTH=cross-sectional area/distance between layers
C     C*H1,C*H2=macropore solute concentration in source,destination layer
C     DFH*=diffusive solute transfer through soil macropore 
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C
      DLYR1=AMAX1(ZERO2,DLYR(N,N3,N2,N1))
      DLYR2=AMAX1(ZERO2,DLYR(N,N6,N5,N4))
      TORTL=(TORTH(M,N3,N2,N1)*DLYR1+TORTH(M,N6,N5,N4)*DLYR2)
     3/(DLYR1+DLYR2)
      DISPN=DISP(N,N6,N5,N4)
     2*AMIN1(VFLWX,ABS(FLWHM(M,N,N6,N5,N4)/AREA(N,N6,N5,N4)))
      DIFPO=(POSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFAL=(ALSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFFE=(FESGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFHY=(HYSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFCA=(CASGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFMG=(GMSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFNA=(ANSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFKA=(AKSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFOH=(OHSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFSO=(SOSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFCL=(CLSXL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFC3=(C3SGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
      DIFHC=(HCSGL2(N6,N5,N4)*TORTL+DISPN)*XDPTH(N,N6,N5,N4)
C
C     DIFFUSIVE FLUXES BETWEEN CURRENT AND ADJACENT GRID CELL
C     MACROPORES
C
      DFHAL=DIFAL*(CAL1-CAL2)
      DFHFE=DIFFE*(CFE1-CFE2)
      DFHHY=DIFHY*(CHY1-CHY2)
      DFHCA=DIFCA*(CCA1-CCA2)
      DFHMG=DIFMG*(CMG1-CMG2)
      DFHNA=DIFNA*(CNA1-CNA2)
      DFHKA=DIFKA*(CKA1-CKA2)
      DFHOH=DIFOH*(COH1-COH2)
      DFHSO=DIFSO*(CSO41-CSO42)
      DFHCL=DIFCL*(CCL1-CCL2)
      DFHC3=DIFC3*(CCO31-CCO32)
      DFHHC=DIFHC*(CHCO31-CHCO32)
      DFHAL1=DIFAL*(CAL11-CAL12)
      DFHAL2=DIFAL*(CAL21-CAL22)
      DFHAL3=DIFAL*(CAL31-CAL32)
      DFHAL4=DIFAL*(CAL41-CAL42)
      DFHALS=DIFAL*(CALS1-CALS2)
      DFHFE1=DIFFE*(CFE11-CFE12)
      DFHFE2=DIFFE*(CFE21-CFE22)
      DFHFE3=DIFFE*(CFE31-CFE32)
      DFHFE4=DIFFE*(CFE41-CFE42)
      DFHFES=DIFFE*(CFES1-CFES2)
      DFHCAO=DIFCA*(CCAO1-CCAO2)
      DFHCAC=DIFCA*(CCAC1-CCAC2)
      DFHCAH=DIFCA*(CCAH1-CCAH2)
      DFHCAS=DIFCA*(CCAS1-CCAS2)
      DFHMGO=DIFMG*(CMGO1-CMGO2)
      DFHMGC=DIFMG*(CMGC1-CMGC2)
      DFHMGH=DIFMG*(CMGH1-CMGH2)
      DFHMGS=DIFMG*(CMGS1-CMGS2)
      DFHNAC=DIFNA*(CNAC1-CNAC2)
      DFHNAS=DIFNA*(CNAS1-CNAS2)
      DFHKAS=DIFKA*(CKAS1-CKAS2)
      DFHH0P=DIFPO*(C0PO41-C0PO42)*VLPO4(N6,N5,N4)
      DFHH3P=DIFPO*(C3PO41-C3PO42)*VLPO4(N6,N5,N4)
      DFHF1P=DIFPO*(CFE1P1-CFE1P2)*VLPO4(N6,N5,N4)
      DFHF2P=DIFPO*(CFE2P1-CFE2P2)*VLPO4(N6,N5,N4)
      DFHC0P=DIFPO*(CCA0P1-CCA0P2)*VLPO4(N6,N5,N4)
      DFHC1P=DIFPO*(CCA1P1-CCA1P2)*VLPO4(N6,N5,N4)
      DFHC2P=DIFPO*(CCA2P1-CCA2P2)*VLPO4(N6,N5,N4)
      DFHM1P=DIFPO*(CMG1P1-CMG1P2)*VLPO4(N6,N5,N4)
      DFHH0B=DIFPO*(C0POB1-C0POB2)*VLPOB(N6,N5,N4)
      DFHH3B=DIFPO*(C3POB1-C3POB2)*VLPOB(N6,N5,N4)
      DFHF1B=DIFPO*(CF1PB1-CF1PB2)*VLPOB(N6,N5,N4)
      DFHF2B=DIFPO*(CF2PB1-CF2PB2)*VLPOB(N6,N5,N4)
      DFHC0B=DIFPO*(CC0PB1-CC0PB2)*VLPOB(N6,N5,N4)
      DFHC1B=DIFPO*(CC1PB1-CC1PB2)*VLPOB(N6,N5,N4)
      DFHC2B=DIFPO*(CC2PB1-CC2PB2)*VLPOB(N6,N5,N4)
      DFHM1B=DIFPO*(CM1PB1-CM1PB2)*VLPOB(N6,N5,N4)
      ELSE
      DFHAL=0.0
      DFHFE=0.0
      DFHHY=0.0
      DFHCA=0.0
      DFHMG=0.0
      DFHNA=0.0
      DFHKA=0.0
      DFHOH=0.0
      DFHSO=0.0
      DFHCL=0.0
      DFHC3=0.0
      DFHHC=0.0
      DFHAL1=0.0
      DFHAL2=0.0
      DFHAL3=0.0
      DFHAL4=0.0
      DFHALS=0.0
      DFHFE1=0.0
      DFHFE2=0.0
      DFHFE3=0.0
      DFHFE4=0.0
      DFHFES=0.0
      DFHCAO=0.0
      DFHCAC=0.0
      DFHCAH=0.0
      DFHCAS=0.0
      DFHMGO=0.0
      DFHMGC=0.0
      DFHMGH=0.0
      DFHMGS=0.0
      DFHNAC=0.0
      DFHNAS=0.0
      DFHKAS=0.0
      DFHH0P=0.0
      DFHH3P=0.0
      DFHF1P=0.0
      DFHF2P=0.0
      DFHC0P=0.0
      DFHC1P=0.0
      DFHC2P=0.0
      DFHM1P=0.0
      DFHH0B=0.0
      DFHH3B=0.0
      DFHF1B=0.0
      DFHF2B=0.0
      DFHC0B=0.0
      DFHC1B=0.0
      DFHC2B=0.0
      DFHM1B=0.0
      ENDIF
C
C     TOTAL MICROPORE AND MACROPORE SOLUTE TRANSPORT
C     FLUXES = CONVECTIVE + DIFFUSIVE FLUXES
C
C     R*FLS=convective + diffusive solute flux through micropores
C     R*FLW,R*FLB=convective + diffusive solute flux through micropores in non-band,band
C     R*FHS=convective + diffusive solute flux through macropores
C     R*FHW,R*FHB=convective + diffusive solute flux through macropores in non-band,band
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     RFL*=convective flux through micropores 
C     DFV*=diffusive solute flux through micropores
C     RFH*=convective flux through macropores 
C     DFH*=diffusive solute flux through macropores
C
      RALFLS(N,N6,N5,N4)=RFLAL+DFVAL
      RFEFLS(N,N6,N5,N4)=RFLFE+DFVFE
      RHYFLS(N,N6,N5,N4)=RFLHY+DFVHY
      RCAFLS(N,N6,N5,N4)=RFLCA+DFVCA
      RMGFLS(N,N6,N5,N4)=RFLMG+DFVMG
      RNAFLS(N,N6,N5,N4)=RFLNA+DFVNA
      RKAFLS(N,N6,N5,N4)=RFLKA+DFVKA
      ROHFLS(N,N6,N5,N4)=RFLOH+DFVOH
      RSOFLS(N,N6,N5,N4)=RFLSO+DFVSO
      RCLFLS(N,N6,N5,N4)=RFLCL+DFVCL
      RC3FLS(N,N6,N5,N4)=RFLC3+DFVC3
      RHCFLS(N,N6,N5,N4)=RFLHC+DFVHC
      RAL1FS(N,N6,N5,N4)=RFLAL1+DFVAL1
      RAL2FS(N,N6,N5,N4)=RFLAL2+DFVAL2
      RAL3FS(N,N6,N5,N4)=RFLAL3+DFVAL3
      RAL4FS(N,N6,N5,N4)=RFLAL4+DFVAL4
      RALSFS(N,N6,N5,N4)=RFLALS+DFVALS
      RFE1FS(N,N6,N5,N4)=RFLFE1+DFVFE1
      RFE2FS(N,N6,N5,N4)=RFLFE2+DFVFE2
      RFE3FS(N,N6,N5,N4)=RFLFE3+DFVFE3
      RFE4FS(N,N6,N5,N4)=RFLFE4+DFVFE4
      RFESFS(N,N6,N5,N4)=RFLFES+DFVFES
      RCAOFS(N,N6,N5,N4)=RFLCAO+DFVCAO
      RCACFS(N,N6,N5,N4)=RFLCAC+DFVCAC
      RCAHFS(N,N6,N5,N4)=RFLCAH+DFVCAH
      RCASFS(N,N6,N5,N4)=RFLCAS+DFVCAS
      RMGOFS(N,N6,N5,N4)=RFLMGO+DFVMGO
      RMGCFS(N,N6,N5,N4)=RFLMGC+DFVMGC
      RMGHFS(N,N6,N5,N4)=RFLMGH+DFVMGH
      RMGSFS(N,N6,N5,N4)=RFLMGS+DFVMGS
      RNACFS(N,N6,N5,N4)=RFLNAC+DFVNAC
      RNASFS(N,N6,N5,N4)=RFLNAS+DFVNAS
      RKASFS(N,N6,N5,N4)=RFLKAS+DFVKAS
      RH0PFS(N,N6,N5,N4)=RFLH0P+DFVH0P
      RH3PFS(N,N6,N5,N4)=RFLH3P+DFVH3P
      RF1PFS(N,N6,N5,N4)=RFLF1P+DFVF1P
      RF2PFS(N,N6,N5,N4)=RFLF2P+DFVF2P
      RC0PFS(N,N6,N5,N4)=RFLC0P+DFVC0P
      RC1PFS(N,N6,N5,N4)=RFLC1P+DFVC1P
      RC2PFS(N,N6,N5,N4)=RFLC2P+DFVC2P
      RM1PFS(N,N6,N5,N4)=RFLM1P+DFVM1P
      RH0BFB(N,N6,N5,N4)=RFLH0B+DFVH0B
      RH3BFB(N,N6,N5,N4)=RFLH3B+DFVH3B
      RF1BFB(N,N6,N5,N4)=RFLF1B+DFVF1B
      RF2BFB(N,N6,N5,N4)=RFLF2B+DFVF2B
      RC0BFB(N,N6,N5,N4)=RFLC0B+DFVC0B
      RC1BFB(N,N6,N5,N4)=RFLC1B+DFVC1B
      RC2BFB(N,N6,N5,N4)=RFLC2B+DFVC2B
      RM1BFB(N,N6,N5,N4)=RFLM1B+DFVM1B
      RALFHS(N,N6,N5,N4)=RFHAL+DFHAL
      RFEFHS(N,N6,N5,N4)=RFHFE+DFHFE
      RHYFHS(N,N6,N5,N4)=RFHHY+DFHHY
      RCAFHS(N,N6,N5,N4)=RFHCA+DFHCA
      RMGFHS(N,N6,N5,N4)=RFHMG+DFHMG
      RNAFHS(N,N6,N5,N4)=RFHNA+DFHNA
      RKAFHS(N,N6,N5,N4)=RFHKA+DFHKA
      ROHFHS(N,N6,N5,N4)=RFHOH+DFHOH
      RSOFHS(N,N6,N5,N4)=RFHSO+DFHSO
      RCLFHS(N,N6,N5,N4)=RFHCL+DFHCL
      RC3FHS(N,N6,N5,N4)=RFHC3+DFHC3
      RHCFHS(N,N6,N5,N4)=RFHHC+DFHHC
      RAL1HS(N,N6,N5,N4)=RFHAL1+DFHAL1
      RAL2HS(N,N6,N5,N4)=RFHAL2+DFHAL2
      RAL3HS(N,N6,N5,N4)=RFHAL3+DFHAL3
      RAL4HS(N,N6,N5,N4)=RFHAL4+DFHAL4
      RALSHS(N,N6,N5,N4)=RFHALS+DFHALS
      RFE1HS(N,N6,N5,N4)=RFHFE1+DFHFE1
      RFE2HS(N,N6,N5,N4)=RFHFE2+DFHFE2
      RFE3HS(N,N6,N5,N4)=RFHFE3+DFHFE3
      RFE4HS(N,N6,N5,N4)=RFHFE4+DFHFE4
      RFESHS(N,N6,N5,N4)=RFHFES+DFHFES
      RCAOHS(N,N6,N5,N4)=RFHCAO+DFHCAO
      RCACHS(N,N6,N5,N4)=RFHCAC+DFHCAC
      RCAHHS(N,N6,N5,N4)=RFHCAH+DFHCAH
      RCASHS(N,N6,N5,N4)=RFHCAS+DFHCAS
      RMGOHS(N,N6,N5,N4)=RFHMGO+DFHMGO
      RMGCHS(N,N6,N5,N4)=RFHMGC+DFHMGC
      RMGHHS(N,N6,N5,N4)=RFHMGH+DFHMGH
      RMGSHS(N,N6,N5,N4)=RFHMGS+DFHMGS
      RNACHS(N,N6,N5,N4)=RFHNAC+DFHNAC
      RNASHS(N,N6,N5,N4)=RFHNAS+DFHNAS
      RKASHS(N,N6,N5,N4)=RFHKAS+DFHKAS
      RH0PHS(N,N6,N5,N4)=RFHH0P+DFHH0P
      RH3PHS(N,N6,N5,N4)=RFHH3P+DFHH3P
      RF1PHS(N,N6,N5,N4)=RFHF1P+DFHF1P
      RF2PHS(N,N6,N5,N4)=RFHF2P+DFHF2P
      RC0PHS(N,N6,N5,N4)=RFHC0P+DFHC0P
      RC1PHS(N,N6,N5,N4)=RFHC1P+DFHC1P
      RC2PHS(N,N6,N5,N4)=RFHC2P+DFHC2P
      RM1PHS(N,N6,N5,N4)=RFHM1P+DFHM1P
      RH0BHB(N,N6,N5,N4)=RFHH0B+DFHH0B
      RH3BHB(N,N6,N5,N4)=RFHH3B+DFHH3B
      RF1BHB(N,N6,N5,N4)=RFHF1B+DFHF1B
      RF2BHB(N,N6,N5,N4)=RFHF2B+DFHF2B
      RC0BHB(N,N6,N5,N4)=RFHC0B+DFHC0B
      RC1BHB(N,N6,N5,N4)=RFHC1B+DFHC1B
      RC2BHB(N,N6,N5,N4)=RFHC2B+DFHC2B
      RM1BHB(N,N6,N5,N4)=RFHM1B+DFHM1B
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*FLS=hourly convective + diffusive solute flux through micropores
C     X*FLW,X*FLB= hourly convective + diffusive solute flux through micropores in non-band,band
C     X*FHS=hourly convective + diffusive solute flux through macropores
C     X*FHW,X*FHB= hourly convective + diffusive solute flux through macropores in non-band,band
C     R*FLS=convective + diffusive solute flux through micropores
C     R*FLW,X*FLB=convective + diffusive solute flux through micropores in non-band,band
C     R*FHS=convective + diffusive solute flux through macropores
C     R*FHW,X*FHB=convective + diffusive solute flux through macropores in non-band,band
C
      XALFLS(N,N6,N5,N4)=XALFLS(N,N6,N5,N4)+RALFLS(N,N6,N5,N4)
      XFEFLS(N,N6,N5,N4)=XFEFLS(N,N6,N5,N4)+RFEFLS(N,N6,N5,N4)
      XHYFLS(N,N6,N5,N4)=XHYFLS(N,N6,N5,N4)+RHYFLS(N,N6,N5,N4)
      XCAFLS(N,N6,N5,N4)=XCAFLS(N,N6,N5,N4)+RCAFLS(N,N6,N5,N4)
      XMGFLS(N,N6,N5,N4)=XMGFLS(N,N6,N5,N4)+RMGFLS(N,N6,N5,N4)
      XNAFLS(N,N6,N5,N4)=XNAFLS(N,N6,N5,N4)+RNAFLS(N,N6,N5,N4)
      XKAFLS(N,N6,N5,N4)=XKAFLS(N,N6,N5,N4)+RKAFLS(N,N6,N5,N4)
      XOHFLS(N,N6,N5,N4)=XOHFLS(N,N6,N5,N4)+ROHFLS(N,N6,N5,N4)
      XSOFLS(N,N6,N5,N4)=XSOFLS(N,N6,N5,N4)+RSOFLS(N,N6,N5,N4)
      XCLFLS(N,N6,N5,N4)=XCLFLS(N,N6,N5,N4)+RCLFLS(N,N6,N5,N4)
      XC3FLS(N,N6,N5,N4)=XC3FLS(N,N6,N5,N4)+RC3FLS(N,N6,N5,N4)
      XHCFLS(N,N6,N5,N4)=XHCFLS(N,N6,N5,N4)+RHCFLS(N,N6,N5,N4)
      XAL1FS(N,N6,N5,N4)=XAL1FS(N,N6,N5,N4)+RAL1FS(N,N6,N5,N4)
      XAL2FS(N,N6,N5,N4)=XAL2FS(N,N6,N5,N4)+RAL2FS(N,N6,N5,N4)
      XAL3FS(N,N6,N5,N4)=XAL3FS(N,N6,N5,N4)+RAL3FS(N,N6,N5,N4)
      XAL4FS(N,N6,N5,N4)=XAL4FS(N,N6,N5,N4)+RAL4FS(N,N6,N5,N4)
      XALSFS(N,N6,N5,N4)=XALSFS(N,N6,N5,N4)+RALSFS(N,N6,N5,N4)
      XFE1FS(N,N6,N5,N4)=XFE1FS(N,N6,N5,N4)+RFE1FS(N,N6,N5,N4)
      XFE2FS(N,N6,N5,N4)=XFE2FS(N,N6,N5,N4)+RFE2FS(N,N6,N5,N4)
      XFE3FS(N,N6,N5,N4)=XFE3FS(N,N6,N5,N4)+RFE3FS(N,N6,N5,N4)
      XFE4FS(N,N6,N5,N4)=XFE4FS(N,N6,N5,N4)+RFE4FS(N,N6,N5,N4)
      XFESFS(N,N6,N5,N4)=XFESFS(N,N6,N5,N4)+RFESFS(N,N6,N5,N4)
      XCAOFS(N,N6,N5,N4)=XCAOFS(N,N6,N5,N4)+RCAOFS(N,N6,N5,N4)
      XCACFS(N,N6,N5,N4)=XCACFS(N,N6,N5,N4)+RCACFS(N,N6,N5,N4)
      XCAHFS(N,N6,N5,N4)=XCAHFS(N,N6,N5,N4)+RCAHFS(N,N6,N5,N4)
      XCASFS(N,N6,N5,N4)=XCASFS(N,N6,N5,N4)+RCASFS(N,N6,N5,N4)
      XMGOFS(N,N6,N5,N4)=XMGOFS(N,N6,N5,N4)+RMGOFS(N,N6,N5,N4)
      XMGCFS(N,N6,N5,N4)=XMGCFS(N,N6,N5,N4)+RMGCFS(N,N6,N5,N4)
      XMGHFS(N,N6,N5,N4)=XMGHFS(N,N6,N5,N4)+RMGHFS(N,N6,N5,N4)
      XMGSFS(N,N6,N5,N4)=XMGSFS(N,N6,N5,N4)+RMGSFS(N,N6,N5,N4)
      XNACFS(N,N6,N5,N4)=XNACFS(N,N6,N5,N4)+RNACFS(N,N6,N5,N4)
      XNASFS(N,N6,N5,N4)=XNASFS(N,N6,N5,N4)+RNASFS(N,N6,N5,N4)
      XKASFS(N,N6,N5,N4)=XKASFS(N,N6,N5,N4)+RKASFS(N,N6,N5,N4)
      XH0PFS(N,N6,N5,N4)=XH0PFS(N,N6,N5,N4)+RH0PFS(N,N6,N5,N4)
      XH3PFS(N,N6,N5,N4)=XH3PFS(N,N6,N5,N4)+RH3PFS(N,N6,N5,N4)
      XF1PFS(N,N6,N5,N4)=XF1PFS(N,N6,N5,N4)+RF1PFS(N,N6,N5,N4)
      XF2PFS(N,N6,N5,N4)=XF2PFS(N,N6,N5,N4)+RF2PFS(N,N6,N5,N4)
      XC0PFS(N,N6,N5,N4)=XC0PFS(N,N6,N5,N4)+RC0PFS(N,N6,N5,N4)
      XC1PFS(N,N6,N5,N4)=XC1PFS(N,N6,N5,N4)+RC1PFS(N,N6,N5,N4)
      XC2PFS(N,N6,N5,N4)=XC2PFS(N,N6,N5,N4)+RC2PFS(N,N6,N5,N4)
      XM1PFS(N,N6,N5,N4)=XM1PFS(N,N6,N5,N4)+RM1PFS(N,N6,N5,N4)
      XH0BFB(N,N6,N5,N4)=XH0BFB(N,N6,N5,N4)+RH0BFB(N,N6,N5,N4)
      XH3BFB(N,N6,N5,N4)=XH3BFB(N,N6,N5,N4)+RH3BFB(N,N6,N5,N4)
      XF1BFB(N,N6,N5,N4)=XF1BFB(N,N6,N5,N4)+RF1BFB(N,N6,N5,N4)
      XF2BFB(N,N6,N5,N4)=XF2BFB(N,N6,N5,N4)+RF2BFB(N,N6,N5,N4)
      XC0BFB(N,N6,N5,N4)=XC0BFB(N,N6,N5,N4)+RC0BFB(N,N6,N5,N4)
      XC1BFB(N,N6,N5,N4)=XC1BFB(N,N6,N5,N4)+RC1BFB(N,N6,N5,N4)
      XC2BFB(N,N6,N5,N4)=XC2BFB(N,N6,N5,N4)+RC2BFB(N,N6,N5,N4)
      XM1BFB(N,N6,N5,N4)=XM1BFB(N,N6,N5,N4)+RM1BFB(N,N6,N5,N4)
      XALFHS(N,N6,N5,N4)=XALFHS(N,N6,N5,N4)+RALFHS(N,N6,N5,N4)
      XFEFHS(N,N6,N5,N4)=XFEFHS(N,N6,N5,N4)+RFEFHS(N,N6,N5,N4)
      XHYFHS(N,N6,N5,N4)=XHYFHS(N,N6,N5,N4)+RHYFHS(N,N6,N5,N4)
      XCAFHS(N,N6,N5,N4)=XCAFHS(N,N6,N5,N4)+RCAFHS(N,N6,N5,N4)
      XMGFHS(N,N6,N5,N4)=XMGFHS(N,N6,N5,N4)+RMGFHS(N,N6,N5,N4)
      XNAFHS(N,N6,N5,N4)=XNAFHS(N,N6,N5,N4)+RNAFHS(N,N6,N5,N4)
      XKAFHS(N,N6,N5,N4)=XKAFHS(N,N6,N5,N4)+RKAFHS(N,N6,N5,N4)
      XOHFHS(N,N6,N5,N4)=XOHFHS(N,N6,N5,N4)+ROHFHS(N,N6,N5,N4)
      XSOFHS(N,N6,N5,N4)=XSOFHS(N,N6,N5,N4)+RSOFHS(N,N6,N5,N4)
      XCLFHS(N,N6,N5,N4)=XCLFHS(N,N6,N5,N4)+RCLFHS(N,N6,N5,N4)
      XC3FHS(N,N6,N5,N4)=XC3FHS(N,N6,N5,N4)+RC3FHS(N,N6,N5,N4)
      XHCFHS(N,N6,N5,N4)=XHCFHS(N,N6,N5,N4)+RHCFHS(N,N6,N5,N4)
      XAL1HS(N,N6,N5,N4)=XAL1HS(N,N6,N5,N4)+RAL1HS(N,N6,N5,N4)
      XAL2HS(N,N6,N5,N4)=XAL2HS(N,N6,N5,N4)+RAL2HS(N,N6,N5,N4)
      XAL3HS(N,N6,N5,N4)=XAL3HS(N,N6,N5,N4)+RAL3HS(N,N6,N5,N4)
      XAL4HS(N,N6,N5,N4)=XAL4HS(N,N6,N5,N4)+RAL4HS(N,N6,N5,N4)
      XALSHS(N,N6,N5,N4)=XALSHS(N,N6,N5,N4)+RALSHS(N,N6,N5,N4)
      XFE1HS(N,N6,N5,N4)=XFE1HS(N,N6,N5,N4)+RFE1HS(N,N6,N5,N4)
      XFE2HS(N,N6,N5,N4)=XFE2HS(N,N6,N5,N4)+RFE2HS(N,N6,N5,N4)
      XFE3HS(N,N6,N5,N4)=XFE3HS(N,N6,N5,N4)+RFE3HS(N,N6,N5,N4)
      XFE4HS(N,N6,N5,N4)=XFE4HS(N,N6,N5,N4)+RFE4HS(N,N6,N5,N4)
      XFESHS(N,N6,N5,N4)=XFESHS(N,N6,N5,N4)+RFESHS(N,N6,N5,N4)
      XCAOHS(N,N6,N5,N4)=XCAOHS(N,N6,N5,N4)+RCAOHS(N,N6,N5,N4)
      XCACHS(N,N6,N5,N4)=XCACHS(N,N6,N5,N4)+RCACHS(N,N6,N5,N4)
      XCAHHS(N,N6,N5,N4)=XCAHHS(N,N6,N5,N4)+RCAHHS(N,N6,N5,N4)
      XCASHS(N,N6,N5,N4)=XCASHS(N,N6,N5,N4)+RCASHS(N,N6,N5,N4)
      XMGOHS(N,N6,N5,N4)=XMGOHS(N,N6,N5,N4)+RMGOHS(N,N6,N5,N4)
      XMGCHS(N,N6,N5,N4)=XMGCHS(N,N6,N5,N4)+RMGCHS(N,N6,N5,N4)
      XMGHHS(N,N6,N5,N4)=XMGHHS(N,N6,N5,N4)+RMGHHS(N,N6,N5,N4)
      XMGSHS(N,N6,N5,N4)=XMGSHS(N,N6,N5,N4)+RMGSHS(N,N6,N5,N4)
      XNACHS(N,N6,N5,N4)=XNACHS(N,N6,N5,N4)+RNACHS(N,N6,N5,N4)
      XNASHS(N,N6,N5,N4)=XNASHS(N,N6,N5,N4)+RNASHS(N,N6,N5,N4)
      XKASHS(N,N6,N5,N4)=XKASHS(N,N6,N5,N4)+RKASHS(N,N6,N5,N4)
      XH0PHS(N,N6,N5,N4)=XH0PHS(N,N6,N5,N4)+RH0PHS(N,N6,N5,N4)
      XH3PHS(N,N6,N5,N4)=XH3PHS(N,N6,N5,N4)+RH3PHS(N,N6,N5,N4)
      XF1PHS(N,N6,N5,N4)=XF1PHS(N,N6,N5,N4)+RF1PHS(N,N6,N5,N4)
      XF2PHS(N,N6,N5,N4)=XF2PHS(N,N6,N5,N4)+RF2PHS(N,N6,N5,N4)
      XC0PHS(N,N6,N5,N4)=XC0PHS(N,N6,N5,N4)+RC0PHS(N,N6,N5,N4)
      XC1PHS(N,N6,N5,N4)=XC1PHS(N,N6,N5,N4)+RC1PHS(N,N6,N5,N4)
      XC2PHS(N,N6,N5,N4)=XC2PHS(N,N6,N5,N4)+RC2PHS(N,N6,N5,N4)
      XM1PHS(N,N6,N5,N4)=XM1PHS(N,N6,N5,N4)+RM1PHS(N,N6,N5,N4)
      XH0BHB(N,N6,N5,N4)=XH0BHB(N,N6,N5,N4)+RH0BHB(N,N6,N5,N4)
      XH3BHB(N,N6,N5,N4)=XH3BHB(N,N6,N5,N4)+RH3BHB(N,N6,N5,N4)
      XF1BHB(N,N6,N5,N4)=XF1BHB(N,N6,N5,N4)+RF1BHB(N,N6,N5,N4)
      XF2BHB(N,N6,N5,N4)=XF2BHB(N,N6,N5,N4)+RF2BHB(N,N6,N5,N4)
      XC0BHB(N,N6,N5,N4)=XC0BHB(N,N6,N5,N4)+RC0BHB(N,N6,N5,N4)
      XC1BHB(N,N6,N5,N4)=XC1BHB(N,N6,N5,N4)+RC1BHB(N,N6,N5,N4)
      XC2BHB(N,N6,N5,N4)=XC2BHB(N,N6,N5,N4)+RC2BHB(N,N6,N5,N4)
      XM1BHB(N,N6,N5,N4)=XM1BHB(N,N6,N5,N4)+RM1BHB(N,N6,N5,N4)
C
C     MACROPORE-MICROPORE SOLUTE EXCHANGE WITHIN SOIL
C     LAYER FROM WATER EXCHANGE IN 'WATSUB' AND
C     FROM MACROPORE OR MICROPORE SOLUTE CONCENTRATIONS
C
      IF(N.EQ.3)THEN
C
C     MACROPORE-MICROPORE CONVECTIVE SOLUTE EXCHANGE IN SOIL
C     LAYER FROM WATER EXCHANGE IN 'WATSUB' AND
C     FROM MACROPORE OR MICROPORE SOLUTE CONCENTRATIONS
C
C     FINHM=macro-micropore water transfer from watsub.f 
C     VOLWM,VOLWHM=micropore,macropore water volume
C     RFL*=convective macropore-micropore solute transfer 
C     VLNH4,VLNO3,VLPO4=non-band NH4,NO3,PO4 volume fraction
C     VLNHB,VLNOB,VLPOB=band NH4,NO3,PO4 volume fraction
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     *H2,*2=macropore,micropore solute content
C
C     MACROPORE TO MICROPORE TRANSFER
C
      IF(FINHM(M,N6,N5,N4).GT.0.0)THEN
      IF(VOLWHM(M,N6,N5,N4).GT.ZEROS2(NY,NX))THEN
      VFLW=AMAX1(0.0,AMIN1(VFLWX,FINHM(M,N6,N5,N4)
     2/VOLWHM(M,N6,N5,N4)))
      ELSE
      VFLW=VFLWX
      ENDIF
      RFLAL=VFLW*AMAX1(0.0,ZALH2(N6,N5,N4)) 
      RFLFE=VFLW*AMAX1(0.0,ZFEH2(N6,N5,N4))
      RFLHY=VFLW*AMAX1(0.0,ZHYH2(N6,N5,N4))
      RFLCA=VFLW*AMAX1(0.0,ZCCH2(N6,N5,N4))
      RFLMG=VFLW*AMAX1(0.0,ZMAH2(N6,N5,N4))
      RFLNA=VFLW*AMAX1(0.0,ZNAH2(N6,N5,N4))
      RFLKA=VFLW*AMAX1(0.0,ZKAH2(N6,N5,N4))
      RFLOH=VFLW*AMAX1(0.0,ZOHH2(N6,N5,N4))
      RFLSO=VFLW*AMAX1(0.0,ZSO4H2(N6,N5,N4))
      RFLCL=VFLW*AMAX1(0.0,ZCLH2(N6,N5,N4))
      RFLC3=VFLW*AMAX1(0.0,ZCO3H2(N6,N5,N4))
      RFLHC=VFLW*AMAX1(0.0,ZHCOH2(N6,N5,N4))
      RFLAL1=VFLW*AMAX1(0.0,ZAL1H2(N6,N5,N4))
      RFLAL2=VFLW*AMAX1(0.0,ZAL2H2(N6,N5,N4))
      RFLAL3=VFLW*AMAX1(0.0,ZAL3H2(N6,N5,N4))
      RFLAL4=VFLW*AMAX1(0.0,ZAL4H2(N6,N5,N4))
      RFLALS=VFLW*AMAX1(0.0,ZALSH2(N6,N5,N4))
      RFLFE1=VFLW*AMAX1(0.0,ZFE1H2(N6,N5,N4))
      RFLFE2=VFLW*AMAX1(0.0,ZFE2H2(N6,N5,N4))
      RFLFE3=VFLW*AMAX1(0.0,ZFE3H2(N6,N5,N4))
      RFLFE4=VFLW*AMAX1(0.0,ZFE4H2(N6,N5,N4))
      RFLFES=VFLW*AMAX1(0.0,ZFESH2(N6,N5,N4))
      RFLCAO=VFLW*AMAX1(0.0,ZCAOH2(N6,N5,N4))
      RFLCAC=VFLW*AMAX1(0.0,ZCACH2(N6,N5,N4))
      RFLCAH=VFLW*AMAX1(0.0,ZCAHH2(N6,N5,N4))
      RFLCAS=VFLW*AMAX1(0.0,ZCASH2(N6,N5,N4))
      RFLMGO=VFLW*AMAX1(0.0,ZMGOH2(N6,N5,N4))
      RFLMGC=VFLW*AMAX1(0.0,ZMGCH2(N6,N5,N4))
      RFLMGH=VFLW*AMAX1(0.0,ZMGHH2(N6,N5,N4))
      RFLMGS=VFLW*AMAX1(0.0,ZMGSH2(N6,N5,N4))
      RFLNAC=VFLW*AMAX1(0.0,ZNACH2(N6,N5,N4))
      RFLNAS=VFLW*AMAX1(0.0,ZNASH2(N6,N5,N4))
      RFLKAS=VFLW*AMAX1(0.0,ZKASH2(N6,N5,N4))
      RFLH0P=VFLW*AMAX1(0.0,H0P4H2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLH3P=VFLW*AMAX1(0.0,H3P4H2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLF1P=VFLW*AMAX1(0.0,ZF1PH2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLF2P=VFLW*AMAX1(0.0,ZF2PH2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLC0P=VFLW*AMAX1(0.0,ZC0PH2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLC1P=VFLW*AMAX1(0.0,ZC1PH2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLC2P=VFLW*AMAX1(0.0,ZC2PH2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLM1P=VFLW*AMAX1(0.0,ZM1PH2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLH0B=VFLW*AMAX1(0.0,H0PBH2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLH3B=VFLW*AMAX1(0.0,H3PBH2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLF1B=VFLW*AMAX1(0.0,ZF1BH2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLF2B=VFLW*AMAX1(0.0,ZF2BH2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLC0B=VFLW*AMAX1(0.0,ZC0BH2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLC1B=VFLW*AMAX1(0.0,ZC1BH2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLC2B=VFLW*AMAX1(0.0,ZC2BH2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLM1B=VFLW*AMAX1(0.0,ZM1BH2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
C
C     MICROPORE TO MACROPORE TRANSFER
C
      ELSEIF(FINHM(M,N6,N5,N4).LT.0.0)THEN
      IF(VOLWM(M,N6,N5,N4).GT.ZEROS2(NY,NX))THEN
      VFLW=AMIN1(0.0,AMAX1(-VFLWX,FINHM(M,N6,N5,N4)
     2/VOLWM(M,N6,N5,N4)))
      ELSE
      VFLW=-VFLWX
      ENDIF
      RFLAL=VFLW*AMAX1(0.0,ZAL2(N6,N5,N4))
      RFLFE=VFLW*AMAX1(0.0,ZFE2(N6,N5,N4)) 
      RFLHY=VFLW*AMAX1(0.0,ZHY2(N6,N5,N4))
      RFLCA=VFLW*AMAX1(0.0,ZCA2(N6,N5,N4))
      RFLMG=VFLW*AMAX1(0.0,ZMG2(N6,N5,N4))
      RFLNA=VFLW*AMAX1(0.0,ZNA2(N6,N5,N4))
      RFLKA=VFLW*AMAX1(0.0,ZKA2(N6,N5,N4))
      RFLOH=VFLW*AMAX1(0.0,ZOH2(N6,N5,N4))
      RFLSO=VFLW*AMAX1(0.0,ZSO42(N6,N5,N4))
      RFLCL=VFLW*AMAX1(0.0,ZCL2(N6,N5,N4))
      RFLC3=VFLW*AMAX1(0.0,ZCO32(N6,N5,N4))
      RFLHC=VFLW*AMAX1(0.0,ZHCO32(N6,N5,N4))
      RFLAL1=VFLW*AMAX1(0.0,ZAL12(N6,N5,N4))
      RFLAL2=VFLW*AMAX1(0.0,ZAL22(N6,N5,N4))
      RFLAL3=VFLW*AMAX1(0.0,ZAL32(N6,N5,N4))
      RFLAL4=VFLW*AMAX1(0.0,ZAL42(N6,N5,N4))
      RFLALS=VFLW*AMAX1(0.0,ZALS2(N6,N5,N4))
      RFLFE1=VFLW*AMAX1(0.0,ZFE12(N6,N5,N4))
      RFLFE2=VFLW*AMAX1(0.0,ZFE22(N6,N5,N4))
      RFLFE3=VFLW*AMAX1(0.0,ZFE32(N6,N5,N4))
      RFLFE4=VFLW*AMAX1(0.0,ZFE42(N6,N5,N4))
      RFLFES=VFLW*AMAX1(0.0,ZFES2(N6,N5,N4))
      RFLCAO=VFLW*AMAX1(0.0,ZCAO2(N6,N5,N4))
      RFLCAC=VFLW*AMAX1(0.0,ZCAC2(N6,N5,N4))
      RFLCAH=VFLW*AMAX1(0.0,ZCAH2(N6,N5,N4))
      RFLCAS=VFLW*AMAX1(0.0,ZCAS2(N6,N5,N4))
      RFLMGO=VFLW*AMAX1(0.0,ZMGO2(N6,N5,N4))
      RFLMGC=VFLW*AMAX1(0.0,ZMGC2(N6,N5,N4))
      RFLMGH=VFLW*AMAX1(0.0,ZMGH2(N6,N5,N4))
      RFLMGS=VFLW*AMAX1(0.0,ZMGS2(N6,N5,N4))
      RFLNAC=VFLW*AMAX1(0.0,ZNAC2(N6,N5,N4))
      RFLNAS=VFLW*AMAX1(0.0,ZNAS2(N6,N5,N4))
      RFLKAS=VFLW*AMAX1(0.0,ZKAS2(N6,N5,N4))
      RFLH0P=VFLW*AMAX1(0.0,H0PO42(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLH3P=VFLW*AMAX1(0.0,H3PO42(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLF1P=VFLW*AMAX1(0.0,ZFE1P2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLF2P=VFLW*AMAX1(0.0,ZFE2P2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLC0P=VFLW*AMAX1(0.0,ZCA0P2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLC1P=VFLW*AMAX1(0.0,ZCA1P2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLC2P=VFLW*AMAX1(0.0,ZCA2P2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLM1P=VFLW*AMAX1(0.0,ZMG1P2(N6,N5,N4))
     2*VLPO4(N6,N5,N4)
      RFLH0B=VFLW*AMAX1(0.0,H0POB2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLH3B=VFLW*AMAX1(0.0,H3POB2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLF1B=VFLW*AMAX1(0.0,ZF1PB2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLF2B=VFLW*AMAX1(0.0,ZF2PB2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLC0B=VFLW*AMAX1(0.0,ZC0PB2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLC1B=VFLW*AMAX1(0.0,ZC1PB2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLC2B=VFLW*AMAX1(0.0,ZC2PB2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
      RFLM1B=VFLW*AMAX1(0.0,ZM1PB2(N6,N5,N4))
     2*VLPOB(N6,N5,N4)
C
C     NO MACROPORE TO MICROPORE TRANSFER
C
      ELSE
      RFLAL=0.0
      RFLFE=0.0
      RFLHY=0.0
      RFLCA=0.0
      RFLMG=0.0
      RFLNA=0.0
      RFLKA=0.0
      RFLOH=0.0
      RFLSO=0.0
      RFLCL=0.0
      RFLC3=0.0
      RFLHC=0.0
      RFLAL1=0.0
      RFLAL2=0.0
      RFLAL3=0.0
      RFLAL4=0.0
      RFLALS=0.0
      RFLFE1=0.0
      RFLFE2=0.0
      RFLFE3=0.0
      RFLFE4=0.0
      RFLFES=0.0
      RFLCAO=0.0
      RFLCAC=0.0
      RFLCAH=0.0
      RFLCAS=0.0
      RFLMGO=0.0
      RFLMGC=0.0
      RFLMGH=0.0
      RFLMGS=0.0
      RFLNAC=0.0
      RFLNAS=0.0
      RFLKAS=0.0
      RFLH0P=0.0
      RFLH3P=0.0
      RFLF1P=0.0
      RFLF2P=0.0
      RFLC0P=0.0
      RFLC1P=0.0
      RFLC2P=0.0
      RFLM1P=0.0
      RFLH0B=0.0
      RFLH3B=0.0
      RFLF1B=0.0
      RFLF2B=0.0
      RFLC0B=0.0
      RFLC1B=0.0
      RFLC2B=0.0
      RFLM1B=0.0
      ENDIF
C
C     DIFFUSIVE FLUXES OF SOLUTES BETWEEN MICROPORES AND
C     MACROPORES FROM AQUEOUS DIFFUSIVITIES AND CONCENTRATION DIFFERENCES
C
C     VOLWM,VOLWHM=micropore,macropore water-filled porosity from watsub.f
C     DFV*S,DFV*B=diffusive solute flux between macro- and micropore in non-band,band
C     XNPH=1/no. of cycles h-1 for water, heat and solute flux calculations
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     *2,*H2=solute content of micropores,macropores
C
      IF(VOLWHM(M,N6,N5,N4).GT.ZEROS2(NY,NX))THEN
      VOLWHS=AMIN1(XFRS*VOLT(N6,N5,N4),VOLWHM(M,N6,N5,N4))
      VOLWT=VOLWM(M,N6,N5,N4)+VOLWHS 
      DFVAL=XNPH*(AMAX1(0.0,ZALH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZAL2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVFE=XNPH*(AMAX1(0.0,ZFEH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZFE2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVHY=XNPH*(AMAX1(0.0,ZHYH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZHY2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVCA=XNPH*(AMAX1(0.0,ZCCH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZCA2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVMG=XNPH*(AMAX1(0.0,ZMAH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZMG2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVNA=XNPH*(AMAX1(0.0,ZNAH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZNA2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVKA=XNPH*(AMAX1(0.0,ZKAH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZKA2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVOH=XNPH*(AMAX1(0.0,ZOHH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZOH2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVSO=XNPH*(AMAX1(0.0,ZSO4H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZSO42(N6,N5,N4))*VOLWHS)/VOLWT
      DFVCL=XNPH*(AMAX1(0.0,ZCLH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZCL2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVC3=XNPH*(AMAX1(0.0,ZCO3H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZCO32(N6,N5,N4))*VOLWHS)/VOLWT
      DFVHC=XNPH*(AMAX1(0.0,ZHCOH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZHCO32(N6,N5,N4))*VOLWHS)/VOLWT
      DFVAL1=XNPH*(AMAX1(0.0,ZAL1H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZAL12(N6,N5,N4))*VOLWHS)/VOLWT
      DFVAL2=XNPH*(AMAX1(0.0,ZAL2H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZAL22(N6,N5,N4))*VOLWHS)/VOLWT
      DFVAL3=XNPH*(AMAX1(0.0,ZAL3H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZAL32(N6,N5,N4))*VOLWHS)/VOLWT
      DFVAL4=XNPH*(AMAX1(0.0,ZAL4H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZAL42(N6,N5,N4))*VOLWHS)/VOLWT
      DFVALS=XNPH*(AMAX1(0.0,ZALSH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZALS2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVFE1=XNPH*(AMAX1(0.0,ZFE1H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZFE12(N6,N5,N4))*VOLWHS)/VOLWT
      DFVF22=XNPH*(AMAX1(0.0,ZFE2H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZFE22(N6,N5,N4))*VOLWHS)/VOLWT
      DFVFE3=XNPH*(AMAX1(0.0,ZFE3H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZFE32(N6,N5,N4))*VOLWHS)/VOLWT
      DFVFE4=XNPH*(AMAX1(0.0,ZFE4H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZFE42(N6,N5,N4))*VOLWHS)/VOLWT
      DFVFES=XNPH*(AMAX1(0.0,ZFESH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZFES2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVCAO=XNPH*(AMAX1(0.0,ZCAOH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZCAO2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVCAC=XNPH*(AMAX1(0.0,ZCACH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZCAC2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVCAH=XNPH*(AMAX1(0.0,ZCAHH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZCAH2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVCAS=XNPH*(AMAX1(0.0,ZCASH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZCAS2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVMGO=XNPH*(AMAX1(0.0,ZMGOH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZMGO2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVMGC=XNPH*(AMAX1(0.0,ZMGCH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZMGC2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVMGH=XNPH*(AMAX1(0.0,ZMGHH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZMGH2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVMGS=XNPH*(AMAX1(0.0,ZMGSH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZMGS2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVNAC=XNPH*(AMAX1(0.0,ZNACH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZNAC2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVNAS=XNPH*(AMAX1(0.0,ZNASH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZNAS2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVKAS=XNPH*(AMAX1(0.0,ZKASH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZKAS2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVNAC=XNPH*(AMAX1(0.0,ZNACH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZNAC2(N6,N5,N4))*VOLWHS)/VOLWT
      DFVH0P=XNPH*(AMAX1(0.0,H0P4H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,H0PO42(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPO4(N6,N5,N4)
      DFVH3P=XNPH*(AMAX1(0.0,H3P4H2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,H3PO42(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPO4(N6,N5,N4)
      DFVF1P=XNPH*(AMAX1(0.0,ZF1PH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZFE1P2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPO4(N6,N5,N4)
      DFVF2P=XNPH*(AMAX1(0.0,ZF2PH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZFE2P2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPO4(N6,N5,N4)
      DFVC0P=XNPH*(AMAX1(0.0,ZC0PH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZCA0P2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPO4(N6,N5,N4)
      DFVC1P=XNPH*(AMAX1(0.0,ZC1PH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZCA1P2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPO4(N6,N5,N4)
      DFVC2P=XNPH*(AMAX1(0.0,ZC2PH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZCA2P2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPO4(N6,N5,N4)
      DFVM1P=XNPH*(AMAX1(0.0,ZM1PH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZMG1P2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPO4(N6,N5,N4)
      DFVH0B=XNPH*(AMAX1(0.0,H0PBH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,H0POB2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPOB(N6,N5,N4)
      DFVH3B=XNPH*(AMAX1(0.0,H3PBH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,H3POB2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPOB(N6,N5,N4)
      DFVF1B=XNPH*(AMAX1(0.0,ZF1BH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZF1PB2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPOB(N6,N5,N4)
      DFVF2B=XNPH*(AMAX1(0.0,ZF2BH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZF2PB2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPOB(N6,N5,N4)
      DFVC0B=XNPH*(AMAX1(0.0,ZC0BH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZC0PB2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPOB(N6,N5,N4)
      DFVC1B=XNPH*(AMAX1(0.0,ZC1BH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZC1PB2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPOB(N6,N5,N4)
      DFVC2B=XNPH*(AMAX1(0.0,ZC2BH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZC2PB2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPOB(N6,N5,N4)
      DFVM1B=XNPH*(AMAX1(0.0,ZM1BH2(N6,N5,N4))*VOLWM(M,N6,N5,N4)
     2-AMAX1(0.0,ZM1PB2(N6,N5,N4))*VOLWHS)/VOLWT
     2*VLPOB(N6,N5,N4)
      ELSE
      DFVAL=0.0
      DFVFE=0.0
      DFVHY=0.0
      DFVCA=0.0
      DFVMG=0.0
      DFVNA=0.0
      DFVKA=0.0
      DFVOH=0.0
      DFVSO=0.0
      DFVCL=0.0
      DFVC3=0.0
      DFVHC=0.0
      DFVAL1=0.0
      DFVAL2=0.0
      DFVAL3=0.0
      DFVAL4=0.0
      DFVALS=0.0
      DFVFE1=0.0
      DFVFE2=0.0
      DFVFE3=0.0
      DFVFE4=0.0
      DFVFES=0.0
      DFVCAO=0.0
      DFVCAC=0.0
      DFVCAH=0.0
      DFVCAS=0.0
      DFVMGO=0.0
      DFVMGC=0.0
      DFVMGH=0.0
      DFVMGS=0.0
      DFVNAC=0.0
      DFVNAS=0.0
      DFVKAS=0.0
      DFVH0P=0.0
      DFVH3P=0.0
      DFVF1P=0.0
      DFVF2P=0.0
      DFVC0P=0.0
      DFVC1P=0.0
      DFVC2P=0.0
      DFVM1P=0.0
      DFVH0B=0.0
      DFVH3B=0.0
      DFVF1B=0.0
      DFVF2B=0.0
      DFVC0B=0.0
      DFVC1B=0.0
      DFVC2B=0.0
      DFVM1B=0.0
      ENDIF
C
C     TOTAL CONVECTIVE +DIFFUSIVE TRANSFER BETWEEN MACROPOES AND MICROPORES
C
C     R*FXS,R*FXB=total convective + diffusive solute flux between macro- and micropore in non-band,band
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     RFL*=convective flux between macro- and micropore 
C     DFV*=diffusive solute flux between macro- and micropore 
C
      RALFXS(N6,N5,N4)=RFLAL+DFVAL
      RFEFXS(N6,N5,N4)=RFLFE+DFVFE
      RHYFXS(N6,N5,N4)=RFLHY+DFVHY
      RCAFXS(N6,N5,N4)=RFLCA+DFVCA
      RMGFXS(N6,N5,N4)=RFLMG+DFVMG
      RNAFXS(N6,N5,N4)=RFLNA+DFVNA
      RKAFXS(N6,N5,N4)=RFLKA+DFVKA
      ROHFXS(N6,N5,N4)=RFLOH+DFVOH
      RSOFXS(N6,N5,N4)=RFLSO+DFVSO
      RCLFXS(N6,N5,N4)=RFLCL+DFVCL
      RC3FXS(N6,N5,N4)=RFLC3+DFVC3
      RHCFXS(N6,N5,N4)=RFLHC+DFVHC
      RAL1XS(N6,N5,N4)=RFLAL1+DFVAL1
      RAL2XS(N6,N5,N4)=RFLAL2+DFVAL2
      RAL3XS(N6,N5,N4)=RFLAL3+DFVAL3
      RAL4XS(N6,N5,N4)=RFLAL4+DFVAL4
      RALSXS(N6,N5,N4)=RFLALS+DFVALS
      RFE1XS(N6,N5,N4)=RFLFE1+DFVFE1
      RFE2XS(N6,N5,N4)=RFLFE2+DFVFE2
      RFE3XS(N6,N5,N4)=RFLFE3+DFVFE3
      RFE4XS(N6,N5,N4)=RFLFE4+DFVFE4
      RFESXS(N6,N5,N4)=RFLFES+DFVFES
      RCAOXS(N6,N5,N4)=RFLCAO+DFVCAO
      RCACXS(N6,N5,N4)=RFLCAC+DFVCAC
      RCAHXS(N6,N5,N4)=RFLCAH+DFVCAH
      RCASXS(N6,N5,N4)=RFLCAS+DFVCAS
      RMGOXS(N6,N5,N4)=RFLMGO+DFVMGO
      RMGCXS(N6,N5,N4)=RFLMGC+DFVMGC
      RMGHXS(N6,N5,N4)=RFLMGH+DFVMGH
      RMGSXS(N6,N5,N4)=RFLMGS+DFVMGS
      RNACXS(N6,N5,N4)=RFLNAC+DFVNAC
      RNASXS(N6,N5,N4)=RFLNAS+DFVNAS
      RKASXS(N6,N5,N4)=RFLKAS+DFVKAS
      RH0PXS(N6,N5,N4)=RFLH0P+DFVH0P
      RH3PXS(N6,N5,N4)=RFLH3P+DFVH3P
      RF1PXS(N6,N5,N4)=RFLF1P+DFVF1P
      RF2PXS(N6,N5,N4)=RFLF2P+DFVF2P
      RC0PXS(N6,N5,N4)=RFLC0P+DFVC0P
      RC1PXS(N6,N5,N4)=RFLC1P+DFVC1P
      RC2PXS(N6,N5,N4)=RFLC2P+DFVC2P
      RM1PXS(N6,N5,N4)=RFLM1P+DFVM1P
      RH0BXB(N6,N5,N4)=RFLH0B+DFVH0B
      RH3BXB(N6,N5,N4)=RFLH3B+DFVH3B
      RF1BXB(N6,N5,N4)=RFLF1B+DFVF1B
      RF2BXB(N6,N5,N4)=RFLF2B+DFVF2B
      RC0BXB(N6,N5,N4)=RFLC0B+DFVC0B
      RC1BXB(N6,N5,N4)=RFLC1B+DFVC1B
      RC2BXB(N6,N5,N4)=RFLC2B+DFVC2B
      RM1BXB(N6,N5,N4)=RFLM1B+DFVM1B
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*FXS,X*FXB= hourly convective + diffusive solute flux between macro- and micropore in non-band,band
C     R*FXS,R*FXB=convective + diffusive solute flux between macro- and micropore in non-band,band
C
      XALFXS(N6,N5,N4)=XALFXS(N6,N5,N4)+RALFXS(N6,N5,N4)
      XFEFXS(N6,N5,N4)=XFEFXS(N6,N5,N4)+RFEFXS(N6,N5,N4)
      XHYFXS(N6,N5,N4)=XHYFXS(N6,N5,N4)+RHYFXS(N6,N5,N4)
      XCAFXS(N6,N5,N4)=XCAFXS(N6,N5,N4)+RCAFXS(N6,N5,N4)
      XMGFXS(N6,N5,N4)=XMGFXS(N6,N5,N4)+RMGFXS(N6,N5,N4)
      XNAFXS(N6,N5,N4)=XNAFXS(N6,N5,N4)+RNAFXS(N6,N5,N4)
      XKAFXS(N6,N5,N4)=XKAFXS(N6,N5,N4)+RKAFXS(N6,N5,N4)
      XOHFXS(N6,N5,N4)=XOHFXS(N6,N5,N4)+ROHFXS(N6,N5,N4)
      XSOFXS(N6,N5,N4)=XSOFXS(N6,N5,N4)+RSOFXS(N6,N5,N4)
      XCLFXS(N6,N5,N4)=XCLFXS(N6,N5,N4)+RCLFXS(N6,N5,N4)
      XC3FXS(N6,N5,N4)=XC3FXS(N6,N5,N4)+RC3FXS(N6,N5,N4)
      XHCFXS(N6,N5,N4)=XHCFXS(N6,N5,N4)+RHCFXS(N6,N5,N4)
      XAL1XS(N6,N5,N4)=XAL1XS(N6,N5,N4)+RAL1XS(N6,N5,N4)
      XAL2XS(N6,N5,N4)=XAL2XS(N6,N5,N4)+RAL2XS(N6,N5,N4)
      XAL3XS(N6,N5,N4)=XAL3XS(N6,N5,N4)+RAL3XS(N6,N5,N4)
      XAL4XS(N6,N5,N4)=XAL4XS(N6,N5,N4)+RAL4XS(N6,N5,N4)
      XALSXS(N6,N5,N4)=XALSXS(N6,N5,N4)+RALSXS(N6,N5,N4)
      XFE1XS(N6,N5,N4)=XFE1XS(N6,N5,N4)+RFE1XS(N6,N5,N4)
      XFE2XS(N6,N5,N4)=XFE2XS(N6,N5,N4)+RFE2XS(N6,N5,N4)
      XFE3XS(N6,N5,N4)=XFE3XS(N6,N5,N4)+RFE3XS(N6,N5,N4)
      XFE4XS(N6,N5,N4)=XFE4XS(N6,N5,N4)+RFE4XS(N6,N5,N4)
      XFESXS(N6,N5,N4)=XFESXS(N6,N5,N4)+RFESXS(N6,N5,N4)
      XCAOXS(N6,N5,N4)=XCAOXS(N6,N5,N4)+RCAOXS(N6,N5,N4)
      XCACXS(N6,N5,N4)=XCACXS(N6,N5,N4)+RCACXS(N6,N5,N4)
      XCAHXS(N6,N5,N4)=XCAHXS(N6,N5,N4)+RCAHXS(N6,N5,N4)
      XCASXS(N6,N5,N4)=XCASXS(N6,N5,N4)+RCASXS(N6,N5,N4)
      XMGOXS(N6,N5,N4)=XMGOXS(N6,N5,N4)+RMGOXS(N6,N5,N4)
      XMGCXS(N6,N5,N4)=XMGCXS(N6,N5,N4)+RMGCXS(N6,N5,N4)
      XMGHXS(N6,N5,N4)=XMGHXS(N6,N5,N4)+RMGHXS(N6,N5,N4)
      XMGSXS(N6,N5,N4)=XMGSXS(N6,N5,N4)+RMGSXS(N6,N5,N4)
      XNACXS(N6,N5,N4)=XNACXS(N6,N5,N4)+RNACXS(N6,N5,N4)
      XNASXS(N6,N5,N4)=XNASXS(N6,N5,N4)+RNASXS(N6,N5,N4)
      XKASXS(N6,N5,N4)=XKASXS(N6,N5,N4)+RKASXS(N6,N5,N4)
      XH0PXS(N6,N5,N4)=XH0PXS(N6,N5,N4)+RH0PXS(N6,N5,N4)
      XH3PXS(N6,N5,N4)=XH3PXS(N6,N5,N4)+RH3PXS(N6,N5,N4)
      XF1PXS(N6,N5,N4)=XF1PXS(N6,N5,N4)+RF1PXS(N6,N5,N4)
      XF2PXS(N6,N5,N4)=XF2PXS(N6,N5,N4)+RF2PXS(N6,N5,N4)
      XC0PXS(N6,N5,N4)=XC0PXS(N6,N5,N4)+RC0PXS(N6,N5,N4)
      XC1PXS(N6,N5,N4)=XC1PXS(N6,N5,N4)+RC1PXS(N6,N5,N4)
      XC2PXS(N6,N5,N4)=XC2PXS(N6,N5,N4)+RC2PXS(N6,N5,N4)
      XM1PXS(N6,N5,N4)=XM1PXS(N6,N5,N4)+RM1PXS(N6,N5,N4)
      XH0BXB(N6,N5,N4)=XH0BXB(N6,N5,N4)+RH0BXB(N6,N5,N4)
      XH3BXB(N6,N5,N4)=XH3BXB(N6,N5,N4)+RH3BXB(N6,N5,N4)
      XF1BXB(N6,N5,N4)=XF1BXB(N6,N5,N4)+RF1BXB(N6,N5,N4)
      XF2BXB(N6,N5,N4)=XF2BXB(N6,N5,N4)+RF2BXB(N6,N5,N4)
      XC0BXB(N6,N5,N4)=XC0BXB(N6,N5,N4)+RC0BXB(N6,N5,N4)
      XC1BXB(N6,N5,N4)=XC1BXB(N6,N5,N4)+RC1BXB(N6,N5,N4)
      XC2BXB(N6,N5,N4)=XC2BXB(N6,N5,N4)+RC2BXB(N6,N5,N4)
      XM1BXB(N6,N5,N4)=XM1BXB(N6,N5,N4)+RM1BXB(N6,N5,N4)
      ENDIF
      ELSEIF(N.NE.3)THEN
      THETW1(N3,N2,N1)=0.0
      THETW1(N6,N5,N4)=0.0
      RALFLS(N,N6,N5,N4)=0.0
      RFEFLS(N,N6,N5,N4)=0.0
      RHYFLS(N,N6,N5,N4)=0.0
      RCAFLS(N,N6,N5,N4)=0.0
      RMGFLS(N,N6,N5,N4)=0.0
      RNAFLS(N,N6,N5,N4)=0.0
      RKAFLS(N,N6,N5,N4)=0.0
      ROHFLS(N,N6,N5,N4)=0.0
      RSOFLS(N,N6,N5,N4)=0.0
      RCLFLS(N,N6,N5,N4)=0.0
      RC3FLS(N,N6,N5,N4)=0.0
      RHCFLS(N,N6,N5,N4)=0.0
      RAL1FS(N,N6,N5,N4)=0.0
      RAL2FS(N,N6,N5,N4)=0.0
      RAL3FS(N,N6,N5,N4)=0.0
      RAL4FS(N,N6,N5,N4)=0.0
      RALSFS(N,N6,N5,N4)=0.0
      RFE1FS(N,N6,N5,N4)=0.0
      RFE2FS(N,N6,N5,N4)=0.0
      RFE3FS(N,N6,N5,N4)=0.0
      RFE4FS(N,N6,N5,N4)=0.0
      RFESFS(N,N6,N5,N4)=0.0
      RCAOFS(N,N6,N5,N4)=0.0
      RCACFS(N,N6,N5,N4)=0.0
      RCAHFS(N,N6,N5,N4)=0.0
      RCASFS(N,N6,N5,N4)=0.0
      RMGOFS(N,N6,N5,N4)=0.0
      RMGCFS(N,N6,N5,N4)=0.0
      RMGHFS(N,N6,N5,N4)=0.0
      RMGSFS(N,N6,N5,N4)=0.0
      RNACFS(N,N6,N5,N4)=0.0
      RNASFS(N,N6,N5,N4)=0.0
      RKASFS(N,N6,N5,N4)=0.0
      RH0PFS(N,N6,N5,N4)=0.0
      RH3PFS(N,N6,N5,N4)=0.0
      RF1PFS(N,N6,N5,N4)=0.0
      RF2PFS(N,N6,N5,N4)=0.0
      RC0PFS(N,N6,N5,N4)=0.0
      RC1PFS(N,N6,N5,N4)=0.0
      RC2PFS(N,N6,N5,N4)=0.0
      RM1PFS(N,N6,N5,N4)=0.0
      RH0BFB(N,N6,N5,N4)=0.0
      RH3BFB(N,N6,N5,N4)=0.0
      RF1BFB(N,N6,N5,N4)=0.0
      RF2BFB(N,N6,N5,N4)=0.0
      RC0BFB(N,N6,N5,N4)=0.0
      RC1BFB(N,N6,N5,N4)=0.0
      RC2BFB(N,N6,N5,N4)=0.0
      RM1BFB(N,N6,N5,N4)=0.0
      RALFHS(N,N6,N5,N4)=0.0
      RFEFHS(N,N6,N5,N4)=0.0
      RHYFHS(N,N6,N5,N4)=0.0
      RCAFHS(N,N6,N5,N4)=0.0
      RMGFHS(N,N6,N5,N4)=0.0
      RNAFHS(N,N6,N5,N4)=0.0
      RKAFHS(N,N6,N5,N4)=0.0
      ROHFHS(N,N6,N5,N4)=0.0
      RSOFHS(N,N6,N5,N4)=0.0
      RCLFHS(N,N6,N5,N4)=0.0
      RC3FHS(N,N6,N5,N4)=0.0
      RHCFHS(N,N6,N5,N4)=0.0
      RAL1HS(N,N6,N5,N4)=0.0
      RAL2HS(N,N6,N5,N4)=0.0
      RAL3HS(N,N6,N5,N4)=0.0
      RAL4HS(N,N6,N5,N4)=0.0
      RALSHS(N,N6,N5,N4)=0.0
      RFE1HS(N,N6,N5,N4)=0.0
      RFE2HS(N,N6,N5,N4)=0.0
      RFE3HS(N,N6,N5,N4)=0.0
      RFE4HS(N,N6,N5,N4)=0.0
      RFESHS(N,N6,N5,N4)=0.0
      RCAOHS(N,N6,N5,N4)=0.0
      RCACHS(N,N6,N5,N4)=0.0
      RCAHHS(N,N6,N5,N4)=0.0
      RCASHS(N,N6,N5,N4)=0.0
      RMGOHS(N,N6,N5,N4)=0.0
      RMGCHS(N,N6,N5,N4)=0.0
      RMGHHS(N,N6,N5,N4)=0.0
      RMGSHS(N,N6,N5,N4)=0.0
      RNACHS(N,N6,N5,N4)=0.0
      RNASHS(N,N6,N5,N4)=0.0
      RKASHS(N,N6,N5,N4)=0.0
      RH0PHS(N,N6,N5,N4)=0.0
      RH3PHS(N,N6,N5,N4)=0.0
      RF1PHS(N,N6,N5,N4)=0.0
      RF2PHS(N,N6,N5,N4)=0.0
      RC0PHS(N,N6,N5,N4)=0.0
      RC1PHS(N,N6,N5,N4)=0.0
      RC2PHS(N,N6,N5,N4)=0.0
      RM1PHS(N,N6,N5,N4)=0.0
      RH0BHB(N,N6,N5,N4)=0.0
      RH3BHB(N,N6,N5,N4)=0.0
      RF1BHB(N,N6,N5,N4)=0.0
      RF2BHB(N,N6,N5,N4)=0.0
      RC0BHB(N,N6,N5,N4)=0.0
      RC1BHB(N,N6,N5,N4)=0.0
      RC2BHB(N,N6,N5,N4)=0.0
      RM1BHB(N,N6,N5,N4)=0.0
      ENDIF
      ELSE 
      THETW1(N3,N2,N1)=0.0
      THETW1(N6,N5,N4)=0.0
      RALFLS(N,N6,N5,N4)=0.0
      RFEFLS(N,N6,N5,N4)=0.0
      RHYFLS(N,N6,N5,N4)=0.0
      RCAFLS(N,N6,N5,N4)=0.0
      RMGFLS(N,N6,N5,N4)=0.0
      RNAFLS(N,N6,N5,N4)=0.0
      RKAFLS(N,N6,N5,N4)=0.0
      ROHFLS(N,N6,N5,N4)=0.0
      RSOFLS(N,N6,N5,N4)=0.0
      RCLFLS(N,N6,N5,N4)=0.0
      RC3FLS(N,N6,N5,N4)=0.0
      RHCFLS(N,N6,N5,N4)=0.0
      RAL1FS(N,N6,N5,N4)=0.0
      RAL2FS(N,N6,N5,N4)=0.0
      RAL3FS(N,N6,N5,N4)=0.0
      RAL4FS(N,N6,N5,N4)=0.0
      RALSFS(N,N6,N5,N4)=0.0
      RFE1FS(N,N6,N5,N4)=0.0
      RFE2FS(N,N6,N5,N4)=0.0
      RFE3FS(N,N6,N5,N4)=0.0
      RFE4FS(N,N6,N5,N4)=0.0
      RFESFS(N,N6,N5,N4)=0.0
      RCAOFS(N,N6,N5,N4)=0.0
      RCACFS(N,N6,N5,N4)=0.0
      RCAHFS(N,N6,N5,N4)=0.0
      RCASFS(N,N6,N5,N4)=0.0
      RMGOFS(N,N6,N5,N4)=0.0
      RMGCFS(N,N6,N5,N4)=0.0
      RMGHFS(N,N6,N5,N4)=0.0
      RMGSFS(N,N6,N5,N4)=0.0
      RNACFS(N,N6,N5,N4)=0.0
      RNASFS(N,N6,N5,N4)=0.0
      RKASFS(N,N6,N5,N4)=0.0
      RH0PFS(N,N6,N5,N4)=0.0
      RH3PFS(N,N6,N5,N4)=0.0
      RF1PFS(N,N6,N5,N4)=0.0
      RF2PFS(N,N6,N5,N4)=0.0
      RC0PFS(N,N6,N5,N4)=0.0
      RC1PFS(N,N6,N5,N4)=0.0
      RC2PFS(N,N6,N5,N4)=0.0
      RM1PFS(N,N6,N5,N4)=0.0
      RH0BFB(N,N6,N5,N4)=0.0
      RH3BFB(N,N6,N5,N4)=0.0
      RF1BFB(N,N6,N5,N4)=0.0
      RF2BFB(N,N6,N5,N4)=0.0
      RC0BFB(N,N6,N5,N4)=0.0
      RC1BFB(N,N6,N5,N4)=0.0
      RC2BFB(N,N6,N5,N4)=0.0
      RM1BFB(N,N6,N5,N4)=0.0
      RALFHS(N,N6,N5,N4)=0.0
      RFEFHS(N,N6,N5,N4)=0.0
      RHYFHS(N,N6,N5,N4)=0.0
      RCAFHS(N,N6,N5,N4)=0.0
      RMGFHS(N,N6,N5,N4)=0.0
      RNAFHS(N,N6,N5,N4)=0.0
      RKAFHS(N,N6,N5,N4)=0.0
      ROHFHS(N,N6,N5,N4)=0.0
      RSOFHS(N,N6,N5,N4)=0.0
      RCLFHS(N,N6,N5,N4)=0.0
      RC3FHS(N,N6,N5,N4)=0.0
      RHCFHS(N,N6,N5,N4)=0.0
      RAL1HS(N,N6,N5,N4)=0.0
      RAL2HS(N,N6,N5,N4)=0.0
      RAL3HS(N,N6,N5,N4)=0.0
      RAL4HS(N,N6,N5,N4)=0.0
      RALSHS(N,N6,N5,N4)=0.0
      RFE1HS(N,N6,N5,N4)=0.0
      RFE2HS(N,N6,N5,N4)=0.0
      RFE3HS(N,N6,N5,N4)=0.0
      RFE4HS(N,N6,N5,N4)=0.0
      RFESHS(N,N6,N5,N4)=0.0
      RCAOHS(N,N6,N5,N4)=0.0
      RCACHS(N,N6,N5,N4)=0.0
      RCAHHS(N,N6,N5,N4)=0.0
      RCASHS(N,N6,N5,N4)=0.0
      RMGOHS(N,N6,N5,N4)=0.0
      RMGCHS(N,N6,N5,N4)=0.0
      RMGHHS(N,N6,N5,N4)=0.0
      RMGSHS(N,N6,N5,N4)=0.0
      RNACHS(N,N6,N5,N4)=0.0
      RNASHS(N,N6,N5,N4)=0.0
      RKASHS(N,N6,N5,N4)=0.0
      RH0PHS(N,N6,N5,N4)=0.0
      RH3PHS(N,N6,N5,N4)=0.0
      RF1PHS(N,N6,N5,N4)=0.0
      RF2PHS(N,N6,N5,N4)=0.0
      RC0PHS(N,N6,N5,N4)=0.0
      RC1PHS(N,N6,N5,N4)=0.0
      RC2PHS(N,N6,N5,N4)=0.0
      RM1PHS(N,N6,N5,N4)=0.0
      RH0BHB(N,N6,N5,N4)=0.0
      RH3BHB(N,N6,N5,N4)=0.0
      RF1BHB(N,N6,N5,N4)=0.0
      RF2BHB(N,N6,N5,N4)=0.0
      RC0BHB(N,N6,N5,N4)=0.0
      RC1BHB(N,N6,N5,N4)=0.0
      RC2BHB(N,N6,N5,N4)=0.0
      RM1BHB(N,N6,N5,N4)=0.0
      ENDIF
120   CONTINUE
125   CONTINUE
      ENDIF
9890  CONTINUE
9895  CONTINUE
C
C     BOUNDARY SOLUTE AND GAS FLUXES
C
C     N3,N2,N1=L,NY,NX of source grid cell
C     M6,M5,M4=L,NY,NX of destination grid cell
C
      DO 9595 NX=NHW,NHE
      DO 9590 NY=NVN,NVS
      IF(ISALTG.NE.0)THEN
      DO 9585 L=NU(NY,NX),NL(NY,NX)
      N1=NX
      N2=NY
      N3=L
C
C     LOCATE ALL EXTERNAL BOUNDARIES AND SET BOUNDARY CONDITIONS
C     ENTERED IN 'READS'
C
      DO 9580 N=1,3
      DO 9575 NN=1,2
      IF(N.EQ.1)THEN
      N4=NX+1
      N5=NY
      N4B=NX-1
      N5B=NY
      N6=L
      IF(NN.EQ.1)THEN
      IF(NX.EQ.NHE)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX+1
      M5=NY
      M6=L
      XN=-1.0
      RCHQF=RCHQE(M2,M1)
      RCHGFU=RCHGEU(M2,M1)
      RCHGFT=RCHGET(M2,M1)
      ELSE
      GO TO 9575
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      IF(NX.EQ.NHW)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY
      M6=L
      XN=1.0
      RCHQF=RCHQW(M5,M4)
      RCHGFU=RCHGWU(M5,M4)
      RCHGFT=RCHGWT(M5,M4)
      ELSE
      GO TO 9575
      ENDIF
      ENDIF
      ELSEIF(N.EQ.2)THEN
      N4=NX
      N5=NY+1
      N4B=NX
      N5B=NY-1
      N6=L
      IF(NN.EQ.1)THEN
      IF(NY.EQ.NVS)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY+1
      M6=L
      XN=-1.0
      RCHQF=RCHQS(M2,M1)
      RCHGFU=RCHGSU(M2,M1)
      RCHGFT=RCHGST(M2,M1)
      ELSE
      GO TO 9575
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      IF(NY.EQ.NVN)THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY
      M6=L
      XN=1.0
      RCHQF=RCHQN(M5,M4)
      RCHGFU=RCHGNU(M5,M4)
      RCHGFT=RCHGNT(M5,M4)
      ELSE
      GO TO 9575
      ENDIF
      ENDIF
      ELSEIF(N.EQ.3)THEN
      N1=NX
      N2=NY
      N3=L
      N4=NX
      N5=NY
      N6=L+1
      IF(NN.EQ.1)THEN
      IF(L.EQ.NL(NY,NX))THEN
      M1=NX
      M2=NY
      M3=L
      M4=NX
      M5=NY
      M6=L+1
      XN=-1.0
      ELSE
      GO TO 9575
      ENDIF
      ELSEIF(NN.EQ.2)THEN
      GO TO 9575
      ENDIF
      ENDIF
C
C     SURFACE SOLUTE TRANSPORT FROM BOUNDARY SURFACE
C     RUNOFF IN WATSUB AND CONCENTRATIONS IN THE SURFACE SOIL LAYER
C
C
C     SURFACE SOLUTE TRANSPORT FROM BOUNDARY SURFACE
C     RUNOFF IN 'WATSUB' AND CONCENTRATIONS IN THE SURFACE SOIL LAYER
C
C     QRM =runoff from watsub.f 
C     RQR*=solute in runoff
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      IF(L.EQ.NUM(M2,M1).AND.N.NE.3)THEN
      IF(IRCHG(NN,N,N2,N1).EQ.0.OR.RCHQF.EQ.0.0
     2.OR.QRM(M,N2,N1).LE.ZEROS(N2,N1))THEN
      RQRAL(N,NN,M5,M4)=0.0
      RQRFE(N,NN,M5,M4)=0.0
      RQRHY(N,NN,M5,M4)=0.0
      RQRCA(N,NN,M5,M4)=0.0
      RQRMG(N,NN,M5,M4)=0.0
      RQRNA(N,NN,M5,M4)=0.0
      RQRKA(N,NN,M5,M4)=0.0
      RQROH(N,NN,M5,M4)=0.0
      RQRSO(N,NN,M5,M4)=0.0
      RQRCL(N,NN,M5,M4)=0.0
      RQRC3(N,NN,M5,M4)=0.0
      RQRHC(N,NN,M5,M4)=0.0
      RQRAL1(N,NN,M5,M4)=0.0
      RQRAL2(N,NN,M5,M4)=0.0
      RQRAL3(N,NN,M5,M4)=0.0
      RQRAL4(N,NN,M5,M4)=0.0
      RQRALS(N,NN,M5,M4)=0.0
      RQRFE1(N,NN,M5,M4)=0.0
      RQRFE2(N,NN,M5,M4)=0.0
      RQRFE3(N,NN,M5,M4)=0.0
      RQRFE4(N,NN,M5,M4)=0.0
      RQRFES(N,NN,M5,M4)=0.0
      RQRCAO(N,NN,M5,M4)=0.0
      RQRCAC(N,NN,M5,M4)=0.0
      RQRCAH(N,NN,M5,M4)=0.0
      RQRCAS(N,NN,M5,M4)=0.0
      RQRMGO(N,NN,M5,M4)=0.0
      RQRMGC(N,NN,M5,M4)=0.0
      RQRMGH(N,NN,M5,M4)=0.0
      RQRMGS(N,NN,M5,M4)=0.0
      RQRNAC(N,NN,M5,M4)=0.0
      RQRNAS(N,NN,M5,M4)=0.0
      RQRKAS(N,NN,M5,M4)=0.0
      RQRH0P(N,NN,M5,M4)=0.0
      RQRH3P(N,NN,M5,M4)=0.0
      RQRF1P(N,NN,M5,M4)=0.0
      RQRF2P(N,NN,M5,M4)=0.0
      RQRC0P(N,NN,M5,M4)=0.0
      RQRC1P(N,NN,M5,M4)=0.0
      RQRC2P(N,NN,M5,M4)=0.0
      RQRM1P(N,NN,M5,M4)=0.0
      ELSE
C
C     SOLUTE LOSS FROM RUNOFF DEPENDING ON ASPECT
C     AND BOUNDARY CONDITIONS SET IN SITE FILE
C
      IF((NN.EQ.1.AND.QRMN(M,N,NN,M5,M4).GT.ZEROS(N2,N1))
     2.OR.(NN.EQ.2.AND.QRMN(M,N,NN,M5,M4).LT.ZEROS(N2,N1)))THEN
      FQRM=QRMN(M,N,NN,M5,M4)/QRM(M,N2,N1)
      RQRAL(N,NN,M5,M4)=RQRAL0(N2,N1)*FQRM
      RQRFE(N,NN,M5,M4)=RQRFE0(N2,N1)*FQRM
      RQRHY(N,NN,M5,M4)=RQRHY0(N2,N1)*FQRM
      RQRCA(N,NN,M5,M4)=RQRCA0(N2,N1)*FQRM
      RQRMG(N,NN,M5,M4)=RQRMG0(N2,N1)*FQRM
      RQRNA(N,NN,M5,M4)=RQRNA0(N2,N1)*FQRM
      RQRKA(N,NN,M5,M4)=RQRKA0(N2,N1)*FQRM
      RQROH(N,NN,M5,M4)=RQROH0(N2,N1)*FQRM
      RQRSO(N,NN,M5,M4)=RQRSO0(N2,N1)*FQRM
      RQRCL(N,NN,M5,M4)=RQRCL0(N2,N1)*FQRM
      RQRC3(N,NN,M5,M4)=RQRC30(N2,N1)*FQRM
      RQRHC(N,NN,M5,M4)=RQRHC0(N2,N1)*FQRM
      RQRAL1(N,NN,M5,M4)=RQRAL10(N2,N1)*FQRM
      RQRAL2(N,NN,M5,M4)=RQRAL20(N2,N1)*FQRM
      RQRAL3(N,NN,M5,M4)=RQRAL30(N2,N1)*FQRM
      RQRAL4(N,NN,M5,M4)=RQRAL40(N2,N1)*FQRM
      RQRALS(N,NN,M5,M4)=RQRALS0(N2,N1)*FQRM
      RQRFE1(N,NN,M5,M4)=RQRFE10(N2,N1)*FQRM
      RQRFE2(N,NN,M5,M4)=RQRFE20(N2,N1)*FQRM
      RQRFE3(N,NN,M5,M4)=RQRFE30(N2,N1)*FQRM
      RQRFE4(N,NN,M5,M4)=RQRFE40(N2,N1)*FQRM
      RQRFES(N,NN,M5,M4)=RQRFES0(N2,N1)*FQRM
      RQRCAO(N,NN,M5,M4)=RQRCAO0(N2,N1)*FQRM
      RQRCAC(N,NN,M5,M4)=RQRCAC0(N2,N1)*FQRM
      RQRCAH(N,NN,M5,M4)=RQRCAH0(N2,N1)*FQRM
      RQRCAS(N,NN,M5,M4)=RQRCAS0(N2,N1)*FQRM
      RQRMGO(N,NN,M5,M4)=RQRMGO0(N2,N1)*FQRM
      RQRMGC(N,NN,M5,M4)=RQRMGC0(N2,N1)*FQRM
      RQRMGH(N,NN,M5,M4)=RQRMGH0(N2,N1)*FQRM
      RQRMGS(N,NN,M5,M4)=RQRMGS0(N2,N1)*FQRM
      RQRNAC(N,NN,M5,M4)=RQRNAC0(N2,N1)*FQRM
      RQRNAS(N,NN,M5,M4)=RQRNAS0(N2,N1)*FQRM
      RQRKAS(N,NN,M5,M4)=RQRKAS0(N2,N1)*FQRM
      RQRH0P(N,NN,M5,M4)=RQRH0P0(N2,N1)*FQRM
      RQRH3P(N,NN,M5,M4)=RQRH3P0(N2,N1)*FQRM
      RQRF1P(N,NN,M5,M4)=RQRF1P0(N2,N1)*FQRM
      RQRF2P(N,NN,M5,M4)=RQRF2P0(N2,N1)*FQRM
      RQRC0P(N,NN,M5,M4)=RQRC0P0(N2,N1)*FQRM
      RQRC1P(N,NN,M5,M4)=RQRC1P0(N2,N1)*FQRM
      RQRC2P(N,NN,M5,M4)=RQRC2P0(N2,N1)*FQRM
      RQRM1P(N,NN,M5,M4)=RQRM1P0(N2,N1)*FQRM
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*QRS=hourly solute in runoff
C     RQR*=solute in runoff
C
      XQRAL(N,NN,M5,M4)=XQRAL(N,NN,M5,M4)+RQRAL(N,NN,M5,M4)
      XQRFE(N,NN,M5,M4)=XQRFE(N,NN,M5,M4)+RQRFE(N,NN,M5,M4)
      XQRHY(N,NN,M5,M4)=XQRHY(N,NN,M5,M4)+RQRHY(N,NN,M5,M4)
      XQRCA(N,NN,M5,M4)=XQRCA(N,NN,M5,M4)+RQRCA(N,NN,M5,M4)
      XQRMG(N,NN,M5,M4)=XQRMG(N,NN,M5,M4)+RQRMG(N,NN,M5,M4)
      XQRNA(N,NN,M5,M4)=XQRNA(N,NN,M5,M4)+RQRNA(N,NN,M5,M4)
      XQRKA(N,NN,M5,M4)=XQRKA(N,NN,M5,M4)+RQRKA(N,NN,M5,M4)
      XQROH(N,NN,M5,M4)=XQROH(N,NN,M5,M4)+RQROH(N,NN,M5,M4)
      XQRSO(N,NN,M5,M4)=XQRSO(N,NN,M5,M4)+RQRSO(N,NN,M5,M4)
      XQRCL(N,NN,M5,M4)=XQRCL(N,NN,M5,M4)+RQRCL(N,NN,M5,M4)
      XQRC3(N,NN,M5,M4)=XQRC3(N,NN,M5,M4)+RQRC3(N,NN,M5,M4)
      XQRHC(N,NN,M5,M4)=XQRHC(N,NN,M5,M4)+RQRHC(N,NN,M5,M4)
      XQRAL1(N,NN,M5,M4)=XQRAL1(N,NN,M5,M4)+RQRAL1(N,NN,M5,M4)
      XQRAL2(N,NN,M5,M4)=XQRAL2(N,NN,M5,M4)+RQRAL2(N,NN,M5,M4)
      XQRAL3(N,NN,M5,M4)=XQRAL3(N,NN,M5,M4)+RQRAL3(N,NN,M5,M4)
      XQRAL4(N,NN,M5,M4)=XQRAL4(N,NN,M5,M4)+RQRAL4(N,NN,M5,M4)
      XQRALS(N,NN,M5,M4)=XQRALS(N,NN,M5,M4)+RQRALS(N,NN,M5,M4)
      XQRFE1(N,NN,M5,M4)=XQRFE1(N,NN,M5,M4)+RQRFE1(N,NN,M5,M4)
      XQRFE2(N,NN,M5,M4)=XQRFE2(N,NN,M5,M4)+RQRFE2(N,NN,M5,M4)
      XQRFE3(N,NN,M5,M4)=XQRFE3(N,NN,M5,M4)+RQRFE3(N,NN,M5,M4)
      XQRFE4(N,NN,M5,M4)=XQRFE4(N,NN,M5,M4)+RQRFE4(N,NN,M5,M4)
      XQRFES(N,NN,M5,M4)=XQRFES(N,NN,M5,M4)+RQRFES(N,NN,M5,M4)
      XQRCAO(N,NN,M5,M4)=XQRCAO(N,NN,M5,M4)+RQRCAO(N,NN,M5,M4)
      XQRCAC(N,NN,M5,M4)=XQRCAC(N,NN,M5,M4)+RQRCAC(N,NN,M5,M4)
      XQRCAH(N,NN,M5,M4)=XQRCAH(N,NN,M5,M4)+RQRCAH(N,NN,M5,M4)
      XQRCAS(N,NN,M5,M4)=XQRCAS(N,NN,M5,M4)+RQRCAS(N,NN,M5,M4)
      XQRMGO(N,NN,M5,M4)=XQRMGO(N,NN,M5,M4)+RQRMGO(N,NN,M5,M4)
      XQRMGC(N,NN,M5,M4)=XQRMGC(N,NN,M5,M4)+RQRMGC(N,NN,M5,M4)
      XQRMGH(N,NN,M5,M4)=XQRMGH(N,NN,M5,M4)+RQRMGH(N,NN,M5,M4)
      XQRMGS(N,NN,M5,M4)=XQRMGS(N,NN,M5,M4)+RQRMGS(N,NN,M5,M4)
      XQRNAC(N,NN,M5,M4)=XQRNAC(N,NN,M5,M4)+RQRNAC(N,NN,M5,M4)
      XQRNAS(N,NN,M5,M4)=XQRNAS(N,NN,M5,M4)+RQRNAS(N,NN,M5,M4)
      XQRKAS(N,NN,M5,M4)=XQRKAS(N,NN,M5,M4)+RQRKAS(N,NN,M5,M4)
      XQRH0P(N,NN,M5,M4)=XQRH0P(N,NN,M5,M4)+RQRH0P(N,NN,M5,M4)
      XQRH3P(N,NN,M5,M4)=XQRH3P(N,NN,M5,M4)+RQRH3P(N,NN,M5,M4)
      XQRF1P(N,NN,M5,M4)=XQRF1P(N,NN,M5,M4)+RQRF1P(N,NN,M5,M4)
      XQRF2P(N,NN,M5,M4)=XQRF2P(N,NN,M5,M4)+RQRF2P(N,NN,M5,M4)
      XQRC0P(N,NN,M5,M4)=XQRC0P(N,NN,M5,M4)+RQRC0P(N,NN,M5,M4)
      XQRC1P(N,NN,M5,M4)=XQRC1P(N,NN,M5,M4)+RQRC1P(N,NN,M5,M4)
      XQRC2P(N,NN,M5,M4)=XQRC2P(N,NN,M5,M4)+RQRC2P(N,NN,M5,M4)
      XQRM1P(N,NN,M5,M4)=XQRM1P(N,NN,M5,M4)+RQRM1P(N,NN,M5,M4)
C
C     SOLUTE GAIN FROM RUNON DEPENDING ON ASPECT
C     AND BOUNDARY CONDITIONS SET IN SITE FILE
C
      ELSEIF((NN.EQ.2.AND.QRMN(M,N,NN,M5,M4).GT.ZEROS(N2,N1))
     2.OR.(NN.EQ.1.AND.QRMN(M,N,NN,M5,M4).LT.ZEROS(N2,N1)))THEN
      RQRAL(N,NN,M5,M4)=0.0
      RQRFE(N,NN,M5,M4)=0.0
      RQRHY(N,NN,M5,M4)=0.0
      RQRCA(N,NN,M5,M4)=0.0
      RQRMG(N,NN,M5,M4)=0.0
      RQRNA(N,NN,M5,M4)=0.0
      RQRKA(N,NN,M5,M4)=0.0
      RQROH(N,NN,M5,M4)=0.0
      RQRSO(N,NN,M5,M4)=0.0
      RQRCL(N,NN,M5,M4)=0.0
      RQRC3(N,NN,M5,M4)=0.0
      RQRHC(N,NN,M5,M4)=0.0
      RQRAL1(N,NN,M5,M4)=0.0 
      RQRAL2(N,NN,M5,M4)=0.0
      RQRAL3(N,NN,M5,M4)=0.0 
      RQRAL4(N,NN,M5,M4)=0.0
      RQRALS(N,NN,M5,M4)=0.0
      RQRFE1(N,NN,M5,M4)=0.0
      RQRFE2(N,NN,M5,M4)=0.0
      RQRFE3(N,NN,M5,M4)=0.0
      RQRFE4(N,NN,M5,M4)=0.0
      RQRFES(N,NN,M5,M4)=0.0
      RQRCAO(N,NN,M5,M4)=0.0
      RQRCAC(N,NN,M5,M4)=0.0
      RQRCAH(N,NN,M5,M4)=0.0
      RQRCAS(N,NN,M5,M4)=0.0
      RQRMGO(N,NN,M5,M4)=0.0
      RQRMGC(N,NN,M5,M4)=0.0
      RQRMGH(N,NN,M5,M4)=0.0
      RQRMGS(N,NN,M5,M4)=0.0
      RQRNAC(N,NN,M5,M4)=0.0
      RQRNAS(N,NN,M5,M4)=0.0
      RQRKAS(N,NN,M5,M4)=0.0
      RQRH0P(N,NN,M5,M4)=0.0
      RQRH3P(N,NN,M5,M4)=0.0
      RQRF1P(N,NN,M5,M4)=0.0
      RQRF2P(N,NN,M5,M4)=0.0
      RQRC0P(N,NN,M5,M4)=0.0
      RQRC1P(N,NN,M5,M4)=0.0
      RQRC2P(N,NN,M5,M4)=0.0
      RQRM1P(N,NN,M5,M4)=0.0
      ELSE
      RQRAL(N,NN,M5,M4)=0.0
      RQRFE(N,NN,M5,M4)=0.0
      RQRHY(N,NN,M5,M4)=0.0
      RQRCA(N,NN,M5,M4)=0.0
      RQRMG(N,NN,M5,M4)=0.0
      RQRNA(N,NN,M5,M4)=0.0
      RQRKA(N,NN,M5,M4)=0.0
      RQROH(N,NN,M5,M4)=0.0
      RQRSO(N,NN,M5,M4)=0.0
      RQRCL(N,NN,M5,M4)=0.0
      RQRC3(N,NN,M5,M4)=0.0
      RQRHC(N,NN,M5,M4)=0.0
      RQRAL1(N,NN,M5,M4)=0.0 
      RQRAL2(N,NN,M5,M4)=0.0
      RQRAL3(N,NN,M5,M4)=0.0 
      RQRAL4(N,NN,M5,M4)=0.0
      RQRALS(N,NN,M5,M4)=0.0
      RQRFE1(N,NN,M5,M4)=0.0
      RQRFE2(N,NN,M5,M4)=0.0
      RQRFE3(N,NN,M5,M4)=0.0
      RQRFE4(N,NN,M5,M4)=0.0
      RQRFES(N,NN,M5,M4)=0.0
      RQRCAO(N,NN,M5,M4)=0.0
      RQRCAC(N,NN,M5,M4)=0.0
      RQRCAH(N,NN,M5,M4)=0.0
      RQRCAS(N,NN,M5,M4)=0.0
      RQRMGO(N,NN,M5,M4)=0.0
      RQRMGC(N,NN,M5,M4)=0.0
      RQRMGH(N,NN,M5,M4)=0.0
      RQRMGS(N,NN,M5,M4)=0.0
      RQRNAC(N,NN,M5,M4)=0.0
      RQRNAS(N,NN,M5,M4)=0.0
      RQRKAS(N,NN,M5,M4)=0.0
      RQRH0P(N,NN,M5,M4)=0.0
      RQRH3P(N,NN,M5,M4)=0.0
      RQRF1P(N,NN,M5,M4)=0.0
      RQRF2P(N,NN,M5,M4)=0.0
      RQRC0P(N,NN,M5,M4)=0.0
      RQRC1P(N,NN,M5,M4)=0.0
      RQRC2P(N,NN,M5,M4)=0.0
      RQRM1P(N,NN,M5,M4)=0.0
      ENDIF
      ENDIF
C
C     BOUNDARY SNOW FLUX
C
      IF(NN.EQ.1)THEN
      RQSAL(N,M5,M4)=0.0
      RQSFE(N,M5,M4)=0.0
      RQSHY(N,M5,M4)=0.0
      RQSCA(N,M5,M4)=0.0
      RQSMG(N,M5,M4)=0.0
      RQSNA(N,M5,M4)=0.0
      RQSKA(N,M5,M4)=0.0
      RQSOH(N,M5,M4)=0.0
      RQSSO(N,M5,M4)=0.0
      RQSCL(N,M5,M4)=0.0
      RQSC3(N,M5,M4)=0.0
      RQSHC(N,M5,M4)=0.0
      RQSAL1(N,M5,M4)=0.0 
      RQSAL2(N,M5,M4)=0.0
      RQSAL3(N,M5,M4)=0.0 
      RQSAL4(N,M5,M4)=0.0
      RQSALS(N,M5,M4)=0.0
      RQSFE1(N,M5,M4)=0.0
      RQSFE2(N,M5,M4)=0.0
      RQSFE3(N,M5,M4)=0.0
      RQSFE4(N,M5,M4)=0.0
      RQSFES(N,M5,M4)=0.0
      RQSCAO(N,M5,M4)=0.0
      RQSCAC(N,M5,M4)=0.0
      RQSCAH(N,M5,M4)=0.0
      RQSCAS(N,M5,M4)=0.0
      RQSMGO(N,M5,M4)=0.0
      RQSMGC(N,M5,M4)=0.0
      RQSMGH(N,M5,M4)=0.0
      RQSMGS(N,M5,M4)=0.0
      RQSNAC(N,M5,M4)=0.0
      RQSNAS(N,M5,M4)=0.0
      RQSKAS(N,M5,M4)=0.0
      RQSH0P(N,M5,M4)=0.0
      RQSH3P(N,M5,M4)=0.0
      RQSF1P(N,M5,M4)=0.0
      RQSF2P(N,M5,M4)=0.0
      RQSC0P(N,M5,M4)=0.0
      RQSC1P(N,M5,M4)=0.0
      RQSC2P(N,M5,M4)=0.0
      RQSM1P(N,M5,M4)=0.0
      ENDIF
      ENDIF
C
C     SOLUTE LOSS WITH SUBSURFACE MICROPORE WATER LOSS
C
C     FLWM=water flux through soil micropore from watsub.f 
C     VOLWM=micropore water-filled porosity from watsub.f
C     R*FLS=convective solute flux through micropores
C     R*FLW,R*FLB=convective solute flux through micropores in non-band,band
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      IF(VOLX(N3,N2,N1).GT.ZEROS(NY,NX))THEN
      IF(NCN(M2,M1).NE.3.OR.N.EQ.3)THEN
      IF(NN.EQ.1.AND.FLWM(M,N,M6,M5,M4).GT.0.0
     2.OR.NN.EQ.2.AND.FLWM(M,N,M6,M5,M4).LT.0.0)THEN
      IF(VOLWM(M,M3,M2,M1).GT.ZEROS2(M2,M1))THEN
      VFLW=AMAX1(-VFLWX,AMIN1(VFLWX,FLWM(M,N,M6,M5,M4)
     2/VOLWM(M,M3,M2,M1)))
      ELSE
      VFLW=0.0 
      ENDIF
      RALFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZAL2(M3,M2,M1))
      RFEFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFE2(M3,M2,M1))
      RHYFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZHY2(M3,M2,M1))
      RCAFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCA2(M3,M2,M1))
      RMGFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZMG2(M3,M2,M1))
      RNAFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNA2(M3,M2,M1))
      RKAFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZKA2(M3,M2,M1))
      ROHFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZOH2(M3,M2,M1))
      RSOFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZSO42(M3,M2,M1))
      RCLFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCL2(M3,M2,M1))
      RC3FLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCO32(M3,M2,M1))
      RHCFLS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZHCO32(M3,M2,M1))
      RAL1FS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZAL12(M3,M2,M1))
      RAL2FS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZAL22(M3,M2,M1))
      RAL3FS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZAL32(M3,M2,M1))
      RAL4FS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZAL42(M3,M2,M1))
      RALSFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZALS2(M3,M2,M1))
      RFE1FS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFE12(M3,M2,M1))
      RFE2FS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFE22(M3,M2,M1))
      RFE3FS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFE32(M3,M2,M1))
      RFE4FS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFE42(M3,M2,M1))
      RFESFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFES2(M3,M2,M1))
      RCAOFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCAO2(M3,M2,M1))
      RCACFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCAC2(M3,M2,M1))
      RCAHFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCAH2(M3,M2,M1))
      RCASFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCAS2(M3,M2,M1))
      RMGOFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZMGO2(M3,M2,M1))
      RMGCFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZMGC2(M3,M2,M1))
      RMGHFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZMGH2(M3,M2,M1))
      RMGSFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZMGS2(M3,M2,M1))
      RNACFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNAC2(M3,M2,M1))
      RNASFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNAS2(M3,M2,M1))
      RKASFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZKAS2(M3,M2,M1))
      RH0PFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H0PO42(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RH3PFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H3PO42(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RF1PFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFE1P2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RF2PFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFE2P2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RC0PFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCA0P2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RC1PFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCA1P2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RC2PFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCA2P2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RM1PFS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZMG1P2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RH0BFB(N,M6,M5,M4)=VFLW*AMAX1(0.0,H0POB2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RH3BFB(N,M6,M5,M4)=VFLW*AMAX1(0.0,H3POB2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RF1BFB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZF1PB2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RF2BFB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZF2PB2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RC0BFB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZC0PB2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RC1BFB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZC1PB2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RC2BFB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZC2PB2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RM1BFB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZM1PB2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
C
C     SOLUTE GAIN WITH SUBSURFACE MICROPORE WATER GAIN
C
      ELSE
      RALFLS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CALU(M3,M2,M1)
      RFEFLS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CFEU(M3,M2,M1)
      RHYFLS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CHYU(M3,M2,M1)
      RCAFLS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CCAU(M3,M2,M1)
      RMGFLS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CMGU(M3,M2,M1)
      RNAFLS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CNAU(M3,M2,M1)
      RKAFLS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CKAU(M3,M2,M1)
      ROHFLS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*COHU(M3,M2,M1)
      RSOFLS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CSOU(M3,M2,M1)
      RCLFLS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CCLU(M3,M2,M1)
      RC3FLS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CC3U(M3,M2,M1)
      RHCFLS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CHCU(M3,M2,M1)
      RAL1FS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CAL1U(M3,M2,M1)
      RAL2FS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CAL2U(M3,M2,M1)
      RAL3FS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CAL3U(M3,M2,M1)
      RAL4FS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CAL4U(M3,M2,M1)
      RALSFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CALSU(M3,M2,M1)
      RFE1FS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CFE1U(M3,M2,M1)
      RFE2FS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CFE2U(M3,M2,M1)
      RFE3FS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CFE3U(M3,M2,M1)
      RFE4FS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CFE4U(M3,M2,M1)
      RFESFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CFESU(M3,M2,M1)
      RCAOFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CCAOU(M3,M2,M1)
      RCACFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CCACU(M3,M2,M1)
      RCAHFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CCAHU(M3,M2,M1)
      RCASFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CCASU(M3,M2,M1)
      RMGOFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CMGOU(M3,M2,M1)
      RMGCFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CMGCU(M3,M2,M1)
      RMGHFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CMGHU(M3,M2,M1)
      RMGSFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CMGSU(M3,M2,M1)
      RNACFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CNACU(M3,M2,M1)
      RNASFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CNASU(M3,M2,M1)
      RKASFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CKASU(M3,M2,M1)
      RH0PFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CH0PU(M3,M2,M1)
     2*VLPO4(M3,M2,M1)
      RH3PFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CH3PU(M3,M2,M1)
     2*VLPO4(M3,M2,M1)
      RF1PFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CF1PU(M3,M2,M1)
     2*VLPO4(M3,M2,M1)
      RF2PFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CF2PU(M3,M2,M1)
     2*VLPO4(M3,M2,M1)
      RC0PFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CC0PU(M3,M2,M1)
     2*VLPO4(M3,M2,M1)
      RC1PFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CC1PU(M3,M2,M1)
     2*VLPO4(M3,M2,M1)
      RC2PFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CC2PU(M3,M2,M1)
     2*VLPO4(M3,M2,M1)
      RM1PFS(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CM1PU(M3,M2,M1)
     2*VLPO4(M3,M2,M1)
      RH0BFB(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CH0PU(M3,M2,M1)
     2*VLPOB(M3,M2,M1)
      RH3BFB(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CH3PU(M3,M2,M1)
     2*VLPOB(M3,M2,M1)
      RF1BFB(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CF1PU(M3,M2,M1)
     2*VLPOB(M3,M2,M1)
      RF2BFB(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CF2PU(M3,M2,M1)
     2*VLPOB(M3,M2,M1)
      RC0BFB(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CC0PU(M3,M2,M1)
     2*VLPOB(M3,M2,M1)
      RC1BFB(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CC1PU(M3,M2,M1)
     2*VLPOB(M3,M2,M1)
      RC2BFB(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CC2PU(M3,M2,M1)
     2*VLPOB(M3,M2,M1)
      RM1BFB(N,M6,M5,M4)=FLWM(M,N,M6,M5,M4)*CM1PU(M3,M2,M1)
     2*VLPOB(M3,M2,M1)
      ENDIF
C
C     SOLUTE LOSS WITH SUBSURFACE MACROPORE WATER LOSS
C
C     FLWHM=water flux through soil macropore from watsub.f 
C     VOLWHM=macropore water-filled porosity from watsub.f
C     RFH*S=solute diffusive flux through macropore
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      IF(NN.EQ.1.AND.FLWHM(M,N,M6,M5,M4).GT.0.0
     2.OR.NN.EQ.2.AND.FLWHM(M,N,M6,M5,M4).LT.0.0)THEN
      IF(VOLWHM(M,M3,M2,M1).GT.ZEROS2(M2,M1))THEN
      VFLW=AMAX1(-VFLWX,AMIN1(VFLWX,FLWHM(M,N,M6,M5,M4)
     2/VOLWHM(M,M3,M2,M1)))
      ELSE
      VFLW=0.0 
      ENDIF
      RALFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZALH2(M3,M2,M1))
      RFEFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFEH2(M3,M2,M1))
      RHYFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZHYH2(M3,M2,M1))
      RCAFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCCH2(M3,M2,M1))
      RMGFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZMAH2(M3,M2,M1))
      RNAFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNAH2(M3,M2,M1))
      RKAFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZKAH2(M3,M2,M1))
      ROHFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZOHH2(M3,M2,M1)) 
      RSOFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZSO4H2(M3,M2,M1))
      RCLFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCLH2(M3,M2,M1))
      RC3FHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCO3H2(M3,M2,M1))
      RHCFHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZHCOH2(M3,M2,M1))
      RAL1HS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZAL1H2(M3,M2,M1))
      RAL2HS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZAL2H2(M3,M2,M1))
      RAL3HS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZAL3H2(M3,M2,M1))
      RAL4HS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZAL4H2(M3,M2,M1))
      RALSHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZALSH2(M3,M2,M1))
      RFE1HS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFE1H2(M3,M2,M1))
      RFE2HS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFE2H2(M3,M2,M1))
      RFE3HS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFE3H2(M3,M2,M1))
      RFE4HS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFE4H2(M3,M2,M1))
      RFESHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZFESH2(M3,M2,M1))
      RCAOHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCAOH2(M3,M2,M1))
      RCACHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCACH2(M3,M2,M1))
      RCAHHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCAHH2(M3,M2,M1))
      RCASHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZCASH2(M3,M2,M1))
      RMGOHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZMGOH2(M3,M2,M1))
      RMGCHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZMGCH2(M3,M2,M1))
      RMGHHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZMGHH2(M3,M2,M1))
      RMGSHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZMGSH2(M3,M2,M1))
      RNACHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNACH2(M3,M2,M1))
      RNASHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZNASH2(M3,M2,M1))
      RKASHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZKASH2(M3,M2,M1))
      RH0PHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H0P4H2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RH3PHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,H3P4H2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RF1PHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZF1PH2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RF2PHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZF2PH2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RC0PHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZC0PH2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RC1PHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZC1PH2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RC2PHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZC2PH2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RM1PHS(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZM1PH2(M3,M2,M1))
     2*VLPO4(M3,M2,M1)
      RH0BHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,H0PBH2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RH3BHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,H3PBH2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RF1BHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZF1BH2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RF2BHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZF2BH2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RC0BHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZC0BH2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RC1BHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZC1BH2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RC2BHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZC2BH2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
      RM1BHB(N,M6,M5,M4)=VFLW*AMAX1(0.0,ZM1BH2(M3,M2,M1))
     2*VLPOB(M3,M2,M1)
C
C     NO SOLUTE GAIN IN SUBSURFACE MACROPORES
C
      ELSE
      RALFHS(N,M6,M5,M4)=0.0
      RFEFHS(N,M6,M5,M4)=0.0
      RHYFHS(N,M6,M5,M4)=0.0
      RCAFHS(N,M6,M5,M4)=0.0
      RMGFHS(N,M6,M5,M4)=0.0
      RNAFHS(N,M6,M5,M4)=0.0
      RKAFHS(N,M6,M5,M4)=0.0
      ROHFHS(N,M6,M5,M4)=0.0
      RSOFHS(N,M6,M5,M4)=0.0
      RCLFHS(N,M6,M5,M4)=0.0
      RC3FHS(N,M6,M5,M4)=0.0
      RHCFHS(N,M6,M5,M4)=0.0
      RAL1HS(N,M6,M5,M4)=0.0
      RAL2HS(N,M6,M5,M4)=0.0
      RAL3HS(N,M6,M5,M4)=0.0
      RAL4HS(N,M6,M5,M4)=0.0
      RALSHS(N,M6,M5,M4)=0.0
      RFE1HS(N,M6,M5,M4)=0.0
      RFE2HS(N,M6,M5,M4)=0.0
      RFE3HS(N,M6,M5,M4)=0.0
      RFE4HS(N,M6,M5,M4)=0.0
      RFESHS(N,M6,M5,M4)=0.0
      RCAOHS(N,M6,M5,M4)=0.0
      RCACHS(N,M6,M5,M4)=0.0
      RCAHHS(N,M6,M5,M4)=0.0
      RCASHS(N,M6,M5,M4)=0.0
      RMGOHS(N,M6,M5,M4)=0.0
      RMGCHS(N,M6,M5,M4)=0.0
      RMGHHS(N,M6,M5,M4)=0.0
      RMGSHS(N,M6,M5,M4)=0.0
      RNACHS(N,M6,M5,M4)=0.0
      RNASHS(N,M6,M5,M4)=0.0
      RKASHS(N,M6,M5,M4)=0.0
      RH0PHS(N,M6,M5,M4)=0.0
      RH3PHS(N,M6,M5,M4)=0.0
      RF1PHS(N,M6,M5,M4)=0.0
      RF2PHS(N,M6,M5,M4)=0.0
      RC0PHS(N,M6,M5,M4)=0.0
      RC1PHS(N,M6,M5,M4)=0.0
      RC2PHS(N,M6,M5,M4)=0.0
      RM1PHS(N,M6,M5,M4)=0.0
      RH0BHB(N,M6,M5,M4)=0.0
      RH3BHB(N,M6,M5,M4)=0.0
      RF1BHB(N,M6,M5,M4)=0.0
      RF2BHB(N,M6,M5,M4)=0.0
      RC0BHB(N,M6,M5,M4)=0.0
      RC1BHB(N,M6,M5,M4)=0.0
      RC2BHB(N,M6,M5,M4)=0.0
      RM1BHB(N,M6,M5,M4)=0.0
      ENDIF
C
C     ACCUMULATE HOURLY FLUXES FOR USE IN REDIST.F
C
C     X*FLS,X*FLW,X*FLB=hourly solute flux in non-band,band micropores 
C     X*FHS,X*FHW,X*FHB=hourly solute flux in non-band,band macropores 
C     R*FLS,R*FLW,R*FLB=solute flux in non-band,band micropores 
C     R*FHS,R*FHW,R*FHB=solute flux in non-band,band macropores 
C
      XALFLS(N,M6,M5,M4)=XALFLS(N,M6,M5,M4)+RALFLS(N,M6,M5,M4)
      XFEFLS(N,M6,M5,M4)=XFEFLS(N,M6,M5,M4)+RFEFLS(N,M6,M5,M4)
      XHYFLS(N,M6,M5,M4)=XHYFLS(N,M6,M5,M4)+RHYFLS(N,M6,M5,M4)
      XCAFLS(N,M6,M5,M4)=XCAFLS(N,M6,M5,M4)+RCAFLS(N,M6,M5,M4)
      XMGFLS(N,M6,M5,M4)=XMGFLS(N,M6,M5,M4)+RMGFLS(N,M6,M5,M4)
      XNAFLS(N,M6,M5,M4)=XNAFLS(N,M6,M5,M4)+RNAFLS(N,M6,M5,M4)
      XKAFLS(N,M6,M5,M4)=XKAFLS(N,M6,M5,M4)+RKAFLS(N,M6,M5,M4)
      XOHFLS(N,M6,M5,M4)=XOHFLS(N,M6,M5,M4)+ROHFLS(N,M6,M5,M4)
      XSOFLS(N,M6,M5,M4)=XSOFLS(N,M6,M5,M4)+RSOFLS(N,M6,M5,M4)
      XCLFLS(N,M6,M5,M4)=XCLFLS(N,M6,M5,M4)+RCLFLS(N,M6,M5,M4)
      XC3FLS(N,M6,M5,M4)=XC3FLS(N,M6,M5,M4)+RC3FLS(N,M6,M5,M4)
      XHCFLS(N,M6,M5,M4)=XHCFLS(N,M6,M5,M4)+RHCFLS(N,M6,M5,M4)
      XAL1FS(N,M6,M5,M4)=XAL1FS(N,M6,M5,M4)+RAL1FS(N,M6,M5,M4)
      XAL2FS(N,M6,M5,M4)=XAL2FS(N,M6,M5,M4)+RAL2FS(N,M6,M5,M4)
      XAL3FS(N,M6,M5,M4)=XAL3FS(N,M6,M5,M4)+RAL3FS(N,M6,M5,M4)
      XAL4FS(N,M6,M5,M4)=XAL4FS(N,M6,M5,M4)+RAL4FS(N,M6,M5,M4)
      XALSFS(N,M6,M5,M4)=XALSFS(N,M6,M5,M4)+RALSFS(N,M6,M5,M4)
      XFE1FS(N,M6,M5,M4)=XFE1FS(N,M6,M5,M4)+RFE1FS(N,M6,M5,M4)
      XFE2FS(N,M6,M5,M4)=XFE2FS(N,M6,M5,M4)+RFE2FS(N,M6,M5,M4)
      XFE3FS(N,M6,M5,M4)=XFE3FS(N,M6,M5,M4)+RFE3FS(N,M6,M5,M4)
      XFE4FS(N,M6,M5,M4)=XFE4FS(N,M6,M5,M4)+RFE4FS(N,M6,M5,M4)
      XFESFS(N,M6,M5,M4)=XFESFS(N,M6,M5,M4)+RFESFS(N,M6,M5,M4)
      XCAOFS(N,M6,M5,M4)=XCAOFS(N,M6,M5,M4)+RCAOFS(N,M6,M5,M4)
      XCACFS(N,M6,M5,M4)=XCACFS(N,M6,M5,M4)+RCACFS(N,M6,M5,M4)
      XCAHFS(N,M6,M5,M4)=XCAHFS(N,M6,M5,M4)+RCAHFS(N,M6,M5,M4)
      XCASFS(N,M6,M5,M4)=XCASFS(N,M6,M5,M4)+RCASFS(N,M6,M5,M4)
      XMGOFS(N,M6,M5,M4)=XMGOFS(N,M6,M5,M4)+RMGOFS(N,M6,M5,M4)
      XMGCFS(N,M6,M5,M4)=XMGCFS(N,M6,M5,M4)+RMGCFS(N,M6,M5,M4)
      XMGHFS(N,M6,M5,M4)=XMGHFS(N,M6,M5,M4)+RMGHFS(N,M6,M5,M4)
      XMGSFS(N,M6,M5,M4)=XMGSFS(N,M6,M5,M4)+RMGSFS(N,M6,M5,M4)
      XNACFS(N,M6,M5,M4)=XNACFS(N,M6,M5,M4)+RNACFS(N,M6,M5,M4)
      XNASFS(N,M6,M5,M4)=XNASFS(N,M6,M5,M4)+RNASFS(N,M6,M5,M4)
      XKASFS(N,M6,M5,M4)=XKASFS(N,M6,M5,M4)+RKASFS(N,M6,M5,M4)
      XH0PFS(N,M6,M5,M4)=XH0PFS(N,M6,M5,M4)+RH0PFS(N,M6,M5,M4)
      XH3PFS(N,M6,M5,M4)=XH3PFS(N,M6,M5,M4)+RH3PFS(N,M6,M5,M4)
      XF1PFS(N,M6,M5,M4)=XF1PFS(N,M6,M5,M4)+RF1PFS(N,M6,M5,M4)
      XF2PFS(N,M6,M5,M4)=XF2PFS(N,M6,M5,M4)+RF2PFS(N,M6,M5,M4)
      XC0PFS(N,M6,M5,M4)=XC0PFS(N,M6,M5,M4)+RC0PFS(N,M6,M5,M4)
      XC1PFS(N,M6,M5,M4)=XC1PFS(N,M6,M5,M4)+RC1PFS(N,M6,M5,M4)
      XC2PFS(N,M6,M5,M4)=XC2PFS(N,M6,M5,M4)+RC2PFS(N,M6,M5,M4)
      XM1PFS(N,M6,M5,M4)=XM1PFS(N,M6,M5,M4)+RM1PFS(N,M6,M5,M4)
      XH0BFB(N,M6,M5,M4)=XH0BFB(N,M6,M5,M4)+RH0BFB(N,M6,M5,M4)
      XH3BFB(N,M6,M5,M4)=XH3BFB(N,M6,M5,M4)+RH3BFB(N,M6,M5,M4)
      XF1BFB(N,M6,M5,M4)=XF1BFB(N,M6,M5,M4)+RF1BFB(N,M6,M5,M4)
      XF2BFB(N,M6,M5,M4)=XF2BFB(N,M6,M5,M4)+RF2BFB(N,M6,M5,M4)
      XC0BFB(N,M6,M5,M4)=XC0BFB(N,M6,M5,M4)+RC0BFB(N,M6,M5,M4)
      XC1BFB(N,M6,M5,M4)=XC1BFB(N,M6,M5,M4)+RC1BFB(N,M6,M5,M4)
      XC2BFB(N,M6,M5,M4)=XC2BFB(N,M6,M5,M4)+RC2BFB(N,M6,M5,M4)
      XM1BFB(N,M6,M5,M4)=XM1BFB(N,M6,M5,M4)+RM1BFB(N,M6,M5,M4)
      XALFHS(N,M6,M5,M4)=XALFHS(N,M6,M5,M4)+RALFHS(N,M6,M5,M4)
      XFEFHS(N,M6,M5,M4)=XFEFHS(N,M6,M5,M4)+RFEFHS(N,M6,M5,M4)
      XHYFHS(N,M6,M5,M4)=XHYFHS(N,M6,M5,M4)+RHYFHS(N,M6,M5,M4)
      XCAFHS(N,M6,M5,M4)=XCAFHS(N,M6,M5,M4)+RCAFHS(N,M6,M5,M4)
      XMGFHS(N,M6,M5,M4)=XMGFHS(N,M6,M5,M4)+RMGFHS(N,M6,M5,M4)
      XNAFHS(N,M6,M5,M4)=XNAFHS(N,M6,M5,M4)+RNAFHS(N,M6,M5,M4)
      XKAFHS(N,M6,M5,M4)=XKAFHS(N,M6,M5,M4)+RKAFHS(N,M6,M5,M4)
      XOHFHS(N,M6,M5,M4)=XOHFHS(N,M6,M5,M4)+ROHFHS(N,M6,M5,M4)
      XSOFHS(N,M6,M5,M4)=XSOFHS(N,M6,M5,M4)+RSOFHS(N,M6,M5,M4)
      XCLFHS(N,M6,M5,M4)=XCLFHS(N,M6,M5,M4)+RCLFHS(N,M6,M5,M4)
      XC3FHS(N,M6,M5,M4)=XC3FHS(N,M6,M5,M4)+RC3FHS(N,M6,M5,M4)
      XHCFHS(N,M6,M5,M4)=XHCFHS(N,M6,M5,M4)+RHCFHS(N,M6,M5,M4)
      XAL1HS(N,M6,M5,M4)=XAL1HS(N,M6,M5,M4)+RAL1HS(N,M6,M5,M4)
      XAL2HS(N,M6,M5,M4)=XAL2HS(N,M6,M5,M4)+RAL2HS(N,M6,M5,M4)
      XAL3HS(N,M6,M5,M4)=XAL3HS(N,M6,M5,M4)+RAL3HS(N,M6,M5,M4)
      XAL4HS(N,M6,M5,M4)=XAL4HS(N,M6,M5,M4)+RAL4HS(N,M6,M5,M4)
      XALSHS(N,M6,M5,M4)=XALSHS(N,M6,M5,M4)+RALSHS(N,M6,M5,M4)
      XFE1HS(N,M6,M5,M4)=XFE1HS(N,M6,M5,M4)+RFE1HS(N,M6,M5,M4)
      XFE2HS(N,M6,M5,M4)=XFE2HS(N,M6,M5,M4)+RFE2HS(N,M6,M5,M4)
      XFE3HS(N,M6,M5,M4)=XFE3HS(N,M6,M5,M4)+RFE3HS(N,M6,M5,M4)
      XFE4HS(N,M6,M5,M4)=XFE4HS(N,M6,M5,M4)+RFE4HS(N,M6,M5,M4)
      XFESHS(N,M6,M5,M4)=XFESHS(N,M6,M5,M4)+RFESHS(N,M6,M5,M4)
      XCAOHS(N,M6,M5,M4)=XCAOHS(N,M6,M5,M4)+RCAOHS(N,M6,M5,M4)
      XCACHS(N,M6,M5,M4)=XCACHS(N,M6,M5,M4)+RCACHS(N,M6,M5,M4)
      XCAHHS(N,M6,M5,M4)=XCAHHS(N,M6,M5,M4)+RCAHHS(N,M6,M5,M4)
      XCASHS(N,M6,M5,M4)=XCASHS(N,M6,M5,M4)+RCASHS(N,M6,M5,M4)
      XMGOHS(N,M6,M5,M4)=XMGOHS(N,M6,M5,M4)+RMGOHS(N,M6,M5,M4)
      XMGCHS(N,M6,M5,M4)=XMGCHS(N,M6,M5,M4)+RMGCHS(N,M6,M5,M4)
      XMGHHS(N,M6,M5,M4)=XMGHHS(N,M6,M5,M4)+RMGHHS(N,M6,M5,M4)
      XMGSHS(N,M6,M5,M4)=XMGSHS(N,M6,M5,M4)+RMGSHS(N,M6,M5,M4)
      XNACHS(N,M6,M5,M4)=XNACHS(N,M6,M5,M4)+RNACHS(N,M6,M5,M4)
      XNASHS(N,M6,M5,M4)=XNASHS(N,M6,M5,M4)+RNASHS(N,M6,M5,M4)
      XKASHS(N,M6,M5,M4)=XKASHS(N,M6,M5,M4)+RKASHS(N,M6,M5,M4)
      XH0PHS(N,M6,M5,M4)=XH0PHS(N,M6,M5,M4)+RH0PHS(N,M6,M5,M4)
      XH3PHS(N,M6,M5,M4)=XH3PHS(N,M6,M5,M4)+RH3PHS(N,M6,M5,M4)
      XF1PHS(N,M6,M5,M4)=XF1PHS(N,M6,M5,M4)+RF1PHS(N,M6,M5,M4)
      XF2PHS(N,M6,M5,M4)=XF2PHS(N,M6,M5,M4)+RF2PHS(N,M6,M5,M4)
      XC0PHS(N,M6,M5,M4)=XC0PHS(N,M6,M5,M4)+RC0PHS(N,M6,M5,M4)
      XC1PHS(N,M6,M5,M4)=XC1PHS(N,M6,M5,M4)+RC1PHS(N,M6,M5,M4)
      XC2PHS(N,M6,M5,M4)=XC2PHS(N,M6,M5,M4)+RC2PHS(N,M6,M5,M4)
      XM1PHS(N,M6,M5,M4)=XM1PHS(N,M6,M5,M4)+RM1PHS(N,M6,M5,M4)
      XH0BHB(N,M6,M5,M4)=XH0BHB(N,M6,M5,M4)+RH0BHB(N,M6,M5,M4)
      XH3BHB(N,M6,M5,M4)=XH3BHB(N,M6,M5,M4)+RH3BHB(N,M6,M5,M4)
      XF1BHB(N,M6,M5,M4)=XF1BHB(N,M6,M5,M4)+RF1BHB(N,M6,M5,M4)
      XF2BHB(N,M6,M5,M4)=XF2BHB(N,M6,M5,M4)+RF2BHB(N,M6,M5,M4)
      XC0BHB(N,M6,M5,M4)=XC0BHB(N,M6,M5,M4)+RC0BHB(N,M6,M5,M4)
      XC1BHB(N,M6,M5,M4)=XC1BHB(N,M6,M5,M4)+RC1BHB(N,M6,M5,M4)
      XC2BHB(N,M6,M5,M4)=XC2BHB(N,M6,M5,M4)+RC2BHB(N,M6,M5,M4)
      XM1BHB(N,M6,M5,M4)=XM1BHB(N,M6,M5,M4)+RM1BHB(N,M6,M5,M4)
      ENDIF
      ENDIF
9575  CONTINUE
C
C     TOTAL SOLUTE FLUXES IN EACH GRID CELL
C
      IF(L.EQ.NUM(N2,N1))THEN
      IF(N.NE.3)THEN
C
C     NET OVERLAND SOLUTE FLUX IN WATER
C
C     TQR*=net overland solute flux
C     RQR*=overland solute flux
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      DO 1202 NN=1,2
      TQRAL(N2,N1)=TQRAL(N2,N1)+RQRAL(N,NN,N2,N1)
      TQRFE(N2,N1)=TQRFE(N2,N1)+RQRFE(N,NN,N2,N1)
      TQRHY(N2,N1)=TQRHY(N2,N1)+RQRHY(N,NN,N2,N1)
      TQRCA(N2,N1)=TQRCA(N2,N1)+RQRCA(N,NN,N2,N1)
      TQRMG(N2,N1)=TQRMG(N2,N1)+RQRMG(N,NN,N2,N1)
      TQRNA(N2,N1)=TQRNA(N2,N1)+RQRNA(N,NN,N2,N1)
      TQRKA(N2,N1)=TQRKA(N2,N1)+RQRKA(N,NN,N2,N1)
      TQROH(N2,N1)=TQROH(N2,N1)+RQROH(N,NN,N2,N1)
      TQRSO(N2,N1)=TQRSO(N2,N1)+RQRSO(N,NN,N2,N1)
      TQRCL(N2,N1)=TQRCL(N2,N1)+RQRCL(N,NN,N2,N1)
      TQRC3(N2,N1)=TQRC3(N2,N1)+RQRC3(N,NN,N2,N1)
      TQRHC(N2,N1)=TQRHC(N2,N1)+RQRHC(N,NN,N2,N1)
      TQRAL1(N2,N1)=TQRAL1(N2,N1)+RQRAL1(N,NN,N2,N1)
      TQRAL2(N2,N1)=TQRAL2(N2,N1)+RQRAL2(N,NN,N2,N1)
      TQRAL3(N2,N1)=TQRAL3(N2,N1)+RQRAL3(N,NN,N2,N1)
      TQRAL4(N2,N1)=TQRAL4(N2,N1)+RQRAL4(N,NN,N2,N1)
      TQRALS(N2,N1)=TQRALS(N2,N1)+RQRALS(N,NN,N2,N1)
      TQRFE1(N2,N1)=TQRFE1(N2,N1)+RQRFE1(N,NN,N2,N1)
      TQRFE2(N2,N1)=TQRFE2(N2,N1)+RQRFE2(N,NN,N2,N1)
      TQRFE3(N2,N1)=TQRFE3(N2,N1)+RQRFE3(N,NN,N2,N1)
      TQRFE4(N2,N1)=TQRFE4(N2,N1)+RQRFE4(N,NN,N2,N1)
      TQRFES(N2,N1)=TQRFES(N2,N1)+RQRFES(N,NN,N2,N1)
      TQRCAO(N2,N1)=TQRCAO(N2,N1)+RQRCAO(N,NN,N2,N1)
      TQRCAC(N2,N1)=TQRCAC(N2,N1)+RQRCAC(N,NN,N2,N1)
      TQRCAH(N2,N1)=TQRCAH(N2,N1)+RQRCAH(N,NN,N2,N1)
      TQRCAS(N2,N1)=TQRCAS(N2,N1)+RQRCAS(N,NN,N2,N1)
      TQRMGO(N2,N1)=TQRMGO(N2,N1)+RQRMGO(N,NN,N2,N1)
      TQRMGC(N2,N1)=TQRMGC(N2,N1)+RQRMGC(N,NN,N2,N1)
      TQRMGH(N2,N1)=TQRMGH(N2,N1)+RQRMGH(N,NN,N2,N1)
      TQRMGS(N2,N1)=TQRMGS(N2,N1)+RQRMGS(N,NN,N2,N1)
      TQRNAC(N2,N1)=TQRNAC(N2,N1)+RQRNAC(N,NN,N2,N1)
      TQRNAS(N2,N1)=TQRNAS(N2,N1)+RQRNAS(N,NN,N2,N1)
      TQRKAS(N2,N1)=TQRKAS(N2,N1)+RQRKAS(N,NN,N2,N1)
      TQRH0P(N2,N1)=TQRH0P(N2,N1)+RQRH0P(N,NN,N2,N1)
      TQRH3P(N2,N1)=TQRH3P(N2,N1)+RQRH3P(N,NN,N2,N1)
      TQRF1P(N2,N1)=TQRF1P(N2,N1)+RQRF1P(N,NN,N2,N1)
      TQRF2P(N2,N1)=TQRF2P(N2,N1)+RQRF2P(N,NN,N2,N1)
      TQRC0P(N2,N1)=TQRC0P(N2,N1)+RQRC0P(N,NN,N2,N1)
      TQRC1P(N2,N1)=TQRC1P(N2,N1)+RQRC1P(N,NN,N2,N1)
      TQRC2P(N2,N1)=TQRC2P(N2,N1)+RQRC2P(N,NN,N2,N1)
      TQRM1P(N2,N1)=TQRM1P(N2,N1)+RQRM1P(N,NN,N2,N1) 
      IF(IFLBM(M,N,NN,N5,N4).EQ.0)THEN
      TQRAL(N2,N1)=TQRAL(N2,N1)-RQRAL(N,NN,N5,N4)
      TQRFE(N2,N1)=TQRFE(N2,N1)-RQRFE(N,NN,N5,N4)
      TQRHY(N2,N1)=TQRHY(N2,N1)-RQRHY(N,NN,N5,N4)
      TQRCA(N2,N1)=TQRCA(N2,N1)-RQRCA(N,NN,N5,N4)
      TQRMG(N2,N1)=TQRMG(N2,N1)-RQRMG(N,NN,N5,N4)
      TQRNA(N2,N1)=TQRNA(N2,N1)-RQRNA(N,NN,N5,N4)
      TQRKA(N2,N1)=TQRKA(N2,N1)-RQRKA(N,NN,N5,N4)
      TQROH(N2,N1)=TQROH(N2,N1)-RQROH(N,NN,N5,N4)
      TQRSO(N2,N1)=TQRSO(N2,N1)-RQRSO(N,NN,N5,N4)
      TQRCL(N2,N1)=TQRCL(N2,N1)-RQRCL(N,NN,N5,N4)
      TQRC3(N2,N1)=TQRC3(N2,N1)-RQRC3(N,NN,N5,N4)
      TQRHC(N2,N1)=TQRHC(N2,N1)-RQRHC(N,NN,N5,N4)
      TQRAL1(N2,N1)=TQRAL1(N2,N1)-RQRAL1(N,NN,N5,N4)
      TQRAL2(N2,N1)=TQRAL2(N2,N1)-RQRAL2(N,NN,N5,N4)
      TQRAL3(N2,N1)=TQRAL3(N2,N1)-RQRAL3(N,NN,N5,N4)
      TQRAL4(N2,N1)=TQRAL4(N2,N1)-RQRAL4(N,NN,N5,N4)
      TQRALS(N2,N1)=TQRALS(N2,N1)-RQRALS(N,NN,N5,N4)
      TQRFE1(N2,N1)=TQRFE1(N2,N1)-RQRFE1(N,NN,N5,N4)
      TQRFE2(N2,N1)=TQRFE2(N2,N1)-RQRFE2(N,NN,N5,N4)
      TQRFE3(N2,N1)=TQRFE3(N2,N1)-RQRFE3(N,NN,N5,N4)
      TQRFE4(N2,N1)=TQRFE4(N2,N1)-RQRFE4(N,NN,N5,N4)
      TQRFES(N2,N1)=TQRFES(N2,N1)-RQRFES(N,NN,N5,N4)
      TQRCAO(N2,N1)=TQRCAO(N2,N1)-RQRCAO(N,NN,N5,N4)
      TQRCAC(N2,N1)=TQRCAC(N2,N1)-RQRCAC(N,NN,N5,N4)
      TQRCAH(N2,N1)=TQRCAH(N2,N1)-RQRCAH(N,NN,N5,N4)
      TQRCAS(N2,N1)=TQRCAS(N2,N1)-RQRCAS(N,NN,N5,N4)
      TQRMGO(N2,N1)=TQRMGO(N2,N1)-RQRMGO(N,NN,N5,N4)
      TQRMGC(N2,N1)=TQRMGC(N2,N1)-RQRMGC(N,NN,N5,N4)
      TQRMGH(N2,N1)=TQRMGH(N2,N1)-RQRMGH(N,NN,N5,N4)
      TQRMGS(N2,N1)=TQRMGS(N2,N1)-RQRMGS(N,NN,N5,N4)
      TQRNAC(N2,N1)=TQRNAC(N2,N1)-RQRNAC(N,NN,N5,N4)
      TQRNAS(N2,N1)=TQRNAS(N2,N1)-RQRNAS(N,NN,N5,N4)
      TQRKAS(N2,N1)=TQRKAS(N2,N1)-RQRKAS(N,NN,N5,N4)
      TQRH0P(N2,N1)=TQRH0P(N2,N1)-RQRH0P(N,NN,N5,N4)
      TQRH3P(N2,N1)=TQRH3P(N2,N1)-RQRH3P(N,NN,N5,N4)
      TQRF1P(N2,N1)=TQRF1P(N2,N1)-RQRF1P(N,NN,N5,N4)
      TQRF2P(N2,N1)=TQRF2P(N2,N1)-RQRF2P(N,NN,N5,N4)
      TQRC0P(N2,N1)=TQRC0P(N2,N1)-RQRC0P(N,NN,N5,N4)
      TQRC1P(N2,N1)=TQRC1P(N2,N1)-RQRC1P(N,NN,N5,N4)
      TQRC2P(N2,N1)=TQRC2P(N2,N1)-RQRC2P(N,NN,N5,N4)
      TQRM1P(N2,N1)=TQRM1P(N2,N1)-RQRM1P(N,NN,N5,N4)
      ENDIF
      IF(N4B.GT.0.AND.N5B.GT.0.AND.NN.EQ.1)THEN
      TQRAL(N2,N1)=TQRAL(N2,N1)-RQRAL(N,NN,N5B,N4B)
      TQRFE(N2,N1)=TQRFE(N2,N1)-RQRFE(N,NN,N5B,N4B)
      TQRHY(N2,N1)=TQRHY(N2,N1)-RQRHY(N,NN,N5B,N4B)
      TQRCA(N2,N1)=TQRCA(N2,N1)-RQRCA(N,NN,N5B,N4B)
      TQRMG(N2,N1)=TQRMG(N2,N1)-RQRMG(N,NN,N5B,N4B)
      TQRNA(N2,N1)=TQRNA(N2,N1)-RQRNA(N,NN,N5B,N4B)
      TQRKA(N2,N1)=TQRKA(N2,N1)-RQRKA(N,NN,N5B,N4B)
      TQROH(N2,N1)=TQROH(N2,N1)-RQROH(N,NN,N5B,N4B)
      TQRSO(N2,N1)=TQRSO(N2,N1)-RQRSO(N,NN,N5B,N4B)
      TQRCL(N2,N1)=TQRCL(N2,N1)-RQRCL(N,NN,N5B,N4B)
      TQRC3(N2,N1)=TQRC3(N2,N1)-RQRC3(N,NN,N5B,N4B)
      TQRHC(N2,N1)=TQRHC(N2,N1)-RQRHC(N,NN,N5B,N4B)
      TQRAL1(N2,N1)=TQRAL1(N2,N1)-RQRAL1(N,NN,N5B,N4B)
      TQRAL2(N2,N1)=TQRAL2(N2,N1)-RQRAL2(N,NN,N5B,N4B)
      TQRAL3(N2,N1)=TQRAL3(N2,N1)-RQRAL3(N,NN,N5B,N4B)
      TQRAL4(N2,N1)=TQRAL4(N2,N1)-RQRAL4(N,NN,N5B,N4B)
      TQRALS(N2,N1)=TQRALS(N2,N1)-RQRALS(N,NN,N5B,N4B)
      TQRFE1(N2,N1)=TQRFE1(N2,N1)-RQRFE1(N,NN,N5B,N4B)
      TQRFE2(N2,N1)=TQRFE2(N2,N1)-RQRFE2(N,NN,N5B,N4B)
      TQRFE3(N2,N1)=TQRFE3(N2,N1)-RQRFE3(N,NN,N5B,N4B)
      TQRFE4(N2,N1)=TQRFE4(N2,N1)-RQRFE4(N,NN,N5B,N4B)
      TQRFES(N2,N1)=TQRFES(N2,N1)-RQRFES(N,NN,N5B,N4B)
      TQRCAO(N2,N1)=TQRCAO(N2,N1)-RQRCAO(N,NN,N5B,N4B)
      TQRCAC(N2,N1)=TQRCAC(N2,N1)-RQRCAC(N,NN,N5B,N4B)
      TQRCAH(N2,N1)=TQRCAH(N2,N1)-RQRCAH(N,NN,N5B,N4B)
      TQRCAS(N2,N1)=TQRCAS(N2,N1)-RQRCAS(N,NN,N5B,N4B)
      TQRMGO(N2,N1)=TQRMGO(N2,N1)-RQRMGO(N,NN,N5B,N4B)
      TQRMGC(N2,N1)=TQRMGC(N2,N1)-RQRMGC(N,NN,N5B,N4B)
      TQRMGH(N2,N1)=TQRMGH(N2,N1)-RQRMGH(N,NN,N5B,N4B)
      TQRMGS(N2,N1)=TQRMGS(N2,N1)-RQRMGS(N,NN,N5B,N4B)
      TQRNAC(N2,N1)=TQRNAC(N2,N1)-RQRNAC(N,NN,N5B,N4B)
      TQRNAS(N2,N1)=TQRNAS(N2,N1)-RQRNAS(N,NN,N5B,N4B)
      TQRKAS(N2,N1)=TQRKAS(N2,N1)-RQRKAS(N,NN,N5B,N4B)
      TQRH0P(N2,N1)=TQRH0P(N2,N1)-RQRH0P(N,NN,N5B,N4B)
      TQRH3P(N2,N1)=TQRH3P(N2,N1)-RQRH3P(N,NN,N5B,N4B)
      TQRF1P(N2,N1)=TQRF1P(N2,N1)-RQRF1P(N,NN,N5B,N4B)
      TQRF2P(N2,N1)=TQRF2P(N2,N1)-RQRF2P(N,NN,N5B,N4B)
      TQRC0P(N2,N1)=TQRC0P(N2,N1)-RQRC0P(N,NN,N5B,N4B)
      TQRC1P(N2,N1)=TQRC1P(N2,N1)-RQRC1P(N,NN,N5B,N4B)
      TQRC2P(N2,N1)=TQRC2P(N2,N1)-RQRC2P(N,NN,N5B,N4B)
      TQRM1P(N2,N1)=TQRM1P(N2,N1)-RQRM1P(N,NN,N5B,N4B)
      ENDIF
1202  CONTINUE
C
C     NET OVERLAND SOLUTE FLUX IN SNOW
C
C     TQS*=net solute flux in snow transfer
C     RQS*=solute flux in snow transfer
C
      TQSAL(N2,N1)=TQSAL(N2,N1)+RQSAL(N,N2,N1)-RQSAL(N,N5,N4)
      TQSFE(N2,N1)=TQSFE(N2,N1)+RQSFE(N,N2,N1)-RQSFE(N,N5,N4)
      TQSHY(N2,N1)=TQSHY(N2,N1)+RQSHY(N,N2,N1)-RQSHY(N,N5,N4)
      TQSCA(N2,N1)=TQSCA(N2,N1)+RQSCA(N,N2,N1)-RQSCA(N,N5,N4)
      TQSMG(N2,N1)=TQSMG(N2,N1)+RQSMG(N,N2,N1)-RQSMG(N,N5,N4)
      TQSNA(N2,N1)=TQSNA(N2,N1)+RQSNA(N,N2,N1)-RQSNA(N,N5,N4)
      TQSKA(N2,N1)=TQSKA(N2,N1)+RQSKA(N,N2,N1)-RQSKA(N,N5,N4)
      TQSOH(N2,N1)=TQSOH(N2,N1)+RQSOH(N,N2,N1)-RQSOH(N,N5,N4)
      TQSSO(N2,N1)=TQSSO(N2,N1)+RQSSO(N,N2,N1)-RQSSO(N,N5,N4)
      TQSCL(N2,N1)=TQSCL(N2,N1)+RQSCL(N,N2,N1)-RQSCL(N,N5,N4)
      TQSC3(N2,N1)=TQSC3(N2,N1)+RQSC3(N,N2,N1)-RQSC3(N,N5,N4)
      TQSHC(N2,N1)=TQSHC(N2,N1)+RQSHC(N,N2,N1)-RQSHC(N,N5,N4)
      TQSAL1(N2,N1)=TQSAL1(N2,N1)+RQSAL1(N,N2,N1)-RQSAL1(N,N5,N4)
      TQSAL2(N2,N1)=TQSAL2(N2,N1)+RQSAL2(N,N2,N1)-RQSAL2(N,N5,N4)
      TQSAL3(N2,N1)=TQSAL3(N2,N1)+RQSAL3(N,N2,N1)-RQSAL3(N,N5,N4)
      TQSAL4(N2,N1)=TQSAL4(N2,N1)+RQSAL4(N,N2,N1)-RQSAL4(N,N5,N4)
      TQSALS(N2,N1)=TQSALS(N2,N1)+RQSALS(N,N2,N1)-RQSALS(N,N5,N4)
      TQSFE1(N2,N1)=TQSFE1(N2,N1)+RQSFE1(N,N2,N1)-RQSFE1(N,N5,N4)
      TQSFE2(N2,N1)=TQSFE2(N2,N1)+RQSFE2(N,N2,N1)-RQSFE2(N,N5,N4)
      TQSFE3(N2,N1)=TQSFE3(N2,N1)+RQSFE3(N,N2,N1)-RQSFE3(N,N5,N4)
      TQSFE4(N2,N1)=TQSFE4(N2,N1)+RQSFE4(N,N2,N1)-RQSFE4(N,N5,N4)
      TQSFES(N2,N1)=TQSFES(N2,N1)+RQSFES(N,N2,N1)-RQSFES(N,N5,N4)
      TQSCAO(N2,N1)=TQSCAO(N2,N1)+RQSCAO(N,N2,N1)-RQSCAO(N,N5,N4)
      TQSCAC(N2,N1)=TQSCAC(N2,N1)+RQSCAC(N,N2,N1)-RQSCAC(N,N5,N4)
      TQSCAH(N2,N1)=TQSCAH(N2,N1)+RQSCAH(N,N2,N1)-RQSCAH(N,N5,N4)
      TQSCAS(N2,N1)=TQSCAS(N2,N1)+RQSCAS(N,N2,N1)-RQSCAS(N,N5,N4)
      TQSMGO(N2,N1)=TQSMGO(N2,N1)+RQSMGO(N,N2,N1)-RQSMGO(N,N5,N4)
      TQSMGC(N2,N1)=TQSMGC(N2,N1)+RQSMGC(N,N2,N1)-RQSMGC(N,N5,N4)
      TQSMGH(N2,N1)=TQSMGH(N2,N1)+RQSMGH(N,N2,N1)-RQSMGH(N,N5,N4)
      TQSMGS(N2,N1)=TQSMGS(N2,N1)+RQSMGS(N,N2,N1)-RQSMGS(N,N5,N4)
      TQSNAC(N2,N1)=TQSNAC(N2,N1)+RQSNAC(N,N2,N1)-RQSNAC(N,N5,N4)
      TQSNAS(N2,N1)=TQSNAS(N2,N1)+RQSNAS(N,N2,N1)-RQSNAS(N,N5,N4)
      TQSKAS(N2,N1)=TQSKAS(N2,N1)+RQSKAS(N,N2,N1)-RQSKAS(N,N5,N4)
      TQSH0P(N2,N1)=TQSH0P(N2,N1)+RQSH0P(N,N2,N1)-RQSH0P(N,N5,N4)
      TQSH3P(N2,N1)=TQSH3P(N2,N1)+RQSH3P(N,N2,N1)-RQSH3P(N,N5,N4)
      TQSF1P(N2,N1)=TQSF1P(N2,N1)+RQSF1P(N,N2,N1)-RQSF1P(N,N5,N4)
      TQSF2P(N2,N1)=TQSF2P(N2,N1)+RQSF2P(N,N2,N1)-RQSF2P(N,N5,N4)
      TQSC0P(N2,N1)=TQSC0P(N2,N1)+RQSC0P(N,N2,N1)-RQSC0P(N,N5,N4)
      TQSC1P(N2,N1)=TQSC1P(N2,N1)+RQSC1P(N,N2,N1)-RQSC1P(N,N5,N4)
      TQSC2P(N2,N1)=TQSC2P(N2,N1)+RQSC2P(N,N2,N1)-RQSC2P(N,N5,N4)
      TQSM1P(N2,N1)=TQSM1P(N2,N1)+RQSM1P(N,N2,N1)-RQSM1P(N,N5,N4)
C
C     NET SOLUTE FLUX IN SNOWPACK
C
C     VHCPWM,VHCPWX=current,minimum volumetric heat capacity of snowpack
C     T*BLS=net solute flux in snowpack
C     R*BLS=solute flux in snowpack
C
      ELSEIF(N.EQ.3)THEN
      DO 1205 LS=1,JS
      IF(VHCPWM(M,LS,NY,NX).GT.VHCPWX(NY,NX))THEN
      LS2=MIN(JS,LS+1)
C
C     IF LOWER LAYER IS IN THE SNOWPACK
C
      IF(LS.LT.JS.AND.VHCPWM(M,LS2,N2,N1).GT.VHCPWX(N2,N1))THEN
      TALBLS(LS,NY,NX)=TALBLS(LS,NY,NX)+RALBLS(LS,NY,NX)
     2-RALBLS(LS2,NY,NX)
      TFEBLS(LS,NY,NX)=TFEBLS(LS,NY,NX)+RFEBLS(LS,NY,NX)
     2-RFEBLS(LS2,NY,NX)
      THYBLS(LS,NY,NX)=THYBLS(LS,NY,NX)+RHYBLS(LS,NY,NX)
     2-RHYBLS(LS2,NY,NX)
      TCABLS(LS,NY,NX)=TCABLS(LS,NY,NX)+RCABLS(LS,NY,NX)
     2-RCABLS(LS2,NY,NX)
      TMGBLS(LS,NY,NX)=TMGBLS(LS,NY,NX)+RMGBLS(LS,NY,NX)
     2-RMGBLS(LS2,NY,NX)
      TNABLS(LS,NY,NX)=TNABLS(LS,NY,NX)+RNABLS(LS,NY,NX)
     2-RNABLS(LS2,NY,NX)
      TKABLS(LS,NY,NX)=TKABLS(LS,NY,NX)+RKABLS(LS,NY,NX)
     2-RKABLS(LS2,NY,NX)
      TOHBLS(LS,NY,NX)=TOHBLS(LS,NY,NX)+ROHBLS(LS,NY,NX)
     2-ROHBLS(LS2,NY,NX)
      TSOBLS(LS,NY,NX)=TSOBLS(LS,NY,NX)+RSOBLS(LS,NY,NX)
     2-RSOBLS(LS2,NY,NX)
      TCLBLS(LS,NY,NX)=TCLBLS(LS,NY,NX)+RCLBLS(LS,NY,NX)
     2-RCLBLS(LS2,NY,NX)
      TC3BLS(LS,NY,NX)=TC3BLS(LS,NY,NX)+RC3BLS(LS,NY,NX)
     2-RC3BLS(LS2,NY,NX)
      THCBLS(LS,NY,NX)=THCBLS(LS,NY,NX)+RHCBLS(LS,NY,NX)
     2-RHCBLS(LS2,NY,NX)
      TAL1BS(LS,NY,NX)=TAL1BS(LS,NY,NX)+RAL1BS(LS,NY,NX)
     2-RAL1BS(LS2,NY,NX)
      TAL2BS(LS,NY,NX)=TAL2BS(LS,NY,NX)+RAL2BS(LS,NY,NX)
     2-RAL2BS(LS2,NY,NX)
      TAL3BS(LS,NY,NX)=TAL3BS(LS,NY,NX)+RAL3BS(LS,NY,NX)
     2-RAL3BS(LS2,NY,NX)
      TAL4BS(LS,NY,NX)=TAL4BS(LS,NY,NX)+RAL4BS(LS,NY,NX)
     2-RAL4BS(LS2,NY,NX)
      TALSBS(LS,NY,NX)=TALSBS(LS,NY,NX)+RALSBS(LS,NY,NX)
     2-RALSBS(LS2,NY,NX)
      TFE1BS(LS,NY,NX)=TFE1BS(LS,NY,NX)+RFE1BS(LS,NY,NX)
     2-RFE1BS(LS2,NY,NX)
      TFE2BS(LS,NY,NX)=TFE2BS(LS,NY,NX)+RFE2BS(LS,NY,NX)
     2-RFE2BS(LS2,NY,NX)
      TFE3BS(LS,NY,NX)=TFE3BS(LS,NY,NX)+RFE3BS(LS,NY,NX)
     2-RFE3BS(LS2,NY,NX)
      TFE4BS(LS,NY,NX)=TFE4BS(LS,NY,NX)+RFE4BS(LS,NY,NX)
     2-RFE4BS(LS2,NY,NX)
      TFESBS(LS,NY,NX)=TFESBS(LS,NY,NX)+RFESBS(LS,NY,NX)
     2-RFESBS(LS2,NY,NX)
      TCAOBS(LS,NY,NX)=TCAOBS(LS,NY,NX)+RCAOBS(LS,NY,NX)
     2-RCAOBS(LS2,NY,NX)
      TCACBS(LS,NY,NX)=TCACBS(LS,NY,NX)+RCACBS(LS,NY,NX)
     2-RCACBS(LS2,NY,NX)
      TCAHBS(LS,NY,NX)=TCAHBS(LS,NY,NX)+RCAHBS(LS,NY,NX)
     2-RCAHBS(LS2,NY,NX)
      TCASBS(LS,NY,NX)=TCASBS(LS,NY,NX)+RCASBS(LS,NY,NX)
     2-RCASBS(LS2,NY,NX)
      TMGOBS(LS,NY,NX)=TMGOBS(LS,NY,NX)+RMGOBS(LS,NY,NX)
     2-RMGOBS(LS2,NY,NX)
      TMGCBS(LS,NY,NX)=TMGCBS(LS,NY,NX)+RMGCBS(LS,NY,NX)
     2-RMGCBS(LS2,NY,NX)
      TMGHBS(LS,NY,NX)=TMGHBS(LS,NY,NX)+RMGHBS(LS,NY,NX)
     2-RMGHBS(LS2,NY,NX)
      TMGSBS(LS,NY,NX)=TMGSBS(LS,NY,NX)+RMGSBS(LS,NY,NX)
     2-RMGSBS(LS2,NY,NX)
      TNACBS(LS,NY,NX)=TNACBS(LS,NY,NX)+RNACBS(LS,NY,NX)
     2-RNACBS(LS2,NY,NX)
      TNASBS(LS,NY,NX)=TNASBS(LS,NY,NX)+RNASBS(LS,NY,NX)
     2-RNASBS(LS2,NY,NX)
      TKASBS(LS,NY,NX)=TKASBS(LS,NY,NX)+RKASBS(LS,NY,NX)
     2-RKASBS(LS2,NY,NX)
      TH0PBS(LS,NY,NX)=TH0PBS(LS,NY,NX)+RH0PBS(LS,NY,NX)
     2-RH0PBS(LS2,NY,NX)
      TH3PBS(LS,NY,NX)=TH3PBS(LS,NY,NX)+RH3PBS(LS,NY,NX)
     2-RH3PBS(LS2,NY,NX)
      TF1PBS(LS,NY,NX)=TF1PBS(LS,NY,NX)+RF1PBS(LS,NY,NX)
     2-RF1PBS(LS2,NY,NX)
      TF2PBS(LS,NY,NX)=TF2PBS(LS,NY,NX)+RF2PBS(LS,NY,NX)
     2-RF2PBS(LS2,NY,NX)
      TC0PBS(LS,NY,NX)=TC0PBS(LS,NY,NX)+RC0PBS(LS,NY,NX)
     2-RC0PBS(LS2,NY,NX)
      TC1PBS(LS,NY,NX)=TC1PBS(LS,NY,NX)+RC1PBS(LS,NY,NX)
     2-RC1PBS(LS2,NY,NX)
      TC2PBS(LS,NY,NX)=TC2PBS(LS,NY,NX)+RC2PBS(LS,NY,NX)
     2-RC2PBS(LS2,NY,NX)
      TM1PBS(LS,NY,NX)=TM1PBS(LS,NY,NX)+RM1PBS(LS,NY,NX)
     2-RM1PBS(LS2,NY,NX)
      ELSE
C
C     IF LOWER LAYER IS THE LITTER AND SOIL SURFACE
C
      TALBLS(LS,NY,NX)=TALBLS(LS,NY,NX)+RALBLS(LS,NY,NX)
     2-RALFLS(3,0,N2,N1)-RALFLS(3,NUM(N2,N1),N2,N1)
C    3-RALFHS(3,NUM(N2,N1),N2,N1)
      TFEBLS(LS,NY,NX)=TFEBLS(LS,NY,NX)+RFEBLS(LS,NY,NX)
     2-RFEFLS(3,0,N2,N1)-RFEFLS(3,NUM(N2,N1),N2,N1)
C    3-RFEFHS(3,NUM(N2,N1),N2,N1)
      THYBLS(LS,NY,NX)=THYBLS(LS,NY,NX)+RHYBLS(LS,NY,NX)
     2-RHYFLS(3,0,N2,N1)-RHYFLS(3,NUM(N2,N1),N2,N1)
C    3-RHYFHS(3,NUM(N2,N1),N2,N1)
      TCABLS(LS,NY,NX)=TCABLS(LS,NY,NX)+RCABLS(LS,NY,NX)
     2-RCAFLS(3,0,N2,N1)-RCAFLS(3,NUM(N2,N1),N2,N1)
C    3-RCAFHS(3,NUM(N2,N1),N2,N1)
      TMGBLS(LS,NY,NX)=TMGBLS(LS,NY,NX)+RMGBLS(LS,NY,NX)
     2-RMGFLS(3,0,N2,N1)-RMGFLS(3,NUM(N2,N1),N2,N1)
C    3-RMGFHS(3,NUM(N2,N1),N2,N1)
      TNABLS(LS,NY,NX)=TNABLS(LS,NY,NX)+RNABLS(LS,NY,NX)
     2-RNAFLS(3,0,N2,N1)-RNAFLS(3,NUM(N2,N1),N2,N1)
C    3-RNAFHS(3,NUM(N2,N1),N2,N1)
      TKABLS(LS,NY,NX)=TKABLS(LS,NY,NX)+RKABLS(LS,NY,NX)
     2-RKAFLS(3,0,N2,N1)-RKAFLS(3,NUM(N2,N1),N2,N1)
C    3-RKAFHS(3,NUM(N2,N1),N2,N1)
      TOHBLS(LS,NY,NX)=TOHBLS(LS,NY,NX)+ROHBLS(LS,NY,NX)
     2-ROHFLS(3,0,N2,N1)-ROHFLS(3,NUM(N2,N1),N2,N1)
C    3-ROHFHS(3,NUM(N2,N1),N2,N1)
      TSOBLS(LS,NY,NX)=TSOBLS(LS,NY,NX)+RSOBLS(LS,NY,NX)
     2-RSOFLS(3,0,N2,N1)-RSOFLS(3,NUM(N2,N1),N2,N1)
C    3-RSOFHS(3,NUM(N2,N1),N2,N1)
      TCLBLS(LS,NY,NX)=TCLBLS(LS,NY,NX)+RCLBLS(LS,NY,NX)
     2-RCLFLS(3,0,N2,N1)-RCLFLS(3,NUM(N2,N1),N2,N1)
C    3-RCLFHS(3,NUM(N2,N1),N2,N1)
      TC3BLS(LS,NY,NX)=TC3BLS(LS,NY,NX)+RC3BLS(LS,NY,NX)
     2-RC3FLS(3,0,N2,N1)-RC3FLS(3,NUM(N2,N1),N2,N1)
C    3-RC3FHS(3,NUM(N2,N1),N2,N1)
      THCBLS(LS,NY,NX)=THCBLS(LS,NY,NX)+RHCBLS(LS,NY,NX)
     2-RHCFLS(3,0,N2,N1)-RHCFLS(3,NUM(N2,N1),N2,N1)
C    3-RHCFHS(3,NUM(N2,N1),N2,N1)
      TAL1BS(LS,NY,NX)=TAL1BS(LS,NY,NX)+RAL1BS(LS,NY,NX)
     2-RAL1FS(3,0,N2,N1)-RAL1FS(3,NUM(N2,N1),N2,N1)
C    3-RAL1HS(3,NUM(N2,N1),N2,N1)
      TAL2BS(LS,NY,NX)=TAL2BS(LS,NY,NX)+RAL2BS(LS,NY,NX)
     2-RAL2FS(3,0,N2,N1)-RAL2FS(3,NUM(N2,N1),N2,N1)
C    3-RAL2HS(3,NUM(N2,N1),N2,N1)
      TAL3BS(LS,NY,NX)=TAL3BS(LS,NY,NX)+RAL3BS(LS,NY,NX)
     2-RAL3FS(3,0,N2,N1)-RAL3FS(3,NUM(N2,N1),N2,N1)
C    3-RAL3HS(3,NUM(N2,N1),N2,N1)
      TAL4BS(LS,NY,NX)=TAL4BS(LS,NY,NX)+RAL4BS(LS,NY,NX)
     2-RAL4FS(3,0,N2,N1)-RAL4FS(3,NUM(N2,N1),N2,N1)
C    3-RAL4HS(3,NUM(N2,N1),N2,N1)
      TALSBS(LS,NY,NX)=TALSBS(LS,NY,NX)+RALSBS(LS,NY,NX)
     2-RALSFS(3,0,N2,N1)-RALSFS(3,NUM(N2,N1),N2,N1)
C    3-RALSHS(3,NUM(N2,N1),N2,N1)
      TFE1BS(LS,NY,NX)=TFE1BS(LS,NY,NX)+RFE1BS(LS,NY,NX)
     2-RFE1FS(3,0,N2,N1)-RFE1FS(3,NUM(N2,N1),N2,N1)
C    3-RFE1HS(3,NUM(N2,N1),N2,N1)
      TFE2BS(LS,NY,NX)=TFE2BS(LS,NY,NX)+RFE2BS(LS,NY,NX)
     2-RFE2FS(3,0,N2,N1)-RFE2FS(3,NUM(N2,N1),N2,N1)
C    3-RFE2HS(3,NUM(N2,N1),N2,N1)
      TFE3BS(LS,NY,NX)=TFE3BS(LS,NY,NX)+RFE3BS(LS,NY,NX)
     2-RFE3FS(3,0,N2,N1)-RFE3FS(3,NUM(N2,N1),N2,N1)
C    3-RFE3HS(3,NUM(N2,N1),N2,N1)
      TFE4BS(LS,NY,NX)=TFE4BS(LS,NY,NX)+RFE4BS(LS,NY,NX)
     2-RFE4FS(3,0,N2,N1)-RFE4FS(3,NUM(N2,N1),N2,N1)
C    3-RFE4HS(3,NUM(N2,N1),N2,N1)
      TFESBS(LS,NY,NX)=TFESBS(LS,NY,NX)+RFESBS(LS,NY,NX)
     2-RFESFS(3,0,N2,N1)-RFESFS(3,NUM(N2,N1),N2,N1)
C    3-RFESHS(3,NUM(N2,N1),N2,N1)
      TCAOBS(LS,NY,NX)=TCAOBS(LS,NY,NX)+RCAOBS(LS,NY,NX)
     2-RCAOFS(3,0,N2,N1)-RCAOFS(3,NUM(N2,N1),N2,N1)
C    3-RCAOHS(3,NUM(N2,N1),N2,N1)
      TCACBS(LS,NY,NX)=TCACBS(LS,NY,NX)+RCACBS(LS,NY,NX)
     2-RCACFS(3,0,N2,N1)-RCACFS(3,NUM(N2,N1),N2,N1)
C    3-RCACHS(3,NUM(N2,N1),N2,N1)
      TCAHBS(LS,NY,NX)=TCAHBS(LS,NY,NX)+RCAHBS(LS,NY,NX)
     2-RCAHFS(3,0,N2,N1)-RCAHFS(3,NUM(N2,N1),N2,N1)
C    3-RCAHHS(3,NUM(N2,N1),N2,N1)
      TCASBS(LS,NY,NX)=TCASBS(LS,NY,NX)+RCASBS(LS,NY,NX)
     2-RCASFS(3,0,N2,N1)-RCASFS(3,NUM(N2,N1),N2,N1)
C    3-RCASHS(3,NUM(N2,N1),N2,N1)
      TMGOBS(LS,NY,NX)=TMGOBS(LS,NY,NX)+RMGOBS(LS,NY,NX)
     2-RMGOFS(3,0,N2,N1)-RMGOFS(3,NUM(N2,N1),N2,N1)
C    3-RMGOHS(3,NUM(N2,N1),N2,N1)
      TMGCBS(LS,NY,NX)=TMGCBS(LS,NY,NX)+RMGCBS(LS,NY,NX)
     2-RMGCFS(3,0,N2,N1)-RMGCFS(3,NUM(N2,N1),N2,N1)
C    3-RMGCHS(3,NUM(N2,N1),N2,N1)
      TMGHBS(LS,NY,NX)=TMGHBS(LS,NY,NX)+RMGHBS(LS,NY,NX)
     2-RMGHFS(3,0,N2,N1)-RMGHFS(3,NUM(N2,N1),N2,N1)
C    3-RMGHHS(3,NUM(N2,N1),N2,N1)
      TMGSBS(LS,NY,NX)=TMGSBS(LS,NY,NX)+RMGSBS(LS,NY,NX)
     2-RMGSFS(3,0,N2,N1)-RMGSFS(3,NUM(N2,N1),N2,N1)
C    3-RMGSHS(3,NUM(N2,N1),N2,N1)
      TNACBS(LS,NY,NX)=TNACBS(LS,NY,NX)+RNACBS(LS,NY,NX)
     2-RNACFS(3,0,N2,N1)-RNACFS(3,NUM(N2,N1),N2,N1)
C    3-RNACHS(3,NUM(N2,N1),N2,N1)
      TNASBS(LS,NY,NX)=TNASBS(LS,NY,NX)+RNASBS(LS,NY,NX)
     2-RNASFS(3,0,N2,N1)-RNASFS(3,NUM(N2,N1),N2,N1)
C    3-RNASHS(3,NUM(N2,N1),N2,N1)
      TKASBS(LS,NY,NX)=TKASBS(LS,NY,NX)+RKASBS(LS,NY,NX)
     2-RKASFS(3,0,N2,N1)-RKASFS(3,NUM(N2,N1),N2,N1)
C    3-RKASHS(3,NUM(N2,N1),N2,N1)
      TH0PBS(LS,NY,NX)=TH0PBS(LS,NY,NX)+RH0PBS(LS,NY,NX)
     2-RH0PFS(3,0,N2,N1)-RH0PFS(3,NUM(N2,N1),N2,N1)
     3-RH0BFB(3,NUM(N2,N1),N2,N1)
C    3-RH0PHS(3,NUM(N2,N1),N2,N1)-RH0BFB(3,NUM(N2,N1),N2,N1)
      TH3PBS(LS,NY,NX)=TH3PBS(LS,NY,NX)+RH3PBS(LS,NY,NX)
     2-RH3PFS(3,0,N2,N1)-RH3PHS(3,NUM(N2,N1),N2,N1)
     3-RH3BFB(3,NUM(N2,N1),N2,N1)
C    3-RH3PHS(3,NUM(N2,N1),N2,N1)-RH3BFB(3,NUM(N2,N1),N2,N1)
      TF1PBS(LS,NY,NX)=TF1PBS(LS,NY,NX)+RF1PBS(LS,NY,NX)
     2-RF1PFS(3,0,N2,N1)-RF1PFS(3,NUM(N2,N1),N2,N1)
     3-RF1BFB(3,NUM(N2,N1),N2,N1)
C    3-RF1PHS(3,NUM(N2,N1),N2,N1)-RF1BFB(3,NUM(N2,N1),N2,N1)
      TF2PBS(LS,NY,NX)=TF2PBS(LS,NY,NX)+RF2PBS(LS,NY,NX)
     2-RF2PFS(3,0,N2,N1)-RF2PFS(3,NUM(N2,N1),N2,N1)
     3-RF2BFB(3,NUM(N2,N1),N2,N1)
C    3-RF2PHS(3,NUM(N2,N1),N2,N1)-RF2BFB(3,NUM(N2,N1),N2,N1)
      TC0PBS(LS,NY,NX)=TC0PBS(LS,NY,NX)+RC0PBS(LS,NY,NX)
     2-RC0PFS(3,0,N2,N1)-RC0PFS(3,NUM(N2,N1),N2,N1)
     3-RC0BFB(3,NUM(N2,N1),N2,N1)
C    3-RC0PHS(3,NUM(N2,N1),N2,N1)-RC0BFB(3,NUM(N2,N1),N2,N1)
      TC1PBS(LS,NY,NX)=TC1PBS(LS,NY,NX)+RC1PBS(LS,NY,NX)
     2-RC1PFS(3,0,N2,N1)-RC1PFS(3,NUM(N2,N1),N2,N1)
     3-RC1BFB(3,NUM(N2,N1),N2,N1)
C    3-RC1PHS(3,NUM(N2,N1),N2,N1)-RC1BFB(3,NUM(N2,N1),N2,N1)
      TC2PBS(LS,NY,NX)=TC2PBS(LS,NY,NX)+RC2PBS(LS,NY,NX)
     2-RC2PFS(3,0,N2,N1)-RC2PFS(3,NUM(N2,N1),N2,N1)
     3-RC2BFB(3,NUM(N2,N1),N2,N1)
C    3-RC2PHS(3,NUM(N2,N1),N2,N1)-RC2BFB(3,NUM(N2,N1),N2,N1)
      TM1PBS(LS,NY,NX)=TM1PBS(LS,NY,NX)+RM1PBS(LS,NY,NX)
     2-RM1PFS(3,0,N2,N1)-RM1PFS(3,NUM(N2,N1),N2,N1)
     3-RM1BFB(3,NUM(N2,N1),N2,N1)
C    3-RM1PHS(3,NUM(N2,N1),N2,N1)-RM1BFB(3,NUM(N2,N1),N2,N1)
      ENDIF
      ENDIF
1205  CONTINUE
      ENDIF
      ENDIF
C
C     TOTAL SOLUTE FLUX IN MICROPORES AND MACROPORES
C
C     T*FLS=net convective + diffusive solute flux through micropores
C     R*FLS=convective + diffusive solute flux through micropores
C     R*FLW,R*FLB=convective + diffusive solute flux through micropores in non-band,band
C     T*FHS=net convective + diffusive solute flux through macropores
C     R*FHS=convective + diffusive solute flux through macropores
C     R*FHW,R*FHB=convective + diffusive solute flux through macropores in non-band,band
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      IF(NCN(N2,N1).NE.3.OR.N.EQ.3)THEN
      DO 1200 LL=N6,NL(NY,NX)
      IF(VOLX(LL,N2,N1).GT.ZEROS2(N2,N1))THEN
      N6=LL
      GO TO 1201
      ENDIF
1200  CONTINUE
1201  CONTINUE
      IF(VOLX(N3,N2,N1).GT.ZEROS2(N2,N1))THEN
      TALFLS(N3,N2,N1)=TALFLS(N3,N2,N1)+RALFLS(N,N3,N2,N1)
     2-RALFLS(N,N6,N5,N4)
      TFEFLS(N3,N2,N1)=TFEFLS(N3,N2,N1)+RFEFLS(N,N3,N2,N1)
     2-RFEFLS(N,N6,N5,N4)
      THYFLS(N3,N2,N1)=THYFLS(N3,N2,N1)+RHYFLS(N,N3,N2,N1)
     2-RHYFLS(N,N6,N5,N4)
      TCAFLS(N3,N2,N1)=TCAFLS(N3,N2,N1)+RCAFLS(N,N3,N2,N1)
     2-RCAFLS(N,N6,N5,N4)
      TMGFLS(N3,N2,N1)=TMGFLS(N3,N2,N1)+RMGFLS(N,N3,N2,N1)
     2-RMGFLS(N,N6,N5,N4)
      TNAFLS(N3,N2,N1)=TNAFLS(N3,N2,N1)+RNAFLS(N,N3,N2,N1)
     2-RNAFLS(N,N6,N5,N4)
      TKAFLS(N3,N2,N1)=TKAFLS(N3,N2,N1)+RKAFLS(N,N3,N2,N1)
     2-RKAFLS(N,N6,N5,N4)
      TOHFLS(N3,N2,N1)=TOHFLS(N3,N2,N1)+ROHFLS(N,N3,N2,N1)
     2-ROHFLS(N,N6,N5,N4)
      TSOFLS(N3,N2,N1)=TSOFLS(N3,N2,N1)+RSOFLS(N,N3,N2,N1)
     2-RSOFLS(N,N6,N5,N4)
      TCLFLS(N3,N2,N1)=TCLFLS(N3,N2,N1)+RCLFLS(N,N3,N2,N1)
     2-RCLFLS(N,N6,N5,N4)
      TC3FLS(N3,N2,N1)=TC3FLS(N3,N2,N1)+RC3FLS(N,N3,N2,N1)
     2-RC3FLS(N,N6,N5,N4)
      THCFLS(N3,N2,N1)=THCFLS(N3,N2,N1)+RHCFLS(N,N3,N2,N1)
     2-RHCFLS(N,N6,N5,N4)
      TAL1FS(N3,N2,N1)=TAL1FS(N3,N2,N1)+RAL1FS(N,N3,N2,N1)
     2-RAL1FS(N,N6,N5,N4)
      TAL2FS(N3,N2,N1)=TAL2FS(N3,N2,N1)+RAL2FS(N,N3,N2,N1)
     2-RAL2FS(N,N6,N5,N4)
      TAL3FS(N3,N2,N1)=TAL3FS(N3,N2,N1)+RAL3FS(N,N3,N2,N1)
     2-RAL3FS(N,N6,N5,N4)
      TAL4FS(N3,N2,N1)=TAL4FS(N3,N2,N1)+RAL4FS(N,N3,N2,N1)
     2-RAL4FS(N,N6,N5,N4)
      TALSFS(N3,N2,N1)=TALSFS(N3,N2,N1)+RALSFS(N,N3,N2,N1)
     2-RALSFS(N,N6,N5,N4)
      TFE1FS(N3,N2,N1)=TFE1FS(N3,N2,N1)+RFE1FS(N,N3,N2,N1)
     2-RFE1FS(N,N6,N5,N4)
      TFE2FS(N3,N2,N1)=TFE2FS(N3,N2,N1)+RFE2FS(N,N3,N2,N1)
     2-RFE2FS(N,N6,N5,N4)
      TFE3FS(N3,N2,N1)=TFE3FS(N3,N2,N1)+RFE3FS(N,N3,N2,N1)
     2-RFE3FS(N,N6,N5,N4)
      TFE4FS(N3,N2,N1)=TFE4FS(N3,N2,N1)+RFE4FS(N,N3,N2,N1)
     2-RFE4FS(N,N6,N5,N4)
      TFESFS(N3,N2,N1)=TFESFS(N3,N2,N1)+RFESFS(N,N3,N2,N1)
     2-RFESFS(N,N6,N5,N4)
      TCAOFS(N3,N2,N1)=TCAOFS(N3,N2,N1)+RCAOFS(N,N3,N2,N1)
     2-RCAOFS(N,N6,N5,N4)
      TCACFS(N3,N2,N1)=TCACFS(N3,N2,N1)+RCACFS(N,N3,N2,N1)
     2-RCACFS(N,N6,N5,N4)
      TCAHFS(N3,N2,N1)=TCAHFS(N3,N2,N1)+RCAHFS(N,N3,N2,N1)
     2-RCAHFS(N,N6,N5,N4)
      TCASFS(N3,N2,N1)=TCASFS(N3,N2,N1)+RCASFS(N,N3,N2,N1)
     2-RCASFS(N,N6,N5,N4)
      TMGOFS(N3,N2,N1)=TMGOFS(N3,N2,N1)+RMGOFS(N,N3,N2,N1)
     2-RMGOFS(N,N6,N5,N4)
      TMGCFS(N3,N2,N1)=TMGCFS(N3,N2,N1)+RMGCFS(N,N3,N2,N1)
     2-RMGCFS(N,N6,N5,N4)
      TMGHFS(N3,N2,N1)=TMGHFS(N3,N2,N1)+RMGHFS(N,N3,N2,N1)
     2-RMGHFS(N,N6,N5,N4)
      TMGSFS(N3,N2,N1)=TMGSFS(N3,N2,N1)+RMGSFS(N,N3,N2,N1)
     2-RMGSFS(N,N6,N5,N4)
      TNACFS(N3,N2,N1)=TNACFS(N3,N2,N1)+RNACFS(N,N3,N2,N1)
     2-RNACFS(N,N6,N5,N4)
      TNASFS(N3,N2,N1)=TNASFS(N3,N2,N1)+RNASFS(N,N3,N2,N1)
     2-RNASFS(N,N6,N5,N4)
      TKASFS(N3,N2,N1)=TKASFS(N3,N2,N1)+RKASFS(N,N3,N2,N1)
     2-RKASFS(N,N6,N5,N4)
      TH0PFS(N3,N2,N1)=TH0PFS(N3,N2,N1)+RH0PFS(N,N3,N2,N1)
     2-RH0PFS(N,N6,N5,N4)
      TH3PFS(N3,N2,N1)=TH3PFS(N3,N2,N1)+RH3PFS(N,N3,N2,N1)
     2-RH3PFS(N,N6,N5,N4)
      TF1PFS(N3,N2,N1)=TF1PFS(N3,N2,N1)+RF1PFS(N,N3,N2,N1)
     2-RF1PFS(N,N6,N5,N4)
      TF2PFS(N3,N2,N1)=TF2PFS(N3,N2,N1)+RF2PFS(N,N3,N2,N1)
     2-RF2PFS(N,N6,N5,N4)
      TC0PFS(N3,N2,N1)=TC0PFS(N3,N2,N1)+RC0PFS(N,N3,N2,N1)
     2-RC0PFS(N,N6,N5,N4)
      TC1PFS(N3,N2,N1)=TC1PFS(N3,N2,N1)+RC1PFS(N,N3,N2,N1)
     2-RC1PFS(N,N6,N5,N4)
      TC2PFS(N3,N2,N1)=TC2PFS(N3,N2,N1)+RC2PFS(N,N3,N2,N1)
     2-RC2PFS(N,N6,N5,N4)
      TM1PFS(N3,N2,N1)=TM1PFS(N3,N2,N1)+RM1PFS(N,N3,N2,N1)
     2-RM1PFS(N,N6,N5,N4)
      TH0BFB(N3,N2,N1)=TH0BFB(N3,N2,N1)+RH0BFB(N,N3,N2,N1)
     2-RH0BFB(N,N6,N5,N4)
      TH3BFB(N3,N2,N1)=TH3BFB(N3,N2,N1)+RH3BFB(N,N3,N2,N1)
     2-RH3BFB(N,N6,N5,N4)
      TF1BFB(N3,N2,N1)=TF1BFB(N3,N2,N1)+RF1BFB(N,N3,N2,N1)
     2-RF1BFB(N,N6,N5,N4)
      TF2BFB(N3,N2,N1)=TF2BFB(N3,N2,N1)+RF2BFB(N,N3,N2,N1)
     2-RF2BFB(N,N6,N5,N4)
      TC0BFB(N3,N2,N1)=TC0BFB(N3,N2,N1)+RC0BFB(N,N3,N2,N1)
     2-RC0BFB(N,N6,N5,N4)
      TC1BFB(N3,N2,N1)=TC1BFB(N3,N2,N1)+RC1BFB(N,N3,N2,N1)
     2-RC1BFB(N,N6,N5,N4)
      TC2BFB(N3,N2,N1)=TC2BFB(N3,N2,N1)+RC2BFB(N,N3,N2,N1)
     2-RC2BFB(N,N6,N5,N4)
      TM1BFB(N3,N2,N1)=TM1BFB(N3,N2,N1)+RM1BFB(N,N3,N2,N1)
     2-RM1BFB(N,N6,N5,N4)
      TALFHS(N3,N2,N1)=TALFHS(N3,N2,N1)+RALFHS(N,N3,N2,N1)
     2-RALFHS(N,N6,N5,N4)
      TFEFHS(N3,N2,N1)=TFEFHS(N3,N2,N1)+RFEFHS(N,N3,N2,N1)
     2-RFEFHS(N,N6,N5,N4)
      THYFHS(N3,N2,N1)=THYFHS(N3,N2,N1)+RHYFHS(N,N3,N2,N1)
     2-RHYFHS(N,N6,N5,N4)
      TCAFHS(N3,N2,N1)=TCAFHS(N3,N2,N1)+RCAFHS(N,N3,N2,N1)
     2-RCAFHS(N,N6,N5,N4)
      TMGFHS(N3,N2,N1)=TMGFHS(N3,N2,N1)+RMGFHS(N,N3,N2,N1)
     2-RMGFHS(N,N6,N5,N4)
      TNAFHS(N3,N2,N1)=TNAFHS(N3,N2,N1)+RNAFHS(N,N3,N2,N1)
     2-RNAFHS(N,N6,N5,N4)
      TKAFHS(N3,N2,N1)=TKAFHS(N3,N2,N1)+RKAFHS(N,N3,N2,N1)
     2-RKAFHS(N,N6,N5,N4)
      TOHFHS(N3,N2,N1)=TOHFHS(N3,N2,N1)+ROHFHS(N,N3,N2,N1)
     2-ROHFHS(N,N6,N5,N4)
      TSOFHS(N3,N2,N1)=TSOFHS(N3,N2,N1)+RSOFHS(N,N3,N2,N1)
     2-RSOFHS(N,N6,N5,N4)
      TCLFHS(N3,N2,N1)=TCLFHS(N3,N2,N1)+RCLFHS(N,N3,N2,N1)
     2-RCLFHS(N,N6,N5,N4)
      TC3FHS(N3,N2,N1)=TC3FHS(N3,N2,N1)+RC3FHS(N,N3,N2,N1)
     2-RC3FHS(N,N6,N5,N4)
      THCFHS(N3,N2,N1)=THCFHS(N3,N2,N1)+RHCFHS(N,N3,N2,N1)
     2-RHCFHS(N,N6,N5,N4)
      TAL1HS(N3,N2,N1)=TAL1HS(N3,N2,N1)+RAL1HS(N,N3,N2,N1)
     2-RAL1HS(N,N6,N5,N4)
      TAL2HS(N3,N2,N1)=TAL2HS(N3,N2,N1)+RAL2HS(N,N3,N2,N1)
     2-RAL2HS(N,N6,N5,N4)
      TAL3HS(N3,N2,N1)=TAL3HS(N3,N2,N1)+RAL3HS(N,N3,N2,N1)
     2-RAL3HS(N,N6,N5,N4)
      TAL4HS(N3,N2,N1)=TAL4HS(N3,N2,N1)+RAL4HS(N,N3,N2,N1)
     2-RAL4HS(N,N6,N5,N4)
      TALSHS(N3,N2,N1)=TALSHS(N3,N2,N1)+RALSHS(N,N3,N2,N1)
     2-RALSHS(N,N6,N5,N4)
      TFE1HS(N3,N2,N1)=TFE1HS(N3,N2,N1)+RFE1HS(N,N3,N2,N1)
     2-RFE1HS(N,N6,N5,N4)
      TFE2HS(N3,N2,N1)=TFE2HS(N3,N2,N1)+RFE2HS(N,N3,N2,N1)
     2-RFE2HS(N,N6,N5,N4)
      TFE3HS(N3,N2,N1)=TFE3HS(N3,N2,N1)+RFE3HS(N,N3,N2,N1)
     2-RFE3HS(N,N6,N5,N4)
      TFE4HS(N3,N2,N1)=TFE4HS(N3,N2,N1)+RFE4HS(N,N3,N2,N1)
     2-RFE4HS(N,N6,N5,N4)
      TFESHS(N3,N2,N1)=TFESHS(N3,N2,N1)+RFESHS(N,N3,N2,N1)
     2-RFESHS(N,N6,N5,N4)
      TCAOHS(N3,N2,N1)=TCAOHS(N3,N2,N1)+RCAOHS(N,N3,N2,N1)
     2-RCAOHS(N,N6,N5,N4)
      TCACHS(N3,N2,N1)=TCACHS(N3,N2,N1)+RCACHS(N,N3,N2,N1)
     2-RCACHS(N,N6,N5,N4)
      TCAHHS(N3,N2,N1)=TCAHHS(N3,N2,N1)+RCAHHS(N,N3,N2,N1)
     2-RCAHHS(N,N6,N5,N4)
      TCASHS(N3,N2,N1)=TCASHS(N3,N2,N1)+RCASHS(N,N3,N2,N1)
     2-RCASHS(N,N6,N5,N4)
      TMGOHS(N3,N2,N1)=TMGOHS(N3,N2,N1)+RMGOHS(N,N3,N2,N1)
     2-RMGOHS(N,N6,N5,N4)
      TMGCHS(N3,N2,N1)=TMGCHS(N3,N2,N1)+RMGCHS(N,N3,N2,N1)
     2-RMGCHS(N,N6,N5,N4)
      TMGHHS(N3,N2,N1)=TMGHHS(N3,N2,N1)+RMGHHS(N,N3,N2,N1)
     2-RMGHHS(N,N6,N5,N4)
      TMGSHS(N3,N2,N1)=TMGSHS(N3,N2,N1)+RMGSHS(N,N3,N2,N1)
     2-RMGSHS(N,N6,N5,N4)
      TNACHS(N3,N2,N1)=TNACHS(N3,N2,N1)+RNACHS(N,N3,N2,N1)
     2-RNACHS(N,N6,N5,N4)
      TNASHS(N3,N2,N1)=TNASHS(N3,N2,N1)+RNASHS(N,N3,N2,N1)
     2-RNASHS(N,N6,N5,N4)
      TKASHS(N3,N2,N1)=TKASHS(N3,N2,N1)+RKASHS(N,N3,N2,N1)
     2-RKASHS(N,N6,N5,N4)
      TH0PHS(N3,N2,N1)=TH0PHS(N3,N2,N1)+RH0PHS(N,N3,N2,N1)
     2-RH0PHS(N,N6,N5,N4)
      TH3PHS(N3,N2,N1)=TH3PHS(N3,N2,N1)+RH3PHS(N,N3,N2,N1)
     2-RH3PHS(N,N6,N5,N4)
      TF1PHS(N3,N2,N1)=TF1PHS(N3,N2,N1)+RF1PHS(N,N3,N2,N1)
     2-RF1PHS(N,N6,N5,N4)
      TF2PHS(N3,N2,N1)=TF2PHS(N3,N2,N1)+RF2PHS(N,N3,N2,N1)
     2-RF2PHS(N,N6,N5,N4)
      TC0PHS(N3,N2,N1)=TC0PHS(N3,N2,N1)+RC0PHS(N,N3,N2,N1)
     2-RC0PHS(N,N6,N5,N4)
      TC1PHS(N3,N2,N1)=TC1PHS(N3,N2,N1)+RC1PHS(N,N3,N2,N1)
     2-RC1PHS(N,N6,N5,N4)
      TC2PHS(N3,N2,N1)=TC2PHS(N3,N2,N1)+RC2PHS(N,N3,N2,N1)
     2-RC2PHS(N,N6,N5,N4)
      TM1PHS(N3,N2,N1)=TM1PHS(N3,N2,N1)+RM1PHS(N,N3,N2,N1)
     2-RM1PHS(N,N6,N5,N4)
      TH0BHB(N3,N2,N1)=TH0BHB(N3,N2,N1)+RH0BHB(N,N3,N2,N1)
     2-RH0BHB(N,N6,N5,N4)
      TH3BHB(N3,N2,N1)=TH3BHB(N3,N2,N1)+RH3BHB(N,N3,N2,N1)
     2-RH3BHB(N,N6,N5,N4)
      TF1BHB(N3,N2,N1)=TF1BHB(N3,N2,N1)+RF1BHB(N,N3,N2,N1)
     2-RF1BHB(N,N6,N5,N4)
      TF2BHB(N3,N2,N1)=TF2BHB(N3,N2,N1)+RF2BHB(N,N3,N2,N1)
     2-RF2BHB(N,N6,N5,N4)
      TC0BHB(N3,N2,N1)=TC0BHB(N3,N2,N1)+RC0BHB(N,N3,N2,N1)
     2-RC0BHB(N,N6,N5,N4)
      TC1BHB(N3,N2,N1)=TC1BHB(N3,N2,N1)+RC1BHB(N,N3,N2,N1)
     2-RC1BHB(N,N6,N5,N4)
      TC2BHB(N3,N2,N1)=TC2BHB(N3,N2,N1)+RC2BHB(N,N3,N2,N1)
     2-RC2BHB(N,N6,N5,N4)
      TM1BHB(N3,N2,N1)=TM1BHB(N3,N2,N1)+RM1BHB(N,N3,N2,N1)
     2-RM1BHB(N,N6,N5,N4)
      ELSE
      TALFLS(N3,N2,N1)=0.0
      TFEFLS(N3,N2,N1)=0.0
      THYFLS(N3,N2,N1)=0.0
      TCAFLS(N3,N2,N1)=0.0
      TMGFLS(N3,N2,N1)=0.0
      TNAFLS(N3,N2,N1)=0.0
      TKAFLS(N3,N2,N1)=0.0
      TOHFLS(N3,N2,N1)=0.0
      TSOFLS(N3,N2,N1)=0.0
      TCLFLS(N3,N2,N1)=0.0
      TC3FLS(N3,N2,N1)=0.0
      THCFLS(N3,N2,N1)=0.0
      TAL1FS(N3,N2,N1)=0.0
      TAL2FS(N3,N2,N1)=0.0
      TAL3FS(N3,N2,N1)=0.0
      TAL4FS(N3,N2,N1)=0.0
      TALSFS(N3,N2,N1)=0.0
      TFE1FS(N3,N2,N1)=0.0
      TFE2FS(N3,N2,N1)=0.0
      TFE3FS(N3,N2,N1)=0.0
      TFE4FS(N3,N2,N1)=0.0
      TFESFS(N3,N2,N1)=0.0
      TCAOFS(N3,N2,N1)=0.0
      TCACFS(N3,N2,N1)=0.0
      TCAHFS(N3,N2,N1)=0.0
      TCASFS(N3,N2,N1)=0.0
      TMGOFS(N3,N2,N1)=0.0
      TMGCFS(N3,N2,N1)=0.0
      TMGHFS(N3,N2,N1)=0.0
      TMGSFS(N3,N2,N1)=0.0
      TNACFS(N3,N2,N1)=0.0
      TNASFS(N3,N2,N1)=0.0
      TKASFS(N3,N2,N1)=0.0
      TH0PFS(N3,N2,N1)=0.0
      TH3PFS(N3,N2,N1)=0.0
      TF1PFS(N3,N2,N1)=0.0
      TF2PFS(N3,N2,N1)=0.0
      TC0PFS(N3,N2,N1)=0.0
      TC1PFS(N3,N2,N1)=0.0
      TC2PFS(N3,N2,N1)=0.0
      TM1PFS(N3,N2,N1)=0.0
      TH0BFB(N3,N2,N1)=0.0
      TH3BFB(N3,N2,N1)=0.0
      TF1BFB(N3,N2,N1)=0.0
      TF2BFB(N3,N2,N1)=0.0
      TC0BFB(N3,N2,N1)=0.0
      TC1BFB(N3,N2,N1)=0.0
      TC2BFB(N3,N2,N1)=0.0
      TM1BFB(N3,N2,N1)=0.0
      TALFHS(N3,N2,N1)=0.0
      TFEFHS(N3,N2,N1)=0.0
      THYFHS(N3,N2,N1)=0.0
      TCAFHS(N3,N2,N1)=0.0
      TMGFHS(N3,N2,N1)=0.0
      TNAFHS(N3,N2,N1)=0.0
      TKAFHS(N3,N2,N1)=0.0
      TOHFHS(N3,N2,N1)=0.0
      TSOFHS(N3,N2,N1)=0.0
      TCLFHS(N3,N2,N1)=0.0
      TC3FHS(N3,N2,N1)=0.0
      THCFHS(N3,N2,N1)=0.0
      TAL1HS(N3,N2,N1)=0.0
      TAL2HS(N3,N2,N1)=0.0
      TAL3HS(N3,N2,N1)=0.0
      TAL4HS(N3,N2,N1)=0.0
      TALSHS(N3,N2,N1)=0.0
      TFE1HS(N3,N2,N1)=0.0
      TFE2HS(N3,N2,N1)=0.0
      TFE3HS(N3,N2,N1)=0.0
      TFE4HS(N3,N2,N1)=0.0
      TFESHS(N3,N2,N1)=0.0
      TCAOHS(N3,N2,N1)=0.0
      TCACHS(N3,N2,N1)=0.0
      TCAHHS(N3,N2,N1)=0.0
      TCASHS(N3,N2,N1)=0.0
      TMGOHS(N3,N2,N1)=0.0
      TMGCHS(N3,N2,N1)=0.0
      TMGHHS(N3,N2,N1)=0.0
      TMGSHS(N3,N2,N1)=0.0
      TNACHS(N3,N2,N1)=0.0
      TNASHS(N3,N2,N1)=0.0
      TKASHS(N3,N2,N1)=0.0
      TH0PHS(N3,N2,N1)=0.0
      TH3PHS(N3,N2,N1)=0.0
      TF1PHS(N3,N2,N1)=0.0
      TF2PHS(N3,N2,N1)=0.0
      TC0PHS(N3,N2,N1)=0.0
      TC1PHS(N3,N2,N1)=0.0
      TC2PHS(N3,N2,N1)=0.0
      TM1PHS(N3,N2,N1)=0.0
      TH0BHB(N3,N2,N1)=0.0
      TH3BHB(N3,N2,N1)=0.0
      TF1BHB(N3,N2,N1)=0.0
      TF2BHB(N3,N2,N1)=0.0
      TC0BHB(N3,N2,N1)=0.0
      TC1BHB(N3,N2,N1)=0.0
      TC2BHB(N3,N2,N1)=0.0
      TM1BHB(N3,N2,N1)=0.0
      ENDIF
      ENDIF
9580  CONTINUE
9585  CONTINUE
      ENDIF
9590  CONTINUE
9595  CONTINUE
C
C     UPDATE STATE VARIABLES FROM TOTAL FLUXES CALCULATED ABOVE
C
      DO 9695 NX=NHW,NHE
      DO 9690 NY=NVN,NVS
      IF(ISALTG.NE.0)THEN
C
C     STATE VARIABLES FOR SOLUTES IN MICROPORES AND MACROPORES IN
C     SOIL SURFACE LAYER FROM OVERLAND FLOW
C
C     *W2=solute content of snowpack
C     TQS*=net overland solute flux in snow 
C     T*BLS=net solute flux in snowpack
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      ZALW2(1,NY,NX)=ZALW2(1,NY,NX)+TQSAL(NY,NX)
      ZFEW2(1,NY,NX)=ZFEW2(1,NY,NX)+TQSFE(NY,NX)
      ZHYW2(1,NY,NX)=ZHYW2(1,NY,NX)+TQSHY(NY,NX)
      ZCAW2(1,NY,NX)=ZCAW2(1,NY,NX)+TQSCA(NY,NX)
      ZMGW2(1,NY,NX)=ZMGW2(1,NY,NX)+TQSMG(NY,NX)
      ZNAW2(1,NY,NX)=ZNAW2(1,NY,NX)+TQSNA(NY,NX)
      ZKAW2(1,NY,NX)=ZKAW2(1,NY,NX)+TQSKA(NY,NX)
      ZOHW2(1,NY,NX)=ZOHW2(1,NY,NX)+TQSOH(NY,NX)
      ZSO4W2(1,NY,NX)=ZSO4W2(1,NY,NX)+TQSSO(NY,NX) 
      ZCLW2(1,NY,NX)=ZCLW2(1,NY,NX)+TQSCL(NY,NX) 
      ZCO3W2(1,NY,NX)=ZCO3W2(1,NY,NX)+TQSC3(NY,NX) 
      ZHCO3W2(1,NY,NX)=ZHCO3W2(1,NY,NX)+TQSHC(NY,NX)
      ZALH1W2(1,NY,NX)=ZALH1W2(1,NY,NX)+TQSAL1(NY,NX)
      ZALH2W2(1,NY,NX)=ZALH2W2(1,NY,NX)+TQSAL2(NY,NX)
      ZALH3W2(1,NY,NX)=ZALH3W2(1,NY,NX)+TQSAL3(NY,NX)
      ZALH4W2(1,NY,NX)=ZALH4W2(1,NY,NX)+TQSAL4(NY,NX)
      ZALSW2(1,NY,NX)=ZALSW2(1,NY,NX)+TQSALS(NY,NX) 
      ZFEH1W2(1,NY,NX)=ZFEH1W2(1,NY,NX)+TQSFE1(NY,NX)
      ZFEH2W2(1,NY,NX)=ZFEH2W2(1,NY,NX)+TQSFE2(NY,NX)
      ZFEH3W2(1,NY,NX)=ZFEH3W2(1,NY,NX)+TQSFE3(NY,NX)
      ZFEH4W2(1,NY,NX)=ZFEH4W2(1,NY,NX)+TQSFE4(NY,NX)
      ZFESW2(1,NY,NX)=ZFESW2(1,NY,NX)+TQSFES(NY,NX)
      ZCAOW2(1,NY,NX)=ZCAOW2(1,NY,NX)+TQSCAO(NY,NX)
      ZCACW2(1,NY,NX)=ZCACW2(1,NY,NX)+TQSCAC(NY,NX)
      ZCAHW2(1,NY,NX)=ZCAHW2(1,NY,NX)+TQSCAH(NY,NX)
      ZCASW2(1,NY,NX)=ZCASW2(1,NY,NX)+TQSCAS(NY,NX)
      ZMGOW2(1,NY,NX)=ZMGOW2(1,NY,NX)+TQSMGO(NY,NX)
      ZMGCW2(1,NY,NX)=ZMGCW2(1,NY,NX)+TQSMGC(NY,NX)
      ZMGHW2(1,NY,NX)=ZMGHW2(1,NY,NX)+TQSMGH(NY,NX)
      ZMGSW2(1,NY,NX)=ZMGSW2(1,NY,NX)+TQSMGS(NY,NX)
      ZNACW2(1,NY,NX)=ZNACW2(1,NY,NX)+TQSNAC(NY,NX)
      ZNASW2(1,NY,NX)=ZNASW2(1,NY,NX)+TQSNAS(NY,NX)
      ZKASW2(1,NY,NX)=ZKASW2(1,NY,NX)+TQSKAS(NY,NX)
      H0PO4W2(1,NY,NX)=H0PO4W2(1,NY,NX)+TQSH0P(NY,NX) 
      H3PO4W2(1,NY,NX)=H3PO4W2(1,NY,NX)+TQSH3P(NY,NX)
      ZFE1PW2(1,NY,NX)=ZFE1PW2(1,NY,NX)+TQSF1P(NY,NX)
      ZFE2PW2(1,NY,NX)=ZFE2PW2(1,NY,NX)+TQSF2P(NY,NX)
      ZCA0PW2(1,NY,NX)=ZCA0PW2(1,NY,NX)+TQSC0P(NY,NX)
      ZCA1PW2(1,NY,NX)=ZCA1PW2(1,NY,NX)+TQSC1P(NY,NX)
      ZCA2PW2(1,NY,NX)=ZCA2PW2(1,NY,NX)+TQSC2P(NY,NX)
      ZMG1PW2(1,NY,NX)=ZMG1PW2(1,NY,NX)+TQSM1P(NY,NX)
      DO 9670 L=1,JS
      ZALW2(L,NY,NX)=ZALW2(L,NY,NX)+TALBLS(L,NY,NX)
      ZFEW2(L,NY,NX)=ZFEW2(L,NY,NX)+TFEBLS(L,NY,NX)
      ZHYW2(L,NY,NX)=ZHYW2(L,NY,NX)+THYBLS(L,NY,NX)
      ZCAW2(L,NY,NX)=ZCAW2(L,NY,NX)+TCABLS(L,NY,NX)
      ZMGW2(L,NY,NX)=ZMGW2(L,NY,NX)+TMGBLS(L,NY,NX)
      ZNAW2(L,NY,NX)=ZNAW2(L,NY,NX)+TNABLS(L,NY,NX)
      ZKAW2(L,NY,NX)=ZKAW2(L,NY,NX)+TKABLS(L,NY,NX)
      ZOHW2(L,NY,NX)=ZOHW2(L,NY,NX)+TOHBLS(L,NY,NX)
      ZSO4W2(L,NY,NX)=ZSO4W2(L,NY,NX)+TSOBLS(L,NY,NX)
      ZCLW2(L,NY,NX)=ZCLW2(L,NY,NX)+TCLBLS(L,NY,NX)
      ZCO3W2(L,NY,NX)=ZCO3W2(L,NY,NX)+TC3BLS(L,NY,NX)
      ZHCO3W2(L,NY,NX)=ZHCO3W2(L,NY,NX)+THCBLS(L,NY,NX)
      ZALH1W2(L,NY,NX)=ZALH1W2(L,NY,NX)+TAL1BS(L,NY,NX)
      ZALH2W2(L,NY,NX)=ZALH2W2(L,NY,NX)+TAL2BS(L,NY,NX)
      ZALH3W2(L,NY,NX)=ZALH3W2(L,NY,NX)+TAL3BS(L,NY,NX)
      ZALH4W2(L,NY,NX)=ZALH4W2(L,NY,NX)+TAL4BS(L,NY,NX)
      ZALSW2(L,NY,NX)=ZALSW2(L,NY,NX)+TALSBS(L,NY,NX)
      ZFEH1W2(L,NY,NX)=ZFEH1W2(L,NY,NX)+TFE1BS(L,NY,NX)
      ZFEH2W2(L,NY,NX)=ZFEH2W2(L,NY,NX)+TFE2BS(L,NY,NX)
      ZFEH3W2(L,NY,NX)=ZFEH3W2(L,NY,NX)+TFE3BS(L,NY,NX)
      ZFEH4W2(L,NY,NX)=ZFEH4W2(L,NY,NX)+TFE4BS(L,NY,NX)
      ZFESW2(L,NY,NX)=ZFESW2(L,NY,NX)+TFESBS(L,NY,NX)
      ZCAOW2(L,NY,NX)=ZCAOW2(L,NY,NX)+TCAOBS(L,NY,NX)
      ZCACW2(L,NY,NX)=ZCACW2(L,NY,NX)+TCACBS(L,NY,NX)
      ZCAHW2(L,NY,NX)=ZCAHW2(L,NY,NX)+TCAHBS(L,NY,NX)
      ZCASW2(L,NY,NX)=ZCASW2(L,NY,NX)+TCASBS(L,NY,NX)
      ZMGOW2(L,NY,NX)=ZMGOW2(L,NY,NX)+TMGOBS(L,NY,NX)
      ZMGCW2(L,NY,NX)=ZMGCW2(L,NY,NX)+TMGCBS(L,NY,NX)
      ZMGHW2(L,NY,NX)=ZMGHW2(L,NY,NX)+TMGHBS(L,NY,NX)
      ZMGSW2(L,NY,NX)=ZMGSW2(L,NY,NX)+TMGSBS(L,NY,NX)
      ZNACW2(L,NY,NX)=ZNACW2(L,NY,NX)+TNACBS(L,NY,NX)
      ZNASW2(L,NY,NX)=ZNASW2(L,NY,NX)+TNASBS(L,NY,NX)
      ZKASW2(L,NY,NX)=ZKASW2(L,NY,NX)+TKASBS(L,NY,NX)
      H0PO4W2(L,NY,NX)=H0PO4W2(L,NY,NX)+TH0PBS(L,NY,NX)
      H3PO4W2(L,NY,NX)=H3PO4W2(L,NY,NX)+TH3PBS(L,NY,NX)
      ZFE1PW2(L,NY,NX)=ZFE1PW2(L,NY,NX)+TF1PBS(L,NY,NX)
      ZFE2PW2(L,NY,NX)=ZFE2PW2(L,NY,NX)+TF2PBS(L,NY,NX)
      ZCA0PW2(L,NY,NX)=ZCA0PW2(L,NY,NX)+TC0PBS(L,NY,NX)
      ZCA1PW2(L,NY,NX)=ZCA1PW2(L,NY,NX)+TC1PBS(L,NY,NX)
      ZCA2PW2(L,NY,NX)=ZCA2PW2(L,NY,NX)+TC2PBS(L,NY,NX)
      ZMG1PW2(L,NY,NX)=ZMG1PW2(L,NY,NX)+TM1PBS(L,NY,NX)
9670  CONTINUE
C
C     STATE VARIABLES FOR SOLUTES IN SURFACE RESIDUE FROM OVERLAND 
C     FLOW AND SURFACE FLUX
C
C     *S2=litter solute content
C     R*DFR=gas exchange between atmosphere and surface litter water
C     R*DFS=gas exchange between atmosphere and soil surface water
C     R*FLS=convective + diffusive solute flux into litter,soil surface 
C     R*FLW,R*FLB=convective + diffusive solute flux into litter from non-band,band
C     TQR*=net overland solute flux
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C
      ZAL2(0,NY,NX)=ZAL2(0,NY,NX)+TQRAL(NY,NX)+RALFLS(3,0,NY,NX)
      ZFE2(0,NY,NX)=ZFE2(0,NY,NX)+TQRFE(NY,NX)+RFEFLS(3,0,NY,NX)
      ZHY2(0,NY,NX)=ZHY2(0,NY,NX)+TQRHY(NY,NX)+RHYFLS(3,0,NY,NX)
      ZCA2(0,NY,NX)=ZCA2(0,NY,NX)+TQRCA(NY,NX)+RCAFLS(3,0,NY,NX)
      ZMG2(0,NY,NX)=ZMG2(0,NY,NX)+TQRMG(NY,NX)+RMGFLS(3,0,NY,NX)
      ZNA2(0,NY,NX)=ZNA2(0,NY,NX)+TQRNA(NY,NX)+RNAFLS(3,0,NY,NX)
      ZKA2(0,NY,NX)=ZKA2(0,NY,NX)+TQRKA(NY,NX)+RKAFLS(3,0,NY,NX)
      ZOH2(0,NY,NX)=ZOH2(0,NY,NX)+TQROH(NY,NX)+ROHFLS(3,0,NY,NX)
      ZSO42(0,NY,NX)=ZSO42(0,NY,NX)+TQRSO(NY,NX)+RSOFLS(3,0,NY,NX)
      ZCL2(0,NY,NX)=ZCL2(0,NY,NX)+TQRCL(NY,NX)+RCLFLS(3,0,NY,NX)
      ZCO32(0,NY,NX)=ZCO32(0,NY,NX)+TQRC3(NY,NX)+RC3FLS(3,0,NY,NX)
      ZHCO32(0,NY,NX)=ZHCO32(0,NY,NX)+TQRHC(NY,NX)+RHCFLS(3,0,NY,NX)
      ZAL12(0,NY,NX)=ZAL12(0,NY,NX)+TQRAL1(NY,NX)+RAL1FS(3,0,NY,NX)
      ZAL22(0,NY,NX)=ZAL22(0,NY,NX)+TQRAL2(NY,NX)+RAL2FS(3,0,NY,NX)
      ZAL32(0,NY,NX)=ZAL32(0,NY,NX)+TQRAL3(NY,NX)+RAL3FS(3,0,NY,NX)
      ZAL42(0,NY,NX)=ZAL42(0,NY,NX)+TQRAL4(NY,NX)+RAL4FS(3,0,NY,NX)
      ZALS2(0,NY,NX)=ZALS2(0,NY,NX)+TQRALS(NY,NX)+RALSFS(3,0,NY,NX)
      ZFE12(0,NY,NX)=ZFE12(0,NY,NX)+TQRFE1(NY,NX)+RFE1FS(3,0,NY,NX)
      ZFE22(0,NY,NX)=ZFE22(0,NY,NX)+TQRFE2(NY,NX)+RFE2FS(3,0,NY,NX)
      ZFE32(0,NY,NX)=ZFE32(0,NY,NX)+TQRFE3(NY,NX)+RFE3FS(3,0,NY,NX)
      ZFE42(0,NY,NX)=ZFE42(0,NY,NX)+TQRFE4(NY,NX)+RFE4FS(3,0,NY,NX)
      ZFES2(0,NY,NX)=ZFES2(0,NY,NX)+TQRFES(NY,NX)+RFESFS(3,0,NY,NX)
      ZCAO2(0,NY,NX)=ZCAO2(0,NY,NX)+TQRCAO(NY,NX)+RCAOFS(3,0,NY,NX)
      ZCAC2(0,NY,NX)=ZCAC2(0,NY,NX)+TQRCAC(NY,NX)+RCACFS(3,0,NY,NX)
      ZCAH2(0,NY,NX)=ZCAH2(0,NY,NX)+TQRCAH(NY,NX)+RCAHFS(3,0,NY,NX)
      ZCAS2(0,NY,NX)=ZCAS2(0,NY,NX)+TQRCAS(NY,NX)+RCASFS(3,0,NY,NX)
      ZMGO2(0,NY,NX)=ZMGO2(0,NY,NX)+TQRMGO(NY,NX)+RMGOFS(3,0,NY,NX)
      ZMGC2(0,NY,NX)=ZMGC2(0,NY,NX)+TQRMGC(NY,NX)+RMGCFS(3,0,NY,NX)
      ZMGH2(0,NY,NX)=ZMGH2(0,NY,NX)+TQRMGH(NY,NX)+RMGHFS(3,0,NY,NX)
      ZMGS2(0,NY,NX)=ZMGS2(0,NY,NX)+TQRMGS(NY,NX)+RMGSFS(3,0,NY,NX)
      ZNAC2(0,NY,NX)=ZNAC2(0,NY,NX)+TQRNAC(NY,NX)+RNACFS(3,0,NY,NX)
      ZNAS2(0,NY,NX)=ZNAS2(0,NY,NX)+TQRNAS(NY,NX)+RNASFS(3,0,NY,NX)
      ZKAS2(0,NY,NX)=ZKAS2(0,NY,NX)+TQRKAS(NY,NX)+RKASFS(3,0,NY,NX)
      H0PO42(0,NY,NX)=H0PO42(0,NY,NX)+TQRH0P(NY,NX)+RH0PFS(3,0,NY,NX)
      H3PO42(0,NY,NX)=H3PO42(0,NY,NX)+TQRH3P(NY,NX)+RH3PFS(3,0,NY,NX)
      ZFE1P2(0,NY,NX)=ZFE1P2(0,NY,NX)+TQRF1P(NY,NX)+RF1PFS(3,0,NY,NX)
      ZFE2P2(0,NY,NX)=ZFE2P2(0,NY,NX)+TQRF2P(NY,NX)+RF2PFS(3,0,NY,NX)
      ZCA0P2(0,NY,NX)=ZCA0P2(0,NY,NX)+TQRC0P(NY,NX)+RC0PFS(3,0,NY,NX)
      ZCA1P2(0,NY,NX)=ZCA1P2(0,NY,NX)+TQRC1P(NY,NX)+RC1PFS(3,0,NY,NX)
      ZCA2P2(0,NY,NX)=ZCA2P2(0,NY,NX)+TQRC2P(NY,NX)+RC2PFS(3,0,NY,NX)
      ZMG1P2(0,NY,NX)=ZMG1P2(0,NY,NX)+TQRM1P(NY,NX)+RM1PFS(3,0,NY,NX)
C
C     STATE VARIABLES FOR GASES AND FOR SOLUTES IN MICROPORES AND
C     MACROPORES IN SOIL LAYERS FROM SUBSURFACE FLOW, EQUILIBRIUM
C     REACTIONS IN SOLUTE
C
C     *S2,*B2=micropore solute content in non-band,band
C     salt code: *HY*=H+,*OH*=OH-,*AL*=Al3+,*FE*=Fe3+,*CA*=Ca2+,*MG*=Mg2+
C          :*NA*=Na+,*KA*=K+,*SO4*=SO42-,*CL*=Cl-,*CO3*=CO32-,*HCO3*=HCO3-
C          :*CO2*=CO2,*ALO1*=AlOH2-,*ALOH2=AlOH2-,*ALOH3*=AlOH3
C          :*ALOH4*=AlOH4+,*ALS*=AlSO4+,*FEO1*=FeOH2-,*FEOH2=F3OH2-
C          :*FEOH3*=FeOH3,*FEOH4*=FeOH4+,*FES*=FeSO4+,*CAO*=CaOH
C          :*CAC*=CaCO3,*CAH*=CaHCO3-,*CAS*=CaSO4,*MGO*=MgOH,*MGC*=MgCO3
C          :*MHG*=MgHCO3-,*MGS*=MgSO4,*NAC*=NaCO3-,*NAS*=NaSO4-,*KAS*=KSO4-
C     phosphorus code: *H0P*=PO43-,*H3P*=H3PO4,*F1P*=FeHPO42-,*F2P*=F1H2PO4-
C          :*C0P*=CaPO4-,*C1P*=CaHPO4,*C2P*=CaH2PO4+,*M1P*=MgHPO4,*COO*=COOH-
C          :*1=non-band,*B=band
C     T*FLS=net convective + diffusive solute flux through micropores
C     T*FHS=net convective + diffusive solute flux through macropores
C     R*FXS=convective + diffusive solute flux between macropores and micropores
C     R*FLZ,R*FBZ=subsurface solute flux in non-band,band
C
      DO 9685 L=NU(NY,NX),NL(NY,NX)
      IF(VOLX(L,NY,NX).GT.ZEROS2(NY,NX))THEN
      ZAL2(L,NY,NX)=ZAL2(L,NY,NX)+TALFLS(L,NY,NX)+RALFXS(L,NY,NX)
     2+RALFLZ(L,NY,NX)
      ZFE2(L,NY,NX)=ZFE2(L,NY,NX)+TFEFLS(L,NY,NX)+RFEFXS(L,NY,NX)
     2+RFEFLZ(L,NY,NX) 
      ZHY2(L,NY,NX)=ZHY2(L,NY,NX)+THYFLS(L,NY,NX)+RHYFXS(L,NY,NX)
     2+RHYFLZ(L,NY,NX) 
      ZCA2(L,NY,NX)=ZCA2(L,NY,NX)+TCAFLS(L,NY,NX)+RCAFXS(L,NY,NX)
     2+RCAFLZ(L,NY,NX) 
      ZMG2(L,NY,NX)=ZMG2(L,NY,NX)+TMGFLS(L,NY,NX)+RMGFXS(L,NY,NX)
     2+RMGFLZ(L,NY,NX) 
      ZNA2(L,NY,NX)=ZNA2(L,NY,NX)+TNAFLS(L,NY,NX)+RNAFXS(L,NY,NX)
     2+RNAFLZ(L,NY,NX) 
      ZKA2(L,NY,NX)=ZKA2(L,NY,NX)+TKAFLS(L,NY,NX)+RKAFXS(L,NY,NX)
     2+RKAFLZ(L,NY,NX) 
      ZOH2(L,NY,NX)=ZOH2(L,NY,NX)+TOHFLS(L,NY,NX)+ROHFXS(L,NY,NX)
     2+ROHFLZ(L,NY,NX) 
      ZSO42(L,NY,NX)=ZSO42(L,NY,NX)+TSOFLS(L,NY,NX)+RSOFXS(L,NY,NX)
     2+RSOFLZ(L,NY,NX) 
      ZCL2(L,NY,NX)=ZCL2(L,NY,NX)+TCLFLS(L,NY,NX)+RCLFXS(L,NY,NX)
     2+RCLFLZ(L,NY,NX)
      ZCO32(L,NY,NX)=ZCO32(L,NY,NX)+TC3FLS(L,NY,NX)+RC3FXS(L,NY,NX)
     2+RC3FLZ(L,NY,NX) 
      ZHCO32(L,NY,NX)=ZHCO32(L,NY,NX)+THCFLS(L,NY,NX)+RHCFXS(L,NY,NX)
     2+RHCFLZ(L,NY,NX) 
      ZAL12(L,NY,NX)=ZAL12(L,NY,NX)+TAL1FS(L,NY,NX)+RAL1XS(L,NY,NX)
     2+RAL1FZ(L,NY,NX) 
      ZAL22(L,NY,NX)=ZAL22(L,NY,NX)+TAL2FS(L,NY,NX)+RAL2XS(L,NY,NX)
     2+RAL2FZ(L,NY,NX) 
      ZAL32(L,NY,NX)=ZAL32(L,NY,NX)+TAL3FS(L,NY,NX)+RAL3XS(L,NY,NX)
     2+RAL3FZ(L,NY,NX) 
      ZAL42(L,NY,NX)=ZAL42(L,NY,NX)+TAL4FS(L,NY,NX)+RAL4XS(L,NY,NX)
     2+RAL4FZ(L,NY,NX) 
      ZALS2(L,NY,NX)=ZALS2(L,NY,NX)+TALSFS(L,NY,NX)+RALSXS(L,NY,NX)
     2+RALSFZ(L,NY,NX) 
      ZFE12(L,NY,NX)=ZFE12(L,NY,NX)+TFE1FS(L,NY,NX)+RFE1XS(L,NY,NX)
     2+RFE1FZ(L,NY,NX) 
      ZFE22(L,NY,NX)=ZFE22(L,NY,NX)+TFE2FS(L,NY,NX)+RFE2XS(L,NY,NX)
     2+RFE2FZ(L,NY,NX) 
      ZFE32(L,NY,NX)=ZFE32(L,NY,NX)+TFE3FS(L,NY,NX)+RFE3XS(L,NY,NX)
     2+RFE3FZ(L,NY,NX) 
      ZFE42(L,NY,NX)=ZFE42(L,NY,NX)+TFE4FS(L,NY,NX)+RFE4XS(L,NY,NX)
     2+RFE4FZ(L,NY,NX) 
      ZFES2(L,NY,NX)=ZFES2(L,NY,NX)+TFESFS(L,NY,NX)+RFESXS(L,NY,NX)
     2+RFESFZ(L,NY,NX) 
      ZCAO2(L,NY,NX)=ZCAO2(L,NY,NX)+TCAOFS(L,NY,NX)+RCAOXS(L,NY,NX)
     2+RCAOFZ(L,NY,NX) 
      ZCAC2(L,NY,NX)=ZCAC2(L,NY,NX)+TCACFS(L,NY,NX)+RCACXS(L,NY,NX)
     2+RCACFZ(L,NY,NX) 
      ZCAH2(L,NY,NX)=ZCAH2(L,NY,NX)+TCAHFS(L,NY,NX)+RCAHXS(L,NY,NX)
     2+RCAHFZ(L,NY,NX) 
      ZCAS2(L,NY,NX)=ZCAS2(L,NY,NX)+TCASFS(L,NY,NX)+RCASXS(L,NY,NX)
     2+RCASFZ(L,NY,NX)
      ZMGO2(L,NY,NX)=ZMGO2(L,NY,NX)+TMGOFS(L,NY,NX)+RMGOXS(L,NY,NX)
     2+RMGOFZ(L,NY,NX) 
      ZMGC2(L,NY,NX)=ZMGC2(L,NY,NX)+TMGCFS(L,NY,NX)+RMGCXS(L,NY,NX)
     2+RMGCFZ(L,NY,NX) 
      ZMGH2(L,NY,NX)=ZMGH2(L,NY,NX)+TMGHFS(L,NY,NX)+RMGHXS(L,NY,NX)
     2+RMGHFZ(L,NY,NX) 
      ZMGS2(L,NY,NX)=ZMGS2(L,NY,NX)+TMGSFS(L,NY,NX)+RMGSXS(L,NY,NX)
     2+RMGSFZ(L,NY,NX) 
      ZNAC2(L,NY,NX)=ZNAC2(L,NY,NX)+TNACFS(L,NY,NX)+RNACXS(L,NY,NX)
     2+RNACFZ(L,NY,NX) 
      ZNAS2(L,NY,NX)=ZNAS2(L,NY,NX)+TNASFS(L,NY,NX)+RNASXS(L,NY,NX)
     2+RNASFZ(L,NY,NX) 
      ZKAS2(L,NY,NX)=ZKAS2(L,NY,NX)+TKASFS(L,NY,NX)+RKASXS(L,NY,NX)
     2+RKASFZ(L,NY,NX)
      H0PO42(L,NY,NX)=H0PO42(L,NY,NX)+TH0PFS(L,NY,NX)+RH0PXS(L,NY,NX)
     2+RH0PFZ(L,NY,NX) 
      H3PO42(L,NY,NX)=H3PO42(L,NY,NX)+TH3PFS(L,NY,NX)+RH3PXS(L,NY,NX)
     2+RH3PFZ(L,NY,NX)
      ZFE1P2(L,NY,NX)=ZFE1P2(L,NY,NX)+TF1PFS(L,NY,NX)+RF1PXS(L,NY,NX)
     2+RF1PFZ(L,NY,NX) 
      ZFE2P2(L,NY,NX)=ZFE2P2(L,NY,NX)+TF2PFS(L,NY,NX)+RF2PXS(L,NY,NX)
     2+RF2PFZ(L,NY,NX) 
      ZCA0P2(L,NY,NX)=ZCA0P2(L,NY,NX)+TC0PFS(L,NY,NX)+RC0PXS(L,NY,NX)
     2+RC0PFZ(L,NY,NX) 
      ZCA1P2(L,NY,NX)=ZCA1P2(L,NY,NX)+TC1PFS(L,NY,NX)+RC1PXS(L,NY,NX)
     2+RC1PFZ(L,NY,NX) 
      ZCA2P2(L,NY,NX)=ZCA2P2(L,NY,NX)+TC2PFS(L,NY,NX)+RC2PXS(L,NY,NX)
     2+RC2PFZ(L,NY,NX) 
      ZMG1P2(L,NY,NX)=ZMG1P2(L,NY,NX)+TM1PFS(L,NY,NX)+RM1PXS(L,NY,NX)
     2+RM1PFZ(L,NY,NX)
      H0POB2(L,NY,NX)=H0POB2(L,NY,NX)+TH0BFB(L,NY,NX)+RH0BXB(L,NY,NX)
     2+RH0BBZ(L,NY,NX)
      H3POB2(L,NY,NX)=H3POB2(L,NY,NX)+TH3BFB(L,NY,NX)+RH3BXB(L,NY,NX)
     2+RH3BBZ(L,NY,NX) 
      ZF1PB2(L,NY,NX)=ZF1PB2(L,NY,NX)+TF1BFB(L,NY,NX)+RF1BXB(L,NY,NX)
     2+RF1BBZ(L,NY,NX) 
      ZF2PB2(L,NY,NX)=ZF2PB2(L,NY,NX)+TF2BFB(L,NY,NX)+RF2BXB(L,NY,NX)
     2+RF2BBZ(L,NY,NX)
      ZC0PB2(L,NY,NX)=ZC0PB2(L,NY,NX)+TC0BFB(L,NY,NX)+RC0BXB(L,NY,NX)
     2+RC0BBZ(L,NY,NX)
      ZC1PB2(L,NY,NX)=ZC1PB2(L,NY,NX)+TC1BFB(L,NY,NX)+RC1BXB(L,NY,NX)
     2+RC1BBZ(L,NY,NX) 
      ZC2PB2(L,NY,NX)=ZC2PB2(L,NY,NX)+TC2BFB(L,NY,NX)+RC2BXB(L,NY,NX)
     2+RC2BBZ(L,NY,NX) 
      ZM1PB2(L,NY,NX)=ZM1PB2(L,NY,NX)+TM1BFB(L,NY,NX)+RM1BXB(L,NY,NX)
     2+RM1BBZ(L,NY,NX) 
      ZALH2(L,NY,NX)=ZALH2(L,NY,NX)+TALFHS(L,NY,NX)-RALFXS(L,NY,NX)
      ZFEH2(L,NY,NX)=ZFEH2(L,NY,NX)+TFEFHS(L,NY,NX)-RFEFXS(L,NY,NX)
      ZHYH2(L,NY,NX)=ZHYH2(L,NY,NX)+THYFHS(L,NY,NX)-RHYFXS(L,NY,NX)
      ZCCH2(L,NY,NX)=ZCCH2(L,NY,NX)+TCAFHS(L,NY,NX)-RCAFXS(L,NY,NX)
      ZMAH2(L,NY,NX)=ZMAH2(L,NY,NX)+TMGFHS(L,NY,NX)-RMGFXS(L,NY,NX)
      ZNAH2(L,NY,NX)=ZNAH2(L,NY,NX)+TNAFHS(L,NY,NX)-RNAFXS(L,NY,NX)
      ZKAH2(L,NY,NX)=ZKAH2(L,NY,NX)+TKAFHS(L,NY,NX)-RKAFXS(L,NY,NX)
      ZOHH2(L,NY,NX)=ZOHH2(L,NY,NX)+TOHFHS(L,NY,NX)-ROHFXS(L,NY,NX)
      ZSO4H2(L,NY,NX)=ZSO4H2(L,NY,NX)+TSOFHS(L,NY,NX)-RSOFXS(L,NY,NX)
      ZCLH2(L,NY,NX)=ZCLH2(L,NY,NX)+TCLFHS(L,NY,NX)-RCLFXS(L,NY,NX)
      ZCO3H2(L,NY,NX)=ZCO3H2(L,NY,NX)+TC3FHS(L,NY,NX)-RC3FXS(L,NY,NX)
      ZHCOH2(L,NY,NX)=ZHCOH2(L,NY,NX)+THCFHS(L,NY,NX)-RHCFXS(L,NY,NX)
      ZAL1H2(L,NY,NX)=ZAL1H2(L,NY,NX)+TAL1HS(L,NY,NX)-RAL1XS(L,NY,NX)
      ZAL2H2(L,NY,NX)=ZAL2H2(L,NY,NX)+TAL2HS(L,NY,NX)-RAL2XS(L,NY,NX)
      ZAL3H2(L,NY,NX)=ZAL3H2(L,NY,NX)+TAL3HS(L,NY,NX)-RAL3XS(L,NY,NX)
      ZAL4H2(L,NY,NX)=ZAL4H2(L,NY,NX)+TAL4HS(L,NY,NX)-RAL4XS(L,NY,NX)
      ZALSH2(L,NY,NX)=ZALSH2(L,NY,NX)+TALSHS(L,NY,NX)-RALSXS(L,NY,NX)
      ZFE1H2(L,NY,NX)=ZFE1H2(L,NY,NX)+TFE1HS(L,NY,NX)-RFE1XS(L,NY,NX)
      ZFE2H2(L,NY,NX)=ZFE2H2(L,NY,NX)+TFE2HS(L,NY,NX)-RFE2XS(L,NY,NX)
      ZFE3H2(L,NY,NX)=ZFE3H2(L,NY,NX)+TFE3HS(L,NY,NX)-RFE3XS(L,NY,NX)
      ZFE4H2(L,NY,NX)=ZFE4H2(L,NY,NX)+TFE4HS(L,NY,NX)-RFE4XS(L,NY,NX)
      ZFESH2(L,NY,NX)=ZFESH2(L,NY,NX)+TFESHS(L,NY,NX)-RFESXS(L,NY,NX)
      ZCAOH2(L,NY,NX)=ZCAOH2(L,NY,NX)+TCAOHS(L,NY,NX)-RCAOXS(L,NY,NX)
      ZCACH2(L,NY,NX)=ZCACH2(L,NY,NX)+TCACHS(L,NY,NX)-RCACXS(L,NY,NX)
      ZCAHH2(L,NY,NX)=ZCAHH2(L,NY,NX)+TCAHHS(L,NY,NX)-RCAHXS(L,NY,NX)
      ZCASH2(L,NY,NX)=ZCASH2(L,NY,NX)+TCASHS(L,NY,NX)-RCASXS(L,NY,NX)
      ZMGOH2(L,NY,NX)=ZMGOH2(L,NY,NX)+TMGOHS(L,NY,NX)-RMGOXS(L,NY,NX)
      ZMGCH2(L,NY,NX)=ZMGCH2(L,NY,NX)+TMGCHS(L,NY,NX)-RMGCXS(L,NY,NX)
      ZMGHH2(L,NY,NX)=ZMGHH2(L,NY,NX)+TMGHHS(L,NY,NX)-RMGHXS(L,NY,NX)
      ZMGSH2(L,NY,NX)=ZMGSH2(L,NY,NX)+TMGSHS(L,NY,NX)-RMGSXS(L,NY,NX)
      ZNACH2(L,NY,NX)=ZNACH2(L,NY,NX)+TNACHS(L,NY,NX)-RNACXS(L,NY,NX)
      ZNASH2(L,NY,NX)=ZNASH2(L,NY,NX)+TNASHS(L,NY,NX)-RNASXS(L,NY,NX)
      ZKASH2(L,NY,NX)=ZKASH2(L,NY,NX)+TKASHS(L,NY,NX)-RKASXS(L,NY,NX)
      H0P4H2(L,NY,NX)=H0P4H2(L,NY,NX)+TH0PHS(L,NY,NX)-RH0PXS(L,NY,NX)
      H3P4H2(L,NY,NX)=H3P4H2(L,NY,NX)+TH3PHS(L,NY,NX)-RH3PXS(L,NY,NX)
      ZF1PH2(L,NY,NX)=ZF1PH2(L,NY,NX)+TF1PHS(L,NY,NX)-RF1PXS(L,NY,NX)
      ZF2PH2(L,NY,NX)=ZF2PH2(L,NY,NX)+TF2PHS(L,NY,NX)-RF2PXS(L,NY,NX)
      ZC0PH2(L,NY,NX)=ZC0PH2(L,NY,NX)+TC0PHS(L,NY,NX)-RC0PXS(L,NY,NX)
      ZC1PH2(L,NY,NX)=ZC1PH2(L,NY,NX)+TC1PHS(L,NY,NX)-RC1PXS(L,NY,NX)
      ZC2PH2(L,NY,NX)=ZC2PH2(L,NY,NX)+TC2PHS(L,NY,NX)-RC2PXS(L,NY,NX)
      ZM1PH2(L,NY,NX)=ZM1PH2(L,NY,NX)+TM1PHS(L,NY,NX)-RM1PXS(L,NY,NX)
      H0PBH2(L,NY,NX)=H0PBH2(L,NY,NX)+TH0BHB(L,NY,NX)-RH0BXB(L,NY,NX)
      H3PBH2(L,NY,NX)=H3PBH2(L,NY,NX)+TH3BHB(L,NY,NX)-RH3BXB(L,NY,NX)
      ZF1BH2(L,NY,NX)=ZF1BH2(L,NY,NX)+TF1BHB(L,NY,NX)-RF1BXB(L,NY,NX)
      ZF2BH2(L,NY,NX)=ZF2BH2(L,NY,NX)+TF2BHB(L,NY,NX)-RF2BXB(L,NY,NX)
      ZC0BH2(L,NY,NX)=ZC0BH2(L,NY,NX)+TC0BHB(L,NY,NX)-RC0BXB(L,NY,NX)
      ZC1BH2(L,NY,NX)=ZC1BH2(L,NY,NX)+TC1BHB(L,NY,NX)-RC1BXB(L,NY,NX)
      ZC2BH2(L,NY,NX)=ZC2BH2(L,NY,NX)+TC2BHB(L,NY,NX)-RC2BXB(L,NY,NX)
      ZM1BH2(L,NY,NX)=ZM1BH2(L,NY,NX)+TM1BHB(L,NY,NX)-RM1BXB(L,NY,NX)
C     IF(I.EQ.268.AND.L.EQ.1)THEN
C     WRITE(*,444)'ZOH2',I,J,M,NX,NY,L,ZOH2(L,NY,NX)
C    2,TOHFLS(L,NY,NX),ROHFXS(L,NY,NX),ROHFLZ(L,NY,NX) 
C    3,ROHFLS(3,L-1,NY,NX),ROHFLS(3,L,NY,NX)
C     WRITE(*,444)'ZAL2',I,J,M,NX,NY,L,ZAL2(L,NY,NX)
C    2,TALFLS(L,NY,NX),RALFXS(L,NY,NX),RALFLZ(L,NY,NX)
C    3,RZAL2(L,NY,NX),TRAL(L,NY,NX)
444   FORMAT(A8,6I4,20E12.4)
C     ENDIF
      ENDIF
9685  CONTINUE
      ENDIF
9690  CONTINUE
9695  CONTINUE
30    CONTINUE
      RETURN
      END

