/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.iq80.leveldb.impl.ValueType;

public final class SequenceNumber {
    public static final long MAX_SEQUENCE_NUMBER = 0xFFFFFFFFFFFFFFL;

    private SequenceNumber() {
    }

    public static long packSequenceAndValueType(long sequence, ValueType valueType) {
        Preconditions.checkArgument(sequence <= 0xFFFFFFFFFFFFFFL, "Sequence number is greater than MAX_SEQUENCE_NUMBER");
        Objects.requireNonNull(valueType, "valueType is null");
        return sequence << 8 | (long)valueType.getPersistentId();
    }

    public static ValueType unpackValueType(long num) {
        return ValueType.getValueTypeByPersistentId((byte)num);
    }

    public static long unpackSequenceNumber(long num) {
        return num >>> 8;
    }
}

