/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.util.Slice;

public class InternalEntry
implements Map.Entry<InternalKey, Slice> {
    private final InternalKey key;
    private final Slice value;

    public InternalEntry(InternalKey key, Slice value) {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(value, "value is null");
        this.key = key;
        this.value = value;
    }

    @Override
    public InternalKey getKey() {
        return this.key;
    }

    @Override
    public Slice getValue() {
        return this.value;
    }

    @Override
    public final Slice setValue(Slice value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalEntry entry = (InternalEntry)o;
        if (!this.key.equals(entry.key)) {
            return false;
        }
        return this.value.equals(entry.value);
    }

    @Override
    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InternalEntry");
        sb.append("{key=").append(this.key);
        sb.append(", value=").append(this.value.toString(StandardCharsets.UTF_8));
        sb.append('}');
        return sb.toString();
    }
}

