/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.Objects;

public class StyleSpan<S> {
    private final S style;
    private final int length;
    private int startPos = 0;

    public StyleSpan(S style, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("StyleSpan's length cannot be negative");
        }
        this.style = style;
        this.length = length;
    }

    StyleSpan(S style, int start, int length) {
        this.style = style;
        this.startPos = start;
        this.length = length;
    }

    public S getStyle() {
        return this.style;
    }

    public int getLength() {
        return this.length;
    }

    void setStart(int start) {
        this.startPos = start;
    }

    int getStart() {
        return this.startPos;
    }

    public boolean equals(Object other) {
        if (other instanceof StyleSpan) {
            StyleSpan that = (StyleSpan)other;
            return this.length == that.length && Objects.equals(this.style, that.style);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.style, this.length);
    }

    public String toString() {
        return String.format("StyleSpan[length=%s, style=%s]", this.length, this.style);
    }
}

