/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io.stream;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import net.querz.nbt.ByteArrayTag;
import net.querz.nbt.ByteTag;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.EndTag;
import net.querz.nbt.FloatTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.IntTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.LongArrayTag;
import net.querz.nbt.LongTag;
import net.querz.nbt.ShortTag;
import net.querz.nbt.StringTag;
import net.querz.nbt.Tag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;

public class StreamTagVisitor
implements TagTypeVisitor {
    private String lastName = "";
    private Tag tag;
    private final Deque<Consumer<Tag>> consumers = new ArrayDeque<Consumer<Tag>>();

    @Override
    public Tag getResult() {
        return this.tag;
    }

    protected int depth() {
        return this.consumers.size();
    }

    private void appendEntry(Tag tag) {
        this.consumers.getLast().accept(tag);
    }

    @Override
    public TagTypeVisitor.ValueResult visitEnd() {
        this.appendEntry(EndTag.INSTANCE);
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    @Override
    public TagTypeVisitor.ValueResult visit(byte b) {
        this.appendEntry(ByteTag.valueOf(b));
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    @Override
    public TagTypeVisitor.ValueResult visit(short s) {
        this.appendEntry(ShortTag.valueOf(s));
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    @Override
    public TagTypeVisitor.ValueResult visit(int i) {
        this.appendEntry(IntTag.valueOf(i));
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    @Override
    public TagTypeVisitor.ValueResult visit(long l) {
        this.appendEntry(LongTag.valueOf(l));
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    @Override
    public TagTypeVisitor.ValueResult visit(float f) {
        this.appendEntry(FloatTag.valueOf(f));
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    @Override
    public TagTypeVisitor.ValueResult visit(double d) {
        this.appendEntry(DoubleTag.valueOf(d));
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    @Override
    public TagTypeVisitor.ValueResult visit(String s) {
        this.appendEntry(StringTag.valueOf(s));
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    @Override
    public TagTypeVisitor.ValueResult visit(byte[] b) {
        this.appendEntry(new ByteArrayTag(b));
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    @Override
    public TagTypeVisitor.ValueResult visit(int[] i) {
        this.appendEntry(new IntArrayTag(i));
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    @Override
    public TagTypeVisitor.ValueResult visit(long[] l) {
        this.appendEntry(new LongArrayTag(l));
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    @Override
    public TagTypeVisitor.ValueResult visitList(TagReader<?> reader, int length) {
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    @Override
    public TagTypeVisitor.EntryResult visitEntry(TagReader<?> reader) {
        return TagTypeVisitor.EntryResult.ENTER;
    }

    @Override
    public TagTypeVisitor.EntryResult visitEntry(TagReader<?> reader, String name) {
        this.lastName = name;
        this.enterContainer(reader);
        return TagTypeVisitor.EntryResult.ENTER;
    }

    @Override
    public TagTypeVisitor.EntryResult visitElement(TagReader<?> reader, int index) {
        this.enterContainer(reader);
        return TagTypeVisitor.EntryResult.ENTER;
    }

    @Override
    public TagTypeVisitor.ValueResult visitContainerEnd() {
        this.consumers.removeLast();
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    @Override
    public TagTypeVisitor.ValueResult visitRootEntry(TagReader<?> reader) {
        if (reader == ListTag.READER) {
            ListTag l = new ListTag();
            this.tag = l;
            this.consumers.addLast(l::add);
        } else if (reader == CompoundTag.READER) {
            CompoundTag c = new CompoundTag();
            this.tag = c;
            this.consumers.addLast(v -> c.put(this.lastName, (Tag)v));
        } else {
            this.consumers.addLast(v -> {
                this.tag = v;
            });
        }
        return TagTypeVisitor.ValueResult.CONTINUE;
    }

    private void enterContainer(TagReader<?> reader) {
        if (reader == ListTag.READER) {
            ListTag l = new ListTag();
            this.appendEntry(l);
            this.consumers.addLast(l::add);
        } else if (reader == CompoundTag.READER) {
            CompoundTag c = new CompoundTag();
            this.appendEntry(c);
            this.consumers.addLast(v -> c.put(this.lastName, (Tag)v));
        }
    }
}

