/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io.snbt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.querz.nbt.Tag;
import net.querz.nbt.io.snbt.ParseException;
import net.querz.nbt.io.snbt.SNBTParser;

public final class SNBTReader {
    private boolean ignoreTrailing;

    public SNBTReader ignoreTrailing(boolean ignoreTrailing) {
        this.ignoreTrailing = ignoreTrailing;
        return this;
    }

    public Tag read(String s) throws ParseException {
        return new SNBTParser(s).parse(this.ignoreTrailing);
    }

    public Tag read(InputStream in) throws IOException {
        String s = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        return new SNBTParser(s).parse(this.ignoreTrailing);
    }

    public Tag read(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            Tag tag = this.read(fis);
            return tag;
        }
    }
}

