/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io.snbt;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.querz.nbt.ByteArrayTag;
import net.querz.nbt.ByteTag;
import net.querz.nbt.CollectionTag;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.FloatTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.IntTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.LongArrayTag;
import net.querz.nbt.LongTag;
import net.querz.nbt.ShortTag;
import net.querz.nbt.StringTag;
import net.querz.nbt.Tag;
import net.querz.nbt.io.snbt.ParseException;
import net.querz.nbt.io.snbt.StringPointer;

public class SNBTParser {
    private static final Pattern FLOAT_LITERAL = Pattern.compile("^([+-]?(?:\\d+(?:_+\\d+)*|\\d?)\\.?(?:\\d+(?:_+\\d+)*|\\d?)(?:[eE][+-]?(?:\\d+(?:_+\\d+)*))?)[fF]$");
    private static final Pattern DOUBLE_LITERAL = Pattern.compile("^([+-]?(?:\\d+(?:_+\\d+)*|\\d?)\\.?(?:\\d+(?:_+\\d+)*|\\d?)(?:[eE][+-]?(?:\\d+(?:_+\\d+)*))?)[dD]?$");
    private static final Pattern BYTE_LITERAL = Pattern.compile("^([-+]?\\d+(?:_+\\d+)*|0x[\\da-fA-F]+(?:_+[\\da-fA-F]+)*(?=[su])|0b[01]+(?:_+[01]+)*)([su]?)[bB]$");
    private static final Pattern SHORT_LITERAL = Pattern.compile("^([-+]?\\d+(?:_+\\d+)*|0x[\\da-fA-F]+(?:_+[\\da-fA-F]+)*|0b[01]+(?:_+[01]+)*)([su]?)[sS]$");
    private static final Pattern INT_LITERAL = Pattern.compile("^([-+]?\\d+(?:_+\\d+)*|0x[\\da-fA-F]+(?:_+[\\da-fA-F]+)*|0b[01]+(?:_+[01]+)*)(?:([su]?)[iI]|[iI]?)$");
    private static final Pattern LONG_LITERAL = Pattern.compile("^([-+]?\\d+(?:_+\\d+)*|0x[\\da-fA-F]+(?:_+[\\da-fA-F]+)*|0b[01]+(?:_+[01]+)*)([su]?)[lL]$");
    private static final Pattern AUTO_TYPE_ARRAY_LITERAL = Pattern.compile("^([-+]?\\d+(?:_+\\d+)*|0x[\\da-fA-F]+(?:_+[\\da-fA-F]+)*|0b[01]+(?:_+[01]+)*)$");
    private static final Pattern UNQUOTED_STRING = Pattern.compile("^[a-zA-Z_][\\w.+-]*$");
    private final StringPointer ptr;

    public SNBTParser(String s) {
        this.ptr = new StringPointer(s);
    }

    public Tag parse() throws ParseException {
        return this.parse(false);
    }

    public Tag parse(boolean ignoreTrailing) throws ParseException {
        if (ignoreTrailing) {
            return this.readValue();
        }
        Tag result = this.readValue();
        this.ptr.skipWhitespace();
        if (this.ptr.hasNext()) {
            throw this.ptr.parseException("trailing non-whitespace characters found");
        }
        return result;
    }

    private CompoundTag readCompoundTag() throws ParseException {
        this.ptr.skipWhitespace();
        this.ptr.expectChar('{');
        CompoundTag tag = new CompoundTag();
        this.ptr.skipWhitespace();
        while (this.ptr.hasNext() && this.ptr.currentChar() != '}') {
            if (this.hasSeparator()) {
                throw this.ptr.parseException("unexpected separator");
            }
            this.ptr.skipWhitespace();
            boolean quoted = this.ptr.currentChar() == '\"' || this.ptr.currentChar() == '\'';
            String key = this.ptr.parseString();
            if (!quoted && !UNQUOTED_STRING.matcher(key).matches()) {
                throw this.ptr.parseException("invalid unquoted key " + key);
            }
            this.ptr.skipWhitespace();
            this.ptr.expectChar(':');
            tag.put(key, this.readValue());
            if (this.hasSeparator()) continue;
            break;
        }
        this.ptr.expectChar('}');
        return tag;
    }

    private CollectionTag<?> readArrayTag() throws ParseException {
        this.ptr.skipWhitespace();
        this.ptr.expectChar('[');
        int start = this.ptr.getIndex();
        char type = this.ptr.next();
        this.ptr.skip(1);
        this.ptr.skipWhitespace();
        if (type == 'B') {
            return this.readByteArrayTag();
        }
        if (type == 'I') {
            return this.readIntArrayTag();
        }
        if (type == 'L') {
            return this.readLongArrayTag();
        }
        this.ptr.setIndex(start);
        throw this.ptr.parseException("invalid array type " + type);
    }

    private ByteArrayTag readByteArrayTag() throws ParseException {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        while (this.ptr.currentChar() != ']') {
            block6: {
                String s = this.ptr.parseSimpleString();
                try {
                    Matcher m = AUTO_TYPE_ARRAY_LITERAL.matcher(s);
                    if (m.matches()) {
                        byteList.add(this.parseByte(m.group(1), null));
                        break block6;
                    }
                    m = BYTE_LITERAL.matcher(s);
                    if (m.matches()) {
                        byteList.add(this.parseByte(m.group(1), m.group(2)));
                        break block6;
                    }
                    throw this.ptr.parseException("invalid byte value " + s);
                }
                catch (NumberFormatException ex) {
                    throw this.ptr.parseException("invalid byte value " + s);
                }
            }
            if (this.hasSeparator()) continue;
            break;
        }
        this.ptr.expectChar(']');
        byte[] array = new byte[byteList.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Byte)byteList.get(i);
        }
        return new ByteArrayTag(array);
    }

    private IntArrayTag readIntArrayTag() throws ParseException {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        while (this.ptr.currentChar() != ']') {
            block8: {
                String s = this.ptr.parseSimpleString();
                try {
                    Matcher m = AUTO_TYPE_ARRAY_LITERAL.matcher(s);
                    if (m.matches()) {
                        intList.add(this.parseInt(m.group(1), null));
                        break block8;
                    }
                    m = INT_LITERAL.matcher(s);
                    if (m.matches()) {
                        intList.add(this.parseInt(m.group(1), m.group(2)));
                        break block8;
                    }
                    m = SHORT_LITERAL.matcher(s);
                    if (m.matches()) {
                        intList.add(Integer.valueOf(this.parseShort(m.group(1), m.group(2))));
                        break block8;
                    }
                    m = BYTE_LITERAL.matcher(s);
                    if (m.matches()) {
                        intList.add(Integer.valueOf(this.parseByte(m.group(1), m.group(2))));
                        break block8;
                    }
                    throw this.ptr.parseException("invalid int value " + s);
                }
                catch (NumberFormatException ex) {
                    throw this.ptr.parseException("invalid int value " + s);
                }
            }
            if (this.hasSeparator()) continue;
            break;
        }
        this.ptr.expectChar(']');
        int[] array = new int[intList.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Integer)intList.get(i);
        }
        return new IntArrayTag(array);
    }

    private LongArrayTag readLongArrayTag() throws ParseException {
        ArrayList<Long> longList = new ArrayList<Long>();
        while (this.ptr.currentChar() != ']') {
            block9: {
                String s = this.ptr.parseSimpleString();
                try {
                    Matcher m = AUTO_TYPE_ARRAY_LITERAL.matcher(s);
                    if (m.matches()) {
                        longList.add(this.parseLong(m.group(1), null));
                        break block9;
                    }
                    m = LONG_LITERAL.matcher(s);
                    if (m.matches()) {
                        longList.add(this.parseLong(m.group(1), m.group(2)));
                        break block9;
                    }
                    m = INT_LITERAL.matcher(s);
                    if (m.matches()) {
                        longList.add(Long.valueOf(this.parseInt(m.group(1), m.group(2))));
                        break block9;
                    }
                    m = SHORT_LITERAL.matcher(s);
                    if (m.matches()) {
                        longList.add(Long.valueOf(this.parseShort(m.group(1), m.group(2))));
                        break block9;
                    }
                    m = BYTE_LITERAL.matcher(s);
                    if (m.matches()) {
                        longList.add(Long.valueOf(this.parseByte(m.group(1), m.group(2))));
                        break block9;
                    }
                    throw this.ptr.parseException("invalid long value " + s);
                }
                catch (NumberFormatException ex) {
                    throw this.ptr.parseException("invalid long value " + s);
                }
            }
            if (this.hasSeparator()) continue;
            break;
        }
        this.ptr.expectChar(']');
        long[] array = new long[longList.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Long)longList.get(i);
        }
        return new LongArrayTag(array);
    }

    private CollectionTag<?> readCollectionTag() throws ParseException {
        this.ptr.skipWhitespace();
        if (this.ptr.hasCharsLeft(3) && this.ptr.lookAhead(1) != '\"' && this.ptr.lookAhead(1) != '\'' && this.ptr.lookAhead(2) == ';') {
            return this.readArrayTag();
        }
        return this.readListTag();
    }

    private ListTag readListTag() throws ParseException {
        this.ptr.expectChar('[');
        ArrayList<Tag> list = new ArrayList<Tag>();
        this.ptr.skipWhitespace();
        Tag.Type listType = null;
        boolean heterogeneous = false;
        while (this.ptr.hasNext() && this.ptr.currentChar() != ']') {
            if (this.hasSeparator()) {
                throw this.ptr.parseException("unexpected list separator");
            }
            Tag t = this.readValue();
            if (listType == null) {
                listType = t.getType();
            } else if (listType != t.getType()) {
                heterogeneous = true;
            }
            list.add(t);
            if (this.hasSeparator()) continue;
            break;
        }
        this.ptr.expectChar(']');
        ListTag tag = new ListTag();
        for (Tag t : list) {
            if (heterogeneous && t.getType() != Tag.Type.COMPOUND) {
                CompoundTag wrapper = new CompoundTag();
                wrapper.put("", t);
                tag.add(wrapper);
                continue;
            }
            tag.add(t);
        }
        return tag;
    }

    private Tag readValue() throws ParseException {
        this.ptr.skipWhitespace();
        char t = this.ptr.currentChar();
        if (t == '{') {
            return this.readCompoundTag();
        }
        if (t == '[') {
            return this.readCollectionTag();
        }
        if (this.ptr.currentChar() == '\"' || this.ptr.currentChar() == '\'') {
            return StringTag.valueOf(this.ptr.parseQuotedString());
        }
        String value = this.ptr.parseSimpleString();
        try {
            Matcher m = BYTE_LITERAL.matcher(value);
            if (m.matches()) {
                return ByteTag.valueOf(this.parseByte(m.group(1), m.group(2)));
            }
            m = SHORT_LITERAL.matcher(value);
            if (m.matches()) {
                return ShortTag.valueOf(this.parseShort(m.group(1), m.group(2)));
            }
            m = INT_LITERAL.matcher(value);
            if (m.matches()) {
                return IntTag.valueOf(this.parseInt(m.group(1), m.group(2)));
            }
            m = LONG_LITERAL.matcher(value);
            if (m.matches()) {
                return LongTag.valueOf(this.parseLong(m.group(1), m.group(2)));
            }
            m = FLOAT_LITERAL.matcher(value);
            if (m.matches()) {
                return FloatTag.valueOf(Float.parseFloat(m.group(1)));
            }
            m = DOUBLE_LITERAL.matcher(value);
            if (m.matches()) {
                return DoubleTag.valueOf(Double.parseDouble(m.group(1)));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!value.isEmpty() && !UNQUOTED_STRING.matcher(value).matches()) {
            throw this.ptr.parseException("invalid number or unquoted string " + value);
        }
        return StringTag.valueOf(value);
    }

    private int getRadix(String s) {
        return s.startsWith("0x") ? 16 : (s.startsWith("0b") ? 2 : 10);
    }

    private String trimNumeric(String s, int radix) {
        if (radix != 10) {
            s = s.substring(2);
        }
        return s.replace("_", "");
    }

    private boolean getSigned(String sign, int radix) {
        return "".equals(sign) || sign == null ? radix == 10 : "s".equals(sign);
    }

    private byte parseByte(String s, String sign) throws NumberFormatException {
        int radix = this.getRadix(s);
        if (this.getSigned(sign, radix)) {
            return Byte.parseByte(this.trimNumeric(s, radix));
        }
        int v = Integer.parseUnsignedInt(this.trimNumeric(s, radix), radix);
        if (v > 255) {
            throw new NumberFormatException("Value out of range. Value:\"" + s + "\" Radix:" + radix);
        }
        return (byte)v;
    }

    private short parseShort(String s, String sign) throws NumberFormatException {
        int radix = this.getRadix(s);
        if (this.getSigned(sign, radix)) {
            return Short.parseShort(this.trimNumeric(s, radix));
        }
        int v = Integer.parseUnsignedInt(this.trimNumeric(s, radix), radix);
        if (v > 65535) {
            throw new NumberFormatException("Value out of range. Value:\"" + s + "\" Radix:" + radix);
        }
        return (short)v;
    }

    private int parseInt(String s, String sign) throws NumberFormatException {
        int radix = this.getRadix(s);
        return this.getSigned(sign, radix) ? Integer.parseInt(this.trimNumeric(s, radix)) : Integer.parseUnsignedInt(this.trimNumeric(s, radix), radix);
    }

    private long parseLong(String s, String sign) throws NumberFormatException {
        int radix = this.getRadix(s);
        return this.getSigned(sign, radix) ? Long.parseLong(this.trimNumeric(s, radix)) : Long.parseUnsignedLong(this.trimNumeric(s, radix), radix);
    }

    private boolean hasSeparator() {
        this.ptr.skipWhitespace();
        if (this.ptr.hasNext() && this.ptr.currentChar() == ',') {
            this.ptr.skip(1);
            this.ptr.skipWhitespace();
            return true;
        }
        return false;
    }

    public int getReadChars() {
        return this.ptr.getIndex() + 1;
    }
}

