/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt.io;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import net.querz.io.LittleEndianInputStream;
import net.querz.nbt.EndTag;
import net.querz.nbt.NamedTag;
import net.querz.nbt.Tag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.io.stream.SelectionStreamTagVisitor;
import net.querz.nbt.io.stream.TagSelector;

public final class NBTReader {
    private boolean compression;
    private boolean detectCompression;
    private boolean littleEndian;
    private boolean rawArrays;
    private List<TagSelector> selectors = null;
    private TagTypeVisitor visitor = null;

    public NBTReader detectCompression() {
        this.detectCompression = true;
        return this;
    }

    public NBTReader compressed(boolean compressed) {
        this.compression = compressed;
        return this;
    }

    public NBTReader littleEndian() {
        this.littleEndian = true;
        return this;
    }

    public NBTReader bigEndian() {
        this.littleEndian = false;
        return this;
    }

    public NBTReader rawArrays(boolean rawArrays) {
        this.rawArrays = rawArrays;
        return this;
    }

    public NBTReader select(String name, TagReader<?> reader) {
        if (this.selectors == null) {
            this.selectors = new ArrayList<TagSelector>();
        }
        this.selectors.add(new TagSelector(name, reader));
        return this;
    }

    public NBTReader select(String p1, String name, TagReader<?> reader) {
        if (this.selectors == null) {
            this.selectors = new ArrayList<TagSelector>();
        }
        this.selectors.add(new TagSelector(p1, name, reader));
        return this;
    }

    public NBTReader select(String p1, String p2, String name, TagReader<?> reader) {
        if (this.selectors == null) {
            this.selectors = new ArrayList<TagSelector>();
        }
        this.selectors.add(new TagSelector(p1, p2, name, reader));
        return this;
    }

    public NBTReader select(TagSelector ... selection) {
        for (TagSelector selector : selection) {
            this.select(selector);
        }
        return this;
    }

    public NBTReader select(TagSelector selector) {
        if (this.selectors == null) {
            this.selectors = new ArrayList<TagSelector>();
        }
        this.selectors.add(selector);
        return this;
    }

    public NBTReader withVisitor(TagTypeVisitor visitor) {
        this.visitor = visitor;
        return this;
    }

    public NamedTag readNamed(InputStream in) throws IOException {
        BufferedInputStream stream = this.detectCompression ? new BufferedInputStream(NBTReader.detectDecompression(in)) : (this.compression ? new BufferedInputStream(new GZIPInputStream(in)) : new BufferedInputStream(in));
        DataInput input = this.littleEndian ? new LittleEndianInputStream(stream) : new DataInputStream(stream);
        if (this.selectors == null) {
            if (this.visitor != null) {
                return this.readWithVisitor(input, this.visitor);
            }
            TagReader<?> reader = Tag.Type.valueOf((byte)input.readByte()).reader;
            String name = input.readUTF();
            return new NamedTag(name, (Tag)reader.read(input, this.rawArrays, 0));
        }
        SelectionStreamTagVisitor visitor = new SelectionStreamTagVisitor(this.selectors.toArray(new TagSelector[0]));
        return this.readWithVisitor(input, visitor);
    }

    private NamedTag readWithVisitor(DataInput input, TagTypeVisitor visitor) throws IOException {
        TagReader<?> reader = Tag.Type.valueOf((byte)input.readByte()).reader;
        String name = "";
        if (reader == EndTag.READER) {
            if (visitor.visitRootEntry(EndTag.READER) == TagTypeVisitor.ValueResult.CONTINUE) {
                visitor.visitEnd();
            }
        } else {
            switch (visitor.visitRootEntry(reader)) {
                case BREAK: {
                    name = input.readUTF();
                    reader.skip(input);
                    break;
                }
                case CONTINUE: {
                    name = input.readUTF();
                    reader.read(input, visitor, this.rawArrays);
                }
            }
        }
        return new NamedTag(name, visitor.getResult());
    }

    public Tag read(InputStream in) throws IOException {
        return this.readNamed(in).tag();
    }

    public NamedTag readNamed(File file) throws IOException {
        return this.readNamed(new FileInputStream(file));
    }

    public Tag read(File file) throws IOException {
        return this.read(new FileInputStream(file));
    }

    private static InputStream detectDecompression(InputStream is) throws IOException {
        PushbackInputStream pbis = new PushbackInputStream(is, 2);
        int signature = (pbis.read() & 0xFF) + (pbis.read() << 8);
        pbis.unread(signature >> 8);
        pbis.unread(signature & 0xFF);
        return signature == 35615 ? new GZIPInputStream(pbis) : pbis;
    }
}

