/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt;

import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.querz.nbt.ByteArrayTag;
import net.querz.nbt.ByteTag;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.EndTag;
import net.querz.nbt.FloatTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.IntTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.LongArrayTag;
import net.querz.nbt.LongTag;
import net.querz.nbt.NumberTag;
import net.querz.nbt.ShortTag;
import net.querz.nbt.StringTag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagVisitor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Tag {
    public static final int MAX_DEPTH = 512;

    public void write(DataOutput var1) throws IOException;

    public String toString();

    default public Type getType() {
        return Type.valueOf(this.getClass());
    }

    public Tag copy();

    public void accept(TagVisitor var1);

    public static enum Type {
        END(0, EndTag.class),
        BYTE(1, ByteTag.class),
        SHORT(2, ShortTag.class),
        INT(3, IntTag.class),
        LONG(4, LongTag.class),
        FLOAT(5, FloatTag.class),
        DOUBLE(6, DoubleTag.class),
        BYTE_ARRAY(7, ByteArrayTag.class),
        STRING(8, StringTag.class),
        LIST(9, ListTag.class),
        COMPOUND(10, CompoundTag.class),
        INT_ARRAY(11, IntArrayTag.class),
        LONG_ARRAY(12, LongArrayTag.class);

        public final byte id;
        public final Class<? extends Tag> tagClass;
        public final TagReader<?> reader;
        public final boolean isNumber;
        private static final Type[] idCache;
        private static final Map<Class<? extends Tag>, Type> tagClassCache;

        private Type(int id, Class<? extends Tag> tagClass) {
            this.id = (byte)id;
            this.tagClass = tagClass;
            try {
                this.reader = (TagReader)tagClass.getDeclaredField("READER").get(null);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Malformed tag class: could not find reader", ex);
            }
            this.isNumber = NumberTag.class.isAssignableFrom(tagClass);
        }

        public static Type valueOf(byte b) {
            if (b < 0 || b >= idCache.length) {
                throw new IllegalArgumentException("No tag type corresponds to byte " + b);
            }
            return idCache[b];
        }

        public static Type valueOf(Class<? extends Tag> clazz) {
            if (!tagClassCache.containsKey(clazz)) {
                throw new IllegalArgumentException("No tag type corresponds to class " + clazz.getName());
            }
            return tagClassCache.get(clazz);
        }

        static {
            idCache = new Type[Type.values().length];
            tagClassCache = new HashMap<Class<? extends Tag>, Type>();
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.idCache[type.id] = type = typeArray[i];
                tagClassCache.put(type.tagClass, type);
            }
        }
    }
}

