/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.querz.nbt.NumberTag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.TagVisitor;

public class ShortTag
extends NumberTag {
    private final short value;
    public static final TagReader<ShortTag> READER = new TagReader<ShortTag>(){

        @Override
        public ShortTag read(DataInput in, boolean rawArrays, int depth) throws IOException {
            return ShortTag.valueOf(in.readShort());
        }

        @Override
        public TagTypeVisitor.ValueResult read(DataInput in, TagTypeVisitor visitor, boolean rawArrays) throws IOException {
            return visitor.visit(in.readShort());
        }

        @Override
        public void skip(DataInput in) throws IOException {
            in.skipBytes(2);
        }
    };

    private ShortTag(short s) {
        this.value = s;
    }

    public static ShortTag valueOf(short s) {
        return s >= -128 && s <= 1024 ? Cache.cache[s + 128] : new ShortTag(s);
    }

    @Override
    public byte asByte() {
        return (byte)(this.value & 0xFF);
    }

    @Override
    public short asShort() {
        return this.value;
    }

    @Override
    public int asInt() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public Number asNumber() {
        return this.value;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeShort(this.value);
    }

    @Override
    public ShortTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ShortTag && this.value == ((ShortTag)other).value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value + "s";
    }

    private static final class Cache {
        private static final ShortTag[] cache = new ShortTag[1153];

        private Cache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                Cache.cache[i] = new ShortTag((short)(i - 128));
            }
        }
    }
}

