/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.querz.nbt.NumberTag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.TagVisitor;

public class LongTag
extends NumberTag {
    private final long value;
    public static final TagReader<LongTag> READER = new TagReader<LongTag>(){

        @Override
        public LongTag read(DataInput in, boolean rawArrays, int depth) throws IOException {
            return LongTag.valueOf(in.readLong());
        }

        @Override
        public TagTypeVisitor.ValueResult read(DataInput in, TagTypeVisitor visitor, boolean rawArrays) throws IOException {
            return visitor.visit(in.readLong());
        }

        @Override
        public void skip(DataInput in) throws IOException {
            in.skipBytes(8);
        }
    };

    private LongTag(long l) {
        this.value = l;
    }

    public static LongTag valueOf(long l) {
        return l >= -128L && l <= 1024L ? Cache.cache[(int)l + 128] : new LongTag(l);
    }

    @Override
    public byte asByte() {
        return (byte)(this.value & 0xFFL);
    }

    @Override
    public short asShort() {
        return (short)(this.value & 0xFFFFL);
    }

    @Override
    public int asInt() {
        return (int)this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public Number asNumber() {
        return this.value;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.value);
    }

    @Override
    public LongTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LongTag && this.value == ((LongTag)other).value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public String toString() {
        return this.value + "L";
    }

    private static final class Cache {
        private static final LongTag[] cache = new LongTag[1153];

        private Cache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                Cache.cache[i] = new LongTag(i - 128);
            }
        }
    }
}

