/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.querz.nbt.ByteArrayTag;
import net.querz.nbt.ByteTag;
import net.querz.nbt.CollectionTag;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.FloatTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.IntTag;
import net.querz.nbt.LongArrayTag;
import net.querz.nbt.LongTag;
import net.querz.nbt.NumberTag;
import net.querz.nbt.ShortTag;
import net.querz.nbt.StringTag;
import net.querz.nbt.Tag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.TagVisitor;

public class ListTag
extends CollectionTag<Tag> {
    private final List<Tag> value;
    private Tag.Type type;
    public static final TagReader<ListTag> READER = new TagReader<ListTag>(){

        @Override
        public ListTag read(DataInput in, boolean rawArrays, int depth) throws IOException {
            byte type = in.readByte();
            int length = in.readInt();
            if (type == Tag.Type.END.id && length > 0) {
                throw new RuntimeException("missing type on ListTag");
            }
            TagReader<?> tagReader = Tag.Type.valueOf((byte)type).reader;
            ArrayList<Tag> list = new ArrayList<Tag>(length);
            for (int i = 0; i < length; ++i) {
                list.add((Tag)tagReader.read(in, rawArrays, depth + 1));
            }
            if (rawArrays && (type == Tag.Type.INT_ARRAY.id || type == Tag.Type.LONG_ARRAY.id)) {
                type = Tag.Type.BYTE_ARRAY.id;
            }
            return new ListTag(list, type == 0 ? null : Tag.Type.valueOf(type));
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public TagTypeVisitor.ValueResult read(DataInput in, TagTypeVisitor visitor, boolean rawArrays) throws IOException {
            reader = Tag.Type.valueOf((byte)in.readByte()).reader;
            length = in.readInt();
            switch (2.$SwitchMap$net$querz$nbt$TagTypeVisitor$ValueResult[visitor.visitList(reader, length).ordinal()]) {
                case 1: {
                    return TagTypeVisitor.ValueResult.RETURN;
                }
                case 2: {
                    reader.skip(in);
                    return visitor.visitContainerEnd();
                }
            }
            block14: for (i = 0; i < length; ++i) {
                switch (2.$SwitchMap$net$querz$nbt$TagTypeVisitor$EntryResult[visitor.visitElement(reader, i).ordinal()]) {
                    case 1: {
                        return TagTypeVisitor.ValueResult.RETURN;
                    }
                    case 2: {
                        reader.skip(in);
                        break block14;
                    }
                    case 3: {
                        reader.skip(in);
                        ** GOTO lbl25
                    }
                    case 4: {
                        switch (2.$SwitchMap$net$querz$nbt$TagTypeVisitor$ValueResult[reader.read(in, visitor, rawArrays).ordinal()]) {
                            case 1: {
                                return TagTypeVisitor.ValueResult.RETURN;
                            }
                            case 2: {
                                break block14;
                            }
                        }
                    }
lbl25:
                    // 3 sources

                    default: {
                        continue block14;
                    }
                }
            }
            if ((remainingElements = length - 1 - i) > 0) {
                for (j = 0; j < remainingElements; ++j) {
                    this.skip(in);
                }
            }
            return visitor.visitContainerEnd();
        }

        @Override
        public void skip(DataInput in) throws IOException {
            TagReader<?> tagReader = Tag.Type.valueOf((byte)in.readByte()).reader;
            int length = in.readInt();
            for (int i = 0; i < length; ++i) {
                tagReader.skip(in);
            }
        }
    };

    public ListTag() {
        this(null);
    }

    public ListTag(Tag.Type type) {
        this(new ArrayList<Tag>(), type);
    }

    public ListTag(List<Tag> list, Tag.Type type) {
        Objects.requireNonNull(list);
        if (type == Tag.Type.END) {
            throw new IllegalArgumentException("ListTag can not be of type END");
        }
        for (int i = 0; i < list.size(); ++i) {
            Objects.requireNonNull(list.get(i));
            if (list.get(i).getType() == type) continue;
            throw new IllegalArgumentException("Incorrect tag type " + list.get(i).getType() + " at index " + i + " (expected " + type + ")");
        }
        this.value = list;
        this.type = type;
    }

    @Override
    public Tag get(int index) {
        return this.value.get(index);
    }

    @Override
    public Tag set(int index, Tag tag) {
        Objects.requireNonNull(tag);
        Tag old = this.value.get(index);
        if (!this.updateType(tag)) {
            throw new UnsupportedOperationException(String.format("trying to set tag of type %s in ListTag of %s", new Object[]{tag.getType(), this.type}));
        }
        this.value.set(index, tag);
        return old;
    }

    @Override
    public void add(int index, Tag tag) {
        Objects.requireNonNull(tag);
        if (!this.updateType(tag)) {
            throw new UnsupportedOperationException(String.format("trying to add tag of type %s to ListTag of %s", new Object[]{tag.getType(), this.type}));
        }
        this.value.add(index, tag);
    }

    public boolean partOf(ListTag other) {
        if (other == null || this.type != other.type) {
            return false;
        }
        switch (this.type) {
            case COMPOUND: {
                block4: for (CompoundTag tag : this.iterateType(CompoundTag.class)) {
                    for (CompoundTag otherTag : other.iterateType(CompoundTag.class)) {
                        if (!tag.partOf(otherTag)) continue;
                        continue block4;
                    }
                    return false;
                }
                break;
            }
            case LIST: {
                block6: for (ListTag tag : this.iterateType(ListTag.class)) {
                    for (ListTag otherTag : other.iterateType(ListTag.class)) {
                        if (!tag.partOf(otherTag)) continue;
                        continue block6;
                    }
                    return false;
                }
                break;
            }
            default: {
                block8: for (Tag tag : this) {
                    for (Tag otherTag : other) {
                        if (!tag.equals(otherTag)) continue;
                        continue block8;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public void addBoolean(boolean b) {
        this.add(ByteTag.valueOf(b));
    }

    public void addByte(byte b) {
        this.add(ByteTag.valueOf(b));
    }

    public void addShort(short s) {
        this.add(ShortTag.valueOf(s));
    }

    public void addInt(int i) {
        this.add(IntTag.valueOf(i));
    }

    public void addLong(long l) {
        this.add(LongTag.valueOf(l));
    }

    public void addFloat(float f) {
        this.add(FloatTag.valueOf(f));
    }

    public void addDouble(double d) {
        this.add(DoubleTag.valueOf(d));
    }

    public void addString(String s) {
        this.add(StringTag.valueOf(s));
    }

    public void addByteArray(byte[] b) {
        this.add(new ByteArrayTag(b));
    }

    public void addIntArray(int[] i) {
        this.add(new IntArrayTag(i));
    }

    public void addLongArray(long[] l) {
        this.add(new LongArrayTag(l));
    }

    private boolean updateType(Tag tag) {
        if (this.type == null && tag.getType() != Tag.Type.END) {
            this.type = tag.getType();
            return true;
        }
        return this.type == tag.getType();
    }

    @Override
    public Tag remove(int index) {
        Tag old = this.value.remove(index);
        if (this.value.isEmpty()) {
            this.type = null;
        }
        return old;
    }

    @Override
    public Tag.Type getElementType() {
        return this.type;
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (this.type != null) {
            out.writeByte(this.type.id);
        } else {
            out.writeByte(0);
        }
        out.writeInt(this.value.size());
        for (Tag tag : this.value) {
            tag.write(out);
        }
    }

    @Override
    public ListTag copy() {
        ArrayList<Tag> copy = new ArrayList<Tag>(this.value.size());
        this.value.forEach(t -> copy.add(t.copy()));
        return new ListTag(copy, this.type);
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visit(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ListTag)) return false;
        ListTag otherList = (ListTag)other;
        if (!this.value.equals(otherList.value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public void clear() {
        this.value.clear();
        this.type = null;
    }

    private NumberTag getNumber(int index) {
        return (NumberTag)this.value.get(index);
    }

    public byte getByte(int index) {
        return this.getNumber(index).asByte();
    }

    public short getShort(int index) {
        return this.getNumber(index).asShort();
    }

    public int getInt(int index) {
        return this.getNumber(index).asInt();
    }

    public long getLong(int index) {
        return this.getNumber(index).asLong();
    }

    public float getFloat(int index) {
        return this.getNumber(index).asFloat();
    }

    public double getDouble(int index) {
        return this.getNumber(index).asDouble();
    }

    public String getString(int index) {
        return ((StringTag)this.value.get(index)).getValue();
    }

    public byte[] getByteArray(int index) {
        return ((ByteArrayTag)this.value.get(index)).getValue();
    }

    public int[] getIntArray(int index) {
        return ((IntArrayTag)this.value.get(index)).getValue();
    }

    public long[] getLongArray(int index) {
        return ((LongArrayTag)this.value.get(index)).getValue();
    }

    public CompoundTag getCompound(int index) {
        return (CompoundTag)this.value.get(index);
    }

    public ListTag getList(int index) {
        return (ListTag)this.value.get(index);
    }

    public boolean getBoolean(int index) {
        return this.getByte(index) != 0;
    }

    public byte getByteOrDefault(int index, byte def) {
        Tag tag;
        if (index >= 0 && index < this.value.size() && (tag = this.value.get(index)) instanceof NumberTag) {
            return ((NumberTag)tag).asByte();
        }
        return def;
    }

    public short getShortOrDefault(int index, short def) {
        Tag tag;
        if (index >= 0 && index < this.value.size() && (tag = this.value.get(index)) instanceof NumberTag) {
            return ((NumberTag)tag).asShort();
        }
        return def;
    }

    public int getIntOrDefault(int index, int def) {
        Tag tag;
        if (index >= 0 && index < this.value.size() && (tag = this.value.get(index)) instanceof NumberTag) {
            return ((NumberTag)tag).asInt();
        }
        return def;
    }

    public long getLongOrDefault(int index, long def) {
        Tag tag;
        if (index >= 0 && index < this.value.size() && (tag = this.value.get(index)) instanceof NumberTag) {
            return ((NumberTag)tag).asLong();
        }
        return def;
    }

    public float getFloatOrDefault(int index, float def) {
        Tag tag;
        if (index >= 0 && index < this.value.size() && (tag = this.value.get(index)) instanceof NumberTag) {
            return ((NumberTag)tag).asFloat();
        }
        return def;
    }

    public double getDoubleOrDefault(int index, double def) {
        Tag tag;
        if (index >= 0 && index < this.value.size() && (tag = this.value.get(index)) instanceof NumberTag) {
            return ((NumberTag)tag).asDouble();
        }
        return def;
    }

    public String getStringOrDefault(int index, String def) {
        Tag tag;
        if (index >= 0 && index < this.value.size() && (tag = this.value.get(index)).getType() == Tag.Type.STRING) {
            return ((StringTag)tag).getValue();
        }
        return def;
    }

    public byte[] getByteArrayOrDefault(int index, byte[] def) {
        Tag tag;
        if (index >= 0 && index < this.value.size() && (tag = this.value.get(index)).getType() == Tag.Type.BYTE_ARRAY) {
            return ((ByteArrayTag)tag).getValue();
        }
        return def;
    }

    public int[] getIntArrayOrDefault(int index, int[] def) {
        Tag tag;
        if (index >= 0 && index < this.value.size() && (tag = this.value.get(index)).getType() == Tag.Type.INT_ARRAY) {
            return ((IntArrayTag)tag).getValue();
        }
        return def;
    }

    public long[] getLongArrayOrDefault(int index, long[] def) {
        Tag tag;
        if (index >= 0 && index < this.value.size() && (tag = this.value.get(index)).getType() == Tag.Type.LONG_ARRAY) {
            return ((LongArrayTag)tag).getValue();
        }
        return def;
    }

    public CompoundTag getCompoundOrDefault(int index, CompoundTag def) {
        Tag tag;
        if (index >= 0 && index < this.value.size() && (tag = this.value.get(index)).getType() == Tag.Type.COMPOUND) {
            return (CompoundTag)tag;
        }
        return def;
    }

    public ListTag getListOrDefault(int index, ListTag def) {
        Tag tag;
        if (index >= 0 && index < this.value.size() && (tag = this.value.get(index)).getType() == Tag.Type.LIST) {
            return (ListTag)tag;
        }
        return def;
    }

    public <T extends Tag> List<T> iterateType(Class<T> tagClass) {
        if (this.type != null && this.type.tagClass != tagClass) {
            throw new IllegalArgumentException("Incorrect tagClass " + tagClass.getName() + ", list is of type " + this.type.tagClass.getName());
        }
        return new TypedListTag<T>(tagClass);
    }

    private class TypedListTag<T extends Tag>
    extends AbstractList<T> {
        private final Class<T> tagClass;

        private TypedListTag(Class<T> tagClass) {
            this.tagClass = tagClass;
        }

        @Override
        public T get(int index) {
            return (T)((Tag)this.tagClass.cast(ListTag.this.value.get(index)));
        }

        @Override
        public int size() {
            return ListTag.this.value.size();
        }

        @Override
        public T set(int index, T element) {
            Objects.requireNonNull(element);
            return (T)((Tag)this.tagClass.cast(ListTag.this.set(index, (Tag)element)));
        }

        @Override
        public void add(int index, T element) {
            Objects.requireNonNull(element);
            ListTag.this.add(index, (Tag)element);
        }

        @Override
        public T remove(int index) {
            return (T)((Tag)this.tagClass.cast(ListTag.this.remove(index)));
        }
    }
}

