/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.querz.nbt.NumberTag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.TagVisitor;

public class IntTag
extends NumberTag {
    private final int value;
    public static final TagReader<IntTag> READER = new TagReader<IntTag>(){

        @Override
        public IntTag read(DataInput in, boolean rawArrays, int depth) throws IOException {
            return IntTag.valueOf(in.readInt());
        }

        @Override
        public TagTypeVisitor.ValueResult read(DataInput in, TagTypeVisitor visitor, boolean rawArrays) throws IOException {
            return visitor.visit(in.readInt());
        }

        @Override
        public void skip(DataInput in) throws IOException {
            in.skipBytes(4);
        }
    };

    private IntTag(int i) {
        this.value = i;
    }

    public static IntTag valueOf(int i) {
        return i >= -128 && i <= 1024 ? Cache.cache[i + 128] : new IntTag(i);
    }

    @Override
    public byte asByte() {
        return (byte)(this.value & 0xFF);
    }

    @Override
    public short asShort() {
        return (short)(this.value & 0xFFFF);
    }

    @Override
    public int asInt() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public Number asNumber() {
        return this.value;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.value);
    }

    @Override
    public IntTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof IntTag && this.value == ((IntTag)other).value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    private static final class Cache {
        private static final IntTag[] cache = new IntTag[1153];

        private Cache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                Cache.cache[i] = new IntTag(i - 128);
            }
        }
    }
}

