/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import net.querz.nbt.ByteArrayTag;
import net.querz.nbt.CollectionTag;
import net.querz.nbt.IntTag;
import net.querz.nbt.NumberTag;
import net.querz.nbt.Tag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.TagVisitor;

public class IntArrayTag
extends CollectionTag<IntTag> {
    private int[] value;
    public static final TagReader<CollectionTag<? extends NumberTag>> READER = new TagReader<CollectionTag<? extends NumberTag>>(){

        @Override
        public CollectionTag<? extends NumberTag> read(DataInput in, boolean rawArrays, int depth) throws IOException {
            if (rawArrays) {
                return new ByteArrayTag(this.readByteArray(in, in.readInt() * 4));
            }
            int[] data = new int[in.readInt()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = in.readInt();
            }
            return new IntArrayTag(data);
        }

        @Override
        public TagTypeVisitor.ValueResult read(DataInput in, TagTypeVisitor visitor, boolean rawArrays) throws IOException {
            if (rawArrays) {
                return visitor.visit(this.readByteArray(in, in.readInt() * 4));
            }
            int[] data = new int[in.readInt()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = in.readInt();
            }
            return visitor.visit(data);
        }

        @Override
        public void skip(DataInput in) throws IOException {
            in.skipBytes(in.readInt() * 4);
        }
    };

    public IntArrayTag(int[] i) {
        Objects.requireNonNull(i);
        this.value = i;
    }

    @Override
    public IntTag get(int index) {
        return IntTag.valueOf(this.value[index]);
    }

    @Override
    public IntTag set(int index, IntTag tag) {
        int old = this.value[index];
        this.value[index] = tag.asInt();
        return IntTag.valueOf(old);
    }

    @Override
    public void add(int index, IntTag tag) {
        if (index > this.value.length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + this.value.length);
        }
        int[] output = new int[this.value.length + 1];
        System.arraycopy(this.value, 0, output, 0, index);
        output[index] = tag.asInt();
        if (index < this.value.length) {
            System.arraycopy(this.value, index, output, index + 1, this.value.length - index);
        }
        this.value = output;
    }

    @Override
    public IntTag remove(int index) {
        if (index < 0 || index >= this.value.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + this.value.length);
        }
        int old = this.value[index];
        int[] output = new int[this.value.length - 1];
        System.arraycopy(this.value, 0, output, 0, index);
        if (index < this.value.length - 1) {
            System.arraycopy(this.value, index + 1, output, index, this.value.length - index - 1);
        }
        this.value = output;
        return IntTag.valueOf(old);
    }

    @Override
    public Tag.Type getElementType() {
        return Tag.Type.INT;
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.value.length);
        for (int i : this.value) {
            out.writeInt(i);
        }
    }

    @Override
    public IntArrayTag copy() {
        int[] copy = new int[this.value.length];
        System.arraycopy(this.value, 0, copy, 0, this.value.length);
        return new IntArrayTag(copy);
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof IntArrayTag && Arrays.equals(this.value, ((IntArrayTag)other).value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public void clear() {
        this.value = new int[0];
    }

    public int[] getValue() {
        return this.value;
    }

    public void setValue(int[] value) {
        this.value = value;
    }
}

