/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.querz.nbt.NumberTag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.TagVisitor;

public class ByteTag
extends NumberTag {
    private final byte value;
    public static final ByteTag TRUE = ByteTag.valueOf((byte)1);
    public static final ByteTag FALSE = ByteTag.valueOf((byte)0);
    public static final TagReader<ByteTag> READER = new TagReader<ByteTag>(){

        @Override
        public ByteTag read(DataInput in, boolean rawArrays, int depth) throws IOException {
            return ByteTag.valueOf(in.readByte());
        }

        @Override
        public TagTypeVisitor.ValueResult read(DataInput in, TagTypeVisitor visitor, boolean rawArrays) throws IOException {
            return visitor.visit(in.readByte());
        }

        @Override
        public void skip(DataInput in) throws IOException {
            in.skipBytes(1);
        }
    };

    private ByteTag(byte b) {
        this.value = b;
    }

    public static ByteTag valueOf(byte b) {
        return Cache.cache[b + 128];
    }

    public static ByteTag valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Override
    public byte asByte() {
        return this.value;
    }

    @Override
    public short asShort() {
        return this.value;
    }

    @Override
    public int asInt() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public float asFloat() {
        return this.value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public Number asNumber() {
        return this.value;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(this.value);
    }

    @Override
    public ByteTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value + "b";
    }

    private static final class Cache {
        private static final ByteTag[] cache = new ByteTag[256];

        private Cache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                Cache.cache[i] = new ByteTag((byte)(i - 128));
            }
        }
    }
}

