/*
 * Decompiled with CFR 0.152.
 */
package net.querz.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.Objects;
import net.querz.nbt.ByteTag;
import net.querz.nbt.CollectionTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.LongArrayTag;
import net.querz.nbt.Tag;
import net.querz.nbt.TagReader;
import net.querz.nbt.TagTypeVisitor;
import net.querz.nbt.TagVisitor;

public class ByteArrayTag
extends CollectionTag<ByteTag> {
    private byte[] value;
    public static final TagReader<ByteArrayTag> READER = new TagReader<ByteArrayTag>(){

        @Override
        public ByteArrayTag read(DataInput in, boolean rawArrays, int depth) throws IOException {
            return new ByteArrayTag(this.readByteArray(in, in.readInt()));
        }

        @Override
        public TagTypeVisitor.ValueResult read(DataInput in, TagTypeVisitor visitor, boolean rawArrays) throws IOException {
            return visitor.visit(this.readByteArray(in, in.readInt()));
        }

        @Override
        public void skip(DataInput in) throws IOException {
            in.skipBytes(in.readInt());
        }
    };

    public ByteArrayTag(byte[] b) {
        Objects.requireNonNull(b);
        this.value = b;
    }

    @Override
    public ByteTag get(int index) {
        return ByteTag.valueOf(this.value[index]);
    }

    @Override
    public ByteTag set(int index, ByteTag tag) {
        byte old = this.value[index];
        this.value[index] = tag.asByte();
        return ByteTag.valueOf(old);
    }

    @Override
    public void add(int index, ByteTag tag) {
        if (index > this.value.length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + this.value.length);
        }
        byte[] output = new byte[this.value.length + 1];
        System.arraycopy(this.value, 0, output, 0, index);
        output[index] = tag.asByte();
        if (index < this.value.length) {
            System.arraycopy(this.value, index, output, index + 1, this.value.length - index);
        }
        this.value = output;
    }

    @Override
    public ByteTag remove(int index) {
        if (index < 0 || index >= this.value.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + this.value.length);
        }
        byte old = this.value[index];
        byte[] output = new byte[this.value.length - 1];
        System.arraycopy(this.value, 0, output, 0, index);
        if (index < this.value.length - 1) {
            System.arraycopy(this.value, index + 1, output, index, this.value.length - index - 1);
        }
        this.value = output;
        return ByteTag.valueOf(old);
    }

    @Override
    public Tag.Type getElementType() {
        return Tag.Type.BYTE;
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.value.length);
        out.write(this.value);
    }

    @Override
    public ByteArrayTag copy() {
        byte[] copy = new byte[this.value.length];
        System.arraycopy(this.value, 0, copy, 0, this.value.length);
        return new ByteArrayTag(copy);
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ByteArrayTag && Arrays.equals(this.value, ((ByteArrayTag)other).value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public void clear() {
        this.value = new byte[0];
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public int[] getIntArrayValue() {
        IntBuffer buffer = this.getAsIntBuffer();
        int[] array = new int[buffer.remaining()];
        buffer.get(array);
        return array;
    }

    public long[] getLongArrayValue() {
        LongBuffer buffer = this.getAsLongBuffer();
        long[] array = new long[buffer.remaining()];
        buffer.get(array);
        return array;
    }

    public ByteBuffer getAsByteBuffer() {
        return ByteBuffer.wrap(this.value);
    }

    public IntBuffer getAsIntBuffer() {
        return ByteBuffer.wrap(this.value).asIntBuffer();
    }

    public LongBuffer getAsLongBuffer() {
        return ByteBuffer.wrap(this.value).asLongBuffer();
    }

    public IntArrayTag getAsIntArrayTag() {
        return new IntArrayTag(this.getIntArrayValue());
    }

    public LongArrayTag getAsLongArrayTag() {
        return new LongArrayTag(this.getLongArrayValue());
    }
}

