/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.util;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public final class Download {
    public static void to(String url, Path output) throws IOException {
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(new URI(url).toURL().openStream());
             FileChannel fileChannel = FileChannel.open(output, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        catch (Exception ex) {
            throw new IOException("failed to download file from " + url + " to " + String.valueOf(output), ex);
        }
    }
}

