/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.util;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import net.querz.mcaselector.version.mapping.minecraft.MinecraftVersion;
import net.querz.mcaselector.version.mapping.minecraft.MinecraftVersionFile;
import net.querz.mcaselector.version.mapping.minecraft.ServerVersion;
import net.querz.mcaselector.version.mapping.util.Command;
import net.querz.mcaselector.version.mapping.util.Download;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.Tag;
import net.querz.nbt.io.NBTWriter;

public final class DebugWorld {
    private final Path path;

    public DebugWorld(Path path) {
        this.path = path;
    }

    public void generate(MinecraftVersion mcVersion) throws IOException, InterruptedException {
        int dataVersion;
        Path r_0_0_mca = this.path.resolve("world/region/r.0.0.mca");
        if (Files.exists(r_0_0_mca, new LinkOption[0])) {
            return;
        }
        Path versionJson = this.path.resolve("version.json");
        Path serverJar = this.path.resolve("server.jar");
        if (!Files.exists(versionJson, new LinkOption[0])) {
            MinecraftVersionFile.download(mcVersion, versionJson);
        }
        MinecraftVersionFile versionFile = MinecraftVersionFile.load(versionJson);
        if (!Files.exists(serverJar, new LinkOption[0])) {
            Download.to(versionFile.getDownloads().server().url(), serverJar);
        }
        try (FileSystem fs = FileSystems.newFileSystem(serverJar);){
            Path serverVersionJson = fs.getPath("version.json", new String[0]);
            ServerVersion serverVersion = ServerVersion.load(serverVersionJson);
            dataVersion = serverVersion.worldVersion();
        }
        this.generateLevelDat(mcVersion, dataVersion);
        Path eulaTxt = this.path.resolve("eula.txt");
        String eula = null;
        if (!Files.exists(eulaTxt, new LinkOption[0]) || (eula = Files.readString(eulaTxt)).contains("eula=false")) {
            Command.exec(this.path, "java", "-jar", "server.jar", "--nogui");
            Path serverProperties = this.path.resolve("server.properties");
            Properties properties = new Properties();
            properties.load(Files.newInputStream(serverProperties, new OpenOption[0]));
            properties.setProperty("level-type", "minecraft:debug");
            properties.store(Files.newOutputStream(serverProperties, new OpenOption[0]), "Minecraft server properties");
            if (eula == null) {
                eula = Files.readString(eulaTxt);
            }
            eula = eula.replace("eula=false", "eula=true");
            Files.writeString(eulaTxt, (CharSequence)eula, new OpenOption[0]);
        }
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            Command.redirect(this.path, "cmd", "/C", "echo", "stop", "|", "java", "-jar", "server.jar", "--nogui");
        } else {
            Command.redirect(this.path, "printf", "stop", "|", "java", "-jar", "server.jar", "--nogui");
        }
    }

    private void generateLevelDat(MinecraftVersion mcVersion, int dataVersion) throws IOException {
        Path levelDatPath = this.path.resolve("world/level.dat");
        Path levelDatOld = this.path.resolve("world/level.dat_old");
        if (Files.exists(levelDatPath, new LinkOption[0]) && Files.exists(levelDatOld, new LinkOption[0])) {
            return;
        }
        CompoundTag levelDat = new CompoundTag();
        CompoundTag data = new CompoundTag();
        CompoundTag worldGenSettings = new CompoundTag();
        CompoundTag dimensions = new CompoundTag();
        CompoundTag overworld = new CompoundTag();
        CompoundTag generator = new CompoundTag();
        CompoundTag version = new CompoundTag();
        CompoundTag gameRules = new CompoundTag();
        generator.putString("type", "minecraft:debug");
        overworld.put("generator", generator);
        overworld.putString("type", "minecraft:overworld");
        dimensions.put("minecraft:overworld", overworld);
        worldGenSettings.putLong("seed", 0L);
        worldGenSettings.put("dimensions", dimensions);
        version.putByte("Snapshot", (byte)0);
        version.putString("Series", "main");
        version.putInt("Id", dataVersion);
        version.putString("Name", mcVersion.id());
        gameRules.putString("spawnChunkRadius", "14");
        data.put("WorldGenSettings", worldGenSettings);
        data.put("Version", version);
        data.put("GameRules", gameRules);
        data.putInt("SpawnX", 240);
        data.putInt("SpawnZ", 240);
        data.putInt("SpawnY", 0);
        data.putString("LevelName", "world");
        data.putInt("DataVersion", dataVersion);
        data.putInt("version", 19133);
        levelDat.put("Data", data);
        if (!Files.exists(levelDatPath.getParent(), new LinkOption[0])) {
            Files.createDirectories(levelDatPath.getParent(), new FileAttribute[0]);
        }
        try (GZIPOutputStream go = new GZIPOutputStream(Files.newOutputStream(levelDatPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
            new NBTWriter().writeNamed(go, "", (Tag)levelDat);
            go.flush();
        }
        Files.copy(levelDatPath, levelDatOld, StandardCopyOption.REPLACE_EXISTING);
    }
}

