/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.querz.mcaselector.io.FileHelper;

public final class StructureRegistry {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Set<String> valid = new HashSet<String>();
    private static final Map<String, Set<String>> alts = new HashMap<String, Set<String>>();

    private StructureRegistry() {
    }

    private static boolean containsUpperCase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidName(String name) {
        return valid.contains(name);
    }

    public static Set<String> getAlts(String name) {
        return alts.getOrDefault(name, Collections.singleton(name));
    }

    static {
        FileHelper.loadFromResource("mapping/registry/structures.json", r -> {
            Set<String> set = GSON.fromJson((Reader)r, new TypeToken<Set<String>>(){});
            for (String s : set) {
                valid.add(s);
                if (StructureRegistry.containsUpperCase(s)) continue;
                valid.add("minecraft:" + s);
            }
            for (String name : valid) {
                alts.computeIfAbsent(name, k -> new HashSet()).add(name);
                if (StructureRegistry.containsUpperCase(name)) {
                    String lowerNamespace;
                    Set<String> alt = alts.get(name);
                    String lower = name.toLowerCase();
                    if (valid.contains(lower)) {
                        alt.add(lower);
                        alts.computeIfAbsent(lower, k -> new HashSet()).add(name);
                    }
                    if (!valid.contains(lowerNamespace = "minecraft:" + lower)) continue;
                    alt.add(lowerNamespace);
                    alts.computeIfAbsent(lowerNamespace, k -> new HashSet()).add(name);
                    continue;
                }
                if (name.startsWith("minecraft:")) {
                    alts.get(name).add(name.substring(10));
                    continue;
                }
                alts.get(name).add("minecraft:" + name);
            }
            return null;
        });
    }
}

