/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.querz.mcaselector.version.mapping.minecraft.MinecraftVersion;
import net.querz.mcaselector.version.mapping.minecraft.MinecraftVersionFile;
import net.querz.mcaselector.version.mapping.minecraft.Report;
import net.querz.mcaselector.version.mapping.util.CollectionAdapter;
import net.querz.mcaselector.version.mapping.util.Download;

public class StructureConfig {
    private final Set<String> structures;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(Set.class, new CollectionAdapter()).create();

    public StructureConfig() {
        this.structures = new HashSet<String>();
    }

    public StructureConfig(Set<String> structures) {
        this.structures = structures;
    }

    public static StructureConfig load(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            StructureConfig structureConfig = StructureConfig.load(reader);
            return structureConfig;
        }
    }

    public static StructureConfig load(Reader reader) throws IOException {
        return new StructureConfig(GSON.fromJson(reader, new TypeToken<Set<String>>(){}));
    }

    public void save(Path path) throws IOException {
        String json = GSON.toJson(this.structures);
        Files.writeString(path, (CharSequence)json, new OpenOption[0]);
    }

    public void merge(StructureConfig other) {
        this.structures.addAll(other.structures);
    }

    public void generate(MinecraftVersion version, Path tmp) throws IOException, InterruptedException {
        Path versionJson = tmp.resolve("version.json");
        Path serverJar = tmp.resolve("server.jar");
        Path generated = tmp.resolve("generated");
        if (!Files.exists(versionJson, new LinkOption[0])) {
            MinecraftVersionFile.download(version, versionJson);
        }
        MinecraftVersionFile versionFile = MinecraftVersionFile.load(versionJson);
        if (!Files.exists(serverJar, new LinkOption[0])) {
            Download.to(versionFile.getDownloads().server().url(), serverJar);
        }
        if (!Files.exists(generated, new LinkOption[0])) {
            Report.generate(serverJar, generated);
        }
        Path structure = generated.resolve("data/minecraft/worldgen/structure");
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(structure);){
            for (Path s : ds) {
                if (!Files.isRegularFile(s, new LinkOption[0])) continue;
                String fileName = s.getFileName().toString();
                String name = fileName.substring(0, fileName.length() - 5);
                this.structures.add(name);
            }
        }
    }
}

