/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.querz.mcaselector.io.mca.RegionChunk;
import net.querz.mcaselector.io.mca.RegionMCAFile;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.mapping.minecraft.MinecraftVersion;
import net.querz.mcaselector.version.mapping.util.CollectionAdapter;
import net.querz.mcaselector.version.mapping.util.DebugWorld;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.NBTUtil;

public class HeightmapConfig {
    @SerializedName(value="light_blocking")
    public Set<String> lightBlocking = new HashSet<String>();
    @SerializedName(value="world_surface")
    public Set<String> worldSurface = new HashSet<String>();
    @SerializedName(value="ocean_floor")
    public Set<String> oceanFloor = new HashSet<String>();
    @SerializedName(value="motion_blocking")
    public Set<String> motionBlocking = new HashSet<String>();
    @SerializedName(value="leaves")
    public Set<String> leaves = new HashSet<String>();
    public static final String LIGHT_BLOCKING = "LIGHT_BLOCKING";
    public static final String WORLD_SURFACE = "WORLD_SURFACE";
    public static final String OCEAN_FLOOR = "OCEAN_FLOOR";
    public static final String MOTION_BLOCKING = "MOTION_BLOCKING";
    public static final String MOTION_BLOCKING_NO_LEAVES = "MOTION_BLOCKING_NO_LEAVES";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(Set.class, new CollectionAdapter()).create();

    public static HeightmapConfig load(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            HeightmapConfig heightmapConfig = HeightmapConfig.load(reader);
            return heightmapConfig;
        }
    }

    public static HeightmapConfig load(Reader reader) throws IOException {
        return GSON.fromJson(reader, HeightmapConfig.class);
    }

    public void save(Path path) throws IOException {
        String json = GSON.toJson(this);
        Files.writeString(path, (CharSequence)json, new OpenOption[0]);
    }

    public void generate(MinecraftVersion version, Path tmp) throws IOException, InterruptedException {
        DebugWorld debugWorld = new DebugWorld(tmp);
        debugWorld.generate(version);
        Path region_0_0 = tmp.resolve("world/region/r.0.0.mca");
        RegionMCAFile region = new RegionMCAFile(region_0_0.toFile());
        region.load(false);
        HashSet<String> mbnl = new HashSet<String>();
        block2: for (int i = 0; i < 1024; ++i) {
            ListTag sections;
            RegionChunk chunk = (RegionChunk)region.getChunk(i);
            if (chunk == null || (sections = (ListTag)Helper.tagFromCompound(chunk.getData(), "sections")) == null) continue;
            CompoundTag section = null;
            for (CompoundTag s : sections.iterateType(CompoundTag.class)) {
                int y = Helper.numberFromCompound(s, "Y", -5).intValue();
                if (y != 4) continue;
                section = s;
                break;
            }
            if (section == null) continue;
            int height = 125;
            for (int x = 1; x < 16; x += 2) {
                for (int z = 1; z < 16; z += 2) {
                    CompoundTag block = this.getBlockAt(section, x, 6, z);
                    if (block == null) continue block2;
                    try {
                        int worldSurface = this.getHeightmapDataAt(chunk.getData(), x, z, WORLD_SURFACE);
                        int oceanFloor = this.getHeightmapDataAt(chunk.getData(), x, z, OCEAN_FLOOR);
                        int motionBlocking = this.getHeightmapDataAt(chunk.getData(), x, z, MOTION_BLOCKING);
                        int motionBlockingNoLeaves = this.getHeightmapDataAt(chunk.getData(), x, z, MOTION_BLOCKING_NO_LEAVES);
                        String name = block.getString("Name");
                        if (worldSurface > height) {
                            this.worldSurface.add(name);
                        }
                        if (oceanFloor > height) {
                            this.oceanFloor.add(name);
                        }
                        if (motionBlocking > height) {
                            this.motionBlocking.add(name);
                        }
                        if (motionBlockingNoLeaves <= height) continue;
                        mbnl.add(name);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(NBTUtil.toSNBT(section));
                        throw e;
                    }
                }
            }
        }
        for (String id : this.motionBlocking) {
            if (mbnl.contains(id)) continue;
            this.leaves.add(id);
        }
        assert (!this.worldSurface.isEmpty());
        assert (!this.oceanFloor.isEmpty());
        assert (!this.motionBlocking.isEmpty());
        assert (!this.leaves.isEmpty());
    }

    private int getHeightmapDataAt(CompoundTag root, int x, int z, String heightmapID) {
        int index = z * 16 + x;
        CompoundTag heightmaps = root.getCompoundTag("Heightmaps");
        long[] data = heightmaps.getLongArray(heightmapID);
        int dataIndex = Math.floorDiv(index, 7);
        int startBit = index % 7 * 9;
        return (int)(data[dataIndex] >> startBit & 0x1FFL);
    }

    private CompoundTag getBlockAt(CompoundTag section, int x, int y, int z) {
        ListTag palette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(section, "block_states"), "palette");
        if (palette == null) {
            return null;
        }
        long[] data = Helper.longArrayFromCompound(Helper.tagFromCompound(section, "block_states"), "data");
        if (data == null) {
            return null;
        }
        int paletteIndex = this.getPaletteIndex(x & 0xF, y & 0xF, z & 0xF, data);
        return palette.getCompound(paletteIndex);
    }

    private int getPaletteIndex(int x, int y, int z, long[] data) {
        int bits;
        int n = bits = data == null ? 0 : data.length >> 6;
        if (bits == 0) {
            return 0;
        }
        int clean = (2 << bits - 1) - 1;
        int index = y * 256 + z * 16 + x;
        int indexesPerLong = (int)(64.0 / (double)bits);
        int blockStatesIndex = index / indexesPerLong;
        int startBit = index % indexesPerLong * bits;
        return (int)(data[blockStatesIndex] >> startBit) & clean;
    }
}

