/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.color;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import net.querz.mcaselector.version.mapping.color.BiomeColors;
import net.querz.mcaselector.version.mapping.color.BlockColor;
import net.querz.mcaselector.version.mapping.color.BlockStateColors;
import net.querz.mcaselector.version.mapping.color.SingleStateColors;
import net.querz.mcaselector.version.mapping.color.StateColors;

public class ColorMapping {
    private static final StateColors missing = new SingleStateColors(BlockColor.MISSING){

        @Override
        public boolean hasColor(BitSet state) {
            return false;
        }
    };
    public final Map<String, StateColors> colors;

    public ColorMapping() {
        this.colors = new HashMap<String, StateColors>();
    }

    private ColorMapping(Map<String, StateColors> colors) {
        this.colors = colors;
    }

    public BlockColor getBlockColor(String name, BitSet state) {
        return this.colors.getOrDefault(name, missing).getColor(state);
    }

    public boolean hasBlockColor(String name, BitSet state) {
        return this.colors.containsKey(name) && this.colors.get(name).hasColor(state);
    }

    public boolean hasBlockStateColors(String name) {
        StateColors c = this.colors.get(name);
        return c != null && c instanceof BlockStateColors;
    }

    public void addBlockColor(String name, BitSet state, BlockColor color) {
        if (this.colors.containsKey(name)) {
            StateColors stateColors = this.colors.get(name);
            stateColors.setColor(state, color);
        } else if (state == null) {
            this.colors.put(name, new SingleStateColors(color));
        } else {
            this.colors.put(name, new BlockStateColors(state, color));
        }
    }

    public void setBlockColor(String name, StateColors color) {
        this.colors.put(name, color);
    }

    public void compress() {
        for (Map.Entry<String, StateColors> entry : this.colors.entrySet()) {
            StateColors stateColors = entry.getValue();
            if (!(stateColors instanceof BlockStateColors)) continue;
            BlockStateColors blockStateColors = (BlockStateColors)stateColors;
            StateColors compressedColors = blockStateColors.compress();
            this.colors.put(entry.getKey(), compressedColors);
        }
    }

    public TintCache createTintCache(BiomeColors tints) {
        TintCache cache = new TintCache(new HashMap<String, Map<String, StateColors>>());
        for (Map.Entry<String, StateColors> entry : this.colors.entrySet()) {
            for (Map.Entry color : entry.getValue()) {
                if ((((BlockColor)color.getValue()).properties & 2) > 0) {
                    this.applyTints(entry.getKey(), (BitSet)color.getKey(), ((BlockColor)color.getValue()).color, tints, BiomeColors.BiomeTints::grassColor, cache);
                    continue;
                }
                if ((((BlockColor)color.getValue()).properties & 4) > 0) {
                    this.applyTints(entry.getKey(), (BitSet)color.getKey(), ((BlockColor)color.getValue()).color, tints, BiomeColors.BiomeTints::foliageColor, cache);
                    continue;
                }
                if ((((BlockColor)color.getValue()).properties & 8) > 0) {
                    this.applyTints(entry.getKey(), (BitSet)color.getKey(), ((BlockColor)color.getValue()).color, tints, BiomeColors.BiomeTints::waterColor, cache);
                    continue;
                }
                if ((((BlockColor)color.getValue()).properties & 0x80) <= 0) continue;
                this.applyTints(entry.getKey(), (BitSet)color.getKey(), ((BlockColor)color.getValue()).color, tints, BiomeColors.BiomeTints::dryFoliageColor, cache);
            }
        }
        return cache;
    }

    private void applyTints(String blockName, BitSet blockState, int base, BiomeColors tints, Function<BiomeColors.BiomeTints, Integer> colorProvider, TintCache cache) {
        Map colored = cache.data.computeIfAbsent(blockName, k -> new HashMap());
        for (Map.Entry<String, BiomeColors.BiomeTints> biomeTints : tints.biomes.entrySet()) {
            int c = ColorMapping.applyTint(base, colorProvider.apply(biomeTints.getValue()));
            if (blockState == null) {
                colored.put(biomeTints.getKey(), new SingleStateColors(new BlockColor(c)));
                continue;
            }
            colored.computeIfAbsent(biomeTints.getKey(), k -> new BlockStateColors()).setColor(blockState, new BlockColor(c));
        }
    }

    public LegacyTintCache createLegacyTintCache(BiomeColors tints) {
        LegacyTintCache cache = new LegacyTintCache(new HashMap<String, int[]>());
        for (Map.Entry<String, StateColors> entry : this.colors.entrySet()) {
            BlockColor color = entry.getValue().getDefaultColor();
            if ((color.properties & 2) > 0) {
                this.applyTintsLegacy(entry.getKey(), color.color, tints, BiomeColors.BiomeTints::grassColor, cache);
                continue;
            }
            if ((color.properties & 4) > 0) {
                this.applyTintsLegacy(entry.getKey(), color.color, tints, BiomeColors.BiomeTints::foliageColor, cache);
                continue;
            }
            if ((color.properties & 8) > 0) {
                this.applyTintsLegacy(entry.getKey(), color.color, tints, BiomeColors.BiomeTints::waterColor, cache);
                continue;
            }
            if ((color.properties & 0x80) <= 0) continue;
            this.applyTintsLegacy(entry.getKey(), color.color, tints, BiomeColors.BiomeTints::dryFoliageColor, cache);
        }
        return cache;
    }

    private void applyTintsLegacy(String blockName, int base, BiomeColors tints, Function<BiomeColors.BiomeTints, Integer> colorProvider, LegacyTintCache cache) {
        int[] colored = cache.data.computeIfAbsent(blockName, k -> new int[256]);
        for (Map.Entry<String, BiomeColors.BiomeTints> biomeTints : tints.biomes.entrySet()) {
            int c;
            colored[Integer.parseInt((String)biomeTints.getKey())] = c = ColorMapping.applyTint(base, colorProvider.apply(biomeTints.getValue()));
        }
    }

    public static int applyTint(int color, int tint) {
        int nr = (tint >> 16 & 0xFF) * (color >> 16 & 0xFF) >> 8;
        int ng = (tint >> 8 & 0xFF) * (color >> 8 & 0xFF) >> 8;
        int nb = (tint & 0xFF) * (color & 0xFF) >> 8;
        return color & 0xFF000000 | nr << 16 | ng << 8 | nb;
    }

    public record TintCache(Map<String, Map<String, StateColors>> data) {
        public BlockColor getColor(String block, String biome, BitSet state) {
            StateColors b;
            Map<String, StateColors> a = this.data.get(block);
            if (a != null && (b = a.get(biome)) != null) {
                return b.getColor(state);
            }
            return null;
        }
    }

    public record LegacyTintCache(Map<String, int[]> data) {
        public int getColor(String block, int biome, BitSet state) {
            int[] a = this.data.get(block);
            if (a != null) {
                return a[biome];
            }
            return ColorMapping.missing.getColor(null).color;
        }
    }

    public static class ColorMappingTypeAdapterFactory
    implements TypeAdapterFactory {
        private static final TypeAdapterFactory instance = new ColorMappingTypeAdapterFactory();

        private ColorMappingTypeAdapterFactory() {
        }

        public static TypeAdapterFactory getColorMappingTypeAdapterFactory() {
            return instance;
        }

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getRawType() != ColorMapping.class) {
                return null;
            }
            return new ColorMappingTypeAdapter(gson);
        }

        private static class ColorMappingTypeAdapter
        extends TypeAdapter<ColorMapping> {
            private final Gson gson;
            private final TypeAdapter<StateColors> adapter;

            public ColorMappingTypeAdapter(Gson gson) {
                this.gson = gson;
                this.adapter = StateColors.StateColorsTypeAdapterFactory.getStateColorsTypeAdapterFactory().create(gson, StateColors.StateColorsTypeAdapterFactory.token);
            }

            @Override
            public void write(JsonWriter out, ColorMapping value) throws IOException {
                out.beginObject();
                TreeMap<String, StateColors> colors = new TreeMap<String, StateColors>(value.colors);
                for (Map.Entry<String, StateColors> entry : colors.entrySet()) {
                    out.name(entry.getKey());
                    this.gson.toJson((Object)entry.getValue(), entry.getValue().getClass(), out);
                }
                out.endObject();
            }

            @Override
            public ColorMapping read(JsonReader in) throws IOException {
                HashMap<String, StateColors> colors = new HashMap<String, StateColors>();
                in.beginObject();
                while (in.hasNext()) {
                    String name = in.nextName();
                    StateColors color = this.adapter.read(in);
                    colors.put(name, color);
                }
                in.endObject();
                return new ColorMapping(colors);
            }
        }
    }
}

