/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.color;

import com.google.gson.annotations.SerializedName;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.querz.mcaselector.version.mapping.color.BlockColor;
import net.querz.mcaselector.version.mapping.color.SingleStateColors;
import net.querz.mcaselector.version.mapping.color.StateColors;

public class BlockStateColors
implements StateColors {
    @SerializedName(value="states")
    private final Map<BitSet, BlockColor> blockStateColors;
    @SerializedName(value="default")
    private BlockColor defaultColor;

    public BlockStateColors(Map<BitSet, BlockColor> blockStateColors) {
        this.blockStateColors = blockStateColors;
    }

    public BlockStateColors(BitSet state, BlockColor color) {
        this.blockStateColors = new HashMap<BitSet, BlockColor>();
        this.blockStateColors.put(state, color);
    }

    public BlockStateColors() {
        this.blockStateColors = new HashMap<BitSet, BlockColor>();
    }

    @Override
    public BlockColor getColor(BitSet state) {
        return this.blockStateColors.getOrDefault(state, this.defaultColor);
    }

    @Override
    public BlockColor getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    public boolean hasColor(BitSet state) {
        return this.blockStateColors.containsKey(state);
    }

    @Override
    public void setColor(BitSet state, BlockColor color) {
        this.blockStateColors.put(state, color);
        if (this.defaultColor == null) {
            this.defaultColor = color;
        }
    }

    public StateColors compress() {
        BlockColor c = null;
        for (Map.Entry<BitSet, BlockColor> entry : this.blockStateColors.entrySet()) {
            if (c == null) {
                c = entry.getValue();
                continue;
            }
            if (c.equals(entry.getValue())) continue;
            return this;
        }
        return new SingleStateColors(c);
    }

    @Override
    public Iterator<Map.Entry<BitSet, BlockColor>> iterator() {
        return this.blockStateColors.entrySet().iterator();
    }
}

