/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.mapping.color;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public class BlockColor {
    public static final BlockColor MISSING = new BlockColor(-1);
    public int color;
    public int properties;
    public static final int TRANSPARENT = 1;
    public static final int GRASS_TINT = 2;
    public static final int FOLIAGE_TINT = 4;
    public static final int WATER = 8;
    public static final int FOLIAGE = 16;
    public static final int STATIC_TINT = 32;
    public static final int STATIC_COLOR = 64;
    public static final int DRY_FOLIAGE_TINT = 128;
    public static final int TINTED = 142;

    private BlockColor() {
    }

    public BlockColor(int color) {
        this(color, 0);
    }

    public BlockColor(int color, int properties) {
        this.color = color;
        this.properties = properties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof BlockColor)) return false;
        BlockColor c = (BlockColor)obj;
        if (this.color != c.color) return false;
        if (this.properties != c.properties) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.color, this.properties);
    }

    public String toString() {
        return String.format("{%06x, %s, %s, %s, %s, %s, %s, %s, %s}", this.color, this.properties & 1, this.properties & 2, this.properties & 4, this.properties & 8, this.properties & 0x10, this.properties & 0x20, this.properties & 0x40, this.properties & 0x80);
    }

    public static class BlockColorAdapter
    extends TypeAdapter<BlockColor> {
        @Override
        public void write(JsonWriter out, BlockColor value) throws IOException {
            if (value.properties != 0) {
                out.beginObject();
                out.name("color");
                out.value(String.format("%06x", value.color));
                out.name("properties");
                out.value(value.properties);
                out.endObject();
            } else {
                out.value(String.format("%06x", value.color));
            }
        }

        @Override
        public BlockColor read(JsonReader in) throws IOException {
            BlockColor blockColor = new BlockColor();
            if (in.peek() == JsonToken.BEGIN_OBJECT) {
                in.beginObject();
                while (in.hasNext()) {
                    switch (in.nextName()) {
                        case "color": {
                            blockColor.color = Integer.parseInt(in.nextString(), 16);
                            break;
                        }
                        case "properties": {
                            blockColor.properties = in.nextInt();
                        }
                    }
                }
                in.endObject();
            } else {
                blockColor.color = Integer.parseInt(in.nextString(), 16);
            }
            return blockColor;
        }
    }
}

