/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_9;

import net.querz.mcaselector.util.math.Bits;
import net.querz.mcaselector.util.math.MathUtil;
import net.querz.mcaselector.version.ChunkRenderer;
import net.querz.mcaselector.version.ColorMapping;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.Tag;

@MCVersionImplementation(value=100)
public class ChunkRenderer_15w32a
implements ChunkRenderer<Integer, Integer> {
    @Override
    public void drawChunk(CompoundTag root, ColorMapping<Integer, Integer> colorMapping, int x, int z, int scale, int[] pixelBuffer, int[] waterPixels, short[] terrainHeights, short[] waterHeights, boolean water, int height) {
        ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(root, "Sections");
        if (sections == null || sections.getElementType() != Tag.Type.COMPOUND) {
            return;
        }
        CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
        height = MathUtil.clamp(height, 0, 255);
        int scaleBits = Bits.msbPosition(scale);
        int yMax = 1 + (height >> 4);
        CompoundTag[] indexedSections = new CompoundTag[yMax];
        sections.iterateType(CompoundTag.class).forEach(s -> {
            int y = Helper.numberFromCompound(s, "Y", -5).intValue();
            if (y >= 0 && y < yMax) {
                indexedSections[y] = s;
            }
        });
        boolean[] indexed = new boolean[yMax];
        byte[][] indexedBlocks = new byte[yMax][];
        byte[][] indexedData = new byte[yMax][];
        byte[] biomes = Helper.byteArrayFromCompound(level, "Biomes");
        int[] startHeight = new int[yMax];
        int[] sectionHeight = new int[yMax];
        for (int cx = 0; cx < 16; cx += scale) {
            block1: for (int cz = 0; cz < 16; cz += scale) {
                int pixelIndex = (z + (cz >> scaleBits)) * (512 >> scaleBits) + (x + (cx >> scaleBits));
                int biome = this.getBiome(cx, cz, biomes);
                boolean waterDepth = false;
                for (int i = height >> 4; i >= 0; --i) {
                    byte[] blocks;
                    if (indexedSections[i] == null) continue;
                    if (!indexed[i]) {
                        CompoundTag section = indexedSections[i];
                        if (section.containsKey("Blocks") && section.containsKey("Data")) {
                            indexedBlocks[i] = Helper.byteArrayFromCompound(section, "Blocks");
                            indexedData[i] = Helper.byteArrayFromCompound(section, "Data");
                        }
                        startHeight[i] = height >> 4 == i ? height & 0xF : 15;
                        sectionHeight[i] = i * 16;
                        indexed[i] = true;
                    }
                    if ((blocks = indexedBlocks[i]) == null) continue;
                    byte[] blockData = indexedData[i];
                    for (int cy = startHeight[i]; cy >= 0; --cy) {
                        int index = cy * 256 + cz * 16 + cx;
                        int block = blocks[index] & 0xFF;
                        int data = ((index & 1) == 0 ? blockData[index >> 1] : blockData[index >> 1] >> 4) & 0xF;
                        if (colorMapping.isTransparent(block)) continue;
                        if (water) {
                            if (!waterDepth) {
                                pixelBuffer[pixelIndex] = colorMapping.getRGB((block << 4) + data, biome);
                                waterHeights[pixelIndex] = (short)(sectionHeight[i] + cy);
                            }
                            if (colorMapping.isWater(block)) {
                                waterDepth = true;
                                continue;
                            }
                            waterPixels[pixelIndex] = colorMapping.getRGB((block << 4) + data, biome);
                        } else {
                            pixelBuffer[pixelIndex] = colorMapping.getRGB((block << 4) + data, biome);
                        }
                        terrainHeights[pixelIndex] = (short)(sectionHeight[i] + cy);
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public void drawLayer(CompoundTag root, ColorMapping<Integer, Integer> colorMapping, int x, int z, int scale, int[] pixelBuffer, int height) {
        ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(root, "Sections");
        if (sections == null) {
            return;
        }
        CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
        height = MathUtil.clamp(height, 0, 255);
        CompoundTag section = null;
        for (CompoundTag s : sections.iterateType(CompoundTag.class)) {
            int y = Helper.numberFromCompound(s, "Y", -1).intValue();
            if (y != height >> 4) continue;
            section = s;
            break;
        }
        if (section == null) {
            return;
        }
        byte[] blocks = Helper.byteArrayFromCompound(section, "Blocks");
        byte[] blockData = Helper.byteArrayFromCompound(section, "Data");
        if (blocks == null || blockData == null) {
            return;
        }
        byte[] biomes = Helper.byteArrayFromCompound(level, "Biomes");
        int scaleBits = Bits.msbPosition(scale);
        int cy = height & 0xF;
        for (int cx = 0; cx < 16; cx += scale) {
            for (int cz = 0; cz < 16; cz += scale) {
                int index = cy * 256 + cz * 16 + cx;
                int block = blocks[index] & 0xFF;
                if (colorMapping.isTransparent(block)) continue;
                int data = ((index & 1) == 0 ? blockData[index >> 1] : blockData[index >> 1] >> 4) & 0xF;
                int pixelIndex = (z + (cz >> scaleBits)) * (512 >> scaleBits) + (x + (cx >> scaleBits));
                int biome = this.getBiome(cx, cz, biomes);
                pixelBuffer[pixelIndex] = colorMapping.getRGB((block << 4) + data, biome);
            }
        }
    }

    @Override
    public void drawCaves(CompoundTag root, ColorMapping<Integer, Integer> colorMapping, int x, int z, int scale, int[] pixelBuffer, short[] terrainHeights, int height) {
        ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(root, "Sections");
        if (sections == null || sections.getElementType() != Tag.Type.COMPOUND) {
            return;
        }
        CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
        height = MathUtil.clamp(height, 0, 255);
        int scaleBits = Bits.msbPosition(scale);
        int yMax = 1 + (height >> 4);
        CompoundTag[] indexedSections = new CompoundTag[yMax];
        sections.iterateType(CompoundTag.class).forEach(s -> {
            int y = Helper.numberFromCompound(s, "Y", -1).intValue();
            if (y >= 0 && y < yMax) {
                indexedSections[y] = s;
            }
        });
        boolean[] indexed = new boolean[yMax];
        byte[][] indexedBlocks = new byte[yMax][];
        byte[][] indexedData = new byte[yMax][];
        byte[] biomes = Helper.byteArrayFromCompound(level, "Biomes");
        int[] startHeight = new int[yMax];
        int[] sectionHeight = new int[yMax];
        for (int cx = 0; cx < 16; cx += scale) {
            block1: for (int cz = 0; cz < 16; cz += scale) {
                int pixelIndex = (z + (cz >> scaleBits)) * (512 >> scaleBits) + (x + (cx >> scaleBits));
                int biome = this.getBiome(cx, cz, biomes);
                int ignored = 0;
                boolean doneSkipping = false;
                for (int i = height >> 4; i >= 0; --i) {
                    byte[] blocks;
                    if (indexedSections[i] == null) continue;
                    if (!indexed[i]) {
                        CompoundTag section = indexedSections[i];
                        if (section.containsKey("Blocks") && section.containsKey("Data")) {
                            indexedBlocks[i] = Helper.byteArrayFromCompound(section, "Blocks");
                            indexedData[i] = Helper.byteArrayFromCompound(section, "Data");
                        }
                        startHeight[i] = height >> 4 == i ? height & 0xF : 15;
                        sectionHeight[i] = i * 16;
                        indexed[i] = true;
                    }
                    if ((blocks = indexedBlocks[i]) == null) continue;
                    byte[] blockData = indexedData[i];
                    for (int cy = startHeight[i]; cy >= 0; --cy) {
                        int index = cy * 256 + cz * 16 + cx;
                        int block = blocks[index] & 0xFF;
                        int data = ((index & 1) == 0 ? blockData[index >> 1] : blockData[index >> 1] >> 4) & 0xF;
                        if (!colorMapping.isTransparent(block) && !colorMapping.isFoliage(block)) {
                            if (doneSkipping) {
                                pixelBuffer[pixelIndex] = colorMapping.getRGB((block << 4) + data, biome);
                                terrainHeights[pixelIndex] = (short)(sectionHeight[i] + cy);
                                continue block1;
                            }
                            ++ignored;
                            continue;
                        }
                        if (ignored <= 0) continue;
                        doneSkipping = true;
                    }
                }
            }
        }
    }

    @Override
    public CompoundTag minimizeChunk(CompoundTag root) {
        CompoundTag minData = new CompoundTag();
        minData.put("DataVersion", root.get("DataVersion").copy());
        CompoundTag level = new CompoundTag();
        minData.put("Level", level);
        level.put("Biomes", root.getCompound("Level").get("Biomes").copy());
        level.put("Sections", root.getCompound("Level").get("Sections").copy());
        level.put("Status", root.getCompound("Level").get("Status").copy());
        return minData;
    }

    private int getBiome(int x, int z, byte[] biomes) {
        if (biomes == null || biomes.length != 256) {
            return 0;
        }
        return biomes[z * 16 + x] & 0xFF;
    }
}

