/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_18;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.range.Range;
import net.querz.mcaselector.util.validation.ValidationHelper;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.mcaselector.version.java_1_17.ChunkFilter_20w45a;
import net.querz.mcaselector.version.java_1_17.ChunkFilter_21w06a;
import net.querz.mcaselector.version.java_1_18.ChunkFilter_21w37a;
import net.querz.mcaselector.version.java_1_9.ChunkFilter_15w32a;
import net.querz.mcaselector.version.mapping.registry.BiomeRegistry;
import net.querz.mcaselector.version.mapping.registry.StatusRegistry;
import net.querz.nbt.ByteTag;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.IntTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.LongArrayTag;
import net.querz.nbt.LongTag;
import net.querz.nbt.StringTag;
import net.querz.nbt.Tag;

public class ChunkFilter_21w43a {

    @MCVersionImplementation(value=2844)
    public static class Entities
    extends ChunkFilter_20w45a.Entities {
        @Override
        public void deleteEntities(ChunkData data, List<Range> ranges) {
            ListTag entities = Helper.tagFromLevelFromRoot(Helper.getEntities(data), "Entities", null);
            this.deleteEntities(entities, ranges);
            ListTag protoEntities = Helper.tagFromLevelFromRoot(Helper.getRegion(data), "entities", null);
            this.deleteEntities(protoEntities, ranges);
        }
    }

    @MCVersionImplementation(value=2844)
    public static class Blending
    implements ChunkFilter.Blending {
        @Override
        public void forceBlending(ChunkData data) {
            int min = 0;
            int max = 0;
            CompoundTag root = Helper.getRegion(data);
            ListTag sections = (ListTag)Helper.tagFromCompound(root, "sections");
            if (sections == null) {
                return;
            }
            for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                int y = Helper.numberFromCompound(section, "Y", 0).intValue();
                min = Math.min(y, min);
                max = Math.max(y, max);
            }
            min = Math.min(min, -4);
            max = Math.max(max, 20);
            CompoundTag blendingData = new CompoundTag();
            blendingData.putInt("min_section", min);
            blendingData.putInt("max_section", max);
            root.put("blending_data", blendingData);
            root.remove("Heightmaps");
            root.remove("isLightOn");
        }
    }

    @MCVersionImplementation(value=2844)
    public static class LightPopulated
    implements ChunkFilter.LightPopulated {
        @Override
        public ByteTag getLightPopulated(ChunkData data) {
            return (ByteTag)Helper.tagFromCompound(Helper.getRegion(data), "isLightOn");
        }

        @Override
        public void setLightPopulated(ChunkData data, byte lightPopulated) {
            if (Helper.getRegion(data) != null) {
                Helper.getRegion(data).putByte("isLightOn", lightPopulated);
            }
        }
    }

    @MCVersionImplementation(value=2844)
    public static class Pos
    implements ChunkFilter.Pos {
        @Override
        public IntTag getXPos(ChunkData data) {
            return (IntTag)Helper.tagFromCompound(Helper.getRegion(data), "xPos");
        }

        @Override
        public IntTag getYPos(ChunkData data) {
            return (IntTag)Helper.tagFromCompound(Helper.getRegion(data), "yPos");
        }

        @Override
        public IntTag getZPos(ChunkData data) {
            return (IntTag)Helper.tagFromCompound(Helper.getRegion(data), "zPos");
        }
    }

    @MCVersionImplementation(value=2844)
    public static class LastUpdate
    implements ChunkFilter.LastUpdate {
        @Override
        public LongTag getLastUpdate(ChunkData data) {
            return (LongTag)Helper.tagFromCompound(Helper.getRegion(data), "LastUpdate");
        }

        @Override
        public void setLastUpdate(ChunkData data, long lastUpdate) {
            if (Helper.getRegion(data) != null) {
                Helper.getRegion(data).putLong("LastUpdate", lastUpdate);
            }
        }
    }

    @MCVersionImplementation(value=2844)
    public static class Status
    implements ChunkFilter.Status {
        @Override
        public StringTag getStatus(ChunkData data) {
            return (StringTag)Helper.tagFromCompound(Helper.getRegion(data), "Status");
        }

        @Override
        public void setStatus(ChunkData data, StatusRegistry.StatusIdentifier status) {
            if (Helper.getRegion(data) != null) {
                Helper.getRegion(data).putString("Status", status.getStatus());
            }
        }

        @Override
        public boolean matchStatus(ChunkData data, StatusRegistry.StatusIdentifier status) {
            StringTag tag = this.getStatus(data);
            if (tag == null) {
                return false;
            }
            return status.getStatus().equals(tag.getValue());
        }
    }

    @MCVersionImplementation(value=2844)
    public static class Structures
    implements ChunkFilter.Structures {
        @Override
        public CompoundTag getStructureReferences(ChunkData data) {
            return (CompoundTag)Helper.tagFromCompound(Helper.tagFromCompound(Helper.getRegion(data), "structures"), "References");
        }

        @Override
        public CompoundTag getStructureStarts(ChunkData data) {
            return (CompoundTag)Helper.tagFromCompound(Helper.tagFromCompound(Helper.getRegion(data), "structures"), "starts");
        }
    }

    @MCVersionImplementation(value=2844)
    public static class TileEntities
    implements ChunkFilter.TileEntities {
        @Override
        public ListTag getTileEntities(ChunkData data) {
            return (ListTag)Helper.tagFromCompound(Helper.getRegion(data), "block_entities");
        }
    }

    @MCVersionImplementation(value=2844)
    public static class Merge
    extends ChunkFilter_21w06a.Merge {
        @Override
        public void mergeChunks(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset) {
            this.mergeCompoundTagLists(source, destination, ranges, yOffset, "sections", c -> ((CompoundTag)c).getInt("Y"));
            this.mergeCompoundTagLists(source, destination, ranges, yOffset, "block_entities", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeCompoundTagLists(source, destination, ranges, yOffset, "block_ticks", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeCompoundTagLists(source, destination, ranges, yOffset, "fluid_ticks", c -> ((CompoundTag)c).getInt("y") >> 4);
            this.mergeListTagLists(source, destination, ranges, yOffset, "PostProcessing");
            this.mergeStructures(source, destination, ranges, yOffset);
        }

        @Override
        protected void mergeStructures(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset) {
            int[] bb;
            Object child;
            int i;
            ListTag children;
            CompoundTag sourceStarts = Helper.tagFromCompound(Helper.tagFromCompound(source, "structures"), "starts", new CompoundTag());
            CompoundTag destinationStarts = Helper.tagFromCompound(Helper.tagFromCompound(destination, "structures"), "starts", new CompoundTag());
            if (!destinationStarts.isEmpty()) {
                block0: for (Map.Entry<String, Tag> start : destinationStarts) {
                    int[] bb2;
                    children = Helper.tagFromCompound(start.getValue(), "Children", null);
                    if (children != null) {
                        block1: for (i = 0; i < children.size(); ++i) {
                            child = children.getCompound(i);
                            bb = Helper.intArrayFromCompound((Tag)child, "BB");
                            if (bb == null || bb.length != 6) continue;
                            for (Range range : ranges) {
                                if (!range.contains(bb[1] >> 4 - yOffset) || !range.contains(bb[4] >> 4 - yOffset)) continue;
                                children.remove(i);
                                --i;
                                continue block1;
                            }
                        }
                    }
                    if (children != null && !children.isEmpty() || (bb2 = Helper.intArrayFromCompound(start.getValue(), "BB")) == null || bb2.length != 6) continue;
                    for (Range range : ranges) {
                        if (!range.contains(bb2[1] >> 4 - yOffset) || !range.contains(bb2[4] >> 4 - yOffset)) continue;
                        CompoundTag emptyStart = new CompoundTag();
                        emptyStart.putString("id", "INVALID");
                        destinationStarts.put(start.getKey(), emptyStart);
                        continue block0;
                    }
                }
            }
            for (Map.Entry<String, Tag> start : sourceStarts) {
                children = Helper.tagFromCompound(start.getValue(), "Children", null);
                if (children == null) continue;
                block5: for (i = 0; i < children.size(); ++i) {
                    child = children.getCompound(i);
                    bb = Helper.intArrayFromCompound((Tag)child, "BB");
                    if (bb == null) continue;
                    for (Range range : ranges) {
                        ListTag destinationChildren;
                        if (!range.contains(bb[1] >> 4 - yOffset) && !range.contains(bb[4] >> 4 - yOffset)) continue;
                        CompoundTag destinationStart = Helper.tagFromCompound(destinationStarts, start.getKey(), null);
                        if (destinationStart == null || "INVALID".equals(destinationStart.getString("id"))) {
                            destinationStart = ((CompoundTag)start.getValue()).copy();
                            ListTag clonedDestinationChildren = Helper.tagFromCompound(destinationStart, "Children", null);
                            if (clonedDestinationChildren != null) {
                                clonedDestinationChildren.clear();
                            }
                            destinationStarts.put(start.getKey(), destinationStart);
                        }
                        if ((destinationChildren = (ListTag)Helper.tagFromCompound(destinationStarts.get(start.getKey()), "Children", null)) == null) {
                            destinationChildren = new ListTag();
                            destinationStart.put("Children", destinationChildren);
                        }
                        destinationChildren.add(children.get(i));
                        continue block5;
                    }
                }
            }
        }

        @Override
        public CompoundTag newEmptyChunk(Point2i absoluteLocation, int dataVersion) {
            CompoundTag root = new CompoundTag();
            root.putInt("xPos", absoluteLocation.getX());
            root.putInt("yPos", -4);
            root.putInt("zPos", absoluteLocation.getZ());
            root.putString("Status", "full");
            root.putInt("DataVersion", dataVersion);
            return root;
        }
    }

    @MCVersionImplementation(value=2844)
    public static class Relocate
    extends ChunkFilter_21w06a.Relocate {
        @Override
        public boolean relocate(CompoundTag root, Point3i offset) {
            CompoundTag structures;
            ListTag liquidTicks;
            ListTag tileTicks;
            root.putInt("xPos", root.getInt("xPos") + offset.blockToChunk().getX());
            root.putInt("zPos", root.getInt("zPos") + offset.blockToChunk().getZ());
            ListTag tileEntities = (ListTag)Helper.tagFromCompound(root, "block_entities");
            if (tileEntities != null) {
                tileEntities.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTileEntity((CompoundTag)v, offset)));
            }
            if ((tileTicks = (ListTag)Helper.tagFromCompound(root, "block_ticks")) != null) {
                tileTicks.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTick((CompoundTag)v, offset)));
            }
            if ((liquidTicks = (ListTag)Helper.tagFromCompound(root, "fluid_ticks")) != null) {
                liquidTicks.forEach(v -> ValidationHelper.catchAndLog(() -> this.applyOffsetToTick((CompoundTag)v, offset)));
            }
            if ((structures = (CompoundTag)Helper.tagFromCompound(root, "structures")) != null) {
                ValidationHelper.catchAndLog(() -> this.applyOffsetToStructures(structures, offset));
            }
            ValidationHelper.catchAndLog(() -> Helper.applyOffsetToListOfShortTagLists(root, "PostProcessing", offset.blockToSection()));
            ListTag sections = (ListTag)Helper.tagFromCompound(root, "sections");
            if (sections != null) {
                ListTag newSections = new ListTag();
                Range sectionRange = Helper.findSectionRange(root, sections);
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    if (!this.applyOffsetToSection(section, offset.blockToSection(), sectionRange)) continue;
                    newSections.add(section);
                }
                root.put("sections", newSections);
            }
            return true;
        }

        @Override
        protected void applyOffsetToStructures(CompoundTag structures, Point3i offset) {
            CompoundTag starts;
            Point3i chunkOffset = offset.blockToChunk();
            CompoundTag references = (CompoundTag)Helper.tagFromCompound(structures, "References");
            if (references != null) {
                for (Map.Entry<String, Tag> entry : references) {
                    long[] reference = ValidationHelper.silent(() -> ((LongArrayTag)entry.getValue()).getValue(), null);
                    if (reference == null) continue;
                    for (int i = 0; i < reference.length; ++i) {
                        int x = (int)reference[i];
                        int z = (int)(reference[i] >> 32);
                        reference[i] = ((long)(z + chunkOffset.getZ()) & 0xFFFFFFFFL) << 32 | (long)(x + chunkOffset.getX()) & 0xFFFFFFFFL;
                    }
                }
            }
            if ((starts = (CompoundTag)Helper.tagFromCompound(structures, "starts")) != null) {
                for (Map.Entry<String, Tag> entry : starts) {
                    ListTag children;
                    CompoundTag structure = ValidationHelper.silent(() -> (CompoundTag)entry.getValue(), null);
                    if ("INVALID".equals(Helper.stringFromCompound(structure, "id"))) continue;
                    Helper.applyIntIfPresent(structure, "ChunkX", chunkOffset.getX());
                    Helper.applyIntIfPresent(structure, "ChunkZ", chunkOffset.getZ());
                    Helper.applyOffsetToBB(Helper.intArrayFromCompound(structure, "BB"), offset);
                    ListTag processed = (ListTag)Helper.tagFromCompound(structure, "Processed");
                    if (processed != null) {
                        for (CompoundTag chunk : processed.iterateType(CompoundTag.class)) {
                            Helper.applyIntIfPresent(chunk, "X", chunkOffset.getX());
                            Helper.applyIntIfPresent(chunk, "Z", chunkOffset.getZ());
                        }
                    }
                    if ((children = (ListTag)Helper.tagFromCompound(structure, "Children")) == null) continue;
                    for (CompoundTag child : children.iterateType(CompoundTag.class)) {
                        ListTag junctions;
                        Helper.applyIntOffsetIfRootPresent(child, "TPX", "TPY", "TPZ", offset);
                        Helper.applyIntOffsetIfRootPresent(child, "PosX", "PosY", "PosZ", offset);
                        Helper.applyOffsetToBB(Helper.intArrayFromCompound(child, "BB"), offset);
                        ListTag entrances = (ListTag)Helper.tagFromCompound(child, "Entrances");
                        if (entrances != null) {
                            entrances.forEach(e -> Helper.applyOffsetToBB(((IntArrayTag)e).getValue(), offset));
                        }
                        if ((junctions = (ListTag)Helper.tagFromCompound(child, "junctions")) == null) continue;
                        for (CompoundTag junction : junctions.iterateType(CompoundTag.class)) {
                            Helper.applyIntOffsetIfRootPresent(junction, "source_x", "source_y", "source_z", offset);
                        }
                    }
                }
            }
        }
    }

    @MCVersionImplementation(value=2844)
    public static class InhabitedTime
    implements ChunkFilter.InhabitedTime {
        @Override
        public LongTag getInhabitedTime(ChunkData data) {
            return (LongTag)Helper.tagFromCompound(Helper.getRegion(data), "InhabitedTime");
        }

        @Override
        public void setInhabitedTime(ChunkData data, long inhabitedTime) {
            CompoundTag root = Helper.getRegion(data);
            if (root != null) {
                root.putLong("InhabitedTime", inhabitedTime);
            }
        }
    }

    @MCVersionImplementation(value=2844)
    public static class Sections
    extends ChunkFilter_15w32a.Sections {
        @Override
        public void deleteSections(ChunkData data, List<Range> ranges) {
            switch (Helper.getRegion(data).getString("Status")) {
                case "light": 
                case "spawn": 
                case "heightmaps": 
                case "full": {
                    Helper.getRegion(data).putString("Status", "features");
                    break;
                }
                default: {
                    return;
                }
            }
            ListTag sections = (ListTag)Helper.tagFromCompound(Helper.getRegion(data), "sections");
            if (sections == null) {
                return;
            }
            for (int i = 0; i < sections.size(); ++i) {
                CompoundTag section = sections.getCompound(i);
                for (Range range : ranges) {
                    if (!range.contains(section.getInt("Y"))) continue;
                    this.deleteSection(section);
                }
            }
        }

        protected void deleteSection(CompoundTag section) {
            CompoundTag blockStates = section.getCompound("block_states");
            blockStates.remove("data");
            ListTag blockPalette = new ListTag();
            CompoundTag air = new CompoundTag();
            air.putString("Name", "minecraft:air");
            blockPalette.add(air);
            blockStates.put("palette", blockPalette);
            section.remove("BlockLight");
        }
    }

    @MCVersionImplementation(value=2844)
    public static class Biomes
    implements ChunkFilter.Biomes {
        @Override
        public boolean matchBiomes(ChunkData data, Collection<BiomeRegistry.BiomeIdentifier> biomes) {
            ListTag sections = (ListTag)Helper.tagFromCompound(Helper.getRegion(data), "sections");
            if (sections == null) {
                return false;
            }
            HashSet<String> names = new HashSet<String>(biomes.size());
            block0: for (BiomeRegistry.BiomeIdentifier identifier : biomes) {
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    ListTag biomePalette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(section, "biomes"), "palette");
                    if (biomePalette == null) continue;
                    for (StringTag biomeName : biomePalette.iterateType(StringTag.class)) {
                        if (!identifier.matches(biomeName.getValue())) continue;
                        names.add(biomeName.getValue());
                        if (biomes.size() != names.size()) continue block0;
                        return true;
                    }
                }
            }
            return biomes.size() == names.size();
        }

        @Override
        public boolean matchAnyBiome(ChunkData data, Collection<BiomeRegistry.BiomeIdentifier> biomes) {
            ListTag sections = (ListTag)Helper.tagFromCompound(Helper.getRegion(data), "sections");
            if (sections == null) {
                return false;
            }
            for (BiomeRegistry.BiomeIdentifier identifier : biomes) {
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    ListTag biomePalette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(section, "biomes"), "palette");
                    if (biomePalette == null) continue;
                    for (StringTag biomeName : biomePalette.iterateType(StringTag.class)) {
                        if (!identifier.matches(biomeName.getValue())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void changeBiome(ChunkData data, BiomeRegistry.BiomeIdentifier biome) {
            ListTag sections = (ListTag)Helper.tagFromCompound(Helper.getRegion(data), "sections");
            if (sections == null) {
                return;
            }
            for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                CompoundTag biomes = (CompoundTag)Helper.tagFromCompound(section, "biomes");
                if (biomes == null) continue;
                ListTag newBiomePalette = new ListTag();
                newBiomePalette.addString(biome.getName());
                biomes.put("palette", newBiomePalette);
                biomes.putLongArray("data", new long[1]);
            }
        }

        @Override
        public void forceBiome(ChunkData data, BiomeRegistry.BiomeIdentifier biome) {
            ListTag sections = (ListTag)Helper.tagFromCompound(Helper.getRegion(data), "sections");
            if (sections == null) {
                return;
            }
            for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                CompoundTag biomes = new CompoundTag();
                ListTag newBiomePalette = new ListTag();
                newBiomePalette.addString(biome.getName());
                biomes.put("palette", newBiomePalette);
                biomes.putLongArray("data", new long[1]);
                section.put("biomes", biomes);
            }
        }
    }

    @MCVersionImplementation(value=2844)
    public static class Palette
    implements ChunkFilter.Palette {
        @Override
        public boolean paletteEquals(ChunkData data, Collection<String> names) {
            ListTag sections = (ListTag)Helper.tagFromCompound(Helper.getRegion(data), "sections");
            if (sections == null) {
                return false;
            }
            HashSet<String> blocks = new HashSet<String>();
            for (CompoundTag t : sections.iterateType(CompoundTag.class)) {
                ListTag palette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(t, "block_states"), "palette");
                if (palette == null) continue;
                for (CompoundTag p : palette.iterateType(CompoundTag.class)) {
                    String n = Helper.stringFromCompound(p, "Name");
                    if (n == null) continue;
                    if (!names.contains(n)) {
                        return false;
                    }
                    blocks.add(n);
                }
            }
            if (blocks.size() != names.size()) {
                return false;
            }
            for (String name : names) {
                if (blocks.contains(name)) continue;
                return false;
            }
            return true;
        }
    }

    @MCVersionImplementation(value=2844)
    public static class Heightmap
    extends ChunkFilter_21w37a.Heightmap {
        @Override
        protected long[] getHeightMap(CompoundTag root, Predicate<CompoundTag> matcher) {
            ListTag sections = (ListTag)Helper.getSectionsFromCompound(root, "sections");
            if (sections == null) {
                return new long[37];
            }
            Range sectionRange = Helper.findSectionRange(root, sections);
            ListTag[] palettes = new ListTag[sectionRange.num()];
            long[][] blockStatesArray = new long[sectionRange.num()][];
            sections.forEach(s -> {
                ListTag p = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(s, "block_states"), "palette");
                long[] b = Helper.longArrayFromCompound(Helper.tagFromCompound(s, "block_states"), "data");
                int y = Helper.numberFromCompound(s, "Y", sectionRange.getFrom() - 1).intValue();
                if (sectionRange.contains(y) && p != null && b != null) {
                    palettes[y - sectionRange.getFrom()] = p;
                    blockStatesArray[y - sectionRange.getFrom()] = b;
                }
            });
            short[] heightmap = new short[256];
            for (int cx = 0; cx < 16; ++cx) {
                block1: for (int cz = 0; cz < 16; ++cz) {
                    for (int i = sectionRange.num() - 1; i >= 0; --i) {
                        ListTag palette = palettes[i];
                        if (palette == null) continue;
                        long[] blockStates = blockStatesArray[i];
                        for (int cy = 15; cy >= 0; --cy) {
                            int blockIndex = cy * 256 + cz * 16 + cx;
                            if (!matcher.test(this.getBlockAt(blockIndex, blockStates, palette))) continue;
                            heightmap[cz * 16 + cx] = (short)(i * 16 + cy + 1);
                            continue block1;
                        }
                    }
                }
            }
            int bits = 32 - Integer.numberOfLeadingZeros(sectionRange.num() * 16);
            return this.applyHeightMap(heightmap, bits);
        }
    }

    @MCVersionImplementation(value=2844)
    public static class Blocks
    extends ChunkFilter_21w37a.Blocks {
        @Override
        public boolean matchBlockNames(ChunkData data, Collection<String> names) {
            ListTag sections = (ListTag)Helper.tagFromCompound(Helper.getRegion(data), "sections");
            if (sections == null) {
                return false;
            }
            int c = 0;
            block0: for (String name : names) {
                for (CompoundTag t : sections.iterateType(CompoundTag.class)) {
                    ListTag palette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(t, "block_states"), "palette");
                    if (palette == null) continue;
                    for (CompoundTag p : palette.iterateType(CompoundTag.class)) {
                        if (!name.equals(Helper.stringFromCompound(p, "Name"))) continue;
                        ++c;
                        continue block0;
                    }
                }
            }
            return names.size() == c;
        }

        @Override
        public boolean matchAnyBlockName(ChunkData data, Collection<String> names) {
            ListTag sections = (ListTag)Helper.tagFromCompound(Helper.getRegion(data), "sections");
            if (sections == null) {
                return false;
            }
            for (String name : names) {
                for (CompoundTag t : sections.iterateType(CompoundTag.class)) {
                    ListTag palette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(t, "block_states"), "palette");
                    if (palette == null) continue;
                    for (CompoundTag p : palette.iterateType(CompoundTag.class)) {
                        if (!name.equals(Helper.stringFromCompound(p, "Name"))) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void replaceBlocks(ChunkData data, Map<String, ChunkFilter.BlockReplaceData> replace) {
            ListTag tileEntities;
            ListTag sections = (ListTag)Helper.tagFromCompound(Helper.getRegion(data), "sections");
            if (sections == null) {
                return;
            }
            Point2i pos = Helper.point2iFromCompound(Helper.getRegion(data), "xPos", "zPos");
            if (pos == null) {
                return;
            }
            pos = pos.chunkToBlock();
            Range sectionRange = Helper.findSectionRange(Helper.getRegion(data), sections);
            if (replace.containsKey("minecraft:air")) {
                HashMap<Integer, CompoundTag> sectionMap = new HashMap<Integer, CompoundTag>();
                ArrayList<Integer> heights = new ArrayList<Integer>(sectionRange.num());
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    sectionMap.put(section.getInt("Y"), section);
                    heights.add(section.getInt("Y"));
                }
                for (int y = sectionRange.getFrom(); y <= sectionRange.getTo(); ++y) {
                    CompoundTag section;
                    if (!sectionMap.containsKey(y)) {
                        sectionMap.put(y, this.completeSection(new CompoundTag(), y));
                        heights.add(y);
                        continue;
                    }
                    section = (CompoundTag)sectionMap.get(y);
                    if (section.containsKey("block_states")) continue;
                    this.completeSection((CompoundTag)sectionMap.get(y), y);
                }
                heights.sort(Integer::compareTo);
                sections.clear();
                Iterator y = heights.iterator();
                while (y.hasNext()) {
                    int height = (Integer)y.next();
                    sections.add((Tag)sectionMap.get(height));
                }
            }
            if ((tileEntities = (ListTag)Helper.tagFromCompound(Helper.getRegion(data), "block_entities")) == null) {
                tileEntities = new ListTag();
            }
            for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                int y;
                CompoundTag blockStatesTag = section.getCompoundTag("block_states");
                if (blockStatesTag == null) continue;
                ListTag palette = (ListTag)Helper.tagFromCompound(blockStatesTag, "palette");
                long[] blockStates = Helper.longArrayFromCompound(blockStatesTag, "data");
                if (palette == null) continue;
                if (palette.size() == 1 && blockStates == null) {
                    blockStates = new long[256];
                }
                if (!sectionRange.contains(y = Helper.numberFromCompound(section, "Y", sectionRange.getFrom() - 1).intValue())) continue;
                section.remove("BlockLight");
                section.remove("SkyLight");
                for (int i = 0; i < 4096; ++i) {
                    CompoundTag blockState = this.getBlockAt(i, blockStates, palette);
                    block9: for (Map.Entry<String, ChunkFilter.BlockReplaceData> entry : replace.entrySet()) {
                        if (!blockState.getString("Name").matches(entry.getKey())) continue;
                        ChunkFilter.BlockReplaceData replacement = entry.getValue();
                        try {
                            blockStates = this.setBlockAt(i, replacement.getState(), blockStates, palette);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("failed to set block in section " + y, ex);
                        }
                        Point3i location = this.indexToLocation(i).add(pos.getX(), y * 16, pos.getZ());
                        if (replacement.getTile() != null) {
                            CompoundTag tile = replacement.getTile().copy();
                            tile.putInt("x", location.getX());
                            tile.putInt("y", location.getY());
                            tile.putInt("z", location.getZ());
                            tileEntities.add(tile);
                            continue;
                        }
                        if (tileEntities.isEmpty()) continue;
                        for (int t = 0; t < tileEntities.size(); ++t) {
                            CompoundTag tile = tileEntities.getCompound(t);
                            if (tile.getInt("x") != location.getX() || tile.getInt("y") != location.getY() || tile.getInt("z") != location.getZ()) continue;
                            tileEntities.remove(t);
                            continue block9;
                        }
                    }
                }
                try {
                    blockStates = this.cleanupPalette(blockStates, palette);
                }
                catch (Exception ex) {
                    throw new RuntimeException("failed to cleanup section " + y, ex);
                }
                if (blockStates == null) {
                    blockStatesTag.remove("data");
                    continue;
                }
                blockStatesTag.putLongArray("data", blockStates);
            }
            Helper.getRegion(data).put("block_entities", tileEntities);
        }

        @Override
        public int getBlockAmount(ChunkData data, String[] blocks) {
            ListTag sections = (ListTag)Helper.tagFromCompound(Helper.getRegion(data), "sections");
            if (sections == null) {
                return 0;
            }
            int result = 0;
            for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                ListTag palette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(section, "block_states"), "palette");
                long[] blockStates = Helper.longArrayFromCompound(Helper.tagFromCompound(section, "block_states"), "data");
                if (palette == null || blockStates == null) continue;
                block1: for (int i = 0; i < palette.size(); ++i) {
                    CompoundTag blockState = palette.getCompound(i);
                    String name = Helper.stringFromCompound(blockState, "Name");
                    if (name == null) continue;
                    for (String block : blocks) {
                        if (!name.equals(block)) continue;
                        for (int k = 0; k < 4096; ++k) {
                            if (blockState != this.getBlockAt(k, blockStates, palette)) continue;
                            ++result;
                        }
                        continue block1;
                    }
                }
            }
            return result;
        }

        @Override
        public int getAverageHeight(ChunkData data) {
            ListTag sections = (ListTag)Helper.tagFromCompound(Helper.getRegion(data), "sections");
            if (sections == null) {
                return 0;
            }
            sections.sort((x$0, x$1) -> this.filterSections((Tag)x$0, (Tag)x$1));
            int totalHeight = 0;
            for (int cx = 0; cx < 16; ++cx) {
                block1: for (int cz = 0; cz < 16; ++cz) {
                    for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                        Number height;
                        ListTag palette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(section, "block_states"), "palette");
                        long[] blockStates = Helper.longArrayFromCompound(Helper.tagFromCompound(section, "block_states"), "data");
                        if (palette == null || blockStates == null || (height = Helper.numberFromCompound(section, "Y", null)) == null) continue;
                        for (int cy = 15; cy >= 0; --cy) {
                            int index = cy * 256 + cz * 16 + cx;
                            CompoundTag block = this.getBlockAt(index, blockStates, palette);
                            if (this.isEmpty(block)) continue;
                            totalHeight += height.intValue() * 16 + cy;
                            continue block1;
                        }
                    }
                }
            }
            return totalHeight / 256;
        }
    }
}

