/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_18;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.range.Range;
import net.querz.mcaselector.util.validation.ValidationHelper;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.mcaselector.version.java_1_17.ChunkFilter_20w45a;
import net.querz.mcaselector.version.java_1_17.ChunkFilter_21w06a;
import net.querz.mcaselector.version.java_1_9.ChunkFilter_15w32a;
import net.querz.mcaselector.version.mapping.generator.HeightmapConfig;
import net.querz.mcaselector.version.mapping.registry.BiomeRegistry;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.StringTag;
import net.querz.nbt.Tag;

public class ChunkFilter_21w37a {

    @MCVersionImplementation(value=2834)
    protected static class Relocate
    extends ChunkFilter_21w06a.Relocate {
        static Relocate instance;

        public Relocate() {
            instance = this;
        }

        @Override
        protected void applyOffsetToVillagerMemory(CompoundTag memory, Point3i offset) {
            super.applyOffsetToVillagerMemory(memory, offset);
        }

        @Override
        protected void applyOffsetToTileEntity(CompoundTag tileEntity, Point3i offset) {
            super.applyOffsetToTileEntity(tileEntity, offset);
        }

        @Override
        protected void applyOffsetToItem(CompoundTag item, Point3i offset) {
            super.applyOffsetToItem(item, offset);
        }
    }

    @MCVersionImplementation(value=2834)
    public static class RelocateEntities
    extends ChunkFilter_20w45a.RelocateEntities {
        @Override
        protected void applyOffsetToEntity(CompoundTag entity, Point3i offset) {
            ListTag armorItems;
            ListTag handItems;
            String id;
            if (entity == null) {
                return;
            }
            ListTag entityPos = (ListTag)Helper.tagFromCompound(entity, "Pos");
            if (entityPos != null && entityPos.size() == 3) {
                entityPos.set(0, DoubleTag.valueOf(entityPos.getDouble(0) + (double)offset.getX()));
                entityPos.set(1, DoubleTag.valueOf(entityPos.getDouble(1) + (double)offset.getY()));
                entityPos.set(2, DoubleTag.valueOf(entityPos.getDouble(2) + (double)offset.getZ()));
            }
            CompoundTag leash = (CompoundTag)Helper.tagFromCompound(entity, "Leash");
            Helper.applyIntOffsetIfRootPresent(leash, "X", "Y", "Z", offset);
            if (ValidationHelper.attempt(() -> Helper.applyIntOffsetIfRootPresent(entity, "xTile", "yTile", "zTile", offset))) {
                ValidationHelper.attempt(() -> Helper.applyShortOffsetIfRootPresent(entity, "xTile", "yTile", "zTile", offset));
            }
            Helper.applyIntOffsetIfRootPresent(entity, "SleepingX", "SleepingY", "SleepingZ", offset);
            switch (id = Helper.stringFromCompound(entity, "id", "")) {
                case "minecraft:dolphin": {
                    Helper.applyIntOffsetIfRootPresent(entity, "TreasurePosX", "TreasurePosY", "TreasurePosZ", offset);
                    break;
                }
                case "minecraft:phantom": {
                    Helper.applyIntOffsetIfRootPresent(entity, "AX", "AY", "AZ", offset);
                    break;
                }
                case "minecraft:shulker": {
                    Helper.applyIntOffsetIfRootPresent(entity, "APX", "APY", "APZ", offset);
                    break;
                }
                case "minecraft:turtle": {
                    Helper.applyIntOffsetIfRootPresent(entity, "HomePosX", "HomePosY", "HomePosZ", offset);
                    Helper.applyIntOffsetIfRootPresent(entity, "TravelPosX", "TravelPosY", "TravelPosZ", offset);
                    break;
                }
                case "minecraft:vex": {
                    Helper.applyIntOffsetIfRootPresent(entity, "BoundX", "BoundY", "BoundZ", offset);
                    break;
                }
                case "minecraft:wandering_trader": {
                    CompoundTag wanderTarget = (CompoundTag)Helper.tagFromCompound(entity, "WanderTarget");
                    Helper.applyIntOffsetIfRootPresent(wanderTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:shulker_bullet": {
                    CompoundTag owner = (CompoundTag)Helper.tagFromCompound(entity, "Owner");
                    Helper.applyIntOffsetIfRootPresent(owner, "X", "Y", "Z", offset);
                    CompoundTag target = (CompoundTag)Helper.tagFromCompound(entity, "Target");
                    Helper.applyIntOffsetIfRootPresent(target, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:end_crystal": {
                    CompoundTag beamTarget = (CompoundTag)Helper.tagFromCompound(entity, "BeamTarget");
                    Helper.applyIntOffsetIfRootPresent(beamTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:item_frame": 
                case "minecraft:painting": {
                    Helper.applyIntOffsetIfRootPresent(entity, "TileX", "TileY", "TileZ", offset);
                    break;
                }
                case "minecraft:villager": {
                    CompoundTag memories = (CompoundTag)Helper.tagFromCompound(Helper.tagFromCompound(entity, "Brain"), "memories");
                    if (memories == null || memories.isEmpty()) break;
                    Relocate.instance.applyOffsetToVillagerMemory((CompoundTag)Helper.tagFromCompound(memories, "minecraft:meeting_point"), offset);
                    Relocate.instance.applyOffsetToVillagerMemory((CompoundTag)Helper.tagFromCompound(memories, "minecraft:home"), offset);
                    Relocate.instance.applyOffsetToVillagerMemory((CompoundTag)Helper.tagFromCompound(memories, "minecraft:job_site"), offset);
                    break;
                }
                case "minecraft:pillager": 
                case "minecraft:witch": 
                case "minecraft:vindicator": 
                case "minecraft:ravager": 
                case "minecraft:illusioner": 
                case "minecraft:evoker": {
                    CompoundTag patrolTarget = (CompoundTag)Helper.tagFromCompound(entity, "PatrolTarget");
                    Helper.applyIntOffsetIfRootPresent(patrolTarget, "X", "Y", "Z", offset);
                    break;
                }
                case "minecraft:falling_block": {
                    CompoundTag tileEntityData = (CompoundTag)Helper.tagFromCompound(entity, "TileEntityData");
                    Relocate.instance.applyOffsetToTileEntity(tileEntityData, offset);
                    break;
                }
                case "minecraft:sniffer": {
                    ListTag value;
                    CompoundTag snifferMemories = (CompoundTag)Helper.tagFromCompound(Helper.tagFromCompound(entity, "Brain"), "memories");
                    if (snifferMemories == null || snifferMemories.isEmpty() || (value = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(snifferMemories, "minecraft:sniffer_explored_positions"), "value")) == null || value.isEmpty() || value.getElementType() != Tag.Type.COMPOUND) break;
                    for (CompoundTag v : value.iterateType(CompoundTag.class)) {
                        IntArrayTag pos = v.getIntArrayTag("pos");
                        if (pos == null) continue;
                        Helper.applyOffsetToIntArrayPos(pos, offset);
                    }
                    break;
                }
            }
            ListTag passengers = (ListTag)Helper.tagFromCompound(entity, "Passengers");
            if (passengers != null) {
                passengers.forEach(p -> this.applyOffsetToEntity((CompoundTag)p, offset));
            }
            CompoundTag item = (CompoundTag)Helper.tagFromCompound(entity, "Item");
            Relocate.instance.applyOffsetToItem(item, offset);
            ListTag items = (ListTag)Helper.tagFromCompound(entity, "Items");
            if (items != null) {
                items.forEach(i -> Relocate.instance.applyOffsetToItem((CompoundTag)i, offset));
            }
            if ((handItems = (ListTag)Helper.tagFromCompound(entity, "HandItems")) != null) {
                handItems.forEach(i -> Relocate.instance.applyOffsetToItem((CompoundTag)i, offset));
            }
            if ((armorItems = (ListTag)Helper.tagFromCompound(entity, "ArmorItems")) != null) {
                armorItems.forEach(i -> Relocate.instance.applyOffsetToItem((CompoundTag)i, offset));
            }
            Helper.fixEntityUUID(entity);
        }
    }

    @MCVersionImplementation(value=2834)
    public static class Sections
    extends ChunkFilter_15w32a.Sections {
        @Override
        public void deleteSections(ChunkData data, List<Range> ranges) {
            CompoundTag level = Helper.levelFromRoot(Helper.getRegion(data));
            switch (Helper.stringFromCompound(level, "Status", "")) {
                case "light": 
                case "spawn": 
                case "heightmaps": 
                case "full": {
                    level.putString("Status", "features");
                    break;
                }
                default: {
                    return;
                }
            }
            ListTag sections = (ListTag)Helper.tagFromCompound(level, "Sections");
            if (sections == null) {
                return;
            }
            for (int i = 0; i < sections.size(); ++i) {
                CompoundTag section = sections.getCompound(i);
                for (Range range : ranges) {
                    if (!range.contains(section.getInt("Y"))) continue;
                    this.deleteSection(section);
                }
            }
        }

        protected void deleteSection(CompoundTag section) {
            CompoundTag blockStates = section.getCompound("block_states");
            blockStates.remove("data");
            ListTag blockPalette = new ListTag();
            CompoundTag air = new CompoundTag();
            air.putString("Name", "minecraft:air");
            blockPalette.add(air);
            blockStates.put("palette", blockPalette);
            section.remove("BlockLight");
        }
    }

    @MCVersionImplementation(value=2834)
    public static class Biomes
    implements ChunkFilter.Biomes {
        @Override
        public boolean matchBiomes(ChunkData data, Collection<BiomeRegistry.BiomeIdentifier> biomes) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return false;
            }
            HashSet<String> names = new HashSet<String>(biomes.size());
            block0: for (BiomeRegistry.BiomeIdentifier identifier : biomes) {
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    ListTag biomePalette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(section, "biomes"), "palette");
                    if (biomePalette == null) continue;
                    for (StringTag biomeName : biomePalette.iterateType(StringTag.class)) {
                        if (!identifier.matches(biomeName.getValue())) continue;
                        names.add(biomeName.getValue());
                        if (biomes.size() != names.size()) continue block0;
                        return true;
                    }
                }
            }
            return biomes.size() == names.size();
        }

        @Override
        public boolean matchAnyBiome(ChunkData data, Collection<BiomeRegistry.BiomeIdentifier> biomes) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return false;
            }
            for (BiomeRegistry.BiomeIdentifier identifier : biomes) {
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    ListTag biomePalette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(section, "biomes"), "palette");
                    if (biomePalette == null) continue;
                    for (StringTag biomeName : biomePalette.iterateType(StringTag.class)) {
                        if (!identifier.matches(biomeName.getValue())) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void changeBiome(ChunkData data, BiomeRegistry.BiomeIdentifier biome) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return;
            }
            for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                CompoundTag biomes = (CompoundTag)Helper.tagFromCompound(section, "biomes");
                if (biomes == null) continue;
                ListTag newBiomePalette = new ListTag();
                newBiomePalette.addString(biome.getName());
                biomes.put("palette", newBiomePalette);
                biomes.putLongArray("data", new long[1]);
            }
        }

        @Override
        public void forceBiome(ChunkData data, BiomeRegistry.BiomeIdentifier biome) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return;
            }
            for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                CompoundTag biomes = new CompoundTag();
                ListTag newBiomePalette = new ListTag();
                newBiomePalette.addString(biome.getName());
                biomes.put("palette", newBiomePalette);
                biomes.putLongArray("data", new long[1]);
                section.put("biomes", biomes);
            }
        }
    }

    @MCVersionImplementation(value=2834)
    public static class Palette
    implements ChunkFilter.Palette {
        @Override
        public boolean paletteEquals(ChunkData data, Collection<String> names) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return false;
            }
            HashSet<String> blocks = new HashSet<String>();
            for (CompoundTag t : sections.iterateType(CompoundTag.class)) {
                ListTag palette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(t, "block_states"), "palette");
                if (palette == null) continue;
                for (CompoundTag p : palette.iterateType(CompoundTag.class)) {
                    String n = Helper.stringFromCompound(p, "Name");
                    if (n == null) continue;
                    if (!names.contains(n)) {
                        return false;
                    }
                    blocks.add(n);
                }
            }
            if (blocks.size() != names.size()) {
                return false;
            }
            for (String name : names) {
                if (blocks.contains(name)) continue;
                return false;
            }
            return true;
        }
    }

    @MCVersionImplementation(value=2834)
    public static class Heightmap
    extends ChunkFilter_21w06a.Heightmap {
        @Override
        protected void loadCfg() {
            this.cfg = FileHelper.loadFromResource("mapping/java_1_18/heightmaps_21w37a.json", HeightmapConfig::load);
        }

        @Override
        protected long[] getHeightMap(CompoundTag root, Predicate<CompoundTag> matcher) {
            ListTag sections = (ListTag)Helper.getSectionsFromLevelFromRoot(root, "Sections");
            if (sections == null) {
                return new long[37];
            }
            Range sectionRange = Helper.findSectionRange(root, sections);
            ListTag[] palettes = new ListTag[sectionRange.num()];
            long[][] blockStatesArray = new long[sectionRange.num()][];
            sections.forEach(s -> {
                ListTag p = (ListTag)Helper.tagFromCompound(s, "palette");
                long[] b = Helper.longArrayFromCompound(s, "block_states");
                int y = Helper.numberFromCompound(s, "Y", sectionRange.getFrom() - 1).intValue();
                if (sectionRange.contains(y) && p != null && b != null) {
                    palettes[y - sectionRange.getFrom()] = p;
                    blockStatesArray[y - sectionRange.getFrom()] = b;
                }
            });
            short[] heightmap = new short[256];
            for (int cx = 0; cx < 16; ++cx) {
                block1: for (int cz = 0; cz < 16; ++cz) {
                    for (int i = palettes.length - 1; i >= 0; --i) {
                        ListTag palette = palettes[i];
                        if (palette == null) continue;
                        long[] blockStates = blockStatesArray[i];
                        for (int cy = 15; cy >= 0; --cy) {
                            int blockIndex = cy * 256 + cz * 16 + cx;
                            if (!matcher.test(this.getBlockAt(blockIndex, blockStates, palette))) continue;
                            heightmap[cz * 16 + cx] = (short)(i * 16 + cy + 1);
                            continue block1;
                        }
                    }
                }
            }
            int bits = 32 - Integer.numberOfLeadingZeros(sectionRange.num() * 16);
            return this.applyHeightMap(heightmap, bits);
        }
    }

    @MCVersionImplementation(value=2834)
    public static class Blocks
    extends ChunkFilter_21w06a.Blocks {
        @Override
        public boolean matchBlockNames(ChunkData data, Collection<String> names) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return false;
            }
            int c = 0;
            block0: for (String name : names) {
                for (CompoundTag t : sections.iterateType(CompoundTag.class)) {
                    ListTag palette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(t, "block_states"), "palette");
                    if (palette == null) continue;
                    for (CompoundTag p : palette.iterateType(CompoundTag.class)) {
                        if (!name.equals(Helper.stringFromCompound(p, "Name"))) continue;
                        ++c;
                        continue block0;
                    }
                }
            }
            return names.size() == c;
        }

        @Override
        public boolean matchAnyBlockName(ChunkData data, Collection<String> names) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return false;
            }
            for (String name : names) {
                for (CompoundTag t : sections.iterateType(CompoundTag.class)) {
                    ListTag palette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(t, "block_states"), "palette");
                    if (palette == null) continue;
                    for (CompoundTag p : palette.iterateType(CompoundTag.class)) {
                        if (!name.equals(Helper.stringFromCompound(p, "Name"))) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void replaceBlocks(ChunkData data, Map<String, ChunkFilter.BlockReplaceData> replace) {
            ListTag tileEntities;
            CompoundTag level = Helper.levelFromRoot(Helper.getRegion(data));
            ListTag sections = (ListTag)Helper.tagFromCompound(level, "Sections");
            if (sections == null) {
                return;
            }
            Point2i pos = Helper.point2iFromCompound(level, "xPos", "zPos");
            if (pos == null) {
                return;
            }
            pos = pos.chunkToBlock();
            Range sectionRange = Helper.findSectionRange(level, sections);
            if (replace.containsKey("minecraft:air")) {
                HashMap<Integer, CompoundTag> sectionMap = new HashMap<Integer, CompoundTag>();
                ArrayList<Integer> heights = new ArrayList<Integer>(sectionRange.num());
                for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                    sectionMap.put(section.getInt("Y"), section);
                    heights.add(section.getInt("Y"));
                }
                for (int y = sectionRange.getFrom(); y <= sectionRange.getTo(); ++y) {
                    CompoundTag section;
                    if (!sectionMap.containsKey(y)) {
                        sectionMap.put(y, this.completeSection(new CompoundTag(), y));
                        heights.add(y);
                        continue;
                    }
                    section = (CompoundTag)sectionMap.get(y);
                    if (section.containsKey("block_states")) continue;
                    this.completeSection((CompoundTag)sectionMap.get(y), y);
                }
                heights.sort(Integer::compareTo);
                sections.clear();
                Iterator y = heights.iterator();
                while (y.hasNext()) {
                    int height = (Integer)y.next();
                    sections.add((Tag)sectionMap.get(height));
                }
            }
            if ((tileEntities = (ListTag)Helper.tagFromCompound(level, "TileEntities")) == null) {
                tileEntities = new ListTag();
            }
            for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                int y;
                CompoundTag blockStatesTag = section.getCompoundTag("block_states");
                if (blockStatesTag == null) continue;
                ListTag palette = (ListTag)Helper.tagFromCompound(blockStatesTag, "palette");
                long[] blockStates = Helper.longArrayFromCompound(blockStatesTag, "data");
                if (palette == null) continue;
                if (palette.size() == 1 && blockStates == null) {
                    blockStates = new long[256];
                }
                if (!sectionRange.contains(y = Helper.numberFromCompound(section, "Y", sectionRange.getFrom() - 1).intValue())) continue;
                section.remove("BlockLight");
                section.remove("SkyLight");
                for (int i = 0; i < 4096; ++i) {
                    CompoundTag blockState = this.getBlockAt(i, blockStates, palette);
                    block9: for (Map.Entry<String, ChunkFilter.BlockReplaceData> entry : replace.entrySet()) {
                        if (!blockState.getString("Name").matches(entry.getKey())) continue;
                        ChunkFilter.BlockReplaceData replacement = entry.getValue();
                        try {
                            blockStates = this.setBlockAt(i, replacement.getState(), blockStates, palette);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("failed to set block in section " + y, ex);
                        }
                        Point3i location = this.indexToLocation(i).add(pos.getX(), y * 16, pos.getZ());
                        if (replacement.getTile() != null) {
                            CompoundTag tile = replacement.getTile().copy();
                            tile.putInt("x", location.getX());
                            tile.putInt("y", location.getY());
                            tile.putInt("z", location.getZ());
                            tileEntities.add(tile);
                            continue;
                        }
                        if (tileEntities.isEmpty()) continue;
                        for (int t = 0; t < tileEntities.size(); ++t) {
                            CompoundTag tile = tileEntities.getCompound(t);
                            if (tile.getInt("x") != location.getX() || tile.getInt("y") != location.getY() || tile.getInt("z") != location.getZ()) continue;
                            tileEntities.remove(t);
                            continue block9;
                        }
                    }
                }
                try {
                    blockStates = this.cleanupPalette(blockStates, palette);
                }
                catch (Exception ex) {
                    throw new RuntimeException("failed to cleanup section " + y, ex);
                }
                if (blockStates == null) {
                    blockStatesTag.remove("data");
                    continue;
                }
                blockStatesTag.putLongArray("data", blockStates);
            }
            level.put("TileEntities", tileEntities);
        }

        protected CompoundTag completeSection(CompoundTag section, int y) {
            CompoundTag biomes;
            CompoundTag blockStates;
            section.putByte("Y", (byte)y);
            if (!section.containsKey("block_states")) {
                CompoundTag newBlockStates = new CompoundTag();
                section.put("block_states", newBlockStates);
            }
            if (!(blockStates = section.getCompound("block_states")).containsKey("data")) {
                blockStates.putLongArray("data", new long[256]);
            }
            if (!blockStates.containsKey("palette")) {
                ListTag newPalette = new ListTag();
                CompoundTag newBlockState = new CompoundTag();
                newBlockState.putString("Name", "minecraft:air");
                newPalette.add(newBlockState);
                blockStates.put("palette", newPalette);
            }
            if (!section.containsKey("biomes")) {
                CompoundTag newBiomes = new CompoundTag();
                section.put("biomes", newBiomes);
            }
            if (!(biomes = section.getCompound("biomes")).containsKey("palette")) {
                ListTag biomePalette = new ListTag();
                biomePalette.addString("minecraft:plains");
                biomes.put("palette", biomePalette);
            }
            if (!biomes.containsKey("data")) {
                biomes.putLongArray("data", new long[1]);
            }
            return section;
        }

        @Override
        public int getBlockAmount(ChunkData data, String[] blocks) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return 0;
            }
            int result = 0;
            for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                ListTag palette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(section, "block_states"), "palette");
                long[] blockStates = Helper.longArrayFromCompound(Helper.tagFromCompound(section, "block_states"), "data");
                if (palette == null || blockStates == null) continue;
                block1: for (int i = 0; i < palette.size(); ++i) {
                    CompoundTag blockState = palette.getCompound(i);
                    String name = Helper.stringFromCompound(blockState, "Name");
                    if (name == null) continue;
                    for (String block : blocks) {
                        if (!name.equals(block)) continue;
                        for (int k = 0; k < 4096; ++k) {
                            if (blockState != this.getBlockAt(k, blockStates, palette)) continue;
                            ++result;
                        }
                        continue block1;
                    }
                }
            }
            return result;
        }

        @Override
        public int getAverageHeight(ChunkData data) {
            ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(Helper.getRegion(data), "Sections");
            if (sections == null) {
                return 0;
            }
            sections.sort((x$0, x$1) -> this.filterSections((Tag)x$0, (Tag)x$1));
            int totalHeight = 0;
            for (int cx = 0; cx < 16; ++cx) {
                block1: for (int cz = 0; cz < 16; ++cz) {
                    for (CompoundTag section : sections.iterateType(CompoundTag.class)) {
                        Number height;
                        ListTag palette = (ListTag)Helper.tagFromCompound(Helper.tagFromCompound(section, "block_states"), "palette");
                        long[] blockStates = Helper.longArrayFromCompound(Helper.tagFromCompound(section, "block_states"), "data");
                        if (palette == null || blockStates == null || (height = Helper.numberFromCompound(section, "Y", null)) == null) continue;
                        for (int cy = 15; cy >= 0; --cy) {
                            int index = cy * 256 + cz * 16 + cx;
                            CompoundTag block = this.getBlockAt(index, blockStates, palette);
                            if (this.isEmpty(block)) continue;
                            totalHeight += height.intValue() * 16 + cy;
                            continue block1;
                        }
                    }
                }
            }
            return totalHeight / 256;
        }
    }
}

