/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_17;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import net.querz.mcaselector.util.math.Bits;
import net.querz.mcaselector.version.ChunkRenderer;
import net.querz.mcaselector.version.ColorMapping;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.Tag;

@MCVersionImplementation(value=2694)
public class ChunkRenderer_21w06a
implements ChunkRenderer<CompoundTag, Integer> {
    private static final CompoundTag waterDummy = new CompoundTag();

    @Override
    public void drawChunk(CompoundTag root, ColorMapping<CompoundTag, Integer> colorMapping, int x, int z, int scale, int[] pixelBuffer, int[] waterPixels, short[] terrainHeights, short[] waterHeights, boolean water, int height) {
        ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(root, "Sections");
        if (sections == null || sections.getElementType() != Tag.Type.COMPOUND) {
            return;
        }
        CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
        int yMin = Helper.intFromCompound(Helper.levelFromRoot(root), "yPos", -4);
        int scaleBits = Bits.msbPosition(scale);
        int absHeight = height - yMin * 16;
        int yMax = 1 + (height >> 4);
        int sMax = yMax - yMin;
        CompoundTag[] indexedSections = new CompoundTag[sMax];
        sections.iterateType(CompoundTag.class).forEach(s -> {
            int y = Helper.numberFromCompound(s, "Y", yMin - 1).intValue();
            if (y >= yMin && y < yMax) {
                indexedSections[y - yMin] = s;
            }
        });
        boolean[] indexed = new boolean[sMax];
        ListTag[] indexedPalettes = new ListTag[sMax];
        LongBuffer[] indexedBlockStates = new LongBuffer[sMax];
        IntBuffer biomes = null;
        byte[] biomesData = Helper.byteArrayFromCompound(level, "Biomes");
        if (biomesData != null) {
            biomes = ByteBuffer.wrap(biomesData).asIntBuffer();
        }
        int[] bits = new int[sMax];
        int[] cleanBits = new int[sMax];
        int[] indexesPerLong = new int[sMax];
        int[] startHeight = new int[sMax];
        int[] sectionHeight = new int[sMax];
        for (int cx = 0; cx < 16; cx += scale) {
            block1: for (int cz = 0; cz < 16; cz += scale) {
                int pixelIndex = (z + (cz >> scaleBits)) * (512 >> scaleBits) + (x + (cx >> scaleBits));
                boolean waterDepth = false;
                for (int i = sMax - (sMax - (absHeight >> 4)); i >= 0; --i) {
                    ListTag palette;
                    if (indexedSections[i] == null) continue;
                    if (!indexed[i]) {
                        CompoundTag section = indexedSections[i];
                        indexedPalettes[i] = (ListTag)Helper.tagFromCompound(section, "Palette");
                        byte[] data = Helper.byteArrayFromCompound(section, "BlockStates");
                        if (data != null) {
                            indexedBlockStates[i] = ByteBuffer.wrap(data).asLongBuffer();
                        }
                        bits[i] = data == null ? 0 : data.length >> 9;
                        cleanBits[i] = (2 << bits[i] - 1) - 1;
                        indexesPerLong[i] = (int)(64.0 / (double)bits[i]);
                        startHeight[i] = absHeight >> 4 == i ? absHeight & 0xF : 15;
                        sectionHeight[i] = (i + yMin) * 16;
                        indexed[i] = true;
                    }
                    if ((palette = indexedPalettes[i]) == null) continue;
                    LongBuffer blockStates = indexedBlockStates[i];
                    for (int cy = startHeight[i]; cy >= 0; --cy) {
                        CompoundTag blockData = this.getBlock(cx, cy, cz, blockStates, bits[i], cleanBits[i], indexesPerLong[i], palette);
                        if (colorMapping.isTransparent(blockData)) continue;
                        int biome = this.getBiome(cx, cy + sectionHeight[i], cz, biomes, yMin);
                        if (water) {
                            if (!waterDepth) {
                                pixelBuffer[pixelIndex] = colorMapping.getRGB(blockData, biome);
                                waterHeights[pixelIndex] = (short)(sectionHeight[i] + cy);
                            }
                            if (colorMapping.isWater(blockData)) {
                                waterDepth = true;
                                continue;
                            }
                            if (colorMapping.isWaterlogged(blockData)) {
                                pixelBuffer[pixelIndex] = colorMapping.getRGB(waterDummy, biome);
                                waterPixels[pixelIndex] = colorMapping.getRGB(blockData, biome);
                                waterHeights[pixelIndex] = (short)(sectionHeight[i] + cy);
                                terrainHeights[pixelIndex] = (short)(sectionHeight[i] + cy - 1);
                                continue block1;
                            }
                            waterPixels[pixelIndex] = colorMapping.getRGB(blockData, biome);
                        } else {
                            pixelBuffer[pixelIndex] = colorMapping.getRGB(blockData, biome);
                        }
                        terrainHeights[pixelIndex] = (short)(sectionHeight[i] + cy);
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public void drawLayer(CompoundTag root, ColorMapping<CompoundTag, Integer> colorMapping, int x, int z, int scale, int[] pixelBuffer, int height) {
        ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(root, "Sections");
        if (sections == null) {
            return;
        }
        CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
        int yMin = Helper.intFromCompound(level, "yPos", -4);
        CompoundTag section = null;
        for (CompoundTag s : sections.iterateType(CompoundTag.class)) {
            int y = Helper.numberFromCompound(s, "Y", yMin - 1).intValue();
            if (y != height >> 4) continue;
            section = s;
            break;
        }
        if (section == null) {
            return;
        }
        ListTag palette = (ListTag)Helper.tagFromCompound(section, "Palette");
        byte[] data = Helper.byteArrayFromCompound(section, "BlockStates");
        LongBuffer blockStates = null;
        if (data != null) {
            blockStates = ByteBuffer.wrap(data).asLongBuffer();
        }
        if (palette == null) {
            return;
        }
        IntBuffer biomes = null;
        byte[] biomesData = Helper.byteArrayFromCompound(level, "Biomes");
        if (biomesData != null) {
            biomes = ByteBuffer.wrap(biomesData).asIntBuffer();
        }
        int scaleBits = Bits.msbPosition(scale);
        int absHeight = height - yMin * 16;
        int cy = absHeight & 0xF;
        int bits = data == null ? 0 : data.length >> 9;
        int clean = (2 << bits - 1) - 1;
        int indexesPerLong = (int)(64.0 / (double)bits);
        for (int cx = 0; cx < 16; cx += scale) {
            for (int cz = 0; cz < 16; cz += scale) {
                CompoundTag blockData = this.getBlock(cx, cy, cz, blockStates, bits, clean, indexesPerLong, palette);
                if (colorMapping.isTransparent(blockData)) continue;
                int pixelIndex = (z + (cz >> scaleBits)) * (512 >> scaleBits) + (x + (cx >> scaleBits));
                int biome = this.getBiome(cx, absHeight, cz, biomes, yMin);
                pixelBuffer[pixelIndex] = colorMapping.getRGB(blockData, biome);
            }
        }
    }

    @Override
    public void drawCaves(CompoundTag root, ColorMapping<CompoundTag, Integer> colorMapping, int x, int z, int scale, int[] pixelBuffer, short[] terrainHeights, int height) {
        ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(root, "Sections");
        if (sections == null || sections.getElementType() != Tag.Type.COMPOUND) {
            return;
        }
        CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
        int yMin = Helper.intFromCompound(level, "yPos", -4);
        int scaleBits = Bits.msbPosition(scale);
        int absHeight = height - yMin * 16;
        int yMax = 1 + (height >> 4);
        int sMax = yMax - yMin;
        CompoundTag[] indexedSections = new CompoundTag[sMax];
        sections.iterateType(CompoundTag.class).forEach(s -> {
            int y = Helper.numberFromCompound(s, "Y", yMin - 1).intValue();
            if (y >= yMin && y < yMax) {
                indexedSections[y - yMin] = s;
            }
        });
        boolean[] indexed = new boolean[sMax];
        ListTag[] indexedPalettes = new ListTag[sMax];
        LongBuffer[] indexedBlockStates = new LongBuffer[sMax];
        IntBuffer biomes = null;
        byte[] biomesData = Helper.byteArrayFromCompound(level, "Biomes");
        if (biomesData != null) {
            biomes = ByteBuffer.wrap(biomesData).asIntBuffer();
        }
        int[] bits = new int[sMax];
        int[] cleanBits = new int[sMax];
        int[] indexesPerLong = new int[sMax];
        int[] startHeight = new int[sMax];
        int[] sectionHeight = new int[sMax];
        for (int cx = 0; cx < 16; cx += scale) {
            block1: for (int cz = 0; cz < 16; cz += scale) {
                int pixelIndex = (z + (cz >> scaleBits)) * (512 >> scaleBits) + (x + (cx >> scaleBits));
                int ignored = 0;
                boolean doneSkipping = false;
                for (int i = sMax - (sMax - (absHeight >> 4)); i >= 0; --i) {
                    ListTag palette;
                    if (indexedSections[i] == null) continue;
                    if (!indexed[i]) {
                        CompoundTag section = indexedSections[i];
                        indexedPalettes[i] = (ListTag)Helper.tagFromCompound(section, "Palette");
                        byte[] data = Helper.byteArrayFromCompound(section, "BlockStates");
                        if (data != null) {
                            indexedBlockStates[i] = ByteBuffer.wrap(data).asLongBuffer();
                        }
                        bits[i] = data == null ? 0 : data.length >> 9;
                        cleanBits[i] = (2 << bits[i] - 1) - 1;
                        indexesPerLong[i] = (int)(64.0 / (double)bits[i]);
                        startHeight[i] = absHeight >> 4 == i ? absHeight & 0xF : 15;
                        sectionHeight[i] = (i + yMin) * 16;
                        indexed[i] = true;
                    }
                    if ((palette = indexedPalettes[i]) == null) continue;
                    LongBuffer blockStates = indexedBlockStates[i];
                    for (int cy = startHeight[i]; cy >= 0; --cy) {
                        CompoundTag blockData = this.getBlock(cx, cy, cz, blockStates, bits[i], cleanBits[i], indexesPerLong[i], palette);
                        if (!colorMapping.isTransparent(blockData) && !colorMapping.isFoliage(blockData)) {
                            if (doneSkipping) {
                                int biome = this.getBiome(cx, cy + sectionHeight[i], cz, biomes, yMin);
                                pixelBuffer[pixelIndex] = colorMapping.getRGB(blockData, biome);
                                terrainHeights[pixelIndex] = (short)(sectionHeight[i] + cy);
                                continue block1;
                            }
                            ++ignored;
                            continue;
                        }
                        if (ignored <= 0) continue;
                        doneSkipping = true;
                    }
                }
            }
        }
    }

    @Override
    public CompoundTag minimizeChunk(CompoundTag root) {
        CompoundTag minData = new CompoundTag();
        minData.put("DataVersion", root.get("DataVersion").copy());
        CompoundTag level = new CompoundTag();
        minData.put("Level", level);
        level.put("Biomes", root.getCompound("Level").get("Biomes").copy());
        level.put("Sections", root.getCompound("Level").get("Sections").copy());
        level.put("Status", root.getCompound("Level").get("Status").copy());
        return minData;
    }

    private int getBiome(int x, int y, int z, IntBuffer biomes, int yMin) {
        if (biomes == null) {
            return 0;
        }
        int b = biomes.get((y - yMin * 16 >> 2 << 4) + (z >> 2 << 2) + (x >> 2));
        if (b < 0 || b >= 255) {
            return 0;
        }
        return b;
    }

    private CompoundTag getBlock(int x, int y, int z, LongBuffer blockStates, int bits, int clean, int indexesPerLong, ListTag palette) {
        if (bits == 0) {
            return palette.getCompound(0);
        }
        int index = y * 256 + z * 16 + x;
        int blockStatesIndex = index / indexesPerLong;
        int startBit = index % indexesPerLong * bits;
        return palette.getCompound((int)(blockStates.get(blockStatesIndex) >> startBit) & clean);
    }

    static {
        waterDummy.putString("Name", "minecraft:water");
    }
}

