/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_16;

import java.util.Map;
import java.util.function.Predicate;
import net.querz.mcaselector.util.math.Bits;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.mcaselector.version.java_1_13.ChunkFilter_17w47a;
import net.querz.mcaselector.version.java_1_16.ChunkFilter_20w06a;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.ListTag;

public class ChunkFilter_20w17a {

    @MCVersionImplementation(value=2529)
    public static class Heightmap
    extends ChunkFilter_20w06a.Heightmap {
        @Override
        protected long[] getHeightMap(CompoundTag root, Predicate<CompoundTag> matcher) {
            ListTag sections = (ListTag)Helper.getSectionsFromLevelFromRoot(root, "Sections");
            if (sections == null) {
                return new long[37];
            }
            ListTag[] palettes = new ListTag[16];
            long[][] blockStatesArray = new long[16][];
            sections.forEach(s -> {
                ListTag p = (ListTag)Helper.tagFromCompound(s, "Palette");
                long[] b = Helper.longArrayFromCompound(s, "BlockStates");
                int y = Helper.numberFromCompound(s, "Y", -1).intValue();
                if (y >= 0 && y <= 15 && p != null && b != null) {
                    palettes[y] = p;
                    blockStatesArray[y] = b;
                }
            });
            short[] heightmap = new short[256];
            for (int cx = 0; cx < 16; ++cx) {
                block1: for (int cz = 0; cz < 16; ++cz) {
                    for (int i = 15; i >= 0; --i) {
                        ListTag palette = palettes[i];
                        if (palette == null) continue;
                        long[] blockStates = blockStatesArray[i];
                        for (int cy = 15; cy >= 0; --cy) {
                            int blockIndex = cy * 256 + cz * 16 + cx;
                            if (!matcher.test(this.getBlockAt(blockIndex, blockStates, palette))) continue;
                            heightmap[cz * 16 + cx] = (short)(i * 16 + cy + 1);
                            continue block1;
                        }
                    }
                }
            }
            return this.applyHeightMap(heightmap);
        }

        @Override
        protected long[] applyHeightMap(short[] rawHeightmap) {
            long[] data = new long[37];
            int index = 0;
            for (int i = 0; i < 37; ++i) {
                long l = 0L;
                for (int j = 0; j < 7 && index < 256; ++j, ++index) {
                    l += (long)rawHeightmap[index] << 9 * j;
                }
                data[i] = l;
            }
            return data;
        }

        @Override
        protected int getPaletteIndex(int blockIndex, long[] blockStates) {
            int bits = blockStates.length >> 6;
            int indicesPerLong = (int)(64.0 / (double)bits);
            int blockStatesIndex = blockIndex / indicesPerLong;
            int startBit = blockIndex % indicesPerLong * bits;
            return (int)Bits.bitRange(blockStates[blockStatesIndex], startBit, startBit + bits);
        }
    }

    @MCVersionImplementation(value=2529)
    public static class Blocks
    extends ChunkFilter_17w47a.Blocks {
        @Override
        protected int getPaletteIndex(int blockIndex, long[] blockStates) {
            int bits = blockStates.length >> 6;
            int indicesPerLong = (int)(64.0 / (double)bits);
            int blockStatesIndex = blockIndex / indicesPerLong;
            int startBit = blockIndex % indicesPerLong * bits;
            return (int)Bits.bitRange(blockStates[blockStatesIndex], startBit, startBit + bits);
        }

        @Override
        protected void setPaletteIndex(int blockIndex, int paletteIndex, long[] blockStates) {
            int bits = blockStates.length >> 6;
            int indicesPerLong = (int)(64.0 / (double)bits);
            int blockStatesIndex = blockIndex / indicesPerLong;
            int startBit = blockIndex % indicesPerLong * bits;
            blockStates[blockStatesIndex] = Bits.setBits(paletteIndex, blockStates[blockStatesIndex], startBit, startBit + bits);
        }

        @Override
        protected long[] adjustBlockStateBits(ListTag palette, long[] blockStates, Map<Integer, Integer> oldToNewMapping) {
            long[] newBlockStates;
            int newBits = 32 - Integer.numberOfLeadingZeros(palette.size() - 1);
            if ((newBits = Math.max(newBits, 4)) == blockStates.length / 64) {
                newBlockStates = blockStates;
            } else {
                int newLength = (int)Math.ceil(4096.0 / Math.floor(64.0 / (double)newBits));
                newBlockStates = new long[newLength];
            }
            if (oldToNewMapping != null) {
                for (i = 0; i < 4096; ++i) {
                    this.setPaletteIndex(i, oldToNewMapping.get(this.getPaletteIndex(i, blockStates)), newBlockStates);
                }
            } else {
                for (i = 0; i < 4096; ++i) {
                    this.setPaletteIndex(i, this.getPaletteIndex(i, blockStates), newBlockStates);
                }
            }
            return newBlockStates;
        }
    }
}

