/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version.java_1_13;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import net.querz.mcaselector.util.math.Bits;
import net.querz.mcaselector.util.math.MathUtil;
import net.querz.mcaselector.version.ChunkRenderer;
import net.querz.mcaselector.version.ColorMapping;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.Tag;

@MCVersionImplementation(value=1451)
public class ChunkRenderer_17w47a
implements ChunkRenderer<CompoundTag, Integer> {
    private static final CompoundTag waterDummy = new CompoundTag();

    @Override
    public void drawChunk(CompoundTag root, ColorMapping<CompoundTag, Integer> colorMapping, int x, int z, int scale, int[] pixelBuffer, int[] waterPixels, short[] terrainHeights, short[] waterHeights, boolean water, int height) {
        ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(root, "Sections");
        if (sections == null || sections.getElementType() != Tag.Type.COMPOUND) {
            return;
        }
        CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
        height = MathUtil.clamp(height, 0, 255);
        int scaleBits = Bits.msbPosition(scale);
        int yMax = 1 + (height >> 4);
        CompoundTag[] indexedSections = new CompoundTag[yMax];
        sections.iterateType(CompoundTag.class).forEach(s -> {
            int y = Helper.numberFromCompound(s, "Y", -1).intValue();
            if (y >= 0 && y < yMax) {
                indexedSections[y] = s;
            }
        });
        boolean[] indexed = new boolean[yMax];
        ListTag[] indexedPalettes = new ListTag[yMax];
        LongBuffer[] indexedBlockStates = new LongBuffer[yMax];
        byte[] biomes = Helper.byteArrayFromCompound(level, "Biomes");
        int[] bits = new int[yMax];
        int[] cleanBits = new int[yMax];
        int[] startHeight = new int[yMax];
        int[] sectionHeight = new int[yMax];
        for (int cx = 0; cx < 16; cx += scale) {
            block1: for (int cz = 0; cz < 16; cz += scale) {
                int pixelIndex = (z + (cz >> scaleBits)) * (512 >> scaleBits) + (x + (cx >> scaleBits));
                int biome = this.getBiome(cx, cz, biomes);
                boolean waterDepth = false;
                for (int i = height >> 4; i >= 0; --i) {
                    ListTag palette;
                    if (indexedSections[i] == null) continue;
                    if (!indexed[i]) {
                        CompoundTag section = indexedSections[i];
                        indexedPalettes[i] = (ListTag)Helper.tagFromCompound(section, "Palette");
                        byte[] data = Helper.byteArrayFromCompound(section, "BlockStates");
                        if (data != null) {
                            indexedBlockStates[i] = ByteBuffer.wrap(data).asLongBuffer();
                        }
                        bits[i] = data == null ? 0 : data.length >> 9;
                        cleanBits[i] = (2 << bits[i] - 1) - 1;
                        startHeight[i] = yMax >> 4 == i ? yMax & 0xF : 15;
                        sectionHeight[i] = i * 16;
                        indexed[i] = true;
                    }
                    if ((palette = indexedPalettes[i]) == null) continue;
                    LongBuffer blockStates = indexedBlockStates[i];
                    for (int cy = startHeight[i]; cy >= 0; --cy) {
                        CompoundTag blockData = this.getBlock(cx, cy, cz, blockStates, bits[i], cleanBits[i], palette);
                        if (colorMapping.isTransparent(blockData)) continue;
                        if (water) {
                            if (!waterDepth) {
                                pixelBuffer[pixelIndex] = colorMapping.getRGB(blockData, biome);
                                waterHeights[pixelIndex] = (short)(sectionHeight[i] + cy);
                            }
                            if (colorMapping.isWater(blockData)) {
                                waterDepth = true;
                                continue;
                            }
                            if (colorMapping.isWaterlogged(blockData)) {
                                pixelBuffer[pixelIndex] = colorMapping.getRGB(waterDummy, biome);
                                waterPixels[pixelIndex] = colorMapping.getRGB(blockData, biome);
                                waterHeights[pixelIndex] = (short)(sectionHeight[i] + cy);
                                terrainHeights[pixelIndex] = (short)(sectionHeight[i] + cy - 1);
                                continue block1;
                            }
                            waterPixels[pixelIndex] = colorMapping.getRGB(blockData, biome);
                        } else {
                            pixelBuffer[pixelIndex] = colorMapping.getRGB(blockData, biome);
                        }
                        terrainHeights[pixelIndex] = (short)(sectionHeight[i] + cy);
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public void drawLayer(CompoundTag root, ColorMapping<CompoundTag, Integer> colorMapping, int x, int z, int scale, int[] pixelBuffer, int height) {
        ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(root, "Sections");
        if (sections == null) {
            return;
        }
        CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
        height = MathUtil.clamp(height, 0, 255);
        CompoundTag section = null;
        for (CompoundTag s : sections.iterateType(CompoundTag.class)) {
            int y = Helper.numberFromCompound(s, "Y", -1).intValue();
            if (y != height >> 4) continue;
            section = s;
            break;
        }
        if (section == null) {
            return;
        }
        ListTag palette = (ListTag)Helper.tagFromCompound(section, "Palette");
        byte[] data = Helper.byteArrayFromCompound(section, "BlockStates");
        LongBuffer blockStates = null;
        if (data != null) {
            blockStates = ByteBuffer.wrap(data).asLongBuffer();
        }
        if (palette == null) {
            return;
        }
        byte[] biomes = Helper.byteArrayFromCompound(level, "Biomes");
        int scaleBits = Bits.msbPosition(scale);
        int cy = height & 0xF;
        int bits = data == null ? 0 : data.length >> 9;
        int clean = (2 << bits - 1) - 1;
        for (int cx = 0; cx < 16; cx += scale) {
            for (int cz = 0; cz < 16; cz += scale) {
                CompoundTag blockData = this.getBlock(cx, cy, cz, blockStates, bits, clean, palette);
                if (colorMapping.isTransparent(blockData)) continue;
                int pixelIndex = (z + (cz >> scaleBits)) * (512 >> scaleBits) + (x + (cx >> scaleBits));
                int biome = this.getBiome(cx, cz, biomes);
                pixelBuffer[pixelIndex] = colorMapping.getRGB(blockData, biome);
            }
        }
    }

    @Override
    public void drawCaves(CompoundTag root, ColorMapping<CompoundTag, Integer> colorMapping, int x, int z, int scale, int[] pixelBuffer, short[] terrainHeights, int height) {
        ListTag sections = (ListTag)Helper.tagFromLevelFromRoot(root, "Sections");
        if (sections == null || sections.getElementType() != Tag.Type.COMPOUND) {
            return;
        }
        CompoundTag level = (CompoundTag)Helper.tagFromCompound(root, "Level");
        height = MathUtil.clamp(height, 0, 255);
        int scaleBits = Bits.msbPosition(scale);
        int yMax = 1 + (height >> 4);
        CompoundTag[] indexedSections = new CompoundTag[yMax];
        sections.iterateType(CompoundTag.class).forEach(s -> {
            int y = Helper.numberFromCompound(s, "Y", -1).intValue();
            if (y >= 0 && y < yMax) {
                indexedSections[y] = s;
            }
        });
        boolean[] indexed = new boolean[yMax];
        ListTag[] indexedPalettes = new ListTag[yMax];
        LongBuffer[] indexedBlockStates = new LongBuffer[yMax];
        byte[] biomes = Helper.byteArrayFromCompound(level, "Biomes");
        int[] bits = new int[yMax];
        int[] cleanBits = new int[yMax];
        int[] startHeight = new int[yMax];
        int[] sectionHeight = new int[yMax];
        for (int cx = 0; cx < 16; cx += scale) {
            block1: for (int cz = 0; cz < 16; cz += scale) {
                int pixelIndex = (z + (cz >> scaleBits)) * (512 >> scaleBits) + (x + (cx >> scaleBits));
                int biome = this.getBiome(cx, cz, biomes);
                int ignored = 0;
                boolean doneSkipping = false;
                for (int i = height >> 4; i >= 0; --i) {
                    ListTag palette;
                    if (indexedSections[i] == null) continue;
                    if (!indexed[i]) {
                        CompoundTag section = indexedSections[i];
                        indexedPalettes[i] = (ListTag)Helper.tagFromCompound(section, "Palette");
                        byte[] data = Helper.byteArrayFromCompound(section, "BlockStates");
                        if (data != null) {
                            indexedBlockStates[i] = ByteBuffer.wrap(data).asLongBuffer();
                        }
                        bits[i] = data == null ? 0 : data.length >> 9;
                        cleanBits[i] = (2 << bits[i] - 1) - 1;
                        startHeight[i] = height >> 4 == i ? height & 0xF : 15;
                        sectionHeight[i] = i * 16;
                        indexed[i] = true;
                    }
                    if ((palette = indexedPalettes[i]) == null) continue;
                    LongBuffer blockStates = indexedBlockStates[i];
                    for (int cy = startHeight[i]; cy >= 0; --cy) {
                        CompoundTag blockData = this.getBlock(cx, cy, cz, blockStates, bits[i], cleanBits[i], palette);
                        if (!colorMapping.isTransparent(blockData) && !colorMapping.isFoliage(blockData)) {
                            if (doneSkipping) {
                                pixelBuffer[pixelIndex] = colorMapping.getRGB(blockData, biome);
                                terrainHeights[pixelIndex] = (short)(sectionHeight[i] + cy);
                                continue block1;
                            }
                            ++ignored;
                            continue;
                        }
                        if (ignored <= 0) continue;
                        doneSkipping = true;
                    }
                }
            }
        }
    }

    @Override
    public CompoundTag minimizeChunk(CompoundTag root) {
        CompoundTag minData = new CompoundTag();
        minData.put("DataVersion", root.get("DataVersion").copy());
        CompoundTag level = new CompoundTag();
        minData.put("Level", level);
        level.put("Biomes", root.getCompound("Level").get("Biomes").copy());
        level.put("Sections", root.getCompound("Level").get("Sections").copy());
        level.put("Status", root.getCompound("Level").get("Status").copy());
        return minData;
    }

    private CompoundTag getBlock(int x, int y, int z, LongBuffer blockStates, int bits, int clean, ListTag palette) {
        if (bits == 0) {
            return palette.getCompound(0);
        }
        int index = y * 256 + z * 16 + x;
        double blockStatesIndex = (double)index / (4096.0 / (double)blockStates.limit());
        int longIndex = (int)blockStatesIndex;
        int startBit = (int)((blockStatesIndex - Math.floor(blockStatesIndex)) * 64.0);
        if (startBit + bits > 64) {
            int previous = (int)(blockStates.get(longIndex) >>> startBit);
            int remainingClean = (2 << startBit + bits - 65) - 1;
            int next = (int)blockStates.get(longIndex + 1) & remainingClean;
            return palette.getCompound((next << 64 - startBit) + previous);
        }
        return palette.getCompound((int)(blockStates.get(longIndex) >> startBit) & clean);
    }

    private int getBiome(int x, int z, byte[] biomes) {
        if (biomes == null || biomes.length != 256) {
            return 0;
        }
        return biomes[z * 16 + x] & 0xFF;
    }

    static {
        waterDummy.putString("Name", "minecraft:water");
    }
}

