/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.MCVersionImplementation;
import org.atteo.classindex.ClassIndex;

public final class VersionHandler {
    private static final Map<Class<?>, TreeMap<Integer, Object>> implementations = new HashMap();

    private VersionHandler() {
    }

    public static void init() {
        for (Class<?> clazz : ClassIndex.getAnnotated(MCVersionImplementation.class)) {
            Class<?> interfaceClass = null;
            for (Class<?> superClass = clazz; interfaceClass == null && superClass != null; superClass = superClass.getSuperclass()) {
                Class<?>[] interfaces = superClass.getInterfaces();
                if (interfaces.length <= 0) continue;
                interfaceClass = interfaces[0];
            }
            if (interfaceClass == null) {
                throw new RuntimeException("could not find interface for " + String.valueOf(clazz));
            }
            implementations.compute(interfaceClass, (k, v) -> {
                if (v == null) {
                    v = new TreeMap();
                }
                try {
                    v.put(clazz.getAnnotation(MCVersionImplementation.class).value(), clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                return v;
            });
        }
    }

    public static <T> T getImpl(int dataVersion, Class<T> clazz) {
        TreeMap<Integer, Object> implementation = implementations.get(clazz);
        if (implementation == null) {
            throw new IllegalArgumentException("no implementation for " + String.valueOf(clazz));
        }
        Map.Entry<Integer, Object> e = implementation.floorEntry(dataVersion);
        if (e == null) {
            throw new IllegalArgumentException("no implementation for " + String.valueOf(clazz) + " with version " + dataVersion);
        }
        if (!clazz.isAssignableFrom(e.getValue().getClass())) {
            throw new IllegalArgumentException("wrong implementation for " + String.valueOf(clazz) + " with version " + dataVersion + ": " + String.valueOf(e.getValue().getClass()));
        }
        return (T)e.getValue();
    }

    public static <T> T getImpl(ChunkData data, Class<T> clazz) {
        if (data == null) {
            throw new IllegalArgumentException("chunk data is null");
        }
        int dataVersion = 0;
        if (data.region() != null && data.region().getData() != null) {
            dataVersion = Helper.getDataVersion(data.region().getData());
        } else if (data.entities() != null && data.entities().getData() != null) {
            dataVersion = Helper.getDataVersion(data.entities().getData());
        } else if (data.poi() != null && data.poi().getData() != null) {
            dataVersion = Helper.getDataVersion(data.poi().getData());
        }
        return VersionHandler.getImpl(dataVersion, clazz);
    }
}

