/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.version;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.range.Range;
import net.querz.mcaselector.version.Helper;
import net.querz.mcaselector.version.mapping.registry.BiomeRegistry;
import net.querz.mcaselector.version.mapping.registry.StatusRegistry;
import net.querz.nbt.ByteTag;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.IntTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.LongTag;
import net.querz.nbt.NBTUtil;
import net.querz.nbt.NumberTag;
import net.querz.nbt.StringTag;
import net.querz.nbt.Tag;

public interface ChunkFilter {

    public static interface Heightmap {
        public void worldSurface(ChunkData var1);

        public void oceanFloor(ChunkData var1);

        public void motionBlocking(ChunkData var1);

        public void motionBlockingNoLeaves(ChunkData var1);
    }

    public static interface Entities {
        public void deleteEntities(ChunkData var1, List<Range> var2);

        public ListTag getEntities(ChunkData var1);
    }

    public static enum BlockReplaceType {
        NAME,
        STATE,
        STATE_TILE,
        NAME_TILE;

    }

    public static class BlockReplaceData {
        private String name;
        private CompoundTag state;
        private CompoundTag tile;
        private final BlockReplaceType type;

        public BlockReplaceData(String name) {
            this.type = BlockReplaceType.NAME;
            this.name = name;
            this.state = new CompoundTag();
            this.state.putString("Name", name);
        }

        public BlockReplaceData(String name, CompoundTag tile) {
            this.type = BlockReplaceType.NAME_TILE;
            this.name = name;
            this.tile = tile;
            this.state = new CompoundTag();
            this.state.putString("Name", name);
        }

        public BlockReplaceData(CompoundTag state) {
            this.type = BlockReplaceType.STATE;
            this.state = state;
            this.name = state.getString("Name");
        }

        public BlockReplaceData(CompoundTag state, CompoundTag tile) {
            this.type = BlockReplaceType.STATE_TILE;
            this.state = state;
            this.tile = tile;
            this.name = state.getString("Name");
        }

        public BlockReplaceType getType() {
            return this.type;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setState(CompoundTag state) {
            this.state = state;
        }

        public CompoundTag getState() {
            return this.state;
        }

        public void setTile(CompoundTag tile) {
            this.tile = tile;
        }

        public CompoundTag getTile() {
            return this.tile;
        }

        public String toString() {
            switch (this.type.ordinal()) {
                case 0: {
                    if (this.name.startsWith("minecraft:")) {
                        return this.name;
                    }
                    return "'" + this.name + "'";
                }
                case 1: {
                    return NBTUtil.toSNBT(this.state);
                }
                case 2: {
                    return NBTUtil.toSNBT(this.state) + ";" + NBTUtil.toSNBT(this.tile);
                }
                case 3: {
                    if (this.name.startsWith("minecraft:")) {
                        return this.name + ";" + NBTUtil.toSNBT(this.tile);
                    }
                    return "'" + this.name + "';" + NBTUtil.toSNBT(this.tile);
                }
            }
            return null;
        }
    }

    public static interface MergePOI
    extends Merge {
    }

    public static interface MergeEntities
    extends Merge {
    }

    public static interface Merge {
        public void mergeChunks(CompoundTag var1, CompoundTag var2, List<Range> var3, int var4);

        public CompoundTag newEmptyChunk(Point2i var1, int var2);

        default public ListTag mergeLists(ListTag source, ListTag destination, List<Range> ranges, Function<Tag, Integer> ySupplier, int yOffset) {
            int y;
            ListTag result = new ListTag();
            for (Tag dest : destination) {
                y = ySupplier.apply(dest);
                for (Range range : ranges) {
                    if (range.contains(y + yOffset)) continue;
                    result.add(dest);
                }
            }
            block2: for (Tag sourceElement : source) {
                y = ySupplier.apply(sourceElement);
                for (Range range : ranges) {
                    if (!range.contains(y - yOffset)) continue;
                    result.add(sourceElement);
                    continue block2;
                }
            }
            return result;
        }

        default public void mergeListTagLists(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset, String name) {
            ListTag sourceList = (ListTag)Helper.tagFromLevelFromRoot(source, name);
            ListTag destinationList = Helper.tagFromLevelFromRoot(destination, name, sourceList);
            if (sourceList == null || destinationList == null || sourceList.size() != destinationList.size()) {
                return;
            }
            for (Range range : ranges) {
                int m = Math.min(range.getTo() + yOffset, sourceList.size() - 1);
                for (int i = Math.max(range.getFrom() + yOffset, 0); i <= m; ++i) {
                    destinationList.set(i, sourceList.get(i));
                }
            }
            this.initLevel(destination).put(name, destinationList);
        }

        default public void mergeCompoundTagListsFromLevel(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset, String name, Function<Tag, Integer> ySupplier) {
            ListTag sourceElements = Helper.tagFromLevelFromRoot(source, name, new ListTag());
            ListTag destinationElements = Helper.tagFromLevelFromRoot(destination, name, new ListTag());
            this.initLevel(destination).put(name, this.mergeLists(sourceElements, destinationElements, ranges, ySupplier, yOffset));
        }

        default public void mergeCompoundTagLists(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset, String name, Function<Tag, Integer> ySupplier) {
            ListTag sourceElements = Helper.tagFromCompound(source, name, new ListTag());
            ListTag destinationElements = Helper.tagFromCompound(destination, name, new ListTag());
            destination.put(name, this.mergeLists(sourceElements, destinationElements, ranges, ySupplier, yOffset));
        }

        default public void mergeCompoundTags(CompoundTag source, CompoundTag destination, List<Range> ranges, int yOffset, String name) {
            CompoundTag sourceElements = Helper.tagFromCompound(source, name, new CompoundTag());
            CompoundTag destinationElements = Helper.tagFromCompound(destination, name, new CompoundTag());
            block0: for (Map.Entry<String, Tag> sourceElement : sourceElements) {
                if (!sourceElement.getKey().matches("^-?[0-9]{1,2}$")) continue;
                int y = Integer.parseInt(sourceElement.getKey());
                for (Range range : ranges) {
                    if (!range.contains(y - yOffset)) continue;
                    destinationElements.put(sourceElement.getKey(), sourceElement.getValue());
                    continue block0;
                }
            }
        }

        default public CompoundTag initLevel(CompoundTag c) {
            CompoundTag level = Helper.levelFromRoot(c);
            if (level == null) {
                level = new CompoundTag();
                c.put("Level", level);
            }
            return level;
        }

        default public void fixEntityUUIDs(CompoundTag root) {
            ListTag entities = Helper.tagFromCompound(root, "Entities", null);
            if (entities != null) {
                entities.forEach(e -> Merge.fixEntityUUID((CompoundTag)e));
            }
        }

        private static void fixEntityUUID(CompoundTag entity) {
            ListTag passengers;
            Helper.fixEntityUUID(entity);
            if (entity.containsKey("Passengers") && (passengers = (ListTag)Helper.tagFromCompound(entity, "Passengers", null)) != null) {
                passengers.forEach(e -> Merge.fixEntityUUID((CompoundTag)e));
            }
        }
    }

    public static interface RelocatePOI
    extends Relocate {
    }

    public static interface RelocateEntities
    extends Relocate {
    }

    public static interface Relocate {
        public boolean relocate(CompoundTag var1, Point3i var2);

        default public boolean applyOffsetToSection(CompoundTag section, Point3i offset, Range sectionRange) {
            NumberTag value = (NumberTag)Helper.tagFromCompound(section, "Y");
            if (value != null) {
                if (!sectionRange.contains(value.asInt())) {
                    return false;
                }
                int y = value.asInt() + offset.getY();
                if (!sectionRange.contains(y)) {
                    return false;
                }
                section.putByte("Y", (byte)y);
            }
            return true;
        }
    }

    public static interface Blending {
        public void forceBlending(ChunkData var1);
    }

    public static interface LightPopulated {
        public ByteTag getLightPopulated(ChunkData var1);

        public void setLightPopulated(ChunkData var1, byte var2);
    }

    public static interface Structures {
        public CompoundTag getStructureStarts(ChunkData var1);

        public CompoundTag getStructureReferences(ChunkData var1);
    }

    public static interface Pos {
        public IntTag getXPos(ChunkData var1);

        public IntTag getYPos(ChunkData var1);

        public IntTag getZPos(ChunkData var1);
    }

    public static interface LastUpdate {
        public LongTag getLastUpdate(ChunkData var1);

        public void setLastUpdate(ChunkData var1, long var2);
    }

    public static interface Status {
        public StringTag getStatus(ChunkData var1);

        public void setStatus(ChunkData var1, StatusRegistry.StatusIdentifier var2);

        public boolean matchStatus(ChunkData var1, StatusRegistry.StatusIdentifier var2);
    }

    public static interface InhabitedTime {
        public LongTag getInhabitedTime(ChunkData var1);

        public void setInhabitedTime(ChunkData var1, long var2);
    }

    public static interface Sections {
        public ListTag getSections(ChunkData var1);

        public void deleteSections(ChunkData var1, List<Range> var2);
    }

    public static interface TileEntities {
        public ListTag getTileEntities(ChunkData var1);
    }

    public static interface Palette {
        public boolean paletteEquals(ChunkData var1, Collection<String> var2);
    }

    public static interface Blocks {
        public boolean matchBlockNames(ChunkData var1, Collection<String> var2);

        public boolean matchAnyBlockName(ChunkData var1, Collection<String> var2);

        public void replaceBlocks(ChunkData var1, Map<String, BlockReplaceData> var2);

        public int getBlockAmount(ChunkData var1, String[] var2);

        public int getAverageHeight(ChunkData var1);
    }

    public static interface Biomes {
        public boolean matchBiomes(ChunkData var1, Collection<BiomeRegistry.BiomeIdentifier> var2);

        public boolean matchAnyBiome(ChunkData var1, Collection<BiomeRegistry.BiomeIdentifier> var2);

        public void changeBiome(ChunkData var1, BiomeRegistry.BiomeIdentifier var2);

        public void forceBiome(ChunkData var1, BiomeRegistry.BiomeIdentifier var2);
    }
}

