/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.util.validation;

import java.util.PriorityQueue;

public final class ShutdownHooks {
    private static final PriorityQueue<ShutdownJob> hooks = new PriorityQueue();

    public static ShutdownJob addShutdownHook(Runnable r) {
        return ShutdownHooks.addShutdownHook(r, Integer.MAX_VALUE);
    }

    public static ShutdownJob addShutdownHook(Runnable r, int priority) {
        ShutdownJob j = new ShutdownJob(r, priority);
        hooks.offer(j);
        return j;
    }

    public static boolean removeShutdownHook(ShutdownJob j) {
        return hooks.remove(j);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (ShutdownJob hook : hooks) {
                hook.run();
            }
        }));
    }

    public static class ShutdownJob
    implements Runnable,
    Comparable<ShutdownJob> {
        private final int priority;
        private final Runnable runnable;

        private ShutdownJob(Runnable runnable, int priority) {
            this.runnable = runnable;
            this.priority = priority;
        }

        @Override
        public int compareTo(ShutdownJob o) {
            return Integer.compare(o.priority, this.priority);
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }
}

