/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.util.range;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.querz.mcaselector.util.range.Range;

public final class RangeParser {
    private static final Pattern rangePattern = Pattern.compile("^(?<from>-?\\d*)(?<divider>:?)(?<to>-?\\d*)$");

    public static Range parseRange(String range) {
        String trimmed = range.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        Matcher m = rangePattern.matcher(trimmed);
        if (m.find()) {
            int to;
            int from;
            String fromString = m.group("from");
            boolean divider = m.group("divider").isEmpty();
            String toString = m.group("to");
            try {
                from = fromString.isEmpty() ? Integer.MIN_VALUE : Integer.parseInt(fromString);
                to = toString.isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(toString);
            }
            catch (NumberFormatException ex) {
                return null;
            }
            if (divider) {
                return new Range(from, from);
            }
            return new Range(from, to);
        }
        return null;
    }

    public static List<Range> parseRanges(String ranges, String delimiter) {
        if ("true".equals(ranges.trim())) {
            return new ArrayList<Range>(Collections.singletonList(new Range(Integer.MIN_VALUE, Integer.MAX_VALUE)));
        }
        String[] split = ranges.split(delimiter);
        ArrayList<Range> list = new ArrayList<Range>(split.length);
        for (String stringRange : split) {
            Range range = RangeParser.parseRange(stringRange);
            if (range == null) {
                return null;
            }
            list.add(range);
        }
        return list;
    }
}

