/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.util.point;

import java.io.Serializable;
import java.util.Objects;
import net.querz.mcaselector.util.point.Point2i;

public class Point3i
implements Cloneable,
Serializable {
    private int x;
    private int y;
    private int z;

    public Point3i() {
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public Point3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public Point3i add(int x, int y, int z) {
        return new Point3i(this.x + x, this.y + y, this.z + z);
    }

    public Point3i add(Point3i p) {
        return this.add(p.x, p.y, p.z);
    }

    public Point3i add(int i) {
        return this.add(i, i, i);
    }

    public Point3i sub(int x, int y, int z) {
        return new Point3i(this.x - x, this.y - y, this.z - z);
    }

    public Point3i sub(Point3i p) {
        return this.sub(p.x, p.y, p.z);
    }

    public Point3i sub(int i) {
        return this.sub(i, i, i);
    }

    public Point3i mul(int x, int y, int z) {
        return new Point3i(this.x * x, this.y * y, this.z * z);
    }

    public Point3i mul(Point3i p) {
        return this.mul(p.x, p.y, p.z);
    }

    public Point3i mul(int i) {
        return this.mul(i, i, i);
    }

    public Point3i div(int x, int y, int z) {
        return new Point3i(this.x / x, this.y / y, this.z / z);
    }

    public Point3i div(float x, float y, float z) {
        return new Point3i((int)((float)this.x / x), (int)((float)this.y / y), (int)((float)this.z / z));
    }

    public Point3i div(Point3i p) {
        return this.div(p.x, p.y, p.z);
    }

    public Point3i div(int i) {
        return this.div(i, i, i);
    }

    public Point3i div(float f) {
        return this.div(f, f, f);
    }

    public Point3i mod(int x, int y, int z) {
        return new Point3i(this.x % x, this.y % y, this.z % z);
    }

    public Point3i mod(float x, float y, float z) {
        return new Point3i((int)((float)this.x % x), (int)((float)this.y % y), (int)((float)this.z % z));
    }

    public Point3i mod(Point3i p) {
        return this.mod(p.x, p.y, p.z);
    }

    public Point3i mod(int i) {
        return this.mod(i, i, i);
    }

    public Point3i mod(float f) {
        return this.mod(f, f, f);
    }

    public Point3i and(int i) {
        return new Point3i(this.x & i, this.y & i, this.z & i);
    }

    public Point3i abs() {
        return new Point3i(this.x < 0 ? this.x * -1 : this.x, this.y < 0 ? this.y * -1 : this.y, this.z < 0 ? this.z * -1 : this.z);
    }

    public Point3i shiftRight(int i) {
        return new Point3i(this.x >> i, this.y >> i, this.z >> i);
    }

    public Point3i shiftLeft(int i) {
        return new Point3i(this.x << i, this.y << i, this.z << i);
    }

    private Point3i shift2Right(int i) {
        return new Point3i(this.x >> i, this.y, this.z >> i);
    }

    private Point3i shift2Left(int i) {
        return new Point3i(this.x << i, this.y, this.z << i);
    }

    public boolean equals(Object other) {
        return other instanceof Point3i && ((Point3i)other).x == this.x && ((Point3i)other).y == this.y && ((Point3i)other).z == this.z;
    }

    public Point3i blockToRegion() {
        return this.shift2Right(9);
    }

    public Point3i regionToBlock() {
        return this.shift2Left(9);
    }

    public Point3i regionToChunk() {
        return this.shift2Left(5);
    }

    public Point3i blockToChunk() {
        return this.shift2Right(4);
    }

    public Point3i chunkToBlock() {
        return this.shift2Left(4);
    }

    public Point3i chunkToRegion() {
        return this.shift2Right(5);
    }

    public Point2i toPoint2i() {
        return new Point2i(this.x, this.z);
    }

    public Point3i sectionToBlock() {
        return this.shiftLeft(4);
    }

    public Point3i blockToSection() {
        return this.shiftRight(4);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        return "<" + this.x + ", " + this.y + ", " + this.z + ">";
    }

    public Point3i clone() {
        try {
            return (Point3i)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

