/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.util.point;

import java.io.Serializable;
import java.util.Objects;
import net.querz.mcaselector.util.point.Point2f;
import net.querz.mcaselector.util.point.Point3i;

public class Point2i
implements Cloneable,
Serializable {
    private int x;
    private int z;

    public Point2i() {
        this.z = 0;
        this.x = 0;
    }

    public Point2i(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public Point2i(long l) {
        this.x = (int)(l >> 32);
        this.z = (int)l;
    }

    public Point2i(int chunkIndex) {
        this.x = chunkIndex & 0x1F;
        this.z = chunkIndex >> 5;
    }

    public Point2i(short chunkIndex) {
        this.x = chunkIndex & 0x1F;
        this.z = chunkIndex >> 5;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public Point2i add(int x, int z) {
        return new Point2i(this.x + x, this.z + z);
    }

    public Point2i add(Point2i p) {
        return this.add(p.x, p.z);
    }

    public Point2i add(int i) {
        return this.add(i, i);
    }

    public Point2i sub(int x, int z) {
        return new Point2i(this.x - x, this.z - z);
    }

    public Point2i sub(Point2i p) {
        return this.sub(p.x, p.z);
    }

    public Point2i sub(int i) {
        return this.sub(i, i);
    }

    public Point2i mul(int x, int z) {
        return new Point2i(this.x * x, this.z * z);
    }

    public Point2i mul(Point2i p) {
        return this.mul(p.x, p.z);
    }

    public Point2i mul(int i) {
        return this.mul(i, i);
    }

    public Point2i div(int x, int z) {
        return new Point2i(this.x / x, this.z / z);
    }

    public Point2i div(float x, float z) {
        return new Point2i((int)((float)this.x / x), (int)((float)this.z / z));
    }

    public Point2i div(Point2i p) {
        return this.div(p.x, p.z);
    }

    public Point2i div(int i) {
        return this.div(i, i);
    }

    public Point2i div(float f) {
        return this.div(f, f);
    }

    public Point2i mod(int x, int z) {
        return new Point2i(this.x % x, this.z % z);
    }

    public Point2i mod(float x, float z) {
        return new Point2i((int)((float)this.x % x), (int)((float)this.z % z));
    }

    public Point2i mod(Point2i p) {
        return this.mod(p.x, p.z);
    }

    public Point2i mod(int i) {
        return this.mod(i, i);
    }

    public Point2i mod(float f) {
        return this.mod(f, f);
    }

    public Point2i and(int i) {
        return new Point2i(this.x & i, this.z & i);
    }

    public Point2i abs() {
        return new Point2i(this.x < 0 ? this.x * -1 : this.x, this.z < 0 ? this.z * -1 : this.z);
    }

    public Point2i shiftRight(int i) {
        return new Point2i(this.x >> i, this.z >> i);
    }

    public Point2i shiftLeft(int i) {
        return new Point2i(this.x << i, this.z << i);
    }

    public Point2f toPoint2f() {
        return new Point2f(this.x, this.z);
    }

    public Point3i toPoint3i() {
        return new Point3i(this.x, 0, this.z);
    }

    public Point3i toPoint3i(int y) {
        return new Point3i(this.x, y, this.z);
    }

    public boolean equals(Object other) {
        return other instanceof Point2i && ((Point2i)other).x == this.x && ((Point2i)other).z == this.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public String toString() {
        return "<" + this.x + ", " + this.z + ">";
    }

    public Point2i clone() {
        try {
            return (Point2i)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Point2i blockToRegion() {
        return this.shiftRight(9);
    }

    public Point2i regionToBlock() {
        return this.shiftLeft(9);
    }

    public Point2i regionToChunk() {
        return this.shiftLeft(5);
    }

    public Point2i blockToChunk() {
        return this.shiftRight(4);
    }

    public Point2i chunkToBlock() {
        return this.shiftLeft(4);
    }

    public Point2i chunkToRegion() {
        return this.shiftRight(5);
    }

    public long asLong() {
        return (long)this.x << 32 | (long)this.z & 0xFFFFFFFFL;
    }

    public Point2i asRelativeChunk() {
        return new Point2i(this.x & 0x1F, this.z & 0x1F);
    }

    public short asChunkIndex() {
        Point2i n = this.asRelativeChunk();
        return (short)(n.z << 5 | n.x & 0x1F);
    }
}

