/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.util.math;

public final class Bits {
    private static final byte[] multiplyDeBruijnBitPositionLSB = new byte[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};

    public static long setBits(long src, long dest, int from, int to) {
        return (to > 63 ? 0L : dest >>> to << to) + (src << from) + (dest & (1L << from) - 1L);
    }

    public static long bitRange(long value, int from, int to) {
        int waste = 64 - to;
        return value << waste >>> waste + from;
    }

    public static int fastNumberOfLeadingZeroes(int i) {
        int n = 25;
        if ((i <<= 24) >>> 28 == 0) {
            n += 4;
            i <<= 4;
        }
        if (i >>> 30 == 0) {
            n += 2;
            i <<= 2;
        }
        return n -= i >>> 31;
    }

    public static int getMsb(int i) {
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        i = (i >> 1) + 1;
        return i;
    }

    public static int lsbPosition(int i) {
        return multiplyDeBruijnBitPositionLSB[(i & -i) * 125613361 >> 27];
    }

    public static int msbPosition(int i) {
        int r = 0;
        while ((i >>= 1) > 0) {
            ++r;
        }
        return r;
    }
}

