/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import java.io.File;
import java.util.Collection;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import net.querz.mcaselector.text.Translation;

public class SelectWorldDialog
extends Dialog<File> {
    private final ListView<File> worlds = new ListView();
    private static final double cellHeight = 26.0;

    public SelectWorldDialog(List<File> worldDirectories, Stage primaryStage) {
        this.titleProperty().bind((ObservableValue)Translation.DIALOG_SELECT_WORLD_TITLE.getProperty());
        this.initStyle(StageStyle.UTILITY);
        this.getDialogPane().getStyleClass().add((Object)"select-world-dialog-pane");
        this.worlds.setEditable(false);
        this.worlds.setCellFactory(view -> new FileNameListCell());
        this.worlds.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.worlds.getItems().addAll(worldDirectories);
        this.worlds.getSelectionModel().selectFirst();
        this.setResultConverter(p -> p == ButtonType.OK ? (File)this.worlds.getSelectionModel().getSelectedItem() : null);
        this.getDialogPane().getStylesheets().addAll((Collection)primaryStage.getScene().getStylesheets());
        DoubleBinding padding = Bindings.createDoubleBinding(() -> this.worlds.getPadding().getTop() + this.worlds.getPadding().getBottom(), (Observable[])new Observable[]{this.worlds.paddingProperty()});
        this.worlds.prefHeightProperty().bind((ObservableValue)Bindings.min((ObservableNumberValue)Bindings.createDoubleBinding(() -> 5.0, (Observable[])new Observable[0]).multiply(26.0).add((ObservableNumberValue)padding), (ObservableNumberValue)Bindings.max((ObservableNumberValue)Bindings.size((ObservableList)this.worlds.getItems()).multiply(26.0).add((ObservableNumberValue)padding), (ObservableNumberValue)Bindings.createDoubleBinding(() -> 1.0, (Observable[])new Observable[0]).multiply(26.0).add((ObservableNumberValue)padding))));
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.getDialogPane().setContent(this.worlds);
    }

    private static class FileNameListCell
    extends ListCell<File> {
        private FileNameListCell() {
        }

        protected void updateItem(File file, boolean empty) {
            super.updateItem((Object)file, empty);
            if (empty || file == null) {
                this.setText(null);
            } else {
                this.setText(file.getName());
            }
            this.setGraphic(null);
        }
    }
}

