/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.ui.ProgressTask;
import net.querz.mcaselector.ui.UIFactory;

public class ProgressDialog
extends Stage {
    private final Label title = new Label();
    private final ProgressBar progressBar = new ProgressBar(-1.0);
    private final Label label = UIFactory.label(Translation.DIALOG_PROGRESS_RUNNING);
    private ProgressTask currentTask;
    private final VBox box = new VBox();

    public ProgressDialog(Translation title, Window primaryStage) {
        this.initStyle(StageStyle.TRANSPARENT);
        this.setResizable(false);
        this.initModality(Modality.APPLICATION_MODAL);
        this.initOwner(primaryStage);
        this.title.textProperty().bind((ObservableValue)title.getProperty());
        this.title.getStyleClass().add((Object)"progress-title");
        this.label.getStyleClass().add((Object)"progress-info");
        this.box.getStyleClass().add((Object)"progress-dialog");
        this.box.getChildren().addAll((Object[])new Node[]{this.title, this.progressBar, this.label});
        this.progressBar.prefWidthProperty().bind((ObservableValue)this.box.widthProperty());
        this.title.prefWidthProperty().bind((ObservableValue)this.box.widthProperty());
        this.label.prefWidthProperty().bind((ObservableValue)this.box.widthProperty());
        Scene scene = new Scene((Parent)this.box);
        scene.setFill((Paint)Color.TRANSPARENT);
        scene.getStylesheets().addAll((Collection)primaryStage.getScene().getStylesheets());
        scene.getStylesheets().add((Object)Objects.requireNonNull(ProgressDialog.class.getClassLoader().getResource("style/component/progress-dialog.css")).toExternalForm());
        this.setScene(scene);
    }

    public void showProgressBar(final Consumer<ProgressTask> r) {
        JobHandler.setTrimSaveData(false);
        this.currentTask = new ProgressTask(this){

            protected Void call() {
                r.accept(this);
                return null;
            }
        };
        this.progressBar.progressProperty().bind((ObservableValue)this.currentTask.progressProperty());
        this.label.textProperty().bind((ObservableValue)this.currentTask.infoProperty());
        this.currentTask.setOnFinish(() -> ((ProgressDialog)this).close());
        Thread thread = new Thread((Runnable)((Object)this.currentTask));
        thread.start();
        this.showAndWait();
        JobHandler.setTrimSaveData(true);
    }

    public void updateProgress(String status, double progress) {
        this.progressBar.setProgress(progress);
        this.label.setText(status);
    }

    protected VBox getBox() {
        return this.box;
    }

    protected ProgressTask getCurrentTask() {
        return this.currentTask;
    }
}

