/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.overlay.Overlay;
import net.querz.mcaselector.overlay.OverlayType;
import net.querz.mcaselector.overlay.overlays.InhabitedTimeOverlay;
import net.querz.mcaselector.overlay.overlays.ScriptOverlay;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.tile.TileMap;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.ui.component.CodeEditor;
import net.querz.mcaselector.ui.component.OverlayBox;
import net.querz.mcaselector.ui.component.PersistentDialogProperties;
import net.querz.mcaselector.util.property.DataProperty;

public class OverlayEditorDialog
extends Dialog<Result>
implements PersistentDialogProperties {
    private static final Image addIcon = FileHelper.getIconFromResources("img/add");
    private final List<Overlay> overlays;
    private final TabPane tabs = new TabPane();
    private final ScrollPane overlaysScrollPane = new ScrollPane();
    private final VBox overlaysList = new VBox();
    private final Label add = new Label("", (Node)new ImageView(addIcon));
    private final TileMap tileMap;
    private final DataProperty<Boolean> closedWithOK = new DataProperty<Boolean>(false);
    private static final String initScript = "import net.querz.mcaselector.io.mca.ChunkData;\nimport net.querz.nbt.*;\n\nint get(ChunkData data) {\n\t\n}";
    private static final CodeEditor codeEditor = new CodeEditor("import net.querz.mcaselector.io.mca.ChunkData;\nimport net.querz.nbt.*;\n\nint get(ChunkData data) {\n\t\n}");
    private static int lastSelectedTab;
    private final ChangeListener<Overlay> tileMapSelectedOverlayChange = (v, o, n) -> {
        if (o != n) {
            this.select((Overlay)n);
        }
    };

    public OverlayEditorDialog(Stage primaryStage, TileMap tileMap, List<Overlay> values) {
        this.overlays = values == null ? new ArrayList<Overlay>() : values;
        this.tileMap = tileMap;
        Overlay originalOverlay = tileMap.getOverlay() != null ? tileMap.getOverlay().clone() : null;
        List<Overlay> originalOverlays = tileMap.getOverlays();
        this.setResultConverter(p -> p == ButtonType.OK ? new Result(this.overlays) : null);
        this.titleProperty().bind((ObservableValue)Translation.DIALOG_EDIT_OVERLAYS_TITLE.getProperty());
        this.initModality(Modality.NONE);
        this.initStyle(StageStyle.UTILITY);
        this.getDialogPane().getStyleClass().add((Object)"overlay-dialog-pane");
        this.getDialogPane().getStylesheets().addAll((Collection)primaryStage.getScene().getStylesheets());
        this.getDialogPane().getStylesheets().add((Object)Objects.requireNonNull(OverlayEditorDialog.class.getClassLoader().getResource("style/component/overlay-editor-dialog.css")).toExternalForm());
        codeEditor.setOwner(this.getDialogPane().getScene().getWindow());
        codeEditor.setRecentFiles(ConfigProvider.GLOBAL.getRecentOverlayScripts());
        codeEditor.setSource(ConfigProvider.GLOBAL.getOverlayScript());
        codeEditor.setOnSave(f -> {
            String path = f.toString();
            for (Overlay overlay : this.overlays) {
                if (overlay.getType() != OverlayType.SCRIPT || !path.equals(overlay.getRawMultiValues())) continue;
                overlay.setMultiValuesString(path);
            }
        });
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.getDialogPane().lookupButton(ButtonType.OK).addEventFilter(ActionEvent.ACTION, e -> {
            tileMap.setOverlays(this.overlays);
            ConfigProvider.OVERLAY.setOverlays(this.overlays);
            tileMap.getWindow().getOptionBar().setEditOverlaysEnabled(true);
            tileMap.getWindow().untrackDialog(this);
            this.closedWithOK.set(true);
            this.initPersistentLocationOnClose(this);
            lastSelectedTab = this.tabs.getSelectionModel().getSelectedIndex();
        });
        this.setOnCloseRequest(e -> {
            tileMap.overlayParserProperty().removeListener(this.tileMapSelectedOverlayChange);
            if (!this.closedWithOK.get().booleanValue()) {
                tileMap.setOverlays(originalOverlays);
                tileMap.setOverlay(originalOverlay);
                tileMap.draw();
                tileMap.getWindow().getOptionBar().setEditOverlaysEnabled(true);
                tileMap.getWindow().untrackDialog(this);
                this.initPersistentLocationOnClose(this);
                lastSelectedTab = this.tabs.getSelectionModel().getSelectedIndex();
            }
        });
        this.setResizable(true);
        for (Overlay parser : this.overlays) {
            this.add(parser);
        }
        this.overlaysScrollPane.setContent((Node)this.overlaysList);
        this.add.getStyleClass().add((Object)"overlay-add-label");
        this.add.setOnMouseReleased(e -> {
            InhabitedTimeOverlay newParser = new InhabitedTimeOverlay();
            this.overlays.add(newParser);
            this.add(newParser);
            tileMap.setOverlays(this.overlays);
            tileMap.setOverlay(newParser);
            tileMap.draw();
        });
        Button createScriptOverlay = UIFactory.button(Translation.DIALOG_EDIT_OVERLAYS_CREATE_OVERLAY);
        createScriptOverlay.setOnAction(e -> {
            if (codeEditor.save(false)) {
                ScriptOverlay overlay = new ScriptOverlay();
                overlay.setRawMultiValues(codeEditor.getSource().file().toString());
                this.overlays.add(overlay);
                this.add(overlay);
                tileMap.setOverlays(this.overlays);
                tileMap.setOverlay(overlay);
                tileMap.draw();
            }
        });
        VBox presets = new VBox();
        presets.getStyleClass().add((Object)"overlay-list");
        presets.getChildren().addAll((Object[])new Node[]{this.overlaysScrollPane, this.add});
        VBox.setVgrow((Node)this.overlaysScrollPane, (Priority)Priority.ALWAYS);
        VBox script = new VBox();
        VBox.setVgrow((Node)codeEditor, (Priority)Priority.ALWAYS);
        script.getChildren().addAll((Object[])new Node[]{codeEditor, createScriptOverlay});
        Tab presetsTab = UIFactory.tab(Translation.DIALOG_EDIT_OVERLAYS_TAB_PRESETS);
        presetsTab.setContent((Node)presets);
        Tab scriptTab = UIFactory.tab(Translation.DIALOG_EDIT_OVERLAYS_TAB_SCRIPT);
        scriptTab.setContent((Node)script);
        this.tabs.getTabs().addAll((Object[])new Tab[]{presetsTab, scriptTab});
        this.getDialogPane().setContent((Node)this.tabs);
        this.getDialogPane().setOnKeyPressed(e -> {
            switch (e.getCode()) {
                case O: {
                    tileMap.nextOverlay();
                    break;
                }
                case N: {
                    tileMap.nextOverlayType();
                }
            }
        });
        this.select(tileMap.getOverlay());
        tileMap.overlayParserProperty().addListener(this.tileMapSelectedOverlayChange);
        tileMap.getWindow().getOptionBar().setEditOverlaysEnabled(false);
        tileMap.getWindow().trackDialog(this);
        this.initPersistentLocationOnOpen(this);
        Platform.runLater(() -> this.tabs.getSelectionModel().select(lastSelectedTab));
    }

    private void onTypeChange(Overlay oldValue, Overlay newValue) {
        int index = this.overlays.indexOf(oldValue);
        this.overlays.set(index, newValue);
        this.tileMap.clearOverlay();
        this.tileMap.setOverlays(this.overlays);
        this.tileMap.setOverlay(newValue);
        this.tileMap.draw();
    }

    private void onDelete(Overlay deleted) {
        int index = this.overlays.indexOf(deleted);
        this.overlays.remove(index);
        this.overlaysList.getChildren().remove(index);
        this.tileMap.setOverlays(this.overlays);
        this.tileMap.draw();
    }

    private void add(Overlay parser) {
        OverlayBox box = new OverlayBox(parser);
        box.setOnTypeChange(this::onTypeChange);
        box.setOnValuesChange(p -> {
            if (p.isActive()) {
                if (p != this.tileMap.getOverlay()) {
                    this.tileMap.setOverlays(this.overlays);
                }
                this.tileMap.setOverlay((Overlay)p);
                this.tileMap.draw();
            } else if (p == this.tileMap.getOverlay()) {
                this.tileMap.clearOverlay();
                this.tileMap.draw();
            }
        });
        box.setOnDelete(this::onDelete);
        this.overlaysList.getChildren().add((Object)box);
    }

    private void select(Overlay parser) {
        for (Node child : this.overlaysList.getChildren()) {
            OverlayBox box = (OverlayBox)child;
            box.setSelected(box.valueProperty.get().same(parser));
        }
    }

    public static class Result {
        private final List<Overlay> overlays;

        public Result(List<Overlay> overlays) {
            this.overlays = overlays;
        }

        public List<Overlay> getOverlays() {
            return this.overlays;
        }

        public String toString() {
            return Arrays.toString(this.overlays.toArray(new Overlay[0]));
        }
    }
}

