/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.querz.mcaselector.io.FileHelper;

public class NumberDialog
extends Stage {
    private static final Image clipboardIcon = FileHelper.getIconFromResources("img/clipboard");

    public NumberDialog(Stage primaryStage, long number, String title) {
        this.initStyle(StageStyle.UTILITY);
        this.setResizable(false);
        this.initModality(Modality.APPLICATION_MODAL);
        this.initOwner((Window)primaryStage);
        Label titleLabel = new Label(title);
        Label numberLabel = new Label(String.valueOf(number));
        numberLabel.getStyleClass().add((Object)"number-label");
        numberLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        ImageView icon = new ImageView(clipboardIcon);
        icon.setFitWidth(16.0);
        icon.setFitHeight(16.0);
        Button copyButton = new Button(null, (Node)icon);
        copyButton.setOnAction(e -> {
            ClipboardContent content = new ClipboardContent();
            content.putString(String.valueOf(number));
            Clipboard.getSystemClipboard().setContent((Map)content);
        });
        HBox box = new HBox(new Node[]{numberLabel, copyButton});
        box.getStyleClass().add((Object)"number-box");
        VBox contentBox = new VBox(new Node[]{titleLabel, new Separator(), box});
        contentBox.getStyleClass().add((Object)"content-box");
        StackPane pane = new StackPane(new Node[]{contentBox});
        StackPane.setAlignment((Node)contentBox, (Pos)Pos.CENTER);
        pane.getStyleClass().add((Object)"dialog-pane");
        pane.getStylesheets().addAll((Collection)primaryStage.getScene().getStylesheets());
        Scene scene = new Scene((Parent)pane);
        scene.getStylesheets().add((Object)Objects.requireNonNull(NumberDialog.class.getClassLoader().getResource("style/component/number-dialog.css")).toExternalForm());
        this.setScene(scene);
        Platform.runLater(() -> ((Label)numberLabel).requestFocus());
    }
}

