/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.ui.dialog;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.mca.Chunk;
import net.querz.mcaselector.io.mca.CompressionType;
import net.querz.mcaselector.io.mca.EntitiesChunk;
import net.querz.mcaselector.io.mca.EntitiesMCAFile;
import net.querz.mcaselector.io.mca.MCAFile;
import net.querz.mcaselector.io.mca.PoiChunk;
import net.querz.mcaselector.io.mca.PoiMCAFile;
import net.querz.mcaselector.io.mca.RegionChunk;
import net.querz.mcaselector.io.mca.RegionMCAFile;
import net.querz.mcaselector.selection.ChunkSet;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.text.Translation;
import net.querz.mcaselector.tile.TileMap;
import net.querz.mcaselector.ui.UIFactory;
import net.querz.mcaselector.ui.component.NBTTreeView;
import net.querz.mcaselector.ui.component.PersistentDialogProperties;
import net.querz.mcaselector.ui.dialog.EditArrayDialog;
import net.querz.mcaselector.ui.dialog.ErrorDialog;
import net.querz.mcaselector.ui.dialog.ProgressDialog;
import net.querz.mcaselector.ui.dialog.RequestNumberDialog;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.progress.Timer;
import net.querz.mcaselector.util.property.DataProperty;
import net.querz.nbt.ByteArrayTag;
import net.querz.nbt.ByteTag;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.DoubleTag;
import net.querz.nbt.FloatTag;
import net.querz.nbt.IntArrayTag;
import net.querz.nbt.IntTag;
import net.querz.nbt.ListTag;
import net.querz.nbt.LongArrayTag;
import net.querz.nbt.LongTag;
import net.querz.nbt.ShortTag;
import net.querz.nbt.StringTag;
import net.querz.nbt.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTEditorDialog
extends Dialog<Result>
implements PersistentDialogProperties {
    private static final Logger LOGGER = LogManager.getLogger(NBTEditorDialog.class);
    private final Label treeViewPlaceHolder = UIFactory.label(Translation.DIALOG_EDIT_NBT_PLACEHOLDER_LOADING);
    private final TabPane editors = new TabPane();
    private CompoundTag regionData;
    private CompoundTag poiData;
    private CompoundTag entitiesData;
    private final Point2i selectedChunk;

    public NBTEditorDialog(TileMap tileMap, Stage primaryStage) {
        this.titleProperty().bind((ObservableValue)Translation.DIALOG_EDIT_NBT_TITLE.getProperty());
        this.initStyle(StageStyle.UTILITY);
        this.getDialogPane().getStyleClass().add((Object)"nbt-editor-dialog-pane");
        this.setResultConverter(p -> p == ButtonType.APPLY ? new Result(this.regionData, this.poiData, this.entitiesData) : null);
        this.getDialogPane().getStylesheets().addAll((Collection)primaryStage.getScene().getStylesheets());
        this.getDialogPane().getScene().getStylesheets().addAll((Collection)primaryStage.getScene().getStylesheets());
        this.getDialogPane().getScene().getStylesheets().add((Object)Objects.requireNonNull(NBTEditorDialog.class.getClassLoader().getResource("style/component/nbt-editor-dialog.css")).toExternalForm());
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
        this.getDialogPane().lookupButton(ButtonType.APPLY).setDisable(true);
        this.selectedChunk = this.getSelectedChunk(tileMap);
        this.getDialogPane().lookupButton(ButtonType.APPLY).addEventFilter(ActionEvent.ACTION, e -> {
            Timer t = new Timer();
            DataProperty exception = new DataProperty();
            new ProgressDialog(Translation.DIALOG_PROGRESS_TITLE_SAVING_CHUNK, this.getDialogPane().getScene().getWindow()).showProgressBar(r -> {
                try {
                    r.setMax(4);
                    r.updateProgress("region/" + FileHelper.createMCAFileName(this.selectedChunk.chunkToRegion()), 1);
                    this.writeSingleChunk(new RegionMCAFile(FileHelper.createRegionMCAFilePath(this.selectedChunk.chunkToRegion())), new RegionChunk(this.selectedChunk), this.regionData);
                    r.incrementProgress("poi/" + FileHelper.createMCAFileName(this.selectedChunk.chunkToRegion()));
                    this.writeSingleChunk(new PoiMCAFile(FileHelper.createPoiMCAFilePath(this.selectedChunk.chunkToRegion())), new PoiChunk(this.selectedChunk), this.poiData);
                    r.incrementProgress("entities/" + FileHelper.createMCAFileName(this.selectedChunk.chunkToRegion()));
                    this.writeSingleChunk(new EntitiesMCAFile(FileHelper.createEntitiesMCAFilePath(this.selectedChunk.chunkToRegion())), new EntitiesChunk(this.selectedChunk), this.entitiesData);
                }
                catch (Exception ex) {
                    exception.set(ex);
                    LOGGER.warn("failed to save chunk", (Throwable)ex);
                }
                finally {
                    r.done("");
                }
            });
            LOGGER.warn("took {} to save chunk {}", (Object)t, (Object)this.selectedChunk);
            if (exception.get() != null) {
                e.consume();
                new ErrorDialog((Window)primaryStage, (Exception)exception.get());
            }
        });
        Tab regionTab = this.createEditorTab("region", primaryStage, new RegionMCAFile(FileHelper.createRegionMCAFilePath(this.selectedChunk.chunkToRegion())), d -> {
            this.regionData = d;
        });
        Tab poiTab = this.createEditorTab("poi", primaryStage, new PoiMCAFile(FileHelper.createPoiMCAFilePath(this.selectedChunk.chunkToRegion())), d -> {
            this.poiData = d;
        });
        Tab entitiesTab = this.createEditorTab("entities", primaryStage, new EntitiesMCAFile(FileHelper.createEntitiesMCAFilePath(this.selectedChunk.chunkToRegion())), d -> {
            this.entitiesData = d;
        });
        this.editors.getTabs().addAll((Object[])new Tab[]{regionTab, poiTab, entitiesTab});
        this.getDialogPane().setContent((Node)this.editors);
        this.setResizable(true);
        this.setOnCloseRequest(e -> this.initPersistentLocationOnClose(this));
        this.initPersistentLocationOnOpen(this);
        Platform.runLater(() -> ((TabPane)this.editors).requestFocus());
    }

    private Point2i getSelectedChunk(TileMap tileMap) {
        Selection selection = tileMap.getSelection();
        if (selection.size() != 1) {
            throw new RuntimeException("only one chunk can be selected, but found selection of " + selection.size() + " regions");
        }
        Point2i location = null;
        for (Long2ObjectMap.Entry<ChunkSet> entry : selection) {
            if (entry.getValue() == null) {
                throw new RuntimeException("only one chunk can be selected, but found entire region " + String.valueOf(new Point2i(entry.getLongKey())) + " selected");
            }
            if (((ChunkSet)entry.getValue()).size() != 1) {
                throw new RuntimeException("only one chunk can be selected, but found selection of " + ((ChunkSet)entry.getValue()).size() + " chunks");
            }
            IntIterator intIterator = ((ChunkSet)entry.getValue()).iterator();
            while (intIterator.hasNext()) {
                int p = (Integer)intIterator.next();
                location = new Point2i(p).add(new Point2i(entry.getLongKey()).regionToChunk());
            }
        }
        if (location == null) {
            throw new RuntimeException("no selected chunk found");
        }
        return location;
    }

    private <T extends Chunk> Tab createEditorTab(String title, Stage primaryStage, MCAFile<T> mcaFile, Consumer<CompoundTag> consumer) {
        NBTTreeView nbtTreeView = new NBTTreeView();
        nbtTreeView.setArrayEditor(a -> new EditArrayDialog(a, primaryStage).showAndWait());
        ImageView deleteIcon = new ImageView(FileHelper.getIconFromResources("img/delete"));
        Label delete = new Label("", (Node)deleteIcon);
        delete.getStyleClass().add((Object)"nbt-editor-delete-tag-label");
        delete.setDisable(true);
        deleteIcon.setPreserveRatio(true);
        delete.setOnMouseEntered(e -> {
            if (!delete.isDisabled()) {
                deleteIcon.setFitWidth(24.0);
            }
        });
        delete.setOnMouseExited(e -> {
            if (!delete.isDisabled()) {
                deleteIcon.setFitWidth(22.0);
            }
        });
        delete.disableProperty().addListener((i, o, n) -> {
            if (o.booleanValue() != n.booleanValue()) {
                if (n.booleanValue()) {
                    delete.getStyleClass().remove((Object)"nbt-editor-delete-tag-label-enabled");
                } else {
                    delete.getStyleClass().add((Object)"nbt-editor-delete-tag-label-enabled");
                }
            }
        });
        LinkedHashMap<Tag.Type, Label> addTagLabels = new LinkedHashMap<Tag.Type, Label>();
        delete.setOnMouseClicked(e -> {
            if (((TreeItem)nbtTreeView.getSelectionModel().getSelectedItem()).getParent() == null) {
                consumer.accept(null);
            }
            nbtTreeView.deleteSelectedItem();
        });
        nbtTreeView.setOnSelectionChanged(b -> {
            delete.setDisable(b.booleanValue());
            this.enableAddTagLabels(nbtTreeView.getPossibleChildTagTypesFromSelected(), addTagLabels);
        });
        BorderPane treeViewHolder = new BorderPane();
        treeViewHolder.getStyleClass().add((Object)"nbt-tree-view-holder");
        treeViewHolder.setCenter((Node)this.treeViewPlaceHolder);
        this.initAddTagLabels(nbtTreeView, primaryStage, addTagLabels, treeViewHolder, consumer);
        HBox options = new HBox();
        options.getStyleClass().add((Object)"nbt-editor-options");
        options.getChildren().add((Object)delete);
        options.getChildren().addAll(addTagLabels.values());
        VBox box = new VBox();
        VBox.setVgrow((Node)treeViewHolder, (Priority)Priority.ALWAYS);
        box.getChildren().addAll((Object[])new Node[]{treeViewHolder, options});
        Tab tab = new Tab(title, (Node)box);
        tab.setClosable(false);
        this.readSingleChunkAsync(mcaFile, nbtTreeView, treeViewHolder, addTagLabels, consumer);
        return tab;
    }

    private void enableAddTagLabels(Tag.Type[] types, Map<Tag.Type, Label> addTagLabels) {
        for (Map.Entry<Tag.Type, Label> label : addTagLabels.entrySet()) {
            label.getValue().setDisable(true);
        }
        if (types != null) {
            for (Tag.Type type : types) {
                addTagLabels.get((Object)type).setDisable(false);
            }
        }
    }

    private void initAddTagLabels(NBTTreeView nbtTreeView, Stage primaryStage, Map<Tag.Type, Label> addTagLabels, BorderPane treeViewHolder, Consumer<CompoundTag> consumer) {
        addTagLabels.put(Tag.Type.BYTE, this.iconLabel(NBTTreeView.NBTTreeCell.getIcon(Tag.Type.BYTE), () -> ByteTag.valueOf((byte)0), nbtTreeView, treeViewHolder, consumer));
        addTagLabels.put(Tag.Type.SHORT, this.iconLabel(NBTTreeView.NBTTreeCell.getIcon(Tag.Type.SHORT), () -> ShortTag.valueOf((short)0), nbtTreeView, treeViewHolder, consumer));
        addTagLabels.put(Tag.Type.INT, this.iconLabel(NBTTreeView.NBTTreeCell.getIcon(Tag.Type.INT), () -> IntTag.valueOf(0), nbtTreeView, treeViewHolder, consumer));
        addTagLabels.put(Tag.Type.LONG, this.iconLabel(NBTTreeView.NBTTreeCell.getIcon(Tag.Type.LONG), () -> LongTag.valueOf(0L), nbtTreeView, treeViewHolder, consumer));
        addTagLabels.put(Tag.Type.FLOAT, this.iconLabel(NBTTreeView.NBTTreeCell.getIcon(Tag.Type.FLOAT), () -> FloatTag.valueOf(0.0f), nbtTreeView, treeViewHolder, consumer));
        addTagLabels.put(Tag.Type.DOUBLE, this.iconLabel(NBTTreeView.NBTTreeCell.getIcon(Tag.Type.DOUBLE), () -> DoubleTag.valueOf(0.0), nbtTreeView, treeViewHolder, consumer));
        addTagLabels.put(Tag.Type.STRING, this.iconLabel(NBTTreeView.NBTTreeCell.getIcon(Tag.Type.STRING), () -> StringTag.valueOf(""), nbtTreeView, treeViewHolder, consumer));
        addTagLabels.put(Tag.Type.LIST, this.iconLabel(NBTTreeView.NBTTreeCell.getIcon(Tag.Type.LIST), ListTag::new, nbtTreeView, treeViewHolder, consumer));
        addTagLabels.put(Tag.Type.COMPOUND, this.iconLabel(NBTTreeView.NBTTreeCell.getIcon(Tag.Type.COMPOUND), CompoundTag::new, nbtTreeView, treeViewHolder, consumer));
        addTagLabels.put(Tag.Type.BYTE_ARRAY, this.iconLabel(NBTTreeView.NBTTreeCell.getIcon(Tag.Type.BYTE_ARRAY), () -> {
            Long l = new RequestNumberDialog(primaryStage, Translation.DIALOG_REQUEST_NUMBER_TITLE_ARRAY_LENGTH, 0L, Integer.MAX_VALUE).showAndWait().orElse(null);
            return l == null ? null : new ByteArrayTag(new byte[l.intValue()]);
        }, nbtTreeView, treeViewHolder, consumer));
        addTagLabels.put(Tag.Type.INT_ARRAY, this.iconLabel(NBTTreeView.NBTTreeCell.getIcon(Tag.Type.INT_ARRAY), () -> {
            Long l = new RequestNumberDialog(primaryStage, Translation.DIALOG_REQUEST_NUMBER_TITLE_ARRAY_LENGTH, 0L, Integer.MAX_VALUE).showAndWait().orElse(null);
            return l == null ? null : new IntArrayTag(new int[l.intValue()]);
        }, nbtTreeView, treeViewHolder, consumer));
        addTagLabels.put(Tag.Type.LONG_ARRAY, this.iconLabel(NBTTreeView.NBTTreeCell.getIcon(Tag.Type.LONG_ARRAY), () -> {
            Long l = new RequestNumberDialog(primaryStage, Translation.DIALOG_REQUEST_NUMBER_TITLE_ARRAY_LENGTH, 0L, Integer.MAX_VALUE).showAndWait().orElse(null);
            return l == null ? null : new LongArrayTag(new long[l.intValue()]);
        }, nbtTreeView, treeViewHolder, consumer));
        this.enableAddTagLabels(null, addTagLabels);
    }

    private Label iconLabel(Image img, Supplier<Tag> tagSupplier, NBTTreeView nbtTreeView, BorderPane treeViewHolder, Consumer<CompoundTag> consumer) {
        ImageView icon = new ImageView(img);
        Label label = new Label("", (Node)icon);
        icon.setPreserveRatio(true);
        label.setOnMouseEntered(e -> icon.setFitWidth(18.0));
        label.setOnMouseExited(e -> icon.setFitWidth(16.0));
        label.getStyleClass().add((Object)"nbt-editor-add-tag-label");
        label.setOnMouseClicked(e -> {
            treeViewHolder.setCenter((Node)nbtTreeView);
            Tag newTag = (Tag)tagSupplier.get();
            if (newTag == null) {
                return;
            }
            if (nbtTreeView.addItemAtSelected("Unknown", newTag, true) && ((NBTTreeView.NamedTag)nbtTreeView.getRoot().getValue()).getRef() == newTag) {
                consumer.accept((CompoundTag)newTag);
            }
        });
        return label;
    }

    private <T extends Chunk> void readSingleChunkAsync(MCAFile<T> mcaFile, NBTTreeView treeView, BorderPane treeViewHolder, Map<Tag.Type, Label> addTagLabels, Consumer<CompoundTag> consumer) {
        new Thread(() -> {
            LOGGER.debug("attempting to read single chunk from file: {}", (Object)this.selectedChunk);
            if (mcaFile.getFile().exists()) {
                try {
                    Object chunkData = mcaFile.loadSingleChunk(this.selectedChunk);
                    if (chunkData == null || ((Chunk)chunkData).getData() == null) {
                        LOGGER.debug("no chunk data found for: {}", (Object)this.selectedChunk);
                        this.enableAddTagLabels(new Tag.Type[]{Tag.Type.COMPOUND}, addTagLabels);
                        Platform.runLater(() -> treeViewHolder.setCenter((Node)UIFactory.label(Translation.DIALOG_EDIT_NBT_PLACEHOLDER_NO_CHUNK_DATA)));
                        return;
                    }
                    consumer.accept(((Chunk)chunkData).getData());
                    Platform.runLater(() -> {
                        treeView.load(chunkData.getData());
                        treeViewHolder.setCenter((Node)treeView);
                        treeView.getRoot().setExpanded(true);
                        this.getDialogPane().lookupButton(ButtonType.APPLY).setDisable(false);
                    });
                }
                catch (IOException ex) {
                    LOGGER.warn("failed to load chunk from file {}", (Object)mcaFile.getFile(), (Object)ex);
                }
            } else {
                this.enableAddTagLabels(new Tag.Type[]{Tag.Type.COMPOUND}, addTagLabels);
                Platform.runLater(() -> treeViewHolder.setCenter((Node)UIFactory.label(Translation.DIALOG_EDIT_NBT_PLACEHOLDER_NO_REGION_FILE)));
            }
        }).start();
    }

    private <T extends Chunk> void writeSingleChunk(MCAFile<T> mcaFile, T chunk, CompoundTag chunkData) throws IOException {
        if (chunkData != null) {
            chunk.setData(chunkData);
            chunk.setCompressionType(CompressionType.ZLIB);
        } else {
            chunk = null;
        }
        try {
            mcaFile.saveSingleChunk(this.selectedChunk, chunk);
            LOGGER.debug("saved single chunk to {}", (Object)mcaFile.getFile());
        }
        catch (IOException ex) {
            LOGGER.warn("failed to save single chunk to {}", (Object)mcaFile.getFile(), (Object)ex);
            throw ex;
        }
    }

    public static class Result {
        private final CompoundTag regionData;
        private final CompoundTag poiData;
        private final CompoundTag entitiesData;

        private Result(CompoundTag regionData, CompoundTag poiData, CompoundTag entitiesData) {
            this.regionData = regionData;
            this.poiData = poiData;
            this.entitiesData = entitiesData;
        }

        public CompoundTag getRegionData() {
            return this.regionData;
        }

        public CompoundTag getPoiData() {
            return this.poiData;
        }

        public CompoundTag getEntitiesData() {
            return this.entitiesData;
        }
    }
}

